<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<title><?php echo $title; ?></title>
	<?php echo Asset::css('bootstrap.css'); ?>
	<style>
		#logo{
			display: block;
			background-image: url(data:image/png;base64,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);
			width: 179px;
			height: 45px;
			position: relative;
			top: 15px;
		}
		header{
			background-image: url(data:image/jpeg;base64,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);
			height: 75px;
			width: 100%;
			margin-bottom: 40px;
		}
		a{
			color: #883ced;
		}
		a:hover{
			color: #af4cf0;
		}
		.btn.primary{color:#ffffff!important;background-color:#883ced;background-repeat:repeat-x;background-image:-khtml-gradient(linear, left top, left bottom, from(#fd6ef7), to(#883ced));background-image:-moz-linear-gradient(top, #fd6ef7, #883ced);background-image:-ms-linear-gradient(top, #fd6ef7, #883ced);background-image:-webkit-gradient(linear, left top, left bottom, color-stop(0%, #fd6ef7), color-stop(100%, #883ced));background-image:-webkit-linear-gradient(top, #fd6ef7, #883ced);background-image:-o-linear-gradient(top, #fd6ef7, #883ced);background-image:linear-gradient(top, #fd6ef7, #883ced);filter:progid:DXImageTransform.Microsoft.gradient(startColorstr='#fd6ef7', endColorstr='#883ced', GradientType=0);text-shadow:0 -1px 0 rgba(0, 0, 0, 0.25);border-color:#883ced #883ced #003f81;border-color:rgba(0, 0, 0, 0.1) rgba(0, 0, 0, 0.1) rgba(0, 0, 0, 0.25);}
		body { margin: 0px 0px 40px 0px; }
	</style>
</head>
<body>
	<header>
		<div class="container">
			<div id="logo"></div>
		</div>
	</header>
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<h1><?php echo $title; ?> <small>We can't find that!</small></h1>
				<hr>
				<p>The controller generating this page is found at <code>APPPATH/classes/controller/welcome.php</code>.</p>
				<p>This view is located at <code>APPPATH/views/welcome/404.php</code>.</p>
			</div>
		</div>
		<footer>
			<p class="pull-right">Page rendered in {exec_time}s using {mem_usage}mb of memory.</p>
			<p>
				<a href="https://fuelphp.com">FuelPHP</a> is released under the MIT license.<br>
				<small>Version: <?php echo Fuel::VERSION; ?></small>
			</p>
		</footer>
	</div>
</body>
</html>
