
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `feedon`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]feed`
--

CREATE TABLE `[[dbprefix]]feed` (
  `feed_id` int(11) NOT NULL AUTO_INCREMENT,
  `feed_url` text NOT NULL,
  `feed_title` text NOT NULL,
  `feed_link` text NOT NULL,
  `feed_description` text NOT NULL,
  `feed_image` text,
  `feed_image_cache_date` int(11) DEFAULT '0',
  `feed_cache_date` int(11) DEFAULT '0',
  `feed_cache_attempt_date` int(11) DEFAULT '0',
  `feed_cache` text,
  PRIMARY KEY (`feed_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]feed`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]item`
--

CREATE TABLE `[[dbprefix]]item` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `feed_id` int(11) NOT NULL DEFAULT '0',
  `item_guid` text NOT NULL,
  `item_link` text NOT NULL,
  `item_cached` int(11) NOT NULL DEFAULT '0',
  `item_published` int(11) NOT NULL DEFAULT '0',
  `item_updated` int(11) NOT NULL DEFAULT '0',
  `item_title` text NOT NULL,
  `item_content` text NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `feed_id` (`feed_id`),
  KEY `item_guid` (`item_guid`(255)),
  KEY `feed_id_item_cached` (`feed_id`,`item_cached`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `[[dbprefix]]item`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]item_tag`
--

CREATE TABLE `[[dbprefix]]item_tag` (
  `user_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL DEFAULT '0',
  `tag_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`item_id`,`tag_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `[[dbprefix]]item_tag`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]subscription`
--

CREATE TABLE `[[dbprefix]]subscription` (
  `feed_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `subscription_prefs` text,
  PRIMARY KEY (`feed_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `[[dbprefix]]subscription`
--


-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tag`
--

CREATE TABLE `[[dbprefix]]tag` (
  `tag_id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_name` char(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`tag_id`),
  UNIQUE KEY `tag_name` (`tag_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]tag`
--

INSERT INTO `[[dbprefix]]tag` VALUES(1, 'unread');
INSERT INTO `[[dbprefix]]tag` VALUES(2, 'star');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user`
--

CREATE TABLE `[[dbprefix]]user` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(100) NOT NULL DEFAULT '',
  `user_password_hash` varchar(32) NOT NULL DEFAULT '',
  `user_level` enum('user','admin') NOT NULL DEFAULT 'user',
  `user_prefs` text,
  PRIMARY KEY (`user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]user`
--

INSERT INTO `[[dbprefix]]user` VALUES(1, 'admin', '[[admin_pass]]', 'admin', NULL);
