<?php
/*
*                 eyeos - The Open Source Cloud's Web Desktop
*                               Version 2.0
*                   Copyright (C) 2007 - 2010 eyeos Team 
* 
* This program is free software; you can redistribute it and/or modify it under
* the terms of the GNU Affero General Public License version 3 as published by the
* Free Software Foundation.
* 
* This program is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
* FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
* details.
* 
* You should have received a copy of the GNU Affero General Public License
* version 3 along with this program in the file "LICENSE".  If not, see 
* <http://www.gnu.org/licenses/agpl-3.0.txt>.
* 
* See www.eyeos.org for more details. All requests should be sent to licensing@eyeos.org
* 
* The interactive user interfaces in modified source and object code versions
* of this program must display Appropriate Legal Notices, as required under
* Section 5 of the GNU Affero General Public License version 3.
* 
* In accordance with Section 7(b) of the GNU Affero General Public License version 3,
* these Appropriate Legal Notices must retain the display of the "Powered by
* eyeos" logo and retain the original copyright notice. If the display of the 
* logo is not reasonably feasible for technical reasons, the Appropriate Legal Notices
* must display the words "Powered by eyeos" and retain the original copyright notice. 
*/

/**
 * 
 * @package kernel-services
 * @subpackage Meta
 */
class EyeosAppsXMLMetaHandler implements IMetaDataHandler {
	protected static $Instance;
	
	
	protected function __construct() {}
	
	public static function getInstance() {
		if (self::$Instance === null) {
			$class = __CLASS__;
			self::$Instance = new $class();
		}
		return self::$Instance;
	}
	
	/**
	 * @param mixed $object
	 * @param String $params
	 * @return boolean
	 * @throws EyeException
	 * @throws EyeErrorException
	 */
	public function deleteMeta($object, $params) {
		throw new EyeUnsupportedOperationException(__METHOD__);
	}
	
	/**
	 * @param mixed $object
	 * @param String $params
	 * @return IMetaData
	 * @throws EyeException
	 * @throws EyeErrorException
	 */
	public function retrieveMeta($object, $params) {
		if (!$object instanceof EyeosApplicationDescriptor) {
			throw new EyeInvalidArgumentException('$object must be an EyeosApplicationDescriptor.');
		}
		$filepath = $object->getPath() . '/info.xml';
		
		$provider = new SimpleXMLMetaProvider((string) $params, array(
			SimpleXMLMetaProvider::PARAM_FILEPATH => $filepath
		));
		$meta = $provider->retrieveMeta(null);
		
		// no meta found (info.xml does not exist), generate default one
		if ($meta === null) {
			$meta = MetaManager::getInstance()->getNewMetaDataInstance($object);
			$meta->setAll(array(
				'eyeos.application.name' => $object->getName(),
				'eyeos.application.author' => '<Unknown>',
				'eyeos.application.version' => '<Unknown>',
				'eyeos.application.description' => 'This is an autogenerated default metadata content because no file named "info.xml" can be found in the application\'s directory.',
				'eyeos.application.license' => '<Unknown>'
			));
		}
		if ($meta->get('eyeos.application.systemParameters') === null) {
			$meta->set('eyeos.application.systemParameters', array(
				'listable' => 'true',
				'owner' => 'root',
				'group' => 'users',
				'permissions' => '---x--x--x',
				'anonymous' => 'false',
				'suid' => 'false'
			));
		}
		return $meta;
	}
	
	/**
	 * @param mixed $object
	 * @param IMetaData $metaData
	 * @param String $params
	 * @throws EyeException
	 * @throws EyeErrorException
	 */
	public function storeMeta($object, IMetaData $metaData = null, $params) {
		if (!$object instanceof EyeosApplicationDescriptor) {
			throw new EyeInvalidArgumentException('$object must be an EyeosApplicationDescriptor.');
		}
		
		//{
		//	TODO: Permission checks here
		//}
		
		$filepath = $object->getPath() . '/info.xml';
		
		$provider = new SimpleXMLMetaProvider((string) $params, array(
			SimpleXMLMetaProvider::PARAM_FILEPATH => $filepath,
			SimpleXMLMetaProvider::PARAM_FORMATOUTPUT => true
		));
		$meta = $provider->storeMeta(null, $metaData);
	}
	
	/**
	 * @param mixed $object
	 * @param mixed $changes
	 * @param String $params
	 * @return boolean
	 * @throws EyeException
	 */
	public function updateMeta($object, $changes, $params) {
		throw new EyeNotImplementedException(__METHOD__);
	}
}

?>
