(function(){

if (!window.qx) window.qx = {};

qx.$$start = new Date();
  
if (!window.qxsettings) qxsettings = {};
var settings = {"qx.application":"eyeos.Application","qx.theme":"aristo.Aristo"};
for (var k in settings) qxsettings[k] = settings[k];

if (!window.qxvariants) qxvariants = {};
var variants = {"qx.debug":"off"};
for (var k in variants) qxvariants[k] = variants[k];

if (!qx.$$libraries) qx.$$libraries = {};
var libinfo = {"__out__":{"sourceUri":"script"},"aristo":{"resourceUri":"resource","sourceUri":"script","version":"trunk"},"qx":{"resourceUri":"resource","sourceUri":"script","version":"1.2.2"}};
for (var k in libinfo) qx.$$libraries[k] = libinfo[k];

qx.$$resources = {};
qx.$$translations = {};
qx.$$locales = {};
qx.$$packageData = {};

qx.$$loader = {
  parts : {"boot":[0]},
  uris : [["__out__:qx.js"]],
  urisBefore : [],
  packageHashes : {"0":"274db7a689a4"},
  boot : "boot",
  closureParts : {},
  bootIsInline : true,
  addNoCacheParam : true,
  
  decodeUris : function(compressedUris)
  {
    var libs = qx.$$libraries;
    var uris = [];
    for (var i=0; i<compressedUris.length; i++)
    {
      var uri = compressedUris[i].split(":");
      var euri;
      if (uri.length==2 && uri[0] in libs) {
        var prefix = libs[uri[0]].sourceUri;
        euri = prefix + "/" + uri[1];
      } else {
        euri = compressedUris[i];
      }
      if (qx.$$loader.addNoCacheParam) {
        euri += "?nocache=" + Math.random();
      }
      
      uris.push(euri);
    }
    return uris;      
  }
};  

function loadScript(uri, callback) {
  var elem = document.createElement("script");
  elem.charset = "utf-8";
  elem.src = uri;
  elem.onreadystatechange = elem.onload = function()
  {
    if (!this.readyState || this.readyState == "loaded" || this.readyState == "complete")
    {
      elem.onreadystatechange = elem.onload = null;
      callback();
    }
  };
  var head = document.getElementsByTagName("head")[0];
  head.appendChild(elem);
}

var isWebkit = /AppleWebKit\/([^ ]+)/.test(navigator.userAgent);

function loadScriptList(list, callback) {
  if (list.length == 0) {
    callback();
    return;
  }
  loadScript(list.shift(), function() {
    if (isWebkit) {
      // force asynchronous load
      // Safari fails with an "maximum recursion depth exceeded" error if it is
      // called sync.      
      window.setTimeout(function() {
        loadScriptList(list, callback);
      }, 0);
    } else {
      loadScriptList(list, callback);
    }
  });
}

var fireContentLoadedEvent = function() {
  qx.$$domReady = true;
  document.removeEventListener('DOMContentLoaded', fireContentLoadedEvent, false);
};
if (document.addEventListener) {
  document.addEventListener('DOMContentLoaded', fireContentLoadedEvent, false);
}

qx.$$loader.importPackageData = function (dataMap) {
  if (dataMap["resources"]){
    var resMap = dataMap["resources"];
    for (var k in resMap) qx.$$resources[k] = resMap[k];
  }
  if (dataMap["locales"]){
    var locMap = dataMap["locales"];
    var qxlocs = qx.$$locales;
    for (var lang in locMap){
      if (!qxlocs[lang]) qxlocs[lang] = locMap[lang];
      else 
        for (var k in locMap[lang]) qxlocs[lang][k] = locMap[lang][k];
    }
  }
  if (dataMap["translations"]){
    var trMap   = dataMap["translations"];
    var qxtrans = qx.$$translations;
    for (var lang in trMap){
      if (!qxtrans[lang]) qxtrans[lang] = trMap[lang];
      else 
        for (var k in trMap[lang]) qxtrans[lang][k] = trMap[lang][k];
    }
  }
}

qx.$$loader.signalStartup = function () 
{
  qx.$$loader.scriptLoaded = true;
  if (window.qx && qx.event && qx.event.handler && qx.event.handler.Application) {
    qx.event.handler.Application.onScriptLoaded();
    qx.$$loader.applicationHandlerReady = true; 
  } else {
    qx.$$loader.applicationHandlerReady = false;
  }
}

qx.$$loader.init = function(){
  var l=qx.$$loader;
  if (l.urisBefore.length>0){
    loadScriptList(l.urisBefore, function(){
      l.initUris();
    });
  } else {
    l.initUris();
  }
}

qx.$$loader.initUris = function(){
  var l=qx.$$loader;
  var bootPackageHash=l.packageHashes[l.parts[l.boot][0]];
  if (l.bootIsInline){
    l.importPackageData(qx.$$packageData[bootPackageHash]);
    l.signalStartup();
  } else {
    loadScriptList(l.decodeUris(l.uris[l.parts[l.boot]]), function(){
      // Opera needs this extra time to parse the scripts
      window.setTimeout(function(){
        l.importPackageData(qx.$$packageData[bootPackageHash] || {});
        l.signalStartup();
      }, 0);
    });
  }
}
})();

qx.$$packageData['274db7a689a4']={"locales":{"C":{"alternateQuotationEnd":"’","alternateQuotationStart":"‘","cldr_am":"AM","cldr_date_format_full":"EEEE, MMMM d, y","cldr_date_format_long":"MMMM d, y","cldr_date_format_medium":"MMM d, y","cldr_date_format_short":"M/d/yy","cldr_date_time_format_EEEd":"d EEE","cldr_date_time_format_Hm":"H:mm","cldr_date_time_format_Hms":"H:mm:ss","cldr_date_time_format_M":"L","cldr_date_time_format_MEd":"E, M/d","cldr_date_time_format_MMM":"LLL","cldr_date_time_format_MMMEd":"E, MMM d","cldr_date_time_format_MMMMEd":"E, MMMM d","cldr_date_time_format_MMMMd":"MMMM d","cldr_date_time_format_MMMd":"MMM d","cldr_date_time_format_Md":"M/d","cldr_date_time_format_d":"d","cldr_date_time_format_hm":"h:mm a","cldr_date_time_format_ms":"mm:ss","cldr_date_time_format_y":"y","cldr_date_time_format_yM":"M/yyyy","cldr_date_time_format_yMEd":"EEE, M/d/yyyy","cldr_date_time_format_yMMM":"MMM y","cldr_date_time_format_yMMMEd":"EEE, MMM d, y","cldr_date_time_format_yMMMM":"MMMM y","cldr_date_time_format_yQ":"Q yyyy","cldr_date_time_format_yQQQ":"QQQ y","cldr_day_format_abbreviated_fri":"Fri","cldr_day_format_abbreviated_mon":"Mon","cldr_day_format_abbreviated_sat":"Sat","cldr_day_format_abbreviated_sun":"Sun","cldr_day_format_abbreviated_thu":"Thu","cldr_day_format_abbreviated_tue":"Tue","cldr_day_format_abbreviated_wed":"Wed","cldr_day_format_narrow_fri":"F","cldr_day_format_narrow_mon":"M","cldr_day_format_narrow_sat":"S","cldr_day_format_narrow_sun":"S","cldr_day_format_narrow_thu":"T","cldr_day_format_narrow_tue":"T","cldr_day_format_narrow_wed":"W","cldr_day_format_wide_fri":"Friday","cldr_day_format_wide_mon":"Monday","cldr_day_format_wide_sat":"Saturday","cldr_day_format_wide_sun":"Sunday","cldr_day_format_wide_thu":"Thursday","cldr_day_format_wide_tue":"Tuesday","cldr_day_format_wide_wed":"Wednesday","cldr_day_stand-alone_abbreviated_fri":"Fri","cldr_day_stand-alone_abbreviated_mon":"Mon","cldr_day_stand-alone_abbreviated_sat":"Sat","cldr_day_stand-alone_abbreviated_sun":"Sun","cldr_day_stand-alone_abbreviated_thu":"Thu","cldr_day_stand-alone_abbreviated_tue":"Tue","cldr_day_stand-alone_abbreviated_wed":"Wed","cldr_day_stand-alone_narrow_fri":"F","cldr_day_stand-alone_narrow_mon":"M","cldr_day_stand-alone_narrow_sat":"S","cldr_day_stand-alone_narrow_sun":"S","cldr_day_stand-alone_narrow_thu":"T","cldr_day_stand-alone_narrow_tue":"T","cldr_day_stand-alone_narrow_wed":"W","cldr_day_stand-alone_wide_fri":"Friday","cldr_day_stand-alone_wide_mon":"Monday","cldr_day_stand-alone_wide_sat":"Saturday","cldr_day_stand-alone_wide_sun":"Sunday","cldr_day_stand-alone_wide_thu":"Thursday","cldr_day_stand-alone_wide_tue":"Tuesday","cldr_day_stand-alone_wide_wed":"Wednesday","cldr_month_format_abbreviated_1":"Jan","cldr_month_format_abbreviated_10":"Oct","cldr_month_format_abbreviated_11":"Nov","cldr_month_format_abbreviated_12":"Dec","cldr_month_format_abbreviated_2":"Feb","cldr_month_format_abbreviated_3":"Mar","cldr_month_format_abbreviated_4":"Apr","cldr_month_format_abbreviated_5":"May","cldr_month_format_abbreviated_6":"Jun","cldr_month_format_abbreviated_7":"Jul","cldr_month_format_abbreviated_8":"Aug","cldr_month_format_abbreviated_9":"Sep","cldr_month_format_wide_1":"January","cldr_month_format_wide_10":"October","cldr_month_format_wide_11":"November","cldr_month_format_wide_12":"December","cldr_month_format_wide_2":"February","cldr_month_format_wide_3":"March","cldr_month_format_wide_4":"April","cldr_month_format_wide_5":"May","cldr_month_format_wide_6":"June","cldr_month_format_wide_7":"July","cldr_month_format_wide_8":"August","cldr_month_format_wide_9":"September","cldr_month_stand-alone_narrow_1":"J","cldr_month_stand-alone_narrow_10":"O","cldr_month_stand-alone_narrow_11":"N","cldr_month_stand-alone_narrow_12":"D","cldr_month_stand-alone_narrow_2":"F","cldr_month_stand-alone_narrow_3":"M","cldr_month_stand-alone_narrow_4":"A","cldr_month_stand-alone_narrow_5":"M","cldr_month_stand-alone_narrow_6":"J","cldr_month_stand-alone_narrow_7":"J","cldr_month_stand-alone_narrow_8":"A","cldr_month_stand-alone_narrow_9":"S","cldr_number_decimal_separator":".","cldr_number_group_separator":",","cldr_number_percent_format":"#,##0%","cldr_pm":"PM","cldr_time_format_full":"h:mm:ss a zzzz","cldr_time_format_long":"h:mm:ss a z","cldr_time_format_medium":"h:mm:ss a","cldr_time_format_short":"h:mm a","quotationEnd":"”","quotationStart":"“"},"de":{"alternateQuotationEnd":"‘","alternateQuotationStart":"‚","cldr_am":"vorm.","cldr_date_format_full":"EEEE, d. MMMM y","cldr_date_format_long":"d. MMMM y","cldr_date_format_medium":"dd.MM.yyyy","cldr_date_format_short":"dd.MM.yy","cldr_date_time_format_EEEd":"d. EEE","cldr_date_time_format_Ed":"E d.","cldr_date_time_format_H":"H","cldr_date_time_format_HHmm":"HH:mm","cldr_date_time_format_HHmmss":"HH:mm:ss","cldr_date_time_format_Hm":"H:mm","cldr_date_time_format_M":"L","cldr_date_time_format_MEd":"E, d.M.","cldr_date_time_format_MMM":"LLL","cldr_date_time_format_MMMEd":"E d. MMM","cldr_date_time_format_MMMMEd":"E d. MMMM","cldr_date_time_format_MMMMd":"d. MMMM","cldr_date_time_format_MMMMdd":"dd. MMMM","cldr_date_time_format_MMMd":"d. MMM","cldr_date_time_format_MMd":"d.MM.","cldr_date_time_format_MMdd":"dd.MM.","cldr_date_time_format_Md":"d.M.","cldr_date_time_format_d":"d","cldr_date_time_format_mmss":"mm:ss","cldr_date_time_format_ms":"mm:ss","cldr_date_time_format_y":"y","cldr_date_time_format_yM":"yyyy-M","cldr_date_time_format_yMEd":"EEE, yyyy-M-d","cldr_date_time_format_yMMM":"MMM y","cldr_date_time_format_yMMMEd":"EEE, d. MMM y","cldr_date_time_format_yMMMM":"MMMM y","cldr_date_time_format_yQ":"Q yyyy","cldr_date_time_format_yQQQ":"QQQ y","cldr_date_time_format_yyMM":"MM.yy","cldr_date_time_format_yyMMM":"MMM yy","cldr_date_time_format_yyMMdd":"dd.MM.yy","cldr_date_time_format_yyQ":"Q yy","cldr_date_time_format_yyQQQQ":"QQQQ yy","cldr_date_time_format_yyyy":"y","cldr_date_time_format_yyyyMMMM":"MMMM y","cldr_day_format_abbreviated_fri":"Fr.","cldr_day_format_abbreviated_mon":"Mo.","cldr_day_format_abbreviated_sat":"Sa.","cldr_day_format_abbreviated_sun":"So.","cldr_day_format_abbreviated_thu":"Do.","cldr_day_format_abbreviated_tue":"Di.","cldr_day_format_abbreviated_wed":"Mi.","cldr_day_format_narrow_fri":"F","cldr_day_format_narrow_mon":"M","cldr_day_format_narrow_sat":"S","cldr_day_format_narrow_sun":"S","cldr_day_format_narrow_thu":"D","cldr_day_format_narrow_tue":"D","cldr_day_format_narrow_wed":"M","cldr_day_format_wide_fri":"Freitag","cldr_day_format_wide_mon":"Montag","cldr_day_format_wide_sat":"Samstag","cldr_day_format_wide_sun":"Sonntag","cldr_day_format_wide_thu":"Donnerstag","cldr_day_format_wide_tue":"Dienstag","cldr_day_format_wide_wed":"Mittwoch","cldr_day_stand-alone_abbreviated_fri":"Fr.","cldr_day_stand-alone_abbreviated_mon":"Mo.","cldr_day_stand-alone_abbreviated_sat":"Sa.","cldr_day_stand-alone_abbreviated_sun":"So.","cldr_day_stand-alone_abbreviated_thu":"Do.","cldr_day_stand-alone_abbreviated_tue":"Di.","cldr_day_stand-alone_abbreviated_wed":"Mi.","cldr_day_stand-alone_narrow_fri":"F","cldr_day_stand-alone_narrow_mon":"M","cldr_day_stand-alone_narrow_sat":"S","cldr_day_stand-alone_narrow_sun":"S","cldr_day_stand-alone_narrow_thu":"D","cldr_day_stand-alone_narrow_tue":"D","cldr_day_stand-alone_narrow_wed":"M","cldr_day_stand-alone_wide_fri":"Freitag","cldr_day_stand-alone_wide_mon":"Montag","cldr_day_stand-alone_wide_sat":"Samstag","cldr_day_stand-alone_wide_sun":"Sonntag","cldr_day_stand-alone_wide_thu":"Donnerstag","cldr_day_stand-alone_wide_tue":"Dienstag","cldr_day_stand-alone_wide_wed":"Mittwoch","cldr_month_format_abbreviated_1":"Jan","cldr_month_format_abbreviated_10":"Okt","cldr_month_format_abbreviated_11":"Nov","cldr_month_format_abbreviated_12":"Dez","cldr_month_format_abbreviated_2":"Feb","cldr_month_format_abbreviated_3":"Mär","cldr_month_format_abbreviated_4":"Apr","cldr_month_format_abbreviated_5":"Mai","cldr_month_format_abbreviated_6":"Jun","cldr_month_format_abbreviated_7":"Jul","cldr_month_format_abbreviated_8":"Aug","cldr_month_format_abbreviated_9":"Sep","cldr_month_format_wide_1":"Januar","cldr_month_format_wide_10":"Oktober","cldr_month_format_wide_11":"November","cldr_month_format_wide_12":"Dezember","cldr_month_format_wide_2":"Februar","cldr_month_format_wide_3":"März","cldr_month_format_wide_4":"April","cldr_month_format_wide_5":"Mai","cldr_month_format_wide_6":"Juni","cldr_month_format_wide_7":"Juli","cldr_month_format_wide_8":"August","cldr_month_format_wide_9":"September","cldr_month_stand-alone_abbreviated_10":"Okt","cldr_month_stand-alone_abbreviated_11":"Nov","cldr_month_stand-alone_abbreviated_12":"Dez","cldr_month_stand-alone_abbreviated_3":"Mär","cldr_month_stand-alone_abbreviated_7":"Jul","cldr_month_stand-alone_abbreviated_8":"Aug","cldr_month_stand-alone_abbreviated_9":"Sep","cldr_month_stand-alone_narrow_1":"J","cldr_month_stand-alone_narrow_10":"O","cldr_month_stand-alone_narrow_11":"N","cldr_month_stand-alone_narrow_12":"D","cldr_month_stand-alone_narrow_2":"F","cldr_month_stand-alone_narrow_3":"M","cldr_month_stand-alone_narrow_4":"A","cldr_month_stand-alone_narrow_5":"M","cldr_month_stand-alone_narrow_6":"J","cldr_month_stand-alone_narrow_7":"J","cldr_month_stand-alone_narrow_8":"A","cldr_month_stand-alone_narrow_9":"S","cldr_number_decimal_separator":",","cldr_number_group_separator":".","cldr_number_percent_format":"#,##0 %","cldr_pm":"nachm.","cldr_time_format_full":"HH:mm:ss zzzz","cldr_time_format_long":"HH:mm:ss z","cldr_time_format_medium":"HH:mm:ss","cldr_time_format_short":"HH:mm","quotationEnd":"“","quotationStart":"„"},"en":{"alternateQuotationEnd":"’","alternateQuotationStart":"‘","cldr_am":"AM","cldr_date_format_full":"EEEE, MMMM d, y","cldr_date_format_long":"MMMM d, y","cldr_date_format_medium":"MMM d, y","cldr_date_format_short":"M/d/yy","cldr_date_time_format_EEEd":"d EEE","cldr_date_time_format_Hm":"H:mm","cldr_date_time_format_Hms":"H:mm:ss","cldr_date_time_format_M":"L","cldr_date_time_format_MEd":"E, M/d","cldr_date_time_format_MMM":"LLL","cldr_date_time_format_MMMEd":"E, MMM d","cldr_date_time_format_MMMMEd":"E, MMMM d","cldr_date_time_format_MMMMd":"MMMM d","cldr_date_time_format_MMMd":"MMM d","cldr_date_time_format_Md":"M/d","cldr_date_time_format_d":"d","cldr_date_time_format_hm":"h:mm a","cldr_date_time_format_ms":"mm:ss","cldr_date_time_format_y":"y","cldr_date_time_format_yM":"M/yyyy","cldr_date_time_format_yMEd":"EEE, M/d/yyyy","cldr_date_time_format_yMMM":"MMM y","cldr_date_time_format_yMMMEd":"EEE, MMM d, y","cldr_date_time_format_yMMMM":"MMMM y","cldr_date_time_format_yQ":"Q yyyy","cldr_date_time_format_yQQQ":"QQQ y","cldr_day_format_abbreviated_fri":"Fri","cldr_day_format_abbreviated_mon":"Mon","cldr_day_format_abbreviated_sat":"Sat","cldr_day_format_abbreviated_sun":"Sun","cldr_day_format_abbreviated_thu":"Thu","cldr_day_format_abbreviated_tue":"Tue","cldr_day_format_abbreviated_wed":"Wed","cldr_day_format_narrow_fri":"F","cldr_day_format_narrow_mon":"M","cldr_day_format_narrow_sat":"S","cldr_day_format_narrow_sun":"S","cldr_day_format_narrow_thu":"T","cldr_day_format_narrow_tue":"T","cldr_day_format_narrow_wed":"W","cldr_day_format_wide_fri":"Friday","cldr_day_format_wide_mon":"Monday","cldr_day_format_wide_sat":"Saturday","cldr_day_format_wide_sun":"Sunday","cldr_day_format_wide_thu":"Thursday","cldr_day_format_wide_tue":"Tuesday","cldr_day_format_wide_wed":"Wednesday","cldr_day_stand-alone_abbreviated_fri":"Fri","cldr_day_stand-alone_abbreviated_mon":"Mon","cldr_day_stand-alone_abbreviated_sat":"Sat","cldr_day_stand-alone_abbreviated_sun":"Sun","cldr_day_stand-alone_abbreviated_thu":"Thu","cldr_day_stand-alone_abbreviated_tue":"Tue","cldr_day_stand-alone_abbreviated_wed":"Wed","cldr_day_stand-alone_narrow_fri":"F","cldr_day_stand-alone_narrow_mon":"M","cldr_day_stand-alone_narrow_sat":"S","cldr_day_stand-alone_narrow_sun":"S","cldr_day_stand-alone_narrow_thu":"T","cldr_day_stand-alone_narrow_tue":"T","cldr_day_stand-alone_narrow_wed":"W","cldr_day_stand-alone_wide_fri":"Friday","cldr_day_stand-alone_wide_mon":"Monday","cldr_day_stand-alone_wide_sat":"Saturday","cldr_day_stand-alone_wide_sun":"Sunday","cldr_day_stand-alone_wide_thu":"Thursday","cldr_day_stand-alone_wide_tue":"Tuesday","cldr_day_stand-alone_wide_wed":"Wednesday","cldr_month_format_abbreviated_1":"Jan","cldr_month_format_abbreviated_10":"Oct","cldr_month_format_abbreviated_11":"Nov","cldr_month_format_abbreviated_12":"Dec","cldr_month_format_abbreviated_2":"Feb","cldr_month_format_abbreviated_3":"Mar","cldr_month_format_abbreviated_4":"Apr","cldr_month_format_abbreviated_5":"May","cldr_month_format_abbreviated_6":"Jun","cldr_month_format_abbreviated_7":"Jul","cldr_month_format_abbreviated_8":"Aug","cldr_month_format_abbreviated_9":"Sep","cldr_month_format_wide_1":"January","cldr_month_format_wide_10":"October","cldr_month_format_wide_11":"November","cldr_month_format_wide_12":"December","cldr_month_format_wide_2":"February","cldr_month_format_wide_3":"March","cldr_month_format_wide_4":"April","cldr_month_format_wide_5":"May","cldr_month_format_wide_6":"June","cldr_month_format_wide_7":"July","cldr_month_format_wide_8":"August","cldr_month_format_wide_9":"September","cldr_month_stand-alone_narrow_1":"J","cldr_month_stand-alone_narrow_10":"O","cldr_month_stand-alone_narrow_11":"N","cldr_month_stand-alone_narrow_12":"D","cldr_month_stand-alone_narrow_2":"F","cldr_month_stand-alone_narrow_3":"M","cldr_month_stand-alone_narrow_4":"A","cldr_month_stand-alone_narrow_5":"M","cldr_month_stand-alone_narrow_6":"J","cldr_month_stand-alone_narrow_7":"J","cldr_month_stand-alone_narrow_8":"A","cldr_month_stand-alone_narrow_9":"S","cldr_number_decimal_separator":".","cldr_number_group_separator":",","cldr_number_percent_format":"#,##0%","cldr_pm":"PM","cldr_time_format_full":"h:mm:ss a zzzz","cldr_time_format_long":"h:mm:ss a z","cldr_time_format_medium":"h:mm:ss a","cldr_time_format_short":"h:mm a","quotationEnd":"”","quotationStart":"“"},"es":{"alternateQuotationEnd":"”","alternateQuotationStart":"“","cldr_am":"a.m.","cldr_date_format_full":"EEEE d 'de' MMMM 'de' y","cldr_date_format_long":"d 'de' MMMM 'de' y","cldr_date_format_medium":"dd/MM/yyyy","cldr_date_format_short":"dd/MM/yy","cldr_date_time_format_EEEd":"EEE d","cldr_date_time_format_HHmm":"HH:mm","cldr_date_time_format_HHmmss":"HH:mm:ss","cldr_date_time_format_Hm":"H:mm","cldr_date_time_format_M":"L","cldr_date_time_format_MEd":"E, d-M","cldr_date_time_format_MMM":"LLL","cldr_date_time_format_MMMEd":"E d MMM","cldr_date_time_format_MMMMEd":"E d MMMM","cldr_date_time_format_MMMMd":"d 'de' MMMM","cldr_date_time_format_MMMd":"d MMM","cldr_date_time_format_MMMdd":"dd-MMM","cldr_date_time_format_MMd":"d/MM","cldr_date_time_format_MMdd":"MM/dd","cldr_date_time_format_Md":"d/M","cldr_date_time_format_d":"d","cldr_date_time_format_hhmm":"hh:mm a","cldr_date_time_format_hhmmss":"hh:mm:ss a","cldr_date_time_format_mmss":"mm:ss","cldr_date_time_format_ms":"mm:ss","cldr_date_time_format_y":"y","cldr_date_time_format_yM":"M/yyyy","cldr_date_time_format_yMEd":"EEE d/M/yyyy","cldr_date_time_format_yMMM":"MMM y","cldr_date_time_format_yMMMEd":"EEE, d MMM y","cldr_date_time_format_yMMMM":"MMMM 'de' y","cldr_date_time_format_yQ":"Q yyyy","cldr_date_time_format_yQQQ":"QQQ yyyy","cldr_date_time_format_yyMM":"MM/yy","cldr_date_time_format_yyMMM":"MMM-yy","cldr_date_time_format_yyQ":"Q yy","cldr_date_time_format_yyQQQQ":"QQQQ 'de' yy","cldr_date_time_format_yyyyMM":"MM/yyyy","cldr_day_format_abbreviated_fri":"vie","cldr_day_format_abbreviated_mon":"lun","cldr_day_format_abbreviated_sat":"sáb","cldr_day_format_abbreviated_sun":"dom","cldr_day_format_abbreviated_thu":"jue","cldr_day_format_abbreviated_tue":"mar","cldr_day_format_abbreviated_wed":"mié","cldr_day_format_narrow_fri":"V","cldr_day_format_narrow_mon":"L","cldr_day_format_narrow_sat":"S","cldr_day_format_narrow_sun":"D","cldr_day_format_narrow_thu":"J","cldr_day_format_narrow_tue":"M","cldr_day_format_narrow_wed":"M","cldr_day_format_wide_fri":"viernes","cldr_day_format_wide_mon":"lunes","cldr_day_format_wide_sat":"sábado","cldr_day_format_wide_sun":"domingo","cldr_day_format_wide_thu":"jueves","cldr_day_format_wide_tue":"martes","cldr_day_format_wide_wed":"miércoles","cldr_day_stand-alone_abbreviated_fri":"vie","cldr_day_stand-alone_abbreviated_mon":"lun","cldr_day_stand-alone_abbreviated_sat":"sáb","cldr_day_stand-alone_abbreviated_sun":"dom","cldr_day_stand-alone_abbreviated_thu":"jue","cldr_day_stand-alone_abbreviated_tue":"mar","cldr_day_stand-alone_abbreviated_wed":"mié","cldr_day_stand-alone_narrow_fri":"V","cldr_day_stand-alone_narrow_mon":"L","cldr_day_stand-alone_narrow_sat":"S","cldr_day_stand-alone_narrow_sun":"D","cldr_day_stand-alone_narrow_thu":"J","cldr_day_stand-alone_narrow_tue":"M","cldr_day_stand-alone_narrow_wed":"M","cldr_day_stand-alone_wide_fri":"viernes","cldr_day_stand-alone_wide_mon":"lunes","cldr_day_stand-alone_wide_sat":"sábado","cldr_day_stand-alone_wide_sun":"domingo","cldr_day_stand-alone_wide_thu":"jueves","cldr_day_stand-alone_wide_tue":"martes","cldr_day_stand-alone_wide_wed":"miércoles","cldr_month_format_abbreviated_1":"ene","cldr_month_format_abbreviated_10":"oct","cldr_month_format_abbreviated_11":"nov","cldr_month_format_abbreviated_12":"dic","cldr_month_format_abbreviated_2":"feb","cldr_month_format_abbreviated_3":"mar","cldr_month_format_abbreviated_4":"abr","cldr_month_format_abbreviated_5":"may","cldr_month_format_abbreviated_6":"jun","cldr_month_format_abbreviated_7":"jul","cldr_month_format_abbreviated_8":"ago","cldr_month_format_abbreviated_9":"sep","cldr_month_format_wide_1":"enero","cldr_month_format_wide_10":"octubre","cldr_month_format_wide_11":"noviembre","cldr_month_format_wide_12":"diciembre","cldr_month_format_wide_2":"febrero","cldr_month_format_wide_3":"marzo","cldr_month_format_wide_4":"abril","cldr_month_format_wide_5":"mayo","cldr_month_format_wide_6":"junio","cldr_month_format_wide_7":"julio","cldr_month_format_wide_8":"agosto","cldr_month_format_wide_9":"septiembre","cldr_month_stand-alone_narrow_1":"E","cldr_month_stand-alone_narrow_10":"O","cldr_month_stand-alone_narrow_11":"N","cldr_month_stand-alone_narrow_12":"D","cldr_month_stand-alone_narrow_2":"F","cldr_month_stand-alone_narrow_3":"M","cldr_month_stand-alone_narrow_4":"A","cldr_month_stand-alone_narrow_5":"M","cldr_month_stand-alone_narrow_6":"J","cldr_month_stand-alone_narrow_7":"J","cldr_month_stand-alone_narrow_8":"A","cldr_month_stand-alone_narrow_9":"S","cldr_number_decimal_separator":",","cldr_number_group_separator":".","cldr_number_percent_format":"#,##0%","cldr_pm":"p.m.","cldr_time_format_full":"HH:mm:ss zzzz","cldr_time_format_long":"HH:mm:ss z","cldr_time_format_medium":"HH:mm:ss","cldr_time_format_short":"HH:mm","quotationEnd":"’","quotationStart":"‘"},"fr":{"alternateQuotationEnd":"”","alternateQuotationStart":"“","cldr_am":"AM","cldr_date_format_full":"EEEE d MMMM y","cldr_date_format_long":"d MMMM y","cldr_date_format_medium":"d MMM y","cldr_date_format_short":"dd/MM/yy","cldr_date_time_format_EEEd":"d EEE","cldr_date_time_format_HHmm":"HH:mm","cldr_date_time_format_HHmmss":"HH:mm:ss","cldr_date_time_format_Hm":"H:mm","cldr_date_time_format_M":"L","cldr_date_time_format_MEd":"E d/M","cldr_date_time_format_MMM":"LLL","cldr_date_time_format_MMMEd":"E d MMM","cldr_date_time_format_MMMMEd":"E d MMMM","cldr_date_time_format_MMMMd":"d MMMM","cldr_date_time_format_MMMd":"d MMM","cldr_date_time_format_MMMdd":"dd MMM","cldr_date_time_format_MMd":"d/MM","cldr_date_time_format_MMdd":"dd/MM","cldr_date_time_format_Md":"d/M","cldr_date_time_format_d":"d","cldr_date_time_format_mmss":"mm:ss","cldr_date_time_format_ms":"mm:ss","cldr_date_time_format_y":"y","cldr_date_time_format_yM":"M/yyyy","cldr_date_time_format_yMEd":"EEE d/M/yyyy","cldr_date_time_format_yMMM":"MMM y","cldr_date_time_format_yMMMEd":"EEE d MMM y","cldr_date_time_format_yMMMM":"MMMM y","cldr_date_time_format_yQ":"'T'Q y","cldr_date_time_format_yQQQ":"QQQ y","cldr_date_time_format_yyMM":"MM/yy","cldr_date_time_format_yyMMM":"MMM yy","cldr_date_time_format_yyMMMEEEd":"EEE d MMM yy","cldr_date_time_format_yyMMMd":"d MMM yy","cldr_date_time_format_yyQ":"'T'Q yy","cldr_date_time_format_yyQQQQ":"QQQQ yy","cldr_date_time_format_yyyyMMMM":"MMMM y","cldr_day_format_abbreviated_fri":"ven.","cldr_day_format_abbreviated_mon":"lun.","cldr_day_format_abbreviated_sat":"sam.","cldr_day_format_abbreviated_sun":"dim.","cldr_day_format_abbreviated_thu":"jeu.","cldr_day_format_abbreviated_tue":"mar.","cldr_day_format_abbreviated_wed":"mer.","cldr_day_format_narrow_fri":"V","cldr_day_format_narrow_mon":"L","cldr_day_format_narrow_sat":"S","cldr_day_format_narrow_sun":"D","cldr_day_format_narrow_thu":"J","cldr_day_format_narrow_tue":"M","cldr_day_format_narrow_wed":"M","cldr_day_format_wide_fri":"vendredi","cldr_day_format_wide_mon":"lundi","cldr_day_format_wide_sat":"samedi","cldr_day_format_wide_sun":"dimanche","cldr_day_format_wide_thu":"jeudi","cldr_day_format_wide_tue":"mardi","cldr_day_format_wide_wed":"mercredi","cldr_day_stand-alone_abbreviated_fri":"ven.","cldr_day_stand-alone_abbreviated_mon":"lun.","cldr_day_stand-alone_abbreviated_sat":"sam.","cldr_day_stand-alone_abbreviated_sun":"dim.","cldr_day_stand-alone_abbreviated_thu":"jeu.","cldr_day_stand-alone_abbreviated_tue":"mar.","cldr_day_stand-alone_abbreviated_wed":"mer.","cldr_day_stand-alone_narrow_fri":"V","cldr_day_stand-alone_narrow_mon":"L","cldr_day_stand-alone_narrow_sat":"S","cldr_day_stand-alone_narrow_sun":"D","cldr_day_stand-alone_narrow_thu":"J","cldr_day_stand-alone_narrow_tue":"M","cldr_day_stand-alone_narrow_wed":"M","cldr_day_stand-alone_wide_fri":"vendredi","cldr_day_stand-alone_wide_mon":"lundi","cldr_day_stand-alone_wide_sat":"samedi","cldr_day_stand-alone_wide_sun":"dimanche","cldr_day_stand-alone_wide_thu":"jeudi","cldr_day_stand-alone_wide_tue":"mardi","cldr_day_stand-alone_wide_wed":"mercredi","cldr_month_format_abbreviated_1":"janv.","cldr_month_format_abbreviated_10":"oct.","cldr_month_format_abbreviated_11":"nov.","cldr_month_format_abbreviated_12":"déc.","cldr_month_format_abbreviated_2":"févr.","cldr_month_format_abbreviated_3":"mars","cldr_month_format_abbreviated_4":"avr.","cldr_month_format_abbreviated_5":"mai","cldr_month_format_abbreviated_6":"juin","cldr_month_format_abbreviated_7":"juil.","cldr_month_format_abbreviated_8":"août","cldr_month_format_abbreviated_9":"sept.","cldr_month_format_wide_1":"janvier","cldr_month_format_wide_10":"octobre","cldr_month_format_wide_11":"novembre","cldr_month_format_wide_12":"décembre","cldr_month_format_wide_2":"février","cldr_month_format_wide_3":"mars","cldr_month_format_wide_4":"avril","cldr_month_format_wide_5":"mai","cldr_month_format_wide_6":"juin","cldr_month_format_wide_7":"juillet","cldr_month_format_wide_8":"août","cldr_month_format_wide_9":"septembre","cldr_month_stand-alone_narrow_1":"J","cldr_month_stand-alone_narrow_10":"O","cldr_month_stand-alone_narrow_11":"N","cldr_month_stand-alone_narrow_12":"D","cldr_month_stand-alone_narrow_2":"F","cldr_month_stand-alone_narrow_3":"M","cldr_month_stand-alone_narrow_4":"A","cldr_month_stand-alone_narrow_5":"M","cldr_month_stand-alone_narrow_6":"J","cldr_month_stand-alone_narrow_7":"J","cldr_month_stand-alone_narrow_8":"A","cldr_month_stand-alone_narrow_9":"S","cldr_number_decimal_separator":",","cldr_number_group_separator":" ","cldr_number_percent_format":"#,##0 %","cldr_pm":"PM","cldr_time_format_full":"HH:mm:ss zzzz","cldr_time_format_long":"HH:mm:ss z","cldr_time_format_medium":"HH:mm:ss","cldr_time_format_short":"HH:mm","quotationEnd":"»","quotationStart":"«"},"it":{"alternateQuotationEnd":"”","alternateQuotationStart":"“","cldr_am":"m.","cldr_date_format_full":"EEEE d MMMM y","cldr_date_format_long":"dd MMMM y","cldr_date_format_medium":"dd/MMM/y","cldr_date_format_short":"dd/MM/yy","cldr_date_time_format_HHmm":"HH.mm","cldr_date_time_format_HHmmss":"HH.mm.ss","cldr_date_time_format_Hm":"HH:mm","cldr_date_time_format_M":"L","cldr_date_time_format_MEd":"EEE d/M","cldr_date_time_format_MMM":"LLL","cldr_date_time_format_MMMEd":"EEE d MMM","cldr_date_time_format_MMMMEd":"EEE d MMMM","cldr_date_time_format_MMMMd":"d MMMM","cldr_date_time_format_MMMMdd":"dd MMMM","cldr_date_time_format_MMMd":"d MMM","cldr_date_time_format_MMdd":"dd/MM","cldr_date_time_format_Md":"d/M","cldr_date_time_format_d":"d","cldr_date_time_format_hhmm":"hh.mm a","cldr_date_time_format_hhmmss":"hh.mm.ss a","cldr_date_time_format_ms":"mm:ss","cldr_date_time_format_y":"y","cldr_date_time_format_yM":"M/yyyy","cldr_date_time_format_yMEd":"EEE, d-M-yyyy","cldr_date_time_format_yMMM":"MMM y","cldr_date_time_format_yMMMEd":"EEE d MMM y","cldr_date_time_format_yMMMM":"MMMM y","cldr_date_time_format_yQ":"Q-yyyy","cldr_date_time_format_yQQQ":"QQQ y","cldr_date_time_format_yyMM":"MM/yy","cldr_date_time_format_yyQ":"Q yy","cldr_date_time_format_yyQQQQ":"QQQQ yy","cldr_date_time_format_yyyyMMMM":"MMMM y","cldr_day_format_abbreviated_fri":"ven","cldr_day_format_abbreviated_mon":"lun","cldr_day_format_abbreviated_sat":"sab","cldr_day_format_abbreviated_sun":"dom","cldr_day_format_abbreviated_thu":"gio","cldr_day_format_abbreviated_tue":"mar","cldr_day_format_abbreviated_wed":"mer","cldr_day_format_narrow_fri":"V","cldr_day_format_narrow_mon":"L","cldr_day_format_narrow_sat":"S","cldr_day_format_narrow_sun":"D","cldr_day_format_narrow_thu":"G","cldr_day_format_narrow_tue":"M","cldr_day_format_narrow_wed":"M","cldr_day_format_wide_fri":"Venerdì","cldr_day_format_wide_mon":"Lunedì","cldr_day_format_wide_sat":"Sabato","cldr_day_format_wide_sun":"Domenica","cldr_day_format_wide_thu":"Giovedì","cldr_day_format_wide_tue":"Martedì","cldr_day_format_wide_wed":"Mercoledì","cldr_day_stand-alone_abbreviated_fri":"ven","cldr_day_stand-alone_abbreviated_mon":"lun","cldr_day_stand-alone_abbreviated_sat":"sab","cldr_day_stand-alone_abbreviated_sun":"dom","cldr_day_stand-alone_abbreviated_thu":"gio","cldr_day_stand-alone_abbreviated_tue":"mar","cldr_day_stand-alone_abbreviated_wed":"mer","cldr_day_stand-alone_narrow_fri":"V","cldr_day_stand-alone_narrow_mon":"L","cldr_day_stand-alone_narrow_sat":"S","cldr_day_stand-alone_narrow_sun":"D","cldr_day_stand-alone_narrow_thu":"G","cldr_day_stand-alone_narrow_tue":"M","cldr_day_stand-alone_narrow_wed":"M","cldr_day_stand-alone_wide_fri":"Venerdì","cldr_day_stand-alone_wide_mon":"Lunedì","cldr_day_stand-alone_wide_sat":"Sabato","cldr_day_stand-alone_wide_sun":"Domenica","cldr_day_stand-alone_wide_thu":"Giovedì","cldr_day_stand-alone_wide_tue":"Martedì","cldr_day_stand-alone_wide_wed":"Mercoledì","cldr_month_format_abbreviated_1":"gen","cldr_month_format_abbreviated_10":"ott","cldr_month_format_abbreviated_11":"nov","cldr_month_format_abbreviated_12":"dic","cldr_month_format_abbreviated_2":"feb","cldr_month_format_abbreviated_3":"mar","cldr_month_format_abbreviated_4":"apr","cldr_month_format_abbreviated_5":"mag","cldr_month_format_abbreviated_6":"giu","cldr_month_format_abbreviated_7":"lug","cldr_month_format_abbreviated_8":"ago","cldr_month_format_abbreviated_9":"set","cldr_month_format_wide_1":"gennaio","cldr_month_format_wide_10":"ottobre","cldr_month_format_wide_11":"novembre","cldr_month_format_wide_12":"dicembre","cldr_month_format_wide_2":"febbraio","cldr_month_format_wide_3":"marzo","cldr_month_format_wide_4":"aprile","cldr_month_format_wide_5":"maggio","cldr_month_format_wide_6":"giugno","cldr_month_format_wide_7":"luglio","cldr_month_format_wide_8":"agosto","cldr_month_format_wide_9":"settembre","cldr_month_stand-alone_narrow_1":"G","cldr_month_stand-alone_narrow_10":"O","cldr_month_stand-alone_narrow_11":"N","cldr_month_stand-alone_narrow_12":"D","cldr_month_stand-alone_narrow_2":"F","cldr_month_stand-alone_narrow_3":"M","cldr_month_stand-alone_narrow_4":"A","cldr_month_stand-alone_narrow_5":"M","cldr_month_stand-alone_narrow_6":"G","cldr_month_stand-alone_narrow_7":"L","cldr_month_stand-alone_narrow_8":"A","cldr_month_stand-alone_narrow_9":"S","cldr_month_stand-alone_wide_1":"Gennaio","cldr_month_stand-alone_wide_10":"Ottobre","cldr_month_stand-alone_wide_11":"Novembre","cldr_month_stand-alone_wide_12":"Dicembre","cldr_month_stand-alone_wide_2":"Febbraio","cldr_month_stand-alone_wide_3":"Marzo","cldr_month_stand-alone_wide_4":"Aprile","cldr_month_stand-alone_wide_5":"Maggio","cldr_month_stand-alone_wide_6":"Giugno","cldr_month_stand-alone_wide_7":"Luglio","cldr_month_stand-alone_wide_8":"Agosto","cldr_month_stand-alone_wide_9":"Settembre","cldr_number_decimal_separator":",","cldr_number_group_separator":".","cldr_number_percent_format":"#,##0%","cldr_pm":"p.","cldr_time_format_full":"HH.mm.ss zzzz","cldr_time_format_long":"HH.mm.ss z","cldr_time_format_medium":"HH.mm.ss","cldr_time_format_short":"HH.mm","quotationEnd":"’","quotationStart":"‘"},"nl":{"alternateQuotationEnd":"”","alternateQuotationStart":"“","cldr_am":"AM","cldr_date_format_full":"EEEE d MMMM y","cldr_date_format_long":"d MMMM y","cldr_date_format_medium":"d MMM y","cldr_date_format_short":"dd-MM-yy","cldr_date_time_format_Hm":"HH:mm","cldr_date_time_format_M":"L","cldr_date_time_format_MEd":"E d-M","cldr_date_time_format_MMM":"LLL","cldr_date_time_format_MMMEd":"E d MMM","cldr_date_time_format_MMMMEd":"E d MMMM","cldr_date_time_format_MMMMd":"d MMMM","cldr_date_time_format_MMMd":"d-MMM","cldr_date_time_format_MMd":"d-MM","cldr_date_time_format_MMdd":"dd-MM","cldr_date_time_format_Md":"d-M","cldr_date_time_format_d":"d","cldr_date_time_format_mmss":"mm:ss","cldr_date_time_format_ms":"mm:ss","cldr_date_time_format_y":"y","cldr_date_time_format_yM":"M-yyyy","cldr_date_time_format_yMEd":"EEE d-M-yyyy","cldr_date_time_format_yMMM":"MMM y","cldr_date_time_format_yMMMEd":"EEE d MMM y","cldr_date_time_format_yMMMM":"MMMM y","cldr_date_time_format_yQ":"Q yyyy","cldr_date_time_format_yQQQ":"QQQ y","cldr_date_time_format_yyMM":"MM-yy","cldr_date_time_format_yyMMM":"MMM yy","cldr_date_time_format_yyQ":"Q yy","cldr_date_time_format_yyQQQQ":"QQQQ yy","cldr_date_time_format_yyyyMMMM":"MMMM y","cldr_day_format_abbreviated_fri":"vr","cldr_day_format_abbreviated_mon":"ma","cldr_day_format_abbreviated_sat":"za","cldr_day_format_abbreviated_sun":"zo","cldr_day_format_abbreviated_thu":"do","cldr_day_format_abbreviated_tue":"di","cldr_day_format_abbreviated_wed":"wo","cldr_day_format_narrow_fri":"V","cldr_day_format_narrow_mon":"M","cldr_day_format_narrow_sat":"Z","cldr_day_format_narrow_sun":"Z","cldr_day_format_narrow_thu":"D","cldr_day_format_narrow_tue":"D","cldr_day_format_narrow_wed":"W","cldr_day_format_wide_fri":"vrijdag","cldr_day_format_wide_mon":"maandag","cldr_day_format_wide_sat":"zaterdag","cldr_day_format_wide_sun":"zondag","cldr_day_format_wide_thu":"donderdag","cldr_day_format_wide_tue":"dinsdag","cldr_day_format_wide_wed":"woensdag","cldr_day_stand-alone_abbreviated_fri":"vr","cldr_day_stand-alone_abbreviated_mon":"ma","cldr_day_stand-alone_abbreviated_sat":"za","cldr_day_stand-alone_abbreviated_sun":"zo","cldr_day_stand-alone_abbreviated_thu":"do","cldr_day_stand-alone_abbreviated_tue":"di","cldr_day_stand-alone_abbreviated_wed":"wo","cldr_day_stand-alone_narrow_fri":"V","cldr_day_stand-alone_narrow_mon":"M","cldr_day_stand-alone_narrow_sat":"Z","cldr_day_stand-alone_narrow_sun":"Z","cldr_day_stand-alone_narrow_thu":"D","cldr_day_stand-alone_narrow_tue":"D","cldr_day_stand-alone_narrow_wed":"W","cldr_day_stand-alone_wide_fri":"vrijdag","cldr_day_stand-alone_wide_mon":"maandag","cldr_day_stand-alone_wide_sat":"zaterdag","cldr_day_stand-alone_wide_sun":"zondag","cldr_day_stand-alone_wide_thu":"donderdag","cldr_day_stand-alone_wide_tue":"dinsdag","cldr_day_stand-alone_wide_wed":"woensdag","cldr_month_format_abbreviated_1":"jan.","cldr_month_format_abbreviated_10":"okt.","cldr_month_format_abbreviated_11":"nov.","cldr_month_format_abbreviated_12":"dec.","cldr_month_format_abbreviated_2":"feb.","cldr_month_format_abbreviated_3":"mrt.","cldr_month_format_abbreviated_4":"apr.","cldr_month_format_abbreviated_5":"mei","cldr_month_format_abbreviated_6":"jun.","cldr_month_format_abbreviated_7":"jul.","cldr_month_format_abbreviated_8":"aug.","cldr_month_format_abbreviated_9":"sep.","cldr_month_format_wide_1":"januari","cldr_month_format_wide_10":"oktober","cldr_month_format_wide_11":"november","cldr_month_format_wide_12":"december","cldr_month_format_wide_2":"februari","cldr_month_format_wide_3":"maart","cldr_month_format_wide_4":"april","cldr_month_format_wide_5":"mei","cldr_month_format_wide_6":"juni","cldr_month_format_wide_7":"juli","cldr_month_format_wide_8":"augustus","cldr_month_format_wide_9":"september","cldr_month_stand-alone_narrow_1":"J","cldr_month_stand-alone_narrow_10":"O","cldr_month_stand-alone_narrow_11":"N","cldr_month_stand-alone_narrow_12":"D","cldr_month_stand-alone_narrow_2":"F","cldr_month_stand-alone_narrow_3":"M","cldr_month_stand-alone_narrow_4":"A","cldr_month_stand-alone_narrow_5":"M","cldr_month_stand-alone_narrow_6":"J","cldr_month_stand-alone_narrow_7":"J","cldr_month_stand-alone_narrow_8":"A","cldr_month_stand-alone_narrow_9":"S","cldr_number_decimal_separator":",","cldr_number_group_separator":".","cldr_number_percent_format":"#,##0%","cldr_pm":"PM","cldr_time_format_full":"HH:mm:ss zzzz","cldr_time_format_long":"HH:mm:ss z","cldr_time_format_medium":"HH:mm:ss","cldr_time_format_short":"HH:mm","quotationEnd":"’","quotationStart":"‘"},"sv":{"alternateQuotationEnd":"’","alternateQuotationStart":"’","cldr_am":"fm","cldr_date_format_full":"EEEE d MMMM y","cldr_date_format_long":"d MMMM y","cldr_date_format_medium":"d MMM y","cldr_date_format_short":"yyyy-MM-dd","cldr_date_time_format_HHmm":"HH:mm","cldr_date_time_format_HHmmss":"HH:mm:ss","cldr_date_time_format_Hm":"HH:mm","cldr_date_time_format_M":"L","cldr_date_time_format_MEd":"E d/M","cldr_date_time_format_MMM":"LLL","cldr_date_time_format_MMMEd":"E d MMM","cldr_date_time_format_MMMMEEEd":"EEE d:'e' MMMM","cldr_date_time_format_MMMMEd":"E d:'e' MMMM","cldr_date_time_format_MMMMd":"d:'e' MMMM","cldr_date_time_format_MMMd":"d MMM","cldr_date_time_format_MMd":"d/M","cldr_date_time_format_MMdd":"dd/MM","cldr_date_time_format_Md":"d/M","cldr_date_time_format_d":"d","cldr_date_time_format_hhmm":"h:mm","cldr_date_time_format_hhmmss":"h:mm:ss","cldr_date_time_format_ms":"mm.ss","cldr_date_time_format_y":"y","cldr_date_time_format_yM":"yyyy-MM","cldr_date_time_format_yMEd":"EEE, yyyy-MM-dd","cldr_date_time_format_yMMM":"y MMM","cldr_date_time_format_yMMMEd":"EEE d MMM y","cldr_date_time_format_yMMMM":"y MMMM","cldr_date_time_format_yQ":"yyyy Q","cldr_date_time_format_yQQQ":"y QQQ","cldr_date_time_format_yyMM":"yy-MM","cldr_date_time_format_yyMMM":"MMM -yy","cldr_date_time_format_yyQ":"Q yy","cldr_date_time_format_yyyyMM":"yyyy-MM","cldr_date_time_format_yyyyMMM":"MMM y","cldr_date_time_format_yyyyQQQQ":"QQQQ y","cldr_day_format_abbreviated_fri":"fre","cldr_day_format_abbreviated_mon":"mån","cldr_day_format_abbreviated_sat":"lör","cldr_day_format_abbreviated_sun":"sön","cldr_day_format_abbreviated_thu":"tors","cldr_day_format_abbreviated_tue":"tis","cldr_day_format_abbreviated_wed":"ons","cldr_day_format_narrow_fri":"F","cldr_day_format_narrow_mon":"M","cldr_day_format_narrow_sat":"L","cldr_day_format_narrow_sun":"S","cldr_day_format_narrow_thu":"T","cldr_day_format_narrow_tue":"T","cldr_day_format_narrow_wed":"O","cldr_day_format_wide_fri":"fredag","cldr_day_format_wide_mon":"måndag","cldr_day_format_wide_sat":"lördag","cldr_day_format_wide_sun":"söndag","cldr_day_format_wide_thu":"torsdag","cldr_day_format_wide_tue":"tisdag","cldr_day_format_wide_wed":"onsdag","cldr_day_stand-alone_abbreviated_fri":"fre","cldr_day_stand-alone_abbreviated_mon":"mån","cldr_day_stand-alone_abbreviated_sat":"lör","cldr_day_stand-alone_abbreviated_sun":"sön","cldr_day_stand-alone_abbreviated_thu":"tors","cldr_day_stand-alone_abbreviated_tue":"tis","cldr_day_stand-alone_abbreviated_wed":"ons","cldr_day_stand-alone_narrow_fri":"F","cldr_day_stand-alone_narrow_mon":"M","cldr_day_stand-alone_narrow_sat":"L","cldr_day_stand-alone_narrow_sun":"S","cldr_day_stand-alone_narrow_thu":"T","cldr_day_stand-alone_narrow_tue":"T","cldr_day_stand-alone_narrow_wed":"O","cldr_day_stand-alone_wide_fri":"fredag","cldr_day_stand-alone_wide_mon":"måndag","cldr_day_stand-alone_wide_sat":"lördag","cldr_day_stand-alone_wide_sun":"söndag","cldr_day_stand-alone_wide_thu":"torsdag","cldr_day_stand-alone_wide_tue":"tisdag","cldr_day_stand-alone_wide_wed":"onsdag","cldr_month_format_abbreviated_1":"jan","cldr_month_format_abbreviated_10":"okt","cldr_month_format_abbreviated_11":"nov","cldr_month_format_abbreviated_12":"dec","cldr_month_format_abbreviated_2":"feb","cldr_month_format_abbreviated_3":"mar","cldr_month_format_abbreviated_4":"apr","cldr_month_format_abbreviated_5":"maj","cldr_month_format_abbreviated_6":"jun","cldr_month_format_abbreviated_7":"jul","cldr_month_format_abbreviated_8":"aug","cldr_month_format_abbreviated_9":"sep","cldr_month_format_wide_1":"januari","cldr_month_format_wide_10":"oktober","cldr_month_format_wide_11":"november","cldr_month_format_wide_12":"december","cldr_month_format_wide_2":"februari","cldr_month_format_wide_3":"mars","cldr_month_format_wide_4":"april","cldr_month_format_wide_5":"maj","cldr_month_format_wide_6":"juni","cldr_month_format_wide_7":"juli","cldr_month_format_wide_8":"augusti","cldr_month_format_wide_9":"september","cldr_month_stand-alone_narrow_1":"J","cldr_month_stand-alone_narrow_10":"O","cldr_month_stand-alone_narrow_11":"N","cldr_month_stand-alone_narrow_12":"D","cldr_month_stand-alone_narrow_2":"F","cldr_month_stand-alone_narrow_3":"M","cldr_month_stand-alone_narrow_4":"A","cldr_month_stand-alone_narrow_5":"M","cldr_month_stand-alone_narrow_6":"J","cldr_month_stand-alone_narrow_7":"J","cldr_month_stand-alone_narrow_8":"A","cldr_month_stand-alone_narrow_9":"S","cldr_number_decimal_separator":",","cldr_number_group_separator":" ","cldr_number_percent_format":"#,##0 %","cldr_pm":"em","cldr_time_format_full":"'kl'. HH.mm.ss zzzz","cldr_time_format_long":"HH.mm.ss z","cldr_time_format_medium":"HH.mm.ss","cldr_time_format_short":"HH.mm","quotationEnd":"”","quotationStart":"”"}},"resources":{"aristo/decoration/arrows-combined.png":[143,9,"png","aristo"],"aristo/decoration/arrows/arrow-down.png":[9,9,"png","aristo"],"aristo/decoration/arrows/arrow-focused-down.png":[9,9,"png","aristo"],"aristo/decoration/arrows/arrow-focused-left.png":[5,9,"png","aristo"],"aristo/decoration/arrows/arrow-focused-right.png":[5,9,"png","aristo"],"aristo/decoration/arrows/arrow-focused-up.png":[9,9,"png","aristo"],"aristo/decoration/arrows/arrow-left.png":[5,9,"png","aristo"],"aristo/decoration/arrows/arrow-right.png":[5,9,"png","aristo"],"aristo/decoration/arrows/arrow-up.png":[9,9,"png","aristo"],"aristo/decoration/arrows/down-invert.png":[8,5,"png","aristo"],"aristo/decoration/arrows/down-small-invert.png":[5,3,"png","aristo"],"aristo/decoration/arrows/down-small.png":[5,3,"png","aristo"],"aristo/decoration/arrows/down.png":[8,5,"png","aristo"],"aristo/decoration/arrows/forward.png":[10,8,"png","aristo"],"aristo/decoration/arrows/left-invert.png":[5,8,"png","aristo"],"aristo/decoration/arrows/left.png":[5,8,"png","aristo"],"aristo/decoration/arrows/rewind.png":[10,8,"png","aristo"],"aristo/decoration/arrows/right-invert.png":[5,8,"png","aristo"],"aristo/decoration/arrows/right.png":[5,8,"png","aristo"],"aristo/decoration/arrows/up-invert.png":[8,5,"png","aristo"],"aristo/decoration/arrows/up-small.png":[5,3,"png","aristo"],"aristo/decoration/arrows/up.png":[8,5,"png","aristo"],"aristo/decoration/button-lr-combined.png":[20,20,"png","aristo"],"aristo/decoration/button-tb-combined.png":[2,60,"png","aristo"],"aristo/decoration/checkradio-combined.png":[818,19,"png","aristo"],"aristo/decoration/colorselector-combined.gif":[46,11,"gif","aristo"],"aristo/decoration/colorselector/brightness-field.png":[19,256,"png","aristo"],"aristo/decoration/colorselector/brightness-handle.gif":[35,11,"gif","aristo"],"aristo/decoration/colorselector/huesaturation-field.jpg":[256,256,"jpeg","aristo"],"aristo/decoration/colorselector/huesaturation-handle.gif":[11,11,"gif","aristo"],"aristo/decoration/cursors-combined.gif":[71,20,"gif","aristo"],"aristo/decoration/cursors/alias.gif":[19,15,"gif","aristo"],"aristo/decoration/cursors/copy.gif":[19,15,"gif","aristo"],"aristo/decoration/cursors/move.gif":[13,9,"gif","aristo"],"aristo/decoration/cursors/nodrop.gif":[20,20,"gif","aristo"],"aristo/decoration/form/button-b.png":[2,2,"png","aristo"],"aristo/decoration/form/button-bl.png":[2,2,"png","aristo"],"aristo/decoration/form/button-br.png":[2,2,"png","aristo"],"aristo/decoration/form/button-c.png":[20,20,"png","aristo"],"aristo/decoration/form/button-checked-b.png":[2,2,"png","aristo"],"aristo/decoration/form/button-checked-bl.png":[2,2,"png","aristo"],"aristo/decoration/form/button-checked-br.png":[2,2,"png","aristo"],"aristo/decoration/form/button-checked-c.png":[20,20,"png","aristo"],"aristo/decoration/form/button-checked-l.png":[2,20,"png","aristo"],"aristo/decoration/form/button-checked-r.png":[2,20,"png","aristo"],"aristo/decoration/form/button-checked-t.png":[2,2,"png","aristo"],"aristo/decoration/form/button-checked-tl.png":[2,2,"png","aristo"],"aristo/decoration/form/button-checked-tr.png":[2,2,"png","aristo"],"aristo/decoration/form/button-checked.png":[62,24,"png","aristo"],"aristo/decoration/form/button-dark-c.png":[58,20,"png","aristo"],"aristo/decoration/form/button-disabled-b.png":[2,2,"png","aristo"],"aristo/decoration/form/button-disabled-bl.png":[2,2,"png","aristo"],"aristo/decoration/form/button-disabled-br.png":[2,2,"png","aristo"],"aristo/decoration/form/button-disabled-c.png":[20,20,"png","aristo"],"aristo/decoration/form/button-disabled-l.png":[2,20,"png","aristo"],"aristo/decoration/form/button-disabled-r.png":[2,20,"png","aristo"],"aristo/decoration/form/button-disabled-t.png":[2,2,"png","aristo"],"aristo/decoration/form/button-disabled-tl.png":[2,2,"png","aristo"],"aristo/decoration/form/button-disabled-tr.png":[2,2,"png","aristo"],"aristo/decoration/form/button-disabled.png":[62,24,"png","aristo"],"aristo/decoration/form/button-hovered-b.png":[2,2,"png","aristo"],"aristo/decoration/form/button-hovered-bl.png":[2,2,"png","aristo"],"aristo/decoration/form/button-hovered-br.png":[2,2,"png","aristo"],"aristo/decoration/form/button-hovered-c.png":[20,20,"png","aristo"],"aristo/decoration/form/button-hovered-l.png":[2,20,"png","aristo"],"aristo/decoration/form/button-hovered-r.png":[2,20,"png","aristo"],"aristo/decoration/form/button-hovered-t.png":[2,2,"png","aristo"],"aristo/decoration/form/button-hovered-tl.png":[2,2,"png","aristo"],"aristo/decoration/form/button-hovered-tr.png":[2,2,"png","aristo"],"aristo/decoration/form/button-hovered.png":[62,24,"png","aristo"],"aristo/decoration/form/button-l.png":[2,20,"png","aristo"],"aristo/decoration/form/button-pressed-b.png":[2,2,"png","aristo"],"aristo/decoration/form/button-pressed-bl.png":[2,2,"png","aristo"],"aristo/decoration/form/button-pressed-br.png":[2,2,"png","aristo"],"aristo/decoration/form/button-pressed-c.png":[20,20,"png","aristo"],"aristo/decoration/form/button-pressed-l.png":[2,20,"png","aristo"],"aristo/decoration/form/button-pressed-r.png":[2,20,"png","aristo"],"aristo/decoration/form/button-pressed-t.png":[2,2,"png","aristo"],"aristo/decoration/form/button-pressed-tl.png":[2,2,"png","aristo"],"aristo/decoration/form/button-pressed-tr.png":[2,2,"png","aristo"],"aristo/decoration/form/button-pressed.png":[62,24,"png","aristo"],"aristo/decoration/form/button-r.png":[2,20,"png","aristo"],"aristo/decoration/form/button-t.png":[2,2,"png","aristo"],"aristo/decoration/form/button-tl.png":[2,2,"png","aristo"],"aristo/decoration/form/button-tr.png":[2,2,"png","aristo"],"aristo/decoration/form/button.png":[62,24,"png","aristo"],"aristo/decoration/form/checkbox-checked-disabled.png":[17,17,"png","aristo"],"aristo/decoration/form/checkbox-checked-focused-invalid.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox-checked-focused.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox-checked-hovered-invalid.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox-checked-hovered.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox-checked-invalid.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox-checked-pressed-invalid.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox-checked-pressed.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox-checked.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox-disabled.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox-focused-disabled.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox-focused-invalid.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox-focused.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox-hovered-invalid.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox-hovered.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox-invalid.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox-pressed-invalid.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox-pressed.png":[19,19,"png","aristo"],"aristo/decoration/form/checkbox.png":[19,19,"png","aristo"],"aristo/decoration/form/input.png":[84,12,"png","aristo"],"aristo/decoration/form/radiobutton-checked-disabled.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-checked-focused-hovered-invalid.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-checked-focused-hovered.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-checked-focused-invalid.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-checked-focused.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-checked-hovered-invalid.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-checked-hovered.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-checked-invalid-disabled.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-checked-invalid.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-checked-pressed-focused-invalid.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-checked-pressed-focused.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-checked-pressed-invalid.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-checked-pressed.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-checked.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-disabled.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-focused-hovered-invalid.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-focused-invalid.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-focused.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-hovered-invalid.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-hovered.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-invalid-disabled.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-invalid.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-pressed-focused-invalid.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-pressed-focused.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-pressed-invalid.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton-pressed.png":[17,17,"png","aristo"],"aristo/decoration/form/radiobutton.png":[17,17,"png","aristo"],"aristo/decoration/form/slider-horizontal-c.png":[80,20,"png","aristo"],"aristo/decoration/form/slider-horizontal-l.png":[10,20,"png","aristo"],"aristo/decoration/form/slider-horizontal-r.png":[10,20,"png","aristo"],"aristo/decoration/form/slider-horizontal.png":[100,20,"png","aristo"],"aristo/decoration/form/slider-vertical-b.png":[20,10,"png","aristo"],"aristo/decoration/form/slider-vertical-c.png":[20,50,"png","aristo"],"aristo/decoration/form/slider-vertical-t.png":[20,8,"png","aristo"],"aristo/decoration/form/slider-vertical.png":[20,68,"png","aristo"],"aristo/decoration/form/tooltip-error-b.png":[6,6,"png","aristo"],"aristo/decoration/form/tooltip-error-bl.png":[6,6,"png","aristo"],"aristo/decoration/form/tooltip-error-br.png":[6,6,"png","aristo"],"aristo/decoration/form/tooltip-error-c.png":[20,18,"png","aristo"],"aristo/decoration/form/tooltip-error-l.png":[6,18,"png","aristo"],"aristo/decoration/form/tooltip-error-r.png":[6,18,"png","aristo"],"aristo/decoration/form/tooltip-error-t.png":[6,6,"png","aristo"],"aristo/decoration/form/tooltip-error-tl.png":[6,6,"png","aristo"],"aristo/decoration/form/tooltip-error-tr.png":[6,6,"png","aristo"],"aristo/decoration/form/tooltip-error.png":[127,30,"png","aristo"],"aristo/decoration/gray-shadow-lr-combined.png":[10,20,"png","aristo"],"aristo/decoration/gray-shadow-tb-combined.png":[5,30,"png","aristo"],"aristo/decoration/groupbox-lr-combined.png":[8,51,"png","aristo"],"aristo/decoration/groupbox-tb-combined.png":[4,24,"png","aristo"],"aristo/decoration/groupbox/groupbox-b.png":[4,4,"png","aristo"],"aristo/decoration/groupbox/groupbox-bl.png":[4,4,"png","aristo"],"aristo/decoration/groupbox/groupbox-br.png":[4,4,"png","aristo"],"aristo/decoration/groupbox/groupbox-c.png":[20,51,"png","aristo"],"aristo/decoration/groupbox/groupbox-l.png":[4,51,"png","aristo"],"aristo/decoration/groupbox/groupbox-r.png":[4,51,"png","aristo"],"aristo/decoration/groupbox/groupbox-t.png":[4,4,"png","aristo"],"aristo/decoration/groupbox/groupbox-tl.png":[4,4,"png","aristo"],"aristo/decoration/groupbox/groupbox-tr.png":[4,4,"png","aristo"],"aristo/decoration/groupbox/groupbox.png":[255,59,"png","aristo"],"aristo/decoration/icons/16x16/add.png":[16,16,"png","aristo"],"aristo/decoration/icons/16x16/back.png":[16,16,"png","aristo"],"aristo/decoration/icons/16x16/calendar.png":[16,16,"png","aristo"],"aristo/decoration/icons/16x16/chart.png":[16,16,"png","aristo"],"aristo/decoration/icons/16x16/folder.png":[16,16,"png","aristo"],"aristo/decoration/icons/16x16/forward.png":[16,16,"png","aristo"],"aristo/decoration/icons/16x16/minus.png":[16,16,"png","aristo"],"aristo/decoration/icons/16x16/order.png":[16,16,"png","aristo"],"aristo/decoration/icons/16x16/reload.png":[16,16,"png","aristo"],"aristo/decoration/icons/16x16/remove.png":[16,16,"png","aristo"],"aristo/decoration/icons/16x16/search.png":[16,16,"png","aristo"],"aristo/decoration/icons/16x16/user.png":[16,16,"png","aristo"],"aristo/decoration/menu-background-combined.png":[80,49,"png","aristo"],"aristo/decoration/menu-checkradio-combined.gif":[64,7,"gif","aristo"],"aristo/decoration/menu/background.png":[40,49,"png","aristo"],"aristo/decoration/menu/bar-background.png":[40,20,"png","aristo"],"aristo/decoration/menu/checkbox-invert.gif":[16,7,"gif","aristo"],"aristo/decoration/menu/checkbox.gif":[16,7,"gif","aristo"],"aristo/decoration/menu/radiobutton-invert.gif":[16,5,"gif","aristo"],"aristo/decoration/menu/radiobutton.gif":[16,5,"gif","aristo"],"aristo/decoration/pane/pane-b.png":[6,6,"png","aristo"],"aristo/decoration/pane/pane-bl.png":[6,6,"png","aristo"],"aristo/decoration/pane/pane-br.png":[6,6,"png","aristo"],"aristo/decoration/pane/pane-c.png":[40,238,"png","aristo"],"aristo/decoration/pane/pane-l.png":[6,238,"png","aristo"],"aristo/decoration/pane/pane-r.png":[6,238,"png","aristo"],"aristo/decoration/pane/pane-t.png":[6,6,"png","aristo"],"aristo/decoration/pane/pane-tl.png":[6,6,"png","aristo"],"aristo/decoration/pane/pane-tr.png":[6,6,"png","aristo"],"aristo/decoration/pane/pane.png":[185,250,"png","aristo"],"aristo/decoration/red-shadow-lr-combined.png":[10,20,"png","aristo"],"aristo/decoration/red-shadow-tb-combined.png":[5,30,"png","aristo"],"aristo/decoration/scrollbar-bg-button-lr-combined.png":[29,68,"png","aristo"],"aristo/decoration/scrollbar-bg-button-tb-combined.png":[17,116,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-bg-button-b.png":[17,29,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-bg-button-focused-b.png":[17,29,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-bg-button-focused-l.png":[29,17,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-bg-button-focused-r.png":[29,17,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-bg-button-focused-t.png":[17,29,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-bg-button-l.png":[29,17,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-bg-button-r.png":[29,17,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-bg-button-t.png":[17,29,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-bg-horizontal.png":[50,17,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-bg-vertical-disabled.png":[17,58,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-bg-vertical.png":[17,29,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-button-bg-horizontal-c.png":[43,14,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-button-bg-horizontal-l.png":[8,14,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-button-bg-horizontal-r.png":[8,14,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-button-bg-horizontal.png":[59,14,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-button-bg-vertical-b.png":[14,8,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-button-bg-vertical-c.png":[14,43,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-button-bg-vertical-t.png":[14,8,"png","aristo"],"aristo/decoration/scrollbar/scrollbar-button-bg-vertical.png":[14,59,"png","aristo"],"aristo/decoration/shadow-lr-combined.png":[10,20,"png","aristo"],"aristo/decoration/shadow-small-lr-combined.png":[10,136,"png","aristo"],"aristo/decoration/shadow-small-tb-combined.png":[5,30,"png","aristo"],"aristo/decoration/shadow-tb-combined.png":[5,30,"png","aristo"],"aristo/decoration/shadow-window-lr-combined.png":[10,402,"png","aristo"],"aristo/decoration/shadow-window-tb-combined.png":[5,30,"png","aristo"],"aristo/decoration/shadow/gray-shadow-b.png":[5,5,"png","aristo"],"aristo/decoration/shadow/gray-shadow-bl.png":[5,5,"png","aristo"],"aristo/decoration/shadow/gray-shadow-br.png":[5,5,"png","aristo"],"aristo/decoration/shadow/gray-shadow-c.png":[20,20,"png","aristo"],"aristo/decoration/shadow/gray-shadow-l.png":[5,20,"png","aristo"],"aristo/decoration/shadow/gray-shadow-r.png":[5,20,"png","aristo"],"aristo/decoration/shadow/gray-shadow-t.png":[5,5,"png","aristo"],"aristo/decoration/shadow/gray-shadow-tl.png":[5,5,"png","aristo"],"aristo/decoration/shadow/gray-shadow-tr.png":[5,5,"png","aristo"],"aristo/decoration/shadow/gray-shadow.png":[68,30,"png","aristo"],"aristo/decoration/shadow/red-shadow-b.png":[5,5,"png","aristo"],"aristo/decoration/shadow/red-shadow-bl.png":[5,5,"png","aristo"],"aristo/decoration/shadow/red-shadow-br.png":[5,5,"png","aristo"],"aristo/decoration/shadow/red-shadow-c.png":[20,20,"png","aristo"],"aristo/decoration/shadow/red-shadow-l.png":[5,20,"png","aristo"],"aristo/decoration/shadow/red-shadow-r.png":[5,20,"png","aristo"],"aristo/decoration/shadow/red-shadow-t.png":[5,5,"png","aristo"],"aristo/decoration/shadow/red-shadow-tl.png":[5,5,"png","aristo"],"aristo/decoration/shadow/red-shadow-tr.png":[5,5,"png","aristo"],"aristo/decoration/shadow/red-shadow.png":[68,30,"png","aristo"],"aristo/decoration/shadow/shadow-b.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-bl.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-br.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-c.png":[20,20,"png","aristo"],"aristo/decoration/shadow/shadow-l.png":[5,20,"png","aristo"],"aristo/decoration/shadow/shadow-r.png":[5,20,"png","aristo"],"aristo/decoration/shadow/shadow-small-b.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-small-bl.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-small-br.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-small-c.png":[20,136,"png","aristo"],"aristo/decoration/shadow/shadow-small-l.png":[5,136,"png","aristo"],"aristo/decoration/shadow/shadow-small-r.png":[5,136,"png","aristo"],"aristo/decoration/shadow/shadow-small-t.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-small-tl.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-small-tr.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-small.png":[114,146,"png","aristo"],"aristo/decoration/shadow/shadow-t.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-tl.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-tr.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-window-active-b.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-window-active-bl.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-window-active-br.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-window-active-c.png":[20,402,"png","aristo"],"aristo/decoration/shadow/shadow-window-active-l.png":[5,402,"png","aristo"],"aristo/decoration/shadow/shadow-window-active-r.png":[5,402,"png","aristo"],"aristo/decoration/shadow/shadow-window-active-t.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-window-active-tl.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-window-active-tr.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-window-active.png":[381,412,"png","aristo"],"aristo/decoration/shadow/shadow-window-b.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-window-bl.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-window-br.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-window-c.png":[20,402,"png","aristo"],"aristo/decoration/shadow/shadow-window-l.png":[5,402,"png","aristo"],"aristo/decoration/shadow/shadow-window-r.png":[5,402,"png","aristo"],"aristo/decoration/shadow/shadow-window-t.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-window-tl.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-window-tr.png":[5,5,"png","aristo"],"aristo/decoration/shadow/shadow-window.png":[381,412,"png","aristo"],"aristo/decoration/shadow/shadow.png":[68,30,"png","aristo"],"aristo/decoration/splitpane-knobs-combined.png":[8,9,"png","aristo"],"aristo/decoration/splitpane/knob-horizontal.png":[1,8,"png","aristo"],"aristo/decoration/splitpane/knob-vertical.png":[8,1,"png","aristo"],"aristo/decoration/table-combined.png":[94,18,"png","aristo"],"aristo/decoration/table/ascending.png":[8,5,"png","aristo"],"aristo/decoration/table/boolean-false.png":[14,14,"png","aristo"],"aristo/decoration/table/boolean-true.png":[14,14,"png","aristo"],"aristo/decoration/table/descending.png":[8,5,"png","aristo"],"aristo/decoration/table/header-cell.png":[40,18,"png","aristo"],"aristo/decoration/table/select-column-order.png":[10,9,"png","aristo"],"aristo/decoration/tabview-button-top-active-lr-combined.png":[10,12,"png","aristo"],"aristo/decoration/tabview-button-top-active-tb-combined.png":[5,30,"png","aristo"],"aristo/decoration/tabview-button-top-inactive-b-combined.png":[3,9,"png","aristo"],"aristo/decoration/tabview-button-top-inactive-t-combined.png":[3,9,"png","aristo"],"aristo/decoration/tabview-pane-lr-combined.png":[60,190,"png","aristo"],"aristo/decoration/tabview-pane-tb-combined.png":[30,180,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-active-b.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-active-bl.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-active-br.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-active-c.png":[40,14,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-active-l.png":[5,14,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-active-r.png":[5,14,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-active-t.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-active-tl.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-active-tr.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-active.png":[49,24,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-inactive-b.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-inactive-bl.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-inactive-br.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-inactive-c.png":[40,15,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-inactive-l.png":[3,15,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-inactive-r.png":[3,15,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-inactive-t.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-inactive-tl.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-inactive-tr.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-bottom-inactive.png":[45,21,"png","aristo"],"aristo/decoration/tabview/tab-button-left-active-b.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-left-active-bl.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-left-active-br.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-left-active-c.png":[40,37,"png","aristo"],"aristo/decoration/tabview/tab-button-left-active-l.png":[5,37,"png","aristo"],"aristo/decoration/tabview/tab-button-left-active-r.png":[5,37,"png","aristo"],"aristo/decoration/tabview/tab-button-left-active-t.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-left-active-tl.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-left-active-tr.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-left-active.png":[22,47,"png","aristo"],"aristo/decoration/tabview/tab-button-left-inactive-b.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-left-inactive-bl.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-left-inactive-br.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-left-inactive-c.png":[40,39,"png","aristo"],"aristo/decoration/tabview/tab-button-left-inactive-l.png":[3,39,"png","aristo"],"aristo/decoration/tabview/tab-button-left-inactive-r.png":[3,39,"png","aristo"],"aristo/decoration/tabview/tab-button-left-inactive-t.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-left-inactive-tl.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-left-inactive-tr.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-left-inactive.png":[20,45,"png","aristo"],"aristo/decoration/tabview/tab-button-right-active-b.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-right-active-bl.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-right-active-br.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-right-active-c.png":[40,37,"png","aristo"],"aristo/decoration/tabview/tab-button-right-active-l.png":[5,37,"png","aristo"],"aristo/decoration/tabview/tab-button-right-active-r.png":[5,37,"png","aristo"],"aristo/decoration/tabview/tab-button-right-active-t.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-right-active-tl.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-right-active-tr.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-right-active.png":[22,47,"png","aristo"],"aristo/decoration/tabview/tab-button-right-inactive-b.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-right-inactive-bl.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-right-inactive-br.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-right-inactive-c.png":[40,39,"png","aristo"],"aristo/decoration/tabview/tab-button-right-inactive-l.png":[3,39,"png","aristo"],"aristo/decoration/tabview/tab-button-right-inactive-r.png":[3,39,"png","aristo"],"aristo/decoration/tabview/tab-button-right-inactive-t.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-right-inactive-tl.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-right-inactive-tr.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-right-inactive.png":[20,45,"png","aristo"],"aristo/decoration/tabview/tab-button-top-active-b.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-top-active-bl.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-top-active-br.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-top-active-c.png":[20,12,"png","aristo"],"aristo/decoration/tabview/tab-button-top-active-l.png":[5,12,"png","aristo"],"aristo/decoration/tabview/tab-button-top-active-r.png":[5,12,"png","aristo"],"aristo/decoration/tabview/tab-button-top-active-t.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-top-active-tl.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-top-active-tr.png":[5,5,"png","aristo"],"aristo/decoration/tabview/tab-button-top-active.png":[48,22,"png","aristo"],"aristo/decoration/tabview/tab-button-top-inactive-b.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-top-inactive-bl.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-top-inactive-br.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-top-inactive-c.png":[20,15,"png","aristo"],"aristo/decoration/tabview/tab-button-top-inactive-l.png":[3,15,"png","aristo"],"aristo/decoration/tabview/tab-button-top-inactive-r.png":[3,15,"png","aristo"],"aristo/decoration/tabview/tab-button-top-inactive-t.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-top-inactive-tl.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-top-inactive-tr.png":[3,3,"png","aristo"],"aristo/decoration/tabview/tab-button-top-inactive.png":[45,21,"png","aristo"],"aristo/decoration/tabview/tabview-pane-b.png":[30,30,"png","aristo"],"aristo/decoration/tabview/tabview-pane-bl.png":[30,30,"png","aristo"],"aristo/decoration/tabview/tabview-pane-br.png":[30,30,"png","aristo"],"aristo/decoration/tabview/tabview-pane-c.png":[20,190,"png","aristo"],"aristo/decoration/tabview/tabview-pane-l.png":[30,190,"png","aristo"],"aristo/decoration/tabview/tabview-pane-r.png":[30,190,"png","aristo"],"aristo/decoration/tabview/tabview-pane-t.png":[30,30,"png","aristo"],"aristo/decoration/tabview/tabview-pane-tl.png":[30,30,"png","aristo"],"aristo/decoration/tabview/tabview-pane-tr.png":[30,30,"png","aristo"],"aristo/decoration/tabview/tabview-pane.png":[185,250,"png","aristo"],"aristo/decoration/toolbar-combined.png":[9,27,"png","aristo"],"aristo/decoration/toolbar/toolbar-gradient.png":[9,27,"png","aristo"],"aristo/decoration/toolbar/toolbar-handle-knob.gif":[1,8,"gif","aristo"],"aristo/decoration/toolbar/toolbar-part.gif":[7,1,"gif","aristo"],"aristo/decoration/tooltip-error-lr-combined.png":[12,18,"png","aristo"],"aristo/decoration/tooltip-error-tb-combined.png":[6,36,"png","aristo"],"aristo/decoration/tooltip/tooltip-error-arrow.png":[11,14,"png","aristo"],"aristo/decoration/tooltip/tooltip-error-b.png":[6,6,"png","aristo"],"aristo/decoration/tooltip/tooltip-error-bl.png":[6,6,"png","aristo"],"aristo/decoration/tooltip/tooltip-error-br.png":[6,6,"png","aristo"],"aristo/decoration/tooltip/tooltip-error-c.png":[40,18,"png","aristo"],"aristo/decoration/tooltip/tooltip-error-l.png":[6,18,"png","aristo"],"aristo/decoration/tooltip/tooltip-error-r.png":[6,18,"png","aristo"],"aristo/decoration/tooltip/tooltip-error-t.png":[6,6,"png","aristo"],"aristo/decoration/tooltip/tooltip-error-tl.png":[6,6,"png","aristo"],"aristo/decoration/tooltip/tooltip-error-tr.png":[6,6,"png","aristo"],"aristo/decoration/tooltip/tooltip-error.png":[127,30,"png","aristo"],"aristo/decoration/tree-combined.png":[32,8,"png","aristo"],"aristo/decoration/tree/closed-selected.png":[8,8,"png","aristo"],"aristo/decoration/tree/closed.png":[8,8,"png","aristo"],"aristo/decoration/tree/open-selected.png":[8,8,"png","aristo"],"aristo/decoration/tree/open.png":[8,8,"png","aristo"],"aristo/decoration/window-captionbar-buttons-combined.png":[192,16,"png","aristo"],"aristo/decoration/window-captionbar-lr-combined.png":[8,20,"png","aristo"],"aristo/decoration/window-captionbar-tb-combined.png":[4,24,"png","aristo"],"aristo/decoration/window-statusbar-lr-combined.png":[8,7,"png","aristo"],"aristo/decoration/window-statusbar-tb-combined.png":[4,24,"png","aristo"],"aristo/decoration/window/captionbar-b.png":[4,4,"png","aristo"],"aristo/decoration/window/captionbar-bl.png":[4,4,"png","aristo"],"aristo/decoration/window/captionbar-br.png":[4,4,"png","aristo"],"aristo/decoration/window/captionbar-c.png":[20,20,"png","aristo"],"aristo/decoration/window/captionbar-l.png":[4,20,"png","aristo"],"aristo/decoration/window/captionbar-r.png":[4,20,"png","aristo"],"aristo/decoration/window/captionbar-t.png":[4,4,"png","aristo"],"aristo/decoration/window/captionbar-tl.png":[4,4,"png","aristo"],"aristo/decoration/window/captionbar-tr.png":[4,4,"png","aristo"],"aristo/decoration/window/captionbar.png":[571,28,"png","aristo"],"aristo/decoration/window/close-active-hovered.png":[16,16,"png","aristo"],"aristo/decoration/window/close-active.png":[16,16,"png","aristo"],"aristo/decoration/window/close-inactive.png":[16,16,"png","aristo"],"aristo/decoration/window/maximize-active-hovered.png":[16,16,"png","aristo"],"aristo/decoration/window/maximize-active.png":[16,16,"png","aristo"],"aristo/decoration/window/maximize-inactive.png":[16,16,"png","aristo"],"aristo/decoration/window/minimize-active-hovered.png":[16,16,"png","aristo"],"aristo/decoration/window/minimize-active.png":[16,16,"png","aristo"],"aristo/decoration/window/minimize-inactive.png":[16,16,"png","aristo"],"aristo/decoration/window/restore-active-hovered.png":[16,16,"png","aristo"],"aristo/decoration/window/restore-active.png":[16,16,"png","aristo"],"aristo/decoration/window/restore-inactive.png":[16,16,"png","aristo"],"aristo/decoration/window/statusbar-b.png":[4,4,"png","aristo"],"aristo/decoration/window/statusbar-bl.png":[4,4,"png","aristo"],"aristo/decoration/window/statusbar-br.png":[4,4,"png","aristo"],"aristo/decoration/window/statusbar-c.png":[20,7,"png","aristo"],"aristo/decoration/window/statusbar-l.png":[4,7,"png","aristo"],"aristo/decoration/window/statusbar-r.png":[4,7,"png","aristo"],"aristo/decoration/window/statusbar-t.png":[4,4,"png","aristo"],"aristo/decoration/window/statusbar-tl.png":[4,4,"png","aristo"],"aristo/decoration/window/statusbar-tr.png":[4,4,"png","aristo"],"aristo/decoration/window/statusbar.png":[369,15,"png","aristo"],"qx/decoration/Classic/arrows-combined.gif":[124,7,"gif","qx"],"qx/decoration/Classic/arrows/down-invert.gif":[7,4,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-38,0],"qx/decoration/Classic/arrows/down-small-invert.gif":[5,3,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-87,0],"qx/decoration/Classic/arrows/down-small.gif":[5,3,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-53,0],"qx/decoration/Classic/arrows/down.gif":[7,4,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-113,0],"qx/decoration/Classic/arrows/forward-invert.gif":[8,7,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-30,0],"qx/decoration/Classic/arrows/forward.gif":[8,7,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-18,0],"qx/decoration/Classic/arrows/left-invert.gif":[4,7,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-92,0],"qx/decoration/Classic/arrows/left-small-invert.gif":[3,5,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-58,0],"qx/decoration/Classic/arrows/left-small.gif":[3,5,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-15,0],"qx/decoration/Classic/arrows/left.gif":[4,7,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-120,0],"qx/decoration/Classic/arrows/next-invert.gif":[4,7,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-80,0],"qx/decoration/Classic/arrows/next.gif":[4,7,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-109,0],"qx/decoration/Classic/arrows/previous-invert.gif":[4,7,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-69,0],"qx/decoration/Classic/arrows/previous.gif":[4,7,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-65,0],"qx/decoration/Classic/arrows/rewind-invert.gif":[8,7,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-45,0],"qx/decoration/Classic/arrows/rewind.gif":[8,7,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-101,0],"qx/decoration/Classic/arrows/right-invert.gif":[4,7,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-61,0],"qx/decoration/Classic/arrows/right-small-invert.gif":[3,5,"gif","qx","qx/decoration/Classic/arrows-combined.gif",0,0],"qx/decoration/Classic/arrows/right-small.gif":[3,5,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-84,0],"qx/decoration/Classic/arrows/right.gif":[4,7,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-26,0],"qx/decoration/Classic/arrows/up-invert.gif":[7,4,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-73,0],"qx/decoration/Classic/arrows/up-small-invert.gif":[5,3,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-96,0],"qx/decoration/Classic/arrows/up-small.gif":[5,3,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-3,0],"qx/decoration/Classic/arrows/up.gif":[7,4,"gif","qx","qx/decoration/Classic/arrows-combined.gif",-8,0],"qx/decoration/Classic/checkbox-radiobutton-combined.png":[504,14,"png","qx"],"qx/decoration/Classic/colorselector-combined.gif":[46,11,"gif","qx"],"qx/decoration/Classic/colorselector/brightness-field.png":[19,256,"png","qx"],"qx/decoration/Classic/colorselector/brightness-handle.gif":[35,11,"gif","qx","qx/decoration/Classic/colorselector-combined.gif",-11,0],"qx/decoration/Classic/colorselector/huesaturation-field.jpg":[256,256,"jpeg","qx"],"qx/decoration/Classic/colorselector/huesaturation-handle.gif":[11,11,"gif","qx","qx/decoration/Classic/colorselector-combined.gif",0,0],"qx/decoration/Classic/cursors-combined.gif":[71,20,"gif","qx"],"qx/decoration/Classic/cursors/alias.gif":[19,15,"gif","qx","qx/decoration/Classic/cursors-combined.gif",-52,0],"qx/decoration/Classic/cursors/copy.gif":[19,15,"gif","qx","qx/decoration/Classic/cursors-combined.gif",-20,0],"qx/decoration/Classic/cursors/move.gif":[13,9,"gif","qx","qx/decoration/Classic/cursors-combined.gif",-39,0],"qx/decoration/Classic/cursors/nodrop.gif":[20,20,"gif","qx","qx/decoration/Classic/cursors-combined.gif",0,0],"qx/decoration/Classic/datechooser/last-month-invert.png":[16,16,"png","qx"],"qx/decoration/Classic/datechooser/last-month.png":[16,16,"png","qx"],"qx/decoration/Classic/datechooser/last-year-invert.png":[16,16,"png","qx"],"qx/decoration/Classic/datechooser/last-year.png":[16,16,"png","qx"],"qx/decoration/Classic/datechooser/next-month-invert.png":[16,16,"png","qx"],"qx/decoration/Classic/datechooser/next-month.png":[16,16,"png","qx"],"qx/decoration/Classic/datechooser/next-year-invert.png":[16,16,"png","qx"],"qx/decoration/Classic/datechooser/next-year.png":[16,16,"png","qx"],"qx/decoration/Classic/form/checkbox-checked-disabled.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-336,0],"qx/decoration/Classic/form/checkbox-checked-focused-invalid.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-28,0],"qx/decoration/Classic/form/checkbox-checked-focused.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-462,0],"qx/decoration/Classic/form/checkbox-checked-hovered-invalid.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-112,0],"qx/decoration/Classic/form/checkbox-checked-hovered.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-140,0],"qx/decoration/Classic/form/checkbox-checked-invalid.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-98,0],"qx/decoration/Classic/form/checkbox-checked-pressed-invalid.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-308,0],"qx/decoration/Classic/form/checkbox-checked-pressed.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",0,0],"qx/decoration/Classic/form/checkbox-checked.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-266,0],"qx/decoration/Classic/form/checkbox-disabled.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-84,0],"qx/decoration/Classic/form/checkbox-focused-invalid.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-476,0],"qx/decoration/Classic/form/checkbox-focused.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-392,0],"qx/decoration/Classic/form/checkbox-hovered-invalid.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-196,0],"qx/decoration/Classic/form/checkbox-hovered.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-154,0],"qx/decoration/Classic/form/checkbox-invalid.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-350,0],"qx/decoration/Classic/form/checkbox-pressed-invalid.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-448,0],"qx/decoration/Classic/form/checkbox-pressed.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-70,0],"qx/decoration/Classic/form/checkbox.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-490,0],"qx/decoration/Classic/form/radiobutton-checked-disabled.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-210,0],"qx/decoration/Classic/form/radiobutton-checked-focused-invalid.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-406,0],"qx/decoration/Classic/form/radiobutton-checked-focused.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-378,0],"qx/decoration/Classic/form/radiobutton-checked-hovered-invalid.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-252,0],"qx/decoration/Classic/form/radiobutton-checked-hovered.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-182,0],"qx/decoration/Classic/form/radiobutton-checked-invalid.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-294,0],"qx/decoration/Classic/form/radiobutton-checked-pressed-invalid.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-420,0],"qx/decoration/Classic/form/radiobutton-checked-pressed.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-56,0],"qx/decoration/Classic/form/radiobutton-checked.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-322,0],"qx/decoration/Classic/form/radiobutton-disabled.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-364,0],"qx/decoration/Classic/form/radiobutton-focused-invalid.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-434,0],"qx/decoration/Classic/form/radiobutton-focused.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-168,0],"qx/decoration/Classic/form/radiobutton-hovered-invalid.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-126,0],"qx/decoration/Classic/form/radiobutton-hovered.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-42,0],"qx/decoration/Classic/form/radiobutton-invalid.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-280,0],"qx/decoration/Classic/form/radiobutton-pressed-invalid.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-238,0],"qx/decoration/Classic/form/radiobutton-pressed.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-14,0],"qx/decoration/Classic/form/radiobutton.png":[14,14,"png","qx","qx/decoration/Classic/checkbox-radiobutton-combined.png",-224,0],"qx/decoration/Classic/menu-combined.gif":[64,7,"gif","qx"],"qx/decoration/Classic/menu/checkbox-invert.gif":[16,7,"gif","qx","qx/decoration/Classic/menu-combined.gif",-16,0],"qx/decoration/Classic/menu/checkbox.gif":[16,7,"gif","qx","qx/decoration/Classic/menu-combined.gif",-32,0],"qx/decoration/Classic/menu/radiobutton-invert.gif":[16,5,"gif","qx","qx/decoration/Classic/menu-combined.gif",0,0],"qx/decoration/Classic/menu/radiobutton.gif":[16,5,"gif","qx","qx/decoration/Classic/menu-combined.gif",-48,0],"qx/decoration/Classic/shadow-lr-combined.png":[30,382,"png","qx"],"qx/decoration/Classic/shadow-small-lr-combined.png":[10,136,"png","qx"],"qx/decoration/Classic/shadow-small-tb-combined.png":[5,30,"png","qx"],"qx/decoration/Classic/shadow-tb-combined.png":[15,90,"png","qx"],"qx/decoration/Classic/shadow/shadow-b.png":[15,15,"png","qx","qx/decoration/Classic/shadow-tb-combined.png",0,-30],"qx/decoration/Classic/shadow/shadow-bl.png":[15,15,"png","qx","qx/decoration/Classic/shadow-tb-combined.png",0,0],"qx/decoration/Classic/shadow/shadow-br.png":[15,15,"png","qx","qx/decoration/Classic/shadow-tb-combined.png",0,-60],"qx/decoration/Classic/shadow/shadow-c.png":[40,382,"png","qx"],"qx/decoration/Classic/shadow/shadow-l.png":[15,382,"png","qx","qx/decoration/Classic/shadow-lr-combined.png",-15,0],"qx/decoration/Classic/shadow/shadow-r.png":[15,382,"png","qx","qx/decoration/Classic/shadow-lr-combined.png",0,0],"qx/decoration/Classic/shadow/shadow-small-b.png":[5,5,"png","qx","qx/decoration/Classic/shadow-small-tb-combined.png",0,-25],"qx/decoration/Classic/shadow/shadow-small-bl.png":[5,5,"png","qx","qx/decoration/Classic/shadow-small-tb-combined.png",0,-20],"qx/decoration/Classic/shadow/shadow-small-br.png":[5,5,"png","qx","qx/decoration/Classic/shadow-small-tb-combined.png",0,0],"qx/decoration/Classic/shadow/shadow-small-c.png":[40,136,"png","qx"],"qx/decoration/Classic/shadow/shadow-small-l.png":[5,136,"png","qx","qx/decoration/Classic/shadow-small-lr-combined.png",0,0],"qx/decoration/Classic/shadow/shadow-small-r.png":[5,136,"png","qx","qx/decoration/Classic/shadow-small-lr-combined.png",-5,0],"qx/decoration/Classic/shadow/shadow-small-t.png":[5,5,"png","qx","qx/decoration/Classic/shadow-small-tb-combined.png",0,-5],"qx/decoration/Classic/shadow/shadow-small-tl.png":[5,5,"png","qx","qx/decoration/Classic/shadow-small-tb-combined.png",0,-15],"qx/decoration/Classic/shadow/shadow-small-tr.png":[5,5,"png","qx","qx/decoration/Classic/shadow-small-tb-combined.png",0,-10],"qx/decoration/Classic/shadow/shadow-small.png":[114,146,"png","qx"],"qx/decoration/Classic/shadow/shadow-t.png":[15,15,"png","qx","qx/decoration/Classic/shadow-tb-combined.png",0,-75],"qx/decoration/Classic/shadow/shadow-tl.png":[15,15,"png","qx","qx/decoration/Classic/shadow-tb-combined.png",0,-45],"qx/decoration/Classic/shadow/shadow-tr.png":[15,15,"png","qx","qx/decoration/Classic/shadow-tb-combined.png",0,-15],"qx/decoration/Classic/shadow/shadow.png":[381,412,"png","qx"],"qx/decoration/Classic/splitpane/knob-horizontal.png":[4,15,"png","qx"],"qx/decoration/Classic/splitpane/knob-vertical.png":[15,4,"png","qx"],"qx/decoration/Classic/table-combined.png":[72,11,"png","qx"],"qx/decoration/Classic/table/ascending-invert.png":[10,10,"png","qx","qx/decoration/Classic/table-combined.png",-62,0],"qx/decoration/Classic/table/ascending.png":[10,10,"png","qx","qx/decoration/Classic/table-combined.png",-52,0],"qx/decoration/Classic/table/boolean-false.png":[11,11,"png","qx","qx/decoration/Classic/table-combined.png",-31,0],"qx/decoration/Classic/table/boolean-true.png":[11,11,"png","qx","qx/decoration/Classic/table-combined.png",-10,0],"qx/decoration/Classic/table/descending-invert.png":[10,10,"png","qx","qx/decoration/Classic/table-combined.png",-42,0],"qx/decoration/Classic/table/descending.png":[10,10,"png","qx","qx/decoration/Classic/table-combined.png",0,0],"qx/decoration/Classic/table/select-column-order.png":[10,9,"png","qx","qx/decoration/Classic/table-combined.png",-21,0],"qx/decoration/Classic/tree/minus.gif":[19,16,"gif","qx"],"qx/decoration/Classic/tree/plus.gif":[19,16,"gif","qx"],"qx/decoration/Classic/treevirtual/cross.gif":[19,16,"gif","qx"],"qx/decoration/Classic/treevirtual/cross_minus.gif":[19,16,"gif","qx"],"qx/decoration/Classic/treevirtual/cross_plus.gif":[19,16,"gif","qx"],"qx/decoration/Classic/treevirtual/end.gif":[19,16,"gif","qx"],"qx/decoration/Classic/treevirtual/end_minus.gif":[19,16,"gif","qx"],"qx/decoration/Classic/treevirtual/end_plus.gif":[19,16,"gif","qx"],"qx/decoration/Classic/treevirtual/line.gif":[19,16,"gif","qx"],"qx/decoration/Classic/treevirtual/only_minus.gif":[19,16,"gif","qx"],"qx/decoration/Classic/treevirtual/only_plus.gif":[19,16,"gif","qx"],"qx/decoration/Classic/treevirtual/start.gif":[19,16,"gif","qx"],"qx/decoration/Classic/treevirtual/start_minus.gif":[19,16,"gif","qx"],"qx/decoration/Classic/treevirtual/start_plus.gif":[19,16,"gif","qx"],"qx/decoration/Classic/window-captionbar-buttons-combined.gif":[36,9,"gif","qx"],"qx/decoration/Classic/window/close.gif":[10,9,"gif","qx","qx/decoration/Classic/window-captionbar-buttons-combined.gif",0,0],"qx/decoration/Classic/window/maximize.gif":[9,9,"gif","qx","qx/decoration/Classic/window-captionbar-buttons-combined.gif",-10,0],"qx/decoration/Classic/window/minimize.gif":[9,9,"gif","qx","qx/decoration/Classic/window-captionbar-buttons-combined.gif",-19,0],"qx/decoration/Classic/window/restore.gif":[8,9,"gif","qx","qx/decoration/Classic/window-captionbar-buttons-combined.gif",-28,0],"qx/decoration/Modern/app-header.png":[110,20,"png","qx"],"qx/decoration/Modern/arrows-combined.png":[87,8,"png","qx"],"qx/decoration/Modern/arrows/down-invert.png":[8,5,"png","qx","qx/decoration/Modern/arrows-combined.png",-74,0],"qx/decoration/Modern/arrows/down-small-invert.png":[5,3,"png","qx","qx/decoration/Modern/arrows-combined.png",-69,0],"qx/decoration/Modern/arrows/down-small.png":[5,3,"png","qx","qx/decoration/Modern/arrows-combined.png",-49,0],"qx/decoration/Modern/arrows/down.png":[8,5,"png","qx","qx/decoration/Modern/arrows-combined.png",-20,0],"qx/decoration/Modern/arrows/forward.png":[10,8,"png","qx","qx/decoration/Modern/arrows-combined.png",-59,0],"qx/decoration/Modern/arrows/left-invert.png":[5,8,"png","qx","qx/decoration/Modern/arrows-combined.png",0,0],"qx/decoration/Modern/arrows/left.png":[5,8,"png","qx","qx/decoration/Modern/arrows-combined.png",-44,0],"qx/decoration/Modern/arrows/rewind.png":[10,8,"png","qx","qx/decoration/Modern/arrows-combined.png",-10,0],"qx/decoration/Modern/arrows/right-invert.png":[5,8,"png","qx","qx/decoration/Modern/arrows-combined.png",-5,0],"qx/decoration/Modern/arrows/right.png":[5,8,"png","qx","qx/decoration/Modern/arrows-combined.png",-54,0],"qx/decoration/Modern/arrows/up-invert.png":[8,5,"png","qx","qx/decoration/Modern/arrows-combined.png",-28,0],"qx/decoration/Modern/arrows/up-small.png":[5,3,"png","qx","qx/decoration/Modern/arrows-combined.png",-82,0],"qx/decoration/Modern/arrows/up.png":[8,5,"png","qx","qx/decoration/Modern/arrows-combined.png",-36,0],"qx/decoration/Modern/button-lr-combined.png":[72,52,"png","qx"],"qx/decoration/Modern/button-tb-combined.png":[4,216,"png","qx"],"qx/decoration/Modern/checkradio-combined.png":[504,14,"png","qx"],"qx/decoration/Modern/colorselector-combined.gif":[46,11,"gif","qx"],"qx/decoration/Modern/colorselector/brightness-field.png":[19,256,"png","qx"],"qx/decoration/Modern/colorselector/brightness-handle.gif":[35,11,"gif","qx","qx/decoration/Modern/colorselector-combined.gif",0,0],"qx/decoration/Modern/colorselector/huesaturation-field.jpg":[256,256,"jpeg","qx"],"qx/decoration/Modern/colorselector/huesaturation-handle.gif":[11,11,"gif","qx","qx/decoration/Modern/colorselector-combined.gif",-35,0],"qx/decoration/Modern/cursors-combined.gif":[71,20,"gif","qx"],"qx/decoration/Modern/cursors/alias.gif":[19,15,"gif","qx","qx/decoration/Modern/cursors-combined.gif",-52,0],"qx/decoration/Modern/cursors/copy.gif":[19,15,"gif","qx","qx/decoration/Modern/cursors-combined.gif",-33,0],"qx/decoration/Modern/cursors/move.gif":[13,9,"gif","qx","qx/decoration/Modern/cursors-combined.gif",-20,0],"qx/decoration/Modern/cursors/nodrop.gif":[20,20,"gif","qx","qx/decoration/Modern/cursors-combined.gif",0,0],"qx/decoration/Modern/form/button-b.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-72],"qx/decoration/Modern/form/button-bl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-204],"qx/decoration/Modern/form/button-br.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-188],"qx/decoration/Modern/form/button-c.png":[40,52,"png","qx"],"qx/decoration/Modern/form/button-checked-b.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-36],"qx/decoration/Modern/form/button-checked-bl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-84],"qx/decoration/Modern/form/button-checked-br.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-184],"qx/decoration/Modern/form/button-checked-c.png":[40,52,"png","qx"],"qx/decoration/Modern/form/button-checked-focused-b.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-156],"qx/decoration/Modern/form/button-checked-focused-bl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-208],"qx/decoration/Modern/form/button-checked-focused-br.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-160],"qx/decoration/Modern/form/button-checked-focused-c.png":[40,52,"png","qx"],"qx/decoration/Modern/form/button-checked-focused-l.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-40,0],"qx/decoration/Modern/form/button-checked-focused-r.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-32,0],"qx/decoration/Modern/form/button-checked-focused-t.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-28],"qx/decoration/Modern/form/button-checked-focused-tl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-24],"qx/decoration/Modern/form/button-checked-focused-tr.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-48],"qx/decoration/Modern/form/button-checked-focused.png":[80,60,"png","qx"],"qx/decoration/Modern/form/button-checked-l.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-16,0],"qx/decoration/Modern/form/button-checked-r.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-60,0],"qx/decoration/Modern/form/button-checked-t.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-140],"qx/decoration/Modern/form/button-checked-tl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-56],"qx/decoration/Modern/form/button-checked-tr.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-112],"qx/decoration/Modern/form/button-checked.png":[80,60,"png","qx"],"qx/decoration/Modern/form/button-disabled-b.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-40],"qx/decoration/Modern/form/button-disabled-bl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-136],"qx/decoration/Modern/form/button-disabled-br.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-16],"qx/decoration/Modern/form/button-disabled-c.png":[40,52,"png","qx"],"qx/decoration/Modern/form/button-disabled-l.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-68,0],"qx/decoration/Modern/form/button-disabled-r.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-4,0],"qx/decoration/Modern/form/button-disabled-t.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-116],"qx/decoration/Modern/form/button-disabled-tl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-168],"qx/decoration/Modern/form/button-disabled-tr.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-60],"qx/decoration/Modern/form/button-disabled.png":[80,60,"png","qx"],"qx/decoration/Modern/form/button-focused-b.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-68],"qx/decoration/Modern/form/button-focused-bl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-144],"qx/decoration/Modern/form/button-focused-br.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-8],"qx/decoration/Modern/form/button-focused-c.png":[40,52,"png","qx"],"qx/decoration/Modern/form/button-focused-l.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-24,0],"qx/decoration/Modern/form/button-focused-r.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-44,0],"qx/decoration/Modern/form/button-focused-t.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-192],"qx/decoration/Modern/form/button-focused-tl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-148],"qx/decoration/Modern/form/button-focused-tr.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-104],"qx/decoration/Modern/form/button-focused.png":[80,60,"png","qx"],"qx/decoration/Modern/form/button-hovered-b.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-108],"qx/decoration/Modern/form/button-hovered-bl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-32],"qx/decoration/Modern/form/button-hovered-br.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-128],"qx/decoration/Modern/form/button-hovered-c.png":[40,52,"png","qx"],"qx/decoration/Modern/form/button-hovered-l.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-20,0],"qx/decoration/Modern/form/button-hovered-r.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-48,0],"qx/decoration/Modern/form/button-hovered-t.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-44],"qx/decoration/Modern/form/button-hovered-tl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-76],"qx/decoration/Modern/form/button-hovered-tr.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-88],"qx/decoration/Modern/form/button-hovered.png":[80,60,"png","qx"],"qx/decoration/Modern/form/button-l.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-56,0],"qx/decoration/Modern/form/button-preselected-b.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-124],"qx/decoration/Modern/form/button-preselected-bl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-176],"qx/decoration/Modern/form/button-preselected-br.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-200],"qx/decoration/Modern/form/button-preselected-c.png":[40,52,"png","qx"],"qx/decoration/Modern/form/button-preselected-focused-b.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,0],"qx/decoration/Modern/form/button-preselected-focused-bl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-4],"qx/decoration/Modern/form/button-preselected-focused-br.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-152],"qx/decoration/Modern/form/button-preselected-focused-c.png":[40,52,"png","qx"],"qx/decoration/Modern/form/button-preselected-focused-l.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-28,0],"qx/decoration/Modern/form/button-preselected-focused-r.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-36,0],"qx/decoration/Modern/form/button-preselected-focused-t.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-196],"qx/decoration/Modern/form/button-preselected-focused-tl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-164],"qx/decoration/Modern/form/button-preselected-focused-tr.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-212],"qx/decoration/Modern/form/button-preselected-focused.png":[80,60,"png","qx"],"qx/decoration/Modern/form/button-preselected-l.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-8,0],"qx/decoration/Modern/form/button-preselected-r.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-64,0],"qx/decoration/Modern/form/button-preselected-t.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-96],"qx/decoration/Modern/form/button-preselected-tl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-80],"qx/decoration/Modern/form/button-preselected-tr.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-132],"qx/decoration/Modern/form/button-preselected.png":[80,60,"png","qx"],"qx/decoration/Modern/form/button-pressed-b.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-12],"qx/decoration/Modern/form/button-pressed-bl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-52],"qx/decoration/Modern/form/button-pressed-br.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-20],"qx/decoration/Modern/form/button-pressed-c.png":[40,52,"png","qx"],"qx/decoration/Modern/form/button-pressed-l.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-52,0],"qx/decoration/Modern/form/button-pressed-r.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",-12,0],"qx/decoration/Modern/form/button-pressed-t.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-100],"qx/decoration/Modern/form/button-pressed-tl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-172],"qx/decoration/Modern/form/button-pressed-tr.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-64],"qx/decoration/Modern/form/button-pressed.png":[80,60,"png","qx"],"qx/decoration/Modern/form/button-r.png":[4,52,"png","qx","qx/decoration/Modern/button-lr-combined.png",0,0],"qx/decoration/Modern/form/button-t.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-92],"qx/decoration/Modern/form/button-tl.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-120],"qx/decoration/Modern/form/button-tr.png":[4,4,"png","qx","qx/decoration/Modern/button-tb-combined.png",0,-180],"qx/decoration/Modern/form/button.png":[80,60,"png","qx"],"qx/decoration/Modern/form/checkbox-checked-disabled.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-126,0],"qx/decoration/Modern/form/checkbox-checked-focused-invalid.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-322,0],"qx/decoration/Modern/form/checkbox-checked-focused.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-294,0],"qx/decoration/Modern/form/checkbox-checked-hovered-invalid.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-364,0],"qx/decoration/Modern/form/checkbox-checked-hovered.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-490,0],"qx/decoration/Modern/form/checkbox-checked-invalid.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-224,0],"qx/decoration/Modern/form/checkbox-checked-pressed-invalid.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-378,0],"qx/decoration/Modern/form/checkbox-checked-pressed.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-84,0],"qx/decoration/Modern/form/checkbox-checked.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-182,0],"qx/decoration/Modern/form/checkbox-disabled.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-42,0],"qx/decoration/Modern/form/checkbox-focused-invalid.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-392,0],"qx/decoration/Modern/form/checkbox-focused.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-210,0],"qx/decoration/Modern/form/checkbox-hovered-invalid.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-14,0],"qx/decoration/Modern/form/checkbox-hovered.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-238,0],"qx/decoration/Modern/form/checkbox-invalid.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-462,0],"qx/decoration/Modern/form/checkbox-pressed-invalid.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-112,0],"qx/decoration/Modern/form/checkbox-pressed.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-448,0],"qx/decoration/Modern/form/checkbox.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-140,0],"qx/decoration/Modern/form/input-focused.png":[40,12,"png","qx"],"qx/decoration/Modern/form/input.png":[84,12,"png","qx"],"qx/decoration/Modern/form/radiobutton-checked-disabled.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-196,0],"qx/decoration/Modern/form/radiobutton-checked-focused-invalid.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-168,0],"qx/decoration/Modern/form/radiobutton-checked-focused.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-98,0],"qx/decoration/Modern/form/radiobutton-checked-hovered-invalid.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-308,0],"qx/decoration/Modern/form/radiobutton-checked-hovered.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-406,0],"qx/decoration/Modern/form/radiobutton-checked-invalid.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-28,0],"qx/decoration/Modern/form/radiobutton-checked-pressed-invalid.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-350,0],"qx/decoration/Modern/form/radiobutton-checked-pressed.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-266,0],"qx/decoration/Modern/form/radiobutton-checked.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-252,0],"qx/decoration/Modern/form/radiobutton-disabled.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-336,0],"qx/decoration/Modern/form/radiobutton-focused-invalid.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-476,0],"qx/decoration/Modern/form/radiobutton-focused.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-420,0],"qx/decoration/Modern/form/radiobutton-hovered-invalid.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-56,0],"qx/decoration/Modern/form/radiobutton-hovered.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",0,0],"qx/decoration/Modern/form/radiobutton-invalid.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-154,0],"qx/decoration/Modern/form/radiobutton-pressed-invalid.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-434,0],"qx/decoration/Modern/form/radiobutton-pressed.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-280,0],"qx/decoration/Modern/form/radiobutton.png":[14,14,"png","qx","qx/decoration/Modern/checkradio-combined.png",-70,0],"qx/decoration/Modern/form/tooltip-error-arrow.png":[11,14,"png","qx"],"qx/decoration/Modern/form/tooltip-error-b.png":[6,6,"png","qx","qx/decoration/Modern/tooltip-error-tb-combined.png",0,-30],"qx/decoration/Modern/form/tooltip-error-bl.png":[6,6,"png","qx","qx/decoration/Modern/tooltip-error-tb-combined.png",0,-24],"qx/decoration/Modern/form/tooltip-error-br.png":[6,6,"png","qx","qx/decoration/Modern/tooltip-error-tb-combined.png",0,0],"qx/decoration/Modern/form/tooltip-error-c.png":[40,18,"png","qx"],"qx/decoration/Modern/form/tooltip-error-l.png":[6,18,"png","qx","qx/decoration/Modern/tooltip-error-lr-combined.png",-6,0],"qx/decoration/Modern/form/tooltip-error-r.png":[6,18,"png","qx","qx/decoration/Modern/tooltip-error-lr-combined.png",0,0],"qx/decoration/Modern/form/tooltip-error-t.png":[6,6,"png","qx","qx/decoration/Modern/tooltip-error-tb-combined.png",0,-6],"qx/decoration/Modern/form/tooltip-error-tl.png":[6,6,"png","qx","qx/decoration/Modern/tooltip-error-tb-combined.png",0,-18],"qx/decoration/Modern/form/tooltip-error-tr.png":[6,6,"png","qx","qx/decoration/Modern/tooltip-error-tb-combined.png",0,-12],"qx/decoration/Modern/form/tooltip-error.png":[127,30,"png","qx"],"qx/decoration/Modern/groupbox-lr-combined.png":[8,51,"png","qx"],"qx/decoration/Modern/groupbox-tb-combined.png":[4,24,"png","qx"],"qx/decoration/Modern/groupbox/groupbox-b.png":[4,4,"png","qx","qx/decoration/Modern/groupbox-tb-combined.png",0,-12],"qx/decoration/Modern/groupbox/groupbox-bl.png":[4,4,"png","qx","qx/decoration/Modern/groupbox-tb-combined.png",0,-16],"qx/decoration/Modern/groupbox/groupbox-br.png":[4,4,"png","qx","qx/decoration/Modern/groupbox-tb-combined.png",0,-8],"qx/decoration/Modern/groupbox/groupbox-c.png":[40,51,"png","qx"],"qx/decoration/Modern/groupbox/groupbox-l.png":[4,51,"png","qx","qx/decoration/Modern/groupbox-lr-combined.png",-4,0],"qx/decoration/Modern/groupbox/groupbox-r.png":[4,51,"png","qx","qx/decoration/Modern/groupbox-lr-combined.png",0,0],"qx/decoration/Modern/groupbox/groupbox-t.png":[4,4,"png","qx","qx/decoration/Modern/groupbox-tb-combined.png",0,-4],"qx/decoration/Modern/groupbox/groupbox-tl.png":[4,4,"png","qx","qx/decoration/Modern/groupbox-tb-combined.png",0,0],"qx/decoration/Modern/groupbox/groupbox-tr.png":[4,4,"png","qx","qx/decoration/Modern/groupbox-tb-combined.png",0,-20],"qx/decoration/Modern/groupbox/groupbox.png":[255,59,"png","qx"],"qx/decoration/Modern/menu-background-combined.png":[80,49,"png","qx"],"qx/decoration/Modern/menu-checkradio-combined.gif":[64,7,"gif","qx"],"qx/decoration/Modern/menu/background.png":[40,49,"png","qx","qx/decoration/Modern/menu-background-combined.png",-40,0],"qx/decoration/Modern/menu/bar-background.png":[40,20,"png","qx","qx/decoration/Modern/menu-background-combined.png",0,0],"qx/decoration/Modern/menu/checkbox-invert.gif":[16,7,"gif","qx","qx/decoration/Modern/menu-checkradio-combined.gif",-16,0],"qx/decoration/Modern/menu/checkbox.gif":[16,7,"gif","qx","qx/decoration/Modern/menu-checkradio-combined.gif",-48,0],"qx/decoration/Modern/menu/radiobutton-invert.gif":[16,5,"gif","qx","qx/decoration/Modern/menu-checkradio-combined.gif",-32,0],"qx/decoration/Modern/menu/radiobutton.gif":[16,5,"gif","qx","qx/decoration/Modern/menu-checkradio-combined.gif",0,0],"qx/decoration/Modern/pane-lr-combined.png":[12,238,"png","qx"],"qx/decoration/Modern/pane-tb-combined.png":[6,36,"png","qx"],"qx/decoration/Modern/pane/pane-b.png":[6,6,"png","qx","qx/decoration/Modern/pane-tb-combined.png",0,-30],"qx/decoration/Modern/pane/pane-bl.png":[6,6,"png","qx","qx/decoration/Modern/pane-tb-combined.png",0,-18],"qx/decoration/Modern/pane/pane-br.png":[6,6,"png","qx","qx/decoration/Modern/pane-tb-combined.png",0,-12],"qx/decoration/Modern/pane/pane-c.png":[40,238,"png","qx"],"qx/decoration/Modern/pane/pane-l.png":[6,238,"png","qx","qx/decoration/Modern/pane-lr-combined.png",0,0],"qx/decoration/Modern/pane/pane-r.png":[6,238,"png","qx","qx/decoration/Modern/pane-lr-combined.png",-6,0],"qx/decoration/Modern/pane/pane-t.png":[6,6,"png","qx","qx/decoration/Modern/pane-tb-combined.png",0,0],"qx/decoration/Modern/pane/pane-tl.png":[6,6,"png","qx","qx/decoration/Modern/pane-tb-combined.png",0,-24],"qx/decoration/Modern/pane/pane-tr.png":[6,6,"png","qx","qx/decoration/Modern/pane-tb-combined.png",0,-6],"qx/decoration/Modern/pane/pane.png":[185,250,"png","qx"],"qx/decoration/Modern/scrollbar-combined.png":[54,12,"png","qx"],"qx/decoration/Modern/scrollbar/scrollbar-bg-horizontal.png":[76,15,"png","qx"],"qx/decoration/Modern/scrollbar/scrollbar-bg-pressed-horizontal.png":[19,10,"png","qx"],"qx/decoration/Modern/scrollbar/scrollbar-bg-pressed-vertical.png":[10,19,"png","qx"],"qx/decoration/Modern/scrollbar/scrollbar-bg-vertical.png":[15,76,"png","qx"],"qx/decoration/Modern/scrollbar/scrollbar-button-bg-horizontal.png":[12,10,"png","qx","qx/decoration/Modern/scrollbar-combined.png",-34,0],"qx/decoration/Modern/scrollbar/scrollbar-button-bg-vertical.png":[10,12,"png","qx","qx/decoration/Modern/scrollbar-combined.png",-6,0],"qx/decoration/Modern/scrollbar/scrollbar-down.png":[6,4,"png","qx","qx/decoration/Modern/scrollbar-combined.png",-28,0],"qx/decoration/Modern/scrollbar/scrollbar-left.png":[4,6,"png","qx","qx/decoration/Modern/scrollbar-combined.png",-50,0],"qx/decoration/Modern/scrollbar/scrollbar-right.png":[4,6,"png","qx","qx/decoration/Modern/scrollbar-combined.png",-46,0],"qx/decoration/Modern/scrollbar/scrollbar-up.png":[6,4,"png","qx","qx/decoration/Modern/scrollbar-combined.png",0,0],"qx/decoration/Modern/scrollbar/slider-knob-background.png":[12,10,"png","qx","qx/decoration/Modern/scrollbar-combined.png",-16,0],"qx/decoration/Modern/selection.png":[110,20,"png","qx"],"qx/decoration/Modern/shadow-lr-combined.png":[30,382,"png","qx"],"qx/decoration/Modern/shadow-small-lr-combined.png":[10,136,"png","qx"],"qx/decoration/Modern/shadow-small-tb-combined.png":[5,30,"png","qx"],"qx/decoration/Modern/shadow-tb-combined.png":[15,90,"png","qx"],"qx/decoration/Modern/shadow/shadow-b.png":[15,15,"png","qx","qx/decoration/Modern/shadow-tb-combined.png",0,-30],"qx/decoration/Modern/shadow/shadow-bl.png":[15,15,"png","qx","qx/decoration/Modern/shadow-tb-combined.png",0,-15],"qx/decoration/Modern/shadow/shadow-br.png":[15,15,"png","qx","qx/decoration/Modern/shadow-tb-combined.png",0,-45],"qx/decoration/Modern/shadow/shadow-c.png":[40,382,"png","qx"],"qx/decoration/Modern/shadow/shadow-l.png":[15,382,"png","qx","qx/decoration/Modern/shadow-lr-combined.png",0,0],"qx/decoration/Modern/shadow/shadow-r.png":[15,382,"png","qx","qx/decoration/Modern/shadow-lr-combined.png",-15,0],"qx/decoration/Modern/shadow/shadow-small-b.png":[5,5,"png","qx","qx/decoration/Modern/shadow-small-tb-combined.png",0,-20],"qx/decoration/Modern/shadow/shadow-small-bl.png":[5,5,"png","qx","qx/decoration/Modern/shadow-small-tb-combined.png",0,-15],"qx/decoration/Modern/shadow/shadow-small-br.png":[5,5,"png","qx","qx/decoration/Modern/shadow-small-tb-combined.png",0,-10],"qx/decoration/Modern/shadow/shadow-small-c.png":[40,136,"png","qx"],"qx/decoration/Modern/shadow/shadow-small-l.png":[5,136,"png","qx","qx/decoration/Modern/shadow-small-lr-combined.png",0,0],"qx/decoration/Modern/shadow/shadow-small-r.png":[5,136,"png","qx","qx/decoration/Modern/shadow-small-lr-combined.png",-5,0],"qx/decoration/Modern/shadow/shadow-small-t.png":[5,5,"png","qx","qx/decoration/Modern/shadow-small-tb-combined.png",0,-5],"qx/decoration/Modern/shadow/shadow-small-tl.png":[5,5,"png","qx","qx/decoration/Modern/shadow-small-tb-combined.png",0,0],"qx/decoration/Modern/shadow/shadow-small-tr.png":[5,5,"png","qx","qx/decoration/Modern/shadow-small-tb-combined.png",0,-25],"qx/decoration/Modern/shadow/shadow-small.png":[114,146,"png","qx"],"qx/decoration/Modern/shadow/shadow-t.png":[15,15,"png","qx","qx/decoration/Modern/shadow-tb-combined.png",0,-60],"qx/decoration/Modern/shadow/shadow-tl.png":[15,15,"png","qx","qx/decoration/Modern/shadow-tb-combined.png",0,-75],"qx/decoration/Modern/shadow/shadow-tr.png":[15,15,"png","qx","qx/decoration/Modern/shadow-tb-combined.png",0,0],"qx/decoration/Modern/shadow/shadow.png":[381,412,"png","qx"],"qx/decoration/Modern/splitpane-knobs-combined.png":[8,9,"png","qx"],"qx/decoration/Modern/splitpane/knob-horizontal.png":[1,8,"png","qx","qx/decoration/Modern/splitpane-knobs-combined.png",0,-1],"qx/decoration/Modern/splitpane/knob-vertical.png":[8,1,"png","qx","qx/decoration/Modern/splitpane-knobs-combined.png",0,0],"qx/decoration/Modern/table-combined.png":[94,18,"png","qx"],"qx/decoration/Modern/table/ascending.png":[8,5,"png","qx","qx/decoration/Modern/table-combined.png",0,0],"qx/decoration/Modern/table/boolean-false.png":[14,14,"png","qx","qx/decoration/Modern/table-combined.png",-80,0],"qx/decoration/Modern/table/boolean-true.png":[14,14,"png","qx","qx/decoration/Modern/table-combined.png",-26,0],"qx/decoration/Modern/table/descending.png":[8,5,"png","qx","qx/decoration/Modern/table-combined.png",-18,0],"qx/decoration/Modern/table/header-cell.png":[40,18,"png","qx","qx/decoration/Modern/table-combined.png",-40,0],"qx/decoration/Modern/table/select-column-order.png":[10,9,"png","qx","qx/decoration/Modern/table-combined.png",-8,0],"qx/decoration/Modern/tabview-button-bottom-active-lr-combined.png":[10,14,"png","qx"],"qx/decoration/Modern/tabview-button-bottom-active-tb-combined.png":[5,30,"png","qx"],"qx/decoration/Modern/tabview-button-bottom-inactive-b-combined.png":[3,9,"png","qx"],"qx/decoration/Modern/tabview-button-bottom-inactive-lr-combined.png":[6,15,"png","qx"],"qx/decoration/Modern/tabview-button-bottom-inactive-t-combined.png":[3,9,"png","qx"],"qx/decoration/Modern/tabview-button-left-active-lr-combined.png":[10,37,"png","qx"],"qx/decoration/Modern/tabview-button-left-active-tb-combined.png":[5,30,"png","qx"],"qx/decoration/Modern/tabview-button-left-inactive-b-combined.png":[3,9,"png","qx"],"qx/decoration/Modern/tabview-button-left-inactive-lr-combined.png":[6,39,"png","qx"],"qx/decoration/Modern/tabview-button-left-inactive-t-combined.png":[3,9,"png","qx"],"qx/decoration/Modern/tabview-button-right-active-lr-combined.png":[10,37,"png","qx"],"qx/decoration/Modern/tabview-button-right-active-tb-combined.png":[5,30,"png","qx"],"qx/decoration/Modern/tabview-button-right-inactive-b-combined.png":[3,9,"png","qx"],"qx/decoration/Modern/tabview-button-right-inactive-lr-combined.png":[6,39,"png","qx"],"qx/decoration/Modern/tabview-button-right-inactive-t-combined.png":[3,9,"png","qx"],"qx/decoration/Modern/tabview-button-top-active-lr-combined.png":[10,12,"png","qx"],"qx/decoration/Modern/tabview-button-top-active-tb-combined.png":[5,30,"png","qx"],"qx/decoration/Modern/tabview-button-top-inactive-b-combined.png":[3,9,"png","qx"],"qx/decoration/Modern/tabview-button-top-inactive-lr-combined.png":[6,15,"png","qx"],"qx/decoration/Modern/tabview-button-top-inactive-t-combined.png":[3,9,"png","qx"],"qx/decoration/Modern/tabview-pane-lr-combined.png":[60,2,"png","qx"],"qx/decoration/Modern/tabview-pane-tb-combined.png":[30,180,"png","qx"],"qx/decoration/Modern/tabview/tab-button-bottom-active-b.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-bottom-active-tb-combined.png",0,-10],"qx/decoration/Modern/tabview/tab-button-bottom-active-bl.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-bottom-active-tb-combined.png",0,-15],"qx/decoration/Modern/tabview/tab-button-bottom-active-br.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-bottom-active-tb-combined.png",0,-5],"qx/decoration/Modern/tabview/tab-button-bottom-active-c.png":[40,14,"png","qx"],"qx/decoration/Modern/tabview/tab-button-bottom-active-l.png":[5,14,"png","qx","qx/decoration/Modern/tabview-button-bottom-active-lr-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-bottom-active-r.png":[5,14,"png","qx","qx/decoration/Modern/tabview-button-bottom-active-lr-combined.png",-5,0],"qx/decoration/Modern/tabview/tab-button-bottom-active-t.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-bottom-active-tb-combined.png",0,-20],"qx/decoration/Modern/tabview/tab-button-bottom-active-tl.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-bottom-active-tb-combined.png",0,-25],"qx/decoration/Modern/tabview/tab-button-bottom-active-tr.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-bottom-active-tb-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-bottom-active.png":[49,24,"png","qx"],"qx/decoration/Modern/tabview/tab-button-bottom-inactive-b.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-bottom-inactive-b-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-bottom-inactive-bl.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-bottom-inactive-b-combined.png",0,-6],"qx/decoration/Modern/tabview/tab-button-bottom-inactive-br.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-bottom-inactive-b-combined.png",0,-3],"qx/decoration/Modern/tabview/tab-button-bottom-inactive-c.png":[40,15,"png","qx"],"qx/decoration/Modern/tabview/tab-button-bottom-inactive-l.png":[3,15,"png","qx","qx/decoration/Modern/tabview-button-bottom-inactive-lr-combined.png",-3,0],"qx/decoration/Modern/tabview/tab-button-bottom-inactive-r.png":[3,15,"png","qx","qx/decoration/Modern/tabview-button-bottom-inactive-lr-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-bottom-inactive-t.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-bottom-inactive-t-combined.png",0,-3],"qx/decoration/Modern/tabview/tab-button-bottom-inactive-tl.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-bottom-inactive-t-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-bottom-inactive-tr.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-bottom-inactive-t-combined.png",0,-6],"qx/decoration/Modern/tabview/tab-button-bottom-inactive.png":[45,21,"png","qx"],"qx/decoration/Modern/tabview/tab-button-left-active-b.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-left-active-tb-combined.png",0,-5],"qx/decoration/Modern/tabview/tab-button-left-active-bl.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-left-active-tb-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-left-active-br.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-left-active-tb-combined.png",0,-25],"qx/decoration/Modern/tabview/tab-button-left-active-c.png":[40,37,"png","qx"],"qx/decoration/Modern/tabview/tab-button-left-active-l.png":[5,37,"png","qx","qx/decoration/Modern/tabview-button-left-active-lr-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-left-active-r.png":[5,37,"png","qx","qx/decoration/Modern/tabview-button-left-active-lr-combined.png",-5,0],"qx/decoration/Modern/tabview/tab-button-left-active-t.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-left-active-tb-combined.png",0,-15],"qx/decoration/Modern/tabview/tab-button-left-active-tl.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-left-active-tb-combined.png",0,-10],"qx/decoration/Modern/tabview/tab-button-left-active-tr.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-left-active-tb-combined.png",0,-20],"qx/decoration/Modern/tabview/tab-button-left-active.png":[22,47,"png","qx"],"qx/decoration/Modern/tabview/tab-button-left-inactive-b.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-left-inactive-b-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-left-inactive-bl.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-left-inactive-b-combined.png",0,-6],"qx/decoration/Modern/tabview/tab-button-left-inactive-br.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-left-inactive-b-combined.png",0,-3],"qx/decoration/Modern/tabview/tab-button-left-inactive-c.png":[40,39,"png","qx"],"qx/decoration/Modern/tabview/tab-button-left-inactive-l.png":[3,39,"png","qx","qx/decoration/Modern/tabview-button-left-inactive-lr-combined.png",-3,0],"qx/decoration/Modern/tabview/tab-button-left-inactive-r.png":[3,39,"png","qx","qx/decoration/Modern/tabview-button-left-inactive-lr-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-left-inactive-t.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-left-inactive-t-combined.png",0,-3],"qx/decoration/Modern/tabview/tab-button-left-inactive-tl.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-left-inactive-t-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-left-inactive-tr.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-left-inactive-t-combined.png",0,-6],"qx/decoration/Modern/tabview/tab-button-left-inactive.png":[20,45,"png","qx"],"qx/decoration/Modern/tabview/tab-button-right-active-b.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-right-active-tb-combined.png",0,-25],"qx/decoration/Modern/tabview/tab-button-right-active-bl.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-right-active-tb-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-right-active-br.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-right-active-tb-combined.png",0,-20],"qx/decoration/Modern/tabview/tab-button-right-active-c.png":[40,37,"png","qx"],"qx/decoration/Modern/tabview/tab-button-right-active-l.png":[5,37,"png","qx","qx/decoration/Modern/tabview-button-right-active-lr-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-right-active-r.png":[5,37,"png","qx","qx/decoration/Modern/tabview-button-right-active-lr-combined.png",-5,0],"qx/decoration/Modern/tabview/tab-button-right-active-t.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-right-active-tb-combined.png",0,-5],"qx/decoration/Modern/tabview/tab-button-right-active-tl.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-right-active-tb-combined.png",0,-15],"qx/decoration/Modern/tabview/tab-button-right-active-tr.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-right-active-tb-combined.png",0,-10],"qx/decoration/Modern/tabview/tab-button-right-active.png":[22,47,"png","qx"],"qx/decoration/Modern/tabview/tab-button-right-inactive-b.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-right-inactive-b-combined.png",0,-3],"qx/decoration/Modern/tabview/tab-button-right-inactive-bl.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-right-inactive-b-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-right-inactive-br.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-right-inactive-b-combined.png",0,-6],"qx/decoration/Modern/tabview/tab-button-right-inactive-c.png":[40,39,"png","qx"],"qx/decoration/Modern/tabview/tab-button-right-inactive-l.png":[3,39,"png","qx","qx/decoration/Modern/tabview-button-right-inactive-lr-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-right-inactive-r.png":[3,39,"png","qx","qx/decoration/Modern/tabview-button-right-inactive-lr-combined.png",-3,0],"qx/decoration/Modern/tabview/tab-button-right-inactive-t.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-right-inactive-t-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-right-inactive-tl.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-right-inactive-t-combined.png",0,-3],"qx/decoration/Modern/tabview/tab-button-right-inactive-tr.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-right-inactive-t-combined.png",0,-6],"qx/decoration/Modern/tabview/tab-button-right-inactive.png":[20,45,"png","qx"],"qx/decoration/Modern/tabview/tab-button-top-active-b.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-top-active-tb-combined.png",0,-20],"qx/decoration/Modern/tabview/tab-button-top-active-bl.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-top-active-tb-combined.png",0,-15],"qx/decoration/Modern/tabview/tab-button-top-active-br.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-top-active-tb-combined.png",0,-10],"qx/decoration/Modern/tabview/tab-button-top-active-c.png":[40,14,"png","qx"],"qx/decoration/Modern/tabview/tab-button-top-active-l.png":[5,12,"png","qx","qx/decoration/Modern/tabview-button-top-active-lr-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-top-active-r.png":[5,12,"png","qx","qx/decoration/Modern/tabview-button-top-active-lr-combined.png",-5,0],"qx/decoration/Modern/tabview/tab-button-top-active-t.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-top-active-tb-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-top-active-tl.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-top-active-tb-combined.png",0,-25],"qx/decoration/Modern/tabview/tab-button-top-active-tr.png":[5,5,"png","qx","qx/decoration/Modern/tabview-button-top-active-tb-combined.png",0,-5],"qx/decoration/Modern/tabview/tab-button-top-active.png":[48,22,"png","qx"],"qx/decoration/Modern/tabview/tab-button-top-inactive-b.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-top-inactive-b-combined.png",0,-6],"qx/decoration/Modern/tabview/tab-button-top-inactive-bl.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-top-inactive-b-combined.png",0,-3],"qx/decoration/Modern/tabview/tab-button-top-inactive-br.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-top-inactive-b-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-top-inactive-c.png":[40,15,"png","qx"],"qx/decoration/Modern/tabview/tab-button-top-inactive-l.png":[3,15,"png","qx","qx/decoration/Modern/tabview-button-top-inactive-lr-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-top-inactive-r.png":[3,15,"png","qx","qx/decoration/Modern/tabview-button-top-inactive-lr-combined.png",-3,0],"qx/decoration/Modern/tabview/tab-button-top-inactive-t.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-top-inactive-t-combined.png",0,-3],"qx/decoration/Modern/tabview/tab-button-top-inactive-tl.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-top-inactive-t-combined.png",0,0],"qx/decoration/Modern/tabview/tab-button-top-inactive-tr.png":[3,3,"png","qx","qx/decoration/Modern/tabview-button-top-inactive-t-combined.png",0,-6],"qx/decoration/Modern/tabview/tab-button-top-inactive.png":[45,21,"png","qx"],"qx/decoration/Modern/tabview/tabview-pane-b.png":[30,30,"png","qx","qx/decoration/Modern/tabview-pane-tb-combined.png",0,-60],"qx/decoration/Modern/tabview/tabview-pane-bl.png":[30,30,"png","qx","qx/decoration/Modern/tabview-pane-tb-combined.png",0,0],"qx/decoration/Modern/tabview/tabview-pane-br.png":[30,30,"png","qx","qx/decoration/Modern/tabview-pane-tb-combined.png",0,-120],"qx/decoration/Modern/tabview/tabview-pane-c.png":[40,120,"png","qx"],"qx/decoration/Modern/tabview/tabview-pane-l.png":[30,2,"png","qx","qx/decoration/Modern/tabview-pane-lr-combined.png",0,0],"qx/decoration/Modern/tabview/tabview-pane-r.png":[30,2,"png","qx","qx/decoration/Modern/tabview-pane-lr-combined.png",-30,0],"qx/decoration/Modern/tabview/tabview-pane-t.png":[30,30,"png","qx","qx/decoration/Modern/tabview-pane-tb-combined.png",0,-150],"qx/decoration/Modern/tabview/tabview-pane-tl.png":[30,30,"png","qx","qx/decoration/Modern/tabview-pane-tb-combined.png",0,-30],"qx/decoration/Modern/tabview/tabview-pane-tr.png":[30,30,"png","qx","qx/decoration/Modern/tabview-pane-tb-combined.png",0,-90],"qx/decoration/Modern/tabview/tabview-pane.png":[185,250,"png","qx"],"qx/decoration/Modern/toolbar-combined.png":[80,130,"png","qx"],"qx/decoration/Modern/toolbar/toolbar-gradient-blue.png":[40,130,"png","qx","qx/decoration/Modern/toolbar-combined.png",-40,0],"qx/decoration/Modern/toolbar/toolbar-gradient.png":[40,130,"png","qx","qx/decoration/Modern/toolbar-combined.png",0,0],"qx/decoration/Modern/toolbar/toolbar-handle-knob.gif":[1,8,"gif","qx"],"qx/decoration/Modern/toolbar/toolbar-part.gif":[7,1,"gif","qx"],"qx/decoration/Modern/tooltip-error-lr-combined.png":[12,18,"png","qx"],"qx/decoration/Modern/tooltip-error-tb-combined.png":[6,36,"png","qx"],"qx/decoration/Modern/tree-combined.png":[32,8,"png","qx"],"qx/decoration/Modern/tree/closed-selected.png":[8,8,"png","qx","qx/decoration/Modern/tree-combined.png",-24,0],"qx/decoration/Modern/tree/closed.png":[8,8,"png","qx","qx/decoration/Modern/tree-combined.png",-16,0],"qx/decoration/Modern/tree/open-selected.png":[8,8,"png","qx","qx/decoration/Modern/tree-combined.png",-8,0],"qx/decoration/Modern/tree/open.png":[8,8,"png","qx","qx/decoration/Modern/tree-combined.png",0,0],"qx/decoration/Modern/window-captionbar-buttons-combined.png":[108,9,"png","qx"],"qx/decoration/Modern/window-captionbar-lr-active-combined.png":[12,9,"png","qx"],"qx/decoration/Modern/window-captionbar-lr-inactive-combined.png":[12,9,"png","qx"],"qx/decoration/Modern/window-captionbar-tb-active-combined.png":[6,36,"png","qx"],"qx/decoration/Modern/window-captionbar-tb-inactive-combined.png":[6,36,"png","qx"],"qx/decoration/Modern/window-statusbar-lr-combined.png":[8,7,"png","qx"],"qx/decoration/Modern/window-statusbar-tb-combined.png":[4,24,"png","qx"],"qx/decoration/Modern/window/captionbar-active-b.png":[6,6,"png","qx","qx/decoration/Modern/window-captionbar-tb-active-combined.png",0,-18],"qx/decoration/Modern/window/captionbar-active-bl.png":[6,6,"png","qx","qx/decoration/Modern/window-captionbar-tb-active-combined.png",0,-24],"qx/decoration/Modern/window/captionbar-active-br.png":[6,6,"png","qx","qx/decoration/Modern/window-captionbar-tb-active-combined.png",0,-12],"qx/decoration/Modern/window/captionbar-active-c.png":[40,9,"png","qx"],"qx/decoration/Modern/window/captionbar-active-l.png":[6,9,"png","qx","qx/decoration/Modern/window-captionbar-lr-active-combined.png",-6,0],"qx/decoration/Modern/window/captionbar-active-r.png":[6,9,"png","qx","qx/decoration/Modern/window-captionbar-lr-active-combined.png",0,0],"qx/decoration/Modern/window/captionbar-active-t.png":[6,6,"png","qx","qx/decoration/Modern/window-captionbar-tb-active-combined.png",0,-6],"qx/decoration/Modern/window/captionbar-active-tl.png":[6,6,"png","qx","qx/decoration/Modern/window-captionbar-tb-active-combined.png",0,0],"qx/decoration/Modern/window/captionbar-active-tr.png":[6,6,"png","qx","qx/decoration/Modern/window-captionbar-tb-active-combined.png",0,-30],"qx/decoration/Modern/window/captionbar-active.png":[69,21,"png","qx"],"qx/decoration/Modern/window/captionbar-inactive-b.png":[6,6,"png","qx","qx/decoration/Modern/window-captionbar-tb-inactive-combined.png",0,-24],"qx/decoration/Modern/window/captionbar-inactive-bl.png":[6,6,"png","qx","qx/decoration/Modern/window-captionbar-tb-inactive-combined.png",0,-6],"qx/decoration/Modern/window/captionbar-inactive-br.png":[6,6,"png","qx","qx/decoration/Modern/window-captionbar-tb-inactive-combined.png",0,-30],"qx/decoration/Modern/window/captionbar-inactive-c.png":[40,9,"png","qx"],"qx/decoration/Modern/window/captionbar-inactive-l.png":[6,9,"png","qx","qx/decoration/Modern/window-captionbar-lr-inactive-combined.png",0,0],"qx/decoration/Modern/window/captionbar-inactive-r.png":[6,9,"png","qx","qx/decoration/Modern/window-captionbar-lr-inactive-combined.png",-6,0],"qx/decoration/Modern/window/captionbar-inactive-t.png":[6,6,"png","qx","qx/decoration/Modern/window-captionbar-tb-inactive-combined.png",0,0],"qx/decoration/Modern/window/captionbar-inactive-tl.png":[6,6,"png","qx","qx/decoration/Modern/window-captionbar-tb-inactive-combined.png",0,-12],"qx/decoration/Modern/window/captionbar-inactive-tr.png":[6,6,"png","qx","qx/decoration/Modern/window-captionbar-tb-inactive-combined.png",0,-18],"qx/decoration/Modern/window/captionbar-inactive.png":[69,21,"png","qx"],"qx/decoration/Modern/window/close-active-hovered.png":[9,9,"png","qx","qx/decoration/Modern/window-captionbar-buttons-combined.png",-27,0],"qx/decoration/Modern/window/close-active.png":[9,9,"png","qx","qx/decoration/Modern/window-captionbar-buttons-combined.png",-9,0],"qx/decoration/Modern/window/close-inactive.png":[9,9,"png","qx","qx/decoration/Modern/window-captionbar-buttons-combined.png",-90,0],"qx/decoration/Modern/window/maximize-active-hovered.png":[9,9,"png","qx","qx/decoration/Modern/window-captionbar-buttons-combined.png",-18,0],"qx/decoration/Modern/window/maximize-active.png":[9,9,"png","qx","qx/decoration/Modern/window-captionbar-buttons-combined.png",-81,0],"qx/decoration/Modern/window/maximize-inactive.png":[9,9,"png","qx","qx/decoration/Modern/window-captionbar-buttons-combined.png",-54,0],"qx/decoration/Modern/window/minimize-active-hovered.png":[9,9,"png","qx","qx/decoration/Modern/window-captionbar-buttons-combined.png",-63,0],"qx/decoration/Modern/window/minimize-active.png":[9,9,"png","qx","qx/decoration/Modern/window-captionbar-buttons-combined.png",-72,0],"qx/decoration/Modern/window/minimize-inactive.png":[9,9,"png","qx","qx/decoration/Modern/window-captionbar-buttons-combined.png",-36,0],"qx/decoration/Modern/window/restore-active-hovered.png":[9,8,"png","qx","qx/decoration/Modern/window-captionbar-buttons-combined.png",0,0],"qx/decoration/Modern/window/restore-active.png":[9,8,"png","qx","qx/decoration/Modern/window-captionbar-buttons-combined.png",-99,0],"qx/decoration/Modern/window/restore-inactive.png":[9,8,"png","qx","qx/decoration/Modern/window-captionbar-buttons-combined.png",-45,0],"qx/decoration/Modern/window/statusbar-b.png":[4,4,"png","qx","qx/decoration/Modern/window-statusbar-tb-combined.png",0,-16],"qx/decoration/Modern/window/statusbar-bl.png":[4,4,"png","qx","qx/decoration/Modern/window-statusbar-tb-combined.png",0,-20],"qx/decoration/Modern/window/statusbar-br.png":[4,4,"png","qx","qx/decoration/Modern/window-statusbar-tb-combined.png",0,-4],"qx/decoration/Modern/window/statusbar-c.png":[40,7,"png","qx"],"qx/decoration/Modern/window/statusbar-l.png":[4,7,"png","qx","qx/decoration/Modern/window-statusbar-lr-combined.png",-4,0],"qx/decoration/Modern/window/statusbar-r.png":[4,7,"png","qx","qx/decoration/Modern/window-statusbar-lr-combined.png",0,0],"qx/decoration/Modern/window/statusbar-t.png":[4,4,"png","qx","qx/decoration/Modern/window-statusbar-tb-combined.png",0,0],"qx/decoration/Modern/window/statusbar-tl.png":[4,4,"png","qx","qx/decoration/Modern/window-statusbar-tb-combined.png",0,-8],"qx/decoration/Modern/window/statusbar-tr.png":[4,4,"png","qx","qx/decoration/Modern/window-statusbar-tb-combined.png",0,-12],"qx/decoration/Modern/window/statusbar.png":[369,15,"png","qx"],"qx/icon/Oxygen/16/actions/dialog-cancel.png":[16,16,"png","qx"],"qx/icon/Oxygen/16/actions/dialog-ok.png":[16,16,"png","qx"],"qx/icon/Oxygen/16/actions/view-refresh.png":[16,16,"png","qx"],"qx/icon/Oxygen/16/actions/window-close.png":[16,16,"png","qx"],"qx/icon/Oxygen/16/apps/office-calendar.png":[16,16,"png","qx"],"qx/icon/Oxygen/16/mimetypes/text-plain.png":[16,16,"png","qx"],"qx/icon/Oxygen/16/places/folder-open.png":[16,16,"png","qx"],"qx/icon/Oxygen/16/places/folder.png":[16,16,"png","qx"],"qx/icon/Tango/16/actions/dialog-cancel.png":[16,16,"png","qx"],"qx/icon/Tango/16/actions/dialog-ok.png":[16,16,"png","qx"],"qx/icon/Tango/16/actions/view-refresh.png":[16,16,"png","qx"],"qx/icon/Tango/16/actions/window-close.png":[16,16,"png","qx"],"qx/icon/Tango/16/apps/office-calendar.png":[16,16,"png","qx"],"qx/icon/Tango/16/apps/utilities-color-chooser.png":[16,16,"png","qx"],"qx/icon/Tango/16/mimetypes/office-document.png":[16,16,"png","qx"],"qx/icon/Tango/16/places/folder-open.png":[16,16,"png","qx"],"qx/icon/Tango/16/places/folder.png":[16,16,"png","qx"],"qx/icon/Tango/22/mimetypes/office-document.png":[22,22,"png","qx"],"qx/icon/Tango/22/places/folder-open.png":[22,22,"png","qx"],"qx/icon/Tango/22/places/folder.png":[22,22,"png","qx"],"qx/icon/Tango/32/mimetypes/office-document.png":[32,32,"png","qx"],"qx/icon/Tango/32/places/folder-open.png":[32,32,"png","qx"],"qx/icon/Tango/32/places/folder.png":[32,32,"png","qx"],"qx/static/blank.gif":[1,1,"gif","qx"],"qx/static/blank.html":"qx"},"translations":{"C":{},"de":{"%1 does not fit %2.":"%1 passt nicht zu %2.","%1 is not a color! %2":"%1 ist keine Farbe! %2","%1 is not a number.":"%1 ist keine Nummer.","%1 is not a string.":"%1 ist keine Zeichenkette.","%1 is not an url.":"%1 ist keine URL.","%1 is not in %2":"%1 ist nicht in %2","%1 is not in the range from [%2, %3].":"%1 liegt nicht im Intervall [%2, %3].","%1 of %2 rows":"%1 von %2 Zeilen","%1 rows":"%1 Zeilen","'%1' is not an email address.":"'%1' ist keine Emailadresse.","Automatic":"Automatisch","Cancel":"Abbruch","Color Selector":"Farbauswahl","Details":"Details","HSB":"HSB","Hex":"Hex","Last month":"Vorheriger Monat","Last year":"Vorheriges Jahr","Next month":"Nächster Monat","Next year":"Nächstes Jahr","OK":"OK","Open ColorSelector":"Öffne Farbauswahl","Presets":"Voreinstellungen","Preview (Old/New)":"Vorschau (alt/neu)","RGB":"RGB","Reset column widths":"Spaltenbreite zurücksetzen","This field is required":"Dieses Feld ist erforderlich","Visual":"Visuell","key_full_Alt":"Alt","key_full_Apps":"Kontextmenü","key_full_Backspace":"Rücktaste","key_full_CapsLock":"Feststelltaste","key_full_Control":"Steuerung","key_full_Delete":"Entfernen","key_full_Down":"Pfeil runter","key_full_End":"Ende","key_full_Enter":"Enter","key_full_Escape":"Escape","key_full_Home":"Position 1","key_full_Insert":"Einfügen","key_full_Left":"Pfeil links","key_full_Meta":"Meta","key_full_NumLock":"NumLock","key_full_PageDown":"Bild runter","key_full_PageUp":"Bild hoch","key_full_Pause":"Pause","key_full_PrintScreen":"Drucken","key_full_Right":"Pfeil rechts","key_full_Scroll":"Rollen","key_full_Shift":"Umschalttaste","key_full_Space":"Leertaste","key_full_Tab":"Tabulator","key_full_Up":"Pfeil hoch","key_full_Win":"Windowstaste","key_short_Alt":"Alt","key_short_Apps":"Kontext","key_short_Backspace":"Rück","key_short_CapsLock":"Feststell","key_short_Control":"Strg","key_short_Delete":"Entf","key_short_Down":"Runter","key_short_End":"Ende","key_short_Enter":"Enter","key_short_Escape":"Esc","key_short_Home":"Pos1","key_short_Insert":"Einfg","key_short_Left":"Links","key_short_Meta":"Meta","key_short_NumLock":"Num","key_short_PageDown":"Bild runter","key_short_PageUp":"Bild hoch","key_short_Pause":"Pause","key_short_PrintScreen":"Druck","key_short_Right":"Rechts","key_short_Scroll":"Rollen","key_short_Shift":"Umschalt","key_short_Space":"Leer","key_short_Tab":"Tab","key_short_Up":"Hoch","key_short_Win":"Win","one of one row":"Eine von einer Zeile","one row":"Eine Zeile"},"en":{},"es":{"%1 does not fit %2.":"%1 no corresponde con %2.","%1 is not a color! %2":"%1 no es un color! %2","%1 is not a number.":"%1 no es un número.","%1 is not a string.":"%1 no es una cadena de caracteres.","%1 is not an url.":"%1 no es un url.","%1 is not in %2":"%1 no se encuentra en %2","%1 is not in the range from [%2, %3].":"%1 no se encuentra en el rango [%2, %3].","%1 of %2 rows":"%1 de %2 filas","%1 rows":"%1 filas","'%1' is not an email address.":"'%1' no es un correo electrónico.","Automatic":"Automático","Cancel":"Cancelar","Color Selector":"Selector de color","Details":"Detalles","HSB":"HSB","Hex":"Hex","Last month":"Último mes","Last year":"Último año","Next month":"Mes siguiente","Next year":"Año siguiente","OK":"Aceptar","Open ColorSelector":"Abrir Selector de Color","Presets":"Preselecciones","Preview (Old/New)":"Vista previa (Viejo/Nuevo)","RGB":"RGB","Reset column widths":"Reestablecer anchos de columnas","This field is required":"Este cuadro es obligatorio","Visual":"Visual","key_full_Alt":"Alt","key_full_Apps":"Aplicaciones","key_full_Backspace":"Retroceso","key_full_CapsLock":"Bloqueo Mayúsculas","key_full_Control":"Control","key_full_Delete":"Suprimir","key_full_Down":"Flecha abajo","key_full_End":"Fin","key_full_Enter":"Intro","key_full_Escape":"Escape","key_full_Home":"Inicio","key_full_Insert":"Insertar","key_full_Left":"Flecha izquierda","key_full_Meta":"Meta","key_full_NumLock":"Bloqueo Numérico","key_full_PageDown":"Avanzar Página","key_full_PageUp":"Retroceder Página","key_full_Pause":"Pausa","key_full_PrintScreen":"Imprimir Pantalla","key_full_Right":"Flecha derecha","key_full_Scroll":"Bloq. Despl.","key_full_Shift":"Mayúscula","key_full_Space":"Espacio","key_full_Tab":"Tabulador","key_full_Up":"Flecha arriba","key_full_Win":"Windows","key_short_Alt":"Alt","key_short_Apps":"Aplic","key_short_Backspace":"Retroceso","key_short_CapsLock":"BloqMayús","key_short_Control":"Ctrl","key_short_Control_Mac":"Ctrl","key_short_Delete":"Supr","key_short_Down":"Abajo","key_short_End":"Fin","key_short_Enter":"Intro","key_short_Escape":"Esc","key_short_Home":"Inicio","key_short_Insert":"Insert","key_short_Left":"Izquierda","key_short_Meta":"Meta","key_short_NumLock":"BloqNum","key_short_PageDown":"AvPág","key_short_PageUp":"RePág","key_short_Pause":"Pausa","key_short_PrintScreen":"ImprPant","key_short_Right":"Derecha","key_short_Scroll":"BloqDespl","key_short_Shift":"Mayús","key_short_Space":"Espacio","key_short_Tab":"Tab","key_short_Up":"Arriba","key_short_Win":"Win","one of one row":"una de una fila","one row":"una fila"},"fr":{"%1 does not fit %2.":"%1 ne correspond pas à %2.","%1 is not a color! %2":"%1 n'est pas une couleur ! %2","%1 is not a number.":"%1 n'est pas un chiffre.","%1 is not a string.":"%1 n'est pas une chaîne de caractères.","%1 is not an url.":"%1 n'est pas un URL.","%1 is not in %2":"%1 n'est pas dans %2","%1 is not in the range from [%2, %3].":"%1 n'est pas dans l'intervalle [%2, %3].","%1 of %2 rows":"ligne %1 de %2","%1 rows":"%1 lignes","'%1' is not an email address.":"'%1'n'est pas une adresse email.","Automatic":"Automatique","Cancel":"Annuler","Color Selector":"Sélecteur de couleurs","Details":"Détails","HSB":"TSV","Hex":"Hex","Last month":"Mois dernier","Last year":"Année dernière","Next month":"Mois prochain","Next year":"Année prochaine","OK":"OK","Open ColorSelector":"Ouvrir le sélecteur de couleurs","Presets":"Pré-réglages","Preview (Old/New)":"Aperçu (Ancien/Nouveau)","RGB":"RVB","Reset column widths":"Réinitialiser la largeur des colonnes","This field is required":"ce champ est requis","key_full_Alt":"Alternative","key_full_Apps":"Application","key_full_Backspace":"Effacement arrière","key_full_CapsLock":"Verrouillage des Majuscule","key_full_Control":"Contrôle","key_full_Delete":"Suppression","key_full_Down":"Bas","key_full_End":"Fin","key_full_Enter":"Entrée","key_full_Escape":"Échappement","key_full_Home":"Origine","key_full_Insert":"Insertion","key_full_Left":"Gauche","key_full_Meta":"Meta","key_full_NumLock":"Verouillage Numérique","key_full_PageDown":"Page Suivante","key_full_PageUp":"Page Précédente","key_full_Pause":"Pause","key_full_PrintScreen":"Impression de l'écran","key_full_Right":"Droite","key_full_Scroll":"Arrêt défilement","key_full_Shift":"Majuscules","key_full_Space":"Espace","key_full_Tab":"Tabulation","key_full_Up":"Haut","key_full_Win":"Windows","key_short_Alt":"Alt","key_short_Apps":"App.","key_short_Backspace":"Effacement Arrière","key_short_CapsLock":"Verr. Maj.","key_short_Control":"Ctrl","key_short_Delete":"Supp.","key_short_Down":"Bas","key_short_End":"Fin","key_short_Enter":"Entrée","key_short_Escape":"Echap.","key_short_Home":"Orig.","key_short_Insert":"Ins.","key_short_Left":"Gauche","key_short_Meta":"Meta","key_short_NumLock":"Verr. Num.","key_short_PageDown":"Pg Suiv.","key_short_PageUp":"Pg Préc.","key_short_Pause":"Pause","key_short_PrintScreen":"Imp. Écran","key_short_Right":"Droite","key_short_Scroll":"Arrêt Défil","key_short_Shift":"Maj","key_short_Space":"Espace","key_short_Tab":"Tab","key_short_Up":"Haut","key_short_Win":"Win","one of one row":"ligne une de une","one row":"une ligne"},"it":{"%1 does not fit %2.":"%1 non corrisponde a %2.","%1 is not a color! %2":"%1 non è un colore! %2","%1 is not a number.":"%1 non è un numero.","%1 is not a string.":"%1 non è una stringa.","%1 is not an url.":"%1 non è un url.","%1 is not in %2":"%1 non è contenuto in %2","%1 is not in the range from [%2, %3].":"%1 non è compreso nell'intervallo [%2, %3].","%1 of %2 rows":"%1 di %2 righe","%1 rows":"%1 righe","'%1' is not an email address.":"'%1' non è un indirizzo email.","Automatic":"Automatico","Cancel":"Annulla","Color Selector":"Selettore dei Colori","Details":"Dettagli","HSB":"TSL","Hex":"Hex","Last month":"Mese precedente","Last year":"Anno precedente","Next month":"Mese successivo","Next year":"Anno successivo","OK":"OK","Open ColorSelector":"Apri il Selettore dei Colori","Presets":"Predefiniti","Preview (Old/New)":"Anteprima (Vecchio/Nuovo)","RGB":"RGB","Reset column widths":"Ripristina le larghezze delle colonne","This field is required":"Questo campo è obbligatorio","Visual":"Selezione visuale","key_full_Alt":"Alt","key_full_Apps":"Tasto Menu","key_full_Backspace":"Backspace","key_full_CapsLock":"Blocca Maiuscole","key_full_Control":"Control","key_full_Delete":"Cancella","key_full_Down":"Freccia Giù","key_full_End":"Fine","key_full_Enter":"Invio","key_full_Escape":"Escape","key_full_Home":"Inizio","key_full_Insert":"Inserisci","key_full_Left":"Freccia Sinistra","key_full_Meta":"Meta","key_full_NumLock":"Blocca Numeri","key_full_PageDown":"Pagina Giù","key_full_PageUp":"Pagina Su","key_full_Pause":"Pausa","key_full_PrintScreen":"Stampa Schermo","key_full_Right":"Freccia Destra","key_full_Scroll":"Blocca Scorrimento","key_full_Shift":"Maiuscole","key_full_Space":"Spazio","key_full_Tab":"Tabulazione","key_full_Up":"Freccia Su","key_full_Win":"Tasto Windows","key_short_Alt":"Alt","key_short_Apps":"Menu","key_short_Backspace":"Backspace","key_short_CapsLock":"Bloc Maiusc","key_short_Control":"Ctrl","key_short_Delete":"Canc","key_short_Down":"Giù","key_short_End":"Fine","key_short_Enter":"Invio","key_short_Escape":"Esc","key_short_Home":"Inizio","key_short_Insert":"Ins","key_short_Left":"Sinistra","key_short_Meta":"Meta","key_short_NumLock":"Bloc Num","key_short_PageDown":"Pag Giù","key_short_PageUp":"Pag Su","key_short_Pause":"Pausa","key_short_PrintScreen":"Stamp","key_short_Right":"Destra","key_short_Scroll":"Bloc Scorr","key_short_Shift":"Maiusc","key_short_Space":"Spazio","key_short_Tab":"Tab","key_short_Up":"Su","key_short_Win":"Win","one of one row":"una di una riga","one row":"una riga"},"nl":{"%1 does not fit %2.":"%1 past niet %2.","%1 is not a color! %2":"%1 is geen kleur! %2","%1 is not a number.":"%1 is geen nummer.","%1 is not a string.":"%1 is geen string.","%1 is not an url.":"%1 is geen url.","%1 is not in %2":"%1 is niet in %2","%1 is not in the range from [%2, %3].":"%1 is niet in het bereik van [%2, %3].","%1 of %2 rows":"%1 van %2 rijen","%1 rows":"%1 rijen","'%1' is not an email address.":"'%1' is geen email adres.","Automatic":"Automatisch","Cancel":"Annuleer","Color Selector":"Kleur-instelling","Details":"Details","HSB":"HSB","Hex":"Hex","Last month":"Laatste maand","Last year":"Laatste jaar","Next month":"Volgende maand","Next year":"Volgend jaar","OK":"OK","Open ColorSelector":"Open Kleurkiezer","Presets":"Voorkeuren","Preview (Old/New)":"Voorbeeld (Oud/Nieuw)","RGB":"RGB","Reset column widths":"Kolombreedte herstellen","This field is required":"Dit veld is verplicht","Visual":"Visueel","key_full_Alt":"Alt","key_full_Apps":"Contextmenu","key_full_Backspace":"Backspace","key_full_CapsLock":"Caps Lock","key_full_Control":"Control","key_full_Delete":"Verwijderen","key_full_Down":"Pijl omlaag","key_full_End":"End","key_full_Enter":"Enter","key_full_Escape":"Escape","key_full_Home":"Positie 1","key_full_Insert":"Invoegen","key_full_Left":"Pijl links","key_full_Meta":"Meta","key_full_NumLock":"Num Lock","key_full_PageDown":"Volgende pagina","key_full_PageUp":"Vorige pagina","key_full_Pause":"Pauze","key_full_PrintScreen":"Schermafbeelding","key_full_Right":"Pijl rechts","key_full_Scroll":"Scroll Lock","key_full_Shift":"Shift","key_full_Space":"Spatiebalk","key_full_Tab":"Tabulator","key_full_Up":"Pijl omhoog","key_full_Win":"Windowstoets","key_short_Alt":"Alt","key_short_Apps":"Apps","key_short_Backspace":"Backspace","key_short_CapsLock":"Caps Lock","key_short_Control":"Ctrl","key_short_Delete":"Del","key_short_Down":"Omlaag","key_short_End":"End","key_short_Enter":"Enter","key_short_Escape":"Esc","key_short_Home":"Home","key_short_Insert":"Ins","key_short_Left":"Links","key_short_Meta":"Meta","key_short_NumLock":"Num Lock","key_short_PageDown":"PgDn","key_short_PageUp":"PgUp","key_short_Pause":"Pause","key_short_PrintScreen":"PrtSc","key_short_Right":"Rechts","key_short_Scroll":"Scroll Lock","key_short_Shift":"Shift","key_short_Space":"Spatie","key_short_Tab":"Tab","key_short_Up":"Omhoog","key_short_Win":"Win","one of one row":"Een van een rij","one row":"een rij"},"sv":{"%1 does not fit %2.":"%1 passar inte %2.","%1 is not a color! %2":"%1 är inte en färg! %2","%1 is not a number.":"%1 är inget nummer.","%1 is not a string.":"%1 är inte en sträng.","%1 is not an url.":"%1 är inte en url","%1 is not in %2":"%1 finns inte i %2","%1 is not in the range from [%2, %3].":"%1 är inte i intervallet mellan [%2, %3].","%1 of %2 rows":"%1 of %2 rader","%1 rows":"%1 rader","'%1' is not an email address.":"'%1' är inte en emailadress.","Automatic":"Automatiskt","Cancel":"Avbryt","Color Selector":"Färgväljare","Details":"Detaljer","HSB":"HSB","Hex":"Hex","Last month":"Föregående månad","Last year":"Föregående år","Next month":"Nästa månad","Next year":"Nästa år","OK":"OK","Open ColorSelector":"Öppna färgväljare","Presets":"Förinställningar","Preview (Old/New)":"Förhandsgranska (Gammal/Ny)","RGB":"RGB","Reset column widths":"Återställ kolumnbredder","This field is required":"Det här fältet måste fyllas i","Visual":"Visuell","key_full_Alt":"Alt","key_full_Apps":"Apps","key_full_Backspace":"Backspace","key_full_CapsLock":"CapsLock","key_full_Control":"Control","key_full_Delete":"Delete","key_full_Down":"Ner","key_full_End":"End","key_full_Enter":"Enter","key_full_Escape":"Escape","key_full_Home":"Home","key_full_Insert":"Insert","key_full_Left":"Vänster","key_full_Meta":"Meta","key_full_NumLock":"NumLock","key_full_PageDown":"PageDown","key_full_PageUp":"PageUp","key_full_Pause":"Pause","key_full_PrintScreen":"PrintScreen","key_full_Right":"Höger","key_full_Scroll":"Scroll","key_full_Shift":"Shift","key_full_Space":"Blanksteg","key_full_Tab":"Tabb","key_full_Up":"Upp","key_full_Win":"Win","key_short_Alt":"Alt","key_short_Apps":"Apps","key_short_Backspace":"BS","key_short_CapsLock":"Caps","key_short_Control":"CTRL","key_short_Delete":"DEL","key_short_Down":"Ner","key_short_End":"END","key_short_Enter":"Enter","key_short_Escape":"ESC","key_short_Home":"HOME","key_short_Insert":"INS","key_short_Left":"Vänster","key_short_Meta":"Meta","key_short_NumLock":"NUM","key_short_PageDown":"PGDN","key_short_PageUp":"PGUP","key_short_Pause":"Pause","key_short_PrintScreen":"PRNSCN","key_short_Right":"Höger","key_short_Scroll":"SCL","key_short_Shift":"Shift","key_short_Space":"Space","key_short_Tab":"Tabb","key_short_Up":"Upp","key_short_Win":"Win","one of one row":"en av en rad","one row":"En rad"}}};
(function(){var U="toString",T=".",S="default",R="Object",Q='"',P="Array",O="()",N="String",M="Function",L=".prototype",bu="function",bt="Boolean",bs="Error",br="constructor",bq="warn",bp="hasOwnProperty",bo="string",bn="toLocaleString",bm="RegExp",bl='\", "',bc="info",bd="BROKEN_IE",ba="isPrototypeOf",bb="Date",X="",Y="qx.Bootstrap",V="]",W="Class",be="error",bf="[Class ",bh="valueOf",bg="Number",bj="count",bi="debug",bk="ES5";if(!window.qx){window.qx={};}qx.Bootstrap={genericToString:function(){return bf+this.classname+V;},createNamespace:function(name,bW){var bY=name.split(T);var parent=window;var bX=bY[0];for(var i=0,ca=bY.length-1;i<ca;i++,bX=bY[i]){if(!parent[bX]){parent=parent[bX]={};}else{parent=parent[bX];}}parent[bX]=bW;return bX;},setDisplayName:function(h,j,name){h.displayName=j+T+name+O;},setDisplayNames:function(t,u){for(var name in t){var v=t[name];if(v instanceof Function){v.displayName=u+T+name+O;}}},define:function(name,B){if(!B){var B={statics:{}};}var G;var E=null;qx.Bootstrap.setDisplayNames(B.statics,name);if(B.members||B.extend){qx.Bootstrap.setDisplayNames(B.members,name+L);G=B.construct||new Function;if(B.extend){this.extendClass(G,G,B.extend,name,F);}var C=B.statics||{};for(var i=0,H=qx.Bootstrap.getKeys(C),l=H.length;i<l;i++){var I=H[i];G[I]=C[I];}E=G.prototype;var D=B.members||{};for(var i=0,H=qx.Bootstrap.getKeys(D),l=H.length;i<l;i++){var I=H[i];E[I]=D[I];}}else{G=B.statics||{};}var F=this.createNamespace(name,G);G.name=G.classname=name;G.basename=F;G.$$type=W;if(!G.hasOwnProperty(U)){G.toString=this.genericToString;}if(B.defer){B.defer(G,E);}qx.Bootstrap.$$registry[name]=B.statics;return G;}};qx.Bootstrap.define(Y,{statics:{LOADSTART:qx.$$start||new Date(),createNamespace:qx.Bootstrap.createNamespace,define:qx.Bootstrap.define,setDisplayName:qx.Bootstrap.setDisplayName,setDisplayNames:qx.Bootstrap.setDisplayNames,genericToString:qx.Bootstrap.genericToString,extendClass:function(m,n,o,name,p){var s=o.prototype;var r=new Function;r.prototype=s;var q=new r;m.prototype=q;q.name=q.classname=name;q.basename=p;n.base=m.superclass=o;n.self=m.constructor=q.constructor=m;},getByName:function(name){return qx.Bootstrap.$$registry[name];},$$registry:{},objectGetLength:({"count":function(e){return e.__count__;},"default":function(bR){var length=0;for(var bS in bR){length++;}return length;}})[(({}).__count__==0)?bj:S],objectMergeWith:function(ch,ci,cj){if(cj===undefined){cj=true;}for(var ck in ci){if(cj||ch[ck]===undefined){ch[ck]=ci[ck];}}return ch;},__a:[ba,bp,bn,U,bh,br],getKeys:({"ES5":Object.keys,"BROKEN_IE":function(bx){var by=[];var bA=Object.prototype.hasOwnProperty;for(var bB in bx){if(bA.call(bx,bB)){by.push(bB);}}var bz=qx.Bootstrap.__a;for(var i=0,a=bz,l=a.length;i<l;i++){if(bA.call(bx,a[i])){by.push(a[i]);}}return by;},"default":function(bC){var bD=[];var bE=Object.prototype.hasOwnProperty;for(var bF in bC){if(bE.call(bC,bF)){bD.push(bF);}}return bD;}})[typeof (Object.keys)==bu?bk:(function(){for(var cg in {toString:1}){return cg;}})()!==U?bd:S],getKeysAsString:function(bP){var bQ=qx.Bootstrap.getKeys(bP);if(bQ.length==0){return X;}return Q+bQ.join(bl)+Q;},__b:{"[object String]":N,"[object Array]":P,"[object Object]":R,"[object RegExp]":bm,"[object Number]":bg,"[object Boolean]":bt,"[object Date]":bb,"[object Function]":M,"[object Error]":bs},bind:function(bT,self,bU){var bV=Array.prototype.slice.call(arguments,2,arguments.length);return function(){var bw=Array.prototype.slice.call(arguments,0,arguments.length);return bT.apply(self,bV.concat(bw));};},firstUp:function(bv){return bv.charAt(0).toUpperCase()+bv.substr(1);},firstLow:function(y){return y.charAt(0).toLowerCase()+y.substr(1);},getClass:function(f){var g=Object.prototype.toString.call(f);return (qx.Bootstrap.__b[g]||g.slice(8,-1));},isString:function(bG){return (bG!==null&&(typeof bG===bo||qx.Bootstrap.getClass(bG)==N||bG instanceof String||(!!bG&&!!bG.$$isString)));},isArray:function(d){return (d!==null&&(d instanceof Array||(d&&qx.data&&qx.data.IListData&&qx.Bootstrap.hasInterface(d.constructor,qx.data.IListData))||qx.Bootstrap.getClass(d)==P||(!!d&&!!d.$$isArray)));},isObject:function(k){return (k!==undefined&&k!==null&&qx.Bootstrap.getClass(k)==R);},isFunction:function(bN){return qx.Bootstrap.getClass(bN)==M;},classIsDefined:function(name){return qx.Bootstrap.getByName(name)!==undefined;},getPropertyDefinition:function(bH,name){while(bH){if(bH.$$properties&&bH.$$properties[name]){return bH.$$properties[name];}bH=bH.superclass;}return null;},hasProperty:function(bO,name){return !!qx.Bootstrap.getPropertyDefinition(bO,name);},getEventType:function(cd,name){var cd=cd.constructor;while(cd.superclass){if(cd.$$events&&cd.$$events[name]!==undefined){return cd.$$events[name];}cd=cd.superclass;}return null;},supportsEvent:function(cc,name){return !!qx.Bootstrap.getEventType(cc,name);},getByInterface:function(bI,bJ){var bK,i,l;while(bI){if(bI.$$implements){bK=bI.$$flatImplements;for(i=0,l=bK.length;i<l;i++){if(bK[i]===bJ){return bI;}}}bI=bI.superclass;}return null;},hasInterface:function(b,c){return !!qx.Bootstrap.getByInterface(b,c);},getMixins:function(w){var x=[];while(w){if(w.$$includes){x.push.apply(x,w.$$flatIncludes);}w=w.superclass;}return x;},$$logs:[],debug:function(ce,cf){qx.Bootstrap.$$logs.push([bi,arguments]);},info:function(z,A){qx.Bootstrap.$$logs.push([bc,arguments]);},warn:function(J,K){qx.Bootstrap.$$logs.push([bq,arguments]);},error:function(bL,bM){qx.Bootstrap.$$logs.push([be,arguments]);},trace:function(cb){}}});})();(function(){var m="qx.allowUrlSettings",l="&",k="qx.core.Setting",j="qx.allowUrlVariants",h="qx.propertyDebugLevel",g="qxsetting",f=":",e=".";qx.Bootstrap.define(k,{statics:{__c:{},define:function(q,r){if(r===undefined){throw new Error('Default value of setting "'+q+'" must be defined!');}if(!this.__c[q]){this.__c[q]={};}else if(this.__c[q].defaultValue!==undefined){throw new Error('Setting "'+q+'" is already defined!');}this.__c[q].defaultValue=r;},get:function(c){var d=this.__c[c];if(d===undefined){throw new Error('Setting "'+c+'" is not defined.');}if(d.value!==undefined){return d.value;}return d.defaultValue;},set:function(o,p){if((o.split(e)).length<2){throw new Error('Malformed settings key "'+o+'". Must be following the schema "namespace.key".');}if(!this.__c[o]){this.__c[o]={};}this.__c[o].value=p;},__d:function(){if(window.qxsettings){for(var n in window.qxsettings){this.set(n,window.qxsettings[n]);}window.qxsettings=undefined;try{delete window.qxsettings;}catch(s){}this.__e();}},__e:function(){if(this.get(m)!=true){return;}var b=document.location.search.slice(1).split(l);for(var i=0;i<b.length;i++){var a=b[i].split(f);if(a.length!=3||a[0]!=g){continue;}this.set(a[1],decodeURIComponent(a[2]));}}},defer:function(t){t.define(m,false);t.define(j,false);t.define(h,0);t.__d();}});})();(function(){var B="function",A="Boolean",z="qx.Interface",y="]",x="toggle",w="Interface",v="is",u="[Interface ";qx.Bootstrap.define(z,{statics:{define:function(name,C){if(C){if(C.extend&&!(C.extend instanceof Array)){C.extend=[C.extend];}{};var D=C.statics?C.statics:{};if(C.extend){D.$$extends=C.extend;}if(C.properties){D.$$properties=C.properties;}if(C.members){D.$$members=C.members;}if(C.events){D.$$events=C.events;}}else{var D={};}D.$$type=w;D.name=name;D.toString=this.genericToString;D.basename=qx.Bootstrap.createNamespace(name,D);qx.Interface.$$registry[name]=D;return D;},getByName:function(name){return this.$$registry[name];},isDefined:function(name){return this.getByName(name)!==undefined;},getTotalNumber:function(){return qx.Bootstrap.objectGetLength(this.$$registry);},flatten:function(g){if(!g){return [];}var h=g.concat();for(var i=0,l=g.length;i<l;i++){if(g[i].$$extends){h.push.apply(h,this.flatten(g[i].$$extends));}}return h;},__f:function(I,J,K,L){var P=K.$$members;if(P){for(var O in P){if(qx.Bootstrap.isFunction(P[O])){var N=this.__g(J,O);var M=N||qx.Bootstrap.isFunction(I[O]);if(!M){throw new Error('Implementation of method "'+O+'" is missing in class "'+J.classname+'" required by interface "'+K.name+'"');}var Q=L===true&&!N&&!qx.Bootstrap.hasInterface(J,K);if(Q){I[O]=this.__j(K,I[O],O,P[O]);}}else{if(typeof I[O]===undefined){if(typeof I[O]!==B){throw new Error('Implementation of member "'+O+'" is missing in class "'+J.classname+'" required by interface "'+K.name+'"');}}}}}},__g:function(a,b){var f=b.match(/^(is|toggle|get|set|reset)(.*)$/);if(!f){return false;}var c=qx.Bootstrap.firstLow(f[2]);var d=qx.Bootstrap.getPropertyDefinition(a,c);if(!d){return false;}var e=f[0]==v||f[0]==x;if(e){return qx.Bootstrap.getPropertyDefinition(a,c).check==A;}return true;},__h:function(r,s){if(s.$$properties){for(var t in s.$$properties){if(!qx.Bootstrap.getPropertyDefinition(r,t)){throw new Error('The property "'+t+'" is not supported by Class "'+r.classname+'"!');}}}},__i:function(j,k){if(k.$$events){for(var m in k.$$events){if(!qx.Bootstrap.supportsEvent(j,m)){throw new Error('The event "'+m+'" is not supported by Class "'+j.classname+'"!');}}}},assertObject:function(n,o){var q=n.constructor;this.__f(n,q,o,false);this.__h(q,o);this.__i(q,o);var p=o.$$extends;if(p){for(var i=0,l=p.length;i<l;i++){this.assertObject(n,p[i]);}}},assert:function(E,F,G){this.__f(E.prototype,E,F,G);this.__h(E,F);this.__i(E,F);var H=F.$$extends;if(H){for(var i=0,l=H.length;i<l;i++){this.assert(E,H[i],G);}}},genericToString:function(){return u+this.name+y;},$$registry:{},__j:function(){},__k:null,__l:function(){}}});})();(function(){var k="qx.Mixin",j=".prototype",h="constructor",g="[Mixin ",f="]",e="destruct",d="Mixin";qx.Bootstrap.define(k,{statics:{define:function(name,w){if(w){if(w.include&&!(w.include instanceof Array)){w.include=[w.include];}{};var y=w.statics?w.statics:{};qx.Bootstrap.setDisplayNames(y,name);for(var x in y){if(y[x] instanceof Function){y[x].$$mixin=y;}}if(w.construct){y.$$constructor=w.construct;qx.Bootstrap.setDisplayName(w.construct,name,h);}if(w.include){y.$$includes=w.include;}if(w.properties){y.$$properties=w.properties;}if(w.members){y.$$members=w.members;qx.Bootstrap.setDisplayNames(w.members,name+j);}for(var x in y.$$members){if(y.$$members[x] instanceof Function){y.$$members[x].$$mixin=y;}}if(w.events){y.$$events=w.events;}if(w.destruct){y.$$destructor=w.destruct;qx.Bootstrap.setDisplayName(w.destruct,name,e);}}else{var y={};}y.$$type=d;y.name=name;y.toString=this.genericToString;y.basename=qx.Bootstrap.createNamespace(name,y);this.$$registry[name]=y;return y;},checkCompatibility:function(m){var p=this.flatten(m);var q=p.length;if(q<2){return true;}var t={};var s={};var r={};var o;for(var i=0;i<q;i++){o=p[i];for(var n in o.events){if(r[n]){throw new Error('Conflict between mixin "'+o.name+'" and "'+r[n]+'" in member "'+n+'"!');}r[n]=o.name;}for(var n in o.properties){if(t[n]){throw new Error('Conflict between mixin "'+o.name+'" and "'+t[n]+'" in property "'+n+'"!');}t[n]=o.name;}for(var n in o.members){if(s[n]){throw new Error('Conflict between mixin "'+o.name+'" and "'+s[n]+'" in member "'+n+'"!');}s[n]=o.name;}}return true;},isCompatible:function(a,b){var c=qx.Bootstrap.getMixins(b);c.push(a);return qx.Mixin.checkCompatibility(c);},getByName:function(name){return this.$$registry[name];},isDefined:function(name){return this.getByName(name)!==undefined;},getTotalNumber:function(){return qx.Bootstrap.objectGetLength(this.$$registry);},flatten:function(u){if(!u){return [];}var v=u.concat();for(var i=0,l=u.length;i<l;i++){if(u[i].$$includes){v.push.apply(v,this.flatten(u[i].$$includes));}}return v;},genericToString:function(){return g+this.name+f;},$$registry:{},__m:null,__n:function(){}}});})();(function(){var ds=';',dr='return this.',dq="string",dp="boolean",dn="",dm="setThemed",dl='!==undefined)',dk="this.",dj="set",di="resetThemed",cW="setRuntime",cV="init",cU='else if(this.',cT="resetRuntime",cS="reset",cR="();",cQ='else ',cP='if(this.',cO="return this.",cN="get",dz=";",dA="(a[",dx=' of an instance of ',dy="refresh",dv=' is not (yet) ready!");',dw="]);",dt='qx.lang.Type.isString(value) && qx.util.ColorUtil.isValidPropertyValue(value)',du='value !== null && qx.theme.manager.Font.getInstance().isDynamic(value)',dB='value !== null && value.nodeType === 9 && value.documentElement',dC='value !== null && value.$$type === "Mixin"',db='return init;',da='var init=this.',dd='value !== null && value.nodeType === 1 && value.attributes',dc="var parent = this.getLayoutParent();",df="Error in property ",de="property",dh='qx.core.Assert.assertInstance(value, Date, msg) || true',dg="if (!parent) return;",cY=" in method ",cX='qx.core.Assert.assertInstance(value, Error, msg) || true',bN='Undefined value is not allowed!',bO="inherit",bP='Is invalid!',bQ="MSIE 6.0",bR="': ",bS=" of class ",bT='value !== null && value.nodeType !== undefined',bU='value !== null && qx.theme.manager.Decoration.getInstance().isValidPropertyValue(value)',bV='qx.core.Assert.assertPositiveInteger(value, msg) || true',bW='if(init==qx.core.Property.$$inherit)init=null;',dG='value !== null && value.$$type === "Interface"',dF='var inherit=prop.$$inherit;',dE="var value = parent.",dD="$$useinit_",dK="(value);",dJ=".",dI="$$runtime_",dH='Requires exactly one argument!',dM="$$user_",dL='qx.core.Assert.assertArray(value, msg) || true',cw='qx.core.Assert.assertPositiveNumber(value, msg) || true',cx=".prototype",cu="Boolean",cv='return value;',cA='if(init==qx.core.Property.$$inherit)throw new Error("Inheritable property ',cB='Does not allow any arguments!',cy="()",cz="var a=arguments[0] instanceof Array?arguments[0]:arguments;",cs='value !== null && value.$$type === "Theme"',ct="())",cf='return null;',ce='qx.core.Assert.assertObject(value, msg) || true',ch='qx.core.Assert.assertString(value, msg) || true',cg="if (value===undefined) value = parent.",cb='value !== null && value.$$type === "Class"',ca='qx.core.Assert.assertFunction(value, msg) || true',cd="on",cc="object",bY="$$init_",bX="$$theme_",cG='qx.core.Assert.assertMap(value, msg) || true',cH="qx.aspects",cI='qx.core.Assert.assertNumber(value, msg) || true',cJ='Null value is not allowed!',cC='qx.core.Assert.assertInteger(value, msg) || true',cD="value",cE="rv:1.8.1",cF="shorthand",cK='qx.core.Assert.assertInstance(value, RegExp, msg) || true',cL='value !== null && value.type !== undefined',cp='value !== null && value.document',co='throw new Error("Property ',cn="(!this.",cm='qx.core.Assert.assertBoolean(value, msg) || true',cl="toggle",ck="$$inherit_",cj=" with incoming value '",ci="a=qx.lang.Array.fromShortHand(qx.lang.Array.fromArguments(a));",cr="qx.core.Property",cq="is",cM='Could not change or apply init value after constructing phase!';qx.Bootstrap.define(cr,{statics:{__o:{"Boolean":cm,"String":ch,"Number":cI,"Integer":cC,"PositiveNumber":cw,"PositiveInteger":bV,"Error":cX,"RegExp":cK,"Object":ce,"Array":dL,"Map":cG,"Function":ca,"Date":dh,"Node":bT,"Element":dd,"Document":dB,"Window":cp,"Event":cL,"Class":cb,"Mixin":dC,"Interface":dG,"Theme":cs,"Color":dt,"Decorator":bU,"Font":du},__p:{"Node":true,"Element":true,"Document":true,"Window":true,"Event":true},$$inherit:bO,$$store:{runtime:{},user:{},theme:{},inherit:{},init:{},useinit:{}},$$method:{get:{},set:{},reset:{},init:{},refresh:{},setRuntime:{},resetRuntime:{},setThemed:{},resetThemed:{}},$$allowedKeys:{name:dq,dereference:dp,inheritable:dp,nullable:dp,themeable:dp,refine:dp,init:null,apply:dq,event:dq,check:null,transform:dq,deferredInit:dp,validate:null},$$allowedGroupKeys:{name:dq,group:cc,mode:dq,themeable:dp},$$inheritable:{},__q:function(T){var U=this.__r(T);if(!U.length){var V=qx.lang.Function.empty;}else{V=this.__s(U);}T.prototype.$$refreshInheritables=V;},__r:function(j){var m=[];while(j){var k=j.$$properties;if(k){for(var name in this.$$inheritable){if(k[name]&&k[name].inheritable){m.push(name);}}}j=j.superclass;}return m;},__s:function(dT){var dX=this.$$store.inherit;var dW=this.$$store.init;var dV=this.$$method.refresh;var dU=[dc,dg];for(var i=0,l=dT.length;i<l;i++){var name=dT[i];dU.push(dE,dX[name],dz,cg,dW[name],dz,dk,dV[name],dK);}return new Function(dU.join(dn));},attachRefreshInheritables:function(W){W.prototype.$$refreshInheritables=function(){qx.core.Property.__q(W);return this.$$refreshInheritables();};},attachMethods:function(bC,name,bD){bD.group?this.__t(bC,bD,name):this.__u(bC,bD,name);},__t:function(x,y,name){var F=qx.Bootstrap.firstUp(name);var E=x.prototype;var G=y.themeable===true;{};var H=[];var B=[];if(G){var z=[];var D=[];}var C=cz;H.push(C);if(G){z.push(C);}if(y.mode==cF){var A=ci;H.push(A);if(G){z.push(A);}}for(var i=0,a=y.group,l=a.length;i<l;i++){{};H.push(dk,this.$$method.set[a[i]],dA,i,dw);B.push(dk,this.$$method.reset[a[i]],cR);if(G){{};z.push(dk,this.$$method.setThemed[a[i]],dA,i,dw);D.push(dk,this.$$method.resetThemed[a[i]],cR);}}this.$$method.set[name]=dj+F;E[this.$$method.set[name]]=new Function(H.join(dn));this.$$method.reset[name]=cS+F;E[this.$$method.reset[name]]=new Function(B.join(dn));if(G){this.$$method.setThemed[name]=dm+F;E[this.$$method.setThemed[name]]=new Function(z.join(dn));this.$$method.resetThemed[name]=di+F;E[this.$$method.resetThemed[name]]=new Function(D.join(dn));}},__u:function(bj,bk,name){var bm=qx.Bootstrap.firstUp(name);var bo=bj.prototype;{};if(bk.dereference===undefined&&typeof bk.check===dq){bk.dereference=this.__v(bk.check);}var bn=this.$$method;var bl=this.$$store;bl.runtime[name]=dI+name;bl.user[name]=dM+name;bl.theme[name]=bX+name;bl.init[name]=bY+name;bl.inherit[name]=ck+name;bl.useinit[name]=dD+name;bn.get[name]=cN+bm;bo[bn.get[name]]=function(){return qx.core.Property.executeOptimizedGetter(this,bj,name,cN);};bn.set[name]=dj+bm;bo[bn.set[name]]=function(b){return qx.core.Property.executeOptimizedSetter(this,bj,name,dj,arguments);};bn.reset[name]=cS+bm;bo[bn.reset[name]]=function(){return qx.core.Property.executeOptimizedSetter(this,bj,name,cS);};if(bk.inheritable||bk.apply||bk.event||bk.deferredInit){bn.init[name]=cV+bm;bo[bn.init[name]]=function(K){return qx.core.Property.executeOptimizedSetter(this,bj,name,cV,arguments);};}if(bk.inheritable){bn.refresh[name]=dy+bm;bo[bn.refresh[name]]=function(S){return qx.core.Property.executeOptimizedSetter(this,bj,name,dy,arguments);};}bn.setRuntime[name]=cW+bm;bo[bn.setRuntime[name]]=function(J){return qx.core.Property.executeOptimizedSetter(this,bj,name,cW,arguments);};bn.resetRuntime[name]=cT+bm;bo[bn.resetRuntime[name]]=function(){return qx.core.Property.executeOptimizedSetter(this,bj,name,cT);};if(bk.themeable){bn.setThemed[name]=dm+bm;bo[bn.setThemed[name]]=function(I){return qx.core.Property.executeOptimizedSetter(this,bj,name,dm,arguments);};bn.resetThemed[name]=di+bm;bo[bn.resetThemed[name]]=function(){return qx.core.Property.executeOptimizedSetter(this,bj,name,di);};}if(bk.check===cu){bo[cl+bm]=new Function(cO+bn.set[name]+cn+bn.get[name]+ct);bo[cq+bm]=new Function(cO+bn.get[name]+cy);}},__v:function(g){return !!this.__p[g];},__w:function(br){return this.__p[br]||qx.Bootstrap.classIsDefined(br)||(qx.Interface&&qx.Interface.isDefined(br));},__x:{0:cM,1:dH,2:bN,3:cB,4:cJ,5:bP},error:function(L,M,N,O,P){var Q=L.constructor.classname;var R=df+N+bS+Q+cY+this.$$method[O][N]+cj+P+bR;throw new Error(R+(this.__x[M]||"Unknown reason: "+M));},__y:function(bH,bI,name,bJ,bK,bL){var bM=this.$$method[bJ][name];{bI[bM]=new Function(cD,bK.join(dn));};if(qx.core.Variant.isSet(cH,cd)){bI[bM]=qx.core.Aspect.wrap(bH.classname+dJ+bM,bI[bM],de);}qx.Bootstrap.setDisplayName(bI[bM],bH.classname+cx,bM);if(bL===undefined){return bH[bM]();}else{return bH[bM](bL[0]);}},executeOptimizedGetter:function(bv,bw,name,bx){var bz=bw.$$properties[name];var bB=bw.prototype;var by=[];var bA=this.$$store;by.push(cP,bA.runtime[name],dl);by.push(dr,bA.runtime[name],ds);if(bz.inheritable){by.push(cU,bA.inherit[name],dl);by.push(dr,bA.inherit[name],ds);by.push(cQ);}by.push(cP,bA.user[name],dl);by.push(dr,bA.user[name],ds);if(bz.themeable){by.push(cU,bA.theme[name],dl);by.push(dr,bA.theme[name],ds);}if(bz.deferredInit&&bz.init===undefined){by.push(cU,bA.init[name],dl);by.push(dr,bA.init[name],ds);}by.push(cQ);if(bz.init!==undefined){if(bz.inheritable){by.push(da,bA.init[name],ds);if(bz.nullable){by.push(bW);}else if(bz.init!==undefined){by.push(dr,bA.init[name],ds);}else{by.push(cA,name,dx,bw.classname,dv);}by.push(db);}else{by.push(dr,bA.init[name],ds);}}else if(bz.inheritable||bz.nullable){by.push(cf);}else{by.push(co,name,dx,bw.classname,dv);}return this.__y(bv,bB,name,bx,by);},executeOptimizedSetter:function(n,o,name,p,q){var v=o.$$properties[name];var u=o.prototype;var s=[];var r=p===dj||p===dm||p===cW||(p===cV&&v.init===undefined);var t=v.apply||v.event||v.inheritable;var w=this.__z(p,name);this.__A(s,v,name,p,r);if(r){this.__B(s,o,v,name);}if(t){this.__C(s,r,w,p);}if(v.inheritable){s.push(dF);}{};if(!t){this.__E(s,name,p,r);}else{this.__F(s,v,name,p,r);}if(v.inheritable){this.__G(s,v,name,p);}else if(t){this.__H(s,v,name,p);}if(t){this.__I(s,v,name);if(v.inheritable&&u._getChildren){this.__J(s,name);}}if(r){s.push(cv);}return this.__y(n,u,name,p,s,q);},__z:function(bp,name){if(bp===cW||bp===cT){var bq=this.$$store.runtime[name];}else if(bp===dm||bp===di){bq=this.$$store.theme[name];}else if(bp===cV){bq=this.$$store.init[name];}else{bq=this.$$store.user[name];}return bq;},__A:function(c,d,name,e,f){{if(!d.nullable||d.check||d.inheritable){c.push('var prop=qx.core.Property;');}if(e==="set"){c.push('if(value===undefined)prop.error(this,2,"',name,'","',e,'",value);');}};},__B:function(dY,ea,eb,name){if(eb.transform){dY.push('value=this.',eb.transform,'(value);');}if(eb.validate){if(typeof eb.validate==="string"){dY.push('this.',eb.validate,'(value);');}else if(eb.validate instanceof Function){dY.push(ea.classname,'.$$properties.',name);dY.push('.validate.call(this, value);');}}},__C:function(X,Y,ba,bb){var bc=(bb==="reset"||bb==="resetThemed"||bb==="resetRuntime");if(Y){X.push('if(this.',ba,'===value)return value;');}else if(bc){X.push('if(this.',ba,'===undefined)return;');}},__D:undefined,__E:function(bE,name,bF,bG){if(bF==="setRuntime"){bE.push('this.',this.$$store.runtime[name],'=value;');}else if(bF==="resetRuntime"){bE.push('if(this.',this.$$store.runtime[name],'!==undefined)');bE.push('delete this.',this.$$store.runtime[name],';');}else if(bF==="set"){bE.push('this.',this.$$store.user[name],'=value;');}else if(bF==="reset"){bE.push('if(this.',this.$$store.user[name],'!==undefined)');bE.push('delete this.',this.$$store.user[name],';');}else if(bF==="setThemed"){bE.push('this.',this.$$store.theme[name],'=value;');}else if(bF==="resetThemed"){bE.push('if(this.',this.$$store.theme[name],'!==undefined)');bE.push('delete this.',this.$$store.theme[name],';');}else if(bF==="init"&&bG){bE.push('this.',this.$$store.init[name],'=value;');}},__F:function(dP,dQ,name,dR,dS){if(dQ.inheritable){dP.push('var computed, old=this.',this.$$store.inherit[name],';');}else{dP.push('var computed, old;');}dP.push('if(this.',this.$$store.runtime[name],'!==undefined){');if(dR==="setRuntime"){dP.push('computed=this.',this.$$store.runtime[name],'=value;');}else if(dR==="resetRuntime"){dP.push('delete this.',this.$$store.runtime[name],';');dP.push('if(this.',this.$$store.user[name],'!==undefined)');dP.push('computed=this.',this.$$store.user[name],';');dP.push('else if(this.',this.$$store.theme[name],'!==undefined)');dP.push('computed=this.',this.$$store.theme[name],';');dP.push('else if(this.',this.$$store.init[name],'!==undefined){');dP.push('computed=this.',this.$$store.init[name],';');dP.push('this.',this.$$store.useinit[name],'=true;');dP.push('}');}else{dP.push('old=computed=this.',this.$$store.runtime[name],';');if(dR==="set"){dP.push('this.',this.$$store.user[name],'=value;');}else if(dR==="reset"){dP.push('delete this.',this.$$store.user[name],';');}else if(dR==="setThemed"){dP.push('this.',this.$$store.theme[name],'=value;');}else if(dR==="resetThemed"){dP.push('delete this.',this.$$store.theme[name],';');}else if(dR==="init"&&dS){dP.push('this.',this.$$store.init[name],'=value;');}}dP.push('}');dP.push('else if(this.',this.$$store.user[name],'!==undefined){');if(dR==="set"){if(!dQ.inheritable){dP.push('old=this.',this.$$store.user[name],';');}dP.push('computed=this.',this.$$store.user[name],'=value;');}else if(dR==="reset"){if(!dQ.inheritable){dP.push('old=this.',this.$$store.user[name],';');}dP.push('delete this.',this.$$store.user[name],';');dP.push('if(this.',this.$$store.runtime[name],'!==undefined)');dP.push('computed=this.',this.$$store.runtime[name],';');dP.push('if(this.',this.$$store.theme[name],'!==undefined)');dP.push('computed=this.',this.$$store.theme[name],';');dP.push('else if(this.',this.$$store.init[name],'!==undefined){');dP.push('computed=this.',this.$$store.init[name],';');dP.push('this.',this.$$store.useinit[name],'=true;');dP.push('}');}else{if(dR==="setRuntime"){dP.push('computed=this.',this.$$store.runtime[name],'=value;');}else if(dQ.inheritable){dP.push('computed=this.',this.$$store.user[name],';');}else{dP.push('old=computed=this.',this.$$store.user[name],';');}if(dR==="setThemed"){dP.push('this.',this.$$store.theme[name],'=value;');}else if(dR==="resetThemed"){dP.push('delete this.',this.$$store.theme[name],';');}else if(dR==="init"&&dS){dP.push('this.',this.$$store.init[name],'=value;');}}dP.push('}');if(dQ.themeable){dP.push('else if(this.',this.$$store.theme[name],'!==undefined){');if(!dQ.inheritable){dP.push('old=this.',this.$$store.theme[name],';');}if(dR==="setRuntime"){dP.push('computed=this.',this.$$store.runtime[name],'=value;');}else if(dR==="set"){dP.push('computed=this.',this.$$store.user[name],'=value;');}else if(dR==="setThemed"){dP.push('computed=this.',this.$$store.theme[name],'=value;');}else if(dR==="resetThemed"){dP.push('delete this.',this.$$store.theme[name],';');dP.push('if(this.',this.$$store.init[name],'!==undefined){');dP.push('computed=this.',this.$$store.init[name],';');dP.push('this.',this.$$store.useinit[name],'=true;');dP.push('}');}else if(dR==="init"){if(dS){dP.push('this.',this.$$store.init[name],'=value;');}dP.push('computed=this.',this.$$store.theme[name],';');}else if(dR==="refresh"){dP.push('computed=this.',this.$$store.theme[name],';');}dP.push('}');}dP.push('else if(this.',this.$$store.useinit[name],'){');if(!dQ.inheritable){dP.push('old=this.',this.$$store.init[name],';');}if(dR==="init"){if(dS){dP.push('computed=this.',this.$$store.init[name],'=value;');}else{dP.push('computed=this.',this.$$store.init[name],';');}}else if(dR==="set"||dR==="setRuntime"||dR==="setThemed"||dR==="refresh"){dP.push('delete this.',this.$$store.useinit[name],';');if(dR==="setRuntime"){dP.push('computed=this.',this.$$store.runtime[name],'=value;');}else if(dR==="set"){dP.push('computed=this.',this.$$store.user[name],'=value;');}else if(dR==="setThemed"){dP.push('computed=this.',this.$$store.theme[name],'=value;');}else if(dR==="refresh"){dP.push('computed=this.',this.$$store.init[name],';');}}dP.push('}');if(dR==="set"||dR==="setRuntime"||dR==="setThemed"||dR==="init"){dP.push('else{');if(dR==="setRuntime"){dP.push('computed=this.',this.$$store.runtime[name],'=value;');}else if(dR==="set"){dP.push('computed=this.',this.$$store.user[name],'=value;');}else if(dR==="setThemed"){dP.push('computed=this.',this.$$store.theme[name],'=value;');}else if(dR==="init"){if(dS){dP.push('computed=this.',this.$$store.init[name],'=value;');}else{dP.push('computed=this.',this.$$store.init[name],';');}dP.push('this.',this.$$store.useinit[name],'=true;');}dP.push('}');}},__G:function(bd,be,name,bf){bd.push('if(computed===undefined||computed===inherit){');if(bf==="refresh"){bd.push('computed=value;');}else{bd.push('var pa=this.getLayoutParent();if(pa)computed=pa.',this.$$store.inherit[name],';');}bd.push('if((computed===undefined||computed===inherit)&&');bd.push('this.',this.$$store.init[name],'!==undefined&&');bd.push('this.',this.$$store.init[name],'!==inherit){');bd.push('computed=this.',this.$$store.init[name],';');bd.push('this.',this.$$store.useinit[name],'=true;');bd.push('}else{');bd.push('delete this.',this.$$store.useinit[name],';}');bd.push('}');bd.push('if(old===computed)return value;');bd.push('if(computed===inherit){');bd.push('computed=undefined;delete this.',this.$$store.inherit[name],';');bd.push('}');bd.push('else if(computed===undefined)');bd.push('delete this.',this.$$store.inherit[name],';');bd.push('else this.',this.$$store.inherit[name],'=computed;');bd.push('var backup=computed;');if(be.init!==undefined&&bf!=="init"){bd.push('if(old===undefined)old=this.',this.$$store.init[name],";");}else{bd.push('if(old===undefined)old=null;');}bd.push('if(computed===undefined||computed==inherit)computed=null;');},__H:function(bs,bt,name,bu){if(bu!=="set"&&bu!=="setRuntime"&&bu!=="setThemed"){bs.push('if(computed===undefined)computed=null;');}bs.push('if(old===computed)return value;');if(bt.init!==undefined&&bu!=="init"){bs.push('if(old===undefined)old=this.',this.$$store.init[name],";");}else{bs.push('if(old===undefined)old=null;');}},__I:function(dN,dO,name){if(dO.apply){dN.push('this.',dO.apply,'(computed, old, "',name,'");');}if(dO.event){dN.push("var reg=qx.event.Registration;","if(reg.hasListener(this, '",dO.event,"')){","reg.fireEvent(this, '",dO.event,"', qx.event.type.Data, [computed, old]",")}");}},__J:function(h,name){h.push('var a=this._getChildren();if(a)for(var i=0,l=a.length;i<l;i++){');h.push('if(a[i].',this.$$method.refresh[name],')a[i].',this.$$method.refresh[name],'(backup);');h.push('}');}},defer:function(bg){var bi=navigator.userAgent.indexOf(bQ)!=-1;var bh=navigator.userAgent.indexOf(cE)!=-1;if(bi||bh){bg.__v=bg.__w;}}});})();(function(){var k="emulated",j="native",h='"',g="qx.lang.Core",f="\\\\",e="\\\"",d="[object Error]";qx.Bootstrap.define(g,{statics:{errorToString:{"native":Error.prototype.toString,"emulated":function(){return this.message;}}[(!Error.prototype.toString||Error.prototype.toString()==d)?k:j],arrayIndexOf:{"native":Array.prototype.indexOf,"emulated":function(t,u){if(u==null){u=0;}else if(u<0){u=Math.max(0,this.length+u);}for(var i=u;i<this.length;i++){if(this[i]===t){return i;}}return -1;}}[Array.prototype.indexOf?j:k],arrayLastIndexOf:{"native":Array.prototype.lastIndexOf,"emulated":function(C,D){if(D==null){D=this.length-1;}else if(D<0){D=Math.max(0,this.length+D);}for(var i=D;i>=0;i--){if(this[i]===C){return i;}}return -1;}}[Array.prototype.lastIndexOf?j:k],arrayForEach:{"native":Array.prototype.forEach,"emulated":function(a,b){var l=this.length;for(var i=0;i<l;i++){var c=this[i];if(c!==undefined){a.call(b||window,c,i,this);}}}}[Array.prototype.forEach?j:k],arrayFilter:{"native":Array.prototype.filter,"emulated":function(y,z){var A=[];var l=this.length;for(var i=0;i<l;i++){var B=this[i];if(B!==undefined){if(y.call(z||window,B,i,this)){A.push(this[i]);}}}return A;}}[Array.prototype.filter?j:k],arrayMap:{"native":Array.prototype.map,"emulated":function(m,n){var o=[];var l=this.length;for(var i=0;i<l;i++){var p=this[i];if(p!==undefined){o[i]=m.call(n||window,p,i,this);}}return o;}}[Array.prototype.map?j:k],arraySome:{"native":Array.prototype.some,"emulated":function(v,w){var l=this.length;for(var i=0;i<l;i++){var x=this[i];if(x!==undefined){if(v.call(w||window,x,i,this)){return true;}}}return false;}}[Array.prototype.some?j:k],arrayEvery:{"native":Array.prototype.every,"emulated":function(q,r){var l=this.length;for(var i=0;i<l;i++){var s=this[i];if(s!==undefined){if(!q.call(r||window,s,i,this)){return false;}}}return true;}}[Array.prototype.every?j:k],stringQuote:{"native":String.prototype.quote,"emulated":function(){return h+this.replace(/\\/g,f).replace(/\"/g,e)+h;}}[String.prototype.quote?j:k]}});Error.prototype.toString=qx.lang.Core.errorToString;Array.prototype.indexOf=qx.lang.Core.arrayIndexOf;Array.prototype.lastIndexOf=qx.lang.Core.arrayLastIndexOf;Array.prototype.forEach=qx.lang.Core.arrayForEach;Array.prototype.filter=qx.lang.Core.arrayFilter;Array.prototype.map=qx.lang.Core.arrayMap;Array.prototype.some=qx.lang.Core.arraySome;Array.prototype.every=qx.lang.Core.arrayEvery;String.prototype.quote=qx.lang.Core.stringQuote;})();(function(){var b="qx.bom.client.Engine";qx.Bootstrap.define(b,{statics:{NAME:"",FULLVERSION:"0.0.0",VERSION:0.0,OPERA:false,WEBKIT:false,GECKO:false,MSHTML:false,UNKNOWN_ENGINE:false,UNKNOWN_VERSION:false,DOCUMENT_MODE:null,__K:function(){var c="unknown";var g="0.0.0";var f=window.navigator.userAgent;var i=false;var e=false;if(window.opera&&Object.prototype.toString.call(window.opera)=="[object Opera]"){c="opera";this.OPERA=true;if(/Opera[\s\/]([0-9]+)\.([0-9])([0-9]*)/.test(f)){g=RegExp.$1+"."+RegExp.$2;if(RegExp.$3!=""){g+="."+RegExp.$3;}}else{e=true;g="9.6.0";}}else if(window.navigator.userAgent.indexOf("AppleWebKit/")!=-1){c="webkit";this.WEBKIT=true;if(/AppleWebKit\/([^ ]+)/.test(f)){g=RegExp.$1;var h=RegExp("[^\\.0-9]").exec(g);if(h){g=g.slice(0,h.index);}}else{e=true;g="525.26";}}else if(window.controllers&&window.navigator.product==="Gecko"){c="gecko";this.GECKO=true;if(/rv\:([^\);]+)(\)|;)/.test(f)){g=RegExp.$1;}else{e=true;g="1.9.0.0";}}else if(window.navigator.cpuClass&&/MSIE\s+([^\);]+)(\)|;)/.test(f)){c="mshtml";g=RegExp.$1;if(document.documentMode){this.DOCUMENT_MODE=document.documentMode;}if(g<8&&/Trident\/([^\);]+)(\)|;)/.test(f)){if(RegExp.$1==="4.0"){g="8.0";}}this.MSHTML=true;}else{var d=window.qxFail;if(d&&typeof d==="function"){var c=d();if(c.NAME&&c.FULLVERSION){c=c.NAME;this[c.toUpperCase()]=true;g=c.FULLVERSION;}}else{i=true;e=true;g="1.9.0.0";c="gecko";this.GECKO=true;qx.Bootstrap.warn("Unsupported client: "+f+"! Assumed gecko version 1.9.0.0 (Firefox 3.0).");}}this.UNKNOWN_ENGINE=i;this.UNKNOWN_VERSION=e;this.NAME=c;this.FULLVERSION=g;this.VERSION=parseFloat(g);}},defer:function(a){a.__K();}});})();(function(){var C="on",B="off",A="|",z="default",y="gecko",x="qx.aspects",w="$",u="qx.debug",t="qx.dynlocale",s="webkit",p="opera",r="qx.client",q="qx.core.Variant",o="mshtml";qx.Bootstrap.define(q,{statics:{__L:{},__M:{},compilerIsSet:function(){return true;},define:function(J,K,L){{};if(!this.__L[J]){this.__L[J]={};}else{}this.__L[J].allowedValues=K;this.__L[J].defaultValue=L;},get:function(D){var E=this.__L[D];{};if(E.value!==undefined){return E.value;}return E.defaultValue;},__N:function(){if(window.qxvariants){for(var a in qxvariants){{};if(!this.__L[a]){this.__L[a]={};}this.__L[a].value=qxvariants[a];}window.qxvariants=undefined;try{delete window.qxvariants;}catch(I){}this.__O(this.__L);}},__O:function(){if(qx.core.Setting.get("qx.allowUrlVariants")!=true){return;}var b=document.location.search.slice(1).split("&");for(var i=0;i<b.length;i++){var c=b[i].split(":");if(c.length!=3||c[0]!="qxvariant"){continue;}var d=c[1];if(!this.__L[d]){this.__L[d]={};}this.__L[d].value=decodeURIComponent(c[2]);}},select:function(e,f){{};for(var g in f){if(this.isSet(e,g)){return f[g];}}if(f[z]!==undefined){return f[z];}{};},isSet:function(h,j){var k=h+w+j;if(this.__M[k]!==undefined){return this.__M[k];}var n=false;if(j.indexOf(A)<0){n=this.get(h)===j;}else{var m=j.split(A);for(var i=0,l=m.length;i<l;i++){if(this.get(h)===m[i]){n=true;break;}}}this.__M[k]=n;return n;},__P:function(v){return typeof v==="object"&&v!==null&&v instanceof Array;},__Q:function(v){return typeof v==="object"&&v!==null&&!(v instanceof Array);},__R:function(F,G){for(var i=0,l=F.length;i<l;i++){if(F[i]==G){return true;}}return false;}},defer:function(H){H.define(r,[y,o,p,s],qx.bom.client.Engine.NAME);H.define(u,[C,B],C);H.define(x,[C,B],B);H.define(t,[C,B],C);H.__N();}});})();(function(){var d="qx.core.Aspect",c="before",b="*",a="static";qx.Bootstrap.define(d,{statics:{__S:[],wrap:function(e,f,g){var m=[];var h=[];var l=this.__S;var k;for(var i=0;i<l.length;i++){k=l[i];if((k.type==null||g==k.type||k.type==b)&&(k.name==null||e.match(k.name))){k.pos==-1?m.push(k.fcn):h.push(k.fcn);}}if(m.length===0&&h.length===0){return f;}var j=function(){for(var i=0;i<m.length;i++){m[i].call(this,e,f,g,arguments);}var n=f.apply(this,arguments);for(var i=0;i<h.length;i++){h[i].call(this,e,f,g,arguments,n);}return n;};if(g!==a){j.self=f.self;j.base=f.base;}f.wrapper=j;j.original=f;return j;},addAdvice:function(o,p,q,name){this.__S.push({fcn:o,pos:p===c?-1:1,type:q,name:name});}}});})();(function(){var bf="qx.aspects",be="on",bd=".",bc="static",bb="[Class ",ba="]",Y="$$init_",X="constructor",W="member",V=".prototype",S="extend",U="qx.Class",T="qx.event.type.Data";qx.Bootstrap.define(U,{statics:{define:function(name,k){if(!k){var k={};}if(k.include&&!(k.include instanceof Array)){k.include=[k.include];}if(k.implement&&!(k.implement instanceof Array)){k.implement=[k.implement];}var m=false;if(!k.hasOwnProperty(S)&&!k.type){k.type=bc;m=true;}{};var n=this.__X(name,k.type,k.extend,k.statics,k.construct,k.destruct,k.include);if(k.extend){if(k.properties){this.__ba(n,k.properties,true);}if(k.members){this.__bc(n,k.members,true,true,false);}if(k.events){this.__Y(n,k.events,true);}if(k.include){for(var i=0,l=k.include.length;i<l;i++){this.__bg(n,k.include[i],false);}}}if(k.settings){for(var o in k.settings){qx.core.Setting.define(o,k.settings[o]);}}if(k.variants){for(var o in k.variants){qx.core.Variant.define(o,k.variants[o].allowedValues,k.variants[o].defaultValue);}}if(k.implement){for(var i=0,l=k.implement.length;i<l;i++){this.__be(n,k.implement[i]);}}{};if(k.defer){k.defer.self=n;k.defer(n,n.prototype,{add:function(name,Q){var R={};R[name]=Q;qx.Class.__ba(n,R,true);}});}return n;},undefine:function(name){delete this.$$registry[name];var bw=name.split(bd);var by=[window];for(var i=0;i<bw.length;i++){by.push(by[i][bw[i]]);}for(var i=by.length-1;i>=1;i--){var bx=by[i];var parent=by[i-1];if(qx.Bootstrap.isFunction(bx)||qx.Bootstrap.objectGetLength(bx)===0){delete parent[bw[i-1]];}else{break;}}},isDefined:qx.Bootstrap.classIsDefined,getTotalNumber:function(){return qx.Bootstrap.objectGetLength(this.$$registry);},getByName:qx.Bootstrap.getByName,include:function(bg,bh){{};qx.Class.__bg(bg,bh,false);},patch:function(d,e){{};qx.Class.__bg(d,e,true);},isSubClassOf:function(bo,bp){if(!bo){return false;}if(bo==bp){return true;}if(bo.prototype instanceof bp){return true;}return false;},getPropertyDefinition:qx.Bootstrap.getPropertyDefinition,getProperties:function(f){var g=[];while(f){if(f.$$properties){g.push.apply(g,qx.Bootstrap.getKeys(f.$$properties));}f=f.superclass;}return g;},getByProperty:function(bX,name){while(bX){if(bX.$$properties&&bX.$$properties[name]){return bX;}bX=bX.superclass;}return null;},hasProperty:qx.Bootstrap.hasProperty,getEventType:qx.Bootstrap.getEventType,supportsEvent:qx.Bootstrap.supportsEvent,hasOwnMixin:function(b,c){return b.$$includes&&b.$$includes.indexOf(c)!==-1;},getByMixin:function(p,q){var r,i,l;while(p){if(p.$$includes){r=p.$$flatIncludes;for(i=0,l=r.length;i<l;i++){if(r[i]===q){return p;}}}p=p.superclass;}return null;},getMixins:qx.Bootstrap.getMixins,hasMixin:function(bV,bW){return !!this.getByMixin(bV,bW);},hasOwnInterface:function(bm,bn){return bm.$$implements&&bm.$$implements.indexOf(bn)!==-1;},getByInterface:qx.Bootstrap.getByInterface,getInterfaces:function(h){var j=[];while(h){if(h.$$implements){j.push.apply(j,h.$$flatImplements);}h=h.superclass;}return j;},hasInterface:qx.Bootstrap.hasInterface,implementsInterface:function(bI,bJ){var bK=bI.constructor;if(this.hasInterface(bK,bJ)){return true;}try{qx.Interface.assertObject(bI,bJ);return true;}catch(bz){}try{qx.Interface.assert(bK,bJ,false);return true;}catch(s){}return false;},getInstance:function(){if(!this.$$instance){this.$$allowconstruct=true;this.$$instance=new this;delete this.$$allowconstruct;}return this.$$instance;},genericToString:function(){return bb+this.classname+ba;},$$registry:qx.Bootstrap.$$registry,__T:null,__U:null,__V:function(){},__W:function(){},__X:function(name,bY,ca,cb,cc,cd,ce){var ch;if(!ca&&qx.core.Variant.isSet("qx.aspects","off")){ch=cb||{};qx.Bootstrap.setDisplayNames(ch,name);}else{var ch={};if(ca){if(!cc){cc=this.__bh();}if(this.__bj(ca,ce)){ch=this.__bk(cc,name,bY);}else{ch=cc;}if(bY==="singleton"){ch.getInstance=this.getInstance;}qx.Bootstrap.setDisplayName(cc,name,"constructor");}if(cb){qx.Bootstrap.setDisplayNames(cb,name);var ci;for(var i=0,a=qx.Bootstrap.getKeys(cb),l=a.length;i<l;i++){ci=a[i];var cf=cb[ci];if(qx.core.Variant.isSet("qx.aspects","on")){if(cf instanceof Function){cf=qx.core.Aspect.wrap(name+"."+ci,cf,"static");}ch[ci]=cf;}else{ch[ci]=cf;}}}}var cg=qx.Bootstrap.createNamespace(name,ch);ch.name=ch.classname=name;ch.basename=cg;ch.$$type="Class";if(bY){ch.$$classtype=bY;}if(!ch.hasOwnProperty("toString")){ch.toString=this.genericToString;}if(ca){qx.Bootstrap.extendClass(ch,cc,ca,name,cg);if(cd){if(qx.core.Variant.isSet("qx.aspects","on")){cd=qx.core.Aspect.wrap(name,cd,"destructor");}ch.$$destructor=cd;qx.Bootstrap.setDisplayName(cd,name,"destruct");}}this.$$registry[name]=ch;return ch;},__Y:function(bq,br,bs){var bt,bt;{};if(bq.$$events){for(var bt in br){bq.$$events[bt]=br[bt];}}else{bq.$$events=br;}},__ba:function(bL,bM,bN){var bO;if(bN===undefined){bN=false;}var bP=bL.prototype;for(var name in bM){bO=bM[name];{};bO.name=name;if(!bO.refine){if(bL.$$properties===undefined){bL.$$properties={};}bL.$$properties[name]=bO;}if(bO.init!==undefined){bL.prototype[Y+name]=bO.init;}if(bO.event!==undefined){var event={};event[bO.event]=T;this.__Y(bL,event,bN);}if(bO.inheritable){qx.core.Property.$$inheritable[name]=true;if(!bP.$$refreshInheritables){qx.core.Property.attachRefreshInheritables(bL);}}if(!bO.refine){qx.core.Property.attachMethods(bL,name,bO);}}},__bb:null,__bc:function(I,J,K,L,M){var N=I.prototype;var P,O;qx.Bootstrap.setDisplayNames(J,I.classname+V);for(var i=0,a=qx.Bootstrap.getKeys(J),l=a.length;i<l;i++){P=a[i];O=J[P];{};if(L!==false&&O instanceof Function&&O.$$type==null){if(M==true){O=this.__bd(O,N[P]);}else{if(N[P]){O.base=N[P];}O.self=I;}if(qx.core.Variant.isSet(bf,be)){O=qx.core.Aspect.wrap(I.classname+bd+P,O,W);}}N[P]=O;}},__bd:function(bQ,bR){if(bR){return function(){var bv=bQ.base;bQ.base=bR;var bu=bQ.apply(this,arguments);bQ.base=bv;return bu;};}else{return bQ;}},__be:function(bA,bB){{};var bC=qx.Interface.flatten([bB]);if(bA.$$implements){bA.$$implements.push(bB);bA.$$flatImplements.push.apply(bA.$$flatImplements,bC);}else{bA.$$implements=[bB];bA.$$flatImplements=bC;}},__bf:function(C){var name=C.classname;var D=this.__bk(C,name,C.$$classtype);for(var i=0,a=qx.Bootstrap.getKeys(C),l=a.length;i<l;i++){E=a[i];D[E]=C[E];}D.prototype=C.prototype;var G=C.prototype;for(var i=0,a=qx.Bootstrap.getKeys(G),l=a.length;i<l;i++){E=a[i];var H=G[E];if(H&&H.self==C){H.self=D;}}for(var E in this.$$registry){var F=this.$$registry[E];if(!F){continue;}if(F.base==C){F.base=D;}if(F.superclass==C){F.superclass=D;}if(F.$$original){if(F.$$original.base==C){F.$$original.base=D;}if(F.$$original.superclass==C){F.$$original.superclass=D;}}}qx.Bootstrap.createNamespace(name,D);this.$$registry[name]=D;return D;},__bg:function(t,u,v){{};if(this.hasMixin(t,u)){return;}var y=t.$$original;if(u.$$constructor&&!y){t=this.__bf(t);}var x=qx.Mixin.flatten([u]);var w;for(var i=0,l=x.length;i<l;i++){w=x[i];if(w.$$events){this.__Y(t,w.$$events,v);}if(w.$$properties){this.__ba(t,w.$$properties,v);}if(w.$$members){this.__bc(t,w.$$members,v,v,v);}}if(t.$$includes){t.$$includes.push(u);t.$$flatIncludes.push.apply(t.$$flatIncludes,x);}else{t.$$includes=[u];t.$$flatIncludes=x;}},__bh:function(){function bD(){bD.base.apply(this,arguments);}return bD;},__bi:function(){return function(){};},__bj:function(bE,bF){{};if(bE&&bE.$$includes){var bG=bE.$$flatIncludes;for(var i=0,l=bG.length;i<l;i++){if(bG[i].$$constructor){return true;}}}if(bF){var bH=qx.Mixin.flatten(bF);for(var i=0,l=bH.length;i<l;i++){if(bH[i].$$constructor){return true;}}}return false;},__bk:function(bi,name,bj){var bl=function(){var B=bl;{};var A=B.$$original.apply(this,arguments);if(B.$$includes){var z=B.$$flatIncludes;for(var i=0,l=z.length;i<l;i++){if(z[i].$$constructor){z[i].$$constructor.apply(this,arguments);}}}{};return A;};if(qx.core.Variant.isSet(bf,be)){var bk=qx.core.Aspect.wrap(name,bl,X);bl.$$original=bi;bl.constructor=bk;bl=bk;}bl.$$original=bi;bi.wrapper=bl;return bl;}},defer:function(){if(qx.core.Variant.isSet(bf,be)){for(var bS in qx.Bootstrap.$$registry){var bT=qx.Bootstrap.$$registry[bS];for(var bU in bT){if(bT[bU] instanceof Function){bT[bU]=qx.core.Aspect.wrap(bS+bd+bU,bT[bU],bc);}}}}}});})();(function(){var q="$$hash",p="",o="qx.core.ObjectRegistry";qx.Class.define(o,{statics:{inShutDown:false,__bl:{},__bm:0,__bn:[],register:function(g){var k=this.__bl;if(!k){return;}var j=g.$$hash;if(j==null){var h=this.__bn;if(h.length>0){j=h.pop();}else{j=(this.__bm++)+p;}g.$$hash=j;}{};k[j]=g;},unregister:function(d){var e=d.$$hash;if(e==null){return;}var f=this.__bl;if(f&&f[e]){delete f[e];this.__bn.push(e);}try{delete d.$$hash;}catch(w){if(d.removeAttribute){d.removeAttribute(q);}}},toHashCode:function(x){{};var z=x.$$hash;if(z!=null){return z;}var y=this.__bn;if(y.length>0){z=y.pop();}else{z=(this.__bm++)+p;}return x.$$hash=z;},clearHashCode:function(m){{};var n=m.$$hash;if(n!=null){this.__bn.push(n);try{delete m.$$hash;}catch(r){if(m.removeAttribute){m.removeAttribute(q);}}}},fromHashCode:function(A){return this.__bl[A]||null;},shutdown:function(){this.inShutDown=true;var t=this.__bl;var v=[];for(var u in t){v.push(u);}v.sort(function(a,b){return parseInt(b)-parseInt(a);});var s,i=0,l=v.length;while(true){try{for(;i<l;i++){u=v[i];s=t[u];if(s&&s.dispose){s.dispose();}}}catch(c){qx.Bootstrap.error(this,"Could not dispose object "+s.toString()+": "+c);if(i!==l){i++;continue;}}break;}qx.Bootstrap.debug(this,"Disposed "+l+" objects");delete this.__bl;},getRegistry:function(){return this.__bl;}}});})();(function(){var a="qx.data.MBinding";qx.Mixin.define(a,{members:{bind:function(b,c,d,e){return qx.data.SingleValueBinding.bind(this,b,c,d,e);},removeBinding:function(f){qx.data.SingleValueBinding.removeBindingFromObject(this,f);},removeAllBindings:function(){qx.data.SingleValueBinding.removeAllBindingsForObject(this);},getBindings:function(){return qx.data.SingleValueBinding.getAllBindingsForObject(this);}}});})();(function(){var m="qx.client",l="on",k="function",j="mousedown",i="qx.bom.Event",h="return;",g="mouseover",f="HTMLEvents";qx.Class.define(i,{statics:{addNativeListener:qx.core.Variant.select(m,{"mshtml":function(b,c,d){b.attachEvent(l+c,d);},"default":function(B,C,D){B.addEventListener(C,D,false);}}),removeNativeListener:qx.core.Variant.select(m,{"mshtml":function(q,r,s){try{q.detachEvent(l+r,s);}catch(e){if(e.number!==-2146828218){throw e;}}},"default":function(n,o,p){n.removeEventListener(o,p,false);}}),getTarget:function(e){return e.target||e.srcElement;},getRelatedTarget:qx.core.Variant.select(m,{"mshtml":function(e){if(e.type===g){return e.fromElement;}else{return e.toElement;}},"gecko":function(e){try{e.relatedTarget&&e.relatedTarget.nodeType;}catch(e){return null;}return e.relatedTarget;},"default":function(e){return e.relatedTarget;}}),preventDefault:qx.core.Variant.select(m,{"gecko":function(e){if(qx.bom.client.Engine.VERSION>=1.9&&e.type==j&&e.button==2){return;}e.preventDefault();if(qx.bom.client.Engine.VERSION<1.9){try{e.keyCode=0;}catch(a){}}},"mshtml":function(e){try{e.keyCode=0;}catch(A){}e.returnValue=false;},"default":function(e){e.preventDefault();}}),stopPropagation:function(e){if(e.stopPropagation){e.stopPropagation();}e.cancelBubble=true;},fire:function(t,u){if(document.createEventObject){var v=document.createEventObject();return t.fireEvent(l+u,v);}else{var v=document.createEvent(f);v.initEvent(u,true,true);return !t.dispatchEvent(v);}},supportsEvent:qx.core.Variant.select(m,{"webkit":function(E,F){return E.hasOwnProperty(l+F);},"default":function(w,x){var y=l+x;var z=(y in w);if(!z){z=typeof w[y]==k;if(!z&&w.setAttribute){w.setAttribute(y,h);z=typeof w[y]==k;w.removeAttribute(y);}}return z;}})}});})();(function(){var q="|bubble",p="|capture",o="|",n="",m="_",k="unload",j="UNKNOWN_",h="__bs",g="c",f="DOM_",c="__bt",e="WIN_",d="capture",b="qx.event.Manager",a="QX_";qx.Class.define(b,{extend:Object,construct:function(bF,bG){this.__bo=bF;this.__bp=qx.core.ObjectRegistry.toHashCode(bF);this.__bq=bG;if(bF.qx!==qx){var self=this;qx.bom.Event.addNativeListener(bF,k,qx.event.GlobalError.observeMethod(function(){qx.bom.Event.removeNativeListener(bF,k,arguments.callee);self.dispose();}));}this.__br={};this.__bs={};this.__bt={};this.__bu={};},statics:{__bv:0,getNextUniqueId:function(){return (this.__bv++)+n;}},members:{__bq:null,__br:null,__bt:null,__bw:null,__bs:null,__bu:null,__bo:null,__bp:null,getWindow:function(){return this.__bo;},getWindowId:function(){return this.__bp;},getHandler:function(Y){var ba=this.__bs[Y.classname];if(ba){return ba;}return this.__bs[Y.classname]=new Y(this);},getDispatcher:function(W){var X=this.__bt[W.classname];if(X){return X;}return this.__bt[W.classname]=new W(this,this.__bq);},getListeners:function(ck,cl,cm){var cn=ck.$$hash||qx.core.ObjectRegistry.toHashCode(ck);var cp=this.__br[cn];if(!cp){return null;}var cq=cl+(cm?p:q);var co=cp[cq];return co?co.concat():null;},serializeListeners:function(r){var y=r.$$hash||qx.core.ObjectRegistry.toHashCode(r);var A=this.__br[y];var w=[];if(A){var u,z,s,v,x;for(var t in A){u=t.indexOf(o);z=t.substring(0,u);s=t.charAt(u+1)==g;v=A[t];for(var i=0,l=v.length;i<l;i++){x=v[i];w.push({self:x.context,handler:x.handler,type:z,capture:s});}}}return w;},toggleAttachedEvents:function(bb,bc){var bh=bb.$$hash||qx.core.ObjectRegistry.toHashCode(bb);var bj=this.__br[bh];if(bj){var be,bi,bd,bf;for(var bg in bj){be=bg.indexOf(o);bi=bg.substring(0,be);bd=bg.charCodeAt(be+1)===99;bf=bj[bg];if(bc){this.__bx(bb,bi,bd);}else{this.__by(bb,bi,bd);}}}},hasListener:function(P,Q,R){{};var S=P.$$hash||qx.core.ObjectRegistry.toHashCode(P);var U=this.__br[S];if(!U){return false;}var V=Q+(R?p:q);var T=U[V];return T&&T.length>0;},importListeners:function(bk,bl){{};var br=bk.$$hash||qx.core.ObjectRegistry.toHashCode(bk);var bs=this.__br[br]={};var bo=qx.event.Manager;for(var bm in bl){var bp=bl[bm];var bq=bp.type+(bp.capture?p:q);var bn=bs[bq];if(!bn){bn=bs[bq]=[];this.__bx(bk,bp.type,bp.capture);}bn.push({handler:bp.listener,context:bp.self,unique:bp.unique||(bo.__bv++)+n});}},addListener:function(bY,ca,cb,self,cc){var cg;{};var ch=bY.$$hash||qx.core.ObjectRegistry.toHashCode(bY);var cj=this.__br[ch];if(!cj){cj=this.__br[ch]={};}var cf=ca+(cc?p:q);var ce=cj[cf];if(!ce){ce=cj[cf]=[];}if(ce.length===0){this.__bx(bY,ca,cc);}var ci=(qx.event.Manager.__bv++)+n;var cd={handler:cb,context:self,unique:ci};ce.push(cd);return cf+o+ci;},findHandler:function(bH,bI){var bS=false,bL=false,bT=false;var bR;if(bH.nodeType===1){bS=true;bR=f+bH.tagName.toLowerCase()+m+bI;}else if(bH==this.__bo){bL=true;bR=e+bI;}else if(bH.classname){bT=true;bR=a+bH.classname+m+bI;}else{bR=j+bH+m+bI;}var bN=this.__bu;if(bN[bR]){return bN[bR];}var bQ=this.__bq.getHandlers();var bM=qx.event.IEventHandler;var bO,bP,bK,bJ;for(var i=0,l=bQ.length;i<l;i++){bO=bQ[i];bK=bO.SUPPORTED_TYPES;if(bK&&!bK[bI]){continue;}bJ=bO.TARGET_CHECK;if(bJ){if(!bS&&bJ===bM.TARGET_DOMNODE){continue;}else if(!bL&&bJ===bM.TARGET_WINDOW){continue;}else if(!bT&&bJ===bM.TARGET_OBJECT){continue;}}bP=this.getHandler(bQ[i]);if(bO.IGNORE_CAN_HANDLE||bP.canHandleEvent(bH,bI)){bN[bR]=bP;return bP;}}return null;},__bx:function(cr,cs,ct){var cu=this.findHandler(cr,cs);if(cu){cu.registerEvent(cr,cs,ct);return;}{};},removeListener:function(cw,cx,cy,self,cz){var cD;{};var cE=cw.$$hash||qx.core.ObjectRegistry.toHashCode(cw);var cF=this.__br[cE];if(!cF){return false;}var cA=cx+(cz?p:q);var cB=cF[cA];if(!cB){return false;}var cC;for(var i=0,l=cB.length;i<l;i++){cC=cB[i];if(cC.handler===cy&&cC.context===self){qx.lang.Array.removeAt(cB,i);if(cB.length==0){this.__by(cw,cx,cz);}return true;}}return false;},removeListenerById:function(bt,bu){var bA;{};var by=bu.split(o);var bD=by[0];var bv=by[1].charCodeAt(0)==99;var bC=by[2];var bB=bt.$$hash||qx.core.ObjectRegistry.toHashCode(bt);var bE=this.__br[bB];if(!bE){return false;}var bz=bD+(bv?p:q);var bx=bE[bz];if(!bx){return false;}var bw;for(var i=0,l=bx.length;i<l;i++){bw=bx[i];if(bw.unique===bC){qx.lang.Array.removeAt(bx,i);if(bx.length==0){this.__by(bt,bD,bv);}return true;}}return false;},removeAllListeners:function(B){var F=B.$$hash||qx.core.ObjectRegistry.toHashCode(B);var H=this.__br[F];if(!H){return false;}var D,G,C;for(var E in H){if(H[E].length>0){D=E.split(o);G=D[0];C=D[1]===d;this.__by(B,G,C);}}delete this.__br[F];return true;},deleteAllListeners:function(cv){delete this.__br[cv];},__by:function(bU,bV,bW){var bX=this.findHandler(bU,bV);if(bX){bX.unregisterEvent(bU,bV,bW);return;}{};},dispatchEvent:function(I,event){var N;{};var O=event.getType();if(!event.getBubbles()&&!this.hasListener(I,O)){qx.event.Pool.getInstance().poolObject(event);return true;}if(!event.getTarget()){event.setTarget(I);}var M=this.__bq.getDispatchers();var L;var K=false;for(var i=0,l=M.length;i<l;i++){L=this.getDispatcher(M[i]);if(L.canDispatchEvent(I,event,O)){L.dispatchEvent(I,event,O);K=true;break;}}if(!K){{};return true;}var J=event.getDefaultPrevented();qx.event.Pool.getInstance().poolObject(event);return !J;},dispose:function(){this.__bq.removeManager(this);qx.util.DisposeUtil.disposeMap(this,h);qx.util.DisposeUtil.disposeMap(this,c);this.__br=this.__bo=this.__bw=null;this.__bq=this.__bu=null;}}});})();(function(){var l="qx.dom.Node",k="qx.client",j="";qx.Class.define(l,{statics:{ELEMENT:1,ATTRIBUTE:2,TEXT:3,CDATA_SECTION:4,ENTITY_REFERENCE:5,ENTITY:6,PROCESSING_INSTRUCTION:7,COMMENT:8,DOCUMENT:9,DOCUMENT_TYPE:10,DOCUMENT_FRAGMENT:11,NOTATION:12,getDocument:function(e){return e.nodeType===this.DOCUMENT?e:e.ownerDocument||e.document;},getWindow:qx.core.Variant.select(k,{"mshtml":function(p){if(p.nodeType==null){return p;}if(p.nodeType!==this.DOCUMENT){p=p.ownerDocument;}return p.parentWindow;},"default":function(b){if(b.nodeType==null){return b;}if(b.nodeType!==this.DOCUMENT){b=b.ownerDocument;}return b.defaultView;}}),getDocumentElement:function(g){return this.getDocument(g).documentElement;},getBodyElement:function(f){return this.getDocument(f).body;},isNode:function(h){return !!(h&&h.nodeType!=null);},isElement:function(c){return !!(c&&c.nodeType===this.ELEMENT);},isDocument:function(o){return !!(o&&o.nodeType===this.DOCUMENT);},isText:function(r){return !!(r&&r.nodeType===this.TEXT);},isWindow:function(q){return !!(q&&q.history&&q.location&&q.document);},isNodeName:function(m,n){if(!n||!m||!m.nodeName){return false;}return n.toLowerCase()==qx.dom.Node.getName(m);},getName:function(d){if(!d||!d.nodeName){return null;}return d.nodeName.toLowerCase();},getText:function(s){if(!s||!s.nodeType){return null;}switch(s.nodeType){case 1:var i,a=[],t=s.childNodes,length=t.length;for(i=0;i<length;i++){a[i]=this.getText(t[i]);}return a.join(j);case 2:return s.nodeValue;break;case 3:return s.nodeValue;break;}return null;}}});})();(function(){var A="mshtml",z="qx.client",y="[object Array]",x="qx.lang.Array",w="qx",v="number",u="string";qx.Class.define(x,{statics:{toArray:function(e,f){return this.cast(e,Array,f);},cast:function(n,o,p){if(n.constructor===o){return n;}if(qx.Class.hasInterface(n,qx.data.IListData)){var n=n.toArray();}var q=new o;if(qx.core.Variant.isSet(z,A)){if(n.item){for(var i=p||0,l=n.length;i<l;i++){q.push(n[i]);}return q;}}if(Object.prototype.toString.call(n)===y&&p==null){q.push.apply(q,n);}else{q.push.apply(q,Array.prototype.slice.call(n,p||0));}return q;},fromArguments:function(B,C){return Array.prototype.slice.call(B,C||0);},fromCollection:function(D){if(qx.core.Variant.isSet(z,A)){if(D.item){var E=[];for(var i=0,l=D.length;i<l;i++){E[i]=D[i];}return E;}}return Array.prototype.slice.call(D,0);},fromShortHand:function(j){var m=j.length;var k=qx.lang.Array.clone(j);switch(m){case 1:k[1]=k[2]=k[3]=k[0];break;case 2:k[2]=k[0];case 3:k[3]=k[1];}return k;},clone:function(d){return d.concat();},insertAt:function(g,h,i){g.splice(i,0,h);return g;},insertBefore:function(N,O,P){var i=N.indexOf(P);if(i==-1){N.push(O);}else{N.splice(i,0,O);}return N;},insertAfter:function(bj,bk,bl){var i=bj.indexOf(bl);if(i==-1||i==(bj.length-1)){bj.push(bk);}else{bj.splice(i+1,0,bk);}return bj;},removeAt:function(bm,i){return bm.splice(i,1)[0];},removeAll:function(bg){bg.length=0;return this;},append:function(H,I){{};Array.prototype.push.apply(H,I);return H;},exclude:function(J,K){{};for(var i=0,M=K.length,L;i<M;i++){L=J.indexOf(K[i]);if(L!=-1){J.splice(L,1);}}return J;},remove:function(F,G){var i=F.indexOf(G);if(i!=-1){F.splice(i,1);return G;}},contains:function(r,s){return r.indexOf(s)!==-1;},equals:function(Q,R){var length=Q.length;if(length!==R.length){return false;}for(var i=0;i<length;i++){if(Q[i]!==R[i]){return false;}}return true;},sum:function(bh){var bi=0;for(var i=0,l=bh.length;i<l;i++){bi+=bh[i];}return bi;},max:function(a){{};var i,c=a.length,b=a[0];for(i=1;i<c;i++){if(a[i]>b){b=a[i];}}return b===undefined?null:b;},min:function(bn){{};var i,bp=bn.length,bo=bn[0];for(i=1;i<bp;i++){if(bn[i]<bo){bo=bn[i];}}return bo===undefined?null:bo;},unique:function(S){var bd=[],U={},X={},ba={};var Y,T=0;var be=w+qx.lang.Date.now();var V=false,bc=false,bf=false;for(var i=0,bb=S.length;i<bb;i++){Y=S[i];if(Y===null){if(!V){V=true;bd.push(Y);}}else if(Y===undefined){}else if(Y===false){if(!bc){bc=true;bd.push(Y);}}else if(Y===true){if(!bf){bf=true;bd.push(Y);}}else if(typeof Y===u){if(!U[Y]){U[Y]=1;bd.push(Y);}}else if(typeof Y===v){if(!X[Y]){X[Y]=1;bd.push(Y);}}else{W=Y[be];if(W==null){W=Y[be]=T++;}if(!ba[W]){ba[W]=Y;bd.push(Y);}}}for(var W in ba){try{delete ba[W][be];}catch(t){try{ba[W][be]=null;}catch(bq){throw new Error("Cannot clean-up map entry doneObjects["+W+"]["+be+"]");}}}return bd;}}});})();(function(){var u="()",t=".",s=".prototype.",r='anonymous()',q="qx.lang.Function",p=".constructor()";qx.Class.define(q,{statics:{getCaller:function(l){return l.caller?l.caller.callee:l.callee.caller;},getName:function(e){if(e.displayName){return e.displayName;}if(e.$$original||e.wrapper||e.classname){return e.classname+p;}if(e.$$mixin){for(var g in e.$$mixin.$$members){if(e.$$mixin.$$members[g]==e){return e.$$mixin.name+s+g+u;}}for(var g in e.$$mixin){if(e.$$mixin[g]==e){return e.$$mixin.name+t+g+u;}}}if(e.self){var h=e.self.constructor;if(h){for(var g in h.prototype){if(h.prototype[g]==e){return h.classname+s+g+u;}}for(var g in h){if(h[g]==e){return h.classname+t+g+u;}}}}var f=e.toString().match(/function\s*(\w*)\s*\(.*/);if(f&&f.length>=1&&f[1]){return f[1]+u;}return r;},globalEval:function(D){if(window.execScript){return window.execScript(D);}else{return eval.call(window,D);}},empty:function(){},returnTrue:function(){return true;},returnFalse:function(){return false;},returnNull:function(){return null;},returnThis:function(){return this;},returnZero:function(){return 0;},create:function(A,B){{};if(!B){return A;}if(!(B.self||B.args||B.delay!=null||B.periodical!=null||B.attempt)){return A;}return function(event){{};var j=qx.lang.Array.fromArguments(arguments);if(B.args){j=B.args.concat(j);}if(B.delay||B.periodical){var i=qx.event.GlobalError.observeMethod(function(){return A.apply(B.self||this,j);});if(B.delay){return window.setTimeout(i,B.delay);}if(B.periodical){return window.setInterval(i,B.periodical);}}else if(B.attempt){var k=false;try{k=A.apply(B.self||this,j);}catch(C){}return k;}else{return A.apply(B.self||this,j);}};},bind:function(E,self,F){return this.create(E,{self:self,args:arguments.length>2?qx.lang.Array.fromArguments(arguments,2):null});},curry:function(v,w){return this.create(v,{args:arguments.length>1?qx.lang.Array.fromArguments(arguments,1):null});},listener:function(x,self,y){if(arguments.length<3){return function(event){return x.call(self||this,event||window.event);};}else{var z=qx.lang.Array.fromArguments(arguments,2);return function(event){var d=[event||window.event];d.push.apply(d,z);x.apply(self||this,d);};}},attempt:function(G,self,H){return this.create(G,{self:self,attempt:true,args:arguments.length>2?qx.lang.Array.fromArguments(arguments,2):null})();},delay:function(a,b,self,c){return this.create(a,{delay:b,self:self,args:arguments.length>3?qx.lang.Array.fromArguments(arguments,3):null})();},periodical:function(m,n,self,o){return this.create(m,{periodical:n,self:self,args:arguments.length>3?qx.lang.Array.fromArguments(arguments,3):null})();}}});})();(function(){var x="qx.event.Registration";qx.Class.define(x,{statics:{__bz:{},getManager:function(C){if(C==null){{};C=window;}else if(C.nodeType){C=qx.dom.Node.getWindow(C);}else if(!qx.dom.Node.isWindow(C)){C=window;}var E=C.$$hash||qx.core.ObjectRegistry.toHashCode(C);var D=this.__bz[E];if(!D){D=new qx.event.Manager(C,this);this.__bz[E]=D;}return D;},removeManager:function(o){var p=o.getWindowId();delete this.__bz[p];},addListener:function(c,d,e,self,f){return this.getManager(c).addListener(c,d,e,self,f);},removeListener:function(y,z,A,self,B){return this.getManager(y).removeListener(y,z,A,self,B);},removeListenerById:function(I,J){return this.getManager(I).removeListenerById(I,J);},removeAllListeners:function(G){return this.getManager(G).removeAllListeners(G);},deleteAllListeners:function(m){var n=m.$$hash;if(n){this.getManager(m).deleteAllListeners(n);}},hasListener:function(u,v,w){return this.getManager(u).hasListener(u,v,w);},serializeListeners:function(F){return this.getManager(F).serializeListeners(F);},createEvent:function(q,r,s){{};if(r==null){r=qx.event.type.Event;}var t=qx.event.Pool.getInstance().getObject(r);s?t.init.apply(t,s):t.init();if(q){t.setType(q);}return t;},dispatchEvent:function(Q,event){return this.getManager(Q).dispatchEvent(Q,event);},fireEvent:function(K,L,M,N){var O;{};var P=this.createEvent(L,M||null,N);return this.getManager(K).dispatchEvent(K,P);},fireNonBubblingEvent:function(g,h,i,j){{};var k=this.getManager(g);if(!k.hasListener(g,h,false)){return true;}var l=this.createEvent(h,i||null,j);return k.dispatchEvent(g,l);},PRIORITY_FIRST:-32000,PRIORITY_NORMAL:0,PRIORITY_LAST:32000,__bA:[],addHandler:function(H){{};this.__bA.push(H);this.__bA.sort(function(a,b){return a.PRIORITY-b.PRIORITY;});},getHandlers:function(){return this.__bA;},__bB:[],addDispatcher:function(R,S){{};this.__bB.push(R);this.__bB.sort(function(a,b){return a.PRIORITY-b.PRIORITY;});},getDispatchers:function(){return this.__bB;}}});})();(function(){var r=":",q="qx.client",p="anonymous",o="...",n="qx.dev.StackTrace",m="",l="\n",k="/source/class/",j=".";qx.Class.define(n,{statics:{getStackTrace:qx.core.Variant.select(q,{"gecko":function(){try{throw new Error();}catch(s){var A=this.getStackTraceFromError(s);qx.lang.Array.removeAt(A,0);var y=this.getStackTraceFromCaller(arguments);var w=y.length>A.length?y:A;for(var i=0;i<Math.min(y.length,A.length);i++){var x=y[i];if(x.indexOf(p)>=0){continue;}var E=x.split(r);if(E.length!=2){continue;}var C=E[0];var v=E[1];var u=A[i];var F=u.split(r);var B=F[0];var t=F[1];if(qx.Class.getByName(B)){var z=B;}else{z=C;}var D=z+r;if(v){D+=v+r;}D+=t;w[i]=D;}return w;}},"mshtml|webkit":function(){return this.getStackTraceFromCaller(arguments);},"opera":function(){var e;try{e.bar();}catch(N){var f=this.getStackTraceFromError(N);qx.lang.Array.removeAt(f,0);return f;}return [];}}),getStackTraceFromCaller:qx.core.Variant.select(q,{"opera":function(O){return [];},"default":function(W){var bc=[];var bb=qx.lang.Function.getCaller(W);var X={};while(bb){var Y=qx.lang.Function.getName(bb);bc.push(Y);try{bb=bb.caller;}catch(g){break;}if(!bb){break;}var ba=qx.core.ObjectRegistry.toHashCode(bb);if(X[ba]){bc.push(o);break;}X[ba]=bb;}return bc;}}),getStackTraceFromError:qx.core.Variant.select(q,{"gecko":function(G){if(!G.stack){return [];}var M=/@(.+):(\d+)$/gm;var H;var I=[];while((H=M.exec(G.stack))!=null){var J=H[1];var L=H[2];var K=this.__bC(J);I.push(K+r+L);}return I;},"webkit":function(h){if(h.sourceURL&&h.line){return [this.__bC(h.sourceURL)+r+h.line];}else{return [];}},"opera":function(P){if(P.message.indexOf("Backtrace:")<0){return [];}var R=[];var S=qx.lang.String.trim(P.message.split("Backtrace:")[1]);var T=S.split(l);for(var i=0;i<T.length;i++){var Q=T[i].match(/\s*Line ([0-9]+) of.* (\S.*)/);if(Q&&Q.length>=2){var V=Q[1];var U=this.__bC(Q[2]);R.push(U+r+V);}}return R;},"default":function(){return [];}}),__bC:function(a){var d=k;var b=a.indexOf(d);var c=(b==-1)?a:a.substring(b+d.length).replace(/\//g,j).replace(/\.js$/,m);return c;}}});})();(function(){var f="qx.lang.RingBuffer";qx.Class.define(f,{extend:Object,construct:function(g){this.setMaxEntries(g||50);},members:{__bD:0,__bE:0,__bF:false,__bG:0,__bH:null,__bI:null,setMaxEntries:function(h){this.__bI=h;this.clear();},getMaxEntries:function(){return this.__bI;},addEntry:function(i){this.__bH[this.__bD]=i;this.__bD=this.__bJ(this.__bD,1);var j=this.getMaxEntries();if(this.__bE<j){this.__bE++;}if(this.__bF&&(this.__bG<j)){this.__bG++;}},mark:function(){this.__bF=true;this.__bG=0;},clearMark:function(){this.__bF=false;},getAllEntries:function(){return this.getEntries(this.getMaxEntries(),false);},getEntries:function(a,b){if(a>this.__bE){a=this.__bE;}if(b&&this.__bF&&(a>this.__bG)){a=this.__bG;}if(a>0){var d=this.__bJ(this.__bD,-1);var c=this.__bJ(d,-a+1);var e;if(c<=d){e=this.__bH.slice(c,d+1);}else{e=this.__bH.slice(c,this.__bE).concat(this.__bH.slice(0,d+1));}}else{e=[];}return e;},clear:function(){this.__bH=new Array(this.getMaxEntries());this.__bE=0;this.__bG=0;this.__bD=0;},__bJ:function(k,l){var m=this.getMaxEntries();var n=(k+l)%m;if(n<0){n+=m;}return n;}}});})();(function(){var b="qx.log.appender.RingBuffer";qx.Class.define(b,{extend:qx.lang.RingBuffer,construct:function(d){this.setMaxMessages(d||50);},members:{setMaxMessages:function(a){this.setMaxEntries(a);},getMaxMessages:function(){return this.getMaxEntries();},process:function(c){this.addEntry(c);},getAllLogEvents:function(){return this.getAllEntries();},retrieveLogEvents:function(e,f){return this.getEntries(e,f);},clearHistory:function(){this.clear();}}});})();(function(){var bg="node",bf="error",be="...(+",bd="array",bc=")",bb="info",ba="instance",Y="string",X="null",W="class",bC="number",bB="stringify",bA="]",bz="date",by="unknown",bx="function",bw="boolean",bv="debug",bu="map",bt="undefined",bn="qx.log.Logger",bo="[",bl="#",bm="warn",bj="document",bk="{...(",bh="text[",bi="[...(",bp="\n",bq=")}",bs=")]",br="object";qx.Class.define(bn,{statics:{__bK:bv,setLevel:function(S){this.__bK=S;},getLevel:function(){return this.__bK;},setTreshold:function(V){this.__bN.setMaxMessages(V);},getTreshold:function(){return this.__bN.getMaxMessages();},__bL:{},__bM:0,register:function(a){if(a.$$id){return;}var c=this.__bM++;this.__bL[c]=a;a.$$id=c;var b=this.__bO;var d=this.__bN.getAllLogEvents();for(var i=0,l=d.length;i<l;i++){if(b[d[i].level]>=b[this.__bK]){a.process(d[i]);}}},unregister:function(e){var f=e.$$id;if(f==null){return;}delete this.__bL[f];delete e.$$id;},debug:function(bG,bH){qx.log.Logger.__bP(bv,arguments);},info:function(bK,bL){qx.log.Logger.__bP(bb,arguments);},warn:function(bI,bJ){qx.log.Logger.__bP(bm,arguments);},error:function(g,h){qx.log.Logger.__bP(bf,arguments);},trace:function(bO){qx.log.Logger.__bP(bb,[bO,qx.dev.StackTrace.getStackTrace().join(bp)]);},deprecatedMethodWarning:function(bP,bQ){var bR;{};},deprecatedClassWarning:function(j,k){var m;{};},deprecatedEventWarning:function(F,event,G){var H;{};},deprecatedMixinWarning:function(bD,bE){var bF;{};},deprecatedConstantWarning:function(w,x,y){var self,z;{};},deprecateMethodOverriding:function(A,B,C,D){var E;{};},clear:function(){this.__bN.clearHistory();},__bN:new qx.log.appender.RingBuffer(50),__bO:{debug:0,info:1,warn:2,error:3},__bP:function(I,J){var O=this.__bO;if(O[I]<O[this.__bK]){return;}var L=J.length<2?null:J[0];var N=L?1:0;var K=[];for(var i=N,l=J.length;i<l;i++){K.push(this.__bR(J[i],true));}var P=new Date;var Q={time:P,offset:P-qx.Bootstrap.LOADSTART,level:I,items:K,win:window};if(L){if(L instanceof qx.core.Object){Q.object=L.$$hash;}else if(L.$$type){Q.clazz=L;}}this.__bN.process(Q);var R=this.__bL;for(var M in R){R[M].process(Q);}},__bQ:function(T){if(T===undefined){return bt;}else if(T===null){return X;}if(T.$$type){return W;}var U=typeof T;if(U===bx||U==Y||U===bC||U===bw){return U;}else if(U===br){if(T.nodeType){return bg;}else if(T.classname){return ba;}else if(T instanceof Array){return bd;}else if(T instanceof Error){return bf;}else if(T instanceof Date){return bz;}else{return bu;}}if(T.toString){return bB;}return by;},__bR:function(n,o){var v=this.__bQ(n);var r=by;var q=[];switch(v){case X:case bt:r=v;break;case Y:case bC:case bw:case bz:r=n;break;case bg:if(n.nodeType===9){r=bj;}else if(n.nodeType===3){r=bh+n.nodeValue+bA;}else if(n.nodeType===1){r=n.nodeName.toLowerCase();if(n.id){r+=bl+n.id;}}else{r=bg;}break;case bx:r=qx.lang.Function.getName(n)||v;break;case ba:r=n.basename+bo+n.$$hash+bA;break;case W:case bB:r=n.toString();break;case bf:q=qx.dev.StackTrace.getStackTraceFromError(n);r=n.toString();break;case bd:if(o){r=[];for(var i=0,l=n.length;i<l;i++){if(r.length>20){r.push(be+(l-i)+bc);break;}r.push(this.__bR(n[i],false));}}else{r=bi+n.length+bs;}break;case bu:if(o){var p;var u=[];for(var t in n){u.push(t);}u.sort();r=[];for(var i=0,l=u.length;i<l;i++){if(r.length>20){r.push(be+(l-i)+bc);break;}t=u[i];p=this.__bR(n[t],false);p.key=t;r.push(p);}}else{var s=0;for(var t in n){s++;}r=bk+s+bq;}break;}return {type:v,text:r,trace:q};}},defer:function(bM){var bN=qx.Bootstrap.$$logs;for(var i=0;i<bN.length;i++){bM.__bP(bN[i][0],bN[i][1]);}qx.Bootstrap.debug=bM.debug;qx.Bootstrap.info=bM.info;qx.Bootstrap.warn=bM.warn;qx.Bootstrap.error=bM.error;qx.Bootstrap.trace=bM.trace;}});})();(function(){var H="set",G="get",F="reset",E="MSIE 6.0",D="info",C="qx.core.Object",B="error",A="warn",z="]",y="debug",v="[",x="$$user_",w="rv:1.8.1",u="Object";qx.Class.define(C,{extend:Object,include:[qx.data.MBinding],construct:function(){qx.core.ObjectRegistry.register(this);},statics:{$$type:u},members:{toHashCode:function(){return this.$$hash;},toString:function(){return this.classname+v+this.$$hash+z;},base:function(bq,br){{};if(arguments.length===1){return bq.callee.base.call(this);}else{return bq.callee.base.apply(this,Array.prototype.slice.call(arguments,1));}},self:function(bG){return bG.callee.self;},clone:function(){var h=this.constructor;var g=new h;var k=qx.Class.getProperties(h);var j=qx.core.Property.$$store.user;var m=qx.core.Property.$$method.set;var name;for(var i=0,l=k.length;i<l;i++){name=k[i];if(this.hasOwnProperty(j[name])){g[m[name]](this[j[name]]);}}return g;},set:function(P,Q){var S=qx.core.Property.$$method.set;if(qx.Bootstrap.isString(P)){if(!this[S[P]]){if(this[H+qx.Bootstrap.firstUp(P)]!=undefined){this[H+qx.Bootstrap.firstUp(P)](Q);return this;}{};}return this[S[P]](Q);}else{for(var R in P){if(!this[S[R]]){if(this[H+qx.Bootstrap.firstUp(R)]!=undefined){this[H+qx.Bootstrap.firstUp(R)](P[R]);continue;}{};}this[S[R]](P[R]);}return this;}},get:function(bc){var bd=qx.core.Property.$$method.get;if(!this[bd[bc]]){if(this[G+qx.Bootstrap.firstUp(bc)]!=undefined){return this[G+qx.Bootstrap.firstUp(bc)]();}{};}return this[bd[bc]]();},reset:function(be){var bf=qx.core.Property.$$method.reset;if(!this[bf[be]]){if(this[F+qx.Bootstrap.firstUp(be)]!=undefined){this[F+qx.Bootstrap.firstUp(be)]();return;}{};}this[bf[be]]();},__bS:qx.event.Registration,addListener:function(q,r,self,s){if(!this.$$disposed){return this.__bS.addListener(this,q,r,self,s);}return null;},addListenerOnce:function(bh,bi,self,bj){var bk=function(e){this.removeListener(bh,bk,this,bj);bi.call(self||this,e);};return this.addListener(bh,bk,this,bj);},removeListener:function(n,o,self,p){if(!this.$$disposed){return this.__bS.removeListener(this,n,o,self,p);}return false;},removeListenerById:function(bo){if(!this.$$disposed){return this.__bS.removeListenerById(this,bo);}return false;},hasListener:function(bs,bt){return this.__bS.hasListener(this,bs,bt);},dispatchEvent:function(I){if(!this.$$disposed){return this.__bS.dispatchEvent(this,I);}return true;},fireEvent:function(bl,bm,bn){if(!this.$$disposed){return this.__bS.fireEvent(this,bl,bm,bn);}return true;},fireNonBubblingEvent:function(bD,bE,bF){if(!this.$$disposed){return this.__bS.fireNonBubblingEvent(this,bD,bE,bF);}return true;},fireDataEvent:function(bu,bv,bw,bx){if(!this.$$disposed){if(bw===undefined){bw=null;}return this.__bS.fireNonBubblingEvent(this,bu,qx.event.type.Data,[bv,bw,!!bx]);}return true;},__bT:null,setUserData:function(bB,bC){if(!this.__bT){this.__bT={};}this.__bT[bB]=bC;},getUserData:function(by){if(!this.__bT){return null;}var bz=this.__bT[by];return bz===undefined?null:bz;},__bU:qx.log.Logger,debug:function(bg){this.__bV(y,arguments);},info:function(bp){this.__bV(D,arguments);},warn:function(a){this.__bV(A,arguments);},error:function(bN){this.__bV(B,arguments);},trace:function(){this.__bU.trace(this);},__bV:function(c,d){var f=qx.lang.Array.fromArguments(d);f.unshift(this);this.__bU[c].apply(this.__bU,f);},isDisposed:function(){return this.$$disposed||false;},dispose:function(){var N,L,K,O;if(this.$$disposed){return;}this.$$disposed=true;this.$$instance=null;this.$$allowconstruct=null;{};var M=this.constructor;var J;while(M.superclass){if(M.$$destructor){M.$$destructor.call(this);}if(M.$$includes){J=M.$$flatIncludes;for(var i=0,l=J.length;i<l;i++){if(J[i].$$destructor){J[i].$$destructor.call(this);}}}M=M.superclass;}if(this.__bW){this.__bW();}{};},__bW:null,__bX:function(){var t=qx.Class.getProperties(this.constructor);for(var i=0,l=t.length;i<l;i++){delete this[x+t[i]];}},_disposeObjects:function(bA){qx.util.DisposeUtil.disposeObjects(this,arguments);},_disposeSingletonObjects:function(bM){qx.util.DisposeUtil.disposeObjects(this,arguments,true);},_disposeArray:function(bH){qx.util.DisposeUtil.disposeArray(this,bH);},_disposeMap:function(b){qx.util.DisposeUtil.disposeMap(this,b);}},settings:{"qx.disposerDebugLevel":0},defer:function(bI,bJ){{};var bL=navigator.userAgent.indexOf(E)!=-1;var bK=navigator.userAgent.indexOf(w)!=-1;if(bL||bK){bJ.__bW=bJ.__bX;}},destruct:function(){if(!qx.core.ObjectRegistry.inShutDown){qx.event.Registration.removeAllListeners(this);}else{qx.event.Registration.deleteAllListeners(this);}qx.core.ObjectRegistry.unregister(this);this.__bT=null;var V=this.constructor;var ba;var bb=qx.core.Property.$$store;var X=bb.user;var Y=bb.theme;var T=bb.inherit;var W=bb.useinit;var U=bb.init;while(V){ba=V.$$properties;if(ba){for(var name in ba){if(ba[name].dereference){this[X[name]]=this[Y[name]]=this[T[name]]=this[W[name]]=this[U[name]]=undefined;}}}V=V.superclass;}}});})();(function(){var e="qx.ui.core.ISingleSelection",d="qx.event.type.Data";qx.Interface.define(e,{events:{"changeSelection":d},members:{getSelection:function(){return true;},setSelection:function(c){return arguments.length==1;},resetSelection:function(){return true;},isSelected:function(b){return arguments.length==1;},isSelectionEmpty:function(){return true;},getSelectables:function(a){return arguments.length==1;}}});})();(function(){var c="qx.event.type.Data",b="qx.ui.form.IForm";qx.Interface.define(b,{events:{"changeEnabled":c,"changeValid":c,"changeInvalidMessage":c,"changeRequired":c},members:{setEnabled:function(g){return arguments.length==1;},getEnabled:function(){},setRequired:function(a){return arguments.length==1;},getRequired:function(){},setValid:function(d){return arguments.length==1;},getValid:function(){},setInvalidMessage:function(f){return arguments.length==1;},getInvalidMessage:function(){},setRequiredInvalidMessage:function(e){return arguments.length==1;},getRequiredInvalidMessage:function(){}}});})();(function(){var a="qx.ui.form.IModelSelection";qx.Interface.define(a,{members:{setModelSelection:function(b){},getModelSelection:function(){}}});})();(function(){var h="qx.ui.core.MSingleSelectionHandling",g="changeSelection",f="changeSelected",d="__bY",c="qx.event.type.Data";qx.Mixin.define(h,{events:{"changeSelection":c},members:{__bY:null,getSelection:function(){var i=this.__ca().getSelected();if(i){return [i];}else{return [];}},setSelection:function(n){switch(n.length){case 0:this.resetSelection();break;case 1:this.__ca().setSelected(n[0]);break;default:throw new Error("Could only select one item, but the selection "+" array contains "+n.length+" items!");}},resetSelection:function(){this.__ca().resetSelected();},isSelected:function(b){return this.__ca().isSelected(b);},isSelectionEmpty:function(){return this.__ca().isSelectionEmpty();},getSelectables:function(j){return this.__ca().getSelectables(j);},_onChangeSelected:function(e){var m=e.getData();var l=e.getOldData();m==null?m=[]:m=[m];l==null?l=[]:l=[l];this.fireDataEvent(g,m,l);},__ca:function(){if(this.__bY==null){var k=this;this.__bY=new qx.ui.core.SingleSelectionManager({getItems:function(){return k._getItems();},isItemSelectable:function(a){if(k._isItemSelectable){return k._isItemSelectable(a);}else{return a.isVisible();}}});this.__bY.addListener(f,this._onChangeSelected,this);}this.__bY.setAllowEmptySelection(this._isAllowEmptySelection());return this.__bY;}},destruct:function(){this._disposeObjects(d);}});})();(function(){var e="change",d="__cb",c="qx.event.type.Data",b="qx.ui.form.MModelSelection",a="changeSelection";qx.Mixin.define(b,{construct:function(){this.__cb=new qx.data.Array();this.__cb.addListener(e,this.__ce,this);this.addListener(a,this.__cd,this);},events:{changeModelSelection:c},members:{__cb:null,__cc:false,__cd:function(){if(this.__cc){return;}var s=this.getSelection();var q=[];for(var i=0;i<s.length;i++){var t=s[i];var r=t.getModel?t.getModel():null;if(r!==null){q.push(r);}}if(q.length===s.length){this.setModelSelection(q);}},__ce:function(){this.__cc=true;var g=this.getSelectables(true);var k=[];var h=this.__cb.toArray();for(var i=0;i<h.length;i++){var m=h[i];for(var j=0;j<g.length;j++){var n=g[j];var f=n.getModel?n.getModel():null;if(m===f){k.push(n);break;}}}this.setSelection(k);this.__cc=false;var l=this.getSelection();if(!qx.lang.Array.equals(l,k)){this.__cd();}},getModelSelection:function(){return this.__cb;},setModelSelection:function(o){if(!o){this.__cb.removeAll();return;}{};o.unshift(this.__cb.getLength());o.unshift(0);var p=this.__cb.splice.apply(this.__cb,o);p.dispose();}},destruct:function(){this._disposeObjects(d);}});})();(function(){var y="Boolean",x="changeInvalidMessage",w="changeValue",v="String",u="_applyAllowEmptySelection",t="_applyInvalidMessage",s="qx.ui.form.RadioGroup",r="_applyValid",q="",p="changeRequired",m="changeValid",o="changeEnabled",n="__cf",k="changeSelection",j="_applyEnabled";qx.Class.define(s,{extend:qx.core.Object,implement:[qx.ui.core.ISingleSelection,qx.ui.form.IForm,qx.ui.form.IModelSelection],include:[qx.ui.core.MSingleSelectionHandling,qx.ui.form.MModelSelection],construct:function(d){qx.core.Object.call(this);this.__cf=[];this.addListener(k,this.__cg,this);if(d!=null){this.add.apply(this,arguments);}},properties:{enabled:{check:y,apply:j,event:o,init:true},wrap:{check:y,init:true},allowEmptySelection:{check:y,init:false,apply:u},valid:{check:y,init:true,apply:r,event:m},required:{check:y,init:false,event:p},invalidMessage:{check:v,init:q,event:x,apply:t},requiredInvalidMessage:{check:v,nullable:true,event:x}},members:{__cf:null,getItems:function(){return this.__cf;},add:function(B){var C=this.__cf;var D;for(var i=0,l=arguments.length;i<l;i++){D=arguments[i];if(qx.lang.Array.contains(C,D)){continue;}D.addListener(w,this._onItemChangeChecked,this);C.push(D);D.setGroup(this);if(D.getValue()){this.setSelection([D]);}}if(!this.isAllowEmptySelection()&&C.length>0&&!this.getSelection()[0]){this.setSelection([C[0]]);}},remove:function(E){var F=this.__cf;if(qx.lang.Array.contains(F,E)){qx.lang.Array.remove(F,E);if(E.getGroup()===this){E.resetGroup();}E.removeListener(w,this._onItemChangeChecked,this);if(E.getValue()){this.resetSelection();}}},getChildren:function(){return this.__cf;},_onItemChangeChecked:function(e){var a=e.getTarget();if(a.getValue()){this.setSelection([a]);}else if(this.getSelection()[0]==a){this.resetSelection();}},_applyInvalidMessage:function(z,A){for(var i=0;i<this.__cf.length;i++){this.__cf[i].setInvalidMessage(z);}},_applyValid:function(M,N){for(var i=0;i<this.__cf.length;i++){this.__cf[i].setValid(M);}},_applyEnabled:function(f,g){var h=this.__cf;if(f==null){for(var i=0,l=h.length;i<l;i++){h[i].resetEnabled();}}else{for(var i=0,l=h.length;i<l;i++){h[i].setEnabled(f);}}},_applyAllowEmptySelection:function(O,P){if(!O&&this.isSelectionEmpty()){this.resetSelection();}},selectNext:function(){var G=this.getSelection()[0];var I=this.__cf;var H=I.indexOf(G);if(H==-1){return;}var i=0;var length=I.length;if(this.getWrap()){H=(H+1)%length;}else{H=Math.min(H+1,length-1);}while(i<length&&!I[H].getEnabled()){H=(H+1)%length;i++;}this.setSelection([I[H]]);},selectPrevious:function(){var J=this.getSelection()[0];var L=this.__cf;var K=L.indexOf(J);if(K==-1){return;}var i=0;var length=L.length;if(this.getWrap()){K=(K-1+length)%length;}else{K=Math.max(K-1,0);}while(i<length&&!L[K].getEnabled()){K=(K-1+length)%length;i++;}this.setSelection([L[K]]);},_getItems:function(){return this.getItems();},_isAllowEmptySelection:function(){return this.isAllowEmptySelection();},__cg:function(e){var c=e.getData()[0];var b=e.getOldData()[0];if(b){b.setValue(false);}if(c){c.setValue(true);}}},destruct:function(){this._disposeArray(n);}});})();(function(){var c="qx.event.type.Event";qx.Class.define(c,{extend:qx.core.Object,statics:{CAPTURING_PHASE:1,AT_TARGET:2,BUBBLING_PHASE:3},members:{init:function(e,f){{};this._type=null;this._target=null;this._currentTarget=null;this._relatedTarget=null;this._originalTarget=null;this._stopPropagation=false;this._preventDefault=false;this._bubbles=!!e;this._cancelable=!!f;this._timeStamp=(new Date()).getTime();this._eventPhase=null;return this;},clone:function(i){if(i){var j=i;}else{var j=qx.event.Pool.getInstance().getObject(this.constructor);}j._type=this._type;j._target=this._target;j._currentTarget=this._currentTarget;j._relatedTarget=this._relatedTarget;j._originalTarget=this._originalTarget;j._stopPropagation=this._stopPropagation;j._bubbles=this._bubbles;j._preventDefault=this._preventDefault;j._cancelable=this._cancelable;return j;},stop:function(){if(this._bubbles){this.stopPropagation();}if(this._cancelable){this.preventDefault();}},stopPropagation:function(){{};this._stopPropagation=true;},getPropagationStopped:function(){return !!this._stopPropagation;},preventDefault:function(){{};this._preventDefault=true;},getDefaultPrevented:function(){return !!this._preventDefault;},getType:function(){return this._type;},setType:function(k){this._type=k;},getEventPhase:function(){return this._eventPhase;},setEventPhase:function(m){this._eventPhase=m;},getTimeStamp:function(){return this._timeStamp;},getTarget:function(){return this._target;},setTarget:function(b){this._target=b;},getCurrentTarget:function(){return this._currentTarget||this._target;},setCurrentTarget:function(h){this._currentTarget=h;},getRelatedTarget:function(){return this._relatedTarget;},setRelatedTarget:function(g){this._relatedTarget=g;},getOriginalTarget:function(){return this._originalTarget;},setOriginalTarget:function(a){this._originalTarget=a;},getBubbles:function(){return this._bubbles;},setBubbles:function(d){this._bubbles=d;},isCancelable:function(){return this._cancelable;},setCancelable:function(l){this._cancelable=l;}},destruct:function(){this._target=this._currentTarget=this._relatedTarget=this._originalTarget=null;}});})();(function(){var a="qx.event.type.Data";qx.Class.define(a,{extend:qx.event.type.Event,members:{__ch:null,__ci:null,init:function(b,c,d){qx.event.type.Event.prototype.init.call(this,false,d);this.__ch=b;this.__ci=c;return this;},clone:function(e){var f=qx.event.type.Event.prototype.clone.call(this,e);f.__ch=this.__ch;f.__ci=this.__ci;return f;},getData:function(){return this.__ch;},getOldData:function(){return this.__ci;}},destruct:function(){this.__ch=this.__ci=null;}});})();(function(){var bF="get",bE="",bD="[",bC="last",bB="change",bA="]",bz=".",by="Number",bx="String",bw="set",bW="deepBinding",bV="item",bU="reset",bT="' (",bS="Boolean",bR=").",bQ=") to the object '",bP="Integer",bO=" of object ",bN="qx.data.SingleValueBinding",bL="Binding property ",bM="PositiveNumber",bJ="Binding from '",bK="PositiveInteger",bH="Binding does not exist!",bI="Date",bG=" not possible: No event available. ";qx.Class.define(bN,{statics:{DEBUG_ON:false,__cj:{},bind:function(cB,cC,cD,cE,cF){var cP=this.__cl(cB,cC,cD,cE,cF);var cK=cC.split(bz);var cH=this.__cs(cK);var cO=[];var cL=[];var cM=[];var cI=[];var cJ=cB;for(var i=0;i<cK.length;i++){if(cH[i]!==bE){cI.push(bB);}else{cI.push(this.__cn(cJ,cK[i]));}cO[i]=cJ;if(i==cK.length-1){if(cH[i]!==bE){var cS=cH[i]===bC?cJ.length-1:cH[i];var cG=cJ.getItem(cS);this.__cr(cG,cD,cE,cF,cB);cM[i]=this.__ct(cJ,cI[i],cD,cE,cF,cH[i]);}else{if(cK[i]!=null&&cJ[bF+qx.lang.String.firstUp(cK[i])]!=null){var cG=cJ[bF+qx.lang.String.firstUp(cK[i])]();this.__cr(cG,cD,cE,cF,cB);}cM[i]=this.__ct(cJ,cI[i],cD,cE,cF);}}else{var cQ={index:i,propertyNames:cK,sources:cO,listenerIds:cM,arrayIndexValues:cH,targetObject:cD,targetPropertyChain:cE,options:cF,listeners:cL};var cN=qx.lang.Function.bind(this.__ck,this,cQ);cL.push(cN);cM[i]=cJ.addListener(cI[i],cN);}if(cJ[bF+qx.lang.String.firstUp(cK[i])]==null){cJ=null;}else if(cH[i]!==bE){cJ=cJ[bF+qx.lang.String.firstUp(cK[i])](cH[i]);}else{cJ=cJ[bF+qx.lang.String.firstUp(cK[i])]();}if(!cJ){break;}}var cR={type:bW,listenerIds:cM,sources:cO,targetListenerIds:cP.listenerIds,targets:cP.targets};this.__cu(cR,cB,cC,cD,cE);return cR;},__ck:function(cl){if(cl.options&&cl.options.onUpdate){cl.options.onUpdate(cl.sources[cl.index],cl.targetObject);}for(var j=cl.index+1;j<cl.propertyNames.length;j++){var cp=cl.sources[j];cl.sources[j]=null;if(!cp){continue;}cp.removeListenerById(cl.listenerIds[j]);}var cp=cl.sources[cl.index];for(var j=cl.index+1;j<cl.propertyNames.length;j++){if(cl.arrayIndexValues[j-1]!==bE){cp=cp[bF+qx.lang.String.firstUp(cl.propertyNames[j-1])](cl.arrayIndexValues[j-1]);}else{cp=cp[bF+qx.lang.String.firstUp(cl.propertyNames[j-1])]();}cl.sources[j]=cp;if(!cp){this.__co(cl.targetObject,cl.targetPropertyChain);break;}if(j==cl.propertyNames.length-1){if(qx.Class.implementsInterface(cp,qx.data.IListData)){var cq=cl.arrayIndexValues[j]===bC?cp.length-1:cl.arrayIndexValues[j];var cn=cp.getItem(cq);this.__cr(cn,cl.targetObject,cl.targetPropertyChain,cl.options,cl.sources[cl.index]);cl.listenerIds[j]=this.__ct(cp,bB,cl.targetObject,cl.targetPropertyChain,cl.options,cl.arrayIndexValues[j]);}else{if(cl.propertyNames[j]!=null&&cp[bF+qx.lang.String.firstUp(cl.propertyNames[j])]!=null){var cn=cp[bF+qx.lang.String.firstUp(cl.propertyNames[j])]();this.__cr(cn,cl.targetObject,cl.targetPropertyChain,cl.options,cl.sources[cl.index]);}var co=this.__cn(cp,cl.propertyNames[j]);cl.listenerIds[j]=this.__ct(cp,co,cl.targetObject,cl.targetPropertyChain,cl.options);}}else{if(cl.listeners[j]==null){var cm=qx.lang.Function.bind(this.__ck,this,cl);cl.listeners.push(cm);}if(qx.Class.implementsInterface(cp,qx.data.IListData)){var co=bB;}else{var co=this.__cn(cp,cl.propertyNames[j]);}cl.listenerIds[j]=cp.addListener(co,cl.listeners[j]);}}},__cl:function(ba,bb,bc,bd,be){var bi=bd.split(bz);var bg=this.__cs(bi);var bn=[];var bm=[];var bk=[];var bj=[];var bh=bc;for(var i=0;i<bi.length-1;i++){if(bg[i]!==bE){bj.push(bB);}else{try{bj.push(this.__cn(bh,bi[i]));}catch(e){break;}}bn[i]=bh;var bl=function(){for(var j=i+1;j<bi.length-1;j++){var cV=bn[j];bn[j]=null;if(!cV){continue;}cV.removeListenerById(bk[j]);}var cV=bn[i];for(var j=i+1;j<bi.length-1;j++){var cT=qx.lang.String.firstUp(bi[j-1]);if(bg[j-1]!==bE){var cW=bg[j-1]===bC?cV.getLength()-1:bg[j-1];cV=cV[bF+cT](cW);}else{cV=cV[bF+cT]();}bn[j]=cV;if(bm[j]==null){bm.push(bl);}if(qx.Class.implementsInterface(cV,qx.data.IListData)){var cU=bB;}else{try{var cU=qx.data.SingleValueBinding.__cn(cV,bi[j]);}catch(e){break;}}bk[j]=cV.addListener(cU,bm[j]);}qx.data.SingleValueBinding.__cm(ba,bb,bc,bd,be);};bm.push(bl);bk[i]=bh.addListener(bj[i],bl);var bf=qx.lang.String.firstUp(bi[i]);if(bh[bF+bf]==null){bh=null;}else if(bg[i]!==bE){bh=bh[bF+bf](bg[i]);}else{bh=bh[bF+bf]();}if(!bh){break;}}return {listenerIds:bk,targets:bn};},__cm:function(ca,cb,cc,cd,ce){var ci=this.__cq(ca,cb);if(ci!=null){var ck=cb.substring(cb.lastIndexOf(bz)+1,cb.length);if(ck.charAt(ck.length-1)==bA){var cf=ck.substring(ck.lastIndexOf(bD)+1,ck.length-1);var ch=ck.substring(0,ck.lastIndexOf(bD));var cj=ci[bF+qx.lang.String.firstUp(ch)]();if(cf==bC){cf=cj.length-1;}if(cj!=null){var cg=cj.getItem(cf);}}else{var cg=ci[bF+qx.lang.String.firstUp(ck)]();}}cg=qx.data.SingleValueBinding.__cv(cg,cc,cd,ce);this.__cp(cc,cd,cg);},__cn:function(a,b){var c=this.__cw(a,b);if(c==null){if(qx.Class.supportsEvent(a.constructor,b)){c=b;}else if(qx.Class.supportsEvent(a.constructor,bB+qx.lang.String.firstUp(b))){c=bB+qx.lang.String.firstUp(b);}else{throw new qx.core.AssertionError(bL+b+bO+a+bG);}}return c;},__co:function(bs,bt){var bu=this.__cq(bs,bt);if(bu!=null){var bv=bt.substring(bt.lastIndexOf(bz)+1,bt.length);if(bv.charAt(bv.length-1)==bA){this.__cp(bs,bt,null);return;}if(bu[bU+qx.lang.String.firstUp(bv)]!=undefined){bu[bU+qx.lang.String.firstUp(bv)]();}else{bu[bw+qx.lang.String.firstUp(bv)](null);}}},__cp:function(cr,cs,ct){var cx=this.__cq(cr,cs);if(cx!=null){var cy=cs.substring(cs.lastIndexOf(bz)+1,cs.length);if(cy.charAt(cy.length-1)==bA){var cu=cy.substring(cy.lastIndexOf(bD)+1,cy.length-1);var cw=cy.substring(0,cy.lastIndexOf(bD));var cv=cx[bF+qx.lang.String.firstUp(cw)]();if(cu==bC){cu=cv.length-1;}if(cv!=null){cv.setItem(cu,ct);}}else{cx[bw+qx.lang.String.firstUp(cy)](ct);}}},__cq:function(cX,cY){var dc=cY.split(bz);var dd=cX;for(var i=0;i<dc.length-1;i++){try{var db=dc[i];if(db.indexOf(bA)==db.length-1){var da=db.substring(db.indexOf(bD)+1,db.length-1);db=db.substring(0,db.indexOf(bD));}dd=dd[bF+qx.lang.String.firstUp(db)]();if(da!=null){if(da==bC){da=dd.length-1;}dd=dd.getItem(da);da=null;}}catch(G){return null;}}return dd;},__cr:function(R,S,T,U,V){R=this.__cv(R,S,T,U);if(R===undefined){this.__co(S,T);}if(R!==undefined){try{this.__cp(S,T,R);if(U&&U.onUpdate){U.onUpdate(V,S,R);}}catch(e){if(!(e instanceof qx.core.ValidationError)){throw e;}if(U&&U.onSetFail){U.onSetFail(e);}else{qx.log.Logger.warn("Failed so set value "+R+" on "+S+". Error message: "+e);}}}},__cs:function(bo){var bp=[];for(var i=0;i<bo.length;i++){var name=bo[i];if(qx.lang.String.endsWith(name,bA)){var bq=name.substring(name.indexOf(bD)+1,name.indexOf(bA));if(name.indexOf(bA)!=name.length-1){throw new Error("Please use only one array at a time: "+name+" does not work.");}if(bq!==bC){if(bq==bE||isNaN(parseInt(bq))){throw new Error("No number or 'last' value hast been given"+" in a array binding: "+name+" does not work.");}}if(name.indexOf(bD)!=0){bo[i]=name.substring(0,name.indexOf(bD));bp[i]=bE;bp[i+1]=bq;bo.splice(i+1,0,bV);i++;}else{bp[i]=bq;bo.splice(i,1,bV);}}else{bp[i]=bE;}}return bp;},__ct:function(d,f,g,h,k,l){var m;{};var o=function(H,e){if(H!==bE){if(H===bC){H=d.length-1;}var K=d.getItem(H);if(K===undefined){qx.data.SingleValueBinding.__co(g,h);}var I=e.getData().start;var J=e.getData().end;if(H<I||H>J){return;}}else{var K=e.getData();}if(qx.data.SingleValueBinding.DEBUG_ON){qx.log.Logger.debug("Binding executed from "+d+" by "+f+" to "+g+" ("+h+")");qx.log.Logger.debug("Data before conversion: "+K);}K=qx.data.SingleValueBinding.__cv(K,g,h,k);if(qx.data.SingleValueBinding.DEBUG_ON){qx.log.Logger.debug("Data after conversion: "+K);}try{if(K!==undefined){qx.data.SingleValueBinding.__cp(g,h,K);}else{qx.data.SingleValueBinding.__co(g,h);}if(k&&k.onUpdate){k.onUpdate(d,g,K);}}catch(e){if(!(e instanceof qx.core.ValidationError)){throw e;}if(k&&k.onSetFail){k.onSetFail(e);}else{qx.log.Logger.warn("Failed so set value "+K+" on "+g+". Error message: "+e);}}};if(!l){l=bE;}o=qx.lang.Function.bind(o,d,l);var n=d.addListener(f,o);return n;},__cu:function(p,q,r,s,t){if(this.__cj[q.toHashCode()]===undefined){this.__cj[q.toHashCode()]=[];}this.__cj[q.toHashCode()].push([p,q,r,s,t]);},__cv:function(u,v,w,x){if(x&&x.converter){var z;if(v.getModel){z=v.getModel();}return x.converter(u,z);}else{var B=this.__cq(v,w);var C=w.substring(w.lastIndexOf(bz)+1,w.length);if(B==null){return u;}var A=qx.Class.getPropertyDefinition(B.constructor,C);var y=A==null?bE:A.check;return this.__cx(u,y);}},__cw:function(de,df){var dg=qx.Class.getPropertyDefinition(de.constructor,df);if(dg==null){return null;}return dg.event;},__cx:function(D,E){var F=qx.lang.Type.getClass(D);if((F==by||F==bx)&&(E==bP||E==bK)){D=parseInt(D);}if((F==bS||F==by||F==bI)&&E==bx){D=D+bE;}if((F==by||F==bx)&&(E==by||E==bM)){D=parseFloat(D);}return D;},removeBindingFromObject:function(W,X){if(X.type==bW){for(var i=0;i<X.sources.length;i++){if(X.sources[i]){X.sources[i].removeListenerById(X.listenerIds[i]);}}for(var i=0;i<X.targets.length;i++){if(X.targets[i]){X.targets[i].removeListenerById(X.targetListenerIds[i]);}}}else{W.removeListenerById(X);}var Y=this.__cj[W.toHashCode()];if(Y!=undefined){for(var i=0;i<Y.length;i++){if(Y[i][0]==X){qx.lang.Array.remove(Y,Y[i]);return;}}}throw new Error("Binding could not be found!");},removeAllBindingsForObject:function(L){{};var M=this.__cj[L.toHashCode()];if(M!=undefined){for(var i=M.length-1;i>=0;i--){this.removeBindingFromObject(L,M[i][0]);}}},getAllBindingsForObject:function(br){if(this.__cj[br.toHashCode()]===undefined){this.__cj[br.toHashCode()]=[];}return this.__cj[br.toHashCode()];},removeAllBindings:function(){for(var bY in this.__cj){var bX=qx.core.ObjectRegistry.fromHashCode(bY);if(bX==null){delete this.__cj[bY];continue;}this.removeAllBindingsForObject(bX);}this.__cj={};},getAllBindings:function(){return this.__cj;},showBindingInLog:function(N,O){var Q;for(var i=0;i<this.__cj[N.toHashCode()].length;i++){if(this.__cj[N.toHashCode()][i][0]==O){Q=this.__cj[N.toHashCode()][i];break;}}if(Q===undefined){var P=bH;}else{var P=bJ+Q[1]+bT+Q[2]+bQ+Q[3]+bT+Q[4]+bR;}qx.log.Logger.debug(P);},showAllBindingsInLog:function(){for(var cA in this.__cj){var cz=qx.core.ObjectRegistry.fromHashCode(cA);for(var i=0;i<this.__cj[cA].length;i++){this.showBindingInLog(cz,this.__cj[cA][i][0]);}}}}});})();(function(){var I="",H="g",G="0",F='\\$1',E="%",D='-',C="qx.lang.String",B=' ',A='\n',z="undefined";qx.Class.define(C,{statics:{camelCase:function(j){return j.replace(/\-([a-z])/g,function(l,m){return m.toUpperCase();});},hyphenate:function(Q){return Q.replace(/[A-Z]/g,function(d){return (D+d.charAt(0).toLowerCase());});},capitalize:function(h){return h.replace(/\b[a-z]/g,function(a){return a.toUpperCase();});},clean:function(M){return this.trim(M.replace(/\s+/g,B));},trimLeft:function(r){return r.replace(/^\s+/,I);},trimRight:function(y){return y.replace(/\s+$/,I);},trim:function(J){return J.replace(/^\s+|\s+$/g,I);},startsWith:function(O,P){return O.indexOf(P)===0;},endsWith:function(b,c){return b.substring(b.length-c.length,b.length)===c;},repeat:function(s,t){return s.length>0?new Array(t+1).join(s):I;},pad:function(o,length,p){var q=length-o.length;if(q>0){if(typeof p===z){p=G;}return this.repeat(p,q)+o;}else{return o;}},firstUp:qx.Bootstrap.firstUp,firstLow:qx.Bootstrap.firstLow,contains:function(K,L){return K.indexOf(L)!=-1;},format:function(e,f){var g=e;for(var i=0;i<f.length;i++){g=g.replace(new RegExp(E+(i+1),H),f[i]+I);}return g;},escapeRegexpChars:function(N){return N.replace(/([.*+?^${}()|[\]\/\\])/g,F);},toArray:function(n){return n.split(/\B|\b/g);},stripTags:function(k){return k.replace(/<\/?[^>]+>/gi,I);},stripScripts:function(u,v){var x=I;var w=u.replace(/<script[^>]*>([\s\S]*?)<\/script>/gi,function(){x+=arguments[1]+A;return I;});if(v===true){qx.lang.Function.globalEval(x);}return w;}}});})();(function(){var c="qx.event.type.Data",b="qx.event.type.Event",a="qx.data.IListData";qx.Interface.define(a,{events:{"change":c,"changeLength":b},members:{getItem:function(d){},setItem:function(e,f){},splice:function(h,i,j){},contains:function(g){},getLength:function(){},toArray:function(){}}});})();(function(){var a="qx.lang.Date";qx.Class.define(a,{statics:{now:function(){return +new Date;}}});})();(function(){var g="qx.globalErrorHandling",f="on",d="qx.event.GlobalError";qx.Bootstrap.define(d,{statics:{setErrorHandler:function(h,i){this.__cy=h||null;this.__cz=i||window;if(qx.core.Setting.get(g)===f){if(h&&window.onerror){var j=qx.Bootstrap.bind(this.__cB,this);if(this.__cA==null){this.__cA=window.onerror;}var self=this;window.onerror=function(e){self.__cA(e);j(e);};}if(h&&!window.onerror){window.onerror=qx.Bootstrap.bind(this.__cB,this);}if(this.__cy==null){if(this.__cA!=null){window.onerror=this.__cA;this.__cA=null;}else{window.onerror=null;}}}},__cB:function(a,b,c){if(this.__cy){this.handleError(new qx.core.WindowError(a,b,c));return true;}},observeMethod:function(n){if(qx.core.Setting.get(g)===f){var self=this;return function(){if(!self.__cy){return n.apply(this,arguments);}try{return n.apply(this,arguments);}catch(l){self.handleError(new qx.core.GlobalError(l,arguments));}};}else{return n;}},handleError:function(k){if(this.__cy){this.__cy.call(this.__cz,k);}}},defer:function(m){qx.core.Setting.define(g,f);m.setErrorHandler(null,null);}});})();(function(){var e="",d="qx.core.WindowError";qx.Bootstrap.define(d,{extend:Error,construct:function(a,b,c){Error.call(this,a);this.__cC=a;this.__cD=b||e;this.__cE=c===undefined?-1:c;},members:{__cC:null,__cD:null,__cE:null,toString:function(){return this.__cC;},getUri:function(){return this.__cD;},getLineNumber:function(){return this.__cE;}}});})();(function(){var b="GlobalError: ",a="qx.core.GlobalError";qx.Bootstrap.define(a,{extend:Error,construct:function(c,d){{};this.__cF=b+(c&&c.message?c.message:c);Error.call(this,this.__cF);this.__cG=d;this.__cH=c;},members:{__cH:null,__cG:null,__cF:null,toString:function(){return this.__cF;},getArguments:function(){return this.__cG;},getSourceException:function(){return this.__cH;}},destruct:function(){this.__cH=null;this.__cG=null;this.__cF=null;}});})();(function(){var c=": ",b="qx.type.BaseError",a="";qx.Class.define(b,{extend:Error,construct:function(d,e){Error.call(this,e);this.__cI=d||a;this.message=e||qx.type.BaseError.DEFAULTMESSAGE;},statics:{DEFAULTMESSAGE:"error"},members:{__cI:null,message:null,getComment:function(){return this.__cI;},toString:function(){return this.__cI+c+this.message;}}});})();(function(){var a="qx.core.AssertionError";qx.Class.define(a,{extend:qx.type.BaseError,construct:function(b,c){qx.type.BaseError.call(this,b,c);this.__cJ=qx.dev.StackTrace.getStackTrace();},members:{__cJ:null,getStackTrace:function(){return this.__cJ;}}});})();(function(){var a="qx.core.ValidationError";qx.Class.define(a,{extend:qx.type.BaseError});})();(function(){var h="qx.lang.Type",g="Error",f="RegExp",e="Date",d="Number",c="Boolean";qx.Class.define(h,{statics:{getClass:qx.Bootstrap.getClass,isString:qx.Bootstrap.isString,isArray:qx.Bootstrap.isArray,isObject:qx.Bootstrap.isObject,isFunction:qx.Bootstrap.isFunction,isRegExp:function(k){return this.getClass(k)==f;},isNumber:function(i){return (i!==null&&(this.getClass(i)==d||i instanceof Number));},isBoolean:function(a){return (a!==null&&(this.getClass(a)==c||a instanceof Boolean));},isDate:function(b){return (b!==null&&(this.getClass(b)==e||b instanceof Date));},isError:function(j){return (j!==null&&(this.getClass(j)==g||j instanceof Error));}}});})();(function(){var d="qx.event.IEventHandler";qx.Interface.define(d,{statics:{TARGET_DOMNODE:1,TARGET_WINDOW:2,TARGET_OBJECT:3},members:{canHandleEvent:function(e,f){},registerEvent:function(g,h,i){},unregisterEvent:function(a,b,c){}}});})();(function(){var b="qx.util.ObjectPool",a="Integer";qx.Class.define(b,{extend:qx.core.Object,construct:function(n){qx.core.Object.call(this);this.__cK={};if(n!=null){this.setSize(n);}},properties:{size:{check:a,init:Infinity}},members:{__cK:null,getObject:function(c){if(this.$$disposed){return new c;}if(!c){throw new Error("Class needs to be defined!");}var d=null;var e=this.__cK[c.classname];if(e){d=e.pop();}if(d){d.$$pooled=false;}else{d=new c;}return d;},poolObject:function(j){if(!this.__cK){return;}var k=j.classname;var m=this.__cK[k];if(j.$$pooled){throw new Error("Object is already pooled: "+j);}if(!m){this.__cK[k]=m=[];}if(m.length>this.getSize()){if(j.destroy){j.destroy();}else{j.dispose();}return;}j.$$pooled=true;m.push(j);}},destruct:function(){var h=this.__cK;var f,g,i,l;for(f in h){g=h[f];for(i=0,l=g.length;i<l;i++){g[i].dispose();}}delete this.__cK;}});})();(function(){var b="singleton",a="qx.event.Pool";qx.Class.define(a,{extend:qx.util.ObjectPool,type:b,construct:function(){qx.util.ObjectPool.call(this,30);}});})();(function(){var f="qx.util.DisposeUtil";qx.Class.define(f,{statics:{disposeObjects:function(m,n,o){var name;for(var i=0,l=n.length;i<l;i++){name=n[i];if(m[name]==null||!m.hasOwnProperty(name)){continue;}if(!qx.core.ObjectRegistry.inShutDown){if(m[name].dispose){if(!o&&m[name].constructor.$$instance){throw new Error("The object stored in key "+name+" is a singleton! Please use disposeSingleton instead.");}else{m[name].dispose();}}else{throw new Error("Has no disposable object under key: "+name+"!");}}m[name]=null;}},disposeArray:function(g,h){var k=g[h];if(!k){return;}if(qx.core.ObjectRegistry.inShutDown){g[h]=null;return;}try{var j;for(var i=k.length-1;i>=0;i--){j=k[i];if(j){j.dispose();}}}catch(e){throw new Error("The array field: "+h+" of object: "+g+" has non disposable entries: "+e);}k.length=0;g[h]=null;},disposeMap:function(p,q){var s=p[q];if(!s){return;}if(qx.core.ObjectRegistry.inShutDown){p[q]=null;return;}try{var r;for(var t in s){r=s[t];if(s.hasOwnProperty(t)&&r){r.dispose();}}}catch(a){throw new Error("The map field: "+q+" of object: "+p+" has non disposable entries: "+a);}p[q]=null;},disposeTriggeredBy:function(b,c){var d=c.dispose;c.dispose=function(){d.call(c);b.dispose();};}}});})();(function(){var a="qx.event.IEventDispatcher";qx.Interface.define(a,{members:{canDispatchEvent:function(b,event,c){this.assertInstance(event,qx.event.type.Event);this.assertString(c);},dispatchEvent:function(d,event,e){this.assertInstance(event,qx.event.type.Event);this.assertString(e);}}});})();(function(){var a="qx.event.dispatch.Direct";qx.Class.define(a,{extend:qx.core.Object,implement:qx.event.IEventDispatcher,construct:function(j){this._manager=j;},statics:{PRIORITY:qx.event.Registration.PRIORITY_LAST},members:{canDispatchEvent:function(k,event,m){return !event.getBubbles();},dispatchEvent:function(b,event,c){var f,d;{};event.setEventPhase(qx.event.type.Event.AT_TARGET);var g=this._manager.getListeners(b,c,false);if(g){for(var i=0,l=g.length;i<l;i++){var e=g[i].context||b;g[i].handler.call(e,event);}}}},defer:function(h){qx.event.Registration.addDispatcher(h);}});})();(function(){var b="qx.event.handler.Object";qx.Class.define(b,{extend:qx.core.Object,implement:qx.event.IEventHandler,statics:{PRIORITY:qx.event.Registration.PRIORITY_LAST,SUPPORTED_TYPES:null,TARGET_CHECK:qx.event.IEventHandler.TARGET_OBJECT,IGNORE_CAN_HANDLE:false},members:{canHandleEvent:function(i,j){return qx.Class.supportsEvent(i.constructor,j);},registerEvent:function(c,d,e){},unregisterEvent:function(f,g,h){}},defer:function(a){qx.event.Registration.addHandler(a);}});})();(function(){var m="indexOf",k="lastIndexOf",j="slice",h="concat",g="join",f="toLocaleUpperCase",e="shift",d="substr",c="filter",b="unshift",J="match",I="quote",H="qx.lang.Generics",G="localeCompare",F="sort",E="some",D="charAt",C="split",B="substring",A="pop",u="toUpperCase",v="replace",r="push",t="charCodeAt",p="every",q="reverse",n="search",o="forEach",w="map",x="toLowerCase",z="splice",y="toLocaleLowerCase";qx.Class.define(H,{statics:{__cL:{"Array":[g,q,F,r,A,e,b,z,h,j,m,k,o,w,c,E,p],"String":[I,B,x,u,D,t,m,k,y,f,G,J,n,v,C,d,h,j]},__cM:function(K,L){return function(s){return K.prototype[L].apply(s,Array.prototype.slice.call(arguments,1));};},__cN:function(){var M=qx.lang.Generics.__cL;for(var Q in M){var O=window[Q];var N=M[Q];for(var i=0,l=N.length;i<l;i++){var P=N[i];if(!O[P]){O[P]=qx.lang.Generics.__cM(O,P);}}}}},defer:function(a){a.__cN();}});})();(function(){var j="__cQ",h="__cP",g="Boolean",f="qx.ui.core.SingleSelectionManager",e="__cO",d="changeSelected",c="qx.event.type.Data";qx.Class.define(f,{extend:qx.core.Object,construct:function(b){qx.core.Object.call(this);{};this.__cO=b;},events:{"changeSelected":c},properties:{allowEmptySelection:{check:g,init:true,apply:j}},members:{__cP:null,__cO:null,getSelected:function(){return this.__cP;},setSelected:function(v){if(!this.__cS(v)){throw new Error("Could not select "+v+", because it is not a child element!");}this.__cR(v);},resetSelected:function(){this.__cR(null);},isSelected:function(a){if(!this.__cS(a)){throw new Error("Could not check if "+a+" is selected,"+" because it is not a child element!");}return this.__cP===a;},isSelectionEmpty:function(){return this.__cP==null;},getSelectables:function(k){var l=this.__cO.getItems();var m=[];for(var i=0;i<l.length;i++){if(this.__cO.isItemSelectable(l[i])){m.push(l[i]);}}if(!k){for(var i=m.length-1;i>=0;i--){if(!m[i].getEnabled()){m.splice(i,1);}}}return m;},__cQ:function(p,q){if(!p){this.__cR(this.__cP);}},__cR:function(r){var u=this.__cP;var t=r;if(t!=null&&u===t){return;}if(!this.isAllowEmptySelection()&&t==null){var s=this.getSelectables(true)[0];if(s){t=s;}}this.__cP=t;this.fireDataEvent(d,t,u);},__cS:function(n){var o=this.__cO.getItems();for(var i=0;i<o.length;i++){if(o[i]===n){return true;}}return false;}},destruct:function(){if(this.__cO.toHashCode){this._disposeObjects(e);}else{this.__cO=null;}this._disposeObjects(h);}});})();(function(){var h="[",g="]",f=".",d="idBubble",c="changeBubble",b="qx.data.marshal.MEventBubbling",a="qx.event.type.Data";qx.Mixin.define(b,{events:{"changeBubble":a},members:{_applyEventPropagation:function(u,v,name){this.fireDataEvent(c,{value:u,name:name,old:v});this._registerEventChaining(u,v,name);},_registerEventChaining:function(q,r,name){if((q instanceof qx.core.Object)&&qx.Class.hasMixin(q.constructor,qx.data.marshal.MEventBubbling)){var s=qx.lang.Function.bind(this.__cT,this,name);var t=q.addListener(c,s,this);q.setUserData(d,t);}if(r!=null&&r.getUserData&&r.getUserData(d)!=null){r.removeListenerById(r.getUserData(d));}},__cT:function(name,e){var p=e.getData();var l=p.value;var j=p.old;if(qx.Class.hasInterface(e.getTarget().constructor,qx.data.IListData)){if(p.name.indexOf){var o=p.name.indexOf(f)!=-1?p.name.indexOf(f):p.name.length;var m=p.name.indexOf(h)!=-1?p.name.indexOf(h):p.name.length;if(o<m){var i=p.name.substring(0,o);var n=p.name.substring(o+1,p.name.length);if(n[0]!=h){n=f+n;}var k=name+h+i+g+n;}else if(m<o){var i=p.name.substring(0,m);var n=p.name.substring(m,p.name.length);var k=name+h+i+g+n;}else{var k=name+h+p.name+g;}}else{var k=name+h+p.name+g;}}else{var k=name+f+p.name;}this.fireDataEvent(c,{value:l,name:k,old:j});}}});})();(function(){var F="change",E="add",D="remove",C="order",B="qx.event.type.Data",A="",z="qx.data.Array",y="?",x="changeBubble",w="number",v="changeLength";qx.Class.define(z,{extend:qx.core.Object,include:qx.data.marshal.MEventBubbling,implement:[qx.data.IListData],construct:function(Y){qx.core.Object.call(this);if(Y==undefined){this.__cU=[];}else if(arguments.length>1){this.__cU=[];for(var i=0;i<arguments.length;i++){this.__cU.push(arguments[i]);}}else if(typeof Y==w){this.__cU=new Array(Y);}else if(Y instanceof Array){this.__cU=qx.lang.Array.clone(Y);}else{this.__cU=[];throw new Error("Type of the parameter not supported!");}for(var i=0;i<this.__cU.length;i++){this._applyEventPropagation(this.__cU[i],null,i);}this.__cV();},events:{"change":B,"changeLength":B},members:{__cU:null,concat:function(N){if(N){var O=this.__cU.concat(N);}else{var O=this.__cU.concat();}return new qx.data.Array(O);},join:function(W){return this.__cU.join(W);},pop:function(){var b=this.__cU.pop();this.__cV();this._applyEventPropagation(null,b,this.length-1);this.fireDataEvent(F,{start:this.length-1,end:this.length-1,type:D,items:[b]},null);return b;},push:function(U){for(var i=0;i<arguments.length;i++){this.__cU.push(arguments[i]);this.__cV();this._applyEventPropagation(arguments[i],null,this.length-1);this.fireDataEvent(F,{start:this.length-1,end:this.length-1,type:E,items:[arguments[i]]},null);}return this.length;},reverse:function(){this.__cU.reverse();this.fireDataEvent(F,{start:0,end:this.length-1,type:C,items:null},null);},shift:function(){var P=this.__cU.shift();this.__cV();this._applyEventPropagation(null,P,this.length-1);this.fireDataEvent(F,{start:0,end:this.length-1,type:D,items:[P]},null);return P;},slice:function(m,n){return new qx.data.Array(this.__cU.slice(m,n));},splice:function(c,d,e){var l=this.__cU.length;var h=this.__cU.splice.apply(this.__cU,arguments);if(this.__cU.length!=l){this.__cV();}var j=d>0;var f=arguments.length>2;var g=null;if(j||f){if(this.__cU.length>l){var k=E;}else if(this.__cU.length<l){var k=D;g=h;}else{var k=C;}this.fireDataEvent(F,{start:c,end:this.length-1,type:k,items:g},null);}for(var i=2;i<arguments.length;i++){this._registerEventChaining(arguments[i],null,c+i);}this.fireDataEvent(x,{value:this,name:y,old:h});for(var i=0;i<h.length;i++){this._applyEventPropagation(null,h[i],i);}return (new qx.data.Array(h));},sort:function(u){this.__cU.sort.apply(this.__cU,arguments);this.fireDataEvent(F,{start:0,end:this.length-1,type:C,items:null},null);},unshift:function(bh){for(var i=arguments.length-1;i>=0;i--){this.__cU.unshift(arguments[i]);this.__cV();this._applyEventPropagation(arguments[i],null,0);this.fireDataEvent(F,{start:0,end:this.length-1,type:E,items:[arguments[i]]},null);}return this.length;},toArray:function(){return this.__cU;},getItem:function(be){return this.__cU[be];},setItem:function(G,H){var I=this.__cU[G];if(I===H){return;}this.__cU[G]=H;this._applyEventPropagation(H,I,G);if(this.length!=this.__cU.length){this.__cV();}this.fireDataEvent(F,{start:G,end:G,type:E,items:[H]},null);},getLength:function(){return this.length;},indexOf:function(bf){return this.__cU.indexOf(bf);},toString:function(){if(this.__cU!=null){return this.__cU.toString();}return A;},contains:function(X){return this.__cU.indexOf(X)!==-1;},copy:function(){return this.concat();},insertAt:function(Q,R){this.splice(Q,0,R);},insertBefore:function(K,L){var M=this.indexOf(K);if(M==-1){this.push(L);}else{this.splice(M,0,L);}},insertAfter:function(r,s){var t=this.indexOf(r);if(t==-1||t==(this.length-1)){this.push(s);}else{this.splice(t+1,0,s);}},removeAt:function(J){return this.splice(J,1).getItem(0);},removeAll:function(){for(var i=0;i<this.__cU.length;i++){this._applyEventPropagation(null,this.__cU[i],i);}var T=this.getLength();var S=this.__cU.concat();this.__cU.length=0;this.__cV();this.fireDataEvent(F,{start:0,end:T-1,type:D,items:S},null);},append:function(ba){if(ba instanceof qx.data.Array){ba=ba.toArray();}{};for(var i=0;i<ba.length;i++){this._applyEventPropagation(ba[i],null,this.__cU.length+i);}Array.prototype.push.apply(this.__cU,ba);var bb=this.length;this.__cV();this.fireDataEvent(F,{start:bb,end:this.length-1,type:E,items:ba},null);},remove:function(bc){var bd=this.indexOf(bc);if(bd!=-1){this.splice(bd,1);return bc;}},equals:function(V){if(this.length!==V.length){return false;}for(var i=0;i<this.length;i++){if(this.getItem(i)!==V.getItem(i)){return false;}}return true;},sum:function(){var bg=0;for(var i=0;i<this.length;i++){bg+=this.getItem(i);}return bg;},max:function(){var a=this.getItem(0);for(var i=1;i<this.length;i++){if(this.getItem(i)>a){a=this.getItem(i);}}return a===undefined?null:a;},min:function(){var o=this.getItem(0);for(var i=1;i<this.length;i++){if(this.getItem(i)<o){o=this.getItem(i);}}return o===undefined?null:o;},forEach:function(p,q){for(var i=0;i<this.__cU.length;i++){p.call(q,this.__cU[i]);}},__cV:function(){var bi=this.length;this.length=this.__cU.length;this.fireDataEvent(v,this.length,bi);}},destruct:function(){for(var i=0;i<this.__cU.length;i++){this._applyEventPropagation(null,this.__cU[i],i);}this.__cU=null;}});})();(function(){var i="qx.event.type.Data",h="partLoadingError",g="qx.io.PartLoader",f="partLoaded",e="success",d="singleton";qx.Class.define(g,{type:d,extend:qx.core.Object,construct:function(){qx.core.Object.call(this);var a=this._loader=qx.Part.getInstance();var self=this;a.onpart=function(j){if(j.readyState==e){self.fireDataEvent(f,j);}else{self.fireDataEvent(h,j.name);}};},events:{"partLoaded":i,"partLoadingError":i},statics:{require:function(b,c,self){this.getInstance().require(b,c,self);}},members:{require:function(k,l,self){return this._loader.require(k,l,self);},getPart:function(name){return this._loader.getPart(name);}}});})();(function(){var o="success",n="complete",m="error",l="load",k="fail",j="qx.client",i="loaded",h="readystatechange",g="head",f="qx.io.ScriptLoader",b="mshtml|webkit",d="script",c="text/javascript",a="abort";qx.Bootstrap.define(f,{construct:function(){this.__cW=qx.Bootstrap.bind(this.__dd,this);this.__cX=document.createElement(d);},members:{__cY:null,__da:null,__db:null,__dc:null,__cW:null,__cX:null,load:function(q,r,s){if(this.__cY){throw new Error("Another request is still running!");}this.__cY=true;this.__da=false;var t=document.getElementsByTagName(g)[0];var u=this.__cX;this.__db=r||null;this.__dc=s||window;u.type=c;u.onerror=u.onload=u.onreadystatechange=this.__cW;u.src=q;setTimeout(function(){t.appendChild(u);},0);},abort:function(){if(this.__cY){this.dispose(a);}},dispose:function(status){if(this.__da){return;}this.__da=true;var w=this.__cX;w.onerror=w.onload=w.onreadystatechange=null;var v=w.parentNode;if(v){v.removeChild(w);}delete this.__cY;if(this.__db){if(qx.core.Variant.isSet(j,b)){var self=this;setTimeout(qx.event.GlobalError.observeMethod(function(){self.__db.call(self.__dc,status);delete self.__db;}),0);}else{this.__db.call(this.__dc,status);delete this.__db;}}},__dd:qx.event.GlobalError.observeMethod(qx.core.Variant.select(j,{"mshtml":function(e){var p=this.__cX.readyState;if(p==i){this.dispose(o);}else if(p==n){this.dispose(o);}else{return;}},"opera":function(e){if(qx.Bootstrap.isString(e)||e.type===m){return this.dispose(k);}else if(e.type===l){return this.dispose(o);}else{return;}},"default":function(e){if(qx.Bootstrap.isString(e)||e.type===m){this.dispose(k);}else if(e.type===l){this.dispose(o);}else if(e.type===h&&(e.target.readyState===n||e.target.readyState===i)){this.dispose(o);}else{return;}}}))}});})();(function(){var p="function",o="qx.Part",n="complete";qx.Bootstrap.define(o,{construct:function(r){var z=r.parts[r.boot][0];this.__de=r;this.__df={};this.__dg={};this.__dh={};this.__di=[];var A=this.__dk();for(var i=0;i<A.length;i++){var s=r.packageHashes[i];var w=new qx.io.part.Package(A[i],s,i==z);this.__di.push(w);}this.__dj={};var v=r.parts;var t=r.closureParts||{};for(var name in v){var u=v[name];var y=[];for(var i=0;i<u.length;i++){y.push(this.__di[u[i]]);}if(t[name]){var x=new qx.io.part.ClosurePart(name,y,this);}else{var x=new qx.io.part.Part(name,y,this);}this.__dj[name]=x;}},statics:{TIMEOUT:7500,getInstance:function(){if(!this.$$instance){this.$$instance=new this(qx.$$loader);}return this.$$instance;},require:function(g,h,self){this.getInstance().require(g,h,self);},preload:function(Y){this.getInstance().preload(Y);},$$notifyLoad:function(e,f){this.getInstance().saveClosure(e,f);}},members:{__de:null,__di:null,__dj:null,__dh:null,addToPackage:function(q){this.__di.push(q);},addClosurePackageListener:function(j,k){var l=j.getId();if(!this.__dh[l]){this.__dh[l]=[];}this.__dh[l].push(k);},saveClosure:function(a,b){var d;for(var i=0;i<this.__di.length;i++){if(this.__di[i].getId()==a){d=this.__di[i];break;}}if(!d){throw new Error("Package not available: "+a);}d.saveClosure(b);var c=this.__dh[a];if(!c){return;}for(var i=0;i<c.length;i++){c[i](n,a);}this.__dh[a]=[];},getParts:function(){return this.__dj;},require:function(K,L,self){var L=L||function(){};var self=self||window;if(qx.Bootstrap.isString(K)){K=[K];}var O=[];for(var i=0;i<K.length;i++){O.push(this.__dj[K[i]]);}var N=0;var M=function(){N+=1;if(N>=O.length){var S=[];for(var i=0;i<O.length;i++){S.push(O[i].getReadyState());}L.call(self,S);}};for(var i=0;i<O.length;i++){O[i].load(M,this);}},preload:function(B,C,self){if(qx.Bootstrap.isString(B)){B=[B];}var D=0;for(var i=0;i<B.length;i++){this.__dj[B[i]].preload(function(){D++;if(D>=B.length){var m=[];for(var i=0;i<B.length;i++){m.push(this.__dj[B[i]].getReadyState());}if(C){C.call(self,m);}}},this);}},__dk:function(){var T=this.__de.uris;var U=[];for(var i=0;i<T.length;i++){U.push(this.__dl(T[i]));}return U;},__dl:qx.$$loader.decodeUris,__df:null,addPartListener:function(E,F){var G=E.getName();if(!this.__df[G]){this.__df[G]=[];}this.__df[G].push(F);},onpart:null,notifyPartResult:function(H){var J=H.getName();var I=this.__df[J];if(I){for(var i=0;i<I.length;i++){I[i](H.getReadyState());}this.__df[J]=[];}if(typeof this.onpart==p){this.onpart(H);}},__dg:null,addPackageListener:function(V,W){var X=V.getId();if(!this.__dg[X]){this.__dg[X]=[];}this.__dg[X].push(W);},notifyPackageResult:function(P){var R=P.getId();var Q=this.__dg[R];if(!Q){return;}for(var i=0;i<Q.length;i++){Q[i](P.getReadyState());}this.__dg[R]=[];}}});})();(function(){var o="error",n="initialized",m="loading",l="complete",k="webkit",j="qx.client",i="success",h="qx.io.part.Package",g="cached";qx.Bootstrap.define(h,{construct:function(u,v,w){this.__dm=w?l:n;this.__dn=u;this.__do=v;},members:{__dm:null,__dn:null,__do:null,__dp:null,__dq:null,__dr:null,__ds:null,getId:function(){return this.__do;},getReadyState:function(){return this.__dm;},getUrls:function(){return this.__dn;},saveClosure:function(t){if(this.__dm==o){return;}this.__dp=t;if(!this.__dq){this.execute();}else{clearTimeout(this.__dr);this.__dm=g;this.__ds(this);}},execute:function(){if(this.__dp){this.__dp();delete this.__dp;}if(qx.$$packageData[this.__do]){this.__du(qx.$$packageData[this.__do]);delete qx.$$packageData[this.__do];}this.__dm=l;},loadClosure:function(p,self){if(this.__dm!==n){return;}this.__dq=true;this.__dm=m;this.__ds=qx.Bootstrap.bind(p,self);this.__dt(this.__dn,function(){},function(){this.__dm=o;p.call(self,this);},this);var q=this;this.__dr=setTimeout(function(){q.__dm=o;p.call(self,q);},qx.Part.TIMEOUT);},load:function(a,self){if(this.__dm!==n){return;}this.__dq=false;this.__dm=m;this.__dt(this.__dn,function(){this.__dm=l;this.execute();a.call(self,this);},function(){this.__dm=o;a.call(self,this);},this);},__dt:function(b,c,d,self){if(b.length==0){c.call(self);return;}var f=0;var self=this;var e=function(r){if(f>=b.length){c.call(self);return;}var s=new qx.io.ScriptLoader();s.load(r.shift(),function(status){f+=1;s.dispose();if(status!==i){if(self.__dm==m){clearTimeout(self.__dr);return d.call(self);}}if(qx.core.Variant.isSet(j,k)){setTimeout(function(){e.call(self,r,c,self);},0);}else{e.call(self,r,c,self);}},self);};e(b.concat());},__du:qx.$$loader.importPackageData}});})();(function(){var j="complete",h="loading",g="error",f="initialized",e="qx.io.part.Part";qx.Bootstrap.define(e,{construct:function(name,p,q){this.__dv=name;this._readyState=j;this._packages=p;this._loader=q;for(var i=0;i<p.length;i++){if(p[i].getReadyState()!==j){this._readyState=f;break;}}},members:{_readyState:null,_loader:null,_packages:null,__dv:null,getReadyState:function(){return this._readyState;},getName:function(){return this.__dv;},getPackages:function(){return this._packages;},preload:function(o,self){if(o){window.setTimeout(function(){o.call(self,this);},0);}},load:function(a,self){if(this._checkCompleteLoading(a,self)){return;}this._readyState=h;if(a){this._appendPartListener(a,self,this);}var c=this;var b=function(){c.load();};for(var i=0;i<this._packages.length;i++){var d=this._packages[i];switch(d.getReadyState()){case f:this._loader.addPackageListener(d,b);d.load(this._loader.notifyPackageResult,this._loader);return;case h:this._loader.addPackageListener(d,b);return;case j:break;case g:this._markAsCompleted(g);return;default:throw new Error("Invalid case! "+d.getReadyState());}}this._markAsCompleted(j);},_appendPartListener:function(r,self,s){var t=this;this._loader.addPartListener(this,function(){t._signalStartup();r.call(self,s._readyState);});},_markAsCompleted:function(k){this._readyState=k;this._loader.notifyPartResult(this);},_signalStartup:function(){if(!qx.$$loader.applicationHandlerReady){qx.$$loader.signalStartup();}},_checkCompleteLoading:function(l,self){var m=this._readyState;if(m==j||m==g){if(l){var n=this;setTimeout(function(){n._signalStartup();l.call(self,m);},0);}return true;}else if(m==h&&l){this._appendPartListener(l,self,this);return true;}}}});})();(function(){var h="error",g="initialized",f="loading",e="qx.io.part.ClosurePart",d="complete";qx.Bootstrap.define(e,{extend:qx.io.part.Part,construct:function(name,k,l){qx.io.part.Part.call(this,name,k,l);},members:{__dw:0,preload:function(n,self){var o=0;var q=this;for(var i=0;i<this._packages.length;i++){var p=this._packages[i];if(p.getReadyState()==g){p.loadClosure(function(j){o++;q._loader.notifyPackageResult(j);if(o>=q._packages.length&&n){n.call(self);}},this._loader);}}},load:function(a,self){if(this._checkCompleteLoading(a,self)){return;}this._readyState=f;if(a){this._appendPartListener(a,self,this);}this.__dw=this._packages.length;for(var i=0;i<this._packages.length;i++){var c=this._packages[i];var b=c.getReadyState();if(b==g){c.loadClosure(this._loader.notifyPackageResult,this._loader);}if(b==g||b==f){this._loader.addPackageListener(c,qx.Bootstrap.bind(this._onPackageLoad,this,c));}else if(b==h){this._markAsCompleted(h);return;}else{this.__dw--;}}if(this.__dw<=0){this.__dx();}},__dx:function(){for(var i=0;i<this._packages.length;i++){this._packages[i].execute();}this._markAsCompleted(d);},_onPackageLoad:function(m){if(this._readyState==h){return;}if(m.getReadyState()==h){this._markAsCompleted(h);return;}this.__dw--;if(this.__dw<=0){this.__dx();}}}});})();(function(){var m="qx.ui.treevirtual.MTreePrimitive",l="<virtual root>";qx.Mixin.define(m,{statics:{Type:{LEAF:1,BRANCH:2},_addNode:function(a,b,c,d,e,f,g,h,i){var k;if(b){k=a[b];if(!k){throw new Error("Request to add a child to a non-existent parent");}if(k.type==qx.ui.treevirtual.SimpleTreeDataModel.Type.LEAF){throw new Error("Sorry, a LEAF may not have children.");}}else{k=a[0];b=0;}if(f==qx.ui.treevirtual.SimpleTreeDataModel.Type.LEAF){d=false;e=false;}if(i===undefined){i=a.length;}var j={type:f,nodeId:i,parentNodeId:b,label:c,bSelected:false,bOpened:d,bHideOpenClose:e,icon:g,iconSelected:h,children:[],columnData:[]};a[i]=j;k.children.push(i);return i;},_getEmptyTree:function(){return {label:l,nodeId:0,bOpened:true,children:[]};}}});})();(function(){var l="qx.event.type.Data",k="qx.event.type.Event",j="qx.ui.table.ITableModel";qx.Interface.define(j,{events:{"dataChanged":l,"metaDataChanged":k,"sorted":l},members:{getRowCount:function(){},getRowData:function(r){},getColumnCount:function(){},getColumnId:function(h){},getColumnIndexById:function(o){},getColumnName:function(u){},isColumnEditable:function(d){},isColumnSortable:function(i){},sortByColumn:function(v,w){},getSortColumnIndex:function(){},isSortAscending:function(){},prefetchRows:function(p,q){},getValue:function(m,n){},getValueById:function(s,t){},setValue:function(e,f,g){},setValueById:function(a,b,c){}}});})();(function(){var u="metaDataChanged",t="qx.event.type.Data",s="qx.event.type.Event",r="abstract",q="qx.ui.table.model.Abstract";qx.Class.define(q,{type:r,extend:qx.core.Object,implement:qx.ui.table.ITableModel,events:{"dataChanged":t,"metaDataChanged":s,"sorted":t},construct:function(){qx.core.Object.call(this);this.__dy=[];this.__dz=[];this.__dA={};},members:{__dy:null,__dz:null,__dA:null,__dB:null,init:function(j){},getRowCount:function(){throw new Error("getRowCount is abstract");},getRowData:function(a){return null;},isColumnEditable:function(x){return false;},isColumnSortable:function(l){return false;},sortByColumn:function(d,e){},getSortColumnIndex:function(){return -1;},isSortAscending:function(){return true;},prefetchRows:function(v,w){},getValue:function(B,C){throw new Error("getValue is abstract");},getValueById:function(g,h){return this.getValue(this.getColumnIndexById(g),h);},setValue:function(m,n,o){throw new Error("setValue is abstract");},setValueById:function(D,E,F){this.setValue(this.getColumnIndexById(D),E,F);},getColumnCount:function(){return this.__dy.length;},getColumnIndexById:function(G){return this.__dA[G];},getColumnId:function(p){return this.__dy[p];},getColumnName:function(c){return this.__dz[c];},setColumnIds:function(f){this.__dy=f;this.__dA={};for(var i=0;i<f.length;i++){this.__dA[f[i]]=i;}this.__dz=new Array(f.length);if(!this.__dB){this.fireEvent(u);}},setColumnNamesByIndex:function(b){if(this.__dy.length!=b.length){throw new Error("this.__columnIdArr and columnNameArr have different length: "+this.__dy.length+" != "+b.length);}this.__dz=b;this.fireEvent(u);},setColumnNamesById:function(k){this.__dz=new Array(this.__dy.length);for(var i=0;i<this.__dy.length;++i){this.__dz[i]=k[this.__dy[i]];}},setColumns:function(y,z){var A=this.__dy.length==0||z;if(z==null){if(this.__dy.length==0){z=y;}else{z=this.__dy;}}if(z.length!=y.length){throw new Error("columnIdArr and columnNameArr have different length: "+z.length+" != "+y.length);}if(A){this.__dB=true;this.setColumnIds(z);this.__dB=false;}this.setColumnNamesByIndex(y);}},destruct:function(){this.__dy=this.__dz=this.__dA=null;}});})();(function(){var u="number",t="dataChanged",s="object",r="metaDataChanged",q="treeOpenWhileEmpty",p="treeOpenWithContent",o="bSelected",n="qx.ui.treevirtual.SimpleTreeDataModel",m="bOpened",l="treeClose";qx.Class.define(n,{extend:qx.ui.table.model.Abstract,include:qx.ui.treevirtual.MTreePrimitive,construct:function(){qx.ui.table.model.Abstract.call(this);this._rowArr=[];this._nodeArr=[];this._nodeRowMap=[];this._treeColumn=0;this._selections={};this._nodeArr.push(qx.ui.treevirtual.MTreePrimitive._getEmptyTree());this.__dC=null;},members:{__dD:null,__dC:null,_rowArr:null,_nodeArr:null,_nodeRowMap:null,_treeColumn:null,_selections:null,setTree:function(y){this.__dD=y;},getTree:function(){return this.__dD;},setEditable:function(bn){this.__dC=[];for(var bo=0;bo<this.getColumnCount();bo++){this.__dC[bo]=bn;}this.fireEvent(r);},setColumnEditable:function(bz,bA){if(bA!=this.isColumnEditable(bz)){if(this.__dC==null){this.__dC=[];}this.__dC[bz]=bA;this.fireEvent(r);}},isColumnEditable:function(v){if(v==this._treeColumn){return false;}return (this.__dC?this.__dC[v]==true:false);},isColumnSortable:function(z){return false;},sortByColumn:function(bj,bk){throw new Error("Trees can not be sorted by column");},getSortColumnIndex:function(){return -1;},setTreeColumn:function(bB){this._treeColumn=bB;},getTreeColumn:function(){return this._treeColumn;},getRowCount:function(){return this._rowArr.length;},getRowData:function(bE){return this._rowArr[bE];},getValue:function(w,x){if(x<0||x>=this._rowArr.length){throw new Error("this._rowArr row "+"("+x+") out of bounds: "+this._rowArr+" (0.."+(this._rowArr.length-1)+")");}if(w<0||w>=this._rowArr[x].length){throw new Error("this._rowArr column "+"("+w+") out of bounds: "+this._rowArr[x]+" (0.."+(this._rowArr[x].length-1)+")");}return this._rowArr[x][w];},setValue:function(bu,bv,bw){if(bu==this._treeColumn){return ;}var bx=this.getNodeFromRow(bv);if(bx.columnData[bu]!=bw){bx.columnData[bu]=bw;this.setData();if(this.hasListener(t)){var by={firstRow:bx.nodeId,lastRow:bx.nodeId,firstColumn:bu,lastColumn:bu};this.fireDataEvent(t,by);}}},getNode:function(bt){if(bt<0||bt>=this._rowArr.length){throw new Error("this._rowArr row "+"("+bt+") out of bounds: "+this._rowArr+" (0.."+(this._rowArr.length-1)+")");}return this._rowArr[bt][this._treeColumn];},addBranch:function(bd,be,bf,bg,bh,bi){return qx.ui.treevirtual.MTreePrimitive._addNode(this._nodeArr,bd,be,bf,bg,qx.ui.treevirtual.MTreePrimitive.Type.BRANCH,bh,bi);},addLeaf:function(K,L,M,N){return qx.ui.treevirtual.MTreePrimitive._addNode(this._nodeArr,K,L,false,false,qx.ui.treevirtual.MTreePrimitive.Type.LEAF,M,N);},prune:function(bp,bq){var br;var bs;if(typeof (bp)==s){br=bp;bs=br.nodeId;}else if(typeof (bp)==u){bs=bp;}else{throw new Error("Expected node object or node id");}for(var i=this._nodeArr[bs].children.length-1;i>=0;i--){this.prune(this._nodeArr[bs].children[i],true);}if(bq&&bs!=0){br=this._nodeArr[bs];qx.lang.Array.remove(this._nodeArr[br.parentNodeId].children,bs);if(this._selections[bs]){delete this._selections[bs];}this._nodeArr[bs]=null;}},move:function(c,d){var k;var e;var h;var f;d=d||0;if(typeof (c)==s){k=c;e=k.nodeId;}else if(typeof (c)==u){e=c;k=this._nodeArr[e];}else{throw new Error("Expected move node object or node id");}if(typeof (d)==s){h=d;f=h.nodeId;}else if(typeof (d)==u){f=d;h=this._nodeArr[f];}else{throw new Error("Expected parent node object or node id");}if(h.type==qx.ui.treevirtual.MTreePrimitive.Type.LEAF){throw new Error("Sorry, a LEAF may not have children.");}var g=this._nodeArr[k.parentNodeId];qx.lang.Array.remove(g.children,e);h.children.push(e);this._nodeArr[e].parentNodeId=f;},setData:function(O){var Q=this;function P(){var bm=function(A,B){var F=null;var E;var C=Q._nodeArr[A].children.length;for(var i=0;i<C;i++){E=Q._nodeArr[A].children[i];F=Q._nodeArr[E];if(F==null){continue;}F.level=B;F.bFirstChild=(i==0);F.lastChild=[i==C-1];var parent=Q._nodeArr[F.parentNodeId];while(parent.nodeId){var G=parent.lastChild[parent.lastChild.length-1];F.lastChild.unshift(G);parent=Q._nodeArr[parent.parentNodeId];}if(!F.columnData){F.columnData=[];}if(F.columnData.length<Q.getColumnCount()){F.columnData[Q.getColumnCount()-1]=null;}var D=[];if(F.columnData){for(var j=0;j<F.columnData.length;j++){if(j==Q._treeColumn){D.push(F);}else{D.push(F.columnData[j]);}}}else{D.push(F);}if(F.bSelected){D.selected=true;}Q._nodeRowMap[F.nodeId]=Q._rowArr.length;Q._rowArr.push(D);if(F.bOpened){bm(E,B+1);}}};Q._rowArr=[];Q._nodeRowMap=[];bm(0,1);if(Q.hasListener(t)){var bl={firstRow:0,lastRow:Q._rowArr.length-1,firstColumn:0,lastColumn:Q.getColumnCount()-1};Q.fireDataEvent(t,bl);}}if(O instanceof Array){for(var i=0;i<O.length;i++){if(O[i].selected){this._selections[i]=true;}}this._nodeArr=O;}else if(O!==null&&O!==undefined){throw new Error("Expected array of node objects or null/undefined; "+"got "+typeof (O));}P();},getData:function(){return this._nodeArr;},clearData:function(){this._clearSelections();this.setData([qx.ui.treevirtual.MTreePrimitive._getEmptyTree()]);},setColumnData:function(H,I,J){this._nodeArr[H].columnData[I]=J;},getColumnData:function(bC,bD){return this._nodeArr[bC].columnData[bD];},setState:function(R,S){var T;var Y;if(typeof (R)==s){T=R;Y=T.nodeId;}else if(typeof (R)==u){Y=R;T=this._nodeArr[Y];}else{throw new Error("Expected node object or node id");}for(var W in S){switch(W){case o:var ba=this.getRowFromNodeId(Y);var U=this.getTree().getSelectionModel();var V=qx.ui.treevirtual.TreeVirtual;var bb=(typeof (ba)===u&&this.getTree().getSelectionMode()!=V.SelectionMode.NONE);if(S[W]){this._selections[Y]=true;if(bb&&!U.isSelectedIndex(ba)){U.setSelectionInterval(ba,ba);}}else{delete this._selections[Y];if(bb&&U.isSelectedIndex(ba)){U.removeSelectionInterval(ba,ba);}}break;case m:if(S[W]==T.bOpened){break;}var X=this.__dD;if(T.bOpened){X.fireDataEvent(l,T);}else{if(T.children.length>0){X.fireDataEvent(p,T);}else{X.fireDataEvent(q,T);}}if(!T.bHideOpenClose){T.bOpened=!T.bOpened;X.getSelectionModel()._resetSelection();}this.setData();break;default:break;}T[W]=S[W];}},getNodeRowMap:function(){return this._nodeRowMap;},getRowFromNodeId:function(bF){return this._nodeRowMap[bF];},getNodeFromRow:function(a){return this._nodeArr[this._rowArr[a][this._treeColumn].nodeId];},_clearSelections:function(){for(var b in this._selections){this._nodeArr[b].bSelected=false;}this._selections={};},getSelectedNodes:function(){var bG=[];for(var bH in this._selections){bG.push(this._nodeArr[bH]);}return bG;}},destruct:function(){this._rowArr=this._nodeArr=this._nodeRowMap=this._selections=this.__dD=null;},defer:function(bc){bc.Type=qx.ui.treevirtual.MTreePrimitive.Type;}});})();(function(){var O="Integer",N="_applyDimension",M="Boolean",L="_applyStretching",K="_applyMargin",J="shorthand",I="_applyAlign",H="allowShrinkY",G="bottom",F="baseline",bd="marginBottom",bc="qx.ui.core.LayoutItem",bb="center",ba="marginTop",Y="allowGrowX",X="middle",W="marginLeft",V="allowShrinkX",U="top",T="right",R="marginRight",S="abstract",P="allowGrowY",Q="left";qx.Class.define(bc,{type:S,extend:qx.core.Object,properties:{minWidth:{check:O,nullable:true,apply:N,init:null,themeable:true},width:{check:O,nullable:true,apply:N,init:null,themeable:true},maxWidth:{check:O,nullable:true,apply:N,init:null,themeable:true},minHeight:{check:O,nullable:true,apply:N,init:null,themeable:true},height:{check:O,nullable:true,apply:N,init:null,themeable:true},maxHeight:{check:O,nullable:true,apply:N,init:null,themeable:true},allowGrowX:{check:M,apply:L,init:true,themeable:true},allowShrinkX:{check:M,apply:L,init:true,themeable:true},allowGrowY:{check:M,apply:L,init:true,themeable:true},allowShrinkY:{check:M,apply:L,init:true,themeable:true},allowStretchX:{group:[Y,V],mode:J,themeable:true},allowStretchY:{group:[P,H],mode:J,themeable:true},marginTop:{check:O,init:0,apply:K,themeable:true},marginRight:{check:O,init:0,apply:K,themeable:true},marginBottom:{check:O,init:0,apply:K,themeable:true},marginLeft:{check:O,init:0,apply:K,themeable:true},margin:{group:[ba,R,bd,W],mode:J,themeable:true},alignX:{check:[Q,bb,T],nullable:true,apply:I,themeable:true},alignY:{check:[U,X,G,F],nullable:true,apply:I,themeable:true}},members:{__dE:null,__dF:null,__dG:null,__dH:null,__dI:null,__dJ:null,__dK:null,getBounds:function(){return this.__dJ||this.__dF||null;},clearSeparators:function(){},renderSeparator:function(k,l){},renderLayout:function(n,top,o,p){var q;{};var r=null;if(this.getHeight()==null&&this._hasHeightForWidth()){var r=this._getHeightForWidth(o);}if(r!=null&&r!==this.__dE){this.__dE=r;qx.ui.core.queue.Layout.add(this);return null;}var t=this.__dF;if(!t){t=this.__dF={};}var s={};if(n!==t.left||top!==t.top){s.position=true;t.left=n;t.top=top;}if(o!==t.width||p!==t.height){s.size=true;t.width=o;t.height=p;}if(this.__dG){s.local=true;delete this.__dG;}if(this.__dI){s.margin=true;delete this.__dI;}return s;},isExcluded:function(){return false;},hasValidLayout:function(){return !this.__dG;},scheduleLayoutUpdate:function(){qx.ui.core.queue.Layout.add(this);},invalidateLayoutCache:function(){this.__dG=true;this.__dH=null;},getSizeHint:function(x){var y=this.__dH;if(y){return y;}if(x===false){return null;}y=this.__dH=this._computeSizeHint();if(this._hasHeightForWidth()&&this.__dE&&this.getHeight()==null){y.height=this.__dE;}if(y.minWidth>y.width){y.width=y.minWidth;}if(y.maxWidth<y.width){y.width=y.maxWidth;}if(!this.getAllowGrowX()){y.maxWidth=y.width;}if(!this.getAllowShrinkX()){y.minWidth=y.width;}if(y.minHeight>y.height){y.height=y.minHeight;}if(y.maxHeight<y.height){y.height=y.maxHeight;}if(!this.getAllowGrowY()){y.maxHeight=y.height;}if(!this.getAllowShrinkY()){y.minHeight=y.height;}return y;},_computeSizeHint:function(){var i=this.getMinWidth()||0;var f=this.getMinHeight()||0;var j=this.getWidth()||i;var h=this.getHeight()||f;var e=this.getMaxWidth()||Infinity;var g=this.getMaxHeight()||Infinity;return {minWidth:i,width:j,maxWidth:e,minHeight:f,height:h,maxHeight:g};},_hasHeightForWidth:function(){var m=this._getLayout();if(m){return m.hasHeightForWidth();}return false;},_getHeightForWidth:function(a){var b=this._getLayout();if(b&&b.hasHeightForWidth()){return b.getHeightForWidth(a);}return null;},_getLayout:function(){return null;},_applyMargin:function(){this.__dI=true;var parent=this.$$parent;if(parent){parent.updateLayoutProperties();}},_applyAlign:function(){var parent=this.$$parent;if(parent){parent.updateLayoutProperties();}},_applyDimension:function(){qx.ui.core.queue.Layout.add(this);},_applyStretching:function(){qx.ui.core.queue.Layout.add(this);},hasUserBounds:function(){return !!this.__dJ;},setUserBounds:function(C,top,D,E){this.__dJ={left:C,top:top,width:D,height:E};qx.ui.core.queue.Layout.add(this);},resetUserBounds:function(){delete this.__dJ;qx.ui.core.queue.Layout.add(this);},__dL:{},setLayoutProperties:function(u){if(u==null){return;}var v=this.__dK;if(!v){v=this.__dK={};}var parent=this.getLayoutParent();if(parent){parent.updateLayoutProperties(u);}for(var w in u){if(u[w]==null){delete v[w];}else{v[w]=u[w];}}},getLayoutProperties:function(){return this.__dK||this.__dL;},clearLayoutProperties:function(){delete this.__dK;},updateLayoutProperties:function(z){var A=this._getLayout();if(A){var B;{};A.invalidateChildrenCache();}qx.ui.core.queue.Layout.add(this);},getApplicationRoot:function(){return qx.core.Init.getApplication().getRoot();},getLayoutParent:function(){return this.$$parent||null;},setLayoutParent:function(parent){if(this.$$parent===parent){return;}this.$$parent=parent||null;qx.ui.core.queue.Visibility.add(this);},isRootWidget:function(){return false;},_getRoot:function(){var parent=this;while(parent){if(parent.isRootWidget()){return parent;}parent=parent.$$parent;}return null;},clone:function(){var c=qx.core.Object.prototype.clone.call(this);var d=this.__dK;if(d){c.__dK=qx.lang.Object.clone(d);}return c;}},destruct:function(){this.$$parent=this.$$subparent=this.__dK=this.__dF=this.__dJ=this.__dH=null;}});})();(function(){var a="qx.locale.MTranslation";qx.Mixin.define(a,{members:{tr:function(d,e){var f=qx.locale.Manager;if(f){return f.tr.apply(f,arguments);}throw new Error("To enable localization please include qx.locale.Manager into your build!");},trn:function(g,h,i,j){var k=qx.locale.Manager;if(k){return k.trn.apply(k,arguments);}throw new Error("To enable localization please include qx.locale.Manager into your build!");},trc:function(l,m,n){var o=qx.locale.Manager;if(o){return o.trc.apply(o,arguments);}throw new Error("To enable localization please include qx.locale.Manager into your build!");},marktr:function(b){var c=qx.locale.Manager;if(c){return c.marktr.apply(c,arguments);}throw new Error("To enable localization please include qx.locale.Manager into your build!");}}});})();(function(){var e="qx.ui.core.DecoratorFactory",d="$$nopool$$";qx.Class.define(e,{extend:qx.core.Object,construct:function(){qx.core.Object.call(this);this.__dM={};},statics:{MAX_SIZE:15,__dN:d},members:{__dM:null,getDecoratorElement:function(f){var k=qx.ui.core.DecoratorFactory;if(qx.lang.Type.isString(f)){var i=f;var h=qx.theme.manager.Decoration.getInstance().resolve(f);}else{var i=k.__dN;h=f;}var j=this.__dM;if(j[i]&&j[i].length>0){var g=j[i].pop();}else{var g=this._createDecoratorElement(h,i);}g.$$pooled=false;return g;},poolDecorator:function(l){if(!l||l.$$pooled||l.isDisposed()){return;}var o=qx.ui.core.DecoratorFactory;var m=l.getId();if(m==o.__dN){l.dispose();return;}var n=this.__dM;if(!n[m]){n[m]=[];}if(n[m].length>o.MAX_SIZE){l.dispose();}else{l.$$pooled=true;n[m].push(l);}},_createDecoratorElement:function(a,b){var c=new qx.html.Decorator(a,b);{};return c;},toString:function(){return qx.core.Object.prototype.toString.call(this);}},destruct:function(){if(!qx.core.ObjectRegistry.inShutDown){var q=this.__dM;for(var p in q){qx.util.DisposeUtil.disposeArray(q,p);}}this.__dM=null;}});})();(function(){var dB="px",dA="Boolean",dz="qx.event.type.Drag",dy="qx.event.type.Mouse",dx="visible",dw="qx.event.type.Focus",dv="on",du="Integer",dt="excluded",ds="qx.event.type.Data",dd="_applyPadding",dc="qx.event.type.Event",db="hidden",da="contextmenu",cY="String",cX="tabIndex",cW="focused",cV="changeVisibility",cU="mshtml",cT="hovered",dI="qx.event.type.KeySequence",dJ="qx.client",dG="absolute",dH="backgroundColor",dE="drag",dF="div",dC="disabled",dD="move",dK="dragstart",dL="qx.dynlocale",dk="dragchange",dj="dragend",dm="resize",dl="Decorator",dp="zIndex",dn="opacity",dr="default",dq="Color",di="changeToolTipText",dh="beforeContextmenuOpen",bK="_applyNativeContextMenu",bL="__dP",bM="_applyBackgroundColor",bN="_applyFocusable",bO="changeShadow",bP="qx.event.type.KeyInput",bQ="__dX",bR="createChildControl",bS="Font",bT="_applyShadow",dP="__dT",dO="_applyEnabled",dN="_applySelectable",dM="Number",dT="_applyKeepActive",dS="__ea",dR="_applyVisibility",dQ="repeat",dV="qxDraggable",dU="syncAppearance",ct="paddingLeft",cu="_applyDroppable",cr="__ec",cs="#",cx="qx.event.type.MouseWheel",cy="_applyCursor",cv="_applyDraggable",cw="changeTextColor",cp="$$widget",cq="changeContextMenu",cc="__dS",cb="paddingTop",ce="changeSelectable",cd="hideFocus",bX="none",bW="outline",ca="_applyAppearance",bY="_applyOpacity",bV="url(",bU=")",cD="qx.ui.core.Widget",cE="_applyFont",cF="cursor",cG="qxDroppable",cz="changeZIndex",cA="changeEnabled",cB="changeFont",cC="__dU",cH="_applyDecorator",cI="_applyZIndex",cm="_applyTextColor",cl="qx.ui.menu.Menu",ck="_applyToolTipText",cj="true",ci="widget",ch="__dO",cg="changeDecorator",cf="_applyTabIndex",co="changeAppearance",cn="shorthand",cJ="/",cK="",cL="_applyContextMenu",cM="paddingBottom",cN="changeNativeContextMenu",cO="qx.ui.tooltip.ToolTip",cP="qxKeepActive",cQ="_applyKeepFocus",cR="paddingRight",cS="changeBackgroundColor",dg="changeLocale",df="qxKeepFocus",de="qx/static/blank.gif";qx.Class.define(cD,{extend:qx.ui.core.LayoutItem,include:[qx.locale.MTranslation],construct:function(){qx.ui.core.LayoutItem.call(this);this.__dO=this._createContainerElement();this.__dP=this.__eb();this.__dO.add(this.__dP);this.initFocusable();this.initSelectable();this.initNativeContextMenu();},events:{appear:dc,disappear:dc,createChildControl:ds,resize:ds,move:ds,syncAppearance:ds,mousemove:dy,mouseover:dy,mouseout:dy,mousedown:dy,mouseup:dy,click:dy,dblclick:dy,contextmenu:dy,beforeContextmenuOpen:ds,mousewheel:cx,keyup:dI,keydown:dI,keypress:dI,keyinput:bP,focus:dw,blur:dw,focusin:dw,focusout:dw,activate:dw,deactivate:dw,capture:dc,losecapture:dc,drop:dz,dragleave:dz,dragover:dz,drag:dz,dragstart:dz,dragend:dz,dragchange:dz,droprequest:dz},properties:{paddingTop:{check:du,init:0,apply:dd,themeable:true},paddingRight:{check:du,init:0,apply:dd,themeable:true},paddingBottom:{check:du,init:0,apply:dd,themeable:true},paddingLeft:{check:du,init:0,apply:dd,themeable:true},padding:{group:[cb,cR,cM,ct],mode:cn,themeable:true},zIndex:{nullable:true,init:null,apply:cI,event:cz,check:du,themeable:true},decorator:{nullable:true,init:null,apply:cH,event:cg,check:dl,themeable:true},shadow:{nullable:true,init:null,apply:bT,event:bO,check:dl,themeable:true},backgroundColor:{nullable:true,check:dq,apply:bM,event:cS,themeable:true},textColor:{nullable:true,check:dq,apply:cm,event:cw,themeable:true,inheritable:true},font:{nullable:true,apply:cE,check:bS,event:cB,themeable:true,inheritable:true,dereference:true},opacity:{check:dM,apply:bY,themeable:true,nullable:true,init:null},cursor:{check:cY,apply:cy,themeable:true,inheritable:true,nullable:true,init:null},toolTip:{check:cO,nullable:true},toolTipText:{check:cY,nullable:true,event:di,apply:ck},toolTipIcon:{check:cY,nullable:true,event:di},blockToolTip:{check:dA,init:false},visibility:{check:[dx,db,dt],init:dx,apply:dR,event:cV},enabled:{init:true,check:dA,inheritable:true,apply:dO,event:cA},anonymous:{init:false,check:dA},tabIndex:{check:du,nullable:true,apply:cf},focusable:{check:dA,init:false,apply:bN},keepFocus:{check:dA,init:false,apply:cQ},keepActive:{check:dA,init:false,apply:dT},draggable:{check:dA,init:false,apply:cv},droppable:{check:dA,init:false,apply:cu},selectable:{check:dA,init:false,event:ce,apply:dN},contextMenu:{check:cl,apply:cL,nullable:true,event:cq},nativeContextMenu:{check:dA,init:false,themeable:true,event:cN,apply:bK},appearance:{check:cY,init:ci,apply:ca,event:co}},statics:{DEBUG:false,getWidgetByElement:function(fN,fO){while(fN){var fP=fN.$$widget;if(fP!=null){var fQ=qx.core.ObjectRegistry.fromHashCode(fP);if(!fO||!fQ.getAnonymous()){return fQ;}}try{fN=fN.parentNode;}catch(e){return null;}}return null;},contains:function(parent,fo){while(fo){if(parent==fo){return true;}fo=fo.getLayoutParent();}return false;},__dQ:new qx.ui.core.DecoratorFactory(),__dR:new qx.ui.core.DecoratorFactory()},members:{__dO:null,__dP:null,__dS:null,__dT:null,__dU:null,__dV:null,__dW:null,__dX:null,_getLayout:function(){return this.__dX;},_setLayout:function(gn){{};if(this.__dX){this.__dX.connectToWidget(null);}if(gn){gn.connectToWidget(this);}this.__dX=gn;qx.ui.core.queue.Layout.add(this);},setLayoutParent:function(parent){if(this.$$parent===parent){return;}var fj=this.getContainerElement();if(this.$$parent&&!this.$$parent.$$disposed){this.$$parent.getContentElement().remove(fj);}this.$$parent=parent||null;if(parent&&!parent.$$disposed){this.$$parent.getContentElement().add(fj);}this.$$refreshInheritables();qx.ui.core.queue.Visibility.add(this);},_updateInsets:null,__dY:function(a,b){if(a==b){return false;}if(a==null||b==null){return true;}var fK=qx.theme.manager.Decoration.getInstance();var fM=fK.resolve(a).getInsets();var fL=fK.resolve(b).getInsets();if(fM.top!=fL.top||fM.right!=fL.right||fM.bottom!=fL.bottom||fM.left!=fL.left){return true;}return false;},renderLayout:function(V,top,W,X){var bh=qx.ui.core.LayoutItem.prototype.renderLayout.call(this,V,top,W,X);if(!bh){return null;}var ba=this.getContainerElement();var content=this.getContentElement();var be=bh.size||this._updateInsets;var bi=dB;var bf={};if(bh.position){bf.left=V+bi;bf.top=top+bi;}if(bh.size){bf.width=W+bi;bf.height=X+bi;}if(bh.position||bh.size){ba.setStyles(bf);}if(be||bh.local||bh.margin){var Y=this.getInsets();var innerWidth=W-Y.left-Y.right;var innerHeight=X-Y.top-Y.bottom;innerWidth=innerWidth<0?0:innerWidth;innerHeight=innerHeight<0?0:innerHeight;}var bc={};if(this._updateInsets){bc.left=Y.left+bi;bc.top=Y.top+bi;}if(be){bc.width=innerWidth+bi;bc.height=innerHeight+bi;}if(be||this._updateInsets){content.setStyles(bc);}if(bh.size){var bg=this.__dU;if(bg){bg.setStyles({width:W+dB,height:X+dB});}}if(bh.size||this._updateInsets){if(this.__dS){this.__dS.resize(W,X);}}if(bh.size){if(this.__dT){var Y=this.__dT.getInsets();var bd=W+Y.left+Y.right;var bb=X+Y.top+Y.bottom;this.__dT.resize(bd,bb);}}if(be||bh.local||bh.margin){if(this.__dX&&this.hasLayoutChildren()){this.__dX.renderLayout(innerWidth,innerHeight);}else if(this.hasLayoutChildren()){throw new Error("At least one child in control "+this._findTopControl()+" requires a layout, but no one was defined!");}}if(bh.position&&this.hasListener(dD)){this.fireDataEvent(dD,this.getBounds());}if(bh.size&&this.hasListener(dm)){this.fireDataEvent(dm,this.getBounds());}delete this._updateInsets;return bh;},__ea:null,clearSeparators:function(){var ha=this.__ea;if(!ha){return;}var hb=qx.ui.core.Widget.__dQ;var content=this.getContentElement();var gY;for(var i=0,l=ha.length;i<l;i++){gY=ha[i];hb.poolDecorator(gY);content.remove(gY);}ha.length=0;},renderSeparator:function(gt,gu){var gv=qx.ui.core.Widget.__dQ.getDecoratorElement(gt);this.getContentElement().add(gv);gv.resize(gu.width,gu.height);gv.setStyles({left:gu.left+dB,top:gu.top+dB});if(!this.__ea){this.__ea=[gv];}else{this.__ea.push(gv);}},_computeSizeHint:function(){var eJ=this.getWidth();var eI=this.getMinWidth();var eE=this.getMaxWidth();var eH=this.getHeight();var eF=this.getMinHeight();var eG=this.getMaxHeight();{};var eK=this._getContentHint();var eD=this.getInsets();var eM=eD.left+eD.right;var eL=eD.top+eD.bottom;if(eJ==null){eJ=eK.width+eM;}if(eH==null){eH=eK.height+eL;}if(eI==null){eI=eM;if(eK.minWidth!=null){eI+=eK.minWidth;}}if(eF==null){eF=eL;if(eK.minHeight!=null){eF+=eK.minHeight;}}if(eE==null){if(eK.maxWidth==null){eE=Infinity;}else{eE=eK.maxWidth+eM;}}if(eG==null){if(eK.maxHeight==null){eG=Infinity;}else{eG=eK.maxHeight+eL;}}return {width:eJ,minWidth:eI,maxWidth:eE,height:eH,minHeight:eF,maxHeight:eG};},invalidateLayoutCache:function(){qx.ui.core.LayoutItem.prototype.invalidateLayoutCache.call(this);if(this.__dX){this.__dX.invalidateLayoutCache();}},_getContentHint:function(){var bl=this.__dX;if(bl){if(this.hasLayoutChildren()){var bk;var bm=bl.getSizeHint();{};return bm;}else{return {width:0,height:0};}}else{return {width:100,height:50};}},_getHeightForWidth:function(ee){var ei=this.getInsets();var em=ei.left+ei.right;var ek=ei.top+ei.bottom;var ej=ee-em;var eg=this._getLayout();if(eg&&eg.hasHeightForWidth()){var ef=eg.getHeightForWidth(ee);}else{ef=this._getContentHeightForWidth(ej);}var eh=ef+ek;return eh;},_getContentHeightForWidth:function(gz){throw new Error("Abstract method call: _getContentHeightForWidth()!");},getInsets:function(){var top=this.getPaddingTop();var eQ=this.getPaddingRight();var eS=this.getPaddingBottom();var eR=this.getPaddingLeft();if(this.__dS){var eP=this.__dS.getInsets();{};top+=eP.top;eQ+=eP.right;eS+=eP.bottom;eR+=eP.left;}return {"top":top,"right":eQ,"bottom":eS,"left":eR};},getInnerSize:function(){var fS=this.getBounds();if(!fS){return null;}var fR=this.getInsets();return {width:fS.width-fR.left-fR.right,height:fS.height-fR.top-fR.bottom};},show:function(){this.setVisibility(dx);},hide:function(){this.setVisibility(db);},exclude:function(){this.setVisibility(dt);},isVisible:function(){return this.getVisibility()===dx;},isHidden:function(){return this.getVisibility()!==dx;},isExcluded:function(){return this.getVisibility()===dt;},isSeeable:function(){var fd=this.getContainerElement().getDomElement();if(fd){return fd.offsetWidth>0;}var fc=this;do{if(!fc.isVisible()){return false;}if(fc.isRootWidget()){return true;}fc=fc.getLayoutParent();}while(fc);return false;},_createContainerElement:function(){var E={"$$widget":this.toHashCode()};{};var D={zIndex:0,position:dG};return new qx.html.Element(dF,D,E);},__eb:function(){var bj=this._createContentElement();{};bj.setStyles({"position":dG,"zIndex":10});return bj;},_createContentElement:function(){return new qx.html.Element(dF,{overflowX:db,overflowY:db});},getContainerElement:function(){return this.__dO;},getContentElement:function(){return this.__dP;},getDecoratorElement:function(){return this.__dS||null;},getShadowElement:function(){return this.__dT||null;},__ec:null,getLayoutChildren:function(){var ea=this.__ec;if(!ea){return this.__ed;}var eb;for(var i=0,l=ea.length;i<l;i++){var dY=ea[i];if(dY.hasUserBounds()||dY.isExcluded()){if(eb==null){eb=ea.concat();}qx.lang.Array.remove(eb,dY);}}return eb||ea;},scheduleLayoutUpdate:function(){qx.ui.core.queue.Layout.add(this);},invalidateLayoutChildren:function(){var gP=this.__dX;if(gP){gP.invalidateChildrenCache();}qx.ui.core.queue.Layout.add(this);},hasLayoutChildren:function(){var bI=this.__ec;if(!bI){return false;}var bJ;for(var i=0,l=bI.length;i<l;i++){bJ=bI[i];if(!bJ.hasUserBounds()&&!bJ.isExcluded()){return true;}}return false;},getChildrenContainer:function(){return this;},__ed:[],_getChildren:function(){return this.__ec||this.__ed;},_indexOf:function(n){var o=this.__ec;if(!o){return -1;}return o.indexOf(n);},_hasChildren:function(){var gX=this.__ec;return gX!=null&&(!!gX[0]);},addChildrenToQueue:function(gw){var gx=this.__ec;if(!gx){return;}var gy;for(var i=0,l=gx.length;i<l;i++){gy=gx[i];gw[gy.$$hash]=gy;gy.addChildrenToQueue(gw);}},_add:function(ge,gf){if(ge.getLayoutParent()==this){qx.lang.Array.remove(this.__ec,ge);}if(this.__ec){this.__ec.push(ge);}else{this.__ec=[ge];}this.__ee(ge,gf);},_addAt:function(bC,bD,bE){if(!this.__ec){this.__ec=[];}if(bC.getLayoutParent()==this){qx.lang.Array.remove(this.__ec,bC);}var bF=this.__ec[bD];if(bF===bC){bC.setLayoutProperties(bE);}if(bF){qx.lang.Array.insertBefore(this.__ec,bC,bF);}else{this.__ec.push(bC);}this.__ee(bC,bE);},_addBefore:function(fU,fV,fW){{};if(fU==fV){return;}if(!this.__ec){this.__ec=[];}if(fU.getLayoutParent()==this){qx.lang.Array.remove(this.__ec,fU);}qx.lang.Array.insertBefore(this.__ec,fU,fV);this.__ee(fU,fW);},_addAfter:function(A,B,C){{};if(A==B){return;}if(!this.__ec){this.__ec=[];}if(A.getLayoutParent()==this){qx.lang.Array.remove(this.__ec,A);}qx.lang.Array.insertAfter(this.__ec,A,B);this.__ee(A,C);},_remove:function(eW){if(!this.__ec){throw new Error("This widget has no children!");}qx.lang.Array.remove(this.__ec,eW);this.__ef(eW);},_removeAt:function(fF){if(!this.__ec){throw new Error("This widget has no children!");}var fG=this.__ec[fF];qx.lang.Array.removeAt(this.__ec,fF);this.__ef(fG);return fG;},_removeAll:function(){if(!this.__ec){return;}var p=this.__ec.concat();this.__ec.length=0;for(var i=p.length-1;i>=0;i--){this.__ef(p[i]);}qx.ui.core.queue.Layout.add(this);},_afterAddChild:null,_afterRemoveChild:null,__ee:function(u,v){{};var parent=u.getLayoutParent();if(parent&&parent!=this){parent._remove(u);}u.setLayoutParent(this);if(v){u.setLayoutProperties(v);}else{this.updateLayoutProperties();}if(this._afterAddChild){this._afterAddChild(u);}},__ef:function(gU){{};if(gU.getLayoutParent()!==this){throw new Error("Remove Error: "+gU+" is not a child of this widget!");}gU.setLayoutParent(null);if(this.__dX){this.__dX.invalidateChildrenCache();}qx.ui.core.queue.Layout.add(this);if(this._afterRemoveChild){this._afterRemoveChild(gU);}},capture:function(gT){this.getContainerElement().capture(gT);},releaseCapture:function(){this.getContainerElement().releaseCapture();},_applyPadding:function(eN,eO,name){this._updateInsets=true;qx.ui.core.queue.Layout.add(this);},_createProtectorElement:function(){if(this.__dU){return;}var T=this.__dU=new qx.html.Element;{};T.setStyles({position:dG,top:0,left:0,zIndex:7});var U=this.getBounds();if(U){this.__dU.setStyles({width:U.width+dB,height:U.height+dB});}if(qx.core.Variant.isSet(dJ,cU)){T.setStyles({backgroundImage:bV+qx.util.ResourceManager.getInstance().toUri(de)+bU,backgroundRepeat:dQ});}this.getContainerElement().add(T);},_applyDecorator:function(fX,fY){{};var gc=qx.ui.core.Widget.__dQ;var ga=this.getContainerElement();if(!this.__dU&&!qx.bom.client.Feature.CSS_POINTER_EVENTS){this._createProtectorElement();}if(fY){ga.remove(this.__dS);gc.poolDecorator(this.__dS);}if(fX){var gb=this.__dS=gc.getDecoratorElement(fX);gb.setStyle(dp,5);ga.add(gb);}else{delete this.__dS;}this._applyBackgroundColor(this.getBackgroundColor());if(this.__dY(fY,fX)){this._updateInsets=true;qx.ui.core.queue.Layout.add(this);}else if(fX){var gd=this.getBounds();if(gd){gb.resize(gd.width,gd.height);this.__dU&&this.__dU.setStyles({width:gd.width+dB,height:gd.height+dB});}}},_applyShadow:function(fp,fq){var fx=qx.ui.core.Widget.__dR;var fs=this.getContainerElement();if(fq){fs.remove(this.__dT);fx.poolDecorator(this.__dT);}if(fp){var fu=this.__dT=fx.getDecoratorElement(fp);fs.add(fu);var fw=fu.getInsets();fu.setStyles({left:(-fw.left)+dB,top:(-fw.top)+dB});var fv=this.getBounds();if(fv){var ft=fv.width+fw.left+fw.right;var fr=fv.height+fw.top+fw.bottom;fu.resize(ft,fr);}fu.tint(null);}else{delete this.__dT;}},_applyToolTipText:function(eY,fa){if(qx.core.Variant.isSet(dL,dv)){if(this.__dW){return;}var fb=qx.locale.Manager.getInstance();this.__dW=fb.addListener(dg,function(){var fe=this.getToolTipText();if(fe&&fe.translate){this.setToolTipText(fe.translate());}},this);}},_applyTextColor:function(fy,fz){},_applyZIndex:function(H,I){this.getContainerElement().setStyle(dp,H==null?0:H);},_applyVisibility:function(eT,eU){var eV=this.getContainerElement();if(eT===dx){eV.show();}else{eV.hide();}var parent=this.$$parent;if(parent&&(eU==null||eT==null||eU===dt||eT===dt)){parent.invalidateLayoutChildren();}qx.ui.core.queue.Visibility.add(this);},_applyOpacity:function(fH,fI){this.getContainerElement().setStyle(dn,fH==1?null:fH);if(qx.core.Variant.isSet(dJ,cU)&&qx.bom.element.Decoration.isAlphaImageLoaderEnabled()){if(!qx.Class.isSubClassOf(this.getContentElement().constructor,qx.html.Image)){var fJ=(fH==1||fH==null)?null:0.99;this.getContentElement().setStyle(dn,fJ);}}},_applyCursor:function(s,t){if(s==null&&!this.isSelectable()){s=dr;}this.getContainerElement().setStyle(cF,s,qx.bom.client.Engine.OPERA);},_applyBackgroundColor:function(go,gp){var gq=this.getBackgroundColor();var gs=this.getContainerElement();if(this.__dS){this.__dS.tint(gq);gs.setStyle(dH,null);}else{var gr=qx.theme.manager.Color.getInstance().resolve(gq);gs.setStyle(dH,gr);}},_applyFont:function(ec,ed){},__eg:null,$$stateChanges:null,_forwardStates:null,hasState:function(et){var eu=this.__eg;return !!eu&&!!eu[et];},addState:function(gi){var gj=this.__eg;if(!gj){gj=this.__eg={};}if(gj[gi]){return;}this.__eg[gi]=true;if(gi===cT){this.syncAppearance();}else if(!qx.ui.core.queue.Visibility.isVisible(this)){this.$$stateChanges=true;}else{qx.ui.core.queue.Appearance.add(this);}var forward=this._forwardStates;var gm=this.__ej;if(forward&&forward[gi]&&gm){var gk;for(var gl in gm){gk=gm[gl];if(gk instanceof qx.ui.core.Widget){gm[gl].addState(gi);}}}},removeState:function(bn){var bo=this.__eg;if(!bo||!bo[bn]){return;}delete this.__eg[bn];if(bn===cT){this.syncAppearance();}else if(!qx.ui.core.queue.Visibility.isVisible(this)){this.$$stateChanges=true;}else{qx.ui.core.queue.Appearance.add(this);}var forward=this._forwardStates;var br=this.__ej;if(forward&&forward[bn]&&br){for(var bq in br){var bp=br[bq];if(bp instanceof qx.ui.core.Widget){bp.removeState(bn);}}}},replaceState:function(ev,ew){var ex=this.__eg;if(!ex){ex=this.__eg={};}if(!ex[ew]){ex[ew]=true;}if(ex[ev]){delete ex[ev];}if(!qx.ui.core.queue.Visibility.isVisible(this)){this.$$stateChanges=true;}else{qx.ui.core.queue.Appearance.add(this);}var forward=this._forwardStates;var eA=this.__ej;if(forward&&forward[ew]&&eA){for(var ez in eA){var ey=eA[ez];if(ey instanceof qx.ui.core.Widget){ey.replaceState(ev,ew);}}}},__eh:null,__ei:null,syncAppearance:function(){var bw=this.__eg;var bv=this.__eh;var bx=qx.theme.manager.Appearance.getInstance();var bt=qx.core.Property.$$method.setThemed;var bB=qx.core.Property.$$method.resetThemed;if(this.__ei){delete this.__ei;if(bv){var bs=bx.styleFrom(bv,bw,null,this.getAppearance());if(bs){bv=null;}}}if(!bv){var bu=this;var bA=[];do{bA.push(bu.$$subcontrol||bu.getAppearance());}while(bu=bu.$$subparent);bv=this.__eh=bA.reverse().join(cJ).replace(/#[0-9]+/g,cK);}var by=bx.styleFrom(bv,bw,null,this.getAppearance());if(by){var bz;if(bs){for(var bz in bs){if(by[bz]===undefined){this[bB[bz]]();}}}{};for(var bz in by){by[bz]===undefined?this[bB[bz]]():this[bt[bz]](by[bz]);}}else if(bs){for(var bz in bs){this[bB[bz]]();}}this.fireDataEvent(dU,this.__eg);},_applyAppearance:function(q,r){this.updateAppearance();},checkAppearanceNeeds:function(){if(!this.__dV){qx.ui.core.queue.Appearance.add(this);this.__dV=true;}else if(this.$$stateChanges){qx.ui.core.queue.Appearance.add(this);delete this.$$stateChanges;}},updateAppearance:function(){this.__ei=true;qx.ui.core.queue.Appearance.add(this);var ep=this.__ej;if(ep){var en;for(var eo in ep){en=ep[eo];if(en instanceof qx.ui.core.Widget){en.updateAppearance();}}}},syncWidget:function(){},getEventTarget:function(){var g=this;while(g.getAnonymous()){g=g.getLayoutParent();if(!g){return null;}}return g;},getFocusTarget:function(){var fA=this;if(!fA.getEnabled()){return null;}while(fA.getAnonymous()||!fA.getFocusable()){fA=fA.getLayoutParent();if(!fA||!fA.getEnabled()){return null;}}return fA;},getFocusElement:function(){return this.getContainerElement();},isTabable:function(){return (!!this.getContainerElement().getDomElement())&&this.isFocusable();},_applyFocusable:function(w,x){var y=this.getFocusElement();if(w){var z=this.getTabIndex();if(z==null){z=1;}y.setAttribute(cX,z);if(qx.core.Variant.isSet(dJ,cU)){y.setAttribute(cd,cj);}else{y.setStyle(bW,bX);}}else{if(y.isNativelyFocusable()){y.setAttribute(cX,-1);}else if(x){y.setAttribute(cX,null);}}},_applyKeepFocus:function(gV){var gW=this.getFocusElement();gW.setAttribute(df,gV?dv:null);},_applyKeepActive:function(gL){var gM=this.getContainerElement();gM.setAttribute(cP,gL?dv:null);},_applyTabIndex:function(fT){if(fT==null){fT=1;}else if(fT<1||fT>32000){throw new Error("TabIndex property must be between 1 and 32000");}if(this.getFocusable()&&fT!=null){this.getFocusElement().setAttribute(cX,fT);}},_applySelectable:function(gQ,gR){if(gR!==null){this._applyCursor(this.getCursor());}this.getContainerElement().setSelectable(gQ);this.getContentElement().setSelectable(gQ);},_applyEnabled:function(gN,gO){if(gN===false){this.addState(dC);this.removeState(cT);if(this.isFocusable()){this.removeState(cW);this._applyFocusable(false,true);}if(this.isDraggable()){this._applyDraggable(false,true);}if(this.isDroppable()){this._applyDroppable(false,true);}}else{this.removeState(dC);if(this.isFocusable()){this._applyFocusable(true,false);}if(this.isDraggable()){this._applyDraggable(true,false);}if(this.isDroppable()){this._applyDroppable(true,false);}}},_applyNativeContextMenu:function(fm,fn,name){},_applyContextMenu:function(bG,bH){if(bH){bH.removeState(da);if(bH.getOpener()==this){bH.resetOpener();}if(!bG){this.removeListener(da,this._onContextMenuOpen);bH.removeListener(cV,this._onBeforeContextMenuOpen,this);}}if(bG){bG.setOpener(this);bG.addState(da);if(!bH){this.addListener(da,this._onContextMenuOpen);bG.addListener(cV,this._onBeforeContextMenuOpen,this);}}},_onContextMenuOpen:function(e){this.getContextMenu().openAtMouse(e);e.stop();},_onBeforeContextMenuOpen:function(e){if(e.getData()==dx&&this.hasListener(dh)){this.fireDataEvent(dh,e);}},_onStopEvent:function(e){e.stopPropagation();},_applyDraggable:function(k,m){if(!this.isEnabled()&&k===true){k=false;}qx.ui.core.DragDropCursor.getInstance();if(k){this.addListener(dK,this._onDragStart);this.addListener(dE,this._onDrag);this.addListener(dj,this._onDragEnd);this.addListener(dk,this._onDragChange);}else{this.removeListener(dK,this._onDragStart);this.removeListener(dE,this._onDrag);this.removeListener(dj,this._onDragEnd);this.removeListener(dk,this._onDragChange);}this.getContainerElement().setAttribute(dV,k?dv:null);},_applyDroppable:function(gg,gh){if(!this.isEnabled()&&gg===true){gg=false;}this.getContainerElement().setAttribute(cG,gg?dv:null);},_onDragStart:function(e){qx.ui.core.DragDropCursor.getInstance().placeToMouse(e);this.getApplicationRoot().setGlobalCursor(dr);},_onDrag:function(e){qx.ui.core.DragDropCursor.getInstance().placeToMouse(e);},_onDragEnd:function(e){qx.ui.core.DragDropCursor.getInstance().moveTo(-1000,-1000);this.getApplicationRoot().resetGlobalCursor();},_onDragChange:function(e){var fk=qx.ui.core.DragDropCursor.getInstance();var fl=e.getCurrentAction();fl?fk.setAction(fl):fk.resetAction();},visualizeFocus:function(){this.addState(cW);},visualizeBlur:function(){this.removeState(cW);},scrollChildIntoView:function(gH,gI,gJ,gK){this.scrollChildIntoViewX(gH,gI,gK);this.scrollChildIntoViewY(gH,gJ,gK);},scrollChildIntoViewX:function(Q,R,S){this.getContentElement().scrollChildIntoViewX(Q.getContainerElement(),R,S);},scrollChildIntoViewY:function(c,d,f){this.getContentElement().scrollChildIntoViewY(c.getContainerElement(),d,f);},focus:function(){if(this.isFocusable()){this.getFocusElement().focus();}else{throw new Error("Widget is not focusable!");}},blur:function(){if(this.isFocusable()){this.getFocusElement().blur();}else{throw new Error("Widget is not focusable!");}},activate:function(){this.getContainerElement().activate();},deactivate:function(){this.getContainerElement().deactivate();},tabFocus:function(){this.getFocusElement().focus();},hasChildControl:function(es){if(!this.__ej){return false;}return !!this.__ej[es];},__ej:null,_getCreatedChildControls:function(){return this.__ej;},getChildControl:function(gE,gF){if(!this.__ej){if(gF){return null;}this.__ej={};}var gG=this.__ej[gE];if(gG){return gG;}if(gF===true){return null;}return this._createChildControl(gE);},_showChildControl:function(eq){var er=this.getChildControl(eq);er.show();return er;},_excludeChildControl:function(fh){var fi=this.getChildControl(fh,true);if(fi){fi.exclude();}},_isChildControlVisible:function(F){var G=this.getChildControl(F,true);if(G){return G.isVisible();}return false;},_createChildControl:function(J){if(!this.__ej){this.__ej={};}else if(this.__ej[J]){throw new Error("Child control '"+J+"' already created!");}var N=J.indexOf(cs);if(N==-1){var K=this._createChildControlImpl(J);}else{var K=this._createChildControlImpl(J.substring(0,N));}if(!K){throw new Error("Unsupported control: "+J);}K.$$subcontrol=J;K.$$subparent=this;var L=this.__eg;var forward=this._forwardStates;if(L&&forward&&K instanceof qx.ui.core.Widget){for(var M in L){if(forward[M]){K.addState(M);}}}this.fireDataEvent(bR,K);return this.__ej[J]=K;},_createChildControlImpl:function(eX){return null;},_disposeChildControls:function(){var fE=this.__ej;if(!fE){return;}var fC=qx.ui.core.Widget;for(var fD in fE){var fB=fE[fD];if(!fC.contains(this,fB)){fB.destroy();}else{fB.dispose();}}delete this.__ej;},_findTopControl:function(){var gS=this;while(gS){if(!gS.$$subparent){return gS;}gS=gS.$$subparent;}return null;},getContainerLocation:function(ff){var fg=this.getContainerElement().getDomElement();return fg?qx.bom.element.Location.get(fg,ff):null;},getContentLocation:function(h){var j=this.getContentElement().getDomElement();return j?qx.bom.element.Location.get(j,h):null;},setDomLeft:function(eB){var eC=this.getContainerElement().getDomElement();if(eC){eC.style.left=eB+dB;}else{throw new Error("DOM element is not yet created!");}},setDomTop:function(gC){var gD=this.getContainerElement().getDomElement();if(gD){gD.style.top=gC+dB;}else{throw new Error("DOM element is not yet created!");}},setDomPosition:function(dW,top){var dX=this.getContainerElement().getDomElement();if(dX){dX.style.left=dW+dB;dX.style.top=top+dB;}else{throw new Error("DOM element is not yet created!");}},destroy:function(){if(this.$$disposed){return;}var parent=this.$$parent;if(parent){parent._remove(this);}qx.ui.core.queue.Dispose.add(this);},clone:function(){var O=qx.ui.core.LayoutItem.prototype.clone.call(this);if(this.getChildren){var P=this.getChildren();for(var i=0,l=P.length;i<l;i++){O.add(P[i].clone());}}return O;}},destruct:function(){if(!qx.core.ObjectRegistry.inShutDown){if(qx.core.Variant.isSet(dL,dv)){if(this.__dW){qx.locale.Manager.getInstance().removeListenerById(this.__dW);}}this.getContainerElement().setAttribute(cp,null,true);this._disposeChildControls();qx.ui.core.queue.Appearance.remove(this);qx.ui.core.queue.Layout.remove(this);qx.ui.core.queue.Visibility.remove(this);qx.ui.core.queue.Widget.remove(this);}if(!qx.core.ObjectRegistry.inShutDown){var gB=qx.ui.core.Widget;var gA=this.getContainerElement();if(this.__dS){gA.remove(this.__dS);gB.__dQ.poolDecorator(this.__dS);}if(this.__dT){gA.remove(this.__dT);gB.__dR.poolDecorator(this.__dT);}this.clearSeparators();this.__dS=this.__dT=this.__ea=null;}else{this._disposeArray(dS);this._disposeObjects(cc,dP);}this._disposeArray(cr);this.__eg=this.__ej=null;this._disposeObjects(bQ,ch,bL,cC);}});})();(function(){var bW="Boolean",bV="column-button",bU="Function",bT="qx.event.type.Data",bS="statusbar",bR="qx.ui.table.pane.CellEvent",bQ="function",bP="PageUp",bO="dataChanged",bN='"',dn="changeLocale",dm="changeSelection",dl="__eu",dk="qx.dynlocale",dj="Enter",di="metaDataChanged",dh="on",dg="_applyStatusBarVisible",df="columnVisibilityMenuCreateStart",de="blur",ce="qx.ui.table.Table",cf="columnVisibilityMenuCreateEnd",cc="changeVisible",cd="_applyResetSelectionOnHeaderClick",ca="_applyMetaColumnCounts",cb="focus",bX="changeDataRowRenderer",bY="changeHeaderCellHeight",cm="Escape",cn="A",cF="changeSelectionModel",cB="Left",cN="Down",cI="Integer",da="_applyHeaderCellHeight",cT="visibilityChanged",cu="qx.ui.table.ITableModel",dd="orderChanged",dc="_applySelectionModel",db="menu-button",cs="menu",cx="_applyAdditionalStatusBarText",cz="_applyFocusCellOnMouseMove",cD="table",cG="_applyColumnVisibilityButtonVisible",cJ="__el",cP="changeTableModel",cV="qx.event.type.Event",cg="tableWidthChanged",ch="_applyHeaderCellsVisible",cw="Object",cM="_applyShowCellFocusIndicator",cL="resize",cK="verticalScrollBarChanged",cR="changeScrollY",cQ="_applyTableModel",cH="__ek",cO="End",bK="_applyKeepFirstVisibleRowComplete",cU="widthChanged",ci="one of one row",cj="Home",cC="_applyRowHeight",bL="F2",bM="appear",cr="Up",ck="%1 rows",cl="qx.ui.table.selection.Model",cq="one row",cE="PageDown",cX="%1 of %2 rows",cW="keypress",cy="changeRowHeight",cY="Number",ct="header",cS="__et",co="qx.ui.table.IRowRenderer",cp="Right",cv="__es",cA="Space";qx.Class.define(ce,{extend:qx.ui.core.Widget,construct:function(v,w){qx.ui.core.Widget.call(this);if(!w){w={};}if(w.selectionManager){this.setNewSelectionManager(w.selectionManager);}if(w.selectionModel){this.setNewSelectionModel(w.selectionModel);}if(w.tableColumnModel){this.setNewTableColumnModel(w.tableColumnModel);}if(w.tablePane){this.setNewTablePane(w.tablePane);}if(w.tablePaneHeader){this.setNewTablePaneHeader(w.tablePaneHeader);}if(w.tablePaneScroller){this.setNewTablePaneScroller(w.tablePaneScroller);}if(w.tablePaneModel){this.setNewTablePaneModel(w.tablePaneModel);}if(w.columnMenu){this.setNewColumnMenu(w.columnMenu);}this._setLayout(new qx.ui.layout.VBox());this.__ek=new qx.ui.container.Composite(new qx.ui.layout.HBox());this._add(this.__ek,{flex:1});this.setDataRowRenderer(new qx.ui.table.rowrenderer.Default(this));this.__el=this.getNewSelectionManager()(this);this.setSelectionModel(this.getNewSelectionModel()(this));this.setTableModel(v||this.getEmptyTableModel());this.setMetaColumnCounts([-1]);this.setTabIndex(1);this.addListener(cW,this._onKeyPress);this.addListener(cb,this._onFocusChanged);this.addListener(de,this._onFocusChanged);var y=new qx.ui.core.Widget().set({height:0});this._add(y);y.addListener(cL,this._onResize,this);this.__em=null;this.__en=null;if(qx.core.Variant.isSet(dk,dh)){qx.locale.Manager.getInstance().addListener(dn,this._onChangeLocale,this);}this.initStatusBarVisible();v=this.getTableModel();if(v.init&&typeof (v.init)==bQ){v.init(this);}},events:{"columnVisibilityMenuCreateStart":bT,"columnVisibilityMenuCreateEnd":bT,"tableWidthChanged":cV,"verticalScrollBarChanged":bT,"cellClick":bR,"cellDblclick":bR,"cellContextmenu":bR,"dataEdited":bT},statics:{__eo:{cellClick:1,cellDblclick:1,cellContextmenu:1}},properties:{appearance:{refine:true,init:cD},focusable:{refine:true,init:true},minWidth:{refine:true,init:50},selectable:{refine:true,init:false},selectionModel:{check:cl,apply:dc,event:cF},tableModel:{check:cu,apply:cQ,event:cP},rowHeight:{check:cY,init:20,apply:cC,event:cy},forceLineHeight:{check:bW,init:true},headerCellsVisible:{check:bW,init:true,apply:ch},headerCellHeight:{check:cI,init:16,apply:da,event:bY,nullable:true},statusBarVisible:{check:bW,init:true,apply:dg},additionalStatusBarText:{nullable:true,init:null,apply:cx},columnVisibilityButtonVisible:{check:bW,init:true,apply:cG},metaColumnCounts:{check:cw,apply:ca},focusCellOnMouseMove:{check:bW,init:false,apply:cz},rowFocusChangeModifiesSelection:{check:bW,init:true},showCellFocusIndicator:{check:bW,init:true,apply:cM},keepFirstVisibleRowComplete:{check:bW,init:true,apply:bK},alwaysUpdateCells:{check:bW,init:false},resetSelectionOnHeaderClick:{check:bW,init:true,apply:cd},dataRowRenderer:{check:co,init:null,nullable:true,event:bX},modalCellEditorPreOpenFunction:{check:bU,init:null,nullable:true},newColumnMenu:{check:bU,init:function(){return new qx.ui.table.columnmenu.Button();}},newSelectionManager:{check:bU,init:function(ej){return new qx.ui.table.selection.Manager(ej);}},newSelectionModel:{check:bU,init:function(fb){return new qx.ui.table.selection.Model(fb);}},newTableColumnModel:{check:bU,init:function(ds){return new qx.ui.table.columnmodel.Basic(ds);}},newTablePane:{check:bU,init:function(dr){return new qx.ui.table.pane.Pane(dr);}},newTablePaneHeader:{check:bU,init:function(q){return new qx.ui.table.pane.Header(q);}},newTablePaneScroller:{check:bU,init:function(ff){return new qx.ui.table.pane.Scroller(ff);}},newTablePaneModel:{check:bU,init:function(fi){return new qx.ui.table.pane.Model(fi);}}},members:{__em:null,__en:null,__ek:null,__el:null,__ep:null,__eq:null,__er:null,__es:null,__et:null,__eu:null,_createChildControlImpl:function(eg){var eh;switch(eg){case bS:eh=new qx.ui.basic.Label();eh.set({allowGrowX:true});this._add(eh);break;case bV:eh=this.getNewColumnMenu()();eh.set({focusable:false});var ei=eh.factory(cs,{table:this});ei.addListener(bM,this._initColumnMenu,this);break;}return eh||qx.ui.core.Widget.prototype._createChildControlImpl.call(this,eg);},_applySelectionModel:function(dF,dG){this.__el.setSelectionModel(dF);if(dG!=null){dG.removeListener(dm,this._onSelectionChanged,this);}dF.addListener(dm,this._onSelectionChanged,this);},_applyRowHeight:function(ea,eb){var ec=this._getPaneScrollerArr();for(var i=0;i<ec.length;i++){ec[i].updateVerScrollBarMaximum();}},_applyHeaderCellsVisible:function(dS,dT){var dU=this._getPaneScrollerArr();for(var i=0;i<dU.length;i++){dU[i]._excludeChildControl(ct);}},_applyHeaderCellHeight:function(dP,dQ){var dR=this._getPaneScrollerArr();for(var i=0;i<dR.length;i++){dR[i].getHeader().setHeight(dP);}},getEmptyTableModel:function(){if(!this.__eu){this.__eu=new qx.ui.table.model.Simple();this.__eu.setColumns([]);this.__eu.setData([]);}return this.__eu;},_applyTableModel:function(dp,dq){this.getTableColumnModel().init(dp.getColumnCount(),this);if(dq!=null){dq.removeListener(di,this._onTableModelMetaDataChanged,this);dq.removeListener(bO,this._onTableModelDataChanged,this);}dp.addListener(di,this._onTableModelMetaDataChanged,this);dp.addListener(bO,this._onTableModelDataChanged,this);this._updateStatusBar();this._updateTableData(0,dp.getRowCount(),0,dp.getColumnCount());this._onTableModelMetaDataChanged();if(dq&&dp.init&&typeof (dp.init)==bQ){dp.init(this);}},getTableColumnModel:function(){if(!this.__et){var eU=this.__et=this.getNewTableColumnModel()(this);eU.addListener(cT,this._onColVisibilityChanged,this);eU.addListener(cU,this._onColWidthChanged,this);eU.addListener(dd,this._onColOrderChanged,this);var eT=this.getTableModel();eU.init(eT.getColumnCount(),this);var eR=this._getPaneScrollerArr();for(var i=0;i<eR.length;i++){var eS=eR[i];var eV=eS.getTablePaneModel();eV.setTableColumnModel(eU);}}return this.__et;},_applyStatusBarVisible:function(eM,eN){if(eM){this._showChildControl(bS);}else{this._excludeChildControl(bS);}if(eM){this._updateStatusBar();}},_applyAdditionalStatusBarText:function(ek,el){this.__ep=ek;this._updateStatusBar();},_applyColumnVisibilityButtonVisible:function(r,s){if(r){this._showChildControl(bV);}else{this._excludeChildControl(bV);}},_applyMetaColumnCounts:function(L,M){var T=L;var N=this._getPaneScrollerArr();var R={};if(L>M){var V=qx.event.Registration.getManager(N[0]);for(var W in qx.ui.table.Table.__eo){R[W]={};R[W].capture=V.getListeners(N[0],W,true);R[W].bubble=V.getListeners(N[0],W,false);}}this._cleanUpMetaColumns(T.length);var S=0;for(var i=0;i<N.length;i++){var X=N[i];var U=X.getTablePaneModel();U.setFirstColumnX(S);U.setMaxColumnCount(T[i]);S+=T[i];}if(T.length>N.length){var Q=this.getTableColumnModel();for(var i=N.length;i<T.length;i++){var U=this.getNewTablePaneModel()(Q);U.setFirstColumnX(S);U.setMaxColumnCount(T[i]);S+=T[i];var X=this.getNewTablePaneScroller()(this);X.setTablePaneModel(U);X.addListener(cR,this._onScrollY,this);for(W in qx.ui.table.Table.__eo){if(!R[W]){break;}if(R[W].capture&&R[W].capture.length>0){var O=R[W].capture;for(var i=0;i<O.length;i++){var P=O[i].context;if(!P){P=this;}else if(P==N[0]){P=X;}X.addListener(W,O[i].handler,P,true);}}if(R[W].bubble&&R[W].bubble.length>0){var ba=R[W].bubble;for(var i=0;i<ba.length;i++){var P=ba[i].context;if(!P){P=this;}else if(P==N[0]){P=X;}X.addListener(W,ba[i].handler,P,false);}}}var Y=(i==T.length-1)?1:0;this.__ek.add(X,{flex:Y});N=this._getPaneScrollerArr();}}for(var i=0;i<N.length;i++){var X=N[i];var bb=(i==(N.length-1));X.getHeader().setHeight(this.getHeaderCellHeight());X.setTopRightWidget(bb?this.getChildControl(bV):null);}if(!this.isColumnVisibilityButtonVisible()){this._excludeChildControl(bV);}this._updateScrollerWidths();this._updateScrollBarVisibility();},_applyFocusCellOnMouseMove:function(fc,fd){var fe=this._getPaneScrollerArr();for(var i=0;i<fe.length;i++){fe[i].setFocusCellOnMouseMove(fc);}},_applyShowCellFocusIndicator:function(eJ,eK){var eL=this._getPaneScrollerArr();for(var i=0;i<eL.length;i++){eL[i].setShowCellFocusIndicator(eJ);}},_applyKeepFirstVisibleRowComplete:function(c,d){var e=this._getPaneScrollerArr();for(var i=0;i<e.length;i++){e[i].onKeepFirstVisibleRowCompleteChanged();}},_applyResetSelectionOnHeaderClick:function(bc,bd){var be=this._getPaneScrollerArr();for(var i=0;i<be.length;i++){be[i].setResetSelectionOnHeaderClick(bc);}},getSelectionManager:function(){return this.__el;},_getPaneScrollerArr:function(){return this.__ek.getChildren();},getPaneScroller:function(b){return this._getPaneScrollerArr()[b];},_cleanUpMetaColumns:function(t){var u=this._getPaneScrollerArr();if(u!=null){for(var i=u.length-1;i>=t;i--){u[i].destroy();}}},_onChangeLocale:function(eI){this.updateContent();this._updateStatusBar();},_onSelectionChanged:function(fl){var fm=this._getPaneScrollerArr();for(var i=0;i<fm.length;i++){fm[i].onSelectionChanged();}this._updateStatusBar();},_onTableModelMetaDataChanged:function(bw){var bx=this._getPaneScrollerArr();for(var i=0;i<bx.length;i++){bx[i].onTableModelMetaDataChanged();}this._updateStatusBar();},_onTableModelDataChanged:function(dN){var dO=dN.getData();this._updateTableData(dO.firstRow,dO.lastRow,dO.firstColumn,dO.lastColumn,dO.removeStart,dO.removeCount);},_updateTableData:function(bC,bD,bE,bF,bG,bH){var bI=this._getPaneScrollerArr();if(bH){this.getSelectionModel().removeSelectionInterval(bG,bG+bH);if(this.__en>=bG&&this.__en<(bG+bH)){this.setFocusedCell();}}for(var i=0;i<bI.length;i++){bI[i].onTableModelDataChanged(bC,bD,bE,bF);}var bJ=this.getTableModel().getRowCount();if(bJ!=this.__eq){this.__eq=bJ;this._updateScrollBarVisibility();this._updateStatusBar();}},_onScrollY:function(bz){if(!this.__er){this.__er=true;var bA=this._getPaneScrollerArr();for(var i=0;i<bA.length;i++){bA[i].setScrollY(bz.getData());}this.__er=false;}},_onKeyPress:function(z){if(!this.getEnabled()){return;}var G=this.__en;var D=true;var H=z.getKeyIdentifier();if(this.isEditing()){if(z.getModifiers()==0){switch(H){case dj:this.stopEditing();var G=this.__en;this.moveFocusedCell(0,1);if(this.__en!=G){D=this.startEditing();}break;case cm:this.cancelEditing();this.focus();break;default:D=false;break;}}}else{if(z.isCtrlPressed()){D=true;switch(H){case cn:var E=this.getTableModel().getRowCount();if(E>0){this.getSelectionModel().setSelectionInterval(0,E-1);}break;default:D=false;break;}}else{switch(H){case cA:this.__el.handleSelectKeyDown(this.__en,z);break;case bL:case dj:this.startEditing();D=true;break;case cj:this.setFocusedCell(this.__em,0,true);break;case cO:var E=this.getTableModel().getRowCount();this.setFocusedCell(this.__em,E-1,true);break;case cB:this.moveFocusedCell(-1,0);break;case cp:this.moveFocusedCell(1,0);break;case cr:this.moveFocusedCell(0,-1);break;case cN:this.moveFocusedCell(0,1);break;case bP:case cE:var C=this.getPaneScroller(0);var F=C.getTablePane();var B=this.getRowHeight();var A=(H==bP)?-1:1;E=F.getVisibleRowCount()-1;C.setScrollY(C.getScrollY()+A*E*B);this.moveFocusedCell(0,A*E);break;default:D=false;}}}if(G!=this.__en&&this.getRowFocusChangeModifiesSelection()){this.__el.handleMoveKeyDown(this.__en,z);}if(D){z.preventDefault();z.stopPropagation();}},_onFocusChanged:function(ed){var ee=this._getPaneScrollerArr();for(var i=0;i<ee.length;i++){ee[i].onFocusChanged();}},_onColVisibilityChanged:function(I){var J=this._getPaneScrollerArr();for(var i=0;i<J.length;i++){J[i].onColVisibilityChanged();}var K=I.getData();if(this.__es!=null&&K.col!=null&&K.visible!=null){this.__es[K.col].setVisible(K.visible);}this._updateScrollerWidths();this._updateScrollBarVisibility();},_onColWidthChanged:function(dV){var dW=this._getPaneScrollerArr();for(var i=0;i<dW.length;i++){var dX=dV.getData();dW[i].setColumnWidth(dX.col,dX.newWidth);}this._updateScrollerWidths();this._updateScrollBarVisibility();},_onColOrderChanged:function(bf){var bg=this._getPaneScrollerArr();for(var i=0;i<bg.length;i++){bg[i].onColOrderChanged();}this._updateScrollerWidths();this._updateScrollBarVisibility();},getTablePaneScrollerAtPageX:function(fg){var fh=this._getMetaColumnAtPageX(fg);return (fh!=-1)?this.getPaneScroller(fh):null;},setFocusedCell:function(dt,du,dv){if(!this.isEditing()&&(dt!=this.__em||du!=this.__en)){if(dt===null){dt=0;}this.__em=dt;this.__en=du;var dw=this._getPaneScrollerArr();for(var i=0;i<dw.length;i++){dw[i].setFocusedCell(dt,du);}if(dt!==null&&dv){this.scrollCellVisible(dt,du);}}},resetSelection:function(){this.getSelectionModel().resetSelection();},resetCellFocus:function(){this.setFocusedCell(null,null,false);},getFocusedColumn:function(){return this.__em;},getFocusedRow:function(){return this.__en;},highlightFocusedRow:function(dH){this.getDataRowRenderer().setHighlightFocusRow(dH);},clearFocusedRowHighlight:function(eO){if(eO){var eQ=eO.getRelatedTarget();if(eQ instanceof qx.ui.table.pane.Pane||eQ instanceof qx.ui.table.pane.FocusIndicator){return;}}this.resetCellFocus();var eP=this._getPaneScrollerArr();for(var i=0;i<eP.length;i++){eP[i].onFocusChanged();}},moveFocusedCell:function(bh,bi){var bm=this.__em;var bn=this.__en;if(bm===null||bn===null){return;}if(bh!=0){var bl=this.getTableColumnModel();var x=bl.getVisibleX(bm);var bk=bl.getVisibleColumnCount();x=qx.lang.Number.limit(x+bh,0,bk-1);bm=bl.getVisibleColumnAtX(x);}if(bi!=0){var bj=this.getTableModel();bn=qx.lang.Number.limit(bn+bi,0,bj.getRowCount()-1);}this.setFocusedCell(bm,bn,true);},scrollCellVisible:function(eW,eX){var eY=this.getTableColumnModel();var x=eY.getVisibleX(eW);var fa=this._getMetaColumnAtColumnX(x);if(fa!=-1){this.getPaneScroller(fa).scrollCellVisible(eW,eX);}},isEditing:function(){if(this.__em!=null){var x=this.getTableColumnModel().getVisibleX(this.__em);var ef=this._getMetaColumnAtColumnX(x);return this.getPaneScroller(ef).isEditing();}return false;},startEditing:function(){if(this.__em!=null){var x=this.getTableColumnModel().getVisibleX(this.__em);var g=this._getMetaColumnAtColumnX(x);var f=this.getPaneScroller(g).startEditing();return f;}return false;},stopEditing:function(){if(this.__em!=null){var x=this.getTableColumnModel().getVisibleX(this.__em);var by=this._getMetaColumnAtColumnX(x);this.getPaneScroller(by).stopEditing();}},cancelEditing:function(){if(this.__em!=null){var x=this.getTableColumnModel().getVisibleX(this.__em);var a=this._getMetaColumnAtColumnX(x);this.getPaneScroller(a).cancelEditing();}},updateContent:function(){var dx=this._getPaneScrollerArr();for(var i=0;i<dx.length;i++){dx[i].getTablePane().updateContent(true);}},blockHeaderElements:function(){var bB=this._getPaneScrollerArr();for(var i=0;i<bB.length;i++){bB[i].getHeader().getBlocker().blockContent(20);}this.getChildControl(bV).getBlocker().blockContent(20);},unblockHeaderElements:function(){var dM=this._getPaneScrollerArr();for(var i=0;i<dM.length;i++){dM[i].getHeader().getBlocker().unblockContent();}this.getChildControl(bV).getBlocker().unblockContent();},_getMetaColumnAtPageX:function(dy){var dz=this._getPaneScrollerArr();for(var i=0;i<dz.length;i++){var dA=dz[i].getContainerLocation();if(dy>=dA.left&&dy<=dA.right){return i;}}return -1;},_getMetaColumnAtColumnX:function(dI){var dK=this.getMetaColumnCounts();var dL=0;for(var i=0;i<dK.length;i++){var dJ=dK[i];dL+=dJ;if(dJ==-1||dI<dL){return i;}}return -1;},_updateStatusBar:function(){var ev=this.getTableModel();if(this.getStatusBarVisible()){var ew=this.getSelectionModel().getSelectedCount();var ey=ev.getRowCount();var ex;if(ey>=0){if(ew==0){ex=this.trn(cq,ck,ey,ey);}else{ex=this.trn(ci,cX,ey,ew,ey);}}if(this.__ep){if(ex){ex+=this.__ep;}else{ex=this.__ep;}}if(ex){this.getChildControl(bS).setValue(ex);}}},_updateScrollerWidths:function(){var dB=this._getPaneScrollerArr();for(var i=0;i<dB.length;i++){var dD=(i==(dB.length-1));var dE=dB[i].getTablePaneModel().getTotalWidth();dB[i].setPaneWidth(dE);var dC=dD?1:0;dB[i].setLayoutProperties({flex:dC});}},_updateScrollBarVisibility:function(){if(!this.getBounds()){return;}var br=qx.ui.table.pane.Scroller.HORIZONTAL_SCROLLBAR;var bu=qx.ui.table.pane.Scroller.VERTICAL_SCROLLBAR;var bo=this._getPaneScrollerArr();var bq=false;var bt=false;for(var i=0;i<bo.length;i++){var bv=(i==(bo.length-1));var bp=bo[i].getNeededScrollBars(bq,!bv);if(bp&br){bq=true;}if(bv&&(bp&bu)){bt=true;}}for(var i=0;i<bo.length;i++){var bv=(i==(bo.length-1));var bs;bo[i].setHorizontalScrollBarVisible(bq);if(bv){bs=bo[i].getVerticalScrollBarVisible();}bo[i].setVerticalScrollBarVisible(bv&&bt);if(bv&&bt!=bs){this.fireDataEvent(cK,bt);}}},_initColumnMenu:function(){var k=this.getTableModel();var m=this.getTableColumnModel();var n=this.getChildControl(bV);n.empty();var j=n.getMenu();var o={table:this,menu:j,columnButton:n};this.fireDataEvent(df,o);this.__es={};for(var p=0,l=k.getColumnCount();p<l;p++){var h=n.factory(db,{text:k.getColumnName(p),column:p,bVisible:m.isColumnVisible(p)});qx.core.Assert.assertInterface(h,qx.ui.table.IColumnMenuItem);h.addListener(cc,this._createColumnVisibilityCheckBoxHandler(p),this);this.__es[p]=h;}o={table:this,menu:j,columnButton:n};this.fireDataEvent(cf,o);},_createColumnVisibilityCheckBoxHandler:function(dY){return function(fj){var fk=this.getTableColumnModel();fk.setColumnVisible(dY,fj.getData());};},setColumnWidth:function(et,eu){this.getTableColumnModel().setColumnWidth(et,eu);},_onResize:function(){this.fireEvent(cg);this._updateScrollerWidths();this._updateScrollBarVisibility();},addListener:function(eo,ep,self,eq){if(this.self(arguments).__eo[eo]){var es=[eo];for(var i=0,er=this._getPaneScrollerArr();i<er.length;i++){es.push(er[i].addListener.apply(er[i],arguments));}return es.join(bN);}else{return qx.ui.core.Widget.prototype.addListener.call(this,eo,ep,self,eq);}},removeListener:function(ez,eA,self,eB){if(this.self(arguments).__eo[ez]){for(var i=0,eC=this._getPaneScrollerArr();i<eC.length;i++){eC[i].removeListener.apply(eC[i],arguments);}}else{qx.ui.core.Widget.prototype.removeListener.call(this,ez,eA,self,eB);}},removeListenerById:function(eD){var eH=eD.split(bN);var eG=eH.shift();if(this.self(arguments).__eo[eG]){var eF=true;for(var i=0,eE=this._getPaneScrollerArr();i<eE.length;i++){eF=eE[i].removeListenerById.call(eE[i],eH[i])&&eF;}return eF;}else{return qx.ui.core.Widget.prototype.removeListenerById.call(this,eD);}},destroy:function(){this.getChildControl(bV).getMenu().destroy();qx.ui.core.Widget.prototype.destroy.call(this);}},destruct:function(){if(qx.core.Variant.isSet(dk,dh)){qx.locale.Manager.getInstance().removeListener(dn,this._onChangeLocale,this);}var en=this.getSelectionModel();if(en){en.dispose();}var em=this.getDataRowRenderer();if(em){em.dispose();}this._cleanUpMetaColumns(0);this.getTableColumnModel().dispose();this._disposeObjects(cJ,cH,dl,dl,cS);this._disposeMap(cv);}});})();(function(){var H="]",G="..",F="changeSelection",E="_applySelectionMode",D='ie',C="qx.event.type.Event",B="Ranges:",A="qx.ui.table.selection.Model",z=" [";qx.Class.define(A,{extend:qx.core.Object,construct:function(){qx.core.Object.call(this);this.__ev=[];this.__ew=-1;this.__ex=-1;this.hasBatchModeRefCount=0;this.__ey=false;},events:{"changeSelection":C},statics:{NO_SELECTION:1,SINGLE_SELECTION:2,SINGLE_INTERVAL_SELECTION:3,MULTIPLE_INTERVAL_SELECTION:4,MULTIPLE_INTERVAL_SELECTION_TOGGLE:5},properties:{selectionMode:{init:2,check:[1,2,3,4,5],apply:E}},members:{__ey:null,__ew:null,__ex:null,__ev:null,_applySelectionMode:function(L){this.resetSelection();},setBatchMode:function(o){if(o){this.hasBatchModeRefCount+=1;}else{if(this.hasBatchModeRefCount==0){throw new Error("Try to turn off batch mode althoug it was not turned on.");}this.hasBatchModeRefCount-=1;if(this.__ey){this.__ey=false;this._fireChangeSelection();}}return this.hasBatchMode();},hasBatchMode:function(){return this.hasBatchModeRefCount>0;},getAnchorSelectionIndex:function(){return this.__ew;},_setAnchorSelectionIndex:function(y){this.__ew=y;},getLeadSelectionIndex:function(){return this.__ex;},_setLeadSelectionIndex:function(T){this.__ex=T;},_getSelectedRangeArr:function(){return this.__ev;},resetSelection:function(){if(!this.isSelectionEmpty()){this._resetSelection();this._fireChangeSelection();}},isSelectionEmpty:function(){return this.__ev.length==0;},getSelectedCount:function(){var P=0;for(var i=0;i<this.__ev.length;i++){var O=this.__ev[i];P+=O.maxIndex-O.minIndex+1;}return P;},isSelectedIndex:function(M){for(var i=0;i<this.__ev.length;i++){var N=this.__ev[i];if(M>=N.minIndex&&M<=N.maxIndex){return true;}}return false;},getSelectedRanges:function(){var I=[];for(var i=0;i<this.__ev.length;i++){I.push({minIndex:this.__ev[i].minIndex,maxIndex:this.__ev[i].maxIndex});}return I;},iterateSelection:function(J,K){for(var i=0;i<this.__ev.length;i++){for(var j=this.__ev[i].minIndex;j<=this.__ev[i].maxIndex;j++){J.call(K,j);}}},setSelectionInterval:function(l,m){var n=this.self(arguments);switch(this.getSelectionMode()){case n.NO_SELECTION:return;case n.SINGLE_SELECTION:if(this.isSelectedIndex(m)){return;}l=m;break;case n.MULTIPLE_INTERVAL_SELECTION_TOGGLE:this.setBatchMode(true);try{for(var i=l;i<=m;i++){if(!this.isSelectedIndex(i)){this._addSelectionInterval(i,i);}else{this.removeSelectionInterval(i,i);}}}catch(e){if(qx.bom.client.Browser.NAME==D&&qx.bom.client.Browser.VERSION<=7){this.setBatchMode(false);}throw e;}finally{this.setBatchMode(false);}this._fireChangeSelection();return;}this._resetSelection();this._addSelectionInterval(l,m);this._fireChangeSelection();},addSelectionInterval:function(Q,R){var S=qx.ui.table.selection.Model;switch(this.getSelectionMode()){case S.NO_SELECTION:return;case S.MULTIPLE_INTERVAL_SELECTION:case S.MULTIPLE_INTERVAL_SELECTION_TOGGLE:this._addSelectionInterval(Q,R);this._fireChangeSelection();break;default:this.setSelectionInterval(Q,R);break;}},removeSelectionInterval:function(a,b){this.__ew=a;this.__ex=b;var c=Math.min(a,b);var f=Math.max(a,b);for(var i=0;i<this.__ev.length;i++){var h=this.__ev[i];if(h.minIndex>f){break;}else if(h.maxIndex>=c){var k=(h.minIndex>=c)&&(h.minIndex<=f);var g=(h.maxIndex>=c)&&(h.maxIndex<=f);if(k&&g){this.__ev.splice(i,1);i--;}else if(k){h.minIndex=f+1;}else if(g){h.maxIndex=c-1;}else{var d={minIndex:f+1,maxIndex:h.maxIndex};this.__ev.splice(i+1,0,d);h.maxIndex=c-1;break;}}}this._fireChangeSelection();},_resetSelection:function(){this.__ev=[];this.__ew=-1;this.__ex=-1;},_addSelectionInterval:function(p,q){this.__ew=p;this.__ex=q;var r=Math.min(p,q);var t=Math.max(p,q);var s=0;for(;s<this.__ev.length;s++){var u=this.__ev[s];if(u.minIndex>r){break;}}this.__ev.splice(s,0,{minIndex:r,maxIndex:t});var v=this.__ev[0];for(var i=1;i<this.__ev.length;i++){var u=this.__ev[i];if(v.maxIndex+1>=u.minIndex){v.maxIndex=Math.max(v.maxIndex,u.maxIndex);this.__ev.splice(i,1);i--;}else{v=u;}}},_dumpRanges:function(){var w=B;for(var i=0;i<this.__ev.length;i++){var x=this.__ev[i];w+=z+x.minIndex+G+x.maxIndex+H;}this.debug(w);},_fireChangeSelection:function(){if(this.hasBatchMode()){this.__ey=true;}else{this.fireEvent(F);}}},destruct:function(){this.__ev=null;}});})();(function(){var q="dataChanged",p="qx.event.type.Data",o="Left",n="Right",m="hidden",l="object",k="Boolean",h="Enter",g="number",f="changeSelection",a="qx.ui.treevirtual.TreeVirtual",d="treevirtual",c="dataEdited";qx.Class.define(a,{extend:qx.ui.table.Table,construct:function(r,t){if(!t){t={};}if(!t.dataModel){t.dataModel=new qx.ui.treevirtual.SimpleTreeDataModel();}if(t.treeColumn===undefined){t.treeColumn=0;t.dataModel.setTreeColumn(t.treeColumn);}if(!t.treeDataCellRenderer){t.treeDataCellRenderer=new qx.ui.treevirtual.SimpleTreeDataCellRenderer();}if(!t.defaultDataCellRenderer){t.defaultDataCellRenderer=new qx.ui.treevirtual.DefaultDataCellRenderer();}if(!t.dataRowRenderer){t.dataRowRenderer=new qx.ui.treevirtual.SimpleTreeDataRowRenderer();}if(!t.selectionManager){t.selectionManager=function(bi){return new qx.ui.treevirtual.SelectionManager(bi);};}if(!t.tableColumnModel){t.tableColumnModel=function(J){return new qx.ui.table.columnmodel.Resize(J);};}if(qx.lang.Type.isString(r)){r=[r];}t.dataModel.setColumns(r);t.dataModel.setTreeColumn(t.treeColumn);t.dataModel.setTree(this);qx.ui.table.Table.call(this,t.dataModel,t);this.addListener(c,function(e){this.getDataModel().setData();},this);this.setColumnVisibilityButtonVisible(r.length>1);this.setRowHeight(16);this.setMetaColumnCounts(r.length>1?[1,-1]:[1]);this.setOverflow(m);var v=t.treeDataCellRenderer;var u=t.defaultDataCellRenderer;var y=this.getTableColumnModel();var x=this.getDataModel().getTreeColumn();for(var i=0;i<r.length;i++){y.setDataCellRenderer(i,i==x?v:u);}this.setDataRowRenderer(t.dataRowRenderer);this.setFocusCellOnMouseMove(true);this.setShowCellFocusIndicator(false);var w=this._getPaneScrollerArr();for(var i=0;i<w.length;i++){w[i].setSelectBeforeFocus(true);}},events:{"treeOpenWithContent":p,"treeOpenWhileEmpty":p,"treeClose":p,"changeSelection":p},statics:{SelectionMode:{NONE:qx.ui.table.selection.Model.NO_SELECTION,SINGLE:qx.ui.table.selection.Model.SINGLE_SELECTION,SINGLE_INTERVAL:qx.ui.table.selection.Model.SINGLE_INTERVAL_SELECTION,MULTIPLE_INTERVAL:qx.ui.table.selection.Model.MULTIPLE_INTERVAL_SELECTION,MULTIPLE_INTERVAL_TOGGLE:qx.ui.table.selection.Model.MULTIPLE_INTERVAL_SELECTION_TOGGLE}},properties:{openCloseClickSelectsRow:{check:k,init:false},appearance:{refine:true,init:d}},members:{getDataModel:function(){return this.getTableModel();},setUseTreeLines:function(b){var M=this.getDataModel();var K=M.getTreeColumn();var L=this.getTableColumnModel().getDataCellRenderer(K);L.setUseTreeLines(b);if(M.hasListener(q)){var N={firstRow:0,lastRow:M.getRowCount()-1,firstColumn:0,lastColumn:M.getColumnCount()-1};M.fireDataEvent(q,N);}},getUseTreeLines:function(){var z=this.getDataModel().getTreeColumn();var A=this.getTableColumnModel().getDataCellRenderer(z);return A.getUseTreeLines();},setAlwaysShowOpenCloseSymbol:function(b){var T=this.getDataModel();var R=T.getTreeColumn();var S=this.getTableColumnModel().getDataCellRenderer(R);S.setAlwaysShowOpenCloseSymbol(b);if(T.hasListener(q)){var U={firstRow:0,lastRow:T.getRowCount()-1,firstColumn:0,lastColumn:T.getColumnCount()-1};T.fireDataEvent(q,U);}},setExcludeFirstLevelTreeLines:function(b){var D=this.getDataModel();var B=D.getTreeColumn();var C=this.getTableColumnModel().getDataCellRenderer(B);C.setExcludeFirstLevelTreeLines(b);if(D.hasListener(q)){var E={firstRow:0,lastRow:D.getRowCount()-1,firstColumn:0,lastColumn:D.getColumnCount()-1};D.fireDataEvent(q,E);}},getExcludeFirstLevelTreeLines:function(){var V=this.getDataModel().getTreeColumn();var W=this.getTableColumnModel().getDataCellRenderer(V);return W.getExcludeFirstLevelTreeLines();},getAlwaysShowOpenCloseSymbol:function(){var F=this.getDataModel().getTreeColumn();var G=this.getTableColumnModel().getDataCellRenderer(F);return G.getAlwaysShowOpenCloseSymbol();},setSelectionMode:function(O){this.getSelectionModel().setSelectionMode(O);},getSelectionMode:function(){return this.getSelectionModel().getSelectionMode();},getHierarchy:function(bc){var bg=this;var bf=[];var bd;var bh;if(typeof (bc)==l){bd=bc;bh=bd.nodeId;}else if(typeof (bc)==g){bh=bc;}else{throw new Error("Expected node object or node id");}function be(P){if(!P){return ;}var Q=bg.getDataModel().getData()[P];bf.unshift(Q.label);be(Q.parentNodeId);}be(bh);return bf;},getSelectedNodes:function(){return this.getDataModel().getSelectedNodes();},_onKeyPress:function(bj){if(!this.getEnabled()){return;}var bs=bj.getKeyIdentifier();var bo=false;var bq=bj.getModifiers();if(bq==0){switch(bs){case h:var bl=this.getDataModel();var bm=this.getFocusedColumn();var bp=bl.getTreeColumn();if(bm==bp){var br=this.getFocusedRow();var bk=bl.getNode(br);if(!bk.bHideOpenClose){bl.setState(bk,{bOpened:!bk.bOpened});}bo=true;}break;case o:this.moveFocusedCell(-1,0);break;case n:this.moveFocusedCell(1,0);break;}}else if(bq==qx.event.type.Dom.CTRL_MASK){switch(bs){case o:var bl=this.getDataModel();var br=this.getFocusedRow();var bp=bl.getTreeColumn();var bk=bl.getNode(br);if((bk.type==qx.ui.treevirtual.SimpleTreeDataModel.Type.BRANCH)&&!bk.bHideOpenClose&&bk.bOpened){bl.setState(bk,{bOpened:!bk.bOpened});}this.setFocusedCell(bp,br,true);bo=true;break;case n:var bl=this.getDataModel();br=this.getFocusedRow();bp=bl.getTreeColumn();bk=bl.getNode(br);if((bk.type==qx.ui.treevirtual.SimpleTreeDataModel.Type.BRANCH)&&!bk.bHideOpenClose&&!bk.bOpened){bl.setState(bk,{bOpened:!bk.bOpened});}this.setFocusedCell(bp,br,true);bo=true;break;}}else if(bq==qx.event.type.Dom.SHIFT_MASK){switch(bs){case o:var bl=this.getDataModel();var br=this.getFocusedRow();var bp=bl.getTreeColumn();var bk=bl.getNode(br);if(bk.parentNodeId){var bn=bl.getRowFromNodeId(bk.parentNodeId);this.setFocusedCell(this._focusedCol,bn,true);}bo=true;break;case n:var bl=this.getDataModel();br=this.getFocusedRow();bp=bl.getTreeColumn();bk=bl.getNode(br);if((bk.type==qx.ui.treevirtual.SimpleTreeDataModel.Type.BRANCH)&&!bk.bHideOpenClose){if(!bk.bOpened){bl.setState(bk,{bOpened:!bk.bOpened});}if(bk.children.length>0){this.moveFocusedCell(0,1);}}bo=true;break;}}if(bo){bj.preventDefault();bj.stopPropagation();}else{qx.ui.table.Table.prototype._onKeyPress.call(this,bj);}},_onSelectionChanged:function(H){this.getDataModel()._clearSelections();if(this.getSelectionMode()!=qx.ui.treevirtual.TreeVirtual.SelectionMode.NONE){var I=this._calculateSelectedNodes();this.fireDataEvent(f,I);}qx.ui.table.Table.prototype._onSelectionChanged.call(this,H);},_calculateSelectedNodes:function(){var bb=this.getDataModel();var Y=this.getSelectionModel().getSelectedRanges();var ba=[];var X;for(var i=0;i<Y.length;i++){for(var j=Y[i].minIndex;j<=Y[i].maxIndex;j++){X=bb.getNode(j);bb.setState(X,{bSelected:true});ba.push(X);}}return ba;},setOverflow:function(s){if(s!=m){throw new Error("Tree overflow must be hidden.  "+"The internal elements of it will scroll.");}}}});})();(function(){var c="qx.ui.core.queue.Layout",b="layout";qx.Class.define(c,{statics:{__ez:{},remove:function(a){delete this.__ez[a.$$hash];},add:function(m){this.__ez[m.$$hash]=m;qx.ui.core.queue.Manager.scheduleFlush(b);},flush:function(){var n=this.__eC();for(var i=n.length-1;i>=0;i--){var o=n[i];if(o.hasValidLayout()){continue;}if(o.isRootWidget()&&!o.hasUserBounds()){var q=o.getSizeHint();o.renderLayout(0,0,q.width,q.height);}else{var p=o.getBounds();o.renderLayout(p.left,p.top,p.width,p.height);}}},getNestingLevel:function(r){var s=this.__eB;var u=0;var parent=r;while(true){if(s[parent.$$hash]!=null){u+=s[parent.$$hash];break;}if(!parent.$$parent){break;}parent=parent.$$parent;u+=1;}var t=u;while(r&&r!==parent){s[r.$$hash]=t--;r=r.$$parent;}return u;},__eA:function(){var A=qx.ui.core.queue.Visibility;this.__eB={};var z=[];var y=this.__ez;var v,x;for(var w in y){v=y[w];if(A.isVisible(v)){x=this.getNestingLevel(v);if(!z[x]){z[x]={};}z[x][w]=v;delete y[w];}}return z;},__eC:function(){var g=[];var j=this.__eA();for(var f=j.length-1;f>=0;f--){if(!j[f]){continue;}for(var e in j[f]){var d=j[f][e];if(f==0||d.isRootWidget()||d.hasUserBounds()){g.push(d);d.invalidateLayoutCache();continue;}var l=d.getSizeHint(false);if(l){d.invalidateLayoutCache();var h=d.getSizeHint();var k=(!d.getBounds()||l.minWidth!==h.minWidth||l.width!==h.width||l.maxWidth!==h.maxWidth||l.minHeight!==h.minHeight||l.height!==h.height||l.maxHeight!==h.maxHeight);}else{k=true;}if(k){var parent=d.getLayoutParent();if(!j[f-1]){j[f-1]={};}j[f-1][parent.$$hash]=parent;}else{g.push(d);}}}return g;}}});})();(function(){var h="qx.event.handler.UserAction";qx.Class.define(h,{extend:qx.core.Object,implement:qx.event.IEventHandler,construct:function(i){qx.core.Object.call(this);this.__eD=i;this.__eE=i.getWindow();},statics:{PRIORITY:qx.event.Registration.PRIORITY_NORMAL,SUPPORTED_TYPES:{useraction:1},TARGET_CHECK:qx.event.IEventHandler.TARGET_WINDOW,IGNORE_CAN_HANDLE:true},members:{__eD:null,__eE:null,canHandleEvent:function(j,k){},registerEvent:function(b,c,d){},unregisterEvent:function(e,f,g){}},destruct:function(){this.__eD=this.__eE=null;},defer:function(a){qx.event.Registration.addHandler(a);}});})();(function(){var d="qx.util.DeferredCallManager",c="singleton";qx.Class.define(d,{extend:qx.core.Object,type:c,construct:function(){this.__eF={};this.__eG=qx.lang.Function.bind(this.__eK,this);this.__eH=false;},members:{__eI:null,__eJ:null,__eF:null,__eH:null,__eG:null,schedule:function(e){if(this.__eI==null){this.__eI=window.setTimeout(this.__eG,0);}var f=e.toHashCode();if(this.__eJ&&this.__eJ[f]){return;}this.__eF[f]=e;this.__eH=true;},cancel:function(a){var b=a.toHashCode();if(this.__eJ&&this.__eJ[b]){this.__eJ[b]=null;return;}delete this.__eF[b];if(qx.lang.Object.isEmpty(this.__eF)&&this.__eI!=null){window.clearTimeout(this.__eI);this.__eI=null;}},__eK:qx.event.GlobalError.observeMethod(function(){this.__eI=null;while(this.__eH){this.__eJ=qx.lang.Object.clone(this.__eF);this.__eF={};this.__eH=false;for(var h in this.__eJ){var g=this.__eJ[h];if(g){this.__eJ[h]=null;g.call();}}}this.__eJ=null;})},destruct:function(){if(this.__eI!=null){window.clearTimeout(this.__eI);}this.__eG=this.__eF=null;}});})();(function(){var a="qx.util.DeferredCall";qx.Class.define(a,{extend:qx.core.Object,construct:function(d,e){qx.core.Object.call(this);this.__eL=d;this.__eM=e||null;this.__eN=qx.util.DeferredCallManager.getInstance();},members:{__eL:null,__eM:null,__eN:null,cancel:function(){this.__eN.cancel(this);},schedule:function(){this.__eN.schedule(this);},call:function(){this.__eM?this.__eL.apply(this.__eM):this.__eL();}},destruct:function(b,c){this.cancel();this.__eM=this.__eL=this.__eN=null;}});})();(function(){var cW="element",cV="qx.client",cU="qxSelectable",cT="off",cS="on",cR="div",cQ="",cP="mshtml",cO="none",cN="scroll",dr="text",dq="qx.html.Element",dp="|capture|",dn="activate",dm="blur",dl="deactivate",dk="capture",dj="userSelect",di="__fl",dh="-moz-none",df="visible",dg="releaseCapture",dd="|bubble|",de="tabIndex",da="focus",dc="MozUserSelect",cX="normal",cY="hidden";qx.Class.define(dq,{extend:qx.core.Object,construct:function(ds,dt,du){qx.core.Object.call(this);this.__eO=ds||cR;this.__eP=dt||null;this.__eQ=du||null;},statics:{DEBUG:false,_modified:{},_visibility:{},_scroll:{},_actions:[],__eR:{},_scheduleFlush:function(H){qx.html.Element.__fw.schedule();},flush:function(){var S;{};var K=this.__eS();var J=K.getFocus();if(J&&this.__eW(J)){K.blur(J);}var ba=K.getActive();if(ba&&this.__eW(ba)){qx.bom.Element.deactivate(ba);}var N=this.__eU();if(N&&this.__eW(N)){qx.bom.Element.releaseCapture(N);}var T=[];var U=this._modified;for(var R in U){S=U[R];if(S.__fp()){if(S.__eX&&qx.dom.Hierarchy.isRendered(S.__eX)){T.push(S);}else{{};S.__fo();}delete U[R];}}for(var i=0,l=T.length;i<l;i++){S=T[i];{};S.__fo();}var P=this._visibility;for(var R in P){S=P[R];var V=S.__eX;if(!V){delete P[R];continue;}{};if(!S.$$disposed){V.style.display=S.__fb?cQ:cO;if(qx.core.Variant.isSet(cV,cP)){if(!(document.documentMode>=8)){V.style.visibility=S.__fb?df:cY;}}}delete P[R];}var scroll=this._scroll;for(var R in scroll){S=scroll[R];var bb=S.__eX;if(bb&&bb.offsetWidth){var M=true;if(S.__fe!=null){S.__eX.scrollLeft=S.__fe;delete S.__fe;}if(S.__ff!=null){S.__eX.scrollTop=S.__ff;delete S.__ff;}var W=S.__fc;if(W!=null){var Q=W.element.getDomElement();if(Q&&Q.offsetWidth){qx.bom.element.Scroll.intoViewX(Q,bb,W.align);delete S.__fc;}else{M=false;}}var X=S.__fd;if(X!=null){var Q=X.element.getDomElement();if(Q&&Q.offsetWidth){qx.bom.element.Scroll.intoViewY(Q,bb,X.align);delete S.__fd;}else{M=false;}}if(M){delete scroll[R];}}}var L={"releaseCapture":1,"blur":1,"deactivate":1};for(var i=0;i<this._actions.length;i++){var Y=this._actions[i];var V=Y.element.__eX;if(!V||!L[Y.type]&&!Y.element.__fp()){continue;}var O=Y.args;O.unshift(V);qx.bom.Element[Y.type].apply(qx.bom.Element,O);}this._actions=[];for(var R in this.__eR){var I=this.__eR[R];var bb=I.element.__eX;if(bb){qx.bom.Selection.set(bb,I.start,I.end);delete this.__eR[R];}}qx.event.handler.Appear.refresh();},__eS:function(){if(!this.__eT){var cM=qx.event.Registration.getManager(window);this.__eT=cM.getHandler(qx.event.handler.Focus);}return this.__eT;},__eU:function(){if(!this.__eV){var cn=qx.event.Registration.getManager(window);this.__eV=cn.getDispatcher(qx.event.dispatch.MouseCapture);}return this.__eV.getCaptureElement();},__eW:function(cC){var cD=qx.core.ObjectRegistry.fromHashCode(cC.$$element);return cD&&!cD.__fp();}},members:{__eO:null,__eX:null,__eY:false,__fa:true,__fb:true,__fc:null,__fd:null,__fe:null,__ff:null,__fg:null,__fh:null,__fi:null,__eP:null,__eQ:null,__fj:null,__fk:null,__fl:null,__fm:null,__fn:null,_scheduleChildrenUpdate:function(){if(this.__fm){return;}this.__fm=true;qx.html.Element._modified[this.$$hash]=this;qx.html.Element._scheduleFlush(cW);},_createDomElement:function(){return qx.bom.Element.create(this.__eO);},__fo:function(){{};var c=this.__fl;if(c){var length=c.length;var d;for(var i=0;i<length;i++){d=c[i];if(d.__fb&&d.__fa&&!d.__eX){d.__fo();}}}if(!this.__eX){this.__eX=this._createDomElement();this.__eX.$$element=this.$$hash;this._copyData(false);if(c&&length>0){this._insertChildren();}}else{this._syncData();if(this.__fm){this._syncChildren();}}delete this.__fm;},_insertChildren:function(){var dC=this.__fl;var length=dC.length;var dE;if(length>2){var dD=document.createDocumentFragment();for(var i=0;i<length;i++){dE=dC[i];if(dE.__eX&&dE.__fa){dD.appendChild(dE.__eX);}}this.__eX.appendChild(dD);}else{var dD=this.__eX;for(var i=0;i<length;i++){dE=dC[i];if(dE.__eX&&dE.__fa){dD.appendChild(dE.__eX);}}}},_syncChildren:function(){var k;var q=qx.core.ObjectRegistry;var f=this.__fl;var o=f.length;var g;var m;var j=this.__eX;var n=j.childNodes;var h=0;var p;{};for(var i=n.length-1;i>=0;i--){p=n[i];m=q.fromHashCode(p.$$element);if(!m||!m.__fa||m.__fn!==this){j.removeChild(p);{};}}for(var i=0;i<o;i++){g=f[i];if(g.__fa){m=g.__eX;p=n[h];if(!m){continue;}if(m!=p){if(p){j.insertBefore(m,p);}else{j.appendChild(m);}{};}h++;}}{};},_copyData:function(bs){var bw=this.__eX;var bv=this.__eQ;if(bv){var bt=qx.bom.element.Attribute;for(var bx in bv){bt.set(bw,bx,bv[bx]);}}var bv=this.__eP;if(bv){var bu=qx.bom.element.Style;if(bs){bu.setStyles(bw,bv);}else{bu.setCss(bw,bu.compile(bv));}}var bv=this.__fj;if(bv){for(var bx in bv){this._applyProperty(bx,bv[bx]);}}var bv=this.__fk;if(bv){qx.event.Registration.getManager(bw).importListeners(bw,bv);delete this.__fk;}},_syncData:function(){var bD=this.__eX;var bC=qx.bom.element.Attribute;var bA=qx.bom.element.Style;var bB=this.__fh;if(bB){var bG=this.__eQ;if(bG){var bE;for(var bF in bB){bE=bG[bF];if(bE!==undefined){bC.set(bD,bF,bE);}else{bC.reset(bD,bF);}}}this.__fh=null;}var bB=this.__fg;if(bB){var bG=this.__eP;if(bG){var bz={};for(var bF in bB){bz[bF]=bG[bF];}bA.setStyles(bD,bz);}this.__fg=null;}var bB=this.__fi;if(bB){var bG=this.__fj;if(bG){var bE;for(var bF in bB){this._applyProperty(bF,bG[bF]);}}this.__fi=null;}},__fp:function(){var cF=this;while(cF){if(cF.__eY){return true;}if(!cF.__fa||!cF.__fb){return false;}cF=cF.__fn;}return false;},__fq:function(br){if(br.__fn===this){throw new Error("Child is already in: "+br);}if(br.__eY){throw new Error("Root elements could not be inserted into other ones.");}if(br.__fn){br.__fn.remove(br);}br.__fn=this;if(!this.__fl){this.__fl=[];}if(this.__eX){this._scheduleChildrenUpdate();}},__fr:function(bl){if(bl.__fn!==this){throw new Error("Has no child: "+bl);}if(this.__eX){this._scheduleChildrenUpdate();}delete bl.__fn;},__fs:function(bc){if(bc.__fn!==this){throw new Error("Has no child: "+bc);}if(this.__eX){this._scheduleChildrenUpdate();}},getChildren:function(){return this.__fl||null;},getChild:function(cy){var cz=this.__fl;return cz&&cz[cy]||null;},hasChildren:function(){var by=this.__fl;return by&&by[0]!==undefined;},indexOf:function(dL){var dM=this.__fl;return dM?dM.indexOf(dL):-1;},hasChild:function(cG){var cH=this.__fl;return cH&&cH.indexOf(cG)!==-1;},add:function(bk){if(arguments[1]){for(var i=0,l=arguments.length;i<l;i++){this.__fq(arguments[i]);}this.__fl.push.apply(this.__fl,arguments);}else{this.__fq(bk);this.__fl.push(bk);}return this;},addAt:function(bT,bU){this.__fq(bT);qx.lang.Array.insertAt(this.__fl,bT,bU);return this;},remove:function(bY){var ca=this.__fl;if(!ca){return;}if(arguments[1]){var cb;for(var i=0,l=arguments.length;i<l;i++){cb=arguments[i];this.__fr(cb);qx.lang.Array.remove(ca,cb);}}else{this.__fr(bY);qx.lang.Array.remove(ca,bY);}return this;},removeAt:function(cq){var cr=this.__fl;if(!cr){throw new Error("Has no children!");}var cs=cr[cq];if(!cs){throw new Error("Has no child at this position!");}this.__fr(cs);qx.lang.Array.removeAt(this.__fl,cq);return this;},removeAll:function(){var bQ=this.__fl;if(bQ){for(var i=0,l=bQ.length;i<l;i++){this.__fr(bQ[i]);}bQ.length=0;}return this;},getParent:function(){return this.__fn||null;},insertInto:function(parent,cI){parent.__fq(this);if(cI==null){parent.__fl.push(this);}else{qx.lang.Array.insertAt(this.__fl,this,cI);}return this;},insertBefore:function(cE){var parent=cE.__fn;parent.__fq(this);qx.lang.Array.insertBefore(parent.__fl,this,cE);return this;},insertAfter:function(bd){var parent=bd.__fn;parent.__fq(this);qx.lang.Array.insertAfter(parent.__fl,this,bd);return this;},moveTo:function(bW){var parent=this.__fn;parent.__fs(this);var bX=parent.__fl.indexOf(this);if(bX===bW){throw new Error("Could not move to same index!");}else if(bX<bW){bW--;}qx.lang.Array.removeAt(parent.__fl,bX);qx.lang.Array.insertAt(parent.__fl,this,bW);return this;},moveBefore:function(dS){var parent=this.__fn;return this.moveTo(parent.__fl.indexOf(dS));},moveAfter:function(bS){var parent=this.__fn;return this.moveTo(parent.__fl.indexOf(bS)+1);},free:function(){var parent=this.__fn;if(!parent){throw new Error("Has no parent to remove from.");}if(!parent.__fl){return;}parent.__fr(this);qx.lang.Array.remove(parent.__fl,this);return this;},getDomElement:function(){return this.__eX||null;},getNodeName:function(){return this.__eO;},setNodeName:function(name){this.__eO=name;},setRoot:function(cc){this.__eY=cc;},useMarkup:function(ce){if(this.__eX){throw new Error("Could not overwrite existing element!");}if(qx.core.Variant.isSet(cV,cP)){var cf=document.createElement(cR);}else{var cf=qx.bom.Element.getHelperElement();}cf.innerHTML=ce;this.useElement(cf.firstChild);return this.__eX;},useElement:function(cJ){if(this.__eX){throw new Error("Could not overwrite existing element!");}this.__eX=cJ;this.__eX.$$element=this.$$hash;this._copyData(true);},isFocusable:function(){var dw=this.getAttribute(de);if(dw>=1){return true;}var dv=qx.event.handler.Focus.FOCUSABLE_ELEMENTS;if(dw>=0&&dv[this.__eO]){return true;}return false;},setSelectable:qx.core.Variant.select(cV,{"webkit":function(bP){this.setAttribute(cU,bP?cS:cT);this.setStyle(dj,bP?cX:cO);},"gecko":function(bV){this.setAttribute(cU,bV?cS:cT);this.setStyle(dc,bV?dr:dh);},"default":function(dF){this.setAttribute(cU,dF?cS:cT);}}),isNativelyFocusable:function(){return !!qx.event.handler.Focus.FOCUSABLE_ELEMENTS[this.__eO];},include:function(){if(this.__fa){return;}delete this.__fa;if(this.__fn){this.__fn._scheduleChildrenUpdate();}return this;},exclude:function(){if(!this.__fa){return;}this.__fa=false;if(this.__fn){this.__fn._scheduleChildrenUpdate();}return this;},isIncluded:function(){return this.__fa===true;},show:function(){if(this.__fb){return;}if(this.__eX){qx.html.Element._visibility[this.$$hash]=this;qx.html.Element._scheduleFlush(cW);}if(this.__fn){this.__fn._scheduleChildrenUpdate();}delete this.__fb;},hide:function(){if(!this.__fb){return;}if(this.__eX){qx.html.Element._visibility[this.$$hash]=this;qx.html.Element._scheduleFlush(cW);}this.__fb=false;},isVisible:function(){return this.__fb===true;},scrollChildIntoViewX:function(ct,cu,cv){var cw=this.__eX;var cx=ct.getDomElement();if(cv!==false&&cw&&cw.offsetWidth&&cx&&cx.offsetWidth){qx.bom.element.Scroll.intoViewX(cx,cw,cu);}else{this.__fc={element:ct,align:cu};qx.html.Element._scroll[this.$$hash]=this;qx.html.Element._scheduleFlush(cW);}delete this.__fe;},scrollChildIntoViewY:function(bH,bI,bJ){var bK=this.__eX;var bL=bH.getDomElement();if(bJ!==false&&bK&&bK.offsetWidth&&bL&&bL.offsetWidth){qx.bom.element.Scroll.intoViewY(bL,bK,bI);}else{this.__fd={element:bH,align:bI};qx.html.Element._scroll[this.$$hash]=this;qx.html.Element._scheduleFlush(cW);}delete this.__ff;},scrollToX:function(x,cg){var ch=this.__eX;if(cg!==true&&ch&&ch.offsetWidth){ch.scrollLeft=x;}else{this.__fe=x;qx.html.Element._scroll[this.$$hash]=this;qx.html.Element._scheduleFlush(cW);}delete this.__fc;},getScrollX:function(){var bn=this.__eX;if(bn){return bn.scrollLeft;}return this.__fe||0;},scrollToY:function(y,t){var u=this.__eX;if(t!==true&&u&&u.offsetWidth){u.scrollTop=y;}else{this.__ff=y;qx.html.Element._scroll[this.$$hash]=this;qx.html.Element._scheduleFlush(cW);}delete this.__fd;},getScrollY:function(){var cK=this.__eX;if(cK){return cK.scrollTop;}return this.__ff||0;},disableScrolling:function(){this.enableScrolling();this.scrollToX(0);this.scrollToY(0);this.addListener(cN,this.__fu,this);},enableScrolling:function(){this.removeListener(cN,this.__fu,this);},__ft:null,__fu:function(e){if(!this.__ft){this.__ft=true;this.__eX.scrollTop=0;this.__eX.scrollLeft=0;delete this.__ft;}},getTextSelection:function(){var dT=this.__eX;if(dT){return qx.bom.Selection.get(dT);}return null;},getTextSelectionLength:function(){var bm=this.__eX;if(bm){return qx.bom.Selection.getLength(bm);}return null;},getTextSelectionStart:function(){var dU=this.__eX;if(dU){return qx.bom.Selection.getStart(dU);}return null;},getTextSelectionEnd:function(){var co=this.__eX;if(co){return qx.bom.Selection.getEnd(co);}return null;},setTextSelection:function(v,w){var z=this.__eX;if(z){qx.bom.Selection.set(z,v,w);return;}qx.html.Element.__eR[this.toHashCode()]={element:this,start:v,end:w};qx.html.Element._scheduleFlush(cW);},clearTextSelection:function(){var cd=this.__eX;if(cd){qx.bom.Selection.clear(cd);}delete qx.html.Element.__eR[this.toHashCode()];},__fv:function(bM,bN){var bO=qx.html.Element._actions;bO.push({type:bM,element:this,args:bN||[]});qx.html.Element._scheduleFlush(cW);},focus:function(){this.__fv(da);},blur:function(){this.__fv(dm);},activate:function(){this.__fv(dn);},deactivate:function(){this.__fv(dl);},capture:function(bR){this.__fv(dk,[bR!==false]);},releaseCapture:function(){this.__fv(dg);},setStyle:function(bh,bi,bj){if(!this.__eP){this.__eP={};}if(this.__eP[bh]==bi){return;}if(bi==null){delete this.__eP[bh];}else{this.__eP[bh]=bi;}if(this.__eX){if(bj){qx.bom.element.Style.set(this.__eX,bh,bi);return this;}if(!this.__fg){this.__fg={};}this.__fg[bh]=true;qx.html.Element._modified[this.$$hash]=this;qx.html.Element._scheduleFlush(cW);}return this;},setStyles:function(dx,dy){var dz=qx.bom.element.Style;if(!this.__eP){this.__eP={};}if(this.__eX){if(!this.__fg){this.__fg={};}for(var dB in dx){var dA=dx[dB];if(this.__eP[dB]==dA){continue;}if(dA==null){delete this.__eP[dB];}else{this.__eP[dB]=dA;}if(dy){dz.set(this.__eX,dB,dA);continue;}this.__fg[dB]=true;}qx.html.Element._modified[this.$$hash]=this;qx.html.Element._scheduleFlush(cW);}else{for(var dB in dx){var dA=dx[dB];if(this.__eP[dB]==dA){continue;}if(dA==null){delete this.__eP[dB];}else{this.__eP[dB]=dA;}}}return this;},removeStyle:function(dJ,dK){this.setStyle(dJ,null,dK);},getStyle:function(dR){return this.__eP?this.__eP[dR]:null;},getAllStyles:function(){return this.__eP||null;},setAttribute:function(dN,dO,dP){if(!this.__eQ){this.__eQ={};}if(this.__eQ[dN]==dO){return;}if(dO==null){delete this.__eQ[dN];}else{this.__eQ[dN]=dO;}if(this.__eX){if(dP){qx.bom.element.Attribute.set(this.__eX,dN,dO);return this;}if(!this.__fh){this.__fh={};}this.__fh[dN]=true;qx.html.Element._modified[this.$$hash]=this;qx.html.Element._scheduleFlush(cW);}return this;},setAttributes:function(be,bf){for(var bg in be){this.setAttribute(bg,be[bg],bf);}return this;},removeAttribute:function(cA,cB){this.setAttribute(cA,null,cB);},getAttribute:function(cL){return this.__eQ?this.__eQ[cL]:null;},_applyProperty:function(name,s){},_setProperty:function(dG,dH,dI){if(!this.__fj){this.__fj={};}if(this.__fj[dG]==dH){return;}if(dH==null){delete this.__fj[dG];}else{this.__fj[dG]=dH;}if(this.__eX){if(dI){this._applyProperty(dG,dH);return this;}if(!this.__fi){this.__fi={};}this.__fi[dG]=true;qx.html.Element._modified[this.$$hash]=this;qx.html.Element._scheduleFlush(cW);}return this;},_removeProperty:function(a,b){this._setProperty(a,null,b);},_getProperty:function(bo){var bp=this.__fj;if(!bp){return null;}var bq=bp[bo];return bq==null?null:bq;},addListener:function(dV,dW,self,dX){var dY;if(this.$$disposed){return null;}{};if(this.__eX){return qx.event.Registration.addListener(this.__eX,dV,dW,self,dX);}if(!this.__fk){this.__fk={};}if(dX==null){dX=false;}var ea=qx.event.Manager.getNextUniqueId();var eb=dV+(dX?dp:dd)+ea;this.__fk[eb]={type:dV,listener:dW,self:self,capture:dX,unique:ea};return eb;},removeListener:function(A,B,self,C){var D;if(this.$$disposed){return null;}{};if(this.__eX){qx.event.Registration.removeListener(this.__eX,A,B,self,C);}else{var F=this.__fk;var E;if(C==null){C=false;}for(var G in F){E=F[G];if(E.listener===B&&E.self===self&&E.capture===C&&E.type===A){delete F[G];break;}}}return this;},removeListenerById:function(cp){if(this.$$disposed){return null;}if(this.__eX){qx.event.Registration.removeListenerById(this.__eX,cp);}else{delete this.__fk[cp];}return this;},hasListener:function(ci,cj){if(this.$$disposed){return false;}if(this.__eX){return qx.event.Registration.hasListener(this.__eX,ci,cj);}var cl=this.__fk;var ck;if(cj==null){cj=false;}for(var cm in cl){ck=cl[cm];if(ck.capture===cj&&ck.type===ci){return true;}}return false;}},defer:function(dQ){dQ.__fw=new qx.util.DeferredCall(dQ.flush,dQ);},destruct:function(){var r=this.__eX;if(r){qx.event.Registration.getManager(r).removeAllListeners(r);r.$$element=cQ;}if(!qx.core.ObjectRegistry.inShutDown){var parent=this.__fn;if(parent&&!parent.$$disposed){parent.remove(this);}}this._disposeArray(di);this.__eQ=this.__eP=this.__fk=this.__fj=this.__fh=this.__fg=this.__fi=this.__eX=this.__fn=this.__fc=this.__fd=null;}});})();(function(){var f='ie',d="qx.ui.core.queue.Manager",c="useraction";qx.Class.define(d,{statics:{__fx:false,__fy:{},__fz:0,MAX_RETRIES:10,scheduleFlush:function(g){var self=qx.ui.core.queue.Manager;self.__fy[g]=true;if(!self.__fx){self.__fC.schedule();self.__fx=true;}},flush:function(){var self=qx.ui.core.queue.Manager;if(self.__fA){return;}self.__fA=true;self.__fC.cancel();var b=self.__fy;self.__fB(function(){while(b.visibility||b.widget||b.appearance||b.layout||b.element){if(b.widget){delete b.widget;qx.ui.core.queue.Widget.flush();}if(b.visibility){delete b.visibility;qx.ui.core.queue.Visibility.flush();}if(b.appearance){delete b.appearance;qx.ui.core.queue.Appearance.flush();}if(b.widget||b.visibility||b.appearance){continue;}if(b.layout){delete b.layout;qx.ui.core.queue.Layout.flush();}if(b.widget||b.visibility||b.appearance||b.layout){continue;}if(b.element){delete b.element;qx.html.Element.flush();}}},function(){self.__fx=false;});self.__fB(function(){if(b.dispose){delete b.dispose;qx.ui.core.queue.Dispose.flush();}},function(){self.__fA=false;});self.__fz=0;},__fB:function(h,i){var self=qx.ui.core.queue.Manager;try{h();}catch(e){{};self.__fx=false;self.__fA=false;self.__fz+=1;if(qx.bom.client.Browser.NAME==f&&qx.bom.client.Browser.VERSION<=7){i();}if(self.__fz<=self.MAX_RETRIES){self.scheduleFlush();}else{throw new Error("Fatal Error: Flush terminated "+(self.__fz-1)+" times in a row"+" due to exceptions in user code. The application has to be reloaded!");}throw e;}finally{i();}}},defer:function(a){a.__fC=new qx.util.DeferredCall(a.flush);qx.html.Element._scheduleFlush=a.scheduleFlush;qx.event.Registration.addListener(window,c,a.flush);}});})();(function(){var f="CSS1Compat",d="qx.bom.client.Feature",c="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",b="pointerEvents",a="label";qx.Class.define(d,{statics:{STANDARD_MODE:false,QUIRKS_MODE:false,CONTENT_BOX:false,BORDER_BOX:false,SVG:false,CANVAS:!!window.CanvasRenderingContext2D,VML:false,XPATH:!!document.evaluate,AIR:navigator.userAgent.indexOf("adobeair")!==-1,GEARS:!!(window.google&&window.google.gears),SSL:window.location.protocol==="https:",ECMA_OBJECT_COUNT:(({}).__count__==0),CSS_POINTER_EVENTS:false,XUL:false,CSS_TEXT_OVERFLOW:("textOverflow" in document.documentElement.style||"OTextOverflow" in document.documentElement.style),HTML5_CLASSLIST:!!(document.documentElement.classList&&qx.Bootstrap.getClass(document.documentElement.classList)==="DOMTokenList"),__fD:function(){this.QUIRKS_MODE=this.__fE();this.STANDARD_MODE=!this.QUIRKS_MODE;this.CONTENT_BOX=!qx.bom.client.Engine.MSHTML||this.STANDARD_MODE;this.BORDER_BOX=!this.CONTENT_BOX;this.SVG=document.implementation&&document.implementation.hasFeature&&(document.implementation.hasFeature("org.w3c.dom.svg","1.0")||document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1"));this.VML=qx.bom.client.Engine.MSHTML;try{document.createElementNS(c,a);this.XUL=true;}catch(e){this.XUL=false;}if(b in document.documentElement.style){if(qx.bom.client.Engine.OPERA){this.CSS_POINTER_EVENTS=false;}else{this.CSS_POINTER_EVENTS=true;}}},__fE:function(){if(qx.bom.client.Engine.MSHTML&&qx.bom.client.Engine.VERSION>=8){return qx.bom.client.Engine.DOCUMENT_MODE===5;}else{return document.compatMode!==f;}}},defer:function(g){g.__fD();}});})();(function(){var h="qx.lang.Object";qx.Class.define(h,{statics:{empty:function(j){{};for(var k in j){if(j.hasOwnProperty(k)){delete j[k];}}},isEmpty:(qx.bom.client.Feature.ECMA_OBJECT_COUNT)?function(q){{};return q.__count__===0;}:function(o){{};for(var p in o){return false;}return true;},hasMinLength:(qx.bom.client.Feature.ECMA_OBJECT_COUNT)?function(u,v){{};return u.__count__>=v;}:function(a,b){{};if(b<=0){return true;}var length=0;for(var c in a){if((++length)>=b){return true;}}return false;},getLength:qx.Bootstrap.objectGetLength,getKeys:qx.Bootstrap.getKeys,getKeysAsString:qx.Bootstrap.getKeysAsString,getValues:function(E){{};var G=[];var F=this.getKeys(E);for(var i=0,l=F.length;i<l;i++){G.push(E[F[i]]);}return G;},mergeWith:qx.Bootstrap.objectMergeWith,carefullyMergeWith:function(d,e){{};return qx.lang.Object.mergeWith(d,e,false);},merge:function(w,x){{};var y=arguments.length;for(var i=1;i<y;i++){qx.lang.Object.mergeWith(w,arguments[i]);}return w;},clone:function(B){{};var C={};for(var D in B){C[D]=B[D];}return C;},invert:function(H){{};var I={};for(var J in H){I[H[J].toString()]=J;}return I;},getKeyFromValue:function(r,s){{};for(var t in r){if(r.hasOwnProperty(t)&&r[t]===s){return t;}}return null;},contains:function(m,n){{};return this.getKeyFromValue(m,n)!==null;},select:function(z,A){{};return A[z];},fromArray:function(f){{};var g={};for(var i=0,l=f.length;i<l;i++){{};g[f[i].toString()]=true;}return g;}}});})();(function(){var c="abstract",b="qx.event.dispatch.AbstractBubbling";qx.Class.define(b,{extend:qx.core.Object,implement:qx.event.IEventDispatcher,type:c,construct:function(a){this._manager=a;},members:{_getParent:function(d){throw new Error("Missing implementation");},canDispatchEvent:function(e,event,f){return event.getBubbles();},dispatchEvent:function(g,event,h){var parent=g;var s=this._manager;var p,w;var n;var r,u;var t;var v=[];p=s.getListeners(g,h,true);w=s.getListeners(g,h,false);if(p){v.push(p);}if(w){v.push(w);}var parent=this._getParent(g);var l=[];var k=[];var m=[];var q=[];while(parent!=null){p=s.getListeners(parent,h,true);if(p){m.push(p);q.push(parent);}w=s.getListeners(parent,h,false);if(w){l.push(w);k.push(parent);}parent=this._getParent(parent);}event.setEventPhase(qx.event.type.Event.CAPTURING_PHASE);for(var i=m.length-1;i>=0;i--){t=q[i];event.setCurrentTarget(t);n=m[i];for(var j=0,o=n.length;j<o;j++){r=n[j];u=r.context||t;r.handler.call(u,event);}if(event.getPropagationStopped()){return;}}event.setEventPhase(qx.event.type.Event.AT_TARGET);event.setCurrentTarget(g);for(var i=0,x=v.length;i<x;i++){n=v[i];for(var j=0,o=n.length;j<o;j++){r=n[j];u=r.context||g;r.handler.call(u,event);}if(event.getPropagationStopped()){return;}}event.setEventPhase(qx.event.type.Event.BUBBLING_PHASE);for(var i=0,x=l.length;i<x;i++){t=k[i];event.setCurrentTarget(t);n=l[i];for(var j=0,o=n.length;j<o;j++){r=n[j];u=r.context||t;r.handler.call(u,event);}if(event.getPropagationStopped()){return;}}}}});})();(function(){var b="qx.event.dispatch.DomBubbling";qx.Class.define(b,{extend:qx.event.dispatch.AbstractBubbling,statics:{PRIORITY:qx.event.Registration.PRIORITY_NORMAL},members:{_getParent:function(a){return a.parentNode;},canDispatchEvent:function(d,event,e){return d.nodeType!==undefined&&event.getBubbles();}},defer:function(c){qx.event.Registration.addDispatcher(c);}});})();(function(){var o="iPod",n="Win32",m="",l="Win64",k="Linux",j="BSD",i="Macintosh",h="iPhone",g="Windows",f="qx.bom.client.Platform",c="iPad",e="X11",d="MacIntel",b="MacPPC";qx.Class.define(f,{statics:{NAME:"",WIN:false,MAC:false,UNIX:false,UNKNOWN_PLATFORM:false,__fF:function(){var p=navigator.platform;if(p==null||p===m){p=navigator.userAgent;}if(p.indexOf(g)!=-1||p.indexOf(n)!=-1||p.indexOf(l)!=-1){this.WIN=true;this.NAME="win";}else if(p.indexOf(i)!=-1||p.indexOf(b)!=-1||p.indexOf(d)!=-1||p.indexOf(o)!=-1||p.indexOf(h)!=-1||p.indexOf(c)!=-1){this.MAC=true;this.NAME="mac";}else if(p.indexOf(e)!=-1||p.indexOf(k)!=-1||p.indexOf(j)!=-1){this.UNIX=true;this.NAME="unix";}else{this.UNKNOWN_PLATFORM=true;this.WIN=true;this.NAME="win";}}},defer:function(a){a.__fF();}});})();(function(){var E="keydown",D="qx.client",C="keypress",B="NumLock",A="keyup",z="Enter",y="0",x="9",w="-",v="PageUp",bM="+",bL="PrintScreen",bK="gecko",bJ="A",bI="Z",bH="Left",bG="F5",bF="Down",bE="Up",bD="F11",L="F6",M="useraction",J="F3",K="keyinput",H="Insert",I="F8",F="End",G="/",T="Delete",U="*",bh="cmd",bd="F1",bp="F4",bk="Home",bz="F2",bu="F12",Y="PageDown",bC="F7",bB="Win",bA="F9",X="F10",bb="Right",bc="text",bf="Escape",bi="webkit",bl="5",br="3",bw="Meta",N="7",O="CapsLock",ba="input",bo="Control",bn="Space",bm="Tab",bt="Shift",bs="Pause",bj="Unidentified",bq="qx.event.handler.Keyboard",s="mshtml|webkit",bv="6",P="off",Q="Apps",be="4",t="Alt",u="mshtml",W="2",R="Scroll",S="1",V="8",bg="autoComplete",by=",",bx="Backspace";qx.Class.define(bq,{extend:qx.core.Object,implement:qx.event.IEventHandler,construct:function(ct){qx.core.Object.call(this);this.__fG=ct;this.__fH=ct.getWindow();if(qx.core.Variant.isSet(D,bK)){this.__fI=this.__fH;}else{this.__fI=this.__fH.document.documentElement;}this.__fJ={};this._initKeyObserver();},statics:{PRIORITY:qx.event.Registration.PRIORITY_NORMAL,SUPPORTED_TYPES:{keyup:1,keydown:1,keypress:1,keyinput:1},TARGET_CHECK:qx.event.IEventHandler.TARGET_DOMNODE,IGNORE_CAN_HANDLE:true,isValidKeyIdentifier:function(cI){if(this._identifierToKeyCodeMap[cI]){return true;}if(cI.length!=1){return false;}if(cI>=y&&cI<=x){return true;}if(cI>=bJ&&cI<=bI){return true;}switch(cI){case bM:case w:case U:case G:return true;default:return false;}}},members:{__fK:null,__fG:null,__fH:null,__fI:null,__fJ:null,__fL:null,__fM:null,__fN:null,canHandleEvent:function(bN,bO){},registerEvent:function(k,l,m){},unregisterEvent:function(cm,cn,co){},_fireInputEvent:function(bS,bT){var bU=this.__fO();if(bU&&bU.offsetWidth!=0){var event=qx.event.Registration.createEvent(K,qx.event.type.KeyInput,[bS,bU,bT]);this.__fG.dispatchEvent(bU,event);}if(this.__fH){qx.event.Registration.fireEvent(this.__fH,M,qx.event.type.Data,[K]);}},_fireSequenceEvent:function(cD,cE,cF){var cG=this.__fO();var cH=cD.keyCode;var event=qx.event.Registration.createEvent(cE,qx.event.type.KeySequence,[cD,cG,cF]);this.__fG.dispatchEvent(cG,event);if(qx.core.Variant.isSet(D,s)){if(cE==E&&event.getDefaultPrevented()){if(!this._isNonPrintableKeyCode(cH)&&!this._emulateKeyPress[cH]){this._fireSequenceEvent(cD,C,cF);}}}if(this.__fH){qx.event.Registration.fireEvent(this.__fH,M,qx.event.type.Data,[cE]);}},__fO:function(){var cu=this.__fG.getHandler(qx.event.handler.Focus);var cv=cu.getActive();if(!cv||cv.offsetWidth==0){cv=cu.getFocus();}if(!cv||cv.offsetWidth==0){cv=this.__fG.getWindow().document.body;}return cv;},_initKeyObserver:function(){this.__fK=qx.lang.Function.listener(this.__fP,this);this.__fN=qx.lang.Function.listener(this.__fR,this);var Event=qx.bom.Event;Event.addNativeListener(this.__fI,A,this.__fK);Event.addNativeListener(this.__fI,E,this.__fK);Event.addNativeListener(this.__fI,C,this.__fN);},_stopKeyObserver:function(){var Event=qx.bom.Event;Event.removeNativeListener(this.__fI,A,this.__fK);Event.removeNativeListener(this.__fI,E,this.__fK);Event.removeNativeListener(this.__fI,C,this.__fN);for(var cK in (this.__fM||{})){var cJ=this.__fM[cK];Event.removeNativeListener(cJ.target,C,cJ.callback);}delete (this.__fM);},__fP:qx.event.GlobalError.observeMethod(qx.core.Variant.select(D,{"mshtml":function(cp){cp=window.event||cp;var cs=cp.keyCode;var cq=0;var cr=cp.type;if(!(this.__fJ[cs]==E&&cr==E)){this._idealKeyHandler(cs,cq,cr,cp);}if(cr==E){if(this._isNonPrintableKeyCode(cs)||this._emulateKeyPress[cs]){this._idealKeyHandler(cs,cq,C,cp);}}this.__fJ[cs]=cr;},"gecko":function(ch){var cl=this._keyCodeFix[ch.keyCode]||ch.keyCode;var cj=0;var ck=ch.type;if(qx.bom.client.Platform.WIN){var ci=cl?this._keyCodeToIdentifier(cl):this._charCodeToIdentifier(cj);if(!(this.__fJ[ci]==E&&ck==E)){this._idealKeyHandler(cl,cj,ck,ch);}this.__fJ[ci]=ck;}else{this._idealKeyHandler(cl,cj,ck,ch);}this.__fQ(ch.target,ck,cl);},"webkit":function(cb){var ce=0;var cc=0;var cd=cb.type;if(qx.bom.client.Engine.VERSION<525.13){if(cd==A||cd==E){ce=this._charCode2KeyCode[cb.charCode]||cb.keyCode;}else{if(this._charCode2KeyCode[cb.charCode]){ce=this._charCode2KeyCode[cb.charCode];}else{cc=cb.charCode;}}this._idealKeyHandler(ce,cc,cd,cb);}else{ce=cb.keyCode;this._idealKeyHandler(ce,cc,cd,cb);if(cd==E){if(this._isNonPrintableKeyCode(ce)||this._emulateKeyPress[ce]){this._idealKeyHandler(ce,cc,C,cb);}}this.__fJ[ce]=cd;}},"opera":function(cg){this.__fL=cg.keyCode;this._idealKeyHandler(cg.keyCode,0,cg.type,cg);}})),__fQ:qx.core.Variant.select(D,{"gecko":function(n,o,p){if(o===E&&(p==33||p==34||p==38||p==40)&&n.type==bc&&n.tagName.toLowerCase()===ba&&n.getAttribute(bg)!==P){if(!this.__fM){this.__fM={};}var r=qx.core.ObjectRegistry.toHashCode(n);if(this.__fM[r]){return;}var self=this;this.__fM[r]={target:n,callback:function(e){qx.bom.Event.stopPropagation(e);self.__fR(e);}};var q=qx.event.GlobalError.observeMethod(this.__fM[r].callback);qx.bom.Event.addNativeListener(n,C,q);}},"default":null}),__fR:qx.event.GlobalError.observeMethod(qx.core.Variant.select(D,{"mshtml":function(j){j=window.event||j;if(this._charCode2KeyCode[j.keyCode]){this._idealKeyHandler(this._charCode2KeyCode[j.keyCode],0,j.type,j);}else{this._idealKeyHandler(0,j.keyCode,j.type,j);}},"gecko":function(bW){var ca=this._keyCodeFix[bW.keyCode]||bW.keyCode;var bX=bW.charCode;var bY=bW.type;this._idealKeyHandler(ca,bX,bY,bW);},"webkit":function(f){if(qx.bom.client.Engine.VERSION<525.13){var i=0;var g=0;var h=f.type;if(h==A||h==E){i=this._charCode2KeyCode[f.charCode]||f.keyCode;}else{if(this._charCode2KeyCode[f.charCode]){i=this._charCode2KeyCode[f.charCode];}else{g=f.charCode;}}this._idealKeyHandler(i,g,h,f);}else{if(this._charCode2KeyCode[f.keyCode]){this._idealKeyHandler(this._charCode2KeyCode[f.keyCode],0,f.type,f);}else{this._idealKeyHandler(0,f.keyCode,f.type,f);}}},"opera":function(b){var d=b.keyCode;var c=b.type;if(d!=this.__fL){this._idealKeyHandler(0,this.__fL,c,b);}else{if(this._keyCodeToIdentifierMap[b.keyCode]){this._idealKeyHandler(b.keyCode,0,b.type,b);}else{this._idealKeyHandler(0,b.keyCode,b.type,b);}}}})),_idealKeyHandler:function(cw,cx,cy,cz){var cA;if(cw||(!cw&&!cx)){cA=this._keyCodeToIdentifier(cw);this._fireSequenceEvent(cz,cy,cA);}else{cA=this._charCodeToIdentifier(cx);this._fireSequenceEvent(cz,C,cA);this._fireInputEvent(cz,cx);}},_specialCharCodeMap:{8:bx,9:bm,13:z,27:bf,32:bn},_emulateKeyPress:qx.core.Variant.select(D,{"mshtml":{8:true,9:true},"webkit":{8:true,9:true,27:true},"default":{}}),_keyCodeToIdentifierMap:{16:bt,17:bo,18:t,20:O,224:bw,37:bH,38:bE,39:bb,40:bF,33:v,34:Y,35:F,36:bk,45:H,46:T,112:bd,113:bz,114:J,115:bp,116:bG,117:L,118:bC,119:I,120:bA,121:X,122:bD,123:bu,144:B,44:bL,145:R,19:bs,91:qx.bom.client.Platform.MAC?bh:bB,92:bB,93:qx.bom.client.Platform.MAC?bh:Q},_numpadToCharCode:{96:y.charCodeAt(0),97:S.charCodeAt(0),98:W.charCodeAt(0),99:br.charCodeAt(0),100:be.charCodeAt(0),101:bl.charCodeAt(0),102:bv.charCodeAt(0),103:N.charCodeAt(0),104:V.charCodeAt(0),105:x.charCodeAt(0),106:U.charCodeAt(0),107:bM.charCodeAt(0),109:w.charCodeAt(0),110:by.charCodeAt(0),111:G.charCodeAt(0)},_charCodeA:bJ.charCodeAt(0),_charCodeZ:bI.charCodeAt(0),_charCode0:y.charCodeAt(0),_charCode9:x.charCodeAt(0),_isNonPrintableKeyCode:function(cf){return this._keyCodeToIdentifierMap[cf]?true:false;},_isIdentifiableKeyCode:function(bV){if(bV>=this._charCodeA&&bV<=this._charCodeZ){return true;}if(bV>=this._charCode0&&bV<=this._charCode9){return true;}if(this._specialCharCodeMap[bV]){return true;}if(this._numpadToCharCode[bV]){return true;}if(this._isNonPrintableKeyCode(bV)){return true;}return false;},_keyCodeToIdentifier:function(cB){if(this._isIdentifiableKeyCode(cB)){var cC=this._numpadToCharCode[cB];if(cC){return String.fromCharCode(cC);}return (this._keyCodeToIdentifierMap[cB]||this._specialCharCodeMap[cB]||String.fromCharCode(cB));}else{return bj;}},_charCodeToIdentifier:function(a){return this._specialCharCodeMap[a]||String.fromCharCode(a).toUpperCase();},_identifierToKeyCode:function(cL){return qx.event.handler.Keyboard._identifierToKeyCodeMap[cL]||cL.charCodeAt(0);}},destruct:function(){this._stopKeyObserver();this.__fL=this.__fG=this.__fH=this.__fI=this.__fJ=null;},defer:function(bP,bQ){qx.event.Registration.addHandler(bP);if(!bP._identifierToKeyCodeMap){bP._identifierToKeyCodeMap={};for(var bR in bQ._keyCodeToIdentifierMap){bP._identifierToKeyCodeMap[bQ._keyCodeToIdentifierMap[bR]]=parseInt(bR,10);}for(var bR in bQ._specialCharCodeMap){bP._identifierToKeyCodeMap[bQ._specialCharCodeMap[bR]]=parseInt(bR,10);}}if(qx.core.Variant.isSet(D,u)){bQ._charCode2KeyCode={13:13,27:27};}else if(qx.core.Variant.isSet(D,bK)){bQ._keyCodeFix={12:bQ._identifierToKeyCode(B)};}else if(qx.core.Variant.isSet(D,bi)){if(qx.bom.client.Engine.VERSION<525.13){bQ._charCode2KeyCode={63289:bQ._identifierToKeyCode(B),63276:bQ._identifierToKeyCode(v),63277:bQ._identifierToKeyCode(Y),63275:bQ._identifierToKeyCode(F),63273:bQ._identifierToKeyCode(bk),63234:bQ._identifierToKeyCode(bH),63232:bQ._identifierToKeyCode(bE),63235:bQ._identifierToKeyCode(bb),63233:bQ._identifierToKeyCode(bF),63272:bQ._identifierToKeyCode(T),63302:bQ._identifierToKeyCode(H),63236:bQ._identifierToKeyCode(bd),63237:bQ._identifierToKeyCode(bz),63238:bQ._identifierToKeyCode(J),63239:bQ._identifierToKeyCode(bp),63240:bQ._identifierToKeyCode(bG),63241:bQ._identifierToKeyCode(L),63242:bQ._identifierToKeyCode(bC),63243:bQ._identifierToKeyCode(I),63244:bQ._identifierToKeyCode(bA),63245:bQ._identifierToKeyCode(X),63246:bQ._identifierToKeyCode(bD),63247:bQ._identifierToKeyCode(bu),63248:bQ._identifierToKeyCode(bL),3:bQ._identifierToKeyCode(z),12:bQ._identifierToKeyCode(B),13:bQ._identifierToKeyCode(z)};}else{bQ._charCode2KeyCode={13:13,27:27};}}}});})();(function(){var j="win98",i="osx2",h="osx0",g="osx4",f="win95",e="win2000",d="osx1",c="osx5",b="osx3",a="Windows NT 5.01",H=")",G="winxp",F="freebsd",E="sunos",D="SV1",C="|",B="nintendods",A="winnt4",z="wince",y="winme",q="os9",r="\.",o="osx",p="linux",m="netbsd",n="winvista",k="openbsd",l="(",s="win2003",t="symbian",v="win7",u="g",x="qx.bom.client.System",w=" Mobile/";qx.Class.define(x,{statics:{NAME:"",SP1:false,SP2:false,WIN95:false,WIN98:false,WINME:false,WINNT4:false,WIN2000:false,WINXP:false,WIN2003:false,WINVISTA:false,WIN7:false,WINCE:false,LINUX:false,SUNOS:false,FREEBSD:false,NETBSD:false,OPENBSD:false,OSX:false,OS9:false,SYMBIAN:false,NINTENDODS:false,PSP:false,IPHONE:false,UNKNOWN_SYSTEM:false,__fS:{"Windows NT 6.1":v,"Windows NT 6.0":n,"Windows NT 5.2":s,"Windows NT 5.1":G,"Windows NT 5.0":e,"Windows 2000":e,"Windows NT 4.0":A,"Win 9x 4.90":y,"Windows CE":z,"Windows 98":j,"Win98":j,"Windows 95":f,"Win95":f,"Linux":p,"FreeBSD":F,"NetBSD":m,"OpenBSD":k,"SunOS":E,"Symbian System":t,"Nitro":B,"PSP":"sonypsp","Mac OS X 10_5":c,"Mac OS X 10.5":c,"Mac OS X 10_4":g,"Mac OS X 10.4":g,"Mac OS X 10_3":b,"Mac OS X 10.3":b,"Mac OS X 10_2":i,"Mac OS X 10.2":i,"Mac OS X 10_1":d,"Mac OS X 10.1":d,"Mac OS X 10_0":h,"Mac OS X 10.0":h,"Mac OS X":o,"Mac OS 9":q},__fT:function(){var K=navigator.userAgent;var J=[];for(var I in this.__fS){J.push(I);}var L=new RegExp(l+J.join(C).replace(/\./g,r)+H,u);if(!L.test(K)){this.UNKNOWN_SYSTEM=true;if(!qx.bom.client.Platform.UNKNOWN_PLATFORM){if(qx.bom.client.Platform.UNIX){this.NAME="linux";this.LINUX=true;}else if(qx.bom.client.Platform.MAC){this.NAME="osx5";this.OSX=true;}else{this.NAME="winxp";this.WINXP=true;}}else{this.NAME="winxp";this.WINXP=true;}return;}if(qx.bom.client.Engine.WEBKIT&&RegExp(w).test(navigator.userAgent)){this.IPHONE=true;this.NAME="iphone";}else{this.NAME=this.__fS[RegExp.$1];this[this.NAME.toUpperCase()]=true;if(qx.bom.client.Platform.WIN){if(K.indexOf(a)!==-1){this.SP1=true;}else if(qx.bom.client.Engine.MSHTML&&K.indexOf(D)!==-1){this.SP2=true;}}}}},defer:function(M){M.__fT();}});})();(function(){var t="qx.client",s="mouseup",r="click",q="mousedown",p="contextmenu",o="mousewheel",n="dblclick",m="mshtml",l="mouseover",k="mouseout",f="DOMMouseScroll",j="mousemove",i="on",e="mshtml|webkit|opera",d="useraction",h="gecko|webkit",g="qx.event.handler.Mouse";qx.Class.define(g,{extend:qx.core.Object,implement:qx.event.IEventHandler,construct:function(u){qx.core.Object.call(this);this.__fU=u;this.__fV=u.getWindow();this.__fW=this.__fV.document;this._initButtonObserver();this._initMoveObserver();this._initWheelObserver();},statics:{PRIORITY:qx.event.Registration.PRIORITY_NORMAL,SUPPORTED_TYPES:{mousemove:1,mouseover:1,mouseout:1,mousedown:1,mouseup:1,click:1,dblclick:1,contextmenu:1,mousewheel:1},TARGET_CHECK:qx.event.IEventHandler.TARGET_DOMNODE,IGNORE_CAN_HANDLE:true},members:{__fX:null,__fY:null,__ga:null,__gb:null,__gc:null,__fU:null,__fV:null,__fW:null,canHandleEvent:function(D,E){},registerEvent:qx.bom.client.System.IPHONE?function(W,X,Y){W[i+X]=qx.lang.Function.returnNull;}:qx.lang.Function.returnNull,unregisterEvent:qx.bom.client.System.IPHONE?function(M,N,O){M[i+N]=undefined;}:qx.lang.Function.returnNull,__gd:function(J,K,L){if(!L){L=J.target||J.srcElement;}if(L&&L.nodeType){qx.event.Registration.fireEvent(L,K||J.type,K==o?qx.event.type.MouseWheel:qx.event.type.Mouse,[J,L,null,true,true]);}qx.event.Registration.fireEvent(this.__fV,d,qx.event.type.Data,[K||J.type]);},_initButtonObserver:function(){this.__fX=qx.lang.Function.listener(this._onButtonEvent,this);var Event=qx.bom.Event;Event.addNativeListener(this.__fW,q,this.__fX);Event.addNativeListener(this.__fW,s,this.__fX);Event.addNativeListener(this.__fW,r,this.__fX);Event.addNativeListener(this.__fW,n,this.__fX);Event.addNativeListener(this.__fW,p,this.__fX);},_initMoveObserver:function(){this.__fY=qx.lang.Function.listener(this._onMoveEvent,this);var Event=qx.bom.Event;Event.addNativeListener(this.__fW,j,this.__fY);Event.addNativeListener(this.__fW,l,this.__fY);Event.addNativeListener(this.__fW,k,this.__fY);},_initWheelObserver:function(){this.__ga=qx.lang.Function.listener(this._onWheelEvent,this);var Event=qx.bom.Event;var y=qx.core.Variant.isSet(t,e)?o:f;var z=qx.core.Variant.isSet(t,m)?this.__fW:this.__fV;Event.addNativeListener(z,y,this.__ga);},_stopButtonObserver:function(){var Event=qx.bom.Event;Event.removeNativeListener(this.__fW,q,this.__fX);Event.removeNativeListener(this.__fW,s,this.__fX);Event.removeNativeListener(this.__fW,r,this.__fX);Event.removeNativeListener(this.__fW,n,this.__fX);Event.removeNativeListener(this.__fW,p,this.__fX);},_stopMoveObserver:function(){var Event=qx.bom.Event;Event.removeNativeListener(this.__fW,j,this.__fY);Event.removeNativeListener(this.__fW,l,this.__fY);Event.removeNativeListener(this.__fW,k,this.__fY);},_stopWheelObserver:function(){var Event=qx.bom.Event;var A=qx.core.Variant.isSet(t,e)?o:f;var B=qx.core.Variant.isSet(t,m)?this.__fW:this.__fV;Event.removeNativeListener(B,A,this.__ga);},_onMoveEvent:qx.event.GlobalError.observeMethod(function(C){this.__gd(C);}),_onButtonEvent:qx.event.GlobalError.observeMethod(function(P){var Q=P.type;var R=P.target||P.srcElement;if(qx.core.Variant.isSet(t,h)){if(R&&R.nodeType==3){R=R.parentNode;}}if(this.__ge){this.__ge(P,Q,R);}if(this.__gg){this.__gg(P,Q,R);}this.__gd(P,Q,R);if(this.__gf){this.__gf(P,Q,R);}if(this.__gh){this.__gh(P,Q,R);}this.__gb=Q;}),_onWheelEvent:qx.event.GlobalError.observeMethod(function(S){this.__gd(S,o);}),__ge:qx.core.Variant.select(t,{"webkit":function(a,b,c){if(qx.bom.client.Engine.VERSION<530){if(b==p){this.__gd(a,s,c);}}},"default":null}),__gf:qx.core.Variant.select(t,{"opera":function(v,w,x){if(w==s&&v.button==2){this.__gd(v,p,x);}},"default":null}),__gg:qx.core.Variant.select(t,{"mshtml":function(T,U,V){if(U==s&&this.__gb==r){this.__gd(T,q,V);}else if(U==n){this.__gd(T,r,V);}},"default":null}),__gh:qx.core.Variant.select(t,{"mshtml":null,"default":function(F,G,H){switch(G){case q:this.__gc=H;break;case s:if(H!==this.__gc){var I=qx.dom.Hierarchy.getCommonParent(H,this.__gc);this.__gd(F,r,I);}}}})},destruct:function(){this._stopButtonObserver();this._stopMoveObserver();this._stopWheelObserver();this.__fU=this.__fV=this.__fW=this.__gc=null;},defer:function(ba){qx.event.Registration.addHandler(ba);}});})();(function(){var g="qx.event.handler.Capture";qx.Class.define(g,{extend:qx.core.Object,implement:qx.event.IEventHandler,statics:{PRIORITY:qx.event.Registration.PRIORITY_NORMAL,SUPPORTED_TYPES:{capture:true,losecapture:true},TARGET_CHECK:qx.event.IEventHandler.TARGET_DOMNODE,IGNORE_CAN_HANDLE:true},members:{canHandleEvent:function(h,i){},registerEvent:function(a,b,c){},unregisterEvent:function(d,e,f){}},defer:function(j){qx.event.Registration.addHandler(j);}});})();(function(){var t="alias",s="copy",r="blur",q="mouseout",p="keydown",o="Ctrl",n="Shift",m="mousemove",l="move",k="mouseover",J="Alt",I="keyup",H="mouseup",G="dragend",F="on",E="mousedown",D="qxDraggable",C="drag",B="drop",A="qxDroppable",y="qx.event.handler.DragDrop",z="droprequest",w="dragstart",x="dragchange",u="dragleave",v="dragover";qx.Class.define(y,{extend:qx.core.Object,implement:qx.event.IEventHandler,construct:function(bb){qx.core.Object.call(this);this.__gi=bb;this.__gj=bb.getWindow().document.documentElement;this.__gi.addListener(this.__gj,E,this._onMouseDown,this);this.__gv();},statics:{PRIORITY:qx.event.Registration.PRIORITY_NORMAL,SUPPORTED_TYPES:{dragstart:1,dragend:1,dragover:1,dragleave:1,drop:1,drag:1,dragchange:1,droprequest:1},IGNORE_CAN_HANDLE:true},members:{__gi:null,__gj:null,__gk:null,__gl:null,__gm:null,__gn:null,__go:null,__gp:null,__gq:null,__gr:null,__gs:false,__gt:0,__gu:0,canHandleEvent:function(M,N){},registerEvent:function(d,f,g){},unregisterEvent:function(T,U,V){},addType:function(R){this.__gm[R]=true;},addAction:function(W){this.__gn[W]=true;},supportsType:function(Q){return !!this.__gm[Q];},supportsAction:function(i){return !!this.__gn[i];},getData:function(j){if(!this.__gC||!this.__gk){throw new Error("This method must not be used outside the drop event listener!");}if(!this.__gm[j]){throw new Error("Unsupported data type: "+j+"!");}if(!this.__gp[j]){this.__gq=j;this.__gx(z,this.__gl,this.__gk,false);}if(!this.__gp[j]){throw new Error("Please use a droprequest listener to the drag source to fill the manager with data!");}return this.__gp[j]||null;},getCurrentAction:function(){return this.__gr;},addData:function(K,L){this.__gp[K]=L;},getCurrentType:function(){return this.__gq;},isSessionActive:function(){return this.__gs;},__gv:function(){this.__gm={};this.__gn={};this.__go={};this.__gp={};},__gw:function(){if(this.__gl==null){return;}var c=this.__gn;var a=this.__go;var b=null;if(this.__gC){if(a.Shift&&a.Ctrl&&c.alias){b=t;}else if(a.Shift&&a.Alt&&c.copy){b=s;}else if(a.Shift&&c.move){b=l;}else if(a.Alt&&c.alias){b=t;}else if(a.Ctrl&&c.copy){b=s;}else if(c.move){b=l;}else if(c.copy){b=s;}else if(c.alias){b=t;}}if(b!=this.__gr){this.__gr=b;this.__gx(x,this.__gl,this.__gk,false);}},__gx:function(bg,bh,bi,bj,bk){var bm=qx.event.Registration;var bl=bm.createEvent(bg,qx.event.type.Drag,[bj,bk]);if(bh!==bi){bl.setRelatedTarget(bi);}return bm.dispatchEvent(bh,bl);},__gy:function(bd){while(bd&&bd.nodeType==1){if(bd.getAttribute(D)==F){return bd;}bd=bd.parentNode;}return null;},__gz:function(h){while(h&&h.nodeType==1){if(h.getAttribute(A)==F){return h;}h=h.parentNode;}return null;},__gA:function(){this.__gl=null;this.__gi.removeListener(this.__gj,m,this._onMouseMove,this,true);this.__gi.removeListener(this.__gj,H,this._onMouseUp,this,true);qx.event.Registration.removeListener(window,r,this._onWindowBlur,this);this.__gv();},__gB:function(){if(this.__gs){this.__gi.removeListener(this.__gj,k,this._onMouseOver,this,true);this.__gi.removeListener(this.__gj,q,this._onMouseOut,this,true);this.__gi.removeListener(this.__gj,p,this._onKeyDown,this,true);this.__gi.removeListener(this.__gj,I,this._onKeyUp,this,true);this.__gx(G,this.__gl,this.__gk,false);this.__gs=false;}this.__gC=false;this.__gk=null;this.__gA();},__gC:false,_onWindowBlur:function(e){this.__gB();},_onKeyDown:function(e){var ba=e.getKeyIdentifier();switch(ba){case J:case o:case n:if(!this.__go[ba]){this.__go[ba]=true;this.__gw();}}},_onKeyUp:function(e){var S=e.getKeyIdentifier();switch(S){case J:case o:case n:if(this.__go[S]){this.__go[S]=false;this.__gw();}}},_onMouseDown:function(e){if(this.__gs){return;}var O=this.__gy(e.getTarget());if(O){this.__gt=e.getDocumentLeft();this.__gu=e.getDocumentTop();this.__gl=O;this.__gi.addListener(this.__gj,m,this._onMouseMove,this,true);this.__gi.addListener(this.__gj,H,this._onMouseUp,this,true);qx.event.Registration.addListener(window,r,this._onWindowBlur,this);}},_onMouseUp:function(e){if(this.__gC){this.__gx(B,this.__gk,this.__gl,false,e);}if(this.__gs){e.stopPropagation();}this.__gB();},_onMouseMove:function(e){if(this.__gs){if(!this.__gx(C,this.__gl,this.__gk,true,e)){this.__gB();}}else{if(Math.abs(e.getDocumentLeft()-this.__gt)>3||Math.abs(e.getDocumentTop()-this.__gu)>3){if(this.__gx(w,this.__gl,this.__gk,true,e)){this.__gs=true;this.__gi.addListener(this.__gj,k,this._onMouseOver,this,true);this.__gi.addListener(this.__gj,q,this._onMouseOut,this,true);this.__gi.addListener(this.__gj,p,this._onKeyDown,this,true);this.__gi.addListener(this.__gj,I,this._onKeyUp,this,true);var bc=this.__go;bc.Ctrl=e.isCtrlPressed();bc.Shift=e.isShiftPressed();bc.Alt=e.isAltPressed();this.__gw();}else{this.__gx(G,this.__gl,this.__gk,false);this.__gA();}}}},_onMouseOver:function(e){var be=e.getTarget();var bf=this.__gz(be);if(bf&&bf!=this.__gk){this.__gC=this.__gx(v,bf,this.__gl,true,e);this.__gk=bf;this.__gw();}},_onMouseOut:function(e){var Y=this.__gz(e.getTarget());var X=this.__gz(e.getRelatedTarget());if(Y&&Y!==X&&Y==this.__gk){this.__gx(u,this.__gk,X,false,e);this.__gk=null;this.__gC=false;qx.event.Timer.once(this.__gw,this,0);}}},destruct:function(){this.__gl=this.__gk=this.__gi=this.__gj=this.__gm=this.__gn=this.__go=this.__gp=null;},defer:function(P){qx.event.Registration.addHandler(P);}});})();(function(){var h="-",g="qx.event.handler.Element";qx.Class.define(g,{extend:qx.core.Object,implement:qx.event.IEventHandler,construct:function(s){qx.core.Object.call(this);this._manager=s;this._registeredEvents={};},statics:{PRIORITY:qx.event.Registration.PRIORITY_NORMAL,SUPPORTED_TYPES:{abort:true,scroll:true,select:true,reset:true,submit:true},TARGET_CHECK:qx.event.IEventHandler.TARGET_DOMNODE,IGNORE_CAN_HANDLE:true},members:{canHandleEvent:function(e,f){},registerEvent:function(m,n,o){var r=qx.core.ObjectRegistry.toHashCode(m);var p=r+h+n;var q=qx.lang.Function.listener(this._onNative,this,p);qx.bom.Event.addNativeListener(m,n,q);this._registeredEvents[p]={element:m,type:n,listener:q};},unregisterEvent:function(t,u,v){var y=this._registeredEvents;if(!y){return;}var z=qx.core.ObjectRegistry.toHashCode(t);var w=z+h+u;var x=this._registeredEvents[w];if(x){qx.bom.Event.removeNativeListener(t,u,x.listener);}delete this._registeredEvents[w];},_onNative:qx.event.GlobalError.observeMethod(function(a,b){var d=this._registeredEvents;if(!d){return;}var c=d[b];qx.event.Registration.fireNonBubblingEvent(c.element,c.type,qx.event.type.Native,[a]);})},destruct:function(){var i;var j=this._registeredEvents;for(var k in j){i=j[k];qx.bom.Event.removeNativeListener(i.element,i.type,i.listener);}this._manager=this._registeredEvents=null;},defer:function(l){qx.event.Registration.addHandler(l);}});})();(function(){var d="qx.event.handler.Appear",c="disappear",b="appear";qx.Class.define(d,{extend:qx.core.Object,implement:qx.event.IEventHandler,construct:function(x){qx.core.Object.call(this);this.__gD=x;this.__gE={};qx.event.handler.Appear.__gF[this.$$hash]=this;},statics:{PRIORITY:qx.event.Registration.PRIORITY_NORMAL,SUPPORTED_TYPES:{appear:true,disappear:true},TARGET_CHECK:qx.event.IEventHandler.TARGET_DOMNODE,IGNORE_CAN_HANDLE:true,__gF:{},refresh:function(){var e=this.__gF;for(var f in e){e[f].refresh();}}},members:{__gD:null,__gE:null,canHandleEvent:function(v,w){},registerEvent:function(g,h,i){var j=qx.core.ObjectRegistry.toHashCode(g)+h;var k=this.__gE;if(k&&!k[j]){k[j]=g;g.$$displayed=g.offsetWidth>0;}},unregisterEvent:function(q,r,s){var t=qx.core.ObjectRegistry.toHashCode(q)+r;var u=this.__gE;if(!u){return;}if(u[t]){delete u[t];}},refresh:function(){var o=this.__gE;var p;for(var n in o){p=o[n];var l=p.offsetWidth>0;if((!!p.$$displayed)!==l){p.$$displayed=l;var m=qx.event.Registration.createEvent(l?b:c);this.__gD.dispatchEvent(p,m);}}}},destruct:function(){this.__gD=this.__gE=null;delete qx.event.handler.Appear.__gF[this.$$hash];},defer:function(a){qx.event.Registration.addHandler(a);}});})();(function(){var I="mshtml",H="",G="qx.client",F=" ",E=">",D="<",C="='",B="none",A="<INPUT TYPE='RADIO' NAME='RADIOTEST' VALUE='Second Choice'>",z="qx.bom.Element",w="' ",y="div",x="></";qx.Class.define(z,{statics:{__gG:{"onload":true,"onpropertychange":true,"oninput":true,"onchange":true,"name":true,"type":true,"checked":true,"disabled":true},__gH:{},__gI:{},allowCreationWithMarkup:function(K){if(!K){K=window;}var L=K.location.href;if(qx.bom.Element.__gI[L]==undefined){try{K.document.createElement(A);qx.bom.Element.__gI[L]=true;}catch(e){qx.bom.Element.__gI[L]=false;}}return qx.bom.Element.__gI[L];},getHelperElement:function(a){if(!a){a=window;}var c=a.location.href;if(!qx.bom.Element.__gH[c]){var b=qx.bom.Element.__gH[c]=a.document.createElement(y);if(qx.bom.client.Engine.WEBKIT){b.style.display=B;a.document.body.appendChild(b);}}return qx.bom.Element.__gH[c];},create:function(name,p,q){if(!q){q=window;}if(!name){throw new Error("The tag name is missing!");}var s=this.__gG;var r=H;for(var u in p){if(s[u]){r+=u+C+p[u]+w;}}var v;if(r!=H){if(qx.bom.Element.allowCreationWithMarkup(q)){v=q.document.createElement(D+name+F+r+E);}else{var t=qx.bom.Element.getHelperElement(q);t.innerHTML=D+name+F+r+x+name+E;v=t.firstChild;}}else{v=q.document.createElement(name);}for(var u in p){if(!s[u]){qx.bom.element.Attribute.set(v,u,p[u]);}}return v;},empty:function(J){return J.innerHTML=H;},addListener:function(d,f,g,self,h){return qx.event.Registration.addListener(d,f,g,self,h);},removeListener:function(bb,bc,bd,self,be){return qx.event.Registration.removeListener(bb,bc,bd,self,be);},removeListenerById:function(m,n){return qx.event.Registration.removeListenerById(m,n);},hasListener:function(bf,bg,bh){return qx.event.Registration.hasListener(bf,bg,bh);},focus:function(M){qx.event.Registration.getManager(M).getHandler(qx.event.handler.Focus).focus(M);},blur:function(ba){qx.event.Registration.getManager(ba).getHandler(qx.event.handler.Focus).blur(ba);},activate:function(bk){qx.event.Registration.getManager(bk).getHandler(qx.event.handler.Focus).activate(bk);},deactivate:function(o){qx.event.Registration.getManager(o).getHandler(qx.event.handler.Focus).deactivate(o);},capture:function(bi,bj){qx.event.Registration.getManager(bi).getDispatcher(qx.event.dispatch.MouseCapture).activateCapture(bi,bj);},releaseCapture:function(k){qx.event.Registration.getManager(k).getDispatcher(qx.event.dispatch.MouseCapture).releaseCapture(k);},clone:function(N,O){var R;if(O||(qx.core.Variant.isSet(G,I)&&!qx.xml.Document.isXmlDocument(N))){var V=qx.event.Registration.getManager(N);var P=qx.dom.Hierarchy.getDescendants(N);P.push(N);}if(qx.core.Variant.isSet(G,I)){for(var i=0,l=P.length;i<l;i++){V.toggleAttachedEvents(P[i],false);}}var R=N.cloneNode(true);if(qx.core.Variant.isSet(G,I)){for(var i=0,l=P.length;i<l;i++){V.toggleAttachedEvents(P[i],true);}}if(O===true){var Y=qx.dom.Hierarchy.getDescendants(R);Y.push(R);var Q,T,X,S;for(var i=0,W=P.length;i<W;i++){X=P[i];Q=V.serializeListeners(X);if(Q.length>0){T=Y[i];for(var j=0,U=Q.length;j<U;j++){S=Q[j];V.addListener(T,S.type,S.handler,S.self,S.capture);}}}}return R;}}});})();(function(){var c="qx.event.type.Native";qx.Class.define(c,{extend:qx.event.type.Event,members:{init:function(d,e,f,g,h){qx.event.type.Event.prototype.init.call(this,g,h);this._target=e||qx.bom.Event.getTarget(d);this._relatedTarget=f||qx.bom.Event.getRelatedTarget(d);if(d.timeStamp){this._timeStamp=d.timeStamp;}this._native=d;this._returnValue=null;return this;},clone:function(i){var j=qx.event.type.Event.prototype.clone.call(this,i);var k={};j._native=this._cloneNativeEvent(this._native,k);j._returnValue=this._returnValue;return j;},_cloneNativeEvent:function(a,b){b.preventDefault=qx.lang.Function.empty;return b;},preventDefault:function(){qx.event.type.Event.prototype.preventDefault.call(this);qx.bom.Event.preventDefault(this._native);},getNativeEvent:function(){return this._native;},setReturnValue:function(l){this._returnValue=l;},getReturnValue:function(){return this._returnValue;}},destruct:function(){this._native=this._returnValue=null;}});})();(function(){var c="qx.event.type.Dom";qx.Class.define(c,{extend:qx.event.type.Native,statics:{SHIFT_MASK:1,CTRL_MASK:2,ALT_MASK:4,META_MASK:8},members:{_cloneNativeEvent:function(a,b){var b=qx.event.type.Native.prototype._cloneNativeEvent.call(this,a,b);b.shiftKey=a.shiftKey;b.ctrlKey=a.ctrlKey;b.altKey=a.altKey;b.metaKey=a.metaKey;return b;},getModifiers:function(){var e=0;var d=this._native;if(d.shiftKey){e|=qx.event.type.Dom.SHIFT_MASK;}if(d.ctrlKey){e|=qx.event.type.Dom.CTRL_MASK;}if(d.altKey){e|=qx.event.type.Dom.ALT_MASK;}if(d.metaKey){e|=qx.event.type.Dom.META_MASK;}return e;},isCtrlPressed:function(){return this._native.ctrlKey;},isShiftPressed:function(){return this._native.shiftKey;},isAltPressed:function(){return this._native.altKey;},isMetaPressed:function(){return this._native.metaKey;},isCtrlOrCommandPressed:function(){if(qx.bom.client.Platform.MAC){return this._native.metaKey;}else{return this._native.ctrlKey;}}}});})();(function(){var c="qx.event.type.KeyInput";qx.Class.define(c,{extend:qx.event.type.Dom,members:{init:function(d,e,f){qx.event.type.Dom.prototype.init.call(this,d,e,null,true,true);this._charCode=f;return this;},clone:function(a){var b=qx.event.type.Dom.prototype.clone.call(this,a);b._charCode=this._charCode;return b;},getCharCode:function(){return this._charCode;},getChar:function(){return String.fromCharCode(this._charCode);}}});})();(function(){var d="qx.event.type.KeySequence";qx.Class.define(d,{extend:qx.event.type.Dom,members:{init:function(a,b,c){qx.event.type.Dom.prototype.init.call(this,a,b,null,true,true);this._identifier=c;return this;},clone:function(e){var f=qx.event.type.Dom.prototype.clone.call(this,e);f._identifier=this._identifier;return f;},getKeyIdentifier:function(){return this._identifier;}}});})();(function(){var be="qx.client",bd="mousedown",bc="mouseup",bb="blur",ba="focus",Y="on",X="DOMFocusOut",W="selectstart",V="DOMFocusIn",U="focusin",bz="focusout",by="draggesture",bx="onmousedown",bw="qx.event.handler.Focus",bv="_applyFocus",bu="deactivate",bt="textarea",bs="onfocusout",br="_applyActive",bq='character',bl="input",bm="onmouseup",bj="onfocusin",bk="qxSelectable",bh="tabIndex",bi="off",bf="activate",bg="mshtml",bn="qxKeepFocus",bo="onselectstart",bp="qxKeepActive";qx.Class.define(bw,{extend:qx.core.Object,implement:qx.event.IEventHandler,construct:function(d){qx.core.Object.call(this);this._manager=d;this._window=d.getWindow();this._document=this._window.document;this._root=this._document.documentElement;this._body=this._document.body;this._initObserver();},properties:{active:{apply:br,nullable:true},focus:{apply:bv,nullable:true}},statics:{PRIORITY:qx.event.Registration.PRIORITY_NORMAL,SUPPORTED_TYPES:{focus:1,blur:1,focusin:1,focusout:1,activate:1,deactivate:1},IGNORE_CAN_HANDLE:true,FOCUSABLE_ELEMENTS:qx.core.Variant.select("qx.client",{"mshtml|gecko":{a:1,body:1,button:1,frame:1,iframe:1,img:1,input:1,object:1,select:1,textarea:1},"opera|webkit":{button:1,input:1,select:1,textarea:1}})},members:{__gJ:null,__gK:null,__gL:null,__gM:null,__gN:null,__gO:null,__gP:null,__gQ:null,__gR:null,__gS:null,canHandleEvent:function(H,I){},registerEvent:function(bF,bG,bH){},unregisterEvent:function(q,r,s){},focus:function(G){if(qx.core.Variant.isSet(be,bg)){window.setTimeout(function(){try{G.focus();var x=qx.bom.Selection.get(G);if(x.length==0){var y=G.createTextRange();y.moveStart(bq,G.value.length);y.collapse();y.select();}}catch(S){}},0);}else{try{G.focus();}catch(z){}}this.setFocus(G);this.setActive(G);},activate:function(C){this.setActive(C);},blur:function(u){try{u.blur();}catch(bJ){}if(this.getActive()===u){this.resetActive();}if(this.getFocus()===u){this.resetFocus();}},deactivate:function(t){if(this.getActive()===t){this.resetActive();}},tryActivate:function(i){var j=this.__hi(i);if(j){this.setActive(j);}},__gT:function(J,K,L,M){var O=qx.event.Registration;var N=O.createEvent(L,qx.event.type.Focus,[J,K,M]);O.dispatchEvent(J,N);},_windowFocused:true,__gU:function(){if(this._windowFocused){this._windowFocused=false;this.__gT(this._window,null,bb,false);}},__gV:function(){if(!this._windowFocused){this._windowFocused=true;this.__gT(this._window,null,ba,false);}},_initObserver:qx.core.Variant.select(be,{"gecko":function(){this.__gJ=qx.lang.Function.listener(this.__hc,this);this.__gK=qx.lang.Function.listener(this.__hd,this);this.__gL=qx.lang.Function.listener(this.__hb,this);this.__gM=qx.lang.Function.listener(this.__ha,this);this.__gN=qx.lang.Function.listener(this.__gW,this);this._document.addEventListener(bd,this.__gJ,true);this._document.addEventListener(bc,this.__gK,true);this._window.addEventListener(ba,this.__gL,true);this._window.addEventListener(bb,this.__gM,true);this._window.addEventListener(by,this.__gN,true);},"mshtml":function(){this.__gJ=qx.lang.Function.listener(this.__hc,this);this.__gK=qx.lang.Function.listener(this.__hd,this);this.__gP=qx.lang.Function.listener(this.__gX,this);this.__gQ=qx.lang.Function.listener(this.__gY,this);this.__gO=qx.lang.Function.listener(this.__hf,this);this._document.attachEvent(bx,this.__gJ);this._document.attachEvent(bm,this.__gK);this._document.attachEvent(bj,this.__gP);this._document.attachEvent(bs,this.__gQ);this._document.attachEvent(bo,this.__gO);},"webkit":function(){this.__gJ=qx.lang.Function.listener(this.__hc,this);this.__gK=qx.lang.Function.listener(this.__hd,this);this.__gQ=qx.lang.Function.listener(this.__gY,this);this.__gL=qx.lang.Function.listener(this.__hb,this);this.__gM=qx.lang.Function.listener(this.__ha,this);this.__gO=qx.lang.Function.listener(this.__hf,this);this._document.addEventListener(bd,this.__gJ,true);this._document.addEventListener(bc,this.__gK,true);this._document.addEventListener(W,this.__gO,false);this._window.addEventListener(X,this.__gQ,true);this._window.addEventListener(ba,this.__gL,true);this._window.addEventListener(bb,this.__gM,true);},"opera":function(){this.__gJ=qx.lang.Function.listener(this.__hc,this);this.__gK=qx.lang.Function.listener(this.__hd,this);this.__gP=qx.lang.Function.listener(this.__gX,this);this.__gQ=qx.lang.Function.listener(this.__gY,this);this._document.addEventListener(bd,this.__gJ,true);this._document.addEventListener(bc,this.__gK,true);this._window.addEventListener(V,this.__gP,true);this._window.addEventListener(X,this.__gQ,true);}}),_stopObserver:qx.core.Variant.select(be,{"gecko":function(){this._document.removeEventListener(bd,this.__gJ,true);this._document.removeEventListener(bc,this.__gK,true);this._window.removeEventListener(ba,this.__gL,true);this._window.removeEventListener(bb,this.__gM,true);this._window.removeEventListener(by,this.__gN,true);},"mshtml":function(){var Event=qx.bom.Event;Event.removeNativeListener(this._document,bd,this.__gJ);Event.removeNativeListener(this._document,bc,this.__gK);Event.removeNativeListener(this._document,U,this.__gP);Event.removeNativeListener(this._document,bz,this.__gQ);Event.removeNativeListener(this._document,W,this.__gO);},"webkit":function(){this._document.removeEventListener(bd,this.__gJ,true);this._document.removeEventListener(bc,this.__gK,true);this._document.removeEventListener(W,this.__gO,false);this._window.removeEventListener(X,this.__gQ,true);this._window.removeEventListener(ba,this.__gL,true);this._window.removeEventListener(bb,this.__gM,true);},"opera":function(){this._document.removeEventListener(bd,this.__gJ,true);this._document.removeEventListener(bc,this.__gK,true);this._window.removeEventListener(V,this.__gP,true);this._window.removeEventListener(X,this.__gQ,true);}}),__gW:qx.event.GlobalError.observeMethod(qx.core.Variant.select(be,{"gecko":function(e){if(!this.__hj(e.target)){qx.bom.Event.preventDefault(e);}},"default":null})),__gX:qx.event.GlobalError.observeMethod(qx.core.Variant.select(be,{"mshtml":function(e){this.__gV();var Q=e.srcElement;var P=this.__hh(Q);if(P){this.setFocus(P);}this.tryActivate(Q);},"opera":function(e){var D=e.target;if(D==this._document||D==this._window){this.__gV();if(this.__gR){this.setFocus(this.__gR);delete this.__gR;}if(this.__gS){this.setActive(this.__gS);delete this.__gS;}}else{this.setFocus(D);this.tryActivate(D);if(!this.__hj(D)){D.selectionStart=0;D.selectionEnd=0;}}},"default":null})),__gY:qx.event.GlobalError.observeMethod(qx.core.Variant.select(be,{"mshtml":function(e){if(!e.toElement){this.__gU();this.resetFocus();this.resetActive();}},"webkit":function(e){var n=e.target;if(n===this.getFocus()){this.resetFocus();}if(n===this.getActive()){this.resetActive();}},"opera":function(e){var A=e.target;if(A==this._document){this.__gU();this.__gR=this.getFocus();this.__gS=this.getActive();this.resetFocus();this.resetActive();}else{if(A===this.getFocus()){this.resetFocus();}if(A===this.getActive()){this.resetActive();}}},"default":null})),__ha:qx.event.GlobalError.observeMethod(qx.core.Variant.select(be,{"gecko":function(e){if(e.target===this._window||e.target===this._document){this.__gU();this.resetActive();this.resetFocus();}},"webkit":function(e){if(e.target===this._window||e.target===this._document){this.__gU();this.__gR=this.getFocus();this.__gS=this.getActive();this.resetActive();this.resetFocus();}},"default":null})),__hb:qx.event.GlobalError.observeMethod(qx.core.Variant.select(be,{"gecko":function(e){var R=e.target;if(R===this._window||R===this._document){this.__gV();R=this._body;}this.setFocus(R);this.tryActivate(R);},"webkit":function(e){var B=e.target;if(B===this._window||B===this._document){this.__gV();if(this.__gR){this.setFocus(this.__gR);delete this.__gR;}if(this.__gS){this.setActive(this.__gS);delete this.__gS;}}else{this.setFocus(B);this.tryActivate(B);}},"default":null})),__hc:qx.event.GlobalError.observeMethod(qx.core.Variant.select(be,{"gecko":function(e){var bN=this.__hh(e.target);if(!bN){qx.bom.Event.preventDefault(e);}else if(bN===this._body){this.setFocus(bN);}},"mshtml":function(e){var l=e.srcElement;var k=this.__hh(l);if(k){if(!this.__hj(l)){l.unselectable=Y;try{document.selection.empty();}catch(e){}try{k.focus();}catch(e){}}}else{qx.bom.Event.preventDefault(e);if(!this.__hj(l)){l.unselectable=Y;}}},"webkit":function(e){var p=e.target;var o=this.__hh(p);if(o){this.setFocus(o);}else{qx.bom.Event.preventDefault(e);}},"opera":function(e){var bQ=e.target;var bO=this.__hh(bQ);if(!this.__hj(bQ)){qx.bom.Event.preventDefault(e);if(bO){var bP=this.getFocus();if(bP&&bP.selectionEnd){bP.selectionStart=0;bP.selectionEnd=0;bP.blur();}if(bO){this.setFocus(bO);}}}else if(bO){this.setFocus(bO);}},"default":null})),__hd:qx.event.GlobalError.observeMethod(qx.core.Variant.select(be,{"mshtml":function(e){var c=e.srcElement;if(c.unselectable){c.unselectable=bi;}this.tryActivate(this.__he(c));},"gecko":function(e){var m=e.target;while(m&&m.offsetWidth===undefined){m=m.parentNode;}if(m){this.tryActivate(m);}},"webkit|opera":function(e){this.tryActivate(this.__he(e.target));},"default":null})),__he:qx.event.GlobalError.observeMethod(qx.core.Variant.select(be,{"mshtml|webkit":function(E){var F=this.getFocus();if(F&&E!=F&&(F.nodeName.toLowerCase()===bl||F.nodeName.toLowerCase()===bt)){E=F;}return E;},"default":function(T){return T;}})),__hf:qx.event.GlobalError.observeMethod(qx.core.Variant.select(be,{"mshtml|webkit":function(e){var bC=qx.bom.client.Engine.MSHTML?e.srcElement:e.target;if(!this.__hj(bC)){qx.bom.Event.preventDefault(e);}},"default":null})),__hg:function(bK){var bL=qx.bom.element.Attribute.get(bK,bh);if(bL>=1){return true;}var bM=qx.event.handler.Focus.FOCUSABLE_ELEMENTS;if(bL>=0&&bM[bK.tagName]){return true;}return false;},__hh:function(bI){while(bI&&bI.nodeType===1){if(bI.getAttribute(bn)==Y){return null;}if(this.__hg(bI)){return bI;}bI=bI.parentNode;}return this._body;},__hi:function(bA){var bB=bA;while(bA&&bA.nodeType===1){if(bA.getAttribute(bp)==Y){return null;}bA=bA.parentNode;}return bB;},__hj:function(v){while(v&&v.nodeType===1){var w=v.getAttribute(bk);if(w!=null){return w===Y;}v=v.parentNode;}return true;},_applyActive:function(a,b){if(b){this.__gT(b,a,bu,true);}if(a){this.__gT(a,b,bf,true);}},_applyFocus:function(bD,bE){if(bE){this.__gT(bE,bD,bz,true);}if(bD){this.__gT(bD,bE,U,true);}if(bE){this.__gT(bE,bD,bb,false);}if(bD){this.__gT(bD,bE,ba,false);}}},destruct:function(){this._stopObserver();this._manager=this._window=this._document=this._root=this._body=this.__hk=null;},defer:function(f){qx.event.Registration.addHandler(f);var g=f.FOCUSABLE_ELEMENTS;for(var h in g){g[h.toUpperCase()]=1;}}});})();(function(){var A="qx.client",z="character",y="EndToEnd",x="input",w="textarea",v="StartToStart",u='character',t="qx.bom.Selection",s="button",r="#text",q="body";qx.Class.define(t,{statics:{getSelectionObject:qx.core.Variant.select(A,{"mshtml":function(bb){return bb.selection;},"default":function(ba){return qx.dom.Node.getWindow(ba).getSelection();}}),get:qx.core.Variant.select(A,{"mshtml":function(X){var Y=qx.bom.Range.get(qx.dom.Node.getDocument(X));return Y.text;},"default":function(J){if(this.__hl(J)){return J.value.substring(J.selectionStart,J.selectionEnd);}else{return this.getSelectionObject(qx.dom.Node.getDocument(J)).toString();}}}),getLength:qx.core.Variant.select(A,{"mshtml":function(K){var M=this.get(K);var L=qx.util.StringSplit.split(M,/\r\n/);return M.length-(L.length-1);},"opera":function(bt){var by,bw,bu;if(this.__hl(bt)){var bx=bt.selectionStart;var bv=bt.selectionEnd;by=bt.value.substring(bx,bv);bw=bv-bx;}else{by=qx.bom.Selection.get(bt);bw=by.length;}bu=qx.util.StringSplit.split(by,/\r\n/);return bw-(bu.length-1);},"default":function(I){if(this.__hl(I)){return I.selectionEnd-I.selectionStart;}else{return this.get(I).length;}}}),getStart:qx.core.Variant.select(A,{"mshtml":function(O){if(this.__hl(O)){var T=qx.bom.Range.get();if(!O.contains(T.parentElement())){return -1;}var U=qx.bom.Range.get(O);var S=O.value.length;U.moveToBookmark(T.getBookmark());U.moveEnd(u,S);return S-U.text.length;}else{var U=qx.bom.Range.get(O);var Q=U.parentElement();var V=qx.bom.Range.get();V.moveToElementText(Q);var P=qx.bom.Range.get(qx.dom.Node.getBodyElement(O));P.setEndPoint(v,U);P.setEndPoint(y,V);if(V.compareEndPoints(v,P)==0){return 0;}var R;var W=0;while(true){R=P.moveStart(z,-1);if(V.compareEndPoints(v,P)==0){break;}if(R==0){break;}else{W++;}}return ++W;}},"gecko|webkit":function(bc){if(this.__hl(bc)){return bc.selectionStart;}else{var be=qx.dom.Node.getDocument(bc);var bd=this.getSelectionObject(be);if(bd.anchorOffset<bd.focusOffset){return bd.anchorOffset;}else{return bd.focusOffset;}}},"default":function(a){if(this.__hl(a)){return a.selectionStart;}else{return qx.bom.Selection.getSelectionObject(qx.dom.Node.getDocument(a)).anchorOffset;}}}),getEnd:qx.core.Variant.select(A,{"mshtml":function(bf){if(this.__hl(bf)){var bk=qx.bom.Range.get();if(!bf.contains(bk.parentElement())){return -1;}var bl=qx.bom.Range.get(bf);var bj=bf.value.length;bl.moveToBookmark(bk.getBookmark());bl.moveStart(u,-bj);return bl.text.length;}else{var bl=qx.bom.Range.get(bf);var bh=bl.parentElement();var bm=qx.bom.Range.get();bm.moveToElementText(bh);var bj=bm.text.length;var bg=qx.bom.Range.get(qx.dom.Node.getBodyElement(bf));bg.setEndPoint(y,bl);bg.setEndPoint(v,bm);if(bm.compareEndPoints(y,bg)==0){return bj-1;}var bi;var bn=0;while(true){bi=bg.moveEnd(z,1);if(bm.compareEndPoints(y,bg)==0){break;}if(bi==0){break;}else{bn++;}}return bj-(++bn);}},"gecko|webkit":function(n){if(this.__hl(n)){return n.selectionEnd;}else{var p=qx.dom.Node.getDocument(n);var o=this.getSelectionObject(p);if(o.focusOffset>o.anchorOffset){return o.focusOffset;}else{return o.anchorOffset;}}},"default":function(m){if(this.__hl(m)){return m.selectionEnd;}else{return qx.bom.Selection.getSelectionObject(qx.dom.Node.getDocument(m)).focusOffset;}}}),__hl:function(N){return qx.dom.Node.isElement(N)&&(N.nodeName.toLowerCase()==x||N.nodeName.toLowerCase()==w);},set:qx.core.Variant.select(A,{"mshtml":function(bo,bp,bq){var br;if(qx.dom.Node.isDocument(bo)){bo=bo.body;}if(qx.dom.Node.isElement(bo)||qx.dom.Node.isText(bo)){switch(bo.nodeName.toLowerCase()){case x:case w:case s:if(bq===undefined){bq=bo.value.length;}if(bp>=0&&bp<=bo.value.length&&bq>=0&&bq<=bo.value.length){br=qx.bom.Range.get(bo);br.collapse(true);br.moveStart(z,bp);br.moveEnd(z,bq-bp);br.select();return true;}break;case r:if(bq===undefined){bq=bo.nodeValue.length;}if(bp>=0&&bp<=bo.nodeValue.length&&bq>=0&&bq<=bo.nodeValue.length){br=qx.bom.Range.get(qx.dom.Node.getBodyElement(bo));br.moveToElementText(bo.parentNode);br.collapse(true);br.moveStart(z,bp);br.moveEnd(z,bq-bp);br.select();return true;}break;default:if(bq===undefined){bq=bo.childNodes.length-1;}if(bo.childNodes[bp]&&bo.childNodes[bq]){br=qx.bom.Range.get(qx.dom.Node.getBodyElement(bo));br.moveToElementText(bo.childNodes[bp]);br.collapse(true);var bs=qx.bom.Range.get(qx.dom.Node.getBodyElement(bo));bs.moveToElementText(bo.childNodes[bq]);br.setEndPoint(y,bs);br.select();return true;}}}return false;},"default":function(B,C,D){var H=B.nodeName.toLowerCase();if(qx.dom.Node.isElement(B)&&(H==x||H==w)){if(D===undefined){D=B.value.length;}if(C>=0&&C<=B.value.length&&D>=0&&D<=B.value.length){B.focus();B.select();B.setSelectionRange(C,D);return true;}}else{var F=false;var G=qx.dom.Node.getWindow(B).getSelection();var E=qx.bom.Range.get(B);if(qx.dom.Node.isText(B)){if(D===undefined){D=B.length;}if(C>=0&&C<B.length&&D>=0&&D<=B.length){F=true;}}else if(qx.dom.Node.isElement(B)){if(D===undefined){D=B.childNodes.length-1;}if(C>=0&&B.childNodes[C]&&D>=0&&B.childNodes[D]){F=true;}}else if(qx.dom.Node.isDocument(B)){B=B.body;if(D===undefined){D=B.childNodes.length-1;}if(C>=0&&B.childNodes[C]&&D>=0&&B.childNodes[D]){F=true;}}if(F){if(!G.isCollapsed){G.collapseToStart();}E.setStart(B,C);if(qx.dom.Node.isText(B)){E.setEnd(B,D);}else{E.setEndAfter(B.childNodes[D]);}if(G.rangeCount>0){G.removeAllRanges();}G.addRange(E);return true;}}return false;}}),setAll:function(f){return qx.bom.Selection.set(f,0);},clear:qx.core.Variant.select(A,{"mshtml":function(b){var c=qx.bom.Selection.getSelectionObject(qx.dom.Node.getDocument(b));var d=qx.bom.Range.get(b);var parent=d.parentElement();var e=qx.bom.Range.get(qx.dom.Node.getDocument(b));if(parent==e.parentElement()&&parent==b){c.empty();}},"default":function(g){var i=qx.bom.Selection.getSelectionObject(qx.dom.Node.getDocument(g));var k=g.nodeName.toLowerCase();if(qx.dom.Node.isElement(g)&&(k==x||k==w)){g.setSelectionRange(0,0);qx.bom.Element.blur(g);}else if(qx.dom.Node.isDocument(g)||k==q){i.collapse(g.body?g.body:g,0);}else{var j=qx.bom.Range.get(g);if(!j.collapsed){var l;var h=j.commonAncestorContainer;if(qx.dom.Node.isElement(g)&&qx.dom.Node.isText(h)){l=h.parentNode;}else{l=h;}if(l==g){i.collapse(g,0);}}}}})}});})();(function(){var l="button",k="qx.bom.Range",j="text",i="password",h="file",g="submit",f="reset",e="textarea",d="input",c="hidden",a="qx.client",b="body";qx.Class.define(k,{statics:{get:qx.core.Variant.select(a,{"mshtml":function(m){if(qx.dom.Node.isElement(m)){switch(m.nodeName.toLowerCase()){case d:switch(m.type){case j:case i:case c:case l:case f:case h:case g:return m.createTextRange();break;default:return qx.bom.Selection.getSelectionObject(qx.dom.Node.getDocument(m)).createRange();}break;case e:case b:case l:return m.createTextRange();break;default:return qx.bom.Selection.getSelectionObject(qx.dom.Node.getDocument(m)).createRange();}}else{if(m==null){m=window;}return qx.bom.Selection.getSelectionObject(qx.dom.Node.getDocument(m)).createRange();}},"default":function(n){var o=qx.dom.Node.getDocument(n);var p=qx.bom.Selection.getSelectionObject(o);if(p.rangeCount>0){return p.getRangeAt(0);}else{return o.createRange();}}})}});})();(function(){var j="",h="m",g="g",f="^",e="qx.util.StringSplit",d="i",c="$(?!\\s)",b="[object RegExp]",a="y";qx.Class.define(e,{statics:{split:function(k,l,m){if(Object.prototype.toString.call(l)!==b){return String.prototype.split.call(k,l,m);}var t=[],n=0,r=(l.ignoreCase?d:j)+(l.multiline?h:j)+(l.sticky?a:j),l=RegExp(l.source,r+g),q,u,o,p,s=/()??/.exec(j)[1]===undefined;k=k+j;if(!s){q=RegExp(f+l.source+c,r);}if(m===undefined||+m<0){m=Infinity;}else{m=Math.floor(+m);if(!m){return [];}}while(u=l.exec(k)){o=u.index+u[0].length;if(o>n){t.push(k.slice(n,u.index));if(!s&&u.length>1){u[0].replace(q,function(){for(var i=1;i<arguments.length-2;i++){if(arguments[i]===undefined){u[i]=undefined;}}});}if(u.length>1&&u.index<k.length){Array.prototype.push.apply(t,u.slice(1));}p=u[0].length;n=o;if(t.length>=m){break;}}if(l.lastIndex===u.index){l.lastIndex++;}}if(n===k.length){if(p||!l.test(j)){t.push(j);}}else{t.push(k.slice(n));}return t.length>m?t.slice(0,m):t;}}});})();(function(){var a="qx.event.type.Focus";qx.Class.define(a,{extend:qx.event.type.Event,members:{init:function(b,c,d){qx.event.type.Event.prototype.init.call(this,d,false);this._target=b;this._relatedTarget=c;return this;}}});})();(function(){var j="",i="undefined",h="qx.client",g="readOnly",f="accessKey",e="qx.bom.element.Attribute",d="rowSpan",c="vAlign",b="className",a="textContent",y="'",x="htmlFor",w="longDesc",v="cellSpacing",u="frameBorder",t="='",s="useMap",r="innerText",q="innerHTML",p="tabIndex",n="dateTime",o="maxLength",l="mshtml",m="cellPadding",k="colSpan";qx.Class.define(e,{statics:{__hm:{names:{"class":b,"for":x,html:q,text:qx.core.Variant.isSet(h,l)?r:a,colspan:k,rowspan:d,valign:c,datetime:n,accesskey:f,tabindex:p,maxlength:o,readonly:g,longdesc:w,cellpadding:m,cellspacing:v,frameborder:u,usemap:s},runtime:{"html":1,"text":1},bools:{compact:1,nowrap:1,ismap:1,declare:1,noshade:1,checked:1,disabled:1,readOnly:1,multiple:1,selected:1,noresize:1,defer:1,allowTransparency:1},property:{$$html:1,$$widget:1,disabled:1,checked:1,readOnly:1,multiple:1,selected:1,value:1,maxLength:1,className:1,innerHTML:1,innerText:1,textContent:1,htmlFor:1,tabIndex:1},qxProperties:{$$widget:1,$$html:1},propertyDefault:{disabled:false,checked:false,readOnly:false,multiple:false,selected:false,value:j,className:j,innerHTML:j,innerText:j,textContent:j,htmlFor:j,tabIndex:0,maxLength:qx.core.Variant.select(h,{"mshtml":2147483647,"webkit":524288,"default":-1})},removeableProperties:{disabled:1,multiple:1,maxLength:1},original:{href:1,src:1,type:1}},compile:function(z){var A=[];var C=this.__hm.runtime;for(var B in z){if(!C[B]){A.push(B,t,z[B],y);}}return A.join(j);},get:qx.core.Variant.select(h,{"mshtml":function(H,name){var J=this.__hm;var I;name=J.names[name]||name;if(J.original[name]){I=H.getAttribute(name,2);}else if(J.property[name]){I=H[name];if(typeof J.propertyDefault[name]!==i&&I==J.propertyDefault[name]){if(typeof J.bools[name]===i){return null;}else{return I;}}}else{I=H.getAttribute(name);}if(J.bools[name]){return !!I;}return I;},"default":function(D,name){var F=this.__hm;var E;name=F.names[name]||name;if(F.property[name]){E=D[name];if(typeof F.propertyDefault[name]!==i&&E==F.propertyDefault[name]){if(typeof F.bools[name]===i){return null;}else{return E;}}}else{E=D.getAttribute(name);}if(F.bools[name]){return !!E;}return E;}}),set:function(K,name,L){var M=this.__hm;name=M.names[name]||name;if(M.bools[name]){L=!!L;}if(M.property[name]&&(!(K[name]===undefined)||M.qxProperties[name])){if(L==null){if(M.removeableProperties[name]){K.removeAttribute(name);return;}else if(typeof M.propertyDefault[name]!==i){L=M.propertyDefault[name];}}K[name]=L;}else{if(L===true){K.setAttribute(name,name);}else if(L===false||L===null){K.removeAttribute(name);}else{K.setAttribute(name,L);}}},reset:function(G,name){this.set(G,name,null);}}});})();(function(){var i="qx.client",h="left",g="right",f="middle",e="click",d="none",c="contextmenu",b="qx.event.type.Mouse";qx.Class.define(b,{extend:qx.event.type.Dom,members:{init:function(k,l,m,n,o){qx.event.type.Dom.prototype.init.call(this,k,l,m,n,o);if(!m){this._relatedTarget=qx.bom.Event.getRelatedTarget(k);}return this;},_cloneNativeEvent:function(p,q){var q=qx.event.type.Dom.prototype._cloneNativeEvent.call(this,p,q);q.button=p.button;q.clientX=p.clientX;q.clientY=p.clientY;q.pageX=p.pageX;q.pageY=p.pageY;q.screenX=p.screenX;q.screenY=p.screenY;q.wheelDelta=p.wheelDelta;q.detail=p.detail;q.srcElement=p.srcElement;return q;},__hn:qx.core.Variant.select(i,{"mshtml":{1:h,2:g,4:f},"default":{0:h,2:g,1:f}}),stop:function(){this.stopPropagation();},getButton:function(){switch(this._type){case c:return g;case e:if(this.__ho){return this.__ho();}default:return this.__hn[this._native.button]||d;}},__ho:qx.core.Variant.select(i,{"mshtml":function(){return h;},"default":null}),isLeftPressed:function(){return this.getButton()===h;},isMiddlePressed:function(){return this.getButton()===f;},isRightPressed:function(){return this.getButton()===g;},getRelatedTarget:function(){return this._relatedTarget;},getViewportLeft:function(){return this._native.clientX;},getViewportTop:function(){return this._native.clientY;},getDocumentLeft:qx.core.Variant.select(i,{"mshtml":function(){var a=qx.dom.Node.getWindow(this._native.srcElement);return this._native.clientX+qx.bom.Viewport.getScrollLeft(a);},"default":function(){return this._native.pageX;}}),getDocumentTop:qx.core.Variant.select(i,{"mshtml":function(){var j=qx.dom.Node.getWindow(this._native.srcElement);return this._native.clientY+qx.bom.Viewport.getScrollTop(j);},"default":function(){return this._native.pageY;}}),getScreenLeft:function(){return this._native.screenX;},getScreenTop:function(){return this._native.screenY;}}});})();(function(){var c="qx.client",b="chrome",a="qx.event.type.MouseWheel";qx.Class.define(a,{extend:qx.event.type.Mouse,members:{stop:function(){this.stopPropagation();this.preventDefault();},getWheelDelta:qx.core.Variant.select(c,{"default":function(){return -(this._native.wheelDelta/40);},"gecko":function(){return this._native.detail;},"webkit":function(){if(qx.bom.client.Browser.NAME==b){if(qx.bom.client.Platform.MAC){if(qx.bom.client.Browser.VERSION>=7){return -(this._native.wheelDelta/30);}return -(this._native.wheelDelta/1200);}else{return -(this._native.wheelDelta/120);}}else{if(qx.bom.client.Platform.WIN){var d=120;if(qx.bom.client.Engine.VERSION==533.16){d=1200;}}else{d=40;if(qx.bom.client.Engine.VERSION==533.16||qx.bom.client.Engine.VERSION==533.17||qx.bom.client.Engine.VERSION==533.18){d=1200;}}return -(this._native.wheelDelta/d);}}})}});})();(function(){var k="qx.client",j="qx.bom.Viewport";qx.Class.define(j,{statics:{getWidth:qx.core.Variant.select(k,{"opera":function(p){if(qx.bom.client.Engine.VERSION<9.5){return (p||window).document.body.clientWidth;}else{var q=(p||window).document;return qx.bom.Document.isStandardMode(p)?q.documentElement.clientWidth:q.body.clientWidth;}},"webkit":function(f){if(qx.bom.client.Engine.VERSION<523.15){return (f||window).innerWidth;}else{var g=(f||window).document;return qx.bom.Document.isStandardMode(f)?g.documentElement.clientWidth:g.body.clientWidth;}},"default":function(h){var i=(h||window).document;return qx.bom.Document.isStandardMode(h)?i.documentElement.clientWidth:i.body.clientWidth;}}),getHeight:qx.core.Variant.select(k,{"opera":function(l){if(qx.bom.client.Engine.VERSION<9.5){return (l||window).document.body.clientHeight;}else{var m=(l||window).document;return qx.bom.Document.isStandardMode(l)?m.documentElement.clientHeight:m.body.clientHeight;}},"webkit":function(d){if(qx.bom.client.Engine.VERSION<523.15){return (d||window).innerHeight;}else{var e=(d||window).document;return qx.bom.Document.isStandardMode(d)?e.documentElement.clientHeight:e.body.clientHeight;}},"default":function(b){var c=(b||window).document;return qx.bom.Document.isStandardMode(b)?c.documentElement.clientHeight:c.body.clientHeight;}}),getScrollLeft:qx.core.Variant.select(k,{"mshtml":function(n){var o=(n||window).document;return o.documentElement.scrollLeft||o.body.scrollLeft;},"default":function(t){return (t||window).pageXOffset;}}),getScrollTop:qx.core.Variant.select(k,{"mshtml":function(r){var s=(r||window).document;return s.documentElement.scrollTop||s.body.scrollTop;},"default":function(a){return (a||window).pageYOffset;}})}});})();(function(){var k="CSS1Compat",j="position:absolute;width:0;height:0;width:1",i="qx.bom.Document",h="1px",g="qx.client",f="div";qx.Class.define(i,{statics:{isQuirksMode:qx.core.Variant.select(g,{"mshtml":function(a){if(qx.bom.client.Engine.VERSION>=8){return (a||window).document.documentMode===5;}else{return (a||window).document.compatMode!==k;}},"webkit":function(m){if(document.compatMode===undefined){var n=(m||window).document.createElement(f);n.style.cssText=j;return n.style.width===h?true:false;}else{return (m||window).document.compatMode!==k;}},"default":function(l){return (l||window).document.compatMode!==k;}}),isStandardMode:function(b){return !this.isQuirksMode(b);},getWidth:function(c){var d=(c||window).document;var e=qx.bom.Viewport.getWidth(c);var scroll=this.isStandardMode(c)?d.documentElement.scrollWidth:d.body.scrollWidth;return Math.max(scroll,e);},getHeight:function(o){var p=(o||window).document;var q=qx.bom.Viewport.getHeight(o);var scroll=this.isStandardMode(o)?p.documentElement.scrollHeight:p.body.scrollHeight;return Math.max(scroll,q);}}});})();(function(){var j="qx.client",i="ie",h="msie",g="android",f="operamini",e="mobile chrome",d=")(/| )([0-9]+\.[0-9])",c="iemobile",b="opera mobi",a="Mobile Safari",x="operamobile",w="mobile safari",v="IEMobile|Maxthon|MSIE",u="qx.bom.client.Browser",t="opera mini",s="(",r="opera",q="mshtml",p="Opera Mini|Opera Mobi|Opera",o="AdobeAIR|Titanium|Fluid|Chrome|Android|Epiphany|Konqueror|iCab|OmniWeb|Maxthon|Pre|Mobile Safari|Safari",m="webkit",n="5.0",k="prism|Fennec|Camino|Kmeleon|Galeon|Netscape|SeaMonkey|Firefox",l="Mobile/";qx.Bootstrap.define(u,{statics:{UNKNOWN:true,NAME:"unknown",TITLE:"unknown 0.0",VERSION:0.0,FULLVERSION:"0.0.0",__hp:function(y){var z=navigator.userAgent;var B=new RegExp(s+y+d);var C=z.match(B);if(!C){return;}var name=C[1].toLowerCase();var A=C[3];if(z.match(/Version(\/| )([0-9]+\.[0-9])/)){A=RegExp.$2;}if(qx.core.Variant.isSet(j,m)){if(name===g){name=e;}else if(z.indexOf(a)!==-1||z.indexOf(l)!==-1){name=w;}}else if(qx.core.Variant.isSet(j,q)){if(name===h){name=i;if(qx.bom.client.System.WINCE&&name===i){name=c;A=n;}}}else if(qx.core.Variant.isSet(j,r)){if(name===b){name=x;}else if(name===t){name=f;}}this.NAME=name;this.FULLVERSION=A;this.VERSION=parseFloat(A,10);this.TITLE=name+" "+this.VERSION;this.UNKNOWN=false;}},defer:qx.core.Variant.select(j,{"webkit":function(D){D.__hp(o);},"gecko":function(E){E.__hp(k);},"mshtml":function(F){F.__hp(v);},"opera":function(G){G.__hp(p);}})});})();(function(){var A="qx.client",z="qx.dom.Hierarchy",y="previousSibling",x="*",w="nextSibling",v="parentNode";qx.Class.define(z,{statics:{getNodeIndex:function(E){var F=0;while(E&&(E=E.previousSibling)){F++;}return F;},getElementIndex:function(L){var M=0;var N=qx.dom.Node.ELEMENT;while(L&&(L=L.previousSibling)){if(L.nodeType==N){M++;}}return M;},getNextElementSibling:function(f){while(f&&(f=f.nextSibling)&&!qx.dom.Node.isElement(f)){continue;}return f||null;},getPreviousElementSibling:function(K){while(K&&(K=K.previousSibling)&&!qx.dom.Node.isElement(K)){continue;}return K||null;},contains:qx.core.Variant.select(A,{"webkit|mshtml|opera":function(g,h){if(qx.dom.Node.isDocument(g)){var i=qx.dom.Node.getDocument(h);return g&&i==g;}else if(qx.dom.Node.isDocument(h)){return false;}else{return g.contains(h);}},"gecko":function(U,V){return !!(U.compareDocumentPosition(V)&16);},"default":function(b,c){while(c){if(b==c){return true;}c=c.parentNode;}return false;}}),isRendered:function(r){if(!r.parentNode||!r.offsetParent){return false;}var s=r.ownerDocument||r.document;if(s.body.contains){return s.body.contains(r);}if(s.compareDocumentPosition){return !!(s.compareDocumentPosition(r)&16);}throw new Error("Missing support for isRendered()!");},isDescendantOf:function(S,T){return this.contains(T,S);},getCommonParent:qx.core.Variant.select(A,{"mshtml|opera":function(t,u){if(t===u){return t;}while(t&&qx.dom.Node.isElement(t)){if(t.contains(u)){return t;}t=t.parentNode;}return null;},"default":function(l,m){if(l===m){return l;}var n={};var q=qx.core.ObjectRegistry;var p,o;while(l||m){if(l){p=q.toHashCode(l);if(n[p]){return n[p];}n[p]=l;l=l.parentNode;}if(m){o=q.toHashCode(m);if(n[o]){return n[o];}n[o]=m;m=m.parentNode;}}return null;}}),getAncestors:function(J){return this._recursivelyCollect(J,v);},getChildElements:function(H){H=H.firstChild;if(!H){return [];}var I=this.getNextSiblings(H);if(H.nodeType===1){I.unshift(H);}return I;},getDescendants:function(j){return qx.lang.Array.fromCollection(j.getElementsByTagName(x));},getFirstDescendant:function(e){e=e.firstChild;while(e&&e.nodeType!=1){e=e.nextSibling;}return e;},getLastDescendant:function(O){O=O.lastChild;while(O&&O.nodeType!=1){O=O.previousSibling;}return O;},getPreviousSiblings:function(G){return this._recursivelyCollect(G,y);},getNextSiblings:function(k){return this._recursivelyCollect(k,w);},_recursivelyCollect:function(P,Q){var R=[];while(P=P[Q]){if(P.nodeType==1){R.push(P);}}return R;},getSiblings:function(a){return this.getPreviousSiblings(a).reverse().concat(this.getNextSiblings(a));},isEmpty:function(d){d=d.firstChild;while(d){if(d.nodeType===qx.dom.Node.ELEMENT||d.nodeType===qx.dom.Node.TEXT){return false;}d=d.nextSibling;}return true;},cleanWhitespace:function(B){var C=B.firstChild;while(C){var D=C.nextSibling;if(C.nodeType==3&&!/\S/.test(C.nodeValue)){B.removeChild(C);}C=D;}}}});})();(function(){var g="qx.client",f="qx.event.type.Drag";qx.Class.define(f,{extend:qx.event.type.Event,members:{init:function(k,l){qx.event.type.Event.prototype.init.call(this,true,k);if(l){this._native=l.getNativeEvent()||null;this._originalTarget=l.getTarget()||null;}else{this._native=null;this._originalTarget=null;}return this;},clone:function(h){var i=qx.event.type.Event.prototype.clone.call(this,h);i._native=this._native;return i;},getDocumentLeft:qx.core.Variant.select(g,{"mshtml":function(){if(this._native==null){return 0;}var d=qx.dom.Node.getWindow(this._native.srcElement);return this._native.clientX+qx.bom.Viewport.getScrollLeft(d);},"default":function(){if(this._native==null){return 0;}return this._native.pageX;}}),getDocumentTop:qx.core.Variant.select(g,{"mshtml":function(){if(this._native==null){return 0;}var m=qx.dom.Node.getWindow(this._native.srcElement);return this._native.clientY+qx.bom.Viewport.getScrollTop(m);},"default":function(){if(this._native==null){return 0;}return this._native.pageY;}}),getManager:function(){return qx.event.Registration.getManager(this.getTarget()).getHandler(qx.event.handler.DragDrop);},addType:function(j){this.getManager().addType(j);},addAction:function(c){this.getManager().addAction(c);},supportsType:function(n){return this.getManager().supportsType(n);},supportsAction:function(e){return this.getManager().supportsAction(e);},addData:function(a,b){this.getManager().addData(a,b);},getData:function(o){return this.getManager().getData(o);},getCurrentType:function(){return this.getManager().getCurrentType();},getCurrentAction:function(){return this.getManager().getCurrentAction();}}});})();(function(){var l="interval",k="qx.event.Timer",j="_applyInterval",i="_applyEnabled",h="Boolean",g="qx.event.type.Event",f="Integer";qx.Class.define(k,{extend:qx.core.Object,construct:function(d){qx.core.Object.call(this);this.setEnabled(false);if(d!=null){this.setInterval(d);}var self=this;this.__hq=function(){self._oninterval.call(self);};},events:{"interval":g},statics:{once:function(n,o,p){var q=new qx.event.Timer(p);q.__hr=n;q.addListener(l,function(e){q.stop();n.call(o,e);q.dispose();o=null;},o);q.start();return q;}},properties:{enabled:{init:true,check:h,apply:i},interval:{check:f,init:1000,apply:j}},members:{__hs:null,__hq:null,_applyInterval:function(r,s){if(this.getEnabled()){this.restart();}},_applyEnabled:function(b,c){if(c){window.clearInterval(this.__hs);this.__hs=null;}else if(b){this.__hs=window.setInterval(this.__hq,this.getInterval());}},start:function(){this.setEnabled(true);},startWith:function(m){this.setInterval(m);this.start();},stop:function(){this.setEnabled(false);},restart:function(){this.stop();this.start();},restartWith:function(a){this.stop();this.startWith(a);},_oninterval:qx.event.GlobalError.observeMethod(function(){if(this.$$disposed){return;}if(this.getEnabled()){this.fireEvent(l);}})},destruct:function(){if(this.__hs){window.clearInterval(this.__hs);}this.__hs=this.__hq=null;}});})();(function(){var j="losecapture",i="qx.client",h="blur",g="focus",f="click",e="qx.event.dispatch.MouseCapture",d="capture",c="scroll";qx.Class.define(e,{extend:qx.event.dispatch.AbstractBubbling,construct:function(m,n){qx.event.dispatch.AbstractBubbling.call(this,m);this.__ht=m.getWindow();this.__hu=n;m.addListener(this.__ht,h,this.releaseCapture,this);m.addListener(this.__ht,g,this.releaseCapture,this);m.addListener(this.__ht,c,this.releaseCapture,this);},statics:{PRIORITY:qx.event.Registration.PRIORITY_FIRST},members:{__hu:null,__hv:null,__hw:true,__ht:null,_getParent:function(t){return t.parentNode;},canDispatchEvent:function(p,event,q){return (this.__hv&&this.__hx[q]);},dispatchEvent:function(r,event,s){if(s==f){event.stopPropagation();this.releaseCapture();return;}if(this.__hw||!qx.dom.Hierarchy.contains(this.__hv,r)){r=this.__hv;}qx.event.dispatch.AbstractBubbling.prototype.dispatchEvent.call(this,r,event,s);},__hx:{"mouseup":1,"mousedown":1,"click":1,"dblclick":1,"mousemove":1,"mouseout":1,"mouseover":1},activateCapture:function(k,l){var l=l!==false;if(this.__hv===k&&this.__hw==l){return;}if(this.__hv){this.releaseCapture();}this.nativeSetCapture(k,l);if(this.hasNativeCapture){var self=this;qx.bom.Event.addNativeListener(k,j,function(){qx.bom.Event.removeNativeListener(k,j,arguments.callee);self.releaseCapture();});}this.__hw=l;this.__hv=k;this.__hu.fireEvent(k,d,qx.event.type.Event,[true,false]);},getCaptureElement:function(){return this.__hv;},releaseCapture:function(){var v=this.__hv;if(!v){return;}this.__hv=null;this.__hu.fireEvent(v,j,qx.event.type.Event,[true,false]);this.nativeReleaseCapture(v);},hasNativeCapture:qx.bom.client.Engine.MSHTML,nativeSetCapture:qx.core.Variant.select(i,{"mshtml":function(a,b){qx.event.Timer.once(function(){a.setCapture(b!==false);},this,0);},"default":qx.lang.Function.empty}),nativeReleaseCapture:qx.core.Variant.select(i,{"mshtml":function(o){qx.event.Timer.once(function(){o.releaseCapture();},this,0);},"default":qx.lang.Function.empty})},destruct:function(){this.__hv=this.__ht=this.__hu=null;},defer:function(u){qx.event.Registration.addDispatcher(u);}});})();(function(){var c="qx.event.handler.Window";qx.Class.define(c,{extend:qx.core.Object,implement:qx.event.IEventHandler,construct:function(k){qx.core.Object.call(this);this._manager=k;this._window=k.getWindow();this._initWindowObserver();},statics:{PRIORITY:qx.event.Registration.PRIORITY_NORMAL,SUPPORTED_TYPES:{error:1,load:1,beforeunload:1,unload:1,resize:1,scroll:1,beforeshutdown:1},TARGET_CHECK:qx.event.IEventHandler.TARGET_WINDOW,IGNORE_CAN_HANDLE:true},members:{canHandleEvent:function(f,g){},registerEvent:function(s,t,u){},unregisterEvent:function(h,i,j){},_initWindowObserver:function(){this._onNativeWrapper=qx.lang.Function.listener(this._onNative,this);var m=qx.event.handler.Window.SUPPORTED_TYPES;for(var l in m){qx.bom.Event.addNativeListener(this._window,l,this._onNativeWrapper);}},_stopWindowObserver:function(){var b=qx.event.handler.Window.SUPPORTED_TYPES;for(var a in b){qx.bom.Event.removeNativeListener(this._window,a,this._onNativeWrapper);}},_onNative:qx.event.GlobalError.observeMethod(function(e){if(this.isDisposed()){return;}var o=this._window;try{var r=o.document;}catch(e){return ;}var p=r.documentElement;var n=e.target||e.srcElement;if(n==null||n===o||n===r||n===p){var event=qx.event.Registration.createEvent(e.type,qx.event.type.Native,[e,o]);qx.event.Registration.dispatchEvent(o,event);var q=event.getReturnValue();if(q!=null){e.returnValue=q;return q;}}})},destruct:function(){this._stopWindowObserver();this._manager=this._window=null;},defer:function(d){qx.event.Registration.addHandler(d);}});})();(function(){var w="qx.client",v="",u="mshtml",t="'",s="SelectionLanguage",r="qx.xml.Document",q=" />",p="MSXML2.DOMDocument.3.0",o='<\?xml version="1.0" encoding="utf-8"?>\n<',n="MSXML2.XMLHTTP.3.0",h="MSXML2.XMLHTTP.6.0",m=" xmlns='",k="text/xml",g="XPath",f="MSXML2.DOMDocument.6.0",j="HTML";qx.Class.define(r,{statics:{DOMDOC:null,XMLHTTP:null,isXmlDocument:function(E){if(E.nodeType===9){return E.documentElement.nodeName!==j;}else if(E.ownerDocument){return this.isXmlDocument(E.ownerDocument);}else{return false;}},create:qx.core.Variant.select(w,{"mshtml":function(A,B){var C=new ActiveXObject(this.DOMDOC);C.setProperty(s,g);if(B){var D=o;D+=B;if(A){D+=m+A+t;}D+=q;C.loadXML(D);}return C;},"default":function(F,G){return document.implementation.createDocument(F||v,G||v,null);}}),fromString:qx.core.Variant.select(w,{"mshtml":function(x){var y=qx.xml.Document.create();y.loadXML(x);return y;},"default":function(d){var e=new DOMParser();return e.parseFromString(d,k);}})},defer:function(a){if(qx.core.Variant.isSet(w,u)){var b=[f,p];var c=[h,n];for(var i=0,l=b.length;i<l;i++){try{new ActiveXObject(b[i]);new ActiveXObject(c[i]);}catch(z){continue;}a.DOMDOC=b[i];a.XMLHTTP=c[i];break;}}}});})();(function(){var G="visible",F="scroll",E="borderBottomWidth",D="borderTopWidth",C="left",B="borderLeftWidth",A="bottom",z="top",y="right",x="qx.bom.element.Scroll",w="borderRightWidth";qx.Class.define(x,{statics:{intoViewX:function(K,stop,L){var parent=K.parentNode;var Q=qx.dom.Node.getDocument(K);var M=Q.body;var Y,W,T;var bb,R,bc;var U,bd,bg;var be,O,X,N;var S,bf,V;var P=L===C;var ba=L===y;stop=stop?stop.parentNode:Q;while(parent&&parent!=stop){if(parent.scrollWidth>parent.clientWidth&&(parent===M||qx.bom.element.Overflow.getY(parent)!=G)){if(parent===M){W=parent.scrollLeft;T=W+qx.bom.Viewport.getWidth();bb=qx.bom.Viewport.getWidth();R=parent.clientWidth;bc=parent.scrollWidth;U=0;bd=0;bg=0;}else{Y=qx.bom.element.Location.get(parent);W=Y.left;T=Y.right;bb=parent.offsetWidth;R=parent.clientWidth;bc=parent.scrollWidth;U=parseInt(qx.bom.element.Style.get(parent,B),10)||0;bd=parseInt(qx.bom.element.Style.get(parent,w),10)||0;bg=bb-R-U-bd;}be=qx.bom.element.Location.get(K);O=be.left;X=be.right;N=K.offsetWidth;S=O-W-U;bf=X-T+bd;V=0;if(P){V=S;}else if(ba){V=bf+bg;}else if(S<0||N>R){V=S;}else if(bf>0){V=bf+bg;}parent.scrollLeft+=V;if(qx.bom.client.Engine.GECKO||qx.bom.client.Engine.OPERA){qx.event.Registration.fireNonBubblingEvent(parent,F);}}if(parent===M){break;}parent=parent.parentNode;}},intoViewY:function(a,stop,b){var parent=a.parentNode;var h=qx.dom.Node.getDocument(a);var c=h.body;var p,d,l;var r,o,j;var f,g,e;var t,u,q,k;var n,i,v;var s=b===z;var m=b===A;stop=stop?stop.parentNode:h;while(parent&&parent!=stop){if(parent.scrollHeight>parent.clientHeight&&(parent===c||qx.bom.element.Overflow.getY(parent)!=G)){if(parent===c){d=parent.scrollTop;l=d+qx.bom.Viewport.getHeight();r=qx.bom.Viewport.getHeight();o=parent.clientHeight;j=parent.scrollHeight;f=0;g=0;e=0;}else{p=qx.bom.element.Location.get(parent);d=p.top;l=p.bottom;r=parent.offsetHeight;o=parent.clientHeight;j=parent.scrollHeight;f=parseInt(qx.bom.element.Style.get(parent,D),10)||0;g=parseInt(qx.bom.element.Style.get(parent,E),10)||0;e=r-o-f-g;}t=qx.bom.element.Location.get(a);u=t.top;q=t.bottom;k=a.offsetHeight;n=u-d-f;i=q-l+g;v=0;if(s){v=n;}else if(m){v=i+e;}else if(n<0||k>o){v=n;}else if(i>0){v=i+e;}parent.scrollTop+=v;if(qx.bom.client.Engine.GECKO||qx.bom.client.Engine.OPERA){qx.event.Registration.fireNonBubblingEvent(parent,F);}}if(parent===c){break;}parent=parent.parentNode;}},intoView:function(H,stop,I,J){this.intoViewX(H,stop,I);this.intoViewY(H,stop,J);}}});})();(function(){var bO="",bN="qx.client",bM="hidden",bL="-moz-scrollbars-none",bK="overflow",bJ=";",bI="overflowY",bH=":",bG="overflowX",bF="overflow:",cb="none",ca="scroll",bY="borderLeftStyle",bX="borderRightStyle",bW="div",bV="borderRightWidth",bU="overflow-y",bT="borderLeftWidth",bS="-moz-scrollbars-vertical",bR="100px",bP="qx.bom.element.Overflow",bQ="overflow-x";qx.Class.define(bP,{statics:{__hy:null,getScrollbarWidth:function(){if(this.__hy!==null){return this.__hy;}var N=qx.bom.element.Style;var P=function(a,b){return parseInt(N.get(a,b))||0;};var Q=function(w){return (N.get(w,bX)==cb?0:P(w,bV));};var O=function(F){return (N.get(F,bY)==cb?0:P(F,bT));};var S=qx.core.Variant.select(bN,{"mshtml":function(d){if(N.get(d,bI)==bM||d.clientWidth==0){return Q(d);}return Math.max(0,d.offsetWidth-d.clientLeft-d.clientWidth);},"default":function(e){if(e.clientWidth==0){var f=N.get(e,bK);var g=(f==ca||f==bS?16:0);return Math.max(0,Q(e)+g);}return Math.max(0,(e.offsetWidth-e.clientWidth-O(e)));}});var R=function(bn){return S(bn)-Q(bn);};var t=document.createElement(bW);var s=t.style;s.height=s.width=bR;s.overflow=ca;document.body.appendChild(t);var c=R(t);this.__hy=c?c:16;document.body.removeChild(t);return this.__hy;},_compile:qx.core.Variant.select(bN,{"gecko":qx.bom.client.Engine.VERSION<1.8?function(z,A){if(A==bM){A=bL;}return bF+A+bJ;}:function(H,I){return H+bH+I+bJ;},"opera":qx.bom.client.Engine.VERSION<9.5?function(bx,by){return bF+by+bJ;}:function(J,K){return J+bH+K+bJ;},"default":function(bc,bd){return bc+bH+bd+bJ;}}),compileX:function(bo){return this._compile(bQ,bo);},compileY:function(o){return this._compile(bU,o);},getX:qx.core.Variant.select(bN,{"gecko":qx.bom.client.Engine.VERSION<1.8?function(bg,bh){var bi=qx.bom.element.Style.get(bg,bK,bh,false);if(bi===bL){bi=bM;}return bi;}:function(ba,bb){return qx.bom.element.Style.get(ba,bG,bb,false);},"opera":qx.bom.client.Engine.VERSION<9.5?function(L,M){return qx.bom.element.Style.get(L,bK,M,false);}:function(h,i){return qx.bom.element.Style.get(h,bG,i,false);},"default":function(D,E){return qx.bom.element.Style.get(D,bG,E,false);}}),setX:qx.core.Variant.select(bN,{"gecko":qx.bom.client.Engine.VERSION<1.8?function(be,bf){if(bf==bM){bf=bL;}be.style.overflow=bf;}:function(B,C){B.style.overflowX=C;},"opera":qx.bom.client.Engine.VERSION<9.5?function(T,U){T.style.overflow=U;}:function(x,y){x.style.overflowX=y;},"default":function(bj,bk){bj.style.overflowX=bk;}}),resetX:qx.core.Variant.select(bN,{"gecko":qx.bom.client.Engine.VERSION<1.8?function(cc){cc.style.overflow=bO;}:function(n){n.style.overflowX=bO;},"opera":qx.bom.client.Engine.VERSION<9.5?function(bz,bA){bz.style.overflow=bO;}:function(bt,bu){bt.style.overflowX=bO;},"default":function(v){v.style.overflowX=bO;}}),getY:qx.core.Variant.select(bN,{"gecko":qx.bom.client.Engine.VERSION<1.8?function(bC,bD){var bE=qx.bom.element.Style.get(bC,bK,bD,false);if(bE===bL){bE=bM;}return bE;}:function(bv,bw){return qx.bom.element.Style.get(bv,bI,bw,false);},"opera":qx.bom.client.Engine.VERSION<9.5?function(br,bs){return qx.bom.element.Style.get(br,bK,bs,false);}:function(j,k){return qx.bom.element.Style.get(j,bI,k,false);},"default":function(ce,cf){return qx.bom.element.Style.get(ce,bI,cf,false);}}),setY:qx.core.Variant.select(bN,{"gecko":qx.bom.client.Engine.VERSION<1.8?function(p,q){if(q===bM){q=bL;}p.style.overflow=q;}:function(r,u){r.style.overflowY=u;},"opera":qx.bom.client.Engine.VERSION<9.5?function(bp,bq){bp.style.overflow=bq;}:function(l,m){l.style.overflowY=m;},"default":function(V,W){V.style.overflowY=W;}}),resetY:qx.core.Variant.select(bN,{"gecko":qx.bom.client.Engine.VERSION<1.8?function(bB){bB.style.overflow=bO;}:function(G){G.style.overflowY=bO;},"opera":qx.bom.client.Engine.VERSION<9.5?function(X,Y){X.style.overflow=bO;}:function(bl,bm){bl.style.overflowY=bO;},"default":function(cd){cd.style.overflowY=bO;}})}});})();(function(){var w="auto",v="px",u=",",t="clip:auto;",s="rect(",r=");",q="",p=")",o="qx.bom.element.Clip",n="string",k="clip:rect(",m="clip",l="rect(auto,auto,auto,auto)",j="rect(auto, auto, auto, auto)";qx.Class.define(o,{statics:{compile:function(x){if(!x){return t;}var C=x.left;var top=x.top;var B=x.width;var A=x.height;var y,z;if(C==null){y=(B==null?w:B+v);C=w;}else{y=(B==null?w:C+B+v);C=C+v;}if(top==null){z=(A==null?w:A+v);top=w;}else{z=(A==null?w:top+A+v);top=top+v;}return k+top+u+y+u+z+u+C+r;},get:function(a,b){var d=qx.bom.element.Style.get(a,m,b,false);var i,top,g,f;var c,e;if(typeof d===n&&d!==w&&d!==q){d=qx.lang.String.trim(d);if(/\((.*)\)/.test(d)){var h=RegExp.$1.split(u);top=qx.lang.String.trim(h[0]);c=qx.lang.String.trim(h[1]);e=qx.lang.String.trim(h[2]);i=qx.lang.String.trim(h[3]);if(i===w){i=null;}if(top===w){top=null;}if(c===w){c=null;}if(e===w){e=null;}if(top!=null){top=parseInt(top,10);}if(c!=null){c=parseInt(c,10);}if(e!=null){e=parseInt(e,10);}if(i!=null){i=parseInt(i,10);}if(c!=null&&i!=null){g=c-i;}else if(c!=null){g=c;}if(e!=null&&top!=null){f=e-top;}else if(e!=null){f=e;}}else{throw new Error("Could not parse clip string: "+d);}}return {left:i||null,top:top||null,width:g||null,height:f||null};},set:function(E,F){if(!F){E.style.clip=l;return;}var K=F.left;var top=F.top;var J=F.width;var I=F.height;var G,H;if(K==null){G=(J==null?w:J+v);K=w;}else{G=(J==null?w:K+J+v);K=K+v;}if(top==null){H=(I==null?w:I+v);top=w;}else{H=(I==null?w:top+I+v);top=top+v;}E.style.clip=s+top+u+G+u+H+u+K+p;},reset:function(D){D.style.clip=j;}}});})();(function(){var k="n-resize",j="e-resize",i="nw-resize",h="ne-resize",g="",f="cursor:",e="qx.client",d=";",c="qx.bom.element.Cursor",b="cursor",a="hand";qx.Class.define(c,{statics:{__hz:qx.core.Variant.select(e,{"mshtml":{"cursor":a,"ew-resize":j,"ns-resize":k,"nesw-resize":h,"nwse-resize":i},"opera":{"col-resize":j,"row-resize":k,"ew-resize":j,"ns-resize":k,"nesw-resize":h,"nwse-resize":i},"default":{}}),compile:function(m){return f+(this.__hz[m]||m)+d;},get:function(p,q){return qx.bom.element.Style.get(p,b,q,false);},set:function(n,o){n.style.cursor=this.__hz[o]||o;},reset:function(l){l.style.cursor=g;}}});})();(function(){var x="",w="qx.client",v=";",u="opacity:",t="opacity",s="filter",r="MozOpacity",q=");",p=")",o="zoom:1;filter:alpha(opacity=",l="qx.bom.element.Opacity",n="alpha(opacity=",m="-moz-opacity:";qx.Class.define(l,{statics:{SUPPORT_CSS3_OPACITY:false,compile:qx.core.Variant.select(w,{"mshtml":function(k){if(k>=1){k=1;}if(k<0.00001){k=0;}if(qx.bom.element.Opacity.SUPPORT_CSS3_OPACITY){return u+k+v;}else{return o+(k*100)+q;}},"gecko":function(D){if(D>=1){D=0.999999;}if(!qx.bom.element.Opacity.SUPPORT_CSS3_OPACITY){return m+D+v;}else{return u+D+v;}},"default":function(L){if(L>=1){return x;}return u+L+v;}}),set:qx.core.Variant.select(w,{"mshtml":function(h,i){if(qx.bom.element.Opacity.SUPPORT_CSS3_OPACITY){if(i>=1){i=x;}h.style.opacity=i;}else{var j=qx.bom.element.Style.get(h,s,qx.bom.element.Style.COMPUTED_MODE,false);if(i>=1){i=1;}if(i<0.00001){i=0;}if(!h.currentStyle||!h.currentStyle.hasLayout){h.style.zoom=1;}h.style.filter=j.replace(/alpha\([^\)]*\)/gi,x)+n+i*100+p;}},"gecko":function(J,K){if(K>=1){K=0.999999;}if(!qx.bom.element.Opacity.SUPPORT_CSS3_OPACITY){J.style.MozOpacity=K;}else{J.style.opacity=K;}},"default":function(f,g){if(g>=1){g=x;}f.style.opacity=g;}}),reset:qx.core.Variant.select(w,{"mshtml":function(d){if(qx.bom.element.Opacity.SUPPORT_CSS3_OPACITY){d.style.opacity=x;}else{var e=qx.bom.element.Style.get(d,s,qx.bom.element.Style.COMPUTED_MODE,false);d.style.filter=e.replace(/alpha\([^\)]*\)/gi,x);}},"gecko":function(C){if(!qx.bom.element.Opacity.SUPPORT_CSS3_OPACITY){C.style.MozOpacity=x;}else{C.style.opacity=x;}},"default":function(B){B.style.opacity=x;}}),get:qx.core.Variant.select(w,{"mshtml":function(F,G){if(qx.bom.element.Opacity.SUPPORT_CSS3_OPACITY){var H=qx.bom.element.Style.get(F,t,G,false);if(H!=null){return parseFloat(H);}return 1.0;}else{var I=qx.bom.element.Style.get(F,s,G,false);if(I){var H=I.match(/alpha\(opacity=(.*)\)/);if(H&&H[1]){return parseFloat(H[1])/100;}}return 1.0;}},"gecko":function(a,b){var c=qx.bom.element.Style.get(a,!qx.bom.element.Opacity.SUPPORT_CSS3_OPACITY?r:t,b,false);if(c==0.999999){c=1.0;}if(c!=null){return parseFloat(c);}return 1.0;},"default":function(y,z){var A=qx.bom.element.Style.get(y,t,z,false);if(A!=null){return parseFloat(A);}return 1.0;}})},defer:function(E){E.SUPPORT_CSS3_OPACITY=(typeof document.documentElement.style.opacity=="string");}});})();(function(){var r="qx.client",q="",p="boxSizing",o="box-sizing",n=":",m="border-box",k="qx.bom.element.BoxSizing",j="KhtmlBoxSizing",h="-moz-box-sizing",g="WebkitBoxSizing",d=";",f="-khtml-box-sizing",e="content-box",c="-webkit-box-sizing",b="MozBoxSizing";qx.Class.define(k,{statics:{__hA:qx.core.Variant.select(r,{"mshtml":null,"webkit":[p,j,g],"gecko":[b],"opera":[p]}),__hB:qx.core.Variant.select(r,{"mshtml":null,"webkit":[o,f,c],"gecko":[h],"opera":[o]}),__hC:{tags:{button:true,select:true},types:{search:true,button:true,submit:true,reset:true,checkbox:true,radio:true}},__hD:function(s){var t=this.__hC;return t.tags[s.tagName.toLowerCase()]||t.types[s.type];},compile:qx.core.Variant.select(r,{"mshtml":function(a){{};},"default":function(w){var y=this.__hB;var x=q;if(y){for(var i=0,l=y.length;i<l;i++){x+=y[i]+n+w+d;}}return x;}}),get:qx.core.Variant.select(r,{"mshtml":function(G){if(qx.bom.Document.isStandardMode(qx.dom.Node.getDocument(G))){if(!this.__hD(G)){return e;}}return m;},"default":function(z){var B=this.__hA;var A;if(B){for(var i=0,l=B.length;i<l;i++){A=qx.bom.element.Style.get(z,B[i],null,false);if(A!=null&&A!==q){return A;}}}return q;}}),set:qx.core.Variant.select(r,{"mshtml":function(u,v){{};},"default":function(C,D){var E=this.__hA;if(E){for(var i=0,l=E.length;i<l;i++){C.style[E[i]]=D;}}}}),reset:function(F){this.set(F,q);}}});})();(function(){var F="",E="qx.client",D="userSelect",C="style",B="MozUserModify",A="px",z="float",y="borderImage",x="styleFloat",w="appearance",Y="pixelHeight",X='Ms',W=":",V="cssFloat",U="pixelTop",T="pixelLeft",S='O',R="qx.bom.element.Style",Q='Khtml',P='string',M="pixelRight",N='Moz',K="pixelWidth",L="pixelBottom",I=";",J="textOverflow",G="userModify",H='Webkit',O="WebkitUserModify";qx.Class.define(R,{statics:{__hE:function(){var k=[w,D,J,y];var p={};var m=document.documentElement.style;var q=[N,H,Q,S,X];for(var i=0,l=k.length;i<l;i++){var r=k[i];var n=r;if(m[r]){p[n]=r;continue;}r=qx.lang.String.firstUp(r);for(var j=0,s=q.length;j<s;j++){var o=q[j]+r;if(typeof m[o]==P){p[n]=o;break;}}}this.__hF=p;this.__hF[G]=qx.core.Variant.select(E,{"gecko":B,"webkit":O,"default":D});this.__hG={};for(var n in p){this.__hG[n]=this.__hK(p[n]);}this.__hF[z]=qx.core.Variant.select(E,{"mshtml":x,"default":V});},__hH:{width:K,height:Y,left:T,right:M,top:U,bottom:L},__hI:{clip:qx.bom.element.Clip,cursor:qx.bom.element.Cursor,opacity:qx.bom.element.Opacity,boxSizing:qx.bom.element.BoxSizing,overflowX:{set:qx.lang.Function.bind(qx.bom.element.Overflow.setX,qx.bom.element.Overflow),get:qx.lang.Function.bind(qx.bom.element.Overflow.getX,qx.bom.element.Overflow),reset:qx.lang.Function.bind(qx.bom.element.Overflow.resetX,qx.bom.element.Overflow),compile:qx.lang.Function.bind(qx.bom.element.Overflow.compileX,qx.bom.element.Overflow)},overflowY:{set:qx.lang.Function.bind(qx.bom.element.Overflow.setY,qx.bom.element.Overflow),get:qx.lang.Function.bind(qx.bom.element.Overflow.getY,qx.bom.element.Overflow),reset:qx.lang.Function.bind(qx.bom.element.Overflow.resetY,qx.bom.element.Overflow),compile:qx.lang.Function.bind(qx.bom.element.Overflow.compileY,qx.bom.element.Overflow)}},compile:function(ba){var bc=[];var be=this.__hI;var bd=this.__hG;var name,bb;for(name in ba){bb=ba[name];if(bb==null){continue;}name=bd[name]||name;if(be[name]){bc.push(be[name].compile(bb));}else{bc.push(this.__hK(name),W,bb,I);}}return bc.join(F);},__hJ:{},__hK:function(bi){var bj=this.__hJ;var bk=bj[bi];if(!bk){bk=bj[bi]=qx.lang.String.hyphenate(bi);}return bk;},setCss:qx.core.Variant.select(E,{"mshtml":function(bB,bC){bB.style.cssText=bC;},"default":function(bg,bh){bg.setAttribute(C,bh);}}),getCss:qx.core.Variant.select(E,{"mshtml":function(bf){return bf.style.cssText.toLowerCase();},"default":function(bq){return bq.getAttribute(C);}}),isPropertySupported:function(bD){return (this.__hI[bD]||this.__hF[bD]||bD in document.documentElement.style);},COMPUTED_MODE:1,CASCADED_MODE:2,LOCAL_MODE:3,set:function(t,name,u,v){{};name=this.__hF[name]||name;if(v!==false&&this.__hI[name]){return this.__hI[name].set(t,u);}else{t.style[name]=u!==null?u:F;}},setStyles:function(a,b,c){{};var f=this.__hF;var h=this.__hI;var d=a.style;for(var g in b){var e=b[g];var name=f[g]||g;if(e===undefined){if(c!==false&&h[name]){h[name].reset(a);}else{d[name]=F;}}else{if(c!==false&&h[name]){h[name].set(a,e);}else{d[name]=e!==null?e:F;}}}},reset:function(br,name,bs){name=this.__hF[name]||name;if(bs!==false&&this.__hI[name]){return this.__hI[name].reset(br);}else{br.style[name]=F;}},get:qx.core.Variant.select(E,{"mshtml":function(bt,name,bu,bv){name=this.__hF[name]||name;if(bv!==false&&this.__hI[name]){return this.__hI[name].get(bt,bu);}if(!bt.currentStyle){return bt.style[name]||F;}switch(bu){case this.LOCAL_MODE:return bt.style[name]||F;case this.CASCADED_MODE:return bt.currentStyle[name]||F;default:var bz=bt.currentStyle[name]||F;if(/^-?[\.\d]+(px)?$/i.test(bz)){return bz;}var by=this.__hH[name];if(by){var bw=bt.style[name];bt.style[name]=bz||0;var bx=bt.style[by]+A;bt.style[name]=bw;return bx;}if(/^-?[\.\d]+(em|pt|%)?$/i.test(bz)){throw new Error("Untranslated computed property value: "+name+". Only pixel values work well across different clients.");}return bz;}},"default":function(bl,name,bm,bn){name=this.__hF[name]||name;if(bn!==false&&this.__hI[name]){return this.__hI[name].get(bl,bm);}switch(bm){case this.LOCAL_MODE:return bl.style[name]||F;case this.CASCADED_MODE:if(bl.currentStyle){return bl.currentStyle[name]||F;}throw new Error("Cascaded styles are not supported in this browser!");default:var bo=qx.dom.Node.getDocument(bl);var bp=bo.defaultView.getComputedStyle(bl,null);return bp?bp[name]:F;}}})},defer:function(bA){bA.__hE();}});})();(function(){var bp="borderTopWidth",bo="borderLeftWidth",bn="marginTop",bm="marginLeft",bl="scroll",bk="qx.client",bj="border-box",bi="borderBottomWidth",bh="borderRightWidth",bg="auto",bE="padding",bD="qx.bom.element.Location",bC="paddingLeft",bB="static",bA="marginBottom",bz="visible",by="BODY",bx="paddingBottom",bw="paddingTop",bv="marginRight",bt="position",bu="margin",br="overflow",bs="paddingRight",bq="border";qx.Class.define(bD,{statics:{__hL:function(u,v){return qx.bom.element.Style.get(u,v,qx.bom.element.Style.COMPUTED_MODE,false);},__hM:function(J,K){return parseInt(qx.bom.element.Style.get(J,K,qx.bom.element.Style.COMPUTED_MODE,false),10)||0;},__hN:function(bG){var bJ=0,top=0;if(bG.getBoundingClientRect&&!qx.bom.client.Engine.OPERA){var bI=qx.dom.Node.getWindow(bG);bJ-=qx.bom.Viewport.getScrollLeft(bI);top-=qx.bom.Viewport.getScrollTop(bI);}else{var bH=qx.dom.Node.getDocument(bG).body;bG=bG.parentNode;while(bG&&bG!=bH){bJ+=bG.scrollLeft;top+=bG.scrollTop;bG=bG.parentNode;}}return {left:bJ,top:top};},__hO:qx.core.Variant.select(bk,{"mshtml":function(w){var y=qx.dom.Node.getDocument(w);var x=y.body;var z=0;var top=0;z-=x.clientLeft+y.documentElement.clientLeft;top-=x.clientTop+y.documentElement.clientTop;if(qx.bom.client.Feature.STANDARD_MODE){z+=this.__hM(x,bo);top+=this.__hM(x,bp);}return {left:z,top:top};},"webkit":function(bK){var bM=qx.dom.Node.getDocument(bK);var bL=bM.body;var bN=bL.offsetLeft;var top=bL.offsetTop;if(qx.bom.client.Engine.VERSION<530.17){bN+=this.__hM(bL,bo);top+=this.__hM(bL,bp);}return {left:bN,top:top};},"gecko":function(a){var b=qx.dom.Node.getDocument(a).body;var c=b.offsetLeft;var top=b.offsetTop;if(qx.bom.client.Engine.VERSION<1.9){c+=this.__hM(b,bm);top+=this.__hM(b,bn);}if(qx.bom.element.BoxSizing.get(b)!==bj){c+=this.__hM(b,bo);top+=this.__hM(b,bp);}return {left:c,top:top};},"default":function(V){var W=qx.dom.Node.getDocument(V).body;var X=W.offsetLeft;var top=W.offsetTop;return {left:X,top:top};}}),__hP:qx.core.Variant.select(bk,{"mshtml|webkit":function(C){var E=qx.dom.Node.getDocument(C);if(C.getBoundingClientRect){var F=C.getBoundingClientRect();var G=F.left;var top=F.top;}else{var G=C.offsetLeft;var top=C.offsetTop;C=C.offsetParent;var D=E.body;while(C&&C!=D){G+=C.offsetLeft;top+=C.offsetTop;G+=this.__hM(C,bo);top+=this.__hM(C,bp);C=C.offsetParent;}}return {left:G,top:top};},"gecko":function(Y){if(Y.getBoundingClientRect){var bc=Y.getBoundingClientRect();var bd=Math.round(bc.left);var top=Math.round(bc.top);}else{var bd=0;var top=0;var ba=qx.dom.Node.getDocument(Y).body;var bb=qx.bom.element.BoxSizing;if(bb.get(Y)!==bj){bd-=this.__hM(Y,bo);top-=this.__hM(Y,bp);}while(Y&&Y!==ba){bd+=Y.offsetLeft;top+=Y.offsetTop;if(bb.get(Y)!==bj){bd+=this.__hM(Y,bo);top+=this.__hM(Y,bp);}if(Y.parentNode&&this.__hL(Y.parentNode,br)!=bz){bd+=this.__hM(Y.parentNode,bo);top+=this.__hM(Y.parentNode,bp);}Y=Y.offsetParent;}}return {left:bd,top:top};},"default":function(O){var Q=0;var top=0;var P=qx.dom.Node.getDocument(O).body;while(O&&O!==P){Q+=O.offsetLeft;top+=O.offsetTop;O=O.offsetParent;}return {left:Q,top:top};}}),get:function(l,m){if(l.tagName==by){var location=this.__hQ(l);var t=location.left;var top=location.top;}else{var n=this.__hO(l);var s=this.__hP(l);var scroll=this.__hN(l);var t=s.left+n.left-scroll.left;var top=s.top+n.top-scroll.top;}var o=t+l.offsetWidth;var p=top+l.offsetHeight;if(m){if(m==bE||m==bl){var q=qx.bom.element.Overflow.getX(l);if(q==bl||q==bg){o+=l.scrollWidth-l.offsetWidth+this.__hM(l,bo)+this.__hM(l,bh);}var r=qx.bom.element.Overflow.getY(l);if(r==bl||r==bg){p+=l.scrollHeight-l.offsetHeight+this.__hM(l,bp)+this.__hM(l,bi);}}switch(m){case bE:t+=this.__hM(l,bC);top+=this.__hM(l,bw);o-=this.__hM(l,bs);p-=this.__hM(l,bx);case bl:t-=l.scrollLeft;top-=l.scrollTop;o-=l.scrollLeft;p-=l.scrollTop;case bq:t+=this.__hM(l,bo);top+=this.__hM(l,bp);o-=this.__hM(l,bh);p-=this.__hM(l,bi);break;case bu:t-=this.__hM(l,bm);top-=this.__hM(l,bn);o+=this.__hM(l,bv);p+=this.__hM(l,bA);break;}}return {left:t,top:top,right:o,bottom:p};},__hQ:qx.core.Variant.select(bk,{"default":function(R){var top=R.offsetTop+this.__hM(R,bn);var S=R.offsetLeft+this.__hM(R,bm);return {left:S,top:top};},"mshtml":function(T){var top=T.offsetTop;var U=T.offsetLeft;if(!((qx.bom.client.Engine.VERSION<8||qx.bom.client.Engine.DOCUMENT_MODE<8)&&!qx.bom.client.Feature.QUIRKS_MODE)){top+=this.__hM(T,bn);U+=this.__hM(T,bm);}return {left:U,top:top};},"gecko":function(be){var top=be.offsetTop+this.__hM(be,bn)+this.__hM(be,bo);var bf=be.offsetLeft+this.__hM(be,bm)+this.__hM(be,bp);return {left:bf,top:top};}}),getLeft:function(bO,bP){return this.get(bO,bP).left;},getTop:function(H,I){return this.get(H,I).top;},getRight:function(A,B){return this.get(A,B).right;},getBottom:function(d,e){return this.get(d,e).bottom;},getRelative:function(f,g,h,i){var k=this.get(f,h);var j=this.get(g,i);return {left:k.left-j.left,top:k.top-j.top,right:k.right-j.right,bottom:k.bottom-j.bottom};},getPosition:function(bF){return this.getRelative(bF,this.getOffsetParent(bF));},getOffsetParent:function(L){var N=L.offsetParent||document.body;var M=qx.bom.element.Style;while(N&&(!/^body|html$/i.test(N.tagName)&&M.get(N,bt)===bB)){N=N.offsetParent;}return N;}}});})();(function(){var d="qx.ui.core.queue.Widget",c="widget";qx.Class.define(d,{statics:{__hR:{},remove:function(e){delete this.__hR[e.$$hash];},add:function(a){var b=this.__hR;if(b[a.$$hash]){return;}b[a.$$hash]=a;qx.ui.core.queue.Manager.scheduleFlush(c);},flush:function(){var f=this.__hR;var h;for(var g in f){h=f[g];delete f[g];h.syncWidget();}for(var g in f){return;}this.__hR={};}}});})();(function(){var i="qx.ui.core.queue.Visibility",h="visibility";qx.Class.define(i,{statics:{__hS:{},__hT:{},remove:function(a){var b=a.$$hash;delete this.__hT[b];delete this.__hS[b];},isVisible:function(n){return this.__hT[n.$$hash]||false;},__hU:function(j){var l=this.__hT;var k=j.$$hash;var m;if(j.isExcluded()){m=false;}else{var parent=j.$$parent;if(parent){m=this.__hU(parent);}else{m=j.isRootWidget();}}return l[k]=m;},add:function(o){var p=this.__hS;if(p[o.$$hash]){return;}p[o.$$hash]=o;qx.ui.core.queue.Manager.scheduleFlush(h);},flush:function(){var c=this.__hS;var g=this.__hT;for(var d in c){if(g[d]!=null){c[d].addChildrenToQueue(c);}}var f={};for(var d in c){f[d]=g[d];g[d]=null;}for(var d in c){var e=c[d];delete c[d];if(g[d]==null){this.__hU(e);}if(g[d]&&g[d]!=f[d]){e.checkAppearanceNeeds();}}this.__hS={};}}});})();(function(){var b="appearance",a="qx.ui.core.queue.Appearance";qx.Class.define(a,{statics:{__hV:{},remove:function(e){delete this.__hV[e.$$hash];},add:function(c){var d=this.__hV;if(d[c.$$hash]){return;}d[c.$$hash]=c;qx.ui.core.queue.Manager.scheduleFlush(b);},has:function(j){return !!this.__hV[j.$$hash];},flush:function(){var i=qx.ui.core.queue.Visibility;var f=this.__hV;var h;for(var g in f){h=f[g];delete f[g];if(i.isVisible(h)){h.syncAppearance();}else{h.$$stateChanges=true;}}}}});})();(function(){var b="dispose",a="qx.ui.core.queue.Dispose";qx.Class.define(a,{statics:{__hW:{},add:function(c){var d=this.__hW;if(d[c.$$hash]){return;}d[c.$$hash]=c;qx.ui.core.queue.Manager.scheduleFlush(b);},flush:function(){var e=this.__hW;for(var g in e){var f=e[g];delete e[g];f.dispose();}for(var g in e){return;}this.__hW={};}}});})();(function(){var r="ready",q="qx.client",p="mshtml",o="load",n="unload",m="qx.event.handler.Application",l="complete",k="qx.application",j="gecko|opera|webkit",i="left",g="DOMContentLoaded",h="shutdown";qx.Class.define(m,{extend:qx.core.Object,implement:qx.event.IEventHandler,construct:function(z){qx.core.Object.call(this);this._window=z.getWindow();this.__hX=false;this.__hY=false;this._initObserver();qx.event.handler.Application.$$instance=this;},statics:{PRIORITY:qx.event.Registration.PRIORITY_NORMAL,SUPPORTED_TYPES:{ready:1,shutdown:1},TARGET_CHECK:qx.event.IEventHandler.TARGET_WINDOW,IGNORE_CAN_HANDLE:true,onScriptLoaded:function(){var s=qx.event.handler.Application.$$instance;if(s){s.__ic();}}},members:{canHandleEvent:function(d,f){},registerEvent:function(t,u,v){},unregisterEvent:function(w,x,y){},__ia:null,__hX:null,__hY:null,__ib:null,__ic:function(){if(!this.__ia&&this.__hX&&qx.$$loader.scriptLoaded){try{var c=qx.core.Setting.get(k);if(!qx.Class.getByName(c)){return;}}catch(e){}if(qx.core.Variant.isSet(q,p)){if(qx.event.Registration.hasListener(this._window,r)){this.__ia=true;qx.event.Registration.fireEvent(this._window,r);}}else{this.__ia=true;qx.event.Registration.fireEvent(this._window,r);}}},isApplicationReady:function(){return this.__ia;},_initObserver:function(){if(qx.$$domReady||document.readyState==l||document.readyState==r){this.__hX=true;this.__ic();}else{this._onNativeLoadWrapped=qx.lang.Function.bind(this._onNativeLoad,this);if(qx.core.Variant.isSet(q,j)){qx.bom.Event.addNativeListener(this._window,g,this._onNativeLoadWrapped);}else if(qx.core.Variant.isSet(q,p)){var self=this;var b=function(){try{document.documentElement.doScroll(i);if(document.body){self._onNativeLoadWrapped();}}catch(a){window.setTimeout(b,100);}};b();}qx.bom.Event.addNativeListener(this._window,o,this._onNativeLoadWrapped);}this._onNativeUnloadWrapped=qx.lang.Function.bind(this._onNativeUnload,this);qx.bom.Event.addNativeListener(this._window,n,this._onNativeUnloadWrapped);},_stopObserver:function(){if(this._onNativeLoadWrapped){qx.bom.Event.removeNativeListener(this._window,o,this._onNativeLoadWrapped);}qx.bom.Event.removeNativeListener(this._window,n,this._onNativeUnloadWrapped);this._onNativeLoadWrapped=null;this._onNativeUnloadWrapped=null;},_onNativeLoad:qx.event.GlobalError.observeMethod(function(){this.__hX=true;this.__ic();}),_onNativeUnload:qx.event.GlobalError.observeMethod(function(){if(!this.__ib){this.__ib=true;try{qx.event.Registration.fireEvent(this._window,h);}catch(e){throw e;}finally{qx.core.ObjectRegistry.shutdown();}}})},destruct:function(){this._stopObserver();this._window=null;},defer:function(A){qx.event.Registration.addHandler(A);}});})();(function(){var j="ready",i="qx.application",h="beforeunload",g="qx.core.Init",f="shutdown";qx.Class.define(g,{statics:{getApplication:function(){return this.__id||null;},ready:function(){if(this.__id){return;}if(qx.bom.client.Engine.UNKNOWN_ENGINE){qx.log.Logger.warn("Could not detect engine!");}if(qx.bom.client.Engine.UNKNOWN_VERSION){qx.log.Logger.warn("Could not detect the version of the engine!");}if(qx.bom.client.Platform.UNKNOWN_PLATFORM){qx.log.Logger.warn("Could not detect platform!");}if(qx.bom.client.System.UNKNOWN_SYSTEM){qx.log.Logger.warn("Could not detect system!");}qx.log.Logger.debug(this,"Load runtime: "+(new Date-qx.Bootstrap.LOADSTART)+"ms");var c=qx.core.Setting.get(i);var d=qx.Class.getByName(c);if(d){this.__id=new d;var b=new Date;this.__id.main();qx.log.Logger.debug(this,"Main runtime: "+(new Date-b)+"ms");var b=new Date;this.__id.finalize();qx.log.Logger.debug(this,"Finalize runtime: "+(new Date-b)+"ms");}else{qx.log.Logger.warn("Missing application class: "+c);}},__ie:function(e){var l=this.__id;if(l){e.setReturnValue(l.close());}},__if:function(){var a=this.__id;if(a){a.terminate();}}},defer:function(k){qx.event.Registration.addListener(window,j,k.ready,k);qx.event.Registration.addListener(window,f,k.__if,k);qx.event.Registration.addListener(window,h,k.__ie,k);}});})();(function(){var n="object",m="_applyTheme",l="__ig",k="qx.theme.manager.Decoration",j="Theme",i="changeTheme",h="string",g="singleton";qx.Class.define(k,{type:g,extend:qx.core.Object,properties:{theme:{check:j,nullable:true,apply:m,event:i}},members:{__ig:null,resolve:function(a){if(!a){return null;}if(typeof a===n){return a;}var d=this.getTheme();if(!d){return null;}var d=this.getTheme();if(!d){return null;}var e=this.__ig;if(!e){e=this.__ig={};}var b=e[a];if(b){return b;}var c=d.decorations[a];if(!c){return null;}var f=c.decorator;if(f==null){throw new Error("Missing definition of which decorator to use in entry: "+a+"!");}return e[a]=(new f).set(c.style);},isValidPropertyValue:function(o){if(typeof o===h){return this.isDynamic(o);}else if(typeof o===n){var p=o.constructor;return qx.Class.hasInterface(p,qx.ui.decoration.IDecorator);}return false;},isDynamic:function(q){if(!q){return false;}var r=this.getTheme();if(!r){return false;}return !!r.decorations[q];},_applyTheme:function(s,t){var v=qx.util.AliasManager.getInstance();if(t){for(var u in t.aliases){v.remove(u);}}if(s){for(var u in s.aliases){v.add(u,s.aliases[u]);}}if(!s){this.__ig={};}}},destruct:function(){this._disposeMap(l);}});})();(function(){var c="qx.ui.decoration.IDecorator";qx.Interface.define(c,{members:{getMarkup:function(){},resize:function(d,e,f){},tint:function(a,b){},getInsets:function(){}}});})();(function(){var d="qx.util.ValueManager",c="abstract";qx.Class.define(d,{type:c,extend:qx.core.Object,construct:function(){qx.core.Object.call(this);this._dynamic={};},members:{_dynamic:null,resolveDynamic:function(e){return this._dynamic[e];},isDynamic:function(f){return !!this._dynamic[f];},resolve:function(b){if(b&&this._dynamic[b]){return this._dynamic[b];}return b;},_setDynamic:function(a){this._dynamic=a;},_getDynamic:function(){return this._dynamic;}},destruct:function(){this._dynamic=null;}});})();(function(){var l="/",k="0",j="qx/static",i="http://",h="https://",g="file://",f="qx.util.AliasManager",e="singleton",d=".",c="static";qx.Class.define(f,{type:e,extend:qx.util.ValueManager,construct:function(){qx.util.ValueManager.call(this);this.__ih={};this.add(c,j);},members:{__ih:null,_preprocess:function(m){var p=this._getDynamic();if(p[m]===false){return m;}else if(p[m]===undefined){if(m.charAt(0)===l||m.charAt(0)===d||m.indexOf(i)===0||m.indexOf(h)===k||m.indexOf(g)===0){p[m]=false;return m;}if(this.__ih[m]){return this.__ih[m];}var o=m.substring(0,m.indexOf(l));var n=this.__ih[o];if(n!==undefined){p[m]=n+m.substring(o.length);}}return m;},add:function(q,r){this.__ih[q]=r;var t=this._getDynamic();for(var s in t){if(s.substring(0,s.indexOf(l))===q){t[s]=r+s.substring(q.length);}}},remove:function(u){delete this.__ih[u];},resolve:function(a){var b=this._getDynamic();if(a!=null){a=this._preprocess(a);}return b[a]||a;}},destruct:function(){this.__ih=null;}});})();(function(){var d="none",c="qx.html.Decorator",b="absolute";qx.Class.define(c,{extend:qx.html.Element,construct:function(g,h){var i={position:b,top:0,left:0};if(qx.bom.client.Feature.CSS_POINTER_EVENTS){i.pointerEvents=d;}qx.html.Element.call(this,null,i);this.__ii=g;this.__ij=h||g.toHashCode();this.useMarkup(g.getMarkup());},members:{__ij:null,__ii:null,getId:function(){return this.__ij;},getDecorator:function(){return this.__ii;},resize:function(e,f){this.__ii.resize(this.getDomElement(),e,f);},tint:function(a){this.__ii.tint(this.getDomElement(),a);},getInsets:function(){return this.__ii.getInsets();}},destruct:function(){this.__ii=null;}});})();(function(){var h="blur",g="focus",f="input",e="load",d="qx.ui.core.EventHandler",c="activate";qx.Class.define(d,{extend:qx.core.Object,implement:qx.event.IEventHandler,construct:function(){qx.core.Object.call(this);this.__ik=qx.event.Registration.getManager(window);},statics:{PRIORITY:qx.event.Registration.PRIORITY_FIRST,SUPPORTED_TYPES:{mousemove:1,mouseover:1,mouseout:1,mousedown:1,mouseup:1,click:1,dblclick:1,contextmenu:1,mousewheel:1,keyup:1,keydown:1,keypress:1,keyinput:1,capture:1,losecapture:1,focusin:1,focusout:1,focus:1,blur:1,activate:1,deactivate:1,appear:1,disappear:1,dragstart:1,dragend:1,dragover:1,dragleave:1,drop:1,drag:1,dragchange:1,droprequest:1},IGNORE_CAN_HANDLE:false},members:{__ik:null,__il:{focusin:1,focusout:1,focus:1,blur:1},__im:{mouseover:1,mouseout:1,appear:1,disappear:1},canHandleEvent:function(a,b){return a instanceof qx.ui.core.Widget;},_dispatchEvent:function(s){var x=s.getTarget();var w=qx.ui.core.Widget.getWidgetByElement(x);var y=false;while(w&&w.isAnonymous()){var y=true;w=w.getLayoutParent();}if(w&&y&&s.getType()==c){w.getContainerElement().activate();}if(this.__il[s.getType()]){w=w&&w.getFocusTarget();if(!w){return;}}if(s.getRelatedTarget){var F=s.getRelatedTarget();var E=qx.ui.core.Widget.getWidgetByElement(F);while(E&&E.isAnonymous()){E=E.getLayoutParent();}if(E){if(this.__il[s.getType()]){E=E.getFocusTarget();}if(E===w){return;}}}var A=s.getCurrentTarget();var C=qx.ui.core.Widget.getWidgetByElement(A);if(!C||C.isAnonymous()){return;}if(this.__il[s.getType()]){C=C.getFocusTarget();}var D=s.getType();if(!C||!(C.isEnabled()||this.__im[D])){return;}var t=s.getEventPhase()==qx.event.type.Event.CAPTURING_PHASE;var z=this.__ik.getListeners(C,D,t);if(!z||z.length===0){return;}var u=qx.event.Pool.getInstance().getObject(s.constructor);s.clone(u);u.setTarget(w);u.setRelatedTarget(E||null);u.setCurrentTarget(C);var G=s.getOriginalTarget();if(G){var v=qx.ui.core.Widget.getWidgetByElement(G);while(v&&v.isAnonymous()){v=v.getLayoutParent();}u.setOriginalTarget(v);}else{u.setOriginalTarget(x);}for(var i=0,l=z.length;i<l;i++){var B=z[i].context||C;z[i].handler.call(B,u);}if(u.getPropagationStopped()){s.stopPropagation();}if(u.getDefaultPrevented()){s.preventDefault();}qx.event.Pool.getInstance().poolObject(u);},registerEvent:function(j,k,m){var n;if(k===g||k===h){n=j.getFocusElement();}else if(k===e||k===f){n=j.getContentElement();}else{n=j.getContainerElement();}if(n){n.addListener(k,this._dispatchEvent,this,m);}},unregisterEvent:function(o,p,q){var r;if(p===g||p===h){r=o.getFocusElement();}else if(p===e||p===f){r=o.getContentElement();}else{r=o.getContainerElement();}if(r){r.removeListener(p,this._dispatchEvent,this,q);}}},destruct:function(){this.__ik=null;},defer:function(H){qx.event.Registration.addHandler(H);}});})();(function(){var m="",l="/",k="mshtml",j="qx.client",i="//",h="?",g="string",f="qx.util.ResourceManager",e="singleton";qx.Class.define(f,{extend:qx.core.Object,type:e,statics:{__in:qx.$$resources||{},__io:{}},members:{has:function(w){return !!this.self(arguments).__in[w];},getData:function(r){return this.self(arguments).__in[r]||null;},getImageWidth:function(n){var o=this.self(arguments).__in[n];return o?o[0]:null;},getImageHeight:function(c){var d=this.self(arguments).__in[c];return d?d[1]:null;},getImageFormat:function(p){var q=this.self(arguments).__in[p];return q?q[2]:null;},isClippedImage:function(a){var b=this.self(arguments).__in[a];return b&&b.length>4;},toUri:function(s){if(s==null){return s;}var t=this.self(arguments).__in[s];if(!t){return s;}if(typeof t===g){var v=t;}else{var v=t[3];if(!v){return s;}}var u=m;if(qx.core.Variant.isSet(j,k)&&qx.bom.client.Feature.SSL){u=this.self(arguments).__io[v];}return u+qx.$$libraries[v].resourceUri+l+s;}},defer:function(x){if(qx.core.Variant.isSet(j,k)){if(qx.bom.client.Feature.SSL){for(var B in qx.$$libraries){var z;if(qx.$$libraries[B].resourceUri){z=qx.$$libraries[B].resourceUri;}else{x.__io[B]=m;continue;}if(z.match(/^\/\//)!=null){x.__io[B]=window.location.protocol;}else if(z.match(/^\//)!=null){x.__io[B]=window.location.protocol+i+window.location.host;}else if(z.match(/^\.\//)!=null){var y=document.URL;x.__io[B]=y.substring(0,y.lastIndexOf(l)+1);}else if(z.match(/^http/)!=null){x.__io[B]=m;}else{var C=window.location.href.indexOf(h);var A;if(C==-1){A=window.location.href;}else{A=window.location.href.substring(0,C);}x.__io[B]=A.substring(0,A.lastIndexOf(l)+1);}}}}}});})();(function(){var c="qx.bom.client.Locale",b="-",a="";qx.Class.define(c,{statics:{LOCALE:"",VARIANT:"",__ip:function(){var e=(navigator.userLanguage||navigator.language).toLowerCase();var g=a;var f=e.indexOf(b);if(f!=-1){g=e.substr(f+1);e=e.substr(0,f);}this.LOCALE=e;this.VARIANT=g;}},defer:function(d){d.__ip();}});})();(function(){var w="",v='indexOf',u='slice',t='concat',s='toLocaleLowerCase',r="qx.type.BaseString",q='match',p='toLocaleUpperCase',o='search',n='replace',f='toLowerCase',m='charCodeAt',j='split',e='substring',d='lastIndexOf',h='substr',g='toUpperCase',k='charAt';qx.Class.define(r,{extend:Object,construct:function(x){var x=x||w;this.__iq=x;this.length=x.length;},members:{$$isString:true,length:0,__iq:null,toString:function(){return this.__iq;},charAt:null,valueOf:null,charCodeAt:null,concat:null,indexOf:null,lastIndexOf:null,match:null,replace:null,search:null,slice:null,split:null,substr:null,substring:null,toLowerCase:null,toUpperCase:null,toHashCode:function(){return qx.core.ObjectRegistry.toHashCode(this);},toLocaleLowerCase:null,toLocaleUpperCase:null,base:function(y,z){return qx.core.Object.prototype.base.apply(this,arguments);}},defer:function(a,b){{};var c=[k,m,t,v,d,q,n,o,u,j,h,e,f,g,s,p];b.valueOf=b.toString;if(new a(w).valueOf()==null){delete b.valueOf;}for(var i=0,l=c.length;i<l;i++){b[c[i]]=String.prototype[c[i]];}}});})();(function(){var a="qx.locale.LocalizedString";qx.Class.define(a,{extend:qx.type.BaseString,construct:function(b,c,d){qx.type.BaseString.call(this,b);this.__ir=c;this.__is=d;},members:{__ir:null,__is:null,translate:function(){return qx.locale.Manager.getInstance().translate(this.__ir,this.__is);}}});})();(function(){var t="_",s="",r="_applyLocale",q="changeLocale",p="C",o="qx.dynlocale",n="on",m="qx.locale.Manager",l="String",k="singleton";qx.Class.define(m,{type:k,extend:qx.core.Object,construct:function(){qx.core.Object.call(this);this.__it=qx.$$translations||{};this.__iu=qx.$$locales||{};var w=qx.bom.client.Locale;var u=w.LOCALE;var v=w.VARIANT;if(v!==s){u+=t+v;}this.__iv=u;this.setLocale(u||this.__iw);},statics:{tr:function(C,D){var E=qx.lang.Array.fromArguments(arguments);E.splice(0,1);return qx.locale.Manager.getInstance().translate(C,E);},trn:function(e,f,g,h){var j=qx.lang.Array.fromArguments(arguments);j.splice(0,3);if(g!=1){return qx.locale.Manager.getInstance().translate(f,j);}else{return qx.locale.Manager.getInstance().translate(e,j);}},trc:function(ba,bb,bc){var bd=qx.lang.Array.fromArguments(arguments);bd.splice(0,2);return qx.locale.Manager.getInstance().translate(bb,bd);},marktr:function(bg){return bg;}},properties:{locale:{check:l,nullable:true,apply:r,event:q}},members:{__iw:p,__ix:null,__iy:null,__it:null,__iu:null,__iv:null,getLanguage:function(){return this.__iy;},getTerritory:function(){return this.getLocale().split(t)[1]||s;},getAvailableLocales:function(){var bf=[];for(var be in this.__iu){if(be!=this.__iw){bf.push(be);}}return bf;},__iz:function(z){var B;var A=z.indexOf(t);if(A==-1){B=z;}else{B=z.substring(0,A);}return B;},_applyLocale:function(x,y){{};this.__ix=x;this.__iy=this.__iz(x);},addTranslation:function(N,O){var P=this.__it;if(P[N]){for(var Q in O){P[N][Q]=O[Q];}}else{P[N]=O;}},addLocale:function(a,b){var c=this.__iu;if(c[a]){for(var d in b){c[a][d]=b[d];}}else{c[a]=b;}},translate:function(J,K,L){var M=this.__it;return this.__iA(M,J,K,L);},localize:function(F,G,H){var I=this.__iu;return this.__iA(I,F,G,H);},__iA:function(R,S,T,U){var V;if(!R){return S;}if(U){var X=this.__iz(U);}else{U=this.__ix;X=this.__iy;}if(!V&&R[U]){V=R[U][S];}if(!V&&R[X]){V=R[X][S];}if(!V&&R[this.__iw]){V=R[this.__iw][S];}if(!V){V=S;}if(T.length>0){var W=[];for(var i=0;i<T.length;i++){var Y=T[i];if(Y&&Y.translate){W[i]=Y.translate();}else{W[i]=Y;}}V=qx.lang.String.format(V,W);}if(qx.core.Variant.isSet(o,n)){V=new qx.locale.LocalizedString(V,S,T);}return V;}},destruct:function(){this.__it=this.__iu=null;}});})();(function(){var W="px",V="qx.client",U="div",T="img",S="",R="no-repeat",Q="scale-x",P="mshtml",O="scale",N="scale-y",bu="qx/icon",bt="repeat",bs=".png",br="crop",bq="progid:DXImageTransform.Microsoft.AlphaImageLoader(src='",bp='<div style="',bo="repeat-y",bn='<img src="',bm="qx.bom.element.Decoration",bl="', sizingMethod='",be="png",bf="')",bc='"></div>',bd='"/>',ba='" style="',bb="none",X="webkit",Y=" ",bh="repeat-x",bi="DXImageTransform.Microsoft.AlphaImageLoader",bk="qx/static/blank.gif",bj="absolute";qx.Class.define(bm,{statics:{DEBUG:false,__iB:{},__iC:qx.core.Variant.isSet(V,P),__iD:qx.core.Variant.select(V,{"mshtml":{"scale-x":true,"scale-y":true,"scale":true,"no-repeat":true},"default":null}),__iE:{"scale-x":T,"scale-y":T,"scale":T,"repeat":U,"no-repeat":U,"repeat-x":U,"repeat-y":U},update:function(t,u,v,w){var y=this.getTagName(v,u);if(y!=t.tagName.toLowerCase()){throw new Error("Image modification not possible because elements could not be replaced at runtime anymore!");}var z=this.getAttributes(u,v,w);if(y===T){t.src=z.src||qx.util.ResourceManager.getInstance().toUri(bk);}if(t.style.backgroundPosition!=S&&z.style.backgroundPosition===undefined){z.style.backgroundPosition=null;}if(t.style.clip!=S&&z.style.clip===undefined){z.style.clip=null;}var x=qx.bom.element.Style;x.setStyles(t,z.style);if(this.__iC){try{t.filters[bi].apply();}catch(e){}}},create:function(bz,bA,bB){var bC=this.getTagName(bA,bz);var bE=this.getAttributes(bz,bA,bB);var bD=qx.bom.element.Style.compile(bE.style);if(bC===T){return bn+bE.src+ba+bD+bd;}else{return bp+bD+bc;}},getTagName:function(E,F){if(qx.core.Variant.isSet(V,P)){if(F&&this.__iC&&this.__iD[E]&&qx.lang.String.endsWith(F,bs)){return U;}}return this.__iE[E];},getAttributes:function(bV,bW,bX){if(!bX){bX={};}if(!bX.position){bX.position=bj;}if(qx.core.Variant.isSet(V,P)){bX.fontSize=0;bX.lineHeight=0;}else if(qx.core.Variant.isSet(V,X)){bX.WebkitUserDrag=bb;}var ca=qx.util.ResourceManager.getInstance().getImageFormat(bV)||qx.io.ImageLoader.getFormat(bV);{};var bY;if(this.__iC&&this.__iD[bW]&&ca===be){bY=this.__iH(bX,bW,bV);}else{if(bW===O){bY=this.__iI(bX,bW,bV);}else if(bW===Q||bW===N){bY=this.__iJ(bX,bW,bV);}else{bY=this.__iM(bX,bW,bV);}}return bY;},__iF:function(bS,bT,bU){if(bS.width==null&&bT!=null){bS.width=bT+W;}if(bS.height==null&&bU!=null){bS.height=bU+W;}return bS;},__iG:function(a){var b=qx.util.ResourceManager.getInstance().getImageWidth(a)||qx.io.ImageLoader.getWidth(a);var c=qx.util.ResourceManager.getInstance().getImageHeight(a)||qx.io.ImageLoader.getHeight(a);return {width:b,height:c};},__iH:function(m,n,o){var r=this.__iG(o);m=this.__iF(m,r.width,r.height);var q=n==R?br:O;var p=bq+qx.util.ResourceManager.getInstance().toUri(o)+bl+q+bf;m.filter=p;m.backgroundImage=m.backgroundRepeat=S;return {style:m};},__iI:function(bF,bG,bH){var bI=qx.util.ResourceManager.getInstance().toUri(bH);var bJ=this.__iG(bH);bF=this.__iF(bF,bJ.width,bJ.height);return {src:bI,style:bF};},__iJ:function(bK,bL,bM){var bQ=qx.util.ResourceManager.getInstance();var bP=bQ.isClippedImage(bM);var bR=this.__iG(bM);if(bP){var bO=bQ.getData(bM);var bN=bQ.toUri(bO[4]);if(bL===Q){bK=this.__iK(bK,bO,bR.height);}else{bK=this.__iL(bK,bO,bR.width);}return {src:bN,style:bK};}else{{};if(bL==Q){bK.height=bR.height==null?null:bR.height+W;}else if(bL==N){bK.width=bR.width==null?null:bR.width+W;}var bN=bQ.toUri(bM);return {src:bN,style:bK};}},__iK:function(bv,bw,bx){var by=qx.util.ResourceManager.getInstance().getImageHeight(bw[4]);bv.clip={top:-bw[6],height:bx};bv.height=by+W;if(bv.top!=null){bv.top=(parseInt(bv.top,10)+bw[6])+W;}else if(bv.bottom!=null){bv.bottom=(parseInt(bv.bottom,10)+bx-by-bw[6])+W;}return bv;},__iL:function(A,B,C){var D=qx.util.ResourceManager.getInstance().getImageWidth(B[4]);A.clip={left:-B[5],width:C};A.width=D+W;if(A.left!=null){A.left=(parseInt(A.left,10)+B[5])+W;}else if(A.right!=null){A.right=(parseInt(A.right,10)+C-D-B[5])+W;}return A;},__iM:function(d,f,g){var l=qx.util.ResourceManager.getInstance().isClippedImage(g);var k=this.__iG(g);if(l&&f!==bt){var j=qx.util.ResourceManager.getInstance().getData(g);var i=qx.bom.element.Background.getStyles(j[4],f,j[5],j[6]);for(var h in i){d[h]=i[h];}if(k.width!=null&&d.width==null&&(f==bo||f===R)){d.width=k.width+W;}if(k.height!=null&&d.height==null&&(f==bh||f===R)){d.height=k.height+W;}return {style:d};}else{{};d=this.__iF(d,k.width,k.height);d=this.__iN(d,g,f);return {style:d};}},__iN:function(G,H,I){var top=null;var M=null;if(G.backgroundPosition){var J=G.backgroundPosition.split(Y);M=parseInt(J[0]);if(isNaN(M)){M=J[0];}top=parseInt(J[1]);if(isNaN(top)){top=J[1];}}var L=qx.bom.element.Background.getStyles(H,I,M,top);for(var K in L){G[K]=L[K];}if(G.filter){G.filter=S;}return G;},__iO:function(s){if(this.DEBUG&&qx.util.ResourceManager.getInstance().has(s)&&s.indexOf(bu)==-1){if(!this.__iB[s]){qx.log.Logger.debug("Potential clipped image candidate: "+s);this.__iB[s]=true;}}},isAlphaImageLoaderEnabled:qx.core.Variant.select(V,{"mshtml":function(){return qx.bom.element.Decoration.__iC;},"default":function(){return false;}})}});})();(function(){var f="qx.client",e="load",d="qx.io.ImageLoader";qx.Bootstrap.define(d,{statics:{__iP:{},__iQ:{width:null,height:null},__iR:/\.(png|gif|jpg|jpeg|bmp)\b/i,isLoaded:function(g){var h=this.__iP[g];return !!(h&&h.loaded);},isFailed:function(w){var x=this.__iP[w];return !!(x&&x.failed);},isLoading:function(D){var E=this.__iP[D];return !!(E&&E.loading);},getFormat:function(j){var k=this.__iP[j];return k?k.format:null;},getSize:function(F){var G=this.__iP[F];return G?{width:G.width,height:G.height}:this.__iQ;},getWidth:function(a){var b=this.__iP[a];return b?b.width:null;},getHeight:function(u){var v=this.__iP[u];return v?v.height:null;},load:function(n,o,p){var q=this.__iP[n];if(!q){q=this.__iP[n]={};}if(o&&!p){p=window;}if(q.loaded||q.loading||q.failed){if(o){if(q.loading){q.callbacks.push(o,p);}else{o.call(p,n,q);}}}else{q.loading=true;q.callbacks=[];if(o){q.callbacks.push(o,p);}var s=new Image();var r=qx.lang.Function.listener(this.__iS,this,s,n);s.onload=r;s.onerror=r;s.src=n;}},__iS:qx.event.GlobalError.observeMethod(function(event,y,z){var A=this.__iP[z];if(event.type===e){A.loaded=true;A.width=this.__iT(y);A.height=this.__iU(y);var B=this.__iR.exec(z);if(B!=null){A.format=B[1];}}else{A.failed=true;}y.onload=y.onerror=null;var C=A.callbacks;delete A.loading;delete A.callbacks;for(var i=0,l=C.length;i<l;i+=2){C[i].call(C[i+1],z,A);}}),__iT:qx.core.Variant.select(f,{"gecko":function(c){return c.naturalWidth;},"default":function(H){return H.width;}}),__iU:qx.core.Variant.select(f,{"gecko":function(t){return t.naturalHeight;},"default":function(m){return m.height;}})}});})();(function(){var m="number",l="0",k="px",j=";",i="background-image:url(",h=");",g="",f=")",e="background-repeat:",d=" ",a="qx.bom.element.Background",c="url(",b="background-position:";qx.Class.define(a,{statics:{__iV:[i,null,h,b,null,j,e,null,j],__iW:{backgroundImage:null,backgroundPosition:null,backgroundRepeat:null},__iX:function(z,top){var A=qx.bom.client.Engine;if(A.GECKO&&A.VERSION<1.9&&z==top&&typeof z==m){top+=0.01;}if(z){var B=(typeof z==m)?z+k:z;}else{B=l;}if(top){var C=(typeof top==m)?top+k:top;}else{C=l;}return B+d+C;},compile:function(D,E,F,top){var G=this.__iX(F,top);var H=qx.util.ResourceManager.getInstance().toUri(D);var I=this.__iV;I[1]=H;I[4]=G;I[7]=E;return I.join(g);},getStyles:function(t,u,v,top){if(!t){return this.__iW;}var w=this.__iX(v,top);var x=qx.util.ResourceManager.getInstance().toUri(t);var y={backgroundPosition:w,backgroundImage:c+x+f};if(u!=null){y.backgroundRepeat=u;}return y;},set:function(n,o,p,q,top){var r=this.getStyles(o,p,q,top);for(var s in r){n.style[s]=r[s];}}}});})();(function(){var n="source",m="scale",l="no-repeat",k="qx.client",j="mshtml",i="webkit",h="backgroundImage",g="div",f="qx.html.Image",e="qx/static/blank.gif";qx.Class.define(f,{extend:qx.html.Element,members:{tagNameHint:null,_applyProperty:function(name,p){qx.html.Element.prototype._applyProperty.call(this,name,p);if(name===n){var t=this.getDomElement();var q=this.getAllStyles();if(this.getNodeName()==g&&this.getStyle(h)){q.backgroundPosition=null;q.backgroundRepeat=null;}var r=this._getProperty(n);var s=this._getProperty(m);var u=s?m:l;if(r!=null){qx.bom.element.Decoration.update(t,r,u,q);}}},_createDomElement:function(){var b=this._getProperty(m);var c=b?m:l;if(qx.core.Variant.isSet(k,j)){var a=this._getProperty(n);if(this.tagNameHint!=null){this.setNodeName(this.tagNameHint);}else{this.setNodeName(qx.bom.element.Decoration.getTagName(c,a));}}else{this.setNodeName(qx.bom.element.Decoration.getTagName(c));}return qx.html.Element.prototype._createDomElement.call(this);},_copyData:function(v){return qx.html.Element.prototype._copyData.call(this,true);},setSource:function(d){this._setProperty(n,d);return this;},getSource:function(){return this._getProperty(n);},resetSource:function(){if(qx.core.Variant.isSet(k,i)){this._setProperty(n,qx.util.ResourceManager.getInstance().toUri(e));}else{this._removeProperty(n,true);}return this;},setScale:function(o){this._setProperty(m,o);return this;},getScale:function(){return this._getProperty(m);}}});})();(function(){var i="_applyTheme",h="qx.theme.manager.Color",g="Theme",f="changeTheme",e="string",d="singleton";qx.Class.define(h,{type:d,extend:qx.util.ValueManager,properties:{theme:{check:g,nullable:true,apply:i,event:f}},members:{_applyTheme:function(j){var k={};if(j){var l=j.colors;var m=qx.util.ColorUtil;var n;for(var o in l){n=l[o];if(typeof n===e){if(!m.isCssString(n)){throw new Error("Could not parse color: "+n);}}else if(n instanceof Array){n=m.rgbToRgbString(n);}else{throw new Error("Could not parse color: "+n);}k[o]=n;}}this._setDynamic(k);},resolve:function(p){var s=this._dynamic;var q=s[p];if(q){return q;}var r=this.getTheme();if(r!==null&&r.colors[p]){return s[p]=r.colors[p];}return p;},isDynamic:function(a){var c=this._dynamic;if(a&&(c[a]!==undefined)){return true;}var b=this.getTheme();if(b!==null&&a&&(b.colors[a]!==undefined)){c[a]=b.colors[a];return true;}return false;}}});})();(function(){var m=",",l="rgb(",k=")",j="qx.theme.manager.Color",h="qx.util.ColorUtil";qx.Class.define(h,{statics:{REGEXP:{hex3:/^#([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,hex6:/^#([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,rgb:/^rgb\(\s*([0-9]{1,3}\.{0,1}[0-9]*)\s*,\s*([0-9]{1,3}\.{0,1}[0-9]*)\s*,\s*([0-9]{1,3}\.{0,1}[0-9]*)\s*\)$/,rgba:/^rgba\(\s*([0-9]{1,3}\.{0,1}[0-9]*)\s*,\s*([0-9]{1,3}\.{0,1}[0-9]*)\s*,\s*([0-9]{1,3}\.{0,1}[0-9]*)\s*,\s*([0-9]{1,3}\.{0,1}[0-9]*)\s*\)$/},SYSTEM:{activeborder:true,activecaption:true,appworkspace:true,background:true,buttonface:true,buttonhighlight:true,buttonshadow:true,buttontext:true,captiontext:true,graytext:true,highlight:true,highlighttext:true,inactiveborder:true,inactivecaption:true,inactivecaptiontext:true,infobackground:true,infotext:true,menu:true,menutext:true,scrollbar:true,threeddarkshadow:true,threedface:true,threedhighlight:true,threedlightshadow:true,threedshadow:true,window:true,windowframe:true,windowtext:true},NAMED:{black:[0,0,0],silver:[192,192,192],gray:[128,128,128],white:[255,255,255],maroon:[128,0,0],red:[255,0,0],purple:[128,0,128],fuchsia:[255,0,255],green:[0,128,0],lime:[0,255,0],olive:[128,128,0],yellow:[255,255,0],navy:[0,0,128],blue:[0,0,255],teal:[0,128,128],aqua:[0,255,255],transparent:[-1,-1,-1],magenta:[255,0,255],orange:[255,165,0],brown:[165,42,42]},isNamedColor:function(bi){return this.NAMED[bi]!==undefined;},isSystemColor:function(a){return this.SYSTEM[a]!==undefined;},supportsThemes:function(){return qx.Class.isDefined(j);},isThemedColor:function(H){if(!this.supportsThemes()){return false;}return qx.theme.manager.Color.getInstance().isDynamic(H);},stringToRgb:function(y){if(this.supportsThemes()&&this.isThemedColor(y)){var y=qx.theme.manager.Color.getInstance().resolveDynamic(y);}if(this.isNamedColor(y)){return this.NAMED[y];}else if(this.isSystemColor(y)){throw new Error("Could not convert system colors to RGB: "+y);}else if(this.isRgbString(y)){return this.__iY();}else if(this.isHex3String(y)){return this.__jb();}else if(this.isHex6String(y)){return this.__jc();}throw new Error("Could not parse color: "+y);},cssStringToRgb:function(B){if(this.isNamedColor(B)){return this.NAMED[B];}else if(this.isSystemColor(B)){throw new Error("Could not convert system colors to RGB: "+B);}else if(this.isRgbString(B)){return this.__iY();}else if(this.isRgbaString(B)){return this.__ja();}else if(this.isHex3String(B)){return this.__jb();}else if(this.isHex6String(B)){return this.__jc();}throw new Error("Could not parse color: "+B);},stringToRgbString:function(z){return this.rgbToRgbString(this.stringToRgb(z));},rgbToRgbString:function(C){return l+C[0]+m+C[1]+m+C[2]+k;},rgbToHexString:function(U){return (qx.lang.String.pad(U[0].toString(16).toUpperCase(),2)+qx.lang.String.pad(U[1].toString(16).toUpperCase(),2)+qx.lang.String.pad(U[2].toString(16).toUpperCase(),2));},isValidPropertyValue:function(S){return this.isThemedColor(S)||this.isNamedColor(S)||this.isHex3String(S)||this.isHex6String(S)||this.isRgbString(S);},isCssString:function(A){return this.isSystemColor(A)||this.isNamedColor(A)||this.isHex3String(A)||this.isHex6String(A)||this.isRgbString(A);},isHex3String:function(e){return this.REGEXP.hex3.test(e);},isHex6String:function(d){return this.REGEXP.hex6.test(d);},isRgbString:function(c){return this.REGEXP.rgb.test(c);},isRgbaString:function(x){return this.REGEXP.rgba.test(x);},__iY:function(){var L=parseInt(RegExp.$1,10);var K=parseInt(RegExp.$2,10);var J=parseInt(RegExp.$3,10);return [L,K,J];},__ja:function(){var G=parseInt(RegExp.$1,10);var F=parseInt(RegExp.$2,10);var E=parseInt(RegExp.$3,10);return [G,F,E];},__jb:function(){var s=parseInt(RegExp.$1,16)*17;var o=parseInt(RegExp.$2,16)*17;var n=parseInt(RegExp.$3,16)*17;return [s,o,n];},__jc:function(){var w=(parseInt(RegExp.$1,16)*16)+parseInt(RegExp.$2,16);var v=(parseInt(RegExp.$3,16)*16)+parseInt(RegExp.$4,16);var u=(parseInt(RegExp.$5,16)*16)+parseInt(RegExp.$6,16);return [w,v,u];},hex3StringToRgb:function(D){if(this.isHex3String(D)){return this.__jb(D);}throw new Error("Invalid hex3 value: "+D);},hex6StringToRgb:function(T){if(this.isHex6String(T)){return this.__jc(T);}throw new Error("Invalid hex6 value: "+T);},hexStringToRgb:function(I){if(this.isHex3String(I)){return this.__jb(I);}if(this.isHex6String(I)){return this.__jc(I);}throw new Error("Invalid hex value: "+I);},rgbToHsb:function(V){var X,Y,bb;var bh=V[0];var be=V[1];var W=V[2];var bg=(bh>be)?bh:be;if(W>bg){bg=W;}var ba=(bh<be)?bh:be;if(W<ba){ba=W;}bb=bg/255.0;if(bg!=0){Y=(bg-ba)/bg;}else{Y=0;}if(Y==0){X=0;}else{var bd=(bg-bh)/(bg-ba);var bf=(bg-be)/(bg-ba);var bc=(bg-W)/(bg-ba);if(bh==bg){X=bc-bf;}else if(be==bg){X=2.0+bd-bc;}else{X=4.0+bf-bd;}X=X/6.0;if(X<0){X=X+1.0;}}return [Math.round(X*360),Math.round(Y*100),Math.round(bb*100)];},hsbToRgb:function(M){var i,f,p,q,t;var N=M[0]/360;var O=M[1]/100;var P=M[2]/100;if(N>=1.0){N%=1.0;}if(O>1.0){O=1.0;}if(P>1.0){P=1.0;}var Q=Math.floor(255*P);var R={};if(O==0.0){R.red=R.green=R.blue=Q;}else{N*=6.0;i=Math.floor(N);f=N-i;p=Math.floor(Q*(1.0-O));q=Math.floor(Q*(1.0-(O*f)));t=Math.floor(Q*(1.0-(O*(1.0-f))));switch(i){case 0:R.red=Q;R.green=t;R.blue=p;break;case 1:R.red=q;R.green=Q;R.blue=p;break;case 2:R.red=p;R.green=Q;R.blue=t;break;case 3:R.red=p;R.green=q;R.blue=Q;break;case 4:R.red=t;R.green=p;R.blue=Q;break;case 5:R.red=Q;R.green=p;R.blue=q;break;}}return [R.red,R.green,R.blue];},randomColor:function(){var r=Math.round(Math.random()*255);var g=Math.round(Math.random()*255);var b=Math.round(Math.random()*255);return this.rgbToRgbString([r,g,b]);}}});})();(function(){var N="string",M="_applyTheme",L="qx.theme.manager.Appearance",K=":",J="Theme",I="changeTheme",H="/",G="singleton";qx.Class.define(L,{type:G,extend:qx.core.Object,construct:function(){qx.core.Object.call(this);this.__jd={};this.__je={};},properties:{theme:{check:J,nullable:true,event:I,apply:M}},members:{__jf:{},__jd:null,__je:null,_applyTheme:function(a,b){this.__je={};this.__jd={};},__jg:function(u,v,w){var B=v.appearances;var E=B[u];if(!E){var F=H;var y=[];var D=u.split(F);var C;while(!E&&D.length>0){y.unshift(D.pop());var z=D.join(F);E=B[z];if(E){C=E.alias||E;if(typeof C===N){var A=C+F+y.join(F);return this.__jg(A,v,w);}}}for(var i=0;i<y.length-1;i++){y.shift();var z=y.join(F);var x=this.__jg(z,v);if(x){return x;}}if(w!=null){return this.__jg(w,v);}return null;}else if(typeof E===N){return this.__jg(E,v,w);}else if(E.include&&!E.style){return this.__jg(E.include,v,w);}return u;},styleFrom:function(c,d,e,f){if(!e){e=this.getTheme();}var m=this.__je;var g=m[c];if(!g){g=m[c]=this.__jg(c,e,f);}var r=e.appearances[g];if(!r){this.warn("Missing appearance: "+c);return null;}if(!r.style){return null;}var s=g;if(d){var t=r.$$bits;if(!t){t=r.$$bits={};r.$$length=0;}var k=0;for(var n in d){if(!d[n]){continue;}if(t[n]==null){t[n]=1<<r.$$length++;}k+=t[n];}if(k>0){s+=K+k;}}var l=this.__jd;if(l[s]!==undefined){return l[s];}if(!d){d=this.__jf;}var p;if(r.include||r.base){var j=r.style(d);var h;if(r.include){h=this.styleFrom(r.include,d,e,f);}p={};if(r.base){var o=this.styleFrom(g,d,r.base,f);if(r.include){for(var q in o){if(!h.hasOwnProperty(q)&&!j.hasOwnProperty(q)){p[q]=o[q];}}}else{for(var q in o){if(!j.hasOwnProperty(q)){p[q]=o[q];}}}}if(r.include){for(var q in h){if(!j.hasOwnProperty(q)){p[q]=h[q];}}}for(var q in j){p[q]=j[q];}}else{p=r.style(d);}return l[s]=p||null;}},destruct:function(){this.__jd=this.__je=null;}});})();(function(){var ba="nonScaled",Y="scaled",X="alphaScaled",W=".png",V="qx.client",U="div",T="replacement",S="qx.event.type.Event",R="hidden",Q="Boolean",bp="px",bo="scale",bn="changeSource",bm="qx.ui.basic.Image",bl="loaded",bk="-disabled.$1",bj="loadingFailed",bi="__jh",bh="String",bg="_applySource",be="img",bf="image",bc="mshtml",bd="_applyScale",bb="no-repeat";qx.Class.define(bm,{extend:qx.ui.core.Widget,construct:function(L){this.__jh={};qx.ui.core.Widget.call(this);if(L){this.setSource(L);}},properties:{source:{check:bh,init:null,nullable:true,event:bn,apply:bg,themeable:true},scale:{check:Q,init:false,themeable:true,apply:bd},appearance:{refine:true,init:bf},allowShrinkX:{refine:true,init:false},allowShrinkY:{refine:true,init:false},allowGrowX:{refine:true,init:false},allowGrowY:{refine:true,init:false}},events:{loadingFailed:S,loaded:S},members:{__ji:null,__jj:null,__jk:null,__jh:null,getContentElement:function(){return this.__jo();},_createContentElement:function(){return this.__jo();},_getContentHint:function(){return {width:this.__ji||0,height:this.__jj||0};},_applyEnabled:function(w,x){qx.ui.core.Widget.prototype._applyEnabled.call(this,w,x);if(this.getSource()){this._styleSource();}},_applySource:function(O){this._styleSource();},_applyScale:function(P){this._styleSource();},__jl:function(u){this.__jk=u;},__jm:function(){if(this.__jk==null){var N=this.getSource();var M=false;if(N!=null){M=qx.lang.String.endsWith(N,W);}if(this.getScale()&&M&&qx.bom.element.Decoration.isAlphaImageLoaderEnabled()){this.__jk=X;}else if(this.getScale()){this.__jk=Y;}else{this.__jk=ba;}}return this.__jk;},__jn:function(y){var z;var A;if(y==X){z=true;A=U;}else if(y==ba){z=false;A=U;}else{z=true;A=be;}var B=new qx.html.Image(A);B.setScale(z);B.setStyles({"overflowX":R,"overflowY":R});return B;},__jo:function(){var v=this.__jm();if(this.__jh[v]==null){this.__jh[v]=this.__jn(v);}return this.__jh[v];},_styleSource:function(){var C=qx.util.AliasManager.getInstance().resolve(this.getSource());if(!C){this.getContentElement().resetSource();return;}this.__jp(C);if(qx.core.Variant.isSet(V,bc)){var D=this.getScale()?bo:bb;this.getContentElement().tagNameHint=qx.bom.element.Decoration.getTagName(D,C);}if(qx.util.ResourceManager.getInstance().has(C)){this.__jr(this.getContentElement(),C);}else if(qx.io.ImageLoader.isLoaded(C)){this.__js(this.getContentElement(),C);}else{this.__jt(this.getContentElement(),C);}},__jp:qx.core.Variant.select(V,{"mshtml":function(f){var h=qx.bom.element.Decoration.isAlphaImageLoaderEnabled();var g=qx.lang.String.endsWith(f,W);if(h&&g){if(this.getScale()&&this.__jm()!=X){this.__jl(X);}else if(!this.getScale()&&this.__jm()!=ba){this.__jl(ba);}}else{if(this.getScale()&&this.__jm()!=Y){this.__jl(Y);}else if(!this.getScale()&&this.__jm()!=ba){this.__jl(ba);}}this.__jq(this.__jo());},"default":function(t){if(this.getScale()&&this.__jm()!=Y){this.__jl(Y);}else if(!this.getScale()&&this.__jm(ba)){this.__jl(ba);}this.__jq(this.__jo());}}),__jq:function(m){var p=this.getContainerElement();var q=p.getChild(0);if(q!=m){if(q!=null){var s=bp;var n={};var o=this.getInnerSize();if(o!=null){n.width=o.width+s;n.height=o.height+s;}var r=this.getInsets();n.left=r.left+s;n.top=r.top+s;n.zIndex=10;m.setStyles(n,true);m.setSelectable(this.getSelectable());}p.removeAt(0);p.addAt(m,0);}},__jr:function(i,j){var l=qx.util.ResourceManager.getInstance();if(!this.getEnabled()){var k=j.replace(/\.([a-z]+)$/,bk);if(l.has(k)){j=k;this.addState(T);}else{this.removeState(T);}}if(i.getSource()===j){return;}i.setSource(j);this.__jv(l.getImageWidth(j),l.getImageHeight(j));},__js:function(E,F){var H=qx.io.ImageLoader;E.setSource(F);var G=H.getWidth(F);var I=H.getHeight(F);this.__jv(G,I);},__jt:function(c,d){var self;var e=qx.io.ImageLoader;{};if(!e.isFailed(d)){e.load(d,this.__ju,this);}else{if(c!=null){c.resetSource();}}},__ju:function(J,K){if(this.$$disposed===true){return;}if(J!==qx.util.AliasManager.getInstance().resolve(this.getSource())){return;}if(K.failed){this.warn("Image could not be loaded: "+J);this.fireEvent(bj);}else{this.fireEvent(bl);}this._styleSource();},__jv:function(a,b){if(a!==this.__ji||b!==this.__jj){this.__ji=a;this.__jj=b;qx.ui.core.queue.Layout.add(this);}}},destruct:function(){this._disposeMap(bi);}});})();(function(){var o="Integer",n="interval",m="keep-align",l="disappear",k="best-fit",j="mouse",i="bottom-left",h="direct",g="Boolean",f="bottom-right",C="widget",B="qx.ui.core.MPlacement",A="left-top",z="offsetRight",y="shorthand",x="offsetLeft",w="top-left",v="appear",u="offsetBottom",t="top-right",r="offsetTop",s="right-bottom",p="right-top",q="left-bottom";qx.Mixin.define(B,{properties:{position:{check:[w,t,i,f,A,q,p,s],init:i,themeable:true},placeMethod:{check:[C,j],init:j,themeable:true},domMove:{check:g,init:false},placementModeX:{check:[h,m,k],init:m,themeable:true},placementModeY:{check:[h,m,k],init:m,themeable:true},offsetLeft:{check:o,init:0,themeable:true},offsetTop:{check:o,init:0,themeable:true},offsetRight:{check:o,init:0,themeable:true},offsetBottom:{check:o,init:0,themeable:true},offset:{group:[r,z,u,x],mode:y,themeable:true}},members:{__jw:null,__jx:null,__jy:null,getLayoutLocation:function(H){var K,J,L,top;J=H.getBounds();L=J.left;top=J.top;var M=J;H=H.getLayoutParent();while(H&&!H.isRootWidget()){J=H.getBounds();L+=J.left;top+=J.top;K=H.getInsets();L+=K.left;top+=K.top;H=H.getLayoutParent();}if(H.isRootWidget()){var I=H.getContainerLocation();if(I){L+=I.left;top+=I.top;}}return {left:L,top:top,right:L+M.width,bottom:top+M.height};},moveTo:function(D,top){if(this.getDomMove()){this.setDomPosition(D,top);}else{this.setLayoutProperties({left:D,top:top});}},placeToWidget:function(c,d){if(d){this.__jz();this.__jw=qx.lang.Function.bind(this.placeToWidget,this,c,false);qx.event.Idle.getInstance().addListener(n,this.__jw);this.__jy=function(){this.__jz();};this.addListener(l,this.__jy,this);}var e=c.getContainerLocation()||this.getLayoutLocation(c);this.__jB(e);},__jz:function(){if(this.__jw){qx.event.Idle.getInstance().removeListener(n,this.__jw);this.__jw=null;}if(this.__jy){this.removeListener(l,this.__jy,this);this.__jy=null;}},placeToMouse:function(event){var O=event.getDocumentLeft();var top=event.getDocumentTop();var N={left:O,top:top,right:O,bottom:top};this.__jB(N);},placeToElement:function(P,Q){var location=qx.bom.element.Location.get(P);var R={left:location.left,top:location.top,right:location.left+P.offsetWidth,bottom:location.top+P.offsetHeight};if(Q){this.__jw=qx.lang.Function.bind(this.placeToElement,this,P,false);qx.event.Idle.getInstance().addListener(n,this.__jw);this.addListener(l,function(){if(this.__jw){qx.event.Idle.getInstance().removeListener(n,this.__jw);this.__jw=null;}},this);}this.__jB(R);},placeToPoint:function(a){var b={left:a.left,top:a.top,right:a.left,bottom:a.top};this.__jB(b);},_getPlacementOffsets:function(){return {left:this.getOffsetLeft(),top:this.getOffsetTop(),right:this.getOffsetRight(),bottom:this.getOffsetBottom()};},__jA:function(F){var G=null;if(this._computePlacementSize){var G=this._computePlacementSize();}else if(this.isVisible()){var G=this.getBounds();}if(G==null){this.addListenerOnce(v,function(){this.__jA(F);},this);}else{F.call(this,G);}},__jB:function(E){this.__jA(function(S){var T=qx.util.placement.Placement.compute(S,this.getLayoutParent().getBounds(),E,this._getPlacementOffsets(),this.getPosition(),this.getPlacementModeX(),this.getPlacementModeY());this.moveTo(T.left,T.top);});}},destruct:function(){this.__jz();}});})();(function(){var g="dragdrop-cursor",f="_applyAction",e="alias",d="qx.ui.core.DragDropCursor",c="move",b="singleton",a="copy";qx.Class.define(d,{extend:qx.ui.basic.Image,include:qx.ui.core.MPlacement,type:b,construct:function(){qx.ui.basic.Image.call(this);this.setZIndex(1e8);this.setDomMove(true);var j=this.getApplicationRoot();j.add(this,{left:-1000,top:-1000});},properties:{appearance:{refine:true,init:g},action:{check:[e,a,c],apply:f,nullable:true}},members:{_applyAction:function(h,i){if(i){this.removeState(i);}if(h){this.addState(h);}}}});})();(function(){var h="interval",g="Number",f="_applyTimeoutInterval",e="qx.event.type.Event",d="qx.event.Idle",c="singleton";qx.Class.define(d,{extend:qx.core.Object,type:c,construct:function(){qx.core.Object.call(this);var b=new qx.event.Timer(this.getTimeoutInterval());b.addListener(h,this._onInterval,this);b.start();this.__jC=b;},events:{"interval":e},properties:{timeoutInterval:{check:g,init:100,apply:f}},members:{__jC:null,_applyTimeoutInterval:function(a){this.__jC.setInterval(a);},_onInterval:function(){this.fireEvent(h);}},destruct:function(){if(this.__jC){this.__jC.stop();}this.__jC=null;}});})();(function(){var z="top",y="right",x="bottom",w="left",v="align-start",u="qx.util.placement.AbstractAxis",t="edge-start",s="align-end",r="edge-end",q="-",n="best-fit",p="qx.util.placement.Placement",o="keep-align",m="direct",l='__jD';qx.Class.define(p,{extend:qx.core.Object,construct:function(){qx.core.Object.call(this);this.__jD=new qx.util.placement.DirectAxis();},properties:{axisX:{check:u},axisY:{check:u},edge:{check:[z,y,x,w],init:z},align:{check:[z,y,x,w],init:y}},statics:{__jE:null,compute:function(B,C,D,E,F,G,H){this.__jE=this.__jE||new qx.util.placement.Placement();var K=F.split(q);var J=K[0];var I=K[1];this.__jE.set({axisX:this.__jI(G),axisY:this.__jI(H),edge:J,align:I});return this.__jE.compute(B,C,D,E);},__jF:null,__jG:null,__jH:null,__jI:function(A){switch(A){case m:this.__jF=this.__jF||new qx.util.placement.DirectAxis();return this.__jF;case o:this.__jG=this.__jG||new qx.util.placement.KeepAlignAxis();return this.__jG;case n:this.__jH=this.__jH||new qx.util.placement.BestFitAxis();return this.__jH;default:throw new Error("Invalid 'mode' argument!'");}}},members:{__jD:null,compute:function(e,f,g,h){{};var i=this.getAxisX()||this.__jD;var k=i.computeStart(e.width,{start:g.left,end:g.right},{start:h.left,end:h.right},f.width,this.__jJ());var j=this.getAxisY()||this.__jD;var top=j.computeStart(e.height,{start:g.top,end:g.bottom},{start:h.top,end:h.bottom},f.height,this.__jK());return {left:k,top:top};},__jJ:function(){var d=this.getEdge();var c=this.getAlign();if(d==w){return t;}else if(d==y){return r;}else if(c==w){return v;}else if(c==y){return s;}},__jK:function(){var b=this.getEdge();var a=this.getAlign();if(b==z){return t;}else if(b==x){return r;}else if(a==z){return v;}else if(a==x){return s;}}},destruct:function(){this._disposeObjects(l);}});})();(function(){var e="edge-start",d="align-start",c="align-end",b="edge-end",a="qx.util.placement.AbstractAxis";qx.Class.define(a,{extend:qx.core.Object,members:{computeStart:function(m,n,o,p,q){throw new Error("abstract method call!");},_moveToEdgeAndAlign:function(f,g,h,i){switch(i){case e:return g.start-h.end-f;case b:return g.end+h.start;case d:return g.start+h.start;case c:return g.end-h.end-f;}},_isInRange:function(j,k,l){return j>=0&&j+k<=l;}}});})();(function(){var f="qx.util.placement.DirectAxis";qx.Class.define(f,{extend:qx.util.placement.AbstractAxis,members:{computeStart:function(a,b,c,d,e){return this._moveToEdgeAndAlign(a,b,c,e);}}});})();(function(){var c="qx.util.placement.KeepAlignAxis",b="edge-start",a="edge-end";qx.Class.define(c,{extend:qx.util.placement.AbstractAxis,members:{computeStart:function(d,e,f,g,h){var i=this._moveToEdgeAndAlign(d,e,f,h);var j,k;if(this._isInRange(i,d,g)){return i;}if(h==b||h==a){j=e.start-f.end;k=e.end+f.start;}else{j=e.end-f.end;k=e.start+f.start;}if(j>g-k){i=j-d;}else{i=k;}return i;}}});})();(function(){var a="qx.util.placement.BestFitAxis";qx.Class.define(a,{extend:qx.util.placement.AbstractAxis,members:{computeStart:function(b,c,d,e,f){var g=this._moveToEdgeAndAlign(b,c,d,f);if(this._isInRange(g,b,e)){return g;}if(g<0){g=Math.min(0,e-b);}if(g+b>e){g=Math.max(0,e-b);}return g;}}});})();(function(){var f="abstract",e="qx.ui.layout.Abstract";qx.Class.define(e,{type:f,extend:qx.core.Object,members:{__jL:null,_invalidChildrenCache:null,__jM:null,invalidateLayoutCache:function(){this.__jL=null;},renderLayout:function(g,h){this.warn("Missing renderLayout() implementation!");},getSizeHint:function(){if(this.__jL){return this.__jL;}return this.__jL=this._computeSizeHint();},hasHeightForWidth:function(){return false;},getHeightForWidth:function(i){this.warn("Missing getHeightForWidth() implementation!");return null;},_computeSizeHint:function(){return null;},invalidateChildrenCache:function(){this._invalidChildrenCache=true;},verifyLayoutProperty:null,_clearSeparators:function(){var a=this.__jM;if(a instanceof qx.ui.core.LayoutItem){a.clearSeparators();}},_renderSeparator:function(b,c){this.__jM.renderSeparator(b,c);},connectToWidget:function(d){if(d&&this.__jM){throw new Error("It is not possible to manually set the connected widget.");}this.__jM=d;this.invalidateChildrenCache();},_getWidget:function(){return this.__jM;},_applyLayoutChange:function(){if(this.__jM){this.__jM.scheduleLayoutUpdate();}},_getLayoutChildren:function(){return this.__jM.getLayoutChildren();}},destruct:function(){this.__jM=this.__jL=null;}});})();(function(){var n="_applyLayoutChange",m="top",k="left",j="middle",h="Decorator",g="center",f="_applyReversed",e="bottom",d="qx.ui.layout.VBox",c="Integer",a="right",b="Boolean";qx.Class.define(d,{extend:qx.ui.layout.Abstract,construct:function(S,T,U){qx.ui.layout.Abstract.call(this);if(S){this.setSpacing(S);}if(T){this.setAlignY(T);}if(U){this.setSeparator(U);}},properties:{alignY:{check:[m,j,e],init:m,apply:n},alignX:{check:[k,g,a],init:k,apply:n},spacing:{check:c,init:0,apply:n},separator:{check:h,nullable:true,apply:n},reversed:{check:b,init:false,apply:f}},members:{__jN:null,__jO:null,__jP:null,__jQ:null,_applyReversed:function(){this._invalidChildrenCache=true;this._applyLayoutChange();},__jR:function(){var t=this._getLayoutChildren();var length=t.length;var p=false;var o=this.__jN&&this.__jN.length!=length&&this.__jO&&this.__jN;var r;var q=o?this.__jN:new Array(length);var s=o?this.__jO:new Array(length);if(this.getReversed()){t=t.concat().reverse();}for(var i=0;i<length;i++){r=t[i].getLayoutProperties();if(r.height!=null){q[i]=parseFloat(r.height)/100;}if(r.flex!=null){s[i]=r.flex;p=true;}else{s[i]=0;}}if(!o){this.__jN=q;this.__jO=s;}this.__jP=p;this.__jQ=t;delete this._invalidChildrenCache;},verifyLayoutProperty:null,renderLayout:function(u,v){if(this._invalidChildrenCache){this.__jR();}var C=this.__jQ;var length=C.length;var M=qx.ui.layout.Util;var L=this.getSpacing();var P=this.getSeparator();if(P){var z=M.computeVerticalSeparatorGaps(C,L,P);}else{var z=M.computeVerticalGaps(C,L,true);}var i,x,y,G;var H=[];var N=z;for(i=0;i<length;i+=1){G=this.__jN[i];y=G!=null?Math.floor((v-z)*G):C[i].getSizeHint().height;H.push(y);N+=y;}if(this.__jP&&N!=v){var E={};var K,O;for(i=0;i<length;i+=1){K=this.__jO[i];if(K>0){D=C[i].getSizeHint();E[i]={min:D.minHeight,value:H[i],max:D.maxHeight,flex:K};}}var A=M.computeFlexOffsets(E,v,N);for(i in A){O=A[i].offset;H[i]+=O;N+=O;}}var top=C[0].getMarginTop();if(N<v&&this.getAlignY()!=m){top=v-N;if(this.getAlignY()===j){top=Math.round(top/2);}}var D,R,I,y,F,J,B;this._clearSeparators();if(P){var Q=qx.theme.manager.Decoration.getInstance().resolve(P).getInsets();var w=Q.top+Q.bottom;}for(i=0;i<length;i+=1){x=C[i];y=H[i];D=x.getSizeHint();J=x.getMarginLeft();B=x.getMarginRight();I=Math.max(D.minWidth,Math.min(u-J-B,D.maxWidth));R=M.computeHorizontalAlignOffset(x.getAlignX()||this.getAlignX(),I,u,J,B);if(i>0){if(P){top+=F+L;this._renderSeparator(P,{top:top,left:0,height:w,width:u});top+=w+L+x.getMarginTop();}else{top+=M.collapseMargins(L,F,x.getMarginTop());}}x.renderLayout(R,top,I,y);top+=y;F=x.getMarginBottom();}},_computeSizeHint:function(){if(this._invalidChildrenCache){this.__jR();}var bc=qx.ui.layout.Util;var bk=this.__jQ;var X=0,bb=0,ba=0;var V=0,bd=0;var bh,W,bj;for(var i=0,l=bk.length;i<l;i+=1){bh=bk[i];W=bh.getSizeHint();bb+=W.height;var bg=this.__jO[i];var Y=this.__jN[i];if(bg){X+=W.minHeight;}else if(Y){ba=Math.max(ba,Math.round(W.minHeight/Y));}else{X+=W.height;}bj=bh.getMarginLeft()+bh.getMarginRight();if((W.width+bj)>bd){bd=W.width+bj;}if((W.minWidth+bj)>V){V=W.minWidth+bj;}}X+=ba;var bf=this.getSpacing();var bi=this.getSeparator();if(bi){var be=bc.computeVerticalSeparatorGaps(bk,bf,bi);}else{var be=bc.computeVerticalGaps(bk,bf,true);}return {minHeight:X+be,height:bb+be,minWidth:V,width:bd};}},destruct:function(){this.__jN=this.__jO=this.__jQ=null;}});})();(function(){var q="middle",p="qx.ui.layout.Util",o="left",n="center",m="top",k="bottom",j="right";qx.Class.define(p,{statics:{PERCENT_VALUE:/[0-9]+(?:\.[0-9]+)?%/,computeFlexOffsets:function(z,A,B){var D,H,C,I;var E=A>B;var J=Math.abs(A-B);var K,F;var G={};for(H in z){D=z[H];G[H]={potential:E?D.max-D.value:D.value-D.min,flex:E?D.flex:1/D.flex,offset:0};}while(J!=0){I=Infinity;C=0;for(H in G){D=G[H];if(D.potential>0){C+=D.flex;I=Math.min(I,D.potential/D.flex);}}if(C==0){break;}I=Math.min(J,I*C)/C;K=0;for(H in G){D=G[H];if(D.potential>0){F=Math.min(J,D.potential,Math.ceil(I*D.flex));K+=F-I*D.flex;if(K>=1){K-=1;F-=1;}D.potential-=F;if(E){D.offset+=F;}else{D.offset-=F;}J-=F;}}}return G;},computeHorizontalAlignOffset:function(R,S,T,U,V){if(U==null){U=0;}if(V==null){V=0;}var W=0;switch(R){case o:W=U;break;case j:W=T-S-V;break;case n:W=Math.round((T-S)/2);if(W<U){W=U;}else if(W<V){W=Math.max(U,T-S-V);}break;}return W;},computeVerticalAlignOffset:function(L,M,N,O,P){if(O==null){O=0;}if(P==null){P=0;}var Q=0;switch(L){case m:Q=O;break;case k:Q=N-M-P;break;case q:Q=Math.round((N-M)/2);if(Q<O){Q=O;}else if(Q<P){Q=Math.max(O,N-M-P);}break;}return Q;},collapseMargins:function(v){var w=0,y=0;for(var i=0,l=arguments.length;i<l;i++){var x=arguments[i];if(x<0){y=Math.min(y,x);}else if(x>0){w=Math.max(w,x);}}return w+y;},computeHorizontalGaps:function(X,Y,ba){if(Y==null){Y=0;}var bb=0;if(ba){bb+=X[0].getMarginLeft();for(var i=1,l=X.length;i<l;i+=1){bb+=this.collapseMargins(Y,X[i-1].getMarginRight(),X[i].getMarginLeft());}bb+=X[l-1].getMarginRight();}else{for(var i=1,l=X.length;i<l;i+=1){bb+=X[i].getMarginLeft()+X[i].getMarginRight();}bb+=(Y*(l-1));}return bb;},computeVerticalGaps:function(r,s,t){if(s==null){s=0;}var u=0;if(t){u+=r[0].getMarginTop();for(var i=1,l=r.length;i<l;i+=1){u+=this.collapseMargins(s,r[i-1].getMarginBottom(),r[i].getMarginTop());}u+=r[l-1].getMarginBottom();}else{for(var i=1,l=r.length;i<l;i+=1){u+=r[i].getMarginTop()+r[i].getMarginBottom();}u+=(s*(l-1));}return u;},computeHorizontalSeparatorGaps:function(a,b,c){var f=qx.theme.manager.Decoration.getInstance().resolve(c);var e=f.getInsets();var d=e.left+e.right;var g=0;for(var i=0,l=a.length;i<l;i++){var h=a[i];g+=h.getMarginLeft()+h.getMarginRight();}g+=(b+d+b)*(l-1);return g;},computeVerticalSeparatorGaps:function(bi,bj,bk){var bn=qx.theme.manager.Decoration.getInstance().resolve(bk);var bm=bn.getInsets();var bl=bm.top+bm.bottom;var bo=0;for(var i=0,l=bi.length;i<l;i++){var bp=bi[i];bo+=bp.getMarginTop()+bp.getMarginBottom();}bo+=(bj+bl+bj)*(l-1);return bo;},arrangeIdeals:function(bc,bd,be,bf,bg,bh){if(bd<bc||bg<bf){if(bd<bc&&bg<bf){bd=bc;bg=bf;}else if(bd<bc){bg-=(bc-bd);bd=bc;if(bg<bf){bg=bf;}}else if(bg<bf){bd-=(bf-bg);bg=bf;if(bd<bc){bd=bc;}}}if(bd>be||bg>bh){if(bd>be&&bg>bh){bd=be;bg=bh;}else if(bd>be){bg+=(bd-be);bd=be;if(bg>bh){bg=bh;}}else if(bg>bh){bd+=(bg-bh);bg=bh;if(bd>be){bd=be;}}}return {begin:bd,end:bg};}}});})();(function(){var b="qx.ui.core.MChildrenHandling";qx.Mixin.define(b,{members:{getChildren:function(){return this._getChildren();},hasChildren:function(){return this._hasChildren();},indexOf:function(f){return this._indexOf(f);},add:function(j,k){this._add(j,k);},addAt:function(m,n,o){this._addAt(m,n,o);},addBefore:function(c,d,e){this._addBefore(c,d,e);},addAfter:function(g,h,i){this._addAfter(g,h,i);},remove:function(l){this._remove(l);},removeAt:function(a){return this._removeAt(a);},removeAll:function(){this._removeAll();}},statics:{remap:function(p){p.getChildren=p._getChildren;p.hasChildren=p._hasChildren;p.indexOf=p._indexOf;p.add=p._add;p.addAt=p._addAt;p.addBefore=p._addBefore;p.addAfter=p._addAfter;p.remove=p._remove;p.removeAt=p._removeAt;p.removeAll=p._removeAll;}}});})();(function(){var a="qx.ui.core.MLayoutHandling";qx.Mixin.define(a,{members:{setLayout:function(c){return this._setLayout(c);},getLayout:function(){return this._getLayout();}},statics:{remap:function(b){b.getLayout=b._getLayout;b.setLayout=b._setLayout;}}});})();(function(){var e="qx.event.type.Data",d="qx.ui.container.Composite",c="addChildWidget",b="removeChildWidget";qx.Class.define(d,{extend:qx.ui.core.Widget,include:[qx.ui.core.MChildrenHandling,qx.ui.core.MLayoutHandling],construct:function(i){qx.ui.core.Widget.call(this);if(i!=null){this._setLayout(i);}},events:{addChildWidget:e,removeChildWidget:e},members:{_afterAddChild:function(a){this.fireNonBubblingEvent(c,qx.event.type.Data,[a]);},_afterRemoveChild:function(h){this.fireNonBubblingEvent(b,qx.event.type.Data,[h]);}},defer:function(f,g){qx.ui.core.MChildrenHandling.remap(g);qx.ui.core.MLayoutHandling.remap(g);}});})();(function(){var L="_applyLayoutChange",K="left",J="center",I="top",H="Decorator",G="middle",F="_applyReversed",E="bottom",D="Boolean",C="right",A="Integer",B="qx.ui.layout.HBox";qx.Class.define(B,{extend:qx.ui.layout.Abstract,construct:function(a,b,c){qx.ui.layout.Abstract.call(this);if(a){this.setSpacing(a);}if(b){this.setAlignX(b);}if(c){this.setSeparator(c);}},properties:{alignX:{check:[K,J,C],init:K,apply:L},alignY:{check:[I,G,E],init:I,apply:L},spacing:{check:A,init:0,apply:L},separator:{check:H,nullable:true,apply:L},reversed:{check:D,init:false,apply:F}},members:{__jS:null,__jT:null,__jU:null,__jV:null,_applyReversed:function(){this._invalidChildrenCache=true;this._applyLayoutChange();},__jW:function(){var j=this._getLayoutChildren();var length=j.length;var f=false;var d=this.__jS&&this.__jS.length!=length&&this.__jT&&this.__jS;var g;var e=d?this.__jS:new Array(length);var h=d?this.__jT:new Array(length);if(this.getReversed()){j=j.concat().reverse();}for(var i=0;i<length;i++){g=j[i].getLayoutProperties();if(g.width!=null){e[i]=parseFloat(g.width)/100;}if(g.flex!=null){h[i]=g.flex;f=true;}else{h[i]=0;}}if(!d){this.__jS=e;this.__jT=h;}this.__jU=f;this.__jV=j;delete this._invalidChildrenCache;},verifyLayoutProperty:null,renderLayout:function(M,N){if(this._invalidChildrenCache){this.__jW();}var T=this.__jV;var length=T.length;var bd=qx.ui.layout.Util;var bc=this.getSpacing();var bg=this.getSeparator();if(bg){var Q=bd.computeHorizontalSeparatorGaps(T,bc,bg);}else{var Q=bd.computeHorizontalGaps(T,bc,true);}var i,O,ba,Y;var bf=[];var U=Q;for(i=0;i<length;i+=1){Y=this.__jS[i];ba=Y!=null?Math.floor((M-Q)*Y):T[i].getSizeHint().width;bf.push(ba);U+=ba;}if(this.__jU&&U!=M){var W={};var bb,be;for(i=0;i<length;i+=1){bb=this.__jT[i];if(bb>0){V=T[i].getSizeHint();W[i]={min:V.minWidth,value:bf[i],max:V.maxWidth,flex:bb};}}var R=bd.computeFlexOffsets(W,M,U);for(i in R){be=R[i].offset;bf[i]+=be;U+=be;}}var bk=T[0].getMarginLeft();if(U<M&&this.getAlignX()!=K){bk=M-U;if(this.getAlignX()===J){bk=Math.round(bk/2);}}var V,top,P,ba,S,bi,X;var bc=this.getSpacing();this._clearSeparators();if(bg){var bh=qx.theme.manager.Decoration.getInstance().resolve(bg).getInsets();var bj=bh.left+bh.right;}for(i=0;i<length;i+=1){O=T[i];ba=bf[i];V=O.getSizeHint();bi=O.getMarginTop();X=O.getMarginBottom();P=Math.max(V.minHeight,Math.min(N-bi-X,V.maxHeight));top=bd.computeVerticalAlignOffset(O.getAlignY()||this.getAlignY(),P,N,bi,X);if(i>0){if(bg){bk+=S+bc;this._renderSeparator(bg,{left:bk,top:0,width:bj,height:N});bk+=bj+bc+O.getMarginLeft();}else{bk+=bd.collapseMargins(bc,S,O.getMarginLeft());}}O.renderLayout(bk,top,ba,P);bk+=ba;S=O.getMarginRight();}},_computeSizeHint:function(){if(this._invalidChildrenCache){this.__jW();}var r=qx.ui.layout.Util;var z=this.__jV;var k=0,s=0,p=0;var o=0,q=0;var w,m,y;for(var i=0,l=z.length;i<l;i+=1){w=z[i];m=w.getSizeHint();s+=m.width;var v=this.__jT[i];var n=this.__jS[i];if(v){k+=m.minWidth;}else if(n){p=Math.max(p,Math.round(m.minWidth/n));}else{k+=m.width;}y=w.getMarginTop()+w.getMarginBottom();if((m.height+y)>q){q=m.height+y;}if((m.minHeight+y)>o){o=m.minHeight+y;}}k+=p;var u=this.getSpacing();var x=this.getSeparator();if(x){var t=r.computeHorizontalSeparatorGaps(z,u,x);}else{var t=r.computeHorizontalGaps(z,u,true);}return {minWidth:k+t,width:s+t,minHeight:o,height:q};}},destruct:function(){this.__jS=this.__jT=this.__jV=null;}});})();(function(){var c="qx.ui.table.IRowRenderer";qx.Interface.define(c,{members:{updateDataRowElement:function(a,b){},getRowHeightStyle:function(f){},createRowStyle:function(d){},getRowClass:function(e){}}});})();(function(){var z="",y="table-row-background-even",x="table-row-background-selected",w="table-row",v="background-color:",u="table-row-background-focused",t=';border-bottom: 1px solid ',s=';color:',r="table-row-selected",q="table-row-background-odd",j="default",p="table-row-background-focused-selected",m="qx.ui.table.rowrenderer.Default",i="table-row-line",h="'",l="height:",k=";",n="px;",g="1px solid ",o="Boolean";qx.Class.define(m,{extend:qx.core.Object,implement:qx.ui.table.IRowRenderer,construct:function(){qx.core.Object.call(this);this.__jX=z;this.__jX={};this.__jY={};this._renderFont(qx.theme.manager.Font.getInstance().resolve(j));var B=qx.theme.manager.Color.getInstance();this.__jY.bgcolFocusedSelected=B.resolve(p);this.__jY.bgcolFocused=B.resolve(u);this.__jY.bgcolSelected=B.resolve(x);this.__jY.bgcolEven=B.resolve(y);this.__jY.bgcolOdd=B.resolve(q);this.__jY.colSelected=B.resolve(r);this.__jY.colNormal=B.resolve(w);this.__jY.horLine=B.resolve(i);},properties:{highlightFocusRow:{check:o,init:true}},members:{__jY:null,__ka:null,__jX:null,_insetY:1,_renderFont:function(a){if(a){this.__ka=a.getStyles();this.__jX=qx.bom.element.Style.compile(this.__ka);this.__jX=this.__jX.replace(/"/g,h);}else{this.__jX=z;this.__ka=qx.bom.Font.getDefaultStyles();}},updateDataRowElement:function(c,d){var f=this.__ka;var e=d.style;qx.bom.element.Style.setStyles(d,f);if(c.focusedRow&&this.getHighlightFocusRow()){e.backgroundColor=c.selected?this.__jY.bgcolFocusedSelected:this.__jY.bgcolFocused;}else{if(c.selected){e.backgroundColor=this.__jY.bgcolSelected;}else{e.backgroundColor=(c.row%2==0)?this.__jY.bgcolEven:this.__jY.bgcolOdd;}}e.color=c.selected?this.__jY.colSelected:this.__jY.colNormal;e.borderBottom=g+this.__jY.horLine;},getRowHeightStyle:function(b){if(qx.bom.client.Feature.CONTENT_BOX){b-=this._insetY;}return l+b+n;},createRowStyle:function(D){var E=[];E.push(k);E.push(this.__jX);E.push(v);if(D.focusedRow&&this.getHighlightFocusRow()){E.push(D.selected?this.__jY.bgcolFocusedSelected:this.__jY.bgcolFocused);}else{if(D.selected){E.push(this.__jY.bgcolSelected);}else{E.push((D.row%2==0)?this.__jY.bgcolEven:this.__jY.bgcolOdd);}}E.push(s);E.push(D.selected?this.__jY.colSelected:this.__jY.colNormal);E.push(t,this.__jY.horLine);return E.join(z);},getRowClass:function(C){return z;},getRowAttributes:function(A){return z;}},destruct:function(){this.__jY=this.__ka=this.__jX=null;}});})();(function(){var e="qx.theme.manager.Font",d="Theme",c="changeTheme",b="_applyTheme",a="singleton";qx.Class.define(e,{type:a,extend:qx.util.ValueManager,properties:{theme:{check:d,nullable:true,apply:b,event:c}},members:{resolveDynamic:function(k){var l=this._dynamic;return k instanceof qx.bom.Font?k:l[k];},resolve:function(m){var p=this._dynamic;var n=p[m];if(n){return n;}var o=this.getTheme();if(o!==null&&o.fonts[m]){return p[m]=(new qx.bom.Font).set(o.fonts[m]);}return m;},isDynamic:function(t){var v=this._dynamic;if(t&&(t instanceof qx.bom.Font||v[t]!==undefined)){return true;}var u=this.getTheme();if(u!==null&&t&&u.fonts[t]){v[t]=(new qx.bom.Font).set(u.fonts[t]);return true;}return false;},__kb:function(q,r){if(q[r].include){var s=q[q[r].include];q[r].include=null;delete q[r].include;q[r]=qx.lang.Object.mergeWith(q[r],s,false);this.__kb(q,r);}},_applyTheme:function(f){var g=this._getDynamic();for(var j in g){if(g[j].themed){g[j].dispose();delete g[j];}}if(f){var h=f.fonts;var i=qx.bom.Font;for(var j in h){if(h[j].include&&h[h[j].include]){this.__kb(h,j);}g[j]=(new i).set(h[j]);g[j].themed=true;}}this._setDynamic(g);}}});})();(function(){var t="",s="underline",r="Boolean",q="px",p='"',o="italic",n="normal",m="bold",k="_applyItalic",j="_applyBold",F="Integer",E="_applyFamily",D="_applyLineHeight",C="Array",B="overline",A="line-through",z="qx.bom.Font",y="Number",x="_applyDecoration",w=" ",u="_applySize",v=",";qx.Class.define(z,{extend:qx.core.Object,construct:function(L,M){qx.core.Object.call(this);if(L!==undefined){this.setSize(L);}if(M!==undefined){this.setFamily(M);}},statics:{fromString:function(G){var K=new qx.bom.Font();var I=G.split(/\s+/);var name=[];var J;for(var i=0;i<I.length;i++){switch(J=I[i]){case m:K.setBold(true);break;case o:K.setItalic(true);break;case s:K.setDecoration(s);break;default:var H=parseInt(J,10);if(H==J||qx.lang.String.contains(J,q)){K.setSize(H);}else{name.push(J);}break;}}if(name.length>0){K.setFamily(name);}return K;},fromConfig:function(g){var h=new qx.bom.Font;h.set(g);return h;},__kc:{fontFamily:t,fontSize:t,fontWeight:t,fontStyle:t,textDecoration:t,lineHeight:1.2},getDefaultStyles:function(){return this.__kc;}},properties:{size:{check:F,nullable:true,apply:u},lineHeight:{check:y,nullable:true,apply:D},family:{check:C,nullable:true,apply:E},bold:{check:r,nullable:true,apply:j},italic:{check:r,nullable:true,apply:k},decoration:{check:[s,A,B],nullable:true,apply:x}},members:{__kd:null,__ke:null,__kf:null,__kg:null,__kh:null,__ki:null,_applySize:function(N,O){this.__kd=N===null?null:N+q;},_applyLineHeight:function(a,b){this.__ki=a===null?null:a;},_applyFamily:function(R,S){var T=t;for(var i=0,l=R.length;i<l;i++){if(R[i].indexOf(w)>0){T+=p+R[i]+p;}else{T+=R[i];}if(i!==l-1){T+=v;}}this.__ke=T;},_applyBold:function(e,f){this.__kf=e===null?null:e?m:n;},_applyItalic:function(c,d){this.__kg=c===null?null:c?o:n;},_applyDecoration:function(P,Q){this.__kh=P===null?null:P;},getStyles:function(){return {fontFamily:this.__ke,fontSize:this.__kd,fontWeight:this.__kf,fontStyle:this.__kg,textDecoration:this.__kh,lineHeight:this.__ki};}}});})();(function(){var r="label",q="icon",p="Boolean",o="both",n="String",m="left",l="changeGap",k="changeShow",j="bottom",i="_applyCenter",E="changeIcon",D="qx.ui.basic.Atom",C="changeLabel",B="Integer",A="_applyIconPosition",z="top",y="right",x="_applyRich",w="_applyIcon",v="_applyShow",t="_applyLabel",u="_applyGap",s="atom";qx.Class.define(D,{extend:qx.ui.core.Widget,construct:function(J,K){{};qx.ui.core.Widget.call(this);this._setLayout(new qx.ui.layout.Atom());if(J!=null){this.setLabel(J);}if(K!=null){this.setIcon(K);}},properties:{appearance:{refine:true,init:s},label:{apply:t,nullable:true,check:n,event:C},rich:{check:p,init:false,apply:x},icon:{check:n,apply:w,nullable:true,themeable:true,event:E},gap:{check:B,nullable:false,event:l,apply:u,themeable:true,init:4},show:{init:o,check:[o,r,q],themeable:true,inheritable:true,apply:v,event:k},iconPosition:{init:m,check:[z,y,j,m],themeable:true,apply:A},center:{init:false,check:p,themeable:true,apply:i}},members:{_createChildControlImpl:function(Q){var R;switch(Q){case r:R=new qx.ui.basic.Label(this.getLabel());R.setAnonymous(true);R.setRich(this.getRich());this._add(R);if(this.getLabel()==null||this.getShow()===q){R.exclude();}break;case q:R=new qx.ui.basic.Image(this.getIcon());R.setAnonymous(true);this._addAt(R,0);if(this.getIcon()==null||this.getShow()===r){R.exclude();}break;}return R||qx.ui.core.Widget.prototype._createChildControlImpl.call(this,Q);},_forwardStates:{focused:true,hovered:true},_handleLabel:function(){if(this.getLabel()==null||this.getShow()===q){this._excludeChildControl(r);}else{this._showChildControl(r);}},_handleIcon:function(){if(this.getIcon()==null||this.getShow()===r){this._excludeChildControl(q);}else{this._showChildControl(q);}},_applyLabel:function(N,O){var P=this.getChildControl(r,true);if(P){P.setValue(N);}this._handleLabel();},_applyRich:function(f,g){var h=this.getChildControl(r,true);if(h){h.setRich(f);}},_applyIcon:function(a,b){var c=this.getChildControl(q,true);if(c){c.setSource(a);}this._handleIcon();},_applyGap:function(L,M){this._getLayout().setGap(L);},_applyShow:function(d,e){this._handleLabel();this._handleIcon();},_applyIconPosition:function(F,G){this._getLayout().setIconPosition(F);},_applyCenter:function(H,I){this._getLayout().setCenter(H);}}});})();(function(){var n="execute",m="toolTipText",l="icon",k="label",j="qx.ui.core.MExecutable",h="value",g="qx.event.type.Event",f="_applyCommand",d="enabled",c="menu",a="changeCommand",b="qx.ui.core.Command";qx.Mixin.define(j,{events:{"execute":g},properties:{command:{check:b,apply:f,event:a,nullable:true}},members:{__kj:null,__kk:false,__kl:null,_bindableProperties:[d,k,l,m,h,c],execute:function(){var u=this.getCommand();if(u){if(this.__kk){this.__kk=false;}else{this.__kk=true;u.execute(this);}}this.fireEvent(n);},__km:function(e){if(this.__kk){this.__kk=false;return;}this.__kk=true;this.execute();},_applyCommand:function(o,p){if(p!=null){p.removeListenerById(this.__kl);}if(o!=null){this.__kl=o.addListener(n,this.__km,this);}var s=this.__kj;if(s==null){this.__kj=s={};}for(var i=0;i<this._bindableProperties.length;i++){var r=this._bindableProperties[i];if(p!=null&&s[r]!=null){p.removeBinding(s[r]);s[r]=null;}if(o!=null&&qx.Class.hasProperty(this.constructor,r)){var q=o.get(r);if(q==null){var t=this.get(r);}s[r]=o.bind(r,this,r);if(t){this.set(r,t);}}}}},destruct:function(){this.__kj=null;}});})();(function(){var b="qx.ui.form.IExecutable",a="qx.event.type.Data";qx.Interface.define(b,{events:{"execute":a},members:{setCommand:function(c){return arguments.length==1;},getCommand:function(){},execute:function(){}}});})();(function(){var r="pressed",q="abandoned",p="hovered",o="Enter",n="Space",m="dblclick",l="qx.ui.form.Button",k="mouseup",j="mousedown",i="mouseover",f="mouseout",h="keydown",g="button",d="keyup";qx.Class.define(l,{extend:qx.ui.basic.Atom,include:[qx.ui.core.MExecutable],implement:[qx.ui.form.IExecutable],construct:function(a,b,c){qx.ui.basic.Atom.call(this,a,b);if(c!=null){this.setCommand(c);}this.addListener(i,this._onMouseOver);this.addListener(f,this._onMouseOut);this.addListener(j,this._onMouseDown);this.addListener(k,this._onMouseUp);this.addListener(h,this._onKeyDown);this.addListener(d,this._onKeyUp);this.addListener(m,this._onStopEvent);},properties:{appearance:{refine:true,init:g},focusable:{refine:true,init:true}},members:{_forwardStates:{focused:true,hovered:true,pressed:true,disabled:true},press:function(){if(this.hasState(q)){return;}this.addState(r);},release:function(){if(this.hasState(r)){this.removeState(r);}},reset:function(){this.removeState(r);this.removeState(q);this.removeState(p);},_onMouseOver:function(e){if(!this.isEnabled()||e.getTarget()!==this){return;}if(this.hasState(q)){this.removeState(q);this.addState(r);}this.addState(p);},_onMouseOut:function(e){if(!this.isEnabled()||e.getTarget()!==this){return;}this.removeState(p);if(this.hasState(r)){this.removeState(r);this.addState(q);}},_onMouseDown:function(e){if(!e.isLeftPressed()){return;}e.stopPropagation();this.capture();this.removeState(q);this.addState(r);},_onMouseUp:function(e){this.releaseCapture();var s=this.hasState(r);var t=this.hasState(q);if(s){this.removeState(r);}if(t){this.removeState(q);}else{this.addState(p);if(s){this.execute();}}e.stopPropagation();},_onKeyDown:function(e){switch(e.getKeyIdentifier()){case o:case n:this.removeState(q);this.addState(r);e.stopPropagation();}},_onKeyUp:function(e){switch(e.getKeyIdentifier()){case o:case n:if(this.hasState(r)){this.removeState(q);this.removeState(r);this.execute();e.stopPropagation();}}}}});})();(function(){var q="pressed",p="hovered",o="changeVisibility",n="qx.ui.menu.Menu",m="submenu",l="Enter",k="contextmenu",j="changeMenu",i="qx.ui.form.MenuButton",h="abandoned",g="_applyMenu";qx.Class.define(i,{extend:qx.ui.form.Button,construct:function(c,d,f){qx.ui.form.Button.call(this,c,d);if(f!=null){this.setMenu(f);}},properties:{menu:{check:n,nullable:true,apply:g,event:j}},members:{_applyMenu:function(a,b){if(b){b.removeListener(o,this._onMenuChange,this);b.resetOpener();}if(a){a.addListener(o,this._onMenuChange,this);a.setOpener(this);a.removeState(m);a.removeState(k);}},open:function(s){var t=this.getMenu();if(t){qx.ui.menu.Manager.getInstance().hideAll();t.setOpener(this);t.open();if(s){var u=t.getSelectables()[0];if(u){t.setSelectedButton(u);}}}},_onMenuChange:function(e){var w=this.getMenu();if(w.isVisible()){this.addState(q);}else{this.removeState(q);}},_onMouseDown:function(e){qx.ui.form.Button.prototype._onMouseDown.call(this,e);var r=this.getMenu();if(r){if(!r.isVisible()){this.open();}else{r.exclude();}e.stopPropagation();}},_onMouseUp:function(e){qx.ui.form.Button.prototype._onMouseUp.call(this,e);e.stopPropagation();},_onMouseOver:function(e){this.addState(p);},_onMouseOut:function(e){this.removeState(p);},_onKeyDown:function(e){switch(e.getKeyIdentifier()){case l:this.removeState(h);this.addState(q);var v=this.getMenu();if(v){if(!v.isVisible()){this.open();}else{v.exclude();}}e.stopPropagation();}},_onKeyUp:function(e){}},destruct:function(){if(this.getMenu()){if(!qx.core.ObjectRegistry.inShutDown){this.getMenu().destroy();}}}});})();(function(){var a="qx.ui.table.IColumnMenuButton";qx.Interface.define(a,{properties:{menu:{}},members:{factory:function(b,c){return true;},empty:function(){return true;}}});})();(function(){var h="menu-button",g="table-column-reset-button",f="separator",e="user-button",d="qx.ui.table.columnmenu.Button",c="menu";qx.Class.define(d,{extend:qx.ui.form.MenuButton,implement:qx.ui.table.IColumnMenuButton,construct:function(){qx.ui.form.MenuButton.call(this);this.__kn=new qx.ui.core.Blocker(this);},members:{__ko:null,__kn:null,factory:function(j,k){switch(j){case c:var m=new qx.ui.menu.Menu();this.setMenu(m);return m;case h:var o=new qx.ui.table.columnmenu.MenuItem(k.text);o.setVisible(k.bVisible);this.getMenu().add(o);return o;case e:var n=new qx.ui.menu.Button(k.text);n.set({appearance:g});return n;case f:return new qx.ui.menu.Separator();default:throw new Error("Unrecognized factory request: "+j);}},getBlocker:function(){return this.__kn;},empty:function(){var a=this.getMenu();var b=a.getChildren();for(var i=0,l=b.length;i<l;i++){b[0].destroy();}}},destruct:function(){this.__kn.dispose();}});})();(function(){var k="bottom",j="_applyLayoutChange",h="top",g="left",f="right",e="middle",d="center",c="qx.ui.layout.Atom",b="Integer",a="Boolean";qx.Class.define(c,{extend:qx.ui.layout.Abstract,properties:{gap:{check:b,init:4,apply:j},iconPosition:{check:[g,h,f,k],init:g,apply:j},center:{check:a,init:false,apply:j}},members:{verifyLayoutProperty:null,renderLayout:function(w,x){var G=qx.ui.layout.Util;var z=this.getIconPosition();var C=this._getLayoutChildren();var length=C.length;var Q,top,P,A;var L,F;var J=this.getGap();var O=this.getCenter();if(z===k||z===f){var H=length-1;var D=-1;var B=-1;}else{var H=0;var D=length;var B=1;}if(z==h||z==k){if(O){var K=0;for(var i=H;i!=D;i+=B){A=C[i].getSizeHint().height;if(A>0){K+=A;if(i!=H){K+=J;}}}top=Math.round((x-K)/2);}else{top=0;}for(var i=H;i!=D;i+=B){L=C[i];F=L.getSizeHint();P=Math.min(F.maxWidth,Math.max(w,F.minWidth));A=F.height;Q=G.computeHorizontalAlignOffset(d,P,w);L.renderLayout(Q,top,P,A);if(A>0){top+=A+J;}}}else{var E=w;var y=null;var N=0;for(var i=H;i!=D;i+=B){L=C[i];P=L.getSizeHint().width;if(P>0){if(!y&&L instanceof qx.ui.basic.Label){y=L;}else{E-=P;}N++;}}if(N>1){var M=(N-1)*J;E-=M;}if(y){var F=y.getSizeHint();var I=Math.max(F.minWidth,Math.min(E,F.maxWidth));E-=I;}if(O&&E>0){Q=Math.round(E/2);}else{Q=0;}for(var i=H;i!=D;i+=B){L=C[i];F=L.getSizeHint();A=Math.min(F.maxHeight,Math.max(x,F.minHeight));if(L===y){P=I;}else{P=F.width;}top=G.computeVerticalAlignOffset(e,F.height,x);L.renderLayout(Q,top,P,A);if(P>0){Q+=P+J;}}}},_computeSizeHint:function(){var v=this._getLayoutChildren();var length=v.length;var n,t;if(length===1){var n=v[0].getSizeHint();t={width:n.width,height:n.height,minWidth:n.minWidth,minHeight:n.minHeight};}else{var r=0,s=0;var o=0,q=0;var p=this.getIconPosition();var u=this.getGap();if(p===h||p===k){var l=0;for(var i=0;i<length;i++){n=v[i].getSizeHint();s=Math.max(s,n.width);r=Math.max(r,n.minWidth);if(n.height>0){q+=n.height;o+=n.minHeight;l++;}}if(l>1){var m=(l-1)*u;q+=m;o+=m;}}else{var l=0;for(var i=0;i<length;i++){n=v[i].getSizeHint();q=Math.max(q,n.height);o=Math.max(o,n.minHeight);if(n.width>0){s+=n.width;r+=n.minWidth;l++;}}if(l>1){var m=(l-1)*u;s+=m;r+=m;}}t={minWidth:r,width:s,minHeight:o,height:q};}return t;}}});})();(function(){var b="qx.event.type.Data",a="qx.ui.form.IStringForm";qx.Interface.define(a,{events:{"changeValue":b},members:{setValue:function(c){return arguments.length==1;},resetValue:function(){},getValue:function(){}}});})();(function(){var A="qx.dynlocale",z="text",y="Boolean",x="color",w="userSelect",v="changeLocale",u="enabled",t="none",s="on",r="_applyTextAlign",X="qx.ui.core.Widget",W="nowrap",V="changeTextAlign",U="_applyWrap",T="changeValue",S="qx.client",R="changeContent",Q="qx.ui.basic.Label",P="A",O="whiteSpace",H="_applyValue",I="center",F="_applyBuddy",G="String",D="textAlign",E="right",B="changeRich",C="normal",J="_applyRich",K="click",M="label",L="webkit",N="left";qx.Class.define(Q,{extend:qx.ui.core.Widget,implement:[qx.ui.form.IStringForm],construct:function(be){qx.ui.core.Widget.call(this);if(be!=null){this.setValue(be);}if(qx.core.Variant.isSet(A,s)){qx.locale.Manager.getInstance().addListener(v,this._onChangeLocale,this);}},properties:{rich:{check:y,init:false,event:B,apply:J},wrap:{check:y,init:true,apply:U},value:{check:G,apply:H,event:T,nullable:true},buddy:{check:X,apply:F,nullable:true,init:null,dereference:true},textAlign:{check:[N,I,E],nullable:true,themeable:true,apply:r,event:V},appearance:{refine:true,init:M},selectable:{refine:true,init:false},allowGrowX:{refine:true,init:false},allowGrowY:{refine:true,init:false},allowShrinkY:{refine:true,init:false}},members:{__kp:null,__kq:null,__kr:null,__ks:null,_getContentHint:function(){if(this.__kq){this.__kt=this.__ku();delete this.__kq;}return {width:this.__kt.width,height:this.__kt.height};},_hasHeightForWidth:function(){return this.getRich()&&this.getWrap();},_applySelectable:function(bb){if(!qx.bom.client.Feature.CSS_TEXT_OVERFLOW&&qx.bom.client.Feature.XUL){if(bb&&!this.isRich()){{};return;}}qx.ui.core.Widget.prototype._applySelectable.call(this,bb);if(qx.core.Variant.isSet(S,L)){this.getContainerElement().setStyle(w,bb?z:t);this.getContentElement().setStyle(w,bb?z:t);}},_getContentHeightForWidth:function(q){if(!this.getRich()&&!this.getWrap()){return null;}return this.__ku(q).height;},_createContentElement:function(){return new qx.html.Label;},_applyTextAlign:function(bf,bg){this.getContentElement().setStyle(D,bf);},_applyTextColor:function(Y,ba){if(Y){this.getContentElement().setStyle(x,qx.theme.manager.Color.getInstance().resolve(Y));}else{this.getContentElement().removeStyle(x);}},__kt:{width:0,height:0},_applyFont:function(c,d){var f;if(c){this.__kp=qx.theme.manager.Font.getInstance().resolve(c);f=this.__kp.getStyles();}else{this.__kp=null;f=qx.bom.Font.getDefaultStyles();}this.getContentElement().setStyles(f);this.__kq=true;qx.ui.core.queue.Layout.add(this);},__ku:function(l){var p=qx.bom.Label;var n=this.getFont();var m=n?this.__kp.getStyles():qx.bom.Font.getDefaultStyles();var content=this.getValue()||P;var o=this.getRich();return o?p.getHtmlSize(content,m,l):p.getTextSize(content,m);},_applyBuddy:function(g,h){if(h!=null){h.removeBinding(this.__kr);this.__kr=null;this.removeListenerById(this.__ks);this.__ks=null;}if(g!=null){this.__kr=g.bind(u,this,u);this.__ks=this.addListener(K,function(){if(g.isFocusable()){g.focus.apply(g);}},this);}},_applyRich:function(bd){this.getContentElement().setRich(bd);this.__kq=true;qx.ui.core.queue.Layout.add(this);},_applyWrap:function(i,j){if(i&&!this.isRich()){{};}if(this.isRich()){var k=i?C:W;this.getContentElement().setStyle(O,k);}},_onChangeLocale:qx.core.Variant.select(A,{"on":function(e){var content=this.getValue();if(content&&content.translate){this.setValue(content.translate());}},"off":null}),_applyValue:function(a,b){this.getContentElement().setValue(a);this.__kq=true;qx.ui.core.queue.Layout.add(this);this.fireDataEvent(R,a,b);}},destruct:function(){if(qx.core.Variant.isSet(A,s)){qx.locale.Manager.getInstance().removeListener(v,this._onChangeLocale,this);}if(this.__kr!=null){var bc=this.getBuddy();if(bc!=null&&!bc.isDisposed()){bc.removeBinding(this.__kr);}}this.__kp=this.__kr=null;}});})();(function(){var e="value",d="qx.html.Label";qx.Class.define(d,{extend:qx.html.Element,members:{__kv:null,_applyProperty:function(name,b){qx.html.Element.prototype._applyProperty.call(this,name,b);if(name==e){var c=this.getDomElement();qx.bom.Label.setValue(c,b);}},_createDomElement:function(){var i=this.__kv;var h=qx.bom.Label.create(this._content,i);return h;},_copyData:function(j){return qx.html.Element.prototype._copyData.call(this,true);},setRich:function(f){var g=this.getDomElement();if(g){throw new Error("The label mode cannot be modified after initial creation");}f=!!f;if(this.__kv==f){return;}this.__kv=f;return this;},setValue:function(a){this._setProperty(e,a);return this;},getValue:function(){return this._getProperty(e);}}});})();(function(){var w="div",v="inherit",u="text",t="value",s="",r="hidden",q="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul",p="nowrap",o="qx.client",n="auto",M="0",L="ellipsis",K="normal",J="label",I="px",H="crop",G="gecko",F="end",E="100%",D="visible",B="qx.bom.Label",C="opera",z="block",A="none",x="-1000px",y="absolute";qx.Class.define(B,{statics:{__kw:{fontFamily:1,fontSize:1,fontWeight:1,fontStyle:1,lineHeight:1},__kx:function(){var h=this.__kz(false);document.body.insertBefore(h,document.body.firstChild);return this._textElement=h;},__ky:function(){var V=this.__kz(true);document.body.insertBefore(V,document.body.firstChild);return this._htmlElement=V;},__kz:function(i){var j=qx.bom.Element.create(w);var k=j.style;k.width=k.height=n;k.left=k.top=x;k.visibility=r;k.position=y;k.overflow=D;if(i){k.whiteSpace=K;}else{k.whiteSpace=p;if(!qx.bom.client.Feature.CSS_TEXT_OVERFLOW&&qx.bom.client.Feature.XUL){var l=document.createElementNS(q,J);var k=l.style;k.padding=M;for(var m in this.__kw){k[m]=v;}j.appendChild(l);}}return j;},__kA:function(Q){var R={};if(Q){R.whiteSpace=K;}else if(!qx.bom.client.Feature.CSS_TEXT_OVERFLOW&&qx.bom.client.Feature.XUL){R.display=z;}else{R.overflow=r;R.whiteSpace=p;R.textOverflow=L;R.userSelect=A;if(qx.core.Variant.isSet(o,C)){R.OTextOverflow=L;}}return R;},create:function(content,b,c){if(!c){c=window;}if(b){var d=c.document.createElement(w);d.useHtml=true;}else if(!qx.bom.client.Feature.CSS_TEXT_OVERFLOW&&qx.bom.client.Feature.XUL){var d=c.document.createElement(w);var f=c.document.createElementNS(q,J);var e=f.style;e.cursor=v;e.color=v;e.overflow=r;e.maxWidth=E;e.padding=M;for(var g in this.__kw){f.style[g]=v;}f.setAttribute(H,F);d.appendChild(f);}else{var d=c.document.createElement(w);qx.bom.element.Style.setStyles(d,this.__kA(b));}if(content){this.setValue(d,content);}return d;},setValue:function(W,X){X=X||s;if(W.useHtml){W.innerHTML=X;}else if(!qx.bom.client.Feature.CSS_TEXT_OVERFLOW&&qx.bom.client.Feature.XUL){W.firstChild.setAttribute(t,X);}else{qx.bom.element.Attribute.set(W,u,X);}},getValue:function(a){if(a.useHtml){return a.innerHTML;}else if(!qx.bom.client.Feature.CSS_TEXT_OVERFLOW&&qx.bom.client.Feature.XUL){return a.firstChild.getAttribute(t)||s;}else{return qx.bom.element.Attribute.get(a,u);}},getHtmlSize:function(content,N,O){var P=this._htmlElement||this.__ky();P.style.width=O!==undefined?O+I:n;P.innerHTML=content;return this.__kB(P,N);},getTextSize:function(S,T){var U=this._textElement||this.__kx();if(!qx.bom.client.Feature.CSS_TEXT_OVERFLOW&&qx.bom.client.Feature.XUL){U.firstChild.setAttribute(t,S);}else{qx.bom.element.Attribute.set(U,u,S);}return this.__kB(U,T);},__kB:function(Y,ba){var bb=this.__kw;if(!ba){ba={};}for(var bc in bb){Y.style[bc]=ba[bc]||s;}var bd=qx.bom.element.Dimension.getSize(Y);if(qx.core.Variant.isSet(o,G)){if(!qx.bom.client.Platform.WIN){bd.width++;}}return bd;}}});})();(function(){var q="0px",p="mshtml",o="qx.client",n="qx.bom.element.Dimension",m="paddingRight",l="paddingLeft",k="paddingTop",j="paddingBottom";qx.Class.define(n,{statics:{getWidth:qx.core.Variant.select(o,{"gecko":function(D){if(D.getBoundingClientRect){var E=D.getBoundingClientRect();return Math.round(E.right)-Math.round(E.left);}else{return D.offsetWidth;}},"default":function(i){return i.offsetWidth;}}),getHeight:qx.core.Variant.select(o,{"gecko":function(t){if(t.getBoundingClientRect){var u=t.getBoundingClientRect();return Math.round(u.bottom)-Math.round(u.top);}else{return t.offsetHeight;}},"default":function(h){return h.offsetHeight;}}),getSize:function(s){return {width:this.getWidth(s),height:this.getHeight(s)};},__kC:{visible:true,hidden:true},getContentWidth:function(v){var x=qx.bom.element.Style;var y=qx.bom.element.Overflow.getX(v);var z=parseInt(x.get(v,l)||q,10);var C=parseInt(x.get(v,m)||q,10);if(this.__kC[y]){var B=v.clientWidth;if(B>0){B=B-z-C;}return B;}else{if(v.clientWidth>=v.scrollWidth){return Math.max(v.clientWidth,v.scrollWidth)-z-C;}else{var A=v.scrollWidth-z;var w=qx.bom.client.Engine;if(w.NAME===p&&w.VERSION==6){A-=C;}return A;}}},getContentHeight:function(a){var c=qx.bom.element.Style;var e=qx.bom.element.Overflow.getY(a);var f=parseInt(c.get(a,k)||q,10);var d=parseInt(c.get(a,j)||q,10);if(this.__kC[e]){return a.clientHeight-f-d;}else{if(a.clientHeight>=a.scrollHeight){return Math.max(a.clientHeight,a.scrollHeight)-f-d;}else{var g=a.scrollHeight-f;var b=qx.bom.client.Engine;if(b.NAME===p&&b.VERSION==6){g-=d;}return g;}}},getContentSize:function(r){return {width:this.getContentWidth(r),height:this.getContentHeight(r)};}}});})();(function(){var W="keypress",V="interval",U="keydown",T="mousedown",S="keyup",R="__kE",Q="blur",P="Enter",O="__kD",N="__kF",H="Up",M="Escape",K="qx.ui.menu.Manager",G="Left",F="Down",J="Right",I="singleton",L="Space";qx.Class.define(K,{type:I,extend:qx.core.Object,construct:function(){qx.core.Object.call(this);this.__kD=[];var k=document.body;var l=qx.event.Registration;l.addListener(window.document.documentElement,T,this._onMouseDown,this,true);l.addListener(k,U,this._onKeyUpDown,this,true);l.addListener(k,S,this._onKeyUpDown,this,true);l.addListener(k,W,this._onKeyPress,this,true);qx.bom.Element.addListener(window,Q,this.hideAll,this);this.__kE=new qx.event.Timer;this.__kE.addListener(V,this._onOpenInterval,this);this.__kF=new qx.event.Timer;this.__kF.addListener(V,this._onCloseInterval,this);},members:{__kG:null,__kH:null,__kE:null,__kF:null,__kD:null,_getChild:function(ba,bb,bc,bd){var be=ba.getChildren();var length=be.length;var bf;for(var i=bb;i<length&&i>=0;i+=bc){bf=be[i];if(bf.isEnabled()&&!bf.isAnonymous()){return bf;}}if(bd){i=i==length?0:length-1;for(;i!=bb;i+=bc){bf=be[i];if(bf.isEnabled()&&!bf.isAnonymous()){return bf;}}}return null;},_isInMenu:function(r){while(r){if(r instanceof qx.ui.menu.Menu){return true;}r=r.getLayoutParent();}return false;},_getMenuButton:function(a){while(a){if(a instanceof qx.ui.menu.AbstractButton){return a;}a=a.getLayoutParent();}return null;},add:function(B){{};var C=this.__kD;C.push(B);B.setZIndex(1e6+C.length);},remove:function(h){{};var j=this.__kD;if(j){qx.lang.Array.remove(j,h);}},hideAll:function(){var bm=this.__kD;if(bm){for(var i=bm.length-1;i>=0;i--){bm[i].exclude();}}},getActiveMenu:function(){var D=this.__kD;return D.length>0?D[D.length-1]:null;},scheduleOpen:function(bD){this.cancelClose(bD);if(bD.isVisible()){if(this.__kG){this.cancelOpen(this.__kG);}}else if(this.__kG!=bD){this.__kG=bD;this.__kE.restartWith(bD.getOpenInterval());}},scheduleClose:function(E){this.cancelOpen(E);if(!E.isVisible()){if(this.__kH){this.cancelClose(this.__kH);}}else if(this.__kH!=E){this.__kH=E;this.__kF.restartWith(E.getCloseInterval());}},cancelOpen:function(Y){if(this.__kG==Y){this.__kE.stop();this.__kG=null;}},cancelClose:function(X){if(this.__kH==X){this.__kF.stop();this.__kH=null;}},_onOpenInterval:function(e){this.__kE.stop();this.__kG.open();this.__kG=null;},_onCloseInterval:function(e){this.__kF.stop();this.__kH.exclude();this.__kH=null;},_onMouseDown:function(e){var m=e.getTarget();m=qx.ui.core.Widget.getWidgetByElement(m,true);if(m==null){this.hideAll();return;}if(m.getMenu&&m.getMenu()&&m.getMenu().isVisible()){return;}if(this.__kD.length>0&&!this._isInMenu(m)){this.hideAll();}},__kI:{"Enter":1,"Space":1},__kJ:{"Escape":1,"Up":1,"Down":1,"Left":1,"Right":1},_onKeyUpDown:function(e){var z=this.getActiveMenu();if(!z){return;}var A=e.getKeyIdentifier();if(this.__kJ[A]||(this.__kI[A]&&z.getSelectedButton())){e.stopPropagation();}},_onKeyPress:function(e){var by=this.getActiveMenu();if(!by){return;}var bz=e.getKeyIdentifier();var bB=this.__kJ[bz];var bA=this.__kI[bz];if(bB){switch(bz){case H:this._onKeyPressUp(by);break;case F:this._onKeyPressDown(by);break;case G:this._onKeyPressLeft(by);break;case J:this._onKeyPressRight(by);break;case M:this.hideAll();break;}e.stopPropagation();e.preventDefault();}else if(bA){var bC=by.getSelectedButton();if(bC){switch(bz){case P:this._onKeyPressEnter(by,bC,e);break;case L:this._onKeyPressSpace(by,bC,e);break;}e.stopPropagation();e.preventDefault();}}},_onKeyPressUp:function(b){var c=b.getSelectedButton();var d=b.getChildren();var g=c?b.indexOf(c)-1:d.length-1;var f=this._getChild(b,g,-1,true);if(f){b.setSelectedButton(f);}else{b.resetSelectedButton();}},_onKeyPressDown:function(n){var o=n.getSelectedButton();var q=o?n.indexOf(o)+1:0;var p=this._getChild(n,q,1,true);if(p){n.setSelectedButton(p);}else{n.resetSelectedButton();}},_onKeyPressLeft:function(s){var x=s.getOpener();if(!x){return;}if(x instanceof qx.ui.menu.AbstractButton){var u=x.getLayoutParent();u.resetOpenedButton();u.setSelectedButton(x);}else if(x instanceof qx.ui.menubar.Button){var w=x.getMenuBar().getMenuButtons();var t=w.indexOf(x);if(t===-1){return;}var y=null;var length=w.length;for(var i=1;i<=length;i++){var v=w[(t-i+length)%length];if(v.isEnabled()){y=v;break;}}if(y&&y!=x){y.open(true);}}},_onKeyPressRight:function(bp){var br=bp.getSelectedButton();if(br){var bq=br.getMenu();if(bq){bp.setOpenedButton(br);var bx=this._getChild(bq,0,1);if(bx){bq.setSelectedButton(bx);}return;}}else if(!bp.getOpenedButton()){var bx=this._getChild(bp,0,1);if(bx){bp.setSelectedButton(bx);if(bx.getMenu()){bp.setOpenedButton(bx);}return;}}var bv=bp.getOpener();if(bv instanceof qx.ui.menu.Button&&br){while(bv){bv=bv.getLayoutParent();if(bv instanceof qx.ui.menu.Menu){bv=bv.getOpener();if(bv instanceof qx.ui.menubar.Button){break;}}else{break;}}if(!bv){return;}}if(bv instanceof qx.ui.menubar.Button){var bu=bv.getMenuBar().getMenuButtons();var bs=bu.indexOf(bv);if(bs===-1){return;}var bw=null;var length=bu.length;for(var i=1;i<=length;i++){var bt=bu[(bs+i)%length];if(bt.isEnabled()){bw=bt;break;}}if(bw&&bw!=bv){bw.open(true);}}},_onKeyPressEnter:function(bg,bh,e){if(bh.hasListener(W)){var bi=e.clone();bi.setBubbles(false);bi.setTarget(bh);bh.dispatchEvent(bi);}this.hideAll();},_onKeyPressSpace:function(bj,bk,e){if(bk.hasListener(W)){var bl=e.clone();bl.setBubbles(false);bl.setTarget(bk);bk.dispatchEvent(bl);}}},destruct:function(){var bo=qx.event.Registration;var bn=document.body;bo.removeListener(window.document.documentElement,T,this._onMouseDown,this,true);bo.removeListener(bn,U,this._onKeyUpDown,this,true);bo.removeListener(bn,S,this._onKeyUpDown,this,true);bo.removeListener(bn,W,this._onKeyPress,this,true);this._disposeObjects(R,N);this._disposeArray(O);}});})();(function(){var q="indexOf",p="addAfter",o="add",n="addBefore",m="_",l="addAt",k="hasChildren",j="removeAt",i="removeAll",h="getChildren",f="remove",g="qx.ui.core.MRemoteChildrenHandling";qx.Mixin.define(g,{members:{__kK:function(A,B,C,D){var E=this.getChildrenContainer();if(E===this){A=m+A;}return (E[A])(B,C,D);},getChildren:function(){return this.__kK(h);},hasChildren:function(){return this.__kK(k);},add:function(v,w){return this.__kK(o,v,w);},remove:function(a){return this.__kK(f,a);},removeAll:function(){return this.__kK(i);},indexOf:function(r){return this.__kK(q,r);},addAt:function(b,c,d){this.__kK(l,b,c,d);},addBefore:function(x,y,z){this.__kK(n,x,y,z);},addAfter:function(s,t,u){this.__kK(p,s,t,u);},removeAt:function(e){this.__kK(j,e);}}});})();(function(){var n="slidebar",m="Integer",l="resize",k="qx.ui.core.Widget",j="selected",h="visible",g="Boolean",f="mouseout",d="excluded",c="menu",C="_applySelectedButton",B="_applySpacingY",A="_blocker",z="_applyCloseInterval",y="_applyBlockerColor",x="_applyIconColumnWidth",w="mouseover",v="_applyArrowColumnWidth",u="qx.ui.menu.Menu",t="Color",r="Number",s="_applyOpenInterval",p="_applySpacingX",q="_applyBlockerOpacity",o="_applyOpenedButton";qx.Class.define(u,{extend:qx.ui.core.Widget,include:[qx.ui.core.MPlacement,qx.ui.core.MRemoteChildrenHandling],construct:function(){qx.ui.core.Widget.call(this);this._setLayout(new qx.ui.menu.Layout);var H=this.getApplicationRoot();H.add(this);this.addListener(w,this._onMouseOver);this.addListener(f,this._onMouseOut);this.addListener(l,this._onResize,this);H.addListener(l,this._onResize,this);this._blocker=new qx.ui.core.Blocker(H);this.initVisibility();this.initKeepFocus();this.initKeepActive();},properties:{appearance:{refine:true,init:c},allowGrowX:{refine:true,init:false},allowGrowY:{refine:true,init:false},visibility:{refine:true,init:d},keepFocus:{refine:true,init:true},keepActive:{refine:true,init:true},spacingX:{check:m,apply:p,init:0,themeable:true},spacingY:{check:m,apply:B,init:0,themeable:true},iconColumnWidth:{check:m,init:0,themeable:true,apply:x},arrowColumnWidth:{check:m,init:0,themeable:true,apply:v},blockerColor:{check:t,init:null,nullable:true,apply:y,themeable:true},blockerOpacity:{check:r,init:1,apply:q,themeable:true},selectedButton:{check:k,nullable:true,apply:C},openedButton:{check:k,nullable:true,apply:o},opener:{check:k,nullable:true},openInterval:{check:m,themeable:true,init:250,apply:s},closeInterval:{check:m,themeable:true,init:250,apply:z},blockBackground:{check:g,themeable:true,init:false}},members:{__kL:null,__kM:null,_blocker:null,open:function(){if(this.getOpener()!=null){this.placeToWidget(this.getOpener());this.__kO();this.show();this._placementTarget=this.getOpener();}else{this.warn("The menu instance needs a configured 'opener' widget!");}},openAtMouse:function(e){this.placeToMouse(e);this.__kO();this.show();this._placementTarget={left:e.getDocumentLeft(),top:e.getDocumentTop()};},openAtPoint:function(J){this.placeToPoint(J);this.__kO();this.show();this._placementTarget=J;},addSeparator:function(){this.add(new qx.ui.menu.Separator);},getColumnSizes:function(){return this._getMenuLayout().getColumnSizes();},getSelectables:function(){var a=[];var b=this.getChildren();for(var i=0;i<b.length;i++){if(b[i].isEnabled()){a.push(b[i]);}}return a;},_applyIconColumnWidth:function(R,S){this._getMenuLayout().setIconColumnWidth(R);},_applyArrowColumnWidth:function(P,Q){this._getMenuLayout().setArrowColumnWidth(P);},_applySpacingX:function(bi,bj){this._getMenuLayout().setColumnSpacing(bi);},_applySpacingY:function(F,G){this._getMenuLayout().setSpacing(F);},_applyVisibility:function(be,bf){qx.ui.core.Widget.prototype._applyVisibility.call(this,be,bf);var bg=qx.ui.menu.Manager.getInstance();if(be===h){bg.add(this);var bh=this.getParentMenu();if(bh){bh.setOpenedButton(this.getOpener());}}else if(bf===h){bg.remove(this);var bh=this.getParentMenu();if(bh&&bh.getOpenedButton()==this.getOpener()){bh.resetOpenedButton();}this.resetOpenedButton();this.resetSelectedButton();}this.__kN();},__kN:function(){if(this.isVisible()){if(this.getBlockBackground()){var O=this.getZIndex();this._blocker.blockContent(O-1);}}else{if(this._blocker.isContentBlocked()){this._blocker.unblockContent();}}},getParentMenu:function(){var V=this.getOpener();if(!V||!(V instanceof qx.ui.menu.AbstractButton)){return null;}while(V&&!(V instanceof qx.ui.menu.Menu)){V=V.getLayoutParent();}return V;},_applySelectedButton:function(D,E){if(E){E.removeState(j);}if(D){D.addState(j);}},_applyOpenedButton:function(Y,ba){if(ba){ba.getMenu().exclude();}if(Y){Y.getMenu().open();}},_applyBlockerColor:function(T,U){this._blocker.setColor(T);},_applyBlockerOpacity:function(W,X){this._blocker.setOpacity(W);},getChildrenContainer:function(){return this.getChildControl(n,true)||this;},_createChildControlImpl:function(bn){var bo;switch(bn){case n:var bo=new qx.ui.menu.MenuSlideBar();var bq=this._getLayout();this._setLayout(new qx.ui.layout.Grow());var bp=bo.getLayout();bo.setLayout(bq);bp.dispose();var br=qx.lang.Array.clone(this.getChildren());for(var i=0;i<br.length;i++){bo.add(br[i]);}this.removeListener(l,this._onResize,this);bo.getChildrenContainer().addListener(l,this._onResize,this);this._add(bo);break;}return bo||qx.ui.core.Widget.prototype._createChildControlImpl.call(this,bn);},_getMenuLayout:function(){if(this.hasChildControl(n)){return this.getChildControl(n).getChildrenContainer().getLayout();}else{return this._getLayout();}},_getMenuBounds:function(){if(this.hasChildControl(n)){return this.getChildControl(n).getChildrenContainer().getBounds();}else{return this.getBounds();}},_computePlacementSize:function(){return this._getMenuBounds();},__kO:function(){var bc=this._getMenuBounds();if(!bc){this.addListenerOnce(l,this.__kO,this);return;}var bb=this.getLayoutParent().getBounds().height;var top=this.getLayoutProperties().top;var bd=this.getLayoutProperties().left;if(top<0){this._assertSlideBar(function(){this.setHeight(bc.height+top);this.moveTo(bd,0);});}else if(top+bc.height>bb){this._assertSlideBar(function(){this.setHeight(bb-top);});}else{this.setHeight(null);}},_assertSlideBar:function(I){if(this.hasChildControl(n)){return I.call(this);}this.__kM=I;qx.ui.core.queue.Widget.add(this);},syncWidget:function(){this.getChildControl(n);if(this.__kM){this.__kM.call(this);delete this.__kM;}},_onResize:function(){if(this.isVisible()){var bm=this._placementTarget;if(!bm){return;}else if(bm instanceof qx.ui.core.Widget){this.placeToWidget(bm);}else if(bm.top!==undefined){this.placeToPoint(bm);}else{throw new Error("Unknown target: "+bm);}this.__kO();}},_onMouseOver:function(e){var L=qx.ui.menu.Manager.getInstance();L.cancelClose(this);var M=e.getTarget();if(M.isEnabled()&&M instanceof qx.ui.menu.AbstractButton){this.setSelectedButton(M);var K=M.getMenu&&M.getMenu();if(K){K.setOpener(M);L.scheduleOpen(K);this.__kL=K;}else{var N=this.getOpenedButton();if(N){L.scheduleClose(N.getMenu());}if(this.__kL){L.cancelOpen(this.__kL);this.__kL=null;}}}else if(!this.getOpenedButton()){this.resetSelectedButton();}},_onMouseOut:function(e){var bk=qx.ui.menu.Manager.getInstance();if(!qx.ui.core.Widget.contains(this,e.getRelatedTarget())){var bl=this.getOpenedButton();bl?this.setSelectedButton(bl):this.resetSelectedButton();if(bl){bk.cancelClose(bl.getMenu());}if(this.__kL){bk.cancelOpen(this.__kL);}}}},destruct:function(){if(!qx.core.ObjectRegistry.inShutDown){qx.ui.menu.Manager.getInstance().remove(this);}this.getApplicationRoot().removeListener(l,this._onResize,this);this._placementTarget=null;this._disposeObjects(A);}});})();(function(){var c="Integer",b="_applyLayoutChange",a="qx.ui.menu.Layout";qx.Class.define(a,{extend:qx.ui.layout.VBox,properties:{columnSpacing:{check:c,init:0,apply:b},spanColumn:{check:c,init:1,nullable:true,apply:b},iconColumnWidth:{check:c,init:0,themeable:true,apply:b},arrowColumnWidth:{check:c,init:0,themeable:true,apply:b}},members:{__kP:null,_computeSizeHint:function(){var q=this._getLayoutChildren();var o,g,j;var e=this.getSpanColumn();var h=this.__kP=[0,0,0,0];var m=this.getColumnSpacing();var k=0;var f=0;for(var i=0,l=q.length;i<l;i++){o=q[i];if(o.isAnonymous()){continue;}g=o.getChildrenSizes();for(var n=0;n<g.length;n++){if(e!=null&&n==e&&g[e+1]==0){k=Math.max(k,g[n]);}else{h[n]=Math.max(h[n],g[n]);}}var d=q[i].getInsets();f=Math.max(f,d.left+d.right);}if(e!=null&&h[e]+m+h[e+1]<k){h[e]=k-h[e+1]-m;}if(k==0){j=m*2;}else{j=m*3;}if(h[0]==0){h[0]=this.getIconColumnWidth();}if(h[3]==0){h[3]=this.getArrowColumnWidth();}var p=qx.ui.layout.VBox.prototype._computeSizeHint.call(this).height;return {minHeight:p,height:p,width:qx.lang.Array.sum(h)+f+j};},getColumnSizes:function(){return this.__kP||null;}},destruct:function(){this.__kP=null;}});})();(function(){var F="zIndex",E="px",D="keydown",C="deactivate",B="resize",A="keyup",z="keypress",y="backgroundColor",x="_applyOpacity",w="Boolean",R="__kX",Q="opacity",P="interval",O="Tab",N="__kT",M="Color",L="__kV",K="qx.ui.root.Page",J="Number",I="qx.ui.core.Blocker",G="qx.ui.root.Application",H="_applyColor";qx.Class.define(I,{extend:qx.core.Object,construct:function(d){qx.core.Object.call(this);this._widget=d;this._isPageRoot=(qx.Class.isDefined(K)&&d instanceof qx.ui.root.Page);if(this._isPageRoot){d.addListener(B,this.__kY,this);}if(qx.Class.isDefined(G)&&d instanceof qx.ui.root.Application){this.setKeepBlockerActive(true);}this.__kQ=[];this.__kR=[];this.__kS=[];},properties:{color:{check:M,init:null,nullable:true,apply:H,themeable:true},opacity:{check:J,init:1,apply:x,themeable:true},keepBlockerActive:{check:w,init:false}},members:{__kT:null,__kU:0,__kV:null,__kS:null,__kQ:null,__kR:null,__kW:null,__kX:null,_isPageRoot:false,_widget:null,__kY:function(e){var U=e.getData();if(this.isContentBlocked()){this.getContentBlockerElement().setStyles({width:U.width,height:U.height});}if(this.isBlocked()){this.getBlockerElement().setStyles({width:U.width,height:U.height});}},_applyColor:function(f,g){var h=qx.theme.manager.Color.getInstance().resolve(f);this.__la(y,h);},_applyOpacity:function(S,T){this.__la(Q,S);},__la:function(l,m){var n=[];this.__kT&&n.push(this.__kT);this.__kV&&n.push(this.__kV);for(var i=0;i<n.length;i++){n[i].setStyle(l,m);}},_backupActiveWidget:function(){var a=qx.event.Registration.getManager(window).getHandler(qx.event.handler.Focus);this.__kQ.push(a.getActive());this.__kR.push(a.getFocus());if(this._widget.isFocusable()){this._widget.focus();}},_restoreActiveWidget:function(){var s=this.__kQ.length;if(s>0){var r=this.__kQ[s-1];if(r){qx.bom.Element.activate(r);}this.__kQ.pop();}var q=this.__kR.length;if(q>0){var r=this.__kR[q-1];if(r){qx.bom.Element.focus(this.__kR[q-1]);}this.__kR.pop();}},__lb:function(){return new qx.html.Blocker(this.getColor(),this.getOpacity());},getBlockerElement:function(){if(!this.__kT){this.__kT=this.__lb();this.__kT.setStyle(F,15);this._widget.getContainerElement().add(this.__kT);this.__kT.exclude();}return this.__kT;},block:function(){this.__kU++;if(this.__kU<2){this._backupActiveWidget();var k=this.getBlockerElement();k.include();k.activate();k.addListener(C,this.__lg,this);k.addListener(z,this.__lf,this);k.addListener(D,this.__lf,this);k.addListener(A,this.__lf,this);}},isBlocked:function(){return this.__kU>0;},unblock:function(){if(!this.isBlocked()){return;}this.__kU--;if(this.__kU<1){this.__lc();this.__kU=0;}},forceUnblock:function(){if(!this.isBlocked()){return;}this.__kU=0;this.__lc();},__lc:function(){this._restoreActiveWidget();var j=this.getBlockerElement();j.removeListener(C,this.__lg,this);j.removeListener(z,this.__lf,this);j.removeListener(D,this.__lf,this);j.removeListener(A,this.__lf,this);j.exclude();},getContentBlockerElement:function(){if(!this.__kV){this.__kV=this.__lb();this._widget.getContentElement().add(this.__kV);this.__kV.exclude();}return this.__kV;},blockContent:function(t){var u=this.getContentBlockerElement();u.setStyle(F,t);this.__kS.push(t);if(this.__kS.length<2){u.include();if(this._isPageRoot){if(!this.__kX){this.__kX=new qx.event.Timer(300);this.__kX.addListener(P,this.__le,this);}this.__kX.start();this.__le();}}},isContentBlocked:function(){return this.__kS.length>0;},unblockContent:function(){if(!this.isContentBlocked()){return;}this.__kS.pop();var b=this.__kS[this.__kS.length-1];var c=this.getContentBlockerElement();c.setStyle(F,b);if(this.__kS.length<1){this.__ld();this.__kS=[];}},forceUnblockContent:function(){if(!this.isContentBlocked()){return;}this.__kS=[];var v=this.getContentBlockerElement();v.setStyle(F,null);this.__ld();},__ld:function(){this.getContentBlockerElement().exclude();if(this._isPageRoot){this.__kX.stop();}},__le:function(){var o=this._widget.getContainerElement().getDomElement();var p=qx.dom.Node.getDocument(o);this.getContentBlockerElement().setStyles({height:p.documentElement.scrollHeight+E,width:p.documentElement.scrollWidth+E});},__lf:function(e){if(e.getKeyIdentifier()==O){e.stop();}},__lg:function(){if(this.getKeepBlockerActive()){this.getBlockerElement().activate();}}},destruct:function(){if(this._isPageRoot){this._widget.removeListener(B,this.__kY,this);}this._disposeObjects(L,N,R);this.__kW=this.__kQ=this.__kR=this._widget=this.__kS=null;}});})();(function(){var j="_applyBlockerColor",i="Number",h="__lh",g="qx.ui.core.MBlocker",f="_applyBlockerOpacity",e="Color";qx.Mixin.define(g,{construct:function(){this.__lh=new qx.ui.core.Blocker(this);},properties:{blockerColor:{check:e,init:null,nullable:true,apply:j,themeable:true},blockerOpacity:{check:i,init:1,apply:f,themeable:true}},members:{__lh:null,_applyBlockerColor:function(a,b){this.__lh.setColor(a);},_applyBlockerOpacity:function(c,d){this.__lh.setOpacity(c);},block:function(){this.__lh.block();},isBlocked:function(){return this.__lh.isBlocked();},unblock:function(){this.__lh.unblock();},forceUnblock:function(){this.__lh.forceUnblock();},blockContent:function(k){this.__lh.blockContent(k);},isContentBlocked:function(){return this.__lh.isContentBlocked();},unblockContent:function(){this.__lh.unblockContent();},forceUnblockContent:function(){this.__lh.forceUnblockContent();},getBlocker:function(){return this.__lh;}},destruct:function(){this._disposeObjects(h);}});})();(function(){var l="qx.ui.window.Window",k="changeModal",j="changeVisibility",i="changeActive",h="_applyActiveWindow",g="__li",f="qx.ui.window.MDesktop",d="__lj";qx.Mixin.define(f,{properties:{activeWindow:{check:l,apply:h,init:null,nullable:true}},members:{__li:null,__lj:null,getWindowManager:function(){if(!this.__lj){this.setWindowManager(new qx.ui.window.Window.DEFAULT_MANAGER_CLASS());}return this.__lj;},supportsMaximize:function(){return true;},setWindowManager:function(c){if(this.__lj){this.__lj.setDesktop(null);}c.setDesktop(this);this.__lj=c;},_onChangeActive:function(e){if(e.getData()){this.setActiveWindow(e.getTarget());}else if(this.getActiveWindow()==e.getTarget()){this.setActiveWindow(null);}},_applyActiveWindow:function(o,p){this.getWindowManager().changeActiveWindow(o,p);this.getWindowManager().updateStack();},_onChangeModal:function(e){this.getWindowManager().updateStack();},_onChangeVisibility:function(){this.getWindowManager().updateStack();},_afterAddChild:function(n){if(qx.Class.isDefined(l)&&n instanceof qx.ui.window.Window){this._addWindow(n);}},_addWindow:function(a){if(!qx.lang.Array.contains(this.getWindows(),a)){this.getWindows().push(a);a.addListener(i,this._onChangeActive,this);a.addListener(k,this._onChangeModal,this);a.addListener(j,this._onChangeVisibility,this);}if(a.getActive()){this.setActiveWindow(a);}this.getWindowManager().updateStack();},_afterRemoveChild:function(m){if(qx.Class.isDefined(l)&&m instanceof qx.ui.window.Window){this._removeWindow(m);}},_removeWindow:function(b){qx.lang.Array.remove(this.getWindows(),b);b.removeListener(i,this._onChangeActive,this);b.removeListener(k,this._onChangeModal,this);b.removeListener(j,this._onChangeVisibility,this);this.getWindowManager().updateStack();},getWindows:function(){if(!this.__li){this.__li=[];}return this.__li;}},destruct:function(){this._disposeArray(g);this._disposeObjects(d);}});})();(function(){var r="contextmenu",q="help",p="qx.client",o="changeGlobalCursor",n="abstract",m="Boolean",l="root",k="",j=" !important",i="_applyGlobalCursor",f="_applyNativeHelp",h=";",g="qx.ui.root.Abstract",d="String",c="*";qx.Class.define(g,{type:n,extend:qx.ui.core.Widget,include:[qx.ui.core.MChildrenHandling,qx.ui.core.MBlocker,qx.ui.window.MDesktop],construct:function(){qx.ui.core.Widget.call(this);qx.ui.core.FocusHandler.getInstance().addRoot(this);qx.ui.core.queue.Visibility.add(this);this.initNativeHelp();},properties:{appearance:{refine:true,init:l},enabled:{refine:true,init:true},focusable:{refine:true,init:true},globalCursor:{check:d,nullable:true,themeable:true,apply:i,event:o},nativeContextMenu:{refine:true,init:false},nativeHelp:{check:m,init:false,apply:f}},members:{__lk:null,isRootWidget:function(){return true;},getLayout:function(){return this._getLayout();},_applyGlobalCursor:qx.core.Variant.select(p,{"mshtml":function(a,b){},"default":function(w,x){var y=qx.bom.Stylesheet;var z=this.__lk;if(!z){this.__lk=z=y.createElement();}y.removeAllRules(z);if(w){y.addRule(z,c,qx.bom.element.Cursor.compile(w).replace(h,k)+j);}}}),_applyNativeContextMenu:function(u,v){if(u){this.removeListener(r,this._onNativeContextMenu,this,true);}else{this.addListener(r,this._onNativeContextMenu,this,true);}},_onNativeContextMenu:function(e){if(e.getTarget().getNativeContextMenu()){return;}e.preventDefault();},_applyNativeHelp:qx.core.Variant.select(p,{"mshtml":function(A,B){if(B===false){qx.bom.Event.removeNativeListener(document,q,qx.lang.Function.returnFalse);}if(A===false){qx.bom.Event.addNativeListener(document,q,qx.lang.Function.returnFalse);}},"default":function(){}})},destruct:function(){this.__lk=null;},defer:function(s,t){qx.ui.core.MChildrenHandling.remap(t);}});})();(function(){var w="resize",v="position",u="0px",t="webkit",s="paddingLeft",r="$$widget",q="qx.ui.root.Application",p="hidden",o="qx.client",n="div",k="paddingTop",m="100%",l="absolute";qx.Class.define(q,{extend:qx.ui.root.Abstract,construct:function(g){this.__ll=qx.dom.Node.getWindow(g);this.__lm=g;qx.ui.root.Abstract.call(this);qx.event.Registration.addListener(this.__ll,w,this._onResize,this);this._setLayout(new qx.ui.layout.Canvas());qx.ui.core.queue.Layout.add(this);qx.ui.core.FocusHandler.getInstance().connectTo(this);this.getContentElement().disableScrolling();},members:{__ll:null,__lm:null,_createContainerElement:function(){var a=this.__lm;if(qx.core.Variant.isSet(o,t)){if(!a.body){alert("The application could not be started due to a missing body tag in the HTML file!");}}var f=a.documentElement.style;var b=a.body.style;f.overflow=b.overflow=p;f.padding=f.margin=b.padding=b.margin=u;f.width=f.height=b.width=b.height=m;var d=a.createElement(n);a.body.appendChild(d);var c=new qx.html.Root(d);c.setStyle(v,l);c.setAttribute(r,this.toHashCode());return c;},_onResize:function(e){qx.ui.core.queue.Layout.add(this);},_computeSizeHint:function(){var z=qx.bom.Viewport.getWidth(this.__ll);var A=qx.bom.Viewport.getHeight(this.__ll);return {minWidth:z,width:z,maxWidth:z,minHeight:A,height:A,maxHeight:A};},_applyPadding:function(x,y,name){if(x&&(name==k||name==s)){throw new Error("The root widget does not support 'left', or 'top' paddings!");}qx.ui.root.Abstract.prototype._applyPadding.call(this,x,y,name);},_applyDecorator:function(h,i){qx.ui.root.Abstract.prototype._applyDecorator.call(this,h,i);if(!h){return;}var j=this.getDecoratorElement().getInsets();if(j.left||j.top){throw new Error("The root widget does not support decorators with 'left', or 'top' insets!");}}},destruct:function(){this.__ll=this.__lm=null;}});})();(function(){var w="__ln",v="keypress",u="focusout",t="activate",s="Tab",r="singleton",q="deactivate",p="focusin",o="qx.ui.core.FocusHandler";qx.Class.define(o,{extend:qx.core.Object,type:r,construct:function(){qx.core.Object.call(this);this.__ln={};},members:{__ln:null,__lo:null,__lp:null,__lq:null,connectTo:function(D){D.addListener(v,this.__lr,this);D.addListener(p,this._onFocusIn,this,true);D.addListener(u,this._onFocusOut,this,true);D.addListener(t,this._onActivate,this,true);D.addListener(q,this._onDeactivate,this,true);},addRoot:function(K){this.__ln[K.$$hash]=K;},removeRoot:function(F){delete this.__ln[F.$$hash];},getActiveWidget:function(){return this.__lo;},isActive:function(x){return this.__lo==x;},getFocusedWidget:function(){return this.__lp;},isFocused:function(M){return this.__lp==M;},isFocusRoot:function(y){return !!this.__ln[y.$$hash];},_onActivate:function(e){var Q=e.getTarget();this.__lo=Q;var P=this.__ls(Q);if(P!=this.__lq){this.__lq=P;}},_onDeactivate:function(e){var n=e.getTarget();if(this.__lo==n){this.__lo=null;}},_onFocusIn:function(e){var E=e.getTarget();if(E!=this.__lp){this.__lp=E;E.visualizeFocus();}},_onFocusOut:function(e){var L=e.getTarget();if(L==this.__lp){this.__lp=null;L.visualizeBlur();}},__lr:function(e){if(e.getKeyIdentifier()!=s){return;}if(!this.__lq){return;}e.stopPropagation();e.preventDefault();var R=this.__lp;if(!e.isShiftPressed()){var S=R?this.__lw(R):this.__lu();}else{var S=R?this.__lx(R):this.__lv();}if(S){S.tabFocus();}},__ls:function(N){var O=this.__ln;while(N){if(O[N.$$hash]){return N;}N=N.getLayoutParent();}return null;},__lt:function(T,U){if(T===U){return 0;}var W=T.getTabIndex()||0;var V=U.getTabIndex()||0;if(W!=V){return W-V;}var bc=T.getContainerElement().getDomElement();var bb=U.getContainerElement().getDomElement();var ba=qx.bom.element.Location;var Y=ba.get(bc);var X=ba.get(bb);if(Y.top!=X.top){return Y.top-X.top;}if(Y.left!=X.left){return Y.left-X.left;}var bd=T.getZIndex();var be=U.getZIndex();if(bd!=be){return bd-be;}return 0;},__lu:function(){return this.__lA(this.__lq,null);},__lv:function(){return this.__lB(this.__lq,null);},__lw:function(z){var A=this.__lq;if(A==z){return this.__lu();}while(z&&z.getAnonymous()){z=z.getLayoutParent();}if(z==null){return [];}var B=[];this.__ly(A,z,B);B.sort(this.__lt);var C=B.length;return C>0?B[0]:this.__lu();},__lx:function(bf){var bg=this.__lq;if(bg==bf){return this.__lv();}while(bf&&bf.getAnonymous()){bf=bf.getLayoutParent();}if(bf==null){return [];}var bh=[];this.__lz(bg,bf,bh);bh.sort(this.__lt);var bi=bh.length;return bi>0?bh[bi-1]:this.__lv();},__ly:function(parent,G,H){var I=parent.getLayoutChildren();var J;for(var i=0,l=I.length;i<l;i++){J=I[i];if(!(J instanceof qx.ui.core.Widget)){continue;}if(!this.isFocusRoot(J)&&J.isEnabled()&&J.isVisible()){if(J.isTabable()&&this.__lt(G,J)<0){H.push(J);}this.__ly(J,G,H);}}},__lz:function(parent,d,f){var g=parent.getLayoutChildren();var h;for(var i=0,l=g.length;i<l;i++){h=g[i];if(!(h instanceof qx.ui.core.Widget)){continue;}if(!this.isFocusRoot(h)&&h.isEnabled()&&h.isVisible()){if(h.isTabable()&&this.__lt(d,h)>0){f.push(h);}this.__lz(h,d,f);}}},__lA:function(parent,j){var k=parent.getLayoutChildren();var m;for(var i=0,l=k.length;i<l;i++){m=k[i];if(!(m instanceof qx.ui.core.Widget)){continue;}if(!this.isFocusRoot(m)&&m.isEnabled()&&m.isVisible()){if(m.isTabable()){if(j==null||this.__lt(m,j)<0){j=m;}}j=this.__lA(m,j);}}return j;},__lB:function(parent,a){var b=parent.getLayoutChildren();var c;for(var i=0,l=b.length;i<l;i++){c=b[i];if(!(c instanceof qx.ui.core.Widget)){continue;}if(!this.isFocusRoot(c)&&c.isEnabled()&&c.isVisible()){if(c.isTabable()){if(a==null||this.__lt(c,a)>0){a=c;}}a=this.__lB(c,a);}}return a;}},destruct:function(){this._disposeMap(w);this.__lp=this.__lo=this.__lq=null;}});})();(function(){var r="qx.client",q="head",p="text/css",o="stylesheet",n="}",m='@import "',l="{",k='";',j="qx.bom.Stylesheet",h="link",g="style";qx.Class.define(j,{statics:{includeFile:function(u,v){if(!v){v=document;}var w=v.createElement(h);w.type=p;w.rel=o;w.href=qx.util.ResourceManager.getInstance().toUri(u);var x=v.getElementsByTagName(q)[0];x.appendChild(w);},createElement:qx.core.Variant.select(r,{"mshtml":function(c){var d=document.createStyleSheet();if(c){d.cssText=c;}return d;},"default":function(s){var t=document.createElement(g);t.type=p;if(s){t.appendChild(document.createTextNode(s));}document.getElementsByTagName(q)[0].appendChild(t);return t.sheet;}}),addRule:qx.core.Variant.select(r,{"mshtml":function(B,C,D){B.addRule(C,D);},"default":function(I,J,K){I.insertRule(J+l+K+n,I.cssRules.length);}}),removeRule:qx.core.Variant.select(r,{"mshtml":function(bd,be){var bf=bd.rules;var bg=bf.length;for(var i=bg-1;i>=0;--i){if(bf[i].selectorText==be){bd.removeRule(i);}}},"default":function(R,S){var T=R.cssRules;var U=T.length;for(var i=U-1;i>=0;--i){if(T[i].selectorText==S){R.deleteRule(i);}}}}),removeAllRules:qx.core.Variant.select(r,{"mshtml":function(L){var M=L.rules;var N=M.length;for(var i=N-1;i>=0;i--){L.removeRule(i);}},"default":function(O){var P=O.cssRules;var Q=P.length;for(var i=Q-1;i>=0;i--){O.deleteRule(i);}}}),addImport:qx.core.Variant.select(r,{"mshtml":function(a,b){a.addImport(b);},"default":function(e,f){e.insertRule(m+f+k,e.cssRules.length);}}),removeImport:qx.core.Variant.select(r,{"mshtml":function(E,F){var G=E.imports;var H=G.length;for(var i=H-1;i>=0;i--){if(G[i].href==F){E.removeImport(i);}}},"default":function(V,W){var X=V.cssRules;var Y=X.length;for(var i=Y-1;i>=0;i--){if(X[i].href==W){V.deleteRule(i);}}}}),removeAllImports:qx.core.Variant.select(r,{"mshtml":function(y){var z=y.imports;var A=z.length;for(var i=A-1;i>=0;i--){y.removeImport(i);}},"default":function(ba){var bb=ba.cssRules;var bc=bb.length;for(var i=bc-1;i>=0;i--){if(bb[i].type==bb[i].IMPORT_RULE){ba.deleteRule(i);}}}})}});})();(function(){var b="number",a="qx.ui.layout.Canvas";qx.Class.define(a,{extend:qx.ui.layout.Abstract,members:{verifyLayoutProperty:null,renderLayout:function(v,w){var H=this._getLayoutChildren();var z,G,E;var J,top,x,y,B,A;var F,D,I,C;for(var i=0,l=H.length;i<l;i++){z=H[i];G=z.getSizeHint();E=z.getLayoutProperties();F=z.getMarginTop();D=z.getMarginRight();I=z.getMarginBottom();C=z.getMarginLeft();J=E.left!=null?E.left:E.edge;if(qx.lang.Type.isString(J)){J=Math.round(parseFloat(J)*v/100);}x=E.right!=null?E.right:E.edge;if(qx.lang.Type.isString(x)){x=Math.round(parseFloat(x)*v/100);}top=E.top!=null?E.top:E.edge;if(qx.lang.Type.isString(top)){top=Math.round(parseFloat(top)*w/100);}y=E.bottom!=null?E.bottom:E.edge;if(qx.lang.Type.isString(y)){y=Math.round(parseFloat(y)*w/100);}if(J!=null&&x!=null){B=v-J-x-C-D;if(B<G.minWidth){B=G.minWidth;}else if(B>G.maxWidth){B=G.maxWidth;}J+=C;}else{B=E.width;if(B==null){B=G.width;}else{B=Math.round(parseFloat(B)*v/100);if(B<G.minWidth){B=G.minWidth;}else if(B>G.maxWidth){B=G.maxWidth;}}if(x!=null){J=v-B-x-D-C;}else if(J==null){J=C;}else{J+=C;}}if(top!=null&&y!=null){A=w-top-y-F-I;if(A<G.minHeight){A=G.minHeight;}else if(A>G.maxHeight){A=G.maxHeight;}top+=F;}else{A=E.height;if(A==null){A=G.height;}else{A=Math.round(parseFloat(A)*w/100);if(A<G.minHeight){A=G.minHeight;}else if(A>G.maxHeight){A=G.maxHeight;}}if(y!=null){top=w-A-y-I-F;}else if(top==null){top=F;}else{top+=F;}}z.renderLayout(J,top,B,A);}},_computeSizeHint:function(){var t=0,s=0;var q=0,o=0;var m,k;var j,g;var c=this._getLayoutChildren();var f,r,e;var u,top,d,h;for(var i=0,l=c.length;i<l;i++){f=c[i];r=f.getLayoutProperties();e=f.getSizeHint();var p=f.getMarginLeft()+f.getMarginRight();var n=f.getMarginTop()+f.getMarginBottom();m=e.width+p;k=e.minWidth+p;u=r.left!=null?r.left:r.edge;if(u&&typeof u===b){m+=u;k+=u;}d=r.right!=null?r.right:r.edge;if(d&&typeof d===b){m+=d;k+=d;}t=Math.max(t,m);s=Math.max(s,k);j=e.height+n;g=e.minHeight+n;top=r.top!=null?r.top:r.edge;if(top&&typeof top===b){j+=top;g+=top;}h=r.bottom!=null?r.bottom:r.edge;if(h&&typeof h===b){j+=h;g+=h;}q=Math.max(q,j);o=Math.max(o,g);}return {width:t,minWidth:s,height:q,minHeight:o};}}});})();(function(){var a="qx.html.Root";qx.Class.define(a,{extend:qx.html.Element,construct:function(c){qx.html.Element.call(this);if(c!=null){this.useElement(c);}},members:{useElement:function(b){qx.html.Element.prototype.useElement.call(this,b);this.setRoot(true);qx.html.Element._modified[this.$$hash]=this;}}});})();(function(){var n="cursor",m="100%",l="repeat",k="mousedown",j="url(",i=")",h="mouseout",g="qx.client",f="div",d="dblclick",z="mousewheel",y="qx.html.Blocker",x="mousemove",w="mouseover",v="appear",u="click",t="mshtml",s="mouseup",r="contextmenu",q="disappear",o="qx/static/blank.gif",p="absolute";qx.Class.define(y,{extend:qx.html.Element,construct:function(a,b){var a=a?qx.theme.manager.Color.getInstance().resolve(a):null;var c={position:p,width:m,height:m,opacity:b||0,backgroundColor:a};if(qx.core.Variant.isSet(g,t)){c.backgroundImage=j+qx.util.ResourceManager.getInstance().toUri(o)+i;c.backgroundRepeat=l;}qx.html.Element.call(this,f,c);this.addListener(k,this._stopPropagation,this);this.addListener(s,this._stopPropagation,this);this.addListener(u,this._stopPropagation,this);this.addListener(d,this._stopPropagation,this);this.addListener(x,this._stopPropagation,this);this.addListener(w,this._stopPropagation,this);this.addListener(h,this._stopPropagation,this);this.addListener(z,this._stopPropagation,this);this.addListener(r,this._stopPropagation,this);this.addListener(v,this.__lC,this);this.addListener(q,this.__lC,this);},members:{_stopPropagation:function(e){e.stopPropagation();},__lC:function(){var A=this.getStyle(n);this.setStyle(n,null,true);this.setStyle(n,A,true);}}});})();(function(){var b="menu-separator",a="qx.ui.menu.Separator";qx.Class.define(a,{extend:qx.ui.core.Widget,properties:{appearance:{refine:true,init:b},anonymous:{refine:true,init:true}}});})();(function(){var w="icon",v="label",u="arrow",t="shortcut",s="changeLocale",r="qx.dynlocale",q="submenu",p="on",o="String",n="qx.ui.menu.Menu",h="qx.ui.menu.AbstractButton",m="keypress",k="",g="_applyIcon",f="mouseup",j="abstract",i="_applyLabel",l="_applyMenu",d="changeCommand";qx.Class.define(h,{extend:qx.ui.core.Widget,include:[qx.ui.core.MExecutable],implement:[qx.ui.form.IExecutable],type:j,construct:function(){qx.ui.core.Widget.call(this);this._setLayout(new qx.ui.menu.ButtonLayout);this.addListener(f,this._onMouseUp);this.addListener(m,this._onKeyPress);this.addListener(d,this._onChangeCommand,this);},properties:{blockToolTip:{refine:true,init:true},label:{check:o,apply:i,nullable:true},menu:{check:n,apply:l,nullable:true,dereference:true},icon:{check:o,apply:g,themeable:true,nullable:true}},members:{_createChildControlImpl:function(b){var c;switch(b){case w:c=new qx.ui.basic.Image;c.setAnonymous(true);this._add(c,{column:0});break;case v:c=new qx.ui.basic.Label;c.setAnonymous(true);this._add(c,{column:1});break;case t:c=new qx.ui.basic.Label;c.setAnonymous(true);this._add(c,{column:2});break;case u:c=new qx.ui.basic.Image;c.setAnonymous(true);this._add(c,{column:3});break;}return c||qx.ui.core.Widget.prototype._createChildControlImpl.call(this,b);},_forwardStates:{selected:1},getChildrenSizes:function(){var x=0,y=0,z=0,D=0;if(this._isChildControlVisible(w)){var E=this.getChildControl(w);x=E.getMarginLeft()+E.getSizeHint().width+E.getMarginRight();}if(this._isChildControlVisible(v)){var B=this.getChildControl(v);y=B.getMarginLeft()+B.getSizeHint().width+B.getMarginRight();}if(this._isChildControlVisible(t)){var A=this.getChildControl(t);z=A.getMarginLeft()+A.getSizeHint().width+A.getMarginRight();}if(this._isChildControlVisible(u)){var C=this.getChildControl(u);D=C.getMarginLeft()+C.getSizeHint().width+C.getMarginRight();}return [x,y,z,D];},_onMouseUp:function(e){},_onKeyPress:function(e){},_onChangeCommand:function(e){var L=e.getData();if(qx.core.Variant.isSet(r,p)){var J=e.getOldData();if(!J){qx.locale.Manager.getInstance().addListener(s,this._onChangeLocale,this);}if(!L){qx.locale.Manager.getInstance().removeListener(s,this._onChangeLocale,this);}}var K=L!=null?L.toString():k;this.getChildControl(t).setValue(K);},_onChangeLocale:qx.core.Variant.select(r,{"on":function(e){var a=this.getCommand();if(a!=null){this.getChildControl(t).setValue(a.toString());}},"off":null}),_applyIcon:function(F,G){if(F){this._showChildControl(w).setSource(F);}else{this._excludeChildControl(w);}},_applyLabel:function(M,N){if(M){this._showChildControl(v).setValue(M);}else{this._excludeChildControl(v);}},_applyMenu:function(H,I){if(I){I.resetOpener();I.removeState(q);}if(H){this._showChildControl(u);H.setOpener(this);H.addState(q);}else{this._excludeChildControl(u);}}},destruct:function(){if(this.getMenu()){if(!qx.core.ObjectRegistry.inShutDown){this.getMenu().destroy();}}if(qx.core.Variant.isSet(r,p)){qx.locale.Manager.getInstance().removeListener(s,this._onChangeLocale,this);}}});})();(function(){var c="middle",b="qx.ui.menu.ButtonLayout",a="left";qx.Class.define(b,{extend:qx.ui.layout.Abstract,members:{verifyLayoutProperty:null,renderLayout:function(d,e){var q=this._getLayoutChildren();var p;var g;var h=[];for(var i=0,l=q.length;i<l;i++){p=q[i];g=p.getLayoutProperties().column;h[g]=p;}var o=this.__lD(q[0]);var r=o.getColumnSizes();var k=o.getSpacingX();var j=qx.lang.Array.sum(r)+k*(r.length-1);if(j<d){r[1]+=d-j;}var s=0,top=0;var m=qx.ui.layout.Util;for(var i=0,l=r.length;i<l;i++){p=h[i];if(p){var f=p.getSizeHint();var top=m.computeVerticalAlignOffset(p.getAlignY()||c,f.height,e,0,0);var n=m.computeHorizontalAlignOffset(p.getAlignX()||a,f.width,r[i],p.getMarginLeft(),p.getMarginRight());p.renderLayout(s+n,top,f.width,f.height);}s+=r[i]+k;}},__lD:function(t){while(!(t instanceof qx.ui.menu.Menu)){t=t.getLayoutParent();}return t;},_computeSizeHint:function(){var w=this._getLayoutChildren();var v=0;var x=0;for(var i=0,l=w.length;i<l;i++){var u=w[i].getSizeHint();x+=u.width;v=Math.max(v,u.height);}return {width:x,height:v};}}});})();(function(){var a="qx.ui.core.MRemoteLayoutHandling";qx.Mixin.define(a,{members:{setLayout:function(b){return this.getChildrenContainer().setLayout(b);},getLayout:function(){return this.getChildrenContainer().getLayout();}}});})();(function(){var z="horizontal",y="scrollpane",x="vertical",w="button-backward",v="button-forward",u="content",t="execute",s="qx.ui.container.SlideBar",r="scrollY",q="removeChildWidget",m="scrollX",p="_applyOrientation",o="mousewheel",l="Integer",k="slidebar",n="update";qx.Class.define(s,{extend:qx.ui.core.Widget,include:[qx.ui.core.MRemoteChildrenHandling,qx.ui.core.MRemoteLayoutHandling],construct:function(C){qx.ui.core.Widget.call(this);var D=this.getChildControl(y);this._add(D,{flex:1});if(C!=null){this.setOrientation(C);}else{this.initOrientation();}this.addListener(o,this._onMouseWheel,this);},properties:{appearance:{refine:true,init:k},orientation:{check:[z,x],init:z,apply:p},scrollStep:{check:l,init:15,themeable:true}},members:{getChildrenContainer:function(){return this.getChildControl(u);},_createChildControlImpl:function(g){var h;switch(g){case v:h=new qx.ui.form.RepeatButton;h.addListener(t,this._onExecuteForward,this);h.setFocusable(false);this._addAt(h,2);break;case w:h=new qx.ui.form.RepeatButton;h.addListener(t,this._onExecuteBackward,this);h.setFocusable(false);this._addAt(h,0);break;case u:h=new qx.ui.container.Composite();if(qx.bom.client.Engine.GECKO){h.addListener(q,this._onRemoveChild,this);}this.getChildControl(y).add(h);break;case y:h=new qx.ui.core.scroll.ScrollPane();h.addListener(n,this._onResize,this);h.addListener(m,this._onScroll,this);h.addListener(r,this._onScroll,this);break;}return h||qx.ui.core.Widget.prototype._createChildControlImpl.call(this,g);},_forwardStates:{barLeft:true,barTop:true,barRight:true,barBottom:true},scrollBy:function(A){var B=this.getChildControl(y);if(this.getOrientation()===z){B.scrollByX(A);}else{B.scrollByY(A);}},scrollTo:function(i){var j=this.getChildControl(y);if(this.getOrientation()===z){j.scrollToX(i);}else{j.scrollToY(i);}},_applyOrientation:function(a,b){var f=[this.getLayout(),this._getLayout()];var d=this.getChildControl(v);var c=this.getChildControl(w);if(b==x){d.removeState(x);c.removeState(x);d.addState(z);c.addState(z);}else if(b==z){d.removeState(z);c.removeState(z);d.addState(x);c.addState(x);}if(a==z){this._setLayout(new qx.ui.layout.HBox());this.setLayout(new qx.ui.layout.HBox());}else{this._setLayout(new qx.ui.layout.VBox());this.setLayout(new qx.ui.layout.VBox());}if(f[0]){f[0].dispose();}if(f[1]){f[1].dispose();}},_onMouseWheel:function(e){this.scrollBy(e.getWheelDelta()*this.getScrollStep());e.stop();},_onScroll:function(){this._updateArrowsEnabled();},_onResize:function(e){var content=this.getChildControl(y).getChildren()[0];if(!content){return;}var H=this.getInnerSize();var J=content.getBounds();var I=(this.getOrientation()===z)?J.width>H.width:J.height>H.height;if(I){this._showArrows();this._updateArrowsEnabled();}else{this._hideArrows();}},_onExecuteBackward:function(){this.scrollBy(-this.getScrollStep());},_onExecuteForward:function(){this.scrollBy(this.getScrollStep());},_onRemoveChild:function(){qx.event.Timer.once(function(){this.scrollBy(this.getChildControl(y).getScrollX());},this,50);},_updateArrowsEnabled:function(){var F=this.getChildControl(y);if(this.getOrientation()===z){var E=F.getScrollX();var G=F.getScrollMaxX();}else{var E=F.getScrollY();var G=F.getScrollMaxY();}this.getChildControl(w).setEnabled(E>0);this.getChildControl(v).setEnabled(E<G);},_showArrows:function(){this._showChildControl(v);this._showChildControl(w);},_hideArrows:function(){this._excludeChildControl(v);this._excludeChildControl(w);this.scrollTo(0);}}});})();(function(){var f="execute",e="button-backward",d="vertical",c="button-forward",b="menu-slidebar",a="qx.ui.menu.MenuSlideBar";qx.Class.define(a,{extend:qx.ui.container.SlideBar,construct:function(){qx.ui.container.SlideBar.call(this,d);},properties:{appearance:{refine:true,init:b}},members:{_createChildControlImpl:function(g){var h;switch(g){case c:h=new qx.ui.form.HoverButton();h.addListener(f,this._onExecuteForward,this);this._addAt(h,2);break;case e:h=new qx.ui.form.HoverButton();h.addListener(f,this._onExecuteBackward,this);this._addAt(h,0);break;}return h||qx.ui.container.SlideBar.prototype._createChildControlImpl.call(this,g);}}});})();(function(){var n="pressed",m="abandoned",l="Integer",k="hovered",j="qx.event.type.Event",i="Enter",h="Space",g="press",f="qx.ui.form.RepeatButton",d="release",a="__lE",c="interval",b="execute";qx.Class.define(f,{extend:qx.ui.form.Button,construct:function(o,p){qx.ui.form.Button.call(this,o,p);this.__lE=new qx.event.AcceleratingTimer();this.__lE.addListener(c,this._onInterval,this);},events:{"execute":j,"press":j,"release":j},properties:{interval:{check:l,init:100},firstInterval:{check:l,init:500},minTimer:{check:l,init:20},timerDecrease:{check:l,init:2}},members:{__lF:null,__lE:null,press:function(){if(this.isEnabled()){if(!this.hasState(n)){this.__lG();}this.removeState(m);this.addState(n);}},release:function(s){if(!this.isEnabled()){return;}if(this.hasState(n)){if(!this.__lF){this.execute();}}this.removeState(n);this.removeState(m);this.__lH();},_applyEnabled:function(q,r){qx.ui.form.Button.prototype._applyEnabled.call(this,q,r);if(!q){this.removeState(n);this.removeState(m);this.__lH();}},_onMouseOver:function(e){if(!this.isEnabled()||e.getTarget()!==this){return;}if(this.hasState(m)){this.removeState(m);this.addState(n);this.__lE.start();}this.addState(k);},_onMouseOut:function(e){if(!this.isEnabled()||e.getTarget()!==this){return;}this.removeState(k);if(this.hasState(n)){this.removeState(n);this.addState(m);this.__lE.stop();}},_onMouseDown:function(e){if(!e.isLeftPressed()){return;}this.capture();this.__lG();e.stopPropagation();},_onMouseUp:function(e){this.releaseCapture();if(!this.hasState(m)){this.addState(k);if(this.hasState(n)&&!this.__lF){this.execute();}}this.__lH();e.stopPropagation();},_onKeyUp:function(e){switch(e.getKeyIdentifier()){case i:case h:if(this.hasState(n)){if(!this.__lF){this.execute();}this.removeState(n);this.removeState(m);e.stopPropagation();this.__lH();}}},_onKeyDown:function(e){switch(e.getKeyIdentifier()){case i:case h:this.removeState(m);this.addState(n);e.stopPropagation();this.__lG();}},_onInterval:function(e){this.__lF=true;this.fireEvent(b);},__lG:function(){this.fireEvent(g);this.__lF=false;this.__lE.set({interval:this.getInterval(),firstInterval:this.getFirstInterval(),minimum:this.getMinTimer(),decrease:this.getTimerDecrease()}).start();this.removeState(m);this.addState(n);},__lH:function(){this.fireEvent(d);this.__lE.stop();this.removeState(m);this.removeState(n);}},destruct:function(){this._disposeObjects(a);}});})();(function(){var e="Integer",d="interval",c="qx.event.type.Event",b="qx.event.AcceleratingTimer",a="__lI";qx.Class.define(b,{extend:qx.core.Object,construct:function(){qx.core.Object.call(this);this.__lI=new qx.event.Timer(this.getInterval());this.__lI.addListener(d,this._onInterval,this);},events:{"interval":c},properties:{interval:{check:e,init:100},firstInterval:{check:e,init:500},minimum:{check:e,init:20},decrease:{check:e,init:2}},members:{__lI:null,__lJ:null,start:function(){this.__lI.setInterval(this.getFirstInterval());this.__lI.start();},stop:function(){this.__lI.stop();this.__lJ=null;},_onInterval:function(){this.__lI.stop();if(this.__lJ==null){this.__lJ=this.getInterval();}this.__lJ=Math.max(this.getMinimum(),this.__lJ-this.getDecrease());this.__lI.setInterval(this.__lJ);this.__lI.start();this.fireEvent(d);}},destruct:function(){this._disposeObjects(a);}});})();(function(){var B="resize",A="scrollY",z="update",w="scrollX",v="_applyScrollX",u="_applyScrollY",t="qx.lang.Type.isNumber(value)&&value>=0&&value<=this.getScrollMaxX()",s="appear",r="qx.lang.Type.isNumber(value)&&value>=0&&value<=this.getScrollMaxY()",q="qx.event.type.Event",o="qx.ui.core.scroll.ScrollPane",p="scroll";qx.Class.define(o,{extend:qx.ui.core.Widget,construct:function(){qx.ui.core.Widget.call(this);this.set({minWidth:0,minHeight:0});this._setLayout(new qx.ui.layout.Grow());this.addListener(B,this._onUpdate);var H=this.getContentElement();H.addListener(p,this._onScroll,this);H.addListener(s,this._onAppear,this);},events:{update:q},properties:{scrollX:{check:t,apply:v,event:w,init:0},scrollY:{check:r,apply:u,event:A,init:0}},members:{add:function(a){var b=this._getChildren()[0];if(b){this._remove(b);b.removeListener(B,this._onUpdate,this);}if(a){this._add(a);a.addListener(B,this._onUpdate,this);}},remove:function(I){if(I){this._remove(I);I.removeListener(B,this._onUpdate,this);}},getChildren:function(){return this._getChildren();},_onUpdate:function(e){this.fireEvent(z);},_onScroll:function(e){var C=this.getContentElement();this.setScrollX(C.getScrollX());this.setScrollY(C.getScrollY());},_onAppear:function(e){var m=this.getContentElement();var j=this.getScrollX();var k=m.getScrollX();if(j!=k){m.scrollToX(j);}var n=this.getScrollY();var l=m.getScrollY();if(n!=l){m.scrollToY(n);}},getItemTop:function(J){var top=0;do{top+=J.getBounds().top;J=J.getLayoutParent();}while(J&&J!==this);return top;},getItemBottom:function(N){return this.getItemTop(N)+N.getBounds().height;},getItemLeft:function(F){var G=0;var parent;do{G+=F.getBounds().left;parent=F.getLayoutParent();if(parent){G+=parent.getInsets().left;}F=parent;}while(F&&F!==this);return G;},getItemRight:function(K){return this.getItemLeft(K)+K.getBounds().width;},getScrollSize:function(){return this.getChildren()[0].getBounds();},getScrollMaxX:function(){var i=this.getInnerSize();var h=this.getScrollSize();if(i&&h){return Math.max(0,h.width-i.width);}return 0;},getScrollMaxY:function(){var M=this.getInnerSize();var L=this.getScrollSize();if(M&&L){return Math.max(0,L.height-M.height);}return 0;},scrollToX:function(c){var d=this.getScrollMaxX();if(c<0){c=0;}else if(c>d){c=d;}this.setScrollX(c);},scrollToY:function(D){var E=this.getScrollMaxY();if(D<0){D=0;}else if(D>E){D=E;}this.setScrollY(D);},scrollByX:function(x){this.scrollToX(this.getScrollX()+x);},scrollByY:function(y){this.scrollToY(this.getScrollY()+y);},_applyScrollX:function(f){this.getContentElement().scrollToX(f);},_applyScrollY:function(g){this.getContentElement().scrollToY(g);}}});})();(function(){var a="qx.ui.layout.Grow";qx.Class.define(a,{extend:qx.ui.layout.Abstract,members:{verifyLayoutProperty:null,renderLayout:function(b,c){var g=this._getLayoutChildren();var f,h,e,d;for(var i=0,l=g.length;i<l;i++){f=g[i];h=f.getSizeHint();e=b;if(e<h.minWidth){e=h.minWidth;}else if(e>h.maxWidth){e=h.maxWidth;}d=c;if(d<h.minHeight){d=h.minHeight;}else if(d>h.maxHeight){d=h.maxHeight;}f.renderLayout(0,0,e,d);}},_computeSizeHint:function(){var q=this._getLayoutChildren();var o,s;var r=0,p=0;var n=0,k=0;var j=Infinity,m=Infinity;for(var i=0,l=q.length;i<l;i++){o=q[i];s=o.getSizeHint();r=Math.max(r,s.width);p=Math.max(p,s.height);n=Math.max(n,s.minWidth);k=Math.max(k,s.minHeight);j=Math.min(j,s.maxWidth);m=Math.min(m,s.maxHeight);}return {width:r,height:p,minWidth:n,minHeight:k,maxWidth:j,maxHeight:m};}}});})();(function(){var i="Integer",h="hovered",g="hover-button",f="interval",d="mouseover",c="mouseout",b="__lK",a="qx.ui.form.HoverButton";qx.Class.define(a,{extend:qx.ui.basic.Atom,include:[qx.ui.core.MExecutable],implement:[qx.ui.form.IExecutable],construct:function(j,k){qx.ui.basic.Atom.call(this,j,k);this.addListener(d,this._onMouseOver,this);this.addListener(c,this._onMouseOut,this);this.__lK=new qx.event.AcceleratingTimer();this.__lK.addListener(f,this._onInterval,this);},properties:{appearance:{refine:true,init:g},interval:{check:i,init:80},firstInterval:{check:i,init:200},minTimer:{check:i,init:20},timerDecrease:{check:i,init:2}},members:{__lK:null,_onMouseOver:function(e){if(!this.isEnabled()||e.getTarget()!==this){return;}this.__lK.set({interval:this.getInterval(),firstInterval:this.getFirstInterval(),minimum:this.getMinTimer(),decrease:this.getTimerDecrease()}).start();this.addState(h);},_onMouseOut:function(e){this.__lK.stop();this.removeState(h);if(!this.isEnabled()||e.getTarget()!==this){return;}},_onInterval:function(){if(this.isEnabled()){this.execute();}else{this.__lK.stop();}}},destruct:function(){this._disposeObjects(b);}});})();(function(){var h="pressed",g="hovered",f="inherit",d="qx.ui.menubar.Button",c="keydown",b="menubar-button",a="keyup";qx.Class.define(d,{extend:qx.ui.form.MenuButton,construct:function(j,k,l){qx.ui.form.MenuButton.call(this,j,k,l);this.removeListener(c,this._onKeyDown);this.removeListener(a,this._onKeyUp);},properties:{appearance:{refine:true,init:b},show:{refine:true,init:f},focusable:{refine:true,init:false}},members:{getMenuBar:function(){var parent=this;while(parent){if(parent instanceof qx.ui.toolbar.ToolBar){return parent;}parent=parent.getLayoutParent();}return null;},open:function(n){qx.ui.form.MenuButton.prototype.open.call(this,n);var menubar=this.getMenuBar();menubar._setAllowMenuOpenHover(true);},_onMenuChange:function(e){var i=this.getMenu();var menubar=this.getMenuBar();if(i.isVisible()){this.addState(h);if(menubar){menubar.setOpenMenu(i);}}else{this.removeState(h);if(menubar&&menubar.getOpenMenu()==i){menubar.resetOpenMenu();menubar._setAllowMenuOpenHover(false);}}},_onMouseUp:function(e){qx.ui.form.MenuButton.prototype._onMouseUp.call(this,e);var m=this.getMenu();if(m&&m.isVisible()&&!this.hasState(h)){this.addState(h);}},_onMouseOver:function(e){this.addState(g);if(this.getMenu()){var menubar=this.getMenuBar();if(menubar._isAllowMenuOpenHover()){qx.ui.menu.Manager.getInstance().hideAll();menubar._setAllowMenuOpenHover(true);if(this.isEnabled()){this.open();}}}}}});})();(function(){var t="both",s="qx.ui.menu.Menu",r="_applySpacing",q="icon",p="label",o="changeShow",n="Integer",m="qx.ui.toolbar.ToolBar",k="toolbar",j="changeOpenMenu";qx.Class.define(m,{extend:qx.ui.core.Widget,include:qx.ui.core.MChildrenHandling,construct:function(){qx.ui.core.Widget.call(this);this._setLayout(new qx.ui.layout.HBox());},properties:{appearance:{refine:true,init:k},openMenu:{check:s,event:j,nullable:true},show:{init:t,check:[t,p,q],inheritable:true,event:o},spacing:{nullable:true,check:n,themeable:true,apply:r}},members:{__lL:false,_setAllowMenuOpenHover:function(a){this.__lL=a;},_isAllowMenuOpenHover:function(){return this.__lL;},_applySpacing:function(e,f){var g=this._getLayout();e==null?g.resetSpacing():g.setSpacing(e);},addSpacer:function(){var h=new qx.ui.core.Spacer;this._add(h,{flex:1});return h;},addSeparator:function(){this.add(new qx.ui.toolbar.Separator);},getMenuButtons:function(){var c=this.getChildren();var b=[];var d;for(var i=0,l=c.length;i<l;i++){d=c[i];if(d instanceof qx.ui.menubar.Button){b.push(d);}else if(d instanceof qx.ui.toolbar.Part){b.push.apply(b,d.getMenuButtons());}}return b;}}});})();(function(){var a="qx.ui.core.Spacer";qx.Class.define(a,{extend:qx.ui.core.LayoutItem,construct:function(c,d){qx.ui.core.LayoutItem.call(this);this.setWidth(c!=null?c:0);this.setHeight(d!=null?d:0);},members:{checkAppearanceNeeds:function(){},addChildrenToQueue:function(b){},destroy:function(){if(this.$$disposed){return;}var parent=this.$$parent;if(parent){parent._remove(this);}qx.ui.core.queue.Dispose.add(this);}}});})();(function(){var b="toolbar-separator",a="qx.ui.toolbar.Separator";qx.Class.define(a,{extend:qx.ui.core.Widget,properties:{appearance:{refine:true,init:b},anonymous:{refine:true,init:true},width:{refine:true,init:0},height:{refine:true,init:0}}});})();(function(){var o="container",n="handle",m="both",k="Integer",j="middle",h="qx.ui.toolbar.Part",g="icon",f="label",e="changeShow",d="_applySpacing",c="toolbar/part";qx.Class.define(h,{extend:qx.ui.core.Widget,include:[qx.ui.core.MRemoteChildrenHandling],construct:function(){qx.ui.core.Widget.call(this);this._setLayout(new qx.ui.layout.HBox);this._createChildControl(n);},properties:{appearance:{refine:true,init:c},show:{init:m,check:[m,f,g],inheritable:true,event:e},spacing:{nullable:true,check:k,themeable:true,apply:d}},members:{_createChildControlImpl:function(a){var b;switch(a){case n:b=new qx.ui.basic.Image();b.setAlignY(j);this._add(b);break;case o:b=new qx.ui.toolbar.PartContainer;this._add(b);break;}return b||qx.ui.core.Widget.prototype._createChildControlImpl.call(this,a);},getChildrenContainer:function(){return this.getChildControl(o);},_applySpacing:function(s,t){var u=this.getChildControl(o).getLayout();s==null?u.resetSpacing():u.setSpacing(s);},addSeparator:function(){this.add(new qx.ui.toolbar.Separator);},getMenuButtons:function(){var q=this.getChildren();var p=[];var r;for(var i=0,l=q.length;i<l;i++){r=q[i];if(r instanceof qx.ui.menubar.Button){p.push(r);}}return p;}}});})();(function(){var f="both",e="toolbar/part/container",d="icon",c="changeShow",b="qx.ui.toolbar.PartContainer",a="label";qx.Class.define(b,{extend:qx.ui.container.Composite,construct:function(){qx.ui.container.Composite.call(this);this._setLayout(new qx.ui.layout.HBox);},properties:{appearance:{refine:true,init:e},show:{init:f,check:[f,a,d],inheritable:true,event:c}}});})();(function(){var b="qx.ui.menu.Button",a="menu-button";qx.Class.define(b,{extend:qx.ui.menu.AbstractButton,construct:function(c,d,f,g){qx.ui.menu.AbstractButton.call(this);if(c!=null){this.setLabel(c);}if(d!=null){this.setIcon(d);}if(f!=null){this.setCommand(f);}if(g!=null){this.setMenu(g);}},properties:{appearance:{refine:true,init:a}},members:{_onMouseUp:function(e){if(e.isLeftPressed()){this.execute();if(this.getMenu()){return;}}qx.ui.menu.Manager.getInstance().hideAll();},_onKeyPress:function(e){this.execute();}}});})();(function(){var c="qx.ui.form.IBooleanForm",b="qx.event.type.Data";qx.Interface.define(c,{events:{"changeValue":b},members:{setValue:function(a){return arguments.length==1;},resetValue:function(){},getValue:function(){}}});})();(function(){var j="checked",i="menu-checkbox",h="Boolean",g="_applyValue",f="changeValue",d="qx.ui.menu.CheckBox",c="execute";qx.Class.define(d,{extend:qx.ui.menu.AbstractButton,implement:[qx.ui.form.IBooleanForm],construct:function(k,l){qx.ui.menu.AbstractButton.call(this);if(k!=null){if(k.translate){this.setLabel(k.translate());}else{this.setLabel(k);}}if(l!=null){this.setMenu(l);}this.addListener(c,this._onExecute,this);},properties:{appearance:{refine:true,init:i},value:{check:h,init:false,apply:g,event:f,nullable:true}},members:{_applyValue:function(a,b){a?this.addState(j):this.removeState(j);},_onExecute:function(e){this.toggleValue();},_onMouseUp:function(e){if(e.isLeftPressed()){this.execute();}qx.ui.menu.Manager.getInstance().hideAll();},_onKeyPress:function(e){this.execute();}}});})();(function(){var b="qx.ui.table.IColumnMenuItem",a="qx.event.type.Data";qx.Interface.define(b,{properties:{visible:{}},events:{changeVisible:a}});})();(function(){var h="changeVisible",g="qx.ui.table.columnmenu.MenuItem",f="_applyVisible",d="Boolean",c="changeValue";qx.Class.define(g,{extend:qx.ui.menu.CheckBox,implement:qx.ui.table.IColumnMenuItem,properties:{visible:{check:d,init:true,apply:f,event:h}},construct:function(i){qx.ui.menu.CheckBox.call(this,i);this.addListener(c,function(e){this.bInListener=true;this.setVisible(e.getData());this.bInListener=false;});},members:{__lM:false,_applyVisible:function(a,b){if(!this.bInListener){this.setValue(a);}}}});})();(function(){var h="qx.ui.table.selection.Model",g="qx.ui.table.selection.Manager";qx.Class.define(g,{extend:qx.core.Object,construct:function(){qx.core.Object.call(this);},properties:{selectionModel:{check:h}},members:{__lN:null,handleMouseDown:function(r,s){if(s.isLeftPressed()){var t=this.getSelectionModel();if(!t.isSelectedIndex(r)){this._handleSelectEvent(r,s);this.__lN=true;}else{this.__lN=false;}}else if(s.isRightPressed()&&s.getModifiers()==0){var t=this.getSelectionModel();if(!t.isSelectedIndex(r)){t.setSelectionInterval(r,r);}}},handleMouseUp:function(i,j){if(j.isLeftPressed()&&!this.__lN){this._handleSelectEvent(i,j);}},handleClick:function(p,q){},handleSelectKeyDown:function(e,f){this._handleSelectEvent(e,f);},handleMoveKeyDown:function(a,b){var d=this.getSelectionModel();switch(b.getModifiers()){case 0:d.setSelectionInterval(a,a);break;case qx.event.type.Dom.SHIFT_MASK:var c=d.getAnchorSelectionIndex();if(c==-1){d.setSelectionInterval(a,a);}else{d.setSelectionInterval(c,a);}break;}},_handleSelectEvent:function(k,l){var o=this.getSelectionModel();var m=o.getLeadSelectionIndex();var n=o.getAnchorSelectionIndex();if(l.isShiftPressed()){if(k!=m||o.isSelectionEmpty()){if(n==-1){n=k;}if(l.isCtrlOrCommandPressed()){o.addSelectionInterval(n,k);}else{o.setSelectionInterval(n,k);}}}else if(l.isCtrlOrCommandPressed()){if(o.isSelectedIndex(k)){o.removeSelectionInterval(k,k);}else{o.addSelectionInterval(k,k);}}else{o.setSelectionInterval(k,k);}}}});})();(function(){var b="qx.ui.table.IHeaderRenderer";qx.Interface.define(b,{members:{createHeaderCell:function(a){return true;},updateHeaderCell:function(c,d){return true;}}});})();(function(){var b="qx.ui.table.headerrenderer.Default",a="String";qx.Class.define(b,{extend:qx.core.Object,implement:qx.ui.table.IHeaderRenderer,statics:{STATE_SORTED:"sorted",STATE_SORTED_ASCENDING:"sortedAscending"},properties:{toolTip:{check:a,init:null,nullable:true}},members:{createHeaderCell:function(g){var h=new qx.ui.table.headerrenderer.HeaderCell();this.updateHeaderCell(g,h);return h;},updateHeaderCell:function(c,d){var e=qx.ui.table.headerrenderer.Default;if(c.name&&c.name.translate){d.setLabel(c.name.translate());}else{d.setLabel(c.name);}var f=d.getToolTip();if(this.getToolTip()!=null){if(f==null){f=new qx.ui.tooltip.ToolTip(this.getToolTip());d.setToolTip(f);qx.util.DisposeUtil.disposeTriggeredBy(f,d);}else{f.setLabel(this.getToolTip());}}c.sorted?d.addState(e.STATE_SORTED):d.removeState(e.STATE_SORTED);c.sortedAscending?d.addState(e.STATE_SORTED_ASCENDING):d.removeState(e.STATE_SORTED_ASCENDING);}}});})();(function(){var a="qx.ui.table.ICellRenderer";qx.Interface.define(a,{members:{createDataCellHtml:function(b,c){return true;}}});})();(function(){var o="",n="px;",m=".qooxdoo-table-cell {",l="qooxdoo-table-cell",k='" ',j="nowrap",i="default",h="qx.client",g="}",f="width:",M=".qooxdoo-table-cell-right { text-align:right } ",L="0px 6px",K='<div class="',J="0px",I="height:",H="1px solid ",G=".qooxdoo-table-cell-bold { font-weight:bold } ",F="table-row-line",E="String",D='>',v="mshtml",w='</div>',t="ellipsis",u="content-box",r='left:',s="qx.ui.table.cellrenderer.Abstract",p='" style="',q="abstract",x="none",y="hidden",A="} ",z='px;',C=".qooxdoo-table-cell-italic { font-style:italic} ",B="absolute";qx.Class.define(s,{type:q,implement:qx.ui.table.ICellRenderer,extend:qx.core.Object,construct:function(){qx.core.Object.call(this);var c=qx.ui.table.cellrenderer.Abstract;if(!c.__lO){var e=qx.theme.manager.Color.getInstance();c.__lO=this.self(arguments);var d=m+qx.bom.element.Style.compile({position:B,top:J,overflow:y,whiteSpace:j,borderRight:H+e.resolve(F),padding:L,cursor:i,textOverflow:t,userSelect:x})+A+M+C+G;if(!qx.core.Variant.isSet(h,v)){d+=m+qx.bom.element.BoxSizing.compile(u)+g;}c.__lO.stylesheet=qx.bom.Stylesheet.createElement(d);}},properties:{defaultCellStyle:{init:null,check:E,nullable:true}},members:{_insetX:6+6+1,_insetY:0,_getCellClass:function(P){return l;},_getCellStyle:function(N){return N.style||o;},_getCellAttributes:function(O){return o;},_getContentHtml:function(V){return V.value||o;},_getCellSizeStyle:function(Q,R,S,T){var U=o;if(qx.bom.client.Feature.CONTENT_BOX){Q-=S;R-=T;}U+=f+Math.max(Q,0)+n;U+=I+Math.max(R,0)+n;return U;},createDataCellHtml:function(a,b){b.push(K,this._getCellClass(a),p,r,a.styleLeft,z,this._getCellSizeStyle(a.styleWidth,a.styleHeight,this._insetX,this._insetY),this._getCellStyle(a),k,this._getCellAttributes(a),D+this._getContentHtml(a),w);}}});})();(function(){var k="",j="number",i="Boolean",h="qx.ui.table.cellrenderer.Default",g=" qooxdoo-table-cell-bold",f=" qooxdoo-table-cell-right",e=" qooxdoo-table-cell-italic",d="string";qx.Class.define(h,{extend:qx.ui.table.cellrenderer.Abstract,statics:{STYLEFLAG_ALIGN_RIGHT:1,STYLEFLAG_BOLD:2,STYLEFLAG_ITALIC:4,_numberFormat:null},properties:{useAutoAlign:{check:i,init:true}},members:{_getStyleFlags:function(p){if(this.getUseAutoAlign()){if(typeof p.value==j){return qx.ui.table.cellrenderer.Default.STYLEFLAG_ALIGN_RIGHT;}}return 0;},_getCellClass:function(m){var n=qx.ui.table.cellrenderer.Abstract.prototype._getCellClass.call(this,m);if(!n){return k;}var o=this._getStyleFlags(m);if(o&qx.ui.table.cellrenderer.Default.STYLEFLAG_ALIGN_RIGHT){n+=f;}if(o&qx.ui.table.cellrenderer.Default.STYLEFLAG_BOLD){n+=g;}if(o&qx.ui.table.cellrenderer.Default.STYLEFLAG_ITALIC){n+=e;}return n;},_getContentHtml:function(l){return qx.bom.String.escape(this._formatValue(l));},_formatValue:function(a){var c=a.value;var b;if(c==null){return k;}if(typeof c==d){return c;}else if(typeof c==j){if(!qx.ui.table.cellrenderer.Default._numberFormat){qx.ui.table.cellrenderer.Default._numberFormat=new qx.util.format.NumberFormat();qx.ui.table.cellrenderer.Default._numberFormat.setMaximumFractionDigits(2);}var b=qx.ui.table.cellrenderer.Default._numberFormat.format(c);}else if(c instanceof Date){b=qx.util.format.DateFormat.getDateInstance().format(c);}else{b=c;}return b;}}});})();(function(){var b="qx.ui.table.ICellEditorFactory";qx.Interface.define(b,{members:{createCellEditor:function(c){return true;},getCellEditorValue:function(a){return true;}}});})();(function(){var f="",e="Function",d="abstract",c="number",b="appear",a="qx.ui.table.celleditor.AbstractField";qx.Class.define(a,{extend:qx.core.Object,implement:qx.ui.table.ICellEditorFactory,type:d,properties:{validationFunction:{check:e,nullable:true,init:null}},members:{_createEditor:function(){throw new Error("Abstract method call!");},createCellEditor:function(j){var k=this._createEditor();k.originalValue=j.value;if(j.value===null||j.value===undefined){j.value=f;}k.setValue(f+j.value);k.addListener(b,function(){k.selectAllText();});return k;},getCellEditorValue:function(g){var i=g.getValue();var h=this.getValidationFunction();if(h){i=h(i,g.originalValue);}if(typeof g.originalValue==c){i=parseFloat(i);}return i;}}});})();(function(){var f="number",e="qx.ui.table.celleditor.TextField",d="table-editor-textfield";qx.Class.define(e,{extend:qx.ui.table.celleditor.AbstractField,members:{getCellEditorValue:function(a){var c=a.getValue();var b=this.getValidationFunction();if(b){c=b(c,a.originalValue);}if(typeof a.originalValue==f){if(c!=null){c=parseFloat(c);}}return c;},_createEditor:function(){var g=new qx.ui.form.TextField();g.setAppearance(d);return g;}}});})();(function(){var l="qx.event.type.Data",k="visibilityChanged",j="orderChanged",h="visibilityChangedPre",g="__lU",f="widthChanged",e="qx.ui.table.columnmodel.Basic",d="__lW",c="__lV",b="headerCellRendererChanged";qx.Class.define(e,{extend:qx.core.Object,construct:function(){qx.core.Object.call(this);this.__lP=[];this.__lQ=[];},events:{"widthChanged":l,"visibilityChangedPre":l,"visibilityChanged":l,"orderChanged":l,"headerCellRendererChanged":l},statics:{DEFAULT_WIDTH:100,DEFAULT_HEADER_RENDERER:qx.ui.table.headerrenderer.Default,DEFAULT_DATA_RENDERER:qx.ui.table.cellrenderer.Default,DEFAULT_EDITOR_FACTORY:qx.ui.table.celleditor.TextField},members:{__lR:null,__lS:null,__lQ:null,__lP:null,__lT:null,__lU:null,__lV:null,__lW:null,init:function(r){{};this.__lT=[];var u=qx.ui.table.columnmodel.Basic.DEFAULT_WIDTH;var v=this.__lU||(this.__lU=new qx.ui.table.columnmodel.Basic.DEFAULT_HEADER_RENDERER());var t=this.__lV||(this.__lV=new qx.ui.table.columnmodel.Basic.DEFAULT_DATA_RENDERER());var s=this.__lW||(this.__lW=new qx.ui.table.columnmodel.Basic.DEFAULT_EDITOR_FACTORY());this.__lP=[];this.__lQ=[];for(var y=0;y<r;y++){this.__lT[y]={width:u,headerRenderer:v,dataRenderer:t,editorFactory:s};this.__lP[y]=y;this.__lQ[y]=y;}this.__lS=null;for(var y=0;y<r;y++){var w={col:y,visible:true};this.fireDataEvent(h,w);this.fireDataEvent(k,w);}},getVisibleColumns:function(){return this.__lQ!=null?this.__lQ:[];},setColumnWidth:function(n,o){{};var q=this.__lT[n].width;if(q!=o){this.__lT[n].width=o;var p={col:n,newWidth:o,oldWidth:q};this.fireDataEvent(f,p);}},getColumnWidth:function(G){{};return this.__lT[G].width;},setHeaderCellRenderer:function(V,W){{};var X=this.__lT[V].headerRenderer;if(X!==this.__lU){X.dispose();}this.__lT[V].headerRenderer=W;this.fireDataEvent(b,{col:V});},getHeaderCellRenderer:function(R){{};return this.__lT[R].headerRenderer;},setDataCellRenderer:function(bd,be){{};this.__lT[bd].dataRenderer=be;var bf=this.__lT[bd].dataRenderer;if(bf!==this.__lV){return bf;}return null;},getDataCellRenderer:function(H){{};return this.__lT[H].dataRenderer;},setCellEditorFactory:function(D,E){{};var F=this.__lT[D].headerRenderer;if(F!==this.__lW){F.dispose();}this.__lT[D].editorFactory=E;},getCellEditorFactory:function(m){{};return this.__lT[m].editorFactory;},_getColToXPosMap:function(){if(this.__lS==null){this.__lS={};for(var B=0;B<this.__lP.length;B++){var A=this.__lP[B];this.__lS[A]={overX:B};}for(var z=0;z<this.__lQ.length;z++){var A=this.__lQ[z];this.__lS[A].visX=z;}}return this.__lS;},getVisibleColumnCount:function(){return this.__lQ!=null?this.__lQ.length:0;},getVisibleColumnAtX:function(T){{};return this.__lQ[T];},getVisibleX:function(C){{};return this._getColToXPosMap()[C].visX;},getOverallColumnCount:function(){return this.__lP.length;},getOverallColumnAtX:function(S){{};return this.__lP[S];},getOverallX:function(U){{};return this._getColToXPosMap()[U].overX;},isColumnVisible:function(a){{};return (this._getColToXPosMap()[a].visX!=null);},setColumnVisible:function(I,J){{};if(J!=this.isColumnVisible(I)){if(J){var P=this._getColToXPosMap();var M=P[I].overX;if(M==null){throw new Error("Showing column failed: "+I+". The column is not added to this TablePaneModel.");}var N;for(var x=M+1;x<this.__lP.length;x++){var O=this.__lP[x];var K=P[O].visX;if(K!=null){N=K;break;}}if(N==null){N=this.__lQ.length;}this.__lQ.splice(N,0,I);}else{var L=this.getVisibleX(I);this.__lQ.splice(L,1);}this.__lS=null;if(!this.__lR){var Q={col:I,visible:J};this.fireDataEvent(h,Q);this.fireDataEvent(k,Q);}}},moveColumn:function(bg,bh){{};this.__lR=true;var bk=this.__lP[bg];var bi=this.isColumnVisible(bk);if(bi){this.setColumnVisible(bk,false);}this.__lP.splice(bg,1);this.__lP.splice(bh,0,bk);this.__lS=null;if(bi){this.setColumnVisible(bk,true);}this.__lR=false;var bj={col:bk,fromOverXPos:bg,toOverXPos:bh};this.fireDataEvent(j,bj);},setColumnsOrder:function(Y){{};if(Y.length==this.__lP.length){this.__lR=true;var bc=new Array(Y.length);for(var ba=0;ba<this.__lP.length;ba++){var bb=this.isColumnVisible(ba);bc[ba]=bb;if(bb){this.setColumnVisible(ba,false);}}this.__lP=qx.lang.Array.clone(Y);this.__lS=null;for(var ba=0;ba<this.__lP.length;ba++){if(bc[ba]){this.setColumnVisible(ba,true);}}this.__lR=false;this.fireDataEvent(j);}else{throw new Error("setColumnsOrder: Invalid number of column positions given, expected "+this.__lP.length+", got "+Y.length);}}},destruct:function(){for(var i=0;i<this.__lT.length;i++){this.__lT[i].headerRenderer.dispose();this.__lT[i].dataRenderer.dispose();this.__lT[i].editorFactory.dispose();}this.__lP=this.__lQ=this.__lT=this.__lS=null;this._disposeObjects(g,c,d);}});})();(function(){var n="icon",m="label",l="String",k="sort-icon",j="_applySortIcon",i="_applyIcon",h="table-header-cell",g="qx.ui.table.headerrenderer.HeaderCell",f="_applyLabel";qx.Class.define(g,{extend:qx.ui.container.Composite,construct:function(){qx.ui.container.Composite.call(this);var c=new qx.ui.layout.Grid();c.setRowFlex(0,1);c.setColumnFlex(1,1);c.setColumnFlex(2,1);this.setLayout(c);},properties:{appearance:{refine:true,init:h},label:{check:l,init:null,nullable:true,apply:f},sortIcon:{check:l,init:null,nullable:true,apply:j,themeable:true},icon:{check:l,init:null,nullable:true,apply:i}},members:{_applyLabel:function(o,p){if(o){this._showChildControl(m).setValue(o);}else{this._excludeChildControl(m);}},_applySortIcon:function(q,r){if(q){this._showChildControl(k).setSource(q);}else{this._excludeChildControl(k);}},_applyIcon:function(a,b){if(a){this._showChildControl(n).setSource(a);}else{this._excludeChildControl(n);}},_createChildControlImpl:function(d){var e;switch(d){case m:e=new qx.ui.basic.Label(this.getLabel()).set({anonymous:true,allowShrinkX:true});this._add(e,{row:0,column:1});break;case k:e=new qx.ui.basic.Image(this.getSortIcon());e.setAnonymous(true);this._add(e,{row:0,column:2});break;case n:e=new qx.ui.basic.Image(this.getIcon()).set({anonymous:true,allowShrinkX:true});this._add(e,{row:0,column:0});break;}return e||qx.ui.container.Composite.prototype._createChildControlImpl.call(this,d);}}});})();(function(){var dl="left",dk="top",dj="_applyLayoutChange",di="hAlign",dh="flex",dg="vAlign",df="Integer",de="minWidth",dd="width",dc="minHeight",cY="qx.ui.layout.Grid",db="height",da="maxHeight",cX="maxWidth";qx.Class.define(cY,{extend:qx.ui.layout.Abstract,construct:function(dt,du){qx.ui.layout.Abstract.call(this);this.__lX=[];this.__lY=[];if(dt){this.setSpacingX(dt);}if(du){this.setSpacingY(du);}},properties:{spacingX:{check:df,init:0,apply:dj},spacingY:{check:df,init:0,apply:dj}},members:{__ma:null,__lX:null,__lY:null,__mb:null,__mc:null,__md:null,__me:null,__mf:null,__mg:null,verifyLayoutProperty:null,__mh:function(){var bq=[];var bp=[];var br=[];var bn=-1;var bm=-1;var bt=this._getLayoutChildren();for(var i=0,l=bt.length;i<l;i++){var bo=bt[i];var bs=bo.getLayoutProperties();var bu=bs.row;var bl=bs.column;bs.colSpan=bs.colSpan||1;bs.rowSpan=bs.rowSpan||1;if(bu==null||bl==null){throw new Error("The layout properties 'row' and 'column' of the child widget '"+bo+"' must be defined!");}if(bq[bu]&&bq[bu][bl]){throw new Error("Cannot add widget '"+bo+"'!. "+"There is already a widget '"+bq[bu][bl]+"' in this cell ("+bu+", "+bl+")");}for(var x=bl;x<bl+bs.colSpan;x++){for(var y=bu;y<bu+bs.rowSpan;y++){if(bq[y]==undefined){bq[y]=[];}bq[y][x]=bo;bm=Math.max(bm,x);bn=Math.max(bn,y);}}if(bs.rowSpan>1){br.push(bo);}if(bs.colSpan>1){bp.push(bo);}}for(var y=0;y<=bn;y++){if(bq[y]==undefined){bq[y]=[];}}this.__ma=bq;this.__mb=bp;this.__mc=br;this.__md=bn;this.__me=bm;this.__mf=null;this.__mg=null;delete this._invalidChildrenCache;},_setRowData:function(bQ,bR,bS){var bT=this.__lX[bQ];if(!bT){this.__lX[bQ]={};this.__lX[bQ][bR]=bS;}else{bT[bR]=bS;}},_setColumnData:function(bB,bC,bD){var bE=this.__lY[bB];if(!bE){this.__lY[bB]={};this.__lY[bB][bC]=bD;}else{bE[bC]=bD;}},setSpacing:function(dp){this.setSpacingY(dp);this.setSpacingX(dp);return this;},setColumnAlign:function(dv,dw,dx){{};this._setColumnData(dv,di,dw);this._setColumnData(dv,dg,dx);this._applyLayoutChange();return this;},getColumnAlign:function(bO){var bP=this.__lY[bO]||{};return {vAlign:bP.vAlign||dk,hAlign:bP.hAlign||dl};},setRowAlign:function(c,d,e){{};this._setRowData(c,di,d);this._setRowData(c,dg,e);this._applyLayoutChange();return this;},getRowAlign:function(P){var Q=this.__lX[P]||{};return {vAlign:Q.vAlign||dk,hAlign:Q.hAlign||dl};},getCellWidget:function(bd,be){if(this._invalidChildrenCache){this.__mh();}var bd=this.__ma[bd]||{};return bd[be]||null;},getRowCount:function(){if(this._invalidChildrenCache){this.__mh();}return this.__md+1;},getColumnCount:function(){if(this._invalidChildrenCache){this.__mh();}return this.__me+1;},getCellAlign:function(cC,cD){var cJ=dk;var cH=dl;var cI=this.__lX[cC];var cF=this.__lY[cD];var cE=this.__ma[cC][cD];if(cE){var cG={vAlign:cE.getAlignY(),hAlign:cE.getAlignX()};}else{cG={};}if(cG.vAlign){cJ=cG.vAlign;}else if(cI&&cI.vAlign){cJ=cI.vAlign;}else if(cF&&cF.vAlign){cJ=cF.vAlign;}if(cG.hAlign){cH=cG.hAlign;}else if(cF&&cF.hAlign){cH=cF.hAlign;}else if(cI&&cI.hAlign){cH=cI.hAlign;}return {vAlign:cJ,hAlign:cH};},setColumnFlex:function(bj,bk){this._setColumnData(bj,dh,bk);this._applyLayoutChange();return this;},getColumnFlex:function(q){var r=this.__lY[q]||{};return r.flex!==undefined?r.flex:0;},setRowFlex:function(bU,bV){this._setRowData(bU,dh,bV);this._applyLayoutChange();return this;},getRowFlex:function(dq){var dr=this.__lX[dq]||{};var ds=dr.flex!==undefined?dr.flex:0;return ds;},setColumnMaxWidth:function(ec,ed){this._setColumnData(ec,cX,ed);this._applyLayoutChange();return this;},getColumnMaxWidth:function(bh){var bi=this.__lY[bh]||{};return bi.maxWidth!==undefined?bi.maxWidth:Infinity;},setColumnWidth:function(bx,by){this._setColumnData(bx,dd,by);this._applyLayoutChange();return this;},getColumnWidth:function(bv){var bw=this.__lY[bv]||{};return bw.width!==undefined?bw.width:null;},setColumnMinWidth:function(bF,bG){this._setColumnData(bF,de,bG);this._applyLayoutChange();return this;},getColumnMinWidth:function(a){var b=this.__lY[a]||{};return b.minWidth||0;},setRowMaxHeight:function(bf,bg){this._setRowData(bf,da,bg);this._applyLayoutChange();return this;},getRowMaxHeight:function(cK){var cL=this.__lX[cK]||{};return cL.maxHeight||Infinity;},setRowHeight:function(I,J){this._setRowData(I,db,J);this._applyLayoutChange();return this;},getRowHeight:function(ea){var eb=this.__lX[ea]||{};return eb.height!==undefined?eb.height:null;},setRowMinHeight:function(bz,bA){this._setRowData(bz,dc,bA);this._applyLayoutChange();return this;},getRowMinHeight:function(dm){var dn=this.__lX[dm]||{};return dn.minHeight||0;},__mi:function(K){var O=K.getSizeHint();var N=K.getMarginLeft()+K.getMarginRight();var M=K.getMarginTop()+K.getMarginBottom();var L={height:O.height+M,width:O.width+N,minHeight:O.minHeight+M,minWidth:O.minWidth+N,maxHeight:O.maxHeight+M,maxWidth:O.maxWidth+N};return L;},_fixHeightsRowSpan:function(dJ){var dW=this.getSpacingY();for(var i=0,l=this.__mc.length;i<l;i++){var dM=this.__mc[i];var dO=this.__mi(dM);var dP=dM.getLayoutProperties();var dL=dP.row;var dU=dW*(dP.rowSpan-1);var dK=dU;var dR={};for(var j=0;j<dP.rowSpan;j++){var dY=dP.row+j;var dN=dJ[dY];var dX=this.getRowFlex(dY);if(dX>0){dR[dY]={min:dN.minHeight,value:dN.height,max:dN.maxHeight,flex:dX};}dU+=dN.height;dK+=dN.minHeight;}if(dU<dO.height){if(!qx.lang.Object.isEmpty(dR)){var dV=qx.ui.layout.Util.computeFlexOffsets(dR,dO.height,dU);for(var k=0;k<dP.rowSpan;k++){var dQ=dV[dL+k]?dV[dL+k].offset:0;dJ[dL+k].height+=dQ;}}else{var dS=dW*(dP.rowSpan-1);var dT=dO.height-dS;var dN=Math.floor(dT/dP.rowSpan);for(var k=0;k<dP.rowSpan;k++){dJ[dL+k].height=dN;}}}if(dK<dO.minHeight){var dV=qx.ui.layout.Util.computeFlexOffsets(dR,dO.minHeight,dK);for(var j=0;j<dP.rowSpan;j++){var dQ=dV[dL+j]?dV[dL+j].offset:0;dJ[dL+j].minHeight+=dQ;}}}},_fixWidthsColSpan:function(s){var w=this.getSpacingX();for(var i=0,l=this.__mb.length;i<l;i++){var t=this.__mb[i];var v=this.__mi(t);var A=t.getLayoutProperties();var u=A.column;var G=w*(A.colSpan-1);var z=G;var B={};var D;for(var j=0;j<A.colSpan;j++){var H=A.column+j;var F=s[H];var E=this.getColumnFlex(H);if(E>0){B[H]={min:F.minWidth,value:F.width,max:F.maxWidth,flex:E};}G+=F.width;z+=F.minWidth;}if(G<v.width){var C=qx.ui.layout.Util.computeFlexOffsets(B,v.width,G);for(var j=0;j<A.colSpan;j++){D=C[u+j]?C[u+j].offset:0;s[u+j].width+=D;}}if(z<v.minWidth){var C=qx.ui.layout.Util.computeFlexOffsets(B,v.minWidth,z);for(var j=0;j<A.colSpan;j++){D=C[u+j]?C[u+j].offset:0;s[u+j].minWidth+=D;}}}},_getRowHeights:function(){if(this.__mf!=null){return this.__mf;}var bb=[];var T=this.__md;var S=this.__me;for(var bc=0;bc<=T;bc++){var U=0;var W=0;var V=0;for(var ba=0;ba<=S;ba++){var R=this.__ma[bc][ba];if(!R){continue;}var X=R.getLayoutProperties().rowSpan||0;if(X>1){continue;}var Y=this.__mi(R);if(this.getRowFlex(bc)>0){U=Math.max(U,Y.minHeight);}else{U=Math.max(U,Y.height);}W=Math.max(W,Y.height);}var U=Math.max(U,this.getRowMinHeight(bc));var V=this.getRowMaxHeight(bc);if(this.getRowHeight(bc)!==null){var W=this.getRowHeight(bc);}else{var W=Math.max(U,Math.min(W,V));}bb[bc]={minHeight:U,height:W,maxHeight:V};}if(this.__mc.length>0){this._fixHeightsRowSpan(bb);}this.__mf=bb;return bb;},_getColWidths:function(){if(this.__mg!=null){return this.__mg;}var dC=[];var dz=this.__me;var dB=this.__md;for(var dH=0;dH<=dz;dH++){var dF=0;var dE=0;var dA=Infinity;for(var dI=0;dI<=dB;dI++){var dy=this.__ma[dI][dH];if(!dy){continue;}var dD=dy.getLayoutProperties().colSpan||0;if(dD>1){continue;}var dG=this.__mi(dy);if(this.getColumnFlex(dH)>0){dE=Math.max(dE,dG.minWidth);}else{dE=Math.max(dE,dG.width);}dF=Math.max(dF,dG.width);}var dE=Math.max(dE,this.getColumnMinWidth(dH));var dA=this.getColumnMaxWidth(dH);if(this.getColumnWidth(dH)!==null){var dF=this.getColumnWidth(dH);}else{var dF=Math.max(dE,Math.min(dF,dA));}dC[dH]={minWidth:dE,width:dF,maxWidth:dA};}if(this.__mb.length>0){this._fixWidthsColSpan(dC);}this.__mg=dC;return dC;},_getColumnFlexOffsets:function(bH){var bI=this.getSizeHint();var bM=bH-bI.width;if(bM==0){return {};}var bK=this._getColWidths();var bJ={};for(var i=0,l=bK.length;i<l;i++){var bN=bK[i];var bL=this.getColumnFlex(i);if((bL<=0)||(bN.width==bN.maxWidth&&bM>0)||(bN.width==bN.minWidth&&bM<0)){continue;}bJ[i]={min:bN.minWidth,value:bN.width,max:bN.maxWidth,flex:bL};}return qx.ui.layout.Util.computeFlexOffsets(bJ,bH,bI.width);},_getRowFlexOffsets:function(f){var g=this.getSizeHint();var n=f-g.height;if(n==0){return {};}var o=this._getRowHeights();var h={};for(var i=0,l=o.length;i<l;i++){var p=o[i];var m=this.getRowFlex(i);if((m<=0)||(p.height==p.maxHeight&&n>0)||(p.height==p.minHeight&&n<0)){continue;}h[i]={min:p.minHeight,value:p.height,max:p.maxHeight,flex:m};}return qx.ui.layout.Util.computeFlexOffsets(h,f,g.height);},renderLayout:function(bW,bX){if(this._invalidChildrenCache){this.__mh();}var cm=qx.ui.layout.Util;var ca=this.getSpacingX();var cg=this.getSpacingY();var cr=this._getColWidths();var cq=this._getColumnFlexOffsets(bW);var cb=[];var ct=this.__me;var bY=this.__md;var cs;for(var cu=0;cu<=ct;cu++){cs=cq[cu]?cq[cu].offset:0;cb[cu]=cr[cu].width+cs;}var cj=this._getRowHeights();var cl=this._getRowFlexOffsets(bX);var cA=[];for(var ch=0;ch<=bY;ch++){cs=cl[ch]?cl[ch].offset:0;cA[ch]=cj[ch].height+cs;}var cB=0;for(var cu=0;cu<=ct;cu++){var top=0;for(var ch=0;ch<=bY;ch++){var co=this.__ma[ch][cu];if(!co){top+=cA[ch]+cg;continue;}var cc=co.getLayoutProperties();if(cc.row!==ch||cc.column!==cu){top+=cA[ch]+cg;continue;}var cz=ca*(cc.colSpan-1);for(var i=0;i<cc.colSpan;i++){cz+=cb[cu+i];}var cp=cg*(cc.rowSpan-1);for(var i=0;i<cc.rowSpan;i++){cp+=cA[ch+i];}var cd=co.getSizeHint();var cx=co.getMarginTop();var cn=co.getMarginLeft();var ck=co.getMarginBottom();var cf=co.getMarginRight();var ci=Math.max(cd.minWidth,Math.min(cz-cn-cf,cd.maxWidth));var cy=Math.max(cd.minHeight,Math.min(cp-cx-ck,cd.maxHeight));var cv=this.getCellAlign(ch,cu);var cw=cB+cm.computeHorizontalAlignOffset(cv.hAlign,ci,cz,cn,cf);var ce=top+cm.computeVerticalAlignOffset(cv.vAlign,cy,cp,cx,ck);co.renderLayout(cw,ce,ci,cy);top+=cA[ch]+cg;}cB+=cb[cu]+ca;}},invalidateLayoutCache:function(){qx.ui.layout.Abstract.prototype.invalidateLayoutCache.call(this);this.__mg=null;this.__mf=null;},_computeSizeHint:function(){if(this._invalidChildrenCache){this.__mh();}var cQ=this._getColWidths();var cS=0,cT=0;for(var i=0,l=cQ.length;i<l;i++){var cU=cQ[i];if(this.getColumnFlex(i)>0){cS+=cU.minWidth;}else{cS+=cU.width;}cT+=cU.width;}var cV=this._getRowHeights();var cO=0,cR=0;for(var i=0,l=cV.length;i<l;i++){var cW=cV[i];if(this.getRowFlex(i)>0){cO+=cW.minHeight;}else{cO+=cW.height;}cR+=cW.height;}var cN=this.getSpacingX()*(cQ.length-1);var cM=this.getSpacingY()*(cV.length-1);var cP={minWidth:cS+cN,width:cT+cN,minHeight:cO+cM,height:cR+cM};return cP;}},destruct:function(){this.__ma=this.__lX=this.__lY=this.__mb=this.__mc=this.__mg=this.__mf=null;}});})();(function(){var e="qx.ui.popup.Popup",d="visible",c="excluded",b="popup",a="Boolean";qx.Class.define(e,{extend:qx.ui.container.Composite,include:qx.ui.core.MPlacement,construct:function(i){qx.ui.container.Composite.call(this,i);qx.core.Init.getApplication().getRoot().add(this);this.initVisibility();},properties:{appearance:{refine:true,init:b},visibility:{refine:true,init:c},autoHide:{check:a,init:true}},members:{_applyVisibility:function(f,g){qx.ui.container.Composite.prototype._applyVisibility.call(this,f,g);var h=qx.ui.popup.Manager.getInstance();f===d?h.add(this):h.remove(this);}},destruct:function(){qx.ui.popup.Manager.getInstance().remove(this);}});})();(function(){var n="atom",m="Integer",l="String",k="_applyRich",j="qx.ui.tooltip.ToolTip",i="_applyIcon",h="tooltip",g="qx.ui.core.Widget",f="mouseover",d="Boolean",c="_applyLabel";qx.Class.define(j,{extend:qx.ui.popup.Popup,construct:function(o,p){qx.ui.popup.Popup.call(this);this.setLayout(new qx.ui.layout.Grow);this._createChildControl(n);if(o!=null){this.setLabel(o);}if(p!=null){this.setIcon(p);}this.addListener(f,this._onMouseOver,this);},properties:{appearance:{refine:true,init:h},showTimeout:{check:m,init:700,themeable:true},hideTimeout:{check:m,init:4000,themeable:true},label:{check:l,nullable:true,apply:c},icon:{check:l,nullable:true,apply:i,themeable:true},rich:{check:d,init:false,apply:k},opener:{check:g,nullable:true}},members:{_createChildControlImpl:function(a){var b;switch(a){case n:b=new qx.ui.basic.Atom;this._add(b);break;}return b||qx.ui.popup.Popup.prototype._createChildControlImpl.call(this,a);},_onMouseOver:function(e){this.hide();},_applyIcon:function(w,x){var y=this.getChildControl(n);w==null?y.resetIcon():y.setIcon(w);},_applyLabel:function(q,r){var s=this.getChildControl(n);q==null?s.resetLabel():s.setLabel(q);},_applyRich:function(t,u){var v=this.getChildControl(n);v.setRich(t);}}});})();(function(){var k="mousedown",j="blur",h="__mj",g="singleton",f="qx.ui.popup.Manager";qx.Class.define(f,{type:g,extend:qx.core.Object,construct:function(){qx.core.Object.call(this);this.__mj=[];qx.event.Registration.addListener(document.documentElement,k,this.__ml,this,true);qx.bom.Element.addListener(window,j,this.hideAll,this);},members:{__mj:null,add:function(m){{};this.__mj.push(m);this.__mk();},remove:function(l){{};if(this.__mj){qx.lang.Array.remove(this.__mj,l);this.__mk();}},hideAll:function(){if(this.__mj){for(var i=0;i<this.__mj.length;i++){this.__mj[i].exclude();}}},__mk:function(){var a=1e7;for(var i=0;i<this.__mj.length;i++){this.__mj[i].setZIndex(a++);}},__ml:function(e){var c=qx.ui.core.Widget.getWidgetByElement(e.getTarget());var d=this.__mj;for(var i=0;i<d.length;i++){var b=d[i];if(!b.getAutoHide()||c==b||qx.ui.core.Widget.contains(b,c)){continue;}b.exclude();}}},destruct:function(){qx.event.Registration.removeListener(document.documentElement,k,this.__ml,this,true);this._disposeArray(h);}});})();(function(){var i="",h="<br",g=" &nbsp;",f="<br>",e=" ",d="\n",c="qx.bom.String";qx.Class.define(c,{statics:{TO_CHARCODE:{"quot":34,"amp":38,"lt":60,"gt":62,"nbsp":160,"iexcl":161,"cent":162,"pound":163,"curren":164,"yen":165,"brvbar":166,"sect":167,"uml":168,"copy":169,"ordf":170,"laquo":171,"not":172,"shy":173,"reg":174,"macr":175,"deg":176,"plusmn":177,"sup2":178,"sup3":179,"acute":180,"micro":181,"para":182,"middot":183,"cedil":184,"sup1":185,"ordm":186,"raquo":187,"frac14":188,"frac12":189,"frac34":190,"iquest":191,"Agrave":192,"Aacute":193,"Acirc":194,"Atilde":195,"Auml":196,"Aring":197,"AElig":198,"Ccedil":199,"Egrave":200,"Eacute":201,"Ecirc":202,"Euml":203,"Igrave":204,"Iacute":205,"Icirc":206,"Iuml":207,"ETH":208,"Ntilde":209,"Ograve":210,"Oacute":211,"Ocirc":212,"Otilde":213,"Ouml":214,"times":215,"Oslash":216,"Ugrave":217,"Uacute":218,"Ucirc":219,"Uuml":220,"Yacute":221,"THORN":222,"szlig":223,"agrave":224,"aacute":225,"acirc":226,"atilde":227,"auml":228,"aring":229,"aelig":230,"ccedil":231,"egrave":232,"eacute":233,"ecirc":234,"euml":235,"igrave":236,"iacute":237,"icirc":238,"iuml":239,"eth":240,"ntilde":241,"ograve":242,"oacute":243,"ocirc":244,"otilde":245,"ouml":246,"divide":247,"oslash":248,"ugrave":249,"uacute":250,"ucirc":251,"uuml":252,"yacute":253,"thorn":254,"yuml":255,"fnof":402,"Alpha":913,"Beta":914,"Gamma":915,"Delta":916,"Epsilon":917,"Zeta":918,"Eta":919,"Theta":920,"Iota":921,"Kappa":922,"Lambda":923,"Mu":924,"Nu":925,"Xi":926,"Omicron":927,"Pi":928,"Rho":929,"Sigma":931,"Tau":932,"Upsilon":933,"Phi":934,"Chi":935,"Psi":936,"Omega":937,"alpha":945,"beta":946,"gamma":947,"delta":948,"epsilon":949,"zeta":950,"eta":951,"theta":952,"iota":953,"kappa":954,"lambda":955,"mu":956,"nu":957,"xi":958,"omicron":959,"pi":960,"rho":961,"sigmaf":962,"sigma":963,"tau":964,"upsilon":965,"phi":966,"chi":967,"psi":968,"omega":969,"thetasym":977,"upsih":978,"piv":982,"bull":8226,"hellip":8230,"prime":8242,"Prime":8243,"oline":8254,"frasl":8260,"weierp":8472,"image":8465,"real":8476,"trade":8482,"alefsym":8501,"larr":8592,"uarr":8593,"rarr":8594,"darr":8595,"harr":8596,"crarr":8629,"lArr":8656,"uArr":8657,"rArr":8658,"dArr":8659,"hArr":8660,"forall":8704,"part":8706,"exist":8707,"empty":8709,"nabla":8711,"isin":8712,"notin":8713,"ni":8715,"prod":8719,"sum":8721,"minus":8722,"lowast":8727,"radic":8730,"prop":8733,"infin":8734,"ang":8736,"and":8743,"or":8744,"cap":8745,"cup":8746,"int":8747,"there4":8756,"sim":8764,"cong":8773,"asymp":8776,"ne":8800,"equiv":8801,"le":8804,"ge":8805,"sub":8834,"sup":8835,"sube":8838,"supe":8839,"oplus":8853,"otimes":8855,"perp":8869,"sdot":8901,"lceil":8968,"rceil":8969,"lfloor":8970,"rfloor":8971,"lang":9001,"rang":9002,"loz":9674,"spades":9824,"clubs":9827,"hearts":9829,"diams":9830,"OElig":338,"oelig":339,"Scaron":352,"scaron":353,"Yuml":376,"circ":710,"tilde":732,"ensp":8194,"emsp":8195,"thinsp":8201,"zwnj":8204,"zwj":8205,"lrm":8206,"rlm":8207,"ndash":8211,"mdash":8212,"lsquo":8216,"rsquo":8217,"sbquo":8218,"ldquo":8220,"rdquo":8221,"bdquo":8222,"dagger":8224,"Dagger":8225,"permil":8240,"lsaquo":8249,"rsaquo":8250,"euro":8364},escape:function(o){return qx.util.StringEscape.escape(o,qx.bom.String.FROM_CHARCODE);},unescape:function(n){return qx.util.StringEscape.unescape(n,qx.bom.String.TO_CHARCODE);},fromText:function(b){return qx.bom.String.escape(b).replace(/(  |\n)/g,function(j){var k={"  ":g,"\n":f};return k[j]||j;});},toText:function(l){return qx.bom.String.unescape(l.replace(/\s+|<([^>])+>/gi,function(m){if(m.indexOf(h)===0){return d;}else if(m.length>0&&m.replace(/^\s*/,i).replace(/\s*$/,i)==i){return e;}else{return i;}}));}},defer:function(a){a.FROM_CHARCODE=qx.lang.Object.invert(a.TO_CHARCODE);}});})();(function(){var g=";",f="&",e='X',d="",c='#',b="&#",a="qx.util.StringEscape";qx.Class.define(a,{statics:{escape:function(h,j){var m,o=d;for(var i=0,l=h.length;i<l;i++){var n=h.charAt(i);var k=n.charCodeAt(0);if(j[k]){m=f+j[k]+g;}else{if(k>0x7F){m=b+k+g;}else{m=n;}}o+=m;}return o;},unescape:function(p,q){return p.replace(/&[#\w]+;/gi,function(r){var s=r;var r=r.substring(1,r.length-1);var t=q[r];if(t){s=String.fromCharCode(t);}else{if(r.charAt(0)==c){if(r.charAt(1).toUpperCase()==e){t=r.substring(2);if(t.match(/^[0-9A-Fa-f]+$/gi)){s=String.fromCharCode(parseInt(t,16));}}else{t=r.substring(1);if(t.match(/^\d+$/gi)){s=String.fromCharCode(parseInt(t,10));}}}}return s;});}}});})();(function(){var a="qx.util.format.IFormat";qx.Interface.define(a,{members:{format:function(b){},parse:function(c){}}});})();(function(){var t="",s="Number",r="-",q="0",p="String",o="changeNumberFormat",n='(',m="g",l="Boolean",k="$",d="NaN",j='([0-9]{1,3}(?:',g='{0,1}[0-9]{3}){0,})',c='\\d+){0,1}',b="qx.util.format.NumberFormat",f="Infinity",e="^",h=".",a="-Infinity",i='([-+]){0,1}';qx.Class.define(b,{extend:qx.core.Object,implement:qx.util.format.IFormat,construct:function(Q){qx.core.Object.call(this);this.__mm=Q;},statics:{getIntegerInstance:function(){var u=qx.util.format.NumberFormat;if(u._integerInstance==null){u._integerInstance=new u();u._integerInstance.setMaximumFractionDigits(0);}return u._integerInstance;},getInstance:function(){if(!this._instance){this._instance=new this;}return this._instance;}},properties:{minimumIntegerDigits:{check:s,init:0},maximumIntegerDigits:{check:s,nullable:true},minimumFractionDigits:{check:s,init:0},maximumFractionDigits:{check:s,nullable:true},groupingUsed:{check:l,init:true},prefix:{check:p,init:t,event:o},postfix:{check:p,init:t,event:o}},members:{__mm:null,format:function(v){switch(v){case Infinity:return f;case -Infinity:return a;case NaN:return d;}var z=(v<0);if(z){v=-v;}if(this.getMaximumFractionDigits()!=null){var G=Math.pow(10,this.getMaximumFractionDigits());v=Math.round(v*G)/G;}var F=String(Math.floor(v)).length;var w=t+v;var C=w.substring(0,F);while(C.length<this.getMinimumIntegerDigits()){C=q+C;}if(this.getMaximumIntegerDigits()!=null&&C.length>this.getMaximumIntegerDigits()){C=C.substring(C.length-this.getMaximumIntegerDigits());}var B=w.substring(F+1);while(B.length<this.getMinimumFractionDigits()){B+=q;}if(this.getMaximumFractionDigits()!=null&&B.length>this.getMaximumFractionDigits()){B=B.substring(0,this.getMaximumFractionDigits());}if(this.getGroupingUsed()){var y=C;C=t;var E;for(E=y.length;E>3;E-=3){C=t+qx.locale.Number.getGroupSeparator(this.__mm)+y.substring(E-3,E)+C;}C=y.substring(0,E)+C;}var A=this.getPrefix()?this.getPrefix():t;var x=this.getPostfix()?this.getPostfix():t;var D=A+(z?r:t)+C;if(B.length>0){D+=t+qx.locale.Number.getDecimalSeparator(this.__mm)+B;}D+=x;return D;},parse:function(H){var M=qx.lang.String.escapeRegexpChars(qx.locale.Number.getGroupSeparator(this.__mm)+t);var K=qx.lang.String.escapeRegexpChars(qx.locale.Number.getDecimalSeparator(this.__mm)+t);var I=new RegExp(e+qx.lang.String.escapeRegexpChars(this.getPrefix())+i+j+M+g+n+K+c+qx.lang.String.escapeRegexpChars(this.getPostfix())+k);var L=I.exec(H);if(L==null){throw new Error("Number string '"+H+"' does not match the number format");}var N=(L[1]==r);var P=L[2];var O=L[3];P=P.replace(new RegExp(M,m),t);var J=(N?r:t)+P;if(O!=null&&O.length!=0){O=O.replace(new RegExp(K),t);J+=h+O;}return parseFloat(J);}}});})();(function(){var d="cldr_number_decimal_separator",c="cldr_number_percent_format",b="qx.locale.Number",a="cldr_number_group_separator";qx.Class.define(b,{statics:{getDecimalSeparator:function(g){return qx.locale.Manager.getInstance().localize(d,[],g);},getGroupSeparator:function(e){return qx.locale.Manager.getInstance().localize(a,[],e);},getPercentFormat:function(f){return qx.locale.Manager.getInstance().localize(c,[],f);}}});})();(function(){var bF="(\\d\\d?)",bE="format",bD="",bC="abbreviated",bB="wide",bA="(",bz=")",by="|",bx="stand-alone",bw="wildcard",bl="default",bk="literal",bj="'",bi="hour",bh="(\\d\\d?\\d?)",bg="ms",bf="narrow",be="-",bd="quoted_literal",bc='a',bM="HH:mm:ss",bN="+",bK="HHmmss",bL="long",bI='z',bJ="0",bG="sec",bH="day",bO='Z',bP=" ",bp="min",bo="mm",br="(\\d+)",bq="h",bt="KK",bs='L',bv="Z",bu="(\\d\\d+)",bn="EEEE",bm="^",c=":",d='y',e="K",f="a",g="([\\+\\-]\\d\\d:?\\d\\d)",h="GMT",j="dd",k="qx.util.format.DateFormat",l="yyy",m="H",bT="YYYY",bS="y",bR="HH",bQ="EE",bX='h',bW="S",bV='s',bU='A',ca="yyyyyy",bY="kk",L="ss",M='H',J='S',K="MMMM",P='c',Q="d",N="([a-zA-Z]+)",O='k',H="m",I='Y',u='D',t="yyyyy",w='K',v="hh",q="SSS",p="MM",s="yy",r="(\\d\\d\\d\\d\\d\\d+)",o="yyyy-MM-dd HH:mm:ss",n="(\\d\\d\\d\\d\\d+)",V="short",W='d',X="unkown",Y='m',R="(\\d\\d\\d\\d)",S="(\\d\\d\\d+)",T="k",U='M',ba="(\\d\\d\\d\\d+)",bb="SS",E="MMM",D="s",C="M",B='w',A="EEE",z="$",y="?",x='E',G="z",F="yyyy";qx.Class.define(k,{extend:qx.core.Object,implement:qx.util.format.IFormat,construct:function(ck,cl){qx.core.Object.call(this);if(!cl){this.__mn=qx.locale.Manager.getInstance().getLocale();}else{this.__mn=cl;}if(ck!=null){this.__mo=ck.toString();}else{this.__mo=qx.locale.Date.getDateFormat(bL,this.__mn)+bP+qx.locale.Date.getDateTimeFormat(bK,bM,this.__mn);}},statics:{getDateTimeInstance:function(){var cj=qx.util.format.DateFormat;var ci=qx.locale.Date.getDateFormat(bL)+bP+qx.locale.Date.getDateTimeFormat(bK,bM);if(cj._dateInstance==null||cj._dateInstance.__mo!=ci){cj._dateTimeInstance=new cj();}return cj._dateTimeInstance;},getDateInstance:function(){var cR=qx.util.format.DateFormat;var cQ=qx.locale.Date.getDateFormat(V)+bD;if(cR._dateInstance==null||cR._dateInstance.__mo!=cQ){cR._dateInstance=new cR(cQ);}return cR._dateInstance;},ASSUME_YEAR_2000_THRESHOLD:30,LOGGING_DATE_TIME__format:o,AM_MARKER:"am",PM_MARKER:"pm",MEDIUM_TIMEZONE_NAMES:["GMT"],FULL_TIMEZONE_NAMES:["Greenwich Mean Time"]},members:{__mn:null,__mo:null,__mp:null,__mq:null,__mr:null,__ms:function(cJ,cK){var cL=bD+cJ;while(cL.length<cK){cL=bJ+cL;}return cL;},__mt:function(cS){var cT=new Date(cS.getTime());var cU=cT.getDate();while(cT.getMonth()!=0){cT.setDate(-1);cU+=cT.getDate()+1;}return cU;},__mu:function(cI){return new Date(cI.getTime()+(3-((cI.getDay()+6)%7))*86400000);},__mv:function(dS){var dU=this.__mu(dS);var dV=dU.getFullYear();var dT=this.__mu(new Date(dV,0,4));return Math.floor(1.5+(dU.getTime()-dT.getTime())/86400000/7);},format:function(dw){if(dw==null){return null;}var dC=qx.util.format.DateFormat;var dD=this.__mn;var dN=dw.getFullYear();var dH=dw.getMonth();var dP=dw.getDate();var dx=dw.getDay();var dI=dw.getHours();var dE=dw.getMinutes();var dJ=dw.getSeconds();var dL=dw.getMilliseconds();var dO=dw.getTimezoneOffset();var dA=dO>0?1:-1;var dy=Math.floor(Math.abs(dO)/60);var dF=Math.abs(dO)%60;this.__mw();var dM=bD;for(var i=0;i<this.__mr.length;i++){var dK=this.__mr[i];if(dK.type==bk){dM+=dK.text;}else{var dB=dK.character;var dG=dK.size;var dz=y;switch(dB){case d:case I:if(dG==2){dz=this.__ms(dN%100,2);}else{dz=dN+bD;if(dG>dz.length){for(var i=dz.length;i<dG;i++){dz=bJ+dz;}}}break;case u:dz=this.__ms(this.__mt(dw),dG);break;case W:dz=this.__ms(dP,dG);break;case B:dz=this.__ms(this.__mv(dw),dG);break;case x:if(dG==2){dz=qx.locale.Date.getDayName(bf,dx,dD,bE);}else if(dG==3){dz=qx.locale.Date.getDayName(bC,dx,dD,bE);}else if(dG==4){dz=qx.locale.Date.getDayName(bB,dx,dD,bE);}break;case P:if(dG==2){dz=qx.locale.Date.getDayName(bf,dx,dD,bx);}else if(dG==3){dz=qx.locale.Date.getDayName(bC,dx,dD,bx);}else if(dG==4){dz=qx.locale.Date.getDayName(bB,dx,dD,bx);}break;case U:if(dG==1||dG==2){dz=this.__ms(dH+1,dG);}else if(dG==3){dz=qx.locale.Date.getMonthName(bC,dH,dD,bE);}else if(dG==4){dz=qx.locale.Date.getMonthName(bB,dH,dD,bE);}break;case bs:if(dG==1||dG==2){dz=this.__ms(dH+1,dG);}else if(dG==3){dz=qx.locale.Date.getMonthName(bC,dH,dD,bx);}else if(dG==4){dz=qx.locale.Date.getMonthName(bB,dH,dD,bx);}break;case bc:dz=(dI<12)?qx.locale.Date.getAmMarker(dD):qx.locale.Date.getPmMarker(dD);break;case M:dz=this.__ms(dI,dG);break;case O:dz=this.__ms((dI==0)?24:dI,dG);break;case w:dz=this.__ms(dI%12,dG);break;case bX:dz=this.__ms(((dI%12)==0)?12:(dI%12),dG);break;case Y:dz=this.__ms(dE,dG);break;case bV:dz=this.__ms(dJ,dG);break;case J:dz=this.__ms(dL,dG);break;case bI:if(dG==1){dz=h+((dA>0)?be:bN)+this.__ms(Math.abs(dy))+c+this.__ms(dF,2);}else if(dG==2){dz=dC.MEDIUM_TIMEZONE_NAMES[dy];}else if(dG==3){dz=dC.FULL_TIMEZONE_NAMES[dy];}break;case bO:dz=((dA>0)?be:bN)+this.__ms(Math.abs(dy),2)+this.__ms(dF,2);break;}dM+=dz;}}return dM;},parse:function(cz){this.__mx();var cF=this.__mp.regex.exec(cz);if(cF==null){throw new Error("Date string '"+cz+"' does not match the date format: "+this.__mo);}var cA={year:1970,month:0,day:1,hour:0,ispm:false,min:0,sec:0,ms:0};var cB=1;for(var i=0;i<this.__mp.usedRules.length;i++){var cD=this.__mp.usedRules[i];var cC=cF[cB];if(cD.field!=null){cA[cD.field]=parseInt(cC,10);}else{cD.manipulator(cA,cC);}cB+=(cD.groups==null)?1:cD.groups;}var cE=new Date(cA.year,cA.month,cA.day,(cA.ispm)?(cA.hour+12):cA.hour,cA.min,cA.sec,cA.ms);if(cA.month!=cE.getMonth()||cA.year!=cE.getFullYear()){throw new Error("Error parsing date '"+cz+"': the value for day or month is too large");}return cE;},__mw:function(){if(this.__mr!=null){return;}this.__mr=[];var ed;var eb=0;var ef=bD;var dY=this.__mo;var ec=bl;var i=0;while(i<dY.length){var ee=dY.charAt(i);switch(ec){case bd:if(ee==bj){if(i+1>=dY.length){i++;break;}var ea=dY.charAt(i+1);if(ea==bj){ef+=ee;i++;}else{i++;ec=X;}}else{ef+=ee;i++;}break;case bw:if(ee==ed){eb++;i++;}else{this.__mr.push({type:bw,character:ed,size:eb});ed=null;eb=0;ec=bl;}break;default:if((ee>=bc&&ee<=bI)||(ee>=bU&&ee<=bO)){ed=ee;ec=bw;}else if(ee==bj){if(i+1>=dY.length){ef+=ee;i++;break;}var ea=dY.charAt(i+1);if(ea==bj){ef+=ee;i++;}i++;ec=bd;}else{ec=bl;}if(ec!=bl){if(ef.length>0){this.__mr.push({type:bk,text:ef});ef=bD;}}else{ef+=ee;i++;}break;}}if(ed!=null){this.__mr.push({type:bw,character:ed,size:eb});}else if(ef.length>0){this.__mr.push({type:bk,text:ef});}},__mx:function(){if(this.__mp!=null){return ;}var cq=this.__mo;this.__my();this.__mw();var cw=[];var cs=bm;for(var co=0;co<this.__mr.length;co++){var cx=this.__mr[co];if(cx.type==bk){cs+=qx.lang.String.escapeRegexpChars(cx.text);}else{var cp=cx.character;var ct=cx.size;var cr;for(var cy=0;cy<this.__mq.length;cy++){var cu=this.__mq[cy];if(cp==cu.pattern.charAt(0)&&ct==cu.pattern.length){cr=cu;break;}}if(cr==null){var cv=bD;for(var i=0;i<ct;i++){cv+=cp;}throw new Error("Malformed date format: "+cq+". Wildcard "+cv+" is not supported");}else{cw.push(cr);cs+=cr.regex;}}}cs+=z;var cn;try{cn=new RegExp(cs);}catch(cm){throw new Error("Malformed date format: "+cq);}this.__mp={regex:cn,"usedRules":cw,pattern:cs};},__my:function(){var dh=qx.util.format.DateFormat;var dk=qx.lang.String;if(this.__mq!=null){return ;}var di=this.__mq=[];var cY=qx.locale.Date.getAmMarker(this.__mn).toString()||dh.AM_MARKER;var dq=qx.locale.Date.getPmMarker(this.__mn).toString()||dh.PM_MARKER;var dd=function(cM,cN){cN=parseInt(cN,10);if(cN<dh.ASSUME_YEAR_2000_THRESHOLD){cN+=2000;}else if(cN<100){cN+=1900;}cM.year=cN;};var df=function(du,dv){du.month=parseInt(dv,10)-1;};var db=function(cb,cc){var cd=qx.locale.Date.getPmMarker(this.__mn).toString()||dh.PM_MARKER;cb.ispm=(cc==cd);};var ds=function(cG,cH){cG.hour=parseInt(cH,10)%24;};var da=function(cO,cP){cO.hour=parseInt(cP,10)%12;};var dm=function(cV,cW){return;};var dt=qx.locale.Date.getMonthNames(bC,this.__mn,bE);for(var i=0;i<dt.length;i++){dt[i]=dk.escapeRegexpChars(dt[i].toString());}var dc=function(cg,ch){ch=dk.escapeRegexpChars(ch);cg.month=dt.indexOf(ch);};var dj=qx.locale.Date.getMonthNames(bB,this.__mn,bE);for(var i=0;i<dj.length;i++){dj[i]=dk.escapeRegexpChars(dj[i].toString());}var dn=function(ce,cf){cf=dk.escapeRegexpChars(cf);ce.month=dj.indexOf(cf);};var cX=qx.locale.Date.getDayNames(bf,this.__mn,bE);for(var i=0;i<cX.length;i++){cX[i]=dk.escapeRegexpChars(cX[i].toString());}var dr=function(dQ,dR){dR=dk.escapeRegexpChars(dR);dQ.month=cX.indexOf(dR);};var dp=qx.locale.Date.getDayNames(bC,this.__mn,bE);for(var i=0;i<dp.length;i++){dp[i]=dk.escapeRegexpChars(dp[i].toString());}var de=function(dW,dX){dX=dk.escapeRegexpChars(dX);dW.month=dp.indexOf(dX);};var dl=qx.locale.Date.getDayNames(bB,this.__mn,bE);for(var i=0;i<dl.length;i++){dl[i]=dk.escapeRegexpChars(dl[i].toString());}var dg=function(a,b){b=dk.escapeRegexpChars(b);a.month=dl.indexOf(b);};di.push({pattern:bT,regex:R,manipulator:dd});di.push({pattern:bS,regex:br,manipulator:dd});di.push({pattern:s,regex:bu,manipulator:dd});di.push({pattern:l,regex:S,manipulator:dd});di.push({pattern:F,regex:ba,manipulator:dd});di.push({pattern:t,regex:n,manipulator:dd});di.push({pattern:ca,regex:r,manipulator:dd});di.push({pattern:C,regex:bF,manipulator:df});di.push({pattern:p,regex:bF,manipulator:df});di.push({pattern:E,regex:bA+dt.join(by)+bz,manipulator:dc});di.push({pattern:K,regex:bA+dj.join(by)+bz,manipulator:dn});di.push({pattern:j,regex:bF,field:bH});di.push({pattern:Q,regex:bF,field:bH});di.push({pattern:bQ,regex:bA+cX.join(by)+bz,manipulator:dr});di.push({pattern:A,regex:bA+dp.join(by)+bz,manipulator:de});di.push({pattern:bn,regex:bA+dl.join(by)+bz,manipulator:dg});di.push({pattern:f,regex:bA+cY+by+dq+bz,manipulator:db});di.push({pattern:bR,regex:bF,field:bi});di.push({pattern:m,regex:bF,field:bi});di.push({pattern:bY,regex:bF,manipulator:ds});di.push({pattern:T,regex:bF,manipulator:ds});di.push({pattern:bt,regex:bF,field:bi});di.push({pattern:e,regex:bF,field:bi});di.push({pattern:v,regex:bF,manipulator:da});di.push({pattern:bq,regex:bF,manipulator:da});di.push({pattern:bo,regex:bF,field:bp});di.push({pattern:H,regex:bF,field:bp});di.push({pattern:L,regex:bF,field:bG});di.push({pattern:D,regex:bF,field:bG});di.push({pattern:q,regex:bh,field:bg});di.push({pattern:bb,regex:bh,field:bg});di.push({pattern:bW,regex:bh,field:bg});di.push({pattern:bv,regex:g,manipulator:dm});di.push({pattern:G,regex:N,manipulator:dm});}},destruct:function(){this.__mr=this.__mp=this.__mq=null;}});})();(function(){var t="_",s="format",r="thu",q="sat",p="cldr_day_",o="cldr_month_",n="wed",m="fri",l="tue",k="mon",K="sun",J="short",I="HH:mm",H="HHmmsszz",G="HHmm",F="HHmmss",E="cldr_date_format_",D="HH:mm:ss zz",C="full",B="cldr_pm",z="long",A="medium",x="cldr_am",y="qx.locale.Date",v="cldr_date_time_format_",w="cldr_time_format_",u="HH:mm:ss";qx.Class.define(y,{statics:{__mz:qx.locale.Manager.getInstance(),getAmMarker:function(O){return this.__mz.localize(x,[],O);},getPmMarker:function(j){return this.__mz.localize(B,[],j);},getDayNames:function(length,T,U){var U=U?U:s;{};var W=[K,k,l,n,r,m,q];var X=[];for(var i=0;i<W.length;i++){var V=p+U+t+length+t+W[i];X.push(this.__mz.localize(V,[],T));}return X;},getDayName:function(length,bb,bc,bd){var bd=bd?bd:s;{};var bf=[K,k,l,n,r,m,q];var be=p+bd+t+length+t+bf[bb];return this.__mz.localize(be,[],bc);},getMonthNames:function(length,P,Q){var Q=Q?Q:s;{};var S=[];for(var i=0;i<12;i++){var R=o+Q+t+length+t+(i+1);S.push(this.__mz.localize(R,[],P));}return S;},getMonthName:function(length,a,b,c){var c=c?c:s;{};var d=o+c+t+length+t+(a+1);return this.__mz.localize(d,[],b);},getDateFormat:function(L,M){{};var N=E+L;return this.__mz.localize(N,[],M);},getDateTimeFormat:function(bj,bk,bl){var bn=v+bj;var bm=this.__mz.localize(bn,[],bl);if(bm==bn){bm=bk;}return bm;},getTimeFormat:function(br,bs){{};var bu=w+br;var bt=this.__mz.localize(bu,[],bs);if(bt!=bu){return bt;}switch(br){case J:case A:return qx.locale.Date.getDateTimeFormat(G,I);case z:return qx.locale.Date.getDateTimeFormat(F,u);case C:return qx.locale.Date.getDateTimeFormat(H,D);default:throw new Error("This case should never happen.");}},getWeekStart:function(bg){var bh={"MV":5,"AE":6,"AF":6,"BH":6,"DJ":6,"DZ":6,"EG":6,"ER":6,"ET":6,"IQ":6,"IR":6,"JO":6,"KE":6,"KW":6,"LB":6,"LY":6,"MA":6,"OM":6,"QA":6,"SA":6,"SD":6,"SO":6,"TN":6,"YE":6,"AS":0,"AU":0,"AZ":0,"BW":0,"CA":0,"CN":0,"FO":0,"GE":0,"GL":0,"GU":0,"HK":0,"IE":0,"IL":0,"IS":0,"JM":0,"JP":0,"KG":0,"KR":0,"LA":0,"MH":0,"MN":0,"MO":0,"MP":0,"MT":0,"NZ":0,"PH":0,"PK":0,"SG":0,"TH":0,"TT":0,"TW":0,"UM":0,"US":0,"UZ":0,"VI":0,"ZA":0,"ZW":0,"MW":0,"NG":0,"TJ":0};var bi=qx.locale.Date._getTerritory(bg);return bh[bi]!=null?bh[bi]:1;},getWeekendStart:function(bv){var bx={"EG":5,"IL":5,"SY":5,"IN":0,"AE":4,"BH":4,"DZ":4,"IQ":4,"JO":4,"KW":4,"LB":4,"LY":4,"MA":4,"OM":4,"QA":4,"SA":4,"SD":4,"TN":4,"YE":4};var bw=qx.locale.Date._getTerritory(bv);return bx[bw]!=null?bx[bw]:6;},getWeekendEnd:function(bo){var bp={"AE":5,"BH":5,"DZ":5,"IQ":5,"JO":5,"KW":5,"LB":5,"LY":5,"MA":5,"OM":5,"QA":5,"SA":5,"SD":5,"TN":5,"YE":5,"AF":5,"IR":5,"EG":6,"IL":6,"SY":6};var bq=qx.locale.Date._getTerritory(bo);return bp[bq]!=null?bp[bq]:0;},isWeekend:function(e,f){var h=qx.locale.Date.getWeekendStart(f);var g=qx.locale.Date.getWeekendEnd(f);if(g>h){return ((e>=h)&&(e<=g));}else{return ((e>=h)||(e<=g));}},_getTerritory:function(Y){if(Y){var ba=Y.split(t)[1]||Y;}else{ba=this.__mz.getTerritory()||this.__mz.getLanguage();}return ba.toUpperCase();}}});})();(function(){var m="qx.dynlocale",l="Boolean",k="changeLocale",j="changeInvalidMessage",i="on",h="String",g="invalid",f="",d="qx.ui.form.MForm",c="_applyValid",a="changeRequired",b="changeValid";qx.Mixin.define(d,{construct:function(){if(qx.core.Variant.isSet(m,i)){qx.locale.Manager.getInstance().addListener(k,this.__mA,this);}},properties:{valid:{check:l,init:true,apply:c,event:b},required:{check:l,init:false,event:a},invalidMessage:{check:h,init:f,event:j},requiredInvalidMessage:{check:h,nullable:true,event:j}},members:{_applyValid:function(p,q){p?this.removeState(g):this.addState(g);},__mA:qx.core.Variant.select(m,{"on":function(e){var n=this.getInvalidMessage();if(n&&n.translate){this.setInvalidMessage(n.translate());}var o=this.getRequiredInvalidMessage();if(o&&o.translate){this.setRequiredInvalidMessage(o.translate());}},"off":null})},destruct:function(){if(qx.core.Variant.isSet(m,i)){qx.locale.Manager.getInstance().removeListener(k,this.__mA,this);}}});})();(function(){var y="showingPlaceholder",x="",w="none",v="qx.dynlocale",u="Boolean",t="qx.client",s="color",r="qx.event.type.Data",q="readonly",p="input",bo="focusin",bn="visibility",bm="focusout",bl="changeLocale",bk="hidden",bj="on",bi="absolute",bh="readOnly",bg="text",bf="_applyTextAlign",F="px",G="RegExp",D=")",E="syncAppearance",B="changeValue",C="A",z="change",A="textAlign",J="focused",K="center",S="visible",Q="disabled",W="url(",U="off",bb="String",Y="resize",M="qx.ui.form.AbstractField",be="transparent",bd="spellcheck",bc="false",L="right",O="PositiveInteger",P="mshtml",R="abstract",T="block",V="webkit",X="_applyReadOnly",ba="_applyPlaceholder",H="left",I="qx/static/blank.gif",N="text-placeholder";qx.Class.define(M,{extend:qx.ui.core.Widget,implement:[qx.ui.form.IStringForm,qx.ui.form.IForm],include:[qx.ui.form.MForm],type:R,construct:function(n){qx.ui.core.Widget.call(this);if(n!=null){this.setValue(n);}this.getContentElement().addListener(z,this._onChangeContent,this);this.addListener(E,this._syncPlaceholder,this);if(qx.core.Variant.isSet(v,bj)){qx.locale.Manager.getInstance().addListener(bl,this._onChangeLocale,this);}},events:{"input":r,"changeValue":r},properties:{textAlign:{check:[H,K,L],nullable:true,themeable:true,apply:bf},readOnly:{check:u,apply:X,init:false},selectable:{refine:true,init:true},focusable:{refine:true,init:true},maxLength:{check:O,init:Infinity},liveUpdate:{check:u,init:false},placeholder:{check:bb,nullable:true,apply:ba},filter:{check:G,nullable:true,init:null}},members:{__mB:true,__mC:null,__mD:null,__mE:null,getFocusElement:function(){var bR=this.getContentElement();if(bR){return bR;}},_createInputElement:function(){return new qx.html.Input(bg);},renderLayout:function(bw,top,bx,by){var bz=this._updateInsets;var bD=qx.ui.core.Widget.prototype.renderLayout.call(this,bw,top,bx,by);if(!bD){return;}var bB=bD.size||bz;var bE=F;if(bB||bD.local||bD.margin){var bA=this.getInsets();var innerWidth=bx-bA.left-bA.right;var innerHeight=by-bA.top-bA.bottom;innerWidth=innerWidth<0?0:innerWidth;innerHeight=innerHeight<0?0:innerHeight;}var bC=this.getContentElement();if(bz){this.__mH().setStyles({"left":bA.left+bE,"top":bA.top+bE});}if(bB){this.__mH().setStyles({"width":innerWidth+bE,"height":innerHeight+bE});bC.setStyles({"width":innerWidth+bE,"height":innerHeight+bE});this._renderContentElement(innerHeight,bC);}},_renderContentElement:function(innerHeight,d){},_createContentElement:function(){var a=this._createInputElement();a.setStyles({"border":w,"padding":0,"margin":0,"display":T,"background":be,"outline":w,"appearance":w,"position":bi,"autoComplete":U});a.setSelectable(this.getSelectable());a.setEnabled(this.getEnabled());a.addListener(p,this._onHtmlInput,this);a.setAttribute(bd,bc);if(qx.core.Variant.isSet(t,V)){a.setStyle(Y,w);}if(qx.core.Variant.isSet(t,P)){a.setStyles({backgroundImage:W+qx.util.ResourceManager.getInstance().toUri(I)+D});}return a;},_applyEnabled:function(bS,bT){qx.ui.core.Widget.prototype._applyEnabled.call(this,bS,bT);this.getContentElement().setEnabled(bS);if(bS){this._showPlaceholder();}else{this._removePlaceholder();}},__mF:{width:16,height:16},_getContentHint:function(){return {width:this.__mF.width*10,height:this.__mF.height||16};},_applyFont:function(bJ,bK){var bL;if(bJ){var bM=qx.theme.manager.Font.getInstance().resolve(bJ);bL=bM.getStyles();}else{bL=qx.bom.Font.getDefaultStyles();}this.getContentElement().setStyles(bL);this.__mH().setStyles(bL);if(bJ){this.__mF=qx.bom.Label.getTextSize(C,bL);}else{delete this.__mF;}qx.ui.core.queue.Layout.add(this);},_applyTextColor:function(b,c){if(b){this.getContentElement().setStyle(s,qx.theme.manager.Color.getInstance().resolve(b));}else{this.getContentElement().removeStyle(s);}},tabFocus:function(){qx.ui.core.Widget.prototype.tabFocus.call(this);this.selectAllText();},_getTextSize:function(){return this.__mF;},_onHtmlInput:function(e){var i=e.getData();var h=true;this.__mB=false;if(this.getFilter()!=null){var j=x;var f=i.search(this.getFilter());var g=i;while(f>=0){j=j+(g.charAt(f));g=g.substring(f+1,g.length);f=g.search(this.getFilter());}if(j!=i){h=false;i=j;this.getContentElement().setValue(i);}}if(i.length>this.getMaxLength()){var h=false;this.getContentElement().setValue(i.substr(0,this.getMaxLength()));}if(h){this.fireDataEvent(p,i,this.__mE);this.__mE=i;if(this.getLiveUpdate()){this.__mG(i);}}},__mG:function(bu){var bv=this.__mD;this.__mD=bu;if(bv!=bu){this.fireNonBubblingEvent(B,qx.event.type.Data,[bu,bv]);}},setValue:function(bN){if(bN===null){if(this.__mB){return bN;}bN=x;this.__mB=true;}else{this.__mB=false;this._removePlaceholder();}if(qx.lang.Type.isString(bN)){var bP=this.getContentElement();if(bN.length>this.getMaxLength()){bN=bN.substr(0,this.getMaxLength());}if(bP.getValue()!=bN){var bQ=bP.getValue();bP.setValue(bN);var bO=this.__mB?null:bN;this.__mD=bQ;this.__mG(bO);}this._showPlaceholder();return bN;}throw new Error("Invalid value type: "+bN);},getValue:function(){var br=this.getContentElement().getValue();return this.__mB?null:br;},resetValue:function(){this.setValue(null);},_onChangeContent:function(e){this.__mB=e.getData()===null;this.__mG(e.getData());},getTextSelection:function(){return this.getContentElement().getTextSelection();},getTextSelectionLength:function(){return this.getContentElement().getTextSelectionLength();},getTextSelectionStart:function(){return this.getContentElement().getTextSelectionStart();},getTextSelectionEnd:function(){return this.getContentElement().getTextSelectionEnd();},setTextSelection:function(bp,bq){this.getContentElement().setTextSelection(bp,bq);},clearTextSelection:function(){this.getContentElement().clearTextSelection();},selectAllText:function(){this.setTextSelection(0);},_showPlaceholder:function(){var bt=this.getValue()||x;var bs=this.getPlaceholder();if(bs!=null&&bt==x&&!this.hasState(J)&&!this.hasState(Q)){if(this.hasState(y)){this._syncPlaceholder();}else{this.addState(y);}}},_removePlaceholder:function(){if(this.hasState(y)){this.__mH().setStyle(bn,bk);this.removeState(y);}},_syncPlaceholder:function(){if(this.hasState(y)){this.__mH().setStyle(bn,S);}},__mH:function(){if(this.__mC==null){this.__mC=new qx.html.Label();var o=qx.theme.manager.Color.getInstance();this.__mC.setStyles({"visibility":bk,"zIndex":6,"position":bi,"color":o.resolve(N)});this.getContainerElement().add(this.__mC);}return this.__mC;},_onChangeLocale:qx.core.Variant.select(v,{"on":function(e){var content=this.getPlaceholder();if(content&&content.translate){this.setPlaceholder(content.translate());}},"off":null}),_applyPlaceholder:function(bH,bI){this.__mH().setValue(bH);if(bH!=null){this.addListener(bo,this._removePlaceholder,this);this.addListener(bm,this._showPlaceholder,this);this._showPlaceholder();}else{this.removeListener(bo,this._removePlaceholder,this);this.removeListener(bm,this._showPlaceholder,this);this._removePlaceholder();}},_applyTextAlign:function(bF,bG){this.getContentElement().setStyle(A,bF);},_applyReadOnly:function(k,l){var m=this.getContentElement();m.setAttribute(bh,k);if(k){this.addState(q);this.setFocusable(false);}else{this.removeState(q);this.setFocusable(true);}}},destruct:function(){this.__mC=null;if(qx.core.Variant.isSet(v,bj)){qx.locale.Manager.getInstance().removeListener(bl,this._onChangeLocale,this);}}});})();(function(){var b="qx.ui.form.TextField",a="textfield";qx.Class.define(b,{extend:qx.ui.form.AbstractField,properties:{appearance:{refine:true,init:a},allowGrowY:{refine:true,init:false},allowShrinkY:{refine:true,init:false}},members:{_renderContentElement:function(innerHeight,c){}}});})();(function(){var q="none",p="wrap",o="value",n="qx.client",m="textarea",l="off",k="on",j="qxSelectable",i="",h="webkit",d="input",g="qx.html.Input",f="select",c="disabled",b="read-only",e="userSelect";qx.Class.define(g,{extend:qx.html.Element,construct:function(z,A,B){if(z===f||z===m){var C=z;}else{C=d;}qx.html.Element.call(this,C,A,B);this.__mI=z;},members:{__mI:null,__mJ:null,__mK:null,_createDomElement:function(){return qx.bom.Input.create(this.__mI);},_applyProperty:function(name,v){qx.html.Element.prototype._applyProperty.call(this,name,v);var w=this.getDomElement();if(name===o){qx.bom.Input.setValue(w,v);}else if(name===p){qx.bom.Input.setWrap(w,v);}},setEnabled:qx.core.Variant.select(n,{"webkit":function(a){this.__mK=a;if(!a){this.setStyles({"userModify":b,"userSelect":q});}else{this.setStyles({"userModify":null,"userSelect":this.__mJ?null:q});}},"default":function(E){this.setAttribute(c,E===false);}}),setSelectable:qx.core.Variant.select(n,{"webkit":function(t){this.__mJ=t;this.setAttribute(j,t?k:l);if(qx.core.Variant.isSet(n,h)){var u=this.__mK?t?null:q:q;this.setStyle(e,u);}},"default":function(x){this.setAttribute(j,x?k:l);}}),setValue:function(r){var s=this.getDomElement();if(s){if(s.value!=r){qx.bom.Input.setValue(s,r);}}else{this._setProperty(o,r);}return this;},getValue:function(){var y=this.getDomElement();if(y){return qx.bom.Input.getValue(y);}return this._getProperty(o)||i;},setWrap:function(D){if(this.__mI===m){this._setProperty(p,D);}else{throw new Error("Text wrapping is only support by textareas!");}return this;},getWrap:function(){if(this.__mI===m){return this._getProperty(p);}else{throw new Error("Text wrapping is only support by textareas!");}}}});})();(function(){var bf="change",be="input",bd="qx.client",bc="text",bb="password",ba="checkbox",Y="radio",X="textarea",W="keypress",V="opera",P="propertychange",U="blur",S="keydown",O="keyup",N="select-multiple",R="checked",Q="value",T="select",M="qx.event.handler.Input";qx.Class.define(M,{extend:qx.core.Object,implement:qx.event.IEventHandler,construct:function(){qx.core.Object.call(this);this._onChangeCheckedWrapper=qx.lang.Function.listener(this._onChangeChecked,this);this._onChangeValueWrapper=qx.lang.Function.listener(this._onChangeValue,this);this._onInputWrapper=qx.lang.Function.listener(this._onInput,this);this._onPropertyWrapper=qx.lang.Function.listener(this._onProperty,this);if(qx.core.Variant.isSet(bd,V)){this._onKeyDownWrapper=qx.lang.Function.listener(this._onKeyDown,this);this._onKeyUpWrapper=qx.lang.Function.listener(this._onKeyUp,this);this._onBlurWrapper=qx.lang.Function.listener(this._onBlur,this);}},statics:{PRIORITY:qx.event.Registration.PRIORITY_NORMAL,SUPPORTED_TYPES:{input:1,change:1},TARGET_CHECK:qx.event.IEventHandler.TARGET_DOMNODE,IGNORE_CAN_HANDLE:false},members:{__mL:false,__mM:null,__mN:null,canHandleEvent:function(h,j){var k=h.tagName.toLowerCase();if(j===be&&(k===be||k===X)){return true;}if(j===bf&&(k===be||k===X||k===T)){return true;}return false;},registerEvent:qx.core.Variant.select(bd,{"mshtml":function(E,F,G){if(!E.__mO){var H=E.tagName.toLowerCase();var I=E.type;if(I===bc||I===bb||H===X||I===ba||I===Y){qx.bom.Event.addNativeListener(E,P,this._onPropertyWrapper);}if(I!==ba&&I!==Y){qx.bom.Event.addNativeListener(E,bf,this._onChangeValueWrapper);}if(I===bc||I===bb){this._onKeyPressWrapped=qx.lang.Function.listener(this._onKeyPress,this,E);qx.bom.Event.addNativeListener(E,W,this._onKeyPressWrapped);}E.__mO=true;}},"default":function(u,v,w){if(v===be){this.__mP(u);}else if(v===bf){if(u.type===Y||u.type===ba){qx.bom.Event.addNativeListener(u,bf,this._onChangeCheckedWrapper);}else{qx.bom.Event.addNativeListener(u,bf,this._onChangeValueWrapper);}if(qx.core.Variant.isSet(bd,V)){if(u.type===bc||u.type===bb){this._onKeyPressWrapped=qx.lang.Function.listener(this._onKeyPress,this,u);qx.bom.Event.addNativeListener(u,W,this._onKeyPressWrapped);}}}}}),__mP:qx.core.Variant.select(bd,{"mshtml":null,"webkit":function(y){var z=y.tagName.toLowerCase();if(qx.bom.client.Engine.VERSION<532&&z==X){qx.bom.Event.addNativeListener(y,W,this._onInputWrapper);}qx.bom.Event.addNativeListener(y,be,this._onInputWrapper);},"opera":function(g){qx.bom.Event.addNativeListener(g,O,this._onKeyUpWrapper);qx.bom.Event.addNativeListener(g,S,this._onKeyDownWrapper);qx.bom.Event.addNativeListener(g,U,this._onBlurWrapper);qx.bom.Event.addNativeListener(g,be,this._onInputWrapper);},"default":function(f){qx.bom.Event.addNativeListener(f,be,this._onInputWrapper);}}),unregisterEvent:qx.core.Variant.select(bd,{"mshtml":function(q,r){if(q.__mO){var s=q.tagName.toLowerCase();var t=q.type;if(t===bc||t===bb||s===X||t===ba||t===Y){qx.bom.Event.removeNativeListener(q,P,this._onPropertyWrapper);}if(t!==ba&&t!==Y){qx.bom.Event.removeNativeListener(q,bf,this._onChangeValueWrapper);}if(t===bc||t===bb){qx.bom.Event.removeNativeListener(q,W,this._onKeyPressWrapped);}try{delete q.__mO;}catch(L){q.__mO=null;}}},"default":function(c,d){if(d===be){this.__mP(c);}else if(d===bf){if(c.type===Y||c.type===ba){qx.bom.Event.removeNativeListener(c,bf,this._onChangeCheckedWrapper);}else{qx.bom.Event.removeNativeListener(c,bf,this._onChangeValueWrapper);}}if(qx.core.Variant.isSet(bd,V)){if(c.type===bc||c.type===bb){qx.bom.Event.removeNativeListener(c,W,this._onKeyPressWrapped);}}}}),__mQ:qx.core.Variant.select(bd,{"mshtml":null,"webkit":function(A){var B=A.tagName.toLowerCase();if(qx.bom.client.Engine.VERSION<532&&B==X){qx.bom.Event.removeNativeListener(A,W,this._onInputWrapper);}qx.bom.Event.removeNativeListener(A,be,this._onInputWrapper);},"opera":function(D){qx.bom.Event.removeNativeListener(D,O,this._onKeyUpWrapper);qx.bom.Event.removeNativeListener(D,S,this._onKeyDownWrapper);qx.bom.Event.removeNativeListener(D,U,this._onBlurWrapper);qx.bom.Event.removeNativeListener(D,be,this._onInputWrapper);},"default":function(C){qx.bom.Event.removeNativeListener(C,be,this._onInputWrapper);}}),_onKeyPress:qx.core.Variant.select(bd,{"mshtml|opera":function(e,a){if(e.keyCode===13){if(a.value!==this.__mN){this.__mN=a.value;qx.event.Registration.fireEvent(a,bf,qx.event.type.Data,[a.value]);}}},"default":null}),_onKeyDown:qx.core.Variant.select(bd,{"opera":function(e){if(e.keyCode===13){this.__mL=true;}},"default":null}),_onKeyUp:qx.core.Variant.select(bd,{"opera":function(e){if(e.keyCode===13){this.__mL=false;}},"default":null}),_onBlur:qx.core.Variant.select(bd,{"opera":function(e){if(this.__mM){window.clearTimeout(this.__mM);}},"default":null}),_onInput:qx.event.GlobalError.observeMethod(function(e){var b=e.target;if(!this.__mL){if(qx.core.Variant.isSet(bd,V)){this.__mM=window.setTimeout(function(){qx.event.Registration.fireEvent(b,be,qx.event.type.Data,[b.value]);},0);}else{qx.event.Registration.fireEvent(b,be,qx.event.type.Data,[b.value]);}}}),_onChangeValue:qx.event.GlobalError.observeMethod(function(e){var K=e.target||e.srcElement;var J=K.value;if(K.type===N){var J=[];for(var i=0,o=K.options,l=o.length;i<l;i++){if(o[i].selected){J.push(o[i].value);}}}qx.event.Registration.fireEvent(K,bf,qx.event.type.Data,[J]);}),_onChangeChecked:qx.event.GlobalError.observeMethod(function(e){var x=e.target;if(x.type===Y){if(x.checked){qx.event.Registration.fireEvent(x,bf,qx.event.type.Data,[x.value]);}}else{qx.event.Registration.fireEvent(x,bf,qx.event.type.Data,[x.checked]);}}),_onProperty:qx.core.Variant.select(bd,{"mshtml":qx.event.GlobalError.observeMethod(function(e){var n=e.target||e.srcElement;var p=e.propertyName;if(p===Q&&(n.type===bc||n.type===bb||n.tagName.toLowerCase()===X)){if(!n.$$inValueSet){qx.event.Registration.fireEvent(n,be,qx.event.type.Data,[n.value]);}}else if(p===R){if(n.type===ba){qx.event.Registration.fireEvent(n,bf,qx.event.type.Data,[n.checked]);}else if(n.checked){qx.event.Registration.fireEvent(n,bf,qx.event.type.Data,[n.value]);}}}),"default":function(){}})},defer:function(m){qx.event.Registration.addHandler(m);}});})();(function(){var J="",I="select",H="soft",G="off",F="qx.client",E="textarea",D="wrap",C="text",B="mshtml",A="number",t="checkbox",z="select-one",w="input",s="option",r="value",v="radio",u="qx.bom.Input",x="nowrap",q="auto",y="normal";qx.Class.define(u,{statics:{__mR:{text:1,textarea:1,select:1,checkbox:1,radio:1,password:1,hidden:1,submit:1,image:1,file:1,search:1,reset:1,button:1},create:function(a,b,c){{};var b=b?qx.lang.Object.clone(b):{};var d;if(a===E||a===I){d=a;}else{d=w;b.type=a;}return qx.bom.Element.create(d,b,c);},setValue:function(S,T){var Y=S.nodeName.toLowerCase();var V=S.type;var Array=qx.lang.Array;var ba=qx.lang.Type;if(typeof T===A){T+=J;}if((V===t||V===v)){if(ba.isArray(T)){S.checked=Array.contains(T,S.value);}else{S.checked=S.value==T;}}else if(Y===I){var U=ba.isArray(T);var bb=S.options;var W,X;for(var i=0,l=bb.length;i<l;i++){W=bb[i];X=W.getAttribute(r);if(X==null){X=W.text;}W.selected=U?Array.contains(T,X):T==X;}if(U&&T.length==0){S.selectedIndex=-1;}}else if((V===C||V===E)&&qx.core.Variant.isSet(F,B)){S.$$inValueSet=true;S.value=T;S.$$inValueSet=null;}else{S.value=T;}},getValue:function(e){var m=e.nodeName.toLowerCase();if(m===s){return (e.attributes.value||{}).specified?e.value:e.text;}if(m===I){var f=e.selectedIndex;if(f<0){return null;}var n=[];var p=e.options;var o=e.type==z;var k=qx.bom.Input;var j;for(var i=o?f:0,h=o?f+1:p.length;i<h;i++){var g=p[i];if(g.selected){j=k.getValue(g);if(o){return j;}n.push(j);}}return n;}else{return (e.value||J).replace(/\r/g,J);}},setWrap:qx.core.Variant.select(F,{"mshtml":function(O,P){O.wrap=P?H:G;},"gecko|webkit":function(K,L){var N=L?H:G;var M=L?J:q;K.setAttribute(D,N);K.style.overflow=M;},"default":function(Q,R){Q.style.whiteSpace=R?y:x;}})}});})();(function(){var bq="",bp="Number",bo='</div>',bn='" ',bm="paneUpdated",bl='<div>',bk="</div>",bj="overflow: hidden;",bi="qx.event.type.Data",bh="paneReloadsData",bI="div",bH='style="',bG="_applyMaxCacheLines",bF="qx.ui.table.pane.Pane",bE="width: 100%;",bD="qx.event.type.Event",bC="_applyVisibleRowCount",bB='>',bA="line-height: ",bz="appear",bx='class="',by="width:100%;",bv="px;",bw='<div ',bt="'>",bu="_applyFirstVisibleRow",br="<div style='",bs=";position:relative;";qx.Class.define(bF,{extend:qx.ui.core.Widget,construct:function(p){qx.ui.core.Widget.call(this);this.__mS=p;this.__mT=0;this.__mU=0;this.__mV=[];},events:{"paneReloadsData":bi,"paneUpdated":bD},properties:{firstVisibleRow:{check:bp,init:0,apply:bu},visibleRowCount:{check:bp,init:0,apply:bC},maxCacheLines:{check:bp,init:1000,apply:bG},allowShrinkX:{refine:true,init:false}},members:{__mU:null,__mT:null,__mS:null,__mW:null,__mX:null,__mY:null,__mV:null,__na:0,_applyFirstVisibleRow:function(j,k){this.updateContent(false,j-k);},_applyVisibleRowCount:function(a,b){this.updateContent(true);},_getContentHint:function(){return {width:this.getPaneScroller().getTablePaneModel().getTotalWidth(),height:400};},getPaneScroller:function(){return this.__mS;},getTable:function(){return this.__mS.getTable();},setFocusedCell:function(L,M,N){if(L!=this.__mY||M!=this.__mX){var O=this.__mX;this.__mY=L;this.__mX=M;if(M!=O&&!N){if(O!==null){this.updateContent(false,null,O,true);}if(M!==null){this.updateContent(false,null,M,true);}}}},onSelectionChanged:function(){this.updateContent(false,null,null,true);},onFocusChanged:function(){this.updateContent(false,null,null,true);},setColumnWidth:function(n,o){this.updateContent(true);},onColOrderChanged:function(){this.updateContent(true);},onPaneModelChanged:function(){this.updateContent(true);},onTableModelDataChanged:function(bb,bc,bd,be){this.__nb();var bg=this.getFirstVisibleRow();var bf=this.getVisibleRowCount();if(bc==-1||bc>=bg&&bb<bg+bf){this.updateContent();}},onTableModelMetaDataChanged:function(){this.updateContent(true);},_applyMaxCacheLines:function(l,m){if(this.__na>=l&&l!==-1){this.__nb();}},__nb:function(){this.__mV=[];this.__na=0;},__nc:function(q,r,s){if(!r&&!s&&this.__mV[q]){return this.__mV[q];}else{return null;}},__nd:function(d,e,f,g){var h=this.getMaxCacheLines();if(!f&&!g&&!this.__mV[d]&&h>0){this._applyMaxCacheLines(h);this.__mV[d]=e;this.__na+=1;}},updateContent:function(H,I,J,K){if(H){this.__nb();}if(I&&Math.abs(I)<=Math.min(10,this.getVisibleRowCount())){this._scrollContent(I);}else if(K&&!this.getTable().getAlwaysUpdateCells()){this._updateRowStyles(J);}else{this._updateAllRows();}},_updateRowStyles:function(P){var T=this.getContentElement().getDomElement();if(!T||!T.firstChild){this._updateAllRows();return;}var X=this.getTable();var R=X.getSelectionModel();var U=X.getTableModel();var Y=X.getDataRowRenderer();var S=T.firstChild.childNodes;var W={table:X};var ba=this.getFirstVisibleRow();var y=0;var Q=S.length;if(P!=null){var V=P-ba;if(V>=0&&V<Q){ba=P;y=V;Q=V+1;}else{return;}}for(;y<Q;y++,ba++){W.row=ba;W.selected=R.isSelectedIndex(ba);W.focusedRow=(this.__mX==ba);W.rowData=U.getRowData(ba);Y.updateDataRowElement(W,S[y]);}},_getRowsHtml:function(bJ,bK){var bQ=this.getTable();var bT=bQ.getSelectionModel();var bN=bQ.getTableModel();var bO=bQ.getTableColumnModel();var cj=this.getPaneScroller().getTablePaneModel();var bY=bQ.getDataRowRenderer();bN.prefetchRows(bJ,bJ+bK-1);var cg=bQ.getRowHeight();var ci=cj.getColumnCount();var bP=0;var bM=[];for(var x=0;x<ci;x++){var cm=cj.getColumnAtX(x);var bS=bO.getColumnWidth(cm);bM.push({col:cm,xPos:x,editable:bN.isColumnEditable(cm),focusedCol:this.__mY==cm,styleLeft:bP,styleWidth:bS});bP+=bS;}var cl=[];var cn=false;for(var bR=bJ;bR<bJ+bK;bR++){var bU=bT.isSelectedIndex(bR);var bX=(this.__mX==bR);var cd=this.__nc(bR,bU,bX);if(cd){cl.push(cd);continue;}var bL=[];var cf={table:bQ};cf.styleHeight=cg;cf.row=bR;cf.selected=bU;cf.focusedRow=bX;cf.rowData=bN.getRowData(bR);if(!cf.rowData){cn=true;}bL.push(bw);var cc=bY.getRowAttributes(cf);if(cc){bL.push(cc);}var cb=bY.getRowClass(cf);if(cb){bL.push(bx,cb,bn);}var ca=bY.createRowStyle(cf);ca+=bs+bY.getRowHeightStyle(cg)+by;if(ca){bL.push(bH,ca,bn);}bL.push(bB);var ck=false;for(x=0;x<ci&&!ck;x++){var bV=bM[x];for(var ch in bV){cf[ch]=bV[ch];}var cm=cf.col;cf.value=bN.getValue(cm,bR);var bW=bO.getDataCellRenderer(cm);cf.style=bW.getDefaultCellStyle();ck=bW.createDataCellHtml(cf,bL)||false;}bL.push(bo);var ce=bL.join(bq);this.__nd(bR,ce,bU,bX);cl.push(ce);}this.fireDataEvent(bh,cn);return cl.join(bq);},_scrollContent:function(co){var cp=this.getContentElement().getDomElement();if(!(cp&&cp.firstChild)){this._updateAllRows();return;}var cy=cp.firstChild;var cq=cy.childNodes;var cw=this.getVisibleRowCount();var cv=this.getFirstVisibleRow();var ct=this.getTable().getTableModel();var cz=0;cz=ct.getRowCount();if(cv+cw>cz){this._updateAllRows();return;}var cA=co<0?cw+co:0;var cr=co<0?0:cw-co;for(i=Math.abs(co)-1;i>=0;i--){var cu=cq[cA];try{cy.removeChild(cu);}catch(c){break;}}if(!this.__mW){this.__mW=document.createElement(bI);}var cx=bl;cx+=this._getRowsHtml(cv+cr,Math.abs(co));cx+=bo;this.__mW.innerHTML=cx;var cs=this.__mW.firstChild.childNodes;if(co>0){for(var i=cs.length-1;i>=0;i--){var cu=cs[0];cy.appendChild(cu);}}else{for(var i=cs.length-1;i>=0;i--){var cu=cs[cs.length-1];cy.insertBefore(cu,cy.firstChild);}}if(this.__mX!==null){this._updateRowStyles(this.__mX-co);this._updateRowStyles(this.__mX);}this.fireEvent(bm);},_updateAllRows:function(){var w=this.getContentElement().getDomElement();if(!w){this.addListenerOnce(bz,arguments.callee,this);return;}var E=this.getTable();var B=E.getTableModel();var D=this.getPaneScroller().getTablePaneModel();var C=D.getColumnCount();var t=E.getRowHeight();var z=this.getFirstVisibleRow();var u=this.getVisibleRowCount();var F=B.getRowCount();if(z+u>F){u=Math.max(0,F-z);}var v=D.getTotalWidth();var A;if(u>0){A=[br,bE,(E.getForceLineHeight()?bA+t+bv:bq),bj,bt,this._getRowsHtml(z,u),bk];}else{A=[];}var G=A.join(bq);w.innerHTML=G;this.setWidth(v);this.__mT=C;this.__mU=u;this.fireEvent(bm);}},destruct:function(){this.__mW=this.__mS=this.__mV=null;}});})();(function(){var e="hovered",d="__nf",c="qx.ui.table.pane.Header";qx.Class.define(c,{extend:qx.ui.core.Widget,construct:function(h){qx.ui.core.Widget.call(this);this._setLayout(new qx.ui.layout.HBox());this.__ne=new qx.ui.core.Blocker(this);this.__nf=h;},members:{__nf:null,__ng:null,__nh:null,__ne:null,getPaneScroller:function(){return this.__nf;},getTable:function(){return this.__nf.getTable();},getBlocker:function(){return this.__ne;},onColOrderChanged:function(){this._updateContent(true);},onPaneModelChanged:function(){this._updateContent(true);},onTableModelMetaDataChanged:function(){this._updateContent();},setColumnWidth:function(v,w){var y=this.getHeaderWidgetAtColumn(v);if(y!=null){y.setWidth(w);}},setMouseOverColumn:function(a){if(a!=this.__nh){if(this.__nh!=null){var b=this.getHeaderWidgetAtColumn(this.__nh);if(b!=null){b.removeState(e);}}if(a!=null){this.getHeaderWidgetAtColumn(a).addState(e);}this.__nh=a;}},getHeaderWidgetAtColumn:function(t){var u=this.getPaneScroller().getTablePaneModel().getX(t);return this._getChildren()[u];},showColumnMoveFeedback:function(i,x){var m=this.getContainerLocation();if(this.__ng==null){var r=this.getTable();var j=this.getPaneScroller().getTablePaneModel().getX(i);var l=this._getChildren()[j];var n=r.getTableModel();var p=r.getTableColumnModel();var q={xPos:j,col:i,name:n.getColumnName(i),table:r};var o=p.getHeaderCellRenderer(i);var k=o.createHeaderCell(q);var s=l.getBounds();k.setWidth(s.width);k.setHeight(s.height);k.setZIndex(1000000);k.setOpacity(0.8);k.setLayoutProperties({top:m.top});this.getApplicationRoot().add(k);this.__ng=k;}this.__ng.setLayoutProperties({left:m.left+x});this.__ng.show();},hideColumnMoveFeedback:function(){if(this.__ng!=null){this.__ng.destroy();this.__ng=null;}},isShowingColumnMoveFeedback:function(){return this.__ng!=null;},_updateContent:function(z){var J=this.getTable();var D=J.getTableModel();var G=J.getTableColumnModel();var I=this.getPaneScroller().getTablePaneModel();var L=this._getChildren();var E=I.getColumnCount();var H=D.getSortColumnIndex();if(z){this._cleanUpCells();}var A={};A.sortedAscending=D.isSortAscending();for(var x=0;x<E;x++){var C=I.getColumnAtX(x);if(C===undefined){continue;}var K=G.getColumnWidth(C);var F=G.getHeaderCellRenderer(C);A.xPos=x;A.col=C;A.name=D.getColumnName(C);A.editable=D.isColumnEditable(C);A.sorted=(C==H);A.table=J;var B=L[x];if(B==null){B=F.createHeaderCell(A);B.set({width:K});this._add(B);}else{F.updateHeaderCell(A,B);}}},_cleanUpCells:function(){var g=this._getChildren();for(var x=g.length-1;x>=0;x--){var f=g[x];f.destroy();}}},destruct:function(){this.__ne.dispose();this._disposeObjects(d);}});})();(function(){var b="qx.nativeScrollBars",a="qx.ui.core.scroll.MScrollBarFactory";qx.core.Setting.define(b,false);qx.Mixin.define(a,{members:{_createScrollBar:function(c){if(qx.core.Setting.get(b)){return new qx.ui.core.scroll.NativeScrollBar(c);}else{return new qx.ui.core.scroll.ScrollBar(c);}}}});})();(function(){var m="Boolean",l="resize-line",k="mousedown",j="qx.event.type.Data",i="mouseup",h="qx.ui.table.pane.CellEvent",g="scroll",d="focus-indicator",c="excluded",b="scrollbar-y",bm="table-scroller-focus-indicator",bl="visible",bk="mousemove",bj="header",bi="editing",bh="click",bg="modelChanged",bf="scrollbar-x",be="cellClick",bd="pane",t="__nl",u="__nn",r="mouseout",s="__nj",p="__nq",q="changeHorizontalScrollBarVisible",n="bottom",o="_applyScrollTimeout",z="changeScrollX",A="_applyTablePaneModel",I="Integer",G="dblclick",Q="__nm",L="dataEdited",Y="mousewheel",V="interval",C="qx.ui.table.pane.Scroller",bc="_applyShowCellFocusIndicator",bb="resize",ba="vertical",B="__nr",E="changeScrollY",F="appear",H="__np",J="table-scroller",M="beforeSort",S="__no",X="cellDblclick",v="horizontal",w="losecapture",D="contextmenu",P="col-resize",O="disappear",N="_applyVerticalScrollBarVisible",U="_applyHorizontalScrollBarVisible",T="__nk",K="cellContextmenu",R="close",a="changeTablePaneModel",W="qx.ui.table.pane.Model",y="changeVerticalScrollBarVisible";qx.Class.define(C,{extend:qx.ui.core.Widget,include:qx.ui.core.scroll.MScrollBarFactory,construct:function(bD){qx.ui.core.Widget.call(this);this.__ni=bD;var bE=new qx.ui.layout.Grid();bE.setColumnFlex(0,1);bE.setRowFlex(1,1);this._setLayout(bE);this.__nj=this._showChildControl(bf);this.__nk=this._showChildControl(b);this.__nl=this._showChildControl(bj);this.__nm=this._showChildControl(bd);this.__nn=new qx.ui.container.Composite(new qx.ui.layout.HBox()).set({minWidth:0});this._add(this.__nn,{row:0,column:0,colSpan:2});this.__no=new qx.ui.table.pane.Clipper();this.__no.add(this.__nl);this.__no.addListener(w,this._onChangeCaptureHeader,this);this.__no.addListener(bk,this._onMousemoveHeader,this);this.__no.addListener(k,this._onMousedownHeader,this);this.__no.addListener(i,this._onMouseupHeader,this);this.__no.addListener(bh,this._onClickHeader,this);this.__nn.add(this.__no,{flex:1});this.__np=new qx.ui.table.pane.Clipper();this.__np.add(this.__nm);this.__np.addListener(Y,this._onMousewheel,this);this.__np.addListener(bk,this._onMousemovePane,this);this.__np.addListener(k,this._onMousedownPane,this);this.__np.addListener(i,this._onMouseupPane,this);this.__np.addListener(bh,this._onClickPane,this);this.__np.addListener(D,this._onContextMenu,this);this.__np.addListener(G,this._onDblclickPane,this);this.__np.addListener(bb,this._onResizePane,this);this._add(this.__np,{row:1,column:0});this.__nq=this.getChildControl(d);this.initShowCellFocusIndicator();this.getChildControl(l).hide();this.addListener(r,this._onMouseout,this);this.addListener(F,this._onAppear,this);this.addListener(O,this._onDisappear,this);this.__nr=new qx.event.Timer();this.__nr.addListener(V,this._oninterval,this);this.initScrollTimeout();},statics:{MIN_COLUMN_WIDTH:10,RESIZE_REGION_RADIUS:5,CLICK_TOLERANCE:5,HORIZONTAL_SCROLLBAR:1,VERTICAL_SCROLLBAR:2},events:{"changeScrollY":j,"changeScrollX":j,"cellClick":h,"cellDblclick":h,"cellContextmenu":h,"beforeSort":j},properties:{horizontalScrollBarVisible:{check:m,init:true,apply:U,event:q},verticalScrollBarVisible:{check:m,init:true,apply:N,event:y},tablePaneModel:{check:W,apply:A,event:a},liveResize:{check:m,init:false},focusCellOnMouseMove:{check:m,init:false},selectBeforeFocus:{check:m,init:false},showCellFocusIndicator:{check:m,init:true,apply:bc},resetSelectionOnHeaderClick:{check:m,init:true},scrollTimeout:{check:I,init:100,apply:o},appearance:{refine:true,init:J}},members:{__ns:null,__ni:null,__nt:null,__nu:null,__nv:null,__nw:null,__nx:null,__ny:null,__nz:null,__nA:null,__nB:null,__nC:null,__nD:null,__nE:null,__nF:false,__nG:null,__nH:null,__nI:null,__nJ:null,__nK:null,__nL:null,__nM:null,__nN:null,__nj:null,__nk:null,__nl:null,__no:null,__nm:null,__np:null,__nq:null,__nn:null,__nr:null,getPaneInsetRight:function(){var eq=this.getTopRightWidget();var er=eq&&eq.isVisible()&&eq.getBounds()?eq.getBounds().width:0;var ep=this.getVerticalScrollBarVisible()?this.getVerticalScrollBarWidth():0;return Math.max(er,ep);},setPaneWidth:function(bw){if(this.isVerticalScrollBarVisible()){bw+=this.getPaneInsetRight();}this.setWidth(bw);},_createChildControlImpl:function(ey){var ez;switch(ey){case bj:ez=(this.getTable().getNewTablePaneHeader())(this);break;case bd:ez=(this.getTable().getNewTablePane())(this);break;case d:ez=new qx.ui.table.pane.FocusIndicator(this);ez.setUserBounds(0,0,0,0);ez.setZIndex(1000);ez.addListener(i,this._onMouseupFocusIndicator,this);this.__np.add(ez);ez.show();ez.setDecorator(null);break;case l:ez=new qx.ui.core.Widget();ez.setUserBounds(0,0,0,0);ez.setZIndex(1000);this.__np.add(ez);break;case bf:ez=this._createScrollBar(v).set({minWidth:0,alignY:n});ez.addListener(g,this._onScrollX,this);this._add(ez,{row:2,column:0});break;case b:ez=this._createScrollBar(ba);ez.addListener(g,this._onScrollY,this);this._add(ez,{row:1,column:1});break;}return ez||qx.ui.core.Widget.prototype._createChildControlImpl.call(this,ey);},_applyHorizontalScrollBarVisible:function(cf,cg){this.__nj.setVisibility(cf?bl:c);},_applyVerticalScrollBarVisible:function(eQ,eR){this.__nk.setVisibility(eQ?bl:c);},_applyTablePaneModel:function(dL,dM){if(dM!=null){dM.removeListener(bg,this._onPaneModelChanged,this);}dL.addListener(bg,this._onPaneModelChanged,this);},_applyShowCellFocusIndicator:function(cy,cz){if(cy){this.__nq.setDecorator(bm);this._updateFocusIndicator();}else{if(this.__nq){this.__nq.setDecorator(null);}}},getScrollY:function(){return this.__nk.getPosition();},setScrollY:function(scrollY,bC){this.__nk.scrollTo(scrollY);if(bC){this._updateContent();}},getScrollX:function(){return this.__nj.getPosition();},setScrollX:function(scrollX){this.__nj.scrollTo(scrollX);},getTable:function(){return this.__ni;},onColVisibilityChanged:function(){this.updateHorScrollBarMaximum();this._updateFocusIndicator();},setColumnWidth:function(cc,cd){this.__nl.setColumnWidth(cc,cd);this.__nm.setColumnWidth(cc,cd);var ce=this.getTablePaneModel();var x=ce.getX(cc);if(x!=-1){this.updateHorScrollBarMaximum();this._updateFocusIndicator();}},onColOrderChanged:function(){this.__nl.onColOrderChanged();this.__nm.onColOrderChanged();this.updateHorScrollBarMaximum();},onTableModelDataChanged:function(cC,cD,cE,cF){this.__nm.onTableModelDataChanged(cC,cD,cE,cF);var cG=this.getTable().getTableModel().getRowCount();if(cG!=this.__ns){this.updateVerScrollBarMaximum();if(this.getFocusedRow()>=cG){if(cG==0){this.setFocusedCell(null,null);}else{this.setFocusedCell(this.getFocusedColumn(),cG-1);}}this.__ns=cG;}},onSelectionChanged:function(){this.__nm.onSelectionChanged();},onFocusChanged:function(){this.__nm.onFocusChanged();},onTableModelMetaDataChanged:function(){this.__nl.onTableModelMetaDataChanged();this.__nm.onTableModelMetaDataChanged();},_onPaneModelChanged:function(){this.__nl.onPaneModelChanged();this.__nm.onPaneModelChanged();},_onResizePane:function(){this.updateHorScrollBarMaximum();this.updateVerScrollBarMaximum();this._updateContent();this.__nl._updateContent();this.__ni._updateScrollBarVisibility();},updateHorScrollBarMaximum:function(){var ev=this.__np.getInnerSize();if(!ev){return ;}var et=this.getTablePaneModel().getTotalWidth();var eu=this.__nj;if(ev.width<et){var es=Math.max(0,et-ev.width);eu.setMaximum(es);eu.setKnobFactor(ev.width/et);var ew=eu.getPosition();eu.setPosition(Math.min(ew,es));}else{eu.setMaximum(0);eu.setKnobFactor(1);eu.setPosition(0);}},updateVerScrollBarMaximum:function(){var da=this.__np.getInnerSize();if(!da){return ;}var cX=this.getTable().getTableModel();var cT=cX.getRowCount();if(this.getTable().getKeepFirstVisibleRowComplete()){cT+=1;}var cS=this.getTable().getRowHeight();var cV=cT*cS;var cY=this.__nk;if(da.height<cV){var cU=Math.max(0,cV-da.height);cY.setMaximum(cU);cY.setKnobFactor(da.height/cV);var cW=cY.getPosition();cY.setPosition(Math.min(cW,cU));}else{cY.setMaximum(0);cY.setKnobFactor(1);cY.setPosition(0);}},onKeepFirstVisibleRowCompleteChanged:function(){this.updateVerScrollBarMaximum();this._updateContent();},_onAppear:function(){this._startInterval(this.getScrollTimeout());},_onDisappear:function(){this._stopInterval();},_onScrollX:function(e){var cP=e.getData();this.fireDataEvent(z,cP,e.getOldData());this.__no.scrollToX(cP);this.__np.scrollToX(cP);},_onScrollY:function(e){this.fireDataEvent(E,e.getData(),e.getOldData());this._postponedUpdateContent();},_onMousewheel:function(e){var bz=this.getTable();if(!bz.getEnabled()){return;}var bB=qx.bom.client.Engine.GECKO?1:3;var bA=this.__nk.getPosition()+((e.getWheelDelta()*bB)*bz.getRowHeight());this.__nk.scrollTo(bA);if(this.__nH&&this.getFocusCellOnMouseMove()){this._focusCellAtPagePos(this.__nH,this.__nI);}e.stop();},__nO:function(eg){var el=this.getTable();var em=this.__nl.getHeaderWidgetAtColumn(this.__nB);var eh=em.getSizeHint().minWidth;var ej=Math.max(eh,this.__nD+eg-this.__nC);if(this.getLiveResize()){var ei=el.getTableColumnModel();ei.setColumnWidth(this.__nB,ej);}else{this.__nl.setColumnWidth(this.__nB,ej);var ek=this.getTablePaneModel();this._showResizeLine(ek.getColumnLeft(this.__nB)+ej);}this.__nC+=ej-this.__nD;this.__nD=ej;},__nP:function(eT){var eU=qx.ui.table.pane.Scroller.CLICK_TOLERANCE;if(this.__nl.isShowingColumnMoveFeedback()||eT>this.__nA+eU||eT<this.__nA-eU){this.__nx+=eT-this.__nA;this.__nl.showColumnMoveFeedback(this.__nw,this.__nx);var eV=this.__ni.getTablePaneScrollerAtPageX(eT);if(this.__nz&&this.__nz!=eV){this.__nz.hideColumnMoveFeedback();}if(eV!=null){this.__ny=eV.showColumnMoveFeedback(eT);}else{this.__ny=null;}this.__nz=eV;this.__nA=eT;}},_onMousemoveHeader:function(e){var bN=this.getTable();if(!bN.getEnabled()){return;}var bO=false;var bH=null;var bL=e.getDocumentLeft();var bM=e.getDocumentTop();this.__nH=bL;this.__nI=bM;if(this.__nB!=null){this.__nO(bL);bO=true;e.stopPropagation();}else if(this.__nw!=null){this.__nP(bL);e.stopPropagation();}else{var bI=this._getResizeColumnForPageX(bL);if(bI!=-1){bO=true;}else{var bK=bN.getTableModel();var bP=this._getColumnForPageX(bL);if(bP!=null&&bK.isColumnSortable(bP)){bH=bP;}}}var bJ=bO?P:null;this.getApplicationRoot().setGlobalCursor(bJ);this.setCursor(bJ);this.__nl.setMouseOverColumn(bH);},_onMousemovePane:function(e){var dS=this.getTable();if(!dS.getEnabled()){return;}var dU=e.getDocumentLeft();var dV=e.getDocumentTop();this.__nH=dU;this.__nI=dV;var dT=this._getRowForPagePos(dU,dV);if(dT!=null&&this._getColumnForPageX(dU)!=null){if(this.getFocusCellOnMouseMove()){this._focusCellAtPagePos(dU,dV);}}this.__nl.setMouseOverColumn(null);},_onMousedownHeader:function(e){if(!this.getTable().getEnabled()){return;}var bR=e.getDocumentLeft();var bS=this._getResizeColumnForPageX(bR);if(bS!=-1){this._startResizeHeader(bS,bR);e.stop();}else{var bQ=this._getColumnForPageX(bR);if(bQ!=null){this._startMoveHeader(bQ,bR);e.stop();}}},_startResizeHeader:function(dv,dw){var dx=this.getTable().getTableColumnModel();this.__nB=dv;this.__nC=dw;this.__nD=dx.getColumnWidth(this.__nB);this.__no.capture();},_startMoveHeader:function(ch,ci){this.__nw=ch;this.__nA=ci;this.__nx=this.getTablePaneModel().getColumnLeft(ch);this.__no.capture();},_onMousedownPane:function(e){var ea=this.getTable();if(!ea.getEnabled()){return;}if(ea.isEditing()){ea.stopEditing();}var dW=e.getDocumentLeft();var dY=e.getDocumentTop();var ec=this._getRowForPagePos(dW,dY);var eb=this._getColumnForPageX(dW);if(ec!==null){this.__nE={row:ec,col:eb};this.__nF=false;var dX=this.getSelectBeforeFocus();if(dX){ea.getSelectionManager().handleMouseDown(ec,e);}if(!this.getFocusCellOnMouseMove()){this._focusCellAtPagePos(dW,dY);}if(!dX){ea.getSelectionManager().handleMouseDown(ec,e);}}},_onMouseupFocusIndicator:function(e){if(this.__nE&&!this.__nF&&!this.isEditing()&&this.__nq.getRow()==this.__nE.row&&this.__nq.getColumn()==this.__nE.col){this.fireEvent(be,qx.ui.table.pane.CellEvent,[this,e,this.__nE.row,this.__nE.col],true);this.__nF=true;}else if(!this.isEditing()){this._onMousedownPane(e);}},_onChangeCaptureHeader:function(e){if(this.__nB!=null){this._stopResizeHeader();}if(this.__nw!=null){this._stopMoveHeader();}},_stopResizeHeader:function(){var bF=this.getTable().getTableColumnModel();if(!this.getLiveResize()){this._hideResizeLine();bF.setColumnWidth(this.__nB,this.__nD);}this.__nB=null;this.__no.releaseCapture();this.getApplicationRoot().setGlobalCursor(null);this.setCursor(null);if(this.isEditing()){var bG=this.__nL.getBounds().height;this.__nL.setUserBounds(0,0,this.__nD,bG);}},_stopMoveHeader:function(){var cL=this.getTable().getTableColumnModel();var cM=this.getTablePaneModel();this.__nl.hideColumnMoveFeedback();if(this.__nz){this.__nz.hideColumnMoveFeedback();}if(this.__ny!=null){var cO=cM.getFirstColumnX()+cM.getX(this.__nw);var cK=this.__ny;if(cK!=cO&&cK!=cO+1){var cN=cL.getVisibleColumnAtX(cO);var cJ=cL.getVisibleColumnAtX(cK);var cI=cL.getOverallX(cN);var cH=(cJ!=null)?cL.getOverallX(cJ):cL.getOverallColumnCount();if(cH>cI){cH--;}cL.moveColumn(cI,cH);this._updateFocusIndicator();}}this.__nw=null;this.__ny=null;this.__no.releaseCapture();},_onMouseupPane:function(e){var cj=this.getTable();if(!cj.getEnabled()){return;}var ck=this._getRowForPagePos(e.getDocumentLeft(),e.getDocumentTop());if(ck!=-1&&ck!=null&&this._getColumnForPageX(e.getDocumentLeft())!=null){cj.getSelectionManager().handleMouseUp(ck,e);}},_onMouseupHeader:function(e){var eS=this.getTable();if(!eS.getEnabled()){return;}if(this.__nB!=null){this._stopResizeHeader();this.__nG=true;e.stop();}else if(this.__nw!=null){this._stopMoveHeader();e.stop();}},_onClickHeader:function(e){if(this.__nG){this.__nG=false;return;}var dH=this.getTable();if(!dH.getEnabled()){return;}var dF=dH.getTableModel();var dG=e.getDocumentLeft();var dE=this._getResizeColumnForPageX(dG);if(dE==-1){var dK=this._getColumnForPageX(dG);if(dK!=null&&dF.isColumnSortable(dK)){var dD=dF.getSortColumnIndex();var dI=(dK!=dD)?true:!dF.isSortAscending();var dJ={column:dK,ascending:dI,clickEvent:e};if(this.fireDataEvent(M,dJ,null,true)){dF.sortByColumn(dK,dI);if(this.getResetSelectionOnHeaderClick()){dH.getSelectionModel().resetSelection();}}}}e.stop();},_onClickPane:function(e){var dy=this.getTable();if(!dy.getEnabled()){return;}var dB=e.getDocumentLeft();var dC=e.getDocumentTop();var dz=this._getRowForPagePos(dB,dC);var dA=this._getColumnForPageX(dB);if(dz!=null&&dA!=null){dy.getSelectionManager().handleClick(dz,e);if(this.__nq.isHidden()||(this.__nE&&!this.__nF&&!this.isEditing()&&dz==this.__nE.row&&dA==this.__nE.col)){this.fireEvent(be,qx.ui.table.pane.CellEvent,[this,e,dz,dA],true);this.__nF=true;}}},_onContextMenu:function(e){var dt=e.getDocumentLeft();var du=e.getDocumentTop();var dr=this._getRowForPagePos(dt,du);var ds=this._getColumnForPageX(dt);if(this.__nq.isHidden()||(this.__nE&&dr==this.__nE.row&&ds==this.__nE.col)){this.fireEvent(K,qx.ui.table.pane.CellEvent,[this,e,dr,ds],true);var dq=this.getTable().getContextMenu();if(dq){if(dq.getChildren().length>0){dq.openAtMouse(e);}else{dq.exclude();}e.preventDefault();}}},_onContextMenuOpen:function(e){},_onDblclickPane:function(e){var eX=e.getDocumentLeft();var eY=e.getDocumentTop();this._focusCellAtPagePos(eX,eY);this.startEditing();var eW=this._getRowForPagePos(eX,eY);if(eW!=-1&&eW!=null){this.fireEvent(X,qx.ui.table.pane.CellEvent,[this,e,eW],true);}},_onMouseout:function(e){var ex=this.getTable();if(!ex.getEnabled()){return;}if(this.__nB==null){this.setCursor(null);this.getApplicationRoot().setGlobalCursor(null);}this.__nl.setMouseOverColumn(null);},_showResizeLine:function(x){var ee=this._showChildControl(l);var ed=ee.getWidth();var ef=this.__np.getBounds();ee.setUserBounds(x-Math.round(ed/2),0,ed,ef.height);},_hideResizeLine:function(){this._excludeChildControl(l);},showColumnMoveFeedback:function(cl){var cu=this.getTablePaneModel();var ct=this.getTable().getTableColumnModel();var co=this.__nm.getContainerLocation().left;var cs=cu.getColumnCount();var cp=0;var cn=0;var cx=co;for(var cm=0;cm<cs;cm++){var cq=cu.getColumnAtX(cm);var cv=ct.getColumnWidth(cq);if(cl<cx+cv/2){break;}cx+=cv;cp=cm+1;cn=cx-co;}var cr=this.__np.getContainerLocation().left;var cw=this.__np.getBounds().width;var scrollX=cr-co;cn=qx.lang.Number.limit(cn,scrollX+2,scrollX+cw-1);this._showResizeLine(cn);return cu.getFirstColumnX()+cp;},hideColumnMoveFeedback:function(){this._hideResizeLine();},_focusCellAtPagePos:function(dO,dP){var dR=this._getRowForPagePos(dO,dP);if(dR!=-1&&dR!=null){var dQ=this._getColumnForPageX(dO);this.__ni.setFocusedCell(dQ,dR);}},setFocusedCell:function(cA,cB){if(!this.isEditing()){this.__nm.setFocusedCell(cA,cB,this.__nu);this.__nJ=cA;this.__nK=cB;this._updateFocusIndicator();}},getFocusedColumn:function(){return this.__nJ;},getFocusedRow:function(){return this.__nK;},scrollCellVisible:function(db,dc){var dm=this.getTablePaneModel();var dd=dm.getX(db);if(dd!=-1){var dj=this.__np.getInnerSize();if(!dj){return;}var dk=this.getTable().getTableColumnModel();var dg=dm.getColumnLeft(db);var dn=dk.getColumnWidth(db);var de=this.getTable().getRowHeight();var dp=dc*de;var scrollX=this.getScrollX();var scrollY=this.getScrollY();var dl=Math.min(dg,dg+dn-dj.width);var di=dg;this.setScrollX(Math.max(dl,Math.min(di,scrollX)));var df=dp+de-dj.height;if(this.getTable().getKeepFirstVisibleRowComplete()){df+=de;}var dh=dp;this.setScrollY(Math.max(df,Math.min(dh,scrollY)),true);}},isEditing:function(){return this.__nL!=null;},startEditing:function(){var eM=this.getTable();var eK=eM.getTableModel();var eO=this.__nJ;if(!this.isEditing()&&(eO!=null)&&eK.isColumnEditable(eO)){var eP=this.__nK;var eI=this.getTablePaneModel().getX(eO);var eJ=eK.getValue(eO,eP);this.__nM=eM.getTableColumnModel().getCellEditorFactory(eO);var eL={col:eO,row:eP,xPos:eI,value:eJ,table:eM};this.__nL=this.__nM.createCellEditor(eL);if(this.__nL===null){return false;}else if(this.__nL instanceof qx.ui.window.Window){this.__nL.setModal(true);this.__nL.setShowClose(false);this.__nL.addListener(R,this._onCellEditorModalWindowClose,this);var f=eM.getModalCellEditorPreOpenFunction();if(f!=null){f(this.__nL,eL);}this.__nL.open();}else{var eN=this.__nq.getInnerSize();this.__nL.setUserBounds(0,0,eN.width,eN.height);this.__nq.addListener(k,function(e){this.__nE={row:this.__nK,col:this.__nJ};e.stopPropagation();},this);this.__nq.add(this.__nL);this.__nq.addState(bi);this.__nq.setKeepActive(false);this.__nq.setDecorator(bm);this.__nL.focus();this.__nL.activate();}return true;}return false;},stopEditing:function(){if(!this.getShowCellFocusIndicator()){this.__nq.setDecorator(null);}this.flushEditor();this.cancelEditing();},flushEditor:function(){if(this.isEditing()){var by=this.__nM.getCellEditorValue(this.__nL);var bx=this.getTable().getTableModel().getValue(this.__nJ,this.__nK);this.getTable().getTableModel().setValue(this.__nJ,this.__nK,by);this.__ni.focus();this.__ni.fireDataEvent(L,{row:this.__nK,col:this.__nJ,oldValue:bx,value:by});}},cancelEditing:function(){if(this.isEditing()&&!this.__nL.pendingDispose){if(this._cellEditorIsModalWindow){this.__nL.destroy();this.__nL=null;this.__nM=null;this.__nL.pendingDispose=true;}else{this.__nq.removeState(bi);this.__nq.setKeepActive(true);this.__nL.destroy();this.__nL=null;this.__nM=null;}}},_onCellEditorModalWindowClose:function(e){this.stopEditing();},_getColumnForPageX:function(bp){var bs=this.getTable().getTableColumnModel();var bt=this.getTablePaneModel();var br=bt.getColumnCount();var bv=this.__nl.getContainerLocation().left;for(var x=0;x<br;x++){var bq=bt.getColumnAtX(x);var bu=bs.getColumnWidth(bq);bv+=bu;if(bp<bv){return bq;}}return null;},_getResizeColumnForPageX:function(bT){var bX=this.getTable().getTableColumnModel();var bY=this.getTablePaneModel();var bW=bY.getColumnCount();var cb=this.__nl.getContainerLocation().left;var bU=qx.ui.table.pane.Scroller.RESIZE_REGION_RADIUS;for(var x=0;x<bW;x++){var bV=bY.getColumnAtX(x);var ca=bX.getColumnWidth(bV);cb+=ca;if(bT>=(cb-bU)&&bT<=(cb+bU)){return bV;}}return -1;},_getRowForPagePos:function(fo,fp){var fq=this.__nm.getContentLocation();if(fo<fq.left||fo>fq.right){return null;}if(fp>=fq.top&&fp<=fq.bottom){var fr=this.getTable().getRowHeight();var scrollY=this.__nk.getPosition();if(this.getTable().getKeepFirstVisibleRowComplete()){scrollY=Math.floor(scrollY/fr)*fr;}var fu=scrollY+fp-fq.top;var fw=Math.floor(fu/fr);var fv=this.getTable().getTableModel();var fs=fv.getRowCount();return (fw<fs)?fw:null;}var ft=this.__nl.getContainerLocation();if(fp>=ft.top&&fp<=ft.bottom&&fo<=ft.right){return -1;}return null;},setTopRightWidget:function(en){var eo=this.__nN;if(eo!=null){this.__nn.remove(eo);}if(en!=null){this.__nn.add(en);}this.__nN=en;},getTopRightWidget:function(){return this.__nN;},getHeader:function(){return this.__nl;},getTablePane:function(){return this.__nm;},getVerticalScrollBarWidth:function(){var dN=this.__nk;return dN.isVisible()?(dN.getSizeHint().width||0):0;},getNeededScrollBars:function(fa,fb){var fh=this.__nk.getSizeHint().width;var fi=this.__np.getInnerSize();var fc=fi?fi.width:0;if(this.getVerticalScrollBarVisible()){fc+=fh;}var fl=fi?fi.height:0;if(this.getHorizontalScrollBarVisible()){fl+=fh;}var ff=this.getTable().getTableModel();var fj=ff.getRowCount();var fm=this.getTablePaneModel().getTotalWidth();var fk=this.getTable().getRowHeight()*fj;var fe=false;var fn=false;if(fm>fc){fe=true;if(fk>fl-fh){fn=true;}}else if(fk>fl){fn=true;if(!fb&&(fm>fc-fh)){fe=true;}}var fg=qx.ui.table.pane.Scroller.HORIZONTAL_SCROLLBAR;var fd=qx.ui.table.pane.Scroller.VERTICAL_SCROLLBAR;return ((fa||fe)?fg:0)|((fb||!fn)?0:fd);},getPaneClipper:function(){return this.__np;},_applyScrollTimeout:function(cQ,cR){this._startInterval(cQ);},_startInterval:function(fx){this.__nr.setInterval(fx);this.__nr.start();},_stopInterval:function(){this.__nr.stop();},_postponedUpdateContent:function(){this._updateContent();},_oninterval:qx.event.GlobalError.observeMethod(function(){if(this.__nu&&!this.__nm._layoutPending){this.__nu=false;this._updateContent();}}),_updateContent:function(){var eE=this.__np.getInnerSize();if(!eE){return;}var eH=eE.height;var scrollX=this.__nj.getPosition();var scrollY=this.__nk.getPosition();var eB=this.getTable().getRowHeight();var eC=Math.floor(scrollY/eB);var eG=this.__nm.getFirstVisibleRow();this.__nm.setFirstVisibleRow(eC);var eD=Math.ceil(eH/eB);var eA=0;var eF=this.getTable().getKeepFirstVisibleRowComplete();if(!eF){eD++;eA=scrollY%eB;}this.__nm.setVisibleRowCount(eD);if(eC!=eG){this._updateFocusIndicator();}this.__np.scrollToX(scrollX);if(!eF){this.__np.scrollToY(eA);}},_updateFocusIndicator:function(){var bn=this.getTable();if(!bn.getEnabled()){return;}this.__nq.moveToCell(this.__nJ,this.__nK);}},destruct:function(){this._stopInterval();var bo=this.getTablePaneModel();if(bo){bo.dispose();}this.__nE=this.__nN=this.__ni=null;this._disposeObjects(s,T,S,H,p,t,Q,u,B);}});})();(function(){var c="qx.ui.core.scroll.IScrollBar",b="qx.event.type.Data";qx.Interface.define(c,{events:{"scroll":b},properties:{orientation:{},maximum:{},position:{},knobFactor:{}},members:{scrollTo:function(e){this.assertNumber(e);},scrollBy:function(d){this.assertNumber(d);},scrollBySteps:function(a){this.assertNumber(a);}}});})();(function(){var o="horizontal",n="px",m="scroll",l="vertical",k="-1px",j="qx.client",i="0",h="hidden",g="mousedown",f="qx.ui.core.scroll.NativeScrollBar",D="PositiveNumber",C="Integer",B="__nR",A="mousemove",z="_applyMaximum",y="_applyOrientation",x="appear",w="opera",v="PositiveInteger",u="mshtml",s="mouseup",t="Number",q="_applyPosition",r="scrollbar",p="native";qx.Class.define(f,{extend:qx.ui.core.Widget,implement:qx.ui.core.scroll.IScrollBar,construct:function(O){qx.ui.core.Widget.call(this);this.addState(p);this.getContentElement().addListener(m,this._onScroll,this);this.addListener(g,this._stopPropagation,this);this.addListener(s,this._stopPropagation,this);this.addListener(A,this._stopPropagation,this);if(qx.core.Variant.isSet(j,w)){this.addListener(x,this._onAppear,this);}this.getContentElement().add(this._getScrollPaneElement());if(O!=null){this.setOrientation(O);}else{this.initOrientation();}},properties:{appearance:{refine:true,init:r},orientation:{check:[o,l],init:o,apply:y},maximum:{check:v,apply:z,init:100},position:{check:t,init:0,apply:q,event:m},singleStep:{check:C,init:20},knobFactor:{check:D,nullable:true}},members:{__nQ:null,__nR:null,_getScrollPaneElement:function(){if(!this.__nR){this.__nR=new qx.html.Element();}return this.__nR;},renderLayout:function(K,top,L,M){var N=qx.ui.core.Widget.prototype.renderLayout.call(this,K,top,L,M);this._updateScrollBar();return N;},_getContentHint:function(){var a=qx.bom.element.Overflow.getScrollbarWidth();return {width:this.__nQ?100:a,maxWidth:this.__nQ?null:a,minWidth:this.__nQ?null:a,height:this.__nQ?a:100,maxHeight:this.__nQ?a:null,minHeight:this.__nQ?a:null};},_applyEnabled:function(P,Q){qx.ui.core.Widget.prototype._applyEnabled.call(this,P,Q);this._updateScrollBar();},_applyMaximum:function(I){this._updateScrollBar();},_applyPosition:function(J){var content=this.getContentElement();if(this.__nQ){content.scrollToX(J);}else{content.scrollToY(J);}},_applyOrientation:function(E,F){var G=this.__nQ=E===o;this.set({allowGrowX:G,allowShrinkX:G,allowGrowY:!G,allowShrinkY:!G});if(G){this.replaceState(l,o);}else{this.replaceState(o,l);}this.getContentElement().setStyles({overflowX:G?m:h,overflowY:G?h:m});qx.ui.core.queue.Layout.add(this);},_updateScrollBar:function(){var S=this.__nQ;var T=this.getBounds();if(!T){return;}if(this.isEnabled()){var U=S?T.width:T.height;var R=this.getMaximum()+U;}else{R=0;}if(qx.core.Variant.isSet(j,u)){var T=this.getBounds();this.getContentElement().setStyles({left:S?i:k,top:S?k:i,width:(S?T.width:T.width+1)+n,height:(S?T.height+1:T.height)+n});}this._getScrollPaneElement().setStyles({left:0,top:0,width:(S?R:1)+n,height:(S?1:R)+n});this.scrollTo(this.getPosition());},scrollTo:function(d){this.setPosition(Math.max(0,Math.min(this.getMaximum(),d)));},scrollBy:function(H){this.scrollTo(this.getPosition()+H);},scrollBySteps:function(b){var c=this.getSingleStep();this.scrollBy(b*c);},_onScroll:function(e){var W=this.getContentElement();var V=this.__nQ?W.getScrollX():W.getScrollY();this.setPosition(V);},_onAppear:function(e){this.scrollTo(this.getPosition());},_stopPropagation:function(e){e.stopPropagation();}},destruct:function(){this._disposeObjects(B);}});})();(function(){var s="slider",r="horizontal",q="button-begin",p="vertical",o="button-end",n="Integer",m="execute",l="right",k="left",j="down",H="up",G="PositiveNumber",F="changeValue",E="qx.lang.Type.isNumber(value)&&value>=0&&value<=this.getMaximum()",D="_applyKnobFactor",C="knob",B="qx.ui.core.scroll.ScrollBar",A="resize",z="_applyOrientation",y="_applyPageStep",w="PositiveInteger",x="scroll",u="_applyPosition",v="scrollbar",t="_applyMaximum";qx.Class.define(B,{extend:qx.ui.core.Widget,implement:qx.ui.core.scroll.IScrollBar,construct:function(i){qx.ui.core.Widget.call(this);this._createChildControl(q);this._createChildControl(s).addListener(A,this._onResizeSlider,this);this._createChildControl(o);if(i!=null){this.setOrientation(i);}else{this.initOrientation();}},properties:{appearance:{refine:true,init:v},orientation:{check:[r,p],init:r,apply:z},maximum:{check:w,apply:t,init:100},position:{check:E,init:0,apply:u,event:x},singleStep:{check:n,init:20},pageStep:{check:n,init:10,apply:y},knobFactor:{check:G,apply:D,nullable:true}},members:{__nS:2,_createChildControlImpl:function(I){var J;switch(I){case s:J=new qx.ui.core.scroll.ScrollSlider();J.setPageStep(100);J.setFocusable(false);J.addListener(F,this._onChangeSliderValue,this);this._add(J,{flex:1});break;case q:J=new qx.ui.form.RepeatButton();J.setFocusable(false);J.addListener(m,this._onExecuteBegin,this);this._add(J);break;case o:J=new qx.ui.form.RepeatButton();J.setFocusable(false);J.addListener(m,this._onExecuteEnd,this);this._add(J);break;}return J||qx.ui.core.Widget.prototype._createChildControlImpl.call(this,I);},_applyMaximum:function(g){this.getChildControl(s).setMaximum(g);},_applyPosition:function(K){this.getChildControl(s).setValue(K);},_applyKnobFactor:function(a){this.getChildControl(s).setKnobFactor(a);},_applyPageStep:function(O){this.getChildControl(s).setPageStep(O);},_applyOrientation:function(L,M){var N=this._getLayout();if(N){N.dispose();}if(L===r){this._setLayout(new qx.ui.layout.HBox());this.setAllowStretchX(true);this.setAllowStretchY(false);this.replaceState(p,r);this.getChildControl(q).replaceState(H,k);this.getChildControl(o).replaceState(j,l);}else{this._setLayout(new qx.ui.layout.VBox());this.setAllowStretchX(false);this.setAllowStretchY(true);this.replaceState(r,p);this.getChildControl(q).replaceState(k,H);this.getChildControl(o).replaceState(l,j);}this.getChildControl(s).setOrientation(L);},scrollTo:function(R){this.getChildControl(s).slideTo(R);},scrollBy:function(h){this.getChildControl(s).slideBy(h);},scrollBySteps:function(P){var Q=this.getSingleStep();this.getChildControl(s).slideBy(P*Q);},_onExecuteBegin:function(e){this.scrollBy(-this.getSingleStep());},_onExecuteEnd:function(e){this.scrollBy(this.getSingleStep());},_onChangeSliderValue:function(e){this.setPosition(e.getData());},_onResizeSlider:function(e){var b=this.getChildControl(s).getChildControl(C);var f=b.getSizeHint();var c=false;var d=this.getChildControl(s).getInnerSize();if(this.getOrientation()==p){if(d.height<f.minHeight+this.__nS){c=true;}}else{if(d.width<f.minWidth+this.__nS){c=true;}}if(c){b.exclude();}else{b.show();}}}});})();(function(){var b="qx.ui.form.INumberForm",a="qx.event.type.Data";qx.Interface.define(b,{events:{"changeValue":a},members:{setValue:function(c){return arguments.length==1;},resetValue:function(){},getValue:function(){}}});})();(function(){var a="qx.ui.form.IRange";qx.Interface.define(a,{members:{setMinimum:function(b){return arguments.length==1;},getMinimum:function(){},setMaximum:function(e){return arguments.length==1;},getMaximum:function(){},setSingleStep:function(c){return arguments.length==1;},getSingleStep:function(){},setPageStep:function(d){return arguments.length==1;},getPageStep:function(){}}});})();(function(){var k="knob",j="horizontal",i="vertical",h="Integer",g="hovered",f="left",d="top",c="mouseup",b="pressed",a="px",V="changeValue",U="interval",T="mousemove",S="resize",R="slider",Q="mousedown",P="PageUp",O="mouseout",N='qx.event.type.Data',M="Left",r="Down",s="Up",p="dblclick",q="qx.ui.form.Slider",n="PageDown",o="mousewheel",l="_applyValue",m="_applyKnobFactor",t="End",u="height",B="Right",z="width",F="_applyOrientation",D="Home",I="mouseover",H="floor",w="_applyMinimum",L="click",K="typeof value==='number'&&value>=this.getMinimum()&&value<=this.getMaximum()",J="keypress",v="ceil",x="losecapture",y="contextmenu",A="_applyMaximum",C="Number",E="changeMaximum",G="changeMinimum";qx.Class.define(q,{extend:qx.ui.core.Widget,implement:[qx.ui.form.IForm,qx.ui.form.INumberForm,qx.ui.form.IRange],include:[qx.ui.form.MForm],construct:function(bk){qx.ui.core.Widget.call(this);this._setLayout(new qx.ui.layout.Canvas());this.addListener(J,this._onKeyPress);this.addListener(o,this._onMouseWheel);this.addListener(Q,this._onMouseDown);this.addListener(c,this._onMouseUp);this.addListener(x,this._onMouseUp);this.addListener(S,this._onUpdate);this.addListener(y,this._onStopEvent);this.addListener(L,this._onStopEvent);this.addListener(p,this._onStopEvent);if(bk!=null){this.setOrientation(bk);}else{this.initOrientation();}},events:{changeValue:N},properties:{appearance:{refine:true,init:R},focusable:{refine:true,init:true},orientation:{check:[j,i],init:j,apply:F},value:{check:K,init:0,apply:l,nullable:true},minimum:{check:h,init:0,apply:w,event:G},maximum:{check:h,init:100,apply:A,event:E},singleStep:{check:h,init:1},pageStep:{check:h,init:10},knobFactor:{check:C,apply:m,nullable:true}},members:{__nT:null,__nU:null,__nV:null,__nW:null,__nX:null,__nY:null,__oa:null,__ob:null,__oc:null,__od:null,__oe:null,__of:null,_forwardStates:{invalid:true},_createChildControlImpl:function(bD){var bE;switch(bD){case k:bE=new qx.ui.core.Widget();bE.addListener(S,this._onUpdate,this);bE.addListener(I,this._onMouseOver);bE.addListener(O,this._onMouseOut);this._add(bE);break;}return bE||qx.ui.core.Widget.prototype._createChildControlImpl.call(this,bD);},_onMouseOver:function(e){this.addState(g);},_onMouseOut:function(e){this.removeState(g);},_onMouseWheel:function(e){var bH=e.getWheelDelta()>0?1:-1;this.slideBy(bH*this.getSingleStep());e.stop();},_onKeyPress:function(e){var X=this.getOrientation()===j;var W=X?M:s;var forward=X?B:r;switch(e.getKeyIdentifier()){case forward:this.slideForward();break;case W:this.slideBack();break;case n:this.slidePageForward();break;case P:this.slidePageBack();break;case D:this.slideToBegin();break;case t:this.slideToEnd();break;default:return;}e.stop();},_onMouseDown:function(e){if(this.__nW){return;}var bx=this.__oh;var bv=this.getChildControl(k);var bw=bx?f:d;var bz=bx?e.getDocumentLeft():e.getDocumentTop();var bA=this.__nT=qx.bom.element.Location.get(this.getContentElement().getDomElement())[bw];var by=this.__nU=qx.bom.element.Location.get(bv.getContainerElement().getDomElement())[bw];if(e.getTarget()===bv){this.__nW=true;if(!this.__od){this.__od=new qx.event.Timer(100);this.__od.addListener(U,this._fireValue,this);}this.__od.start();this.__nX=bz+bA-by;bv.addState(b);}else{this.__nY=true;this.__oa=bz<=by?-1:1;this.__oi(e);this._onInterval();if(!this.__oc){this.__oc=new qx.event.Timer(100);this.__oc.addListener(U,this._onInterval,this);}this.__oc.start();}this.addListener(T,this._onMouseMove);this.capture();e.stopPropagation();},_onMouseUp:function(e){if(this.__nW){this.releaseCapture();delete this.__nW;this.__od.stop();this._fireValue();delete this.__nX;this.getChildControl(k).removeState(b);if(e.getType()===c){var bX;var bY;var bW;if(this.__oh){bX=e.getDocumentLeft()-(this._valueToPosition(this.getValue())+this.__nT);bW=qx.bom.element.Location.get(this.getContentElement().getDomElement())[d];bY=e.getDocumentTop()-(bW+this.getChildControl(k).getBounds().top);}else{bX=e.getDocumentTop()-(this._valueToPosition(this.getValue())+this.__nT);bW=qx.bom.element.Location.get(this.getContentElement().getDomElement())[f];bY=e.getDocumentLeft()-(bW+this.getChildControl(k).getBounds().left);}if(bY<0||bY>this.__nV||bX<0||bX>this.__nV){this.getChildControl(k).removeState(g);}}}else if(this.__nY){this.__oc.stop();this.releaseCapture();delete this.__nY;delete this.__oa;delete this.__ob;}this.removeListener(T,this._onMouseMove);if(e.getType()===c){e.stopPropagation();}},_onMouseMove:function(e){if(this.__nW){var bi=this.__oh?e.getDocumentLeft():e.getDocumentTop();var bh=bi-this.__nX;this.slideTo(this._positionToValue(bh));}else if(this.__nY){this.__oi(e);}e.stopPropagation();},_onInterval:function(e){var bI=this.getValue()+(this.__oa*this.getPageStep());if(bI<this.getMinimum()){bI=this.getMinimum();}else if(bI>this.getMaximum()){bI=this.getMaximum();}var bJ=this.__oa==-1;if((bJ&&bI<=this.__ob)||(!bJ&&bI>=this.__ob)){bI=this.__ob;}this.slideTo(bI);},_onUpdate:function(e){var cd=this.getInnerSize();var ce=this.getChildControl(k).getBounds();var cc=this.__oh?z:u;this._updateKnobSize();this.__og=cd[cc]-ce[cc];this.__nV=ce[cc];this._updateKnobPosition();},__oh:false,__og:0,__oi:function(e){var bK=this.__oh;var bR=bK?e.getDocumentLeft():e.getDocumentTop();var bT=this.__nT;var bL=this.__nU;var bV=this.__nV;var bS=bR-bT;if(bR>=bL){bS-=bV;}var bP=this._positionToValue(bS);var bM=this.getMinimum();var bN=this.getMaximum();if(bP<bM){bP=bM;}else if(bP>bN){bP=bN;}else{var bQ=this.getValue();var bO=this.getPageStep();var bU=this.__oa<0?H:v;bP=bQ+(Math[bU]((bP-bQ)/bO)*bO);}if(this.__ob==null||(this.__oa==-1&&bP<=this.__ob)||(this.__oa==1&&bP>=this.__ob)){this.__ob=bP;}},_positionToValue:function(bn){var bo=this.__og;if(bo==null||bo==0){return 0;}var bq=bn/bo;if(bq<0){bq=0;}else if(bq>1){bq=1;}var bp=this.getMaximum()-this.getMinimum();return this.getMinimum()+Math.round(bp*bq);},_valueToPosition:function(br){var bs=this.__og;if(bs==null){return 0;}var bt=this.getMaximum()-this.getMinimum();if(bt==0){return 0;}var br=br-this.getMinimum();var bu=br/bt;if(bu<0){bu=0;}else if(bu>1){bu=1;}return Math.round(bs*bu);},_updateKnobPosition:function(){this._setKnobPosition(this._valueToPosition(this.getValue()));},_setKnobPosition:function(ba){var bb=this.getChildControl(k).getContainerElement();if(this.__oh){bb.setStyle(f,ba+a,true);}else{bb.setStyle(d,ba+a,true);}},_updateKnobSize:function(){var bG=this.getKnobFactor();if(bG==null){return;}var bF=this.getInnerSize();if(bF==null){return;}if(this.__oh){this.getChildControl(k).setWidth(Math.round(bG*bF.width));}else{this.getChildControl(k).setHeight(Math.round(bG*bF.height));}},slideToBegin:function(){this.slideTo(this.getMinimum());},slideToEnd:function(){this.slideTo(this.getMaximum());},slideForward:function(){this.slideBy(this.getSingleStep());},slideBack:function(){this.slideBy(-this.getSingleStep());},slidePageForward:function(){this.slideBy(this.getPageStep());},slidePageBack:function(){this.slideBy(-this.getPageStep());},slideBy:function(Y){this.slideTo(this.getValue()+Y);},slideTo:function(bj){if(bj<this.getMinimum()){bj=this.getMinimum();}else if(bj>this.getMaximum()){bj=this.getMaximum();}else{bj=this.getMinimum()+Math.round((bj-this.getMinimum())/this.getSingleStep())*this.getSingleStep();}this.setValue(bj);},_applyOrientation:function(bc,bd){var be=this.getChildControl(k);this.__oh=bc===j;if(this.__oh){this.removeState(i);be.removeState(i);this.addState(j);be.addState(j);be.setLayoutProperties({top:0,right:null,bottom:0});}else{this.removeState(j);be.removeState(j);this.addState(i);be.addState(i);be.setLayoutProperties({right:0,bottom:null,left:0});}this._updateKnobPosition();},_applyKnobFactor:function(bf,bg){if(bf!=null){this._updateKnobSize();}else{if(this.__oh){this.getChildControl(k).resetWidth();}else{this.getChildControl(k).resetHeight();}}},_applyValue:function(bl,bm){if(bl!=null){this._updateKnobPosition();if(this.__nW){this.__of=[bl,bm];}else{this.fireEvent(V,qx.event.type.Data,[bl,bm]);}}else{this.resetValue();}},_fireValue:function(){if(!this.__of){return;}var cf=this.__of;this.__of=null;this.fireEvent(V,qx.event.type.Data,cf);},_applyMinimum:function(bB,bC){if(this.getValue()<bB){this.setValue(bB);}this._updateKnobPosition();},_applyMaximum:function(ca,cb){if(this.getValue()>ca){this.setValue(ca);}this._updateKnobPosition();}}});})();(function(){var d="horizontal",c="mousewheel",b="qx.ui.core.scroll.ScrollSlider",a="keypress";qx.Class.define(b,{extend:qx.ui.form.Slider,construct:function(g){qx.ui.form.Slider.call(this,g);this.removeListener(a,this._onKeyPress);this.removeListener(c,this._onMouseWheel);},members:{getSizeHint:function(e){var f=qx.ui.form.Slider.prototype.getSizeHint.call(this);if(this.getOrientation()===d){f.width=0;}else{f.height=0;}return f;}}});})();(function(){var b="qx.ui.table.pane.Clipper";qx.Class.define(b,{extend:qx.ui.container.Composite,construct:function(){qx.ui.container.Composite.call(this,new qx.ui.layout.Grow());this.setMinWidth(0);},members:{scrollToX:function(a){this.getContentElement().scrollToX(a,false);},scrollToY:function(c){this.getContentElement().scrollToY(c,true);}}});})();(function(){var h="Integer",g="Escape",f="keypress",d="Enter",c="excluded",b="qx.ui.table.pane.FocusIndicator";qx.Class.define(b,{extend:qx.ui.container.Composite,construct:function(a){qx.ui.container.Composite.call(this);this.__oj=a;this.setKeepActive(true);this.addListener(f,this._onKeyPress,this);},properties:{visibility:{refine:true,init:c},row:{check:h,nullable:true},column:{check:h,nullable:true}},members:{__oj:null,_onKeyPress:function(e){var i=e.getKeyIdentifier();if(i!==g&&i!==d){e.stopPropagation();}},moveToCell:function(j,k){if(!this.__oj.getShowCellFocusIndicator()&&!this.__oj.getTable().getTableModel().isColumnEditable(j)){this.exclude();return;}else{this.show();}if(j==null){this.hide();this.setRow(null);this.setColumn(null);}else{var l=this.__oj.getTablePaneModel().getX(j);if(l==-1){this.hide();this.setRow(null);this.setColumn(null);}else{var q=this.__oj.getTable();var o=q.getTableColumnModel();var p=this.__oj.getTablePaneModel();var n=this.__oj.getTablePane().getFirstVisibleRow();var m=q.getRowHeight();this.setUserBounds(p.getColumnLeft(j)-2,(k-n)*m-2,o.getColumnWidth(j)+3,m+3);this.show();this.setRow(k);this.setColumn(j);}}}},destruct:function(){this.__oj=null;}});})();(function(){var b="Integer",a="qx.ui.table.pane.CellEvent";qx.Class.define(a,{extend:qx.event.type.Mouse,properties:{row:{check:b,nullable:true},column:{check:b,nullable:true}},members:{init:function(c,d,e,f){d.clone(this);this.setBubbles(false);if(e!=null){this.setRow(e);}else{this.setRow(c._getRowForPagePos(this.getDocumentLeft(),this.getDocumentTop()));}if(f!=null){this.setColumn(f);}else{this.setColumn(c._getColumnForPageX(this.getDocumentLeft()));}},clone:function(g){var h=qx.event.type.Mouse.prototype.clone.call(this,g);h.set({row:this.getRow(),column:this.getColumn()});return h;}}});})();(function(){var a="qx.lang.Number";qx.Class.define(a,{statics:{isInRange:function(e,f,g){return e>=f&&e<=g;},isBetweenRange:function(b,c,d){return b>c&&b<d;},limit:function(h,i,j){if(j!=null&&h>j){return j;}else if(i!=null&&h<i){return i;}else{return h;}}}});})();(function(){var n="Boolean",m="resize",l="mousedown",k="w-resize",j="sw-resize",i="n-resize",h="resizableRight",g="ne-resize",f="se-resize",d="Integer",C="e-resize",B="resizableLeft",A="mousemove",z="move",y="shorthand",x="maximized",w="nw-resize",v="mouseout",u="qx.ui.core.MResizable",t="mouseup",r="losecapture",s="resize-frame",p="resizableBottom",q="s-resize",o="resizableTop";qx.Mixin.define(u,{construct:function(){this.addListener(l,this.__ow,this,true);this.addListener(t,this.__ox,this);this.addListener(A,this.__oz,this);this.addListener(v,this.__oA,this);this.addListener(r,this.__oy,this);var Y=this.getContainerElement().getDomElement();if(Y==null){Y=window;}this.__ok=qx.event.Registration.getManager(Y).getHandler(qx.event.handler.DragDrop);},properties:{resizableTop:{check:n,init:true},resizableRight:{check:n,init:true},resizableBottom:{check:n,init:true},resizableLeft:{check:n,init:true},resizable:{group:[o,h,p,B],mode:y},resizeSensitivity:{check:d,init:5},useResizeFrame:{check:n,init:true}},members:{__ok:null,__ol:null,__om:null,__on:null,__oo:null,__op:null,__oq:null,RESIZE_TOP:1,RESIZE_BOTTOM:2,RESIZE_LEFT:4,RESIZE_RIGHT:8,__or:function(){var N=this.__ol;if(!N){N=this.__ol=new qx.ui.core.Widget();N.setAppearance(s);N.exclude();qx.core.Init.getApplication().getRoot().add(N);}return N;},__os:function(){var E=this.__op;var D=this.__or();D.setUserBounds(E.left,E.top,E.width,E.height);D.show();D.setZIndex(this.getZIndex()+1);},__ot:function(e){var G=this.__om;var H=this.getSizeHint();var K=this.__oq;var J=this.__op;var F=J.width;var I=J.height;var M=J.left;var top=J.top;var L;if((G&this.RESIZE_TOP)||(G&this.RESIZE_BOTTOM)){L=Math.max(K.top,Math.min(K.bottom,e.getDocumentTop()))-this.__oo;if(G&this.RESIZE_TOP){I-=L;}else{I+=L;}if(I<H.minHeight){I=H.minHeight;}else if(I>H.maxHeight){I=H.maxHeight;}if(G&this.RESIZE_TOP){top+=J.height-I;}}if((G&this.RESIZE_LEFT)||(G&this.RESIZE_RIGHT)){L=Math.max(K.left,Math.min(K.right,e.getDocumentLeft()))-this.__on;if(G&this.RESIZE_LEFT){F-=L;}else{F+=L;}if(F<H.minWidth){F=H.minWidth;}else if(F>H.maxWidth){F=H.maxWidth;}if(G&this.RESIZE_LEFT){M+=J.width-F;}}return {viewportLeft:M,viewportTop:top,parentLeft:J.bounds.left+M-J.left,parentTop:J.bounds.top+top-J.top,width:F,height:I};},__ou:{1:i,2:q,4:k,8:C,5:w,6:j,9:g,10:f},__ov:function(e){var V=this.getContentLocation();var T=this.getResizeSensitivity();var X=e.getDocumentLeft();var W=e.getDocumentTop();var U=0;if(this.getResizableTop()&&Math.abs(V.top-W)<T){U+=this.RESIZE_TOP;}else if(this.getResizableBottom()&&Math.abs(V.bottom-W)<T){U+=this.RESIZE_BOTTOM;}if(this.getResizableLeft()&&Math.abs(V.left-X)<T){U+=this.RESIZE_LEFT;}else if(this.getResizableRight()&&Math.abs(V.right-X)<T){U+=this.RESIZE_RIGHT;}this.__om=U;},__ow:function(e){if(!this.__om){return;}this.addState(m);this.__on=e.getDocumentLeft();this.__oo=e.getDocumentTop();var location=this.getContainerLocation();var c=this.getBounds();this.__op={top:location.top,left:location.left,width:c.width,height:c.height,bounds:qx.lang.Object.clone(c)};var parent=this.getLayoutParent();var a=parent.getContentLocation();var b=parent.getBounds();this.__oq={left:a.left,top:a.top,right:a.left+b.width,bottom:a.top+b.height};if(this.getUseResizeFrame()){this.__os();}this.capture();e.stop();},__ox:function(e){if(!this.hasState(m)){return;}if(this.getUseResizeFrame()){this.__or().exclude();}var ba=this.__ot(e);this.setWidth(ba.width);this.setHeight(ba.height);if(this.getResizableLeft()||this.getResizableTop()){this.setLayoutProperties({left:ba.parentLeft,top:ba.parentTop});}this.__om=0;this.removeState(m);this.resetCursor();this.getApplicationRoot().resetGlobalCursor();this.releaseCapture();e.stopPropagation();},__oy:function(e){if(!this.__om){return;}this.resetCursor();this.getApplicationRoot().resetGlobalCursor();this.removeState(z);if(this.getUseResizeFrame()){this.__or().exclude();}},__oz:function(e){if(this.hasState(m)){var R=this.__ot(e);if(this.getUseResizeFrame()){var P=this.__or();P.setUserBounds(R.viewportLeft,R.viewportTop,R.width,R.height);}else{this.setWidth(R.width);this.setHeight(R.height);if(this.getResizableLeft()||this.getResizableTop()){this.setLayoutProperties({left:R.parentLeft,top:R.parentTop});}}e.stopPropagation();}else if(!this.hasState(x)&&!this.__ok.isSessionActive()){this.__ov(e);var S=this.__om;var Q=this.getApplicationRoot();if(S){var O=this.__ou[S];this.setCursor(O);Q.setGlobalCursor(O);}else if(this.getCursor()){this.resetCursor();Q.resetGlobalCursor();}}},__oA:function(e){if(this.getCursor()&&!this.hasState(m)){this.resetCursor();this.getApplicationRoot().resetGlobalCursor();}}},destruct:function(){if(this.__ol!=null&&!qx.core.ObjectRegistry.inShutDown){this.__ol.destroy();this.__ol=null;}this.__ok=null;}});})();(function(){var s="move",r="Boolean",q="mouseup",p="mousedown",o="losecapture",n="__oC",m="qx.ui.core.MMovable",l="__oB",k="mousemove",j="maximized",i="move-frame";qx.Mixin.define(m,{properties:{movable:{check:r,init:true},useMoveFrame:{check:r,init:false}},members:{__oB:null,__oC:null,__oD:null,__oE:null,__oF:null,__oG:null,__oH:null,__oI:false,__oJ:null,__oK:0,_activateMoveHandle:function(z){if(this.__oB){throw new Error("The move handle could not be redefined!");}this.__oB=z;z.addListener(p,this._onMoveMouseDown,this);z.addListener(q,this._onMoveMouseUp,this);z.addListener(k,this._onMoveMouseMove,this);z.addListener(o,this.__oO,this);},__oL:function(){var u=this.__oC;if(!u){u=this.__oC=new qx.ui.core.Widget();u.setAppearance(i);u.exclude();qx.core.Init.getApplication().getRoot().add(u);}return u;},__oM:function(){var location=this.getContainerLocation();var b=this.getBounds();var a=this.__oL();a.setUserBounds(location.left,location.top,b.width,b.height);a.show();a.setZIndex(this.getZIndex()+1);},__oN:function(e){var d=this.__oD;var h=Math.max(d.left,Math.min(d.right,e.getDocumentLeft()));var g=Math.max(d.top,Math.min(d.bottom,e.getDocumentTop()));var c=this.__oE+h;var f=this.__oF+g;return {viewportLeft:c,viewportTop:f,parentLeft:c-this.__oG,parentTop:f-this.__oH};},_onMoveMouseDown:function(e){if(!this.getMovable()||this.hasState(j)){return;}var parent=this.getLayoutParent();var w=parent.getContentLocation();var x=parent.getBounds();if(qx.Class.implementsInterface(parent,qx.ui.window.IDesktop)){if(!parent.isContentBlocked()){this.__oJ=parent.getBlockerColor();this.__oK=parent.getBlockerOpacity();parent.setBlockerColor(null);parent.setBlockerOpacity(1);parent.blockContent(this.getZIndex()-1);this.__oI=true;}}this.__oD={left:w.left,top:w.top,right:w.left+x.width,bottom:w.top+x.height};var v=this.getContainerLocation();this.__oG=w.left;this.__oH=w.top;this.__oE=v.left-e.getDocumentLeft();this.__oF=v.top-e.getDocumentTop();this.addState(s);this.__oB.capture();if(this.getUseMoveFrame()){this.__oM();}e.stop();},_onMoveMouseMove:function(e){if(!this.hasState(s)){return;}var t=this.__oN(e);if(this.getUseMoveFrame()){this.__oL().setDomPosition(t.viewportLeft,t.viewportTop);}else{this.setDomPosition(t.parentLeft,t.parentTop);}e.stopPropagation();},_onMoveMouseUp:function(e){if(!this.hasState(s)){return;}this.removeState(s);var parent=this.getLayoutParent();if(qx.Class.implementsInterface(parent,qx.ui.window.IDesktop)){if(this.__oI){parent.unblockContent();parent.setBlockerColor(this.__oJ);parent.setBlockerOpacity(this.__oK);this.__oJ=null;this.__oK=0;this.__oI=false;}}this.__oB.releaseCapture();var y=this.__oN(e);this.setLayoutProperties({left:y.parentLeft,top:y.parentTop});if(this.getUseMoveFrame()){this.__oL().exclude();}e.stopPropagation();},__oO:function(e){if(!this.hasState(s)){return;}this.removeState(s);if(this.getUseMoveFrame()){this.__oL().exclude();}}},destruct:function(){this._disposeObjects(n,l);this.__oD=null;}});})();(function(){var p="Integer",o="_applyContentPadding",n="resetPaddingRight",m="setPaddingBottom",l="resetPaddingTop",k="qx.ui.core.MContentPadding",j="resetPaddingLeft",i="setPaddingTop",h="setPaddingRight",g="resetPaddingBottom",c="contentPaddingLeft",f="setPaddingLeft",e="contentPaddingTop",b="shorthand",a="contentPaddingRight",d="contentPaddingBottom";qx.Mixin.define(k,{properties:{contentPaddingTop:{check:p,init:0,apply:o,themeable:true},contentPaddingRight:{check:p,init:0,apply:o,themeable:true},contentPaddingBottom:{check:p,init:0,apply:o,themeable:true},contentPaddingLeft:{check:p,init:0,apply:o,themeable:true},contentPadding:{group:[e,a,d,c],mode:b,themeable:true}},members:{__oP:{contentPaddingTop:i,contentPaddingRight:h,contentPaddingBottom:m,contentPaddingLeft:f},__oQ:{contentPaddingTop:l,contentPaddingRight:n,contentPaddingBottom:g,contentPaddingLeft:j},_applyContentPadding:function(q,r,name){var s=this._getContentPaddingTarget();if(q==null){var t=this.__oQ[name];s[t]();}else{var u=this.__oP[name];s[u](q);}}}});})();(function(){var a="qx.ui.window.IWindowManager";qx.Interface.define(a,{members:{setDesktop:function(f){this.assertInterface(f,qx.ui.window.IDesktop);},changeActiveWindow:function(b,c){},updateStack:function(){},bringToFront:function(d){this.assertInstance(d,qx.ui.window.Window);},sendToBack:function(e){this.assertInstance(e,qx.ui.window.Window);}}});})();(function(){var e="qx.ui.window.Manager",d="__oR";qx.Class.define(e,{extend:qx.core.Object,implement:qx.ui.window.IWindowManager,members:{__oR:null,setDesktop:function(c){this.__oR=c;this.updateStack();},getDesktop:function(){return this.__oR;},changeActiveWindow:function(a,b){if(a){this.bringToFront(a);a.setActive(true);}if(b){b.resetActive();}},_minZIndex:1e5,updateStack:function(){qx.ui.core.queue.Widget.add(this);},syncWidget:function(){this.__oR.forceUnblockContent();var n=this.__oR.getWindows();var p=this._minZIndex;var s=p+n.length*2;var q=p+n.length*4;var r=null;for(var i=0,l=n.length;i<l;i++){var o=n[i];if(!o.isVisible()){continue;}r=r||o;if(o.isModal()){o.setZIndex(q);this.__oR.blockContent(q-1);q+=2;r=o;}else if(o.isAlwaysOnTop()){o.setZIndex(s);s+=2;}else{o.setZIndex(p);p+=2;}if(!r.isModal()&&o.isActive()||o.getZIndex()>r.getZIndex()){r=o;}}this.__oR.setActiveWindow(r);},bringToFront:function(j){var k=this.__oR.getWindows();var m=qx.lang.Array.remove(k,j);if(m){k.push(j);this.updateStack();}},sendToBack:function(f){var g=this.__oR.getWindows();var h=qx.lang.Array.remove(g,f);if(h){g.unshift(f);this.updateStack();}}},destruct:function(){this._disposeObjects(d);}});})();(function(){var G="Boolean",F="qx.event.type.Event",E="captionbar",D="_applyCaptionBarChange",C="maximize-button",B="restore-button",A="minimize-button",z="close-button",y="maximized",x="execute",bn="pane",bm="title",bl="icon",bk="statusbar-text",bj="statusbar",bi="String",bh="normal",bg="active",bf="beforeClose",be="beforeMinimize",N="mousedown",O="changeStatus",L="changeIcon",M="excluded",J="dblclick",K="_applyActive",H="beforeRestore",I="minimize",P="changeModal",Q="changeAlwaysOnTop",V="_applyShowStatusbar",U="_applyStatus",X="qx.ui.window.Window",W="changeCaption",ba="focusout",Y="beforeMaximize",S="maximize",bd="restore",bc="window",bb="close",R="changeActive",T="minimized";qx.Class.define(X,{extend:qx.ui.core.Widget,include:[qx.ui.core.MRemoteChildrenHandling,qx.ui.core.MRemoteLayoutHandling,qx.ui.core.MResizable,qx.ui.core.MMovable,qx.ui.core.MContentPadding],construct:function(bo,bp){qx.ui.core.Widget.call(this);this._setLayout(new qx.ui.layout.VBox());this._createChildControl(E);this._createChildControl(bn);if(bp!=null){this.setIcon(bp);}if(bo!=null){this.setCaption(bo);}this._updateCaptionBar();this.addListener(N,this._onWindowMouseDown,this,true);this.addListener(ba,this._onWindowFocusOut,this);qx.core.Init.getApplication().getRoot().add(this);this.initVisibility();qx.ui.core.FocusHandler.getInstance().addRoot(this);},statics:{DEFAULT_MANAGER_CLASS:qx.ui.window.Manager},events:{"beforeClose":F,"close":F,"beforeMinimize":F,"minimize":F,"beforeMaximize":F,"maximize":F,"beforeRestore":F,"restore":F},properties:{appearance:{refine:true,init:bc},visibility:{refine:true,init:M},focusable:{refine:true,init:true},active:{check:G,init:false,apply:K,event:R},alwaysOnTop:{check:G,init:false,event:Q},modal:{check:G,init:false,event:P},caption:{apply:D,event:W,nullable:true},icon:{check:bi,nullable:true,apply:D,event:L,themeable:true},status:{check:bi,nullable:true,apply:U,event:O},showClose:{check:G,init:true,apply:D,themeable:true},showMaximize:{check:G,init:true,apply:D,themeable:true},showMinimize:{check:G,init:true,apply:D,themeable:true},allowClose:{check:G,init:true,apply:D},allowMaximize:{check:G,init:true,apply:D},allowMinimize:{check:G,init:true,apply:D},showStatusbar:{check:G,init:false,apply:V}},members:{__oS:null,__oT:null,getChildrenContainer:function(){return this.getChildControl(bn);},_forwardStates:{active:true,maximized:true},setLayoutParent:function(parent){{};qx.ui.core.Widget.prototype.setLayoutParent.call(this,parent);},_createChildControlImpl:function(l){var m;switch(l){case bj:m=new qx.ui.container.Composite(new qx.ui.layout.HBox());this._add(m);m.add(this.getChildControl(bk));break;case bk:m=new qx.ui.basic.Label();m.setValue(this.getStatus());break;case bn:m=new qx.ui.container.Composite();this._add(m,{flex:1});break;case E:var o=new qx.ui.layout.Grid();o.setRowFlex(0,1);o.setColumnFlex(1,1);m=new qx.ui.container.Composite(o);this._add(m);m.addListener(J,this._onCaptionMouseDblClick,this);this._activateMoveHandle(m);break;case bl:m=new qx.ui.basic.Image(this.getIcon());this.getChildControl(E).add(m,{row:0,column:0});break;case bm:m=new qx.ui.basic.Label(this.getCaption());m.setWidth(0);m.setAllowGrowX(true);var n=this.getChildControl(E);n.add(m,{row:0,column:1});break;case A:m=new qx.ui.form.Button();m.setFocusable(false);m.addListener(x,this._onMinimizeButtonClick,this);this.getChildControl(E).add(m,{row:0,column:2});break;case B:m=new qx.ui.form.Button();m.setFocusable(false);m.addListener(x,this._onRestoreButtonClick,this);this.getChildControl(E).add(m,{row:0,column:3});break;case C:m=new qx.ui.form.Button();m.setFocusable(false);m.addListener(x,this._onMaximizeButtonClick,this);this.getChildControl(E).add(m,{row:0,column:4});break;case z:m=new qx.ui.form.Button();m.setFocusable(false);m.addListener(x,this._onCloseButtonClick,this);this.getChildControl(E).add(m,{row:0,column:6});break;}return m||qx.ui.core.Widget.prototype._createChildControlImpl.call(this,l);},_updateCaptionBar:function(){var s;var t=this.getIcon();if(t){this.getChildControl(bl).setSource(t);this._showChildControl(bl);}else{this._excludeChildControl(bl);}var r=this.getCaption();if(r){this.getChildControl(bm).setValue(r);this._showChildControl(bm);}else{this._excludeChildControl(bm);}if(this.getShowMinimize()){this._showChildControl(A);s=this.getChildControl(A);this.getAllowMinimize()?s.resetEnabled():s.setEnabled(false);}else{this._excludeChildControl(A);}if(this.getShowMaximize()){if(this.isMaximized()){this._showChildControl(B);this._excludeChildControl(C);}else{this._showChildControl(C);this._excludeChildControl(B);}s=this.getChildControl(C);this.getAllowMaximize()?s.resetEnabled():s.setEnabled(false);}else{this._excludeChildControl(C);this._excludeChildControl(B);}if(this.getShowClose()){this._showChildControl(z);s=this.getChildControl(z);this.getAllowClose()?s.resetEnabled():s.setEnabled(false);}else{this._excludeChildControl(z);}},close:function(){if(!this.isVisible()){return;}if(this.fireNonBubblingEvent(bf,qx.event.type.Event,[false,true])){this.hide();this.fireEvent(bb);}},open:function(){this.show();this.setActive(true);this.focus();},center:function(){var parent=this.getLayoutParent();if(parent){var v=parent.getBounds();if(v){var w=this.getSizeHint();var u=Math.round((v.width-w.width)/2);var top=Math.round((v.height-w.height)/2);if(top<0){top=0;}this.moveTo(u,top);return;}}{};},maximize:function(){if(this.isMaximized()){return;}var parent=this.getLayoutParent();if(parent!=null&&parent.supportsMaximize()){if(this.fireNonBubblingEvent(Y,qx.event.type.Event,[false,true])){if(!this.isVisible()){this.open();}var bq=this.getLayoutProperties();this.__oT=bq.left===undefined?0:bq.left;this.__oS=bq.top===undefined?0:bq.top;this.setLayoutProperties({left:null,top:null,edge:0});this.addState(y);this._updateCaptionBar();this.fireEvent(S);}}},minimize:function(){if(!this.isVisible()){return;}if(this.fireNonBubblingEvent(be,qx.event.type.Event,[false,true])){var g=this.getLayoutProperties();this.__oT=g.left===undefined?0:g.left;this.__oS=g.top===undefined?0:g.top;this.removeState(y);this.hide();this.fireEvent(I);}},restore:function(){if(this.getMode()===bh){return;}if(this.fireNonBubblingEvent(H,qx.event.type.Event,[false,true])){if(!this.isVisible()){this.open();}var br=this.__oT;var top=this.__oS;this.setLayoutProperties({edge:null,left:br,top:top});this.removeState(y);this._updateCaptionBar();this.fireEvent(bd);}},moveTo:function(q,top){if(this.isMaximized()){return;}this.setLayoutProperties({left:q,top:top});},isMaximized:function(){return this.hasState(y);},getMode:function(){if(!this.isVisible()){return T;}else{if(this.isMaximized()){return y;}else{return bh;}}},_applyActive:function(h,i){if(i){this.removeState(bg);}else{this.addState(bg);}},_getContentPaddingTarget:function(){return this.getChildControl(bn);},_applyShowStatusbar:function(j,k){if(j){this._showChildControl(bj);}else{this._excludeChildControl(bj);}},_applyCaptionBarChange:function(d,f){this._updateCaptionBar();},_applyStatus:function(a,b){var c=this.getChildControl(bk,true);if(c){c.setValue(a);}},_onWindowEventStop:function(e){e.stopPropagation();},_onWindowMouseDown:function(e){this.setActive(true);},_onWindowFocusOut:function(e){if(this.getModal()){return;}var p=e.getRelatedTarget();if(p!=null&&!qx.ui.core.Widget.contains(this,p)){this.setActive(false);}},_onCaptionMouseDblClick:function(e){if(this.getAllowMaximize()){this.isMaximized()?this.restore():this.maximize();}},_onMinimizeButtonClick:function(e){this.minimize();this.getChildControl(A).reset();},_onRestoreButtonClick:function(e){this.restore();this.getChildControl(B).reset();},_onMaximizeButtonClick:function(e){this.maximize();this.getChildControl(C).reset();},_onCloseButtonClick:function(e){this.close();this.getChildControl(z).reset();}}});})();(function(){var b="qx.ui.window.IDesktop";qx.Interface.define(b,{members:{setWindowManager:function(a){this.assertInterface(a,qx.ui.window.IWindowManager);},getWindows:function(){},supportsMaximize:function(){},blockContent:function(c){this.assertInteger(c);},unblockContent:function(){},isContentBlocked:function(){}}});})();(function(){var r="headerCellRendererChanged",q="visibilityChangedPre",p="Number",o="qx.event.type.Event",n="_applyFirstColumnX",m="Integer",l="qx.ui.table.pane.Model",k="_applyMaxColumnCount";qx.Class.define(l,{extend:qx.core.Object,construct:function(v){qx.core.Object.call(this);this.setTableColumnModel(v);},events:{"modelChanged":o},statics:{EVENT_TYPE_MODEL_CHANGED:"modelChanged"},properties:{firstColumnX:{check:m,init:0,apply:n},maxColumnCount:{check:p,init:-1,apply:k}},members:{__oU:null,__oV:null,_applyFirstColumnX:function(a,b){this.__oU=null;this.fireEvent(qx.ui.table.pane.Model.EVENT_TYPE_MODEL_CHANGED);},_applyMaxColumnCount:function(E,F){this.__oU=null;this.fireEvent(qx.ui.table.pane.Model.EVENT_TYPE_MODEL_CHANGED);},setTableColumnModel:function(C){if(this.__oV){this.__oV.removeListener(q,this._onColVisibilityChanged,this);this.__oV.removeListener(r,this._onColVisibilityChanged,this);}this.__oV=C;this.__oV.addListener(q,this._onColVisibilityChanged,this);this.__oV.addListener(r,this._onHeaderCellRendererChanged,this);this.__oU=null;},_onColVisibilityChanged:function(D){this.__oU=null;this.fireEvent(qx.ui.table.pane.Model.EVENT_TYPE_MODEL_CHANGED);},_onHeaderCellRendererChanged:function(B){this.fireEvent(qx.ui.table.pane.Model.EVENT_TYPE_MODEL_CHANGED);},getColumnCount:function(){if(this.__oU==null){var h=this.getFirstColumnX();var j=this.getMaxColumnCount();var i=this.__oV.getVisibleColumnCount();if(j==-1||(h+j)>i){this.__oU=i-h;}else{this.__oU=j;}}return this.__oU;},getColumnAtX:function(f){var g=this.getFirstColumnX();return this.__oV.getVisibleColumnAtX(g+f);},getX:function(s){var t=this.getFirstColumnX();var u=this.getMaxColumnCount();var x=this.__oV.getVisibleX(s)-t;if(x>=0&&(u==-1||x<u)){return x;}else{return -1;}},getColumnLeft:function(w){var A=0;var z=this.getColumnCount();for(var x=0;x<z;x++){var y=this.getColumnAtX(x);if(y==w){return A;}A+=this.__oV.getColumnWidth(y);}return -1;},getTotalWidth:function(){var c=0;var d=this.getColumnCount();for(var x=0;x<d;x++){var e=this.getColumnAtX(x);c+=this.__oV.getColumnWidth(e);}return c;}},destruct:function(){if(this.__oV){this.__oV.removeListener(q,this._onColVisibilityChanged,this);this.__oV.removeListener(r,this._onColVisibilityChanged,this);}this.__oV=null;}});})();(function(){var be="dataChanged",bd="metaDataChanged",bc="qx.ui.table.model.Simple",bb="Boolean",ba="sorted";qx.Class.define(bc,{extend:qx.ui.table.model.Abstract,construct:function(){qx.ui.table.model.Abstract.call(this);this.__oW=[];this.__oX=-1;this.__oY=[];this.__pa=null;},properties:{caseSensitiveSorting:{check:bb,init:true}},statics:{_defaultSortComparatorAscending:function(r,s){var t=r[arguments.callee.columnIndex];var u=s[arguments.callee.columnIndex];if(qx.lang.Type.isNumber(t)&&qx.lang.Type.isNumber(u)){var v=isNaN(t)?isNaN(u)?0:1:isNaN(u)?-1:null;if(v!=null){return v;}}return (t>u)?1:((t==u)?0:-1);},_defaultSortComparatorInsensitiveAscending:function(bf,bg){var bh=(bf[arguments.callee.columnIndex].toLowerCase?bf[arguments.callee.columnIndex].toLowerCase():bf[arguments.callee.columnIndex]);var bi=(bg[arguments.callee.columnIndex].toLowerCase?bg[arguments.callee.columnIndex].toLowerCase():bg[arguments.callee.columnIndex]);if(qx.lang.Type.isNumber(bh)&&qx.lang.Type.isNumber(bi)){var bj=isNaN(bh)?isNaN(bi)?0:1:isNaN(bi)?-1:null;if(bj!=null){return bj;}}return (bh>bi)?1:((bh==bi)?0:-1);},_defaultSortComparatorDescending:function(m,n){var o=m[arguments.callee.columnIndex];var p=n[arguments.callee.columnIndex];if(qx.lang.Type.isNumber(o)&&qx.lang.Type.isNumber(p)){var q=isNaN(o)?isNaN(p)?0:1:isNaN(p)?-1:null;if(q!=null){return q;}}return (o<p)?1:((o==p)?0:-1);},_defaultSortComparatorInsensitiveDescending:function(e,f){var g=(e[arguments.callee.columnIndex].toLowerCase?e[arguments.callee.columnIndex].toLowerCase():e[arguments.callee.columnIndex]);var h=(f[arguments.callee.columnIndex].toLowerCase?f[arguments.callee.columnIndex].toLowerCase():f[arguments.callee.columnIndex]);if(qx.lang.Type.isNumber(g)&&qx.lang.Type.isNumber(h)){var k=isNaN(g)?isNaN(h)?0:1:isNaN(h)?-1:null;if(k!=null){return k;}}return (g<h)?1:((g==h)?0:-1);}},members:{__oW:null,__pa:null,__pb:null,__oY:null,__oX:null,__pc:null,getRowData:function(bs){var bt=this.__oW[bs];if(bt==null||bt.originalData==null){return bt;}else{return bt.originalData;}},getRowDataAsMap:function(bA){var bC=this.__oW[bA];if(bC!=null){var bB={};for(var bD=0;bD<this.getColumnCount();bD++){bB[this.getColumnId(bD)]=bC[bD];}if(bC.originalData!=null){for(var bE in bC.originalData){if(bB[bE]==undefined){bB[bE]=bC.originalData[bE];}}}return bB;}return (bC&&bC.originalData)?bC.originalData:null;},getDataAsMapArray:function(){var b=this.getRowCount();var a=[];for(var i=0;i<b;i++){a.push(this.getRowDataAsMap(i));}return a;},setEditable:function(N){this.__pa=[];for(var O=0;O<this.getColumnCount();O++){this.__pa[O]=N;}this.fireEvent(bd);},setColumnEditable:function(bk,bl){if(bl!=this.isColumnEditable(bk)){if(this.__pa==null){this.__pa=[];}this.__pa[bk]=bl;this.fireEvent(bd);}},isColumnEditable:function(w){return this.__pa?(this.__pa[w]==true):false;},setColumnSortable:function(bL,bM){if(bM!=this.isColumnSortable(bL)){if(this.__pb==null){this.__pb=[];}this.__pb[bL]=bM;this.fireEvent(bd);}},isColumnSortable:function(U){return (this.__pb?(this.__pb[U]!==false):true);},sortByColumn:function(P,Q){var T;var S=this.__oY[P];if(S){T=(Q?S.ascending:S.descending);}else{if(this.getCaseSensitiveSorting()){T=(Q?qx.ui.table.model.Simple._defaultSortComparatorAscending:qx.ui.table.model.Simple._defaultSortComparatorDescending);}else{T=(Q?qx.ui.table.model.Simple._defaultSortComparatorInsensitiveAscending:qx.ui.table.model.Simple._defaultSortComparatorInsensitiveDescending);}}T.columnIndex=P;this.__oW.sort(T);this.__oX=P;this.__pc=Q;var R={columnIndex:P,ascending:Q};this.fireDataEvent(ba,R);this.fireEvent(bd);},setSortMethods:function(bN,bO){var bP;if(qx.lang.Type.isFunction(bO)){bP={ascending:bO,descending:function(by,bz){return bO(bz,by);}};}else{bP=bO;}this.__oY[bN]=bP;},getSortMethods:function(l){return this.__oY[l];},clearSorting:function(){if(this.__oX!=-1){this.__oX=-1;this.__pc=true;this.fireEvent(bd);}},getSortColumnIndex:function(){return this.__oX;},isSortAscending:function(){return this.__pc;},getRowCount:function(){return this.__oW.length;},getValue:function(c,d){if(d<0||d>=this.__oW.length){throw new Error("this.__rowArr out of bounds: "+d+" (0.."+this.__oW.length+")");}return this.__oW[d][c];},setValue:function(B,C,D){if(this.__oW[C][B]!=D){this.__oW[C][B]=D;if(this.hasListener(be)){var E={firstRow:C,lastRow:C,firstColumn:B,lastColumn:B};this.fireDataEvent(be,E);}if(B==this.__oX){this.clearSorting();}}},setData:function(bp,bq){this.__oW=bp;if(this.hasListener(be)){var br={firstRow:0,lastRow:bp.length-1,firstColumn:0,lastColumn:this.getColumnCount()-1};this.fireDataEvent(be,br);}if(bq!==false){this.clearSorting();}},getData:function(){return this.__oW;},setDataAsMapArray:function(bm,bn,bo){this.setData(this._mapArray2RowArr(bm,bn),bo);},addRows:function(J,K,L){if(K==null){K=this.__oW.length;}J.splice(0,0,K,0);Array.prototype.splice.apply(this.__oW,J);var M={firstRow:K,lastRow:this.__oW.length-1,firstColumn:0,lastColumn:this.getColumnCount()-1};this.fireDataEvent(be,M);if(L!==false){this.clearSorting();}},addRowsAsMapArray:function(F,G,H,I){this.addRows(this._mapArray2RowArr(F,H),G,I);},setRows:function(x,y,z){if(y==null){y=0;}x.splice(0,0,y,x.length);Array.prototype.splice.apply(this.__oW,x);var A={firstRow:y,lastRow:this.__oW.length-1,firstColumn:0,lastColumn:this.getColumnCount()-1};this.fireDataEvent(be,A);if(z!==false){this.clearSorting();}},setRowsAsMapArray:function(V,W,X,Y){this.setRows(this._mapArray2RowArr(V,X),W,Y);},removeRows:function(bu,bv,bw){this.__oW.splice(bu,bv);var bx={firstRow:bu,lastRow:this.__oW.length-1,firstColumn:0,lastColumn:this.getColumnCount()-1,removeStart:bu,removeCount:bv};this.fireDataEvent(be,bx);if(bw!==false){this.clearSorting();}},_mapArray2RowArr:function(bF,bG){var bK=bF.length;var bH=this.getColumnCount();var bJ=new Array(bK);var bI;for(var i=0;i<bK;++i){bI=[];if(bG){bI.originalData=bF[i];}for(var j=0;j<bH;++j){bI[j]=bF[i][this.getColumnId(j)];}bJ[i]=bI;}return bJ;}},destruct:function(){this.__oW=this.__pa=this.__oY=this.__pb=null;}});})();(function(){var bQ="",bP="!",bO="'!",bN="'",bM="Expected '",bL="' (rgb(",bK=",",bJ=")), but found value '",bI="Event (",bH="Expected value to be the CSS color '",cX="' but found ",cW="The value '",cV=" != ",cU="qx.core.Object",cT="Expected value to be an array but found ",cS=") was fired.",cR="Expected value to be an integer >= 0 but found ",cQ="' to be not equal with '",cP="' to '",cO="qx.ui.core.Widget",bX="Called assertTrue with '",bY="Expected value to be a map but found ",bV="The function did not raise an exception!",bW="Expected value to be undefined but found ",bT="Expected value to be a DOM element but found  '",bU="Expected value to be a regular expression but found ",bR="' to implement the interface '",bS="Expected value to be null but found ",cg="Invalid argument 'type'",ch="Called assert with 'false'",ct="Assertion error! ",cp="Expected value to be a string but found ",cB="null",cw="' but found '",cK="' must must be a key of the map '",cG="The String '",cl="Expected value not to be undefined but found ",cN="qx.util.ColorUtil",cM=": ",cL="The raised exception does not have the expected type! ",ck=") not fired.",cn="qx.core.Assert",co="Expected value to be typeof object but found ",cr="' (identical) but found '",cu="' must have any of the values defined in the array '",cx="Expected value to be a number but found ",cD="Called assertFalse with '",cI="]",ca="Expected value to be a qooxdoo object but found ",cb="' arguments.",cm="Expected value not to be null but found ",cA="Array[",cz="' does not match the regular expression '",cy="' to be not identical with '",cF="' arguments but found '",cE="', which cannot be converted to a CSS color!",cv="Expected object '",cC="qx.core.AssertionError",bE="Expected value to be a boolean but found ",cH="))!",cc="Expected value to be a qooxdoo widget but found ",cd="Expected value '%1' to be in the range '%2'..'%3'!",cq="Expected value to be typeof '",bF="Expected value to be typeof function but found ",bG="Expected value to be an integer but found ",cj="Called fail().",ce="The parameter 're' must be a string or a regular expression.",cf="Expected value to be a number >= 0 but found ",ci="Expected value to be instanceof '",cs="Wrong number of arguments given. Expected '",cJ="object";qx.Class.define(cn,{statics:{__pd:true,__pe:function(x,y){var z=bQ;for(var i=1,l=arguments.length;i<l;i++){z=z+this.__pf(arguments[i]);}var B=ct+x+cM+z;if(this.__pd){qx.Bootstrap.error(B);}if(qx.Class.isDefined(cC)){var A=new qx.core.AssertionError(x,z);if(this.__pd){qx.Bootstrap.error("Stack trace: \n"+A.getStackTrace());}throw A;}else{throw new Error(B);}},__pf:function(dw){var dx;if(dw===null){dx=cB;}else if(qx.lang.Type.isArray(dw)&&dw.length>10){dx=cA+dw.length+cI;}else if((dw instanceof Object)&&(dw.toString==null)){dx=qx.lang.Json.stringify(dw,null,2);}else{try{dx=dw.toString();}catch(e){dx=bQ;}}return dx;},assert:function(U,V){U==true||this.__pe(V||bQ,ch);},fail:function(J){this.__pe(J||bQ,cj);},assertTrue:function(H,I){(H===true)||this.__pe(I||bQ,bX,H,bN);},assertFalse:function(bp,bq){(bp===false)||this.__pe(bq||bQ,cD,bp,bN);},assertEquals:function(C,D,E){C==D||this.__pe(E||bQ,bM,C,cw,D,bO);},assertNotEquals:function(dg,dh,di){dg!=dh||this.__pe(di||bQ,bM,dg,cQ,dh,bO);},assertIdentical:function(by,bz,bA){by===bz||this.__pe(bA||bQ,bM,by,cr,bz,bO);},assertNotIdentical:function(dI,dJ,dK){dI!==dJ||this.__pe(dK||bQ,bM,dI,cy,dJ,bO);},assertNotUndefined:function(dW,dX){dW!==undefined||this.__pe(dX||bQ,cl,dW,bP);},assertUndefined:function(bk,bl){bk===undefined||this.__pe(bl||bQ,bW,bk,bP);},assertNotNull:function(F,G){F!==null||this.__pe(G||bQ,cm,F,bP);},assertNull:function(m,n){m===null||this.__pe(n||bQ,bS,m,bP);},assertJsonEquals:function(dj,dk,dl){this.assertEquals(qx.lang.Json.stringify(dj),qx.lang.Json.stringify(dk),dl);},assertMatch:function(P,Q,R){this.assertString(P);this.assert(qx.lang.Type.isRegExp(Q)||qx.lang.Type.isString(Q),ce);P.search(Q)>=0||this.__pe(R||bQ,cG,P,cz,Q.toString(),bO);},assertArgumentsCount:function(dR,dS,dT,dU){var dV=dR.length;(dV>=dS&&dV<=dT)||this.__pe(dU||bQ,cs,dS,cP,dT,cF,arguments.length,cb);},assertEventFired:function(cY,event,da,db,dc){var de=false;var dd=function(e){if(db){db.call(cY,e);}de=true;};var df=cY.addListener(event,dd,cY);da.call();de===true||this.__pe(dc||bQ,bI,event,ck);cY.removeListenerById(df);},assertEventNotFired:function(W,event,X,Y){var bb=false;var ba=function(e){bb=true;};var bc=W.addListener(event,ba,W);X.call();bb===false||this.__pe(Y||bQ,bI,event,cS);W.removeListenerById(bc);},assertException:function(K,L,M,N){var L=L||Error;var O;try{this.__pd=false;K();}catch(bm){O=bm;}finally{this.__pd=true;}if(O==null){this.__pe(N||bQ,bV);}O instanceof L||this.__pe(N||bQ,cL,L,cV,O);if(M){this.assertMatch(O.toString(),M,N);}},assertInArray:function(bB,bC,bD){bC.indexOf(bB)!==-1||this.__pe(bD||bQ,cW,bB,cu,bC,bN);},assertArrayEquals:function(dn,dp,dq){this.assertArray(dn,dq);this.assertArray(dp,dq);this.assertEquals(dn.length,dp.length,dq);for(var i=0;i<dn.length;i++){this.assertIdentical(dn[i],dp[i],dq);}},assertKeyInMap:function(bf,bg,bh){bg[bf]!==undefined||this.__pe(bh||bQ,cW,bf,cK,bg,bN);},assertFunction:function(dL,dM){qx.lang.Type.isFunction(dL)||this.__pe(dM||bQ,bF,dL,bP);},assertString:function(dA,dB){qx.lang.Type.isString(dA)||this.__pe(dB||bQ,cp,dA,bP);},assertBoolean:function(dE,dF){qx.lang.Type.isBoolean(dE)||this.__pe(dF||bQ,bE,dE,bP);},assertNumber:function(S,T){(qx.lang.Type.isNumber(S)&&isFinite(S))||this.__pe(T||bQ,cx,S,bP);},assertPositiveNumber:function(dC,dD){(qx.lang.Type.isNumber(dC)&&isFinite(dC)&&dC>=0)||this.__pe(dD||bQ,cf,dC,bP);},assertInteger:function(bd,be){(qx.lang.Type.isNumber(bd)&&isFinite(bd)&&bd%1===0)||this.__pe(be||bQ,bG,bd,bP);},assertPositiveInteger:function(dr,ds){var dt=(qx.lang.Type.isNumber(dr)&&isFinite(dr)&&dr%1===0&&dr>=0);dt||this.__pe(ds||bQ,cR,dr,bP);},assertInRange:function(bu,bv,bw,bx){(bu>=bv&&bu<=bw)||this.__pe(bx||bQ,qx.lang.String.format(cd,[bu,bv,bw]));},assertObject:function(a,b){var c=a!==null&&(qx.lang.Type.isObject(a)||typeof a===cJ);c||this.__pe(b||bQ,co,(a),bP);},assertArray:function(du,dv){qx.lang.Type.isArray(du)||this.__pe(dv||bQ,cT,du,bP);},assertMap:function(bn,bo){qx.lang.Type.isObject(bn)||this.__pe(bo||bQ,bY,bn,bP);},assertRegExp:function(dy,dz){qx.lang.Type.isRegExp(dy)||this.__pe(dz||bQ,bU,dy,bP);},assertType:function(br,bs,bt){this.assertString(bs,cg);typeof (br)===bs||this.__pe(bt||bQ,cq,bs,cX,br,bP);},assertInstance:function(dN,dO,dP){var dQ=dO.classname||dO+bQ;dN instanceof dO||this.__pe(dP||bQ,ci,dQ,cX,dN,bP);},assertInterface:function(h,j,k){qx.Class.implementsInterface(h,j)||this.__pe(k||bQ,cv,h,bR,j,bO);},assertCssColor:function(q,r,s){var t=qx.Class.getByName(cN);if(!t){throw new Error("qx.util.ColorUtil not available! Your code must have a dependency on 'qx.util.ColorUtil'");}var v=t.stringToRgb(q);try{var u=t.stringToRgb(r);}catch(dm){this.__pe(s||bQ,bH,q,bL,v.join(bK),bJ,r,cE);}var w=v[0]==u[0]&&v[1]==u[1]&&v[2]==u[2];w||this.__pe(s||bQ,bH,v,bL,v.join(bK),bJ,r,bL,u.join(bK),cH);},assertElement:function(bi,bj){!!(bi&&bi.nodeType===1)||this.__pe(bj||bQ,bT,bi,bO);},assertQxObject:function(o,p){this.__pg(o,cU)||this.__pe(p||bQ,ca,o,bP);},assertQxWidget:function(dG,dH){this.__pg(dG,cO)||this.__pe(dH||bQ,cc,dG,bP);},__pg:function(d,f){if(!d){return false;}var g=d.constructor;while(g){if(g.classname===f){return true;}g=g.superclass;}return false;}}});})();(function(){var s='',r='"',q=':',p=']',o='null',m=': ',l='object',h='function',g=',',f='\n',bd='\\u',bc=',\n',bb='0000',ba='string',Y="Cannot stringify a recursive object.",X='0',W='-',V='}',U='String',T='Boolean',A='\\\\',B='\\f',y='\\t',z='{\n',w='[]',x="qx.lang.JsonImpl",t='Z',u='\\n',C='Object',D='{}',K='@',I='.',N='(',M='Array',P='T',O='\\r',F='{',S='JSON.parse',R=' ',Q='[',E='Number',G=')',H='[\n',J='\\"',L='\\b';qx.Class.define(x,{extend:Object,construct:function(){this.stringify=qx.lang.Function.bind(this.stringify,this);this.parse=qx.lang.Function.bind(this.parse,this);},members:{__ph:null,__pi:null,__pj:null,__pk:null,stringify:function(b,d,e){this.__ph=s;this.__pi=s;this.__pk=[];if(qx.lang.Type.isNumber(e)){var e=Math.min(10,Math.floor(e));for(var i=0;i<e;i+=1){this.__pi+=R;}}else if(qx.lang.Type.isString(e)){if(e.length>10){e=e.slice(0,10);}this.__pi=e;}if(d&&(qx.lang.Type.isFunction(d)||qx.lang.Type.isArray(d))){this.__pj=d;}else{this.__pj=null;}return this.__pl(s,{'':b});},__pl:function(bi,bj){var bm=this.__ph,bk,bn=bj[bi];if(bn&&qx.lang.Type.isFunction(bn.toJSON)){bn=bn.toJSON(bi);}else if(qx.lang.Type.isDate(bn)){bn=this.dateToJSON(bn);}if(typeof this.__pj===h){bn=this.__pj.call(bj,bi,bn);}if(bn===null){return o;}if(bn===undefined){return undefined;}switch(qx.lang.Type.getClass(bn)){case U:return this.__pm(bn);case E:return isFinite(bn)?String(bn):o;case T:return String(bn);case M:this.__ph+=this.__pi;bk=[];if(this.__pk.indexOf(bn)!==-1){throw new TypeError(Y);}this.__pk.push(bn);var length=bn.length;for(var i=0;i<length;i+=1){bk[i]=this.__pl(i,bn)||o;}this.__pk.pop();if(bk.length===0){var bl=w;}else if(this.__ph){bl=H+this.__ph+bk.join(bc+this.__ph)+f+bm+p;}else{bl=Q+bk.join(g)+p;}this.__ph=bm;return bl;case C:this.__ph+=this.__pi;bk=[];if(this.__pk.indexOf(bn)!==-1){throw new TypeError(Y);}this.__pk.push(bn);if(this.__pj&&typeof this.__pj===l){var length=this.__pj.length;for(var i=0;i<length;i+=1){var k=this.__pj[i];if(typeof k===ba){var v=this.__pl(k,bn);if(v){bk.push(this.__pm(k)+(this.__ph?m:q)+v);}}}}else{for(var k in bn){if(Object.hasOwnProperty.call(bn,k)){var v=this.__pl(k,bn);if(v){bk.push(this.__pm(k)+(this.__ph?m:q)+v);}}}}this.__pk.pop();if(bk.length===0){var bl=D;}else if(this.__ph){bl=z+this.__ph+bk.join(bc+this.__ph)+f+bm+V;}else{bl=F+bk.join(g)+V;}this.__ph=bm;return bl;}},dateToJSON:function(bv){var bw=function(n){return n<10?X+n:n;};var bx=function(n){var bo=bw(n);return n<100?X+bo:bo;};return isFinite(bv.valueOf())?bv.getUTCFullYear()+W+bw(bv.getUTCMonth()+1)+W+bw(bv.getUTCDate())+P+bw(bv.getUTCHours())+q+bw(bv.getUTCMinutes())+q+bw(bv.getUTCSeconds())+I+bx(bv.getUTCMilliseconds())+t:null;},__pm:function(bs){var bt={'\b':L,'\t':y,'\n':u,'\f':B,'\r':O,'"':J,'\\':A};var bu=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;bu.lastIndex=0;if(bu.test(bs)){return r+bs.replace(bu,function(a){var c=bt[a];return typeof c===ba?c:bd+(bb+a.charCodeAt(0).toString(16)).slice(-4);})+r;}else{return r+bs+r;}},parse:function(bp,bq){var br=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;br.lastIndex=0;if(br.test(bp)){bp=bp.replace(br,function(a){return bd+(bb+a.charCodeAt(0).toString(16)).slice(-4);});}if(/^[\],:{}\s]*$/.test(bp.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,K).replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,p).replace(/(?:^|:|,)(?:\s*\[)+/g,s))){var j=eval(N+bp+G);return typeof bq===h?this.__pn({'':j},s,bq):j;}throw new SyntaxError(S);},__pn:function(be,bf,bg){var bh=be[bf];if(bh&&typeof bh===l){for(var k in bh){if(Object.hasOwnProperty.call(bh,k)){var v=this.__pn(bh,k,bg);if(v!==undefined){bh[k]=v;}else{delete bh[k];}}}}return bg.call(be,bf,bh);}}});})();(function(){var b="qx.lang.Json";qx.Class.define(b,{statics:{JSON:(qx.lang.Type.getClass(window.JSON)=="JSON"&&JSON.parse('{"x":1}').x===1)?window.JSON:new qx.lang.JsonImpl(),stringify:null,parse:null},defer:function(a){a.stringify=a.JSON.stringify;a.parse=a.JSON.parse;}});})();(function(){var x="other",w="widgets",v="fonts",u="appearances",t="qx.Theme",s="]",r="[Theme ",q="colors",p="decorations",o="Theme",k="meta",n="borders",m="icons";qx.Bootstrap.define(t,{statics:{define:function(name,P){if(!P){var P={};}P.include=this.__po(P.include);P.patch=this.__po(P.patch);{};var Q={$$type:o,name:name,title:P.title,toString:this.genericToString};if(P.extend){Q.supertheme=P.extend;}Q.basename=qx.Bootstrap.createNamespace(name,Q);this.__pr(Q,P);this.__pp(Q,P);this.$$registry[name]=Q;for(var i=0,a=P.include,l=a.length;i<l;i++){this.include(Q,a[i]);}for(var i=0,a=P.patch,l=a.length;i<l;i++){this.patch(Q,a[i]);}},__po:function(b){if(!b){return [];}if(qx.Bootstrap.isArray(b)){return b;}else{return [b];}},__pp:function(y,z){var A=z.aliases||{};if(z.extend&&z.extend.aliases){qx.Bootstrap.objectMergeWith(A,z.extend.aliases,false);}y.aliases=A;},getAll:function(){return this.$$registry;},getByName:function(name){return this.$$registry[name];},isDefined:function(name){return this.getByName(name)!==undefined;},getTotalNumber:function(){return qx.Bootstrap.objectGetLength(this.$$registry);},genericToString:function(){return r+this.name+s;},__pq:function(B){for(var i=0,C=this.__ps,l=C.length;i<l;i++){if(B[C[i]]){return C[i];}}},__pr:function(c,d){var g=this.__pq(d);if(d.extend&&!g){g=d.extend.type;}c.type=g||x;if(!g){return;}var j=function(){};if(d.extend){j.prototype=new d.extend.$$clazz;}var h=j.prototype;var f=d[g];for(var e in f){h[e]=f[e];if(h[e].base){{};h[e].base=d.extend;}}c.$$clazz=j;c[g]=new j;},$$registry:{},__ps:[q,n,p,v,m,w,u,k],__pt:null,__pu:null,__pv:function(){},patch:function(D,E){var G=this.__pq(E);if(G!==this.__pq(D)){throw new Error("The mixins '"+D.name+"' are not compatible '"+E.name+"'!");}var F=E[G];var H=D.$$clazz.prototype;for(var I in F){H[I]=F[I];}},include:function(J,K){var M=K.type;if(M!==J.type){throw new Error("The mixins '"+J.name+"' are not compatible '"+K.name+"'!");}var L=K[M];var N=J.$$clazz.prototype;for(var O in L){if(N[O]!==undefined){continue;}N[O]=L[O];}}}});})();(function(){var j="#CCCCCC",i="#F3F3F3",h="#E4E4E4",g="#1a1a1a",f="#084FAB",e="gray",d="#fffefe",c="white",b="#4a4a4a",a="#EEEEEE",K="#80B4EF",J="#C72B2B",I="#ffffdd",H="#334866",G="#00204D",F="#666666",E="#CBC8CD",D="#99C3FE",C="#808080",B="#F4F4F4",q="#001533",r="#909090",o="#FCFCFC",p="#314a6e",m="#B6B6B6",n="#0880EF",k="#4d4d4d",l="#DFDFDF",s="#000000",t="#FF9999",w="#7B7A7E",v="#26364D",y="#990000",x="#AFAFAF",A="#404955",z="#AAAAAA",u="qx.theme.modern.Color";qx.Theme.define(u,{colors:{"background-application":l,"background-pane":i,"background-light":o,"background-medium":a,"background-splitpane":x,"background-tip":I,"background-tip-error":J,"background-odd":h,"text-light":r,"text-gray":b,"text-label":g,"text-title":p,"text-input":s,"text-hovered":q,"text-disabled":w,"text-selected":d,"text-active":v,"text-inactive":A,"text-placeholder":E,"border-main":k,"border-separator":C,"border-input":H,"border-disabled":m,"border-pane":G,"border-button":F,"border-column":j,"border-focused":D,"invalid":y,"border-focused-invalid":t,"table-pane":i,"table-focus-indicator":n,"table-row-background-focused-selected":f,"table-row-background-focused":K,"table-row-background-selected":f,"table-row-background-even":i,"table-row-background-odd":h,"table-row-selected":d,"table-row":g,"table-row-line":j,"table-column-line":j,"progressive-table-header":z,"progressive-table-row-background-even":B,"progressive-table-row-background-odd":h,"progressive-progressbar-background":e,"progressive-progressbar-indicator-done":j,"progressive-progressbar-indicator-undone":c,"progressive-progressbar-percent-background":e,"progressive-progressbar-percent-text":c}});})();(function(){var i="Number",h="_applyInsets",g="abstract",f="insetRight",e="insetTop",d="insetBottom",c="qx.ui.decoration.Abstract",b="shorthand",a="insetLeft";qx.Class.define(c,{extend:qx.core.Object,implement:[qx.ui.decoration.IDecorator],type:g,properties:{insetLeft:{check:i,nullable:true,apply:h},insetRight:{check:i,nullable:true,apply:h},insetBottom:{check:i,nullable:true,apply:h},insetTop:{check:i,nullable:true,apply:h},insets:{group:[e,f,d,a],mode:b}},members:{__pw:null,_getDefaultInsets:function(){throw new Error("Abstract method called.");},_isInitialized:function(){throw new Error("Abstract method called.");},_resetInsets:function(){this.__pw=null;},getInsets:function(){if(this.__pw){return this.__pw;}var j=this._getDefaultInsets();return this.__pw={left:this.getInsetLeft()==null?j.left:this.getInsetLeft(),right:this.getInsetRight()==null?j.right:this.getInsetRight(),bottom:this.getInsetBottom()==null?j.bottom:this.getInsetBottom(),top:this.getInsetTop()==null?j.top:this.getInsetTop()};},_applyInsets:function(){{};this.__pw=null;}},destruct:function(){this.__pw=null;}});})();(function(){var q="_applyBackground",p="repeat",o="mshtml",n="backgroundPositionX",m="",l="backgroundPositionY",k="no-repeat",j="scale",i=" ",h="repeat-x",c="qx.client",g="repeat-y",f="hidden",b="qx.ui.decoration.MBackgroundImage",a="String",e='"></div>',d='<div style="';qx.Mixin.define(b,{properties:{backgroundImage:{check:a,nullable:true,apply:q},backgroundRepeat:{check:[p,h,g,k,j],init:p,apply:q},backgroundPositionX:{nullable:true,apply:q},backgroundPositionY:{nullable:true,apply:q},backgroundPosition:{group:[l,n]}},members:{_generateBackgroundMarkup:function(r){var v=m;var u=this.getBackgroundImage();var t=this.getBackgroundRepeat();var top=this.getBackgroundPositionY();if(top==null){top=0;}var w=this.getBackgroundPositionX();if(w==null){w=0;}r.backgroundPosition=w+i+top;if(u){var s=qx.util.AliasManager.getInstance().resolve(u);v=qx.bom.element.Decoration.create(s,t,r);}else{if(r){if(qx.core.Variant.isSet(c,o)){if(qx.bom.client.Engine.VERSION<7||qx.bom.client.Feature.QUIRKS_MODE){r.overflow=f;}}v=d+qx.bom.element.Style.compile(r)+e;}}return v;},_applyBackground:function(){{};}}});})();(function(){var r="_applyStyle",q="",p="Color",o="px",n="solid",m="dotted",l="double",k="dashed",j="_applyWidth",i="qx.ui.decoration.Uniform",f="px ",h=" ",g="scale",e="PositiveInteger",d="absolute";qx.Class.define(i,{extend:qx.ui.decoration.Abstract,include:[qx.ui.decoration.MBackgroundImage],construct:function(a,b,c){qx.ui.decoration.Abstract.call(this);if(a!=null){this.setWidth(a);}if(b!=null){this.setStyle(b);}if(c!=null){this.setColor(c);}},properties:{width:{check:e,init:0,apply:j},style:{nullable:true,check:[n,m,k,l],init:n,apply:r},color:{nullable:true,check:p,apply:r},backgroundColor:{check:p,nullable:true,apply:r}},members:{__px:null,_getDefaultInsets:function(){var w=this.getWidth();return {top:w,right:w,bottom:w,left:w};},_isInitialized:function(){return !!this.__px;},getMarkup:function(){if(this.__px){return this.__px;}var s={position:d,top:0,left:0};var t=this.getWidth();{};var v=qx.theme.manager.Color.getInstance();s.border=t+f+this.getStyle()+h+(v.resolve(this.getColor())||q);var u=this._generateBackgroundMarkup(s);return this.__px=u;},resize:function(A,B,C){var E=this.getBackgroundImage()&&this.getBackgroundRepeat()==g;if(E||qx.bom.client.Feature.CONTENT_BOX){var D=this.getWidth()*2;B-=D;C-=D;if(B<0){B=0;}if(C<0){C=0;}}A.style.width=B+o;A.style.height=C+o;},tint:function(x,y){var z=qx.theme.manager.Color.getInstance();if(y==null){y=this.getBackgroundColor();}x.style.backgroundColor=z.resolve(y)||q;},_applyWidth:function(){{};this._resetInsets();},_applyStyle:function(){{};}},destruct:function(){this.__px=null;}});})();(function(){var m="px",l="qx.ui.decoration.Background",k="",j="_applyStyle",i="Color",h="absolute";qx.Class.define(l,{extend:qx.ui.decoration.Abstract,include:[qx.ui.decoration.MBackgroundImage],construct:function(p){qx.ui.decoration.Abstract.call(this);if(p!=null){this.setBackgroundColor(p);}},properties:{backgroundColor:{check:i,nullable:true,apply:j}},members:{__py:null,_getDefaultInsets:function(){return {top:0,right:0,bottom:0,left:0};},_isInitialized:function(){return !!this.__py;},getMarkup:function(){if(this.__py){return this.__py;}var n={position:h,top:0,left:0};var o=this._generateBackgroundMarkup(n);return this.__py=o;},resize:function(a,b,c){var d=this.getInsets();a.style.width=(b-d.left-d.right)+m;a.style.height=(c-d.top-d.bottom)+m;a.style.left=d.left+m;a.style.top=d.top+m;},tint:function(e,f){var g=qx.theme.manager.Color.getInstance();if(f==null){f=this.getBackgroundColor();}e.style.backgroundColor=g.resolve(f)||k;},_applyStyle:function(){{};}},destruct:function(){this.__py=null;}});})();(function(){var m="_applyStyle",l="solid",k="Color",j="",i="double",h="px",g="px ",f="dotted",e="_applyWidth",d="dashed",H="Number",G=" ",F="shorthand",E="widthTop",D="styleRight",C="styleLeft",B="widthLeft",A="widthBottom",z="styleTop",y="colorBottom",t="styleBottom",u="widthRight",r="colorLeft",s="colorRight",p="colorTop",q="border-top",n="border-left",o="border-right",v="qx.ui.decoration.Single",w="border-bottom",x="absolute";qx.Class.define(v,{extend:qx.ui.decoration.Abstract,include:[qx.ui.decoration.MBackgroundImage],construct:function(I,J,K){qx.ui.decoration.Abstract.call(this);if(I!=null){this.setWidth(I);}if(J!=null){this.setStyle(J);}if(K!=null){this.setColor(K);}},properties:{widthTop:{check:H,init:0,apply:e},widthRight:{check:H,init:0,apply:e},widthBottom:{check:H,init:0,apply:e},widthLeft:{check:H,init:0,apply:e},styleTop:{nullable:true,check:[l,f,d,i],init:l,apply:m},styleRight:{nullable:true,check:[l,f,d,i],init:l,apply:m},styleBottom:{nullable:true,check:[l,f,d,i],init:l,apply:m},styleLeft:{nullable:true,check:[l,f,d,i],init:l,apply:m},colorTop:{nullable:true,check:k,apply:m},colorRight:{nullable:true,check:k,apply:m},colorBottom:{nullable:true,check:k,apply:m},colorLeft:{nullable:true,check:k,apply:m},backgroundColor:{check:k,nullable:true,apply:m},left:{group:[B,C,r]},right:{group:[u,D,s]},top:{group:[E,z,p]},bottom:{group:[A,t,y]},width:{group:[E,u,A,B],mode:F},style:{group:[z,D,t,C],mode:F},color:{group:[p,s,y,r],mode:F}},members:{__pz:null,_getDefaultInsets:function(){return {top:this.getWidthTop(),right:this.getWidthRight(),bottom:this.getWidthBottom(),left:this.getWidthLeft()};},_isInitialized:function(){return !!this.__pz;},getMarkup:function(P){if(this.__pz){return this.__pz;}var Q=qx.theme.manager.Color.getInstance();var R={};var T=this.getWidthTop();if(T>0){R[q]=T+g+this.getStyleTop()+G+(Q.resolve(this.getColorTop())||j);}var T=this.getWidthRight();if(T>0){R[o]=T+g+this.getStyleRight()+G+(Q.resolve(this.getColorRight())||j);}var T=this.getWidthBottom();if(T>0){R[w]=T+g+this.getStyleBottom()+G+(Q.resolve(this.getColorBottom())||j);}var T=this.getWidthLeft();if(T>0){R[n]=T+g+this.getStyleLeft()+G+(Q.resolve(this.getColorLeft())||j);}{};R.position=x;R.top=0;R.left=0;var S=this._generateBackgroundMarkup(R);return this.__pz=S;},resize:function(L,M,N){var O=this.getInsets();M-=O.left+O.right;N-=O.top+O.bottom;if(M<0){M=0;}if(N<0){N=0;}L.style.width=M+h;L.style.height=N+h;L.style.left=(parseInt(L.style.left)+O.left-this.getWidthLeft())+h;L.style.top=(parseInt(L.style.top)+O.top-this.getWidthTop())+h;},tint:function(a,b){var c=qx.theme.manager.Color.getInstance();if(b==null){b=this.getBackgroundColor();}a.style.backgroundColor=c.resolve(b)||j;},_applyWidth:function(){{};this._resetInsets();},_applyStyle:function(){{};}},destruct:function(){this.__pz=null;}});})();(function(){var t="Number",s="_applyInsets",r="-l",q="insetRight",p="insetTop",o="_applyBaseImage",n="insetBottom",m="set",l="shorthand",k="-t",h="insetLeft",j="String",i="qx.ui.decoration.Grid";qx.Class.define(i,{extend:qx.core.Object,implement:[qx.ui.decoration.IDecorator],construct:function(d,e){qx.core.Object.call(this);if(qx.ui.decoration.css3.BorderImage.IS_SUPPORTED){this.__pA=new qx.ui.decoration.css3.BorderImage();if(d){this.__pB(d);}}else{this.__pA=new qx.ui.decoration.GridDiv(d);}if(e!=null){this.__pA.setInsets(e);}},properties:{baseImage:{check:j,nullable:true,apply:o},insetLeft:{check:t,nullable:true,apply:s},insetRight:{check:t,nullable:true,apply:s},insetBottom:{check:t,nullable:true,apply:s},insetTop:{check:t,nullable:true,apply:s},insets:{group:[p,q,n,h],mode:l}},members:{__pA:null,getMarkup:function(){return this.__pA.getMarkup();},resize:function(u,v,w){this.__pA.resize(u,v,w);},tint:function(H,I){},getInsets:function(){return this.__pA.getInsets();},_applyInsets:function(a,b,name){var c=m+qx.lang.String.firstUp(name);this.__pA[c](a);},_applyBaseImage:function(f,g){if(this.__pA instanceof qx.ui.decoration.GridDiv){this.__pA.setBaseImage(f);}else{this.__pB(f);}},__pB:function(x){var z,B;this.__pA.setBorderImage(x);var D=qx.util.AliasManager.getInstance().resolve(x);var E=/(.*)(\.[a-z]+)$/.exec(D);var A=E[1];var C=E[2];var y=qx.util.ResourceManager.getInstance();var F=y.getImageHeight(A+k+C);var G=y.getImageWidth(A+r+C);{};this.__pA.setSlice([F,G]);}},destruct:function(){this.__pA=null;}});})();(function(){var m="_applyStyle",l='"></div>',k="Color",j="1px",i='<div style="',h='border:',g="1px solid ",f="",e=";",d="px",y='</div>',x="qx.ui.decoration.Beveled",w='<div style="position:absolute;top:1px;left:1px;',v='border-bottom:',u='border-right:',t='border-left:',s='border-top:',r="Number",q='<div style="position:absolute;top:1px;left:0px;',p='position:absolute;top:0px;left:1px;',n='<div style="overflow:hidden;font-size:0;line-height:0;">',o="absolute";qx.Class.define(x,{extend:qx.ui.decoration.Abstract,include:[qx.ui.decoration.MBackgroundImage],construct:function(a,b,c){qx.ui.decoration.Abstract.call(this);if(a!=null){this.setOuterColor(a);}if(b!=null){this.setInnerColor(b);}if(c!=null){this.setInnerOpacity(c);}},properties:{innerColor:{check:k,nullable:true,apply:m},innerOpacity:{check:r,init:1,apply:m},outerColor:{check:k,nullable:true,apply:m},backgroundColor:{check:k,nullable:true,apply:m}},members:{__pC:null,_getDefaultInsets:function(){return {top:2,right:2,bottom:2,left:2};},_isInitialized:function(){return !!this.__pC;},_applyStyle:function(){{};},getMarkup:function(){if(this.__pC){return this.__pC;}var N=qx.theme.manager.Color.getInstance();var O=[];var R=g+N.resolve(this.getOuterColor())+e;var Q=g+N.resolve(this.getInnerColor())+e;O.push(n);O.push(i);O.push(h,R);O.push(qx.bom.element.Opacity.compile(0.35));O.push(l);O.push(q);O.push(t,R);O.push(u,R);O.push(qx.bom.element.Opacity.compile(1));O.push(l);O.push(i);O.push(p);O.push(s,R);O.push(v,R);O.push(qx.bom.element.Opacity.compile(1));O.push(l);var P={position:o,top:j,left:j,opacity:1};O.push(this._generateBackgroundMarkup(P));O.push(w);O.push(h,Q);O.push(qx.bom.element.Opacity.compile(this.getInnerOpacity()));O.push(l);O.push(y);return this.__pC=O.join(f);},resize:function(z,A,B){if(A<4){A=4;}if(B<4){B=4;}if(qx.bom.client.Feature.CONTENT_BOX){var outerWidth=A-2;var outerHeight=B-2;var H=outerWidth;var G=outerHeight;var innerWidth=A-4;var innerHeight=B-4;}else{var outerWidth=A;var outerHeight=B;var H=A-2;var G=B-2;var innerWidth=H;var innerHeight=G;}var J=d;var F=z.childNodes[0].style;F.width=outerWidth+J;F.height=outerHeight+J;var E=z.childNodes[1].style;E.width=outerWidth+J;E.height=G+J;var D=z.childNodes[2].style;D.width=H+J;D.height=outerHeight+J;var C=z.childNodes[3].style;C.width=H+J;C.height=G+J;var I=z.childNodes[4].style;I.width=innerWidth+J;I.height=innerHeight+J;},tint:function(K,L){var M=qx.theme.manager.Color.getInstance();if(L==null){L=this.getBackgroundColor();}K.childNodes[3].style.backgroundColor=M.resolve(L)||f;}},destruct:function(){this.__pC=null;}});})();(function(){var m="solid",l="scale",k="border-main",j="white",i="repeat-x",h="border-separator",g="background-light",f="invalid",e="border-focused-invalid",d="border-disabled",bs="decoration/table/header-cell.png",br="decoration/form/input.png",bq="#f8f8f8",bp="decoration/scrollbar/scrollbar-button-bg-horizontal.png",bo="#b6b6b6",bn="background-pane",bm="repeat-y",bl="decoration/form/input-focused.png",bk="#33508D",bj="decoration/selection.png",t="border-input",u="decoration/scrollbar/scrollbar-button-bg-vertical.png",r="decoration/tabview/tab-button-top-active.png",s="black",p="decoration/form/button-c.png",q="decoration/scrollbar/scrollbar-bg-vertical.png",n="decoration/form/button.png",o="decoration/form/button-checked.png",B="decoration/tabview/tab-button-left-inactive.png",C="decoration/groupbox/groupbox.png",O="#FAFAFA",K="decoration/pane/pane.png",W="dotted",R="decoration/toolbar/toolbar-part.gif",bf="decoration/tabview/tab-button-top-inactive.png",bc="decoration/menu/bar-background.png",G="center",bi="decoration/tabview/tab-button-bottom-active.png",bh="decoration/form/button-hovered.png",bg="decoration/form/tooltip-error-arrow.png",F="decoration/window/captionbar-inactive.png",I="qx/decoration/Modern",J="decoration/menu/background.png",M="decoration/window/statusbar.png",P="border-focused",S="table-focus-indicator",Y="#F2F2F2",be="decoration/form/button-checked-c.png",v="decoration/scrollbar/scrollbar-bg-horizontal.png",w="qx.theme.modern.Decoration",H="#f4f4f4",V="decoration/shadow/shadow-small.png",U="decoration/app-header.png",T="decoration/tabview/tabview-pane.png",bb="decoration/form/tooltip-error.png",ba="decoration/form/button-focused.png",Q="decoration/tabview/tab-button-bottom-inactive.png",X="decoration/form/button-disabled.png",a="decoration/tabview/tab-button-right-active.png",bd="decoration/form/button-pressed.png",x="no-repeat",y="decoration/window/captionbar-active.png",L="decoration/tabview/tab-button-left-active.png",b="background-splitpane",c="decoration/form/button-checked-focused.png",E="#C5C5C5",z="decoration/toolbar/toolbar-gradient.png",A="decoration/tabview/tab-button-right-inactive.png",D="#b8b8b8",N="decoration/shadow/shadow.png";qx.Theme.define(w,{aliases:{decoration:I},decorations:{"main":{decorator:qx.ui.decoration.Uniform,style:{width:1,color:k}},"selected":{decorator:qx.ui.decoration.Background,style:{backgroundImage:bj,backgroundRepeat:l}},"selected-dragover":{decorator:qx.ui.decoration.Single,style:{backgroundImage:bj,backgroundRepeat:l,bottom:[2,m,bk]}},"dragover":{decorator:qx.ui.decoration.Single,style:{bottom:[2,m,bk]}},"pane":{decorator:qx.ui.decoration.Grid,style:{baseImage:K,insets:[0,2,3,0]}},"group":{decorator:qx.ui.decoration.Grid,style:{baseImage:C}},"border-invalid":{decorator:qx.ui.decoration.Beveled,style:{outerColor:f,innerColor:j,innerOpacity:0.5,backgroundImage:br,backgroundRepeat:i,backgroundColor:g}},"keyboard-focus":{decorator:qx.ui.decoration.Single,style:{width:1,color:s,style:W}},"separator-horizontal":{decorator:qx.ui.decoration.Single,style:{widthLeft:1,colorLeft:h}},"separator-vertical":{decorator:qx.ui.decoration.Single,style:{widthTop:1,colorTop:h}},"tooltip-error":{decorator:qx.ui.decoration.Grid,style:{baseImage:bb,insets:[2,5,5,2]}},"tooltip-error-arrow":{decorator:qx.ui.decoration.Background,style:{backgroundImage:bg,backgroundPositionY:G,backgroundRepeat:x,insets:[0,0,0,10]}},"shadow-window":{decorator:qx.ui.decoration.Grid,style:{baseImage:N,insets:[4,8,8,4]}},"shadow-popup":{decorator:qx.ui.decoration.Grid,style:{baseImage:V,insets:[0,3,3,0]}},"scrollbar-horizontal":{decorator:qx.ui.decoration.Background,style:{backgroundImage:v,backgroundRepeat:i}},"scrollbar-vertical":{decorator:qx.ui.decoration.Background,style:{backgroundImage:q,backgroundRepeat:bm}},"scrollbar-slider-horizontal":{decorator:qx.ui.decoration.Beveled,style:{backgroundImage:bp,backgroundRepeat:l,outerColor:k,innerColor:j,innerOpacity:0.5}},"scrollbar-slider-horizontal-disabled":{decorator:qx.ui.decoration.Beveled,style:{backgroundImage:bp,backgroundRepeat:l,outerColor:d,innerColor:j,innerOpacity:0.3}},"scrollbar-slider-vertical":{decorator:qx.ui.decoration.Beveled,style:{backgroundImage:u,backgroundRepeat:l,outerColor:k,innerColor:j,innerOpacity:0.5}},"scrollbar-slider-vertical-disabled":{decorator:qx.ui.decoration.Beveled,style:{backgroundImage:u,backgroundRepeat:l,outerColor:d,innerColor:j,innerOpacity:0.3}},"button":{decorator:qx.ui.decoration.Grid,style:{baseImage:n,insets:2}},"button-disabled":{decorator:qx.ui.decoration.Grid,style:{baseImage:X,insets:2}},"button-focused":{decorator:qx.ui.decoration.Grid,style:{baseImage:ba,insets:2}},"button-hovered":{decorator:qx.ui.decoration.Grid,style:{baseImage:bh,insets:2}},"button-pressed":{decorator:qx.ui.decoration.Grid,style:{baseImage:bd,insets:2}},"button-checked":{decorator:qx.ui.decoration.Grid,style:{baseImage:o,insets:2}},"button-checked-focused":{decorator:qx.ui.decoration.Grid,style:{baseImage:c,insets:2}},"button-invalid-shadow":{decorator:qx.ui.decoration.Beveled,style:{outerColor:f,innerColor:e,insets:[1]}},"checkbox-invalid-shadow":{decorator:qx.ui.decoration.Beveled,style:{outerColor:f,innerColor:e,insets:[0]}},"input":{decorator:qx.ui.decoration.Beveled,style:{outerColor:t,innerColor:j,innerOpacity:0.5,backgroundImage:br,backgroundRepeat:i,backgroundColor:g}},"input-focused":{decorator:qx.ui.decoration.Beveled,style:{outerColor:t,innerColor:P,backgroundImage:bl,backgroundRepeat:i,backgroundColor:g}},"input-focused-invalid":{decorator:qx.ui.decoration.Beveled,style:{outerColor:f,innerColor:e,backgroundImage:bl,backgroundRepeat:i,backgroundColor:g,insets:[2]}},"input-disabled":{decorator:qx.ui.decoration.Beveled,style:{outerColor:d,innerColor:j,innerOpacity:0.5,backgroundImage:br,backgroundRepeat:i,backgroundColor:g}},"toolbar":{decorator:qx.ui.decoration.Background,style:{backgroundImage:z,backgroundRepeat:l}},"toolbar-button-hovered":{decorator:qx.ui.decoration.Beveled,style:{outerColor:bo,innerColor:bq,backgroundImage:p,backgroundRepeat:l}},"toolbar-button-checked":{decorator:qx.ui.decoration.Beveled,style:{outerColor:bo,innerColor:bq,backgroundImage:be,backgroundRepeat:l}},"toolbar-separator":{decorator:qx.ui.decoration.Single,style:{widthLeft:1,widthRight:1,colorLeft:D,colorRight:H,styleLeft:m,styleRight:m}},"toolbar-part":{decorator:qx.ui.decoration.Background,style:{backgroundImage:R,backgroundRepeat:bm}},"tabview-pane":{decorator:qx.ui.decoration.Grid,style:{baseImage:T,insets:[4,6,7,4]}},"tabview-page-button-top-active":{decorator:qx.ui.decoration.Grid,style:{baseImage:r}},"tabview-page-button-top-inactive":{decorator:qx.ui.decoration.Grid,style:{baseImage:bf}},"tabview-page-button-bottom-active":{decorator:qx.ui.decoration.Grid,style:{baseImage:bi}},"tabview-page-button-bottom-inactive":{decorator:qx.ui.decoration.Grid,style:{baseImage:Q}},"tabview-page-button-left-active":{decorator:qx.ui.decoration.Grid,style:{baseImage:L}},"tabview-page-button-left-inactive":{decorator:qx.ui.decoration.Grid,style:{baseImage:B}},"tabview-page-button-right-active":{decorator:qx.ui.decoration.Grid,style:{baseImage:a}},"tabview-page-button-right-inactive":{decorator:qx.ui.decoration.Grid,style:{baseImage:A}},"splitpane":{decorator:qx.ui.decoration.Uniform,style:{backgroundColor:bn,width:3,color:b,style:m}},"window":{decorator:qx.ui.decoration.Single,style:{backgroundColor:bn,width:1,color:k,widthTop:0}},"window-captionbar-active":{decorator:qx.ui.decoration.Grid,style:{baseImage:y}},"window-captionbar-inactive":{decorator:qx.ui.decoration.Grid,style:{baseImage:F}},"window-statusbar":{decorator:qx.ui.decoration.Grid,style:{baseImage:M}},"table":{decorator:qx.ui.decoration.Single,style:{width:1,color:k,style:m}},"table-statusbar":{decorator:qx.ui.decoration.Single,style:{widthTop:1,colorTop:k,style:m}},"table-scroller-header":{decorator:qx.ui.decoration.Single,style:{backgroundImage:bs,backgroundRepeat:l,widthBottom:1,colorBottom:k,style:m}},"table-header-cell":{decorator:qx.ui.decoration.Single,style:{widthRight:1,colorRight:h,styleRight:m}},"table-header-cell-hovered":{decorator:qx.ui.decoration.Single,style:{widthRight:1,colorRight:h,styleRight:m,widthBottom:1,colorBottom:j,styleBottom:m}},"table-column-button":{decorator:qx.ui.decoration.Single,style:{backgroundImage:bs,backgroundRepeat:l,widthBottom:1,colorBottom:k,style:m}},"table-scroller-focus-indicator":{decorator:qx.ui.decoration.Single,style:{width:2,color:S,style:m}},"progressive-table-header":{decorator:qx.ui.decoration.Single,style:{width:1,color:k,style:m}},"progressive-table-header-cell":{decorator:qx.ui.decoration.Single,style:{backgroundImage:bs,backgroundRepeat:l,widthRight:1,colorRight:Y,style:m}},"menu":{decorator:qx.ui.decoration.Single,style:{backgroundImage:J,backgroundRepeat:l,width:1,color:k,style:m}},"menu-separator":{decorator:qx.ui.decoration.Single,style:{widthTop:1,colorTop:E,widthBottom:1,colorBottom:O}},"menubar":{decorator:qx.ui.decoration.Single,style:{backgroundImage:bc,backgroundRepeat:l,width:1,color:h,style:m}},"app-header":{decorator:qx.ui.decoration.Background,style:{backgroundImage:U,backgroundRepeat:l}}}});})();(function(){var n="Liberation Sans",m="Arial",l="Lucida Grande",k="sans-serif",j="Tahoma",i="Candara",h="Segoe UI",g="Consolas",f="Courier New",e="Monaco",b="monospace",d="Lucida Console",c="qx.theme.modern.Font",a="DejaVu Sans Mono";qx.Theme.define(c,{fonts:{"default":{size:(qx.bom.client.System.WINVISTA||qx.bom.client.System.WIN7)?12:11,lineHeight:1.4,family:qx.bom.client.Platform.MAC?[l]:(qx.bom.client.System.WINVISTA||qx.bom.client.System.WIN7)?[h,i]:[j,n,m,k]},"bold":{size:(qx.bom.client.System.WINVISTA||qx.bom.client.System.WIN7)?12:11,lineHeight:1.4,family:qx.bom.client.Platform.MAC?[l]:(qx.bom.client.System.WINVISTA||qx.bom.client.System.WIN7)?[h,i]:[j,n,m,k],bold:true},"small":{size:(qx.bom.client.System.WINVISTA||qx.bom.client.System.WIN7)?11:10,lineHeight:1.4,family:qx.bom.client.Platform.MAC?[l]:(qx.bom.client.System.WINVISTA||qx.bom.client.System.WIN7)?[h,i]:[j,n,m,k]},"monospace":{size:11,lineHeight:1.4,family:qx.bom.client.Platform.MAC?[d,e]:(qx.bom.client.System.WINVISTA||qx.bom.client.System.WIN7)?[g]:[g,a,f,b]}}});})();(function(){var gz="button-frame",gy="atom",gx="widget",gw="main",gv="button",gu="text-selected",gt="image",gs="bold",gr="middle",gq="background-light",fe="text-disabled",fd="groupbox",fc="decoration/arrows/down.png",fb="cell",fa="selected",eY="border-invalid",eX="input",eW="input-disabled",eV="menu-button",eU="input-focused-invalid",gG="toolbar-button",gH="spinner",gE="input-focused",gF="popup",gC="tooltip",gD="label",gA="list",gB="white",gI="tree-item",gJ="treevirtual-contract",fY="scrollbar",fX="datechooser/nav-button",gb="text-hovered",ga="center",gd="treevirtual-expand",gc="textfield",gf="decoration/arrows/right.png",ge="background-application",fW="radiobutton",fV="invalid",db="combobox",dc="right-top",dd="checkbox",de="text-title",df="qx/static/blank.gif",dg="scrollbar/button",dh="right",di="combobox/button",dj="icon/16/places/folder.png",dk="text-label",gX="decoration/tree/closed.png",gW="scrollbar-slider-horizontal",gV="checkbox-checked",gU="decoration/arrows/left.png",hc="button-focused",hb="text-light",ha="menu-slidebar-button",gY="text-input",he="slidebar/button-forward",hd="background-splitpane",ee=".png",ef="decoration/tree/open.png",ec="default",ed="decoration/arrows/down-small.png",ei="datechooser",ej="slidebar/button-backward",eg="selectbox",eh="treevirtual-folder",ea="shadow-popup",eb="icon/16/mimetypes/office-document.png",dF="background-medium",dE="table",dH="decoration/arrows/up.png",dG="decoration/form/",dB="",dA="-invalid",dD="icon/16/places/folder-open.png",dC="button-checked",dz="decoration/window/maximize-active-hovered.png",dy="radiobutton-hovered",ep="keyboard-focus",eq="decoration/cursors/",er="slidebar",es="tooltip-error-arrow",el="table-scroller-focus-indicator",em="move-frame",en="nodrop",eo="decoration/table/boolean-true.png",et="table-header-cell",eu="menu",dS="app-header",dR="row-layer",dQ="text-inactive",dP="move",dO="radiobutton-checked-focused",dN="decoration/window/restore-active-hovered.png",dM="shadow-window",dL="table-column-button",dW="right.png",dV="tabview-page-button-bottom-inactive",ev="tooltip-error",ew="window-statusbar",ex="button-hovered",ey="decoration/scrollbar/scrollbar-",ez="background-tip",eA="scrollbar-slider-horizontal-disabled",eB="table-scroller-header",eC="button-pressed",eD="table-pane",eE="decoration/window/close-active.png",fm="native",fl="checkbox-hovered",fk="button-invalid-shadow",fj="decoration/window/minimize-active-hovered.png",fq="menubar",fp="icon/16/actions/dialog-cancel.png",fo="tabview-page-button-top-inactive",fn="tabview-page-button-left-inactive",fu="menu-slidebar",ft="toolbar-button-checked",fR="decoration/tree/open-selected.png",fS="radiobutton-checked",fP="decoration/window/minimize-inactive.png",fQ="icon/16/apps/office-calendar.png",fN="group",fO="tabview-page-button-right-inactive",fL="decoration/window/minimize-active.png",fM="decoration/window/restore-inactive.png",fT="checkbox-checked-focused",fU="splitpane",gj="combobox/textfield",gi="button-preselected-focused",gl="decoration/window/close-active-hovered.png",gk="qx/icon/Tango/16/actions/window-close.png",gn="checkbox-pressed",gm="button-disabled",gp="selected-dragover",go="border-separator",gh="decoration/window/maximize-inactive.png",gg="dragover",gQ="scrollarea",gR="scrollbar-vertical",gS="decoration/menu/checkbox-invert.gif",gT="decoration/toolbar/toolbar-handle-knob.gif",gM="icon/22/mimetypes/office-document.png",gN="button-preselected",gO="button-checked-focused",gP="up.png",gK="best-fit",gL="decoration/tree/closed-selected.png",da="qx.theme.modern.Appearance",cY="text-active",cX="toolbar-button-hovered",cW="progressive-table-header",cV="decoration/table/select-column-order.png",cU="decoration/menu/radiobutton.gif",cT="decoration/arrows/forward.png",cS="decoration/table/descending.png",cR="window-captionbar-active",cQ="checkbox-checked-hovered",dn="scrollbar-slider-vertical",dp="toolbar",dl="alias",dm="decoration/window/restore-active.png",ds="decoration/table/boolean-false.png",dt="icon/32/mimetypes/office-document.png",dq="radiobutton-checked-disabled",dr="tabview-pane",dv="decoration/arrows/rewind.png",dw="checkbox-focused",fy="top",fs="icon/16/actions/dialog-ok.png",fF="radiobutton-checked-hovered",fB="table-header-cell-hovered",fh="window",ff="text-gray",dJ="decoration/menu/radiobutton-invert.gif",fi="text-placeholder",dU="slider",dT="keep-align",eM="down.png",eN="tabview-page-button-top-active",eO="icon/32/places/folder-open.png",eP="icon/22/places/folder.png",eQ="decoration/window/maximize-active.png",eR="checkbox-checked-pressed",eS="decoration/window/close-inactive.png",eT="tabview-page-button-left-active",eK="toolbar-part",eL="decoration/splitpane/knob-vertical.png",fg=".gif",fE="icon/22/places/folder-open.png",fD="radiobutton-checked-pressed",fC="table-statusbar",fJ="radiobutton-pressed",fI="window-captionbar-inactive",fH="copy",fG="radiobutton-focused",fA="decoration/arrows/down-invert.png",fz="decoration/menu/checkbox.gif",du="decoration/splitpane/knob-horizontal.png",dY="icon/32/places/folder.png",dX="toolbar-separator",fr="tabview-page-button-bottom-active",ek="decoration/arrows/up-small.png",fx="decoration/table/ascending.png",fw="decoration/arrows/up-invert.png",fv="small",dI="tabview-page-button-right-active",fK="-disabled",dx="scrollbar-horizontal",dK="progressive-table-header-cell",eF="menu-separator",eG="pane",eH="decoration/arrows/right-invert.png",eI="left.png",eJ="icon/16/actions/view-refresh.png";qx.Theme.define(da,{appearances:{"widget":{},"root":{style:function(k){return {backgroundColor:ge,textColor:dk,font:ec};}},"label":{style:function(cn){return {textColor:cn.disabled?fe:undefined};}},"move-frame":{style:function(ce){return {decorator:gw};}},"resize-frame":em,"dragdrop-cursor":{style:function(M){var N=en;if(M.copy){N=fH;}else if(M.move){N=dP;}else if(M.alias){N=dl;}return {source:eq+N+fg,position:dc,offset:[2,16,2,6]};}},"image":{style:function(bX){return {opacity:!bX.replacement&&bX.disabled?0.3:1};}},"atom":{},"atom/label":gD,"atom/icon":gt,"popup":{style:function(T){return {decorator:gw,backgroundColor:gq,shadow:ea};}},"button-frame":{alias:gy,style:function(ia){var ic,ib;if(ia.checked&&ia.focused&&!ia.inner){ic=gO;ib=undefined;}else if(ia.disabled){ic=gm;ib=undefined;}else if(ia.pressed){ic=eC;ib=gb;}else if(ia.checked){ic=dC;ib=undefined;}else if(ia.hovered){ic=ex;ib=gb;}else if(ia.preselected&&ia.focused&&!ia.inner){ic=gi;ib=gb;}else if(ia.preselected){ic=gN;ib=gb;}else if(ia.focused&&!ia.inner){ic=hc;ib=undefined;}else{ic=gv;ib=undefined;}return {decorator:ic,textColor:ib,shadow:ia.invalid&&!ia.disabled?fk:undefined};}},"button-frame/image":{style:function(hM){return {opacity:!hM.replacement&&hM.disabled?0.5:1};}},"button":{alias:gz,include:gz,style:function(o){return {padding:[2,8],center:true};}},"hover-button":{alias:gy,include:gy,style:function(cC){return {decorator:cC.hovered?fa:undefined,textColor:cC.hovered?gu:undefined};}},"splitbutton":{},"splitbutton/button":gv,"splitbutton/arrow":{alias:gv,include:gv,style:function(p){return {icon:fc,padding:2,marginLeft:1};}},"checkbox":{alias:gy,style:function(hw){var hy;if(hw.checked){if(hw.disabled){hy=gV;}else if(hw.focused){hy=fT;}else if(hw.pressed){hy=eR;}else if(hw.hovered){hy=cQ;}else{hy=gV;}}else if(!hw.disabled){if(hw.focused){hy=dw;}else if(hw.pressed){hy=gn;}else if(hw.hovered){hy=fl;}}hy=hy||dd;var hx=hw.invalid&&!hw.disabled?dA:dB;return {icon:dG+hy+hx+ee,gap:6};}},"radiobutton":{alias:gy,style:function(s){var u;if(s.checked&&s.focused){u=dO;}else if(s.checked&&s.disabled){u=dq;}else if(s.checked&&s.pressed){u=fD;}else if(s.checked&&s.hovered){u=fF;}else if(s.checked){u=fS;}else if(s.focused){u=fG;}else if(s.pressed){u=fJ;}else if(s.hovered){u=dy;}else{u=fW;}var t=s.invalid&&!s.disabled?dA:dB;return {icon:dG+u+t+ee,gap:6};}},"textfield":{style:function(bC){var bH;var bF=!!bC.focused;var bG=!!bC.invalid;var bD=!!bC.disabled;if(bF&&bG&&!bD){bH=eU;}else if(bF&&!bG&&!bD){bH=gE;}else if(bD){bH=eW;}else if(!bF&&bG&&!bD){bH=eY;}else{bH=eX;}var bE;if(bC.disabled){bE=fe;}else if(bC.showingPlaceholder){bE=fi;}else{bE=gY;}return {decorator:bH,padding:[2,4,1],textColor:bE};}},"textarea":{include:gc,style:function(cE){return {padding:4};}},"spinner":{style:function(cg){var ck;var ci=!!cg.focused;var cj=!!cg.invalid;var ch=!!cg.disabled;if(ci&&cj&&!ch){ck=eU;}else if(ci&&!cj&&!ch){ck=gE;}else if(ch){ck=eW;}else if(!ci&&cj&&!ch){ck=eY;}else{ck=eX;}return {decorator:ck};}},"spinner/textfield":{style:function(hG){return {marginRight:2,padding:[2,4,1],textColor:hG.disabled?fe:gY};}},"spinner/upbutton":{alias:gz,include:gz,style:function(bs){return {icon:ek,padding:bs.pressed?[2,2,0,4]:[1,3,1,3],shadow:undefined};}},"spinner/downbutton":{alias:gz,include:gz,style:function(V){return {icon:ed,padding:V.pressed?[2,2,0,4]:[1,3,1,3],shadow:undefined};}},"datefield":db,"datefield/button":{alias:di,include:di,style:function(hW){return {icon:fQ,padding:[0,3],decorator:undefined};}},"datefield/textfield":gj,"datefield/list":{alias:ei,include:ei,style:function(cH){return {decorator:undefined};}},"groupbox":{style:function(Y){return {legendPosition:fy};}},"groupbox/legend":{alias:gy,style:function(cp){return {padding:[1,0,1,4],textColor:cp.invalid?fV:de,font:gs};}},"groupbox/frame":{style:function(hX){return {padding:12,decorator:fN};}},"check-groupbox":fd,"check-groupbox/legend":{alias:dd,include:dd,style:function(g){return {padding:[1,0,1,4],textColor:g.invalid?fV:de,font:gs};}},"radio-groupbox":fd,"radio-groupbox/legend":{alias:fW,include:fW,style:function(hg){return {padding:[1,0,1,4],textColor:hg.invalid?fV:de,font:gs};}},"scrollarea":{style:function(hl){return {minWidth:50,minHeight:50};}},"scrollarea/corner":{style:function(bi){return {backgroundColor:ge};}},"scrollarea/pane":gx,"scrollarea/scrollbar-x":fY,"scrollarea/scrollbar-y":fY,"scrollbar":{style:function(br){if(br[fm]){return {};}return {width:br.horizontal?undefined:16,height:br.horizontal?16:undefined,decorator:br.horizontal?dx:gR,padding:1};}},"scrollbar/slider":{alias:dU,style:function(bI){return {padding:bI.horizontal?[0,1,0,1]:[1,0,1,0]};}},"scrollbar/slider/knob":{include:gz,style:function(bb){var bc=bb.horizontal?gW:dn;if(bb.disabled){bc+=fK;}return {decorator:bc,minHeight:bb.horizontal?undefined:9,minWidth:bb.horizontal?9:undefined};}},"scrollbar/button":{alias:gz,include:gz,style:function(F){var G=ey;if(F.left){G+=eI;}else if(F.right){G+=dW;}else if(F.up){G+=gP;}else{G+=eM;}if(F.left||F.right){return {padding:[0,0,0,F.left?3:4],icon:G,width:15,height:14};}else{return {padding:[0,0,0,2],icon:G,width:14,height:15};}}},"scrollbar/button-begin":dg,"scrollbar/button-end":dg,"slider":{style:function(hR){var hV;var hT=!!hR.focused;var hU=!!hR.invalid;var hS=!!hR.disabled;if(hT&&hU&&!hS){hV=eU;}else if(hT&&!hU&&!hS){hV=gE;}else if(hS){hV=eW;}else if(!hT&&hU&&!hS){hV=eY;}else{hV=eX;}return {decorator:hV};}},"slider/knob":{include:gz,style:function(hA){return {decorator:hA.disabled?eA:gW,shadow:undefined,height:14,width:14};}},"list":{alias:gQ,style:function(bj){var bn;var bl=!!bj.focused;var bm=!!bj.invalid;var bk=!!bj.disabled;if(bl&&bm&&!bk){bn=eU;}else if(bl&&!bm&&!bk){bn=gE;}else if(bk){bn=eW;}else if(!bl&&bm&&!bk){bn=eY;}else{bn=eX;}return {backgroundColor:gq,decorator:bn};}},"list/pane":gx,"listitem":{alias:gy,style:function(hr){var hs;if(hr.dragover){hs=hr.selected?gp:gg;}else{hs=hr.selected?fa:undefined;}return {padding:hr.dragover?[4,4,2,4]:4,textColor:hr.selected?gu:undefined,decorator:hs};}},"slidebar":{},"slidebar/scrollpane":{},"slidebar/content":{},"slidebar/button-forward":{alias:gz,include:gz,style:function(c){return {padding:5,center:true,icon:c.vertical?fc:gf};}},"slidebar/button-backward":{alias:gz,include:gz,style:function(bz){return {padding:5,center:true,icon:bz.vertical?dH:gU};}},"tabview":{style:function(U){return {contentPadding:16};}},"tabview/bar":{alias:er,style:function(d){var e={marginBottom:d.barTop?-1:0,marginTop:d.barBottom?-4:0,marginLeft:d.barRight?-3:0,marginRight:d.barLeft?-1:0,paddingTop:0,paddingRight:0,paddingBottom:0,paddingLeft:0};if(d.barTop||d.barBottom){e.paddingLeft=5;e.paddingRight=7;}else{e.paddingTop=5;e.paddingBottom=7;}return e;}},"tabview/bar/button-forward":{include:he,alias:he,style:function(q){if(q.barTop||q.barBottom){return {marginTop:2,marginBottom:2};}else{return {marginLeft:2,marginRight:2};}}},"tabview/bar/button-backward":{include:ej,alias:ej,style:function(hv){if(hv.barTop||hv.barBottom){return {marginTop:2,marginBottom:2};}else{return {marginLeft:2,marginRight:2};}}},"tabview/bar/scrollpane":{},"tabview/pane":{style:function(cy){return {decorator:dr,minHeight:100,marginBottom:cy.barBottom?-1:0,marginTop:cy.barTop?-1:0,marginLeft:cy.barLeft?-1:0,marginRight:cy.barRight?-1:0};}},"tabview-page":gx,"tabview-page/button":{alias:gy,style:function(w){var C,y=0;var B=0,x=0,z=0,A=0;if(w.checked){if(w.barTop){C=eN;y=[6,14];z=w.firstTab?0:-5;A=w.lastTab?0:-5;}else if(w.barBottom){C=fr;y=[6,14];z=w.firstTab?0:-5;A=w.lastTab?0:-5;}else if(w.barRight){C=dI;y=[6,13];B=w.firstTab?0:-5;x=w.lastTab?0:-5;}else{C=eT;y=[6,13];B=w.firstTab?0:-5;x=w.lastTab?0:-5;}}else{if(w.barTop){C=fo;y=[4,10];B=4;z=w.firstTab?5:1;A=1;}else if(w.barBottom){C=dV;y=[4,10];x=4;z=w.firstTab?5:1;A=1;}else if(w.barRight){C=fO;y=[4,10];A=5;B=w.firstTab?5:1;x=1;z=1;}else{C=fn;y=[4,10];z=5;B=w.firstTab?5:1;x=1;A=1;}}return {zIndex:w.checked?10:5,decorator:C,padding:y,marginTop:B,marginBottom:x,marginLeft:z,marginRight:A,textColor:w.checked?cY:dQ};}},"tabview-page/button/label":{alias:gD,style:function(be){return {padding:[0,1,0,1],margin:be.focused?0:1,decorator:be.focused?ep:undefined};}},"tabview-page/button/close-button":{alias:gy,style:function(bJ){return {icon:gk};}},"toolbar":{style:function(bf){return {decorator:dp,spacing:2};}},"toolbar/part":{style:function(cb){return {decorator:eK,spacing:2};}},"toolbar/part/container":{style:function(cr){return {paddingLeft:2,paddingRight:2};}},"toolbar/part/handle":{style:function(co){return {source:gT,marginLeft:3,marginRight:3};}},"toolbar-button":{alias:gy,style:function(bg){return {marginTop:2,marginBottom:2,padding:(bg.pressed||bg.checked||bg.hovered)&&!bg.disabled||(bg.disabled&&bg.checked)?3:5,decorator:bg.pressed||(bg.checked&&!bg.hovered)||(bg.checked&&bg.disabled)?ft:bg.hovered&&!bg.disabled?cX:undefined};}},"toolbar-menubutton":{alias:gG,include:gG,style:function(b){return {showArrow:true};}},"toolbar-menubutton/arrow":{alias:gt,include:gt,style:function(cu){return {source:ed};}},"toolbar-splitbutton":{style:function(H){return {marginTop:2,marginBottom:2};}},"toolbar-splitbutton/button":{alias:gG,include:gG,style:function(ba){return {icon:fc,marginTop:undefined,marginBottom:undefined};}},"toolbar-splitbutton/arrow":{alias:gG,include:gG,style:function(hn){if(hn.pressed||hn.checked||(hn.hovered&&!hn.disabled)){var ho=1;}else{var ho=3;}return {padding:ho,icon:fc,marginTop:undefined,marginBottom:undefined};}},"toolbar-separator":{style:function(hp){return {decorator:dX,margin:7};}},"tree":gA,"tree-item":{style:function(cA){return {padding:[2,6],textColor:cA.selected?gu:undefined,decorator:cA.selected?fa:undefined};}},"tree-item/icon":{include:gt,style:function(ie){return {paddingRight:5};}},"tree-item/label":gD,"tree-item/open":{include:gt,style:function(hD){var hE;if(hD.selected&&hD.opened){hE=fR;}else if(hD.selected&&!hD.opened){hE=gL;}else if(hD.opened){hE=ef;}else{hE=gX;}return {padding:[0,5,0,2],source:hE};}},"tree-folder":{include:gI,alias:gI,style:function(hi){var hj;if(hi.small){hj=hi.opened?dD:dj;}else if(hi.large){hj=hi.opened?eO:dY;}else{hj=hi.opened?fE:eP;}return {icon:hj};}},"tree-file":{include:gI,alias:gI,style:function(hY){return {icon:hY.small?eb:hY.large?dt:gM};}},"treevirtual":dE,"treevirtual-folder":{style:function(hO){return {icon:hO.opened?dD:dj};}},"treevirtual-file":{include:eh,alias:eh,style:function(O){return {icon:eb};}},"treevirtual-line":{style:function(bQ){return {icon:df};}},"treevirtual-contract":{style:function(hJ){return {icon:ef,paddingLeft:5,paddingTop:2};}},"treevirtual-expand":{style:function(D){return {icon:gX,paddingLeft:5,paddingTop:2};}},"treevirtual-only-contract":gJ,"treevirtual-only-expand":gd,"treevirtual-start-contract":gJ,"treevirtual-start-expand":gd,"treevirtual-end-contract":gJ,"treevirtual-end-expand":gd,"treevirtual-cross-contract":gJ,"treevirtual-cross-expand":gd,"treevirtual-end":{style:function(ca){return {icon:df};}},"treevirtual-cross":{style:function(ht){return {icon:df};}},"tooltip":{include:gF,style:function(j){return {backgroundColor:ez,padding:[1,3,2,3],offset:[15,5,5,5]};}},"tooltip/atom":gy,"tooltip-error":{include:gC,style:function(bp){return {textColor:gu,placeMethod:gx,offset:[0,0,0,14],marginTop:-2,position:dc,showTimeout:100,hideTimeout:10000,decorator:ev,shadow:es,font:gs};}},"tooltip-error/atom":gy,"window":{style:function(bR){return {shadow:dM,contentPadding:[10,10,10,10]};}},"window/pane":{style:function(bL){return {decorator:fh};}},"window/captionbar":{style:function(hB){return {decorator:hB.active?cR:fI,textColor:hB.active?gB:ff,minHeight:26,paddingRight:2};}},"window/icon":{style:function(cx){return {margin:[5,0,3,6]};}},"window/title":{style:function(cl){return {alignY:gr,font:gs,marginLeft:6,marginRight:12};}},"window/minimize-button":{alias:gy,style:function(cd){return {icon:cd.active?cd.hovered?fj:fL:fP,margin:[4,8,2,0]};}},"window/restore-button":{alias:gy,style:function(i){return {icon:i.active?i.hovered?dN:dm:fM,margin:[5,8,2,0]};}},"window/maximize-button":{alias:gy,style:function(cI){return {icon:cI.active?cI.hovered?dz:eQ:gh,margin:[4,8,2,0]};}},"window/close-button":{alias:gy,style:function(hk){return {icon:hk.active?hk.hovered?gl:eE:eS,margin:[4,8,2,0]};}},"window/statusbar":{style:function(hL){return {padding:[2,6],decorator:ew,minHeight:18};}},"window/statusbar-text":{style:function(bN){return {font:fv};}},"iframe":{style:function(bY){return {decorator:gw};}},"resizer":{style:function(cF){return {decorator:eG};}},"splitpane":{style:function(bT){return {decorator:fU};}},"splitpane/splitter":{style:function(X){return {width:X.horizontal?3:undefined,height:X.vertical?3:undefined,backgroundColor:hd};}},"splitpane/splitter/knob":{style:function(id){return {source:id.horizontal?du:eL};}},"splitpane/slider":{style:function(bO){return {width:bO.horizontal?3:undefined,height:bO.vertical?3:undefined,backgroundColor:hd};}},"selectbox":{alias:gz,include:gz,style:function(cm){return {padding:[2,8]};}},"selectbox/atom":gy,"selectbox/popup":gF,"selectbox/list":{alias:gA},"selectbox/arrow":{include:gt,style:function(m){return {source:fc,paddingLeft:5};}},"datechooser":{style:function(cL){var cP;var cN=!!cL.focused;var cO=!!cL.invalid;var cM=!!cL.disabled;if(cN&&cO&&!cM){cP=eU;}else if(cN&&!cO&&!cM){cP=gE;}else if(cM){cP=eW;}else if(!cN&&cO&&!cM){cP=eY;}else{cP=eX;}return {padding:2,decorator:cP,backgroundColor:gq};}},"datechooser/navigation-bar":{},"datechooser/nav-button":{include:gz,alias:gz,style:function(cs){var ct={padding:[2,4],shadow:undefined};if(cs.lastYear){ct.icon=dv;ct.marginRight=1;}else if(cs.lastMonth){ct.icon=gU;}else if(cs.nextYear){ct.icon=cT;ct.marginLeft=1;}else if(cs.nextMonth){ct.icon=gf;}return ct;}},"datechooser/last-year-button-tooltip":gC,"datechooser/last-month-button-tooltip":gC,"datechooser/next-year-button-tooltip":gC,"datechooser/next-month-button-tooltip":gC,"datechooser/last-year-button":fX,"datechooser/last-month-button":fX,"datechooser/next-month-button":fX,"datechooser/next-year-button":fX,"datechooser/month-year-label":{style:function(hq){return {font:gs,textAlign:ga,textColor:hq.disabled?fe:undefined};}},"datechooser/date-pane":{style:function(hz){return {textColor:hz.disabled?fe:undefined,marginTop:2};}},"datechooser/weekday":{style:function(bd){return {textColor:bd.disabled?fe:bd.weekend?hb:undefined,textAlign:ga,paddingTop:2,backgroundColor:dF};}},"datechooser/week":{style:function(cv){return {textAlign:ga,padding:[2,4],backgroundColor:dF};}},"datechooser/day":{style:function(P){return {textAlign:ga,decorator:P.disabled?undefined:P.selected?fa:undefined,textColor:P.disabled?fe:P.selected?gu:P.otherMonth?hb:undefined,font:P.today?gs:undefined,padding:[2,4]};}},"combobox":{style:function(bu){var by;var bw=!!bu.focused;var bx=!!bu.invalid;var bv=!!bu.disabled;if(bw&&bx&&!bv){by=eU;}else if(bw&&!bx&&!bv){by=gE;}else if(bv){by=eW;}else if(!bw&&bx&&!bv){by=eY;}else{by=eX;}return {decorator:by};}},"combobox/popup":gF,"combobox/list":{alias:gA},"combobox/button":{include:gz,alias:gz,style:function(R){var S={icon:fc,padding:2};if(R.selected){S.decorator=hc;}return S;}},"combobox/textfield":{include:gc,style:function(cJ){return {decorator:undefined};}},"menu":{style:function(hH){var hI={decorator:eu,shadow:ea,spacingX:6,spacingY:1,iconColumnWidth:16,arrowColumnWidth:4,placementModeY:hH.submenu||hH.contextmenu?gK:dT};if(hH.submenu){hI.position=dc;hI.offset=[-2,-3];}return hI;}},"menu/slidebar":fu,"menu-slidebar":gx,"menu-slidebar-button":{style:function(hf){return {decorator:hf.hovered?fa:undefined,padding:7,center:true};}},"menu-slidebar/button-backward":{include:ha,style:function(hh){return {icon:hh.hovered?fw:dH};}},"menu-slidebar/button-forward":{include:ha,style:function(hN){return {icon:hN.hovered?fA:fc};}},"menu-separator":{style:function(cB){return {height:0,decorator:eF,margin:[4,2]};}},"menu-button":{alias:gy,style:function(bU){return {decorator:bU.selected?fa:undefined,textColor:bU.selected?gu:undefined,padding:[4,6]};}},"menu-button/icon":{include:gt,style:function(v){return {alignY:gr};}},"menu-button/label":{include:gD,style:function(hC){return {alignY:gr,padding:1};}},"menu-button/shortcut":{include:gD,style:function(L){return {alignY:gr,marginLeft:14,padding:1};}},"menu-button/arrow":{include:gt,style:function(hK){return {source:hK.selected?eH:gf,alignY:gr};}},"menu-checkbox":{alias:eV,include:eV,style:function(bW){return {icon:!bW.checked?undefined:bW.selected?gS:fz};}},"menu-radiobutton":{alias:eV,include:eV,style:function(bP){return {icon:!bP.checked?undefined:bP.selected?dJ:cU};}},"menubar":{style:function(bB){return {decorator:fq};}},"menubar-button":{alias:gy,style:function(J){return {decorator:(J.pressed||J.hovered)&&!J.disabled?fa:undefined,textColor:J.pressed||J.hovered?gu:undefined,padding:[3,8]};}},"colorselector":gx,"colorselector/control-bar":gx,"colorselector/control-pane":gx,"colorselector/visual-pane":fd,"colorselector/preset-grid":gx,"colorselector/colorbucket":{style:function(cz){return {decorator:gw,width:16,height:16};}},"colorselector/preset-field-set":fd,"colorselector/input-field-set":fd,"colorselector/preview-field-set":fd,"colorselector/hex-field-composite":gx,"colorselector/hex-field":gc,"colorselector/rgb-spinner-composite":gx,"colorselector/rgb-spinner-red":gH,"colorselector/rgb-spinner-green":gH,"colorselector/rgb-spinner-blue":gH,"colorselector/hsb-spinner-composite":gx,"colorselector/hsb-spinner-hue":gH,"colorselector/hsb-spinner-saturation":gH,"colorselector/hsb-spinner-brightness":gH,"colorselector/preview-content-old":{style:function(l){return {decorator:gw,width:50,height:10};}},"colorselector/preview-content-new":{style:function(f){return {decorator:gw,backgroundColor:gq,width:50,height:10};}},"colorselector/hue-saturation-field":{style:function(bq){return {decorator:gw,margin:5};}},"colorselector/brightness-field":{style:function(K){return {decorator:gw,margin:[5,7]};}},"colorselector/hue-saturation-pane":gx,"colorselector/hue-saturation-handle":gx,"colorselector/brightness-pane":gx,"colorselector/brightness-handle":gx,"colorpopup":{alias:gF,include:gF,style:function(cG){return {padding:5,backgroundColor:ge};}},"colorpopup/field":{style:function(bt){return {decorator:gw,margin:2,width:14,height:14,backgroundColor:gq};}},"colorpopup/selector-button":gv,"colorpopup/auto-button":gv,"colorpopup/preview-pane":fd,"colorpopup/current-preview":{style:function(cK){return {height:20,padding:4,marginLeft:4,decorator:gw,allowGrowX:true};}},"colorpopup/selected-preview":{style:function(W){return {height:20,padding:4,marginRight:4,decorator:gw,allowGrowX:true};}},"colorpopup/colorselector-okbutton":{alias:gv,include:gv,style:function(hF){return {icon:fs};}},"colorpopup/colorselector-cancelbutton":{alias:gv,include:gv,style:function(cD){return {icon:fp};}},"table":{alias:gx,style:function(h){return {decorator:dE};}},"table-header":{},"table/statusbar":{style:function(cw){return {decorator:fC,padding:[0,2]};}},"table/column-button":{alias:gz,style:function(bV){return {decorator:dL,padding:3,icon:cV};}},"table-column-reset-button":{include:eV,alias:eV,style:function(){return {icon:eJ};}},"table-scroller":gx,"table-scroller/scrollbar-x":fY,"table-scroller/scrollbar-y":fY,"table-scroller/header":{style:function(bh){return {decorator:eB};}},"table-scroller/pane":{style:function(cf){return {backgroundColor:eD};}},"table-scroller/focus-indicator":{style:function(bo){return {decorator:el};}},"table-scroller/resize-line":{style:function(E){return {backgroundColor:go,width:2};}},"table-header-cell":{alias:gy,style:function(hu){return {minWidth:13,minHeight:20,padding:hu.hovered?[3,4,2,4]:[3,4],decorator:hu.hovered?fB:et,sortIcon:hu.sorted?(hu.sortedAscending?fx:cS):undefined};}},"table-header-cell/label":{style:function(hQ){return {minWidth:0,alignY:gr,paddingRight:5};}},"table-header-cell/sort-icon":{style:function(cq){return {alignY:gr,alignX:dh};}},"table-header-cell/icon":{style:function(r){return {minWidth:0,alignY:gr,paddingRight:5};}},"table-editor-textfield":{include:gc,style:function(bK){return {decorator:undefined,padding:[2,2],backgroundColor:gq};}},"table-editor-selectbox":{include:eg,alias:eg,style:function(I){return {padding:[0,2],backgroundColor:gq};}},"table-editor-combobox":{include:db,alias:db,style:function(cc){return {decorator:undefined,backgroundColor:gq};}},"progressive-table-header":{alias:gx,style:function(a){return {decorator:cW};}},"progressive-table-header-cell":{alias:gy,style:function(bA){return {minWidth:40,minHeight:25,paddingLeft:6,decorator:dK};}},"app-header":{style:function(bM){return {font:gs,textColor:gu,padding:[8,12],decorator:dS};}},"virtual-list":gA,"virtual-list/row-layer":dR,"row-layer":{style:function(hm){return {colorEven:gB,colorOdd:gB};}},"column-layer":gx,"cell":{style:function(hP){return {textColor:hP.selected?gu:dk,padding:[3,6],font:ec};}},"cell-string":fb,"cell-number":{include:fb,style:function(bS){return {textAlign:dh};}},"cell-image":fb,"cell-boolean":{include:fb,style:function(Q){return {iconTrue:eo,iconFalse:ds};}},"cell-atom":fb,"cell-date":fb,"cell-html":fb,"htmlarea":{"include":gx,style:function(n){return {backgroundColor:gB};}}}});})();(function(){var c="Tango",b="qx/icon/Tango",a="qx.theme.icon.Tango";qx.Theme.define(a,{title:c,aliases:{"icon":b},icons:{}});})();(function(){var b="qx.theme.Modern",a="Modern";qx.Theme.define(b,{title:a,meta:{color:qx.theme.modern.Color,decoration:qx.theme.modern.Decoration,font:qx.theme.modern.Font,appearance:qx.theme.modern.Appearance,icon:qx.theme.icon.Tango}});})();(function(){var j="white",i="black",h="#3E6CA8",g="#EBE9ED",f="#A7A6AA",e="#EEE",d="#F3F0F5",c="gray",b="#85878C",a="#888888",E="#3E5B97",D="#FFFFE1",C="#F3F8FD",B="#CBC8CD",A="#FFE0E0",z="#F4F4F4",y="#808080",x="#CCCCCC",w="#C82C2C",v="#DBEAF9",q="#BCCEE5",r="#A5BDDE",o="#7CA0CF",p="#F6F5F7",m="#FF9999",n="qx.theme.classic.Color",k="#990000",l="#F9F8E9",s="#DCDFE4",t="#FAFBFE",u="#AAAAAA";qx.Theme.define(n,{colors:{"background":g,"background-light":d,"background-focused":C,"background-focused-inner":v,"background-disabled":z,"background-selected":h,"background-field":j,"background-pane":t,"background-invalid":A,"border-lead":a,"border-light":j,"border-light-shadow":s,"border-dark-shadow":f,"border-dark":b,"border-main":b,"border-focused-light":q,"border-focused-light-shadow":r,"border-focused-dark-shadow":o,"border-focused-dark":h,"border-separator":y,"invalid":k,"border-focused-invalid":m,"text":i,"text-disabled":f,"text-selected":j,"text-focused":E,"text-placeholder":B,"tooltip":D,"tooltip-text":i,"tooltip-invalid":w,"button":g,"button-hovered":p,"button-abandoned":l,"button-checked":d,"window-active-caption-text":[255,255,255],"window-inactive-caption-text":[255,255,255],"window-active-caption":[51,94,168],"window-inactive-caption":[111,161,217],"date-chooser":j,"date-chooser-title":[116,116,116],"date-chooser-selected":[52,52,52],"effect":[254,200,60],"table-pane":j,"table-header":[242,242,242],"table-header-border":[214,213,217],"table-header-cell":[235,234,219],"table-header-cell-hover":[255,255,255],"table-focus-indicator":[179,217,255],"table-row-background-focused-selected":[90,138,211],"table-row-background-focused":[221,238,255],"table-row-background-selected":[51,94,168],"table-row-background-even":[250,248,243],"table-row-background-odd":[255,255,255],"table-row-selected":[255,255,255],"table-row":[0,0,0],"table-row-line":e,"table-column-line":e,"progressive-table-header":u,"progressive-table-row-background-even":[250,248,243],"progressive-table-row-background-odd":[255,255,255],"progressive-progressbar-background":c,"progressive-progressbar-indicator-done":x,"progressive-progressbar-indicator-undone":j,"progressive-progressbar-percent-background":c,"progressive-progressbar-percent-text":j}});})();(function(){var n="px ",m=" ",l="px",k="Color",j="Number",i=";",h="shorthand",g="innerWidthRight",f="border-left:",e='<div style="position:absolute;top:0;left:0;',I="innerColorBottom",H='</div>',G='',F="scale",E="border-top",D="innerWidthTop",C="border-left",B="innerColorRight",A="innerColorTop",z="relative",u="border-top:",v="qx.ui.decoration.Double",s="border-right:",t='line-height:0;',q="innerColorLeft",r="border-bottom",o='">',p="innerWidthBottom",w="innerWidthLeft",x="border-bottom:",y="border-right";qx.Class.define(v,{extend:qx.ui.decoration.Single,construct:function(a,b,c,innerWidth,d){qx.ui.decoration.Single.call(this,a,b,c,innerWidth,d);if(innerWidth!=null){this.setInnerWidth(innerWidth);}if(d!=null){this.setInnerColor(d);}},properties:{innerWidthTop:{check:j,init:0},innerWidthRight:{check:j,init:0},innerWidthBottom:{check:j,init:0},innerWidthLeft:{check:j,init:0},innerWidth:{group:[D,g,p,w],mode:h},innerColorTop:{nullable:true,check:k},innerColorRight:{nullable:true,check:k},innerColorBottom:{nullable:true,check:k},innerColorLeft:{nullable:true,check:k},innerColor:{group:[A,B,I,q],mode:h}},members:{__pD:null,_getDefaultInsets:function(){return {top:this.getWidthTop()+this.getInnerWidthTop(),right:this.getWidthRight()+this.getInnerWidthRight(),bottom:this.getWidthBottom()+this.getInnerWidthBottom(),left:this.getWidthLeft()+this.getInnerWidthLeft()};},_isInitialized:function(){return !!this.__pD;},getMarkup:function(){if(this.__pD){return this.__pD;}var S=qx.theme.manager.Color.getInstance();var V={position:z};var T=this.getInnerWidthTop();if(T>0){V[E]=T+n+this.getStyleTop()+m+S.resolve(this.getInnerColorTop());}var T=this.getInnerWidthRight();if(T>0){V[y]=T+n+this.getStyleRight()+m+S.resolve(this.getInnerColorRight());}var T=this.getInnerWidthBottom();if(T>0){V[r]=T+n+this.getStyleBottom()+m+S.resolve(this.getInnerColorBottom());}var T=this.getInnerWidthLeft();if(T>0){V[C]=T+n+this.getStyleLeft()+m+S.resolve(this.getInnerColorLeft());}{};var W=this._generateBackgroundMarkup(V);var U=t;if((qx.bom.client.Engine.MSHTML&&qx.bom.client.Engine.VERSION<8)||(qx.bom.client.Engine.MSHTML&&qx.bom.client.Engine.DOCUMENT_MODE<8)){U=G;}var T=this.getWidthTop();if(T>0){U+=u+T+n+this.getStyleTop()+m+S.resolve(this.getColorTop())+i;}var T=this.getWidthRight();if(T>0){U+=s+T+n+this.getStyleRight()+m+S.resolve(this.getColorRight())+i;}var T=this.getWidthBottom();if(T>0){U+=x+T+n+this.getStyleBottom()+m+S.resolve(this.getColorBottom())+i;}var T=this.getWidthLeft();if(T>0){U+=f+T+n+this.getStyleLeft()+m+S.resolve(this.getColorLeft())+i;}{};return this.__pD=e+U+o+W+H;},resize:function(J,K,L){var Q=this.getBackgroundImage()&&this.getBackgroundRepeat()==F;var O=this.getInsets();if(Q||qx.bom.client.Feature.CONTENT_BOX){var innerWidth=K-O.left-O.right;var innerHeight=L-O.top-O.bottom;}else{var M=O.top-this.getInnerWidthTop();var R=O.bottom-this.getInnerWidthBottom();var N=O.left-this.getInnerWidthLeft();var P=O.right-this.getInnerWidthRight();var innerWidth=K-N-P;var innerHeight=L-M-R;}if(innerWidth<0){innerWidth=0;}if(innerHeight<0){innerHeight=0;}J.firstChild.style.width=innerWidth+l;J.firstChild.style.height=innerHeight+l;J.style.left=(parseInt(J.style.left)+O.left-this.getWidthLeft()-this.getInnerWidthLeft())+l;J.style.top=(parseInt(J.style.top)+O.top-this.getWidthTop()-this.getInnerWidthTop())+l;}},destruct:function(){this.__pD=null;}});})();(function(){var j="border-dark-shadow",i="border-light",h="border-dark",g="border-light-shadow",f="solid",e="gray",d="border-focused-light",c="border-focused-dark",b="border-focused-light-shadow",a="border-focused-dark-shadow",y="table-header-border",x="dotted",w="border-separator",v="tooltip-text",u="invalid",t="white",s="decoration/shadow/shadow.png",r="black",q="effect",p="table-focus-indicator",n="border-focused-invalid",o="qx/decoration/Classic",l="border-lead",m="decoration/shadow/shadow-small.png",k="qx.theme.classic.Decoration";qx.Theme.define(k,{aliases:{decoration:o},decorations:{"main":{decorator:qx.ui.decoration.Uniform,style:{width:1,color:h}},"keyboard-focus":{decorator:qx.ui.decoration.Single,style:{width:1,color:r,style:x}},"inset":{decorator:qx.ui.decoration.Double,style:{width:1,innerWidth:1,color:[j,i,i,j],innerColor:[h,g,g,h]}},"outset":{decorator:qx.ui.decoration.Double,style:{width:1,innerWidth:1,color:[g,h,h,g],innerColor:[i,j,j,i]}},"groove":{decorator:qx.ui.decoration.Double,style:{width:1,innerWidth:1,color:[j,i,i,j],innerColor:[i,j,j,i]}},"ridge":{decorator:qx.ui.decoration.Double,style:{width:1,innerWidth:1,color:[i,j,j,i],innerColor:[j,i,i,j]}},"inset-thin":{decorator:qx.ui.decoration.Single,style:{width:1,color:[j,i,i,j]}},"outset-thin":{decorator:qx.ui.decoration.Single,style:{width:1,color:[i,j,j,i]}},"focused-inset":{decorator:qx.ui.decoration.Double,style:{width:1,innerWidth:1,color:[a,d,d,a],innerColor:[c,b,b,c]}},"focused-outset":{decorator:qx.ui.decoration.Double,style:{width:1,innerWidth:1,color:[b,c,c,b],innerColor:[d,a,a,d]}},"border-invalid":{decorator:qx.ui.decoration.Double,style:{width:1,innerWidth:1,color:[j,i,i,j],innerColor:u}},"separator-horizontal":{decorator:qx.ui.decoration.Single,style:{widthLeft:1,colorLeft:w}},"separator-vertical":{decorator:qx.ui.decoration.Single,style:{widthTop:1,colorTop:w}},"shadow":{decorator:qx.ui.decoration.Grid,style:{baseImage:s,insets:[4,8,8,4]}},"shadow-window":{decorator:qx.ui.decoration.Grid,style:{baseImage:s,insets:[4,8,8,4]}},"shadow-small":{decorator:qx.ui.decoration.Grid,style:{baseImage:m,insets:[0,3,3,0]}},"checkbox-invalid-shadow":{decorator:qx.ui.decoration.Beveled,style:{outerColor:u,innerColor:n,insets:[0]}},"lead-item":{decorator:qx.ui.decoration.Uniform,style:{width:1,style:x,color:l}},"tooltip":{decorator:qx.ui.decoration.Uniform,style:{width:1,color:v}},"tooltip-error":{decorator:qx.ui.decoration.Uniform,style:{width:1,color:v}},"toolbar-separator":{decorator:qx.ui.decoration.Single,style:{widthLeft:1,colorLeft:j}},"toolbar-part-handle":{decorator:qx.ui.decoration.Single,style:{width:1,style:f,colorTop:t,colorLeft:t,colorRight:j,colorBottom:j}},"menu-separator":{decorator:qx.ui.decoration.Single,style:{widthTop:1,widthBottom:1,colorTop:h,colorBottom:i}},"datechooser-date-pane":{decorator:qx.ui.decoration.Single,style:{widthTop:1,colorTop:e,style:f}},"datechooser-weekday":{decorator:qx.ui.decoration.Single,style:{widthBottom:1,colorBottom:e,style:f}},"datechooser-week":{decorator:qx.ui.decoration.Single,style:{widthRight:1,colorRight:e,style:f}},"datechooser-week-header":{decorator:qx.ui.decoration.Single,style:{widthBottom:1,colorBottom:e,widthRight:1,colorRight:e,style:f}},"tabview-page-button-top":{decorator:qx.ui.decoration.Double,style:{width:1,color:[g,h,h,g],innerWidth:1,innerColor:[i,j,j,i],widthBottom:0,innerWidthBottom:0}},"tabview-page-button-bottom":{decorator:qx.ui.decoration.Double,style:{width:1,color:[g,h,h,g],innerWidth:1,innerColor:[i,j,j,i],widthTop:0,innerWidthTop:0}},"tabview-page-button-left":{decorator:qx.ui.decoration.Double,style:{width:1,color:[g,h,h,g],innerWidth:1,innerColor:[i,j,j,i],widthRight:0,innerWidthRight:0}},"tabview-page-button-right":{decorator:qx.ui.decoration.Double,style:{width:1,color:[g,h,h,g],innerWidth:1,innerColor:[i,j,j,i],widthLeft:0,innerWidthLeft:0}},"table-statusbar":{decorator:qx.ui.decoration.Single,style:{widthTop:1,colorTop:j,styleTop:f}},"table-scroller-header":{decorator:qx.ui.decoration.Single,style:{widthBottom:1,colorBottom:y,styleBottom:f}},"table-scroller-focus-indicator":{decorator:qx.ui.decoration.Single,style:{width:2,color:p,style:f}},"table-header-cell":{decorator:qx.ui.decoration.Single,style:{widthRight:1,colorRight:y,styleRight:f}},"table-header-cell-hovered":{decorator:qx.ui.decoration.Single,style:{widthRight:1,colorRight:y,styleRight:f,widthBottom:2,colorBottom:q,styleBottom:f}}}});})();(function(){var i="Liberation Sans",h="Verdana",g="Bitstream Vera Sans",f="Lucida Grande",e="Tahoma",d="monospace",c="qx.theme.classic.Font",b="Courier New",a="DejaVu Sans Mono";qx.Theme.define(c,{fonts:{"default":{size:11,lineHeight:1.4,family:[f,e,h,g,i]},"bold":{size:11,lineHeight:1.4,family:[f,e,h,g,i],bold:true},"small":{size:10,lineHeight:1.4,family:[f,e,h,g,i]},"monospace":{size:11,lineHeight:1.4,family:[a,b,d]}}});})();(function(){var fy="button",fx="widget",fw="background",fv="atom",fu="inset-thin",ft="outset",fs="text-disabled",fr="text-selected",fq="inset",fp="image",es="groupbox",er="cell",eq="focused-inset",ep="tooltip",eo="menu-button",en="middle",em="decoration/arrows/down.gif",el="spinner",ek="background-selected",ej="list",fF="popup",fG="button-hovered",fD="checkbox",fE="toolbar-button",fB="button-frame",fC="textfield",fz="label",fA="background-invalid",fH="background-disabled",fI="bold",eX="white",eW="shadow-small",fa="invalid",eY="scrollbar",fc="center",fb="datechooser/button",fe="button-abandoned",fd="background-light",eV="main",eU="date-chooser",cJ="date-chooser-title",cK="radiobutton",cL="default",cM="combobox",cN="background-field",cO="outset-thin",cP="menu-slidebar-button",cQ="scrollbar/button",cR="combobox/button",cS="table-header-cell",fW="decoration/arrows/right.gif",fV="text",fU="decoration/arrows/down-small.gif",fT="icon/16/places/folder.png",gb="tree-folder",ga="slidebar/button-forward",fY="icon/16/mimetypes/text-plain.png",fX="right-top",gd="button-checked",gc=".png",dG="background-focused",dH="datechooser",dE="slidebar/button-backward",dF="selectbox",dK="decoration/arrows/up.gif",dL="treevirtual-folder",dI="checkbox-checked",dJ="decoration/form/",dC="decoration/tree/minus.gif",dD="",dl="decoration/tree/plus.gif",dk="-invalid",dn="decoration/arrows/left.gif",dm="icon/16/places/folder-open.png",dh="table-row-background-even",dg="decoration/treevirtual/cross_minus.gif",dj="radiobutton-hovered",di="keyboard-focus",df="decoration/treevirtual/start_plus.gif",de="decoration/cursors/",dQ="icon/16/actions/dialog-ok.png",dR="slidebar",dS="table-scroller-focus-indicator",dT="move-frame",dM="nodrop",dN="tabview-page-button-left",dO="decoration/arrows/up-small.gif",dP="move",dU="radiobutton-checked-focused",dV="qx.theme.classic.Appearance",dx="decoration/menu/checkbox.gif",dw="tooltip-error",dv="right",du="decoration/arrows/rewind.gif",dt="table-scroller-header",ds="table-pane",dr="focused-outset",dq="checkbox-hovered",dB="icon/16/actions/dialog-cancel.png",dA="menu-slidebar",dW="datechooser-date-pane",dX="background-pane",dY="decoration/treevirtual/cross_plus.gif",ea="qx/icon/Oxygen/16/actions/window-close.png",eb="datechooser-week",ec="icon/16/apps/office-calendar.png",ed="datechooser-weekday",ee="table-header-border",ef="table-header-cell-hover",eg="window-active-caption-text",ez="window-active-caption",ey="icon",ex="checkbox-checked-focused",ew="toolbar-separator",eD="groove",eC="checkbox-pressed",eB="tooltip-invalid",eA="decoration/window/restore.gif",eG="decoration/menu/checkbox-invert.gif",eF="scrollarea",eQ="window-inactive-caption-text",eR="best-fit",eO="up.gif",eP="keep-align",eM="tabview-page-button-right",eN="tabview-page-button-top",eK="tabview-page-button-bottom",eL="row-layer",eS="decoration/menu/radiobutton.gif",eT="decoration/arrows/",fi="decoration/table/descending.png",fh="tooltip-text",fk="checkbox-checked-hovered",fj="left.gif",fm="decoration/arrows/up-invert.gif",fl="alias",fo="decoration/arrows/right-invert.gif",fn="radiobutton-checked-disabled",fg="lead-item",ff="checkbox-focused",fP="border-dark",fQ="decoration/treevirtual/end_plus.gif",fR="decoration/treevirtual/start_minus.gif",fS="radiobutton-checked-hovered",fL="decoration/window/minimize.gif",fM="table-header-cell-hovered",fN="down.gif",fO="decoration/treevirtual/end.gif",fJ="decoration/treevirtual/end_minus.gif",fK="window-inactive-caption",cI="decoration/menu/radiobutton-invert.gif",cH="text-placeholder",cG="slider",cF="decoration/table/select-column-order.png",cE="decoration/arrows/next.gif",cD="table-header",cC="decoration/treevirtual/only_minus.gif",cB="datechooser-week-header",cA="decoration/window/maximize.gif",cz="decoration/treevirtual/only_plus.gif",cV="checkbox-checked-pressed",cW="decoration/arrows/down-invert.gif",cT="menu-separator",cU="decoration/splitpane/knob-vertical.png",da=".gif",db="decoration/arrows/forward.gif",cX="radiobutton-checked-pressed",cY="table-statusbar",dc="radiobutton-pressed",dd="copy",eH="table-row-background-selected",eE="radiobutton-focused",eJ="decoration/splitpane/knob-horizontal.png",eI="right.gif",eu="radiobutton-checked",et="decoration/treevirtual/cross.gif",dp="decoration/table/ascending.png",ev="decoration/treevirtual/line.gif",dz="date-chooser-selected",dy="toolbar-part-handle",eh="decoration/window/close.gif",ei="icon/16/actions/view-refresh.png";qx.Theme.define(dV,{appearances:{"widget":{},"label":{style:function(C){return {textColor:C.disabled?fs:undefined};}},"image":{style:function(cw){return {opacity:!cw.replacement&&cw.disabled?0.3:undefined};}},"atom":{},"atom/label":fz,"atom/icon":fp,"root":{style:function(bv){return {backgroundColor:fw,textColor:fV,font:cL};}},"popup":{style:function(a){return {decorator:eV,backgroundColor:dX,shadow:eW};}},"tooltip":{include:fF,style:function(j){return {backgroundColor:ep,textColor:fh,decorator:ep,shadow:eW,padding:[1,3,2,3],offset:[15,5,5,5]};}},"tooltip/atom":fv,"tooltip-error":{include:ep,style:function(bA){return {textColor:fr,showTimeout:100,hideTimeout:10000,decorator:dw,font:fI,backgroundColor:eB};}},"tooltip-error/atom":fv,"iframe":{style:function(cv){return {backgroundColor:eX,decorator:fq};}},"move-frame":{style:function(hb){return {decorator:eV};}},"resize-frame":dT,"dragdrop-cursor":{style:function(bU){var bV=dM;if(bU.copy){bV=dd;}else if(bU.move){bV=dP;}else if(bU.alias){bV=fl;}return {source:de+bV+da,position:fX,offset:[2,16,2,6]};}},"button-frame":{alias:fv,style:function(L){if(L.pressed||L.abandoned||L.checked){var N=!L.inner&&L.focused?eq:fq;var M=[4,3,2,5];}else{var N=!L.inner&&L.focused?dr:ft;var M=[3,4];}return {backgroundColor:L.abandoned?fe:L.hovered?fG:L.checked?gd:fy,decorator:N,padding:M};}},"button":{alias:fB,include:fB,style:function(cr){return {center:true};}},"hover-button":{alias:fv,include:fv,style:function(cl){return {backgroundColor:cl.hovered?ek:undefined,textColor:cl.hovered?fr:undefined};}},"splitbutton":{},"splitbutton/button":fy,"splitbutton/arrow":{alias:fy,include:fy,style:function(D){return {icon:em};}},"scrollarea/corner":{style:function(){return {backgroundColor:fw};}},"scrollarea":fx,"scrollarea/pane":fx,"scrollarea/scrollbar-x":eY,"scrollarea/scrollbar-y":eY,"list":{alias:eF,style:function(gN){var gR;var gP=!!gN.focused;var gQ=!!gN.invalid;var gO=!!gN.disabled;if(gQ&&!gO){gR=fA;}else if(gP&&!gQ&&!gO){gR=dG;}else if(gO){gR=fH;}else{gR=eX;}return {decorator:gN.focused?eq:fq,backgroundColor:gR};}},"listitem":{alias:fv,style:function(be){return {gap:4,padding:be.lead?[2,4]:[3,5],backgroundColor:be.selected?ek:undefined,textColor:be.selected?fr:undefined,decorator:be.lead?fg:undefined};}},"textfield":{style:function(Q){var V;var T=!!Q.focused;var U=!!Q.invalid;var R=!!Q.disabled;if(U&&!R){V=fA;}else if(T&&!U&&!R){V=dG;}else if(R){V=fH;}else{V=cN;}var S;if(Q.disabled){S=fs;}else if(Q.showingPlaceholder){S=cH;}else{S=undefined;}return {decorator:Q.focused?eq:fq,padding:[2,3],textColor:S,backgroundColor:V};}},"textarea":fC,"checkbox":{alias:fv,style:function(bG){var bI;if(bG.checked){if(bG.disabled){bI=dI;}else if(bG.focused){bI=ex;}else if(bG.pressed){bI=cV;}else if(bG.hovered){bI=fk;}else{bI=dI;}}else if(!bG.disabled){if(bG.focused){bI=ff;}else if(bG.pressed){bI=eC;}else if(bG.hovered){bI=dq;}}bI=bI||fD;var bH=bG.invalid&&!bG.disabled?dk:dD;return {icon:dJ+bI+bH+gc,gap:6};}},"radiobutton":{alias:fD,include:fD,style:function(gF){var gH;if(gF.checked&&gF.focused){gH=dU;}else if(gF.checked&&gF.disabled){gH=fn;}else if(gF.checked&&gF.pressed){gH=cX;}else if(gF.checked&&gF.hovered){gH=fS;}else if(gF.checked){gH=eu;}else if(gF.focused){gH=eE;}else if(gF.pressed){gH=dc;}else if(gF.hovered){gH=dj;}else{gH=cK;}var gG=gF.invalid&&!gF.disabled?dk:dD;return {icon:dJ+gH+gG+gc,shadow:undefined};}},"spinner":{style:function(gL){return {decorator:gL.focused?eq:fq,textColor:gL.disabled?fs:undefined};}},"spinner/textfield":{include:fC,style:function(cu){return {decorator:undefined,padding:[2,3]};}},"spinner/upbutton":{alias:fy,include:fy,style:function(bp){return {icon:dO,padding:bp.pressed?[2,2,0,4]:[1,3,1,3],backgroundColor:bp.hovered?fG:fy};}},"spinner/downbutton":{alias:fy,include:fy,style:function(bl){return {icon:fU,padding:bl.pressed?[2,2,0,4]:[1,3,1,3],backgroundColor:bl.hovered?fG:fy};}},"datefield":cM,"datefield/button":{alias:cR,include:cR,style:function(cx){return {icon:ec,padding:[0,3],backgroundColor:undefined,decorator:undefined};}},"datefield/list":{alias:dH,include:dH,style:function(ge){return {decorator:ge.focused?eq:fq};}},"groupbox":{style:function(bL){return {backgroundColor:fw};}},"groupbox/legend":{alias:fv,style:function(gU){return {backgroundColor:fw,textColor:gU.invalid?fa:undefined,paddingRight:4,paddingLeft:4,marginRight:10,marginLeft:10};}},"groupbox/frame":{style:function(ci){return {padding:[12,9],decorator:eD};}},"check-groupbox":es,"check-groupbox/legend":{alias:fD,include:fD,style:function(P){return {backgroundColor:fw,textColor:P.invalid?fa:undefined,paddingRight:3,paddingLeft:3,marginRight:10,marginLeft:10};}},"radio-groupbox":es,"radio-groupbox/legend":{alias:cK,include:cK,style:function(B){return {backgroundColor:fw,textColor:B.invalid?fa:undefined,paddingRight:3,paddingLeft:3,marginRight:10,marginLeft:10};}},"toolbar":{style:function(gJ){return {backgroundColor:fw};}},"toolbar/part":{},"toolbar/part/container":{},"toolbar/part/handle":{style:function(cf){return {decorator:dy,backgroundColor:fw,padding:[0,1],margin:[3,2],allowGrowY:true};}},"toolbar-separator":{style:function(bE){return {margin:[3,2],decorator:ew};}},"toolbar-button":{alias:fv,style:function(gi){if(gi.pressed||gi.checked||gi.abandoned){var gk=fu;var gj=[3,2,1,4];}else if(gi.hovered){var gk=cO;var gj=[2,3];}else{var gk=undefined;var gj=[3,4];}return {cursor:cL,decorator:gk,padding:gj,backgroundColor:gi.abandoned?fe:gi.checked?fd:fy};}},"toolbar-menubutton":{alias:fE,include:fE,style:function(W){return {showArrow:true};}},"toolbar-menubutton/arrow":{alias:fp,include:fp,style:function(co){return {source:fU};}},"toolbar-splitbutton":{},"toolbar-splitbutton/button":fE,"toolbar-splitbutton/arrow":{alias:fE,include:fE,style:function(gT){return {icon:em};}},"slidebar":{},"slidebar/scrollpane":{},"slidebar/content":{},"slidebar/button-forward":{alias:fy,include:fy,style:function(Y){return {icon:Y.vertical?em:cE};}},"slidebar/button-backward":{alias:fy,include:fy,style:function(ba){return {icon:ba.vertical?dK:dn};}},"tabview":{},"tabview/bar":{alias:dR,style:function(gx){var gy=0,gB=0,gz=0,gA=0;if(gx.barTop){gz=-2;}else if(gx.barBottom){gy=-2;}else if(gx.barRight){gA=-2;}else{gB=-2;}return {marginBottom:gz,marginTop:gy,marginLeft:gA,marginRight:gB};}},"tabview/bar/button-forward":{include:ga,alias:ga,style:function(bc){if(bc.barTop||bc.barBottom){return {marginTop:2,marginBottom:2};}else{return {marginLeft:2,marginRight:2};}}},"tabview/bar/button-backward":{include:dE,alias:dE,style:function(bk){if(bk.barTop||bk.barBottom){return {marginTop:2,marginBottom:2};}else{return {marginLeft:2,marginRight:2};}}},"tabview/pane":{style:function(O){return {backgroundColor:fw,decorator:ft,padding:10};}},"tabview-page":fx,"tabview-page/button":{style:function(r){var A;var y=0,w=0,t=0,v=0;if(r.barTop||r.barBottom){var u=2,s=2,x=6,z=6;}else{var u=6,s=6,x=6,z=6;}if(r.barTop){A=eN;}else if(r.barRight){A=eM;}else if(r.barBottom){A=eK;}else{A=dN;}if(r.checked){if(r.barTop||r.barBottom){x+=2;z+=2;}else{u+=2;s+=2;}}else{if(r.barTop||r.barBottom){t+=2;y+=2;}else if(r.barLeft||r.barRight){w+=2;v+=2;}}if(r.checked){if(!r.firstTab){if(r.barTop||r.barBottom){v=-4;}else{y=-4;}}if(!r.lastTab){if(r.barTop||r.barBottom){w=-4;}else{t=-4;}}}return {zIndex:r.checked?10:5,decorator:A,backgroundColor:fw,padding:[u,z,s,x],margin:[y,w,t,v]};}},"tabview-page/button/label":{alias:fz,style:function(c){return {padding:[0,1,0,1],margin:c.focused?0:1,decorator:c.focused?di:undefined};}},"tabview-page/button/icon":fp,"tabview-page/button/close-button":{alias:fv,style:function(k){return {icon:ea};}},"scrollbar":{},"scrollbar/slider":{alias:cG,style:function(gW){return {backgroundColor:fd};}},"scrollbar/slider/knob":{include:fB,style:function(l){return {height:14,width:14,minHeight:l.horizontal?undefined:9,minWidth:l.horizontal?9:undefined};}},"scrollbar/button":{alias:fy,include:fy,style:function(bW){var bX;if(bW.up||bW.down){if(bW.pressed||bW.abandoned||bW.checked){bX=[5,2,3,4];}else{bX=[4,3];}}else{if(bW.pressed||bW.abandoned||bW.checked){bX=[4,3,2,5];}else{bX=[3,4];}}var bY=eT;if(bW.left){bY+=fj;}else if(bW.right){bY+=eI;}else if(bW.up){bY+=eO;}else{bY+=fN;}return {padding:bX,icon:bY};}},"scrollbar/button-begin":cQ,"scrollbar/button-end":cQ,"slider":{style:function(E){var F;if(E.disabled){F=fH;}else if(E.invalid){F=fA;}else if(E.focused){F=fd;}else{F=cN;}return {backgroundColor:F,decorator:E.focused?eq:fq};}},"slider/knob":{include:fB,style:function(bt){return {width:14,height:14,decorator:ft};}},"tree-folder/open":{style:function(gv){return {source:gv.opened?dC:dl};}},"tree-folder":{style:function(bD){return {padding:[2,3,2,0],icon:bD.opened?dm:fT};}},"tree-folder/icon":{style:function(gp){return {padding:[0,4,0,0]};}},"tree-folder/label":{style:function(cn){return {padding:[1,2],backgroundColor:cn.selected?ek:undefined,textColor:cn.selected?fr:undefined};}},"tree-file":{include:gb,alias:gb,style:function(i){return {icon:fY};}},"tree":{include:ej,alias:ej,style:function(hc){return {contentPadding:[4,4,4,4]};}},"treevirtual":{style:function(bS){return {decorator:eV};}},"treevirtual-folder":{style:function(gn){return {icon:(gn.opened?dm:fT)};}},"treevirtual-file":{include:dL,alias:dL,style:function(bd){return {icon:fY};}},"treevirtual-line":{style:function(gu){return {icon:ev};}},"treevirtual-contract":{style:function(cy){return {icon:dC};}},"treevirtual-expand":{style:function(h){return {icon:dl};}},"treevirtual-only-contract":{style:function(gD){return {icon:cC};}},"treevirtual-only-expand":{style:function(gS){return {icon:cz};}},"treevirtual-start-contract":{style:function(go){return {icon:fR};}},"treevirtual-start-expand":{style:function(cq){return {icon:df};}},"treevirtual-end-contract":{style:function(bR){return {icon:fJ};}},"treevirtual-end-expand":{style:function(bO){return {icon:fQ};}},"treevirtual-cross-contract":{style:function(bx){return {icon:dg};}},"treevirtual-cross-expand":{style:function(bK){return {icon:dY};}},"treevirtual-end":{style:function(q){return {icon:fO};}},"treevirtual-cross":{style:function(f){return {icon:et};}},"window":{style:function(cb){return {contentPadding:[10,10,10,10],backgroundColor:fw,decorator:cb.maximized?undefined:ft,shadow:cb.maximized?undefined:eW};}},"window/pane":{},"window/captionbar":{style:function(e){return {padding:1,backgroundColor:e.active?ez:fK,textColor:e.active?eg:eQ};}},"window/icon":{style:function(J){return {marginRight:4};}},"window/title":{style:function(bB){return {cursor:cL,font:fI,marginRight:20,alignY:en};}},"window/minimize-button":{include:fy,alias:fy,style:function(cm){return {icon:fL,padding:cm.pressed||cm.abandoned?[2,1,0,3]:[1,2]};}},"window/restore-button":{include:fy,alias:fy,style:function(H){return {icon:eA,padding:H.pressed||H.abandoned?[2,1,0,3]:[1,2]};}},"window/maximize-button":{include:fy,alias:fy,style:function(gV){return {icon:cA,padding:gV.pressed||gV.abandoned?[2,1,0,3]:[1,2]};}},"window/close-button":{include:fy,alias:fy,style:function(bw){return {marginLeft:2,icon:eh,padding:bw.pressed||bw.abandoned?[2,1,0,3]:[1,2]};}},"window/statusbar":{style:function(gE){return {decorator:fu,padding:[2,6]};}},"window/statusbar-text":fz,"resizer":{style:function(o){return {decorator:ft};}},"splitpane":{},"splitpane/splitter":{style:function(bo){return {backgroundColor:fw};}},"splitpane/splitter/knob":{style:function(bg){return {source:bg.horizontal?eJ:cU,padding:2};}},"splitpane/slider":{style:function(cp){return {backgroundColor:fP,opacity:0.3};}},"selectbox":{include:fB,style:function(br){var bs=fy;if(br.invalid&&!br.disabled){bs=fA;}else if(br.abandoned){bs=fe;}else if(!br.abandoned&&br.hovered){bs=fG;}else if(!br.abandoned&&!br.hovered&&br.checked){bs=gd;}return {backgroundColor:bs};}},"selectbox/atom":fv,"selectbox/popup":fF,"selectbox/list":ej,"selectbox/arrow":{include:fp,style:function(bn){return {source:em,paddingRight:4,paddingLeft:5};}},"datechooser":{style:function(d){return {decorator:ft};}},"datechooser/navigation-bar":{style:function(gr){return {backgroundColor:eU,textColor:gr.disabled?fs:gr.invalid?fa:undefined,padding:[2,10]};}},"datechooser/last-year-button-tooltip":ep,"datechooser/last-month-button-tooltip":ep,"datechooser/next-year-button-tooltip":ep,"datechooser/next-month-button-tooltip":ep,"datechooser/last-year-button":fb,"datechooser/last-month-button":fb,"datechooser/next-year-button":fb,"datechooser/next-month-button":fb,"datechooser/button/icon":{},"datechooser/button":{style:function(cg){var ch={width:17,show:ey};if(cg.lastYear){ch.icon=du;}else if(cg.lastMonth){ch.icon=dn;}else if(cg.nextYear){ch.icon=db;}else if(cg.nextMonth){ch.icon=fW;}if(cg.pressed||cg.checked||cg.abandoned){ch.decorator=fu;}else if(cg.hovered){ch.decorator=cO;}else{ch.decorator=undefined;}if(cg.pressed||cg.checked||cg.abandoned){ch.padding=[2,0,0,2];}else if(cg.hovered){ch.padding=1;}else{ch.padding=2;}return ch;}},"datechooser/month-year-label":{style:function(bJ){return {font:fI,textAlign:fc};}},"datechooser/date-pane":{style:function(ck){return {decorator:dW,backgroundColor:eU};}},"datechooser/weekday":{style:function(cs){return {decorator:ed,font:fI,textAlign:fc,textColor:cs.disabled?fs:cs.weekend?cJ:eU,backgroundColor:cs.weekend?eU:cJ};}},"datechooser/day":{style:function(gq){return {textAlign:fc,decorator:gq.today?eV:undefined,textColor:gq.disabled?fs:gq.selected?fr:gq.otherMonth?fs:undefined,backgroundColor:gq.disabled?undefined:gq.selected?dz:undefined,padding:[2,4]};}},"datechooser/week":{style:function(I){return {textAlign:fc,textColor:cJ,padding:[2,4],decorator:I.header?cB:eb};}},"combobox":{style:function(gl){var gm;if(gl.disabled){gm=fH;}else if(gl.invalid){gm=fA;}else if(gl.focused){gm=fd;}else{gm=cN;}return {decorator:gl.focused?eq:fq,textColor:gl.disabled?fs:undefined,backgroundColor:gm};}},"combobox/button":{alias:fy,include:fy,style:function(ct){return {icon:em,backgroundColor:ct.hovered?fG:fy};}},"combobox/popup":fF,"combobox/list":ej,"combobox/textfield":{include:fC,style:function(gK){return {decorator:undefined,padding:[2,3],backgroundColor:undefined};}},"menu":{style:function(bh){var bi={backgroundColor:fw,shadow:eW,decorator:ft,spacingX:6,spacingY:1,iconColumnWidth:16,arrowColumnWidth:4,padding:1,placementModeY:bh.submenu||bh.contextmenu?eR:eP};if(bh.submenu){bi.position=fX;bi.offset=[-2,-3];}if(bh.contextmenu){bi.offset=4;}return bi;}},"menu/slidebar":dA,"menu-slidebar":fx,"menu-slidebar-button":{style:function(K){return {backgroundColor:K.hovered?ek:undefined,padding:6,center:true};}},"menu-slidebar/button-backward":{include:cP,style:function(p){return {icon:p.hovered?fm:dK};}},"menu-slidebar/button-forward":{include:cP,style:function(bj){return {icon:bj.hovered?cW:em};}},"menu-separator":{style:function(by){return {height:0,decorator:cT,marginTop:4,marginBottom:4,marginLeft:2,marginRight:2};}},"menu-button":{alias:fv,style:function(gw){return {backgroundColor:gw.selected?ek:undefined,textColor:gw.selected?fr:undefined,padding:[2,6]};}},"menu-button/icon":{include:fp,style:function(bF){return {alignY:en};}},"menu-button/label":{include:fz,style:function(bf){return {alignY:en,padding:1};}},"menu-button/shortcut":{include:fz,style:function(bQ){return {alignY:en,marginLeft:14,padding:1};}},"menu-button/arrow":{include:fp,style:function(X){return {source:X.selected?fo:fW,alignY:en};}},"menu-checkbox":{alias:eo,include:eo,style:function(m){return {icon:!m.checked?undefined:m.selected?eG:dx};}},"menu-radiobutton":{alias:eo,include:eo,style:function(ca){return {icon:!ca.checked?undefined:ca.selected?cI:eS};}},"menubar":{style:function(b){return {backgroundColor:fw,decorator:ft};}},"menubar-button":{alias:fv,style:function(cj){return {padding:[2,6],backgroundColor:cj.pressed||cj.hovered?ek:undefined,textColor:cj.pressed||cj.hovered?fr:undefined};}},"colorselector":fx,"colorselector/control-bar":fx,"colorselector/visual-pane":es,"colorselector/control-pane":fx,"colorselector/preset-grid":fx,"colorselector/colorbucket":{style:function(gs){return {decorator:fu,width:16,height:16};}},"colorselector/preset-field-set":es,"colorselector/input-field-set":es,"colorselector/preview-field-set":es,"colorselector/hex-field-composite":fx,"colorselector/hex-field":fC,"colorselector/rgb-spinner-composite":fx,"colorselector/rgb-spinner-red":el,"colorselector/rgb-spinner-green":el,"colorselector/rgb-spinner-blue":el,"colorselector/hsb-spinner-composite":fx,"colorselector/hsb-spinner-hue":el,"colorselector/hsb-spinner-saturation":el,"colorselector/hsb-spinner-brightness":el,"colorselector/preview-content-old":{style:function(bb){return {decorator:fu,width:50,height:10};}},"colorselector/preview-content-new":{style:function(gt){return {decorator:fu,backgroundColor:eX,width:50,height:10};}},"colorselector/hue-saturation-field":{style:function(gg){return {decorator:fu,margin:5};}},"colorselector/brightness-field":{style:function(gf){return {decorator:fu,margin:[5,7]};}},"colorselector/hue-saturation-pane":fx,"colorselector/hue-saturation-handle":fx,"colorselector/brightness-pane":fx,"colorselector/brightness-handle":fx,"table":fx,"table/statusbar":{style:function(G){return {decorator:cY,paddingLeft:2,paddingRight:2};}},"table/column-button":{alias:fy,style:function(gX){var ha,gY;if(gX.pressed||gX.checked||gX.abandoned){ha=fu;gY=[3,2,1,4];}else if(gX.hovered){ha=cO;gY=[2,3];}else{ha=undefined;gY=[3,4];}return {decorator:ha,padding:gY,backgroundColor:gX.abandoned?fe:fy,icon:cF};}},"table-column-reset-button":{extend:eo,alias:eo,style:function(){return {icon:ei};}},"table-scroller/scrollbar-x":eY,"table-scroller/scrollbar-y":eY,"table-scroller":fx,"table-scroller/header":{style:function(bP){return {decorator:dt,backgroundColor:cD};}},"table-scroller/pane":{style:function(n){return {backgroundColor:ds};}},"table-scroller/focus-indicator":{style:function(bz){return {decorator:dS};}},"table-scroller/resize-line":{style:function(bN){return {backgroundColor:ee,width:3};}},"table-header-cell":{alias:fv,style:function(ce){return {minWidth:13,paddingLeft:2,paddingRight:2,paddingBottom:ce.hovered?0:2,decorator:ce.hovered?fM:cS,backgroundColor:ce.hovered?ef:cS,sortIcon:ce.sorted?(ce.sortedAscending?dp:fi):undefined};}},"table-header-cell/sort-icon":{style:function(gM){return {alignY:en};}},"table-editor-textfield":{include:fC,style:function(gC){return {decorator:undefined,padding:[2,2]};}},"table-editor-selectbox":{include:dF,alias:dF,style:function(bM){return {padding:[0,2]};}},"table-editor-combobox":{include:cM,alias:cM,style:function(bq){return {decorator:undefined};}},"colorpopup":{alias:fF,include:fF,style:function(bm){return {decorator:ft,padding:5,backgroundColor:fw};}},"colorpopup/field":{style:function(bC){return {decorator:fu,margin:2,width:14,height:14,backgroundColor:fw};}},"colorpopup/selector-button":fy,"colorpopup/auto-button":fy,"colorpopup/preview-pane":es,"colorpopup/current-preview":{style:function(cd){return {height:20,padding:4,marginLeft:4,decorator:fu,allowGrowX:true};}},"colorpopup/selected-preview":{style:function(g){return {height:20,padding:4,marginRight:4,decorator:fu,allowGrowX:true};}},"colorpopup/colorselector-okbutton":{alias:fy,include:fy,style:function(gh){return {icon:dQ};}},"colorpopup/colorselector-cancelbutton":{alias:fy,include:fy,style:function(bT){return {icon:dB};}},"virtual-list":ej,"virtual-list/row-layer":eL,"row-layer":fx,"column-layer":fx,"cell":{style:function(bu){return {backgroundColor:bu.selected?eH:dh,textColor:bu.selected?fr:fV,padding:[3,6]};}},"cell-string":er,"cell-number":{include:er,style:function(gI){return {textAlign:dv};}},"cell-image":er,"cell-boolean":er,"cell-atom":er,"cell-date":er,"cell-html":er,"htmlarea":{"include":fx,style:function(cc){return {backgroundColor:eX};}}}});})();(function(){var c="Oxygen",b="qx.theme.icon.Oxygen",a="qx/icon/Oxygen";qx.Theme.define(b,{title:c,aliases:{"icon":a},icons:{}});})();(function(){var b="Classic Windows",a="qx.theme.Classic";qx.Theme.define(a,{title:b,meta:{color:qx.theme.classic.Color,decoration:qx.theme.classic.Decoration,font:qx.theme.classic.Font,appearance:qx.theme.classic.Appearance,icon:qx.theme.icon.Oxygen}});})();(function(){var E='px;',D="",C="Boolean",B='',A='px',z='</div>',y='<div style="position:absolute;',x=";",w='left:',v='">',bt='</span>',bs='background-image:url(',br="treevirtual-start-contract",bq='">&nbsp;</div>',bp="treevirtual-file",bo="qx.ui.treevirtual.SimpleTreeDataCellRenderer",bn="qx.client",bm="treevirtual-only-expand",bl='style="',bk='top:0;',L='background-repeat:no-repeat;',M='>',J='right:',K='<div style="',H='" title="',I="treevirtual-end",F="treevirtual-cross",G=');',P='<span',Q="treevirtual-end-contract",X=';width:',V=';"',bc="treevirtual-end-expand",ba="treevirtual-only-contract",bg="qx.dynlocale",be="treevirtual-contract",S='top:',bj="content-box",bi='bottom:',bh="treevirtual-start-expand",R="on",T="mshtml",U="treevirtual-cross-contract",W="treevirtual-folder",Y='width:',bb="treevirtual-expand",bd="treevirtual-cross-expand",bf="treevirtual-line",N=';height:',O='height:';qx.Class.define(bo,{extend:qx.ui.table.cellrenderer.Abstract,construct:function(){var bS=qx.ui.treevirtual.SimpleTreeDataCellRenderer;if(bS.__pE){bS.__pJ();bS.__pE=false;}qx.ui.table.cellrenderer.Abstract.call(this);this.__pF=qx.util.AliasManager.getInstance();this.__pG=qx.util.ResourceManager.getInstance();this.__pH=qx.theme.manager.Appearance.getInstance();this.BLANK=this.__pG.toUri(this.__pF.resolve("static/blank.gif"));},statics:{__pI:{},__pE:true,__pJ:function(){qx.theme.manager.Meta.getInstance().initialize();var p=qx.ui.treevirtual.SimpleTreeDataCellRenderer;var s=qx.io.ImageLoader;var q=qx.util.AliasManager.getInstance();var t=qx.util.ResourceManager.getInstance();var r=qx.theme.manager.Appearance.getInstance();var u=function(f){s.load(t.toUri(q.resolve(f)));};p.__pI.line=r.styleFrom(bf);u(p.__pI.line.icon);p.__pI.contract=r.styleFrom(be);u(p.__pI.contract.icon);p.__pI.expand=r.styleFrom(bb);u(p.__pI.expand.icon);p.__pI.onlyContract=r.styleFrom(ba);u(p.__pI.onlyContract.icon);p.__pI.onlyExpand=r.styleFrom(bm);u(p.__pI.onlyExpand.icon);p.__pI.startContract=r.styleFrom(br);u(p.__pI.startContract.icon);p.__pI.startExpand=r.styleFrom(bh);u(p.__pI.startExpand.icon);p.__pI.endContract=r.styleFrom(Q);u(p.__pI.endContract.icon);p.__pI.endExpand=r.styleFrom(bc);u(p.__pI.endExpand.icon);p.__pI.crossContract=r.styleFrom(U);u(p.__pI.crossContract.icon);p.__pI.crossExpand=r.styleFrom(bd);u(p.__pI.crossExpand.icon);p.__pI.end=r.styleFrom(I);u(p.__pI.end.icon);p.__pI.cross=r.styleFrom(F);u(p.__pI.cross.icon);}},properties:{useTreeLines:{check:C,init:true},excludeFirstLevelTreeLines:{check:C,init:false},alwaysShowOpenCloseSymbol:{check:C,init:false}},members:{__pF:null,__pH:null,__pG:null,_getCellStyle:function(cb){var cc=cb.value;var cd=qx.ui.table.cellrenderer.Abstract.prototype._getCellStyle.call(this,cb)+(cc.cellStyle?cc.cellStyle+x:D);return cd;},_getContentHtml:function(bC){var bE=D;var bF=0;var bH=this._addExtraContentBeforeIndentation(bC,bF);bE+=bH.html;bF=bH.pos;var bG=this._addIndentation(bC,bF);bE+=bG.html;bF=bG.pos;bH=this._addExtraContentBeforeIcon(bC,bF);bE+=bH.html;bF=bH.pos;var bD=this._addIcon(bC,bF);bE+=bD.html;bF=bD.pos;bH=this._addExtraContentBeforeLabel(bC,bF);bE+=bH.html;bF=bH.pos;bE+=this._addLabel(bC,bF);return bE;},_addImage:function(a){var c=[];var b=this.__pG.toUri(this.__pF.resolve(a.url));if(a.position){var d=a.position;c.push(y);if(!qx.core.Variant.isSet(bn,T)){c.push(qx.bom.element.BoxSizing.compile(bj));}if(d.top!==undefined){c.push(S+d.top+E);}if(d.right!==undefined){c.push(J+d.right+E);}if(d.bottom!==undefined){c.push(bi+d.bottom+E);}if(d.left!==undefined){c.push(w+d.left+E);}if(d.width!==undefined){c.push(Y+d.width+E);}if(d.height!==undefined){c.push(O+d.height+E);}c.push(v);}c.push(K);c.push(bs+b+G);c.push(L);if(a.imageWidth&&a.imageHeight){c.push(X+a.imageWidth+A+N+a.imageHeight+A);}var e=a.tooltip;if(e!=null){c.push(H+e);}c.push(bq);if(a.position){c.push(z);}return c.join(D);},_addIndentation:function(bu,bv){var bw=bu.value;var bx;var by=D;var bB=this.getUseTreeLines();var bz=this.getExcludeFirstLevelTreeLines();var bA=this.getAlwaysShowOpenCloseSymbol();for(var i=0;i<bw.level;i++){bx=this._getIndentSymbol(i,bw,bB,bA,bz);by+=this._addImage({url:bx.icon,position:{top:0+(bx.paddingTop||0),left:bv+(bx.paddingLeft||0),width:19,height:16}});bv+=19;}return ({html:by,pos:bv});},_addIcon:function(bK,bL){var bM=bK.value;var bO=(bM.bSelected?bM.iconSelected:bM.icon);if(!bO){if(bM.type==qx.ui.treevirtual.SimpleTreeDataModel.Type.LEAF){var o=this.__pH.styleFrom(bp);}else{var bN={opened:bM.bOpened};var o=this.__pH.styleFrom(W,bN);}bO=o.icon;}var bP=this._addImage({url:bO,position:{top:0,left:bL,width:19,height:16}});return ({html:bP,pos:bL+19});},_addLabel:function(bT,bU){var bV=bT.value;var bX=bV.label;if(qx.core.Variant.isSet(bg,R)){if(bX&&bX.translate){bX=bX.translate();}}var bW=y+w+bU+E+bk+(bV.labelStyle?bV.labelStyle+x:D)+v+P+(bT.labelSpanStyle?bl+bT.labelSpanStyle+V:D)+M+bX+bt+z;return bW;},_addExtraContentBeforeIndentation:function(bQ,bR){return {html:B,pos:bR};},_addExtraContentBeforeIcon:function(bI,bJ){return {html:B,pos:bJ};},_addExtraContentBeforeLabel:function(bY,ca){return {html:B,pos:ca};},_getIndentSymbol:function(g,h,j,k,l){var m=qx.ui.treevirtual.SimpleTreeDataCellRenderer;if(g==0&&l){j=false;}if(g<h.level-1){return (j&&!h.lastChild[g]?m.__pI.line:{icon:this.BLANK});}var n=h.lastChild[h.lastChild.length-1];if(h.type==qx.ui.treevirtual.SimpleTreeDataModel.Type.BRANCH&&!h.bHideOpenClose){if(h.children.length>0||k){if(!j){return (h.bOpened?m.__pI.contract:m.__pI.expand);}if(g==0&&h.bFirstChild){if(n){return (h.bOpened?m.__pI.onlyContract:m.__pI.onlyExpand);}else{return (h.bOpened?m.__pI.startContract:m.__pI.startExpand);}}if(n){return (h.bOpened?m.__pI.endContract:m.__pI.endExpand);}return (h.bOpened?m.__pI.crossContract:m.__pI.crossExpand);}}if(j){if(h.parentNodeId==0){if(n&&h.bFirstChild){return {icon:this.BLANK};}if(n){return m.__pI.end;}if(h.bFirstChild){return (h.bOpened?m.__pI.startContract:m.__pI.startExpand);}}return (n?m.__pI.end:m.__pI.cross);}return {icon:this.BLANK};}},destruct:function(){this.__pF=this.__pG=this.__pH=null;}});})();(function(){var p="_applyStyle",o="stretch",n="Integer",m="px",l=" ",k="repeat",j="round",i="shorthand",h="px ",g="sliceBottom",E=";'></div>",D="<div style='",C="sliceLeft",B="sliceRight",A="repeatX",z="String",y="qx.ui.decoration.css3.BorderImage",x="border-box",w="",v='") ',t="sliceTop",u='url("',r="hidden",s="repeatY",q="absolute";qx.Class.define(y,{extend:qx.ui.decoration.Abstract,construct:function(F,G){qx.ui.decoration.Abstract.call(this);if(F!=null){this.setBorderImage(F);}if(G!=null){this.setSlice(G);}},statics:{IS_SUPPORTED:qx.bom.element.Style.isPropertySupported("borderImage")},properties:{borderImage:{check:z,nullable:true,apply:p},sliceTop:{check:n,init:0,apply:p},sliceRight:{check:n,init:0,apply:p},sliceBottom:{check:n,init:0,apply:p},sliceLeft:{check:n,init:0,apply:p},slice:{group:[t,B,g,C],mode:i},repeatX:{check:[o,k,j],init:o,apply:p},repeatY:{check:[o,k,j],init:o,apply:p},repeat:{group:[A,s],mode:i}},members:{__pK:null,_getDefaultInsets:function(){return {top:0,right:0,bottom:0,left:0};},_isInitialized:function(){return !!this.__pK;},getMarkup:function(){if(this.__pK){return this.__pK;}var d=this._resolveImageUrl(this.getBorderImage());var e=[this.getSliceTop(),this.getSliceRight(),this.getSliceBottom(),this.getSliceLeft()];var f=[this.getRepeatX(),this.getRepeatY()].join(l);this.__pK=[D,qx.bom.element.Style.compile({"borderImage":u+d+v+e.join(l)+l+f,position:q,lineHeight:0,fontSize:0,overflow:r,boxSizing:x,borderWidth:e.join(h)+m}),E].join(w);return this.__pK;},resize:function(H,I,J){H.style.width=I+m;H.style.height=J+m;},tint:function(b,c){},_applyStyle:function(){{};},_resolveImageUrl:function(a){return qx.util.ResourceManager.getInstance().toUri(qx.util.AliasManager.getInstance().resolve(a));}},destruct:function(){this.__pK=null;}});})();(function(){var v="px",u="0px",t="-1px",s="no-repeat",r="scale-x",q="scale-y",p="-tr",o="-l",n='</div>',m="scale",J="qx.client",I="-br",H="-t",G="-tl",F="-r",E='<div style="position:absolute;top:0;left:0;overflow:hidden;font-size:0;line-height:0;">',D="_applyBaseImage",C="-b",B="String",A="",y="-bl",z="qx.ui.decoration.GridDiv",w="-c",x="mshtml";qx.Class.define(z,{extend:qx.ui.decoration.Abstract,construct:function(S,T){qx.ui.decoration.Abstract.call(this);if(S!=null){this.setBaseImage(S);}if(T!=null){this.setInsets(T);}},properties:{baseImage:{check:B,nullable:true,apply:D}},members:{__pL:null,__pM:null,__pN:null,_getDefaultInsets:function(){return {top:0,right:0,bottom:0,left:0};},_isInitialized:function(){return !!this.__pL;},getMarkup:function(){if(this.__pL){return this.__pL;}var O=qx.bom.element.Decoration;var P=this.__pM;var Q=this.__pN;var R=[];R.push(E);R.push(O.create(P.tl,s,{top:0,left:0}));R.push(O.create(P.t,r,{top:0,left:Q.left+v}));R.push(O.create(P.tr,s,{top:0,right:0}));R.push(O.create(P.bl,s,{bottom:0,left:0}));R.push(O.create(P.b,r,{bottom:0,left:Q.left+v}));R.push(O.create(P.br,s,{bottom:0,right:0}));R.push(O.create(P.l,q,{top:Q.top+v,left:0}));R.push(O.create(P.c,m,{top:Q.top+v,left:Q.left+v}));R.push(O.create(P.r,q,{top:Q.top+v,right:0}));R.push(n);return this.__pL=R.join(A);},resize:function(b,c,d){var e=this.__pN;var innerWidth=c-e.left-e.right;var innerHeight=d-e.top-e.bottom;if(innerWidth<0){innerWidth=0;}if(innerHeight<0){innerHeight=0;}b.style.width=c+v;b.style.height=d+v;b.childNodes[1].style.width=innerWidth+v;b.childNodes[4].style.width=innerWidth+v;b.childNodes[7].style.width=innerWidth+v;b.childNodes[6].style.height=innerHeight+v;b.childNodes[7].style.height=innerHeight+v;b.childNodes[8].style.height=innerHeight+v;if(qx.core.Variant.isSet(J,x)){if(qx.bom.client.Engine.VERSION<7||(qx.bom.client.Feature.QUIRKS_MODE&&qx.bom.client.Engine.VERSION<8)){if(c%2==1){b.childNodes[2].style.marginRight=t;b.childNodes[5].style.marginRight=t;b.childNodes[8].style.marginRight=t;}else{b.childNodes[2].style.marginRight=u;b.childNodes[5].style.marginRight=u;b.childNodes[8].style.marginRight=u;}if(d%2==1){b.childNodes[3].style.marginBottom=t;b.childNodes[4].style.marginBottom=t;b.childNodes[5].style.marginBottom=t;}else{b.childNodes[3].style.marginBottom=u;b.childNodes[4].style.marginBottom=u;b.childNodes[5].style.marginBottom=u;}}}},tint:function(M,N){},_applyBaseImage:function(f,g){{};if(f){var k=this._resolveImageUrl(f);var l=/(.*)(\.[a-z]+)$/.exec(k);var j=l[1];var i=l[2];var h=this.__pM={tl:j+G+i,t:j+H+i,tr:j+p+i,bl:j+y+i,b:j+C+i,br:j+I+i,l:j+o+i,c:j+w+i,r:j+F+i};this.__pN=this._computeEdgeSizes(h);}},_resolveImageUrl:function(a){return qx.util.AliasManager.getInstance().resolve(a);},_computeEdgeSizes:function(K){var L=qx.util.ResourceManager.getInstance();return {top:L.getImageHeight(K.t),bottom:L.getImageHeight(K.b),left:L.getImageWidth(K.l),right:L.getImageWidth(K.r)};}},destruct:function(){this.__pL=this.__pM=this.__pN=null;}});})();(function(){var i="_applyTheme",h="qx.theme",g="qx.theme.manager.Meta",f="qx.theme.Modern",e="Theme",d="singleton";qx.Class.define(g,{type:d,extend:qx.core.Object,properties:{theme:{check:e,nullable:true,apply:i}},members:{_applyTheme:function(j,k){var n=null;var q=null;var t=null;var u=null;var p=null;if(j){n=j.meta.color||null;q=j.meta.decoration||null;t=j.meta.font||null;u=j.meta.icon||null;p=j.meta.appearance||null;}var r=qx.theme.manager.Color.getInstance();var s=qx.theme.manager.Decoration.getInstance();var l=qx.theme.manager.Font.getInstance();var o=qx.theme.manager.Icon.getInstance();var m=qx.theme.manager.Appearance.getInstance();r.setTheme(n);s.setTheme(q);l.setTheme(t);o.setTheme(u);m.setTheme(p);},initialize:function(){var b=qx.core.Setting;var a,c;a=b.get(h);if(a){c=qx.Theme.getByName(a);if(!c){throw new Error("The theme to use is not available: "+a);}this.setTheme(c);}}},settings:{"qx.theme":f}});})();(function(){var e="qx.theme.manager.Icon",d="Theme",c="changeTheme",b="_applyTheme",a="singleton";qx.Class.define(e,{type:a,extend:qx.core.Object,properties:{theme:{check:d,nullable:true,apply:b,event:c}},members:{_applyTheme:function(f,g){var i=qx.util.AliasManager.getInstance();if(g){for(var h in g.aliases){i.remove(h);}}if(f){for(var h in f.aliases){i.add(h,f.aliases[h]);}}}}});})();(function(){var a="qx.ui.treevirtual.DefaultDataCellRenderer";qx.Class.define(a,{extend:qx.ui.table.cellrenderer.Default});})();(function(){var i="qx.ui.treevirtual.SimpleTreeDataRowRenderer";qx.Class.define(i,{extend:qx.ui.table.rowrenderer.Default,construct:function(){qx.ui.table.rowrenderer.Default.call(this);},members:{updateDataRowElement:function(a,b){var e=a.table;var g=a.rowData;var f=e.getTableModel();var d=f.getTreeColumn();var c=g[d];a.selected=c.bSelected;if(c.bSelected){var h=a.row;e.getSelectionModel()._addSelectionInterval(h,h);}qx.ui.table.rowrenderer.Default.prototype.updateDataRowElement.call(this,a,b);}}});})();(function(){var m="qx.ui.treevirtual.SelectionManager",l="Space",k="Enter";qx.Class.define(m,{extend:qx.ui.table.selection.Manager,construct:function(n){qx.ui.table.selection.Manager.call(this);this.__pO=n;},members:{__pO:null,getTable:function(){return this.__pO;},_handleSelectEvent:function(e,f){var j=this;function g(o,p,q){var B=o.getDataModel();var v=B.getTreeColumn();var t=o.getFocusedColumn();if(t!=v){return false;}if(q instanceof qx.event.type.Mouse){if(!o.getFocusCellOnMouseMove()){var u=o._getPaneScrollerArr();for(var i=0;i<u.length;i++){u[i]._focusCellAtPagePos(q.getViewportLeft(),q.getViewportTop());}}}var r=B.getNode(o.getFocusedRow());if(!r){return false;}if(q instanceof qx.event.type.Mouse){var w=o.getTableColumnModel();var z=w._getColToXPosMap();var C=qx.bom.element.Location.getLeft(o.getContentElement().getDomElement());for(var i=0;i<z[v].visX;i++){C+=w.getColumnWidth(z[i].visX);}var x=q.getViewportLeft();var y=2;var s=C+(r.level-1)*19+2;if(x>=s-y&&x<=s+19+y){B.setState(r,{bOpened:!r.bOpened});return o.getOpenCloseClickSelectsRow()?false:true;}else{return j._handleExtendedClick(o,q,r,C);}}else{var A=q.getKeyIdentifier();switch(A){case l:return false;case k:if(!r.bHideOpenClose){B.setState(r,{bOpened:!r.bOpened});}return o.getOpenCloseClickSelectsRow()?false:true;default:return true;}}}var h=g(this.__pO,e,f);if(!h){qx.ui.table.selection.Manager.prototype._handleSelectEvent.call(this,e,f);}},_handleExtendedClick:function(a,b,c,d){return false;}},destruct:function(){this.__pO=null;}});})();(function(){var s="appear",r="columnVisibilityMenuCreateEnd",q="tableWidthChanged",p="verticalScrollBarChanged",n="qx.ui.table.columnmodel.resizebehavior.Abstract",m="qx.ui.table.columnmodel.Resize",l="_applyBehavior",k="separator",j="visibilityChanged",i="Reset column widths",f="changeBehavior",h="user-button",g="widthChanged",e="execute";qx.Class.define(m,{extend:qx.ui.table.columnmodel.Basic,include:qx.locale.MTranslation,construct:function(){qx.ui.table.columnmodel.Basic.call(this);this.__pP=false;this.__pQ=false;},properties:{behavior:{check:n,init:null,nullable:true,apply:l,event:f}},members:{__pQ:null,__pP:null,__pR:null,_applyBehavior:function(c,d){if(d!=null){d.dispose();d=null;}c._setNumColumns(this.getOverallColumnCount());c.setTableColumnModel(this);},init:function(a,b){qx.ui.table.columnmodel.Basic.prototype.init.call(this,a);if(this.__pR==null){this.__pR=b;b.addListener(s,this._onappear,this);b.addListener(q,this._onTableWidthChanged,this);b.addListener(p,this._onverticalscrollbarchanged,this);b.addListener(r,this._addResetColumnWidthButton,this);this.addListener(g,this._oncolumnwidthchanged,this);this.addListener(j,this._onvisibilitychanged,this);}if(this.getBehavior()==null){this.setBehavior(new qx.ui.table.columnmodel.resizebehavior.Default());}this.getBehavior()._setNumColumns(a);},getTable:function(){return this.__pR;},_addResetColumnWidthButton:function(event){var v=event.getData();var u=v.columnButton;var t=v.menu;var o;o=u.factory(k);t.add(o);o=u.factory(h,{text:this.tr(i)});t.add(o);o.addListener(e,this._onappear,this);},_onappear:function(event){if(this.__pP){return ;}this.__pP=true;{};this.getBehavior().onAppear(event,event.getType()!==s);this.__pR._updateScrollerWidths();this.__pR._updateScrollBarVisibility();this.__pP=false;this.__pQ=true;},_onTableWidthChanged:function(event){if(this.__pP||!this.__pQ){return ;}this.__pP=true;{};this.getBehavior().onTableWidthChanged(event);this.__pP=false;},_onverticalscrollbarchanged:function(event){if(this.__pP||!this.__pQ){return ;}this.__pP=true;{};this.getBehavior().onVerticalScrollBarChanged(event);qx.event.Timer.once(function(){if(this.__pR&&!this.__pR.isDisposed()){this.__pR._updateScrollerWidths();this.__pR._updateScrollBarVisibility();}},this,0);this.__pP=false;},_oncolumnwidthchanged:function(event){if(this.__pP||!this.__pQ){return ;}this.__pP=true;{};this.getBehavior().onColumnWidthChanged(event);this.__pP=false;},_onvisibilitychanged:function(event){if(this.__pP||!this.__pQ){return ;}this.__pP=true;{};this.getBehavior().onVisibilityChanged(event);this.__pP=false;}},destruct:function(){this.__pR=null;}});})();(function(){var e="auto",d="string",c="number",b="*",a="qx.ui.core.ColumnData";qx.Class.define(a,{extend:qx.ui.core.LayoutItem,construct:function(){qx.ui.core.LayoutItem.call(this);this.setColumnWidth(e);},members:{__pS:null,renderLayout:function(j,top,k,l){this.__pS=k;},getComputedWidth:function(){return this.__pS;},getFlex:function(){return this.getLayoutProperties().flex||0;},setColumnWidth:function(f,g){var g=g||0;var h=null;if(typeof f==c){this.setWidth(f);}else if(typeof f==d){if(f==e){g=1;}else{var i=f.match(/^[0-9]+(?:\.[0-9]+)?([%\*])$/);if(i){if(i[1]==b){g=parseFloat(f);}else{h=f;}}}}this.setLayoutProperties({flex:g,width:h});}},settings:{"qx.tableResizeDebug":false}});})();(function(){var b="qx.ui.table.columnmodel.resizebehavior.Abstract",a="abstract";qx.Class.define(b,{type:a,extend:qx.core.Object,members:{_setNumColumns:function(i){throw new Error("_setNumColumns is abstract");},onAppear:function(event,h){throw new Error("onAppear is abstract");},onTableWidthChanged:function(event){throw new Error("onTableWidthChanged is abstract");},onVerticalScrollBarChanged:function(event){throw new Error("onVerticalScrollBarChanged is abstract");},onColumnWidthChanged:function(event){throw new Error("onColumnWidthChanged is abstract");},onVisibilityChanged:function(event){throw new Error("onVisibilityChanged is abstract");},_getAvailableWidth:function(){var d=this.getTableColumnModel();var g=d.getTable();var c=g._getPaneScrollerArr();if(!c[0]||!c[0].getLayoutParent().getBounds()){return null;}var f=c[0].getLayoutParent().getBounds().width;var e=c[c.length-1];f-=e.getPaneInsetRight();return f;}}});})();(function(){var y="Function",x="Boolean",w="minWidth",v="width",u="qx.ui.table.columnmodel.Resize",t="qx.ui.table.columnmodel.resizebehavior.Default",s="__pV",r="__pU",q="maxWidth";qx.Class.define(t,{extend:qx.ui.table.columnmodel.resizebehavior.Abstract,construct:function(){qx.ui.table.columnmodel.resizebehavior.Abstract.call(this);this.__pT=[];this.__pU=new qx.ui.layout.HBox();this.__pU.connectToWidget(this);this.__pV=new qx.util.DeferredCall(this._computeColumnsFlexWidth,this);},properties:{newResizeBehaviorColumnData:{check:y,init:function(A){return new qx.ui.core.ColumnData();}},initializeWidthsOnEveryAppear:{check:x,init:false},tableColumnModel:{check:u}},members:{__pU:null,__pW:null,__pT:null,__pV:null,__pX:false,setWidth:function(O,P,Q){if(O>=this.__pT.length){throw new Error("Column number out of range");}this.__pT[O].setColumnWidth(P,Q);this.__pV.schedule();},setMinWidth:function(n,o){if(n>=this.__pT.length){throw new Error("Column number out of range");}this.__pT[n].setMinWidth(o);this.__pV.schedule();},setMaxWidth:function(k,m){if(k>=this.__pT.length){throw new Error("Column number out of range");}this.__pT[k].setMaxWidth(m);this.__pV.schedule();},set:function(B,C){for(var D in C){switch(D){case v:this.setWidth(B,C[D]);break;case w:this.setMinWidth(B,C[D]);break;case q:this.setMaxWidth(B,C[D]);break;default:throw new Error("Unknown property: "+D);}}},onAppear:function(event,a){if(a===true||!this.__pX||this.getInitializeWidthsOnEveryAppear()){this._computeColumnsFlexWidth();this.__pX=true;}},onTableWidthChanged:function(event){this._computeColumnsFlexWidth();},onVerticalScrollBarChanged:function(event){this._computeColumnsFlexWidth();},onColumnWidthChanged:function(event){this._extendNextColumn(event);},onVisibilityChanged:function(event){var p=event.getData();if(p.visible){this._computeColumnsFlexWidth();return;}this._extendLastColumn(event);},_setNumColumns:function(M){var N=this.__pT;if(M<=N.length){N.splice(M,N.length);return;}for(var i=N.length;i<M;i++){N[i]=this.getNewResizeBehaviorColumnData()();N[i].columnNumber=i;}},getLayoutChildren:function(){return this.__pW;},_computeColumnsFlexWidth:function(){this.__pV.cancel();var V=this._getAvailableWidth();if(V===null){return;}var R=this.getTableColumnModel();var T=R.getVisibleColumns();var U=T.length;var S=this.__pT;var i,l;if(U===0){return;}var X=[];for(i=0;i<U;i++){X.push(S[T[i]]);}this.__pW=X;this.__pY();this.__pU.renderLayout(V,100);for(i=0,l=X.length;i<l;i++){var W=X[i].getComputedWidth();R.setColumnWidth(T[i],W);}},__pY:function(){this.__pU.invalidateChildrenCache();var z=this.__pW;for(var i=0,l=z.length;i<l;i++){z[i].invalidateLayoutCache();}},_extendNextColumn:function(event){var I=this.getTableColumnModel();var L=event.getData();var G=I.getVisibleColumns();var F=this._getAvailableWidth();var E=G.length;if(L.newWidth>L.oldWidth){return ;}var i;var H;var K=0;for(i=0;i<E;i++){K+=I.getColumnWidth(G[i]);}if(K<F){for(i=0;i<G.length;i++){if(G[i]==L.col){H=G[i+1];break;}}if(H){var J=(F-(K-I.getColumnWidth(H)));I.setColumnWidth(H,J);}}},_extendLastColumn:function(event){var e=this.getTableColumnModel();var j=event.getData();if(j.visible){return;}var d=e.getVisibleColumns();if(d.length==0){return;}var c=this._getAvailableWidth(e);var b=d.length;var i;var g;var h=0;for(i=0;i<b;i++){h+=e.getColumnWidth(d[i]);}if(h<c){g=d[d.length-1];var f=(c-(h-e.getColumnWidth(g)));e.setColumnWidth(g,f);}},_getResizeColumnData:function(){return this.__pT;}},destruct:function(){this.__pT=this.__pW=null;this._disposeObjects(r,s);}});})();(function(){var n="interval",m="qx.util.TimerManager",l="singleton";qx.Class.define(m,{extend:qx.core.Object,type:l,statics:{__qa:[],__qb:{},__qc:0},members:{__qd:false,start:function(e,f,g,h,j){if(!j){j=f||0;}var k=(new Date()).getTime()+j;this.self(arguments).__qb[++this.self(arguments).__qc]={callback:e,userData:h||null,expireAt:k,recurTime:f,context:g||this};this.__qe(k,this.self(arguments).__qc);return this.self(arguments).__qc;},stop:function(o){var p=this.self(arguments).__qa;var length=p.length;for(var i=0;i<length;i++){if(p[i]==o){p.splice(i,1);break;}}delete this.self(arguments).__qb[o];if(p.length==0&&this.__qd){qx.event.Idle.getInstance().removeListener(n,this.__qf,this);this.__qd=false;}},__qe:function(a,b){var d=this.self(arguments).__qa;var c=this.self(arguments).__qb;var length=d.length;for(var i=0;i<length;i++){if(c[d[i]].expireAt>a){d.splice(i,0,b);break;}}if(d.length==length){d.push(b);}if(!this.__qd){qx.event.Idle.getInstance().addListener(n,this.__qf,this);this.__qd=true;}},__qf:function(){var t=(new Date()).getTime();var r=this.self(arguments).__qa;var s=this.self(arguments).__qb;while(r.length>0&&s[r[0]].expireAt<=t){var v=r.shift();var q=s[v];q.callback.call(q.context,q.userData,v);if(q.recurTime&&s[v]){var u=(new Date()).getTime();q.expireAt=u+q.recurTime;this.__qe(q.expireAt,v);}else{delete s[v];}}if(r.length==0&&this.__qd){qx.event.Idle.getInstance().removeListener(n,this.__qf,this);this.__qd=false;}}}});})();(function(){var k="function",j="qx.event.message.Bus",h="*",g="undefined",f="string",e="singleton";qx.Class.define(j,{type:e,extend:qx.core.Object,statics:{getSubscriptions:function(){return this.getInstance().getSubscriptions();},subscribe:function(n,o,p){return this.getInstance().subscribe(n,o,p);},checkSubscription:function(D,E,F){return this.getInstance().checkSubscription(D,E,F);},unsubscribe:function(K,L,M){return this.getInstance().unsubscribe(K,L,M);},dispatch:function(N){return this.getInstance().dispatch.apply(this.getInstance(),arguments);},dispatchByName:function(name,O){return this.getInstance().dispatchByName.apply(this.getInstance(),arguments);}},construct:function(){this.__qg={};},members:{__qg:null,getSubscriptions:function(){return this.__qg;},subscribe:function(a,b,c){if(!a||typeof b!=k){this.error("Invalid parameters! "+[a,b,c]);return false;}var d=this.getSubscriptions();if(this.checkSubscription(a)){if(this.checkSubscription(a,b,c)){this.warn("Object method already subscribed to "+a);return false;}d[a].push({subscriber:b,context:c||null});return true;}else{d[a]=[{subscriber:b,context:c||null}];return true;}},checkSubscription:function(P,Q,R){var S=this.getSubscriptions();if(!S[P]||S[P].length===0){return false;}if(Q){for(var i=0;i<S[P].length;i++){if(S[P][i].subscriber===Q&&S[P][i].context===(R||null)){return true;}}return false;}return true;},unsubscribe:function(x,y,z){var B=this.getSubscriptions();var A=B[x];if(A){if(!z){z=null;}var i=A.length;var C;do{C=A[--i];if(C.subscriber===y&&C.context===z){A.splice(i,1);if(A.length===0){B[x]=null;delete B[x];}return true;}}while(i);}return false;},dispatch:function(q){if(typeof q==f){{};var v=typeof arguments[1]!=g?arguments[1]:true;q=new qx.event.message.Message(q,v);}var r=this.getSubscriptions();var s=q.getName();var t=false;for(var w in r){var u=w.indexOf(h);if(u>-1){if(u===0||w.substr(0,u)===s.substr(0,u)){this.__qh(r[w],q);t=true;}}else{if(w===s){this.__qh(r[s],q);t=true;}}}return t;},dispatchByName:function(name,l){var m=new qx.event.message.Message(name,l);return this.dispatch(m);},__qh:function(G,H){for(var i=0;i<G.length;i++){var I=G[i].subscriber;var J=G[i].context;if(J&&J.isDisposed){if(J.isDisposed()){G.splice(i,1);i--;}else{I.call(J,H);}}else{I.call(J,H);}}}}});})();(function(){var c="Object",b="qx.event.message.Message",a="String";qx.Class.define(b,{extend:qx.core.Object,construct:function(name,d){qx.core.Object.call(this);if(name!=null){this.setName(name);}if(d!=null){this.setData(d);}},properties:{name:{check:a},data:{init:null,nullable:true},sender:{check:c}}});})();(function(){var m="button",l="hovered",k="pressed",j="arrow",i="Enter",h="Space",g="abandoned",f="both",d="String",c="changeVisibility",C="splitbutton",B="changeShow",A="mouseout",z="keydown",y="execute",x="_applyMenu",w="icon",v="mouseover",u="keyup",t="qx.ui.menu.Menu",r="_applyIcon",s="label",p="_applyShow",q="changeMenu",n="_applyLabel",o="qx.ui.form.SplitButton";qx.Class.define(o,{extend:qx.ui.core.Widget,include:[qx.ui.core.MExecutable],implement:[qx.ui.form.IExecutable],construct:function(G,H,I,J){qx.ui.core.Widget.call(this);this._setLayout(new qx.ui.layout.HBox);this._createChildControl(j);this.addListener(v,this._onMouseOver,this,true);this.addListener(A,this._onMouseOut,this,true);this.addListener(z,this._onKeyDown);this.addListener(u,this._onKeyUp);if(G!=null){this.setLabel(G);}if(H!=null){this.setIcon(H);}if(I!=null){this.setMenu(I);}if(J!=null){this.setCommand(J);}},properties:{appearance:{refine:true,init:C},focusable:{refine:true,init:true},label:{apply:n,nullable:true,check:d},icon:{check:d,apply:r,nullable:true,themeable:true},show:{init:f,check:[f,s,w],themeable:true,inheritable:true,apply:p,event:B},menu:{check:t,nullable:true,apply:x,event:q}},members:{__qi:null,_createChildControlImpl:function(a){var b;switch(a){case m:b=new qx.ui.form.Button;b.addListener(y,this._onButtonExecute,this);b.setFocusable(false);this._addAt(b,0,{flex:1});break;case j:b=new qx.ui.form.MenuButton;b.setFocusable(false);this._addAt(b,1);break;}return b||qx.ui.core.Widget.prototype._createChildControlImpl.call(this,a);},_forwardStates:{hovered:1,focused:1},_applyLabel:function(K,L){var M=this.getChildControl(m);K==null?M.resetLabel():M.setLabel(K);},_applyIcon:function(D,E){var F=this.getChildControl(m);D==null?F.resetIcon():F.setIcon(D);},_applyMenu:function(N,O){var P=this.getChildControl(j);if(N){P.resetEnabled();P.setMenu(N);N.setOpener(this);N.addListener(c,this._onChangeMenuVisibility,this);}else{P.setEnabled(false);P.resetMenu();}if(O){O.removeListener(c,this._onChangeMenuVisibility,this);O.resetOpener();}},_applyShow:function(S,T){},_onMouseOver:function(e){e.stopPropagation();this.addState(l);delete this.__qi;},_onMouseOut:function(e){e.stopPropagation();if(!this.hasState(l)){return;}var V=e.getRelatedTarget();if(qx.ui.core.Widget.contains(this,V)){return;}var U=this.getMenu();if(U&&U.isVisible()){this.__qi=true;return;}this.removeState(l);},_onKeyDown:function(e){var R=this.getChildControl(m);switch(e.getKeyIdentifier()){case i:case h:R.removeState(g);R.addState(k);}},_onKeyUp:function(e){var Q=this.getChildControl(m);switch(e.getKeyIdentifier()){case i:case h:if(Q.hasState(k)){Q.removeState(g);Q.removeState(k);Q.execute();}}},_onButtonExecute:function(e){this.execute();},_onChangeMenuVisibility:function(e){if(!this.getMenu().isVisible()&&this.__qi){this.removeState(l);}}}});})();(function(){var g="arrow",f="qx.ui.toolbar.SplitButton",e="keydown",d="toolbar-splitbutton",c="button",b="keyup",a="execute";qx.Class.define(f,{extend:qx.ui.form.SplitButton,construct:function(j,k,l,m){qx.ui.form.SplitButton.call(this,j,k,l,m);this.removeListener(e,this._onKeyDown);this.removeListener(b,this._onKeyUp);},properties:{appearance:{refine:true,init:d},focusable:{refine:true,init:false}},members:{_createChildControlImpl:function(h){var i;switch(h){case c:i=new qx.ui.toolbar.Button;i.addListener(a,this._onButtonExecute,this);this._addAt(i,0);break;case g:i=new qx.ui.toolbar.MenuButton;this._addAt(i,1);break;}return i||qx.ui.form.SplitButton.prototype._createChildControlImpl.call(this,h);}}});})();(function(){var e="inherit",d="toolbar-button",c="keydown",b="qx.ui.toolbar.Button",a="keyup";qx.Class.define(b,{extend:qx.ui.form.Button,construct:function(f,g,h){qx.ui.form.Button.call(this,f,g,h);this.removeListener(c,this._onKeyDown);this.removeListener(a,this._onKeyUp);},properties:{appearance:{refine:true,init:d},show:{refine:true,init:e},focusable:{refine:true,init:false}}});})();(function(){var g="arrow",f="qx.ui.toolbar.MenuButton",e="Boolean",d="_applyShowArrow",c="toolbar-menubutton";qx.Class.define(f,{extend:qx.ui.menubar.Button,properties:{appearance:{refine:true,init:c},showArrow:{check:e,init:false,themeable:true,apply:d}},members:{_createChildControlImpl:function(h){var i;switch(h){case g:i=new qx.ui.basic.Image();i.setAnonymous(true);this._addAt(i,10);break;}return i||qx.ui.menubar.Button.prototype._createChildControlImpl.call(this,h);},_applyShowArrow:function(a,b){if(a){this._showChildControl(g);}else{this._excludeChildControl(g);}}}});})();(function(){var u="Boolean",t="changeInvalidMessage",s="changeSelection",r="String",q="__qj",p="_applyValid",o="",n="changeRequired",m="changeValid",l="_applyInvalidMessage",j="qx.ui.form.RadioButtonGroup",k="qx.event.type.Data";qx.Class.define(j,{extend:qx.ui.core.Widget,include:[qx.ui.core.MLayoutHandling,qx.ui.form.MModelSelection],implement:[qx.ui.form.IForm,qx.ui.core.ISingleSelection,qx.ui.form.IModelSelection],construct:function(B){qx.ui.core.Widget.call(this);if(B==null){this.setLayout(new qx.ui.layout.VBox(4));}else{this.setLayout(B);}this.__qj=new qx.ui.form.RadioGroup();this.__qj.addListener(s,function(e){this.fireDataEvent(s,e.getData(),e.getOldData());},this);},properties:{valid:{check:u,init:true,apply:p,event:m},required:{check:u,init:false,event:n},invalidMessage:{check:r,init:o,event:t,apply:l},requiredInvalidMessage:{check:r,nullable:true,event:t}},events:{"changeSelection":k},members:{__qj:null,_applyInvalidMessage:function(v,w){var x=this._getChildren();for(var i=0;i<x.length;i++){x[i].setInvalidMessage(v);}},_applyValid:function(b,c){var d=this._getChildren();for(var i=0;i<d.length;i++){d[i].setValid(b);}},getRadioGroup:function(){return this.__qj;},getChildren:function(){return this._getChildren();},add:function(f,g){this.__qj.add(f);this._add(f,g);},remove:function(y){this.__qj.remove(y);this._remove(y);},removeAll:function(){var a=this.__qj.getItems();for(var i=0;i<a.length;i++){this.__qj.remove(a[i]);}this._removeAll();},getSelection:function(){return this.__qj.getSelection();},setSelection:function(h){return this.__qj.setSelection(h);},resetSelection:function(){return this.__qj.resetSelection();},isSelected:function(z){return this.__qj.isSelected(z);},isSelectionEmpty:function(){return this.__qj.isSelectionEmpty();},getSelectables:function(A){return this.__qj.getSelectables(A);}},destruct:function(){this._disposeObjects(q);}});})();(function(){var b=".",a="qx.bom.client.Transport";qx.Class.define(a,{statics:{getMaxConcurrentRequestCount:function(){var h;var c=qx.bom.client.Engine;var g=c.FULLVERSION.split(b);var e=0;var d=0;var f=0;if(g[0]){e=g[0];}if(g[1]){d=g[1];}if(g[2]){f=g[2];}if(window.maxConnectionsPerServer){h=window.maxConnectionsPerServer;}else if(c.OPERA){h=8;}else if(c.WEBKIT){h=4;}else if(c.GECKO&&((e>1)||((e==1)&&(d>9))||((e==1)&&(d==9)&&(f>=1)))){h=6;}else{h=2;}return h;}}});})();(function(){var x="Number",w="qx.event.type.Event",v="update",u="linear",t="reverse",s="Boolean",r="setup",q="none",p="qx.fx.Base",o="sinodial",h="flicker",n="pulse",k="_applyDuration",g="easeOutQuad",f="spring",j="easeInQuad",i="full",l="wobble",e="finish",m="Object";qx.Class.define(p,{extend:qx.core.Object,construct:function(y){qx.core.Object.call(this);this.setQueue(qx.fx.queue.Manager.getInstance().getDefaultQueue());this.__qk=qx.fx.Base.EffectState.IDLE;this.__ql=y;},events:{"setup":w,"update":w,"finish":w},properties:{duration:{init:0.5,check:x,apply:k},fps:{init:100,check:x},sync:{init:false,check:s},from:{init:0,check:x},to:{init:1,check:x},delay:{init:0.0,check:x},queue:{check:m,dereference:true},transition:{init:u,check:[u,j,g,o,t,h,l,n,f,q,i]}},statics:{EffectState:{IDLE:'idle',PREPARING:'preparing',FINISHED:'finished',RUNNING:'running'}},members:{__qk:null,__qm:null,__qn:null,__qo:null,__qp:null,__qq:null,__qr:null,__qs:null,__ql:null,_getElement:function(){return this.__ql;},_setElement:function(d){this.__ql=d;},_applyDuration:function(b,c){},init:function(){this.__qk=qx.fx.Base.EffectState.PREPARING;this.__qm=0;this.__qn=this.getDelay()*1000+(new Date().getTime());this.__qo=this.__qn+(this.getDuration()*1000);this.__qp=this.getTo()-this.getFrom();this.__qq=this.__qo-this.__qn;this.__qr=this.getFps()*this.getDuration();},beforeFinishInternal:function(){},beforeFinish:function(){},afterFinishInternal:function(){},afterFinish:function(){},beforeSetupInternal:function(){},beforeSetup:function(){},afterSetupInternal:function(){},afterSetup:function(){},beforeUpdateInternal:function(){},beforeUpdate:function(){},afterUpdateInternal:function(){},afterUpdate:function(){},beforeStartInternal:function(){},beforeStart:function(){},setup:function(){this.fireEvent(r);},update:function(C){},finish:function(){this.fireEvent(e);},start:function(){if(this.__qk!=qx.fx.Base.EffectState.IDLE){return false;}this.init();this.beforeStartInternal();this.beforeStart();if(!this.getSync()){this.getQueue().add(this);}return true;},end:function(){this.render(1.0);this.cancel();this.beforeFinishInternal();this.beforeFinish();this.finish();this.afterFinishInternal();this.afterFinish();},render:function(a){if(this.__qk==qx.fx.Base.EffectState.PREPARING){this.__qk=qx.fx.Base.EffectState.RUNNING;this.beforeSetupInternal();this.beforeSetup();this.setup();this.afterSetupInternal();this.afterSetup();}if(this.__qk==qx.fx.Base.EffectState.RUNNING){this.__qs=qx.fx.Transition.get(this.getTransition())(a)*this.__qp+this.getFrom();this.beforeUpdateInternal();this.beforeUpdate();this.update(this.__qs);this.afterUpdateInternal();this.afterUpdate();if(this.hasListener(v)){this.fireEvent(v);}}},loop:function(z){if(z>=this.__qn){if(z>=this.__qo){this.end();}var B=(z-this.__qn)/this.__qq;var A=Math.round(B*this.__qr);if(A>this.__qm){this.render(B);this.__qm=A;}}},cancel:function(){if(!this.getSync()){this.getQueue().remove(this);}this.__qk=qx.fx.Base.EffectState.IDLE;},resetState:function(){this.__qk=qx.fx.Base.EffectState.IDLE;}},destruct:function(){this.__ql=this.__qk=null;}});})();(function(){var j="sinodial",i="px",h="flicker",g="0px",f="center",e="pulse",d="spring",c="full",b="wobble",a="easeOutQuad",J="easeInQuad",I="reverse",H="none",G="overflow",F="linear",E="height",D='bottom-left',C='top-left',B='bottom-right',A="bottom-right",q="qx.fx.effect.combination.Grow",r="bottom-left",o="visible",p="__qt",m="width",n="__qv",k="top-left",l="top",s="top-right",t='top-right',v="block",u='center',x="__qu",w="hidden",z="left",y="display";qx.Class.define(q,{extend:qx.fx.Base,construct:function(N){qx.fx.Base.call(this,N);this.__qt=new qx.fx.effect.core.Move(N);this.__qu=new qx.fx.effect.core.Scale(N);this.__qv=new qx.fx.effect.core.Parallel(this.__qt,this.__qu);},properties:{direction:{init:f,check:[k,s,r,A,f]},scaleTransition:{init:j,check:[F,J,a,j,I,h,b,e,d,H,c]},moveTransition:{init:j,check:[F,J,a,j,I,h,b,e,d,H,c]}},members:{__qu:null,__qt:null,__qv:null,setup:function(){qx.fx.Base.prototype.setup.call(this);},start:function(){if(!qx.fx.Base.prototype.start.call(this)){return;}var R=this._getElement();qx.bom.element.Style.set(R,y,v);qx.bom.element.Style.set(R,G,w);var P,O;var S,T;var Q={top:qx.bom.element.Location.getTop(R),left:qx.bom.element.Location.getLeft(R),width:qx.bom.element.Dimension.getContentWidth(R),height:qx.bom.element.Dimension.getContentHeight(R),overflow:o};this.__qu.afterFinishInternal=function(){var L;var M=this._getElement();for(var K in Q){L=Q[K];if(K!=G){L+=i;}qx.bom.element.Style.set(M,K,L);}};switch(this.getDirection()){case C:P=O=S=T=0;break;case t:P=Q.width;O=T=0;S=-Q.width;break;case D:P=S=0;O=Q.height;T=-Q.height;break;case B:P=Q.width;O=Q.height;S=-Q.width;T=-Q.height;break;case u:P=Math.round(Q.width/2);O=Math.round(Q.height/2);S=-Math.round(Q.width/2);T=-Math.round(Q.height/2);break;}this.__qt.set({x:S,y:T,sync:true,transition:this.getMoveTransition()});this.__qu.set({scaleTo:100,sync:true,scaleFrom:0,scaleFromCenter:false,transition:this.getScaleTransition(),alternateDimensions:[Q.width,Q.height]});qx.bom.element.Style.set(R,l,(Q.top+O)+i);qx.bom.element.Style.set(R,z,(Q.left+P)+i);qx.bom.element.Style.set(R,E,g);qx.bom.element.Style.set(R,m,g);this.__qv.start();}},destruct:function(){this._disposeObjects(p,x,n);}});})();(function(){var e="__default",d="qx.fx.queue.Manager",c="__qw",b="singleton",a="object";qx.Class.define(d,{extend:qx.core.Object,type:b,construct:function(){qx.core.Object.call(this);this.__qw={};},members:{__qw:null,getQueue:function(f){if(typeof (this.__qw[f])==a){return this.__qw[f];}else{return this.__qw[f]=new qx.fx.queue.Queue;}},getDefaultQueue:function(){return this.getQueue(e);}},destruct:function(){this._disposeMap(c);}});})();(function(){var e="qx.fx.queue.Queue",d="Number";qx.Class.define(e,{extend:qx.core.Object,construct:function(){qx.core.Object.call(this);this.__qx=[];},properties:{limit:{init:Infinity,check:d}},members:{__qy:null,__qx:null,add:function(b){var c=new Date().getTime();b._startOn+=c;b._finishOn+=c;if(this.__qx.length<this.getLimit()){this.__qx.push(b);}else{b.resetState();}if(!this.__qy){this.__qy=qx.lang.Function.periodical(this.loop,15,this);}},remove:function(a){qx.lang.Array.remove(this.__qx,a);if(this.__qx.length==0){window.clearInterval(this.__qy);delete this.__qy;}},loop:function(){var f=new Date().getTime();for(var i=0,g=this.__qx.length;i<g;i++){this.__qx[i]&&this.__qx[i].loop(f);}}},destruct:function(){this.__qx=null;}});})();(function(){var f="Number",e="static",d="qx.fx.Transition";qx.Class.define(d,{type:e,statics:{get:function(h){return qx.fx.Transition[h]||false;},linear:function(k){return k;},easeInQuad:function(m){return Math.pow(2,10*(m-1));},easeOutQuad:function(o){return (-Math.pow(2,-10*o)+1);},sinodial:function(l){return (-Math.cos(l*Math.PI)/2)+0.5;},reverse:function(i){return 1-i;},flicker:function(c){var c=((-Math.cos(c*Math.PI)/4)+0.75)+Math.random()/4;return c>1?1:c;},wobble:function(j){return (-Math.cos(j*Math.PI*(9*j))/2)+0.5;},pulse:function(a,b){b=(typeof (b)==f)?b:5;return (Math.round((a%(1/b))*b)==0?Math.floor((a*b*2)-(a*b*2)):1-Math.floor((a*b*2)-(a*b*2)));},spring:function(n){return 1-(Math.cos(n*4.5*Math.PI)*Math.exp(-n*6));},none:function(p){return 0;},full:function(g){return 1;}}});})();(function(){var j="position",i="px",h="relative",g="Number",f="absolute",e="top",d="left",c='absolute',b="qx.fx.effect.core.Move";qx.Class.define(b,{extend:qx.fx.Base,properties:{mode:{init:h,check:[h,f]},x:{init:0,check:g},y:{init:0,check:g}},members:{__qz:null,__qA:null,__qB:null,__qC:null,__qD:null,setup:function(){var a=this._getElement();qx.fx.Base.prototype.setup.call(this);if(a.parentNode){this.__qB=qx.bom.element.Location.getLeft(a)-qx.bom.element.Location.getLeft(a.parentNode);this.__qC=qx.bom.element.Location.getTop(a)-qx.bom.element.Location.getTop(a.parentNode);}else{this.__qB=qx.bom.element.Location.getLeft(a);this.__qC=qx.bom.element.Location.getTop(a);}this.__qD=qx.bom.element.Style.get(a,j);qx.bom.element.Style.set(a,j,f);if(this.getMode()==c){this.__qz=this.getX()-this.__qB;this.__qA=this.getY()-this.__qC;}else{this.__qz=this.getX();this.__qA=this.getY();}},update:function(k){var m=this._getElement();qx.fx.Base.prototype.update.call(this);var l=Math.round(this.__qz*k+this.__qB);var top=Math.round(this.__qA*k+this.__qC);qx.bom.element.Style.set(m,d,l+i);qx.bom.element.Style.set(m,e,top+i);},afterFinishInternal:function(){qx.bom.element.Style.set(this._getElement(),j,this.__qD);}}});})();(function(){var w='px',v="Boolean",u="Number",t="fontSize",s="Array",r="qx.fx.effect.core.Scale",q="12px",p='pt',o='em',n="position",k='%',m="100%",l="string",j="absolute";qx.Class.define(r,{extend:qx.fx.Base,construct:function(x){qx.fx.Base.call(this,x);this.__qE=qx.fx.effect.core.Scale.originalStyle;this.__qF=qx.fx.effect.core.Scale.fontTypes;},properties:{scaleX:{init:true,check:v},scaleY:{init:true,check:v},scaleContent:{init:true,check:v},scaleFromCenter:{init:true,check:v},scaleFrom:{init:100.0,check:u},scaleTo:{init:100,check:u},restoreAfterFinish:{init:false,check:v},alternateDimensions:{init:[],check:s}},statics:{originalStyle:{'top':null,'left':null,'width':null,'height':null,'fontSize':null},fontTypes:{'em':o,'px':w,'%':k,'pt':p}},members:{__qG:null,__qH:null,__qI:null,__qJ:null,__qK:null,__qL:null,__qM:null,__qE:null,__qF:null,setup:function(){qx.fx.Base.prototype.setup.call(this);var F=this._getElement();this.__qG=qx.bom.element.Style.get(F,n);for(var D in this.__qE){this.__qE[D]=F.style[D];}this.__qH=qx.bom.element.Location.getTop(F);this.__qI=qx.bom.element.Location.getLeft(F);try{var E=qx.bom.element.Style.get(F,t);}catch(G){if(typeof (E)!=l){E=(qx.bom.client.Engine.MSHTML)?q:m;}}for(var B in this.__qF){if(E.indexOf(B)>0){this.__qJ=parseFloat(E);this.__qK=B;break;}}this.__qL=(this.getScaleTo()-this.getScaleFrom())/100;var C=this.getAlternateDimensions();if(C.length==0){this.__qM=[F.offsetWidth,F.offsetHeight];}else{this.__qM=C;}},update:function(y){var A=this._getElement();qx.fx.Base.prototype.update.call(this);var z=(this.getScaleFrom()/100.0)+(this.__qL*y);if(this.getScaleContent()&&this.__qJ){qx.bom.element.Style.set(A,t,this.__qJ*z+this.__qK);}this._setDimensions(this.__qM[0]*z,this.__qM[1]*z);},finish:function(){qx.fx.Base.prototype.finish.call(this);var J=this._getElement();if(this.getRestoreAfterFinish()){for(var H in this.__qE){var I=this.__qE[H];qx.bom.element.Style.set(J,H,I);}}},_setDimensions:function(a,b){var d={};var g=this._getElement();var e=this.getScaleX();var f=this.getScaleY();if(e){d.width=Math.round(a)+w;}if(f){d.height=Math.round(b)+w;}if(this.getScaleFromCenter()){var h=(a-this.__qM[0])/2;var i=(b-this.__qM[1])/2;if(this.__qG==j){if(f){d.top=this.__qH-i+w;}if(e){d.left=this.__qI-h+w;}}else{if(f){d.top=-i+w;}if(e){d.left=-h+w;}}}for(var c in d){qx.bom.element.Style.set(g,c,d[c]);}}},destruct:function(){this.__qM=this.__qE=this.__qF=null;}});})();(function(){var c="qx.fx.effect.core.Parallel",b="__qN";qx.Class.define(c,{extend:qx.fx.Base,construct:function(g){qx.fx.Base.call(this);this.__qN=arguments;},members:{__qN:null,finish:function(){qx.fx.Base.prototype.finish.call(this);var f=this.__qN;for(var i=0;i<f.length;i++){f[i].render(1.0);f[i].cancel();f[i].beforeFinishInternal();f[i].beforeFinish();f[i].finish(1.0);f[i].afterFinishInternal();f[i].afterFinish();}},update:function(d){qx.fx.Base.prototype.update.call(this);var e=this.__qN;for(var i=0;i<e.length;i++){e[i].render(d);}},start:function(){if(!qx.fx.Base.prototype.start.call(this)){return;}var a=this.__qN;for(var i=0;i<a.length;i++){a[i].start();}}},destruct:function(){this._disposeArray(b);}});})();(function(){var e="qx.util.Permutation";qx.Class.define(e,{statics:{permute:function(f,g,h){var k=qx.lang.Object.getKeys(f);var j={};var n=[];for(var i=0;i<k.length;i++){n[i]=0;var m=k[i];j[m]=f[m][0];}var l=function(a,b){if(a>=k.length){return;}var d=k[a];var c=f[d];for(var i=0;i<c.length;i++){if(b!==i){n[a]=i;j[d]=c[i];g.call(h||window,j);}l(a+1,n[a+1]);}};l(0,-1);}}});})();(function(){var bc="failed",bb="sending",ba="completed",Y="receiving",X="aborted",W="timeout",V="qx.event.type.Event",U="Connection dropped",T="qx.io.remote.Response",S="configured",cd="Unknown status code. ",cc="=",cb="qx.io.remote.transport.XmlHttp",ca="qx.io.remote.transport.Abstract",bY="Request-URL too large",bX="MSHTML-specific HTTP status code",bW="Not available",bV="Precondition failed",bU="Server error",bT="Moved temporarily",bj="&",bk="qx.io.remote.Exchange",bh="Possibly due to a cross-domain request?",bi="Bad gateway",bf="Gone",bg="See other",bd="Partial content",be="Server timeout",bp="qx.io.remote.transport.Script",bq="HTTP version not supported",bz="Unauthorized",bw="Possibly due to application URL using 'file:' protocol?",bH="Multiple choices",bC="Payment required",bP="Not implemented",bM="Proxy authentication required",bs="Length required",bS="_applyState",bR="changeState",bQ="Not modified",br="qx.io.remote.Request",bu="Connection closed by server",bv="Moved permanently",by="_applyImplementation",bA="Method not allowed",bD="Forbidden",bJ="Use proxy",bO="Ok",bl="Conflict",bm="Not found",bt="Not acceptable",bG="Request time-out",bF="Bad request",bE="No content",bL="file:",bK="qx.io.remote.transport.Iframe",bB="Request entity too large",bI="Unknown status code",R="Unsupported media type",bN="Gateway time-out",bn="created",bo="Out of resources",bx="undefined";qx.Class.define(bk,{extend:qx.core.Object,construct:function(F){qx.core.Object.call(this);this.setRequest(F);F.setTransport(this);},events:{"sending":V,"receiving":V,"completed":T,"aborted":V,"failed":T,"timeout":T},statics:{typesOrder:[cb,bK,bp],typesReady:false,typesAvailable:{},typesSupported:{},registerType:function(p,q){qx.io.remote.Exchange.typesAvailable[q]=p;},initTypes:function(){if(qx.io.remote.Exchange.typesReady){return;}for(var s in qx.io.remote.Exchange.typesAvailable){var r=qx.io.remote.Exchange.typesAvailable[s];if(r.isSupported()){qx.io.remote.Exchange.typesSupported[s]=r;}}qx.io.remote.Exchange.typesReady=true;if(qx.lang.Object.isEmpty(qx.io.remote.Exchange.typesSupported)){throw new Error("No supported transport types were found!");}},canHandle:function(L,M,N){if(!qx.lang.Array.contains(L.handles.responseTypes,N)){return false;}for(var O in M){if(!L.handles[O]){return false;}}return true;},_nativeMap:{0:bn,1:S,2:bb,3:Y,4:ba},wasSuccessful:function(C,D,E){if(E){switch(C){case null:case 0:return true;case -1:return D<4;default:return typeof C===bx;}}else{switch(C){case -1:{};return D<4;case 200:case 304:return true;case 201:case 202:case 203:case 204:case 205:return true;case 206:{};return D!==4;case 300:case 301:case 302:case 303:case 305:case 400:case 401:case 402:case 403:case 404:case 405:case 406:case 407:case 408:case 409:case 410:case 411:case 412:case 413:case 414:case 415:case 500:case 501:case 502:case 503:case 504:case 505:{};return false;case 12002:case 12007:case 12029:case 12030:case 12031:case 12152:case 13030:{};return false;default:if(C>206&&C<300){return true;}qx.log.Logger.debug(this,"Unknown status code: "+C+" ("+D+")");return false;}}},statusCodeToString:function(b){switch(b){case -1:return bW;case 0:var c=window.location.href;if(qx.lang.String.startsWith(c.toLowerCase(),bL)){return (cd+bw);}else{return (cd+bh);}break;case 200:return bO;case 304:return bQ;case 206:return bd;case 204:return bE;case 300:return bH;case 301:return bv;case 302:return bT;case 303:return bg;case 305:return bJ;case 400:return bF;case 401:return bz;case 402:return bC;case 403:return bD;case 404:return bm;case 405:return bA;case 406:return bt;case 407:return bM;case 408:return bG;case 409:return bl;case 410:return bf;case 411:return bs;case 412:return bV;case 413:return bB;case 414:return bY;case 415:return R;case 500:return bU;case 501:return bP;case 502:return bi;case 503:return bo;case 504:return bN;case 505:return bq;case 12002:return be;case 12029:return U;case 12030:return U;case 12031:return U;case 12152:return bu;case 13030:return bX;default:return bI;}}},properties:{request:{check:br,nullable:true},implementation:{check:ca,nullable:true,apply:by},state:{check:[S,bb,Y,ba,X,W,bc],init:S,event:bR,apply:bS}},members:{send:function(){var h=this.getRequest();if(!h){return this.error("Please attach a request object first");}qx.io.remote.Exchange.initTypes();var f=qx.io.remote.Exchange.typesOrder;var d=qx.io.remote.Exchange.typesSupported;var k=h.getResponseType();var m={};if(h.getAsynchronous()){m.asynchronous=true;}else{m.synchronous=true;}if(h.getCrossDomain()){m.crossDomain=true;}if(h.getFileUpload()){m.fileUpload=true;}for(var j in h.getFormFields()){m.programaticFormFields=true;break;}var n,g;for(var i=0,l=f.length;i<l;i++){n=d[f[i]];if(n){if(!qx.io.remote.Exchange.canHandle(n,m,k)){continue;}try{{};g=new n;this.setImplementation(g);g.setUseBasicHttpAuth(h.getUseBasicHttpAuth());g.send();return true;}catch(Q){this.error("Request handler throws error");this.error(Q);return;}}}this.error("There is no transport implementation available to handle this request: "+h);},abort:function(){var P=this.getImplementation();if(P){{};P.abort();}else{{};this.setState(X);}},timeout:function(){var o=this.getImplementation();if(o){this.warn("Timeout: implementation "+o.toHashCode());o.timeout();}else{this.warn("Timeout: forcing state to timeout");this.setState(W);}this.__qO();},__qO:function(){var B=this.getRequest();if(B){B.setTimeout(0);}},_onsending:function(e){this.setState(bb);},_onreceiving:function(e){this.setState(Y);},_oncompleted:function(e){this.setState(ba);},_onabort:function(e){this.setState(X);},_onfailed:function(e){this.setState(bc);},_ontimeout:function(e){this.setState(W);},_applyImplementation:function(t,u){if(u){u.removeListener(bb,this._onsending,this);u.removeListener(Y,this._onreceiving,this);u.removeListener(ba,this._oncompleted,this);u.removeListener(X,this._onabort,this);u.removeListener(W,this._ontimeout,this);u.removeListener(bc,this._onfailed,this);}if(t){var w=this.getRequest();t.setUrl(w.getUrl());t.setMethod(w.getMethod());t.setAsynchronous(w.getAsynchronous());t.setUsername(w.getUsername());t.setPassword(w.getPassword());t.setParameters(w.getParameters(false));t.setFormFields(w.getFormFields());t.setRequestHeaders(w.getRequestHeaders());if(t instanceof qx.io.remote.transport.XmlHttp){t.setParseJson(w.getParseJson());}var z=w.getData();if(z===null){var A=w.getParameters(true);var y=[];for(var v in A){var x=A[v];if(x instanceof Array){for(var i=0;i<x.length;i++){y.push(encodeURIComponent(v)+cc+encodeURIComponent(x[i]));}}else{y.push(encodeURIComponent(v)+cc+encodeURIComponent(x));}}if(y.length>0){t.setData(y.join(bj));}}else{t.setData(z);}t.setResponseType(w.getResponseType());t.addListener(bb,this._onsending,this);t.addListener(Y,this._onreceiving,this);t.addListener(ba,this._oncompleted,this);t.addListener(X,this._onabort,this);t.addListener(W,this._ontimeout,this);t.addListener(bc,this._onfailed,this);}},_applyState:function(G,H){{};switch(G){case bb:this.fireEvent(bb);break;case Y:this.fireEvent(Y);break;case ba:case X:case W:case bc:var J=this.getImplementation();if(!J){break;}this.__qO();if(this.hasListener(G)){var K=qx.event.Registration.createEvent(G,qx.io.remote.Response);if(G==ba){var I=J.getResponseContent();K.setContent(I);if(I===null){{};G=bc;}}else if(G==bc){K.setContent(J.getResponseContent());}K.setStatusCode(J.getStatusCode());K.setResponseHeaders(J.getResponseHeaders());this.dispatchEvent(K);}this.setImplementation(null);J.dispose();break;}}},settings:{"qx.ioRemoteDebug":false,"qx.ioRemoteDebugData":false},destruct:function(){var a=this.getImplementation();if(a){this.setImplementation(null);a.dispose();}this.setRequest(null);}});})();(function(){var q="qx.event.type.Event",p="String",o="failed",n="timeout",m="created",l="aborted",k="sending",j="configured",i="receiving",h="completed",c="Object",g="Boolean",f="abstract",b="_applyState",a="GET",e="changeState",d="qx.io.remote.transport.Abstract";qx.Class.define(d,{type:f,extend:qx.core.Object,construct:function(){qx.core.Object.call(this);this.setRequestHeaders({});this.setParameters({});this.setFormFields({});},events:{"created":q,"configured":q,"sending":q,"receiving":q,"completed":q,"aborted":q,"failed":q,"timeout":q},properties:{url:{check:p,nullable:true},method:{check:p,nullable:true,init:a},asynchronous:{check:g,nullable:true,init:true},data:{check:p,nullable:true},username:{check:p,nullable:true},password:{check:p,nullable:true},state:{check:[m,j,k,i,h,l,n,o],init:m,event:e,apply:b},requestHeaders:{check:c,nullable:true},parameters:{check:c,nullable:true},formFields:{check:c,nullable:true},responseType:{check:p,nullable:true},useBasicHttpAuth:{check:g,nullable:true}},members:{send:function(){throw new Error("send is abstract");},abort:function(){{};this.setState(l);},timeout:function(){{};this.setState(n);},failed:function(){{};this.setState(o);},setRequestHeader:function(u,v){throw new Error("setRequestHeader is abstract");},getResponseHeader:function(t){throw new Error("getResponseHeader is abstract");},getResponseHeaders:function(){throw new Error("getResponseHeaders is abstract");},getStatusCode:function(){throw new Error("getStatusCode is abstract");},getStatusText:function(){throw new Error("getStatusText is abstract");},getResponseText:function(){throw new Error("getResponseText is abstract");},getResponseXml:function(){throw new Error("getResponseXml is abstract");},getFetchedLength:function(){throw new Error("getFetchedLength is abstract");},_applyState:function(r,s){{};switch(r){case m:this.fireEvent(m);break;case j:this.fireEvent(j);break;case k:this.fireEvent(k);break;case i:this.fireEvent(i);break;case h:this.fireEvent(h);break;case l:this.fireEvent(l);break;case o:this.fireEvent(o);break;case n:this.fireEvent(n);break;}return true;}},destruct:function(){this.setRequestHeaders(null);this.setParameters(null);this.setFormFields(null);}});})();(function(){var v="=",u="&",t="application/xml",s="application/json",r="text/html",q="qx.client",p="textarea",o="none",n="text/plain",m="text/javascript",P="",O="completed",N="?",M="qx.io.remote.transport.Iframe",L="gecko",K="frame_",J="aborted",I="_data_",H="pre",G="javascript:void(0)",C="sending",D="form",A="failed",B='<iframe name="',y="mshtml",z="form_",w='"></iframe>',x="iframe",E="timeout",F="qx/static/blank.gif";qx.Class.define(M,{extend:qx.io.remote.transport.Abstract,construct:function(){qx.io.remote.transport.Abstract.call(this);var R=(new Date).valueOf();var S=K+R;var T=z+R;if(qx.core.Variant.isSet(q,y)){this.__qP=document.createElement(B+S+w);}else{this.__qP=document.createElement(x);}this.__qP.src=G;this.__qP.id=this.__qP.name=S;this.__qP.onload=qx.lang.Function.bind(this._onload,this);this.__qP.style.display=o;document.body.appendChild(this.__qP);this.__qQ=document.createElement(D);this.__qQ.target=S;this.__qQ.id=this.__qQ.name=T;this.__qQ.style.display=o;document.body.appendChild(this.__qQ);this.__qR=document.createElement(p);this.__qR.id=this.__qR.name=I;this.__qQ.appendChild(this.__qR);this.__qP.onreadystatechange=qx.lang.Function.bind(this._onreadystatechange,this);},statics:{handles:{synchronous:false,asynchronous:true,crossDomain:false,fileUpload:true,programaticFormFields:true,responseTypes:[n,m,s,t,r]},isSupported:function(){return true;},_numericMap:{"uninitialized":1,"loading":2,"loaded":2,"interactive":3,"complete":4}},members:{__qR:null,__qS:0,__qQ:null,__qP:null,send:function(){var b=this.getMethod();var d=this.getUrl();var j=this.getParameters(false);var h=[];for(var c in j){var f=j[c];if(f instanceof Array){for(var i=0;i<f.length;i++){h.push(encodeURIComponent(c)+v+encodeURIComponent(f[i]));}}else{h.push(encodeURIComponent(c)+v+encodeURIComponent(f));}}if(h.length>0){d+=(d.indexOf(N)>=0?u:N)+h.join(u);}if(this.getData()===null){var j=this.getParameters(true);var h=[];for(var c in j){var f=j[c];if(f instanceof Array){for(var i=0;i<f.length;i++){h.push(encodeURIComponent(c)+v+encodeURIComponent(f[i]));}}else{h.push(encodeURIComponent(c)+v+encodeURIComponent(f));}}if(h.length>0){this.setData(h.join(u));}}var a=this.getFormFields();for(var c in a){var g=document.createElement(p);g.name=c;g.appendChild(document.createTextNode(a[c]));this.__qQ.appendChild(g);}this.__qQ.action=d;this.__qQ.method=b;this.__qR.appendChild(document.createTextNode(this.getData()));this.__qQ.submit();this.setState(C);},_onload:qx.event.GlobalError.observeMethod(function(e){if(this.__qQ.src){return;}this._switchReadyState(qx.io.remote.transport.Iframe._numericMap.complete);}),_onreadystatechange:qx.event.GlobalError.observeMethod(function(e){this._switchReadyState(qx.io.remote.transport.Iframe._numericMap[this.__qP.readyState]);}),_switchReadyState:function(l){switch(this.getState()){case O:case J:case A:case E:this.warn("Ignore Ready State Change");return;}while(this.__qS<l){this.setState(qx.io.remote.Exchange._nativeMap[++this.__qS]);}},setRequestHeader:function(Y,ba){},getResponseHeader:function(k){return null;},getResponseHeaders:function(){return {};},getStatusCode:function(){return 200;},getStatusText:function(){return P;},getIframeWindow:function(){return qx.bom.Iframe.getWindow(this.__qP);},getIframeDocument:function(){return qx.bom.Iframe.getDocument(this.__qP);},getIframeBody:function(){return qx.bom.Iframe.getBody(this.__qP);},getIframeTextContent:function(){var X=this.getIframeBody();if(!X){return null;}if(!X.firstChild){return P;}if(X.firstChild.tagName&&X.firstChild.tagName.toLowerCase()==H){return X.firstChild.innerHTML;}else{return X.innerHTML;}},getIframeHtmlContent:function(){var Q=this.getIframeBody();return Q?Q.innerHTML:null;},getFetchedLength:function(){return 0;},getResponseContent:function(){if(this.getState()!==O){{};return null;}{};var W=this.getIframeTextContent();switch(this.getResponseType()){case n:{};return W;break;case r:W=this.getIframeHtmlContent();{};return W;break;case s:W=this.getIframeHtmlContent();{};try{return W&&W.length>0?qx.util.Json.parse(W,false):null;}catch(V){return this.error("Could not execute json: ("+W+")",V);}case m:W=this.getIframeHtmlContent();{};try{return W&&W.length>0?window.eval(W):null;}catch(U){return this.error("Could not execute javascript: ("+W+")",U);}case t:W=this.getIframeDocument();{};return W;default:this.warn("No valid responseType specified ("+this.getResponseType()+")!");return null;}}},defer:function(){qx.io.remote.Exchange.registerType(qx.io.remote.transport.Iframe,M);},destruct:function(){if(this.__qP){this.__qP.onload=null;this.__qP.onreadystatechange=null;if(qx.core.Variant.isSet(q,L)){this.__qP.src=qx.util.ResourceManager.getInstance().toUri(F);}document.body.removeChild(this.__qP);}if(this.__qQ){document.body.removeChild(this.__qQ);}this.__qP=this.__qQ=this.__qR=null;}});})();(function(){var j="qx.event.handler.Iframe",i="load",h="iframe";qx.Class.define(j,{extend:qx.core.Object,implement:qx.event.IEventHandler,statics:{PRIORITY:qx.event.Registration.PRIORITY_NORMAL,SUPPORTED_TYPES:{load:1},TARGET_CHECK:qx.event.IEventHandler.TARGET_DOMNODE,IGNORE_CAN_HANDLE:false,onevent:qx.event.GlobalError.observeMethod(function(d){qx.event.Registration.fireEvent(d,i);})},members:{canHandleEvent:function(l,m){return l.tagName.toLowerCase()===h;},registerEvent:function(e,f,g){},unregisterEvent:function(a,b,c){}},defer:function(k){qx.event.Registration.addHandler(k);}});})();(function(){var j="qx.client",i="webkit",h="body",g="iframe",f="qx.bom.Iframe";qx.Class.define(f,{statics:{DEFAULT_ATTRIBUTES:{onload:"qx.event.handler.Iframe.onevent(this)",frameBorder:0,frameSpacing:0,marginWidth:0,marginHeight:0,hspace:0,vspace:0,border:0,allowTransparency:true},create:function(k,l){var k=k?qx.lang.Object.clone(k):{};var m=qx.bom.Iframe.DEFAULT_ATTRIBUTES;for(var n in m){if(k[n]==null){k[n]=m[n];}}return qx.bom.Element.create(g,k,l);},getWindow:qx.core.Variant.select(j,{"mshtml|gecko":function(e){try{return e.contentWindow;}catch(d){return null;}},"default":function(B){try{var C=this.getDocument(B);return C?C.defaultView:null;}catch(o){return null;}}}),getDocument:qx.core.Variant.select(j,{"mshtml":function(t){try{var u=this.getWindow(t);return u?u.document:null;}catch(s){return null;}},"default":function(D){try{return D.contentDocument;}catch(x){return null;}}}),getBody:function(a){try{var b=this.getDocument(a);return b?b.getElementsByTagName(h)[0]:null;}catch(c){return null;}},setSource:function(p,q){try{if(this.getWindow(p)&&qx.dom.Hierarchy.isRendered(p)){try{if(qx.core.Variant.isSet(j,i)&&qx.bom.client.Platform.MAC){var r=this.getContentWindow();if(r){r.stop();}}this.getWindow(p).location.replace(q);}catch(y){p.src=q;}}else{p.src=q;}}catch(z){qx.log.Logger.warn("Iframe source could not be set!");}},queryCurrentUrl:function(v){var w=this.getDocument(v);try{if(w&&w.location){return w.location.href;}}catch(A){}return null;}}});})();(function(){var q=",",p="",o="string",n="null",m="new Date(Date.UTC(",k='"',j="))",h=':',g="qx.jsonDebugging",f='-',R='\\u00',Q='\\\\',P="__qV",O='\\f',N='\\"',M='Z',L='T',K="}",J='(',I='.',x="{",y='\\r',v="__qY",w=":",t="__rh",u='\\t',r="The default returned parsed date format will change. Use the CONVERT_DATES flag to change the behavior.",s="]",z="qx.jsonEncodeUndefined",A="__qW",D="[",C="__rg",F='\\b',E="qx.util.Json",H=')',G='\\n',B="__qX";qx.Class.define(E,{statics:{__qT:null,BEAUTIFYING_INDENT:"  ",BEAUTIFYING_LINE_END:"\n",CONVERT_DATES:null,__qU:{"function":P,"boolean":A,"number":B,"string":v,"object":C,"undefined":t},__qV:function(d,e){return String(d);},__qW:function(bl,bm){return String(bl);},__qX:function(bw,bx){return isFinite(bw)?String(bw):n;},__qY:function(U,V){var W;if(/["\\\x00-\x1f]/.test(U)){W=U.replace(/([\x00-\x1f\\"])/g,qx.util.Json.__rb);}else{W=U;}return k+W+k;},__ra:{'\b':F,'\t':u,'\n':G,'\f':O,'\r':y,'"':N,'\\':Q},__rb:function(a,b){var bn=qx.util.Json.__ra[b];if(bn){return bn;}bn=b.charCodeAt();return R+Math.floor(bn/16).toString(16)+(bn%16).toString(16);},__rc:function(be,bf){var bh=[],bk=true,bj,bg;var bi=qx.util.Json.__rj;bh.push(D);if(bi){qx.util.Json.__rd+=qx.util.Json.BEAUTIFYING_INDENT;bh.push(qx.util.Json.__rd);}for(var i=0,l=be.length;i<l;i++){bg=be[i];bj=this.__qU[typeof bg];if(bj){bg=this[bj](bg,i+p);if(typeof bg==o){if(!bk){bh.push(q);if(bi){bh.push(qx.util.Json.__rd);}}bh.push(bg);bk=false;}}}if(bi){qx.util.Json.__rd=qx.util.Json.__rd.substring(0,qx.util.Json.__rd.length-qx.util.Json.BEAUTIFYING_INDENT.length);bh.push(qx.util.Json.__rd);}bh.push(s);return bh.join(p);},__re:function(bo,bp){if(qx.util.Json.CONVERT_DATES===null){qx.log.Logger.deprecatedMethodWarning(arguments.callee,r);var br=bo.getUTCFullYear()+q+bo.getUTCMonth()+q+bo.getUTCDate()+q+bo.getUTCHours()+q+bo.getUTCMinutes()+q+bo.getUTCSeconds()+q+bo.getUTCMilliseconds();return m+br+j;}else if(!qx.util.Json.CONVERT_DATES){if(bo.toJSON){return bo.toJSON();}var bq=qx.util.format.NumberFormat.getInstance();bq.setMinimumIntegerDigits(2);var bs=bo.getUTCFullYear()+f+bq.format(bo.getUTCMonth()+1)+f+bq.format(bo.getUTCDate())+L+bq.format(bo.getUTCHours())+h+bq.format(bo.getUTCMinutes())+h+bq.format(bo.getUTCSeconds())+I;bq.setMinimumIntegerDigits(3);return bs+bq.format(bo.getUTCMilliseconds())+M;}else{var br=bo.getUTCFullYear()+q+bo.getUTCMonth()+q+bo.getUTCDate()+q+bo.getUTCHours()+q+bo.getUTCMinutes()+q+bo.getUTCSeconds()+q+bo.getUTCMilliseconds();return m+br+j;}},__rf:function(bA,bB){var bE=[],bG=true,bD,bC;var bF=qx.util.Json.__rj;bE.push(x);if(bF){qx.util.Json.__rd+=qx.util.Json.BEAUTIFYING_INDENT;bE.push(qx.util.Json.__rd);}for(var bB in bA){bC=bA[bB];bD=this.__qU[typeof bC];if(bD){bC=this[bD](bC,bB);if(typeof bC==o){if(!bG){bE.push(q);if(bF){bE.push(qx.util.Json.__rd);}}bE.push(this.__qY(bB),w,bC);bG=false;}}}if(bF){qx.util.Json.__rd=qx.util.Json.__rd.substring(0,qx.util.Json.__rd.length-qx.util.Json.BEAUTIFYING_INDENT.length);bE.push(qx.util.Json.__rd);}bE.push(K);return bE.join(p);},__rg:function(S,T){if(S){if(qx.lang.Type.isFunction(S.toJSON)&&S.toJSON!==this.__qT){return this.__ri(S.toJSON(T),T);}else if(qx.lang.Type.isDate(S)){return this.__re(S,T);}else if(qx.lang.Type.isArray(S)){return this.__rc(S,T);}else if(qx.lang.Type.isObject(S)){return this.__rf(S,T);}return p;}return n;},__rh:function(bt,bu){if(qx.core.Setting.get(z)){return n;}},__ri:function(by,bz){return this[this.__qU[typeof by]](by,bz);},stringify:function(bb,bc){this.__rj=bc;this.__rd=this.BEAUTIFYING_LINE_END;var bd=this.__ri(bb,p);if(typeof bd!=o){bd=null;}if(qx.core.Setting.get(g)){qx.log.Logger.debug(this,"JSON request: "+bd);}return bd;},parse:function(X,Y){if(Y===undefined){Y=true;}if(qx.core.Setting.get(g)){qx.log.Logger.debug(this,"JSON response: "+X);}if(Y){if(/[^,:{}\[\]0-9.\-+Eaeflnr-u \n\r\t]/.test(X.replace(/"(\\.|[^"\\])*"/g,p))){throw new Error("Could not parse JSON string!");}}try{var ba=(X&&X.length>0)?eval(J+X+H):null;return ba;}catch(bv){throw new Error("Could not evaluate JSON string: "+bv.message);}}},settings:{"qx.jsonEncodeUndefined":true,"qx.jsonDebugging":false},defer:function(c){c.__qT=Date.prototype.toJSON;}});})();(function(){var w="&",v="=",u="?",t="application/json",s="completed",r="text/plain",q="text/javascript",p="qx.io.remote.transport.Script",o="",n="_ScriptTransport_data",h="script",m="timeout",l="_ScriptTransport_",g="_ScriptTransport_id",f="aborted",k="utf-8",j="failed";qx.Class.define(p,{extend:qx.io.remote.transport.Abstract,construct:function(){qx.io.remote.transport.Abstract.call(this);var F=++qx.io.remote.transport.Script.__rk;if(F>=2000000000){qx.io.remote.transport.Script.__rk=F=1;}this.__rl=null;this.__rk=F;},statics:{__rk:0,_instanceRegistry:{},ScriptTransport_PREFIX:l,ScriptTransport_ID_PARAM:g,ScriptTransport_DATA_PARAM:n,handles:{synchronous:false,asynchronous:true,crossDomain:true,fileUpload:false,programaticFormFields:false,responseTypes:[r,q,t]},isSupported:function(){return true;},_numericMap:{"uninitialized":1,"loading":2,"loaded":2,"interactive":3,"complete":4},_requestFinished:qx.event.GlobalError.observeMethod(function(x,content){var y=qx.io.remote.transport.Script._instanceRegistry[x];if(y==null){{};}else{y._responseContent=content;y._switchReadyState(qx.io.remote.transport.Script._numericMap.complete);}})},members:{__rm:0,__rl:null,__rk:null,send:function(){var B=this.getUrl();B+=(B.indexOf(u)>=0?w:u)+qx.io.remote.transport.Script.ScriptTransport_ID_PARAM+v+this.__rk;var E=this.getParameters();var D=[];for(var A in E){if(A.indexOf(qx.io.remote.transport.Script.ScriptTransport_PREFIX)==0){this.error("Illegal parameter name. The following prefix is used internally by qooxdoo): "+qx.io.remote.transport.Script.ScriptTransport_PREFIX);}var C=E[A];if(C instanceof Array){for(var i=0;i<C.length;i++){D.push(encodeURIComponent(A)+v+encodeURIComponent(C[i]));}}else{D.push(encodeURIComponent(A)+v+encodeURIComponent(C));}}if(D.length>0){B+=w+D.join(w);}var z=this.getData();if(z!=null){B+=w+qx.io.remote.transport.Script.ScriptTransport_DATA_PARAM+v+encodeURIComponent(z);}qx.io.remote.transport.Script._instanceRegistry[this.__rk]=this;this.__rl=document.createElement(h);this.__rl.charset=k;this.__rl.src=B;{};document.body.appendChild(this.__rl);},_switchReadyState:function(e){switch(this.getState()){case s:case f:case j:case m:this.warn("Ignore Ready State Change");return;}while(this.__rm<e){this.setState(qx.io.remote.Exchange._nativeMap[++this.__rm]);}},setRequestHeader:function(b,c){},getResponseHeader:function(d){return null;},getResponseHeaders:function(){return {};},getStatusCode:function(){return 200;},getStatusText:function(){return o;},getFetchedLength:function(){return 0;},getResponseContent:function(){if(this.getState()!==s){{};return null;}{};switch(this.getResponseType()){case r:case t:case q:{};var a=this._responseContent;return (a===0?0:(a||null));default:this.warn("No valid responseType specified ("+this.getResponseType()+")!");return null;}}},defer:function(){qx.io.remote.Exchange.registerType(qx.io.remote.transport.Script,p);},destruct:function(){if(this.__rl){delete qx.io.remote.transport.Script._instanceRegistry[this.__rk];document.body.removeChild(this.__rl);}this.__rl=this._responseContent=null;}});})();(function(){var bb="failed",ba="completed",Y="=",X="aborted",W="",V="sending",U="&",T="configured",S="timeout",R="application/xml",bx="qx.io.remote.transport.XmlHttp",bw="application/json",bv="text/html",bu="qx.client",bt="receiving",bs="text/plain",br="text/javascript",bq="?",bp="created",bo="Boolean",bi='Referer',bj='Basic ',bg="\n</pre>",bh="string",be='Authorization',bf="<pre>Could not execute json: \n",bc="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",bd=':',bk="parseerror",bl="file:",bn="webkit",bm="object";qx.Class.define(bx,{extend:qx.io.remote.transport.Abstract,statics:{handles:{synchronous:true,asynchronous:true,crossDomain:false,fileUpload:false,programaticFormFields:false,responseTypes:[bs,br,bw,R,bv]},requestObjects:[],requestObjectCount:0,createRequestObject:qx.core.Variant.select(bu,{"default":function(){return new XMLHttpRequest;},"mshtml":function(){if(window.ActiveXObject&&qx.xml.Document.XMLHTTP){return new ActiveXObject(qx.xml.Document.XMLHTTP);}if(window.XMLHttpRequest){return new XMLHttpRequest;}}}),isSupported:function(){return !!this.createRequestObject();}},properties:{parseJson:{check:bo,init:true}},members:{__rn:false,__ro:0,__rp:null,getRequest:function(){if(this.__rp===null){this.__rp=qx.io.remote.transport.XmlHttp.createRequestObject();this.__rp.onreadystatechange=qx.lang.Function.bind(this._onreadystatechange,this);}return this.__rp;},send:function(){this.__ro=0;var E=this.getRequest();var A=this.getMethod();var H=this.getAsynchronous();var G=this.getUrl();var C=(window.location.protocol===bl&&!(/^http(s){0,1}\:/.test(G)));this.__rn=C;var K=this.getParameters(false);var I=[];for(var B in K){var F=K[B];if(F instanceof Array){for(var i=0;i<F.length;i++){I.push(encodeURIComponent(B)+Y+encodeURIComponent(F[i]));}}else{I.push(encodeURIComponent(B)+Y+encodeURIComponent(F));}}if(I.length>0){G+=(G.indexOf(bq)>=0?U:bq)+I.join(U);}if(this.getData()===null){var K=this.getParameters(true);var I=[];for(var B in K){var F=K[B];if(F instanceof Array){for(var i=0;i<F.length;i++){I.push(encodeURIComponent(B)+Y+encodeURIComponent(F[i]));}}else{I.push(encodeURIComponent(B)+Y+encodeURIComponent(F));}}if(I.length>0){this.setData(I.join(U));}}var J=function(j){var p=bc;var u=W;var n,m,k;var q,r,t,o;var i=0;do{n=j.charCodeAt(i++);m=j.charCodeAt(i++);k=j.charCodeAt(i++);q=n>>2;r=((n&3)<<4)|(m>>4);t=((m&15)<<2)|(k>>6);o=k&63;if(isNaN(m)){t=o=64;}else if(isNaN(k)){o=64;}u+=p.charAt(q)+p.charAt(r)+p.charAt(t)+p.charAt(o);}while(i<j.length);return u;};try{if(this.getUsername()){if(this.getUseBasicHttpAuth()){E.open(A,G,H);E.setRequestHeader(be,bj+J(this.getUsername()+bd+this.getPassword()));}else{E.open(A,G,H,this.getUsername(),this.getPassword());}}else{E.open(A,G,H);}}catch(L){this.error("Failed with exception: "+L);this.failed();return;}if(!qx.core.Variant.isSet(bu,bn)){E.setRequestHeader(bi,window.location.href);}var D=this.getRequestHeaders();for(var B in D){E.setRequestHeader(B,D[B]);}try{{};E.send(this.getData());}catch(d){if(C){this.failedLocally();}else{this.error("Failed to send data: "+d,"send");this.failed();}return;}if(!H){this._onreadystatechange();}},failedLocally:function(){if(this.getState()===bb){return;}this.warn("Could not load from file: "+this.getUrl());this.failed();},_onreadystatechange:qx.event.GlobalError.observeMethod(function(e){switch(this.getState()){case ba:case X:case bb:case S:{};return;}var bE=this.getReadyState();if(bE==4){if(!qx.io.remote.Exchange.wasSuccessful(this.getStatusCode(),bE,this.__rn)){if(this.getState()===T){this.setState(V);}this.failed();return;}}while(this.__ro<bE){this.setState(qx.io.remote.Exchange._nativeMap[++this.__ro]);}}),getReadyState:function(){var bG=null;try{bG=this.getRequest().readyState;}catch(bF){}return bG;},setRequestHeader:function(bJ,bK){this.getRequestHeaders()[bJ]=bK;},getResponseHeader:function(bH){var bI=null;try{bI=this.getRequest().getResponseHeader(bH)||null;}catch(by){}return bI;},getStringResponseHeaders:function(){var bO=null;try{var bN=this.getRequest().getAllResponseHeaders();if(bN){bO=bN;}}catch(g){}return bO;},getResponseHeaders:function(){var O=this.getStringResponseHeaders();var P={};if(O){var M=O.split(/[\r\n]+/g);for(var i=0,l=M.length;i<l;i++){var N=M[i].match(/^([^:]+)\s*:\s*(.+)$/i);if(N){P[N[1]]=N[2];}}}return P;},getStatusCode:function(){var bD=-1;try{bD=this.getRequest().status;}catch(bB){}return bD;},getStatusText:function(){var bP=W;try{bP=this.getRequest().statusText;}catch(h){}return bP;},getResponseText:function(){var bL=null;try{bL=this.getRequest().responseText;}catch(z){bL=null;}return bL;},getResponseXml:function(){var x=null;var v=this.getStatusCode();var w=this.getReadyState();if(qx.io.remote.Exchange.wasSuccessful(v,w,this.__rn)){try{x=this.getRequest().responseXML;}catch(f){}}if(typeof x==bm&&x!=null){if(!x.documentElement){var s=String(this.getRequest().responseText).replace(/<\?xml[^\?]*\?>/,W);x.loadXML(s);}if(!x.documentElement){throw new Error("Missing Document Element!");}if(x.documentElement.tagName==bk){throw new Error("XML-File is not well-formed!");}}else{throw new Error("Response was not a valid xml document ["+this.getRequest().responseText+"]");}return x;},getFetchedLength:function(){var Q=this.getResponseText();return typeof Q==bh?Q.length:0;},getResponseContent:function(){var a=this.getState();if(a!==ba&&a!=bb){{};return null;}{};var c=this.getResponseText();if(a==bb){{};return c;}switch(this.getResponseType()){case bs:case bv:{};return c;case bw:{};try{if(c&&c.length>0){var b;if(this.getParseJson()){b=qx.util.Json.parse(c,false);b=(b===0?0:(b||null));}else{b=c;}return b;}else{return null;}}catch(bM){this.error("Could not execute json: ["+c+"]",bM);return bf+c+bg;}case br:{};try{if(c&&c.length>0){var b=window.eval(c);return (b===0?0:(b||null));}else{return null;}}catch(bC){this.error("Could not execute javascript: ["+c+"]",bC);return null;}case R:c=this.getResponseXml();{};return (c===0?0:(c||null));default:this.warn("No valid responseType specified ("+this.getResponseType()+")!");return null;}},_applyState:function(bz,bA){{};switch(bz){case bp:this.fireEvent(bp);break;case T:this.fireEvent(T);break;case V:this.fireEvent(V);break;case bt:this.fireEvent(bt);break;case ba:this.fireEvent(ba);break;case bb:this.fireEvent(bb);break;case X:this.getRequest().abort();this.fireEvent(X);break;case S:this.getRequest().abort();this.fireEvent(S);break;}}},defer:function(){qx.io.remote.Exchange.registerType(qx.io.remote.transport.XmlHttp,bx);},destruct:function(){var y=this.getRequest();if(y){y.onreadystatechange=qx.lang.Function.empty;switch(y.readyState){case 1:case 2:case 3:y.abort();}}this.__rp=null;}});})();(function(){var c="Integer",b="Object",a="qx.io.remote.Response";qx.Class.define(a,{extend:qx.event.type.Event,properties:{state:{check:c,nullable:true},statusCode:{check:c,nullable:true},content:{nullable:true},responseHeaders:{check:b,nullable:true}},members:{clone:function(f){var g=qx.event.type.Event.prototype.clone.call(this,f);g.setType(this.getType());g.setState(this.getState());g.setStatusCode(this.getStatusCode());g.setContent(this.getContent());g.setResponseHeaders(this.getResponseHeaders());return g;},getResponseHeader:function(d){var e=this.getResponseHeaders();if(e){return e[d]||null;}return null;}}});})();(function(){var g="",f="Function",e="qx.ui.table.celleditor.ComboBox",d="number",c="Array",b="table-editor-combobox",a="appear";qx.Class.define(e,{extend:qx.core.Object,implement:qx.ui.table.ICellEditorFactory,properties:{validationFunction:{check:f,nullable:true,init:null},listData:{check:c,init:null,nullable:true}},members:{createCellEditor:function(m){var o=new qx.ui.form.ComboBox().set({appearance:b});var p=m.value;o.originalValue=p;var s=m.table.getTableColumnModel().getDataCellRenderer(m.col);var q=s._getContentHtml(m);if(p!=q){p=q;}if(p===null||p===undefined){p=g;}var n=this.getListData();if(n){var r;for(var i=0,l=n.length;i<l;i++){var t=n[i];if(t instanceof Array){r=new qx.ui.form.ListItem(t[0],t[1]);}else{r=new qx.ui.form.ListItem(t,null);}o.add(r);}}o.setValue(g+p);o.addListener(a,function(){o.selectAllText();});return o;},getCellEditorValue:function(h){var k=h.getValue()||g;var j=this.getValidationFunction();if(j){k=j(k,h.originalValue);}if(typeof h.originalValue==d){k=parseFloat(k);}return k;}}});})();(function(){var B="popup",A="list",z="",y="mousewheel",x="resize",w="Function",v="blur",u="abstract",t="keypress",s="Number",l="changeSelection",r="PageUp",o="_applyMaxListHeight",j="PageDown",i="mouseup",n="Escape",m="changeVisibility",p="one",h="middle",q="qx.ui.form.AbstractSelectBox",k="mousedown";qx.Class.define(q,{extend:qx.ui.core.Widget,include:[qx.ui.core.MRemoteChildrenHandling,qx.ui.form.MForm],implement:[qx.ui.form.IForm],type:u,construct:function(){qx.ui.core.Widget.call(this);var M=new qx.ui.layout.HBox();this._setLayout(M);M.setAlignY(h);this.addListener(t,this._onKeyPress);this.addListener(v,this._onBlur,this);var L=qx.core.Init.getApplication().getRoot();L.addListener(y,this._onMousewheel,this,true);this.addListener(x,this._onResize,this);},properties:{focusable:{refine:true,init:true},width:{refine:true,init:120},maxListHeight:{check:s,apply:o,nullable:true,init:200},format:{check:w,init:function(J){return this._defaultFormat(J);},nullable:true}},members:{_createChildControlImpl:function(D){var E;switch(D){case A:E=new qx.ui.form.List().set({focusable:false,keepFocus:true,height:null,width:null,maxHeight:this.getMaxListHeight(),selectionMode:p,quickSelection:true});E.addListener(l,this._onListChangeSelection,this);E.addListener(k,this._onListMouseDown,this);break;case B:E=new qx.ui.popup.Popup(new qx.ui.layout.VBox);E.setAutoHide(false);E.setKeepActive(true);E.addListener(i,this.close,this);E.add(this.getChildControl(A));E.addListener(m,this._onPopupChangeVisibility,this);break;}return E||qx.ui.core.Widget.prototype._createChildControlImpl.call(this,D);},_applyMaxListHeight:function(f,g){this.getChildControl(A).setMaxHeight(f);},getChildrenContainer:function(){return this.getChildControl(A);},open:function(){var d=this.getChildControl(B);d.placeToWidget(this,true);d.show();},close:function(){this.getChildControl(B).hide();},toggle:function(){var K=this.getChildControl(B).isVisible();if(K){this.close();}else{this.open();}},_defaultFormat:function(a){var b=a?a.getLabel():z;var c=a?a.getRich():false;if(c){b=b.replace(/<[^>]+?>/g,z);b=qx.bom.String.unescape(b);}return b;},_onBlur:function(e){this.close();},_onKeyPress:function(e){var F=e.getKeyIdentifier();var G=this.getChildControl(B);if(G.isHidden()&&(F==j||F==r)){e.stopPropagation();}else if(!G.isHidden()&&F==n){this.close();e.stop();}else{this.getChildControl(A).handleKeyPress(e);}},_onMousewheel:function(e){var I=e.getTarget();var H=this.getChildControl(B,true);if(H==null){return;}if(qx.ui.core.Widget.contains(H,I)){e.preventDefault();}else{this.close();}},_onResize:function(e){this.getChildControl(B).setMinWidth(e.getData().width);},_onListChangeSelection:function(e){throw new Error("Abstract method: _onListChangeSelection()");},_onListMouseDown:function(e){throw new Error("Abstract method: _onListMouseDown()");},_onPopupChangeVisibility:function(e){throw new Error("Abstract method: _onPopupChangeVisibility()");}},destruct:function(){var C=qx.core.Init.getApplication().getRoot();if(C){C.removeListener(y,this._onMousewheel,this,true);}}});})();(function(){var K="textfield",J="button",I="list",H="selected",G="focusout",F="inner",E="changeValue",D="popup",C="focusin",B="combobox",u="click",A="blur",x="Enter",t="quick",s="_applyPlaceholder",w="qx.ui.form.ComboBox",v="single",y="Down",r="String",z="qx.event.type.Data";qx.Class.define(w,{extend:qx.ui.form.AbstractSelectBox,implement:[qx.ui.form.IStringForm],construct:function(){qx.ui.form.AbstractSelectBox.call(this);var g=this._createChildControl(K);this._createChildControl(J);this.addListener(u,this._onClick);this.addListener(C,function(e){g.fireNonBubblingEvent(C,qx.event.type.Focus);},this);this.addListener(G,function(e){g.fireNonBubblingEvent(G,qx.event.type.Focus);},this);},properties:{appearance:{refine:true,init:B},placeholder:{check:r,nullable:true,apply:s}},events:{"changeValue":z},members:{__rq:null,__rr:null,_applyPlaceholder:function(a,b){this.getChildControl(K).setPlaceholder(a);},_createChildControlImpl:function(d){var f;switch(d){case K:f=new qx.ui.form.TextField();f.setFocusable(false);f.addState(F);f.addListener(E,this._onTextFieldChangeValue,this);f.addListener(A,this.close,this);this._add(f,{flex:1});break;case J:f=new qx.ui.form.Button();f.setFocusable(false);f.setKeepActive(true);f.addState(F);this._add(f);break;case I:f=qx.ui.form.AbstractSelectBox.prototype._createChildControlImpl.call(this,d);f.setSelectionMode(v);break;}return f||qx.ui.form.AbstractSelectBox.prototype._createChildControlImpl.call(this,d);},_forwardStates:{focused:true},tabFocus:function(){var P=this.getChildControl(K);P.getFocusElement().focus();P.selectAllText();},focus:function(){qx.ui.form.AbstractSelectBox.prototype.focus.call(this);this.getChildControl(K).getFocusElement().focus();},setValue:function(R){var S=this.getChildControl(K);if(S.getValue()==R){return;}S.setValue(R);},getValue:function(){return this.getChildControl(K).getValue();},resetValue:function(){this.getChildControl(K).setValue(null);},_onKeyPress:function(e){var q=this.getChildControl(D);var p=e.getKeyIdentifier();if(p==y&&e.isAltPressed()){this.getChildControl(J).addState(H);this.toggle();e.stopPropagation();}else if(p==x){if(q.isVisible()){this.close();e.stop();}}else if(q.isVisible()){qx.ui.form.AbstractSelectBox.prototype._onKeyPress.call(this,e);}},_onClick:function(e){var c=e.getTarget();if(c==this.getChildControl(J)){this.toggle();}else{this.close();}},_onListMouseDown:function(e){if(this.__rq){var Q=this.__rq.getLabel();if(this.getFormat()!=null){Q=this.getFormat().call(this,this.__rq);}if(Q&&Q.translate){Q=Q.translate();}this.setValue(Q);this.__rq=null;}},_onListChangeSelection:function(e){var m=e.getData();if(m.length>0){var n=this.getChildControl(I);if(n.getSelectionContext()==t){this.__rq=m[0];}else{var o=m[0].getLabel();if(this.getFormat()!=null){o=this.getFormat().call(this,m[0]);}if(o&&o.translate){o=o.translate();}this.setValue(o);this.__rq=null;}}},_onPopupChangeVisibility:function(e){var M=this.getChildControl(D);if(M.isVisible()){var N=this.getChildControl(I);var O=this.getValue();var L=null;if(O){L=N.findItem(O);}if(L){N.setSelection([L]);}else{N.resetSelection();}}else{this.tabFocus();}this.getChildControl(J).removeState(H);},_onTextFieldChangeValue:function(e){var l=e.getData();var k=this.getChildControl(I);if(l!=null){var j=k.findItem(l,false);if(j){k.setSelection([j]);}else{k.resetSelection();}}else{k.resetSelection();}this.fireDataEvent(E,l,e.getOldData());},getTextSelection:function(){return this.getChildControl(K).getTextSelection();},getTextSelectionLength:function(){return this.getChildControl(K).getTextSelectionLength();},setTextSelection:function(h,i){this.getChildControl(K).setTextSelection(h,i);},clearTextSelection:function(){this.getChildControl(K).clearTextSelection();},selectAllText:function(){this.getChildControl(K).selectAllText();}}});})();(function(){var Y="scrollbar-y",X="scrollbar-x",W="pane",V="auto",U="corner",T="on",S="changeVisibility",R="scroll",Q="_computeScrollbars",P="off",I="scrollY",O="qx.ui.core.scroll.AbstractScrollArea",L="abstract",G="update",F="scrollX",K="mousewheel",J="scrollbarY",M="scrollbarX",E="horizontal",N="scrollarea",H="vertical";qx.Class.define(O,{extend:qx.ui.core.Widget,include:qx.ui.core.scroll.MScrollBarFactory,type:L,construct:function(){qx.ui.core.Widget.call(this);var b=new qx.ui.layout.Grid();b.setColumnFlex(0,1);b.setRowFlex(0,1);this._setLayout(b);this.addListener(K,this._onMouseWheel,this);},properties:{appearance:{refine:true,init:N},width:{refine:true,init:100},height:{refine:true,init:200},scrollbarX:{check:[V,T,P],init:V,themeable:true,apply:Q},scrollbarY:{check:[V,T,P],init:V,themeable:true,apply:Q},scrollbar:{group:[M,J]}},members:{_createChildControlImpl:function(h){var i;switch(h){case W:i=new qx.ui.core.scroll.ScrollPane();i.addListener(G,this._computeScrollbars,this);i.addListener(F,this._onScrollPaneX,this);i.addListener(I,this._onScrollPaneY,this);this._add(i,{row:0,column:0});break;case X:i=this._createScrollBar(E);i.setMinWidth(0);i.exclude();i.addListener(R,this._onScrollBarX,this);i.addListener(S,this._onChangeScrollbarXVisibility,this);this._add(i,{row:1,column:0});break;case Y:i=this._createScrollBar(H);i.setMinHeight(0);i.exclude();i.addListener(R,this._onScrollBarY,this);i.addListener(S,this._onChangeScrollbarYVisibility,this);this._add(i,{row:0,column:1});break;case U:i=new qx.ui.core.Widget();i.setWidth(0);i.setHeight(0);i.exclude();this._add(i,{row:1,column:1});break;}return i||qx.ui.core.Widget.prototype._createChildControlImpl.call(this,h);},getPaneSize:function(){return this.getChildControl(W).getInnerSize();},getItemTop:function(ba){return this.getChildControl(W).getItemTop(ba);},getItemBottom:function(D){return this.getChildControl(W).getItemBottom(D);},getItemLeft:function(j){return this.getChildControl(W).getItemLeft(j);},getItemRight:function(y){return this.getChildControl(W).getItemRight(y);},scrollToX:function(a){qx.ui.core.queue.Manager.flush();this.getChildControl(X).scrollTo(a);},scrollByX:function(w){qx.ui.core.queue.Manager.flush();this.getChildControl(X).scrollBy(w);},getScrollX:function(){var g=this.getChildControl(X,true);return g?g.getPosition():0;},scrollToY:function(u){qx.ui.core.queue.Manager.flush();this.getChildControl(Y).scrollTo(u);},scrollByY:function(v){qx.ui.core.queue.Manager.flush();this.getChildControl(Y).scrollBy(v);},getScrollY:function(){var x=this.getChildControl(Y,true);return x?x.getPosition():0;},_onScrollBarX:function(e){this.getChildControl(W).scrollToX(e.getData());},_onScrollBarY:function(e){this.getChildControl(W).scrollToY(e.getData());},_onScrollPaneX:function(e){this.scrollToX(e.getData());},_onScrollPaneY:function(e){this.scrollToY(e.getData());},_onMouseWheel:function(e){var d=this._isChildControlVisible(X);var f=this._isChildControlVisible(Y);var c=(f)?this.getChildControl(Y,true):(d?this.getChildControl(X,true):null);if(c){c.scrollBySteps(e.getWheelDelta());e.stop();}},_onChangeScrollbarXVisibility:function(e){var B=this._isChildControlVisible(X);var C=this._isChildControlVisible(Y);if(!B){this.scrollToX(0);}B&&C?this._showChildControl(U):this._excludeChildControl(U);},_onChangeScrollbarYVisibility:function(e){var z=this._isChildControlVisible(X);var A=this._isChildControlVisible(Y);if(!A){this.scrollToY(0);}z&&A?this._showChildControl(U):this._excludeChildControl(U);},_computeScrollbars:function(){var q=this.getChildControl(W);var content=q.getChildren()[0];if(!content){this._excludeChildControl(X);this._excludeChildControl(Y);return;}var k=this.getInnerSize();var p=q.getInnerSize();var n=q.getScrollSize();if(!p||!n){return;}var r=this.getScrollbarX();var s=this.getScrollbarY();if(r===V&&s===V){var o=n.width>k.width;var t=n.height>k.height;if((o||t)&&!(o&&t)){if(o){t=n.height>p.height;}else if(t){o=n.width>p.width;}}}else{var o=r===T;var t=s===T;if(n.width>(o?p.width:k.width)&&r===V){o=true;}if(n.height>(o?p.height:k.height)&&s===V){t=true;}}if(o){var m=this.getChildControl(X);m.show();m.setMaximum(Math.max(0,n.width-p.width));m.setKnobFactor((n.width===0)?0:p.width/n.width);}else{this._excludeChildControl(X);}if(t){var l=this.getChildControl(Y);l.show();l.setMaximum(Math.max(0,n.height-p.height));l.setKnobFactor((n.height===0)?0:p.height/n.height);}else{this._excludeChildControl(Y);}}}});})();(function(){var b="qx.ui.core.IMultiSelection";qx.Interface.define(b,{extend:qx.ui.core.ISingleSelection,members:{selectAll:function(){return true;},addToSelection:function(a){return arguments.length==1;},removeFromSelection:function(c){return arguments.length==1;}}});})();(function(){var H="single",G="Boolean",F="one",E="changeSelection",D="__rs",C="mouseup",B="mousedown",A="losecapture",z="multi",y="_applyQuickSelection",r="mouseover",x="_applySelectionMode",u="_applyDragSelection",q="qx.ui.core.MMultiSelectionHandling",p="removeItem",t="keypress",s="qx.event.type.Data",v="addItem",o="additive",w="mousemove";qx.Mixin.define(q,{construct:function(){var K=this.SELECTION_MANAGER;var J=this.__rs=new K(this);this.addListener(B,J.handleMouseDown,J);this.addListener(C,J.handleMouseUp,J);this.addListener(r,J.handleMouseOver,J);this.addListener(w,J.handleMouseMove,J);this.addListener(A,J.handleLoseCapture,J);this.addListener(t,J.handleKeyPress,J);this.addListener(v,J.handleAddItem,J);this.addListener(p,J.handleRemoveItem,J);J.addListener(E,this._onSelectionChange,this);},events:{"changeSelection":s},properties:{selectionMode:{check:[H,z,o,F],init:H,apply:x},dragSelection:{check:G,init:false,apply:u},quickSelection:{check:G,init:false,apply:y}},members:{__rs:null,selectAll:function(){this.__rs.selectAll();},isSelected:function(f){if(!qx.ui.core.Widget.contains(this,f)){throw new Error("Could not test if "+f+" is selected, because it is not a child element!");}return this.__rs.isItemSelected(f);},addToSelection:function(M){if(!qx.ui.core.Widget.contains(this,M)){throw new Error("Could not add + "+M+" to selection, because it is not a child element!");}this.__rs.addItem(M);},removeFromSelection:function(g){if(!qx.ui.core.Widget.contains(this,g)){throw new Error("Could not remove "+g+" from selection, because it is not a child element!");}this.__rs.removeItem(g);},selectRange:function(h,j){this.__rs.selectItemRange(h,j);},resetSelection:function(){this.__rs.clearSelection();},setSelection:function(c){for(var i=0;i<c.length;i++){if(!qx.ui.core.Widget.contains(this,c[i])){throw new Error("Could not select "+c[i]+", because it is not a child element!");}}if(c.length===0){this.resetSelection();}else{var d=this.getSelection();if(!qx.lang.Array.equals(d,c)){this.__rs.replaceSelection(c);}}},getSelection:function(){return this.__rs.getSelection();},getSortedSelection:function(){return this.__rs.getSortedSelection();},isSelectionEmpty:function(){return this.__rs.isSelectionEmpty();},getSelectionContext:function(){return this.__rs.getSelectionContext();},_getManager:function(){return this.__rs;},getSelectables:function(I){return this.__rs.getSelectables(I);},invertSelection:function(){this.__rs.invertSelection();},_getLeadItem:function(){var L=this.__rs.getMode();if(L===H||L===F){return this.__rs.getSelectedItem();}else{return this.__rs.getLeadItem();}},_applySelectionMode:function(a,b){this.__rs.setMode(a);},_applyDragSelection:function(m,n){this.__rs.setDrag(m);},_applyQuickSelection:function(k,l){this.__rs.setQuick(k);},_onSelectionChange:function(e){this.fireDataEvent(E,e.getData());}},destruct:function(){this._disposeObjects(D);}});})();(function(){var by="one",bx="single",bw="selected",bv="additive",bu="multi",bt="PageUp",bs="under",br="Left",bq="lead",bp="Down",bW="Up",bV="Boolean",bU="PageDown",bT="anchor",bS="End",bR="Home",bQ="Right",bP="right",bO="click",bN="above",bF="left",bG="Escape",bD="A",bE="Space",bB="_applyMode",bC="interval",bz="changeSelection",bA="qx.event.type.Data",bH="quick",bI="key",bK="__rw",bJ="abstract",bM="drag",bL="qx.ui.core.selection.Abstract";qx.Class.define(bL,{type:bJ,extend:qx.core.Object,construct:function(){qx.core.Object.call(this);this.__rt={};},events:{"changeSelection":bA},properties:{mode:{check:[bx,bu,bv,by],init:bx,apply:bB},drag:{check:bV,init:false},quick:{check:bV,init:false}},members:{__ru:0,__rv:0,__rw:null,__rx:null,__ry:null,__rz:null,__rA:null,__rB:null,__rC:null,__rD:null,__rE:null,__rF:null,__rG:null,__rH:null,__rI:null,__rJ:null,__rK:null,__rt:null,__rL:null,__rM:null,_userInteraction:false,__rN:null,getSelectionContext:function(){return this.__rJ;},selectAll:function(){var cO=this.getMode();if(cO==bx||cO==by){throw new Error("Can not select all items in selection mode: "+cO);}this._selectAllItems();this._fireChange();},selectItem:function(bh){this._setSelectedItem(bh);var bi=this.getMode();if(bi!==bx&&bi!==by){this._setLeadItem(bh);this._setAnchorItem(bh);}this._scrollItemIntoView(bh);this._fireChange();},addItem:function(cp){var cq=this.getMode();if(cq===bx||cq===by){this._setSelectedItem(cp);}else{if(!this._getAnchorItem()){this._setAnchorItem(cp);}this._setLeadItem(cp);this._addToSelection(cp);}this._scrollItemIntoView(cp);this._fireChange();},removeItem:function(cR){this._removeFromSelection(cR);if(this.getMode()===by&&this.isSelectionEmpty()){var cS=this._getFirstSelectable();if(cS){this.addItem(cS);}if(cS==cR){return;}}if(this.getLeadItem()==cR){this._setLeadItem(null);}if(this._getAnchorItem()==cR){this._setAnchorItem(null);}this._fireChange();},selectItemRange:function(bc,bd){var be=this.getMode();if(be==bx||be==by){throw new Error("Can not select multiple items in selection mode: "+be);}this._selectItemRange(bc,bd);this._setAnchorItem(bc);this._setLeadItem(bd);this._scrollItemIntoView(bd);this._fireChange();},clearSelection:function(){if(this.getMode()==by){return;}this._clearSelection();this._setLeadItem(null);this._setAnchorItem(null);this._fireChange();},replaceSelection:function(cd){var ce=this.getMode();if(ce==by||ce===bx){if(cd.length>1){throw new Error("Could not select more than one items in mode: "+ce+"!");}if(cd.length==1){this.selectItem(cd[0]);}else{this.clearSelection();}return;}else{this._replaceMultiSelection(cd);}},getSelectedItem:function(){var r=this.getMode();if(r===bx||r===by){return this._getSelectedItem()||null;}throw new Error("The method getSelectedItem() is only supported in 'single' and 'one' selection mode!");},getSelection:function(){return qx.lang.Object.getValues(this.__rt);},getSortedSelection:function(){var bo=this.getSelectables();var bn=qx.lang.Object.getValues(this.__rt);bn.sort(function(a,b){return bo.indexOf(a)-bo.indexOf(b);});return bn;},isItemSelected:function(cx){var cy=this._selectableToHashCode(cx);return this.__rt[cy]!==undefined;},isSelectionEmpty:function(){return qx.lang.Object.isEmpty(this.__rt);},invertSelection:function(){var ck=this.getMode();if(ck===bx||ck===by){throw new Error("The method invertSelection() is only supported in 'multi' and 'additive' selection mode!");}var cj=this.getSelectables();for(var i=0;i<cj.length;i++){this._toggleInSelection(cj[i]);}this._fireChange();},_setLeadItem:function(cP){var cQ=this.__rK;if(cQ!==null){this._styleSelectable(cQ,bq,false);}if(cP!==null){this._styleSelectable(cP,bq,true);}this.__rK=cP;},getLeadItem:function(){return this.__rK!==null?this.__rK:null;},_setAnchorItem:function(s){var t=this.__rL;if(t){this._styleSelectable(t,bT,false);}if(s){this._styleSelectable(s,bT,true);}this.__rL=s;},_getAnchorItem:function(){return this.__rL!==null?this.__rL:null;},_isSelectable:function(E){throw new Error("Abstract method call: _isSelectable()");},_getSelectableFromMouseEvent:function(event){var ci=event.getTarget();if(ci&&this._isSelectable(ci)){return ci;}return null;},_selectableToHashCode:function(cc){throw new Error("Abstract method call: _selectableToHashCode()");},_styleSelectable:function(c,d,f){throw new Error("Abstract method call: _styleSelectable()");},_capture:function(){throw new Error("Abstract method call: _capture()");},_releaseCapture:function(){throw new Error("Abstract method call: _releaseCapture()");},_getLocation:function(){throw new Error("Abstract method call: _getLocation()");},_getDimension:function(){throw new Error("Abstract method call: _getDimension()");},_getSelectableLocationX:function(ct){throw new Error("Abstract method call: _getSelectableLocationX()");},_getSelectableLocationY:function(cf){throw new Error("Abstract method call: _getSelectableLocationY()");},_getScroll:function(){throw new Error("Abstract method call: _getScroll()");},_scrollBy:function(cX,cY){throw new Error("Abstract method call: _scrollBy()");},_scrollItemIntoView:function(H){throw new Error("Abstract method call: _scrollItemIntoView()");},getSelectables:function(co){throw new Error("Abstract method call: getSelectables()");},_getSelectableRange:function(bf,bg){throw new Error("Abstract method call: _getSelectableRange()");},_getFirstSelectable:function(){throw new Error("Abstract method call: _getFirstSelectable()");},_getLastSelectable:function(){throw new Error("Abstract method call: _getLastSelectable()");},_getRelatedSelectable:function(cV,cW){throw new Error("Abstract method call: _getRelatedSelectable()");},_getPage:function(ba,bb){throw new Error("Abstract method call: _getPage()");},_applyMode:function(cl,cm){this._setLeadItem(null);this._setAnchorItem(null);this._clearSelection();if(cl===by){var cn=this._getFirstSelectable();if(cn){this._setSelectedItem(cn);this._scrollItemIntoView(cn);}}this._fireChange();},handleMouseOver:function(event){if(this.__rN!=null&&this.__rN!=this._getScroll().top){this.__rN=null;return;}this._userInteraction=true;if(!this.getQuick()){this._userInteraction=false;return;}var G=this.getMode();if(G!==by&&G!==bx){this._userInteraction=false;return;}var F=this._getSelectableFromMouseEvent(event);if(F===null){this._userInteraction=false;return;}this._setSelectedItem(F);this._fireChange(bH);this._userInteraction=false;},handleMouseDown:function(event){this._userInteraction=true;var J=this._getSelectableFromMouseEvent(event);if(J===null){this._userInteraction=false;return;}var L=event.isCtrlPressed()||(qx.bom.client.Platform.MAC&&event.isMetaPressed());var I=event.isShiftPressed();if(this.isItemSelected(J)&&!I&&!L&&!this.getDrag()){this.__rM=J;this._userInteraction=false;return;}else{this.__rM=null;}this._scrollItemIntoView(J);switch(this.getMode()){case bx:case by:this._setSelectedItem(J);break;case bv:this._setLeadItem(J);this._setAnchorItem(J);this._toggleInSelection(J);break;case bu:this._setLeadItem(J);if(I){var K=this._getAnchorItem();if(K===null){K=this._getFirstSelectable();this._setAnchorItem(K);}this._selectItemRange(K,J,L);}else if(L){this._setAnchorItem(J);this._toggleInSelection(J);}else{this._setAnchorItem(J);this._setSelectedItem(J);}break;}var M=this.getMode();if(this.getDrag()&&M!==bx&&M!==by&&!I&&!L){this.__rA=this._getLocation();this.__rx=this._getScroll();this.__rB=event.getDocumentLeft()+this.__rx.left;this.__rC=event.getDocumentTop()+this.__rx.top;this.__rD=true;this._capture();}this._fireChange(bO);this._userInteraction=false;},handleMouseUp:function(event){this._userInteraction=true;var bm=event.isCtrlPressed()||(qx.bom.client.Platform.MAC&&event.isMetaPressed());var bj=event.isShiftPressed();if(!bm&&!bj&&this.__rM){var bk=this._getSelectableFromMouseEvent(event);if(bk===null||!this.isItemSelected(bk)){this._userInteraction=false;return;}var bl=this.getMode();if(bl===bv){this._removeFromSelection(bk);}else{this._setSelectedItem(bk);if(this.getMode()===bu){this._setLeadItem(bk);this._setAnchorItem(bk);}}this._userInteraction=false;}this._cleanup();},handleLoseCapture:function(event){this._cleanup();},handleMouseMove:function(event){if(!this.__rD){return;}this.__rE=event.getDocumentLeft();this.__rF=event.getDocumentTop();this._userInteraction=true;var h=this.__rE+this.__rx.left;if(h>this.__rB){this.__rG=1;}else if(h<this.__rB){this.__rG=-1;}else{this.__rG=0;}var g=this.__rF+this.__rx.top;if(g>this.__rC){this.__rH=1;}else if(g<this.__rC){this.__rH=-1;}else{this.__rH=0;}var location=this.__rA;if(this.__rE<location.left){this.__ru=this.__rE-location.left;}else if(this.__rE>location.right){this.__ru=this.__rE-location.right;}else{this.__ru=0;}if(this.__rF<location.top){this.__rv=this.__rF-location.top;}else if(this.__rF>location.bottom){this.__rv=this.__rF-location.bottom;}else{this.__rv=0;}if(!this.__rw){this.__rw=new qx.event.Timer(100);this.__rw.addListener(bC,this._onInterval,this);}this.__rw.start();this._autoSelect();event.stopPropagation();this._userInteraction=false;},handleAddItem:function(e){var u=e.getData();if(this.getMode()===by&&this.isSelectionEmpty()){this.addItem(u);}},handleRemoveItem:function(e){this.removeItem(e.getData());},_cleanup:function(){if(!this.getDrag()&&this.__rD){return;}if(this.__rI){this._fireChange(bO);}delete this.__rD;delete this.__ry;delete this.__rz;this._releaseCapture();if(this.__rw){this.__rw.stop();}},_onInterval:function(e){this._scrollBy(this.__ru,this.__rv);this.__rx=this._getScroll();this._autoSelect();},_autoSelect:function(){var cK=this._getDimension();var cD=Math.max(0,Math.min(this.__rE-this.__rA.left,cK.width))+this.__rx.left;var cC=Math.max(0,Math.min(this.__rF-this.__rA.top,cK.height))+this.__rx.top;if(this.__ry===cD&&this.__rz===cC){return;}this.__ry=cD;this.__rz=cC;var cM=this._getAnchorItem();var cF=cM;var cI=this.__rG;var cL,cE;while(cI!==0){cL=cI>0?this._getRelatedSelectable(cF,bP):this._getRelatedSelectable(cF,bF);if(cL!==null){cE=this._getSelectableLocationX(cL);if((cI>0&&cE.left<=cD)||(cI<0&&cE.right>=cD)){cF=cL;continue;}}break;}var cJ=this.__rH;var cH,cG;while(cJ!==0){cH=cJ>0?this._getRelatedSelectable(cF,bs):this._getRelatedSelectable(cF,bN);if(cH!==null){cG=this._getSelectableLocationY(cH);if((cJ>0&&cG.top<=cC)||(cJ<0&&cG.bottom>=cC)){cF=cH;continue;}}break;}var cN=this.getMode();if(cN===bu){this._selectItemRange(cM,cF);}else if(cN===bv){if(this.isItemSelected(cM)){this._selectItemRange(cM,cF,true);}else{this._deselectItemRange(cM,cF);}this._setAnchorItem(cF);}this._fireChange(bM);},__rO:{Home:1,Down:1,Right:1,PageDown:1,End:1,Up:1,Left:1,PageUp:1},handleKeyPress:function(event){this._userInteraction=true;var S,R;var U=event.getKeyIdentifier();var T=this.getMode();var O=event.isCtrlPressed()||(qx.bom.client.Platform.MAC&&event.isMetaPressed());var P=event.isShiftPressed();var Q=false;if(U===bD&&O){if(T!==bx&&T!==by){this._selectAllItems();Q=true;}}else if(U===bG){if(T!==bx&&T!==by){this._clearSelection();Q=true;}}else if(U===bE){var N=this.getLeadItem();if(N&&!P){if(O||T===bv){this._toggleInSelection(N);}else{this._setSelectedItem(N);}Q=true;}}else if(this.__rO[U]){Q=true;if(T===bx||T==by){S=this._getSelectedItem();}else{S=this.getLeadItem();}if(S!==null){switch(U){case bR:R=this._getFirstSelectable();break;case bS:R=this._getLastSelectable();break;case bW:R=this._getRelatedSelectable(S,bN);break;case bp:R=this._getRelatedSelectable(S,bs);break;case br:R=this._getRelatedSelectable(S,bF);break;case bQ:R=this._getRelatedSelectable(S,bP);break;case bt:R=this._getPage(S,true);break;case bU:R=this._getPage(S,false);break;}}else{switch(U){case bR:case bp:case bQ:case bU:R=this._getFirstSelectable();break;case bS:case bW:case br:case bt:R=this._getLastSelectable();break;}}if(R!==null){switch(T){case bx:case by:this._setSelectedItem(R);break;case bv:this._setLeadItem(R);break;case bu:if(P){var V=this._getAnchorItem();if(V===null){this._setAnchorItem(V=this._getFirstSelectable());}this._setLeadItem(R);this._selectItemRange(V,R,O);}else{this._setAnchorItem(R);this._setLeadItem(R);if(!O){this._setSelectedItem(R);}}break;}this.__rN=this._getScroll().top;this._scrollItemIntoView(R);}}if(Q){event.stop();this._fireChange(bI);}this._userInteraction=false;},_selectAllItems:function(){var bX=this.getSelectables();for(var i=0,l=bX.length;i<l;i++){this._addToSelection(bX[i]);}},_clearSelection:function(){var cT=this.__rt;for(var cU in cT){this._removeFromSelection(cT[cU]);}this.__rt={};},_selectItemRange:function(j,k,m){var p=this._getSelectableRange(j,k);if(!m){var o=this.__rt;var q=this.__rP(p);for(var n in o){if(!q[n]){this._removeFromSelection(o[n]);}}}for(var i=0,l=p.length;i<l;i++){this._addToSelection(p[i]);}},_deselectItemRange:function(cu,cv){var cw=this._getSelectableRange(cu,cv);for(var i=0,l=cw.length;i<l;i++){this._removeFromSelection(cw[i]);}},__rP:function(W){var Y={};var X;for(var i=0,l=W.length;i<l;i++){X=W[i];Y[this._selectableToHashCode(X)]=X;}return Y;},_getSelectedItem:function(){for(var D in this.__rt){return this.__rt[D];}return null;},_setSelectedItem:function(cz){if(this._isSelectable(cz)){var cA=this.__rt;var cB=this._selectableToHashCode(cz);if(!cA[cB]||qx.lang.Object.hasMinLength(cA,2)){this._clearSelection();this._addToSelection(cz);}}},_addToSelection:function(cg){var ch=this._selectableToHashCode(cg);if(!this.__rt[ch]&&this._isSelectable(cg)){this.__rt[ch]=cg;this._styleSelectable(cg,bw,true);this.__rI=true;}},_toggleInSelection:function(cr){var cs=this._selectableToHashCode(cr);if(!this.__rt[cs]){this.__rt[cs]=cr;this._styleSelectable(cr,bw,true);}else{delete this.__rt[cs];this._styleSelectable(cr,bw,false);}this.__rI=true;},_removeFromSelection:function(bY){var ca=this._selectableToHashCode(bY);if(this.__rt[ca]!=null){delete this.__rt[ca];this._styleSelectable(bY,bw,false);this.__rI=true;}},_replaceMultiSelection:function(v){var y=false;var B,A;var w={};for(var i=0,l=v.length;i<l;i++){B=v[i];if(this._isSelectable(B)){A=this._selectableToHashCode(B);w[A]=B;}}var C=v[0];var x=B;var z=this.__rt;for(var A in z){if(w[A]){delete w[A];}else{B=z[A];delete z[A];this._styleSelectable(B,bw,false);y=true;}}for(var A in w){B=z[A]=w[A];this._styleSelectable(B,bw,true);y=true;}if(!y){return false;}this._scrollItemIntoView(x);this._setLeadItem(C);this._setAnchorItem(C);this.__rI=true;this._fireChange();},_fireChange:function(cb){if(this.__rI){this.__rJ=cb||null;this.fireDataEvent(bz,this.getSelection());delete this.__rI;}}},destruct:function(){this._disposeObjects(bK);this.__rt=this.__rM=this.__rL=null;this.__rK=null;}});})();(function(){var H="vertical",G="under",F="above",E="qx.ui.core.selection.Widget",D="left",C="right";qx.Class.define(E,{extend:qx.ui.core.selection.Abstract,construct:function(o){qx.ui.core.selection.Abstract.call(this);this.__rQ=o;},members:{__rQ:null,_isSelectable:function(b){return this._isItemSelectable(b)&&b.getLayoutParent()===this.__rQ;},_selectableToHashCode:function(a){return a.$$hash;},_styleSelectable:function(v,w,x){x?v.addState(w):v.removeState(w);},_capture:function(){this.__rQ.capture();},_releaseCapture:function(){this.__rQ.releaseCapture();},_isItemSelectable:function(I){if(this._userInteraction){return I.isVisible()&&I.isEnabled();}else{return I.isVisible();}},_getWidget:function(){return this.__rQ;},_getLocation:function(){var n=this.__rQ.getContentElement().getDomElement();return n?qx.bom.element.Location.get(n):null;},_getDimension:function(){return this.__rQ.getInnerSize();},_getSelectableLocationX:function(K){var L=K.getBounds();if(L){return {left:L.left,right:L.left+L.width};}},_getSelectableLocationY:function(c){var d=c.getBounds();if(d){return {top:d.top,bottom:d.top+d.height};}},_getScroll:function(){return {left:0,top:0};},_scrollBy:function(A,B){},_scrollItemIntoView:function(M){this.__rQ.scrollChildIntoView(M);},getSelectables:function(N){var O=false;if(!N){O=this._userInteraction;this._userInteraction=true;}var R=this.__rQ.getChildren();var P=[];var Q;for(var i=0,l=R.length;i<l;i++){Q=R[i];if(this._isItemSelectable(Q)){P.push(Q);}}this._userInteraction=O;return P;},_getSelectableRange:function(p,q){if(p===q){return [p];}var u=this.__rQ.getChildren();var r=[];var t=false;var s;for(var i=0,l=u.length;i<l;i++){s=u[i];if(s===p||s===q){if(t){r.push(s);break;}else{t=true;}}if(t&&this._isItemSelectable(s)){r.push(s);}}return r;},_getFirstSelectable:function(){var J=this.__rQ.getChildren();for(var i=0,l=J.length;i<l;i++){if(this._isItemSelectable(J[i])){return J[i];}}return null;},_getLastSelectable:function(){var e=this.__rQ.getChildren();for(var i=e.length-1;i>0;i--){if(this._isItemSelectable(e[i])){return e[i];}}return null;},_getRelatedSelectable:function(f,g){var k=this.__rQ.getOrientation()===H;var j=this.__rQ.getChildren();var h=j.indexOf(f);var m;if((k&&g===F)||(!k&&g===D)){for(var i=h-1;i>=0;i--){m=j[i];if(this._isItemSelectable(m)){return m;}}}else if((k&&g===G)||(!k&&g===C)){for(var i=h+1;i<j.length;i++){m=j[i];if(this._isItemSelectable(m)){return m;}}}return null;},_getPage:function(y,z){if(z){return this._getFirstSelectable();}else{return this._getLastSelectable();}}},destruct:function(){this.__rQ=null;}});})();(function(){var a="qx.ui.core.selection.ScrollArea";qx.Class.define(a,{extend:qx.ui.core.selection.Widget,members:{_isSelectable:function(s){return this._isItemSelectable(s)&&s.getLayoutParent()===this._getWidget().getChildrenContainer();},_getDimension:function(){return this._getWidget().getPaneSize();},_getScroll:function(){var r=this._getWidget();return {left:r.getScrollX(),top:r.getScrollY()};},_scrollBy:function(o,p){var q=this._getWidget();q.scrollByX(o);q.scrollByY(p);},_getPage:function(b,c){var g=this.getSelectables();var length=g.length;var k=g.indexOf(b);if(k===-1){throw new Error("Invalid lead item: "+b);}var d=this._getWidget();var m=d.getScrollY();var innerHeight=d.getInnerSize().height;var top,f,l;if(c){var j=m;var i=k;while(1){for(;i>=0;i--){top=d.getItemTop(g[i]);if(top<j){l=i+1;break;}}if(l==null){var n=this._getFirstSelectable();return n==b?null:n;}if(l>=k){j-=innerHeight+m-d.getItemBottom(b);l=null;continue;}return g[l];}}else{var h=innerHeight+m;var i=k;while(1){for(;i<length;i++){f=d.getItemBottom(g[i]);if(f>h){l=i-1;break;}}if(l==null){var e=this._getLastSelectable();return e==b?null:e;}if(l<=k){h+=d.getItemTop(b)-m;l=null;continue;}return g[l];}}}}});})();(function(){var m="horizontal",k="qx.event.type.Data",j="vertical",h="",g="qx.ui.form.List",f="Enter",d="one",c="addChildWidget",b="_applySpacing",a="Boolean",y="Integer",x="action",w="keyinput",v="addItem",u="removeChildWidget",t="_applyOrientation",s="single",r="keypress",q="list",p="__rR",n="pane",o="removeItem";qx.Class.define(g,{extend:qx.ui.core.scroll.AbstractScrollArea,implement:[qx.ui.core.IMultiSelection,qx.ui.form.IForm,qx.ui.form.IModelSelection],include:[qx.ui.core.MRemoteChildrenHandling,qx.ui.core.MMultiSelectionHandling,qx.ui.form.MForm,qx.ui.form.MModelSelection],construct:function(z){qx.ui.core.scroll.AbstractScrollArea.call(this);this.__rR=new qx.ui.container.Composite();this.__rR.addListener(c,this._onAddChild,this);this.__rR.addListener(u,this._onRemoveChild,this);this.getChildControl(n).add(this.__rR);if(z){this.setOrientation(m);}else{this.initOrientation();}this.addListener(r,this._onKeyPress);this.addListener(w,this._onKeyInput);this.__rS=h;},events:{addItem:k,removeItem:k},properties:{appearance:{refine:true,init:q},focusable:{refine:true,init:true},orientation:{check:[m,j],init:j,apply:t},spacing:{check:y,init:0,apply:b,themeable:true},enableInlineFind:{check:a,init:true}},members:{__rS:null,__rT:null,__rR:null,SELECTION_MANAGER:qx.ui.core.selection.ScrollArea,getChildrenContainer:function(){return this.__rR;},_onAddChild:function(e){this.fireDataEvent(v,e.getData());},_onRemoveChild:function(e){this.fireDataEvent(o,e.getData());},handleKeyPress:function(e){if(!this._onKeyPress(e)){this._getManager().handleKeyPress(e);}},_applyOrientation:function(G,H){var I=G===m;var J=I?new qx.ui.layout.HBox():new qx.ui.layout.VBox();var content=this.__rR;content.setLayout(J);content.setAllowGrowX(!I);content.setAllowGrowY(I);this._applySpacing(this.getSpacing());},_applySpacing:function(K,L){this.__rR.getLayout().setSpacing(K);},_onKeyPress:function(e){if(e.getKeyIdentifier()==f&&!e.isAltPressed()){var F=this.getSelection();for(var i=0;i<F.length;i++){F[i].fireEvent(x);}return true;}return false;},_onKeyInput:function(e){if(!this.getEnableInlineFind()){return;}var A=this.getSelectionMode();if(!(A===s||A===d)){return;}if(((new Date).valueOf()-this.__rT)>1000){this.__rS=h;}this.__rS+=e.getChar();var B=this.findItemByLabelFuzzy(this.__rS);if(B){this.setSelection([B]);}this.__rT=(new Date).valueOf();},findItemByLabelFuzzy:function(C){C=C.toLowerCase();var D=this.getChildren();for(var i=0,l=D.length;i<l;i++){var E=D[i].getLabel();if(E&&E.toLowerCase().indexOf(C)==0){return D[i];}}return null;},findItem:function(M,N){if(N!==false){M=M.toLowerCase();}var O=this.getChildren();var Q;for(var i=0,l=O.length;i<l;i++){Q=O[i];var P=Q.getLabel();if(P!=null){if(P.translate){P=P.translate();}if(N!==false){P=P.toLowerCase();}if(P.toString()==M.toString()){return Q;}}}return null;}},destruct:function(){this._disposeObjects(p);}});})();(function(){var b="qx.ui.form.IModel",a="qx.event.type.Data";qx.Interface.define(b,{events:{"changeModel":a},members:{setModel:function(c){},getModel:function(){},resetModel:function(){}}});})();(function(){var b="changeModel",a="qx.ui.form.MModelProperty";qx.Mixin.define(a,{properties:{model:{nullable:true,event:b,dereference:true}}});})();(function(){var c="listitem",b="qx.ui.form.ListItem",a="qx.event.type.Event";qx.Class.define(b,{extend:qx.ui.basic.Atom,implement:[qx.ui.form.IModel],include:[qx.ui.form.MModelProperty],construct:function(d,e,f){qx.ui.basic.Atom.call(this,d,e);if(f!=null){this.setModel(f);}},events:{"action":a},properties:{appearance:{refine:true,init:c}},members:{_forwardStates:{focused:true,hovered:true,selected:true,dragover:true}}});})();(function(){var t="linear",s="Number",r="reverse",q="Boolean",p="none",o="wobble",n="flicker",m="pulse",l="sinodial",k="easeOutQuad",d="spring",j="easeInQuad",g="full",c="Color",b="__rU",f="backgroundColor",e="#ffffff",h="backgroundImage",a="qx.fx.effect.combination.ColorFlow",i="#ffffaa";qx.Class.define(a,{extend:qx.fx.Base,construct:function(u){qx.fx.Base.call(this,u);this.__rU=[new qx.fx.effect.core.Highlight(u),new qx.fx.effect.core.Highlight(u)];},properties:{startColor:{init:e,check:c},endColor:{init:i,check:c},forwardTransition:{init:t,check:[t,j,k,l,r,n,o,m,d,p,g]},backwardTransition:{init:t,check:[t,j,k,l,r,n,o,m,d,p,g]},forwardDuration:{init:1.0,check:s},backwardDuration:{init:1.0,check:s},delayBetween:{init:0.3,check:s},restoreBackground:{init:true,check:q},keepBackgroundImage:{init:false,check:q}},members:{__rV:null,__rU:null,start:function(){if(!qx.fx.Base.prototype.start.call(this)){return;}var v=this._getElement();this.setDuration(this.getForwardDuration()+this.getDelayBetween()+this.getBackwardDuration());this.__rV={backgroundImage:qx.bom.element.Style.get(v,h),backgroundColor:qx.bom.element.Style.get(v,f)};this.__rU[0].set({startColor:this.getStartColor(),endColor:this.getEndColor(),duration:this.getForwardDuration(),transition:this.getForwardTransition(),restoreBackground:false,keepBackgroundImage:this.getKeepBackgroundImage()});this.__rU[1].set({startColor:this.getEndColor(),endColor:this.getStartColor(),duration:this.getBackwardDuration(),transition:this.getBackwardTransition(),restoreBackground:this.getRestoreBackground(),keepBackgroundImage:this.getKeepBackgroundImage(),delay:this.getDelayBetween()});var self=this;this.__rU[0].afterFinishInternal=function(){self.__rU[1].start();};this.__rU[0].start();}},destruct:function(){this._disposeArray(b);}});})();(function(){var j="backgroundColor",i="Boolean",h="backgroundImage",g="Color",f="none",e="qx.fx.effect.core.Highlight",d="#ffffff",c="#",b="#ffffaa";qx.Class.define(e,{extend:qx.fx.Base,properties:{startColor:{init:d,check:g},endColor:{init:b,check:g},restoreBackground:{init:true,check:i},keepBackgroundImage:{init:false,check:i}},members:{__rW:null,__rX:null,__rY:null,__sa:null,setup:function(){qx.fx.Base.prototype.setup.call(this);var a=this._getElement();this.__rW={backgroundImage:qx.bom.element.Style.get(a,h),backgroundColor:qx.bom.element.Style.get(a,j)};if(!this.getKeepBackgroundImage()){qx.bom.element.Style.set(a,h,f);}this.__rX=qx.util.ColorUtil.cssStringToRgb(this.getStartColor());this.__rY=qx.util.ColorUtil.cssStringToRgb(this.getEndColor());this.__sa=[this.__rY[0]-this.__rX[0],this.__rY[1]-this.__rX[1],this.__rY[2]-this.__rX[2]];},update:function(m){qx.fx.Base.prototype.update.call(this);var n=[this.__rX[0]+Math.round(this.__sa[0]*m),this.__rX[1]+Math.round(this.__sa[1]*m),this.__rX[2]+Math.round(this.__sa[2]*m)];var o=c+qx.util.ColorUtil.rgbToHexString([n[0].toString(16),n[1].toString(16),n[2].toString(16)]);qx.bom.element.Style.set(this._getElement(),j,o);},finish:function(){qx.fx.Base.prototype.finish.call(this);if(this.getRestoreBackground()){qx.lang.Function.delay(this._restore,1000,this);}},_restore:function(){var l=this._getElement();for(var k in this.__rW){qx.bom.element.Style.set(l,k,this.__rW[k]);}}},destruct:function(){this.__rX=this.__rY=this.__sa=null;}});})();(function(){var b="qx.ui.form.IDateForm",a="qx.event.type.Data";qx.Interface.define(b,{events:{"changeValue":a},members:{setValue:function(c){return arguments.length==1;},resetValue:function(){},getValue:function(){}}});})();(function(){var C="selected",B="click",A="last-month-button",z="default",w="next-month-button",v="otherMonth",u="month-year-label",t="last-year-button",s="navigation-bar",r="next-year-button",bA="date-pane",bz="PageUp",by="mousedown",bx="today",bw="Integer",bv="PageDown",bu="changeLocale",bt="next-month-button-tooltip",bs="last-month-button-tooltip",br="qx.dynlocale",J="last-year-button-tooltip",K="next-year-button-tooltip",H="on",I="weekend",F="day",G="lastMonth",D="Next month",E="Escape",N="Left",O="weekday",W="changeValue",U="Space",bf="Down",ba="qx.ui.control.DateChooser",bn="Date",bk="Enter",Q="dblclick",bq="day#",bp="Next year",bo="ww",P="_applyValue",S="Up",T="weekday#",V="datechooser",X="header",bb="week",bh="lastYear",bm="nextYear",L="changeShownYear",M="week#",R="Last month",be="Right",bd="Last year",bc="EE",bj="mouseup",bi="keypress",Y="",bg="nextMonth",q="week#0",bl="changeShownMonth";qx.Class.define(ba,{extend:qx.ui.core.Widget,include:[qx.ui.core.MExecutable,qx.ui.form.MForm],implement:[qx.ui.form.IExecutable,qx.ui.form.IForm,qx.ui.form.IDateForm],construct:function(bD){qx.ui.core.Widget.call(this);var bF=new qx.ui.layout.VBox();this._setLayout(bF);this._createChildControl(s);this._createChildControl(bA);this.addListener(bi,this._onKeyPress);var bE=(bD!=null)?bD:new Date();this.showMonth(bE.getMonth(),bE.getFullYear());if(qx.core.Variant.isSet(br,H)){qx.locale.Manager.getInstance().addListener(bu,this._updateDatePane,this);}this.addListener(by,this._onMouseUpDown,this);this.addListener(bj,this._onMouseUpDown,this);},statics:{MONTH_YEAR_FORMAT:qx.locale.Date.getDateTimeFormat("yyyyMMMM","MMMM yyyy")},properties:{appearance:{refine:true,init:V},width:{refine:true,init:200},height:{refine:true,init:150},shownMonth:{check:bw,init:null,nullable:true,event:bl},shownYear:{check:bw,init:null,nullable:true,event:L},value:{check:bn,init:null,nullable:true,event:W,apply:P}},members:{__sb:null,__sc:null,__sd:null,_forwardStates:{invalid:true},_createChildControlImpl:function(m){var n;switch(m){case s:n=new qx.ui.container.Composite(new qx.ui.layout.HBox());n.add(this.getChildControl(t));n.add(this.getChildControl(A));n.add(this.getChildControl(u),{flex:1});n.add(this.getChildControl(w));n.add(this.getChildControl(r));this._add(n);break;case J:n=new qx.ui.tooltip.ToolTip(this.tr(bd));break;case t:n=new qx.ui.form.Button();n.addState(bh);n.setFocusable(false);n.setToolTip(this.getChildControl(J));n.addListener(B,this._onNavButtonClicked,this);break;case bs:n=new qx.ui.tooltip.ToolTip(this.tr(R));break;case A:n=new qx.ui.toolbar.Button();n.addState(G);n.setFocusable(false);n.setToolTip(this.getChildControl(bs));n.addListener(B,this._onNavButtonClicked,this);break;case bt:n=new qx.ui.tooltip.ToolTip(this.tr(D));break;case w:n=new qx.ui.toolbar.Button();n.addState(bg);n.setFocusable(false);n.setToolTip(this.getChildControl(bt));n.addListener(B,this._onNavButtonClicked,this);break;case K:n=new qx.ui.tooltip.ToolTip(this.tr(bp));break;case r:n=new qx.ui.toolbar.Button();n.addState(bm);n.setFocusable(false);n.setToolTip(this.getChildControl(K));n.addListener(B,this._onNavButtonClicked,this);break;case u:n=new qx.ui.basic.Label();n.setAllowGrowX(true);n.setAnonymous(true);break;case bb:n=new qx.ui.basic.Label();n.setAllowGrowX(true);n.setAllowGrowY(true);n.setSelectable(false);n.setAnonymous(true);n.setCursor(z);break;case O:n=new qx.ui.basic.Label();n.setAllowGrowX(true);n.setAllowGrowY(true);n.setSelectable(false);n.setAnonymous(true);n.setCursor(z);break;case F:n=new qx.ui.basic.Label();n.setAllowGrowX(true);n.setAllowGrowY(true);n.setCursor(z);n.addListener(by,this._onDayClicked,this);n.addListener(Q,this._onDayDblClicked,this);break;case bA:var o=new qx.ui.layout.Grid();n=new qx.ui.container.Composite(o);for(var i=0;i<8;i++){o.setColumnFlex(i,1);}for(var i=0;i<7;i++){o.setRowFlex(i,1);}var p=this.getChildControl(q);p.addState(X);n.add(p,{column:0,row:0});this.__sb=[];for(var i=0;i<7;i++){p=this.getChildControl(T+i);n.add(p,{column:i+1,row:0});this.__sb.push(p);}this.__sc=[];this.__sd=[];for(var y=0;y<6;y++){var p=this.getChildControl(M+(y+1));n.add(p,{column:0,row:y+1});this.__sd.push(p);for(var x=0;x<7;x++){var p=this.getChildControl(bq+((y*7)+x));n.add(p,{column:x+1,row:y+1});this.__sc.push(p);}}this._add(n);break;}return n||qx.ui.core.Widget.prototype._createChildControlImpl.call(this,m);},_applyValue:function(g,h){if((g!=null)&&(this.getShownMonth()!=g.getMonth()||this.getShownYear()!=g.getFullYear())){this.showMonth(g.getMonth(),g.getFullYear());}else{var k=(g==null)?-1:g.getDate();for(var i=0;i<6*7;i++){var j=this.__sc[i];if(j.hasState(v)){if(j.hasState(C)){j.removeState(C);}}else{var l=parseInt(j.getValue());if(l==k){j.addState(C);}else if(j.hasState(C)){j.removeState(C);}}}}},_onMouseUpDown:function(e){var ck=e.getTarget();if(ck==this.getChildControl(s)||ck==this.getChildControl(bA)){e.stopPropagation();return;}},_onNavButtonClicked:function(cl){var cn=this.getShownYear();var cm=this.getShownMonth();switch(cl.getCurrentTarget()){case this.getChildControl(t):cn--;break;case this.getChildControl(A):cm--;if(cm<0){cm=11;cn--;}break;case this.getChildControl(w):cm++;if(cm>=12){cm=0;cn++;}break;case this.getChildControl(r):cn++;break;}this.showMonth(cm,cn);},_onDayClicked:function(bB){var bC=bB.getCurrentTarget().dateTime;this.setValue(new Date(bC));},_onDayDblClicked:function(){this.execute();},_onKeyPress:function(a){var f=null;var c=null;var d=null;if(a.getModifiers()==0){switch(a.getKeyIdentifier()){case N:f=-1;break;case be:f=1;break;case S:f=-7;break;case bf:f=7;break;case bz:c=-1;break;case bv:c=1;break;case E:if(this.getValue()!=null){this.setValue(null);return true;}break;case bk:case U:if(this.getValue()!=null){this.execute();}return;}}else if(a.isShiftPressed()){switch(a.getKeyIdentifier()){case bz:d=-1;break;case bv:d=1;break;}}if(f!=null||c!=null||d!=null){var b=this.getValue();if(b!=null){b=new Date(b.getTime());}if(b==null){b=new Date();}else{if(f!=null){b.setDate(b.getDate()+f);}if(c!=null){b.setMonth(b.getMonth()+c);}if(d!=null){b.setFullYear(b.getFullYear()+d);}}this.setValue(b);}},showMonth:function(ci,cj){if((ci!=null&&ci!=this.getShownMonth())||(cj!=null&&cj!=this.getShownYear())){if(ci!=null){this.setShownMonth(ci);}if(cj!=null){this.setShownYear(cj);}this._updateDatePane();}},handleKeyPress:function(e){this._onKeyPress(e);},_updateDatePane:function(){var bV=qx.ui.control.DateChooser;var bS=new Date();var bL=bS.getFullYear();var bQ=bS.getMonth();var bO=bS.getDate();var bW=this.getValue();var ca=(bW==null)?-1:bW.getFullYear();var ch=(bW==null)?-1:bW.getMonth();var bT=(bW==null)?-1:bW.getDate();var bP=this.getShownMonth();var ce=this.getShownYear();var bM=qx.locale.Date.getWeekStart();var bX=new Date(this.getShownYear(),this.getShownMonth(),1);var bU=new qx.util.format.DateFormat(bV.MONTH_YEAR_FORMAT);this.getChildControl(u).setValue(bU.format(bX));var cg=bX.getDay();var bR=1+((7-cg)%7);var bY=new qx.util.format.DateFormat(bc);for(var i=0;i<7;i++){var cb=(i+bM)%7;var cd=this.__sb[i];bX.setDate(bR+cb);cd.setValue(bY.format(bX));if(qx.locale.Date.isWeekend(cb)){cd.addState(I);}else{cd.removeState(I);}}bX=new Date(ce,bP,1,12,0,0);var bH=(7+cg-bM)%7;bX.setDate(bX.getDate()-bH);var cc=new qx.util.format.DateFormat(bo);for(var bG=0;bG<6;bG++){this.__sd[bG].setValue(cc.format(bX));for(var i=0;i<7;i++){var cd=this.__sc[bG*7+i];var bK=bX.getFullYear();var bJ=bX.getMonth();var bN=bX.getDate();var bI=(ca==bK&&ch==bJ&&bT==bN);if(bI){cd.addState(C);}else{cd.removeState(C);}if(bJ!=bP){cd.addState(v);}else{cd.removeState(v);}var cf=(bK==bL&&bJ==bQ&&bN==bO);if(cf){cd.addState(bx);}else{cd.removeState(bx);}cd.setValue(Y+bN);cd.dateTime=bX.getTime();bX.setDate(bX.getDate()+1);}}bU.dispose();bY.dispose();cc.dispose();}},destruct:function(){if(qx.core.Variant.isSet(br,H)){qx.locale.Manager.getInstance().removeListener(bu,this._updateDatePane,this);}this.__sb=this.__sc=this.__sd=null;}});})();(function(){var q="mouseup",p="mousedown",o="losecapture",n="mouseover",m="mousemove",l="removeItem",k="keypress",j="addItem",i="qx.ui.virtual.selection.Abstract";qx.Class.define(i,{extend:qx.ui.core.selection.Abstract,construct:function(d,e){qx.ui.core.selection.Abstract.call(this);{};this._pane=d;this._delegate=e||{};},members:{_isSelectable:function(a){return this._delegate.isItemSelectable?this._delegate.isItemSelectable(a):true;},_styleSelectable:function(f,g,h){if(this._delegate.styleSelectable){this._delegate.styleSelectable(f,g,h);}},attachMouseEvents:function(){var w=this._pane.getContainerElement();w.addListener(p,this.handleMouseDown,this);w.addListener(q,this.handleMouseUp,this);w.addListener(n,this.handleMouseOver,this);w.addListener(m,this.handleMouseMove,this);w.addListener(o,this.handleLoseCapture,this);},detatchMouseEvents:function(){var v=this._pane.getContainerElement();v.removeListener(p,this.handleMouseDown,this);v.removeListener(q,this.handleMouseUp,this);v.removeListener(n,this.handleMouseOver,this);v.removeListener(m,this.handleMouseMove,this);v.removeListener(o,this.handleLoseCapture,this);},attachKeyEvents:function(u){u.addListener(k,this.handleKeyPress,this);},detachKeyEvents:function(b){b.removeListener(k,this.handleKeyPress,this);},attachListEvents:function(c){c.addListener(j,this.handleAddItem,this);c.addListener(l,this.handleRemoveItem,this);},detachListEvents:function(x){x.removeListener(j,this.handleAddItem,this);x.removeListener(l,this.handleRemoveItem,this);},_capture:function(){this._pane.capture();},_releaseCapture:function(){this._pane.releaseCapture();},_getScroll:function(){return {left:this._pane.getScrollX(),top:this._pane.getScrollY()};},_scrollBy:function(s,t){this._pane.setScrollX(this._pane.getScrollX()+s);this._pane.setScrollY(this._pane.getScrollY()+t);},_getLocation:function(){var r=this._pane.getContentElement().getDomElement();return r?qx.bom.element.Location.get(r):null;},_getDimension:function(){return this._pane.getInnerSize();}},destruct:function(){this._pane=this._delegate=null;}});})();(function(){var h="qx.ui.virtual.selection.Row",g="above",f="under";qx.Class.define(h,{extend:qx.ui.virtual.selection.Abstract,members:{_getItemCount:function(){return this._pane.getRowConfig().getItemCount();},_getSelectableFromMouseEvent:function(event){var a=this._pane.getCellAtPosition(event.getDocumentLeft(),event.getDocumentTop());if(!a){return null;}return this._isSelectable(a.row)?a.row:null;},getSelectables:function(b){var c=[];for(var i=0,l=this._getItemCount();i<l;i++){if(this._isSelectable(i)){c.push(i);}}return c;},_getSelectableRange:function(y,z){var A=[];var C=Math.min(y,z);var B=Math.max(y,z);for(var i=C;i<=B;i++){if(this._isSelectable(i)){A.push(i);}}return A;},_getFirstSelectable:function(){var q=this._getItemCount();for(var i=0;i<q;i++){if(this._isSelectable(i)){return i;}}return null;},_getLastSelectable:function(){var s=this._getItemCount();for(var i=s-1;i>=0;i--){if(this._isSelectable(i)){return i;}}return null;},_getRelatedSelectable:function(t,u){if(u==g){var w=t-1;var v=0;var x=-1;}else if(u==f){var w=t+1;var v=this._getItemCount()-1;var x=1;}else{return null;}for(var i=w;i!==v+x;i+=x){if(this._isSelectable(i)){return i;}}return null;},_getPage:function(d,e){if(e){return this._getFirstSelectable();}else{return this._getLastSelectable();}},_selectableToHashCode:function(j){return j;},_scrollItemIntoView:function(r){this._pane.scrollRowIntoView(r);},_getSelectableLocationX:function(k){return {left:0,right:this._pane.getColumnConfig().getTotalSize()-1};},_getSelectableLocationY:function(m){var p=this._pane.getRowConfig();var o=p.getItemPosition(m);var n=o+p.getItemSize(m)-1;return {top:o,bottom:n};}}});})();(function(){var k="right",j="qx.ui.virtual.selection.Column",h="left";qx.Class.define(j,{extend:qx.ui.virtual.selection.Row,members:{_getItemCount:function(){return this._pane.getColumnConfig().getItemCount();},_getSelectableFromMouseEvent:function(event){var a=this._pane.getCellAtPosition(event.getDocumentLeft(),event.getDocumentTop());if(!a){return null;}return this._isSelectable(a.column)?a.column:null;},_getRelatedSelectable:function(c,d){if(d==h){var f=c-1;var e=0;var g=-1;}else if(d==k){var f=c+1;var e=this._getItemCount()-1;var g=1;}else{return null;}for(var i=f;i!==e+g;i+=g){if(this._isSelectable(i)){return i;}}return null;},_scrollItemIntoView:function(b){this._pane.scrollColumnIntoView(b);},_getSelectableLocationX:function(l){var m=this._pane.getColumnConfig();var o=m.getItemPosition(l);var n=o+m.getItemSize(l)-1;return {left:o,right:n};},_getSelectableLocationY:function(p){return {top:0,bottom:this._pane.getRowConfig().getTotalSize()-1};}}});})();(function(){var k="mshtml",j="pop.push.reverse.shift.sort.splice.unshift.join.slice",h="number",g="qx.type.BaseArray",f="qx.client",e=".";qx.Class.define(g,{extend:Array,construct:function(length){},members:{toArray:null,valueOf:null,pop:null,push:null,reverse:null,shift:null,sort:null,splice:null,unshift:null,concat:null,join:null,slice:null,toString:null,indexOf:null,lastIndexOf:null,forEach:null,filter:null,map:null,some:null,every:null}});(function(){function n(p){if(qx.core.Variant.isSet(f,k)){m.prototype={length:0,$$isArray:true};var s=j.split(e);for(var length=s.length;length;){m.prototype[s[--length]]=Array.prototype[s[length]];}}var t=Array.prototype.slice;m.prototype.concat=function(){var b=this.slice(0);for(var i=0,length=arguments.length;i<length;i++){var a;if(arguments[i] instanceof m){a=t.call(arguments[i],0);}else if(arguments[i] instanceof Array){a=arguments[i];}else{a=[arguments[i]];}b.push.apply(b,a);}return b;};m.prototype.toString=function(){return t.call(this,0).toString();};m.prototype.toLocaleString=function(){return t.call(this,0).toLocaleString();};m.prototype.constructor=m;m.prototype.indexOf=qx.lang.Core.arrayIndexOf;m.prototype.lastIndexOf=qx.lang.Core.arrayLastIndexOf;m.prototype.forEach=qx.lang.Core.arrayForEach;m.prototype.some=qx.lang.Core.arraySome;m.prototype.every=qx.lang.Core.arrayEvery;var q=qx.lang.Core.arrayFilter;var r=qx.lang.Core.arrayMap;m.prototype.filter=function(){var u=new this.constructor;u.push.apply(u,q.apply(this,arguments));return u;};m.prototype.map=function(){var c=new this.constructor;c.push.apply(c,r.apply(this,arguments));return c;};m.prototype.slice=function(){var d=new this.constructor;d.push.apply(d,Array.prototype.slice.apply(this,arguments));return d;};m.prototype.splice=function(){var o=new this.constructor;o.push.apply(o,Array.prototype.splice.apply(this,arguments));return o;};m.prototype.toArray=function(){return Array.prototype.slice.call(this,0);};m.prototype.valueOf=function(){return this.length;};return m;}function m(length){if(arguments.length===1&&typeof length===h){this.length=-1<length&&length===length>>.5?length:this.push(length);}else if(arguments.length){this.push.apply(this,arguments);}}function l(){}l.prototype=[];m.prototype=new l;m.prototype.length=0;qx.type.BaseArray=n(m);})();})();(function(){var c="qx.ui.virtual.cell.ICell";qx.Interface.define(c,{members:{getCellProperties:function(a,b){}}});})();(function(){var l="",k="qx.ui.virtual.cell.Abstract",j="abstract",i="qx-cell";qx.Class.define(k,{type:j,extend:qx.core.Object,implement:qx.ui.virtual.cell.ICell,construct:function(){qx.core.Object.call(this);qx.ui.virtual.cell.CellStylesheet.getInstance();},members:{getCssClasses:function(c,d){return i;},getAttributes:function(e,f){return l;},getStyles:function(g,h){return l;},getInsets:function(o,p){return [0,0];},getContent:function(m,n){return m;},getCellProperties:function(a,b){return {classes:this.getCssClasses(a,b),style:this.getStyles(a,b),attributes:this.getAttributes(a,b),content:this.getContent(a,b),insets:this.getInsets(a,b)};}}});})();(function(){var m="Integer",l="_applyPadding",k="paddingLeft",j="Color",h="",g="paddingBottom",f="paddingTop",e="paddingRight",d=";",c="-",L="backgroundColor",K="_applyTextAlign",J="px",I="_applyFont",H="_applyBackgroundColor",G="cell",F="center",E="font",D=":",C="shorthand",t="String",u="_applyAppearance",r="background-color:",s="textAlign",p="qx-cell ",q="left",n="textColor",o="text-align:",v="Font",w="right",y="_applyTextColor",x="justify",A="color:",z=" ",B="qx.ui.virtual.cell.Cell";qx.Class.define(B,{extend:qx.ui.virtual.cell.Abstract,construct:function(){qx.ui.virtual.cell.Abstract.call(this);this.__se=qx.ui.virtual.cell.CellStylesheet.getInstance();this.__sf={};this.__sg={};this.__sh={};this.__si={};this.__sj={};this.__sk={};this.initAppearance();this.__so();},properties:{appearance:{check:t,init:G,apply:u},backgroundColor:{nullable:true,check:j,apply:H,themeable:true},textColor:{nullable:true,check:j,apply:y,themeable:true},textAlign:{check:[q,F,w,x],nullable:true,themeable:true,apply:K},font:{nullable:true,apply:I,check:v,themeable:true},paddingTop:{check:m,init:0,apply:l,themeable:true},paddingRight:{check:m,nullable:true,apply:l,themeable:true},paddingBottom:{check:m,nullable:true,apply:l,themeable:true},paddingLeft:{check:m,nullable:true,apply:l,themeable:true},padding:{group:[f,e,g,k],mode:C,themeable:true}},members:{__sl:null,__sm:null,__sj:null,__sk:null,__sg:null,__sf:null,__sh:null,__si:null,__sn:false,__se:null,__so:function(){var bD=qx.util.PropertyUtil;var bF=qx.lang.Object.fromArray(this._getCssProperties());this.__sl=[];var bC=this.constructor;while(bC){var bE=bD.getProperties(bC);for(var bB in bE){if(!bF[bB]){this.__sl.push(bB);}}bC=bC.superclass;}},_getCssProperties:function(){return [L,n,E,s,f,e,g,k];},_applyAppearance:function(a,b){if(b){this.__sg={};}},_getValue:function(T){if(this.__sn){return qx.util.PropertyUtil.getThemeValue(this,T);}else{return qx.util.PropertyUtil.getUserValue(this,T);}},_storeStyle:function(bj,bk){var bl;if(this.__sn){bl=this.__sg;}else{bl=this.__sf;}if(bk===null){delete bl[bj];}else{bl[bj]=bk;}},_applyBackgroundColor:function(bN,bO,name){var bN=this._getValue(name);if(!bN){this._storeStyle(name,null);}else{this._storeStyle(name,r+qx.theme.manager.Color.getInstance().resolve(bN));}},_applyTextColor:function(bm,bn,name){var bm=this._getValue(name);if(!bm){this._storeStyle(name,null);}else{this._storeStyle(name,A+qx.theme.manager.Color.getInstance().resolve(bm));}},_applyTextAlign:function(P,Q,name){var P=this._getValue(name);if(!P){this._storeStyle(name,null);}else{this._storeStyle(name,o+P);}},_applyFont:function(bb,bc,name){var bb=this._getValue(name);if(!bb){this._storeStyle(name,null);}else{var bd=qx.theme.manager.Font.getInstance().resolve(bb);this._storeStyle(name,qx.bom.element.Style.compile(bd.getStyles()));}},_applyPadding:function(bo,bp,name){var bo=this._getValue(name);if(this.__sn){var br=this.__si;}else{br=this.__sh;}if(bo===null){delete br[name];}else{br[name]=bo;}if(bo===null){this._storeStyle(name,null);}else{var bq=qx.lang.String.hyphenate(name);this._storeStyle(name,bq+D+bo+J);}},getCellProperties:function(bT,bU){this.__sp(bU);return {classes:this.getCssClasses(bT,bU),style:this.getStyles(bT,bU),attributes:this.getAttributes(bT,bU),content:this.getContent(bT,bU),insets:this.getInsets(bT,bU)};},getAttributes:function(U,V){return h;},getContent:function(bL,bM){return bL;},getCssClasses:function(M,N){var O=this.__se.getCssClass(this.__sm)||h;return p+O;},__sp:function(W){if(!W){W={};}var Y=this.getAppearance();var X=Y+c+qx.lang.Object.getKeys(W).sort().join(z);if(this.__sm==X){return;}this.__sm=X;var ba=this.__sj[this.__sm];if(!ba){this.__sq();this.__sr(W);this.__ss(W);this.__st();this.__sj[this.__sm]=1;}this.__su();},__sq:function(){var R=qx.util.PropertyUtil;var S=this._getCssProperties();for(var i=0;i<S.length;i++){R.deleteThemeValue(this,S[i]);}},__sr:function(bG){this.__sg={};this.__sn=true;var bJ=this.getAppearance();var bI=qx.util.PropertyUtil;var bH=qx.theme.manager.Appearance.getInstance().styleFrom(bJ,bG);for(var bK in bH){if(bH[bK]!==undefined){bI.setThemed(this,bK,bH[bK]);}}this.__sn=false;},__ss:function(){var bS=qx.lang.Object.getValues(this.__sg).join(d);this.__se.computeClassForStyles(this.__sm,bS);},__st:function(){var bi=this.__sl;var be=qx.util.PropertyUtil;var bg={};for(var i=0;i<bi.length;i++){var bh=bi[i];var bf=be.getThemeValue(this,bh);if(bf!==undefined){bg[bh]=bf;}}this.__sk[this.__sm]=bg;},__su:function(){var bQ=qx.util.PropertyUtil;var bP=this.__sk[this.__sm]||{};for(var bR in bP){bQ.setThemed(this,bR,bP[bR]);}},getStyles:function(bz,bA){return qx.lang.Object.getValues(this.__sf).join(d);},getInsets:function(bs,bt){var bx=this.__sh;var bw=this.__si;var top=(bx.paddingTop!==undefined?bx.paddingTop:bw.paddingTop)||0;var bu=(bx.paddingRight!==undefined?bx.paddingRight:bw.paddingRight)||0;var bv=(bx.paddingBottom!==undefined?bx.paddingBottom:bw.paddingBottom)||0;var by=(bx.paddingLeft!==undefined?bx.paddingLeft:bw.paddingLeft)||0;return [by+bu,top+bv];}},destruct:function(){this.__se=this.__sf=this.__sg=this.__sh=this.__si=this.__sj=this.__sk=this.__sl=null;}});})();(function(){var d="qx.util.format.DateFormat",c="cell-date",b="",a="qx.ui.virtual.cell.Date";qx.Class.define(a,{extend:qx.ui.virtual.cell.Cell,construct:function(g){qx.ui.virtual.cell.Cell.call(this);if(g){this.setDateFormat(g);}else{this.initDateFormat(qx.util.format.DateFormat.getDateTimeInstance());}},properties:{appearance:{refine:true,init:c},dateFormat:{check:d,deferredInit:true}},members:{getContent:function(e,f){return e?this.getDateFormat().format(e):b;}}});})();(function(){var s=".qx-cell {",r="-",q="mshtml",p="qx.ui.virtual.cell.CellStylesheet",o="none",n="qx-cell-",m="default",l="ellipsis",k="}",j="hidden",f="} ",i=".",h="qx.client",e="content-box",d="singleton",g="absolute";qx.Class.define(p,{extend:qx.core.Object,type:d,construct:function(){qx.core.Object.call(this);var t=s+qx.bom.element.Style.compile({position:g,overflow:j,cursor:m,textOverflow:l,userSelect:o})+f;if(!qx.core.Variant.isSet(h,q)){t+=s+qx.bom.element.BoxSizing.compile(e)+k;}this.__sv=qx.bom.Stylesheet.createElement(t);this.__sw={};this.__sx={};},members:{__sv:null,__sw:null,__sx:null,getStylesheet:function(){return this.__sv;},getCssClass:function(u){return this.__sw[u]||null;},computeClassForStyles:function(a,b){var c=this.__sx[b];if(!c){var c=this.__sy();qx.bom.Stylesheet.addRule(this.__sv,i+c,b);this.__sx[b]=c;}this.__sw[a]=c;return c;},__sy:function(){return n+this.toHashCode()+r+(this.__sz++);},__sz:0},destruct:function(){this.__sv=this.__sw=this.__sx=null;}});})();(function(){var i="$$theme_",h="$$user_",g="$$init_",f="qx.util.PropertyUtil";qx.Class.define(f,{statics:{getProperties:function(p){return p.$$properties;},getAllProperties:function(a){var d={};var e=a;while(e!=qx.core.Object){var c=this.getProperties(e);for(var b in c){d[b]=c[b];}e=e.superclass;}return d;},getUserValue:function(I,J){return I[h+J];},setUserValue:function(m,n,o){m[h+n]=o;},deleteUserValue:function(x,y){delete (x[h+y]);},getInitValue:function(K,L){return K[g+L];},setInitValue:function(z,A,B){z[g+A]=B;},deleteInitValue:function(s,t){delete (s[g+t]);},getThemeValue:function(q,r){return q[i+r];},setThemeValue:function(j,k,l){j[i+k]=l;},deleteThemeValue:function(G,H){delete (G[i+H]);},setThemed:function(C,D,E){var F=qx.core.Property.$$method.setThemed;C[F[D]](E);},resetThemed:function(u,v){var w=qx.core.Property.$$method.resetThemed;u[w[v]]();}}});})();(function(){var b="qx.ui.form.IColorForm",a="qx.event.type.Data";qx.Interface.define(b,{events:{"changeValue":a},members:{setValue:function(c){return arguments.length==1;},resetValue:function(){},getValue:function(){}}});})();(function(){var bS="brightness-handle",bR="hue-saturation-handle",bQ="hsbSpinner",bP="rgbSpinner",bO="changeValue",bN="hexField",bM="hueSaturationField",bL="brightness-field",bK="mousedown",bJ="rgb-spinner-red",by="preview-