

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `eyeos25`
--

-- --------------------------------------------------------

--
-- Table structure for table `cache`
--

CREATE TABLE `cache` (
  `cache_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cache_key` varchar(128) CHARACTER SET ascii NOT NULL,
  `created` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `data` longtext NOT NULL,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cache_id`),
  KEY `created_index` (`created`),
  KEY `user_cache_index` (`user_id`,`cache_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `calendar`
--

CREATE TABLE `calendar` (
  `id` varchar(128) NOT NULL,
  `name` varchar(64) NOT NULL,
  `description` text,
  `timezone` tinyint(4) NOT NULL,
  `ownerid` varchar(128) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ownerid` (`ownerid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `calendarevent`
--

CREATE TABLE `calendarevent` (
  `id` varchar(128) NOT NULL,
  `subject` varchar(128) NOT NULL,
  `location` varchar(128) DEFAULT NULL,
  `description` text,
  `isallday` tinyint(1) NOT NULL,
  `timestart` int(32) NOT NULL,
  `timeend` int(32) NOT NULL,
  `type` varchar(16) NOT NULL,
  `privacy` varchar(10) NOT NULL,
  `repetition` varchar(64) NOT NULL,
  `creatorid` varchar(128) NOT NULL,
  `calendarid` varchar(128) NOT NULL,
  `repeattype` varchar(1) DEFAULT NULL,
  `finaltype` tinyint(4) DEFAULT NULL,
  `finalvalue` int(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `creatorid` (`creatorid`),
  KEY `calendarid` (`calendarid`),
  KEY `timestart` (`timestart`),
  KEY `timeend` (`timeend`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `calendarprefs`
--

CREATE TABLE `calendarprefs` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `color` varchar(7) NOT NULL,
  `visible` tinyint(1) NOT NULL,
  `notifications` text NOT NULL,
  `userid` varchar(128) NOT NULL,
  `calendarid` varchar(128) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNQ_calendarprefs_userid_calendarid` (`userid`,`calendarid`),
  KEY `userid` (`userid`),
  KEY `calendarid` (`calendarid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `channels`
--

CREATE TABLE `channels` (
  `id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `channel` varchar(128) NOT NULL,
  `password` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `contactgroupmembers`
--

CREATE TABLE `contactgroupmembers` (
  `contactgroup_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  PRIMARY KEY (`contactgroup_id`,`contact_id`),
  KEY `contact_id_fk_contacts` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `contactgroups`
--

CREATE TABLE `contactgroups` (
  `contactgroup_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `changed` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `del` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(128) NOT NULL DEFAULT '',
  PRIMARY KEY (`contactgroup_id`),
  KEY `contactgroups_user_index` (`user_id`,`del`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `contacts`
--

CREATE TABLE `contacts` (
  `contact_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `changed` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `del` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(128) NOT NULL DEFAULT '',
  `email` varchar(128) NOT NULL,
  `firstname` varchar(128) NOT NULL DEFAULT '',
  `surname` varchar(128) NOT NULL DEFAULT '',
  `vcard` text,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`contact_id`),
  KEY `user_contacts_index` (`user_id`,`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `eventgroup`
--

CREATE TABLE `eventgroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `eventsubject` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `eventineventgroup`
--

CREATE TABLE `eventineventgroup` (
  `eventId` varchar(128) NOT NULL,
  `eventgroupid` int(11) NOT NULL,
  KEY `eventineventgroup_ibfk_4` (`eventId`),
  KEY `eventineventgroup_ibfk_5` (`eventgroupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `eventnotificationinformation`
--

CREATE TABLE `eventnotificationinformation` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(128) DEFAULT NULL,
  `answer` varchar(128) DEFAULT NULL,
  `creationdate` int(32) NOT NULL,
  `sender` varchar(128) NOT NULL,
  `receiver` varchar(128) NOT NULL,
  `question` text NOT NULL,
  `messageinformation` text,
  `availableanswers` text,
  `isquestion` tinyint(1) NOT NULL,
  `eventdata` text,
  `hasended` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `eventnotificationinformation_ibfk_1` (`sender`),
  KEY `eventnotificationinformation_ibfk_2` (`receiver`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `eyeosgroup`
--

CREATE TABLE `eyeosgroup` (
  `id` varchar(128) NOT NULL,
  `name` varchar(40) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `eyeosgroup`
--

INSERT INTO `eyeosgroup` VALUES('eyeID_EyeosGroup_admin', 'admin', 0);
INSERT INTO `eyeosgroup` VALUES('eyeID_EyeosGroup_exec', 'exec', 0);
INSERT INTO `eyeosgroup` VALUES('eyeID_EyeosGroup_lfs', 'lfs', 0);
INSERT INTO `eyeosgroup` VALUES('eyeID_EyeosGroup_mnt', 'mnt', 0);
INSERT INTO `eyeosgroup` VALUES('eyeID_EyeosGroup_rfs', 'rfs', 0);
INSERT INTO `eyeosgroup` VALUES('eyeID_EyeosGroup_root', 'root', 0);
INSERT INTO `eyeosgroup` VALUES('eyeID_EyeosGroup_sys', 'sys', 0);
INSERT INTO `eyeosgroup` VALUES('eyeID_EyeosGroup_um', 'um', 0);
INSERT INTO `eyeosgroup` VALUES('eyeID_EyeosGroup_users', 'users', 0);
INSERT INTO `eyeosgroup` VALUES('eyeID_EyeosGroup_vfs', 'vfs', 0);
INSERT INTO `eyeosgroup` VALUES('eyeID_EyeosGroup_wg', 'wg', 0);
INSERT INTO `eyeosgroup` VALUES('eyeID_EyeosGroup_wg-managers', 'wg-managers', 0);

-- --------------------------------------------------------

--
-- Table structure for table `eyeosmetadata`
--

CREATE TABLE `eyeosmetadata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `className` varchar(128) NOT NULL,
  `object_id` varchar(128) NOT NULL,
  `name` text NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=14 ;

--
-- Dumping data for table `eyeosmetadata`
--

INSERT INTO `eyeosmetadata` VALUES(1, 'EyeosUser', 'eyeID_EyeosUser_root', 'eyeos.user.firstname', 's:4:"root";');
INSERT INTO `eyeosmetadata` VALUES(2, 'EyeosUser', 'eyeID_EyeosUser_root', 'eyeos.user.lastname', 's:4:"root";');
INSERT INTO `eyeosmetadata` VALUES(3, 'EyeosUser', 'eyeID_EyeosUser_root', 'eyeos.user.email', 's:16:"root@example.com";');
INSERT INTO `eyeosmetadata` VALUES(4, 'EyeosUser', 'eyeID_EyeosUser_root', 'eyeos.user.applications.installed', 'a:6:{s:10:"calculator";s:1:"0";s:4:"mail";s:1:"0";s:5:"files";s:1:"0";s:8:"calendar";s:1:"0";s:9:"documents";s:1:"0";s:7:"notepad";s:1:"0";}');
INSERT INTO `eyeosmetadata` VALUES(5, 'EyeosUser', 'eyeID_EyeosUser_root', 'eyeos.user.desktop.widgets', 'a:7:{s:7:"desktop";a:4:{s:5:"title";s:7:"Desktop";s:9:"installed";s:5:"false";s:6:"column";s:1:"1";s:8:"position";s:1:"1";}s:5:"files";a:5:{s:5:"title";s:5:"Files";s:9:"installed";s:4:"true";s:6:"column";i:1;s:8:"position";i:0;s:9:"minimized";b:0;}s:6:"groups";a:5:{s:5:"title";s:9:"My Groups";s:9:"installed";s:4:"true";s:6:"column";i:1;s:8:"position";i:1;s:9:"minimized";b:0;}s:6:"events";a:6:{s:5:"title";s:6:"Events";s:9:"installed";s:4:"true";s:5:"items";s:1:"5";s:6:"column";i:3;s:8:"position";i:1;s:9:"minimized";b:0;}s:9:"favorites";a:5:{s:5:"title";s:22:"Favorites Applications";s:9:"installed";s:4:"true";s:6:"column";i:3;s:8:"position";i:0;s:9:"minimized";b:0;}s:5:"notes";a:5:{s:5:"title";s:5:"Notes";s:9:"installed";s:4:"true";s:6:"column";i:3;s:8:"position";i:2;s:9:"minimized";b:0;}i:1;a:3:{s:6:"column";i:1;s:8:"position";i:0;s:9:"minimized";b:0;}}');
INSERT INTO `eyeosmetadata` VALUES(6, 'EyeosUser', 'eyeID_EyeosUser_root', 'eyeos.user.desktop.wallpaperId', 's:6:"nature";');
INSERT INTO `eyeosmetadata` VALUES(7, 'EyeosUser', 'eyeID_EyeosUser_root', 'eyeos.user.language', 's:2:"en";');
INSERT INTO `eyeosmetadata` VALUES(8, 'EyeosUser', 'eyeID_EyeosUser_root', 'eyeos.user.applications.favorite', 'a:5:{s:10:"calculator";s:1:"0";s:5:"files";s:1:"0";s:8:"calendar";s:1:"0";s:9:"documents";s:1:"0";s:7:"notepad";s:1:"0";}');
INSERT INTO `eyeosmetadata` VALUES(9, 'EyeosUser', 'eyeID_EyeosUser_root', 'eyeos.desktop.mode', 's:7:"classic";');
INSERT INTO `eyeosmetadata` VALUES(10, 'EyeosUser', 'eyeID_EyeosUser_root', 'eyeos.desktop.dashboard.nbcolumns', 's:1:"3";');
INSERT INTO `eyeosmetadata` VALUES(11, 'EyeosUser', 'eyeID_EyeosUser_root', 'eyeos.user.desktop.wallpaperMode', 's:5:"image";');
INSERT INTO `eyeosmetadata` VALUES(12, 'EyeosUser', 'eyeID_EyeosUser_root', 'eyeos.user.desktop.backgroundColors', 'a:9:{s:7:"#E6E6E6";s:4:"true";s:7:"#CCDADA";s:5:"false";s:7:"#A1C4E0";s:5:"false";s:7:"#A7AFC4";s:5:"false";s:7:"#999999";s:5:"false";s:7:"#6293BB";s:5:"false";s:7:"#679966";s:5:"false";s:7:"#787B9A";s:5:"false";s:7:"#6E829A";s:5:"false";}');
INSERT INTO `eyeosmetadata` VALUES(13, 'EyeosUser', 'eyeID_EyeosUser_root', 'eyeos.user.desktop.wallpaper', 's:50:"sys:///extern/images/wallpapers/nature/default.jpg";');

-- --------------------------------------------------------

--
-- Table structure for table `eyeosprincipalgroupassignation`
--

CREATE TABLE `eyeosprincipalgroupassignation` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `principalid` varchar(128) NOT NULL,
  `groupid` varchar(128) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `principalid` (`principalid`),
  KEY `groupid` (`groupid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=41 ;

--
-- Dumping data for table `eyeosprincipalgroupassignation`
--

INSERT INTO `eyeosprincipalgroupassignation` VALUES(1, 'eyeID_EyeosUser_root', 'eyeID_EyeosGroup_root');
INSERT INTO `eyeosprincipalgroupassignation` VALUES(2, 'eyeID_EyeosUser_root', 'eyeID_EyeosGroup_users');
INSERT INTO `eyeosprincipalgroupassignation` VALUES(3, 'eyeID_EyeosUser_root', 'eyeID_EyeosGroup_sys');
INSERT INTO `eyeosprincipalgroupassignation` VALUES(4, 'eyeID_EyeosUser_register', 'eyeID_EyeosGroup_sys');
INSERT INTO `eyeosprincipalgroupassignation` VALUES(5, 'eyeID_EyeosUser_register', 'eyeID_EyeosGroup_um');
INSERT INTO `eyeosprincipalgroupassignation` VALUES(6, 'eyeID_EyeosGroup_wg-managers', 'eyeID_EyeosGroup_wg');

-- --------------------------------------------------------

--
-- Table structure for table `eyeosuser`
--

CREATE TABLE `eyeosuser` (
  `id` varchar(128) NOT NULL,
  `name` varchar(40) NOT NULL,
  `password` varchar(40) NOT NULL,
  `primarygroupid` varchar(128) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `primarygroupid` (`primarygroupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `eyeosuser`
--

INSERT INTO `eyeosuser` VALUES('eyeID_EyeosUser_register', '_register', '', 'eyeID_EyeosGroup_sys', 0);
INSERT INTO `eyeosuser` VALUES('eyeID_EyeosUser_root', 'root', '[[admin_pass]]', 'eyeID_EyeosGroup_root', 0);

-- --------------------------------------------------------

--
-- Table structure for table `eyeosuserworkgroupassignation`
--

CREATE TABLE `eyeosuserworkgroupassignation` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `userid` varchar(128) NOT NULL,
  `workgroupid` varchar(128) NOT NULL,
  `role` tinyint(4) NOT NULL,
  `status` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UK_userid_workgroupid` (`userid`,`workgroupid`),
  KEY `userid` (`userid`),
  KEY `workgroupid` (`workgroupid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

-- --------------------------------------------------------

--
-- Table structure for table `eyeosworkgroup`
--

CREATE TABLE `eyeosworkgroup` (
  `id` varchar(128) NOT NULL,
  `name` varchar(40) NOT NULL,
  `ownerId` varchar(128) NOT NULL,
  `mastergroupid` varchar(128) NOT NULL,
  `privacymode` tinyint(4) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `ownerId` (`ownerId`),
  KEY `mastergroupid` (`mastergroupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `identities`
--

CREATE TABLE `identities` (
  `identity_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `changed` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `del` tinyint(1) NOT NULL DEFAULT '0',
  `standard` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(128) NOT NULL,
  `organization` varchar(128) NOT NULL DEFAULT '',
  `email` varchar(128) NOT NULL,
  `reply-to` varchar(128) NOT NULL DEFAULT '',
  `bcc` varchar(128) NOT NULL DEFAULT '',
  `signature` text,
  `html_signature` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`identity_id`),
  KEY `user_identities_index` (`user_id`,`del`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `impressionto`
--

CREATE TABLE `impressionto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sourceId` varchar(128) NOT NULL,
  `targetId` varchar(128) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sourceId` (`sourceId`),
  KEY `targetId` (`targetId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `languageadminto`
--

CREATE TABLE `languageadminto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) NOT NULL,
  `code` varchar(10) NOT NULL,
  `assigned` varchar(128) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `assigned` (`assigned`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mailaccounts`
--

CREATE TABLE `mailaccounts` (
  `accountid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` tinytext NOT NULL,
  `imap_server` text NOT NULL,
  `imap_user` text NOT NULL,
  `imap_password` text NOT NULL,
  `smtp_server` text NOT NULL,
  `smtp_user` text NOT NULL,
  `smtp_password` text NOT NULL,
  `name` text NOT NULL,
  `email` text NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`accountid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `messages`
--

CREATE TABLE `messages` (
  `message_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `del` tinyint(1) NOT NULL DEFAULT '0',
  `cache_key` varchar(128) CHARACTER SET ascii NOT NULL,
  `created` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `idx` int(11) unsigned NOT NULL DEFAULT '0',
  `uid` int(11) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(255) NOT NULL,
  `from` varchar(255) NOT NULL,
  `to` varchar(255) NOT NULL,
  `cc` varchar(255) NOT NULL,
  `date` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `size` int(11) unsigned NOT NULL DEFAULT '0',
  `headers` text NOT NULL,
  `structure` text,
  PRIMARY KEY (`message_id`),
  UNIQUE KEY `uniqueness` (`user_id`,`cache_key`,`uid`),
  KEY `created_index` (`created`),
  KEY `index_index` (`user_id`,`cache_key`,`idx`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `netsyncHooks`
--

CREATE TABLE `netsyncHooks` (
  `callback` varchar(256) NOT NULL,
  `file` varchar(256) NOT NULL,
  PRIMARY KEY (`callback`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `netsync_messages`
--

CREATE TABLE `netsync_messages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `from` varchar(128) NOT NULL,
  `to` varchar(128) NOT NULL,
  `data` varchar(1024) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `peopletag`
--

CREATE TABLE `peopletag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `userId` varchar(128) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userId` (`userId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `presence`
--

CREATE TABLE `presence` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` varchar(128) CHARACTER SET utf8 NOT NULL,
  `lastSeen` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `userId` (`userId`)
) ENGINE=InnoDB DEFAULT CHARSET=ucs2 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `pressence`
--

CREATE TABLE `pressence` (
  `who` varchar(128) NOT NULL,
  `since` int(10) unsigned NOT NULL,
  `loggedIn` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`who`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Table structure for table `relation`
--

CREATE TABLE `relation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sourceId` varchar(128) NOT NULL,
  `targetId` varchar(128) NOT NULL,
  `state` varchar(50) NOT NULL,
  `lastmodification` int(32) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sourceId` (`sourceId`),
  KEY `targetId` (`targetId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `session`
--

CREATE TABLE `session` (
  `sess_id` varchar(40) NOT NULL,
  `created` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `changed` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `ip` varchar(40) NOT NULL,
  `vars` mediumtext NOT NULL,
  PRIMARY KEY (`sess_id`),
  KEY `changed_index` (`changed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `subscriptions`
--

CREATE TABLE `subscriptions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `who` varchar(128) NOT NULL,
  `channel` varchar(128) NOT NULL,
  `since` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tag`
--

CREATE TABLE `tag` (
  `tagid` bigint(20) NOT NULL AUTO_INCREMENT,
  `principalid` varchar(128) NOT NULL,
  `label` varchar(64) NOT NULL,
  `color` varchar(7) NOT NULL,
  PRIMARY KEY (`tagid`),
  UNIQUE KEY `UNQ_tag_principalid_label` (`principalid`,`label`),
  KEY `principalid` (`principalid`),
  KEY `label` (`label`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `taggedobject`
--

CREATE TABLE `taggedobject` (
  `taggableobjectid` varchar(128) NOT NULL,
  `objectdata` text NOT NULL,
  `handlerclassname` varchar(128) NOT NULL,
  PRIMARY KEY (`taggableobjectid`),
  KEY `handlerclassname` (`handlerclassname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `tagobjectassignation`
--

CREATE TABLE `tagobjectassignation` (
  `taggableobjectid` varchar(128) NOT NULL,
  `tagid` bigint(20) NOT NULL,
  UNIQUE KEY `UNQ_tagobjectassignation_taggableoibjectid_tagid` (`taggableobjectid`,`tagid`),
  KEY `taggableobjectid` (`taggableobjectid`),
  KEY `tagid` (`tagid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `tagperimpressionto`
--

CREATE TABLE `tagperimpressionto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tagId` int(11) NOT NULL,
  `impressionId` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tagId` (`tagId`),
  KEY `impressionId` (`impressionId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `urlfile`
--

CREATE TABLE `urlfile` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(200) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `path` (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `urlshare`
--

CREATE TABLE `urlshare` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `password` varchar(8) NOT NULL,
  `publicationDate` int(12) NOT NULL,
  `expirationDate` int(12) DEFAULT NULL,
  `lastdownloaddate` int(12) DEFAULT NULL,
  `fileId` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fileId` (`fileId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(128) NOT NULL,
  `mail_host` varchar(128) NOT NULL,
  `alias` varchar(128) NOT NULL,
  `created` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `last_login` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `language` varchar(5) DEFAULT NULL,
  `preferences` text,
  PRIMARY KEY (`user_id`),
  KEY `username_index` (`username`),
  KEY `alias_index` (`alias`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `cache`
--
ALTER TABLE `cache`
  ADD CONSTRAINT `user_id_fk_cache` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `calendarevent`
--
ALTER TABLE `calendarevent`
  ADD CONSTRAINT `calendarevent_ibfk_4` FOREIGN KEY (`creatorid`) REFERENCES `eyeosuser` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `calendarevent_ibfk_5` FOREIGN KEY (`calendarid`) REFERENCES `calendar` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `calendarprefs`
--
ALTER TABLE `calendarprefs`
  ADD CONSTRAINT `calendarprefs_ibfk_2` FOREIGN KEY (`calendarid`) REFERENCES `calendar` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `calendarprefs_ibfk_3` FOREIGN KEY (`userid`) REFERENCES `eyeosuser` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `contactgroupmembers`
--
ALTER TABLE `contactgroupmembers`
  ADD CONSTRAINT `contactgroup_id_fk_contactgroups` FOREIGN KEY (`contactgroup_id`) REFERENCES `contactgroups` (`contactgroup_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `contact_id_fk_contacts` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`contact_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `contactgroups`
--
ALTER TABLE `contactgroups`
  ADD CONSTRAINT `user_id_fk_contactgroups` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `contacts`
--
ALTER TABLE `contacts`
  ADD CONSTRAINT `user_id_fk_contacts` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `eventineventgroup`
--
ALTER TABLE `eventineventgroup`
  ADD CONSTRAINT `eventineventgroup_ibfk_4` FOREIGN KEY (`eventId`) REFERENCES `calendarevent` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `eventineventgroup_ibfk_5` FOREIGN KEY (`eventgroupid`) REFERENCES `eventgroup` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `eventnotificationinformation`
--
ALTER TABLE `eventnotificationinformation`
  ADD CONSTRAINT `eventnotificationinformation_ibfk_1` FOREIGN KEY (`sender`) REFERENCES `eyeosuser` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `eventnotificationinformation_ibfk_2` FOREIGN KEY (`receiver`) REFERENCES `eyeosuser` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `eyeosprincipalgroupassignation`
--
ALTER TABLE `eyeosprincipalgroupassignation`
  ADD CONSTRAINT `FK_eyeosprincipal2groupassignation_group_id` FOREIGN KEY (`groupid`) REFERENCES `eyeosgroup` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `eyeosuser`
--
ALTER TABLE `eyeosuser`
  ADD CONSTRAINT `FK_eyeosuser_primaryGroup_id` FOREIGN KEY (`primarygroupid`) REFERENCES `eyeosgroup` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `eyeosuserworkgroupassignation`
--
ALTER TABLE `eyeosuserworkgroupassignation`
  ADD CONSTRAINT `eyeosuserworkgroupassignation_ibfk_2` FOREIGN KEY (`workgroupid`) REFERENCES `eyeosworkgroup` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `eyeosuserworkgroupassignation_ibfk_3` FOREIGN KEY (`userid`) REFERENCES `eyeosuser` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `eyeosworkgroup`
--
ALTER TABLE `eyeosworkgroup`
  ADD CONSTRAINT `eyeosworkgroup_ibfk_3` FOREIGN KEY (`ownerId`) REFERENCES `eyeosuser` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `eyeosworkgroup_ibfk_4` FOREIGN KEY (`mastergroupid`) REFERENCES `eyeosgroup` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `identities`
--
ALTER TABLE `identities`
  ADD CONSTRAINT `user_id_fk_identities` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `impressionto`
--
ALTER TABLE `impressionto`
  ADD CONSTRAINT `impressionto_ibfk_2` FOREIGN KEY (`targetId`) REFERENCES `eyeosuser` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `impressionto_ibfk_1` FOREIGN KEY (`sourceId`) REFERENCES `eyeosuser` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `languageadminto`
--
ALTER TABLE `languageadminto`
  ADD CONSTRAINT `languageadminto_ibfk_1` FOREIGN KEY (`assigned`) REFERENCES `eyeosuser` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `messages`
--
ALTER TABLE `messages`
  ADD CONSTRAINT `user_id_fk_messages` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `peopletag`
--
ALTER TABLE `peopletag`
  ADD CONSTRAINT `peopletag_ibfk_1` FOREIGN KEY (`userId`) REFERENCES `eyeosuser` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `presence`
--
ALTER TABLE `presence`
  ADD CONSTRAINT `presence_ibfk_1` FOREIGN KEY (`userId`) REFERENCES `eyeosuser` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `relation`
--
ALTER TABLE `relation`
  ADD CONSTRAINT `relation_ibfk_2` FOREIGN KEY (`targetId`) REFERENCES `eyeosuser` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `relation_ibfk_1` FOREIGN KEY (`sourceId`) REFERENCES `eyeosuser` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tagobjectassignation`
--
ALTER TABLE `tagobjectassignation`
  ADD CONSTRAINT `tagobjectassignation_ibfk_2` FOREIGN KEY (`tagid`) REFERENCES `tag` (`tagid`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tagobjectassignation_ibfk_1` FOREIGN KEY (`taggableobjectid`) REFERENCES `taggedobject` (`taggableobjectid`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `tagperimpressionto`
--
ALTER TABLE `tagperimpressionto`
  ADD CONSTRAINT `tagperimpressionto_ibfk_2` FOREIGN KEY (`impressionId`) REFERENCES `impressionto` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tagperimpressionto_ibfk_1` FOREIGN KEY (`tagId`) REFERENCES `peopletag` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `urlshare`
--
ALTER TABLE `urlshare`
  ADD CONSTRAINT `urlshare_ibfk_1` FOREIGN KEY (`fileId`) REFERENCES `urlfile` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
