"""whmapi0 functions"""
from typing import Union
import warnings

from cpapis._errors import CpAPIDeprecation
from ._base import CpAPIBase


class Whmapi0(CpAPIBase):
    """whmapi0 functions"""

    __module__ = 'cpapis'

    def __init__(self):
        if self._can_exec('/usr/sbin/whmapi0'):
            super().__init__('/usr/sbin/whmapi0')
        else:
            super().__init__('/usr/local/cpanel/bin/whmapi0')

    def __call__(
        self,
        function: str,
        args: Union[dict, None] = None,
        timeout: Union[float, None] = None,
    ):
        """Query whmapi0

        Args:
            function: whmapi0 function to use
            args: key-vals to send to whmapi0
            timeout: timeout for the whmapi0 command in secs

        Raises:
            CpAPIExecFail: command failed to execute or returned invalid json
        """
        warnings.warn('whmapi0 is deprecated. Use whmapi1', CpAPIDeprecation)
        return self._exec(
            module_args=[function],
            user=None,
            args=args,
            timeout=timeout,
        )
