<?PHP

// New language structure
$lang_info = array (
	'name' => 'French'
	,'nativename' => 'Franais' // Language name in native language. E.g: 'Franais' for 'French'
	,'locale' => array('fr','french') // Standard locale alternatives for a specific language. For reference, go to: http://www.php.net/manual/en/function.setlocale.php
	,'charset' => 'ISO-8859-1' // For reference, go to : http://www.w3.org/International/O-charset-lang.html
	,'direction' => 'ltr' // 'ltr' for Left to Right. 'rtl' for Right to Left languages such as Arabic.
	,'author' => 'DreamCatcher Team Leader'
	,'author_email' => 'contact@alphanet-sc.com'
	,'author_url' => 'http://www.alphanet-sc.com'
	,'transdate' => '26/12/2004'
);

$lang_general = array (
	'yes' => 'Oui'
	,'no' => 'Non'
	,'back' => 'Retour'
	,'continue' => 'Continuer'
	,'close' => 'Fermer'
	,'errors' => 'Erreurs'
	,'info' => 'Info'
	,'day' => 'Jour'
	,'days' => 'Jours'
	,'month' => 'Mois'
	,'months' => 'Mois'
	,'year' => 'Anne'
	,'years' => 'Annes'
	,'hour' => 'Heure'
	,'hours' => 'Heures'
	,'minute' => 'Minute'
	,'minutes' => 'Minutes'
	,'everyday' => 'Chaque jour'
	,'everymonth' => 'Chaque mois'
	,'everyyear' => 'Chaque anne'
	,'active' => 'Activ'
	,'not_active' => 'Dsactiv'
	,'today' => 'Aujourd\'hui'
	,'signature' => 'Ralis par %s'
	,'expand' => 'Dvelopper'
	,'collapse' => 'Rduire'
);

// Date formats, For reference, go to : http://www.php.net/manual/en/function.strftime.php
$lang_date_format = array (
	'full_date' => '%A, %d %B, %Y' // e.g. Wednesday, June 05, 2002
	,'full_date_time_24hour' => '%A, %d %B, %Y  %H:%M' // e.g. Wednesday, June 05, 2002 At 21:05
	,'full_date_time_12hour' => '%A, %d %B, %Y  %I:%M %p' // e.g. Wednesday, June 05, 2002 At 9:05 pm
	,'day_month_year' => '%d-%b-%Y' // e.g 10-Sep-2004
	,'local_date' => '%c' // Preferred date and time representation for current language 
	,'mini_date' => '%a. %d %b, %Y' 
	,'month_year' => '%B %Y'
	,'day_of_week' => array('Dimanche','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi')
	,'months' => array('Janvier','Fvrier','Mars','Avril','Mai','Juin','Juillet','Aot','Septembre','Octobre','Novembre','Dcembre')
);

$lang_system = array (
	'system_caption' => 'Message systme'
  ,'page_access_denied' => 'Vous n\'avez pas assez de privilges pour accder  cette page.'
  ,'page_requires_login' => 'Vous devez tre identifi pour accder  cette page.'
  ,'operation_denied' => 'Vous n\'avez pas assez de privilges pour effectuer cette opration.'
	,'section_disabled' => 'Cette partie est dsactive actuellement !'
  ,'non_exist_cat' => 'La catgorie slectionne n\'existe pas !'
  ,'non_exist_event' => 'L\'vnement slectionn n\'existe pas !'
  ,'param_missing' => 'Les paramtres fournis sont incorrects.'
  ,'no_events' => 'Il n\'y a pas d\'vnement  afficher'
  ,'config_string' => 'Vous utilisez \'%s\' fonctionnant sur %s, %s et %s.'
  ,'no_table' => 'La table \'%s\' n\'existe pas !'
  ,'no_anonymous_group' => 'La table %s ne contient pas le groupe \'Anonymes\' !'
  ,'calendar_locked' => 'Ce service est momentanment dsactiv pour des raisons de maintenance. Nous sommes dsols pour cet inconvnient !'
	,'new_upgrade' => 'Le systme a dtect une nouvelle version. Il est recommand d\'effectu la mise  jour maintenant. Clickez sur "Continuer" pour lancer l\'outil de mise  jour.'
	,'no_profile' => 'Une erreur s\'est produite en recherchant les informations concernant votre profil'
// Mail messages
	,'new_event_subject' => 'Nouvel vnement  %s'
	,'event_notification_failed' => 'Une erreur s\'est produite en essayant d\'envoyer un email de notification !'
);

// Message body for new event email notification
$lang_system['event_notification_body'] = <<<EOT
L'vnement suivant vient d'tre post  {CALENDAR_NAME}

Titre : "{TITLE}"
Date : "{DATE}"
Dure : "{DURATION}"

Vous pouvez accder  l'vnement en clickant sur le lien suivant 
ou en le copiant l'URL dans votre navigateur.

{LINK}

Salutations,

L'administrateur de {CALENDAR_NAME}

EOT;

// Admin menu entries
$lang_admin_menu = array (
	'login' => 'Login'
	,'register' => 'S\'enregister'
  ,'logout' => 'Logout <span style="color:#FF9922">[<span style="color:#606F79">%s</span>]</span>'
  ,'user_profile' => 'Mon Profil'
	,'admin_events' => 'Evnements'
  ,'admin_categories' => 'Catgories'
  ,'admin_groups' => 'Groupes'
  ,'admin_users' => 'Utilisateurs'
  ,'admin_settings' => 'Rglages'
);

// Main menu entries
$lang_main_menu = array (
	'add_event' => 'Evnement'
	,'cal_view' => 'Mensuel'
  ,'flat_view' => 'Etendue'
  ,'weekly_view' => 'Hebdomadaire'
  ,'daily_view' => 'Journalier'
  ,'yearly_view' => 'Annuel'
  ,'categories_view' => 'Catgories'
  ,'search_view' => 'Chercher'
);

// ======================================================
// Add Event view
// ======================================================

$lang_add_event_view = array(
	'section_title' => 'Ajouter un vnement'
	,'edit_event' => 'Editer l\'vnement [id%d] \'%s\''
	,'update_event_button' => 'Mettre  jour'

// Event details
	,'event_details_label' => 'Dtails de l\'vnement'
	,'event_title' => 'Titre de l\'vnement'
	,'event_desc' => 'Description de l\'vnement'
	,'event_cat' => 'Catgorie'
	,'choose_cat' => 'Slectionner une catgorie'
	,'event_date' => 'Date de l\'vnement'
	,'day_label' => 'Jour'
	,'month_label' => 'Mois'
	,'year_label' => 'Anne'
	,'start_date_label' => 'Heure de dbut'
	,'start_time_label' => ''
	,'end_date_label' => 'Dure'
	,'all_day_label' => 'Tous les jours'
// Contact details
	,'contact_details_label' => 'Dtails concernant le contact'
	,'contact_info' => 'Informations sur le contact'
	,'contact_email' => 'Email du contact'
	,'contact_url' => 'URL du contact'
// Repeat events
	,'repeat_event_label' => 'Rpter l\'vnement'
	,'repeat_method_label' => 'Mthode pour rpter'
	,'repeat_none' => 'Ne pas rpter l\'vnement'
	,'repeat_every' => 'Rpter chaque'
	,'repeat_days' => 'Jour(s)'
	,'repeat_weeks' => 'Semaine(s)'
	,'repeat_months' => 'Mois'
	,'repeat_years' => 'Anne(s)'
	,'repeat_end_date_label' => 'Date de fin'
	,'repeat_end_date_none' => 'Pas de date de fin'
	,'repeat_end_date_count' => 'Fin aprs %s occurence(s)'
	,'repeat_end_date_until' => 'Rpter jusqu\'au'
// Other details
	,'other_details_label' => 'Autres dtails'
	,'picture_file' => 'Fichier image'
	,'file_upload_info' => '(limit  %d Koctets - extensions valides : %s )' 
	,'del_picture' => 'Effacer l\'image actuelle ?'
// Administrative options
	,'admin_options_label' => 'Options d\'administration'
	,'auto_appr_event' => 'Evnement approuv'

// Error messages
	,'no_title' => 'Vous devez fournir un titre pour l\'vnement !'
	,'no_desc' => 'Vous devez fournir une description pour cet vnement !'
	,'no_cat' => 'Vous devez slectionner une catgorie dans le menu droulant !'
	,'date_invalid' => 'Vous devez fournir une date valide pour cet vnement !'
	,'end_days_invalid' => 'La valeur saisie dans le champ \'Jours\' n\'est pas valide !'
	,'end_hours_invalid' => 'La valeur saisie dans le champ \'Heures\' n\'est pas valide !'
	,'end_minutes_invalid' => 'La valeur saisie dans le champ \'Minutes\' n\'est pas valide !'

	,'non_valid_extension' => 'Le format du fichier image attach n\'est pas support ! (Extensions valides : %s)'

	,'file_too_large' => 'Le fichier attach est trop grand ! (limit  %d Koctets)'
	,'move_image_failed' => 'Le systme n\'a pas pu dplacer l\'image !'
	,'non_valid_dimensions' => 'La largeur ou la hauteur de l\'image est plus large que %s pixels !'

	,'recur_val_1_invalid' => 'La valeur entre comme \'priode de rptition\' n\'est pas valide. Cette valeur doit tre un nombre suprieur  \'0\' !'
	,'recur_end_count_invalid' => 'La valeur entre comme \'nombre d\'occurences\' n\'est pas valide. Cette valeur doit tre un nombre suprieur  \'0\' !'
	,'recur_end_until_invalid' => 'La date \'rpter jusqu\'\' doit tre suprieure  la date de dbut d\'vnement !'
// Misc. messages
	,'submit_event_pending' => 'Votre vnement est en attente d\'approbation. Merci pour votre collaboration !'
	,'submit_event_approved' => 'Votre vnement est automatiquement approuv. Merci pour votre collaboration !'
	,'event_repeat_msg' => 'Cet vnement est prvu pour tre rpt'
	,'event_no_repeat_msg' => 'Cet vnement ne se rpte pas'
);

// ======================================================
// daily view
// ======================================================

$lang_daily_event_view = array(
	'section_title' => 'Vue journalire'
	,'next_day' => 'Jour suivant'
	,'previous_day' => 'Jour prcdent'
	,'no_events' => 'Il n\'y a pas d\'vnement pour ce jour'
);

// ======================================================
// weekly view
// ======================================================

$lang_weekly_event_view = array(
	'section_title' => 'Vue hebdomadaire'
	,'week_period' => '%s - %s'
	,'next_week' => 'Semaine suivante'
	,'previous_week' => 'Semaine prcdente'
	,'selected_week' => 'Semaine %d'
	,'no_events' => 'Il n\'y a pas d\'vnement pour cette semaine'
);

// ======================================================
// monthly view
// ======================================================

$lang_monthly_event_view = array(
	'section_title' => 'Vue mensuelle'
	,'next_month' => 'Mois suivant'
	,'previous_month' => 'Mois prcdent'
);

// ======================================================
// flat view
// ======================================================

$lang_flat_event_view = array(
	'section_title' => 'Vue tendue'
	,'week_period' => '%s - %s'
	,'next_month' => 'Mois suivant'
	,'previous_month' => 'Mois prcdent'
	,'contact_info' => 'Info Contact'
	,'contact_email' => 'Email'
	,'contact_url' => 'URL'
	,'no_events' => 'Il n\'y a pas d\'vnement pour ce mois'
);

// ======================================================
// Event view
// ======================================================

$lang_event_view = array(
	'section_title' => 'Evnement'
	,'display_event' => 'Evnement : \'%s\''
	,'cat_name' => 'Catgorie'
	,'event_start_date' => 'Date'
	,'event_end_date' => 'Jusqu\''
	,'event_duration' => 'Dure'
	,'contact_info' => 'Info Contact'
	,'contact_email' => 'Email'
	,'contact_url' => 'URL'
	,'no_event' => 'Il n\'y a aucun vnement  afficher.'
	,'stats_string' => '<strong>%d</strong> vnements au total'
	,'edit_event' => 'Editer l\'vnement'
	,'delete_event' => 'Dtruire l\'vnement'
	,'delete_confirm' => 'Etes vous sr de vouloir dtruire cet vnement ?'
	
);

// ======================================================
// Categories view
// ======================================================

$lang_cats_view = array(
	'section_title' => 'Vue des catgories'
	,'cat_name' => 'Nom de la catgorie'
	,'total_events' => 'Total des vnements'
	,'upcoming_events' => 'Evnements  venir'
	,'no_cats' => 'Il n\'y a aucune catgorie  afficher.'
	,'stats_string' => 'Il y a <strong>%d</strong> vnements dans <strong>%d</strong> catgories'
);

// ======================================================
// Category Events view
// ======================================================

$lang_cat_events_view = array(
	'section_title' => 'Evnements sous \'%s\''
	,'event_name' => 'Nom de l\'vnement'
	,'event_date' => 'Date'
	,'no_events' => 'Il n\'y a aucun vnement dans cette catgorie.'
	,'stats_string' => '<strong>%d</strong> vnement(s) au total'
);

// ======================================================
// cal_search.php
// ======================================================

$lang_event_search_data = array(
	'section_title' => 'Rechercher dans le calendrier',
	'search_results' => 'Rsultat de la recherche',
	'category_label' => 'Catgorie',
	'date_label' => 'Date',
	'no_events' => 'Il n\'y a aucun vnement dans cette catgorie.',
	'search_caption' => 'Entrer des mots cls...',
	'search_again' => 'Chercher encore',
	'search_button' => 'Chercher',
// Misc.
	'no_results' => 'Aucun rsultat trouv',	
// Stats
	'stats_string1' => '<strong>%d</strong> vnement(s) trouv(s)',
	'stats_string2' => '<strong>%d</strong> vnement(s) dans <strong>%d</strong> page(s)'
);

// ======================================================
// profile.php
// ======================================================

if (defined('PROFILE_PHP')) 

$lang_user_profile_data = array(
	'section_title' => 'Mon profil',
	'edit_profile' => 'Editer mon profil',
	'update_profile' => 'Mettre  jour mon profil',
	'actions_label' => 'Actions',
// Account Info
	'account_info_label' => 'Informations',
	'user_name' => 'Login',
	'user_pass' => 'Mot de passe',
	'user_pass_confirm' => 'Confirmer le mot de passe',
	'user_email' => 'Addresse E-mail',
	'group_label' => 'Groupe d\'appartenance',
// Other Details
	'other_details_label' => 'Autres Dtails',
	'first_name' => 'Prnom',
	'last_name' => 'Nom',
	'full_name' => 'Nom complet',
	'user_website' => 'Page d\'accueil',
	'user_location' => 'Localisation',
	'user_occupation' => 'Fonction',
// Misc.
	'select_language' => 'Selectionner la Langue',
	'edit_profile_success' => 'Le profil a t mis  jour avec succs',
	'update_pass_info' => 'Laisser le champ mot de passe vide si vous ne souhaitez pas le changer',
// Error messages
	'invalid_password' => 'Entrez un mot de passe constitu seulement de lettres et de chiffres, entre 4 et 16 caractres de long !',
	'password_is_username' => 'Le mot de passe doit tre diffrent du login !',
	'password_not_match' =>'Le mot de passe entr ne correspond pas au mot de passe de confirmation',
	'invalid_email' => 'Vous devez fournir une adresse email valide !',
	'email_exists' => 'Un autre utilisateur s\'est dj enregistr avec l\'adresse email que vous avez entr. Entrez un email diffrent !',
	'no_email' => 'Vous devez fournir une adresse email !',
	'invalid_email' => 'Vous devez fournir une adresse email valide !',
	'no_password' => 'Vous devez fournir un mot de passe pour ce nouveau compte !'
);

// ======================================================
// register.php
// ======================================================

if (defined('USER_REGISTRATION_PHP')) 

$lang_user_registration_data = array(
	'section_title' => 'Enregistrement utilisateur',
// Step 1: Terms & Conditions
	'terms_caption' => 'Termes et Conditions',
	'terms_intro' => 'Pour pouvoir continuer, vous devez accepter ce qui suit :',
	'terms_message' => 'Prenez un moment s\'il vous plat, pour tudier les rgles ci-dessous. Si vous tes d\'accord avec et souhaitez continuer  vous enregistrer, clickez sur le bouton "je suis d\'accord" ci-dessous. Pour abandonner l\'enregistrement, clickez sur la flche "retour arrire" de votre navigateur.<br /><br />Rappelez vous que nous ne sommes pas responsable des vnements enregistrs par les utilisateurs dans le calendrier. Nous ne nous portons pas garrant, ni ne garantissons l\'exactitude, l\'exhaustitivt ou l\'utilit des vnements enregistrs, et ne sommes pas responsables de leur contenus.<br /><br />Les messages expriment les opinions de l\'auteur de l\'vnenement, pas ncessairement celles des administrateurs de %s. N\'importe quel utilisateur qui estime qu\'un vnement est rprhensible est encourag  nous contacter immdiatement par email. Nous avons la capacit d\'enlever le contenu rprhensible et nous ferons tout pour le faire dans un temps raisonnable, si nous dterminons que son retrait est necessaire.<br/><br/>Vous approuvez, par votre utilisation de ce service, que vous n\'emploierez pas cette application de calendrier pour mettre en avant un vnement volontairement faux, diffamatoire, imprcis, abusif, vulgaire, obscne, orient sexuel, menaant, risquant de compromettre l\'intimit d\'une personne ou violer une loi.<br/><br/>Vous acceptez de ne pas proposer des informations soumises  des droits, sauf si les droits d\'auteur vous appartiennent ou appartiennent  %s.',
	'terms_button' => 'Je suis d\'accord',
	
// Account Info
	'account_info_label' => 'Information du compte',
	'user_name' => 'Nom de login',
	'user_pass' => 'Mot de passe',
	'user_pass_confirm' => 'Confirmer le mot de passe',
	'user_email' => 'Adresse E-mail',
// Other Details
	'other_details_label' => 'Autres dtails',
	'first_name' => 'Prnom',
	'last_name' => 'Nom',
	'user_website' => 'Page d\'accueil',
	'user_location' => 'Localisation',
	'user_occupation' => 'Profession',
	'register_button' => 'Soumettre ma requette',

// Stats
	'stats_string1' => '<strong>%d</strong> utilisateurs',
	'stats_string2' => '<strong>%d</strong> utilisateur(s) sur %d page(s)',
// Misc.
	'reg_nomail_success' => 'Merci de votre inscription.',
	'reg_mail_success' => 'Un email avec les informations sur comment activer votre compte vous a t envoy  l\'adresse indique.',
	'reg_activation_success' => 'Flicitations ! Votre compte est activ et vous pouvez vous connecter avec votre login et votre mot de passe. Merci de votre inscription.',
// Mail messages
	'reg_confirm_subject' => 'Inscrit  %s',
	
// Error messages
	'no_username' => 'Vous devez fournir un nom de login !',
	'invalid_username' => 'Entrer un nom de login constitu seulement de lettres et de nombres, entre 4 et 30 caractres de long !',
	'username_exists' => 'Le nom de login que vous avez entr est dja pris. Proposez un nom diffrent SVP !',
	'no_password' => 'Vous devez fournir un mot de passe pour ce nouveau compte !',
	'invalid_password' => 'Entrer un mot de passe constitu seulement de lettres et de nombres, entre 4 et 16 caractres de long !',
	'password_is_username' => 'Le mot de passe doit tre diffrent du login !',
	'password_not_match' =>'Le mot de passe entr ne correspond pas  celui de confirmation',
	'no_email' => 'Vous devez fournir une adresse email !',
	'invalid_email' => 'Vous devez fournir une adresse email valide !',
	'email_exists' => 'Un autre utilisateur a dja fourni cette adresse email. Choisissez en une diffrente s\'il vous plat !',
	'delete_user_failed' => 'Ce compte utilisateur ne peut pas tre dtruit',
	'no_users' => 'Il n\'y a pas de compte utilisateur  afficher !',
	'already_logged' => 'Vous tes dja connect !',
	'registration_not_allowed' => 'Les inscriptions sont momentanment closes !',
	'reg_email_failed' => 'Une erreur s\'est produite en essayant d\'envoyer l\'email d\'activation !',
	'reg_activation_failed' => 'Une erreur s\'est produite en essaynt d\'activer le compte !'

);
// Message body for email activation
$lang_user_registration_data['reg_confirm_body'] = <<<EOT
Merci pour votre inscription  {CALENDAR_NAME}

Votre login est  : "{USERNAME}"
Votre mot de passe est : "{PASSWORD}"

Pour activer votre compte, vous devez clicker sur le lien ci-dessous
ou le recopier dans votre navigateur.

{REG_LINK}

Salutations,

Administrateur de {CALENDAR_NAME}

EOT;

// ======================================================
// theme.php
// ======================================================

// To Be Done

// ======================================================
// functions.inc.php
// ======================================================

// To Be Done

// ======================================================
// dblib.php
// ======================================================

// To Be Done

// ======================================================
// admin_events.php
// ======================================================

if (defined('ADMIN_EVENTS_PHP')) 

$lang_event_admin_data = array(
	'section_title' => 'Administration des vnements',
	'events_to_approve' => 'Administration des vnements : Evnements  approuver',
	'upcoming_events' => 'Administration des vnements : Evnements  venir',
	'past_events' => 'Administration des vnements : Evnements passs',
	'add_event' => 'Ajouter un nouvel vnement',
	'edit_event' => 'Editer l\'vnement',
	'view_event' => 'Afficher l\'vnement',
	'approve_event' => 'Approuver l\'vnement',
	'update_event' => 'Mettre  jour les informations de l\'vnement',
	'delete_event' => 'Dtruire l\'vnement',
	'events_label' => 'Evnements',
	'auto_approve' => 'Auto-approbation',
	'date_label' => 'Date',
	'actions_label' => 'Actions',
	'events_filter_label' => 'Filtrer les vnements',
	'events_filter_options' => array('Afficher tous les vnements','Afficher seulement les vnements non-approuvs','Afficher seulement les vnements  venir','Afficher seulement les vnements passs'),
	'picture_attached' => 'Image attache',
// View Event
	'view_event_name' => 'Evnement : \'%s\'',
	'event_start_date' => 'Date',
	'event_end_date' => 'Jusqu\'',
	'event_duration' => 'Dure',
	'contact_info' => 'Info Contact',
	'contact_email' => 'Email',
	'contact_url' => 'URL',
// General Info
// Event form
	'edit_event_title' => 'Evnement : \'%s\'',
	'cat_name' => 'Catgorie',
	'event_start_date' => 'Date',
	'event_end_date' => 'Jusqu\'',
	'contact_info' => 'Info Contact',
	'contact_email' => 'Email',
	'contact_url' => 'URL',
	'no_event' => 'Il n\'y a pas d\'vnement  afficher.',
	'stats_string' => '<strong>%d</strong> vnement(s) au total',
// Stats
	'stats_string1' => '<strong>%d</strong> vnement(s)',
	'stats_string2' => 'Total : <strong>%d</strong> vnements sur %d page(s)',
// Misc.
	'add_event_success' => 'Nouvel vnement ajout avec succs',
	'edit_event_success' => 'Evnement mis  jour avec succs',
	'approve_event_success' => 'Evnement approuv avec succs',
	'delete_confirm' => 'Etes vous sr de vouloir dtruire cet vnement ?',
	'delete_event_success' => 'Evnement dtruit avec succs',
	'active_label' => 'Activ',
	'not_active_label' => 'Dsactiv',
// Error messages
	'no_event_name' => 'Vous devez fournir un nom pour cet vnement !',
	'no_event_desc' => 'Vous devez fournir une description pour cet vnement !',
	'no_cat' => 'Vous devez slectionner une catgorie pour cet vnement !',
	'no_day' => 'Vous devez slectionner un jour !',
	'no_month' => 'Vous devez slectionner un mois !',
	'no_year' => 'Vous devez slectionner une anne !',
	'non_valid_date' => 'Entrer une date valide SVP !',
	'end_days_invalid' => 'Assurez vous que le champ \'Jours\' sous \'Dure\' est constitu seulement de nombres !',
	'end_hours_invalid' => 'Assurez vous que le champ \'Heures\' sous \'Dure\' est constitu seulement de nombres !',
	'end_minutes_invalid' => 'Assurez vous que le champ \'Minutes\' sous \'Dure\' est constitu seulement de nombres !',
	'file_too_large' => 'L\'image que vous avez attach est plus grande que %s Koctets !',
	'non_valid_extension' => 'Le format du fichier attach n\'est pas support !',
	'delete_event_failed' => 'Cet vnement ne peut pas tre dtruit',
	'approve_event_failed' => 'Cet vnement ne peut pas tre approuv',
	'no_events' => 'Il n\'y a pas d\'vnement  afficher !',
	'move_image_failed' => 'Le systme n\'a pas russi  dplacer l\'image !',
	'non_valid_dimensions' => 'La largeur ou la hauteur de l\'image est suprieure  %s pixels !',

	'recur_val_1_invalid' => 'La valeur entre comme \'priode de rptition\' n\'est pas valide. Cette valeur doit tre un nombre suprieur  \'0\' !',
	'recur_end_count_invalid' => 'La valeur entre comme \'nombre d\'occurences\' n\'est pas valide. Cette valeur doit tre un nombre suprieur  \'0\' !',
	'recur_end_until_invalid' => 'La date \'rpter jusqu\'\' doit tre suprieure  la date de dbut d\'vnement !'

);

// ======================================================
// admin_categories.php
// ======================================================

if (defined('ADMIN_CATS_PHP')) 

$lang_cat_admin_data = array(
	'section_title' => 'Administration des catgories',
	'add_cat' => 'Ajouter une nouvelle catgorie',
	'edit_cat' => 'Editer la catgorie',
	'update_cat' => 'Mettre  jour les informations de la catgorie',
	'delete_cat' => 'Dtruire la catgorie',
	'events_label' => 'Evnements',
	'visibility' => 'Visibilit',
	'actions_label' => 'Actions',
	'users_label' => 'Utilisateurs',
	'admins_label' => 'Administrateurs',
// General Info
	'general_info_label' => 'Information gnrale',
	'cat_name' => 'Nom de la catgorie',
	'cat_desc' => 'Description de la catgorie',
	'cat_color' => 'Couleur',
	'pick_color' => 'Choisir une couleur !',
	'status_label' => 'Statut',
// Administrative Options
	'admin_label' => 'Options d\'administration',
	'auto_admin_appr' => 'Approuver automatiquement les soumissions des administrateurs',
	'auto_user_appr' => 'Approuver automatiquement les soumissions des utilisateurs',
// Stats
	'stats_string1' => '<strong>%d</strong> catgories',
	'stats_string2' => 'Actives : <strong>%d</strong>&nbsp;&nbsp;&nbsp;Total : <strong>%d</strong>&nbsp;&nbsp;&nbsp;sur %d page(s)',
// Misc.
	'add_cat_success' => 'Nouvelle catgorie ajoute avec succs',
	'edit_cat_success' => 'Catgorie mise  jour avec succs',
	'delete_confirm' => 'Etes vous sr de vouloir dtruire cette catgorie ?',
	'delete_cat_success' => 'Catgorie dtruite avec succs',
	'active_label' => 'Active',
	'not_active_label' => 'Dsactive',
// Error messages
	'no_cat_name' => 'Vous devez fournir un nom pour cette catgorie !',
	'no_cat_desc' => 'Vous devez fournir une description pour cette catgorie !',
	'no_color' => 'Vous devez fournir une couleur pour cette catgorie !',
	'delete_cat_failed' => 'Cette catgorie ne peut pas tre dtruite',
	'no_cats' => 'Il n\'y a pas de catgorie  afficher !',
	'cat_has_events' => 'Cette catgorie contient %d vnement(s) et ne peut donc pas tre dtruite !<br>Dtruisez les vnements restants dans cette catgorie et recommencer  nouveau !'

);
// ======================================================
// admin_users.php
// ======================================================

if (defined('ADMIN_USERS_PHP')) 

$lang_user_admin_data = array(
	'section_title' => 'Administration des utilisateurs',
	'add_user' => 'Ajouter un nouvel utilisateur',
	'edit_user' => 'Editer les informations de l\'utilisateur',
	'update_user' => 'Mettre  jour les informations de l\'utilisateur',
	'delete_user' => 'Dtruire le compte de l\'utilisateur',
	'last_access' => 'Dernier accs',
	'actions_label' => 'Actions',
	'active_label' => 'Active',
	'not_active_label' => 'Dsactive',
// Account Info
	'account_info_label' => 'Information du compte',
	'user_name' => 'Nom de login',
	'user_pass' => 'Mot de passe',
	'user_pass_confirm' => 'Confirmer le mot de passe',
	'user_email' => 'E-mail',
	'group_label' => 'Groupe d\'appartenance',
	'status_label' => 'Statut du compte',
// Other Details
	'other_details_label' => 'Autres dtails',
	'first_name' => 'Prnom',
	'last_name' => 'Nom',
	'user_website' => 'Site web',
	'user_location' => 'Localisation',
	'user_occupation' => 'Profession',
// Stats
	'stats_string1' => '<strong>%d</strong> utilisateurs',
	'stats_string2' => '<strong>%d</strong> utilisateur(s) sur %d page(s)',
// Misc.
	'select_group' => 'En slectionner un...',
	'add_user_success' => 'Compte utilisateur ajout avec succs',
	'edit_user_success' => 'Compte utilisateur mis  jour avec succs',
	'delete_confirm' => 'Etes vous sr de vouloir dtruire ce compte ?',
	'delete_user_success' => 'Compte utilisateur dtruit avec succs',
	'update_pass_info' => 'Laisser le champ du mot de passe vide si vous n\'avez pas besoin de le changer',
	'access_never' => 'Jamais',
// Error messages
	'no_username' => 'Vous devez fournir un nom de login !',
	'invalid_username' => 'Entrer un nom de login constitu seulement de lettres et de nombres, entre 4 et 30 caractres de long !',
	'invalid_password' => 'Entrer un mot de passe constitu seulement de lettres et de nombres, entre 4 et 16 caractres de long !',
	'password_is_username' => 'Le mot de passe doit tre diffrent du nom de login !',
	'password_not_match' =>'Le mot de passe que vou savez entr ne correspond pas  celui de confirmation',
	'invalid_email' => 'Vous devez fournir une adresse email valide !',
	'email_exists' => 'Un autre utilisateur a dja fourni cette adresse email. Choisissez en une diffrente s\'il vous plat !',
	'username_exists' => 'Le nom de login que vous avez entr est dja pris. Proposez un nom diffrent SVP !',
	'no_email' => 'Vous devez fournir une adresse email !',
	'invalid_email' => 'Vous devez fournir une adresse email valide !',
	'no_password' => 'Vous devez fournir un mot de passe pour ce nouveau compte !',
	'no_group' => 'Slectionner un groupe d\'appartenance pour cet utilisateur !',
	'delete_user_failed' => 'Ce compte utilisateur ne peut pas tre dtruit',
	'no_users' => 'Il n\'y a pas de compte utilisateur  afficher !'

);

// ======================================================
// admin_groups.php
// ======================================================

if (defined('ADMIN_GROUPS_PHP')) 

$lang_group_admin_data = array(
	'section_title' => 'Administration des groupes',
	'add_group' => 'Ajouter un nouveau groupe',
	'edit_group' => 'Editer le groupe',
	'update_group' => 'Mettre  jour les informations du groupe',
	'delete_group' => 'Dtruire le groupe',
	'view_group' => 'Afficher le groupe',
	'users_label' => 'Membres',
	'actions_label' => 'Actions',
// General Info
	'general_info_label' => 'Information gnrale',
	'group_name' => 'Nom du groupe',
	'group_desc' => 'Description du groupe',
// Group Access Level
	'access_level_label' => 'Niveau d\'accs du groupe',
	'has_admin_access' => 'Les utilisateurs de ce groupe ont l\'accs administrateur',
	'can_manage_accounts' => 'Les utilisateurs de ce groupe peuvent administrer les comptes',
	'can_change_settings' => 'Les utilisateurs de ce groupe peuvent changer la configuration du calendrier',
	'can_manage_cats' => 'Les utilisateurs de ce groupe peuvent grer les catgories',
	'upl_need_approval' => 'Les vnements soumis ncessitent l\'approbation d\'un administrateur',
// Stats
	'stats_string1' => '<strong>%d</strong> groupe(s)',
	'stats_string2' => 'Total : <strong>%d</strong> groupe(s) dans %d page(s)',
	'stats_string3' => 'Total : <strong>%d</strong> utilisateur(s) sur %d page(s)',
// View Group Members
	'group_members_string' => 'Membres du groupe \'%s\'',
	'username_label' => 'Nom de login',
	'firstname_label' => 'Prnom',
	'lastname_label' => 'Nom',
	'email_label' => 'Email',
	'last_access_label' => 'Dernier accs',
	'edit_user' => 'Editer l\'utilisateur',
	'delete_user' => 'Dtruire l\'utilisateur',
// Misc.
	'add_group_success' => 'Nouveau groupe ajout avec succs',
	'edit_group_success' => 'Groupe mis  jour avec succs',
	'delete_confirm' => 'Etes vous sr de vouloir dtruire ce groupe ?',
	'delete_user_confirm' => 'Etes vous sr de vouloir dtruire ce groupe ?',
	'delete_group_success' => 'Groupe dtruit avec succs',
	'no_users_string' => 'Il n\'y a pas d\'utilisateur dans ce groupe',
// Error messages
	'no_group_name' => 'Vous devez fournir un nom pour ce groupe !',
	'no_group_desc' => 'Vous devez fournir une description pour ce groupe !',
	'delete_group_failed' => 'Ce groupe ne peut pas tre dtruit',
	'no_groups' => 'Il n\'y a pas de groupe  afficher !',
	'group_has_users' => 'Ce groupe contient %d utilisateur(s) et ne peut donc pas tre dtruit!<br>Retirez les utilisateurs de ce groupe et recommencez SVP !'

);

// ======================================================
// admin_settings.php / admin_settings_template.php / 
// admin_settings_updates.php
// ======================================================

if (defined('SETTINGS_PHP')) 

$lang_settings_data = array(
	'section_title' => 'Rglages du calendrier'
// Links
	,'admin_links_text' => 'Choisir la section'
	,'admin_links' => array('Rglages principaux','Configuration du Template','Mise  jour produit')
// General Settings
	,'general_settings_label' => 'Paramtres gnraux'
	,'calendar_name' => 'Nom du calendrier'
	,'calendar_description' => 'Description du calendrier'
	,'calendar_admin_email' => 'Email de l\'administrateur du calendrier'
	,'cookie_name' => 'Nom du cookie utilis par le script'
	,'cookie_path' => 'Chemin du cookie utilis par le script'
	,'debug_mode' => 'Activer le mode debug'
	,'calendar_status' => 'Situation publique du calendrier'
// Environment Settings
	,'env_settings_label' => 'Paramtres d\'environnement'
	,'lang' => 'Langage'
		,'lang_name' => 'Code langue'
		,'lang_native_name' => 'Langue'
		,'lang_trans_date' => 'Traduit le'
		,'lang_author_name' => 'Auteur'
		,'lang_author_email' => 'E-mail'
		,'lang_author_url' => 'Site web'
	,'charset' => 'Encodage des caractres'
	,'theme' => 'Thme'
		,'theme_name' => 'Nom du thme'
		,'theme_date_made' => 'Fait le'
		,'theme_author_name' => 'Auteur'
		,'theme_author_email' => 'E-mail'
		,'theme_author_url' => 'Site web'
	,'timezone' => 'Dcalage horaire'
	,'time_format' => 'Format d\'affichage de l\'heure'
		,'24hours' => '24 Heures'
		,'12hours' => '12 Heures'
	,'auto_daylight_saving' => 'Ajustement automatique de l\'heure d\'t/hiver (DST)'
	,'main_table_width' => 'Largeur de la Table principale (Pixels ou %)'
	,'day_start' => 'Les semaines commence le'
	,'default_view' => 'Affichage par dfaut'
	,'search_view' => 'Permettre la recherche'
	,'archive' => 'Afficher les vnements passs'
	,'events_per_page' => 'Nombre d\'vnements par page'
	,'sort_order' => 'Ordre de tri par dfaut'
		,'sort_order_title_a' => 'Titre ascendant'
		,'sort_order_title_d' => 'Title descendant'
		,'sort_order_date_a' => 'Date croissante'
		,'sort_order_date_d' => 'Date dcroissante'
	,'show_recurrent_events' => 'Voir les vnements rccurents'
	,'multi_day_events' => 'Evnements sur plusieurs jours'
		,'multi_day_events_all' => 'Voir toute la priode'
		,'multi_day_events_bounds' => 'Voir seulement la date de dbut et de fin'
		,'multi_day_events_start' => 'Voir seulement la date de dbut'
	// User Settings
	,'user_settings_label' => 'Rglages utilisateur'
	,'allow_user_registration' => 'Permettre l\'inscription des utilisateurs'
	,'reg_duplicate_emails' => 'Autoriser la duplication des emails'
	,'reg_email_verify' => 'Permettre l\'activation des compte par email'
// Event View
	,'event_view_label' => 'Affichage des vnements'
	,'popup_event_mode' => 'Affichage des vnements en Pop-up'
	,'popup_event_width' => 'Largeur de la fentre Pop-up'
	,'popup_event_height' => 'Hauteur de la fentre Pop-up'
// Add Event View
	,'add_event_view_label' => 'Ajout des vnements'
	,'add_event_view' => 'Activ'
	,'addevent_allow_html' => 'Permettre les codes <b>BB</b> dans la description'
	,'addevent_allow_contact' => 'Autoriser Contact'
	,'addevent_allow_email' => 'Autoriser Email'
	,'addevent_allow_url' => 'Autoriser URL'
	,'addevent_allow_picture' => 'Autoriser Images'
	,'new_post_notification' => 'Notification de nouvelle entre'
// Calendar View
	,'calendar_view_label' => 'Vue mensuelle (calendrier)'
	,'monthly_view' => 'Active'
	,'cal_view_show_week' => 'Afficher les numros de semaine'
	,'cal_view_max_chars' => 'Nombre maximum de caractres pour la description'
// Flyer View
	,'flyer_view_label' => 'Vue des catgories'
	,'flyer_view' => 'Active'
	,'flyer_show_picture' => 'Afficher les images dans la vue des catgories'
	,'flyer_view_max_chars' => 'Nombre maximum de caractres pour la description'
// Weekly View
	,'weekly_view_label' => 'Vue hebdomadaire'
	,'weekly_view' => 'Active'
	,'weekly_view_max_chars' => 'Nombre maximum de caractres pour la description'
// Daily View
	,'daily_view_label' => 'Vue journalire'
	,'daily_view' => 'Active'
	,'daily_view_max_chars' => 'Nombre maximum de caractres pour la description'
// Categories View
	,'categories_view_label' => 'Vue par catgorie'
	,'cats_view' => 'Active'
	,'cats_view_max_chars' => 'Nombre maximum de caractres pour la description'
// Mini Calendar
	,'mini_cal_label' => 'Mini Calendrier'
	,'mini_cal_def_picture' => 'Image par dfaut'
	,'mini_cal_display_picture' => 'Affiche l\'image'
	,'mini_cal_diplay_options' => array('Aucune','Image par dfaut', 'Image du jour','Image de la semaine','Image alatoire')
// Mail Settings
	,'mail_settings_label' => 'Rglages de mail'
	,'mail_method' => 'Mthode pour envoyer le mail'
	,'mail_smtp_host' => 'Serveurs SMTP (Spars par un point virgule ;)'
	,'mail_smtp_auth' => ' Authentification SMTP'
	,'mail_smtp_username' => 'Login SMTP'
	,'mail_smtp_password' => 'Mot de passe SMTP'

// Picture Settings
	,'picture_settings_label' => 'Rglages pour les images'
	,'max_upl_dim' => 'Largeur et hauteur max. pour les images tlcharges'
	,'max_upl_size' => 'Taille maximum pour les images tlcharges (Upload) (en Koctets)'
	,'picture_chmod' => 'Mode par dfaut pour les images (CHMOD) (en base 8 - Octal)'
	,'allowed_file_extensions' => 'Extensions de fichier acceptes pour les images tlcharges'
// Form Buttons
	,'update_config' => 'Enregistrer'
	,'restore_config' => 'Restaurer d\'origine'
// Misc.
	,'update_settings_success' => 'Rglages mis  jour avec succs'
	,'restore_default_confirm' => 'Etes vous sr de vouloir remettre les rglages par dfaut ?'
// Template Configuration
	,'template_type' => 'Type de gabarit'
	,'template_header' => 'Personnalisation de l\'entte'
	,'template_footer' => 'Personnalisation du pied de page'
	,'template_status_default' => 'Utiliser le gabarit par dfaut'
	,'template_status_custom' => 'Utiliser le gabarit suivant :'
	,'template_custom' => 'Gabarit personnalis'

	,'info_meta' => 'Meta Information'
	,'info_status' => 'Contrle de statut'
	,'info_status_default' => 'Dsactiver ce contenu'
	,'info_status_custom' => 'Afficher le contenu suivant :'
	,'info_custom' => 'Contenu personnalis'

	,'dynamic_tags' => 'Tags Dynamiques'

// Product Updates
	,'updates_check_text' => 'Attendez le temps de retrouver le sinformations sur ce serveur...'
	,'updates_no_response' => 'Pas de rponse du serveur. Essayez plus tard.'
	,'avail_updates' => 'Mises  jour disponibles'
	,'updates_download_zip' => 'Tlcharger le package ZIP (.zip)'
	,'updates_download_tgz' => 'Tlcharger le package TGZ (.tar.gz)'
	,'updates_released_label' => 'Date de version : %s'
	,'updates_no_update' => 'Vous utilisez la dernire version disponible. La mise  jour n\'est pas ncessaire.'
);

// ======================================================
// cal_mini.inc.php
// ======================================================

$lang_mini_cal = array(
	'def_pic' => 'Image par dfaut'
	,'daily_pic' => 'Image du jour (%s)'
	,'weekly_pic' => 'Image de la semaine (%s)'
	,'rand_pic' => 'Image alatoire (%s)'
	,'post_event' => 'Envoyer un nouvel vnement'
);

// ======================================================
// calendar.php
// ======================================================

// To Be Done

// ======================================================
// config.inc.php
// ======================================================

// To Be Done

// ======================================================
// install.php
// ======================================================

// To Be Done

// ======================================================
// login.php
// ======================================================

if (defined('LOGIN_PHP')) 

$lang_login_data = array(
	'section_title' => 'Fentre d\'identification'
// General Settings
	,'login_intro' => 'Entrer votre login et mot de passe pour vous connecter'
	,'username' => 'Login'
	,'password' => 'Mot de passe'
	,'remember_me' => 'Se rappeler de moi'
	,'login_button' => 'Login'
// Errors
	,'invalid_login' => 'Vrifiez vos information de login et re-essayer !'
	,'no_username' => 'Vous devez fournir un nom de login !'
	,'already_logged' => 'Vous tes dja connect !'
);

// ======================================================
// logout.php
// ======================================================

// To Be Done


?>