
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `extcal202a`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `cat_id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_parent` int(11) NOT NULL DEFAULT '0',
  `cat_name` varchar(150) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `color` varchar(10) DEFAULT '#000000',
  `bgcolor` varchar(10) DEFAULT '#EEF0F0',
  `options` tinyint(4) DEFAULT '0',
  `enabled` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`cat_id`),
  UNIQUE KEY `cat_id` (`cat_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Table for event categories' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(1, 0, 'General', 'This is the default category', '#000000', '#EEF0F0', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `name` varchar(40) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Table for configurable parameters';

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
('allowed_file_extensions', 'GIF/PNG/JPG/JPEG'),
('max_upl_size', '20000'),
('cookie_name', 'ext20'),
('cookie_path', '/'),
('debug_mode', '0'),
('events_per_page', '10'),
('calendar_name', 'ExtCalendar 2'),
('calendar_admin_email', 'you@somewhere.com'),
('calendar_description', 'Your online events calendar'),
('lang', 'english'),
('charset', 'language file'),
('main_table_width', '650'),
('max_tabs', '12'),
('theme', 'default'),
('time_format_24hours', '1'),
('auto_daylight_saving', '1'),
('default_view', '2'),
('popup_event_mode', '0'),
('popup_event_width', '550'),
('popup_event_height', '300'),
('add_event_view', '1'),
('cats_view', '1'),
('daily_view', '1'),
('weekly_view', '1'),
('monthly_view', '1'),
('flyer_view', '1'),
('search_view', '1'),
('day_start', '0'),
('archive', '0'),
('flyer_show_picture', '1'),
('addevent_allow_html', '0'),
('addevent_allow_contact', '1'),
('addevent_allow_email', '1'),
('addevent_allow_url', '1'),
('addevent_allow_picture', '1'),
('new_post_notification', '1'),
('cal_view_max_chars', '100'),
('flyer_view_max_chars', '100'),
('weekly_view_max_chars', '100'),
('daily_view_max_chars', '100'),
('cats_view_max_chars', '100'),
('mini_cal_def_picture', 'def_pic.gif'),
('mini_cal_diplay_options', '1'),
('release_name', '2.0 Beta 1'),
('release_version', '200.25'),
('release_type', 'beta'),
('sort_order', 'ta'),
('picture_chmod', '0644'),
('max_upl_dim', '450'),
('allow_user_registration', '1'),
('reg_email_verify', '1'),
('reg_duplicate_emails', '0'),
('calendar_status', '1'),
('show_recurrent_events', '1'),
('multi_day_events', 'all'),
('cal_view_show_week', '1'),
('mail_method', 'mail'),
('mail_smtp_host', 'smtp.myhost.com'),
('mail_smtp_auth', '0'),
('mail_smtp_username', ''),
('mail_smtp_password', ''),
('legend_cat_columns', '4'),
('timezone', '-5');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]events`
--

CREATE TABLE `[[dbprefix]]events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `contact` text NOT NULL,
  `url` varchar(100) NOT NULL DEFAULT '',
  `email` varchar(120) NOT NULL DEFAULT '',
  `picture` varchar(100) NOT NULL DEFAULT '',
  `cat` tinyint(2) NOT NULL DEFAULT '0',
  `day` tinyint(2) NOT NULL DEFAULT '0',
  `month` smallint(2) NOT NULL DEFAULT '0',
  `year` smallint(4) NOT NULL DEFAULT '0',
  `approved` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_date` datetime DEFAULT '0000-00-00 00:00:00',
  `recur_type` varchar(16) DEFAULT NULL,
  `recur_val` tinyint(4) DEFAULT '0',
  `recur_end_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `recur_count` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `recur_until` date DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `start_date` (`start_date`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Table holding events and their attributes' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]events`
--

INSERT INTO `[[dbprefix]]events` VALUES
(1, 'ExtCalendar Installed', 'Congratulations! ExtCalendar is installed and ready to kick !', '', '', '', '', 1, [[regday]], [[regmonth]], [[regyear]], 1, '[[regdate]]', '[[regdate]]', NULL, 0, 0, 0, '0000-00-00');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]groups`
--

CREATE TABLE `[[dbprefix]]groups` (
  `group_id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  `has_admin_access` tinyint(1) NOT NULL DEFAULT '0',
  `can_manage_accounts` tinyint(1) NOT NULL DEFAULT '0',
  `can_change_settings` tinyint(1) NOT NULL DEFAULT '0',
  `can_manage_cats` tinyint(1) NOT NULL DEFAULT '0',
  `upl_need_approval` tinyint(1) NOT NULL DEFAULT '1',
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Table holding user groups' AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]groups`
--

INSERT INTO `[[dbprefix]]groups` VALUES
(1, 'Administrators', 'Members of this group have the absolute power.', 1, 1, 1, 1, 0, 1),
(2, 'Moderators', 'Moderators can manage content of the calendar', 1, 0, 0, 1, 0, 0),
(3, 'Anonymous', 'Group of anonymous users', 0, 0, 0, 0, 1, 1),
(4, 'Banned', 'The damned group.', 0, 0, 0, 0, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plugins`
--

CREATE TABLE `[[dbprefix]]plugins` (
  `plugin_id` int(11) NOT NULL AUTO_INCREMENT,
  `plugin_name` varchar(64) NOT NULL,
  `plugin_priority` tinyint(2) unsigned NOT NULL DEFAULT '50',
  `plugin_path` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`plugin_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Table holding installed plugins' AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]templates`
--

CREATE TABLE `[[dbprefix]]templates` (
  `template_id` int(11) NOT NULL AUTO_INCREMENT,
  `template_type` varchar(16) NOT NULL,
  `template_description` varchar(255) DEFAULT NULL,
  `template_status` tinyint(1) NOT NULL DEFAULT '0',
  `template_value` text,
  `last_access` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`template_id`),
  UNIQUE KEY `template_type` (`template_type`),
  KEY `template_status` (`template_status`),
  FULLTEXT KEY `template_value` (`template_value`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Table for custom interface template' AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]templates`
--

INSERT INTO `[[dbprefix]]templates` VALUES
(1, 'header', 'Custom header structure to display on top', 0, '<body>\r\n<div align="center">\r\n  <div class="apptitle">{CAL_NAME}</div>\r\n  <div class="appdesc">{CAL_DESCRIPTION}</div>\r\n  <br>\r\n  {ADMIN_MENU}\r\n  <br>\r\n  {MAIN_MENU} \r\n  <br>\r\n  <div width="{MAIN_TABLE_WIDTH}">\r\n', '[[regtime]]'),
(2, 'footer', 'Custom footer structure to display at the bottom', 0, '  </div>\r\n</div>\r\n</body>', '[[regtime]]'),
(3, 'meta', 'Space to hold meta tags and other browser related information', 1, '', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(30) NOT NULL DEFAULT '',
  `password` varchar(64) NOT NULL DEFAULT '',
  `firstname` varchar(64) DEFAULT '',
  `lastname` varchar(64) DEFAULT '',
  `group_id` int(11) NOT NULL DEFAULT '2',
  `lastvisit` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `email` varchar(255) NOT NULL DEFAULT '',
  `user_regdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_lang` varchar(255) NOT NULL DEFAULT '',
  `user_website` varchar(255) NOT NULL DEFAULT '',
  `user_location` varchar(255) NOT NULL DEFAULT '',
  `user_occupation` varchar(255) NOT NULL DEFAULT '',
  `reg_key` varchar(64) DEFAULT NULL,
  `user_status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Table for calendar users' AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', '[[admin_fname]]', '[[admin_lname]]', 1, '[[regtime]]', '[[admin_email]]', '[[regtime]]', '', '', '', '', NULL, 1);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
