<?PHP

// New language structure
$lang_info = array (
	'name' => 'Portuguese'
	,'nativename' => 'Portugus' // Language name in native language. E.g: 'Franais' for 'French'
	,'locale' => array('pt-br','Portuguese') // Standard locale alternatives for a specific language. For reference, go to: http://www.php.net/manual/en/function.setlocale.php
	,'charset' => 'ISO-8859-1' // For reference, go to : http://www.w3.org/International/O-charset-lang.html
	,'direction' => 'ltr' // 'ltr' for Left to Right. 'rtl' for Right to Left languages such as Arabic.
	,'author' => 'Allan Rodrigo Bomfim'
	,'author_email' => 'allanrodrigo@gmx.net'
	,'author_url' => 'www.infonet.com.br/allanrodrigo'
	,'transdate' => '01/20/2005'
);

$lang_general = array (
	'yes' => 'Sim'
	,'no' => 'No'
	,'back' => 'Voltar'
	,'continue' => 'Continuar'
	,'close' => 'Fechar'
	,'errors' => 'Erros'
	,'info' => 'Informao'
	,'day' => 'Dia'
	,'days' => 'Dias'
	,'month' => 'Ms'
	,'months' => 'Meses'
	,'year' => 'Ano'
	,'years' => 'Anos'
	,'hour' => 'Hora'
	,'hours' => 'Horas'
	,'minute' => 'Minuto'
	,'minutes' => 'Minutos'
	,'everyday' => 'Todo Dia'
	,'everymonth' => 'Todo Ms'
	,'everyyear' => 'Todo Ano'
	,'active' => 'Ativo'
	,'not_active' => 'No Ativo'
	,'today' => 'Hoje'
	,'signature' => 'Powered by %s'
	,'expand' => 'Expandir'
	,'collapse' => 'Encolher'	
);

// Date formats, For reference, go to : http://www.php.net/manual/en/function.strftime.php
$lang_date_format = array (
	'full_date' => '%A, %B %d, %Y' // e.g. Wednesday, June 05, 2002
	,'full_date_time_24hour' => '%A, %B %d, %Y At %H:%M' // e.g. Wednesday, June 05, 2002 At 21:05
	,'full_date_time_12hour' => '%A, %B %d, %Y At %I:%M %p' // e.g. Wednesday, June 05, 2002 At 9:05 pm
	,'day_month_year' => '%d-%b-%Y'
	,'local_date' => '%c'
	,'mini_date' => '%a. %d %b, %Y'
	,'month_year' => '%B %Y'
	,'day_of_week' => array('Domingo','Segunda','Tera','Quarta','Quinta','Sexta','Sbado')
	,'months' => array('Janeiro','Fevereiro','Maro','Abril','Maio','Junho','Julho','Agosto','Setembro','Outubro','Novembro','Dezembro')
);

$lang_system = array (
	'system_caption' => 'Mensagem de Sistema'
  ,'page_access_denied' => 'Voc no tem o nvel de privilgio para acessar esta pgina.'
  ,'page_requires_login' => 'Voc deve estar registrado para acessar esta pgina.'
  ,'operation_denied' => 'Vo no tem o nvel de privilgio para executar esta operao.'
  ,'section_disabled' => 'Esta seo est atualnente desabilitada !'
  ,'non_exist_cat' => 'A categoria selecionada no existe !'
  ,'non_exist_event' => 'O evento selecionado no existe !'
  ,'param_missing' => 'O parmetro fornecido est incorreto.'
  ,'no_events' => 'No h eventos a mostrar'
   ,'config_string' => 'You are currently using \'%s\' running on %s, %s and %s.'
  ,'no_table' => 'A \'%s\' tabela no existe !'
  ,'no_anonymous_group' => 'A %s tabela no contm o grupo \'Anonymous\'  !'
  ,'calendar_locked' => 'Este servio est em manuteno temporariamente. '
	,'new_upgrade' => 'O sistema detectou uma nova verso.  recomendada a tualizao agora. Clique "Continuar" para iniciar a atualizao.'
	,'no_profile' => 'Um erro ocorreu enquanto recuperamos a informao do seu perfil'
// Mail messages
	,'new_event_subject' => 'Novo Evento em %s'
	,'event_notification_failed' => 'Um erro ocorreu durante o envio da notificao de ativao por email !'
);

// Message body for new event email notification
$lang_system['event_notification_body'] = <<<EOT
O seguinte evento tem sido postado no {CALENDAR_NAME}

Ttulo: "{TITLE}"
Data: "{DATE}"
Durao: "{DURATION}"

Voc pode acessar este evento clicando no link abaixo
ou copiando e colando no seu navegador.

{LINK}

Atenciosamente,

O administrador de {CALENDAR_NAME}

EOT;

// Admin menu entries
$lang_admin_menu = array (
	'login' => 'Login'
	,'register' => 'Registrar'
  ,'logout' => 'Logout <span style="color:#FF9922">[<span style="color:#606F79">%s</span>]</span>'
  ,'user_profile' => 'Meu Perfil'
	,'admin_events' => 'Eventos'
  ,'admin_categories' => 'Categorias'
  ,'admin_groups' => 'Grupos'
  ,'admin_users' => 'Usurios'
  ,'admin_settings' => 'Configuraes'
);

// Main menu entries
$lang_main_menu = array (
	'add_event' => 'Adicionar Evento'
	,'cal_view' => 'Visualizar Meses'
  ,'flat_view' => 'Visualizar Flat'
  ,'weekly_view' => 'Visualizar Semanas'
  ,'daily_view' => 'Visualizar Dias'
  ,'yearly_view' => 'Visualizar Anos'
  ,'categories_view' => 'Categorias'
  ,'search_view' => 'Procurar'
);

// ======================================================
// Add Event view
// ======================================================

$lang_add_event_view = array(
	'section_title' => 'Adicionar Evento'
	,'edit_event' => 'Editar Evento [id%d] \'%s\''
	,'update_event_button' => 'Atualizar Evento'

// Event details
	,'event_details_label' => 'Detalhes do Evento'
	,'event_title' => 'Ttulo do Evento'
	,'event_desc' => 'Descrio do Evento'
	,'event_cat' => 'Categoria'
	,'choose_cat' => 'Selecione a Categoria'
	,'event_date' => 'Data do Evento'
	,'day_label' => 'Dia'
	,'month_label' => 'Ms'
	,'year_label' => 'Ano'
	,'start_date_label' => 'Incio do Evento'
	,'start_time_label' => 'em'
	,'end_date_label' => 'Durao'
	,'all_day_label' => 'Todo dia'
// Contact details
	,'contact_details_label' => 'Contato - Detalhes'
	,'contact_info' => 'Contato - Info'
	,'contact_email' => 'Contato - Email'
	,'contact_url' => 'Contato - URL'
// Repeat events
	,'repeat_event_label' => 'Repetir Evento'
	,'repeat_method_label' => 'Repetir Mtodo'
	,'repeat_none' => 'No repetir este evento'
	,'repeat_every' => 'Repetir todos'
	,'repeat_days' => 'Dia(s)'
	,'repeat_weeks' => 'Semana(s)'
	,'repeat_months' => 'Ms(es)'
	,'repeat_years' => 'Ano(s)'
	,'repeat_end_date_label' => 'Repetir data final'
	,'repeat_end_date_none' => 'Sem data final'
	,'repeat_end_date_count' => 'Finalizado depois de %s ocorrncia(s)'
	,'repeat_end_date_until' => 'Repetir at'	
// Other details
	,'other_details_label' => 'Outros Detalhes'
	,'picture_file' => 'Arquivo de Imagem'
	,'file_upload_info' => '(%d KBytes limite - vlida extenses : %s )' 
	,'del_picture' => 'Deletar imagem atual ?'
// Administrative options
	,'admin_options_label' => 'Opo Administrativas'
	,'auto_appr_event' => 'Evento Aprovado'

// Error messages
	,'no_title' => 'Voc deve dar um ttulo para o evento !'
	,'no_desc' => 'Voc deve dar uma descrio para este evento !'
	,'no_cat' => 'Voc deve selecionar uma categoria !'
	,'date_invalid' => 'Voc deve dar uma data vlida para este evento !'
	,'end_days_invalid' => 'O valor colocado no \'Days\' campo no  vlido !'
	,'end_hours_invalid' => 'O valor colocado no campo \'Hours\' no  vlido !'
	,'end_minutes_invalid' => 'O valor colocado no campo \'Minutes\' no  vlido !'
	
	,'non_valid_extension' => 'O formato de arquivo da imagem no  suportado ! (Vlidas extenses: %s)'

	,'file_too_large' => 'O arquivo  muito grande ! (%d KBytes limit)'
	,'move_image_failed' => 'O sistema falhou ao mover a imagem !'
	,'non_valid_dimensions' => 'A largura e altura da imagem  maior que %s pixels !'

	,'recur_val_1_invalid' => 'O valor colocado como \'repeat interval\' no  vlido. Este valor deve ser um nmero maior que \'0\' !'
	,'recur_end_count_invalid' => 'O valor colocado como \'number of occurrences\' no  vlido. Este valor deve ser um nmero maior que \'0\' !'
	,'recur_end_until_invalid' => 'O \'repeat until\' date deve ser uma data posterior ao incio do evento !'
// Misc. messages
	,'submit_event_pending' => 'Seu evento depende de aprovao. Obrigado pela sua participao !'
	,'submit_event_approved' => 'Seu evento est automaticamente aprovado. Obrigado pela sua participao !'
	,'event_repeat_msg' => 'Este evento est configurado para repetir'
	,'event_no_repeat_msg' => 'Este evento no ser repetido'
);

// ======================================================
// daily view
// ======================================================

$lang_daily_event_view = array(
	'section_title' => 'Visualizar Dias'
	,'next_day' => 'Prximo Dia'
	,'previous_day' => 'Dia Anterior'
	,'no_events' => 'No h eventos neste dia.'
);

// ======================================================
// weekly view
// ======================================================

$lang_weekly_event_view = array(
	'section_title' => 'Visualizar Semanas'
	,'week_period' => '%s - %s'
	,'next_week' => 'Prxima Semana'
	,'previous_week' => 'Semana Anterior'
	,'selected_week' => 'Semana %d'
	,'no_events' => 'No h eventos nesta semana'
);

// ======================================================
// monthly view
// ======================================================

$lang_monthly_event_view = array(
	'section_title' => 'Visualizar Mses'
	,'next_month' => 'Prximo Ms'
	,'previous_month' => 'Ms Anterior'
);

// ======================================================
// flat view
// ======================================================

$lang_flat_event_view = array(
	'section_title' => 'Visualizar Flat'
	,'week_period' => '%s - %s'
	,'next_month' => 'Prximo Ms'
	,'previous_month' => 'Ms Anterior'
	,'contact_info' => 'Contato - Info'
	,'contact_email' => 'Contato - Email'
	,'contact_url' => 'Contato - URL'
	,'no_events' => 'No h eventos neste ms'
);

// ======================================================
// Event view
// ======================================================

$lang_event_view = array(
	'section_title' => 'Evento: \'%s\''
	,'display_event' => 'Evento: \'%s\''
	,'cat_name' => 'Categoria'
	,'event_start_date' => 'Data'
	,'event_end_date' => 'At'
	,'event_duration' => 'Durao'
	,'contact_info' => 'Contato - Info'
	,'contact_email' => 'Email'
	,'contact_url' => 'URL'
	,'no_event' => 'No h eventos a serem exibidas.'
	,'stats_string' => '<strong>%d</strong> Eventos no Total'
	,'edit_event' => 'Editar Evento'
	,'delete_event' => 'Deletar Evento'
	,'delete_confirm' => 'Voc tem certeza que quer deletar este evento?'
	
);

// ======================================================
// Categories view
// ======================================================

$lang_cats_view = array(
	'section_title' => 'Mostrar Categorias'
	,'cat_name' => 'Nome da Categoria'
	,'total_events' => 'Total de Eventos'
	,'upcoming_events' => 'Eventos Prximos'
	,'no_cats' => 'No h categorias a serem exibidas.'
	,'stats_string' => 'H <strong>%d</strong> Eventos em <strong>%d</strong> Categorias'
);

// ======================================================
// Category Events view
// ======================================================

$lang_cat_events_view = array(
	'section_title' => 'Eventos sobre \'%s\''
	,'event_name' => 'Nome do Evento'
	,'event_date' => 'Data'
	,'no_events' => 'No h eventos nesta categoria.'
	,'stats_string' => '<strong>%d</strong> Eventos como Total'
);

// ======================================================
// cal_search.php
// ======================================================

$lang_event_search_data = array(
	'section_title' => 'Procurar no Calendrio',
	'search_results' => 'Resultado da Procura',
	'category_label' => 'Categoria',
	'date_label' => 'Data',
	'no_events' => 'No h eventos nesta categoria.',
	'search_caption' => 'Digite alguma palavra-chave...',
	'search_again' => 'Procurar Novamente',
	'search_button' => 'Procurar',
// Misc.
	'no_results' => 'Nenhum resultado encontrado',	
// Stats
	'stats_string1' => '<strong>%d</strong> evento(s) encontrados',
	'stats_string2' => '<strong>%d</strong> Evento(s) em <strong>%d</strong> pgina(s)'
);

// ======================================================
// profile.php
// ======================================================

if (defined('PROFILE_PHP')) 

$lang_user_profile_data = array(
	'section_title' => 'Meu Perfil',
	'edit_profile' => 'Editar Meu Perfil',
	'update_profile' => 'Atualizar Meu Perfil',
	'actions_label' => 'Aes',
// Account Info
	'account_info_label' => 'Informao da Conta',
	'user_name' => 'Login',
	'user_pass' => 'Senha',
	'user_pass_confirm' => 'Confirmar Senha',
	'user_email' => 'E-mai',
	'group_label' => 'Grupo',
// Other Details
	'other_details_label' => 'Outras Informaes',
	'first_name' => 'Nome',
	'last_name' => 'Sobrenome',
	'full_name' => 'Nome Completo',
	'user_website' => 'Home page',
	'user_location' => 'Localizao',
	'user_occupation' => 'Ocupao',
// Misc.
	'select_language' => 'Selecionar Idioma',
	'edit_profile_success' => 'Perfil atualizado com sucesso',
	'update_pass_info' => 'Deixe o campo de senha vazio caso no queira mud-la',
// Error messages
	'invalid_password' => 'Por favor, digite uma senha com apenas letras e nmeros e entre 4 e 16 caracteres !',
	'password_is_username' => 'A senha deve ser diferentes do login !',
	'password_not_match' =>'Senha no confirmada',
	'invalid_email' => 'Voc deve fornecer um email vlido !',
	'email_exists' => 'Outro usurio j est registrado com seu email. Por favor, digite um email diferente !',
	'no_email' => 'Voc deve fornecer um email !',
	'invalid_email' => 'Voc deve fornecer um email vlido !',
	'no_password' => 'Voc deve fornecer uma senha para esta nova conta !'
);

// ======================================================
// register.php
// ======================================================

if (defined('USER_REGISTRATION_PHP')) 

$lang_user_registration_data = array(
	'section_title' => 'Usurio Registrado',
// Step 1: Terms & Conditions
	'terms_caption' => 'Termos and Condies',
	'terms_intro' => 'Para prosseguir, voc deve concordar com os seguintes termos:',
	'terms_message' => 'Por favor, reserve um momento para revisar esses termos abaixo. Se voc concordar com eles e desejar prosseguir com a instalao, simplesmente clique em "Eu concordo". Para cancelar este registro, simplesmente clique no boto \'back\'  do seu navegador.<br /><br />Lembre-se que ns no nos responsabilizamos por nenhum evento postado por usurios desta aplicao de calendrio. Ns no garantimos a extadido, integridade ou utilidade de nenhum evento postado, e no nos responsabilizamos pelo contedo de nenhum evento.<br /><br />As mensagens expressam as opinies o autor do evento, no necessariamente as opinies dos desenvolvedores desta aplicao de calendrio. Todo usurio que sentir que um evento afixado  desagradvel, incetivamos a entrar em contato conosco imediatamente por email. Ns podemos remover o contedo desagradvel e ns faremos esforo para faz-lo dentro de um espao de tempo razovel, se ns determinarmos que a remoo  necessria.<br /><br />Voc concorda, atravs do seu uso deste servio, que voc no usar este calendrio para postar nenhum material que seja conscientemente falso ou defamatrio, inexato, abusivo, odioso, vulgar, incmodo, obsceno, ameador, sexualmente orientado, invasor de privacidade ou qualquer outra forma de violao da lei.w.<br /><br />Voc concorda em no postar material protegido por direitos autorais a no ser que os direitos autorais sejam seus ou a %s.',
	'terms_button' => 'Eu concordo',

// Account Info
	'account_info_label' => 'Informao da Conta',
	'user_name' => 'Login',
	'user_pass' => 'Senha',
	'user_pass_confirm' => 'Confirmar Senha',
	'user_email' => 'E-mail',
// Other Details
	'other_details_label' => 'Outras Informaes',
	'first_name' => 'Nome',
	'last_name' => 'Sobrenome',
	'user_website' => 'Home page',
	'user_location' => 'Localizao',
	'user_occupation' => 'Ocupao',
	'register_button' => 'Registrar',

// Stats
	'stats_string1' => '<strong>%d</strong> usurios',
	'stats_string2' => '<strong>%d</strong> usurios em <strong>%d</strong> pgina(s)',
// Misc.
	'reg_nomail_success' => 'Obrigado pelo seu registro.',
	'reg_mail_success' => 'Um email com informao de como ativar sua conta foi enviado para voc.',
	'reg_activation_success' => 'Parabns! Sua conta est ativada e voc j pode se logar. Obrigado pelo seu registro.',
// Mail messages
	'reg_confirm_subject' => 'Registrado em %s',
	
// Error messages
	'no_username' => 'Voc deve fornecer um nome para o login !',
	'invalid_username' => 'Por favor, digite um nome para o login que tenha somente letras e nmeros  e entre 4 a 30 caracteres !',
	'username_exists' => 'O login que voc digitou j existe. Por favor, tente registrar um outro nome para login !',
	'no_password' => 'Voc deve fornecer uma senha !',
	'invalid_password' => 'Por favor, digite uma senha com apenas letras e nmeros e entre 4 e 16 caracteres !',
	'password_is_username' => 'A senha deve ser diferentes do login !',
	'password_not_match' =>'Senha no confirmada',
	'no_email' => 'Voc deve fornecer um email !',
	'invalid_email' => 'Voc deve fornecer uma email vlido  !',
	'email_exists' => 'Outro usurio j est registrado com seu email. Por favor, digite um email diferente !',
	'delete_user_failed' => 'Este usurio no pode ser deletado',
	'no_users' => 'No h contas de usurio para exibir !',
	'already_logged' => 'Voc j est logado como um membro !',
	'registration_not_allowed' => 'Usurios registrados esto atualmente sem permisso !',
	'reg_email_failed' => 'Um erro ocorreu durante o envio da notificao de ativao por email !',
	'reg_activation_failed' => 'Um erro ocorreu durante o processo de ativao !'

);		
// Message body for email activation
$lang_user_registration_data['reg_confirm_body'] = <<<EOT
Obrigado pelo seu registro not {CALENDAR_NAME}

Seu login  : "{USERNAME}"
Sua senha  : "{PASSWORD}"

Para ativar sua conta, voc precisa clicar no link abaixo ou copiar e colar no seu navegador.

{REG_LINK}

Atenciosamente,

O administrador do {CALENDAR_NAME}

EOT;

// ======================================================
// theme.php
// ======================================================

// To Be Done

// ======================================================
// functions.inc.php
// ======================================================

// To Be Done

// ======================================================
// dblib.php
// ======================================================

// To Be Done

// ======================================================
// admin_events.php
// ======================================================

if (defined('ADMIN_EVENTS_PHP')) 

$lang_event_admin_data = array(
	'section_title' => 'Administrao de Evento',
	'events_to_approve' => 'Administrao de Evento: Eventos para Aprovar',
	'upcoming_events' => 'Administrao de Evento: Eventos Programados',
	'past_events' => 'Administrao de Evento: Eventos Passados',
	'add_event' => 'Adicionar Novo Evento',
	'edit_event' => 'Editar Evento',
	'view_event' => 'Exibir Evento',
	'approve_event' => 'Aprovar Evento',
	'update_event' => 'Atualizar Informaes do Evento',
	'delete_event' => 'Deletar Evento',
	'events_label' => 'Eventos',
	'auto_approve' => 'Auto-Aprovar',
	'date_label' => 'Data',
	'actions_label' => 'Aes',
	'events_filter_label' => 'Filtrar Eventos',
	'events_filter_options' => array('Mostrar todos eventos','Mostrar somente eventos no aprovados','Mostrar eventos programados','Mostrar somente eventos passados'),
	'picture_attached' => 'Imagem Anexada',
// View Event
	'view_event_name' => 'Evento: \'%s\'',
	'event_start_date' => 'Data',
	'event_end_date' => 'At',
	'event_duration' => 'Durao',
	'contact_info' => 'Contato - Info',
	'contact_email' => 'Email',
	'contact_url' => 'URL',
// General Info
// Event form
	'edit_event_title' => 'Evento: \'%s\'',
	'cat_name' => 'Categoria',
	'event_start_date' => 'Data',
	'event_end_date' => 'At',
	'contact_info' => 'Contato - Info',
	'contact_email' => 'Email',
	'contact_url' => 'URL',
	'no_event' => 'No h eventos a serem exibidos.',
	'stats_string' => '<strong>%d</strong> Eventos no Total',
// Stats
	'stats_string1' => '<strong>%d</strong> evento(s)',
	'stats_string2' => 'Total: <strong>%d</strong> eventos na(s) %d pgina(s)',
// Misc.
	'add_event_success' => 'Novo evento adicionado com sucesso',
	'edit_event_success' => 'Evento atualizado com sucesso',
	'approve_event_success' => 'Evento aprovado com sucesso',
	'delete_confirm' => 'Voc tem certeza que quer deletar este evento ?',
	'delete_event_success' => 'Evento deletado com sucesso',
	'active_label' => 'Ativo',
	'not_active_label' => 'Inativo',
// Error messages
	'no_event_name' => 'Voc deve fornecer um nome para este evento !',
	'no_event_desc' => 'Voc deve fornecer uma descrio para este evento !',
	'no_cat' => 'Voc deve selecionar a categoria para este evento !',
	'no_day' => 'Voc deve selecionar um dia !',
	'no_month' => 'Voc deve selecionar um ms !',
	'no_year' => 'Voc deve selecionar um ano !',
	'non_valid_date' => 'Por favor, entre com uma data vlida !',
	'end_days_invalid' => 'Por favor, verifique se o campo \'Days\' sobre \'Duration\' possui apenas nmeros !',
	'end_hours_invalid' => 'Por favor, verifique se o campo \'Hours\' sobre \'Duration\' possui apenas nmeros !',
	'end_minutes_invalid' => 'Por favor, verifique se o campo \'Minutes\' sobre \'Duration\' possui apenas nmeros !',
	'file_too_large' => 'A imagem  maior que %s KBytes !',
	'non_valid_extension' => 'O formato de arquivo da imagem no  suportado !',
	'delete_event_failed' => 'Este evento no pode ser deletado',
	'approve_event_failed' => 'Este evento no pode ser aprovado',
	'no_events' => 'No h eventos para exibir !',
	'move_image_failed' => 'O sistema falhou ao mover a imagem !',
	'non_valid_dimensions' => 'A imagem tem largura ou altura maior que %s pixels !',
	
	'recur_val_1_invalid' => 'O valor digitado como \'repeat interval\' no  vlido. Este valor deve ser um nmero maior que \'0\' !',
	'recur_end_count_invalid' => 'O valor digitado como \'number of occurrences\' no  vlido. Este valor deve ser um nmero maior que \'0\' !',
	'recur_end_until_invalid' => 'A data do \'repeat until\' deve ser posterior a data inicial do evento !'

);

// ======================================================
// admin_categories.php
// ======================================================

if (defined('ADMIN_CATS_PHP')) 

$lang_cat_admin_data = array(
	'section_title' => 'Categoria -  Administrao',
	'add_cat' => 'Adicionar Nova Categoria',
	'edit_cat' => 'Editar Categoria',
	'update_cat' => 'Atualizar Informao da Categoria',
	'delete_cat' => 'Deletar Categoria',
	'events_label' => 'Eventos',
	'auto_approve' => 'Auto-Aprovar',
	'actions_label' => 'Aes',
	'users_label' => 'Ususrios',
	'admins_label' => 'Admins',
// General Info
	'general_info_label' => 'Informao Geral',
	'cat_name' => 'Nome da Categoria',
	'cat_desc' => 'Descrio da Categoria',
	'cat_color' => 'Cor',
	'pick_color' => 'Esclha uma Cor!',
	'status_label' => 'Status',
// Administrative Options
	'admin_label' => 'Opes Administrativas',
	'auto_admin_appr' => 'Auto-aprovar posts dos administradores',
	'auto_user_appr' => 'Auto-aprovar posts dos usurios',
// Stats
	'stats_string1' => '<strong>%d</strong> categorias',
	'stats_string2' => 'Ativo: <strong>%d</strong>&nbsp;&nbsp;&nbsp;Total: <strong>%d</strong>&nbsp;&nbsp;&nbsp;na(s) %d pgina(s)',
// Misc.
	'add_cat_success' => 'Nova categoria adicionaca com sucesso',
	'edit_cat_success' => 'Categoria atualizada com sucesso',
	'delete_confirm' => 'Voc est certo que quer deletar esta categoria ?',
	'delete_cat_success' => 'Categoria deletada com sucesso',
	'active_label' => 'Ativo',
	'not_active_label' => 'Inativo',
// Error messages
	'no_cat_name' => 'Voc deve fornecer um nome pare esta categoria !',
	'no_cat_desc' => 'Voc deve fornecer uma descrio para esta categoria !',
	'no_color' => 'Voc~e deve fornecer uma cor para esta categoria !',
	'delete_cat_failed' => 'Esta categoria no pode ser deletada',
	'no_cats' => 'No h categorias para exibir!',
	'cat_has_events' => 'Esta categoria contm %d evento(s) e no pode ser deletada!<br>Por favor, delete os eventos que restam nessa categoria e tente novamente!'

);
// ======================================================
// admin_users.php
// ======================================================

if (defined('ADMIN_USERS_PHP')) 

$lang_user_admin_data = array(
	'section_title' => 'Administrador',
	'add_user' => 'Adicionar Novo Usurio',
	'edit_user' => 'Editar Informao de Usurio',
	'update_user' => 'Atualizar Informao de Usurio',
	'delete_user' => 'Deletar Conta de Usurio',
	'last_access' => 'ltimo Acesso',
	'actions_label' => 'Aes',
	'active_label' => 'Ativo',
	'not_active_label' => 'No Ativo',
// Account Info
	'account_info_label' => 'Informao da Conta',
	'user_name' => 'Login',
	'user_pass' => 'Senha',
	'user_pass_confirm' => 'Confirmar Senha',
	'user_email' => 'E-mail',
	'group_label' => 'Grupo de Membros',
	'status_label' => 'Status da Conta',
// Other Details
	'other_details_label' => 'Outras Informaes',
	'first_name' => 'Nome',
	'last_name' => 'Sobrenome',
	'user_website' => 'Home page',
	'user_location' => 'Localizao',
	'user_occupation' => 'Ocupao',
// Stats
	'stats_string1' => '<strong>%d</strong> usurios',
	'stats_string2' => '<strong>%d</strong> usurios em %d pgina(s)',
// Misc.
	'select_group' => 'Selecione uma...',
	'add_user_success' => 'Conta do usurio adicionada com sucesso',
	'edit_user_success' => 'Conta do usurio atualizada com sucesso',
	'delete_confirm' => 'Voc est certo que deseja deletar esta conta?',
	'delete_user_success' => 'Conta de usurio deletada com sucesso',
	'update_pass_info' => 'Deixa o compo de senha vazia se no deseja mud-la',
	'access_never' => 'Nunca',
// Error messages
	'no_username' => 'Voc deve fornecer o login !',
	'invalid_username' => 'Por favor, digite um nome para o login que tenha somente letras e nmeros  e entre 4 a 30 caracteres !',
	'invalid_password' => 'Por favor, digite uma senha com apenas letras e nmeros e entre 4 e 16 caracteres !',
	'password_is_username' => 'A senha deve ser diferente do login !',
	'password_not_match' =>'Senha no confirmada',
	'invalid_email' => 'Voc deve fornecer uma email vlido !',
	'email_exists' => 'Outro usurio j est registrado com seu email. Por favor, digite um email diferente !',
	'username_exists' => 'O login que voc digitou j existe. Por favor, tente registrar um outro nome para login !',
	'no_email' => 'Voc deve fornecer um email !',
	'invalid_email' => 'Voc deve fornecer uma email vlido !',
	'no_password' => 'Voc deve fornecer uma senha para esta conta !',
	'no_group' => 'Por favor selecione um grupo de mebros para este usurio !',
	'delete_user_failed' => 'Esta conta de usurio no pode ser deletada',
	'no_users' => 'No h contas de usurio para exibir !'

);

// ======================================================
// admin_groups.php
// ======================================================

if (defined('ADMIN_GROUPS_PHP')) 

$lang_group_admin_data = array(
	'section_title' => 'Grupo - Administrao',
	'add_group' => 'Adicionar Novo Grupo',
	'edit_group' => 'Editar Grupo',
	'update_group' => 'Atualizar Informaes de Grupo',
	'delete_group' => 'Deletar Grupo',
	'view_group' => 'Visualizar Grupo',
	'users_label' => 'Membros',
	'actions_label' => 'Aes',
// General Info
	'general_info_label' => 'Informao Geral',
	'group_name' => 'Nome do Grupo',
	'group_desc' => 'Descrio do Grupo',
// Group Access Level
	'access_level_label' => 'Nvel de Acesso do Grupo',
	'has_admin_access' => 'Usurios deste grupo tem acesso administrativo',
	'can_manage_accounts' => 'Usurios deste grupo podem manipular contas',
	'can_change_settings' => 'Usurios deste grupo podem mudar configuraes do calendrio',
	'can_manage_cats' => 'Usurios deste grupo podem manipular categorias',
	'upl_need_approval' => 'Postar eventos requer aprovao dos administradores',
// Stats
	'stats_string1' => '<strong>%d</strong> grupos',
	'stats_string2' => 'Total: <strong>%d</strong> grupos em %d pgina(s)',
	'stats_string3' => 'Total: <strong>%d</strong> usurios em %d pgina(s)',
// View Group Members
	'group_members_string' => 'Membros de \'%s\' grupos',
	'username_label' => 'Login',
	'firstname_label' => 'Primeiro Nome',
	'lastname_label' => 'Sobrenome',
	'email_label' => 'Email',
	'last_access_label' => 'ltimo Acesso',
	'edit_user' => 'Editar Uusrio',
	'delete_user' => 'Deletar Usurio',
// Misc.
	'add_group_success' => 'Novo grupo adicionado com sucesso',
	'edit_group_success' => 'Grupo atualizado com sucesso',
	'delete_confirm' => 'Voc est certo que deseja atualizar este grupo ?',
	'delete_user_confirm' => 'Voc est certo que deseja deletar este grupo ?',
	'delete_group_success' => 'Grupo deletado com sucesso',
	'no_users_string' => 'No h usurio neste grupo',
// Error messages
	'no_group_name' => 'Voc deve fornecer um nome para o grupo !',
	'no_group_desc' => 'Voc deve fornecer uma descrio para este grupo !',
	'delete_group_failed' => 'Este grupo no pode ser deletado',
	'no_groups' => 'No h grupos para serem exibidos !',
	'group_has_users' => 'Este grupo contm %d usurio(s) e no pode ser deletado!<br>Favor, desvincule os usurios restantes deste grupo e tente novamente!'

);

// ======================================================
// admin_settings.php / admin_settings_template.php / 
// admin_settings_updates.php
// ======================================================

if (defined('SETTINGS_PHP')) 

$lang_settings_data = array(
	'section_title' => 'Configuraes do Calendrio'
// Links
	,'admin_links_text' => 'Escolha a Seo'
	,'admin_links' => array('Configuraes Principais','Configurao de Template','Atualizar Programa')
// General Settings
	,'general_settings_label' => 'Configuraes Gerais'
	,'calendar_name' => 'Nome do Calendrio'
	,'calendar_description' => 'Descrio do Calendrio'
	,'calendar_admin_email' => 'Email do Administrador do Calendrio'
	,'cookie_name' => 'Nome para o cookie usado pelo script'
	,'cookie_path' => 'Path para o cookie usado pelo script'
	,'debug_mode' => 'Habilitar debug mode'
	,'calendar_status' => 'Status do Calendrio'
// Environment Settings
	,'env_settings_label' => 'Configuraes Ambiente'
	,'lang' => 'Idioma'
		,'lang_name' => 'Idioma'
		,'lang_native_name' => 'Nome Nativo'
		,'lang_trans_date' => 'Traduzido em'
		,'lang_author_name' => 'Autor'
		,'lang_author_email' => 'E-mail'
		,'lang_author_url' => 'Website'
	,'charset' => 'Character encoding'
	,'theme' => 'Tema'
		,'theme_name' => 'Nome do Tema'
		,'theme_date_made' => 'Feito em'
		,'theme_author_name' => 'Autor'
		,'theme_author_email' => 'E-mail'
		,'theme_author_url' => 'Website'
	,'timezone' => 'Fuso Horrio'
	,'time_format' => 'Formato de exibio de horas'
		,'24hours' => '24 Hours'
		,'12hours' => '12 Hours'
	,'auto_daylight_saving' => 'Ajustar automaticamente horrio de vero (DST)'
	,'main_table_width' => 'Largura da tabela principal (Pixels ou %)'
	,'day_start' => 'Semana comea em'
	,'default_view' => 'Visualizao padro'
	,'search_view' => 'Habilitar procura'
	,'archive' => 'Mostrar ltimos eventos'
	,'events_per_page' => 'Nmero de eventos por pgina'
	,'sort_order' => 'Ordem de classificao padro'
		,'sort_order_title_a' => 'Ttulo ascendente'
		,'sort_order_title_d' => 'Ttulo descendente'
		,'sort_order_date_a' => 'Date ascendente'
		,'sort_order_date_d' => 'Date descendente'
	,'show_recurrent_events' => 'Mostrar eventos recorrentes'
	,'multi_day_events' => 'Eventos em vrios dias'
		,'multi_day_events_all' => 'Mostrar toda escala de data'
		,'multi_day_events_bounds' => 'Mostrar data inicial e final somente'
		,'multi_day_events_start' => 'Mostrar data inicial somente'
	// User Settings
	,'user_settings_label' => 'Configuraes do Usurio'
	,'allow_user_registration' => 'Permitir registro de usurios'
	,'reg_duplicate_emails' => 'Permitir emails duplicados'
	,'reg_email_verify' => 'Habilitar ativao de conta atravs de email'
// Event View
	,'event_view_label' => 'Visualizar Evento'
	,'popup_event_mode' => 'Evento Pop-up'
	,'popup_event_width' => 'Largura da Janela Pop-up'
	,'popup_event_height' => 'Altura da Janela Pop-up'
// Add Event View
	,'add_event_view_label' => 'Adicionar Visulizao de Evento'
	,'add_event_view' => 'Ativado'
	,'addevent_allow_html' => 'Permitir <b>BB Code</b> '
	,'addevent_allow_contact' => 'Permitir Contato'
	,'addevent_allow_email' => 'Permitir Email'
	,'addevent_allow_url' => 'Permitir URL'
	,'addevent_allow_picture' => 'Permitir Imagens'
	,'new_post_notification' => 'Postar Nova Notificao'
// Calendar View
	,'calendar_view_label' => 'Visualizar Calendrio (Mensal) '
	,'monthly_view' => 'Ativado'
	,'cal_view_show_week' => 'Exibir Nmero da Semana'
	,'cal_view_max_chars' => 'Maximo de Caracteres na Descrio'
// Flyer View
	,'flyer_view_label' => 'Flyer View'
	,'flyer_view' => 'Ativado'
	,'flyer_show_picture' => 'Exibir imagens na Flyer View'
	,'flyer_view_max_chars' => 'Maximo de Caracteres na Descrio'
// Weekly View
	,'weekly_view_label' => 'Visualizar Semanas'
	,'weekly_view' => 'Ativado'
	,'weekly_view_max_chars' => 'Maximo de Caracteres na Descrio'
// Daily View
	,'daily_view_label' => 'Visualizar Dias'
	,'daily_view' => 'Ativado'
	,'daily_view_max_chars' => 'Maximo de Caracteres na Descrio'
// Categories View
	,'categories_view_label' => 'Visualizar Categorias'
	,'cats_view' => 'Ativado'
	,'cats_view_max_chars' => 'Maximo de Caracteres na Descrio'
// Mini Calendar
	,'mini_cal_label' => 'Mini Calendrio'
	,'mini_cal_def_picture' => 'Imagem Padro'
	,'mini_cal_display_picture' => 'Exibir Imagem'
	,'mini_cal_diplay_options' => array('Nenhuma','Imagem Padro', 'Imagens Diria','Imagem Semanal','Imagem Aleatria')
// Mail Settings
	,'mail_settings_label' => 'Configurao de Correio'
	,'mail_method' => 'Mtodo para Enviar Email'
	,'mail_smtp_host' => 'SMTP Hosts (separada por ponto e vrgula ;)'
	,'mail_smtp_auth' => ' SMTP Autenticao'
	,'mail_smtp_username' => 'SMTP Login'
	,'mail_smtp_password' => 'SMTP Senha'
	
	// Picture Settings
	,'picture_settings_label' => 'Configuraes de Imagems'
	,'max_upl_dim' => 'Max. largura ou altura para enviar imagens'
	,'max_upl_size' => 'Max. tamanho para enviar imagens (em Bytes)'
	,'picture_chmod' => 'Modo padro para imagens (CHMOD) (em Octal)'
	,'allowed_file_extensions' => 'Extenses de arquivo permitidos para upload de imagens'
// Form Buttons
	,'update_config' => 'Salvar Nova Configurao'
	,'restore_config' => 'Restaurar Padres'
// Misc.
	,'update_settings_success' => 'Configurao salva com sucesso'
	,'restore_default_confirm' => 'Voc ter certeza que quer restaurar as configuraes padro?'
// Template Configuration
	,'template_type' => 'Tipo de Template'
	,'template_header' => 'Personalizar Cabealho'
	,'template_footer' => 'Personalizar Rodap'
	,'template_status_default' => 'Usar tema template padro'
	,'template_status_custom' => 'Usar o seguinte template:'
	,'template_custom' => 'Personalizar template'

	,'info_meta' => 'Meta Information'
	,'info_status' => 'Controle de Status'
	,'info_status_default' => 'Desabilitar este ndice'
	,'info_status_custom' => 'Exibir o seguinte ndice:'
	,'info_custom' => 'Personalizar ndice'

	,'dynamic_tags' => 'Tags Dinmicas'

// Product Updates
	,'updates_check_text' => 'Por favor espera enquanto ns recuperamos a informao do servidor...'
	,'updates_no_response' => 'Nenhuma resposta do servidor. Por favor tente novamente mais tarde.'
	,'avail_updates' => 'Atualizao Disponvel'
	,'updates_download_zip' => 'Download ZIP package (.zip)'
	,'updates_download_tgz' => 'Download TGZ package (.tar.gz)'
	,'updates_released_label' => 'Release Date: %s'
	,'updates_no_update' => 'Voc est executando a ltima verso disponvel. No  necessrio atualizao.'
);

// ======================================================
// cal_mini.inc.php
// ======================================================

$lang_mini_cal = array(
	'def_pic' => 'Imagem Padro'
	,'daily_pic' => 'Imagem do Dia (%s)'
	,'weekly_pic' => 'Imagem da Semana (%s)'
	,'rand_pic' => 'Imagem Aleatria (%s)'
	,'post_event' => 'Postar Novo Evento'
);

// ======================================================
// calendar.php
// ======================================================

// To Be Done

// ======================================================
// config.inc.php
// ======================================================

// To Be Done

// ======================================================
// install.php
// ======================================================

// To Be Done

// ======================================================
// login.php
// ======================================================

if (defined('LOGIN_PHP')) 

$lang_login_data = array(
	'section_title' => 'Tela de Login'
// General Settings
	,'login_intro' => 'Digitar seu login e senha para entrar'
	,'username' => 'Login'
	,'password' => 'Senha'
	,'remember_me' => 'Lembre-me'
	,'login_button' => 'Entrar'
// Errors
	,'invalid_login' => 'Por favor, verifique seu login e senha e tente novamente !'
	,'no_username' => 'Voc deve digitar o login !'
	,'already_logged' => 'Voc j est logado !'
);

// ======================================================
// logout.php
// ======================================================

// To Be Done


?>