### Working with Issues

Add stuff to this page to explain what can be done with an open issue.

Issue Overview
--------------

The Issue Overview gives a bird's eye view of the issue, including its Status, Priority, Assignment and Summary.

The bottom of the Issue Overview contains buttons for multiple actions including changing the Status, or closing the issue.

### Mark as duplicate

See the topic on Associated issues

### Assigning authorized repliers

By assigning authorized repliers, you can have users that otherwise do not have the appropriate rights to edit an issue to post internal notes or comments.

### Associated issues

When you or a supportagent finds that the content of an issue is in any form related to an existing issue, an issue can either be:

-   associated (when the related issue has not been solved or the issues are not completely identical)
-   marked as duplicate when the essence of the issue is exactly equal to a previously entered issue.

For relating issues there is a lookup function available which gives you the opportunity to select an issue by its title or ID. This lookup is also available when the button "mark as duplicate" is used.

`Associated issues or duplicates are presented as hyperlinks on the issue detail page. `
`Hovering over the hyperlink will show you the status of the associated or duplicate issue as well as the title of the associated issue.`
`When the duplicated or associated issue is already closed, these hyperlinks will appear with strikethrough.`

Attached Files
--------------

Files may be uploaded to this section.

Time Tracking
-------------

A tool is provided to keep track of time spent working on an issue. This is self-reported, not automatic.

Internal Notes
--------------

Internal notes allow staff to comment on an issue, and updates are sent via email to users in the notification list for that issue.

Phone Calls
-----------

The Phone Calls section allows telephone conversations to be logged, including the date, time, parties involved, phone number (and type), and other information. While this feature may require a lot of discipline, it is an important way to keep staff aware of all action taken on an issue.

Drafts
------

Drafts of emails may be saved until they are ready to be sent. They are either original emails (as opposed to replies) that may be composed for and automatically associated with an issue, or they are replies to existing associated emails. It is often desirable to begin a draft, but not send it until more information is collected or other staff are allowed to review and/or collaborate.

An original draft must be saved at least once before it can be sent. When a saved draft is opened, it can be further edited or sent (added to the outgoing queue). Once the message is sent, it is removed from the Drafts section to the Associated Emails section. By default, it no longer appears in the Drafts list, but checking the "Show All Drafts" checkbox will cause sent messages to be displayed in strikethrough text.

When an existing associated email is opened by clicking on its "Reply" icon, the "Save as Draft" button appears at the bottom of the new window.

Note that once a Draft is saved, it cannot be deleted (as of v. 2.1), but it can be used as the basis for another draft in order to get rid of it.

**NOTE:** You must ensure that the recipient(s) are in the Authorized Repliers list, or responses will be blocked by the system.

Associated Emails
-----------------

Email integration allows messages to be associated to an issue, and they will be listed here. Association may be done manually from the "Associate Emails" page or automatically associated with an issue based on routing configuration. When draft emails are sent, they are also moved to this section.