CREATE TABLE `dsb_access_levels` (
  `level_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `level_code` varchar(30) NOT NULL,
  `level_diz` varchar(255) NOT NULL,
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `disabled_level` int(10) unsigned NOT NULL DEFAULT '0',
  `allow_na` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_visible` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`level_id`),
  UNIQUE KEY `level_code` (`level_code`)
) ENGINE=MyISAM ;

INSERT INTO `dsb_access_levels` (`level_id`, `level_code`, `level_diz`, `level`, `disabled_level`, `allow_na`, `is_visible`) VALUES
(1, 'login', 'when someone tries to login', 1, 65534, 0, 1),
(2, 'profile_view', 'View member profiles', 7, 0, 0, 0),
(21, 'search_photo', 'Search browse member photos', 7, 0, 0, 0),
(4, 'message_read', 'Read messages', 6, 1, 0, 0),
(5, 'message_write', 'Write messages', 6, 1, 0, 0),
(6, 'flirt_read', 'Read flirts', 6, 1, 0, 0),
(7, 'flirt_send', 'Send flirts', 6, 1, 0, 0),
(8, 'upload_photos', 'Upload photos', 6, 1, 0, 0),
(9, 'write_comments', 'Post comments', 6, 0, 0, 0),
(10, 'read_blogs', 'Read blogs', 7, 0, 0, 0),
(11, 'write_blogs', 'Write own blogs', 6, 1, 0, 0),
(13, 'view_photo', 'View larger single photos', 7, 0, 0, 0),
(14, 'manage_folders', 'Manage personal mail folders', 6, 1, 0, 0),
(15, 'saved_messages', 'Use saved responses feature', 6, 1, 0, 0),
(16, 'search_basic', 'Use the basic quick search forms', 7, 0, 0, 0),
(17, 'search_advanced', 'Use the advanced search form', 7, 0, 0, 0),
(18, 'manage_networks', 'Manage members in your networks', 6, 1, 0, 0),
(19, 'save_searches', 'Save personal searches', 6, 1, 0, 0),
(22, 'inbox', 'View messages in inbox', 6, 1, 0, 0),
(23, 'search_blog', 'Search browse blogs', 7, 0, 0, 0),
(24, 'contact', 'Use site contact form', 7, 0, 0, 1),
(25, 'message_reply', 'Reply to messages', 6, 1, 0, 0),
(26, 'flirt_reply', 'Reply to flirts', 6, 1, 0, 0),
(27, 'private_photos', 'Access to Member''s Private Photos', 6, 0, 0, 0),
(28, 'paid', 'Paid Access Only', 0, 0, 0, 1);

CREATE TABLE `dsb_admin_accounts` (
  `admin_id` int(3) unsigned NOT NULL AUTO_INCREMENT,
  `user` varchar(20) NOT NULL,
  `pass` varchar(32) NOT NULL,
  `name` varchar(50) NOT NULL,
  `status` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `dept_id` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `email` varchar(64) NOT NULL,
  PRIMARY KEY (`admin_id`),
  UNIQUE KEY `user` (`user`)
) ENGINE=MyISAM pack_keys=0;

INSERT INTO `dsb_admin_accounts` (`admin_id`, `user`, `pass`, `name`, `status`, `dept_id`, `email`) VALUES
(1, 'admin', 'fe01ce2a7fbac8fafaed7c982a04e229', 'Main Admin', 15, 4, '');

CREATE TABLE `dsb_admin_menu` (
  `link_id` int(3) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL,
  `link_text` varchar(100) NOT NULL,
  `link_type` tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`link_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

CREATE TABLE `dsb_admin_mtpls` (
  `amtpl_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `amtpl_name` varchar(40) NOT NULL,
  `subject` varchar(100) NOT NULL,
  `message_body` text NOT NULL,
  `amtpl_type` tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`amtpl_id`),
  KEY `amtpl_type` (`amtpl_type`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;

INSERT INTO `dsb_admin_mtpls` (`amtpl_id`, `amtpl_name`, `subject`, `message_body`, `amtpl_type`) VALUES
(1, 'Reject member profile', 'Your profile was not approved', '<html><head><title>Your profile has not been approved</title>   <link href="{tplvars.baseurl}/skins/def/styles/common.css" media="screen" type="text/css" rel="stylesheet" /> </head><body> <div id="trim"> 	<div id="content"> 		<p>Thank you for joining <a href="{tplvars.baseurl}">{tplvars.sitename}</a>.</p> 		<p>Unfortunately we are unable to publish your profile on the site yet because it doesn''t contain enough information to be of interest to other members.</p><p>Please update your profile with relevant information.<br /></p> 	</div> </div> </body></html>', 1),
(2, 'Reject photo', 'One of your photos was not approved', '<html><head><title>Your photo has not been approved</title>                       <link href="{tplvars.baseurl}/skins/def/styles/common.css" media="screen" type="text/css" rel="stylesheet" />     </head><body spellcheck="false"><p>Unfortunately we are unable to publish your photo on the site yet because</p>         <p>&nbsp;</p>         <p>Regards,<br />{tplvars.sitename} admin</p></body></html>', 2),
(3, 'Reject blog', 'One of your blog posts was not approved', '<html><head><title>Your blog post has not been approved</title>                       <link rel="stylesheet" type="text/css" media="screen" href="{tplvars.baseurl}/skins/def/styles/common.css" />     </head><body spellcheck="false"><p>Unfortunately we are unable to publish your blog post on the site yet because</p>         <p>&nbsp;</p>         <p>Regards,<br />         {tplvars.sitename} admin</p></body></html>', 3),
(4, 'Reject comment', 'One of your comments was not approved', '<html><head><title>Your comment has not been approved</title>                       <link rel="stylesheet" type="text/css" media="screen" href="{tplvars.baseurl}/skins/def/styles/common.css" />     </head><body spellcheck="false"><p>Unfortunately we are unable to publish your comment on the site yet because</p>         <p>&nbsp;</p>         <p>Regards,<br />         {tplvars.sitename} admin</p></body></html>', 4);

CREATE TABLE `dsb_banned_words` (
  `word_id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `word` varchar(100) NOT NULL,
  PRIMARY KEY (`word_id`),
  UNIQUE KEY `word` (`word`)
) ENGINE=MyISAM ;

INSERT INTO `dsb_banned_words` (`word_id`, `word`) VALUES
(5, 'fuck'),
(6, 'suck'),
(7, 'sucks'),
(8, 'dick'),
(9, 'cock'),
(10, 'penis');

CREATE TABLE `dsb_blog_posts` (
  `post_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date_posted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `fk_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `_user` varchar(48) NOT NULL,
  `fk_blog_id` int(10) unsigned NOT NULL DEFAULT '0',
  `is_public` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `title` varchar(200) NOT NULL,
  `post_content` text NOT NULL,
  `allow_comments` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `alt_url` text NOT NULL,
  `stat_views` int(5) unsigned NOT NULL DEFAULT '0',
  `stat_votes` int(4) unsigned NOT NULL DEFAULT '0',
  `stat_votes_total` int(5) unsigned NOT NULL DEFAULT '0',
  `stat_comments` int(5) unsigned NOT NULL DEFAULT '0',
  `last_changed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reject_reason` text NOT NULL,
  `processed` tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`post_id`),
  KEY `is_public` (`is_public`),
  KEY `date_posted` (`date_posted`),
  KEY `uid_pub_stat` (`fk_user_id`,`is_public`,`status`),
  KEY `bid_pub_stat` (`fk_blog_id`,`is_public`,`status`),
  FULLTEXT KEY `text_key` (`title`,`post_content`)
) ENGINE=MyISAM pack_keys=0;

CREATE TABLE `dsb_comments_blog` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fk_parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `fk_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `_user` varchar(48) NOT NULL,
  `comment` text NOT NULL,
  `date_posted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_changed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `processed` tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_id`),
  KEY `fk_user_id` (`fk_user_id`),
  KEY `date_posted` (`date_posted`),
  KEY `pid_stat` (`fk_parent_id`,`status`)
) ENGINE=MyISAM ;

CREATE TABLE `dsb_comments_photo` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fk_parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `fk_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `_user` varchar(48) NOT NULL,
  `comment` text NOT NULL,
  `date_posted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_changed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `processed` tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_id`),
  KEY `fk_user_id` (`fk_user_id`),
  KEY `date_posted` (`date_posted`),
  KEY `pid_stat` (`fk_parent_id`,`status`)
) ENGINE=MyISAM ;

CREATE TABLE `dsb_comments_profile` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fk_parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `fk_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `_user` varchar(48) NOT NULL,
  `comment` text NOT NULL,
  `date_posted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_changed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `processed` tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_id`),
  KEY `fk_user_id` (`fk_user_id`),
  KEY `date_posted` (`date_posted`),
  KEY `pid_stat` (`fk_parent_id`,`status`)
) ENGINE=MyISAM ;

CREATE TABLE `dsb_error_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(48) NOT NULL,
  `error` text NOT NULL,
  `error_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM ;

CREATE TABLE `dsb_feed_cache` (
  `module_code` varchar(32) NOT NULL,
  `feed_xml` text NOT NULL,
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`module_code`)
) ENGINE=MyISAM ;

CREATE TABLE `dsb_flirts` (
  `flirt_id` int(3) unsigned NOT NULL AUTO_INCREMENT,
  `flirt_text` text NOT NULL,
  `flirt_type` tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`flirt_id`),
  KEY `flirt_type` (`flirt_type`)
) ENGINE=MyISAM ;

INSERT INTO `dsb_flirts` (`flirt_id`, `flirt_text`, `flirt_type`) VALUES
(5, 'Hey sexy!', 0),
(6, 'Whaaadddup!', 0),
(4, 'I hope you know CPR, cuz you take my breath away...', 0),
(7, 'Hello? Hello? Anybody there?', 0),
(8, 'In your dreams', 1),
(9, 'Maybe later', 1),
(10, 'Sure, let''s go', 1);

CREATE TABLE `dsb_lang_keys` (
  `lk_id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `alt_id_text` varchar(40) NOT NULL,
  `lk_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `lk_diz` varchar(255) NOT NULL,
  `lk_use` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `save_file` varchar(100) NOT NULL,
  PRIMARY KEY (`lk_id`,`lk_use`)
) ENGINE=MyISAM ;

INSERT INTO `dsb_lang_keys` (`lk_id`, `alt_id_text`, `lk_type`, `lk_diz`, `lk_use`, `save_file`) VALUES
(1, '', 2, 'account not found', 2, 'join.inc.php'),
(2, '', 2, 'invalid blog', 2, 'blogs.inc.php'),
(3, '', 2, 'email changed ok', 2, 'email_change.inc.php'),
(4, '', 2, 'invalid email change request', 2, 'email_change.inc.php'),
(5, '', 2, 'no such message', 2, 'mailbox.inc.php'),
(6, '', 2, 'invalid photo', 2, 'photos.inc.php'),
(7, '', 2, 'Member not found.', 2, ''),
(8, '', 2, 'no search for less than 4 chars', 2, ''),
(9, '', 2, 'just one vote a day for a photo', 2, 'rating.inc.php'),
(10, '', 2, 'no vote for own photos', 2, 'rating.inc.php'),
(11, '', 2, 'invalid vote', 2, 'rating.inc.php'),
(12, '', 2, 'login to rate', 2, 'rating.inc.php'),
(13, '', 2, 'enter blog title', 2, 'blogs.inc.php'),
(14, '', 2, 'blog changed ok', 2, 'blogs.inc.php'),
(15, '', 2, 'blog added ok', 2, 'blogs.inc.php'),
(16, '', 2, 'blog deleted ok', 2, 'blogs.inc.php'),
(17, '', 2, 'add blog post title', 2, 'blogs.inc.php'),
(18, '', 2, 'add blog post content', 2, 'blogs.inc.php'),
(19, '', 2, 'blog post changed ok', 2, 'blogs.inc.php'),
(20, '', 2, 'blog post added ok', 2, 'blogs.inc.php'),
(21, '', 2, 'blog post added ok but needs approval', 2, 'blogs.inc.php'),
(22, '', 2, 'blog post deleted ok', 2, 'blogs.inc.php'),
(23, '', 2, 'enter comment', 2, 'comments.inc.php'),
(24, '', 2, 'bad captcha entered', 2, ''),
(25, '', 2, 'comment changed ok', 2, 'comments.inc.php'),
(26, '', 2, 'comment changed ok but needs approval', 2, 'comments.inc.php'),
(27, '', 2, 'not allowed to edit comments', 2, 'comments.inc.php'),
(28, '', 2, 'comment added ok', 2, 'comments.inc.php'),
(29, '', 2, 'comment added ok but needs approval', 2, 'comments.inc.php'),
(30, '', 2, 'comment deleted ok', 2, 'comments.inc.php'),
(31, '', 2, 'not allowed to delete comment', 2, 'comments.inc.php'),
(32, '', 2, 'enter subject', 2, 'contact.inc.php'),
(33, '', 2, 'need email to contact you back', 2, 'contact.inc.php'),
(34, '', 2, 'enter message', 2, 'contact.inc.php'),
(35, '', 2, 'message not sent', 2, 'contact.inc.php'),
(36, '', 2, 'message sent ok', 2, 'contact.inc.php'),
(37, '', 2, 'emails don''t match', 2, 'join.inc.php'),
(38, '', 2, 'enter new email address', 2, 'email_change.inc.php'),
(39, '', 2, 'email change confirmation sent ok', 2, 'email_change.inc.php'),
(40, '', 2, 'email subject: email change confirmation', 2, 'email_change.inc.php'),
(41, '', 2, 'filter not saved because no such user', 2, 'mailbox.inc.php'),
(42, '', 2, 'filter changed ok', 2, 'mailbox.inc.php'),
(43, '', 2, 'filter not changed', 2, 'mailbox.inc.php'),
(44, '', 2, 'filter added ok', 2, 'mailbox.inc.php'),
(45, '', 2, 'filter not added', 2, 'mailbox.inc.php'),
(46, '', 2, 'filter deleted ok', 2, 'mailbox.inc.php'),
(47, '', 2, 'flirt not sent because no receiver', 2, 'mailbox.inc.php'),
(48, '', 2, 'select a flirt', 2, 'mailbox.inc.php'),
(49, '', 2, 'no such flirt in db', 2, 'mailbox.inc.php'),
(50, '', 2, 'flirt sent ok', 2, 'mailbox.inc.php'),
(51, '', 2, 'folder renamed', 2, 'mailbox.inc.php'),
(52, '', 2, 'folder exists', 2, 'mailbox.inc.php'),
(53, '', 2, 'folder added ok', 2, 'mailbox.inc.php'),
(54, '', 2, 'folder exists, not added', 2, 'mailbox.inc.php'),
(55, '', 2, 'folder deleted ok', 2, 'mailbox.inc.php'),
(56, '', 2, 'passwords don''t match', 2, 'pass_change.inc.php'),
(57, '', 2, 'enter password', 2, 'pass_change.inc.php'),
(58, '', 2, 'invalid params', 2, 'pass_change.inc.php'),
(59, '', 2, 'password changed ok', 2, 'pass_change.inc.php'),
(60, '', 2, 'password not changed, invalid user', 2, 'pass_change.inc.php'),
(61, '', 2, 'x connections added', 2, 'net.inc.php'),
(62, '', 2, 'x connections declined', 2, 'net.inc.php'),
(63, '', 2, 'invalid user', 2, 'join.inc.php'),
(64, '', 2, 'account exists', 2, 'join.inc.php'),
(65, '', 2, 'invalid password', 2, 'join.inc.php'),
(66, '', 2, 'invalid email', 2, 'join.inc.php'),
(67, '', 2, 'email already exists', 2, 'join.inc.php'),
(68, '', 2, 'must agree to terms', 2, 'join.inc.php'),
(69, '', 2, 'fields must not be empty', 2, ''),
(70, '', 2, 'email subject: user registration', 2, 'join.inc.php'),
(71, '', 2, 'account suspended', 2, 'login.inc.php'),
(72, '', 2, 'invalid user or pass', 2, 'login.inc.php'),
(73, '', 2, 'x messages deleted', 2, 'mailbox.inc.php'),
(74, '', 2, 'x messages moved', 2, 'mailbox.inc.php'),
(75, '', 2, 'message not sent, no receiver', 2, 'mailbox.inc.php'),
(76, '', 2, 'response deleted ok', 2, 'mailbox.inc.php'),
(77, '', 2, 'ok', 2, ''),
(78, '', 2, 'enter title for search', 2, 'my_searches.inc.php'),
(79, '', 2, 'search title saved', 2, 'my_searches.inc.php'),
(80, '', 2, 'preferences saved ok', 2, 'my_settings.inc.php'),
(81, '', 2, 'invalid user to add/del to/from network', 2, 'net.inc.php'),
(82, '', 2, 'invalid network', 2, 'net.inc.php'),
(83, '', 2, 'confirmation request sent', 2, 'net.inc.php'),
(84, '', 2, 'message subject: confirmation request', 2, 'net.inc.php'),
(85, '', 2, 'confirmation request message', 2, 'net.inc.php'),
(86, '', 2, 'member added to network', 2, 'net.inc.php'),
(87, '', 2, 'member removed from network', 2, 'net.inc.php'),
(88, '', 2, 'password changed ok', 2, 'pass_change.inc.php'),
(89, '', 2, 'pass reset email sent', 2, 'pass_change.inc.php'),
(90, '', 2, 'entered email not found', 2, 'pass_change.inc.php'),
(91, '', 2, 'photo deleted ok', 2, 'photos.inc.php'),
(92, '', 2, 'photo settings changed ok', 2, 'photos.inc.php'),
(93, '', 2, 'photo upload error', 2, 'photos.inc.php'),
(94, '', 2, 'photo not uploaded because of min size', 2, 'photos.inc.php'),
(95, '', 2, 'photo not uploaded because of max size', 2, 'photos.inc.php'),
(96, '', 2, 'x photos uploaded ok', 2, 'photos.inc.php'),
(97, '', 2, 'no photo uploaded', 2, 'photos.inc.php'),
(98, '', 2, 'no search selected', 2, 'my_searches.inc.php'),
(99, '', 2, 'search saved', 2, 'my_searches.inc.php'),
(100, '', 2, 'profile changed ok', 2, ''),
(101, '', 2, 'search deleted ok', 2, 'my_searches.inc.php'),
(102, '', 2, 'is online', 2, ''),
(103, '', 2, 'is offline', 2, ''),
(104, '', 2, 'title: latest blogs', 2, 'blogs.inc.php'),
(105, '', 2, 'title: most popular blogs', 2, 'blogs.inc.php'),
(106, '', 2, 'title: most discussed blogs', 2, 'blogs.inc.php'),
(107, '', 2, 'title: search results', 2, ''),
(108, '', 2, 'title: ***''s blogs', 2, 'blogs.inc.php'),
(109, '', 2, 'title: blog posts', 2, 'blogs.inc.php'),
(110, '', 2, 'inbox', 2, 'mailbox.inc.php'),
(111, '', 2, 'sent', 2, 'mailbox.inc.php'),
(112, '', 2, 'Trash', 2, 'mailbox.inc.php'),
(113, '', 2, 'spambox', 2, 'mailbox.inc.php'),
(114, '', 2, 'user: x', 2, 'mailbox.inc.php'),
(115, '', 2, 'title: manage your filters', 2, 'mailbox.inc.php'),
(116, '', 2, 'title: message filters', 2, 'mailbox.inc.php'),
(117, '', 2, 'user', 2, ''),
(118, '', 2, 'users with x', 2, 'mailbox.inc.php'),
(119, '', 2, 'title: add/edit a filter', 2, 'mailbox.inc.php'),
(120, '', 2, 'no receiver specified', 2, 'mailbox.inc.php'),
(121, '', 2, 'title: send a flirt', 2, 'mailbox.inc.php'),
(122, '', 2, 'title: my personal folders', 2, 'mailbox.inc.php'),
(123, '', 2, 'never', 2, 'home.php'),
(124, '', 2, 'title: my home', 2, 'home.php'),
(125, '', 2, 'remaining chars', 2, ''),
(126, '', 2, 'country', 2, ''),
(127, '', 2, 'state', 2, ''),
(128, '', 2, 'city', 2, ''),
(129, '', 2, 'zip code', 2, ''),
(130, '', 2, 'title: registration', 2, 'join.inc.php'),
(131, '', 2, 'day', 2, ''),
(132, '', 2, 'year', 2, ''),
(133, '', 2, 'state', 2, ''),
(134, '', 2, 'select city', 2, ''),
(135, '', 2, 'SYSTEM', 2, 'mailbox.inc.php'),
(136, '', 2, 'title: read message', 2, 'mailbox.inc.php'),
(137, '', 2, 'title: write to x', 2, 'mailbox.inc.php'),
(138, '', 2, 'private', 2, 'photos.inc.php'),
(139, '', 2, 'public', 2, 'photos.inc.php'),
(140, '', 2, 'title: my photos', 2, 'photos.inc.php'),
(141, '', 2, 'title: my profile', 2, ''),
(142, '', 2, 'title: Saved Responses', 2, 'mailbox.inc.php'),
(143, '', 2, 'title: ***''s photos', 2, 'photos.inc.php'),
(144, '', 2, 'title: Newest Photos', 2, 'photos.inc.php'),
(145, '', 2, 'title: Most Popular Photos', 2, 'photos.inc.php'),
(146, '', 2, 'title: Most Voted Photos', 2, 'photos.inc.php'),
(147, '', 2, 'title: Most Discussed Photos', 2, 'photos.inc.php'),
(148, '', 2, 'title: results for "search"', 2, ''),
(149, '', 2, 'upload unlimited num of photos', 2, 'photos.inc.php'),
(150, '', 2, 'upload x more photos', 2, 'photos.inc.php'),
(151, '', 2, 'title: upload photos', 2, 'photos.inc.php'),
(152, '', 2, 'title: ***''s profile', 2, ''),
(153, '', 2, 'online now', 2, ''),
(154, '', 2, 'today', 2, ''),
(155, '', 2, 'yesterday', 2, ''),
(156, '', 2, 'last week', 2, ''),
(157, '', 2, 'last month', 2, ''),
(158, '', 2, 'more than a month ago', 2, ''),
(159, '', 2, 'any', 2, ''),
(160, '', 2, 'subject for new comment on blog notif', 2, 'comments.inc.php'),
(161, '', 2, 'message for new comment on blog notif', 2, 'comments.inc.php'),
(162, '', 2, 'subject for new comment on photo notif', 2, 'comments.inc.php'),
(163, '', 2, 'message for new comment on photo notif', 2, 'comments.inc.php'),
(164, '', 2, 'subject for new comment on profile notif', 2, 'comments.inc.php'),
(165, '', 2, 'message for new comment on profile notif', 2, 'comments.inc.php'),
(166, '', 2, 'month', 2, ''),
(167, '', 2, 'jan', 2, ''),
(168, '', 2, 'feb', 2, ''),
(169, '', 2, 'mar', 2, ''),
(170, '', 2, 'apr', 2, ''),
(171, '', 2, 'may', 2, ''),
(172, '', 2, 'jun', 2, ''),
(173, '', 2, 'jul', 2, ''),
(174, '', 2, 'aug', 2, ''),
(175, '', 2, 'sep', 2, ''),
(176, '', 2, 'oct', 2, ''),
(177, '', 2, 'nov', 2, ''),
(178, '', 2, 'dec', 2, ''),
(179, '', 2, 'pager: pages', 2, ''),
(180, '', 2, 'pager: results to show', 2, ''),
(181, '', 2, 'pager: go to first page', 2, ''),
(182, '', 2, 'pager: go to last page', 2, ''),
(183, '', 2, 'pager: go to next page', 2, ''),
(184, '', 2, 'pager: go to previous page', 2, ''),
(185, '', 2, 'distance', 2, ''),
(186, '', 2, 'miles from zip', 2, ''),
(187, '', 2, 'error processing payment', 2, 'payment.inc.php'),
(188, '', 2, 'error: paid amount doesn''t match subscription price', 2, 'payment.inc.php'),
(189, '', 2, 'error: invalid subscription', 2, 'payment.inc.php'),
(190, '', 2, 'paypal error: payment still pending', 2, 'payment.inc.php'),
(191, '', 2, 'paypal error: unhandled transaction type', 2, 'payment.inc.php'),
(192, '', 2, 'error: user not found', 2, 'payment.inc.php'),
(193, '', 2, 'error: invalid payment type', 2, 'payment.inc.php'),
(194, '', 2, 'emails don''t match', 2, 'email_change.inc.php'),
(195, '', 2, 'select country', 2, ''),
(196, '', 2, 'enter subject', 2, 'mailbox.inc.php'),
(197, '', 2, 'enter message', 2, 'mailbox.inc.php'),
(198, '', 2, 'message sent ok', 2, 'mailbox.inc.php'),
(199, '', 2, 'error: failed internal validation', 2, 'payment.inc.php'),
(200, '', 2, 'error trying to process the credit card', 2, 'payment.inc.php'),
(201, '', 2, 'error trying to process the credit card', 2, 'payment.inc.php'),
(202, '', 2, 'page title: Browse Blogs', 2, 'blogs.inc.php'),
(203, '', 2, 'last edited by xx on yy', 2, 'comments.inc.php'),
(204, '', 2, 'email already exists', 2, 'email_change.inc.php'),
(205, '', 2, 'More Blogs', 2, 'blogs.inc.php'),
(206, '', 2, 'title: Contact Us', 2, 'contact.inc.php'),
(207, '', 2, 'title: latest comments', 2, 'blogs.inc.php'),
(208, '', 2, 'title: Newest Members', 2, ''),
(209, '', 2, 'title: Most Voted Members', 2, ''),
(210, '', 2, 'title: Most Popular Members', 2, ''),
(211, '', 2, 'title: Most Discussed Members', 2, ''),
(212, '', 2, 'title: OS tech feed', 2, 'plugins/widget/osignal_feed/osignal_feed.class.php'),
(213, '', 2, 'title: Photos', 2, 'photos.inc.php'),
(214, '', 2, 'more photos', 2, 'photos.inc.php'),
(215, '', 2, 'title: site news', 2, 'plugins/widget/site_news/site_news.class.php'),
(216, '', 2, 'message subject: x sent you a kiss', 2, 'mailbox.inc.php'),
(217, '', 2, 'email subject: new matches', 2, ''),
(218, '', 2, 'email subject: subscription is about to expire', 2, ''),
(219, '', 2, 'More Members', 2, ''),
(220, '', 2, 'title: Add/Edit a Blog', 2, 'blogs.inc.php'),
(221, '', 2, 'title: blog name : post title', 2, 'blogs.inc.php'),
(222, '', 2, 'title: blog name - post title', 2, 'blogs.inc.php'),
(223, '', 2, 'title: Add/Edit a Post in blog', 2, 'blogs.inc.php'),
(224, '', 2, 'title: Change Password', 2, 'pass_change.inc.php'),
(225, '', 2, 'email subject: password reset confirmation', 2, 'pass_change.inc.php'),
(226, '', 2, 'title: Friendship Requests', 2, 'net.inc.php'),
(227, '', 2, 'title: Information', 2, 'info.php'),
(228, '', 2, 'title: Signup successful', 2, 'info.php'),
(229, '', 2, 'title: Upgrade', 2, 'info.php'),
(230, '', 2, 'title: Email sent', 2, 'info.php'),
(231, '', 2, 'title: Activate your account', 2, 'info.php'),
(232, '', 2, 'title: Account successfully confirmed', 2, 'info.php'),
(233, '', 2, 'title: No access until approved', 2, 'info.php'),
(234, '', 2, 'title: Subscribe', 2, 'info.php'),
(235, '', 2, 'title: Message', 2, 'info.php'),
(236, '', 2, 'title: Login', 2, 'login.inc.php'),
(237, '', 2, 'title: Login to continue', 2, 'login.inc.php'),
(238, '', 2, 'title: Posts in blog', 2, 'blogs.inc.php'),
(239, '', 2, 'title: My Blogs', 2, 'blogs.inc.php'),
(240, '', 2, 'title: How I am connected', 2, 'net.inc.php'),
(241, '', 2, 'title: Photo Settings', 2, 'photos.inc.php'),
(242, '', 2, 'title: My Searches', 2, 'my_searches.inc.php'),
(243, '', 2, 'title: My Settings', 2, 'my_settings.inc.php'),
(244, '', 2, 'title: Lost Password', 2, 'pass_change.inc.php'),
(245, '', 2, 'title: Compare Memberships', 2, 'payment.inc.php'),
(246, '', 2, 'title: Privacy', 2, 'privacy.php'),
(247, '', 2, 'title: Advanced Search', 2, ''),
(248, '', 2, 'title: Upgrade Your Membership', 2, 'payment.inc.php'),
(249, '', 2, 'title: Thank you for your payment', 2, 'payment.inc.php'),
(250, '', 2, 'title: Terms of Service', 2, 'tos.php'),
(251, '', 2, 'Subscribe to latest blog comments feed', 2, 'blogs.inc.php'),
(252, '', 2, 'You are not allowed to edit this comment', 2, 'comments.inc.php'),
(253, '', 2, 'Please enter a name to remember this search:', 2, ''),
(254, '', 2, 'error saving search', 2, ''),
(255, '', 2, 'Thank you for your vote', 2, 'rating.inc.php'),
(256, '', 2, 'comment remove confirmation', 2, ''),
(257, '', 2, 'Please select at least one photo to upload!', 2, 'photos.inc.php'),
(258, '', 2, 'please enter your email address', 2, 'pass_change.inc.php'),
(259, '', 2, 'enter captcha code', 2, ''),
(260, '', 2, 'Please enter the new password', 2, 'my_settings.inc.php'),
(261, '', 2, 'The passwords do not match', 2, 'my_settings.inc.php'),
(262, '', 2, 'delete blog and all posts?', 2, 'blogs.inc.php'),
(263, '', 2, 'Message saved as template', 2, 'mailbox.inc.php'),
(264, '', 2, 'not allowed to save message templates', 2, 'mailbox.inc.php'),
(265, '', 2, 'enter the new password', 2, 'pass_change.inc.php'),
(266, '', 2, 'The passwords do not match.', 2, 'pass_change.inc.php'),
(267, '', 2, 'enter folder name', 2, 'mailbox.inc.php'),
(268, '', 2, 'delete folder and all messages?', 2, 'mailbox.inc.php'),
(269, '', 2, 'enter new folder name', 2, 'mailbox.inc.php'),
(270, '', 2, 'delete this filter?', 2, 'mailbox.inc.php'),
(271, '', 2, 'enter a search term', 2, 'blogs.inc.php'),
(272, '', 2, 'Username is OK.', 2, 'join.inc.php'),
(273, '', 2, 'block this member?', 2, ''),
(274, '', 2, 'unblock this member?', 2, ''),
(275, '', 2, 'thanks for cancelling', 2, ''),
(276, '', 2, 'you sure you want to cancel?', 2, ''),
(2275, '', 2, 'Category name', 1, ''),
(2276, '', 2, 'Category name', 1, ''),
(2277, '', 2, 'Category name', 1, ''),
(2278, '', 2, 'Category name', 1, ''),
(2279, '', 2, 'Category name', 1, ''),
(2280, '', 2, 'Field value', 1, ''),
(2281, '', 2, 'Field value', 1, ''),
(2282, '', 2, 'Label for f1 field', 1, ''),
(2283, '', 2, 'Search label for f1 field', 1, ''),
(2284, '', 4, 'Help text for f1 field', 1, ''),
(2285, '', 2, 'Field value', 1, ''),
(2286, '', 2, 'Field value', 1, ''),
(2287, '', 2, 'Label for f2 field', 1, ''),
(2288, '', 2, 'Search label for f2 field', 1, ''),
(2289, '', 4, 'Help text for f2 field', 1, ''),
(2290, '', 2, 'Label for f3 field', 1, ''),
(2291, '', 2, 'Search label for f3 field', 1, ''),
(2292, '', 4, 'Help text for f3 field', 1, ''),
(2293, '', 2, 'Label for f4 field', 1, ''),
(2294, '', 2, 'Search label for f4 field', 1, ''),
(2295, '', 4, 'Help text for f4 field', 1, ''),
(2296, '', 2, 'Label for f5 field', 1, ''),
(2297, '', 2, 'Search label for f5 field', 1, ''),
(2298, '', 4, 'Help text for f5 field', 1, ''),
(2299, '', 2, 'Field value', 1, ''),
(2300, '', 2, 'Field value', 1, ''),
(2301, '', 2, 'Field value', 1, ''),
(2302, '', 2, 'Field value', 1, ''),
(2303, '', 2, 'Field value', 1, ''),
(2304, '', 2, 'Field value', 1, ''),
(2305, '', 2, 'Field value', 1, ''),
(2306, '', 2, 'Field value', 1, ''),
(2307, '', 2, 'Field value', 1, ''),
(2308, '', 2, 'Label for f6 field', 1, ''),
(2309, '', 2, 'Search label for f6 field', 1, ''),
(2310, '', 4, 'Help text for f6 field', 1, ''),
(2311, '', 2, 'Field value', 1, ''),
(2312, '', 2, 'Field value', 1, ''),
(2313, '', 2, 'Field value', 1, ''),
(2314, '', 2, 'Field value', 1, ''),
(2315, '', 2, 'Field value', 1, ''),
(2316, '', 2, 'Field value', 1, ''),
(2317, '', 2, 'Field value', 1, ''),
(2318, '', 2, 'Field value', 1, ''),
(2319, '', 2, 'Field value', 1, ''),
(2320, '', 2, 'Field value', 1, ''),
(2321, '', 2, 'Field value', 1, ''),
(2322, '', 2, 'Field value', 1, ''),
(2323, '', 2, 'Label for f7 field', 1, ''),
(2324, '', 2, 'Search label for f7 field', 1, ''),
(2325, '', 4, 'Help text for f7 field', 1, ''),
(2326, '', 2, 'Field value', 1, ''),
(2327, '', 2, 'Field value', 1, ''),
(2328, '', 2, 'Field value', 1, ''),
(2329, '', 2, 'Field value', 1, ''),
(2330, '', 2, 'Field value', 1, ''),
(2331, '', 2, 'Field value', 1, ''),
(2332, '', 2, 'Field value', 1, ''),
(2333, '', 2, 'Field value', 1, ''),
(2334, '', 2, 'Field value', 1, ''),
(2335, '', 2, 'Field value', 1, ''),
(2336, '', 2, 'Field value', 1, ''),
(2337, '', 2, 'Label for f8 field', 1, ''),
(2338, '', 2, 'Search label for f8 field', 1, ''),
(2339, '', 4, 'Help text for f8 field', 1, ''),
(2340, '', 2, 'Field value', 1, ''),
(2341, '', 2, 'Field value', 1, ''),
(2342, '', 2, 'Field value', 1, ''),
(2343, '', 2, 'Field value', 1, ''),
(2344, '', 2, 'Field value', 1, ''),
(2345, '', 2, 'Field value', 1, ''),
(2346, '', 2, 'Label for f9 field', 1, ''),
(2347, '', 2, 'Search label for f9 field', 1, ''),
(2348, '', 4, 'Help text for f9 field', 1, ''),
(2349, '', 2, 'Field value', 1, ''),
(2350, '', 2, 'Field value', 1, ''),
(2351, '', 2, 'Field value', 1, ''),
(2352, '', 2, 'Field value', 1, ''),
(2353, '', 2, 'Field value', 1, ''),
(2354, '', 2, 'Field value', 1, ''),
(2355, '', 2, 'Field value', 1, ''),
(2356, '', 2, 'Field value', 1, ''),
(2357, '', 2, 'Field value', 1, ''),
(2358, '', 2, 'Label for f10 field', 1, ''),
(2359, '', 2, 'Search label for f10 field', 1, ''),
(2360, '', 4, 'Help text for f10 field', 1, ''),
(2361, '', 2, 'Field value', 1, ''),
(2362, '', 2, 'Field value', 1, ''),
(2363, '', 2, 'Field value', 1, ''),
(2364, '', 2, 'Label for f11 field', 1, ''),
(2365, '', 2, 'Search label for f11 field', 1, ''),
(2366, '', 4, 'Help text for f11 field', 1, ''),
(2367, '', 2, 'Field value', 1, ''),
(2368, '', 2, 'Field value', 1, ''),
(2369, '', 2, 'Field value', 1, ''),
(2370, '', 2, 'Label for f12 field', 1, ''),
(2371, '', 2, 'Search label for f12 field', 1, ''),
(2372, '', 4, 'Help text for f12 field', 1, ''),
(2373, '', 2, 'Field value', 1, ''),
(2374, '', 2, 'Field value', 1, ''),
(2375, '', 2, 'Field value', 1, ''),
(2376, '', 2, 'Field value', 1, ''),
(2377, '', 2, 'Field value', 1, ''),
(2378, '', 2, 'Label for f13 field', 1, ''),
(2379, '', 2, 'Search label for f13 field', 1, ''),
(2380, '', 4, 'Help text for f13 field', 1, ''),
(2381, '', 2, 'Field value', 1, ''),
(2382, '', 2, 'Field value', 1, ''),
(2383, '', 2, 'Field value', 1, ''),
(2384, '', 2, 'Field value', 1, ''),
(2385, '', 2, 'Label for f14 field', 1, ''),
(2386, '', 2, 'Search label for f14 field', 1, ''),
(2387, '', 4, 'Help text for f14 field', 1, ''),
(2388, '', 2, 'Field value', 1, ''),
(2389, '', 2, 'Field value', 1, ''),
(2390, '', 2, 'Field value', 1, ''),
(2391, '', 2, 'Field value', 1, ''),
(2392, '', 2, 'Field value', 1, ''),
(2393, '', 2, 'Field value', 1, ''),
(2394, '', 2, 'Field value', 1, ''),
(2395, '', 2, 'Label for f15 field', 1, ''),
(2396, '', 2, 'Search label for f15 field', 1, ''),
(2397, '', 4, 'Help text for f15 field', 1, ''),
(280, '', 2, 'you are already connected to **', 2, 'net.inc.php'),
(279, '', 2, 'Private Photos from ***', 2, 'photos.inc.php'),
(278, '', 2, 'no photos found', 2, 'photos.inc.php'),
(277, '', 2, 'must be friends to see photos', 2, 'photos.inc.php'),
(2433, '', 2, 'Field value', 1, ''),
(2432, '', 2, 'Field value', 1, ''),
(2427, '', 2, 'Field value', 1, ''),
(2428, '', 2, 'Field value', 1, ''),
(2429, '', 2, 'Field value', 1, ''),
(2430, '', 2, 'Field value', 1, ''),
(2431, '', 2, 'Field value', 1, ''),
(2434, '', 2, 'message subject: friendship request accepted', 2, 'net.inc.php'),
(2435, '', 2, 'message body: friendship request accepted', 2, 'net.inc.php'),
(2436, 'rndi_str1', 2, 'title: Random Members', 2, 'plugins/widget/members/members.class.php'),
(2437, 'rndi_str2', 2, 'title: Random Photos', 2, 'plugins/widget/members/members.class.php');

CREATE TABLE `dsb_lang_strings` (
  `ls_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fk_lk_id` int(5) unsigned NOT NULL DEFAULT '0',
  `skin` varchar(32) NOT NULL,
  `lang_value` text NOT NULL,
  PRIMARY KEY (`ls_id`),
  UNIQUE KEY `lkid_skin` (`fk_lk_id`,`skin`)
) ENGINE=MyISAM ;

INSERT INTO `dsb_lang_strings` (`ls_id`, `fk_lk_id`, `skin`, `lang_value`) VALUES
(1, 1, 'skin_def', 'Sorry, your account has not been found. Maybe you have already activated your account?'),
(2, 2, 'skin_def', 'Invalid blog selected.'),
(3, 3, 'skin_def', 'Your email address has been changed.'),
(4, 4, 'skin_def', 'Invalid email change request.'),
(5, 5, 'skin_def', 'No such message.'),
(6, 6, 'skin_def', 'Invalid photo selected.'),
(7, 7, 'skin_def', 'Member not found.'),
(8, 8, 'skin_def', 'You are not allowed to search for less than 4 chars.'),
(9, 9, 'skin_def', 'You cannot vote more than once a day for the same photo.'),
(10, 10, 'skin_def', 'You are not allowed to vote for your own items.'),
(11, 11, 'skin_def', 'Invalid vote received.'),
(12, 12, 'skin_def', 'You must be logged in to rate photos.'),
(13, 13, 'skin_def', 'Please enter the title of the blog.'),
(14, 14, 'skin_def', 'Blog details changed.'),
(15, 15, 'skin_def', 'Blog created.'),
(16, 16, 'skin_def', 'Blog and all related posts and comments deleted.'),
(17, 17, 'skin_def', 'Please add a title for this post.'),
(18, 18, 'skin_def', 'Please write something in this post.'),
(19, 19, 'skin_def', 'Post changed successfully.'),
(20, 20, 'skin_def', 'Post added.'),
(21, 21, 'skin_def', 'Post added. It will be reviewed and published shortly.'),
(22, 22, 'skin_def', 'Post deleted.'),
(23, 23, 'skin_def', 'Please enter your comment.'),
(24, 24, 'skin_def', 'The verification code doesn''t match. Please enter the new code.'),
(25, 25, 'skin_def', 'Comment changed successfully.'),
(26, 26, 'skin_def', 'Comment changed but needs to be reviewed first.'),
(27, 27, 'skin_def', 'You are not allowed to edit comments.'),
(28, 28, 'skin_def', 'Comment added.'),
(29, 29, 'skin_def', 'Comment added but needs to be reviewed first.'),
(30, 30, 'skin_def', 'Comment deleted.'),
(31, 31, 'skin_def', 'You are not allowed to delete this comment.'),
(32, 32, 'skin_def', 'Please enter the message subject.'),
(33, 33, 'skin_def', 'Please enter your email address where we can contact you back.'),
(34, 34, 'skin_def', 'Please enter the message.'),
(35, 35, 'skin_def', 'Your message could not be sent: %s'),
(36, 36, 'skin_def', 'Message sent successfully.'),
(37, 37, 'skin_def', 'The emails do not match.'),
(38, 38, 'skin_def', 'Please enter the new email address you wish to use.'),
(39, 39, 'skin_def', 'An email has been sent to the email address you specified.'),
(40, 40, 'skin_def', '%1$s email change confirmation'),
(41, 41, 'skin_def', 'User %1$s doesn''t exist. Filter not saved.'),
(42, 42, 'skin_def', 'Filter changed successfully.'),
(43, 43, 'skin_def', 'Filter not changed. A similar filter already exists.'),
(44, 44, 'skin_def', 'Filter added.'),
(45, 45, 'skin_def', 'Filter not added. A similar filter already exists.'),
(46, 46, 'skin_def', 'Filter deleted.'),
(47, 47, 'skin_def', 'Flirt not sent because there was no receiver specified.'),
(48, 48, 'skin_def', 'Please select a flirt to send.'),
(49, 49, 'skin_def', 'Could not find flirt in database. Please select another flirt.'),
(50, 50, 'skin_def', 'Flirt sent.'),
(51, 51, 'skin_def', 'Folder renamed.'),
(52, 52, 'skin_def', 'Folder not changed. This folder name already exists.'),
(53, 53, 'skin_def', 'Folder added.'),
(54, 54, 'skin_def', 'Folder not added. This folder name already exists.'),
(55, 55, 'skin_def', 'Folder deleted.'),
(56, 56, 'skin_def', 'The passwords do not match.'),
(57, 57, 'skin_def', 'Please enter the password.'),
(58, 58, 'skin_def', 'Invalid parameters received.'),
(59, 59, 'skin_def', 'Password changed, please login below.'),
(60, 60, 'skin_def', 'Invalid username specified. Password not changed.'),
(61, 61, 'skin_def', '%s connections added.'),
(62, 62, 'skin_def', '%s connections declined.'),
(63, 63, 'skin_def', 'Please only use letters, numerals, dashes and underscores for your username. Dashes and underscores can not be added at the start or end of your username. Length of username must be 4-20 characters.'),
(64, 64, 'skin_def', 'This account already exists. Please choose another one.'),
(65, 65, 'skin_def', 'Password cannot be empty. Please enter your password.'),
(66, 66, 'skin_def', 'Invalid email entered. Please check your email.'),
(67, 67, 'skin_def', 'The email address %s is already in use.'),
(68, 68, 'skin_def', 'You must agree to the terms of services before joining the site.'),
(69, 69, 'skin_def', 'The fields outlined below are required and must not be empty.'),
(70, 70, 'skin_def', '%s user registration confirmation'),
(71, 71, 'skin_def', 'Your account is suspended.'),
(72, 72, 'skin_def', 'Invalid user name or password. Please try again.'),
(73, 73, 'skin_def', '%s message(s) deleted.'),
(74, 74, 'skin_def', '%s message(s) moved.'),
(75, 75, 'skin_def', 'Message not sent because there was no receiver specified.'),
(76, 76, 'skin_def', 'Response deleted.'),
(77, 77, 'skin_def', 'Ok'),
(78, 78, 'skin_def', 'Please enter a title for this search.'),
(79, 79, 'skin_def', 'Search title saved.'),
(80, 80, 'skin_def', 'Your preferences were saved.'),
(81, 81, 'skin_def', 'Invalid user.'),
(82, 82, 'skin_def', 'Invalid network selected.'),
(83, 83, 'skin_def', 'A confirmation request has been sent to %1$s.'),
(84, 84, 'skin_def', 'Connection request from %s'),
(85, 85, 'skin_def', '%1$s wants to add you to their %2$s network.<br><a class="content-link simple" href="friendship_requests.php">Click here</a> to approve/deny this request and to see any other friendship requests.'),
(86, 86, 'skin_def', '%1$s has been added to your %2$s.'),
(87, 87, 'skin_def', '%1$s has been removed from your %2$s.'),
(88, 88, 'skin_def', 'Password changed.'),
(89, 89, 'skin_def', 'An email with steps required to reset your password has been sent to your address.'),
(90, 90, 'skin_def', 'The email address you entered was not found.'),
(91, 91, 'skin_def', 'Photo deleted.'),
(92, 92, 'skin_def', 'Settings changed.'),
(93, 93, 'skin_def', 'Sorry, an error has occured. Try uploading less photos at once or smaller photos.'),
(94, 94, 'skin_def', 'Photo %1$s was not uploaded because the minimum allowed size for photos is %2$s bytes.'),
(95, 95, 'skin_def', 'Photo %1$s was not uploaded because the maximum allowed size for photos is %2$s bytes.'),
(96, 96, 'skin_def', '%1u photos uploaded.'),
(97, 97, 'skin_def', 'No photo uploaded.'),
(98, 98, 'skin_def', 'No search selected.'),
(99, 99, 'skin_def', 'Search saved.'),
(100, 100, 'skin_def', 'Your profile has been changed.'),
(101, 101, 'skin_def', 'Your search has been deleted.'),
(102, 102, 'skin_def', 'is online'),
(103, 103, 'skin_def', 'is offline'),
(104, 104, 'skin_def', 'Latest Blogs'),
(105, 105, 'skin_def', 'Most Popular Blogs'),
(106, 106, 'skin_def', 'Most Discussed Blogs'),
(107, 107, 'skin_def', 'Search Results'),
(108, 108, 'skin_def', '%1$s''s Blogs'),
(109, 109, 'skin_def', 'Blog Posts'),
(110, 110, 'skin_def', 'INBOX'),
(111, 111, 'skin_def', 'SENT'),
(112, 112, 'skin_def', 'Trash'),
(113, 113, 'skin_def', 'SPAMBOX'),
(114, 114, 'skin_def', 'User: %1$s'),
(115, 115, 'skin_def', 'Manage your filters'),
(116, 116, 'skin_def', 'Message Filters'),
(117, 117, 'skin_def', 'user'),
(118, 118, 'skin_def', 'users with %1$s'),
(119, 119, 'skin_def', 'Add/Edit a Filter'),
(120, 120, 'skin_def', 'No receiver specified'),
(121, 121, 'skin_def', 'Send a Flirt'),
(122, 122, 'skin_def', 'My Personal Folders'),
(123, 123, 'skin_def', 'Never'),
(124, 124, 'skin_def', 'My Home'),
(125, 125, 'skin_def', 'Remaining chars:'),
(126, 126, 'skin_def', 'Any Country'),
(127, 127, 'skin_def', 'State'),
(128, 128, 'skin_def', 'City'),
(129, 129, 'skin_def', 'Zip'),
(130, 130, 'skin_def', 'Registration'),
(131, 131, 'skin_def', 'day'),
(132, 132, 'skin_def', 'year'),
(133, 133, 'skin_def', 'Select state'),
(134, 134, 'skin_def', 'Select city'),
(135, 135, 'skin_def', 'SYSTEM'),
(136, 136, 'skin_def', 'Read Message'),
(137, 137, 'skin_def', 'Write to %1$s'),
(138, 138, 'skin_def', 'private'),
(139, 139, 'skin_def', 'public'),
(140, 140, 'skin_def', 'My Photos'),
(141, 141, 'skin_def', 'My Profile'),
(142, 142, 'skin_def', 'Saved Responses'),
(143, 143, 'skin_def', '%1$s''s Photos'),
(144, 144, 'skin_def', 'Newest Photos'),
(145, 145, 'skin_def', 'Most Popular Photos'),
(146, 146, 'skin_def', 'Most Voted Photos'),
(147, 147, 'skin_def', 'Most Discussed Photos'),
(148, 148, 'skin_def', 'Results for "%1$s"'),
(149, 149, 'skin_def', 'You can upload an unlimited number of photos.'),
(150, 150, 'skin_def', 'You can upload %1$s more photos.'),
(151, 151, 'skin_def', 'Upload Photos'),
(152, 152, 'skin_def', '%1$s''s Profile'),
(153, 153, 'skin_def', 'Online now!'),
(154, 154, 'skin_def', 'Today'),
(155, 155, 'skin_def', 'Yesterday'),
(156, 156, 'skin_def', 'Last week'),
(157, 157, 'skin_def', 'Last month'),
(158, 158, 'skin_def', 'More than a month ago'),
(159, 159, 'skin_def', 'Any'),
(160, 160, 'skin_def', 'New comment on one of your blogs'),
(161, 161, 'skin_def', '%1$s posted a comment on one of your blog posts.<br><a class="content-link simple" href="blog_post_view.php?pid=%2$s#comm%3$s">Click here</a> to view the comment'),
(162, 162, 'skin_def', 'New comment on one of your photos'),
(163, 163, 'skin_def', '%1$s posted a comment on one of your photos.<br><a class="content-link simple" href="photo_view.php?photo_id=%2$s#comm%3$s">Click here</a> to view the comment'),
(164, 164, 'skin_def', 'New comment on your profile'),
(165, 165, 'skin_def', '%1$s posted a comment on your profile.<br><a class="content-link simple" href="my_comments.php#comm%2$s">Click here</a> to view the comment'),
(166, 166, 'skin_def', 'month'),
(167, 167, 'skin_def', 'jan'),
(168, 168, 'skin_def', 'feb'),
(169, 169, 'skin_def', 'mar'),
(170, 170, 'skin_def', 'apr'),
(171, 171, 'skin_def', 'may'),
(172, 172, 'skin_def', 'jun'),
(173, 173, 'skin_def', 'jul'),
(174, 174, 'skin_def', 'aug'),
(175, 175, 'skin_def', 'sep'),
(176, 176, 'skin_def', 'oct'),
(177, 177, 'skin_def', 'nov'),
(178, 178, 'skin_def', 'dec'),
(179, 179, 'skin_def', 'Pages:'),
(180, 180, 'skin_def', 'Results to show:'),
(181, 181, 'skin_def', 'Go to first page'),
(182, 182, 'skin_def', 'Go to last page'),
(183, 183, 'skin_def', 'Go to next page'),
(184, 184, 'skin_def', 'Go to previous page'),
(185, 185, 'skin_def', 'Distance'),
(186, 186, 'skin_def', 'miles from zip'),
(187, 187, 'skin_def', 'We''re sorry but there were some problems processing your payment. Please contact us to upgrade your subscription.'),
(188, 188, 'skin_def', 'We''re sorry but the price you''ve paid doesn''t match the subscription price. Please contact us to upgrade your subscription.'),
(189, 189, 'skin_def', 'We''re sorry but the system doesn''t recognize the subscription for the payment you''ve made. Please contact us to upgrade your subscription.'),
(190, 190, 'skin_def', 'Thank you for your payment. The transaction is still <strong>pending</strong> at the moment. As soon as the payment clears, a receipt for your purchase will be emailed to you and your membership will be upgraded.<br>You may log into your account at http://www.paypal.com to view details of this transaction.'),
(191, 191, 'skin_def', 'Error: Unhandled transaction type received from Paypal.'),
(192, 192, 'skin_def', 'Error: Sorry, your username could not be found. Please contact us to upgrade your membership.'),
(193, 193, 'skin_def', 'Invalid payment received. Please contact us if you feel this is an error.'),
(194, 194, 'skin_def', 'The emails do not match.'),
(195, 195, 'skin_def', 'Select country'),
(196, 196, 'skin_def', 'Please enter the message subject.'),
(197, 197, 'skin_def', 'Please enter the message.'),
(198, 198, 'skin_def', 'Message sent successfully.'),
(199, 199, 'skin_def', 'We''re sorry but this transaction failed internal validation. Please try again.'),
(200, 200, 'skin_def', 'We''re sorry, but an error occurred when trying to process your Credit Card: %1$s (%2$s)'),
(201, 201, 'skin_def', 'We''re sorry, but an error occurred when trying to process your Credit Card. Please contact us for details or try again.'),
(202, 202, 'skin_def', 'Browse Blogs'),
(203, 203, 'skin_def', ''),
(204, 204, 'skin_def', 'The email address %s is already in use.'),
(205, 205, 'skin_def', 'More Blogs'),
(206, 206, 'skin_def', 'Contact Us'),
(207, 207, 'skin_def', 'Latest Comments'),
(208, 208, 'skin_def', 'Newest Members'),
(209, 209, 'skin_def', 'Most Voted Members'),
(210, 210, 'skin_def', 'Most Popular Members'),
(211, 211, 'skin_def', 'Most Discussed Members'),
(212, 212, 'skin_def', 'Original Signal Tech Feed'),
(213, 213, 'skin_def', 'Photos'),
(214, 214, 'skin_def', 'More Photos'),
(215, 215, 'skin_def', 'News'),
(216, 216, 'skin_def', '%s sent you a flirt'),
(217, 217, 'skin_def', 'New matches for you on %1$s'),
(218, 218, 'skin_def', 'Your %s subscription is about to expire'),
(219, 219, 'skin_def', 'More Members'),
(220, 220, 'skin_def', 'Add/Edit a Blog'),
(221, 221, 'skin_def', '%2$s'),
(222, 222, 'skin_def', 'Blogs - %1$s - %2$s'),
(223, 223, 'skin_def', 'Add/Edit a Post in %1$s'),
(224, 224, 'skin_def', 'Change Password'),
(225, 225, 'skin_def', '%1$s password reset confirmation'),
(226, 226, 'skin_def', 'Friendship Requests'),
(227, 227, 'skin_def', 'Information'),
(228, 228, 'skin_def', 'Signup successful!'),
(229, 229, 'skin_def', 'Upgrade'),
(230, 230, 'skin_def', 'Email sent'),
(231, 231, 'skin_def', 'Activate your account'),
(232, 232, 'skin_def', 'Account successfully confirmed!'),
(233, 233, 'skin_def', 'No access until approved!'),
(234, 234, 'skin_def', 'Subscribe'),
(235, 235, 'skin_def', 'Message'),
(236, 236, 'skin_def', 'Login'),
(237, 237, 'skin_def', 'Login to continue...'),
(238, 238, 'skin_def', 'Posts in %1$s'),
(239, 239, 'skin_def', 'My Blogs'),
(240, 240, 'skin_def', 'How I am connected'),
(241, 241, 'skin_def', 'Photo Settings'),
(242, 242, 'skin_def', 'My Searches'),
(243, 243, 'skin_def', 'My Settings'),
(244, 244, 'skin_def', 'Lost Password'),
(245, 245, 'skin_def', 'Compare Memberships'),
(246, 246, 'skin_def', 'Privacy'),
(247, 247, 'skin_def', 'Advanced Search'),
(248, 248, 'skin_def', 'Upgrade Your Membership'),
(249, 249, 'skin_def', 'Thank you for your payment'),
(250, 250, 'skin_def', 'Terms of Service'),
(251, 251, 'skin_def', 'Subscribe to latest blog comments feed'),
(503, 252, 'skin_def', 'You are not allowed to edit this comment.'),
(504, 253, 'skin_def', 'Please enter a name to remember this search:'),
(505, 254, 'skin_def', 'There has been an error saving your search. Please try again later.'),
(506, 255, 'skin_def', 'Thank you for your vote.'),
(507, 256, 'skin_def', 'Are you sure you want to remove this comment?'),
(508, 257, 'skin_def', 'Please select at least one photo to upload!'),
(509, 258, 'skin_def', 'Please enter the email address you used to register with us.'),
(510, 259, 'skin_def', 'Please enter the code from the image.'),
(511, 260, 'skin_def', 'Please enter the new password.'),
(512, 261, 'skin_def', 'The passwords do not match.'),
(513, 262, 'skin_def', 'Are you sure you want to permanently delete this blog? All posts in this blog will also be deleted!'),
(514, 263, 'skin_def', 'Message saved as template.'),
(515, 264, 'skin_def', 'You are not allowed to save message templates.'),
(516, 265, 'skin_def', 'Please enter the new password.'),
(517, 266, 'skin_def', 'The passwords do not match.'),
(518, 267, 'skin_def', 'Please enter the folder name.'),
(519, 268, 'skin_def', 'Are you sure you want to delete this folder? All messages inside this folder will be moved to Trash and all the filters associated with this folder will be deleted!'),
(520, 269, 'skin_def', 'Please enter the new folder name.'),
(521, 270, 'skin_def', 'Are you sure you want to delete this filter?'),
(522, 271, 'skin_def', 'Please enter a search term.'),
(523, 272, 'skin_def', 'The chosen username is OK and can be used.'),
(524, 273, 'skin_def', 'Are you sure you want to block this member?'),
(525, 274, 'skin_def', 'Are you sure you want to unblock this member?'),
(526, 2275, 'skin_def', 'Basic Info'),
(527, 2276, 'skin_def', 'Appearance'),
(528, 2277, 'skin_def', 'Lifestyle'),
(529, 2278, 'skin_def', 'Home Life'),
(530, 2279, 'skin_def', 'Personality'),
(531, 2280, 'skin_def', 'Man'),
(532, 2281, 'skin_def', 'Woman'),
(1216, 2282, 'skin_def', 'I am a'),
(1217, 2283, 'skin_def', 'Find a'),
(1218, 2284, 'skin_def', ''),
(536, 2285, 'skin_def', 'Men'),
(537, 2286, 'skin_def', 'Women'),
(1219, 2287, 'skin_def', 'Seeking'),
(1220, 2288, 'skin_def', 'Seeking'),
(1221, 2289, 'skin_def', ''),
(1135, 2293, 'skin_def', 'Country'),
(1136, 2294, 'skin_def', 'From'),
(1137, 2295, 'skin_def', ''),
(1265, 2296, 'skin_def', 'About me'),
(1266, 2297, 'skin_def', ''),
(1267, 2298, 'skin_def', ''),
(550, 2299, 'skin_def', 'African American (black)'),
(551, 2300, 'skin_def', 'Asian'),
(552, 2301, 'skin_def', 'Caucasian (white)'),
(553, 2302, 'skin_def', 'East Indian'),
(554, 2303, 'skin_def', 'Hispanic/Latino'),
(555, 2304, 'skin_def', 'Middle Eastern'),
(556, 2305, 'skin_def', 'Native American'),
(557, 2306, 'skin_def', 'Pacific Islander'),
(558, 2307, 'skin_def', 'Inter-racial'),
(1171, 2308, 'skin_def', 'My ethnicity is'),
(1172, 2309, 'skin_def', 'Having ethnicity'),
(1173, 2310, 'skin_def', ''),
(562, 2311, 'skin_def', '4''0" or less'),
(563, 2312, 'skin_def', '4''1" - 4''3"'),
(564, 2313, 'skin_def', '4''4" - 4''6"'),
(565, 2314, 'skin_def', '4''7" - 4''9"'),
(566, 2315, 'skin_def', '4''10" - 5''0"'),
(567, 2316, 'skin_def', '5''1" - 5''3"'),
(568, 2317, 'skin_def', '5''4" - 5''6"'),
(569, 2318, 'skin_def', '5''7" - 5''9"'),
(570, 2319, 'skin_def', '5''10" - 6''0"'),
(571, 2320, 'skin_def', '6''1" - 6''3"'),
(572, 2321, 'skin_def', '6''4" - 6''6"'),
(573, 2322, 'skin_def', '6''7" - 6''9"'),
(577, 2326, 'skin_def', '6''10" - 7''0"'),
(578, 2327, 'skin_def', '7''1" or more'),
(1249, 2323, 'skin_def', 'My height is'),
(1250, 2324, 'skin_def', 'Height'),
(1251, 2325, 'skin_def', ''),
(585, 2328, 'skin_def', 'Slim'),
(586, 2329, 'skin_def', 'Slender'),
(587, 2330, 'skin_def', 'Average'),
(588, 2331, 'skin_def', 'Athletic'),
(589, 2332, 'skin_def', 'Fit'),
(590, 2333, 'skin_def', 'Thick'),
(591, 2334, 'skin_def', 'A few extra pounds'),
(592, 2335, 'skin_def', 'Large'),
(593, 2336, 'skin_def', 'Voluptous'),
(1222, 2337, 'skin_def', 'My body type is'),
(1223, 2338, 'skin_def', 'Body'),
(1224, 2339, 'skin_def', ''),
(597, 2340, 'skin_def', 'Black'),
(598, 2341, 'skin_def', 'Blue'),
(599, 2342, 'skin_def', 'Brown'),
(600, 2343, 'skin_def', 'Gray'),
(601, 2344, 'skin_def', 'Green'),
(602, 2345, 'skin_def', 'Hazel'),
(1180, 2346, 'skin_def', 'My eyes are'),
(1181, 2347, 'skin_def', 'Eyes'),
(1182, 2348, 'skin_def', ''),
(606, 2349, 'skin_def', 'Auburn'),
(607, 2350, 'skin_def', 'Black'),
(608, 2351, 'skin_def', 'Blonde'),
(609, 2352, 'skin_def', 'Light Brown'),
(610, 2353, 'skin_def', 'Dark Brown'),
(611, 2354, 'skin_def', 'Red'),
(612, 2355, 'skin_def', 'White/Gray'),
(613, 2356, 'skin_def', 'Bald'),
(614, 2357, 'skin_def', 'A little gray'),
(1183, 2358, 'skin_def', 'My hair is'),
(1184, 2359, 'skin_def', 'Hair'),
(1185, 2360, 'skin_def', ''),
(618, 2361, 'skin_def', 'No'),
(619, 2362, 'skin_def', 'Socially'),
(620, 2363, 'skin_def', 'Daily'),
(1186, 2364, 'skin_def', 'I smoke'),
(1187, 2365, 'skin_def', 'Smoke'),
(1188, 2366, 'skin_def', ''),
(624, 2367, 'skin_def', 'No'),
(625, 2368, 'skin_def', 'Socially'),
(626, 2369, 'skin_def', 'Daily'),
(1189, 2370, 'skin_def', 'I drink'),
(1190, 2371, 'skin_def', 'Drink'),
(1191, 2372, 'skin_def', ''),
(630, 2373, 'skin_def', 'Some High School'),
(631, 2374, 'skin_def', 'High School Grad'),
(632, 2375, 'skin_def', 'Some College'),
(633, 2376, 'skin_def', 'College Grad'),
(634, 2377, 'skin_def', 'Post-Graduate'),
(1192, 2378, 'skin_def', 'My education is'),
(1193, 2379, 'skin_def', 'Education'),
(1194, 2380, 'skin_def', ''),
(638, 2381, 'skin_def', 'Single, never married'),
(639, 2382, 'skin_def', 'Divorced'),
(640, 2383, 'skin_def', 'Widowed'),
(641, 2384, 'skin_def', 'Separated'),
(1195, 2385, 'skin_def', 'My marital status is'),
(1196, 2386, 'skin_def', 'Marital status'),
(1197, 2387, 'skin_def', ''),
(645, 2388, 'skin_def', 'Alone'),
(646, 2389, 'skin_def', 'With kids'),
(647, 2390, 'skin_def', 'With parents'),
(648, 2391, 'skin_def', 'With pets'),
(649, 2392, 'skin_def', 'With roommate(s)'),
(650, 2393, 'skin_def', 'Family and friends visit often'),
(651, 2394, 'skin_def', 'There is a party every night'),
(1198, 2395, 'skin_def', 'I am currently living'),
(1199, 2396, 'skin_def', 'Living'),
(1200, 2397, 'skin_def', ''),
(1269, 2290, 'skin_def', 'Birthdate'),
(1270, 2291, 'skin_def', 'Age'),
(1271, 2292, 'skin_def', ''),
(658, 275, 'skin_def', 'Your account has been marked for deletion and it will be deleted in the next couple of hours. Thank you for using our site.'),
(659, 276, 'skin_def', 'Are you sure you want to cancel your account?'),
(1268, 280, 'skin_def', 'You''re already connected to %1$s'),
(1261, 2433, 'skin_def', ''),
(1260, 2432, 'skin_def', ''),
(1259, 2431, 'skin_def', ''),
(1258, 2430, 'skin_def', ''),
(1257, 2429, 'skin_def', ''),
(1256, 2428, 'skin_def', ''),
(1255, 2427, 'skin_def', ''),
(1254, 279, 'skin_def', 'Private Photos from %1$s'),
(1253, 278, 'skin_def', 'No photos found matching your search criteria. Please refine your search and try again.'),
(1252, 277, 'skin_def', 'You must be friends with <a class="content-link" href="%1$s" title="%2$s">%2$s</a> in order to view the private photos.'),
(1272, 2434, 'skin_def', 'Friendship Request Accepted'),
(1273, 2435, 'skin_def', '%1$s has accepted your Friendship Request! You are friends now.'),
(1274, 2436, 'skin_def', 'Random Members'),
(1275, 2437, 'skin_def', 'Random Photos');

CREATE TABLE `dsb_locales` (
  `locale_id` int(4) unsigned NOT NULL AUTO_INCREMENT,
  `locale_name` varchar(100) NOT NULL,
  `codes` varchar(50) NOT NULL,
  PRIMARY KEY (`locale_id`)
) ENGINE=MyISAM ;

INSERT INTO `dsb_locales` (`locale_id`, `locale_name`, `codes`) VALUES
(1, 'Arabic (Algeria)', 'ar_DZ,arabic'),
(2, 'Arabic (Saudi Arabia)', 'ar_SA,arabic'),
(3, 'Bulgarian (Bulgaria)', 'bg_BG,bulgarian'),
(4, 'Chinese, Simplified (China)', 'zh_CN,chinese'),
(5, 'Chinese, Traditional (Hong Kong)', 'zh_HK,chinese'),
(6, 'Chinese, Traditional (Taiwan)', 'zh_TW,chinese'),
(7, 'Czech (Czech Republic)', 'cs_CZ,czech'),
(8, 'Danish (Denmark)', 'da_DK,danish'),
(9, 'Dutch (Netherlands)', 'nl_NL,dutch'),
(10, 'English (United Kingdom)', 'en_GB,english'),
(11, 'English (United States)', 'en_US,english'),
(12, 'Finnish (Finland)', 'fi_FI,finnish'),
(13, 'French (Canada)', 'fr_CA,french'),
(14, 'French (France)', 'fr_FR,french'),
(15, 'German (Germany)', 'de_DE,german'),
(16, 'Greek (Greece)', 'el_GR,greek'),
(17, 'Hebrew (Israel)', 'iw_IL,hebrew'),
(18, 'Hungarian (Hungary)', 'hu_HU,hungarian'),
(19, 'Icelandic (Iceland)', 'is_IS,icelandic'),
(20, 'Italian (Italy)', 'it_IT,italian'),
(21, 'Japanese (Japan)', 'ja_JP,japanese'),
(22, 'Korean (Korea)', 'ko_KR,korean'),
(23, 'Norwegian (Norway)', 'no_NO,norwegian'),
(24, 'Polish (Poland)', 'pl_PL,polish'),
(25, 'Portuguese (Brazil)', 'pt_BR,portuguese'),
(26, 'Portuguese (Portugal)', 'pt_PT,portuguese'),
(27, 'Romanian (Romania)', 'ro_RO,romanian'),
(28, 'Russian (Russia)', 'ru_RU,russian'),
(29, 'Serbocroatian (Croatia)', 'hr_HR,croatian'),
(30, 'Slovak (Slovakia)', 'sk_SK,slovak'),
(31, 'Slovene (Slovenia)', 'sl_SI,sloven'),
(32, 'Spanish (Argentina)', 'es_AR,spanish'),
(33, 'Spanish (Bolivia)', 'es_BO,spanish'),
(34, 'Spanish (Chile)', 'es_CL,spanish'),
(35, 'Spanish (Colombia)', 'es_CO,spanish'),
(36, 'Spanish (Costa Rica)', 'es_CR,spanish'),
(37, 'Spanish (Ecuador)', 'es_EC,spanish'),
(38, 'Spanish (El Salvador)', 'es_SV,spanish'),
(39, 'Spanish (Guatemala)', 'es_GT,spanish'),
(40, 'Spanish (Mexico)', 'es_MX,spanish'),
(41, 'Spanish (Nicaragua)', 'es_NI,spanish'),
(42, 'Spanish (Panama)', 'es_PA,spanish'),
(43, 'Spanish (Paraguay)', 'es_PY,spanish'),
(44, 'Spanish (Peru)', 'es_PE,spanish'),
(45, 'Spanish (Puerto Rico)', 'es_PR,spanish'),
(46, 'Spanish (Spain)', 'es_ES,spanish'),
(47, 'Spanish (Uruguay)', 'es_UY,spanish'),
(48, 'Spanish (Venezuela)', 'es_VE,spanish'),
(49, 'Swedish (Sweden)', 'sv_SE,spanish'),
(50, 'Thai (Thailand)', 'th_TH,thai'),
(51, 'Turkish (Turkey)', 'tr_TR,turkish');

CREATE TABLE `dsb_loc_cities` (
  `city_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `city` varchar(200) NOT NULL,
  `latitude` double NOT NULL DEFAULT '0',
  `rad_latitude` double NOT NULL DEFAULT '0',
  `longitude` double NOT NULL DEFAULT '0',
  `rad_longitude` double NOT NULL DEFAULT '0',
  `fk_country_id` int(3) unsigned NOT NULL DEFAULT '0',
  `fk_state_id` int(10) unsigned NOT NULL DEFAULT '0',
  `feature_code` varchar(10) NOT NULL,
  `feature_class` char(1) NOT NULL,
  PRIMARY KEY (`city_id`),
  KEY `fk_country_id` (`fk_country_id`),
  KEY `sid_city` (`fk_state_id`,`city`)
) ENGINE=MyISAM ;

INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(92071, '107 West Colonia', 26.318000793457, 0.459335766388305, -98.2649993896484, -1.71504777881958, 218, 51, 'PPL', 'P'),
(92072, '11 North-Victoria Road-FM 493 Colonia', 26.2129993438721, 0.457503145373681, -98.0309982299805, -1.71096368812989, 218, 51, 'PPL', 'P'),
(92073, '13 1/2 North-FM 493 Colonia', 26.2490005493164, 0.458131484943371, -98.0400009155273, -1.71112081463421, 218, 51, 'PPL', 'P'),
(92074, '13 North-2 West Colonia', 26.2439994812012, 0.458044199838644, -97.9390029907227, -1.70935806830868, 218, 51, 'PPL', 'P'),
(92075, '15 1/2 North-FM 491 Colonia', 26.2810001373291, 0.458689983113475, -97.9179992675781, -1.70899148418463, 218, 51, 'PPL', 'P'),
(92076, '17 1/2 North-6 West Colonia', 26.3090000152588, 0.459178673173504, -98.0199966430664, -1.7107716742153, 218, 51, 'PPL', 'P'),
(92077, '1st, 2nd, and 3rd Street Area Colonia', 28.4330005645752, 0.496249476073244, -97.7109985351563, -1.70537863984983, 218, 51, 'PPL', 'P'),
(92078, '21 Subdivision Colonia', 25.8899993896484, 0.451865732688688, -97.4280014038086, -1.70043940813412, 218, 51, 'PPL', 'P'),
(202810, '214 North Temple Condominium', 40.7719383239746, 0.711604566173415, -111.900283813477, -1.95302838646128, 218, 52, 'PPL', 'P'),
(92079, '281 Estates Colonia', 26.3780002593994, 0.460382954618438, -98.1520004272461, -1.71307557487433, 218, 51, 'PPL', 'P'),
(92080, '665 Site Colonia', 27.7299995422363, 0.483979793588544, -98.0329971313477, -1.71099857554017, 218, 51, 'PPL', 'P'),
(92081, '9 North-East FM 493 Colonia', 26.1149997711182, 0.455792730163578, -98.0660018920898, -1.71157461728396, 218, 51, 'PPL', 'P'),
(195829, 'A and B Trailer Court Number One', 48.5525016784668, 0.847401014369319, -109.680557250977, -1.91428684945168, 218, 31, 'PPL', 'P'),
(195830, 'A and B Trailer Court Number Two', 48.5499992370605, 0.847357338527442, -109.683326721191, -1.91433518582547, 218, 31, 'PPL', 'P'),
(92085, 'A and E Ramirez Colonia', 26.0949993133545, 0.455443656323695, -97.9509963989258, -1.70956739277036, 218, 51, 'PPL', 'P'),
(92086, 'A and E Ramirez Colonia Number 2', 26.0990009307861, 0.455513497723283, -97.9530029296875, -1.7096024133387, 218, 51, 'PPL', 'P'),
(192981, 'A and F Trailer Court', 33.2958297729492, 0.58112185672152, -111.841110229492, -1.95199561259055, 218, 5, 'PPL', 'P'),
(192980, 'A and F Trailer Park', 33.4944381713867, 0.584588227196367, -112.110282897949, -1.9566935619115, 218, 5, 'PPL', 'P'),
(99269, 'A Country Place', 38.9550018310547, 0.679893042072324, -77.2763900756836, -1.34872744087615, 218, 53, 'PPL', 'P'),
(144710, 'A Country Place', 40.0883293151855, 0.699673338173751, -74.2291717529297, -1.29554344811699, 218, 37, 'PPL', 'P'),
(92082, 'A F Pierce Colonia', 26.9039993286133, 0.469563370238646, -99.2740020751953, -1.73265819784384, 218, 51, 'PPL', 'P'),
(92083, 'A Sherton', 28.4416694641113, 0.496400776912674, -99.7600021362305, -1.7411404990738, 218, 51, 'PPL', 'P'),
(92084, 'A T Martinez Colonia', 26.3899993896484, 0.460592378948659, -98.8430023193359, -1.7251358330288, 218, 51, 'PPL', 'P'),
(192982, 'A-1 Trailer Park', 33.4486083984375, 0.583788346762962, -112.008331298828, -1.95491417082917, 218, 5, 'PPL', 'P'),
(7014, 'Aa Junction', 36.079719543457, 0.629709899229471, -90.9397201538086, -1.5871975375262, 218, 4, 'PPL', 'P'),
(195831, 'AA Westside Mobile Estates', 46.0022201538086, 0.802890204911252, -112.54167175293, -1.96422271778732, 218, 31, 'PPL', 'P'),
(18707, 'Aaron', 32.5680618286133, 0.568419909902387, -81.9925003051758, -1.43103909226777, 218, 13, 'PPL', 'P'),
(29057, 'Aaron', 38.8830604553223, 0.678637428197379, -85.1258316040039, -1.48572603998811, 218, 19, 'PPL', 'P'),
(34495, 'Aaron', 36.8125, 0.642499330890413, -85.1808319091797, -1.48668597640303, 218, 21, 'PPL', 'P'),
(53114, 'Aaron', 38.4230613708496, 0.670608929617172, -94.1536102294922, -1.64329050114405, 218, 29, 'PPL', 'P'),
(107898, 'Aarons', 38.4930610656738, 0.671830654767246, -81.5344390869141, -1.42304441583341, 218, 58, 'PPL', 'P'),
(62422, 'Aarons Corner', 36.5380592346191, 0.637709435932823, -80.2961120605469, -1.40143153200687, 218, 33, 'PPL', 'P'),
(99270, 'Aarons Creek', 36.6611099243164, 0.63985707561489, -78.7222213745117, -1.37396195746909, 218, 53, 'PPL', 'P'),
(158517, 'Aaronsburg', 40.8997192382813, 0.713834763849275, -77.45361328125, -1.35182056932422, 218, 45, 'PPL', 'P'),
(154000, 'Aaronsburg (historical)', 40.3983306884766, 0.705083882823384, -82.6952819824219, -1.44330494645841, 218, 41, 'PPL', 'P'),
(53115, 'Abadyl', 37.038330078125, 0.64644080930373, -92.9469375610352, -1.62223009008565, 218, 29, 'PPL', 'P'),
(154001, 'Abanaka', 40.7599983215332, 0.711396173818117, -84.6983337402344, -1.47826479472009, 218, 41, 'PPL', 'P'),
(112666, 'Abanda', 33.100830078125, 0.577718470006453, -85.5297164916992, -1.49277516107744, 218, 2, 'PPL', 'P'),
(186306, 'Abarr', 39.8505592346191, 0.695523467405135, -102.706672668457, -1.79256960183265, 218, 7, 'PPL', 'P'),
(53116, 'Abattis (historical)', 38.8169403076172, 0.67748341391802, -91.3916702270508, -1.59508555435891, 218, 29, 'PPL', 'P'),
(18711, 'Abba', 31.7566699981689, 0.55425845093735, -83.3705596923828, -1.45509076586255, 218, 13, 'PPL', 'P'),
(179597, 'Abbato (historical)', 37.0538902282715, 0.646712385155891, -120.826667785645, -2.10882317707286, 218, 6, 'PPL', 'P'),
(18708, 'Abbeville', 31.9919395446777, 0.558364679153602, -83.3069381713867, -1.45398036084604, 218, 13, 'PPL', 'P'),
(39022, 'Abbeville', 29.9744396209717, 0.523152662826197, -92.1341705322266, -1.60804462938129, 218, 22, 'PPL', 'P'),
(58400, 'Abbeville', 34.503059387207, 0.6021919883179, -89.503059387207, -1.56212307691478, 218, 30, 'PPL', 'P'),
(79480, 'Abbeville', 34.1780586242676, 0.596519654933113, -82.3791732788086, -1.43778780878614, 218, 48, 'PPL', 'P'),
(112667, 'Abbeville', 31.5716705322266, 0.551029601142224, -85.2505569458008, -1.48790290786314, 218, 2, 'PPL', 'P'),
(194487, 'Abbey (historical)', 42.6316719055176, 0.744063040381247, -114.755279541016, -2.00285746203721, 218, 17, 'PPL', 'P'),
(154002, 'Abbeyville', 41.1972198486328, 0.719027129026602, -81.8869400024414, -1.42919671742566, 218, 41, 'PPL', 'P'),
(186307, 'Abbeyville', 38.7775001525879, 0.676795053355262, -106.491668701172, -1.85863024477844, 218, 7, 'PPL', 'P'),
(39023, 'Abbie Joe (historical)', 30.4916706085205, 0.532180046552266, -93.3030624389648, -1.62844564175379, 218, 22, 'PPL', 'P'),
(26325, 'Abbot', 37.5572204589844, 0.655497154906653, -88.6988906860352, -1.54808768533785, 218, 18, 'PPL', 'P'),
(112668, 'Abbot Springs', 33.3608283996582, 0.582256296766866, -86.4816665649414, -1.50938982417012, 218, 2, 'PPL', 'P'),
(126726, 'Abbot Village', 45.1863899230957, 0.788651281248007, -69.4524993896484, -1.21217478808872, 218, 26, 'PPL', 'P'),
(172827, 'Abbotsford', 44.9463882446289, 0.784462461748449, -90.3158264160156, -1.57630853761914, 218, 57, 'PPL', 'P'),
(158519, 'Abbotsford Homes', 40.0133285522461, 0.69836432791895, -75.1750030517578, -1.31205131844996, 218, 45, 'PPL', 'P'),
(7015, 'Abbott', 35.0733299255371, 0.61214508683888, -94.1936111450195, -1.64398864882382, 218, 4, 'PPL', 'P'),
(58402, 'Abbott', 33.6800003051758, 0.587826897398012, -88.7744369506836, -1.54940621639354, 218, 30, 'PPL', 'P'),
(92087, 'Abbott', 31.8847198486328, 0.556493342434631, -97.0730590820313, -1.69424449596443, 218, 51, 'PPL', 'P'),
(99271, 'Abbott', 37.4291687011719, 0.653262230119859, -80.1397171020508, -1.39870192504759, 218, 53, 'PPL', 'P'),
(107899, 'Abbott', 38.9216690063477, 0.679311274532196, -80.3216705322266, -1.40187761148946, 218, 58, 'PPL', 'P'),
(114336, 'Abbott', 42.485279083252, 0.741508003631425, -93.0661087036133, -1.624310018897, 218, 16, 'PPL', 'P'),
(141123, 'Abbott', 40.9747200012207, 0.715143774104076, -98.4811096191406, -1.71881961387146, 218, 35, 'PPL', 'P'),
(158518, 'Abbott', 41.582218170166, 0.725746617352009, -77.7847213745117, -1.35759949573164, 218, 45, 'PPL', 'P'),
(179598, 'Abbott', 39.0205612182617, 0.681037269234677, -121.624443054199, -2.12274698220012, 218, 6, 'PPL', 'P'),
(187974, 'Abbott', 36.3055610656738, 0.63365157737987, -104.258331298828, -1.81965115379961, 218, 38, 'PPL', 'P'),
(114337, 'Abbott Crossing (historical)', 42.4930610656738, 0.741643824847019, -93.070556640625, -1.62438765004278, 218, 16, 'PPL', 'P'),
(195834, 'Abbott Lake (historical)', 48.4097213745117, 0.844909027958304, -112.228332519531, -1.95875391648884, 218, 31, 'PPL', 'P'),
(169247, 'Abbott Run', 41.9552803039551, 0.732257779901143, -71.3894424438477, -1.24598082180813, 218, 47, 'PPL', 'P'),
(146697, 'Abbotts', 42.2569389343262, 0.737522716218176, -78.3188934326172, -1.36692255691773, 218, 40, 'PPL', 'P'),
(13258, 'Abbotts Mill', 38.8863906860352, 0.67869555168817, -75.476936340332, -1.31732104845695, 218, 10, 'PPL', 'P'),
(126728, 'Abbotts Mill', 44.475830078125, 0.776249672420808, -70.6324996948242, -1.23276967858857, 218, 26, 'PPL', 'P'),
(62426, 'Abbottsburg', 34.5169410705566, 0.60243426939807, -78.7252807617188, -1.37401535384894, 218, 33, 'PPL', 'P'),
(18710, 'Abbottsford', 33.0472183227539, 0.576782768357454, -85.1797180175781, -1.48666653532708, 218, 13, 'PPL', 'P'),
(129414, 'Abbottsford', 43.0200004577637, 0.750840652197444, -82.6333312988281, -1.44222370305583, 218, 27, 'PPL', 'P'),
(77757, 'Abbottstown', 39.8863906860352, 0.696148844208113, -76.9850006103516, -1.34364173530048, 218, 45, 'PPL', 'P'),
(154003, 'Abbottsville', 40.0374984741211, 0.698786172635619, -84.5783309936523, -1.4761703516808, 218, 41, 'PPL', 'P'),
(99272, 'Abbs Valley', 37.2438888549805, 0.65002848676623, -81.4524993896484, -1.42161429832804, 218, 53, 'PPL', 'P'),
(107900, 'Abbs Valley (historical)', 37.3036117553711, 0.651070848016887, -81.3030624389648, -1.41900613151447, 218, 58, 'PPL', 'P'),
(39024, 'Abby Plantation', 29.8116703033447, 0.520311802312382, -90.8408279418945, -1.58547154282372, 218, 22, 'PPL', 'P'),
(31591, 'Abbyville', 37.9708290100098, 0.662715985936449, -98.2038879394531, -1.71398118280301, 218, 20, 'PPL', 'P'),
(7016, 'Abco', 34.3488883972168, 0.599501196931511, -92.8291702270508, -1.62017466235633, 218, 4, 'PPL', 'P'),
(141124, 'Abdal (historical)', 40.1222190856934, 0.700264826251858, -98.1230621337891, -1.71257050637359, 218, 35, 'PPL', 'P'),
(58401, 'Abdan', 32.6138916015625, 0.569219790335792, -89.5666732788086, -1.56323334877324, 218, 30, 'PPL', 'P'),
(158523, 'Abdera', 41.0305595397949, 0.716118357904991, -77.5611114501953, -1.35369676631218, 218, 45, 'PPL', 'P'),
(154004, 'Abe', 40.165828704834, 0.701025957691403, -84.3744430541992, -1.47261183583224, 218, 41, 'PPL', 'P'),
(195832, 'Abe (historical)', 45.0433311462402, 0.786154434568004, -111.683326721191, -1.94924177086535, 218, 31, 'PPL', 'P'),
(14933, 'Abe Springs', 30.3655605316162, 0.529979010490343, -85.1474990844727, -1.48610420886291, 218, 12, 'PPL', 'P'),
(187975, 'Abe Yarbrough', 31.6519393920898, 0.55243055703366, -108.845001220703, -1.89970364563852, 218, 38, 'PPL', 'P'),
(62427, 'Abecrumby (historical)', 35.1438903808594, 0.61337659910596, -80.1402816772461, -1.39871177874363, 218, 33, 'PPL', 'P'),
(112671, 'Abel', 33.5486106872559, 0.585533715962372, -85.7125015258789, -1.49596536174725, 218, 2, 'PPL', 'P'),
(141125, 'Abel', 41.0741691589355, 0.716879489344535, -96.3550033569336, -1.68171205934868, 218, 35, 'PPL', 'P'),
(7019, 'Abeles (historical)', 34.4327812194824, 0.600965402898836, -91.6152801513672, -1.59898828377837, 218, 4, 'PPL', 'P'),
(44260, 'Abell', 38.2541694641113, 0.667661209764618, -76.7438888549805, -1.33943354130399, 218, 25, 'PPL', 'P'),
(191028, 'Abell', 35.3933296203613, 0.61773013511894, -101.45832824707, -1.77078188148054, 218, 51, 'PPL', 'P'),
(99273, 'Abell (historical)', 37.0713882446289, 0.647017783153895, -78.8511123657227, -1.37621152964188, 218, 53, 'PPL', 'P'),
(191029, 'Abell City', 31.25, 0.545415391248228, -102.658332824707, -1.79172591239931, 218, 51, 'PPL', 'P'),
(146698, 'Abell Corners', 42.8983306884766, 0.748717114123242, -75.82861328125, -1.32345896897931, 218, 40, 'PPL', 'P'),
(172829, 'Abells Corners', 42.7261085510254, 0.745711270779897, -88.5425033569336, -1.54535821153662, 218, 57, 'PPL', 'P'),
(39025, 'Aben', 30.107780456543, 0.525479899434276, -90.9427795410156, -1.58725093390606, 218, 22, 'PPL', 'P'),
(18719, 'Abercorn Heights', 32.0325012207031, 0.559072613950372, -81.1069412231445, -1.41558317056539, 218, 13, 'PPL', 'P'),
(92089, 'Abercrombie', 30.3386096954346, 0.529508629662807, -97.7252807617188, -1.70562791172786, 218, 51, 'PPL', 'P'),
(112670, 'Abercrombie', 32.8486099243164, 0.573316397882607, -87.1650009155273, -1.52131625847982, 218, 2, 'PPL', 'P'),
(139553, 'Abercrombie', 46.4477806091309, 0.810666701873311, -96.7300033569336, -1.68825704404366, 218, 34, 'PPL', 'P'),
(7017, 'Aberdeen', 34.603328704834, 0.603942018049218, -91.341667175293, -1.59421283646969, 218, 4, 'PPL', 'P'),
(14934, 'Aberdeen', 26.5502796173096, 0.463389796647192, -80.1488876342773, -1.39886198102911, 218, 12, 'PPL', 'P'),
(18712, 'Aberdeen', 33.4088897705078, 0.583095125931214, -84.601936340332, -1.47658234270144, 218, 13, 'PPL', 'P'),
(34496, 'Aberdeen', 37.2538909912109, 0.650203056975685, -86.6816711425781, -1.51288056256894, 218, 21, 'PPL', 'P'),
(44261, 'Aberdeen', 39.5094413757324, 0.689569837630209, -76.164436340332, -1.32932018706441, 218, 25, 'PPL', 'P'),
(58403, 'Aberdeen', 33.8250007629395, 0.590357632802887, -88.5436096191406, -1.54537751945453, 218, 30, 'PPL', 'P'),
(62428, 'Aberdeen', 35.1313896179199, 0.613158419633655, -79.4297180175781, -1.3863101033374, 218, 33, 'PPL', 'P'),
(71620, 'Aberdeen', 38.6555595397949, 0.674666788170125, -83.7611083984375, -1.46190712667261, 218, 41, 'PPL', 'P'),
(107901, 'Aberdeen', 39.0583305358887, 0.681696468183499, -80.3161087036133, -1.40178053926773, 218, 58, 'PPL', 'P'),
(122102, 'Aberdeen', 41.4388885498047, 0.72324504356107, -87.1113891601563, -1.52038055683082, 218, 19, 'PPL', 'P'),
(124073, 'Aberdeen', 42.3444404602051, 0.739049905945282, -71.1500015258789, -1.24180178942558, 218, 23, 'PPL', 'P'),
(158522, 'Aberdeen', 40.1766700744629, 0.701215175286853, -76.6236114501953, -1.33733430457474, 218, 45, 'PPL', 'P'),
(169688, 'Aberdeen', 45.4647216796875, 0.793509086813394, -98.4861068725586, -1.71890683239716, 218, 49, 'PPL', 'P'),
(179599, 'Aberdeen', 36.9780616760254, 0.645388927252176, -118.252502441406, -2.06389551632517, 218, 6, 'PPL', 'P'),
(191030, 'Aberdeen', 35.0377807617188, 0.611524636883919, -100.148887634277, -1.74792783142797, 218, 51, 'PPL', 'P'),
(194488, 'Aberdeen', 42.9441719055176, 0.749517194293729, -112.837501525879, -1.96938592135071, 218, 17, 'PPL', 'P'),
(195833, 'Aberdeen', 45.0544395446777, 0.786348312695361, -107.356391906738, -1.87372251183398, 218, 31, 'PPL', 'P'),
(206636, 'Aberdeen', 46.9755592346191, 0.819878176609731, -123.814437866211, -2.16096960227132, 218, 56, 'PPL', 'P'),
(7018, 'Aberdeen (historical)', 35.3611106872559, 0.61716780865477, -91.0047225952148, -1.58833204415058, 218, 4, 'PPL', 'P'),
(18713, 'Aberdeen Estates', 33.6624984741211, 0.58752143282098, -84.8133316040039, -1.48027188607563, 218, 13, 'PPL', 'P'),
(99274, 'Aberdeen Gardens', 37.0322189331055, 0.646334149702072, -76.3988876342773, -1.33341213407932, 218, 53, 'PPL', 'P'),
(206637, 'Aberdeen Gardens', 47.0627784729004, 0.821400439488821, -123.778327941895, -2.16033936519936, 218, 56, 'PPL', 'P'),
(58404, 'Aberdeen Junction', 33.0325012207031, 0.576525906470316, -89.8775024414063, -1.56865834107178, 218, 30, 'PPL', 'P'),
(194489, 'Aberdeen Junction', 43.2230606079102, 0.754384720397094, -112.470001220703, -1.96297183102331, 218, 17, 'PPL', 'P'),
(206638, 'Aberdeen Junction', 46.978889465332, 0.819936300100522, -123.761672973633, -2.16004868116637, 218, 56, 'PPL', 'P'),
(84572, 'Aberdeen Park', 35.9283294677734, 0.627067643953948, -86.5199966430664, -1.51005881023595, 218, 50, 'PPL', 'P'),
(112593, 'Aberfoil', 32.0702781677246, 0.559731946057249, -85.6877822875977, -1.49553392965066, 218, 2, 'PPL', 'P'),
(92090, 'Aberfoyle', 33.3050003051758, 0.581281912703034, -96.0250015258789, -1.67595244085917, 218, 51, 'PPL', 'P'),
(112673, 'Abernant', 33.2902793884277, 0.581024984236868, -87.1980590820313, -1.52189323232999, 218, 2, 'PPL', 'P'),
(112672, 'Abernathy', 33.6505584716797, 0.587313040465682, -85.4075012207031, -1.49064210220235, 218, 2, 'PPL', 'P'),
(191031, 'Abernathy', 33.832218170166, 0.590483600322448, -101.842498779297, -1.77748692215704, 218, 51, 'PPL', 'P'),
(58405, 'Abernathy (historical)', 32.3916702270508, 0.565341295682255, -89.8472213745117, -1.56812983675345, 218, 30, 'PPL', 'P'),
(84571, 'Abernathy (historical)', 35.8061103820801, 0.624934518499822, -89.4722213745117, -1.56158485205848, 218, 50, 'PPL', 'P'),
(112674, 'Abernathy (historical)', 33.7966690063477, 0.589863150367487, -85.565559387207, -1.4934007376175, 218, 2, 'PPL', 'P'),
(18714, 'Abernathys Mill', 33.8641700744629, 0.591041266254711, -85.209716796875, -1.48719011279739, 218, 13, 'PPL', 'P'),
(99275, 'Abert', 37.4980583190918, 0.654464580773002, -79.225830078125, -1.38275158748884, 218, 53, 'PPL', 'P'),
(144712, 'Abertown', 41.2508316040039, 0.719962830675602, -74.7850036621094, -1.30524454501983, 218, 37, 'PPL', 'P'),
(53118, 'Abesville', 36.8397216796875, 0.642974438828883, -93.3705596923828, -1.62962369106198, 218, 29, 'PPL', 'P'),
(186308, 'Abeyta', 37.079719543457, 0.647163191749414, -104.185829162598, -1.81838575280766, 218, 7, 'PPL', 'P'),
(187976, 'Abeytas', 34.4674987792969, 0.601571338625857, -106.810829162598, -1.86420064567251, 218, 38, 'PPL', 'P'),
(18715, 'Abide Awhile', 33.5805587768555, 0.586091315315608, -83.9638900756836, -1.46544633460327, 218, 13, 'PPL', 'P'),
(141126, 'Abie', 41.334171295166, 0.721417382683976, -96.9486083984375, -1.69207242177936, 218, 35, 'PPL', 'P'),
(84573, 'Abiff', 35.9761085510254, 0.62790154627028, -87.317497253418, -1.52397782167325, 218, 50, 'PPL', 'P'),
(34497, 'Abigail', 38.5766716003418, 0.673289933886554, -83.9822235107422, -1.46576631340824, 218, 21, 'PPL', 'P'),
(112675, 'Abihka (historical)', 33.2999992370605, 0.581194627598306, -86.1611099243164, -1.50379505535208, 218, 2, 'PPL', 'P'),
(18716, 'Abilene', 33.649169921875, 0.587288805699762, -85.0497207641602, -1.48439765523638, 218, 13, 'PPL', 'P'),
(31592, 'Abilene', 38.9172210693359, 0.679233643386421, -97.2136077880859, -1.6966975336445, 218, 20, 'PPL', 'P'),
(92091, 'Abilene', 32.4486083984375, 0.566335054243018, -99.732780456543, -1.74066539113533, 218, 51, 'PPL', 'P'),
(99276, 'Abilene', 37.1413917541504, 0.648239574882997, -78.5444412231445, -1.37085910848303, 218, 53, 'PPL', 'P'),
(179600, 'Abilene', 36.1455612182617, 0.63085905323984, -119.052780151367, -2.07786299729431, 218, 6, 'PPL', 'P'),
(44263, 'Abingdon', 39.4622192382813, 0.688745655851857, -76.2794418334961, -1.33132741157801, 218, 25, 'PPL', 'P'),
(62429, 'Abingdon', 35.9111099243164, 0.626767106224933, -81.5961074829102, -1.42412073238797, 218, 33, 'PPL', 'P'),
(79481, 'Abingdon', 34.9922218322754, 0.610729483561449, -81.4997177124023, -1.42243841352736, 218, 48, 'PPL', 'P'),
(99277, 'Abingdon', 36.7097206115723, 0.640705492159162, -81.9775009155273, -1.43077730353262, 218, 53, 'PPL', 'P'),
(114338, 'Abingdon', 41.082218170166, 0.717019971092037, -92.1388931274414, -1.60812705421703, 218, 16, 'PPL', 'P'),
(118561, 'Abingdon', 40.8044395446777, 0.712171819485602, -90.4016723632813, -1.57780683204842, 218, 18, 'PPL', 'P'),
(44264, 'Abingdon Reserve', 39.4658317565918, 0.688808706190664, -76.283332824707, -1.3313953221858, 218, 25, 'PPL', 'P'),
(29060, 'Abington', 39.7330589294434, 0.69347270020772, -84.9630584716797, -1.48288511289527, 218, 19, 'PPL', 'P'),
(39026, 'Abington', 32.1113891601563, 0.560449468233943, -93.4786071777344, -1.63150947542987, 218, 22, 'PPL', 'P'),
(124074, 'Abington', 42.1047210693359, 0.73486601329374, -70.9458312988281, -1.238238346729, 218, 23, 'PPL', 'P'),
(158524, 'Abington', 40.1205596923828, 0.700235864375003, -75.1183319091797, -1.3110622204211, 218, 45, 'PPL', 'P'),
(177429, 'Abington', 41.8605613708496, 0.730604622654477, -72.0072174072266, -1.25676302895548, 218, 8, 'PPL', 'P'),
(191032, 'Abington', 34.5444412231445, 0.602914237605529, -100.206939697266, -1.7489410310647, 218, 51, 'PPL', 'P'),
(18717, 'Abington Green', 34.0519409179688, 0.594318485713135, -84.5833282470703, -1.4762575702065, 218, 13, 'PPL', 'P'),
(44265, 'Abington Shores', 38.5852813720703, 0.673440202751062, -76.6680603027344, -1.33811008340028, 218, 25, 'PPL', 'P'),
(187977, 'Abiquiu', 36.207218170166, 0.631935170057313, -106.318061828613, -1.8556002332482, 218, 38, 'PPL', 'P'),
(39037, 'Abita Springs', 30.4783306121826, 0.531947219693966, -90.0374984741211, -1.57145079863278, 218, 22, 'PPL', 'P'),
(186309, 'Able', 38.0605583190918, 0.66428205781547, -102.869171142578, -1.79540573523553, 218, 7, 'PPL', 'P'),
(92092, 'Ables Springs', 32.8147087097168, 0.572724710067418, -96.1208724975586, -1.67762570497206, 218, 51, 'PPL', 'P'),
(70449, 'Ablett Village', 39.9486083984375, 0.697234748142593, -75.102783203125, -1.31079084430602, 218, 37, 'PPL', 'P'),
(62430, 'Abner', 35.4980583190918, 0.619557995733116, -79.9080581665039, -1.39465871388064, 218, 33, 'PPL', 'P'),
(92093, 'Abner', 32.6277809143066, 0.569462204574017, -96.1913909912109, -1.67885648486984, 218, 51, 'PPL', 'P'),
(7020, 'Abner (historical)', 34.1833305358887, 0.596611667148775, -93.710563659668, -1.63555787976095, 218, 4, 'PPL', 'P'),
(58406, 'Abney', 34.2133293151855, 0.597135244619085, -88.4869384765625, -1.54438842142567, 218, 30, 'PPL', 'P'),
(107902, 'Abney', 37.6883316040039, 0.657785476073304, -81.2041702270508, -1.41728013681199, 218, 58, 'PPL', 'P'),
(79482, 'Abney Crossroads', 34.5086097717285, 0.602288860802551, -80.5141677856445, -1.40523732236265, 218, 48, 'PPL', 'P'),
(644, 'Abo', 37.6977806091309, 0.657950392323807, -92.4649963378906, -1.61381862894069, 218, 29, 'PPL', 'P'),
(187978, 'Abo', 34.4558296203613, 0.601367673381493, -106.332496643066, -1.85585216828733, 218, 38, 'PPL', 'P'),
(122103, 'Aboite', 41.0008316040039, 0.715599507545616, -85.3180618286133, -1.4890810903294, 218, 19, 'PPL', 'P'),
(62431, 'Abotts Creek (historical)', 36.0047187805176, 0.628400888974669, -80.084716796875, -1.39774198863268, 218, 33, 'PPL', 'P'),
(192983, 'Abra', 34.9019393920898, 0.609153757723476, -112.446113586426, -1.96255491315466, 218, 5, 'PPL', 'P'),
(107903, 'Abraham', 37.7905616760254, 0.65956972742463, -80.9552764892578, -1.4129361215999, 218, 58, 'PPL', 'P'),
(192462, 'Abraham', 39.396671295166, 0.687601628426586, -112.717216491699, -1.9672865514634, 218, 52, 'PPL', 'P'),
(158527, 'Abrahams', 40.1127815246582, 0.700100109738437, -75.3775024414063, -1.3155855995326, 218, 45, 'PPL', 'P'),
(158528, 'Abrahamsville', 41.7641716003418, 0.728922303793874, -75.123893737793, -1.31115929264284, 218, 45, 'PPL', 'P'),
(92094, 'Abram', 26.1994400024414, 0.457266490221314, -98.4108276367188, -1.71759296187337, 218, 51, 'PPL', 'P'),
(92095, 'Abram North Colonia', 26.2870006561279, 0.458794711923342, -98.3860015869141, -1.71715966556402, 218, 51, 'PPL', 'P'),
(172830, 'Abrams', 44.7791709899902, 0.781543970088858, -88.0597229003906, -1.53693210300567, 218, 57, 'PPL', 'P'),
(193334, 'Abrams Lake Mobile Estates', 41.3380584716797, 0.721485226712746, -122.35417175293, -2.13548315063926, 218, 6, 'PPL', 'P'),
(146699, 'Abrams Landing', 40.9925003051758, 0.715454098950098, -72.1061096191406, -1.25848902365796, 218, 40, 'PPL', 'P'),
(18720, 'Absalom (historical)', 34.2733306884766, 0.598182466138731, -83.915283203125, -1.46459798463802, 218, 13, 'PPL', 'P'),
(139556, 'Absaraka', 46.9780616760254, 0.819921852451609, -97.394172668457, -1.69984898532045, 218, 34, 'PPL', 'P'),
(195835, 'Absarokee', 45.5205612182617, 0.794483670614308, -109.442222595215, -1.91012712498703, 218, 31, 'PPL', 'P'),
(70450, 'Absecon', 39.4283294677734, 0.68815416777375, -74.4961090087891, -1.30020238212798, 218, 37, 'PPL', 'P'),
(70451, 'Absecon Highlands', 39.4466705322266, 0.688474279736777, -74.4744415283203, -1.29982421325319, 218, 37, 'PPL', 'P'),
(34498, 'Absher', 37.1686096191406, 0.64871461624244, -85.2591705322266, -1.48805324330668, 218, 21, 'PPL', 'P'),
(195836, 'Absher (historical)', 46.5583305358887, 0.812596162083073, -107.983329772949, -1.88466464180478, 218, 31, 'PPL', 'P'),
(62433, 'Abshers', 36.3686103820801, 0.63475199554229, -81.1111068725586, -1.41565587486315, 218, 33, 'PPL', 'P'),
(92096, 'Abshier Settlement', 29.9152793884277, 0.52212012198206, -94.6236114501953, -1.65149356993371, 218, 51, 'PPL', 'P'),
(194490, 'Abstein Place', 44.9708290100098, 0.784889033576052, -115.485832214355, -2.01560801154624, 218, 17, 'PPL', 'P'),
(187979, 'Abuelo', 35.9449996948242, 0.62735859430304, -105.360282897949, -1.83888383740189, 218, 38, 'PPL', 'P'),
(29061, 'Abydel', 38.5705604553223, 0.673183274284897, -86.5611114501953, -1.51077639899167, 218, 19, 'PPL', 'P'),
(92097, 'Acacia Colonia', 26.2509994506836, 0.458166372353652, -98.1880035400391, -1.71370394773353, 218, 51, 'PPL', 'P'),
(154006, 'Academia', 40.4136085510254, 0.705350531827528, -82.4683303833008, -1.43934389381108, 218, 41, 'PPL', 'P'),
(158529, 'Academia', 40.4963912963867, 0.706795363297923, -77.4761123657227, -1.35221325242695, 218, 45, 'PPL', 'P'),
(122104, 'Academie', 41.1708297729492, 0.718566535316073, -85.1458282470703, -1.48607504724897, 218, 19, 'PPL', 'P'),
(77759, 'Academy', 39.9055595397949, 0.696483403820055, -75.2624969482422, -1.31357837501901, 218, 45, 'PPL', 'P'),
(92098, 'Academy', 30.9808292388916, 0.540717475216787, -97.3413925170898, -1.69892779789939, 218, 51, 'PPL', 'P'),
(169691, 'Academy', 43.4563903808594, 0.758457093177989, -99.0794372558594, -1.72926240113788, 218, 49, 'PPL', 'P'),
(7021, 'Academy (historical)', 33.8005599975586, 0.589931060975284, -93.7333297729492, -1.63595522339559, 218, 4, 'PPL', 'P'),
(99279, 'Academy (historical)', 37.1272201538086, 0.647992233796756, -77.3125, -1.34935767794812, 218, 53, 'PPL', 'P'),
(18721, 'Academy Acres', 30.8955593109131, 0.539229234220624, -83.2491683959961, -1.45297208805734, 218, 13, 'PPL', 'P'),
(44267, 'Academy Acres', 39.4594383239746, 0.68869711974099, -77.0344390869141, -1.34450459949366, 218, 25, 'PPL', 'P'),
(79485, 'Academy Estates', 32.4327812194824, 0.56605881785895, -80.6352767944336, -1.40735107331985, 218, 48, 'PPL', 'P'),
(158530, 'Academy Garden', 40.0616683959961, 0.699208017352287, -74.9966735839844, -1.30893888208398, 218, 45, 'PPL', 'P'),
(44268, 'Academy Heights', 39.2819404602051, 0.685599197602955, -76.7230606079102, -1.33907001981519, 218, 25, 'PPL', 'P'),
(44269, 'Academy Hill', 38.6597213745117, 0.674739425888857, -76.6619415283203, -1.33800329064056, 218, 25, 'PPL', 'P'),
(44270, 'Academy Hills', 39.6566696166992, 0.692139455186999, -75.8555603027344, -1.32392928322782, 218, 25, 'PPL', 'P'),
(44271, 'Academy Junction', 39.0894393920898, 0.682239420150738, -76.6986083984375, -1.33864324825051, 218, 25, 'PPL', 'P'),
(44272, 'Academy Lane', 39.4355583190918, 0.688280335030392, -76.7866668701172, -1.34018015851559, 218, 25, 'PPL', 'P'),
(99281, 'Academy Park', 36.8055610656738, 0.642378223639841, -76.3511123657227, -1.33257829834202, 218, 53, 'PPL', 'P'),
(112685, 'Academy Park', 33.2000007629395, 0.579449324977923, -87.1566696166992, -1.52117084988431, 218, 2, 'PPL', 'P'),
(158531, 'Academyville', 40.0105590820313, 0.698315991545165, -75.2430572509766, -1.31323908829613, 218, 45, 'PPL', 'P'),
(39029, 'Acadia', 29.7686100006104, 0.519560258252762, -90.8013916015625, -1.58478324883999, 218, 22, 'PPL', 'P'),
(126729, 'Acadia', 46.9861106872559, 0.82006233419911, -68.0322189331055, -1.18738621782031, 218, 26, 'PPL', 'P'),
(39033, 'Acadian Villa', 29.7666702270508, 0.519526402817404, -90.8199996948242, -1.58510802133493, 218, 22, 'PPL', 'P'),
(191033, 'Acala', 31.333890914917, 0.54687956392604, -105.913887023926, -1.8485460521528, 218, 51, 'PPL', 'P'),
(92099, 'Acampo', 32.7127799987793, 0.570945718459245, -99.4433288574219, -1.7356135077055, 218, 51, 'PPL', 'P'),
(179602, 'Acampo', 38.1747207641602, 0.66627456836404, -121.277496337891, -2.11669161967156, 218, 6, 'PPL', 'P'),
(124076, 'Acapesket', 41.5499992370605, 0.725184290887838, -70.5763931274414, -1.23179043425575, 218, 23, 'PPL', 'P'),
(79483, 'Acapulco', 34.0641708374023, 0.594531938074505, -81.4730606079102, -1.42197315928493, 218, 48, 'PPL', 'P'),
(138995, 'Acasto', 40.5980606079102, 0.708569827532243, -91.8338928222656, -1.60280379467212, 218, 29, 'PPL', 'P'),
(99280, 'Acca', 37.5783309936523, 0.655865603243466, -77.4702835083008, -1.35211151967331, 218, 53, 'PPL', 'P'),
(179603, 'Accent Homes Mobile Home Park', 37.4300003051758, 0.6532767443478, -122.429168701172, -2.13679209431504, 218, 6, 'PPL', 'P'),
(141127, 'Accent Mobile Home Parks', 41.0166702270508, 0.715875943666766, -95.9069366455078, -1.67389181996572, 218, 35, 'PPL', 'P'),
(34499, 'Access', 38.209171295166, 0.666875843559153, -83.0711135864258, -1.44986444538133, 218, 21, 'PPL', 'P'),
(7022, 'Accident', 36.2277793884277, 0.632294031014202, -94.1013870239258, -1.64237903426097, 218, 4, 'PPL', 'P'),
(44273, 'Accident', 39.6286087036133, 0.691649699862533, -79.3199996948242, -1.38439515735558, 218, 25, 'PPL', 'P'),
(44274, 'Acco Park', 38.6738891601563, 0.674986700396071, -77.0002822875977, -1.34390845088365, 218, 25, 'PPL', 'P'),
(44275, 'Accokeek', 38.6674995422363, 0.674875180525424, -77.0286102294922, -1.34440286674002, 218, 25, 'PPL', 'P'),
(44276, 'Accokeek Acres', 38.6686096191406, 0.674894555022354, -76.9936065673828, -1.34379193758596, 218, 25, 'PPL', 'P'),
(44277, 'Accokeek Lawn', 38.6694412231445, 0.674909069250295, -77.0388870239258, -1.34458223063944, 218, 25, 'PPL', 'P'),
(195837, 'Accola', 45.9497184753418, 0.801973877759183, -111.184440612793, -1.94053456568134, 218, 31, 'PPL', 'P'),
(99284, 'Accomac', 37.7194404602051, 0.658328428040544, -75.6658325195313, -1.32061790872842, 218, 53, 'PPL', 'P'),
(158532, 'Accomac', 40.0449981689453, 0.698917067003196, -76.5638885498047, -1.33629194332408, 218, 45, 'PPL', 'P'),
(124077, 'Accord', 42.1744384765625, 0.736082811595797, -70.8841705322266, -1.23716216333249, 218, 23, 'PPL', 'P'),
(146700, 'Accord', 41.7855606079102, 0.729295612399676, -74.2294387817383, -1.2955481086489, 218, 40, 'PPL', 'P'),
(99283, 'Accotink', 38.7083282470703, 0.675587775854102, -77.1597213745117, -1.34669118790667, 218, 53, 'PPL', 'P'),
(99285, 'Accotink Heights', 38.8352813720703, 0.677803525881048, -77.2130584716797, -1.34762209586571, 218, 53, 'PPL', 'P'),
(107904, 'Accoville', 37.7686080932617, 0.659186565122795, -81.8372192382813, -1.42832892638445, 218, 58, 'PPL', 'P'),
(92100, 'Ace', 30.5361099243164, 0.532955658930238, -94.8241729736328, -1.65499402887051, 218, 51, 'PPL', 'P'),
(18723, 'Ace Mobile Home Park', 33.5605583190918, 0.585742241475726, -84.2663879394531, -1.4707259183063, 218, 13, 'PPL', 'P'),
(114339, 'Ace Mobile Home Park', 42.4833297729492, 0.741473981748499, -90.716667175293, -1.58330452864473, 218, 16, 'PPL', 'P'),
(179604, 'Acebedo', 35.8319396972656, 0.625385325093345, -120.200828552246, -2.0979002218619, 218, 6, 'PPL', 'P'),
(186310, 'Acequia', 39.523609161377, 0.689817112137423, -105.027496337891, -1.83307561622248, 218, 7, 'PPL', 'P'),
(194491, 'Acequia', 42.6680603027344, 0.744698137722203, -113.59610748291, -1.98262609302615, 218, 17, 'PPL', 'P'),
(92101, 'Acevedo Colonia Number 4', 26.2089996337891, 0.457433337263607, -98.3690032958984, -1.71686298941858, 218, 51, 'PPL', 'P'),
(92102, 'Acevedo Number 3 Colonia', 26.288890838623, 0.458827701831345, -98.3755569458008, -1.7169773721874, 218, 51, 'PPL', 'P'),
(14935, 'Achackwaithle (historical)', 29.8250007629395, 0.520544462723114, -85.0166702270508, -1.48382081454427, 218, 12, 'PPL', 'P'),
(14936, 'Achan', 27.8591709136963, 0.486234259319837, -81.9686126708984, -1.43062217439912, 218, 12, 'PPL', 'P'),
(99286, 'Achash', 38.3319396972656, 0.669018556393204, -78.1655578613281, -1.36424634633831, 218, 53, 'PPL', 'P'),
(177430, 'Achenbach', 41.5872192382813, 0.725833902456736, -72.7074966430664, -1.26898520730423, 218, 8, 'PPL', 'P'),
(158533, 'Acheson', 40.1949996948242, 0.701535087512799, -80.4513931274414, -1.40414169789019, 218, 45, 'PPL', 'P'),
(193087, 'Achi', 32.3444404602051, 0.564516980745849, -112.014167785645, -1.95501603674086, 218, 5, 'PPL', 'P'),
(74929, 'Achille', 33.8333282470703, 0.590502974819379, -96.3869400024414, -1.68226945896483, 218, 42, 'PPL', 'P'),
(99287, 'Achilles', 37.2799987792969, 0.650658723838197, -76.440559387207, -1.33413944337302, 218, 53, 'PPL', 'P'),
(187569, 'Achilles', 39.7119407653809, 0.693104118712853, -100.835830688477, -1.75991724949746, 218, 20, 'PPL', 'P'),
(154007, 'Achor', 40.774169921875, 0.711643514904358, -80.5419387817383, -1.40572201768104, 218, 41, 'PPL', 'P'),
(18724, 'Achord', 32.1061096191406, 0.560357322860227, -82.9688873291016, -1.44808026060903, 218, 13, 'PPL', 'P'),
(146701, 'Acidalia', 41.8994407653809, 0.731283196100229, -75.0336074829102, -1.30958350022584, 218, 40, 'PPL', 'P'),
(112677, 'Acipcoville', 33.5561103820801, 0.58566461032995, -86.8430633544922, -1.51569738805392, 218, 2, 'PPL', 'P'),
(158534, 'Acker', 40.4972190856934, 0.706809810946837, -77.0602798461914, -1.34495560582427, 218, 45, 'PPL', 'P'),
(58412, 'Acker (historical)', 33.9166717529297, 0.59195759340678, -88.4833297729492, -1.54432543766589, 218, 30, 'PPL', 'P'),
(191036, 'Ackerly', 32.5263900756836, 0.567692600608686, -101.715560913086, -1.7752714384462, 218, 51, 'PPL', 'P'),
(58408, 'Ackerman', 33.310001373291, 0.581369197807761, -89.1727828979492, -1.5563586647353, 218, 30, 'PPL', 'P'),
(107905, 'Ackerman (historical)', 39.5855598449707, 0.690898355539995, -78.8208312988281, -1.37568302532355, 218, 58, 'PPL', 'P'),
(144723, 'Ackermans Mills', 41.0272216796875, 0.716060101256145, -74.1691665649414, -1.29449616001832, 218, 37, 'PPL', 'P'),
(158535, 'Ackermanville', 40.839168548584, 0.712777954949704, -75.2197189331055, -1.31283175780741, 218, 45, 'PPL', 'P'),
(144713, 'Ackers Corner', 40.3347206115723, 0.703973677543957, -74.8494415283203, -1.30636919794817, 218, 37, 'PPL', 'P'),
(144714, 'Ackerson', 41.082218170166, 0.717019971092037, -74.668327331543, -1.3032081588923, 218, 37, 'PPL', 'P'),
(112678, 'Ackerville', 32.0294418334961, 0.559019217570516, -87.0663909912109, -1.51959519062536, 218, 2, 'PPL', 'P'),
(172832, 'Ackerville', 43.310001373291, 0.755902123007194, -88.258056640625, -1.54039367979055, 218, 57, 'PPL', 'P'),
(84574, 'Acklena', 35.0063896179199, 0.610976758068662, -90.0680618286133, -1.57198422979913, 218, 50, 'PPL', 'P'),
(114340, 'Ackley', 42.5541687011719, 0.742710354284568, -93.0530624389648, -1.6240823186238, 218, 16, 'PPL', 'P'),
(7023, 'Acklin Gap (historical)', 35.1366691589355, 0.613250565007372, -92.3188934326172, -1.61126865219694, 218, 4, 'PPL', 'P'),
(14937, 'Acklocknayke (historical)', 28.0833301544189, 0.490146576119218, -82.783332824707, -1.44484172356544, 218, 12, 'PPL', 'P'),
(114341, 'Ackworth', 41.3669395446777, 0.72198929652807, -93.4725036621094, -1.63140294898627, 218, 16, 'PPL', 'P'),
(158536, 'Ackworth', 40.0077781677246, 0.698267455434299, -75.6686096191406, -1.32066637826026, 218, 45, 'PPL', 'P'),
(14938, 'Acline', 26.8847198486328, 0.469226879834914, -82.0152816772461, -1.43143670221852, 218, 12, 'PPL', 'P'),
(112679, 'Acmar', 33.6213912963867, 0.586803977223313, -86.4961090087891, -1.5096418923673, 218, 2, 'PPL', 'P'),
(726, 'Acme', 34.3255615234375, 0.599094066179865, -78.2050018310547, -1.3649347734801, 218, 33, 'PPL', 'P'),
(29070, 'Acme', 38.9780616760254, 0.680295512292062, -86.0588912963867, -1.50201100373784, 218, 19, 'PPL', 'P'),
(31594, 'Acme', 38.8424987792969, 0.677929493400609, -97.2605590820313, -1.69751698831192, 218, 20, 'PPL', 'P'),
(39035, 'Acme', 31.2855606079102, 0.546036040940271, -91.8202819824219, -1.60256624070289, 218, 22, 'PPL', 'P'),
(53119, 'Acme', 39.2308311462402, 0.684707171795833, -94.5447235107422, -1.65011671565014, 218, 29, 'PPL', 'P'),
(58410, 'Acme', 31.9675006866455, 0.557938140615512, -89.1733322143555, -1.55636825211523, 218, 30, 'PPL', 'P'),
(74930, 'Acme', 34.7988891601563, 0.607355191881291, -98.0188903808594, -1.71075236629739, 218, 42, 'PPL', 'P'),
(107906, 'Acme', 38.0366706848145, 0.663865139946819, -81.4558334350586, -1.42167248839786, 218, 58, 'PPL', 'P'),
(129415, 'Acme', 44.7719383239746, 0.781417736253189, -85.5013885498047, -1.49228074522107, 218, 27, 'PPL', 'P'),
(154008, 'Acme', 41.0247192382813, 0.716016425414268, -81.79638671875, -1.42761626447675, 218, 41, 'PPL', 'P'),
(158537, 'Acme', 40.1266708374023, 0.700342523976661, -79.4288864135742, -1.38629558910946, 218, 45, 'PPL', 'P'),
(187980, 'Acme', 33.5922203063965, 0.586294847401917, -104.328056335449, -1.82086808525972, 218, 38, 'PPL', 'P'),
(193195, 'Acme', 43.9799995422363, 0.767595797037623, -124.059722900391, -2.16525063372363, 218, 43, 'PPL', 'P'),
(193241, 'Acme', 48.7172203063965, 0.850275896766059, -122.203887939453, -2.13286020328165, 218, 56, 'PPL', 'P'),
(209251, 'Acme', 44.9105606079102, 0.783837151524498, -106.984443664551, -1.8672307903608, 218, 59, 'PPL', 'P'),
(92105, 'Acme (historical)', 34.3166694641113, 0.598938870467341, -99.8236083984375, -1.7422506377742, 218, 51, 'PPL', 'P'),
(179605, 'Acme (historical)', 35.7869415283203, 0.624599958887881, -116.199996948242, -2.02807253755419, 218, 6, 'PPL', 'P'),
(189853, 'Acme (historical)', 38.5374984741211, 0.672606233855704, -118.294166564941, -2.06462269246082, 218, 39, 'PPL', 'P'),
(84575, 'Acme Mill', 35.5499992370605, 0.620464535768179, -84.5683288574219, -1.47599578147135, 218, 50, 'PPL', 'P'),
(158538, 'Acmetonia', 40.540828704834, 0.707570942386381, -79.8161087036133, -1.39305389300775, 218, 45, 'PPL', 'P'),
(124078, 'Acoaxet', 41.5069389343262, 0.724432746828218, -71.0972213745117, -1.24088060200452, 218, 23, 'PPL', 'P'),
(99288, 'Acodale', 38.2150001525879, 0.666977576312794, -77.2444381713867, -1.34816977494389, 218, 53, 'PPL', 'P'),
(179606, 'Acolita', 33.0711097717285, 0.577199752805133, -115.183891296387, -2.01033814838119, 218, 6, 'PPL', 'P'),
(189852, 'Acoma', 37.5483283996582, 0.655341959194129, -114.171669006348, -1.99267153665793, 218, 39, 'PPL', 'P'),
(187981, 'Acoma Pueblo', 34.8963890075684, 0.609056885238824, -107.581108093262, -1.87764454917134, 218, 38, 'PPL', 'P'),
(187986, 'Acoma Village', 34.898609161377, 0.609095634232685, -107.586387634277, -1.87773669454505, 218, 38, 'PPL', 'P'),
(187984, 'Acomita', 35.0552787780762, 0.611830034881924, -107.571113586426, -1.87747011211994, 218, 38, 'PPL', 'P'),
(187985, 'Acomita Lake', 35.0702781677246, 0.612091823617079, -107.613059997559, -1.8782022151036, 218, 38, 'PPL', 'P'),
(58411, 'Acona', 33.271671295166, 0.580700211741933, -90.01611328125, -1.57107755660601, 218, 30, 'PPL', 'P'),
(7024, 'Acorn', 34.6427803039551, 0.604630578349058, -94.2008285522461, -1.64411461634338, 218, 4, 'PPL', 'P'),
(34500, 'Acorn', 37.1330604553223, 0.648094166287478, -84.3777770996094, -1.47267002590206, 218, 21, 'PPL', 'P'),
(84576, 'Acorn', 35.4674987792969, 0.6190246311458, -84.2255630493164, -1.47001338955665, 218, 50, 'PPL', 'P'),
(99290, 'Acorn', 38.0191688537598, 0.663559675369786, -76.6494369506836, -1.33778504458923, 218, 53, 'PPL', 'P'),
(158539, 'Acorn', 40.1930618286133, 0.701501265366955, -75.2944412231445, -1.31413590779322, 218, 45, 'PPL', 'P'),
(179607, 'Acorn', 34.6527786254883, 0.604805081979486, -120.492218017578, -2.10298592743757, 218, 6, 'PPL', 'P'),
(99291, 'Acorn Acres', 36.7683296203613, 0.641728412333862, -76.6750030517578, -1.33823125722987, 218, 53, 'PPL', 'P'),
(143444, 'Acorn Acres', 43.0180587768555, 0.750806763472573, -70.7666702270508, -1.23511139613508, 218, 36, 'PPL', 'P'),
(53120, 'Acorn Corner', 36.0883293151855, 0.629860168093978, -89.7705612182617, -1.5667918646218, 218, 29, 'PPL', 'P'),
(62434, 'Acorn Hill', 36.4425010681152, 0.636041631300161, -76.5480575561523, -1.33601564036098, 218, 33, 'PPL', 'P'),
(84577, 'Acorn Hill', 36.1113891601563, 0.630262638313716, -87.2708282470703, -1.52316329385385, 218, 50, 'PPL', 'P'),
(18731, 'Acorn Pond', 31.8102798461914, 0.555194119296835, -83.8552780151367, -1.46355069653935, 218, 13, 'PPL', 'P'),
(53121, 'Acorn Ridge', 36.913330078125, 0.644259147738737, -90.0580596923828, -1.57180965958967, 218, 29, 'PPL', 'P'),
(124079, 'Acorn Terrace', 42.0944404602051, 0.734686582815296, -71.3722229003906, -1.24568028407911, 218, 23, 'PPL', 'P'),
(18725, 'Acorn Tree', 33.9577789306641, 0.592675049004447, -84.7927780151367, -1.4799131582768, 218, 13, 'PPL', 'P'),
(99292, 'Acors Corner', 38.0900001525879, 0.664795914747801, -77.3263931274414, -1.34960015876537, 218, 53, 'PPL', 'P'),
(158540, 'Acosta', 40.110279083252, 0.700056433896559, -79.0691680908203, -1.38001731999765, 218, 45, 'PPL', 'P'),
(92103, 'Acosta Colonia', 26.3169994354248, 0.459318289393652, -98.2750015258789, -1.71522234902904, 218, 51, 'PPL', 'P'),
(177431, 'Acquidaneck (historical)', 41.7874984741211, 0.72932943454552, -71.8686065673828, -1.25434381342125, 218, 8, 'PPL', 'P'),
(146702, 'Acra', 42.3108291625977, 0.738463278136164, -74.0558319091797, -1.29251809711866, 218, 40, 'PPL', 'P'),
(92104, 'Acre Tract Colonia', 26.2280006408691, 0.457764967398349, -97.9580001831055, -1.7096896318644, 218, 51, 'PPL', 'P'),
(44278, 'Acredale', 39.0027809143066, 0.680726944388655, -76.9430618286133, -1.34290976547487, 218, 25, 'PPL', 'P'),
(99293, 'Acredale', 36.7969398498535, 0.642227755038252, -76.1747207641602, -1.32949968412189, 218, 53, 'PPL', 'P'),
(18726, 'Acree', 31.5552806854248, 0.550743544351636, -83.9961090087891, -1.46600866106744, 218, 13, 'PPL', 'P'),
(99294, 'Acree Acres', 37.1755599975586, 0.648835923230093, -76.4688873291016, -1.33463385922939, 218, 53, 'PPL', 'P'),
(186311, 'Acres Green', 39.5566711425781, 0.690394152566616, -104.895561218262, -1.83077291398594, 218, 7, 'PPL', 'P'),
(44279, 'Acresville', 39.1777801513672, 0.68378125726384, -76.6116714477539, -1.33712591221944, 218, 25, 'PPL', 'P'),
(177432, 'Acropolis (historical)', 41.5363883972168, 0.724946736918603, -73.2061080932617, -1.27768761879829, 218, 8, 'PPL', 'P'),
(179608, 'Actis', 34.958610534668, 0.610142855752331, -118.14778137207, -2.06206778886905, 218, 6, 'PPL', 'P'),
(112681, 'Active', 32.8677787780762, 0.573650957494548, -86.976936340332, -1.5180339124363, 218, 2, 'PPL', 'P'),
(29062, 'Acton', 39.6555595397949, 0.692120080690069, -85.9669418334961, -1.50040618286496, 218, 19, 'PPL', 'P'),
(34501, 'Acton', 37.3469390869141, 0.651827052608415, -85.2480621337891, -1.48785936517932, 218, 21, 'PPL', 'P'),
(62435, 'Acton', 35.5613899230957, 0.620663340743553, -82.6391677856445, -1.44232556896753, 218, 33, 'PPL', 'P'),
(70453, 'Acton', 39.584171295166, 0.690874120774075, -75.4136123657227, -1.31621583660457, 218, 37, 'PPL', 'P'),
(84578, 'Acton', 35.0080604553223, 0.611005919682599, -88.4594421386719, -1.54390851979724, 218, 50, 'PPL', 'P'),
(92106, 'Acton', 32.4466705322266, 0.566301232097174, -97.6900024414063, -1.70501218888384, 218, 51, 'PPL', 'P'),
(112683, 'Acton', 33.3561096191406, 0.582173938510156, -86.8069381713867, -1.51506688466584, 218, 2, 'PPL', 'P'),
(124080, 'Acton', 42.4850006103516, 0.741503143362435, -71.4333267211914, -1.24674674693764, 218, 23, 'PPL', 'P'),
(126730, 'Acton', 43.5341682434082, 0.759814572964629, -70.9102783203125, -1.23761783019501, 218, 26, 'PPL', 'P'),
(133848, 'Acton', 45.084171295166, 0.786867229633763, -94.6605606079102, -1.65213845439168, 218, 28, 'PPL', 'P'),
(179609, 'Acton', 34.4700012207031, 0.601615014467734, -118.195831298828, -2.06290641829632, 218, 6, 'PPL', 'P'),
(195838, 'Acton', 45.9305610656738, 0.801639517884324, -108.680000305176, -1.89682383639376, 218, 31, 'PPL', 'P'),
(18727, 'Acton (historical)', 32.6527786254883, 0.569898496939599, -85.0100021362305, -1.48370443440463, 218, 13, 'PPL', 'P'),
(44280, 'Acton Village', 38.6405601501465, 0.674404999434971, -76.9055633544922, -1.34225529363698, 218, 25, 'PPL', 'P'),
(84579, 'Acuff', 36.3158302307129, 0.633830808121232, -83.7200012207031, -1.46118967107494, 218, 50, 'PPL', 'P'),
(191034, 'Acuff', 33.5950012207031, 0.586343383512784, -101.619720458984, -1.77359870696552, 218, 51, 'PPL', 'P'),
(107907, 'Acup', 38.3619384765625, 0.669542133863513, -81.3422164916992, -1.41968949865018, 218, 58, 'PPL', 'P'),
(124082, 'Acushnet', 41.6805610656738, 0.727463024674565, -70.908332824707, -1.23758387489111, 218, 23, 'PPL', 'P'),
(124083, 'Acushnet Station (historical)', 41.6749992370605, 0.727365952452831, -70.9400024414063, -1.23813661397535, 218, 23, 'PPL', 'P'),
(18728, 'Acworth', 34.0658302307129, 0.59456089995136, -84.6769409179688, -1.47789141953526, 218, 13, 'PPL', 'P'),
(92107, 'Acworth', 33.774169921875, 0.589470467264755, -94.9494400024414, -1.65718035096742, 218, 51, 'PPL', 'P'),
(143445, 'Acworth', 43.2177810668945, 0.754292575023377, -72.2925033569336, -1.26174220808754, 218, 36, 'PPL', 'P'),
(18729, 'Acworth Beach', 34.0608291625977, 0.594473614846632, -84.682502746582, -1.477988491757, 218, 13, 'PPL', 'P'),
(39036, 'Acy', 30.2186107635498, 0.527414253202542, -90.8202819824219, -1.58511294818294, 218, 22, 'PPL', 'P'),
(7026, 'Ada', 35.1069412231445, 0.612731714647997, -92.8733291625977, -1.6209453811758, 218, 4, 'PPL', 'P'),
(31595, 'Ada', 39.1513900756836, 0.683320663553311, -97.8888931274414, -1.7084834862067, 218, 20, 'PPL', 'P'),
(39038, 'Ada', 32.5458297729492, 0.568031887331562, -93.1402816772461, -1.62560458150289, 218, 22, 'PPL', 'P'),
(74931, 'Ada', 34.7744407653809, 0.606928486895633, -96.6780624389648, -1.6873505040086, 218, 42, 'PPL', 'P'),
(92108, 'Ada', 30.4877490997314, 0.532111603312251, -95.4911804199219, -1.66663550494358, 218, 51, 'PPL', 'P'),
(99295, 'Ada', 38.8369407653809, 0.677832487757903, -77.9186096191406, -1.35993628643013, 218, 53, 'PPL', 'P'),
(107908, 'Ada', 37.2947196960449, 0.650915652304363, -81.1469421386719, -1.41628131824515, 218, 58, 'PPL', 'P'),
(112684, 'Ada', 32.105281829834, 0.560342875211313, -86.2763900756836, -1.50580707355564, 218, 2, 'PPL', 'P'),
(129417, 'Ada', 42.9541702270508, 0.749691697924156, -85.4888916015625, -1.49206263232779, 218, 27, 'PPL', 'P'),
(133850, 'Ada', 47.2997207641602, 0.825535862608523, -96.5149993896484, -1.68450451690968, 218, 28, 'PPL', 'P'),
(154009, 'Ada', 40.7694396972656, 0.711560956910565, -83.8227767944336, -1.46298344322716, 218, 41, 'PPL', 'P'),
(172834, 'Ada', 43.8769416809082, 0.765797098037383, -87.8955612182617, -1.53406694114691, 218, 57, 'PPL', 'P'),
(79484, 'Ada (historical)', 34.5661087036133, 0.603292406480321, -81.5286102294922, -1.42294268307977, 218, 48, 'PPL', 'P'),
(18732, 'Adabelle', 32.291389465332, 0.563591066213855, -81.9272232055664, -1.42989979195344, 218, 13, 'PPL', 'P'),
(515, 'Adaburg', 37.5916709899902, 0.656098430101766, -86.8477783203125, -1.5157796797316, 218, 21, 'PPL', 'P'),
(77760, 'Adah', 39.8963890075684, 0.696323347838541, -79.9222183227539, -1.3949058552298, 218, 45, 'PPL', 'P'),
(34502, 'Adair', 37.9505615234375, 0.66236225156466, -86.8266677856445, -1.51541123139479, 218, 21, 'PPL', 'P'),
(58414, 'Adair', 33.3136100769043, 0.581432181567541, -90.0905609130859, -1.57237691290186, 218, 30, 'PPL', 'P'),
(74932, 'Adair', 36.4366683959961, 0.635939831967493, -95.271110534668, -1.66279456086141, 218, 42, 'PPL', 'P'),
(84580, 'Adair', 35.714168548584, 0.623329830784995, -88.9608306884766, -1.55265940082313, 218, 50, 'PPL', 'P'),
(114342, 'Adair', 41.500560760498, 0.724321426694653, -94.6433334350586, -1.65183778350461, 218, 16, 'PPL', 'P'),
(118564, 'Adair', 40.4188919067383, 0.705442743780272, -90.4966735839844, -1.5794649161431, 218, 18, 'PPL', 'P'),
(129419, 'Adair', 42.7980613708496, 0.746967084391924, -82.6338882446289, -1.44223342359381, 218, 27, 'PPL', 'P'),
(138996, 'Adair', 40.2522201538086, 0.702533772921578, -92.3763885498047, -1.61227213129568, 218, 29, 'PPL', 'P'),
(154010, 'Adair', 40.7936096191406, 0.711982801627234, -80.9561080932617, -1.41295063582785, 218, 41, 'PPL', 'P'),
(191035, 'Adair', 32.9627799987793, 0.575309041589231, -102.254173278809, -1.78467199762002, 218, 51, 'PPL', 'P'),
(194493, 'Adair', 47.3422203063965, 0.826277619551137, -115.611106872559, -2.01779446680119, 218, 17, 'PPL', 'P'),
(200292, 'Adair Village', 44.6708297729492, 0.779653059135875, -123.216667175293, -2.15053653554288, 218, 43, 'PPL', 'P'),
(18733, 'Adairsville', 34.3686103820801, 0.599845410502404, -84.9341735839844, -1.48238097650092, 218, 13, 'PPL', 'P'),
(34504, 'Adairville', 36.6674995422363, 0.639968595485538, -86.851936340332, -1.51585225087131, 218, 21, 'PPL', 'P'),
(212251, 'Adak', 51.8800010681152, 0.905476834576786, -176.658065795898, -3.0832648983432, 218, 1, 'PPL', 'P'),
(62436, 'Adako', 35.9041709899902, 0.626645998974362, -81.7041702270508, -1.42600678307196, 218, 33, 'PPL', 'P'),
(107909, 'Adaland', 39.208610534668, 0.68431934896209, -80.0769424438477, -1.39760630057514, 218, 58, 'PPL', 'P'),
(107910, 'Adaline', 39.7652816772461, 0.694035093250917, -80.6466674804688, -1.40754987829522, 218, 58, 'PPL', 'P'),
(126732, 'Adaline', 46.7619400024414, 0.816149817662648, -68.1244430541992, -1.18899583238316, 218, 26, 'PPL', 'P'),
(14940, 'Adam', 29.4911098480225, 0.514716966915316, -82.5063934326172, -1.440008219345, 218, 12, 'PPL', 'P'),
(107911, 'Adam', 38.8300018310547, 0.677711380507331, -81.1719436645508, -1.41671767718976, 218, 58, 'PPL', 'P'),
(99297, 'Adam Acres', 37.2144393920898, 0.649514496675845, -80.0219421386719, -1.39664636416022, 218, 53, 'PPL', 'P'),
(53123, 'Adam Ford', 37.6283302307129, 0.656738254553657, -92.32861328125, -1.61143829555838, 218, 29, 'PPL', 'P'),
(92109, 'Adam Lee Colonia', 26.3759994506836, 0.460348033918644, -98.1669998168945, -1.71333736360948, 218, 51, 'PPL', 'P'),
(192984, 'Adamana', 34.9766693115234, 0.610458040867342, -109.821670532227, -1.91674974082779, 218, 5, 'PPL', 'P'),
(171670, 'Adamant', 44.3291702270508, 0.773689975139078, -72.5033264160156, -1.26542176460765, 218, 55, 'PPL', 'P'),
(14941, 'Adams', 30.4650001525879, 0.531714559283234, -83.0461120605469, -1.44942808643672, 218, 12, 'PPL', 'P'),
(26326, 'Adams', 39.8652801513672, 0.695780395871301, -91.1980590820313, -1.59170640240976, 218, 18, 'PPL', 'P'),
(29064, 'Adams', 39.4822196960449, 0.689094729691739, -86.3555603027344, -1.50718885468723, 218, 19, 'PPL', 'P'),
(31596, 'Adams', 37.458610534668, 0.65377608705219, -97.9772186279297, -1.71002505700369, 218, 20, 'PPL', 'P'),
(34505, 'Adams', 38.0544395446777, 0.664175265055758, -82.7077789306641, -1.44352305935168, 218, 21, 'PPL', 'P'),
(53124, 'Adams', 39.0916709899902, 0.682278368881681, -94.3375015258789, -1.64650000973176, 218, 29, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(58413, 'Adams', 32.1597213745117, 0.561293024509226, -90.5605621337891, -1.58057998169152, 218, 30, 'PPL', 'P'),
(84581, 'Adams', 36.582218170166, 0.638480154752292, -87.065559387207, -1.51958067639742, 218, 50, 'PPL', 'P'),
(107913, 'Adams', 38.1699981689453, 0.666192143528302, -81.8525009155273, -1.42859564196763, 218, 58, 'PPL', 'P'),
(112665, 'Adams', 32.7394409179688, 0.571411039280709, -86.8327789306641, -1.51551789099645, 218, 2, 'PPL', 'P'),
(124086, 'Adams', 42.6241683959961, 0.743932079434642, -73.1180572509766, -1.27615084169125, 218, 23, 'PPL', 'P'),
(126733, 'Adams', 45.3274993896484, 0.791114106045085, -68.9011077880859, -1.20255118917361, 218, 26, 'PPL', 'P'),
(133852, 'Adams', 43.5652809143066, 0.760357591510897, -92.7191696166992, -1.61825478952649, 218, 28, 'PPL', 'P'),
(139559, 'Adams', 48.4213905334473, 0.845112693202668, -98.07861328125, -1.71179472754805, 218, 34, 'PPL', 'P'),
(141128, 'Adams', 40.4594383239746, 0.706150412260933, -96.5097198486328, -1.68441237153597, 218, 35, 'PPL', 'P'),
(144715, 'Adams', 40.4508285522461, 0.706000143396425, -74.4936065673828, -1.3001587062861, 218, 37, 'PPL', 'P'),
(146703, 'Adams', 43.8091697692871, 0.764614255039225, -76.0244369506836, -1.32687673676427, 218, 40, 'PPL', 'P'),
(158542, 'Adams', 40.3594398498535, 0.70440510964055, -77.8619384765625, -1.35894718840127, 218, 45, 'PPL', 'P'),
(172836, 'Adams', 42.8005599975586, 0.747010693654774, -88.5327835083008, -1.54518856817519, 218, 57, 'PPL', 'P'),
(179610, 'Adams', 38.8563919067383, 0.67817197421786, -122.718612670898, -2.14184384458681, 218, 6, 'PPL', 'P'),
(190950, 'Adams', 36.7563896179199, 0.641520019978563, -101.076667785645, -1.76412064980398, 218, 42, 'PPL', 'P'),
(191037, 'Adams', 30.934440612793, 0.53990784095589, -100.264442443848, -1.74994464332149, 218, 51, 'PPL', 'P'),
(200293, 'Adams', 45.7675018310547, 0.798793597364438, -118.561393737793, -2.06928668647787, 218, 43, 'PPL', 'P'),
(18734, 'Adams (historical)', 33.4097213745117, 0.583109640159155, -82.0111083984375, -1.43136386476271, 218, 13, 'PPL', 'P'),
(118565, 'Adams (historical)', 41.0994415283203, 0.71732057540008, -88.584716796875, -1.54609497505219, 218, 18, 'PPL', 'P'),
(138998, 'Adams (historical)', 40.5152816772461, 0.707125062640875, -94.2544403076172, -1.64505031799238, 218, 29, 'PPL', 'P'),
(146704, 'Adams Basin', 43.1974983215332, 0.753938574335479, -77.8541717529297, -1.35881163350179, 218, 40, 'PPL', 'P'),
(172837, 'Adams Beach', 44.6861114501953, 0.779919774719046, -88.6680603027344, -1.54754959363959, 218, 57, 'PPL', 'P'),
(146705, 'Adams Center', 43.8600006103516, 0.765501420577357, -76.0058288574219, -1.32655196426933, 218, 40, 'PPL', 'P'),
(172838, 'Adams Center (historical)', 43.9161109924316, 0.766480731489207, -89.7972183227539, -1.56725711886424, 218, 57, 'PPL', 'P'),
(44281, 'Adams Chance', 39.5758285522461, 0.690728512441475, -76.8819427490234, -1.34184303630024, 218, 25, 'PPL', 'P'),
(26327, 'Adams Corner', 38.5130615234375, 0.672179728607128, -87.741943359375, -1.53138580371947, 218, 18, 'PPL', 'P'),
(31597, 'Adams Corner', 38.0574989318848, 0.664228661435614, -98.0869369506836, -1.71194000298552, 218, 20, 'PPL', 'P'),
(126734, 'Adams Corner', 43.4124984741211, 0.757691034890427, -70.4416732788086, -1.22943912932932, 218, 26, 'PPL', 'P'),
(146706, 'Adams Corner', 42.4266700744629, 0.740485083456725, -75.7286071777344, -1.32171353320088, 218, 40, 'PPL', 'P'),
(146707, 'Adams Corners', 41.353328704834, 0.721751742558835, -73.8399963378906, -1.28875105575675, 218, 40, 'PPL', 'P'),
(146708, 'Adams Cove', 44.0063896179199, 0.768056390748152, -76.1588897705078, -1.32922338115879, 218, 40, 'PPL', 'P'),
(79486, 'Adams Crossing', 34.6522216796875, 0.604795361441507, -82.8663864135742, -1.44629128214677, 218, 48, 'PPL', 'P'),
(158543, 'Adams Crossing', 40.5424995422363, 0.707600104000318, -78.8802795410156, -1.37672059288424, 218, 45, 'PPL', 'P'),
(13259, 'Adams Crossroads', 38.7972183227539, 0.677139200347128, -75.7016677856445, -1.32124335211042, 218, 10, 'PPL', 'P'),
(18736, 'Adams Crossroads', 33.964168548584, 0.592786568875094, -84.1397171020508, -1.46851509512737, 218, 13, 'PPL', 'P'),
(84582, 'Adams Crossroads', 36.1813888549805, 0.63148436346379, -87.5208282470703, -1.52752661698383, 218, 50, 'PPL', 'P'),
(112686, 'Adams Crossroads', 34.0774993896484, 0.594764565195723, -85.4877777099609, -1.49204319125184, 218, 2, 'PPL', 'P'),
(92111, 'Adams Gardens', 26.1681499481201, 0.456720375750279, -97.7921524047852, -1.70679504207559, 218, 51, 'PPL', 'P'),
(84583, 'Adams Grove', 36.1072196960449, 0.63018986743693, -86.2655563354492, -1.50561798911824, 218, 50, 'PPL', 'P'),
(99298, 'Adams Grove', 36.6930618286133, 0.640414741547153, -77.3855590820313, -1.35063279947805, 218, 53, 'PPL', 'P'),
(44285, 'Adams Heights', 39.5377807617188, 0.690064453223664, -76.1805572509766, -1.32960155003358, 218, 25, 'PPL', 'P'),
(124087, 'Adams Junction', 42.4583282470703, 0.741037622803889, -73.2083282470703, -1.27772636779215, 218, 23, 'PPL', 'P'),
(58416, 'Adams Landing', 32.5702781677246, 0.56845859231722, -90.7266693115234, -1.58347909885418, 218, 30, 'PPL', 'P'),
(79487, 'Adams Landing', 33.5275001525879, 0.58516526762556, -80.4383316040039, -1.40391373130088, 218, 48, 'PPL', 'P'),
(171671, 'Adams Landing', 44.7361106872559, 0.780792426029238, -73.3324966430664, -1.2798935151292, 218, 55, 'PPL', 'P'),
(84584, 'Adams Mill', 36.1402816772461, 0.630766907866123, -82.5980606079102, -1.44160811336986, 218, 50, 'PPL', 'P'),
(122106, 'Adams Mill', 40.4805603027344, 0.706519060334827, -86.5088882446289, -1.50986493210859, 218, 19, 'PPL', 'P'),
(154011, 'Adams Mills', 40.1566696166992, 0.700866101446971, -81.9469375610352, -1.43024387236628, 218, 41, 'PPL', 'P'),
(44282, 'Adams Mobile Home Park', 39.5297203063965, 0.68992377173908, -76.1263885498047, -1.3286561278466, 218, 25, 'PPL', 'P'),
(13028, 'Adams Morgan', 38.9213905334473, 0.679306414263207, -77.0425033569336, -1.34464534755728, 218, 9, 'PPL', 'P'),
(129420, 'Adams Park', 42.1538887023926, 0.735724150375991, -85.4727783203125, -1.49178140251668, 218, 27, 'PPL', 'P'),
(202818, 'Adams Park', 40.6355590820313, 0.70922429937013, -111.855560302734, -1.95224781394578, 218, 52, 'PPL', 'P'),
(154012, 'Adams Ridge', 41.398609161377, 0.722542035612316, -84.2655563354492, -1.47071140407836, 218, 41, 'PPL', 'P'),
(79489, 'Adams Run', 32.7205581665039, 0.571081473095812, -80.3483276367188, -1.4023428657319, 218, 48, 'PPL', 'P'),
(124088, 'Adams Shore', 42.2638893127441, 0.737644023205829, -70.9847183227539, -1.2389170533328, 218, 23, 'PPL', 'P'),
(179611, 'Adams Square', 34.1336097717285, 0.595743876107573, -118.240280151367, -2.06368219712186, 218, 6, 'PPL', 'P'),
(193335, 'Adams Station', 41.8427810668945, 0.730294297808455, -123.991386413574, -2.16405793702943, 218, 6, 'PPL', 'P'),
(143447, 'Adams Trailer Park', 42.9033317565918, 0.748804399227969, -70.8641662597656, -1.23681302291359, 218, 36, 'PPL', 'P'),
(122112, 'Adamsboro', 40.7844390869141, 0.71182274564572, -86.2669372558594, -1.50564209072611, 218, 19, 'PPL', 'P'),
(79490, 'Adamsburg', 34.7911109924316, 0.607219437244724, -81.5430603027344, -1.423194884435, 218, 48, 'PPL', 'P'),
(112689, 'Adamsburg', 34.3988914489746, 0.60037391482073, -85.6722183227539, -1.49526228721947, 218, 2, 'PPL', 'P'),
(158547, 'Adamsburg', 40.3116683959961, 0.703571340482273, -79.6563873291016, -1.39026622913671, 218, 45, 'PPL', 'P'),
(124090, 'Adamsdale', 41.9277801513672, 0.731777811693684, -71.3708267211914, -1.24565591615514, 218, 23, 'PPL', 'P'),
(158549, 'Adamsdale', 40.6361083984375, 0.709233886750054, -76.1283264160156, -1.32868994999245, 218, 45, 'PPL', 'P'),
(18738, 'Adamson', 33.2677803039551, 0.580632301134136, -85.2322235107422, -1.48758292905817, 218, 13, 'PPL', 'P'),
(34506, 'Adamson', 37.2016716003418, 0.649291656671632, -82.5791702270508, -1.44127841402691, 218, 21, 'PPL', 'P'),
(74936, 'Adamson', 34.9238891601563, 0.609536853446284, -95.5469436645508, -1.66760875716395, 218, 42, 'PPL', 'P'),
(107914, 'Adamston', 39.2905616760254, 0.685749666204545, -80.3580627441406, -1.40251277540944, 218, 58, 'PPL', 'P'),
(144716, 'Adamston', 40.045280456543, 0.698921993851213, -74.0955581665039, -1.29321145110847, 218, 37, 'PPL', 'P'),
(44283, 'Adamstown', 39.3108291625977, 0.686103400576334, -77.4749984741211, -1.352193811351, 218, 25, 'PPL', 'P'),
(158550, 'Adamstown', 40.2411117553711, 0.702339894794221, -76.0566711425781, -1.32743932954455, 218, 45, 'PPL', 'P'),
(44284, 'Adamstown Village', 39.3166694641113, 0.686205333067057, -77.5066680908203, -1.35274655043524, 218, 25, 'PPL', 'P'),
(13260, 'Adamsville', 38.8313903808594, 0.677735615273251, -75.6894378662109, -1.32102989974905, 218, 10, 'PPL', 'P'),
(14944, 'Adamsville', 28.7994403839111, 0.502645057431069, -82.0208282470703, -1.43153350812415, 218, 12, 'PPL', 'P'),
(18740, 'Adamsville', 33.3752784729004, 0.582508498122097, -82.3702774047852, -1.43763254649459, 218, 13, 'PPL', 'P'),
(31599, 'Adamsville', 37.1733283996582, 0.64879697449915, -97.1761093139648, -1.69604306180661, 218, 20, 'PPL', 'P'),
(62441, 'Adamsville', 35.3708305358887, 0.617337452016208, -77.95361328125, -1.36054721558419, 218, 33, 'PPL', 'P'),
(84585, 'Adamsville', 35.2358283996582, 0.61498122024176, -88.3905563354492, -1.54270623572312, 218, 50, 'PPL', 'P'),
(92112, 'Adamsville', 31.3011093139648, 0.54630741705535, -98.1686096191406, -1.71336545995898, 218, 51, 'PPL', 'P'),
(107915, 'Adamsville', 39.3952789306641, 0.687577327081639, -80.2447204589844, -1.40053457935173, 218, 58, 'PPL', 'P'),
(112688, 'Adamsville', 33.600830078125, 0.586445116266425, -86.9561080932617, -1.51767039094751, 218, 2, 'PPL', 'P'),
(124091, 'Adamsville', 42.6813888549805, 0.744930764843422, -72.7486114501953, -1.26970279605996, 218, 23, 'PPL', 'P'),
(129424, 'Adamsville', 41.7852783203125, 0.729290685551659, -85.9938888549805, -1.50087649711347, 218, 27, 'PPL', 'P'),
(146710, 'Adamsville', 43.3208312988281, 0.756091140865562, -73.4736099243164, -1.2823564065053, 218, 40, 'PPL', 'P'),
(154020, 'Adamsville', 40.0697212219238, 0.699348565678816, -81.8824996948242, -1.42911921943793, 218, 41, 'PPL', 'P'),
(158552, 'Adamsville', 41.5111083984375, 0.724505517705004, -80.370002746582, -1.40272116776474, 218, 45, 'PPL', 'P'),
(169248, 'Adamsville', 41.5544395446777, 0.72526178887556, -71.1316680908203, -1.2414818106206, 218, 47, 'PPL', 'P'),
(192463, 'Adamsville', 38.2583312988281, 0.667733847483349, -112.793060302734, -1.96861027568323, 218, 52, 'PPL', 'P'),
(192987, 'Adamsville', 33.0127792358398, 0.576181692899423, -111.441390991211, -1.94501919579898, 218, 5, 'PPL', 'P'),
(58417, 'Adamsville (historical)', 31.2930603027344, 0.546166935307848, -88.5458297729492, -1.54541626844839, 218, 30, 'PPL', 'P'),
(124092, 'Adamsville (historical)', 42.2425003051758, 0.737270714600027, -71.0711135864258, -1.24042493514201, 218, 23, 'PPL', 'P'),
(79491, 'Adamsville Crossroads', 34.688060760498, 0.605420871402539, -79.595832824707, -1.38920935365812, 218, 48, 'PPL', 'P'),
(154021, 'Adario', 40.934440612793, 0.714440766155323, -82.4502792358398, -1.43902884185412, 218, 41, 'PPL', 'P'),
(18741, 'Adasburg', 33.7061080932617, 0.588282564260525, -82.5483322143555, -1.4407401891706, 218, 13, 'PPL', 'P'),
(58418, 'Adaton', 33.4772186279297, 0.584287689467352, -88.92138671875, -1.55197097368134, 218, 30, 'PPL', 'P'),
(199134, 'Adaton (historical)', 42.8847198486328, 0.748479560154007, -102.762222290039, -1.79353912562749, 218, 35, 'PPL', 'P'),
(189854, 'Adaven', 38.1322212219238, 0.665532811421426, -115.59944152832, -2.01759086813586, 218, 39, 'PPL', 'P'),
(114350, 'Adaville', 42.7508316040039, 0.746142769455517, -96.404167175293, -1.6825701298519, 218, 16, 'PPL', 'P'),
(114351, 'Adaza', 42.1952781677246, 0.736446532821675, -94.4941711425781, -1.649234410381, 218, 16, 'PPL', 'P'),
(206640, 'Adco', 47.4174995422363, 0.827591490074928, -119.361389160156, -2.083249240599, 218, 56, 'PPL', 'P'),
(62439, 'Adcock Crossroads', 36.3294410705566, 0.634068362090467, -78.3552780151367, -1.36755758767966, 218, 33, 'PPL', 'P'),
(13261, 'Addick Estates', 39.8027801513672, 0.694689565088804, -75.4499969482422, -1.3168508673665, 218, 10, 'PPL', 'P'),
(92113, 'Addicks', 29.7822208404541, 0.519797812221997, -95.642219543457, -1.66927163494859, 218, 51, 'PPL', 'P'),
(58419, 'Addie', 32.9872207641602, 0.575735613416835, -91.0758285522461, -1.58957307721855, 218, 30, 'PPL', 'P'),
(62440, 'Addie', 35.4058303833008, 0.617948314591245, -83.1600036621094, -1.45141586987435, 218, 33, 'PPL', 'P'),
(194495, 'Addie', 48.9536094665527, 0.85440166592681, -116.165283203125, -2.0274666684062, 218, 17, 'PPL', 'P'),
(84586, 'Addie (historical)', 36.3791694641113, 0.634936286289724, -86.9086074829102, -1.51684134890016, 218, 50, 'PPL', 'P'),
(74937, 'Addielee', 35.9588890075684, 0.627601008541264, -94.6366729736328, -1.65172153652303, 218, 42, 'PPL', 'P'),
(92114, 'Addielou', 33.8147201538086, 0.590178202324443, -95.2163925170898, -1.66183955129451, 218, 51, 'PPL', 'P'),
(26329, 'Addieville', 38.3913917541504, 0.670056190532926, -89.4899978637695, -1.56189511032547, 218, 18, 'PPL', 'P'),
(77763, 'Addingham', 39.9422187805176, 0.697123228271946, -75.3050003051758, -1.31432019854065, 218, 45, 'PPL', 'P'),
(74938, 'Addington', 34.2444381713867, 0.597678196586324, -97.966667175293, -1.70984089941432, 218, 42, 'PPL', 'P'),
(99299, 'Addington', 36.9766693115234, 0.645364625907229, -82.6213912963867, -1.44201531070053, 218, 53, 'PPL', 'P'),
(62443, 'Addington Mill', 35.1133308410645, 0.612843234518644, -83.398063659668, -1.45557080064904, 218, 33, 'PPL', 'P'),
(39039, 'Addis', 30.353609085083, 0.529770418397962, -91.2652816772461, -1.592879658028, 218, 22, 'PPL', 'P'),
(34507, 'Addison', 37.9161109924316, 0.661760976369547, -86.5650024414063, -1.51084430959947, 218, 21, 'PPL', 'P'),
(71626, 'Addison', 38.8861083984375, 0.678690624840153, -82.1463928222656, -1.43372502338517, 218, 41, 'PPL', 'P'),
(77764, 'Addison', 39.7472190856934, 0.693719841556879, -79.3394393920898, -1.38473444407846, 218, 45, 'PPL', 'P'),
(84587, 'Addison', 35.3783302307129, 0.617468346383785, -84.5213928222656, -1.47517659312004, 218, 50, 'PPL', 'P'),
(92115, 'Addison', 32.961669921875, 0.575289667092301, -96.8288879394531, -1.68998290558808, 218, 51, 'PPL', 'P'),
(99300, 'Addison', 37.1974983215332, 0.649218819215819, -77.5027770996094, -1.35267863982744, 218, 53, 'PPL', 'P'),
(112690, 'Addison', 34.202220916748, 0.596941366491727, -87.1813888549805, -1.5216022819809, 218, 2, 'PPL', 'P'),
(118567, 'Addison', 41.9316711425781, 0.731845722301481, -87.9888916015625, -1.53569586362765, 218, 18, 'PPL', 'P'),
(126735, 'Addison', 44.6183280944824, 0.778736731983806, -67.7447204589844, -1.18236842285244, 218, 26, 'PPL', 'P'),
(129425, 'Addison', 41.9863891601563, 0.732800731868383, -84.3472213745117, -1.47213672789377, 218, 27, 'PPL', 'P'),
(146711, 'Addison', 42.1027793884277, 0.734832124568868, -77.23388671875, -1.34798561735451, 218, 40, 'PPL', 'P'),
(171672, 'Addison', 44.0886116027832, 0.769491435101541, -73.3030624389648, -1.27937979135492, 218, 55, 'PPL', 'P'),
(172844, 'Addison', 43.422779083252, 0.757870465368871, -88.3744430541992, -1.54242500591201, 218, 57, 'PPL', 'P'),
(177433, 'Addison', 41.7183303833008, 0.728122223623387, -72.5772171020508, -1.26671140036552, 218, 8, 'PPL', 'P'),
(18742, 'Addison Heights', 34.0327796936035, 0.593984059259248, -84.5341720581055, -1.47539963286133, 218, 13, 'PPL', 'P'),
(99301, 'Addison Heights', 38.8555603027344, 0.67815745998992, -77.0605621337891, -1.34496053267229, 218, 53, 'PPL', 'P'),
(129426, 'Addison Junction', 41.9936103820801, 0.732926765966971, -84.3255615234375, -1.47175869217703, 218, 27, 'PPL', 'P'),
(62442, 'Addor', 35.0777816772461, 0.612222784563683, -79.4622192382813, -1.38687735664959, 218, 33, 'PPL', 'P'),
(92116, 'Addran', 33.2941703796387, 0.581092894844665, -95.602783203125, -1.66858334096486, 218, 51, 'PPL', 'P'),
(206641, 'Addy', 48.3561096191406, 0.843973326309305, -117.836387634277, -2.05663294287447, 218, 56, 'PPL', 'P'),
(71628, 'Addyston', 39.1366691589355, 0.683063735087145, -84.7091674804688, -1.47845387915749, 218, 41, 'PPL', 'P'),
(122113, 'Ade', 40.8683280944824, 0.713286885034018, -87.4447174072266, -1.5261982322321, 218, 19, 'PPL', 'P'),
(18743, 'Adel', 31.1369400024414, 0.543442122038534, -83.4236068725586, -1.45601661381552, 218, 13, 'PPL', 'P'),
(29071, 'Adel', 39.1919403076172, 0.684028398612999, -86.7958297729492, -1.51487300653849, 218, 19, 'PPL', 'P'),
(74939, 'Adel', 34.5791702270508, 0.603520373069631, -95.5941696166992, -1.66843300552133, 218, 42, 'PPL', 'P'),
(92117, 'Adel', 29.3494396209717, 0.512244355001232, -97.1727828979492, -1.69598500489485, 218, 51, 'PPL', 'P'),
(114352, 'Adel', 41.6144409179688, 0.726309010395206, -94.017219543457, -1.64091003460369, 218, 16, 'PPL', 'P'),
(139000, 'Adel', 40.5313911437988, 0.70740622587296, -93.6688919067383, -1.63483057046725, 218, 29, 'PPL', 'P'),
(195839, 'Adel', 47.0277786254883, 0.820789576913784, -111.623062133789, -1.94818995539283, 218, 31, 'PPL', 'P'),
(200294, 'Adel', 42.1775016784668, 0.73613627455468, -119.897499084473, -2.09260612393093, 218, 43, 'PPL', 'P'),
(179614, 'Adela', 37.7886085510254, 0.659535638962677, -120.86222076416, -2.10944369360685, 218, 6, 'PPL', 'P'),
(179612, 'Adelaida', 35.6455612182617, 0.622132406979868, -120.872497558594, -2.10962305750627, 218, 6, 'PPL', 'P'),
(18744, 'Adelaide', 31.2666702270508, 0.545706341597319, -84.1486129760742, -1.46867035741892, 218, 13, 'PPL', 'P'),
(158553, 'Adelaide', 40.0433311462402, 0.698887971968287, -79.6241683959961, -1.38970390267254, 218, 45, 'PPL', 'P'),
(186315, 'Adelaide', 39.2472190856934, 0.684993195296908, -106.257499694824, -1.85454322461155, 218, 7, 'PPL', 'P'),
(194496, 'Adelaide', 42.8072204589844, 0.747126940636356, -113.72110748291, -1.98480775459114, 218, 17, 'PPL', 'P'),
(206643, 'Adelaide', 47.6500015258789, 0.831649415206909, -122.087501525879, -2.13082887716019, 218, 56, 'PPL', 'P'),
(7027, 'Adelaide (historical)', 35.4952812194824, 0.619509526201276, -91.5299987792969, -1.59749984304512, 218, 4, 'PPL', 'P'),
(199801, 'Adelaide (historical)', 40.8166694641113, 0.712385271846972, -117.524719238281, -2.05119330318993, 218, 39, 'PPL', 'P'),
(179613, 'Adelanto', 34.5827789306641, 0.603583356829412, -117.408332824707, -2.04916197706847, 218, 6, 'PPL', 'P'),
(53126, 'Adelbert (historical)', 37.9708290100098, 0.662715985936449, -90.7099990844727, -1.58318814850509, 218, 29, 'PPL', 'P'),
(34509, 'Adele', 37.7572212219238, 0.658987826726447, -83.3011093139648, -1.4538786280924, 218, 21, 'PPL', 'P'),
(77767, 'Adele', 39.9772186279297, 0.697734090846983, -75.3338928222656, -1.31482446809306, 218, 45, 'PPL', 'P'),
(112565, 'Adelia (historical)', 33.9111099243164, 0.591860521185046, -85.7777786254883, -1.49710466206159, 218, 2, 'PPL', 'P'),
(44286, 'Adelina', 38.4805603027344, 0.671612475294941, -76.6216735839844, -1.33730048242889, 218, 25, 'PPL', 'P'),
(39050, 'Adeline', 29.8727798461914, 0.521378365039445, -91.5908279418945, -1.59856151221368, 218, 22, 'PPL', 'P'),
(118569, 'Adeline', 42.1433296203613, 0.735539859628557, -89.4902801513672, -1.56190003717349, 218, 18, 'PPL', 'P'),
(187987, 'Adelino', 34.7158317565918, 0.605905566720934, -106.730560302734, -1.86279968978107, 218, 38, 'PPL', 'P'),
(92118, 'Adell', 32.8844413757324, 0.573941774685584, -97.9219436645508, -1.70906032689881, 218, 51, 'PPL', 'P'),
(172845, 'Adell', 43.6191711425781, 0.761298153428885, -87.9519424438477, -1.53505097916969, 218, 57, 'PPL', 'P'),
(172847, 'Adella Beach', 44.142219543457, 0.770427070171513, -88.461669921875, -1.54394740194915, 218, 57, 'PPL', 'P'),
(58420, 'Adelle', 32.5055618286133, 0.567329079119891, -90.4055633544922, -1.57787474265622, 218, 30, 'PPL', 'P'),
(206644, 'Adelma Beach', 48.0494384765625, 0.838620905150464, -122.827781677246, -2.14374920318871, 218, 56, 'PPL', 'P'),
(44287, 'Adelphi', 39.003059387207, 0.680731804657645, -76.9722213745117, -1.34341869555918, 218, 25, 'PPL', 'P'),
(71629, 'Adelphi', 39.4666709899902, 0.68882335357666, -82.7472229003906, -1.44421148649347, 218, 41, 'PPL', 'P'),
(114354, 'Adelphi', 41.5333290100098, 0.724893340538747, -93.4261093139648, -1.63059321485683, 218, 16, 'PPL', 'P'),
(44288, 'Adelphi Park', 38.9863891601563, 0.680440854308554, -76.9683303833008, -1.34335078495139, 218, 25, 'PPL', 'P'),
(144717, 'Adelphia', 40.2180595397949, 0.701937557732537, -74.2566680908203, -1.29602334974543, 218, 37, 'PPL', 'P'),
(26330, 'Aden', 38.2416687011719, 0.667443030292313, -88.4583282470703, -1.54388907872128, 218, 18, 'PPL', 'P'),
(34508, 'Aden', 38.2794418334961, 0.668102295820162, -83.0472183227539, -1.44944739435462, 218, 21, 'PPL', 'P'),
(99302, 'Aden', 38.6549987792969, 0.674657001053119, -77.5374984741211, -1.35328464213349, 218, 53, 'PPL', 'P'),
(112687, 'Aden', 33.1586112976074, 0.578726942532239, -86.9966735839844, -1.5183783923233, 218, 2, 'PPL', 'P'),
(146714, 'Aden', 41.8605613708496, 0.730604622654477, -74.6736068725586, -1.30330030426601, 218, 40, 'PPL', 'P'),
(187988, 'Aden', 32.1527786254883, 0.561171850679627, -107.126937866211, -1.86971778334477, 218, 38, 'PPL', 'P'),
(154022, 'Adena', 40.2186088562012, 0.701947145112461, -80.8730621337891, -1.41150121040457, 218, 41, 'PPL', 'P'),
(194079, 'Adena', 40.0083312988281, 0.69827710939325, -103.886108398438, -1.81315463863647, 218, 7, 'PPL', 'P'),
(26331, 'Adenmoor', 39.3658294677734, 0.687063336991254, -87.7966690063477, -1.53234094644442, 218, 18, 'PPL', 'P'),
(187989, 'Adero Az', 35.3536109924316, 0.617036914287192, -104.458610534668, -1.82314668588839, 218, 38, 'PPL', 'P'),
(18745, 'Adgateville', 33.2230606079102, 0.579851795197661, -83.6711120605469, -1.46033639426168, 218, 13, 'PPL', 'P'),
(79493, 'Adger', 34.4363899230957, 0.601028386658617, -81.1258316040039, -1.41591286990834, 218, 48, 'PPL', 'P'),
(112554, 'Adger', 33.3769416809082, 0.582537526577979, -87.0936126708984, -1.52007029856383, 218, 2, 'PPL', 'P'),
(99303, 'Adial', 37.8647193908691, 0.660864023714408, -78.8305587768555, -1.37585280184304, 218, 53, 'PPL', 'P'),
(44289, 'Adil Meadows', 39.2938919067383, 0.685807789695336, -76.7555618286133, -1.33963727312738, 218, 25, 'PPL', 'P'),
(193336, 'Adin', 41.1938896179199, 0.718969005535812, -120.94416809082, -2.11087394427028, 218, 6, 'PPL', 'P'),
(92119, 'Adina', 30.4213905334473, 0.530953427843689, -97.1722183227539, -1.69597515119882, 218, 51, 'PPL', 'P'),
(146716, 'Adirondack', 43.7638893127441, 0.763823961985744, -73.7588882446289, -1.28733545247932, 218, 40, 'PPL', 'P'),
(189855, 'Adits Mill (historical)', 39.2275009155273, 0.684649048305042, -117.135559082031, -2.04440117714579, 218, 39, 'PPL', 'P'),
(112692, 'Adkin Hill', 32.6088905334473, 0.569132505231065, -86.3111114501953, -1.50641307586169, 218, 2, 'PPL', 'P'),
(92120, 'Adkins', 29.3927803039551, 0.513000792619356, -98.2369384765625, -1.71455802349512, 218, 51, 'PPL', 'P'),
(206645, 'Adkins', 46.252498626709, 0.807258388310227, -118.70361328125, -2.07176888577188, 218, 56, 'PPL', 'P'),
(92121, 'Adkins Colonia', 26.19700050354, 0.457223912933386, -98.120002746582, -1.71251710999374, 218, 51, 'PPL', 'P'),
(84588, 'Adkins Mill', 36.1816711425781, 0.631489290311807, -84.8619384765625, -1.48112023604088, 218, 50, 'PPL', 'P'),
(107920, 'Adlai', 39.3377799987793, 0.68657378140387, -81.0633316040039, -1.41482203912584, 218, 58, 'PPL', 'P'),
(112691, 'Adler', 32.7630615234375, 0.571823296617454, -87.168327331543, -1.52137431539159, 218, 2, 'PPL', 'P'),
(62444, 'Adley', 36.1336097717285, 0.630650461147459, -81.2125015258789, -1.41742554540751, 218, 33, 'PPL', 'P'),
(107916, 'Adma (historical)', 39.0758285522461, 0.682001866181503, -80.0380630493164, -1.39692772712938, 218, 58, 'PPL', 'P'),
(141134, 'Admah (historical)', 41.6694412231445, 0.727268946810125, -96.3958282470703, -1.68242458809833, 218, 35, 'PPL', 'P'),
(92122, 'Admiral', 32.2963905334473, 0.563678351318583, -99.2975006103516, -1.73306832465171, 218, 51, 'PPL', 'P'),
(44298, 'Admiral (historical)', 39.0900001525879, 0.682249207267745, -76.7347183227539, -1.33927348532248, 218, 25, 'PPL', 'P'),
(107917, 'Admiral (historical)', 39.2830581665039, 0.68561870525794, -81.0250015258789, -1.41415305306002, 218, 58, 'PPL', 'P'),
(44290, 'Admiral Heights', 38.9847183227539, 0.680411692694617, -76.5188903808594, -1.33550657711861, 218, 25, 'PPL', 'P'),
(192986, 'Admiral Trailer Park', 33.4508285522461, 0.583827095756822, -111.991668701172, -1.95462335363813, 218, 5, 'PPL', 'P'),
(124093, 'Admirals Hill', 42.3899993896484, 0.739845059267752, -71.0480575561523, -1.24002253150129, 218, 23, 'PPL', 'P'),
(44291, 'Admirals Walk', 39.0344390869141, 0.681279483735819, -76.4475021362305, -1.33426061720262, 218, 25, 'PPL', 'P'),
(126737, 'Admiralty Village', 43.0924987792969, 0.752105986610368, -70.7302780151367, -1.2344762322151, 218, 26, 'PPL', 'P'),
(31600, 'Admire', 38.6411094665527, 0.674414586814895, -96.102783203125, -1.67730998722483, 218, 20, 'PPL', 'P'),
(77768, 'Admire', 39.9619407653809, 0.697467441842839, -76.8708267211914, -1.34164902501483, 218, 45, 'PPL', 'P'),
(193242, 'Adna', 46.6291694641113, 0.813832534619143, -123.059997558594, -2.14780213489364, 218, 56, 'PPL', 'P'),
(194080, 'Adna', 40.3394393920898, 0.704056035800668, -104.827781677246, -1.82958993782973, 218, 7, 'PPL', 'P'),
(39040, 'Adner', 32.5669403076172, 0.568400335668375, -93.607780456543, -1.63376397445068, 218, 22, 'PPL', 'P'),
(99304, 'Adner', 37.4986114501953, 0.654474234731954, -76.6336135864258, -1.33750887478419, 218, 53, 'PPL', 'P'),
(192985, 'Adobe', 33.6891708374023, 0.587986953379526, -112.121940612793, -1.95689702741879, 218, 5, 'PPL', 'P'),
(191038, 'Adobe Colonia', 31.6509990692139, 0.552414145303443, -106.302001953125, -1.85531993554347, 218, 51, 'PPL', 'P'),
(179615, 'Adobe Corner', 37.4261093139648, 0.653208833740003, -122.265281677246, -2.13393172614624, 218, 6, 'PPL', 'P'),
(191039, 'Adobe Crossing', 31.0527801513672, 0.541973255539301, -102.306938171387, -1.78559291872497, 218, 51, 'PPL', 'P'),
(192988, 'Adobe Mountain Trailer Park', 33.6861114501953, 0.58793355699967, -112.114440917969, -1.95676613305121, 218, 5, 'PPL', 'P'),
(187990, 'Adobe Ranch', 33.8622207641602, 0.591007244371785, -106.304443359375, -1.85536254612092, 218, 38, 'PPL', 'P'),
(191040, 'Adobes', 29.7590408325195, 0.5193932447629, -104.553131103516, -1.82479638102564, 218, 51, 'PPL', 'P'),
(39041, 'Adois (historical)', 31.6944408416748, 0.553172347265788, -93.3180618286133, -1.62870743048894, 218, 22, 'PPL', 'P'),
(107918, 'Adolph', 38.7444381713867, 0.676218012926069, -80.0458297729492, -1.39706328202887, 218, 58, 'PPL', 'P'),
(133854, 'Adolph', 46.7786102294922, 0.816440768011739, -92.2799987792969, -1.61058981243508, 218, 28, 'PPL', 'P'),
(34510, 'Adolphus', 36.651668548584, 0.639692292522442, -86.2613906860352, -1.50554528482048, 218, 21, 'PPL', 'P'),
(84589, 'Adolphus', 35.7411117553711, 0.623800078454476, -84.4255599975586, -1.47350399479741, 218, 50, 'PPL', 'P'),
(209252, 'Adon', 44.5183296203613, 0.776991429363422, -105.232498168945, -1.836653573147, 218, 59, 'PPL', 'P'),
(7028, 'Adona', 35.0380592346191, 0.611529497152908, -92.8977813720703, -1.62137215274048, 218, 4, 'PPL', 'P'),
(107919, 'Adonijah', 38.3338890075684, 0.669052578276129, -81.1947174072266, -1.41711515398246, 218, 58, 'PPL', 'P'),
(53127, 'Adonis', 37.7963905334473, 0.659671460178271, -93.3630599975586, -1.62949279669441, 218, 29, 'PPL', 'P'),
(107929, 'Adonis', 39.5055618286133, 0.689502126759494, -80.9869384765625, -1.4134887275261, 218, 58, 'PPL', 'P'),
(99305, 'Adria', 37.1686096191406, 0.64871461624244, -81.5461120605469, -1.4232481476568, 218, 53, 'PPL', 'P'),
(18746, 'Adrian', 32.5305595397949, 0.567765371485473, -82.5894393920898, -1.44145764476827, 218, 13, 'PPL', 'P'),
(53128, 'Adrian', 38.3974990844727, 0.670162783555556, -94.3513870239258, -1.64674235739096, 218, 29, 'PPL', 'P'),
(79492, 'Adrian', 33.9466705322266, 0.592481170877089, -79.0177764892578, -1.37912036734251, 218, 48, 'PPL', 'P'),
(107921, 'Adrian', 38.9052810668945, 0.679025251031122, -80.2758331298828, -1.401077597898, 218, 58, 'PPL', 'P'),
(118570, 'Adrian', 40.5208282470703, 0.707221868546499, -91.1669387817383, -1.59116325070544, 218, 18, 'PPL', 'P'),
(129428, 'Adrian', 41.8974990844727, 0.731249307375358, -84.0372161865234, -1.46672611666511, 218, 27, 'PPL', 'P'),
(133855, 'Adrian', 43.6349983215332, 0.761574389812954, -95.932502746582, -1.67433803260636, 218, 28, 'PPL', 'P'),
(139565, 'Adrian', 46.5999984741211, 0.813323404797747, -98.5530624389648, -1.72007542748349, 218, 34, 'PPL', 'P'),
(146715, 'Adrian', 42.2544403076172, 0.737479106955326, -77.521110534668, -1.35299861863242, 218, 40, 'PPL', 'P'),
(154023, 'Adrian', 41.0013885498047, 0.715609228083595, -83.3230590820313, -1.45426172381521, 218, 41, 'PPL', 'P'),
(158554, 'Adrian', 40.8847198486328, 0.71357297511412, -79.5380630493164, -1.38820108086941, 218, 45, 'PPL', 'P'),
(191041, 'Adrian', 35.2747192382813, 0.615659993424594, -102.66471862793, -1.79183736569093, 218, 51, 'PPL', 'P'),
(200295, 'Adrian', 43.7408294677734, 0.763421491766005, -117.070831298828, -2.04327146421138, 218, 43, 'PPL', 'P'),
(206646, 'Adrian', 47.3911094665527, 0.827130896364399, -119.916389465332, -2.09293582327389, 218, 56, 'PPL', 'P'),
(158555, 'Adrian Furnace', 41.1319389343262, 0.717887762133239, -78.7838897705078, -1.37503827402364, 218, 45, 'PPL', 'P'),
(158556, 'Adrian Mines', 40.9847183227539, 0.715318277734504, -78.960563659668, -1.37812181509179, 218, 45, 'PPL', 'P'),
(99306, 'Adsit', 36.827220916748, 0.642756259356578, -77.6983337402344, -1.35609174708049, 218, 53, 'PPL', 'P'),
(92123, 'Adsul', 30.6427803039551, 0.534817408269285, -93.8427810668945, -1.63786550884551, 218, 51, 'PPL', 'P'),
(7029, 'Advance', 36.1552810668945, 0.631028696601278, -92.3822174072266, -1.61237386404932, 218, 4, 'PPL', 'P'),
(26333, 'Advance', 39.1566696166992, 0.683412808927027, -88.0288925170898, -1.53639401130742, 218, 18, 'PPL', 'P'),
(29072, 'Advance', 39.9958305358887, 0.698058929920945, -86.620002746582, -1.51180424601439, 218, 19, 'PPL', 'P'),
(53129, 'Advance', 37.1044387817383, 0.647594623846007, -89.9105606079102, -1.56923531492195, 218, 29, 'PPL', 'P'),
(62448, 'Advance', 35.9411087036133, 0.627290683695243, -80.4094390869141, -1.40340946174847, 218, 33, 'PPL', 'P'),
(92124, 'Advance', 32.9411087036133, 0.574930806135413, -97.9269409179688, -1.70914754542451, 218, 51, 'PPL', 'P'),
(129431, 'Advance', 45.2213897705078, 0.789262143823044, -85.0774993896484, -1.48488248371283, 218, 27, 'PPL', 'P'),
(154024, 'Advance', 41.6405601501465, 0.726764876994801, -84.1127777099609, -1.46804491403691, 218, 41, 'PPL', 'P'),
(158559, 'Advance', 40.708610534668, 0.710499287742005, -79.2622222900391, -1.38338675140882, 218, 45, 'PPL', 'P'),
(172849, 'Advance', 44.7877807617188, 0.781694238953366, -88.3322219848633, -1.54168810923839, 218, 57, 'PPL', 'P'),
(179617, 'Advance', 36.5158309936523, 0.637321479941026, -118.901672363281, -2.07522566886681, 218, 6, 'PPL', 'P'),
(99307, 'Advance Mills', 38.1830596923828, 0.666420110117613, -78.4388885498047, -1.36901686679897, 218, 53, 'PPL', 'P'),
(99308, 'Advance Mills Village', 38.1972198486328, 0.666667251466773, -78.4250030517578, -1.36877451913977, 218, 53, 'PPL', 'P'),
(107922, 'Advent', 38.610279083252, 0.673876495116644, -81.5588912963867, -1.42347118739809, 218, 58, 'PPL', 'P'),
(62445, 'Advent Crossroads', 35.6691703796387, 0.622544464579531, -81.4261093139648, -1.42115370461751, 218, 33, 'PPL', 'P'),
(194497, 'Advent Hollow (historical)', 46.8375015258789, 0.817468615034455, -116.983329772949, -2.04174427448427, 218, 17, 'PPL', 'P'),
(14945, 'Adventura', 25.9650001525879, 0.453174742943489, -80.1430587768555, -1.39876024827547, 218, 12, 'PPL', 'P'),
(18747, 'Adventure (historical)', 33.3933296203613, 0.582823550079053, -82.019172668457, -1.43150461282632, 218, 13, 'PPL', 'P'),
(202821, 'Adventure Condominium', 40.6091690063477, 0.708763705659601, -111.794998168945, -1.95119080530913, 218, 52, 'PPL', 'P'),
(189856, 'Adverse', 39.3813896179199, 0.687334912843414, -114.774719238281, -2.00319674876009, 218, 39, 'PPL', 'P'),
(112693, 'Adville', 33.8838882446289, 0.591385413246576, -86.6447219848633, -1.51223567811098, 218, 2, 'PPL', 'P'),
(44292, 'Advocate Hill Farms', 39.5994415283203, 0.691140636620165, -76.4613876342773, -1.33450296486182, 218, 25, 'PPL', 'P'),
(44293, 'Advocates Choice', 39.6416702270508, 0.691877666451844, -76.9833297729492, -1.34361257368654, 218, 25, 'PPL', 'P'),
(99309, 'Adwolf', 36.7891693115234, 0.642092133559739, -81.5822219848633, -1.42387838472877, 218, 53, 'PPL', 'P'),
(44294, 'Ady', 39.6386108398438, 0.691824270071988, -76.3330612182617, -1.33226324638506, 218, 25, 'PPL', 'P'),
(191042, 'Ady', 35.4855613708496, 0.619339882839838, -102.131942749023, -1.78253867242881, 218, 51, 'PPL', 'P'),
(44295, 'Ady Estates', 39.667781829834, 0.692333399893384, -76.3541717529297, -1.33263169472187, 218, 25, 'PPL', 'P'),
(29073, 'Adyeville', 38.1908302307129, 0.666555731596126, -86.7694396972656, -1.51441241282796, 218, 19, 'PPL', 'P'),
(53130, 'Aeiker Ford', 38.3788909912109, 0.669838011060621, -91.0727767944336, -1.58951981399675, 218, 29, 'PPL', 'P'),
(206647, 'Aeneas', 48.5475006103516, 0.847313729264591, -118.977500915527, -2.07654912677052, 218, 56, 'PPL', 'P'),
(18748, 'Aerial', 34.6644401550293, 0.605008614065795, -83.6444396972656, -1.45987087370313, 218, 13, 'PPL', 'P'),
(179618, 'Aerial Acres', 35.0877799987793, 0.612397288194111, -117.791107177734, -2.05584264982099, 218, 6, 'PPL', 'P'),
(44296, 'Aero Acres', 39.332218170166, 0.686476709182136, -76.4533309936523, -1.33436234995626, 218, 25, 'PPL', 'P'),
(191043, 'Aero Vista', 31.8241691589355, 0.55543653353506, -106.388061523438, -1.85682195839828, 218, 51, 'PPL', 'P'),
(84591, 'Aethra', 35.5611114501953, 0.620658480474564, -87.3241729736328, -1.52409433497094, 218, 50, 'PPL', 'P'),
(7031, 'Aetna', 35.9363899230957, 0.627208325438532, -91.4400024414063, -1.59592911063419, 218, 4, 'PPL', 'P'),
(31602, 'Aetna', 37.0838890075684, 0.6472359626262, -98.9625015258789, -1.7272214876365, 218, 20, 'PPL', 'P'),
(84590, 'Aetna', 35.6549987792969, 0.622297123493289, -87.5047225952148, -1.52724552033078, 218, 50, 'PPL', 'P'),
(122114, 'Aetna', 41.5919418334961, 0.725916327292474, -87.289436340332, -1.52348806634878, 218, 19, 'PPL', 'P'),
(129432, 'Aetna', 43.5677795410156, 0.760401200773747, -85.9208297729492, -1.49960137558354, 218, 27, 'PPL', 'P'),
(179619, 'Aetna Springs', 38.6536102294922, 0.6746327662872, -122.481666564941, -2.13770835488808, 218, 6, 'PPL', 'P'),
(34511, 'Aetnaville', 37.672779083252, 0.657514033379198, -86.7905578613281, -1.51478099432282, 218, 21, 'PPL', 'P'),
(154025, 'Aetnaville', 40.0833282470703, 0.699586053069024, -80.7375030517578, -1.40913525809214, 218, 41, 'PPL', 'P'),
(39042, 'Afeman', 31.1025009155273, 0.542841046580503, -92.8183288574219, -1.61998544476088, 218, 22, 'PPL', 'P'),
(107923, 'Affinity', 37.7127799987793, 0.658212181058962, -81.2261123657227, -1.41766309937674, 218, 58, 'PPL', 'P'),
(53131, 'Affton', 38.5505599975586, 0.672834200445015, -90.3330612182617, -1.57660934166427, 218, 29, 'PPL', 'P'),
(34512, 'Aflex', 37.6580581665039, 0.657257104913032, -82.2474975585938, -1.43548963392346, 218, 21, 'PPL', 'P'),
(212252, 'Afognak', 58.0077781677246, 1.01242672079328, -152.76806640625, -2.6663057506944, 218, 1, 'PPL', 'P'),
(118572, 'Afolkey', 42.4324989318848, 0.740586816210366, -89.5744400024414, -1.56336890367272, 218, 18, 'PPL', 'P'),
(99310, 'Afredton', 37.1305618286133, 0.648050557024628, -81.783332824707, -1.42738843104549, 218, 53, 'PPL', 'P'),
(29074, 'Africa', 37.8402786254883, 0.660437451886805, -87.0727767944336, -1.51970664391698, 218, 19, 'PPL', 'P'),
(154026, 'Africa', 40.1822204589844, 0.701312047771504, -82.9572219848633, -1.44787666194369, 218, 41, 'PPL', 'P'),
(58421, 'Africa (historical)', 34.0638885498047, 0.594527011226488, -90.6513900756836, -1.58216522833039, 218, 30, 'PPL', 'P'),
(570, 'Afton', 32.2447204589844, 0.562776538394455, -91.1913909912109, -1.59159002227013, 218, 22, 'PPL', 'P'),
(800, 'Afton', 39.0613899230957, 0.681749864563355, -84.1002807617188, -1.46782680114364, 218, 41, 'PPL', 'P'),
(13262, 'Afton', 39.8269386291504, 0.695111210068391, -75.4811096191406, -1.31739388591277, 218, 10, 'PPL', 'P'),
(18749, 'Afton', 34.5002784729004, 0.602143452207033, -84.2455596923828, -1.4703623968175, 218, 13, 'PPL', 'P'),
(62446, 'Afton', 36.3386116027832, 0.634228418071981, -78.2163925170898, -1.36513357845547, 218, 33, 'PPL', 'P'),
(74940, 'Afton', 36.6936111450195, 0.640424328927077, -94.9627838134766, -1.65741324440474, 218, 42, 'PPL', 'P'),
(84592, 'Afton', 36.1938896179199, 0.631702542936095, -82.7388916015625, -1.44406607789795, 218, 50, 'PPL', 'P'),
(99312, 'Afton', 38.0322189331055, 0.663787442222015, -78.8394393920898, -1.37600779781848, 218, 53, 'PPL', 'P'),
(107924, 'Afton', 39.535831451416, 0.690030431340738, -79.5388870239258, -1.3882154619393, 218, 58, 'PPL', 'P'),
(114355, 'Afton', 41.0275001525879, 0.716064961525135, -94.1977767944336, -1.64406135312158, 218, 16, 'PPL', 'P'),
(129434, 'Afton', 45.3738899230957, 0.791923773595497, -84.4966735839844, -1.47474516102344, 218, 27, 'PPL', 'P'),
(133859, 'Afton', 44.9027786254883, 0.783701330308904, -92.783332824707, -1.61937464876487, 218, 28, 'PPL', 'P'),
(144718, 'Afton', 40.7724990844727, 0.711614353290421, -74.3899993896484, -1.29835041990594, 218, 37, 'PPL', 'P'),
(146717, 'Afton', 42.2280616760254, 0.737018712981878, -75.5269393920898, -1.31819376634617, 218, 40, 'PPL', 'P'),
(172850, 'Afton', 42.603889465332, 0.74357814532577, -89.0711135864258, -1.55458420050098, 218, 57, 'PPL', 'P'),
(179621, 'Afton', 35.0363883972168, 0.611500335538972, -116.378890991211, -2.0311948276162, 218, 6, 'PPL', 'P'),
(187991, 'Afton', 32.0727806091309, 0.559775621899126, -106.94361114502, -1.86651812845309, 218, 38, 'PPL', 'P'),
(191044, 'Afton', 33.7627792358398, 0.58927166228938, -100.816390991211, -1.75957796277458, 218, 51, 'PPL', 'P'),
(209253, 'Afton', 42.7249984741211, 0.745691896282966, -110.931106567383, -1.93611305248154, 218, 59, 'PPL', 'P'),
(199802, 'Afton (historical)', 41.4777793884277, 0.723923816743904, -115.113891601563, -2.00911642323111, 218, 39, 'PPL', 'P'),
(118573, 'Afton Center', 41.8491706848145, 0.730405817679102, -88.7736129760742, -1.54939183532366, 218, 18, 'PPL', 'P'),
(114356, 'Afton Junction (historical)', 41.0166702270508, 0.715875943666766, -94.1233291625977, -1.64276199682573, 218, 16, 'PPL', 'P'),
(126738, 'Agamenticus Station', 43.2438888549805, 0.75474824188589, -70.7755584716797, -1.23526652526858, 218, 26, 'PPL', 'P'),
(126739, 'Agamenticus Village', 43.2152786254883, 0.7542488991815, -70.6705627441406, -1.23343400412249, 218, 26, 'PPL', 'P'),
(201849, 'Agar', 44.8383293151855, 0.782576477643482, -100.074172973633, -1.74662381460022, 218, 49, 'PPL', 'P'),
(129435, 'Agate', 46.4741706848145, 0.81112729558384, -89.0699996948242, -1.55456475942503, 218, 27, 'PPL', 'P'),
(139568, 'Agate', 48.6227798461914, 0.848627599788382, -99.4927825927734, -1.7364766382148, 218, 34, 'PPL', 'P'),
(186316, 'Agate', 39.461669921875, 0.688736068471932, -103.941673278809, -1.81412442874742, 218, 7, 'PPL', 'P'),
(192464, 'Agate', 39.0149993896484, 0.680940197012943, -109.243057250977, -1.90665103397421, 218, 52, 'PPL', 'P'),
(199135, 'Agate', 42.4199981689453, 0.740368636738062, -103.793327331543, -1.81153530353565, 218, 35, 'PPL', 'P'),
(206648, 'Agate', 47.2136116027832, 0.824032974226364, -123.011108398438, -2.14694885808038, 218, 56, 'PPL', 'P'),
(206649, 'Agate Bay', 48.7561111450195, 0.850954669948893, -122.35417175293, -2.13548315063926, 218, 56, 'PPL', 'P'),
(200296, 'Agate Beach', 44.6775016784668, 0.779769505854539, -124.060562133789, -2.16526528110962, 218, 43, 'PPL', 'P'),
(206650, 'Agate Point', 47.714168548584, 0.832769341024315, -122.551940917969, -2.13893487372812, 218, 56, 'PPL', 'P'),
(194498, 'Agatha', 46.5108299255371, 0.811767120035732, -116.575828552246, -2.03463203647711, 218, 17, 'PPL', 'P'),
(34513, 'Agawam', 37.9144401550293, 0.66173181475561, -84.0880584716797, -1.46761348194032, 218, 21, 'PPL', 'P'),
(74942, 'Agawam', 34.8733291625977, 0.608654415019086, -97.9458312988281, -1.70947724476746, 218, 42, 'PPL', 'P'),
(124094, 'Agawam', 42.0694389343262, 0.734250223870686, -72.6152801513672, -1.26737572589944, 218, 23, 'PPL', 'P'),
(195840, 'Agawam', 48, 0.837758040957278, -112.16667175293, -1.95767773309234, 218, 31, 'PPL', 'P'),
(84594, 'Agee', 36.2999992370605, 0.633554505158136, -84.033332824707, -1.46665833921536, 218, 50, 'PPL', 'P'),
(84593, 'Agee (historical)', 36.2986106872559, 0.633530270392216, -84.0236129760742, -1.46648869585393, 218, 50, 'PPL', 'P'),
(53132, 'Agency', 39.644718170166, 0.691930863094619, -94.7397232055664, -1.65352010236521, 218, 29, 'PPL', 'P'),
(114359, 'Agency', 40.9949989318848, 0.715497708212948, -92.3066711425781, -1.61105533299362, 218, 16, 'PPL', 'P'),
(195841, 'Agency', 47.3280601501465, 0.826030478201978, -114.292503356934, -1.99478049392516, 218, 31, 'PPL', 'P'),
(31605, 'Agenda', 39.7077789306641, 0.693031480994121, -97.4313888549805, -1.70049853031032, 218, 20, 'PPL', 'P'),
(193337, 'Ager', 41.8663902282715, 0.730706355408118, -122.459442138672, -2.13732046547531, 218, 6, 'PPL', 'P'),
(34514, 'Ages', 36.857780456543, 0.643289623943894, -83.2463912963867, -1.4529236185255, 218, 21, 'PPL', 'P'),
(141135, 'Aggies Acres', 41.8672218322754, 0.730720869636059, -99.267219543457, -1.73253982033339, 218, 35, 'PPL', 'P'),
(107925, 'Aggregates', 38.9361114501953, 0.679563342729372, -79.9188919067383, -1.39484779831803, 218, 58, 'PPL', 'P'),
(44297, 'Agner', 38.7555618286133, 0.676412157369536, -75.7897186279297, -1.32278012921745, 218, 25, 'PPL', 'P'),
(34515, 'Agnes', 37.0483283996582, 0.646615312934157, -87.0202789306641, -1.51879038334394, 218, 21, 'PPL', 'P'),
(53134, 'Agnes', 37.5122184753418, 0.654711722122162, -92.4983291625977, -1.61440039648082, 218, 29, 'PPL', 'P'),
(92125, 'Agnes', 32.9791717529297, 0.575595131669333, -97.788330078125, -1.70672832989029, 218, 51, 'PPL', 'P'),
(18750, 'Agnes (historical)', 33.7458305358887, 0.5889758516713, -82.4286117553711, -1.43865067297933, 218, 13, 'PPL', 'P'),
(146719, 'Agnes Corners', 43.1758308410645, 0.753560405460687, -75.6066665649414, -1.31958526801574, 218, 40, 'PPL', 'P'),
(200297, 'Agness', 42.5566711425781, 0.742754030126445, -124.067779541016, -2.16539124862918, 218, 43, 'PPL', 'P'),
(107926, 'Agnew', 38.2125015258789, 0.666933967049944, -81.1430587768555, -1.41621354079541, 218, 58, 'PPL', 'P'),
(118575, 'Agnew', 41.7866706848145, 0.729314986896606, -89.8000030517578, -1.56730572155413, 218, 18, 'PPL', 'P'),
(129436, 'Agnew', 42.9650001525879, 0.749880715782525, -86.1766662597656, -1.50406656462522, 218, 27, 'PPL', 'P'),
(141136, 'Agnew', 41.0169410705566, 0.715880670777701, -96.8144378662109, -1.68973070423285, 218, 35, 'PPL', 'P'),
(179622, 'Agnew', 37.394718170166, 0.652660954924746, -121.958061218262, -2.12856971760747, 218, 6, 'PPL', 'P'),
(206651, 'Agnew', 48.1058311462402, 0.83960514291033, -123.247222900391, -2.15106983355117, 218, 56, 'PPL', 'P'),
(99314, 'Agnewville', 38.6691703796387, 0.67490434213936, -77.2861099243164, -1.34889708423759, 218, 53, 'PPL', 'P'),
(7033, 'Agnos', 36.2772216796875, 0.633156961786415, -91.6913909912109, -1.6003166685301, 218, 4, 'PPL', 'P'),
(179623, 'Agoura', 34.1430587768555, 0.595908792358076, -118.736938476563, -2.07235052015396, 218, 6, 'PPL', 'P'),
(179624, 'Agoura Hills', 34.1363906860352, 0.595792412218439, -118.773612976074, -2.07299061092196, 218, 6, 'PPL', 'P'),
(31607, 'Agra', 39.7616691589355, 0.69397204291211, -99.1188888549805, -1.72995096143772, 218, 20, 'PPL', 'P'),
(74944, 'Agra', 35.894718170166, 0.626481016144831, -96.871940612793, -1.69073431648965, 218, 42, 'PPL', 'P'),
(179625, 'Agra', 33.3333282470703, 0.581776328559407, -117.499168395996, -2.0507473568654, 218, 6, 'PPL', 'P'),
(84595, 'Agreeable (historical)', 36.1916694641113, 0.631663793942234, -83.6166687011719, -1.45938617838474, 218, 50, 'PPL', 'P'),
(14947, 'Agricola', 27.7875003814697, 0.484983372555827, -81.8916702270508, -1.42927927541945, 218, 12, 'PPL', 'P'),
(18751, 'Agricola', 33.1944389343262, 0.57935225275619, -82.7205581665039, -1.44374609909298, 218, 13, 'PPL', 'P'),
(31608, 'Agricola', 38.4194412231445, 0.67054574612031, -95.5347213745117, -1.66739543796063, 218, 20, 'PPL', 'P'),
(58422, 'Agricola', 30.8075008392334, 0.537692323955539, -88.5199966430664, -1.54496539527584, 218, 30, 'PPL', 'P'),
(99315, 'Agricola', 37.5311088562012, 0.655041421465113, -79.2441711425781, -1.38307169945187, 218, 53, 'PPL', 'P'),
(112695, 'Agricola', 32.7683296203613, 0.571915242254089, -85.7386093139648, -1.49642102860976, 218, 2, 'PPL', 'P'),
(114361, 'Agricola (historical)', 41.4991683959961, 0.724297125349706, -92.4749984741211, -1.61399319915015, 218, 16, 'PPL', 'P'),
(187992, 'Agua (historical)', 35.2452812194824, 0.61514620307129, -106.245002746582, -1.85432511171828, 218, 38, 'PPL', 'P'),
(179628, 'Agua Caliente', 38.3241691589355, 0.668882934914691, -122.486938476563, -2.13780036710374, 218, 6, 'PPL', 'P'),
(192989, 'Agua Caliente', 32.985279083252, 0.575701724691963, -113.323608398438, -1.97787008679343, 218, 5, 'PPL', 'P'),
(179629, 'Agua Dulce', 34.4963912963867, 0.602075608178263, -118.324722290039, -2.06515599046911, 218, 6, 'PPL', 'P'),
(191045, 'Agua Dulce', 31.6550006866455, 0.55248398670303, -106.138328552246, -1.8524632958002, 218, 51, 'PPL', 'P'),
(191046, 'Agua Dulce Colonia', 31.6609992980957, 0.552588682223384, -106.144996643066, -1.85257967593984, 218, 51, 'PPL', 'P'),
(191047, 'Agua Dulce Number 2 Colonia', 31.6569995880127, 0.55251887411331, -106.141998291016, -1.85252734482442, 218, 51, 'PPL', 'P'),
(191048, 'Agua Dulce Number 3 Colonia', 31.6620006561279, 0.552606159218037, -106.141998291016, -1.85252734482442, 218, 51, 'PPL', 'P'),
(191049, 'Agua Dulce Number 4 Colonia', 31.6660003662109, 0.552675967328111, -106.141998291016, -1.85252734482442, 218, 51, 'PPL', 'P'),
(191050, 'Agua Dulce Number 5 Colonia', 31.6609992980957, 0.552588682223384, -106.138999938965, -1.852475013709, 218, 51, 'PPL', 'P'),
(92128, 'Agua Dulce Ranch Number 1 Colonia', 27.9699993133545, 0.488168579798589, -98.0270004272461, -1.71089391330933, 218, 51, 'PPL', 'P'),
(92129, 'Agua Dulce Ranch Number 2 Colonia', 27.94700050354, 0.487767174843287, -98.0309982299805, -1.71096368812989, 218, 51, 'PPL', 'P'),
(92130, 'Agua Dulce Ranch Number 3 Colonia', 27.9599990844727, 0.487994042878648, -98.0299987792969, -1.71094624442475, 218, 51, 'PPL', 'P'),
(179631, 'Agua Fria', 34.2388916015625, 0.5975813906807, -117.217498779297, -2.04583129465116, 218, 6, 'PPL', 'P'),
(187994, 'Agua Fria', 36.4300003051758, 0.635823451827856, -105.298332214355, -1.83780259399931, 218, 38, 'PPL', 'P'),
(192990, 'Agua Fria', 33.6055603027344, 0.586527674260217, -112.313888549805, -1.96024715091205, 218, 5, 'PPL', 'P'),
(192991, 'Agua Linda', 31.6788902282715, 0.552900937861195, -111.061111450195, -1.93838206573028, 218, 5, 'PPL', 'P'),
(187995, 'Agua Negra (historical)', 34.8772201538086, 0.608722325626883, -104.693893432617, -1.82725314713124, 218, 38, 'PPL', 'P'),
(92131, 'Agua Nueva', 26.9013900756836, 0.469517830184005, -98.5999984741211, -1.7208946158348, 218, 51, 'PPL', 'P'),
(187998, 'Agua Zarca', 35.5633316040039, 0.620697229468424, -105.271392822266, -1.83733241290886, 218, 38, 'PPL', 'P'),
(179637, 'Aguanga', 33.4427795410156, 0.583686614009321, -116.864166259766, -2.03966447883098, 218, 6, 'PPL', 'P'),
(187999, 'Agudo', 34.4052810668945, 0.600485434691377, -104.303062438965, -1.82043185947316, 218, 38, 'PPL', 'P'),
(212253, 'Aguikchuk', 60.4749984741211, 1.05548783851196, -164.435562133789, -2.86994196660233, 218, 1, 'PPL', 'P'),
(192993, 'Aguila', 33.9427795410156, 0.592413260269292, -113.173332214355, -1.97524727259387, 218, 5, 'PPL', 'P'),
(186317, 'Aguilar', 37.4027786254883, 0.65280163640933, -104.652778625488, -1.82653555837552, 218, 7, 'PPL', 'P'),
(92132, 'Aguilares', 27.4483299255371, 0.479063731374313, -99.0869369506836, -1.72939329550546, 218, 51, 'PPL', 'P'),
(92133, 'Aguilares Acres Colonia', 27.4519996643066, 0.479127780398529, -99.0920028686523, -1.72948171245365, 218, 51, 'PPL', 'P'),
(211642, 'Ah Fong Village', 20.8533306121826, 0.363959279189511, -156.464721679688, -2.7308245565271, 218, 15, 'PPL', 'P'),
(133864, 'Ah-gwah-ching', 47.0741691589355, 0.821599244464195, -94.5625, -1.65042697391714, 218, 28, 'PPL', 'P'),
(18752, 'Ahaluna', 34.3125, 0.598866099590554, -83.8627777099609, -1.46368159090693, 218, 13, 'PPL', 'P'),
(193088, 'Ahan Owuch', 32.1425018310547, 0.56099248678021, -112.342781066895, -1.96075142046446, 218, 5, 'PPL', 'P'),
(118576, 'Ahern', 41.1541709899902, 0.718275784704064, -87.6047210693359, -1.52899082295116, 218, 18, 'PPL', 'P'),
(195842, 'Ahern Trailer Court', 46.7538909912109, 0.816009335915146, -114.086112976074, -1.99117830223472, 218, 31, 'PPL', 'P'),
(129437, 'Ahgosatown', 45.0811080932617, 0.78681376667488, -85.591667175293, -1.49385640448002, 218, 27, 'PPL', 'P'),
(195843, 'Ahles', 46.478889465332, 0.811209653840551, -107.163887023926, -1.87036266780273, 218, 31, 'PPL', 'P'),
(74945, 'Ahloso', 34.7350006103516, 0.606240126332875, -96.6372222900391, -1.68663770894284, 218, 42, 'PPL', 'P'),
(129438, 'Ahmeek', 47.2988891601563, 0.825521348380582, -88.3963928222656, -1.54280810163482, 218, 27, 'PPL', 'P'),
(169698, 'Ahnberg', 44.3041687011719, 0.773253616194469, -97.0566711425781, -1.69395847246336, 218, 49, 'PPL', 'P'),
(62447, 'Aho', 36.1591682434082, 0.631096540630048, -81.6166687011719, -1.42447959334485, 218, 33, 'PPL', 'P'),
(53135, 'Aholt', 39.2644386291504, 0.685293733025923, -92.9047164916992, -1.62149319341203, 218, 29, 'PPL', 'P'),
(62449, 'Ahoskie', 36.2866706848145, 0.633321878036918, -76.9850006103516, -1.34364173530048, 218, 33, 'PPL', 'P'),
(14948, 'Ahosulga (historical)', 30.4333305358887, 0.531161820198988, -83.6833267211914, -1.46054958030694, 218, 12, 'PPL', 'P'),
(99316, 'Ahoy Acres', 36.8008308410645, 0.642295665646049, -76.3974990844727, -1.3333878993134, 218, 53, 'PPL', 'P'),
(99317, 'Ahoy Shores', 36.7986106872559, 0.642256916652188, -76.3897171020508, -1.33325207809781, 218, 53, 'PPL', 'P'),
(158557, 'Ahrensville', 41.4544410705566, 0.723516486255176, -79.6458282470703, -1.39008193838928, 218, 45, 'PPL', 'P'),
(194499, 'Ahsahka', 46.5022201538086, 0.811616851171224, -116.323059082031, -2.03022037697334, 218, 17, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(206652, 'Ahtanum', 46.5597190856934, 0.812620396848993, -120.620826721191, -2.10523057276235, 218, 56, 'PPL', 'P'),
(179639, 'Ahwahnee', 37.3655586242676, 0.652152024840432, -119.725280761719, -2.08960034716662, 218, 6, 'PPL', 'P'),
(179640, 'Ahwahnee Estates', 37.3708305358887, 0.652244037056094, -119.702781677246, -2.08920766406388, 218, 6, 'PPL', 'P'),
(193089, 'Ahwatukee', 33.3416709899902, 0.581921936892007, -111.983329772949, -1.95447781188456, 218, 5, 'PPL', 'P'),
(179641, 'Ahwin (historical)', 34.4602813720703, 0.601445371106296, -120.023330688477, -2.09480229972387, 218, 6, 'PPL', 'P'),
(18753, 'Ai', 34.833610534668, 0.607961194187338, -84.4527816772461, -1.47397910273588, 218, 13, 'PPL', 'P'),
(62451, 'Ai', 36.3199996948242, 0.633903578998018, -78.9619369506836, -1.3781457835416, 218, 33, 'PPL', 'P'),
(112697, 'Ai', 33.6500015258789, 0.587303319927703, -85.4472198486328, -1.49133532303409, 218, 2, 'PPL', 'P'),
(154027, 'Ai', 41.628059387207, 0.726546697522496, -83.9352798461914, -1.46494699189888, 218, 41, 'PPL', 'P'),
(53147, 'Aid', 36.8769416809082, 0.64362405039778, -90.0411071777344, -1.57151378239256, 218, 29, 'PPL', 'P'),
(71630, 'Aid', 38.5961112976074, 0.673629220609431, -82.4933319091797, -1.43978025275569, 218, 41, 'PPL', 'P'),
(146720, 'Aiden Lair', 43.8716697692871, 0.765705085821721, -74.003059387207, -1.29159704285566, 218, 40, 'PPL', 'P'),
(58423, 'Aiken', 34.6308288574219, 0.604421986256678, -89.7397232055664, -1.56625363976549, 218, 30, 'PPL', 'P'),
(79494, 'Aiken', 33.5602798461914, 0.585737381206736, -81.7197189331055, -1.42627815918704, 218, 48, 'PPL', 'P'),
(118577, 'Aiken', 42.3525009155273, 0.739190587429865, -90.415283203125, -1.57804438601766, 218, 18, 'PPL', 'P'),
(158558, 'Aiken', 41.878059387207, 0.730910020652482, -78.5780563354492, -1.37144580287118, 218, 45, 'PPL', 'P'),
(177732, 'Aiken', 34.142219543457, 0.59589414497208, -101.525283813477, -1.77195047656687, 218, 51, 'PPL', 'P'),
(194500, 'Aiken', 43.209171295166, 0.75414230615887, -112.405830383301, -1.96185183862688, 218, 17, 'PPL', 'P'),
(99318, 'Aiken Summit', 36.5950012207031, 0.638703261072614, -79.7050018310547, -1.39111471226001, 218, 53, 'PPL', 'P'),
(18755, 'Aikenton', 33.3722190856934, 0.582455101742241, -83.5486068725586, -1.45819827538051, 218, 13, 'PPL', 'P'),
(44311, 'Aikin', 39.5738906860352, 0.690694690295631, -76.0680618286133, -1.32763813451992, 218, 25, 'PPL', 'P'),
(92135, 'Aikin Grove', 33.5555610656738, 0.585655022950025, -95.0483322143555, -1.6589063456699, 218, 51, 'PPL', 'P'),
(31609, 'Aikins', 39.3680610656738, 0.687102285722196, -96.1161117553711, -1.67754261434605, 218, 20, 'PPL', 'P'),
(53136, 'Aikinsville', 38.5580596923828, 0.672965094812592, -92.8361129760742, -1.62029583618593, 218, 29, 'PPL', 'P'),
(31610, 'Aikman', 37.9897193908691, 0.663045685279401, -96.6805572509766, -1.68739404669242, 218, 20, 'PPL', 'P'),
(194501, 'Aikman (historical)', 43.8166694641113, 0.764745149406802, -116.404167175293, -2.03163598025077, 218, 17, 'PPL', 'P'),
(18756, 'Ailey', 32.1872215270996, 0.561772992716685, -82.5658264160156, -1.44104552058958, 218, 13, 'PPL', 'P'),
(84596, 'Ailor (historical)', 36.2425003051758, 0.632550959480367, -83.7336120605469, -1.46142722504418, 218, 50, 'PPL', 'P'),
(179642, 'Ailsa (historical)', 34.0666694641113, 0.594575547337355, -117.434722900391, -2.049622570779, 218, 6, 'PPL', 'P'),
(77769, 'Ailston', 39.7441711425781, 0.693666644914105, -76.3158264160156, -1.33196244233994, 218, 45, 'PPL', 'P'),
(99319, 'Aily', 37.0869407653809, 0.647289225848002, -82.2855606079102, -1.43615395945738, 218, 53, 'PPL', 'P'),
(18757, 'Aimar', 31.7527809143066, 0.554190573619066, -81.6716690063477, -1.42543952975977, 218, 13, 'PPL', 'P'),
(92136, 'Aimee Acres Colonia', 27.9330005645752, 0.487522829813272, -98.0339965820313, -1.71101601924531, 218, 51, 'PPL', 'P'),
(92137, 'Aimee Acres Number 2 Colonia', 27.9370002746582, 0.487592637923346, -98.036003112793, -1.71105103981365, 218, 51, 'PPL', 'P'),
(200298, 'Aims', 45.4508285522461, 0.793266605996142, -122.206672668457, -2.13290880597154, 218, 43, 'PPL', 'P'),
(39044, 'Aimwell', 31.7833309173584, 0.554723771758814, -91.9933319091797, -1.60558653169515, 218, 22, 'PPL', 'P'),
(112698, 'Aimwell', 32.1213912963867, 0.560624038443398, -87.9061126708984, -1.53425109873628, 218, 2, 'PPL', 'P'),
(7034, 'Ain', 34.2083282470703, 0.597047959514357, -92.3375015258789, -1.61159342469188, 218, 4, 'PPL', 'P'),
(211650, 'Ainaloa', 19.5269393920898, 0.340809385229348, -154.993057250977, -2.70513916676161, 218, 15, 'PPL', 'P'),
(129440, 'Ainger', 42.482780456543, 0.741464394368575, -84.934440612793, -1.48238563703283, 218, 27, 'PPL', 'P'),
(154028, 'Ainger', 41.639720916748, 0.726750229608805, -84.6838912963867, -1.47801272652292, 218, 41, 'PPL', 'P'),
(13265, 'Ainsley Woods', 39.7625007629395, 0.693986557140051, -75.7083282470703, -1.321359599092, 218, 10, 'PPL', 'P'),
(18758, 'Ainslie (historical)', 32.4483299255371, 0.566330193974029, -83.4716720581055, -1.45685550955889, 218, 13, 'PPL', 'P'),
(92138, 'Ainsworth', 30.3138904571533, 0.529077197566215, -95.0305633544922, -1.65859622056096, 218, 51, 'PPL', 'P'),
(114362, 'Ainsworth', 41.288890838623, 0.720627089630495, -91.5522232055664, -1.59788773245789, 218, 16, 'PPL', 'P'),
(122116, 'Ainsworth', 41.4877815246582, 0.724098386953359, -87.2586135864258, -1.52295010780859, 218, 19, 'PPL', 'P'),
(141137, 'Ainsworth', 42.5499992370605, 0.742637583407782, -99.8622207641602, -1.74292455068804, 218, 35, 'PPL', 'P'),
(193338, 'Ainsworth Corner', 41.9986114501953, 0.733014051071699, -121.558609008789, -2.12159796134781, 218, 6, 'PPL', 'P'),
(206653, 'Ainsworth Junction', 46.2097206115723, 0.806511771098624, -119.036666870117, -2.0775817674832, 218, 56, 'PPL', 'P'),
(209254, 'Air Base Acres', 42.8822212219238, 0.748435950891157, -106.440559387207, -1.85773821897132, 218, 59, 'PPL', 'P'),
(188000, 'Air Base City', 32.769718170166, 0.571939477020008, -103.194717407227, -1.80108758942121, 218, 38, 'PPL', 'P'),
(79498, 'Air Base Heights', 34.1980590820313, 0.596868728772995, -79.7402801513672, -1.39173043510404, 218, 48, 'PPL', 'P'),
(177373, 'Air City', 43.2200012207031, 0.754331324017238, -75.4227828979492, -1.31637589258608, 218, 40, 'PPL', 'P'),
(53137, 'Air Line Junction', 39.121940612793, 0.682806673462925, -94.4974975585938, -1.64929246729276, 218, 29, 'PPL', 'P'),
(154029, 'Air Line Junction', 41.6386108398438, 0.726730855111875, -83.5824966430664, -1.45878976345862, 218, 41, 'PPL', 'P'),
(62452, 'Airboro', 35.3591690063477, 0.617133919929898, -77.9916687011719, -1.36121140796006, 218, 33, 'PPL', 'P'),
(192994, 'Aire Libre Mobile Home Park', 33.6377792358398, 0.587090000724387, -112.017219543457, -1.95506929996266, 218, 5, 'PPL', 'P'),
(34516, 'Airedale', 37.6025009155273, 0.656287447960134, -83.6394424438477, -1.45978365517743, 218, 21, 'PPL', 'P'),
(44299, 'Airedele', 38.1183280944824, 0.665290330604174, -76.3483276367188, -1.33252969565212, 218, 25, 'PPL', 'P'),
(44300, 'Airey', 38.5227813720703, 0.672349371968566, -75.9930572509766, -1.32632905768609, 218, 25, 'PPL', 'P'),
(58424, 'Airey', 30.6483306884766, 0.534914280753937, -89.0772171020508, -1.55469072694459, 218, 30, 'PPL', 'P'),
(71632, 'Airhill', 39.8194389343262, 0.694980315700814, -84.3672180175781, -1.47248573515462, 218, 41, 'PPL', 'P'),
(71633, 'Airington (historical)', 39.7333297729492, 0.693477427318655, -81.809440612793, -1.427844097908, 218, 41, 'PPL', 'P'),
(79499, 'Airlee', 34.7480583190918, 0.606468026343158, -81.1999969482422, -1.41720729935617, 218, 48, 'PPL', 'P'),
(99320, 'Airlee Court', 37.3183288574219, 0.651327709904025, -79.9541702270508, -1.39546352116206, 218, 53, 'PPL', 'P'),
(62454, 'Airlie', 34.2150001525879, 0.597164406233021, -77.8269424438477, -1.35833639240526, 218, 33, 'PPL', 'P'),
(99321, 'Airlie', 38.7569389343262, 0.676436192398374, -77.7919387817383, -1.3577254632512, 218, 53, 'PPL', 'P'),
(133866, 'Airlie', 44.0200004577637, 0.768293944717387, -96.4377822875977, -1.68315682424005, 218, 28, 'PPL', 'P'),
(200299, 'Airlie', 44.750560760498, 0.781044627384469, -123.330276489258, -2.1525193921325, 218, 43, 'PPL', 'P'),
(53138, 'Airline Acres', 36.8033294677734, 0.642339274908899, -89.3580627441406, -1.55959240808893, 218, 29, 'PPL', 'P'),
(39046, 'Airline Park Estates', 32.579719543457, 0.568623375409669, -93.7130584716797, -1.63560142244478, 218, 22, 'PPL', 'P'),
(99322, 'Airmont', 39.0847206115723, 0.682157061894028, -77.7872161865234, -1.35764303841546, 218, 53, 'PPL', 'P'),
(146721, 'Airmont', 41.100830078125, 0.717344810165999, -74.1166687011719, -1.29357989944528, 218, 40, 'PPL', 'P'),
(13264, 'Airmont Acres', 39.5311088562012, 0.689948006505, -75.6744384765625, -1.3207681110139, 218, 10, 'PPL', 'P'),
(99323, 'Airpoint', 37.1711082458496, 0.64875822550529, -80.1144409179688, -1.39826077241302, 218, 53, 'PPL', 'P'),
(44301, 'Airport Acres', 39.4638900756836, 0.688774817465793, -77.0158309936523, -1.34417982699873, 218, 25, 'PPL', 'P'),
(99324, 'Airport Acres', 38.1369400024414, 0.665615169678137, -78.4355621337891, -1.36895880988721, 218, 53, 'PPL', 'P'),
(191051, 'Airport Addition Colonia', 28.8610000610352, 0.503719476483348, -100.542999267578, -1.75480637704949, 218, 51, 'PPL', 'P'),
(44302, 'Airport Beach (historical)', 39.2633285522461, 0.685274358528993, -76.438606262207, -1.33410535491107, 218, 25, 'PPL', 'P'),
(92139, 'Airport City', 29.5327796936035, 0.515444242919504, -98.3011093139648, -1.71567801589155, 218, 51, 'PPL', 'P'),
(53139, 'Airport Drive', 37.1425018310547, 0.648258949379927, -94.5105590820313, -1.64952043388207, 218, 29, 'PPL', 'P'),
(34517, 'Airport Gardens', 37.2869415283203, 0.650779897667796, -83.2030563354492, -1.45216728077592, 218, 21, 'PPL', 'P'),
(18759, 'Airport Grove', 33.6469383239746, 0.587249856968819, -83.8450012207031, -1.46337133263993, 218, 13, 'PPL', 'P'),
(92140, 'Airport Heights Colonia', 26.4090003967285, 0.460924009083401, -98.8359985351563, -1.72501359393477, 218, 51, 'PPL', 'P'),
(112694, 'Airport Highlands', 33.5849990844727, 0.586168813303329, -86.7416687011719, -1.51392771750956, 218, 2, 'PPL', 'P'),
(84597, 'Airport Plaza', 35.8175010681152, 0.625133323475197, -83.9786071777344, -1.46570319649041, 218, 50, 'PPL', 'P'),
(209255, 'Airport Road', 43.9933280944824, 0.767828424158841, -107.948608398438, -1.88405863949874, 218, 59, 'PPL', 'P'),
(92141, 'Airport Road Addition', 27.2197208404541, 0.475073750139642, -98.0991668701172, -1.71215345534689, 218, 51, 'PPL', 'P'),
(92142, 'Airport Road Addition Colonia', 27.2140007019043, 0.474973914888278, -98.1119995117188, -1.71237742719456, 218, 51, 'PPL', 'P'),
(18760, 'Airport Subdivision', 31.5194396972656, 0.55011800110109, -84.2041702270508, -1.46964001437182, 218, 13, 'PPL', 'P'),
(7035, 'Airport Village', 35.6377792358398, 0.621996585764274, -91.1949996948242, -1.59165300602991, 218, 4, 'PPL', 'P'),
(107927, 'Airport Village', 38.3666687011719, 0.669624691857306, -81.5819396972656, -1.42387345788075, 218, 58, 'PPL', 'P'),
(126740, 'Airport Village', 43.4700012207031, 0.758694647147224, -70.4841690063477, -1.23018081969291, 218, 26, 'PPL', 'P'),
(211651, 'Airport Village', 20.8222198486328, 0.363416293932758, -156.454162597656, -2.73064026577967, 218, 15, 'PPL', 'P'),
(99326, 'Airview Court', 37.2486114501953, 0.650110911601968, -80.0258331298828, -1.39671427476801, 218, 53, 'PPL', 'P'),
(77770, 'Airville', 39.832218170166, 0.695203355442108, -76.4066696166992, -1.33354795529492, 218, 45, 'PPL', 'P'),
(92143, 'Airville', 31.076940536499, 0.542394933808401, -97.163330078125, -1.69582002206532, 218, 51, 'PPL', 'P'),
(206654, 'Airway Heights', 47.644718170166, 0.831557203254165, -117.592216491699, -2.05237135249813, 218, 56, 'PPL', 'P'),
(44303, 'Airy Estates', 39.4058303833008, 0.687761484671018, -77.1341705322266, -1.34624524158214, 218, 25, 'PPL', 'P'),
(158560, 'Airydale', 40.4844398498535, 0.706586771205543, -77.8677825927734, -1.35904918747102, 218, 45, 'PPL', 'P'),
(158561, 'Aitch', 40.3741683959961, 0.70466217126477, -78.1594390869141, -1.3641395535786, 218, 45, 'PPL', 'P'),
(133867, 'Aitkin', 46.5330581665039, 0.812155076027529, -93.7099990844727, -1.63554802606492, 218, 28, 'PPL', 'P'),
(122117, 'Aix', 41.041389465332, 0.716307375763359, -87.1513900756836, -1.52107870451059, 218, 19, 'PPL', 'P'),
(79500, 'Aix (historical)', 34.0791702270508, 0.59479372680966, -82.1708297729492, -1.43415152863375, 218, 48, 'PPL', 'P'),
(202826, 'Aix La Chapelle Condominium', 40.6666717529297, 0.709767317916397, -111.824996948242, -1.95171438277944, 218, 52, 'PPL', 'P'),
(39048, 'Ajax', 31.8763904571533, 0.556347967128626, -93.3897171020508, -1.62995805093684, 218, 22, 'PPL', 'P'),
(99327, 'Ajax', 36.9808311462402, 0.645437263625961, -79.5772171020508, -1.38888444800513, 218, 53, 'PPL', 'P'),
(107928, 'Ajax', 37.8025016784668, 0.659778119779928, -82.3047180175781, -1.43648831933224, 218, 58, 'PPL', 'P'),
(158562, 'Ajax', 41.3544387817383, 0.721771117055766, -79.7908325195313, -1.39261274037318, 218, 45, 'PPL', 'P'),
(201851, 'Ajax', 43.8974990844727, 0.766155892415244, -103.18138885498, -1.80085496229999, 218, 49, 'PPL', 'P'),
(206655, 'Ajlune', 46.5155601501465, 0.811849678029524, -122.433609008789, -2.13686959230276, 218, 56, 'PPL', 'P'),
(192995, 'Ajo', 32.3716697692871, 0.564992221842373, -112.860000610352, -1.96977860445344, 218, 5, 'PPL', 'P'),
(192997, 'Ak Chin', 33.0327796936035, 0.576530766739305, -112.07250213623, -1.9560341632256, 218, 5, 'PPL', 'P'),
(192998, 'Ak Chut Vaya', 31.6305599212646, 0.552057414875426, -111.808891296387, -1.95143328612638, 218, 5, 'PPL', 'P'),
(192996, 'Ak Komelik', 31.7177791595459, 0.553579677754516, -112.200561523438, -1.95826922117045, 218, 5, 'PPL', 'P'),
(192999, 'Ak-Chin Village', 33.0283317565918, 0.576453135593529, -112.086936950684, -1.95628609826472, 218, 5, 'PPL', 'P'),
(84598, 'Akard Addition', 36.5580596923828, 0.638058509772705, -82.2786102294922, -1.43603265246973, 218, 50, 'PPL', 'P'),
(201852, 'Akaska', 45.3325004577637, 0.791201391149813, -100.120277404785, -1.74742848872358, 218, 49, 'PPL', 'P'),
(188001, 'Akela', 32.2458305358887, 0.562795912891385, -107.404998779297, -1.87457086179922, 218, 38, 'PPL', 'P'),
(133871, 'Akeley', 47.0041694641113, 0.820377519314121, -94.7266693115234, -1.65329226893395, 218, 28, 'PPL', 'P'),
(158563, 'Akeley', 41.9647216796875, 0.732422562993592, -79.1311111450195, -1.38109843024217, 218, 45, 'PPL', 'P'),
(84599, 'Akeman Crossroad', 35.6266708374023, 0.621802707636916, -84.7513885498047, -1.47919077583111, 218, 50, 'PPL', 'P'),
(158564, 'Akerly', 41.8905601501465, 0.731128200124786, -80.4877777099609, -1.40477672865212, 218, 45, 'PPL', 'P'),
(39049, 'Akers', 30.2900009155273, 0.528660246408049, -90.4016723632813, -1.57780683204842, 218, 22, 'PPL', 'P'),
(53141, 'Akers', 37.3761100769043, 0.652336182429811, -91.5536117553711, -1.59791196722381, 218, 29, 'PPL', 'P'),
(179643, 'Akers', 37.9983291625977, 0.663195954143909, -121.282501220703, -2.11677897135531, 218, 6, 'PPL', 'P'),
(44304, 'Akers Acres', 39.4452781677246, 0.688449978391831, -77.477783203125, -1.35224241404089, 218, 25, 'PPL', 'P'),
(34523, 'Akersville', 36.6474990844727, 0.639619521645655, -85.9377822875977, -1.49989725278064, 218, 21, 'PPL', 'P'),
(77771, 'Akersville', 39.978328704834, 0.697753465343913, -78.1980590820313, -1.3648135996505, 218, 45, 'PPL', 'P'),
(195844, 'Akerville (historical)', 47.0638885498047, 0.821419813985751, -109.41667175293, -1.9096811786625, 218, 31, 'PPL', 'P'),
(18761, 'Akes', 33.9672203063965, 0.592839832096896, -85.3180618286133, -1.4890810903294, 218, 13, 'PPL', 'P'),
(212254, 'Akhiok', 56.9455604553223, 0.993887524338855, -154.170272827148, -2.69077886953169, 218, 1, 'PPL', 'P'),
(212255, 'Akiachak', 60.9094390869141, 1.06307025760958, -161.431396484375, -2.81750938474474, 218, 1, 'PPL', 'P'),
(212256, 'Akiak', 60.9122200012207, 1.06311879372045, -161.213882446289, -2.81371304861083, 218, 1, 'PPL', 'P'),
(18762, 'Akin', 31.4558296203613, 0.549007795821663, -81.7044372558594, -1.42601144360387, 218, 13, 'PPL', 'P'),
(26334, 'Akin', 37.9880599975586, 0.663016723402547, -88.7474975585938, -1.54893603530309, 218, 18, 'PPL', 'P'),
(186318, 'Akin', 39.2547187805176, 0.685124089664485, -108.262496948242, -1.88953702817714, 218, 7, 'PPL', 'P'),
(92153, 'Akin Development Colonia', 26.2369995117188, 0.457922027323637, -98.3840026855469, -1.71712477815374, 218, 51, 'PPL', 'P'),
(26335, 'Akin Junction', 38.0099983215332, 0.663399619388273, -88.7613906860352, -1.54917851612034, 218, 18, 'PPL', 'P'),
(18763, 'Akins', 32.3061103820801, 0.563847994680021, -81.6205596923828, -1.42454750395265, 218, 13, 'PPL', 'P'),
(74947, 'Akins', 35.5069389343262, 0.619712991708558, -94.690559387207, -1.65266203186199, 218, 42, 'PPL', 'P'),
(84600, 'Akins Chapel', 35.788890838623, 0.624633980770807, -88.086669921875, -1.53740241725417, 218, 50, 'PPL', 'P'),
(84601, 'Akins Corner', 35.4866714477539, 0.619359257336769, -89.769172668457, -1.56676762985588, 218, 50, 'PPL', 'P'),
(18764, 'Akins Mill', 32.5141716003418, 0.567479347984398, -81.8161087036133, -1.42796047804764, 218, 13, 'PPL', 'P'),
(112700, 'Akinsville', 31.6355590820313, 0.55214466669064, -85.6111068725586, -1.49419569120289, 218, 2, 'PPL', 'P'),
(112699, 'Akka', 30.7772197723389, 0.537163819637213, -88.023063659668, -1.53629227855378, 218, 2, 'PPL', 'P'),
(212257, 'Akokpak', 59.6333312988281, 1.04079797509714, -157.133331298828, -2.74249399579161, 218, 1, 'PPL', 'P'),
(211654, 'Akolea Plantation Estates *', 19.7033290863037, 0.343887966159966, -155.13444519043, -2.70760685182768, 218, 15, 'PPL', 'P'),
(211523, 'Akona', 20.103609085083, 0.350874170068543, -155.611663818359, -2.7159358881369, 218, 15, 'PPL', 'P'),
(139570, 'Akra', 48.7752799987793, 0.851289229560835, -97.7266693115234, -1.70565214649378, 218, 34, 'PPL', 'P'),
(18765, 'Akridge', 30.983060836792, 0.54075642394773, -84.1605606079102, -1.46887888293227, 218, 13, 'PPL', 'P'),
(18766, 'Akridge (historical)', 31.2255592346191, 0.544988819420624, -84.022216796875, -1.46646432792995, 218, 13, 'PPL', 'P'),
(215, 'Akron', 32.8763885498047, 0.573801226359056, -87.7425003051758, -1.53139552425745, 218, 2, 'PPL', 'P'),
(31611, 'Akron', 37.3516693115234, 0.651909610602208, -97.0147171020508, -1.69322623632164, 218, 20, 'PPL', 'P'),
(58425, 'Akron', 32.7408294677734, 0.571435274046629, -88.5247192382813, -1.54504782011157, 218, 30, 'PPL', 'P'),
(107930, 'Akron', 39.4147186279297, 0.687916613804515, -80.8058319091797, -1.41032782162828, 218, 58, 'PPL', 'P'),
(114363, 'Akron', 42.8288917541504, 0.747505176090174, -96.5591735839844, -1.68527550204526, 218, 16, 'PPL', 'P'),
(118578, 'Akron', 40.9038887023926, 0.713907534726062, -89.6538925170898, -1.56475561165232, 218, 18, 'PPL', 'P'),
(122118, 'Akron', 41.038330078125, 0.716253979383503, -86.0280609130859, -1.50147291203959, 218, 19, 'PPL', 'P'),
(129441, 'Akron', 43.5680618286133, 0.760406127621763, -83.5141677856445, -1.45759719992248, 218, 27, 'PPL', 'P'),
(139001, 'Akron', 40.5194396972656, 0.70719763378058, -93.8172225952148, -1.63741942936292, 218, 29, 'PPL', 'P'),
(141139, 'Akron', 41.7413902282715, 0.728524693843125, -98.241943359375, -1.71464537517887, 218, 35, 'PPL', 'P'),
(146722, 'Akron', 43.0208282470703, 0.750855099846358, -78.4955596923828, -1.37000596482783, 218, 40, 'PPL', 'P'),
(154030, 'Akron', 41.0813903808594, 0.717005523443123, -81.519172668457, -1.42277796656635, 218, 41, 'PPL', 'P'),
(158565, 'Akron', 40.1566696166992, 0.700866101446971, -76.2024993896484, -1.32998451259833, 218, 45, 'PPL', 'P'),
(194081, 'Akron', 40.1605606079102, 0.700934012054768, -103.213890075684, -1.80142221561218, 218, 7, 'PPL', 'P'),
(202827, 'Akron', 40.6308288574219, 0.709141741376337, -111.854438781738, -1.95222823971177, 218, 52, 'PPL', 'P'),
(7045, 'Akron (historical)', 35.6661109924316, 0.622491068199674, -91.4486083984375, -1.59607931291967, 218, 4, 'PPL', 'P'),
(146723, 'Akron Junction', 43.0047187805176, 0.750573936614272, -78.5347213745117, -1.3706894651216, 218, 40, 'PPL', 'P'),
(141140, 'Aksarben Mobile Home Park', 41.2361106872559, 0.719705902209436, -96.0111083984375, -1.67570996004191, 218, 35, 'PPL', 'P'),
(212259, 'Akulurak', 60.2775001525879, 1.05204084253404, -162.441390991211, -2.83513711431609, 218, 1, 'PPL', 'P'),
(212258, 'Akumsuk', 62.7230606079102, 1.09472392453599, -164.472213745117, -2.87058165789617, 218, 1, 'PPL', 'P'),
(211655, 'Akupu', 21.3941707611084, 0.373398720515243, -158.103057861328, -2.75941891715128, 218, 15, 'PPL', 'P'),
(212260, 'Akutan', 54.1355590820313, 0.944843748389364, -165.773056030273, -2.89328563882131, 218, 1, 'PPL', 'P'),
(71634, 'Al Bar Meadows', 39.1680603027344, 0.683611613902402, -84.3688888549805, -1.47251489676856, 218, 41, 'PPL', 'P'),
(92144, 'Ala Blanca Colonia', 26.4099998474121, 0.460941452788541, -98.9980010986328, -1.72784107206411, 218, 51, 'PPL', 'P'),
(92145, 'Ala Blanca Colonia Number 1', 26.2220001220703, 0.457660238588482, -98.3550033569336, -1.71661864438857, 218, 51, 'PPL', 'P'),
(92146, 'Ala Blanca Colonia Number 2', 26.2199993133545, 0.457625317888688, -98.3529968261719, -1.71658362382023, 218, 51, 'PPL', 'P'),
(92147, 'Ala Blanca Colonia Number 3', 26.2199993133545, 0.457625317888688, -98.3539962768555, -1.71660106752537, 218, 51, 'PPL', 'P'),
(92148, 'Ala Blanca Colonia Number 4', 26.2199993133545, 0.457625317888688, -98.3550033569336, -1.71661864438857, 218, 51, 'PPL', 'P'),
(92149, 'Ala Blanca Norte Number 1 Colonia', 26.2229995727539, 0.457677682293622, -98.3519973754883, -1.71656618011509, 218, 51, 'PPL', 'P'),
(92150, 'Ala Blanca Norte Number 2 Colonia', 26.2280006408691, 0.457764967398349, -98.3509979248047, -1.71654873640995, 218, 51, 'PPL', 'P'),
(92151, 'Ala Blanca Norte Number 3 Colonia', 26.2250003814697, 0.457712602993416, -98.3539962768555, -1.71660106752537, 218, 51, 'PPL', 'P'),
(92152, 'Ala Blanca Norte Number 4 Colonia', 26.2269992828369, 0.457747490403696, -98.3529968261719, -1.71658362382023, 218, 51, 'PPL', 'P'),
(7036, 'Alabam', 36.1525001525879, 0.630980160490411, -93.6811065673828, -1.63504375651251, 218, 4, 'PPL', 'P'),
(112706, 'Alabama', 32.7502784729004, 0.571600190297132, -86.7502822875977, -1.5140780529531, 218, 2, 'ADM1', 'A'),
(146735, 'Alabama', 43.0963897705078, 0.752173897218165, -78.39111328125, -1.36818303106167, 218, 40, 'PPL', 'P'),
(112702, 'Alabama City', 34.0222206115723, 0.593799768511815, -86.0455627441406, -1.50177837661662, 218, 2, 'PPL', 'P'),
(112701, 'Alabama Fork', 34.851390838623, 0.60827151903336, -86.9738922119141, -1.51798078237255, 218, 2, 'PPL', 'P'),
(71635, 'Alabama Hill', 39.6344413757324, 0.691751499195202, -82.0516662597656, -1.43207173298045, 218, 41, 'PPL', 'P'),
(179645, 'Alabama Hill', 38.3549995422363, 0.669421026612942, -120.590827941895, -2.10470699529204, 218, 6, 'PPL', 'P'),
(179646, 'Alabama Hills', 36.5677795410156, 0.638228153134143, -118.088890075684, -2.06103994184633, 218, 6, 'PPL', 'P'),
(18767, 'Alabama Junction', 32.0758285522461, 0.5598288185419, -81.1402816772461, -1.41616507126357, 218, 13, 'PPL', 'P'),
(39051, 'Alabama Landing', 32.8736114501953, 0.573752756827216, -92.0844421386719, -1.60717670518203, 218, 22, 'PPL', 'P'),
(112704, 'Alabama Port', 30.3627796173096, 0.529930474379476, -88.1147232055664, -1.53789203942059, 218, 2, 'PPL', 'P'),
(112703, 'Alabama Shores', 34.7963905334473, 0.607311582618441, -87.5524978637695, -1.52807935606808, 218, 2, 'PPL', 'P'),
(211656, 'Alabama Village', 20.8658294677734, 0.364177425372303, -156.454162597656, -2.73064026577967, 218, 15, 'PPL', 'P'),
(92154, 'Alabama-Arkansas Colonia', 25.8649997711182, 0.451429407033592, -97.383056640625, -1.69965497403503, 218, 51, 'PPL', 'P'),
(112705, 'Alabaster', 33.2441711425781, 0.580220243534474, -86.8163909912109, -1.51523186749537, 218, 2, 'PPL', 'P'),
(129443, 'Alabaster', 44.1863899230957, 0.771197988728064, -83.5580596923828, -1.45836325821004, 218, 27, 'PPL', 'P'),
(129444, 'Alabaster Junction', 44.2458305358887, 0.772235423130704, -83.563606262207, -1.45846006411566, 218, 27, 'PPL', 'P'),
(14953, 'Alachua', 29.7513904571533, 0.519259720523746, -82.4250030517578, -1.43858768921955, 218, 12, 'PPL', 'P'),
(14950, 'Alachua II (historical)', 29.6166706085205, 0.516908415597315, -82.3666687011719, -1.43756956273481, 218, 12, 'PPL', 'P'),
(14951, 'Alackaway Tolofa (historical)', 29.5333309173584, 0.515453863588941, -82.283332824707, -1.43611507730546, 218, 12, 'PPL', 'P'),
(18768, 'Alaculsy', 34.9886093139648, 0.610666433222641, -84.633056640625, -1.47712549440576, 218, 13, 'PPL', 'P'),
(26342, 'Aladdin', 39.7163887023926, 0.693181749858629, -91.3230590820313, -1.59388806397476, 218, 18, 'PPL', 'P'),
(158567, 'Aladdin', 40.6916694641113, 0.710203610281979, -79.6569366455078, -1.39027581651664, 218, 45, 'PPL', 'P'),
(206657, 'Aladdin', 48.7286109924316, 0.850474701741434, -117.670280456543, -2.05373382571181, 218, 56, 'PPL', 'P'),
(209256, 'Aladdin', 44.6399993896484, 0.779114967437624, -104.183059692383, -1.81833741643387, 218, 59, 'PPL', 'P'),
(14952, 'Aladdin City', 25.5702800750732, 0.446285577967131, -80.4544372558594, -1.40419482795394, 218, 12, 'PPL', 'P'),
(44305, 'Aladdin Village Trailer Park', 39.1744384765625, 0.683722934035967, -76.7836074829102, -1.34012676213574, 218, 25, 'PPL', 'P'),
(112707, 'Alaga', 31.1261100769043, 0.543253104180165, -85.0725021362305, -1.48479526518713, 218, 2, 'PPL', 'P'),
(212262, 'Alaganik', 60.4441719055176, 1.05494981339274, -145.215835571289, -2.53449445675369, 218, 1, 'PPL', 'P'),
(212261, 'Alakanuk', 62.6888885498047, 1.09412750960987, -164.615280151367, -2.87307863773423, 218, 1, 'PPL', 'P'),
(14954, 'Alamana', 28.9427795410156, 0.505146797669576, -81.102783203125, -1.41551059942568, 218, 12, 'PPL', 'P'),
(62455, 'Alamance', 36.0349998474121, 0.628929393292996, -79.4861068725586, -1.38729427451824, 218, 33, 'PPL', 'P'),
(62458, 'Alamance Hills Subdivision', 36.0986099243164, 0.630039598572422, -79.3977813720703, -1.38575270372125, 218, 33, 'PPL', 'P'),
(129446, 'Alamando', 43.7427787780762, 0.763455513648931, -84.5266723632813, -1.47526873849375, 218, 27, 'PPL', 'P'),
(14955, 'Alameda', 25.7630596160889, 0.449650215688337, -80.2977828979492, -1.40146069362081, 218, 12, 'PPL', 'P'),
(31612, 'Alameda', 37.5611114501953, 0.65556506551445, -98.0611114501953, -1.71148926297102, 218, 20, 'PPL', 'P'),
(179648, 'Alameda', 35.2377815246582, 0.615015308703713, -119.002220153809, -2.07698055886711, 218, 6, 'PPL', 'P'),
(188002, 'Alameda', 35.1866683959961, 0.614123216317564, -106.617500305176, -1.86082642057138, 218, 38, 'PPL', 'P'),
(200300, 'Alameda', 45.5552787780762, 0.795089606341328, -122.629440307617, -2.14028749324577, 218, 43, 'PPL', 'P'),
(191052, 'Alameda Estates Colonia', 31.6469993591309, 0.552344337193369, -106.294998168945, -1.85519769644944, 218, 51, 'PPL', 'P'),
(188004, 'Alamillo', 34.2547187805176, 0.597857627064769, -106.915557861328, -1.86602850628668, 218, 38, 'PPL', 'P'),
(188005, 'Alamito', 35.8224983215332, 0.625220542000897, -104.436943054199, -1.8227685170136, 218, 38, 'PPL', 'P'),
(179650, 'Alamitos', 37.250560760498, 0.650144933484894, -121.866111755371, -2.12696489673459, 218, 6, 'PPL', 'P'),
(7039, 'Alamo', 34.4738883972168, 0.601682858496504, -93.4686126708984, -1.63133503837847, 218, 4, 'PPL', 'P'),
(18769, 'Alamo', 32.1469383239746, 0.561069918188905, -82.7780609130859, -1.44474971134977, 218, 13, 'PPL', 'P'),
(29076, 'Alamo', 39.9819412231445, 0.697816515682721, -87.0572204589844, -1.51943513464385, 218, 19, 'PPL', 'P'),
(84602, 'Alamo', 35.7847213745117, 0.62456120989402, -89.1172180175781, -1.55538887462435, 218, 50, 'PPL', 'P'),
(92160, 'Alamo', 26.1833305358887, 0.456985326989229, -98.1227798461914, -1.71256557952558, 218, 51, 'PPL', 'P'),
(129447, 'Alamo', 42.3752784729004, 0.739588130801587, -85.7077789306641, -1.49588293691151, 218, 27, 'PPL', 'P'),
(179651, 'Alamo', 37.8502807617188, 0.660612022096259, -122.031112670898, -2.12984470597935, 218, 6, 'PPL', 'P'),
(186319, 'Alamo', 37.6555595397949, 0.657213495650182, -104.958061218262, -1.83186374476844, 218, 7, 'PPL', 'P'),
(188008, 'Alamo', 34.4208297729492, 0.600756810806456, -107.510276794434, -1.87640830979332, 218, 38, 'PPL', 'P'),
(189857, 'Alamo', 37.3650016784668, 0.652142304302453, -115.163612365723, -2.00998421427232, 218, 39, 'PPL', 'P'),
(197916, 'Alamo', 48.5816688537598, 0.847910077611687, -103.469436645508, -1.80588234464779, 218, 34, 'PPL', 'P'),
(188007, 'Alamo (historical)', 34.8375015258789, 0.608029104795136, -104.277496337891, -1.81998564683252, 218, 38, 'PPL', 'P'),
(191053, 'Alamo Alto', 31.4050006866455, 0.548120663573044, -106.023330688477, -1.85045620444466, 218, 51, 'PPL', 'P'),
(92155, 'Alamo Beach', 28.5798301696777, 0.498812136121686, -96.5860595703125, -1.68574475102933, 218, 51, 'PPL', 'P'),
(193090, 'Alamo Crossing (historical)', 34.2605590820313, 0.597959559555491, -113.581939697266, -1.98237881851894, 218, 5, 'PPL', 'P'),
(92156, 'Alamo Heights', 29.4847202301025, 0.514605447044669, -98.4655609130859, -1.71854823775638, 218, 51, 'PPL', 'P'),
(188009, 'Alamo Hueco', 31.440559387207, 0.548741279975573, -108.426940917969, -1.89240711688392, 218, 38, 'PPL', 'P'),
(179652, 'Alamo Oaks', 37.8394393920898, 0.660422804500809, -121.991943359375, -2.12916107252753, 218, 6, 'PPL', 'P'),
(92157, 'Alamo Orchards Colonia', 26.1620006561279, 0.456613050358349, -98.1289978027344, -1.71267410334, 218, 51, 'PPL', 'P'),
(186320, 'Alamo Placita', 39.7208290100098, 0.69325924784635, -104.975280761719, -1.83216428249745, 218, 7, 'PPL', 'P'),
(191054, 'Alamo Ranchettes Colonia', 30.8570003509521, 0.538556253413161, -102.902000427246, -1.79597871434406, 218, 51, 'PPL', 'P'),
(92158, 'Alamo Rose RV Resort Colonia', 26.1690006256104, 0.456735222873357, -98.1230010986328, -1.71256944110916, 218, 51, 'PPL', 'P'),
(191055, 'Alamo Village', 29.4277801513672, 0.513611655194393, -100.394721984863, -1.7522184502602, 218, 51, 'PPL', 'P'),
(53142, 'Alamode (historical)', 37.313060760498, 0.65123576426739, -90.9961090087891, -1.58818170870704, 218, 29, 'PPL', 'P'),
(188010, 'Alamogordo', 32.8994407653809, 0.574203563420739, -105.959716796875, -1.84934593258621, 218, 38, 'PPL', 'P'),
(179653, 'Alamorio', 32.9791717529297, 0.575595131669333, -115.460563659668, -2.01516699206972, 218, 6, 'PPL', 'P'),
(188011, 'Alamorosa', 33.0055618286133, 0.576055725379862, -105.991668701172, -1.84990359851847, 218, 38, 'PPL', 'P'),
(186321, 'Alamosa', 37.4694404602051, 0.653965104910558, -105.869438171387, -1.84777027332726, 218, 7, 'PPL', 'P'),
(187572, 'Alamota', 38.461109161377, 0.671272988834983, -100.309722900391, -1.75073493637497, 218, 20, 'PPL', 'P'),
(58427, 'Alamucha', 32.3586082458496, 0.564764255253062, -88.4686126708984, -1.54406857577875, 218, 30, 'PPL', 'P'),
(18770, 'Alandale', 34.2058296203613, 0.597004350251507, -83.82861328125, -1.46308530913886, 218, 13, 'PPL', 'P'),
(26336, 'Alandale', 38.9388885498047, 0.679611812261212, -90.2291717529297, -1.57479612843609, 218, 18, 'PPL', 'P'),
(124096, 'Alander', 42.0561103820801, 0.734017596749468, -73.466667175293, -1.2822352326757, 218, 23, 'PPL', 'P'),
(191056, 'Alanreed', 35.2125015258789, 0.614574089490114, -100.73388671875, -1.75813799157317, 218, 51, 'PPL', 'P'),
(129449, 'Alanson', 45.4441719055176, 0.793150425593587, -84.7866668701172, -1.47980649867514, 218, 27, 'PPL', 'P'),
(99328, 'Alanthus', 38.5419387817383, 0.672683731843425, -77.9330596923828, -1.36018848778536, 218, 53, 'PPL', 'P'),
(187574, 'Alanthus', 38.7000007629395, 0.675442433837611, -100.16667175293, -1.74823822285302, 218, 20, 'PPL', 'P'),
(139002, 'Alanthus Grove', 40.3069381713867, 0.703488782488481, -94.5438919067383, -1.6501022014222, 218, 29, 'PPL', 'P'),
(84603, 'Alanthus Hill', 36.5652809143066, 0.638184543871293, -83.3916702270508, -1.45545921419936, 218, 50, 'PPL', 'P'),
(99329, 'Alantic City', 36.8566703796387, 0.643270249446963, -76.3022232055664, -1.33172502152876, 218, 53, 'PPL', 'P'),
(99330, 'Alanton', 36.8824996948242, 0.643721056040486, -76.022216796875, -1.32683798777041, 218, 53, 'PPL', 'P'),
(18771, 'Alapaha', 31.3850002288818, 0.547771589733162, -83.2230606079102, -1.45251642119483, 218, 13, 'PPL', 'P'),
(14956, 'Alapaha (historical)', 30.6000003814697, 0.534070757768168, -83.0500030517578, -1.44949599704451, 218, 12, 'PPL', 'P'),
(13266, 'Alapocas', 39.7708282470703, 0.694131899156542, -75.5597229003906, -1.31876594650638, 218, 10, 'PPL', 'P'),
(62460, 'Alarka', 35.3530616760254, 0.617027326907268, -83.445556640625, -1.45639970953833, 218, 33, 'PPL', 'P'),
(29077, 'Alaska', 39.4702796936035, 0.68888633733644, -86.6413879394531, -1.51217748804116, 218, 19, 'PPL', 'P'),
(129450, 'Alaska', 42.8400001525879, 0.747699054217532, -85.4780578613281, -1.4918735478904, 218, 27, 'PPL', 'P'),
(158569, 'Alaska', 40.7836112976074, 0.711808297996806, -76.4377822875977, -1.33409097384118, 218, 45, 'PPL', 'P'),
(172855, 'Alaska', 44.5405616760254, 0.777379451934247, -87.501106262207, -1.52718240341294, 218, 57, 'PPL', 'P'),
(188012, 'Alaska', 35.0527801513672, 0.611786425619074, -107.595558166504, -1.87789675052657, 218, 38, 'PPL', 'P'),
(212264, 'Alaska', 64.0002822875977, 1.11701564812439, -150.000274658203, -2.61799867168146, 218, 1, 'ADM1', 'A'),
(107931, 'Alaska (historical)', 37.9144401550293, 0.66173181475561, -81.039436340332, -1.41440498809914, 218, 58, 'PPL', 'P'),
(212263, 'Alatna', 66.5572204589844, 1.16164263798501, -152.707214355469, -2.66524368205168, 218, 1, 'PPL', 'P'),
(92161, 'Alazan', 31.5830593109131, 0.551228372828085, -94.7858276367188, -1.65432477648858, 218, 51, 'PPL', 'P'),
(199803, 'Alazon', 41.1336097717285, 0.717916923747176, -115.029167175293, -2.00763770303585, 218, 39, 'PPL', 'P'),
(53143, 'Alba', 37.2383308410645, 0.649931481123524, -94.4172210693359, -1.64789137824327, 218, 29, 'PPL', 'P'),
(92162, 'Alba', 32.792781829834, 0.572342013818774, -95.6341705322266, -1.66913115320109, 218, 51, 'PPL', 'P'),
(129451, 'Alba', 44.9747200012207, 0.784956944183849, -84.9686126708984, -1.48298205195895, 218, 27, 'PPL', 'P'),
(158570, 'Alba', 41.7050018310547, 0.727889596502168, -76.82861328125, -1.34091226149926, 218, 45, 'PPL', 'P'),
(179654, 'Alba', 37.7980613708496, 0.659700621792207, -121.038612365723, -2.11252230782698, 218, 6, 'PPL', 'P'),
(172856, 'Alban', 44.6277809143066, 0.778901714813336, -89.2847213745117, -1.55831235971099, 218, 57, 'PPL', 'P'),
(13267, 'Alban Park', 39.7291717529297, 0.69340485617895, -75.5749969482422, -1.31903252893149, 218, 10, 'PPL', 'P'),
(99331, 'Albano', 38.207218170166, 0.6668417550972, -78.304443359375, -1.3666703555625, 218, 53, 'PPL', 'P'),
(44306, 'Albantown', 39.6408309936523, 0.691863019065849, -76.8091735839844, -1.34057297477638, 218, 25, 'PPL', 'P'),
(18772, 'Albany', 31.5783290863037, 0.551145814834292, -84.1558303833008, -1.46879632493848, 218, 13, 'PPL', 'P'),
(34518, 'Albany', 36.6908302307129, 0.640375792816211, -85.1347198486328, -1.48588116912161, 218, 21, 'PPL', 'P'),
(39052, 'Albany', 30.5041694641113, 0.532398192735057, -90.5822219848633, -1.58095801740826, 218, 22, 'PPL', 'P'),
(71636, 'Albany', 39.2275009155273, 0.684649048305042, -82.2024993896484, -1.43470426771799, 218, 41, 'PPL', 'P'),
(74950, 'Albany', 33.8813896179199, 0.591341803983726, -96.1624984741211, -1.67835221531744, 218, 42, 'PPL', 'P'),
(84604, 'Albany', 36.2419395446777, 0.632541172363361, -82.9111099243164, -1.44707185466227, 218, 50, 'PPL', 'P'),
(92163, 'Albany', 32.723331451416, 0.571129876048624, -99.2969436645508, -1.73305860411374, 218, 51, 'PPL', 'P'),
(114364, 'Albany', 42.8658294677734, 0.748149860811055, -91.7586135864258, -1.60148992414833, 218, 16, 'PPL', 'P'),
(118581, 'Albany', 41.7894401550293, 0.729363323270391, -90.2191696166992, -1.57462155822663, 218, 18, 'PPL', 'P'),
(122119, 'Albany', 40.3008308410645, 0.70338218946585, -85.241943359375, -1.48775257241961, 218, 19, 'PPL', 'P'),
(133878, 'Albany', 45.6300010681152, 0.79639375632714, -94.5697174072266, -1.6505529414367, 218, 28, 'PPL', 'P'),
(139003, 'Albany', 40.2486114501953, 0.702470789161798, -94.3308334350586, -1.64638362959213, 218, 29, 'PPL', 'P'),
(143448, 'Albany', 43.9577789306641, 0.76720797420388, -71.1680603027344, -1.24211697454059, 218, 36, 'PPL', 'P'),
(146725, 'Albany', 42.6525001525879, 0.744426561870043, -73.7566680908203, -1.28729670348545, 218, 40, 'PPL', 'P'),
(158573, 'Albany', 40.0377807617188, 0.698791099483635, -79.8716735839844, -1.39402368311871, 218, 45, 'PPL', 'P'),
(171675, 'Albany', 44.7308311462402, 0.780700280655521, -72.3802795410156, -1.26327419150461, 218, 55, 'PPL', 'P'),
(172858, 'Albany', 42.7077789306641, 0.745391358553951, -89.4369430541992, -1.56096912921445, 218, 57, 'PPL', 'P'),
(179655, 'Albany', 37.8869400024414, 0.661251846548151, -122.296669006348, -2.13447953838247, 218, 6, 'PPL', 'P'),
(200301, 'Albany', 44.6366691589355, 0.779056843946833, -123.104721069336, -2.14858270740915, 218, 43, 'PPL', 'P'),
(209257, 'Albany', 41.1841697692871, 0.718799362174373, -106.131393432617, -1.85234225512866, 218, 59, 'PPL', 'P'),
(39053, 'Albany (historical)', 32.6124992370605, 0.569195488990845, -93.8319396972656, -1.63767629125006, 218, 22, 'PPL', 'P'),
(199136, 'Albany (historical)', 42.9583282470703, 0.749764269063861, -102.288887023926, -1.78527786676801, 218, 35, 'PPL', 'P'),
(171676, 'Albany Center', 44.7366714477539, 0.780802213146244, -72.3499984741211, -1.26274568718629, 218, 55, 'PPL', 'P'),
(139004, 'Albany Junction', 40.2269401550293, 0.702092553707979, -94.3688888549805, -1.64704782196799, 218, 29, 'PPL', 'P'),
(114365, 'Albaton', 42.1855583190918, 0.736276889460237, -96.2905578613281, -1.68058727326229, 218, 16, 'PPL', 'P'),
(53145, 'Albatross', 37.1891708374023, 0.649073477199328, -93.8388900756836, -1.63779759823771, 218, 29, 'PPL', 'P'),
(44307, 'Albatross Mobile Home Park', 38.3525009155273, 0.669377417350092, -75.1580581665039, -1.31175557441091, 218, 25, 'PPL', 'P'),
(18773, 'Albaugh', 32.5455589294434, 0.568027160220627, -83.8258285522461, -1.46303670644897, 218, 13, 'PPL', 'P'),
(169700, 'Albee', 45.0522193908691, 0.786309563701501, -96.5530624389648, -1.6851688424436, 218, 49, 'PPL', 'P'),
(200302, 'Albee (historical)', 45.2127799987793, 0.789111874958537, -118.908058166504, -2.07533712215842, 218, 43, 'PPL', 'P'),
(58426, 'Albeison', 31.4911098480225, 0.549623551955203, -89.279167175293, -1.55821542064731, 218, 30, 'PPL', 'P'),
(39054, 'Albemarle', 29.8824996948242, 0.521548008400883, -90.9747161865234, -1.58780833352221, 218, 22, 'PPL', 'P'),
(62462, 'Albemarle', 35.3499984741211, 0.616973863948385, -80.2002792358398, -1.39975893368425, 218, 33, 'PPL', 'P'),
(62463, 'Albemarle Beach', 35.9358291625977, 0.627198538321526, -76.6416702270508, -1.33764948968975, 218, 33, 'PPL', 'P'),
(99333, 'Alberene', 37.8863906860352, 0.661242259168227, -78.6166687011719, -1.37211971578502, 218, 53, 'PPL', 'P'),
(179656, 'Alberhill', 33.7272186279297, 0.588651012597337, -117.398887634277, -2.048997127397, 218, 6, 'PPL', 'P'),
(26337, 'Albers', 38.5433311462402, 0.672708033188372, -89.6122207641602, -1.56402830235862, 218, 18, 'PPL', 'P'),
(7042, 'Albert', 34.3711090087891, 0.599889019765254, -93.8744430541992, -1.6384181147717, 218, 4, 'PPL', 'P'),
(31621, 'Albert', 38.4527816772461, 0.671127646818492, -99.0111083984375, -1.72806983760174, 218, 20, 'PPL', 'P'),
(74952, 'Albert', 35.232780456543, 0.614928023598986, -98.4111099243164, -1.71759788872139, 218, 42, 'PPL', 'P'),
(92170, 'Albert', 30.1936092376709, 0.526977894257932, -98.6013870239258, -1.72091885060072, 218, 51, 'PPL', 'P'),
(158576, 'Albert', 41.1202812194824, 0.717684296625957, -75.9313888549805, -1.32525274113154, 218, 45, 'PPL', 'P'),
(188013, 'Albert', 35.934440612793, 0.627174303555606, -103.864723205566, -1.81278139660969, 218, 38, 'PPL', 'P'),
(18774, 'Albert (historical)', 34.4613914489746, 0.601464745603226, -83.9433288574219, -1.46508747364638, 218, 13, 'PPL', 'P'),
(114366, 'Albert City', 42.7819404602051, 0.746685721422757, -94.9483337402344, -1.65716104304951, 218, 16, 'PPL', 'P'),
(133881, 'Albert Lea', 43.6480598449707, 0.761802356402264, -93.3680572509766, -1.62958001522011, 218, 28, 'PPL', 'P'),
(34519, 'Alberta', 38.4000015258789, 0.670206459397433, -84.4741668701172, -1.47435234476266, 218, 21, 'PPL', 'P'),
(39055, 'Alberta', 32.232780456543, 0.562568146039156, -93.1536102294922, -1.62583720862411, 218, 22, 'PPL', 'P'),
(53146, 'Alberta', 38.3638916015625, 0.669576222325466, -93.6694412231445, -1.63484015784718, 218, 29, 'PPL', 'P'),
(99334, 'Alberta', 36.8655586242676, 0.64342537858046, -77.8866729736328, -1.35937888681398, 218, 53, 'PPL', 'P'),
(112709, 'Alberta', 32.2319412231445, 0.56255349865316, -87.4100036621094, -1.52559236308411, 218, 2, 'PPL', 'P'),
(129455, 'Alberta', 46.6436080932617, 0.814084536237291, -88.4794387817383, -1.54425752705809, 218, 27, 'PPL', 'P'),
(133884, 'Alberta', 45.5733299255371, 0.795404658298285, -96.0472183227539, -1.67634019711388, 218, 28, 'PPL', 'P'),
(92164, 'Alberta Acres Colonia', 26.2469997406006, 0.458096564243578, -98.1050033569336, -1.71225532125858, 218, 51, 'PPL', 'P'),
(92165, 'Alberta Estates Number 2 Colonia', 26.2490005493164, 0.458131484943371, -98.1520004272461, -1.71307557487433, 218, 51, 'PPL', 'P'),
(44308, 'Alberta Heights', 39.1513900756836, 0.683320663553311, -76.6680603027344, -1.33811008340028, 218, 25, 'PPL', 'P'),
(84605, 'Alberton', 35.6997184753418, 0.623077629429764, -88.3163909912109, -1.54141180627529, 218, 50, 'PPL', 'P'),
(112713, 'Alberton', 31.2777805328369, 0.545900253014191, -86.1258316040039, -1.50317933250806, 218, 2, 'PPL', 'P'),
(195845, 'Alberton', 47.0016708374023, 0.820333910051271, -114.472503662109, -1.99792209190508, 218, 31, 'PPL', 'P'),
(44309, 'Alberton (historical)', 39.3175010681152, 0.686219847294998, -76.8138885498047, -1.34065526645406, 218, 25, 'PPL', 'P'),
(146728, 'Alberts Landing', 41.0033302307129, 0.715643116808466, -72.120002746582, -1.25873150447521, 218, 40, 'PPL', 'P'),
(13268, 'Albertson', 39.7402801513672, 0.693598734306308, -75.6277770996094, -1.31995371635255, 218, 10, 'PPL', 'P'),
(62464, 'Albertson', 35.1141700744629, 0.61285788190464, -77.8191680908203, -1.35820070434772, 218, 33, 'PPL', 'P'),
(146729, 'Albertson', 40.7733306884766, 0.711628867518362, -73.6436080932617, -1.28532343427576, 218, 40, 'PPL', 'P'),
(13269, 'Albertson Park', 39.7416687011719, 0.693622969072228, -75.6277770996094, -1.31995371635255, 218, 10, 'PPL', 'P'),
(202832, 'Albertsons Center', 41.2299995422363, 0.719599242607779, -111.945281982422, -1.95381375266675, 218, 52, 'PPL', 'P'),
(112712, 'Albertville', 34.2675018310547, 0.59808073338509, -86.2088928222656, -1.50462902424744, 218, 2, 'PPL', 'P'),
(133887, 'Albertville', 45.2377815246582, 0.789548233903146, -93.654167175293, -1.63457357542206, 218, 28, 'PPL', 'P'),
(172862, 'Albertville', 44.9599990844727, 0.784700015717684, -91.6002807617188, -1.59872649504321, 218, 57, 'PPL', 'P'),
(44310, 'Albeth Heights', 39.3019409179688, 0.685948271442837, -76.9013900756836, -1.34218245618117, 218, 25, 'PPL', 'P'),
(34520, 'Albia', 37.3047218322754, 0.651090222513817, -84.5933303833008, -1.47643214041596, 218, 21, 'PPL', 'P'),
(114367, 'Albia', 41.026668548584, 0.716050447297194, -92.8055572509766, -1.61976253817764, 218, 16, 'PPL', 'P'),
(146730, 'Albia', 42.7033309936523, 0.745313727408175, -73.6522216796875, -1.2854737697193, 218, 40, 'PPL', 'P'),
(58428, 'Albin', 33.913330078125, 0.591899270178907, -90.329719543457, -1.57655101843639, 218, 30, 'PPL', 'P'),
(99335, 'Albin', 39.2216682434082, 0.684547248972374, -78.1988906860352, -1.36482811387844, 218, 53, 'PPL', 'P'),
(209259, 'Albin', 41.417781829834, 0.722876661803285, -104.097778320313, -1.81684897570063, 218, 59, 'PPL', 'P'),
(200303, 'Albina', 45.5438919067383, 0.794890867944981, -122.673889160156, -2.14106327207131, 218, 43, 'PPL', 'P'),
(92166, 'Albino Rodriguez Estates Colonia', 26.257999420166, 0.458288544868659, -98.1380004882813, -1.71283122984431, 218, 51, 'PPL', 'P'),
(7043, 'Albion', 35.3424987792969, 0.616842969580807, -91.789436340332, -1.60202788268853, 218, 4, 'PPL', 'P'),
(13270, 'Albion', 39.7138900756836, 0.693138140595779, -75.6624984741211, -1.3205597186586, 218, 10, 'PPL', 'P'),
(26338, 'Albion', 38.377498626709, 0.669813709715674, -88.0561065673828, -1.53686898608783, 218, 18, 'PPL', 'P'),
(62465, 'Albion', 36.5191688537598, 0.637379736589871, -80.4491729736328, -1.40410294889633, 218, 33, 'PPL', 'P'),
(70454, 'Albion', 39.7786102294922, 0.694267720372136, -74.9552764892578, -1.30821636648024, 218, 37, 'PPL', 'P'),
(74953, 'Albion', 34.6627807617188, 0.60497965218894, -95.0997161865234, -1.65980316516698, 218, 42, 'PPL', 'P'),
(92167, 'Albion', 33.8588905334473, 0.590949120880994, -95.0305633544922, -1.65859622056096, 218, 51, 'PPL', 'P'),
(114368, 'Albion', 42.1124992370605, 0.735001767930307, -92.9883270263672, -1.62295247253134, 218, 16, 'PPL', 'P'),
(122120, 'Albion', 41.3955612182617, 0.722488838969542, -85.4244384765625, -1.49093771308334, 218, 19, 'PPL', 'P'),
(126742, 'Albion', 44.5322189331055, 0.777233843601647, -69.4430618286133, -1.2120100715753, 218, 26, 'PPL', 'P'),
(129456, 'Albion', 42.2430610656738, 0.737280501717033, -84.753059387207, -1.47921993744505, 218, 27, 'PPL', 'P'),
(141143, 'Albion', 41.6908302307129, 0.727642255415927, -98.0033264160156, -1.71048072386621, 218, 35, 'PPL', 'P'),
(146731, 'Albion', 43.2463912963867, 0.754791917727767, -78.1938934326172, -1.36474089535274, 218, 40, 'PPL', 'P'),
(154032, 'Albion', 40.9741706848145, 0.715134186724152, -82.1638870239258, -1.43403035480415, 218, 41, 'PPL', 'P'),
(158578, 'Albion', 40.9588890075684, 0.71486747114098, -78.9472198486328, -1.37788892165446, 218, 45, 'PPL', 'P'),
(169249, 'Albion', 41.9511108398438, 0.732185009024357, -71.4550018310547, -1.24712504897048, 218, 47, 'PPL', 'P'),
(172863, 'Albion', 42.8794403076172, 0.74838741478029, -89.0697174072266, -1.55455983257701, 218, 57, 'PPL', 'P'),
(179657, 'Albion', 39.2236099243164, 0.684581137697245, -123.767501831055, -2.16015041392001, 218, 6, 'PPL', 'P'),
(194503, 'Albion', 42.4127807617188, 0.740242669218501, -113.577217102051, -1.9822963936832, 218, 17, 'PPL', 'P'),
(195846, 'Albion', 45.1872215270996, 0.788665795475948, -104.276390075684, -1.81996633891462, 218, 31, 'PPL', 'P'),
(206658, 'Albion', 46.7911109924316, 0.816658947484044, -117.249443054199, -2.04638882742537, 218, 56, 'PPL', 'P'),
(107932, 'Albion (historical)', 38.2158317565918, 0.666992090540735, -81.0169372558594, -1.41401230499641, 218, 58, 'PPL', 'P'),
(202833, 'Albion Alps', 40.5805587768555, 0.708264362955211, -111.617782592773, -1.94809781001911, 218, 52, 'PPL', 'P'),
(202834, 'Albion Basin', 40.5805587768555, 0.708264362955211, -111.617782592773, -1.94809781001911, 218, 52, 'PPL', 'P'),
(133890, 'Albion Center', 45.1769409179688, 0.788486364997504, -94.0733337402344, -1.64188941209456, 218, 28, 'PPL', 'P'),
(146732, 'Albion Center', 43.4886093139648, 0.759019419642159, -76.0419387817383, -1.3271822013413, 218, 40, 'PPL', 'P'),
(129457, 'Albion Landing', 42.3819389343262, 0.739704377783169, -84.7841720581055, -1.47976295599132, 218, 27, 'PPL', 'P'),
(144719, 'Albion Place', 40.8911094665527, 0.713684494984767, -74.1761093139648, -1.29461733384792, 218, 37, 'PPL', 'P'),
(133892, 'Alborn', 46.9730606079102, 0.819834567346881, -92.5758285522461, -1.61575301599847, 218, 28, 'PPL', 'P'),
(179658, 'Albrae', 37.4955596923828, 0.654420971510152, -121.988327026367, -2.12909795560969, 218, 6, 'PPL', 'P'),
(107933, 'Albright', 39.4938888549805, 0.689298394936102, -79.6430587768555, -1.3900336020155, 218, 58, 'PPL', 'P'),
(133895, 'Albright', 45.1294403076172, 0.787657322950163, -94.1141662597656, -1.64260207400227, 218, 28, 'PPL', 'P'),
(195848, 'Albright (historical)', 46.2844390869141, 0.807815854505408, -106.487503051758, -1.85855754048068, 218, 31, 'PPL', 'P'),
(158580, 'Albrightsville', 41.0144386291504, 0.715836994935824, -75.6013870239258, -1.31949312264202, 218, 45, 'PPL', 'P'),
(7047, 'Albritton (historical)', 33.0525016784668, 0.576874980310198, -91.4375, -1.59588543479232, 218, 4, 'PPL', 'P'),
(62467, 'Albrittons', 35.1977806091309, 0.614317161023949, -77.665283203125, -1.35551490638838, 218, 33, 'PPL', 'P'),
(188014, 'Albuquerque', 35.0844383239746, 0.612338964966238, -106.65055847168, -1.86140339442154, 218, 38, 'PPL', 'P'),
(146742, 'Alburg', 44.7772216796875, 0.781509948205933, -74.5819396972656, -1.30170041024115, 218, 40, 'PPL', 'P'),
(171678, 'Alburg', 44.9749984741211, 0.784961804452839, -73.3005599975586, -1.27933611551304, 218, 55, 'PPL', 'P'),
(171679, 'Alburg Center', 44.9536094665527, 0.784588495847037, -73.2702789306641, -1.27880761119472, 218, 55, 'PPL', 'P'),
(171680, 'Alburg Springs', 44.9919395446777, 0.785257481912865, -73.2233276367188, -1.2779881565273, 218, 55, 'PPL', 'P'),
(171681, 'Alburg Travel Trailer Park', 44.9622192382813, 0.784738764711545, -73.2486114501953, -1.27842944231993, 218, 55, 'PPL', 'P'),
(114371, 'Alburnett', 42.1483306884766, 0.735627144733284, -91.6183319091797, -1.59904154700017, 218, 16, 'PPL', 'P'),
(158581, 'Alburtis', 40.5108299255371, 0.707047364916072, -75.6033325195313, -1.31952707794592, 218, 45, 'PPL', 'P'),
(34521, 'Alcalde', 37.0550003051758, 0.646731759652821, -84.5513916015625, -1.47570017059035, 218, 21, 'PPL', 'P'),
(188015, 'Alcalde', 36.0888900756836, 0.629869955210984, -106.053062438965, -1.85097512138306, 218, 38, 'PPL', 'P'),
(212265, 'Alcan', 62.7230606079102, 1.09472392453599, -141.188064575195, -2.46419659135553, 218, 1, 'PPL', 'P'),
(188016, 'Alcatraz', 36.7563896179199, 0.641520019978563, -107.756393432617, -1.88070385547356, 218, 38, 'PPL', 'P'),
(169703, 'Alcester', 43.0213890075684, 0.750864886963364, -96.6305618286133, -1.68652146196125, 218, 49, 'PPL', 'P'),
(99336, 'Alchie', 36.892219543457, 0.643890699401924, -79.0166702270508, -1.37910105942461, 218, 53, 'PPL', 'P'),
(7046, 'Alco', 35.8875007629395, 0.62635504862527, -92.366943359375, -1.61210728162421, 218, 4, 'PPL', 'P'),
(39057, 'Alco', 31.3341693878174, 0.546884424195029, -93.1305618286133, -1.62543493814145, 218, 22, 'PPL', 'P'),
(92168, 'Alco', 31.3519401550293, 0.547194582593483, -94.5702819824219, -1.65056279513273, 218, 51, 'PPL', 'P'),
(84606, 'Alcoa', 35.7894401550293, 0.624643568150731, -83.9738922119141, -1.46562090481272, 218, 50, 'PPL', 'P'),
(92169, 'Alcoa', 30.5641708374023, 0.533445414254703, -97.0663909912109, -1.69412811582479, 218, 51, 'PPL', 'P'),
(158583, 'Alcoa Center', 40.538330078125, 0.707527333123531, -79.6452789306641, -1.39007235100936, 218, 45, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(158584, 'Alcola', 41.0122184753418, 0.715798245941963, -79.2891693115234, -1.38385706565733, 218, 45, 'PPL', 'P'),
(79502, 'Alcolu', 33.7508316040039, 0.589063136776027, -80.2144393920898, -1.40000607503341, 218, 48, 'PPL', 'P'),
(14957, 'Alcoma', 27.8947200775146, 0.486854709274798, -81.4824981689453, -1.42213787579835, 218, 12, 'PPL', 'P'),
(99337, 'Alcoma', 37.5486106872559, 0.655346886042146, -78.5924987792969, -1.37169787106835, 218, 53, 'PPL', 'P'),
(129460, 'Alcona', 44.7599983215332, 0.78120934389789, -83.2977828979492, -1.45382057118064, 218, 27, 'PPL', 'P'),
(154033, 'Alcony', 40.0113906860352, 0.698330505773106, -84.0580596923828, -1.46708990447001, 218, 41, 'PPL', 'P'),
(34522, 'Alcorn', 37.5613899230957, 0.65556992578344, -84.0488891601563, -1.4669298484885, 218, 21, 'PPL', 'P'),
(58429, 'Alcorn', 31.8777809143066, 0.556372235184059, -91.1391677856445, -1.59067855538705, 218, 30, 'PPL', 'P'),
(74954, 'Alcorn', 36.6130599975586, 0.639018446187624, -97.3927764892578, -1.69982461739647, 218, 42, 'PPL', 'P'),
(18775, 'Alcorns', 32.4094390869141, 0.565651420791195, -83.1102828979492, -1.45054807883315, 218, 13, 'PPL', 'P'),
(79501, 'Alcot', 34.250560760498, 0.597785055925064, -80.1802825927734, -1.39940992642339, 218, 48, 'PPL', 'P'),
(209260, 'Alcova', 42.5522193908691, 0.742676332401642, -106.715827941895, -1.86254256157782, 218, 59, 'PPL', 'P'),
(99339, 'Alcova Heights', 38.8644409179688, 0.678312455965362, -77.0975036621094, -1.34560528397219, 218, 53, 'PPL', 'P'),
(209261, 'Alcova Po', 42.560001373291, 0.742812153617237, -106.722778320313, -1.86266386856548, 218, 59, 'PPL', 'P'),
(146736, 'Alcove', 42.4686088562012, 0.741217053282334, -73.9261093139648, -1.29025401071793, 218, 40, 'PPL', 'P'),
(31618, 'Alcove Spring', 39.7608299255371, 0.693957395526114, -96.6777801513672, -1.68734557716058, 218, 20, 'PPL', 'P'),
(18776, 'Alcovy', 33.639720916748, 0.587123889449259, -83.7869415283203, -1.46235799984516, 218, 13, 'PPL', 'P'),
(18777, 'Alcovy Forest', 33.961109161377, 0.592733172495238, -83.9161071777344, -1.46461236570791, 218, 13, 'PPL', 'P'),
(18778, 'Alcovy Mobile Home Park', 33.5527801513672, 0.585606486839159, -83.845832824707, -1.46338584686788, 218, 13, 'PPL', 'P'),
(18779, 'Alcovy Mountain', 33.7405586242676, 0.588883839455638, -83.7663879394531, -1.46199927204633, 218, 13, 'PPL', 'P'),
(18782, 'Alcovy Shores', 33.3894386291504, 0.582755639471256, -83.8327789306641, -1.46315801343662, 218, 13, 'PPL', 'P'),
(26349, 'Alda', 38.4627799987793, 0.671302150448919, -89.2366714477539, -1.55747373028372, 218, 18, 'PPL', 'P'),
(177364, 'Alda', 40.8711090087891, 0.713335421144885, -98.4677810668945, -1.71858698675024, 218, 35, 'PPL', 'P'),
(191057, 'Aldama Estates Colonia', 31.6359996795654, 0.552152356568288, -106.271003723145, -1.85477891436802, 218, 51, 'PPL', 'P'),
(77772, 'Aldan', 39.9213905334473, 0.69675970678315, -75.288330078125, -1.31402924819156, 218, 45, 'PPL', 'P'),
(796, 'Alden', 39.4833297729492, 0.689114104188669, -81.5022201538086, -1.42248208936924, 218, 41, 'PPL', 'P'),
(31619, 'Alden', 38.2422218322754, 0.667452684251264, -98.3116683959961, -1.71586230663898, 218, 20, 'PPL', 'P'),
(74955, 'Alden', 34.9752807617188, 0.610433806101423, -98.5849990844727, -1.72063282709964, 218, 42, 'PPL', 'P'),
(99338, 'Alden', 38.274169921875, 0.6680102836045, -77.0722198486328, -1.34516399817957, 218, 53, 'PPL', 'P'),
(112714, 'Alden', 33.6388893127441, 0.587109375221318, -86.9652786254883, -1.51783044692902, 218, 2, 'PPL', 'P'),
(114372, 'Alden', 42.5202789306641, 0.742118866206462, -93.3758316040039, -1.62971570327765, 218, 16, 'PPL', 'P'),
(118584, 'Alden', 42.4588890075684, 0.741047409920895, -88.5177764892578, -1.54492664628198, 218, 18, 'PPL', 'P'),
(129463, 'Alden', 44.8811111450195, 0.783323161434113, -85.2755584716797, -1.48833926680775, 218, 27, 'PPL', 'P'),
(133896, 'Alden', 43.670280456543, 0.762190179236007, -93.5758285522461, -1.63320630851841, 218, 28, 'PPL', 'P'),
(146737, 'Alden', 42.9000015258789, 0.748746275737178, -78.4922180175781, -1.36994764159995, 218, 40, 'PPL', 'P'),
(158585, 'Alden', 41.1819381713867, 0.718760413443431, -76.0127792358398, -1.32667327125698, 218, 45, 'PPL', 'P'),
(194082, 'Alden', 40.4575004577637, 0.706116590115089, -104.581390380859, -1.82528959845952, 218, 7, 'PPL', 'P'),
(199137, 'Alden', 41.5613899230957, 0.725383095863213, -103.035827636719, -1.79831443977811, 218, 35, 'PPL', 'P'),
(39056, 'Alden Bridge', 32.7750015258789, 0.572031688972752, -93.7200012207031, -1.63572259627437, 218, 22, 'PPL', 'P'),
(146738, 'Alden Center', 42.9111099243164, 0.748940153864536, -78.5236129760742, -1.37049558699424, 218, 40, 'PPL', 'P'),
(146739, 'Alden Manor', 40.6941719055176, 0.710247286123857, -73.7180633544922, -1.28662292372966, 218, 40, 'PPL', 'P'),
(114373, 'Alden Station (historical)', 42.5041694641113, 0.741837702974376, -93.3805618286133, -1.62979826127144, 218, 16, 'PPL', 'P'),
(144720, 'Aldene', 40.663330078125, 0.709708994688524, -74.2733306884766, -1.29631416693646, 218, 37, 'PPL', 'P'),
(58431, 'Aldens', 34.9333305358887, 0.609701636538732, -90.0247192382813, -1.57122775889149, 218, 30, 'PPL', 'P'),
(172868, 'Aldens Corners', 43.2213897705078, 0.754355558783158, -89.6399993896484, -1.56451313083507, 218, 57, 'PPL', 'P'),
(124097, 'Aldenville', 42.172779083252, 0.736053849718942, -72.5986099243164, -1.26708477555035, 218, 23, 'PPL', 'P'),
(158586, 'Aldenville', 41.646671295166, 0.726871536596458, -75.3641662597656, -1.31535283925333, 218, 45, 'PPL', 'P'),
(84607, 'Aldenwood Park', 35.8941688537598, 0.626471428764907, -84.0274963378906, -1.46655647330367, 218, 50, 'PPL', 'P'),
(84608, 'Alder', 36.3474998474121, 0.634383547205478, -83.9899978637695, -1.46590200146578, 218, 50, 'PPL', 'P'),
(129464, 'Alder', 46.7894401550293, 0.816629785870107, -87.6972198486328, -1.53060523120397, 218, 27, 'PPL', 'P'),
(133900, 'Alder', 47.5616683959961, 0.830107711251862, -93.70361328125, -1.6354365727733, 218, 28, 'PPL', 'P'),
(186322, 'Alder', 38.3694381713867, 0.669673028231091, -106.038887023926, -1.8507277137178, 218, 7, 'PPL', 'P'),
(195849, 'Alder', 45.3238906860352, 0.791051122285305, -112.106391906738, -1.95662565130371, 218, 31, 'PPL', 'P'),
(200304, 'Alder', 44.5825004577637, 0.778111421759855, -123.507781982422, -2.15561744742859, 218, 43, 'PPL', 'P'),
(206659, 'Alder', 46.8005599975586, 0.816823863734547, -122.288887023926, -2.13434371716687, 218, 56, 'PPL', 'P'),
(200305, 'Alder (historical)', 45.3980598449707, 0.792345618312165, -117.296112060547, -2.04720335524477, 218, 43, 'PPL', 'P'),
(146741, 'Alder Bend', 44.8480606079102, 0.782746320742002, -73.7213897705078, -1.28668098064143, 218, 40, 'PPL', 'P'),
(62468, 'Alder Branch', 36.2516708374023, 0.632711015461881, -76.0311126708984, -1.32699325006196, 218, 33, 'PPL', 'P'),
(84609, 'Alder Branch', 35.9216690063477, 0.626951396972366, -83.5550003051758, -1.45830986183018, 218, 50, 'PPL', 'P'),
(146743, 'Alder Brook', 44.5133285522461, 0.776904144258695, -73.9438934326172, -1.29056440214298, 218, 40, 'PPL', 'P'),
(194504, 'Alder City (historical)', 43.872501373291, 0.765719600049662, -113.519439697266, -1.98128798773644, 218, 17, 'PPL', 'P'),
(146744, 'Alder Creek', 43.4233283996582, 0.757880052748796, -75.2283325195313, -1.31298209325094, 218, 40, 'PPL', 'P'),
(179659, 'Alder Creek', 38.6347198486328, 0.674303066944248, -121.200561523438, -2.11534885384994, 218, 6, 'PPL', 'P'),
(194505, 'Alder Creek', 47.2227783203125, 0.824192963628851, -116.606666564941, -2.03517026133341, 218, 17, 'PPL', 'P'),
(200306, 'Alder Creek', 45.378059387207, 0.791996544472283, -122.100563049316, -2.1310568437495, 218, 43, 'PPL', 'P'),
(206660, 'Alder Grove', 46.9658317565918, 0.819708400090239, -123.637496948242, -2.15788140067127, 218, 56, 'PPL', 'P'),
(58432, 'Alder Grove (historical)', 33.1936111450195, 0.579337805107276, -90.9097213745117, -1.58667396005589, 218, 30, 'PPL', 'P'),
(84611, 'Alder Springs', 36.3691711425781, 0.634761782659296, -84.0063934326172, -1.46618815812491, 218, 50, 'PPL', 'P'),
(112730, 'Alder Springs', 34.3430595397949, 0.59939946417787, -86.2158279418945, -1.50475006491899, 218, 2, 'PPL', 'P'),
(179661, 'Alder Springs', 39.6511116027832, 0.692042449544293, -122.72444152832, -2.14194557734045, 218, 6, 'PPL', 'P'),
(997, 'Alderbranch', 31.6886100769043, 0.553070581222634, -95.4577789306641, -1.66605253898096, 218, 51, 'PPL', 'P'),
(143450, 'Alderbrook', 44.3266716003418, 0.773646365876228, -71.6969375610352, -1.25134762403686, 218, 36, 'PPL', 'P'),
(179663, 'Aldercroft Heights', 37.160831451416, 0.648578861605873, -121.967781066895, -2.12873936096891, 218, 6, 'PPL', 'P'),
(206661, 'Alderdale', 45.8349990844727, 0.799971646672634, -119.919723510742, -2.0929940133437, 218, 56, 'PPL', 'P'),
(14958, 'Alderene Park', 28.8111095428467, 0.502848722675433, -81.3658294677734, -1.42010162282887, 218, 12, 'PPL', 'P'),
(179662, 'Alderglen Springs', 38.8352813720703, 0.677803525881048, -123.051666259766, -2.14765672629813, 218, 6, 'PPL', 'P'),
(172869, 'Alderley', 43.2174987792969, 0.754287648175361, -88.4497222900391, -1.5437388764358, 218, 57, 'PPL', 'P'),
(14959, 'Alderman', 28.4902801513672, 0.497249193456946, -82.165283203125, -1.43405472272812, 218, 12, 'PPL', 'P'),
(14960, 'Aldermans Ford', 27.8622207641602, 0.486287489252125, -82.1458282470703, -1.43371516968914, 218, 12, 'PPL', 'P'),
(193339, 'Alderpoint', 40.1763916015625, 0.701210315017863, -123.610557556152, -2.15741121958081, 218, 6, 'PPL', 'P'),
(62469, 'Aldersgate', 34.7872200012207, 0.607151526636927, -77.4166717529297, -1.35117581802431, 218, 33, 'PPL', 'P'),
(74956, 'Alderson', 34.9000015258789, 0.609119935577632, -95.6916732788086, -1.67013476545789, 218, 42, 'PPL', 'P'),
(107934, 'Alderson', 37.725830078125, 0.658439947911191, -80.642219543457, -1.40747224714944, 218, 58, 'PPL', 'P'),
(206662, 'Alderton', 47.1697196960449, 0.823266915938803, -122.228057861328, -2.13328204799831, 218, 56, 'PPL', 'P'),
(200307, 'Aldervale', 45.7686080932617, 0.798812905282341, -123.843063354492, -2.16146921129182, 218, 43, 'PPL', 'P'),
(206663, 'Alderwood Manor', 47.8222198486328, 0.834655191971227, -122.280830383301, -2.13420310226132, 218, 56, 'PPL', 'P'),
(158587, 'Aldham', 40.0905609130859, 0.699712286904694, -75.5416717529297, -1.31845089454942, 218, 45, 'PPL', 'P'),
(99341, 'Aldie', 38.9755592346191, 0.680251836450185, -77.6416702270508, -1.35510278220969, 218, 53, 'PPL', 'P'),
(70455, 'Aldine', 39.5688896179199, 0.690607405190904, -75.2752838134766, -1.31380154791836, 218, 37, 'PPL', 'P'),
(92171, 'Aldine', 29.9322204589844, 0.522415799442086, -95.379997253418, -1.66469499261529, 218, 51, 'PPL', 'P'),
(122122, 'Aldine', 41.2008285522461, 0.719090112786383, -86.6744384765625, -1.51275432873327, 218, 19, 'PPL', 'P'),
(44312, 'Aldino', 39.5638885498047, 0.690520120086176, -76.1961135864258, -1.32987305930671, 218, 25, 'PPL', 'P'),
(18780, 'Aldora', 33.0519409179688, 0.576865193193192, -84.1758270263672, -1.46914533219934, 218, 13, 'PPL', 'P'),
(158588, 'Aldovin', 41.6172218322754, 0.726357546506073, -75.938606262207, -1.3253787086511, 218, 45, 'PPL', 'P'),
(18781, 'Aldreds', 32.9494400024414, 0.575076214730931, -82.3930587768555, -1.43803015644534, 218, 13, 'PPL', 'P'),
(53148, 'Aldrich', 37.5475006103516, 0.655327511545215, -93.554443359375, -1.63283306649164, 218, 29, 'PPL', 'P'),
(112717, 'Aldrich', 33.1074981689453, 0.57783485014609, -86.89111328125, -1.51653601748119, 218, 2, 'PPL', 'P'),
(133901, 'Aldrich', 46.3763885498047, 0.80942067537829, -94.936393737793, -1.65695265069421, 218, 28, 'PPL', 'P'),
(146746, 'Aldrich', 44.148609161377, 0.77053859004216, -75.1116714477539, -1.31094597343952, 218, 40, 'PPL', 'P'),
(124098, 'Aldrich Mills', 42.2819404602051, 0.737959075162785, -72.538330078125, -1.26603269376172, 218, 23, 'PPL', 'P'),
(26343, 'Aldridge', 37.5583305358887, 0.655516529403584, -89.4700012207031, -1.56154610306462, 218, 18, 'PPL', 'P'),
(58433, 'Aldridge', 33.3619384765625, 0.582275671263797, -90.9097213745117, -1.58667396005589, 218, 30, 'PPL', 'P'),
(107935, 'Aldridge', 39.3011093139648, 0.685933757214896, -77.9227828979492, -1.36000912388594, 218, 58, 'PPL', 'P'),
(112718, 'Aldridge', 33.7069396972656, 0.588297078488466, -87.241943359375, -1.5226591574595, 218, 2, 'PPL', 'P'),
(195850, 'Aldridge', 45.0869407653809, 0.786915566007548, -110.820831298828, -1.93418838596173, 218, 31, 'PPL', 'P'),
(112715, 'Aldridge Grove', 34.4230613708496, 0.600795759537399, -87.2405624389648, -1.52263505585163, 218, 2, 'PPL', 'P'),
(99342, 'Aldwyck', 37.7388916015625, 0.658667914500502, -77.879997253418, -1.35926237351628, 218, 53, 'PPL', 'P'),
(200308, 'Ale (historical)', 44.788890838623, 0.781713613450296, -122.851387023926, -2.14416119420934, 218, 43, 'PPL', 'P'),
(74958, 'Aledo', 35.827220916748, 0.625302966836635, -99.123893737793, -1.73003831312148, 218, 42, 'PPL', 'P'),
(92172, 'Aledo', 32.6958312988281, 0.570649907841165, -97.601936340332, -1.7034751454607, 218, 51, 'PPL', 'P'),
(118587, 'Aledo', 41.1997184753418, 0.719070738289453, -90.7491683959961, -1.58387178195691, 218, 18, 'PPL', 'P'),
(202836, 'Alegre Vista', 40.5944404602051, 0.708506644035381, -111.874168395996, -1.95257258644072, 218, 52, 'PPL', 'P'),
(92173, 'Alejandrenas', 26.7769393920898, 0.467345755998937, -99.1399993896484, -1.73031940977453, 218, 51, 'PPL', 'P'),
(212266, 'Aleknagik', 59.2730598449707, 1.03451005202638, -158.617782592773, -2.76840255845644, 218, 1, 'PPL', 'P'),
(212268, 'Aleksashkina', 57.7799987792969, 1.00845122049703, -152.355285644531, -2.65910136731352, 218, 1, 'PPL', 'P'),
(92174, 'Aleman', 31.6322193145752, 0.552086376752281, -98.0419387817383, -1.71115463678005, 218, 51, 'PPL', 'P'),
(179665, 'Alemandra', 39.1488914489746, 0.683277054290461, -121.686943054199, -2.12383781298262, 218, 6, 'PPL', 'P'),
(129465, 'Alembic', 43.5974998474121, 0.760919917975067, -84.668327331543, -1.47774108409173, 218, 27, 'PPL', 'P'),
(84612, 'Alena (historical)', 36.0763893127441, 0.62965177573868, -83.5069427490234, -1.45747109924486, 218, 50, 'PPL', 'P'),
(146745, 'Alene', 43.0122184753418, 0.75070483098185, -75.7372207641602, -1.32186386864441, 218, 40, 'PPL', 'P'),
(212267, 'Aleneva', 58.060001373291, 1.01333818767636, -152.909713745117, -2.66877796313432, 218, 1, 'PPL', 'P'),
(77774, 'Aleppo', 39.8238906860352, 0.695058013425617, -80.4463882446289, -1.40405434620644, 218, 45, 'PPL', 'P'),
(727, 'Alert', 36.2308311462402, 0.632347294236003, -78.2227783203125, -1.36524503174709, 218, 33, 'PPL', 'P'),
(29079, 'Alert', 39.1602783203125, 0.683475792686808, -85.6783294677734, -1.49536894682113, 218, 19, 'PPL', 'P'),
(71637, 'Alert', 39.3250007629395, 0.686350741662576, -84.7752838134766, -1.47960782685782, 218, 41, 'PPL', 'P'),
(58437, 'Ales (historical)', 34.0244407653809, 0.593838517505676, -88.3944396972656, -1.54277401317286, 218, 30, 'PPL', 'P'),
(44313, 'Alesia', 39.6830596923828, 0.692600048897528, -76.8291702270508, -1.34092198203724, 218, 25, 'PPL', 'P'),
(44314, 'Alesia Heights', 39.6847190856934, 0.692629010774383, -76.8219375610352, -1.34079574820157, 218, 25, 'PPL', 'P'),
(179664, 'Alessandro', 33.8861083984375, 0.591424162240437, -117.269439697266, -2.04673783468623, 218, 6, 'PPL', 'P'),
(58434, 'Alesville', 34.3650016784668, 0.599782426742623, -89.6041717529297, -1.56388782061112, 218, 30, 'PPL', 'P'),
(126743, 'Alewife', 43.4527816772461, 0.758394109418208, -70.6102828979492, -1.23238192233386, 218, 26, 'PPL', 'P'),
(146756, 'Alewife Brook Landing', 41.0322189331055, 0.716147319781845, -72.2399978637695, -1.26082581435645, 218, 40, 'PPL', 'P'),
(74959, 'Alex', 34.9147186279297, 0.60937679746477, -97.7783279418945, -1.70655375968083, 218, 42, 'PPL', 'P'),
(195851, 'Alex Boggio Place', 45.3158302307129, 0.790910440800722, -109.436943054199, -1.91003497961332, 218, 31, 'PPL', 'P'),
(92176, 'Alex Cavazos Colonia', 26.2600002288818, 0.458323465568453, -98.3420028686523, -1.71639174306369, 218, 51, 'PPL', 'P'),
(7048, 'Alexander', 34.6294403076172, 0.604397751490758, -92.4411087036133, -1.61340171107204, 218, 4, 'PPL', 'P'),
(18783, 'Alexander', 33.0219383239746, 0.576341549143855, -81.8769378662109, -1.4290221472162, 218, 13, 'PPL', 'P'),
(26344, 'Alexander', 39.7244415283203, 0.693322298185158, -90.0380630493164, -1.57146065232882, 218, 18, 'PPL', 'P'),
(31620, 'Alexander', 38.4694404602051, 0.671418397430501, -99.5527801513672, -1.73752379315542, 218, 20, 'PPL', 'P'),
(92175, 'Alexander', 32.0588912963867, 0.559533207660902, -98.2058334350586, -1.71401513810691, 218, 51, 'PPL', 'P'),
(107936, 'Alexander', 38.7827796936035, 0.676887198728979, -80.2227783203125, -1.40015161678698, 218, 58, 'PPL', 'P'),
(114375, 'Alexander', 42.8058280944824, 0.747102639291409, -93.4763870239258, -1.63147072643601, 218, 16, 'PPL', 'P'),
(126744, 'Alexander', 45.0886116027832, 0.786944727621485, -67.4688873291016, -1.17755422654991, 218, 26, 'PPL', 'P'),
(146747, 'Alexander', 42.9011116027832, 0.748765650234109, -78.2569427490234, -1.36584131351516, 218, 40, 'PPL', 'P'),
(154034, 'Alexander', 41.3563919067383, 0.721805205517719, -81.5961074829102, -1.42412073238797, 218, 41, 'PPL', 'P'),
(194506, 'Alexander', 42.6511116027832, 0.744402327104123, -111.70832824707, -1.94967812980996, 218, 17, 'PPL', 'P'),
(197917, 'Alexander', 47.8430595397949, 0.835018913197104, -103.642219543457, -1.80889797510814, 218, 34, 'PPL', 'P'),
(58435, 'Alexander (historical)', 32.8675003051758, 0.573646097225558, -91.0827789306641, -1.58969438420621, 218, 30, 'PPL', 'P'),
(206664, 'Alexander Beach', 48.4752807617188, 0.846053255120657, -122.658889770508, -2.14080148333615, 218, 56, 'PPL', 'P'),
(112720, 'Alexander City', 32.9438896179199, 0.574979342246279, -85.9538879394531, -1.5001783494337, 218, 2, 'PPL', 'P'),
(99343, 'Alexander Corner', 36.814998626709, 0.642542940153263, -76.3566665649414, -1.3326752374057, 218, 53, 'PPL', 'P'),
(79503, 'Alexander Crossroads', 34.1969413757324, 0.59684922111801, -79.9305572509766, -1.39505139698337, 218, 48, 'PPL', 'P'),
(84613, 'Alexander Mill', 36.1375007629395, 0.630718371755256, -82.7594375610352, -1.44442467253873, 218, 50, 'PPL', 'P'),
(62471, 'Alexander Mills', 35.3105583190918, 0.616285503385626, -81.85888671875, -1.42870709525924, 218, 33, 'PPL', 'P'),
(188017, 'Alexander Place', 34.6861114501953, 0.605386849519613, -106.253608703613, -1.85447531400376, 218, 38, 'PPL', 'P'),
(14963, 'Alexander Springs', 29.0799999237061, 0.50754174514837, -81.5783309936523, -1.42381047412097, 218, 12, 'PPL', 'P'),
(84614, 'Alexander Springs', 35.3772201538086, 0.617448971886855, -87.269172668457, -1.52313439855602, 218, 50, 'PPL', 'P'),
(158590, 'Alexander Springs', 40.6283302307129, 0.709098132113487, -77.6744384765625, -1.35567469605378, 218, 45, 'PPL', 'P'),
(99344, 'Alexanders Corner', 37.586669921875, 0.656011144997039, -77.2233276367188, -1.34780132660707, 218, 53, 'PPL', 'P'),
(18784, 'Alexanders Mill', 34.9738883972168, 0.610409504756475, -83.8819427490234, -1.46401608393984, 218, 13, 'PPL', 'P'),
(92177, 'Alexanders Store', 31.6169300079346, 0.551819528011055, -93.9264678955078, -1.63932611954536, 218, 51, 'PPL', 'P'),
(212271, 'Alexanders Village', 66.788330078125, 1.16567626177204, -145.436935424805, -2.53835337717322, 218, 1, 'PPL', 'P'),
(34525, 'Alexandria', 38.8230590820313, 0.677590206677733, -84.4280624389648, -1.47354767063929, 218, 21, 'PPL', 'P'),
(39061, 'Alexandria', 31.3111095428467, 0.546481953975291, -92.4449996948242, -1.61346962167984, 218, 22, 'PPL', 'P'),
(84615, 'Alexandria', 36.0774993896484, 0.62967115023561, -86.033332824707, -1.50156492425525, 218, 50, 'PPL', 'P'),
(99345, 'Alexandria', 38.8047218322754, 0.677270161293732, -77.0472183227539, -1.34472763923496, 218, 53, 'PPL', 'P'),
(112723, 'Alexandria', 33.7738914489746, 0.589465606995765, -85.8855590820313, -1.49898578589756, 218, 2, 'PPL', 'P'),
(122123, 'Alexandria', 40.2627792358398, 0.702718063669012, -85.6758270263672, -1.49532527097925, 218, 19, 'PPL', 'P'),
(133904, 'Alexandria', 45.8852806091309, 0.800849224830843, -95.3772201538086, -1.66464652308345, 218, 28, 'PPL', 'P'),
(139005, 'Alexandria', 40.3594398498535, 0.70440510964055, -91.4552764892578, -1.59619569305931, 218, 29, 'PPL', 'P'),
(141145, 'Alexandria', 40.2452812194824, 0.702412665671007, -97.3888931274414, -1.69975683994673, 218, 35, 'PPL', 'P'),
(143451, 'Alexandria', 43.6113891601563, 0.761162332213291, -71.793327331543, -1.25302994289746, 218, 36, 'PPL', 'P'),
(154035, 'Alexandria', 40.0888900756836, 0.699683125290757, -82.6125030517578, -1.44186018156704, 218, 41, 'PPL', 'P'),
(158600, 'Alexandria', 40.5563888549805, 0.707842518238542, -78.0980606079102, -1.36306829703012, 218, 45, 'PPL', 'P'),
(169707, 'Alexandria', 43.6536102294922, 0.761899228886916, -97.7825012207031, -1.70662659713664, 218, 49, 'PPL', 'P'),
(146749, 'Alexandria Bay', 44.3358306884766, 0.77380622212066, -75.9180603027344, -1.32502011401032, 218, 40, 'PPL', 'P'),
(146750, 'Alexandria Center', 44.3074989318848, 0.77331173968526, -75.8763885498047, -1.32429280471662, 218, 40, 'PPL', 'P'),
(39058, 'Alexandria Junction', 31.2908306121826, 0.54612801986642, -92.4433288574219, -1.6134404600659, 218, 22, 'PPL', 'P'),
(133905, 'Alexandria Mobile Estates', 45.8886108398438, 0.800907348321634, -95.3766708374023, -1.66463693570353, 218, 28, 'PPL', 'P'),
(144722, 'Alexauken', 40.3894386291504, 0.704928687110859, -74.9394378662109, -1.30793993035909, 218, 37, 'PPL', 'P'),
(402, 'Alexis', 30.7419395446777, 0.536548063503673, -82.9186096191406, -1.44720274902985, 218, 13, 'PPL', 'P'),
(62472, 'Alexis', 35.3997192382813, 0.617841654989587, -81.1180572509766, -1.4157771818508, 218, 33, 'PPL', 'P'),
(71640, 'Alexis', 39.6363906860352, 0.691785521078128, -81.0313873291016, -1.41426450635164, 218, 41, 'PPL', 'P'),
(112726, 'Alexis', 34.1788902282715, 0.596534169161054, -85.5122222900391, -1.49246982965847, 218, 2, 'PPL', 'P'),
(118588, 'Alexis', 41.0633316040039, 0.716690338328112, -90.5558319091797, -1.58049742369773, 218, 18, 'PPL', 'P'),
(154036, 'Alexis Addition', 41.7197189331055, 0.728146458389306, -83.5269393920898, -1.45782010650572, 218, 41, 'PPL', 'P'),
(118589, 'Alexis Junction', 41.0672187805176, 0.716758182356882, -90.6383285522461, -1.58193726174108, 218, 18, 'PPL', 'P'),
(92178, 'Aley', 32.3216094970703, 0.564118505267745, -96.2568588256836, -1.67999911413554, 218, 51, 'PPL', 'P'),
(7050, 'Alf', 34.4897193908691, 0.6019591614596, -93.8702774047852, -1.63834541047394, 218, 4, 'PPL', 'P'),
(179666, 'Alfac (historical)', 36.0319404602051, 0.628875996913139, -119.307220458984, -2.08230381841202, 218, 6, 'PPL', 'P'),
(39059, 'Alfalfa', 31.3694400787354, 0.547500013881001, -92.6183319091797, -1.61649483952011, 218, 22, 'PPL', 'P'),
(74961, 'Alfalfa', 35.2188911437988, 0.614685609360761, -98.6069412231445, -1.7210157896644, 218, 42, 'PPL', 'P'),
(112725, 'Alfalfa', 32.5102806091309, 0.567411437376601, -87.7644424438477, -1.5317784868222, 218, 2, 'PPL', 'P'),
(191058, 'Alfalfa', 31.7552795410156, 0.554234182881916, -106.38111114502, -1.85670065141063, 218, 51, 'PPL', 'P'),
(200309, 'Alfalfa', 44.0774993896484, 0.769297490395156, -121.015830993652, -2.11212469787623, 218, 43, 'PPL', 'P'),
(206665, 'Alfalfa', 46.3305587768555, 0.808620794944885, -120.237777709961, -2.09854510631987, 218, 56, 'PPL', 'P'),
(53150, 'Alfalfa Center', 36.9630584716797, 0.645127071937994, -89.2072219848633, -1.55695974019334, 218, 29, 'PPL', 'P'),
(141148, 'Alfalfa Center', 40.6922187805176, 0.710213197661903, -99.1788864135742, -1.73099811637834, 218, 35, 'PPL', 'P'),
(158593, 'Alfarata', 40.6624984741211, 0.709694480460583, -77.4572219848633, -1.351883553084, 218, 45, 'PPL', 'P'),
(31624, 'Alfmil', 39.1319389343262, 0.682981177093353, -97.7219390869141, -1.70556958849999, 218, 20, 'PPL', 'P'),
(99347, 'Alfonso', 37.8086090087891, 0.659884712802559, -76.5083312988281, -1.33532228637118, 218, 53, 'PPL', 'P'),
(29080, 'Alfont', 39.9513893127441, 0.69728328425346, -85.8147201538086, -1.49774941336149, 218, 19, 'PPL', 'P'),
(14964, 'Alford', 30.6936092376709, 0.535704540517904, -85.392219543457, -1.49037538661917, 218, 12, 'PPL', 'P'),
(29081, 'Alford', 38.4913902282715, 0.671801493153309, -87.2427825927734, -1.52267380484549, 218, 19, 'PPL', 'P'),
(124099, 'Alford', 42.2355613708496, 0.737149607349455, -73.4138870239258, -1.28131404525465, 218, 23, 'PPL', 'P'),
(133908, 'Alford', 46.6319389343262, 0.813880870992928, -92.3833312988281, -1.61239330512528, 218, 28, 'PPL', 'P'),
(158594, 'Alford', 41.8066711425781, 0.729664060736488, -75.7750015258789, -1.32252326733031, 218, 45, 'PPL', 'P'),
(39060, 'Alford Acres', 30.5233306884766, 0.532732619188944, -91.0097198486328, -1.58841926267628, 218, 22, 'PPL', 'P'),
(193340, 'Alford Place', 40.2183303833008, 0.701942284843472, -122.665557861328, -2.14091786347579, 218, 6, 'PPL', 'P'),
(18785, 'Alfords', 31.4622192382813, 0.54911931569231, -83.9238891601563, -1.46474818692351, 218, 13, 'PPL', 'P'),
(39062, 'Alfords', 30.5691699981689, 0.533532666069917, -91.3188934326172, -1.593815359677, 218, 22, 'PPL', 'P'),
(29082, 'Alfordsville', 38.5605583190918, 0.673008704075442, -86.9483337402344, -1.51753470288997, 218, 19, 'PPL', 'P'),
(62473, 'Alfordsville', 34.5800018310547, 0.603534887297572, -79.3186111450195, -1.38437092258966, 218, 33, 'PPL', 'P'),
(171683, 'Alfrecha', 43.5641708374023, 0.760338217013966, -72.9730606079102, -1.27362017286541, 218, 55, 'PPL', 'P'),
(71641, 'Alfred', 39.1725006103516, 0.683689111890123, -81.9211120605469, -1.42979313235178, 218, 41, 'PPL', 'P'),
(92179, 'Alfred', 27.8802795410156, 0.486602674367136, -97.9844436645508, -1.71015115768131, 218, 51, 'PPL', 'P'),
(113088, 'Alfred', 43.476390838623, 0.758806167017871, -70.7188873291016, -1.23427742723972, 218, 26, 'PPL', 'P'),
(129479, 'Alfred', 46.0838890075684, 0.80431559530569, -87.6324996948242, -1.52947565142761, 218, 27, 'PPL', 'P'),
(139579, 'Alfred', 46.6030616760254, 0.81337686775663, -98.998893737793, -1.72785665155648, 218, 34, 'PPL', 'P'),
(146752, 'Alfred', 42.2541694641113, 0.737474379844391, -77.7908325195313, -1.3577061553333, 218, 40, 'PPL', 'P'),
(92180, 'Alfred Acres Colonia', 27.886999130249, 0.48671995332364, -97.9779968261719, -1.71003863912525, 218, 51, 'PPL', 'P'),
(92181, 'Alfred Hilltop Estates Colonia', 27.9080009460449, 0.487086504158176, -97.9609985351563, -1.70974196297982, 218, 51, 'PPL', 'P'),
(126746, 'Alfred Mills', 43.4638900756836, 0.758587987545566, -70.7024993896484, -1.23399140373865, 218, 26, 'PPL', 'P'),
(146753, 'Alfred Station', 42.269718170166, 0.73774575595947, -77.7594375610352, -1.35715820993901, 218, 40, 'PPL', 'P'),
(92182, 'Alfredo Garza Colonia', 26.2229995727539, 0.457677682293622, -97.4879989624023, -1.70148656307474, 218, 51, 'PPL', 'P'),
(7052, 'Alfrey', 34.8288917541504, 0.607878835930628, -91.1549987792969, -1.59095485835014, 218, 4, 'PPL', 'P'),
(129466, 'Algansee', 41.8325004577637, 0.730114867330011, -84.8808288574219, -1.48144993538383, 218, 27, 'PPL', 'P'),
(79504, 'Algary (historical)', 34.3655586242676, 0.599792147280602, -82.279167175293, -1.4360423730077, 218, 48, 'PPL', 'P'),
(34526, 'Alger', 37.313060760498, 0.65123576426739, -83.7316665649414, -1.46139326974028, 218, 21, 'PPL', 'P'),
(129468, 'Alger', 44.125560760498, 0.770136319559504, -84.1211090087891, -1.46819032263243, 218, 27, 'PPL', 'P'),
(133910, 'Alger', 47.1472206115723, 0.822874232836071, -91.692497253418, -1.600335976448, 218, 28, 'PPL', 'P'),
(154037, 'Alger', 40.7061080932617, 0.710455611900128, -83.8438873291016, -1.46335189156398, 218, 41, 'PPL', 'P'),
(206666, 'Alger', 48.6199989318848, 0.848579063677515, -122.339996337891, -2.135235742974, 218, 56, 'PPL', 'P'),
(107937, 'Algeria (historical)', 39.4180603027344, 0.687974937032388, -81.0527801513672, -1.41463788153647, 218, 58, 'PPL', 'P'),
(124101, 'Algerie Four Corners', 42.2186088562012, 0.736853730152348, -73.0311126708984, -1.27463337250213, 218, 23, 'PPL', 'P'),
(179667, 'Algerine', 37.9111099243164, 0.66167369126482, -120.382217407227, -2.10106605460774, 218, 6, 'PPL', 'P'),
(92183, 'Algerita', 31.2277793884277, 0.545027568414485, -98.852783203125, -1.72530654165468, 218, 51, 'PPL', 'P'),
(18786, 'Algernon (historical)', 34.064998626709, 0.594546385723419, -83.7844390869141, -1.46231432400328, 218, 13, 'PPL', 'P'),
(124102, 'Algers Corner', 42.0105590820313, 0.733222576585052, -71.0666732788086, -1.24034743715428, 218, 23, 'PPL', 'P'),
(144724, 'Algers Mills', 40.1652793884277, 0.701016370311478, -74.0749969482422, -1.29285259015158, 218, 37, 'PPL', 'P'),
(29083, 'Algiers', 38.4872207641602, 0.671728722276523, -87.1750030517578, -1.52149082868928, 218, 19, 'PPL', 'P'),
(39063, 'Algiers', 29.9447193145752, 0.522633945624877, -90.0466690063477, -1.5716108546143, 218, 22, 'PPL', 'P'),
(171684, 'Algiers (historical)', 42.8166694641113, 0.747291856886859, -72.5666732788086, -1.2665273759342, 218, 55, 'PPL', 'P'),
(7053, 'Algoa', 35.5058288574219, 0.619693617211628, -91.1166687011719, -1.59028587228431, 218, 4, 'PPL', 'P'),
(92184, 'Algoa', 29.4022197723389, 0.513165542422291, -95.1691665649414, -1.66101530293713, 218, 51, 'PPL', 'P'),
(179668, 'Algodon (historical)', 38.9902801513672, 0.68050876491635, -121.541938781738, -2.12130701099872, 218, 6, 'PPL', 'P'),
(191059, 'Algodon Colonia', 31.6569995880127, 0.55251887411331, -106.302001953125, -1.85531993554347, 218, 51, 'PPL', 'P'),
(188019, 'Algodones', 35.3805618286133, 0.617507295114727, -106.478607177734, -1.85840227818913, 218, 38, 'PPL', 'P'),
(58438, 'Algoma', 34.1761093139648, 0.596485633050187, -89.0311126708984, -1.55388605282122, 218, 30, 'PPL', 'P'),
(99348, 'Algoma', 37.0558280944824, 0.646746207301735, -80.0875015258789, -1.39779059132257, 218, 53, 'PPL', 'P'),
(107938, 'Algoma', 37.4188919067383, 0.653082866220442, -81.4261093139648, -1.42115370461751, 218, 58, 'PPL', 'P'),
(172870, 'Algoma', 44.6088905334473, 0.778572015470384, -87.432502746582, -1.52598504618684, 218, 57, 'PPL', 'P'),
(194507, 'Algoma', 48.1969413757324, 0.841195316397216, -116.571113586426, -2.03454974479943, 218, 17, 'PPL', 'P'),
(200310, 'Algoma', 42.3472213745117, 0.739098442056148, -121.814437866211, -2.12606301723144, 218, 43, 'PPL', 'P'),
(99349, 'Algoma Park', 37.2208290100098, 0.649626016546492, -79.9944381713867, -1.39616632937373, 218, 53, 'PPL', 'P'),
(114376, 'Algona', 43.0699996948242, 0.751713303507636, -94.232780456543, -1.64467228227564, 218, 16, 'PPL', 'P'),
(206667, 'Algona', 47.2791709899902, 0.825177201388717, -122.250831604004, -2.13367952479101, 218, 56, 'PPL', 'P'),
(129471, 'Algonac', 42.6183280944824, 0.743830146943919, -82.5311126708984, -1.44043965144159, 218, 27, 'PPL', 'P'),
(44315, 'Algonquin', 38.5827789306641, 0.673396526909185, -76.1061096191406, -1.32830219373773, 218, 25, 'PPL', 'P'),
(118590, 'Algonquin', 42.1655616760254, 0.735927882199382, -88.2941665649414, -1.54102391686252, 218, 18, 'PPL', 'P'),
(107939, 'Algonquin (historical)', 37.452220916748, 0.653664567181543, -81.2997207641602, -1.4189478082866, 218, 58, 'PPL', 'P'),
(99350, 'Algonquin Hills', 38.6863899230957, 0.675204879868376, -77.4272232055664, -1.35135997561369, 218, 53, 'PPL', 'P'),
(99351, 'Algonquin Park', 36.9086112976074, 0.644176789482026, -76.2930603027344, -1.3315650987053, 218, 53, 'PPL', 'P'),
(84616, 'Algood', 36.1958312988281, 0.631736431660966, -85.4486083984375, -1.49135955780001, 218, 50, 'PPL', 'P'),
(179669, 'Algoso', 35.3597183227539, 0.617143507309823, -118.924171447754, -2.07561835196954, 218, 6, 'PPL', 'P'),
(99352, 'Algren', 36.7747192382813, 0.641839932204509, -76.4466705322266, -1.33424610297468, 218, 53, 'PPL', 'P'),
(26347, 'Alhambra', 38.8883285522461, 0.678729373834014, -89.7313919067383, -1.56610823116998, 218, 18, 'PPL', 'P'),
(34527, 'Alhambra', 38.4902801513672, 0.671782118656379, -83.945556640625, -1.4651263557983, 218, 21, 'PPL', 'P'),
(39064, 'Alhambra', 30.1763896942139, 0.526677356528917, -91.1230621337891, -1.59039745873399, 218, 22, 'PPL', 'P'),
(58440, 'Alhambra', 33.0277786254883, 0.576443481634578, -91.0599975585938, -1.58929677425546, 218, 30, 'PPL', 'P'),
(99353, 'Alhambra', 37.7866706848145, 0.659501816816833, -79.0899963378906, -1.38038084148645, 218, 53, 'PPL', 'P'),
(179670, 'Alhambra', 34.0952796936035, 0.595074890041745, -118.126106262207, -2.06168948683621, 218, 6, 'PPL', 'P'),
(193001, 'Alhambra', 33.4983291625977, 0.584656137804164, -112.133613586426, -1.95710075924218, 218, 5, 'PPL', 'P'),
(195852, 'Alhambra', 46.4513893127441, 0.810729685633091, -111.987503051758, -1.95455064934037, 218, 31, 'PPL', 'P'),
(188020, 'Alhambra (historical)', 32.7213897705078, 0.571095987323753, -108.509437561035, -1.89384695492727, 218, 38, 'PPL', 'P'),
(193000, 'Ali Ak Chin', 31.858060836792, 0.55602805490268, -112.540000915527, -1.96419355617339, 218, 5, 'PPL', 'P'),
(193002, 'Ali Chuk', 31.8150005340576, 0.55527651084306, -112.556106567383, -1.96447465282644, 218, 5, 'PPL', 'P'),
(193004, 'Ali Chukson', 31.913610458374, 0.556997578697523, -111.798606872559, -1.95125378906891, 218, 5, 'PPL', 'P'),
(193003, 'Ali Molina', 31.8999996185303, 0.556760024728288, -111.773612976074, -1.95081756328235, 218, 5, 'PPL', 'P'),
(193091, 'Ali Oidak', 32.3041687011719, 0.563814105955149, -112.025001525879, -1.95520512117826, 218, 5, 'PPL', 'P'),
(158595, 'Alica', 40.0080604553223, 0.698272382282315, -79.9286117553711, -1.39501744167947, 218, 45, 'PPL', 'P'),
(39065, 'Alice', 30.9197196960449, 0.539650912489724, -91.2975006103516, -1.59344198449217, 218, 22, 'PPL', 'P'),
(53151, 'Alice', 37.2983283996582, 0.650978636064143, -92.188606262207, -1.60899471210018, 218, 29, 'PPL', 'P'),
(58439, 'Alice', 32.910831451416, 0.574402368396114, -89.2799987792969, -1.55822993487525, 218, 30, 'PPL', 'P'),
(71642, 'Alice', 39.021110534668, 0.681046856614601, -82.3727798461914, -1.43767622233647, 218, 41, 'PPL', 'P'),
(92186, 'Alice', 27.7519397735596, 0.484362722863784, -98.0694427490234, -1.71163467156654, 218, 51, 'PPL', 'P'),
(107940, 'Alice', 38.997501373291, 0.680634799014939, -80.8161087036133, -1.4105071855277, 218, 58, 'PPL', 'P'),
(112728, 'Alice', 34.1291694641113, 0.595666378119851, -86.2402801513672, -1.50517683648367, 218, 2, 'PPL', 'P'),
(114378, 'Alice', 42.1974983215332, 0.736485281815535, -91.695556640625, -1.60038937282786, 218, 16, 'PPL', 'P'),
(139580, 'Alice', 46.7619400024414, 0.816149817662648, -97.5555572509766, -1.70266567764737, 218, 34, 'PPL', 'P'),
(146755, 'Alice', 42.0208282470703, 0.733401807326414, -77.6141662597656, -1.3546227474232, 218, 40, 'PPL', 'P'),
(158597, 'Alice', 40.1641693115234, 0.700996995814548, -79.4599990844727, -1.38683860765573, 218, 45, 'PPL', 'P'),
(186323, 'Alice', 39.8183288574219, 0.694960941203884, -105.642219543457, -1.84380456014803, 218, 7, 'PPL', 'P'),
(195853, 'Alice (historical)', 46.9472198486328, 0.819383561016277, -107.578330993652, -1.8775960796395, 218, 31, 'PPL', 'P'),
(92187, 'Alice Acres', 27.7283306121826, 0.483950665264122, -98.1144409179688, -1.712420037772, 218, 51, 'PPL', 'P'),
(92188, 'Alice Acres Colonia', 27.7250003814697, 0.483892541773331, -98.1179962158203, -1.7124820894254, 218, 51, 'PPL', 'P'),
(39066, 'Alice B', 29.7761096954346, 0.519691152620339, -91.7569427490234, -1.6014607625344, 218, 22, 'PPL', 'P'),
(18789, 'Alice Ingram Subdivision', 32.5286102294922, 0.567731349602547, -83.892219543457, -1.46419544783926, 218, 13, 'PPL', 'P'),
(200311, 'Alicel', 45.4044418334961, 0.792457005024758, -117.978889465332, -2.0591200690165, 218, 43, 'PPL', 'P'),
(34528, 'Aliceton', 37.5908317565918, 0.656083782715771, -85.0299987792969, -1.48405344166549, 218, 21, 'PPL', 'P'),
(31625, 'Aliceville', 38.1544418334961, 0.665920634255169, -95.5516662597656, -1.66769118199969, 218, 20, 'PPL', 'P'),
(112727, 'Aliceville', 33.1294403076172, 0.578217812710843, -88.1513900756836, -1.53853199703053, 218, 2, 'PPL', 'P'),
(118592, 'Aliceville', 41.5522193908691, 0.725223039881699, -89.8794403076172, -1.56869216321762, 218, 18, 'PPL', 'P'),
(7054, 'Alicia', 35.8930587768555, 0.626452054267977, -91.0827789306641, -1.58969438420621, 218, 4, 'PPL', 'P'),
(129473, 'Alicia', 43.2708282470703, 0.755218422976343, -84.0325012207031, -1.46664382498742, 218, 27, 'PPL', 'P'),
(179671, 'Alicia', 39.1027793884277, 0.682472247009039, -121.580558776855, -2.12198105707062, 218, 6, 'PPL', 'P'),
(179672, 'Alico', 36.5697212219238, 0.638262041859015, -117.962219238281, -2.05882911866741, 218, 6, 'PPL', 'P'),
(31626, 'Alida', 39.0958290100098, 0.682350940021386, -96.9400024414063, -1.69192221949388, 218, 20, 'PPL', 'P'),
(122124, 'Alida', 41.5105590820313, 0.72449593032508, -86.9030609130859, -1.51674454299454, 218, 19, 'PPL', 'P'),
(133911, 'Alida', 47.3836097717285, 0.827000001996821, -95.2344436645508, -1.66215460325147, 218, 28, 'PPL', 'P'),
(92189, 'Alief', 29.7108306884766, 0.51855181901649, -95.5961074829102, -1.66846682766717, 218, 51, 'PPL', 'P'),
(211459, 'Alii Kai', 19.6155605316162, 0.342356115900952, -155.978057861328, -2.7223306705464, 218, 15, 'PPL', 'P'),
(154038, 'Alikanna', 40.3875007629395, 0.704894864965015, -80.6361083984375, -1.40736558754779, 218, 41, 'PPL', 'P'),
(74966, 'Alikchi', 34.1627807617188, 0.596253005928969, -95.0688934326172, -1.65926520662678, 218, 42, 'PPL', 'P'),
(179673, 'Alimur Park Mobile Home Park', 36.9866714477539, 0.645539196116684, -121.960563659668, -2.12861339344935, 218, 6, 'PPL', 'P'),
(158598, 'Alinda', 40.3463897705078, 0.704177342788321, -77.2847213745117, -1.34887284947167, 218, 45, 'PPL', 'P'),
(18787, 'Aline', 32.3608283996582, 0.564803004246923, -82.1605606079102, -1.43397229789239, 218, 13, 'PPL', 'P'),
(39067, 'Aline', 30.6130599975586, 0.534298691067965, -91.64111328125, -1.59943915695092, 218, 22, 'PPL', 'P'),
(74967, 'Aline', 36.5097198486328, 0.637214820339368, -98.4486083984375, -1.71825236055928, 218, 42, 'PPL', 'P'),
(158599, 'Aline', 40.6805610656738, 0.710009732154621, -76.9875030517578, -1.34368541114236, 218, 45, 'PPL', 'P'),
(18788, 'Aline Estates', 33.6624984741211, 0.58752143282098, -84.7986068725586, -1.48001489103044, 218, 13, 'PPL', 'P'),
(158602, 'Aliquippa', 40.6366691589355, 0.70924367386706, -80.2402801513672, -1.40045708136401, 218, 45, 'PPL', 'P'),
(188021, 'Alire', 36.476390838623, 0.636633119378268, -106.580276489258, -1.86017674242345, 218, 38, 'PPL', 'P'),
(13271, 'Alisa Estates', 39.3461112976074, 0.686719189999388, -75.6383285522461, -1.32013787394193, 218, 10, 'PPL', 'P'),
(179675, 'Aliso', 33.7269401550293, 0.588646152328348, -117.832221984863, -2.05656023857671, 218, 6, 'PPL', 'P'),
(179676, 'Aliso Viejo', 33.6083297729492, 0.586576010634002, -117.744438171387, -2.05502812200159, 218, 6, 'PPL', 'P'),
(188022, 'Alivio', 32.836669921875, 0.573108005527308, -107.020278930664, -1.8678562337428, 218, 38, 'PPL', 'P'),
(7055, 'Alix', 35.4247207641602, 0.618278013934196, -93.7302780151367, -1.63590196017379, 218, 4, 'PPL', 'P'),
(191060, 'Aljo Estates Colonia', 31.6229991912842, 0.551925455243413, -106.26000213623, -1.85458690045343, 218, 51, 'PPL', 'P'),
(99359, 'Alka (historical)', 37.0311088562012, 0.646314775205142, -82.4741668701172, -1.43944575972277, 218, 53, 'PPL', 'P'),
(197921, 'Alkabo', 48.8627815246582, 0.852816419287941, -103.889717102051, -1.81321762239625, 218, 34, 'PPL', 'P'),
(189859, 'Alkali', 37.8258285522461, 0.660185250531574, -117.336669921875, -2.04791122346252, 218, 39, 'PPL', 'P'),
(112729, 'Alkehatchee (historical)', 32.8666687011719, 0.573631582997618, -85.9097213745117, -1.49940749745618, 218, 2, 'PPL', 'P'),
(206668, 'Alki', 47.5763893127441, 0.830364639718027, -122.40860748291, -2.13643323335815, 218, 56, 'PPL', 'P'),
(107941, 'Alkires Mills', 38.978328704834, 0.68030017282397, -80.4516677856445, -1.40414649158015, 218, 58, 'PPL', 'P'),
(107942, 'Alkol', 38.1627807617188, 0.666066176008742, -81.9250030517578, -1.42986104295958, 218, 58, 'PPL', 'P'),
(53152, 'All', 37.1805610656738, 0.64892320833482, -93.0358276367188, -1.62378151457868, 218, 29, 'PPL', 'P'),
(53153, 'All Saints Village', 38.7605590820313, 0.676499375895236, -90.6613922119141, -1.58233979853985, 218, 29, 'PPL', 'P'),
(179678, 'Alla', 33.9811096191406, 0.59308224633512, -118.428886413574, -2.06697399738725, 218, 6, 'PPL', 'P'),
(146757, 'Allaben', 42.1166687011719, 0.735074538807093, -74.3708267211914, -1.29801579371497, 218, 40, 'PPL', 'P'),
(126748, 'Allagash', 47.0833282470703, 0.821759100708627, -69.0416717529297, -1.20500449316979, 218, 26, 'PPL', 'P'),
(193005, 'Allah', 33.9280586242676, 0.592156331803127, -112.690002441406, -1.96681157668299, 218, 5, 'PPL', 'P'),
(144725, 'Allaire', 40.1583290100098, 0.700895063323825, -74.1258316040039, -1.29373982226874, 218, 37, 'PPL', 'P'),
(34529, 'Allais', 37.2666702270508, 0.650426096716979, -83.1822204589844, -1.45180362612907, 218, 21, 'PPL', 'P'),
(212272, 'Allakaket', 66.565559387207, 1.16178817973858, -152.645553588867, -2.66416749865518, 218, 1, 'PPL', 'P'),
(191061, 'Allamoore', 31.0780601501465, 0.5424144747529, -105.003059387207, -1.8326491109739, 218, 51, 'PPL', 'P'),
(144726, 'Allamuchy', 40.9216690063477, 0.714217859572083, -74.8105621337891, -1.30569062450241, 218, 37, 'PPL', 'P'),
(193093, 'Allan Lake Landing', 34.8252792358398, 0.60781578559182, -111.435829162598, -1.94492212357724, 218, 5, 'PPL', 'P'),
(44316, 'Allana Acres', 39.7136116027832, 0.693133280326789, -76.915283203125, -1.34242493699842, 218, 25, 'PPL', 'P'),
(14965, 'Allandale', 29.1213893890381, 0.508264127594054, -80.9766693115234, -1.41330949678473, 218, 12, 'PPL', 'P'),
(44317, 'Allandale', 39.6286087036133, 0.691649699862533, -77.0647201538086, -1.34503310381199, 218, 25, 'PPL', 'P'),
(71643, 'Allandale (historical)', 39.2011108398438, 0.684188454594513, -84.3397216796875, -1.47200583352619, 218, 41, 'PPL', 'P'),
(133912, 'Allansons Park', 44.5283317565918, 0.777165999572877, -93.9075012207031, -1.63899508862186, 218, 28, 'PPL', 'P'),
(14966, 'Allanton', 30.0313892364502, 0.524146621124042, -85.4577789306641, -1.49151961378153, 218, 12, 'PPL', 'P'),
(44318, 'Allanwood', 39.1105613708496, 0.682608068224633, -77.0366668701172, -1.34454348164558, 218, 25, 'PPL', 'P'),
(14967, 'Allapattah', 25.8141708374023, 0.450542274784973, -80.2241668701172, -1.4001758515529, 218, 12, 'PPL', 'P'),
(195854, 'Allard', 47.038890838623, 0.820983521620169, -104.566673278809, -1.82503273657238, 218, 31, 'PPL', 'P'),
(195855, 'Allard (historical)', 47.7483291625977, 0.833365556213356, -114.023612976074, -1.99008747145223, 218, 31, 'PPL', 'P'),
(84618, 'Allardt', 36.3808288574219, 0.634965248166578, -84.8844375610352, -1.48151291914361, 218, 50, 'PPL', 'P'),
(18790, 'Allatoona', 34.1080589294434, 0.595297929783039, -84.7113876342773, -1.47849262815135, 218, 13, 'PPL', 'P'),
(18791, 'Allatoona Bay', 34.0486106872559, 0.594260362222344, -84.7238922119141, -1.47871087420268, 218, 13, 'PPL', 'P'),
(18792, 'Allatoona Beach', 34.1108283996582, 0.595346266156824, -84.7074966430664, -1.47842471754355, 218, 13, 'PPL', 'P'),
(18793, 'Allatoona Heights', 34.0558280944824, 0.594386329741905, -84.7399978637695, -1.47899197085574, 218, 13, 'PPL', 'P'),
(18794, 'Allatoona Pass', 34.1150016784668, 0.595419103612638, -84.5994415283203, -1.47653880001761, 218, 13, 'PPL', 'P'),
(18796, 'Allatoona Ridge', 34.0433311462402, 0.594168216848627, -84.7002792358398, -1.47829875002399, 218, 13, 'PPL', 'P'),
(53154, 'Allbright', 37.3288917541504, 0.651512067230486, -90.2266693115234, -1.57475245259421, 218, 29, 'PPL', 'P'),
(7057, 'Allbrook', 33.7999992370605, 0.589921273858278, -93.8886108398438, -1.63866538927891, 218, 4, 'PPL', 'P'),
(71644, 'Alledonia', 39.898609161377, 0.696362096832401, -80.9694366455078, -1.41318326294906, 218, 41, 'PPL', 'P'),
(7058, 'Alleene', 33.7700004577637, 0.589397696387968, -94.2602767944336, -1.64515218390407, 218, 4, 'PPL', 'P'),
(129474, 'Allegan', 42.5291709899902, 0.742274061918986, -85.8552780151367, -1.49845728157924, 218, 27, 'PPL', 'P'),
(146758, 'Allegany', 42.0900001525879, 0.734609084827574, -78.4944381713867, -1.36998639059382, 218, 40, 'PPL', 'P'),
(200312, 'Allegany', 43.4261093139648, 0.757928588859663, -124.031112670898, -2.16475129101924, 218, 43, 'PPL', 'P'),
(44320, 'Allegany Grove', 39.6399993896484, 0.691848504837908, -78.8283309936523, -1.37581391969113, 218, 25, 'PPL', 'P'),
(99354, 'Alleghany', 37.7472190856934, 0.658813256516993, -80.2405624389648, -1.40046200821203, 218, 53, 'PPL', 'P'),
(179679, 'Alleghany', 39.4697189331055, 0.688876550219434, -120.842216491699, -2.10909455318794, 218, 6, 'PPL', 'P'),
(84619, 'Alleghany (historical)', 35.6650009155273, 0.622471693702744, -84.1983337402344, -1.46953814846012, 218, 50, 'PPL', 'P'),
(99358, 'Alleghany Springs', 37.128059387207, 0.648006881182751, -80.2652816772461, -1.40089344030862, 218, 53, 'PPL', 'P'),
(62477, 'Allegheny', 35.9883308410645, 0.628114865473595, -82.6675033569336, -1.44282011798196, 218, 33, 'PPL', 'P'),
(158603, 'Allegheny (historical)', 40.4505615234375, 0.705995482864518, -80.0163879394531, -1.39654942509654, 218, 45, 'PPL', 'P'),
(158604, 'Allegheny Acres', 40.6152801513672, 0.708870365261258, -79.8702774047852, -1.39399931519473, 218, 45, 'PPL', 'P'),
(158608, 'Allegheny Furnace', 40.4897193908691, 0.706678916579259, -78.4075012207031, -1.36846905456274, 218, 45, 'PPL', 'P'),
(158609, 'Allegheny Springs', 41.8266716003418, 0.73001313457637, -79.3041687011719, -1.38411885439248, 218, 45, 'PPL', 'P'),
(84620, 'Allegheny Springs (historical)', 35.5852813720703, 0.621080325191232, -84.0438919067383, -1.4668426299628, 218, 50, 'PPL', 'P'),
(158610, 'Allegheny West', 40.0083312988281, 0.69827710939325, -75.1783294677734, -1.31210937536172, 218, 45, 'PPL', 'P'),
(158617, 'Alleghenyville', 40.2341690063477, 0.702218720964622, -75.9888916015625, -1.32625635338833, 218, 45, 'PPL', 'P'),
(34530, 'Allegre', 36.9286117553711, 0.644525863321908, -87.2172164916992, -1.52222759220485, 218, 21, 'PPL', 'P'),
(114380, 'Alleman', 41.8199996948242, 0.729896687857706, -93.6113891601563, -1.63382695821046, 218, 16, 'PPL', 'P'),
(39068, 'Allemand', 29.6599998474121, 0.517664653478357, -90.7655563354492, -1.58415780545799, 218, 22, 'PPL', 'P'),
(39070, 'Allemania', 30.2611103057861, 0.528156010145156, -91.2183303833008, -1.59206020336058, 218, 22, 'PPL', 'P'),
(158618, 'Allemans', 40.7266693115234, 0.710814472857016, -78.404167175293, -1.36841086449292, 218, 45, 'PPL', 'P'),
(18798, 'Allen', 33.9455604553223, 0.592461796380159, -83.5438919067383, -1.45811598370283, 218, 13, 'PPL', 'P'),
(31627, 'Allen', 38.6561088562012, 0.67467637555005, -96.1694412231445, -1.67847338914703, 218, 20, 'PPL', 'P'),
(39071, 'Allen', 31.8352794647217, 0.555630444951931, -93.288330078125, -1.62818851355054, 218, 22, 'PPL', 'P'),
(44321, 'Allen', 38.2872200012207, 0.668238050456729, -75.6883316040039, -1.32101059183115, 218, 25, 'PPL', 'P'),
(58444, 'Allen', 31.7483291625977, 0.554112875894263, -90.658332824707, -1.58228640215999, 218, 30, 'PPL', 'P'),
(62478, 'Allen', 35.225830078125, 0.614806716611333, -80.6141662597656, -1.40698262498303, 218, 33, 'PPL', 'P'),
(74969, 'Allen', 34.8788909912109, 0.608751487240819, -96.4122161865234, -1.68271061159941, 218, 42, 'PPL', 'P'),
(79505, 'Allen', 33.9211082458496, 0.592035024815474, -79.0408325195313, -1.37952277098323, 218, 48, 'PPL', 'P'),
(84621, 'Allen', 35.435001373291, 0.618457444412641, -84.8522186279297, -1.48095059267944, 218, 50, 'PPL', 'P'),
(92190, 'Allen', 33.1030616760254, 0.577757418737396, -96.670280456543, -1.687214682793, 218, 51, 'PPL', 'P'),
(114381, 'Allen', 41.8050003051758, 0.729634899122552, -95.8183288574219, -1.67234532232071, 218, 16, 'PPL', 'P'),
(118593, 'Allen', 40.3050003051758, 0.703454960342637, -89.6494369506836, -1.56467784734849, 218, 18, 'PPL', 'P'),
(122125, 'Allen', 41.2000007629395, 0.719075665137469, -85.1958312988281, -1.48694776513819, 218, 19, 'PPL', 'P'),
(129478, 'Allen', 41.9569396972656, 0.732286741777998, -84.7677764892578, -1.47947679933219, 218, 27, 'PPL', 'P'),
(133913, 'Allen', 47.5163917541504, 0.829317484777408, -92.0986099243164, -1.60742397968925, 218, 28, 'PPL', 'P'),
(141150, 'Allen', 42.416389465332, 0.740305652978281, -96.8450012207031, -1.6902641353992, 218, 35, 'PPL', 'P'),
(158620, 'Allen', 41.8827781677246, 0.730992378909192, -78.5733337402344, -1.37136337803544, 218, 45, 'PPL', 'P'),
(172873, 'Allen', 44.6613883972168, 0.779488276043426, -91.3666687011719, -1.5946491954143, 218, 57, 'PPL', 'P'),
(179681, 'Allen', 38.6172218322754, 0.673997668946243, -120.109718322754, -2.09631004837502, 218, 6, 'PPL', 'P'),
(193239, 'Allen', 48.5166702270508, 0.846775637566341, -122.375831604004, -2.135861186356, 218, 56, 'PPL', 'P'),
(201854, 'Allen', 43.2808303833008, 0.755392993185798, -101.923889160156, -1.77890745228248, 218, 49, 'PPL', 'P'),
(107943, 'Allen (historical)', 38.122501373291, 0.665363168059988, -82.0755615234375, -1.43248878400716, 218, 58, 'PPL', 'P'),
(188023, 'Allen (historical)', 35.0122184753418, 0.611078490822303, -103.138061523438, -1.80009875770846, 218, 38, 'PPL', 'P'),
(195856, 'Allen (historical)', 47.0722198486328, 0.821565222581269, -106.484443664551, -1.85850414410083, 218, 31, 'PPL', 'P'),
(62479, 'Allen Acres', 35.3177795410156, 0.616411537484214, -81.5169372558594, -1.42273895125638, 218, 33, 'PPL', 'P'),
(146762, 'Allen Center', 42.3861083984375, 0.739777148659955, -78.0155563354492, -1.36162832582871, 218, 40, 'PPL', 'P'),
(154039, 'Allen Center', 40.2416687011719, 0.702349615332199, -83.4780578613281, -1.45696696285051, 218, 41, 'PPL', 'P'),
(92191, 'Allen Chapel', 31.3722190856934, 0.547548516702354, -95.1502838134766, -1.66068573675223, 218, 51, 'PPL', 'P'),
(34531, 'Allen City', 37.6094398498535, 0.656408555210706, -82.727783203125, -1.44387219977059, 218, 21, 'PPL', 'P'),
(146763, 'Allen Corners', 41.4705581665039, 0.723797782645316, -73.7491683959961, -1.28716580911788, 218, 40, 'PPL', 'P'),
(29085, 'Allen Crossing', 39.103889465332, 0.682491621505969, -85.3169403076172, -1.48906151609538, 218, 19, 'PPL', 'P'),
(53155, 'Allen Ford', 36.5372200012207, 0.637694788546828, -91.5177764892578, -1.59728652384181, 218, 29, 'PPL', 'P'),
(62481, 'Allen Grove', 36.3052787780762, 0.633646650531853, -77.6447219848633, -1.35515604543149, 218, 33, 'PPL', 'P'),
(84622, 'Allen Grove', 35.8411102294922, 0.625545381074859, -83.2174987792969, -1.45241934897309, 218, 50, 'PPL', 'P'),
(62483, 'Allen Jay', 35.9238891601563, 0.626990145966227, -79.9655609130859, -1.39566232613743, 218, 33, 'PPL', 'P'),
(107944, 'Allen Junction', 37.589168548584, 0.656054754259889, -81.350830078125, -1.41983983409372, 218, 58, 'PPL', 'P'),
(158621, 'Allen Junction', 40.6319389343262, 0.709161115873268, -75.39111328125, -1.31582315350184, 218, 45, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(39072, 'Allen Landing', 30.500560760498, 0.532335208975277, -91.2708282470703, -1.59297646393362, 218, 22, 'PPL', 'P'),
(158622, 'Allen Lane', 40.0563888549805, 0.699115871978571, -75.1977767944336, -1.31244879524265, 218, 45, 'PPL', 'P'),
(18799, 'Allen Mill (historical)', 33.0497207641602, 0.576826444199331, -83.1013870239258, -1.4503928165416, 218, 13, 'PPL', 'P'),
(53156, 'Allen Mills', 37.5044403076172, 0.654575967485595, -90.6947174072266, -1.58292143292192, 218, 29, 'PPL', 'P'),
(129480, 'Allen Park', 42.2574996948242, 0.737532503335182, -83.2111129760742, -1.45230789568147, 218, 27, 'PPL', 'P'),
(92192, 'Allen Point', 33.644718170166, 0.587211107974959, -95.9075012207031, -1.67390167366175, 218, 51, 'PPL', 'P'),
(99360, 'Allen Shop Corner', 37.7055587768555, 0.658086146960374, -76.8450012207031, -1.34119828500033, 218, 53, 'PPL', 'P'),
(34533, 'Allen Springs', 36.8316688537598, 0.642833890502354, -86.3150024414063, -1.50648098646948, 218, 21, 'PPL', 'P'),
(84623, 'Allenbridge (historical)', 36.0697212219238, 0.629535395599043, -82.9000015258789, -1.44687797653491, 218, 50, 'PPL', 'P'),
(99361, 'Allencrest', 38.8933296203613, 0.678816658938741, -77.1505584716797, -1.34653126508321, 218, 53, 'PPL', 'P'),
(7060, 'Allendale', 34.8102798461914, 0.607553996856665, -91.2663879394531, -1.5928989659459, 218, 4, 'PPL', 'P'),
(18801, 'Allendale', 32.5277786254883, 0.567716835374606, -84.9255599975586, -1.48223064105738, 218, 13, 'PPL', 'P'),
(26350, 'Allendale', 38.526668548584, 0.672417215997336, -87.709716796875, -1.53082334409724, 218, 18, 'PPL', 'P'),
(29084, 'Allendale', 39.3916702270508, 0.687514343321858, -87.3958282470703, -1.52534495541884, 218, 19, 'PPL', 'P'),
(34535, 'Allendale', 37.3711090087891, 0.652248897325084, -85.5830612182617, -1.49370620219454, 218, 21, 'PPL', 'P'),
(39074, 'Allendale', 30.4963893890381, 0.532262404808976, -91.2727813720703, -1.59301055239557, 218, 22, 'PPL', 'P'),
(62484, 'Allendale', 35.3147201538086, 0.616358141104358, -81.5136108398438, -1.42268089434461, 218, 33, 'PPL', 'P'),
(79510, 'Allendale', 34.4297218322754, 0.60091200651898, -82.7583312988281, -1.44440536462083, 218, 48, 'PPL', 'P'),
(92194, 'Allendale', 33.8574981689453, 0.590924819536047, -98.5933303833008, -1.72077823569516, 218, 51, 'PPL', 'P'),
(129484, 'Allendale', 42.9722213745117, 0.750006749881113, -85.95361328125, -1.50017355574374, 218, 27, 'PPL', 'P'),
(139007, 'Allendale', 40.4855613708496, 0.706606345439555, -94.288330078125, -1.64564180607048, 218, 29, 'PPL', 'P'),
(144728, 'Allendale', 41.041389465332, 0.716307375763359, -74.1294403076172, -1.29380280602852, 218, 37, 'PPL', 'P'),
(146765, 'Allendale', 43.7805595397949, 0.764114912334835, -76.0169372558594, -1.32674584239669, 218, 40, 'PPL', 'P'),
(158625, 'Allendale', 40.2238883972168, 0.702039290486178, -76.8905563354492, -1.34199337174377, 218, 45, 'PPL', 'P'),
(169250, 'Allendale', 41.8499984741211, 0.730420265328016, -71.4711074829102, -1.24740614562354, 218, 47, 'PPL', 'P'),
(177179, 'Allendale', 40.0186080932617, 0.698456473292667, -80.70361328125, -1.40854377001404, 218, 58, 'PPL', 'P'),
(179682, 'Allendale', 38.4447212219238, 0.670986965333908, -121.941940307617, -2.12828835463831, 218, 6, 'PPL', 'P'),
(194508, 'Allendale', 43.6763916015625, 0.762296838837665, -116.873893737793, -2.03983425535047, 218, 17, 'PPL', 'P'),
(209263, 'Allendale', 42.8147201538086, 0.747257835003933, -106.309997558594, -1.85545948518459, 218, 59, 'PPL', 'P'),
(58445, 'Allendale (historical)', 33.3944396972656, 0.582842924575984, -88.5311126708984, -1.54515940656125, 218, 30, 'PPL', 'P'),
(195857, 'Allendale (historical)', 46.0327796936035, 0.803423569498568, -112.533332824707, -1.96407717603375, 218, 31, 'PPL', 'P'),
(44322, 'Allendale Estates', 39.5811080932617, 0.690820657815192, -76.2525024414063, -1.33085723048755, 218, 25, 'PPL', 'P'),
(18802, 'Allendale Heights', 33.5763893127441, 0.586018544438821, -84.2966690063477, -1.47125442262462, 218, 13, 'PPL', 'P'),
(114385, 'Allendorf', 43.4147186279297, 0.757729783884288, -95.6430587768555, -1.66928628233459, 218, 16, 'PPL', 'P'),
(31631, 'Allendorph', 38.9927787780762, 0.680552374179201, -96.2708282470703, -1.68024292653334, 218, 20, 'PPL', 'P'),
(92195, 'Allenfarm', 30.399169921875, 0.530565605009946, -96.2436065673828, -1.67976781859487, 218, 51, 'PPL', 'P'),
(44323, 'Allenford', 39.3108291625977, 0.686103400576334, -76.8608322143555, -1.34147458796343, 218, 25, 'PPL', 'P'),
(14968, 'Allenhurst', 28.7361106872559, 0.501539745710145, -80.7558288574219, -1.40945510373906, 218, 12, 'PPL', 'P'),
(18803, 'Allenhurst', 31.7838897705078, 0.554733525586306, -81.607780456543, -1.42432446421136, 218, 13, 'PPL', 'P'),
(92196, 'Allenhurst', 29.0091705322266, 0.506305539059869, -95.8444366455078, -1.67280098918322, 218, 51, 'PPL', 'P'),
(144730, 'Allenhurst', 40.2361106872559, 0.702252609689493, -74.001106262207, -1.29156295439371, 218, 37, 'PPL', 'P'),
(158627, 'Allenport', 40.3736114501953, 0.704652450726791, -77.8702774047852, -1.35909273015485, 218, 45, 'PPL', 'P'),
(84624, 'Allens', 35.6411094665527, 0.622054709255065, -89.190559387207, -1.5566689230023, 218, 50, 'PPL', 'P'),
(158628, 'Allens', 41.2419395446777, 0.719807634963078, -76.9797210693359, -1.34354958992676, 218, 45, 'PPL', 'P'),
(92197, 'Allens Chapel', 33.6472091674805, 0.587254584079754, -95.9599533081055, -1.67481713528647, 218, 51, 'PPL', 'P'),
(144732, 'Allens Corner', 40.5466690063477, 0.707672874877104, -74.9388885498047, -1.30793034297917, 218, 37, 'PPL', 'P'),
(118595, 'Allens Corners', 42.0994415283203, 0.734773867920023, -88.4813919067383, -1.54429161552005, 218, 18, 'PPL', 'P'),
(99363, 'Allens Creek', 37.5466690063477, 0.655312997317274, -78.8688888549805, -1.37652178790887, 218, 53, 'PPL', 'P'),
(84627, 'Allens Creek (historical)', 35.4269409179688, 0.618316762928057, -87.595832824707, -1.52883569381766, 218, 50, 'PPL', 'P'),
(62487, 'Allens Crossroads', 34.9119415283203, 0.609328327932931, -80.4077835083008, -1.40338056645065, 218, 33, 'PPL', 'P'),
(112734, 'Allens Crossroads', 34.4277801513672, 0.600878117794109, -86.5419387817383, -1.5104417728007, 218, 2, 'PPL', 'P'),
(158629, 'Allens Crossroads', 40.1361083984375, 0.700507240490083, -79.8430633544922, -1.39352434041432, 218, 45, 'PPL', 'P'),
(112733, 'Allens Factory', 34.2788887023926, 0.598279471781437, -87.7213897705078, -1.53102707592063, 218, 2, 'PPL', 'P'),
(44324, 'Allens Fresh', 38.413890838623, 0.670448873635658, -76.9408264160156, -1.3428707501649, 218, 25, 'PPL', 'P'),
(172874, 'Allens Grove', 42.5802803039551, 0.743166087726108, -88.7624969482422, -1.54919782403824, 218, 57, 'PPL', 'P'),
(146768, 'Allens Hill', 42.8408317565918, 0.747713568445473, -77.5152816772461, -1.35289688587878, 218, 40, 'PPL', 'P'),
(62488, 'Allens Level', 36.3252792358398, 0.633995724371735, -79.021110534668, -1.37917855741233, 218, 33, 'PPL', 'P'),
(99362, 'Allens Mill', 37.2802810668945, 0.650663650686214, -78.5524978637695, -1.37099972338859, 218, 53, 'PPL', 'P'),
(126750, 'Allens Mills', 44.7161102294922, 0.780443352189356, -70.081672668457, -1.2231559333695, 218, 26, 'PPL', 'P'),
(143453, 'Allens Mills', 43.4083290100098, 0.757618264013641, -71.4519424438477, -1.24707165259063, 218, 36, 'PPL', 'P'),
(144733, 'Allens Mills', 40.7400016784668, 0.711047166557262, -75.1188888549805, -1.31107194095908, 218, 37, 'PPL', 'P'),
(158630, 'Allens Mills', 41.1994400024414, 0.719065878020463, -78.9077835083008, -1.37720062767073, 218, 45, 'PPL', 'P'),
(26351, 'Allens Spring', 37.3688888549805, 0.652210148331223, -88.6569366455078, -1.54735544919613, 218, 18, 'PPL', 'P'),
(194509, 'Allens Spur', 48.7405586242676, 0.850683227254787, -116.365280151367, -2.03095727364696, 218, 17, 'PPL', 'P'),
(71645, 'Allensburg', 39.2044410705566, 0.684246578085304, -83.7772216796875, -1.46218835648372, 218, 41, 'PPL', 'P'),
(99365, 'Allenslevel', 37.5616683959961, 0.655574786052429, -78.4897232055664, -1.36990409891613, 218, 53, 'PPL', 'P'),
(194083, 'Allenspark', 40.1944389343262, 0.701525300395793, -105.525001525879, -1.84175871979863, 218, 7, 'PPL', 'P'),
(62489, 'Allenstand', 35.9727783203125, 0.627843422779488, -82.753059387207, -1.44431335240516, 218, 33, 'PPL', 'P'),
(143454, 'Allenstown Elementary School', 43.1577796936035, 0.753245353503731, -71.4061126708984, -1.24627177215722, 218, 36, 'PPL', 'P'),
(29086, 'Allensville', 38.8730583190918, 0.678462857987924, -85.0202789306641, -1.48388379830405, 218, 19, 'PPL', 'P'),
(34534, 'Allensville', 36.7166709899902, 0.640826799146816, -87.0661087036133, -1.51959026377734, 218, 21, 'PPL', 'P'),
(62490, 'Allensville', 36.3902816772461, 0.635130230996109, -78.8888931274414, -1.37687092832778, 218, 33, 'PPL', 'P'),
(71646, 'Allensville', 39.2724990844727, 0.685434414510507, -82.6069412231445, -1.4417631093453, 218, 41, 'PPL', 'P'),
(107945, 'Allensville', 39.5830612182617, 0.690854746277145, -77.9933319091797, -1.36124043641594, 218, 58, 'PPL', 'P'),
(158634, 'Allensville', 40.535831451416, 0.707483723860681, -77.8172225952148, -1.35816674904383, 218, 45, 'PPL', 'P'),
(84625, 'Allensville (historical)', 35.9124984741211, 0.626791340990853, -83.4872207641602, -1.45712688567397, 218, 50, 'PPL', 'P'),
(179683, 'Allensworth', 35.8636093139648, 0.625938064177591, -119.388061523438, -2.08371476115754, 218, 6, 'PPL', 'P'),
(53157, 'Allenton', 38.5036087036133, 0.672014745777597, -90.6758270263672, -1.58259173357897, 218, 29, 'PPL', 'P'),
(62492, 'Allenton', 34.5922203063965, 0.60374813992186, -78.9263916015625, -1.37752540016567, 218, 33, 'PPL', 'P'),
(112735, 'Allenton', 31.9366703033447, 0.557400048917262, -87.0533294677734, -1.51936722403605, 218, 2, 'PPL', 'P'),
(129487, 'Allenton', 42.9194412231445, 0.749085562460054, -82.945556640625, -1.44767306327835, 218, 27, 'PPL', 'P'),
(169251, 'Allenton', 41.5438919067383, 0.725077697865208, -71.4683303833008, -1.2473576760917, 218, 47, 'PPL', 'P'),
(172875, 'Allenton', 43.4205589294434, 0.757831716375011, -88.3408279418945, -1.54183831152387, 218, 57, 'PPL', 'P'),
(112522, 'Allenton Station', 31.9297199249268, 0.557278741929609, -87.0236129760742, -1.51884857341376, 218, 2, 'PPL', 'P'),
(14969, 'Allentown', 30.7625007629395, 0.536906924460561, -87.0422210693359, -1.51917334590869, 218, 12, 'PPL', 'P'),
(18805, 'Allentown', 32.5930595397949, 0.568856202267969, -83.225830078125, -1.45256475756861, 218, 13, 'PPL', 'P'),
(58446, 'Allentown', 34.8572196960449, 0.608373251787001, -88.6050033569336, -1.54644904231912, 218, 30, 'PPL', 'P'),
(79512, 'Allentown', 33.6258316040039, 0.586881475211034, -79.3505630493164, -1.38492858852192, 218, 48, 'PPL', 'P'),
(99364, 'Allentown', 37.6955604553223, 0.657911643329946, -75.6894378662109, -1.32102989974905, 218, 53, 'PPL', 'P'),
(107946, 'Allentown', 38.764720916748, 0.676572013613968, -81.5127792358398, -1.42266638011667, 218, 58, 'PPL', 'P'),
(118597, 'Allentown', 40.5558280944824, 0.707832731121536, -89.3966674804688, -1.56026618784472, 218, 18, 'PPL', 'P'),
(144734, 'Allentown', 40.1777801513672, 0.701234549783783, -74.5838928222656, -1.3017344987031, 218, 37, 'PPL', 'P'),
(146767, 'Allentown', 43.3250007629395, 0.756163911742349, -73.9552764892578, -1.2907630739603, 218, 40, 'PPL', 'P'),
(154045, 'Allentown', 40.7547187805176, 0.7113040284444, -84.1947174072266, -1.46947503154229, 218, 41, 'PPL', 'P'),
(158632, 'Allentown', 40.6083297729492, 0.708749058273605, -75.4905624389648, -1.3175588687423, 218, 45, 'PPL', 'P'),
(177434, 'Allentown', 41.6488914489746, 0.726910285590319, -72.9908294677734, -1.27393029797435, 218, 8, 'PPL', 'P'),
(193094, 'Allentown', 35.2919387817383, 0.615960531153609, -109.157783508301, -1.90516272639902, 218, 5, 'PPL', 'P'),
(195858, 'Allentown', 47.440559387207, 0.827993960294666, -114.095558166504, -1.9913431519062, 218, 31, 'PPL', 'P'),
(206670, 'Allentown', 47.4944381713867, 0.828934322475573, -122.275001525879, -2.13410136950768, 218, 56, 'PPL', 'P'),
(200313, 'Allentown (historical)', 42.0444412231445, 0.733813931505104, -123.625, -2.15766328777799, 218, 43, 'PPL', 'P'),
(158635, 'Allenvale', 40.0800018310547, 0.69952799615726, -79.142219543457, -1.38129230836953, 218, 45, 'PPL', 'P'),
(158636, 'Allenview', 40.1783294677734, 0.701244137163707, -76.9700012207031, -1.34337994656532, 218, 45, 'PPL', 'P'),
(18806, 'Allenville', 31.1288890838623, 0.543301607001518, -83.2141723632813, -1.45236129206133, 218, 13, 'PPL', 'P'),
(26352, 'Allenville', 39.5555610656738, 0.690374778069685, -88.5297164916992, -1.54513503863727, 218, 18, 'PPL', 'P'),
(44325, 'Allenville', 39.0602798461914, 0.681730490066424, -76.523063659668, -1.33557941457443, 218, 25, 'PPL', 'P'),
(53158, 'Allenville', 37.2216682434082, 0.649640663932487, -89.7574996948242, -1.56656389803249, 218, 29, 'PPL', 'P'),
(112737, 'Allenville', 30.7027797698975, 0.535864596499418, -88.0788879394531, -1.53726659603858, 218, 2, 'PPL', 'P'),
(129488, 'Allenville', 45.9847183227539, 0.80258474033422, -84.820556640625, -1.48039798675325, 218, 27, 'PPL', 'P'),
(172876, 'Allenville', 44.1330604553223, 0.770267213927081, -88.6188888549805, -1.54669138997832, 218, 57, 'PPL', 'P'),
(193095, 'Allenville', 33.3519401550293, 0.582101167633369, -112.585830688477, -1.96499343660679, 218, 5, 'PPL', 'P'),
(18807, 'Allenwood', 33.0697212219238, 0.577175518039213, -83.2613906860352, -1.45318540726065, 218, 13, 'PPL', 'P'),
(144736, 'Allenwood', 40.1413917541504, 0.700599452442827, -74.1002807617188, -1.2932938759442, 218, 37, 'PPL', 'P'),
(158637, 'Allenwood', 41.1074981689453, 0.717461190305636, -76.8986129760742, -1.34213398664933, 218, 45, 'PPL', 'P'),
(26353, 'Allerton', 39.9116706848145, 0.696590063421712, -87.936393737793, -1.53477960305461, 218, 18, 'PPL', 'P'),
(114387, 'Allerton', 40.7063903808594, 0.710460538748145, -93.3649978637695, -1.62952661884025, 218, 16, 'PPL', 'P'),
(124103, 'Allerton', 42.3041687011719, 0.738347031154582, -70.8838882446289, -1.23715723648448, 218, 23, 'PPL', 'P'),
(144737, 'Allerton', 40.6111106872559, 0.708797594384472, -74.8788909912109, -1.30688318803855, 218, 37, 'PPL', 'P'),
(53159, 'Alley', 37.1522216796875, 0.648428592741365, -91.4433288574219, -1.59598716754596, 218, 29, 'PPL', 'P'),
(107947, 'Alley Grove', 39.9608306884766, 0.697448067345908, -80.5263900756836, -1.40545064156596, 218, 58, 'PPL', 'P'),
(188024, 'Alley Place', 34.9724998474121, 0.610385269990556, -106.249717712402, -1.85440740339596, 218, 38, 'PPL', 'P'),
(53160, 'Alley Spring', 37.1441688537598, 0.648288044414836, -91.4438934326172, -1.59599702124199, 218, 29, 'PPL', 'P'),
(92198, 'Alleyton', 29.7063903808594, 0.518474321028768, -96.4861068725586, -1.68400024735728, 218, 51, 'PPL', 'P'),
(7062, 'Allfriend (historical)', 36.1108283996582, 0.63025285119671, -93.4105606079102, -1.63032183874175, 218, 4, 'PPL', 'P'),
(112738, 'Allgood', 33.9119415283203, 0.591875035412987, -86.5094375610352, -1.50987451948852, 218, 2, 'PPL', 'P'),
(58447, 'Allgoods Mill (historical)', 33.225830078125, 0.579900131571446, -88.7013931274414, -1.54813136117972, 218, 30, 'PPL', 'P'),
(14970, 'Alliance', 30.6097202301025, 0.534240401129606, -85.1136093139648, -1.4855127207848, 218, 12, 'PPL', 'P'),
(39077, 'Alliance', 31.5316696166992, 0.55033145346246, -93.6500015258789, -1.6345008711243, 218, 22, 'PPL', 'P'),
(53161, 'Alliance', 37.5622215270996, 0.655584440011381, -89.9966735839844, -1.57073826988313, 218, 29, 'PPL', 'P'),
(62493, 'Alliance', 35.144718170166, 0.613391046754874, -76.8024978637695, -1.34045646147869, 218, 33, 'PPL', 'P'),
(70456, 'Alliance', 39.5186080932617, 0.689729827032695, -75.0922164916992, -1.31060642040054, 218, 37, 'PPL', 'P'),
(99372, 'Alliance', 37.1380615234375, 0.648181451392206, -76.7838897705078, -1.34013168898375, 218, 53, 'PPL', 'P'),
(107948, 'Alliance', 39.4563903808594, 0.688643923098216, -80.4811096191406, -1.40466034851248, 218, 58, 'PPL', 'P'),
(112743, 'Alliance', 33.547779083252, 0.585519201734432, -87.1263885498047, -1.52064234556598, 218, 2, 'PPL', 'P'),
(122129, 'Alliance', 40.0333290100098, 0.698713401758832, -85.6500015258789, -1.49487453096475, 218, 19, 'PPL', 'P'),
(154046, 'Alliance', 40.9152793884277, 0.714106339701436, -81.1061096191406, -1.41556865633745, 218, 41, 'PPL', 'P'),
(193341, 'Alliance', 40.8886108398438, 0.713640885721917, -124.086669921875, -2.16572094797213, 218, 6, 'PPL', 'P'),
(199139, 'Alliance', 42.1016693115234, 0.734812750071938, -102.871673583984, -1.7954494110774, 218, 35, 'PPL', 'P'),
(158638, 'Alliance Furnace', 40.1138916015625, 0.700119484235367, -79.7188873291016, -1.39135705991921, 218, 45, 'PPL', 'P'),
(154047, 'Alliance Junction', 40.9208297729492, 0.714203212186088, -81.0425033569336, -1.41445851763705, 218, 41, 'PPL', 'P'),
(179684, 'Alliance Redwood', 38.4338912963867, 0.67079794747554, -122.971939086914, -2.14626522462856, 218, 6, 'PPL', 'P'),
(44326, 'Allibone (historical)', 39.6161117553711, 0.691431586969256, -76.3147201538086, -1.33194313442203, 218, 25, 'PPL', 'P'),
(18808, 'Allie', 33.0991706848145, 0.577689508129599, -84.728889465332, -1.47879809272838, 218, 13, 'PPL', 'P'),
(107949, 'Allied', 39.3891716003418, 0.687470734059008, -80.2752838134766, -1.40106801051808, 218, 58, 'PPL', 'P'),
(58448, 'Alligator', 34.0894393920898, 0.594972957551022, -90.7194366455078, -1.58335286501851, 218, 30, 'PPL', 'P'),
(62494, 'Alligator', 35.9144401550293, 0.626825229715724, -76.1127777099609, -1.32841857387737, 218, 33, 'PPL', 'P'),
(79513, 'Alligator Lake', 34.1252784729004, 0.595598467512054, -79.804443359375, -1.39285029434242, 218, 48, 'PPL', 'P'),
(146769, 'Alligerville', 41.7958297729492, 0.729474843141038, -74.179443359375, -1.29467552391774, 218, 40, 'PPL', 'P'),
(18809, 'Alligood', 32.4361114501953, 0.566116941349741, -83.0041732788086, -1.44869611661111, 218, 13, 'PPL', 'P'),
(62499, 'Alligoods', 35.5597190856934, 0.620634179129617, -76.9463882446289, -1.34296782238663, 218, 33, 'PPL', 'P'),
(62497, 'Allin (historical)', 36.2316703796387, 0.632361941621999, -80.9574966430664, -1.41297487059377, 218, 33, 'PPL', 'P'),
(107950, 'Allingdale', 38.3572196960449, 0.669459775606802, -80.6116714477539, -1.40693908229921, 218, 58, 'PPL', 'P'),
(84628, 'Allingham', 36.0275001525879, 0.628798498925418, -84.3405609130859, -1.47202048091218, 218, 50, 'PPL', 'P'),
(177435, 'Allingtown', 41.2975006103516, 0.720777358495003, -72.960563659668, -1.27340205997213, 218, 8, 'PPL', 'P'),
(7063, 'Allis', 33.6277809143066, 0.58691549709396, -91.9049987792969, -1.6040448277401, 218, 4, 'PPL', 'P'),
(158639, 'Allis Hollow', 41.8433303833008, 0.73030388518838, -76.3061065673828, -1.3317927989785, 218, 45, 'PPL', 'P'),
(7064, 'Allison', 35.9366683959961, 0.627213185707521, -92.1172180175781, -1.60774875218418, 218, 4, 'PPL', 'P'),
(62498, 'Allison', 36.4088897705078, 0.635455003491044, -79.4644393920898, -1.38691610564345, 218, 33, 'PPL', 'P'),
(74972, 'Allison', 33.8958282470703, 0.591593805601875, -96.3713912963867, -1.68199808284975, 218, 42, 'PPL', 'P'),
(77776, 'Allison', 39.9888916015625, 0.697937822670374, -79.8649978637695, -1.39390716982102, 218, 45, 'PPL', 'P'),
(99366, 'Allison', 36.9305610656738, 0.644559885204834, -80.8363876342773, -1.41086111963657, 218, 53, 'PPL', 'P'),
(112741, 'Allison', 32.7866706848145, 0.572235354217116, -87.975830078125, -1.53546789703834, 218, 2, 'PPL', 'P'),
(114388, 'Allison', 42.7527809143066, 0.746176791338443, -92.7949981689453, -1.61957824743021, 218, 16, 'PPL', 'P'),
(139008, 'Allison', 40.5322189331055, 0.707420673521874, -94.7063903808594, -1.65293833482508, 218, 29, 'PPL', 'P'),
(186324, 'Allison', 37.0244407653809, 0.646198395065505, -107.487503051758, -1.87601083300063, 218, 7, 'PPL', 'P'),
(187575, 'Allison', 39.5750007629395, 0.690714064792561, -100.263893127441, -1.74993505594157, 218, 20, 'PPL', 'P'),
(188025, 'Allison', 35.524169921875, 0.620013729174656, -108.784439086914, -1.89864663700186, 218, 38, 'PPL', 'P'),
(191062, 'Allison', 35.6058311462402, 0.621438986411039, -100.100280761719, -1.74707948146273, 218, 51, 'PPL', 'P'),
(206669, 'Allison', 47.1405601501465, 0.822757985854489, -122.394439697266, -2.13618595885094, 218, 56, 'PPL', 'P'),
(201856, 'Allison Crossing', 45.1988906860352, 0.788869460720312, -101.916938781738, -1.77878614529483, 218, 49, 'PPL', 'P'),
(62500, 'Allison Ferry', 35.3886108398438, 0.617647776862229, -80.9577789306641, -1.41297979744178, 218, 33, 'PPL', 'P'),
(99367, 'Allison Gap', 36.8941688537598, 0.64392472128485, -81.7769393920898, -1.42727684459582, 218, 53, 'PPL', 'P'),
(77777, 'Allison Heights', 39.9861106872559, 0.697889286559507, -79.8788909912109, -1.39414965063827, 218, 45, 'PPL', 'P'),
(112742, 'Allison Mills', 33.389720916748, 0.582760566319273, -86.1149978637695, -1.50299024807066, 218, 2, 'PPL', 'P'),
(158646, 'Allison Park', 40.559440612793, 0.707895781460344, -79.9588928222656, -1.3955459459978, 218, 45, 'PPL', 'P'),
(84629, 'Allisona', 35.7547187805176, 0.624037565844684, -86.6919403076172, -1.51305979331031, 218, 50, 'PPL', 'P'),
(99368, 'Allisonia', 36.9391708374023, 0.644710154069342, -80.7363891601563, -1.40911581701619, 218, 53, 'PPL', 'P'),
(29087, 'Allisonville', 39.9049987792969, 0.696473616703049, -86.0783309936523, -1.50235029046072, 218, 19, 'PPL', 'P'),
(107951, 'Allister', 39.601390838623, 0.691174658503091, -80.6941680908203, -1.40837892034256, 218, 58, 'PPL', 'P'),
(29088, 'Allman', 39.6172218322754, 0.691450961466186, -86.4311065673828, -1.50850738574292, 218, 19, 'PPL', 'P'),
(191063, 'Allmon', 33.8813896179199, 0.591341803983726, -101.51277923584, -1.77173223051554, 218, 51, 'PPL', 'P'),
(99369, 'Allmondsville', 37.3933296203613, 0.652636720158826, -76.6511077880859, -1.33781420620317, 218, 53, 'PPL', 'P'),
(99370, 'Allnut', 38.3080596923828, 0.668601771682606, -77.1061096191406, -1.34575548625767, 218, 53, 'PPL', 'P'),
(44327, 'Allnut Farms Estates', 39.1972198486328, 0.684120543986716, -76.9691696166992, -1.34336543233738, 218, 25, 'PPL', 'P'),
(34536, 'Allock', 37.228889465332, 0.649766698031075, -83.0733337402344, -1.44990319437519, 218, 21, 'PPL', 'P'),
(18811, 'Allon', 32.6375007629395, 0.569631847935455, -83.98388671875, -1.46579534186412, 218, 13, 'PPL', 'P'),
(39097, 'Allon', 30.6411094665527, 0.534788246655349, -91.4938888549805, -1.59686960597315, 218, 22, 'PPL', 'P'),
(84630, 'Allons', 36.4419403076172, 0.636031844183155, -85.3447189331055, -1.48954634457183, 218, 50, 'PPL', 'P'),
(129490, 'Allouez', 47.2872200012207, 0.825317683136218, -88.4094390869141, -1.54303580190802, 218, 27, 'PPL', 'P'),
(172878, 'Allouez', 46.6886100769043, 0.814869969021783, -92.0244369506836, -1.60612941708336, 218, 57, 'PPL', 'P'),
(44328, 'Alloway', 39.1408309936523, 0.683136372805877, -76.478889465332, -1.33480842943885, 218, 25, 'PPL', 'P'),
(70457, 'Alloway', 39.5608291625977, 0.69046672370632, -75.3627777099609, -1.31532860448741, 218, 37, 'PPL', 'P'),
(84631, 'Alloway', 35.7999992370605, 0.624827858898165, -84.8755569458008, -1.48135792316817, 218, 50, 'PPL', 'P'),
(146770, 'Alloway', 43.023609161377, 0.750903635957224, -76.9888916015625, -1.34370964590828, 218, 40, 'PPL', 'P'),
(70458, 'Alloway Junction', 39.5813903808594, 0.690825584663208, -75.3633270263672, -1.31533819186733, 218, 37, 'PPL', 'P'),
(107952, 'Alloy', 38.1375007629395, 0.665624956795143, -81.2744369506836, -1.41850652249397, 218, 58, 'PPL', 'P'),
(7065, 'Allport', 34.5419387817383, 0.602870561763652, -91.7838897705078, -1.6019310767829, 218, 4, 'PPL', 'P'),
(158645, 'Allport', 40.9669418334961, 0.715008019467509, -78.2016677856445, -1.36487658341028, 218, 45, 'PPL', 'P'),
(84632, 'Allred', 36.3305587768555, 0.634087869745452, -85.1897201538086, -1.48684110553653, 218, 50, 'PPL', 'P'),
(112739, 'Allred', 31.7716693878174, 0.554520239672505, -86.0083312988281, -1.50112856531064, 218, 2, 'PPL', 'P'),
(191064, 'Allred', 32.9861106872559, 0.575716238919904, -102.887496948242, -1.79572558088244, 218, 51, 'PPL', 'P'),
(189860, 'Allred (historical)', 38.6783294677734, 0.675064198383793, -115.547782897949, -2.01668925494881, 218, 39, 'PPL', 'P'),
(62501, 'Allreds', 35.4530601501465, 0.618772629527651, -79.8058319091797, -1.39287452910834, 218, 33, 'PPL', 'P'),
(26355, 'Allright', 39.2972183227539, 0.685865846607099, -87.748893737793, -1.53150711070712, 218, 18, 'PPL', 'P'),
(112511, 'Allsboro', 34.6941719055176, 0.605527531004197, -88.1102828979492, -1.53781454143286, 218, 2, 'PPL', 'P'),
(79514, 'Allsbrook', 34.0200004577637, 0.593761019517954, -78.9466705322266, -1.37787933427454, 218, 48, 'PPL', 'P'),
(112745, 'Allsop', 33.9411087036133, 0.592384098655356, -85.7163925170898, -1.49603327235505, 218, 2, 'PPL', 'P'),
(124104, 'Allston', 42.3583297729492, 0.739292320183506, -71.1263885498047, -1.24138966524689, 218, 23, 'PPL', 'P'),
(39078, 'Alluvial City', 29.8411102294922, 0.520825625955199, -89.6913909912109, -1.56541008349021, 218, 22, 'PPL', 'P'),
(70460, 'Alluvium', 39.8349990844727, 0.695251891552975, -74.9422225952148, -1.30798853304899, 218, 37, 'PPL', 'P'),
(74974, 'Alluwe', 36.610279083252, 0.638969910076758, -95.4869384765625, -1.66656146906527, 218, 42, 'PPL', 'P'),
(44329, 'Allview Estates', 39.1941719055176, 0.684067347343942, -76.8597183227539, -1.34145514688747, 218, 25, 'PPL', 'P'),
(44330, 'Allwood', 39.1800003051758, 0.6838200062577, -76.648063659668, -1.33776107613942, 218, 25, 'PPL', 'P'),
(99371, 'Allwood', 37.6494407653809, 0.65710670289047, -79.2211074829102, -1.3826691626531, 218, 53, 'PPL', 'P'),
(177371, 'Allwood', 40.8424987792969, 0.712836078440495, -74.1591720581055, -1.29432172296692, 218, 37, 'PPL', 'P'),
(206671, 'Allyn', 47.3858299255371, 0.827038750990682, -122.826393127441, -2.14372496842279, 218, 56, 'PPL', 'P'),
(177436, 'Allyn Point', 41.4416694641113, 0.723293579671937, -72.0791702270508, -1.25801884256751, 218, 8, 'PPL', 'P'),
(44331, 'Allyson Gardens', 39.4297218322754, 0.688178469118697, -76.7886123657227, -1.34021411381949, 218, 25, 'PPL', 'P'),
(7066, 'Alma', 35.4777793884277, 0.619204061624244, -94.2216720581055, -1.64447840414828, 218, 4, 'PPL', 'P'),
(14971, 'Alma', 30.6108303070068, 0.534259775626536, -83.9063873291016, -1.46444272234647, 218, 12, 'PPL', 'P'),
(18812, 'Alma', 31.5391693115234, 0.550462347830037, -82.4625015258789, -1.43924216105743, 218, 13, 'PPL', 'P'),
(26356, 'Alma', 38.7216682434082, 0.675820602712402, -88.9091720581055, -1.55175778763608, 218, 18, 'PPL', 'P'),
(31632, 'Alma', 39.0166702270508, 0.68096935862688, -96.2888870239258, -1.68055811164835, 218, 20, 'PPL', 'P'),
(39079, 'Alma', 30.5961093902588, 0.534002847160371, -91.3894424438477, -1.59504667220699, 218, 22, 'PPL', 'P'),
(53162, 'Alma', 39.0952796936035, 0.682341352641461, -93.5449981689453, -1.63266821682016, 218, 29, 'PPL', 'P'),
(62510, 'Alma', 34.7236099243164, 0.6060413213575, -79.3127822875977, -1.38426918983602, 218, 33, 'PPL', 'P'),
(71648, 'Alma', 39.188060760498, 0.683960687742284, -82.978889465332, -1.44825483081848, 218, 41, 'PPL', 'P'),
(74976, 'Alma', 34.4194412231445, 0.600732576040536, -97.6119384765625, -1.70364971567015, 218, 42, 'PPL', 'P'),
(92201, 'Alma', 32.2852783203125, 0.563484406612198, -96.5458297729492, -1.68504260860793, 218, 51, 'PPL', 'P'),
(99376, 'Alma', 38.5911102294922, 0.673541935504703, -78.5577774047852, -1.37109186876231, 218, 53, 'PPL', 'P'),
(112746, 'Alma', 31.4638900756836, 0.549148477306247, -87.7538909912109, -1.53159432923282, 218, 2, 'PPL', 'P'),
(129492, 'Alma', 43.3788909912109, 0.757104473660338, -84.6597213745117, -1.47759088180625, 218, 27, 'PPL', 'P'),
(141152, 'Alma', 40.0974998474121, 0.699833394155265, -99.3616714477539, -1.73418831704815, 218, 35, 'PPL', 'P'),
(146771, 'Alma', 42.0125007629395, 0.733256465309923, -78.0580596923828, -1.36237014935035, 218, 40, 'PPL', 'P'),
(172880, 'Alma', 44.3199996948242, 0.773529919157565, -91.9147186279297, -1.60421447110154, 218, 57, 'PPL', 'P'),
(186325, 'Alma', 39.2838897705078, 0.685633219485881, -106.062217712402, -1.85113491104847, 218, 7, 'PPL', 'P'),
(188026, 'Alma', 33.3794403076172, 0.582581135840829, -108.902778625488, -1.90071205158528, 218, 38, 'PPL', 'P'),
(200314, 'Alma', 43.8911094665527, 0.766044372544597, -123.473609924316, -2.15502103250247, 218, 43, 'PPL', 'P'),
(179686, 'Alma (historical)', 37.1852798461914, 0.649005566591531, -121.986106872559, -2.12905920661583, 218, 6, 'PPL', 'P'),
(195859, 'Alma (historical)', 48.8211097717285, 0.85208910999424, -110.818061828613, -1.93414004958795, 218, 31, 'PPL', 'P'),
(172881, 'Alma Center', 44.4372215270996, 0.775575826085991, -90.9111099243164, -1.58669819482181, 218, 57, 'PPL', 'P'),
(133915, 'Alma City', 44.0224990844727, 0.768337553980237, -93.727783203125, -1.63585841748997, 218, 28, 'PPL', 'P'),
(92202, 'Alma Colonia', 26.3360004425049, 0.459649919528394, -98.1859970092773, -1.7136689271652, 218, 51, 'PPL', 'P'),
(193006, 'Alma Gardens', 33.4047203063965, 0.583022355054428, -111.853889465332, -1.95221865233184, 218, 5, 'PPL', 'P'),
(186326, 'Alma Junction', 39.2675018310547, 0.685347195984806, -106.044723510742, -1.85082957962949, 218, 7, 'PPL', 'P'),
(29089, 'Alma Lake', 39.6083297729492, 0.691295765753662, -87.0194396972656, -1.51877573595794, 218, 19, 'PPL', 'P'),
(44332, 'Alma Meadows', 39.5863914489746, 0.690912869767936, -76.8625030517578, -1.34150374957736, 218, 25, 'PPL', 'P'),
(193007, 'Alma Meadows Mobile Home Park', 33.4047203063965, 0.583022355054428, -111.856941223145, -1.95227191555365, 218, 5, 'PPL', 'P'),
(39080, 'Almadane', 30.9416694641113, 0.540034008212532, -93.5047225952148, -1.63196527545044, 218, 22, 'PPL', 'P'),
(158673, 'Almaden', 40.7627792358398, 0.711444709928983, -78.4000015258789, -1.36833816019517, 218, 45, 'PPL', 'P'),
(99373, 'Almagro', 36.5705604553223, 0.63827668924501, -79.3886108398438, -1.38559264773973, 218, 53, 'PPL', 'P'),
(193342, 'Almanor', 40.2174987792969, 0.701927770615531, -121.173057556152, -2.11486881906345, 218, 6, 'PPL', 'P'),
(193343, 'Almanor West', 40.2363891601563, 0.702257469958483, -121.203330993652, -2.11539719022372, 218, 6, 'PPL', 'P'),
(44333, 'Almar Estates', 38.811939239502, 0.677396128813293, -76.5999984741211, -1.33692218039605, 218, 25, 'PPL', 'P'),
(53163, 'Almartha', 36.7641716003418, 0.641655841194157, -92.5169372558594, -1.61472516897575, 218, 29, 'PPL', 'P'),
(84633, 'Almaville', 35.8652801513672, 0.625967225791528, -86.5811080932617, -1.51112540625253, 218, 50, 'PPL', 'P'),
(79515, 'Almeda', 32.829719543457, 0.572986698539655, -81.0494384765625, -1.41457955830859, 218, 48, 'PPL', 'P'),
(92203, 'Almeda', 29.603889465332, 0.516685342566508, -95.4169387817383, -1.6653397439152, 218, 51, 'PPL', 'P'),
(129494, 'Almeda Beach', 43.8175010681152, 0.764759663634743, -83.9230575561523, -1.46473367269556, 218, 27, 'PPL', 'P'),
(92204, 'Almeda Plaza', 29.6341705322266, 0.517213846884834, -95.418327331543, -1.66536397868112, 218, 51, 'PPL', 'P'),
(39081, 'Almedia', 29.9733295440674, 0.523133288329267, -90.3005599975586, -1.57604208835208, 218, 22, 'PPL', 'P'),
(158647, 'Almedia', 41.0144386291504, 0.715836994935824, -76.3813934326172, -1.33310680266034, 218, 45, 'PPL', 'P'),
(133917, 'Almelund', 45.4913902282715, 0.793974540792912, -92.7852783203125, -1.61940860406877, 218, 28, 'PPL', 'P'),
(31634, 'Almena', 39.892219543457, 0.696250576961754, -99.706672668457, -1.74020972427282, 218, 20, 'PPL', 'P'),
(129495, 'Almena', 42.264720916748, 0.73765853743377, -85.8252792358398, -1.49793370410893, 218, 27, 'PPL', 'P'),
(172886, 'Almena', 45.4169387817383, 0.792675117918035, -92.0327835083008, -1.60627509199499, 218, 57, 'PPL', 'P'),
(112744, 'Almeria', 32.0263900756836, 0.558965954348715, -85.8505630493164, -1.49837498990155, 218, 2, 'PPL', 'P'),
(141155, 'Almeria', 41.8258285522461, 0.729998420611347, -99.5216674804688, -1.73698077460915, 218, 35, 'PPL', 'P'),
(18819, 'Almira', 32.9447212219238, 0.57499385647422, -82.5261077880859, -1.44035229975783, 218, 13, 'PPL', 'P'),
(92205, 'Almira', 33.0999984741211, 0.577703955778512, -94.4452819824219, -1.64838113356774, 218, 51, 'PPL', 'P'),
(99374, 'Almira', 37.1419410705566, 0.648249162262921, -82.6222229003906, -1.44202982492848, 218, 53, 'PPL', 'P'),
(206672, 'Almira', 47.711109161377, 0.832715944644458, -118.939720153809, -2.07588972808462, 218, 56, 'PPL', 'P'),
(34540, 'Almo', 36.6947212219238, 0.640443703424008, -88.2783279418945, -1.54074748074137, 218, 21, 'PPL', 'P'),
(194510, 'Almo', 42.1002807617188, 0.734788515306019, -113.632781982422, -1.98326618379415, 218, 17, 'PPL', 'P'),
(34537, 'Almo Heights', 36.6927795410156, 0.640409814699136, -88.2958297729492, -1.5410529453184, 218, 21, 'PPL', 'P'),
(18813, 'Almon', 33.6191711425781, 0.586765228229452, -83.9222183227539, -1.46471902530957, 218, 13, 'PPL', 'P'),
(53164, 'Almon', 37.9580612182617, 0.662493145932237, -93.0944366455078, -1.62480443475338, 218, 29, 'PPL', 'P'),
(172889, 'Almon', 44.9063911437988, 0.783764380647712, -88.9916687011719, -1.55319762567943, 218, 57, 'PPL', 'P'),
(7068, 'Almond', 35.6958312988281, 0.623009785400995, -91.7983322143555, -1.60218314498008, 218, 4, 'PPL', 'P'),
(62502, 'Almond', 35.3697204589844, 0.617318077519277, -83.5652770996094, -1.4584892257296, 218, 33, 'PPL', 'P'),
(112748, 'Almond', 33.1463890075684, 0.578513623328924, -85.6216735839844, -1.49438011510838, 218, 2, 'PPL', 'P'),
(146773, 'Almond', 42.3222198486328, 0.738662083111539, -77.7386093139648, -1.35679468845022, 218, 40, 'PPL', 'P'),
(172891, 'Almond', 44.2588882446289, 0.772463323140988, -89.4069366455078, -1.56044541858609, 218, 57, 'PPL', 'P'),
(179687, 'Almond', 33.8588905334473, 0.590949120880994, -117.98388671875, -2.0592072875422, 218, 6, 'PPL', 'P'),
(99375, 'Almond (historical)', 38.3375015258789, 0.669115628614937, -78.7161102294922, -1.37385529786743, 218, 53, 'PPL', 'P'),
(44334, 'Almond Valley', 39.4544410705566, 0.68860990121529, -76.9263916015625, -1.34261881512578, 218, 25, 'PPL', 'P'),
(70461, 'Almonesson', 39.8188896179199, 0.694970728320889, -75.0988922119141, -1.31072293369823, 218, 37, 'PPL', 'P'),
(112747, 'Almont', 33.1144409179688, 0.577956023975688, -86.8791732788086, -1.51632762512589, 218, 2, 'PPL', 'P'),
(114391, 'Almont', 41.9752807617188, 0.732606853741026, -90.1988906860352, -1.57426762411776, 218, 16, 'PPL', 'P'),
(129499, 'Almont', 42.9205589294434, 0.749105070115039, -83.0449981689453, -1.44940864536076, 218, 27, 'PPL', 'P'),
(158648, 'Almont', 40.3641700744629, 0.704487667634342, -75.334716796875, -1.31483884916295, 218, 45, 'PPL', 'P'),
(186327, 'Almont', 38.6647186279297, 0.674826644414557, -106.845558166504, -1.86480678113661, 218, 7, 'PPL', 'P'),
(197924, 'Almont', 46.7252807617188, 0.815509993210756, -101.502220153809, -1.77154793976811, 218, 34, 'PPL', 'P'),
(7069, 'Almont (historical)', 35.1672210693359, 0.613783796436633, -90.1580581665039, -1.57355496221006, 218, 4, 'PPL', 'P'),
(179688, 'Almonte', 37.8899993896484, 0.661305242928007, -122.523887634277, -2.13844525156171, 218, 6, 'PPL', 'P'),
(118599, 'Almora', 42.0608291625977, 0.734099955006179, -88.3361129760742, -1.54175601984618, 218, 18, 'PPL', 'P'),
(133919, 'Almora', 46.2463912963867, 0.807151795287597, -95.3652801513672, -1.66443813072815, 218, 28, 'PPL', 'P'),
(118600, 'Almora Heights', 42.042781829834, 0.733784969628249, -88.3438873291016, -1.54189170790372, 218, 18, 'PPL', 'P'),
(114392, 'Almoral', 42.5355606079102, 0.742385581789633, -91.2897186279297, -1.59330616327657, 218, 16, 'PPL', 'P'),
(114393, 'Almoral Siding (historical)', 42.5163917541504, 0.742051022177692, -91.2724990844727, -1.59300562554756, 218, 16, 'PPL', 'P'),
(206673, 'Almota', 46.7030601501465, 0.815122170377013, -117.468330383301, -2.05020913200909, 218, 56, 'PPL', 'P'),
(124105, 'Alms House', 41.6674995422363, 0.727235058085254, -70.7633285522461, -1.23505307290721, 218, 23, 'PPL', 'P'),
(58450, 'Almy', 33.3491706848145, 0.582052831259584, -90.8791732788086, -1.58614079520566, 218, 30, 'PPL', 'P'),
(209264, 'Almy', 41.3316688537598, 0.721373706842099, -111.003890991211, -1.9373833803215, 218, 59, 'PPL', 'P'),
(7070, 'Almyra', 34.4061088562012, 0.600499882340291, -91.4094390869141, -1.59539567946785, 218, 4, 'PPL', 'P'),
(177437, 'Almyville', 41.7180595397949, 0.728117496512452, -71.8666687011719, -1.25430999127541, 218, 8, 'PPL', 'P'),
(126751, 'Alna', 44.1061096191406, 0.769796833099546, -69.6041717529297, -1.21482197021226, 218, 26, 'PPL', 'P'),
(126752, 'Alna Center', 44.0808296203613, 0.769355613885947, -69.6186065673828, -1.21507390525138, 218, 26, 'PPL', 'P'),
(84634, 'Alnwick', 35.7480583190918, 0.623921318863102, -84.0377807617188, -1.46673597036114, 218, 50, 'PPL', 'P'),
(158649, 'Alnwick', 40.1288909912109, 0.700381272970522, -75.0733337402344, -1.31027685421564, 218, 45, 'PPL', 'P'),
(92206, 'Aloe', 28.7663898468018, 0.502068216738958, -97.0758285522461, -1.69429283233821, 218, 51, 'PPL', 'P'),
(195860, 'Aloe', 48.6572189331055, 0.849228675246413, -112.004997253418, -1.95485598075935, 218, 31, 'PPL', 'P'),
(39082, 'Aloha', 31.5830593109131, 0.551228372828085, -92.772216796875, -1.61918063747946, 218, 22, 'PPL', 'P'),
(129501, 'Aloha', 45.5263900756836, 0.794585403367949, -84.466667175293, -1.47422145039508, 218, 27, 'PPL', 'P'),
(200315, 'Aloha', 45.4944381713867, 0.794027737435687, -122.865829467773, -2.14441326240652, 218, 43, 'PPL', 'P'),
(206674, 'Aloha', 47.2011108398438, 0.823814794754059, -124.16667175293, -2.16711724333166, 218, 56, 'PPL', 'P'),
(211667, 'Aloha Kona', 19.6408290863037, 0.342797135377469, -155.985565185547, -2.72246169807203, 218, 15, 'PPL', 'P'),
(92207, 'Aloha Village Colonia', 26.2929992675781, 0.458899407443696, -98.3190002441406, -1.71599027152936, 218, 51, 'PPL', 'P'),
(14972, 'Aloma', 28.6005592346191, 0.499173926555773, -81.3066711425781, -1.41906911527425, 218, 12, 'PPL', 'P'),
(179690, 'Alondra Park', 33.8894386291504, 0.591482285731228, -118.330001831055, -2.06524813584282, 218, 6, 'PPL', 'P'),
(99377, 'Alonzaville', 38.9286117553711, 0.679432448361795, -78.5466690063477, -1.37089799063495, 218, 53, 'PPL', 'P'),
(34538, 'Alonzo', 36.6930618286133, 0.640414741547153, -86.3447189331055, -1.50699963709178, 218, 21, 'PPL', 'P'),
(58451, 'Alonzo', 32.0502815246582, 0.559382938796394, -90.2152786254883, -1.57455364761883, 218, 30, 'PPL', 'P'),
(118601, 'Alonzo', 40.5666694641113, 0.708021948716986, -87.7311096191406, -1.53119671928207, 218, 18, 'PPL', 'P'),
(39083, 'Alonzo (historical)', 31.8638896942139, 0.556129787656321, -92.7050018310547, -1.61800751501928, 218, 22, 'PPL', 'P'),
(146775, 'Aloquin', 42.8608283996582, 0.748062575706328, -77.1452789306641, -1.3464391197095, 218, 40, 'PPL', 'P'),
(26358, 'Alorton', 38.5897216796875, 0.673517700738783, -90.120002746582, -1.57289076983419, 218, 18, 'PPL', 'P'),
(141156, 'Aloys', 41.8294410705566, 0.730061470950155, -96.9030609130859, -1.69127746819397, 218, 35, 'PPL', 'P'),
(179691, 'Alpaugh', 35.8877792358398, 0.62635990889426, -119.486389160156, -2.08543090216399, 218, 6, 'PPL', 'P'),
(7071, 'Alpena', 36.2947196960449, 0.633462359784419, -93.2919387817383, -1.62825149731032, 218, 4, 'PPL', 'P'),
(107953, 'Alpena', 38.9097213745117, 0.679102749018843, -79.6513900756836, -1.39017901061101, 218, 58, 'PPL', 'P'),
(129503, 'Alpena', 45.0616683959961, 0.786474479952004, -83.4327774047852, -1.45617666979703, 218, 27, 'PPL', 'P'),
(169713, 'Alpena', 44.1813888549805, 0.771110703623337, -98.3652801513672, -1.71679800828798, 218, 49, 'PPL', 'P'),
(129505, 'Alpena Junction', 45.0586090087891, 0.786421083572148, -83.4561080932617, -1.4565838671277, 218, 27, 'PPL', 'P'),
(74977, 'Alpers', 34.4925003051758, 0.602007697570466, -97.3869400024414, -1.69972275148478, 218, 42, 'PPL', 'P'),
(7072, 'Alpha', 35.1155586242676, 0.61288211667056, -93.2805633544922, -1.62805295865106, 218, 4, 'PPL', 'P'),
(34539, 'Alpha', 36.7622184753418, 0.641621752732204, -85.0102767944336, -1.4837092280946, 218, 21, 'PPL', 'P'),
(44335, 'Alpha', 39.3211097717285, 0.686282831054779, -76.9280624389648, -1.34264797673972, 218, 25, 'PPL', 'P'),
(53165, 'Alpha', 39.985279083252, 0.697874772331566, -93.4208297729492, -1.63050106948311, 218, 29, 'PPL', 'P'),
(71649, 'Alpha', 39.711669921875, 0.693099391601918, -84.0233306884766, -1.46648376900591, 218, 41, 'PPL', 'P'),
(74978, 'Alpha', 35.8702812194824, 0.626054510896255, -98.0999984741211, -1.71216796957483, 218, 42, 'PPL', 'P'),
(84635, 'Alpha', 36.1769409179688, 0.631406732318014, -83.3827819824219, -1.45530408506587, 218, 50, 'PPL', 'P'),
(99382, 'Alpha', 37.5827789306641, 0.655943234389242, -78.4175033569336, -1.3686436247722, 218, 53, 'PPL', 'P'),
(114394, 'Alpha', 42.9966697692871, 0.750433454866771, -92.0475006103516, -1.60653195388212, 218, 16, 'PPL', 'P'),
(118602, 'Alpha', 41.1916694641113, 0.718930256541951, -90.379997253418, -1.57742853001558, 218, 18, 'PPL', 'P'),
(129507, 'Alpha', 46.0438919067383, 0.803617514204953, -88.3769378662109, -1.54246854859583, 218, 27, 'PPL', 'P'),
(133920, 'Alpha', 43.6388893127441, 0.761642300420751, -94.8705596923828, -1.6558036298419, 218, 28, 'PPL', 'P'),
(144744, 'Alpha', 40.6669387817383, 0.709771978448305, -75.1577835083008, -1.31175078072094, 218, 37, 'PPL', 'P'),
(172894, 'Alpha', 45.7724990844727, 0.798880815890138, -92.5794372558594, -1.61581599975825, 218, 57, 'PPL', 'P'),
(194511, 'Alpha', 44.3911094665527, 0.774771018804569, -116.006942749023, -2.02470310614302, 218, 17, 'PPL', 'P'),
(197926, 'Alpha', 46.6583290100098, 0.814341464703457, -103.819442749023, -1.81199110355621, 218, 34, 'PPL', 'P'),
(199805, 'Alpha', 40.0102806091309, 0.698311131276176, -116.192222595215, -2.02793684949665, 218, 39, 'PPL', 'P'),
(200316, 'Alpha', 44.1644401550293, 0.770814893005256, -123.699440002441, -2.15896251091579, 218, 43, 'PPL', 'P'),
(206675, 'Alpha', 46.6116714477539, 0.813527136621138, -122.60417175293, -2.13984647376925, 218, 56, 'PPL', 'P'),
(179692, 'Alpha (historical)', 39.3305587768555, 0.686447747305282, -120.781387329102, -2.10803288401938, 218, 6, 'PPL', 'P'),
(206676, 'Alpha (historical)', 47.6758308410645, 0.832100221800432, -117.16667175293, -2.04494419569206, 218, 56, 'PPL', 'P'),
(84636, 'Alpha Heights', 36.1847190856934, 0.631542486954581, -83.3880615234375, -1.45539623043958, 218, 50, 'PPL', 'P'),
(39084, 'Alpha Mobile Home Park', 32.3894386291504, 0.565302346951313, -93.7655563354492, -1.63651768301782, 218, 22, 'PPL', 'P'),
(58452, 'Alphaba', 34.7738914489746, 0.606918899515709, -89.8736114501953, -1.56859043046398, 218, 30, 'PPL', 'P'),
(144739, 'Alphano', 40.9022216796875, 0.713878439691152, -74.8619384765625, -1.30658731084144, 218, 37, 'PPL', 'P'),
(18815, 'Alpharetta', 34.0752792358398, 0.594725816201863, -84.2941665649414, -1.47121074678275, 218, 13, 'PPL', 'P'),
(18816, 'Alpharetta Woods', 34.1572189331055, 0.596155933707235, -84.2747192382813, -1.47087132690182, 218, 13, 'PPL', 'P'),
(18817, 'Alpharette', 34.0750007629395, 0.594720955932873, -84.2125015258789, -1.46978542296734, 218, 13, 'PPL', 'P'),
(39085, 'Alphenia Landing', 31.8194408416748, 0.555354008830781, -91.570556640625, -1.59820771126286, 218, 22, 'PPL', 'P'),
(107954, 'Alpheus', 37.3680610656738, 0.652195700682309, -81.5611114501953, -1.42350993639196, 218, 58, 'PPL', 'P'),
(179693, 'Alphine Village', 38.7730598449707, 0.676717555367541, -119.816940307617, -2.09120010803343, 218, 6, 'PPL', 'P'),
(34541, 'Alphoretta', 37.563060760498, 0.655599087397376, -82.7644424438477, -1.44451202422248, 218, 21, 'PPL', 'P'),
(146776, 'Alpina', 44.1691703796387, 0.770897450999049, -75.4269409179688, -1.31644846372579, 218, 40, 'PPL', 'P'),
(7074, 'Alpine', 34.7238883972168, 0.60604618162649, -92.4602813720703, -1.61373633726301, 218, 4, 'PPL', 'P'),
(14973, 'Alpine', 27.6319408416748, 0.482268346403519, -81.4763870239258, -1.42203121619669, 218, 12, 'PPL', 'P'),
(18818, 'Alpine', 34.4558296203613, 0.601367673381493, -85.4916687011719, -1.49211110185963, 218, 13, 'PPL', 'P'),
(29090, 'Alpine', 39.5538902282715, 0.690345616455749, -85.1758270263672, -1.48659862471928, 218, 19, 'PPL', 'P'),
(34542, 'Alpine', 36.9249992370605, 0.644462812983101, -84.5208282470703, -1.475166739424, 218, 21, 'PPL', 'P'),
(44336, 'Alpine', 39.4130592346191, 0.68788765192766, -77.3233337402344, -1.34954676238551, 218, 25, 'PPL', 'P'),
(58453, 'Alpine', 34.4952812194824, 0.602056233681333, -88.7977828979492, -1.54981368004033, 218, 30, 'PPL', 'P'),
(84637, 'Alpine', 36.394718170166, 0.635207662404803, -85.2169418334961, -1.487316213475, 218, 50, 'PPL', 'P'),
(99380, 'Alpine', 38.6705589294434, 0.67492857690528, -78.6350021362305, -1.37243969459, 218, 53, 'PPL', 'P'),
(112751, 'Alpine', 34.5052795410156, 0.60223073731176, -85.6102828979492, -1.49418131013301, 218, 2, 'PPL', 'P'),
(118603, 'Alpine', 41.5863914489746, 0.725819454807822, -87.8813934326172, -1.53381966663969, 218, 18, 'PPL', 'P'),
(129508, 'Alpine', 43.0727806091309, 0.751761839618502, -85.6849975585938, -1.49548532696076, 218, 27, 'PPL', 'P'),
(144740, 'Alpine', 40.9558296203613, 0.714814074761124, -73.9316711425781, -1.29035108293967, 218, 37, 'PPL', 'P'),
(146777, 'Alpine', 42.313060760498, 0.738502226867107, -76.7244415283203, -1.33909412142306, 218, 40, 'PPL', 'P'),
(158651, 'Alpine', 40.0786094665527, 0.699503694812313, -76.8730621337891, -1.3416880403248, 218, 45, 'PPL', 'P'),
(179696, 'Alpine', 32.8349990844727, 0.573078843913372, -116.765556335449, -2.03794341097651, 218, 6, 'PPL', 'P'),
(186328, 'Alpine', 37.6891708374023, 0.657800123459299, -106.588333129883, -1.86031735732901, 218, 7, 'PPL', 'P'),
(191065, 'Alpine', 30.3583297729492, 0.529852809944186, -103.66056060791, -1.80921808707117, 218, 51, 'PPL', 'P'),
(193008, 'Alpine', 33.8480606079102, 0.590760103022626, -109.142501831055, -1.90489601081584, 218, 5, 'PPL', 'P'),
(194512, 'Alpine', 44.5936088562012, 0.778305299887213, -116.49388885498, -2.03320191897174, 218, 17, 'PPL', 'P'),
(195861, 'Alpine', 45.2013893127441, 0.788913069983162, -109.640556335449, -1.91358870177192, 218, 31, 'PPL', 'P'),
(200317, 'Alpine', 44.3302803039551, 0.773709349636009, -123.359169006348, -2.15302366168491, 218, 43, 'PPL', 'P'),
(202867, 'Alpine', 40.4533309936523, 0.706043819238303, -111.777221679688, -1.95088054704213, 218, 52, 'PPL', 'P'),
(206677, 'Alpine', 45.788330078125, 0.799157118853234, -122.423057556152, -2.13668543471338, 218, 56, 'PPL', 'P'),
(209265, 'Alpine', 43.1752815246582, 0.753550818080763, -111.033889770508, -1.93790695779181, 218, 59, 'PPL', 'P'),
(212273, 'Alpine', 70.3280563354492, 1.22745613958165, -150.977493286133, -2.63505435425065, 218, 1, 'PPL', 'P'),
(179697, 'Alpine (historical)', 34.4375, 0.601047761155547, -118.336387634277, -2.06535958913444, 218, 6, 'PPL', 'P'),
(186329, 'Alpine (historical)', 38.711109161377, 0.675636311964969, -106.276390075684, -1.8548729239545, 218, 7, 'PPL', 'P'),
(189862, 'Alpine (historical)', 38.0269393920898, 0.663695296848299, -117.563606262207, -2.05187200979374, 218, 39, 'PPL', 'P'),
(84638, 'Alpine Acres', 36.1022186279297, 0.630102582332203, -84.9000015258789, -1.4817845615748, 218, 50, 'PPL', 'P'),
(112754, 'Alpine Bay', 33.4480590820313, 0.583778759383037, -86.295280456543, -1.50613677289859, 218, 2, 'PPL', 'P'),
(188027, 'Alpine Cellars Village', 33.374439239502, 0.582493850736101, -105.691390991211, -1.8446627638093, 218, 38, 'PPL', 'P'),
(14974, 'Alpine Heights', 30.7447204589844, 0.53659659961454, -86.2099990844727, -1.50464833216535, 218, 12, 'PPL', 'P'),
(158652, 'Alpine Heights', 40.2533302307129, 0.702553147418509, -76.6766662597656, -1.33826028568576, 218, 45, 'PPL', 'P'),
(179717, 'Alpine Heights', 32.8180618286133, 0.572783233032373, -116.779998779297, -2.03819547917369, 218, 6, 'PPL', 'P'),
(99381, 'Alpine Hills', 37.3455581665039, 0.65180295100055, -79.9680633544922, -1.39570600197931, 218, 53, 'PPL', 'P'),
(146778, 'Alpine Junction', 42.2936096191406, 0.738162740407149, -76.710563659668, -1.33885190692192, 218, 40, 'PPL', 'P'),
(209266, 'Alpine Junction', 43.1725006103516, 0.753502281969896, -111.017776489258, -1.9376257279807, 218, 59, 'PPL', 'P'),
(107955, 'Alpine Lake', 39.4747200012207, 0.688963835324161, -79.5008316040039, -1.38755126956343, 218, 58, 'PPL', 'P'),
(179699, 'Alpine Meadows', 39.1786117553711, 0.683795771491781, -120.226669311523, -2.09835122819251, 218, 6, 'PPL', 'P'),
(195862, 'Alpine Mobile Manor', 48.2000007629395, 0.841248712777072, -114.300003051758, -1.99491138829274, 218, 31, 'PPL', 'P'),
(202844, 'Alpine Ranchettes', 41.209171295166, 0.719235721118983, -112.047218322754, -1.95559287743297, 218, 52, 'PPL', 'P'),
(202845, 'Alpine Ranchettes Two', 41.2058296203613, 0.71917739789111, -112.047218322754, -1.95559287743297, 218, 52, 'PPL', 'P'),
(112755, 'Alpine Shores', 34.2166709899902, 0.597193567846957, -85.5263900756836, -1.49271710416568, 218, 2, 'PPL', 'P'),
(71650, 'Alpine Terrace', 39.0905609130859, 0.682258994384751, -84.2919387817383, -1.47117186463083, 218, 41, 'PPL', 'P'),
(195863, 'Alpine Trailer Court', 45.6805610656738, 0.797276194754338, -111.022216796875, -1.93770322596842, 218, 31, 'PPL', 'P'),
(44337, 'Alpine View', 39.5338897705078, 0.689996542615867, -77.5708312988281, -1.35386640967362, 218, 25, 'PPL', 'P'),
(171685, 'Alpine Village', 44.0686111450195, 0.769142361261659, -72.834716796875, -1.27120561786309, 218, 55, 'PPL', 'P'),
(179700, 'Alpine Village', 33.6061096191406, 0.586537261640142, -116.468887329102, -2.03276556002713, 218, 6, 'PPL', 'P'),
(146779, 'Alplaus', 42.855281829834, 0.747965769800703, -73.8994369506836, -1.28978849015939, 218, 40, 'PPL', 'P'),
(107956, 'Alpoca', 37.5436096191406, 0.655259600937418, -81.3891677856445, -1.4205089533176, 218, 58, 'PPL', 'P'),
(206678, 'Alpowa', 46.4194412231445, 0.810172086279856, -117.195556640625, -2.04544833208641, 218, 56, 'PPL', 'P'),
(18820, 'Alps', 33.1480598449707, 0.57854278494286, -84.6033325195313, -1.47660671062541, 218, 13, 'PPL', 'P'),
(158653, 'Alpsville', 40.3055610656738, 0.703464747459643, -79.7958297729492, -1.39269995889888, 218, 45, 'PPL', 'P'),
(29091, 'Alquina', 39.6127815246582, 0.691373463478465, -85.0547180175781, -1.48448487376208, 218, 19, 'PPL', 'P'),
(179701, 'Alray', 34.3283309936523, 0.59914240255365, -117.481941223145, -2.05044668597833, 218, 6, 'PPL', 'P'),
(7076, 'Alread', 35.6327781677246, 0.621909300659547, -92.6797180175781, -1.61756622922665, 218, 4, 'PPL', 'P'),
(194513, 'Alridge', 43.2113914489746, 0.75418105515273, -112.004173278809, -1.95484159968946, 218, 17, 'PPL', 'P'),
(92208, 'Alsa', 32.8183288574219, 0.57278789356428, -96.0336074829102, -1.67610264314465, 218, 51, 'PPL', 'P'),
(179702, 'Alsace', 33.9786109924316, 0.59303863707227, -118.41471862793, -2.06672672288004, 218, 6, 'PPL', 'P'),
(158654, 'Alsace Manor', 40.3997192382813, 0.705108117589303, -75.8608322143555, -1.32402129544348, 218, 45, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(39086, 'Alsatia', 32.6127815246582, 0.569200415838862, -91.1822204589844, -1.59142996628861, 218, 22, 'PPL', 'P'),
(92209, 'Alsdorf', 32.4049987792969, 0.565573922803474, -96.5355606079102, -1.68486337786657, 218, 51, 'PPL', 'P'),
(200318, 'Alsea', 44.3816719055176, 0.774606302291147, -123.595283508301, -2.1571446371557, 218, 43, 'PPL', 'P'),
(200319, 'Alsea Rivera', 44.4055595397949, 0.775023220159799, -123.897216796875, -2.16241436716269, 218, 43, 'PPL', 'P'),
(39087, 'Alsen', 30.5711097717285, 0.533566521505275, -91.2041702270508, -1.59181306201142, 218, 22, 'PPL', 'P'),
(139588, 'Alsen', 48.6305618286133, 0.848763421003976, -98.7044372558594, -1.7227174164429, 218, 34, 'PPL', 'P'),
(146780, 'Alsen', 42.1580581665039, 0.735796921252777, -73.9197235107422, -1.29014255742631, 218, 40, 'PPL', 'P'),
(169717, 'Alsen', 42.961109161377, 0.749812805174728, -96.8052825927734, -1.68957091456745, 218, 49, 'PPL', 'P'),
(39088, 'Alsen Heights', 30.5755596160889, 0.533644185940564, -91.2058334350586, -1.5918420904673, 218, 22, 'PPL', 'P'),
(26359, 'Alsey', 39.5605583190918, 0.690461996595385, -90.4338912963867, -1.57836915851259, 218, 18, 'PPL', 'P'),
(118604, 'Alsip', 41.6688919067383, 0.727259359430201, -87.7386093139648, -1.53132761364965, 218, 18, 'PPL', 'P'),
(92210, 'Alsonia Colonia', 26.4379997253418, 0.461430142848571, -98.1460037231445, -1.71297091264349, 218, 51, 'PPL', 'P'),
(99387, 'Alsop', 38.2069396972656, 0.666836894828211, -77.6497192382813, -1.35524326395719, 218, 53, 'PPL', 'P'),
(177438, 'Alsop Corner', 41.8052787780762, 0.729639759391541, -72.8180618286133, -1.2709149338301, 218, 8, 'PPL', 'P'),
(62504, 'Alspaugh', 36.1452789306641, 0.630854126391823, -80.2558288574219, -1.40072845747909, 218, 33, 'PPL', 'P'),
(143456, 'Alstead', 43.1488914489746, 0.753090224370234, -72.3611068725586, -1.26293956531364, 218, 36, 'PPL', 'P'),
(143457, 'Alstead Center', 43.1186103820801, 0.752561720051908, -72.3263931274414, -1.26233369616565, 218, 36, 'PPL', 'P'),
(18821, 'Alston', 32.0805587768555, 0.559911376535693, -82.477783203125, -1.43950887664061, 218, 13, 'PPL', 'P'),
(74979, 'Alston', 36.4361114501953, 0.635930111429514, -99.2900009155273, -1.73293743028414, 218, 42, 'PPL', 'P'),
(79516, 'Alston', 34.2433280944824, 0.597658822089394, -81.3169403076172, -1.41924834601561, 218, 48, 'PPL', 'P'),
(129510, 'Alston', 46.7683296203613, 0.816261337533295, -88.753059387207, -1.54903310752482, 218, 27, 'PPL', 'P'),
(200320, 'Alston', 46.0994415283203, 0.804587037999796, -123.045829772949, -2.14755486038643, 218, 43, 'PPL', 'P'),
(206679, 'Alstown', 47.5611114501953, 0.830097990713883, -119.99388885498, -2.09428844279154, 218, 56, 'PPL', 'P'),
(74980, 'Alsuma', 36.0950012207031, 0.629976614812642, -95.8633270263672, -1.67313068852617, 218, 42, 'PPL', 'P'),
(53167, 'Alsup', 37.3980598449707, 0.652719278152619, -93.3052825927734, -1.62848439074765, 218, 29, 'PPL', 'P'),
(113361, 'Alsville', 44.586669921875, 0.778184192636642, -97.1277770996094, -1.69519950553133, 218, 49, 'PPL', 'P'),
(29092, 'Alta', 39.7722206115723, 0.694156200501489, -87.3866729736328, -1.52518516575344, 218, 19, 'PPL', 'P'),
(107959, 'Alta', 37.8694381713867, 0.660946381971119, -80.5430603027344, -1.40574159191506, 218, 58, 'PPL', 'P'),
(112758, 'Alta', 33.6708297729492, 0.587666841416499, -87.5316696166992, -1.52771583457928, 218, 2, 'PPL', 'P'),
(114395, 'Alta', 42.6736106872559, 0.744795010206855, -95.290283203125, -1.66312918705238, 218, 16, 'PPL', 'P'),
(118605, 'Alta', 40.8108291625977, 0.712283339356249, -89.6341705322266, -1.56441139808143, 218, 18, 'PPL', 'P'),
(154049, 'Alta', 40.7324981689453, 0.710916205610657, -82.5697174072266, -1.44111343119738, 218, 41, 'PPL', 'P'),
(179703, 'Alta', 39.2066688537598, 0.684285460237219, -120.810279846191, -2.10853715357179, 218, 6, 'PPL', 'P'),
(186330, 'Alta', 37.8863906860352, 0.661242259168227, -107.85221862793, -1.88237632063813, 218, 7, 'PPL', 'P'),
(195864, 'Alta', 45.6188888549805, 0.796199811620755, -114.298889160156, -1.99489194721678, 218, 31, 'PPL', 'P'),
(202846, 'Alta', 40.5888900756836, 0.708409771550729, -111.637222290039, -1.94843709674199, 218, 52, 'PPL', 'P'),
(209267, 'Alta', 43.7538909912109, 0.763649458355316, -111.036109924316, -1.93794570678567, 218, 59, 'PPL', 'P'),
(179704, 'Alta (historical)', 32.7797203063965, 0.572114047229463, -116.988059997559, -2.04182683247807, 218, 6, 'PPL', 'P'),
(179705, 'Alta Hill', 39.2299995422363, 0.684692657567892, -121.075561523438, -2.11316719228495, 218, 6, 'PPL', 'P'),
(202852, 'Alta Hills', 40.5930595397949, 0.708482542427516, -111.801109313965, -1.95129746491079, 218, 52, 'PPL', 'P'),
(179706, 'Alta Loma', 34.1222190856934, 0.595545071132198, -117.597221374512, -2.05245870418188, 218, 6, 'PPL', 'P'),
(158656, 'Alta Manor', 40.5316696166992, 0.707411086141949, -78.4047164916992, -1.36842045187285, 218, 45, 'PPL', 'P'),
(179707, 'Alta Mesa', 37.3988914489746, 0.65273379238056, -122.133613586426, -2.13163368444161, 218, 6, 'PPL', 'P'),
(31636, 'Alta Mills', 38.1177787780762, 0.66528074322425, -97.591667175293, -1.70329591471934, 218, 20, 'PPL', 'P'),
(193010, 'Alta Mira', 33.3255615234375, 0.581640773659922, -111.906936645508, -1.95314450028481, 218, 5, 'PPL', 'P'),
(179709, 'Alta Sierra', 39.1416702270508, 0.683151020191873, -121.052780151367, -2.1127695823342, 218, 6, 'PPL', 'P'),
(179710, 'Alta Sierra Estates', 39.1141700744629, 0.682671051984413, -121.054168701172, -2.11279381710012, 218, 6, 'PPL', 'P'),
(179711, 'Alta Sierra Ranches', 39.1044387817383, 0.682501208885893, -121.023612976074, -2.11226051909183, 218, 6, 'PPL', 'P'),
(99383, 'Alta View', 37.2783317565918, 0.650629628803288, -80.0780563354492, -1.39762574165109, 218, 53, 'PPL', 'P'),
(18822, 'Alta Vista', 32.4813919067383, 0.566907234403222, -84.9250030517578, -1.48222092051941, 218, 13, 'PPL', 'P'),
(31637, 'Alta Vista', 38.8638916015625, 0.678302868585438, -96.4888916015625, -1.68404885004717, 218, 20, 'PPL', 'P'),
(44338, 'Alta Vista', 39.0088882446289, 0.680833537411286, -77.10888671875, -1.34580395578951, 218, 25, 'PPL', 'P'),
(53168, 'Alta Vista', 39.9091682434082, 0.696546387579835, -94.2050018310547, -1.64418745379919, 218, 29, 'PPL', 'P'),
(84641, 'Alta Vista', 35.4638900756836, 0.61896164738602, -84.6161117553711, -1.4768297503667, 218, 50, 'PPL', 'P'),
(112757, 'Alta Vista', 32.6547203063965, 0.56993238566447, -85.3938903808594, -1.49040454823311, 218, 2, 'PPL', 'P'),
(114396, 'Alta Vista', 43.1986083984375, 0.753957948832409, -92.4169387817383, -1.61297986635537, 218, 16, 'PPL', 'P'),
(179712, 'Alta Vista', 37.4127807617188, 0.652976206618784, -118.54167175293, -2.06894247290698, 218, 6, 'PPL', 'P'),
(186331, 'Alta Vista', 39.0269393920898, 0.681148589368242, -104.111938476563, -1.81709611704978, 218, 7, 'PPL', 'P'),
(188028, 'Alta Vista', 35.5349998474121, 0.620202747033024, -104.743057250977, -1.82811121763446, 218, 38, 'PPL', 'P'),
(206680, 'Alta Vista', 46.4997215270996, 0.811573241908374, -122.371109008789, -2.13577876152026, 218, 56, 'PPL', 'P'),
(179713, 'Alta Vista (historical)', 36.0550003051758, 0.629278467132878, -118.96305847168, -2.07629705857334, 218, 6, 'PPL', 'P'),
(92212, 'Alta Vista Colonia', 26.3020000457764, 0.459056500658497, -98.3519973754883, -1.71656618011509, 218, 51, 'PPL', 'P'),
(179714, 'Alta Vista Park', 39.2275009155273, 0.684649048305042, -121.065559387207, -2.11299262207549, 218, 6, 'PPL', 'P'),
(202856, 'Alta Vista Subdivision Number 1', 40.5666694641113, 0.708021948716986, -111.816673278809, -1.95156910734197, 218, 52, 'PPL', 'P'),
(44339, 'Alta Vista Terrace', 39.0052795410156, 0.680770553651505, -77.1208267211914, -1.34601234814481, 218, 25, 'PPL', 'P'),
(179715, 'Altacanyada', 34.2222213745117, 0.597290440331609, -118.211112976074, -2.06317313387949, 218, 6, 'PPL', 'P'),
(179716, 'Altadena', 34.1897201538086, 0.596723187019422, -118.130279541016, -2.06176232429202, 218, 6, 'PPL', 'P'),
(112756, 'Altadena Ridge Estates', 33.4333305358887, 0.583521697758818, -86.7466735839844, -1.51401506919332, 218, 2, 'PPL', 'P'),
(112762, 'Altadena Woods', 33.4052810668945, 0.583032142171434, -86.7474975585938, -1.5140294502632, 218, 2, 'PPL', 'P'),
(92213, 'Altair', 29.5711097717285, 0.516113228985331, -96.4538879394531, -1.68343792089311, 218, 51, 'PPL', 'P'),
(18824, 'Altamaha', 31.961389541626, 0.557831481013854, -82.2074966430664, -1.43479148624369, 218, 13, 'PPL', 'P'),
(18825, 'Altamaha Park', 31.4263896942139, 0.548493972178846, -81.6072235107422, -1.42431474367338, 218, 13, 'PPL', 'P'),
(62505, 'Altamahaw', 36.1841697692871, 0.631532899574657, -79.5074996948242, -1.38766764970307, 218, 33, 'PPL', 'P'),
(92214, 'Altamira West Number 2 Colonia', 26.2900009155273, 0.458847076328276, -98.1869964599609, -1.71368637087034, 218, 51, 'PPL', 'P'),
(26362, 'Altamont', 38.9230613708496, 0.679335575877143, -90.209716796875, -1.5744565753971, 218, 18, 'PPL', 'P'),
(31639, 'Altamont', 37.1902809143066, 0.649092851696258, -95.2969436645508, -1.66324543403396, 218, 20, 'PPL', 'P'),
(44340, 'Altamont', 39.4275016784668, 0.688139720124836, -79.2822189331055, -1.38373575866968, 218, 25, 'PPL', 'P'),
(53169, 'Altamont', 39.8886108398438, 0.696187593201974, -94.0888900756836, -1.6421609213677, 218, 29, 'PPL', 'P'),
(62506, 'Altamont', 35.9908294677734, 0.628158474736445, -81.9444427490234, -1.43020032968245, 218, 33, 'PPL', 'P'),
(84640, 'Altamont', 35.4294395446777, 0.618360372190907, -85.7230606079102, -1.49614965249468, 218, 50, 'PPL', 'P'),
(146781, 'Altamont', 42.7005615234375, 0.74526539103439, -74.0341720581055, -1.29214006140193, 218, 40, 'PPL', 'P'),
(154050, 'Altamont', 40.3333282470703, 0.70394937619901, -80.6177825927734, -1.40704574190087, 218, 41, 'PPL', 'P'),
(158657, 'Altamont', 40.7861099243164, 0.711851907259657, -76.2252807617188, -1.33038212254908, 218, 45, 'PPL', 'P'),
(169718, 'Altamont', 44.8397216796875, 0.782600778988429, -96.6891708374023, -1.68754438213595, 218, 49, 'PPL', 'P'),
(179720, 'Altamont', 37.7438888549805, 0.658755133026202, -121.661666870117, -2.12339666034805, 218, 6, 'PPL', 'P'),
(200321, 'Altamont', 42.2069396972656, 0.736650064907984, -121.736106872559, -2.12469588348584, 218, 43, 'PPL', 'P'),
(202857, 'Altamont', 40.3594398498535, 0.70440510964055, -110.28556060791, -1.92484615001579, 218, 52, 'PPL', 'P'),
(209268, 'Altamont', 41.1922187805176, 0.718939843921875, -110.788887023926, -1.93363085318753, 218, 59, 'PPL', 'P'),
(112764, 'Altamont Park', 33.5094413757324, 0.584850082510549, -86.7655563354492, -1.51434463537821, 218, 2, 'PPL', 'P'),
(44341, 'Altamont Place', 39.6027793884277, 0.69119889326901, -75.934440612793, -1.32530600435334, 218, 25, 'PPL', 'P'),
(122130, 'Altamont Switch', 40.3786087036133, 0.704739669252491, -86.8744430541992, -1.5162450671321, 218, 19, 'PPL', 'P'),
(14975, 'Altamonte Springs', 28.6608295440674, 0.500225841896841, -81.3658294677734, -1.42010162282887, 218, 12, 'PPL', 'P'),
(62508, 'Altapass', 35.8933296203613, 0.626456781378911, -82.0180587768555, -1.43148517175036, 218, 33, 'PPL', 'P'),
(179718, 'Altaville', 38.0838890075684, 0.664689255146144, -120.560829162598, -2.10418341782173, 218, 6, 'PPL', 'P'),
(99384, 'Altavista', 37.1116714477539, 0.647720857681676, -79.2858276367188, -1.38379874242946, 218, 53, 'PPL', 'P'),
(202860, 'Altawood', 40.5811080932617, 0.708273950335135, -111.802780151367, -1.95132662652472, 218, 52, 'PPL', 'P'),
(202862, 'Altawood Subdivision Number 3', 40.5791702270508, 0.708240128189291, -111.804168701172, -1.95135086129064, 218, 52, 'PPL', 'P'),
(146782, 'Altay', 42.4394416809082, 0.740707990039965, -77.0202789306641, -1.34425745814451, 218, 40, 'PPL', 'P'),
(179719, 'Alten', 38.3813896179199, 0.669881620323471, -122.805282592773, -2.14335652008598, 218, 6, 'PPL', 'P'),
(53180, 'Altenburg', 37.6308288574219, 0.656781863816507, -89.5852813720703, -1.56355812126817, 218, 29, 'PPL', 'P'),
(77780, 'Altenwald', 39.8450012207031, 0.695426461762429, -77.603889465332, -1.35444338352379, 218, 45, 'PPL', 'P'),
(118606, 'Altgeld Gardens', 41.6544418334961, 0.727007158074971, -87.601936340332, -1.52894222026127, 218, 18, 'PPL', 'P'),
(14976, 'Altha', 30.5702800750732, 0.533552040566847, -85.1272201538086, -1.48575027475403, 218, 12, 'PPL', 'P'),
(7077, 'Altharp (historical)', 34.5933303833008, 0.603767514418791, -92.370002746582, -1.61216067800406, 218, 4, 'PPL', 'P'),
(53170, 'Althea', 36.6413917541504, 0.639512928623025, -92.2286071777344, -1.60969285977994, 218, 29, 'PPL', 'P'),
(79517, 'Althea (historical)', 33.8122215270996, 0.590134593061593, -81.4638900756836, -1.42181310330341, 218, 48, 'PPL', 'P'),
(53171, 'Altheim', 38.6313896179199, 0.674244943453457, -90.4877777099609, -1.57930965385155, 218, 29, 'PPL', 'P'),
(7078, 'Altheimer', 34.3191719055176, 0.598982546309218, -91.8472213745117, -1.60303642179334, 218, 4, 'PPL', 'P'),
(158658, 'Althom', 41.7533302307129, 0.728733086198424, -79.3030624389648, -1.38409954647458, 218, 45, 'PPL', 'P'),
(77778, 'Althouse', 39.8880615234375, 0.69617800582205, -79.0311126708984, -1.37935312762179, 218, 45, 'PPL', 'P'),
(200322, 'Althouse (historical)', 42.1263885498047, 0.735244182168531, -123.576393127441, -2.15681493781275, 218, 43, 'PPL', 'P'),
(58454, 'Altitude', 34.6683311462402, 0.605076524673592, -88.4430618286133, -1.54362262945422, 218, 30, 'PPL', 'P'),
(71651, 'Altitude', 39.753059387207, 0.693821774047602, -81.0236129760742, -1.4141288182941, 218, 41, 'PPL', 'P'),
(107960, 'Altizer', 38.827220916748, 0.677662844396465, -81.148063659668, -1.41630089247917, 218, 58, 'PPL', 'P'),
(18827, 'Altman', 32.7255592346191, 0.571168758200539, -81.6305618286133, -1.4247220741621, 218, 13, 'PPL', 'P'),
(107962, 'Altman', 38.1644401550293, 0.666095137885596, -81.8680572509766, -1.42886715124076, 218, 58, 'PPL', 'P'),
(158659, 'Altman', 40.9755592346191, 0.715158421490072, -80.2788925170898, -1.40113099427786, 218, 45, 'PPL', 'P'),
(186332, 'Altman (historical)', 38.7361106872559, 0.676072670909578, -105.133331298828, -1.83492278475456, 218, 7, 'PPL', 'P'),
(118607, 'Altmar', 41.1419410705566, 0.718062332342694, -88.8925018310547, -1.55146683728699, 218, 18, 'PPL', 'P'),
(146783, 'Altmar', 43.5099983215332, 0.759392728247961, -76.0025024414063, -1.32649390735757, 218, 40, 'PPL', 'P'),
(18828, 'Alto', 34.4672203063965, 0.601566478356867, -83.5738906860352, -1.45863956117314, 218, 13, 'PPL', 'P'),
(39089, 'Alto', 32.3574981689453, 0.564744880756132, -91.8597183227539, -1.60325453468662, 218, 22, 'PPL', 'P'),
(84642, 'Alto', 35.2705612182617, 0.615587422284889, -85.9530563354492, -1.50016383520576, 218, 50, 'PPL', 'P'),
(92215, 'Alto', 31.6502799987793, 0.552401595156806, -95.0725021362305, -1.65932819038656, 218, 51, 'PPL', 'P'),
(99385, 'Alto', 37.7719383239746, 0.659244688613586, -79.2280578613281, -1.38279046964075, 218, 53, 'PPL', 'P'),
(112220, 'Alto', 35.5699996948242, 0.620813609608061, -90.3311080932617, -1.57657525320231, 218, 4, 'PPL', 'P'),
(122131, 'Alto', 40.439998626709, 0.705811125538057, -86.1655578613281, -1.50387268649786, 218, 19, 'PPL', 'P'),
(129511, 'Alto', 42.8566703796387, 0.747990004566623, -85.3802795410156, -1.49016699426388, 218, 27, 'PPL', 'P'),
(172895, 'Alto', 43.6766700744629, 0.762301699106654, -88.7949981689453, -1.54976507735043, 218, 57, 'PPL', 'P'),
(188029, 'Alto', 33.398609161377, 0.58291569545277, -105.680282592773, -1.84446888568195, 218, 38, 'PPL', 'P'),
(192889, 'Alto', 37.9044418334961, 0.661557311125183, -122.524436950684, -2.13845483894163, 218, 6, 'PPL', 'P'),
(193009, 'Alto', 31.6044406890869, 0.551601548275832, -110.877502441406, -1.93517748399059, 218, 5, 'PPL', 'P'),
(201855, 'Alto', 44.3300018310547, 0.773704489367019, -100.126937866211, -1.74754473570517, 218, 49, 'PPL', 'P'),
(206681, 'Alto', 46.3863906860352, 0.809595245587745, -118.110557556152, -2.06141811072113, 218, 56, 'PPL', 'P'),
(92216, 'Alto Bonito', 26.3072204589844, 0.459147614057291, -98.6399993896484, -1.72159276351456, 218, 51, 'PPL', 'P'),
(92217, 'Alto Bonito Colonia', 26.3040008544922, 0.459091421358291, -98.6399993896484, -1.72159276351456, 218, 51, 'PPL', 'P'),
(92218, 'Alto Bonito Heights Colonia', 26.3150005340576, 0.459283401983372, -98.640998840332, -1.7216102072197, 218, 51, 'PPL', 'P'),
(92219, 'Alto Colorado', 27.1563892364502, 0.473968405129205, -98.1266708374023, -1.71263349013337, 218, 51, 'PPL', 'P'),
(158660, 'Alto Grandview Acres', 40.2666702270508, 0.702785974276809, -75.5999984741211, -1.3194688878761, 218, 45, 'PPL', 'P'),
(26363, 'Alto Pass', 37.5702781677246, 0.655725054916937, -89.317497253418, -1.55888440671314, 218, 18, 'PPL', 'P'),
(92220, 'Alto Real Colonia', 26.1490001678467, 0.456386149033474, -97.8570022583008, -1.70792688553888, 218, 51, 'PPL', 'P'),
(92221, 'Alto Springs', 31.2858295440674, 0.546040734761692, -96.670280456543, -1.687214682793, 218, 51, 'PPL', 'P'),
(44342, 'Alto Vista', 39.5541687011719, 0.690350476724738, -76.9905624389648, -1.34373880752221, 218, 25, 'PPL', 'P'),
(92222, 'Altoga', 33.2497215270996, 0.580317116019125, -96.4891662597656, -1.68405364373713, 218, 51, 'PPL', 'P'),
(14977, 'Alton', 30.0527801513672, 0.524519963019357, -83.1380615234375, -1.4510329073096, 218, 12, 'PPL', 'P'),
(26365, 'Alton', 38.8905601501465, 0.678768322564956, -90.1841735839844, -1.57401076223062, 218, 18, 'PPL', 'P'),
(29093, 'Alton', 38.122501373291, 0.665363168059988, -86.4177780151367, -1.50827475862171, 218, 19, 'PPL', 'P'),
(31640, 'Alton', 39.4708290100098, 0.688895924716364, -98.9477767944336, -1.72696449259131, 218, 20, 'PPL', 'P'),
(34546, 'Alton', 38.0888900756836, 0.664776540250871, -84.9349975585938, -1.48239535757081, 218, 21, 'PPL', 'P'),
(39090, 'Alton', 30.3305606842041, 0.529368147915306, -89.7619400024414, -1.56664139602021, 218, 22, 'PPL', 'P'),
(53172, 'Alton', 36.6941719055176, 0.640434116044083, -91.399169921875, -1.59521644872649, 218, 29, 'PPL', 'P'),
(62509, 'Alton', 34.8808288574219, 0.608785309386663, -80.5419387817383, -1.40572201768104, 218, 33, 'PPL', 'P'),
(71652, 'Alton', 39.9502792358398, 0.69726390975653, -83.1747207641602, -1.45167273176149, 218, 41, 'PPL', 'P'),
(92223, 'Alton', 26.2869396209717, 0.458793646658906, -98.3130569458008, -1.7158865414049, 218, 51, 'PPL', 'P'),
(99386, 'Alton', 36.5730590820313, 0.63832029850786, -79.003059387207, -1.37886350545538, 218, 53, 'PPL', 'P'),
(107963, 'Alton', 38.8191719055176, 0.677522362648963, -80.2141723632813, -1.4000014145015, 218, 58, 'PPL', 'P'),
(112763, 'Alton', 33.5791702270508, 0.586067080549688, -86.6374969482422, -1.51210957743337, 218, 2, 'PPL', 'P'),
(114397, 'Alton', 42.9874992370605, 0.750273398885257, -96.0102767944336, -1.67569544581397, 218, 16, 'PPL', 'P'),
(126754, 'Alton', 45.0313911437988, 0.785946042212705, -68.7291717529297, -1.19955033925731, 218, 26, 'PPL', 'P'),
(129513, 'Alton', 43.0163917541504, 0.750777668437663, -85.3516693115234, -1.48966765155949, 218, 27, 'PPL', 'P'),
(139591, 'Alton', 47.3555603027344, 0.826510446409437, -97.045280456543, -1.69375966748798, 218, 34, 'PPL', 'P'),
(143459, 'Alton', 43.452220916748, 0.758384322301202, -71.2180633544922, -1.24298969242981, 218, 36, 'PPL', 'P'),
(146784, 'Alton', 43.211109161377, 0.754176128304714, -76.980827331543, -1.34356889784467, 218, 40, 'PPL', 'P'),
(169252, 'Alton', 41.4375, 0.72322080879515, -71.7177810668945, -1.25171141184176, 218, 47, 'PPL', 'P'),
(193082, 'Alton', 37.4377784729004, 0.653412498984366, -112.481941223145, -1.96318022337861, 218, 52, 'PPL', 'P'),
(193344, 'Alton', 40.5475006103516, 0.707687389105045, -124.139717102051, -2.1666467959251, 218, 6, 'PPL', 'P'),
(194514, 'Alton', 42.2275009155273, 0.737008925864872, -111.150833129883, -1.93994800445125, 218, 17, 'PPL', 'P'),
(7079, 'Alton (historical)', 33.5625, 0.585776130200597, -93.5897216796875, -1.63344878933566, 218, 4, 'PPL', 'P'),
(18829, 'Alton (historical)', 31.8969402313232, 0.556706628348432, -81.9094390869141, -1.42958940052839, 218, 13, 'PPL', 'P'),
(39091, 'Alton (historical)', 31.4422206878662, 0.548770275141942, -91.8119430541992, -1.60242069894932, 218, 22, 'PPL', 'P'),
(143460, 'Alton Bay', 43.4686088562012, 0.758670345802277, -71.2324981689453, -1.24324162746893, 218, 36, 'PPL', 'P'),
(92224, 'Alton North', 26.2950000762939, 0.45893432814349, -98.3041687011719, -1.71573141227141, 218, 51, 'PPL', 'P'),
(84644, 'Alton Park', 35.003059387207, 0.610918634577871, -85.3166732788086, -1.48905685556348, 218, 50, 'PPL', 'P'),
(34543, 'Alton Station', 38.0780601501465, 0.664587522392503, -84.9422225952148, -1.48252145824842, 218, 21, 'PPL', 'P'),
(34544, 'Altona', 37.0522193908691, 0.646683223541954, -88.396110534668, -1.5428031747868, 218, 21, 'PPL', 'P'),
(53173, 'Altona', 38.3997192382813, 0.670201532549417, -94.2347183227539, -1.64470610442148, 218, 29, 'PPL', 'P'),
(74981, 'Altona', 35.7830581665039, 0.624532181438138, -98.1708297729492, -1.71340420895284, 218, 42, 'PPL', 'P'),
(118609, 'Altona', 41.1147193908691, 0.717587224404224, -90.164436340332, -1.57366628234362, 218, 18, 'PPL', 'P'),
(122132, 'Altona', 41.351390838623, 0.721717920412991, -85.1549987792969, -1.48623510323048, 218, 19, 'PPL', 'P'),
(129514, 'Altona', 43.5397186279297, 0.759911445449281, -85.313606262207, -1.48900332602557, 218, 27, 'PPL', 'P'),
(141157, 'Altona', 42.1049995422363, 0.734870873562729, -96.991943359375, -1.69282875952894, 218, 35, 'PPL', 'P'),
(146785, 'Altona', 44.8883285522461, 0.783449128953674, -73.6561126708984, -1.28554168032709, 218, 40, 'PPL', 'P'),
(194084, 'Altona', 40.1338882446289, 0.700468491496222, -105.282218933105, -1.8375213641882, 218, 7, 'PPL', 'P'),
(158662, 'Altonah', 40.6561088562012, 0.709582960589936, -75.3613891601563, -1.31530436972149, 218, 45, 'PPL', 'P'),
(202863, 'Altonah', 40.4013900756836, 0.70513727920324, -110.293060302734, -1.92497704438337, 218, 52, 'PPL', 'P'),
(84643, 'Altonville', 36.3980598449707, 0.635265985632676, -83.1236114501953, -1.45078070595437, 218, 50, 'PPL', 'P'),
(14978, 'Altoona', 28.9655609130859, 0.505544407620325, -81.6488876342773, -1.42504191980902, 218, 12, 'PPL', 'P'),
(31641, 'Altoona', 37.5238914489746, 0.654915453945553, -95.6611099243164, -1.66960133429154, 218, 20, 'PPL', 'P'),
(39092, 'Altoona', 32.4544410705566, 0.566436853575687, -91.45361328125, -1.59616666460343, 218, 22, 'PPL', 'P'),
(71653, 'Altoona', 39.1133308410645, 0.682656404598418, -82.586669921875, -1.44140930839449, 218, 41, 'PPL', 'P'),
(112765, 'Altoona', 34.0261116027832, 0.593867679119612, -86.3261108398438, -1.50667486459684, 218, 2, 'PPL', 'P'),
(114398, 'Altoona', 41.6441688537598, 0.726827860754581, -93.4644393920898, -1.63126220092266, 218, 16, 'PPL', 'P'),
(158663, 'Altoona', 40.5186080932617, 0.707183119552639, -78.3949966430664, -1.36825080851141, 218, 45, 'PPL', 'P'),
(172897, 'Altoona', 44.8047218322754, 0.781989916413392, -91.4430618286133, -1.59598250701405, 218, 57, 'PPL', 'P'),
(206682, 'Altoona', 46.2669410705566, 0.807510456507404, -123.654998779297, -2.1581868652483, 218, 56, 'PPL', 'P'),
(44345, 'Altoona Beach', 39.1591682434082, 0.683456418189877, -76.5405578613281, -1.33588474599341, 218, 25, 'PPL', 'P'),
(99388, 'Altoona Mines (historical)', 37.0819396972656, 0.647201940743275, -80.8686065673828, -1.41142344610074, 218, 53, 'PPL', 'P'),
(77779, 'Altor', 39.9702796936035, 0.697612983596412, -75.6699981689453, -1.32069061302618, 218, 45, 'PPL', 'P'),
(118610, 'Altorf', 41.1902809143066, 0.718906021776031, -87.9622192382813, -1.53523034306911, 218, 18, 'PPL', 'P'),
(34545, 'Altro', 37.3808288574219, 0.652418540686522, -83.3822174072266, -1.45529423136983, 218, 21, 'PPL', 'P'),
(191066, 'Altuda', 30.3019409179688, 0.528868638763348, -103.457496643066, -1.80567395229249, 218, 51, 'PPL', 'P'),
(133925, 'Altura', 44.0716705322266, 0.769195757641515, -91.9394378662109, -1.60464590319813, 218, 28, 'PPL', 'P'),
(144742, 'Altura', 40.2675018310547, 0.70280048850475, -74.8166732788086, -1.30579728410407, 218, 37, 'PPL', 'P'),
(186334, 'Altura', 37.1833305358887, 0.648971544708605, -107.190559387207, -1.87082818836128, 218, 7, 'PPL', 'P'),
(14979, 'Alturas', 27.8713893890381, 0.486447511944125, -81.7152786254883, -1.42620066119932, 218, 12, 'PPL', 'P'),
(193345, 'Alturas', 41.4872207641602, 0.724088599836353, -120.541389465332, -2.10384413109885, 218, 6, 'PPL', 'P'),
(194515, 'Alturas City (historical)', 43.8008308410645, 0.764468713285652, -115.159439086914, -2.0099113768165, 218, 17, 'PPL', 'P'),
(92225, 'Alturas de Azahares Colonia', 26.2479991912842, 0.458114007948718, -98.2939987182617, -1.71555391258475, 218, 51, 'PPL', 'P'),
(7080, 'Altus', 35.4461097717285, 0.618651322539998, -93.7622222900391, -1.636459492948, 218, 4, 'PPL', 'P'),
(58455, 'Altus', 34.3408317565918, 0.599360582025955, -89.396110534668, -1.56025646730674, 218, 30, 'PPL', 'P'),
(74983, 'Altus', 34.6380615234375, 0.604548220092347, -99.333610534668, -1.73369856172368, 218, 42, 'PPL', 'P'),
(202864, 'Altus', 40.752498626709, 0.711265279450539, -111.617500305176, -1.94809288317109, 218, 52, 'PPL', 'P'),
(209269, 'Altvan', 41.1230583190918, 0.717732766157797, -104.699440002441, -1.82734995303686, 218, 59, 'PPL', 'P'),
(195865, 'Altyn (historical)', 48.7999992370605, 0.851720661657427, -113.623611450195, -1.98310612781264, 218, 31, 'PPL', 'P'),
(92226, 'Alum', 29.2950000762939, 0.511294205703319, -97.9644393920898, -1.7098020172624, 218, 51, 'PPL', 'P'),
(7081, 'Alum (historical)', 34.5944404602051, 0.603786888915721, -92.727783203125, -1.61840512497003, 218, 4, 'PPL', 'P'),
(189864, 'Alum (historical)', 37.9086112976074, 0.661630082001969, -117.665832519531, -2.05365619456604, 218, 39, 'PPL', 'P'),
(158665, 'Alum Bank', 40.1805610656738, 0.70128308589465, -78.6138916015625, -1.37207124625318, 218, 45, 'PPL', 'P'),
(107964, 'Alum Bridge', 39.0391693115234, 0.681362041729612, -80.6552810668945, -1.40770021373875, 218, 58, 'PPL', 'P'),
(92227, 'Alum Creek', 30.0674991607666, 0.524776858196009, -97.2172164916992, -1.69676051740428, 218, 51, 'PPL', 'P'),
(107965, 'Alum Creek', 38.2866706848145, 0.668228463076804, -81.8052825927734, -1.4277715267683, 218, 58, 'PPL', 'P'),
(154051, 'Alum Creek', 40.267219543457, 0.702795561656733, -82.9444427490234, -1.4476536222024, 218, 41, 'PPL', 'P'),
(158666, 'Alum Rock', 41.1672210693359, 0.718503551556293, -79.6213912963867, -1.3896554331407, 218, 45, 'PPL', 'P'),
(179721, 'Alum Rock', 37.3661117553711, 0.652161678799384, -121.826110839844, -2.12626674905483, 218, 6, 'PPL', 'P'),
(34547, 'Alum Springs', 37.5966682434082, 0.656185648627466, -84.8405609130859, -1.48074712717216, 218, 21, 'PPL', 'P'),
(99389, 'Alum Springs', 37.1597213745117, 0.648559487108942, -80.8047180175781, -1.41030838055232, 218, 53, 'PPL', 'P'),
(107966, 'Alum Springs (historical)', 37.8613891601563, 0.660805900223617, -80.3727798461914, -1.40276963729658, 218, 58, 'PPL', 'P'),
(99390, 'Alum Wells', 36.7577781677246, 0.641544254744483, -82.1836090087891, -1.43437456837504, 218, 53, 'PPL', 'P'),
(34548, 'Alumbaugh', 37.5974998474121, 0.656200162855407, -83.9300003051758, -1.46485484652516, 218, 21, 'PPL', 'P'),
(84645, 'Alumwell', 36.4811096191406, 0.636715477634978, -83.0019378662109, -1.44865710130114, 218, 50, 'PPL', 'P'),
(192465, 'Alunite', 38.3791694641113, 0.66984287132961, -112.245826721191, -1.95905924790782, 218, 52, 'PPL', 'P'),
(158667, 'Aluta', 40.7708282470703, 0.711585191676485, -75.3172225952148, -1.31453351774397, 218, 45, 'PPL', 'P'),
(14980, 'Alva', 26.7152805328369, 0.466269605891949, -81.6102828979492, -1.42436814005323, 218, 12, 'PPL', 'P'),
(34549, 'Alva', 36.7350006103516, 0.641146711372761, -83.4244384765625, -1.45603112804346, 218, 21, 'PPL', 'P'),
(58456, 'Alva', 33.6377792358398, 0.587090000724387, -89.5072174072266, -1.56219564805449, 218, 30, 'PPL', 'P'),
(74984, 'Alva', 36.8050003051758, 0.642368436522835, -98.6661071777344, -1.72204843037707, 218, 42, 'PPL', 'P'),
(209270, 'Alva', 44.6947212219238, 0.780070043583554, -104.440826416016, -1.82283629446334, 218, 59, 'PPL', 'P'),
(92228, 'Alvacan Colonia', 26.3320007324219, 0.45958011141832, -98.1829986572266, -1.71361659604977, 218, 51, 'PPL', 'P'),
(154052, 'Alvada', 41.0502815246582, 0.716462571475883, -83.4019393920898, -1.45563844494073, 218, 41, 'PPL', 'P'),
(200323, 'Alvadore', 44.1269416809082, 0.770160421167369, -123.263328552246, -2.15135093020423, 218, 43, 'PPL', 'P'),
(158668, 'Alvan', 40.146110534668, 0.700681810699537, -78.1494369506836, -1.36396498336915, 218, 45, 'PPL', 'P'),
(92229, 'Alvarado', 32.4063911437988, 0.565598224148421, -97.2113876342773, -1.69665878465064, 218, 51, 'PPL', 'P'),
(99391, 'Alvarado', 36.6505584716797, 0.639672918025512, -81.8869400024414, -1.42919671742566, 218, 53, 'PPL', 'P'),
(122133, 'Alvarado', 41.5766716003418, 0.725649811446384, -84.8377838134766, -1.48069865764032, 218, 19, 'PPL', 'P'),
(133927, 'Alvarado', 48.1941719055176, 0.841146980023431, -96.9958267211914, -1.69289653697869, 218, 28, 'PPL', 'P'),
(188030, 'Alvarado', 32.1363906860352, 0.560885827178553, -106.236671447754, -1.85417970312276, 218, 38, 'PPL', 'P'),
(192958, 'Alvarez Colonia', 31.5890007019043, 0.55133206966303, -106.271003723145, -1.85477891436802, 218, 51, 'PPL', 'P'),
(144743, 'Alvater Corner', 40.5658302307129, 0.708007301330991, -74.9702835083008, -1.30847828837345, 218, 37, 'PPL', 'P'),
(18830, 'Alvaton', 33.1708297729492, 0.578940195156527, -84.5805587768555, -1.47620923383272, 218, 13, 'PPL', 'P'),
(34550, 'Alvaton', 36.8733291625977, 0.643561000058973, -86.3530578613281, -1.50714517884535, 218, 21, 'PPL', 'P'),
(158669, 'Alverda', 40.6302795410156, 0.709132153996413, -78.8572235107422, -1.37631818924353, 218, 45, 'PPL', 'P'),
(129515, 'Alverno', 45.5586090087891, 0.795147729832119, -84.3916702270508, -1.47291250671931, 218, 27, 'PPL', 'P'),
(172899, 'Alverno', 44.0849990844727, 0.769428384762734, -87.7397232055664, -1.53134705472561, 218, 57, 'PPL', 'P'),
(146787, 'Alverson', 43.9477806091309, 0.767033470573453, -76.0244369506836, -1.32687673676427, 218, 40, 'PPL', 'P'),
(158670, 'Alverton', 40.1399993896484, 0.700575151097879, -79.5875015258789, -1.3890639450626, 218, 45, 'PPL', 'P'),
(191067, 'Alvery Junction', 31.4813899993896, 0.549453908593765, -100.416938781738, -1.75260620651492, 218, 51, 'PPL', 'P'),
(200324, 'Alville (historical)', 45.2955589294434, 0.790556639849905, -120.33332824707, -2.10021277779447, 218, 43, 'PPL', 'P'),
(18831, 'Alvin', 34.2341690063477, 0.597498965844962, -83.3241729736328, -1.45428116489117, 218, 13, 'PPL', 'P'),
(34551, 'Alvin', 37.6366691589355, 0.65688379630723, -82.6949996948242, -1.44330001961039, 218, 21, 'PPL', 'P'),
(79519, 'Alvin', 33.3488883972168, 0.582047904411568, -79.8163909912109, -1.39305881985577, 218, 48, 'PPL', 'P'),
(92230, 'Alvin', 29.4236106872559, 0.513538884317606, -95.2438888549805, -1.66231945292294, 218, 51, 'PPL', 'P'),
(118611, 'Alvin', 40.3083305358887, 0.703513083833428, -87.6083297729492, -1.52905380671094, 218, 18, 'PPL', 'P'),
(129516, 'Alvin', 44.5244407653809, 0.77709808896508, -83.442497253418, -1.45634631315847, 218, 27, 'PPL', 'P'),
(172900, 'Alvin', 45.9850006103516, 0.802589667182237, -88.8291702270508, -1.55036149227656, 218, 57, 'PPL', 'P'),
(194085, 'Alvin', 40.3077812194824, 0.703503496453503, -102.07527923584, -1.78154970755801, 218, 7, 'PPL', 'P'),
(158671, 'Alvira (historical)', 41.1341705322266, 0.717926710864182, -76.9555587768555, -1.34312787836815, 218, 45, 'PPL', 'P'),
(7082, 'Alvis (historical)', 35.9388885498047, 0.627251934701382, -91.7172164916992, -1.60076740854459, 218, 4, 'PPL', 'P'),
(179724, 'Alviso', 37.4261093139648, 0.653208833740003, -121.974166870117, -2.12885081426053, 218, 6, 'PPL', 'P'),
(113153, 'Alvo', 40.871940612793, 0.713349935372826, -96.3872222900391, -1.68227438581285, 218, 35, 'PPL', 'P'),
(107974, 'Alvon', 37.9049987792969, 0.661567031663162, -80.2144393920898, -1.40000607503341, 218, 58, 'PPL', 'P'),
(92231, 'Alvord', 33.3583297729492, 0.582212687504016, -97.6944427490234, -1.70508968687156, 218, 51, 'PPL', 'P'),
(107967, 'Alvord', 38.8074989318848, 0.677318630825572, -81.3491668701172, -1.41981080563784, 218, 58, 'PPL', 'P'),
(114399, 'Alvord', 43.3422203063965, 0.756464449471364, -96.3008270263672, -1.68076650400365, 218, 16, 'PPL', 'P'),
(139009, 'Alvord (historical)', 40.4555587768555, 0.706082701390218, -93.5952835083008, -1.6335458615574, 218, 29, 'PPL', 'P'),
(154053, 'Alvordton', 41.665828704834, 0.727205896471318, -84.4369430541992, -1.47370266661473, 218, 41, 'PPL', 'P'),
(133929, 'Alvwood', 47.7305603027344, 0.833055431104416, -94.2677764892578, -1.64528307827165, 218, 28, 'PPL', 'P'),
(99405, 'Alwington', 38.7044410705566, 0.675519931825332, -77.7880630493164, -1.35765781895951, 218, 53, 'PPL', 'P'),
(118612, 'Alworth', 42.2436103820801, 0.737290089096957, -89.2455596923828, -1.55762885941722, 218, 18, 'PPL', 'P'),
(7085, 'Aly', 34.7905616760254, 0.6072098498648, -93.4861068725586, -1.63164036979745, 218, 4, 'PPL', 'P'),
(212274, 'Alyeska', 60.9608306884766, 1.06396721026472, -149.110824584961, -2.60247483937128, 218, 1, 'PPL', 'P'),
(14981, 'Alys Beach', 30.2833309173584, 0.528543832978899, -86.0305633544922, -1.50151658788147, 218, 12, 'PPL', 'P'),
(92232, 'Alysonders Estates Colonia', 26.2259998321533, 0.457730046698556, -98.3610000610352, -1.71672330661941, 218, 51, 'PPL', 'P'),
(195866, 'Alzada', 45.0230598449707, 0.785800633617187, -104.41194152832, -1.82233215806899, 218, 31, 'PPL', 'P'),
(71654, 'Am-Beth Acres', 39.0855598449707, 0.682171709280023, -84.2808303833008, -1.47097798650347, 218, 41, 'PPL', 'P'),
(39093, 'Ama', 29.951940536499, 0.522759979723465, -90.29638671875, -1.57596925089627, 218, 22, 'PPL', 'P'),
(74986, 'Amabel', 36.0108299255371, 0.628507548576327, -96.8377838134766, -1.69013816787964, 218, 42, 'PPL', 'P'),
(92233, 'Amada Acres Colonia', 26.3430004119873, 0.459772092043401, -98.7409973144531, -1.72335550984009, 218, 51, 'PPL', 'P'),
(193011, 'Amado', 31.7077808380127, 0.553405174124088, -111.063888549805, -1.93843053526212, 218, 5, 'PPL', 'P'),
(189867, 'Amador (historical)', 39.5597190856934, 0.69044734920939, -117.080833435059, -2.04344603442083, 218, 39, 'PPL', 'P'),
(195867, 'Amador (historical)', 47.1761093139648, 0.82337843580945, -114.86888885498, -2.00484031862683, 218, 31, 'PPL', 'P'),
(179722, 'Amador City', 38.4194412231445, 0.67054574612031, -120.823059082031, -2.10876019331308, 218, 6, 'PPL', 'P'),
(129517, 'Amadore', 43.1949996948242, 0.753894965072628, -82.5858306884766, -1.44139466100849, 218, 27, 'PPL', 'P'),
(146788, 'Amagansett', 40.9736099243164, 0.715124399607146, -72.144172668457, -1.25915334919188, 218, 40, 'PPL', 'P'),
(7083, 'Amagon', 35.561939239502, 0.620672928123477, -91.1102828979492, -1.59017441899269, 218, 4, 'PPL', 'P'),
(194517, 'Amalga', 42.5769386291504, 0.743107764498235, -113.723892211914, -1.98485635728104, 218, 17, 'PPL', 'P'),
(202865, 'Amalga', 41.8611106872559, 0.730614210034401, -111.894996643066, -1.95293610792951, 218, 52, 'PPL', 'P'),
(188031, 'Amalia', 36.9419403076172, 0.644758490443127, -105.453887939453, -1.8405175535726, 218, 38, 'PPL', 'P'),
(79520, 'Aman (historical)', 34.0869407653809, 0.594929348288172, -80.3333282470703, -1.40208107699674, 218, 48, 'PPL', 'P'),
(114400, 'Amana', 41.7999992370605, 0.729547614017824, -91.8705596923828, -1.60344375228207, 218, 16, 'PPL', 'P'),
(7084, 'Amanca', 35.1083297729492, 0.612755949413917, -90.2297210693359, -1.57480571581601, 218, 4, 'PPL', 'P'),
(53174, 'Amanda', 38.059440612793, 0.664262550160486, -91.4119415283203, -1.59543935530973, 218, 29, 'PPL', 'P'),
(71655, 'Amanda', 39.6494407653809, 0.692013287930357, -82.7444381713867, -1.44416288380357, 218, 41, 'PPL', 'P'),
(191068, 'Amanda', 29.3716697692871, 0.512632344282543, -100.657501220703, -1.75680481313148, 218, 51, 'PPL', 'P'),
(44346, 'Amanda Hills', 39.5999984741211, 0.691150357158144, -77.0536117553711, -1.34483922568463, 218, 25, 'PPL', 'P'),
(206683, 'Amanda Park', 47.4633293151855, 0.828391370508333, -123.884719848633, -2.16219625426941, 218, 56, 'PPL', 'P'),
(34553, 'Amandaville', 36.896671295166, 0.643968397126727, -85.3111114501953, -1.48895978334174, 218, 21, 'PPL', 'P'),
(107968, 'Amandaville', 38.3972206115723, 0.670157923286567, -81.8561096191406, -1.42865862572741, 218, 58, 'PPL', 'P'),
(18832, 'Amandaville (historical)', 34.2266693115234, 0.597368071477385, -82.9638900756836, -1.44799304208333, 218, 13, 'PPL', 'P'),
(62511, 'Amantha', 36.2786102294922, 0.633181196552334, -81.7799987792969, -1.42733024097567, 218, 33, 'PPL', 'P'),
(13272, 'Amaranth', 39.7138900756836, 0.693138140595779, -75.783332824707, -1.32266867592583, 218, 10, 'PPL', 'P'),
(77785, 'Amaranth', 39.7975006103516, 0.694597419715088, -78.2783279418945, -1.36621455554194, 218, 45, 'PPL', 'P'),
(188032, 'Amargo', 36.9377784729004, 0.644685852724395, -106.89111328125, -1.86560186788005, 218, 38, 'PPL', 'P'),
(189868, 'Amargosa (historical)', 36.5697212219238, 0.638262041859015, -116.157501220703, -2.0273308471906, 218, 39, 'PPL', 'P'),
(92234, 'Amargosa Colonia', 27.8859996795654, 0.4867025096185, -98.1070022583008, -1.71229020866886, 218, 51, 'PPL', 'P'),
(92251, 'Amargosa Number 2 Colonia', 27.8840007781982, 0.48666762220822, -98.1039962768555, -1.71223774439539, 218, 51, 'PPL', 'P'),
(189869, 'Amargosa Valley', 36.6438903808594, 0.639556537885875, -116.399436950684, -2.03155342225698, 218, 39, 'PPL', 'P'),
(191069, 'Amarillo', 35.2219390869141, 0.614738806003536, -101.830833435059, -1.7772833234917, 218, 51, 'PPL', 'P'),
(129518, 'Amasa', 46.232780456543, 0.806914241318362, -88.4486083984375, -1.54371943535984, 218, 27, 'PPL', 'P'),
(7095, 'Amateur (historical)', 36.0166702270508, 0.62860948106705, -91.5361099243164, -1.59760650264678, 218, 4, 'PPL', 'P'),
(77781, 'Amatus', 39.964168548584, 0.697506323994754, -77.0441665649414, -1.34467437601316, 218, 45, 'PPL', 'P'),
(146789, 'Amawalk', 41.288330078125, 0.720617302513489, -73.7666702270508, -1.28747127369491, 218, 40, 'PPL', 'P'),
(92235, 'Amaya Colonia', 28.7099990844727, 0.501084012268605, -99.8349990844727, -1.74244944274957, 218, 51, 'PPL', 'P'),
(195868, 'Amazon', 46.3202781677246, 0.808441364466441, -112.106391906738, -1.95662565130371, 218, 31, 'PPL', 'P'),
(53175, 'Amazonia', 39.8861083984375, 0.696143917360097, -94.8916702270508, -1.65617207817871, 218, 29, 'PPL', 'P'),
(34552, 'Amba', 37.5297203063965, 0.655017186699194, -82.6430587768555, -1.44239347957533, 218, 21, 'PPL', 'P'),
(99392, 'Ambar', 38.3250007629395, 0.668897449142632, -77.1783294677734, -1.34701596040161, 218, 53, 'PPL', 'P'),
(193096, 'Ambassador Downs Mobile Home Park', 33.4066696166992, 0.583056376937353, -111.780281066895, -1.95093394342199, 218, 5, 'PPL', 'P'),
(77782, 'Ambau', 39.851390838623, 0.695537981633076, -76.8933334350586, -1.34204184127561, 218, 45, 'PPL', 'P'),
(74987, 'Amber', 35.1602783203125, 0.613662622607035, -97.8788909912109, -1.70830891599725, 218, 42, 'PPL', 'P'),
(129519, 'Amber', 43.9555587768555, 0.767169225210019, -86.3194427490234, -1.5065584844572, 218, 27, 'PPL', 'P'),
(146790, 'Amber', 42.8872184753418, 0.748523169416857, -76.2969436645508, -1.33163287615504, 218, 40, 'PPL', 'P'),
(177314, 'Amber', 42.128059387207, 0.735273343782467, -91.1800003051758, -1.59139121729475, 218, 16, 'PPL', 'P'),
(189870, 'Amber', 36.6080589294434, 0.638931161082897, -114.49333190918, -1.99828561339387, 218, 39, 'PPL', 'P'),
(206684, 'Amber', 47.3519401550293, 0.826447262912575, -117.710563659668, -2.05443690023959, 218, 56, 'PPL', 'P'),
(7086, 'Amber (historical)', 34.3769416809082, 0.599990819097922, -92.2375030517578, -1.60984812207149, 218, 4, 'PPL', 'P'),
(179726, 'Amber Hills', 34.142219543457, 0.59589414497208, -117.207778930664, -2.04566165128973, 218, 6, 'PPL', 'P'),
(99393, 'Amber Lake', 37.6622200012207, 0.657329742631764, -77.7736129760742, -1.35740561760428, 218, 53, 'PPL', 'P'),
(92236, 'Amber Land Colonia', 26.2749996185303, 0.458585254303607, -98.2850036621094, -1.71539691923849, 218, 51, 'PPL', 'P'),
(44347, 'Amber Meadows', 39.452220916748, 0.688571152221429, -77.408332824707, -1.35103027627074, 218, 25, 'PPL', 'P'),
(84647, 'Amber Meadows', 36.086669921875, 0.629831206217124, -85.5569381713867, -1.49325026901591, 218, 50, 'PPL', 'P'),
(202868, 'Amber Way Condominium', 41.1749992370605, 0.71863930619286, -111.974998474121, -1.95433240328904, 218, 52, 'PPL', 'P'),
(18834, 'Amber Wood Estates', 33.5869407653809, 0.5862027020282, -84.288330078125, -1.47110888087105, 218, 13, 'PPL', 'P'),
(44348, 'Amber Woode', 38.7105598449707, 0.675626724585044, -76.5899963378906, -1.33674761018659, 218, 25, 'PPL', 'P'),
(44349, 'Amberfield', 39.0191688537598, 0.68101296788973, -76.6930618286133, -1.33854644234489, 218, 25, 'PPL', 'P'),
(172902, 'Amberg', 45.503059387207, 0.794178206037276, -87.9936065673828, -1.53577815530534, 218, 57, 'PPL', 'P'),
(44350, 'Amberleigh Farms', 38.4944381713867, 0.671854689796084, -76.8691711425781, -1.341620129717, 218, 25, 'PPL', 'P'),
(71657, 'Amberley', 39.204719543457, 0.684251438354293, -84.4280624389648, -1.47354767063929, 218, 41, 'PPL', 'P'),
(44352, 'Amberly', 39.3738899230957, 0.687204018475837, -76.9377822875977, -1.34281762010115, 218, 25, 'PPL', 'P'),
(158672, 'Amberson', 40.170280456543, 0.701103655416206, -77.6774978637695, -1.35572809243364, 218, 45, 'PPL', 'P'),
(158680, 'Amberson Valley Estates', 40.2036094665527, 0.701685356377306, -77.6324996948242, -1.35494272622818, 218, 45, 'PPL', 'P'),
(193097, 'Amberwood', 33.3616714477539, 0.582271010731889, -111.868606567383, -1.95247551421898, 218, 5, 'PPL', 'P'),
(193013, 'Amberwood II', 33.3458290100098, 0.581994508031712, -111.844718933105, -1.95205859635033, 218, 5, 'PPL', 'P'),
(193014, 'Amberwood North', 33.6597213745117, 0.587472963289141, -112.14582824707, -1.95731394528744, 218, 5, 'PPL', 'P'),
(92237, 'Ambia', 33.5927810668945, 0.586304634518923, -95.6588897705078, -1.66956258529768, 218, 51, 'PPL', 'P'),
(122134, 'Ambia', 40.4900016784668, 0.706683843427276, -87.5169372558594, -1.52745870637604, 218, 19, 'PPL', 'P'),
(129521, 'Amble', 43.4313888549805, 0.758020734233379, -85.3886108398438, -1.49031240285939, 218, 27, 'PPL', 'P'),
(122135, 'Ambler', 41.7158317565918, 0.728078614360537, -86.7966690063477, -1.51488765392448, 218, 19, 'PPL', 'P'),
(158674, 'Ambler', 40.1544418334961, 0.700827219295056, -75.2219390869141, -1.31287050680127, 218, 45, 'PPL', 'P'),
(212275, 'Ambler', 67.0861129760742, 1.17087355379739, -157.85139465332, -2.75502656556541, 218, 1, 'PPL', 'P'),
(154056, 'Ambler Heights', 41.4972190856934, 0.72426310346678, -81.6011123657227, -1.42420808407172, 218, 41, 'PPL', 'P'),
(179727, 'Ambler Park', 36.5763893127441, 0.638378421998651, -121.719169616699, -2.12440027260485, 218, 6, 'PPL', 'P'),
(146791, 'Amblers Crossing', 42.6733283996582, 0.744790083358838, -75.2630615234375, -1.31358822871504, 218, 40, 'PPL', 'P'),
(107969, 'Amblersburg', 39.3863906860352, 0.687422197948142, -79.6294403076172, -1.38979591488821, 218, 58, 'PPL', 'P'),
(146792, 'Amblerville', 42.5411109924316, 0.742482454274285, -75.4002838134766, -1.31598320948335, 218, 40, 'PPL', 'P'),
(18835, 'Ambleside', 33.5888900756836, 0.586236723911126, -84.2683334350586, -1.4707598736102, 218, 13, 'PPL', 'P'),
(7087, 'Amboy', 34.8058280944824, 0.607476299131862, -92.291389465332, -1.61078861741045, 218, 4, 'PPL', 'P'),
(107970, 'Amboy', 39.348331451416, 0.686757938993249, -79.5686111450195, -1.38873424571965, 218, 58, 'PPL', 'P'),
(118613, 'Amboy', 41.714168548584, 0.728049585904655, -89.32861328125, -1.55907841799855, 218, 18, 'PPL', 'P'),
(122136, 'Amboy', 40.601390838623, 0.708627951023034, -85.9288864135742, -1.49974199048909, 218, 19, 'PPL', 'P'),
(133932, 'Amboy', 43.8880615234375, 0.765991175901823, -94.1563873291016, -1.64333897067589, 218, 28, 'PPL', 'P'),
(141158, 'Amboy', 40.0902786254883, 0.699707360056677, -98.4383316040039, -1.71807299665986, 218, 35, 'PPL', 'P'),
(146793, 'Amboy', 43.0694389343262, 0.751703516390629, -76.2727813720703, -1.33121116459643, 218, 40, 'PPL', 'P'),
(154057, 'Amboy', 41.9272193908691, 0.731768024576678, -80.6152801513672, -1.40700206605899, 218, 41, 'PPL', 'P'),
(179728, 'Amboy', 34.5577812194824, 0.603147064463829, -115.743606567383, -2.02010702273376, 218, 6, 'PPL', 'P'),
(206685, 'Amboy', 45.9102783203125, 0.801285517196425, -122.445281982422, -2.13707332412615, 218, 56, 'PPL', 'P'),
(146794, 'Amboy Center', 43.3688888549805, 0.756929903450883, -75.9422225952148, -1.32544182556893, 218, 40, 'PPL', 'P'),
(158676, 'Ambridge', 40.589168548584, 0.708414631819719, -80.2252807617188, -1.40019529262886, 218, 45, 'PPL', 'P'),
(172904, 'Ambridge', 46.6366691589355, 0.81396342898672, -92.0702819824219, -1.60692956383287, 218, 57, 'PPL', 'P'),
(158677, 'Ambridge Heights', 40.5916709899902, 0.708458307661596, -80.2119369506836, -1.39996239919153, 218, 45, 'PPL', 'P'),
(84648, 'Ambro (historical)', 36.2608299255371, 0.632870871706313, -83.6547164916992, -1.46005023760255, 218, 50, 'PPL', 'P'),
(18836, 'Ambrose', 31.5936107635498, 0.551412530417464, -83.0144424438477, -1.44887534735247, 218, 13, 'PPL', 'P'),
(92238, 'Ambrose', 33.690559387207, 0.588011188145446, -96.3850021362305, -1.68223563681899, 218, 51, 'PPL', 'P'),
(114402, 'Ambrose', 41.5313911437988, 0.724859518392903, -92.2333297729492, -1.60977528461568, 218, 16, 'PPL', 'P'),
(158679, 'Ambrose', 40.7724990844727, 0.711614353290421, -79.1086120605469, -1.38070574713944, 218, 45, 'PPL', 'P'),
(193346, 'Ambrose', 41.5019416809082, 0.724345528302518, -120.980278015137, -2.11150418134225, 218, 6, 'PPL', 'P'),
(197927, 'Ambrose', 48.9538917541504, 0.854406592774827, -103.482223510742, -1.80610551754714, 218, 34, 'PPL', 'P'),
(179729, 'Ambrose (historical)', 38.0352783203125, 0.663840838601872, -121.948890686035, -2.12840966162596, 218, 6, 'PPL', 'P'),
(107971, 'Ambrosia', 38.8055610656738, 0.677284808679728, -82.0527801513672, -1.43209117405641, 218, 58, 'PPL', 'P'),
(39094, 'Ambrosia (historical)', 30.6547203063965, 0.535025800624584, -91.1933288574219, -1.59162384441597, 218, 22, 'PPL', 'P'),
(188033, 'Ambrosia Lake', 35.4188919067383, 0.618176281180555, -107.821113586426, -1.88183343524992, 218, 38, 'PPL', 'P'),
(193012, 'Ambrosia Mill', 33.7997207641602, 0.589916413589289, -113.181671142578, -1.97539281434744, 218, 5, 'PPL', 'P'),
(99394, 'Amburg', 37.5536117553711, 0.655434171146873, -76.3586120605469, -1.33270919270959, 218, 53, 'PPL', 'P'),
(34554, 'Amburgey', 37.2613906860352, 0.650333951343262, -82.9986114501953, -1.44859904438937, 218, 21, 'PPL', 'P'),
(44358, 'Amcelle', 39.607780456543, 0.691286178373738, -78.815559387207, -1.37559101310789, 218, 25, 'PPL', 'P'),
(44353, 'Amcelle Acres', 39.5888900756836, 0.690956479030786, -78.8494415283203, -1.37618236802794, 218, 25, 'PPL', 'P'),
(1, 'Amchitka', 51.5672187805176, 0.900017753816287, 178.877502441406, 3.12200137534673, 218, 1, 'PPL', 'P'),
(107972, 'Ameagle', 37.9497184753418, 0.662347537599637, -81.4188919067383, -1.42102773709795, 218, 58, 'PPL', 'P'),
(53176, 'Ameera (historical)', 36.7669410705566, 0.641704177567942, -93.0947189331055, -1.62480936160139, 218, 29, 'PPL', 'P'),
(39095, 'Amehe (historical)', 30.0013904571533, 0.523623043653732, -91.0758285522461, -1.58957307721855, 218, 22, 'PPL', 'P'),
(44354, 'Amelano Manor', 39.4752807617188, 0.688973622441167, -77.4302825927734, -1.35141337199355, 218, 25, 'PPL', 'P'),
(39096, 'Amelia', 29.666109085083, 0.517771279790501, -91.101936340332, -1.59002874408107, 218, 22, 'PPL', 'P'),
(62513, 'Amelia', 36.5424995422363, 0.637786933920545, -81.2033309936523, -1.41726548942599, 218, 33, 'PPL', 'P'),
(71659, 'Amelia', 39.0283317565918, 0.681172890713189, -84.2177810668945, -1.46987756834105, 218, 41, 'PPL', 'P'),
(92239, 'Amelia', 30.0697193145752, 0.52481560718987, -94.1908264160156, -1.64394004613392, 218, 51, 'PPL', 'P'),
(107973, 'Amelia', 38.2891693115234, 0.668272072339654, -81.2961120605469, -1.41888482452681, 218, 58, 'PPL', 'P'),
(141159, 'Amelia', 42.2355613708496, 0.737149607349455, -98.9116668701172, -1.72633425551934, 218, 35, 'PPL', 'P'),
(14983, 'Amelia City', 30.5900001525879, 0.533896220848227, -81.4574966430664, -1.42170151685374, 218, 12, 'PPL', 'P'),
(99396, 'Amelia Court House', 37.3427810668945, 0.65175448146871, -77.980827331543, -1.36102219036461, 218, 53, 'PPL', 'P'),
(99397, 'Amelia Springs (historical)', 37.3313903808594, 0.651555676493336, -78.1025009155273, -1.36314579501784, 218, 53, 'PPL', 'P'),
(44355, 'Amelung Estates', 39.3019409179688, 0.685948271442837, -77.4044418334961, -1.35096236566294, 218, 25, 'PPL', 'P'),
(77783, 'Amend', 39.8727798461914, 0.695911290238878, -79.789436340332, -1.39258837244921, 218, 45, 'PPL', 'P'),
(118615, 'Amenia', 40.0219383239746, 0.698514596783458, -88.666389465332, -1.54752043202566, 218, 18, 'PPL', 'P'),
(139592, 'Amenia', 47.0050010681152, 0.820392033542062, -97.2186126708984, -1.69678488532826, 218, 34, 'PPL', 'P'),
(146796, 'Amenia', 41.8491706848145, 0.730405817679102, -73.5572204589844, -1.28381568562461, 218, 40, 'PPL', 'P'),
(146797, 'Amenia Union', 41.8244400024414, 0.729974185845428, -73.5055618286133, -1.28291407243757, 218, 40, 'PPL', 'P'),
(118616, 'Ament Corners', 41.5972213745117, 0.726008472666191, -88.4358291625977, -1.54349639561855, 218, 18, 'PPL', 'P'),
(84649, 'Amerene (historical)', 35.7658309936523, 0.624231510551069, -83.8969421386719, -1.464277872675, 218, 50, 'PPL', 'P'),
(26367, 'America', 37.1383285522461, 0.648186111924113, -89.1236114501953, -1.55550046107403, 218, 18, 'PPL', 'P'),
(74989, 'America', 33.8152809143066, 0.590187989441449, -94.5483322143555, -1.65017969940992, 218, 42, 'PPL', 'P'),
(112766, 'America', 33.7377815246582, 0.588835369923798, -87.2525024414063, -1.52284344820693, 218, 2, 'PPL', 'P'),
(122137, 'America', 40.6791687011719, 0.709985430809674, -85.7019424438477, -1.49578107099982, 218, 19, 'PPL', 'P'),
(31642, 'America City', 39.5736083984375, 0.690689763447614, -96.0316696166992, -1.6760688209988, 218, 20, 'PPL', 'P'),
(14984, 'American Beach', 30.5747203826904, 0.533629538554569, -81.4441680908203, -1.42146888973252, 218, 12, 'PPL', 'P'),
(179730, 'American Canyon', 38.1749992370605, 0.66627942863303, -122.259719848633, -2.13383465392451, 218, 6, 'PPL', 'P'),
(186335, 'American City', 39.872501373291, 0.695906429969889, -105.586669921875, -1.84283503635318, 218, 7, 'PPL', 'P'),
(189871, 'American City (historical)', 39.2700004577637, 0.685390805247657, -119.660278320313, -2.08846584054224, 218, 39, 'PPL', 'P'),
(44356, 'American Corner', 38.767219543457, 0.676615622876818, -75.8194427490234, -1.3232989129978, 218, 25, 'PPL', 'P'),
(194518, 'American Falls', 42.7861099243164, 0.746758492299543, -112.853607177734, -1.96966701800377, 218, 17, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(189872, 'American Flat (historical)', 39.2708282470703, 0.68540525289657, -119.665283203125, -2.088553192226, 218, 39, 'PPL', 'P'),
(209908, 'American Fork', 40.3769416809082, 0.704710574217582, -111.794998168945, -1.95119080530913, 218, 52, 'PPL', 'P'),
(84650, 'American Heritage', 35.1563911437988, 0.613594778578265, -84.7819366455078, -1.47972394068135, 218, 50, 'PPL', 'P'),
(179731, 'American Hill (historical)', 39.4838905334473, 0.689123891305675, -120.758331298828, -2.10763048037867, 218, 6, 'PPL', 'P'),
(206686, 'American Lake Garden Tract', 47.122501373291, 0.822442800739478, -122.534172058105, -2.13862474861918, 218, 56, 'PPL', 'P'),
(202870, 'American Plaza Condominium', 40.7663917541504, 0.711507760267791, -111.891670227051, -1.95287805101775, 218, 52, 'PPL', 'P'),
(206687, 'American River', 46.9761085510254, 0.819887763989656, -121.16056060791, -2.11465070617017, 218, 56, 'PPL', 'P'),
(202871, 'American Towers Condominium', 40.7655601501465, 0.71149324603985, -111.891670227051, -1.95287805101775, 218, 52, 'PPL', 'P'),
(13029, 'American University Park', 38.9513893127441, 0.679829991733517, -77.0902786254883, -1.34547918329458, 218, 9, 'PPL', 'P'),
(92240, 'Americana Colonia', 26.3589992523193, 0.460051324483696, -98.1389999389648, -1.71284867354945, 218, 51, 'PPL', 'P'),
(92241, 'Americana Grove Colonia', 26.2099990844727, 0.457450780968747, -98.3769989013672, -1.7170025390597, 218, 51, 'PPL', 'P'),
(92242, 'Americana Grove Number 2 Colonia', 26.2099990844727, 0.457450780968747, -98.3769989013672, -1.7170025390597, 218, 51, 'PPL', 'P'),
(18837, 'Americus', 32.0722198486328, 0.55976583478212, -84.232780456543, -1.47013935707621, 218, 13, 'PPL', 'P'),
(31643, 'Americus', 38.5069389343262, 0.672072869268388, -96.2616729736328, -1.68008313686793, 218, 20, 'PPL', 'P'),
(53177, 'Americus', 38.7802810668945, 0.676843589466129, -91.5638885498047, -1.59809133112323, 218, 29, 'PPL', 'P'),
(122138, 'Americus', 40.5258293151855, 0.707309153651227, -86.758056640625, -1.51421374101064, 218, 19, 'PPL', 'P'),
(186336, 'Americus', 38.9025001525879, 0.678976714920255, -106.165000915527, -1.85292881635875, 218, 7, 'PPL', 'P'),
(84651, 'Amersham', 36.5305595397949, 0.637578541565246, -82.6022186279297, -1.44168068450957, 218, 50, 'PPL', 'P'),
(172905, 'Amery', 45.3069381713867, 0.790755245088197, -92.3619384765625, -1.61201992994045, 218, 57, 'PPL', 'P'),
(7089, 'Ames', 33.5747184753418, 0.585989382824885, -93.2169418334961, -1.62694255363455, 218, 4, 'PPL', 'P'),
(26369, 'Ames', 38.146671295166, 0.665785012776657, -90.054443359375, -1.57174654267184, 218, 18, 'PPL', 'P'),
(31645, 'Ames', 39.5694389343262, 0.690616992570828, -97.4416732788086, -1.70067802736779, 218, 20, 'PPL', 'P'),
(74990, 'Ames', 36.2458305358887, 0.632609082971158, -98.1849975585938, -1.71365148346005, 218, 42, 'PPL', 'P'),
(92244, 'Ames', 30.0536098480225, 0.524534443957785, -94.7433319091797, -1.65358308612499, 218, 51, 'PPL', 'P'),
(107975, 'Ames', 38.086109161377, 0.664728004140004, -81.0861129760742, -1.41521964907659, 218, 58, 'PPL', 'P'),
(114404, 'Ames', 42.0347213745117, 0.733644288143666, -93.6197204589844, -1.63397236680597, 218, 16, 'PPL', 'P'),
(122139, 'Ames', 40.0333290100098, 0.698713401758832, -86.8869400024414, -1.51646318002537, 218, 19, 'PPL', 'P'),
(141160, 'Ames', 41.452220916748, 0.723477737261316, -96.6241683959961, -1.68640987551158, 218, 35, 'PPL', 'P'),
(143462, 'Ames', 43.5625, 0.76030905540003, -71.3352813720703, -1.24503553277921, 218, 36, 'PPL', 'P'),
(146799, 'Ames', 42.8375015258789, 0.747655444954682, -74.601936340332, -1.302049417502, 218, 40, 'PPL', 'P'),
(169726, 'Ames', 44.2691688537598, 0.772642753619432, -99.0844421386719, -1.72934975282164, 218, 49, 'PPL', 'P'),
(186337, 'Ames', 37.8647193908691, 0.660864023714408, -107.88166809082, -1.88289031072852, 218, 7, 'PPL', 'P'),
(99399, 'Ames Cove', 36.8611106872559, 0.643347747434685, -76.4897232055664, -1.33499751387625, 218, 53, 'PPL', 'P'),
(107976, 'Ames Heights', 38.0852813720703, 0.664713556491091, -81.0758285522461, -1.41504015201912, 218, 58, 'PPL', 'P'),
(171686, 'Ames Hill', 42.8547210693359, 0.747955982683697, -72.6880569458008, -1.26864592058136, 218, 55, 'PPL', 'P'),
(206688, 'Ames Lake', 47.6330604553223, 0.831353737746883, -121.964996337891, -2.12869075827902, 218, 56, 'PPL', 'P'),
(124106, 'Amesbury', 42.8583297729492, 0.748018966443478, -70.9305572509766, -1.23797176430388, 218, 23, 'PPL', 'P'),
(179733, 'Amesti', 36.9636116027832, 0.645136725896945, -121.778060913086, -2.12542811962756, 218, 6, 'PPL', 'P'),
(71661, 'Amesville', 39.4005584716797, 0.687669472455355, -81.9558334350586, -1.43039913465783, 218, 41, 'PPL', 'P'),
(158681, 'Amesville', 40.8308296203613, 0.712632413196131, -78.4005584716797, -1.36834788073314, 218, 45, 'PPL', 'P'),
(177439, 'Amesville', 41.9627799987793, 0.732388674268721, -73.3763885498047, -1.28065957341676, 218, 8, 'PPL', 'P'),
(62514, 'Amherst', 35.7988891601563, 0.624808484401234, -81.5963897705078, -1.42412565923598, 218, 33, 'PPL', 'P'),
(84652, 'Amherst', 35.958610534668, 0.627596148272275, -84.0316696166992, -1.46662931075948, 218, 50, 'PPL', 'P'),
(99400, 'Amherst', 37.5849990844727, 0.655981983383102, -79.0516662597656, -1.37971185542062, 218, 53, 'PPL', 'P'),
(124108, 'Amherst', 42.3802795410156, 0.739675415906314, -72.5236129760742, -1.26577583187458, 218, 23, 'PPL', 'P'),
(126756, 'Amherst', 44.8333282470703, 0.782489192538755, -68.3647232055664, -1.19318951215171, 218, 26, 'PPL', 'P'),
(133935, 'Amherst', 43.6086082458496, 0.761113796102424, -91.8947219848633, -1.60386546384068, 218, 28, 'PPL', 'P'),
(141161, 'Amherst', 40.7688903808594, 0.711551369530641, -99.2694396972656, -1.73257856932725, 218, 35, 'PPL', 'P'),
(143463, 'Amherst', 42.8613891601563, 0.748072362823334, -71.6258316040039, -1.25010659096888, 218, 36, 'PPL', 'P'),
(146800, 'Amherst', 42.978328704834, 0.750113342903743, -78.8000030517578, -1.37531950383475, 218, 40, 'PPL', 'P'),
(154060, 'Amherst', 41.3977813720703, 0.722527587963403, -82.2225036621094, -1.4350534081369, 218, 41, 'PPL', 'P'),
(169727, 'Amherst', 45.7380599975586, 0.798279740432107, -97.9208297729492, -1.70904088582286, 218, 49, 'PPL', 'P'),
(172907, 'Amherst', 44.4508285522461, 0.775813313476199, -89.2847213745117, -1.55831235971099, 218, 57, 'PPL', 'P'),
(191070, 'Amherst', 34.0102806091309, 0.593591376156516, -102.415000915527, -1.78747896940896, 218, 51, 'PPL', 'P'),
(194086, 'Amherst', 40.6827812194824, 0.710048481148482, -102.165557861328, -1.78312536681695, 218, 7, 'PPL', 'P'),
(195869, 'Amherst', 47.1497192382813, 0.822917842098921, -109.624168395996, -1.91330267827084, 218, 31, 'PPL', 'P'),
(124109, 'Amherst Center', 42.3752784729004, 0.739588130801587, -72.5197219848633, -1.26570792126678, 218, 23, 'PPL', 'P'),
(154061, 'Amherst Heights', 40.8300018310547, 0.712617965547218, -81.51611328125, -1.42272457018649, 218, 41, 'PPL', 'P'),
(172908, 'Amherst Junction', 44.4688911437988, 0.776128565170237, -89.3125, -1.55879718818744, 218, 57, 'PPL', 'P'),
(107977, 'Amherstdale', 37.7852783203125, 0.659477515471886, -81.809440612793, -1.427844097908, 218, 58, 'PPL', 'P'),
(18838, 'Amicalola', 34.5547218322754, 0.603093668083973, -84.2525024414063, -1.4704835706471, 218, 13, 'PPL', 'P'),
(99402, 'Amicus', 38.2555618286133, 0.667685511109564, -78.4802780151367, -1.36973924924466, 218, 53, 'PPL', 'P'),
(197930, 'Amidon', 46.4822196960449, 0.811267777331342, -103.321388244629, -1.80329841260014, 218, 34, 'PPL', 'P'),
(107978, 'Amigo', 37.5963897705078, 0.656180788358477, -81.3211135864258, -1.41932118347142, 218, 58, 'PPL', 'P'),
(92246, 'Amigo Park Colonia Number 1', 26.238000869751, 0.45793950431829, -98.265998840332, -1.71506522252472, 218, 51, 'PPL', 'P'),
(92247, 'Amigo Park Number 3 Colonia', 26.2390003204346, 0.45795694802343, -98.2679977416992, -1.715100109935, 218, 51, 'PPL', 'P'),
(133937, 'Amiret', 44.3166694641113, 0.773471795666774, -95.6966705322266, -1.67022198398359, 218, 28, 'PPL', 'P'),
(84653, 'Amis', 36.4183311462402, 0.635619786583493, -82.9524993896484, -1.44779423710795, 218, 50, 'PPL', 'P'),
(114406, 'Amish', 41.535831451416, 0.724937016380625, -91.7863922119141, -1.60197475262478, 218, 16, 'PPL', 'P'),
(99403, 'Amissville', 38.6713905334473, 0.674943091133221, -77.9958267211914, -1.36128397909976, 218, 53, 'PPL', 'P'),
(188034, 'Amistad', 35.9188919067383, 0.626902927440527, -103.153327941895, -1.80036520697553, 218, 38, 'PPL', 'P'),
(191071, 'Amistad Acres', 29.5149993896484, 0.515133918073482, -101.166938781738, -1.76569617590487, 218, 51, 'PPL', 'P'),
(191072, 'Amistad Village', 29.461109161377, 0.514193356155493, -101.028610229492, -1.76328188721866, 218, 51, 'PPL', 'P'),
(39098, 'Amite', 30.726390838623, 0.536276687388594, -90.5088882446289, -1.57967810218837, 218, 22, 'PPL', 'P'),
(7091, 'Amity', 34.264720916748, 0.598032197274223, -93.4608306884766, -1.63119921716287, 218, 4, 'PPL', 'P'),
(18839, 'Amity', 33.6758308410645, 0.587754126521226, -82.4897232055664, -1.43971726899591, 218, 13, 'PPL', 'P'),
(26370, 'Amity', 38.7763900756836, 0.676775678858332, -87.9241714477539, -1.5345662838513, 218, 18, 'PPL', 'P'),
(29094, 'Amity', 39.4261093139648, 0.688115418779889, -86.001106262207, -1.50100246463303, 218, 19, 'PPL', 'P'),
(53178, 'Amity', 39.8708305358887, 0.695877268355953, -94.4355621337891, -1.6482114902063, 218, 29, 'PPL', 'P'),
(84654, 'Amity', 35.6988906860352, 0.623063181780851, -86.0599975585938, -1.50203031165574, 218, 50, 'PPL', 'P'),
(92248, 'Amity', 32.0591697692871, 0.559538067929891, -98.8833312988281, -1.72583970650491, 218, 51, 'PPL', 'P'),
(146803, 'Amity', 41.2680587768555, 0.720263501562672, -74.4552764892578, -1.29948972022027, 218, 40, 'PPL', 'P'),
(154065, 'Amity', 40.0686111450195, 0.699329191181886, -83.2513885498047, -1.4530108370512, 218, 41, 'PPL', 'P'),
(158682, 'Amity', 40.0394401550293, 0.69882006136049, -80.2052764892578, -1.39984615220995, 218, 45, 'PPL', 'P'),
(200325, 'Amity', 45.1158294677734, 0.787419768980927, -123.206108093262, -2.15035224479545, 218, 43, 'PPL', 'P'),
(7092, 'Amity (historical)', 33.9269409179688, 0.592136824148142, -93.8786087036133, -1.63849081906946, 218, 4, 'PPL', 'P'),
(158683, 'Amity Gardens', 40.274169921875, 0.702916868644386, -75.7355575561523, -1.32183484018853, 218, 45, 'PPL', 'P'),
(146804, 'Amity Harbor', 40.663330078125, 0.709708994688524, -73.3986129760742, -1.28104746282953, 218, 40, 'PPL', 'P'),
(62515, 'Amity Hill', 35.6972198486328, 0.623034020166914, -80.7736129760742, -1.40976549516411, 218, 33, 'PPL', 'P'),
(146806, 'Amityville', 40.6788902282715, 0.709980570540685, -73.4175033569336, -1.28137716217248, 218, 40, 'PPL', 'P'),
(158686, 'Amityville', 40.2999992370605, 0.703367675237909, -75.7366714477539, -1.32185428126449, 218, 45, 'PPL', 'P'),
(77784, 'Amleyn Gardens', 39.8911094665527, 0.696231202464824, -76.6486129760742, -1.33777066351934, 218, 45, 'PPL', 'P'),
(154066, 'Amlin', 40.0769386291504, 0.699474533198377, -83.1811065673828, -1.45178418505311, 218, 41, 'PPL', 'P'),
(107979, 'Amma', 38.5686111450195, 0.673149252401971, -81.2658309936523, -1.41835632020849, 218, 58, 'PPL', 'P'),
(92249, 'Ammannsville', 29.788890838623, 0.519914225651147, -96.8583297729492, -1.69049676252042, 218, 51, 'PPL', 'P'),
(92250, 'Ammans Crossing', 29.8947200775146, 0.521761294314685, -98.6708297729492, -1.72213085521281, 218, 51, 'PPL', 'P'),
(44357, 'Ammendale', 39.0508308410645, 0.681565573815921, -76.8969421386719, -1.34210482503539, 218, 25, 'PPL', 'P'),
(34555, 'Ammie', 37.2663917541504, 0.65042123644799, -83.6922225952148, -1.46070484259849, 218, 21, 'PPL', 'P'),
(725, 'Ammon', 34.7999992370605, 0.607374566378221, -78.5805587768555, -1.37148947871306, 218, 33, 'PPL', 'P'),
(99404, 'Ammon', 37.211109161377, 0.649456373185054, -77.7683334350586, -1.35731347223056, 218, 53, 'PPL', 'P'),
(194519, 'Ammon', 43.4697189331055, 0.758689720299207, -111.965827941895, -1.95417234730753, 218, 17, 'PPL', 'P'),
(209271, 'Ammon', 42.6263885498047, 0.743970828428503, -105.129722595215, -1.83485980099478, 218, 59, 'PPL', 'P'),
(62516, 'Ammon Ford', 34.7924995422363, 0.607243672010644, -78.5869369506836, -1.37160079884662, 218, 33, 'PPL', 'P'),
(34556, 'Ammons', 37.9511108398438, 0.662371838944584, -86.4938888549805, -1.50960314337344, 218, 21, 'PPL', 'P'),
(172912, 'Amnicon Falls', 46.603889465332, 0.813391315405544, -91.8897171020508, -1.60377811215693, 218, 57, 'PPL', 'P'),
(29095, 'Amo', 39.688060760498, 0.692687334002256, -86.6136093139648, -1.51169265956471, 218, 19, 'PPL', 'P'),
(99406, 'Amonate', 37.1908302307129, 0.649102439076182, -81.6388931274414, -1.42486748275762, 218, 53, 'PPL', 'P'),
(133940, 'Amor', 46.4124984741211, 0.810050912450257, -95.745002746582, -1.67106554025887, 218, 28, 'PPL', 'P'),
(643, 'Amoret', 38.2552795410156, 0.667680584261548, -94.5875015258789, -1.65086333286175, 218, 29, 'PPL', 'P'),
(74991, 'Amorita', 36.9244384765625, 0.644453025866095, -98.291389465332, -1.71550837253011, 218, 42, 'PPL', 'P'),
(58458, 'Amory', 33.9841690063477, 0.593135642714976, -88.4880599975586, -1.54440799565968, 218, 30, 'PPL', 'P'),
(7094, 'Amos', 36.3658294677734, 0.634703459431424, -92.5547180175781, -1.61538456766166, 218, 4, 'PPL', 'P'),
(34557, 'Amos', 36.6525001525879, 0.639706806750383, -86.0883331298828, -1.50252486067017, 218, 21, 'PPL', 'P'),
(39099, 'Amos', 30.3394393920898, 0.529523110601235, -89.7988891601563, -1.56728628047817, 218, 22, 'PPL', 'P'),
(53179, 'Amos', 38.0158309936523, 0.663501418720941, -94.5800018310547, -1.65073243849417, 218, 29, 'PPL', 'P'),
(179734, 'Amos', 33.1180610656738, 0.57801920747255, -115.254997253418, -2.01157918144916, 218, 6, 'PPL', 'P'),
(199806, 'Amos (historical)', 41.3899993896484, 0.722391766747809, -117.808326721191, -2.05614318755001, 218, 39, 'PPL', 'P'),
(200326, 'Amos (historical)', 43.6083297729492, 0.761108935833435, -123.08332824707, -2.14820933222432, 218, 43, 'PPL', 'P'),
(18840, 'Amos Mill', 34.7174987792969, 0.605934661755843, -85.5188903808594, -1.4925862097981, 218, 13, 'PPL', 'P'),
(44359, 'Amos Mill', 39.7002792358398, 0.692900586626544, -76.5013885498047, -1.33520111254158, 218, 25, 'PPL', 'P'),
(18841, 'Amoskeag (historical)', 32.1694412231445, 0.561462667870664, -83.1561126708984, -1.45134795926655, 218, 13, 'PPL', 'P'),
(44360, 'Amoss', 39.5280609130859, 0.689894809862226, -76.4105606079102, -1.33361586590271, 218, 25, 'PPL', 'P'),
(62518, 'Amostown', 36.524169921875, 0.637467021694599, -80.054443359375, -1.3972136174724, 218, 33, 'PPL', 'P'),
(124111, 'Amostown', 42.1263885498047, 0.735244182168531, -72.6597213745117, -1.26815137156693, 218, 23, 'PPL', 'P'),
(139596, 'Amourdale', 48.8713912963867, 0.852966688152448, -99.3724975585938, -1.73437726832749, 218, 34, 'PPL', 'P'),
(154067, 'Amoy', 40.8286094665527, 0.712593664202271, -82.5533294677734, -1.4408274076963, 218, 41, 'PPL', 'P'),
(144745, 'Ampere', 40.7666702270508, 0.71151262053678, -74.1952819824219, -1.29495196003889, 218, 37, 'PPL', 'P'),
(179735, 'Ampere', 38.1025009155273, 0.665014094220106, -121.242218017578, -2.11607589682753, 218, 6, 'PPL', 'P'),
(92252, 'Amphion', 28.9983291625977, 0.506116321464419, -98.6352767944336, -1.72151033867882, 218, 51, 'PPL', 'P'),
(193015, 'Amphitheater', 32.2722206115723, 0.563256506601914, -110.971672058105, -1.93682105385733, 218, 5, 'PPL', 'P'),
(99407, 'Ampt Hill', 37.4516716003418, 0.653654979801618, -77.4449996948242, -1.35167023388069, 218, 53, 'PPL', 'P'),
(84655, 'Amqui', 36.2761116027832, 0.633137587289484, -86.7091674804688, -1.51336046419738, 218, 50, 'PPL', 'P'),
(124112, 'Amrita', 41.6597213745117, 0.727099303448687, -70.6194381713867, -1.23254171199926, 218, 23, 'PPL', 'P'),
(158687, 'Amsbry', 40.5363883972168, 0.70749344439866, -78.5563888549805, -1.37106763399639, 218, 45, 'PPL', 'P'),
(194521, 'Amsco', 43.764720916748, 0.763838476213685, -116.648330688477, -2.03589743746906, 218, 17, 'PPL', 'P'),
(113229, 'Amsden', 41.2161102294922, 0.719356828369554, -83.32861328125, -1.45435866287889, 218, 41, 'PPL', 'P'),
(129523, 'Amsden', 43.1705589294434, 0.753468393245025, -85.1236114501953, -1.48568729099425, 218, 27, 'PPL', 'P'),
(171687, 'Amsden', 43.4058303833008, 0.757574654750791, -72.5063934326172, -1.26547529414556, 218, 55, 'PPL', 'P'),
(18842, 'Amsterdam', 30.7272205352783, 0.536291168327021, -84.4358291625977, -1.47368322553878, 218, 13, 'PPL', 'P'),
(53185, 'Amsterdam', 38.3497200012207, 0.669328881239225, -94.5888900756836, -1.65088756762767, 218, 29, 'PPL', 'P'),
(99409, 'Amsterdam', 37.4272193908691, 0.653228208236933, -79.9063873291016, -1.3946295522667, 218, 53, 'PPL', 'P'),
(144746, 'Amsterdam', 40.5875015258789, 0.708385536784809, -75.1588897705078, -1.31177008863885, 218, 37, 'PPL', 'P'),
(146807, 'Amsterdam', 42.9386100769043, 0.749420122071996, -74.188606262207, -1.2948354467412, 218, 40, 'PPL', 'P'),
(154068, 'Amsterdam', 40.4736099243164, 0.706397753347174, -80.9230575561523, -1.41237379513573, 218, 41, 'PPL', 'P'),
(158688, 'Amsterdam', 41.1338882446289, 0.717921784016165, -80.1338882446289, -1.39860019229395, 218, 45, 'PPL', 'P'),
(179736, 'Amsterdam', 37.4302787780762, 0.653281604616789, -120.541107177734, -2.10383920425083, 218, 6, 'PPL', 'P'),
(194520, 'Amsterdam', 42.2958297729492, 0.738201489401009, -114.583892822266, -1.99986619950083, 218, 17, 'PPL', 'P'),
(195870, 'Amsterdam', 45.7580604553223, 0.798628814271989, -111.31916809082, -1.94288600376582, 218, 31, 'PPL', 'P'),
(177440, 'Amston', 41.6252784729004, 0.726498161411629, -72.3436126708984, -1.26263423389467, 218, 8, 'PPL', 'P'),
(114409, 'Amund', 43.473331451416, 0.758752770638015, -93.7930603027344, -1.6369977178043, 218, 16, 'PPL', 'P'),
(144747, 'Amwell', 40.4313888549805, 0.705660856673549, -74.7525024414063, -1.30467729170764, 218, 37, 'PPL', 'P'),
(7096, 'Amy', 33.7319412231445, 0.588733437433075, -92.8152770996094, -1.61993218153908, 218, 4, 'PPL', 'P'),
(53181, 'Amy', 36.6055603027344, 0.638887551820047, -92.0036087036133, -1.60576589559456, 218, 29, 'PPL', 'P'),
(58459, 'Amy', 31.7772197723389, 0.554617112157156, -89.2583312988281, -1.55785176600046, 218, 30, 'PPL', 'P'),
(187579, 'Amy', 38.4819412231445, 0.671636576902806, -100.601387023926, -1.7558254356406, 218, 20, 'PPL', 'P'),
(44361, 'Amyclae Estates', 39.5497207641602, 0.690272845578963, -76.3222198486328, -1.33207402878961, 218, 25, 'PPL', 'P'),
(44362, 'Amys Acres', 38.4594383239746, 0.671243827221047, -76.8974990844727, -1.34211454557337, 218, 25, 'PPL', 'P'),
(39100, 'Anabel', 32.2930603027344, 0.563620227827792, -92.2508316040039, -1.61008074919271, 218, 22, 'PPL', 'P'),
(53182, 'Anabel', 39.7458305358887, 0.69369560679096, -92.3330612182617, -1.61151592670415, 218, 29, 'PPL', 'P'),
(191073, 'Anacacho', 29.1908302307129, 0.509476098916636, -100.300277709961, -1.7505700867035, 218, 51, 'PPL', 'P'),
(172914, 'Anacker', 43.625560760498, 0.761409673299532, -89.4436111450195, -1.56108550935409, 218, 57, 'PPL', 'P'),
(39101, 'Anacoco', 31.2519397735596, 0.545449246683586, -93.3411102294922, -1.6291097009716, 218, 22, 'PPL', 'P'),
(53183, 'Anaconda', 38.3016700744629, 0.668490251811959, -91.0405578613281, -1.58895748753258, 218, 29, 'PPL', 'P'),
(195871, 'Anaconda', 46.1286087036133, 0.805096101242165, -112.941390991211, -1.97119913457889, 218, 31, 'PPL', 'P'),
(186338, 'Anaconda (historical)', 38.7319412231445, 0.675999900032792, -108.162498474121, -1.88779172555676, 218, 7, 'PPL', 'P'),
(195872, 'Anaconda Trailer Court', 46.1458282470703, 0.80539663897118, -112.985557556152, -1.97196998655642, 218, 31, 'PPL', 'P'),
(206689, 'Anacortes', 48.5127792358398, 0.846707726958544, -122.611389160156, -2.13997244128881, 218, 56, 'PPL', 'P'),
(206690, 'Anacortes Crossing', 48.7833290100098, 0.851429711308336, -120.82861328125, -2.10885713237676, 218, 56, 'PPL', 'P'),
(13030, 'Anacostia', 38.8663902282715, 0.678346477848288, -76.9841690063477, -1.34362722107254, 218, 9, 'PPL', 'P'),
(92253, 'Anacua Colonia', 26.3859996795654, 0.460522570838586, -98.9199981689453, -1.72647966411486, 218, 51, 'PPL', 'P'),
(195873, 'Anad (historical)', 47.2275009155273, 0.824275388464588, -107.332221984863, -1.87330066711731, 218, 31, 'PPL', 'P'),
(74995, 'Anadarko', 35.0724983215332, 0.612130572610939, -98.2433319091797, -1.71466960994479, 218, 42, 'PPL', 'P'),
(92254, 'Anadarko', 31.9280605316162, 0.557249780052754, -94.876106262207, -1.65590043574752, 218, 51, 'PPL', 'P'),
(211669, 'Anaehoomalu', 19.9169406890869, 0.347616191948995, -155.890274047852, -2.72079855397128, 218, 15, 'PPL', 'P'),
(179737, 'Anaheim', 33.8352813720703, 0.590537063281331, -117.913612365723, -2.05798076870216, 218, 6, 'PPL', 'P'),
(179738, 'Anaheim Hills', 33.8444404602051, 0.590696919525764, -117.776390075684, -2.05558578793385, 218, 6, 'PPL', 'P'),
(211670, 'Anahola', 22.1452808380127, 0.386508064402131, -159.315567016602, -2.78058119412138, 218, 15, 'PPL', 'P'),
(92255, 'Anahuac', 29.7727794647217, 0.519633029129548, -94.682502746582, -1.65252141695643, 218, 51, 'PPL', 'P'),
(212277, 'Anaktuvuk Pass', 68.1433334350586, 1.18932553172611, -151.735824584961, -2.64828973223613, 218, 1, 'PPL', 'P'),
(188035, 'Analco (historical)', 35.6833305358887, 0.62279160592869, -105.943061828613, -1.84905524855323, 218, 38, 'PPL', 'P'),
(158690, 'Analomink', 41.0511093139648, 0.716477019124797, -75.220832824707, -1.31285119888336, 218, 45, 'PPL', 'P'),
(197935, 'Anamoose', 47.8824996948242, 0.835707273759863, -100.240829467773, -1.7495325191428, 218, 34, 'PPL', 'P'),
(114410, 'Anamosa', 42.1083297729492, 0.73492899705352, -91.2850036621094, -1.59322387159889, 218, 16, 'PPL', 'P'),
(141162, 'Anan', 40.4666709899902, 0.706276646096603, -98.1838912963867, -1.71363217554215, 218, 35, 'PPL', 'P'),
(39102, 'Anandale', 31.2549991607666, 0.545502643063442, -92.4538879394531, -1.61362475081333, 218, 22, 'PPL', 'P'),
(18843, 'Anandale (historical)', 34.6327781677246, 0.604456008139603, -83.478889465332, -1.45698147707845, 218, 13, 'PPL', 'P'),
(188036, 'Anapra', 31.7841701507568, 0.554738419144809, -106.563331604004, -1.8598809983844, 218, 38, 'PPL', 'P'),
(92256, 'Anaqua Addition Colonia', 26.1620006561279, 0.456613050358349, -98.0149993896484, -1.7106844556896, 218, 51, 'PPL', 'P'),
(146810, 'Anaquassacook', 43.0747184753418, 0.751795661764346, -73.3127822875977, -1.27954943471636, 218, 40, 'PPL', 'P'),
(92257, 'Anarene', 33.4850006103516, 0.584423510682946, -98.6658325195313, -1.72204363668711, 218, 51, 'PPL', 'P'),
(84656, 'Anark', 35.9047203063965, 0.626655586354286, -88.4008331298828, -1.54288559962254, 218, 50, 'PPL', 'P'),
(188037, 'Anasazi Trails', 35.3163909912109, 0.616387302718295, -106.511940002441, -1.85898404572926, 218, 38, 'PPL', 'P'),
(14985, 'Anastasia', 29.8875007629395, 0.521635293505611, -81.2897186279297, -1.41877323807714, 218, 12, 'PPL', 'P'),
(206691, 'Anatone', 46.1349983215332, 0.805207621112812, -117.131393432617, -2.04432847284803, 218, 56, 'PPL', 'P'),
(107982, 'Anawalt', 37.3358306884766, 0.651633174481057, -81.4366683959961, -1.42133799536494, 218, 58, 'PPL', 'P'),
(195874, 'Anceney', 45.648609161377, 0.796718528822075, -111.353889465332, -1.94349200607187, 218, 31, 'PPL', 'P'),
(177707, 'Ancho', 33.9377784729004, 0.592325975164565, -105.739166259766, -1.84549659954661, 218, 38, 'PPL', 'P'),
(39103, 'Anchor', 30.6833305358887, 0.535525143328974, -91.3550033569336, -1.59444559674896, 218, 22, 'PPL', 'P'),
(58460, 'Anchor', 33.8266716003418, 0.590386794416824, -89.0380630493164, -1.55400735980887, 218, 30, 'PPL', 'P'),
(74992, 'Anchor', 35.8355598449707, 0.625448508590208, -95.4027786254883, -1.66509260256604, 218, 42, 'PPL', 'P'),
(107980, 'Anchor', 37.996940612793, 0.663171719377989, -81.915283203125, -1.42969139959814, 218, 58, 'PPL', 'P'),
(118619, 'Anchor', 40.5680618286133, 0.708046250061933, -88.5355606079102, -1.54523703770702, 218, 18, 'PPL', 'P'),
(158691, 'Anchor', 40.1372184753418, 0.700526614987013, -76.581672668457, -1.33660233474913, 218, 45, 'PPL', 'P'),
(188038, 'Anchor (historical)', 36.7627792358398, 0.64163153984921, -105.338890075684, -1.83851046221706, 218, 38, 'PPL', 'P'),
(200327, 'Anchor (historical)', 42.8486099243164, 0.74784932308204, -123.163887023926, -2.14961534812183, 218, 43, 'PPL', 'P'),
(179742, 'Anchor Bay', 38.8027801513672, 0.677236272568861, -123.576667785645, -2.15681973150271, 218, 6, 'PPL', 'P'),
(129524, 'Anchor Bay Gardens', 42.6427803039551, 0.744256918508604, -82.8125, -1.4453507868078, 218, 27, 'PPL', 'P'),
(129525, 'Anchor Bay Harbor', 42.6552810668945, 0.744475097980909, -82.7991714477539, -1.44511815968659, 218, 27, 'PPL', 'P'),
(129526, 'Anchor Bay Shores', 42.6355590820313, 0.744130884410016, -82.8166732788086, -1.44542362426362, 218, 27, 'PPL', 'P'),
(39104, 'Anchor Landing', 31.8497200012207, 0.555882479859594, -91.5697174072266, -1.59819306387687, 218, 22, 'PPL', 'P'),
(84657, 'Anchor Mill', 35.5380592346191, 0.62025614341288, -86.533332824707, -1.51029157051522, 218, 50, 'PPL', 'P'),
(212279, 'Anchor Point', 59.776668548584, 1.04329968204613, -151.831390380859, -2.64995767002684, 218, 1, 'PPL', 'P'),
(34559, 'Anchorage', 38.2666702270508, 0.667879389236922, -85.5330581665039, -1.49283348430532, 218, 21, 'PPL', 'P'),
(39105, 'Anchorage', 30.4825000762939, 0.532019990570752, -91.2102813720703, -1.59191972161308, 218, 22, 'PPL', 'P'),
(44364, 'Anchorage', 38.7955589294434, 0.677110238470273, -76.1386108398438, -1.32886944704992, 218, 25, 'PPL', 'P'),
(58461, 'Anchorage', 32.9313888549805, 0.574761162773975, -90.6141662597656, -1.58151555018247, 218, 30, 'PPL', 'P'),
(92258, 'Anchorage', 29.0672206878662, 0.507318705407076, -98.7055587768555, -1.72273699067691, 218, 51, 'PPL', 'P'),
(144748, 'Anchorage', 40.0013885498047, 0.698155935563652, -74.1430587768555, -1.29404049315581, 218, 37, 'PPL', 'P'),
(202875, 'Anchorage', 41.0880584716797, 0.71712190358276, -112.023330688477, -1.95517595956432, 218, 52, 'PPL', 'P'),
(212278, 'Anchorage', 61.2180595397949, 1.06845670065135, -149.900283813477, -2.61625350221913, 218, 1, 'PPL', 'P'),
(172915, 'Anchorage (historical)', 44.2686080932617, 0.772632966502426, -91.7569427490234, -1.6014607625344, 218, 57, 'PPL', 'P'),
(44365, 'Anchorage Anchors', 38.3172187805176, 0.668761627927038, -76.9052810668945, -1.34225036678897, 218, 25, 'PPL', 'P'),
(44366, 'Anchorage Park Mobile Home Park', 38.5086097717285, 0.672102030882325, -76.6624984741211, -1.33801301117854, 218, 25, 'PPL', 'P'),
(129527, 'Anchorville', 42.6911087036133, 0.74510040820486, -82.688606262207, -1.44318843316071, 218, 27, 'PPL', 'P'),
(31646, 'Anchorway', 38.3488883972168, 0.669314367011284, -98.8158264160156, -1.72466152403866, 218, 20, 'PPL', 'P'),
(44367, 'Ancient Oak', 39.1116714477539, 0.682627442721563, -77.2708282470703, -1.34863036865442, 218, 25, 'PPL', 'P'),
(44368, 'Ancient Oak North', 39.1227798461914, 0.682821320848921, -77.2724990844727, -1.34865953026835, 218, 25, 'PPL', 'P'),
(44369, 'Ancient Oak West', 39.1080589294434, 0.682564392382755, -77.2786102294922, -1.34876618987001, 218, 25, 'PPL', 'P'),
(44370, 'Ancient Oaks', 38.1699981689453, 0.666192143528302, -76.4124984741211, -1.33364968804856, 218, 25, 'PPL', 'P'),
(158692, 'Ancient Oaks', 40.5472183227539, 0.707682462257028, -75.5897216796875, -1.31928952397669, 218, 45, 'PPL', 'P'),
(14986, 'Anclote', 28.1758308410645, 0.491761017661538, -82.7808303833008, -1.44479804772356, 218, 12, 'PPL', 'P'),
(34558, 'Anco', 37.2497215270996, 0.650130286098898, -83.054443359375, -1.44957349503223, 218, 21, 'PPL', 'P'),
(188039, 'Ancon', 35.7152786254883, 0.623349205281925, -104.425003051758, -1.8225601246583, 218, 38, 'PPL', 'P'),
(118622, 'Ancona', 41.0405616760254, 0.716292928114445, -88.8724975585938, -1.55111769686808, 218, 18, 'PPL', 'P'),
(188040, 'Ancones', 36.4238891601563, 0.635716792226199, -106.0625, -1.85113983789649, 218, 38, 'PPL', 'P'),
(71665, 'Ancor', 39.1372184753418, 0.68307332246707, -84.3177795410156, -1.47162287096144, 218, 41, 'PPL', 'P'),
(70462, 'Ancora', 39.6944389343262, 0.692798654135821, -74.841667175293, -1.30623350989063, 218, 37, 'PPL', 'P'),
(146811, 'Ancram', 42.0505599975586, 0.733920724264816, -73.6366729736328, -1.28520239360422, 218, 40, 'PPL', 'P'),
(146813, 'Ancramdale', 42.0180587768555, 0.733353470952629, -73.591667175293, -1.2844168942407, 218, 40, 'PPL', 'P'),
(31647, 'Andale', 37.7905616760254, 0.65956972742463, -97.6291732788086, -1.70395051971528, 218, 20, 'PPL', 'P'),
(14987, 'Andalusia', 29.499719619751, 0.514867235779824, -81.4850006103516, -1.42218155164022, 218, 12, 'PPL', 'P'),
(112767, 'Andalusia', 31.3083305358887, 0.546433451153938, -86.4833297729492, -1.509418852626, 218, 2, 'PPL', 'P'),
(118623, 'Andalusia', 41.4391708374023, 0.723249970409087, -90.7174987792969, -1.58331904287267, 218, 18, 'PPL', 'P'),
(158693, 'Andalusia', 40.0694389343262, 0.6993436388308, -74.9716720581055, -1.30850252313937, 218, 45, 'PPL', 'P'),
(193016, 'Andalusia', 33.5694389343262, 0.585897237451168, -111.869438171387, -1.95249002844692, 218, 5, 'PPL', 'P'),
(99411, 'Anden at The Woods', 38.5855598449707, 0.673445063020052, -77.3105621337891, -1.34932385580227, 218, 53, 'PPL', 'P'),
(112577, 'Ander', 28.8575000762939, 0.503658390225844, -97.3419418334961, -1.69893738527931, 218, 51, 'PPL', 'P'),
(7099, 'Anderson', 34.9122200012207, 0.60933318820192, -94.1213912963867, -1.64272817467988, 218, 4, 'PPL', 'P'),
(26372, 'Anderson', 39.3438911437988, 0.686680441005527, -89.8450012207031, -1.56809108775959, 218, 18, 'PPL', 'P'),
(34561, 'Anderson', 37.0180587768555, 0.646087008352913, -86.7997207641602, -1.51494091714628, 218, 21, 'PPL', 'P'),
(39106, 'Anderson', 32.2669410705566, 0.563164361228197, -93.1763916015625, -1.62623481857486, 218, 22, 'PPL', 'P'),
(53184, 'Anderson', 36.6505584716797, 0.639672918025512, -94.4433288574219, -1.64834704510579, 218, 29, 'PPL', 'P'),
(58462, 'Anderson', 32.5591697692871, 0.568264714189863, -90.245002746582, -1.57507243139918, 218, 30, 'PPL', 'P'),
(62517, 'Anderson', 36.2669410705566, 0.632977531307971, -79.3455581665039, -1.38484123683817, 218, 33, 'PPL', 'P'),
(74994, 'Anderson', 35.0872192382813, 0.612387501077105, -96.9841690063477, -1.6926930714714, 218, 42, 'PPL', 'P'),
(79521, 'Anderson', 34.5033302307129, 0.602196715428835, -82.6502838134766, -1.44251958025294, 218, 48, 'PPL', 'P'),
(84661, 'Anderson', 36.5402793884277, 0.637748184926684, -82.3213882446289, -1.43677926968133, 218, 50, 'PPL', 'P'),
(92259, 'Anderson', 30.4869403839111, 0.532097488558473, -95.9866714477539, -1.67528345479334, 218, 51, 'PPL', 'P'),
(107981, 'Anderson', 39.3899993896484, 0.687485181707922, -79.7197189331055, -1.39137157414715, 218, 58, 'PPL', 'P'),
(112769, 'Anderson', 34.9283294677734, 0.609614351434005, -87.2663879394531, -1.52308579586613, 218, 2, 'PPL', 'P'),
(114411, 'Anderson', 40.8013916015625, 0.712118622842828, -95.603889465332, -1.66860264888277, 218, 16, 'PPL', 'P'),
(122140, 'Anderson', 40.105281829834, 0.699969215370859, -85.6802825927734, -1.49540303528308, 218, 19, 'PPL', 'P'),
(129528, 'Anderson', 42.4708290100098, 0.741255802276194, -84.0061111450195, -1.46618323127689, 218, 27, 'PPL', 'P'),
(144749, 'Anderson', 40.7705612182617, 0.711580531144577, -74.9194412231445, -1.30759092309824, 218, 37, 'PPL', 'P'),
(146814, 'Anderson', 41.9030609130859, 0.731346379597091, -74.7072219848633, -1.30388699865416, 218, 40, 'PPL', 'P'),
(158695, 'Anderson', 41.0583305358887, 0.716603053223385, -78.6608276367188, -1.37289043460449, 218, 45, 'PPL', 'P'),
(172916, 'Anderson', 42.7169418334961, 0.74555128137741, -89.0166702270508, -1.55363398462404, 218, 57, 'PPL', 'P'),
(177395, 'Anderson', 41.3888893127441, 0.722372392250878, -82.529167175293, -1.44040569613769, 218, 41, 'PPL', 'P'),
(193347, 'Anderson', 40.4483299255371, 0.705956534133575, -122.296669006348, -2.13447953838247, 218, 6, 'PPL', 'P'),
(194522, 'Anderson', 42.0205612182617, 0.733397146794507, -111.956108093262, -1.95400270394609, 218, 17, 'PPL', 'P'),
(195875, 'Anderson', 48.3455581665039, 0.843789168719926, -104.931938171387, -1.83140781158982, 218, 31, 'PPL', 'P'),
(212280, 'Anderson', 64.3441696166992, 1.1230176142731, -149.186935424805, -2.60380322412301, 218, 1, 'PPL', 'P'),
(7097, 'Anderson (historical)', 34.1597213745117, 0.596199609549112, -93.5041732788086, -1.63195568807051, 218, 4, 'PPL', 'P'),
(154069, 'Anderson (historical)', 41.7388916015625, 0.728481084580275, -80.6224975585938, -1.40712803357855, 218, 41, 'PPL', 'P'),
(199807, 'Anderson (historical)', 41.4672203063965, 0.723739525996471, -116.101112365723, -2.02634667600976, 218, 39, 'PPL', 'P'),
(18844, 'Anderson Acres', 33.538890838623, 0.585364072600934, -83.8494415283203, -1.46344883062766, 218, 13, 'PPL', 'P'),
(129529, 'Anderson Bayview', 44.2366714477539, 0.772075566886272, -83.545280456543, -1.45814021846875, 218, 27, 'PPL', 'P'),
(18845, 'Anderson City', 31.3713893890381, 0.547534035763927, -83.8547210693359, -1.46354097600137, 218, 13, 'PPL', 'P'),
(34562, 'Anderson City', 38.0072212219238, 0.663351149856433, -85.0258331298828, -1.48398073736773, 218, 21, 'PPL', 'P'),
(133942, 'Anderson Court', 44.7708282470703, 0.781398361756258, -94.1413879394531, -1.64307718194074, 218, 28, 'PPL', 'P'),
(62519, 'Anderson Creek', 35.2833290100098, 0.615810262289102, -78.9172210693359, -1.37736534418415, 218, 33, 'PPL', 'P'),
(158696, 'Anderson Creek', 41.1458282470703, 0.718130176371464, -78.5469436645508, -1.37090278432491, 218, 45, 'PPL', 'P'),
(13273, 'Anderson Crossroads', 38.8586082458496, 0.678210656632694, -75.3702774047852, -1.31545949885499, 218, 10, 'PPL', 'P'),
(71667, 'Anderson Ferry', 39.0780601501465, 0.682040814912446, -84.621940612793, -1.47693148312035, 218, 41, 'PPL', 'P'),
(62521, 'Anderson Heights', 35.3424987792969, 0.616842969580807, -80.1524963378906, -1.39892496478889, 218, 33, 'PPL', 'P'),
(192466, 'Anderson Junction', 37.2841682434082, 0.650731494714984, -113.304718017578, -1.97754038745048, 218, 52, 'PPL', 'P'),
(58463, 'Anderson Landing', 34.139720916748, 0.59585053570923, -90.8666687011719, -1.58592254915433, 218, 30, 'PPL', 'P'),
(18846, 'Anderson Mill', 32.2197189331055, 0.562340179449845, -81.8038864135742, -1.42774715884433, 218, 13, 'PPL', 'P'),
(92261, 'Anderson Mill', 30.454719543457, 0.531535128804789, -97.8055572509766, -1.70702900077736, 218, 51, 'PPL', 'P'),
(188041, 'Anderson Place', 34.6805610656738, 0.605289977034962, -106.348892211914, -1.85613832494646, 218, 38, 'PPL', 'P'),
(194523, 'Anderson Place', 42.2447204589844, 0.737309463593887, -114.949996948242, -2.00625592190426, 218, 17, 'PPL', 'P'),
(169728, 'Anderson Subdivision', 43.5163917541504, 0.759504314697635, -96.6247177124023, -1.6864194628915, 218, 49, 'PPL', 'P'),
(172917, 'Anderson Trailer Court', 45.4691696166992, 0.793586717959169, -91.7058334350586, -1.60056873672727, 218, 57, 'PPL', 'P'),
(7100, 'Anderson Tully', 35.485279083252, 0.619334955991822, -90.6016693115234, -1.58129743728919, 218, 4, 'PPL', 'P'),
(92262, 'Anderson Ways', 29.2605590820313, 0.510693096955775, -94.9061126708984, -1.65642414637589, 218, 51, 'PPL', 'P'),
(202876, 'Anderson West Acres', 41.2144393920898, 0.719327666755618, -112.074996948242, -1.95607770590942, 218, 52, 'PPL', 'P'),
(158697, 'Andersonburg', 40.3499984741211, 0.704240326548101, -77.4686126708984, -1.35208235805938, 218, 45, 'PPL', 'P'),
(179743, 'Andersonia', 39.9780616760254, 0.697748804812006, -123.806106567383, -2.16082419367581, 218, 6, 'PPL', 'P'),
(189873, 'Andersons (historical)', 39.4697189331055, 0.688876550219434, -119.796112060547, -2.09083658654463, 218, 39, 'PPL', 'P'),
(13274, 'Andersons Corner', 38.6986083984375, 0.675418132492664, -75.2597198486328, -1.31352990548717, 218, 10, 'PPL', 'P'),
(18847, 'Andersons Corner', 32.8766708374023, 0.573806153207072, -84.9516677856445, -1.4826863079199, 218, 13, 'PPL', 'P'),
(44371, 'Andersons Corner', 39.0569381713867, 0.681672166838552, -76.6555633544922, -1.337891970507, 218, 25, 'PPL', 'P'),
(99412, 'Andersons Corner', 37.4211082458496, 0.653121548635275, -76.8244400024414, -1.34083942404344, 218, 53, 'PPL', 'P'),
(158698, 'Andersons Corner', 41.7944412231445, 0.729450608375118, -80.0238876342773, -1.39668031946412, 218, 45, 'PPL', 'P'),
(62524, 'Andersons Crossroads', 36.3619384765625, 0.634635548823627, -77.741943359375, -1.35685287852004, 218, 33, 'PPL', 'P'),
(99413, 'Andersons Mill', 36.8819389343262, 0.64371126892348, -79.539436340332, -1.38822504931922, 218, 53, 'PPL', 'P'),
(44372, 'Andersontown', 38.8377799987793, 0.677847135143898, -75.7836074829102, -1.32267346961579, 218, 25, 'PPL', 'P'),
(158700, 'Andersontown', 40.1522216796875, 0.700788470301195, -76.9319381713867, -1.3427156210314, 218, 45, 'PPL', 'P'),
(18849, 'Andersonville', 32.1958312988281, 0.561923261581193, -84.1399993896484, -1.46852002197538, 218, 13, 'PPL', 'P'),
(71670, 'Andersonville', 39.4277801513672, 0.688144580393826, -83.0097198486328, -1.44879292251673, 218, 41, 'PPL', 'P'),
(84663, 'Andersonville', 36.1986083984375, 0.631784901192806, -84.0372161865234, -1.46672611666511, 218, 50, 'PPL', 'P'),
(99414, 'Andersonville', 37.4672203063965, 0.653926355916697, -78.5691680908203, -1.37129067373768, 218, 53, 'PPL', 'P'),
(107983, 'Andersonville', 39.7799987792969, 0.694291955138056, -80.5219421386719, -1.40537301042019, 218, 58, 'PPL', 'P'),
(122142, 'Andersonville', 40.2186088562012, 0.701947145112461, -85.4311065673828, -1.49105409322298, 218, 19, 'PPL', 'P'),
(129530, 'Andersonville', 42.7299995422363, 0.745779181387694, -83.4925003051758, -1.45721903104769, 218, 27, 'PPL', 'P'),
(194087, 'Andersonville', 40.5938911437988, 0.708497056655456, -105.056671142578, -1.8335848126229, 218, 7, 'PPL', 'P'),
(79525, 'Andersonville (historical)', 34.4472198486328, 0.601217404516985, -82.8552780151367, -1.44609740401941, 218, 48, 'PPL', 'P'),
(195876, 'Andersonville (historical)', 47.186939239502, 0.823567453667818, -109.283889770508, -1.90736369588191, 218, 31, 'PPL', 'P'),
(146815, 'Andes', 42.1886100769043, 0.736330152682038, -74.7861099243164, -1.30526385293773, 218, 40, 'PPL', 'P'),
(195877, 'Andes', 47.9555587768555, 0.836982395289793, -104.548332214355, -1.82471262460936, 218, 31, 'PPL', 'P'),
(193348, 'Andesite', 41.5325012207031, 0.724878892889834, -122.20361328125, -2.13285540959168, 218, 6, 'PPL', 'P'),
(92263, 'Andice', 30.7819404602051, 0.537246211183437, -97.851936340332, -1.70783846859068, 218, 51, 'PPL', 'P'),
(58464, 'Anding', 32.6919403076172, 0.570581997233368, -90.3977813720703, -1.57773892144062, 218, 30, 'PPL', 'P'),
(71671, 'Andis', 38.5508308410645, 0.67283892755595, -82.5233306884766, -1.440303830226, 218, 41, 'PPL', 'P'),
(202878, 'Andlor', 40.663330078125, 0.709708994688524, -111.814720153809, -1.95153501888002, 218, 52, 'PPL', 'P'),
(44373, 'Andora', 39.6847190856934, 0.692629010774383, -75.8611068725586, -1.32402608913345, 218, 25, 'PPL', 'P'),
(44374, 'Andora Acres', 39.6858291625977, 0.692648385271313, -75.8655624389648, -1.32410385343728, 218, 25, 'PPL', 'P'),
(44375, 'Andorick Acres', 39.1349983215332, 0.683034573473209, -76.6916732788086, -1.33852220757897, 218, 25, 'PPL', 'P'),
(158702, 'Andorra Woods', 40.082218170166, 0.699566678572094, -75.2666702270508, -1.31365121247482, 218, 45, 'PPL', 'P'),
(14988, 'Andover', 25.9680595397949, 0.453228139323345, -80.2130584716797, -1.39998197342554, 218, 12, 'PPL', 'P'),
(31654, 'Andover', 37.7138900756836, 0.658231555555892, -97.1361083984375, -1.69534491412685, 218, 20, 'PPL', 'P'),
(77786, 'Andover', 39.9463882446289, 0.697195999148732, -78.0841674804688, -1.36282581621286, 218, 45, 'PPL', 'P'),
(99415, 'Andover', 36.9236106872559, 0.644438578217181, -82.7966690063477, -1.44507448384471, 218, 53, 'PPL', 'P'),
(113024, 'Andover', 41.2938919067383, 0.720714374735222, -90.2919387817383, -1.57589161975049, 218, 18, 'PPL', 'P'),
(114413, 'Andover', 41.9791717529297, 0.732674764348823, -90.2516708374023, -1.57518881153882, 218, 16, 'PPL', 'P'),
(124113, 'Andover', 42.6583290100098, 0.744528294623684, -71.1374969482422, -1.24158354337424, 218, 23, 'PPL', 'P'),
(126759, 'Andover', 44.6355590820313, 0.779037469449903, -70.7516708374023, -1.23484960739992, 218, 26, 'PPL', 'P'),
(133943, 'Andover', 45.2333297729492, 0.789470536178343, -93.2911071777344, -1.62823698308238, 218, 28, 'PPL', 'P'),
(139010, 'Andover', 40.564998626709, 0.70799278710305, -93.8949966430664, -1.63877684257053, 218, 29, 'PPL', 'P'),
(143465, 'Andover', 43.436939239502, 0.758117606718031, -71.8238906860352, -1.2535633740638, 218, 36, 'PPL', 'P'),
(144750, 'Andover', 40.9858283996582, 0.715337652231434, -74.7425003051758, -1.30450272149818, 218, 37, 'PPL', 'P'),
(146817, 'Andover', 42.1563911437988, 0.735767826217868, -77.7958297729492, -1.357793373859, 218, 40, 'PPL', 'P'),
(154071, 'Andover', 41.6066703796387, 0.726173388916694, -80.5725021362305, -1.40625544884739, 218, 41, 'PPL', 'P'),
(169729, 'Andover', 45.4102783203125, 0.792558870936453, -97.9022216796875, -1.70871611332792, 218, 49, 'PPL', 'P'),
(171688, 'Andover', 43.2772216796875, 0.755330009426018, -72.6972198486328, -1.26880584340482, 218, 55, 'PPL', 'P'),
(177442, 'Andover', 41.7372207641602, 0.728451922966338, -72.3708267211914, -1.26310920867508, 218, 8, 'PPL', 'P'),
(179744, 'Andover', 39.3105583190918, 0.6860986734654, -120.246109008789, -2.09869051491538, 218, 6, 'PPL', 'P'),
(79526, 'Andover (historical)', 35.0791702270508, 0.612247019329603, -82.2058334350586, -1.43476245778781, 218, 48, 'PPL', 'P'),
(179745, 'Andover (historical)', 39.3019409179688, 0.685948271442837, -120.256393432617, -2.09887001197286, 218, 6, 'PPL', 'P'),
(44377, 'Andover Estates', 38.1686096191406, 0.666167908762383, -76.5047225952148, -1.3352593026114, 218, 25, 'PPL', 'P'),
(14989, 'Andover Golf Estates', 25.9638900756836, 0.453155368446558, -80.208610534668, -1.39990434227977, 218, 12, 'PPL', 'P'),
(144751, 'Andover Junction', 40.996940612793, 0.715531596937819, -74.7461090087891, -1.30456570525796, 218, 37, 'PPL', 'P'),
(14990, 'Andover Lakes Estates', 25.9658298492432, 0.453189223881916, -80.2022171020508, -1.39979275583009, 218, 12, 'PPL', 'P'),
(179746, 'Andrade Corner', 34.648609161377, 0.604732311102699, -118.376106262207, -2.06605280996619, 218, 6, 'PPL', 'P'),
(71672, 'Andre', 38.7472190856934, 0.676266549036936, -82.7347183227539, -1.44399324044214, 218, 41, 'PPL', 'P'),
(84664, 'Andrea Heights', 35.0563888549805, 0.611849409378854, -85.3533325195313, -1.48969668001537, 218, 50, 'PPL', 'P'),
(158703, 'Andreas', 40.7516708374023, 0.711250831801626, -75.7927780151367, -1.32283352559731, 218, 45, 'PPL', 'P'),
(133947, 'Andree', 45.728328704834, 0.798109897333587, -93.2236099243164, -1.62705893377418, 218, 28, 'PPL', 'P'),
(118626, 'Andres', 41.3716697692871, 0.722071854521863, -87.8824996948242, -1.53383897455759, 218, 18, 'PPL', 'P'),
(14991, 'Andrew', 30.3997192382813, 0.53057519238987, -84.4102783203125, -1.47323727921424, 218, 12, 'PPL', 'P'),
(26374, 'Andrew', 39.8955612182617, 0.696308900189627, -89.6399993896484, -1.56451313083507, 218, 18, 'PPL', 'P'),
(39107, 'Andrew', 30.0847206115723, 0.525077429214538, -92.2427825927734, -1.60994026744521, 218, 22, 'PPL', 'P'),
(107984, 'Andrew', 38.0999984741211, 0.664970418378229, -81.7174987792969, -1.42623941019318, 218, 58, 'PPL', 'P'),
(114414, 'Andrew', 42.1536102294922, 0.735719290107001, -90.5922164916992, -1.58113245445966, 218, 16, 'PPL', 'P'),
(99416, 'Andrew Lewis', 37.2825012207031, 0.650702399680075, -80.1255569458008, -1.39845478369844, 218, 53, 'PPL', 'P'),
(114415, 'Andrew Mobile Home Park', 41.6144409179688, 0.726309010395206, -93.7055587768555, -1.6354705280772, 218, 16, 'PPL', 'P'),
(7102, 'Andrews', 35.1838912963867, 0.614074746785724, -91.5680618286133, -1.59816416857904, 218, 4, 'PPL', 'P'),
(14997, 'Andrews', 30.7350006103516, 0.536426956253102, -81.9480590820313, -1.43026344660029, 218, 12, 'PPL', 'P'),
(44376, 'Andrews', 38.3566703796387, 0.669450188226878, -76.1102828979492, -1.32837503119355, 218, 25, 'PPL', 'P'),
(62526, 'Andrews', 35.2016716003418, 0.614385071631746, -83.8241729736328, -1.46300781115114, 218, 33, 'PPL', 'P'),
(70463, 'Andrews', 39.7238883972168, 0.693312644226206, -74.9594421386719, -1.308289070778, 218, 37, 'PPL', 'P'),
(79527, 'Andrews', 33.4511108398438, 0.583832022604839, -79.5611114501953, -1.38860335135207, 218, 48, 'PPL', 'P'),
(114416, 'Andrews', 41.7533302307129, 0.728733086198424, -93.7569427490234, -1.63636734757428, 218, 16, 'PPL', 'P'),
(122143, 'Andrews', 40.8624992370605, 0.713185152280377, -85.6016693115234, -1.49403097468947, 218, 19, 'PPL', 'P'),
(191074, 'Andrews', 32.3186111450195, 0.564066174152325, -102.545280456543, -1.78975277634767, 218, 51, 'PPL', 'P'),
(199142, 'Andrews', 42.6313896179199, 0.74405811353323, -103.733329772949, -1.81048814859503, 218, 35, 'PPL', 'P'),
(209889, 'Andrews', 42.464168548584, 0.741139555294612, -118.61222076416, -2.07017378543698, 218, 43, 'PPL', 'P'),
(118627, 'Andrews and Hurds Subdivision', 41.6666717529297, 0.72722061043634, -87.6319427490234, -1.52946593088963, 218, 18, 'PPL', 'P'),
(112773, 'Andrews Chapel', 34.3380584716797, 0.599312179073143, -87.0844421386719, -1.51991024258232, 218, 2, 'PPL', 'P'),
(18852, 'Andrews Crossroads', 32.9833297729492, 0.575667702809038, -84.6611099243164, -1.47761511657217, 218, 13, 'PPL', 'P'),
(13275, 'Andrews Lake Estates', 39.0208282470703, 0.681041929766584, -75.5258331298828, -1.31817445842827, 218, 10, 'PPL', 'P'),
(44381, 'Andrews Manor', 38.8138885498047, 0.677430150696219, -76.8983306884766, -1.34212905980131, 218, 25, 'PPL', 'P'),
(188042, 'Andrews Place', 32.0325012207031, 0.559072613950372, -103.397499084473, -1.80462679735187, 218, 38, 'PPL', 'P'),
(158705, 'Andrews Settlement', 41.9000015258789, 0.731292983217235, -77.9044418334961, -1.35968901192292, 218, 45, 'PPL', 'P'),
(79529, 'Andrews Subdivision', 33.4772186279297, 0.584287689467352, -80.8236083984375, -1.41063807989528, 218, 48, 'PPL', 'P'),
(13276, 'Andrewsville', 38.8613891601563, 0.678259192743561, -75.6352767944336, -1.32008461072013, 218, 10, 'PPL', 'P'),
(186339, 'Andrix', 37.2794418334961, 0.650649003300219, -103.192222595215, -1.80104404673739, 218, 7, 'PPL', 'P'),
(206692, 'Andron', 48.2627792358398, 0.842344403828558, -121.605003356934, -2.12240769547725, 218, 56, 'PPL', 'P'),
(133948, 'Andrusia', 47.4861106872559, 0.828788980459082, -94.6636123657227, -1.65219171761348, 218, 28, 'PPL', 'P'),
(122144, 'Andry', 41.7177810668945, 0.728112636243462, -86.758056640625, -1.51421374101064, 218, 19, 'PPL', 'P'),
(107985, 'Andy (historical)', 39.6713905334473, 0.692396383653164, -80.7572174072266, -1.40947933850498, 218, 58, 'PPL', 'P'),
(62527, 'Andy Cove', 35.894718170166, 0.626481016144831, -82.7130584716797, -1.4436152047254, 218, 33, 'PPL', 'P'),
(169733, 'Andys Acres', 43.6294403076172, 0.761477384170248, -96.6897201538086, -1.68755396951588, 218, 49, 'PPL', 'P'),
(199808, 'Andys Place', 41.7944412231445, 0.729450608375118, -119.384437561035, -2.08365151108165, 218, 39, 'PPL', 'P'),
(14998, 'Andytown', 26.1455593109131, 0.456326094750893, -80.4419403076172, -1.40397671506066, 218, 12, 'PPL', 'P'),
(34564, 'Andyville', 38.0338897705078, 0.663816603835952, -86.3724975585938, -1.50748446556822, 218, 21, 'PPL', 'P'),
(133949, 'Andyville', 43.7238883972168, 0.763125814305979, -92.9894409179688, -1.62297191360729, 218, 28, 'PPL', 'P'),
(177626, 'Anegam', 32.3727798461914, 0.565011596339304, -112.030281066895, -1.95529726655198, 218, 5, 'PPL', 'P'),
(84665, 'Anes', 35.5586090087891, 0.620614804632686, -86.7508316040039, -1.51408764033302, 218, 50, 'PPL', 'P'),
(139598, 'Aneta', 47.6794395446777, 0.832163205560213, -97.9877777099609, -1.71020934775113, 218, 34, 'PPL', 'P'),
(192467, 'Aneth', 37.2161102294922, 0.649543658289781, -109.186393737793, -1.90566206910341, 218, 52, 'PPL', 'P'),
(71673, 'Angel', 38.7208290100098, 0.675805955326407, -82.2694396972656, -1.43587259648821, 218, 41, 'PPL', 'P'),
(112775, 'Angel', 33.8352813720703, 0.590537063281331, -85.8369369506836, -1.49813716961621, 218, 2, 'PPL', 'P'),
(129531, 'Angel', 44.8325004577637, 0.782474744889841, -85.4150009155273, -1.49077299656992, 218, 27, 'PPL', 'P'),
(14999, 'Angel City', 28.3441696166992, 0.49469908355514, -80.6608276367188, -1.40779701964438, 218, 12, 'PPL', 'P'),
(92264, 'Angel City', 28.7163906097412, 0.501195565428766, -97.5408325195313, -1.70240868260218, 218, 51, 'PPL', 'P'),
(188043, 'Angel Fire', 36.3930587768555, 0.635178700527948, -105.284439086914, -1.83756011318206, 218, 38, 'PPL', 'P'),
(92265, 'Angel Haven Colonia', 25.8669395446777, 0.451463262468949, -97.4300003051758, -1.7004742955444, 218, 51, 'PPL', 'P'),
(202879, 'Angel Street', 40.6022186279297, 0.708642398671948, -111.882781982422, -1.95272292188425, 218, 52, 'PPL', 'P'),
(195878, 'Angela', 46.7299995422363, 0.815592351467467, -106.200561523438, -1.85354946605079, 218, 31, 'PPL', 'P'),
(92266, 'Angela Colonia', 26.1280002593994, 0.456019631488452, -97.9800033569336, -1.71007365969359, 218, 51, 'PPL', 'P'),
(191076, 'Angeles', 31.9013900756836, 0.556784292783722, -103.961936950684, -1.81447809654018, 218, 51, 'PPL', 'P'),
(44378, 'Angelica', 38.5852813720703, 0.673440202751062, -76.5250015258789, -1.33561323672027, 218, 25, 'PPL', 'P'),
(146819, 'Angelica', 42.3066711425781, 0.73839070699646, -78.01611328125, -1.36163804636669, 218, 40, 'PPL', 'P'),
(158704, 'Angelica', 40.2613906860352, 0.702693828903092, -75.9538879394531, -1.32564542423427, 218, 45, 'PPL', 'P'),
(172919, 'Angelica', 44.6738891601563, 0.779706455515731, -88.313606262207, -1.5413632035854, 218, 57, 'PPL', 'P'),
(99417, 'Angelico', 36.7169418334961, 0.64083152625775, -77.2369384765625, -1.34803888057631, 218, 53, 'PPL', 'P'),
(39108, 'Angelina', 30.0577793121338, 0.524607214834571, -90.6344375610352, -1.58186935113328, 218, 22, 'PPL', 'P'),
(39109, 'Angelique Estates', 29.9233303070068, 0.522260637019075, -89.9000015258789, -1.56905102417451, 218, 22, 'PPL', 'P'),
(193017, 'Angell', 35.1955604553223, 0.614278412030088, -111.303329467773, -1.94260956764467, 218, 5, 'PPL', 'P'),
(146820, 'Angells Corner', 43.0275001525879, 0.750971546565021, -76.8625030517578, -1.34150374957736, 218, 40, 'PPL', 'P'),
(99418, 'Angelo', 37.5438919067383, 0.655264527785435, -79.0744400024414, -1.38010933221332, 218, 53, 'PPL', 'P'),
(172921, 'Angelo', 43.9708290100098, 0.767435741056109, -90.7777786254883, -1.5843711246613, 218, 57, 'PPL', 'P'),
(158706, 'Angels', 41.2780609130859, 0.720438071772126, -75.3677825927734, -1.31541595617117, 218, 45, 'PPL', 'P'),
(18857, 'Angels Acres', 32.7694396972656, 0.571934616751019, -83.7594375610352, -1.46187796505867, 218, 13, 'PPL', 'P'),
(179749, 'Angels Camp', 38.0683288574219, 0.664417679293983, -120.538612365723, -2.10379566156701, 218, 6, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(202880, 'Angels Grove', 40.5213890075684, 0.707231655663505, -112.260276794434, -1.95931144926305, 218, 52, 'PPL', 'P'),
(84666, 'Angeltown', 36.5472183227539, 0.637869292177255, -86.3497161865234, -1.50708685561748, 218, 50, 'PPL', 'P'),
(885, 'Angelus', 34.5966682434082, 0.603825771067636, -80.3199996948242, -1.40184844987552, 218, 48, 'PPL', 'P'),
(187580, 'Angelus', 39.1911087036133, 0.684013884385058, -100.683891296387, -1.75726540684201, 218, 20, 'PPL', 'P'),
(179750, 'Angelus Oaks', 34.1458282470703, 0.595957128731861, -116.981666564941, -2.04171524602839, 218, 6, 'PPL', 'P'),
(18853, 'Angelville', 34.5888900756836, 0.603690016431069, -84.8899993896484, -1.48160999136534, 218, 13, 'PPL', 'P'),
(107986, 'Angerona', 38.8305587768555, 0.67772110104531, -81.804443359375, -1.4277568793823, 218, 58, 'PPL', 'P'),
(39110, 'Angie', 30.9663906097412, 0.540465473598639, -89.809440612793, -1.56747043806755, 218, 22, 'PPL', 'P'),
(202881, 'Angie Circle Condominium', 40.6522216796875, 0.709515116561167, -111.872497558594, -1.95254342482678, 218, 52, 'PPL', 'P'),
(191077, 'Angie Colonia', 31.6140003204346, 0.551768395318126, -106.279998779297, -1.85493590771428, 218, 51, 'PPL', 'P'),
(62529, 'Angier', 35.5069389343262, 0.619712991708558, -78.7394409179688, -1.3742624951981, 218, 33, 'PPL', 'P'),
(179751, 'Angiola', 35.9891700744629, 0.62812951285959, -119.474998474121, -2.08523209718861, 218, 6, 'PPL', 'P'),
(192468, 'Angle', 38.2491683959961, 0.66757392465989, -111.975830078125, -1.95434691751698, 218, 52, 'PPL', 'P'),
(189874, 'Angle City', 37.0433311462402, 0.646528094408457, -114.587501525879, -1.99992918326061, 218, 39, 'PPL', 'P'),
(133950, 'Angle Inlet', 49.3452796936035, 0.86123760097088, -95.0625, -1.65915362017711, 218, 28, 'PPL', 'P'),
(202882, 'Angle View', 40.6377792358398, 0.709263048363991, -111.944442749023, -1.95379910528075, 218, 52, 'PPL', 'P'),
(92268, 'Angler', 32.5938911437988, 0.56887071649591, -95.2533264160156, -1.66248416943636, 218, 51, 'PPL', 'P'),
(84667, 'Anglers Cove', 35.8202781677246, 0.625181793007036, -84.5319366455078, -1.47536061755136, 218, 50, 'PPL', 'P'),
(79530, 'Anglers Haven', 34.2249984741211, 0.597338909863448, -81.945556640625, -1.43021977075841, 218, 48, 'PPL', 'P'),
(15000, 'Anglers Park', 25.139720916748, 0.438770903029741, -80.3974990844727, -1.40320106939317, 218, 12, 'PPL', 'P'),
(70464, 'Anglesea', 39.0186080932617, 0.681003180772724, -74.795280456543, -1.30542390891924, 218, 37, 'PPL', 'P'),
(13288, 'Anglesey', 39.7588882446289, 0.693923506801243, -75.6163864135742, -1.31975491137718, 218, 10, 'PPL', 'P'),
(92271, 'Angleton', 29.1691703796387, 0.509098063199899, -95.4316711425781, -1.66559687211845, 218, 51, 'PPL', 'P'),
(15001, 'Anglevillas', 27.4599990844727, 0.479267396618676, -80.3722229003906, -1.4027599167586, 218, 12, 'PPL', 'P'),
(79531, 'Anglewood', 34.9186096191406, 0.609444708072567, -81.9938888549805, -1.43106332703369, 218, 48, 'PPL', 'P'),
(133951, 'Anglim', 47.7949981689453, 0.834180084032757, -96.5975036621094, -1.68594448811109, 218, 28, 'PPL', 'P'),
(206693, 'Anglin', 48.6569404602051, 0.849223814977424, -119.288063049316, -2.08196945853716, 218, 56, 'PPL', 'P'),
(129532, 'Angling', 44.6699981689453, 0.779638544907934, -85.0091705322266, -1.48368992017669, 218, 27, 'PPL', 'P'),
(31649, 'Angola', 37.1055603027344, 0.647614198080019, -95.4491729736328, -1.66590233669548, 218, 20, 'PPL', 'P'),
(39111, 'Angola', 30.9502792358398, 0.54018427707704, -91.5691680908203, -1.59818347649694, 218, 22, 'PPL', 'P'),
(62530, 'Angola', 34.7097206115723, 0.605798907119276, -77.6352767944336, -1.35499119576002, 218, 33, 'PPL', 'P'),
(99419, 'Angola', 37.4013900756836, 0.65277740164341, -78.2402801513672, -1.36555049632412, 218, 53, 'PPL', 'P'),
(122145, 'Angola', 41.6347198486328, 0.726662944504078, -84.9994430541992, -1.4835201436572, 218, 19, 'PPL', 'P'),
(146829, 'Angola', 42.6383285522461, 0.744179220783801, -79.0280609130859, -1.37929986439999, 218, 40, 'PPL', 'P'),
(71674, 'Angola (historical)', 38.6938896179199, 0.675335774235953, -82.1913909912109, -1.43451038959064, 218, 41, 'PPL', 'P'),
(13277, 'Angola Acres II Mobile Home Park', 38.6730613708496, 0.674972252747157, -75.1580581665039, -1.31175557441091, 218, 10, 'PPL', 'P'),
(13278, 'Angola Beach Mobile Home Park', 38.6530609130859, 0.674623178907275, -75.1650009155273, -1.3118767482405, 218, 10, 'PPL', 'P'),
(13283, 'Angola by the Bay', 38.6708297729492, 0.674933304016215, -75.1750030517578, -1.31205131844996, 218, 10, 'PPL', 'P'),
(13279, 'Angola Crest II Mobile Home Park', 38.6683311462402, 0.674889694753365, -75.1533279418945, -1.31167301641711, 218, 10, 'PPL', 'P'),
(13280, 'Angola Crest Mobile Home Park', 38.6694412231445, 0.674909069250295, -75.1561126708984, -1.31172161910701, 218, 10, 'PPL', 'P'),
(146822, 'Angola Lake Shore Addition', 42.6180610656738, 0.743825486412012, -79.0986099243164, -1.38053117692998, 218, 40, 'PPL', 'P'),
(13281, 'Angola Landing', 38.6438903808594, 0.674463122925762, -75.1272201538086, -1.3112173495546, 218, 10, 'PPL', 'P'),
(39112, 'Angola Landing', 30.9438896179199, 0.540072757206393, -91.647216796875, -1.59954568339452, 218, 22, 'PPL', 'P'),
(13282, 'Angola Neck Park Mobile Home Park', 38.6708297729492, 0.674933304016215, -75.1511077880859, -1.31163426742325, 218, 10, 'PPL', 'P'),
(146823, 'Angola on the Lake', 42.6547203063965, 0.744465310863903, -79.0491714477539, -1.3796683127368, 218, 40, 'PPL', 'P'),
(146824, 'Angola-on-the-Lake', 42.6502799987793, 0.744387812876182, -79.0550003051758, -1.37977004549044, 218, 40, 'PPL', 'P'),
(209933, 'Angoon', 57.5033302307129, 1.00362244338753, -134.583892822266, -2.3489320498997, 218, 1, 'PPL', 'P'),
(77787, 'Angora', 39.9438896179199, 0.697152389885882, -75.2380599975586, -1.31315186977043, 218, 45, 'PPL', 'P'),
(133952, 'Angora', 47.7750015258789, 0.833831076771902, -92.6338882446289, -1.61676634879324, 218, 28, 'PPL', 'P'),
(194088, 'Angora', 40.1766700744629, 0.701215175286853, -108.574996948242, -1.89499118208962, 218, 7, 'PPL', 'P'),
(199144, 'Angora', 41.8519401550293, 0.730454154052887, -103.124717712402, -1.79986586427114, 218, 35, 'PPL', 'P'),
(188047, 'Angostura', 32.6519393920898, 0.569883849553603, -107.092498779297, -1.86911670788674, 218, 38, 'PPL', 'P'),
(18854, 'Anguilla', 31.2552795410156, 0.545507536621945, -81.6036071777344, -1.42425162675554, 218, 13, 'PPL', 'P'),
(58465, 'Anguilla', 32.9738883972168, 0.575502919716589, -90.8244400024414, -1.58518551932265, 218, 30, 'PPL', 'P'),
(53193, 'Angus', 36.6344413757324, 0.639391621635372, -90.4836120605469, -1.57923694955379, 218, 29, 'PPL', 'P'),
(92269, 'Angus', 32.0061111450195, 0.558612020239843, -96.4327774047852, -1.68306947255629, 218, 51, 'PPL', 'P'),
(114417, 'Angus', 41.8833312988281, 0.731002032868144, -94.1572189331055, -1.64335348490383, 218, 16, 'PPL', 'P'),
(133954, 'Angus', 48.0811080932617, 0.83917364423471, -96.7027816772461, -1.68778193610519, 218, 28, 'PPL', 'P'),
(141165, 'Angus', 40.2822189331055, 0.703057350391888, -97.9791717529297, -1.71005914546565, 218, 35, 'PPL', 'P'),
(146825, 'Angus', 42.7347183227539, 0.745861539644404, -76.9730606079102, -1.34343334294518, 218, 40, 'PPL', 'P'),
(154072, 'Angus', 41.1966705322266, 0.719017541646678, -83.2850036621094, -1.45359753143934, 218, 41, 'PPL', 'P'),
(172924, 'Angus', 45.6477813720703, 0.796704081173162, -91.6016693115234, -1.59875072980913, 218, 57, 'PPL', 'P'),
(188048, 'Angus', 33.4452781677246, 0.583730223272171, -105.665000915527, -1.84420217009878, 218, 38, 'PPL', 'P'),
(179752, 'Angwin', 38.5758285522461, 0.673275219921532, -122.448890686035, -2.13713630788593, 218, 6, 'PPL', 'P'),
(92270, 'Anhalt', 29.7938899993896, 0.520001477466361, -98.4752807617188, -1.71871788111782, 218, 51, 'PPL', 'P'),
(212281, 'Aniak', 61.5783309936523, 1.0747446237221, -159.522216796875, -2.78418791318567, 218, 1, 'PPL', 'P'),
(7103, 'Anice (historical)', 35.4294395446777, 0.618360372190907, -94.0208282470703, -1.64097301836347, 218, 4, 'PPL', 'P'),
(200328, 'Anidem (historical)', 44.6055603027344, 0.778513891979593, -122.391670227051, -2.13613762247715, 218, 43, 'PPL', 'P'),
(13284, 'Aniline Village', 39.8138885498047, 0.694883443216162, -75.4430618286133, -1.31672982669496, 218, 10, 'PPL', 'P'),
(188049, 'Animas', 31.9488906860352, 0.557613334831063, -108.806671142578, -1.89903465957269, 218, 38, 'PPL', 'P'),
(186340, 'Animas Forks', 37.9311103820801, 0.662022765104702, -107.570831298828, -1.87746518527192, 218, 7, 'PPL', 'P'),
(158707, 'Anise', 40.3263893127441, 0.703828268948439, -75.5341720581055, -1.31832000018184, 218, 45, 'PPL', 'P'),
(29102, 'Anita', 39.4258308410645, 0.6881105585109, -86.1913909912109, -1.50432355967041, 218, 19, 'PPL', 'P'),
(112776, 'Anita', 33.1741714477539, 0.5789985183844, -86.9802780151367, -1.51809223566417, 218, 2, 'PPL', 'P'),
(114418, 'Anita', 41.4452781677246, 0.723356563431717, -94.7644424438477, -1.6539515344618, 218, 16, 'PPL', 'P'),
(158708, 'Anita', 41.0013885498047, 0.715609228083595, -78.9633331298828, -1.37817015146557, 218, 45, 'PPL', 'P'),
(179753, 'Anita', 39.8108291625977, 0.694830046836306, -121.97721862793, -2.12890407748233, 218, 6, 'PPL', 'P'),
(195879, 'Anita', 45.9441719055176, 0.801877071853559, -108.021392822266, -1.88532896733871, 218, 31, 'PPL', 'P'),
(212282, 'Aniuk (historical)', 68, 1.18682389135614, -158, -2.75762021815104, 218, 1, 'PPL', 'P'),
(172925, 'Aniwa', 45.0086097717285, 0.785548432261956, -89.2141723632813, -1.55708104718099, 218, 57, 'PPL', 'P'),
(107988, 'Anjean', 38.0200004577637, 0.663574189597727, -80.6333312988281, -1.40731711801595, 218, 58, 'PPL', 'P'),
(114419, 'Ankeny', 41.7297210693359, 0.728321028598761, -93.6055603027344, -1.63372522545681, 218, 16, 'PPL', 'P'),
(158709, 'Ankeny', 40.1377792358398, 0.700536402104019, -79.1102828979492, -1.38073490875338, 218, 45, 'PPL', 'P'),
(206694, 'Ankeny', 46.8499984741211, 0.817686727927732, -118.153610229492, -2.06216952162269, 218, 56, 'PPL', 'P'),
(154073, 'Ankenytown', 40.5341682434082, 0.707454695404799, -82.504997253418, -1.43998385142102, 218, 41, 'PPL', 'P'),
(15002, 'Ankona', 27.3402805328369, 0.477177913716914, -80.2752838134766, -1.40106801051808, 218, 12, 'PPL', 'P'),
(99420, 'Ankum', 36.603328704834, 0.638848603089105, -77.8811111450195, -1.35928181459224, 218, 53, 'PPL', 'P'),
(200329, 'Anlauf', 43.711109161377, 0.762902774564685, -123.222503662109, -2.15063840145458, 218, 43, 'PPL', 'P'),
(71675, 'Anlo', 39.9397201538086, 0.697079619009096, -83.9466705322266, -1.46514579687425, 218, 41, 'PPL', 'P'),
(107989, 'Anmoore', 39.2566719055176, 0.685158178126438, -80.2925033569336, -1.40136854824709, 218, 58, 'PPL', 'P'),
(53190, 'Ann', 37.0308303833008, 0.646309914936152, -92.1972198486328, -1.60914504754371, 218, 29, 'PPL', 'P'),
(129533, 'Ann Arbor', 42.2708282470703, 0.7377651304564, -83.7263870239258, -1.46130112436656, 218, 27, 'PPL', 'P'),
(99421, 'Ann Wrights Corner', 38.0900001525879, 0.664795914747801, -77.5263900756836, -1.35309076400613, 218, 53, 'PPL', 'P'),
(26375, 'Anna', 37.4602813720703, 0.653805248666126, -89.246940612793, -1.55765296102508, 218, 18, 'PPL', 'P'),
(34565, 'Anna', 37.1163902282715, 0.647803215938387, -86.4230575561523, -1.50836690399542, 218, 21, 'PPL', 'P'),
(58466, 'Anna', 31.6966705322266, 0.553211262707217, -91.3513870239258, -1.59438247983113, 218, 30, 'PPL', 'P'),
(92272, 'Anna', 33.3488883972168, 0.582047904411568, -96.5483322143555, -1.68508628444981, 218, 51, 'PPL', 'P'),
(154074, 'Anna', 40.3944396972656, 0.705015972215587, -84.1727828979492, -1.46909220213559, 218, 41, 'PPL', 'P'),
(7104, 'Anna (historical)', 35.7272186279297, 0.623557597637224, -94.2861099243164, -1.64560305707662, 218, 4, 'PPL', 'P'),
(18855, 'Anna Bella Estates', 33.7986106872559, 0.589897039092358, -84.6708297729492, -1.47778475993361, 218, 13, 'PPL', 'P'),
(92273, 'Anna Lisa Colonia', 26.3020000457764, 0.459056500658497, -98.2839965820313, -1.7153793423753, 218, 51, 'PPL', 'P'),
(34566, 'Anna Lynne', 36.5469398498535, 0.637864431908266, -89.2538909912109, -1.55777426801274, 218, 21, 'PPL', 'P'),
(15003, 'Anna Maria', 27.5308303833008, 0.480503635996691, -82.7336120605469, -1.44397393252423, 218, 12, 'PPL', 'P'),
(192469, 'Annabella', 38.709171295166, 0.675602489819125, -112.059173583984, -1.95580153610438, 218, 52, 'PPL', 'P'),
(53191, 'Annada', 39.2611083984375, 0.685235609535132, -90.8274993896484, -1.58523891570251, 218, 29, 'PPL', 'P'),
(39113, 'Annadale', 30.1319408416748, 0.525901577703377, -91.1311111450195, -1.59053794048149, 218, 22, 'PPL', 'P'),
(84668, 'Annadale', 35.165828704834, 0.613759495091686, -84.8850021362305, -1.48152277283964, 218, 50, 'PPL', 'P'),
(146826, 'Annadale', 40.5444412231445, 0.707633992725189, -74.1769409179688, -1.29463184807586, 218, 40, 'PPL', 'P'),
(84669, 'Annadel', 36.1766700744629, 0.63140200520708, -84.6658325195313, -1.47769754140791, 218, 50, 'PPL', 'P'),
(99422, 'Annalee Heights', 38.8597183227539, 0.678230031129624, -77.1808319091797, -1.34705963624349, 218, 53, 'PPL', 'P'),
(107990, 'Annamoriah', 38.940559387207, 0.679640973875148, -81.2272186279297, -1.41768240729464, 218, 58, 'PPL', 'P'),
(44379, 'Annandale', 39.3233299255371, 0.686321580048639, -76.9749984741211, -1.34346716509102, 218, 25, 'PPL', 'P'),
(58467, 'Annandale', 32.514720916748, 0.567488935364323, -90.1883316040039, -1.57408333337033, 218, 30, 'PPL', 'P'),
(99423, 'Annandale', 38.8302803039551, 0.677716240776321, -77.1966705322266, -1.34733607236464, 218, 53, 'PPL', 'P'),
(133967, 'Annandale', 45.2627792358398, 0.789984526268728, -94.1241683959961, -1.64277664421172, 218, 28, 'PPL', 'P'),
(144754, 'Annandale', 40.6408309936523, 0.709316311585792, -74.8816680908203, -1.30693165757039, 218, 37, 'PPL', 'P'),
(158710, 'Annandale', 41.0911102294922, 0.717175166804561, -79.8930587768555, -1.39439692514548, 218, 45, 'PPL', 'P'),
(99424, 'Annandale Acres', 38.8186111450195, 0.677512575531957, -77.1933288574219, -1.34727774913676, 218, 53, 'PPL', 'P'),
(29100, 'Annandale Estates', 39.2177810668945, 0.684479404943604, -86.26611328125, -1.50562770965622, 218, 19, 'PPL', 'P'),
(99425, 'Annandale Terrace', 38.8238906860352, 0.677604720905674, -77.2069396972656, -1.347515303106, 218, 53, 'PPL', 'P'),
(146827, 'Annandale-on-Hudson', 42.0127792358398, 0.733261325578913, -73.9086074829102, -1.2899485461409, 218, 40, 'PPL', 'P'),
(26382, 'Annapolis', 39.1444396972656, 0.683199356565658, -87.8166732788086, -1.53269008686333, 218, 18, 'PPL', 'P'),
(29101, 'Annapolis', 39.8525009155273, 0.695557356130007, -87.2505569458008, -1.52280949290303, 218, 19, 'PPL', 'P'),
(44380, 'Annapolis', 38.978328704834, 0.68030017282397, -76.4925003051758, -1.33504598340808, 218, 25, 'PPL', 'P'),
(53192, 'Annapolis', 37.360279083252, 0.652059879466715, -90.6975021362305, -1.58297003561181, 218, 29, 'PPL', 'P'),
(154075, 'Annapolis', 40.4111099243164, 0.705306922564678, -80.8633270263672, -1.41133130072702, 218, 41, 'PPL', 'P'),
(179754, 'Annapolis', 38.7219390869141, 0.675825329823337, -123.368606567383, -2.15318837819833, 218, 6, 'PPL', 'P'),
(206695, 'Annapolis', 47.547779083252, 0.829865297013638, -122.619438171387, -2.14011292303631, 218, 56, 'PPL', 'P'),
(44382, 'Annapolis Cove', 38.9394416809082, 0.679621466220163, -76.4608306884766, -1.33449324432384, 218, 25, 'PPL', 'P'),
(44383, 'Annapolis Landing', 38.939998626709, 0.679631186758142, -76.5833282470703, -1.33663123004695, 218, 25, 'PPL', 'P'),
(44385, 'Annapolis Roads', 38.9511108398438, 0.679825131464527, -76.4752807617188, -1.33474544567907, 218, 25, 'PPL', 'P'),
(44386, 'Annapolis Rock', 39.2816696166992, 0.68559447049202, -77.1319427490234, -1.34620635943023, 218, 25, 'PPL', 'P'),
(169253, 'Annaquatucket', 41.5513916015625, 0.725208592232785, -71.4486083984375, -1.24701346252081, 218, 47, 'PPL', 'P'),
(172928, 'Annaton', 42.9113883972168, 0.748945014133525, -90.5374984741211, -1.58017744489276, 218, 57, 'PPL', 'P'),
(92275, 'Annaville', 33.1169395446777, 0.577999633238538, -97.5716705322266, -1.70294690745848, 218, 51, 'PPL', 'P'),
(118628, 'Annawan', 41.3972206115723, 0.722517800846397, -89.9044418334961, -1.56912852216223, 218, 18, 'PPL', 'P'),
(169254, 'Annawomscutt', 41.7402801513672, 0.728505319346195, -71.3444366455078, -1.24519532244461, 218, 47, 'PPL', 'P'),
(141166, 'Anncar', 42.8072204589844, 0.747126940636356, -98.7430572509766, -1.7233914625148, 218, 35, 'PPL', 'P'),
(79532, 'Anne', 33.4727783203125, 0.58421019147963, -79.2538909912109, -1.3832413428133, 218, 48, 'PPL', 'P'),
(13285, 'Anne Acres', 38.7002792358398, 0.6754472941066, -75.0830612182617, -1.31044663073513, 218, 10, 'PPL', 'P'),
(18856, 'Anne Heights', 33.7213897705078, 0.588549279843696, -82.7050018310547, -1.44347458981984, 218, 13, 'PPL', 'P'),
(112506, 'Anne Manie', 32.0527801513672, 0.559426548059244, -87.5708312988281, -1.52839933487305, 218, 2, 'PPL', 'P'),
(18858, 'Anneewakee', 33.6802787780762, 0.587831757667002, -84.7333297729492, -1.4788755907161, 218, 13, 'PPL', 'P'),
(18879, 'Anneewakee Estates', 33.7125015258789, 0.588394150710199, -84.6647186279297, -1.47767810033195, 218, 13, 'PPL', 'P'),
(31650, 'Annelly', 37.9722213745117, 0.662740287281396, -97.2008285522461, -1.69647449390321, 218, 20, 'PPL', 'P'),
(44388, 'Annemessix Towne (historical)', 38.038890838623, 0.663903888940679, -75.779167175293, -1.32259597162807, 218, 25, 'PPL', 'P'),
(44397, 'Annes Delight', 39.4269409179688, 0.68812993300783, -76.3475036621094, -1.33251531458224, 218, 25, 'PPL', 'P'),
(44389, 'Anneslie', 39.3758316040039, 0.687237907200708, -76.6047210693359, -1.33700460523178, 218, 25, 'PPL', 'P'),
(31651, 'Anness', 37.4819412231445, 0.654183284382863, -97.7283325195313, -1.70568117494967, 218, 20, 'PPL', 'P'),
(34567, 'Anneta', 37.3708305358887, 0.652244037056094, -86.2452774047852, -1.50526405500937, 218, 21, 'PPL', 'P'),
(92276, 'Annetta', 32.709171295166, 0.570882734699465, -97.6758270263672, -1.70476478121857, 218, 51, 'PPL', 'P'),
(44390, 'Annetta Gardens', 39.1883316040039, 0.683965414853219, -76.8030624389648, -1.34046631517472, 218, 25, 'PPL', 'P'),
(92277, 'Annetta North', 32.7191696166992, 0.571057238329892, -97.6755599975586, -1.70476012068666, 218, 51, 'PPL', 'P'),
(92278, 'Annetta South', 32.6680603027344, 0.57016521252277, -97.6602783203125, -1.70449340510349, 218, 51, 'PPL', 'P'),
(179755, 'Annette', 35.6508293151855, 0.622224352616503, -120.178062438965, -2.09750287822726, 218, 6, 'PPL', 'P'),
(209934, 'Annette', 55.0616683959961, 0.961007405151437, -131.54167175293, -2.29583527566624, 218, 1, 'PPL', 'P'),
(13286, 'Anneville', 39.1291694641113, 0.682932840719568, -75.5194396972656, -1.3180628719786, 218, 10, 'PPL', 'P'),
(99426, 'Annex', 38.1611099243164, 0.666037014394805, -78.9858322143555, -1.37856283456831, 218, 53, 'PPL', 'P'),
(200330, 'Annex', 44.2402801513672, 0.772138550646053, -116.983329772949, -2.04174427448427, 218, 43, 'PPL', 'P'),
(107991, 'Annfred', 38.3041687011719, 0.668533861074809, -81.4138870239258, -1.42094038541419, 218, 58, 'PPL', 'P'),
(44391, 'Annie Hall', 38.6755599975586, 0.675015862010008, -76.5711135864258, -1.33641804400169, 218, 25, 'PPL', 'P'),
(18860, 'Anniedelle', 34.2174987792969, 0.597208015495871, -85.3974990844727, -1.49046753199289, 218, 13, 'PPL', 'P'),
(7105, 'Annieville', 36.1549987792969, 0.631023769753261, -91.2402801513672, -1.59244329908339, 218, 4, 'PPL', 'P'),
(79534, 'Annieville', 33.4805603027344, 0.584346012695224, -79.1022186279297, -1.38059416068976, 218, 48, 'PPL', 'P'),
(158711, 'Annin Creek', 41.9013900756836, 0.731317217983155, -78.2605590820313, -1.365904430433, 218, 45, 'PPL', 'P'),
(194524, 'Annis', 43.728328704834, 0.763203312293701, -111.935279846191, -1.95363918245729, 218, 17, 'PPL', 'P'),
(124115, 'Annisquam', 42.6583290100098, 0.744528294623684, -70.6777801513672, -1.23355997164205, 218, 23, 'PPL', 'P'),
(53195, 'Anniston', 36.8258285522461, 0.642731958011631, -89.3277816772461, -1.55906390377061, 218, 29, 'PPL', 'P'),
(112777, 'Anniston', 33.6597213745117, 0.587472963289141, -85.831672668457, -1.4980452905586, 218, 2, 'PPL', 'P'),
(188050, 'Anniston (historical)', 35.3738899230957, 0.617390848396064, -103.321937561035, -1.80330799998006, 218, 38, 'PPL', 'P'),
(158713, 'Annisville', 41.0825004577637, 0.717024897940054, -79.7972183227539, -1.3927241936648, 218, 45, 'PPL', 'P'),
(92279, 'Annona', 33.5805587768555, 0.586091315315608, -94.915283203125, -1.6565842023574, 218, 51, 'PPL', 'P'),
(7107, 'Annover (historical)', 33.7733306884766, 0.589455819878759, -91.9930572509766, -1.60558173800518, 218, 4, 'PPL', 'P'),
(146828, 'Annsville', 41.3074989318848, 0.72095186212543, -73.9283294677734, -1.29029275971179, 218, 40, 'PPL', 'P'),
(34568, 'Annville', 37.3191719055176, 0.651342423869048, -83.9705581665039, -1.46556271474291, 218, 21, 'PPL', 'P'),
(158714, 'Annville', 40.3294410705566, 0.70388153217024, -76.5155563354492, -1.3354483870488, 218, 45, 'PPL', 'P'),
(34569, 'Ano', 37.1133308410645, 0.647749819558531, -84.3363876342773, -1.47194764345637, 218, 21, 'PPL', 'P'),
(212283, 'Anogok', 59.8211097717285, 1.04407532771362, -164.028610229492, -2.86283931597509, 218, 1, 'PPL', 'P'),
(122146, 'Anoka', 40.7219390869141, 0.710731914863224, -86.2825012207031, -1.5059137331573, 218, 19, 'PPL', 'P'),
(133959, 'Anoka', 45.1977806091309, 0.788850086223382, -93.3869400024414, -1.629909581405, 218, 28, 'PPL', 'P'),
(141167, 'Anoka', 42.9469413757324, 0.749565530667514, -98.8305587768555, -1.72491865224191, 218, 35, 'PPL', 'P'),
(18861, 'Anon (historical)', 33.8683280944824, 0.591113837394415, -82.9258270263672, -1.44732871654941, 218, 13, 'PPL', 'P'),
(369, 'Anona', 27.8950004577637, 0.486859602833301, -82.8308334350586, -1.44567076561278, 218, 12, 'PPL', 'P'),
(44392, 'Another Place', 38.4416694641113, 0.670933702112107, -76.5236129760742, -1.33558900195435, 218, 25, 'PPL', 'P'),
(7108, 'Anrep (historical)', 34.2222213745117, 0.597290440331609, -91.5680618286133, -1.59816416857904, 218, 4, 'PPL', 'P'),
(44393, 'Anscroft', 39.1252784729004, 0.682864930111771, -77.0541687011719, -1.34484894622261, 218, 25, 'PPL', 'P'),
(692, 'Anse', 32.1188888549805, 0.560580362601521, -90.100830078125, -1.57255614364322, 218, 30, 'PPL', 'P'),
(39114, 'Anse La Butte', 30.2594394683838, 0.52812684853122, -91.9680633544922, -1.60514551221863, 218, 22, 'PPL', 'P'),
(34570, 'Ansel', 37.1961097717285, 0.649194584449899, -84.7091674804688, -1.47845387915749, 218, 21, 'PPL', 'P'),
(179756, 'Ansel', 34.9049987792969, 0.609207154103332, -118.153327941895, -2.06216459477468, 218, 6, 'PPL', 'P'),
(186341, 'Ansel', 37.7030601501465, 0.658042537697524, -106.101936340332, -1.85182813188022, 218, 7, 'PPL', 'P'),
(139600, 'Anselm', 46.5286102294922, 0.812077444881753, -97.4952774047852, -1.70161359585873, 218, 34, 'PPL', 'P'),
(158716, 'Anselma', 40.0813903808594, 0.69955223092318, -75.642219543457, -1.32020578454973, 218, 45, 'PPL', 'P'),
(141168, 'Anselmo', 41.6186103820801, 0.726381781271993, -99.8647232055664, -1.74296822652992, 218, 35, 'PPL', 'P'),
(195880, 'Anselmo (historical)', 46.0166702270508, 0.803142406266483, -112.547218322754, -1.96431952369295, 218, 31, 'PPL', 'P'),
(18862, 'Ansley', 33.3186111450195, 0.581519466672269, -82.7750015258789, -1.44469631496992, 218, 13, 'PPL', 'P'),
(39115, 'Ansley', 32.3955612182617, 0.565409206290052, -92.6927795410156, -1.61779419581596, 218, 22, 'PPL', 'P'),
(58468, 'Ansley', 30.2250003814697, 0.527525773073189, -89.4836120605469, -1.56178365703385, 218, 30, 'PPL', 'P'),
(112779, 'Ansley', 31.8861103057861, 0.556517610490064, -86.1158294677734, -1.5030047622986, 218, 2, 'PPL', 'P'),
(141169, 'Ansley', 41.2877807617188, 0.720607715133565, -99.3813934326172, -1.73453253061904, 218, 35, 'PPL', 'P'),
(122147, 'Ansley Acres', 41.0783309936523, 0.716952127063267, -85.2122192382813, -1.48723378863926, 218, 19, 'PPL', 'P'),
(18863, 'Ansley Brook', 33.9047203063965, 0.591749001314399, -84.0583267211914, -1.46709456500192, 218, 13, 'PPL', 'P'),
(62534, 'Ansley Heights', 36.1380615234375, 0.630728158872262, -81.7130584716797, -1.42616191220546, 218, 33, 'PPL', 'P'),
(18865, 'Ansley Mill', 33.5194396972656, 0.585024586140977, -82.4136123657227, -1.43838888424417, 218, 13, 'PPL', 'P'),
(18867, 'Ansley Park', 33.7988891601563, 0.589901899361348, -84.6602783203125, -1.47760060234423, 218, 13, 'PPL', 'P'),
(79535, 'Ansley Park', 33.5319404602051, 0.585242765613281, -81.684440612793, -1.42566243634301, 218, 48, 'PPL', 'P'),
(191078, 'Ansley Place', 30.2433300018311, 0.527845685299135, -103.138061523438, -1.80009875770846, 218, 51, 'PPL', 'P'),
(18869, 'Ansley Pointe', 33.5188903808594, 0.585014998761052, -84.4138870239258, -1.47330026297402, 218, 13, 'PPL', 'P'),
(31652, 'Anson', 37.3652801513672, 0.652147164571443, -97.5294418334961, -1.7022098776268, 218, 20, 'PPL', 'P'),
(92280, 'Anson', 32.7563896179199, 0.57170684989879, -99.8958282470703, -1.74351111191813, 218, 51, 'PPL', 'P'),
(126762, 'Anson', 44.7983283996582, 0.781878329963718, -69.8897171020508, -1.21980567671818, 218, 26, 'PPL', 'P'),
(139011, 'Anson', 40.577220916748, 0.708206106306365, -91.7658309936523, -1.60161589166789, 218, 29, 'PPL', 'P'),
(172929, 'Anson', 44.9808311462402, 0.785063603785507, -91.2866668701172, -1.59325290005477, 218, 57, 'PPL', 'P'),
(154076, 'Ansonia', 40.2144393920898, 0.701874374235675, -84.6369400024414, -1.4771932718555, 218, 41, 'PPL', 'P'),
(158717, 'Ansonia', 41.7463912963867, 0.728611978947852, -77.4286117553711, -1.35138421037961, 218, 45, 'PPL', 'P'),
(177441, 'Ansonia', 41.3461112976074, 0.721625775039275, -73.0794372558594, -1.27547679561936, 218, 8, 'PPL', 'P'),
(62532, 'Ansonville', 35.1044387817383, 0.61268803880612, -80.1094436645508, -1.39817355388732, 218, 33, 'PPL', 'P'),
(158718, 'Ansonville', 40.8474998474121, 0.712923363545223, -78.5658264160156, -1.37123235050981, 218, 45, 'PPL', 'P'),
(107992, 'Ansted', 38.1361083984375, 0.665600655450196, -81.0997161865234, -1.41545706988777, 218, 58, 'PPL', 'P'),
(77788, 'Anstine', 39.7541694641113, 0.693841148544532, -76.6352767944336, -1.33753790324007, 218, 45, 'PPL', 'P'),
(172931, 'Anston', 44.6172218322754, 0.778717424065903, -88.1602783203125, -1.53868712616403, 218, 57, 'PPL', 'P'),
(195881, 'Ant Flat', 48.7241706848145, 0.850397203753713, -114.875556945801, -2.00495669876646, 218, 31, 'PPL', 'P'),
(193018, 'Antares', 35.4197196960449, 0.618190728829469, -113.807777404785, -1.98632043009031, 218, 5, 'PPL', 'P'),
(124116, 'Antassawamock', 41.6252784729004, 0.726498161411629, -70.8077774047852, -1.23582885173275, 218, 23, 'PPL', 'P'),
(99427, 'Ante', 36.6647186279297, 0.639920059374671, -77.7194366455078, -1.35646006225925, 218, 53, 'PPL', 'P'),
(18870, 'Antebellum North', 32.6713905334473, 0.570223336013561, -83.7050018310547, -1.46092788233979, 218, 13, 'PPL', 'P'),
(18871, 'Antebellum Plateau', 32.663330078125, 0.570082654528978, -83.6977767944336, -1.46080178166217, 218, 13, 'PPL', 'P'),
(31653, 'Antelope', 38.4361114501953, 0.670836696469401, -96.9736099243164, -1.69250878072397, 218, 20, 'PPL', 'P'),
(92281, 'Antelope', 33.4416694641113, 0.58366723951239, -98.3694381713867, -1.71687057942769, 218, 51, 'PPL', 'P'),
(179757, 'Antelope', 38.7083282470703, 0.675587775854102, -121.328887939453, -2.1175885723267, 218, 6, 'PPL', 'P'),
(188051, 'Antelope', 31.9569396972656, 0.557753816578565, -108.713333129883, -1.89740560393389, 218, 38, 'PPL', 'P'),
(195882, 'Antelope', 48.6897201538086, 0.8497959285586, -104.457778930664, -1.82313217166045, 218, 31, 'PPL', 'P'),
(197938, 'Antelope', 46.8558311462402, 0.817788527260401, -102.202217102051, -1.78376519126884, 218, 34, 'PPL', 'P'),
(200331, 'Antelope', 44.910831451416, 0.783841878635433, -120.721672058105, -2.10699065592678, 218, 43, 'PPL', 'P'),
(201859, 'Antelope', 43.3030586242676, 0.755780949177595, -100.628890991211, -1.75630547042709, 218, 49, 'PPL', 'P'),
(209272, 'Antelope', 41.4211082458496, 0.722934718715049, -110.529441833496, -1.92910268038606, 218, 59, 'PPL', 'P'),
(179758, 'Antelope (historical)', 39.7069396972656, 0.693016833608126, -120.035278320313, -2.09501082523722, 218, 6, 'PPL', 'P'),
(189875, 'Antelope (historical)', 38.8211097717285, 0.677556184794807, -116.471672058105, -2.03281416271702, 218, 39, 'PPL', 'P'),
(194525, 'Antelope (historical)', 43.6722183227539, 0.762224001381851, -113.64111328125, -1.98341159238967, 218, 17, 'PPL', 'P'),
(179759, 'Antelope Acres', 34.7544403076172, 0.606579413055751, -118.288612365723, -2.06452575339714, 218, 6, 'PPL', 'P'),
(179760, 'Antelope Center', 34.5800018310547, 0.603534887297572, -117.968330383301, -2.05893577826906, 218, 6, 'PPL', 'P'),
(92282, 'Antelope Crossing', 31.2466697692871, 0.545357267757437, -97.8716735839844, -1.70818294847769, 218, 51, 'PPL', 'P'),
(201860, 'Antelope Development Area', 43.3022193908691, 0.7557663017916, -100.634170532227, -1.75639761580081, 218, 49, 'PPL', 'P'),
(191079, 'Antelope Flats', 34.6058082580566, 0.603985294416932, -100.985702514648, -1.76253300632013, 218, 51, 'PPL', 'P'),
(179761, 'Antelope Hills', 33.6055603027344, 0.586527674260217, -117.166107177734, -2.04493434199603, 218, 6, 'PPL', 'P'),
(209273, 'Antelope Hills', 43.0816688537598, 0.751916968751999, -106.323608398438, -1.85569703915383, 218, 59, 'PPL', 'P'),
(188052, 'Antelope Springs', 34.832218170166, 0.607936892842392, -106.067497253418, -1.85122705642219, 218, 38, 'PPL', 'P'),
(189877, 'Antelope Springs (historical)', 37.6086082458496, 0.656394040982765, -116.728332519531, -2.03729373282859, 218, 39, 'PPL', 'P'),
(188053, 'Antelope Wells', 31.3488903045654, 0.547141352661195, -108.508331298828, -1.89382764700937, 218, 38, 'PPL', 'P'),
(186342, 'Antero Junction', 38.9233283996582, 0.679340236409051, -105.964721679688, -1.84943328426996, 218, 7, 'PPL', 'P'),
(179762, 'Antes', 36.3086090087891, 0.633704774022644, -119.129722595215, -2.07920589627398, 218, 6, 'PPL', 'P'),
(158722, 'Antes Fort', 41.1916694641113, 0.718930256541951, -77.2241668701172, -1.34781597399307, 218, 45, 'PPL', 'P'),
(107993, 'Anthem', 39.646671295166, 0.691964951556572, -80.5286102294922, -1.40548939055983, 218, 58, 'PPL', 'P'),
(193019, 'Anthem', 33.8672218322754, 0.591094529476512, -112.146110534668, -1.95731887213545, 218, 5, 'PPL', 'P'),
(74997, 'Anthon', 35.7402801513672, 0.623785564226535, -99.0127792358398, -1.72809899921568, 218, 42, 'PPL', 'P'),
(114420, 'Anthon', 42.3883285522461, 0.739815897653816, -95.8663864135742, -1.67318408490603, 218, 16, 'PPL', 'P'),
(53194, 'Anthonies Mill', 38.079719543457, 0.664616484269357, -91.0861129760742, -1.58975257427603, 218, 29, 'PPL', 'P'),
(15007, 'Anthony', 29.2891693115234, 0.511192439660165, -82.1119384765625, -1.43312368161103, 218, 12, 'PPL', 'P'),
(31655, 'Anthony', 37.1533317565918, 0.648447967238295, -98.0308303833008, -1.71096075865269, 218, 20, 'PPL', 'P'),
(44394, 'Anthony', 38.8777809143066, 0.678545282823662, -75.7886123657227, -1.32276082129955, 218, 25, 'PPL', 'P'),
(71676, 'Anthony', 39.2361106872559, 0.68479931716955, -81.9824981689453, -1.43086452205832, 218, 41, 'PPL', 'P'),
(107994, 'Anthony', 37.8958282470703, 0.661406975681648, -80.3322219848633, -1.40206176907884, 218, 58, 'PPL', 'P'),
(122148, 'Anthony', 40.2777786254883, 0.702979852404167, -85.4361114501953, -1.49114144490674, 218, 19, 'PPL', 'P'),
(133963, 'Anthony', 47.3461112976074, 0.826345530158934, -96.6658325195313, -1.68713705164723, 218, 28, 'PPL', 'P'),
(144755, 'Anthony', 40.7483291625977, 0.711192508573753, -74.8816680908203, -1.30693165757039, 218, 37, 'PPL', 'P'),
(169255, 'Anthony', 41.6949996948242, 0.727715026292714, -71.5497207641602, -1.24877820621715, 218, 47, 'PPL', 'P'),
(188054, 'Anthony', 32.0038909912109, 0.558573271245982, -106.605278015137, -1.86061310136806, 218, 38, 'PPL', 'P'),
(191080, 'Anthony', 31.9991703033447, 0.558490879699758, -106.605003356934, -1.8606083076781, 218, 51, 'PPL', 'P'),
(18872, 'Anthony Crossroads', 33.5897216796875, 0.586251238139067, -82.5416717529297, -1.44062394218902, 218, 13, 'PPL', 'P'),
(92284, 'Anthony Harbor', 31.2652797698975, 0.545682073541886, -94.1230621337891, -1.64275733629382, 218, 51, 'PPL', 'P'),
(84672, 'Anthony Hill', 35.1358299255371, 0.613235917621377, -87.1072235107422, -1.52030785253307, 218, 50, 'PPL', 'P'),
(7109, 'Anthony Subdivision', 35.0397186279297, 0.611558459029763, -90.3402786254883, -1.57673530918383, 218, 4, 'PPL', 'P'),
(122149, 'Anthony Wayne Village', 41.0394401550293, 0.716273353880433, -85.1055603027344, -1.4853722390373, 218, 19, 'PPL', 'P'),
(7110, 'Anthonyville', 35.0394401550293, 0.611553598760774, -90.3408279418945, -1.57674489656375, 218, 4, 'PPL', 'P'),
(44395, 'Anthonyville', 39.3377799987793, 0.68657378140387, -76.5522232055664, -1.33608834465874, 218, 25, 'PPL', 'P'),
(34571, 'Anthoston', 37.7594413757324, 0.659026575720308, -87.538330078125, -1.52783208156087, 218, 21, 'PPL', 'P'),
(158721, 'Anthracite', 40.274169921875, 0.702916868644386, -76.3983306884766, -1.33340241354134, 218, 45, 'PPL', 'P'),
(84673, 'Anthras', 36.5458297729492, 0.637845057411336, -83.9902801513672, -1.4659069283138, 218, 50, 'PPL', 'P'),
(44396, 'Antietam', 39.4161109924316, 0.687940915149462, -77.7425003051758, -1.35686259905801, 218, 25, 'PPL', 'P'),
(154077, 'Antietam (historical)', 41.3325004577637, 0.72138822107004, -80.5986099243164, -1.4067111157099, 218, 41, 'PPL', 'P'),
(44398, 'Antietam Farmettes', 39.523609161377, 0.689817112137423, -77.7119369506836, -1.35632916789167, 218, 25, 'PPL', 'P'),
(44399, 'Antietam Heights', 39.476390838623, 0.688992996938098, -77.6952819824219, -1.35603848385869, 218, 25, 'PPL', 'P'),
(44400, 'Antietam Manor', 39.5291709899902, 0.689914184359156, -77.7455596923828, -1.35691599543787, 218, 25, 'PPL', 'P'),
(44401, 'Antietam Overlook', 39.5213890075684, 0.689778363143562, -77.6986083984375, -1.35609654077045, 218, 25, 'PPL', 'P'),
(172932, 'Antigo', 45.1402816772461, 0.787846540545613, -89.1522216796875, -1.55599980377842, 218, 57, 'PPL', 'P'),
(192470, 'Antimony', 38.1169395446777, 0.665266095838255, -111.998893737793, -1.95474945431575, 218, 52, 'PPL', 'P'),
(7111, 'Antimony (historical)', 34.1930618286133, 0.596781510247295, -94.2058334350586, -1.64420196802713, 218, 4, 'PPL', 'P'),
(7116, 'Antioch', 35.1355590820313, 0.613231190510442, -91.9169387817383, -1.6042532200954, 218, 4, 'PPL', 'P'),
(15008, 'Antioch', 28.0466709136963, 0.489506751667327, -82.2491683959961, -1.4355187955374, 218, 12, 'PPL', 'P'),
(18877, 'Antioch', 33.1074981689453, 0.57783485014609, -85.1699981689453, -1.48649689196564, 218, 13, 'PPL', 'P'),
(31658, 'Antioch', 38.723331451416, 0.675849631168284, -94.9452819824219, -1.65710777982771, 218, 20, 'PPL', 'P'),
(34572, 'Antioch', 38.5663909912109, 0.67311050340811, -84.2927780151367, -1.47118651201683, 218, 21, 'PPL', 'P'),
(39118, 'Antioch', 32.586109161377, 0.568734895280316, -92.7388916015625, -1.61859900309738, 218, 22, 'PPL', 'P'),
(58473, 'Antioch', 31.6336097717285, 0.552110644807714, -89.0580596923828, -1.55435636706973, 218, 30, 'PPL', 'P'),
(62539, 'Antioch', 36.1533317565918, 0.630994674718352, -81.0213928222656, -1.41409006930024, 218, 33, 'PPL', 'P'),
(71678, 'Antioch', 39.6599998474121, 0.69219757867779, -81.0680618286133, -1.41490459711964, 218, 41, 'PPL', 'P'),
(74999, 'Antioch', 34.0999984741211, 0.595157248298456, -96.8280563354492, -1.68996839136014, 218, 42, 'PPL', 'P'),
(79542, 'Antioch', 33.4797210693359, 0.584331365309229, -79.5966720581055, -1.38922400104411, 218, 48, 'PPL', 'P'),
(84685, 'Antioch', 36.3558311462402, 0.634528955800996, -86.254997253418, -1.50543369837081, 218, 50, 'PPL', 'P'),
(92293, 'Antioch', 32.2019386291504, 0.562029854603824, -95.2586135864258, -1.66257644796813, 218, 51, 'PPL', 'P'),
(99429, 'Antioch', 38.8588905334473, 0.678215583480711, -77.686393737793, -1.35588335472519, 218, 53, 'PPL', 'P'),
(107996, 'Antioch', 39.3236083984375, 0.686326440317629, -79.0177764892578, -1.37912036734251, 218, 58, 'PPL', 'P'),
(112785, 'Antioch', 32.3499984741211, 0.564613986388555, -86.4552764892578, -1.50892923045959, 218, 2, 'PPL', 'P'),
(118630, 'Antioch', 42.4772186279297, 0.741367322146841, -88.0955581665039, -1.53755754638767, 218, 18, 'PPL', 'P'),
(122151, 'Antioch', 40.3677787780762, 0.704550651394123, -84.9422225952148, -1.48252145824842, 218, 19, 'PPL', 'P'),
(139012, 'Antioch', 40.3247184753418, 0.703799107334502, -91.6930618286133, -1.60034583014403, 218, 29, 'PPL', 'P'),
(179763, 'Antioch', 38.0050010681152, 0.663312400862573, -121.804718017578, -2.12589337387, 218, 6, 'PPL', 'P'),
(199148, 'Antioch', 42.0683288574219, 0.734230849373756, -102.581672668457, -1.79038794026765, 218, 35, 'PPL', 'P'),
(7117, 'Antioch (historical)', 34.1722183227539, 0.59641772244239, -94.3591690063477, -1.64687817860655, 218, 4, 'PPL', 'P'),
(18878, 'Antioch (historical)', 30.7708301544189, 0.537052299766566, -83.8436126708984, -1.46334709787401, 218, 13, 'PPL', 'P'),
(58472, 'Antioch (historical)', 32.8380584716797, 0.573132240293228, -88.5800018310547, -1.54601268337451, 218, 30, 'PPL', 'P'),
(84686, 'Antioch (historical)', 36.2125015258789, 0.632027382010057, -87.4199981689453, -1.52576680013551, 218, 50, 'PPL', 'P'),
(92294, 'Antioch (historical)', 31.0972194671631, 0.542748867917273, -95.5038909912109, -1.66685734626238, 218, 51, 'PPL', 'P'),
(79543, 'Antioch Acres', 34.707218170166, 0.605755231277399, -80.6547164916992, -1.40769036004272, 218, 48, 'PPL', 'P'),
(112790, 'Antioch Estates', 34.2458305358887, 0.597702497931272, -85.6430587768555, -1.49475335713516, 218, 2, 'PPL', 'P'),
(99430, 'Antioch Fork', 38.0175018310547, 0.663530580334877, -77.3380584716797, -1.3498037574307, 218, 53, 'PPL', 'P'),
(29106, 'Antioch Grange', 38.7372207641602, 0.676092045406509, -85.4702835083008, -1.49173785983286, 218, 19, 'PPL', 'P'),
(84687, 'Antioch Harbor Resort', 36.3608283996582, 0.634616174326696, -88.128059387207, -1.53812479969986, 218, 50, 'PPL', 'P'),
(39119, 'Antioch Villa', 30.3786106109619, 0.530206777342572, -91.0038909912109, -1.58831752992264, 218, 22, 'PPL', 'P'),
(71679, 'Antiquity', 38.9469413757324, 0.679752360587741, -81.9063873291016, -1.42953613730659, 218, 41, 'PPL', 'P'),
(122152, 'Antiville', 40.497501373291, 0.706814737794853, -84.9786071777344, -1.48315648901035, 218, 19, 'PPL', 'P'),
(107995, 'Antler', 37.4533309936523, 0.653683941678473, -81.623893737793, -1.42460569402247, 218, 58, 'PPL', 'P'),
(197944, 'Antler', 48.9708290100098, 0.854702203655826, -101.281936645508, -1.76770326726041, 218, 34, 'PPL', 'P'),
(53196, 'Antler (historical)', 37.2166709899902, 0.649553445406787, -92.293327331543, -1.6108224395563, 218, 29, 'PPL', 'P'),
(75000, 'Antlers', 34.2311096191406, 0.597445569465106, -95.620002746582, -1.66888387869388, 218, 42, 'PPL', 'P'),
(99431, 'Antlers', 36.6705589294434, 0.640021991865394, -78.320556640625, -1.36695158537362, 218, 53, 'PPL', 'P'),
(129537, 'Antlers', 46.7544403076172, 0.81601892329507, -87.6558303833008, -1.52988284875828, 218, 27, 'PPL', 'P'),
(186343, 'Antlers', 39.5433311462402, 0.690161325708315, -107.72721862793, -1.88019465907314, 218, 7, 'PPL', 'P'),
(193349, 'Antlers', 40.8955612182617, 0.71376219270957, -122.370002746582, -2.13575945360236, 218, 6, 'PPL', 'P'),
(133965, 'Antlers Park', 44.6630592346191, 0.779517437657363, -93.2652816772461, -1.62778624306788, 218, 28, 'PPL', 'P'),
(7121, 'Antoine', 34.0361099243164, 0.594042182750039, -93.4205627441406, -1.6304964089512, 218, 4, 'PPL', 'P'),
(129538, 'Antoine', 45.8375015258789, 0.800015322514512, -88.0619430541992, -1.53697085199953, 218, 27, 'PPL', 'P'),
(34573, 'Anton', 37.3519401550293, 0.651914337713142, -87.3947219848633, -1.52532564750094, 218, 21, 'PPL', 'P'),
(172935, 'Anton', 46.6191711425781, 0.813658030988715, -92.2352828979492, -1.60980937307763, 218, 57, 'PPL', 'P'),
(186344, 'Anton', 39.7416687011719, 0.693622969072228, -103.216667175293, -1.80147068514402, 218, 7, 'PPL', 'P'),
(192959, 'Anton', 33.8111114501953, 0.590115218564663, -102.163330078125, -1.78308648466504, 218, 51, 'PPL', 'P'),
(188055, 'Anton Chico', 35.2000007629395, 0.614355910017809, -105.141670227051, -1.83506832650813, 218, 38, 'PPL', 'P'),
(44447, 'Anton North', 39.4019393920898, 0.687693574063221, -76.7244415283203, -1.33909412142306, 218, 25, 'PPL', 'P'),
(44403, 'Anton Woods', 39.4000015258789, 0.687659751917377, -76.7261123657227, -1.339123283037, 218, 25, 'PPL', 'P'),
(200332, 'Antone (historical)', 44.4716682434082, 0.776177034702076, -119.808891296387, -2.09105962628593, 218, 43, 'PPL', 'P'),
(39120, 'Antonia', 31.5641708374023, 0.550898706774647, -92.4091720581055, -1.61284431145589, 218, 22, 'PPL', 'P'),
(53197, 'Antonia', 38.3624992370605, 0.669551920980519, -90.4655609130859, -1.57892189759684, 218, 29, 'PPL', 'P'),
(31659, 'Antonino', 38.7838897705078, 0.676906573225909, -99.392219543457, -1.73472148189838, 218, 20, 'PPL', 'P'),
(39121, 'Antonio', 30.4061107635498, 0.530686745550031, -91.2247161865234, -1.5921716566522, 218, 22, 'PPL', 'P'),
(179764, 'Antonio', 34.8352813720703, 0.607990355801275, -120.568893432617, -2.10432416588534, 218, 6, 'PPL', 'P'),
(92295, 'Antonio Santos Colonia', 27.6509990692139, 0.482600975223669, -99.6190032958984, -1.73867960506851, 218, 51, 'PPL', 'P'),
(71680, 'Antonis', 39.1838912963867, 0.683887916865498, -82.9274978637695, -1.44735787816334, 218, 41, 'PPL', 'P'),
(186345, 'Antonito', 37.0791702270508, 0.64715360436949, -106.008056640625, -1.85018962201955, 218, 7, 'PPL', 'P'),
(77789, 'Antram', 39.9116706848145, 0.696590063421712, -79.9169387817383, -1.39481370985608, 218, 45, 'PPL', 'P'),
(79544, 'Antreville', 34.3038902282715, 0.598715830726047, -82.5425033569336, -1.44063845641696, 218, 48, 'PPL', 'P'),
(7123, 'Antrey (historical)', 34.098331451416, 0.595128153263546, -94.4180603027344, -1.64790602562927, 218, 4, 'PPL', 'P'),
(39122, 'Antrim', 32.8772201538086, 0.573815740586996, -93.7050018310547, -1.63546080753922, 218, 22, 'PPL', 'P'),
(53198, 'Antrim', 37.189998626709, 0.649087924848241, -92.6483306884766, -1.61701841699042, 218, 29, 'PPL', 'P'),
(99432, 'Antrim', 38.8936080932617, 0.678821519207731, -77.1941680908203, -1.34729239652276, 218, 53, 'PPL', 'P'),
(129541, 'Antrim', 44.8899993896484, 0.78347829056761, -85.0738906860352, -1.48481949995305, 218, 27, 'PPL', 'P'),
(143467, 'Antrim', 43.0308303833008, 0.751029670055812, -71.9394378662109, -1.25558005279926, 218, 36, 'PPL', 'P'),
(146831, 'Antrim', 41.1238899230957, 0.717747280385738, -74.1416702270508, -1.29401625838989, 218, 40, 'PPL', 'P'),
(154078, 'Antrim', 40.1202812194824, 0.700231004106014, -81.3586120605469, -1.41997565530931, 218, 41, 'PPL', 'P'),
(158723, 'Antrim', 41.6338882446289, 0.726648430276137, -77.2872161865234, -1.34891639215549, 218, 45, 'PPL', 'P'),
(129539, 'Antrim Center', 42.8136100769043, 0.747238460507003, -84.1144409179688, -1.4680739424928, 218, 27, 'PPL', 'P'),
(143468, 'Antrim Center', 43.0502815246582, 0.75136915651577, -71.9661102294922, -1.25604557335781, 218, 36, 'PPL', 'P'),
(146832, 'Antwerp', 44.1991691589355, 0.771421028469358, -75.6072235107422, -1.31959498855372, 218, 40, 'PPL', 'P'),
(154080, 'Antwerp', 41.1813888549805, 0.718750826063507, -84.7405624389648, -1.47900182455177, 218, 41, 'PPL', 'P'),
(53199, 'Anutt', 37.7158317565918, 0.658265444280763, -91.7197189331055, -1.60081108438647, 218, 29, 'PPL', 'P'),
(212284, 'Anvik', 62.6561088562012, 1.09355539602869, -160.206665039063, -2.79613378857133, 218, 1, 'PPL', 'P'),
(71681, 'Anvil', 39.9913902282715, 0.697981431933224, -80.834716796875, -1.41083195802263, 218, 41, 'PPL', 'P'),
(129544, 'Anvil', 46.4702796936035, 0.811059384976043, -90.0183334350586, -1.57111630559987, 218, 27, 'PPL', 'P'),
(186346, 'Anvil Points', 39.5161094665527, 0.689686217769845, -107.922218322754, -1.88359804578821, 218, 7, 'PPL', 'P'),
(79545, 'Anvil Rock', 34.5730590820313, 0.603413713467974, -80.7169418334961, -1.40877639713526, 218, 48, 'PPL', 'P'),
(179766, 'Anza', 32.8002815246582, 0.572472908186351, -115.497497558594, -2.01581161021157, 218, 6, 'PPL', 'P'),
(188063, 'Anzac', 35.0686111450195, 0.612062728582169, -107.726112365723, -1.88017535115524, 218, 38, 'PPL', 'P'),
(18880, 'Aonia', 33.6752815246582, 0.587744539141302, -82.6233291625977, -1.44204913284638, 218, 13, 'PPL', 'P'),
(75002, 'Apache', 34.8936080932617, 0.609008349127958, -98.3655624389648, -1.716802935136, 218, 42, 'PPL', 'P'),
(188062, 'Apache', 33.3252792358398, 0.581635846811905, -105.902221679688, -1.84834245348747, 218, 38, 'PPL', 'P'),
(193021, 'Apache', 31.6902809143066, 0.55309974283657, -109.13166809082, -1.90470692637845, 218, 5, 'PPL', 'P'),
(193020, 'Apache Acres Trailer Park', 33.4172210693359, 0.583240534526732, -111.601387023926, -1.94781165335998, 218, 5, 'PPL', 'P'),
(186347, 'Apache City', 37.8583297729492, 0.660752503843761, -104.830558776855, -1.82963840736157, 218, 7, 'PPL', 'P'),
(188064, 'Apache Creek', 33.8330612182617, 0.590498314287471, -108.624443054199, -1.89585417944086, 218, 38, 'PPL', 'P'),
(53200, 'Apache Flats', 38.583610534668, 0.673411041137126, -92.2994384765625, -1.61092909915795, 218, 29, 'PPL', 'P'),
(193098, 'Apache Flats', 31.5580596923828, 0.550792047172989, -110.361938476563, -1.92617919529943, 218, 5, 'PPL', 'P'),
(193023, 'Apache Grove', 32.8697204589844, 0.573684846219419, -109.189720153809, -1.90572012601517, 218, 5, 'PPL', 'P'),
(193024, 'Apache Junction', 33.4150009155273, 0.583201785532872, -111.548889160156, -1.94689539278694, 218, 5, 'PPL', 'P'),
(188065, 'Apache Springs', 35.3722190856934, 0.617361686782127, -105.192497253418, -1.83595542546724, 218, 38, 'PPL', 'P'),
(193026, 'Apache Wells', 33.4594383239746, 0.58397736462133, -111.71028137207, -1.94971221827192, 218, 5, 'PPL', 'P'),
(193100, 'Apache West Mobile Village', 33.413890838623, 0.583182411035941, -111.853889465332, -1.95221865233184, 218, 5, 'PPL', 'P'),
(75003, 'Apache Wye', 35.0436096191406, 0.61162636963756, -98.3563919067383, -1.71664287915449, 218, 42, 'PPL', 'P'),
(79546, 'Apalache', 34.961109161377, 0.610186465015181, -82.2122192382813, -1.43487391107943, 218, 48, 'PPL', 'P'),
(18881, 'Apalachee', 33.6863899230957, 0.587938417268659, -83.4311065673828, -1.45614750818309, 218, 13, 'PPL', 'P'),
(84690, 'Apalachia', 35.1680603027344, 0.613798443822629, -84.3227767944336, -1.47171008948714, 218, 50, 'PPL', 'P'),
(15013, 'Apalachicola', 29.7255592346191, 0.51880888064071, -84.9833297729492, -1.48323891384609, 218, 12, 'PPL', 'P'),
(146834, 'Apalachin', 42.0694389343262, 0.734250223870686, -76.1549987792969, -1.32915547055099, 218, 40, 'PPL', 'P'),
(7124, 'Apalco', 33.3583297729492, 0.582212687504016, -93.4599990844727, -1.63118470293493, 218, 4, 'PPL', 'P'),
(29105, 'Apalona', 38.1544418334961, 0.665920634255169, -86.6322174072266, -1.51201743205965, 218, 19, 'PPL', 'P'),
(146835, 'Apaquogue', 40.9427795410156, 0.714586307908895, -72.2125015258789, -1.26034591272802, 218, 40, 'PPL', 'P'),
(7125, 'Apex', 34.9997215270996, 0.610860377929026, -94.4358291625977, -1.64821615073821, 218, 4, 'PPL', 'P'),
(34574, 'Apex', 37.0974998474121, 0.647473516595435, -87.3411102294922, -1.52438994585194, 218, 21, 'PPL', 'P'),
(53201, 'Apex', 39.1108283996582, 0.68261272875654, -90.754997253418, -1.58397351471055, 218, 29, 'PPL', 'P'),
(62543, 'Apex', 35.7324981689453, 0.623649743010941, -78.8505630493164, -1.37620194226195, 218, 33, 'PPL', 'P'),
(146836, 'Apex', 42.0672187805176, 0.734211474876826, -75.2494430541992, -1.31335054158775, 218, 40, 'PPL', 'P'),
(154081, 'Apex', 40.4102783203125, 0.705292408336737, -80.9094390869141, -1.41213610800844, 218, 41, 'PPL', 'P'),
(179767, 'Apex', 38.7269401550293, 0.675912614928064, -120.822219848633, -2.10874554592709, 218, 6, 'PPL', 'P'),
(189880, 'Apex', 36.3291702270508, 0.634063634979532, -114.926940917969, -2.00585351826355, 218, 39, 'PPL', 'P'),
(193101, 'Apex', 35.9430618286133, 0.627324772157196, -112.184997558594, -1.95799757873926, 218, 5, 'PPL', 'P'),
(195883, 'Apex', 45.3819389343262, 0.792064255342998, -112.706390380859, -1.96709760018406, 218, 31, 'PPL', 'P'),
(107997, 'Apgah (historical)', 38.4252815246582, 0.670647678611032, -81.3027801513672, -1.41900120466645, 218, 58, 'PPL', 'P'),
(195884, 'Apgar', 48.5277786254883, 0.846969515693699, -113.992218017578, -1.98953952605794, 218, 31, 'PPL', 'P'),
(79547, 'Apia (historical)', 33.5033302307129, 0.584743422908891, -81.540283203125, -1.42314641490316, 218, 48, 'PPL', 'P'),
(200333, 'Apiary', 46.0141716003418, 0.803098797003633, -123.02889251709, -2.14725924950543, 218, 43, 'PPL', 'P'),
(84689, 'Apison', 35.0238914489746, 0.611282222645695, -85.0238876342773, -1.48394678206383, 218, 50, 'PPL', 'P'),
(7126, 'Aplin', 34.9738883972168, 0.610409504756475, -92.9786071777344, -1.6227828291699, 218, 4, 'PPL', 'P'),
(107998, 'Aplin (historical)', 38.7472190856934, 0.676266549036936, -81.5897216796875, -1.42400927909635, 218, 58, 'PPL', 'P'),
(129545, 'Aplin Beach', 43.6508293151855, 0.761850692776049, -83.8708267211914, -1.46382207265443, 218, 27, 'PPL', 'P'),
(114421, 'Aplington', 42.584171295166, 0.743233998333905, -92.8841705322266, -1.62113459877125, 218, 16, 'PPL', 'P'),
(188066, 'Apodaca', 36.1986083984375, 0.631784901192806, -105.861671447754, -1.84763471842778, 218, 38, 'PPL', 'P'),
(158725, 'Apollo', 40.5813903808594, 0.708278877183152, -79.5666732788086, -1.3887004235738, 218, 45, 'PPL', 'P'),
(179768, 'Apollo', 35.3416709899902, 0.616828521931894, -116.873611450195, -2.03982932850245, 218, 6, 'PPL', 'P'),
(18882, 'Apollo (historical)', 33.3652801513672, 0.582333994491669, -83.5277786254883, -1.45783475389171, 218, 13, 'PPL', 'P'),
(15014, 'Apollo Beach', 27.7727794647217, 0.484726444089662, -82.4077835083008, -1.43828715149053, 218, 12, 'PPL', 'P'),
(193027, 'Apollo Mobile Home Park', 33.5830612182617, 0.586134991157485, -112.268333435059, -1.95945206416861, 218, 5, 'PPL', 'P'),
(84691, 'Apollo Shores', 35.7461090087891, 0.623887296980176, -84.7491683959961, -1.47915202683725, 218, 50, 'PPL', 'P'),
(172936, 'Apollonia', 45.4500007629395, 0.793252158347228, -91.3013916015625, -1.59350989509996, 218, 57, 'PPL', 'P'),
(92296, 'Apolonia', 30.4930591583252, 0.532204281318186, -95.9097213745117, -1.67394042265561, 218, 51, 'PPL', 'P'),
(58474, 'Aponaug (historical)', 33.0583305358887, 0.576976713063839, -89.6194381713867, -1.56415426987818, 218, 30, 'PPL', 'P'),
(193028, 'Aponi-vi', 35.8813896179199, 0.626248389023613, -110.713333129883, -1.93231218897377, 218, 5, 'PPL', 'P'),
(15015, 'Apopka', 28.6802806854248, 0.500565328356799, -81.5097198486328, -1.42261298373682, 218, 12, 'PPL', 'P'),
(99433, 'Appalachia', 36.9066696166992, 0.644142900757155, -82.7819366455078, -1.44481735564146, 218, 53, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(143470, 'Appalachia', 44.3711090087891, 0.774421944964687, -71.2897186279297, -1.24424031287771, 218, 36, 'PPL', 'P'),
(112794, 'Appalachian', 33.8847198486328, 0.591399927474517, -86.4019393920898, -1.50799832250056, 218, 2, 'PPL', 'P'),
(26383, 'Appalokia (historical)', 39.5902786254883, 0.690980713796706, -89.9877777099609, -1.57058300759158, 218, 18, 'PPL', 'P'),
(118632, 'Appaloosa West', 41.9025001525879, 0.731336592480085, -88.4161071777344, -1.54315218204766, 218, 18, 'PPL', 'P'),
(197943, 'Appam', 48.5699996948242, 0.847706412367324, -103.588333129883, -1.80795747976918, 218, 34, 'PPL', 'P'),
(44404, 'Appeal', 38.3675003051758, 0.669639206085247, -76.4486083984375, -1.33427992512052, 218, 25, 'PPL', 'P'),
(92297, 'Appelt Hill', 29.5180606842041, 0.515187347742852, -96.9086074829102, -1.6913742740996, 218, 51, 'PPL', 'P'),
(158727, 'Appenzell', 40.9927787780762, 0.715458959219087, -75.3555603027344, -1.31520263696785, 218, 45, 'PPL', 'P'),
(75004, 'Apperson', 36.7511100769043, 0.641427874604846, -96.7658309936523, -1.68888235426761, 218, 42, 'PPL', 'P'),
(99434, 'Appersons Store', 37.6358299255371, 0.656869148921235, -77.1747207641602, -1.34695297664183, 218, 53, 'PPL', 'P'),
(62544, 'Appie', 35.5958290100098, 0.621264416201584, -77.7452774047852, -1.35691106858985, 218, 33, 'PPL', 'P'),
(838, 'Apple', 34.127498626709, 0.595637216505915, -95.4172210693359, -1.66534467076322, 218, 42, 'PPL', 'P'),
(71682, 'Apple', 39.4027786254883, 0.687708221449216, -82.7072219848633, -1.4435133388137, 218, 41, 'PPL', 'P'),
(195885, 'Apple Blossom Court', 46.5038909912109, 0.81164601278516, -114.08528137207, -1.99116378800678, 218, 31, 'PPL', 'P'),
(53207, 'Apple Creek', 37.5825004577637, 0.655938374120252, -89.7377777099609, -1.5662196844616, 218, 29, 'PPL', 'P'),
(154082, 'Apple Creek', 40.7516708374023, 0.711250831801626, -81.8394393920898, -1.42836767537831, 218, 41, 'PPL', 'P'),
(172937, 'Apple Creek', 44.3255615234375, 0.773626991379298, -88.3744430541992, -1.54242500591201, 218, 57, 'PPL', 'P'),
(44405, 'Apple Greene', 38.7161102294922, 0.675723597069696, -76.654167175293, -1.33786760258302, 218, 25, 'PPL', 'P'),
(34575, 'Apple Grove', 37.0552787780762, 0.64673661992181, -86.0727767944336, -1.50225335139704, 218, 21, 'PPL', 'P'),
(44406, 'Apple Grove', 38.788330078125, 0.676984071213631, -76.9611129760742, -1.34322481743183, 218, 25, 'PPL', 'P'),
(62546, 'Apple Grove', 36.5286102294922, 0.63754451968232, -81.5849990844727, -1.42392685426061, 218, 33, 'PPL', 'P'),
(71683, 'Apple Grove', 38.8866691589355, 0.678700411957159, -81.8677825927734, -1.4288623575508, 218, 41, 'PPL', 'P'),
(99437, 'Apple Grove', 37.8927803039551, 0.661353779038874, -77.897216796875, -1.3595629112453, 218, 53, 'PPL', 'P'),
(108000, 'Apple Grove', 37.4375, 0.653407638715377, -81.8050003051758, -1.42776659992028, 218, 58, 'PPL', 'P'),
(112797, 'Apple Grove', 34.398609161377, 0.600368987972713, -86.6102828979492, -1.51163460265295, 218, 2, 'PPL', 'P'),
(99438, 'Apple Mountain Lake', 38.9241714477539, 0.679354950374074, -78.1016693115234, -1.3631312807899, 218, 53, 'PPL', 'P'),
(99439, 'Apple Mountain Lake West', 38.934440612793, 0.679534181115436, -78.1197204589844, -1.36344633274685, 218, 53, 'PPL', 'P'),
(44407, 'Apple Ridge', 39.3791694641113, 0.687296163849554, -76.5111083984375, -1.33537075590302, 218, 25, 'PPL', 'P'),
(62547, 'Apple Ridge', 36.1100006103516, 0.630238403547797, -81.6427764892578, -1.42493526020737, 218, 33, 'PPL', 'P'),
(118644, 'Apple River', 42.5050010681152, 0.741852217202317, -90.0986099243164, -1.57251739464936, 218, 18, 'PPL', 'P'),
(92298, 'Apple Springs', 31.2233295440674, 0.544949903979196, -94.9661102294922, -1.65747130131651, 218, 51, 'PPL', 'P'),
(7129, 'Apple Spur', 36.3561096191406, 0.634533816069986, -94.1613922119141, -1.64342632235965, 218, 4, 'PPL', 'P'),
(99442, 'Apple Tree Village', 37.3555603027344, 0.651977521210005, -79.898063659668, -1.39448427682924, 218, 53, 'PPL', 'P'),
(18883, 'Apple Valley', 34.1586112976074, 0.596180235052182, -83.5094375610352, -1.45751464192869, 218, 13, 'PPL', 'P'),
(79550, 'Apple Valley', 34.0550003051758, 0.594371882092991, -81.0983276367188, -1.41543283512185, 218, 48, 'PPL', 'P'),
(133968, 'Apple Valley', 44.7319412231445, 0.780719655152452, -93.2174987792969, -1.62695227417253, 218, 28, 'PPL', 'P'),
(179769, 'Apple Valley', 34.5008316040039, 0.602153106165985, -117.184997558594, -2.04526404133898, 218, 6, 'PPL', 'P'),
(194526, 'Apple Valley', 43.8400001525879, 0.765152346737475, -116.995559692383, -2.04195772684564, 218, 17, 'PPL', 'P'),
(197946, 'Apple Valley', 46.8216705322266, 0.817192312071359, -100.597503662109, -1.75575765819086, 218, 34, 'PPL', 'P'),
(202889, 'Apple Valley', 40.6177787780762, 0.708913974524108, -111.793060302734, -1.95115698316328, 218, 52, 'PPL', 'P'),
(84692, 'Apple Valley Estates', 36.1477813720703, 0.6308978022337, -85.5527801513672, -1.49317769787621, 218, 50, 'PPL', 'P'),
(179770, 'Apple Valley Estates', 38.0111083984375, 0.663418993885203, -120.327781677246, -2.10011597188885, 218, 6, 'PPL', 'P'),
(179771, 'Apple Valley Highlands', 34.3911094665527, 0.600238093605136, -117.216667175293, -2.04581678042322, 218, 6, 'PPL', 'P'),
(99441, 'Apple View Estates', 39.2611083984375, 0.685235609535132, -78.1138916015625, -1.36334459999321, 218, 53, 'PPL', 'P'),
(158729, 'Applebachsville', 40.4824981689453, 0.706552882480671, -75.2733306884766, -1.31376745945641, 218, 45, 'PPL', 'P'),
(7130, 'Appleby', 36.021110534668, 0.628686979054771, -94.2461090087891, -1.64490490939686, 218, 4, 'PPL', 'P'),
(92299, 'Appleby', 31.7161102294922, 0.553550549430093, -94.6047210693359, -1.65116387059076, 218, 51, 'PPL', 'P'),
(169739, 'Appleby', 44.8169403076172, 0.78220316903768, -97.0502777099609, -1.69384688601368, 218, 49, 'PPL', 'P'),
(206696, 'Appledale', 47.3544387817383, 0.826490872175425, -119.973327636719, -2.09392958183465, 218, 56, 'PPL', 'P'),
(144756, 'Applegarth', 40.2783317565918, 0.702989506363118, -74.4730606079102, -1.29980011164532, 218, 37, 'PPL', 'P'),
(44408, 'Applegarth (historical)', 38.2447204589844, 0.667496293514114, -76.1402816772461, -1.32889860866385, 218, 25, 'PPL', 'P'),
(26384, 'Applegate', 38.792781829834, 0.677061768938434, -87.7966690063477, -1.53234094644442, 218, 18, 'PPL', 'P'),
(129546, 'Applegate', 43.355281829834, 0.756692416060675, -82.6372222900391, -1.44229161366363, 218, 27, 'PPL', 'P'),
(179772, 'Applegate', 39.0008316040039, 0.680692922505729, -120.991386413574, -2.1116980594696, 218, 6, 'PPL', 'P'),
(200334, 'Applegate', 42.2572212219238, 0.737527643066192, -123.167221069336, -2.14967353819164, 218, 43, 'PPL', 'P'),
(202891, 'Applegate Condo', 40.6561088562012, 0.709582960589936, -111.911109924316, -1.95321733774062, 218, 52, 'PPL', 'P'),
(146837, 'Applegate Corner', 42.4513893127441, 0.740916515553318, -76.6116714477539, -1.33712591221944, 218, 40, 'PPL', 'P'),
(7132, 'Appleton', 35.4252815246582, 0.618287801051202, -92.8741683959961, -1.62096002856179, 218, 4, 'PPL', 'P'),
(44410, 'Appleton', 39.6983299255371, 0.692866564743618, -75.8144378662109, -1.32321156131405, 218, 25, 'PPL', 'P'),
(53204, 'Appleton', 37.5972213745117, 0.656195302586418, -89.7127838134766, -1.56578345867504, 218, 29, 'PPL', 'P'),
(77791, 'Appleton', 39.9130592346191, 0.696614298187632, -76.6316680908203, -1.33747491948029, 218, 45, 'PPL', 'P'),
(79549, 'Appleton', 33.0433311462402, 0.576714924328684, -81.3630599975586, -1.42005328645509, 218, 48, 'PPL', 'P'),
(84693, 'Appleton', 35.023609161377, 0.611277295797678, -87.2333297729492, -1.52250882201596, 218, 50, 'PPL', 'P'),
(112798, 'Appleton', 31.2208309173584, 0.544906294716346, -87.1213912963867, -1.52055512704028, 218, 2, 'PPL', 'P'),
(118635, 'Appleton', 40.9358291625977, 0.714465000921242, -90.1608276367188, -1.57360329858384, 218, 18, 'PPL', 'P'),
(126764, 'Appleton', 44.2891693115234, 0.772991827459314, -69.2513885498047, -1.20866474177199, 218, 26, 'PPL', 'P'),
(133970, 'Appleton', 45.1969413757324, 0.788835438837386, -96.0194396972656, -1.67585536863743, 218, 28, 'PPL', 'P'),
(146838, 'Appleton', 43.3274993896484, 0.756207521005199, -78.6483306884766, -1.37267232171121, 218, 40, 'PPL', 'P'),
(154083, 'Appleton', 40.209171295166, 0.70178242859904, -82.6163864135742, -1.44192795901678, 218, 41, 'PPL', 'P'),
(172939, 'Appleton', 44.2619400024414, 0.77251658636279, -88.415283203125, -1.54313780097777, 218, 57, 'PPL', 'P'),
(186348, 'Appleton', 39.1208305358887, 0.682787298965995, -108.607498168945, -1.89555843540181, 218, 7, 'PPL', 'P'),
(194527, 'Appleton', 42.7480583190918, 0.746094366502705, -114.634437561035, -2.00074837161192, 218, 17, 'PPL', 'P'),
(206697, 'Appleton', 45.811939239502, 0.799569176452896, -121.269996643066, -2.11656072530398, 218, 56, 'PPL', 'P'),
(44411, 'Appleton Acres', 39.7013893127441, 0.692919961123474, -75.8172225952148, -1.32326016400394, 218, 25, 'PPL', 'P'),
(53205, 'Appleton City', 38.190559387207, 0.666551004485191, -94.029167175293, -1.64111856011704, 218, 29, 'PPL', 'P'),
(44412, 'Appleton Glen', 39.7041702270508, 0.692968497234341, -75.8152770996094, -1.32322620870004, 218, 25, 'PPL', 'P'),
(44413, 'Appletown', 39.4805603027344, 0.689065767814884, -77.6477813720703, -1.35520944181135, 218, 25, 'PPL', 'P'),
(158730, 'Appletree Hill', 40.1602783203125, 0.700929085206751, -74.8438873291016, -1.30627225888449, 218, 45, 'PPL', 'P'),
(84694, 'Applewalk Park', 36.4630584716797, 0.636400425678022, -82.5069427490234, -1.44001780672492, 218, 50, 'PPL', 'P'),
(158734, 'Applewold', 40.8086090087891, 0.712244590362389, -79.5219421386719, -1.38791971790025, 218, 45, 'PPL', 'P'),
(18884, 'Applewood', 34.0944404602051, 0.595060242655749, -84.4674987792969, -1.47423596462302, 218, 13, 'PPL', 'P'),
(58475, 'Applewood', 34.2897186279297, 0.598468489639805, -88.7225036621094, -1.54849980951654, 218, 30, 'PPL', 'P'),
(84695, 'Applewood', 35.1480598449707, 0.613449369982746, -85.3363876342773, -1.48940093597631, 218, 50, 'PPL', 'P'),
(99448, 'Applewood', 37.3269386291504, 0.651477978768533, -79.8777770996094, -1.39413020956231, 218, 53, 'PPL', 'P'),
(186349, 'Applewood', 39.7472190856934, 0.693719841556879, -105.162216186523, -1.83542692114891, 218, 7, 'PPL', 'P'),
(202892, 'Applewood', 40.6450004577637, 0.709389082462578, -111.829170227051, -1.95178722023525, 218, 52, 'PPL', 'P'),
(141177, 'Applewood Mobile Home Park', 40.6827812194824, 0.710048481148482, -95.8647232055664, -1.67315505645015, 218, 35, 'PPL', 'P'),
(206698, 'Appleyard', 47.3977813720703, 0.827247343083062, -120.301940917969, -2.09966496555824, 218, 56, 'PPL', 'P'),
(18885, 'Appling', 33.5458297729492, 0.585485179851506, -82.3161087036133, -1.43668712430761, 218, 13, 'PPL', 'P'),
(44414, 'Appolds', 39.6272201538086, 0.691625465096614, -77.3219375610352, -1.34952239446154, 218, 25, 'PPL', 'P'),
(99444, 'Appomattoc (historical)', 37.3416709899902, 0.65173510697178, -77.2736129760742, -1.34867897134431, 218, 53, 'PPL', 'P'),
(99445, 'Appomattox', 37.3569412231445, 0.65200162281787, -78.8255615234375, -1.37576558331734, 218, 53, 'PPL', 'P'),
(99446, 'Appomattox (historical)', 37.3772201538086, 0.652355556926741, -78.7966690063477, -1.37526131376494, 218, 53, 'PPL', 'P'),
(124117, 'Apponagansett', 41.601390838623, 0.726081243542977, -70.9625015258789, -1.23852929707809, 218, 23, 'PPL', 'P'),
(169256, 'Apponaug', 41.7002792358398, 0.72780717166643, -71.4602813720703, -1.2472171943442, 218, 47, 'PPL', 'P'),
(158732, 'Apps', 40.7661094665527, 0.711502833419774, -75.5819396972656, -1.31915370276109, 218, 45, 'PPL', 'P'),
(206699, 'Apricot', 46.2366714477539, 0.806982151926159, -119.856391906738, -2.09188866833327, 218, 56, 'PPL', 'P'),
(202894, 'April Acres', 40.7019386291504, 0.710382841023342, -112.080558776855, -1.95617477813116, 218, 52, 'PPL', 'P'),
(44415, 'April Estates', 38.660831451416, 0.674758800385788, -76.620002746582, -1.33727132081495, 218, 25, 'PPL', 'P'),
(202895, 'April Meadows', 40.6349983215332, 0.709214512253124, -111.990280151367, -1.95459911887221, 218, 52, 'PPL', 'P'),
(193029, 'Apron Crossing', 34.4833297729492, 0.601847641588953, -113.046943664551, -1.97304137626296, 218, 5, 'PPL', 'P'),
(144757, 'Apshawa', 41.0175018310547, 0.715890457894707, -74.3633270263672, -1.29788489934739, 218, 37, 'PPL', 'P'),
(7133, 'Apt', 35.774169921875, 0.624377052304641, -90.6722183227539, -1.58252874981919, 218, 4, 'PPL', 'P'),
(118636, 'Aptakisic', 42.1824989318848, 0.73622349308038, -87.9472198486328, -1.53496855433395, 218, 18, 'PPL', 'P'),
(143471, 'Apthorp', 44.3077812194824, 0.773316666533277, -71.7427825927734, -1.25214777078637, 218, 36, 'PPL', 'P'),
(179774, 'Aptos', 36.9772186279297, 0.645374213287153, -121.898330688477, -2.12752722319876, 218, 6, 'PPL', 'P'),
(53208, 'Aptus', 38.0402793884277, 0.663928123706599, -90.8483276367188, -1.5856024371913, 218, 29, 'PPL', 'P'),
(146839, 'Apulia', 42.8238906860352, 0.747417890985447, -76.0538864135742, -1.32739072685465, 218, 40, 'PPL', 'P'),
(146840, 'Apulia Station', 42.8186111450195, 0.74732574561173, -76.0727767944336, -1.3277204261976, 218, 40, 'PPL', 'P'),
(124118, 'Aqawam (historical)', 42.6791687011719, 0.744892015849561, -70.841667175293, -1.23642033981085, 218, 23, 'PPL', 'P'),
(77792, 'Aqua', 39.9119415283203, 0.696594790532647, -77.6172180175781, -1.354676010645, 218, 45, 'PPL', 'P'),
(18887, 'Aqua (historical)', 33.5161094665527, 0.584966462650185, -83.4902801513672, -1.45718028205383, 218, 13, 'PPL', 'P'),
(75005, 'Aqua Park', 35.6202812194824, 0.621691187766269, -95.0758285522461, -1.65938624729833, 218, 42, 'PPL', 'P'),
(112799, 'Aqua Vista', 34.8302803039551, 0.607903070696547, -87.4852828979492, -1.5269062336079, 218, 2, 'PPL', 'P'),
(177446, 'Aqua Vista', 41.4461097717285, 0.723371077659658, -73.4444427490234, -1.28184734326293, 218, 8, 'PPL', 'P'),
(62549, 'Aquadale', 35.2272186279297, 0.614830951377252, -80.225830078125, -1.40020488000878, 218, 33, 'PPL', 'P'),
(44416, 'Aquahart Manor', 39.1500015258789, 0.683296428787391, -76.628059387207, -1.33741193572051, 218, 25, 'PPL', 'P'),
(44417, 'Aquasco', 38.5849990844727, 0.673435275903046, -76.7252807617188, -1.33910876880906, 218, 25, 'PPL', 'P'),
(158733, 'Aquashicola', 40.8111114501953, 0.712288266204266, -75.5905609130859, -1.31930417136268, 218, 45, 'PPL', 'P'),
(146841, 'Aquebogue', 40.9444389343262, 0.71461526978575, -72.6275024414063, -1.26758904510276, 218, 40, 'PPL', 'P'),
(146842, 'Aqueduct', 42.8480606079102, 0.747839735702115, -73.8894424438477, -1.28961405310799, 218, 40, 'PPL', 'P'),
(158735, 'Aquetong', 40.351390838623, 0.704264627893048, -75.0036087036133, -1.30905992275553, 218, 45, 'PPL', 'P'),
(146843, 'Aquetuck', 42.4605598449707, 0.741076571534832, -73.8388900756836, -1.28873174783884, 218, 40, 'PPL', 'P'),
(15016, 'Aqui Esta', 26.9061107635498, 0.46960022173023, -82.0472183227539, -1.43199410183468, 218, 12, 'PPL', 'P'),
(99449, 'Aquia', 38.4822196960449, 0.671641437171795, -77.3869400024414, -1.35065690108591, 218, 53, 'PPL', 'P'),
(99450, 'Aquia Harbour', 38.4625015258789, 0.67129729017993, -77.3891677856445, -1.35069578323783, 218, 53, 'PPL', 'P'),
(53209, 'Aquilla', 36.9469413757324, 0.644845775547854, -89.9147186279297, -1.56930788606165, 218, 29, 'PPL', 'P'),
(92300, 'Aquilla', 31.851390838623, 0.55591164147353, -97.2177810668945, -1.69677037110032, 218, 51, 'PPL', 'P'),
(112192, 'Aquilla', 31.7122192382813, 0.553482638822296, -88.4138870239258, -1.5431134330538, 218, 2, 'PPL', 'P'),
(154084, 'Aquilla', 41.5724983215332, 0.725576973990571, -81.1544418334961, -1.41641221261273, 218, 41, 'PPL', 'P'),
(62550, 'Aquone', 35.207218170166, 0.61448187753737, -83.6272201538086, -1.45957033597412, 218, 33, 'PPL', 'P'),
(194089, 'Ara', 40.0250015258789, 0.698568059742341, -105.249717712402, -1.83695411087602, 218, 7, 'PPL', 'P'),
(53211, 'Arab', 37.0708312988281, 0.647008062615917, -90.1194381713867, -1.57288091613816, 218, 29, 'PPL', 'P'),
(112801, 'Arab', 34.3180618286133, 0.598963171812288, -86.4958267211914, -1.50963696551928, 218, 2, 'PPL', 'P'),
(188067, 'Arabela', 33.5869407653809, 0.5862027020282, -105.172782897949, -1.8356113450544, 218, 38, 'PPL', 'P'),
(188068, 'Arabella', 34.8636093139648, 0.608484771657648, -104.78360748291, -1.82881895269415, 218, 38, 'PPL', 'P'),
(18888, 'Arabi', 31.8313903808594, 0.555562567633648, -83.7380599975586, -1.46150485618995, 218, 13, 'PPL', 'P'),
(39123, 'Arabi', 29.9541702270508, 0.522798895164894, -90.0052795410156, -1.57088847216861, 218, 22, 'PPL', 'P'),
(29107, 'Arabia', 39.7661094665527, 0.694049540899831, -87.3219375610352, -1.52405531966097, 218, 19, 'PPL', 'P'),
(62551, 'Arabia', 34.9500007629395, 0.609992586887824, -79.1258316040039, -1.38100628486845, 218, 33, 'PPL', 'P'),
(71684, 'Arabia', 38.6580581665039, 0.674710397432975, -82.4736099243164, -1.43943603918479, 218, 41, 'PPL', 'P'),
(146845, 'Arabia', 42.5338897705078, 0.742356420175697, -74.6361083984375, -1.30264583242813, 218, 40, 'PPL', 'P'),
(199149, 'Arabia', 42.7311096191406, 0.745798555884624, -100.372222900391, -1.75182576715747, 218, 35, 'PPL', 'P'),
(199811, 'Arabia', 40.3636093139648, 0.704477880517336, -118.391670227051, -2.06632445239738, 218, 39, 'PPL', 'P'),
(13289, 'Arabian Acres', 38.7355613708496, 0.676063083529654, -75.2266693115234, -1.31295306479506, 218, 10, 'PPL', 'P'),
(179775, 'Arabian Gardens Mobile Home Park', 33.7305603027344, 0.58870933582521, -116.240562438965, -2.02878053892999, 218, 6, 'PPL', 'P'),
(193025, 'Araby', 32.6755599975586, 0.570296106890348, -114.521392822266, -1.99877536871834, 218, 5, 'PPL', 'P'),
(44418, 'Araby View', 39.353889465332, 0.686854944635955, -77.3858337402344, -1.35063759316801, 218, 25, 'PPL', 'P'),
(108001, 'Aracoma', 37.8588905334473, 0.660762290960767, -81.9922180175781, -1.43103416541976, 218, 58, 'PPL', 'P'),
(133973, 'Arago', 47.0511093139648, 0.821196774244457, -95.1613922119141, -1.66087961487959, 218, 28, 'PPL', 'P'),
(200335, 'Arago', 43.1022186279297, 0.752275629971806, -124.191108703613, -2.16754374858024, 218, 43, 'PPL', 'P'),
(141178, 'Arago (historical)', 40.1525001525879, 0.700793330570184, -95.477783203125, -1.66640167939987, 218, 35, 'PPL', 'P'),
(18889, 'Aragon', 34.0455589294434, 0.594207099000542, -85.0561065673828, -1.484509108528, 218, 13, 'PPL', 'P'),
(188070, 'Aragon', 33.8811111450195, 0.591336943714737, -108.538330078125, -1.89435122447968, 218, 38, 'PPL', 'P'),
(193031, 'Aragon Place', 32.9722213745117, 0.57547382468168, -109.356941223145, -1.90863868425379, 218, 5, 'PPL', 'P'),
(62552, 'Aragona Village', 34.7641716003418, 0.606749256154271, -77.3466720581055, -1.34995409287424, 218, 33, 'PPL', 'P'),
(99452, 'Aragona Village', 36.8488883972168, 0.643134428231369, -76.1494369506836, -1.32905839832926, 218, 53, 'PPL', 'P'),
(202896, 'Aragonite', 40.7427787780762, 0.711095636089101, -113.001937866211, -1.97225587689944, 218, 52, 'PPL', 'P'),
(191081, 'Arah', 32.7580604553223, 0.571736011512726, -101.134719848633, -1.7651338494407, 218, 51, 'PPL', 'P'),
(129547, 'Aral (historical)', 44.7622184753418, 0.781248092891751, -86.0747222900391, -1.50228730670094, 218, 27, 'PPL', 'P'),
(92302, 'Aransas Pass', 27.9091701507568, 0.487106910630029, -97.1497192382813, -1.69558246809609, 218, 51, 'PPL', 'P'),
(75006, 'Arapaho', 35.5777816772461, 0.620949430823655, -98.9641723632813, -1.72725064925044, 218, 42, 'PPL', 'P'),
(62553, 'Arapahoe', 35.0255584716797, 0.611311317680604, -76.8258285522461, -1.34086365880936, 218, 33, 'PPL', 'P'),
(141181, 'Arapahoe', 40.3041687011719, 0.703440446114696, -99.9000015258789, -1.74358394937395, 218, 35, 'PPL', 'P'),
(186350, 'Arapahoe', 38.8499984741211, 0.678060387768186, -102.181671142578, -1.78340659662806, 218, 7, 'PPL', 'P'),
(209274, 'Arapahoe', 42.9622192382813, 0.749832179671658, -108.489166259766, -1.89349315397645, 218, 59, 'PPL', 'P'),
(15017, 'Araquey', 29.9461097717285, 0.52265821368031, -81.3375015258789, -1.4196072069725, 218, 12, 'PPL', 'P'),
(18891, 'Ararat', 32.0611114501953, 0.559571956654762, -83.1263885498047, -1.45082917548621, 218, 13, 'PPL', 'P'),
(39124, 'Ararat', 30.3002796173096, 0.528839643596979, -93.1997222900391, -1.62664201590553, 218, 22, 'PPL', 'P'),
(62554, 'Ararat', 36.4038887023926, 0.635367718386317, -80.5608291625977, -1.406051717024, 218, 33, 'PPL', 'P'),
(79559, 'Ararat', 32.978328704834, 0.57558041770431, -80.0036087036133, -1.39632638535524, 218, 48, 'PPL', 'P'),
(99453, 'Ararat', 36.5988883972168, 0.638771105101383, -80.5108337402344, -1.40517913229283, 218, 53, 'PPL', 'P'),
(112803, 'Ararat', 31.9680595397949, 0.557947894443005, -88.1466674804688, -1.53844957219479, 218, 2, 'PPL', 'P'),
(158736, 'Ararat', 41.8294410705566, 0.730061470950155, -75.5250015258789, -1.31815994420033, 218, 45, 'PPL', 'P'),
(179776, 'Arastraville', 37.9980583190918, 0.663191227032974, -120.225830078125, -2.09833658080651, 218, 6, 'PPL', 'P'),
(34576, 'Arat', 36.7566719055176, 0.64152494682658, -85.4652786254883, -1.4916505081491, 218, 21, 'PPL', 'P'),
(193032, 'Aravaipa', 32.957218170166, 0.575211969367498, -110.354438781738, -1.92604830093185, 218, 5, 'PPL', 'P'),
(179777, 'Araz Junction', 32.7472190856934, 0.571546793917276, -114.713607788086, -2.00213015274351, 218, 6, 'PPL', 'P'),
(729, 'Arba', 35.4011116027832, 0.617865956334534, -77.7024993896484, -1.35616445137825, 218, 33, 'PPL', 'P'),
(122153, 'Arba', 40.0108299255371, 0.6983207186561, -84.866943359375, -1.48120758772463, 218, 19, 'PPL', 'P'),
(112802, 'Arbacoochee (historical)', 33.5761108398438, 0.586013684169832, -85.517219543457, -1.49255704818417, 218, 2, 'PPL', 'P'),
(92303, 'Arbala', 32.9874992370605, 0.575740473685824, -95.6530609130859, -1.66946085254404, 218, 51, 'PPL', 'P'),
(7134, 'Arbaugh', 35.7816696166992, 0.624507946672219, -93.5013885498047, -1.63190708538062, 218, 4, 'PPL', 'P'),
(71685, 'Arbaugh', 39.1733283996582, 0.683703559539037, -82.3377838134766, -1.43706542634046, 218, 41, 'PPL', 'P'),
(179785, 'Arbee', 39.211109161377, 0.68436295822494, -121.994720458984, -2.12920954205937, 218, 6, 'PPL', 'P'),
(139013, 'Arbela', 40.4625015258789, 0.706203875219817, -92.0166702270508, -1.60599386218387, 218, 29, 'PPL', 'P'),
(154085, 'Arbela', 40.4816703796387, 0.706538434831758, -83.4069366455078, -1.45572566346643, 218, 41, 'PPL', 'P'),
(179778, 'Arbios', 36.776668548584, 0.641873954087435, -120.396942138672, -2.10132304965293, 218, 6, 'PPL', 'P'),
(58476, 'Arbo', 31.7266693115234, 0.553734840177527, -89.6338882446289, -1.56440647123341, 218, 30, 'PPL', 'P'),
(71688, 'Arbocrest Acres', 39.2133293151855, 0.684401707218801, -84.414436340332, -1.47330985035395, 218, 41, 'PPL', 'P'),
(179779, 'Arboga', 39.0513916015625, 0.681575360932927, -121.554718017578, -2.12153005074001, 218, 6, 'PPL', 'P'),
(179780, 'Arbolada', 34.4497184753418, 0.601261013779835, -119.257217407227, -2.0814311005228, 218, 6, 'PPL', 'P'),
(186352, 'Arboles', 37.0280609130859, 0.646261578562368, -107.418609619141, -1.87480841576846, 218, 7, 'PPL', 'P'),
(194528, 'Arbon', 42.4558296203613, 0.740994013541039, -112.567497253418, -1.96467345780182, 218, 17, 'PPL', 'P'),
(53212, 'Arbor', 37.1591682434082, 0.648549833149991, -89.8022232055664, -1.56734447054799, 218, 29, 'PPL', 'P'),
(77793, 'Arbor', 39.8802795410156, 0.696042184606456, -76.6227798461914, -1.33731979034679, 218, 45, 'PPL', 'P'),
(92308, 'Arbor', 31.2941703796387, 0.546186309804779, -95.2944412231445, -1.66320175819208, 218, 51, 'PPL', 'P'),
(141184, 'Arbor', 40.8955612182617, 0.71376219270957, -96.6727828979492, -1.68725835863488, 218, 35, 'PPL', 'P'),
(179781, 'Arbor', 37.961669921875, 0.662556129692017, -121.722221374512, -2.12445353582665, 218, 6, 'PPL', 'P'),
(62562, 'Arbor Acres', 35.7986106872559, 0.624803624132245, -80.2272186279297, -1.4002291147747, 218, 33, 'PPL', 'P'),
(202897, 'Arbor Estates', 40.6644401550293, 0.709728369185455, -111.826393127441, -1.95173875070341, 218, 52, 'PPL', 'P'),
(202898, 'Arbor Estates Condominium', 40.6644401550293, 0.709728369185455, -111.826393127441, -1.95173875070341, 218, 52, 'PPL', 'P'),
(18892, 'Arbor Forest', 33.9333305358887, 0.592248344018789, -84.6180572509766, -1.4768637056706, 218, 13, 'PPL', 'P'),
(44419, 'Arbor Greene', 38.6911087036133, 0.675287238125087, -76.6313934326172, -1.33747012579033, 218, 25, 'PPL', 'P'),
(7136, 'Arbor Grove', 36.0183296203613, 0.628638442943904, -91.0475006103516, -1.58907866136218, 218, 4, 'PPL', 'P'),
(206700, 'Arbor Heights', 47.5175018310547, 0.829336859274339, -122.375556945801, -2.13585639266604, 218, 56, 'PPL', 'P'),
(99454, 'Arbor Hill', 38.0997200012207, 0.664965558109239, -79.1527786254883, -1.38147659911696, 218, 53, 'PPL', 'P'),
(114423, 'Arbor Hill', 41.3666687011719, 0.721984569417136, -94.3180618286133, -1.64616072300889, 218, 16, 'PPL', 'P'),
(114424, 'Arbor Lake Mobile Home Community', 41.7355613708496, 0.728422961089484, -92.7297210693359, -1.61843894711587, 218, 16, 'PPL', 'P'),
(99456, 'Arbor Meadows', 36.8697204589844, 0.643498016299192, -76.4638900756836, -1.33454664070369, 218, 53, 'PPL', 'P'),
(99457, 'Arbor Park', 38.1222190856934, 0.665358241211971, -78.5088882446289, -1.37023859194905, 218, 53, 'PPL', 'P'),
(13290, 'Arbor Pointe Apartments', 39.7113914489746, 0.693094531332929, -75.6477813720703, -1.32030285677146, 218, 10, 'PPL', 'P'),
(18893, 'Arbor Ridge', 33.7869415283203, 0.589693373847994, -84.105827331543, -1.46792360704926, 218, 13, 'PPL', 'P'),
(53213, 'Arbor Terrace', 38.7000007629395, 0.675442433837611, -90.283332824707, -1.57574141746501, 218, 29, 'PPL', 'P'),
(18894, 'Arbor Trace', 34.0166702270508, 0.593702896027163, -84.0366668701172, -1.46671652928518, 218, 13, 'PPL', 'P'),
(172941, 'Arbor Vitae', 45.9205589294434, 0.801464947674869, -89.663330078125, -1.56492032816575, 218, 57, 'PPL', 'P'),
(18895, 'Arbor Walk', 33.8311080932617, 0.590464225825518, -84.8694381713867, -1.48125113040845, 218, 13, 'PPL', 'P'),
(18896, 'Arbor West', 33.5530586242676, 0.585611347108148, -84.4697189331055, -1.47427471361688, 218, 13, 'PPL', 'P'),
(44420, 'Arboranda Estates', 39.6833305358887, 0.692604776008463, -77.7888870239258, -1.3576722000294, 218, 25, 'PPL', 'P'),
(44421, 'Arbordale', 39.1452789306641, 0.683214003951653, -76.6166687011719, -1.33721313074514, 218, 25, 'PPL', 'P'),
(108002, 'Arborland Acres', 38.3913917541504, 0.670056190532926, -81.8638916015625, -1.428794446943, 218, 58, 'PPL', 'P'),
(44422, 'Arborview', 38.4972190856934, 0.67190322590695, -76.7827835083008, -1.34011238106585, 218, 25, 'PPL', 'P'),
(79552, 'Arborville', 34.2922210693359, 0.598512165481683, -82.3475036621094, -1.4372350697019, 218, 48, 'PPL', 'P'),
(141185, 'Arborville', 41.0227813720703, 0.715982603268424, -97.774169921875, -1.70648118854113, 218, 35, 'PPL', 'P'),
(44423, 'Arborwood', 39.4638900756836, 0.688774817465793, -76.791389465332, -1.34026258335133, 218, 25, 'PPL', 'P'),
(202899, 'Arborwood Park', 40.6605606079102, 0.709660658314739, -111.828330993652, -1.95177257284926, 218, 52, 'PPL', 'P'),
(44424, 'Arbour Green', 39.398609161377, 0.68763545057243, -76.4569396972656, -1.33442533371604, 218, 25, 'PPL', 'P'),
(44425, 'Arbour Manor', 39.2430610656738, 0.684920624157203, -76.6997222900391, -1.33866268932647, 218, 25, 'PPL', 'P'),
(13291, 'Arbour Park', 39.6541709899902, 0.692095845924149, -75.7652816772461, -1.32235362396888, 218, 10, 'PPL', 'P'),
(108003, 'Arbovale', 38.4352798461914, 0.67082218224146, -79.8177795410156, -1.39308305462169, 218, 58, 'PPL', 'P'),
(13292, 'Arbre Park Mobile Home Park', 38.7099990844727, 0.675616937468038, -75.2038879394531, -1.31255545484431, 218, 10, 'PPL', 'P'),
(39126, 'Arbroth', 30.610279083252, 0.534250154957098, -91.3188934326172, -1.593815359677, 218, 22, 'PPL', 'P'),
(108004, 'Arbuckle', 38.7127799987793, 0.675665473578905, -81.9483337402344, -1.43026824029025, 218, 58, 'PPL', 'P'),
(158738, 'Arbuckle', 41.982780456543, 0.732737748108603, -79.8641662597656, -1.39389265559308, 218, 45, 'PPL', 'P'),
(179782, 'Arbuckle', 39.0175018310547, 0.680983872854821, -122.056671142578, -2.13029078546194, 218, 6, 'PPL', 'P'),
(99458, 'Arbuckle Landing', 36.5927810668945, 0.638664512078753, -76.3850021362305, -1.33316978642012, 218, 53, 'PPL', 'P'),
(118638, 'Arbury Hills', 41.5355606079102, 0.72493228926969, -87.8475036621094, -1.53322817856158, 218, 18, 'PPL', 'P'),
(44426, 'Arbutus', 39.2544403076172, 0.685119229395496, -76.7002792358398, -1.33867240986445, 218, 25, 'PPL', 'P'),
(133976, 'Arbutus', 48.3069381713867, 0.843115122648027, -93.0475006103516, -1.62398524640207, 218, 28, 'PPL', 'P'),
(113104, 'Arbutus Beach', 44.9461097717285, 0.78445760147946, -84.6833267211914, -1.47800287282688, 218, 27, 'PPL', 'P'),
(108006, 'Arbutus Park', 39.2663917541504, 0.685327821487876, -80.3238906860352, -1.40191636048332, 218, 58, 'PPL', 'P'),
(53214, 'Arbyrd', 36.0508308410645, 0.629205696256091, -90.2386093139648, -1.57496084494951, 218, 29, 'PPL', 'P'),
(18897, 'Arcade', 34.0777816772461, 0.59476949204374, -83.5616683959961, -1.45842624196982, 218, 13, 'PPL', 'P'),
(146846, 'Arcade', 42.5338897705078, 0.742356420175697, -78.4233322143555, -1.36874535752584, 218, 40, 'PPL', 'P'),
(179783, 'Arcade', 38.475830078125, 0.671529917301148, -121.57861328125, -2.12194710176672, 218, 6, 'PPL', 'P'),
(191082, 'Arcade', 31.8027801513672, 0.555063224929258, -102.445556640625, -1.78801226741725, 218, 51, 'PPL', 'P'),
(179784, 'Arcade (historical)', 38.6366691589355, 0.674337088827174, -121.406936645508, -2.11895077922427, 218, 6, 'PPL', 'P'),
(172943, 'Arcade Acres', 43.8586082458496, 0.76547711923241, -88.8708267211914, -1.55108853525415, 218, 57, 'PPL', 'P'),
(7137, 'Arcadia', 33.8422203063965, 0.590658170531903, -93.4658279418945, -1.63128643568857, 218, 4, 'PPL', 'P'),
(15018, 'Arcadia', 27.2155609130859, 0.475001145710424, -81.8586120605469, -1.42870230156928, 218, 12, 'PPL', 'P'),
(26385, 'Arcadia', 39.839168548584, 0.695324662429761, -90.2447204589844, -1.57506750455117, 218, 18, 'PPL', 'P'),
(31663, 'Arcadia', 37.6419410705566, 0.656975808522893, -94.6236114501953, -1.65149356993371, 218, 20, 'PPL', 'P'),
(39127, 'Arcadia', 32.5488891601563, 0.568085283711419, -92.9199981689453, -1.6217599089952, 218, 22, 'PPL', 'P'),
(44427, 'Arcadia', 39.0958290100098, 0.682350940021386, -76.4291687011719, -1.33394063839765, 218, 25, 'PPL', 'P'),
(53215, 'Arcadia', 37.5880584716797, 0.656035379762958, -90.6288909912109, -1.58177254522766, 218, 29, 'PPL', 'P'),
(62557, 'Arcadia', 36.0708312988281, 0.629554770095973, -80.2461090087891, -1.40055881411765, 218, 33, 'PPL', 'P'),
(75009, 'Arcadia', 35.6666717529297, 0.622500855316681, -97.3263931274414, -1.69866600916423, 218, 42, 'PPL', 'P'),
(79553, 'Arcadia', 34.9580612182617, 0.610133268372407, -81.9908294677734, -1.43100993065384, 218, 48, 'PPL', 'P'),
(84697, 'Arcadia', 36.5852813720703, 0.638533617711176, -82.4580612182617, -1.43916466306971, 218, 50, 'PPL', 'P'),
(92306, 'Arcadia', 31.7630596160889, 0.554369970807997, -94.3402786254883, -1.6465484792636, 218, 51, 'PPL', 'P'),
(99460, 'Arcadia', 38.1063919067383, 0.665082004827903, -77.5299987792969, -1.35315374776592, 218, 53, 'PPL', 'P'),
(114425, 'Arcadia', 42.0872192382813, 0.734560548716708, -95.0458297729492, -1.65886266982802, 218, 16, 'PPL', 'P'),
(122154, 'Arcadia', 40.1758308410645, 0.701200527900857, -86.0216674804688, -1.50136132558991, 218, 19, 'PPL', 'P'),
(129550, 'Arcadia', 44.4930610656738, 0.776550409886905, -86.2316665649414, -1.50502650104014, 218, 27, 'PPL', 'P'),
(141188, 'Arcadia', 41.4233283996582, 0.722973467708909, -99.1258316040039, -1.73007213526732, 218, 35, 'PPL', 'P'),
(154089, 'Arcadia', 41.1083297729492, 0.717475704533577, -83.5169372558594, -1.45764553629626, 218, 41, 'PPL', 'P'),
(158739, 'Arcadia', 40.7811088562012, 0.711764622154929, -78.852783203125, -1.37624069125581, 218, 45, 'PPL', 'P'),
(169257, 'Arcadia', 41.5555610656738, 0.725281363109572, -71.6972198486328, -1.25135255088487, 218, 47, 'PPL', 'P'),
(172944, 'Arcadia', 44.2527809143066, 0.772356730118357, -91.5013885498047, -1.59700050034073, 218, 57, 'PPL', 'P'),
(179786, 'Arcadia', 34.139720916748, 0.59585053570923, -118.034439086914, -2.06008959281134, 218, 6, 'PPL', 'P'),
(200336, 'Arcadia', 43.9244384765625, 0.766626073505698, -116.984443664551, -2.04176371556023, 218, 43, 'PPL', 'P'),
(202904, 'Arcadia', 40.2224998474121, 0.702015055720258, -110.236671447754, -1.92399287320253, 218, 52, 'PPL', 'P'),
(206702, 'Arcadia', 47.1980590820313, 0.823761531532258, -122.938331604004, -2.14567866339847, 218, 56, 'PPL', 'P'),
(58477, 'Arcadia (historical)', 32.648609161377, 0.569825726062813, -91.1255569458008, -1.59044100141781, 218, 30, 'PPL', 'P'),
(99461, 'Arcadia Farm', 39.1313896179199, 0.682971589713429, -77.9141693115234, -1.35985878844241, 218, 53, 'PPL', 'P'),
(79554, 'Arcadia Heights', 34.9561080932617, 0.610099179910454, -82, -1.43116998663535, 218, 48, 'PPL', 'P'),
(79555, 'Arcadia Lakes', 34.0536117553711, 0.594347647327071, -80.9613876342773, -1.41304278120156, 218, 48, 'PPL', 'P'),
(99462, 'Arcadia Mobile Home Park', 39.1972198486328, 0.684120543986716, -78.1372222900391, -1.36375179732389, 218, 53, 'PPL', 'P'),
(92307, 'Arcadia Park', 32.749439239502, 0.571585542911137, -96.9102783203125, -1.69140343571353, 218, 51, 'PPL', 'P'),
(44428, 'Arcadia Shores', 38.7638893127441, 0.676557499386027, -76.1608276367188, -1.32925720330463, 218, 25, 'PPL', 'P'),
(84698, 'Arcadia Shores', 35.3638916015625, 0.617216344765636, -85.0583267211914, -1.48454785752186, 218, 50, 'PPL', 'P'),
(129553, 'Arcadian', 47.1558303833008, 0.823024501700578, -88.5558319091797, -1.54559083865784, 218, 27, 'PPL', 'P'),
(79556, 'Arcadian Shores', 33.773609161377, 0.589460680147749, -78.7755584716797, -1.37489286542812, 218, 48, 'PPL', 'P'),
(122155, 'Arcana', 40.5386085510254, 0.707532193392521, -85.5033264160156, -1.49231456736692, 218, 19, 'PPL', 'P'),
(71686, 'Arcanum', 39.9900016784668, 0.697957197167304, -84.5533294677734, -1.47573399273619, 218, 41, 'PPL', 'P'),
(193350, 'Arcata', 40.8666687011719, 0.713257923157164, -124.081672668457, -2.16563372944643, 218, 6, 'PPL', 'P'),
(39128, 'Arceneaux', 30.2902793884277, 0.528665106677038, -92.2280578613281, -1.60968327240002, 218, 22, 'PPL', 'P'),
(75010, 'Arch', 34.7744407653809, 0.606928486895633, -95.6608276367188, -1.66959640744353, 218, 42, 'PPL', 'P'),
(188071, 'Arch', 34.1133308410645, 0.595389941998701, -103.141937255859, -1.80016640200015, 218, 38, 'PPL', 'P'),
(44429, 'Arch Bridge', 39.4477806091309, 0.688493654233708, -77.501106262207, -1.35264947821351, 218, 25, 'PPL', 'P'),
(200337, 'Arch Cape', 45.8291702270508, 0.799869913918993, -123.960830688477, -2.16352463902115, 218, 43, 'PPL', 'P'),
(158740, 'Arch Rock', 40.6074981689453, 0.708734544045664, -77.4186096191406, -1.35120964017016, 218, 45, 'PPL', 'P'),
(158741, 'Arch Spring', 40.6058311462402, 0.708705449010755, -78.2030563354492, -1.3649008181762, 218, 45, 'PPL', 'P'),
(194529, 'Archabal', 44.8469390869141, 0.78272674650799, -116.121109008789, -2.02669568327062, 218, 17, 'PPL', 'P'),
(158742, 'Archbald', 41.4947204589844, 0.72421949420393, -75.5372161865234, -1.31837313024559, 218, 45, 'PPL', 'P'),
(15019, 'Archbold', 27.1811103820801, 0.474399870515311, -81.3522186279297, -1.41986406885964, 218, 12, 'PPL', 'P'),
(154087, 'Archbold', 41.5213890075684, 0.724684948183449, -84.3072204589844, -1.471438580214, 218, 41, 'PPL', 'P'),
(62560, 'Archdale', 35.9144401550293, 0.626825229715724, -79.9722213745117, -1.39577857311901, 218, 33, 'PPL', 'P'),
(79558, 'Archdale', 33.9497184753418, 0.592534367519864, -80.366943359375, -1.40266777138489, 218, 48, 'PPL', 'P'),
(146849, 'Archdale', 43.0330581665039, 0.751068552207727, -73.4813919067383, -1.2824922277209, 218, 40, 'PPL', 'P'),
(44430, 'Arched Bow Valley', 39.6233291625977, 0.691557554488817, -76.8308334350586, -1.34095101049312, 218, 25, 'PPL', 'P'),
(15020, 'Archer', 29.5297203063965, 0.515390846539647, -82.519172668457, -1.44023125908629, 218, 12, 'PPL', 'P'),
(26387, 'Archer', 39.7813911437988, 0.694316256483003, -89.7358322143555, -1.5661857291577, 218, 18, 'PPL', 'P'),
(84699, 'Archer', 35.3280601501465, 0.616590967962658, -86.7597198486328, -1.51424276946652, 218, 50, 'PPL', 'P'),
(108007, 'Archer', 39.5105590820313, 0.689589345285194, -80.5952835083008, -1.40665305879814, 218, 58, 'PPL', 'P'),
(112400, 'Archer', 33.2972183227539, 0.58114609148744, -88.2216720581055, -1.53975864902862, 218, 2, 'PPL', 'P'),
(114427, 'Archer', 43.1152801513672, 0.752503596561117, -95.7455596923828, -1.67107526079685, 218, 16, 'PPL', 'P'),
(141190, 'Archer', 41.1652793884277, 0.718469662831422, -98.1355590820313, -1.71278861926687, 218, 35, 'PPL', 'P'),
(179787, 'Archer', 34.4205589294434, 0.600752083695521, -115.364723205566, -2.01349426058904, 218, 6, 'PPL', 'P'),
(186353, 'Archer', 39.5333290100098, 0.689986755498861, -105.076393127441, -1.83392902619379, 218, 7, 'PPL', 'P'),
(194530, 'Archer', 43.7136116027832, 0.762946450406563, -111.781936645508, -1.95096283871982, 218, 17, 'PPL', 'P'),
(195886, 'Archer', 48.792781829834, 0.851594694137867, -104.810279846191, -1.8292844732527, 218, 31, 'PPL', 'P'),
(141191, 'Archer (historical)', 40.0875015258789, 0.699658890524838, -95.5666732788086, -1.66795310389289, 218, 35, 'PPL', 'P'),
(99463, 'Archer Bluff', 37.2605590820313, 0.650319437115321, -77.3824996948242, -1.35057940309819, 218, 53, 'PPL', 'P'),
(92309, 'Archer City', 33.5955581665039, 0.586353104050763, -98.6252822875977, -1.72133590162742, 218, 51, 'PPL', 'P'),
(177180, 'Archer Heights', 40.3608283996582, 0.704429344406469, -80.6002807617188, -1.40674027732384, 218, 58, 'PPL', 'P'),
(144758, 'Archers Corner', 40.0883293151855, 0.699673338173751, -74.4558334350586, -1.29949944075825, 218, 37, 'PPL', 'P'),
(126766, 'Archers Corners', 44.8313903808594, 0.782455370392911, -68.4449996948242, -1.1945906012012, 218, 26, 'PPL', 'P'),
(71687, 'Archers Fork', 39.4833297729492, 0.689114104188669, -81.2058334350586, -1.41730916526787, 218, 41, 'PPL', 'P'),
(62564, 'Archers Lodge', 35.6938896179199, 0.622975896676123, -78.3758316040039, -1.3679163154785, 218, 33, 'PPL', 'P'),
(144759, 'Archertown', 40.0652809143066, 0.699271067691095, -74.5002822875977, -1.30027521958379, 218, 37, 'PPL', 'P'),
(18898, 'Archery', 32.026668548584, 0.558970814617704, -84.4483337402344, -1.47390147159011, 218, 13, 'PPL', 'P'),
(7138, 'Archey (historical)', 35.6483306884766, 0.622180743353653, -92.5258331298828, -1.61488043126731, 218, 4, 'PPL', 'P'),
(7151, 'Archey Valley', 35.6963882446289, 0.623019505938973, -92.7252807617188, -1.61836144912815, 218, 4, 'PPL', 'P'),
(39129, 'Archibald', 32.3488883972168, 0.564594611891624, -91.7772216796875, -1.60181469664327, 218, 22, 'PPL', 'P'),
(26388, 'Archie', 39.8941688537598, 0.69628459884468, -87.8283309936523, -1.53289355237062, 218, 18, 'PPL', 'P'),
(39130, 'Archie', 31.579719543457, 0.551170082889726, -91.9672164916992, -1.60513073167458, 218, 22, 'PPL', 'P'),
(53223, 'Archie', 38.4816703796387, 0.671631849791871, -94.3541717529297, -1.64679096008085, 218, 29, 'PPL', 'P'),
(188072, 'Archuleta', 36.7941703796387, 0.642179418664467, -107.70832824707, -1.87986495973019, 218, 38, 'PPL', 'P'),
(84700, 'Archville', 35.1327781677246, 0.613182654399575, -84.5255584716797, -1.4752492974178, 218, 50, 'PPL', 'P'),
(146850, 'Archville', 41.1216697692871, 0.717708531391877, -73.8616714477539, -1.28912935778959, 218, 40, 'PPL', 'P'),
(179788, 'Arcilla', 33.7833290100098, 0.589630323509187, -117.478607177734, -2.05038849590851, 218, 6, 'PPL', 'P'),
(18899, 'Arco', 31.2011108398438, 0.544562114434967, -81.5063934326172, -1.42255492682505, 218, 13, 'PPL', 'P'),
(99486, 'Arco', 38.8600006103516, 0.678234957977641, -78.1750030517578, -1.36441119600979, 218, 53, 'PPL', 'P'),
(133977, 'Arco', 44.3836097717285, 0.774640124436991, -96.1833267211914, -1.67871573680623, 218, 28, 'PPL', 'P'),
(194531, 'Arco', 43.6366691589355, 0.76160355142689, -113.299438476563, -1.97744824207676, 218, 17, 'PPL', 'P'),
(92311, 'Arco Iris Colonia', 26.2520008087158, 0.458183849348305, -98.3610000610352, -1.71672330661941, 218, 51, 'PPL', 'P'),
(92312, 'Arco Iris Number 2 Colonia', 26.2409992218018, 0.45799183543371, -98.1439971923828, -1.71293589207515, 218, 51, 'PPL', 'P'),
(18900, 'Arcola', 32.3433303833008, 0.564497606248918, -81.6022186279297, -1.42422739198962, 218, 13, 'PPL', 'P'),
(26389, 'Arcola', 39.6847190856934, 0.692629010774383, -88.3063888549805, -1.54123723606583, 218, 18, 'PPL', 'P'),
(31664, 'Arcola', 38.7508316040039, 0.676329599375744, -97.9333267211914, -1.70925899871613, 218, 20, 'PPL', 'P'),
(39131, 'Arcola', 30.7763900756836, 0.537149338698786, -90.5102767944336, -1.57970233695429, 218, 22, 'PPL', 'P'),
(44431, 'Arcola', 39.047779083252, 0.68151231059412, -77.0519409179688, -1.3448100640707, 218, 25, 'PPL', 'P'),
(53217, 'Arcola', 37.5491714477539, 0.655356673159152, -93.875, -1.63842783530968, 218, 29, 'PPL', 'P'),
(58478, 'Arcola', 33.269718170166, 0.58066612327998, -90.8797225952148, -1.58615038258558, 218, 30, 'PPL', 'P'),
(62565, 'Arcola', 36.2894401550293, 0.633370214410703, -77.9802780151367, -1.36101260298468, 218, 33, 'PPL', 'P'),
(92313, 'Arcola', 29.4958305358887, 0.514799358461541, -95.4655609130859, -1.66618836019655, 218, 51, 'PPL', 'P'),
(99464, 'Arcola', 38.9516716003418, 0.679834918581533, -77.5344390869141, -1.35323124575364, 218, 53, 'PPL', 'P'),
(108008, 'Arcola', 38.4666709899902, 0.671370061056716, -80.5194396972656, -1.40532933457831, 218, 58, 'PPL', 'P'),
(112810, 'Arcola', 32.5569381713867, 0.56822576545892, -87.7675018310547, -1.53183188320206, 218, 2, 'PPL', 'P'),
(122156, 'Arcola', 41.1036109924316, 0.717393346276866, -85.2941665649414, -1.48866403930269, 218, 19, 'PPL', 'P'),
(133979, 'Arcola', 45.1233291625977, 0.787550663348505, -92.7663879394531, -1.61907890472582, 218, 28, 'PPL', 'P'),
(144760, 'Arcola', 40.9258308410645, 0.714290497290815, -74.0897216796875, -1.29310958519677, 218, 37, 'PPL', 'P'),
(158749, 'Arcola', 40.1525001525879, 0.700793330570184, -75.4569396972656, -1.3169720411961, 218, 45, 'PPL', 'P'),
(209275, 'Arcola', 41.100830078125, 0.717344810165999, -104.456672668457, -1.82311286374255, 218, 59, 'PPL', 'P'),
(92314, 'Arcola Junction', 29.5027809143066, 0.514920665449194, -95.4622192382813, -1.66613003696868, 218, 51, 'PPL', 'P'),
(193034, 'Arcosanti', 34.3430595397949, 0.59939946417787, -112.099998474121, -1.95651406485403, 218, 5, 'PPL', 'P'),
(84701, 'Arcott', 36.5200004577637, 0.637394250817812, -85.5550003051758, -1.49321644687007, 218, 50, 'PPL', 'P'),
(146851, 'Arctic', 42.1855583190918, 0.736276889460237, -75.4147186279297, -1.31623514452247, 218, 40, 'PPL', 'P'),
(169258, 'Arctic', 41.7030601501465, 0.727855707777297, -71.5288925170898, -1.24841468472835, 218, 47, 'PPL', 'P'),
(29108, 'Arctic Springs', 38.2830581665039, 0.668165412737997, -85.7113876342773, -1.49594592067129, 218, 19, 'PPL', 'P'),
(212285, 'Arctic Village', 68.1269378662109, 1.18903937506698, -145.537780761719, -2.54011346033765, 218, 1, 'PPL', 'P'),
(99465, 'Arcturus', 38.7386093139648, 0.676116280172428, -77.0449981689453, -1.3446888902411, 218, 53, 'PPL', 'P'),
(112808, 'Arcus', 31.5136108398438, 0.550016268347449, -85.9752807617188, -1.50055172461853, 218, 2, 'PPL', 'P'),
(7141, 'Ard', 35.144718170166, 0.613391046754874, -93.1916732788086, -1.62650153415803, 218, 4, 'PPL', 'P'),
(79566, 'Ard Crossroads', 33.7836112976074, 0.589635250357203, -79.4366683959961, -1.38643141032505, 218, 48, 'PPL', 'P'),
(29109, 'Arda', 38.517219543457, 0.672252299746832, -87.2505569458008, -1.52280949290303, 218, 19, 'PPL', 'P'),
(158745, 'Ardara', 40.357780456543, 0.704376147763695, -79.7352828979492, -1.39164321657834, 218, 45, 'PPL', 'P'),
(53218, 'Ardath', 37.6100006103516, 0.656418342327712, -94.6050033569336, -1.65116879743878, 218, 29, 'PPL', 'P'),
(84702, 'Ardee (historical)', 36.5430603027344, 0.637796721037551, -87.6263885498047, -1.52936899182595, 218, 50, 'PPL', 'P'),
(108009, 'Ardel', 38.2705612182617, 0.667947299844719, -82.4555587768555, -1.43912098722784, 218, 58, 'PPL', 'P'),
(31665, 'Ardell', 37.901668548584, 0.661508908172371, -99.4961090087891, -1.73653469512656, 218, 20, 'PPL', 'P'),
(112809, 'Ardell', 33.9952812194824, 0.593329587421361, -87.0986099243164, -1.52015751708953, 218, 2, 'PPL', 'P'),
(7142, 'Arden', 33.6894416809082, 0.587991680490461, -94.2855606079102, -1.6455934696967, 218, 4, 'PPL', 'P'),
(13293, 'Arden', 39.8091697692871, 0.694801084959451, -75.4869384765625, -1.31749561866641, 218, 10, 'PPL', 'P'),
(53219, 'Arden', 36.985279083252, 0.645514894771737, -92.804443359375, -1.61974309710168, 218, 29, 'PPL', 'P'),
(62566, 'Arden', 35.4661102294922, 0.61900039637988, -82.5166702270508, -1.44018758324441, 218, 33, 'PPL', 'P'),
(84703, 'Arden', 35.4216690063477, 0.618224750712395, -84.4094390869141, -1.47322263182825, 218, 50, 'PPL', 'P'),
(108011, 'Arden', 39.4155616760254, 0.687931327769538, -78.0436096191406, -1.36211794799512, 218, 58, 'PPL', 'P'),
(129554, 'Arden', 41.9858283996582, 0.732790944751377, -86.3919372558594, -1.5078237522911, 218, 27, 'PPL', 'P'),
(146852, 'Arden', 41.2744407653809, 0.720374888275264, -74.1533279418945, -1.29421972389717, 218, 40, 'PPL', 'P'),
(158746, 'Arden', 40.2050018310547, 0.701709657722253, -80.2591705322266, -1.40078678070696, 218, 45, 'PPL', 'P'),
(189881, 'Arden', 36.0180587768555, 0.62863371583297, -115.230003356934, -2.01114295566261, 218, 39, 'PPL', 'P'),
(191083, 'Arden', 31.4436092376709, 0.548794509907861, -100.766670227051, -1.75871017173338, 218, 51, 'PPL', 'P'),
(206703, 'Arden', 48.4602813720703, 0.845791466385502, -117.875282287598, -2.05731178263633, 218, 56, 'PPL', 'P'),
(133981, 'Arden Hills', 45.0502815246582, 0.786275741555657, -93.1563873291016, -1.62588567815595, 218, 28, 'PPL', 'P'),
(18901, 'Arden Lake', 34.059440612793, 0.594449380080712, -84.5741729736328, -1.4760977805411, 218, 13, 'PPL', 'P'),
(158747, 'Arden Mines', 40.2186088562012, 0.701947145112461, -80.2647171020508, -1.40088358661259, 218, 45, 'PPL', 'P'),
(44433, 'Arden on the Severn', 39.0658302307129, 0.681827362551076, -76.5791702270508, -1.33655865890725, 218, 25, 'PPL', 'P'),
(179789, 'Arden Town', 38.5741691589355, 0.673246258044677, -121.381942749023, -2.11851455343772, 218, 6, 'PPL', 'P'),
(44432, 'Arden Valley', 39.5736083984375, 0.690689763447614, -76.6888885498047, -1.33847360488907, 218, 25, 'PPL', 'P'),
(144761, 'Ardena', 40.2113914489746, 0.7018211775929, -74.2330627441406, -1.29561135872479, 218, 37, 'PPL', 'P'),
(13294, 'Ardencroft', 39.8041687011719, 0.694713799854724, -75.4916687011719, -1.3175781766602, 218, 10, 'PPL', 'P'),
(158748, 'Ardenheim', 40.464168548584, 0.706232970254726, -77.9833297729492, -1.36106586620649, 218, 45, 'PPL', 'P'),
(13295, 'Ardentown', 39.8083305358887, 0.694786437573456, -75.4833297729492, -1.31743263490663, 218, 10, 'PPL', 'P'),
(206704, 'Ardenvoir', 47.7374992370605, 0.833176538354988, -120.367782592773, -2.10081411956861, 218, 56, 'PPL', 'P'),
(200338, 'Ardenwald', 45.4555587768555, 0.793349163989934, -122.628608703613, -2.14027297901783, 218, 43, 'PPL', 'P'),
(53220, 'Ardeola', 37.0011100769043, 0.645791197734832, -89.852783203125, -1.56822690897519, 218, 29, 'PPL', 'P'),
(18902, 'Ardick', 31.461109161377, 0.54909994119538, -81.4336090087891, -1.42128459898509, 218, 13, 'PPL', 'P'),
(112812, 'Ardilla', 31.1413898468018, 0.543519786473823, -85.1513900756836, -1.4861721194707, 218, 2, 'PPL', 'P'),
(92315, 'Ardis Heights', 33.1391716003418, 0.578387655809363, -96.0727767944336, -1.67678627659647, 218, 51, 'PPL', 'P'),
(53221, 'Arditta', 36.6163902282715, 0.639076569678416, -92.0625, -1.60679374261728, 218, 29, 'PPL', 'P'),
(18903, 'Ardmore', 32.4949989318848, 0.56714472179343, -81.4288864135742, -1.42120217414935, 218, 13, 'PPL', 'P'),
(44434, 'Ardmore', 38.9333305358887, 0.679514806618506, -76.8522186279297, -1.34132425251989, 218, 25, 'PPL', 'P'),
(53222, 'Ardmore', 39.6430587768555, 0.691901901217764, -92.5355606079102, -1.6150502077868, 218, 29, 'PPL', 'P'),
(62568, 'Ardmore', 36.0847206115723, 0.629797184334198, -80.274169921875, -1.40104856944212, 218, 33, 'PPL', 'P'),
(75011, 'Ardmore', 34.1741714477539, 0.596451810904343, -97.1433334350586, -1.69547101480447, 218, 42, 'PPL', 'P'),
(84704, 'Ardmore', 34.9919395446777, 0.610724556713432, -86.8466720581055, -1.5157603718137, 218, 50, 'PPL', 'P'),
(99467, 'Ardmore', 37.3480606079102, 0.651846626842427, -79.9330596923828, -1.39509507282525, 218, 53, 'PPL', 'P'),
(112813, 'Ardmore', 34.9919395446777, 0.610724556713432, -86.8469390869141, -1.51576503234561, 218, 2, 'PPL', 'P'),
(122157, 'Ardmore', 41.6891708374023, 0.727613293539072, -86.317497253418, -1.50652452915331, 218, 19, 'PPL', 'P'),
(158753, 'Ardmore', 40.0066719055176, 0.698248147516396, -75.2858276367188, -1.31398557234968, 218, 45, 'PPL', 'P'),
(201865, 'Ardmore', 43.0194396972656, 0.750830865080438, -103.655830383301, -1.80913552907737, 218, 49, 'PPL', 'P'),
(144762, 'Ardmore Estates', 40.2061080932617, 0.701728965640156, -74.2249984741211, -1.29547061066118, 218, 37, 'PPL', 'P'),
(77794, 'Ardmore Park', 39.9938888549805, 0.698025041196074, -75.2977828979492, -1.31419423102109, 218, 45, 'PPL', 'P'),
(139602, 'Ardoch', 48.207218170166, 0.841374680296633, -97.3419418334961, -1.69893738527931, 218, 34, 'PPL', 'P'),
(114428, 'Ardon', 41.3950004577637, 0.722479051852536, -91.1883316040039, -1.59153662589027, 218, 16, 'PPL', 'P'),
(146853, 'Ardonia', 41.6758308410645, 0.727380466680772, -74.0730590820313, -1.29281876800573, 218, 40, 'PPL', 'P'),
(39133, 'Ardoyne', 29.646390914917, 0.517427132798636, -90.8216705322266, -1.58513718294886, 218, 22, 'PPL', 'P'),
(195887, 'Ardrum (historical)', 46.9949989318848, 0.820217463332608, -114.124443054199, -1.99184728830055, 218, 31, 'PPL', 'P'),
(15021, 'Ards Crossroads', 30.9591693878174, 0.540339439500051, -85.6933288574219, -1.49563073555628, 218, 12, 'PPL', 'P'),
(146854, 'Ardsley', 41.0105590820313, 0.715769284065109, -73.8441696166992, -1.28882389321256, 218, 40, 'PPL', 'P'),
(158750, 'Ardsley', 40.1211090087891, 0.700245451754928, -75.1555633544922, -1.31171203172708, 218, 45, 'PPL', 'P'),
(146855, 'Ardsley-on-Hudson', 41.0250015258789, 0.716021352262285, -73.8708267211914, -1.289289147455, 218, 40, 'PPL', 'P'),
(62569, 'Ardulusa', 34.9627799987793, 0.610215626629118, -78.9172210693359, -1.37736534418415, 218, 33, 'PPL', 'P'),
(44435, 'Ardwick', 38.9455604553223, 0.679728258979876, -76.8811111450195, -1.3418285220723, 218, 25, 'PPL', 'P'),
(44436, 'Ardwick Park', 38.9419403076172, 0.679665075483013, -76.871940612793, -1.34166846609078, 218, 25, 'PPL', 'P'),
(99468, 'Ardwood', 38.1122207641602, 0.665183737581544, -78.4888916015625, -1.36988958468819, 218, 53, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(141192, 'Area Mobile Park', 40.7386093139648, 0.711022865212315, -99.5372161865234, -1.73725215072423, 218, 35, 'PPL', 'P'),
(99469, 'Areanum', 37.4474983215332, 0.653582142345805, -78.5100021362305, -1.370258033025, 218, 53, 'PPL', 'P'),
(114429, 'Aredale', 42.8330612182617, 0.747577946966961, -93.0052795410156, -1.62324834972844, 218, 16, 'PPL', 'P'),
(146856, 'Arena', 42.1155586242676, 0.735055164310163, -74.7377777099609, -1.30442029666245, 218, 40, 'PPL', 'P'),
(172947, 'Arena', 43.1655616760254, 0.753381174719325, -89.9127807617188, -1.56927406391581, 218, 57, 'PPL', 'P'),
(179790, 'Arena', 37.3708305358887, 0.652244037056094, -120.675277709961, -2.10618092179734, 218, 6, 'PPL', 'P'),
(188073, 'Arena', 31.8019409179688, 0.555048577543263, -107.415000915527, -1.87474543200868, 218, 38, 'PPL', 'P'),
(197947, 'Arena', 47.1272201538086, 0.822525158996189, -100.16194152832, -1.74815566485923, 218, 34, 'PPL', 'P'),
(154095, 'Arena (historical)', 41.1352806091309, 0.717946085361112, -84.6313934326172, -1.47709646594988, 218, 41, 'PPL', 'P'),
(129555, 'Arenac', 44.0055618286133, 0.768041943099238, -83.8580627441406, -1.46359929922925, 218, 27, 'PPL', 'P'),
(188075, 'Arenal', 35.0533294677734, 0.611796012998998, -106.70361328125, -1.86232937553256, 218, 38, 'PPL', 'P'),
(188074, 'Arenas Valley', 32.7938919067383, 0.572361388315704, -108.183609008789, -1.88816017389357, 218, 38, 'PPL', 'P'),
(133985, 'Arendahl', 43.8252792358398, 0.76489541827131, -91.9094390869141, -1.60412232572782, 218, 28, 'PPL', 'P'),
(77795, 'Arendtsville', 39.9230613708496, 0.696788868397087, -77.2988891601563, -1.34912012397888, 218, 45, 'PPL', 'P'),
(77797, 'Arensburg', 39.9527816772461, 0.697307585598407, -79.9499969482422, -1.39539068370624, 218, 45, 'PPL', 'P'),
(26391, 'Arenzville', 39.8769416809082, 0.69598392795761, -90.3733291625977, -1.57731214987594, 218, 18, 'PPL', 'P'),
(126767, 'Arey', 44.7227783203125, 0.780559732328992, -68.8722229003906, -1.20204705277926, 218, 26, 'PPL', 'P'),
(114430, 'Argand', 42.2816696166992, 0.73795434805185, -91.3452835083008, -1.59427595338753, 218, 16, 'PPL', 'P'),
(39134, 'Argent', 31.7383308410645, 0.553938372263836, -91.4061126708984, -1.59533762255609, 218, 22, 'PPL', 'P'),
(26393, 'Argenta', 39.9819412231445, 0.697816515682721, -88.8227767944336, -1.55024990582688, 218, 18, 'PPL', 'P'),
(92316, 'Argenta', 28.1697196960449, 0.49165435805988, -97.8469390869141, -1.70775125006498, 218, 51, 'PPL', 'P'),
(195888, 'Argenta', 45.2797203063965, 0.790280203728754, -112.861106872559, -1.96979791237135, 218, 31, 'PPL', 'P'),
(199812, 'Argenta', 40.6744384765625, 0.709902872815882, -116.704719543457, -2.0368816086499, 218, 39, 'PPL', 'P'),
(31666, 'Argentine', 39.0750007629395, 0.68198741853259, -94.6722183227539, -1.65234191989896, 218, 20, 'PPL', 'P'),
(129558, 'Argentine', 42.791389465332, 0.74685063767326, -83.8463897705078, -1.46339556740585, 218, 27, 'PPL', 'P'),
(158751, 'Argentine', 41.0941696166992, 0.717228563184418, -79.8194427490234, -1.39311208307757, 218, 45, 'PPL', 'P'),
(179791, 'Argentine (historical)', 39.9247207641602, 0.696817830273941, -120.771392822266, -2.10785844696798, 218, 6, 'PPL', 'P'),
(189883, 'Argentum (historical)', 38.1183280944824, 0.665290330604174, -117.992218017578, -2.05935269613771, 218, 39, 'PPL', 'P'),
(53234, 'Argentville', 39.0161094665527, 0.680959571509874, -90.7980575561523, -1.58472505877017, 218, 29, 'PPL', 'P'),
(34582, 'Argillite', 38.4897193908691, 0.671772331539373, -82.8283309936523, -1.4456270897709, 218, 21, 'PPL', 'P'),
(34577, 'Argo', 37.4805603027344, 0.654159182774998, -82.0633316040039, -1.43227533164579, 218, 21, 'PPL', 'P'),
(39135, 'Argo', 31.3305606842041, 0.546821440435249, -91.8858337402344, -1.60371033470719, 218, 22, 'PPL', 'P'),
(53224, 'Argo', 38.1838912963867, 0.666434624345554, -91.3302764892578, -1.59401403149432, 218, 29, 'PPL', 'P'),
(92317, 'Argo', 33.2550010681152, 0.580409261392842, -94.8947219848633, -1.65622534140051, 218, 51, 'PPL', 'P'),
(112815, 'Argo', 33.8013916015625, 0.589945575203225, -87.116943359375, -1.5204774958945, 218, 2, 'PPL', 'P'),
(114431, 'Argo', 41.6258316040039, 0.726507815370581, -90.432502746582, -1.57834492374667, 218, 16, 'PPL', 'P'),
(177723, 'Argo', 39.5974998474121, 0.691106747895294, -119.162780761719, -2.07978287012415, 218, 39, 'PPL', 'P'),
(18904, 'Argo (historical)', 34.6911087036133, 0.605474068045313, -84.1413879394531, -1.4685442567413, 218, 13, 'PPL', 'P'),
(141193, 'Argo (historical)', 41.7236099243164, 0.728214368997103, -96.4438934326172, -1.68326348384171, 218, 35, 'PPL', 'P'),
(13296, 'Argo Corners', 38.8713912963867, 0.678433762953015, -75.345832824707, -1.31503286044836, 218, 10, 'PPL', 'P'),
(118642, 'Argo Fay', 42.0041694641113, 0.733111056714405, -90.017219543457, -1.57109686452391, 218, 18, 'PPL', 'P'),
(186355, 'Argo Mill', 39.7427787780762, 0.693642343569158, -105.50611114502, -1.84142902045568, 218, 7, 'PPL', 'P'),
(53225, 'Argola', 39.997501373291, 0.698088091534882, -91.7869415283203, -1.60198434000471, 218, 29, 'PPL', 'P'),
(31667, 'Argonia', 37.2658309936523, 0.650411449330983, -97.7652816772461, -1.70632605940763, 218, 20, 'PPL', 'P'),
(133987, 'Argonne', 44.6958312988281, 0.780089418080484, -93.2855606079102, -1.62814017717676, 218, 28, 'PPL', 'P'),
(169744, 'Argonne', 44.0733299255371, 0.76922471951837, -97.6383285522461, -1.70411030938068, 218, 49, 'PPL', 'P'),
(172950, 'Argonne', 45.6597213745117, 0.79691247352846, -88.8791732788086, -1.55123421016577, 218, 57, 'PPL', 'P'),
(44437, 'Argonne Hills', 39.1144409179688, 0.682675779095348, -76.7655563354492, -1.33981171017878, 218, 25, 'PPL', 'P'),
(122158, 'Argos', 41.6972198486328, 0.727753775286574, -86.245002746582, -1.50525926131941, 218, 19, 'PPL', 'P'),
(179792, 'Argos', 34.725830078125, 0.606080070351361, -116.25, -2.02894525544341, 218, 6, 'PPL', 'P'),
(13297, 'Argos Choice', 38.9500007629395, 0.679805756967597, -75.5100021362305, -1.31789815546517, 218, 10, 'PPL', 'P'),
(7144, 'Argosy (historical)', 36.3833312988281, 0.635008924008456, -92.0736083984375, -1.60698762074464, 218, 4, 'PPL', 'P'),
(179794, 'Arguello', 34.5783309936523, 0.603505725683636, -120.641937255859, -2.10559902109916, 218, 6, 'PPL', 'P'),
(92318, 'Arguello Colonia', 26.2140007019043, 0.457520622368335, -98.1490020751953, -1.71302324375891, 218, 51, 'PPL', 'P'),
(92319, 'Arguello Number 2 Colonia', 26.2140007019043, 0.457520622368335, -98.1490020751953, -1.71302324375891, 218, 51, 'PPL', 'P'),
(62570, 'Argura', 35.2675018310547, 0.615534025905033, -83.0411071777344, -1.44934073475296, 218, 33, 'PPL', 'P'),
(158752, 'Argus', 40.3663902282715, 0.704526416628203, -75.3833312988281, -1.31568733228624, 218, 45, 'PPL', 'P'),
(179793, 'Argus', 35.7472190856934, 0.623906671477106, -117.394439697266, -2.04891949625122, 218, 6, 'PPL', 'P'),
(139605, 'Argusville', 47.0522193908691, 0.821216148741387, -96.9341735839844, -1.69182048674024, 218, 34, 'PPL', 'P'),
(146878, 'Argusville', 42.7905616760254, 0.746836190024346, -74.5194396972656, -1.30060957945865, 218, 40, 'PPL', 'P'),
(112816, 'Arguta', 31.5691699981689, 0.55098595858986, -85.5952835083008, -1.49391952139785, 218, 2, 'PPL', 'P'),
(15022, 'Argyle', 30.7194404602051, 0.536155380400941, -86.0444412231445, -1.50175880238261, 218, 12, 'PPL', 'P'),
(18905, 'Argyle', 31.0738906860352, 0.542341703876113, -82.6486129760742, -1.442490418639, 218, 13, 'PPL', 'P'),
(34578, 'Argyle', 37.225830078125, 0.649713301651219, -84.807502746582, -1.48017015332199, 218, 21, 'PPL', 'P'),
(39137, 'Argyle', 29.5719394683838, 0.516127709923759, -90.746940612793, -1.583832899805, 218, 22, 'PPL', 'P'),
(53226, 'Argyle', 38.2944412231445, 0.668364084555317, -92.0236129760742, -1.60611503601347, 218, 29, 'PPL', 'P'),
(79560, 'Argyle', 34.4888916015625, 0.601944713810686, -79.682502746582, -1.39072202915728, 218, 48, 'PPL', 'P'),
(92320, 'Argyle', 33.1211090087891, 0.578072404115325, -97.1830596923828, -1.69616436879427, 218, 51, 'PPL', 'P'),
(108017, 'Argyle', 37.8255615234375, 0.660180589999667, -81.8769378662109, -1.4290221472162, 218, 58, 'PPL', 'P'),
(114448, 'Argyle', 40.5316696166992, 0.707411086141949, -91.5661087036133, -1.59813008011709, 218, 16, 'PPL', 'P'),
(118643, 'Argyle', 42.3600006103516, 0.739321481797442, -88.9400024414063, -1.55229587933433, 218, 18, 'PPL', 'P'),
(126768, 'Argyle', 45.0541687011719, 0.786343585584426, -68.6727828979492, -1.19856616807647, 218, 26, 'PPL', 'P'),
(129559, 'Argyle', 43.5641708374023, 0.760338217013966, -82.9361114501953, -1.44750821360688, 218, 27, 'PPL', 'P'),
(133988, 'Argyle', 48.3327789306641, 0.843566128978632, -96.820556640625, -1.68983749699257, 218, 28, 'PPL', 'P'),
(146857, 'Argyle', 43.2377815246582, 0.754641648863259, -73.491943359375, -1.28267638531028, 218, 40, 'PPL', 'P'),
(172962, 'Argyle', 42.7011108398438, 0.745274978414314, -89.866943359375, -1.56847405032435, 218, 57, 'PPL', 'P'),
(201867, 'Argyle', 43.5349998474121, 0.75982908719257, -103.647499084473, -1.80899012048186, 218, 49, 'PPL', 'P'),
(206705, 'Argyle', 48.514720916748, 0.846741615683415, -123.018333435059, -2.147074958758, 218, 56, 'PPL', 'P'),
(15023, 'Argyle Forest', 30.1936092376709, 0.526977894257932, -81.754997253418, -1.42689388203106, 218, 12, 'PPL', 'P'),
(99470, 'Argyle Heights', 38.2869415283203, 0.668233190187739, -77.432502746582, -1.35145212098741, 218, 53, 'PPL', 'P'),
(39138, 'Argyle Plantation', 30.6594390869141, 0.535108158881294, -91.6413879394531, -1.59944395064088, 218, 22, 'PPL', 'P'),
(122159, 'Ari', 41.2636108398438, 0.720185870416896, -85.2494430541992, -1.48788346678719, 218, 19, 'PPL', 'P'),
(79561, 'Arial', 34.8458290100098, 0.608174446811627, -82.6416702270508, -1.44236924480941, 218, 48, 'PPL', 'P'),
(186356, 'Arickaree', 39.6991691589355, 0.692881212129613, -103.065559387207, -1.79883335671651, 218, 7, 'PPL', 'P'),
(15024, 'Ariel', 28.9002799987793, 0.504405040726962, -80.8638916015625, -1.41134115442306, 218, 12, 'PPL', 'P'),
(58479, 'Ariel', 31.1005592346191, 0.542807157855632, -90.9872207641602, -1.58802657957355, 218, 30, 'PPL', 'P'),
(206706, 'Ariel', 45.9569396972656, 0.802099911857771, -122.569717407227, -2.13924513199511, 218, 56, 'PPL', 'P'),
(79562, 'Ariel Cross Road', 34.0761108398438, 0.594740330429804, -79.3030624389648, -1.38409954647458, 218, 48, 'PPL', 'P'),
(92321, 'Ariel Hinojosa Colonia', 26.238000869751, 0.45793950431829, -98.3639984130859, -1.71677563773483, 218, 51, 'PPL', 'P'),
(92322, 'Ariel Hinojosa Colonia Number 3', 26.2789993286133, 0.458655062413681, -98.3649978637695, -1.71679308143997, 218, 51, 'PPL', 'P'),
(146859, 'Arietta', 43.2461090087891, 0.754786990879751, -74.5180587768555, -1.30058547785079, 218, 40, 'PPL', 'P'),
(194532, 'Arimo', 42.560001373291, 0.742812153617237, -112.170562744141, -1.95774564370014, 218, 17, 'PPL', 'P'),
(71689, 'Arion', 38.8461112976074, 0.677992543739416, -83.103889465332, -1.45043649238347, 218, 41, 'PPL', 'P'),
(114432, 'Arion', 41.9491691589355, 0.732151120299486, -95.4633331298828, -1.66614947804464, 218, 16, 'PPL', 'P'),
(77798, 'Ariosa', 39.9772186279297, 0.697734090846983, -77.1750030517578, -1.34695790348985, 218, 45, 'PPL', 'P'),
(15025, 'Aripeka', 28.4319400787354, 0.496230967103668, -82.664436340332, -1.44276658844405, 218, 12, 'PPL', 'P'),
(193033, 'Aripine', 34.4083290100098, 0.600538631334151, -110.430282592773, -1.92737202515168, 218, 5, 'PPL', 'P'),
(114433, 'Arispe', 40.9494400024414, 0.714702554890477, -94.2188873291016, -1.64442980145839, 218, 16, 'PPL', 'P'),
(191084, 'Arispe', 31.1511096954346, 0.543689429835261, -105.274436950684, -1.83738554297261, 218, 51, 'PPL', 'P'),
(34579, 'Arista', 37.3686103820801, 0.652205288062234, -85.3047180175781, -1.48884819689207, 218, 21, 'PPL', 'P'),
(108012, 'Arista', 37.4724998474121, 0.654018501290414, -81.2608337402344, -1.41826910168279, 218, 58, 'PPL', 'P'),
(158754, 'Aristes', 40.8183288574219, 0.712414233723827, -76.3386077880859, -1.33236005229069, 218, 45, 'PPL', 'P'),
(194090, 'Aristocrat Ranchettes', 40.1091690063477, 0.700037059399629, -104.761940002441, -1.82844078381936, 218, 7, 'PPL', 'P'),
(193030, 'Aristocrat Trailer Park', 33.4947204589844, 0.584593154044384, -112.0625, -1.95585959301615, 218, 5, 'PPL', 'P'),
(146861, 'Aristotle', 42.3497200012207, 0.739142051318998, -78.0141677856445, -1.36160409106279, 218, 40, 'PPL', 'P'),
(112194, 'Ariton', 31.6000003814697, 0.551524050288111, -85.7188873291016, -1.49607681503887, 218, 2, 'PPL', 'P'),
(193035, 'Arivaca', 31.5747203826904, 0.551082831074512, -111.331672668457, -1.94310424981716, 218, 5, 'PPL', 'P'),
(193036, 'Arivaca Junction', 31.7272205352783, 0.553744460846964, -111.060562133789, -1.93837247835036, 218, 5, 'PPL', 'P'),
(193038, 'Arizola', 32.8511085510254, 0.573360007145457, -111.713607788086, -1.94977027518368, 218, 5, 'PPL', 'P'),
(39139, 'Arizona', 32.788890838623, 0.572274103210977, -92.9574966430664, -1.62241438083308, 218, 22, 'PPL', 'P'),
(92323, 'Arizona', 30.7894401550293, 0.537377105551015, -95.4677810668945, -1.66622710919041, 218, 51, 'PPL', 'P'),
(141194, 'Arizona', 41.8144416809082, 0.729799682215, -96.1333312988281, -1.67784315207507, 218, 35, 'PPL', 'P'),
(193042, 'Arizona', 34.5002784729004, 0.602143452207033, -111.500282287598, -1.94604704282169, 218, 5, 'ADM1', 'A'),
(193037, 'Arizona Acres Mobile Home Resort', 33.4127807617188, 0.583163036539011, -111.626388549805, -1.94824801230459, 218, 5, 'PPL', 'P'),
(193039, 'Arizona City', 32.7558288574219, 0.571697062781784, -111.670280456543, -1.94901407059215, 218, 5, 'PPL', 'P'),
(193040, 'Arizona Sun Sites', 31.9166698455811, 0.55705097507738, -109.95832824707, -1.91913486790006, 218, 5, 'PPL', 'P'),
(193041, 'Arizona Village', 34.8530616760254, 0.608300680647296, -114.583610534668, -1.99986127265282, 218, 5, 'PPL', 'P'),
(34580, 'Arjay', 36.8047218322754, 0.642363576253846, -83.6458282470703, -1.45989510846905, 218, 21, 'PPL', 'P'),
(53227, 'Ark', 37.6811103820801, 0.657659441974716, -91.3358306884766, -1.594110970558, 218, 29, 'PPL', 'P'),
(99471, 'Ark', 37.4383316040039, 0.653422152943318, -76.5761108398438, -1.33650526252739, 218, 53, 'PPL', 'P'),
(58480, 'Arkabutla', 34.6988906860352, 0.605609889260908, -90.1222229003906, -1.57292951882805, 218, 30, 'PPL', 'P'),
(7145, 'Arkadelphia', 34.1208305358887, 0.595520836366279, -93.0536117553711, -1.62409190600373, 218, 4, 'PPL', 'P'),
(112817, 'Arkadelphia', 33.9049987792969, 0.591753861583389, -86.9625015258789, -1.51778197739718, 218, 2, 'PPL', 'P'),
(187582, 'Arkalon', 37.1430587768555, 0.648268669917906, -100.806938171387, -1.75941297994505, 218, 20, 'PPL', 'P'),
(7146, 'Arkana', 36.2383308410645, 0.632478188603581, -92.3163909912109, -1.61122497635506, 218, 4, 'PPL', 'P'),
(39140, 'Arkana', 33.0183296203613, 0.576278565384075, -93.6744384765625, -1.63492737637288, 218, 22, 'PPL', 'P'),
(7152, 'Arkansas', 34.7502784729004, 0.606506775337019, -92.5002822875977, -1.61443448494277, 218, 4, 'ADM1', 'A'),
(34581, 'Arkansas', 37.5827789306641, 0.655943234389242, -82.7324981689453, -1.44395449144828, 218, 21, 'PPL', 'P'),
(108013, 'Arkansas', 39.0744400024414, 0.681977631415584, -78.7294387817383, -1.37408792498865, 218, 58, 'PPL', 'P'),
(7147, 'Arkansas (historical)', 34.026668548584, 0.593877399657591, -91.3430633544922, -1.59423720439367, 218, 4, 'PPL', 'P'),
(7148, 'Arkansas City', 33.6086082458496, 0.586580870902992, -91.206672668457, -1.5918567378533, 218, 4, 'PPL', 'P'),
(31669, 'Arkansas City', 37.061939239502, 0.646852866903392, -97.0380630493164, -1.69363369996842, 218, 20, 'PPL', 'P'),
(92324, 'Arkansas City', 26.6611099243164, 0.465324150415457, -98.4338912963867, -1.71799549867214, 218, 51, 'PPL', 'P'),
(188076, 'Arkansas Junction', 32.6966705322266, 0.57066455522716, -103.350563049316, -1.80380760900056, 218, 38, 'PPL', 'P'),
(7150, 'Arkansas Post', 34.023609161377, 0.593824003277735, -91.3436126708984, -1.59424679177359, 218, 4, 'PPL', 'P'),
(172954, 'Arkansaw', 44.6338882446289, 0.779008307835967, -92.0311126708984, -1.60624593038105, 218, 57, 'PPL', 'P'),
(7154, 'Arkawana', 36.4036102294922, 0.635362858117327, -92.4608306884766, -1.61374592464293, 218, 4, 'PPL', 'P'),
(172955, 'Arkdale', 44.0272216796875, 0.768419978815975, -89.8877792358398, -1.5688377049712, 218, 57, 'PPL', 'P'),
(112818, 'Arkdell', 34.9597206115723, 0.610162230249262, -87.4297180175781, -1.52593644349695, 218, 2, 'PPL', 'P'),
(99472, 'Arkendale', 38.4383316040039, 0.670875445463261, -77.3427810668945, -1.34988618226644, 218, 53, 'PPL', 'P'),
(7155, 'Arkinda', 33.7802810668945, 0.589577126866412, -94.4686126708984, -1.64878833089841, 218, 4, 'PPL', 'P'),
(7157, 'Arkins (historical)', 35.9847183227539, 0.628051815134787, -92.0827789306641, -1.60714767672615, 218, 4, 'PPL', 'P'),
(84705, 'Arkland', 35.6758308410645, 0.622660711561113, -87.2005615234375, -1.52193690817187, 218, 50, 'PPL', 'P'),
(34583, 'Arkle', 36.9191703796387, 0.64436108022946, -83.976936340332, -1.46567403487647, 218, 21, 'PPL', 'P'),
(7158, 'Arkmo', 35.9966697692871, 0.628260407227168, -90.2474975585938, -1.57511597408301, 218, 4, 'PPL', 'P'),
(71690, 'Arkoe', 39.0444412231445, 0.681454053945274, -83.2324981689453, -1.45268113770825, 218, 41, 'PPL', 'P'),
(139014, 'Arkoe', 40.2580604553223, 0.702635705412301, -94.8274993896484, -1.65505208578228, 218, 29, 'PPL', 'P'),
(7159, 'Arkola', 35.0847206115723, 0.612343891814255, -94.3088912963867, -1.64600066702737, 218, 4, 'PPL', 'P'),
(75012, 'Arkoma', 35.3544387817383, 0.617051361936106, -94.4338912963867, -1.64818232859236, 218, 42, 'PPL', 'P'),
(146862, 'Arkport', 42.3944396972656, 0.739922557255473, -77.6969375610352, -1.35606737915652, 218, 40, 'PPL', 'P'),
(99473, 'Arkton', 38.5730590820313, 0.673226883547747, -78.695556640625, -1.37349657006859, 218, 53, 'PPL', 'P'),
(146863, 'Arkville', 42.1477813720703, 0.73561755735336, -74.6202774047852, -1.30236952946503, 218, 40, 'PPL', 'P'),
(18912, 'Arkwright', 32.9327812194824, 0.574785464118922, -83.7030563354492, -1.46089392703589, 218, 13, 'PPL', 'P'),
(79563, 'Arkwright', 34.9238891601563, 0.609536853446284, -81.9330596923828, -1.43000165786513, 218, 48, 'PPL', 'P'),
(112820, 'Arkwright', 33.3713912963867, 0.582440654093327, -86.4024963378906, -1.50800804303853, 218, 2, 'PPL', 'P'),
(146864, 'Arkwright', 42.4069404602051, 0.740140736727778, -79.2366714477539, -1.38294080508429, 218, 40, 'PPL', 'P'),
(169259, 'Arkwright', 41.7286109924316, 0.728301654101831, -71.5488891601563, -1.24876369198921, 218, 47, 'PPL', 'P'),
(92325, 'Arlam', 31.8761100769043, 0.556343073570123, -94.5338897705078, -1.64992763121275, 218, 51, 'PPL', 'P'),
(172956, 'Arland', 45.3383293151855, 0.791303123903454, -92.0227813720703, -1.60610052178553, 218, 57, 'PPL', 'P'),
(99474, 'Arlandria', 38.8411102294922, 0.677905258634689, -77.0672225952148, -1.34507677965387, 218, 53, 'PPL', 'P'),
(179797, 'Arlanza', 33.9427795410156, 0.592413260269292, -117.464721679688, -2.05014614824931, 218, 6, 'PPL', 'P'),
(39141, 'Arlatex', 32.6777801513672, 0.570334855884208, -93.9533309936523, -1.63979496905527, 218, 22, 'PPL', 'P'),
(7160, 'Arlberg', 35.7336082458496, 0.623669117507871, -92.3891677856445, -1.61249517103698, 218, 4, 'PPL', 'P'),
(133990, 'Arlberg', 46.9233283996582, 0.818966576568597, -92.6138916015625, -1.61641734153239, 218, 28, 'PPL', 'P'),
(108014, 'Arlee', 38.7324981689453, 0.676009620570771, -82.0947189331055, -1.43282314388202, 218, 58, 'PPL', 'P'),
(195889, 'Arlee', 47.1619415283203, 0.823131161302236, -114.084167480469, -1.99114434693082, 218, 31, 'PPL', 'P'),
(189884, 'Arlemont (historical)', 37.8244400024414, 0.660161015765655, -118.078056335449, -2.06085085740894, 218, 39, 'PPL', 'P'),
(129561, 'Arlene', 44.3899993896484, 0.774751644307639, -85.2866668701172, -1.48853314493511, 218, 27, 'PPL', 'P'),
(18907, 'Arles', 32.1180610656738, 0.560565914952607, -84.1975021362305, -1.46952363423218, 218, 13, 'PPL', 'P'),
(200339, 'Arleta', 45.4888916015625, 0.793930931530062, -122.592216491699, -2.13963781509784, 218, 43, 'PPL', 'P'),
(206707, 'Arletta', 47.2902793884277, 0.825371079516074, -122.666389465332, -2.14093237770373, 218, 56, 'PPL', 'P'),
(53228, 'Arley', 39.4044418334961, 0.687737249905098, -94.4449996948242, -1.64837620671972, 218, 29, 'PPL', 'P'),
(112821, 'Arley', 34.0788917541504, 0.59478886654067, -87.2122192382813, -1.52214037367915, 218, 2, 'PPL', 'P'),
(112822, 'Arley Landing', 34.0441703796387, 0.594182864234623, -87.2658309936523, -1.52307607532815, 218, 2, 'PPL', 'P'),
(191085, 'Arlie', 34.7177810668945, 0.605939588603859, -100.090560913086, -1.74690983810129, 218, 51, 'PPL', 'P'),
(179795, 'Arlight', 34.5777816772461, 0.603496138303712, -120.638328552246, -2.10553603733938, 218, 6, 'PPL', 'P'),
(84706, 'Arline', 35.7938919067383, 0.624721265875534, -84.0947189331055, -1.4677297289219, 218, 50, 'PPL', 'P'),
(194533, 'Arling', 44.6252784729004, 0.778858038971459, -116.049171447754, -2.0254401359747, 218, 17, 'PPL', 'P'),
(158764, 'Arlingham', 40.1152801513672, 0.700143719001287, -75.20361328125, -1.31255066115435, 218, 45, 'PPL', 'P'),
(15027, 'Arlington', 30.3355598449707, 0.529455399730519, -81.6030578613281, -1.42424203937562, 218, 12, 'PPL', 'P'),
(18908, 'Arlington', 31.4397201538086, 0.548726632589578, -84.7249984741211, -1.47873018212058, 218, 13, 'PPL', 'P'),
(29111, 'Arlington', 39.6425018310547, 0.691892180679785, -85.5763931274414, -1.4935898220549, 218, 19, 'PPL', 'P'),
(31671, 'Arlington', 37.896671295166, 0.661421689646671, -98.1783294677734, -1.71353510332042, 218, 20, 'PPL', 'P'),
(34585, 'Arlington', 36.7902793884277, 0.64211150805667, -89.0127792358398, -1.55356607401625, 218, 21, 'PPL', 'P'),
(39143, 'Arlington', 32.8208312988281, 0.572831569406158, -91.1755599975586, -1.59131371930703, 218, 22, 'PPL', 'P'),
(44438, 'Arlington', 39.3394393920898, 0.686602743280724, -76.6841735839844, -1.33839131321139, 218, 25, 'PPL', 'P'),
(53229, 'Arlington', 37.920280456543, 0.661833747246333, -91.970832824707, -1.60519384859241, 218, 29, 'PPL', 'P'),
(58482, 'Arlington', 32.8766708374023, 0.573806153207072, -89.1772232055664, -1.55643616272303, 218, 30, 'PPL', 'P'),
(62571, 'Arlington', 36.2272186279297, 0.632284243897196, -80.833610534668, -1.41081265010473, 218, 33, 'PPL', 'P'),
(75013, 'Arlington', 35.5788917541504, 0.620968805320585, -96.679443359375, -1.68737460561646, 218, 42, 'PPL', 'P'),
(84709, 'Arlington', 35.2961082458496, 0.616033302030396, -89.6613922119141, -1.5648865060199, 218, 50, 'PPL', 'P'),
(92326, 'Arlington', 32.7355613708496, 0.571343328409994, -97.107780456543, -1.69485049827048, 218, 51, 'PPL', 'P'),
(99477, 'Arlington', 37.226390838623, 0.649723088768225, -76.0016708374023, -1.32647939312963, 218, 53, 'PPL', 'P'),
(108016, 'Arlington', 38.7999992370605, 0.677187736457994, -80.3433303833008, -1.4022556472062, 218, 58, 'PPL', 'P'),
(112824, 'Arlington', 32.0569381713867, 0.559499119198949, -87.5886077880859, -1.52870959314005, 218, 2, 'PPL', 'P'),
(114434, 'Arlington', 42.7491683959961, 0.746113740999635, -91.6711120605469, -1.59996273442123, 218, 16, 'PPL', 'P'),
(118646, 'Arlington', 41.4736099243164, 0.723851045867118, -89.2491683959961, -1.557691843177, 218, 18, 'PPL', 'P'),
(124120, 'Arlington', 42.4152793884277, 0.740286278481351, -71.1569366455078, -1.24192283009712, 218, 23, 'PPL', 'P'),
(133991, 'Arlington', 44.6083297729492, 0.778562228353378, -94.0802764892578, -1.64201058592416, 218, 28, 'PPL', 'P'),
(141196, 'Arlington', 41.4524993896484, 0.723482597530305, -96.350830078125, -1.68163922189287, 218, 35, 'PPL', 'P'),
(144763, 'Arlington', 40.7775001525879, 0.711701638395149, -74.1386108398438, -1.29396286201003, 218, 37, 'PPL', 'P'),
(146867, 'Arlington', 40.6322212219238, 0.709166042721284, -74.1655578613281, -1.29443317625854, 218, 40, 'PPL', 'P'),
(154091, 'Arlington', 41.0802803039551, 0.716986148946193, -81.4936065673828, -1.4223317539257, 218, 41, 'PPL', 'P'),
(158755, 'Arlington', 41.4119415283203, 0.722774729312562, -75.3261108398438, -1.31468864687746, 218, 45, 'PPL', 'P'),
(169745, 'Arlington', 44.3644409179688, 0.77430556482505, -97.1327819824219, -1.69528685721509, 218, 49, 'PPL', 'P'),
(171693, 'Arlington', 43.0747184753418, 0.751795661764346, -73.1544418334961, -1.27678587245318, 218, 55, 'PPL', 'P'),
(172958, 'Arlington', 43.3380584716797, 0.756391811752632, -89.3802795410156, -1.55998016434365, 218, 57, 'PPL', 'P'),
(179796, 'Arlington', 33.920280456543, 0.59202057716656, -117.445556640625, -2.0498116552164, 218, 6, 'PPL', 'P'),
(186358, 'Arlington', 38.336109161377, 0.66909132726999, -103.342781066895, -1.80367178778497, 218, 7, 'PPL', 'P'),
(193102, 'Arlington', 33.3255615234375, 0.581640773659922, -112.763328552246, -1.96809135874483, 218, 5, 'PPL', 'P'),
(200340, 'Arlington', 45.7169418334961, 0.79791115893724, -120.199722290039, -2.097880913944, 218, 43, 'PPL', 'P'),
(206710, 'Arlington', 48.1988906860352, 0.841229338280142, -122.123893737793, -2.13146404108017, 218, 56, 'PPL', 'P'),
(209276, 'Arlington', 41.5947189331055, 0.725964796824313, -106.207778930664, -1.85367543357035, 218, 59, 'PPL', 'P'),
(169747, 'Arlington Beach', 44.5338897705078, 0.777263005215583, -97.0975036621094, -1.69467113437106, 218, 49, 'PPL', 'P'),
(79564, 'Arlington Estates', 34.1211090087891, 0.595525696635268, -81.0469436645508, -1.41453601562477, 218, 48, 'PPL', 'P'),
(99480, 'Arlington Forest', 37.2099990844727, 0.649436998688123, -80.019172668457, -1.39659802778643, 218, 53, 'PPL', 'P'),
(71692, 'Arlington Heights', 39.2150001525879, 0.684430868832737, -84.4555587768555, -1.47402757226772, 218, 41, 'PPL', 'P'),
(92327, 'Arlington Heights', 27.8347206115723, 0.485807521044666, -97.5663909912109, -1.70285476208476, 218, 51, 'PPL', 'P'),
(99481, 'Arlington Heights', 38.8694381713867, 0.678399674491062, -77.0924987792969, -1.34551793228844, 218, 53, 'PPL', 'P'),
(118647, 'Arlington Heights', 42.0883293151855, 0.734579923213638, -87.9805603027344, -1.53555045503213, 218, 18, 'PPL', 'P'),
(124121, 'Arlington Heights', 42.420280456543, 0.740373563586078, -71.1805572509766, -1.24233508743386, 218, 23, 'PPL', 'P'),
(158757, 'Arlington Heights', 40.9900016784668, 0.715410489687248, -75.216667175293, -1.31277849458561, 218, 45, 'PPL', 'P'),
(206708, 'Arlington Heights', 48.202220916748, 0.841287461770933, -122.060829162598, -2.13036335660164, 218, 56, 'PPL', 'P'),
(99482, 'Arlington Hills', 37.2119407653809, 0.649470887412995, -80.0180587768555, -1.39657858671047, 218, 53, 'PPL', 'P'),
(206709, 'Arlington Junction', 48.2061080932617, 0.841355305799703, -122.127777099609, -2.13153181852991, 218, 56, 'PPL', 'P'),
(158758, 'Arlington Knolls', 40.6566696166992, 0.709592747706942, -75.4972229003906, -1.31767511572388, 218, 45, 'PPL', 'P'),
(133992, 'Arlington Mobile Home Park', 44.6069412231445, 0.778537993587459, -94.0691680908203, -1.6418167077968, 218, 28, 'PPL', 'P'),
(15028, 'Arlington Park', 26.3066692352295, 0.459137993387853, -80.1072235107422, -1.39813480489346, 218, 12, 'PPL', 'P'),
(18909, 'Arlington Park', 32.8169403076172, 0.572763658798361, -83.6797180175781, -1.46048659654716, 218, 13, 'PPL', 'P'),
(77799, 'Arlington Park', 39.9049987792969, 0.696473616703049, -76.6858291625977, -1.33842020850922, 218, 45, 'PPL', 'P'),
(143472, 'Arlington Park', 42.8302803039551, 0.747529410856094, -71.2244415283203, -1.24310101256337, 218, 36, 'PPL', 'P'),
(179798, 'Arlington Station', 33.9141693115234, 0.591913917564903, -117.440277099609, -2.04971950984268, 218, 6, 'PPL', 'P'),
(99483, 'Arlington Village', 38.8616714477539, 0.678264119591577, -77.085563659668, -1.3453968916169, 218, 53, 'PPL', 'P'),
(154093, 'Arlington Woods', 41.2874984741211, 0.720602788285548, -83.6527786254883, -1.46001641545671, 218, 41, 'PPL', 'P'),
(99484, 'Arlingwood', 38.9275016784668, 0.679413073864865, -77.1222229003906, -1.34603671606879, 218, 53, 'PPL', 'P'),
(171691, 'Arlins', 44.922779083252, 0.784050404148786, -71.5116729736328, -1.24811414699934, 218, 55, 'PPL', 'P'),
(193351, 'Arlynda Corners', 40.5950012207031, 0.708516431152387, -124.253890991211, -2.16863950621075, 218, 6, 'PPL', 'P'),
(58483, 'Arm', 31.5027809143066, 0.549827250489081, -90.01611328125, -1.57107755660601, 218, 30, 'PPL', 'P'),
(31673, 'Arma', 37.5438919067383, 0.655264527785435, -94.6999969482422, -1.65282674837541, 218, 20, 'PPL', 'P'),
(44439, 'Armacost', 39.6133308410645, 0.691383050858389, -76.8041687011719, -1.34048562309263, 218, 25, 'PPL', 'P'),
(129563, 'Armada', 42.8441696166992, 0.747771825094318, -82.8844375610352, -1.44660633410372, 218, 27, 'PPL', 'P'),
(7161, 'Armada (historical)', 35.7166709899902, 0.623373506626872, -94.1952819824219, -1.64401781043775, 218, 4, 'PPL', 'P'),
(71695, 'Armadale', 39.3958282470703, 0.687586914461563, -81.9230575561523, -1.42982708765568, 218, 41, 'PPL', 'P'),
(39144, 'Armagh', 31.4283294677734, 0.548527827614204, -91.7508316040039, -1.60135410293274, 218, 22, 'PPL', 'P'),
(44440, 'Armagh', 39.3811111450195, 0.687330052574425, -76.6202774047852, -1.33727611450492, 218, 25, 'PPL', 'P'),
(158759, 'Armagh', 40.4536094665527, 0.706048679507292, -79.0322189331055, -1.37937243553969, 218, 45, 'PPL', 'P'),
(114436, 'Armah', 41.5313911437988, 0.724859518392903, -92.2091674804688, -1.60935357305706, 218, 16, 'PPL', 'P'),
(39145, 'Armant', 29.9961109161377, 0.523530898280015, -90.7300033569336, -1.583537288924, 218, 22, 'PPL', 'P'),
(84710, 'Armathwaite', 36.3741683959961, 0.634849001184996, -84.7822189331055, -1.47972886752936, 218, 50, 'PPL', 'P'),
(146868, 'Armawalk', 41.2877807617188, 0.720607715133565, -73.7713928222656, -1.28755369853065, 218, 40, 'PPL', 'P'),
(18910, 'Armboy', 31.7922191619873, 0.554878900892311, -83.5875015258789, -1.45887711514237, 218, 13, 'PPL', 'P'),
(158762, 'Armbrust', 40.2236099243164, 0.702034430217188, -79.5513916015625, -1.38843370799063, 218, 45, 'PPL', 'P'),
(99485, 'Armel', 39.0791702270508, 0.682060189409376, -78.1438903808594, -1.36386817746352, 218, 53, 'PPL', 'P'),
(186357, 'Armel', 39.7972183227539, 0.694592492867071, -102.107780456543, -1.78211696087019, 218, 7, 'PPL', 'P'),
(114437, 'Armel Acres Mobile Home Estates', 42.7880592346191, 0.746792514182469, -96.1805572509766, -1.67866740043245, 218, 16, 'PPL', 'P'),
(195890, 'Armells (historical)', 47.315559387207, 0.825812298729673, -109.183326721191, -1.90560853956549, 218, 31, 'PPL', 'P'),
(18911, 'Armena', 31.6808300018311, 0.552934793296553, -84.2847213745117, -1.47104589711127, 218, 13, 'PPL', 'P'),
(79565, 'Armenia', 34.7683296203613, 0.606821827293975, -81.2930603027344, -1.41883156130501, 218, 48, 'PPL', 'P'),
(71696, 'Armenia (historical)', 39.2249984741211, 0.684605372463165, -81.7013931274414, -1.42595831354012, 218, 41, 'PPL', 'P'),
(188077, 'Armenta Plaza (historical)', 35.8247184753418, 0.625259290994757, -104.370002746582, -1.82160018824338, 218, 38, 'PPL', 'P'),
(29114, 'Armiesburg', 39.7633285522461, 0.694001004788964, -87.3511123657227, -1.52456451606139, 218, 19, 'PPL', 'P'),
(44441, 'Armiger', 39.125, 0.682860069842781, -76.5350036621094, -1.33578780692973, 218, 25, 'PPL', 'P'),
(188078, 'Armijo', 35.0536117553711, 0.611800939847015, -106.676666259766, -1.86185906128405, 218, 38, 'PPL', 'P'),
(108018, 'Armilda', 38.1836090087891, 0.666429697497538, -82.4016723632813, -1.43818049188887, 218, 58, 'PPL', 'P'),
(200341, 'Armin (historical)', 45.3402786254883, 0.791337145786379, -116.987503051758, -2.04181711194009, 218, 43, 'PPL', 'P'),
(84711, 'Arminda', 36.0508308410645, 0.629205696256091, -83.79638671875, -1.46252284951664, 218, 50, 'PPL', 'P'),
(118648, 'Armington', 40.3388900756836, 0.704046448420743, -89.311393737793, -1.55877788026953, 218, 18, 'PPL', 'P'),
(195891, 'Armington', 47.3663902282715, 0.826699464267806, -110.902778625488, -1.93561863662516, 218, 31, 'PPL', 'P'),
(169261, 'Armington Corner', 41.7980613708496, 0.72951379187198, -71.3638916015625, -1.24553487548359, 218, 47, 'PPL', 'P'),
(195892, 'Armington Junction', 47.3480606079102, 0.82637955204186, -110.893608093262, -1.93545858064365, 218, 31, 'PPL', 'P'),
(209277, 'Arminto', 43.1788902282715, 0.753613801840543, -107.256942749023, -1.87198679659352, 218, 59, 'PPL', 'P'),
(39147, 'Armistead', 32.0052795410156, 0.558597506011902, -93.3802795410156, -1.62979333442342, 218, 22, 'PPL', 'P'),
(58484, 'Armistead', 34.3641700744629, 0.599767912514682, -90.6122207641602, -1.58148159487857, 218, 30, 'PPL', 'P'),
(179799, 'Armistead', 35.547779083252, 0.620425786774318, -117.926666259766, -2.05820860213342, 218, 6, 'PPL', 'P'),
(99487, 'Armistead Forest', 36.8727798461914, 0.643551412679048, -76.4116668701172, -1.33363517382062, 218, 53, 'PPL', 'P'),
(44442, 'Armistead Gardens', 39.3016700744629, 0.685943544331902, -76.5497207641602, -1.33604466881686, 218, 25, 'PPL', 'P'),
(44443, 'Armistead Homes', 39.3069381713867, 0.686035489968537, -76.557502746582, -1.33618049003246, 218, 25, 'PPL', 'P'),
(71697, 'Armitage', 39.3455581665039, 0.686709536040437, -82.0961074829102, -1.43284737864794, 218, 41, 'PPL', 'P'),
(58485, 'Armitage (historical)', 33.1783294677734, 0.579071089524104, -88.6111068725586, -1.54655556876272, 218, 30, 'PPL', 'P'),
(84712, 'Armona', 35.7872200012207, 0.62460481915687, -84.0141677856445, -1.46632384618245, 218, 50, 'PPL', 'P'),
(179800, 'Armona', 36.3158302307129, 0.633830808121232, -119.707496643066, -2.08928995574157, 218, 6, 'PPL', 'P'),
(146869, 'Armonk', 41.1263885498047, 0.717790889648588, -73.7144393920898, -1.28655967365378, 218, 40, 'PPL', 'P'),
(146870, 'Armor', 42.7405586242676, 0.745963472135127, -78.7991714477539, -1.37530498960681, 218, 40, 'PPL', 'P'),
(7162, 'Armorel', 35.9199981689453, 0.62692223535843, -89.7980575561523, -1.56727176625023, 218, 4, 'PPL', 'P'),
(177444, 'Armoryville (historical)', 41.3369407653809, 0.721465719057761, -72.9124984741211, -1.27256316422875, 218, 8, 'PPL', 'P'),
(53231, 'Armour', 39.5486106872559, 0.690253471082032, -95.0461120605469, -1.65886759667604, 218, 29, 'PPL', 'P'),
(62573, 'Armour', 34.3469390869141, 0.599467175048585, -78.2544403076172, -1.36579763767328, 218, 33, 'PPL', 'P'),
(114438, 'Armour', 42.5127792358398, 0.741987971838884, -92.254997253418, -1.61015345349047, 218, 16, 'PPL', 'P'),
(169750, 'Armour', 43.3186111450195, 0.756052391871702, -98.3463897705078, -1.71646830894503, 218, 49, 'PPL', 'P'),
(141199, 'Armour (historical)', 40.1194381713867, 0.700216290140991, -96.4199981689453, -1.682846432815, 218, 35, 'PPL', 'P'),
(133996, 'Armour Number Two Mine', 46.4850006103516, 0.811316313442208, -93.9683303833008, -1.64005675779042, 218, 28, 'PPL', 'P'),
(84713, 'Armour Village', 35.6327781677246, 0.621909300659547, -87.1580581665039, -1.52119508465023, 218, 50, 'PPL', 'P'),
(118651, 'Armsby (historical)', 42.4736099243164, 0.741304338387061, -88.4111099243164, -1.54306496352196, 218, 18, 'PPL', 'P'),
(13031, 'Armsleigh Park (historical)', 38.9452781677246, 0.679723332131859, -77.0772171020508, -1.34525121670527, 218, 9, 'PPL', 'P'),
(112827, 'Armstead', 33.8819389343262, 0.59135139136365, -86.5247192382813, -1.51014123507169, 218, 2, 'PPL', 'P'),
(195893, 'Armstead (historical)', 44.9724998474121, 0.784918195189989, -112.863327026367, -1.96983666136521, 218, 31, 'PPL', 'P'),
(7163, 'Armstrong', 36.3727798461914, 0.634824766419077, -91.3172225952148, -1.59378619806306, 218, 4, 'PPL', 'P'),
(13298, 'Armstrong', 39.4805603027344, 0.689065767814884, -75.7169418334961, -1.32150993453554, 218, 10, 'PPL', 'P'),
(15029, 'Armstrong', 29.7619400024414, 0.519443844823612, -81.4480590820313, -1.42153680034032, 218, 12, 'PPL', 'P'),
(29112, 'Armstrong', 38.1091690063477, 0.665130474359742, -87.647216796875, -1.52973251331475, 218, 19, 'PPL', 'P'),
(53232, 'Armstrong', 39.269718170166, 0.68538587839964, -92.7011108398438, -1.61793960441148, 218, 29, 'PPL', 'P'),
(75014, 'Armstrong', 34.0513916015625, 0.594308898333211, -96.3450012207031, -1.68153748913923, 218, 42, 'PPL', 'P'),
(92329, 'Armstrong', 26.9241695404053, 0.46991540684524, -97.7911071777344, -1.70677679942212, 218, 51, 'PPL', 'P'),
(99488, 'Armstrong', 38.1119384765625, 0.665178810733527, -79.5216674804688, -1.38791492421028, 218, 53, 'PPL', 'P'),
(112825, 'Armstrong', 32.2394409179688, 0.562684393020738, -85.6577835083008, -1.49501035218035, 218, 2, 'PPL', 'P'),
(114439, 'Armstrong', 43.396110534668, 0.757405011389353, -94.4780578613281, -1.64895318056989, 218, 16, 'PPL', 'P'),
(118652, 'Armstrong', 40.3063888549805, 0.703479195108556, -87.8777770996094, -1.53375654972186, 218, 18, 'PPL', 'P'),
(133998, 'Armstrong', 45.0113906860352, 0.785596968372823, -93.6866683959961, -1.63514082873425, 218, 28, 'PPL', 'P'),
(144764, 'Armstrong', 41.1494407653809, 0.718193226710271, -74.6902770996094, -1.3035912546151, 218, 37, 'PPL', 'P'),
(154094, 'Armstrong', 40.9122200012207, 0.71405294332158, -82.0111083984375, -1.43136386476271, 218, 41, 'PPL', 'P'),
(158766, 'Armstrong', 41.0941696166992, 0.717228563184418, -80.0519409179688, -1.39716994163053, 218, 45, 'PPL', 'P'),
(172963, 'Armstrong', 43.7102813720703, 0.762888326915772, -88.1947174072266, -1.53928820162206, 218, 57, 'PPL', 'P'),
(179802, 'Armstrong', 38.089168548584, 0.66478140051986, -121.273612976074, -2.11662384222181, 218, 6, 'PPL', 'P'),
(206711, 'Armstrong', 46.7602806091309, 0.816120855785793, -117.22444152832, -2.04595246848076, 218, 56, 'PPL', 'P'),
(18913, 'Armstrong (historical)', 33.810001373291, 0.590095844067733, -82.7624969482422, -1.44447806891859, 218, 13, 'PPL', 'P'),
(172964, 'Armstrong Creek', 45.6583290100098, 0.796888172183513, -88.4461135864258, -1.54367589267602, 218, 57, 'PPL', 'P'),
(99489, 'Armstrong Gardens', 37.0080604553223, 0.645912504722485, -76.3594436645508, -1.33272370693754, 218, 53, 'PPL', 'P'),
(92330, 'Armstrong Landing', 33.2272186279297, 0.579924366337366, -94.2786102294922, -1.64547216270905, 218, 51, 'PPL', 'P'),
(53233, 'Armstrong Quarry', 36.519718170166, 0.637389323969796, -94.4830627441406, -1.64904053225364, 218, 29, 'PPL', 'P'),
(92331, 'Armstrong''s Alton Colonia', 26.2880001068115, 0.458812155628482, -98.3119964599609, -1.71586803243533, 218, 51, 'PPL', 'P'),
(71698, 'Armstrongs Mills', 39.9080581665039, 0.696527013082905, -80.9349975585938, -1.41258218749103, 218, 41, 'PPL', 'P'),
(18914, 'Armuchee', 34.3888893127441, 0.600199344611275, -85.1819381713867, -1.48670528432094, 218, 13, 'PPL', 'P'),
(172966, 'Army Lake (historical)', 42.8066711425781, 0.747117353256431, -88.3752822875977, -1.54243965329801, 218, 57, 'PPL', 'P'),
(99490, 'Arna Valley', 38.8441696166992, 0.677958655014545, -77.0766677856445, -1.34524162932534, 218, 53, 'PPL', 'P'),
(39148, 'Arnaudville', 30.3974990844727, 0.53053644339601, -91.9313888549805, -1.60450542145063, 218, 22, 'PPL', 'P'),
(18915, 'Arnco Mills', 33.4147186279297, 0.583196858684855, -84.8536071777344, -1.48097482744536, 218, 13, 'PPL', 'P'),
(139608, 'Arndt', 48.6300010681152, 0.84875363388697, -99.2350006103516, -1.73197749386922, 218, 34, 'PPL', 'P'),
(158769, 'Arndts', 40.7994384765625, 0.712084534380875, -75.4772186279297, -1.31732597530497, 218, 45, 'PPL', 'P'),
(92332, 'Arneckeville', 28.9922199249268, 0.506009695152275, -97.2719421386719, -1.69771566012924, 218, 51, 'PPL', 'P'),
(112828, 'Arnedra Subdivision', 33.2911109924316, 0.581039498464809, -87.7022171020508, -1.53069244972967, 218, 2, 'PPL', 'P'),
(197949, 'Arnegard', 47.8077812194824, 0.834403190353078, -103.440559387207, -1.80537834141149, 218, 34, 'PPL', 'P'),
(134000, 'Arnesen', 48.9575004577637, 0.854469576534607, -95.0672225952148, -1.65923604501285, 218, 28, 'PPL', 'P'),
(7164, 'Arnett', 35.8950004577637, 0.626485942992848, -94.039436340332, -1.6412977908584, 218, 4, 'PPL', 'P'),
(34586, 'Arnett', 37.4102783203125, 0.652932530776907, -83.5686111450195, -1.45854741579942, 218, 21, 'PPL', 'P'),
(53235, 'Arnett', 36.5625, 0.638136007760427, -94.2219390869141, -1.64448306468019, 218, 29, 'PPL', 'P'),
(75016, 'Arnett', 34.7472190856934, 0.606453378957163, -99.9647216796875, -1.7447135291503, 218, 42, 'PPL', 'P'),
(108020, 'Arnett', 37.8333282470703, 0.660316144899152, -81.4302825927734, -1.42122654207332, 218, 58, 'PPL', 'P'),
(146871, 'Arnett', 43.1438903808594, 0.753002939265506, -77.6408309936523, -1.35508813482369, 218, 40, 'PPL', 'P'),
(191087, 'Arnett', 33.4925003051758, 0.584554405050523, -102.291389465332, -1.78532154260989, 218, 51, 'PPL', 'P'),
(108021, 'Arnettsville', 39.5855598449707, 0.690898355539995, -80.0924987792969, -1.39787780984827, 218, 58, 'PPL', 'P'),
(29115, 'Arney', 39.2186088562012, 0.684493852592518, -86.9316711425781, -1.51724388569893, 218, 19, 'PPL', 'P'),
(191088, 'Arney', 34.6872215270996, 0.605406224016544, -102.102500915527, -1.78202481549648, 218, 51, 'PPL', 'P'),
(144767, 'Arneys Mount', 40.0097198486328, 0.69830134415917, -74.6969375610352, -1.30370750159669, 218, 37, 'PPL', 'P'),
(144765, 'Arneytown', 40.101390838623, 0.699901304763062, -74.5663909912109, -1.30142903412607, 218, 37, 'PPL', 'P'),
(71701, 'Arnheim', 38.9333305358887, 0.679514806618506, -83.8274993896484, -1.4630658680629, 218, 41, 'PPL', 'P'),
(129566, 'Arnheim', 46.9169387817383, 0.81885505669795, -88.4824981689453, -1.54431092343795, 218, 27, 'PPL', 'P'),
(53236, 'Arnica', 37.7516708374023, 0.658890954241796, -93.7083282470703, -1.63551886445098, 218, 29, 'PPL', 'P'),
(15030, 'Arno', 29.7716693878174, 0.519613654632618, -82.5555572509766, -1.44086628984822, 218, 12, 'PPL', 'P'),
(53237, 'Arno', 36.9397201538086, 0.644719741449266, -92.746940612793, -1.61873948484488, 218, 29, 'PPL', 'P'),
(84714, 'Arno', 35.8030586242676, 0.624881255278021, -86.7416687011719, -1.51392771750956, 218, 50, 'PPL', 'P'),
(99491, 'Arno', 36.9272193908691, 0.644501561976961, -82.8122177124023, -1.44534585995979, 218, 53, 'PPL', 'P'),
(191089, 'Arno', 31.6630592346191, 0.5526246348981, -103.635559082031, -1.80878172812656, 218, 51, 'PPL', 'P'),
(179803, 'Arno (historical)', 38.3333282470703, 0.669042791159123, -121.335563659668, -2.11770508562439, 218, 6, 'PPL', 'P'),
(34588, 'Arnold', 37.3913917541504, 0.652602898012982, -86.6588897705078, -1.51248295261819, 218, 21, 'PPL', 'P'),
(44444, 'Arnold', 39.0319404602051, 0.681235874472969, -76.503059387207, -1.33523027415552, 218, 25, 'PPL', 'P'),
(53238, 'Arnold', 38.4327812194824, 0.67077857297861, -90.3775024414063, -1.57738498733175, 218, 29, 'PPL', 'P'),
(62574, 'Arnold', 35.8933296203613, 0.626456781378911, -80.2808303833008, -1.4011648164237, 218, 33, 'PPL', 'P'),
(92334, 'Arnold', 33.269718170166, 0.58066612327998, -96.3308334350586, -1.68129021463201, 218, 51, 'PPL', 'P'),
(114441, 'Arnold', 42.8108291625977, 0.747189924396136, -94.1983337402344, -1.64407107365955, 218, 16, 'PPL', 'P'),
(118653, 'Arnold', 42.1699981689453, 0.736005313608076, -90.2263870239258, -1.57474752574619, 218, 18, 'PPL', 'P'),
(129567, 'Arnold', 46.0508308410645, 0.803738621455524, -87.491943359375, -1.52702248058948, 218, 27, 'PPL', 'P'),
(134001, 'Arnold', 46.8802795410156, 0.818215232246059, -92.0902786254883, -1.60727857109373, 218, 28, 'PPL', 'P'),
(154096, 'Arnold', 40.1419410705566, 0.700609039822751, -83.2508316040039, -1.45300111651322, 218, 41, 'PPL', 'P'),
(158770, 'Arnold', 40.5800018310547, 0.708254642417232, -79.7669372558594, -1.39219568934648, 218, 45, 'PPL', 'P'),
(172967, 'Arnold', 45.2488899230957, 0.789742112030504, -91.0041732788086, -1.58832245677065, 218, 57, 'PPL', 'P'),
(177181, 'Arnold', 40.2986106872559, 0.70334344047199, -80.5802764892578, -1.40639113690493, 218, 58, 'PPL', 'P'),
(179805, 'Arnold', 39.5188903808594, 0.689734753880712, -123.392501831055, -2.15360542922504, 218, 6, 'PPL', 'P'),
(192927, 'Arnold', 38.6402816772461, 0.674400139165981, -100.045829772949, -1.74612913242773, 218, 20, 'PPL', 'P'),
(195894, 'Arnold', 45.7144393920898, 0.797867483095363, -111.35417175293, -1.94349693291989, 218, 31, 'PPL', 'P'),
(197952, 'Arnold', 46.9238891601563, 0.818976363685603, -100.753059387207, -1.75847261776414, 218, 34, 'PPL', 'P'),
(199150, 'Arnold', 41.4225006103516, 0.722959020059996, -100.193061828613, -1.74869881656355, 218, 35, 'PPL', 'P'),
(179806, 'Arnold (historical)', 37.7630615234375, 0.65908975921717, -120.740829467773, -2.10732501580164, 218, 6, 'PPL', 'P'),
(158771, 'Arnold City', 40.1163902282715, 0.700163093498217, -79.8252792358398, -1.39321394898927, 218, 45, 'PPL', 'P'),
(126770, 'Arnold Corner', 44.7383308410645, 0.780831175023099, -69.0652770996094, -1.20541648419042, 218, 26, 'PPL', 'P'),
(44445, 'Arnold Heights', 38.8536109924316, 0.678123438106994, -76.9366683959961, -1.3427981790252, 218, 25, 'PPL', 'P'),
(179807, 'Arnold Heights', 33.8936080932617, 0.591555056608014, -117.278060913086, -2.04688830328782, 218, 6, 'PPL', 'P'),
(108023, 'Arnold Hill', 38.8833312988281, 0.678642155308314, -79.8638916015625, -1.39388786190311, 218, 58, 'PPL', 'P'),
(58486, 'Arnold Line', 31.3349990844727, 0.546898905133457, -89.3733291625977, -1.559858857356, 218, 30, 'PPL', 'P'),
(18916, 'Arnold Mill', 34.1175003051758, 0.595462712875488, -84.3880615234375, -1.47284952295953, 218, 13, 'PPL', 'P'),
(169262, 'Arnold Mills', 41.978328704834, 0.7326600503838, -71.3925018310547, -1.24603421818798, 218, 47, 'PPL', 'P'),
(193044, 'Arnold Place', 34.4533309936523, 0.601324064118643, -111.917503356934, -1.9533289241903, 218, 5, 'PPL', 'P'),
(177447, 'Arnolds', 41.4658317565918, 0.723715291230551, -72.5149993896484, -1.26562549643104, 218, 8, 'PPL', 'P'),
(99492, 'Arnolds Corner', 38.2761116027832, 0.668044172329371, -77.2041702270508, -1.34746696673221, 218, 53, 'PPL', 'P'),
(126771, 'Arnolds Landing', 44.9566688537598, 0.784641892226893, -69.870002746582, -1.21946159630534, 218, 26, 'PPL', 'P'),
(146872, 'Arnolds Mill', 42.3413887023926, 0.73899664272348, -73.5955581665039, -1.28448480484849, 218, 40, 'PPL', 'P'),
(114442, 'Arnolds Park', 43.3727798461914, 0.75699781405868, -95.1236114501953, -1.66022021619369, 218, 16, 'PPL', 'P'),
(108024, 'Arnoldsburg', 38.788890838623, 0.676993858330637, -81.1277770996094, -1.41594682521224, 218, 58, 'PPL', 'P'),
(18918, 'Arnoldsville', 33.9049987792969, 0.591753861583389, -83.2169418334961, -1.45240962843511, 218, 13, 'PPL', 'P'),
(44446, 'Arnoldtown', 39.4094390869141, 0.687824468430798, -77.6061096191406, -1.35448213251765, 218, 25, 'PPL', 'P'),
(124123, 'Arnoldville', 42.5880584716797, 0.743301842362675, -73.1341705322266, -1.27643207150237, 218, 23, 'PPL', 'P'),
(58487, 'Arnot', 31.2555599212646, 0.545512430180448, -91.6083297729492, -1.59886697679071, 218, 30, 'PPL', 'P'),
(158773, 'Arnot', 41.6624984741211, 0.727147772980527, -77.1233291625977, -1.34605602398669, 218, 45, 'PPL', 'P'),
(112830, 'Arnot (historical)', 34.9191703796387, 0.609454495189573, -87.5708312988281, -1.52839933487305, 218, 2, 'PPL', 'P'),
(158778, 'Arnots Addition', 40.7180595397949, 0.710664203992508, -76.2002792358398, -1.32994576360447, 218, 45, 'PPL', 'P'),
(172968, 'Arnott', 44.457218170166, 0.775924833346846, -89.4466705322266, -1.56113890573394, 218, 57, 'PPL', 'P'),
(53239, 'Arnsberg', 37.5697212219238, 0.655715334378958, -89.7774963378906, -1.56691290529334, 218, 29, 'PPL', 'P'),
(193043, 'Arntz', 34.9358291625977, 0.609745245801583, -110.041938781738, -1.92059414701937, 218, 5, 'PPL', 'P'),
(200342, 'Arock', 42.9141693115234, 0.748993550244392, -117.524169921875, -2.05118371581001, 218, 43, 'PPL', 'P'),
(99493, 'Aroda', 38.3263893127441, 0.668921683908552, -78.2324981689453, -1.36541467510853, 218, 53, 'PPL', 'P'),
(212286, 'Arolokovik', 62.3847198486328, 1.0888187642929, -163.800567626953, -2.85885922172597, 218, 1, 'PPL', 'P'),
(53240, 'Aroma', 36.8636093139648, 0.643391356697535, -94.2644424438477, -1.64522488820183, 218, 29, 'PPL', 'P'),
(122160, 'Aroma', 40.1994400024414, 0.70161258550052, -85.8741683959961, -1.49878698092219, 218, 19, 'PPL', 'P'),
(118654, 'Aroma Park', 41.079719543457, 0.716976361829187, -87.811393737793, -1.53259794148962, 218, 18, 'PPL', 'P'),
(179808, 'Aromas', 36.8886108398438, 0.643827715642144, -121.641937255859, -2.1230523136191, 218, 6, 'PPL', 'P'),
(75017, 'Aron', 35.6824989318848, 0.622777091700749, -96.5119400024414, -1.68445112052983, 218, 42, 'PPL', 'P'),
(112831, 'Arona', 34.2216682434082, 0.597280786372657, -86.0819396972656, -1.5024132742205, 218, 2, 'PPL', 'P'),
(158774, 'Arona', 40.2691688537598, 0.702829583539659, -79.6616668701172, -1.39035837451043, 218, 45, 'PPL', 'P'),
(77800, 'Aronimink', 39.9505615234375, 0.697268836604546, -75.3188934326172, -1.3145626793579, 218, 45, 'PPL', 'P'),
(158776, 'Aronwold', 40.014720916748, 0.698388629263897, -75.414436340332, -1.31623021767446, 218, 45, 'PPL', 'P'),
(186359, 'Aroya', 38.8541717529297, 0.678133225224, -103.125, -1.79987079111915, 218, 7, 'PPL', 'P'),
(18920, 'Arp', 31.7558307647705, 0.554243803551354, -83.4069366455078, -1.45572566346643, 218, 13, 'PPL', 'P'),
(84715, 'Arp', 35.7733306884766, 0.624362404918646, -89.6025009155273, -1.56385865899719, 218, 50, 'PPL', 'P'),
(92335, 'Arp', 32.2252807617188, 0.562437251671578, -95.057502746582, -1.65906640165141, 218, 51, 'PPL', 'P'),
(7165, 'Arp (historical)', 34.1061096191406, 0.595263907900113, -93.6316680908203, -1.63418089231933, 218, 4, 'PPL', 'P'),
(201868, 'Arpan', 44.788330078125, 0.78170382633329, -103.648612976074, -1.80900956155781, 218, 49, 'PPL', 'P'),
(118656, 'Arpee', 41.1830596923828, 0.718779987677443, -90.9469375610352, -1.58732350504576, 218, 18, 'PPL', 'P'),
(75018, 'Arpelar', 34.9419403076172, 0.60985190540324, -95.9652786254883, -1.67491007960851, 218, 42, 'PPL', 'P'),
(172969, 'Arpin', 44.5405616760254, 0.777379451934247, -90.0350036621094, -1.57140725594896, 218, 57, 'PPL', 'P'),
(15031, 'Arran', 30.1902809143066, 0.526919804056655, -84.4161071777344, -1.47333901196788, 218, 12, 'PPL', 'P'),
(15032, 'Arrant Settlement', 30.8591709136963, 0.538594136879667, -85.9741668701172, -1.50053228354257, 218, 12, 'PPL', 'P'),
(15033, 'Arredondo', 29.6047191619873, 0.516699823504935, -82.4094390869141, -1.43831604678836, 218, 12, 'PPL', 'P'),
(92345, 'Arredondo Colonia', 26.3840007781982, 0.460487683428305, -98.8369979858398, -1.72503103763991, 218, 51, 'PPL', 'P'),
(15034, 'Arredondo Estates', 29.6047191619873, 0.516699823504935, -82.416389465332, -1.43843735377601, 218, 12, 'PPL', 'P'),
(188079, 'Arrey', 32.8486099243164, 0.573316397882607, -107.31861114502, -1.87306311314807, 218, 38, 'PPL', 'P'),
(92336, 'Arriaga Colonia', 26.2210006713867, 0.457642794883342, -98.0859985351563, -1.71192362454481, 218, 51, 'PPL', 'P'),
(186361, 'Arriba', 39.2861099243164, 0.685671968479742, -103.275001525879, -1.80248881162875, 218, 7, 'PPL', 'P'),
(188080, 'Arriba', 35.6233291625977, 0.621744384409044, -105.20027923584, -1.83609124668283, 218, 38, 'PPL', 'P'),
(62579, 'Arringdale', 36.5311088562012, 0.63758812894517, -76.184440612793, -1.32966932748332, 218, 33, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(99494, 'Arringdale', 36.7177810668945, 0.640846173643746, -77.3363876342773, -1.34977459581677, 218, 53, 'PPL', 'P'),
(31674, 'Arrington', 39.4627799987793, 0.688755442968863, -95.5361099243164, -1.66741967272655, 218, 20, 'PPL', 'P'),
(84716, 'Arrington', 35.8680610656738, 0.626015761902394, -86.7091674804688, -1.51336046419738, 218, 50, 'PPL', 'P'),
(99495, 'Arrington', 37.6838912963867, 0.657707978085583, -78.9013900756836, -1.37708904122106, 218, 53, 'PPL', 'P'),
(112829, 'Arrington (historical)', 32.4844398498535, 0.566960431045996, -88.1191711425781, -1.53796967056636, 218, 2, 'PPL', 'P'),
(34589, 'Arrington Corner', 37.7747192382813, 0.659293224724452, -86.7486114501953, -1.51404889133916, 218, 21, 'PPL', 'P'),
(99496, 'Arrington Court', 37.2930603027344, 0.650886690427508, -79.9024963378906, -1.3945616416589, 218, 53, 'PPL', 'P'),
(44458, 'Arrington Estates', 39.3902816772461, 0.687490108555939, -76.9341735839844, -1.34275463634137, 218, 25, 'PPL', 'P'),
(186360, 'Arriola', 37.4425010681152, 0.653494923820104, -108.645561218262, -1.89622276093573, 218, 7, 'PPL', 'P'),
(146873, 'Arrochar', 40.598331451416, 0.708574554643178, -74.0730590820313, -1.29281876800573, 218, 40, 'PPL', 'P'),
(189885, 'Arrolime', 36.351390838623, 0.634451457813275, -114.908332824707, -2.00552874576861, 218, 39, 'PPL', 'P'),
(53241, 'Arroll', 37.1074981689453, 0.647648020225863, -91.7263870239258, -1.60092746452611, 218, 29, 'PPL', 'P'),
(84717, 'Arrow', 35.5122184753418, 0.619805137082275, -87.1930618286133, -1.52180601380429, 218, 50, 'PPL', 'P'),
(194534, 'Arrow', 46.4780616760254, 0.811195206191637, -116.766937255859, -2.03796751258438, 218, 17, 'PPL', 'P'),
(195895, 'Arrow Creek', 47.3444404602051, 0.826316368544998, -110.174438476563, -1.92290670295194, 218, 31, 'PPL', 'P'),
(18921, 'Arrow Head', 33.4983291625977, 0.584656137804164, -82.1041717529297, -1.43298812671155, 218, 13, 'PPL', 'P'),
(84718, 'Arrow Hills', 36.1733283996582, 0.631343681979207, -83.408332824707, -1.4557500313904, 218, 50, 'PPL', 'P'),
(53242, 'Arrow Point', 36.5447196960449, 0.637825682914405, -93.6191711425781, -1.63396277942605, 218, 29, 'PPL', 'P'),
(118657, 'Arrow Ridge Mobile Home Park', 41.6777801513672, 0.727414488563698, -87.7763900756836, -1.53198701233555, 218, 18, 'PPL', 'P'),
(53243, 'Arrow Rock', 39.0697212219238, 0.681895273158873, -92.9463882446289, -1.62222050270573, 218, 29, 'PPL', 'P'),
(99497, 'Arrow Wood', 37.3208312988281, 0.651371385745903, -79.9916687011719, -1.39611799299995, 218, 53, 'PPL', 'P'),
(179809, 'Arrowbear Lake', 34.2108306884766, 0.597091635356235, -117.082496643066, -2.04347506287672, 218, 6, 'PPL', 'P'),
(44449, 'Arrowhead', 39.1875, 0.683950900625278, -76.8625030517578, -1.34150374957736, 218, 25, 'PPL', 'P'),
(53245, 'Arrowhead', 38.1811103820801, 0.666386088234687, -92.628059387207, -1.6166646160396, 218, 29, 'PPL', 'P'),
(84719, 'Arrowhead', 35.8855590820313, 0.626321159900399, -83.9375, -1.46498574089274, 218, 50, 'PPL', 'P'),
(99501, 'Arrowhead', 36.834171295166, 0.642877566344231, -76.1872177124023, -1.32971779701516, 218, 53, 'PPL', 'P'),
(112972, 'Arrowhead', 33.6586112976074, 0.587453588792211, -86.6680603027344, -1.51264300859971, 218, 2, 'PPL', 'P'),
(154097, 'Arrowhead', 40.5536117553711, 0.707794048706703, -81.248893737793, -1.41806070932749, 218, 41, 'PPL', 'P'),
(189886, 'Arrowhead', 36.6588897705078, 0.63981832662103, -114.574996948242, -1.99971093720928, 218, 39, 'PPL', 'P'),
(194091, 'Arrowhead', 40.5791702270508, 0.708240128189291, -105.023887634277, -1.8330126324627, 218, 7, 'PPL', 'P'),
(44450, 'Arrowhead Acres', 39.6022186279297, 0.691189106152004, -76.0736083984375, -1.32773494042554, 218, 25, 'PPL', 'P'),
(53246, 'Arrowhead Beach', 38.1800003051758, 0.666366713737757, -92.6294403076172, -1.61668871764747, 218, 29, 'PPL', 'P'),
(62582, 'Arrowhead Beach', 36.2230606079102, 0.632211672757491, -76.709716796875, -1.33883712637787, 218, 33, 'PPL', 'P'),
(154098, 'Arrowhead Beach', 41.6988906860352, 0.727782936900511, -81.3891677856445, -1.4205089533176, 218, 41, 'PPL', 'P'),
(179811, 'Arrowhead Equestrian Estates', 34.357780456543, 0.599656392644035, -117.248893737793, -2.04637924004545, 218, 6, 'PPL', 'P'),
(201869, 'Arrowhead Estates', 44.0361099243164, 0.768575107949472, -103.276390075684, -1.80251304639467, 218, 49, 'PPL', 'P'),
(44451, 'Arrowhead Farms Estates', 38.982780456543, 0.680377870548773, -76.6936111450195, -1.33855602972481, 218, 25, 'PPL', 'P'),
(179813, 'Arrowhead Highlands', 34.2299995422363, 0.597426194968176, -117.261940002441, -2.04660694031865, 218, 6, 'PPL', 'P'),
(179814, 'Arrowhead Junction', 34.9427795410156, 0.609866552789236, -114.823608398438, -2.00405002557335, 218, 6, 'PPL', 'P'),
(158777, 'Arrowhead Lake', 41.1508293151855, 0.718217461476191, -75.5741729736328, -1.31901814786161, 218, 45, 'PPL', 'P'),
(114443, 'Arrowhead Mobile Home Park', 41.9861106872559, 0.732795871599394, -92.5908279418945, -1.61601480473362, 218, 16, 'PPL', 'P'),
(122161, 'Arrowhead Park', 41.2788887023926, 0.72045251942104, -85.7900009155273, -1.4973179812649, 218, 19, 'PPL', 'P'),
(84720, 'Arrowhead Point', 35.2077789306641, 0.614491664654376, -84.8186111450195, -1.48036403144935, 218, 50, 'PPL', 'P'),
(193045, 'Arrowhead Ranch', 33.6683311462402, 0.587623232153649, -112.191673278809, -1.95811409203695, 218, 5, 'PPL', 'P'),
(179815, 'Arrowhead Springs', 34.1866683959961, 0.596669923797621, -117.260833740234, -2.04658763240075, 218, 6, 'PPL', 'P'),
(209278, 'Arrowhead Springs', 41.5069389343262, 0.724432746828218, -109.156936645508, -1.90514794585497, 218, 59, 'PPL', 'P'),
(144766, 'Arrowhead Village', 40.0763893127441, 0.699464945818453, -74.1041717529297, -1.293361786552, 218, 37, 'PPL', 'P'),
(79568, 'Arrowood', 34.1733283996582, 0.59643709693932, -79.841667175293, -1.39349997249034, 218, 48, 'PPL', 'P'),
(194092, 'Arrowood', 40.1872215270996, 0.701399332876232, -105.510276794434, -1.84150172475343, 218, 7, 'PPL', 'P'),
(79569, 'Arrowood Estates', 34.7597198486328, 0.606671558429468, -80.7930603027344, -1.41010491504504, 218, 48, 'PPL', 'P'),
(126773, 'Arrowsic', 43.8497200012207, 0.765321990098913, -69.7786102294922, -1.21786649597043, 218, 26, 'PPL', 'P'),
(118658, 'Arrowsmith', 40.4494400024414, 0.705975908630506, -88.6316680908203, -1.54691442971961, 218, 18, 'PPL', 'P'),
(79570, 'Arrowwood', 35.1672210693359, 0.613783796436633, -81.8847198486328, -1.4291579684318, 218, 48, 'PPL', 'P'),
(158783, 'Arroyo', 41.3908309936523, 0.72240628097575, -78.8805618286133, -1.37672551973226, 218, 45, 'PPL', 'P'),
(92337, 'Arroyo Alto', 26.1352806091309, 0.456146697561963, -97.8216705322266, -1.70731023058847, 218, 51, 'PPL', 'P'),
(92338, 'Arroyo Alto Colonia', 26.1350002288818, 0.45614180400346, -97.8219985961914, -1.70731595638481, 218, 51, 'PPL', 'P'),
(92339, 'Arroyo City', 26.3374195098877, 0.459674686926532, -97.4339294433594, -1.70054287194247, 218, 51, 'PPL', 'P'),
(92340, 'Arroyo City Subdivision Colonia', 26.3449993133545, 0.459806979453681, -97.4189987182617, -1.7002822816298, 218, 51, 'PPL', 'P'),
(92341, 'Arroyo Colorado Estates Colonia', 26.1889991760254, 0.457084263423725, -97.6080017089844, -1.70358100611403, 218, 51, 'PPL', 'P'),
(188085, 'Arroyo del Agua', 36.1594390869141, 0.631101267740982, -106.651672363281, -1.8614228354975, 218, 38, 'PPL', 'P'),
(179820, 'Arroyo Fairways Mobile Home Club', 33.7458305358887, 0.5889758516713, -116.911109924316, -2.04048380034034, 218, 6, 'PPL', 'P'),
(92342, 'Arroyo Gardens Number 1 Colonia', 26.1949996948242, 0.457188992233592, -97.5029983520508, -1.70174835180989, 218, 51, 'PPL', 'P'),
(92343, 'Arroyo Gardens Number 2 Colonia', 26.2369995117188, 0.457922027323637, -97.4980010986328, -1.70166113328419, 218, 51, 'PPL', 'P'),
(92344, 'Arroyo Gardens Number 4 Colonia', 26.2439994812012, 0.458044199838644, -97.4800033569336, -1.70134701343362, 218, 51, 'PPL', 'P'),
(179821, 'Arroyo Grande', 35.1186103820801, 0.612935379892361, -120.589721679688, -2.10468768737413, 218, 6, 'PPL', 'P'),
(206712, 'Arroyo Heights', 47.5063896179199, 0.829142914567954, -122.380279541016, -2.13593881750178, 218, 56, 'PPL', 'P'),
(188081, 'Arroyo Hondo', 36.535831451416, 0.637670553780908, -105.669166564941, -1.84427487439653, 218, 38, 'PPL', 'P'),
(179823, 'Arroyo Mobile Home Park', 34.3733291625977, 0.599927768759114, -119.306106567383, -2.08228437733606, 218, 6, 'PPL', 'P'),
(188084, 'Arroyo Seco', 35.9652786254883, 0.627712528411911, -106.029998779297, -1.8505725845843, 218, 38, 'PPL', 'P'),
(179826, 'Arroyo Vista', 38.723331451416, 0.675849631168284, -121.053611755371, -2.11278409656214, 218, 6, 'PPL', 'P'),
(179827, 'Arroz', 38.6208305358887, 0.674060652706023, -121.970001220703, -2.12877810996277, 218, 6, 'PPL', 'P'),
(62584, 'Arrwood Mill', 35.1105613708496, 0.61279489814486, -83.9408264160156, -1.4650437978045, 218, 33, 'PPL', 'P'),
(202912, 'Arsenal', 41.1341705322266, 0.717926710864182, -112.022216796875, -1.95515651848836, 218, 52, 'PPL', 'P'),
(146874, 'Arsenal Hill', 42.8833312988281, 0.748455325388087, -77.2966690063477, -1.34908137498502, 218, 40, 'PPL', 'P'),
(202913, 'Arsenal Villa', 41.1597213745117, 0.718372657188716, -112.033332824707, -1.95535052977378, 218, 52, 'PPL', 'P'),
(99502, 'Arsenic Mine (historical)', 37.0572204589844, 0.646770508646682, -80.2547225952148, -1.40070914956119, 218, 53, 'PPL', 'P'),
(146875, 'Arshamonaque', 41.0894393920898, 0.717146005190625, -72.39111328125, -1.26346327594201, 218, 40, 'PPL', 'P'),
(29116, 'Art', 39.4027786254883, 0.687708221449216, -87.1552810668945, -1.52114661511839, 218, 19, 'PPL', 'P'),
(92346, 'Art', 30.7383308410645, 0.536485079743892, -99.1111068725586, -1.72981514022213, 218, 51, 'PPL', 'P'),
(146876, 'Art Village', 40.8838882446289, 0.713558460886179, -72.4236068725586, -1.26403039609614, 218, 40, 'PPL', 'P'),
(154099, 'Artanna', 40.3219413757324, 0.703750637802663, -82.3105621337891, -1.43659031840199, 218, 41, 'PPL', 'P'),
(169757, 'Artas', 45.8880615234375, 0.80089776094171, -99.8061065673828, -1.74194517319717, 218, 49, 'PPL', 'P'),
(77801, 'Artemas', 39.746940612793, 0.69371498128789, -78.4391708374023, -1.36902179364699, 218, 45, 'PPL', 'P'),
(34590, 'Artemus', 36.8333282470703, 0.642862852379208, -83.841667175293, -1.46331314257012, 218, 21, 'PPL', 'P'),
(44452, 'Arters Mill', 39.6650009155273, 0.692284863782517, -77.0719375610352, -1.34515907133155, 218, 25, 'PPL', 'P'),
(44453, 'Arters Mill Estates', 39.688060760498, 0.692687334002256, -77.0730590820313, -1.34517864556556, 218, 25, 'PPL', 'P'),
(193047, 'Artesa', 31.8994407653809, 0.556750270900796, -111.851669311523, -1.95217990333798, 218, 5, 'PPL', 'P'),
(58490, 'Artesia', 33.4152793884277, 0.583206645801861, -88.6438903808594, -1.54712774892293, 218, 30, 'PPL', 'P'),
(62586, 'Artesia', 34.3222198486328, 0.599035742951992, -78.5752792358398, -1.37139733333934, 218, 33, 'PPL', 'P'),
(179828, 'Artesia', 33.8658294677734, 0.591070228131565, -118.082221984863, -2.0609235617067, 218, 6, 'PPL', 'P'),
(188086, 'Artesia', 32.8422203063965, 0.57320487801196, -104.402778625488, -1.82217223524553, 218, 38, 'PPL', 'P'),
(193048, 'Artesia', 32.6980590820313, 0.57068878999308, -109.706939697266, -1.91474731000416, 218, 5, 'PPL', 'P'),
(18924, 'Artesia (historical)', 31.5499992370605, 0.550651365688406, -83.9674987792969, -1.46550931836305, 218, 13, 'PPL', 'P'),
(189888, 'Artesia (historical)', 38.9538917541504, 0.679873667575394, -119.374443054199, -2.08347707403025, 218, 39, 'PPL', 'P'),
(129568, 'Artesia Beach', 44.3563919067383, 0.774165083077549, -84.4916687011719, -1.47465780933969, 218, 27, 'PPL', 'P'),
(172972, 'Artesia Beach', 43.9347190856934, 0.766805503984142, -88.3150024414063, -1.54138757150937, 218, 57, 'PPL', 'P'),
(92347, 'Artesia Wells', 28.2797203063965, 0.493574230889718, -99.2841720581055, -1.7328356975305, 218, 51, 'PPL', 'P'),
(7166, 'Artesian', 33.401668548584, 0.582969091832626, -92.4688873291016, -1.61388653954849, 218, 4, 'PPL', 'P'),
(114444, 'Artesian', 42.728328704834, 0.745750019773757, -92.3369369506836, -1.61158357099584, 218, 16, 'PPL', 'P'),
(169754, 'Artesian', 44.0091705322266, 0.768104926859019, -97.9205627441406, -1.70903622529095, 218, 49, 'PPL', 'P'),
(206713, 'Artesian', 46.5522193908691, 0.812489502481416, -120.353332519531, -2.10056191821338, 218, 56, 'PPL', 'P'),
(209856, 'Artesian City', 42.4172210693359, 0.740320167206222, -114.160278320313, -1.99247273168256, 218, 17, 'PPL', 'P'),
(212287, 'Artesian Village', 61.2275009155273, 1.06862148374379, -149.781387329102, -2.61417836709774, 218, 1, 'PPL', 'P'),
(7167, 'Artex', 33.3875007629395, 0.582721817325412, -93.8319396972656, -1.63767629125006, 218, 4, 'PPL', 'P'),
(7168, 'Arthur', 35.3013916015625, 0.61612551398314, -92.6427764892578, -1.61692147792674, 218, 4, 'PPL', 'P'),
(26397, 'Arthur', 39.7147216796875, 0.69315265482372, -88.4722213745117, -1.54413155953853, 218, 18, 'PPL', 'P'),
(29118, 'Arthur', 38.3405609130859, 0.669169024994793, -87.2458267211914, -1.52272693490924, 218, 19, 'PPL', 'P'),
(34591, 'Arthur', 37.1755599975586, 0.648835923230093, -86.206672668457, -1.50459027525358, 218, 21, 'PPL', 'P'),
(53247, 'Arthur', 38.0130615234375, 0.663453082347156, -94.3691711425781, -1.64705274881601, 218, 29, 'PPL', 'P'),
(79572, 'Arthur', 33.9716682434082, 0.592917463242672, -81.1377792358398, -1.41612139542169, 218, 48, 'PPL', 'P'),
(84728, 'Arthur', 36.5480613708496, 0.637884006142278, -83.6708297729492, -1.46033146741366, 218, 50, 'PPL', 'P'),
(108025, 'Arthur', 39.0672187805176, 0.681851597316996, -79.1122207641602, -1.38076873089922, 218, 58, 'PPL', 'P'),
(114445, 'Arthur', 42.3347206115723, 0.738880262583843, -95.3472213745117, -1.66412294561314, 218, 16, 'PPL', 'P'),
(139611, 'Arthur', 47.1041717529297, 0.822122888513532, -97.2177810668945, -1.69677037110032, 218, 34, 'PPL', 'P'),
(146877, 'Arthur', 43.4949989318848, 0.759130939512806, -76.2483291625977, -1.33078439303174, 218, 40, 'PPL', 'P'),
(154100, 'Arthur', 41.1947212219238, 0.718983519763753, -84.3608322143555, -1.472374281863, 218, 41, 'PPL', 'P'),
(172973, 'Arthur', 42.8466682434082, 0.747815434357168, -90.4463882446289, -1.57858727140587, 218, 57, 'PPL', 'P'),
(199152, 'Arthur', 41.5716705322266, 0.725562526341657, -101.691108703613, -1.77484466688151, 218, 35, 'PPL', 'P'),
(199815, 'Arthur', 40.7966690063477, 0.71203619800709, -115.190002441406, -2.01044480798285, 218, 39, 'PPL', 'P'),
(202914, 'Arthur', 40.7172203063965, 0.710649556606513, -112.135833740234, -1.95713950823604, 218, 52, 'PPL', 'P'),
(7170, 'Arthur (historical)', 35.4555587768555, 0.618816238790501, -90.600830078125, -1.58128278990319, 218, 4, 'PPL', 'P'),
(195896, 'Arthur (historical)', 48.0611114501953, 0.838824636973855, -105.172218322754, -1.83560149135836, 218, 31, 'PPL', 'P'),
(129569, 'Arthur Bay', 45.3088912963867, 0.79078933355015, -87.4355621337891, -1.5260384425667, 218, 27, 'PPL', 'P'),
(92348, 'Arthur City', 33.8702812194824, 0.591147925856368, -95.5061111450195, -1.66689609525624, 218, 51, 'PPL', 'P'),
(31675, 'Arthur Heights', 37.769718170166, 0.659205939619725, -97.2647171020508, -1.69758955945162, 218, 20, 'PPL', 'P'),
(146883, 'Arthur Manor', 40.9766693115234, 0.715177795987002, -73.793327331543, -1.28793652793735, 218, 40, 'PPL', 'P'),
(44454, 'Arthur Ridge', 39.4172210693359, 0.687960289646392, -77.0277786254883, -1.34438835251208, 218, 25, 'PPL', 'P'),
(53248, 'Arthur Spring Ford', 38.2058296203613, 0.66681752033128, -91.5677795410156, -1.59815924173102, 218, 29, 'PPL', 'P'),
(108026, 'Arthurdale', 39.4949989318848, 0.689317769433033, -79.8152770996094, -1.39303937877981, 218, 58, 'PPL', 'P'),
(34592, 'Arthurmabel', 37.5950012207031, 0.656156553592557, -82.9475021362305, -1.44770701858225, 218, 21, 'PPL', 'P'),
(158779, 'Arthurs', 41.2708282470703, 0.720311837936457, -79.3908309936523, -1.38563139673359, 218, 45, 'PPL', 'P'),
(146879, 'Arthursburg', 41.6283302307129, 0.726551424633431, -73.7719421386719, -1.28756328591057, 218, 40, 'PPL', 'P'),
(79573, 'Arthurtown', 33.9613914489746, 0.592738099343255, -81.0002822875977, -1.41372162096342, 218, 48, 'PPL', 'P'),
(134005, 'Arthyde', 46.3561096191406, 0.809066741269418, -93.0891723632813, -1.62471255569577, 218, 28, 'PPL', 'P'),
(99503, 'Artia', 37.3247184753418, 0.651439229774672, -82.1641693115234, -1.43403528165217, 218, 53, 'PPL', 'P'),
(122162, 'Artic', 41.4736099243164, 0.723851045867118, -84.8147201538086, -1.48029612084155, 218, 19, 'PPL', 'P'),
(206714, 'Artic', 46.8891716003418, 0.818370427958583, -123.713333129883, -2.15920499173304, 218, 56, 'PPL', 'P'),
(134006, 'Artichoke', 45.399169921875, 0.792364992809096, -96.1572189331055, -1.67826006994372, 218, 28, 'PPL', 'P'),
(108027, 'Artie', 37.9324989318848, 0.662046999870621, -81.3597183227539, -1.41999496322721, 218, 58, 'PPL', 'P'),
(99504, 'Artillery Ridge', 38.2516708374023, 0.667617600501767, -77.4786071777344, -1.35225679511078, 218, 53, 'PPL', 'P'),
(75019, 'Artillery Village', 34.6388893127441, 0.604562667741261, -98.4136123657227, -1.71764156456327, 218, 42, 'PPL', 'P'),
(7172, 'Artist Point', 35.7197189331055, 0.623426703269647, -94.1372222900391, -1.64300447764298, 218, 4, 'PPL', 'P'),
(29117, 'Artist Point', 38.160831451416, 0.666032154125816, -86.3705596923828, -1.50745064342238, 218, 19, 'PPL', 'P'),
(202917, 'Artists View Heights', 40.6074981689453, 0.708734544045664, -111.803886413574, -1.95134593444262, 218, 52, 'PPL', 'P'),
(179829, 'Artois', 39.6197204589844, 0.691494570729036, -122.192779541016, -2.13266632515429, 218, 6, 'PPL', 'P'),
(206715, 'Artondale', 47.2997207641602, 0.825535862608523, -122.619438171387, -2.14011292303631, 218, 56, 'PPL', 'P'),
(58491, 'Artonish', 31.1897201538086, 0.544363309459592, -91.583610534668, -1.59843554469412, 218, 30, 'PPL', 'P'),
(99505, 'Artrip', 36.9638900756836, 0.645141586165935, -82.1186065673828, -1.43324006175067, 218, 53, 'PPL', 'P'),
(179830, 'Arts Trailer Court', 34.2236099243164, 0.597314675097529, -119.139717102051, -2.07938033332538, 218, 6, 'PPL', 'P'),
(34593, 'Artville', 37.9236106872559, 0.661891870737124, -83.4627838134766, -1.45670038042539, 218, 21, 'PPL', 'P'),
(58492, 'Arunde', 32.3030586242676, 0.563794731458219, -88.7622222900391, -1.54919303034828, 218, 30, 'PPL', 'P'),
(13299, 'Arundel', 39.7361106872559, 0.693525963429522, -75.6680603027344, -1.32065679088033, 218, 10, 'PPL', 'P'),
(15036, 'Arundel', 27.0877799987793, 0.472770948034564, -80.2986068725586, -1.40147507469069, 218, 12, 'PPL', 'P'),
(44455, 'Arundel', 39.5658302307129, 0.690554008811048, -75.8733291625977, -1.32423940833676, 218, 25, 'PPL', 'P'),
(126775, 'Arundel', 43.3824996948242, 0.757167457420118, -70.4783325195313, -1.23007895378121, 218, 26, 'PPL', 'P'),
(179831, 'Arundel (historical)', 37.4486083984375, 0.653601516842735, -120.598327636719, -2.10483788965961, 218, 6, 'PPL', 'P'),
(44456, 'Arundel Acres', 39.0763893127441, 0.682011653298509, -76.6763916015625, -1.33825549199579, 218, 25, 'PPL', 'P'),
(44457, 'Arundel Beach', 39.0769386291504, 0.682021240678434, -76.5188903808594, -1.33550657711861, 218, 25, 'PPL', 'P'),
(44459, 'Arundel Gardens', 39.2125015258789, 0.684387259569887, -76.6191711425781, -1.33725680658701, 218, 25, 'PPL', 'P'),
(44460, 'Arundel Hills', 39.202220916748, 0.684207829091443, -76.6377792358398, -1.33758157908195, 218, 25, 'PPL', 'P'),
(44463, 'Arundel on the Bay', 38.9205589294434, 0.679291900035266, -76.4630584716797, -1.33453212647575, 218, 25, 'PPL', 'P'),
(44461, 'Arundel View', 39.0705604553223, 0.681909920544868, -76.6788864135742, -1.33829903467962, 218, 25, 'PPL', 'P'),
(186362, 'Arvada', 39.8027801513672, 0.694689565088804, -105.086936950684, -1.83411305062512, 218, 7, 'PPL', 'P'),
(209279, 'Arvada', 44.6536102294922, 0.779352521406859, -106.130561828613, -1.85232774090072, 218, 59, 'PPL', 'P'),
(193072, 'Arvana', 32.8097190856934, 0.572637624699773, -101.914436340332, -1.77874246945295, 218, 51, 'PPL', 'P'),
(34594, 'Arvel', 37.5183296203613, 0.654818381723819, -83.8852767944336, -1.46407427400966, 218, 21, 'PPL', 'P'),
(146880, 'Arverne', 40.5911102294922, 0.70844852054459, -73.79638671875, -1.2879899243172, 218, 40, 'PPL', 'P'),
(108028, 'Arvilla', 39.4352798461914, 0.688275474761403, -81.0711135864258, -1.41495786034144, 218, 58, 'PPL', 'P'),
(139614, 'Arvilla', 47.9191703796387, 0.836347297948836, -97.4944381713867, -1.70159894847274, 218, 34, 'PPL', 'P'),
(179832, 'Arvin', 35.209171295166, 0.614515965999323, -118.827499389648, -2.07393110626092, 218, 6, 'PPL', 'P'),
(99506, 'Arvins Store', 37.019718170166, 0.646115970229767, -78.3430633544922, -1.3673444016344, 218, 53, 'PPL', 'P'),
(108029, 'Arvondale', 38.6944389343262, 0.675345361615878, -80.2666702270508, -1.40091767507454, 218, 58, 'PPL', 'P'),
(31676, 'Arvonia', 38.4805603027344, 0.671612475294941, -95.8694381713867, -1.67323734812783, 218, 20, 'PPL', 'P'),
(99507, 'Arvonia', 37.6833305358887, 0.657698190968577, -78.341667175293, -1.36732003371043, 218, 53, 'PPL', 'P'),
(34595, 'Ary', 37.3663902282715, 0.652166539068373, -83.1508331298828, -1.45125581389284, 218, 21, 'PPL', 'P'),
(206716, 'Arzina', 48.439998626709, 0.845437465697603, -118.117500305176, -2.06153928455072, 218, 56, 'PPL', 'P'),
(34596, 'Asa', 37.7677803039551, 0.659172117473881, -82.904167175293, -1.44695068083267, 218, 21, 'PPL', 'P'),
(58493, 'Asa', 34.2688903808594, 0.59810496815101, -90.0711135864258, -1.57203749302093, 218, 30, 'PPL', 'P'),
(92349, 'Asa', 31.4141693115234, 0.548280686265044, -97.0538864135742, -1.69390986977346, 218, 51, 'PPL', 'P'),
(112835, 'Asahel', 31.8677806854248, 0.556197698264118, -87.4208297729492, -1.52578131436345, 218, 2, 'PPL', 'P'),
(158780, 'Asaph', 41.7708282470703, 0.729038484196428, -77.4052810668945, -1.35097701304894, 218, 45, 'PPL', 'P'),
(112832, 'Asberry', 33.8944396972656, 0.591569570835955, -85.7447204589844, -1.49652768821142, 218, 2, 'PPL', 'P'),
(44464, 'Asberry (historical)', 39.0269393920898, 0.681148589368242, -76.5055618286133, -1.3352739499974, 218, 25, 'PPL', 'P'),
(99508, 'Asberrys', 37.0113906860352, 0.645970628213276, -81.5388870239258, -1.42312204697919, 218, 53, 'PPL', 'P'),
(193199, 'Asbestos (historical)', 42.6666717529297, 0.744673902956284, -122.9375, -2.14566414917053, 218, 43, 'PPL', 'P'),
(194535, 'Asbestos Point', 45.8180618286133, 0.799676035791636, -115.939720153809, -2.02352985052479, 218, 17, 'PPL', 'P'),
(44465, 'Asbury', 38.8569412231445, 0.678181561597785, -75.8569412231445, -1.32395338483569, 218, 25, 'PPL', 'P'),
(53249, 'Asbury', 37.2744407653809, 0.650561718195491, -94.6052780151367, -1.65117359112874, 218, 29, 'PPL', 'P'),
(62590, 'Asbury', 35.7900009155273, 0.624653355267737, -78.7377777099609, -1.37423346674222, 218, 33, 'PPL', 'P'),
(71699, 'Asbury', 39.0605583190918, 0.681735350335414, -84.3422164916992, -1.47204937621001, 218, 41, 'PPL', 'P'),
(79574, 'Asbury', 34.9263916015625, 0.609580529288161, -81.6311111450195, -1.42473166154203, 218, 48, 'PPL', 'P'),
(84727, 'Asbury', 36.3208312988281, 0.633918093225959, -82.3944396972656, -1.43805425805321, 218, 50, 'PPL', 'P'),
(108030, 'Asbury', 37.8197212219238, 0.660078657508944, -80.559440612793, -1.40602748225808, 218, 58, 'PPL', 'P'),
(112839, 'Asbury', 34.378059387207, 0.600010326752907, -86.126106262207, -1.50318412619802, 218, 2, 'PPL', 'P'),
(114446, 'Asbury', 42.5144386291504, 0.742016933715739, -90.7513885498047, -1.58391053095077, 218, 16, 'PPL', 'P'),
(134008, 'Asbury', 44.8788909912109, 0.783284412440252, -95.5336074829102, -1.66737599688467, 218, 28, 'PPL', 'P'),
(144768, 'Asbury', 40.6958312988281, 0.710276248000711, -75.0105590820313, -1.30918122974318, 218, 37, 'PPL', 'P'),
(146882, 'Asbury', 42.1411094665527, 0.735501110634696, -73.9583282470703, -1.2908163371821, 218, 40, 'PPL', 'P'),
(158782, 'Asbury', 42.0719413757324, 0.734293899712564, -80.1822204589844, -1.39944374856924, 218, 45, 'PPL', 'P'),
(18925, 'Asbury (historical)', 33.0222206115723, 0.576346475991872, -81.9263916015625, -1.4298852777255, 218, 13, 'PPL', 'P'),
(71700, 'Asbury (historical)', 39.6824989318848, 0.692590261780522, -82.2930603027344, -1.43628485382496, 218, 41, 'PPL', 'P'),
(84730, 'Asbury Estates', 35.7705612182617, 0.624314068544861, -83.9263916015625, -1.46479186276538, 218, 50, 'PPL', 'P'),
(124124, 'Asbury Grove', 42.6222190856934, 0.743898057551716, -70.8847198486328, -1.23717175071242, 218, 23, 'PPL', 'P'),
(15037, 'Asbury Lake', 30.0488891601563, 0.52445205241156, -81.8216705322266, -1.42805755026937, 218, 12, 'PPL', 'P'),
(112841, 'Asbury Park', 33.4627799987793, 0.584035687849203, -86.7372207641602, -1.51385008636379, 218, 2, 'PPL', 'P'),
(144769, 'Asbury Park', 40.2202796936035, 0.701976306726397, -74.0124969482422, -1.29176175936908, 218, 37, 'PPL', 'P'),
(84729, 'Asbury Prk', 35.8883285522461, 0.626369496274184, -86.4583282470703, -1.50898249368139, 218, 50, 'PPL', 'P'),
(582, 'Asbury Woods', 39.1469383239746, 0.683242965828508, -76.8180618286133, -1.34072810390988, 218, 25, 'PPL', 'P'),
(18926, 'Asbury Woods', 33.8186111450195, 0.59024611293224, -84.8061065673828, -1.48014578539802, 218, 13, 'PPL', 'P'),
(79575, 'Ascaga Heights', 33.5625, 0.585776130200597, -81.897216796875, -1.42937608132507, 218, 48, 'PPL', 'P'),
(18927, 'Ascalon', 34.8394393920898, 0.608062926940979, -85.4247207641602, -1.49094263993136, 218, 13, 'PPL', 'P'),
(53250, 'Ascalon', 38.7008285522461, 0.675456881486525, -90.4094390869141, -1.57794238694791, 218, 29, 'PPL', 'P'),
(191090, 'Ascencion Park Estates Colonia', 31.621000289917, 0.551890567833133, -106.142997741699, -1.85254478852956, 218, 51, 'PPL', 'P'),
(148, 'Asco', 37.5019416809082, 0.654532358222745, -81.626106262207, -1.42464430985827, 218, 58, 'PPL', 'P'),
(179834, 'Asco', 37.6830596923828, 0.657693463857642, -121.871673583984, -2.12706196895633, 218, 6, 'PPL', 'P'),
(114447, 'Ascot', 41.4136085510254, 0.722803824347471, -95.898063659668, -1.67373695714833, 218, 16, 'PPL', 'P'),
(44466, 'Ascot Estates', 39.5205612182617, 0.689763915494648, -76.5647201538086, -1.33630645755202, 218, 25, 'PPL', 'P'),
(171692, 'Ascutney', 43.4069404602051, 0.757594029247721, -72.4075012207031, -1.26374929944308, 218, 55, 'PPL', 'P'),
(70466, 'Aserdaten (historical)', 39.8563919067383, 0.695625266737804, -74.3383331298828, -1.29744867356084, 218, 37, 'PPL', 'P'),
(18928, 'Ash', 33.8036117553711, 0.589984324197086, -84.8502807617188, -1.48091677053359, 218, 13, 'PPL', 'P'),
(53251, 'Ash', 39.5149993896484, 0.689666843272915, -92.2897186279297, -1.61075945579652, 218, 29, 'PPL', 'P'),
(62592, 'Ash', 34.0666694641113, 0.594575547337355, -78.5266723632813, -1.37054898337409, 218, 33, 'PPL', 'P'),
(92350, 'Ash', 31.1949996948242, 0.544455454833309, -95.6919403076172, -1.6701394259898, 218, 51, 'PPL', 'P'),
(108031, 'Ash', 38.8325004577637, 0.677754989770181, -81.9736099243164, -1.43070939292482, 218, 58, 'PPL', 'P'),
(154102, 'Ash', 40.0552787780762, 0.69909649748164, -82.6691665649414, -1.44284914643784, 218, 41, 'PPL', 'P'),
(200343, 'Ash', 43.5525016784668, 0.760134551769602, -123.820556640625, -2.16107639503104, 218, 43, 'PPL', 'P'),
(206717, 'Ash', 46.2533302307129, 0.807272902538168, -118.842216491699, -2.07418796814806, 218, 56, 'PPL', 'P'),
(179835, 'Ash (historical)', 37.0688896179199, 0.646974173891046, -120.303062438965, -2.09968453979226, 218, 6, 'PPL', 'P'),
(129572, 'Ash Acres', 44.0377807617188, 0.768604269563409, -84.8119430541992, -1.48024765130971, 218, 27, 'PPL', 'P'),
(134009, 'Ash Creek', 43.538330078125, 0.759887210683361, -96.1938934326172, -1.67890016071172, 218, 28, 'PPL', 'P'),
(193352, 'Ash Creek Junction', 41.2675018310547, 0.720253781024693, -122.076667785645, -2.13063979272279, 218, 6, 'PPL', 'P'),
(193353, 'Ash Creek Station (historical)', 41.2686080932617, 0.720273088942596, -121.94361114502, -2.12831751625224, 218, 6, 'PPL', 'P'),
(7173, 'Ash Flat', 36.2238883972168, 0.632226120406405, -91.6083297729492, -1.59886697679071, 218, 4, 'PPL', 'P'),
(193049, 'Ash Fork', 35.2249984741211, 0.614792202383392, -112.483329772949, -1.96320445814453, 218, 5, 'PPL', 'P'),
(31678, 'Ash Grove', 39.1613883972168, 0.683495167183738, -98.3616714477539, -1.7167350245282, 218, 20, 'PPL', 'P'),
(53252, 'Ash Grove', 37.3152809143066, 0.651274513261251, -93.5849990844727, -1.63336636449993, 218, 29, 'PPL', 'P'),
(99509, 'Ash Grove', 38.9283294677734, 0.679427521513778, -77.2416687011719, -1.3481214385701, 218, 53, 'PPL', 'P'),
(114449, 'Ash Grove', 40.8708305358887, 0.713330560875896, -92.5527801513672, -1.61535074551581, 218, 16, 'PPL', 'P'),
(122163, 'Ash Grove', 40.547779083252, 0.707692249374035, -86.8477783203125, -1.5157796797316, 218, 19, 'PPL', 'P'),
(146884, 'Ash Grove', 43.0319404602051, 0.751049044552743, -73.331672668457, -1.27987913405931, 218, 40, 'PPL', 'P'),
(53253, 'Ash Hill', 36.7755584716797, 0.641854579590504, -90.2330627441406, -1.57486403904388, 218, 29, 'PPL', 'P'),
(62599, 'Ash Hill', 36.3930587768555, 0.635178700527948, -80.5733337402344, -1.40626996307533, 218, 33, 'PPL', 'P'),
(179836, 'Ash Hill', 34.7069396972656, 0.605750371008409, -116.054168701172, -2.0255273545004, 218, 6, 'PPL', 'P'),
(99510, 'Ash Hollow Estates', 39.1838912963867, 0.683887916865498, -78.1319427490234, -1.36365965195017, 218, 53, 'PPL', 'P'),
(29126, 'Ash Iron Springs', 38.0352783203125, 0.663840838601872, -87.1866683959961, -1.52169442735462, 218, 19, 'PPL', 'P'),
(134011, 'Ash Lake', 48.2188911437988, 0.841578412120024, -92.9158325195313, -1.62168720469744, 218, 28, 'PPL', 'P'),
(18930, 'Ash Manor', 33.639720916748, 0.587123889449259, -84.279167175293, -1.47094895804759, 218, 13, 'PPL', 'P'),
(126777, 'Ash Point', 44.0555610656738, 0.76891459440943, -69.0872192382813, -1.20579944675518, 218, 26, 'PPL', 'P'),
(71702, 'Ash Ridge', 38.9077796936035, 0.679068860293972, -83.7588882446289, -1.46186837767875, 218, 41, 'PPL', 'P'),
(189890, 'Ash Springs', 37.4605598449707, 0.653810108935115, -115.192222595215, -2.01048355697671, 218, 39, 'PPL', 'P'),
(31679, 'Ash Valley', 38.3050003051758, 0.66854837530275, -99.2161102294922, -1.73164779452627, 218, 20, 'PPL', 'P'),
(146885, 'Ashantee', 42.8969383239746, 0.748692812778295, -77.7649993896484, -1.35725528216075, 218, 40, 'PPL', 'P'),
(146886, 'Asharoken', 40.9277801513672, 0.714324519173741, -73.3602828979492, -1.2803784767637, 218, 40, 'PPL', 'P'),
(114450, 'Ashawa', 41.5722198486328, 0.725572113721581, -93.7561111450195, -1.63635283334634, 218, 16, 'PPL', 'P'),
(169263, 'Ashaway', 41.4233283996582, 0.722973467708909, -71.7861099243164, -1.2529039753779, 218, 47, 'PPL', 'P'),
(112836, 'Ashbank', 34.0102806091309, 0.593591376156516, -87.4875030517578, -1.52694498260176, 218, 2, 'PPL', 'P'),
(29119, 'Ashboro', 39.3988914489746, 0.687640377420446, -87.105827331543, -1.52028348460909, 218, 19, 'PPL', 'P'),
(79576, 'Ashborough', 32.9599990844727, 0.575260505478364, -80.1877822875977, -1.39954082079097, 218, 48, 'PPL', 'P'),
(79577, 'Ashborough East', 32.9602813720703, 0.575265432326381, -80.1800003051758, -1.39940499957538, 218, 48, 'PPL', 'P'),
(158785, 'Ashbourne', 40.0675010681152, 0.699309816684956, -75.1305618286133, -1.31127567278247, 218, 45, 'PPL', 'P'),
(13300, 'Ashbourne Hills', 39.8097190856934, 0.694810672339376, -75.4680633544922, -1.31716618563957, 218, 10, 'PPL', 'P'),
(44467, 'Ashbox', 38.6711082458496, 0.674938164285204, -76.7972183227539, -1.34036431610497, 218, 25, 'PPL', 'P'),
(34597, 'Ashbrook', 37.9319381713867, 0.662037212753615, -85.0458297729492, -1.48432974462859, 218, 21, 'PPL', 'P'),
(202919, 'Ashbrook Condominium', 40.625560760498, 0.709049795739702, -111.881942749023, -1.95270827449825, 218, 52, 'PPL', 'P'),
(62593, 'Ashbrook Park', 35.7752799987793, 0.624396426801572, -80.9511108398438, -1.41286341730215, 218, 33, 'PPL', 'P'),
(18929, 'Ashburn', 31.7058296203613, 0.553371118951649, -83.6533279418945, -1.46002600283663, 218, 13, 'PPL', 'P'),
(53255, 'Ashburn', 39.5447196960449, 0.690185560474235, -91.1686096191406, -1.59119241231938, 218, 29, 'PPL', 'P'),
(84731, 'Ashburn', 36.6211090087891, 0.639158927935126, -86.82861328125, -1.51544518669869, 218, 50, 'PPL', 'P'),
(99511, 'Ashburn', 39.0436096191406, 0.681439539717333, -77.4877777099609, -1.35241685109229, 218, 53, 'PPL', 'P'),
(99512, 'Ashburn Farm', 39.0355606079102, 0.681299057969831, -77.5013885498047, -1.35265440506153, 218, 53, 'PPL', 'P'),
(99513, 'Ashburn Junction', 39.0708312988281, 0.681914647655803, -77.4800033569336, -1.35228116303475, 218, 53, 'PPL', 'P'),
(99514, 'Ashburn Village', 39.0436096191406, 0.681439539717333, -77.4744415283203, -1.35218409081302, 218, 53, 'PPL', 'P'),
(124125, 'Ashburnham', 42.6361083984375, 0.744140471789941, -71.908332824707, -1.25503716741105, 218, 23, 'PPL', 'P'),
(44468, 'Ashburton', 39.0127792358398, 0.680901448019083, -77.128059387207, -1.34613858198048, 218, 25, 'PPL', 'P'),
(92351, 'Ashby', 28.8289203643799, 0.503159580153672, -96.1239776611328, -1.67767990030025, 218, 51, 'PPL', 'P'),
(99516, 'Ashby', 39.0108299255371, 0.680867426136157, -78.1355590820313, -1.363722768868, 218, 53, 'PPL', 'P'),
(112843, 'Ashby', 33.0208282470703, 0.576322174646925, -86.9194412231445, -1.51703043333756, 218, 2, 'PPL', 'P'),
(124127, 'Ashby', 42.6777801513672, 0.744867781083641, -71.8208312988281, -1.25350997768395, 218, 23, 'PPL', 'P'),
(134013, 'Ashby', 46.0930595397949, 0.804475651287204, -95.8172225952148, -1.6723260144028, 218, 28, 'PPL', 'P'),
(199155, 'Ashby', 42.0219383239746, 0.733421181823345, -101.927223205566, -1.7789656423523, 218, 35, 'PPL', 'P'),
(206718, 'Ashby', 47.1522216796875, 0.822961517940798, -118.066673278809, -2.06065218559162, 218, 56, 'PPL', 'P'),
(29120, 'Ashby (historical)', 39.3300018310547, 0.686438026767303, -84.9016723632813, -1.48181372318873, 218, 19, 'PPL', 'P'),
(84732, 'Ashby (historical)', 36.292781829834, 0.633428537638575, -83.6816711425781, -1.46052068500911, 218, 50, 'PPL', 'P'),
(99517, 'Ashby Gap Estates', 39.014720916748, 0.680935336743954, -77.9652786254883, -1.36075081424953, 218, 53, 'PPL', 'P'),
(44470, 'Ashby Place', 39.4252815246582, 0.688100971130976, -76.3144378662109, -1.33193820757402, 218, 25, 'PPL', 'P'),
(108032, 'Ashby Ridge Estates', 39.2944412231445, 0.68581737707526, -81.4672164916992, -1.42187116021518, 218, 58, 'PPL', 'P'),
(99520, 'Ashby Run', 39.0688896179199, 0.681880758930932, -77.9236068725586, -1.36002350495583, 218, 53, 'PPL', 'P'),
(29121, 'Ashby Yards', 38.4744415283203, 0.671505682535229, -87.2847213745117, -1.5234057746711, 218, 19, 'PPL', 'P'),
(34598, 'Ashbyburg', 37.5352783203125, 0.6551141923419, -87.3688888549805, -1.52487477432839, 218, 21, 'PPL', 'P'),
(99521, 'Ashbys Corner', 38.6319389343262, 0.674254530833381, -78.2344436645508, -1.36544863041243, 218, 53, 'PPL', 'P'),
(99522, 'Ashcake', 37.6916694641113, 0.657843732722149, -77.4027786254883, -1.35093333720706, 218, 53, 'PPL', 'P'),
(112330, 'Ashcamp', 37.2661094665527, 0.650416309599973, -82.4349975585938, -1.43876212627095, 218, 21, 'PPL', 'P'),
(158784, 'Ashcom', 40.0036087036133, 0.698194684557512, -78.4194412231445, -1.36867744691804, 218, 45, 'PPL', 'P'),
(112844, 'Ashcraft Corner', 33.526668548584, 0.585150753397619, -87.9005584716797, -1.53415415967261, 218, 2, 'PPL', 'P'),
(44471, 'Ashcroft', 39.024169921875, 0.681100252994457, -76.5027770996094, -1.3352253473075, 218, 25, 'PPL', 'P'),
(99523, 'Ashcroft', 38.0311088562012, 0.663768067725085, -78.4361114501953, -1.36896839726713, 218, 53, 'PPL', 'P'),
(124129, 'Ashcroft', 42.2333297729492, 0.737110658618513, -71.1500015258789, -1.24180178942558, 218, 23, 'PPL', 'P'),
(186363, 'Ashcroft', 39.0536117553711, 0.681614109926788, -106.799171447754, -1.86399718016522, 218, 7, 'PPL', 'P'),
(53256, 'Ashcroft Addition', 36.7441711425781, 0.641306767354275, -90.3894424438477, -1.57759337968705, 218, 29, 'PPL', 'P'),
(71703, 'Ashdale', 39.1722183227539, 0.683684185042106, -84.1519393920898, -1.46872841433068, 218, 41, 'PPL', 'P'),
(79580, 'Ashdale', 32.4480590820313, 0.566325466863094, -80.6194381713867, -1.40707463719869, 218, 48, 'PPL', 'P'),
(126778, 'Ashdale', 43.7675018310547, 0.763887012324551, -69.8394393920898, -1.21892816513899, 218, 26, 'PPL', 'P'),
(118664, 'Ashdale Junction', 42.0849990844727, 0.734521799722847, -89.9244384765625, -1.56947752942309, 218, 18, 'PPL', 'P'),
(124130, 'Ashdod', 42.0686111450195, 0.734235776221773, -70.7513885498047, -1.23484468055191, 218, 23, 'PPL', 'P'),
(7174, 'Ashdown', 33.6741714477539, 0.587725164644371, -94.1311111450195, -1.64289781804132, 218, 4, 'PPL', 'P'),
(62596, 'Asheboro', 35.7077789306641, 0.623218310914348, -79.8138885498047, -1.39301514401389, 218, 33, 'PPL', 'P'),
(18931, 'Ashebrook', 33.9752807617188, 0.592980513581479, -84.466667175293, -1.47422145039508, 218, 13, 'PPL', 'P'),
(62598, 'Ashebrook Park', 35.3422203063965, 0.616838109311818, -81.2263870239258, -1.4176678930667, 218, 33, 'PPL', 'P'),
(79578, 'Ashepoo', 32.7400016784668, 0.571420826397716, -80.5505599975586, -1.40587248628263, 218, 48, 'PPL', 'P'),
(79579, 'Ashepoo Crossing', 32.7574996948242, 0.57172622439572, -80.6191711425781, -1.40706997666679, 218, 48, 'PPL', 'P'),
(79597, 'Ashepoo Siding', 32.6366691589355, 0.569617333707514, -80.5008316040039, -1.40500456208338, 218, 48, 'PPL', 'P'),
(7175, 'Asher', 35.9425010681152, 0.62731498504019, -93.8502807617188, -1.63799640321308, 218, 4, 'PPL', 'P'),
(34599, 'Asher', 37.0441703796387, 0.646542741794453, -83.404167175293, -1.45567732709264, 218, 21, 'PPL', 'P'),
(75021, 'Asher', 34.9894409179688, 0.610680947450582, -96.9233322143555, -1.69163126914479, 218, 42, 'PPL', 'P'),
(193051, 'Asher', 32.6755599975586, 0.570296106890348, -114.072776794434, -1.99094554195545, 218, 5, 'PPL', 'P'),
(44472, 'Asher Glade', 39.7038917541504, 0.692963636965351, -79.4475021362305, -1.38662049476245, 218, 25, 'PPL', 'P'),
(34600, 'Ashers Fork', 37.0083312988281, 0.64591723183342, -83.5955581665039, -1.45901773004793, 218, 21, 'PPL', 'P'),
(92352, 'Asherton', 28.4433307647705, 0.496429772079042, -99.7586135864258, -1.74111626430788, 218, 51, 'PPL', 'P'),
(158786, 'Asherton', 40.7880592346191, 0.711885929142582, -76.8241729736328, -1.34083476351154, 218, 45, 'PPL', 'P'),
(29122, 'Asherville', 39.4747200012207, 0.688963835324161, -87.0622177124023, -1.51952235316955, 218, 19, 'PPL', 'P'),
(31715, 'Asherville', 39.4058303833008, 0.687761484671018, -97.9766693115234, -1.71001546962377, 218, 20, 'PPL', 'P'),
(53258, 'Asherville', 36.898609161377, 0.644002219272572, -90.1872177124023, -1.57406389229437, 218, 29, 'PPL', 'P'),
(79581, 'Asheton', 34.8250007629395, 0.607810925322831, -82.2541732788086, -1.43560614722115, 218, 48, 'PPL', 'P'),
(62601, 'Asheville', 35.600830078125, 0.621351701306311, -82.5541687011719, -1.4408420550823, 218, 33, 'PPL', 'P'),
(124131, 'Ashfield', 42.5263900756836, 0.742225525808119, -72.7888870239258, -1.27040573742968, 218, 23, 'PPL', 'P'),
(158787, 'Ashfield', 40.7844390869141, 0.71182274564572, -75.7138900756836, -1.32145667131374, 218, 45, 'PPL', 'P'),
(195897, 'Ashfield', 48.4619407653809, 0.845820428262357, -107.473327636719, -1.87576342533536, 218, 31, 'PPL', 'P'),
(728, 'Ashford', 35.8713912963867, 0.626073885393185, -81.9480590820313, -1.43026344660029, 218, 33, 'PPL', 'P'),
(44473, 'Ashford', 38.6436080932617, 0.674458196077745, -76.9438934326172, -1.34292427970281, 218, 25, 'PPL', 'P'),
(108033, 'Ashford', 38.1791687011719, 0.666352199509816, -81.7111129760742, -1.42612795690156, 218, 58, 'PPL', 'P'),
(112845, 'Ashford', 31.1827793121338, 0.544242168919507, -85.2363891601563, -1.48765563335593, 218, 2, 'PPL', 'P'),
(146887, 'Ashford', 42.3202781677246, 0.738628194386667, -78.6083297729492, -1.37197417403145, 218, 40, 'PPL', 'P'),
(172975, 'Ashford', 43.5869407653809, 0.760735627227633, -88.3705596923828, -1.54235722846227, 218, 57, 'PPL', 'P'),
(177449, 'Ashford', 41.8730583190918, 0.730822735547754, -72.121940612793, -1.25876532662105, 218, 8, 'PPL', 'P'),
(206719, 'Ashford', 46.7586097717285, 0.816091694171857, -122.029716491699, -2.12982033805537, 218, 56, 'PPL', 'P'),
(172976, 'Ashford (historical)', 43.3466682434082, 0.75654208061714, -90.4680633544922, -1.57896557343871, 218, 57, 'PPL', 'P'),
(202920, 'Ashford Acres', 40.5694389343262, 0.708070285090771, -111.981666564941, -1.95444878342868, 218, 52, 'PPL', 'P'),
(146888, 'Ashford Hollow', 42.4033317565918, 0.740077752967998, -78.6855621337891, -1.37332213301719, 218, 40, 'PPL', 'P'),
(179839, 'Ashford Junction', 35.9097213745117, 0.626742871459013, -116.672500610352, -2.03631928218573, 218, 6, 'PPL', 'P'),
(179837, 'Ashford Mill (historical)', 35.9188919067383, 0.626902927440527, -116.683891296387, -2.0365180871611, 218, 6, 'PPL', 'P'),
(18932, 'Ashintilly', 31.3936100006104, 0.54792185859767, -81.4091720581055, -1.42085809373651, 218, 13, 'PPL', 'P'),
(172978, 'Ashippun', 43.2119407653809, 0.754190642532655, -88.51611328125, -1.54489761782609, 218, 57, 'PPL', 'P'),
(118665, 'Ashkum', 40.8802795410156, 0.713495477126399, -87.9550018310547, -1.53510437554955, 218, 18, 'PPL', 'P'),
(13301, 'Ashland', 39.7997207641602, 0.694636168708948, -75.6575012207031, -1.3204725001329, 218, 10, 'PPL', 'P'),
(18934, 'Ashland', 33.9005584716797, 0.591676363595667, -83.5805587768555, -1.45875594131277, 218, 13, 'PPL', 'P'),
(26400, 'Ashland', 39.8877792358398, 0.696173078974033, -90.0077819824219, -1.57093214801049, 218, 18, 'PPL', 'P'),
(29123, 'Ashland', 39.9261093139648, 0.696842065039861, -85.304443359375, -1.48884340320211, 218, 19, 'PPL', 'P'),
(31683, 'Ashland', 37.1886100769043, 0.649063690082322, -99.7652816772461, -1.74123264444752, 218, 20, 'PPL', 'P'),
(34601, 'Ashland', 38.478328704834, 0.671573526563998, -82.6380615234375, -1.44230626104963, 218, 21, 'PPL', 'P'),
(39154, 'Ashland', 31.2858295440674, 0.546040734761692, -91.5811080932617, -1.59839186885224, 218, 22, 'PPL', 'P'),
(44474, 'Ashland', 39.4952812194824, 0.689322696281049, -76.6402816772461, -1.33762525492383, 218, 25, 'PPL', 'P'),
(53261, 'Ashland', 38.7744407653809, 0.676741656975406, -92.2569427490234, -1.61018740879437, 218, 29, 'PPL', 'P'),
(58496, 'Ashland', 31.7999992370605, 0.555014688818391, -91.3480606079102, -1.59432442291937, 218, 30, 'PPL', 'P'),
(62604, 'Ashland', 36.4408302307129, 0.636012469686225, -81.6597213745117, -1.42523100424642, 218, 33, 'PPL', 'P'),
(70467, 'Ashland', 39.8630599975586, 0.69574164687744, -75.0063934326172, -1.30910852544542, 218, 37, 'PPL', 'P'),
(75022, 'Ashland', 34.7677803039551, 0.606812239914051, -96.0694427490234, -1.67672808652665, 218, 42, 'PPL', 'P'),
(79582, 'Ashland', 34.3397216796875, 0.599341207529024, -80.1983337402344, -1.39972497838035, 218, 48, 'PPL', 'P'),
(84734, 'Ashland', 35.4361114501953, 0.618476818909571, -87.6675033569336, -1.53008658058167, 218, 50, 'PPL', 'P'),
(92353, 'Ashland', 32.690559387207, 0.570557895625503, -94.7041702270508, -1.65289958583122, 218, 51, 'PPL', 'P'),
(99524, 'Ashland', 37.7588882446289, 0.659016921761357, -77.4802780151367, -1.35228595672471, 218, 53, 'PPL', 'P'),
(108034, 'Ashland', 37.4083290100098, 0.652898508893981, -81.352783203125, -1.41987392255567, 218, 58, 'PPL', 'P'),
(112846, 'Ashland', 33.273609161377, 0.580734033887777, -85.8361129760742, -1.49812278854632, 218, 2, 'PPL', 'P'),
(114482, 'Ashland', 40.958610534668, 0.714862610871991, -92.2363891601563, -1.60982868099553, 218, 16, 'PPL', 'P'),
(124133, 'Ashland', 42.2611083984375, 0.737595487094962, -71.4638900756836, -1.24728017810398, 218, 23, 'PPL', 'P'),
(126781, 'Ashland', 46.6311111450195, 0.813866423344014, -68.4066696166992, -1.19392161513537, 218, 26, 'PPL', 'P'),
(129575, 'Ashland', 43.3077812194824, 0.755863374013333, -85.8111114501953, -1.49768642960171, 218, 27, 'PPL', 'P'),
(141201, 'Ashland', 41.0391693115234, 0.716268626769498, -96.3680572509766, -1.68193989277994, 218, 35, 'PPL', 'P'),
(143473, 'Ashland', 43.6952781677246, 0.762626471601589, -71.6311111450195, -1.2501987363426, 218, 36, 'PPL', 'P'),
(146891, 'Ashland', 42.3036117553711, 0.738337310616604, -74.3338928222656, -1.29737117557312, 218, 40, 'PPL', 'P'),
(154103, 'Ashland', 40.8686103820801, 0.713291811882035, -82.3183288574219, -1.43672587330147, 218, 41, 'PPL', 'P'),
(158789, 'Ashland', 40.7816696166992, 0.711774409271935, -76.3461074829102, -1.33249094665826, 218, 45, 'PPL', 'P'),
(172979, 'Ashland', 46.5924987792969, 0.813192510430169, -90.8836135864258, -1.58621829319338, 218, 57, 'PPL', 'P'),
(179838, 'Ashland', 37.6947212219238, 0.657896995943951, -122.112777709961, -2.13127002979476, 218, 6, 'PPL', 'P'),
(195898, 'Ashland', 45.5944404602051, 0.795773106635097, -106.270278930664, -1.85476626435285, 218, 31, 'PPL', 'P'),
(200344, 'Ashland', 42.1947212219238, 0.736436812283696, -122.70832824707, -2.14166434752934, 218, 43, 'PPL', 'P'),
(53259, 'Ashland (historical)', 38.4563903808594, 0.671190630578272, -90.6816711425781, -1.58269373264872, 218, 29, 'PPL', 'P'),
(58497, 'Ashland (historical)', 33.7705612182617, 0.589407483504974, -88.4519424438477, -1.54377762542966, 218, 30, 'PPL', 'P'),
(169265, 'Ashland (historical)', 41.7874984741211, 0.72932943454552, -71.6011123657227, -1.24967515887229, 218, 47, 'PPL', 'P'),
(129576, 'Ashland Center', 43.3363914489746, 0.756362716717723, -85.8516693115234, -1.49839429781946, 218, 27, 'PPL', 'P'),
(84735, 'Ashland City', 36.274169921875, 0.633103698564613, -87.0641708374023, -1.5195564416315, 218, 50, 'PPL', 'P'),
(18935, 'Ashland Estates', 33.5724983215332, 0.585950633831024, -84.4544372558594, -1.47400799803371, 218, 13, 'PPL', 'P'),
(201874, 'Ashland Heights', 44.1297187805176, 0.770208890699209, -103.124717712402, -1.79986586427114, 218, 49, 'PPL', 'P'),
(84736, 'Ashland Hills', 36.5063896179199, 0.637156696848577, -87.2966690063477, -1.52361430018445, 218, 50, 'PPL', 'P'),
(172981, 'Ashland Junction', 46.5738906860352, 0.812867737935234, -90.9711074829102, -1.58774534976243, 218, 57, 'PPL', 'P'),
(44475, 'Ashland Landing', 39.1202812194824, 0.682777711586071, -76.0972213745117, -1.32814706460423, 218, 25, 'PPL', 'P'),
(99526, 'Ashland Mill', 37.8063888549805, 0.659845963808698, -77.4733276367188, -1.35216464973706, 218, 53, 'PPL', 'P'),
(34602, 'Ashland Park', 38.0250015258789, 0.663661474702455, -84.4775009155273, -1.47441053483248, 218, 21, 'PPL', 'P'),
(44476, 'Ashlar Hill', 39.3791694641113, 0.687296163849554, -76.5736083984375, -1.33646158668552, 218, 25, 'PPL', 'P'),
(44477, 'Ashleigh', 39.0169410705566, 0.680974085737815, -77.1608276367188, -1.34671049582458, 218, 25, 'PPL', 'P'),
(79583, 'Ashleigh', 33.3008308410645, 0.581209141826247, -81.3177795410156, -1.41926299340161, 218, 48, 'PPL', 'P'),
(13302, 'Ashley', 39.7291717529297, 0.69340485617895, -75.5833282470703, -1.31917793752701, 218, 10, 'PPL', 'P'),
(26402, 'Ashley', 38.3294410705566, 0.668974947130354, -89.1908264160156, -1.55667358353421, 218, 18, 'PPL', 'P'),
(44478, 'Ashley', 38.9216690063477, 0.679311274532196, -76.6188888549805, -1.337251879739, 218, 25, 'PPL', 'P'),
(53260, 'Ashley', 39.2511100769043, 0.685061105904705, -91.2202835083008, -1.59209429182253, 218, 29, 'PPL', 'P'),
(58499, 'Ashley', 31.8019409179688, 0.555048577543263, -90.2630615234375, -1.57538761651419, 218, 30, 'PPL', 'P'),
(75023, 'Ashley', 36.8044395446777, 0.642358649405829, -98.5244369506836, -1.71957581846299, 218, 42, 'PPL', 'P'),
(79584, 'Ashley', 34.9055595397949, 0.609216941220338, -82.0013885498047, -1.43119422140127, 218, 48, 'PPL', 'P'),
(99527, 'Ashley', 37.2158317565918, 0.649538798020792, -77.4766693115234, -1.35222297296493, 218, 53, 'PPL', 'P'),
(108035, 'Ashley', 39.4044418334961, 0.687737249905098, -80.6761093139648, -1.40806373522755, 218, 58, 'PPL', 'P'),
(122180, 'Ashley', 41.5272216796875, 0.724786747516117, -85.065559387207, -1.48467409135753, 218, 19, 'PPL', 'P'),
(129578, 'Ashley', 43.1866683959961, 0.75374955647711, -84.4744415283203, -1.47435713845262, 218, 27, 'PPL', 'P'),
(139617, 'Ashley', 46.0341682434082, 0.803447804264488, -99.3711090087891, -1.73435303356157, 218, 34, 'PPL', 'P'),
(154106, 'Ashley', 40.4088897705078, 0.705268173570817, -82.9555587768555, -1.44784763348781, 218, 41, 'PPL', 'P'),
(158793, 'Ashley', 41.2102813720703, 0.719255095615913, -75.8969421386719, -1.32465153251545, 218, 45, 'PPL', 'P'),
(172984, 'Ashley', 44.6927795410156, 0.780036154858683, -89.6080627441406, -1.56395573121892, 218, 57, 'PPL', 'P'),
(195899, 'Ashley (historical)', 48.1916694641113, 0.841103304181554, -114.331939697266, -1.99546878790889, 218, 31, 'PPL', 'P'),
(18936, 'Ashley Acres', 33.8388900756836, 0.590600047041112, -84.7608337402344, -1.47935562550259, 218, 13, 'PPL', 'P'),
(44480, 'Ashley Acres', 39.3236083984375, 0.686326440317629, -77.2433319091797, -1.34815046702598, 218, 25, 'PPL', 'P'),
(112479, 'Ashley Corner', 38.7694396972656, 0.676654371870679, -82.7863922119141, -1.44489511994529, 218, 41, 'PPL', 'P'),
(53262, 'Ashley Creek', 37.4030609130859, 0.652806563257346, -91.6883316040039, -1.60026327215024, 218, 29, 'PPL', 'P'),
(79586, 'Ashley Creek Village', 33.8813896179199, 0.591341803983726, -80.3836135864258, -1.40295872173398, 218, 48, 'PPL', 'P'),
(58500, 'Ashley Crossing', 33.4174995422363, 0.583245394795722, -90.9888916015625, -1.58805574118748, 218, 30, 'PPL', 'P'),
(79587, 'Ashley Downs', 34.577220916748, 0.603486351186706, -82.6549987792969, -1.44260187193062, 218, 48, 'PPL', 'P'),
(124135, 'Ashley Falls', 42.0561103820801, 0.734017596749468, -73.335563659668, -1.27994704466711, 218, 23, 'PPL', 'P'),
(18942, 'Ashley Forest', 34.0763893127441, 0.594745190698793, -84.5702819824219, -1.4760298699333, 218, 13, 'PPL', 'P'),
(79590, 'Ashley Forest', 32.9655609130859, 0.575357577700098, -80.2002792358398, -1.39975893368425, 218, 48, 'PPL', 'P'),
(18937, 'Ashley Grove', 33.711669921875, 0.588379636482258, -83.8905563354492, -1.46416641938338, 218, 13, 'PPL', 'P'),
(79592, 'Ashley Harbor', 32.8236083984375, 0.572880038937997, -80.0250015258789, -1.39669976054007, 218, 48, 'PPL', 'P'),
(13303, 'Ashley Heights', 39.7252807617188, 0.693336945571153, -75.5794372558594, -1.31911002691921, 218, 10, 'PPL', 'P'),
(62607, 'Ashley Heights', 35.3858299255371, 0.617599240751362, -80.206672668457, -1.39987052013392, 218, 33, 'PPL', 'P'),
(79593, 'Ashley Heights', 32.9324989318848, 0.574780537270905, -80.054443359375, -1.3972136174724, 218, 48, 'PPL', 'P'),
(124136, 'Ashley Heights', 41.7791709899902, 0.729184092529028, -70.9208297729492, -1.23780198778439, 218, 23, 'PPL', 'P'),
(79594, 'Ashley Junction', 32.8688888549805, 0.573670331991478, -79.9958267211914, -1.39619056413965, 218, 48, 'PPL', 'P'),
(44481, 'Ashley Manor', 39.1333312988281, 0.6830054784383, -77.0347213745117, -1.34450952634168, 218, 25, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(44482, 'Ashley Mobile Home Park', 39.4097213745117, 0.687829395278815, -77.0552825927734, -1.34486838729857, 218, 25, 'PPL', 'P'),
(84739, 'Ashley Oaks', 35.9086112976074, 0.626723496962083, -84.102783203125, -1.46787047698551, 218, 50, 'PPL', 'P'),
(18938, 'Ashley Park', 33.5072212219238, 0.584811333516688, -84.476936340332, -1.47440068113644, 218, 13, 'PPL', 'P'),
(79595, 'Ashley Place (historical)', 33.1680603027344, 0.578891858782742, -81.6458282470703, -1.42498852342917, 218, 48, 'PPL', 'P'),
(79596, 'Ashley Retreat', 32.9661102294922, 0.575367165080022, -80.2452774047852, -1.40054429988971, 218, 48, 'PPL', 'P'),
(99528, 'Ashleys', 36.702220916748, 0.640574597791585, -81.914436340332, -1.42967661905409, 218, 53, 'PPL', 'P'),
(195900, 'Ashleys Settlement (historical)', 47.5763893127441, 0.830364639718027, -115.245826721191, -2.01141912546765, 218, 31, 'PPL', 'P'),
(79600, 'Ashleyville', 32.7930603027344, 0.572346874087763, -79.9847183227539, -1.39599668601229, 218, 48, 'PPL', 'P'),
(124137, 'Ashleyville', 42.1583290100098, 0.735801648363712, -72.6333312988281, -1.2676907778564, 218, 23, 'PPL', 'P'),
(18939, 'Ashling Place', 33.0883293151855, 0.577500290534148, -85.0541687011719, -1.48447528638216, 218, 13, 'PPL', 'P'),
(34603, 'Ashlock', 36.624439239502, 0.639217051425917, -85.432502746582, -1.49107846114696, 218, 21, 'PPL', 'P'),
(39158, 'Ashly', 32.4413909912109, 0.566209086723458, -91.1230621337891, -1.59039745873399, 218, 22, 'PPL', 'P'),
(44483, 'Ashmead', 39.1569404602051, 0.683417536037962, -76.9916687011719, -1.34375811544012, 218, 25, 'PPL', 'P'),
(158795, 'Ashmead Village', 40.0616683959961, 0.699208017352287, -75.0994415283203, -1.31073252107815, 218, 45, 'PPL', 'P'),
(189891, 'Ashmeadow (historical)', 36.3616714477539, 0.634630888291719, -116.293327331543, -2.02970146003494, 218, 39, 'PPL', 'P'),
(99529, 'Ashmere', 37.9819412231445, 0.662909930642834, -78.4049987792969, -1.36842537872087, 218, 53, 'PPL', 'P'),
(62611, 'Ashmont', 35.0702781677246, 0.612091823617079, -79.3552780151367, -1.38501088019961, 218, 33, 'PPL', 'P'),
(124138, 'Ashmont', 42.2833290100098, 0.737983309928705, -71.0694427490234, -1.24039577352807, 218, 23, 'PPL', 'P'),
(154108, 'Ashmont (historical)', 41.3761100769043, 0.722149352509584, -82.4400024414063, -1.4388494779547, 218, 41, 'PPL', 'P'),
(195901, 'Ashmoor (historical)', 48.0633316040039, 0.838863385967716, -111.324996948242, -1.94298773651947, 218, 31, 'PPL', 'P'),
(15038, 'Ashmore', 30.0852794647217, 0.525087183042031, -84.4702835083008, -1.47428456731292, 218, 12, 'PPL', 'P'),
(26404, 'Ashmore', 39.5330581665039, 0.689982028387926, -88.022216796875, -1.53627749800973, 218, 18, 'PPL', 'P'),
(191091, 'Ashmore', 32.9152793884277, 0.57447999954189, -102.278060913086, -1.78508891548867, 218, 51, 'PPL', 'P'),
(146894, 'Ashokan', 41.9755592346191, 0.732611714010015, -74.1972198486328, -1.29498578218473, 218, 40, 'PPL', 'P'),
(84737, 'Ashport', 35.7599983215332, 0.6241297112184, -89.7855606079102, -1.56705365335695, 218, 50, 'PPL', 'P'),
(84738, 'Ashport Landing', 35.7602806091309, 0.624134638066417, -89.789436340332, -1.56712129764864, 218, 50, 'PPL', 'P'),
(179840, 'Ashrama', 37.3072204589844, 0.651133831776668, -121.468612670898, -2.12002722893688, 218, 6, 'PPL', 'P'),
(112848, 'Ashridge', 34.2347183227539, 0.597508553224886, -87.4686126708984, -1.52661528325881, 218, 2, 'PPL', 'P'),
(568, 'Ashridge (historical)', 31.0680599212646, 0.542239937832958, -91.6302795410156, -1.59925007251352, 218, 22, 'PPL', 'P'),
(154109, 'Ashtabula', 41.8650016784668, 0.730682120642198, -80.7900009155273, -1.41005151866519, 218, 41, 'PPL', 'P'),
(139619, 'Ashtabula (historical)', 47.1416702270508, 0.822777360351419, -98.0313873291016, -1.71097047919067, 218, 34, 'PPL', 'P'),
(158796, 'Ashtola', 40.1969413757324, 0.70156897623767, -78.7799987792969, -1.37497036341584, 218, 45, 'PPL', 'P'),
(191092, 'Ashtola', 35.0063896179199, 0.610976758068662, -101.043060302734, -1.76353408857389, 218, 51, 'PPL', 'P'),
(7180, 'Ashton', 33.3127784729004, 0.5814176673396, -91.3391723632813, -1.59416929378587, 218, 4, 'PPL', 'P'),
(15039, 'Ashton', 28.2461109161377, 0.492987636370115, -81.2441711425781, -1.41797828449175, 218, 12, 'PPL', 'P'),
(18948, 'Ashton', 31.704719543457, 0.553351744454719, -83.1561126708984, -1.45134795926655, 218, 13, 'PPL', 'P'),
(31685, 'Ashton', 37.0830612182617, 0.647221514977287, -97.2383270263672, -1.69712896574109, 218, 20, 'PPL', 'P'),
(39155, 'Ashton', 29.8358306884766, 0.520733480581483, -91.6080627441406, -1.59886231625881, 218, 22, 'PPL', 'P'),
(44485, 'Ashton', 39.6300010681152, 0.69167400120748, -77.915283203125, -1.35987822951837, 218, 25, 'PPL', 'P'),
(62612, 'Ashton', 34.4752807617188, 0.601707159841451, -77.9013900756836, -1.35963574870111, 218, 33, 'PPL', 'P'),
(71704, 'Ashton', 39.714168548584, 0.693143000864768, -81.4647216796875, -1.42182761753135, 218, 41, 'PPL', 'P'),
(79601, 'Ashton', 33.0158309936523, 0.576234956121224, -80.970832824707, -1.41320763087304, 218, 48, 'PPL', 'P'),
(108036, 'Ashton', 38.6241683959961, 0.674118909354869, -82.1647186279297, -1.43404486903209, 218, 58, 'PPL', 'P'),
(114451, 'Ashton', 43.3113899230957, 0.755926357773114, -95.7908325195313, -1.67186542069228, 218, 16, 'PPL', 'P'),
(118667, 'Ashton', 41.8661117553711, 0.730701495139128, -89.2211074829102, -1.55720208785253, 218, 18, 'PPL', 'P'),
(129579, 'Ashton', 43.9730606079102, 0.767474689787051, -85.5036087036133, -1.49231949421493, 218, 27, 'PPL', 'P'),
(139015, 'Ashton', 40.4461097717285, 0.705917785139715, -91.807502746582, -1.60234320096159, 218, 29, 'PPL', 'P'),
(141203, 'Ashton', 41.2480583190918, 0.71991442772279, -98.7938919067383, -1.72427869463196, 218, 35, 'PPL', 'P'),
(169264, 'Ashton', 41.9388885498047, 0.731971689821042, -71.4311065673828, -1.24670799794378, 218, 47, 'PPL', 'P'),
(169759, 'Ashton', 44.9949989318848, 0.785310878292721, -98.4974975585938, -1.71910563737254, 218, 49, 'PPL', 'P'),
(172985, 'Ashton', 43.1405601501465, 0.752944815774715, -89.541389465332, -1.56279206298061, 218, 57, 'PPL', 'P'),
(189892, 'Ashton', 36.7202796936035, 0.640889782906596, -116.671669006348, -2.03630476795779, 218, 39, 'PPL', 'P'),
(194536, 'Ashton', 44.0716705322266, 0.769195757641515, -111.44750213623, -1.94512585540064, 218, 17, 'PPL', 'P'),
(53277, 'Ashton (historical)', 39.7219390869141, 0.69327862234328, -94.8341674804688, -1.65516846592192, 218, 29, 'PPL', 'P'),
(172986, 'Ashton Corners', 43.1402816772461, 0.752939955505726, -89.5205612182617, -1.56242854149181, 218, 57, 'PPL', 'P'),
(99530, 'Ashton Glen', 38.7605590820313, 0.676499375895236, -77.5033264160156, -1.35268822720737, 218, 53, 'PPL', 'P'),
(44486, 'Ashton Manor', 39.1444396972656, 0.683199356565658, -77.0111083984375, -1.34409740216299, 218, 25, 'PPL', 'P'),
(18943, 'Ashton Place', 33.9113883972168, 0.591865381454036, -83.3363876342773, -1.45449435093643, 218, 13, 'PPL', 'P'),
(44487, 'Ashton Pond', 39.1505584716797, 0.68330614932537, -76.9883270263672, -1.34369979221224, 218, 25, 'PPL', 'P'),
(44488, 'Ashton River Estates', 39.1761093139648, 0.683752095649903, -77.0263900756836, -1.34436411774616, 218, 25, 'PPL', 'P'),
(158797, 'Ashton Wooden Bridge', 40.0716705322266, 0.699382587561742, -75.0233306884766, -1.30940413632642, 218, 45, 'PPL', 'P'),
(77802, 'Ashtree', 39.7727813720703, 0.694165987618495, -80.3627777099609, -1.40259506708713, 218, 45, 'PPL', 'P'),
(206723, 'Ashue', 46.4044418334961, 0.809910297544701, -120.45832824707, -2.10239443935947, 218, 56, 'PPL', 'P'),
(143475, 'Ashuelot', 42.7775001525879, 0.746608223435035, -72.4241714477539, -1.26404024979217, 218, 36, 'PPL', 'P'),
(195902, 'Ashuelot', 47.5572204589844, 0.830030080106086, -111.810562133789, -1.95146244774032, 218, 31, 'PPL', 'P'),
(193052, 'Ashurst', 32.9841690063477, 0.575682350195033, -109.931671142578, -1.91866961365763, 218, 5, 'PPL', 'P'),
(15040, 'Ashville', 30.6163902282715, 0.534356814558756, -83.6466674804688, -1.45990975585505, 218, 12, 'PPL', 'P'),
(34604, 'Ashville', 38.1347198486328, 0.665576420684276, -85.5805587768555, -1.49366252635266, 218, 21, 'PPL', 'P'),
(71705, 'Ashville', 39.7155609130859, 0.693167302209715, -82.9530563354492, -1.44780395764593, 218, 41, 'PPL', 'P'),
(99532, 'Ashville', 38.8805618286133, 0.678593818934529, -77.934440612793, -1.36021258939322, 218, 53, 'PPL', 'P'),
(112850, 'Ashville', 33.8369407653809, 0.590566025158186, -86.2544403076172, -1.50542397783283, 218, 2, 'PPL', 'P'),
(126780, 'Ashville', 44.4877815246582, 0.776458264513189, -68.1216735839844, -1.18894749600937, 218, 26, 'PPL', 'P'),
(146895, 'Ashville', 42.0963897705078, 0.734720604698221, -79.3758316040039, -1.38536960799844, 218, 40, 'PPL', 'P'),
(158798, 'Ashville', 40.560001373291, 0.70790556857735, -78.5488891601563, -1.37093673962881, 218, 45, 'PPL', 'P'),
(39156, 'Ashville (historical)', 32.1527786254883, 0.561171850679627, -91.1791687011719, -1.59137670306681, 218, 22, 'PPL', 'P'),
(172987, 'Ashwaubenon', 44.4822196960449, 0.776361192291455, -88.0699996948242, -1.53711146690508, 218, 57, 'PPL', 'P'),
(58501, 'Ashwood', 31.0447196960449, 0.541832574054717, -91.2969436645508, -1.59343226395419, 218, 30, 'PPL', 'P'),
(62613, 'Ashwood', 35.0738906860352, 0.612154873955886, -76.7163925170898, -1.33895363967556, 218, 33, 'PPL', 'P'),
(79602, 'Ashwood', 34.1088905334473, 0.59531244401098, -80.3166732788086, -1.40179039296376, 218, 48, 'PPL', 'P'),
(84741, 'Ashwood', 36.0652809143066, 0.629457897611322, -86.4630584716797, -1.50906505167519, 218, 50, 'PPL', 'P'),
(92354, 'Ashwood', 29.103889465332, 0.507958696306536, -95.8711090087891, -1.67326650974177, 218, 51, 'PPL', 'P'),
(99536, 'Ashwood', 37.9724998474121, 0.662745147550386, -79.8505630493164, -1.39365523478189, 218, 53, 'PPL', 'P'),
(146896, 'Ashwood', 43.3277816772461, 0.756212447853215, -78.3102798461914, -1.3667722214742, 218, 40, 'PPL', 'P'),
(200345, 'Ashwood', 44.7338905334473, 0.780753677035377, -120.753326416016, -2.10754312869492, 218, 43, 'PPL', 'P'),
(58502, 'Ashwood (historical)', 33.4472198486328, 0.583764111997042, -91.1166687011719, -1.59028587228431, 218, 30, 'PPL', 'P'),
(154112, 'Ashwood (historical)', 41.2558288574219, 0.720050049201302, -84.4572219848633, -1.4740566007236, 218, 41, 'PPL', 'P'),
(79603, 'Ashwood Estates', 34.1277809143066, 0.595642143353932, -79.7744369506836, -1.39232658371405, 218, 48, 'PPL', 'P'),
(44489, 'Ashwood Manor', 38.7402801513672, 0.676145441786365, -76.6680603027344, -1.33811008340028, 218, 25, 'PPL', 'P'),
(99533, 'Ashwoods', 37.6155586242676, 0.656515347970418, -77.7169418334961, -1.35641651957543, 218, 53, 'PPL', 'P'),
(84742, 'Asia', 35.2438888549805, 0.615121901726344, -86.0902786254883, -1.50255881597407, 218, 50, 'PPL', 'P'),
(92355, 'Asia', 30.9979190826416, 0.541015749258876, -94.8691101074219, -1.65577832981154, 218, 51, 'PPL', 'P'),
(18944, 'Aska', 34.7677803039551, 0.606812239914051, -84.2622222900391, -1.47065321400854, 218, 13, 'PPL', 'P'),
(158800, 'Askam', 41.1986083984375, 0.719051363792522, -75.954719543457, -1.32565993846221, 218, 45, 'PPL', 'P'),
(112851, 'Askea Grove', 34.2852783203125, 0.598390991652084, -86.4594421386719, -1.50900193475735, 218, 2, 'PPL', 'P'),
(172990, 'Askeaton', 44.2700004577637, 0.772657267847373, -88.1108322143555, -1.53782412881279, 218, 57, 'PPL', 'P'),
(58503, 'Askew', 34.5369415283203, 0.602783343237952, -90.1933288574219, -1.57417055189603, 218, 30, 'PPL', 'P'),
(7181, 'Askew (historical)', 34.7744407653809, 0.606928486895633, -90.5508270263672, -1.58041007201397, 218, 4, 'PPL', 'P'),
(62614, 'Askewville', 36.1097183227539, 0.63023347669978, -76.9402770996094, -1.34286116278498, 218, 33, 'PPL', 'P'),
(34611, 'Askin', 37.6383285522461, 0.656912758184085, -86.6399993896484, -1.51215325327524, 218, 21, 'PPL', 'P'),
(112448, 'Askin', 35.2202796936035, 0.614709844126681, -77.0669403076172, -1.34507185280585, 218, 33, 'PPL', 'P'),
(134017, 'Askov', 46.1866683959961, 0.80610943403694, -92.7822189331055, -1.61935520768891, 218, 28, 'PPL', 'P'),
(118669, 'Askvig Addition', 41.9438896179199, 0.732058974925769, -89.0741729736328, -1.55463759688084, 218, 18, 'PPL', 'P'),
(206721, 'Asotin', 46.3394393920898, 0.808775790920327, -117.047218322754, -2.04285934003269, 218, 56, 'PPL', 'P'),
(112852, 'Aspel', 34.6208305358887, 0.60424748262625, -86.1655578613281, -1.50387268649786, 218, 2, 'PPL', 'P'),
(44490, 'Aspen', 39.4186096191406, 0.687984524412312, -77.3188934326172, -1.34946926439779, 218, 25, 'PPL', 'P'),
(99534, 'Aspen', 37.040828704834, 0.64648441856658, -78.8269424438477, -1.37578968492521, 218, 53, 'PPL', 'P'),
(186364, 'Aspen', 39.1911087036133, 0.684013884385058, -106.816940307617, -1.86430730527416, 218, 7, 'PPL', 'P'),
(209280, 'Aspen', 41.2058296203613, 0.71917739789111, -110.751106262207, -1.93297145450162, 218, 59, 'PPL', 'P'),
(18945, 'Aspen Acres', 33.5819396972656, 0.586115416923473, -84.4286117553711, -1.47355725801921, 218, 13, 'PPL', 'P'),
(202923, 'Aspen Glen Condominium', 40.6494407653809, 0.7094665804503, -111.883888244629, -1.95274222980215, 218, 52, 'PPL', 'P'),
(34605, 'Aspen Grove', 38.8963890075684, 0.678870055318597, -84.3858337402344, -1.47281064080761, 218, 21, 'PPL', 'P'),
(193225, 'Aspen Grove', 40.4033317565918, 0.705171167928111, -111.601669311523, -1.947816580208, 218, 52, 'PPL', 'P'),
(79604, 'Aspen Heights', 34.2150001525879, 0.597164406233021, -82.1138916015625, -1.43315777007299, 218, 48, 'PPL', 'P'),
(44491, 'Aspen Hill', 39.0794410705566, 0.682064916520311, -77.0733337402344, -1.34518343925553, 218, 25, 'PPL', 'P'),
(84743, 'Aspen Hill', 35.1005592346191, 0.612620327935405, -87.0038909912109, -1.51850435984286, 218, 50, 'PPL', 'P'),
(44492, 'Aspen Hill Park', 39.0719413757324, 0.681934022152734, -77.0947189331055, -1.3455566812823, 218, 25, 'PPL', 'P'),
(44493, 'Aspen Knolls', 39.0833282470703, 0.682132760549081, -77.0886077880859, -1.34545002168064, 218, 25, 'PPL', 'P'),
(13309, 'Aspen Meadows', 38.7347183227539, 0.676048369564631, -75.1308288574219, -1.31128033331438, 218, 10, 'PPL', 'P'),
(186365, 'Aspen Meadows', 39.976390838623, 0.697719643198069, -105.412780761719, -1.83980009797493, 218, 7, 'PPL', 'P'),
(188087, 'Aspen Mountain', 33.6980590820313, 0.588142082513023, -108.964996337891, -1.90179795551976, 218, 38, 'PPL', 'P'),
(44494, 'Aspen Park', 39.1352806091309, 0.683039500321226, -76.5500030517578, -1.33604959566488, 218, 25, 'PPL', 'P'),
(186366, 'Aspen Park', 39.5391693115234, 0.690088687989584, -105.294166564941, -1.83772988970156, 218, 7, 'PPL', 'P'),
(202926, 'Aspen Park Condo', 40.624439239502, 0.70903022150569, -111.807220458984, -1.95140412451244, 218, 52, 'PPL', 'P'),
(44495, 'Aspen Run', 39.5794410705566, 0.690791562780283, -76.899169921875, -1.34214370718731, 218, 25, 'PPL', 'P'),
(179841, 'Aspen Springs', 37.5547218322754, 0.655453545643803, -118.712219238281, -2.07191908805736, 218, 6, 'PPL', 'P'),
(179842, 'Aspen Valley', 37.8274993896484, 0.660214412145511, -119.770278930664, -2.09038571337208, 218, 6, 'PPL', 'P'),
(194537, 'Aspendale', 46.6769409179688, 0.814666303777419, -116.496391296387, -2.03324559481361, 218, 17, 'PPL', 'P'),
(179843, 'Aspendell', 37.2380599975586, 0.649926754012589, -118.597503662109, -2.06991692354984, 218, 6, 'PPL', 'P'),
(53264, 'Aspenhoff', 38.7013893127441, 0.675466668603531, -91.1513900756836, -1.59089187459036, 218, 29, 'PPL', 'P'),
(99535, 'Aspenwall', 37.0205612182617, 0.64613068419479, -78.8238906860352, -1.37573642170341, 218, 53, 'PPL', 'P'),
(44530, 'Aspenwood', 39.1500015258789, 0.683296428787391, -76.8197174072266, -1.34075699920771, 218, 25, 'PPL', 'P'),
(53265, 'Asper', 39.6055603027344, 0.691247429379877, -93.4775009155273, -1.63149016751197, 218, 29, 'PPL', 'P'),
(191093, 'Aspermont', 33.1333312988281, 0.57828572331864, -100.226936340332, -1.74929003832555, 218, 51, 'PPL', 'P'),
(77803, 'Aspers', 39.9794387817383, 0.697772839840844, -77.2230606079102, -1.34779666607517, 218, 45, 'PPL', 'P'),
(177450, 'Aspetuck', 41.2180595397949, 0.71939085025248, -73.3213882446289, -1.27969963700184, 218, 8, 'PPL', 'P'),
(34606, 'Asphalt', 37.1908302307129, 0.649102439076182, -86.3499984741211, -1.50709178246549, 218, 21, 'PPL', 'P'),
(179844, 'Asphalt Mines (historical)', 35.1936111450195, 0.614244390147162, -120.609443664551, -2.10503190094503, 218, 6, 'PPL', 'P'),
(179845, 'Asphalto (historical)', 35.3047218322754, 0.616183637473931, -119.599998474121, -2.08741375875361, 218, 6, 'PPL', 'P'),
(75025, 'Asphaltum', 34.2599983215332, 0.597949772438485, -97.6747207641602, -1.70474547330067, 218, 42, 'PPL', 'P'),
(122164, 'Asphaltum', 41.1002807617188, 0.717335222786075, -86.9980621337891, -1.51840262708922, 218, 19, 'PPL', 'P'),
(108043, 'Aspinall', 38.9261093139648, 0.679388772519918, -80.6044387817383, -1.40681284846354, 218, 58, 'PPL', 'P'),
(18946, 'Aspinwall', 31.4347190856934, 0.548639347484851, -82.1741714477539, -1.43420985186162, 218, 13, 'PPL', 'P'),
(114453, 'Aspinwall', 41.9119415283203, 0.731501375572534, -95.1352767944336, -1.66042381485902, 218, 16, 'PPL', 'P'),
(158801, 'Aspinwall', 40.4913902282715, 0.706708078193196, -79.9049987792969, -1.39460531750078, 218, 45, 'PPL', 'P'),
(31686, 'Assaria', 38.6802787780762, 0.675098220266718, -97.6041717529297, -1.70351416077067, 218, 20, 'PPL', 'P'),
(146897, 'Assembly Park', 42.7797203063965, 0.746646972428896, -76.1305618286133, -1.32872896530242, 218, 40, 'PPL', 'P'),
(129580, 'Assinins', 46.8102798461914, 0.816993507095985, -88.4772186279297, -1.54421877806423, 218, 27, 'PPL', 'P'),
(124139, 'Assinippi', 42.1583290100098, 0.735801648363712, -70.8513870239258, -1.23658998317229, 218, 23, 'PPL', 'P'),
(124140, 'Assonet', 41.7958297729492, 0.729474843141038, -71.0683288574219, -1.24037633245211, 218, 23, 'PPL', 'P'),
(124141, 'Assonet Bay Shores', 41.7958297729492, 0.729474843141038, -71.0902786254883, -1.24075942817492, 218, 23, 'PPL', 'P'),
(26406, 'Assumption', 39.5202789306641, 0.689758988646632, -89.0488891601563, -1.55419631108821, 218, 18, 'PPL', 'P'),
(134019, 'Assumption', 44.688060760498, 0.779953796601972, -93.8886108398438, -1.63866538927891, 218, 28, 'PPL', 'P'),
(141206, 'Assumption', 40.5099983215332, 0.707032850688131, -98.5719375610352, -1.72040486051033, 218, 35, 'PPL', 'P'),
(154113, 'Assumption', 41.6719398498535, 0.727312556072975, -83.9116668701172, -1.46453486772019, 218, 41, 'PPL', 'P'),
(108037, 'Assurance', 37.4955596923828, 0.654420971510152, -80.6730575561523, -1.40801047200575, 218, 58, 'PPL', 'P'),
(129581, 'Assyria', 42.4644393920898, 0.741144282405547, -85.1313934326172, -1.48582311220985, 218, 27, 'PPL', 'P'),
(18947, 'Asta Village', 33.1300010681152, 0.578227599827849, -84.975830078125, -1.48310801947851, 218, 13, 'PPL', 'P'),
(15041, 'Astatula', 28.7094402313232, 0.501074258441113, -81.7330627441406, -1.42651105262437, 218, 12, 'PPL', 'P'),
(179846, 'Asti', 38.7630615234375, 0.676543051737113, -122.971939086914, -2.14626522462856, 218, 6, 'PPL', 'P'),
(172991, 'Astico', 43.3330612182617, 0.756304593226932, -88.9397201538086, -1.55229095248632, 218, 57, 'PPL', 'P'),
(126782, 'Asticou', 44.3038902282715, 0.77324875592548, -68.2822189331055, -1.1917495409503, 218, 26, 'PPL', 'P'),
(92356, 'Astin', 30.7066707611084, 0.535932507107215, -96.5630569458008, -1.685343279495, 218, 51, 'PPL', 'P'),
(77804, 'Aston Mills', 39.8741683959961, 0.695935525004798, -75.4486083984375, -1.31682663260058, 218, 45, 'PPL', 'P'),
(15042, 'Astor', 29.1622200012207, 0.508976756212246, -81.5255584716797, -1.42288941985797, 218, 12, 'PPL', 'P'),
(108038, 'Astor', 39.2402801513672, 0.684872088046336, -80.1413879394531, -1.39873108666153, 218, 58, 'PPL', 'P'),
(114454, 'Astor', 41.8699989318848, 0.730769339167898, -95.2663879394531, -1.66271213602567, 218, 16, 'PPL', 'P'),
(187583, 'Astor', 38.4727783203125, 0.671476654079347, -101.902496337891, -1.77853407709766, 218, 20, 'PPL', 'P'),
(186367, 'Astor City (historical)', 39.5499992370605, 0.690277705847952, -106.408332824707, -1.8571757593491, 218, 7, 'PPL', 'P'),
(15043, 'Astor Farms', 28.8291702270508, 0.503163941079957, -81.3633270263672, -1.42005794698699, 218, 12, 'PPL', 'P'),
(15044, 'Astor Park', 29.1533298492432, 0.508821593789235, -81.5722198486328, -1.42370381451931, 218, 12, 'PPL', 'P'),
(18949, 'Astoria', 31.1483306884766, 0.543640927013908, -82.2919387817383, -1.43626527959094, 218, 13, 'PPL', 'P'),
(53266, 'Astoria', 37.3797187805176, 0.652399166189591, -92.2886123657227, -1.61074014787861, 218, 29, 'PPL', 'P'),
(71714, 'Astoria', 39.5591697692871, 0.690437761829466, -84.466667175293, -1.47422145039508, 218, 41, 'PPL', 'P'),
(118670, 'Astoria', 40.2275009155273, 0.702102340824985, -90.3594436645508, -1.57706980221674, 218, 18, 'PPL', 'P'),
(146898, 'Astoria', 40.7719383239746, 0.711604566173415, -73.9305572509766, -1.29033164186371, 218, 40, 'PPL', 'P'),
(169762, 'Astoria', 44.5583305358887, 0.777689577043187, -96.5469436645508, -1.68506204968389, 218, 49, 'PPL', 'P'),
(200346, 'Astoria', 46.188060760498, 0.806133735381887, -123.830001831055, -2.16124124470251, 218, 43, 'PPL', 'P'),
(158803, 'Astral', 41.3438911437988, 0.721587026045414, -79.772216796875, -1.39228783472019, 218, 45, 'PPL', 'P'),
(179847, 'Asuncion', 35.5149993896484, 0.619853673193142, -120.678329467773, -2.10623418501914, 218, 6, 'PPL', 'P'),
(158804, 'Asylum', 41.7130584716797, 0.728030211407724, -76.3338928222656, -1.332277760613, 218, 45, 'PPL', 'P'),
(179849, 'Asylum', 39.1336097717285, 0.683010338707289, -123.199440002441, -2.15023586465581, 218, 6, 'PPL', 'P'),
(44496, 'Asylum (historical)', 39.2669410705566, 0.6853374088678, -76.7249984741211, -1.33910384196104, 218, 25, 'PPL', 'P'),
(114455, 'Atalissa', 41.5711097717285, 0.725552739224651, -91.1658325195313, -1.59114394278754, 218, 16, 'PPL', 'P'),
(62615, 'Atando Junction', 35.2608299255371, 0.61541757918637, -80.8169403076172, -1.41052169975564, 218, 33, 'PPL', 'P'),
(188088, 'Atarque', 34.7363891601563, 0.606264361098794, -108.702499389648, -1.89721651949649, 218, 38, 'PPL', 'P'),
(179850, 'Atascadero', 35.4894409179688, 0.619407593710554, -120.669723510742, -2.10608398273366, 218, 6, 'PPL', 'P'),
(92357, 'Atascocita', 29.9986095428467, 0.523574507542866, -95.1763916015625, -1.66114140361474, 218, 51, 'PPL', 'P'),
(92358, 'Atascosa', 29.2666702270508, 0.510799756557433, -98.7316665649414, -1.72319265753943, 218, 51, 'PPL', 'P'),
(92360, 'Atascosito', 30.0916690826416, 0.525198702912678, -94.7624969482422, -1.6539175791579, 218, 51, 'PPL', 'P'),
(92361, 'Atascosito Crossing (historical)', 29.6619396209717, 0.517698508913715, -96.4502792358398, -1.68337493713333, 218, 51, 'PPL', 'P'),
(15045, 'Atawalia (historical)', 30.0833301544189, 0.525053161159105, -83.8833312988281, -1.46404031870576, 218, 12, 'PPL', 'P'),
(39159, 'Atchafalaya', 30.3458309173584, 0.529634663761395, -91.7230606079102, -1.60086940761434, 218, 22, 'PPL', 'P'),
(186368, 'Atchee', 39.563060760498, 0.690505672437263, -108.912216186523, -1.9008767680987, 218, 7, 'PPL', 'P'),
(31687, 'Atchison', 39.563060760498, 0.690505672437263, -95.1213912963867, -1.66018146719983, 218, 20, 'PPL', 'P'),
(34607, 'Atchison', 37.3074989318848, 0.651138692045657, -85.3005599975586, -1.48877562575236, 218, 21, 'PPL', 'P'),
(177451, 'Atchison Cove', 41.5741691589355, 0.725606135604507, -73.4847183227539, -1.28255028463266, 218, 8, 'PPL', 'P'),
(53268, 'Atchley (historical)', 37.7366714477539, 0.658629165506641, -92.7063903808594, -1.6180317497852, 218, 29, 'PPL', 'P'),
(18950, 'Atco', 34.1805610656738, 0.59656333077499, -84.8199996948242, -1.48038826621527, 218, 13, 'PPL', 'P'),
(70468, 'Atco', 39.769718170166, 0.694112524659611, -74.8877792358398, -1.30703831717205, 218, 37, 'PPL', 'P'),
(92364, 'Atco', 31.4797191619873, 0.549424746979829, -97.245002746582, -1.69724547903879, 218, 51, 'PPL', 'P'),
(158805, 'Atco', 41.6211090087891, 0.726425390534843, -75.0861129760742, -1.31049989395693, 218, 45, 'PPL', 'P'),
(197954, 'Atcoal', 48.9013900756836, 0.853490265622758, -102.911392211914, -1.79614263190915, 218, 34, 'PPL', 'P'),
(141207, 'Aten', 42.8400001525879, 0.747699054217532, -97.440559387207, -1.70065858629183, 218, 35, 'PPL', 'P'),
(188089, 'Atencio', 36.7713890075684, 0.641781808713718, -103.125282287598, -1.79987571796717, 218, 38, 'PPL', 'P'),
(108039, 'Atenville', 38.0480613708496, 0.664063944922193, -82.1430587768555, -1.43366683331535, 218, 58, 'PPL', 'P'),
(92362, 'Ater', 31.5230598449707, 0.550181184597952, -97.8608322143555, -1.70799373088224, 218, 51, 'PPL', 'P'),
(77806, 'Atglen', 39.9491691589355, 0.697244535259599, -75.9738922119141, -1.32599456465318, 218, 45, 'PPL', 'P'),
(71706, 'Athalia', 38.5161094665527, 0.672232925249902, -82.3066711425781, -1.43652240779419, 218, 41, 'PPL', 'P'),
(201875, 'Athboy', 45.5741691589355, 0.79541930568428, -101.922218322754, -1.77887829066855, 218, 49, 'PPL', 'P'),
(126783, 'Athearns Corner', 44.2730598449707, 0.772710664227229, -69.166389465332, -1.20718122788676, 218, 26, 'PPL', 'P'),
(79605, 'Athelone Heights', 34.7819404602051, 0.60705938126321, -82.3952789306641, -1.4380689054392, 218, 48, 'PPL', 'P'),
(7184, 'Athelstan', 35.6980590820313, 0.62304866755291, -90.1783294677734, -1.57390876316087, 218, 4, 'PPL', 'P'),
(114456, 'Athelstan', 40.5722198486328, 0.708118821201638, -94.5372161865234, -1.64998568812451, 218, 16, 'PPL', 'P'),
(172992, 'Athelstane', 45.4238891601563, 0.792796424905688, -88.0952835083008, -1.53755275269771, 218, 57, 'PPL', 'P'),
(15046, 'Athena', 29.9877796173096, 0.523385489684497, -83.4944381713867, -1.45725285319353, 218, 12, 'PPL', 'P'),
(200347, 'Athena', 45.811939239502, 0.799569176452896, -118.489440917969, -2.06803087286585, 218, 43, 'PPL', 'P'),
(191094, 'Athena West Colonia', 31.6159992218018, 0.551803282728406, -106.221000671387, -1.85390619647881, 218, 51, 'PPL', 'P'),
(84744, 'Athendale', 35.6744384765625, 0.622636410216166, -87.0780563354492, -1.5197987892907, 218, 50, 'PPL', 'P'),
(144771, 'Athenia', 40.8666687011719, 0.713257923157164, -74.1547164916992, -1.29424395866309, 218, 37, 'PPL', 'P'),
(7182, 'Athens', 34.3144416809082, 0.598899988315426, -93.9766693115234, -1.640202299544, 218, 4, 'PPL', 'P'),
(18951, 'Athens', 33.9608306884766, 0.592728312226249, -83.378059387207, -1.45522166023013, 218, 13, 'PPL', 'P'),
(26408, 'Athens', 39.9608306884766, 0.697448067345908, -89.7238922119141, -1.5659773368024, 218, 18, 'PPL', 'P'),
(31691, 'Athens', 37.9069404602051, 0.661600920388033, -95.6136093139648, -1.6687722922442, 218, 20, 'PPL', 'P'),
(34608, 'Athens', 37.9491691589355, 0.662337950219713, -84.3641662597656, -1.47243247193282, 218, 21, 'PPL', 'P'),
(39160, 'Athens', 32.6502799987793, 0.569854887676749, -93.0255584716797, -1.62360228383731, 218, 22, 'PPL', 'P'),
(58504, 'Athens', 33.8722190856934, 0.591181748002212, -88.4416732788086, -1.5435983946883, 218, 30, 'PPL', 'P'),
(71707, 'Athens', 39.3291702270508, 0.686423512539362, -82.1013870239258, -1.43293952402165, 218, 41, 'PPL', 'P'),
(84745, 'Athens', 35.4427795410156, 0.618593199049207, -84.5930633544922, -1.47642747988405, 218, 50, 'PPL', 'P'),
(92363, 'Athens', 32.204719543457, 0.56207839071469, -95.8552780151367, -1.67299020677867, 218, 51, 'PPL', 'P'),
(108040, 'Athens', 37.4222183227539, 0.653140923132206, -81.0163879394531, -1.41400271761648, 218, 58, 'PPL', 'P'),
(112607, 'Athens', 37.9925003051758, 0.663094221390268, -77.4175033569336, -1.35119033225225, 218, 53, 'PPL', 'P'),
(112842, 'Athens', 34.8027801513672, 0.607423102489088, -86.9716720581055, -1.51794203337869, 218, 2, 'PPL', 'P'),
(122165, 'Athens', 41.0536117553711, 0.716520694966674, -86.1252822875977, -1.50316974512813, 218, 19, 'PPL', 'P'),
(126784, 'Athens', 44.9230613708496, 0.784055330996803, -69.6733322143555, -1.21602904797633, 218, 26, 'PPL', 'P'),
(129583, 'Athens', 42.0886116027832, 0.734584850061655, -85.2347183227539, -1.48762647174199, 218, 27, 'PPL', 'P'),
(139018, 'Athens', 40.5825004577637, 0.708298251680082, -91.6983337402344, -1.6004378423597, 218, 29, 'PPL', 'P'),
(146899, 'Athens', 42.2602806091309, 0.737581039446048, -73.8099975585938, -1.28822747828644, 218, 40, 'PPL', 'P'),
(158806, 'Athens', 41.957218170166, 0.732291602046987, -76.5183334350586, -1.33549685658064, 218, 45, 'PPL', 'P'),
(171694, 'Athens', 43.1336097717285, 0.752823508787062, -72.5683288574219, -1.26655627123203, 218, 55, 'PPL', 'P'),
(172994, 'Athens', 45.0330581665039, 0.785975137247614, -90.0738906860352, -1.57208596255277, 218, 57, 'PPL', 'P'),
(179852, 'Athens', 33.9199981689453, 0.592015650318544, -118.280281066895, -2.06438034480162, 218, 6, 'PPL', 'P'),
(202928, 'Athens', 40.7277793884277, 0.710833847353947, -112.066940307617, -1.95593709100387, 218, 52, 'PPL', 'P'),
(141208, 'Athens (historical)', 40.0444412231445, 0.698907346465217, -95.9861068725586, -1.6752736010973, 218, 35, 'PPL', 'P'),
(26411, 'Athensville', 39.4555587768555, 0.688629408870275, -90.1891708374023, -1.57409798075632, 218, 18, 'PPL', 'P'),
(29125, 'Atherton', 39.6080589294434, 0.691291038642727, -87.3619384765625, -1.52475346734073, 218, 19, 'PPL', 'P'),
(39161, 'Atherton', 32.6983299255371, 0.570693517104015, -91.170280456543, -1.59122157393331, 218, 22, 'PPL', 'P'),
(53269, 'Atherton', 39.1861114501953, 0.683926665859358, -94.3052825927734, -1.64593768326759, 218, 29, 'PPL', 'P'),
(71710, 'Atherton', 39.9605598449707, 0.697443340234974, -82.4361114501953, -1.43878156734691, 218, 41, 'PPL', 'P'),
(179853, 'Atherton', 37.4613914489746, 0.653824623163056, -122.196670532227, -2.13273423576209, 218, 6, 'PPL', 'P'),
(34609, 'Athertonville', 37.6355590820313, 0.6568644218103, -85.6041717529297, -1.49407465053135, 218, 21, 'PPL', 'P'),
(39162, 'Athlone', 31.610279083252, 0.551703447477041, -91.7375030517578, -1.60112147581152, 218, 22, 'PPL', 'P'),
(99537, 'Athlone', 38.535831451416, 0.672577138820795, -78.7063903808594, -1.37368565450599, 218, 53, 'PPL', 'P'),
(179854, 'Athlone', 37.2080612182617, 0.64940317654228, -120.356941223145, -2.10062490197316, 218, 6, 'PPL', 'P'),
(71711, 'Athlone (historical)', 39.357780456543, 0.686922855243752, -84.5194396972656, -1.47514250465808, 218, 41, 'PPL', 'P'),
(31693, 'Athol', 39.7649993896484, 0.694030166402901, -98.9191665649414, -1.72646514988692, 218, 20, 'PPL', 'P'),
(34610, 'Athol', 37.5525016784668, 0.655414796649943, -83.5627822875977, -1.45844568304578, 218, 21, 'PPL', 'P'),
(44497, 'Athol', 38.4263916015625, 0.670667053107963, -75.7888870239258, -1.32276561498951, 218, 25, 'PPL', 'P'),
(53271, 'Athol', 39.1072196960449, 0.68254974499676, -94.4830627441406, -1.64904053225364, 218, 29, 'PPL', 'P'),
(124142, 'Athol', 42.5958290100098, 0.743437463841187, -72.2272186279297, -1.26060277461515, 218, 23, 'PPL', 'P'),
(146901, 'Athol', 43.4925003051758, 0.759087330249956, -73.8433303833008, -1.28880924582657, 218, 40, 'PPL', 'P'),
(169764, 'Athol', 45.0088882446289, 0.785553292530945, -98.5961074829102, -1.720826705227, 218, 49, 'PPL', 'P'),
(194538, 'Athol', 47.9480590820313, 0.836851500922215, -116.706939697266, -2.03692035764376, 218, 17, 'PPL', 'P'),
(209281, 'Athol', 41.0127792358398, 0.715808033058969, -104.827781677246, -1.82958993782973, 218, 59, 'PPL', 'P'),
(124143, 'Athol Junction', 42.1277809143066, 0.735268483513478, -72.5625, -1.26645453847839, 218, 23, 'PPL', 'P'),
(146902, 'Athol Springs', 42.769718170166, 0.746472402219441, -78.8666687011719, -1.37648303891501, 218, 40, 'PPL', 'P'),
(18952, 'Athon (historical)', 33.3950004577637, 0.58285271169299, -83.5555572509766, -1.45831958236816, 218, 13, 'PPL', 'P'),
(193057, 'Athos', 34.9500007629395, 0.609992586887824, -114.138610839844, -1.99209456280776, 218, 5, 'PPL', 'P'),
(212288, 'Atka', 52.1961097717285, 0.910993972249048, -174.200561523438, -3.04037335740693, 218, 1, 'PPL', 'P'),
(112854, 'Atkeison', 31.9652805328369, 0.557899391621652, -87.686393737793, -1.53041627992462, 218, 2, 'PPL', 'P'),
(7186, 'Atkins', 35.2463912963867, 0.615165577568221, -92.936393737793, -1.62204606565433, 218, 4, 'PPL', 'P'),
(39163, 'Atkins', 32.309440612793, 0.563906118170812, -93.5147171020508, -1.63213971250184, 218, 22, 'PPL', 'P'),
(79606, 'Atkins', 34.0377807617188, 0.594071344363976, -80.1155624389648, -1.39828034664704, 218, 48, 'PPL', 'P'),
(84746, 'Atkins', 36.523609161377, 0.637457234577593, -87.7305603027344, -1.53118713190215, 218, 50, 'PPL', 'P'),
(99538, 'Atkins', 36.8672218322754, 0.643454407036342, -81.4236068725586, -1.42111002877563, 218, 53, 'PPL', 'P'),
(114458, 'Atkins', 41.996940612793, 0.732984889457762, -91.8619384765625, -1.60329328368048, 218, 16, 'PPL', 'P'),
(129585, 'Atkins', 43.063060760498, 0.751592196257064, -82.5769424438477, -1.44123953187499, 218, 27, 'PPL', 'P'),
(172996, 'Atkins', 45.6652793884277, 0.797009479171166, -89.023063659668, -1.55374557107372, 218, 57, 'PPL', 'P'),
(195903, 'Atkins', 45.6213912963867, 0.796243487462633, -111.196388244629, -1.94074309119469, 218, 31, 'PPL', 'P'),
(199157, 'Atkins', 41.7238883972168, 0.728219229266093, -103.214721679688, -1.80143672984012, 218, 35, 'PPL', 'P'),
(84747, 'Atkins (historical)', 35.7477798461914, 0.623916458594112, -88.5250015258789, -1.54505274695959, 218, 50, 'PPL', 'P'),
(44498, 'Atkins Acres', 39.3791694641113, 0.687296163849554, -77.1158294677734, -1.34592512961911, 218, 25, 'PPL', 'P'),
(7185, 'Atkins Lake', 34.2097206115723, 0.597072260859304, -91.8802795410156, -1.60361339564351, 218, 4, 'PPL', 'P'),
(18953, 'Atkinson', 31.2230606079102, 0.544945210157775, -81.852783203125, -1.42860056881564, 218, 13, 'PPL', 'P'),
(62616, 'Atkinson', 34.5283317565918, 0.602633074373444, -78.17138671875, -1.36434807909195, 218, 33, 'PPL', 'P'),
(118672, 'Atkinson', 41.4208297729492, 0.722929858446059, -90.0149993896484, -1.57105811553005, 218, 18, 'PPL', 'P'),
(122166, 'Atkinson', 40.5627784729004, 0.707954038109189, -87.2466735839844, -1.52274171545329, 218, 19, 'PPL', 'P'),
(134022, 'Atkinson', 46.6122207641602, 0.813536724001062, -92.5652770996094, -1.61556885840909, 218, 28, 'PPL', 'P'),
(141209, 'Atkinson', 42.5313911437988, 0.742312810912847, -98.977783203125, -1.72748820321967, 218, 35, 'PPL', 'P'),
(143476, 'Atkinson', 42.8383293151855, 0.747669892603596, -71.1474990844727, -1.2417581135837, 218, 36, 'PPL', 'P'),
(202929, 'Atkinson', 40.7405586242676, 0.711056887095241, -111.474166870117, -1.94559124280113, 218, 52, 'PPL', 'P'),
(206724, 'Atkinson', 47.4088897705078, 0.82744122121042, -122.015556335449, -2.12957319670622, 218, 56, 'PPL', 'P'),
(143477, 'Atkinson Heights', 42.8233299255371, 0.747408103868441, -71.1658325195313, -1.24207809238867, 218, 36, 'PPL', 'P'),
(126786, 'Atkinson Mills', 45.1597213745117, 0.788185827268489, -69.0827789306641, -1.20572194876746, 218, 26, 'PPL', 'P'),
(158810, 'Atkinson Mills', 40.4552803039551, 0.706077841121229, -77.8183288574219, -1.35818605696173, 218, 45, 'PPL', 'P'),
(29127, 'Atkinsonville', 39.3777809143066, 0.687271929083634, -86.8733291625977, -1.51622562605614, 218, 19, 'PPL', 'P'),
(34612, 'Atkinstown', 37.3830604553223, 0.652457489417464, -83.9627838134766, -1.46542702668537, 218, 21, 'PPL', 'P'),
(192472, 'Atkinville', 37.0299987792969, 0.646295400708212, -113.626937866211, -1.9831641847244, 218, 52, 'PPL', 'P'),
(7187, 'Atlanta', 33.1186103820801, 0.578028794852475, -93.0524978637695, -1.62407246492777, 218, 4, 'PPL', 'P'),
(13304, 'Atlanta', 38.708610534668, 0.675592702702119, -75.6783294677734, -1.32083602162169, 218, 10, 'PPL', 'P'),
(18955, 'Atlanta', 33.7488899230957, 0.589029248051156, -84.3880615234375, -1.47284952295953, 218, 13, 'PPL', 'P'),
(31694, 'Atlanta', 37.4363899230957, 0.653388264218447, -96.7644424438477, -1.68885811950169, 218, 20, 'PPL', 'P'),
(34613, 'Atlanta', 37.2324981689453, 0.649829681790856, -84.0494384765625, -1.46693943586842, 218, 21, 'PPL', 'P'),
(39164, 'Atlanta', 31.8050003051758, 0.555101973923119, -92.7380599975586, -1.61858448886944, 218, 22, 'PPL', 'P'),
(53272, 'Atlanta', 39.898609161377, 0.696362096832401, -92.480827331543, -1.61409493190379, 218, 29, 'PPL', 'P'),
(58505, 'Atlanta', 33.7983283996582, 0.589892112244342, -89.1474990844727, -1.55591737894268, 218, 30, 'PPL', 'P'),
(71712, 'Atlanta', 39.5613899230957, 0.690476510823326, -83.190559387207, -1.45194916788264, 218, 41, 'PPL', 'P'),
(92365, 'Atlanta', 33.1136093139648, 0.577941509747747, -94.1641693115234, -1.64347479189149, 218, 51, 'PPL', 'P'),
(118674, 'Atlanta', 40.2594413757324, 0.702659807020166, -89.2333297729492, -1.55741540705585, 218, 18, 'PPL', 'P'),
(122167, 'Atlanta', 40.2152786254883, 0.70188902162167, -86.0263900756836, -1.50144375042565, 218, 19, 'PPL', 'P'),
(129586, 'Atlanta', 45.0047187805176, 0.785480521654159, -84.1438903808594, -1.46858793258318, 218, 27, 'PPL', 'P'),
(141211, 'Atlanta', 40.3666687011719, 0.704531276897192, -99.4727783203125, -1.73612749779589, 218, 35, 'PPL', 'P'),
(146903, 'Atlanta', 42.5541687011719, 0.742710354284568, -77.4727783203125, -1.35215506235714, 218, 40, 'PPL', 'P'),
(179855, 'Atlanta', 37.813060760498, 0.659962410527362, -121.119720458984, -2.11393791110442, 218, 6, 'PPL', 'P'),
(186369, 'Atlanta', 37.5036087036133, 0.654561453257654, -102.995559692383, -1.79761163156644, 218, 7, 'PPL', 'P'),
(189895, 'Atlanta', 38.4652786254883, 0.671345759711769, -114.330558776855, -1.99544468630103, 218, 39, 'PPL', 'P'),
(194539, 'Atlanta', 43.8016700744629, 0.764483360671647, -115.125831604004, -2.00932481558641, 218, 17, 'PPL', 'P'),
(206725, 'Atlanta (historical)', 48.6091690063477, 0.848390045819147, -122.433326721191, -2.13686466545474, 218, 56, 'PPL', 'P'),
(13305, 'Atlanta Estates', 38.663890838623, 0.674812196765644, -75.6333312988281, -1.32005065541623, 218, 10, 'PPL', 'P'),
(18956, 'Atlanta Junction', 34.2138900756836, 0.597145031736091, -85.1827774047852, -1.48671993170693, 218, 13, 'PPL', 'P'),
(62617, 'Atlantic', 34.8847198486328, 0.608853219994461, -76.3408279418945, -1.33239880128455, 218, 33, 'PPL', 'P'),
(99541, 'Atlantic', 37.9005584716797, 0.661489533675441, -75.508056640625, -1.31786420016128, 218, 53, 'PPL', 'P'),
(114459, 'Atlantic', 41.4036102294922, 0.722629320717044, -95.0136108398438, -1.65830034336385, 218, 16, 'PPL', 'P'),
(124146, 'Atlantic', 42.2669410705566, 0.73769728642763, -70.8483276367188, -1.23653658679244, 218, 23, 'PPL', 'P'),
(126788, 'Atlantic', 44.1716690063477, 0.770941060261899, -68.4247207641602, -1.19423666709233, 218, 26, 'PPL', 'P'),
(143480, 'Atlantic', 42.8711090087891, 0.748242006184772, -70.8616714477539, -1.23676948022976, 218, 36, 'PPL', 'P'),
(158813, 'Atlantic', 40.3574981689453, 0.704371220915679, -79.3197174072266, -1.38439023050756, 218, 45, 'PPL', 'P'),
(108041, 'Atlantic (historical)', 39.3899993896484, 0.687485181707922, -79.7241668701172, -1.39144920529293, 218, 58, 'PPL', 'P'),
(15047, 'Atlantic Beach', 30.3341693878174, 0.529431131675086, -81.3988876342773, -1.42067859667904, 218, 12, 'PPL', 'P'),
(62618, 'Atlantic Beach', 34.6988906860352, 0.605609889260908, -76.7405624389648, -1.33937548439223, 218, 33, 'PPL', 'P'),
(79607, 'Atlantic Beach', 33.8025016784668, 0.589964949700155, -78.716667175293, -1.37386501840541, 218, 48, 'PPL', 'P'),
(146904, 'Atlantic Beach', 40.5888900756836, 0.708409771550729, -73.7294387817383, -1.28682146238893, 218, 40, 'PPL', 'P'),
(70469, 'Atlantic City', 39.3641700744629, 0.687034375114399, -74.4233322143555, -1.29893218744607, 218, 37, 'PPL', 'P'),
(209282, 'Atlantic City', 42.4966697692871, 0.741706808606799, -108.730003356934, -1.89769655428298, 218, 59, 'PPL', 'P'),
(195904, 'Atlantic City (historical)', 46.7855606079102, 0.816562074999392, -112.41667175293, -1.96204105622233, 218, 31, 'PPL', 'P'),
(15048, 'Atlantic Heights', 25.8549995422363, 0.451254870113651, -80.1208267211914, -1.39837222570464, 218, 12, 'PPL', 'P'),
(143481, 'Atlantic Heights', 43.0922203063965, 0.752101126341378, -70.773063659668, -1.23522298258475, 218, 36, 'PPL', 'P'),
(144772, 'Atlantic Highlands', 40.4077796936035, 0.705248799073887, -74.0347213745117, -1.29214964878185, 218, 37, 'PPL', 'P'),
(129587, 'Atlantic Mine', 47.0972213745117, 0.822001581525879, -88.6275024414063, -1.54684172542185, 218, 27, 'PPL', 'P'),
(99542, 'Atlantic Park', 36.8433303833008, 0.643037422588663, -76.0108337402344, -1.32663931595309, 218, 53, 'PPL', 'P'),
(146905, 'Atlantique', 40.6416702270508, 0.709330958971788, -73.1711120605469, -1.27707682280228, 218, 40, 'PPL', 'P'),
(15049, 'Atlantis', 26.5905609130859, 0.464092837885459, -80.1011123657227, -1.3980281452918, 218, 12, 'PPL', 'P'),
(44499, 'Atlantis', 39.0463905334473, 0.6814880758282, -76.4550018310547, -1.3343915115702, 218, 25, 'PPL', 'P'),
(26413, 'Atlas', 39.5138893127441, 0.689647468775985, -90.9694366455078, -1.5877161881485, 218, 18, 'PPL', 'P'),
(31696, 'Atlas', 37.3672218322754, 0.652181053296314, -94.7222213745117, -1.65321463778818, 218, 20, 'PPL', 'P'),
(53273, 'Atlas', 37.0950012207031, 0.647429907332585, -94.3858337402344, -1.64734356600704, 218, 29, 'PPL', 'P'),
(92366, 'Atlas', 33.5686111450195, 0.585882789802255, -95.6166687011719, -1.66882568862406, 218, 51, 'PPL', 'P'),
(108042, 'Atlas', 38.9775009155273, 0.680285725175056, -80.2799987792969, -1.40115030219576, 218, 58, 'PPL', 'P'),
(129588, 'Atlas', 42.9377784729004, 0.749405607844055, -83.5344390869141, -1.4579510008733, 218, 27, 'PPL', 'P'),
(158814, 'Atlas', 40.7997207641602, 0.712089461228892, -76.4280624389648, -1.33392133047974, 218, 45, 'PPL', 'P'),
(172998, 'Atlas', 45.6355590820313, 0.796490761969846, -92.5905609130859, -1.61601014420172, 218, 57, 'PPL', 'P'),
(179856, 'Atlas', 38.4291687011719, 0.670715522639802, -122.246940612793, -2.13361161418321, 218, 6, 'PPL', 'P'),
(194540, 'Atlas', 47.7005615234375, 0.832531853634107, -116.82861328125, -2.03904396229699, 218, 17, 'PPL', 'P'),
(112856, 'Atlas (historical)', 34.9119415283203, 0.609328327932931, -87.5088882446289, -1.52731822462854, 218, 2, 'PPL', 'P'),
(112261, 'Atlas Circle', 34.2830581665039, 0.598352242658224, -83.8574981689453, -1.46358944553321, 218, 13, 'PPL', 'P'),
(202930, 'Atlas Hills', 40.5980606079102, 0.708569827532243, -111.795829772949, -1.95120531953707, 218, 52, 'PPL', 'P'),
(158815, 'Atlasburg', 40.3411102294922, 0.704085197414604, -80.383056640625, -1.402949001196, 218, 45, 'PPL', 'P'),
(75027, 'Atlee', 34.0933303833008, 0.595040868158819, -97.6322174072266, -1.70400364977903, 218, 42, 'PPL', 'P'),
(99543, 'Atlee', 37.6575012207031, 0.657247384375053, -77.4072189331055, -1.35101083519478, 218, 53, 'PPL', 'P'),
(99544, 'Atlee Manor', 37.6594390869141, 0.657281206520897, -77.4124984741211, -1.3511029805685, 218, 53, 'PPL', 'P'),
(99545, 'Atlee Ridge', 37.6797218322754, 0.657635207208796, -77.4266662597656, -1.35135025507571, 218, 53, 'PPL', 'P'),
(99546, 'Atlee Station', 37.6500015258789, 0.657116490007476, -77.4022216796875, -1.35092361666908, 218, 53, 'PPL', 'P'),
(212289, 'Atmautluak', 60.8669395446777, 1.06232850066696, -162.273056030273, -2.83219911500151, 218, 1, 'PPL', 'P'),
(112855, 'Atmore', 31.023609161377, 0.541464125717905, -87.4938888549805, -1.52705643589338, 218, 2, 'PPL', 'P'),
(34614, 'Atoka', 37.6500015258789, 0.657116490007476, -84.8622207641602, -1.48112516288889, 218, 21, 'PPL', 'P'),
(75028, 'Atoka', 34.3858299255371, 0.600145948231419, -96.128059387207, -1.67775113985941, 218, 42, 'PPL', 'P'),
(84752, 'Atoka', 35.4411087036133, 0.618564037435271, -89.7780609130859, -1.56692275898938, 218, 50, 'PPL', 'P'),
(99547, 'Atoka', 38.9755592346191, 0.680251836450185, -77.8097229003906, -1.35803585467625, 218, 53, 'PPL', 'P'),
(188090, 'Atoka', 32.7694396972656, 0.571934616751019, -104.388328552246, -1.8219200338903, 218, 38, 'PPL', 'P'),
(179858, 'Atolia', 35.3147201538086, 0.616358141104358, -117.608329772949, -2.05265258230924, 218, 6, 'PPL', 'P'),
(194541, 'Atomic City', 43.4449996948242, 0.758258288202614, -112.811943054199, -1.96893984186812, 218, 17, 'PPL', 'P'),
(112579, 'Atoy', 31.773889541626, 0.554558988666365, -95.0130615234375, -1.65829075598392, 218, 51, 'PPL', 'P'),
(212290, 'Atqasuk', 70.4694366455078, 1.22992369148966, -157.39582824707, -2.74707543181487, 218, 1, 'PPL', 'P'),
(92367, 'Atreco', 29.9794406890869, 0.523239947930924, -93.8824996948242, -1.63855872967725, 218, 51, 'PPL', 'P'),
(188091, 'Atrisco', 35.0811080932617, 0.612280841475447, -106.686943054199, -1.86203842518347, 218, 38, 'PPL', 'P'),
(70472, 'Atsion', 39.7425003051758, 0.693637483300169, -74.7263870239258, -1.30422149168707, 218, 37, 'PPL', 'P'),
(39165, 'Attakapas Canal', 29.8916702270508, 0.521708064382397, -91.0911102294922, -1.58983979280173, 218, 22, 'PPL', 'P'),
(39166, 'Attakapas Landing', 29.850830078125, 0.520995269316637, -91.1030578613281, -1.59004831831508, 218, 22, 'PPL', 'P'),
(58507, 'Attalaville (historical)', 33.0097198486328, 0.576128296519567, -89.7888870239258, -1.56711171026872, 218, 30, 'PPL', 'P'),
(206726, 'Attalia', 46.1080589294434, 0.804737440022358, -118.918891906738, -2.07552620659582, 218, 56, 'PPL', 'P'),
(112857, 'Attalla', 34.021671295166, 0.593790181131891, -86.0886077880859, -1.50252965436013, 218, 2, 'PPL', 'P'),
(15050, 'Attapulgas (historical)', 30.6166706085205, 0.534361708117259, -84.5666732788086, -1.47596688617352, 218, 12, 'PPL', 'P'),
(18957, 'Attapulgus', 30.7488899230957, 0.536669370491326, -84.48388671875, -1.4745219881241, 218, 13, 'PPL', 'P'),
(177453, 'Attawan Beach', 41.3030586242676, 0.720874364137709, -72.2072219848633, -1.2602537673543, 218, 8, 'PPL', 'P'),
(177452, 'Attawaugan', 41.8672218322754, 0.730720869636059, -71.8816680908203, -1.25457178001056, 218, 8, 'PPL', 'P'),
(79608, 'Attaway', 32.4674987792969, 0.56666475358597, -80.6302795410156, -1.40726385479415, 218, 48, 'PPL', 'P'),
(126789, 'Attean (historical)', 45.5747184753418, 0.795428893064205, -70.3186111450195, -1.22729128991017, 218, 26, 'PPL', 'P'),
(126790, 'Attean Landing', 45.5875015258789, 0.795651999384526, -70.2780609130859, -1.22658355485048, 218, 26, 'PPL', 'P'),
(118676, 'Atterberry', 40.0608291625977, 0.699193369966292, -89.9236068725586, -1.56946301519515, 218, 18, 'PPL', 'P'),
(34615, 'Atterson', 37.3383293151855, 0.651676783743907, -85.0780563354492, -1.48489220425081, 218, 21, 'PPL', 'P'),
(7188, 'Attica', 36.350830078125, 0.634441670696269, -90.9952774047852, -1.5881671944791, 218, 4, 'PPL', 'P'),
(18959, 'Attica', 34.0186080932617, 0.593736718173007, -83.491943359375, -1.45720931050971, 218, 13, 'PPL', 'P'),
(31697, 'Attica', 37.2413902282715, 0.64998487750338, -98.2263870239258, -1.71437386590574, 218, 20, 'PPL', 'P'),
(114460, 'Attica', 41.2297210693359, 0.719594382338789, -93.0158309936523, -1.62343250731782, 218, 16, 'PPL', 'P'),
(122168, 'Attica', 40.2941703796387, 0.703265942484268, -87.248893737793, -1.52278046444715, 218, 19, 'PPL', 'P'),
(129590, 'Attica', 43.0302810668945, 0.751020082675888, -83.1661071777344, -1.45152239631795, 218, 27, 'PPL', 'P'),
(146906, 'Attica', 42.8641700744629, 0.7481208989342, -78.2805633544922, -1.36625357085191, 218, 40, 'PPL', 'P'),
(154115, 'Attica', 41.0647201538086, 0.716714573094032, -82.8877792358398, -1.44666465733159, 218, 41, 'PPL', 'P'),
(172999, 'Attica', 42.7700004577637, 0.746477329067458, -89.4805603027344, -1.56173039381205, 218, 57, 'PPL', 'P'),
(146907, 'Attica Center', 42.815559387207, 0.747272482389928, -78.2347183227539, -1.36545342410239, 218, 40, 'PPL', 'P'),
(154116, 'Attica Junction', 41.0869407653809, 0.717102395927775, -82.8772201538086, -1.44648036658416, 218, 41, 'PPL', 'P'),
(26414, 'Attila', 37.769718170166, 0.659205939619725, -88.771110534668, -1.54934815948178, 218, 18, 'PPL', 'P'),
(34616, 'Attilla', 37.5033302307129, 0.654556592988665, -85.5063934326172, -1.49236809690483, 218, 21, 'PPL', 'P'),
(124147, 'Attleboro', 41.9444389343262, 0.732068562305693, -71.2861099243164, -1.24417732911793, 218, 23, 'PPL', 'P'),
(124148, 'Attleboro Falls', 41.9708290100098, 0.732529156016222, -71.3166732788086, -1.24471076028427, 218, 23, 'PPL', 'P'),
(124150, 'Attleborough City', 41.9249992370605, 0.731729275582817, -71.3499984741211, -1.24529239466634, 218, 23, 'PPL', 'P'),
(146909, 'Attlebury', 41.9172210693359, 0.73159352094625, -73.6688919067383, -1.28576472006839, 218, 40, 'PPL', 'P'),
(99548, 'Attoway', 36.8133316040039, 0.642513845118354, -81.4674987792969, -1.42187608706319, 218, 53, 'PPL', 'P'),
(92368, 'Attoyac', 31.5586109161377, 0.550801667842427, -94.357780456543, -1.64685394384063, 218, 51, 'PPL', 'P'),
(2, 'Attu', 52.9375, 0.923933672774498, 173.237503051758, 3.0235648161869, 218, 1, 'PPL', 'P'),
(18960, 'Atwater', 32.9683303833008, 0.575405914073883, -84.3694381713867, -1.47252448414848, 218, 13, 'PPL', 'P'),
(26415, 'Atwater', 39.3327789306641, 0.686486496299142, -89.7249984741211, -1.5659966447203, 218, 18, 'PPL', 'P'),
(134025, 'Atwater', 45.1388893127441, 0.787822239200666, -94.7777786254883, -1.65418429474108, 218, 28, 'PPL', 'P'),
(154117, 'Atwater', 41.0238914489746, 0.716001977765354, -81.1636123657227, -1.41657226859424, 218, 41, 'PPL', 'P'),
(173000, 'Atwater', 43.5608291625977, 0.760279893786093, -88.7344436645508, -1.54870820187183, 218, 57, 'PPL', 'P'),
(179860, 'Atwater', 37.3477783203125, 0.651841699994411, -120.608062744141, -2.10500779933716, 218, 6, 'PPL', 'P'),
(154118, 'Atwater Center', 41.023609161377, 0.715997050917338, -81.148063659668, -1.41630089247917, 218, 41, 'PPL', 'P'),
(146910, 'Atwaters', 42.6308288574219, 0.744048326416224, -76.6500015258789, -1.33779489828526, 218, 40, 'PPL', 'P'),
(58508, 'Atway', 34.8658294677734, 0.608523520651509, -89.4127807617188, -1.56054741765584, 218, 30, 'PPL', 'P'),
(18961, 'Atwell', 33.1405601501465, 0.578411890575283, -82.2863922119141, -1.43616847368532, 218, 13, 'PPL', 'P'),
(53274, 'Atwell', 38.038330078125, 0.663894101823673, -92.2125015258789, -1.60941176312688, 218, 29, 'PPL', 'P'),
(92369, 'Atwell', 32.2611083984375, 0.563062561895529, -99.1338882446289, -1.73021275017288, 218, 51, 'PPL', 'P'),
(108044, 'Atwell', 37.3491706848145, 0.651866001339357, -81.7627792358398, -1.42702970324666, 218, 58, 'PPL', 'P'),
(146911, 'Atwell', 43.5238914489746, 0.759635209065213, -74.9447174072266, -1.30803207573281, 218, 40, 'PPL', 'P'),
(146912, 'Atwell Corners', 42.9247207641602, 0.749177707833771, -75.9066696166992, -1.32482130903494, 218, 40, 'PPL', 'P'),
(158816, 'Atwells Crossing', 41.1049995422363, 0.717417581042786, -79.9205627441406, -1.39487695993197, 218, 45, 'PPL', 'P'),
(7189, 'Atwood', 34.098331451416, 0.595128153263546, -94.0725021362305, -1.64187489786662, 218, 4, 'PPL', 'P'),
(26416, 'Atwood', 39.7994384765625, 0.694631241860932, -88.4622192382813, -1.54395698932908, 218, 18, 'PPL', 'P'),
(34617, 'Atwood', 38.8722190856934, 0.678448210601929, -84.538330078125, -1.47547220400104, 218, 21, 'PPL', 'P'),
(62621, 'Atwood', 36.0497207641602, 0.629186321759161, -80.3266677856445, -1.40196483001516, 218, 33, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(75030, 'Atwood', 34.9561080932617, 0.610099179910454, -96.3383331298828, -1.68142110899959, 218, 42, 'PPL', 'P'),
(84748, 'Atwood', 35.9730606079102, 0.627848349627505, -88.6780624389648, -1.54772416384905, 218, 50, 'PPL', 'P'),
(108045, 'Atwood', 39.5113906860352, 0.689603859513135, -80.7425003051758, -1.40922247661784, 218, 58, 'PPL', 'P'),
(112858, 'Atwood', 34.3605613708496, 0.599704928754902, -87.995002746582, -1.53580252322931, 218, 2, 'PPL', 'P'),
(114461, 'Atwood', 41.3250007629395, 0.721257326702462, -92.4058303833008, -1.61278598822801, 218, 16, 'PPL', 'P'),
(122169, 'Atwood', 41.2608299255371, 0.720137334306029, -85.9752807617188, -1.50055172461853, 218, 19, 'PPL', 'P'),
(129592, 'Atwood', 45.1791687011719, 0.788525247149419, -85.3452835083008, -1.48955619826787, 218, 27, 'PPL', 'P'),
(134027, 'Atwood', 44.8630599975586, 0.783008109477157, -93.3636093139648, -1.62950238407433, 218, 28, 'PPL', 'P'),
(146913, 'Atwood', 41.8927803039551, 0.731166949118647, -74.1602783203125, -1.29434103088482, 218, 40, 'PPL', 'P'),
(158817, 'Atwood', 40.7547187805176, 0.7113040284444, -79.2666702270508, -1.3834643825546, 218, 45, 'PPL', 'P'),
(173001, 'Atwood', 44.8861083984375, 0.783410379959813, -90.4816665649414, -1.5792029942499, 218, 57, 'PPL', 'P'),
(179862, 'Atwood', 33.8655586242676, 0.59106550102063, -117.830001831055, -2.05652148958285, 218, 6, 'PPL', 'P'),
(187584, 'Atwood', 39.8066711425781, 0.694757475696601, -101.04167175293, -1.76350985380797, 218, 20, 'PPL', 'P'),
(194093, 'Atwood', 40.547779083252, 0.707692249374035, -103.269172668457, -1.80238707887511, 218, 7, 'PPL', 'P'),
(202932, 'Atwood', 40.6327781677246, 0.709175763259263, -111.897499084473, -1.95297978377139, 218, 52, 'PPL', 'P'),
(206727, 'Atwood', 47.1005592346191, 0.822059838174724, -119.123062133789, -2.0790896492924, 218, 56, 'PPL', 'P'),
(99549, 'Atwood (historical)', 36.6399993896484, 0.639488627278078, -80.2119369506836, -1.39996239919153, 218, 53, 'PPL', 'P'),
(154120, 'Atwood (historical)', 40.5525016784668, 0.707774674209772, -81.2425003051758, -1.41794912287782, 218, 41, 'PPL', 'P'),
(189897, 'Atwood (historical)', 38.7480583190918, 0.676281196422932, -117.855278015137, -2.05696264221742, 218, 39, 'PPL', 'P'),
(62622, 'Atwood Acres', 36.0491714477539, 0.629176734379237, -80.3055572509766, -1.40159638167835, 218, 33, 'PPL', 'P'),
(154121, 'Atwood Cove', 40.5466690063477, 0.707672874877104, -81.2441711425781, -1.41797828449175, 218, 41, 'PPL', 'P'),
(154122, 'Atwood Crossing', 40.5486106872559, 0.707706763601975, -81.2372207641602, -1.4178569775041, 218, 41, 'PPL', 'P'),
(154123, 'Atwood Pines', 40.5530586242676, 0.707784394747751, -81.2302780151367, -1.4177358036745, 218, 41, 'PPL', 'P'),
(154124, 'Atwood Valley', 40.5550003051758, 0.707818283472623, -81.2163925170898, -1.4174934560153, 218, 41, 'PPL', 'P'),
(154125, 'Atwood Village', 40.535831451416, 0.707483723860681, -81.2486114501953, -1.41805578247947, 218, 41, 'PPL', 'P'),
(177454, 'Atwoodville', 41.7847213745117, 0.72928096501368, -72.1750030517578, -1.25969144089013, 218, 8, 'PPL', 'P'),
(129593, 'Au Gres', 44.0486106872559, 0.768793287421777, -83.6958312988281, -1.46076782635827, 218, 27, 'PPL', 'P'),
(129596, 'Au Sable', 44.410831451416, 0.775115232375462, -83.3322219848633, -1.45442164663867, 218, 27, 'PPL', 'P'),
(146914, 'Au Sable Forks', 44.4416694641113, 0.775653457231767, -73.6750030517578, -1.28587137967004, 218, 40, 'PPL', 'P'),
(129600, 'Au Sable River Park', 44.4033317565918, 0.774984338007884, -84.4602813720703, -1.47410999710346, 218, 27, 'PPL', 'P'),
(129599, 'Au Train', 46.4302787780762, 0.810361237296279, -86.836669921875, -1.51558580160425, 218, 27, 'PPL', 'P'),
(179863, 'Auberry', 37.0808296203613, 0.647182566246344, -119.484443664551, -2.08539694686009, 218, 6, 'PPL', 'P'),
(39167, 'Aubin', 30.4191703796387, 0.530914678849828, -91.0630569458008, -1.58935017063532, 218, 22, 'PPL', 'P'),
(7206, 'Aubrey', 34.7166709899902, 0.605920214106929, -90.9002838134766, -1.58650924354247, 218, 4, 'PPL', 'P'),
(18963, 'Aubrey', 33.1988906860352, 0.579429950480993, -85.1361083984375, -1.48590540388753, 218, 13, 'PPL', 'P'),
(39168, 'Aubrey', 31.9319400787354, 0.557317490923469, -91.320556640625, -1.59384438813288, 218, 22, 'PPL', 'P'),
(58509, 'Aubrey', 33.1474990844727, 0.578532997825854, -88.3322219848633, -1.54168810923839, 218, 30, 'PPL', 'P'),
(92370, 'Aubrey', 33.3041687011719, 0.581267398475093, -96.9858322143555, -1.69272209992729, 218, 51, 'PPL', 'P'),
(112859, 'Aubrey', 32.6669387817383, 0.570145638288758, -85.4524993896484, -1.49142746840781, 218, 2, 'PPL', 'P'),
(173002, 'Aubrey', 43.3147201538086, 0.755984481263905, -90.293327331543, -1.57591585451641, 218, 57, 'PPL', 'P'),
(195905, 'Aubrey Crossing', 48.3377799987793, 0.843653414083359, -112.410278320313, -1.96192946977265, 218, 31, 'PPL', 'P'),
(112860, 'Aubrey Isle', 34.1527786254883, 0.596078435719514, -85.7750015258789, -1.49705619252975, 218, 2, 'PPL', 'P'),
(31699, 'Aubry', 38.7708282470703, 0.676678606636599, -94.6708297729492, -1.65231768513304, 218, 20, 'PPL', 'P'),
(13306, 'Auburn', 39.8083305358887, 0.694786437573456, -75.6888885498047, -1.32102031236913, 218, 10, 'PPL', 'P'),
(15051, 'Auburn', 30.8199996948242, 0.53791047013833, -86.5377807617188, -1.510369201661, 218, 12, 'PPL', 'P'),
(18964, 'Auburn', 34.0136108398438, 0.593649499647307, -83.8277816772461, -1.46307079491092, 218, 13, 'PPL', 'P'),
(26417, 'Auburn', 39.5916709899902, 0.691005015141653, -89.7463912963867, -1.56637001990513, 218, 18, 'PPL', 'P'),
(31701, 'Auburn', 38.9061088562012, 0.679039698680036, -95.8158264160156, -1.67230164647883, 218, 20, 'PPL', 'P'),
(34618, 'Auburn', 36.8641700744629, 0.643401143814541, -86.7102813720703, -1.51337990527333, 218, 21, 'PPL', 'P'),
(44500, 'Auburn', 38.6822204589844, 0.675132108991589, -77.023063659668, -1.3443060608344, 218, 25, 'PPL', 'P'),
(53275, 'Auburn', 39.1266708374023, 0.682889231456718, -90.9738922119141, -1.58779395245233, 218, 29, 'PPL', 'P'),
(58511, 'Auburn', 31.3591709136963, 0.547320783139639, -90.607780456543, -1.58140409689085, 218, 30, 'PPL', 'P'),
(62624, 'Auburn', 35.6930618286133, 0.62296144902721, -78.5555572509766, -1.37105311976845, 218, 33, 'PPL', 'P'),
(70473, 'Auburn', 39.7108306884766, 0.693084744215923, -75.3680572509766, -1.31542074986113, 218, 37, 'PPL', 'P'),
(71713, 'Auburn', 39.3911094665527, 0.687504556204852, -84.7022171020508, -1.47833257216984, 218, 41, 'PPL', 'P'),
(79609, 'Auburn', 34.3752784729004, 0.59996179064204, -79.9761123657227, -1.39584648372681, 218, 48, 'PPL', 'P'),
(92371, 'Auburn', 32.2972183227539, 0.563692798967496, -97.0769424438477, -1.69431227341417, 218, 51, 'PPL', 'P'),
(99553, 'Auburn', 38.7027816772461, 0.675490969948478, -77.7011108398438, -1.35614021661233, 218, 53, 'PPL', 'P'),
(108046, 'Auburn', 39.0955581665039, 0.682346212910451, -80.8563919067383, -1.41121026005548, 218, 58, 'PPL', 'P'),
(112861, 'Auburn', 32.6097183227539, 0.569146952879979, -85.480827331543, -1.49192188426418, 218, 2, 'PPL', 'P'),
(114462, 'Auburn', 42.2513885498047, 0.737425843733524, -94.8775024414063, -1.6559248036715, 218, 16, 'PPL', 'P'),
(122171, 'Auburn', 41.3669395446777, 0.72198929652807, -85.0588912963867, -1.4845577112179, 218, 19, 'PPL', 'P'),
(124151, 'Auburn', 42.1944389343262, 0.736431885435679, -71.8361129760742, -1.25377669326712, 218, 23, 'PPL', 'P'),
(126791, 'Auburn', 44.0977783203125, 0.769651424504028, -70.2316665649414, -1.22577382072104, 218, 26, 'PPL', 'P'),
(129602, 'Auburn', 43.603328704834, 0.761021650728708, -84.0697174072266, -1.46729336997729, 218, 27, 'PPL', 'P'),
(139623, 'Auburn', 48.5069389343262, 0.846605794467821, -97.4394378662109, -1.70063901205782, 218, 34, 'PPL', 'P'),
(141214, 'Auburn', 40.3927803039551, 0.704987010338732, -95.8386077880859, -1.67269925642958, 218, 35, 'PPL', 'P'),
(143482, 'Auburn', 43.0044403076172, 0.750569076345283, -71.3488922119141, -1.24527308674844, 218, 36, 'PPL', 'P'),
(146916, 'Auburn', 42.9316711425781, 0.749299014821424, -76.5663909912109, -1.33633561916596, 218, 40, 'PPL', 'P'),
(158819, 'Auburn', 40.598331451416, 0.708574554643178, -76.0936126708984, -1.32808408084445, 218, 45, 'PPL', 'P'),
(169266, 'Auburn', 41.7738914489746, 0.729091947155312, -71.4283294677734, -1.24665952841194, 218, 47, 'PPL', 'P'),
(179864, 'Auburn', 38.896671295166, 0.678874982166614, -121.075828552246, -2.11317185281685, 218, 6, 'PPL', 'P'),
(194094, 'Auburn', 40.3680610656738, 0.704555578242139, -104.636108398438, -1.82624460802643, 218, 7, 'PPL', 'P'),
(206728, 'Auburn', 47.3074989318848, 0.82567161724509, -122.22721862793, -2.13326740061232, 218, 56, 'PPL', 'P'),
(209283, 'Auburn', 42.7922210693359, 0.746865151901201, -111.002502441406, -1.93735914555558, 218, 59, 'PPL', 'P'),
(7190, 'Auburn (historical)', 35.2544403076172, 0.615306059315722, -94.1297225952148, -1.6428735832754, 218, 4, 'PPL', 'P'),
(200348, 'Auburn (historical)', 44.6994400024414, 0.780152401840265, -117.94416809082, -2.05851406671045, 218, 43, 'PPL', 'P'),
(154127, 'Auburn Center', 41.3872184753418, 0.722343230636942, -81.2463912963867, -1.41801703348561, 218, 41, 'PPL', 'P'),
(158820, 'Auburn Center', 41.6897201538086, 0.727622880918997, -76.0369415283203, -1.3270949828156, 218, 45, 'PPL', 'P'),
(99550, 'Auburn Chase', 37.6402816772461, 0.656946846646038, -77.7286071777344, -1.35662011824076, 218, 53, 'PPL', 'P'),
(154128, 'Auburn Corners', 41.3872184753418, 0.722343230636942, -81.2163925170898, -1.4174934560153, 218, 41, 'PPL', 'P'),
(158821, 'Auburn Four Corners', 41.7200012207031, 0.728151385237323, -75.9805603027344, -1.32611094479281, 218, 45, 'PPL', 'P'),
(129603, 'Auburn Heights', 42.6336097717285, 0.744096862527091, -83.2227783203125, -1.45251149434681, 218, 27, 'PPL', 'P'),
(202935, 'Auburn Heights', 40.6111106872559, 0.708797594384472, -111.823059082031, -1.95168056063359, 218, 52, 'PPL', 'P'),
(13307, 'Auburn Hills', 39.8041687011719, 0.694713799854724, -75.6930618286133, -1.32109314982494, 218, 10, 'PPL', 'P'),
(129604, 'Auburn Hills', 42.6875, 0.745037424445079, -83.2341690063477, -1.45271029932218, 218, 27, 'PPL', 'P'),
(179865, 'Auburn Hills Mobile Estates', 38.9261093139648, 0.679388772519918, -121.087219238281, -2.11337065779223, 218, 6, 'PPL', 'P'),
(122172, 'Auburn Junction', 41.3519401550293, 0.721727507792916, -85.0747222900391, -1.48483401418099, 218, 19, 'PPL', 'P'),
(179866, 'Auburn Lake Trails', 38.9144401550293, 0.679185107275554, -120.951393127441, -2.11100004494789, 218, 6, 'PPL', 'P'),
(126792, 'Auburn Plains', 44.1758308410645, 0.771013697980631, -70.2322235107422, -1.22578354125902, 218, 26, 'PPL', 'P'),
(15052, 'Auburndale', 28.0650005340576, 0.489826663893272, -81.7888870239258, -1.42748537010917, 218, 12, 'PPL', 'P'),
(34619, 'Auburndale', 38.1427803039551, 0.66571710216886, -85.7744369506836, -1.49704633883371, 218, 21, 'PPL', 'P'),
(124153, 'Auburndale', 42.3472213745117, 0.739098442056148, -71.25, -1.24354709204596, 218, 23, 'PPL', 'P'),
(154132, 'Auburndale', 41.6872215270996, 0.727579271656147, -83.5941696166992, -1.45899349528201, 218, 41, 'PPL', 'P'),
(173005, 'Auburndale', 44.6269416809082, 0.778887067427341, -90.0074996948242, -1.57092722116247, 218, 57, 'PPL', 'P'),
(84749, 'Auburntown', 35.9474983215332, 0.62740220356589, -86.0972213745117, -1.50267998980367, 218, 50, 'PPL', 'P'),
(124154, 'Auburnville', 42.0694389343262, 0.734250223870686, -70.9638900756836, -1.23855353184401, 218, 23, 'PPL', 'P'),
(112862, 'Aucheucaula (historical)', 33.0208282470703, 0.576322174646925, -86.5111083984375, -1.50990368110245, 218, 2, 'PPL', 'P'),
(158824, 'Aucheys', 40.5750007629395, 0.708167357312505, -76.1666717529297, -1.32935920237438, 218, 45, 'PPL', 'P'),
(15053, 'Aucilla', 30.4797191619873, 0.531971454459885, -83.7544403076172, -1.46179074653297, 218, 12, 'PPL', 'P'),
(15054, 'Aucilla (historical)', 30.4166698455811, 0.530871036297465, -83.7666702270508, -1.46200419889434, 218, 12, 'PPL', 'P'),
(18965, 'Aucilla (historical)', 30.6652793884277, 0.535210091372017, -83.8013916015625, -1.46261020120039, 218, 13, 'PPL', 'P'),
(192887, 'Auckland', 36.5880584716797, 0.638582087243015, -119.105827331543, -2.07878884524728, 218, 6, 'PPL', 'P'),
(53276, 'Aud', 38.5802803039551, 0.673352917646335, -91.7205581665039, -1.60082573177247, 218, 29, 'PPL', 'P'),
(92372, 'Audelia', 32.9091682434082, 0.574373339940232, -96.7169418334961, -1.68802907745435, 218, 51, 'PPL', 'P'),
(158825, 'Audenried', 40.9105606079102, 0.714023981444725, -75.991943359375, -1.32630961661013, 218, 45, 'PPL', 'P'),
(193062, 'Audley', 35.401668548584, 0.617875676872513, -113.038330078125, -1.97289104081942, 218, 5, 'PPL', 'P'),
(158826, 'Audobon Gardens', 40.1283302307129, 0.700371485853516, -75.4366683959961, -1.31661824024528, 218, 45, 'PPL', 'P'),
(108047, 'Audra', 39.0419387817383, 0.681410378103397, -80.0669403076172, -1.39743173036568, 218, 58, 'PPL', 'P'),
(206729, 'Audrey', 46.627498626709, 0.813803373005206, -119.614166259766, -2.08766103326082, 218, 56, 'PPL', 'P'),
(200349, 'Audrey (historical)', 44.5688896179199, 0.77787386779062, -118.218063354492, -2.06329444086714, 218, 43, 'PPL', 'P'),
(39169, 'Audrey Park', 32.5544395446777, 0.56818215619607, -93.8288879394531, -1.63762302802825, 218, 22, 'PPL', 'P'),
(15055, 'Audubon', 28.436939239502, 0.496318218918881, -80.6600036621094, -1.40778263857449, 218, 12, 'PPL', 'P'),
(18966, 'Audubon', 34.5661087036133, 0.603292406480321, -84.8191680908203, -1.48037375198733, 218, 13, 'PPL', 'P'),
(39170, 'Audubon', 30.4088897705078, 0.530735248371384, -89.7838897705078, -1.56702449174302, 218, 22, 'PPL', 'P'),
(70474, 'Audubon', 39.8908309936523, 0.696226342195835, -75.0733337402344, -1.31027685421564, 218, 37, 'PPL', 'P'),
(114464, 'Audubon', 41.7180595397949, 0.728117496512452, -94.9322204589844, -1.6568798132384, 218, 16, 'PPL', 'P'),
(134028, 'Audubon', 46.8633308410645, 0.817919421627978, -95.9813919067383, -1.67519130941962, 218, 28, 'PPL', 'P'),
(158827, 'Audubon', 40.1277809143066, 0.700361898473591, -75.4322204589844, -1.31654060909951, 218, 45, 'PPL', 'P'),
(18969, 'Audubon Forest', 33.7158317565918, 0.58845227420099, -84.7763900756836, -1.47962713477572, 218, 13, 'PPL', 'P'),
(79610, 'Audubon Homes', 33.5200004577637, 0.585034373257983, -81.9347229003906, -1.43003068632101, 218, 48, 'PPL', 'P'),
(34620, 'Audubon Park', 38.2038917541504, 0.666783698185436, -85.7252807617188, -1.49618840148854, 218, 21, 'PPL', 'P'),
(39171, 'Audubon Park', 32.5869407653809, 0.568749409508257, -91.9813919067383, -1.60537813933985, 218, 22, 'PPL', 'P'),
(70475, 'Audubon Park', 39.8963890075684, 0.696323347838541, -75.0880584716797, -1.31053384926083, 218, 37, 'PPL', 'P'),
(79611, 'Audubon Park', 33.9269409179688, 0.592136824148142, -80.3838882446289, -1.40296351542394, 218, 48, 'PPL', 'P'),
(154133, 'Augerburg', 41.1630592346191, 0.718430913837561, -81.1675033569336, -1.41664017920204, 218, 41, 'PPL', 'P'),
(118681, 'Augerville', 40.139720916748, 0.70057029082889, -88.1716690063477, -1.5388859311394, 218, 18, 'PPL', 'P'),
(177455, 'Augerville', 41.371940612793, 0.722076581632798, -72.9063873291016, -1.2724565046271, 218, 8, 'PPL', 'P'),
(158829, 'Aughwick', 40.336669921875, 0.704007699426883, -77.8605575561523, -1.35892308679341, 218, 45, 'PPL', 'P'),
(7192, 'Augsburg', 35.4144401550293, 0.618098583455752, -93.2380599975586, -1.62731113512941, 218, 4, 'PPL', 'P'),
(26422, 'Augsburg', 38.8666687011719, 0.678351338117277, -89.0133285522461, -1.55357566139617, 218, 18, 'PPL', 'P'),
(179867, 'August', 37.978889465332, 0.662856667421033, -121.261108398438, -2.11640559617048, 218, 6, 'PPL', 'P'),
(7193, 'Augusta', 35.2822189331055, 0.615790887792171, -91.3652801513672, -1.59462496064838, 218, 4, 'PPL', 'P'),
(18970, 'Augusta', 33.4708290100098, 0.584176169596704, -81.9749984741211, -1.43073362769074, 218, 13, 'PPL', 'P'),
(29129, 'Augusta', 38.3313903808594, 0.669008969013279, -87.1908264160156, -1.52176699849432, 218, 19, 'PPL', 'P'),
(31703, 'Augusta', 37.6866683959961, 0.657756447617422, -96.9763870239258, -1.69255725025581, 218, 20, 'PPL', 'P'),
(34625, 'Augusta', 38.771671295166, 0.676693320601621, -84.0058288574219, -1.46617830442888, 218, 21, 'PPL', 'P'),
(39177, 'Augusta', 30.1897201538086, 0.526910016939649, -91.2152786254883, -1.59200694013878, 218, 22, 'PPL', 'P'),
(44501, 'Augusta', 39.3677787780762, 0.687097358874179, -77.6750030517578, -1.35568454974982, 218, 25, 'PPL', 'P'),
(53280, 'Augusta', 38.5724983215332, 0.673217096430741, -90.8819427490234, -1.58618913157945, 218, 29, 'PPL', 'P'),
(92373, 'Augusta', 31.5313892364502, 0.550326559903957, -95.3305587768555, -1.66383212842211, 218, 51, 'PPL', 'P'),
(108048, 'Augusta', 39.295280456543, 0.685832024461255, -78.6380615234375, -1.37249309096985, 218, 58, 'PPL', 'P'),
(113122, 'Augusta', 44.8050003051758, 0.781994776682381, -93.6877822875977, -1.6351602698102, 218, 28, 'PPL', 'P'),
(114467, 'Augusta', 40.7580604553223, 0.711362351672273, -91.2755584716797, -1.59305902192741, 218, 16, 'PPL', 'P'),
(118682, 'Augusta', 40.2299995422363, 0.702145950087836, -90.9499969482422, -1.58737690142562, 218, 18, 'PPL', 'P'),
(126795, 'Augusta', 44.3105583190918, 0.773365136065116, -69.7799987792969, -1.21789073073635, 218, 26, 'PPL', 'P'),
(129607, 'Augusta', 42.3363914489746, 0.73890942419778, -85.3522186279297, -1.48967723893941, 218, 27, 'PPL', 'P'),
(144774, 'Augusta', 41.1288909912109, 0.717834565490465, -74.7286071777344, -1.30426024068093, 218, 37, 'PPL', 'P'),
(146918, 'Augusta', 42.9747200012207, 0.750050359143963, -75.5016708374023, -1.31775274686966, 218, 40, 'PPL', 'P'),
(154137, 'Augusta', 40.6858291625977, 0.710101677791256, -81.021110534668, -1.41408514245222, 218, 41, 'PPL', 'P'),
(173008, 'Augusta', 44.6802787780762, 0.779817975386378, -91.1197204589844, -1.59033913550612, 218, 57, 'PPL', 'P'),
(195906, 'Augusta', 47.4927787780762, 0.828905360598719, -112.391387939453, -1.9615997704297, 218, 31, 'PPL', 'P'),
(44502, 'Augusta Acres', 39.1269416809082, 0.682893958567653, -76.6155624389648, -1.33719382282723, 218, 25, 'PPL', 'P'),
(79612, 'Augusta Acres', 34.7811088562012, 0.607044867035269, -82.3630599975586, -1.43750657897503, 218, 48, 'PPL', 'P'),
(79613, 'Augusta Fields', 34.1430587768555, 0.595908792358076, -82.1377792358398, -1.43357468794164, 218, 48, 'PPL', 'P'),
(99552, 'Augusta Springs', 38.1019401550293, 0.6650043071031, -79.3183288574219, -1.38436599574164, 218, 53, 'PPL', 'P'),
(79614, 'Augusta View Heights', 33.5066719055176, 0.584801746136764, -81.9199981689453, -1.42977369127582, 218, 48, 'PPL', 'P'),
(158830, 'Augustaville', 40.8072204589844, 0.712220355596469, -76.7416687011719, -1.33939479231013, 218, 45, 'PPL', 'P'),
(112865, 'Augustin', 32.5061111450195, 0.567338666499815, -87.107780456543, -1.52031757307104, 218, 2, 'PPL', 'P'),
(13308, 'Augustine', 39.7638893127441, 0.69401079190597, -75.5541687011719, -1.3186690074427, 218, 10, 'PPL', 'P'),
(188092, 'Augustine', 34.936939239502, 0.609764620298513, -106.19361114502, -1.85342815906314, 218, 38, 'PPL', 'P'),
(188093, 'Augustine (historical)', 34.1133308410645, 0.595389941998701, -107.669441223145, -1.87918625312638, 218, 38, 'PPL', 'P'),
(13312, 'Augustine Hills', 39.7636108398438, 0.694005931636981, -75.5508270263672, -1.31861068421482, 218, 10, 'PPL', 'P'),
(191095, 'Augustus', 33.1305618286133, 0.578237386944855, -101.299171447754, -1.76800407130554, 218, 51, 'PPL', 'P'),
(209935, 'Auke Bay', 58.3833312988281, 1.01898135944721, -134.659713745117, -2.35025537464536, 218, 1, 'PPL', 'P'),
(154139, 'Aukerman', 40.9597206115723, 0.714881985368921, -82.0250015258789, -1.43160634557996, 218, 41, 'PPL', 'P'),
(179868, 'Aukum', 38.5572204589844, 0.672950447426597, -120.725563049316, -2.10705856653458, 218, 6, 'PPL', 'P'),
(62625, 'Aulander', 36.2294387817383, 0.632322992891056, -77.1144409179688, -1.34590089485319, 218, 33, 'PPL', 'P'),
(179869, 'Auld (historical)', 33.586109161377, 0.586188187800259, -117.060562133789, -2.04309223347002, 218, 6, 'PPL', 'P'),
(62626, 'Auld Farm', 35.9711112976074, 0.627814327744579, -81.4308319091797, -1.42123612945325, 218, 33, 'PPL', 'P'),
(39179, 'Aulds (historical)', 32.3691711425781, 0.564948612579523, -93.7172164916992, -1.63567399358448, 218, 22, 'PPL', 'P'),
(53281, 'Aullville', 39.0177803039551, 0.68098873312381, -93.6777801513672, -1.63498569960075, 218, 29, 'PPL', 'P'),
(31706, 'Aulne', 38.2761116027832, 0.668044172329371, -97.0763931274414, -1.69430268603425, 218, 20, 'PPL', 'P'),
(84751, 'Aulon', 35.1375007629395, 0.613265079235313, -89.961669921875, -1.57012734072907, 218, 50, 'PPL', 'P'),
(34621, 'Ault', 38.1952781677246, 0.666633362741901, -83.2108306884766, -1.45230296883346, 218, 21, 'PPL', 'P'),
(194095, 'Ault', 40.5825004577637, 0.708298251680082, -104.731391906738, -1.82790761896913, 218, 7, 'PPL', 'P'),
(154140, 'Aultman', 40.9283294677734, 0.714334106553665, -81.4175033569336, -1.42100350233203, 218, 41, 'PPL', 'P'),
(158831, 'Aultman', 40.5638885498047, 0.70797341260612, -79.2611083984375, -1.38336731033286, 218, 45, 'PPL', 'P'),
(193104, 'Aultman', 34.6163902282715, 0.604169984638529, -111.913612365723, -1.9532610135825, 218, 5, 'PPL', 'P'),
(18971, 'Aultman Pines', 32.7344398498535, 0.571323754175982, -83.6916732788086, -1.46069525521857, 218, 13, 'PPL', 'P'),
(18972, 'Aultmans (historical)', 31.6847190856934, 0.553002670614836, -83.9263916015625, -1.46479186276538, 218, 13, 'PPL', 'P'),
(122173, 'Aultshire', 40.2119407653809, 0.701830764972825, -85.3461074829102, -1.48957057933775, 218, 19, 'PPL', 'P'),
(62627, 'Aumans Crossroads', 35.5586090087891, 0.620614804632686, -79.8394393920898, -1.39346109033843, 218, 33, 'PPL', 'P'),
(200352, 'Aumsville', 44.8411102294922, 0.782625013754349, -122.869720458984, -2.14448117301432, 218, 43, 'PPL', 'P'),
(84753, 'Aunt (historical)', 36.5152816772461, 0.637311892561102, -82.892219543457, -1.44674215531932, 218, 50, 'PPL', 'P'),
(70478, 'Aura', 39.672779083252, 0.692420618419084, -75.1377792358398, -1.31140164030203, 218, 37, 'PPL', 'P'),
(129609, 'Aura', 46.8627815246582, 0.817909834248054, -88.3186111450195, -1.54145055526915, 218, 27, 'PPL', 'P'),
(179870, 'Aurant', 34.0780601501465, 0.594774352312729, -118.163330078125, -2.06233916498413, 218, 6, 'PPL', 'P'),
(15056, 'Aurantia', 28.7277793884277, 0.501394337114627, -80.8877792358398, -1.41175807229171, 218, 12, 'PPL', 'P'),
(18989, 'Auraria', 34.4744415283203, 0.601692512455455, -84.0233306884766, -1.46648376900591, 218, 13, 'PPL', 'P'),
(134035, 'Aure', 47.6733283996582, 0.832056545958555, -95.1202774047852, -1.66016202612387, 218, 28, 'PPL', 'P'),
(114468, 'Aurelia', 42.7127799987793, 0.745478643658678, -95.436393737793, -1.66567929695419, 218, 16, 'PPL', 'P'),
(197956, 'Aurelia', 48.4666709899902, 0.845902986256149, -101.901672363281, -1.77851969602777, 218, 34, 'PPL', 'P'),
(62630, 'Aurelian Springs', 36.3641700744629, 0.634674497554569, -77.8072204589844, -1.35799217883437, 218, 33, 'PPL', 'P'),
(129610, 'Aurelius', 42.524169921875, 0.742186776814259, -84.522216796875, -1.47519097418992, 218, 27, 'PPL', 'P'),
(7195, 'Aurelle', 33.0480613708496, 0.576797482322476, -92.4055633544922, -1.6127813276961, 218, 4, 'PPL', 'P'),
(114469, 'Aureola', 42.9683303833008, 0.749938839273316, -92.8777770996094, -1.62102301232157, 218, 16, 'PPL', 'P'),
(146924, 'Auriesville', 42.9294395446777, 0.749260066090482, -74.3169403076172, -1.29707529837601, 218, 40, 'PPL', 'P'),
(112427, 'Auris (historical)', 33.2333297729492, 0.580031025939023, -89.695556640625, -1.56548278778797, 218, 30, 'PPL', 'P'),
(474, 'Aurora', 39.0569381713867, 0.681672166838552, -84.9013900756836, -1.48180879634072, 218, 19, 'PPL', 'P'),
(7196, 'Aurora', 35.9972190856934, 0.628269994607092, -93.7024993896484, -1.63541713169734, 218, 4, 'PPL', 'P'),
(15057, 'Aurora', 28.1355590820313, 0.491058142870839, -80.6849975585938, -1.40821886436105, 218, 12, 'PPL', 'P'),
(31707, 'Aurora', 39.4519386291504, 0.688566225373413, -97.5269393920898, -1.70216620178492, 218, 20, 'PPL', 'P'),
(34622, 'Aurora', 36.776668548584, 0.641873954087435, -88.144172668457, -1.53840602951097, 218, 21, 'PPL', 'P'),
(53283, 'Aurora', 36.9708290100098, 0.645262693416506, -93.7177810668945, -1.63568384728051, 218, 29, 'PPL', 'P'),
(62628, 'Aurora', 35.3052787780762, 0.61619335801191, -76.7888870239258, -1.34021890750945, 218, 33, 'PPL', 'P'),
(92374, 'Aurora', 33.0605583190918, 0.577015595215754, -97.503059387207, -1.70174941707433, 218, 51, 'PPL', 'P'),
(108050, 'Aurora', 39.3241691589355, 0.686336227434635, -79.5547180175781, -1.38849176490239, 218, 58, 'PPL', 'P'),
(112866, 'Aurora', 34.1166687011719, 0.595448198647547, -86.192497253418, -1.50434286758831, 218, 2, 'PPL', 'P'),
(114471, 'Aurora', 41.4958305358887, 0.72423886870086, -92.2394409179688, -1.60988194421734, 218, 16, 'PPL', 'P'),
(118684, 'Aurora', 41.7605590820313, 0.728859253455066, -88.3199996948242, -1.54147479003507, 218, 18, 'PPL', 'P'),
(126796, 'Aurora', 44.8541717529297, 0.78285298034366, -68.32861328125, -1.19255927507974, 218, 26, 'PPL', 'P'),
(129612, 'Aurora', 46.4488906860352, 0.810686076370241, -90.1458282470703, -1.57334150984869, 218, 27, 'PPL', 'P'),
(134036, 'Aurora', 47.5299987792969, 0.829554972167616, -92.2369384765625, -1.60983826837546, 218, 28, 'PPL', 'P'),
(141215, 'Aurora', 40.8672218322754, 0.713267577116115, -98.0038909912109, -1.71049057756224, 218, 35, 'PPL', 'P'),
(146921, 'Aurora', 42.7538909912109, 0.746196165835373, -76.7027816772461, -1.33871608570632, 218, 40, 'PPL', 'P'),
(154141, 'Aurora', 41.3175010681152, 0.721126432334885, -81.3455581665039, -1.41974782187805, 218, 41, 'PPL', 'P'),
(169767, 'Aurora', 44.2841682434082, 0.772904542354587, -96.6852798461914, -1.68747647152816, 218, 49, 'PPL', 'P'),
(173011, 'Aurora', 43.4275016784668, 0.757952890204609, -88.3016662597656, -1.5411548112301, 218, 57, 'PPL', 'P'),
(179871, 'Aurora', 37.6599998474121, 0.657290993637903, -121.001670837402, -2.11187755652708, 218, 6, 'PPL', 'P'),
(186370, 'Aurora', 39.7294387817383, 0.693409516710858, -104.831390380859, -1.82965292158951, 218, 7, 'PPL', 'P'),
(188094, 'Aurora', 35.146671295166, 0.613425135216827, -105.448608398438, -1.84042540819888, 218, 38, 'PPL', 'P'),
(192474, 'Aurora', 38.9222183227539, 0.679320861912121, -111.933326721191, -1.95360509399534, 218, 52, 'PPL', 'P'),
(200350, 'Aurora', 45.2311096191406, 0.789431787184482, -122.754722595215, -2.14247408165878, 218, 43, 'PPL', 'P'),
(212291, 'Aurora', 64.8569412231445, 1.13196716711631, -147.758605957031, -2.5788741721071, 218, 1, 'PPL', 'P'),
(189898, 'Aurora (historical)', 38.2872200012207, 0.668238050456729, -118.899719238281, -2.07519158040485, 218, 39, 'PPL', 'P'),
(169768, 'Aurora Center', 43.5269393920898, 0.759688405707987, -98.5894393920898, -1.72071032508736, 218, 49, 'PPL', 'P'),
(44503, 'Aurora Hills', 39.0872192382813, 0.682200671156878, -76.6477813720703, -1.3377561492914, 218, 25, 'PPL', 'P'),
(99554, 'Aurora Hills', 38.851390838623, 0.678084689113133, -77.0644378662109, -1.34502817696397, 218, 53, 'PPL', 'P'),
(212292, 'Aurora Lodge', 64.4705581665039, 1.12522351060401, -146.938613891602, -2.56456261072513, 218, 1, 'PPL', 'P'),
(92375, 'Aurora Longoria Colonia', 26.2129993438721, 0.457503145373681, -97.8259963989258, -1.70738573120537, 218, 51, 'PPL', 'P'),
(53284, 'Aurora Springs', 38.3247184753418, 0.668892522294616, -92.5849990844727, -1.61591307197998, 218, 29, 'PPL', 'P'),
(173015, 'Auroraville', 44.0519409179688, 0.768851410912568, -88.9925003051758, -1.55321213990738, 218, 57, 'PPL', 'P'),
(189903, 'Aurum (historical)', 39.7033309936523, 0.692953849848345, -114.583892822266, -1.99986619950083, 218, 39, 'PPL', 'P'),
(146923, 'Ausable Chasm', 44.5224990844727, 0.777064200240209, -73.4655609130859, -1.2822159247578, 218, 40, 'PPL', 'P'),
(62629, 'Ausbon (historical)', 35.8047218322754, 0.624910283733902, -76.7644424438477, -1.33979226910282, 218, 33, 'PPL', 'P'),
(18973, 'Ausmac', 30.9961109161377, 0.540984190799959, -84.6241683959961, -1.47697036527226, 218, 13, 'PPL', 'P'),
(18974, 'Austell', 33.8125, 0.590139453330583, -84.6344375610352, -1.47714959601362, 218, 13, 'PPL', 'P'),
(108049, 'Austen', 39.3880615234375, 0.687451359562078, -79.8011093139648, -1.3927921042726, 218, 58, 'PPL', 'P'),
(34623, 'Austerlitz', 38.0905609130859, 0.664805701864807, -84.2169418334961, -1.46986292095506, 218, 21, 'PPL', 'P'),
(146927, 'Austerlitz', 42.3116683959961, 0.73847792552216, -73.4736099243164, -1.2823564065053, 218, 40, 'PPL', 'P'),
(7199, 'Austin', 35.5305595397949, 0.620125249045303, -92.7905578613281, -1.61950074944248, 218, 4, 'PPL', 'P'),
(29130, 'Austin', 38.7583312988281, 0.676460493743321, -85.8080596923828, -1.49763316637991, 218, 19, 'PPL', 'P'),
(34624, 'Austin', 36.8252792358398, 0.642722370631707, -86.019172668457, -1.50131778290609, 218, 21, 'PPL', 'P'),
(53287, 'Austin', 36.160831451416, 0.631125569085929, -90.1591720581055, -1.57357440328601, 218, 29, 'PPL', 'P'),
(58513, 'Austin', 34.6405601501465, 0.604591829355197, -90.4491729736328, -1.57863587409576, 218, 30, 'PPL', 'P'),
(62631, 'Austin', 36.3236083984375, 0.633966562757799, -80.9772186279297, -1.41331908416466, 218, 33, 'PPL', 'P'),
(71728, 'Austin', 39.4366683959961, 0.688299709527323, -83.2225036621094, -1.45250670065685, 218, 41, 'PPL', 'P'),
(84754, 'Austin', 35.2016716003418, 0.614385071631746, -88.2391662597656, -1.5400639804476, 218, 50, 'PPL', 'P'),
(92376, 'Austin', 30.266939163208, 0.528257742898797, -97.7427825927734, -1.7059333763049, 218, 51, 'PPL', 'P'),
(118686, 'Austin', 41.8875007629395, 0.73107480374493, -87.7647171020508, -1.53178328051216, 218, 18, 'PPL', 'P'),
(129614, 'Austin', 46.2844390869141, 0.807815854505408, -87.4569396972656, -1.52641155143542, 218, 27, 'PPL', 'P'),
(134038, 'Austin', 43.6666717529297, 0.762127195476227, -92.9744415283203, -1.62271012487214, 218, 28, 'PPL', 'P'),
(146926, 'Austin', 42.8108291625977, 0.747189924396136, -76.4711074829102, -1.33467260822326, 218, 40, 'PPL', 'P'),
(158832, 'Austin', 41.6311111450195, 0.726599960744297, -78.091667175293, -1.36295671058044, 218, 45, 'PPL', 'P'),
(169267, 'Austin', 41.5905609130859, 0.725892225684609, -71.6555633544922, -1.25062550790728, 218, 47, 'PPL', 'P'),
(179873, 'Austin', 37.2425003051758, 0.65000425200031, -121.997222900391, -2.12925321790124, 218, 6, 'PPL', 'P'),
(186371, 'Austin', 38.7811088562012, 0.676858037115043, -107.95027923584, -1.88408780111267, 218, 7, 'PPL', 'P'),
(189902, 'Austin', 39.4933280944824, 0.689288607819097, -117.06861114502, -2.04323271521752, 218, 39, 'PPL', 'P'),
(192473, 'Austin', 38.6722183227539, 0.674957538782135, -112.120826721191, -1.95687758634283, 218, 52, 'PPL', 'P'),
(195907, 'Austin', 46.6391716003418, 0.814007104828597, -112.244438171387, -1.9590350131419, 218, 31, 'PPL', 'P'),
(200351, 'Austin', 44.6027793884277, 0.778465355868727, -118.495559692383, -2.06813766562556, 218, 43, 'PPL', 'P'),
(206731, 'Austin', 47.685001373291, 0.832260277781946, -117.163612365723, -2.0448907993122, 218, 56, 'PPL', 'P'),
(79615, 'Austin (historical)', 34.4777793884277, 0.601750769104301, -82.1638870239258, -1.43403035480415, 218, 48, 'PPL', 'P'),
(194542, 'Austin (historical)', 42.6563911437988, 0.74449447247784, -114.848327636719, -2.00448145766994, 218, 17, 'PPL', 'P'),
(79616, 'Austin Acres', 33.9097213745117, 0.591836286419127, -80.4241714477539, -1.40366658995172, 218, 48, 'PPL', 'P'),
(134039, 'Austin Acres', 43.6522216796875, 0.761874994120996, -93.001106262207, -1.62317551227263, 218, 28, 'PPL', 'P'),
(129615, 'Austin Center', 43.622501373291, 0.761356276919676, -82.9375, -1.4475324483728, 218, 27, 'PPL', 'P'),
(129616, 'Austin Corners', 42.7877807617188, 0.746787653913479, -83.508056640625, -1.45749054032082, 218, 27, 'PPL', 'P'),
(143484, 'Austin Corners', 42.9111099243164, 0.748940153864536, -70.9647216796875, -1.23856804607195, 218, 36, 'PPL', 'P'),
(92378, 'Austin Gardens Colonia', 26.3460006713867, 0.459824456448335, -98.197998046875, -1.71387838478493, 218, 51, 'PPL', 'P'),
(158833, 'Austin Heights', 41.3827781677246, 0.722265732649221, -75.7433319091797, -1.32197052824607, 218, 45, 'PPL', 'P'),
(134040, 'Austin Mobile Home Park', 43.6666717529297, 0.762127195476227, -92.9749984741211, -1.62271984541012, 218, 28, 'PPL', 'P'),
(84757, 'Austin Springs', 36.4916687011719, 0.636899768382412, -88.6344375610352, -1.5469627660934, 218, 50, 'PPL', 'P'),
(112864, 'Austin Subdivision', 33.209171295166, 0.579609380959437, -87.495002746582, -1.52707587696934, 218, 2, 'PPL', 'P'),
(154143, 'Austin Village', 41.2425003051758, 0.719817422080084, -80.8594436645508, -1.41126352327728, 218, 41, 'PPL', 'P'),
(154144, 'Austinburg', 41.7719383239746, 0.729057858693359, -80.8547210693359, -1.41118109844154, 218, 41, 'PPL', 'P'),
(158834, 'Austinburg', 41.9930610656738, 0.732917178587047, -77.495002746582, -1.35254295176991, 218, 45, 'PPL', 'P'),
(84759, 'Austins Mill', 36.3733291625977, 0.634834353799001, -83.0066680908203, -1.44873965929493, 218, 50, 'PPL', 'P'),
(154146, 'Austintown', 41.1016693115234, 0.717359457551995, -80.7647171020508, -1.40961023287256, 218, 41, 'PPL', 'P'),
(99555, 'Austinville', 36.8511085510254, 0.64317317722523, -80.9122161865234, -1.41218457754028, 218, 53, 'PPL', 'P'),
(112853, 'Austinville', 34.5747184753418, 0.603442675344828, -87.0086135864258, -1.5185867846786, 218, 2, 'PPL', 'P'),
(114472, 'Austinville', 42.5858306884766, 0.74326296021076, -92.9569396972656, -1.62240466029511, 218, 16, 'PPL', 'P'),
(158835, 'Austinville', 41.8388900756836, 0.730226387200658, -76.8741683959961, -1.3417073482427, 218, 45, 'PPL', 'P'),
(92379, 'Austonio', 31.1855602264404, 0.544290705030374, -95.6383285522461, -1.6692037243408, 218, 51, 'PPL', 'P'),
(84760, 'Austral', 35.2338905334473, 0.614947398095916, -84.545280456543, -1.47559351098869, 218, 50, 'PPL', 'P'),
(58514, 'Australia Landing', 34.065559387207, 0.594556172840425, -90.8777770996094, -1.58611642728169, 218, 30, 'PPL', 'P'),
(53289, 'Austria (historical)', 37.8494415283203, 0.660597374710264, -91.5547180175781, -1.59793127514171, 218, 29, 'PPL', 'P'),
(92380, 'Austwell', 28.3899993896484, 0.495498963988546, -96.8419418334961, -1.69021073901934, 218, 51, 'PPL', 'P'),
(112870, 'Autaugaville', 32.4338912963867, 0.56607819235588, -86.6547164916992, -1.51241011516238, 218, 2, 'PPL', 'P'),
(58515, 'Auter', 33.042781829834, 0.57670533694876, -90.710563659668, -1.58319800220112, 218, 30, 'PPL', 'P'),
(44504, 'Auth Village', 38.8208312988281, 0.677551324525817, -76.9024963378906, -1.34220176409907, 218, 25, 'PPL', 'P'),
(92381, 'Authon', 32.8683280944824, 0.573660544874472, -97.9436111450195, -1.7094384957736, 218, 51, 'PPL', 'P'),
(18975, 'Autney', 33.3472213745117, 0.582018809376659, -82.4391708374023, -1.43883496372676, 218, 13, 'PPL', 'P'),
(134043, 'Automba', 46.5208282470703, 0.811941623666159, -93.0183334350586, -1.6234761831597, 218, 28, 'PPL', 'P'),
(18976, 'Autreyville', 31.062219619751, 0.542138005342236, -83.7649993896484, -1.46197503728041, 218, 13, 'PPL', 'P'),
(62633, 'Autryville', 34.9977798461914, 0.610826489204155, -78.6427764892578, -1.37257538264754, 218, 33, 'PPL', 'P'),
(71716, 'Autumn Acres', 39.2238883972168, 0.684585997966235, -84.6052780151367, -1.47664066592931, 218, 41, 'PPL', 'P'),
(18977, 'Autumn Chase', 33.6230583190918, 0.586833072258222, -84.2227783203125, -1.46996478686675, 218, 13, 'PPL', 'P'),
(44505, 'Autumn Chase At Riva Trace', 38.964168548584, 0.680053031474811, -76.5625, -1.33626770855816, 218, 25, 'PPL', 'P'),
(44506, 'Autumn Estates', 38.7027816772461, 0.675490969948478, -76.5627822875977, -1.33627263540618, 218, 25, 'PPL', 'P'),
(44507, 'Autumn Grove', 38.3638916015625, 0.669576222325466, -75.5416717529297, -1.31845089454942, 218, 25, 'PPL', 'P'),
(44508, 'Autumn Hill', 39.2572212219238, 0.685167765506362, -76.8119430541992, -1.34062131115017, 218, 25, 'PPL', 'P'),
(177458, 'Autumn HIll', 41.517219543457, 0.724612177306662, -72.8724975585938, -1.27186501654899, 218, 8, 'PPL', 'P'),
(158836, 'Autumn Leaves', 41.9288902282715, 0.731797186190614, -75.334716796875, -1.31483884916295, 218, 45, 'PPL', 'P'),
(79617, 'Autumn Oaks', 34.5433311462402, 0.602894863108599, -82.6252822875977, -1.44208322130833, 218, 48, 'PPL', 'P'),
(99556, 'Autumn Oaks', 37.3708305358887, 0.652244037056094, -77.4749984741211, -1.352193811351, 218, 53, 'PPL', 'P'),
(44509, 'Autumn Ridge', 39.5950012207031, 0.691063138632444, -76.9913864135742, -1.3437531885921, 218, 25, 'PPL', 'P'),
(193069, 'Autumn Ridge', 33.6530609130859, 0.587356716307559, -112.153060913086, -1.95744017912311, 218, 5, 'PPL', 'P'),
(39180, 'Autumn Run', 30.3527793884277, 0.529755937459535, -91.1180572509766, -1.59031010705023, 218, 22, 'PPL', 'P'),
(44510, 'Autumn Wind', 39.4644393920898, 0.688784404845717, -76.7266693115234, -1.33913300357497, 218, 25, 'PPL', 'P'),
(202938, 'Autumn Wood', 40.6555595397949, 0.709573373210012, -111.949996948242, -1.95389604434443, 218, 52, 'PPL', 'P'),
(202939, 'Autumn Wood Circle', 40.6566696166992, 0.709592747706942, -111.949996948242, -1.95389604434443, 218, 52, 'PPL', 'P'),
(44511, 'Autumn Woods', 39.1441688537598, 0.683194629454723, -76.8172225952148, -1.34071345652388, 218, 25, 'PPL', 'P'),
(75034, 'Autwine', 36.7219390869141, 0.640918744783451, -97.2297210693359, -1.69697876345561, 218, 42, 'PPL', 'P'),
(7202, 'Auvergne', 35.5136108398438, 0.619829438427222, -91.2305603027344, -1.59227365572195, 218, 4, 'PPL', 'P'),
(108052, 'Auvil', 39.1777801513672, 0.68378125726384, -79.7238922119141, -1.39144441160297, 218, 58, 'PPL', 'P'),
(129622, 'Auvinen Corner', 46.5202789306641, 0.811932036286235, -90.0961074829102, -1.57247371880748, 218, 27, 'PPL', 'P'),
(113023, 'Aux Sable', 41.394718170166, 0.722474125004519, -88.32861328125, -1.5416251254786, 218, 18, 'PPL', 'P'),
(34626, 'Auxier', 37.7369384765625, 0.658633826038549, -82.7583312988281, -1.44440536462083, 218, 21, 'PPL', 'P'),
(53290, 'Auxvasse', 39.0180587768555, 0.680993593392799, -91.8969421386719, -1.60390421283454, 218, 29, 'PPL', 'P'),
(7203, 'Ava', 34.8694381713867, 0.608586504411289, -93.2052764892578, -1.62673895496921, 218, 4, 'PPL', 'P'),
(26424, 'Ava', 37.8883285522461, 0.661276081314071, -89.4947204589844, -1.56197753516121, 218, 18, 'PPL', 'P'),
(53291, 'Ava', 36.9519386291504, 0.644932994073554, -92.6602783203125, -1.61722694250377, 218, 29, 'PPL', 'P'),
(71717, 'Ava', 39.8316688537598, 0.695193768062184, -81.5749969482422, -1.42375228405115, 218, 41, 'PPL', 'P'),
(112872, 'Ava', 33.3430595397949, 0.581946171657927, -85.4780578613281, -1.4918735478904, 218, 2, 'PPL', 'P'),
(146928, 'Ava', 43.4188919067383, 0.757802621340102, -75.4797210693359, -1.31736965114685, 218, 40, 'PPL', 'P'),
(173016, 'Avalanche', 43.6022186279297, 0.761002276231777, -90.7802810668945, -1.58441480050318, 218, 57, 'PPL', 'P'),
(194097, 'Avalo', 40.8033294677734, 0.712152444988672, -103.649719238281, -1.80902886947572, 218, 7, 'PPL', 'P'),
(13310, 'Avalon', 39.7305603027344, 0.69342909094487, -75.6222229003906, -1.31985677728887, 218, 10, 'PPL', 'P'),
(18981, 'Avalon', 34.5019416809082, 0.602172480662915, -83.1952819824219, -1.45203159271838, 218, 13, 'PPL', 'P'),
(39181, 'Avalon', 29.7177791595459, 0.518673092714629, -91.3308334350586, -1.5940237520323, 218, 22, 'PPL', 'P'),
(44513, 'Avalon', 38.709171295166, 0.675602489819125, -76.3386077880859, -1.33236005229069, 218, 25, 'PPL', 'P'),
(53292, 'Avalon', 39.6591682434082, 0.692183064449849, -93.4413909912109, -1.63085993044, 218, 29, 'PPL', 'P'),
(58516, 'Avalon', 33.6549987792969, 0.587390538453403, -90.085563659668, -1.57228969437616, 218, 30, 'PPL', 'P'),
(70479, 'Avalon', 39.1011085510254, 0.682443085395102, -74.7180633544922, -1.30407621624961, 218, 37, 'PPL', 'P'),
(71718, 'Avalon', 39.5308303833008, 0.689943146236011, -84.3788909912109, -1.47268946697801, 218, 41, 'PPL', 'P'),
(92382, 'Avalon', 32.2052803039551, 0.562088177831696, -96.7897186279297, -1.68929927213626, 218, 51, 'PPL', 'P'),
(99558, 'Avalon', 37.9066696166992, 0.661596193277098, -76.4241714477539, -1.33385341987195, 218, 53, 'PPL', 'P'),
(122174, 'Avalon', 41.0161094665527, 0.71586615654976, -85.1577835083008, -1.48628370592038, 218, 19, 'PPL', 'P'),
(134045, 'Avalon', 44.1888885498047, 0.771241597990914, -94.0513916015625, -1.64150644952981, 218, 28, 'PPL', 'P'),
(158837, 'Avalon', 40.5008316040039, 0.706872861285644, -80.0677795410156, -1.39744637775168, 218, 45, 'PPL', 'P'),
(173017, 'Avalon', 42.6327781677246, 0.74408234829915, -88.8675003051758, -1.55103047834238, 218, 57, 'PPL', 'P'),
(179874, 'Avalon', 33.3427810668945, 0.581941311388937, -118.326942443848, -2.06519473946297, 218, 6, 'PPL', 'P'),
(188095, 'Avalon', 32.497501373291, 0.567188397635307, -104.236106872559, -1.81926326438684, 218, 38, 'PPL', 'P'),
(189905, 'Avalon', 38.7630615234375, 0.676543051737113, -118.755279541016, -2.07267063211698, 218, 39, 'PPL', 'P'),
(15058, 'Avalon Beach', 30.5300006866455, 0.532849032618094, -87.1016693115234, -1.52021091346939, 218, 12, 'PPL', 'P'),
(129620, 'Avalon Beach', 42.6888885498047, 0.745061659210999, -82.5083312988281, -1.44004204149084, 218, 27, 'PPL', 'P'),
(171696, 'Avalon Beach', 43.6399993896484, 0.761661674917681, -73.2255630493164, -1.27802717183727, 218, 55, 'PPL', 'P'),
(62635, 'Avalon Bench', 36.0424995422363, 0.629060287660573, -75.6783294677734, -1.32083602162169, 218, 33, 'PPL', 'P'),
(71719, 'Avalon Heights', 39.4208297729492, 0.688023273406173, -84.2138900756836, -1.46980965773326, 218, 41, 'PPL', 'P'),
(29131, 'Avalon Hills', 39.878059387207, 0.696003435612595, -86.0558319091797, -1.50195760735798, 218, 19, 'PPL', 'P'),
(99559, 'Avalon Hills', 36.8108291625977, 0.642470169276476, -76.1894378662109, -1.32975654600902, 218, 53, 'PPL', 'P'),
(44514, 'Avalon Park', 38.4191703796387, 0.670541019009375, -75.5569381713867, -1.31871734381648, 218, 25, 'PPL', 'P'),
(53293, 'Avalon Park', 37.3261108398438, 0.651463531119619, -93.2624969482422, -1.62773764037799, 218, 29, 'PPL', 'P'),
(112875, 'Avalon Park', 33.4305610656738, 0.583473361385033, -86.9902801513672, -1.51826680587363, 218, 2, 'PPL', 'P'),
(13311, 'Avalon Park Mobile Home Park', 38.6577796936035, 0.674705537163986, -75.2666702270508, -1.31365121247482, 218, 10, 'PPL', 'P'),
(44515, 'Avalon Shores', 38.8375015258789, 0.677842274874909, -76.5180587768555, -1.33549206289067, 218, 25, 'PPL', 'P'),
(99560, 'Avalon Terrace', 36.8161087036133, 0.642562314650193, -76.1927795410156, -1.3298148692369, 218, 53, 'PPL', 'P'),
(179876, 'Avalon Village', 33.8127784729004, 0.590144313599572, -118.263061523438, -2.06407980707261, 218, 6, 'PPL', 'P'),
(201877, 'Avance (historical)', 44.9183311462402, 0.783972773003011, -102.247222900391, -1.78455069063236, 218, 49, 'PPL', 'P'),
(18983, 'Avans', 34.8852806091309, 0.608863007111467, -85.5441665649414, -1.49302736243268, 218, 13, 'PPL', 'P'),
(7204, 'Avant', 34.6458282470703, 0.604683774991832, -93.3397216796875, -1.62908546620568, 218, 4, 'PPL', 'P'),
(75035, 'Avant', 36.4894409179688, 0.636860886230497, -96.0619430541992, -1.67659719215907, 218, 42, 'PPL', 'P'),
(112876, 'Avant', 31.6213893890381, 0.551897358893913, -86.7013931274414, -1.51322477613984, 218, 2, 'PPL', 'P'),
(92383, 'Avant Prairie', 31.6094398498535, 0.551688800091046, -96.1805572509766, -1.67866740043245, 218, 51, 'PPL', 'P'),
(18984, 'Avants', 32.1100006103516, 0.560425233468024, -82.8594436645508, -1.44617010831717, 218, 13, 'PPL', 'P'),
(75036, 'Avard', 36.6988906860352, 0.640516474300794, -98.7886123657227, -1.72418654925824, 218, 42, 'PPL', 'P'),
(34627, 'Avawam', 37.2244415283203, 0.649689066885299, -83.2752838134766, -1.45342788807791, 218, 21, 'PPL', 'P'),
(15059, 'Ave Maria', 26.3333301544189, 0.459603314209317, -81.4416732788086, -1.4214253470487, 218, 12, 'PPL', 'P'),
(44516, 'Aveley', 38.7791709899902, 0.676824214969199, -76.1391677856445, -1.3288791675879, 218, 25, 'PPL', 'P'),
(158839, 'Avella', 40.2750015258789, 0.702931382872327, -80.4608306884766, -1.40430641440361, 218, 45, 'PPL', 'P'),
(158840, 'Avella Highlands', 40.2733306884766, 0.702902221258391, -80.4649963378906, -1.40437911870137, 218, 45, 'PPL', 'P'),
(26425, 'Avena', 39.0074996948242, 0.680809302645366, -88.9277801513672, -1.55208256013102, 218, 18, 'PPL', 'P'),
(179877, 'Avena', 37.8430595397949, 0.660485987997671, -121.065277099609, -2.11298769522747, 218, 6, 'PPL', 'P'),
(179878, 'Avenal', 36.0041694641113, 0.628391301594745, -120.128059387207, -2.09663016033804, 218, 6, 'PPL', 'P'),
(77809, 'Avendale', 39.8855590820313, 0.696134329980172, -75.3633270263672, -1.31533819186733, 218, 45, 'PPL', 'P'),
(99561, 'Avendale', 37.2947196960449, 0.650915652304363, -79.934440612793, -1.39511917443311, 218, 53, 'PPL', 'P'),
(44518, 'Avenel', 39.002498626709, 0.680722017540639, -76.9802780151367, -1.34355931046474, 218, 25, 'PPL', 'P'),
(144775, 'Avenel', 40.5802803039551, 0.708259502686221, -74.2855606079102, -1.29652761929783, 218, 37, 'PPL', 'P'),
(191096, 'Avenger Village', 32.4594383239746, 0.566524072101387, -100.455276489258, -1.7532753257388, 218, 51, 'PPL', 'P'),
(34628, 'Avenstoke', 38.1083297729492, 0.665115826973747, -85.0005569458008, -1.48353958473316, 218, 21, 'PPL', 'P'),
(58517, 'Avent', 30.9813899993896, 0.540727262333793, -88.779167175293, -1.54948877438734, 218, 30, 'PPL', 'P'),
(62637, 'Aventon', 36.1527786254883, 0.6309850207594, -77.9499969482422, -1.36048409866636, 218, 33, 'PPL', 'P'),
(15060, 'Aventura', 25.9561100006104, 0.453019580520478, -80.1394424438477, -1.39869713135763, 218, 12, 'PPL', 'P'),
(44519, 'Avenue', 38.2561111450195, 0.667695098489489, -76.7680587768555, -1.33985538602066, 218, 25, 'PPL', 'P'),
(53294, 'Avenue City', 39.8633308410645, 0.695746373988375, -94.7569427490234, -1.65382064009423, 218, 29, 'PPL', 'P'),
(79618, 'Avenue of Oaks', 32.9638900756836, 0.575328416086161, -80.1474990844727, -1.39883774626319, 218, 48, 'PPL', 'P'),
(18985, 'Avera', 33.1938896179199, 0.579342665376265, -82.5272216796875, -1.44037174083379, 218, 13, 'PPL', 'P'),
(58518, 'Avera', 31.2958297729492, 0.546215271681633, -88.7413864135742, -1.54882937570143, 218, 30, 'PPL', 'P'),
(99562, 'Averett', 36.5747184753418, 0.638349260384715, -78.6516723632813, -1.37273064493909, 218, 53, 'PPL', 'P'),
(79619, 'Averill', 33.0741691589355, 0.577253149184989, -81.5136108398438, -1.42268089434461, 218, 48, 'PPL', 'P'),
(129621, 'Averill', 43.6655616760254, 0.762107820979297, -84.3419418334961, -1.47204458252005, 218, 27, 'PPL', 'P'),
(134046, 'Averill', 46.9708290100098, 0.819795618615939, -96.5469436645508, -1.68506204968389, 218, 28, 'PPL', 'P'),
(171697, 'Averill', 44.9980583190918, 0.785364274672577, -71.7108306884766, -1.25159010485411, 218, 55, 'PPL', 'P'),
(146930, 'Averill Park', 42.6338882446289, 0.74410172279608, -73.5541687011719, -1.28376242240281, 218, 40, 'PPL', 'P'),
(39184, 'Averit (historical)', 32.5166702270508, 0.567522957247248, -92.4333267211914, -1.61326588985644, 218, 22, 'PPL', 'P'),
(53295, 'Avert', 36.9294395446777, 0.644540310970822, -89.8477783203125, -1.56813955729143, 218, 29, 'PPL', 'P'),
(7205, 'Avery', 33.9297218322754, 0.592185360259009, -91.6569366455078, -1.59971532675596, 218, 4, 'PPL', 'P'),
(18988, 'Avery', 34.1955604553223, 0.596825119510145, -84.4225006103516, -1.47345059841756, 218, 13, 'PPL', 'P'),
(44520, 'Avery', 39.1094398498535, 0.682588493990621, -77.121940612793, -1.34603178922077, 218, 25, 'PPL', 'P'),
(53296, 'Avery', 38.0677795410156, 0.664408091914058, -93.3600006103516, -1.62943940031455, 218, 29, 'PPL', 'P'),
(75038, 'Avery', 35.8841705322266, 0.626296925134479, -96.7519378662109, -1.68863987345036, 218, 42, 'PPL', 'P'),
(92384, 'Avery', 33.5519409179688, 0.585591839453163, -94.7808303833008, -1.65423755796288, 218, 51, 'PPL', 'P'),
(112877, 'Avery', 34.1083297729492, 0.595302656893974, -86.0361099243164, -1.50161339378709, 218, 2, 'PPL', 'P'),
(113230, 'Avery', 41.3277816772461, 0.721305862813329, -82.6208267211914, -1.4420054570045, 218, 41, 'PPL', 'P'),
(114473, 'Avery', 41.0652809143066, 0.716724360211038, -92.7141723632813, -1.61816757100079, 218, 16, 'PPL', 'P'),
(122175, 'Avery', 40.3088912963867, 0.703522870950434, -86.440559387207, -1.50867236857245, 218, 19, 'PPL', 'P'),
(129623, 'Avery', 44.9575004577637, 0.784656406454834, -84.0313873291016, -1.46662438391147, 218, 27, 'PPL', 'P'),
(141217, 'Avery', 41.1636085510254, 0.718440501217485, -95.9222183227539, -1.67415853554889, 218, 35, 'PPL', 'P'),
(158841, 'Avery', 41.6386108398438, 0.726730855111875, -75.9313888549805, -1.32525274113154, 218, 45, 'PPL', 'P'),
(179879, 'Avery', 38.2044410705566, 0.666793285565361, -120.36888885498, -2.10083342748652, 218, 6, 'PPL', 'P'),
(194543, 'Avery', 47.250560760498, 0.824677858684327, -115.804168701172, -2.02116403137041, 218, 17, 'PPL', 'P'),
(53297, 'Avery (historical)', 38.0533294677734, 0.664155890558828, -91.2827835083008, -1.59318512260503, 218, 29, 'PPL', 'P'),
(177459, 'Avery Corner', 41.5988883972168, 0.7260375677011, -72.2113876342773, -1.26032647165206, 218, 8, 'PPL', 'P'),
(62640, 'Avery Creek', 35.4633293151855, 0.618951860269014, -82.5827789306641, -1.44134139778669, 218, 33, 'PPL', 'P'),
(26427, 'Avery Hill', 38.5530586242676, 0.672877809707865, -90.0269393920898, -1.57126650788535, 218, 18, 'PPL', 'P'),
(39186, 'Avery Island', 29.9033298492432, 0.521911563179193, -91.9102783203125, -1.60413697311382, 218, 22, 'PPL', 'P'),
(18990, 'Avery Landing', 33.4925003051758, 0.584554405050523, -82.1397171020508, -1.43360851008748, 218, 13, 'PPL', 'P'),
(193356, 'Avery Place', 40.1819381713867, 0.701307120923488, -121.779441833496, -2.12545222123543, 218, 6, 'PPL', 'P'),
(146931, 'Averys Place', 43.2941703796387, 0.755625820044098, -74.5550003051758, -1.30123022915069, 218, 40, 'PPL', 'P'),
(129625, 'Averytown (historical)', 44.6725006103516, 0.779682220749811, -86.0400009155273, -1.50168130439489, 218, 27, 'PPL', 'P'),
(118690, 'Averyville', 40.7166709899902, 0.710639969226589, -89.5622177124023, -1.5631555844694, 218, 18, 'PPL', 'P'),
(146932, 'Averyville', 44.2438888549805, 0.772201534405833, -74.0519409179688, -1.29245018651087, 218, 40, 'PPL', 'P'),
(31709, 'Avian', 37.0958290100098, 0.647444354981499, -95.6013870239258, -1.66855897304089, 218, 20, 'PPL', 'P'),
(44521, 'Avila', 38.9083290100098, 0.679078447673896, -76.6144409179688, -1.33717424859322, 218, 25, 'PPL', 'P'),
(179881, 'Avila Beach', 35.1800003051758, 0.614006836177927, -120.730827331543, -2.10715044559218, 218, 6, 'PPL', 'P'),
(193354, 'Avila Place', 41.0430603027344, 0.716336537377296, -120.866668701172, -2.10952132475263, 218, 6, 'PPL', 'P'),
(7212, 'Avilla', 34.6824989318848, 0.605323799180806, -92.5849990844727, -1.61591307197998, 218, 4, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(53299, 'Avilla', 37.1952781677246, 0.649180070221958, -94.1294403076172, -1.64286865642738, 218, 29, 'PPL', 'P'),
(122176, 'Avilla', 41.3658294677734, 0.72196992203114, -85.2388916015625, -1.48769930919781, 218, 19, 'PPL', 'P'),
(44522, 'Avilton', 39.6502799987793, 0.692027935316352, -79.0425033569336, -1.37955193259716, 218, 25, 'PPL', 'P'),
(92385, 'Avinger', 32.8997192382813, 0.574208423689729, -94.5561065673828, -1.65031538746746, 218, 51, 'PPL', 'P'),
(179880, 'Avinsino Corner', 38.6936111450195, 0.675330913966964, -120.675559997559, -2.10618584864536, 218, 6, 'PPL', 'P'),
(99563, 'Avis', 38.0433311462402, 0.6639813869284, -79.0941696166992, -1.38045367894226, 218, 53, 'PPL', 'P'),
(108053, 'Avis', 37.666389465332, 0.657402513508551, -80.8880615234375, -1.41176299913972, 218, 58, 'PPL', 'P'),
(154149, 'Avis', 41.0208282470703, 0.715948514806471, -84.1691665649414, -1.46902908521775, 218, 41, 'PPL', 'P'),
(158843, 'Avis', 41.1847190856934, 0.718808949554298, -77.3141708374023, -1.34938683956205, 218, 45, 'PPL', 'P'),
(188096, 'Avis', 32.7002792358398, 0.570727538986941, -105.454170227051, -1.84052248042061, 218, 38, 'PPL', 'P'),
(70481, 'Avis Mills', 39.665828704834, 0.692299311431431, -75.2486114501953, -1.31333602735981, 218, 37, 'PPL', 'P'),
(26430, 'Aviston', 38.6066703796387, 0.673813511356864, -89.6074981689453, -1.56394587752289, 218, 18, 'PPL', 'P'),
(71720, 'Avlon', 39.7438888549805, 0.693661718066088, -82.3850021362305, -1.43788954153978, 218, 41, 'PPL', 'P'),
(7207, 'Avoca', 36.4019393920898, 0.635333696503391, -94.070556640625, -1.64184094256272, 218, 4, 'PPL', 'P'),
(15061, 'Avoca', 30.5777797698975, 0.533682934934425, -83.0269393920898, -1.44909346024575, 218, 12, 'PPL', 'P'),
(29132, 'Avoca', 38.9119415283203, 0.679141498012704, -86.5477828979492, -1.51054377187045, 218, 19, 'PPL', 'P'),
(34629, 'Avoca', 38.2591705322266, 0.667748494869345, -85.4986114501953, -1.49223227568923, 218, 21, 'PPL', 'P'),
(39187, 'Avoca', 29.6838893890381, 0.518081604636523, -91.1902770996094, -1.59157058119417, 218, 22, 'PPL', 'P'),
(62642, 'Avoca', 36.002498626709, 0.628362139980809, -76.7119369506836, -1.33887587537173, 218, 33, 'PPL', 'P'),
(75039, 'Avoca', 35.0138893127441, 0.61110765243624, -96.9302825927734, -1.69175257613244, 218, 42, 'PPL', 'P'),
(84762, 'Avoca', 36.5316696166992, 0.637597916062176, -82.2463912963867, -1.43547032600556, 218, 50, 'PPL', 'P'),
(92386, 'Avoca', 32.8655586242676, 0.573612208500687, -99.7155609130859, -1.74036485340631, 218, 51, 'PPL', 'P'),
(108054, 'Avoca', 38.4530601501465, 0.671132507087481, -81.0508270263672, -1.41460379307451, 218, 58, 'PPL', 'P'),
(114476, 'Avoca', 41.4766693115234, 0.723904442246974, -95.3377838134766, -1.66395822909972, 218, 16, 'PPL', 'P'),
(129626, 'Avoca', 43.061939239502, 0.751572622023052, -82.6911087036133, -1.44323210900259, 218, 27, 'PPL', 'P'),
(134047, 'Avoca', 43.9486083984375, 0.767047918222366, -95.6452789306641, -1.66932503132845, 218, 28, 'PPL', 'P'),
(141218, 'Avoca', 40.7961082458496, 0.712026410890084, -96.1172180175781, -1.67756192226396, 218, 35, 'PPL', 'P'),
(146933, 'Avoca', 42.4094390869141, 0.740184345990628, -77.4216690063477, -1.35126303655001, 218, 40, 'PPL', 'P'),
(158845, 'Avoca', 41.3397216796875, 0.721514255168628, -75.7366714477539, -1.32185428126449, 218, 45, 'PPL', 'P'),
(173018, 'Avoca', 43.1819381713867, 0.753666998483318, -90.3244400024414, -1.57645887306268, 218, 57, 'PPL', 'P'),
(197959, 'Avoca', 48.185001373291, 0.840986924041918, -103.523612976074, -1.80682789999282, 218, 34, 'PPL', 'P'),
(112879, 'Avoca (historical)', 34.5750007629395, 0.603447602192845, -87.5055618286133, -1.52726016771677, 218, 2, 'PPL', 'P'),
(118691, 'Avoca (historical)', 40.8061103820801, 0.712200981099539, -88.5180587768555, -1.54493157312999, 218, 18, 'PPL', 'P'),
(71721, 'Avoca Park', 39.1388893127441, 0.683102484081006, -84.3411102294922, -1.47203006829211, 218, 41, 'PPL', 'P'),
(179882, 'Avocado Heights', 34.0361099243164, 0.594042182750039, -117.990280151367, -2.05931887399187, 218, 6, 'PPL', 'P'),
(7208, 'Avon', 34.0747184753418, 0.594716029084857, -94.3227767944336, -1.64624301468657, 218, 4, 'PPL', 'P'),
(29133, 'Avon', 39.7627792358398, 0.69399141740904, -86.3997192382813, -1.5079595735067, 218, 19, 'PPL', 'P'),
(34630, 'Avon', 38.0716705322266, 0.664476002521855, -84.3186111450195, -1.47163738518938, 218, 21, 'PPL', 'P'),
(53301, 'Avon', 37.7513885498047, 0.658886027393779, -90.2233276367188, -1.57469412936634, 218, 29, 'PPL', 'P'),
(58519, 'Avon', 33.2299995422363, 0.579972902448232, -91.0472183227539, -1.58907373451417, 218, 30, 'PPL', 'P'),
(62643, 'Avon', 35.3519401550293, 0.617007752673256, -75.5108337402344, -1.31791266969311, 218, 33, 'PPL', 'P'),
(99564, 'Avon', 37.9997215270996, 0.663220255488856, -78.8266677856445, -1.37578489123524, 218, 53, 'PPL', 'P'),
(108055, 'Avon', 39.1952781677246, 0.684086655261845, -80.649169921875, -1.4075935541371, 218, 58, 'PPL', 'P'),
(112878, 'Avon', 31.1891708374023, 0.544353722079668, -85.2861099243164, -1.48852342439713, 218, 2, 'PPL', 'P'),
(114477, 'Avon', 41.5286102294922, 0.724810982282037, -93.523063659668, -1.63228538741346, 218, 16, 'PPL', 'P'),
(118693, 'Avon', 40.6641693115234, 0.70972364207452, -90.4347229003906, -1.57838367274053, 218, 18, 'PPL', 'P'),
(124155, 'Avon', 42.1305618286133, 0.735317019624345, -71.0416717529297, -1.23991107820967, 218, 23, 'PPL', 'P'),
(126798, 'Avon', 44.8061103820801, 0.782014151179312, -70.2716674804688, -1.22647196840081, 218, 26, 'PPL', 'P'),
(134049, 'Avon', 45.6091690063477, 0.796030168259317, -94.4513931274414, -1.6484877931694, 218, 28, 'PPL', 'P'),
(146935, 'Avon', 42.9119415283203, 0.748954668092477, -77.7458267211914, -1.35692065596978, 218, 40, 'PPL', 'P'),
(154150, 'Avon', 41.4516716003418, 0.723468149881391, -82.0355606079102, -1.43179063632739, 218, 41, 'PPL', 'P'),
(158847, 'Avon', 40.3455581665039, 0.70416282856038, -76.3902816772461, -1.33326193179384, 218, 45, 'PPL', 'P'),
(169773, 'Avon', 43.0050010681152, 0.750578863462289, -98.059440612793, -1.71146010135708, 218, 49, 'PPL', 'P'),
(173021, 'Avon', 42.5433311462402, 0.742521203268145, -89.3313903808594, -1.55912688753039, 218, 57, 'PPL', 'P'),
(177461, 'Avon', 41.8097190856934, 0.729717257379262, -72.8311080932617, -1.27114263410331, 218, 8, 'PPL', 'P'),
(179883, 'Avon', 38.0327796936035, 0.663797229339022, -122.074172973633, -2.13059625003897, 218, 6, 'PPL', 'P'),
(186372, 'Avon', 39.6313896179199, 0.6916982359734, -106.521667480469, -1.85915382224875, 218, 7, 'PPL', 'P'),
(194544, 'Avon', 46.8261108398438, 0.817269810059081, -116.612777709961, -2.03527692093507, 218, 17, 'PPL', 'P'),
(195908, 'Avon', 46.5972213745117, 0.813274935265907, -112.601112365723, -1.96526015218996, 218, 31, 'PPL', 'P'),
(202952, 'Avon', 41.5330581665039, 0.724888613427812, -111.8125, -1.95149626988616, 218, 52, 'PPL', 'P'),
(206732, 'Avon', 48.4425010681152, 0.845481141539481, -122.377220153809, -2.13588542112192, 218, 56, 'PPL', 'P'),
(154151, 'Avon Center', 41.4597206115723, 0.723608631628893, -82.0197219848633, -1.43151420020624, 218, 41, 'PPL', 'P'),
(126799, 'Avon Corner', 44.8002815246582, 0.781912418425671, -70.26611328125, -1.22637502933713, 218, 26, 'PPL', 'P'),
(44523, 'Avon Crest', 38.586669921875, 0.673464437516982, -77.0105590820313, -1.34408781478307, 218, 25, 'PPL', 'P'),
(99565, 'Avon Forest', 38.7719383239746, 0.676697981133529, -77.3058319091797, -1.34924129780848, 218, 53, 'PPL', 'P'),
(158848, 'Avon Heights', 40.3525009155273, 0.704284002389978, -76.3752822875977, -1.33300014305869, 218, 45, 'PPL', 'P'),
(114478, 'Avon Lake', 41.5219383239746, 0.724694535563373, -93.5008316040039, -1.63189736484264, 218, 16, 'PPL', 'P'),
(154152, 'Avon Lake', 41.5052795410156, 0.724403784951363, -82.0283279418945, -1.43166440249172, 218, 41, 'PPL', 'P'),
(15063, 'Avon Park', 27.5955600738525, 0.481633382220616, -81.5063934326172, -1.42255492682505, 218, 12, 'PPL', 'P'),
(18991, 'Avon Park', 32.0555610656738, 0.559475084170111, -81.0599975585938, -1.41476384905603, 218, 13, 'PPL', 'P'),
(112874, 'Avon Park', 33.5461082458496, 0.585490040120495, -86.7713928222656, -1.51444650128991, 218, 2, 'PPL', 'P'),
(144776, 'Avon Park', 40.5930595397949, 0.708482542427516, -74.4000015258789, -1.29852499011539, 218, 37, 'PPL', 'P'),
(15064, 'Avon Park Lakes', 27.628059387207, 0.48220060224329, -81.5486068725586, -1.42329169034062, 218, 12, 'PPL', 'P'),
(177460, 'Avon Park North', 41.8125, 0.729765793490129, -72.8358306884766, -1.27122505893904, 218, 8, 'PPL', 'P'),
(177456, 'Avon Park South', 41.8063888549805, 0.729659133888471, -72.8411102294922, -1.27131720431276, 218, 8, 'PPL', 'P'),
(154154, 'Avon Point', 41.5133285522461, 0.724544266698865, -82.0177764892578, -1.43148024490234, 218, 41, 'PPL', 'P'),
(144777, 'Avon-by-the-Sea', 40.1922187805176, 0.701486551401932, -74.0163879394531, -1.29182966997688, 218, 37, 'PPL', 'P'),
(92387, 'Avonak', 30.0944404602051, 0.525247072575976, -95.5066680908203, -1.66690581579422, 218, 51, 'PPL', 'P'),
(29134, 'Avonburg', 38.8863906860352, 0.67869555168817, -85.1722183227539, -1.4865356409595, 218, 19, 'PPL', 'P'),
(15066, 'Avondale', 30.4516696929932, 0.531481898872502, -87.3066711425781, -1.52378887039391, 218, 12, 'PPL', 'P'),
(18996, 'Avondale', 33.5113906860352, 0.584884104393475, -82.0602798461914, -1.43222206842399, 218, 13, 'PPL', 'P'),
(39189, 'Avondale', 31.9402809143066, 0.557463065966556, -91.2816696166992, -1.59316568152907, 218, 22, 'PPL', 'P'),
(44525, 'Avondale', 38.9486083984375, 0.67978145562265, -76.9755630493164, -1.34347701878706, 218, 25, 'PPL', 'P'),
(53302, 'Avondale', 39.1541709899902, 0.683369199664177, -94.5466690063477, -1.65015067095404, 218, 29, 'PPL', 'P'),
(62644, 'Avondale', 35.2694396972656, 0.615567848050877, -81.7908325195313, -1.42751932541307, 218, 33, 'PPL', 'P'),
(79623, 'Avondale', 33.9111099243164, 0.591860521185046, -80.4061126708984, -1.40335140483671, 218, 48, 'PPL', 'P'),
(84767, 'Avondale', 36.3319396972656, 0.634111971353317, -86.5494384765625, -1.51057266716828, 218, 50, 'PPL', 'P'),
(92389, 'Avondale', 32.9677810668945, 0.575396326693959, -97.420280456543, -1.70030465218296, 218, 51, 'PPL', 'P'),
(99566, 'Avondale', 37.6575012207031, 0.657247384375053, -77.3619384765625, -1.3502205421413, 218, 53, 'PPL', 'P'),
(108057, 'Avondale', 37.4124984741211, 0.652971279770768, -81.7844390869141, -1.4274077389634, 218, 58, 'PPL', 'P'),
(112880, 'Avondale', 33.521671295166, 0.585063534871919, -86.7780609130859, -1.51456288142955, 218, 2, 'PPL', 'P'),
(129627, 'Avondale', 44.0158309936523, 0.768221173840601, -85.2266693115234, -1.48748598999449, 218, 27, 'PPL', 'P'),
(144779, 'Avondale', 40.8147201538086, 0.712351249964046, -74.1505584716797, -1.29417138752339, 218, 37, 'PPL', 'P'),
(154157, 'Avondale', 40.8263893127441, 0.71255491520841, -81.414436340332, -1.42094997279412, 218, 41, 'PPL', 'P'),
(158849, 'Avondale', 41.2227783203125, 0.719473208509191, -75.9822235107422, -1.3261399732487, 218, 45, 'PPL', 'P'),
(169268, 'Avondale', 41.3344383239746, 0.721422043215884, -71.8358306884766, -1.2537717664191, 218, 47, 'PPL', 'P'),
(186373, 'Avondale', 38.2374992370605, 0.667370259415526, -104.350563049316, -1.82126090152051, 218, 7, 'PPL', 'P'),
(193074, 'Avondale', 33.4355583190918, 0.583560579910733, -112.348892211914, -1.96085808006612, 218, 5, 'PPL', 'P'),
(206733, 'Avondale', 47.7033309936523, 0.832580190007892, -122.091667175293, -2.13090158145795, 218, 56, 'PPL', 'P'),
(195909, 'Avondale (historical)', 48.6650009155273, 0.849364496462007, -106.184722900391, -1.85327302992964, 218, 31, 'PPL', 'P'),
(202946, 'Avondale Condo', 40.610279083252, 0.708783080156531, -111.790283203125, -1.95110851363144, 218, 52, 'PPL', 'P'),
(18999, 'Avondale Estates', 33.7713890075684, 0.589421931153888, -84.267219543457, -1.47074043253424, 218, 13, 'PPL', 'P'),
(34631, 'Avondale Heights', 37.0722198486328, 0.647032297381836, -88.6500015258789, -1.54723440852458, 218, 21, 'PPL', 'P'),
(158850, 'Avondale Hill', 41.2272186279297, 0.719550706496912, -75.9836120605469, -1.32616420801462, 218, 45, 'PPL', 'P'),
(84769, 'Avondale Springs', 36.3105583190918, 0.63373879590557, -83.4625015258789, -1.45669545357738, 218, 50, 'PPL', 'P'),
(44528, 'Avondale Terrace', 38.9533309936523, 0.679863880458388, -76.9763870239258, -1.34349139985694, 218, 25, 'PPL', 'P'),
(112887, 'Avondale Village', 33.5930595397949, 0.586309494787913, -86.2761077880859, -1.50580214670762, 218, 2, 'PPL', 'P'),
(158851, 'Avonia', 42.0455589294434, 0.733833439160089, -80.2699966430664, -1.4009757319863, 218, 45, 'PPL', 'P'),
(158852, 'Avonmore', 40.5288887023926, 0.707362550031083, -79.461669921875, -1.38686776926966, 218, 45, 'PPL', 'P'),
(44529, 'Avonvue', 38.7069396972656, 0.675563541088182, -76.1811065673828, -1.32961113741351, 218, 25, 'PPL', 'P'),
(84770, 'Avoton (historical)', 36.2825012207031, 0.633249107160131, -85.4844436645508, -1.49198500118202, 218, 50, 'PPL', 'P'),
(158854, 'Avoy', 41.4447212219238, 0.723346842893738, -75.3399963378906, -1.31493099453666, 218, 45, 'PPL', 'P'),
(193068, 'Avra', 32.3277816772461, 0.564226230133839, -111.217498779297, -1.9411115395315, 218, 5, 'PPL', 'P'),
(193079, 'Avra Valley', 32.4377784729004, 0.56614603638465, -111.314720153809, -1.94280837262005, 218, 5, 'PPL', 'P'),
(84771, 'Avreet', 35.6202812194824, 0.621691187766269, -89.6666717529297, -1.56497865139362, 218, 50, 'PPL', 'P'),
(199817, 'Awakening', 41.2755584716797, 0.720394395930249, -117.952499389648, -2.05865947530597, 218, 39, 'PPL', 'P'),
(84772, 'Awalt (historical)', 35.2583312988281, 0.615373969923519, -86.2547225952148, -1.50542890468085, 218, 50, 'PPL', 'P'),
(34632, 'Awe', 38.4213905334473, 0.670579768003235, -83.3438873291016, -1.45462524530401, 218, 21, 'PPL', 'P'),
(79627, 'Awendaw', 33.0374984741211, 0.576613124996016, -79.6133270263672, -1.38951468507709, 218, 48, 'PPL', 'P'),
(112881, 'Awin', 31.8377799987793, 0.555674087504295, -86.9488906860352, -1.51754442342794, 218, 2, 'PPL', 'P'),
(144780, 'Awosting', 41.1544418334961, 0.718280511814999, -74.3369369506836, -1.29742430563686, 218, 37, 'PPL', 'P'),
(146939, 'Awosting', 41.6691703796387, 0.72726421969919, -74.2916717529297, -1.29663427889949, 218, 40, 'PPL', 'P'),
(200353, 'Axehandle (historical)', 44.7508316040039, 0.781049354495403, -120.650001525879, -2.10573976916277, 218, 43, 'PPL', 'P'),
(158855, 'Axemann', 40.8899993896484, 0.713665120487837, -77.7605590820313, -1.35717778417302, 218, 45, 'PPL', 'P'),
(146937, 'Axeville', 42.2491683959961, 0.737387094739663, -78.9594421386719, -1.37810224085778, 218, 40, 'PPL', 'P'),
(206734, 'Axford', 47.1944389343262, 0.823698348035396, -123.944999694824, -2.16324833605805, 218, 56, 'PPL', 'P'),
(194096, 'Axial', 40.2852783203125, 0.703110746771744, -107.791389465332, -1.88131465146957, 218, 7, 'PPL', 'P'),
(129628, 'Axin', 44.2099990844727, 0.771610046327727, -85.5475006103516, -1.49308555250249, 218, 27, 'PPL', 'P'),
(112873, 'Axis', 30.9297199249268, 0.539825449409665, -88.0272216796875, -1.53636484969348, 218, 2, 'PPL', 'P'),
(112868, 'Axle', 31.5955600738525, 0.55144655230039, -87.329719543457, -1.52419114087656, 218, 2, 'PPL', 'P'),
(19001, 'Axson', 31.2761096954346, 0.545871091400254, -82.7344436645508, -1.44398844675217, 218, 13, 'PPL', 'P'),
(34634, 'Axtel', 37.6441688537598, 0.657014690674808, -86.475830078125, -1.50928795825843, 218, 21, 'PPL', 'P'),
(154158, 'Axtel', 41.3686103820801, 0.722018458142007, -82.3638916015625, -1.43752109320297, 218, 41, 'PPL', 'P'),
(31713, 'Axtell', 39.8716697692871, 0.695891915741948, -96.2586135864258, -1.68002974048808, 218, 20, 'PPL', 'P'),
(53303, 'Axtell', 39.8244400024414, 0.695067600805541, -92.4727783203125, -1.61395445015628, 218, 29, 'PPL', 'P'),
(62645, 'Axtell', 36.3624992370605, 0.634645335940633, -78.2566680908203, -1.3658365198252, 218, 33, 'PPL', 'P'),
(92390, 'Axtell', 31.6580600738525, 0.552537383082886, -96.9711074829102, -1.69246510488209, 218, 51, 'PPL', 'P'),
(99567, 'Axtell', 37.7011108398438, 0.658008515814598, -78.6016693115234, -1.37185792704987, 218, 53, 'PPL', 'P'),
(141221, 'Axtell', 40.478328704834, 0.706480111603885, -99.1263885498047, -1.7300818558053, 218, 35, 'PPL', 'P'),
(192476, 'Axtell', 39.0552787780762, 0.681643204961697, -111.821113586426, -1.95164660532969, 218, 52, 'PPL', 'P'),
(124158, 'Axtell Corner', 42.2319412231445, 0.737086423852593, -71.6841735839844, -1.25112485061167, 218, 23, 'PPL', 'P'),
(99568, 'Axton', 36.6594390869141, 0.639827914000954, -79.7122192382813, -1.39124067977957, 218, 53, 'PPL', 'P'),
(146938, 'Axton Landing', 44.2027816772461, 0.771484078808166, -74.3291702270508, -1.29728875073738, 218, 40, 'PPL', 'P'),
(58521, 'Ayanabi (historical)', 32.6944389343262, 0.570625606496218, -88.7422180175781, -1.54884388992937, 218, 30, 'PPL', 'P'),
(39191, 'Aycock', 32.7080612182617, 0.570863360202535, -92.9175033569336, -1.62171636631138, 218, 22, 'PPL', 'P'),
(62646, 'Aycock Crossing', 35.6266708374023, 0.621802707636916, -78.054443359375, -1.36230703243252, 218, 33, 'PPL', 'P'),
(19002, 'Aycock Mill', 31.6372203826904, 0.552173661857008, -84.6130599975586, -1.4767764871449, 218, 13, 'PPL', 'P'),
(75041, 'Aydelotte', 35.4441719055176, 0.618617500394154, -96.9113922119141, -1.69142287678949, 218, 42, 'PPL', 'P'),
(62647, 'Ayden', 35.4724998474121, 0.619111916250527, -77.4158325195313, -1.35116117063832, 218, 33, 'PPL', 'P'),
(62649, 'Aydlett', 36.3258285522461, 0.634005311751659, -75.9072189331055, -1.32483089641487, 218, 33, 'PPL', 'P'),
(124162, 'Ayer', 42.5611114501953, 0.742831528114167, -71.5902786254883, -1.24948607443489, 218, 23, 'PPL', 'P'),
(186374, 'Ayer', 37.7580604553223, 0.659002474112443, -103.845832824707, -1.81245169726674, 218, 7, 'PPL', 'P'),
(206735, 'Ayer', 46.5963897705078, 0.813260421037966, -118.347221374512, -2.06554867357184, 218, 56, 'PPL', 'P'),
(15067, 'Ayers', 28.4630603790283, 0.496774118807989, -82.4438934326172, -1.4389173885625, 218, 12, 'PPL', 'P'),
(34633, 'Ayers', 36.6308288574219, 0.639328571296564, -84.2286071777344, -1.47006651962039, 218, 21, 'PPL', 'P'),
(84773, 'Ayers', 36.0791702270508, 0.629700311849546, -89.6419372558594, -1.56454695298092, 218, 50, 'PPL', 'P'),
(108058, 'Ayers', 38.9780616760254, 0.680295512292062, -81.0986099243164, -1.41543776196987, 218, 58, 'PPL', 'P'),
(118696, 'Ayers', 42.0538902282715, 0.733978847755607, -90.1155624389648, -1.57281327184647, 218, 18, 'PPL', 'P'),
(126801, 'Ayers', 44.9844398498535, 0.785126587545287, -67.2386093139648, -1.17353511699081, 218, 26, 'PPL', 'P'),
(79628, 'Ayers (historical)', 34.6105613708496, 0.604068251884888, -79.7027816772461, -1.39107596326615, 218, 48, 'PPL', 'P'),
(158856, 'Ayers Crossroads', 41.8613891601563, 0.73061907030339, -76.6672210693359, -1.33809543601428, 218, 45, 'PPL', 'P'),
(158857, 'Ayers Hill', 41.7286109924316, 0.728301654101831, -77.9658279418945, -1.36076040162945, 218, 45, 'PPL', 'P'),
(195910, 'Ayers Ranch Colony', 47.0513916015625, 0.821201701092474, -108.948890686035, -1.9015168588667, 218, 31, 'PPL', 'P'),
(124160, 'Ayers Village', 42.7869415283203, 0.746773006527484, -71.1694412231445, -1.24214107614845, 218, 23, 'PPL', 'P'),
(19003, 'Ayersville', 34.5608291625977, 0.603200261106604, -83.413330078125, -1.4558372499161, 218, 13, 'PPL', 'P'),
(62650, 'Ayersville', 36.4869384765625, 0.636817210388619, -80.0252838134766, -1.39670468738809, 218, 33, 'PPL', 'P'),
(154159, 'Ayersville', 41.2386093139648, 0.719749511472287, -84.2855606079102, -1.47106054449727, 218, 41, 'PPL', 'P'),
(75042, 'Aylesworth', 34.0280609130859, 0.593901701002538, -96.6263885498047, -1.68644862450544, 218, 42, 'PPL', 'P'),
(122178, 'Aylesworth', 41.3183288574219, 0.721140879983798, -87.1133270263672, -1.52041437897667, 218, 19, 'PPL', 'P'),
(99569, 'Aylett', 37.785831451416, 0.659487169430837, -77.1052780151367, -1.34574097202973, 218, 53, 'PPL', 'P'),
(99575, 'Aylett Mill', 37.7619400024414, 0.659070184983158, -77.0927810668945, -1.34552285913646, 218, 53, 'PPL', 'P'),
(197960, 'Aylmer', 47.9341697692871, 0.836609086683991, -100.192497253418, -1.74868896286752, 218, 34, 'PPL', 'P'),
(19004, 'Aylmer (historical)', 34.1916694641113, 0.596757208902348, -84.9252777099609, -1.48222571420937, 218, 13, 'PPL', 'P'),
(44531, 'Aylor', 39.3833312988281, 0.687368801568286, -77.3694381713867, -1.35035143650888, 218, 25, 'PPL', 'P'),
(99570, 'Aylor', 38.4347190856934, 0.670812395124454, -78.3022232055664, -1.36663160656864, 218, 53, 'PPL', 'P'),
(84774, 'Aymett Town', 35.1761093139648, 0.61393892557013, -86.959716796875, -1.51773337470729, 218, 50, 'PPL', 'P'),
(79629, 'Aynor', 33.9997215270996, 0.593407085409083, -79.1997222900391, -1.38229592062633, 218, 48, 'PPL', 'P'),
(44532, 'Aynsley', 39.4619407653809, 0.688740795582867, -77.459716796875, -1.35192709576782, 218, 25, 'PPL', 'P'),
(206736, 'Ayock', 47.5074996948242, 0.829162289064884, -123.055557250977, -2.14772463690592, 218, 56, 'PPL', 'P'),
(129630, 'Ayr', 45.4922218322754, 0.793989055020853, -84.8533325195313, -1.4809700337554, 218, 27, 'PPL', 'P'),
(139626, 'Ayr', 47.0411109924316, 0.821022270614029, -97.4902801513672, -1.70152637733303, 218, 34, 'PPL', 'P'),
(141222, 'Ayr', 40.4375, 0.705767516275207, -98.4400024414063, -1.7181021582738, 218, 35, 'PPL', 'P'),
(141223, 'Ayr Junction', 40.4577789306641, 0.706121450384079, -98.4313888549805, -1.71795182283026, 218, 35, 'PPL', 'P'),
(44533, 'Ayres', 38.6641693115234, 0.674817057034633, -77.0194396972656, -1.34424281075851, 218, 25, 'PPL', 'P'),
(112883, 'Ayres', 33.7313919067383, 0.588723850053151, -86.563606262207, -1.51081994167549, 218, 2, 'PPL', 'P'),
(124161, 'Ayres City', 42.625, 0.743946593662583, -71.3125, -1.24463792282846, 218, 23, 'PPL', 'P'),
(112882, 'Ayres Estates', 33.7269401550293, 0.588646152328348, -86.5583267211914, -1.51072779630178, 218, 2, 'PPL', 'P'),
(44534, 'Ayres Lane Estates', 38.1216697692871, 0.665348653832047, -75.3375015258789, -1.31488745185284, 218, 25, 'PPL', 'P'),
(114479, 'Ayresville', 41.6847190856934, 0.727535595814269, -91.0138931274414, -1.58849210013209, 218, 16, 'PPL', 'P'),
(29135, 'Ayrshire', 38.371940612793, 0.669716704072968, -87.2408294677734, -1.52263971638354, 218, 19, 'PPL', 'P'),
(114480, 'Ayrshire', 43.0391693115234, 0.751175211809385, -94.8324966430664, -1.65513930430798, 218, 16, 'PPL', 'P'),
(724, 'Azalea', 35.5800018310547, 0.620988179817516, -82.4713897705078, -1.43939729019093, 218, 33, 'PPL', 'P'),
(193355, 'Azalea', 41.2783317565918, 0.720442798883061, -122.301109313965, -2.13455703637019, 218, 6, 'PPL', 'P'),
(200354, 'Azalea', 42.7955589294434, 0.746923408550046, -123.259170532227, -2.15127835906452, 218, 43, 'PPL', 'P'),
(99572, 'Azalea Acres', 36.7355613708496, 0.641156498489767, -76.5933303833008, -1.33680580025641, 218, 53, 'PPL', 'P'),
(19005, 'Azalea Gardens', 31.1972198486328, 0.54449420382717, -81.4749984741211, -1.42200698143077, 218, 13, 'PPL', 'P'),
(99573, 'Azalea Mobile Home Park', 38.6297187805176, 0.67421578183952, -77.4111099243164, -1.35107874580258, 218, 53, 'PPL', 'P'),
(15068, 'Azalea Park', 28.5408306121826, 0.498131465436575, -81.3008270263672, -1.4189671162045, 218, 12, 'PPL', 'P'),
(19006, 'Azalea Park', 32.8372192382813, 0.573117592907232, -83.6900024414063, -1.46066609360463, 218, 13, 'PPL', 'P'),
(19007, 'Azalea Plaza Mobile Home Park', 32.041389465332, 0.559227743083869, -81.1813888549805, -1.41688252686124, 218, 13, 'PPL', 'P'),
(15069, 'Azalea Terrace', 30.2869396209717, 0.528606816738679, -81.5611114501953, -1.42350993639196, 218, 12, 'PPL', 'P'),
(79631, 'Azalea Trailer Park', 33.9688911437988, 0.592868993710832, -80.3905563354492, -1.40307989556358, 218, 48, 'PPL', 'P'),
(29136, 'Azalia', 39.0916709899902, 0.682278368881681, -85.8472213745117, -1.49831666667368, 218, 19, 'PPL', 'P'),
(129629, 'Azalia', 42.0188903808594, 0.73336798518057, -83.6658325195313, -1.46024424888796, 218, 27, 'PPL', 'P'),
(158858, 'Azelta', 41.8394393920898, 0.730235974580583, -77.4852828979492, -1.35237330840847, 218, 45, 'PPL', 'P'),
(39192, 'Azema (historical)', 30.2244396209717, 0.527515985956183, -91.8727798461914, -1.60348250127593, 218, 22, 'PPL', 'P'),
(99574, 'Azen', 36.6580581665039, 0.639803812393089, -81.6361083984375, -1.42481888006773, 218, 53, 'PPL', 'P'),
(139020, 'Azen', 40.5597190856934, 0.707900641729333, -92.0380630493164, -1.6063672373687, 218, 29, 'PPL', 'P'),
(92391, 'Azle', 32.8950004577637, 0.574126065433018, -97.5455627441406, -1.70249124059597, 218, 51, 'PPL', 'P'),
(195911, 'Aznoe (historical)', 47.9583282470703, 0.837030731663578, -111.323059082031, -1.94295391437362, 218, 31, 'PPL', 'P'),
(7210, 'Azor', 33.5916709899902, 0.586285260021993, -93.4247207641602, -1.63056898009091, 218, 4, 'PPL', 'P'),
(173023, 'Aztalan', 43.0727806091309, 0.751761839618502, -88.8622207641602, -1.55093833296867, 218, 57, 'PPL', 'P'),
(188097, 'Aztec', 36.8222198486328, 0.642668974251851, -107.992218017578, -1.88481977093828, 218, 38, 'PPL', 'P'),
(193083, 'Aztec', 32.8244400024414, 0.572894553165938, -113.449172973633, -1.98006160205446, 218, 5, 'PPL', 'P'),
(193084, 'Aztec Lodge', 33.8450012207031, 0.59070670664277, -110.968330383301, -1.93676273062946, 218, 5, 'PPL', 'P'),
(114481, 'Aztec Mobile Home Park', 40.6347198486328, 0.709209651984134, -91.3625030517578, -1.59457649111654, 218, 16, 'PPL', 'P'),
(154160, 'Aztec Subdivision', 41.6172218322754, 0.726357546506073, -83.4641723632813, -1.45672461519131, 218, 41, 'PPL', 'P'),
(92392, 'Azteca Acres Colonia', 26.2099990844727, 0.457450780968747, -98.1539993286133, -1.71311046228461, 218, 51, 'PPL', 'P'),
(39193, 'Azucena', 31.7777805328369, 0.554626899274162, -91.4377822875977, -1.59589036164033, 218, 22, 'PPL', 'P'),
(188098, 'Azul', 34.6938896179199, 0.60552260415618, -106.757781982422, -1.86327479771954, 218, 38, 'PPL', 'P'),
(179884, 'Azure Vista', 32.7194404602051, 0.571061965440827, -117.262222290039, -2.04661186716667, 218, 6, 'PPL', 'P'),
(179885, 'Azusa', 34.1336097717285, 0.595743876107573, -117.906669616699, -2.05785959487256, 218, 6, 'PPL', 'P'),
(206737, 'Azwell', 47.9372215270996, 0.836662349905792, -119.875282287598, -2.09221836767622, 218, 56, 'PPL', 'P'),
(211665, 'Ãƒâ€žliamanu', 21.3547191619873, 0.372710160215403, -157.927505493164, -2.75635495031714, 218, 15, 'PPL', 'P'),
(211570, 'Ã‚â€˜Aiea', 21.3822193145752, 0.373190128422862, -157.933609008789, -2.75646147676075, 218, 15, 'PPL', 'P'),
(211649, 'Ã‚â€˜Aiea Heights', 21.3908290863037, 0.37334039728737, -157.920272827148, -2.75622871648147, 218, 15, 'PPL', 'P'),
(211544, 'Ã‚â€˜AinapÃƒÂ¶', 19.3591709136963, 0.337881272900319, -155.424163818359, -2.71266339578941, 218, 15, 'PPL', 'P'),
(211581, 'Ã‚â€˜Ãƒâ€žhuimanu', 21.4447193145752, 0.374280959205359, -157.837783813477, -2.75478901159618, 218, 15, 'PPL', 'P'),
(211554, 'Ã‚â€˜Ãƒâ€žina Haina', 21.2819404602051, 0.371439932243976, -157.752502441406, -2.75330057086293, 218, 15, 'PPL', 'P'),
(211692, 'Ã‚â€˜Ãƒâ€žlewa Heights', 21.3430595397949, 0.372506661418607, -157.852783203125, -2.75505080033133, 218, 15, 'PPL', 'P'),
(211412, 'Ã‚â€˜Ãƒâ€žpua (historical)', 19.2613906860352, 0.336174685984283, -155.196105957031, -2.70868303522418, 218, 15, 'PPL', 'P'),
(210830, 'Ã‚â€˜Ãƒâ€“Ã‚â€˜ÃƒÂ¶kala', 20.0174999237061, 0.349371281686384, -155.287216186523, -2.71027320871107, 218, 15, 'PPL', 'P'),
(210820, 'Ã‚â€˜Ãƒâ€“maÃ‚â€˜opio', 20.7999992370605, 0.363028471099015, -156.328063964844, -2.72843942945482, 218, 15, 'PPL', 'P'),
(211326, 'Ã‚â€˜Ewa', 21.3425006866455, 0.372496907591115, -158.040283203125, -2.75832329267882, 218, 15, 'PPL', 'P'),
(211325, 'Ã‚â€˜Ewa Beach', 21.315559387207, 0.372026693211148, -158.007217407227, -2.7577461856706, 218, 15, 'PPL', 'P'),
(211327, 'Ã‚â€˜Ewa Gentry', 21.3441696166992, 0.372526035915537, -158.030822753906, -2.75815817669124, 218, 15, 'PPL', 'P'),
(211328, 'Ã‚â€˜Ewa Villages', 21.3455600738525, 0.372550303970971, -158.040832519531, -2.75833288005875, 218, 15, 'PPL', 'P'),
(211329, 'Ã‚â€˜Ewa-Schofield Junction', 21.3994407653809, 0.373490699441391, -157.981384277344, -2.75729531249805, 218, 15, 'PPL', 'P'),
(211109, 'Ã‚â€˜UalapuÃ‚â€˜e', 21.0658302307129, 0.367668097192097, -156.832504272461, -2.73724357370252, 218, 15, 'PPL', 'P'),
(211113, 'Ã‚â€˜UlaÃ‚â€˜ino (historical)', 20.8086109161377, 0.363178773253036, -156.058883666992, -2.72374134697582, 218, 15, 'PPL', 'P'),
(211121, 'Ã‚â€˜Umikoa', 19.9825000762939, 0.348760419111347, -155.38444519043, -2.71197017495767, 218, 15, 'PPL', 'P'),
(211122, 'Ã‚â€˜UmipaÃ‚â€˜a', 21.1097202301025, 0.368434122190144, -157.055557250977, -2.741136582584, 218, 15, 'PPL', 'P'),
(92393, 'B and E Colonia', 26.3560009002686, 0.459998993368276, -98.7539978027344, -1.72358241116496, 218, 51, 'PPL', 'P'),
(44535, 'B and J Trailer Park', 39.5180587768555, 0.689720239652771, -76.146110534668, -1.3290003414175, 218, 25, 'PPL', 'P'),
(92394, 'B and P Bridge Colonia', 26.0669994354248, 0.454954966263666, -97.9499969482422, -1.70954994906522, 218, 51, 'PPL', 'P'),
(195913, 'B and R Subdivision', 45.9127807617188, 0.801329193038302, -106.644439697266, -1.86129660166183, 218, 31, 'PPL', 'P'),
(39194, 'B and S Park Subdivision', 33.0108299255371, 0.576147671016497, -93.4561080932617, -1.63111679232714, 218, 22, 'PPL', 'P'),
(7211, 'B B Junction', 34.5813903808594, 0.603559122063492, -91.1047210693359, -1.59007734677096, 218, 4, 'PPL', 'P'),
(31714, 'B N Junction', 38.5616683959961, 0.673028078572372, -95.271110534668, -1.66279456086141, 218, 20, 'PPL', 'P'),
(206738, 'B Z Corner', 45.8502807617188, 0.800238362255806, -121.507781982422, -2.1207108623887, 218, 56, 'PPL', 'P'),
(195912, 'Babb', 48.860279083252, 0.852772743446063, -113.435829162598, -1.97982870861713, 218, 31, 'PPL', 'P'),
(206739, 'Babb', 47.4583282470703, 0.828304085403606, -117.656669616699, -2.05349627174258, 218, 56, 'PPL', 'P'),
(126802, 'Babb Corner', 43.6297187805176, 0.761482244439237, -70.4505615234375, -1.22959425846282, 218, 26, 'PPL', 'P'),
(124163, 'Babbatasset Village', 42.6666717529297, 0.744673902956284, -71.5791702270508, -1.24929219630753, 218, 23, 'PPL', 'P'),
(112885, 'Babbie', 31.2794399261475, 0.545929214891045, -86.3255615234375, -1.50666527721692, 218, 2, 'PPL', 'P'),
(193086, 'Babbit Winter', 34.6252784729004, 0.604325113772026, -110.832496643066, -1.93439198462707, 218, 5, 'PPL', 'P'),
(129631, 'Babbits Resort', 44.6674995422363, 0.779594935645084, -84.6127777099609, -1.47677156029689, 218, 27, 'PPL', 'P'),
(134052, 'Babbitt', 47.708610534668, 0.832672335381608, -91.9444427490234, -1.60473325488189, 218, 28, 'PPL', 'P'),
(144781, 'Babbitt', 40.8097190856934, 0.712263964859319, -74.0202789306641, -1.29189758058468, 218, 37, 'PPL', 'P'),
(189906, 'Babbitt', 38.5394401550293, 0.672640122580575, -118.636672973633, -2.07060055700166, 218, 39, 'PPL', 'P'),
(146941, 'Babbitt Corner', 42.836109161377, 0.747631143609735, -77.1847229003906, -1.34712754685128, 218, 40, 'PPL', 'P'),
(75043, 'Babbs', 34.9483299255371, 0.609963425273887, -99.0591735839844, -1.72890873334512, 218, 42, 'PPL', 'P'),
(84776, 'Babbs Mill', 36.2636108398438, 0.632919407817179, -82.7772216796875, -1.44473506396378, 218, 50, 'PPL', 'P'),
(53304, 'Babbtown', 38.3388900756836, 0.669139863380857, -92.1383285522461, -1.60811720052099, 218, 29, 'PPL', 'P'),
(71726, 'Babbtown (historical)', 39.9702796936035, 0.697612983596412, -84.1394424438477, -1.46851030143741, 218, 41, 'PPL', 'P'),
(19009, 'Babcock', 31.1122207641602, 0.543010689941941, -84.6416702270508, -1.47727582984929, 218, 13, 'PPL', 'P'),
(108059, 'Babcock', 38.0825004577637, 0.664665020380224, -80.8886108398438, -1.41177258651965, 218, 58, 'PPL', 'P'),
(118697, 'Babcock', 41.5294418334961, 0.724825496509978, -90.3958282470703, -1.57770483297867, 218, 18, 'PPL', 'P'),
(122179, 'Babcock', 41.5724983215332, 0.725576973990571, -87.1050033569336, -1.5202691035392, 218, 19, 'PPL', 'P'),
(129632, 'Babcock', 42.2172203063965, 0.736829495386428, -84.8000030517578, -1.48003925895441, 218, 27, 'PPL', 'P'),
(173025, 'Babcock', 44.3016700744629, 0.773210006931619, -90.1111068725586, -1.57273550754264, 218, 57, 'PPL', 'P'),
(206740, 'Babcock', 46.3258285522461, 0.808538236951092, -118.592216491699, -2.06982464501807, 218, 56, 'PPL', 'P'),
(146942, 'Babcock Hill', 42.9316711425781, 0.749299014821424, -75.2211074829102, -1.31285599257333, 218, 40, 'PPL', 'P'),
(146943, 'Babcock Lake', 42.8133316040039, 0.747233600238013, -73.4049987792969, -1.28115891612115, 218, 40, 'PPL', 'P'),
(44536, 'Babel Heights', 39.4880599975586, 0.689196662182461, -76.9686126708984, -1.3433557117994, 218, 25, 'PPL', 'P'),
(108060, 'Baber', 38.0083312988281, 0.663370524353364, -82.0458297729492, -1.43196986706876, 218, 58, 'PPL', 'P'),
(58522, 'Babington (historical)', 31.0541706085205, 0.541997523594734, -90.1788864135742, -1.57391848369885, 218, 30, 'PPL', 'P'),
(108061, 'Bablin', 38.7649993896484, 0.676576873882958, -80.4369430541992, -1.40388949653496, 218, 58, 'PPL', 'P'),
(15070, 'Babson Park', 27.8316707611084, 0.485754291112378, -81.5224990844727, -1.42283602347811, 218, 12, 'PPL', 'P'),
(124164, 'Babson Park', 42.2986106872559, 0.738250025511876, -71.2600021362305, -1.24372166225541, 218, 23, 'PPL', 'P'),
(92396, 'Baby Head (historical)', 30.8880596160889, 0.539098339853046, -98.6527786254883, -1.72181580325586, 218, 51, 'PPL', 'P'),
(206741, 'Baby Island Heights', 48.0963897705078, 0.839440359817881, -122.520278930664, -2.13838226780193, 218, 56, 'PPL', 'P'),
(193105, 'Baby Rocks', 36.7752799987793, 0.641849719321515, -110.008331298828, -1.92000758578928, 218, 5, 'PPL', 'P'),
(118698, 'Babylon', 40.5908317565918, 0.7084436602756, -90.3491668701172, -1.57689043831733, 218, 18, 'PPL', 'P'),
(146946, 'Babylon', 40.6955604553223, 0.710271520889776, -73.3261108398438, -1.27978206183758, 218, 40, 'PPL', 'P'),
(189907, 'Babylon (historical)', 39.2441711425781, 0.684939998654133, -115.513061523438, -2.01608325264276, 218, 39, 'PPL', 'P'),
(44537, 'Babylon Heights', 39.7069396972656, 0.693016833608126, -77.0888900756836, -1.34545494852866, 218, 25, 'PPL', 'P'),
(188100, 'Baca (historical)', 33.5366706848145, 0.585325323607074, -105.362777709961, -1.83892738008571, 218, 38, 'PPL', 'P'),
(193092, 'Bacavi', 35.9236106872559, 0.626985285697238, -110.656669616699, -1.93132322410297, 218, 5, 'PPL', 'P'),
(188103, 'Bacaville', 34.642219543457, 0.604620791232052, -106.779998779297, -1.86366255397426, 218, 38, 'PPL', 'P'),
(62652, 'Bacchus', 35.9277801513672, 0.627058056574024, -82.2055587768555, -1.43475766409785, 218, 33, 'PPL', 'P'),
(84777, 'Bacchus', 36.5091705322266, 0.637205232959444, -83.603889465332, -1.45916313864345, 218, 50, 'PPL', 'P'),
(202950, 'Bacchus', 40.6630592346191, 0.709704267577589, -112.095283508301, -1.95643177317635, 218, 52, 'PPL', 'P'),
(39195, 'Baccus', 32.9366683959961, 0.574853308147691, -93.4555587768555, -1.63110720494721, 218, 22, 'PPL', 'P'),
(129633, 'Bach', 43.6830596923828, 0.762413218977301, -83.355827331543, -1.4548336376593, 218, 27, 'PPL', 'P'),
(75044, 'Bache', 34.8941688537598, 0.609018136244964, -95.6483306884766, -1.66937829455025, 218, 42, 'PPL', 'P'),
(84778, 'Bachelder', 35.542781829834, 0.620338568248618, -87.3211135864258, -1.52404093859108, 218, 50, 'PPL', 'P'),
(53305, 'Bachelor', 38.9933280944824, 0.680561961559125, -91.7719421386719, -1.60172255126955, 218, 29, 'PPL', 'P'),
(62653, 'Bachelor', 34.9077796936035, 0.609255690214199, -76.7538909912109, -1.33960811151345, 218, 33, 'PPL', 'P'),
(200355, 'Bachelor Flat (historical)', 45.8480606079102, 0.800199613261945, -122.866668701172, -2.14442790979251, 218, 43, 'PPL', 'P'),
(112886, 'Bachelors Chapel', 34.0194396972656, 0.593751232400948, -85.870002746582, -1.49871427662443, 218, 2, 'PPL', 'P'),
(99576, 'Bachelors Hall', 36.6030616760254, 0.638843942557197, -79.5313873291016, -1.38808456757172, 218, 53, 'PPL', 'P'),
(34635, 'Bachelors Rest', 38.644718170166, 0.674477570574675, -84.2358322143555, -1.47019262029801, 218, 21, 'PPL', 'P'),
(19010, 'Bachlott', 31.1144409179688, 0.543049438935802, -82.0036087036133, -1.43123297039513, 218, 13, 'PPL', 'P'),
(71727, 'Bachman', 39.8627815246582, 0.695736786608451, -84.4572219848633, -1.4740566007236, 218, 41, 'PPL', 'P'),
(108062, 'Bachman', 38.0994415283203, 0.66496069784025, -81.1222229003906, -1.41584988614856, 218, 58, 'PPL', 'P'),
(79632, 'Bachman Chapel', 34.2519416809082, 0.597809157532929, -81.5077819824219, -1.42257916159097, 218, 48, 'PPL', 'P'),
(44538, 'Bachman Mills', 39.6624984741211, 0.69224118794064, -76.9472198486328, -1.34298233661458, 218, 25, 'PPL', 'P'),
(44539, 'Bachman Valley Estates', 39.6650009155273, 0.692284863782517, -76.9388885498047, -1.34283692801906, 218, 25, 'PPL', 'P'),
(158859, 'Bachmanville', 40.2425003051758, 0.70236412956014, -76.5950012207031, -1.33683496187035, 218, 45, 'PPL', 'P'),
(191097, 'Back', 35.3647193908691, 0.61723079241455, -100.609443664551, -1.75596605054616, 218, 51, 'PPL', 'P'),
(44540, 'Back Bay', 38.8305587768555, 0.67772110104531, -76.5388870239258, -1.33585558437947, 218, 25, 'PPL', 'P'),
(124165, 'Back Bay', 42.3499984741211, 0.739146911587988, -71.0875015258789, -1.24071095864308, 218, 23, 'PPL', 'P'),
(44541, 'Back Bay Beach', 38.8313903808594, 0.677735615273251, -76.5355606079102, -1.33579752746771, 218, 25, 'PPL', 'P'),
(7213, 'Back Gate', 33.9324989318848, 0.592233829790848, -91.3927764892578, -1.59510486227681, 218, 4, 'PPL', 'P'),
(19011, 'Back Landing', 31.1502799987793, 0.543674948896834, -81.4772186279297, -1.42204573042463, 218, 13, 'PPL', 'P'),
(158860, 'Back Mountain', 41.3358306884766, 0.72144634456083, -75.9966735839844, -1.32639217460393, 218, 45, 'PPL', 'P'),
(126803, 'Back Narrows', 43.8927803039551, 0.766073534158534, -69.5924987792969, -1.21461823838887, 218, 26, 'PPL', 'P'),
(44542, 'Back River', 39.3005599975586, 0.685924169834972, -76.4936065673828, -1.33506529132599, 218, 25, 'PPL', 'P'),
(99578, 'Back River', 37.0602798461914, 0.646823905026538, -76.3386077880859, -1.33236005229069, 218, 53, 'PPL', 'P'),
(44543, 'Back River Highlands', 39.3147201538086, 0.686171311184131, -76.480827331543, -1.33484225158469, 218, 25, 'PPL', 'P'),
(126805, 'Back Settlement', 45.5386085510254, 0.794798655992237, -68.3191680908203, -1.19239442540826, 218, 26, 'PPL', 'P'),
(79633, 'Back Swamp', 34.273609161377, 0.59818732640772, -79.7261123657227, -1.39148316059683, 218, 48, 'PPL', 'P'),
(99579, 'Back Swamp', 39.2055587768555, 0.684266085740289, -77.5369415283203, -1.35327492159551, 218, 53, 'PPL', 'P'),
(99580, 'Backbone', 37.7730598449707, 0.659264262847598, -80.1555633544922, -1.3989784943268, 218, 53, 'PPL', 'P'),
(112890, 'Backems Crossroads', 31.2416706085205, 0.545270015942223, -85.6305618286133, -1.49453524424188, 218, 2, 'PPL', 'P'),
(112889, 'Backers Landing', 31.8083305358887, 0.55516009741391, -87.4577789306641, -1.52642619882141, 218, 2, 'PPL', 'P'),
(139629, 'Backoo', 48.836669921875, 0.852360685846401, -97.7099990844727, -1.70536119614469, 218, 34, 'PPL', 'P'),
(158861, 'Backup Corners', 41.9172210693359, 0.73159352094625, -79.1502838134766, -1.38143305643314, 218, 45, 'PPL', 'P'),
(108063, 'Backus', 37.8541717529297, 0.660679932704056, -80.9749984741211, -1.4132803351708, 218, 58, 'PPL', 'P'),
(134054, 'Backus', 46.8202781677246, 0.817168010726412, -94.51611328125, -1.64961737294575, 218, 28, 'PPL', 'P'),
(146945, 'Backus', 44.1694412231445, 0.770902178109984, -75.2813873291016, -1.31390807436196, 218, 40, 'PPL', 'P'),
(158862, 'Backus', 41.8022193908691, 0.729586363011685, -78.5641708374023, -1.37120345521198, 218, 45, 'PPL', 'P'),
(129634, 'Backus Beach', 44.7599983215332, 0.78120934389789, -83.5461120605469, -1.45815473269669, 218, 27, 'PPL', 'P'),
(177463, 'Backus Corner', 41.5144386291504, 0.724563641195796, -72.1050033569336, -1.25846971574006, 218, 8, 'PPL', 'P'),
(34636, 'Backusburg', 36.7058296203613, 0.640637581551365, -88.4683303833008, -1.54406364893074, 218, 21, 'PPL', 'P'),
(84779, 'Backwoods', 36.1761093139648, 0.631392218090074, -82.1502838134766, -1.43379293399297, 218, 50, 'PPL', 'P'),
(92397, 'Bacliff', 29.5066699981689, 0.514988542767477, -94.9922180175781, -1.65792696817902, 218, 51, 'PPL', 'P'),
(29137, 'Bacon', 38.4105606079102, 0.670390750144867, -86.4333267211914, -1.50854613473679, 218, 19, 'PPL', 'P'),
(53306, 'Bacon', 38.708610534668, 0.675592702702119, -92.4533309936523, -1.61361503027535, 218, 29, 'PPL', 'P'),
(92398, 'Bacon', 33.9933280944824, 0.593295498959408, -98.5449981689453, -1.71993467941988, 218, 51, 'PPL', 'P'),
(154161, 'Bacon', 40.2208290100098, 0.701985894106322, -81.7755584716797, -1.42725274298795, 218, 41, 'PPL', 'P'),
(194545, 'Bacon', 44.6361083984375, 0.779047056829827, -116.546943664551, -2.03412790008276, 218, 17, 'PPL', 'P'),
(206742, 'Bacon', 47.5008316040039, 0.829045908925247, -119.329170227051, -2.08268691413483, 218, 56, 'PPL', 'P'),
(58523, 'Bacon (historical)', 33.985279083252, 0.593155017211907, -88.8402786254883, -1.55055537040391, 218, 30, 'PPL', 'P'),
(71729, 'Bacon Flat', 38.961669921875, 0.680009422211961, -83.3627777099609, -1.45495494464696, 218, 41, 'PPL', 'P'),
(112379, 'Bacon Hall', 39.5713882446289, 0.690651014453754, -76.6822204589844, -1.33835722474943, 218, 25, 'PPL', 'P'),
(44544, 'Bacon Hill', 39.603889465332, 0.691218267765941, -75.8927764892578, -1.32457882821769, 218, 25, 'PPL', 'P'),
(146947, 'Bacon Hill', 43.1333312988281, 0.752818648518073, -73.6061096191406, -1.28466896243787, 218, 40, 'PPL', 'P'),
(112888, 'Bacon Level', 33.1286087036133, 0.578203298482902, -85.2908325195313, -1.48860584923287, 218, 2, 'PPL', 'P'),
(112512, 'Bacon Mill', 39.8175010681152, 0.69494649355497, -76.5363922119141, -1.33581204169565, 218, 45, 'PPL', 'P'),
(58524, 'Bacon Springs', 34.8711090087891, 0.608615666025225, -88.1361083984375, -1.53826528144736, 218, 30, 'PPL', 'P'),
(200356, 'Bacona', 45.7775001525879, 0.798968100994865, -123.120826721191, -2.1488638040622, 218, 43, 'PPL', 'P'),
(75045, 'Bacone', 35.7669410705566, 0.624250885047999, -95.3399963378906, -1.66399684493553, 218, 42, 'PPL', 'P'),
(13314, 'Bacons', 38.5083312988281, 0.672097170613335, -75.5699996948242, -1.31894531040579, 218, 10, 'PPL', 'P'),
(99583, 'Bacons Fork', 36.8522186279297, 0.64319255172216, -78.0602798461914, -1.36240889834421, 218, 53, 'PPL', 'P'),
(99586, 'Bacons Quarters (historical)', 37.4911117553711, 0.654343340364376, -76.605827331543, -1.33702391314969, 218, 53, 'PPL', 'P'),
(19013, 'Baconton', 31.3794403076172, 0.547674550800942, -84.1611099243164, -1.4688884703122, 218, 13, 'PPL', 'P'),
(124166, 'Baconville', 42.4230613708496, 0.740422099696945, -72.4422225952148, -1.26435530174913, 218, 23, 'PPL', 'P'),
(58526, 'Bacots', 31.2124996185303, 0.544760886120827, -90.3841705322266, -1.57750136747139, 218, 30, 'PPL', 'P'),
(99584, 'Bacova', 38.0538902282715, 0.664165677675834, -79.8438873291016, -1.3935387214842, 218, 53, 'PPL', 'P'),
(99585, 'Bacova Junction', 38.0102806091309, 0.663404546236289, -79.8747177124023, -1.39407681318245, 218, 53, 'PPL', 'P'),
(158863, 'Bacton', 40.0566711425781, 0.699120798826587, -75.586669921875, -1.31923626075488, 218, 45, 'PPL', 'P'),
(114484, 'Baculis Mobile Home Park', 41.6319389343262, 0.726614408393211, -91.5361099243164, -1.59760650264678, 218, 16, 'PPL', 'P'),
(129636, 'Bad Axe', 43.8019409179688, 0.764488087782582, -83.0008316040039, -1.44863779338323, 218, 27, 'PPL', 'P'),
(201880, 'Bad Wound', 43.3002815246582, 0.755732479645756, -101.759437561035, -1.77603723041765, 218, 49, 'PPL', 'P'),
(154162, 'Baddow Pass (historical)', 40.4944381713867, 0.70676127483597, -82.148063659668, -1.43375418499911, 218, 41, 'PPL', 'P'),
(19014, 'Baden', 30.7172203063965, 0.53611663140708, -83.5652770996094, -1.4584892257296, 218, 13, 'PPL', 'P'),
(44545, 'Baden', 38.6591682434082, 0.674729771929906, -76.7780609130859, -1.34002995623011, 218, 25, 'PPL', 'P'),
(53308, 'Baden', 38.7055587768555, 0.675539439480317, -90.2300033569336, -1.57481064266403, 218, 29, 'PPL', 'P'),
(99587, 'Baden', 37.1344413757324, 0.648118267895344, -82.5325012207031, -1.44046388620751, 218, 53, 'PPL', 'P'),
(108064, 'Baden', 38.7983283996582, 0.677158574844058, -81.8874969482422, -1.42920643796363, 218, 58, 'PPL', 'P'),
(134058, 'Baden', 47.0102806091309, 0.820484178915779, -92.5883331298828, -1.6159712620498, 218, 28, 'PPL', 'P'),
(158864, 'Baden', 40.6349983215332, 0.709214512253124, -80.2283325195313, -1.40024855585066, 218, 45, 'PPL', 'P'),
(197961, 'Baden', 48.5872192382813, 0.848006950096339, -102.003608703613, -1.780298820794, 218, 34, 'PPL', 'P'),
(44546, 'Baden Estates', 38.5911102294922, 0.673541935504703, -76.5305633544922, -1.33571030894201, 218, 25, 'PPL', 'P'),
(92400, 'Bader', 29.3713893890381, 0.51262745072404, -98.9544372558594, -1.72708073957289, 218, 51, 'PPL', 'P'),
(118700, 'Bader', 40.1730613708496, 0.701152191527072, -90.3686065673828, -1.5772297250402, 218, 18, 'PPL', 'P'),
(53309, 'Baderville', 36.5544395446777, 0.637995326275843, -89.7369384765625, -1.5662050370756, 218, 29, 'PPL', 'P'),
(31716, 'Badger', 37.1583290100098, 0.648535185763995, -94.6324996948242, -1.65164869906721, 218, 20, 'PPL', 'P'),
(34637, 'Badger', 37.4544410705566, 0.653703316175403, -85.5313873291016, -1.49280432269138, 218, 21, 'PPL', 'P'),
(114483, 'Badger', 42.6144409179688, 0.743762302915149, -94.1458282470703, -1.64315467992846, 218, 16, 'PPL', 'P'),
(134057, 'Badger', 48.7825012207031, 0.851415263659423, -96.0141677856445, -1.67576335642177, 218, 28, 'PPL', 'P'),
(141225, 'Badger', 40.0883293151855, 0.699673338173751, -96.5952835083008, -1.68590573911723, 218, 35, 'PPL', 'P'),
(169777, 'Badger', 44.485279083252, 0.776414588671311, -97.2044372558594, -1.69653747766299, 218, 49, 'PPL', 'P'),
(179888, 'Badger', 36.6313896179199, 0.63933835841357, -119.012222290039, -2.07715512907657, 218, 6, 'PPL', 'P'),
(191098, 'Badger', 31.728889465332, 0.553773589171387, -102.613891601563, -1.79095026673182, 218, 51, 'PPL', 'P'),
(206743, 'Badger', 46.2002792358398, 0.806346988006175, -119.358329772949, -2.08319584421914, 218, 56, 'PPL', 'P'),
(209284, 'Badger Basin', 44.9258308410645, 0.784103667370588, -109.07250213623, -1.90367428566577, 218, 59, 'PPL', 'P'),
(200357, 'Badger Corner', 44.9502792358398, 0.784530372356246, -122.982223510742, -2.14644472168603, 218, 43, 'PPL', 'P'),
(122181, 'Badger Grove', 40.583610534668, 0.708317626177012, -86.9636077880859, -1.51780128531508, 218, 19, 'PPL', 'P'),
(179889, 'Badger Hill (historical)', 39.3836097717285, 0.687373661837275, -121.024436950684, -2.11227490016172, 218, 6, 'PPL', 'P'),
(186376, 'Badger House Community (historical)', 37.1886100769043, 0.649063690082322, -108.533889770508, -1.89427372649195, 218, 7, 'PPL', 'P'),
(154165, 'Badgertown', 40.0297203063965, 0.698650417999052, -81.0822219848633, -1.4151517384688, 218, 41, 'PPL', 'P'),
(79634, 'Badham', 33.1955604553223, 0.579371826990202, -80.6113891601563, -1.40693415545119, 218, 48, 'PPL', 'P'),
(62656, 'Badin', 35.4058303833008, 0.617948314591245, -80.116943359375, -1.3983044482549, 218, 33, 'PPL', 'P'),
(186377, 'Badito', 37.7272186279297, 0.658464182677111, -105.013610839844, -1.83283326856328, 218, 7, 'PPL', 'P'),
(201882, 'Badnation', 43.651668548584, 0.761865340162045, -100.369438171387, -1.75177716446757, 218, 49, 'PPL', 'P'),
(53311, 'Bado', 37.2691688537598, 0.650469705979829, -92.1233291625977, -1.60785541178584, 218, 29, 'PPL', 'P'),
(75046, 'Bado', 36.2169418334961, 0.632104879997779, -98.7425003051758, -1.72338174197682, 218, 42, 'PPL', 'P'),
(134060, 'Badoura', 46.8622207641602, 0.817900047131048, -94.7658309936523, -1.65397576922772, 218, 28, 'PPL', 'P'),
(179890, 'Badwater', 36.2297210693359, 0.632327919739073, -116.76611328125, -2.03795313151449, 218, 6, 'PPL', 'P'),
(209285, 'Badwater', 43.3227806091309, 0.756125162748488, -107.426940917969, -1.87495382436397, 218, 59, 'PPL', 'P'),
(158869, 'Baederwood', 40.1066703796387, 0.699993450136779, -75.1425018310547, -1.31148406513777, 218, 45, 'PPL', 'P'),
(58527, 'Bafrick (historical)', 32.1694412231445, 0.561462667870664, -89.845832824707, -1.56810560198754, 218, 30, 'PPL', 'P'),
(92399, 'Bagby', 33.4844398498535, 0.58441372356594, -95.9191665649414, -1.67410527232709, 218, 51, 'PPL', 'P'),
(99588, 'Bagby', 37.9261093139648, 0.661935479999974, -77.2316665649414, -1.34794686836065, 218, 53, 'PPL', 'P'),
(15071, 'Bagdad', 30.5986099243164, 0.534046489712734, -87.0311126708984, -1.51897946778133, 218, 12, 'PPL', 'P'),
(34638, 'Bagdad', 38.2622184753418, 0.667801691512119, -85.0577774047852, -1.48453827014194, 218, 21, 'PPL', 'P'),
(39196, 'Bagdad', 31.4663906097412, 0.54919211985861, -92.5936126708984, -1.61606340742352, 218, 22, 'PPL', 'P'),
(99589, 'Bagdad', 37.9052810668945, 0.661571958511179, -77.4236068725586, -1.35129685869586, 218, 53, 'PPL', 'P'),
(146949, 'Bagdad', 42.482780456543, 0.741464394368575, -78.920280456543, -1.37741874056401, 218, 40, 'PPL', 'P'),
(158867, 'Bagdad', 40.6530609130859, 0.709529763947162, -79.6444396972656, -1.39005770362336, 218, 45, 'PPL', 'P'),
(179891, 'Bagdad', 34.5827789306641, 0.603583356829412, -115.874717712402, -2.02239534390041, 218, 6, 'PPL', 'P'),
(193099, 'Bagdad', 34.5811080932617, 0.603554195215475, -113.203887939453, -1.97578057060216, 218, 5, 'PPL', 'P'),
(84780, 'Bagdad (historical)', 36.3694381713867, 0.634766443191204, -85.8277816772461, -1.49797737995081, 218, 50, 'PPL', 'P'),
(206744, 'Bagdad Junction', 47.8738899230957, 0.835557004895355, -118.936393737793, -2.07583167117285, 218, 56, 'PPL', 'P'),
(158868, 'Baggaley', 40.2683296203613, 0.702814936153663, -79.3727798461914, -1.38531634477664, 218, 45, 'PPL', 'P'),
(191099, 'Bagge Estates Colonia', 31.6700000762939, 0.552745775438185, -106.283996582031, -1.85500568253484, 218, 51, 'PPL', 'P'),
(39197, 'Baggett (historical)', 30.7638893127441, 0.536931159226481, -93.0027770996094, -1.62320467388657, 218, 22, 'PPL', 'P'),
(79636, 'Baggette Crossroads', 33.6266708374023, 0.58689612259703, -80.1374969482422, -1.39866317605373, 218, 48, 'PPL', 'P'),
(84781, 'Baggettsville', 36.4766693115234, 0.636637979647257, -86.7302780151367, -1.51372891253419, 218, 50, 'PPL', 'P'),
(209286, 'Baggs', 41.035831451416, 0.716210370120653, -107.656936645508, -1.87896800707505, 218, 59, 'PPL', 'P'),
(146948, 'Baggs Corner', 43.9569396972656, 0.767193326817885, -76.0580596923828, -1.32746356431047, 218, 40, 'PPL', 'P'),
(143485, 'Baglett Grove', 42.8830604553223, 0.748450598277152, -71.1797180175781, -1.24232044004787, 218, 36, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(44547, 'Bagley', 39.4983291625977, 0.689375892923824, -76.398063659668, -1.33339775300943, 218, 25, 'PPL', 'P'),
(62657, 'Bagley', 35.5763893127441, 0.620925129478708, -78.1697235107422, -1.36431905063607, 218, 33, 'PPL', 'P'),
(112891, 'Bagley', 33.7555618286133, 0.58914569476982, -87.0016708374023, -1.518465610849, 218, 2, 'PPL', 'P'),
(114486, 'Bagley', 41.8461112976074, 0.730352421299246, -94.4297180175781, -1.64810949113655, 218, 16, 'PPL', 'P'),
(129638, 'Bagley', 45.5513916015625, 0.795021762312559, -87.5755615234375, -1.52848189286685, 218, 27, 'PPL', 'P'),
(134062, 'Bagley', 47.521671295166, 0.829409630151125, -95.398063659668, -1.66501031088836, 218, 28, 'PPL', 'P'),
(143486, 'Bagley', 43.2666702270508, 0.755145851836639, -71.779167175293, -1.2527828015483, 218, 36, 'PPL', 'P'),
(173026, 'Bagley', 42.9055595397949, 0.748843281379884, -91.1011123657227, -1.59001436301118, 218, 57, 'PPL', 'P'),
(173027, 'Bagley Junction', 45.1383285522461, 0.78781245208366, -87.751106262207, -1.53154572654293, 218, 57, 'PPL', 'P'),
(206745, 'Bagley Junction', 47.3936080932617, 0.827174505627249, -121.845001220703, -2.12659644839778, 218, 56, 'PPL', 'P'),
(112892, 'Bagley Meadows', 33.7538909912109, 0.589116533155883, -86.9938888549805, -1.51832978963341, 218, 2, 'PPL', 'P'),
(99590, 'Bagleys Mills', 36.8400001525879, 0.642979299097872, -78.1900024414063, -1.36467298474494, 218, 53, 'PPL', 'P'),
(44548, 'Bagleys Venture', 39.4963912963867, 0.68934207077798, -76.3952789306641, -1.33334915031954, 218, 25, 'PPL', 'P'),
(129640, 'Bagnall', 44.4272193908691, 0.775401255876536, -85.7586135864258, -1.49677016902867, 218, 27, 'PPL', 'P'),
(53312, 'Bagnell', 38.2266693115234, 0.667181241557158, -92.6013870239258, -1.61619909548106, 218, 29, 'PPL', 'P'),
(200358, 'Bagnell Ferry', 42.4666709899902, 0.74118323113649, -124.366668701172, -2.17060784857243, 218, 43, 'PPL', 'P'),
(44549, 'Bagtown', 39.5816688537598, 0.690830444932198, -77.6108322143555, -1.35456455735338, 218, 25, 'PPL', 'P'),
(92401, 'Bagwell', 33.6619415283203, 0.587511712283001, -95.1605606079102, -1.66086510065165, 218, 51, 'PPL', 'P'),
(62658, 'Bahama', 36.165828704834, 0.631212787611629, -78.8769378662109, -1.37666226965637, 218, 33, 'PPL', 'P'),
(15072, 'Bahama Beach', 30.1972198486328, 0.527040911307226, -85.8424987792969, -1.49823424183794, 218, 12, 'PPL', 'P'),
(62659, 'Bahama Park', 35.3227806091309, 0.616498822588942, -80.8591690063477, -1.41125872958732, 218, 33, 'PPL', 'P'),
(44550, 'Bahama View', 38.8286094665527, 0.677687079162384, -76.543327331543, -1.33593308236719, 218, 25, 'PPL', 'P'),
(179892, 'Bahia', 38.0966682434082, 0.664912294887438, -122.101936340332, -2.13108081219931, 218, 6, 'PPL', 'P'),
(169269, 'Bahia Corner', 41.4944381713867, 0.724214567355913, -71.1622161865234, -1.24201497547084, 218, 47, 'PPL', 'P'),
(15073, 'Bahia Oaks', 29.1263904571533, 0.508351412698782, -82.216667175293, -1.43495154222521, 218, 12, 'PPL', 'P'),
(15074, 'Bahia Shores', 27.735559463501, 0.484076832520764, -82.7388916015625, -1.44406607789795, 218, 12, 'PPL', 'P'),
(15075, 'Bahia Subdivision', 28.7772197723389, 0.502257234597326, -81.3633270263672, -1.42005794698699, 218, 12, 'PPL', 'P'),
(53314, 'Bahner', 38.5694389343262, 0.673163700050885, -93.1283264160156, -1.62539592283148, 218, 29, 'PPL', 'P'),
(15076, 'Bahoma', 30.8144397735596, 0.53781343120611, -85.508056640625, -1.49239712536071, 218, 12, 'PPL', 'P'),
(177465, 'Bahre Corner', 41.8450012207031, 0.730333046802316, -72.9005584716797, -1.27235477187346, 218, 8, 'PPL', 'P'),
(158871, 'Baidland', 40.1947212219238, 0.701530227243809, -79.9711074829102, -1.39575913204306, 218, 45, 'PPL', 'P'),
(129641, 'Baie de Wasai', 46.4613914489746, 0.810904255842546, -84.2447204589844, -1.47034774943151, 218, 27, 'PPL', 'P'),
(44551, 'Baie Holm', 38.8480606079102, 0.678026565622342, -76.3675003051758, -1.33286432184309, 218, 25, 'PPL', 'P'),
(44552, 'Baile', 39.5149993896484, 0.689666843272915, -77.0583267211914, -1.34492151736232, 218, 25, 'PPL', 'P'),
(7215, 'Bailes (historical)', 35.1347198486328, 0.613216543124446, -90.5638885498047, -1.58063803860328, 218, 4, 'PPL', 'P'),
(44553, 'Bailes Mill', 39.5311088562012, 0.689948006505, -77.0583267211914, -1.34492151736232, 218, 25, 'PPL', 'P'),
(7216, 'Bailey', 35.541389465332, 0.620314266903671, -91.4958267211914, -1.596903428119, 218, 4, 'PPL', 'P'),
(15077, 'Bailey', 30.5680599212646, 0.533513291572987, -83.5919418334961, -1.45895461313009, 218, 12, 'PPL', 'P'),
(19015, 'Bailey', 34.274169921875, 0.598197113524726, -83.7747192382813, -1.46214468064184, 218, 13, 'PPL', 'P'),
(39198, 'Bailey', 30.8788890838623, 0.538938283871533, -90.3383331298828, -1.57670135387993, 218, 22, 'PPL', 'P'),
(53313, 'Bailey', 38.2249984741211, 0.667152079943222, -90.4313888549805, -1.57832548267071, 218, 29, 'PPL', 'P'),
(58528, 'Bailey', 32.4674987792969, 0.56666475358597, -88.7227783203125, -1.5485046032065, 218, 30, 'PPL', 'P'),
(62661, 'Bailey', 35.7805595397949, 0.624488572175288, -78.1191711425781, -1.36343674536693, 218, 33, 'PPL', 'P'),
(75047, 'Bailey', 34.7161102294922, 0.605910426989923, -97.7977828979492, -1.70689331271982, 218, 42, 'PPL', 'P'),
(84782, 'Bailey', 35.0508308410645, 0.611752403736148, -89.7286071777344, -1.56605962848008, 218, 50, 'PPL', 'P'),
(92402, 'Bailey', 33.4319381713867, 0.583497396413871, -96.1655578613281, -1.67840561169729, 218, 51, 'PPL', 'P'),
(99591, 'Bailey', 37.2241706848145, 0.649684339774365, -81.3861083984375, -1.42045555693774, 218, 53, 'PPL', 'P'),
(114487, 'Bailey', 43.4650001525879, 0.758607362042496, -92.607780456543, -1.61631068193073, 218, 16, 'PPL', 'P'),
(129642, 'Bailey', 43.2777786254883, 0.755339729963996, -85.8102798461914, -1.49767191537377, 218, 27, 'PPL', 'P'),
(134064, 'Bailey', 45.3169403076172, 0.790929815297652, -93.6650009155273, -1.63476265985946, 218, 28, 'PPL', 'P'),
(146950, 'Bailey', 43.0724983215332, 0.751756912770486, -77.6602783203125, -1.35542755470462, 218, 40, 'PPL', 'P'),
(154163, 'Bailey', 41.4619407653809, 0.723647380622754, -83.7877807617188, -1.46237264723115, 218, 41, 'PPL', 'P'),
(158870, 'Bailey', 40.473331451416, 0.706392893078185, -77.0716705322266, -1.34515441079964, 218, 45, 'PPL', 'P'),
(186378, 'Bailey', 39.4055595397949, 0.687756757560083, -105.472778320313, -1.84084725291555, 218, 7, 'PPL', 'P'),
(199819, 'Bailey (historical)', 40.3875007629395, 0.704894864965015, -117.052223205566, -2.04294669171645, 218, 39, 'PPL', 'P'),
(7217, 'Bailey Addition', 35.0369415283203, 0.611509989497924, -92.0374984741211, -1.60635738367267, 218, 4, 'PPL', 'P'),
(177466, 'Bailey Beach', 41.4952812194824, 0.724229281320936, -72.4244384765625, -1.26404491032408, 218, 8, 'PPL', 'P'),
(62662, 'Bailey Camp', 36.1044387817383, 0.630141331326063, -81.646110534668, -1.42499345027718, 218, 33, 'PPL', 'P'),
(126806, 'Bailey Corner', 44.1722183227539, 0.770950647641823, -69.745002746582, -1.21727993474034, 218, 26, 'PPL', 'P'),
(112893, 'Bailey Cove Estates', 34.6650009155273, 0.605018401182801, -86.5441665649414, -1.51048065495262, 218, 2, 'PPL', 'P'),
(34639, 'Bailey Creek', 36.8788909912109, 0.643658072280706, -83.190559387207, -1.45194916788264, 218, 21, 'PPL', 'P'),
(112895, 'Bailey Crossroads', 31.1908302307129, 0.544382683956523, -85.5938873291016, -1.49389515347388, 218, 2, 'PPL', 'P'),
(7219, 'Bailey Estates', 34.9022216796875, 0.609158684571493, -92.0188903808594, -1.60603261117774, 218, 4, 'PPL', 'P'),
(118704, 'Bailey Falls (historical)', 41.2772216796875, 0.720423424386131, -89.0441665649414, -1.55411388625248, 218, 18, 'PPL', 'P'),
(179894, 'Bailey Flats (historical)', 37.3430595397949, 0.6517593417377, -119.811111450195, -2.09109837527979, 218, 6, 'PPL', 'P'),
(15078, 'Bailey Hall', 27.2830600738525, 0.476179228308134, -82.5630569458008, -1.4409971842158, 218, 12, 'PPL', 'P'),
(126807, 'Bailey Island', 43.7275009155273, 0.763188864644787, -69.9955596923828, -1.22165297840831, 218, 26, 'PPL', 'P'),
(154164, 'Bailey Lake', 40.9458312988281, 0.714639571130697, -82.3597183227539, -1.43744825574716, 218, 41, 'PPL', 'P'),
(171701, 'Bailey Mills', 43.5052795410156, 0.75931036999125, -72.5702819824219, -1.26659035969398, 218, 55, 'PPL', 'P'),
(92403, 'Bailey Prairie', 29.1516704559326, 0.508792631912381, -95.5086135864258, -1.66693977109812, 218, 51, 'PPL', 'P'),
(112902, 'Bailey Springs', 34.8955612182617, 0.609042437589911, -87.5713882446289, -1.52840905541103, 218, 2, 'PPL', 'P'),
(62663, 'Bailey Town', 36.3194389343262, 0.633893791881012, -80.1425018310547, -1.39875052773749, 218, 33, 'PPL', 'P'),
(84783, 'Bailey Town', 35.957218170166, 0.627571846927328, -83.2808303833008, -1.45352469398353, 218, 50, 'PPL', 'P'),
(79637, 'Bailey Town (historical)', 34.8061103820801, 0.607481225979879, -81.540283203125, -1.42314641490316, 218, 48, 'PPL', 'P'),
(191101, 'Baileyboro', 34.026668548584, 0.593877399657591, -102.81916809082, -1.79453301734631, 218, 51, 'PPL', 'P'),
(99592, 'Baileys', 37.3863906860352, 0.652515612908255, -76.4625015258789, -1.33452240593778, 218, 53, 'PPL', 'P'),
(143487, 'Baileys', 44.4072189331055, 0.775052182036654, -71.5055618286133, -1.24800748739768, 218, 36, 'PPL', 'P'),
(99593, 'Baileys Beach', 37.083610534668, 0.647231102357211, -76.6641693115234, -1.33804217279248, 218, 53, 'PPL', 'P'),
(113066, 'Baileys Corner', 42.0250015258789, 0.733474644782228, -70.6980590820313, -1.23391390575093, 218, 23, 'PPL', 'P'),
(122182, 'Baileys Corner', 41.0708312988281, 0.71682123269569, -86.9983291625977, -1.51840728762113, 218, 19, 'PPL', 'P'),
(143488, 'Baileys Corner', 43.1055603027344, 0.752333953199679, -71.581672668457, -1.24933587214941, 218, 36, 'PPL', 'P'),
(144782, 'Baileys Corner', 40.1527786254883, 0.700798190839174, -74.0725021362305, -1.29280904746775, 218, 37, 'PPL', 'P'),
(99594, 'Baileys Crossroads', 38.8502807617188, 0.678065314616203, -77.129997253418, -1.34617240412633, 218, 53, 'PPL', 'P'),
(146951, 'Baileys Gap', 41.6919403076172, 0.727661629912857, -74.0005569458008, -1.29155336701378, 218, 40, 'PPL', 'P'),
(173030, 'Baileys Harbor', 45.064998626709, 0.786532603442795, -87.1241683959961, -1.52060359657212, 218, 57, 'PPL', 'P'),
(13313, 'Baileys Landing', 38.5722198486328, 0.673212236161751, -75.6438903808594, -1.32023494616366, 218, 10, 'PPL', 'P'),
(79638, 'Baileys Landing', 32.3458290100098, 0.564541215511768, -80.8874969482422, -1.41175314544369, 218, 48, 'PPL', 'P'),
(112907, 'Baileys Landing', 31.4147205352783, 0.548290306934482, -87.5933303833008, -1.52879201797579, 218, 2, 'PPL', 'P'),
(71730, 'Baileys Mills', 39.9558296203613, 0.697360782241181, -81.228889465332, -1.41771156890858, 218, 41, 'PPL', 'P'),
(171700, 'Baileys Mills', 43.297779083252, 0.755688803803879, -72.6052780151367, -1.26720115568999, 218, 55, 'PPL', 'P'),
(19016, 'Baileys Park', 32.3113899230957, 0.563940140053737, -83.3525009155273, -1.45477558074754, 218, 13, 'PPL', 'P'),
(146952, 'Baileys Settlement', 42.8869400024414, 0.748518309147868, -76.1563873291016, -1.32917970531691, 218, 40, 'PPL', 'P'),
(206746, 'Baileysburg', 46.2991714477539, 0.808072982708655, -117.951667785645, -2.05864496107803, 218, 56, 'PPL', 'P'),
(108065, 'Baileysville', 37.589168548584, 0.656054754259889, -81.679443359375, -1.42557521781731, 218, 58, 'PPL', 'P'),
(84784, 'Baileyton', 36.334171295166, 0.634150920084259, -82.8369369506836, -1.44577729205638, 218, 50, 'PPL', 'P'),
(112901, 'Baileyton', 34.2622184753418, 0.597988521432346, -86.6127777099609, -1.51167814533677, 218, 2, 'PPL', 'P'),
(70482, 'Baileytown', 39.3194389343262, 0.686253669440842, -75.0733337402344, -1.31027685421564, 218, 37, 'PPL', 'P'),
(99595, 'Baileytown', 36.8047218322754, 0.642363576253846, -76.5113906860352, -1.33537568275104, 218, 53, 'PPL', 'P'),
(112909, 'Baileytown', 34.1636085510254, 0.596267453577882, -86.6597213745117, -1.51249746684614, 218, 2, 'PPL', 'P'),
(146953, 'Baileytown', 41.3080596923828, 0.720961649242436, -74.081672668457, -1.29296910344927, 218, 40, 'PPL', 'P'),
(31717, 'Baileyville', 39.8444404602051, 0.695416674645423, -96.1847229003906, -1.67874010473021, 218, 20, 'PPL', 'P'),
(92404, 'Baileyville', 31.0524997711182, 0.541968361980798, -96.8283309936523, -1.68997318505011, 218, 51, 'PPL', 'P'),
(118701, 'Baileyville', 42.1972198486328, 0.736480421546546, -89.5933303833008, -1.56369860301567, 218, 18, 'PPL', 'P'),
(146954, 'Baileyville', 41.4722213745117, 0.723826811101198, -74.48388671875, -1.29998906292466, 218, 40, 'PPL', 'P'),
(158872, 'Baileyville', 40.7080612182617, 0.710489700362081, -77.9855575561523, -1.3611047483584, 218, 45, 'PPL', 'P'),
(177464, 'Baileyville', 41.5130615234375, 0.724539606166958, -72.7249984741211, -1.26929067188127, 218, 8, 'PPL', 'P'),
(99596, 'Baileyville (historical)', 37.0961112976074, 0.647449281829516, -78.8405609130859, -1.3760273720525, 218, 53, 'PPL', 'P'),
(179895, 'Bailhache', 38.6036109924316, 0.673760114977008, -122.853607177734, -2.1441999432032, 218, 6, 'PPL', 'P'),
(84785, 'Bain', 36.1669387817383, 0.63123216210856, -88.148063659668, -1.53847394011877, 218, 50, 'PPL', 'P'),
(134065, 'Bain', 46.790828704834, 0.816654020636027, -93.5894393920898, -1.63344386248765, 218, 28, 'PPL', 'P'),
(31718, 'Bain City', 39.2838897705078, 0.685633219485881, -94.9036102294922, -1.65638047053401, 218, 20, 'PPL', 'P'),
(209288, 'Bain Place', 43.5013885498047, 0.759242459383453, -109.465560913086, -1.91053445547576, 218, 59, 'PPL', 'P'),
(19017, 'Bainbridge', 30.9036102294922, 0.539369749257639, -84.5755615234375, -1.47612201530702, 218, 13, 'PPL', 'P'),
(26431, 'Bainbridge', 37.7338905334473, 0.658580629395774, -88.9930572509766, -1.55322186044535, 218, 18, 'PPL', 'P'),
(29138, 'Bainbridge', 39.7611083984375, 0.693962255795104, -86.8119430541992, -1.5151542363496, 218, 19, 'PPL', 'P'),
(34640, 'Bainbridge', 36.9955596923828, 0.645694325250181, -87.6611099243164, -1.529974994132, 218, 21, 'PPL', 'P'),
(44554, 'Bainbridge', 38.3916702270508, 0.670061050801915, -75.1738891601563, -1.312031877374, 218, 25, 'PPL', 'P'),
(53315, 'Bainbridge', 37.4105606079102, 0.652937457624924, -89.4369430541992, -1.56096912921445, 218, 29, 'PPL', 'P'),
(146955, 'Bainbridge', 42.2933311462402, 0.73815788013816, -75.4797210693359, -1.31736965114685, 218, 40, 'PPL', 'P'),
(154166, 'Bainbridge', 41.3863906860352, 0.722328782988028, -81.3397216796875, -1.41964595596636, 218, 41, 'PPL', 'P'),
(158873, 'Bainbridge', 40.0908317565918, 0.699717014015629, -76.6677780151367, -1.33810515655226, 218, 45, 'PPL', 'P'),
(206747, 'Bainbridge', 47.6552810668945, 0.831741560580626, -122.516670227051, -2.13831928404215, 218, 56, 'PPL', 'P'),
(112911, 'Bainbridge (historical)', 34.8008308410645, 0.607389080606162, -87.5899963378906, -1.52873382790597, 218, 2, 'PPL', 'P'),
(129643, 'Bainbridge Center', 42.1155586242676, 0.735055164310163, -86.2816696166992, -1.50589921892936, 218, 27, 'PPL', 'P'),
(206748, 'Bainbridge Grange', 47.6561088562012, 0.831756008229539, -122.519439697266, -2.13836762041593, 218, 56, 'PPL', 'P'),
(191102, 'Bainer', 33.8611106872559, 0.590987869874855, -102.239440917969, -1.78441486941677, 218, 51, 'PPL', 'P'),
(39199, 'Bains', 30.8305606842041, 0.538094794175277, -91.3866729736328, -1.59499833583321, 218, 22, 'PPL', 'P'),
(146957, 'Bains Corner', 41.7388916015625, 0.728481084580275, -73.5625, -1.28390783099833, 218, 40, 'PPL', 'P'),
(122183, 'Bainter Town', 41.5169410705566, 0.724607317037673, -85.8172225952148, -1.49779308920337, 218, 19, 'PPL', 'P'),
(92407, 'Bainville', 28.7452793121338, 0.501699768402145, -97.932502746582, -1.70924461764625, 218, 51, 'PPL', 'P'),
(195914, 'Bainville', 48.1399993896484, 0.840201491257426, -104.222221374512, -1.81902091672764, 218, 31, 'PPL', 'P'),
(77819, 'Bair', 39.9052810668945, 0.696478543551065, -76.8280563354492, -1.34090254096128, 218, 45, 'PPL', 'P'),
(202956, 'Bair Estates', 40.6022186279297, 0.708642398671948, -111.797218322754, -1.95122955430299, 218, 52, 'PPL', 'P'),
(15079, 'Baird', 27.687219619751, 0.483233143087427, -81.9561080932617, -1.43040392834779, 218, 12, 'PPL', 'P'),
(53316, 'Baird', 36.4474983215332, 0.636128849825861, -90.0036087036133, -1.57085931055468, 218, 29, 'PPL', 'P'),
(58529, 'Baird', 33.4249992370605, 0.583376289163299, -90.5833282470703, -1.58097732532616, 218, 30, 'PPL', 'P'),
(92405, 'Baird', 32.3938903808594, 0.565380044676116, -99.3938903808594, -1.73475064351232, 218, 51, 'PPL', 'P'),
(114488, 'Baird', 41.7986106872559, 0.729523379251905, -95.654167175293, -1.66948016046195, 218, 16, 'PPL', 'P'),
(62666, 'Baird (historical)', 35.7880592346191, 0.624619466542866, -81.4055633544922, -1.42079510997673, 218, 33, 'PPL', 'P'),
(193357, 'Baird (historical)', 40.7924995422363, 0.711963427130304, -122.295280456543, -2.13445530361655, 218, 6, 'PPL', 'P'),
(195915, 'Baird (historical)', 46.7166709899902, 0.815359724346248, -113.516670227051, -1.98123965136266, 218, 31, 'PPL', 'P'),
(206749, 'Baird (historical)', 47.6202812194824, 0.831130698005589, -119.468612670898, -2.08512064389699, 218, 56, 'PPL', 'P'),
(146958, 'Baird Corners', 43.2222213745117, 0.754370073011099, -76.460563659668, -1.33448858379193, 218, 40, 'PPL', 'P'),
(124167, 'Baird Four Corners', 42.1208305358887, 0.735147176525825, -72.9319381713867, -1.27290245095163, 218, 23, 'PPL', 'P'),
(188104, 'Baird Place', 32.160831451416, 0.561312399006156, -103.42749786377, -1.80515037482218, 218, 38, 'PPL', 'P'),
(158875, 'Bairdford', 40.6311111450195, 0.709146668224354, -79.8816680908203, -1.39419812017011, 218, 45, 'PPL', 'P'),
(84786, 'Bairds Mill', 36.1022186279297, 0.630102582332203, -86.331672668457, -1.50677193681857, 218, 50, 'PPL', 'P'),
(139021, 'Bairdston', 40.2847213745117, 0.703101026233765, -93.1958312988281, -1.62657410529773, 218, 29, 'PPL', 'P'),
(19018, 'Bairdstown', 33.6980590820313, 0.588142082513023, -83.1188888549805, -1.45069828111863, 218, 13, 'PPL', 'P'),
(154168, 'Bairdstown', 41.172779083252, 0.718600557198999, -83.6080627441406, -1.45923597609926, 218, 41, 'PPL', 'P'),
(158874, 'Bairdstown', 40.4324989318848, 0.70568023117048, -79.279167175293, -1.38368249544787, 218, 45, 'PPL', 'P'),
(144783, 'Bairdsville', 40.2419395446777, 0.702354342443134, -74.3841705322266, -1.2982486871523, 218, 37, 'PPL', 'P'),
(209287, 'Bairoil', 42.2444381713867, 0.737304536745871, -107.558891296387, -1.87725679291662, 218, 59, 'PPL', 'P'),
(15080, 'Bairs Den', 27.2080593109131, 0.474870218053333, -81.32861328125, -1.419452077839, 218, 12, 'PPL', 'P'),
(108067, 'Baisden', 37.5838890075684, 0.655962608886172, -81.9052810668945, -1.42951682938868, 218, 58, 'PPL', 'P'),
(146959, 'Baiting Hollow', 40.9561080932617, 0.714818935030114, -72.7447204589844, -1.26963488545216, 218, 40, 'PPL', 'P'),
(34641, 'Baizetown', 37.3705596923828, 0.652239309945159, -86.7108306884766, -1.51338949265326, 218, 21, 'PPL', 'P'),
(179896, 'Bak', 38.4575004577637, 0.671210005075203, -122.670280456543, -2.14100028831153, 218, 6, 'PPL', 'P'),
(200359, 'Bakeoven', 45.086669921875, 0.786910838896613, -120.838607788086, -2.10903156942816, 218, 43, 'PPL', 'P'),
(7223, 'Baker', 36.2805595397949, 0.63321521843526, -91.4138870239258, -1.59547331061363, 218, 4, 'PPL', 'P'),
(15082, 'Baker', 30.7969398498535, 0.537507999918592, -86.6813888549805, -1.51287563572093, 218, 12, 'PPL', 'P'),
(29140, 'Baker', 39.1305618286133, 0.682957142064515, -87.3125, -1.52389060314755, 218, 19, 'PPL', 'P'),
(31719, 'Baker', 39.7541694641113, 0.693841148544532, -95.5627822875977, -1.6678851932851, 218, 20, 'PPL', 'P'),
(39200, 'Baker', 30.5880603790283, 0.533862365412869, -91.1680603027344, -1.59118282493945, 218, 22, 'PPL', 'P'),
(44560, 'Baker', 39.0077781677246, 0.680814162914355, -76.1388931274414, -1.32887437389794, 218, 25, 'PPL', 'P'),
(53317, 'Baker', 36.7727813720703, 0.641806110058665, -89.7641677856445, -1.56668027817212, 218, 29, 'PPL', 'P'),
(58530, 'Baker', 34.502498626709, 0.602182201200894, -88.9472198486328, -1.55242184685389, 218, 30, 'PPL', 'P'),
(77814, 'Baker', 39.8355598449707, 0.695261678669981, -75.8069381713867, -1.32308066694647, 218, 45, 'PPL', 'P'),
(108068, 'Baker', 39.0416717529297, 0.681405717571489, -78.745002746582, -1.37435956741983, 218, 58, 'PPL', 'P'),
(118703, 'Baker', 41.5555610656738, 0.725281363109572, -88.8111114501953, -1.55004630716154, 218, 18, 'PPL', 'P'),
(134067, 'Baker', 46.7130584716797, 0.815296674007441, -96.5516662597656, -1.68514447451963, 218, 28, 'PPL', 'P'),
(139631, 'Baker', 48.1605606079102, 0.840560352214314, -99.647216796875, -1.73917202355407, 218, 34, 'PPL', 'P'),
(146960, 'Baker', 42.9772186279297, 0.750093968406813, -77.7922210693359, -1.35773039009922, 218, 40, 'PPL', 'P'),
(154169, 'Baker', 40.0558280944824, 0.699106084861565, -84.7013931274414, -1.47831819109995, 218, 41, 'PPL', 'P'),
(179898, 'Baker', 35.2649993896484, 0.615490350063156, -116.073608398438, -2.02586664122328, 218, 6, 'PPL', 'P'),
(189909, 'Baker', 39.0133285522461, 0.680911035399007, -114.121940612793, -1.99180361245867, 218, 39, 'PPL', 'P'),
(190951, 'Baker', 36.8694381713867, 0.643493089451176, -101.017501831055, -1.76308800909131, 218, 42, 'PPL', 'P'),
(191103, 'Baker', 34.2013893127441, 0.596926852263786, -100.110832214355, -1.74726363905211, 218, 51, 'PPL', 'P'),
(194546, 'Baker', 45.0947189331055, 0.787051320644115, -113.733612060547, -1.98502600064248, 218, 17, 'PPL', 'P'),
(195916, 'Baker', 46.3669395446777, 0.809255759127787, -104.284172058105, -1.82010216013021, 218, 31, 'PPL', 'P'),
(206750, 'Baker', 45.7547187805176, 0.798570491044116, -122.660278320313, -2.14082571810207, 218, 56, 'PPL', 'P'),
(212293, 'Baker', 64.9669418334961, 1.13388703994615, -150.459716796875, -2.62601744972369, 218, 1, 'PPL', 'P'),
(53318, 'Baker (historical)', 38.1980590820313, 0.666681898852768, -93.5897216796875, -1.63344878933566, 218, 29, 'PPL', 'P'),
(141226, 'Baker (historical)', 42.9888916015625, 0.750297700230204, -98.7305603027344, -1.72317334962152, 218, 35, 'PPL', 'P'),
(84787, 'Baker Bluff Subdivision', 36.4666709899902, 0.63646347601683, -82.4663925170898, -1.43931007166523, 218, 50, 'PPL', 'P'),
(124168, 'Baker Bridge', 42.4277801513672, 0.740504457953656, -71.3369369506836, -1.24506442807703, 218, 23, 'PPL', 'P'),
(200360, 'Baker City', 44.7750015258789, 0.781471199212072, -117.83332824707, -2.05657954649462, 218, 43, 'PPL', 'P'),
(126809, 'Baker Corner', 43.8247184753418, 0.764885631154304, -70.3888931274414, -1.22851794190826, 218, 26, 'PPL', 'P'),
(143489, 'Baker Corner', 43.1375007629395, 0.752891419394859, -72.2494430541992, -1.26099066402792, 218, 36, 'PPL', 'P'),
(146961, 'Baker Corner', 41.5875015258789, 0.725838829304753, -73.5633316040039, -1.28392234522627, 218, 40, 'PPL', 'P'),
(146962, 'Baker Corners', 43.1094398498535, 0.752401664070394, -75.1425018310547, -1.31148406513777, 218, 40, 'PPL', 'P'),
(7226, 'Baker Creek (historical)', 35.336109161377, 0.61673144971016, -93.1327819824219, -1.62547368713531, 218, 4, 'PPL', 'P'),
(62667, 'Baker Crossroads', 35.3925018310547, 0.617715687470026, -81.4527816772461, -1.42161922517605, 218, 33, 'PPL', 'P'),
(79642, 'Baker Crossroads', 33.9936103820801, 0.593300425807425, -79.0566711425781, -1.37979920710438, 218, 48, 'PPL', 'P'),
(84788, 'Baker Crossroads', 35.9961090087891, 0.628250620110162, -85.1105575561523, -1.485459457563, 218, 50, 'PPL', 'P'),
(7225, 'Baker Den (historical)', 36.4555587768555, 0.636269531310445, -91.1388931274414, -1.59067376169708, 218, 4, 'PPL', 'P'),
(7227, 'Baker Ford', 36.3763885498047, 0.634887750178857, -91.5611114501953, -1.59804286159139, 218, 4, 'PPL', 'P'),
(108069, 'Baker Heights', 39.4233283996582, 0.688066882669023, -77.9255599975586, -1.36005759341778, 218, 58, 'PPL', 'P'),
(206751, 'Baker Heights', 48.4355583190918, 0.845359967709882, -122.251670837402, -2.133694172177, 218, 56, 'PPL', 'P'),
(79640, 'Baker Hill', 32.3730583190918, 0.565016456608293, -81.1213912963867, -1.41583537192062, 218, 48, 'PPL', 'P'),
(112912, 'Baker Hill', 31.7811107635498, 0.554685022764953, -85.3022232055664, -1.48880465420825, 218, 2, 'PPL', 'P'),
(7228, 'Baker Hollow', 35.9347190856934, 0.627179163824595, -92.710563659668, -1.61810458724101, 218, 4, 'PPL', 'P'),
(79641, 'Baker Place', 34.7077789306641, 0.605765018394405, -80.6975021362305, -1.40843711041238, 218, 48, 'PPL', 'P'),
(19026, 'Baker Ridge', 34.0688896179199, 0.594614296331216, -84.6288909912109, -1.477052790108, 218, 13, 'PPL', 'P'),
(108071, 'Baker Ridge', 39.6738891601563, 0.692439992916014, -79.9480590820313, -1.3953568615604, 218, 58, 'PPL', 'P'),
(15084, 'Baker Settlement', 30.8669395446777, 0.538729725068666, -85.9049987792969, -1.49932507262044, 218, 12, 'PPL', 'P'),
(7232, 'Baker Springs', 34.3125, 0.598866099590554, -94.1675033569336, -1.6435329819613, 218, 4, 'PPL', 'P'),
(158878, 'Baker Station', 40.0752792358398, 0.699445571321522, -80.2263870239258, -1.40021460054676, 218, 45, 'PPL', 'P'),
(19022, 'Baker Village', 32.4244384765625, 0.56591320952635, -84.9388885498047, -1.4824632681786, 218, 13, 'PPL', 'P'),
(206752, 'Baker-Langdon', 46.0247192382813, 0.803282888013984, -118.323608398438, -2.06513654939315, 218, 56, 'PPL', 'P'),
(383, 'Bakerfield (historical)', 32.1805610656738, 0.561656745735103, -83.9855575561523, -1.46582450347806, 218, 13, 'PPL', 'P'),
(34645, 'Bakers', 37.1838912963867, 0.648981331825611, -88.0355606079102, -1.53651039144705, 218, 21, 'PPL', 'P'),
(39204, 'Bakers', 32.3411102294922, 0.564458857255058, -91.521110534668, -1.59734471391162, 218, 22, 'PPL', 'P'),
(62668, 'Bakers', 35.0272216796875, 0.611340346136485, -80.603889465332, -1.40680326108362, 218, 33, 'PPL', 'P'),
(84789, 'Bakers', 36.3722190856934, 0.634814979302071, -86.7600021362305, -1.51424769631454, 218, 50, 'PPL', 'P'),
(158876, 'Bakers', 40.047779083252, 0.698965603114063, -80.1613922119141, -1.39908022708044, 218, 45, 'PPL', 'P'),
(195917, 'Bakers (historical)', 48.3208312988281, 0.843357603465279, -105.887222290039, -1.84808066475231, 218, 31, 'PPL', 'P'),
(118705, 'Bakers Acres', 41.9474983215332, 0.732121958685549, -88.3466720581055, -1.54194031059362, 218, 18, 'PPL', 'P'),
(19023, 'Bakers Bridge Estates', 33.8152809143066, 0.590187989441449, -84.8147201538086, -1.48029612084155, 218, 13, 'PPL', 'P'),
(122184, 'Bakers Corner', 40.1305618286133, 0.700410434584458, -86.1374969482422, -1.50338293117339, 218, 19, 'PPL', 'P'),
(173032, 'Bakers Corners', 43.2677803039551, 0.755165226333569, -89.1869430541992, -1.55660580608446, 218, 57, 'PPL', 'P'),
(19024, 'Bakers Crossing', 31.9869403839111, 0.558277427338388, -81.0722198486328, -1.41497716825934, 218, 13, 'PPL', 'P'),
(99597, 'Bakers Crossing', 36.6719398498535, 0.640046093473259, -76.67138671875, -1.33816814031204, 218, 53, 'PPL', 'P'),
(191104, 'Bakers Crossing', 29.9619407653809, 0.522934516643406, -101.147499084473, -1.765356889182, 218, 51, 'PPL', 'P'),
(158877, 'Bakers Crossroad', 40.6241683959961, 0.709025494394755, -78.6952819824219, -1.37349177637863, 218, 45, 'PPL', 'P'),
(26432, 'Bakers Crossroads', 37.628059387207, 0.656733527442723, -89.1147232055664, -1.55534533194053, 218, 18, 'PPL', 'P'),
(34642, 'Bakers Crossroads', 36.5522193908691, 0.637956577281983, -88.3569412231445, -1.54211954133498, 218, 21, 'PPL', 'P'),
(62669, 'Bakers Crossroads', 36.3669395446777, 0.634722833928354, -79.8099975585938, -1.3929472334061, 218, 33, 'PPL', 'P'),
(84790, 'Bakers Crossroads', 36.0133285522461, 0.628551157839177, -85.5522232055664, -1.49316797733823, 218, 50, 'PPL', 'P'),
(124169, 'Bakers Grove', 42.5352783203125, 0.742380654941616, -71.8833312988281, -1.25460080846644, 218, 23, 'PPL', 'P'),
(15085, 'Bakers Mill', 30.579439163208, 0.533711896811279, -82.9394378662109, -1.44756627051864, 218, 12, 'PPL', 'P'),
(146963, 'Bakers Mills', 43.6147193908691, 0.761220455704082, -74.0252838134766, -1.29198493226843, 218, 40, 'PPL', 'P'),
(108073, 'Bakers Run', 38.6349983215332, 0.674307927213237, -80.5930633544922, -1.40661430980427, 218, 58, 'PPL', 'P'),
(158886, 'Bakers Summit', 40.2625007629395, 0.702713203400022, -78.4216690063477, -1.36871632906996, 218, 45, 'PPL', 'P'),
(44555, 'Bakersfield', 39.563060760498, 0.690505672437263, -76.4888916015625, -1.3349829996483, 218, 25, 'PPL', 'P'),
(53320, 'Bakersfield', 36.5224990844727, 0.637437860080663, -92.1419372558594, -1.60818018428077, 218, 29, 'PPL', 'P'),
(171702, 'Bakersfield', 44.7819404602051, 0.781592306462643, -72.8033294677734, -1.27065780562686, 218, 55, 'PPL', 'P'),
(179904, 'Bakersfield', 35.3733291625977, 0.617381061279058, -119.017776489258, -2.07725206814025, 218, 6, 'PPL', 'P'),
(191105, 'Bakersfield', 30.8911094665527, 0.539151569785334, -102.297500610352, -1.78542820221154, 218, 51, 'PPL', 'P'),
(34643, 'Bakersport', 37.2077789306641, 0.649398249694263, -87.3447189331055, -1.52445292961172, 218, 21, 'PPL', 'P'),
(146964, 'Bakerstand', 42.3505592346191, 0.739156698704994, -78.5488891601563, -1.37093673962881, 218, 40, 'PPL', 'P'),
(15086, 'Bakerstown', 29.3477802276611, 0.512215393124378, -81.4916687011719, -1.42229793177986, 218, 12, 'PPL', 'P'),
(158879, 'Bakerstown', 40.6508293151855, 0.70949081521622, -79.9366683959961, -1.39515805658503, 218, 45, 'PPL', 'P'),
(158880, 'Bakerstown Station', 40.6552810668945, 0.709568512941023, -79.9727783203125, -1.39578829365699, 218, 45, 'PPL', 'P'),
(15087, 'Bakersville', 29.9058303833008, 0.521955205731557, -81.4913864135742, -1.42229300493184, 218, 12, 'PPL', 'P'),
(44556, 'Bakersville', 39.514720916748, 0.689661983003926, -77.7577819824219, -1.35712931464119, 218, 25, 'PPL', 'P'),
(62670, 'Bakersville', 36.0155601501465, 0.628590106570119, -82.1588897705078, -1.43394313627845, 218, 33, 'PPL', 'P'),
(129645, 'Bakersville', 42.4900016784668, 0.741590428467163, -86.0697174072266, -1.50219995501718, 218, 27, 'PPL', 'P'),
(144784, 'Bakersville', 40.2747192382813, 0.70292645602431, -74.706672668457, -1.30387741127423, 218, 37, 'PPL', 'P'),
(154170, 'Bakersville', 40.3555603027344, 0.704337398769834, -81.6458282470703, -1.42498852342917, 218, 41, 'PPL', 'P'),
(158882, 'Bakersville', 40.0422210693359, 0.698868597471357, -79.216667175293, -1.38259166466538, 218, 45, 'PPL', 'P'),
(177467, 'Bakersville', 41.8319396972656, 0.730105080213005, -73.0305633544922, -1.2746237851222, 218, 8, 'PPL', 'P'),
(53321, 'Bakersville (historical)', 38.5694389343262, 0.673163700050885, -92.022216796875, -1.6060906680895, 218, 29, 'PPL', 'P'),
(84791, 'Bakersworks', 36.077220916748, 0.62966628996662, -87.2633285522461, -1.52303239948627, 218, 50, 'PPL', 'P'),
(34644, 'Bakerton', 36.848331451416, 0.64312470769339, -85.333610534668, -1.48935246644447, 218, 21, 'PPL', 'P'),
(84792, 'Bakerton', 36.5127792358398, 0.637268216719224, -85.8047180175781, -1.49757484315204, 218, 50, 'PPL', 'P'),
(108072, 'Bakerton', 39.3627815246582, 0.687010140348479, -77.7633285522461, -1.35722612054681, 218, 58, 'PPL', 'P'),
(158883, 'Bakerton', 40.6027793884277, 0.708652185788954, -78.745002746582, -1.37435956741983, 218, 45, 'PPL', 'P'),
(62672, 'Bakertown', 35.9300003051758, 0.627096805567885, -79.9674987792969, -1.39569614828328, 218, 33, 'PPL', 'P'),
(84794, 'Bakertown', 35.2586097717285, 0.615378830192509, -86.3302764892578, -1.5067475688946, 218, 50, 'PPL', 'P'),
(122185, 'Bakertown', 41.3663902282715, 0.721979709148146, -85.3572235107422, -1.48976459062316, 218, 19, 'PPL', 'P'),
(129646, 'Bakertown', 41.8050003051758, 0.729634899122552, -86.3908309936523, -1.5078044443732, 218, 27, 'PPL', 'P'),
(146965, 'Bakertown', 43.399169921875, 0.757458407769209, -74.1313934326172, -1.29383689449047, 218, 40, 'PPL', 'P'),
(53322, 'Bakerville', 36.2338905334473, 0.632400690615859, -89.9177780151367, -1.56936128244151, 218, 29, 'PPL', 'P'),
(84795, 'Bakerville', 35.9436111450195, 0.62733435953712, -87.8741683959961, -1.53369356596208, 218, 50, 'PPL', 'P'),
(118706, 'Bakerville', 40.063060760498, 0.699232318697234, -89.1966705322266, -1.55677558260396, 218, 18, 'PPL', 'P'),
(173033, 'Bakerville', 44.6272201538086, 0.77889192769633, -90.2180633544922, -1.57460225030873, 218, 57, 'PPL', 'P'),
(186379, 'Bakerville', 39.6913909912109, 0.692745457493047, -105.804443359375, -1.84663589986094, 218, 7, 'PPL', 'P'),
(193103, 'Bakerville', 31.422779083252, 0.548430955129552, -109.886672973633, -1.91788424745216, 218, 5, 'PPL', 'P'),
(84796, 'Bakewell', 35.3433303833008, 0.616857483808748, -85.133056640625, -1.48585214066573, 218, 50, 'PPL', 'P'),
(15088, 'Bal Harbour', 25.8913898468018, 0.451890000744121, -80.1272201538086, -1.39848381215432, 218, 12, 'PPL', 'P'),
(31724, 'Bala', 39.3097190856934, 0.686084026079404, -96.9494400024414, -1.6920869360073, 218, 20, 'PPL', 'P'),
(77815, 'Bala', 39.9991683959961, 0.698117186569791, -75.2333297729492, -1.31306931177664, 218, 45, 'PPL', 'P'),
(158884, 'Bala-Cynwyd', 40.0074996948242, 0.698262595165309, -75.2344436645508, -1.3130887528526, 218, 45, 'PPL', 'P'),
(179899, 'Balance Rock', 35.8061103820801, 0.624934518499822, -118.651107788086, -2.07085249204079, 218, 6, 'PPL', 'P'),
(194098, 'Balarat', 40.1591682434082, 0.700909710709821, -105.39582824707, -1.83950422077782, 218, 7, 'PPL', 'P'),
(134069, 'Balaton', 44.2333297729492, 0.7720172436584, -95.871940612793, -1.67328102396971, 218, 28, 'PPL', 'P'),
(122186, 'Balbec', 40.5308303833008, 0.707396438755954, -85.1488876342773, -1.48612844362882, 218, 19, 'PPL', 'P'),
(179900, 'Balboa', 33.5869407653809, 0.5862027020282, -117.900001525879, -2.05774321473293, 218, 6, 'PPL', 'P'),
(7233, 'Balboa (historical)', 36.0325012207031, 0.628885784030146, -91.5002822875977, -1.59698119242283, 218, 4, 'PPL', 'P'),
(179901, 'Balboa Island', 33.5944404602051, 0.586333596395778, -117.890830993652, -2.05758315875141, 218, 6, 'PPL', 'P'),
(7234, 'Balch', 35.5316696166992, 0.620144623542233, -91.065559387207, -1.58939384647719, 218, 4, 'PPL', 'P'),
(179902, 'Balch', 35.042781829834, 0.611611921988646, -116.026672363281, -2.02504745287197, 218, 6, 'PPL', 'P'),
(206753, 'Balch', 46.8147201538086, 0.817071005083706, -123.241943359375, -2.15097768817746, 218, 56, 'PPL', 'P'),
(179903, 'Balch Camp', 36.9030609130859, 0.644079916997375, -119.122222900391, -2.07907500190641, 218, 6, 'PPL', 'P'),
(92408, 'Balch Springs', 32.7286109924316, 0.571222021422341, -96.6224975585938, -1.68638071389764, 218, 51, 'PPL', 'P'),
(39205, 'Balco', 29.7199993133545, 0.51871184170849, -91.4411087036133, -1.5959484185521, 218, 22, 'PPL', 'P'),
(26434, 'Balcom', 37.4130592346191, 0.652981066887774, -89.2061080932617, -1.55694029911738, 218, 18, 'PPL', 'P'),
(146966, 'Balcom', 42.3697204589844, 0.73949112515888, -79.0966720581055, -1.38049735478414, 218, 40, 'PPL', 'P'),
(146967, 'Balcom Beach', 42.3863906860352, 0.739782075507972, -78.2016677856445, -1.36487658341028, 218, 40, 'PPL', 'P'),
(146968, 'Balcom Corners', 42.3697204589844, 0.73949112515888, -79.0905609130859, -1.38039069518248, 218, 40, 'PPL', 'P'),
(92410, 'Balcones Heights', 29.4877796173096, 0.514658843424526, -98.5513916015625, -1.72004626586955, 218, 51, 'PPL', 'P'),
(99598, 'Balcony Falls', 37.6277809143066, 0.656728667173733, -79.4561080932617, -1.38677069704793, 218, 53, 'PPL', 'P'),
(118707, 'Bald Bluff', 41.0186080932617, 0.71590976581261, -90.8536071777344, -1.58569458256502, 218, 18, 'PPL', 'P'),
(195918, 'Bald Butte', 46.7241706848145, 0.815490618713826, -112.345558166504, -1.9607998899963, 218, 31, 'PPL', 'P'),
(62674, 'Bald Creek', 35.9119415283203, 0.626781620452874, -82.4227828979492, -1.43854894022569, 218, 33, 'PPL', 'P'),
(84797, 'Bald Crossing', 36.2625007629395, 0.632900033320249, -82.5180587768555, -1.44021181801033, 218, 50, 'PPL', 'P'),
(44557, 'Bald Eagle', 38.6763916015625, 0.675030376237948, -76.7227783203125, -1.33906509296718, 218, 25, 'PPL', 'P'),
(134071, 'Bald Eagle', 45.1019401550293, 0.787177354742703, -93.0136108398438, -1.62339375832396, 218, 28, 'PPL', 'P'),
(158885, 'Bald Eagle', 40.7219390869141, 0.710731914863224, -78.1855621337891, -1.36459548675722, 218, 45, 'PPL', 'P'),
(134072, 'Bald Eagle Center', 47.4011116027832, 0.827305466573853, -94.4186096191406, -1.64791561300919, 218, 28, 'PPL', 'P'),
(13315, 'Bald Eagle Village', 38.7058296203613, 0.675544166591252, -75.0988922119141, -1.31072293369823, 218, 10, 'PPL', 'P'),
(44558, 'Bald Friar (historical)', 39.7027816772461, 0.692944262468421, -76.2102813720703, -1.33012033381393, 218, 25, 'PPL', 'P'),
(126810, 'Bald Head', 43.2208290100098, 0.754345771666152, -70.5777816772461, -1.23181466902167, 218, 26, 'PPL', 'P'),
(62675, 'Bald Head Island', 33.8616714477539, 0.590997656991861, -77.9947204589844, -1.36126467118186, 218, 33, 'PPL', 'P'),
(34646, 'Bald Hill', 38.3569412231445, 0.669454915337813, -83.7147216796875, -1.46109752570122, 218, 21, 'PPL', 'P'),
(44559, 'Bald Hill', 39.6858291625977, 0.692648385271313, -76.228889465332, -1.33044510630886, 218, 25, 'PPL', 'P'),
(58532, 'Bald Hill', 34.4130592346191, 0.600621189327944, -89.0852813720703, -1.5548314750082, 218, 30, 'PPL', 'P'),
(75048, 'Bald Hill', 35.7402801513672, 0.623785564226535, -95.8369369506836, -1.67267009481564, 218, 42, 'PPL', 'P'),
(92409, 'Bald Hill', 31.2394409179688, 0.545231100500794, -94.6447219848633, -1.65186201827053, 218, 51, 'PPL', 'P'),
(112914, 'Bald Hill', 31.163610458374, 0.543907609307566, -85.6355590820313, -1.49462246276758, 218, 2, 'PPL', 'P'),
(158888, 'Bald Hill', 41.079719543457, 0.716976361829187, -78.293327331543, -1.36647634427709, 218, 45, 'PPL', 'P'),
(84798, 'Bald Hill (historical)', 36.4880599975586, 0.636836784622632, -83.5625, -1.45844075619776, 218, 50, 'PPL', 'P'),
(126811, 'Bald Hill Crossing', 43.3424987792969, 0.756469309740354, -70.6733322143555, -1.23348234049628, 218, 26, 'PPL', 'P'),
(7236, 'Bald Knob', 35.3097190856934, 0.616270855999631, -91.5677795410156, -1.59815924173102, 218, 4, 'PPL', 'P'),
(71732, 'Bald Knob', 38.5724983215332, 0.673217096430741, -82.5130615234375, -1.44012459948463, 218, 41, 'PPL', 'P'),
(108075, 'Bald Knob', 37.8708305358887, 0.660970683316066, -81.6358337402344, -1.42481408637777, 218, 58, 'PPL', 'P'),
(802, 'Bald Knobs', 39.0250015258789, 0.681114767222398, -81.8338928222656, -1.42827086947269, 218, 41, 'PPL', 'P'),
(29142, 'Bald Knobs', 39.0200004577637, 0.681027482117671, -86.1705627441406, -1.50396003818161, 218, 19, 'PPL', 'P'),
(118709, 'Bald Mound', 41.8461112976074, 0.730352421299246, -88.4063873291016, -1.54298253868622, 218, 18, 'PPL', 'P'),
(62676, 'Bald Mountain', 35.9644393920898, 0.627697881025916, -82.4719390869141, -1.43940687757086, 218, 33, 'PPL', 'P'),
(126812, 'Bald Mountain', 44.954719543457, 0.784607870343967, -70.7911071777344, -1.23553790138366, 218, 26, 'PPL', 'P'),
(146969, 'Bald Mountain', 43.1294403076172, 0.752750737910276, -73.5386123657227, -1.28349091312968, 218, 40, 'PPL', 'P'),
(84799, 'Bald Point', 36.4111099243164, 0.635493752484905, -83.3608322143555, -1.45492098934306, 218, 50, 'PPL', 'P'),
(92411, 'Bald Prairie', 31.2233295440674, 0.544949903979196, -96.432502746582, -1.68306467886633, 218, 51, 'PPL', 'P'),
(206754, 'Balder', 47.1827812194824, 0.823494882528114, -117.404441833496, -2.04909406646067, 218, 56, 'PPL', 'P'),
(108074, 'Balderson (historical)', 39.1594390869141, 0.683461145300812, -81.6722183227539, -1.4254491171397, 218, 58, 'PPL', 'P'),
(179905, 'Balderson Station', 38.9347190856934, 0.679539041384425, -120.753059387207, -2.10753846816301, 218, 6, 'PPL', 'P'),
(79643, 'Baldock', 33.0791702270508, 0.577340434289716, -81.4236068725586, -1.42111002877563, 218, 48, 'PPL', 'P'),
(29144, 'Baldridge', 39.2230606079102, 0.684571550317321, -87.3722229003906, -1.52493296439821, 218, 19, 'PPL', 'P'),
(75050, 'Baldridge', 35.3619384765625, 0.617182256303683, -94.6197204589844, -1.65142565932592, 218, 42, 'PPL', 'P'),
(191106, 'Baldridge', 31.0277805328369, 0.541536929884205, -102.620002746582, -1.79105692633348, 218, 51, 'PPL', 'P'),
(34647, 'Baldrock', 36.9902801513672, 0.645602179876464, -84.2836074829102, -1.47102645603531, 218, 21, 'PPL', 'P'),
(722, 'Baldwin', 36.3474998474121, 0.634383547205478, -81.5330581665039, -1.42302031422554, 218, 33, 'PPL', 'P'),
(7240, 'Baldwin', 36.0483283996582, 0.629162020414214, -94.0966720581055, -1.64229674258329, 218, 4, 'PPL', 'P'),
(15089, 'Baldwin', 30.3024997711182, 0.52887839259084, -81.9755630493164, -1.43074348138677, 218, 12, 'PPL', 'P'),
(19027, 'Baldwin', 34.4916687011719, 0.601993183342525, -83.5374984741211, -1.45800439725315, 218, 13, 'PPL', 'P'),
(26437, 'Baldwin', 38.1830596923828, 0.666420110117613, -89.8424987792969, -1.56804741191772, 218, 18, 'PPL', 'P'),
(34648, 'Baldwin', 37.7966690063477, 0.65967632044726, -84.4252777099609, -1.4734990679494, 218, 21, 'PPL', 'P'),
(39206, 'Baldwin', 29.8377799987793, 0.520767502464408, -91.5441665649414, -1.59774711755234, 218, 22, 'PPL', 'P'),
(44561, 'Baldwin', 39.4947204589844, 0.689312909164043, -76.4705581665039, -1.33466302084333, 218, 25, 'PPL', 'P'),
(79644, 'Baldwin', 34.3811111450195, 0.600063589974708, -82.1466674804688, -1.43372981707513, 218, 48, 'PPL', 'P'),
(92412, 'Baldwin', 32.7058296203613, 0.570824411471592, -94.2341690063477, -1.64469651704156, 218, 51, 'PPL', 'P'),
(99599, 'Baldwin', 37.7397193908691, 0.658682362149415, -79.850830078125, -1.3936598953138, 218, 53, 'PPL', 'P'),
(108076, 'Baldwin', 38.9727783203125, 0.680203300339318, -80.7547225952148, -1.40943579582116, 218, 58, 'PPL', 'P'),
(112915, 'Baldwin', 34.1891708374023, 0.596713599639498, -86.9169387817383, -1.51698675749568, 218, 2, 'PPL', 'P'),
(114492, 'Baldwin', 42.0741691589355, 0.734332781864479, -90.8413925170898, -1.58548139651976, 218, 16, 'PPL', 'P'),
(129647, 'Baldwin', 43.9011116027832, 0.766218942754052, -85.8516693115234, -1.49839429781946, 218, 27, 'PPL', 'P'),
(146971, 'Baldwin', 40.6563911437988, 0.709587887437953, -73.6097183227539, -1.28473194619765, 218, 40, 'PPL', 'P'),
(154171, 'Baldwin', 41.0188903808594, 0.715914692660627, -84.8019409179688, -1.48007308110026, 218, 41, 'PPL', 'P'),
(158889, 'Baldwin', 40.3380584716797, 0.704031934192802, -79.9791717529297, -1.39589988010667, 218, 45, 'PPL', 'P'),
(173034, 'Baldwin', 44.9666709899902, 0.784816462436348, -92.3741683959961, -1.61223338230182, 218, 57, 'PPL', 'P'),
(186380, 'Baldwin', 38.7638893127441, 0.676557499386027, -107.047218322754, -1.86832641483326, 218, 7, 'PPL', 'P'),
(197966, 'Baldwin', 47.026668548584, 0.820770202416854, -100.749168395996, -1.75840470715635, 218, 34, 'PPL', 'P'),
(154172, 'Baldwin (historical)', 41.5830612182617, 0.725761331317031, -84.4972229003906, -1.47475474840337, 218, 41, 'PPL', 'P'),
(44562, 'Baldwin Acres', 38.9597206115723, 0.679975400329035, -76.3341674804688, -1.33228255430296, 218, 25, 'PPL', 'P'),
(118711, 'Baldwin Beach', 40.3458290100098, 0.704167555671315, -90.0319366455078, -1.57135372641105, 218, 18, 'PPL', 'P'),
(31723, 'Baldwin City', 38.7750015258789, 0.676751444092412, -95.1861114501953, -1.66131104697618, 218, 20, 'PPL', 'P'),
(146973, 'Baldwin Corner', 43.3875007629395, 0.757254742524845, -73.4938888549805, -1.28271034061417, 218, 40, 'PPL', 'P'),
(126815, 'Baldwin Corners', 44.246940612793, 0.772254797627635, -68.3591690063477, -1.19309257308803, 218, 26, 'PPL', 'P'),
(44563, 'Baldwin Estates', 39.4836082458496, 0.689118964457658, -76.4499969482422, -1.33430415988644, 218, 25, 'PPL', 'P'),
(34649, 'Baldwin Ford', 37.3455581665039, 0.65180295100055, -87.8213882446289, -1.53277237854102, 218, 21, 'PPL', 'P'),
(158890, 'Baldwin Furnace', 40.351390838623, 0.704264627893048, -79.0505599975586, -1.37969254750272, 218, 45, 'PPL', 'P'),
(146974, 'Baldwin Harbor', 40.6394386291504, 0.709292010240845, -73.60888671875, -1.28471743196971, 218, 40, 'PPL', 'P'),
(26439, 'Baldwin Heights', 38.4497184753418, 0.671074183859608, -89.1447219848633, -1.55586890941084, 218, 18, 'PPL', 'P'),
(29143, 'Baldwin Heights', 38.3413887023926, 0.669183472643707, -87.5713882446289, -1.52840905541103, 218, 19, 'PPL', 'P'),
(146975, 'Baldwin Heights', 42.0991706848145, 0.734769140809088, -78.4227828979492, -1.36873577014591, 218, 40, 'PPL', 'P'),
(19029, 'Baldwin Hills', 33.8347206115723, 0.590527276164325, -84.8708267211914, -1.48127536517437, 218, 13, 'PPL', 'P'),
(44565, 'Baldwin Hills', 39.5666694641113, 0.690568656197043, -76.4636077880859, -1.33454171385568, 218, 25, 'PPL', 'P'),
(44566, 'Baldwin Hills South', 39.0394401550293, 0.681366768840547, -76.6452789306641, -1.33771247344953, 218, 25, 'PPL', 'P'),
(179907, 'Baldwin Lake', 34.2794418334961, 0.598289125740389, -116.79638671875, -2.03848150267476, 218, 6, 'PPL', 'P'),
(44568, 'Baldwin Mill Terrace', 39.5088882446289, 0.689560183671257, -76.477783203125, -1.33478912152095, 218, 25, 'PPL', 'P'),
(53323, 'Baldwin Park', 38.7938919067383, 0.677081143435364, -94.2452774047852, -1.64489039516892, 218, 29, 'PPL', 'P'),
(179908, 'Baldwin Park', 34.0852813720703, 0.594900386411317, -117.959999084473, -2.05879036967354, 218, 6, 'PPL', 'P'),
(146976, 'Baldwin Place', 41.3474998474121, 0.721650009805194, -73.7624969482422, -1.2873984362391, 218, 40, 'PPL', 'P'),
(193106, 'Baldwin Place', 34.2855606079102, 0.598395918500101, -112.484718322754, -1.96322869291045, 218, 5, 'PPL', 'P'),
(62678, 'Baldwin Woods', 34.3424987792969, 0.599389677060864, -78.6894378662109, -1.37338977730888, 218, 33, 'PPL', 'P'),
(144785, 'Baldwins Corner', 40.3138885498047, 0.703610089476134, -74.7863922119141, -1.30526877978575, 218, 37, 'PPL', 'P'),
(177468, 'Baldwins Crossing', 41.2400016784668, 0.719773812817234, -73.0933303833008, -1.27571927643661, 218, 8, 'PPL', 'P'),
(193107, 'Baldwins Crossing', 34.8238906860352, 0.6077915508259, -111.806938171387, -1.95139919766443, 218, 5, 'PPL', 'P'),
(173037, 'Baldwins Mill', 44.3880615234375, 0.774717822161795, -88.9608306884766, -1.55265940082313, 218, 57, 'PPL', 'P'),
(146978, 'Baldwinsville', 43.1586112976074, 0.753259867731672, -76.3330612182617, -1.33226324638506, 218, 40, 'PPL', 'P'),
(19030, 'Baldwinville', 32.6505584716797, 0.569859747945738, -84.4497222900391, -1.47392570635603, 218, 13, 'PPL', 'P'),
(124170, 'Baldwinville', 42.6083297729492, 0.743655643313492, -72.0763931274414, -1.25797037303567, 218, 23, 'PPL', 'P'),
(58533, 'Baldwyn', 34.5094413757324, 0.602303375030492, -88.6352767944336, -1.54697741347939, 218, 30, 'PPL', 'P'),
(179909, 'Baldy Mesa', 34.459171295166, 0.601425996609366, -117.45027923584, -2.04989408005213, 218, 6, 'PPL', 'P'),
(179910, 'Bale', 38.5541687011719, 0.672897184204795, -122.509437561035, -2.13819305020648, 218, 6, 'PPL', 'P'),
(19031, 'Bales (historical)', 32.5800018310547, 0.568628302257686, -82.7255630493164, -1.44383345077673, 218, 13, 'PPL', 'P'),
(144786, 'Balesville', 41.1041717529297, 0.717403133393872, -74.7600021362305, -1.30480818607522, 218, 37, 'PPL', 'P'),
(206755, 'Balford', 48.9347190856934, 0.854071966583858, -122.149169921875, -2.13190519371474, 218, 56, 'PPL', 'P'),
(62680, 'Balfour', 35.3463897705078, 0.616910880188604, -82.4722213745117, -1.43941180441887, 218, 33, 'PPL', 'P'),
(114493, 'Balfour', 41.0488891601563, 0.716438270130937, -95.6675033569336, -1.66971292074122, 218, 16, 'PPL', 'P'),
(186381, 'Balfour', 38.9072189331055, 0.679059073176966, -105.723892211914, -1.84523001712149, 218, 7, 'PPL', 'P'),
(197967, 'Balfour', 47.9516716003418, 0.836914551261023, -100.534172058105, -1.75465231318042, 218, 34, 'PPL', 'P'),
(99600, 'Bali Hai', 37.288890838623, 0.650813919550722, -79.8775024414063, -1.39412541587235, 218, 53, 'PPL', 'P'),
(202959, 'Bali Hai', 40.6144409179688, 0.708855717875263, -111.867500305176, -1.95245620630108, 218, 52, 'PPL', 'P'),
(114494, 'Bali Hai Estates Mobile Home Park', 42.0527801513672, 0.733959473258677, -91.6672210693359, -1.59989482381343, 218, 16, 'PPL', 'P'),
(129650, 'Balitmore', 46.5347213745117, 0.812184104483411, -89.228889465332, -1.55733790906813, 218, 27, 'PPL', 'P'),
(39207, 'Balize (historical)', 29.1222190856934, 0.508278608532482, -89.1072235107422, -1.55521443757295, 218, 22, 'PPL', 'P'),
(34650, 'Balkan', 36.7591705322266, 0.64156855608943, -83.5444412231445, -1.45812557108275, 218, 21, 'PPL', 'P'),
(190952, 'Balko', 36.6300010681152, 0.639314123647651, -100.684440612793, -1.75727499422193, 218, 42, 'PPL', 'P'),
(112917, 'Balkum', 31.4174995422363, 0.548338809755835, -85.2275009155273, -1.48750050422243, 218, 2, 'PPL', 'P'),
(7241, 'Ball', 35.5200004577637, 0.619940958297869, -94.2666702270508, -1.64526377035375, 218, 4, 'PPL', 'P'),
(39208, 'Ball', 31.4152793884277, 0.548300060761975, -92.4116668701172, -1.61288785413971, 218, 22, 'PPL', 'P'),
(7242, 'Ball (historical)', 34.0069389343262, 0.593533052928643, -93.7083282470703, -1.63551886445098, 218, 4, 'PPL', 'P'),
(134076, 'Ball Bluff', 46.954719543457, 0.819514455383854, -93.273063659668, -1.62792206428348, 218, 28, 'PPL', 'P'),
(84800, 'Ball Camp', 35.9527816772461, 0.627494415518634, -84.121940612793, -1.46820483686037, 218, 50, 'PPL', 'P'),
(134078, 'Ball Club', 47.3258285522461, 0.825991529471036, -93.9358291625977, -1.63948950447824, 218, 28, 'PPL', 'P'),
(112918, 'Ball Flat', 34.0177803039551, 0.593722270524094, -85.73388671875, -1.49633860377403, 218, 2, 'PPL', 'P'),
(19033, 'Ball Ground', 34.6519393920898, 0.60479043459349, -84.7602767944336, -1.47934590496461, 218, 13, 'PPL', 'P'),
(58534, 'Ball Hill', 32.3152809143066, 0.564008050661534, -89.355827331543, -1.55955339277896, 218, 30, 'PPL', 'P'),
(195919, 'Ball Place', 45.1413917541504, 0.787865915042543, -112.151107788086, -1.95740609066115, 218, 31, 'PPL', 'P'),
(84801, 'Ball Play', 35.0291709899902, 0.611374368019411, -84.7022171020508, -1.47833257216984, 218, 50, 'PPL', 'P'),
(177469, 'Ball Pond', 41.4555587768555, 0.723535993910161, -73.523063659668, -1.2832195370146, 218, 8, 'PPL', 'P'),
(154173, 'Ball Subdivision', 41.1883316040039, 0.718871999893105, -84.4491729736328, -1.4739161189761, 218, 41, 'PPL', 'P'),
(195920, 'Ballantine', 45.9488906860352, 0.80195943011027, -108.144439697266, -1.88747654044174, 218, 31, 'PPL', 'P'),
(179912, 'Ballarat', 36.047779083252, 0.62915243303429, -117.222503662109, -2.04591864633492, 218, 6, 'PPL', 'P'),
(7245, 'Ballard', 36.2350006103516, 0.63242006511279, -91.6686096191406, -1.59991905857935, 218, 4, 'PPL', 'P'),
(34651, 'Ballard', 37.9302787780762, 0.662008250876761, -84.9905624389648, -1.48336514768176, 218, 21, 'PPL', 'P'),
(44569, 'Ballard', 38.7666702270508, 0.676606035496894, -76.8813934326172, -1.34183344892032, 218, 25, 'PPL', 'P'),
(53324, 'Ballard', 38.3613891601563, 0.669532546483589, -94.1430587768555, -1.64310634355467, 218, 29, 'PPL', 'P'),
(58535, 'Ballard', 32.6027793884277, 0.569025845629407, -90.07861328125, -1.57216838738851, 218, 30, 'PPL', 'P'),
(62681, 'Ballard', 35.9036102294922, 0.626636211857356, -77.149169921875, -1.3465070303173, 218, 33, 'PPL', 'P'),
(75052, 'Ballard', 36.0944404602051, 0.629966827695636, -94.5891723632813, -1.65089249447568, 218, 42, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(108077, 'Ballard', 37.4747200012207, 0.654057250284275, -80.7794418334961, -1.40986722791775, 218, 58, 'PPL', 'P'),
(179913, 'Ballard', 34.6358299255371, 0.604509271361405, -120.11222076416, -2.09635372421689, 218, 6, 'PPL', 'P'),
(202961, 'Ballard', 40.2894401550293, 0.703183384490476, -109.942497253418, -1.91885856493697, 218, 52, 'PPL', 'P'),
(206756, 'Ballard', 47.6761093139648, 0.832105082069421, -122.386108398438, -2.13604055025542, 218, 56, 'PPL', 'P'),
(146979, 'Ballard Corners', 43.1530609130859, 0.75316299524702, -73.6819381713867, -1.28599242034159, 218, 40, 'PPL', 'P'),
(92413, 'Ballard Crossing', 31.5397205352783, 0.550471968499475, -98.0883331298828, -1.71196437090949, 218, 51, 'PPL', 'P'),
(62682, 'Ballard Crossroads', 36.4102783203125, 0.635479238256964, -76.7991714477539, -1.34039840456693, 218, 33, 'PPL', 'P'),
(44570, 'Ballard Gardens', 39.3363914489746, 0.68654954663795, -76.4441680908203, -1.3342024271328, 218, 25, 'PPL', 'P'),
(202964, 'Ballard Junction', 41.7852783203125, 0.729290685551659, -111.986106872559, -1.9545262814164, 218, 52, 'PPL', 'P'),
(15090, 'Ballard Pines', 27.9155597686768, 0.487218430500676, -80.4786071777344, -1.40461667267061, 218, 12, 'PPL', 'P'),
(99601, 'Ballard Woods', 38.077220916748, 0.664572875006507, -78.5758285522461, -1.37140692071926, 218, 53, 'PPL', 'P'),
(129651, 'Ballards Corners', 43.1169395446777, 0.752532558437971, -85.7099990844727, -1.49592168590537, 218, 27, 'PPL', 'P'),
(62683, 'Ballards Crossroad', 35.547779083252, 0.620425786774318, -77.5036087036133, -1.35269315405539, 218, 33, 'PPL', 'P'),
(34654, 'Ballardsville', 38.3613891601563, 0.669532546483589, -85.345832824707, -1.48956578564779, 218, 21, 'PPL', 'P'),
(58536, 'Ballardsville', 34.2425003051758, 0.59764437444048, -88.5380630493164, -1.5452807135489, 218, 30, 'PPL', 'P'),
(124171, 'Ballardvale', 42.625, 0.743946593662583, -71.1611099243164, -1.24199566755293, 218, 23, 'PPL', 'P'),
(58537, 'Ballaston', 33.7861099243164, 0.589678859620054, -90.533332824707, -1.580104740595, 218, 30, 'PPL', 'P'),
(7246, 'Balle (historical)', 34.6838912963867, 0.605348100525753, -91.5458297729492, -1.59777614600822, 218, 4, 'PPL', 'P'),
(179914, 'Ballena', 33.0652809143066, 0.577098020051492, -116.745826721191, -2.03759906424757, 218, 6, 'PPL', 'P'),
(108078, 'Ballengee', 37.6169395446777, 0.656539449578283, -80.7383270263672, -1.40914963916203, 218, 58, 'PPL', 'P'),
(44580, 'Ballenger Creek', 39.372501373291, 0.687179783709917, -77.4355621337891, -1.35150551736727, 218, 25, 'PPL', 'P'),
(44571, 'Ballenger Creek Meadows', 39.3875007629395, 0.687441572445072, -77.4502792358398, -1.3517623792544, 218, 25, 'PPL', 'P'),
(44572, 'Ballenger Heights', 39.3616714477539, 0.686990765851549, -77.4997177124023, -1.35262524344759, 218, 25, 'PPL', 'P'),
(58538, 'Ballentine', 34.3941688537598, 0.600291489984992, -90.0963897705078, -1.5724786456555, 218, 30, 'PPL', 'P'),
(79645, 'Ballentine', 34.1241683959961, 0.595579093015124, -81.2375030517578, -1.41786190435212, 218, 48, 'PPL', 'P'),
(79646, 'Ballentine Landing', 34.1122207641602, 0.595370567501771, -81.245002746582, -1.41799279871969, 218, 48, 'PPL', 'P'),
(15091, 'Ballentine Manor', 27.4011096954346, 0.478239582885474, -82.565559387207, -1.44104086005767, 218, 12, 'PPL', 'P'),
(99602, 'Ballentine Place', 36.8691711425781, 0.643488428919268, -76.2527770996094, -1.33086202417752, 218, 53, 'PPL', 'P'),
(19034, 'Ballew Mill', 34.839168548584, 0.608058199830045, -84.3491668701172, -1.47217068319767, 218, 13, 'PPL', 'P'),
(112937, 'Ballfield Landing', 31.6124992370605, 0.551742196470902, -88.0747222900391, -1.53719389174082, 218, 2, 'PPL', 'P'),
(58539, 'Ballground', 32.5374984741211, 0.567886478736044, -90.7466735839844, -1.58382823927309, 218, 30, 'PPL', 'P'),
(92414, 'Balli Colonia Number 1', 26.1580009460449, 0.456543242248275, -98.0410003662109, -1.71113825833935, 218, 51, 'PPL', 'P'),
(92415, 'Balli Estates Colonia', 26.1410007476807, 0.456246532813327, -98.0380020141602, -1.71108592722393, 218, 51, 'PPL', 'P'),
(92416, 'Balli Number 2 Colonia', 26.1620006561279, 0.456613050358349, -98.0260009765625, -1.71087646960419, 218, 51, 'PPL', 'P'),
(179915, 'Ballico', 37.4544410705566, 0.653703316175403, -120.705001831055, -2.10669970557769, 218, 6, 'PPL', 'P'),
(158893, 'Balliet', 40.7786102294922, 0.711721012892079, -75.7113876342773, -1.32141299547186, 218, 45, 'PPL', 'P'),
(158894, 'Balliettsville', 40.6783294677734, 0.709970783423679, -75.5741729736328, -1.31901814786161, 218, 45, 'PPL', 'P'),
(39209, 'Ballina', 31.666109085083, 0.552677864830388, -91.6791687011719, -1.60010334932678, 218, 22, 'PPL', 'P'),
(146980, 'Ballina', 42.8977813720703, 0.748707526743318, -75.8475036621094, -1.32378866832227, 218, 40, 'PPL', 'P'),
(92417, 'Ballinger', 31.7380599975586, 0.553933645152901, -99.9469375610352, -1.74440313772525, 218, 51, 'PPL', 'P'),
(70483, 'Ballingers Mill', 39.5763893127441, 0.690738299558481, -75.2694396972656, -1.31369954884861, 218, 37, 'PPL', 'P'),
(143490, 'Balloch', 43.4322204589844, 0.75803524846132, -72.3925018310547, -1.26348751070793, 218, 36, 'PPL', 'P'),
(75054, 'Ballou', 36.1458282470703, 0.630863713771747, -95.1900024414063, -1.66137895758398, 218, 42, 'PPL', 'P'),
(118712, 'Ballou', 41.2775001525879, 0.72042828465512, -88.101936340332, -1.53766886652124, 218, 18, 'PPL', 'P'),
(154177, 'Ballou', 40.1997184753418, 0.701617445769509, -84.0602798461914, -1.46712865346387, 218, 41, 'PPL', 'P'),
(173038, 'Ballou', 46.3175010681152, 0.808392894934601, -90.5844421386719, -1.58099676640212, 218, 57, 'PPL', 'P'),
(179917, 'Ballou', 34.0491714477539, 0.59427014933935, -117.606109619141, -2.05261383331538, 218, 6, 'PPL', 'P'),
(177470, 'Ballouville', 41.8766708374023, 0.730885785886562, -71.8616714477539, -1.25422277274971, 218, 8, 'PPL', 'P'),
(206757, 'Ballow', 47.2405586242676, 0.824503288474872, -122.865829467773, -2.14441326240652, 218, 56, 'PPL', 'P'),
(84802, 'Ballplay', 35.4638900756836, 0.61896164738602, -84.2055587768555, -1.46966424913774, 218, 50, 'PPL', 'P'),
(112913, 'Ballplay', 34.0586090087891, 0.594434865852772, -85.8080596923828, -1.49763316637991, 218, 2, 'PPL', 'P'),
(99606, 'Balls Hill', 38.9411087036133, 0.679650561255072, -77.1944427490234, -1.34729719021272, 218, 53, 'PPL', 'P'),
(99603, 'Balls Mill', 38.6302795410156, 0.674225568956527, -77.7394409179688, -1.35680920267816, 218, 53, 'PPL', 'P'),
(158895, 'Balls Mills', 41.3180618286133, 0.721136219451891, -77.0272216796875, -1.3443786319741, 218, 45, 'PPL', 'P'),
(202965, 'Ballstaedt Estates', 40.6197204589844, 0.70894786324898, -111.805557250977, -1.95137509605656, 218, 52, 'PPL', 'P'),
(99604, 'Ballston', 38.8800010681152, 0.678584031817523, -77.1141662597656, -1.34589610116323, 218, 53, 'PPL', 'P'),
(200362, 'Ballston', 45.0669403076172, 0.786566492167666, -123.319717407227, -2.15233510138507, 218, 43, 'PPL', 'P'),
(146981, 'Ballston Center', 42.9558296203613, 0.749720659801011, -73.8658294677734, -1.2892019289293, 218, 40, 'PPL', 'P'),
(146982, 'Ballston Lake', 42.9116706848145, 0.748949940981542, -73.8686065673828, -1.28925039846114, 218, 40, 'PPL', 'P'),
(146983, 'Ballston Spa', 43.0008316040039, 0.750506092585503, -73.8494415283203, -1.28891590542822, 218, 40, 'PPL', 'P'),
(29147, 'Ballstown', 39.250560760498, 0.68505151852478, -85.2441711425781, -1.48779145457153, 218, 19, 'PPL', 'P'),
(99605, 'Ballsville', 37.4983291625977, 0.654469307883937, -78.0672225952148, -1.36253007217381, 218, 53, 'PPL', 'P'),
(34656, 'Balltown', 36.7238883972168, 0.640952766666376, -84.1677780151367, -1.46900485045183, 218, 21, 'PPL', 'P'),
(79647, 'Balltown', 33.5913887023926, 0.586280333173976, -81.7247161865234, -1.42636537771274, 218, 48, 'PPL', 'P'),
(84803, 'Balltown', 35.3097190856934, 0.616270855999631, -84.5438919067383, -1.47556927622277, 218, 50, 'PPL', 'P'),
(114495, 'Balltown', 42.6380615234375, 0.744174560251894, -90.8686065673828, -1.58595637130017, 218, 16, 'PPL', 'P'),
(146985, 'Balltown', 42.4905586242676, 0.741600149005141, -79.0766677856445, -1.38014821436523, 218, 40, 'PPL', 'P'),
(158896, 'Balltown', 41.601390838623, 0.726081243542977, -79.1725006103516, -1.38182081268785, 218, 45, 'PPL', 'P'),
(186382, 'Balltown', 39.0777816772461, 0.682035954643456, -106.280563354492, -1.85494576141032, 218, 7, 'PPL', 'P'),
(154174, 'Ballville', 41.3277816772461, 0.721305862813329, -83.1322174072266, -1.45093090823985, 218, 41, 'PPL', 'P'),
(53325, 'Ballwin', 38.5950012207031, 0.6736098461125, -90.5461120605469, -1.58032778033629, 218, 29, 'PPL', 'P'),
(158897, 'Bally', 40.4022216796875, 0.705151793431181, -75.5875015258789, -1.31925077498282, 218, 45, 'PPL', 'P'),
(114496, 'Ballyclough', 42.4258308410645, 0.74047043607073, -90.7180633544922, -1.5833288965687, 218, 16, 'PPL', 'P'),
(99610, 'Ballylynn Shores', 36.8311080932617, 0.642824103385348, -76.2213897705078, -1.33031421194129, 218, 53, 'PPL', 'P'),
(15092, 'Balm', 27.7591705322266, 0.48448892340994, -82.2613906860352, -1.43573211474071, 218, 12, 'PPL', 'P'),
(62684, 'Balm', 36.1697196960449, 0.631280698219427, -81.8525009155273, -1.42859564196763, 218, 33, 'PPL', 'P'),
(92418, 'Balm', 33.7466697692871, 0.588990499057295, -96.9763870239258, -1.69255725025581, 218, 51, 'PPL', 'P'),
(200363, 'Balm Grove', 45.5969390869141, 0.795816715897947, -123.217216491699, -2.15054612292281, 218, 43, 'PPL', 'P'),
(146987, 'Balmat', 44.2483291625977, 0.772279032393554, -75.3952789306641, -1.3158958577996, 218, 40, 'PPL', 'P'),
(195921, 'Balmont', 45.628059387207, 0.796359867602269, -111.104438781738, -1.93913827032181, 218, 31, 'PPL', 'P'),
(39210, 'Balmoral', 32.1147193908691, 0.560507591724734, -91.2238922119141, -1.59215727558231, 218, 22, 'PPL', 'P'),
(44573, 'Balmoral', 39.4208297729492, 0.688023273406173, -77.3008270263672, -1.34915394612473, 218, 25, 'PPL', 'P'),
(84804, 'Balmoral', 35.1072196960449, 0.612736574916987, -85.3466720581055, -1.48958043303379, 218, 50, 'PPL', 'P'),
(173039, 'Balmoral', 43.225830078125, 0.754433056770879, -90.4638900756836, -1.5788927359829, 218, 57, 'PPL', 'P'),
(191107, 'Balmorhea', 30.9841709136963, 0.54077579844466, -103.744171142578, -1.81067736619048, 218, 51, 'PPL', 'P'),
(146986, 'Balmville', 41.5347213745117, 0.724917641883694, -74.0152816772461, -1.29181036205898, 218, 40, 'PPL', 'P'),
(62685, 'Balsam', 35.4266700744629, 0.618312035817122, -83.0852813720703, -1.45011171988854, 218, 33, 'PPL', 'P'),
(129652, 'Balsam', 46.2077789306641, 0.806477882373753, -88.3808288574219, -1.54253645920363, 218, 27, 'PPL', 'P'),
(134079, 'Balsam', 46.7811088562012, 0.816484377274589, -93.1558303833008, -1.62587595761797, 218, 28, 'PPL', 'P'),
(158899, 'Balsam', 41.7030601501465, 0.727855707777297, -77.3488922119141, -1.3499928418681, 218, 45, 'PPL', 'P'),
(62686, 'Balsam Grove', 35.2294387817383, 0.614869700371113, -82.873893737793, -1.4464223096724, 218, 33, 'PPL', 'P'),
(173040, 'Balsam Lake', 45.452220916748, 0.793290907341089, -92.4544372558594, -1.61363433819326, 218, 57, 'PPL', 'P'),
(77820, 'Balsinger', 39.896110534668, 0.696318487569551, -79.7991714477539, -1.39275828212676, 218, 45, 'PPL', 'P'),
(92419, 'Balsora', 33.1161117553711, 0.577985185589625, -97.8516693115234, -1.70783380805878, 218, 51, 'PPL', 'P'),
(31725, 'Balta', 38.8847198486328, 0.678666390074234, -98.915283203125, -1.72639737243717, 218, 20, 'PPL', 'P'),
(84806, 'Balta', 35.7688903808594, 0.624284906930925, -84.8763885498047, -1.48137243739611, 218, 50, 'PPL', 'P'),
(197969, 'Balta', 48.1666717529297, 0.840667011815972, -100.036666870117, -1.74596920960428, 218, 34, 'PPL', 'P'),
(62687, 'Baltic', 34.9936103820801, 0.610753718327368, -78.1600036621094, -1.36414940727463, 218, 33, 'PPL', 'P'),
(112921, 'Baltic', 31.6516704559326, 0.552425863212239, -86.0041732788086, -1.50105599417094, 218, 2, 'PPL', 'P'),
(129653, 'Baltic', 47.0675010681152, 0.821482864324559, -88.6333312988281, -1.54694345817549, 218, 27, 'PPL', 'P'),
(154176, 'Baltic', 40.439998626709, 0.705811125538057, -81.6991729736328, -1.42591956454626, 218, 41, 'PPL', 'P'),
(169785, 'Baltic', 43.7613906860352, 0.763780352722894, -96.7399978637695, -1.68843148109506, 218, 49, 'PPL', 'P'),
(177312, 'Baltic', 41.6169395446777, 0.726352619658056, -72.0849990844727, -1.25812057532115, 218, 8, 'PPL', 'P'),
(34657, 'Baltimore', 36.6875, 0.64031766932542, -88.8058319091797, -1.54995416178783, 218, 21, 'PPL', 'P'),
(44574, 'Baltimore', 39.2902793884277, 0.685744739356528, -76.6125030517578, -1.33714042644738, 218, 25, 'PPL', 'P'),
(62689, 'Baltimore', 36.1477813720703, 0.6308978022337, -80.5299987792969, -1.40551362532574, 218, 33, 'PPL', 'P'),
(71733, 'Baltimore', 39.8452796936035, 0.695431322031419, -82.600830078125, -1.44165644974365, 218, 41, 'PPL', 'P'),
(84807, 'Baltimore', 35.9841690063477, 0.628042227754863, -83.059440612793, -1.44966071355793, 218, 50, 'PPL', 'P'),
(146988, 'Baltimore', 42.735279083252, 0.74587132676141, -76.126106262207, -1.32865120099859, 218, 40, 'PPL', 'P'),
(171704, 'Baltimore', 43.360279083252, 0.756779634586375, -72.5736083984375, -1.26664841660574, 218, 55, 'PPL', 'P'),
(112920, 'Baltimore (historical)', 33.9174995422363, 0.591972041055693, -86.8869400024414, -1.51646318002537, 218, 2, 'PPL', 'P'),
(114497, 'Baltimore (historical)', 40.857780456543, 0.713102794023667, -91.459716796875, -1.59627319104703, 218, 16, 'PPL', 'P'),
(179918, 'Baltimore (historical)', 39.0152816772461, 0.68094512386096, -120.829170227051, -2.10886685291474, 218, 6, 'PPL', 'P'),
(186383, 'Baltimore (historical)', 39.9033317565918, 0.696444521668139, -105.573890686035, -1.84261199661189, 218, 7, 'PPL', 'P'),
(99607, 'Baltimore Corner', 37.0988883972168, 0.647497751361355, -77.7272186279297, -1.35659588347484, 218, 53, 'PPL', 'P'),
(112384, 'Baltimore Corner', 39.0580596923828, 0.681691741072564, -75.8450012207031, -1.32374499248039, 218, 25, 'PPL', 'P'),
(44576, 'Baltimore Highlands', 39.2330589294434, 0.684746053947748, -76.6369400024414, -1.33756693169595, 218, 25, 'PPL', 'P'),
(112922, 'Baltimore Hill', 34.836669921875, 0.608014590567195, -86.5422210693359, -1.51044669964872, 218, 2, 'PPL', 'P'),
(189912, 'Baltimore Mill', 39.2844390869141, 0.685642806865805, -114.868057250977, -2.00482580439889, 218, 39, 'PPL', 'P'),
(179919, 'Baltimore Park', 37.9308280944824, 0.662017838256685, -122.531387329102, -2.13857614592928, 218, 6, 'PPL', 'P'),
(53326, 'Baltimore Settlement', 38.6097183227539, 0.673866707999638, -91.2416687011719, -1.59246753384931, 218, 29, 'PPL', 'P'),
(179926, 'Baltimore Town', 39.3877792358398, 0.687446432714061, -120.539169311523, -2.10380538210499, 218, 6, 'PPL', 'P'),
(144787, 'Baltusrol', 40.7244415283203, 0.710775590705101, -74.3283309936523, -1.29727410335138, 218, 37, 'PPL', 'P'),
(99608, 'Balty', 37.997501373291, 0.663181506494995, -77.4452819824219, -1.3516751607287, 218, 53, 'PPL', 'P'),
(58540, 'Baltzer', 33.9819412231445, 0.593096760563061, -90.5947189331055, -1.58117613030154, 218, 30, 'PPL', 'P'),
(19035, 'Balus Creek', 34.2477798461914, 0.597736519814197, -83.9088897705078, -1.46448639818835, 218, 13, 'PPL', 'P'),
(194099, 'Balzac', 40.4069404602051, 0.705234151687891, -103.470832824707, -1.80590671257176, 218, 7, 'PPL', 'P'),
(112925, 'Bama Dale', 31.267219543457, 0.545715928977243, -85.376106262207, -1.49009415680806, 218, 2, 'PPL', 'P'),
(112924, 'Bama Park', 32.7161102294922, 0.571003841950036, -85.851936340332, -1.49839895835137, 218, 2, 'PPL', 'P'),
(19036, 'Bamah (historical)', 32.8808288574219, 0.573878724346777, -83.9302825927734, -1.46485977337318, 218, 13, 'PPL', 'P'),
(70484, 'Bamber Lake', 39.8905601501465, 0.6962216150849, -74.3125, -1.29699780038829, 218, 37, 'PPL', 'P'),
(79648, 'Bamberg', 33.2969398498535, 0.58114123121845, -81.0350036621094, -1.41432762326947, 218, 48, 'PPL', 'P'),
(70485, 'Bamberry Estates', 39.9936103820801, 0.698020180927085, -74.2180633544922, -1.29534956998964, 218, 37, 'PPL', 'P'),
(15093, 'Bamboo', 28.8225002288818, 0.503047527650807, -81.9658279418945, -1.43057357170923, 218, 12, 'PPL', 'P'),
(62690, 'Bamboo', 36.1936111450195, 0.631697682667106, -81.6080627441406, -1.42432939105937, 218, 33, 'PPL', 'P'),
(19037, 'Bamburg', 30.7772197723389, 0.537163819637213, -82.9141693115234, -1.44712525104212, 218, 13, 'PPL', 'P'),
(112933, 'Bamford', 33.2758293151855, 0.580772782881638, -86.9319381713867, -1.51724854623084, 218, 2, 'PPL', 'P'),
(158900, 'Bamford', 40.0849990844727, 0.699615214682961, -76.3891677856445, -1.33324249071788, 218, 45, 'PPL', 'P'),
(92420, 'Bammel', 30.0066699981689, 0.523715189027449, -95.4633331298828, -1.66614947804464, 218, 51, 'PPL', 'P'),
(179920, 'Bamom (historical)', 38.6652793884277, 0.674836431531563, -120.925003051758, -2.11053945123737, 218, 6, 'PPL', 'P'),
(179921, 'Banadelle Ranchos', 36.9666709899902, 0.645190122276801, -119.893058776855, -2.09252862594321, 218, 6, 'PPL', 'P'),
(62691, 'Banalsburg (historical)', 35.1230583190918, 0.613013011038137, -80.9916687011719, -1.41357128551989, 218, 33, 'PPL', 'P'),
(129655, 'Banat', 45.5177803039551, 0.794435134503441, -87.6975021362305, -1.53061015805198, 218, 27, 'PPL', 'P'),
(39211, 'Bancker', 29.8850002288818, 0.521591650953247, -92.1241683959961, -1.60787005917184, 218, 22, 'PPL', 'P'),
(99609, 'Banco', 38.4511108398438, 0.671098485204556, -78.2819366455078, -1.36627753930172, 218, 53, 'PPL', 'P'),
(108079, 'Banco', 38.002498626709, 0.663268725020695, -82.0086135864258, -1.43132032207889, 218, 58, 'PPL', 'P'),
(19038, 'Bancroft', 31.4147205352783, 0.548290306934482, -84.8399963378906, -1.48073727347612, 218, 13, 'PPL', 'P'),
(31726, 'Bancroft', 39.6083297729492, 0.691295765753662, -95.9000015258789, -1.67377077929417, 218, 20, 'PPL', 'P'),
(34659, 'Bancroft', 37.165828704834, 0.648666080131573, -87.2474975585938, -1.52275609652318, 218, 21, 'PPL', 'P'),
(39212, 'Bancroft', 30.5650005340576, 0.533459895193131, -93.6852798461914, -1.63511659396833, 218, 22, 'PPL', 'P'),
(44578, 'Bancroft', 39.0183296203613, 0.680998320503734, -76.5086135864258, -1.3353272132192, 218, 25, 'PPL', 'P'),
(92421, 'Bancroft', 30.1111106872559, 0.525538022925067, -93.7988891601563, -1.63709945055795, 218, 51, 'PPL', 'P'),
(108080, 'Bancroft', 38.5094413757324, 0.672116545110266, -81.8399963378906, -1.42837739591629, 218, 58, 'PPL', 'P'),
(114499, 'Bancroft', 43.292781829834, 0.755601585278178, -94.2177810668945, -1.64441049354049, 218, 16, 'PPL', 'P'),
(124172, 'Bancroft', 42.3091697692871, 0.73843431625931, -73.029167175293, -1.27459941719823, 218, 23, 'PPL', 'P'),
(126816, 'Bancroft', 45.6736106872559, 0.797154887766685, -68.0313873291016, -1.18737170359237, 218, 26, 'PPL', 'P'),
(129656, 'Bancroft', 42.8786087036133, 0.748372900552349, -84.0638885498047, -1.46719163722365, 218, 27, 'PPL', 'P'),
(134082, 'Bancroft', 43.7016716003418, 0.762738058051264, -93.3550033569336, -1.62935218178885, 218, 28, 'PPL', 'P'),
(139022, 'Bancroft', 40.1191711425781, 0.700211629609084, -93.8583297729492, -1.63813688496059, 218, 29, 'PPL', 'P'),
(141229, 'Bancroft', 42.0127792358398, 0.733261325578913, -96.5725021362305, -1.68550812916648, 218, 35, 'PPL', 'P'),
(169787, 'Bancroft', 44.4880599975586, 0.776463124782178, -97.7497177124023, -1.70605441697644, 218, 49, 'PPL', 'P'),
(173043, 'Bancroft', 44.3097190856934, 0.773350488679121, -89.5136108398438, -1.56230723450416, 218, 57, 'PPL', 'P'),
(179922, 'Bancroft', 37.9338912963867, 0.662071301215568, -122.046112060547, -2.1301064947145, 218, 6, 'PPL', 'P'),
(194547, 'Bancroft', 42.7202796936035, 0.745609538026256, -111.88500213623, -1.95276167087811, 218, 17, 'PPL', 'P'),
(200364, 'Bancroft', 42.9397201538086, 0.749439496568926, -124.005828857422, -2.16431000522661, 218, 43, 'PPL', 'P'),
(118713, 'Bancroft Corners', 42.4211082458496, 0.740388011234992, -87.8619384765625, -1.53348011360071, 218, 18, 'PPL', 'P'),
(179923, 'Bancroft Point', 32.7369384765625, 0.571367363438832, -116.984718322754, -2.04176850925019, 218, 6, 'PPL', 'P'),
(7247, 'Band Mill', 36.1336097717285, 0.630650461147459, -91.978889465332, -1.60533446349797, 218, 4, 'PPL', 'P'),
(84808, 'Band Mill', 36.0458297729492, 0.629118411151364, -89.4994430541992, -1.56205995999695, 218, 50, 'PPL', 'P'),
(34660, 'Bandana', 37.146110534668, 0.648321933139707, -88.9458312988281, -1.55239761208798, 218, 21, 'PPL', 'P'),
(62692, 'Bandana', 35.9730606079102, 0.627848349627505, -82.1761093139648, -1.43424367400747, 218, 33, 'PPL', 'P'),
(77821, 'Bandanna', 39.7386093139648, 0.693569572692372, -76.9375, -1.34281269325314, 218, 45, 'PPL', 'P'),
(92422, 'Bandera', 29.726390838623, 0.51882339486865, -99.0733337402344, -1.72915587469428, 218, 51, 'PPL', 'P'),
(206758, 'Bandera', 47.3869400024414, 0.827058125487612, -121.532501220703, -2.1211422944853, 218, 56, 'PPL', 'P'),
(92424, 'Bandera Falls', 29.6769409179688, 0.517960330938383, -98.9630584716797, -1.72723120817448, 218, 51, 'PPL', 'P'),
(179925, 'Bandini', 34.0066719055176, 0.593528392396736, -118.166938781738, -2.06240214874391, 218, 6, 'PPL', 'P'),
(29145, 'Bandmill', 38.538330078125, 0.672620748083645, -87.602783203125, -1.52895700080532, 218, 19, 'PPL', 'P'),
(112293, 'Bando', 39.8274993896484, 0.695120997185397, -89.7094421386719, -1.56572513544717, 218, 18, 'PPL', 'P'),
(29146, 'Bandon', 38.1372184753418, 0.665620029947126, -86.6002807617188, -1.5114600324435, 218, 19, 'PPL', 'P'),
(200365, 'Bandon', 43.1191711425781, 0.752571507168914, -124.407218933105, -2.17131558363212, 218, 43, 'PPL', 'P'),
(19039, 'Bandy', 30.8705596923828, 0.538792908565528, -83.1750030517578, -1.45167765860951, 218, 13, 'PPL', 'P'),
(62693, 'Bandy', 35.6419410705566, 0.622069223483006, -81.0899963378906, -1.41528742652634, 218, 33, 'PPL', 'P'),
(99611, 'Bandy', 37.1427803039551, 0.648263809648916, -81.7011108398438, -1.4259533866921, 218, 53, 'PPL', 'P'),
(108081, 'Bandytown', 37.940559387207, 0.662187681355205, -81.6399993896484, -1.42488679067553, 218, 58, 'PPL', 'P'),
(99612, 'Bane', 37.267219543457, 0.650435684096903, -80.7127838134766, -1.40870382599555, 218, 53, 'PPL', 'P'),
(108082, 'Bane', 39.5044403076172, 0.689482552525482, -80.5877838134766, -1.40652216443056, 218, 58, 'PPL', 'P'),
(84809, 'Baneberry', 36.0636100769043, 0.629428735997385, -83.2958297729492, -1.45378648271868, 218, 50, 'PPL', 'P'),
(158901, 'Banetown', 40.0783309936523, 0.699498834543324, -80.2283325195313, -1.40024855585066, 218, 45, 'PPL', 'P'),
(158902, 'Baney Settlement', 41.0680618286133, 0.716772896321905, -78.4250030517578, -1.36877451913977, 218, 45, 'PPL', 'P'),
(199158, 'Baney Trailer Park', 40.0491714477539, 0.69898990445901, -101.532501220703, -1.77207644408643, 218, 35, 'PPL', 'P'),
(129657, 'Banfield', 42.4636116027832, 0.741129834756633, -85.2886123657227, -1.48856710023901, 218, 27, 'PPL', 'P'),
(158903, 'Banfield', 40.6363906860352, 0.709238813598071, -79.605827331543, -1.38938379070952, 218, 45, 'PPL', 'P'),
(193358, 'Banfield Place', 40.086669921875, 0.699644376296897, -122.607498168945, -2.13990453068101, 218, 6, 'PPL', 'P'),
(146992, 'Bangall', 41.875560760498, 0.730866411389631, -73.6916732788086, -1.28616233001914, 218, 40, 'PPL', 'P'),
(53327, 'Bangert', 37.771110534668, 0.659230240964672, -91.5158309936523, -1.59725256853791, 218, 29, 'PPL', 'P'),
(84810, 'Bangham', 36.2472190856934, 0.632633317737078, -85.470832824707, -1.49174744721278, 218, 50, 'PPL', 'P'),
(84811, 'Bangham Village', 36.2502784729004, 0.632686714116934, -85.45361328125, -1.49144690948377, 218, 50, 'PPL', 'P'),
(179927, 'Bangle', 33.8244400024414, 0.590347845685881, -118.227783203125, -2.06346408422858, 218, 6, 'PPL', 'P'),
(34662, 'Bangor', 38.0433311462402, 0.6639813869284, -83.4388885498047, -1.45628332939869, 218, 21, 'PPL', 'P'),
(112923, 'Bangor', 33.9744415283203, 0.592965866195484, -86.7566680908203, -1.51418950624472, 218, 2, 'PPL', 'P'),
(114500, 'Bangor', 42.1733283996582, 0.736063437098867, -93.0933303833008, -1.62478512683547, 218, 16, 'PPL', 'P'),
(126818, 'Bangor', 44.8011093139648, 0.781926866074585, -68.7783279418945, -1.20040827660247, 218, 26, 'PPL', 'P'),
(129658, 'Bangor', 42.3125, 0.738492439750101, -86.1130599975586, -1.50295642592482, 218, 27, 'PPL', 'P'),
(146990, 'Bangor', 44.8122215270996, 0.78212081078097, -74.3977813720703, -1.29848624112153, 218, 40, 'PPL', 'P'),
(158904, 'Bangor', 40.8655586242676, 0.713238548660234, -75.2069396972656, -1.31260871806611, 218, 45, 'PPL', 'P'),
(173044, 'Bangor', 43.8930587768555, 0.766078394427523, -90.9902801513672, -1.5880799759534, 218, 57, 'PPL', 'P'),
(179928, 'Bangor', 39.3886108398438, 0.687460946942002, -121.404167175293, -2.11890244285049, 218, 6, 'PPL', 'P'),
(206759, 'Bangor', 47.7211112976074, 0.832890514853913, -122.744720458984, -2.14229951144932, 218, 56, 'PPL', 'P'),
(154178, 'Bangorville', 40.564998626709, 0.70799278710305, -82.5641708374023, -1.44101662529175, 218, 41, 'PPL', 'P'),
(92425, 'Bangs', 31.7169399261475, 0.55356503036852, -99.1322174072266, -1.73018358855894, 218, 51, 'PPL', 'P'),
(154179, 'Bangs', 40.3522186279297, 0.704279075541962, -82.5524978637695, -1.44081289346836, 218, 41, 'PPL', 'P'),
(99613, 'Bangs (historical)', 37.1411094665527, 0.64823464803498, -80.4019393920898, -1.4032785673809, 218, 53, 'PPL', 'P'),
(126820, 'Bangs Beach', 44.4724998474121, 0.776191548930017, -69.7752838134766, -1.21780843905867, 218, 26, 'PPL', 'P'),
(158906, 'Banian Junction', 40.8138885498047, 0.712336735736105, -78.4366683959961, -1.36897811780511, 218, 45, 'PPL', 'P'),
(194549, 'Banida', 42.2311096191406, 0.737071909624652, -111.941673278809, -1.95375076890697, 218, 17, 'PPL', 'P'),
(99614, 'Banister', 36.771671295166, 0.641786735561735, -79.5344390869141, -1.38813783079352, 218, 53, 'PPL', 'P'),
(99616, 'Banister Town', 36.774169921875, 0.641830344824585, -78.9205627441406, -1.37742366741203, 218, 53, 'PPL', 'P'),
(143491, 'Bank', 42.7502784729004, 0.746133115496565, -71.8375015258789, -1.25380092803304, 218, 36, 'PPL', 'P'),
(44579, 'Bank (historical)', 39.6561088562012, 0.692129668069993, -75.8199996948242, -1.32330863353578, 218, 25, 'PPL', 'P'),
(84812, 'Bank (historical)', 35.8088912963867, 0.624983054610689, -83.8772201538086, -1.4639336591041, 218, 50, 'PPL', 'P'),
(13317, 'Bank Harbor Retreat', 38.5588912963867, 0.672979609040533, -75.0986099243164, -1.31071800685021, 218, 10, 'PPL', 'P'),
(34661, 'Bank Lick', 38.9097213745117, 0.679102749018843, -84.579719543457, -1.47619458644672, 218, 21, 'PPL', 'P'),
(154180, 'Banker Heights', 40.7611083984375, 0.711415548315047, -81.4194412231445, -1.42103732447787, 218, 41, 'PPL', 'P'),
(39213, 'Banker Plantation', 30.1352806091309, 0.525959867641736, -91.7799987792969, -1.60186316617511, 218, 22, 'PPL', 'P'),
(39214, 'Bankers', 30.1391696929932, 0.526027744960019, -91.7425003051758, -1.60120869433722, 218, 22, 'PPL', 'P'),
(129662, 'Bankers', 41.8977813720703, 0.731254234223374, -84.6913909912109, -1.47814362089049, 218, 27, 'PPL', 'P'),
(92426, 'Bankersmith', 30.125560760498, 0.525790224280298, -98.8211135864258, -1.72475380257043, 218, 51, 'PPL', 'P'),
(112927, 'Bankhead', 34.5602798461914, 0.603190673726679, -85.5530624389648, -1.49318262472423, 218, 2, 'PPL', 'P'),
(177649, 'Bankhead Springs', 32.6497192382813, 0.569845100559743, -116.243057250977, -2.02882408161381, 218, 6, 'PPL', 'P'),
(26441, 'Banklick', 37.827220916748, 0.660209551876521, -88.7022171020508, -1.54814574224961, 218, 18, 'PPL', 'P'),
(7248, 'Banks', 33.5747184753418, 0.585989382824885, -92.2688903808594, -1.61039593430772, 218, 4, 'PPL', 'P'),
(34663, 'Banks', 37.084171295166, 0.647240889474217, -83.0219421386719, -1.44900624172005, 218, 21, 'PPL', 'P'),
(58541, 'Banks', 34.8258285522461, 0.607825372971744, -90.2297210693359, -1.57480571581601, 218, 30, 'PPL', 'P'),
(62695, 'Banks', 35.6355590820313, 0.621957836770413, -78.7144393920898, -1.37382613625349, 218, 33, 'PPL', 'P'),
(112929, 'Banks', 33.1513900756836, 0.578600908433651, -87.1891708374023, -1.52173810319649, 218, 2, 'PPL', 'P'),
(194548, 'Banks', 44.0805587768555, 0.769350886775012, -116.123062133789, -2.02672977173257, 218, 17, 'PPL', 'P'),
(197971, 'Banks', 48.0386085510254, 0.838431887292096, -103.19416809082, -1.80107800204129, 218, 34, 'PPL', 'P'),
(200366, 'Banks', 45.6188888549805, 0.796199811620755, -123.113059997559, -2.14872824916272, 218, 43, 'PPL', 'P'),
(13318, 'Banks Acres', 38.5569381713867, 0.67294552057858, -75.1113891601563, -1.31094104659151, 218, 10, 'PPL', 'P'),
(19042, 'Banks Crossing', 34.2566719055176, 0.597891715526722, -83.4641723632813, -1.45672461519131, 218, 13, 'PPL', 'P'),
(13319, 'Banks Development', 38.5533294677734, 0.6728825368188, -75.1138916015625, -1.31098472243338, 218, 10, 'PPL', 'P'),
(13320, 'Banks Harbor Estates', 38.5577812194824, 0.672960234543603, -75.0972213745117, -1.31069377208429, 218, 10, 'PPL', 'P'),
(206760, 'Banks Lake South', 47.6266708374023, 0.831242217876236, -119.274436950684, -2.08173163825181, 218, 56, 'PPL', 'P'),
(39215, 'Banks Springs', 32.0819396972656, 0.559935478143558, -92.0927810668945, -1.60732224693561, 218, 22, 'PPL', 'P'),
(112930, 'Bankston', 33.6713905334473, 0.587676628533505, -87.67138671875, -1.53015435803142, 218, 2, 'PPL', 'P'),
(114503, 'Bankston', 42.5186080932617, 0.742089704592525, -90.9611129760742, -1.58757091271103, 218, 16, 'PPL', 'P'),
(146993, 'Banksville', 41.1411094665527, 0.718047818114753, -73.6399993896484, -1.28526045051598, 218, 40, 'PPL', 'P'),
(158908, 'Banksville', 40.4083290100098, 0.705258386453811, -80.0338897705078, -1.39685488967357, 218, 45, 'PPL', 'P'),
(13321, 'Banksville Park', 38.5555610656738, 0.672921485549742, -75.1186065673828, -1.31106701411107, 218, 10, 'PPL', 'P'),
(195922, 'Bannack', 45.1611099243164, 0.788210062034408, -112.994720458984, -1.97212990937988, 218, 31, 'PPL', 'P'),
(92427, 'Bannas Junction', 31.6030597686768, 0.551577446667967, -97.1944427490234, -1.69636304061159, 218, 51, 'PPL', 'P'),
(108084, 'Bannen', 39.728328704834, 0.693390142213927, -80.5869369506836, -1.40650738388651, 218, 58, 'PPL', 'P'),
(7249, 'Banner', 35.6416702270508, 0.622064496372071, -91.8313903808594, -1.60276011883025, 218, 4, 'PPL', 'P'),
(34664, 'Banner', 37.5991706848145, 0.656229324469343, -82.7013931274414, -1.44341160606006, 218, 21, 'PPL', 'P'),
(53328, 'Banner', 37.6969413757324, 0.657935744937812, -90.8344421386719, -1.5853600895321, 218, 29, 'PPL', 'P'),
(58542, 'Banner', 34.0886116027832, 0.594958509902108, -89.3847198486328, -1.56005766233137, 218, 30, 'PPL', 'P'),
(71737, 'Banner', 38.939998626709, 0.679631186758142, -82.5950012207031, -1.44155471699001, 218, 41, 'PPL', 'P'),
(75055, 'Banner', 35.5127792358398, 0.619814924199281, -97.8486099243164, -1.70778041167892, 218, 42, 'PPL', 'P'),
(99617, 'Banner', 36.9494400024414, 0.644889384810704, -82.4297180175781, -1.43866998089723, 218, 53, 'PPL', 'P'),
(118714, 'Banner', 40.5169410705566, 0.707154024517729, -89.908332824707, -1.56919643277003, 218, 18, 'PPL', 'P'),
(173047, 'Banner', 43.7730598449707, 0.763984017967257, -88.2094421386719, -1.53954519666725, 218, 57, 'PPL', 'P'),
(179930, 'Banner', 33.0688896179199, 0.577161003811272, -116.545280456543, -2.03409887162687, 218, 6, 'PPL', 'P'),
(194550, 'Banner', 44.0200004577637, 0.768293944717387, -115.534721374512, -2.0164612883595, 218, 17, 'PPL', 'P'),
(206761, 'Banner', 47.4888916015625, 0.828837516569949, -122.54167175293, -2.13875564298675, 218, 56, 'PPL', 'P'),
(209289, 'Banner', 44.601390838623, 0.778441121102807, -106.864723205566, -1.86514127416952, 218, 59, 'PPL', 'P'),
(7250, 'Banner (historical)', 35.6113891601563, 0.621535992053745, -92.3894424438477, -1.61249996472694, 218, 4, 'PPL', 'P'),
(112919, 'Banner (historical)', 34.0083312988281, 0.59355735427359, -85.7763900756836, -1.49708042729567, 218, 2, 'PPL', 'P'),
(179931, 'Banner (historical)', 36.371940612793, 0.634810119033081, -119.663063049316, -2.08851444323214, 218, 6, 'PPL', 'P'),
(44597, 'Banner Country', 39.232780456543, 0.684741193678759, -77.2083282470703, -1.34753953787192, 218, 25, 'PPL', 'P'),
(179932, 'Banner Crest', 39.2355613708496, 0.684789729789626, -121.018058776855, -2.11216358002815, 218, 6, 'PPL', 'P'),
(62696, 'Banner Elk', 36.1630592346191, 0.631164451237845, -81.8716735839844, -1.42893026815859, 218, 33, 'PPL', 'P'),
(84813, 'Banner Hill', 36.1305618286133, 0.630597264504685, -82.4247207641602, -1.43858276237153, 218, 50, 'PPL', 'P'),
(29149, 'Banner Mills', 39.9327812194824, 0.696958511758525, -87.1011123657227, -1.52020119293141, 218, 19, 'PPL', 'P'),
(84814, 'Banner Springs', 36.2477798461914, 0.632643104854084, -84.9311065673828, -1.48232744696301, 218, 50, 'PPL', 'P'),
(173049, 'Bannerman', 43.9966697692871, 0.767886747386714, -89.2249984741211, -1.55726999846033, 218, 57, 'PPL', 'P'),
(99618, 'Banners Corner', 36.8716697692871, 0.643532038182118, -82.3002777099609, -1.43641082134452, 218, 53, 'PPL', 'P'),
(62700, 'Bannertown', 36.4855613708496, 0.636793175359782, -80.5902786254883, -1.40656570711438, 218, 33, 'PPL', 'P'),
(158910, 'Bannerville', 40.7322196960449, 0.710911345341668, -77.3480606079102, -1.34997832764016, 218, 45, 'PPL', 'P'),
(99619, 'Bannerwood', 38.7649993896484, 0.676576873882958, -77.5038909912109, -1.3526980809034, 218, 53, 'PPL', 'P'),
(19043, 'Banning', 33.5119400024414, 0.584893691773399, -84.9311065673828, -1.48232744696301, 218, 13, 'PPL', 'P'),
(134086, 'Banning', 46.1605606079102, 0.805653767174427, -92.8516693115234, -1.62056734545906, 218, 28, 'PPL', 'P'),
(158911, 'Banning', 40.1194381713867, 0.700216290140991, -79.7516708374023, -1.39192924007941, 218, 45, 'PPL', 'P'),
(179933, 'Banning', 33.9255599975586, 0.592112722540277, -116.875556945801, -2.03986328380635, 218, 6, 'PPL', 'P'),
(122187, 'Banning Corner', 40.3663902282715, 0.704526416628203, -87.1624984741211, -1.52127258263795, 218, 19, 'PPL', 'P'),
(19044, 'Banning Mills', 33.5261116027832, 0.58514103285964, -84.9244384765625, -1.48221106682337, 218, 13, 'PPL', 'P'),
(188105, 'Banning Place', 36.9222183227539, 0.644414276872234, -105.128608703613, -1.83484035991882, 218, 38, 'PPL', 'P'),
(26443, 'Bannister', 38.6188888549805, 0.674026763981152, -88.8597183227539, -1.55089465712679, 218, 18, 'PPL', 'P'),
(44581, 'Bannister', 38.5947189331055, 0.673604919264484, -76.9027786254883, -1.34220669094709, 218, 25, 'PPL', 'P'),
(53329, 'Bannister', 38.0349998474121, 0.663835978332882, -92.9880599975586, -1.62294781199943, 218, 29, 'PPL', 'P'),
(129664, 'Bannister', 43.1324996948242, 0.752804134290132, -84.4216690063477, -1.47343608418962, 218, 27, 'PPL', 'P'),
(179934, 'Bannister', 35.2655601501465, 0.615500137180162, -119.099716186523, -2.07868218564562, 218, 6, 'PPL', 'P'),
(39216, 'Bannister (historical)', 30.7072200775146, 0.535942094487139, -93.2491683959961, -1.62750501325677, 218, 22, 'PPL', 'P'),
(19045, 'Bannister Acres', 33.8283309936523, 0.590415756293678, -84.6833267211914, -1.47800287282688, 218, 13, 'PPL', 'P'),
(53330, 'Bannister Ford', 38.0416717529297, 0.663952425051546, -92.9847183227539, -1.62288948877156, 218, 29, 'PPL', 'P'),
(154181, 'Bannock', 40.0986099243164, 0.699852768652195, -80.9772186279297, -1.41331908416466, 218, 41, 'PPL', 'P'),
(179935, 'Bannock', 34.9366683959961, 0.609759893187578, -114.863059997559, -2.00473858587319, 218, 6, 'PPL', 'P'),
(194551, 'Bannock', 42.8613891601563, 0.748072362823334, -112.721939086914, -1.96736897629914, 218, 17, 'PPL', 'P'),
(199821, 'Bannock', 40.5166702270508, 0.707149297406795, -117.100280761719, -2.04378545430177, 218, 39, 'PPL', 'P'),
(209290, 'Bannock Ford', 44.8936080932617, 0.783541274327391, -110.376106262207, -1.92642646980664, 218, 59, 'PPL', 'P'),
(19046, 'Bannockburn', 31.2847194671631, 0.546021360264762, -83.057502746582, -1.44962689141209, 218, 13, 'PPL', 'P'),
(44582, 'Bannockburn', 38.973331451416, 0.68021295429827, -77.1419372558594, -1.34638079648163, 218, 25, 'PPL', 'P'),
(79650, 'Bannockburn', 34.1344413757324, 0.595758390335514, -79.7591705322266, -1.39206013444699, 218, 48, 'PPL', 'P'),
(118716, 'Bannockburn', 42.1933288574219, 0.736412510938749, -87.8663864135742, -1.53355774474648, 218, 18, 'PPL', 'P'),
(44583, 'Bannockburn Estates', 38.9836082458496, 0.680392318197687, -77.1474990844727, -1.34647786870336, 218, 25, 'PPL', 'P'),
(44584, 'Bannockburn Heights', 38.9811096191406, 0.680348708934837, -77.1427764892578, -1.34639544386762, 218, 25, 'PPL', 'P'),
(71735, 'Bannon', 39.920280456543, 0.69674033228622, -82.9469375610352, -1.44769716488622, 218, 41, 'PPL', 'P'),
(62701, 'Banoak', 35.586109161377, 0.621094772840146, -81.4091720581055, -1.42085809373651, 218, 33, 'PPL', 'P'),
(34665, 'Banock', 37.350830078125, 0.651894963216212, -86.6555633544922, -1.51242489570643, 218, 21, 'PPL', 'P'),
(92428, 'Banquete', 27.8058300018311, 0.485303284781773, -97.7958297729492, -1.70685922425786, 218, 51, 'PPL', 'P'),
(122188, 'Banquo', 40.6963882446289, 0.71028596853869, -85.6197204589844, -1.49434602664643, 218, 19, 'PPL', 'P'),
(29148, 'Banta', 39.5238914489746, 0.689822038985439, -86.2502822875977, -1.50535140669313, 218, 19, 'PPL', 'P'),
(179937, 'Banta', 37.7544403076172, 0.658939290615581, -121.369720458984, -2.1183012342344, 218, 6, 'PPL', 'P'),
(71736, 'Bantam', 38.9986114501953, 0.680654173511869, -84.1413879394531, -1.4685442567413, 218, 41, 'PPL', 'P'),
(177471, 'Bantam', 41.7244415283203, 0.728228883225044, -73.2366714477539, -1.27822104996463, 218, 8, 'PPL', 'P'),
(197973, 'Bantry', 48.4983291625977, 0.846455525603314, -100.610000610352, -1.75597577108414, 218, 34, 'PPL', 'P'),
(75062, 'Banty', 34.0697212219238, 0.594628810559157, -96.0947189331055, -1.67716923916122, 218, 42, 'PPL', 'P'),
(7253, 'Banty (historical)', 34.7411117553711, 0.606346785934532, -92.4958267211914, -1.61435672063894, 218, 4, 'PPL', 'P'),
(7254, 'Banyard', 35.7599983215332, 0.6241297112184, -94.206672668457, -1.64421661541313, 218, 4, 'PPL', 'P'),
(75063, 'Banzet', 36.9427795410156, 0.644773137829122, -95.2513885498047, -1.66245034729052, 218, 42, 'PPL', 'P'),
(158912, 'Baoba', 41.4813919067383, 0.723986867082712, -75.091667175293, -1.31059683302061, 218, 45, 'PPL', 'P'),
(193109, 'Bapchule', 33.1363906860352, 0.578339119698496, -111.872497558594, -1.95254342482678, 218, 5, 'PPL', 'P'),
(134087, 'Baptism Crossing', 47.5297203063965, 0.829550111898627, -91.3411102294922, -1.59420311593171, 218, 28, 'PPL', 'P'),
(34666, 'Baptist', 37.7313919067383, 0.658537020132924, -83.4791717529297, -1.45698640392647, 218, 21, 'PPL', 'P'),
(39217, 'Baptist', 30.5047206878662, 0.532407813404495, -90.5330581665039, -1.58009994690503, 218, 22, 'PPL', 'P'),
(124173, 'Baptist Corner', 42.5519409179688, 0.742671472132653, -72.7633285522461, -1.26995965794709, 218, 23, 'PPL', 'P'),
(124174, 'Baptist Corners', 42.6994400024414, 0.745245816800378, -72.2699966430664, -1.26134939182676, 218, 23, 'PPL', 'P'),
(146994, 'Baptist Corners', 42.9036102294922, 0.748809259496959, -76.4686126708984, -1.33462906553943, 218, 40, 'PPL', 'P'),
(79651, 'Baptist Hill', 32.7330589294434, 0.571299652568117, -80.2688903808594, -1.4009564240684, 218, 48, 'PPL', 'P'),
(112934, 'Baptist Hill', 32.5158309936523, 0.567508309861253, -87.8313903808594, -1.53294694875047, 218, 2, 'PPL', 'P'),
(171706, 'Baptist Hill', 44.4419403076172, 0.775658184342702, -71.7244415283203, -1.25182765882334, 218, 55, 'PPL', 'P'),
(84815, 'Baptist Ridge', 36.4838905334473, 0.636764013745845, -85.524169921875, -1.49267835517182, 218, 50, 'PPL', 'P'),
(124175, 'Baptist Village', 42.0472183227539, 0.733862401036943, -72.470832824707, -1.26485464445352, 218, 23, 'PPL', 'P'),
(144790, 'Baptistown', 40.521671295166, 0.707236582511522, -75.0063934326172, -1.30910852544542, 218, 37, 'PPL', 'P'),
(92429, 'Bar Colonia Number 6', 26.3379993438721, 0.459684806938674, -98.1989974975586, -1.71389582849007, 218, 51, 'PPL', 'P'),
(44585, 'Bar Harbor', 39.1575012207031, 0.683427323154968, -76.508056640625, -1.33531749268122, 218, 25, 'PPL', 'P'),
(126821, 'Bar Harbor', 44.3875007629395, 0.774708035044788, -68.2044372558594, -1.19039199458463, 218, 26, 'PPL', 'P'),
(44586, 'Bar Harbor Manor', 39.1552810668945, 0.683388574161108, -76.5094375610352, -1.33534159428908, 218, 25, 'PPL', 'P'),
(179938, 'Bar J Ranch', 38.6619415283203, 0.674778174882718, -121.009719848633, -2.11201803827458, 218, 6, 'PPL', 'P'),
(129665, 'Bar Lake', 44.2975006103516, 0.773137236054833, -86.3069381713867, -1.50634023840587, 218, 27, 'PPL', 'P'),
(126823, 'Bar Mills', 43.6130599975586, 0.761191493827228, -70.5502777099609, -1.23133463423518, 218, 26, 'PPL', 'P'),
(92430, 'Bar Number 2 Colonia', 26.3360004425049, 0.459649919528394, -98.1240005493164, -1.7125868848143, 218, 51, 'PPL', 'P'),
(92431, 'Bar Number 3 Colonia', 26.318000793457, 0.459335766388305, -97.9769973754883, -1.71002119542011, 218, 51, 'PPL', 'P'),
(92432, 'Bar Number 4 Colonia', 26.2229995727539, 0.457677682293622, -98.1419982910156, -1.71290100466487, 218, 51, 'PPL', 'P'),
(92433, 'Bar Number 5 Colonia', 26.3400001525879, 0.459719727638467, -98.1190032958984, -1.7124996662886, 218, 51, 'PPL', 'P'),
(92434, 'Bar Number 7 Colonia', 26.201000213623, 0.45729372104346, -98.0879974365234, -1.71195851195509, 218, 51, 'PPL', 'P'),
(209291, 'Bar Nunn', 42.9136085510254, 0.748983763127386, -106.342781066895, -1.8560316653448, 218, 59, 'PPL', 'P'),
(122189, 'Bar-Barry Heights', 40.4561080932617, 0.706092288770142, -86.9158325195313, -1.51696744957778, 218, 19, 'PPL', 'P'),
(114505, 'Bar-Jac Mobile Estates', 41.8597183227539, 0.730589908689454, -94.1083297729492, -1.64250020809057, 218, 16, 'PPL', 'P'),
(44588, 'Bar-Klee Estates', 39.452220916748, 0.688571152221429, -76.9963912963867, -1.34384054027585, 218, 25, 'PPL', 'P'),
(173048, 'Baraboo', 43.4711112976074, 0.758714021644154, -89.7441711425781, -1.56633127091127, 218, 57, 'PPL', 'P'),
(112936, 'Barachias', 32.2994384765625, 0.563731547961357, -86.1963882446289, -1.50441077819611, 218, 2, 'PPL', 'P'),
(141231, 'Barada', 40.2186088562012, 0.701947145112461, -95.5774993896484, -1.66814205517224, 218, 35, 'PPL', 'P'),
(92435, 'Barado', 30.6238899230957, 0.534487708926333, -95.4794387817383, -1.6664305746977, 218, 51, 'PPL', 'P'),
(129666, 'Baraga', 46.7786102294922, 0.816440768011739, -88.4888916015625, -1.54442250988762, 218, 27, 'PPL', 'P'),
(34667, 'Baralto', 37.9813919067383, 0.66290034326291, -84.5155563354492, -1.47507472720834, 218, 21, 'PPL', 'P'),
(209936, 'Baranof', 57.0894393920898, 0.996398685509718, -134.833053588867, -2.35328072564369, 218, 1, 'PPL', 'P'),
(39218, 'Barataria', 29.7230606079102, 0.51876527137786, -90.1236114501953, -1.57295375359397, 218, 22, 'PPL', 'P'),
(58543, 'Barbara', 30.9919395446777, 0.540911386633659, -88.9783325195313, -1.55296486540016, 218, 30, 'PPL', 'P'),
(7255, 'Barbara (historical)', 36.0916709899902, 0.629918491321851, -94.1616668701172, -1.64343111604961, 218, 4, 'PPL', 'P'),
(92436, 'Barbarosa', 29.7011108398438, 0.518382175655052, -98.0027770996094, -1.71047113648628, 218, 51, 'PPL', 'P'),
(129669, 'Barbeau', 46.2886085510254, 0.807888625382195, -84.2811126708984, -1.47098291335149, 218, 27, 'PPL', 'P'),
(62702, 'Barbecue', 35.3358306884766, 0.616726589441171, -79.0388870239258, -1.37948881567933, 218, 33, 'PPL', 'P'),
(58544, 'Barbee', 34.4311103820801, 0.6009362412849, -90.459716796875, -1.57881989852709, 218, 30, 'PPL', 'P'),
(122190, 'Barbee', 41.290828704834, 0.720660911776339, -85.7122192382813, -1.49596043489923, 218, 19, 'PPL', 'P'),
(7256, 'Barber', 35.1283302307129, 0.613105023253799, -94.0533294677734, -1.64154027167565, 218, 4, 'PPL', 'P'),
(31731, 'Barber', 37.5677795410156, 0.655681445654087, -94.6483306884766, -1.65192500203031, 218, 20, 'PPL', 'P'),
(44589, 'Barber', 38.6419410705566, 0.674429101042836, -76.0202789306641, -1.32680416562456, 218, 25, 'PPL', 'P'),
(62705, 'Barber', 36.122501373291, 0.630456583020102, -76.5927810668945, -1.33679621287648, 218, 33, 'PPL', 'P'),
(75065, 'Barber', 35.7572212219238, 0.624081241686561, -94.8675003051758, -1.65575023346204, 218, 42, 'PPL', 'P'),
(112939, 'Barber', 31.2341709136963, 0.545139121574646, -85.2355575561523, -1.48764111912799, 218, 2, 'PPL', 'P'),
(144788, 'Barber', 40.5305595397949, 0.707391711645019, -74.2583312988281, -1.29605237820131, 218, 37, 'PPL', 'P'),
(179939, 'Barber', 39.7147216796875, 0.69315265482372, -121.834442138672, -2.12641215765035, 218, 6, 'PPL', 'P'),
(194553, 'Barber', 43.5652809143066, 0.760357591510897, -116.11222076416, -2.02654055413712, 218, 17, 'PPL', 'P'),
(195923, 'Barber', 46.3133316040039, 0.808320124057815, -109.384437561035, -1.90911858588222, 218, 31, 'PPL', 'P'),
(7257, 'Barber (historical)', 35.1647186279297, 0.613740120594756, -91.5250015258789, -1.59741262451942, 218, 4, 'PPL', 'P'),
(179940, 'Barber City', 33.7588882446289, 0.589203751681583, -118.023330688477, -2.05989571468398, 218, 6, 'PPL', 'P'),
(177472, 'Barber Corner (historical)', 41.8061103820801, 0.729654273619482, -72.751106262207, -1.26974633874378, 218, 8, 'PPL', 'P'),
(19047, 'Barber Creek Estates', 33.9033317565918, 0.59172476654848, -83.461669921875, -1.45668093934944, 218, 13, 'PPL', 'P'),
(188106, 'Barber Crossing', 32.485279083252, 0.566975078431992, -104.396110534668, -1.82205585510589, 218, 38, 'PPL', 'P'),
(15094, 'Barber Quarters', 27.2522201538086, 0.475640970162315, -80.8394393920898, -1.41091438285837, 218, 12, 'PPL', 'P'),
(39219, 'Barber Spur', 30.6908302307129, 0.535656037696551, -92.4266662597656, -1.61314964287486, 218, 22, 'PPL', 'P'),
(19048, 'Barbers', 31.2216701507568, 0.544920942102341, -83.7213897705078, -1.46121390584086, 218, 13, 'PPL', 'P'),
(202973, 'Barbers', 40.6763916015625, 0.709936961277835, -111.939170837402, -1.95370709306509, 218, 52, 'PPL', 'P'),
(118717, 'Barbers Corners', 41.7108306884766, 0.727991329255809, -88.0683288574219, -1.53708230529115, 218, 18, 'PPL', 'P'),
(44590, 'Barbers Quarter', 38.374439239502, 0.669760313335818, -76.8411102294922, -1.34113037439253, 218, 25, 'PPL', 'P'),
(29150, 'Barbersville', 38.9058303833008, 0.679034838411046, -85.2808303833008, -1.48843127902342, 218, 19, 'PPL', 'P'),
(44591, 'Barbersville Trailer Park', 39.0902786254883, 0.682254067536734, -76.8249969482422, -1.34084914458142, 218, 25, 'PPL', 'P'),
(154182, 'Barberton', 41.0127792358398, 0.715808033058969, -81.6052780151367, -1.42428078836948, 218, 41, 'PPL', 'P'),
(206762, 'Barberton', 45.6933288574219, 0.79749903475855, -122.597778320313, -2.13973488731958, 218, 56, 'PPL', 'P'),
(144789, 'Barbertown', 40.485279083252, 0.706601418591538, -75.0274963378906, -1.30947684062418, 218, 37, 'PPL', 'P'),
(158916, 'Barbertown (historical)', 41.3711090087891, 0.722062067404857, -75.7350006103516, -1.32182511965055, 218, 45, 'PPL', 'P'),
(15095, 'Barberville', 29.186939239502, 0.509408188308839, -81.4211120605469, -1.42106648609181, 218, 12, 'PPL', 'P'),
(79655, 'Barberville', 35.0325012207031, 0.611432491510202, -80.8763885498047, -1.41155926731633, 218, 48, 'PPL', 'P'),
(146995, 'Barberville', 42.6833305358887, 0.744964653568293, -73.5411071777344, -1.2835344558135, 218, 40, 'PPL', 'P'),
(169270, 'Barberville', 41.5391693115234, 0.72499527302947, -71.6991729736328, -1.25138663934683, 218, 47, 'PPL', 'P'),
(92439, 'Barbosa-Lopez Colonia Number 1', 26.1900005340576, 0.457101740418379, -98.0139999389648, -1.71066701198446, 218, 51, 'PPL', 'P'),
(34668, 'Barbourmeade', 38.2972183227539, 0.668412554087156, -85.6033325195313, -1.49406000314535, 218, 21, 'PPL', 'P'),
(158913, 'Barbours', 41.3930587768555, 0.722445163127665, -76.7997207641602, -1.34040799194685, 218, 45, 'PPL', 'P'),
(99620, 'Barbours Creek', 37.5552787780762, 0.655463266181782, -80.0530624389648, -1.39718951586454, 218, 53, 'PPL', 'P'),
(99621, 'Barboursville', 38.1708297729492, 0.666206657756243, -78.2819366455078, -1.36627753930172, 218, 53, 'PPL', 'P'),
(108086, 'Barboursville', 38.4094390869141, 0.670371175910855, -82.2947235107422, -1.43631388228084, 218, 58, 'PPL', 'P'),
(34669, 'Barbourville', 36.8663902282715, 0.643439892808401, -83.8888931274414, -1.4641373909275, 218, 21, 'PPL', 'P'),
(146996, 'Barbourville', 42.1372184753418, 0.735433200026899, -75.3566665649414, -1.31522194488575, 218, 40, 'PPL', 'P'),
(39220, 'Barbreck', 30.8099994659424, 0.537735933218389, -92.1986083984375, -1.60916928230963, 218, 22, 'PPL', 'P'),
(122191, 'Barce', 40.6208305358887, 0.70896723774591, -87.2766723632813, -1.5232652929236, 218, 19, 'PPL', 'P'),
(7266, 'Barcelona', 35.6205596923828, 0.621696048035259, -94.4558334350586, -1.64856529115712, 218, 4, 'PPL', 'P'),
(39222, 'Barcelona', 31.8525009155273, 0.55593101597046, -91.4227828979492, -1.59562857290518, 218, 22, 'PPL', 'P'),
(146997, 'Barcelona', 42.3402786254883, 0.73897726822655, -79.5961074829102, -1.38921414734808, 218, 40, 'PPL', 'P'),
(189918, 'Barcelona (historical)', 38.648609161377, 0.674545481182472, -116.959442138672, -2.04132735661562, 218, 39, 'PPL', 'P'),
(19050, 'Barcelona Estates', 33.5233306884766, 0.585092496748774, -84.3338928222656, -1.47190410077255, 218, 13, 'PPL', 'P'),
(189914, 'Barcelona Summit', 38.6508293151855, 0.674584230176333, -116.957221984863, -2.04128860762176, 218, 39, 'PPL', 'P'),
(19049, 'Barch Estates', 33.8824996948242, 0.591361178480657, -83.3083267211914, -1.45400459561196, 218, 13, 'PPL', 'P'),
(26444, 'Barclay', 39.8747215270996, 0.69594517896375, -89.5177764892578, -1.56237993880192, 218, 18, 'PPL', 'P'),
(31733, 'Barclay', 38.577220916748, 0.673299521266479, -95.879997253418, -1.67342163887526, 218, 20, 'PPL', 'P'),
(44592, 'Barclay', 39.1441688537598, 0.683194629454723, -75.8644409179688, -1.32408427920326, 218, 25, 'PPL', 'P'),
(92437, 'Barclay', 31.0763893127441, 0.542385313138963, -97.1091690063477, -1.6948747330364, 218, 51, 'PPL', 'P'),
(112941, 'Barclay', 33.4191703796387, 0.583274556409658, -86.1669387817383, -1.50389678810572, 218, 2, 'PPL', 'P'),
(154184, 'Barclay', 41.4541702270508, 0.723511759144241, -80.6255569458008, -1.40718142995841, 218, 41, 'PPL', 'P'),
(158914, 'Barclay', 41.6558303833008, 0.72703139284089, -76.6266708374023, -1.33738770095459, 218, 45, 'PPL', 'P'),
(189915, 'Barclay', 37.5133285522461, 0.654731096619092, -114.250831604004, -1.99405318463146, 218, 39, 'PPL', 'P'),
(62707, 'Barclay Downs', 35.1572189331055, 0.613609226227179, -80.8344421386719, -1.41082716433267, 218, 33, 'PPL', 'P'),
(79652, 'Barclay Estates', 33.5561103820801, 0.58566461032995, -81.9216690063477, -1.42980285288976, 218, 48, 'PPL', 'P'),
(70486, 'Barclay Farm', 39.9058303833008, 0.696488130930989, -74.9941711425781, -1.30889520624211, 218, 37, 'PPL', 'P'),
(79653, 'Barclay Park', 33.5297203063965, 0.585204016619421, -81.6836090087891, -1.42564792211507, 218, 48, 'PPL', 'P'),
(62710, 'Barclaysville', 35.4686088562012, 0.61904400564273, -78.6944427490234, -1.37347712899264, 218, 33, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(62711, 'Barco', 36.3916702270508, 0.635154465762029, -75.9800033569336, -1.32610122425484, 218, 33, 'PPL', 'P'),
(206766, 'Barco', 48.2805595397949, 0.84265472867458, -121.67138671875, -2.12356630370949, 218, 56, 'PPL', 'P'),
(15096, 'Barcola', 27.8341693878174, 0.485797900375228, -81.8827819824219, -1.42912414628595, 218, 12, 'PPL', 'P'),
(34670, 'Barcreek', 37.2272186279297, 0.649737536417139, -83.64111328125, -1.45981281679137, 218, 21, 'PPL', 'P'),
(99622, 'Barcroft', 38.8558311462402, 0.678162187100854, -77.1041717529297, -1.34572166411183, 218, 53, 'PPL', 'P'),
(99623, 'Barcroft Hill', 38.8405609130859, 0.677895671254765, -77.1705627441406, -1.34688040550212, 218, 53, 'PPL', 'P'),
(99624, 'Barcroft Woods', 38.8416709899902, 0.677915045751695, -77.1708297729492, -1.34688506603403, 218, 53, 'PPL', 'P'),
(7259, 'Bard', 36.0744400024414, 0.629617753855754, -90.3769378662109, -1.57737513363572, 218, 4, 'PPL', 'P'),
(77822, 'Bard', 39.9277801513672, 0.696871226653797, -78.6594390869141, -1.37286619983857, 218, 45, 'PPL', 'P'),
(114507, 'Bard', 41.2402801513672, 0.719778673086223, -91.2874984741211, -1.59326741428271, 218, 16, 'PPL', 'P'),
(179941, 'Bard', 32.7891693115234, 0.572278963479966, -114.555282592773, -1.99936685679644, 218, 6, 'PPL', 'P'),
(188107, 'Bard', 35.1286087036133, 0.613109883522789, -103.245277404785, -1.80197002784841, 218, 38, 'PPL', 'P'),
(189916, 'Bard', 35.9877815246582, 0.628105278093671, -115.236671447754, -2.01125933580225, 218, 39, 'PPL', 'P'),
(108087, 'Bardane', 39.3627815246582, 0.687010140348479, -77.8655624389648, -1.35901043847716, 218, 58, 'PPL', 'P'),
(146999, 'Bardeen Corners', 43.3452796936035, 0.75651784585122, -76.1522216796875, -1.32910700101915, 218, 40, 'PPL', 'P'),
(39221, 'Bardel', 32.5508308410645, 0.56811917243629, -91.7574996948242, -1.60147048307237, 218, 22, 'PPL', 'P'),
(134090, 'Barden', 44.7905616760254, 0.781742775064233, -93.4102783203125, -1.63031691189373, 218, 28, 'PPL', 'P'),
(179942, 'Bardi', 37.764720916748, 0.659118721094025, -121.164169311523, -2.11471368992996, 218, 6, 'PPL', 'P'),
(7260, 'Bardill (historical)', 34.5838890075684, 0.603602731326342, -91.4483337402344, -1.59607451922971, 218, 4, 'PPL', 'P'),
(368, 'Bardin', 29.7141704559326, 0.518610108954849, -81.7249984741211, -1.42637030456076, 218, 12, 'PPL', 'P'),
(53331, 'Bardley', 36.6941719055176, 0.640434116044083, -91.1216735839844, -1.59037322396807, 218, 29, 'PPL', 'P'),
(34671, 'Bardo', 36.7597198486328, 0.641578143469354, -83.3444366455078, -1.45463483268393, 218, 21, 'PPL', 'P'),
(118718, 'Bardolph', 40.4949989318848, 0.706771061952976, -90.5644378662109, -1.58064762598321, 218, 18, 'PPL', 'P'),
(146998, 'Bardonia', 41.1094398498535, 0.717495079030507, -73.9966735839844, -1.29148558956404, 218, 40, 'PPL', 'P'),
(179943, 'Bardsdale', 34.3716697692871, 0.59989880688226, -118.931938171387, -2.07575390686902, 218, 6, 'PPL', 'P'),
(7261, 'Bardstown', 35.5355606079102, 0.62021253415003, -90.1600036621094, -1.57358891751395, 218, 4, 'PPL', 'P'),
(34672, 'Bardstown', 37.8091697692871, 0.659894499919565, -85.4669418334961, -1.49167953660499, 218, 21, 'PPL', 'P'),
(34673, 'Bardstown Junction', 37.939998626709, 0.662177894238199, -85.6994400024414, -1.49573739515794, 218, 21, 'PPL', 'P'),
(34674, 'Bardwell', 36.8705596923828, 0.643512663685188, -89.0097198486328, -1.55351267763639, 218, 21, 'PPL', 'P'),
(71738, 'Bardwell', 39.047779083252, 0.68151231059412, -83.9219436645508, -1.46471423161961, 218, 41, 'PPL', 'P'),
(92438, 'Bardwell', 32.2688903808594, 0.563198383111123, -96.6958312988281, -1.68766062911754, 218, 51, 'PPL', 'P'),
(124177, 'Bardwell', 42.2183303833008, 0.736848869883358, -72.3694381713867, -1.26308497390916, 218, 23, 'PPL', 'P'),
(158918, 'Bardwell', 41.5611114501953, 0.725378235594224, -75.8625030517578, -1.32405045705742, 218, 45, 'PPL', 'P'),
(173052, 'Bardwell', 42.5869407653809, 0.74328233470769, -88.7505569458008, -1.54898943168295, 218, 57, 'PPL', 'P'),
(44593, 'Bare Hills', 39.3811111450195, 0.687330052574425, -76.6536102294922, -1.33785788204504, 218, 25, 'PPL', 'P'),
(7262, 'Bare Stone', 35.4280586242676, 0.618336270583042, -91.6388931274414, -1.59940040795706, 218, 4, 'PPL', 'P'),
(112940, 'Barefield Crossroads', 31.5516700744629, 0.550680527302342, -85.4524993896484, -1.49142746840781, 218, 2, 'PPL', 'P'),
(884, 'Barefoot', 33.7033309936523, 0.588234094728685, -81.4775009155273, -1.42205065727265, 218, 48, 'PPL', 'P'),
(34675, 'Barefoot', 38.4236106872559, 0.670618516997096, -84.116943359375, -1.46811761833467, 218, 21, 'PPL', 'P'),
(84817, 'Barefoot', 36.6358299255371, 0.639415856401292, -86.1922225952148, -1.50433807389835, 218, 50, 'PPL', 'P'),
(44594, 'Barefoot Acres', 38.2874984741211, 0.668242910725718, -76.5072174072266, -1.33530284529522, 218, 25, 'PPL', 'P'),
(44595, 'Barefoot Park', 38.6897201538086, 0.675263003359167, -76.5788879394531, -1.33655373205923, 218, 25, 'PPL', 'P'),
(186384, 'Barela', 37.1155586242676, 0.647788701710446, -104.261108398438, -1.81969962333145, 218, 7, 'PPL', 'P'),
(188108, 'Barelas', 35.0730590820313, 0.612140359727945, -106.656112670898, -1.86150033348522, 218, 38, 'PPL', 'P'),
(158917, 'Bareville', 40.0922203063965, 0.699741248781548, -76.1561126708984, -1.32917491162695, 218, 45, 'PPL', 'P'),
(7263, 'Barfield', 35.9049987792969, 0.626660446623275, -89.7677764892578, -1.56674326193191, 218, 4, 'PPL', 'P'),
(84819, 'Barfield', 35.7849998474121, 0.62456607016301, -86.4266662597656, -1.5084298877552, 218, 50, 'PPL', 'P'),
(112942, 'Barfield', 33.3611106872559, 0.582261223614883, -85.7158279418945, -1.49602341865901, 218, 2, 'PPL', 'P'),
(84818, 'Barfield Meadows', 35.7911109924316, 0.624672729764667, -86.442497253418, -1.5087061907183, 218, 50, 'PPL', 'P'),
(79654, 'Barfield Mill', 34.4838905334473, 0.601857428705959, -80.5299987792969, -1.40551362532574, 218, 48, 'PPL', 'P'),
(58545, 'Barfoot', 32.5808296203613, 0.568642749906599, -89.1800003051758, -1.55648463225487, 218, 30, 'PPL', 'P'),
(99625, 'Barfoot', 36.978328704834, 0.645393587784083, -79.9297180175781, -1.39503674959737, 218, 53, 'PPL', 'P'),
(70487, 'Bargaintown', 39.3624992370605, 0.687005213500463, -74.5813903808594, -1.30169082286122, 218, 37, 'PPL', 'P'),
(7264, 'Barger Addition', 34.9861106872559, 0.610622823959791, -92.1097183227539, -1.6076178578166, 218, 4, 'PPL', 'P'),
(108088, 'Bargers Springs', 37.6141700744629, 0.656491113204498, -80.758056640625, -1.40949398589098, 218, 58, 'PPL', 'P'),
(29151, 'Bargersville', 39.5208282470703, 0.689768576026556, -86.1677780151367, -1.50391143549172, 218, 19, 'PPL', 'P'),
(84820, 'Bargerton', 35.7319412231445, 0.623640022472962, -88.4855575561523, -1.54436431981781, 218, 50, 'PPL', 'P'),
(177474, 'Bargytown', 41.5125007629395, 0.724529819049952, -72.1655578613281, -1.25952659121865, 218, 8, 'PPL', 'P'),
(7265, 'Barham', 33.7236099243164, 0.588588028837557, -93.0538864135742, -1.62409669969369, 218, 4, 'PPL', 'P'),
(39223, 'Barham', 31.3191699981689, 0.546622635459875, -93.392219543457, -1.63000172677872, 218, 22, 'PPL', 'P'),
(62712, 'Barham', 35.9419403076172, 0.627305197923184, -78.4044418334961, -1.36841565818289, 218, 33, 'PPL', 'P'),
(99627, 'Barham', 37.1411094665527, 0.64823464803498, -77.1130599975586, -1.34587679324533, 218, 53, 'PPL', 'P'),
(206763, 'Barham', 47.084171295166, 0.82177381467365, -119.011940002441, -2.07715020222855, 218, 56, 'PPL', 'P'),
(99626, 'Barhamsville', 37.4544410705566, 0.653703316175403, -76.8405609130859, -1.34112078701261, 218, 53, 'PPL', 'P'),
(19052, 'Barin', 32.5888900756836, 0.568783431391183, -84.9463882446289, -1.48259416254618, 218, 13, 'PPL', 'P'),
(126824, 'Baring', 45.1361083984375, 0.787773703089799, -67.3172225952148, -1.17490717758442, 218, 26, 'PPL', 'P'),
(139023, 'Baring', 40.2441711425781, 0.702393291174077, -92.2055587768555, -1.60929058929728, 218, 29, 'PPL', 'P'),
(206764, 'Baring', 47.7733306884766, 0.833801915157965, -121.484169006348, -2.12029873821001, 218, 56, 'PPL', 'P'),
(194554, 'Barite', 43.5563888549805, 0.760202395798372, -114.325561523438, -1.99535746777533, 218, 17, 'PPL', 'P'),
(195924, 'Barite', 46.9452781677246, 0.819349672291405, -113.437782287598, -1.97986279707908, 218, 31, 'PPL', 'P'),
(62713, 'Barium Springs', 35.7188911437988, 0.623412255620733, -80.8983306884766, -1.41194222988109, 218, 33, 'PPL', 'P'),
(53332, 'Bark Camp (historical)', 36.252498626709, 0.632725463110794, -90.0888900756836, -1.57234775128792, 218, 29, 'PPL', 'P'),
(19054, 'Bark Camp Place', 34.3794403076172, 0.600034428360772, -83.8880615234375, -1.46412287669955, 218, 13, 'PPL', 'P'),
(44596, 'Bark Hill', 39.586669921875, 0.690917730036925, -77.1527786254883, -1.34657001407708, 218, 25, 'PPL', 'P'),
(173053, 'Bark Point', 46.8875007629395, 0.818341266344647, -91.1833267211914, -1.59144927420652, 218, 57, 'PPL', 'P'),
(194101, 'Bark Ranch', 40.1175003051758, 0.700182467995147, -105.438888549805, -1.84025576483744, 218, 7, 'PPL', 'P'),
(129670, 'Bark River', 45.7102813720703, 0.797794911955658, -87.3047180175781, -1.52375478193196, 218, 27, 'PPL', 'P'),
(7268, 'Barkada', 33.6730613708496, 0.587705790147441, -91.9022216796875, -1.60399635820826, 218, 4, 'PPL', 'P'),
(202970, 'Barke Circle', 40.6647186279297, 0.709733229454444, -111.927223205566, -1.95349856755174, 218, 52, 'PPL', 'P'),
(19053, 'Barker', 33.0119400024414, 0.576167045513427, -84.4702835083008, -1.47428456731292, 218, 13, 'PPL', 'P'),
(92440, 'Barker', 29.7841701507568, 0.519831834104923, -95.6847229003906, -1.67001345847023, 218, 51, 'PPL', 'P'),
(108089, 'Barker', 39.5794410705566, 0.690791562780283, -80.6605606079102, -1.40779235911247, 218, 58, 'PPL', 'P'),
(147000, 'Barker', 43.3300018310547, 0.756251196847076, -78.5550003051758, -1.37104339923047, 218, 40, 'PPL', 'P'),
(195926, 'Barker', 46.5344390869141, 0.812179177635394, -111.488609313965, -1.9458433109983, 218, 31, 'PPL', 'P'),
(206765, 'Barker', 48.5774993896484, 0.847837306734901, -119.480827331543, -2.08533382994226, 218, 56, 'PPL', 'P'),
(129672, 'Barker Creek', 44.7802810668945, 0.781563344585789, -85.3133316040039, -1.4889985323356, 218, 27, 'PPL', 'P'),
(99630, 'Barker Crossroads', 36.6197204589844, 0.639134693169206, -78.0119400024414, -1.36156520891088, 218, 53, 'PPL', 'P'),
(62714, 'Barker Heights', 35.3111114501953, 0.616295157344578, -82.4441680908203, -1.43892218225246, 218, 33, 'PPL', 'P'),
(99628, 'Barker Land', 39.0736083984375, 0.681963117187643, -77.8897171020508, -1.35943201687772, 218, 53, 'PPL', 'P'),
(99629, 'Barker Mill', 36.7005615234375, 0.64054563591473, -82.3197174072266, -1.43675010806739, 218, 53, 'PPL', 'P'),
(19057, 'Barker Spring', 32.9213905334473, 0.574586659143547, -84.4383316040039, -1.47372690138065, 218, 13, 'PPL', 'P'),
(15097, 'Barker Store', 30.9141693115234, 0.539554040005073, -85.9161071777344, -1.4995189507478, 218, 12, 'PPL', 'P'),
(62715, 'Barker Ten Mile', 34.6797218322754, 0.605275329648966, -78.9888916015625, -1.37861623094816, 218, 33, 'PPL', 'P'),
(19055, 'Barkers Crossroads', 33.3738899230957, 0.582484263356177, -85.1711120605469, -1.48651633304159, 218, 13, 'PPL', 'P'),
(99631, 'Barkers Crossroads', 38.7583312988281, 0.676460493743321, -77.2163925170898, -1.34768028593553, 218, 53, 'PPL', 'P'),
(147001, 'Barkers Grove', 42.9877815246582, 0.750278325733274, -73.5522232055664, -1.28372846709891, 218, 40, 'PPL', 'P'),
(13322, 'Barkers Landing', 39.0849990844727, 0.682161922163017, -75.4574966430664, -1.31698176173408, 218, 10, 'PPL', 'P'),
(34677, 'Barkers Mill', 36.6680603027344, 0.639978382602544, -87.3477783203125, -1.52450632599158, 218, 21, 'PPL', 'P'),
(99632, 'Barkers Mill', 37.5605583190918, 0.655555411555499, -77.258056640625, -1.34840746207118, 218, 53, 'PPL', 'P'),
(147002, 'Barkersville', 43.0883293151855, 0.752033215733581, -74.0400009155273, -1.29224179415557, 218, 40, 'PPL', 'P'),
(84821, 'Barkertown', 35.3916702270508, 0.617701173242085, -85.5530624389648, -1.49318262472423, 218, 50, 'PPL', 'P'),
(147003, 'Barkertown', 42.5513916015625, 0.742661884752729, -77.9002838134766, -1.35961644078321, 218, 40, 'PPL', 'P'),
(79657, 'Barkerville', 32.7055587768555, 0.570819684360657, -80.9369430541992, -1.41261614279493, 218, 48, 'PPL', 'P'),
(124178, 'Barkerville', 42.4225006103516, 0.740412312579939, -73.3091735839844, -1.27948645095658, 218, 23, 'PPL', 'P'),
(193111, 'Barkerville', 32.8316688537598, 0.573020720422581, -110.944717407227, -1.93635060645077, 218, 5, 'PPL', 'P'),
(179944, 'Barkerville (historical)', 39.1544418334961, 0.683373926775112, -122.561393737793, -2.13909985655765, 218, 6, 'PPL', 'P'),
(158919, 'Barkeyville', 41.1919403076172, 0.718934983652886, -79.975830078125, -1.3958415568788, 218, 45, 'PPL', 'P'),
(177475, 'Barkhampsted Center', 41.9288902282715, 0.731797186190614, -72.9669418334961, -1.27351338010569, 218, 8, 'PPL', 'P'),
(177476, 'Barkhamsted', 41.9291687011719, 0.731802046459604, -72.914436340332, -1.2725969863746, 218, 8, 'PPL', 'P'),
(158921, 'Barking', 40.5327796936035, 0.70743046063888, -79.7822189331055, -1.39246240492965, 218, 45, 'PPL', 'P'),
(13323, 'Barkley', 39.8319396972656, 0.695198495173118, -75.5188903808594, -1.31805328459867, 218, 10, 'PPL', 'P'),
(53333, 'Barkley', 39.7363891601563, 0.693530823698511, -91.5094375610352, -1.59714098208823, 218, 29, 'PPL', 'P'),
(200367, 'Barkley (historical)', 42.3819389343262, 0.739704377783169, -121.809722900391, -2.12598072555375, 218, 43, 'PPL', 'P'),
(39224, 'Barkley Place', 30.3677806854248, 0.530017759484203, -91.0819396972656, -1.58967973682021, 218, 22, 'PPL', 'P'),
(34676, 'Barkley Shores', 36.7574996948242, 0.641539394475493, -87.9641723632813, -1.53526443153106, 218, 21, 'PPL', 'P'),
(92441, 'Barkman', 33.5252799987793, 0.585126518631699, -94.2441711425781, -1.64487108725101, 218, 51, 'PPL', 'P'),
(19056, 'Barko Village', 30.9041690826416, 0.539379503085132, -83.3349990844727, -1.45447011617051, 218, 13, 'PPL', 'P'),
(44600, 'Barksdale', 39.6688919067383, 0.692352774390314, -75.8150024414063, -1.32322141501008, 218, 25, 'PPL', 'P'),
(58546, 'Barksdale', 34.2238883972168, 0.597319535366518, -90.3947219848633, -1.57768552506077, 218, 30, 'PPL', 'P'),
(79658, 'Barksdale', 34.5694389343262, 0.603350529971111, -82.0875015258789, -1.43269717636246, 218, 48, 'PPL', 'P'),
(99636, 'Barksdale', 36.6150016784668, 0.639052334912496, -79.1563873291016, -1.38153958287674, 218, 53, 'PPL', 'P'),
(108090, 'Barksdale', 37.7075004577637, 0.658120035685245, -80.8866729736328, -1.41173876437381, 218, 58, 'PPL', 'P'),
(173055, 'Barksdale', 46.6213912963867, 0.813696779982576, -90.9319381713867, -1.58706171631061, 218, 57, 'PPL', 'P'),
(191108, 'Barksdale', 29.7250003814697, 0.518799126813217, -100.03360748291, -1.74591581322442, 218, 51, 'PPL', 'P'),
(44598, 'Barksdale Farms', 39.6655616760254, 0.692294650899523, -75.8127822875977, -1.32318266601622, 218, 25, 'PPL', 'P'),
(58547, 'Barland', 31.8875007629395, 0.556541878545497, -90.8105621337891, -1.58494330482151, 218, 30, 'PPL', 'P'),
(99634, 'Barlett', 36.9408302307129, 0.644739115946196, -76.5374984741211, -1.33583134961355, 218, 53, 'PPL', 'P'),
(99635, 'Barley', 36.5638885498047, 0.638160242526347, -77.7244415283203, -1.356547413943, 218, 53, 'PPL', 'P'),
(13324, 'Barley Woods', 39.7727813720703, 0.694165987618495, -75.6133270263672, -1.31970151499732, 218, 10, 'PPL', 'P'),
(7270, 'Barling', 35.3255615234375, 0.616547358699808, -94.3013916015625, -1.64586977265979, 218, 4, 'PPL', 'P'),
(34678, 'Barlow', 37.0516700744629, 0.64667363616203, -89.0466690063477, -1.55415756209435, 218, 21, 'PPL', 'P'),
(58548, 'Barlow', 31.8225002288818, 0.555407405210637, -90.649169921875, -1.58212647933653, 218, 30, 'PPL', 'P'),
(71739, 'Barlow', 39.398609161377, 0.68763545057243, -81.6650009155273, -1.42532314962014, 218, 41, 'PPL', 'P'),
(77823, 'Barlow', 39.7552795410156, 0.693860523041463, -77.2302780151367, -1.34792263359473, 218, 45, 'PPL', 'P'),
(112944, 'Barlow', 31.5666694641113, 0.550942316037497, -88.3236083984375, -1.54153777379485, 218, 2, 'PPL', 'P'),
(139636, 'Barlow', 47.5697212219238, 0.830248259578391, -99.1374969482422, -1.73027573393266, 218, 34, 'PPL', 'P'),
(179945, 'Barlow', 38.4249992370605, 0.670642751763016, -122.857498168945, -2.144267853811, 218, 6, 'PPL', 'P'),
(194555, 'Barlow', 43.6711082458496, 0.762204626884921, -112.012222290039, -1.95498208143696, 218, 17, 'PPL', 'P'),
(200368, 'Barlow', 45.2519416809082, 0.789795375252305, -122.719436645508, -2.1418582256567, 218, 43, 'PPL', 'P'),
(53334, 'Barlow (historical)', 37.0138893127441, 0.646014237476126, -90.6138916015625, -1.5815107564925, 218, 29, 'PPL', 'P'),
(108091, 'Barlow (historical)', 38.3944396972656, 0.6701093871757, -81.5827789306641, -1.42388810526675, 218, 58, 'PPL', 'P'),
(112943, 'Barlow Bend', 31.454439163208, 0.54898352776623, -87.6347198486328, -1.52951440042147, 218, 2, 'PPL', 'P'),
(158922, 'Barlow Heights', 40.211669921875, 0.70182603786189, -75.5449981689453, -1.31850895146118, 218, 45, 'PPL', 'P'),
(77824, 'Barlow Knoll', 39.8452796936035, 0.695431322031419, -77.2263870239258, -1.34785472298693, 218, 45, 'PPL', 'P'),
(112945, 'Barlow Landing', 30.9572200775146, 0.540305417617125, -87.8724975585938, -1.53366440434814, 218, 2, 'PPL', 'P'),
(118719, 'Barlow Park', 40.309440612793, 0.703532458330358, -87.6230621337891, -1.52931093491419, 218, 18, 'PPL', 'P'),
(62717, 'Barlowes', 34.4455604553223, 0.601188442640131, -77.5977783203125, -1.35433672392213, 218, 33, 'PPL', 'P'),
(99637, 'Barlows Corner', 37.3586082458496, 0.652030717852779, -76.7172164916992, -1.33896802074544, 218, 53, 'PPL', 'P'),
(124179, 'Barlows Landing', 41.6908302307129, 0.727642255415927, -70.6255569458008, -1.23264850475897, 218, 23, 'PPL', 'P'),
(39226, 'Barmen', 30.1622200012207, 0.526430048732189, -90.8161087036133, -1.58504011072713, 218, 22, 'PPL', 'P'),
(108092, 'Barnabus', 37.7438888549805, 0.658755133026202, -82.0094375610352, -1.43133470314877, 218, 58, 'PPL', 'P'),
(44599, 'Barnaby Manor Oaks', 38.8180618286133, 0.677502988152033, -76.9680633544922, -1.34334612441948, 218, 25, 'PPL', 'P'),
(13032, 'Barnaby Terrace', 38.8333282470703, 0.677769437419095, -76.9894409179688, -1.3437192332882, 218, 9, 'PPL', 'P'),
(13033, 'Barnaby Woods', 38.9747200012207, 0.68023718906419, -77.0599975585938, -1.34495067897625, 218, 9, 'PPL', 'P'),
(29152, 'Barnard', 39.8486099243164, 0.69548944552221, -86.7005615234375, -1.5132102619119, 218, 19, 'PPL', 'P'),
(31735, 'Barnard', 39.190559387207, 0.684004297005134, -98.0416717529297, -1.71114997624814, 218, 20, 'PPL', 'P'),
(62718, 'Barnard', 35.8394393920898, 0.625516219460923, -82.7541732788086, -1.44433279348112, 218, 33, 'PPL', 'P'),
(70488, 'Barnard', 39.6208305358887, 0.691513945225967, -74.7847213745117, -1.30523961817181, 218, 37, 'PPL', 'P'),
(126826, 'Barnard', 45.3663902282715, 0.791792879227919, -69.2074966430664, -1.20789868348443, 218, 26, 'PPL', 'P'),
(129673, 'Barnard', 45.2511100769043, 0.789780861024364, -85.3011093139648, -1.48878521313229, 218, 27, 'PPL', 'P'),
(139024, 'Barnard', 40.1744384765625, 0.70117622655591, -94.8236083984375, -1.65498417517448, 218, 29, 'PPL', 'P'),
(147004, 'Barnard', 43.2125015258789, 0.754200429649661, -77.6430587768555, -1.35512701697561, 218, 40, 'PPL', 'P'),
(169793, 'Barnard', 45.7324981689453, 0.798182668210374, -98.4961090087891, -1.71908140260662, 218, 49, 'PPL', 'P'),
(171707, 'Barnard', 43.7286109924316, 0.763208239141717, -72.6194381713867, -1.26744829703915, 218, 55, 'PPL', 'P'),
(126828, 'Barnard Corner', 45.3072204589844, 0.790760171936214, -69.1236114501953, -1.20643461067516, 218, 26, 'PPL', 'P'),
(118720, 'Barnard Mill (historical)', 42.4172210693359, 0.740320167206222, -88.3608322143555, -1.54218745194278, 218, 18, 'PPL', 'P'),
(158923, 'Barnards', 40.8252792358398, 0.71253554071148, -79.2300033569336, -1.38282442494465, 218, 45, 'PPL', 'P'),
(62719, 'Barnardsville', 35.7775001525879, 0.624435175795432, -82.4550018310547, -1.43911126668986, 218, 33, 'PPL', 'P'),
(84823, 'Barnardsville', 35.7611083984375, 0.624149085715331, -84.5991668701172, -1.47653400632765, 218, 50, 'PPL', 'P'),
(70489, 'Barnegat', 39.753059387207, 0.693821774047602, -74.2233276367188, -1.29544144904724, 218, 37, 'PPL', 'P'),
(147006, 'Barnegat', 41.6319389343262, 0.726614408393211, -73.9472198486328, -1.29062245905475, 218, 40, 'PPL', 'P'),
(200369, 'Barnegat (historical)', 45.5055618286133, 0.794221881879153, -123.943061828613, -2.16321451391221, 218, 43, 'PPL', 'P'),
(70490, 'Barnegat Bay', 39.7580604553223, 0.693909059152329, -74.1919403076172, -1.29489363681101, 218, 37, 'PPL', 'P'),
(70491, 'Barnegat Bay Estates', 39.9708290100098, 0.697622570976336, -74.129997253418, -1.2938125265665, 218, 37, 'PPL', 'P'),
(70492, 'Barnegat Beach', 39.7786102294922, 0.694267720372136, -74.1911087036133, -1.29487912258307, 218, 37, 'PPL', 'P'),
(70493, 'Barnegat Estates', 39.7611083984375, 0.693962255795104, -74.2594375610352, -1.29607168611921, 218, 37, 'PPL', 'P'),
(70494, 'Barnegat Light', 39.7574996948242, 0.693899272035323, -74.1066665649414, -1.29340532923582, 218, 37, 'PPL', 'P'),
(70496, 'Barnegat Pines', 39.896110534668, 0.696318487569551, -74.2102813720703, -1.29521374877404, 218, 37, 'PPL', 'P'),
(158924, 'Barners Hill', 40.3480606079102, 0.704206504402257, -79.7386093139648, -1.3917012734901, 218, 45, 'PPL', 'P'),
(147007, 'Barnerville', 42.6875, 0.745037424445079, -74.4269409179688, -1.29899517120585, 218, 40, 'PPL', 'P'),
(7271, 'Barnes', 35.6352806091309, 0.621952976501424, -93.8202819824219, -1.63747282574277, 218, 4, 'PPL', 'P'),
(19058, 'Barnes', 34.2730598449707, 0.598177739027796, -83.9166717529297, -1.46462221940394, 218, 13, 'PPL', 'P'),
(31736, 'Barnes', 39.7119407653809, 0.693104118712853, -96.8741683959961, -1.69077319864157, 218, 20, 'PPL', 'P'),
(39225, 'Barnes', 32.3791694641113, 0.565123116209951, -91.1230621337891, -1.59039745873399, 218, 22, 'PPL', 'P'),
(58549, 'Barnes', 32.9022216796875, 0.574252099531606, -89.5016708374023, -1.56209884214886, 218, 30, 'PPL', 'P'),
(84825, 'Barnes', 36.3530616760254, 0.634480619427211, -82.3105621337891, -1.43659031840199, 218, 50, 'PPL', 'P'),
(92442, 'Barnes', 30.8930606842041, 0.539185624957774, -94.6966705322266, -1.65276869146364, 218, 51, 'PPL', 'P'),
(99638, 'Barnes', 38.2208290100098, 0.667079309066435, -78.4486083984375, -1.36918651016041, 218, 53, 'PPL', 'P'),
(112932, 'Barnes', 31.4677791595459, 0.54921635462453, -85.1188888549805, -1.48560486615852, 218, 2, 'PPL', 'P'),
(118721, 'Barnes', 40.5027809143066, 0.70690688316857, -88.9016723632813, -1.55162689326851, 218, 18, 'PPL', 'P'),
(158927, 'Barnes', 41.6780586242676, 0.727419348832687, -79.0280609130859, -1.37929986439999, 218, 45, 'PPL', 'P'),
(202975, 'Barnes', 41.100830078125, 0.717344810165999, -112.064437866211, -1.95589341516199, 218, 52, 'PPL', 'P'),
(62720, 'Barnes (historical)', 35.7122192382813, 0.623295808902069, -78.6580581665039, -1.37284209823071, 218, 33, 'PPL', 'P'),
(189919, 'Barnes (historical)', 38.9513893127441, 0.679829991733517, -115.138893127441, -2.00955278217572, 218, 39, 'PPL', 'P'),
(114508, 'Barnes City', 41.5083312988281, 0.724457048173165, -92.4680633544922, -1.6138721584786, 218, 16, 'PPL', 'P'),
(44601, 'Barnes Corner', 39.6749992370605, 0.692459367412945, -76.0658264160156, -1.32759911920995, 218, 25, 'PPL', 'P'),
(147008, 'Barnes Corners', 43.8169403076172, 0.764749876517737, -75.8180618286133, -1.32327481138993, 218, 40, 'PPL', 'P'),
(154185, 'Barnes Corners', 41.5097198486328, 0.724481282939085, -81.0519409179688, -1.41462323415047, 218, 41, 'PPL', 'P'),
(154186, 'Barnes Corners (historical)', 41.6780586242676, 0.727419348832687, -80.9105606079102, -1.41215568224246, 218, 41, 'PPL', 'P'),
(19059, 'Barnes Crossroads', 32.9669418334961, 0.575381679307963, -84.6902770996094, -1.47812417981454, 218, 13, 'PPL', 'P'),
(77825, 'Barnes Gap', 39.7436103820801, 0.693656857797099, -78.355827331543, -1.36756717505959, 218, 45, 'PPL', 'P'),
(200370, 'Barnes Heights', 45.5325012207031, 0.794692062969607, -122.752777099609, -2.14244012635488, 218, 43, 'PPL', 'P'),
(147009, 'Barnes Hole', 40.9991683959961, 0.715570479089734, -72.133056640625, -1.25895933790647, 218, 40, 'PPL', 'P'),
(99639, 'Barnes Junction', 36.8205604553223, 0.642640012374996, -78.595832824707, -1.37175606113817, 218, 53, 'PPL', 'P'),
(44602, 'Barnes Landing', 38.3902816772461, 0.670036816035995, -76.1052780151367, -1.32828767950979, 218, 25, 'PPL', 'P'),
(147010, 'Barnes Landing', 41.0044403076172, 0.715662491305396, -72.1255569458008, -1.25882844353889, 218, 40, 'PPL', 'P'),
(108093, 'Barnes Mill', 39.3511085510254, 0.686806408525088, -78.6366729736328, -1.37246885620393, 218, 58, 'PPL', 'P'),
(58550, 'Barnes Prairie', 32.4213905334473, 0.565860012883576, -90.0141677856445, -1.57104360130211, 218, 30, 'PPL', 'P'),
(79660, 'Barnes Station', 34.2591705322266, 0.597935324789572, -82.6808319091797, -1.44305274510317, 218, 48, 'PPL', 'P'),
(158934, 'Barnesboro (historical)', 40.6624984741211, 0.709694480460583, -78.7802810668945, -1.37497529026386, 218, 45, 'PPL', 'P'),
(34679, 'Barnesburg', 37.1477813720703, 0.648351094753644, -84.5327835083008, -1.47537539809541, 218, 21, 'PPL', 'P'),
(71741, 'Barnesburg', 39.228889465332, 0.684673283070962, -84.6222229003906, -1.47693640996836, 218, 41, 'PPL', 'P'),
(19060, 'Barnesdale', 31.1863899230957, 0.544305185968801, -83.3733291625977, -1.45513910223634, 218, 13, 'PPL', 'P'),
(200371, 'Barnesdale', 45.6394386291504, 0.796558472840562, -123.853332519531, -2.16164844203318, 218, 43, 'PPL', 'P'),
(141234, 'Barneston', 40.0483283996582, 0.698975190493987, -96.5766677856445, -1.68558083346424, 218, 35, 'PPL', 'P'),
(158929, 'Barneston', 40.1044387817383, 0.699954501405837, -75.8102798461914, -1.32313899017434, 218, 45, 'PPL', 'P'),
(206767, 'Barneston', 47.3877792358398, 0.827072772873608, -121.860000610352, -2.12685823713293, 218, 56, 'PPL', 'P'),
(19061, 'Barnesville', 33.0544395446777, 0.576908802456042, -84.1558303833008, -1.46879632493848, 218, 13, 'PPL', 'P'),
(31738, 'Barnesville', 38.0152816772461, 0.663491831341017, -94.6611099243164, -1.6521480417716, 218, 20, 'PPL', 'P'),
(44606, 'Barnesville', 39.2205581665039, 0.684527874475444, -77.3777770996094, -1.35049697826245, 218, 25, 'PPL', 'P'),
(53336, 'Barnesville', 39.8994407653809, 0.696376611060342, -92.5897216796875, -1.61599549681572, 218, 29, 'PPL', 'P'),
(58551, 'Barnesville', 34.9938888549805, 0.610758578596358, -90.095832824707, -1.57246892511752, 218, 30, 'PPL', 'P'),
(62721, 'Barnesville', 34.4086112976074, 0.600543558182168, -79.0469436645508, -1.37962943058488, 218, 33, 'PPL', 'P'),
(71742, 'Barnesville', 39.9880599975586, 0.697923308442433, -81.1766662597656, -1.4168001020255, 218, 41, 'PPL', 'P'),
(84826, 'Barnesville', 35.4352798461914, 0.61846230468163, -87.3855590820313, -1.52516572467748, 218, 50, 'PPL', 'P'),
(112947, 'Barnesville', 34.139720916748, 0.59585053570923, -88.0777816772461, -1.53724728812068, 218, 2, 'PPL', 'P'),
(134091, 'Barnesville', 46.6522216796875, 0.814234871680826, -96.4194412231445, -1.68283671227702, 218, 28, 'PPL', 'P'),
(158930, 'Barnesville', 40.8144416809082, 0.712346389695057, -76.0311126708984, -1.32699325006196, 218, 45, 'PPL', 'P'),
(177477, 'Barnesville', 41.3086090087891, 0.72097123662236, -72.9102783203125, -1.27252441523489, 218, 8, 'PPL', 'P'),
(194100, 'Barnesville', 40.4791717529297, 0.706494825568908, -104.47917175293, -1.82350554684528, 218, 7, 'PPL', 'P'),
(171709, 'Barnet', 44.2969398498535, 0.773127448937826, -72.0497207641602, -1.25750485247712, 218, 55, 'PPL', 'P'),
(39227, 'Barnet Springs', 32.5074996948242, 0.567362901265735, -92.6758270263672, -1.61749831861885, 218, 22, 'PPL', 'P'),
(19062, 'Barnett', 33.5038909912109, 0.584753210025897, -82.8077774047852, -1.44526836197207, 218, 13, 'PPL', 'P'),
(26446, 'Barnett', 39.2644386291504, 0.685293733025923, -89.6972198486328, -1.56551181624385, 218, 18, 'PPL', 'P'),
(44603, 'Barnett', 39.4049987792969, 0.687746970443077, -77.2225036621094, -1.34778694553719, 218, 25, 'PPL', 'P'),
(53337, 'Barnett', 38.3783302307129, 0.669828223943615, -92.6744384765625, -1.61747408385293, 218, 29, 'PPL', 'P'),
(58552, 'Barnett', 31.9866695404053, 0.558272700227453, -88.9049987792969, -1.55168495018027, 218, 30, 'PPL', 'P'),
(99640, 'Barnett', 36.9236106872559, 0.644438578217181, -82.001106262207, -1.43118929455325, 218, 53, 'PPL', 'P'),
(19063, 'Barnett Bluffs', 33.8591690063477, 0.590953981149983, -83.3213882446289, -1.45423256220127, 218, 13, 'PPL', 'P'),
(112949, 'Barnett Chapel', 34.1619415283203, 0.596238358542973, -87.2994384765625, -1.52366263655824, 218, 2, 'PPL', 'P'),
(112948, 'Barnett Crossroads', 31.2211093902588, 0.544911154985335, -87.304443359375, -1.52374998824199, 218, 2, 'PPL', 'P'),
(34680, 'Barnett Springs', 37.2419395446777, 0.649994464883304, -85.0913925170898, -1.48512496453008, 218, 21, 'PPL', 'P'),
(108094, 'Barnettown', 37.6974983215332, 0.65794546547579, -80.6772232055664, -1.40808317630351, 218, 58, 'PPL', 'P'),
(84827, 'Barnetts', 36.4524993896484, 0.636216134930589, -82.2111129760742, -1.43485460316153, 218, 50, 'PPL', 'P'),
(99641, 'Barnetts', 37.3669395446777, 0.652176126448297, -77.1580581665039, -1.34666215945079, 218, 53, 'PPL', 'P'),
(34681, 'Barnetts Creek', 37.8277816772461, 0.660219338993527, -82.8797225952148, -1.44652404242604, 218, 21, 'PPL', 'P'),
(158933, 'Barnettstown', 40.211109161377, 0.701816250744884, -78.1772232055664, -1.36444994500365, 218, 45, 'PPL', 'P'),
(147011, 'Barneveld', 43.2722206115723, 0.75524272432129, -75.1902770996094, -1.31231790087508, 218, 40, 'PPL', 'P'),
(173057, 'Barneveld', 43.0155601501465, 0.750763154209723, -89.8952789306641, -1.56896859933878, 218, 57, 'PPL', 'P'),
(7274, 'Barney', 35.2516708374023, 0.615257722941937, -92.206672668457, -1.60931003037324, 218, 4, 'PPL', 'P'),
(19064, 'Barney', 31.0080604553223, 0.541192749602826, -83.5130615234375, -1.45757789200458, 218, 13, 'PPL', 'P'),
(112952, 'Barney', 33.7161102294922, 0.58845713446998, -87.1586074829102, -1.52120467203015, 218, 2, 'PPL', 'P'),
(114510, 'Barney', 41.1666717529297, 0.718493964176369, -94.0036087036133, -1.64067248063445, 218, 16, 'PPL', 'P'),
(139639, 'Barney', 46.267219543457, 0.807515316776393, -97.0002822875977, -1.69297430128252, 218, 34, 'PPL', 'P'),
(92443, 'Barney Groves Colonia', 26.2940006256104, 0.458916884438349, -98.3440017700195, -1.71642663047397, 218, 51, 'PPL', 'P'),
(147014, 'Barney Mills', 42.0922203063965, 0.734647833821435, -77.7058334350586, -1.35622264144807, 218, 40, 'PPL', 'P'),
(79661, 'Barney Ridge', 32.9694404602051, 0.575425288570813, -80.1944427490234, -1.39965706777255, 218, 48, 'PPL', 'P'),
(112951, 'Barneys Lower Landing', 31.9922199249268, 0.558369572712105, -88.0755615234375, -1.53720853912682, 218, 2, 'PPL', 'P'),
(19065, 'Barneyville', 31.2138900756836, 0.544785154176261, -83.4541702270508, -1.45655004498186, 218, 13, 'PPL', 'P'),
(124180, 'Barneyville', 41.771671295166, 0.729053198161451, -71.2861099243164, -1.24417732911793, 218, 23, 'PPL', 'P'),
(53338, 'Barnhart', 38.3441696166992, 0.669232008754573, -90.3933334350586, -1.57766129029485, 218, 29, 'PPL', 'P'),
(191109, 'Barnhart', 31.1277809143066, 0.543282265794102, -101.170280456543, -1.76575449913275, 218, 51, 'PPL', 'P'),
(29153, 'Barnhart Town', 39.5038909912109, 0.689472965145557, -87.4355621337891, -1.5260384425667, 218, 19, 'PPL', 'P'),
(19066, 'Barnhill', 32.3263893127441, 0.564201928788892, -82.6691665649414, -1.44284914643784, 218, 13, 'PPL', 'P'),
(26447, 'Barnhill', 38.2844390869141, 0.668189514345862, -88.3641662597656, -1.54224564201259, 218, 18, 'PPL', 'P'),
(79662, 'Barnhill', 33.702220916748, 0.588214720231755, -79.3758316040039, -1.38536960799844, 218, 48, 'PPL', 'P'),
(154187, 'Barnhill', 40.4480590820313, 0.70595180702264, -81.3691711425781, -1.42015994605674, 218, 41, 'PPL', 'P'),
(112953, 'Barnisdale Forest', 33.5900001525879, 0.586256098408056, -86.6786117553711, -1.51282716618909, 218, 2, 'PPL', 'P'),
(158935, 'Barnitz', 40.1213912963867, 0.700250378602944, -77.2266693115234, -1.34785964983495, 218, 45, 'PPL', 'P'),
(126829, 'Barnjum', 44.9413909912109, 0.784375243222749, -70.3655624389648, -1.22811074457759, 218, 26, 'PPL', 'P'),
(70498, 'Barnsboro', 39.7616691589355, 0.69397204291211, -75.1602783203125, -1.31179432340477, 218, 37, 'PPL', 'P'),
(39228, 'Barnsdall', 30.4805603027344, 0.531986135135394, -92.6549987792969, -1.61713479713006, 218, 22, 'PPL', 'P'),
(75068, 'Barnsdall', 36.561939239502, 0.638126220643421, -96.1613922119141, -1.67833290739953, 218, 42, 'PPL', 'P'),
(34682, 'Barnsley', 37.2569389343262, 0.650256253618459, -87.4897232055664, -1.52698373159562, 218, 21, 'PPL', 'P'),
(77826, 'Barnsley', 39.7655601501465, 0.694039953519907, -75.9891662597656, -1.32626114707829, 218, 45, 'PPL', 'P'),
(124181, 'Barnstable', 41.7000007629395, 0.727802311397441, -70.3000030517578, -1.22696651741524, 218, 23, 'PPL', 'P'),
(143492, 'Barnstead', 43.3338890075684, 0.756319040875846, -71.293327331543, -1.24430329663749, 218, 36, 'PPL', 'P'),
(92444, 'Barnum', 30.9447193145752, 0.54008723814482, -94.6725006103516, -1.65234684674698, 218, 51, 'PPL', 'P'),
(108095, 'Barnum', 39.4416694641113, 0.68838699463205, -79.1147232055664, -1.3808124067411, 218, 58, 'PPL', 'P'),
(114511, 'Barnum', 42.5086097717285, 0.741915200962098, -94.3649978637695, -1.64697991136019, 218, 16, 'PPL', 'P'),
(134095, 'Barnum', 46.503059387207, 0.811631498557219, -92.6883316040039, -1.61771656467019, 218, 28, 'PPL', 'P'),
(147012, 'Barnum', 42.0022201538086, 0.733077034831479, -78.4119415283203, -1.36854655255046, 218, 40, 'PPL', 'P'),
(173059, 'Barnum', 43.2188911437988, 0.754311949520308, -90.8394393920898, -1.5854473080578, 218, 57, 'PPL', 'P'),
(209292, 'Barnum', 43.6641693115234, 0.76208351963435, -106.908889770508, -1.86591212614705, 218, 59, 'PPL', 'P'),
(147013, 'Barnum Corners', 41.4588890075684, 0.723594117400952, -73.5561065673828, -1.28379624454865, 218, 40, 'PPL', 'P'),
(147018, 'Barnum Island', 40.6044387817383, 0.708681147665808, -73.6444396972656, -1.2853379485037, 218, 40, 'PPL', 'P'),
(53339, 'Barnumton', 38.1100006103516, 0.665144988587683, -92.936393737793, -1.62204606565433, 218, 29, 'PPL', 'P'),
(171711, 'Barnumtown', 44.2080612182617, 0.771576224181883, -73.1638870239258, -1.27695072212466, 218, 55, 'PPL', 'P'),
(171712, 'Barnumville', 43.1897201538086, 0.753802819698912, -73.0216674804688, -1.27446852283065, 218, 55, 'PPL', 'P'),
(79663, 'Barnwell', 33.2447204589844, 0.580229830914398, -81.35888671875, -1.41998044899927, 218, 48, 'PPL', 'P'),
(112950, 'Barnwell', 30.4247207641602, 0.53101155133448, -87.8794403076172, -1.53378557817774, 218, 2, 'PPL', 'P'),
(192891, 'Barnwell', 35.2930603027344, 0.615980105387621, -115.235000610352, -2.01123017418831, 218, 6, 'PPL', 'P'),
(129674, 'Baroda', 41.9575004577637, 0.732296528895004, -86.4855575561523, -1.50945773477792, 218, 27, 'PPL', 'P'),
(134098, 'Baroda', 43.7208290100098, 0.763072417926123, -93.6747207641602, -1.63493230322089, 218, 28, 'PPL', 'P'),
(179946, 'Baroda', 34.6866683959961, 0.605396570057592, -120.591667175293, -2.10472164267803, 218, 6, 'PPL', 'P'),
(75069, 'Baron', 35.9236106872559, 0.626985285697238, -94.6161117553711, -1.65136267556614, 218, 42, 'PPL', 'P'),
(179947, 'Barona', 32.9358291625977, 0.574838660761696, -116.867218017578, -2.03971774205278, 218, 6, 'PPL', 'P'),
(179948, 'Baronet Estates', 36.563060760498, 0.638145794877433, -121.753890991211, -2.12500627491089, 218, 6, 'PPL', 'P'),
(44604, 'Baronet Woods', 39.4261093139648, 0.688115418779889, -76.7444381713867, -1.33944312868391, 218, 25, 'PPL', 'P'),
(79666, 'Baronywood', 34.0519409179688, 0.594318485713135, -81.0519409179688, -1.41462323415047, 218, 48, 'PPL', 'P'),
(26450, 'Barr', 39.9619407653809, 0.697467441842839, -89.6969375610352, -1.56550688939584, 218, 18, 'PPL', 'P'),
(58555, 'Barr', 34.624439239502, 0.604310466386031, -89.7799987792969, -1.56695658113522, 218, 30, 'PPL', 'P'),
(75071, 'Barr', 36.2324981689453, 0.632376389270912, -98.033332824707, -1.71100443449457, 218, 42, 'PPL', 'P'),
(84828, 'Barr', 35.8822212219238, 0.626262903251554, -89.7311096191406, -1.56610330432196, 218, 50, 'PPL', 'P'),
(188109, 'Barr', 34.9775009155273, 0.610472555095283, -106.666938781738, -1.86168928476456, 218, 38, 'PPL', 'P'),
(195928, 'Barr (historical)', 48.7377815246582, 0.850634757722948, -107.053329467773, -1.86843307443492, 218, 31, 'PPL', 'P'),
(79667, 'Barr Crossing', 33.9394416809082, 0.592355003620447, -81.2930603027344, -1.41883156130501, 218, 48, 'PPL', 'P'),
(186385, 'Barr Lake', 39.9444389343262, 0.697161977265807, -104.774719238281, -1.82866382356065, 218, 7, 'PPL', 'P'),
(158936, 'Barr Slope', 40.7130584716797, 0.710576918887781, -79.01611328125, -1.37909133888663, 218, 45, 'PPL', 'P'),
(99642, 'Barracks', 38.0574989318848, 0.664228661435614, -78.5136108398438, -1.37032101678478, 218, 53, 'PPL', 'P'),
(108096, 'Barrackville', 39.5036087036133, 0.689468038297541, -80.1669387817383, -1.39917703298606, 218, 58, 'PPL', 'P'),
(34683, 'Barrallton', 38.038890838623, 0.663903888940679, -85.7988891601563, -1.4974731103984, 218, 21, 'PPL', 'P'),
(188111, 'Barranca', 36.2619400024414, 0.632890246203243, -105.867218017578, -1.8477315243334, 218, 38, 'PPL', 'P'),
(188112, 'Barranco', 35.3236083984375, 0.616513270237855, -105.41471862793, -1.83983392012077, 218, 38, 'PPL', 'P'),
(99643, 'Barranger', 37.2588882446289, 0.650290275501385, -80.0127792358398, -1.39648644133676, 218, 53, 'PPL', 'P'),
(124184, 'Barre', 42.422779083252, 0.740417172848928, -72.1055603027344, -1.25847943627803, 218, 23, 'PPL', 'P'),
(171713, 'Barre', 44.1969413757324, 0.771382146317443, -72.5025024414063, -1.26540738353777, 218, 55, 'PPL', 'P'),
(147015, 'Barre Center', 43.1861114501953, 0.753739835939131, -78.1944427490234, -1.36475048273267, 218, 40, 'PPL', 'P'),
(124185, 'Barre Falls', 42.4291687011719, 0.740528692719575, -72.0266723632813, -1.25710258199446, 218, 23, 'PPL', 'P'),
(173060, 'Barre Mills', 43.8413887023926, 0.765176581503395, -91.1138916015625, -1.59023740275248, 218, 57, 'PPL', 'P'),
(124186, 'Barre Plains', 42.3777809143066, 0.739631806643464, -72.1097183227539, -1.25855200741774, 218, 23, 'PPL', 'P'),
(158938, 'Barree', 40.5852813720703, 0.708346787790949, -78.100830078125, -1.3631166334039, 218, 45, 'PPL', 'P'),
(189920, 'Barrel Spring (historical)', 37.9552803039551, 0.66244460982137, -117.594436645508, -2.05241010149199, 218, 39, 'PPL', 'P'),
(114512, 'Barrell', 40.6980590820313, 0.710315130152626, -93.8672180175781, -1.63829201409408, 218, 16, 'PPL', 'P'),
(79668, 'Barrell Landing', 32.2949981689453, 0.563654049973636, -80.9308319091797, -1.41250948319327, 218, 48, 'PPL', 'P'),
(44605, 'Barrelville', 39.7016716003418, 0.692924887971491, -78.8427810668945, -1.37606612104636, 218, 25, 'PPL', 'P'),
(79669, 'Barrelville', 32.6861114501953, 0.570480264479727, -80.3511123657227, -1.40239146842179, 218, 48, 'PPL', 'P'),
(53340, 'Barren (historical)', 36.8280601501465, 0.642770906742573, -91.0141677856445, -1.58849689382205, 218, 29, 'PPL', 'P'),
(108097, 'Barren Creek', 38.480281829834, 0.671607615025951, -81.283332824707, -1.41866178478552, 218, 58, 'PPL', 'P'),
(158940, 'Barren Hill', 40.0872192382813, 0.699653963676821, -75.2633285522461, -1.31359288924695, 218, 45, 'PPL', 'P'),
(7276, 'Barren Hollow', 35.9452781677246, 0.627363454572029, -92.5536117553711, -1.61536525974375, 218, 4, 'PPL', 'P'),
(84829, 'Barren Plain', 36.601390838623, 0.638814780943261, -86.9194412231445, -1.51703043333756, 218, 50, 'PPL', 'P'),
(99644, 'Barren Ridge', 38.1624984741211, 0.666061249160725, -78.9502792358398, -1.37794231803432, 218, 53, 'PPL', 'P'),
(34685, 'Barren River', 37.0491714477539, 0.64663002689918, -86.5166702270508, -1.51000075332419, 218, 21, 'PPL', 'P'),
(99645, 'Barren Springs', 36.9080581665039, 0.644167135523075, -80.8008270263672, -1.41024046994453, 218, 53, 'PPL', 'P'),
(7280, 'Barrentine Corner', 35.0688896179199, 0.612067588851159, -91.9449996948242, -1.60474297541986, 218, 4, 'PPL', 'P'),
(92445, 'Barrera Colonia', 26.3929996490479, 0.460644743353593, -98.8990020751953, -1.72611321314886, 218, 51, 'PPL', 'P'),
(31739, 'Barret', 39.6708297729492, 0.692386596536158, -96.4499969482422, -1.68337001028531, 218, 20, 'PPL', 'P'),
(99646, 'Barrets Corner', 36.8125, 0.642499330890413, -76.2055587768555, -1.33003790897819, 218, 53, 'PPL', 'P'),
(149, 'Barrett', 37.8872184753418, 0.66125670681714, -81.670280456543, -1.42541529499385, 218, 58, 'PPL', 'P'),
(19067, 'Barrett', 34.336669921875, 0.599287944307223, -83.8161087036133, -1.46286706308753, 218, 13, 'PPL', 'P'),
(29155, 'Barrett', 38.2005615234375, 0.666725574694645, -87.8694381713867, -1.53361100796828, 218, 19, 'PPL', 'P'),
(39229, 'Barrett', 31.3669395446777, 0.547456371328637, -92.5133285522461, -1.61466218521597, 218, 22, 'PPL', 'P'),
(44607, 'Barrett', 39.4075012207031, 0.687790646284954, -77.0166702270508, -1.34419447438472, 218, 25, 'PPL', 'P'),
(62722, 'Barrett', 36.5272216796875, 0.6375202849164, -80.9683303833008, -1.41316395503116, 218, 33, 'PPL', 'P'),
(92446, 'Barrett', 29.8797206878662, 0.52149950557953, -95.0627822875977, -1.65915854702513, 218, 51, 'PPL', 'P'),
(112956, 'Barrett', 31.1919403076172, 0.544402058453453, -85.4208297729492, -1.49087472932356, 218, 2, 'PPL', 'P'),
(134099, 'Barrett', 45.9105606079102, 0.801290444044442, -95.8899993896484, -1.67359620908472, 218, 28, 'PPL', 'P'),
(143494, 'Barrett', 44.2580604553223, 0.772448875492074, -71.8291702270508, -1.25365551943752, 218, 36, 'PPL', 'P'),
(158941, 'Barrett', 41.0105590820313, 0.715769284065109, -78.3891677856445, -1.36814907575777, 218, 45, 'PPL', 'P'),
(179950, 'Barrett', 37.6399993896484, 0.656941919798021, -120.284721374512, -2.09936442782923, 218, 6, 'PPL', 'P'),
(31740, 'Barrett (historical)', 37.3333282470703, 0.65158949863918, -94.7777786254883, -1.65418429474108, 218, 20, 'PPL', 'P'),
(189921, 'Barrett (historical)', 39.0533294677734, 0.681609183078771, -117.424171447754, -2.04943841318962, 218, 39, 'PPL', 'P'),
(99647, 'Barrett Acres', 36.7200012207031, 0.640884922637607, -76.6408309936523, -1.33763484230375, 218, 53, 'PPL', 'P'),
(99648, 'Barrett Corner', 36.8833312988281, 0.643735570268427, -77.0422210693359, -1.34464042070926, 218, 53, 'PPL', 'P'),
(147017, 'Barrett Corners', 42.7186088562012, 0.745580376412319, -75.1733322143555, -1.31202215683602, 218, 40, 'PPL', 'P'),
(112955, 'Barrett Crossroads', 33.1952781677246, 0.579366900142185, -85.2938919067383, -1.48865924561273, 218, 2, 'PPL', 'P'),
(179951, 'Barrett Junction', 32.6113891601563, 0.569176114493915, -116.706390380859, -2.03691077026384, 218, 6, 'PPL', 'P'),
(199823, 'Barrett Springs (historical)', 41.0405616760254, 0.716292928114445, -117.914169311523, -2.05799048924014, 218, 39, 'PPL', 'P'),
(19068, 'Barretts', 31.0013904571533, 0.541076336173675, -83.1994400024414, -1.45210416385808, 218, 13, 'PPL', 'P'),
(53342, 'Barretts', 38.5716705322266, 0.673202648781827, -90.4599990844727, -1.5788248253751, 218, 29, 'PPL', 'P'),
(99649, 'Barretts', 37.5763893127441, 0.655831714518594, -76.4441680908203, -1.3342024271328, 218, 53, 'PPL', 'P'),
(126830, 'Barretts', 46.8974990844727, 0.818515769975074, -68.01611328125, -1.18710512116726, 218, 26, 'PPL', 'P'),
(195929, 'Barretts', 45.1313896179199, 0.787691344833088, -112.739723205566, -1.96767936772419, 218, 31, 'PPL', 'P'),
(62723, 'Barretts Crossroads', 36.4702796936035, 0.63652645977661, -77.0558319091797, -1.34487797467849, 218, 33, 'PPL', 'P'),
(19069, 'Barretts Mill', 34.0077781677246, 0.593547700314639, -83.3647232055664, -1.45498889995086, 218, 13, 'PPL', 'P'),
(71743, 'Barretts Mills', 39.2024993896484, 0.684212689360433, -83.3872222900391, -1.45538158305359, 218, 41, 'PPL', 'P'),
(7281, 'Barrettsville', 34.8597183227539, 0.608416861049851, -91.6694412231445, -1.59993357280729, 218, 4, 'PPL', 'P'),
(19070, 'Barrettsville', 34.3397216796875, 0.599341207529024, -84.1569366455078, -1.46881563285638, 218, 13, 'PPL', 'P'),
(84830, 'Barretville', 35.3736114501953, 0.617385988127074, -89.7633285522461, -1.56666563078613, 218, 50, 'PPL', 'P'),
(118723, 'Barreville', 42.2755584716797, 0.737847688450193, -88.2624969482422, -1.54047117777827, 218, 18, 'PPL', 'P'),
(154188, 'Barrick', 40.5327796936035, 0.70743046063888, -81.2525024414063, -1.41812369308727, 218, 41, 'PPL', 'P'),
(29156, 'Barrick Corner', 39.2561111450195, 0.685148391009432, -87.0733337402344, -1.51971636445496, 218, 19, 'PPL', 'P'),
(154189, 'Barrick Corners', 40.1908302307129, 0.701462316636012, -82.5508270263672, -1.44078373185443, 218, 41, 'PPL', 'P'),
(139642, 'Barrie', 46.5688896179199, 0.812780452830507, -97.1222229003906, -1.69510256646765, 218, 34, 'PPL', 'P'),
(34686, 'Barrier', 36.7688903808594, 0.641738199450868, -84.767219543457, -1.47946707879421, 218, 21, 'PPL', 'P'),
(62724, 'Barriers Mill', 35.3566703796387, 0.617090310667048, -80.4280624389648, -1.40373450055952, 218, 33, 'PPL', 'P'),
(79670, 'Barrineau Crossroads', 33.871940612793, 0.591176887733223, -79.9091720581055, -1.39467815495659, 218, 48, 'PPL', 'P'),
(15098, 'Barrineau Park', 30.6936092376709, 0.535704540517904, -87.4361114501953, -1.52604802994662, 218, 12, 'PPL', 'P'),
(7282, 'Barringer', 33.8480606079102, 0.590760103022626, -93.1338882446289, -1.62549299505322, 218, 4, 'PPL', 'P'),
(19072, 'Barrington', 33.5202789306641, 0.585039233526972, -84.0327835083008, -1.46664875183544, 218, 13, 'PPL', 'P'),
(44608, 'Barrington', 39.3547210693359, 0.686869458863896, -76.4683303833008, -1.33462413869142, 218, 25, 'PPL', 'P'),
(70500, 'Barrington', 39.8647193908691, 0.695770608754295, -75.0555572509766, -1.30996659594865, 218, 37, 'PPL', 'P'),
(118724, 'Barrington', 42.1538887023926, 0.735724150375991, -88.1361083984375, -1.53826528144736, 218, 18, 'PPL', 'P'),
(143495, 'Barrington', 43.2227783203125, 0.754379793549077, -71.0475006103516, -1.24001281096332, 218, 36, 'PPL', 'P'),
(147019, 'Barrington', 42.5469398498535, 0.742584187027926, -77.0563888549805, -1.34488769521647, 218, 40, 'PPL', 'P'),
(169271, 'Barrington', 41.7405586242676, 0.728510179615184, -71.3091735839844, -1.24457986591669, 218, 47, 'PPL', 'P'),
(118725, 'Barrington Center', 42.1105613708496, 0.734967945784463, -88.1941680908203, -1.53927861424214, 218, 18, 'PPL', 'P'),
(92447, 'Barrington Heights Colonia', 26.1730003356934, 0.45680503098343, -97.8270034790039, -1.70740330806857, 218, 51, 'PPL', 'P'),
(118727, 'Barrington Hills', 42.1686096191406, 0.735981078842156, -88.2574996948242, -1.54038395925257, 218, 18, 'PPL', 'P'),
(44609, 'Barrington Manor', 39.1175003051758, 0.682729175475204, -76.5388870239258, -1.33585558437947, 218, 25, 'PPL', 'P'),
(202978, 'Barrington Park', 40.6786117553711, 0.709975710271696, -111.924438476563, -1.95344996486184, 218, 52, 'PPL', 'P'),
(44610, 'Barrington Woods', 39.2202796936035, 0.684523014206454, -76.8091735839844, -1.34057297477638, 218, 25, 'PPL', 'P'),
(118728, 'Barrington Woods', 42.1522216796875, 0.735695055341081, -88.0558319091797, -1.53686419239787, 218, 18, 'PPL', 'P'),
(92448, 'Barrios Colonia', 25.9449996948242, 0.452825669103607, -97.4089965820313, -1.70010771142035, 218, 51, 'PPL', 'P'),
(92449, 'Barrios Number 2 Colonia', 26.2220001220703, 0.457660238588482, -98.1510009765625, -1.71305813116919, 218, 51, 'PPL', 'P'),
(99650, 'Barrister Estates', 37.3105583190918, 0.651192088425513, -80.0983276367188, -1.39797954260191, 218, 53, 'PPL', 'P'),
(158944, 'Barrisville', 40.7844390869141, 0.71182274564572, -80.2408294677734, -1.40046666874394, 218, 45, 'PPL', 'P'),
(179953, 'Barro', 38.5261116027832, 0.672407495459357, -122.491668701172, -2.13788292509754, 218, 6, 'PPL', 'P'),
(202977, 'Barro', 40.7269401550293, 0.710819199967951, -113.488059997559, -1.98074030865827, 218, 52, 'PPL', 'P'),
(39231, 'Barron', 31.336669921875, 0.546928066747393, -92.2494430541992, -1.61005651442679, 218, 22, 'PPL', 'P'),
(53343, 'Barron', 36.7713890075684, 0.641781808713718, -90.2630615234375, -1.57538761651419, 218, 29, 'PPL', 'P'),
(173062, 'Barron', 45.4013900756836, 0.792403741802956, -91.8488922119141, -1.60306558340728, 218, 57, 'PPL', 'P'),
(206768, 'Barron', 48.7533302307129, 0.850906133838027, -120.715278625488, -2.10687906947711, 218, 56, 'PPL', 'P'),
(200372, 'Barron (historical)', 42.1261100769043, 0.735239321899542, -122.610282897949, -2.13995313337091, 218, 43, 'PPL', 'P'),
(126831, 'Barron Corner', 44.8208312988281, 0.782271079645477, -69.8450012207031, -1.21902523736073, 218, 26, 'PPL', 'P'),
(58553, 'Barron Point', 31.1472206115723, 0.543621552516978, -89.165283203125, -1.55622777036773, 218, 30, 'PPL', 'P'),
(173066, 'Barronett', 45.6369400024414, 0.796514863577712, -91.9927825927734, -1.60557694431522, 218, 57, 'PPL', 'P'),
(112957, 'Barrons (historical)', 32.1286087036133, 0.560750005962959, -88.0027770996094, -1.53593821128685, 218, 2, 'PPL', 'P'),
(84831, 'Barrons Corner', 36.0699996948242, 0.629540255868033, -88.9352798461914, -1.5522134544986, 218, 50, 'PPL', 'P'),
(19073, 'Barrons Lane', 32.3666687011719, 0.564904936737646, -83.9963912963867, -1.46601358791546, 218, 13, 'PPL', 'P'),
(58554, 'Barrontown', 31.375280380249, 0.547601946371724, -89.2174987792969, -1.55713910409275, 218, 30, 'PPL', 'P'),
(77827, 'Barronvale', 39.9516716003418, 0.697288211101476, -79.2716674804688, -1.3835516010803, 218, 45, 'PPL', 'P'),
(26453, 'Barrow', 39.5061111450195, 0.689511714139418, -90.4013900756836, -1.5778019052004, 218, 18, 'PPL', 'P'),
(212294, 'Barrow', 71.2905578613281, 1.2442549602637, -156.788604736328, -2.7364773822569, 218, 1, 'PPL', 'P'),
(19075, 'Barrow Heights', 33.9916687011719, 0.593266537082554, -83.7444381713867, -1.46161617632352, 218, 13, 'PPL', 'P'),
(134101, 'Barrows', 46.3011093139648, 0.808106804854499, -94.2536087036133, -1.64503580376444, 218, 28, 'PPL', 'P'),
(99651, 'Barrows Store', 36.9347190856934, 0.644632456344539, -77.9791717529297, -1.36099329506678, 218, 53, 'PPL', 'P'),
(124188, 'Barrowsville', 41.9458312988281, 0.73209286365064, -71.2041702270508, -1.24274721161255, 218, 23, 'PPL', 'P'),
(39232, 'Barroza (historical)', 30.5055599212646, 0.53242246079049, -91.2938919067383, -1.59337900073239, 218, 22, 'PPL', 'P'),
(108098, 'Barrs', 38.8230590820313, 0.677590206677733, -81.3808288574219, -1.42036341156403, 218, 58, 'PPL', 'P'),
(158943, 'Barrs Corners', 41.2786102294922, 0.720447659152051, -79.7197189331055, -1.39137157414715, 218, 45, 'PPL', 'P'),
(58556, 'Barrs Mill', 33.7972183227539, 0.589872737747411, -88.852783203125, -1.55077361645524, 218, 30, 'PPL', 'P'),
(154190, 'Barrs Mills', 40.5486106872559, 0.707706763601975, -81.6236114501953, -1.42460076717445, 218, 41, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(71744, 'Barrsville', 39.1236114501953, 0.682835835076862, -84.5519409179688, -1.47570975797027, 218, 41, 'PPL', 'P'),
(158946, 'Barrville', 40.6630592346191, 0.709704267577589, -77.6769409179688, -1.35571837189566, 218, 45, 'PPL', 'P'),
(26454, 'Barry', 39.6941719055176, 0.692793993603913, -91.0388870239258, -1.58892832591865, 218, 18, 'PPL', 'P'),
(53344, 'Barry', 39.2463912963867, 0.684978747647994, -94.6005630493164, -1.65109129945106, 218, 29, 'PPL', 'P'),
(92450, 'Barry', 32.0991706848145, 0.560236215609655, -96.6358337402344, -1.68661347417692, 218, 51, 'PPL', 'P'),
(134102, 'Barry', 45.5580596923828, 0.795138142452195, -96.5588912963867, -1.68527057519724, 218, 28, 'PPL', 'P'),
(173068, 'Barry Corner', 44.5180587768555, 0.776986702252488, -92.179443359375, -1.60883478927672, 218, 57, 'PPL', 'P'),
(13034, 'Barry Farms', 38.8563919067383, 0.67817197421786, -76.9916687011719, -1.34375811544012, 218, 9, 'PPL', 'P'),
(112958, 'Barry Village', 30.9986095428467, 0.541027800062809, -88.0269393920898, -1.53635992284546, 218, 2, 'PPL', 'P'),
(194556, 'Barrymore', 42.6808280944824, 0.744920977726416, -114.462219238281, -1.9977425948476, 218, 17, 'PPL', 'P'),
(129677, 'Barryton', 43.752498626709, 0.763625157010369, -85.1469421386719, -1.48609448832493, 218, 27, 'PPL', 'P'),
(112954, 'Barrytown', 31.8372192382813, 0.555664300387289, -88.2527770996094, -1.54030153441684, 218, 2, 'PPL', 'P'),
(147022, 'Barrytown', 41.9983291625977, 0.733009124223682, -73.9244384765625, -1.290224849104, 218, 40, 'PPL', 'P'),
(53346, 'Barryville', 39.667781829834, 0.692333399893384, -92.6619415283203, -1.61725597095966, 218, 29, 'PPL', 'P'),
(147021, 'Barryville', 41.4775009155273, 0.723918956474915, -74.9113922119141, -1.30745044135074, 218, 40, 'PPL', 'P'),
(39233, 'Barso', 32.7447204589844, 0.571503184654426, -93.7275009155273, -1.63585349064195, 218, 22, 'PPL', 'P'),
(7283, 'Barson', 35.1513900756836, 0.613507493473538, -91.0730590820313, -1.58952474084477, 218, 4, 'PPL', 'P'),
(44611, 'Barstow', 38.5252799987793, 0.672392981231416, -76.6163864135742, -1.33720820389712, 218, 25, 'PPL', 'P'),
(118730, 'Barstow', 41.5183296203613, 0.724631551803593, -90.3569412231445, -1.57702612637486, 218, 18, 'PPL', 'P'),
(179955, 'Barstow', 34.898609161377, 0.609095634232685, -117.021942138672, -2.04241818739812, 218, 6, 'PPL', 'P'),
(191110, 'Barstow', 31.461109161377, 0.54909994119538, -103.393333435059, -1.80455409305411, 218, 51, 'PPL', 'P'),
(206769, 'Barstow', 48.7772216796875, 0.851323118285706, -118.141670227051, -2.06196112926739, 218, 56, 'PPL', 'P'),
(179956, 'Barstow Heights', 34.8697204589844, 0.608591431259306, -117.055282592773, -2.0430000880963, 218, 6, 'PPL', 'P'),
(179957, 'Barsug', 34.9575004577637, 0.610123481255401, -120.571937561035, -2.10437729594909, 218, 6, 'PPL', 'P'),
(79671, 'Bartell Crossroads', 33.7591705322266, 0.5892086785296, -79.57861328125, -1.3889088159291, 218, 48, 'PPL', 'P'),
(26456, 'Bartelso', 38.5363883972168, 0.672586859358773, -89.4663925170898, -1.56148311930484, 218, 18, 'PPL', 'P'),
(99653, 'Barterbrook', 38.0658302307129, 0.664374070031133, -78.4986114501953, -1.37005922804963, 218, 53, 'PPL', 'P'),
(34687, 'Barterville', 38.3788909912109, 0.669838011060621, -84.0688934326172, -1.46727898890741, 218, 21, 'PPL', 'P'),
(15099, 'Barth', 30.7613906860352, 0.536887549963631, -87.3302764892578, -1.52420086141454, 218, 12, 'PPL', 'P'),
(58557, 'Barth', 30.6722202301025, 0.535331231912102, -89.3644409179688, -1.5597037282225, 218, 30, 'PPL', 'P'),
(199824, 'Barth', 40.5816688537598, 0.708283737452141, -116.268333435059, -2.02926523424838, 218, 39, 'PPL', 'P'),
(84835, 'Barthelia', 36.3450012207031, 0.634339937942628, -86.2561111450195, -1.50545313944677, 218, 50, 'PPL', 'P'),
(34688, 'Barthell', 36.6863899230957, 0.640298294828489, -84.5252838134766, -1.47524450372783, 218, 21, 'PPL', 'P'),
(92451, 'Bartholomew Crossing', 33.0522193908691, 0.576870053462181, -99.3263931274414, -1.73357259420412, 218, 51, 'PPL', 'P'),
(44612, 'Bartholows', 39.3738899230957, 0.687204018475837, -77.2322235107422, -1.34795658889863, 218, 25, 'PPL', 'P'),
(29157, 'Bartle', 38.5602798461914, 0.673003843806453, -85.8874969482422, -1.49901960804341, 218, 19, 'PPL', 'P'),
(193359, 'Bartle', 41.2577781677246, 0.720084071084228, -121.819999694824, -2.12616008945317, 218, 6, 'PPL', 'P'),
(84832, 'Bartlebaugh', 35.1163902282715, 0.612896630898501, -85.1669387817383, -1.48644349558578, 218, 50, 'PPL', 'P'),
(84833, 'Bartlebaugh Subdivision', 35.1263885498047, 0.613071134528928, -85.1661071777344, -1.48642898135784, 218, 50, 'PPL', 'P'),
(71745, 'Bartles', 38.6616706848145, 0.674773447771783, -82.6600036621094, -1.44268922361438, 218, 41, 'PPL', 'P'),
(144791, 'Bartles Corners', 40.5366706848145, 0.707498371246677, -74.857780456543, -1.30651473970174, 218, 37, 'PPL', 'P'),
(75073, 'Bartlesville', 36.7472190856934, 0.641359963997049, -95.9805603027344, -1.67517679519168, 218, 42, 'PPL', 'P'),
(19076, 'Bartlett', 32.3355598449707, 0.564361984770406, -84.1152801513672, -1.46808858987879, 218, 13, 'PPL', 'P'),
(31741, 'Bartlett', 37.0547218322754, 0.646726899383832, -95.210563659668, -1.66173781854087, 218, 20, 'PPL', 'P'),
(53347, 'Bartlett', 37.0047187805176, 0.645854181494613, -91.4141693115234, -1.59547823746164, 218, 29, 'PPL', 'P'),
(58558, 'Bartlett', 32.2583312988281, 0.56301409236369, -89.3166732788086, -1.55887002564325, 218, 30, 'PPL', 'P'),
(62727, 'Bartlett', 36.2891693115234, 0.633365487299768, -76.084716796875, -1.3279288185529, 218, 33, 'PPL', 'P'),
(71746, 'Bartlett', 39.4194412231445, 0.687999038640253, -81.8158264160156, -1.42795555119962, 218, 41, 'PPL', 'P'),
(84834, 'Bartlett', 35.2044410705566, 0.614433408005531, -89.873893737793, -1.568595357312, 218, 50, 'PPL', 'P'),
(92452, 'Bartlett', 30.7947196960449, 0.537469250924731, -97.4252777099609, -1.70039187070866, 218, 51, 'PPL', 'P'),
(114513, 'Bartlett', 40.8849983215332, 0.71357783538311, -95.7947235107422, -1.67193333130007, 218, 16, 'PPL', 'P'),
(118731, 'Bartlett', 41.9949989318848, 0.732951000732891, -88.1855621337891, -1.53912841195666, 218, 18, 'PPL', 'P'),
(134106, 'Bartlett', 46.9124984741211, 0.818777558710229, -92.3411102294922, -1.61165640845166, 218, 28, 'PPL', 'P'),
(139644, 'Bartlett', 48.0447196960449, 0.838538546893753, -98.4319381713867, -1.71796141021018, 218, 34, 'PPL', 'P'),
(141236, 'Bartlett', 41.8852806091309, 0.73103605475107, -98.5519409179688, -1.72005585324948, 218, 35, 'PPL', 'P'),
(143497, 'Bartlett', 44.0780601501465, 0.769307277512162, -71.283332824707, -1.24412885958609, 218, 36, 'PPL', 'P'),
(147023, 'Bartlett', 43.1344413757324, 0.752838023015003, -75.4422225952148, -1.31671517930896, 218, 40, 'PPL', 'P'),
(177478, 'Bartlett', 41.4216690063477, 0.722944505832055, -72.1036071777344, -1.25844534781608, 218, 8, 'PPL', 'P'),
(179958, 'Bartlett', 36.4766693115234, 0.636637979647257, -118.029998779297, -2.06001209482362, 218, 6, 'PPL', 'P'),
(186386, 'Bartlett', 37.4333305358887, 0.653334867838591, -102.143608093262, -1.78274227109414, 218, 7, 'PPL', 'P'),
(200373, 'Bartlett', 45.9847183227539, 0.80258474033422, -117.457221984863, -2.05001525388173, 218, 43, 'PPL', 'P'),
(112960, 'Bartlett (historical)', 34.1877784729004, 0.596689298294551, -86.2577819824219, -1.5054823010607, 218, 2, 'PPL', 'P'),
(147024, 'Bartlett Corners', 43.3102798461914, 0.755906983276183, -77.7947235107422, -1.35777406594109, 218, 40, 'PPL', 'P'),
(209937, 'Bartlett Cove', 58.4500007629395, 1.02014496110649, -135.91667175293, -2.372193430441, 218, 1, 'PPL', 'P'),
(44613, 'Bartlett Heights', 39.4583282470703, 0.68867774524406, -77.4161071777344, -1.35116596432828, 218, 25, 'PPL', 'P'),
(147025, 'Bartlett Hollow', 42.3197212219238, 0.738618473848689, -75.1822204589844, -1.31217728596952, 218, 40, 'PPL', 'P'),
(126832, 'Bartlett Mills', 43.3994407653809, 0.757463134880144, -70.5297164916992, -1.2309757732783, 218, 26, 'PPL', 'P'),
(179959, 'Bartlett Springs', 39.1838912963867, 0.683887916865498, -122.703330993652, -2.14157712900364, 218, 6, 'PPL', 'P'),
(147026, 'Bartletts Corner', 44.2599983215332, 0.772482697637918, -75.7249984741211, -1.3216505494411, 218, 40, 'PPL', 'P'),
(29162, 'Bartlettsville', 38.9702796936035, 0.680159691076468, -86.4419403076172, -1.50869647018032, 218, 19, 'PPL', 'P'),
(108100, 'Bartley', 37.3405609130859, 0.65171573247485, -81.7377777099609, -1.42659334430205, 218, 58, 'PPL', 'P'),
(144792, 'Bartley', 40.8224983215332, 0.712487004600613, -74.7186126708984, -1.30408580362953, 218, 37, 'PPL', 'P'),
(199161, 'Bartley', 40.2491683959961, 0.702480509699777, -100.311668395996, -1.75076889167887, 218, 35, 'PPL', 'P'),
(19077, 'Bartley Road Estates', 32.9805603027344, 0.575619366435253, -85.0013885498047, -1.4835540989611, 218, 13, 'PPL', 'P'),
(92454, 'Bartley Woods', 33.4888916015625, 0.584491421290743, -96.0269393920898, -1.67598626300501, 218, 51, 'PPL', 'P'),
(99654, 'Bartlick', 37.246940612793, 0.650081749988032, -82.3247222900391, -1.43683745975115, 218, 53, 'PPL', 'P'),
(58559, 'Barto', 31.1755599975586, 0.544116168110433, -90.311393737793, -1.57623117278948, 218, 30, 'PPL', 'P'),
(158947, 'Barto', 40.3911094665527, 0.704957848724796, -75.6105575561523, -1.31965317862354, 218, 45, 'PPL', 'P'),
(179960, 'Bartolo', 34.0063896179199, 0.593523465548719, -118.061393737793, -2.0605600402179, 218, 6, 'PPL', 'P'),
(179961, 'Bartolo (historical)', 34.0194396972656, 0.593751232400948, -118.043060302734, -2.06024006141293, 218, 6, 'PPL', 'P'),
(7286, 'Barton', 34.5475006103516, 0.602967633985385, -90.7680587768555, -1.58420148129987, 218, 4, 'PPL', 'P'),
(31742, 'Barton', 38.9938888549805, 0.680571748676131, -98.0772171020508, -1.71177035962408, 218, 20, 'PPL', 'P'),
(39234, 'Barton', 30.086109161377, 0.525101663980458, -91.054443359375, -1.58919983519178, 218, 22, 'PPL', 'P'),
(44614, 'Barton', 39.5305595397949, 0.689938419125076, -79.0177764892578, -1.37912036734251, 218, 25, 'PPL', 'P'),
(58561, 'Barton', 34.9638900756836, 0.610235001126048, -89.6891708374023, -1.56537133449635, 218, 30, 'PPL', 'P'),
(79672, 'Barton', 32.9222183227539, 0.574601106792461, -81.2866668701172, -1.41871997485534, 218, 48, 'PPL', 'P'),
(92453, 'Barton', 30.9197196960449, 0.539650912489724, -96.7113876342773, -1.68793213839067, 218, 51, 'PPL', 'P'),
(112959, 'Barton', 34.7386093139648, 0.606303110092655, -87.89111328125, -1.53398931000113, 218, 2, 'PPL', 'P'),
(147027, 'Barton', 42.042781829834, 0.733784969628249, -76.4488906860352, -1.33428485196854, 218, 40, 'PPL', 'P'),
(154192, 'Barton', 40.1072196960449, 0.700003037516703, -80.8413925170898, -1.41094847132032, 218, 41, 'PPL', 'P'),
(158949, 'Barton', 40.7924995422363, 0.711963427130304, -79.0541687011719, -1.3797555312625, 218, 45, 'PPL', 'P'),
(171716, 'Barton', 44.7480583190918, 0.781000951542591, -72.1766662597656, -1.25972046934601, 218, 55, 'PPL', 'P'),
(173070, 'Barton', 43.4436111450195, 0.758234053436695, -88.1805572509766, -1.5390410602729, 218, 57, 'PPL', 'P'),
(179962, 'Barton', 38.454719543457, 0.671161468964336, -120.529167175293, -2.10363081189554, 218, 6, 'PPL', 'P'),
(188114, 'Barton', 35.0830612182617, 0.6123149299374, -106.246391296387, -1.85434934648419, 218, 38, 'PPL', 'P'),
(194557, 'Barton', 44.3844413757324, 0.774654638664932, -116.798889160156, -2.03852517851664, 218, 17, 'PPL', 'P'),
(197976, 'Barton', 48.5069389343262, 0.846605794467821, -100.175827026367, -1.74839801251843, 218, 34, 'PPL', 'P'),
(199162, 'Barton', 41.0338897705078, 0.716176481395782, -102.173889160156, -1.78327077541247, 218, 35, 'PPL', 'P'),
(200374, 'Barton', 45.3891716003418, 0.792190489178668, -122.405830383301, -2.13638476382631, 218, 43, 'PPL', 'P'),
(202985, 'Barton', 41.1599998474121, 0.718377517457705, -112.063888549805, -1.95588382778207, 218, 52, 'PPL', 'P'),
(108101, 'Barton (historical)', 38.5186080932617, 0.672276534512752, -81.170280456543, -1.41668864873388, 218, 58, 'PPL', 'P'),
(129679, 'Barton City', 44.6841697692871, 0.779885885994175, -83.6055603027344, -1.45919230025738, 218, 27, 'PPL', 'P'),
(191111, 'Barton Corners', 36.2019309997559, 0.631842891525542, -100.457809448242, -1.75331953421289, 218, 51, 'PPL', 'P'),
(92455, 'Barton Creek', 30.2849998474121, 0.528572961303322, -97.8688888549805, -1.70813434578779, 218, 51, 'PPL', 'P'),
(99655, 'Barton Crossroad', 36.6572189331055, 0.639789165007093, -81.3522186279297, -1.41986406885964, 218, 53, 'PPL', 'P'),
(158948, 'Barton Glen', 41.0055618286133, 0.715682065539409, -75.2980575561523, -1.31419902471105, 218, 45, 'PPL', 'P'),
(129680, 'Barton Hills', 42.3219413757324, 0.738657222842549, -83.7688903808594, -1.4620429478882, 218, 27, 'PPL', 'P'),
(84837, 'Barton Mill', 35.5191688537598, 0.619926444069928, -84.6094436645508, -1.47671337022707, 218, 50, 'PPL', 'P'),
(84836, 'Barton Springs', 36.2363891601563, 0.632444299878709, -83.2352828979492, -1.45272974039814, 218, 50, 'PPL', 'P'),
(19078, 'Barton Village', 33.4347190856934, 0.583545932524737, -82.0933303833008, -1.4327989091161, 218, 13, 'PPL', 'P'),
(44615, 'Barton Woods', 39.2088890075684, 0.68432420923108, -77.2133331298828, -1.34762688955567, 218, 25, 'PPL', 'P'),
(122193, 'Bartonia', 40.1152801513672, 0.700143719001287, -84.8511123657227, -1.48093128476154, 218, 19, 'PPL', 'P'),
(92456, 'Bartons Chapel', 33.0644416809082, 0.577083372665496, -98.2361068725586, -1.71454350926718, 218, 51, 'PPL', 'P'),
(169273, 'Bartons Corner', 41.6627807617188, 0.727152699828543, -71.4983291625977, -1.24788125356201, 218, 47, 'PPL', 'P'),
(29160, 'Bartons Location', 38.5291709899902, 0.672460891839213, -87.3394393920898, -1.524360784238, 218, 19, 'PPL', 'P'),
(44616, 'Bartonsville', 39.3925018310547, 0.687528857549799, -77.3583297729492, -1.35015755838152, 218, 25, 'PPL', 'P'),
(62729, 'Bartonsville', 36.4749984741211, 0.636608818033321, -76.9588928222656, -1.34318606843797, 218, 33, 'PPL', 'P'),
(99656, 'Bartonsville', 39.1113891601563, 0.682622515873546, -78.2122192382813, -1.36506074099966, 218, 53, 'PPL', 'P'),
(158951, 'Bartonsville', 41.0050010681152, 0.715672278422402, -75.2799987792969, -1.31388383959604, 218, 45, 'PPL', 'P'),
(171718, 'Bartonsville', 43.2255592346191, 0.754428329659944, -72.5361099243164, -1.26599394476786, 218, 55, 'PPL', 'P'),
(92457, 'Bartonville', 33.0730590820313, 0.577233774688059, -97.1313934326172, -1.69526262244917, 218, 51, 'PPL', 'P'),
(112962, 'Bartonville', 33.5747184753418, 0.585989382824885, -86.7805633544922, -1.51460655727142, 218, 2, 'PPL', 'P'),
(118732, 'Bartonville', 40.6502799987793, 0.709481227836295, -89.6519393920898, -1.56472152319037, 218, 18, 'PPL', 'P'),
(15101, 'Bartow', 27.896110534668, 0.486878977330232, -81.8433303833008, -1.42843558598611, 218, 12, 'PPL', 'P'),
(19080, 'Bartow', 32.8786087036133, 0.573839975352916, -82.4738922119141, -1.43944096603281, 218, 13, 'PPL', 'P'),
(108102, 'Bartow', 38.5411109924316, 0.672669284194511, -79.7844390869141, -1.39250115392351, 218, 58, 'PPL', 'P'),
(108103, 'Bartram (historical)', 38.2627792358398, 0.667811478629125, -82.3208312988281, -1.43676954914335, 218, 58, 'PPL', 'P'),
(71747, 'Bartramville', 38.4925003051758, 0.67182086765024, -82.3847198486328, -1.43788461469177, 218, 41, 'PPL', 'P'),
(77829, 'Bartville', 39.8911094665527, 0.696231202464824, -76.0686111450195, -1.32764772189984, 218, 45, 'PPL', 'P'),
(200376, 'Barview', 45.5699996948242, 0.795346534807494, -123.942222595215, -2.16319986652621, 218, 43, 'PPL', 'P'),
(15102, 'Barwal', 26.3086109161377, 0.459171882112725, -80.0899963378906, -1.39783413400639, 218, 12, 'PPL', 'P'),
(19082, 'Barwick', 30.8899993896484, 0.539132195288404, -83.7408294677734, -1.46155319256374, 218, 13, 'PPL', 'P'),
(34689, 'Barwick', 37.3666687011719, 0.652171399337362, -83.3663864135742, -1.45501792840674, 218, 21, 'PPL', 'P'),
(53351, 'Barwick', 39.7136116027832, 0.693133280326789, -94.1230621337891, -1.64275733629382, 218, 29, 'PPL', 'P'),
(191112, 'Barwise', 33.9972190856934, 0.593363409567205, -101.526107788086, -1.77196485763676, 218, 51, 'PPL', 'P'),
(880, 'Barwood', 39.9977798461914, 0.698092951803871, -76.6733322143555, -1.33820209561594, 218, 45, 'PPL', 'P'),
(801, 'Barwyn Acres', 39.2272186279297, 0.684644121457025, -84.3727798461914, -1.47258280737635, 218, 41, 'PPL', 'P'),
(99659, 'Barytes', 36.621940612793, 0.639173442163067, -82.1575012207031, -1.43391890151253, 218, 53, 'PPL', 'P'),
(53352, 'Baryties', 38.061939239502, 0.664306159423336, -90.658332824707, -1.58228640215999, 218, 29, 'PPL', 'P'),
(186387, 'Basalt', 39.3688888549805, 0.68711673337111, -107.032218933105, -1.8680646260981, 218, 7, 'PPL', 'P'),
(189922, 'Basalt', 38.0074996948242, 0.663356010125423, -118.272216796875, -2.06423959673801, 218, 39, 'PPL', 'P'),
(194558, 'Basalt', 43.315559387207, 0.7559991286499, -112.163612365723, -1.95762433671249, 218, 17, 'PPL', 'P'),
(118733, 'Basco', 40.3277816772461, 0.703852570293386, -91.1999969482422, -1.59174022455561, 218, 18, 'PPL', 'P'),
(173072, 'Basco', 42.9119415283203, 0.748954668092477, -89.5147171020508, -1.56232654242206, 218, 57, 'PPL', 'P'),
(15103, 'Bascom', 30.9277801513672, 0.539791593974308, -85.1186065673828, -1.4855999393105, 218, 12, 'PPL', 'P'),
(19083, 'Bascom', 32.8402786254883, 0.573170989287088, -81.668327331543, -1.4253812065319, 218, 13, 'PPL', 'P'),
(34690, 'Bascom', 38.0400009155273, 0.66392326343761, -83.1613922119141, -1.45144010464027, 218, 21, 'PPL', 'P'),
(92458, 'Bascom', 32.3227806091309, 0.564138945029112, -95.2172164916992, -1.6618539323644, 218, 51, 'PPL', 'P'),
(154194, 'Bascom', 41.1327781677246, 0.717902409519235, -83.2852783203125, -1.45360232512931, 218, 41, 'PPL', 'P'),
(195930, 'Bascom', 46.6261100769043, 0.813779138239286, -107.752777099609, -1.88064073855573, 218, 31, 'PPL', 'P'),
(29161, 'Bascom Corner', 38.9088897705078, 0.679088234790902, -84.9686126708984, -1.48298205195895, 218, 19, 'PPL', 'P'),
(19084, 'Bascombs Springs', 34.0933303833008, 0.595040868158819, -84.5472183227539, -1.47562733313453, 218, 13, 'PPL', 'P'),
(79673, 'Bascomville', 34.6988906860352, 0.605609889260908, -80.9766693115234, -1.41330949678473, 218, 48, 'PPL', 'P'),
(7288, 'Base Line', 34.6680603027344, 0.605071797562657, -92.3177795410156, -1.61124921112098, 218, 4, 'PPL', 'P'),
(31744, 'Basehor', 39.1416702270508, 0.683151020191873, -94.9383316040039, -1.65698647284006, 218, 20, 'PPL', 'P'),
(39235, 'Basel (historical)', 30.7369403839111, 0.536460811688459, -91.3452835083008, -1.59427595338753, 218, 22, 'PPL', 'P'),
(195931, 'Baseline', 45.7838897705078, 0.799079620865512, -108.702499389648, -1.89721651949649, 218, 31, 'PPL', 'P'),
(141238, 'Basford (historical)', 42.0041694641113, 0.733111056714405, -96.3652801513672, -1.6818914232481, 218, 35, 'PPL', 'P'),
(158950, 'Basforth Acres', 40.3438911437988, 0.704133733525471, -79.5763931274414, -1.38887006693524, 218, 45, 'PPL', 'P'),
(188116, 'Basgal Place', 35.3663902282715, 0.617259954028486, -108.472778320313, -1.89320713047538, 218, 38, 'PPL', 'P'),
(99657, 'Basham', 37.0361099243164, 0.646402060309869, -80.3427810668945, -1.40224605982627, 218, 53, 'PPL', 'P'),
(112195, 'Basham', 34.514720916748, 0.602395520404209, -87.0180587768555, -1.51875163435008, 218, 2, 'PPL', 'P'),
(92459, 'Basham Colonia (M and B)', 26.2660007476807, 0.45842819437832, -98.3430023193359, -1.71640918676883, 218, 51, 'PPL', 'P'),
(92460, 'Basham Number 1 Colonia', 26.2609996795654, 0.458340909273593, -98.3550033569336, -1.71661864438857, 218, 51, 'PPL', 'P'),
(92477, 'Basham Number 10 Colonia', 26.2630004882813, 0.458375829973386, -98.3369979858398, -1.71630439137994, 218, 51, 'PPL', 'P'),
(92461, 'Basham Number 11 Colonia', 26.2530002593994, 0.458201293053445, -98.3610000610352, -1.71672330661941, 218, 51, 'PPL', 'P'),
(92462, 'Basham Number 12 Colonia', 26.2689990997314, 0.45848052549374, -98.3820037841797, -1.71708989074346, 218, 51, 'PPL', 'P'),
(92463, 'Basham Number 13 Colonia', 26.2730007171631, 0.458550366893327, -98.3809967041016, -1.71707231388026, 218, 51, 'PPL', 'P'),
(92464, 'Basham Number 14 Colonia', 26.3199996948242, 0.459370653798585, -98.2770004272461, -1.71525723643932, 218, 51, 'PPL', 'P'),
(92465, 'Basham Number 15 Colonia', 26.2409992218018, 0.45799183543371, -98.3629989624023, -1.71675819402969, 218, 51, 'PPL', 'P'),
(92466, 'Basham Number 16 Colonia', 26.2719993591309, 0.458532889898674, -98.3820037841797, -1.71708989074346, 218, 51, 'PPL', 'P'),
(92467, 'Basham Number 18 Colonia', 26.2430000305176, 0.458026756133504, -98.3669967651367, -1.71682796885025, 218, 51, 'PPL', 'P'),
(92468, 'Basham Number 19 Colonia', 26.226110458374, 0.457731977490346, -98.3755569458008, -1.7169773721874, 218, 51, 'PPL', 'P'),
(92469, 'Basham Number 2 Colonia', 26.2600002288818, 0.458323465568453, -98.3410034179688, -1.71637429935855, 218, 51, 'PPL', 'P'),
(92470, 'Basham Number 3 Colonia', 26.3540000915527, 0.459964072668482, -98.3519973754883, -1.71656618011509, 218, 51, 'PPL', 'P'),
(92471, 'Basham Number 4 Colonia', 26.2770004272461, 0.458620175003401, -98.3610000610352, -1.71672330661941, 218, 51, 'PPL', 'P'),
(92472, 'Basham Number 5 Colonia', 26.2830009460449, 0.458724903813268, -98.3550033569336, -1.71661864438857, 218, 51, 'PPL', 'P'),
(92473, 'Basham Number 6 Colonia', 26.2549991607666, 0.458236180463725, -98.3420028686523, -1.71639174306369, 218, 51, 'PPL', 'P'),
(92474, 'Basham Number 7 Colonia', 26.2520008087158, 0.458183849348305, -98.3420028686523, -1.71639174306369, 218, 51, 'PPL', 'P'),
(92475, 'Basham Number 8 Colonia', 26.2830009460449, 0.458724903813268, -98.3600006103516, -1.71670586291427, 218, 51, 'PPL', 'P'),
(92476, 'Basham Number 9 Colonia', 26.3279991149902, 0.459510270018733, -98.3440017700195, -1.71642663047397, 218, 51, 'PPL', 'P'),
(71748, 'Bashan', 39.0433311462402, 0.681434679448344, -81.8652801513672, -1.42881868170892, 218, 41, 'PPL', 'P'),
(79674, 'Bashan', 32.5513916015625, 0.568128959553296, -80.9463882446289, -1.41278099246641, 218, 48, 'PPL', 'P'),
(177479, 'Bashan', 41.5130615234375, 0.724539606166958, -72.4338912963867, -1.26420989315361, 218, 8, 'PPL', 'P'),
(173073, 'Bashaw', 45.7691688537598, 0.798822692399347, -92.0630569458008, -1.60680346315526, 218, 57, 'PPL', 'P'),
(7289, 'Bashe', 35.3125, 0.616319392110498, -94.4341735839844, -1.64818725544038, 218, 4, 'PPL', 'P'),
(645, 'Basher', 36.9966697692871, 0.645713699747111, -92.605827331543, -1.61627659346878, 218, 29, 'PPL', 'P'),
(112963, 'Bashi', 31.9711093902588, 0.558001124375293, -87.8613891601563, -1.53347052622078, 218, 2, 'PPL', 'P'),
(112430, 'Basic', 32.2183303833008, 0.562315944683925, -88.769172668457, -1.54931433733594, 218, 30, 'PPL', 'P'),
(189923, 'Basic', 38.871940612793, 0.67844335033294, -117.899169921875, -2.05772870050498, 218, 39, 'PPL', 'P'),
(31745, 'Basil', 37.5163917541504, 0.654784559577975, -98.0899963378906, -1.71199339936537, 218, 20, 'PPL', 'P'),
(39236, 'Basile', 30.4850006103516, 0.532063633123116, -92.595832824707, -1.61610215641738, 218, 22, 'PPL', 'P'),
(108107, 'Basin', 37.5366706848145, 0.655138493686847, -81.2897186279297, -1.41877323807714, 218, 58, 'PPL', 'P'),
(112964, 'Basin', 31.3413906097412, 0.547010458293617, -86.1308288574219, -1.50326655103376, 218, 2, 'PPL', 'P'),
(179963, 'Basin', 35.0430603027344, 0.611616782257636, -116.294166564941, -2.02971610742093, 218, 6, 'PPL', 'P'),
(186388, 'Basin', 38.0658302307129, 0.664374070031133, -108.536109924316, -1.89431247548581, 218, 7, 'PPL', 'P'),
(194559, 'Basin', 42.2455596923828, 0.737324110979883, -113.78360748291, -1.98589858537364, 218, 17, 'PPL', 'P'),
(195932, 'Basin', 46.2713890075684, 0.807588087653179, -112.26277923584, -1.95935512510493, 218, 31, 'PPL', 'P'),
(209293, 'Basin', 44.3800010681152, 0.774577140677211, -108.038330078125, -1.8856245782197, 218, 59, 'PPL', 'P'),
(206770, 'Basin City', 46.5941696166992, 0.813221672044106, -119.151107788086, -2.07957913830076, 218, 56, 'PPL', 'P'),
(13325, 'Basin Corner', 39.6805610656738, 0.692556439634678, -75.5902786254883, -1.31929924451466, 218, 10, 'PPL', 'P'),
(191113, 'Basin Junction', 29.3341693878174, 0.511977839155143, -103.25611114502, -1.8021591122858, 218, 51, 'PPL', 'P'),
(126833, 'Basin Mills', 44.874439239502, 0.783206714715449, -68.6669387817383, -1.19846416900672, 218, 26, 'PPL', 'P'),
(34691, 'Basin Spring', 37.8419418334961, 0.660466480342687, -86.3066711425781, -1.50633557787396, 218, 21, 'PPL', 'P'),
(92478, 'Basin Springs', 33.7266693115234, 0.588641425217413, -96.836669921875, -1.69011872680368, 218, 51, 'PPL', 'P'),
(15104, 'Basinger', 27.3999996185303, 0.478220208388544, -81.0166702270508, -1.4140076444645, 218, 12, 'PPL', 'P'),
(99660, 'Baskerville', 36.6888885498047, 0.640341904091339, -78.2750015258789, -1.36615649863017, 218, 53, 'PPL', 'P'),
(99661, 'Baskerville Mill', 36.9755592346191, 0.645345251410299, -77.7697219848633, -1.35733770699648, 218, 53, 'PPL', 'P'),
(147029, 'Basket', 41.8488883972168, 0.730400890831086, -75.1102828979492, -1.3109217386736, 218, 40, 'PPL', 'P'),
(158952, 'Basket', 40.3899993896484, 0.704938474227865, -75.8263931274414, -1.32342021998545, 218, 45, 'PPL', 'P'),
(19085, 'Basket Creek', 33.5958290100098, 0.586357831161697, -84.820556640625, -1.48039798675325, 218, 13, 'PPL', 'P'),
(34692, 'Baskett', 37.8708305358887, 0.660970683316066, -87.4625015258789, -1.52650862365715, 218, 21, 'PPL', 'P'),
(15105, 'Baskin', 27.8966693878174, 0.486888731157724, -82.795280456543, -1.44505024907879, 218, 12, 'PPL', 'P'),
(39237, 'Baskin', 32.2588882446289, 0.563023812901668, -91.7474975585938, -1.60129591286292, 218, 22, 'PPL', 'P'),
(79675, 'Baskin Hills', 33.9930610656738, 0.593290838427501, -81.1941680908203, -1.41710556660253, 218, 48, 'PPL', 'P'),
(144793, 'Basking Ridge', 40.7061080932617, 0.710455611900128, -74.5497207641602, -1.30113808377698, 218, 37, 'PPL', 'P'),
(192992, 'Basking Ridge', 33.6394386291504, 0.587118962601242, -111.935829162598, -1.95364876983722, 218, 5, 'PPL', 'P'),
(39238, 'Baskinton', 32.3111114501953, 0.563935279784748, -91.6805572509766, -1.6001275840927, 218, 22, 'PPL', 'P'),
(108104, 'Basnettville', 39.586109161377, 0.690907942919919, -80.2358322143555, -1.40037945021824, 218, 58, 'PPL', 'P'),
(147030, 'Basom', 43.0672187805176, 0.751664767396769, -78.3916702270508, -1.36819275159965, 218, 40, 'PPL', 'P'),
(108105, 'Basore', 38.8636093139648, 0.678297941737421, -78.8305587768555, -1.37585280184304, 218, 58, 'PPL', 'P'),
(200377, 'Basque', 42.410831451416, 0.740208647335575, -117.867500305176, -2.05717596142074, 218, 43, 'PPL', 'P'),
(7290, 'Bass', 35.9041709899902, 0.626645998974362, -92.9977798461914, -1.62311745536087, 218, 4, 'PPL', 'P'),
(15106, 'Bass', 30.1083297729492, 0.525489486814201, -82.6961135864258, -1.44331946068635, 218, 12, 'PPL', 'P'),
(19086, 'Bass', 32.5855598449707, 0.568725307900392, -83.6666717529297, -1.46025889627396, 218, 13, 'PPL', 'P'),
(34693, 'Bass', 37.3386116027832, 0.651681710591924, -85.1447219848633, -1.48605573933107, 218, 21, 'PPL', 'P'),
(53353, 'Bass', 38.4319381713867, 0.670763859013587, -92.3249969482422, -1.61137517864054, 218, 29, 'PPL', 'P'),
(108106, 'Bass', 38.9483299255371, 0.67977659535366, -79.0025024414063, -1.3788537849174, 218, 58, 'PPL', 'P'),
(112966, 'Bass', 34.9319381713867, 0.609677335193786, -85.9130630493164, -1.49946582068405, 218, 2, 'PPL', 'P'),
(84838, 'Bass Bay', 36.2822189331055, 0.633244180312115, -87.975830078125, -1.53546789703834, 218, 50, 'PPL', 'P'),
(19087, 'Bass Crossroads', 33.1425018310547, 0.578445779300154, -84.9013900756836, -1.48180879634072, 218, 13, 'PPL', 'P'),
(62734, 'Bass Crossroads', 35.9841690063477, 0.628042227754863, -78.0788879394531, -1.36273367083915, 218, 33, 'PPL', 'P'),
(79677, 'Bass Crossroads', 33.9263916015625, 0.592127236768218, -79.648063659668, -1.39012095369925, 218, 48, 'PPL', 'P'),
(126834, 'Bass Harbor', 44.2400016784668, 0.772133690377063, -68.3444366455078, -1.19283544488478, 218, 26, 'PPL', 'P'),
(15107, 'Bass Haven', 29.9269409179688, 0.522323654068369, -81.5849990844727, -1.42392685426061, 218, 12, 'PPL', 'P'),
(122194, 'Bass Lake', 41.207218170166, 0.71920163265703, -86.601936340332, -1.51148892774132, 218, 19, 'PPL', 'P'),
(158953, 'Bass Lake', 40.1458282470703, 0.70067688385152, -76.7819366455078, -1.3400976005218, 218, 45, 'PPL', 'P'),
(179964, 'Bass Lake', 37.3247184753418, 0.651439229774672, -119.565277099609, -2.08680775644756, 218, 6, 'PPL', 'P'),
(179965, 'Bass Lake Annex', 37.2713890075684, 0.65050845497369, -119.533058166504, -2.08624542998339, 218, 6, 'PPL', 'P'),
(154195, 'Bass Landing', 40.5105590820313, 0.707042637805137, -84.5266723632813, -1.47526873849375, 218, 41, 'PPL', 'P'),
(134112, 'Bass Mobile Home Park', 43.8699989318848, 0.765675924207785, -93.0472183227539, -1.62398031955405, 218, 28, 'PPL', 'P'),
(70501, 'Bass River', 39.5924987792969, 0.691019462790566, -74.4430618286133, -1.29927653417501, 218, 37, 'PPL', 'P'),
(124189, 'Bass River', 41.6527786254883, 0.726978129619089, -70.2041702270508, -1.22529391909261, 218, 23, 'PPL', 'P'),
(124190, 'Bass Rocks', 42.6141700744629, 0.743757575804215, -70.6358337402344, -1.23282786865839, 218, 23, 'PPL', 'P'),
(122195, 'Bass Station', 41.1852798461914, 0.718818736671304, -86.6022186279297, -1.51149385458934, 218, 19, 'PPL', 'P'),
(19088, 'Bass Store', 31.6755599975586, 0.552842814370405, -84.8230590820313, -1.48044166259512, 218, 13, 'PPL', 'P'),
(39239, 'Bassa Bassa', 29.3636093139648, 0.51249166279796, -89.9944381713867, -1.57069925457316, 218, 22, 'PPL', 'P'),
(124191, 'Bassets Corner', 42.4813919067383, 0.741440159602655, -72.1291732788086, -1.25889156045672, 218, 23, 'PPL', 'P'),
(7292, 'Bassett', 35.5363883972168, 0.620226981798944, -90.1266708374023, -1.57300714997383, 218, 4, 'PPL', 'P'),
(31746, 'Bassett', 37.9027786254883, 0.661528282669301, -95.4038925170898, -1.665112043642, 218, 20, 'PPL', 'P'),
(92479, 'Bassett', 33.3166694641113, 0.581485577947397, -94.5608291625977, -1.6503978123032, 218, 51, 'PPL', 'P'),
(99662, 'Bassett', 36.7591705322266, 0.64156855608943, -79.9905624389648, -1.39609868508204, 218, 53, 'PPL', 'P'),
(114515, 'Bassett', 43.063060760498, 0.751592196257064, -92.5152816772461, -1.61469627367793, 218, 16, 'PPL', 'P'),
(134113, 'Bassett', 47.3872184753418, 0.827062985756602, -91.82861328125, -1.60271164929841, 218, 28, 'PPL', 'P'),
(141240, 'Bassett', 42.5858306884766, 0.74326296021076, -99.5374984741211, -1.73725707757224, 218, 35, 'PPL', 'P'),
(173077, 'Bassett', 42.5405616760254, 0.74247286689436, -88.227783203125, -1.53986530863028, 218, 57, 'PPL', 'P'),
(179967, 'Bassett', 34.0497207641602, 0.594279736719274, -117.995826721191, -2.0594156798975, 218, 6, 'PPL', 'P'),
(194560, 'Bassett', 43.6511116027832, 0.761855619624066, -112.087501525879, -1.95629595196076, 218, 17, 'PPL', 'P'),
(154196, 'Bassett (historical)', 41.2119407653809, 0.719284057492768, -83.6736068725586, -1.4603799369455, 218, 41, 'PPL', 'P'),
(189924, 'Bassett (historical)', 39.458610534668, 0.688682672092076, -114.511390686035, -1.99860079850888, 218, 39, 'PPL', 'P'),
(171719, 'Bassett Development', 43.6202812194824, 0.761317527925816, -72.9449996948242, -1.27313041754094, 218, 55, 'PPL', 'P'),
(99663, 'Bassett Forks', 36.7408294677734, 0.641248444126402, -79.934440612793, -1.39511917443311, 218, 53, 'PPL', 'P'),
(206771, 'Bassett Junction', 47.0424995422363, 0.821046505379949, -119.08805847168, -2.07847872013834, 218, 56, 'PPL', 'P'),
(179966, 'Bassetts', 39.6197204589844, 0.691494570729036, -120.586387634277, -2.10462949730432, 218, 6, 'PPL', 'P'),
(112967, 'Bassetts Creek', 31.4644393920898, 0.549158064686171, -88.0322189331055, -1.53645206821918, 218, 2, 'PPL', 'P'),
(58562, 'Bassfield', 31.4963893890381, 0.54971569732892, -89.7394409179688, -1.56624871291748, 218, 30, 'PPL', 'P'),
(53354, 'Bassinger Corner', 39.2808303833008, 0.685579823106025, -91.644172668457, -1.59949255333077, 218, 29, 'PPL', 'P'),
(62731, 'Basstown', 35.0869407653809, 0.612382640808115, -78.3566665649414, -1.36758182244558, 218, 33, 'PPL', 'P'),
(19089, 'Bassville', 31.7819404602051, 0.554699503703381, -82.370002746582, -1.43762775280463, 218, 13, 'PPL', 'P'),
(53355, 'Bassville', 37.3444404602051, 0.651783443345565, -93.1322174072266, -1.62546383343928, 218, 29, 'PPL', 'P'),
(15108, 'Bassville Park', 28.8402805328369, 0.503357852496829, -81.7688903808594, -1.42713636284832, 218, 12, 'PPL', 'P'),
(129682, 'Basswood', 46.1886100769043, 0.806143322761811, -88.8450012207031, -1.55063779523965, 218, 27, 'PPL', 'P'),
(134115, 'Basswood', 46.4555587768555, 0.810802456509878, -95.6930618286133, -1.67015900022381, 218, 28, 'PPL', 'P'),
(173078, 'Basswood', 43.2625007629395, 0.755073080959852, -90.4991683959961, -1.57950845882693, 218, 57, 'PPL', 'P'),
(15109, 'Basswood Estates', 27.2777805328369, 0.476087082934417, -80.8574981689453, -1.41122956797338, 218, 12, 'PPL', 'P'),
(134116, 'Basswood Grove', 44.827220916748, 0.782382599516124, -92.7991714477539, -1.61965108488602, 218, 28, 'PPL', 'P'),
(99664, 'Bastian', 37.1519393920898, 0.648423665893348, -81.1502838134766, -1.41633964147303, 218, 53, 'PPL', 'P'),
(19090, 'Bastonville', 33.3077812194824, 0.5813304488139, -82.5316696166992, -1.44044937197957, 218, 13, 'PPL', 'P'),
(158954, 'Bastress', 41.1758308410645, 0.718653820420801, -77.1374969482422, -1.3463032984939, 218, 45, 'PPL', 'P'),
(39240, 'Bastrop', 32.7561111450195, 0.571701989629801, -91.8722229003906, -1.60347278073795, 218, 22, 'PPL', 'P'),
(92480, 'Bastrop', 30.110279083252, 0.525523508697126, -97.3150024414063, -1.69846720418886, 218, 51, 'PPL', 'P'),
(92483, 'Bastrop Beach', 29.1116695404053, 0.508094484232616, -95.3722229003906, -1.66455930455775, 218, 51, 'PPL', 'P'),
(99665, 'Basye', 38.8069381713867, 0.677308843708566, -78.7925033569336, -1.37518860946718, 218, 53, 'PPL', 'P'),
(39241, 'Bat', 30.7166690826416, 0.536107010737642, -91.898063659668, -1.60392378706856, 218, 22, 'PPL', 'P'),
(62733, 'Bat Cave', 35.4513893127441, 0.618743467913715, -82.2872161865234, -1.43618285475521, 218, 33, 'PPL', 'P'),
(84840, 'Bat Harbor', 35.9324989318848, 0.627140414830735, -83.1308288574219, -1.45090667347393, 218, 50, 'PPL', 'P'),
(99666, 'Bataan Village', 38.7630615234375, 0.676543051737113, -77.5205612182617, -1.35298903125249, 218, 53, 'PPL', 'P'),
(709, 'Batarora', 34.2400016784668, 0.59760076517763, -78.1447219848633, -1.36388269169146, 218, 33, 'PPL', 'P'),
(7293, 'Batavia', 36.2550010681152, 0.632769138952672, -93.2225036621094, -1.62703962585628, 218, 4, 'PPL', 'P'),
(71749, 'Batavia', 39.0769386291504, 0.682021240678434, -84.1769409179688, -1.46916477327529, 218, 41, 'PPL', 'P'),
(114517, 'Batavia', 40.9941711425781, 0.715483260564034, -92.1672210693359, -1.6086214700734, 218, 16, 'PPL', 'P'),
(118734, 'Batavia', 41.8499984741211, 0.730420265328016, -88.3125, -1.54134389566749, 218, 18, 'PPL', 'P'),
(129683, 'Batavia', 41.9124984741211, 0.731511096110512, -85.0980606079102, -1.48524134466972, 218, 27, 'PPL', 'P'),
(147031, 'Batavia', 42.9980583190918, 0.75045768963269, -78.1877822875977, -1.36463423575108, 218, 40, 'PPL', 'P'),
(173079, 'Batavia', 43.5944404602051, 0.760866521595211, -88.0508270263672, -1.53677684071412, 218, 57, 'PPL', 'P'),
(179968, 'Batavia', 38.4063911437988, 0.670317979268081, -121.858612060547, -2.12683400236701, 218, 6, 'PPL', 'P'),
(195933, 'Batavia', 48.1819381713867, 0.840933461083034, -114.412216186523, -1.99686987695838, 218, 31, 'PPL', 'P'),
(129684, 'Batavia Center', 41.940559387207, 0.732000851434978, -85.1183319091797, -1.48559514562054, 218, 27, 'PPL', 'P'),
(118735, 'Batavia Junction', 41.795280456543, 0.729465255761114, -88.2405624389648, -1.54008834837157, 218, 18, 'PPL', 'P'),
(126835, 'Batchelders Crossing', 44.1897201538086, 0.771256112218855, -69.9402770996094, -1.22068811514537, 218, 26, 'PPL', 'P'),
(129686, 'Batcheller', 44.0041694641113, 0.768017641754291, -86.1308288574219, -1.50326655103376, 218, 27, 'PPL', 'P'),
(147041, 'Batchellerville', 43.211669921875, 0.75418591542172, -74.0822219848633, -1.29297869082919, 218, 40, 'PPL', 'P'),
(39242, 'Batchelor', 30.8402805328369, 0.538264437536715, -91.6613922119141, -1.59979309105979, 218, 22, 'PPL', 'P'),
(62736, 'Batchelor Crossroads', 35.9483299255371, 0.627416717793831, -78.0163879394531, -1.36164284005665, 218, 33, 'PPL', 'P'),
(112965, 'Batchelor Subdivision', 33.3469390869141, 0.582013882528642, -87.5888900756836, -1.52871451998806, 218, 2, 'PPL', 'P'),
(26457, 'Batchtown', 39.0330581665039, 0.681255382127954, -90.6575012207031, -1.58227188793205, 218, 18, 'PPL', 'P'),
(92482, 'Bateman', 29.9511108398438, 0.522745498785038, -97.4749984741211, -1.70125966174986, 218, 51, 'PPL', 'P'),
(173080, 'Bateman', 44.9311103820801, 0.784195812744305, -91.2677764892578, -1.59292320071182, 218, 57, 'PPL', 'P'),
(193360, 'Bateman Place', 40.6236114501953, 0.709015773856777, -121.737503051758, -2.12472025140982, 218, 6, 'PPL', 'P'),
(154205, 'Batemantown', 40.5258293151855, 0.707309153651227, -82.5961074829102, -1.44157402490791, 218, 41, 'PPL', 'P'),
(7296, 'Bates', 34.9080581665039, 0.609260550483188, -94.3866729736328, -1.64735821339304, 218, 4, 'PPL', 'P'),
(26458, 'Bates', 39.7241706848145, 0.693317571074223, -89.8494415283203, -1.56816858574732, 218, 18, 'PPL', 'P'),
(39243, 'Bates', 30.4213905334473, 0.530953427843689, -92.3983306884766, -1.61265509386043, 218, 22, 'PPL', 'P'),
(84841, 'Bates', 35.9099998474121, 0.626747731728003, -87.3744430541992, -1.52497171339207, 218, 50, 'PPL', 'P'),
(129687, 'Bates', 44.7727813720703, 0.781432450218211, -85.4441680908203, -1.49128205981229, 218, 27, 'PPL', 'P'),
(147035, 'Bates', 42.4463882446289, 0.740829230448591, -74.2747192382813, -1.29633840170238, 218, 40, 'PPL', 'P'),
(154197, 'Bates', 41.5905609130859, 0.725892225684609, -83.5783309936523, -1.45871705916086, 218, 41, 'PPL', 'P'),
(188117, 'Bates', 36.2958297729492, 0.63348173428135, -103.202499389648, -1.8012234106368, 218, 38, 'PPL', 'P'),
(194561, 'Bates', 43.6916694641113, 0.762563487841809, -111.199996948242, -1.94080607495447, 218, 17, 'PPL', 'P'),
(200378, 'Bates', 44.5930595397949, 0.778295712507289, -118.507499694824, -2.06834605798086, 218, 43, 'PPL', 'P'),
(206772, 'Bates', 45.7050018310547, 0.797702766581941, -120.425559997559, -2.10182252551537, 218, 56, 'PPL', 'P'),
(44622, 'Bates Acres', 38.211109161377, 0.666909665704997, -76.4855575561523, -1.33492480957849, 218, 25, 'PPL', 'P'),
(53356, 'Bates City', 39.0061111450195, 0.680785067879446, -94.0722198486328, -1.6418699710186, 218, 29, 'PPL', 'P'),
(53357, 'Bates Corner', 36.6541709899902, 0.639735968364319, -93.8086090087891, -1.63726909391938, 218, 29, 'PPL', 'P'),
(154198, 'Bates Corners', 41.0505599975586, 0.716467431744873, -81.6380615234375, -1.42485296852968, 218, 41, 'PPL', 'P'),
(62737, 'Bates Creek', 35.1130599975586, 0.61283850740771, -84.0530624389648, -1.46700268594431, 218, 33, 'PPL', 'P'),
(53359, 'Bates Creek Camp', 37.9061088562012, 0.661586406160092, -90.8213882446289, -1.58513225610085, 218, 29, 'PPL', 'P'),
(84842, 'Bates Hill', 35.7305603027344, 0.623615920865097, -85.9313888549805, -1.49978566633097, 218, 50, 'PPL', 'P'),
(129688, 'Bates Junction', 46.0863914489746, 0.804359271147567, -88.601936340332, -1.54639551278121, 218, 27, 'PPL', 'P'),
(129689, 'Bates Location', 46.1130599975586, 0.804824725127086, -88.6161117553711, -1.54664292044648, 218, 27, 'PPL', 'P'),
(70503, 'Bates Mill', 39.7069396972656, 0.693016833608126, -74.8655624389648, -1.30665056091733, 218, 37, 'PPL', 'P'),
(188118, 'Bates Place', 35.4944381713867, 0.619494812236254, -103.412780761719, -1.80489351293504, 218, 38, 'PPL', 'P'),
(79678, 'Batesburg', 33.9077796936035, 0.591802397694255, -81.5475006103516, -1.42327238242272, 218, 48, 'PPL', 'P'),
(79680, 'Batesburg-Leesville', 33.9099998474121, 0.591841146688116, -81.5374984741211, -1.42309781221327, 218, 48, 'PPL', 'P'),
(201886, 'Batesland', 43.1294403076172, 0.752750737910276, -102.101669311523, -1.78201030126854, 218, 49, 'PPL', 'P'),
(118737, 'Batestown', 40.1199989318848, 0.700226077257997, -87.6963882446289, -1.53059071697602, 218, 18, 'PPL', 'P'),
(7298, 'Batesville', 35.769718170166, 0.624299354579838, -91.6408309936523, -1.5994342301029, 218, 4, 'PPL', 'P'),
(19092, 'Batesville', 34.7480583190918, 0.606468026343158, -83.6113891601563, -1.45929403301102, 218, 13, 'PPL', 'P'),
(29163, 'Batesville', 39.2999992370605, 0.685914382717966, -85.2222213745117, -1.48740835884872, 218, 19, 'PPL', 'P'),
(31747, 'Batesville', 37.836109161377, 0.660364681010018, -95.8702774047852, -1.67325199551383, 218, 20, 'PPL', 'P'),
(53360, 'Batesville', 36.6988906860352, 0.640516474300794, -90.2461090087891, -1.57509173931709, 218, 29, 'PPL', 'P'),
(58564, 'Batesville', 34.3113899230957, 0.598846725093624, -89.9441680908203, -1.56982187615204, 218, 30, 'PPL', 'P'),
(71751, 'Batesville', 39.9141693115234, 0.696633672684562, -81.2813873291016, -1.41862782948162, 218, 41, 'PPL', 'P'),
(79681, 'Batesville', 34.8505592346191, 0.608257004805419, -82.230827331543, -1.43519868357437, 218, 48, 'PPL', 'P'),
(92485, 'Batesville', 28.9508304595947, 0.505287312706591, -99.6175003051758, -1.73865337293177, 218, 51, 'PPL', 'P'),
(99667, 'Batesville', 37.9955596923828, 0.663147617770124, -78.7225036621094, -1.3739668843171, 218, 53, 'PPL', 'P'),
(112969, 'Batesville', 32.0088882446289, 0.558660489771683, -85.3111114501953, -1.48895978334174, 218, 2, 'PPL', 'P'),
(126836, 'Batesville', 46.125560760498, 0.805042904599391, -68.3475036621094, -1.19288897442269, 218, 26, 'PPL', 'P'),
(19093, 'Bath', 33.3386116027832, 0.581868540512151, -82.1766662597656, -1.43425339454544, 218, 13, 'PPL', 'P'),
(29164, 'Bath', 39.5083312988281, 0.689550463133279, -84.8625030517578, -1.48113008973691, 218, 19, 'PPL', 'P'),
(34694, 'Bath', 37.2425003051758, 0.65000425200031, -82.9113922119141, -1.44707678151028, 218, 21, 'PPL', 'P'),
(62741, 'Bath', 35.4769401550293, 0.619189414238249, -76.8119430541992, -1.34062131115017, 218, 33, 'PPL', 'P'),
(79682, 'Bath', 33.5044403076172, 0.584762797405822, -81.8691711425781, -1.42888659231672, 218, 48, 'PPL', 'P'),
(92486, 'Bath', 30.5944404602051, 0.533973718835948, -95.6236114501953, -1.66894686245366, 218, 51, 'PPL', 'P'),
(118738, 'Bath', 40.1933288574219, 0.701505925898862, -90.1408309936523, -1.57325429132299, 218, 18, 'PPL', 'P'),
(126837, 'Bath', 43.9105606079102, 0.766383859004555, -69.8211135864258, -1.21860831949208, 218, 26, 'PPL', 'P'),
(129691, 'Bath', 42.8186111450195, 0.74732574561173, -84.4486083984375, -1.47390626528007, 218, 27, 'PPL', 'P'),
(134117, 'Bath', 43.8255615234375, 0.764900345119326, -93.3897171020508, -1.62995805093684, 218, 28, 'PPL', 'P'),
(143499, 'Bath', 44.1669387817383, 0.770858502268106, -71.966667175293, -1.25605529389579, 218, 36, 'PPL', 'P'),
(147036, 'Bath', 42.3369407653809, 0.738919011577704, -77.3180618286133, -1.34945475016985, 218, 40, 'PPL', 'P'),
(154199, 'Bath', 41.1888885498047, 0.718881720431084, -81.6363906860352, -1.42482380691575, 218, 41, 'PPL', 'P'),
(158960, 'Bath', 40.7255592346191, 0.710795098360086, -75.3944396972656, -1.3158812104136, 218, 45, 'PPL', 'P'),
(169798, 'Bath', 45.4683303833008, 0.793572070573174, -98.3233337402344, -1.71606590530432, 218, 49, 'PPL', 'P'),
(179969, 'Bath (historical)', 39.0361099243164, 0.681308645349756, -120.792221069336, -2.10822196845678, 218, 6, 'PPL', 'P'),
(158956, 'Bath Addition', 40.1074981689453, 0.700007897785693, -74.8655624389648, -1.30665056091733, 218, 45, 'PPL', 'P'),
(99668, 'Bath Alum', 38.0486106872559, 0.664073532302117, -79.7188873291016, -1.39135705991921, 218, 53, 'PPL', 'P'),
(147037, 'Bath Beach', 40.6044387817383, 0.708681147665808, -74.0047225952148, -1.29162607131154, 218, 40, 'PPL', 'P'),
(154200, 'Bath Center', 41.1686096191406, 0.718527786322213, -81.6369400024414, -1.42483339429567, 218, 41, 'PPL', 'P'),
(169799, 'Bath Corner', 45.459171295166, 0.793412214328742, -98.3291702270508, -1.71616777121602, 218, 49, 'PPL', 'P'),
(158957, 'Bath Junction', 40.7219390869141, 0.710731914863224, -75.3813934326172, -1.3156535101404, 218, 45, 'PPL', 'P'),
(84843, 'Bath Springs', 35.4397201538086, 0.618539802669351, -88.0877838134766, -1.53742185833013, 218, 50, 'PPL', 'P'),
(112971, 'Bath Springs', 34.1116714477539, 0.595360980121847, -85.8897171020508, -1.49905835703727, 218, 2, 'PPL', 'P'),
(139647, 'Bathgate', 48.8772201538086, 0.853068420906089, -97.475830078125, -1.7012741759778, 218, 34, 'PPL', 'P'),
(84844, 'Batley', 36.0291709899902, 0.628827660539355, -84.288330078125, -1.47110888087105, 218, 50, 'PPL', 'P'),
(99673, 'Batna', 38.4013900756836, 0.670230694163353, -77.8908309936523, -1.35945145795368, 218, 53, 'PPL', 'P'),
(62740, 'Baton', 35.8072204589844, 0.624953892996753, -81.5319366455078, -1.42300073999153, 218, 33, 'PPL', 'P'),
(39245, 'Baton Rouge', 30.4505596160889, 0.531462524375571, -91.1544418334961, -1.59094513781216, 218, 22, 'PPL', 'P'),
(79683, 'Baton Rouge', 34.6969413757324, 0.605575867377982, -81.3441696166992, -1.41972358711214, 218, 48, 'PPL', 'P'),
(39247, 'Batree', 29.999719619751, 0.523593882039796, -90.7863922119141, -1.58452146010484, 218, 22, 'PPL', 'P'),
(7299, 'Batson', 35.6222190856934, 0.621725009912113, -93.647216796875, -1.63445226843441, 218, 4, 'PPL', 'P'),
(19094, 'Batson', 32.3083305358887, 0.563886743673881, -83.0680618286133, -1.44981118215952, 218, 13, 'PPL', 'P'),
(58565, 'Batson', 31.2688903808594, 0.54574509059118, -89.1958312988281, -1.55676093521796, 218, 30, 'PPL', 'P'),
(92489, 'Batson', 30.2491703033447, 0.527947617789857, -94.6069412231445, -1.65120261958462, 218, 51, 'PPL', 'P'),
(154203, 'Batson', 41.0183296203613, 0.715904905543621, -84.745002746582, -1.47907932253949, 218, 41, 'PPL', 'P'),
(92487, 'Batson Gardens Colonia', 26.3239994049072, 0.459440461908659, -98.1890029907227, -1.71372139143867, 218, 51, 'PPL', 'P'),
(70504, 'Batsto', 39.6416702270508, 0.691877666451844, -74.648063659668, -1.30285449109953, 218, 37, 'PPL', 'P'),
(99670, 'Batt', 37.5686111450195, 0.655695959882028, -76.6488876342773, -1.33777545720931, 218, 53, 'PPL', 'P'),
(58566, 'Batt Place', 30.9752807617188, 0.540620636021649, -88.9791717529297, -1.55297951278616, 218, 30, 'PPL', 'P'),
(112970, 'Battelle', 34.6494407653809, 0.60474682533064, -85.5652770996094, -1.49339581076949, 218, 2, 'PPL', 'P'),
(112968, 'Battens Crossroads', 31.2608299255371, 0.545604409106596, -85.8899993896484, -1.49906328388529, 218, 2, 'PPL', 'P'),
(147039, 'Battenville', 43.1091690063477, 0.752396936959459, -73.4244384765625, -1.28149820284402, 218, 40, 'PPL', 'P'),
(44617, 'Batter Brook Farms', 39.4377784729004, 0.688319084024253, -76.438606262207, -1.33410535491107, 218, 25, 'PPL', 'P'),
(99671, 'Battersea', 37.2247200012207, 0.649693927154289, -77.4225006103516, -1.35127755077795, 218, 53, 'PPL', 'P'),
(44618, 'Battersea on the Bay', 38.7405586242676, 0.676150302055354, -77.0055618286133, -1.34400059625737, 218, 25, 'PPL', 'P'),
(200379, 'Batterson', 45.7013893127441, 0.797639716243134, -123.757217407227, -2.15997091686254, 218, 43, 'PPL', 'P'),
(99672, 'Battery', 37.9655609130859, 0.662624040299814, -77.024169921875, -1.3443253687523, 218, 53, 'PPL', 'P'),
(112973, 'Battery Hill', 34.9527816772461, 0.61004112299869, -85.7083282470703, -1.49589252429144, 218, 2, 'PPL', 'P'),
(79684, 'Battery Marina Village', 32.3786087036133, 0.565113329092945, -80.7197189331055, -1.40882486666709, 218, 48, 'PPL', 'P'),
(44619, 'Battery Park', 38.9894409179688, 0.680494117530355, -77.107780456543, -1.34578464787161, 218, 25, 'PPL', 'P'),
(99674, 'Battery Park', 36.9963912963867, 0.645708839478122, -76.5744400024414, -1.33647610091346, 218, 53, 'PPL', 'P'),
(79685, 'Battery Point', 32.7427787780762, 0.571469295929555, -79.9491729736328, -1.39537630263636, 218, 48, 'PPL', 'P'),
(44620, 'Battery Point Farms', 39.4680595397949, 0.688847588342579, -75.9044418334961, -1.32478242688303, 218, 25, 'PPL', 'P'),
(75075, 'Battiest', 34.3933296203613, 0.600276842598997, -94.9247207641602, -1.65674891887082, 218, 42, 'PPL', 'P'),
(200380, 'Battin', 45.4588890075684, 0.793407287480725, -122.576942443848, -2.13937123267273, 218, 43, 'PPL', 'P'),
(34696, 'Battle', 37.7786102294922, 0.659361135332249, -85.0286102294922, -1.48402920689957, 218, 21, 'PPL', 'P'),
(39246, 'Battle', 30.8263893127441, 0.538021990008977, -91.0813903808594, -1.58967014944029, 218, 22, 'PPL', 'P'),
(92488, 'Battle', 31.5524997711182, 0.550695008240769, -96.8891677856445, -1.69103498737672, 218, 51, 'PPL', 'P'),
(44621, 'Battle (historical)', 38.4519386291504, 0.671112932853469, -76.5888900756836, -1.33672830226869, 218, 25, 'PPL', 'P'),
(209294, 'Battle (historical)', 41.1558303833008, 0.718304746580919, -106.981666564941, -1.86718232082896, 218, 59, 'PPL', 'P'),
(58568, 'Battle Bluff', 32.7847213745117, 0.57220133233419, -89.4166717529297, -1.56061532826363, 218, 30, 'PPL', 'P'),
(79687, 'Battle Creek', 34.7480583190918, 0.606468026343158, -83.290283203125, -1.45368967681306, 218, 48, 'PPL', 'P'),
(99675, 'Battle Creek', 38.6063919067383, 0.673808651087875, -78.5861129760742, -1.37158641777674, 218, 53, 'PPL', 'P'),
(114518, 'Battle Creek', 42.315559387207, 0.738545836129957, -95.5983276367188, -1.66850557666103, 218, 16, 'PPL', 'P'),
(129693, 'Battle Creek', 42.3211097717285, 0.738642708614608, -85.1797180175781, -1.48666653532708, 218, 27, 'PPL', 'P'),
(141244, 'Battle Creek', 41.999439239502, 0.733028498720612, -97.5980606079102, -1.70340750116901, 218, 35, 'PPL', 'P'),
(194102, 'Battle Creek', 41.0013885498047, 0.715609228083595, -107.244438171387, -1.87176855054219, 218, 7, 'PPL', 'P'),
(122196, 'Battle Ground', 40.5083312988281, 0.707003755653222, -86.841667175293, -1.51567302012995, 218, 19, 'PPL', 'P'),
(206776, 'Battle Ground', 45.7811088562012, 0.799031084754646, -122.532218933105, -2.13859066015722, 218, 56, 'PPL', 'P'),
(15110, 'Battle Ground Forks', 30.5044403076172, 0.532402919845992, -85.9497222900391, -1.50010564513594, 218, 12, 'PPL', 'P'),
(44623, 'Battle Grove', 39.2719383239746, 0.685424627393501, -76.4775009155273, -1.33478419467293, 218, 25, 'PPL', 'P'),
(7302, 'Battle Hill (historical)', 34.2777786254883, 0.598260097284507, -94.1083297729492, -1.64250020809057, 218, 4, 'PPL', 'P'),
(19096, 'Battle Hill Haven', 33.7558288574219, 0.589150355301727, -84.4461135864258, -1.47386272259625, 218, 13, 'PPL', 'P'),
(158959, 'Battle Hollow', 41.0058288574219, 0.715686726071316, -78.996940612793, -1.37875671269566, 218, 45, 'PPL', 'P'),
(134119, 'Battle Lake', 46.2805595397949, 0.807748143634693, -95.7133331298828, -1.67051280117462, 218, 28, 'PPL', 'P'),
(199825, 'Battle Mountain', 40.642219543457, 0.709340546351712, -116.933326721191, -2.04087155659506, 218, 39, 'PPL', 'P');
INSERT INTO `dsb_loc_cities` (`city_id`, `city`, `latitude`, `rad_latitude`, `longitude`, `rad_longitude`, `fk_country_id`, `fk_state_id`, `feature_code`, `feature_class`) VALUES
(19097, 'Battle Park', 32.3844413757324, 0.565215128425613, -84.9494400024414, -1.48264742576798, 218, 13, 'PPL', 'P'),
(99676, 'Battle Park', 37.1974983215332, 0.649218819215819, -76.4930572509766, -1.33505570394606, 218, 53, 'PPL', 'P'),
(206774, 'Battle Point', 47.6575012207031, 0.831780309574486, -122.583610534668, -2.13948761281236, 218, 56, 'PPL', 'P'),
(34699, 'Battle Run', 38.3497200012207, 0.669328881239225, -83.8441696166992, -1.46335681841199, 218, 21, 'PPL', 'P'),
(62744, 'Battleboro', 36.0488891601563, 0.62917180753122, -77.7494430541992, -1.35698377288761, 218, 33, 'PPL', 'P'),
(7301, 'Battlefield', 33.5933303833008, 0.586314221898847, -93.6883316040039, -1.63516985719013, 218, 4, 'PPL', 'P'),
(53362, 'Battlefield', 37.1291694641113, 0.648026255679681, -93.3666687011719, -1.62955578045419, 218, 29, 'PPL', 'P'),
(58569, 'Battlefield (historical)', 32.5463905334473, 0.568041674448568, -88.9400024414063, -1.55229587933433, 218, 30, 'PPL', 'P'),
(99677, 'Battlefield Green', 37.628059387207, 0.656733527442723, -77.3105621337891, -1.34932385580227, 218, 53, 'PPL', 'P'),
(84775, 'BAttlefield Meadows', 35.9277801513672, 0.627058056574024, -86.4894409179688, -1.50952551222766, 218, 50, 'PPL', 'P'),
(99679, 'Battlefield Park', 37.1916694641113, 0.649117086462178, -77.3827819824219, -1.35058432994621, 218, 53, 'PPL', 'P'),
(62743, 'Battleground', 36.2422218322754, 0.632546099211378, -81.9316711425781, -1.42997742309921, 218, 33, 'PPL', 'P'),
(112975, 'Battleground', 34.3044395446777, 0.598725418105971, -86.9963912963867, -1.51837346547529, 218, 2, 'PPL', 'P'),
(186389, 'Battlement Mesa', 39.4413909912109, 0.688382134363061, -108.024436950684, -1.88538209740245, 218, 7, 'PPL', 'P'),
(58570, 'Battles', 31.5016708374023, 0.54980787599215, -88.5094375610352, -1.5447811045284, 218, 30, 'PPL', 'P'),
(112977, 'Battles Wharf', 30.4941692352295, 0.532223655815116, -87.9277801513672, -1.53462926761108, 218, 2, 'PPL', 'P'),
(154204, 'Battlesburg', 40.6980590820313, 0.710315130152626, -81.3702774047852, -1.42017925397465, 218, 41, 'PPL', 'P'),
(34697, 'Battletown', 38.0638885498047, 0.664340181306261, -86.2938919067383, -1.50611253813267, 218, 21, 'PPL', 'P'),
(99680, 'Battletown', 39.1480598449707, 0.68326254006252, -77.9694366455078, -1.36082338538923, 218, 53, 'PPL', 'P'),
(197978, 'Battleview', 48.5788917541504, 0.847861608079848, -102.791938781738, -1.79405777624978, 218, 34, 'PPL', 'P'),
(84847, 'Battlewood Estates', 35.9930610656738, 0.628197423467387, -86.8841705322266, -1.51641484365159, 218, 50, 'PPL', 'P'),
(84849, 'Battlewood Forest', 36.003059387207, 0.628371927097815, -86.8708267211914, -1.51618195021426, 218, 50, 'PPL', 'P'),
(179970, 'Batto', 38.2836112976074, 0.668175066696948, -122.435829162598, -2.13690834129662, 218, 6, 'PPL', 'P'),
(195934, 'Battrick (historical)', 46.9033317565918, 0.818617569307742, -108.736671447754, -1.89781293442261, 218, 31, 'PPL', 'P'),
(62745, 'Batts Court', 35.6044387817383, 0.621414685066092, -77.478889465332, -1.35226172195879, 218, 33, 'PPL', 'P'),
(62746, 'Batts Crossroads', 35.6902809143066, 0.622912912916343, -77.0802764892578, -1.34530461308512, 218, 33, 'PPL', 'P'),
(206775, 'Batum', 47.2336082458496, 0.824381981487219, -118.809173583984, -2.073611260614, 218, 56, 'PPL', 'P'),
(84848, 'Baucom', 35.5349998474121, 0.620202747033024, -86.2222213745117, -1.50486165136866, 218, 50, 'PPL', 'P'),
(7303, 'Baucum', 34.728889465332, 0.606133466731217, -92.129997253418, -1.60797179192548, 218, 4, 'PPL', 'P'),
(134123, 'Baudette', 48.7125015258789, 0.850193538509349, -94.5997161865234, -1.65107651890701, 218, 28, 'PPL', 'P'),
(34698, 'Bauer', 36.9322204589844, 0.644588847081689, -84.4472198486328, -1.47388203051415, 218, 21, 'PPL', 'P'),
(114520, 'Bauer', 41.2038917541504, 0.719143575745266, -93.3069381713867, -1.62851328604548, 218, 16, 'PPL', 'P'),
(129695, 'Bauer', 42.9213905334473, 0.74911958434298, -85.9022216796875, -1.4992766030886, 218, 27, 'PPL', 'P'),
(202986, 'Bauer', 40.4719390869141, 0.706368591733238, -112.361389160156, -1.96107619295939, 218, 52, 'PPL', 'P'),
(44624, 'Bauers Mobile Home Park', 39.4263916015625, 0.688120345627906, -76.2819366455078, -1.33137095426183, 218, 25, 'PPL', 'P'),
(158961, 'Bauerstown', 40.4958305358887, 0.706785576180917, -79.9766693115234, -1.39585620426479, 218, 45, 'PPL', 'P'),
(75077, 'Baugh', 36.2188911437988, 0.632138901880705, -96.3172225952148, -1.68105266066278, 218, 42, 'PPL', 'P'),
(84850, 'Baugh', 35.0730590820313, 0.612140359727945, -86.8505630493164, -1.5158282824215, 218, 50, 'PPL', 'P'),
(58571, 'Baugh (historical)', 34.1961097717285, 0.596834706890069, -90.7286071777344, -1.58351292100002, 218, 30, 'PPL', 'P'),
(29166, 'Baugh City', 38.0416717529297, 0.663952425051546, -87.4124984741211, -1.52563590576793, 218, 19, 'PPL', 'P'),
(84851, 'Baugh Spring', 35.1772193908691, 0.613958300067061, -84.9869384765625, -1.48330189760587, 218, 50, 'PPL', 'P'),
(44625, 'Baugher Woods', 39.5691719055176, 0.69061233203892, -77.4369430541992, -1.35152961897513, 218, 25, 'PPL', 'P'),
(34700, 'Baughman', 36.8647193908691, 0.643410731194465, -83.8002777099609, -1.46259076012443, 218, 21, 'PPL', 'P'),
(34701, 'Baughman Heights', 37.6319389343262, 0.656801238313438, -84.7724990844727, -1.47955922416793, 218, 21, 'PPL', 'P'),
(108110, 'Baughman Settlement', 39.0113906860352, 0.680877213253163, -78.7388916015625, -1.37425290781818, 218, 58, 'PPL', 'P'),
(19098, 'Baughs Crossroads', 32.915828704834, 0.574489586921814, -85.0199966430664, -1.48387887145603, 218, 13, 'PPL', 'P'),
(19099, 'Baughville', 32.6527786254883, 0.569898496939599, -84.6705627441406, -1.4777800994017, 218, 13, 'PPL', 'P'),
(15112, 'Baum', 30.5138893127441, 0.532567836096495, -84.0802764892578, -1.46747766072473, 218, 12, 'PPL', 'P'),
(26459, 'Baum', 39.3274993896484, 0.686394350925426, -90.315559387207, -1.57630387708723, 218, 18, 'PPL', 'P'),
(75078, 'Baum', 34.2680587768555, 0.598090453923069, -96.9805603027344, -1.69263008771162, 218, 42, 'PPL', 'P'),
(191114, 'Bauman Estates Colonia', 31.6359996795654, 0.552152356568288, -106.255996704102, -1.85451699247482, 218, 51, 'PPL', 'P'),
(191115, 'Bauman Estates Number 2 Colonia', 31.636999130249, 0.552169800273428, -106.262001037598, -1.85462178786371, 218, 51, 'PPL', 'P'),
(191116, 'Bauman Estates Number 3 Colonia', 31.6350002288818, 0.552134912863148, -106.264999389648, -1.85467411897913, 218, 51, 'PPL', 'P'),
(179971, 'Baumberg', 37.6208305358887, 0.65660736018608, -122.099166870117, -2.13103247582552, 218, 6, 'PPL', 'P'),
(77830, 'Baumgardner', 39.9605598449707, 0.697443340234974, -76.2811126708984, -1.33135657319194, 218, 45, 'PPL', 'P'),
(158962, 'Baumstown', 40.2802810668945, 0.703023528246044, -75.8052825927734, -1.32305177164864, 218, 45, 'PPL', 'P'),
(62747, 'Baumtown', 35.8502807617188, 0.625705437056373, -75.6544418334961, -1.32041910375304, 218, 33, 'PPL', 'P'),
(92490, 'Bausell and Ellis Colonia', 26.431999206543, 0.461325414038704, -97.7870025634766, -1.7067051603888, 218, 51, 'PPL', 'P'),
(158963, 'Bausman', 40.024169921875, 0.6985535455144, -76.3311080932617, -1.33222915792311, 218, 45, 'PPL', 'P'),
(191117, 'Bautista', 35.7200012207031, 0.623431630117663, -102.024436950684, -1.78066234228279, 218, 51, 'PPL', 'P'),
(92491, 'Bautista Colonia', 25.923999786377, 0.452459151558584, -97.4240036010742, -1.70036963331356, 218, 51, 'PPL', 'P'),
(199827, 'Bauvard (historical)', 41.2366714477539, 0.719715689326442, -114.239723205566, -1.9938593065041, 218, 39, 'PPL', 'P'),
(7304, 'Bauxippi (historical)', 35.1386108398438, 0.613284453732243, -90.1344375610352, -1.57314270487331, 218, 4, 'PPL', 'P'),
(4, 'Bauxite', 34.0472183227539, 0.594236060877397, -85.459716796875, -1.49155343592737, 218, 2, 'PPL', 'P'),
(7305, 'Bauxite', 34.5555610656738, 0.603108315469969, -92.521110534668, -1.61479800643157, 218, 4, 'PPL', 'P'),
(7306, 'Bauxite Junction', 34.5849990844727, 0.603622105823272, -92.5155563354492, -1.61470106736789, 218, 4, 'PPL', 'P'),
(31750, 'Bavaria', 38.7972183227539, 0.677139200347128, -97.7552795410156, -1.70615148919817, 218, 20, 'PPL', 'P'),
(173082, 'Bavaria', 45.3141708374023, 0.790881478923867, -89.3638916015625, -1.55969414084257, 218, 57, 'PPL', 'P'),
(158964, 'Bavington', 40.4258308410645, 0.705563851030843, -80.3647232055664, -1.40262902239103, 218, 45, 'PPL', 'P'),
(99681, 'Bavon', 37.3333282470703, 0.65158949863918, -76.2886123657227, -1.33148746755952, 218, 53, 'PPL', 'P'),
(39248, 'Bawcomville', 32.4702796936035, 0.566713289696837, -92.1672210693359, -1.6086214700734, 218, 22, 'PPL', 'P'),
(767, 'Baxley', 34.4277801513672, 0.600878117794109, -80.3619384765625, -1.40258041970113, 218, 48, 'PPL', 'P'),
(19100, 'Baxley', 31.7780609130859, 0.554631792832665, -82.3486099243164, -1.4372543776198, 218, 13, 'PPL', 'P'),
(7308, 'Baxter', 33.5291709899902, 0.585194429239496, -91.496940612793, -1.59692286919496, 218, 4, 'PPL', 'P'),
(15111, 'Baxter', 30.5133304595947, 0.532558082269003, -82.23388671875, -1.43525207995422, 218, 12, 'PPL', 'P'),
(19101, 'Baxter', 34.7386093139648, 0.606303110092655, -84.0747222900391, -1.46738072166105, 218, 13, 'PPL', 'P'),
(34702, 'Baxter', 36.8597183227539, 0.643323446089738, -83.3308334350586, -1.45439741187275, 218, 21, 'PPL', 'P'),
(53366, 'Baxter', 36.5661087036133, 0.638198991520207, -93.491943359375, -1.63174223570914, 218, 29, 'PPL', 'P'),
(58572, 'Baxter', 32.1911087036133, 0.561840836745455, -89.1697235107422, -1.55630526835545, 218, 30, 'PPL', 'P'),
(62748, 'Baxter', 35.3172187805176, 0.616401750367208, -82.3480606079102, -1.43724479023988, 218, 33, 'PPL', 'P'),
(84852, 'Baxter', 36.1536102294922, 0.630999534987341, -85.6436080932617, -1.49476294451508, 218, 50, 'PPL', 'P'),
(92492, 'Baxter', 32.1683311462402, 0.561443293373734, -95.748893737793, -1.67113345086667, 218, 51, 'PPL', 'P'),
(108112, 'Baxter', 39.5438919067383, 0.690171112825322, -80.1425018310547, -1.39875052773749, 218, 58, 'PPL', 'P'),
(114521, 'Baxter', 41.8261108398438, 0.730003347459364, -93.1513900756836, -1.62579845963025, 218, 16, 'PPL', 'P'),
(129696, 'Baxter', 44.5038909912109, 0.776739427745274, -85.5269393920898, -1.49272669154561, 218, 27, 'PPL', 'P'),
(134124, 'Baxter', 46.3433303833008, 0.808843701528124, -94.2863922119141, -1.64560798392464, 218, 28, 'PPL', 'P'),
(158965, 'Baxter', 41.1344413757324, 0.717931437975117, -79.1500015258789, -1.38142812958512, 218, 45, 'PPL', 'P'),
(173081, 'Baxter', 45.1072196960449, 0.78726950011642, -91.9458312988281, -1.60475748964781, 218, 57, 'PPL', 'P'),
(179972, 'Baxter', 39.2130584716797, 0.684396980107866, -120.779998779297, -2.10800864925346, 218, 6, 'PPL', 'P'),
(186390, 'Baxter', 38.2758293151855, 0.668039245481354, -104.491111755371, -1.82371393920058, 218, 7, 'PPL', 'P'),
(195935, 'Baxter', 47.1505584716797, 0.822932489484916, -109.438888549805, -1.91006893491721, 218, 31, 'PPL', 'P'),
(199163, 'Baxter', 41.8594398498535, 0.730585048420465, -103.47110748291, -1.80591150626172, 218, 35, 'PPL', 'P'),
(179973, 'Baxter (historical)', 35.0430603027344, 0.611616782257636, -116.288330078125, -2.02961424150924, 218, 6, 'PPL', 'P'),
(147049, 'Baxter Estates', 40.8347206115723, 0.712700323803929, -73.6958312988281, -1.28623490115884, 218, 40, 'PPL', 'P'),
(79686, 'Baxter Forks', 33.9738883972168, 0.592956212236532, -79.0177764892578, -1.37912036734251, 218, 48, 'PPL', 'P'),
(31751, 'Baxter Junction', 37.0286102294922, 0.646271165942292, -94.7461090087891, -1.65363155565683, 218, 20, 'PPL', 'P'),
(31752, 'Baxter Springs', 37.023609161377, 0.646183880837564, -94.7352828979492, -1.65344260437749, 218, 20, 'PPL', 'P'),
(6, 'Baxters', 31.7574996948242, 0.554272931875777, -85.5811080932617, -1.49367211373258, 218, 2, 'PPL', 'P'),
(58573, 'Baxterville', 31.083890914917, 0.542516240796054, -89.5902786254883, -1.56364533979387, 218, 30, 'PPL', 'P'),
(186391, 'Baxterville', 37.6741714477539, 0.657538334724145, -106.657218933105, -1.86151964140312, 218, 7, 'PPL', 'P'),
(7311, 'Bay', 35.7422218322754, 0.623819452951406, -90.5622177124023, -1.58060887698935, 218, 4, 'PPL', 'P'),
(19102, 'Bay', 31.1916694641113, 0.544397331342518, -83.9266662597656, -1.46479665645534, 218, 13, 'PPL', 'P'),
(53367, 'Bay', 38.5083312988281, 0.672097170613335, -91.5583267211914, -1.59799425890149, 218, 29, 'PPL', 'P'),
(202987, 'Bay', 40.6536102294922, 0.709539351327086, -111.836936950684, -1.95192277513474, 218, 52, 'PPL', 'P'),
(154207, 'Bay (historical)', 40.5541687011719, 0.707803769244682, -84.2780609130859, -1.47092965012969, 218, 41, 'PPL', 'P'),
(19103, 'Bay Branch', 32.0863914489746, 0.560013175868361, -81.975830078125, -1.43074814191868, 218, 13, 'PPL', 'P'),
(206781, 'Bay Center', 46.6316719055176, 0.81387621046102, -123.95361328125, -2.16339867150158, 218, 56, 'PPL', 'P'),
(206777, 'Bay Center Junction', 46.5991706848145, 0.813308957148833, -123.916938781738, -2.16275858073358, 218, 56, 'PPL', 'P'),
(15113, 'Bay City', 29.7563896179199, 0.51934697233896, -85.0205612182617, -1.48388872515207, 218, 12, 'PPL', 'P'),
(26460, 'Bay City', 37.2488899230957, 0.650115771870957, -88.4966735839844, -1.54455833110322, 218, 18, 'PPL', 'P'),
(44626, 'Bay City', 38.9669418334961, 0.680101434427623, -76.3427810668945, -1.3324328897465, 218, 25, 'PPL', 'P'),
(62749, 'Bay City', 35.1791687011719, 0.613992321949986, -76.7708282470703, -1.33990372239444, 218, 33, 'PPL', 'P'),
(112627, 'Bay City', 28.9825000762939, 0.505840051790837, -95.9691696166992, -1.67497799021631, 218, 51, 'PPL', 'P'),
(129697, 'Bay City', 43.5944404602051, 0.760866521595211, -83.8888931274414, -1.4641373909275, 218, 27, 'PPL', 'P'),
(173083, 'Bay City', 44.5855598449707, 0.778164818139711, -92.4502792358398, -1.61356176705355, 218, 57, 'PPL', 'P'),
(200381, 'Bay City', 45.5227813720703, 0.794522419608169, -123.888061523438, -2.16225457749729, 218, 43, 'PPL', 'P'),
(206778, 'Bay City', 46.8647193908691, 0.817943656393898, -124.058059692383, -2.16522160526774, 218, 56, 'PPL', 'P'),
(13326, 'Bay City Mobile Home Park', 38.6316719055176, 0.674249870301474, -75.133056640625, -1.3113192154663, 218, 10, 'PPL', 'P'),
(13327, 'Bay Colony', 38.586109161377, 0.673454650399976, -75.1444396972656, -1.31151788728362, 218, 10, 'PPL', 'P'),
(44627, 'Bay Colony', 38.3908309936523, 0.67004640341592, -75.1561126708984, -1.31172161910701, 218, 25, 'PPL', 'P'),
(99683, 'Bay Colony', 36.878059387207, 0.643643558052765, -76.0063934326172, -1.32656181796536, 218, 53, 'PPL', 'P'),
(147042, 'Bay Colony', 40.6294403076172, 0.709117506610418, -73.595832824707, -1.28448959853846, 218, 40, 'PPL', 'P'),
(44628, 'Bay Country', 38.7594413757324, 0.676479868240251, -76.6152801513672, -1.33718889597922, 218, 25, 'PPL', 'P'),
(44629, 'Bay Forest', 38.186939239502, 0.666487820988329, -76.3611068725586, -1.33275273539342, 218, 25, 'PPL', 'P'),
(79688, 'Bay Forest', 33.8633308410645, 0.591026618868715, -78.6619415283203, -1.37290987568045, 218, 48, 'PPL', 'P'),
(13328, 'Bay Harbor', 38.7052803039551, 0.675534579211328, -75.0986099243164, -1.31071800685021, 218, 10, 'PPL', 'P'),
(15116, 'Bay Harbor', 26.1505603790283, 0.45641337985562, -80.1180572509766, -1.39832388933086, 218, 12, 'PPL', 'P'),
(92493, 'Bay Harbor', 29.1272201538086, 0.508365893637209, -95.0683288574219, -1.65925535293075, 218, 51, 'PPL', 'P'),
(144794, 'Bay Harbor Estates', 40.0208282470703, 0.698495222286528, -74.1333312988281, -1.29387071663632, 218, 37, 'PPL', 'P'),
(15117, 'Bay Harbor Islands', 25.8872203826904, 0.451817229867334, -80.1313934326172, -1.39855664961013, 218, 12, 'PPL', 'P'),
(44630, 'Bay Harbour', 38.2611083984375, 0.667782317015189, -75.2558288574219, -1.31346199487937, 218, 25, 'PPL', 'P'),
(144795, 'Bay Head', 40.0716705322266, 0.699382587561742, -74.0547180175781, -1.29249865604271, 218, 37, 'PPL', 'P'),
(144796, 'Bay Head Junction', 40.0777816772461, 0.6994892471634, -74.04638671875, -1.29235324744719, 218, 37, 'PPL', 'P'),
(15131, 'Bay Heights', 25.7455596923828, 0.449344784400819, -80.2219390869141, -1.40013696940098, 218, 12, 'PPL', 'P'),
(15119, 'Bay Hill', 28.7099990844727, 0.501084012268605, -82.2399978637695, -1.43535873955588, 218, 12, 'PPL', 'P'),
(44631, 'Bay Hills', 39.0486106872559, 0.681526824822061, -76.482780456543, -1.33487634004665, 218, 25, 'PPL', 'P'),
(195936, 'Bay Horse', 45.0433311462402, 0.786154434568004, -105.566390991211, -1.84248110224431, 218, 31, 'PPL', 'P'),
(99682, 'Bay Island', 36.9088897705078, 0.644181649751016, -76.0491714477539, -1.32730843517697, 218, 53, 'PPL', 'P'),
(15122, 'Bay Lake', 28.3883304595947, 0.495469835664123, -81.5661087036133, -1.42359715491766, 218, 12, 'PPL', 'P'),
(134127, 'Bay Lake', 46.4094390869141, 0.809997516070401, -93.8736114501953, -1.63840360054376, 218, 28, 'PPL', 'P'),
(19104, 'Bay Meadows', 31.4597206115723, 0.54907570642946, -82.9166717529297, -1.447168926884, 218, 13, 'PPL', 'P'),
(129700, 'Bay Mills', 46.4372215270996, 0.810482411125877, -84.5838928222656, -1.47626742390253, 218, 27, 'PPL', 'P'),
(10, 'Bay Minette', 30.8827800750732, 0.53900619447933, -87.773063659668, -1.53192895542379, 218, 2, 'PPL', 'P'),
(92494, 'Bay Oaks', 29.6416702270508, 0.517344741252411, -95.0166702270508, -1.6583537397437, 218, 51, 'PPL', 'P'),
(129702, 'Bay Park', 43.6547203063965, 0.761918603383846, -83.5891723632813, -1.45890627675631, 218, 27, 'PPL', 'P'),
(147043, 'Bay Park', 40.6330604553223, 0.70918069010728, -73.6708297729492, -1.28579854221423, 218, 40, 'PPL', 'P'),
(179974, 'Bay Park', 32.7816696166992, 0.572148069112389, -117.205558776855, -2.04562290229587, 218, 6, 'PPL', 'P'),
(200382, 'Bay Park', 43.3491706848145, 0.756585756459017, -124.200561523438, -2.16770873140977, 218, 43, 'PPL', 'P'),
(15123, 'Bay Pines', 27.8138904571533, 0.485443966266356, -82.7783279418945, -1.44475437188168, 218, 12, 'PPL', 'P'),
(79689, 'Bay Pines', 32.1716690063477, 0.561501550022579, -80.7750015258789, -1.40978972993003, 218, 48, 'PPL', 'P'),
(7312, 'Bay Plantation', 34.9655609130859, 0.610264162739984, -91.3838882446289, -1.59494973314332, 218, 4, 'PPL', 'P'),
(15124, 'Bay Point', 24.6263904571533, 0.429811596359037, -81.5924987792969, -1.42405774862818, 218, 12, 'PPL', 'P'),
(126839, 'Bay Point', 43.7563896179199, 0.763693067618166, -69.7752838134766, -1.21780843905867, 218, 26, 'PPL', 'P'),
(147044, 'Bay Point', 41.0033302307129, 0.715643116808466, -72.315559387207, -1.26214461172826, 218, 40, 'PPL', 'P'),
(179975, 'Bay Point', 38.0291709899902, 0.663734245579241, -121.960563659668, -2.12861339344935, 218, 6, 'PPL', 'P'),
(179976, 'Bay Point (historical)', 38.0458297729492, 0.664024996191251, -122.028610229492, -2.12980103013747, 218, 6, 'PPL', 'P'),
(147045, 'Bay Pond', 44.4313888549805, 0.775474026753323, -74.4122161865234, -1.29873817616065, 218, 40, 'PPL', 'P'),
(129703, 'Bay Port', 43.8494415283203, 0.765317129829924, -83.3733291625977, -1.45513910223634, 218, 27, 'PPL', 'P'),
(15125, 'Bay Ridge', 28.7563896179199, 0.501893679819017, -81.5599975585938, -1.423490495316, 218, 12, 'PPL', 'P'),
(44633, 'Bay Ridge', 39.6952781677246, 0.692813301521816, -76.3369369506836, -1.33233089067675, 218, 25, 'PPL', 'P'),
(99684, 'Bay Ridge', 37.211109161377, 0.649456373185054, -76.0105590820313, -1.32663452226312, 218, 53, 'PPL', 'P'),
(147046, 'Bay Ridge', 40.6338882446289, 0.709195137756193, -74.0149993896484, -1.29180543521096, 218, 40, 'PPL', 'P'),
(44634, 'Bay Ridge Junction', 38.9786109924316, 0.680305099671987, -76.5047225952148, -1.3352593026114, 218, 25, 'PPL', 'P'),
(58574, 'Bay Saint Louis', 30.3086109161377, 0.528985052192498, -89.3300018310547, -1.55910265276447, 218, 30, 'PPL', 'P'),
(173085, 'Bay Settlement', 44.5530586242676, 0.777597564827524, -87.8905563354492, -1.53397958946315, 218, 57, 'PPL', 'P'),
(70505, 'Bay Shore', 39.9508285522461, 0.697273497136454, -74.1136093139648, -1.29352650306542, 218, 37, 'PPL', 'P'),
(129704, 'Bay Shore', 45.3583297729492, 0.791652197743336, -85.0972213745117, -1.48522669728372, 218, 27, 'PPL', 'P'),
(147047, 'Bay Shore', 40.7249984741211, 0.71078531124308, -73.2458267211914, -1.27838083963003, 218, 40, 'PPL', 'P'),
(44635, 'Bay Shore Acres', 38.3427810668945, 0.669207773988654, -75.103889465332, -1.31081015222393, 218, 25, 'PPL', 'P'),
(13329, 'Bay Shore Hills', 38.6949996948242, 0.675355148732884, -75.1449966430664, -1.31152760782159, 218, 10, 'PPL', 'P'),
(13330, 'Bay Shore Mobile Home Park', 38.5761108398438, 0.673280146769548, -75.0844421386719, -1.310470732343, 218, 10, 'PPL', 'P'),
(92495, 'Bay Shore Park', 29.6583309173584, 0.517635525153934, -95.0041732788086, -1.65813562685043, 218, 51, 'PPL', 'P'),
(44636, 'Bay Shore Park (historical)', 39.2075004577637, 0.68429997446516, -76.4274978637695, -1.33391147678371, 218, 25, 'PPL', 'P'),
(79690, 'Bay Shores', 34.7236099243164, 0.6060413213575, -82.8647232055664, -1.44626225369088, 218, 48, 'PPL', 'P'),
(147048, 'Bay Shores', 42.8622207641602, 0.748086877051275, -76.2744369506836, -1.33124005989425, 218, 40, 'PPL', 'P'),
(179977, 'Bay Shores', 33.6147193908691, 0.586687530504649, -117.910003662109, -2.05791778494238, 218, 6, 'PPL', 'P'),
(70507, 'Bay Side', 39.6686096191406, 0.692347847542298, -74.2136077880859, -1.29527180568581, 218, 37, 'PPL', 'P'),
(169274, 'Bay Spring', 41.7480583190918, 0.728641073982761, -71.3472213745117, -1.2452439251345, 218, 47, 'PPL', 'P'),
(16, 'Bay Springs', 34.1758308410645, 0.596480772781198, -85.7155609130859, -1.49601875812711, 218, 2, 'PPL', 'P'),
(15126, 'Bay Springs', 30.7733306884766, 0.537095942318929, -87.4791717529297, -1.52679957400624, 218, 12, 'PPL', 'P'),
(58575, 'Bay Springs', 31.978889465332, 0.558136912301373, -89.2872161865234, -1.55835590239481, 218, 30, 'PPL', 'P'),
(79692, 'Bay Springs', 33.899169921875, 0.591652128829748, -80.4097213745117, -1.40341438859649, 218, 48, 'PPL', 'P'),
(124192, 'Bay State', 42.3222198486328, 0.738662083111539, -72.6638870239258, -1.26822407586469, 218, 23, 'PPL', 'P'),
(44637, 'Bay Terrace', 38.5502815246582, 0.672829340176025, -76.5622177124023, -1.33626278171014, 218, 25, 'PPL', 'P'),
(18, 'Bay View', 33.5586090087891, 0.5857082195928, -86.9736099243164, -1.51797585552454, 218, 2, 'PPL', 'P'),
(15127, 'Bay View', 30.4594402313232, 0.531617520351014, -86.1772232055664, -1.5040762851632, 218, 12, 'PPL', 'P'),
(44638, 'Bay View', 39.6433296203613, 0.691906628328699, -75.961669921875, -1.32578124544986, 218, 25, 'PPL', 'P'),
(84853, 'Bay View', 35.7611083984375, 0.624149085715331, -84.6425018310547, -1.47729034407723, 218, 50, 'PPL', 'P'),
(124193, 'Bay View', 42.6699981689453, 0.744731959868047, -70.665283203125, -1.23334185874878, 218, 23, 'PPL', 'P'),
(126840, 'Bay View', 43.4877815246582, 0.759004971993245, -70.3874969482422, -1.22849357398429, 218, 26, 'PPL', 'P'),
(129705, 'Bay View', 45.3855590820313, 0.79212743883986, -84.9302825927734, -1.48231306589312, 218, 27, 'PPL', 'P'),
(147052, 'Bay View', 41.0411109924316, 0.71630251549437, -72.4211120605469, -1.26398685341232, 218, 40, 'PPL', 'P'),
(154209, 'Bay View', 41.4324989318848, 0.723133523690423, -82.960563659668, -1.44793498517156, 218, 41, 'PPL', 'P'),
(173086, 'Bay View', 44.6327781677246, 0.778988933339036, -87.7441711425781, -1.53142468587138, 218, 57, 'PPL', 'P'),
(206780, 'Bay View', 48.4838905334473, 0.846203523985165, -122.476387023926, -2.13761620951436, 218, 56, 'PPL', 'P'),
(99685, 'Bay View Beach', 36.9388885498047, 0.644705227221325, -76.2358322143555, -1.33056628013846, 218, 53, 'PPL', 'P'),
(13331, 'Bay View Estates', 38.4561080932617, 0.671185703730256, -75.129997253418, -1.31126581908644, 218, 10, 'PPL', 'P'),
(44639, 'Bay View Estates', 39.4249992370605, 0.688096044282959, -75.9991683959961, -1.32643571728775, 218, 25, 'PPL', 'P'),
(118740, 'Bay View Garden', 40.8088912963867, 0.712249517210405, -89.5205612182617, -1.56242854149181, 218, 18, 'PPL', 'P'),
(13332, 'Bay View Heights', 39.0547218322754, 0.681633484423718, -75.4019393920898, -1.31601210478118, 218, 10, 'PPL', 'P'),
(44641, 'Bay View Mobile Home Park', 39.4447212219238, 0.688440257853852, -76.2844390869141, -1.33141463010371, 218, 25, 'PPL', 'P'),
(13333, 'Bay View Park', 38.5074996948242, 0.672082656385394, -75.0597229003906, -1.3100393002464, 218, 10, 'PPL', 'P'),
(7313, 'Bay Village', 35.4497184753418, 0.618714306299779, -90.6758270263672, -1.58259173357897, 218, 4, 'PPL', 'P'),
(124194, 'Bay Village', 42.3505592346191, 0.739156698704994, -71.0702819824219, -1.24041042091406, 218, 23, 'PPL', 'P'),
(154210, 'Bay Village', 41.4847183227539, 0.724044923994475, -81.9222183227539, -1.42981244026968, 218, 41, 'PPL', 'P'),
(13334, 'Bay Vista', 38.6972198486328, 0.675393897726744, -75.0980606079102, -1.31070841947029, 218, 10, 'PPL', 'P'),
(147053, 'Bay Wood', 40.75, 0.711221670187689, -73.2916717529297, -1.27918098637955, 218, 40, 'PPL', 'P'),
(360, 'Bayard', 38.5002784729004, 0.671956622286806, -75.1319427490234, -1.31129977439034, 218, 10, 'PPL', 'P'),
(15128, 'Bayard', 30.1433296203613, 0.526100349389238, -81.5130615234375, -1.42267130696469, 218, 12, 'PPL', 'P'),
(31754, 'Bayard', 37.9936103820801, 0.663113595887198, -95.1627807617188, -1.66090384964551, 218, 20, 'PPL', 'P'),
(108111, 'Bayard', 39.2727813720703, 0.685439341358523, -79.3647232055664, -1.38517572987108, 218, 58, 'PPL', 'P'),
(114522, 'Bayard', 41.8519401550293, 0.730454154052887, -94.5580596923828, -1.65034947592942, 218, 16, 'PPL', 'P'),
(154213, 'Bayard', 40.750560760498, 0.711231457304695, -81.0650024414063, -1.41485120073978, 218, 41, 'PPL', 'P'),
(188119, 'Bayard', 32.7616691589355, 0.571798995272507, -108.129997253418, -1.88722447224457, 218, 38, 'PPL', 'P'),
(199164, 'Bayard', 41.7550010681152, 0.72876224781236, -103.323608398438, -1.803337161594, 218, 35, 'PPL', 'P'),
(19105, 'Bayard (historical)', 32.6736106872559, 0.570262085007422, -84.9069366455078, -1.48190560224634, 218, 13, 'PPL', 'P'),
(199828, 'Bayard (historical)', 41.6980590820313, 0.72776842267257, -115.509170532227, -2.01601534203496, 218, 39, 'PPL', 'P'),
(44642, 'Bayberry', 39.0613899230957, 0.681749864563355, -76.4736099243164, -1.33471628406513, 218, 25, 'PPL', 'P'),
(62751, 'Bayberry Bluffs', 36.1708297729492, 0.631300072716357, -75.753059387207, -1.32214030476556, 218, 33, 'PPL', 'P'),
(13335, 'Bayberry Dunes', 38.5713882446289, 0.67319772193381, -75.0605621337891, -1.3100539476324, 218, 10, 'PPL', 'P'),
(147055, 'Bayberry Dunes', 40.6897201538086, 0.710169588399054, -72.9897232055664, -1.27391099005644, 218, 40, 'PPL', 'P'),
(147056, 'Bayberry Park', 40.9466705322266, 0.714654218516692, -73.7744369506836, -1.28760682859439, 218, 40, 'PPL', 'P'),
(62752, 'Bayboro', 35.1427803039551, 0.61335722460903, -76.7705612182617, -1.33989906186254, 218, 33, 'PPL', 'P'),
(79693, 'Bayboro', 34.0094413757324, 0.593576728770521, -79.0224990844727, -1.37920279217825, 218, 48, 'PPL', 'P'),
(19106, 'Bayboro (historical)', 31.1658306121826, 0.543946358301427, -83.5680618286133, -1.4585378284195, 218, 13, 'PPL', 'P'),
(147057, 'Baychester', 40.8611106872559, 0.713160917514458, -73.841667175293, -1.28878021737068, 218, 40, 'PPL', 'P'),
(154214, 'Bayer Trailer Court', 41.5394401550293, 0.725000000140405, -83.581672668457, -1.45877538238873, 218, 41, 'PPL', 'P'),
(122197, 'Bayfield', 41.2747192382813, 0.720379748544254, -85.7069396972656, -1.49586828952552, 218, 19, 'PPL', 'P'),
(173087, 'Bayfield', 46.8108291625977, 0.817003094475909, -90.8180618286133, -1.58507419918908, 218, 57, 'PPL', 'P'),
(186392, 'Bayfield', 37.2255592346191, 0.649708574540284, -107.597503662109, -1.87793070583046, 218, 7, 'PPL', 'P'),
(53368, 'Bayfield (historical)', 39.7819404602051, 0.694325843862927, -94.595832824707, -1.65100874145727, 218, 29, 'PPL', 'P'),
(99686, 'Bayford', 37.4777793884277, 0.654110646664131, -75.9330596923828, -1.32528190274547, 218, 53, 'PPL', 'P'),
(79694, 'Bayfront', 32.7419395446777, 0.57145464854356, -79.9636077880859, -1.39562823767548, 218, 48, 'PPL', 'P'),
(193365, 'Bayha (historical)', 40.7297210693359, 0.710867736078818, -122.321113586426, -2.1349061767891, 218, 6, 'PPL', 'P'),
(15129, 'Bayhead', 30.3072204589844, 0.528960784137064, -85.5819396972656, -1.49368662796052, 218, 12, 'PPL', 'P'),
(44644, 'Bayhead', 39.042781829834, 0.68142509206842, -76.4244384765625, -1.33385808040385, 218, 25, 'PPL', 'P'),
(194562, 'Bayhorse', 44.3977813720703, 0.774887465523233, -114.310829162598, -1.99510033957208, 218, 17, 'PPL', 'P'),
(99687, 'Baylake Beach', 36.9111099243164, 0.644220398744876, -76.1080627441406, -1.32833628219968, 218, 53, 'PPL', 'P'),
(99688, 'Baylake Pines', 36.9086112976074, 0.644176789482026, -76.1155624389648, -1.32846717656726, 218, 53, 'PPL', 'P'),
(58576, 'Bayland', 32.8872184753418, 0.573990244217424, -90.658332824707, -1.58228640215999, 218, 30, 'PPL', 'P'),
(26461, 'Bayle 