<?php
/**
 * User_Settings class.
 *
 * @author Arkadiusz Bisaga <abisaga@telaxus.com> and Paul Bukowski <pbukowski@telaxus.com>
 * @copyright Copyright &copy; 2008, Janusz Tylek
 * @license MIT
 * @version 1.0
 * @package epesi-base
 * @subpackage user-settings
 */
defined("_VALID_ACCESS") || die('Direct access forbidden');

class Base_User_SettingsCommon extends ModuleCommon {
	private static $admin_variables;
	private static $user_variables;

	public static function menu(){
		if (Base_AclCommon::check_permission('Advanced User Settings'))
			return array(_M('My settings')=>array('__weight__'=>10,'__submenu__'=>1,_M('Control panel')=>array()));
		return array();
	}

	public static function body_access() {
		return Acl::is_user();
	}

	public static function admin_access_levels() {
		return false;
	}

	public static function admin_caption() {
		return array('label'=>__('Default user settings'), 'section'=>__('User Management'));
	}

	/**
	 * Returns default setting.
	 *
	 * @param string module name
	 * @param string variable name
	 * @return mixed variable value
	 */
	public static function get_default($module,$name){
		$module = str_replace('/','_',$module);
		static $variables;
		if ($variables === null) {
			$variables = isset($_SESSION['default_user_settings']) ? $_SESSION['default_user_settings'] : null;
		}
		if (!isset($variables[$module])) {
			if (class_exists($module . 'Common') && method_exists($module . 'Common', 'user_settings')) {
				$settings = call_user_func(array($module . 'Common', 'user_settings'), true);
				if (is_array($settings)) {
					foreach ($settings as $v) {
						if (!is_array($v)) {
							continue;
						}
						foreach ($v as $v2) {
							$max_len = 64;
							if(isset($v2['name']) && strlen($v2['name'])>$max_len) throw new Exception("Variable name too long. Max length is $max_len.");
							if ($v2['type'] == 'group') {
								foreach ($v2['elems'] as $e) {
									if ($e['type'] != 'static' && $e['type'] != 'header') {
										$variables[$module][$e['name']] = $e['default'];
									}
								}
							} elseif ($v2['type'] != 'static' && $v2['type'] != 'header') {
								$variables[$module][$v2['name']] = $v2['default'];
							}
						}
					}
				}
			}
			$_SESSION['default_user_settings'] = $variables;
		}
		if(isset($variables[$module][$name]))
			return $variables[$module][$name];
		return null;
	}

	/**
	 * Returns admin setting.
	 *
	 * @param string module name
	 * @param string variable name
	 * @return mixed user value
	 */
	public static function get_admin($module,$name){
		$module = str_replace('/','_',$module);
		if (!isset(self::$admin_variables)) {
			self::$admin_variables = array();
			$ret = DB::Execute('SELECT module,variable,value FROM base_user_settings_admin_defaults');
			while($row = $ret->FetchRow()) {
				$val = @unserialize($row['value']);
				if($val!==false || $val===serialize(false))
					self::$admin_variables[$row['module']][$row['variable']] = $val;
			}
		}
		if (isset(self::$admin_variables[$module][$name]))
			return self::$admin_variables[$module][$name];
		return self::$admin_variables[$module][$name] = self::get_default($module,$name);
	}

	/**
	 * Returns user setting.
	 * If user is logged in, returns user prefered setting,
	 * otherwise returns default value.
	 *
	 * @param string module name
	 * @param string variable name
	 * @return mixed user value
	 */
	public static function get($module,$name,$user=null){
		if (!Acl::is_user()) return null;
		if(!is_numeric($user) && $user!==null) return null;
		if ($user===null) $user = Acl::get_user();
		$module = str_replace('/','_',$module);
		if (!isset(self::$user_variables[$user])) {
			self::$user_variables[$user] = array();
			$ret = DB::Execute('SELECT variable, value, module FROM base_user_settings WHERE user_login_id=%d',array($user));
			while($row = $ret->FetchRow()) {
				$val = @unserialize($row['value']);
				if($val!==false || $val===serialize(false))
					self::$user_variables[$user][$row['module']][$row['variable']] = $val;
			}
		}
		if (isset(self::$user_variables[$user][$module][$name]))
			return self::$user_variables[$user][$module][$name];
		return self::$user_variables[$user][$module][$name] = self::get_admin($module,$name);
	}

	public static function get_users_settings($module,$name){
		$module = str_replace('/','_',$module);
		$vals = array();
		$ret = DB::Execute('SELECT user_login_id, value FROM base_user_settings WHERE module=%s AND variable=%s', array($module, $name));
		while($row = $ret->FetchRow()) {
			$vals[$row['user_login_id']] = @unserialize($row['value']);
		}
		$default = self::get_admin($module,$name);
		$ret = DB::Execute('SELECT id FROM user_login WHERE active=1');
		while($row = $ret->FetchRow()) {
			if (!isset($vals[$row['id']])) $vals[$row['id']] = $default;
		}
		return $vals;
	}

	/**
	 * Sets user setting to given value for currently logged in user.
	 * Returns false if no user is logged in.
	 *
	 * @param string module name
	 * @param string variable name
	 * @param mixed value
	 * @return bool true on success, false otherwise
	 */
	public static function save($module,$name,$value,$user=null){
		if ($user === null) $user = Acl::get_user();
		if ($user === null) return false;
		$module = str_replace('/','_',$module);
		$def = self::get_admin($module,$name);
		if ($value==$def) {
			DB::Execute('DELETE FROM base_user_settings WHERE user_login_id=%d AND module=%s AND variable=%s',array($user,$module,$name));
			if(isset(self::$user_variables[$user])) unset(self::$user_variables[$user][$module][$name]);
		} else {
			if(isset(self::$user_variables[$user])) self::$user_variables[$user][$module][$name]=$value;
			$value = serialize($value);
			$val = DB::GetOne('SELECT value FROM base_user_settings WHERE user_login_id=%d AND module=%s AND variable=%s',array($user,$module,$name));
			if ($val === false || $val===null)
				DB::Execute('INSERT INTO base_user_settings VALUES (%d,%s,%s,%s)',array($user,$module,$name,$value));
			else
				DB::Execute('UPDATE base_user_settings SET value=%s WHERE user_login_id=%d AND module=%s AND variable=%s',array($value,$user,$module,$name));
		}
		return true;
	}

	/**
	 * Sets admin setting to given value for currently logged in user.
	 * Returns false on permission denied.
	 *
	 * @param string module name
	 * @param string variable name
	 * @param mixed value
	 * @return bool true on success, false otherwise
	 */
	public static function save_admin($module,$name,$value){
		//if ($value === null) $value = 0;
		$module = str_replace('/','_',$module);
		$def = self::get_default($module,$name);
		if (!isset($def)) return false;
		if ($value==$def) {
			DB::Execute('DELETE FROM base_user_settings_admin_defaults WHERE module=%s AND variable=%s',array($module,$name));
			if(isset(self::$admin_variables)) unset(self::$admin_variables[$module][$name]);
		} else {
			if(isset(self::$admin_variables)) self::$admin_variables[$module][$name]=$value;
			$value = serialize($value);
			$val = DB::GetOne('SELECT value FROM base_user_settings_admin_defaults WHERE module=%s AND variable=%s',array($module,$name));
			if ($val === false || $val===null)
				DB::Execute('INSERT INTO base_user_settings_admin_defaults VALUES (%s,%s,%s)',array($module,$name,$value));
			else
				DB::Execute('UPDATE base_user_settings_admin_defaults SET value=%s WHERE module=%s AND variable=%s',array($value,$module,$name));
		}
		return true;
	}
}

?>
