-- 
-- Database: `eggblog`
-- 

-- --------------------------------------------------------

-- 
-- Table structure for table `eb_albums`
-- 

CREATE TABLE `eb_albums` (
  `album_id` int(11) NOT NULL auto_increment,
  `album_title` varchar(250) NOT NULL default '',
  PRIMARY KEY  (`album_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `eb_albums`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `eb_articles`
-- 

CREATE TABLE `eb_articles` (
  `article_id` int(11) NOT NULL auto_increment,
  `article_flag` int(11) NOT NULL default '0',
  `author_id` int(11) NOT NULL default '0',
  `article_date` int(11) NOT NULL default '0',
  `article_title` varchar(250) NOT NULL default '',
  `article_body` longtext NOT NULL,
  `article_comments` int(11) NOT NULL default '0',
  `tag_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`article_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `eb_articles`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `eb_comments`
-- 

CREATE TABLE `eb_comments` (
  `comment_id` int(11) NOT NULL auto_increment,
  `author_id` int(11) NOT NULL default '0',
  `article_id` int(11) NOT NULL default '0',
  `comment_ip` varchar(20) NOT NULL default '',
  `comment_date` int(11) NOT NULL default '0',
  `comment_body` longtext NOT NULL,
  PRIMARY KEY  (`comment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `eb_comments`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `eb_photos`
-- 

CREATE TABLE `eb_photos` (
  `photo_id` int(11) NOT NULL auto_increment,
  `album_id` int(11) NOT NULL default '0',
  `photo_description` longtext NOT NULL,
  PRIMARY KEY  (`photo_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `eb_photos`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `eb_posts`
-- 

CREATE TABLE `eb_posts` (
  `post_id` int(11) NOT NULL auto_increment,
  `topic_id` int(11) NOT NULL default '0',
  `post_date` int(11) NOT NULL default '0',
  `post_ip` varchar(20) NOT NULL default '',
  `author_id` int(11) NOT NULL default '0',
  `post_body` longtext NOT NULL,
  PRIMARY KEY  (`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `eb_posts`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `eb_tags`
-- 

CREATE TABLE `eb_tags` (
  `tag_id` int(11) NOT NULL auto_increment,
  `tag_name` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`tag_id`),
  UNIQUE KEY `tag_name` (`tag_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `eb_tags`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `eb_tags_links`
-- 

CREATE TABLE `eb_tags_links` (
  `tag_id` int(11) NOT NULL default '0',
  `article_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`tag_id`,`article_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `eb_tags_links`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `eb_topics`
-- 

CREATE TABLE `eb_topics` (
  `topic_id` int(11) NOT NULL auto_increment,
  `topic_title` varchar(250) NOT NULL default '',
  PRIMARY KEY  (`topic_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `eb_topics`
-- 


-- --------------------------------------------------------

-- 
-- Table structure for table `eb_users`
-- 

CREATE TABLE `eb_users` (
  `user_id` int(11) NOT NULL auto_increment,
  `user_flag` int(11) NOT NULL default '0',
  `user_name` varchar(250) NOT NULL default '',
  `user_email` varchar(250) NOT NULL default '',
  `user_password` varchar(250) NOT NULL default '',
  PRIMARY KEY  (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- 
-- Dumping data for table `eb_users`
-- 

INSERT INTO `eb_users` VALUES (1, 2, '[[admin_username]]', '[[admin_email]]', '[[admin_pass]]');
