import { __ } from '@wordpress/i18n';
import { LabelControl } from './label';
import { useState, useRef, useEffect } from '@wordpress/element';
import { ColorPicker } from '@wordpress/components';

export const TextShadowControl = (props) => {
    const { prop, label, value, setAttributes } = props;
    const { name } = prop['c'];
	
	var values = !pagelayer_empty(value) ? value : ['', '', '', ''];
	
	// Do we have a val ?
	if(pagelayer_is_string(value)){
		values = value.split(',');
	}
	
    const [isColorPickerVisible, setIsColorPickerVisible] = useState(false);
    const [isTextShadowVisible, setIsTextShadowVisible] = useState(false);
    const colorPreviewRef = useRef(null);
    const colorPickerRef = useRef(null);
    const textShadowRef = useRef(null);

    const handleInputChange = (index, newValue) => {
        const newValues = [...values];
        newValues[index] = newValue;
        setAttributes({ [name]: newValues });
    };

    const onChange = (color = '') => {
        handleInputChange(3, color);
    }

    const handleRemoveColor = (e) => {
        handleInputChange(3, '');
        setIsColorPickerVisible(false);

    };
    var blank = 'pagelayer-blank-preview';
    useEffect(() => {
        const handleDocumentClick = (e) => {
            // ColorPicker Handler
            if (
                colorPickerRef.current &&
                !colorPickerRef.current.contains(e.target) &&
                colorPreviewRef.current &&
                !colorPreviewRef.current.contains(e.target)
            ) {
                setIsColorPickerVisible(false);
            }
            // text Shodow Modal Handler
            if (
                textShadowRef.current &&
                !textShadowRef.current.contains(e.target)
            ) {
                setIsTextShadowVisible(false);
            }
        };

        document.addEventListener('click', handleDocumentClick);
        return () => {
            document.removeEventListener('click', handleDocumentClick);
        };
    }, []);

    return (
        <div className="components-base-control pagelayer-base-control">
            <LabelControl {...props} />
            <div className="pagelayer-prop-holder" ref={textShadowRef}>
                <span
                    className="pagelayer-prop-edit"
                    onClick={() => setIsTextShadowVisible(!isTextShadowVisible)}
                >
                    <i className="pli pli-pencil"></i>
                </span>
                {isTextShadowVisible &&
                    <div className="pagelayer-elp-shadow-div">
                        <div className="pagelayer-elp-prop-grp pagelayer-elp-shadow-horizontal">
                            <label className="pagelayer-elp-label">{ __('Horizontal') }</label>
                            <input
                                className="pagelayer-elp-shadow-input"
                                type="number"
                                max="100"
                                min="-100"
                                step="1"
                                name="horizontal"
                                value={values[0]}
                                onChange={(e) => handleInputChange(0, parseFloat(e.target.value))}
                            />
                        </div>
                        <div className="pagelayer-elp-prop-grp pagelayer-elp-shadow-vertical">
                            <label className="pagelayer-elp-label">{ __('Vertical') }</label>
                            <input
                                className="pagelayer-elp-shadow-input"
                                type="number"
                                max="100"
                                min="-100"
                                step="1"
                                name="vertical"
                                value={values[1]}
                                onChange={(e) => handleInputChange(1, parseFloat(e.target.value))}
                            />
                        </div>
                        <div className="pagelayer-elp-prop-grp pagelayer-elp-shadow-blur">
                            <label className="pagelayer-elp-label">{ __('Blur') }</label>
                            <input
                                className="pagelayer-elp-shadow-input"
                                type="number"
                                max="100"
                                min="-100"
                                step="1"
                                name="blur"
                                value={values[2]}
                                onChange={(e) => handleInputChange(2, parseFloat(e.target.value))}
                            />
                        </div>
                        <div className="pagelayer-elp-prop-grp pagelayer-elp-shadow-color">
                            <label className="pagelayer-elp-label">{ __('Color') }</label>
                            <div
                                className="pagelayer-elp-color-div"
                                ref={colorPickerRef}
                            >
                                <div
                                    className={`pagelayer-elp-color-preview ${values[3] === '' ? blank : ''}`}
                                    onClick={() => setIsColorPickerVisible(!isColorPickerVisible)}
                                    style={{ backgroundColor: values[3] }}

                                ></div>
                                <span className="pagelayer-elp-remove-color" onClick={() => { handleRemoveColor() }}>
                                    <i className="pli pli-cross"></i>
                                </span>

                            </div>
                        </div>
                        {isColorPickerVisible && (
                            <div ref={colorPickerRef} className="test">
                                <ColorPicker
                                    color={values[3]}
                                    onChangeComplete={(val) => {
                                        if (val.rgb) {
                                            onChange(
                                                val.rgb.a != 1
                                                    ? "rgba(" +
                                                    val.rgb.r +
                                                    "," +
                                                    val.rgb.g +
                                                    "," +
                                                    val.rgb.b +
                                                    "," +
                                                    val.rgb.a +
                                                    ")"
                                                    : val.hex
                                            );
                                        }
                                    }}
                                    disableAlpha={false}
                                />
                            </div>
                        )}
                    </div>
                }
            </div>
        </div>
    )
}