import { useState } from '@wordpress/element';
import { LabelControl } from './label';

export const SpinnerControl = (props) =>{
		
	const { prop, label, value, setAttributes } = props;
	const { name } = prop['c'];
	const { min, max, step } = prop;
	
	const handleInputChange = (e) => {
		let newValue = parseFloat(e.target.value);

		if (!isNaN(max) && newValue > max) {
			newValue = max;
		}
		setAttributes({[name]: newValue});
	};
	
	return (
		<div className="components-base-control pagelayer-base-control">
			<LabelControl {...props}/>
			<div className="pagelayer-elp-spinner-div">
				<input
					type="number"
					className="pagelayer-elp-spinner"
					name={name}
					min={min}
					max={max}
					step={step}
					value={value}
					onChange={handleInputChange}
				/>
			</div>
		</div>
	);	
}