import { useEffect, useRef, useState} from '@wordpress/element';

export const RenderFacebookButton = (props) => {
	const { _props, pl_props, tag, data } = props;
	const { attributes } = _props;
	const { id, atts } = data;
	
	const facbookRef = useRef(null)
	const [url, setUrl] = useState(null);
	
	useEffect(() => {
		
		if(atts['link_type'] == 'current') {
			atts['custom-url'] = pagelayer_post_permalink;			
			setUrl(atts['custom-url']);
		}
		
		const timer = setTimeout(() => {
           	pagelayer_fb_apps(jQuery(facbookRef.current));
        }, 300);

        return () => {
            clearTimeout(timer);
        };
	}, [ attributes ]);

	return (
		<>
			<div className="pagelayer-fb-btn-container" pagelayer-facebook-load="1" ref={facbookRef}>
				<span className='pagelayer-app-details' pagelayer-app-id={atts['fb-app-id'] ? atts['fb-app-id'] : ''} ></span>
				<div id="fb-root"></div>
				<div
					className="fb-like pagelayer-fb-btn-details"
					id="fb-like-btn"
					data-href={ atts['custom-url'] ? atts['custom-url'] : url}
					data-layout={ atts?.layout }
					data-action={ atts?.btn_action }
					data-show-faces={ atts?.peoples_faces }
					data-size={ atts?.btn_size }
					data-share={ atts?.share_btn } 
				></div>
			</div>
		</>
	)
}