/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { SelectControl } from '@wordpress/components';
import PropTypes from 'prop-types';

/**
 * A pre-configured SelectControl for product orderby settings.
 *
 * @param {Object} props Incoming props for the component.
 * @param {string} props.value
 * @param {function(any):any} props.setAttributes Setter for block attributes.
 */
const ProductOrderbyControl = ( { value, setAttributes } ) => {
	return (
		<SelectControl
			label={ __( 'Order products by', 'kkart' ) }
			value={ value }
			options={ [
				{
					label: __(
						'Newness - newest first',
						'kkart'
					),
					value: 'date',
				},
				{
					label: __(
						'Price - low to high',
						'kkart'
					),
					value: 'price_asc',
				},
				{
					label: __(
						'Price - high to low',
						'kkart'
					),
					value: 'price_desc',
				},
				{
					label: __(
						'Rating - highest first',
						'kkart'
					),
					value: 'rating',
				},
				{
					label: __(
						'Sales - most first',
						'kkart'
					),
					value: 'popularity',
				},
				{
					label: __(
						'Title - alphabetical',
						'kkart'
					),
					value: 'title',
				},
				{
					label: __( 'Menu Order', 'kkart' ),
					value: 'menu_order',
				},
			] }
			onChange={ ( orderby ) => setAttributes( { orderby } ) }
		/>
	);
};

ProductOrderbyControl.propTypes = {
	/**
	 * Callback to update the order setting.
	 */
	setAttributes: PropTypes.func.isRequired,
	/**
	 * The selected order setting.
	 */
	value: PropTypes.string.isRequired,
};

export default ProductOrderbyControl;
