/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { FormStep } from '@kkart/base-components/cart-checkout';
import { useCheckoutContext } from '@kkart/base-context';
import PropTypes from 'prop-types';

const BillingFieldsStep = ( { children } ) => {
	const { isProcessing: checkoutIsProcessing } = useCheckoutContext();

	return (
		<FormStep
			id="billing-fields"
			disabled={ checkoutIsProcessing }
			className="kkart-block-checkout__billing-fields"
			title={ __( 'Billing address', 'kkart' ) }
			description={ __(
				'Enter the address that matches your card or payment method.',
				'kkart'
			) }
		>
			{ children }
		</FormStep>
	);
};

BillingFieldsStep.propTypes = {
	children: PropTypes.node.isRequired,
};

export default BillingFieldsStep;
