/** @typedef { import('@kkart/type-defs/address-fields').AddressField } AddressField */

/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';

/**
 * Default address field properties.
 *
 * @property {AddressField} first_name Customer first name.
 * @property {AddressField} last_name  Customer last name.
 * @property {AddressField} company    Company name.
 * @property {AddressField} address_1  Street address.
 * @property {AddressField} address_2  Second line of address.
 * @property {AddressField} country    Country code.
 * @property {AddressField} city       City name.
 * @property {AddressField} state      State name or code.
 * @property {AddressField} postcode   Postal code.
 */
const AddressFields = {
	first_name: {
		label: __( 'First name', 'kkart' ),
		optionalLabel: __(
			'First name (optional)',
			'kkart'
		),
		autocomplete: 'given-name',
		autocapitalize: 'sentences',
		required: true,
		hidden: false,
		index: 1,
	},
	last_name: {
		label: __( 'Last name', 'kkart' ),
		optionalLabel: __(
			'Last name (optional)',
			'kkart'
		),
		autocomplete: 'family-name',
		autocapitalize: 'sentences',
		required: true,
		hidden: false,
		index: 2,
	},
	company: {
		label: __( 'Company', 'kkart' ),
		optionalLabel: __(
			'Company (optional)',
			'kkart'
		),
		autocomplete: 'organization',
		autocapitalize: 'sentences',
		required: false,
		hidden: false,
		index: 3,
	},
	address_1: {
		label: __( 'Address', 'kkart' ),
		optionalLabel: __(
			'Address (optional)',
			'kkart'
		),
		autocomplete: 'address-line1',
		autocapitalize: 'sentences',
		required: true,
		hidden: false,
		index: 4,
	},
	address_2: {
		label: __( 'Apartment, suite, etc.', 'kkart' ),
		optionalLabel: __(
			'Apartment, suite, etc. (optional)',
			'kkart'
		),
		autocomplete: 'address-line2',
		autocapitalize: 'sentences',
		required: false,
		hidden: false,
		index: 5,
	},
	country: {
		label: __( 'Country/Region', 'kkart' ),
		optionalLabel: __(
			'Country/Region (optional)',
			'kkart'
		),
		autocomplete: 'country',
		required: true,
		hidden: false,
		index: 6,
	},
	city: {
		label: __( 'City', 'kkart' ),
		optionalLabel: __( 'City (optional)', 'kkart' ),
		autocomplete: 'address-level2',
		autocapitalize: 'sentences',
		required: true,
		hidden: false,
		index: 7,
	},
	state: {
		label: __( 'State/County', 'kkart' ),
		optionalLabel: __(
			'State/County (optional)',
			'kkart'
		),
		autocomplete: 'address-level1',
		autocapitalize: 'sentences',
		required: true,
		hidden: false,
		index: 8,
	},
	postcode: {
		label: __( 'Postal code', 'kkart' ),
		optionalLabel: __(
			'Postal code (optional)',
			'kkart'
		),
		autocomplete: 'postal-code',
		autocapitalize: 'characters',
		required: true,
		hidden: false,
		index: 9,
	},
};

export default AddressFields;
