/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { Icon, grid } from '@kkart/icons';
import { isExperimentalBuild } from '@kkart/block-settings';
/**
 * Internal dependencies
 */
import save from '../save';

/**
 * Holds default config for this collection of blocks.
 */
export default {
	category: 'kkart-product-elements',
	keywords: [ __( 'Kkart', 'kkart' ) ],
	icon: {
		src: <Icon srcElement={ grid } />,
		foreground: '#96588a',
	},
	supports: {
		html: false,
	},
	parent: isExperimentalBuild()
		? null
		: [ '@kkart/all-products', '@kkart/single-product' ],
	save,
	deprecated: [
		{
			save() {},
		},
	],
};
