<?php
/**
 * Kkart Homescreen.
 * NOTE: DO NOT edit this file in Kkart core, this is generated from kkart-admin.
 */

namespace Automattic\Kkart\Admin\Features;

use Automattic\Kkart\Admin\Loader;

/**
 * Contains backend logic for the homescreen feature.
 */
class Homescreen {
	/**
	 * Menu slug.
	 */
	const MENU_SLUG = 'kkart-admin';

	/**
	 * Class instance.
	 *
	 * @var Homescreen instance
	 */
	protected static $instance = null;

	/**
	 * Get class instance.
	 */
	public static function get_instance() {
		if ( ! self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Hook into Kkart.
	 */
	public function __construct() {
		add_filter( 'kkart_admin_get_user_data_fields', array( $this, 'add_user_data_fields' ) );
		add_action( 'admin_menu', array( $this, 'register_page' ) );
		// priority is 20 to run after https://github.com/kkart/kkart/blob/a55ae325306fc2179149ba9b97e66f32f84fdd9c/includes/admin/class-kkart-admin-menus.php#L165.
		add_action( 'admin_head', array( $this, 'update_link_structure' ), 20 );
		add_filter( 'kkart_admin_plugins_whitelist', array( $this, 'get_homescreen_allowed_plugins' ) );
		add_filter( 'kkart_admin_preload_options', array( $this, 'preload_options' ) );
		add_filter( 'kkart_shared_settings', array( $this, 'component_settings' ), 20 );
	}

	/**
	 * Adds fields so that we can store performance indicators, row settings, and chart type settings for users.
	 *
	 * @param array $user_data_fields User data fields.
	 * @return array
	 */
	public function add_user_data_fields( $user_data_fields ) {
		return array_merge(
			$user_data_fields,
			array(
				'homepage_layout',
				'homepage_stats',
			)
		);
	}

	/**
	 * Registers home page.
	 */
	public function register_page() {
		kkart_admin_register_page(
			array(
				'id'           => 'kkart-home',
				'title'        => __( 'Home', 'kkart' ),
				'parent'       => 'kkart',
				'path'         => self::MENU_SLUG,
				'is_top_level' => true,
				'order'        => 0,
			)
		);
	}

	/**
	 * Update the Kkart menu structure to make our main dashboard/handler
	 * the top level link for 'Kkart'.
	 */
	public function update_link_structure() {
		global $submenu;
		// User does not have capabilites to see the submenu.
		if ( ! current_user_can( 'manage_kkart' ) || empty( $submenu['kkart'] ) ) {
			return;
		}

		$kkart_admin_key = null;
		foreach ( $submenu['kkart'] as $submenu_key => $submenu_item ) {
			if ( self::MENU_SLUG === $submenu_item[2] ) {
				$kkart_admin_key = $submenu_key;
				break;
			}
		}

		if ( ! $kkart_admin_key ) {
			return;
		}

		$menu = $submenu['kkart'][ $kkart_admin_key ];

		// Move menu item to top of array.
		unset( $submenu['kkart'][ $kkart_admin_key ] );
		array_unshift( $submenu['kkart'], $menu );
	}

	/**
	 * Gets an array of plugins that can be installed & activated via the home screen.
	 *
	 * @param array $plugins Array of plugin slugs to be allowed.
	 *
	 * @return array
	 */
	public static function get_homescreen_allowed_plugins( $plugins ) {
		$homescreen_plugins = array(
			'jetpack' => 'jetpack/jetpack.php',
		);

		return array_merge( $plugins, $homescreen_plugins );
	}

	/**
	 * Preload options to prime state of the application.
	 *
	 * @param array $options Array of options to preload.
	 * @return array
	 */
	public function preload_options( $options ) {
		$options[] = 'kkart_default_homepage_layout';

		return $options;
	}

	/**
	 * Add data to the shared component settings.
	 *
	 * @param array $settings Shared component settings.
	 */
	public function component_settings( $settings ) {
		$allowed_statuses = Loader::get_order_statuses( kkart_get_order_statuses() );

		// Remove the Draft Order status (from the Checkout Block).
		unset( $allowed_statuses['checkout-draft'] );

		$status_counts          = array_map( 'kkart_orders_count', array_keys( $allowed_statuses ) );
		$settings['orderCount'] = array_sum( $status_counts );

		return $settings;
	}
}
