<?php
/**
 * Twenty Twelve support.
 *
 * @class   KKART_Twenty_Twelve
 * @since   3.3.0
 * @package Kkart\Classes
 */

defined( 'ABSPATH' ) || exit;

/**
 * KKART_Twenty_Twelve class.
 */
class KKART_Twenty_Twelve {

	/**
	 * Theme init.
	 */
	public static function init() {
		// Remove default wrappers.
		remove_action( 'kkart_before_main_content', 'kkart_output_content_wrapper' );
		remove_action( 'kkart_after_main_content', 'kkart_output_content_wrapper_end' );

		// Add custom wrappers.
		add_action( 'kkart_before_main_content', array( __CLASS__, 'output_content_wrapper' ) );
		add_action( 'kkart_after_main_content', array( __CLASS__, 'output_content_wrapper_end' ) );

		// Declare theme support for features.
		add_theme_support( 'kkart-product-gallery-zoom' );
		add_theme_support( 'kkart-product-gallery-lightbox' );
		add_theme_support( 'kkart-product-gallery-slider' );
		add_theme_support(
			'kkart',
			array(
				'thumbnail_image_width' => 200,
				'single_image_width'    => 300,
			)
		);
	}

	/**
	 * Open wrappers.
	 */
	public static function output_content_wrapper() {
		echo '<div id="primary" class="site-content"><div id="content" role="main" class="twentytwelve">';
	}

	/**
	 * Close wrappers.
	 */
	public static function output_content_wrapper_end() {
		echo '</div></div>';
	}
}

KKART_Twenty_Twelve::init();
