<?php
/**
 * Themes administration panel.
 *
 * @package WordPress
 * @subpackage Administration
 */

/** WordPress Administration Bootstrap */
require_once( dirname( __FILE__ ) . '/admin.php' );

$title = __('Compare Plans');

require_once( ABSPATH . 'site-admin/admin-header.php' );

$plans = fetch_plan();

// Update the license
if(!empty($_REQUEST['license_key'])){
	
	$license_key = trim($_REQUEST['license_key']);
	$resp = wp_remote_get(SITEPAD_API.'license_enduser.php?eu_license='.$license_key.'&siteurl='.rawurlencode($sitepad['serving_url']));
	
	if(is_array($resp)){
		$json = json_decode($resp['body'], true);
		//r_print($json);
		
		if(empty($json['license'])){
			$error['lic_invalid'] = __('The license key is invalid');
		}else{
			update_option('sitepad_license', $json);
			sitepad_license_check();
		
			// Mark as saved
			$GLOBALS['saved'] = true;
		}
		
	}else{
		$error['resp_invalid'] = __('The response was malformed<br>'.var_export($resp, true));		
	}
}

foreach($plans as $pk => $pv){
	
	if($pv['slug'] == 'free'){
		$plans[$pk]['button_txt'] = 'Free';
		continue;
	}
	
	if(empty($sitepad['license'])){
		$plans[$pk]['button_txt'] = 'Purchase';
		continue;
	}
	
	if($pv['slug'] == $sitepad['license']['plan']){
		$plans[$pk]['button_txt'] = 'Renew';
		$matched_plan = 1;
	}else{
		if(!empty($matched_plan)){
			$plans[$pk]['button_txt'] = 'Upgrade';
		}else{
			$plans[$pk]['button_txt'] = 'Purchase';
			$plans[$pk]['button_disable'] = 1;
		}
	}
}

//r_print($plans);

echo '
<div class="wrap">
	<div class="bg">
		<h1 style="padding:0px"><!--This is to fix promo--></h1>
		<div class="row p-3 mb-4">
			<div class="col-sm-6">
				<h1><span class="dashicons-before sme-dash-header dashicons-cart"></span>Plans<br /></h1>
			</div>
			<div class="col-sm-6">
				<div class="float-right">
				<a href="javascript:toggle_license_form()" class="btn btn-info">Enter License</a> &nbsp; 
				Contact us : <a href="mailto:sales@sitepad.com">sales@sitepad.com</a>
				</div>
			</div>			
		</div>
		
		<div class="row" id="enter_license_form" style="display:none;">
			<div class="col-sm-12 mb-5">
				<div class="text-center"><h4>'.__('Enter SitePad License Key').'</h4></div>
				
				<div class="text-center">'.__('If you have already purchased the license you can enter the license key below and start using SitePad Premium').'</div><br />
				<form action="" method="post" name="submit_license" id="submit_license">
				<div class="row">
					<div class="col-sm-4 offset-sm-3">
						<input type="text" name="license_key" class="form-control" id="license_key" size="30" value="'.POSTval('license_key').'" placeholder="SITEP-xxxxx-xxxxx-xxxxx-xxxxx" />
					</div>
					<div class="col-sm-1">
						<button type="submit" class="btn btn-primary">'.__('Submit').'</button>
					</div>
				</div>
				</form>
			</div>
		</div>';
		
		// Saved
		if(!empty($GLOBALS['saved'])){			
			echo '<div class="notice notice-success is-dismissible">
				<p>'.__('The license has been saved').'</p>
			</div>';			
		}
	
		// Any errors ?
		if(!empty($error)){
			pagelayer_report_error($error);echo '<br />';
		}
		
		// Expired license ?
		if(!empty($sitepad['license']) && empty($sitepad['license']['status'])){
			$msg = !empty($sitepad['license']['status_msg']) ? $sitepad['license']['status_msg'] : __('There is no active license for this website. Please buy a license from the <a href="'.SITEPAD_BUY.'">Client Center</a>.');
			echo '<div id="message" class="error"><p>'.$msg.'</p></div>';
		}
		//r_print($sitepad['license']);
		
		// Show plan details
		if(!empty($sitepad['license'])){
		
			echo '
			<center><div id="license_details" align="center" class="license_details py-2"><h5><span style="border-bottom: 1px solid #000;">Current plan details</span></h5>
			<b>Plan Name</b> : '.$plans[$sitepad['license']['plan']]['name'];
			
			if(!empty($sitepad['license']['expires'])){
				echo '<br /><b>Expires</b> : '.makedate($sitepad['license']['expires'], 'jS F Y');
			}
			
			echo '<br /><b>License Key</b> : '.$sitepad['license']['license'].'
			</div></center><br />';
			
		}

		echo '
		<div class="tab">
			<div class="plan_highlight"><span class="current_plan'.(empty($sitepad['license']['plan']) ? '">Current Plan' : '">').'</span>
			</div>
			<div class="plan_highlight"><span class="current_plan'.($sitepad['license']['plan'] == 'personal' ? '">Current Plan' : '">').'</span>
			</div>
			<div class="plan_highlight"><span class="current_plan'.($sitepad['license']['plan'] == 'professional' ? '">Current Plan' : ' most_popular">Most Popular').'</span>
			</div>
			<div class="plan_highlight"><span class="current_plan'.($sitepad['license']['plan'] == 'business' ? '">Current Plan' : '">').'</span>
			</div>
		</div>
		<div class="tab">';
		
		foreach($plans as $slug => $plan){
			
			echo '<div class="pricing_tab" id="'.$plan['slug'].'">
				<ul>
					<li class="plans_heading" id="plan"><span class="head_span">'.$plan['name'].'</span></li>
					<li class="plans_price" id="price"><span data-price="'.$plan['price'].'">'.(empty($plan['price']) ? 'No Cost' : '$'.$plan['price'].'/Year').'</span></li>
					<li>'.(empty($plan['themes']) ? 'Unlimited' : $plan['themes']).' Themes</li>
					<li>'.(empty($plan['sites']) ? 'Unlimited' : $plan['sites']).' Site'.($plan['sites'] != 1 ? 's' : '').' *</li>
					<li>'.(empty($plan['pages']) ? 'Unlimited' : $plan['pages']).' Pages</li>
					<li>'.(empty($plan['blogs']) ? 'Unlimited' : $plan['blogs']).' Blog Posts</li>';
					//<li>Download Sites '.(!empty($plan['download_sites']) ? '<span class="dashicons dashicons-yes" style="color:#00B249;"></span>' : '<span class="dashicons dashicons-no" style="color:#D41B27;"></span>').'</li>
			echo '	<li><button class="buy_button" id="pay_now" onClick="start_buy(\''.$plan['slug'].'\');" '.(!empty($plan['button_disable']) ? 'style="background-color:#999999;"' : '').'>'.__($plan['button_txt']).'</button></li>
				</ul>
			</div>';
			
		}
		
		echo '
		</div>
		<p>* If your license expires, your site will continue to work, but you will not be able to edit your site</p>
		<br/><br/>
	</div>
</div>';

?>

<style>

.wrap{
font-size: 14px;
}

.plans_history th{
color: #FFFFFF !important;
}
.plans_heading{
	background: #00B249;
	color: #FFFFFF !important;
	font-size: 24px !important;
}
.plans_price{
	background: #33C16D;
	color: #FFFFFF !important;
	font-size: 20px !important;
	line-height: 45%;
}
.head_span{
	border-bottom: 1px solid #fff;
}
.most_popular{
	background: #FA9300 !important;
}
.current_plan{
	background: #49A9F5;
	font-size: 14px;
	padding: 5px 20px;
	text-align: center;
	color: #FFFFFF;
	margin: 0 auto;
	display: table;
}

.buy_button{
	font-size: 16px;
	padding: 5px 30px;
	line-height: 25px;
	background: #FA9300;
	color: #FFFFFF;
	border: 0px;
	cursor: pointer;
}
.buy_button:hover{
	background: #D77E00;
}

.dashicons, .dashicons-before::before {
	width: 30px;
}
.pricing_tab ul{
	border: 1px solid rgba(0, 0, 0, 0.14);
	box-shadow: 0 2px 2px 0 rgba(0, 0, 0, 0.14);
	margin-top: -1px;
}
.pricing_tab{
	padding: 10px;
	width: 25%;
	padding-top: 0px;
}
.pricing_tab li {
	border-bottom: 1px solid rgba(0, 0, 0, 0.05);
	color: #737373;
	margin-bottom: 0;
	padding: 20px;
	text-align: center;
	list-style-type: none;
	font-size: 16px;
}
.plan_highlight{
	width:25%;
}

.tab{
	display: inline-flex;
	width: 100%;
}
.modalDialog {
	position: fixed;
	font-family: Arial, Helvetica, sans-serif;
	top: 40px;
	right: 0;
	bottom: 0;
	left: 0;
	background: rgba(0,0,0,0.8);
	z-index: 10001;
	display: none;
}
.modal-header {
    border-bottom: 1px solid #e5e5e5;
    padding: 0 15px;
}
.modal-header .close {
    margin-top: -2px;
}
button.close {
    background: rgba(0, 0, 0, 0) none repeat scroll 0 0;
    border: 0 none;
    cursor: pointer;
    padding: 0;
}
.close {
    color: #000;
    float: right;
    font-size: 21px;
    font-weight: 700;
    line-height: 1;
    opacity: 0.2;
    text-shadow: 0 1px 0 #fff;
}
.modal-body {
    padding: 15px;
    position: relative;
}
.modalDialog > div {
	width: 300px;
	left: calc(50% - 125px);
    background-clip: padding-box;
    background-color: #fff;
    border: 1px solid rgba(0, 0, 0, 0.2);
    border-radius: 6px;
    box-shadow: 0 3px 9px rgba(0, 0, 0, 0.5);
    outline: 0 none;
    position: relative;
}
.modal-footer {
    border-top: 1px solid #e5e5e5;
    padding: 10px 20px;
    text-align: right;
}
.btn-default {
    background-color: #fff;
    border-color: #ccc;
    color: #333;
}
.btn {
    -moz-user-select: none;
    background-image: none;
    border: 1px solid transparent;
    border-radius: 4px;
    cursor: pointer;
    display: inline-block;
    font-size: 14px;
    font-weight: 400;
    line-height: 1.42857;
    margin-bottom: 0;
    padding: 6px 12px;
    text-align: center;
    touch-action: manipulation;
    vertical-align: middle;
    white-space: nowrap;
}

.license_details{
background-color:#F5F5F5;
border: 1px solid #E5E5E5;
width:30%;
}

</style>

<center><div id="display_theme" style="height:auto;"></div></center>
	
<script>
	
function toggle_license_form(){
	$("#enter_license_form").toggle(300);
}

function start_buy(plan_name){
	var cur_url = window.location;
	window.open(<?php echo '"'.$sitepad['buy_link'].'&license='.$sitepad['license']['license'].'&plan="'; ?>+plan_name+"&return_cp_url="+encodeURI(cur_url));
}

</script>

<?php require( ABSPATH . 'site-admin/admin-footer.php' );