<?php
/**
 * WordPress core upgrade functionality.
 *
 * @package WordPress
 * @subpackage Administration
 * @since 2.7.0
 */

/**
 * Stores files to be deleted.
 *
 * @since 2.7.0
 * @global array $_old_files
 * @var array
 * @name $_old_files
 */
global $_old_files;

$_old_files = array(
	// 2.0
	'site-admin/import-b2.php',
	'site-admin/import-blogger.php',
	'site-admin/import-greymatter.php',
	'site-admin/import-livejournal.php',
	'site-admin/import-mt.php',
	'site-admin/import-rss.php',
	'site-admin/import-textpattern.php',
	'site-admin/quicktags.js',
	'wp-images/fade-butt.png',
	'wp-images/get-firefox.png',
	'wp-images/header-shadow.png',
	'wp-images/smilies',
	'wp-images/wp-small.png',
	'wp-images/wpminilogo.png',
	'wp.php',
	// 2.0.8
	'site-inc/js/tinymce/plugins/inlinepopups/readme.txt',
	// 2.1
	'site-admin/edit-form-ajax-cat.php',
	'site-admin/execute-pings.php',
	'site-admin/inline-uploading.php',
	'site-admin/link-categories.php',
	'site-admin/list-manipulation.js',
	'site-admin/list-manipulation.php',
	'site-inc/comment-functions.php',
	'site-inc/feed-functions.php',
	'site-inc/functions-compat.php',
	'site-inc/functions-formatting.php',
	'site-inc/functions-post.php',
	'site-inc/js/dbx-key.js',
	'site-inc/js/tinymce/plugins/autosave/langs/cs.js',
	'site-inc/js/tinymce/plugins/autosave/langs/sv.js',
	'site-inc/links.php',
	'site-inc/pluggable-functions.php',
	'site-inc/template-functions-author.php',
	'site-inc/template-functions-category.php',
	'site-inc/template-functions-general.php',
	'site-inc/template-functions-links.php',
	'site-inc/template-functions-post.php',
	'site-inc/wp-l10n.php',
	// 2.2
	'site-admin/cat-js.php',
	'site-admin/import/b2.php',
	'site-inc/js/autosave-js.php',
	'site-inc/js/list-manipulation-js.php',
	'site-inc/js/wp-ajax-js.php',
	// 2.3
	'site-admin/admin-db.php',
	'site-admin/cat.js',
	'site-admin/categories.js',
	'site-admin/custom-fields.js',
	'site-admin/dbx-admin-key.js',
	'site-admin/edit-comments.js',
	'site-admin/install-rtl.css',
	'site-admin/install.css',
	'site-admin/upgrade-schema.php',
	'site-admin/upload-functions.php',
	'site-admin/upload-rtl.css',
	'site-admin/upload.css',
	'site-admin/upload.js',
	'site-admin/users.js',
	'site-admin/widgets-rtl.css',
	'site-admin/widgets.css',
	'site-admin/xfn.js',
	'site-inc/js/tinymce/license.html',
	// 2.5
	'site-admin/css/upload.css',
	'site-admin/images/box-bg-left.gif',
	'site-admin/images/box-bg-right.gif',
	'site-admin/images/box-bg.gif',
	'site-admin/images/box-butt-left.gif',
	'site-admin/images/box-butt-right.gif',
	'site-admin/images/box-butt.gif',
	'site-admin/images/box-head-left.gif',
	'site-admin/images/box-head-right.gif',
	'site-admin/images/box-head.gif',
	'site-admin/images/heading-bg.gif',
	'site-admin/images/login-bkg-bottom.gif',
	'site-admin/images/login-bkg-tile.gif',
	'site-admin/images/notice.gif',
	'site-admin/images/toggle.gif',
	'site-admin/includes/upload.php',
	'site-admin/js/dbx-admin-key.js',
	'site-admin/js/link-cat.js',
	'site-admin/profile-update.php',
	'site-admin/templates.php',
	'site-inc/images/wlw/WpComments.png',
	'site-inc/images/wlw/WpIcon.png',
	'site-inc/images/wlw/WpWatermark.png',
	'site-inc/js/dbx.js',
	'site-inc/js/fat.js',
	'site-inc/js/list-manipulation.js',
	'site-inc/js/tinymce/langs/en.js',
	'site-inc/js/tinymce/plugins/autosave/editor_plugin_src.js',
	'site-inc/js/tinymce/plugins/autosave/langs',
	'site-inc/js/tinymce/plugins/directionality/images',
	'site-inc/js/tinymce/plugins/directionality/langs',
	'site-inc/js/tinymce/plugins/inlinepopups/css',
	'site-inc/js/tinymce/plugins/inlinepopups/images',
	'site-inc/js/tinymce/plugins/inlinepopups/jscripts',
	'site-inc/js/tinymce/plugins/paste/images',
	'site-inc/js/tinymce/plugins/paste/jscripts',
	'site-inc/js/tinymce/plugins/paste/langs',
	'site-inc/js/tinymce/plugins/spellchecker/classes/HttpClient.class.php',
	'site-inc/js/tinymce/plugins/spellchecker/classes/TinyGoogleSpell.class.php',
	'site-inc/js/tinymce/plugins/spellchecker/classes/TinyPspell.class.php',
	'site-inc/js/tinymce/plugins/spellchecker/classes/TinyPspellShell.class.php',
	'site-inc/js/tinymce/plugins/spellchecker/css/spellchecker.css',
	'site-inc/js/tinymce/plugins/spellchecker/images',
	'site-inc/js/tinymce/plugins/spellchecker/langs',
	'site-inc/js/tinymce/plugins/spellchecker/tinyspell.php',
	'site-inc/js/tinymce/plugins/wordpress/images',
	'site-inc/js/tinymce/plugins/wordpress/langs',
	'site-inc/js/tinymce/plugins/wordpress/wordpress.css',
	'site-inc/js/tinymce/plugins/wphelp',
	'site-inc/js/tinymce/themes/advanced/css',
	'site-inc/js/tinymce/themes/advanced/images',
	'site-inc/js/tinymce/themes/advanced/jscripts',
	'site-inc/js/tinymce/themes/advanced/langs',
	// 2.5.1
	'site-inc/js/tinymce/tiny_mce_gzip.php',
	// 2.6
	'site-admin/bookmarklet.php',
	'site-inc/js/jquery/jquery.dimensions.min.js',
	'site-inc/js/tinymce/plugins/wordpress/popups.css',
	'site-inc/js/wp-ajax.js',
	// 2.7
	'site-admin/css/press-this-ie-rtl.css',
	'site-admin/css/press-this-ie.css',
	'site-admin/css/upload-rtl.css',
	'site-admin/edit-form.php',
	'site-admin/images/comment-pill.gif',
	'site-admin/images/comment-stalk-classic.gif',
	'site-admin/images/comment-stalk-fresh.gif',
	'site-admin/images/comment-stalk-rtl.gif',
	'site-admin/images/del.png',
	'site-admin/images/gear.png',
	'site-admin/images/media-button-gallery.gif',
	'site-admin/images/media-buttons.gif',
	'site-admin/images/postbox-bg.gif',
	'site-admin/images/tab.png',
	'site-admin/images/tail.gif',
	'site-admin/js/forms.js',
	'site-admin/js/upload.js',
	'site-admin/link-import.php',
	'site-inc/images/audio.png',
	'site-inc/images/css.png',
	'site-inc/images/default.png',
	'site-inc/images/doc.png',
	'site-inc/images/exe.png',
	'site-inc/images/html.png',
	'site-inc/images/js.png',
	'site-inc/images/pdf.png',
	'site-inc/images/swf.png',
	'site-inc/images/tar.png',
	'site-inc/images/text.png',
	'site-inc/images/video.png',
	'site-inc/images/zip.png',
	'site-inc/js/tinymce/tiny_mce_config.php',
	'site-inc/js/tinymce/tiny_mce_ext.js',
	// 2.8
	'site-admin/js/users.js',
	'site-inc/js/swfupload/plugins/swfupload.documentready.js',
	'site-inc/js/swfupload/plugins/swfupload.graceful_degradation.js',
	'site-inc/js/swfupload/swfupload_f9.swf',
	'site-inc/js/tinymce/plugins/autosave',
	'site-inc/js/tinymce/plugins/paste/css',
	'site-inc/js/tinymce/utils/mclayer.js',
	'site-inc/js/tinymce/wordpress.css',
	// 2.8.5
	'site-admin/import/btt.php',
	'site-admin/import/jkw.php',
	// 2.9
	'site-admin/js/page.dev.js',
	'site-admin/js/page.js',
	'site-admin/js/set-post-thumbnail-handler.dev.js',
	'site-admin/js/set-post-thumbnail-handler.js',
	'site-admin/js/slug.dev.js',
	'site-admin/js/slug.js',
	'site-inc/gettext.php',
	'site-inc/js/tinymce/plugins/wordpress/js',
	'site-inc/streams.php',
	// MU
	'README.txt',
	'htaccess.dist',
	'index-install.php',
	'site-admin/css/mu-rtl.css',
	'site-admin/css/mu.css',
	'site-admin/images/site-admin.png',
	'site-admin/includes/mu.php',
	'site-admin/wpmu-admin.php',
	'site-admin/wpmu-blogs.php',
	'site-admin/wpmu-edit.php',
	'site-admin/wpmu-options.php',
	'site-admin/wpmu-themes.php',
	'site-admin/wpmu-upgrade-site.php',
	'site-admin/wpmu-users.php',
	'site-inc/images/wordpress-mu.png',
	'site-inc/wpmu-default-filters.php',
	'site-inc/wpmu-functions.php',
	'wpmu-settings.php',
	// 3.0
	'site-admin/categories.php',
	'site-admin/edit-category-form.php',
	'site-admin/edit-page-form.php',
	'site-admin/edit-pages.php',
	'site-admin/images/admin-header-footer.png',
	'site-admin/images/browse-happy.gif',
	'site-admin/images/ico-add.png',
	'site-admin/images/ico-close.png',
	'site-admin/images/ico-edit.png',
	'site-admin/images/ico-viewpage.png',
	'site-admin/images/fav-top.png',
	'site-admin/images/screen-options-left.gif',
	'site-admin/images/wp-logo-vs.gif',
	'site-admin/images/wp-logo.gif',
	'site-admin/import',
	'site-admin/js/wp-gears.dev.js',
	'site-admin/js/wp-gears.js',
	'site-admin/options-misc.php',
	'site-admin/page-new.php',
	'site-admin/page.php',
	'site-admin/rtl.css',
	'site-admin/rtl.dev.css',
	'site-admin/update-links.php',
	'site-admin/site-admin.css',
	'site-admin/site-admin.dev.css',
	'site-inc/js/codepress',
	'site-inc/js/codepress/engines/khtml.js',
	'site-inc/js/codepress/engines/older.js',
	'site-inc/js/jquery/autocomplete.dev.js',
	'site-inc/js/jquery/autocomplete.js',
	'site-inc/js/jquery/interface.js',
	'site-inc/js/scriptaculous/prototype.js',
	// Following file added back in 5.1 see #45645
	//'site-inc/js/tinymce/wp-tinymce.js',
	// 3.1
	'site-admin/edit-attachment-rows.php',
	'site-admin/edit-link-categories.php',
	'site-admin/edit-link-category-form.php',
	'site-admin/edit-post-rows.php',
	'site-admin/images/button-grad-active-vs.png',
	'site-admin/images/button-grad-vs.png',
	'site-admin/images/fav-arrow-vs-rtl.gif',
	'site-admin/images/fav-arrow-vs.gif',
	'site-admin/images/fav-top-vs.gif',
	'site-admin/images/list-vs.png',
	'site-admin/images/screen-options-right-up.gif',
	'site-admin/images/screen-options-right.gif',
	'site-admin/images/visit-site-button-grad-vs.gif',
	'site-admin/images/visit-site-button-grad.gif',
	'site-admin/link-category.php',
	'site-admin/sidebar.php',
	'site-inc/classes.php',
	'site-inc/js/tinymce/blank.htm',
	'site-inc/js/tinymce/plugins/media/css/content.css',
	'site-inc/js/tinymce/plugins/media/img',
	'site-inc/js/tinymce/plugins/safari',
	// 3.2
	'site-admin/images/logo-login.gif',
	'site-admin/images/star.gif',
	'site-admin/js/list-table.dev.js',
	'site-admin/js/list-table.js',
	'site-inc/default-embeds.php',
	'site-inc/js/tinymce/plugins/wordpress/img/help.gif',
	'site-inc/js/tinymce/plugins/wordpress/img/more.gif',
	'site-inc/js/tinymce/plugins/wordpress/img/toolbars.gif',
	'site-inc/js/tinymce/themes/advanced/img/fm.gif',
	'site-inc/js/tinymce/themes/advanced/img/sflogo.png',
	// 3.3
	'site-admin/css/colors-classic-rtl.css',
	'site-admin/css/colors-classic-rtl.dev.css',
	'site-admin/css/colors-fresh-rtl.css',
	'site-admin/css/colors-fresh-rtl.dev.css',
	'site-admin/css/dashboard-rtl.dev.css',
	'site-admin/css/dashboard.dev.css',
	'site-admin/css/global-rtl.css',
	'site-admin/css/global-rtl.dev.css',
	'site-admin/css/global.css',
	'site-admin/css/global.dev.css',
	'site-admin/css/install-rtl.dev.css',
	'site-admin/css/login-rtl.dev.css',
	'site-admin/css/login.dev.css',
	'site-admin/css/ms.css',
	'site-admin/css/ms.dev.css',
	'site-admin/css/nav-menu-rtl.css',
	'site-admin/css/nav-menu-rtl.dev.css',
	'site-admin/css/nav-menu.css',
	'site-admin/css/nav-menu.dev.css',
	'site-admin/css/plugin-install-rtl.css',
	'site-admin/css/plugin-install-rtl.dev.css',
	'site-admin/css/plugin-install.css',
	'site-admin/css/plugin-install.dev.css',
	'site-admin/css/press-this-rtl.dev.css',
	'site-admin/css/press-this.dev.css',
	'site-admin/css/theme-editor-rtl.css',
	'site-admin/css/theme-editor-rtl.dev.css',
	'site-admin/css/theme-editor.css',
	'site-admin/css/theme-editor.dev.css',
	'site-admin/css/theme-install-rtl.css',
	'site-admin/css/theme-install-rtl.dev.css',
	'site-admin/css/theme-install.css',
	'site-admin/css/theme-install.dev.css',
	'site-admin/css/widgets-rtl.dev.css',
	'site-admin/css/widgets.dev.css',
	'site-admin/includes/internal-linking.php',
	'site-inc/images/admin-bar-sprite-rtl.png',
	'site-inc/js/jquery/ui.button.js',
	'site-inc/js/jquery/ui.core.js',
	'site-inc/js/jquery/ui.dialog.js',
	'site-inc/js/jquery/ui.draggable.js',
	'site-inc/js/jquery/ui.droppable.js',
	'site-inc/js/jquery/ui.mouse.js',
	'site-inc/js/jquery/ui.position.js',
	'site-inc/js/jquery/ui.resizable.js',
	'site-inc/js/jquery/ui.selectable.js',
	'site-inc/js/jquery/ui.sortable.js',
	'site-inc/js/jquery/ui.tabs.js',
	'site-inc/js/jquery/ui.widget.js',
	'site-inc/js/l10n.dev.js',
	'site-inc/js/l10n.js',
	'site-inc/js/tinymce/plugins/wplink/css',
	'site-inc/js/tinymce/plugins/wplink/img',
	'site-inc/js/tinymce/plugins/wplink/js',
	'site-inc/js/tinymce/themes/advanced/img/wpicons.png',
	'site-inc/js/tinymce/themes/advanced/skins/wp_theme/img/butt2.png',
	'site-inc/js/tinymce/themes/advanced/skins/wp_theme/img/button_bg.png',
	'site-inc/js/tinymce/themes/advanced/skins/wp_theme/img/down_arrow.gif',
	'site-inc/js/tinymce/themes/advanced/skins/wp_theme/img/fade-butt.png',
	'site-inc/js/tinymce/themes/advanced/skins/wp_theme/img/separator.gif',
	// Don't delete, yet: 'wp-rss.php',
	// Don't delete, yet: 'wp-rdf.php',
	// Don't delete, yet: 'wp-rss2.php',
	// Don't delete, yet: 'wp-commentsrss2.php',
	// Don't delete, yet: 'wp-atom.php',
	// Don't delete, yet: 'wp-feed.php',
	// 3.4
	'site-admin/images/gray-star.png',
	'site-admin/images/logo-login.png',
	'site-admin/images/star.png',
	'site-admin/index-extra.php',
	'site-admin/network/index-extra.php',
	'site-admin/user/index-extra.php',
	'site-admin/images/screenshots/admin-flyouts.png',
	'site-admin/images/screenshots/coediting.png',
	'site-admin/images/screenshots/drag-and-drop.png',
	'site-admin/images/screenshots/help-screen.png',
	'site-admin/images/screenshots/media-icon.png',
	'site-admin/images/screenshots/new-feature-pointer.png',
	'site-admin/images/screenshots/welcome-screen.png',
	'site-inc/css/editor-buttons.css',
	'site-inc/css/editor-buttons.dev.css',
	'site-inc/js/tinymce/plugins/paste/blank.htm',
	'site-inc/js/tinymce/plugins/wordpress/css',
	'site-inc/js/tinymce/plugins/wordpress/editor_plugin.dev.js',
	'site-inc/js/tinymce/plugins/wordpress/img/embedded.png',
	'site-inc/js/tinymce/plugins/wordpress/img/more_bug.gif',
	'site-inc/js/tinymce/plugins/wordpress/img/page_bug.gif',
	'site-inc/js/tinymce/plugins/wpdialogs/editor_plugin.dev.js',
	'site-inc/js/tinymce/plugins/wpeditimage/css/editimage-rtl.css',
	'site-inc/js/tinymce/plugins/wpeditimage/editor_plugin.dev.js',
	'site-inc/js/tinymce/plugins/wpfullscreen/editor_plugin.dev.js',
	'site-inc/js/tinymce/plugins/wpgallery/editor_plugin.dev.js',
	'site-inc/js/tinymce/plugins/wpgallery/img/gallery.png',
	'site-inc/js/tinymce/plugins/wplink/editor_plugin.dev.js',
	// Don't delete, yet: 'wp-pass.php',
	// Don't delete, yet: 'wp-register.php',
	// 3.5
	'site-admin/gears-manifest.php',
	'site-admin/includes/manifest.php',
	'site-admin/images/archive-link.png',
	'site-admin/images/blue-grad.png',
	'site-admin/images/button-grad-active.png',
	'site-admin/images/button-grad.png',
	'site-admin/images/ed-bg-vs.gif',
	'site-admin/images/ed-bg.gif',
	'site-admin/images/fade-butt.png',
	'site-admin/images/fav-arrow-rtl.gif',
	'site-admin/images/fav-arrow.gif',
	'site-admin/images/fav-vs.png',
	'site-admin/images/fav.png',
	'site-admin/images/gray-grad.png',
	'site-admin/images/loading-publish.gif',
	'site-admin/images/logo-ghost.png',
	'site-admin/images/logo.gif',
	'site-admin/images/menu-arrow-frame-rtl.png',
	'site-admin/images/menu-arrow-frame.png',
	'site-admin/images/menu-arrows.gif',
	'site-admin/images/menu-bits-rtl-vs.gif',
	'site-admin/images/menu-bits-rtl.gif',
	'site-admin/images/menu-bits-vs.gif',
	'site-admin/images/menu-bits.gif',
	'site-admin/images/menu-dark-rtl-vs.gif',
	'site-admin/images/menu-dark-rtl.gif',
	'site-admin/images/menu-dark-vs.gif',
	'site-admin/images/menu-dark.gif',
	'site-admin/images/required.gif',
	'site-admin/images/screen-options-toggle-vs.gif',
	'site-admin/images/screen-options-toggle.gif',
	'site-admin/images/toggle-arrow-rtl.gif',
	'site-admin/images/toggle-arrow.gif',
	'site-admin/images/upload-classic.png',
	'site-admin/images/upload-fresh.png',
	'site-admin/images/white-grad-active.png',
	'site-admin/images/white-grad.png',
	'site-admin/images/widgets-arrow-vs.gif',
	'site-admin/images/widgets-arrow.gif',
	'site-admin/images/wpspin_dark.gif',
	'site-inc/images/upload.png',
	'site-inc/js/prototype.js',
	'site-inc/js/scriptaculous',
	'site-admin/css/site-admin-rtl.dev.css',
	'site-admin/css/site-admin.dev.css',
	'site-admin/css/media-rtl.dev.css',
	'site-admin/css/media.dev.css',
	'site-admin/css/colors-classic.dev.css',
	'site-admin/css/customize-controls-rtl.dev.css',
	'site-admin/css/customize-controls.dev.css',
	'site-admin/css/ie-rtl.dev.css',
	'site-admin/css/ie.dev.css',
	'site-admin/css/install.dev.css',
	'site-admin/css/colors-fresh.dev.css',
	'site-inc/js/customize-base.dev.js',
	'site-inc/js/json2.dev.js',
	'site-inc/js/comment-reply.dev.js',
	'site-inc/js/customize-preview.dev.js',
	'site-inc/js/wplink.dev.js',
	'site-inc/js/tw-sack.dev.js',
	'site-inc/js/wp-list-revisions.dev.js',
	'site-inc/js/autosave.dev.js',
	'site-inc/js/admin-bar.dev.js',
	'site-inc/js/quicktags.dev.js',
	'site-inc/js/wp-ajax-response.dev.js',
	'site-inc/js/wp-pointer.dev.js',
	'site-inc/js/hoverIntent.dev.js',
	'site-inc/js/colorpicker.dev.js',
	'site-inc/js/wp-lists.dev.js',
	'site-inc/js/customize-loader.dev.js',
	'site-inc/js/jquery/jquery.table-hotkeys.dev.js',
	'site-inc/js/jquery/jquery.color.dev.js',
	'site-inc/js/jquery/jquery.color.js',
	'site-inc/js/jquery/jquery.hotkeys.dev.js',
	'site-inc/js/jquery/jquery.form.dev.js',
	'site-inc/js/jquery/suggest.dev.js',
	'site-admin/js/xfn.dev.js',
	'site-admin/js/set-post-thumbnail.dev.js',
	'site-admin/js/comment.dev.js',
	'site-admin/js/theme.dev.js',
	'site-admin/js/cat.dev.js',
	'site-admin/js/password-strength-meter.dev.js',
	'site-admin/js/user-profile.dev.js',
	'site-admin/js/theme-preview.dev.js',
	'site-admin/js/post.dev.js',
	'site-admin/js/media-upload.dev.js',
	'site-admin/js/word-count.dev.js',
	'site-admin/js/plugin-install.dev.js',
	'site-admin/js/edit-comments.dev.js',
	'site-admin/js/media-gallery.dev.js',
	'site-admin/js/custom-fields.dev.js',
	'site-admin/js/custom-background.dev.js',
	'site-admin/js/common.dev.js',
	'site-admin/js/inline-edit-tax.dev.js',
	'site-admin/js/gallery.dev.js',
	'site-admin/js/utils.dev.js',
	'site-admin/js/widgets.dev.js',
	'site-admin/js/wp-fullscreen.dev.js',
	'site-admin/js/nav-menu.dev.js',
	'site-admin/js/dashboard.dev.js',
	'site-admin/js/link.dev.js',
	'site-admin/js/user-suggest.dev.js',
	'site-admin/js/postbox.dev.js',
	'site-admin/js/tags.dev.js',
	'site-admin/js/image-edit.dev.js',
	'site-admin/js/media.dev.js',
	'site-admin/js/customize-controls.dev.js',
	'site-admin/js/inline-edit-post.dev.js',
	'site-admin/js/categories.dev.js',
	'site-admin/js/editor.dev.js',
	'site-inc/js/tinymce/plugins/wpeditimage/js/editimage.dev.js',
	'site-inc/js/tinymce/plugins/wpdialogs/js/popup.dev.js',
	'site-inc/js/tinymce/plugins/wpdialogs/js/wpdialog.dev.js',
	'site-inc/js/plupload/handlers.dev.js',
	'site-inc/js/plupload/wp-plupload.dev.js',
	'site-inc/js/swfupload/handlers.dev.js',
	'site-inc/js/jcrop/jquery.Jcrop.dev.js',
	'site-inc/js/jcrop/jquery.Jcrop.js',
	'site-inc/js/jcrop/jquery.Jcrop.css',
	'site-inc/js/imgareaselect/jquery.imgareaselect.dev.js',
	'site-inc/css/wp-pointer.dev.css',
	'site-inc/css/editor.dev.css',
	'site-inc/css/jquery-ui-dialog.dev.css',
	'site-inc/css/admin-bar-rtl.dev.css',
	'site-inc/css/admin-bar.dev.css',
	'site-inc/js/jquery/ui/jquery.effects.clip.min.js',
	'site-inc/js/jquery/ui/jquery.effects.scale.min.js',
	'site-inc/js/jquery/ui/jquery.effects.blind.min.js',
	'site-inc/js/jquery/ui/jquery.effects.core.min.js',
	'site-inc/js/jquery/ui/jquery.effects.shake.min.js',
	'site-inc/js/jquery/ui/jquery.effects.fade.min.js',
	'site-inc/js/jquery/ui/jquery.effects.explode.min.js',
	'site-inc/js/jquery/ui/jquery.effects.slide.min.js',
	'site-inc/js/jquery/ui/jquery.effects.drop.min.js',
	'site-inc/js/jquery/ui/jquery.effects.highlight.min.js',
	'site-inc/js/jquery/ui/jquery.effects.bounce.min.js',
	'site-inc/js/jquery/ui/jquery.effects.pulsate.min.js',
	'site-inc/js/jquery/ui/jquery.effects.transfer.min.js',
	'site-inc/js/jquery/ui/jquery.effects.fold.min.js',
	'site-admin/images/screenshots/captions-1.png',
	'site-admin/images/screenshots/captions-2.png',
	'site-admin/images/screenshots/flex-header-1.png',
	'site-admin/images/screenshots/flex-header-2.png',
	'site-admin/images/screenshots/flex-header-3.png',
	'site-admin/images/screenshots/flex-header-media-library.png',
	'site-admin/images/screenshots/theme-customizer.png',
	'site-admin/images/screenshots/twitter-embed-1.png',
	'site-admin/images/screenshots/twitter-embed-2.png',
	'site-admin/js/utils.js',
	'site-admin/options-privacy.php',
	'wp-app.php',
	'site-inc/class-wp-atom-server.php',
	'site-inc/js/tinymce/themes/advanced/skins/wp_theme/ui.css',
	// 3.5.2
	'site-inc/js/swfupload/swfupload-all.js',
	// 3.6
	'site-admin/js/revisions-js.php',
	'site-admin/images/screenshots',
	'site-admin/js/categories.js',
	'site-admin/js/categories.min.js',
	'site-admin/js/custom-fields.js',
	'site-admin/js/custom-fields.min.js',
	// 3.7
	'site-admin/js/cat.js',
	'site-admin/js/cat.min.js',
	'site-inc/js/tinymce/plugins/wpeditimage/js/editimage.min.js',
	// 3.8
	'site-inc/js/tinymce/themes/advanced/skins/wp_theme/img/page_bug.gif',
	'site-inc/js/tinymce/themes/advanced/skins/wp_theme/img/more_bug.gif',
	'site-inc/js/thickbox/tb-close-2x.png',
	'site-inc/js/thickbox/tb-close.png',
	'site-inc/images/wpmini-blue-2x.png',
	'site-inc/images/wpmini-blue.png',
	'site-admin/css/colors-fresh.css',
	'site-admin/css/colors-classic.css',
	'site-admin/css/colors-fresh.min.css',
	'site-admin/css/colors-classic.min.css',
	'site-admin/js/about.min.js',
	'site-admin/js/about.js',
	'site-admin/images/arrows-dark-vs-2x.png',
	'site-admin/images/wp-logo-vs.png',
	'site-admin/images/arrows-dark-vs.png',
	'site-admin/images/wp-logo.png',
	'site-admin/images/arrows-pr.png',
	'site-admin/images/arrows-dark.png',
	'site-admin/images/press-this.png',
	'site-admin/images/press-this-2x.png',
	'site-admin/images/arrows-vs-2x.png',
	'site-admin/images/welcome-icons.png',
	'site-admin/images/wp-logo-2x.png',
	'site-admin/images/stars-rtl-2x.png',
	'site-admin/images/arrows-dark-2x.png',
	'site-admin/images/arrows-pr-2x.png',
	'site-admin/images/menu-shadow-rtl.png',
	'site-admin/images/arrows-vs.png',
	'site-admin/images/about-search-2x.png',
	'site-admin/images/bubble_bg-rtl-2x.gif',
	'site-admin/images/wp-badge-2x.png',
	'site-admin/images/wordpress-logo-2x.png',
	'site-admin/images/bubble_bg-rtl.gif',
	'site-admin/images/wp-badge.png',
	'site-admin/images/menu-shadow.png',
	'site-admin/images/about-globe-2x.png',
	'site-admin/images/welcome-icons-2x.png',
	'site-admin/images/stars-rtl.png',
	'site-admin/images/wp-logo-vs-2x.png',
	'site-admin/images/about-updates-2x.png',
	// 3.9
	'site-admin/css/colors.css',
	'site-admin/css/colors.min.css',
	'site-admin/css/colors-rtl.css',
	'site-admin/css/colors-rtl.min.css',
	// Following files added back in 4.5 see #36083
	// 'site-admin/css/media-rtl.min.css',
	// 'site-admin/css/media.min.css',
	// 'site-admin/css/farbtastic-rtl.min.css',
	'site-admin/images/lock-2x.png',
	'site-admin/images/lock.png',
	'site-admin/js/theme-preview.js',
	'site-admin/js/theme-install.min.js',
	'site-admin/js/theme-install.js',
	'site-admin/js/theme-preview.min.js',
	'site-inc/js/plupload/plupload.html4.js',
	'site-inc/js/plupload/plupload.html5.js',
	'site-inc/js/plupload/changelog.txt',
	'site-inc/js/plupload/plupload.silverlight.js',
	'site-inc/js/plupload/plupload.flash.js',
	// Added back in 4.9 [41328], see #41755
	// 'site-inc/js/plupload/plupload.js',
	'site-inc/js/tinymce/plugins/spellchecker',
	'site-inc/js/tinymce/plugins/inlinepopups',
	'site-inc/js/tinymce/plugins/media/js',
	'site-inc/js/tinymce/plugins/media/css',
	'site-inc/js/tinymce/plugins/wordpress/img',
	'site-inc/js/tinymce/plugins/wpdialogs/js',
	'site-inc/js/tinymce/plugins/wpeditimage/img',
	'site-inc/js/tinymce/plugins/wpeditimage/js',
	'site-inc/js/tinymce/plugins/wpeditimage/css',
	'site-inc/js/tinymce/plugins/wpgallery/img',
	'site-inc/js/tinymce/plugins/wpfullscreen/css',
	'site-inc/js/tinymce/plugins/paste/js',
	'site-inc/js/tinymce/themes/advanced',
	'site-inc/js/tinymce/tiny_mce.js',
	'site-inc/js/tinymce/mark_loaded_src.js',
	'site-inc/js/tinymce/wp-tinymce-schema.js',
	'site-inc/js/tinymce/plugins/media/editor_plugin.js',
	'site-inc/js/tinymce/plugins/media/editor_plugin_src.js',
	'site-inc/js/tinymce/plugins/media/media.htm',
	'site-inc/js/tinymce/plugins/wpview/editor_plugin_src.js',
	'site-inc/js/tinymce/plugins/wpview/editor_plugin.js',
	'site-inc/js/tinymce/plugins/directionality/editor_plugin.js',
	'site-inc/js/tinymce/plugins/directionality/editor_plugin_src.js',
	'site-inc/js/tinymce/plugins/wordpress/editor_plugin.js',
	'site-inc/js/tinymce/plugins/wordpress/editor_plugin_src.js',
	'site-inc/js/tinymce/plugins/wpdialogs/editor_plugin_src.js',
	'site-inc/js/tinymce/plugins/wpdialogs/editor_plugin.js',
	'site-inc/js/tinymce/plugins/wpeditimage/editimage.html',
	'site-inc/js/tinymce/plugins/wpeditimage/editor_plugin.js',
	'site-inc/js/tinymce/plugins/wpeditimage/editor_plugin_src.js',
	'site-inc/js/tinymce/plugins/fullscreen/editor_plugin_src.js',
	'site-inc/js/tinymce/plugins/fullscreen/fullscreen.htm',
	'site-inc/js/tinymce/plugins/fullscreen/editor_plugin.js',
	'site-inc/js/tinymce/plugins/wplink/editor_plugin_src.js',
	'site-inc/js/tinymce/plugins/wplink/editor_plugin.js',
	'site-inc/js/tinymce/plugins/wpgallery/editor_plugin_src.js',
	'site-inc/js/tinymce/plugins/wpgallery/editor_plugin.js',
	'site-inc/js/tinymce/plugins/tabfocus/editor_plugin.js',
	'site-inc/js/tinymce/plugins/tabfocus/editor_plugin_src.js',
	'site-inc/js/tinymce/plugins/wpfullscreen/editor_plugin.js',
	'site-inc/js/tinymce/plugins/wpfullscreen/editor_plugin_src.js',
	'site-inc/js/tinymce/plugins/paste/editor_plugin.js',
	'site-inc/js/tinymce/plugins/paste/pasteword.htm',
	'site-inc/js/tinymce/plugins/paste/editor_plugin_src.js',
	'site-inc/js/tinymce/plugins/paste/pastetext.htm',
	'site-inc/js/tinymce/langs/wp-langs.php',
	// 4.1
	'site-inc/js/jquery/ui/jquery.ui.accordion.min.js',
	'site-inc/js/jquery/ui/jquery.ui.autocomplete.min.js',
	'site-inc/js/jquery/ui/jquery.ui.button.min.js',
	'site-inc/js/jquery/ui/jquery.ui.core.min.js',
	'site-inc/js/jquery/ui/jquery.ui.datepicker.min.js',
	'site-inc/js/jquery/ui/jquery.ui.dialog.min.js',
	'site-inc/js/jquery/ui/jquery.ui.draggable.min.js',
	'site-inc/js/jquery/ui/jquery.ui.droppable.min.js',
	'site-inc/js/jquery/ui/jquery.ui.effect-blind.min.js',
	'site-inc/js/jquery/ui/jquery.ui.effect-bounce.min.js',
	'site-inc/js/jquery/ui/jquery.ui.effect-clip.min.js',
	'site-inc/js/jquery/ui/jquery.ui.effect-drop.min.js',
	'site-inc/js/jquery/ui/jquery.ui.effect-explode.min.js',
	'site-inc/js/jquery/ui/jquery.ui.effect-fade.min.js',
	'site-inc/js/jquery/ui/jquery.ui.effect-fold.min.js',
	'site-inc/js/jquery/ui/jquery.ui.effect-highlight.min.js',
	'site-inc/js/jquery/ui/jquery.ui.effect-pulsate.min.js',
	'site-inc/js/jquery/ui/jquery.ui.effect-scale.min.js',
	'site-inc/js/jquery/ui/jquery.ui.effect-shake.min.js',
	'site-inc/js/jquery/ui/jquery.ui.effect-slide.min.js',
	'site-inc/js/jquery/ui/jquery.ui.effect-transfer.min.js',
	'site-inc/js/jquery/ui/jquery.ui.effect.min.js',
	'site-inc/js/jquery/ui/jquery.ui.menu.min.js',
	'site-inc/js/jquery/ui/jquery.ui.mouse.min.js',
	'site-inc/js/jquery/ui/jquery.ui.position.min.js',
	'site-inc/js/jquery/ui/jquery.ui.progressbar.min.js',
	'site-inc/js/jquery/ui/jquery.ui.resizable.min.js',
	'site-inc/js/jquery/ui/jquery.ui.selectable.min.js',
	'site-inc/js/jquery/ui/jquery.ui.slider.min.js',
	'site-inc/js/jquery/ui/jquery.ui.sortable.min.js',
	'site-inc/js/jquery/ui/jquery.ui.spinner.min.js',
	'site-inc/js/jquery/ui/jquery.ui.tabs.min.js',
	'site-inc/js/jquery/ui/jquery.ui.tooltip.min.js',
	'site-inc/js/jquery/ui/jquery.ui.widget.min.js',
	'site-inc/js/tinymce/skins/wordpress/images/dashicon-no-alt.png',
	// 4.3
	'site-admin/js/wp-fullscreen.js',
	'site-admin/js/wp-fullscreen.min.js',
	'site-inc/js/tinymce/wp-mce-help.php',
	'site-inc/js/tinymce/plugins/wpfullscreen',
	// 4.5
	'site-inc/theme-compat/comments-popup.php',
	// 4.6
	'site-admin/includes/class-wp-automatic-upgrader.php', // Wrong file name, see #37628.
	// 4.8
	'site-inc/js/tinymce/plugins/wpembed',
	'site-inc/js/tinymce/plugins/media/moxieplayer.swf',
	'site-inc/js/tinymce/skins/lightgray/fonts/readme.md',
	'site-inc/js/tinymce/skins/lightgray/fonts/tinymce-small.json',
	'site-inc/js/tinymce/skins/lightgray/fonts/tinymce.json',
	'site-inc/js/tinymce/skins/lightgray/skin.ie7.min.css',
	// 4.9
	'site-admin/css/press-this-editor-rtl.css',
	'site-admin/css/press-this-editor-rtl.min.css',
	'site-admin/css/press-this-editor.css',
	'site-admin/css/press-this-editor.min.css',
	'site-admin/css/press-this-rtl.css',
	'site-admin/css/press-this-rtl.min.css',
	'site-admin/css/press-this.css',
	'site-admin/css/press-this.min.css',
	'site-admin/includes/class-wp-press-this.php',
	'site-admin/js/bookmarklet.js',
	'site-admin/js/bookmarklet.min.js',
	'site-admin/js/press-this.js',
	'site-admin/js/press-this.min.js',
	'site-inc/js/mediaelement/background.png',
	'site-inc/js/mediaelement/bigplay.png',
	'site-inc/js/mediaelement/bigplay.svg',
	'site-inc/js/mediaelement/controls.png',
	'site-inc/js/mediaelement/controls.svg',
	'site-inc/js/mediaelement/flashmediaelement.swf',
	'site-inc/js/mediaelement/froogaloop.min.js',
	'site-inc/js/mediaelement/jumpforward.png',
	'site-inc/js/mediaelement/loading.gif',
	'site-inc/js/mediaelement/silverlightmediaelement.xap',
	'site-inc/js/mediaelement/skipback.png',
	'site-inc/js/plupload/plupload.flash.swf',
	'site-inc/js/plupload/plupload.full.min.js',
	'site-inc/js/plupload/plupload.silverlight.xap',
	'site-inc/js/swfupload/plugins',
	'site-inc/js/swfupload/swfupload.swf',
	// 4.9.2
	'site-inc/js/mediaelement/lang',
	'site-inc/js/mediaelement/lang/ca.js',
	'site-inc/js/mediaelement/lang/cs.js',
	'site-inc/js/mediaelement/lang/de.js',
	'site-inc/js/mediaelement/lang/es.js',
	'site-inc/js/mediaelement/lang/fa.js',
	'site-inc/js/mediaelement/lang/fr.js',
	'site-inc/js/mediaelement/lang/hr.js',
	'site-inc/js/mediaelement/lang/hu.js',
	'site-inc/js/mediaelement/lang/it.js',
	'site-inc/js/mediaelement/lang/ja.js',
	'site-inc/js/mediaelement/lang/ko.js',
	'site-inc/js/mediaelement/lang/nl.js',
	'site-inc/js/mediaelement/lang/pl.js',
	'site-inc/js/mediaelement/lang/pt.js',
	'site-inc/js/mediaelement/lang/ro.js',
	'site-inc/js/mediaelement/lang/ru.js',
	'site-inc/js/mediaelement/lang/sk.js',
	'site-inc/js/mediaelement/lang/sv.js',
	'site-inc/js/mediaelement/lang/uk.js',
	'site-inc/js/mediaelement/lang/zh-cn.js',
	'site-inc/js/mediaelement/lang/zh.js',
	'site-inc/js/mediaelement/mediaelement-flash-audio-ogg.swf',
	'site-inc/js/mediaelement/mediaelement-flash-audio.swf',
	'site-inc/js/mediaelement/mediaelement-flash-video-hls.swf',
	'site-inc/js/mediaelement/mediaelement-flash-video-mdash.swf',
	'site-inc/js/mediaelement/mediaelement-flash-video.swf',
	'site-inc/js/mediaelement/renderers/dailymotion.js',
	'site-inc/js/mediaelement/renderers/dailymotion.min.js',
	'site-inc/js/mediaelement/renderers/facebook.js',
	'site-inc/js/mediaelement/renderers/facebook.min.js',
	'site-inc/js/mediaelement/renderers/soundcloud.js',
	'site-inc/js/mediaelement/renderers/soundcloud.min.js',
	'site-inc/js/mediaelement/renderers/twitch.js',
	'site-inc/js/mediaelement/renderers/twitch.min.js',
	// 5.0
	'site-inc/js/codemirror/jshint.js',
	// 5.1
	'site-inc/random_compat/random_bytes_openssl.php',
	'site-inc/js/tinymce/wp-tinymce.js.gz',
);

/**
 * Stores new files in wp-content to copy
 *
 * The contents of this array indicate any new bundled plugins/themes which
 * should be installed with the WordPress Upgrade. These items will not be
 * re-installed in future upgrades, this behaviour is controlled by the
 * introduced version present here being older than the current installed version.
 *
 * The content of this array should follow the following format:
 * Filename (relative to wp-content) => Introduced version
 * Directories should be noted by suffixing it with a trailing slash (/)
 *
 * @since 3.2.0
 * @since 4.7.0 New themes were not automatically installed for 4.4-4.6 on
 *              upgrade. New themes are now installed again. To disable new
 *              themes from being installed on upgrade, explicitly define
 *              CORE_UPGRADE_SKIP_NEW_BUNDLED as false.
 * @global array $_new_bundled_files
 * @var array
 * @name $_new_bundled_files
 */
global $_new_bundled_files;

$_new_bundled_files = array(
	'plugins/akismet/'        => '2.0',
	'themes/twentyten/'       => '3.0',
	'themes/twentyeleven/'    => '3.2',
	'themes/twentytwelve/'    => '3.5',
	'themes/twentythirteen/'  => '3.6',
	'themes/twentyfourteen/'  => '3.8',
	'themes/twentyfifteen/'   => '4.1',
	'themes/twentysixteen/'   => '4.4',
	'themes/twentyseventeen/' => '4.7',
	'themes/twentynineteen/'  => '5.0',
);

/**
 * Upgrades the core of WordPress.
 *
 * This will create a .maintenance file at the base of the WordPress directory
 * to ensure that people can not access the web site, when the files are being
 * copied to their locations.
 *
 * The files in the `$_old_files` list will be removed and the new files
 * copied from the zip file after the database is upgraded.
 *
 * The files in the `$_new_bundled_files` list will be added to the installation
 * if the version is greater than or equal to the old version being upgraded.
 *
 * The steps for the upgrader for after the new release is downloaded and
 * unzipped is:
 *   1. Test unzipped location for select files to ensure that unzipped worked.
 *   2. Create the .maintenance file in current WordPress base.
 *   3. Copy new WordPress directory over old WordPress files.
 *   4. Upgrade WordPress to new version.
 *     4.1. Copy all files/folders other than wp-content
 *     4.2. Copy any language files to WP_LANG_DIR (which may differ from WP_CONTENT_DIR
 *     4.3. Copy any new bundled themes/plugins to their respective locations
 *   5. Delete new WordPress directory path.
 *   6. Delete .maintenance file.
 *   7. Remove old files.
 *   8. Delete 'update_core' option.
 *
 * There are several areas of failure. For instance if PHP times out before step
 * 6, then you will not be able to access any portion of your site. Also, since
 * the upgrade will not continue where it left off, you will not be able to
 * automatically remove old files and remove the 'update_core' option. This
 * isn't that bad.
 *
 * If the copy of the new WordPress over the old fails, then the worse is that
 * the new WordPress directory will remain.
 *
 * If it is assumed that every file will be copied over, including plugins and
 * themes, then if you edit the default theme, you should rename it, so that
 * your changes remain.
 *
 * @since 2.7.0
 *
 * @global WP_Filesystem_Base $wp_filesystem          WordPress filesystem subclass.
 * @global array              $_old_files
 * @global array              $_new_bundled_files
 * @global wpdb               $wpdb
 * @global string             $wp_version
 * @global string             $required_php_version
 * @global string             $required_mysql_version
 *
 * @param string $from New release unzipped path.
 * @param string $to   Path to old WordPress installation.
 * @return WP_Error|null WP_Error on failure, null on success.
 */
function update_core( $from, $to ) {
	global $wp_filesystem, $_old_files, $_new_bundled_files, $wpdb;

	@set_time_limit( 300 );

	/**
	 * Filters feedback messages displayed during the core update process.
	 *
	 * The filter is first evaluated after the zip file for the latest version
	 * has been downloaded and unzipped. It is evaluated five more times during
	 * the process:
	 *
	 * 1. Before WordPress begins the core upgrade process.
	 * 2. Before Maintenance Mode is enabled.
	 * 3. Before WordPress begins copying over the necessary files.
	 * 4. Before Maintenance Mode is disabled.
	 * 5. Before the database is upgraded.
	 *
	 * @since 2.5.0
	 *
	 * @param string $feedback The core update feedback messages.
	 */
	apply_filters( 'update_feedback', __( 'Verifying the unpacked files&#8230;' ) );

	// Sanity check the unzipped distribution.
	$distro = '';
	$roots  = array( '/wordpress/', '/wordpress-mu/' );
	foreach ( $roots as $root ) {
		if ( $wp_filesystem->exists( $from . $root . 'readme.html' ) && $wp_filesystem->exists( $from . $root . 'site-inc/version.php' ) ) {
			$distro = $root;
			break;
		}
	}
	if ( ! $distro ) {
		$wp_filesystem->delete( $from, true );
		return new WP_Error( 'insane_distro', __( 'The update could not be unpacked' ) );
	}

	/*
	 * Import $wp_version, $required_php_version, and $required_mysql_version from the new version.
	 * DO NOT globalise any variables imported from `version-current.php` in this function.
	 *
	 * BC Note: $wp_filesystem->wp_content_dir() returned unslashed pre-2.8
	 */
	$versions_file = trailingslashit( $wp_filesystem->wp_content_dir() ) . 'upgrade/version-current.php';
	if ( ! $wp_filesystem->copy( $from . $distro . 'site-inc/version.php', $versions_file ) ) {
		$wp_filesystem->delete( $from, true );
		return new WP_Error( 'copy_failed_for_version_file', __( 'The update cannot be installed because we will be unable to copy some files. This is usually due to inconsistent file permissions.' ), 'site-inc/version.php' );
	}

	$wp_filesystem->chmod( $versions_file, FS_CHMOD_FILE );
	require( WP_CONTENT_DIR . '/upgrade/version-current.php' );
	$wp_filesystem->delete( $versions_file );

	$php_version       = phpversion();
	$mysql_version     = $wpdb->db_version();
	$old_wp_version    = $GLOBALS['wp_version']; // The version of WordPress we're updating from
	$development_build = ( false !== strpos( $old_wp_version . $wp_version, '-' ) ); // a dash in the version indicates a Development release
	$php_compat        = version_compare( $php_version, $required_php_version, '>=' );
	if ( file_exists( WP_CONTENT_DIR . '/db.php' ) && empty( $wpdb->is_mysql ) ) {
		$mysql_compat = true;
	} else {
		$mysql_compat = version_compare( $mysql_version, $required_mysql_version, '>=' );
	}

	if ( ! $mysql_compat || ! $php_compat ) {
		$wp_filesystem->delete( $from, true );
	}

	if ( ! $mysql_compat && ! $php_compat ) {
		return new WP_Error( 'php_mysql_not_compatible', sprintf( __( 'The update cannot be installed because WordPress %1$s requires PHP version %2$s or higher and MySQL version %3$s or higher. You are running PHP version %4$s and MySQL version %5$s.' ), $wp_version, $required_php_version, $required_mysql_version, $php_version, $mysql_version ) );
	} elseif ( ! $php_compat ) {
		return new WP_Error( 'php_not_compatible', sprintf( __( 'The update cannot be installed because WordPress %1$s requires PHP version %2$s or higher. You are running version %3$s.' ), $wp_version, $required_php_version, $php_version ) );
	} elseif ( ! $mysql_compat ) {
		return new WP_Error( 'mysql_not_compatible', sprintf( __( 'The update cannot be installed because WordPress %1$s requires MySQL version %2$s or higher. You are running version %3$s.' ), $wp_version, $required_mysql_version, $mysql_version ) );
	}

	/** This filter is documented in site-admin/includes/update-core.php */
	apply_filters( 'update_feedback', __( 'Preparing to install the latest version&#8230;' ) );

	// Don't copy wp-content, we'll deal with that below
	// We also copy version.php last so failed updates report their old version
	$skip              = array( 'wp-content', 'site-inc/version.php' );
	$check_is_writable = array();

	// Check to see which files don't really need updating - only available for 3.7 and higher
	if ( function_exists( 'get_core_checksums' ) ) {
		// Find the local version of the working directory
		$working_dir_local = WP_CONTENT_DIR . '/upgrade/' . basename( $from ) . $distro;

		$checksums = get_core_checksums( $wp_version, isset( $wp_local_package ) ? $wp_local_package : 'en_US' );
		if ( is_array( $checksums ) && isset( $checksums[ $wp_version ] ) ) {
			$checksums = $checksums[ $wp_version ]; // Compat code for 3.7-beta2
		}
		if ( is_array( $checksums ) ) {
			foreach ( $checksums as $file => $checksum ) {
				if ( 'wp-content' == substr( $file, 0, 10 ) ) {
					continue;
				}
				if ( ! file_exists( ABSPATH . $file ) ) {
					continue;
				}
				if ( ! file_exists( $working_dir_local . $file ) ) {
					continue;
				}
				if ( '.' === dirname( $file ) && in_array( pathinfo( $file, PATHINFO_EXTENSION ), array( 'html', 'txt' ) ) ) {
					continue;
				}
				if ( md5_file( ABSPATH . $file ) === $checksum ) {
					$skip[] = $file;
				} else {
					$check_is_writable[ $file ] = ABSPATH . $file;
				}
			}
		}
	}

	// If we're using the direct method, we can predict write failures that are due to permissions.
	if ( $check_is_writable && 'direct' === $wp_filesystem->method ) {
		$files_writable = array_filter( $check_is_writable, array( $wp_filesystem, 'is_writable' ) );
		if ( $files_writable !== $check_is_writable ) {
			$files_not_writable = array_diff_key( $check_is_writable, $files_writable );
			foreach ( $files_not_writable as $relative_file_not_writable => $file_not_writable ) {
				// If the writable check failed, chmod file to 0644 and try again, same as copy_dir().
				$wp_filesystem->chmod( $file_not_writable, FS_CHMOD_FILE );
				if ( $wp_filesystem->is_writable( $file_not_writable ) ) {
					unset( $files_not_writable[ $relative_file_not_writable ] );
				}
			}

			// Store package-relative paths (the key) of non-writable files in the WP_Error object.
			$error_data = version_compare( $old_wp_version, '3.7-beta2', '>' ) ? array_keys( $files_not_writable ) : '';

			if ( $files_not_writable ) {
				return new WP_Error( 'files_not_writable', __( 'The update cannot be installed because we will be unable to copy some files. This is usually due to inconsistent file permissions.' ), implode( ', ', $error_data ) );
			}
		}
	}

	/** This filter is documented in site-admin/includes/update-core.php */
	apply_filters( 'update_feedback', __( 'Enabling Maintenance mode&#8230;' ) );
	// Create maintenance file to signal that we are upgrading
	$maintenance_string = '<?php $upgrading = ' . time() . '; ?>';
	$maintenance_file   = $to . '.maintenance';
	$wp_filesystem->delete( $maintenance_file );
	$wp_filesystem->put_contents( $maintenance_file, $maintenance_string, FS_CHMOD_FILE );

	/** This filter is documented in site-admin/includes/update-core.php */
	apply_filters( 'update_feedback', __( 'Copying the required files&#8230;' ) );
	// Copy new versions of WP files into place.
	$result = _copy_dir( $from . $distro, $to, $skip );
	if ( is_wp_error( $result ) ) {
		$result = new WP_Error( $result->get_error_code(), $result->get_error_message(), substr( $result->get_error_data(), strlen( $to ) ) );
	}

	// Since we know the core files have copied over, we can now copy the version file
	if ( ! is_wp_error( $result ) ) {
		if ( ! $wp_filesystem->copy( $from . $distro . 'site-inc/version.php', $to . 'site-inc/version.php', true /* overwrite */ ) ) {
			$wp_filesystem->delete( $from, true );
			$result = new WP_Error( 'copy_failed_for_version_file', __( 'The update cannot be installed because we will be unable to copy some files. This is usually due to inconsistent file permissions.' ), 'site-inc/version.php' );
		}
		$wp_filesystem->chmod( $to . 'site-inc/version.php', FS_CHMOD_FILE );
	}

	// Check to make sure everything copied correctly, ignoring the contents of wp-content
	$skip   = array( 'wp-content' );
	$failed = array();
	if ( isset( $checksums ) && is_array( $checksums ) ) {
		foreach ( $checksums as $file => $checksum ) {
			if ( 'wp-content' == substr( $file, 0, 10 ) ) {
				continue;
			}
			if ( ! file_exists( $working_dir_local . $file ) ) {
				continue;
			}
			if ( '.' === dirname( $file ) && in_array( pathinfo( $file, PATHINFO_EXTENSION ), array( 'html', 'txt' ) ) ) {
				$skip[] = $file;
				continue;
			}
			if ( file_exists( ABSPATH . $file ) && md5_file( ABSPATH . $file ) == $checksum ) {
				$skip[] = $file;
			} else {
				$failed[] = $file;
			}
		}
	}

	// Some files didn't copy properly
	if ( ! empty( $failed ) ) {
		$total_size = 0;
		foreach ( $failed as $file ) {
			if ( file_exists( $working_dir_local . $file ) ) {
				$total_size += filesize( $working_dir_local . $file );
			}
		}

		// If we don't have enough free space, it isn't worth trying again.
		// Unlikely to be hit due to the check in unzip_file().
		$available_space = @disk_free_space( ABSPATH );
		if ( $available_space && $total_size >= $available_space ) {
			$result = new WP_Error( 'disk_full', __( 'There is not enough free disk space to complete the update.' ) );
		} else {
			$result = _copy_dir( $from . $distro, $to, $skip );
			if ( is_wp_error( $result ) ) {
				$result = new WP_Error( $result->get_error_code() . '_retry', $result->get_error_message(), substr( $result->get_error_data(), strlen( $to ) ) );
			}
		}
	}

	// Custom Content Directory needs updating now.
	// Copy Languages
	if ( ! is_wp_error( $result ) && $wp_filesystem->is_dir( $from . $distro . 'wp-content/languages' ) ) {
		if ( WP_LANG_DIR != ABSPATH . WPINC . '/languages' || @is_dir( WP_LANG_DIR ) ) {
			$lang_dir = WP_LANG_DIR;
		} else {
			$lang_dir = WP_CONTENT_DIR . '/languages';
		}

		if ( ! @is_dir( $lang_dir ) && 0 === strpos( $lang_dir, ABSPATH ) ) { // Check the language directory exists first
			$wp_filesystem->mkdir( $to . str_replace( ABSPATH, '', $lang_dir ), FS_CHMOD_DIR ); // If it's within the ABSPATH we can handle it here, otherwise they're out of luck.
			clearstatcache(); // for FTP, Need to clear the stat cache
		}

		if ( @is_dir( $lang_dir ) ) {
			$wp_lang_dir = $wp_filesystem->find_folder( $lang_dir );
			if ( $wp_lang_dir ) {
				$result = copy_dir( $from . $distro . 'wp-content/languages/', $wp_lang_dir );
				if ( is_wp_error( $result ) ) {
					$result = new WP_Error( $result->get_error_code() . '_languages', $result->get_error_message(), substr( $result->get_error_data(), strlen( $wp_lang_dir ) ) );
				}
			}
		}
	}

	/** This filter is documented in site-admin/includes/update-core.php */
	apply_filters( 'update_feedback', __( 'Disabling Maintenance mode&#8230;' ) );
	// Remove maintenance file, we're done with potential site-breaking changes
	$wp_filesystem->delete( $maintenance_file );

	// 3.5 -> 3.5+ - an empty twentytwelve directory was created upon upgrade to 3.5 for some users, preventing installation of Twenty Twelve.
	if ( '3.5' == $old_wp_version ) {
		if ( is_dir( WP_CONTENT_DIR . '/themes/twentytwelve' ) && ! file_exists( WP_CONTENT_DIR . '/themes/twentytwelve/style.css' ) ) {
			$wp_filesystem->delete( $wp_filesystem->wp_themes_dir() . 'twentytwelve/' );
		}
	}

	// Copy New bundled plugins & themes
	// This gives us the ability to install new plugins & themes bundled with future versions of WordPress whilst avoiding the re-install upon upgrade issue.
	// $development_build controls us overwriting bundled themes and plugins when a non-stable release is being updated
	if ( ! is_wp_error( $result ) && ( ! defined( 'CORE_UPGRADE_SKIP_NEW_BUNDLED' ) || ! CORE_UPGRADE_SKIP_NEW_BUNDLED ) ) {
		foreach ( (array) $_new_bundled_files as $file => $introduced_version ) {
			// If a $development_build or if $introduced version is greater than what the site was previously running
			if ( $development_build || version_compare( $introduced_version, $old_wp_version, '>' ) ) {
				$directory             = ( '/' == $file[ strlen( $file ) - 1 ] );
				list($type, $filename) = explode( '/', $file, 2 );

				// Check to see if the bundled items exist before attempting to copy them
				if ( ! $wp_filesystem->exists( $from . $distro . 'wp-content/' . $file ) ) {
					continue;
				}

				if ( 'plugins' == $type ) {
					$dest = $wp_filesystem->wp_plugins_dir();
				} elseif ( 'themes' == $type ) {
					$dest = trailingslashit( $wp_filesystem->wp_themes_dir() ); // Back-compat, ::wp_themes_dir() did not return trailingslash'd pre-3.2
				} else {
					continue;
				}

				if ( ! $directory ) {
					if ( ! $development_build && $wp_filesystem->exists( $dest . $filename ) ) {
						continue;
					}

					if ( ! $wp_filesystem->copy( $from . $distro . 'wp-content/' . $file, $dest . $filename, FS_CHMOD_FILE ) ) {
						$result = new WP_Error( "copy_failed_for_new_bundled_$type", __( 'Could not copy file.' ), $dest . $filename );
					}
				} else {
					if ( ! $development_build && $wp_filesystem->is_dir( $dest . $filename ) ) {
						continue;
					}

					$wp_filesystem->mkdir( $dest . $filename, FS_CHMOD_DIR );
					$_result = copy_dir( $from . $distro . 'wp-content/' . $file, $dest . $filename );

					// If a error occurs partway through this final step, keep the error flowing through, but keep process going.
					if ( is_wp_error( $_result ) ) {
						if ( ! is_wp_error( $result ) ) {
							$result = new WP_Error;
						}
						$result->add( $_result->get_error_code() . "_$type", $_result->get_error_message(), substr( $_result->get_error_data(), strlen( $dest ) ) );
					}
				}
			}
		} //end foreach
	}

	// Handle $result error from the above blocks
	if ( is_wp_error( $result ) ) {
		$wp_filesystem->delete( $from, true );
		return $result;
	}

	// Remove old files
	foreach ( $_old_files as $old_file ) {
		$old_file = $to . $old_file;
		if ( ! $wp_filesystem->exists( $old_file ) ) {
			continue;
		}

		// If the file isn't deleted, try writing an empty string to the file instead.
		if ( ! $wp_filesystem->delete( $old_file, true ) && $wp_filesystem->is_file( $old_file ) ) {
			$wp_filesystem->put_contents( $old_file, '' );
		}
	}

	// Remove any Genericons example.html's from the filesystem
	_upgrade_422_remove_genericons();

	// Remove the REST API plugin if its version is Beta 4 or lower
	_upgrade_440_force_deactivate_incompatible_plugins();

	// Upgrade DB with separate request
	/** This filter is documented in site-admin/includes/update-core.php */
	apply_filters( 'update_feedback', __( 'Upgrading database&#8230;' ) );
	$db_upgrade_url = admin_url( 'upgrade.php?step=upgrade_db' );
	wp_remote_post( $db_upgrade_url, array( 'timeout' => 60 ) );

	// Clear the cache to prevent an update_option() from saving a stale db_version to the cache
	wp_cache_flush();
	// (Not all cache back ends listen to 'flush')
	wp_cache_delete( 'alloptions', 'options' );

	// Remove working directory
	$wp_filesystem->delete( $from, true );

	// Force refresh of update information
	if ( function_exists( 'delete_site_transient' ) ) {
		delete_site_transient( 'update_core' );
	} else {
		delete_option( 'update_core' );
	}

	/**
	 * Fires after WordPress core has been successfully updated.
	 *
	 * @since 3.3.0
	 *
	 * @param string $wp_version The current WordPress version.
	 */
	do_action( '_core_updated_successfully', $wp_version );

	// Clear the option that blocks auto updates after failures, now that we've been successful.
	if ( function_exists( 'delete_site_option' ) ) {
		delete_site_option( 'auto_core_update_failed' );
	}

	return $wp_version;
}

/**
 * Copies a directory from one location to another via the WordPress Filesystem Abstraction.
 * Assumes that WP_Filesystem() has already been called and setup.
 *
 * This is a temporary function for the 3.1 -> 3.2 upgrade, as well as for those upgrading to
 * 3.7+
 *
 * @ignore
 * @since 3.2.0
 * @since 3.7.0 Updated not to use a regular expression for the skip list
 * @see copy_dir()
 *
 * @global WP_Filesystem_Base $wp_filesystem
 *
 * @param string $from     source directory
 * @param string $to       destination directory
 * @param array $skip_list a list of files/folders to skip copying
 * @return mixed WP_Error on failure, True on success.
 */
function _copy_dir( $from, $to, $skip_list = array() ) {
	global $wp_filesystem;

	$dirlist = $wp_filesystem->dirlist( $from );

	$from = trailingslashit( $from );
	$to   = trailingslashit( $to );

	foreach ( (array) $dirlist as $filename => $fileinfo ) {
		if ( in_array( $filename, $skip_list ) ) {
			continue;
		}

		if ( 'f' == $fileinfo['type'] ) {
			if ( ! $wp_filesystem->copy( $from . $filename, $to . $filename, true, FS_CHMOD_FILE ) ) {
				// If copy failed, chmod file to 0644 and try again.
				$wp_filesystem->chmod( $to . $filename, FS_CHMOD_FILE );
				if ( ! $wp_filesystem->copy( $from . $filename, $to . $filename, true, FS_CHMOD_FILE ) ) {
					return new WP_Error( 'copy_failed__copy_dir', __( 'Could not copy file.' ), $to . $filename );
				}
			}
		} elseif ( 'd' == $fileinfo['type'] ) {
			if ( ! $wp_filesystem->is_dir( $to . $filename ) ) {
				if ( ! $wp_filesystem->mkdir( $to . $filename, FS_CHMOD_DIR ) ) {
					return new WP_Error( 'mkdir_failed__copy_dir', __( 'Could not create directory.' ), $to . $filename );
				}
			}

			/*
			 * Generate the $sub_skip_list for the subdirectory as a sub-set
			 * of the existing $skip_list.
			 */
			$sub_skip_list = array();
			foreach ( $skip_list as $skip_item ) {
				if ( 0 === strpos( $skip_item, $filename . '/' ) ) {
					$sub_skip_list[] = preg_replace( '!^' . preg_quote( $filename, '!' ) . '/!i', '', $skip_item );
				}
			}

			$result = _copy_dir( $from . $filename, $to . $filename, $sub_skip_list );
			if ( is_wp_error( $result ) ) {
				return $result;
			}
		}
	}
	return true;
}

/**
 * Redirect to the About WordPress page after a successful upgrade.
 *
 * This function is only needed when the existing installation is older than 3.4.0.
 *
 * @since 3.3.0
 *
 * @global string $wp_version
 * @global string $pagenow
 * @global string $action
 *
 * @param string $new_version
 */
function _redirect_to_about_wordpress( $new_version ) {
	global $wp_version, $pagenow, $action;

	if ( version_compare( $wp_version, '3.4-RC1', '>=' ) ) {
		return;
	}

	// Ensure we only run this on the update-core.php page. The Core_Upgrader may be used in other contexts.
	if ( 'update-core.php' != $pagenow ) {
		return;
	}

	if ( 'do-core-upgrade' != $action && 'do-core-reinstall' != $action ) {
		return;
	}

	// Load the updated default text localization domain for new strings.
	load_default_textdomain();

	// See do_core_upgrade()
	show_message( __( 'WordPress updated successfully' ) );

	// self_admin_url() won't exist when upgrading from <= 3.0, so relative URLs are intentional.
	show_message( '<span class="hide-if-no-js">' . sprintf( __( 'Welcome to WordPress %1$s. You will be redirected to the About WordPress screen. If not, click <a href="%2$s">here</a>.' ), $new_version, 'about.php?updated' ) . '</span>' );
	show_message( '<span class="hide-if-js">' . sprintf( __( 'Welcome to WordPress %1$s. <a href="%2$s">Learn more</a>.' ), $new_version, 'about.php?updated' ) . '</span>' );
	echo '</div>';
	?>
<script type="text/javascript">
window.location = 'about.php?updated';
</script>
	<?php

	// Include admin-footer.php and exit.
	include( ABSPATH . 'site-admin/admin-footer.php' );
	exit();
}

/**
 * Cleans up Genericons example files.
 *
 * @since 4.2.2
 *
 * @global array              $wp_theme_directories
 * @global WP_Filesystem_Base $wp_filesystem
 */
function _upgrade_422_remove_genericons() {
	global $wp_theme_directories, $wp_filesystem;

	// A list of the affected files using the filesystem absolute paths.
	$affected_files = array();

	// Themes
	foreach ( $wp_theme_directories as $directory ) {
		$affected_theme_files = _upgrade_422_find_genericons_files_in_folder( $directory );
		$affected_files       = array_merge( $affected_files, $affected_theme_files );
	}

	// Plugins
	$affected_plugin_files = _upgrade_422_find_genericons_files_in_folder( WP_PLUGIN_DIR );
	$affected_files        = array_merge( $affected_files, $affected_plugin_files );

	foreach ( $affected_files as $file ) {
		$gen_dir = $wp_filesystem->find_folder( trailingslashit( dirname( $file ) ) );
		if ( empty( $gen_dir ) ) {
			continue;
		}

		// The path when the file is accessed via WP_Filesystem may differ in the case of FTP
		$remote_file = $gen_dir . basename( $file );

		if ( ! $wp_filesystem->exists( $remote_file ) ) {
			continue;
		}

		if ( ! $wp_filesystem->delete( $remote_file, false, 'f' ) ) {
			$wp_filesystem->put_contents( $remote_file, '' );
		}
	}
}

/**
 * Recursively find Genericons example files in a given folder.
 *
 * @ignore
 * @since 4.2.2
 *
 * @param string $directory Directory path. Expects trailingslashed.
 * @return array
 */
function _upgrade_422_find_genericons_files_in_folder( $directory ) {
	$directory = trailingslashit( $directory );
	$files     = array();

	if ( file_exists( "{$directory}example.html" ) && false !== strpos( file_get_contents( "{$directory}example.html" ), '<title>Genericons</title>' ) ) {
		$files[] = "{$directory}example.html";
	}

	$dirs = glob( $directory . '*', GLOB_ONLYDIR );
	if ( $dirs ) {
		foreach ( $dirs as $dir ) {
			$files = array_merge( $files, _upgrade_422_find_genericons_files_in_folder( $dir ) );
		}
	}

	return $files;
}

/**
 * @ignore
 * @since 4.4.0
 */
function _upgrade_440_force_deactivate_incompatible_plugins() {
	if ( defined( 'REST_API_VERSION' ) && version_compare( REST_API_VERSION, '2.0-beta4', '<=' ) ) {
		deactivate_plugins( array( 'rest-api/plugin.php' ), true );
	}
}
