<?php
namespace Automattic\Kkart\Blocks\BlockTypes;

/**
 * AllProducts class.
 */
class AllProducts extends AbstractDynamicBlock {
	/**
	 * Block name.
	 *
	 * @var string
	 */
	protected $block_name = 'all-products';

	/**
	 * Registers the block type with WordPress.
	 */
	public function register_block_type() {
		register_block_type(
			$this->namespace . '/' . $this->block_name,
			array(
				'render_callback' => array( $this, 'render' ),
				'editor_script'   => 'kkart-' . $this->block_name,
				'editor_style'    => 'kkart-block-editor',
				'style'           => 'kkart-block-style',
				'script'          => 'kkart-' . $this->block_name . '-frontend',
				'supports'        => [],
			)
		);
	}

	/**
	 * Append frontend scripts when rendering the Product Categories List block.
	 *
	 * @param array  $attributes Block attributes. Default empty array.
	 * @param string $content    Block content. Default empty string.
	 * @return string Rendered block type output.
	 */
	public function render( $attributes = array(), $content = '' ) {
		\Automattic\Kkart\Blocks\Assets::register_block_script( $this->block_name . '-frontend' );

		return $content;
	}
}
