<?php

/**
 * Class ActionScheduler_wpPostStore_PostTypeRegistrar
 * @codeCoverageIgnore
 */
class ActionScheduler_wpPostStore_PostTypeRegistrar {
	public function register() {
		register_post_type( ActionScheduler_wpPostStore::POST_TYPE, $this->post_type_args() );
	}

	/**
	 * Build the args array for the post type definition
	 *
	 * @return array
	 */
	protected function post_type_args() {
		$args = array(
			'label' => __( 'Scheduled Actions', 'kkart' ),
			'description' => __( 'Scheduled actions are hooks triggered on a cetain date and time.', 'kkart' ),
			'public' => false,
			'map_meta_cap' => true,
			'hierarchical' => false,
			'supports' => array('title', 'editor','comments'),
			'rewrite' => false,
			'query_var' => false,
			'can_export' => true,
			'ep_mask' => EP_NONE,
			'labels' => array(
				'name' => __( 'Scheduled Actions', 'kkart' ),
				'singular_name' => __( 'Scheduled Action', 'kkart' ),
				'menu_name' => _x( 'Scheduled Actions', 'Admin menu name', 'kkart' ),
				'add_new' => __( 'Add', 'kkart' ),
				'add_new_item' => __( 'Add New Scheduled Action', 'kkart' ),
				'edit' => __( 'Edit', 'kkart' ),
				'edit_item' => __( 'Edit Scheduled Action', 'kkart' ),
				'new_item' => __( 'New Scheduled Action', 'kkart' ),
				'view' => __( 'View Action', 'kkart' ),
				'view_item' => __( 'View Action', 'kkart' ),
				'search_items' => __( 'Search Scheduled Actions', 'kkart' ),
				'not_found' => __( 'No actions found', 'kkart' ),
				'not_found_in_trash' => __( 'No actions found in trash', 'kkart' ),
			),
		);

		$args = apply_filters('action_scheduler_post_type_args', $args);
		return $args;
	}
}
 