<?php
/*
 * This file is part of EC-CUBE
 *
 * Copyright(c) 2000-2012 LOCKON CO.,LTD. All Rights Reserved.
 *
 * http://www.lockon.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

//---- アップロードファイル加工クラス(thumb.phpとセットで使用する)
class SC_Image {

    var $tmp_dir;

    function __construct($tmp_dir) {
        // ヘッダファイル読込
        $this->tmp_dir = rtrim($tmp_dir, '/') . '/';
    }

    //--- 一時ファイル生成(サムネイル画像生成用)
    function makeTempImage($keyname, $max_width, $max_height) {
        // 一意なIDを取得する。
        $mainname = uniqid('').'.';
        // 拡張子以外を置き換える。
        $newFileName = preg_replace("/^.*\./", $mainname, $_FILES[$keyname]['name']);
        $result  = $this->MakeThumb($_FILES[$keyname]['tmp_name'], $this->tmp_dir , $max_width, $max_height, $newFileName);
        GC_Utils_Ex::gfDebugLog($result);
        return $newFileName;
    }

    //--- ファイルを指定保存DIRへ移動
    function moveTempImage($filename, $save_dir) {
        // コピー元ファイル、コピー先ディレクトリが存在する場合にのみ実行する
        $from_path = $this->tmp_dir.$filename;
        $to_path = $save_dir.'/'.$filename;
        if (file_exists($from_path) && file_exists($save_dir)) {
            if (copy($from_path , $to_path)) {
                unlink($from_path);
            }
        } else {
            $tokens = array(
                'T_ARG1' => $from_path,
                'T_ARG2' => $to_path
            );
            GC_Utils_Ex::gfDebugLog(t('c_Copying of T_ARG1->T_ARG2 failed._01', $tokens));
        }
    }

    //---- 指定ファイルを削除
    function deleteImage($filename, $dir) {
        if (file_exists($dir.'/'.$filename)) {
            unlink($dir.'/'.$filename);
        }
    }

    /**
     * 指定サイズで画像を出力する.
     *
     * @param string $FromImgPath ファイル名までのパス
     * @param string $ToImgPath 出力先パス
     * @param integer $tmpMW 最大横幅
     * @param integer $tmpMH 最大縦幅
     * @param integer $newFileName 新ファイル名
     * @param array 新ファイル名を格納した配列
     */
    function MakeThumb($FromImgPath , $ToImgPath , $tmpMW , $tmpMH, $newFileName = '') {
        // 画像の最大横幅（単位：ピクセル）
        $ThmMaxWidth = LARGE_IMAGE_WIDTH;

        // 画像の最大縦幅（単位：ピクセル）
        $ThmMaxHeight = LARGE_IMAGE_HEIGHT;

        //サムネイル画像の接頭文字
        $PreWord = $head;

        //拡張子取得
        $array_ext = explode('.', $FromImgPath);
        $ext = $array_ext[count($array_ext) - 1];

        $MW = $ThmMaxWidth;
        if ($tmpMW) $MW = $tmpMW; // $MWに最大横幅セット

        $MH = $ThmMaxHeight;
        if ($tmpMH) $MH = $tmpMH; // $MHに最大縦幅セット

        if (empty($FromImgPath) || empty($ToImgPath)) {
            return array(0,  t('c_The output source image path or the output destination folder has not been designated._01'));
        }

        if (!file_exists($FromImgPath)) {
            return array(0,  t('c_The output source image was not found._01'));
        }

        $size = @GetImageSize($FromImgPath);
        $re_size = $size;

        // 画像の種類が不明 or swf
        if (!$size[2] || $size[2] > 3) {
            return array(0,  t('c_The image format is not supported._01'));
        }

        //アスペクト比固定処理
        $tmp_w = $size[0] / $MW;

        if ($MH != 0) {
            $tmp_h = $size[1] / $MH;
        }

        if ($tmp_w > 1 || $tmp_h > 1) {
            if ($MH == 0) {
                if ($tmp_w > 1) {
                    $re_size[0] = $MW;
                    $re_size[1] = $size[1] * $MW / $size[0];
                }
            } else {
                if ($tmp_w > $tmp_h) {
                    $re_size[0] = $MW;
                    $re_size[1] = $size[1] * $MW / $size[0];
                } else {
                    $re_size[1] = $MH;
                    $re_size[0] = $size[0] * $MH / $size[1];
                }
            }
        }

        // サムネイル画像ファイル名作成処理
        $tmp = array_pop(explode('/',$FromImgPath)); // /の一番最後を切り出し
        $FromFileName = array_shift(explode('.',$tmp)); // .で区切られた部分を切り出し
        $ToFile = $PreWord.$FromFileName; // 拡張子以外の部分までを作成

        $ImgNew = imagecreatetruecolor($re_size[0],$re_size[1]);

        switch ($size[2]) {
            case '1': //gif形式
                if ($tmp_w <= 1 && $tmp_h <= 1) {
                    if ($newFileName) {
                        $ToFile = $newFileName;
                    } elseif ($ext) {
                        $ToFile .= '.' . $ext;
                    } else {
                        $ToFile .= '.gif';
                    }
                    if (!@copy($FromImgPath , $ToImgPath.$ToFile)) { // エラー処理
                        return array(0,  t('c_File copying failed._01'));
                    }
                    ImageDestroy($ImgNew);
                    return array(1,$ToFile);
                }

                ImageColorAllocate($ImgNew,255,235,214); //背景色
                $black = ImageColorAllocate($ImgNew,0,0,0);
                $red = ImageColorAllocate($ImgNew,255,0,0);
                Imagestring($ImgNew,4,5,5,"GIF $size[0]x$size[1]", $red);
                ImageRectangle ($ImgNew,0,0,($re_size[0]-1),($re_size[1]-1),    $black);

                if ($newFileName) {
                    $ToFile = $newFileName;
                } elseif ($ext) {
                    $ToFile .= '.' . $ext;
                } else {
                    $ToFile .= '.png';
                }
                $TmpPath = $ToImgPath.$ToFile;
                @Imagepng($ImgNew,$TmpPath);
                // 画像が作成されていない場合
                if (!@file_exists($TmpPath)) {
                    return array(0,  t('c_Image output failed._01'));
                }
                ImageDestroy($ImgNew);
                return array(1,$ToFile);

            case '2': //jpg形式
                $ImgDefault = ImageCreateFromJpeg($FromImgPath);
                //ImageCopyResized($ImgNew,$ImgDefault, 0, 0, 0, 0,$re_size[0], $re_size[1],$size[0], $size[1]);

                if ($re_size[0] != $size[0] || $re_size[0] != $size[0]) {
                    ImageCopyResampled($ImgNew,$ImgDefault, 0, 0, 0, 0,$re_size[0], $re_size[1],$size[0], $size[1]);
                }

                GC_Utils_Ex::gfDebugLog($size);
                GC_Utils_Ex::gfDebugLog($re_size);

                if ($newFileName) {
                    $ToFile = $newFileName;
                } elseif ($ext) {
                    $ToFile .= '.' . $ext;
                } else {
                    $ToFile .= '.jpg';
                }
                $TmpPath = $ToImgPath.$ToFile;
                @ImageJpeg($ImgNew,$TmpPath);
                // 画像が作成されていない場合
                if (!@file_exists($TmpPath)) {
                    return array(0,  t('c_Image output failed._01')."<br>${ImgNew}<br>${TmpPath}");
                }
                $RetVal = $ToFile;
                break;

            case '3': //png形式
                $ImgDefault = ImageCreateFromPNG($FromImgPath);
                //ImageCopyResized($ImgNew, $ImgDefault, 0, 0, 0, 0,$re_size[0], $re_size[1],$size[0], $size[1]);
                ImageCopyResampled($ImgNew, $ImgDefault, 0, 0, 0, 0,$re_size[0], $re_size[1],$size[0], $size[1]);

                if ($newFileName) {
                    $ToFile = $newFileName;
                } elseif ($ext) {
                    $ToFile .= '.' . $ext;
                } else {
                    $ToFile .= '.png';
                }
                $TmpPath = $ToImgPath.$ToFile;
                @ImagePNG($ImgNew,$TmpPath);
                // 画像が作成されていない場合
                if (!@file_exists($TmpPath)) {
                    return array(0,  t('c_Image output failed._01'));
                }
                $RetVal = $ToFile;
                break;
        }

        ImageDestroy($ImgDefault);
        ImageDestroy($ImgNew);

        return array(1,$RetVal);
    }
}
