<?php
/*
 * This file is part of EC-CUBE
 *
 * Copyright(c) 2000-2012 LOCKON CO.,LTD. All Rights Reserved.
 *
 * http://www.lockon.co.jp/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

// {{{ requires
require_once CLASS_EX_REALDIR . 'page_extends/admin/LC_Page_Admin_Ex.php';

/**
 * メールテンプレート設定 のページクラス.
 *
 * @package Page
 * @author LOCKON CO.,LTD.
 * @version $Id: LC_Page_Admin_Mail_Template.php 22505 2013-02-05 12:31:33Z kim $
 */
class LC_Page_Admin_Mail_Template extends LC_Page_Admin_Ex {

    // }}}
    // {{{ functions

    /**
     * Page を初期化する.
     *
     * @return void
     */
    function init() {
        parent::init();
        $this->tpl_mainpage = 'mail/template.tpl';
        $this->tpl_mainno = 'mail';
        $this->tpl_subno = 'template';
        $this->tpl_maintitle = t('c_Mail magazine_02');
        $this->tpl_subtitle = t('c_Template settings_02');

        $masterData = new SC_DB_MasterData_Ex();
        $this->arrMagazineType = $masterData->getMasterData('mtb_magazine_type');
    }

    /**
     * Page のプロセス.
     *
     * @return void
     */
    function process() {
        $this->action();
        $this->sendResponse();
    }

    /**
     * Page のアクション.
     *
     * @return void
     */
    function action() {

        $objMailHelper = new SC_Helper_Mail_Ex();

        switch ($this->getMode()) {
            case 'delete':
                if (SC_Utils_Ex::sfIsInt($_GET['id'])===true) {
                    $this->lfDeleteMailTemplate($_GET['id']);

                    $this->objDisplay->reload(null, true);
                }
                break;
            default:
                break;
        }
        $this->arrTemplates = $objMailHelper->sfGetMailmagaTemplate();

    }

    /**
     * デストラクタ.
     *
     * @return void
     */
    function destroy() {
        parent::destroy();
    }

    /**
     * メールテンプレートの削除
     * @param integer 削除したいテンプレートのID
     * @return void
     */
    function lfDeleteMailTemplate($template_id) {
        $objQuery =& SC_Query_Ex::getSingletonInstance();
        $objQuery->update('dtb_mailmaga_template',
                          array('del_flg' =>1),
                          'template_id = ?',
                          array($template_id));
    }

}
