
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `dolph742`
--

-- --------------------------------------------------------

--
-- Table structure for table `Profiles`
--

CREATE TABLE `Profiles` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `NickName` varchar(255) NOT NULL DEFAULT '',
  `Email` varchar(255) NOT NULL DEFAULT '',
  `Password` varchar(40) NOT NULL DEFAULT '',
  `Salt` varchar(10) NOT NULL DEFAULT '',
  `Status` enum('Unconfirmed','Approval','Active','Rejected','Suspended') NOT NULL DEFAULT 'Unconfirmed',
  `Role` tinyint(4) unsigned NOT NULL DEFAULT '1',
  `Couple` int(10) unsigned NOT NULL DEFAULT '0',
  `Sex` varchar(255) NOT NULL DEFAULT '',
  `LookingFor` set('male','female') NOT NULL DEFAULT '',
  `DescriptionMe` text NOT NULL,
  `Country` varchar(255) NOT NULL DEFAULT '',
  `City` varchar(255) NOT NULL,
  `DateOfBirth` date NOT NULL,
  `Featured` tinyint(1) NOT NULL DEFAULT '0',
  `DateReg` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `DateLastEdit` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `DateLastLogin` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `DateLastNav` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `aff_num` int(10) unsigned NOT NULL DEFAULT '0',
  `Tags` varchar(255) NOT NULL DEFAULT '',
  `zip` varchar(255) NOT NULL,
  `EmailNotify` tinyint(1) NOT NULL DEFAULT '1',
  `LangID` int(11) NOT NULL,
  `UpdateMatch` tinyint(1) NOT NULL DEFAULT '1',
  `Views` int(11) NOT NULL,
  `Rate` float NOT NULL,
  `RateCount` int(11) NOT NULL,
  `CommentsCount` int(11) NOT NULL,
  `PrivacyDefaultGroup` int(11) NOT NULL DEFAULT '3',
  `allow_view_to` int(11) NOT NULL DEFAULT '3',
  `UserStatus` varchar(64) NOT NULL DEFAULT 'online',
  `UserStatusMessage` varchar(255) NOT NULL DEFAULT '',
  `UserStatusMessageWhen` int(10) NOT NULL,
  `Avatar` int(10) unsigned NOT NULL,
  `Height` varchar(255) NOT NULL,
  `Weight` varchar(255) NOT NULL,
  `Income` varchar(255) NOT NULL,
  `Occupation` varchar(255) NOT NULL,
  `Religion` varchar(255) NOT NULL,
  `Education` varchar(255) NOT NULL,
  `RelationshipStatus` enum('Single','In a Relationship','Engaged','Married','It''s Complicated','In an Open Relationship') DEFAULT NULL,
  `Hobbies` text NOT NULL,
  `Interests` text NOT NULL,
  `Ethnicity` varchar(255) NOT NULL,
  `FavoriteSites` text NOT NULL,
  `FavoriteMusic` text NOT NULL,
  `FavoriteFilms` text NOT NULL,
  `FavoriteBooks` text NOT NULL,
  `FullName` varchar(255) NOT NULL,
  `FirstName` varchar(255) NOT NULL,
  `LastName` varchar(255) NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `NickName` (`NickName`),
  KEY `Country` (`Country`),
  KEY `DateOfBirth` (`DateOfBirth`),
  KEY `DateReg` (`DateReg`),
  KEY `DateLastNav` (`DateLastNav`),
  FULLTEXT KEY `NickName_2` (`NickName`,`FullName`,`FirstName`,`LastName`,`City`,`DescriptionMe`,`Tags`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `Profiles`
--

INSERT INTO `Profiles` VALUES
(1, '[[admin_username]]', '[[admin_email]]', '[[admin_pass]]', '[[salt]]', 'Active', 3, 0, '', '', '', '', '', '0000-00-00', 0, '[[regtime]]', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', '', 1, 0, 1, 0, 0, 0, 0, 3, 3, 'online', '', 0, 0, '', '', '', '', '', '', NULL, '', '', '', '', '', '', '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `RayBoardBoards`
--

CREATE TABLE `RayBoardBoards` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) NOT NULL DEFAULT '',
  `Password` varchar(255) NOT NULL DEFAULT '',
  `OwnerID` varchar(20) NOT NULL DEFAULT '0',
  `When` int(11) DEFAULT NULL,
  `Status` enum('new','normal','delete') NOT NULL DEFAULT 'new',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `RayBoardCurrentUsers`
--

CREATE TABLE `RayBoardCurrentUsers` (
  `ID` varchar(20) NOT NULL DEFAULT '',
  `Nick` varchar(255) NOT NULL,
  `Sex` enum('M','F') NOT NULL DEFAULT 'M',
  `Age` int(11) NOT NULL DEFAULT '0',
  `Photo` varchar(255) NOT NULL DEFAULT '',
  `Profile` varchar(255) NOT NULL DEFAULT '',
  `Desc` varchar(255) NOT NULL,
  `When` int(11) NOT NULL DEFAULT '0',
  `Status` enum('new','old','idle') NOT NULL DEFAULT 'new',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `RayBoardUsers`
--

CREATE TABLE `RayBoardUsers` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Board` int(11) NOT NULL DEFAULT '0',
  `User` varchar(20) NOT NULL DEFAULT '',
  `When` int(11) DEFAULT NULL,
  `Status` enum('normal','delete') NOT NULL DEFAULT 'normal',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `RayChatCurrentUsers`
--

CREATE TABLE `RayChatCurrentUsers` (
  `ID` varchar(20) NOT NULL DEFAULT '',
  `Nick` varchar(36) NOT NULL DEFAULT '',
  `Sex` enum('M','F') NOT NULL DEFAULT 'M',
  `Age` int(11) NOT NULL DEFAULT '0',
  `Desc` text NOT NULL,
  `Photo` varchar(255) NOT NULL DEFAULT '',
  `Profile` varchar(255) NOT NULL DEFAULT '',
  `Online` varchar(10) NOT NULL DEFAULT 'online',
  `Start` int(11) NOT NULL DEFAULT '0',
  `When` int(11) NOT NULL DEFAULT '0',
  `Status` enum('new','old','idle','kick','type','online') NOT NULL DEFAULT 'new',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `RayChatHistory`
--

CREATE TABLE `RayChatHistory` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Room` int(11) NOT NULL DEFAULT '0',
  `SndRcp` varchar(40) NOT NULL DEFAULT '',
  `Sender` varchar(20) NOT NULL DEFAULT '',
  `Recipient` varchar(20) NOT NULL DEFAULT '',
  `Message` text NOT NULL,
  `When` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `RayChatMemberships`
--

CREATE TABLE `RayChatMemberships` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Setting` int(11) NOT NULL DEFAULT '0',
  `Value` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `Membership` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `RayChatMembershipsSettings`
--

CREATE TABLE `RayChatMembershipsSettings` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `Caption` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `Type` enum('boolean','number','custom') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'boolean',
  `Default` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `Range` int(3) NOT NULL DEFAULT '3',
  `Error` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Name` (`Name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=13 ;

--
-- Dumping data for table `RayChatMembershipsSettings`
--

INSERT INTO `RayChatMembershipsSettings` VALUES
(1, 'RoomCreate', 'New Rooms Creating:', 'boolean', 'true', 1, 'RayzRoomCreate'),
(2, 'PrivateRoomCreate', 'Private Rooms Creating:', 'boolean', 'true', 1, 'RayzPrivateRoomCreate'),
(3, 'AVCasting', 'Audio/Video Casting:', 'boolean', 'true', 1, 'RayzAVCasting'),
(4, 'AVPlaying', 'Audio/Video Playing (for Messenger):', 'boolean', 'true', 1, 'RayzAVPlaying'),
(5, 'AVLargeWindow', 'Enable Large Video Window:', 'boolean', 'true', 1, 'RayzAVLargeWindow'),
(6, 'FileSend', 'Files Sending:', 'boolean', 'true', 1, 'RayzFileSend'),
(7, 'WhisperMessages', 'Whispering Messages:', 'boolean', 'true', 1, 'RayzWhisperMessages'),
(8, 'DirectMessages', 'Addressed Messages:', 'boolean', 'true', 1, 'RayzDirectMessages'),
(9, 'RoomsNumber', 'Maximum Rooms Number:', 'number', '100', 3, 'RayzRoomsNumber'),
(10, 'ChatsNumber', 'Maximum Private Chats Number:', 'number', '100', 3, 'RayzChatsNumber'),
(11, 'AVWindowsNumber', 'Maximum Video Windows Number:', 'number', '100', 3, 'RayzAVWindowsNumber'),
(12, 'RestrictedRooms', 'Restricted Rooms:', 'custom', '', 1, 'RayzRestrictedRooms');

-- --------------------------------------------------------

--
-- Table structure for table `RayChatMessages`
--

CREATE TABLE `RayChatMessages` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Room` int(11) NOT NULL DEFAULT '0',
  `SndRcp` varchar(40) NOT NULL DEFAULT '',
  `Sender` varchar(20) NOT NULL DEFAULT '',
  `Recipient` varchar(20) NOT NULL DEFAULT '',
  `Whisper` enum('true','false') NOT NULL DEFAULT 'false',
  `Message` text NOT NULL,
  `Style` text NOT NULL,
  `Type` varchar(10) NOT NULL DEFAULT 'text',
  `When` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `RayChatProfiles`
--

CREATE TABLE `RayChatProfiles` (
  `ID` varchar(20) NOT NULL DEFAULT '0',
  `Banned` enum('true','false') NOT NULL DEFAULT 'false',
  `Type` varchar(10) NOT NULL DEFAULT 'full',
  `Smileset` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `RayChatRooms`
--

CREATE TABLE `RayChatRooms` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) NOT NULL DEFAULT '',
  `Password` varchar(255) NOT NULL DEFAULT '',
  `Desc` text NOT NULL,
  `OwnerID` varchar(20) NOT NULL DEFAULT '0',
  `When` int(11) DEFAULT NULL,
  `Status` enum('normal','delete') NOT NULL DEFAULT 'normal',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Name` (`Name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `RayChatRooms`
--

INSERT INTO `RayChatRooms` VALUES
(1, 'Lobby', '', 'Welcome to our chat! You are in the "Lobby" now, but you can pass into any other public room you wish to - take a look at the "All rooms" box.', '0', 0, 'normal'),
(2, 'Friends', '', 'Welcome to the "Friends" room! This is a public room where you can have a fun chat with existing friends or make new ones! Enjoy!', '0', 1, 'normal');

-- --------------------------------------------------------

--
-- Table structure for table `RayChatRoomsUsers`
--

CREATE TABLE `RayChatRoomsUsers` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Room` int(11) NOT NULL DEFAULT '0',
  `User` varchar(20) NOT NULL DEFAULT '',
  `When` int(11) DEFAULT NULL,
  `Status` enum('normal','delete') NOT NULL DEFAULT 'normal',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `RayImContacts`
--

CREATE TABLE `RayImContacts` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `SenderID` int(11) NOT NULL DEFAULT '0',
  `RecipientID` int(11) NOT NULL DEFAULT '0',
  `Online` varchar(10) NOT NULL DEFAULT 'online',
  `When` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `RayImMessages`
--

CREATE TABLE `RayImMessages` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ContactID` int(11) NOT NULL DEFAULT '0',
  `Message` text NOT NULL,
  `Style` text NOT NULL,
  `Type` varchar(10) NOT NULL DEFAULT 'text',
  `When` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `RayImPendings`
--

CREATE TABLE `RayImPendings` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `SenderID` int(11) NOT NULL DEFAULT '0',
  `RecipientID` int(11) NOT NULL DEFAULT '0',
  `Message` varchar(255) NOT NULL DEFAULT '',
  `When` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `RecipientID` (`RecipientID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `RayImProfiles`
--

CREATE TABLE `RayImProfiles` (
  `ID` int(11) NOT NULL DEFAULT '0',
  `Smileset` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `RayMp3Files`
--

CREATE TABLE `RayMp3Files` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Categories` text NOT NULL,
  `Title` varchar(255) NOT NULL DEFAULT '',
  `Uri` varchar(255) NOT NULL DEFAULT '',
  `Tags` text NOT NULL,
  `Description` text NOT NULL,
  `Time` int(11) NOT NULL DEFAULT '0',
  `Date` int(20) NOT NULL DEFAULT '0',
  `Reports` int(11) NOT NULL DEFAULT '0',
  `Owner` varchar(64) NOT NULL DEFAULT '',
  `Listens` int(12) DEFAULT '0',
  `Rate` float NOT NULL,
  `RateCount` int(11) NOT NULL,
  `CommentsCount` int(11) NOT NULL,
  `Featured` tinyint(4) NOT NULL,
  `Status` enum('approved','disapproved','pending','processing','failed') NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Uri` (`Uri`),
  KEY `Owner` (`Owner`),
  FULLTEXT KEY `ftMain` (`Title`,`Tags`,`Description`,`Categories`),
  FULLTEXT KEY `ftTags` (`Tags`),
  FULLTEXT KEY `ftCategories` (`Categories`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `RayMp3Tokens`
--

CREATE TABLE `RayMp3Tokens` (
  `ID` int(11) NOT NULL DEFAULT '0',
  `Token` varchar(32) NOT NULL DEFAULT '',
  `Date` int(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`,`Token`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `RayShoutboxMessages`
--

CREATE TABLE `RayShoutboxMessages` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `UserID` varchar(20) NOT NULL DEFAULT '0',
  `Msg` text NOT NULL,
  `When` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `RayVideoFiles`
--

CREATE TABLE `RayVideoFiles` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Categories` text NOT NULL,
  `Title` varchar(255) NOT NULL DEFAULT '',
  `Uri` varchar(255) NOT NULL DEFAULT '',
  `Tags` text NOT NULL,
  `Description` text NOT NULL,
  `Time` int(11) NOT NULL DEFAULT '0',
  `Date` int(20) NOT NULL DEFAULT '0',
  `Owner` varchar(64) NOT NULL DEFAULT '',
  `Views` int(12) DEFAULT '0',
  `Rate` float NOT NULL,
  `RateCount` int(11) NOT NULL,
  `CommentsCount` int(11) NOT NULL,
  `Featured` tinyint(4) NOT NULL,
  `Status` enum('approved','disapproved','pending','processing','failed') NOT NULL DEFAULT 'pending',
  `Source` varchar(20) NOT NULL DEFAULT '',
  `Video` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Uri` (`Uri`),
  KEY `Owner` (`Owner`),
  FULLTEXT KEY `ftMain` (`Title`,`Tags`,`Description`,`Categories`),
  FULLTEXT KEY `ftTags` (`Tags`),
  FULLTEXT KEY `ftCategories` (`Categories`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `RayVideoTokens`
--

CREATE TABLE `RayVideoTokens` (
  `ID` int(11) NOT NULL DEFAULT '0',
  `Token` varchar(32) NOT NULL DEFAULT '',
  `Date` int(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`,`Token`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `RayVideo_commentsFiles`
--

CREATE TABLE `RayVideo_commentsFiles` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Categories` text NOT NULL,
  `Title` varchar(255) NOT NULL DEFAULT '',
  `Uri` varchar(255) NOT NULL DEFAULT '',
  `Tags` text NOT NULL,
  `Description` text NOT NULL,
  `Time` int(11) NOT NULL DEFAULT '0',
  `Date` int(20) NOT NULL DEFAULT '0',
  `Owner` varchar(64) NOT NULL DEFAULT '',
  `Views` int(12) DEFAULT '0',
  `Status` enum('approved','disapproved','pending','processing','failed') NOT NULL DEFAULT 'pending',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Uri` (`Uri`),
  KEY `Owner` (`Owner`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `RayVideo_commentsTokens`
--

CREATE TABLE `RayVideo_commentsTokens` (
  `ID` int(11) NOT NULL DEFAULT '0',
  `Token` varchar(32) NOT NULL DEFAULT '',
  `Date` int(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`,`Token`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_account_custom_stat_elements`
--

CREATE TABLE `sys_account_custom_stat_elements` (
  `ID` int(2) NOT NULL AUTO_INCREMENT,
  `Label` varchar(128) NOT NULL,
  `Value` varchar(255) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_acl_actions`
--

CREATE TABLE `sys_acl_actions` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) NOT NULL DEFAULT '',
  `AdditionalParamName` varchar(80) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `sys_acl_actions`
--

INSERT INTO `sys_acl_actions` VALUES
(1, 'send greetings', NULL),
(2, 'view profiles', NULL),
(3, 'vote', NULL),
(4, 'send messages', NULL),
(5, 'get other members emails', NULL),
(6, 'comments post', NULL),
(7, 'comments vote', NULL),
(8, 'comments edit own', NULL),
(9, 'comments remove own', NULL),
(10, 'send friend request', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `sys_acl_actions_track`
--

CREATE TABLE `sys_acl_actions_track` (
  `IDAction` smallint(5) unsigned NOT NULL DEFAULT '0',
  `IDMember` int(10) unsigned NOT NULL DEFAULT '0',
  `ActionsLeft` smallint(5) unsigned NOT NULL DEFAULT '0',
  `ValidSince` datetime DEFAULT NULL,
  PRIMARY KEY (`IDAction`,`IDMember`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_acl_levels`
--

CREATE TABLE `sys_acl_levels` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(100) NOT NULL DEFAULT '',
  `Icon` varchar(255) NOT NULL DEFAULT '',
  `Description` text NOT NULL,
  `Active` enum('yes','no') NOT NULL DEFAULT 'no',
  `Purchasable` enum('yes','no') NOT NULL DEFAULT 'yes',
  `Removable` enum('yes','no') NOT NULL DEFAULT 'yes',
  `Order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Name` (`Name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `sys_acl_levels`
--

INSERT INTO `sys_acl_levels` VALUES
(1, 'Non-member', 'non-member.png', '', 'yes', 'no', 'no', 0),
(2, 'Standard', 'member.png', '', 'yes', 'no', 'no', 0),
(3, 'Promotion', 'promotion.png', '', 'yes', 'no', 'no', 0);

-- --------------------------------------------------------

--
-- Table structure for table `sys_acl_levels_members`
--

CREATE TABLE `sys_acl_levels_members` (
  `IDMember` int(10) unsigned NOT NULL DEFAULT '0',
  `IDLevel` smallint(5) unsigned NOT NULL DEFAULT '0',
  `DateStarts` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `DateExpires` datetime DEFAULT NULL,
  `TransactionID` varchar(16) NOT NULL DEFAULT '',
  `Expiring` tinyint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`IDMember`,`IDLevel`,`DateStarts`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_acl_level_prices`
--

CREATE TABLE `sys_acl_level_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `IDLevel` smallint(5) unsigned NOT NULL DEFAULT '0',
  `Days` int(10) unsigned NOT NULL DEFAULT '1',
  `Price` float unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`IDLevel`,`Days`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_acl_matrix`
--

CREATE TABLE `sys_acl_matrix` (
  `IDLevel` smallint(5) unsigned NOT NULL DEFAULT '0',
  `IDAction` smallint(5) unsigned NOT NULL DEFAULT '0',
  `AllowedCount` smallint(5) unsigned DEFAULT NULL,
  `AllowedPeriodLen` smallint(5) unsigned DEFAULT NULL,
  `AllowedPeriodStart` datetime DEFAULT NULL,
  `AllowedPeriodEnd` datetime DEFAULT NULL,
  `AdditionalParamValue` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`IDLevel`,`IDAction`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_acl_matrix`
--

INSERT INTO `sys_acl_matrix` VALUES
(1, 2, NULL, NULL, NULL, NULL, NULL),
(1, 3, NULL, NULL, NULL, NULL, NULL),
(1, 7, NULL, NULL, NULL, NULL, NULL),
(2, 1, 4, 24, NULL, NULL, NULL),
(2, 2, NULL, NULL, NULL, NULL, NULL),
(2, 3, NULL, NULL, NULL, NULL, NULL),
(2, 4, 10, 24, NULL, NULL, NULL),
(2, 6, NULL, NULL, NULL, NULL, NULL),
(2, 7, NULL, NULL, NULL, NULL, NULL),
(2, 8, NULL, NULL, NULL, NULL, NULL),
(2, 9, NULL, NULL, NULL, NULL, NULL),
(2, 10, NULL, NULL, NULL, NULL, NULL),
(3, 1, NULL, NULL, NULL, NULL, NULL),
(3, 2, NULL, NULL, NULL, NULL, NULL),
(3, 3, NULL, NULL, NULL, NULL, NULL),
(3, 4, NULL, NULL, NULL, NULL, NULL),
(3, 6, NULL, NULL, NULL, NULL, NULL),
(3, 7, NULL, NULL, NULL, NULL, NULL),
(3, 8, NULL, NULL, NULL, NULL, NULL),
(3, 9, NULL, NULL, NULL, NULL, NULL),
(3, 10, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `sys_admin_ban_list`
--

CREATE TABLE `sys_admin_ban_list` (
  `ProfID` int(10) unsigned NOT NULL DEFAULT '0',
  `Time` int(10) unsigned NOT NULL DEFAULT '0',
  `DateTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`ProfID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_albums`
--

CREATE TABLE `sys_albums` (
  `ID` int(10) NOT NULL AUTO_INCREMENT,
  `Caption` varchar(128) NOT NULL DEFAULT '',
  `Uri` varchar(255) NOT NULL DEFAULT '',
  `Location` varchar(128) NOT NULL DEFAULT '',
  `Description` varchar(255) NOT NULL DEFAULT '',
  `Type` varchar(20) NOT NULL DEFAULT '',
  `Owner` int(10) NOT NULL DEFAULT '0',
  `Status` enum('active','passive') NOT NULL DEFAULT 'active',
  `Date` int(10) NOT NULL DEFAULT '0',
  `ObjCount` int(10) NOT NULL DEFAULT '0',
  `LastObjId` int(10) NOT NULL DEFAULT '0',
  `AllowAlbumView` int(10) NOT NULL DEFAULT '3',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Uri` (`Uri`,`Type`,`Owner`),
  KEY `Owner` (`Owner`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_albums_objects`
--

CREATE TABLE `sys_albums_objects` (
  `id_album` int(10) NOT NULL,
  `id_object` int(10) NOT NULL,
  `obj_order` int(10) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_album` (`id_album`,`id_object`),
  KEY `id_object` (`id_object`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_alerts`
--

CREATE TABLE `sys_alerts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `unit` varchar(64) NOT NULL DEFAULT '',
  `action` varchar(64) NOT NULL DEFAULT 'none',
  `handler_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `alert_handler` (`unit`,`action`,`handler_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

--
-- Dumping data for table `sys_alerts`
--

INSERT INTO `sys_alerts` VALUES
(1, 'system', 'begin', 1),
(2, 'profile', 'before_join', 2),
(3, 'profile', 'join', 2),
(4, 'profile', 'before_login', 2),
(5, 'profile', 'login', 2),
(6, 'profile', 'logout', 2),
(7, 'profile', 'edit', 2),
(8, 'profile', 'delete', 2),
(9, 'profile', 'join', 3),
(10, 'profile', 'edit', 3),
(11, 'profile', 'delete', 3),
(12, 'profile', 'join', 4),
(13, 'profile', 'edit', 4),
(14, 'profile', 'delete', 4),
(15, 'profile', 'change_status', 4),
(16, 'profile', 'commentRemoved', 5);

-- --------------------------------------------------------

--
-- Table structure for table `sys_alerts_handlers`
--

CREATE TABLE `sys_alerts_handlers` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL DEFAULT '',
  `class` varchar(128) NOT NULL DEFAULT '',
  `file` varchar(255) NOT NULL DEFAULT '',
  `eval` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `sys_alerts_handlers`
--

INSERT INTO `sys_alerts_handlers` VALUES
(1, 'system', 'BxDolAlertsResponseSystem', 'inc/classes/BxDolAlertsResponseSystem.php', ''),
(2, 'profile', 'BxDolAlertsResponseProfile', 'inc/classes/BxDolAlertsResponseProfile.php', ''),
(3, 'membersData', 'BxDolUpdateMembersCache', 'inc/classes/BxDolUpdateMembersCache.php', ''),
(4, 'profileMatch', 'BxDolAlertsResponceMatch', 'inc/classes/BxDolAlertsResponceMatch.php', ''),
(5, 'bx_videos_comments_delete', 'BxDolVideoDeleteResponse', 'flash/modules/video_comments/inc/classes/BxDolVideoDeleteResponse.php', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_antispam_block_log`
--

CREATE TABLE `sys_antispam_block_log` (
  `ip` int(10) unsigned NOT NULL,
  `member_id` int(10) unsigned NOT NULL,
  `type` varchar(32) NOT NULL,
  `extra` text NOT NULL,
  `added` int(11) NOT NULL,
  KEY `ip` (`ip`),
  KEY `member_id` (`member_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_banners`
--

CREATE TABLE `sys_banners` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Title` varchar(32) NOT NULL DEFAULT '',
  `Url` varchar(255) NOT NULL DEFAULT '',
  `Text` mediumtext NOT NULL,
  `Active` tinyint(4) NOT NULL DEFAULT '0',
  `Created` date NOT NULL DEFAULT '0000-00-00',
  `campaign_start` date NOT NULL DEFAULT '2005-01-01',
  `campaign_end` date NOT NULL DEFAULT '2007-01-01',
  `Position` varchar(10) NOT NULL DEFAULT '4',
  `lhshift` int(5) NOT NULL DEFAULT '-200',
  `lvshift` int(5) NOT NULL DEFAULT '-750',
  `rhshift` int(5) NOT NULL DEFAULT '100',
  `rvshift` int(5) NOT NULL DEFAULT '-750',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 PACK_KEYS=0 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_banners_clicks`
--

CREATE TABLE `sys_banners_clicks` (
  `ID` int(10) unsigned NOT NULL DEFAULT '0',
  `Date` int(10) NOT NULL DEFAULT '0',
  `IP` varchar(16) NOT NULL DEFAULT '',
  UNIQUE KEY `ID_2` (`ID`,`Date`,`IP`),
  KEY `ID` (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_banners_shows`
--

CREATE TABLE `sys_banners_shows` (
  `ID` int(10) unsigned NOT NULL DEFAULT '0',
  `Date` int(10) NOT NULL DEFAULT '0',
  `IP` varchar(16) NOT NULL DEFAULT '',
  KEY `ID` (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_block_list`
--

CREATE TABLE `sys_block_list` (
  `ID` int(10) unsigned NOT NULL DEFAULT '0',
  `Profile` int(10) unsigned NOT NULL DEFAULT '0',
  `When` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  UNIQUE KEY `BlockPair` (`ID`,`Profile`),
  KEY `ID` (`ID`),
  KEY `Profile` (`Profile`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_box_download`
--

CREATE TABLE `sys_box_download` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) NOT NULL,
  `url` varchar(255) NOT NULL,
  `onclick` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `icon` varchar(255) NOT NULL,
  `order` int(11) NOT NULL,
  `disabled` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `sys_box_download`
--

INSERT INTO `sys_box_download` VALUES
(1, '_sbd_iPhone_title', 'http://itunes.apple.com/us/app/oo/id345450186', '', '_sbd_iPhone_desc', 'apple', 2, 0),
(2, '_sbd_Android_title', 'https://play.google.com/store/apps/details?id=com.boonex.oo', '', '_sbd_Android_desc', 'android', 3, 0);

-- --------------------------------------------------------

--
-- Table structure for table `sys_categories`
--

CREATE TABLE `sys_categories` (
  `Category` varchar(32) NOT NULL DEFAULT '',
  `ID` int(10) unsigned NOT NULL DEFAULT '0',
  `Type` varchar(20) NOT NULL DEFAULT 'photo',
  `Owner` int(10) unsigned NOT NULL,
  `Status` enum('active','passive') NOT NULL DEFAULT 'active',
  `Date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`Category`,`ID`,`Type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_cmts_profile`
--

CREATE TABLE `sys_cmts_profile` (
  `cmt_id` int(11) NOT NULL AUTO_INCREMENT,
  `cmt_parent_id` int(11) NOT NULL DEFAULT '0',
  `cmt_object_id` int(11) NOT NULL DEFAULT '0',
  `cmt_author_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cmt_text` text NOT NULL,
  `cmt_mood` tinyint(4) NOT NULL DEFAULT '0',
  `cmt_rate` int(11) NOT NULL DEFAULT '0',
  `cmt_rate_count` int(11) NOT NULL DEFAULT '0',
  `cmt_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cmt_replies` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cmt_id`),
  KEY `cmt_object_id` (`cmt_object_id`,`cmt_parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_cmts_track`
--

CREATE TABLE `sys_cmts_track` (
  `cmt_system_id` int(11) NOT NULL DEFAULT '0',
  `cmt_id` int(11) NOT NULL DEFAULT '0',
  `cmt_rate` tinyint(4) NOT NULL DEFAULT '0',
  `cmt_rate_author_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cmt_rate_author_nip` int(11) unsigned NOT NULL DEFAULT '0',
  `cmt_rate_ts` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cmt_system_id`,`cmt_id`,`cmt_rate_author_nip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_color_base`
--

CREATE TABLE `sys_color_base` (
  `ColorName` varchar(20) NOT NULL DEFAULT '',
  `ColorCode` varchar(10) NOT NULL DEFAULT '',
  UNIQUE KEY `ColorName` (`ColorName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_color_base`
--

INSERT INTO `sys_color_base` VALUES
('AliceBlue', '#F0F8FF'),
('AntiqueWhite', '#FAEBD7'),
('Aqua', '#00FFFF'),
('Aquamarine', '#7FFFD4'),
('Azure', '#F0FFFF'),
('Beige', '#F5F5DC'),
('Bisque', '#FFE4C4'),
('Black', '#000000'),
('BlanchedAlmond', '#FFEBCD'),
('Blue', '#0000FF'),
('BlueViolet', '#8A2BE2'),
('Brown', '#A52A2A'),
('BurlyWood', '#DEB887'),
('CadetBlue', '#5F9EA0'),
('Chartreuse', '#7FFF00'),
('Chocolate', '#D2691E'),
('Coral', '#FF7F50'),
('CornflowerBlue', '#6495ED'),
('Cornsilk', '#FFF8DC'),
('Crimson', '#DC143C'),
('Cyan', '#00FFFF'),
('DarkBlue', '#00008B'),
('DarkCyan', '#008B8B'),
('DarkGoldenRod', '#B8860B'),
('DarkGray', '#A9A9A9'),
('DarkGreen', '#006400'),
('DarkKhaki', '#BDB76B'),
('DarkMagenta', '#8B008B'),
('DarkOliveGreen', '#556B2F'),
('Darkorange', '#FF8C00'),
('DarkOrchid', '#9932CC'),
('DarkRed', '#8B0000'),
('DarkSalmon', '#E9967A'),
('DarkSeaGreen', '#8FBC8F'),
('DarkSlateBlue', '#483D8B'),
('DarkSlateGray', '#2F4F4F'),
('DarkTurquoise', '#00CED1'),
('DarkViolet', '#9400D3'),
('DeepPink', '#FF1493'),
('DeepSkyBlue', '#00BFFF'),
('DimGray', '#696969'),
('DodgerBlue', '#1E90FF'),
('Feldspar', '#D19275'),
('FireBrick', '#B22222'),
('FloralWhite', '#FFFAF0'),
('ForestGreen', '#228B22'),
('Fuchsia', '#FF00FF'),
('Gainsboro', '#DCDCDC'),
('GhostWhite', '#F8F8FF'),
('Gold', '#FFD700'),
('GoldenRod', '#DAA520'),
('Gray', '#808080'),
('Green', '#008000'),
('GreenYellow', '#ADFF2F'),
('HoneyDew', '#F0FFF0'),
('HotPink', '#FF69B4'),
('IndianRed', '#CD5C5C'),
('Indigo', '#4B0082'),
('Ivory', '#FFFFF0'),
('Khaki', '#F0E68C'),
('Lavender', '#E6E6FA'),
('LavenderBlush', '#FFF0F5'),
('LawnGreen', '#7CFC00'),
('LemonChiffon', '#FFFACD'),
('LightBlue', '#ADD8E6'),
('LightCoral', '#F08080'),
('LightCyan', '#E0FFFF'),
('LightGoldenRodYellow', '#FAFAD2'),
('LightGrey', '#D3D3D3'),
('LightGreen', '#90EE90'),
('LightPink', '#FFB6C1'),
('LightSalmon', '#FFA07A'),
('LightSeaGreen', '#20B2AA'),
('LightSkyBlue', '#87CEFA'),
('LightSlateBlue', '#8470FF'),
('LightSlateGray', '#778899'),
('LightSteelBlue', '#B0C4DE'),
('LightYellow', '#FFFFE0'),
('Lime', '#00FF00'),
('LimeGreen', '#32CD32'),
('Linen', '#FAF0E6'),
('Magenta', '#FF00FF'),
('Maroon', '#800000'),
('MediumAquaMarine', '#66CDAA'),
('MediumBlue', '#0000CD'),
('MediumOrchid', '#BA55D3'),
('MediumPurple', '#9370D8'),
('MediumSeaGreen', '#3CB371'),
('MediumSlateBlue', '#7B68EE'),
('MediumSpringGreen', '#00FA9A'),
('MediumTurquoise', '#48D1CC'),
('MediumVioletRed', '#C71585'),
('MidnightBlue', '#191970'),
('MintCream', '#F5FFFA'),
('MistyRose', '#FFE4E1'),
('Moccasin', '#FFE4B5'),
('NavajoWhite', '#FFDEAD'),
('Navy', '#000080'),
('OldLace', '#FDF5E6'),
('Olive', '#808000'),
('OliveDrab', '#6B8E23'),
('Orange', '#FFA500'),
('OrangeRed', '#FF4500'),
('Orchid', '#DA70D6'),
('PaleGoldenRod', '#EEE8AA'),
('PaleGreen', '#98FB98'),
('PaleTurquoise', '#AFEEEE'),
('PaleVioletRed', '#D87093'),
('PapayaWhip', '#FFEFD5'),
('PeachPuff', '#FFDAB9'),
('Peru', '#CD853F'),
('Pink', '#FFC0CB'),
('Plum', '#DDA0DD'),
('PowderBlue', '#B0E0E6'),
('Purple', '#800080'),
('Red', '#FF0000'),
('RosyBrown', '#BC8F8F'),
('RoyalBlue', '#4169E1'),
('SaddleBrown', '#8B4513'),
('Salmon', '#FA8072'),
('SandyBrown', '#F4A460'),
('SeaGreen', '#2E8B57'),
('SeaShell', '#FFF5EE'),
('Sienna', '#A0522D'),
('Silver', '#C0C0C0'),
('SkyBlue', '#87CEEB'),
('SlateBlue', '#6A5ACD'),
('SlateGray', '#708090'),
('Snow', '#FFFAFA'),
('SpringGreen', '#00FF7F'),
('SteelBlue', '#4682B4'),
('Tan', '#D2B48C'),
('Teal', '#008080'),
('Thistle', '#D8BFD8'),
('Tomato', '#FF6347'),
('Turquoise', '#40E0D0'),
('Violet', '#EE82EE'),
('VioletRed', '#D02090'),
('Wheat', '#F5DEB3'),
('White', '#FFFFFF'),
('WhiteSmoke', '#F5F5F5'),
('Yellow', '#FFFF00'),
('YellowGreen', '#9ACD32');

-- --------------------------------------------------------

--
-- Table structure for table `sys_countries`
--

CREATE TABLE `sys_countries` (
  `ISO2` varchar(2) NOT NULL DEFAULT '',
  `ISO3` varchar(3) NOT NULL DEFAULT '',
  `ISONo` smallint(3) NOT NULL DEFAULT '0',
  `Country` varchar(100) NOT NULL DEFAULT '',
  `Region` varchar(100) DEFAULT NULL,
  `Currency` varchar(100) DEFAULT NULL,
  `CurrencyCode` varchar(3) DEFAULT NULL,
  PRIMARY KEY (`ISO2`),
  KEY `CurrencyCode` (`CurrencyCode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_countries`
--

INSERT INTO `sys_countries` VALUES
('AD', 'AND', 20, 'Andorra', 'Europe', 'Euro', 'EUR'),
('AE', 'ARE', 784, 'United Arab Emirates', 'Middle East', 'UAE Dirham', 'AED'),
('AF', 'AFG', 4, 'Afghanistan', 'Asia', 'Afghani', 'AFA'),
('AG', 'ATG', 28, 'Antigua and Barbuda', 'Central America and the Caribbean', 'East Caribbean Dollar', 'XCD'),
('AI', 'AIA', 660, 'Anguilla', 'Central America and the Caribbean', 'East Caribbean Dollar', 'XCD'),
('AL', 'ALB', 8, 'Albania', 'Europe', 'Lek', 'ALL'),
('AM', 'ARM', 51, 'Armenia', 'Commonwealth of Independent States', 'Armenian Dram', 'AMD'),
('AN', 'ANT', 530, 'Netherlands Antilles', 'Central America and the Caribbean', 'Netherlands Antillean guilder', 'ANG'),
('AO', 'AGO', 24, 'Angola', 'Africa', 'Kwanza', 'AOA'),
('AQ', 'ATA', 10, 'Antarctica', 'Antarctic Region', NULL, NULL),
('AR', 'ARG', 32, 'Argentina', 'South America', 'Argentine Peso', 'ARS'),
('AS', 'ASM', 16, 'American Samoa', 'Oceania', 'US Dollar', 'USD'),
('AT', 'AUT', 40, 'Austria', 'Europe', 'Euro', 'EUR'),
('AU', 'AUS', 36, 'Australia', 'Oceania', 'Australian dollar', 'AUD'),
('AW', 'ABW', 533, 'Aruba', 'Central America and the Caribbean', 'Aruban Guilder', 'AWG'),
('AX', 'ALA', 248, 'Aland Islands', 'Europe', 'Euro', 'EUR'),
('AZ', 'AZE', 31, 'Azerbaijan', 'Commonwealth of Independent States', 'Azerbaijani Manat', 'AZM'),
('BA', 'BIH', 70, 'Bosnia and Herzegovina', 'Bosnia and Herzegovina, Europe', 'Convertible Marka', 'BAM'),
('BB', 'BRB', 52, 'Barbados', 'Central America and the Caribbean', 'Barbados Dollar', 'BBD'),
('BD', 'BGD', 50, 'Bangladesh', 'Asia', 'Taka', 'BDT'),
('BE', 'BEL', 56, 'Belgium', 'Europe', 'Euro', 'EUR'),
('BF', 'BFA', 854, 'Burkina Faso', 'Africa', 'CFA Franc BCEAO', 'XOF'),
('BG', 'BGR', 100, 'Bulgaria', 'Europe', 'Lev', 'BGL'),
('BH', 'BHR', 48, 'Bahrain', 'Middle East', 'Bahraini Dinar', 'BHD'),
('BI', 'BDI', 108, 'Burundi', 'Africa', 'Burundi Franc', 'BIF'),
('BJ', 'BEN', 204, 'Benin', 'Africa', 'CFA Franc BCEAO', 'XOF'),
('BL', 'BLM', 652, 'Saint Barthelemy', 'Central America and the Caribbean', 'Euro', 'EUR'),
('BM', 'BMU', 60, 'Bermuda', 'North America', 'Bermudian Dollar', 'BMD'),
('BN', 'BRN', 96, 'Brunei Darussalam', 'Southeast Asia', 'Brunei Dollar', 'BND'),
('BO', 'BOL', 68, 'Bolivia', 'South America', 'Boliviano', 'BOB'),
('BR', 'BRA', 76, 'Brazil', 'South America', 'Brazilian Real', 'BRL'),
('BS', 'BHS', 44, 'The Bahamas', 'Central America and the Caribbean', 'Bahamian Dollar', 'BSD'),
('BT', 'BTN', 64, 'Bhutan', 'Asia', 'Ngultrum', 'BTN'),
('BV', 'BVT', 74, 'Bouvet Island', 'Antarctic Region', 'Norwegian Krone', 'NOK'),
('BW', 'BWA', 72, 'Botswana', 'Africa', 'Pula', 'BWP'),
('BY', 'BLR', 112, 'Belarus', 'Commonwealth of Independent States', 'Belarussian Ruble', 'BYR'),
('BZ', 'BLZ', 84, 'Belize', 'Central America and the Caribbean', 'Belize Dollar', 'BZD'),
('CA', 'CAN', 124, 'Canada', 'North America', 'Canadian Dollar', 'CAD'),
('CC', 'CCK', 166, 'Cocos (Keeling) Islands', 'Southeast Asia', 'Australian Dollar', 'AUD'),
('CD', 'COD', 180, 'Congo, Democratic Republic of the', 'Africa', 'Franc Congolais', 'CDF'),
('CF', 'CAF', 140, 'Central African Republic', 'Africa', 'CFA Franc BEAC', 'XAF'),
('CG', 'COG', 178, 'Congo, Republic of the', 'Africa', 'CFA Franc BEAC', 'XAF'),
('CH', 'CHE', 756, 'Switzerland', 'Europe', 'Swiss Franc', 'CHF'),
('CI', 'CIV', 384, 'Cote d''Ivoire', 'Africa', 'CFA Franc BCEAO', 'XOF'),
('CK', 'COK', 184, 'Cook Islands', 'Oceania', 'New Zealand Dollar', 'NZD'),
('CL', 'CHL', 152, 'Chile', 'South America', 'Chilean Peso', 'CLP'),
('CM', 'CMR', 120, 'Cameroon', 'Africa', 'CFA Franc BEAC', 'XAF'),
('CN', 'CHN', 156, 'China', 'Asia', 'Yuan Renminbi', 'CNY'),
('CO', 'COL', 170, 'Colombia', 'South America, Central America and the Caribbean', 'Colombian Peso', 'COP'),
('CR', 'CRI', 188, 'Costa Rica', 'Central America and the Caribbean', 'Costa Rican Colon', 'CRC'),
('CU', 'CUB', 192, 'Cuba', 'Central America and the Caribbean', 'Cuban Peso', 'CUP'),
('CV', 'CPV', 132, 'Cape Verde', 'World', 'Cape Verdean Escudo', 'CVE'),
('CX', 'CXR', 162, 'Christmas Island', 'Southeast Asia', 'Australian Dollar', 'AUD'),
('CY', 'CYP', 196, 'Cyprus', 'Middle East', 'Cyprus Pound', 'CYP'),
('CZ', 'CZE', 203, 'Czech Republic', 'Europe', 'Czech Koruna', 'CZK'),
('DE', 'DEU', 276, 'Germany', 'Europe', 'Euro', 'EUR'),
('DJ', 'DJI', 262, 'Djibouti', 'Africa', 'Djibouti Franc', 'DJF'),
('DK', 'DNK', 208, 'Denmark', 'Europe', 'Danish Krone', 'DKK'),
('DM', 'DMA', 212, 'Dominica', 'Central America and the Caribbean', 'East Caribbean Dollar', 'XCD'),
('DO', 'DOM', 214, 'Dominican Republic', 'Central America and the Caribbean', 'Dominican Peso', 'DOP'),
('DZ', 'DZA', 12, 'Algeria', 'Africa', 'Algerian Dinar', 'DZD'),
('EC', 'ECU', 218, 'Ecuador', 'South America', 'US dollar', 'USD'),
('EE', 'EST', 233, 'Estonia', 'Europe', 'Kroon', 'EEK'),
('EG', 'EGY', 818, 'Egypt', 'Africa', 'Egyptian Pound', 'EGP'),
('EH', 'ESH', 732, 'Western Sahara', 'Africa', 'Moroccan Dirham', 'MAD'),
('ER', 'ERI', 232, 'Eritrea', 'Africa', 'Nakfa', 'ERN'),
('ES', 'ESP', 724, 'Spain', 'Europe', 'Euro', 'EUR'),
('ET', 'ETH', 231, 'Ethiopia', 'Africa', 'Ethiopian Birr', 'ETB'),
('FI', 'FIN', 246, 'Finland', 'Europe', 'Euro', 'EUR'),
('FJ', 'FJI', 242, 'Fiji', 'Oceania', 'Fijian Dollar', 'FJD'),
('FK', 'FLK', 238, 'Falkland Islands (Islas Malvinas)', 'South America', 'Falkland Islands Pound', 'FKP'),
('FM', 'FSM', 583, 'Micronesia, Federated States of', 'Oceania', 'US dollar', 'USD'),
('FO', 'FRO', 234, 'Faroe Islands', 'Europe', 'Danish Krone', 'DKK'),
('FR', 'FRA', 250, 'France', 'Europe', 'Euro', 'EUR'),
('GA', 'GAB', 266, 'Gabon', 'Africa', 'CFA Franc BEAC', 'XAF'),
('GB', 'GBR', 826, 'United Kingdom', 'Europe', 'Pound Sterling', 'GBP'),
('GD', 'GRD', 308, 'Grenada', 'Central America and the Caribbean', 'East Caribbean Dollar', 'XCD'),
('GE', 'GEO', 268, 'Georgia', 'Commonwealth of Independent States', 'Lari', 'GEL'),
('GF', 'GUF', 254, 'French Guiana', 'South America', 'Euro', 'EUR'),
('GG', 'GGY', 831, 'Guernsey', 'Europe', 'Pound sterling', 'GBP'),
('GH', 'GHA', 288, 'Ghana', 'Africa', 'Cedi', 'GHC'),
('GI', 'GIB', 292, 'Gibraltar', 'Europe', 'Gibraltar Pound', 'GIP'),
('GL', 'GRL', 304, 'Greenland', 'Arctic Region', 'Danish Krone', 'DKK'),
('GM', 'GMB', 270, 'The Gambia', 'Africa', 'Dalasi', 'GMD'),
('GN', 'GIN', 324, 'Guinea', 'Africa', 'Guinean Franc', 'GNF'),
('GP', 'GLP', 312, 'Guadeloupe', 'Central America and the Caribbean', 'Euro', 'EUR'),
('GQ', 'GNQ', 226, 'Equatorial Guinea', 'Africa', 'CFA Franc BEAC', 'XAF'),
('GR', 'GRC', 300, 'Greece', 'Europe', 'Euro', 'EUR'),
('GS', 'SGS', 239, 'South Georgia and the South Sandwich Islands', 'Antarctic Region', 'Pound Sterling', 'GBP'),
('GT', 'GTM', 320, 'Guatemala', 'Central America and the Caribbean', 'Quetzal', 'GTQ'),
('GU', 'GUM', 316, 'Guam', 'Oceania', 'US Dollar', 'USD'),
('GW', 'GNB', 624, 'Guinea-Bissau', 'Africa', 'CFA Franc BCEAO', 'XOF'),
('GY', 'GUY', 328, 'Guyana', 'South America', 'Guyana Dollar', 'GYD'),
('HK', 'HKG', 344, 'Hong Kong (SAR)', 'Southeast Asia', 'Hong Kong Dollar', 'HKD'),
('HM', 'HMD', 334, 'Heard Island and McDonald Islands', 'Antarctic Region', 'Australian Dollar', 'AUD'),
('HN', 'HND', 340, 'Honduras', 'Central America and the Caribbean', 'Lempira', 'HNL'),
('HR', 'HRV', 191, 'Croatia', 'Europe', 'Kuna', 'HRK'),
('HT', 'HTI', 332, 'Haiti', 'Central America and the Caribbean', 'Gourde', 'HTG'),
('HU', 'HUN', 348, 'Hungary', 'Europe', 'Forint', 'HUF'),
('ID', 'IDN', 360, 'Indonesia', 'Southeast Asia', 'Rupiah', 'IDR'),
('IE', 'IRL', 372, 'Ireland', 'Europe', 'Euro', 'EUR'),
('IL', 'ISR', 376, 'Israel', 'Middle East', 'New Israeli Sheqel', 'ILS'),
('IM', 'IMN', 833, 'Isle of Man', 'Europe', 'Pound sterling', 'GBP'),
('IN', 'IND', 356, 'India', 'Asia', 'Indian Rupee', 'INR'),
('IO', 'IOT', 86, 'British Indian Ocean Territory', 'World', 'US Dollar', 'USD'),
('IQ', 'IRQ', 368, 'Iraq', 'Middle East', 'Iraqi Dinar', 'IQD'),
('IR', 'IRN', 364, 'Iran', 'Middle East', 'Iranian Rial', 'IRR'),
('IS', 'ISL', 352, 'Iceland', 'Arctic Region', 'Iceland Krona', 'ISK'),
('IT', 'ITA', 380, 'Italy', 'Europe', 'Euro', 'EUR'),
('JE', 'JEY', 832, 'Jersey', 'Europe', 'Pound sterling', 'GBP'),
('JM', 'JAM', 388, 'Jamaica', 'Central America and the Caribbean', 'Jamaican dollar', 'JMD'),
('JO', 'JOR', 400, 'Jordan', 'Middle East', 'Jordanian Dinar', 'JOD'),
('JP', 'JPN', 392, 'Japan', 'Asia', 'Yen', 'JPY'),
('KE', 'KEN', 404, 'Kenya', 'Africa', 'Kenyan shilling', 'KES'),
('KG', 'KGZ', 417, 'Kyrgyzstan', 'Commonwealth of Independent States', 'Som', 'KGS'),
('KH', 'KHM', 116, 'Cambodia', 'Southeast Asia', 'Riel', 'KHR'),
('KI', 'KIR', 296, 'Kiribati', 'Oceania', 'Australian dollar', 'AUD'),
('KM', 'COM', 174, 'Comoros', 'Africa', 'Comoro Franc', 'KMF'),
('KN', 'KNA', 659, 'Saint Kitts and Nevis', 'Central America and the Caribbean', 'East Caribbean Dollar', 'XCD'),
('KP', 'PRK', 408, 'Korea, North', 'Asia', 'North Korean Won', 'KPW'),
('KR', 'KOR', 410, 'Korea, South', 'Asia', 'Won', 'KRW'),
('KW', 'KWT', 414, 'Kuwait', 'Middle East', 'Kuwaiti Dinar', 'KWD'),
('KY', 'CYM', 136, 'Cayman Islands', 'Central America and the Caribbean', 'Cayman Islands Dollar', 'KYD'),
('KZ', 'KAZ', 398, 'Kazakhstan', 'Commonwealth of Independent States', 'Tenge', 'KZT'),
('LA', 'LAO', 418, 'Laos', 'Southeast Asia', 'Kip', 'LAK'),
('LB', 'LBN', 422, 'Lebanon', 'Middle East', 'Lebanese Pound', 'LBP'),
('LC', 'LCA', 662, 'Saint Lucia', 'Central America and the Caribbean', 'East Caribbean Dollar', 'XCD'),
('LI', 'LIE', 438, 'Liechtenstein', 'Europe', 'Swiss Franc', 'CHF'),
('LK', 'LKA', 144, 'Sri Lanka', 'Asia', 'Sri Lanka Rupee', 'LKR'),
('LR', 'LBR', 430, 'Liberia', 'Africa', 'Liberian Dollar', 'LRD'),
('LS', 'LSO', 426, 'Lesotho', 'Africa', 'Loti', 'LSL'),
('LT', 'LTU', 440, 'Lithuania', 'Europe', 'Lithuanian Litas', 'LTL'),
('LU', 'LUX', 442, 'Luxembourg', 'Europe', 'Euro', 'EUR'),
('LV', 'LVA', 428, 'Latvia', 'Europe', 'Latvian Lats', 'LVL'),
('LY', 'LBY', 434, 'Libya', 'Africa', 'Libyan Dinar', 'LYD'),
('MA', 'MAR', 504, 'Morocco', 'Africa', 'Moroccan Dirham', 'MAD'),
('MC', 'MCO', 492, 'Monaco', 'Europe', 'Euro', 'EUR'),
('MD', 'MDA', 498, 'Moldova', 'Commonwealth of Independent States', 'Moldovan Leu', 'MDL'),
('ME', 'MNE', 499, 'Montenegro', 'Europe', 'Euro', 'EUR'),
('MF', 'MAF', 663, 'Saint Martin (French part)', 'Central America and the Caribbean', 'Euro', 'EUR'),
('MG', 'MDG', 450, 'Madagascar', 'Africa', 'Malagasy Franc', 'MGF'),
('MH', 'MHL', 584, 'Marshall Islands', 'Oceania', 'US dollar', 'USD'),
('MK', 'MKD', 807, 'Macedonia, The Former Yugoslav Republic of', 'Europe', 'Denar', 'MKD'),
('ML', 'MLI', 466, 'Mali', 'Africa', 'CFA Franc BCEAO', 'XOF'),
('MM', 'MMR', 104, 'Myanmar', 'Southeast Asia', 'kyat', 'MMK'),
('MN', 'MNG', 496, 'Mongolia', 'Asia', 'Tugrik', 'MNT'),
('MO', 'MAC', 446, 'Macao', 'Southeast Asia', 'Pataca', 'MOP'),
('MP', 'MNP', 580, 'Northern Mariana Islands', 'Oceania', 'US Dollar', 'USD'),
('MQ', 'MTQ', 474, 'Martinique', 'Central America and the Caribbean', 'Euro', 'EUR'),
('MR', 'MRT', 478, 'Mauritania', 'Africa', 'Ouguiya', 'MRO'),
('MS', 'MSR', 500, 'Montserrat', 'Central America and the Caribbean', 'East Caribbean Dollar', 'XCD'),
('MT', 'MLT', 470, 'Malta', 'Europe', 'Maltese Lira', 'MTL'),
('MU', 'MUS', 480, 'Mauritius', 'World', 'Mauritius Rupee', 'MUR'),
('MV', 'MDV', 462, 'Maldives', 'Asia', 'Rufiyaa', 'MVR'),
('MW', 'MWI', 454, 'Malawi', 'Africa', 'Kwacha', 'MWK'),
('MX', 'MEX', 484, 'Mexico', 'North America', 'Mexican Peso', 'MXN'),
('MY', 'MYS', 458, 'Malaysia', 'Southeast Asia', 'Malaysian Ringgit', 'MYR'),
('MZ', 'MOZ', 508, 'Mozambique', 'Africa', 'Metical', 'MZM'),
('NA', 'NAM', 516, 'Namibia', 'Africa', 'Namibian Dollar', 'NAD'),
('NC', 'NCL', 540, 'New Caledonia', 'Oceania', 'CFP Franc', 'XPF'),
('NE', 'NER', 562, 'Niger', 'Africa', 'CFA Franc BCEAO', 'XOF'),
('NF', 'NFK', 574, 'Norfolk Island', 'Oceania', 'Australian Dollar', 'AUD'),
('NG', 'NGA', 566, 'Nigeria', 'Africa', 'Naira', 'NGN'),
('NI', 'NIC', 558, 'Nicaragua', 'Central America and the Caribbean', 'Cordoba Oro', 'NIO'),
('NL', 'NLD', 528, 'Netherlands', 'Europe', 'Euro', 'EUR'),
('NO', 'NOR', 578, 'Norway', 'Europe', 'Norwegian Krone', 'NOK'),
('NP', 'NPL', 524, 'Nepal', 'Asia', 'Nepalese Rupee', 'NPR'),
('NR', 'NRU', 520, 'Nauru', 'Oceania', 'Australian Dollar', 'AUD'),
('NU', 'NIU', 570, 'Niue', 'Oceania', 'New Zealand Dollar', 'NZD'),
('NZ', 'NZL', 554, 'New Zealand', 'Oceania', 'New Zealand Dollar', 'NZD'),
('OM', 'OMN', 512, 'Oman', 'Middle East', 'Rial Omani', 'OMR'),
('PA', 'PAN', 591, 'Panama', 'Central America and the Caribbean', 'balboa', 'PAB'),
('PE', 'PER', 604, 'Peru', 'South America', 'Nuevo Sol', 'PEN'),
('PF', 'PYF', 258, 'French Polynesia', 'Oceania', 'CFP Franc', 'XPF'),
('PG', 'PNG', 598, 'Papua New Guinea', 'Oceania', 'Kina', 'PGK'),
('PH', 'PHL', 608, 'Philippines', 'Southeast Asia', 'Philippine Peso', 'PHP'),
('PK', 'PAK', 586, 'Pakistan', 'Asia', 'Pakistan Rupee', 'PKR'),
('PL', 'POL', 616, 'Poland', 'Europe', 'Zloty', 'PLN'),
('PM', 'SPM', 666, 'Saint Pierre and Miquelon', 'North America', 'Euro', 'EUR'),
('PN', 'PCN', 612, 'Pitcairn Islands', 'Oceania', 'New Zealand Dollar', 'NZD'),
('PR', 'PRI', 630, 'Puerto Rico', 'Central America and the Caribbean', 'US dollar', 'USD'),
('PS', 'PSE', 275, 'Palestinian Territory, Occupied', NULL, NULL, NULL),
('PT', 'PRT', 620, 'Portugal', 'Europe', 'Euro', 'EUR'),
('PW', 'PLW', 585, 'Palau', 'Oceania', 'US dollar', 'USD'),
('PY', 'PRY', 600, 'Paraguay', 'South America', 'Guarani', 'PYG'),
('QA', 'QAT', 634, 'Qatar', 'Middle East', 'Qatari Rial', 'QAR'),
('RE', 'REU', 638, 'Reunion', 'World', 'Euro', 'EUR'),
('RO', 'ROU', 642, 'Romania', 'Europe', 'Leu', 'ROL'),
('RS', 'SRB', 688, 'Serbia', 'Europe', 'Serbian Dinar', 'RSD'),
('RU', 'RUS', 643, 'Russia', 'Asia', 'Russian Ruble', 'RUB'),
('RW', 'RWA', 646, 'Rwanda', 'Africa', 'Rwanda Franc', 'RWF'),
('SA', 'SAU', 682, 'Saudi Arabia', 'Middle East', 'Saudi Riyal', 'SAR'),
('SB', 'SLB', 90, 'Solomon Islands', 'Oceania', 'Solomon Islands Dollar', 'SBD'),
('SC', 'SYC', 690, 'Seychelles', 'Africa', 'Seychelles Rupee', 'SCR'),
('SD', 'SDN', 736, 'Sudan', 'Africa', 'Sudanese Dinar', 'SDD'),
('SE', 'SWE', 752, 'Sweden', 'Europe', 'Swedish Krona', 'SEK'),
('SG', 'SGP', 702, 'Singapore', 'Southeast Asia', 'Singapore Dollar', 'SGD'),
('SH', 'SHN', 654, 'Saint Helena', 'Africa', 'Saint Helenian Pound', 'SHP'),
('SI', 'SVN', 705, 'Slovenia', 'Europe', 'Tolar', 'SIT'),
('SJ', 'SJM', 744, 'Svalbard', 'Arctic Region', 'Norwegian Krone', 'NOK'),
('SK', 'SVK', 703, 'Slovakia', 'Europe', 'Slovak Koruna', 'SKK'),
('SL', 'SLE', 694, 'Sierra Leone', 'Africa', 'Leone', 'SLL'),
('SM', 'SMR', 674, 'San Marino', 'Europe', 'Euro', 'EUR'),
('SN', 'SEN', 686, 'Senegal', 'Africa', 'CFA Franc BCEAO', 'XOF'),
('SO', 'SOM', 706, 'Somalia', 'Africa', 'Somali Shilling', 'SOS'),
('SR', 'SUR', 740, 'Suriname', 'South America', 'Suriname Guilder', 'SRG'),
('ST', 'STP', 678, 'Sao Tome and Principe', 'Africa', 'Dobra', 'STD'),
('SV', 'SLV', 222, 'El Salvador', 'Central America and the Caribbean', 'El Salvador Colon', 'SVC'),
('SY', 'SYR', 760, 'Syria', 'Middle East', 'Syrian Pound', 'SYP'),
('SZ', 'SWZ', 748, 'Swaziland', 'Africa', 'Lilangeni', 'SZL'),
('TC', 'TCA', 796, 'Turks and Caicos Islands', 'Central America and the Caribbean', 'US Dollar', 'USD'),
('TD', 'TCD', 148, 'Chad', 'Africa', 'CFA Franc BEAC', 'XAF'),
('TF', 'ATF', 260, 'French Southern and Antarctic Lands', 'Antarctic Region', 'Euro', 'EUR'),
('TG', 'TGO', 768, 'Togo', 'Africa', 'CFA Franc BCEAO', 'XOF'),
('TH', 'THA', 764, 'Thailand', 'Southeast Asia', 'Baht', 'THB'),
('TJ', 'TJK', 762, 'Tajikistan', 'Commonwealth of Independent States', 'Somoni', 'TJS'),
('TK', 'TKL', 772, 'Tokelau', 'Oceania', 'New Zealand Dollar', 'NZD'),
('TL', 'TLS', 626, 'East Timor', NULL, 'Timor Escudo', 'TPE'),
('TM', 'TKM', 795, 'Turkmenistan', 'Commonwealth of Independent States', 'Manat', 'TMM'),
('TN', 'TUN', 788, 'Tunisia', 'Africa', 'Tunisian Dinar', 'TND'),
('TO', 'TON', 776, 'Tonga', 'Oceania', 'Pa''anga', 'TOP'),
('TR', 'TUR', 792, 'Turkey', 'Middle East', 'Turkish Lira', 'TRL'),
('TT', 'TTO', 780, 'Trinidad and Tobago', 'Central America and the Caribbean', 'Trinidad and Tobago Dollar', 'TTD'),
('TV', 'TUV', 798, 'Tuvalu', 'Oceania', 'Australian Dollar', 'AUD'),
('TW', 'TWN', 158, 'Taiwan', 'Southeast Asia', 'New Taiwan Dollar', 'TWD'),
('TZ', 'TZA', 834, 'Tanzania', 'Africa', 'Tanzanian Shilling', 'TZS'),
('UA', 'UKR', 804, 'Ukraine', 'Commonwealth of Independent States', 'Hryvnia', 'UAH'),
('UG', 'UGA', 800, 'Uganda', 'Africa', 'Uganda Shilling', 'UGX'),
('UM', 'UMI', 581, 'United States Minor Outlying Islands', NULL, 'US Dollar', 'USD'),
('US', 'USA', 840, 'United States', 'North America', 'US Dollar', 'USD'),
('UY', 'URY', 858, 'Uruguay', 'South America', 'Peso Uruguayo', 'UYU'),
('UZ', 'UZB', 860, 'Uzbekistan', 'Commonwealth of Independent States', 'Uzbekistan Sum', 'UZS'),
('VA', 'VAT', 336, 'Holy See (Vatican City)', 'Europe', 'Euro', 'EUR'),
('VC', 'VCT', 670, 'Saint Vincent and the Grenadines', 'Central America and the Caribbean', 'East Caribbean Dollar', 'XCD'),
('VE', 'VEN', 862, 'Venezuela', 'South America, Central America and the Caribbean', 'Bolivar', 'VEB'),
('VG', 'VGB', 92, 'British Virgin Islands', 'Central America and the Caribbean', 'US dollar', 'USD'),
('VI', 'VIR', 850, 'Virgin Islands', 'Central America and the Caribbean', 'US Dollar', 'USD'),
('VN', 'VNM', 704, 'Vietnam', 'Southeast Asia', 'Dong', 'VND'),
('VU', 'VUT', 548, 'Vanuatu', 'Oceania', 'Vatu', 'VUV'),
('WF', 'WLF', 876, 'Wallis and Futuna', 'Oceania', 'CFP Franc', 'XPF'),
('WS', 'WSM', 882, 'Samoa', 'Oceania', 'Tala', 'WST'),
('YE', 'YEM', 887, 'Yemen', 'Middle East', 'Yemeni Rial', 'YER'),
('YT', 'MYT', 175, 'Mayotte', 'Africa', 'Euro', 'EUR'),
('ZA', 'ZAF', 710, 'South Africa', 'Africa', 'Rand', 'ZAR'),
('ZM', 'ZWB', 894, 'Zambia', 'Africa', 'Kwacha', 'ZMK'),
('ZW', 'ZWE', 716, 'Zimbabwe', 'Africa', 'Zimbabwe Dollar', 'ZWD');

-- --------------------------------------------------------

--
-- Table structure for table `sys_cron_jobs`
--

CREATE TABLE `sys_cron_jobs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL DEFAULT '',
  `time` varchar(128) NOT NULL DEFAULT '*',
  `class` varchar(128) NOT NULL DEFAULT '',
  `file` varchar(255) NOT NULL DEFAULT '',
  `eval` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `sys_cron_jobs`
--

INSERT INTO `sys_cron_jobs` VALUES
(1, 'cmd', '0 0 * * *', 'BxDolCronCmd', 'inc/classes/BxDolCronCmd.php', ''),
(2, 'notifies', '*/10 * * * *', 'BxDolCronNotifies', 'inc/classes/BxDolCronNotifies.php', ''),
(3, 'video_comments', '* * * * *', 'BxDolCronVideoComments', 'flash/modules/video_comments/inc/classes/BxDolCronVideoComments.php', ''),
(4, 'sitemap', '0 2 * * *', '', '', 'bx_import(''BxDolSiteMaps'');\r\nBxDolSiteMaps::generateAllSiteMaps();'),
(5, 'modules', '0 0 * * 0', 'BxDolCronModules', 'inc/classes/BxDolCronModules.php', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_dnsbluri_zones`
--

CREATE TABLE `sys_dnsbluri_zones` (
  `level` tinyint(4) NOT NULL,
  `zone` varchar(64) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_dnsbl_rules`
--

CREATE TABLE `sys_dnsbl_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chain` enum('spammers','whitelist','uridns') NOT NULL,
  `zonedomain` varchar(255) NOT NULL,
  `postvresp` varchar(32) NOT NULL,
  `url` varchar(255) NOT NULL,
  `recheck` varchar(255) NOT NULL,
  `comment` varchar(255) NOT NULL,
  `added` int(11) NOT NULL,
  `active` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

--
-- Dumping data for table `sys_dnsbl_rules`
--

INSERT INTO `sys_dnsbl_rules` VALUES
(1, 'whitelist', 'au.countries.nerd.dk.', '127.0.0.2', 'http://countries.nerd.dk/', '', 'Country based zone, any ip from Australia is whitelisted', 1287642420, 0),
(2, 'spammers', 'sbl.spamhaus.org.', 'any', 'http://www.spamhaus.org/sbl/', 'http://www.spamhaus.org/query/bl?ip=%s', 'Any non-failure result from sbl.spamhaus.org is a positive match', 1287642420, 1),
(4, 'spammers', 'cn.countries.nerd.dk.', '127.0.0.2', 'http://countries.nerd.dk/', '', 'Country based zone, any ip from China is blocked', 1287642420, 0),
(5, 'uridns', 'multi.surbl.org.', 'any', 'http://www.surbl.org/', 'http://george.surbl.org/lookup.html', 'SURBLs are lists of web sites that have appeared in unsolicited messages. Unlike most lists, SURBLs are not lists of message senders.', 1287642420, 1),
(6, 'spammers', 'dnsbl.dronebl.org.', '127.0.0.5', 'http://www.dronebl.org/', 'http://www.dronebl.org/lookup?ip=%s', 'Bottler', 1368854835, 1),
(7, 'spammers', 'dnsbl.dronebl.org.', '127.0.0.6', 'http://www.dronebl.org/', 'http://www.dronebl.org/lookup?ip=%s', 'Unknown spambot or drone', 1368854835, 1),
(8, 'spammers', 'dnsbl.dronebl.org.', '127.0.0.7', 'http://www.dronebl.org/', 'http://www.dronebl.org/lookup?ip=%s', 'DDOS Drone', 1368854835, 1),
(9, 'spammers', 'dnsbl.dronebl.org.', '127.0.0.8', 'http://www.dronebl.org/', 'http://www.dronebl.org/lookup?ip=%s', 'SOCKS Proxy', 1368854835, 1),
(10, 'spammers', 'dnsbl.dronebl.org.', '127.0.0.9', 'http://www.dronebl.org/', 'http://www.dronebl.org/lookup?ip=%s', 'HTTP Proxy', 1368854835, 1),
(11, 'spammers', 'dnsbl.dronebl.org.', '127.0.0.10', 'http://www.dronebl.org/', 'http://www.dronebl.org/lookup?ip=%s', 'ProxyChain', 1368854835, 1),
(12, 'spammers', 'dnsbl.dronebl.org.', '127.0.0.14', 'http://www.dronebl.org/', 'http://www.dronebl.org/lookup?ip=%s', 'Open Wingate Proxy', 1368854835, 1),
(13, 'spammers', 'dnsbl.dronebl.org.', '127.0.0.15', 'http://www.dronebl.org/', 'http://www.dronebl.org/lookup?ip=%s', 'Compromised router / gateway', 1368854835, 1),
(14, 'spammers', 'dnsbl.tornevall.org.', '230', 'http://dnsbl.tornevall.org/', '', 'Block anonymous/elite proxies and abuse IPs', 1369274751, 1),
(15, 'spammers', 'uribl.swinog.ch.', '127.0.0.3', 'http://antispam.imp.ch/06-dnsbl.php?lng=1', '', 'ImproWare Antispam', 1393336086, 0),
(16, 'uridns', 'uribl.swinog.ch.', 'any', 'http://antispam.imp.ch/05-uribl.php?lng=1', '', 'ImproWare Antispam', 1393336170, 0);

-- --------------------------------------------------------

--
-- Table structure for table `sys_email_templates`
--

CREATE TABLE `sys_email_templates` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) NOT NULL,
  `Subject` varchar(255) NOT NULL,
  `Body` text NOT NULL,
  `Desc` varchar(255) NOT NULL,
  `LangID` tinyint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`ID`),
  KEY `Name` (`Name`,`LangID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=30 ;

--
-- Dumping data for table `sys_email_templates`
--

INSERT INTO `sys_email_templates` VALUES
(1, 't_Activation', 'Your Profile Is Now Active', '<bx_include_auto:_email_header.html />\r\n\r\n<p><b>Dear <RealName></b>,</p>\r\n\r\n<p>Your profile was reviewed and activated!</p>\r\n\r\n<p>Your Account: <a href="<Domain>member.php"><Domain>member.php</a></p>\r\n\r\n<p>Member ID: <b><recipientID></b></p>\r\n\r\n<p>Your E-mail: <span style="color:#FF6633"><Email></span></p>\r\n\r\n<bx_include_auto:_email_footer.html />', 'Profile activation notification.', 0),
(2, 't_AdminEmail', '<SiteName> Admin: <MessageSubject>', '<bx_include_auto:_email_header.html />\r\n\r\n<p><b>Dear <RealName></b>,</p>\r\n\r\n<p><a href="<Domain>"><SiteName></a> Admin sent you a message:</p>\r\n\r\n<hr>\r\n<p style="color:#3B5C8E"><MessageText></p>\r\n<hr>\r\n\r\n<bx_include_auto:_email_footer.html />', 'Message from the site Admin.', 0),
(3, 't_AdminStats', 'Content Pending Admin Review', '<bx_include_auto:_email_header.html />\r\n\r\n<p><b>Dear <RealName></b>,</p>\r\n\r\n<p><MessageText></p>\r\n\r\n<p>Go to <a href="<ViewLink>">administration panel</a> to review pending content.</p>\r\n\r\n<bx_include_auto:_email_footer.html />', 'Message to admin about content pending review', 0),
(4, 't_Compose', 'You''ve Got A New Message', '<bx_include_auto:_email_header.html />\r\n\r\n<p><b>Hello <RealName></b>,</p>\r\n\r\n<p>You have received a message from <a href="<ProfileUrl>"><ProfileReference></a>!</p>\r\n\r\n<p>Go to your account to read and reply: <a href="<Domain>member.php"><Domain>member.php</a></p>\r\n\r\n<bx_include_auto:_email_footer.html />', 'New message notification without message text', 0),
(5, 't_Confirmation', 'Email Confirmation Request', '<bx_include_auto:_email_header.html />\r\n\r\n<p><b>Dear <RealName></b>,</p>\r\n\r\n<p>Thank you for registering at <SiteName>!</p>\r\n\r\n<p>Click to confirm your email:\r\n<a href="<ConfirmationLink>"><ConfirmationLink></a></p>\r\n\r\n<p>CONFIRMATION CODE: <ConfCode></p>\r\n\r\n<bx_include_auto:_email_footer.html />', 'Email confirmation message.', 0),
(6, 't_CupidMail', 'Your Matches', '<bx_include_auto:_email_header.html />\r\n\r\n<p><b>Hello <RealName></b>,</p>\r\n\r\n<p>Check out some <SiteName> members that may be a good match with you:</p>\r\n\r\n<p><a href="<MatchProfileLink>"><MatchProfileLink></a></p>\r\n\r\n\r\n<bx_include_auto:_email_footer.html />', 'Matching profiles notification.', 0),
(7, 't_Forgot', 'Your Account Password', '<bx_include_auto:_email_header.html />\r\n\r\n<p><b>Dear <RealName></b>,</p>\r\n\r\n<p>Your member ID: <b><recipientID></b></p>\r\n\r\n<p>Your password: <b><Password></b></p>\r\n\r\n<p>You may login here: <a href="<Domain>member.php"><Domain>member.php</a></p>\r\n\r\n\r\n<bx_include_auto:_email_footer.html />', 'Password retrieval', 0),
(8, 't_FreeEmail', 'Member Email Address', '<bx_include_auto:_email_header.html />\r\n\r\n<p><b>Dear <RealName></b>,</p>\r\n\r\n<p><profileNickName>''s contact info:</p> \r\n\r\n<p><profileContactInfo></p>\r\n\r\n\r\n<bx_include_auto:_email_footer.html />', 'Requested Member Email Address', 0),
(9, 't_MemExpiration', 'Your Membership Is About To Expire', '<bx_include_auto:_email_header.html />\r\n\r\n<p><b>Hello <RealName></b>,</p>\r\n\r\n<p>Your <SiteName> <MembershipName> membership will expire in <ExpireDays> days.</p>\r\n\r\n<p>NOTE: -1 means it has already expired</p>\r\n\r\n\r\n<p><a href="<Domain>modules/?r=membership/index/">Renew Membership</a></p>\r\n<bx_include_auto:_email_footer.html />', 'Membership expiration notice', 0),
(10, 't_MemChanged', 'Your Membership Changed', '<bx_include_auto:_email_header.html />\r\n\r\n<p><b>Hello <RealName></b>,</p>\r\n\r\n<p>Your membership level was changed to: <b><a href="<Domain>modules/?r=membership/index/"><MembershipLevel></a></b></p>\r\n\r\n\r\n<bx_include_auto:_email_footer.html />', 'Membership change', 0),
(11, 't_Message', 'You''ve Got A New Message', '<bx_include_auto:_email_header.html />\r\n\r\n<p><b>Dear <RealName></b>,</p>\r\n\r\n<p><a href="<ProfileUrl>"><ProfileReference></a> sent you a message: </p>\r\n\r\n<hr>\r\n<p><MessageText></p>\r\n<hr>\r\n\r\n<p>Go to your account to reply: <a href="<Domain>member.php"><Domain>member.php</a></p>\r\n\r\n<bx_include_auto:_email_footer.html />', 'New message notification with message text', 0),
(12, 't_UserJoined', 'New Member Joined', '<bx_include_auto:_email_header.html />\r\n\r\n<p>New user: <RealName></p> \r\n<p>Email: <Email></p> \r\n\r\n<bx_include_auto:_email_footer.html />', 'Admin notification about new member', 0),
(13, 't_UserConfirmed', 'User Confirmed Email', '<bx_include_auto:_email_header.html />\r\n\r\n<p>User: <RealName></p> \r\n<p>Email: <Email></p> \r\n\r\n<bx_include_auto:_email_footer.html />', 'Admin notification - user confirmed email', 0),
(14, 't_UserMemChanged', 'Member Membership Changed', '<bx_include_auto:_email_header.html />\r\n\r\n<p><RealName>''s membership level was changed to: <b><MembershipLevel></b></p>\r\n\r\n\r\n<bx_include_auto:_email_footer.html />', 'Admin notification about membership change', 0),
(15, 't_UserUnregistered', 'Member Unregistered', '<bx_include_auto:_email_header.html />\r\n\r\n<p>User: <NickName></p> \r\n<p>Email: <Email></p> \r\n<p>was unregistered.</p> \r\n\r\n<bx_include_auto:_email_footer.html />', 'Admin notification about unregistered member', 0),
(16, 't_SpamReport', 'Profile Spam Report', '<bx_include_auto:_email_header.html />\r\n\r\n<p><a href="<Domain>profile.php?ID=<reporterID>"><reporterNick></a> reported Profile SPAM:  <a href="<Domain>profile.php?ID=<spamerID>"><b><spamerNick></b></a></p>\r\n\r\n<bx_include_auto:_email_footer.html />', 'Profile Spam Report', 0),
(17, 't_TellFriend', 'Check This Out!', '<bx_include_auto:_email_header.html />\r\n\r\n\r\n<p>I thought you''d be interested: <a href="<Link>"><Link></a><br />\r\n---<br />\r\n<a href="<SenderLink>"><SenderName></a>\r\n</p>\r\n\r\n<bx_include_auto:_email_footer.html />', 'Friend Invitation', 0),
(18, 't_TellFriendProfile', 'Look At This Profile', '<bx_include_auto:_email_header.html />\r\n\r\n\r\n\r\n<p>Check out this profile: <a href="<Link>"><Link></a><br />\r\n---<br />\r\n<a href="<SenderLink>"><SenderName></a>\r\n</p>\r\n\r\n<bx_include_auto:_email_footer.html />', 'Email profile to a friend', 0),
(19, 't_VKiss', 'Greeting notification', '<bx_include_auto:_email_header.html />\r\n\r\n<p><b>Dear <RealName></b>,</p>\r\n\r\n<p><ProfileReference> sent you a greeting!</p>\r\n\r\n<p><ProfileReference> may be interested in you or maybe just wants to say Hello!\r\n</p>\r\n\r\n<bx_include_auto:_email_footer.html />', 'Greeting notification ', 0),
(20, 't_VKiss_visitor', 'Greeting notification', '<bx_include_auto:_email_header.html />\r\n\r\n<p><b>Dear <RealName></b>,</p>\r\n\r\n<p>Our site visitor sent you a greeting!</p>\r\n\r\n\r\n<bx_include_auto:_email_footer.html />', 'Greeting from visitor notification', 0),
(21, 't_MessageCopy', 'Copy Of Your Message : <your subject here>', '<bx_include_auto:_email_header.html />\r\n\r\n<p>You wrote:</p>\r\n<hr>\r\n<p><your message here></p>\r\n<hr>\r\n\r\n<bx_include_auto:_email_footer.html />', 'Message copy', 0),
(22, 't_Subscription', 'Your Subscription', '<bx_include_auto:_email_header.html />\r\n\r\n<p><b>Dear <RealName></b>,</p>\r\n\r\n<p>You subscribed to <a href="<ViewLink>"><Subscription></a></p>\r\n\r\n<p>You may cancel the subscription here: <a href="<SysUnsubscribeLink>"><SysUnsubscribeLink></a></p>\r\n\r\n<bx_include_auto:_email_footer.html />', 'Subscription confirmation', 0),
(23, 't_sbsProfileComments', 'New Profile Comments', '<bx_include_auto:_email_header.html />\r\n\r\n <p><b>Dear <RealName></b>,</p>\r\n\r\n<p>Profile you subscribed to got <a href="<ViewLink>">new comments</a>.</p>\r\n\r\n<bx_include_auto:_email_footer.html />', 'New comments to profile subscription', 0),
(24, 't_sbsProfileEdit', 'Subscription: Profile Edited', '<bx_include_auto:_email_header.html />\r\n\r\n<p><b>Dear <RealName></b>,</p>\r\n\r\n<p><a href="<ViewLink>">Profile you subscribed to</a> has been updated.</p>\r\n\r\n<bx_include_auto:_email_footer.html />', 'Profile info subscription.', 0),
(25, 't_FriendRequest', 'Friendship Request', '<bx_include_auto:_email_header.html />\r\n\r\n    <p><b>Dear <Recipient></b>,</p>\r\n   \r\n    <p><a href="<SenderLink>"><Sender></a> wants to be friends with you. <a href="<RequestLink>">Respond</a>.</p>\r\n    <br /> \r\n    <bx_include_auto:_email_footer.html />', 'Friendship Request', 0),
(26, 't_FriendRequestAccepted', 'Friendship Request Accepted', '<bx_include_auto:_email_header.html />\r\n\r\n    <p><b>Dear <Recipient></b>,</p>\r\n    \r\n    <p><a href="<SenderLink>"><Sender></a> accepted your friendship request.</p>\r\n    <br /> \r\n    <bx_include_auto:_email_footer.html />', 'Friendship Request Accepted', 0),
(27, 't_SpamReportAuto', '<SiteName> Automatic Spam Report', '<bx_include_auto:_email_header.html />\r\n\r\n\r\n<b>Profile:</b> <a href="<SpammerUrl>"><SpammerNickName></a><br />\r\n\r\n<b>Page:</b> <Page><br />\r\n\r\n<b>GET variables:</b>\r\n<pre>\r\n<Get>\r\n</pre>\r\n\r\n<b>Spam Content:</b>\r\n<pre>\r\n<SpamContent>\r\n</pre>\r\n\r\n\r\n<bx_include_auto:_email_footer.html />', 'Automatic spam report', 0),
(28, 't_ModulesUpdates', '<SiteName> Automatic modules updates checker', '<bx_include_auto:_email_header.html />\r\n\r\n\r\n<p><b>Dear <RealName></b>,</p>\r\n\r\n<p>The following updates are available:</p>\r\n\r\n<p><MessageText></p>\r\n\r\n<p>If you want to install any of them you need to go to your site''s admin panel -> Modules -> Add & Manage and click Check For Updates button in Installed Modules block. It will load all available updates.</p>\r\n\r\n\r\n<bx_include_auto:_email_footer.html />', 'Message to admin about modules updates', 0),
(29, 't_ExportReady', '<SiteName> Your data export is ready', '<bx_include_auto:_email_header.html />\r\n\r\n\r\n<p><b>Dear <RealName></b>,</p>\r\n\r\n<p>Your data download link:</p>\r\n\r\n<p><FileUrl></p>\r\n\r\n<p>Link will be availiable for 24 hours.</p>\r\n\r\n\r\n<bx_include_auto:_email_footer.html />', 'Notification about user data export', 0);

-- --------------------------------------------------------

--
-- Table structure for table `sys_fave_list`
--

CREATE TABLE `sys_fave_list` (
  `ID` int(10) unsigned NOT NULL DEFAULT '0',
  `Profile` int(10) unsigned NOT NULL DEFAULT '0',
  `When` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY `HotPair` (`ID`,`Profile`),
  KEY `ID` (`ID`),
  KEY `Profile` (`Profile`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_friend_list`
--

CREATE TABLE `sys_friend_list` (
  `ID` int(10) unsigned NOT NULL DEFAULT '0',
  `Profile` int(10) unsigned NOT NULL DEFAULT '0',
  `Check` tinyint(2) NOT NULL DEFAULT '0',
  `When` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY `FriendPair` (`ID`,`Profile`),
  KEY `Profile` (`Profile`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_greetings`
--

CREATE TABLE `sys_greetings` (
  `ID` int(10) unsigned NOT NULL DEFAULT '0',
  `Profile` int(10) unsigned NOT NULL DEFAULT '0',
  `Number` smallint(5) unsigned NOT NULL DEFAULT '0',
  `When` date NOT NULL DEFAULT '0000-00-00',
  `New` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`ID`,`Profile`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_injections`
--

CREATE TABLE `sys_injections` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL DEFAULT '',
  `page_index` int(11) NOT NULL DEFAULT '0',
  `key` varchar(128) NOT NULL DEFAULT '',
  `type` enum('text','php') NOT NULL DEFAULT 'text',
  `data` text NOT NULL,
  `replace` tinyint(4) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `sys_injections`
--

INSERT INTO `sys_injections` VALUES
(1, 'flash_integration', 0, 'injection_header', 'php', 'return getRayIntegrationJS(true);', 0, 1),
(2, 'banner_bottom', 0, 'banner_bottom', 'php', 'return banner_put_nv(4);', 0, 1),
(3, 'banner_right', 0, 'banner_right', 'php', 'return banner_put_nv(3);', 0, 1),
(4, 'banner_top', 0, 'banner_top', 'php', 'return banner_put_nv(1);', 0, 1),
(5, 'banner_left', 0, 'banner_left', 'php', 'return banner_put_nv(2);', 0, 1),
(6, 'sys_confirm_popup', 0, 'injection_footer', 'php', 'return $GLOBALS[''oSysTemplate'']->parseHtmlByName(''transBoxConfirm.html'', array());', 0, 1),
(7, 'sys_prompt_popup', 0, 'injection_footer', 'php', 'return $GLOBALS[''oSysTemplate'']->parseHtmlByName(''transBoxPrompt.html'', array());', 0, 1),
(8, 'sys_head', 0, 'injection_head', 'text', '', 0, 1),
(9, 'sys_body', 0, 'injection_footer', 'text', '', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_injections_admin`
--

CREATE TABLE `sys_injections_admin` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL DEFAULT '',
  `page_index` int(11) NOT NULL DEFAULT '0',
  `key` varchar(128) NOT NULL DEFAULT '',
  `type` enum('text','php') NOT NULL DEFAULT 'text',
  `data` text NOT NULL,
  `replace` tinyint(4) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `sys_injections_admin`
--

INSERT INTO `sys_injections_admin` VALUES
(1, 'flash_integration', 0, 'injection_header', 'php', 'return getRayIntegrationJS();', 0, 1),
(2, 'lfa', 0, 'injection_header', 'php', 'return lfa();', 0, 1),
(3, 'sys_confirm_popup', 0, 'injection_footer', 'php', 'return $GLOBALS[''oSysTemplate'']->parseHtmlByName(''transBoxConfirm.html'', array());', 0, 1),
(4, 'sys_prompt_popup', 0, 'injection_footer', 'php', 'return $GLOBALS[''oSysTemplate'']->parseHtmlByName(''transBoxPrompt.html'', array());', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_ip_list`
--

CREATE TABLE `sys_ip_list` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `From` int(10) unsigned NOT NULL,
  `To` int(10) unsigned NOT NULL,
  `Type` enum('allow','deny') NOT NULL DEFAULT 'deny',
  `LastDT` int(11) unsigned NOT NULL,
  `Desc` varchar(128) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `From` (`From`),
  KEY `To` (`To`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_ip_members_visits`
--

CREATE TABLE `sys_ip_members_visits` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `MemberID` int(10) unsigned NOT NULL,
  `From` int(10) unsigned NOT NULL,
  `DateTime` datetime NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `From` (`From`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_localization_categories`
--

CREATE TABLE `sys_localization_categories` (
  `ID` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Name` (`Name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_localization_categories`
--

INSERT INTO `sys_localization_categories` VALUES
(1, 'System');

-- --------------------------------------------------------

--
-- Table structure for table `sys_localization_keys`
--

CREATE TABLE `sys_localization_keys` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IDCategory` int(6) unsigned NOT NULL DEFAULT '0',
  `Key` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Key` (`Key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2269 ;

--
-- Dumping data for table `sys_localization_keys`
--

INSERT INTO `sys_localization_keys` VALUES
(1, 1, '_ABOUT_US'),
(2, 1, '_ABOUT_US_H'),
(3, 1, '_ACTION_EVERY_PERIOD'),
(4, 1, '_ACTION_LIMIT_REACHED'),
(5, 1, '_ACTION_NOT_ACTIVE'),
(6, 1, '_ACTION_NOT_ALLOWED'),
(7, 1, '_ACTION_NOT_ALLOWED_AFTER'),
(8, 1, '_ACTION_NOT_ALLOWED_BEFORE'),
(9, 1, '_ACTIVATION_EMAIL_H'),
(10, 1, '_ACTIVATION_EMAIL_H1'),
(11, 1, '_ADM_PROFILE_SEND_MSG'),
(12, 1, '_ADVICE'),
(13, 1, '_ADVICE_H'),
(14, 1, '_ADVICE_H1'),
(15, 1, '_ALREADY_ACTIVATED'),
(16, 1, '_ATT_ACTIVE'),
(17, 1, '_ATT_ACTIVE_E'),
(18, 1, '_ATT_APPROVAL'),
(19, 1, '_ATT_APPROVAL_E'),
(20, 1, '_ATT_REJECTED'),
(21, 1, '_ATT_REJECTED_E'),
(22, 1, '_ATT_SUSPENDED'),
(23, 1, '_ATT_SUSPENDED_E'),
(24, 1, '_ATT_UNCONFIRMED'),
(25, 1, '_ATT_UNCONFIRMED_E'),
(26, 1, '_About'),
(27, 1, '_About Us'),
(28, 1, '_Access denied'),
(29, 1, '_Account'),
(30, 1, '_Account Home'),
(31, 1, '_Account Info'),
(32, 1, '_Action'),
(33, 1, '_Actions'),
(34, 1, '_Activate account'),
(35, 1, '_Active'),
(36, 1, '_Activity'),
(37, 1, '_Add Category'),
(38, 1, '_Add Post'),
(39, 1, '_Add Your Comment'),
(40, 1, '_Added'),
(41, 1, '_Added by'),
(42, 1, '_Additional information'),
(43, 1, '_Admin'),
(44, 1, '_Admin Panel'),
(45, 1, '_Advice'),
(46, 1, '_All'),
(47, 1, '_All Members'),
(48, 1, '_Allowed Since'),
(49, 1, '_Allowed Until'),
(50, 1, '_Allowed actions'),
(51, 1, '_Anonymous'),
(52, 1, '_Any'),
(53, 1, '_Approval'),
(54, 1, '_Approve'),
(55, 1, '_April'),
(56, 1, '_Archive'),
(57, 1, '_Are_you_sure'),
(58, 1, '_August'),
(59, 1, '_Auth type'),
(60, 1, '_Author'),
(61, 1, '_Away'),
(62, 1, '_Back'),
(63, 1, '_Back Invite'),
(64, 1, '_Basic'),
(65, 1, '_Befriend'),
(66, 1, '_Birthdays'),
(67, 1, '_Block'),
(68, 1, '_Block list'),
(69, 1, '_Bookmark'),
(70, 1, '_BoonEx News'),
(71, 1, '_Bottom'),
(72, 1, '_Browse'),
(73, 1, '_Browse Profiles'),
(74, 1, '_Busy'),
(75, 1, '_By'),
(76, 1, '_By Age'),
(77, 1, '_By Country'),
(78, 1, '_By Female'),
(79, 1, '_By Male'),
(80, 1, '_By Sex'),
(81, 1, '_CHANGE_STATUS_H'),
(82, 1, '_CHANGE_STATUS_H1'),
(83, 1, '_COMPOSE_H'),
(84, 1, '_COMPOSE_H1'),
(85, 1, '_CONTACT'),
(86, 1, '_CONTACT_H'),
(87, 1, '_CONTACT_H1'),
(88, 1, '_Can not delete comments with replies'),
(89, 1, '_Cancel'),
(90, 1, '_Cancel_Uploads'),
(91, 1, '_Captcha check failed'),
(92, 1, '_Caption'),
(93, 1, '_Categories'),
(94, 1, '_CategoriesSettings'),
(95, 1, '_Category'),
(96, 1, '_Chat'),
(97, 1, '_Choose'),
(98, 1, '_City'),
(99, 1, '_Click here'),
(100, 1, '_Click to sort'),
(101, 1, '_Close'),
(102, 1, '_Code Block'),
(103, 1, '_Comment Negative'),
(104, 1, '_Comment Neutral'),
(105, 1, '_Comment Positive'),
(106, 1, '_Comments'),
(107, 1, '_Compose'),
(108, 1, '_Compose new letter'),
(109, 1, '_Confirm password'),
(110, 1, '_Confirm password descr'),
(111, 1, '_Confirmation code'),
(112, 1, '_Contact'),
(113, 1, '_Contact information not sent'),
(114, 1, '_Contact information sent'),
(115, 1, '_Contacted'),
(116, 1, '_Content'),
(117, 1, '_Continue'),
(118, 1, '_Control Panel'),
(119, 1, '_Count'),
(120, 1, '_Counter'),
(121, 1, '_Country'),
(122, 1, '_Couple'),
(123, 1, '_Couple profile not found'),
(124, 1, '_Customize'),
(125, 1, '_DELETE_SUCCESS'),
(126, 1, '_DELETE_TEXT'),
(127, 1, '_Dashboard'),
(128, 1, '_Database Error'),
(129, 1, '_Date'),
(130, 1, '_De-Feature it'),
(131, 1, '_December'),
(132, 1, '_Delete'),
(133, 1, '_Delete account'),
(134, 1, '_Delete image'),
(135, 1, '_Description'),
(136, 1, '_Disapprove'),
(137, 1, '_Download'),
(138, 1, '_Duplicate vote'),
(139, 1, '_E-mail'),
(140, 1, '_E-mail or ID'),
(141, 1, '_EMAIL_CONF_FAILED_EX'),
(142, 1, '_EMAIL_CONF_NOT_SENT'),
(143, 1, '_EMAIL_CONF_SENT'),
(144, 1, '_EMAIL_CONF_SUCCEEDED'),
(145, 1, '_ENTER_CONF_CODE'),
(146, 1, '_ERROR_WHILE_PROCESSING'),
(147, 1, '_EXPLANATION_H'),
(148, 1, '_Edit'),
(149, 1, '_Edit Profile'),
(150, 1, '_EditProfile'),
(151, 1, '_Edit_profile_and_settings'),
(152, 1, '_Email'),
(153, 1, '_Email confirmation'),
(154, 1, '_Email confirmation Ex'),
(155, 1, '_Email sent failed'),
(156, 1, '_Email was successfully sent'),
(157, 1, '_Embed'),
(158, 1, '_Empty'),
(159, 1, '_Enter Captcha'),
(160, 1, '_Enter email(s)'),
(161, 1, '_Enter new URL'),
(162, 1, '_Enter what you see'),
(163, 1, '_Enter_value_here'),
(164, 1, '_Error'),
(165, 1, '_Error Occured'),
(166, 1, '_Error occured'),
(167, 1, '_Errors in join form'),
(168, 1, '_Expiration date'),
(169, 1, '_Extended'),
(170, 1, '_Exception_user_msg'),
(171, 1, '_Exception_uncaught_msg'),
(172, 1, '_Exception_uncaught_in_msg'),
(173, 1, '_FAILED_TO_SEND_MESSAGE'),
(174, 1, '_FAILED_TO_SEND_MESSAGE_BLOCK'),
(175, 1, '_FAILED_TO_SEND_MESSAGE_MEMBERSHIP_DISALLOW'),
(176, 1, '_FAILED_TO_SEND_MESSAGE_NOT_ACTIVE'),
(177, 1, '_FAQ'),
(178, 1, '_FAQ_H'),
(179, 1, '_FAQ_H1'),
(180, 1, '_FAQ_INFO'),
(181, 1, '_FORGOT'),
(182, 1, '_FREEMAIL_ALREADY_SENT'),
(183, 1, '_FREEMAIL_BLOCK'),
(184, 1, '_FREEMAIL_ERROR'),
(185, 1, '_FREEMAIL_H'),
(186, 1, '_FREEMAIL_NOT_ALLOWED'),
(187, 1, '_FREEMAIL_NOT_KISSED'),
(188, 1, '_FREEMAIL_SENT'),
(189, 1, '_Failed to apply changes'),
(190, 1, '_Fave'),
(191, 1, '_Remove Fave'),
(192, 1, '_Faves'),
(193, 1, '_Feature it'),
(194, 1, '_Featured'),
(195, 1, '_February'),
(196, 1, '_Female'),
(197, 1, '_FieldCaption_Admin Controls_View'),
(198, 1, '_FieldCaption_DateReg_View'),
(199, 1, '_FieldCaption_General Info_View'),
(200, 1, '_FieldCaption_Misc_View'),
(201, 1, '_FieldCaption_Sex_Join'),
(202, 1, '_FieldCaption_Admin Controls_Edit'),
(203, 1, '_FieldCaption_Admin Controls_Join'),
(204, 1, '_FieldCaption_Age_View'),
(205, 1, '_FieldCaption_Captcha_Join'),
(206, 1, '_FieldCaption_City_Edit'),
(207, 1, '_FieldCaption_City_Join'),
(208, 1, '_FieldCaption_City_Search'),
(209, 1, '_FieldCaption_City_View'),
(210, 1, '_FieldCaption_Country_Edit'),
(211, 1, '_FieldCaption_Country_Join'),
(212, 1, '_FieldCaption_Country_Search'),
(213, 1, '_FieldCaption_Country_View'),
(214, 1, '_FieldCaption_Couple_Join'),
(215, 1, '_FieldCaption_Couple_Search'),
(216, 1, '_FieldCaption_DateLastEdit_View'),
(217, 1, '_FieldCaption_DateLastLogin_View'),
(218, 1, '_FieldCaption_DateLastNav_View'),
(219, 1, '_FieldCaption_DateOfBirth_Edit'),
(220, 1, '_FieldCaption_DateOfBirth_Join'),
(221, 1, '_FieldCaption_DateOfBirth_Search'),
(222, 1, '_FieldCaption_DateOfBirth_View'),
(223, 1, '_FieldCaption_DescriptionMe_Edit'),
(224, 1, '_FieldCaption_DescriptionMe_Join'),
(225, 1, '_FieldCaption_DescriptionMe_View'),
(226, 1, '_FieldCaption_Description_Join'),
(227, 1, '_FieldCaption_Description_View'),
(228, 1, '_FieldCaption_Education_Edit'),
(229, 1, '_FieldCaption_Education_View'),
(230, 1, '_FieldCaption_EmailNotify_Edit'),
(231, 1, '_FieldCaption_EmailNotify_Join'),
(232, 1, '_FieldCaption_Email_Edit'),
(233, 1, '_FieldCaption_Email_Join'),
(234, 1, '_FieldCaption_Email_View'),
(235, 1, '_FieldCaption_Ethnicity_Edit'),
(236, 1, '_FieldCaption_Ethnicity_View'),
(237, 1, '_FieldCaption_FavoriteBooks_Edit'),
(238, 1, '_FieldCaption_FavoriteBooks_View'),
(239, 1, '_FieldCaption_FavoriteFilms_Edit'),
(240, 1, '_FieldCaption_FavoriteFilms_View'),
(241, 1, '_FieldCaption_FavoriteMusic_Edit'),
(242, 1, '_FieldCaption_FavoriteMusic_View'),
(243, 1, '_FieldCaption_FavoriteSites_Edit'),
(244, 1, '_FieldCaption_FavoriteSites_View'),
(245, 1, '_FieldCaption_Featured_Edit'),
(246, 1, '_FieldCaption_General Info_Edit'),
(247, 1, '_FieldCaption_General Info_Join'),
(248, 1, '_FieldCaption_General Info_Search'),
(249, 1, '_FieldCaption_Headline_Edit'),
(250, 1, '_FieldCaption_Headline_Join'),
(251, 1, '_FieldCaption_Headline_View'),
(252, 1, '_FieldCaption_Height_Edit'),
(253, 1, '_FieldCaption_Height_View'),
(254, 1, '_FieldCaption_Hobbies_Edit'),
(255, 1, '_FieldCaption_Hobbies_View'),
(256, 1, '_FieldCaption_ID_Search'),
(257, 1, '_FieldCaption_ID_View'),
(258, 1, '_FieldCaption_Income_Edit'),
(259, 1, '_FieldCaption_Income_View'),
(260, 1, '_FieldCaption_Interests_Edit'),
(261, 1, '_FieldCaption_Interests_View'),
(262, 1, '_FieldCaption_Keyword_Search'),
(263, 1, '_FieldCaption_FirstName_Edit'),
(264, 1, '_FieldCaption_FirstName_Join'),
(265, 1, '_FieldCaption_FirstName_View'),
(266, 1, '_FieldCaption_FullName_Edit'),
(267, 1, '_FieldCaption_FullName_Join'),
(268, 1, '_FieldCaption_FullName_View'),
(269, 1, '_FieldCaption_LastName_Edit'),
(270, 1, '_FieldCaption_LastName_Join'),
(271, 1, '_FieldCaption_LastName_View'),
(272, 1, '_FieldCaption_Location_Search'),
(273, 1, '_FieldCaption_LookingFor_Edit'),
(274, 1, '_FieldCaption_LookingFor_Join'),
(275, 1, '_FieldCaption_LookingFor_Search'),
(276, 1, '_FieldCaption_LookingFor_View'),
(277, 1, '_FieldCaption_Membership_Edit'),
(278, 1, '_FieldCaption_Misc Info_Edit'),
(279, 1, '_FieldCaption_Misc Info_Join'),
(280, 1, '_FieldCaption_Misc Info_Search'),
(281, 1, '_FieldCaption_Misc Info_View'),
(282, 1, '_FieldCaption_NickName_Edit'),
(283, 1, '_FieldCaption_NickName_Join'),
(284, 1, '_FieldCaption_NickName_Search'),
(285, 1, '_FieldCaption_NickName_View'),
(286, 1, '_FieldCaption_Occupation_Edit'),
(287, 1, '_FieldCaption_Occupation_View'),
(288, 1, '_FieldCaption_Password_Edit'),
(289, 1, '_FieldCaption_Password_Join'),
(290, 1, '_FieldCaption_Profile Type_Join'),
(291, 1, '_FieldCaption_ProfilePhoto_Join'),
(292, 1, '_FieldCaption_RelationshipStatus_Edit'),
(293, 1, '_FieldCaption_RelationshipStatus_View'),
(294, 1, '_FieldCaption_Religion_Edit'),
(295, 1, '_FieldCaption_Religion_View'),
(296, 1, '_FieldCaption_Religious_Edit'),
(297, 1, '_FieldCaption_Sex_Edit'),
(298, 1, '_FieldCaption_Sex_Search'),
(299, 1, '_FieldCaption_Sex_View'),
(300, 1, '_FieldCaption_Status_Edit'),
(301, 1, '_FieldCaption_Status_View'),
(302, 1, '_FieldCaption_Tags_Edit'),
(303, 1, '_FieldCaption_Tags_Join'),
(304, 1, '_FieldCaption_Tags_Search'),
(305, 1, '_FieldCaption_Tags_View'),
(306, 1, '_FieldCaption_TermsOfUse_Join'),
(307, 1, '_FieldCaption_Weight_Edit'),
(308, 1, '_FieldCaption_Weight_View'),
(309, 1, '_FieldCaption_allow_view_to_Edit'),
(310, 1, '_FieldCaption_zip_Edit'),
(311, 1, '_FieldCaption_zip_Join'),
(312, 1, '_FieldDesc_Sex_Join'),
(313, 1, '_FieldDesc_Captcha_Join'),
(314, 1, '_FieldDesc_City_Join'),
(315, 1, '_FieldDesc_Country_Join'),
(316, 1, '_FieldDesc_Couple_Join'),
(317, 1, '_FieldDesc_DateLastEdit_View'),
(318, 1, '_FieldDesc_DateLastLogin_View'),
(319, 1, '_FieldDesc_DateOfBirth_Join'),
(320, 1, '_FieldDesc_DescriptionMe_Join'),
(321, 1, '_FieldDesc_Education_Edit'),
(322, 1, '_FieldDesc_Email_Join'),
(323, 1, '_FieldDesc_Ethnicity_Edit'),
(324, 1, '_FieldDesc_FavoriteBooks_Edit'),
(325, 1, '_FieldDesc_FavoriteFilms_Edit'),
(326, 1, '_FieldDesc_FavoriteMusic_Edit'),
(327, 1, '_FieldDesc_FavoriteSites_Edit'),
(328, 1, '_FieldDesc_Featured_Edit'),
(329, 1, '_FieldDesc_Headline_Join'),
(330, 1, '_FieldDesc_Height_Edit'),
(331, 1, '_FieldDesc_Hobbies_Edit'),
(332, 1, '_FieldDesc_ID_View'),
(333, 1, '_FieldDesc_Income_Edit'),
(334, 1, '_FieldDesc_Interests_Edit'),
(335, 1, '_FieldDesc_FirstName_Join'),
(336, 1, '_FieldDesc_FullName_Join'),
(337, 1, '_FieldDesc_LastName_Join'),
(338, 1, '_FieldDesc_LookingFor_Join'),
(339, 1, '_FieldDesc_Membership_Edit'),
(340, 1, '_FieldDesc_NickName_Join'),
(341, 1, '_FieldDesc_Occupation_Edit'),
(342, 1, '_FieldDesc_Password_Edit'),
(343, 1, '_FieldDesc_Password_Join'),
(344, 1, '_FieldDesc_RelationshipStatus_Edit'),
(345, 1, '_FieldDesc_Religion_Edit'),
(346, 1, '_FieldDesc_Religious_Edit'),
(347, 1, '_FieldDesc_Status_Edit'),
(348, 1, '_FieldDesc_Tags_Join'),
(349, 1, '_FieldDesc_Weight_Edit'),
(350, 1, '_FieldDesc_zip_Edit'),
(351, 1, '_FieldDesc_zip_Join'),
(352, 1, '_FieldError_City_Mandatory'),
(353, 1, '_FieldError_City_Max'),
(354, 1, '_FieldError_City_Min'),
(355, 1, '_FieldError_Country_Mandatory'),
(356, 1, '_FieldError_DateOfBirth_Mandatory'),
(357, 1, '_FieldError_DateOfBirth_Max'),
(358, 1, '_FieldError_DateOfBirth_Min'),
(359, 1, '_FieldError_DescriptionMe_Mandatory'),
(360, 1, '_FieldError_DescriptionMe_Min'),
(361, 1, '_FieldError_Email_Check'),
(362, 1, '_FieldError_Email_Mandatory'),
(363, 1, '_FieldError_Email_Min'),
(364, 1, '_FieldError_Email_Unique'),
(365, 1, '_FieldError_Headline_Mandatory'),
(366, 1, '_FieldError_Headline_Max'),
(367, 1, '_FieldError_Headline_Min'),
(368, 1, '_FieldError_FirstName_Mandatory'),
(369, 1, '_FieldError_FirstName_Max'),
(370, 1, '_FieldError_FirstName_Min'),
(371, 1, '_FieldError_FullName_Mandatory'),
(372, 1, '_FieldError_FullName_Max'),
(373, 1, '_FieldError_FullName_Min'),
(374, 1, '_FieldError_LastName_Mandatory'),
(375, 1, '_FieldError_LastName_Max'),
(376, 1, '_FieldError_LastName_Min'),
(377, 1, '_FieldError_NickName_Check'),
(378, 1, '_FieldError_NickName_Mandatory'),
(379, 1, '_FieldError_NickName_Max'),
(380, 1, '_FieldError_NickName_Min'),
(381, 1, '_FieldError_NickName_Unique'),
(382, 1, '_FieldError_Password_Mandatory'),
(383, 1, '_FieldError_Password_Max'),
(384, 1, '_FieldError_Password_Min'),
(385, 1, '_FieldError_Sex_Mandatory'),
(386, 1, '_FieldError_zip_Mandatory'),
(387, 1, '_FieldError_zip_Max'),
(388, 1, '_FieldError_zip_Min'),
(389, 1, '_FieldValues_Active'),
(390, 1, '_FieldValues_Approval'),
(391, 1, '_FieldValues_Engaged'),
(392, 1, '_FieldValues_In a Relationship'),
(393, 1, '_FieldValues_In an Open Relationship'),
(394, 1, '_FieldValues_It''s Complicated'),
(395, 1, '_FieldValues_Married'),
(396, 1, '_FieldValues_Rejected'),
(397, 1, '_FieldValues_Single'),
(398, 1, '_FieldValues_Suspended'),
(399, 1, '_FieldValues_Unconfirmed'),
(400, 1, '_File info was sent'),
(401, 1, '_First'),
(402, 1, '_First Person'),
(403, 1, '_First page'),
(404, 1, '_First value must be bigger'),
(405, 1, '_Forgot password?'),
(406, 1, '_Friend Requests'),
(407, 1, '_Friend email'),
(408, 1, '_Friend list'),
(409, 1, '_Friend was removed'),
(410, 1, '_FriendRequest'),
(411, 1, '_Friends'),
(412, 1, '_Friends of'),
(413, 1, '_From'),
(414, 1, '_Get E-mail'),
(415, 1, '_Go admin panel'),
(416, 1, '_Greet'),
(417, 1, '_Greetings'),
(418, 1, '_Guest'),
(419, 1, '_HELP'),
(420, 1, '_HELP_H'),
(421, 1, '_HELP_H1'),
(422, 1, '_HTML Block'),
(423, 1, '_Header'),
(424, 1, '_Hello member'),
(425, 1, '_Hide'),
(426, 1, '_Hide N replies'),
(427, 1, '_Home'),
(428, 1, '_I am'),
(429, 1, '_ID'),
(430, 1, '_INVALID_PASSWD'),
(431, 1, '_INVALID_ROLE'),
(432, 1, '_In'),
(433, 1, '_Inbox'),
(434, 1, '_Incorrect Captcha'),
(435, 1, '_Incorrect Email'),
(436, 1, '_Info'),
(437, 1, '_Intersex'),
(438, 1, '_Invite a friend'),
(439, 1, '_January'),
(440, 1, '_JOIN_H'),
(441, 1, '_Join'),
(442, 1, '_Join complete'),
(443, 1, '_Join failed'),
(444, 1, '_Join_now'),
(445, 1, '_July'),
(446, 1, '_June'),
(447, 1, '_Keyword'),
(448, 1, '_Keyword_Search'),
(449, 1, '_LOGIN_OBSOLETE'),
(450, 1, '_LOGIN_REQUIRED_AE1'),
(451, 1, '_LOGIN_REQUIRED_AE2'),
(452, 1, '_Language'),
(453, 1, '_Last'),
(454, 1, '_Last login'),
(455, 1, '_Last page'),
(456, 1, '_Latest'),
(457, 1, '_Latest activity'),
(458, 1, '_Location'),
(459, 1, '_Log In'),
(460, 1, '_Log Out'),
(461, 1, '_Login'),
(462, 1, '_LookinFemale'),
(463, 1, '_LookinIntersex'),
(464, 1, '_LookinMale'),
(465, 1, '_MEMBERSHIP_EXPIRES'),
(466, 1, '_MEMBERSHIP_EXPIRES_NEVER'),
(467, 1, '_MEMBERSHIP_UPGRADE_FROM_STANDARD'),
(468, 1, '_MEMBERS_INVITE_YOU_FRIENDLIST'),
(469, 1, '_MEMBERS_YOU_BLOCKLISTED'),
(470, 1, '_MEMBERS_YOU_BLOCKLISTED_BY'),
(471, 1, '_MEMBERS_YOU_HOTLISTED'),
(472, 1, '_MEMBERS_YOU_HOTLISTED_BY'),
(473, 1, '_MEMBERS_YOU_INVITED_FRIENDLIST'),
(474, 1, '_MEMBERS_YOU_KISSED'),
(475, 1, '_MEMBERS_YOU_KISSED_BY'),
(476, 1, '_MEMBER_NOT_RECOGNIZED'),
(477, 1, '_MEMBER_RECOGNIZED_MAIL_NOT_SENT'),
(478, 1, '_MEMBER_RECOGNIZED_MAIL_SENT'),
(479, 1, '_MESSAGE_SENT'),
(480, 1, '_Mail'),
(481, 1, '_Mail box'),
(482, 1, '_Mailbox'),
(483, 1, '_Mailbox description empty'),
(484, 1, '_Mailbox recipient empty'),
(485, 1, '_Mailbox title empty'),
(486, 1, '_Main'),
(487, 1, '_Male'),
(488, 1, '_Map'),
(489, 1, '_March'),
(490, 1, '_Mark as New'),
(491, 1, '_Mark as old'),
(492, 1, '_Match'),
(493, 1, '_May'),
(494, 1, '_Member'),
(495, 1, '_Member Friends'),
(496, 1, '_Member Friends Mutual'),
(497, 1, '_Member Friends Requests'),
(498, 1, '_Member Profile'),
(499, 1, '_Member menu position'),
(500, 1, '_Member_Login'),
(501, 1, '_Members'),
(502, 1, '_Members_adm_stats'),
(503, 1, '_Membership2'),
(504, 1, '_Membership_current'),
(505, 1, '_Membership_days'),
(506, 1, '_Membership_days_info'),
(507, 1, '_Membership_name'),
(508, 1, '_Membership_name_err_empty'),
(509, 1, '_Membership_save'),
(510, 1, '_Membership_save_err_saved'),
(511, 1, '_Membership_save_msg_saved'),
(512, 1, '_Membership_starts'),
(513, 1, '_Message'),
(514, 1, '_Message text'),
(515, 1, '_Messages'),
(516, 1, '_More actions'),
(517, 1, '_Mutual Friends'),
(518, 1, '_My Account'),
(519, 1, '_My Email'),
(520, 1, '_My Friends'),
(521, 1, '_My contacts'),
(522, 1, '_N point'),
(523, 1, '_N points'),
(524, 1, '_N times'),
(525, 1, '_NO_NEED_TO_CONFIRM_EMAIL'),
(526, 1, '_Name'),
(527, 1, '_Name is required'),
(528, 1, '_New Post'),
(529, 1, '_News'),
(530, 1, '_Next'),
(531, 1, '_Next_item'),
(532, 1, '_Next page'),
(533, 1, '_NickName'),
(534, 1, '_No'),
(535, 1, '_No member specified'),
(536, 1, '_No such comment'),
(537, 1, '_None'),
(538, 1, '_Notify by e-mail'),
(539, 1, '_November'),
(540, 1, '_Now online'),
(541, 1, '_OUR_SERV'),
(542, 1, '_October'),
(543, 1, '_Offline'),
(544, 1, '_OK'),
(545, 1, '_Online'),
(546, 1, '_Online Friends'),
(547, 1, '_Open'),
(548, 1, '_Order by'),
(549, 1, '_Outbox'),
(550, 1, '_Overview'),
(551, 1, '_PRIVACY'),
(552, 1, '_PRIVACY_H'),
(553, 1, '_PRIVACY_H1'),
(554, 1, '_PROFILE_CANT_ACTIVATE/SUSPEND'),
(555, 1, '_PROFILE_CAN_ACTIVATE'),
(556, 1, '_PROFILE_CAN_SUSPEND'),
(557, 1, '_PROFILE_CONFIRM'),
(558, 1, '_PROFILE_ERR'),
(559, 1, '_PROFILE_NOT_AVAILABLE'),
(560, 1, '_Page'),
(561, 1, '_Page URI'),
(562, 1, '_Page title'),
(563, 1, '_Password'),
(564, 1, '_Password confirmation failed'),
(565, 1, '_Password retrieval'),
(566, 1, '_People'),
(567, 1, '_People_Calendar'),
(568, 1, '_People_Search'),
(569, 1, '_Period_hours'),
(570, 1, '_Phone'),
(571, 1, '_Picture'),
(572, 1, '_Please Wait'),
(573, 1, '_Please enter 3-2048 characters'),
(574, 1, '_Please specify image file'),
(575, 1, '_Please, select at least one message'),
(576, 1, '_Please_Select_'),
(577, 1, '_Popular'),
(578, 1, '_Post'),
(579, 1, '_Presence'),
(580, 1, '_Preview'),
(581, 1, '_Previous_item'),
(582, 1, '_Previous page'),
(583, 1, '_Privacy'),
(584, 1, '_Profile'),
(585, 1, '_Profile NA'),
(586, 1, '_Profile Not found'),
(587, 1, '_Profile Not found Ex'),
(588, 1, '_Profile activation failed'),
(589, 1, '_Profile info'),
(590, 1, '_Profile not found'),
(591, 1, '_Profile not specified'),
(592, 1, '_Profile status'),
(593, 1, '_ProfilePhotos'),
(594, 1, '_Profiles'),
(595, 1, '_Quick Links'),
(596, 1, '_Quick Search'),
(597, 1, '_RECOGNIZED'),
(598, 1, '_RESULT-1_A'),
(599, 1, '_RESULT-1_D'),
(600, 1, '_RESULT-1_H'),
(601, 1, '_RESULT0'),
(602, 1, '_RESULT0_H'),
(603, 1, '_RESULT1000'),
(604, 1, '_RESULT1_DESC'),
(605, 1, '_RESULT1_H'),
(606, 1, '_RESULT1_THANK'),
(607, 1, '_RESULT2DESC'),
(608, 1, '_RSS'),
(609, 1, '_RSS Feed'),
(610, 1, '_RSS_Feed_Title_Common'),
(611, 1, '_RSS_Feed_Title_Profile'),
(612, 1, '_Random'),
(613, 1, '_Rate'),
(614, 1, '_Read'),
(615, 1, '_Read more'),
(616, 1, '_Recipient'),
(617, 1, '_Recognized'),
(618, 1, '_Record Your Comment'),
(619, 1, '_Refresh'),
(620, 1, '_Registration'),
(621, 1, '_Remember password'),
(622, 1, '_Remove'),
(623, 1, '_Remove friend'),
(624, 1, '_Reply'),
(625, 1, '_Reply as text'),
(626, 1, '_Reply as video'),
(627, 1, '_Reply to this comment'),
(628, 1, '_Report'),
(629, 1, '_Report Spam'),
(630, 1, '_Report about spam failed to sent'),
(631, 1, '_Report about spam was sent'),
(632, 1, '_Repost'),
(633, 1, '_Reset'),
(634, 1, '_Restore'),
(635, 1, '_Results'),
(636, 1, '_Results per page'),
(637, 1, '_Retrieve my information'),
(638, 1, '_SEARCH_RESULT_H'),
(639, 1, '_SEND_MESSAGE'),
(640, 1, '_SEND_MSG_TO'),
(641, 1, '_SERV_DESC'),
(642, 1, '_SUBSCRIBE_TEXT'),
(643, 1, '_Save'),
(644, 1, '_Save Changes'),
(645, 1, '_Save profile successful'),
(646, 1, '_Saved'),
(647, 1, '_Search'),
(648, 1, '_Search...'),
(649, 1, '_Search profiles'),
(650, 1, '_Search result'),
(651, 1, '_Search_Home'),
(652, 1, '_Second Person'),
(653, 1, '_Section'),
(654, 1, '_Select'),
(655, 1, '_Select all'),
(656, 1, '_Select file'),
(657, 1, '_Select_all'),
(658, 1, '_Selectively'),
(659, 1, '_Send'),
(660, 1, '_Send Letter'),
(661, 1, '_Send Message'),
(662, 1, '_Send copy to my personal email'),
(663, 1, '_Send copy to personal email'),
(664, 1, '_Send virtual kiss'),
(665, 1, '_SendLetter'),
(666, 1, '_Sent'),
(667, 1, '_Sent you a'),
(668, 1, '_September'),
(669, 1, '_Settings'),
(670, 1, '_Share'),
(671, 1, '_Show'),
(672, 1, '_Show N replies'),
(673, 1, '_Simple'),
(674, 1, '_Single'),
(675, 1, '_Site Stats'),
(676, 1, '_Sorry, your IP been banned'),
(677, 1, '_Spam report'),
(678, 1, '_Start date'),
(679, 1, '_Static'),
(680, 1, '_Status'),
(681, 1, '_Status Message'),
(682, 1, '_SubCategory is required'),
(683, 1, '_Subject'),
(684, 1, '_Submit'),
(685, 1, '_Submit Comment'),
(686, 1, '_Subscribe'),
(687, 1, '_Subscribe_block_caption'),
(688, 1, '_Subscribers'),
(689, 1, '_Success'),
(690, 1, '_Suspend account'),
(691, 1, '_Suspended'),
(692, 1, '_TELLAFRIEND'),
(693, 1, '_TELLAFRIEND2'),
(694, 1, '_TERMS_OF_USE'),
(695, 1, '_TERMS_OF_USE_H'),
(696, 1, '_TERMS_OF_USE_H1'),
(697, 1, '_Tag'),
(698, 1, '_Tags'),
(699, 1, '_Tags_desc'),
(700, 1, '_Tell a friend'),
(701, 1, '_Template'),
(702, 1, '_Terms_of_use'),
(703, 1, '_Text'),
(704, 1, '_Text Block'),
(705, 1, '_There are no comments yet'),
(706, 1, '_Thumb Down'),
(707, 1, '_Thumb Up'),
(708, 1, '_Times allowed'),
(709, 1, '_Title'),
(710, 1, '_To'),
(711, 1, '_Top'),
(712, 1, '_Top Rated'),
(713, 1, '_Trash'),
(714, 1, '_Type'),
(715, 1, '_URL'),
(716, 1, '_USER_ACTIVATION_SUCCEEDED'),
(717, 1, '_USER_CONF_SUCCEEDED'),
(718, 1, '_Unconfirmed'),
(719, 1, '_Unblock'),
(720, 1, '_Unread'),
(721, 1, '_Unregister'),
(722, 1, '_User was added to block list'),
(723, 1, '_User was added to favourites'),
(724, 1, '_User was removed from favourites'),
(725, 1, '_User was added to friend list'),
(726, 1, '_User was invited to friend list'),
(727, 1, '_User was removed from block list'),
(728, 1, '_VIEW_MEMBERSHIP_ACTIONS'),
(729, 1, '_VKISS_BAD'),
(730, 1, '_VKISS_BAD_COUSE_A3'),
(731, 1, '_VKISS_BAD_COUSE_B'),
(732, 1, '_VKISS_BAD_COUSE_C'),
(733, 1, '_VKISS_BAD_COUSE_X'),
(734, 1, '_VKISS_BAD_COUSE_Y'),
(735, 1, '_VKISS_OK'),
(736, 1, '_Vacant'),
(737, 1, '_View'),
(738, 1, '_View All'),
(739, 1, '_View friends'),
(740, 1, '_Views'),
(741, 1, '_Visitor'),
(742, 1, '_Why join'),
(743, 1, '_With photos only'),
(744, 1, '_With status'),
(745, 1, '_World_Map'),
(746, 1, '_XX match'),
(747, 1, '_YOUR PROFILE_IS_NOT_ACTIVE'),
(748, 1, '_Yes'),
(749, 1, '_You are'),
(750, 1, '_You cannot edit this profile'),
(751, 1, '_You have blocked by this profile'),
(752, 1, '_You have to wait for PERIOD minutes before you can write another message!'),
(753, 1, '_You must agree with terms of use'),
(754, 1, '_You need to select the mood'),
(755, 1, '_Your email'),
(756, 1, '_Your name'),
(757, 1, '_add'),
(758, 1, '_add_other'),
(759, 1, '_adm_admtools_Audit'),
(760, 1, '_adm_admtools_Bad_files'),
(761, 1, '_adm_admtools_Current_level'),
(762, 1, '_adm_admtools_Desired_level'),
(763, 1, '_adm_admtools_Directories'),
(764, 1, '_adm_admtools_Elements'),
(765, 1, '_adm_admtools_Executable'),
(766, 1, '_adm_admtools_Files'),
(767, 1, '_adm_admtools_Flash'),
(768, 1, '_adm_admtools_modules_dirs'),
(769, 1, '_adm_admtools_modules_files'),
(770, 1, '_adm_admtools_Non_Executable'),
(771, 1, '_adm_admtools_Non_Writable'),
(772, 1, '_adm_admtools_Not_Exists'),
(773, 1, '_adm_admtools_Only_bad_files'),
(774, 1, '_adm_admtools_Perm_description'),
(775, 1, '_adm_admtools_Permissions'),
(776, 1, '_adm_admtools_Writable'),
(777, 1, '_adm_admtools_cache_engines'),
(778, 1, '_adm_admtools_phpinfo'),
(779, 1, '_adm_admtools_title'),
(780, 1, '_adm_ambuilder_Big_Icon'),
(781, 1, '_adm_ambuilder_Check'),
(782, 1, '_adm_ambuilder_Check_desc'),
(783, 1, '_adm_ambuilder_Icon'),
(784, 1, '_adm_ambuilder_Small_Icon'),
(785, 1, '_adm_ambuilder_title'),
(786, 1, '_adm_at_title'),
(787, 1, '_adm_bann_Bottom'),
(788, 1, '_adm_bann_HShift'),
(789, 1, '_adm_bann_Insert_as_new'),
(790, 1, '_adm_bann_Left'),
(791, 1, '_adm_bann_Position_on_the_page'),
(792, 1, '_adm_bann_Right'),
(793, 1, '_adm_bann_Top'),
(794, 1, '_adm_bann_VShift'),
(795, 1, '_adm_bann_clicks'),
(796, 1, '_adm_bann_clicks_chart'),
(797, 1, '_adm_bann_impressions'),
(798, 1, '_adm_bann_title'),
(799, 1, '_adm_bmbuilder_box_title'),
(800, 1, '_adm_bmbuilder_page_title'),
(801, 1, '_adm_box_cpt_admin_password'),
(802, 1, '_adm_box_cpt_available_updates'),
(803, 1, '_adm_box_cpt_boonex_news'),
(804, 1, '_adm_box_cpt_charts'),
(805, 1, '_adm_box_cpt_content'),
(806, 1, '_adm_box_cpt_design_templates'),
(807, 1, '_adm_box_cpt_email_templates'),
(808, 1, '_adm_box_cpt_help'),
(809, 1, '_adm_box_cpt_fapps'),
(810, 1, '_adm_box_cpt_featured_modules'),
(811, 1, '_adm_box_cpt_injections'),
(812, 1, '_adm_box_cpt_installed_modules'),
(813, 1, '_adm_box_cpt_lang_available'),
(814, 1, '_adm_box_cpt_lang_edit_language'),
(815, 1, '_adm_box_cpt_lang_files'),
(816, 1, '_adm_box_cpt_lang_key'),
(817, 1, '_adm_box_cpt_license'),
(818, 1, '_adm_box_cpt_links'),
(819, 1, '_adm_box_cpt_logo'),
(820, 1, '_adm_box_cpt_mlevel_action'),
(821, 1, '_adm_box_cpt_mlevel_actions'),
(822, 1, '_adm_box_cpt_mlevel_memberships'),
(823, 1, '_adm_box_cpt_mlevel_prices'),
(824, 1, '_adm_box_cpt_mp_controls'),
(825, 1, '_adm_box_cpt_mp_members'),
(826, 1, '_adm_box_cpt_not_installed_modules'),
(827, 1, '_adm_box_cpt_operation_results'),
(828, 1, '_adm_box_cpt_privacy'),
(829, 1, '_adm_box_cpt_pvalues_manage'),
(830, 1, '_adm_box_cpt_settings_advanced'),
(831, 1, '_adm_box_cpt_settings_main'),
(832, 1, '_adm_box_cpt_splash'),
(833, 1, '_adm_box_cpt_upload'),
(834, 1, '_adm_btn_Column'),
(835, 1, '_adm_btn_Create_page'),
(836, 1, '_adm_btn_Go'),
(837, 1, '_adm_btn_add_column'),
(838, 1, '_adm_btn_add_full_column'),
(839, 1, '_adm_btn_add_page'),
(840, 1, '_adm_btn_email_save'),
(841, 1, '_adm_btn_lang_import'),
(842, 1, '_adm_btn_lang_save'),
(843, 1, '_adm_btn_login_login'),
(844, 1, '_adm_btn_mlevels_add'),
(845, 1, '_adm_btn_mlevels_add_price'),
(846, 1, '_adm_btn_mlevels_delete'),
(847, 1, '_adm_btn_mlevels_disable'),
(848, 1, '_adm_btn_mlevels_enable'),
(849, 1, '_adm_btn_mlevels_save'),
(850, 1, '_adm_btn_modules_delete'),
(851, 1, '_adm_btn_modules_install'),
(852, 1, '_adm_btn_modules_recompile_languages'),
(853, 1, '_adm_btn_modules_uninstall'),
(854, 1, '_adm_btn_modules_update'),
(855, 1, '_adm_btn_mp_activate'),
(856, 1, '_adm_btn_mp_ban'),
(857, 1, '_adm_btn_mp_ban_duration'),
(858, 1, '_adm_btn_mp_browse'),
(859, 1, '_adm_btn_mp_calendar'),
(860, 1, '_adm_btn_mp_confirm'),
(861, 1, '_adm_btn_mp_deactivate'),
(862, 1, '_adm_btn_mp_delete'),
(863, 1, '_adm_btn_mp_delete_spammer'),
(864, 1, '_adm_btn_mp_extended'),
(865, 1, '_adm_btn_mp_geeky'),
(866, 1, '_adm_btn_mp_qlinks'),
(867, 1, '_adm_btn_mp_search'),
(868, 1, '_adm_btn_mp_simple'),
(869, 1, '_adm_btn_mp_tags'),
(870, 1, '_adm_btn_mp_unban'),
(871, 1, '_adm_btn_ms_delete'),
(872, 1, '_adm_btn_pvc_save'),
(873, 1, '_adm_btn_settings_save'),
(874, 1, '_adm_btn_settings_upload'),
(875, 1, '_adm_btn_settings_delete'),
(876, 1, '_adm_charts_date_from'),
(877, 1, '_adm_charts_date_to'),
(878, 1, '_adm_charts_select'),
(879, 1, '_adm_dbtools_Backup_content'),
(880, 1, '_adm_dbtools_Backup_database'),
(881, 1, '_adm_dbtools_Backup_structure'),
(882, 1, '_adm_dbtools_Backup_structure_content'),
(883, 1, '_adm_dbtools_Backup_table'),
(884, 1, '_adm_dbtools_Choose_operation'),
(885, 1, '_adm_dbtools_Choose_operation_and_table'),
(886, 1, '_adm_dbtools_Data_succefully_restored_from_PC'),
(887, 1, '_adm_dbtools_Data_succefully_restored_from_dump'),
(888, 1, '_adm_dbtools_Database_backup_tools'),
(889, 1, '_adm_dbtools_Database_restore'),
(890, 1, '_adm_dbtools_Database_restore_from_your_PC'),
(891, 1, '_adm_dbtools_Delete_dump_from_server'),
(892, 1, '_adm_dbtools_Dump_file_succefully_deleted'),
(893, 1, '_adm_dbtools_Please_select_correct_dump_file'),
(894, 1, '_adm_dbtools_Please_select_dump_file'),
(895, 1, '_adm_dbtools_Restore_data_from_dump'),
(896, 1, '_adm_dbtools_Save_to_server'),
(897, 1, '_adm_dbtools_Save_to_your_PC'),
(898, 1, '_adm_dbtools_Show_on_the_screen'),
(899, 1, '_adm_dbtools_Tables_backup_tools'),
(900, 1, '_adm_dbtools_succ_dumped_into_file'),
(901, 1, '_adm_dbtools_title'),
(902, 1, '_adm_dblinks_antispam'),
(903, 1, '_adm_dblinks_backup'),
(904, 1, '_adm_dblinks_builders'),
(905, 1, '_adm_dblinks_host_tools'),
(906, 1, '_adm_dblinks_manage_languages'),
(907, 1, '_adm_dblinks_manage_members'),
(908, 1, '_adm_dblinks_manage_modules'),
(909, 1, '_adm_dblinks_manage_templates'),
(910, 1, '_adm_dblinks_mass_mailer'),
(911, 1, '_adm_dblinks_settings'),
(912, 1, '_adm_dsc_settings_splash_editor'),
(913, 1, '_adm_dsc_settings_injection_head'),
(914, 1, '_adm_dsc_settings_injection_body'),
(915, 1, '_adm_fields_admin'),
(916, 1, '_adm_fields_advanced'),
(917, 1, '_adm_fields_advanced_search'),
(918, 1, '_adm_fields_box_cpt_field'),
(919, 1, '_adm_fields_box_title'),
(920, 1, '_adm_fields_caption_desc'),
(921, 1, '_adm_fields_check_error_message'),
(922, 1, '_adm_fields_check_error_message_desc'),
(923, 1, '_adm_fields_default_value'),
(924, 1, '_adm_fields_default_value_desc'),
(925, 1, '_adm_fields_delete_item_desc'),
(926, 1, '_adm_fields_description_desc'),
(927, 1, '_adm_fields_edit_profile'),
(928, 1, '_adm_fields_error_field_cannot_be_deleted'),
(929, 1, '_adm_fields_error_field_not_found'),
(930, 1, '_adm_fields_error_i_dont_know_this_control_type'),
(931, 1, '_adm_fields_error_i_dont_know_this_type'),
(932, 1, '_adm_fields_error_name_already_exists'),
(933, 1, '_adm_fields_error_name_latin'),
(934, 1, '_adm_fields_error_you_entered_incorrect_link'),
(935, 1, '_adm_fields_error_you_entered_incorrect_value'),
(936, 1, '_adm_fields_error_you_must_enter_caption'),
(937, 1, '_adm_fields_error_you_must_enter_name'),
(938, 1, '_adm_fields_error_you_must_enter_values'),
(939, 1, '_adm_fields_general'),
(940, 1, '_adm_fields_join_form'),
(941, 1, '_adm_fields_join_page'),
(942, 1, '_adm_fields_loading'),
(943, 1, '_adm_fields_mandatory'),
(944, 1, '_adm_fields_mandatory_desc'),
(945, 1, '_adm_fields_mandatory_error_message'),
(946, 1, '_adm_fields_mandatory_error_message_desc'),
(947, 1, '_adm_fields_match_percent'),
(948, 1, '_adm_fields_match_percent_desc'),
(949, 1, '_adm_fields_match_with_field'),
(950, 1, '_adm_fields_match_with_field_desc'),
(951, 1, '_adm_fields_matching'),
(952, 1, '_adm_fields_maximum_exceed_error_message'),
(953, 1, '_adm_fields_maximum_exceed_error_message_desc'),
(954, 1, '_adm_fields_maximum_value'),
(955, 1, '_adm_fields_maximum_value_desc'),
(956, 1, '_adm_fields_member'),
(957, 1, '_adm_fields_messages'),
(958, 1, '_adm_fields_minimum_exceed_error_message'),
(959, 1, '_adm_fields_minimum_exceed_error_message_desc'),
(960, 1, '_adm_fields_minimum_value'),
(961, 1, '_adm_fields_minimum_value_desc'),
(962, 1, '_adm_fields_multiple_selector_control'),
(963, 1, '_adm_fields_multiple_selector_control_desc'),
(964, 1, '_adm_fields_mutual_couple_fields'),
(965, 1, '_adm_fields_mutual_couple_fields_desc'),
(966, 1, '_adm_fields_name_desc'),
(967, 1, '_adm_fields_non_unique_error_message'),
(968, 1, '_adm_fields_non_unique_error_message_desc'),
(969, 1, '_adm_fields_owner'),
(970, 1, '_adm_fields_possible_values'),
(971, 1, '_adm_fields_possible_values_desc'),
(972, 1, '_adm_fields_quick_search'),
(973, 1, '_adm_fields_search_in_fields'),
(974, 1, '_adm_fields_search_in_fields_desc'),
(975, 1, '_adm_fields_search_profiles'),
(976, 1, '_adm_fields_selector_control'),
(977, 1, '_adm_fields_selector_control_desc'),
(978, 1, '_adm_fields_simple_search'),
(979, 1, '_adm_fields_title'),
(980, 1, '_adm_fields_unique'),
(981, 1, '_adm_fields_unique_desc'),
(982, 1, '_adm_fields_used_lang_key'),
(983, 1, '_adm_fields_used_lang_key_desc'),
(984, 1, '_adm_fields_view_profile'),
(985, 1, '_adm_fields_visitor'),
(986, 1, '_adm_fields_warning_field_not_found'),
(987, 1, '_adm_fields_warning_item_not_found'),
(988, 1, '_adm_ipbl_Date_of_finish'),
(989, 1, '_adm_ipbl_IP_Role'),
(990, 1, '_adm_ipbl_Stored_members_caption'),
(991, 1, '_adm_ipbl_manage'),
(992, 1, '_adm_ipbl_sample'),
(993, 1, '_adm_ipbl_title'),
(994, 1, '_adm_ipbl_Type0_desc'),
(995, 1, '_adm_ipbl_Type1_desc'),
(996, 1, '_adm_ipbl_Type2_desc'),
(997, 1, '_adm_license_trial_copy_login_text'),
(998, 1, '_adm_license_note_permanent'),
(999, 1, '_adm_license_note_unregistered'),
(1000, 1, '_adm_license_continue'),
(1001, 1, '_adm_license_popup_continue'),
(1002, 1, '_adm_license_popup_license'),
(1003, 1, '_adm_license_popup_note'),
(1004, 1, '_adm_license_popup_or'),
(1005, 1, '_adm_license_popup_register'),
(1006, 1, '_adm_license_register'),
(1007, 1, '_adm_license_register_new'),
(1008, 1, '_adm_license_unregistered'),
(1009, 1, '_adm_license_warning'),
(1010, 1, '_adm_mbuilder_All_Items'),
(1011, 1, '_adm_mbuilder_Could_not_delete_the_item'),
(1012, 1, '_adm_mbuilder_Default_Name'),
(1013, 1, '_adm_mbuilder_Item_ID_not_specified'),
(1014, 1, '_adm_mbuilder_Item_is_non_deletable'),
(1015, 1, '_adm_mbuilder_Item_is_non_editable'),
(1016, 1, '_adm_mbuilder_Item_not_found'),
(1017, 1, '_adm_mbuilder_Language_Key'),
(1018, 1, '_adm_mbuilder_New'),
(1019, 1, '_adm_mbuilder_Quick_Link'),
(1020, 1, '_adm_mbuilder_Same'),
(1021, 1, '_adm_mbuilder_Sorry_could_not_insert_object'),
(1022, 1, '_adm_mbuilder_System_Name'),
(1023, 1, '_adm_mbuilder_Target_Window'),
(1024, 1, '_adm_mbuilder_This_items_are_non_editable'),
(1025, 1, '_adm_mbuilder_Visible_for'),
(1026, 1, '_adm_mbuilder_active_items'),
(1027, 1, '_adm_mbuilder_all_items'),
(1028, 1, '_adm_mbuilder_edit_item'),
(1029, 1, '_adm_mbuilder_icon'),
(1030, 1, '_adm_mbuilder_inactive_items'),
(1031, 1, '_adm_mbuilder_legend'),
(1032, 1, '_adm_mbuilder_legend_custom'),
(1033, 1, '_adm_mbuilder_legend_inact'),
(1034, 1, '_adm_mbuilder_legend_system'),
(1035, 1, '_adm_mbuilder_legend_top'),
(1036, 1, '_adm_mbuilder_script'),
(1037, 1, '_adm_mbuilder_title'),
(1038, 1, '_adm_mbuilder_title_box'),
(1039, 1, '_adm_mmail_Age'),
(1040, 1, '_adm_mmail_All_Messages'),
(1041, 1, '_adm_mmail_Body'),
(1042, 1, '_adm_mmail_Cupid_mails_status'),
(1043, 1, '_adm_mmail_Email_message'),
(1044, 1, '_adm_mmail_Email_not_added_to_queue_X'),
(1045, 1, '_adm_mmail_Empty_Queue'),
(1046, 1, '_adm_mmail_Failed_to_queue_emails_X'),
(1047, 1, '_adm_mmail_Message_was_deleted'),
(1048, 1, '_adm_mmail_Message_was_not_deleted'),
(1049, 1, '_adm_mmail_Queue_empty'),
(1050, 1, '_adm_mmail_Queue_emptying_failed'),
(1051, 1, '_adm_mmail_Queue_message'),
(1052, 1, '_adm_mmail_Queue_status'),
(1053, 1, '_adm_mmail_Send_to_members'),
(1054, 1, '_adm_mmail_Send_to_members_info'),
(1055, 1, '_adm_mmail_Send_to_subscribers'),
(1056, 1, '_adm_mmail_Sex'),
(1057, 1, '_adm_mmail_Text_email_body'),
(1058, 1, '_adm_mmail_X_emails_was_succ_added_to_queue'),
(1059, 1, '_adm_mmail_emails'),
(1060, 1, '_adm_mmail_mails_in_queue'),
(1061, 1, '_adm_mmail_no_emails_in_queue'),
(1062, 1, '_adm_mmail_title'),
(1063, 1, '_adm_mmi_admin_menu'),
(1064, 1, '_adm_mmi_admin_password'),
(1065, 1, '_adm_mmi_advanced_settings'),
(1066, 1, '_adm_mmi_antispam'),
(1067, 1, '_adm_mmi_banners'),
(1068, 1, '_adm_mmi_basic_settings'),
(1069, 1, '_adm_mmi_bottom_menu'),
(1070, 1, '_adm_mmi_builders'),
(1071, 1, '_adm_mmi_cache'),
(1072, 1, '_adm_mmi_categories_settings'),
(1073, 1, '_adm_mmi_dashboard'),
(1074, 1, '_adm_mmi_database_backup'),
(1075, 1, '_adm_mmi_email_templates'),
(1076, 1, '_adm_mmi_flash_apps'),
(1077, 1, '_adm_mmi_host_tools'),
(1078, 1, '_adm_mmi_ip_blacklist'),
(1079, 1, '_adm_mmi_languages_settings'),
(1080, 1, '_adm_mmi_license'),
(1081, 1, '_adm_mmi_manage_modules'),
(1082, 1, '_adm_mmi_mass_mailer'),
(1083, 1, '_adm_mmi_member_menu'),
(1084, 1, '_adm_mmi_membership_levels'),
(1085, 1, '_adm_mmi_mobile_pages'),
(1086, 1, '_adm_mmi_modules'),
(1087, 1, '_adm_mmi_navigation_menu'),
(1088, 1, '_adm_mmi_pages_blocks'),
(1089, 1, '_adm_mmi_predefined_values'),
(1090, 1, '_adm_mmi_privacy'),
(1091, 1, '_adm_mmi_profile_fields'),
(1092, 1, '_adm_mmi_service_menu'),
(1093, 1, '_adm_mmi_settings'),
(1094, 1, '_adm_mmi_sitemap'),
(1095, 1, '_adm_mmi_templates'),
(1096, 1, '_adm_mmi_tools'),
(1097, 1, '_adm_mmi_users'),
(1098, 1, '_adm_mmi_watermark'),
(1099, 1, '_adm_mobile_builder_cont_active'),
(1100, 1, '_adm_mobile_builder_cont_inactive'),
(1101, 1, '_adm_mobile_builder_title'),
(1102, 1, '_adm_mobile_page_homepage'),
(1103, 1, '_adm_mobile_page_profile'),
(1104, 1, '_adm_mobile_page_search'),
(1105, 1, '_adm_page_cpt_dashboard'),
(1106, 1, '_adm_page_cpt_email_templates'),
(1107, 1, '_adm_page_cpt_fapps'),
(1108, 1, '_adm_page_cpt_lang_file'),
(1109, 1, '_adm_page_cpt_license'),
(1110, 1, '_adm_page_cpt_login'),
(1111, 1, '_adm_page_cpt_manage_members'),
(1112, 1, '_adm_page_cpt_manage_modules'),
(1113, 1, '_adm_page_cpt_manage_subscribers'),
(1114, 1, '_adm_page_cpt_memb_levels'),
(1115, 1, '_adm_page_cpt_privacy'),
(1116, 1, '_adm_page_cpt_pvalues_manage'),
(1117, 1, '_adm_page_cpt_settings'),
(1118, 1, '_adm_page_cpt_settings_advanced'),
(1119, 1, '_adm_page_cpt_settings_basic'),
(1120, 1, '_adm_pbuilder_Add_column'),
(1121, 1, '_adm_pbuilder_Block'),
(1122, 1, '_adm_pbuilder_Caption_Lang_Key'),
(1123, 1, '_adm_pbuilder_Column_delete_confirmation'),
(1124, 1, '_adm_pbuilder_Column_non_enough_width_warn'),
(1125, 1, '_adm_pbuilder_Create_new_page'),
(1126, 1, '_adm_pbuilder_DesignBox_Lang_Key'),
(1127, 1, '_adm_pbuilder_DesignBox_2'),
(1128, 1, '_adm_pbuilder_DesignBox_0'),
(1129, 1, '_adm_pbuilder_DesignBox_11'),
(1130, 1, '_adm_pbuilder_DesignBox_1'),
(1131, 1, '_adm_pbuilder_DesignBox_13'),
(1132, 1, '_adm_pbuilder_DesignBox_3'),
(1133, 1, '_adm_pbuilder_HTML_Block'),
(1134, 1, '_adm_pbuilder_Number_RSS_items'),
(1135, 1, '_adm_pbuilder_Profile_Fields'),
(1136, 1, '_adm_pbuilder_Code_Block'),
(1137, 1, '_adm_pbuilder_RSS_Feed'),
(1138, 1, '_adm_pbuilder_Reset_page_warning'),
(1139, 1, '_adm_pbuilder_Special_Block'),
(1140, 1, '_adm_pbuilder_Text_Block'),
(1141, 1, '_adm_pbuilder_This_block_has_no_properties'),
(1142, 1, '_adm_pbuilder_Url_of_RSS_feed'),
(1143, 1, '_adm_pbuilder_Want_to_delete'),
(1144, 1, '_adm_pbuilder_XML_Block'),
(1145, 1, '_adm_pbuilder_XML_path'),
(1146, 1, '_adm_pbuilder_box_title'),
(1147, 1, '_adm_pbuilder_title'),
(1148, 1, '_adm_pbuilder_title_info'),
(1149, 1, '_adm_pbuilder_uri_info'),
(1150, 1, '_adm_pvalues_help_value'),
(1151, 1, '_adm_pvalues_help_lkey'),
(1152, 1, '_adm_pvalues_help_lkey2'),
(1153, 1, '_adm_pvalues_help_lkey3'),
(1154, 1, '_adm_pvalues_help_extra'),
(1155, 1, '_adm_pvalues_help_extra2'),
(1156, 1, '_adm_pvalues_help_extra3'),
(1157, 1, '_adm_pvalues_msg_enter_list_name'),
(1158, 1, '_adm_pvalues_msg_enter_correct_name'),
(1159, 1, '_adm_pvalues_txt_select_list'),
(1160, 1, '_adm_pvalues_txt_move_up'),
(1161, 1, '_adm_pvalues_txt_move_down'),
(1162, 1, '_adm_pvalues_txt_create_new'),
(1163, 1, '_adm_pvalues_txt_add_record'),
(1164, 1, '_adm_smbuilder_box_title'),
(1165, 1, '_adm_smbuilder_page_title'),
(1166, 1, '_adm_tmi_extensions'),
(1167, 1, '_adm_tmi_home'),
(1168, 1, '_adm_tmi_info'),
(1169, 1, '_adm_tmi_language'),
(1170, 1, '_adm_tmi_logout'),
(1171, 1, '_adm_txt_cache'),
(1172, 1, '_adm_txt_clear_cache'),
(1173, 1, '_adm_txt_dashboard_cache'),
(1174, 1, '_adm_txt_dashboard_cache_all'),
(1175, 1, '_adm_txt_dashboard_cache_clean_failed'),
(1176, 1, '_adm_txt_dashboard_cache_clean_success'),
(1177, 1, '_adm_txt_dashboard_cache_css'),
(1178, 1, '_adm_txt_dashboard_cache_db'),
(1179, 1, '_adm_txt_dashboard_cache_js'),
(1180, 1, '_adm_txt_dashboard_cache_member_menu'),
(1181, 1, '_adm_txt_dashboard_cache_pb'),
(1182, 1, '_adm_txt_dashboard_cache_template'),
(1183, 1, '_adm_txt_dashboard_cache_users'),
(1184, 1, '_adm_txt_dashboard_help'),
(1185, 1, '_adm_txt_dashboard_help_dont_show'),
(1186, 1, '_adm_txt_dashboard_update_now'),
(1187, 1, '_adm_txt_dashboard_update_to'),
(1188, 1, '_adm_txt_default'),
(1189, 1, '_adm_txt_email_body'),
(1190, 1, '_adm_txt_email_language'),
(1191, 1, '_adm_txt_email_list'),
(1192, 1, '_adm_txt_email_nothing_changed'),
(1193, 1, '_adm_txt_email_settings'),
(1194, 1, '_adm_txt_email_subject'),
(1195, 1, '_adm_txt_email_success_save'),
(1196, 1, '_adm_txt_get_new_modules'),
(1197, 1, '_adm_txt_hosting_text'),
(1198, 1, '_adm_txt_hosting_title'),
(1199, 1, '_adm_txt_keys_category'),
(1200, 1, '_adm_txt_keys_name'),
(1201, 1, '_adm_txt_keys_string_for'),
(1202, 1, '_adm_txt_langs_add_key'),
(1203, 1, '_adm_txt_langs_already_exists'),
(1204, 1, '_adm_txt_langs_cannot_add_string'),
(1205, 1, '_adm_txt_langs_cannot_compile'),
(1206, 1, '_adm_txt_langs_cannot_create'),
(1207, 1, '_adm_txt_langs_cannot_delete'),
(1208, 1, '_adm_txt_langs_cannot_delete_default'),
(1209, 1, '_adm_txt_langs_cannot_upload_file'),
(1210, 1, '_adm_txt_langs_code'),
(1211, 1, '_adm_txt_langs_compile'),
(1212, 1, '_adm_txt_langs_copy_from'),
(1213, 1, '_adm_txt_langs_country_code'),
(1214, 1, '_adm_txt_langs_def_lang'),
(1215, 1, '_adm_txt_langs_default'),
(1216, 1, '_adm_txt_langs_delete'),
(1217, 1, '_adm_txt_langs_direction'),
(1218, 1, '_adm_txt_langs_edit'),
(1219, 1, '_adm_txt_langs_empty_name'),
(1220, 1, '_adm_txt_langs_empty_title'),
(1221, 1, '_adm_txt_langs_export'),
(1222, 1, '_adm_txt_langs_file'),
(1223, 1, '_adm_txt_langs_flag'),
(1224, 1, '_adm_txt_langs_keys'),
(1225, 1, '_adm_txt_langs_languages'),
(1226, 1, '_adm_txt_langs_languages_add'),
(1227, 1, '_adm_txt_langs_languages_import'),
(1228, 1, '_adm_txt_langs_settings'),
(1229, 1, '_adm_txt_langs_success_compile'),
(1230, 1, '_adm_txt_langs_success_create'),
(1231, 1, '_adm_txt_langs_success_delete'),
(1232, 1, '_adm_txt_langs_success_import'),
(1233, 1, '_adm_txt_langs_success_key_save'),
(1234, 1, '_adm_txt_langs_success_updated'),
(1235, 1, '_adm_txt_langs_title'),
(1236, 1, '_adm_txt_list'),
(1237, 1, '_adm_txt_login_password'),
(1238, 1, '_adm_txt_login_username'),
(1239, 1, '_adm_txt_make_default'),
(1240, 1, '_adm_txt_manage'),
(1241, 1, '_adm_txt_mlevels_action_cannot_save'),
(1242, 1, '_adm_txt_mlevels_action_saved'),
(1243, 1, '_adm_txt_mlevels_actions'),
(1244, 1, '_adm_txt_mlevels_actions_avail_desc'),
(1245, 1, '_adm_txt_mlevels_actions_avail_end'),
(1246, 1, '_adm_txt_mlevels_actions_avail_start'),
(1247, 1, '_adm_txt_mlevels_actions_number'),
(1248, 1, '_adm_txt_mlevels_actions_number_desc'),
(1249, 1, '_adm_txt_mlevels_actions_reset'),
(1250, 1, '_adm_txt_mlevels_actions_reset_desc'),
(1251, 1, '_adm_txt_mlevels_cannot_remove'),
(1252, 1, '_adm_txt_mlevels_custom'),
(1253, 1, '_adm_txt_mlevels_description'),
(1254, 1, '_adm_txt_mlevels_edit'),
(1255, 1, '_adm_txt_mlevels_icon'),
(1256, 1, '_adm_txt_mlevels_icon_err'),
(1257, 1, '_adm_txt_mlevels_icon_info_edit'),
(1258, 1, '_adm_txt_mlevels_is_used'),
(1259, 1, '_adm_txt_mlevels_levels'),
(1260, 1, '_adm_txt_mlevels_levels_add'),
(1261, 1, '_adm_txt_mlevels_name'),
(1262, 1, '_adm_txt_mlevels_name_err'),
(1263, 1, '_adm_txt_mlevels_name_err_non_uniq'),
(1264, 1, '_adm_txt_mlevels_not_found'),
(1265, 1, '_adm_txt_mlevels_order'),
(1266, 1, '_adm_txt_mlevels_order_err'),
(1267, 1, '_adm_txt_mlevels_price'),
(1268, 1, '_adm_txt_mlevels_price_add_days'),
(1269, 1, '_adm_txt_mlevels_price_add_price'),
(1270, 1, '_adm_txt_mlevels_price_exists'),
(1271, 1, '_adm_txt_mlevels_price_info'),
(1272, 1, '_adm_txt_mlevels_price_info_lifetime'),
(1273, 1, '_adm_txt_mlevels_settings'),
(1274, 1, '_adm_txt_mlevels_system'),
(1275, 1, '_adm_txt_modules_already_installed'),
(1276, 1, '_adm_txt_modules_already_uninstalled'),
(1277, 1, '_adm_txt_modules_cannot_connect_to_ftp'),
(1278, 1, '_adm_txt_modules_cannot_recompile_lang'),
(1279, 1, '_adm_txt_modules_cannot_remove_package'),
(1280, 1, '_adm_txt_modules_cannot_unzip_package'),
(1281, 1, '_adm_txt_modules_cannot_upload_package'),
(1282, 1, '_adm_txt_modules_cannot_download_package'),
(1283, 1, '_adm_txt_modules_cannot_write_package'),
(1284, 1, '_adm_txt_modules_check_permissions'),
(1285, 1, '_adm_txt_modules_change_permissions'),
(1286, 1, '_adm_txt_modules_check_dependencies'),
(1287, 1, '_adm_txt_modules_check_module_exists'),
(1288, 1, '_adm_txt_modules_check_module_hash'),
(1289, 1, '_adm_txt_modules_check_module_version'),
(1290, 1, '_adm_txt_modules_check_script_version'),
(1291, 1, '_adm_txt_modules_clear_db_cache'),
(1292, 1, '_adm_txt_modules_data_will_be_lost'),
(1293, 1, '_adm_txt_modules_destination_not_valid'),
(1294, 1, '_adm_txt_modules_executable'),
(1295, 1, '_adm_txt_modules_execute_sql'),
(1296, 1, '_adm_txt_modules_ftp_access'),
(1297, 1, '_adm_txt_modules_ftp_copy_failed'),
(1298, 1, '_adm_txt_modules_has_dependents'),
(1299, 1, '_adm_txt_modules_host'),
(1300, 1, '_adm_txt_modules_login'),
(1301, 1, '_adm_txt_modules_module'),
(1302, 1, '_adm_txt_modules_module_config_not_found'),
(1303, 1, '_adm_txt_modules_module_not_found'),
(1304, 1, '_adm_txt_modules_module_was_modified'),
(1305, 1, '_adm_txt_modules_no_ftp_info'),
(1306, 1, '_adm_txt_modules_operation_install'),
(1307, 1, '_adm_txt_modules_operation_recompile'),
(1308, 1, '_adm_txt_modules_operation_uninstall'),
(1309, 1, '_adm_txt_modules_operation_update'),
(1310, 1, '_adm_txt_modules_package_to_upload'),
(1311, 1, '_adm_txt_modules_params_used'),
(1312, 1, '_adm_txt_modules_path_to_dolphin'),
(1313, 1, '_adm_txt_modules_process_action_failed'),
(1314, 1, '_adm_txt_modules_process_action_success'),
(1315, 1, '_adm_txt_modules_process_failed'),
(1316, 1, '_adm_txt_modules_process_operation_failed'),
(1317, 1, '_adm_txt_modules_process_success'),
(1318, 1, '_adm_txt_modules_recompile_alerts'),
(1319, 1, '_adm_txt_modules_recompile_categories'),
(1320, 1, '_adm_txt_modules_recompile_comments'),
(1321, 1, '_adm_txt_modules_recompile_global_paramaters'),
(1322, 1, '_adm_txt_modules_recompile_injections'),
(1323, 1, '_adm_txt_modules_recompile_main_menu'),
(1324, 1, '_adm_txt_modules_recompile_member_actions'),
(1325, 1, '_adm_txt_modules_recompile_member_menu'),
(1326, 1, '_adm_txt_modules_recompile_page_builder'),
(1327, 1, '_adm_txt_modules_recompile_permalinks'),
(1328, 1, '_adm_txt_modules_recompile_profile_fields'),
(1329, 1, '_adm_txt_modules_recompile_search'),
(1330, 1, '_adm_txt_modules_recompile_site_stats'),
(1331, 1, '_adm_txt_modules_recompile_tags'),
(1332, 1, '_adm_txt_modules_recompile_votes'),
(1333, 1, '_adm_txt_modules_show_conclusion'),
(1334, 1, '_adm_txt_modules_show_introduction'),
(1335, 1, '_adm_txt_modules_success_delete'),
(1336, 1, '_adm_txt_modules_success_upload'),
(1337, 1, '_adm_txt_modules_title_module'),
(1338, 1, '_adm_txt_modules_title_update'),
(1339, 1, '_adm_txt_modules_update_download_success'),
(1340, 1, '_adm_txt_modules_update_files'),
(1341, 1, '_adm_txt_modules_update_languages'),
(1342, 1, '_adm_txt_modules_update_latest'),
(1343, 1, '_adm_txt_modules_update_text'),
(1344, 1, '_adm_txt_modules_update_text_ext'),
(1345, 1, '_adm_txt_modules_writable'),
(1346, 1, '_adm_txt_modules_wrong_dependency_uninstall'),
(1347, 1, '_adm_txt_modules_wrong_dependency_install'),
(1348, 1, '_adm_txt_modules_wrong_dependency_install_payment'),
(1349, 1, '_adm_txt_modules_wrong_mysql_query'),
(1350, 1, '_adm_txt_modules_wrong_mysql_query_msg'),
(1351, 1, '_adm_txt_modules_wrong_package_format'),
(1352, 1, '_adm_txt_modules_wrong_permissions_check'),
(1353, 1, '_adm_txt_modules_wrong_permissions_change'),
(1354, 1, '_adm_txt_modules_wrong_permissions_change_cannot_connect_to_ftp'),
(1355, 1, '_adm_txt_modules_wrong_permissions_change_destination_not_valid'),
(1356, 1, '_adm_txt_modules_wrong_permissions_change_list'),
(1357, 1, '_adm_txt_modules_wrong_permissions_msg'),
(1358, 1, '_adm_txt_modules_wrong_version'),
(1359, 1, '_adm_txt_modules_wrong_version_script'),
(1360, 1, '_adm_txt_modules_zip_not_available'),
(1361, 1, '_adm_txt_mp_active'),
(1362, 1, '_adm_txt_mp_admins'),
(1363, 1, '_adm_txt_mp_all'),
(1364, 1, '_adm_txt_mp_approval'),
(1365, 1, '_adm_txt_mp_banned'),
(1366, 1, '_adm_txt_mp_couple'),
(1367, 1, '_adm_txt_mp_featured'),
(1368, 1, '_adm_txt_mp_female'),
(1369, 1, '_adm_txt_mp_intersex'),
(1370, 1, '_adm_txt_mp_male'),
(1371, 1, '_adm_txt_mp_other'),
(1372, 1, '_adm_txt_mp_promotion'),
(1373, 1, '_adm_txt_mp_rejected'),
(1374, 1, '_adm_txt_mp_single'),
(1375, 1, '_adm_txt_mp_suspended'),
(1376, 1, '_adm_txt_mp_unconfirmed'),
(1377, 1, '_adm_txt_mp_activation_sent'),
(1378, 1, '_adm_txt_mp_email'),
(1379, 1, '_adm_txt_mp_filter'),
(1380, 1, '_adm_txt_mp_last_activity'),
(1381, 1, '_adm_txt_mp_mlevel'),
(1382, 1, '_adm_txt_mp_order_by'),
(1383, 1, '_adm_txt_mp_order_last_activity'),
(1384, 1, '_adm_txt_mp_order_last_join'),
(1385, 1, '_adm_txt_mp_order_none'),
(1386, 1, '_adm_txt_mp_order_user_name'),
(1387, 1, '_adm_txt_mp_registration'),
(1388, 1, '_adm_txt_mp_username'),
(1389, 1, '_adm_txt_pb_active_blocks'),
(1390, 1, '_adm_txt_pb_inactive_blocks'),
(1391, 1, '_adm_txt_pb_loading'),
(1392, 1, '_adm_txt_pb_other_pages_width'),
(1393, 1, '_adm_txt_pb_page'),
(1394, 1, '_adm_txt_pb_page_width'),
(1395, 1, '_adm_txt_pb_samples'),
(1396, 1, '_adm_txt_pb_select_page'),
(1397, 1, '_adm_txt_pb_view_page'),
(1398, 1, '_adm_txt_pvc_defaults'),
(1399, 1, '_adm_txt_pvc_nothing_changed'),
(1400, 1, '_adm_txt_pvc_settings'),
(1401, 1, '_adm_txt_pvc_success_save'),
(1402, 1, '_adm_txt_settings_conf_password'),
(1403, 1, '_adm_txt_settings_error'),
(1404, 1, '_adm_txt_settings_file_cannot_move'),
(1405, 1, '_adm_txt_settings_file_not_image'),
(1406, 1, '_adm_txt_settings_file_wrong_format'),
(1407, 1, '_adm_txt_settings_image_cannot_resize'),
(1408, 1, '_adm_txt_settings_injection_head'),
(1409, 1, '_adm_txt_settings_injection_body'),
(1410, 1, '_adm_txt_settings_logo_header'),
(1411, 1, '_adm_txt_settings_logo_upload'),
(1412, 1, '_adm_txt_settings_logo_wrong_size'),
(1413, 1, '_adm_txt_settings_new_password'),
(1414, 1, '_adm_txt_settings_old_password'),
(1415, 1, '_adm_txt_settings_resize_enable'),
(1416, 1, '_adm_txt_settings_resize_header'),
(1417, 1, '_adm_txt_settings_resize_height'),
(1418, 1, '_adm_txt_settings_resize_width'),
(1419, 1, '_adm_txt_settings_splash_editor'),
(1420, 1, '_adm_txt_settings_splash_logged'),
(1421, 1, '_adm_txt_settings_splash_visibility'),
(1422, 1, '_adm_txt_settings_splash_visibility_all'),
(1423, 1, '_adm_txt_settings_splash_visibility_disable'),
(1424, 1, '_adm_txt_settings_splash_visibility_index'),
(1425, 1, '_adm_txt_settings_splash_warning'),
(1426, 1, '_adm_txt_settings_success'),
(1427, 1, '_adm_txt_settings_wrong_conf_pasword'),
(1428, 1, '_adm_txt_settings_wrong_new_pasword'),
(1429, 1, '_adm_txt_settings_wrong_old_pasword'),
(1430, 1, '_adm_txt_templ_alt_desc'),
(1431, 1, '_adm_txt_templ_evo_desc'),
(1432, 1, '_adm_txt_templ_uni_desc'),
(1433, 1, '_adm_txt_template_preview_na'),
(1434, 1, '_adm_txt_templates'),
(1435, 1, '_all'),
(1436, 1, '_all_tags'),
(1437, 1, '_allow_view_to'),
(1438, 1, '_already_in_friend_list'),
(1439, 1, '_associated_image'),
(1440, 1, '_bad comment parent id'),
(1441, 1, '_categ_admin_pending'),
(1442, 1, '_categ_admin_settings'),
(1443, 1, '_categ_all'),
(1444, 1, '_categ_btn_activate'),
(1445, 1, '_categ_btn_delete'),
(1446, 1, '_categ_btn_disable'),
(1447, 1, '_categ_by_day'),
(1448, 1, '_categ_caption_all'),
(1449, 1, '_categ_caption_calendar'),
(1450, 1, '_categ_caption_common'),
(1451, 1, '_categ_caption_day'),
(1452, 1, '_categ_caption_founded'),
(1453, 1, '_categ_caption_keyword'),
(1454, 1, '_categ_caption_search_form'),
(1455, 1, '_categ_caption_users'),
(1456, 1, '_categ_err_keyword'),
(1457, 1, '_categ_exist_err'),
(1458, 1, '_categ_form_add'),
(1459, 1, '_categ_form_field_name_err'),
(1460, 1, '_categ_form_name'),
(1461, 1, '_categ_form_type'),
(1462, 1, '_categ_modules'),
(1463, 1, '_categ_order_none'),
(1464, 1, '_categ_order_order_by'),
(1465, 1, '_categ_order_popular'),
(1466, 1, '_categ_order_recent'),
(1467, 1, '_categ_plural'),
(1468, 1, '_categ_single'),
(1469, 1, '_categ_users'),
(1470, 1, '_chars_to_chars'),
(1471, 1, '_comments'),
(1472, 1, '_contact_us'),
(1473, 1, '_copyright'),
(1474, 1, '_created'),
(1475, 1, '_days'),
(1476, 1, '_delete'),
(1477, 1, '_download'),
(1478, 1, '_edit_available_for_N_seconds'),
(1479, 1, '_edit_profile_info'),
(1480, 1, '_edit_profile_membership'),
(1481, 1, '_edit_profile_privacy'),
(1482, 1, '_edit_profile_privacy_save'),
(1483, 1, '_expand all'),
(1484, 1, '_failed_to_delete_post'),
(1485, 1, '_featured members'),
(1486, 1, '_female'),
(1487, 1, '_forgot_your_password'),
(1488, 1, '_from'),
(1489, 1, '_from zip/postal code');
INSERT INTO `sys_localization_keys` VALUES
(1490, 1, '_greeting'),
(1491, 1, '_help'),
(1492, 1, '_hidden_comment'),
(1493, 1, '_in_x_days'),
(1494, 1, '_in_x_days_short'),
(1495, 1, '_in_x_hour'),
(1496, 1, '_in_x_hours'),
(1497, 1, '_in_x_hours_short'),
(1498, 1, '_in_x_minutes'),
(1499, 1, '_in_x_minutes_short'),
(1500, 1, '_item'),
(1501, 1, '_items'),
(1502, 1, '_join_form_note'),
(1503, 1, '_just_now'),
(1504, 1, '_kilometers'),
(1505, 1, '_letter'),
(1506, 1, '_living within'),
(1507, 1, '_loading ...'),
(1508, 1, '_login_form_description2join'),
(1509, 1, '_male'),
(1510, 1, '_media_flash_warning'),
(1511, 1, '_member_banned'),
(1512, 1, '_membership'),
(1513, 1, '_message_subject'),
(1514, 1, '_miles'),
(1515, 1, '_mma_comments_edit_own'),
(1516, 1, '_mma_comments_post'),
(1517, 1, '_mma_comments_remove_own'),
(1518, 1, '_mma_comments_vote'),
(1519, 1, '_mma_get_other_members_emails'),
(1520, 1, '_mma_send_friend_request'),
(1521, 1, '_mma_send_greetings'),
(1522, 1, '_mma_send_messages'),
(1523, 1, '_mma_view_profiles'),
(1524, 1, '_mma_vote'),
(1525, 1, '_mmbuilder_box_title'),
(1526, 1, '_mmbuilder_page_title'),
(1527, 1, '_month_next'),
(1528, 1, '_month_next_mini'),
(1529, 1, '_month_prev'),
(1530, 1, '_month_prev_mini'),
(1531, 1, '_more'),
(1532, 1, '_new'),
(1533, 1, '_newest first'),
(1534, 1, '_no limit'),
(1535, 1, '_not_a_member'),
(1536, 1, '_of'),
(1537, 1, '_oldest first'),
(1538, 1, '_online only'),
(1539, 1, '_or'),
(1540, 1, '_pending_friend_request'),
(1541, 1, '_pending_friend_request_answer'),
(1542, 1, '_pfm_unlimited'),
(1543, 1, '_please_fill_next_fields_first'),
(1544, 1, '_popular_tags'),
(1545, 1, '_post_successfully_deleted'),
(1546, 1, '_powered_by_Dolphin'),
(1547, 1, '_prof_status'),
(1548, 1, '_profile_comments'),
(1549, 1, '_profile_info'),
(1550, 1, '_ps_bcpt_add_members'),
(1551, 1, '_ps_bcpt_block_privacy'),
(1552, 1, '_ps_bcpt_create_group'),
(1553, 1, '_ps_bcpt_default_group'),
(1554, 1, '_ps_bcpt_default_values'),
(1555, 1, '_ps_bcpt_delete_members'),
(1556, 1, '_ps_bcpt_my_groups'),
(1557, 1, '_ps_btncpt_add'),
(1558, 1, '_ps_btncpt_create'),
(1559, 1, '_ps_btncpt_delete'),
(1560, 1, '_ps_btncpt_save'),
(1561, 1, '_ps_btncpt_search'),
(1562, 1, '_ps_cpt_extended'),
(1563, 1, '_ps_cpt_none'),
(1564, 1, '_ps_fcpt_extends'),
(1565, 1, '_ps_fcpt_groups'),
(1566, 1, '_ps_fcpt_keyword'),
(1567, 1, '_ps_fcpt_title'),
(1568, 1, '_ps_ferr_incorrect_length'),
(1569, 1, '_ps_ferr_incorrect_select'),
(1570, 1, '_ps_fnote_default_group'),
(1571, 1, '_ps_group_1_title'),
(1572, 1, '_ps_group_2_title'),
(1573, 1, '_ps_group_3_title'),
(1574, 1, '_ps_group_4_title'),
(1575, 1, '_ps_group_5_title'),
(1576, 1, '_ps_group_6_title'),
(1577, 1, '_ps_group_7_title'),
(1578, 1, '_ps_lcpt_add'),
(1579, 1, '_ps_lcpt_delete'),
(1580, 1, '_ps_pcpt_privacy_settings'),
(1581, 1, '_ps_tmenu_privacy_settings'),
(1582, 1, '_ps_view_block'),
(1583, 1, '_public'),
(1584, 1, '_rate profile'),
(1585, 1, '_registration by invitation only'),
(1586, 1, '_sbd_Android_desc'),
(1587, 1, '_sbd_Android_title'),
(1588, 1, '_sbd_iPhone_desc'),
(1589, 1, '_sbd_iPhone_title'),
(1590, 1, '_sbs_tmenu_my_subscriptions'),
(1591, 1, '_sbs_txt_sbs_mass_mailer'),
(1592, 1, '_sbs_txt_sbs_profile'),
(1593, 1, '_sbs_txt_sbs_profile_comments'),
(1594, 1, '_sbs_txt_sbs_profile_edit'),
(1595, 1, '_sbs_txt_title_profile'),
(1596, 1, '_sbs_txt_title_system'),
(1597, 1, '_sbs_wrn_email_notify_disabled'),
(1598, 1, '_sbs_wrn_unsubscribe'),
(1599, 1, '_search_tab_Adv'),
(1600, 1, '_search_tab_quick'),
(1601, 1, '_search_tab_simple'),
(1602, 1, '_services'),
(1603, 1, '_show_replacement'),
(1604, 1, '_sys_add_content'),
(1605, 1, '_sys_adm_akismet_key_empty'),
(1606, 1, '_sys_adm_akismet_key_invalid'),
(1607, 1, '_sys_adm_akismet_key_valid'),
(1608, 1, '_sys_adm_available'),
(1609, 1, '_sys_adm_btn_dnsbl_activate'),
(1610, 1, '_sys_adm_btn_dnsbl_add'),
(1611, 1, '_sys_adm_btn_dnsbl_deactivate'),
(1612, 1, '_sys_adm_btn_dnsbl_delete'),
(1613, 1, '_sys_adm_btn_dnsbl_help'),
(1614, 1, '_sys_adm_btn_dnsbl_help_text'),
(1615, 1, '_sys_adm_btn_dnsbl_log'),
(1616, 1, '_sys_adm_btn_dnsbl_recheck'),
(1617, 1, '_sys_adm_btn_dnsbluri_help_text'),
(1618, 1, '_sys_adm_cache_support'),
(1619, 1, '_sys_adm_disabled'),
(1620, 1, '_sys_adm_dnsbl_failed'),
(1621, 1, '_sys_adm_dnsbl_listed'),
(1622, 1, '_sys_adm_dnsbl_not_listed'),
(1623, 1, '_sys_adm_enabled'),
(1624, 1, '_sys_adm_fld_dnsbl_active'),
(1625, 1, '_sys_adm_fld_dnsbl_chain'),
(1626, 1, '_sys_adm_fld_dnsbl_comment'),
(1627, 1, '_sys_adm_fld_dnsbl_postvresp'),
(1628, 1, '_sys_adm_fld_dnsbl_recheck'),
(1629, 1, '_sys_adm_fld_dnsbl_recheck_url'),
(1630, 1, '_sys_adm_fld_dnsbl_url'),
(1631, 1, '_sys_adm_fld_dnsbl_zonedomain'),
(1632, 1, '_sys_adm_fld_dnsbluri_recheck'),
(1633, 1, '_sys_adm_form_err_required_field'),
(1634, 1, '_sys_adm_installed'),
(1635, 1, '_sys_adm_page_cpt_akismet'),
(1636, 1, '_sys_adm_page_cpt_dnsbl'),
(1637, 1, '_sys_adm_page_cpt_stopforumspam'),
(1638, 1, '_sys_adm_page_cpt_uridnsbl'),
(1639, 1, '_sys_adm_stopforumspam_key_empty'),
(1640, 1, '_sys_adm_stopforumspam_key_specified'),
(1641, 1, '_sys_adm_title_akismet_log'),
(1642, 1, '_sys_adm_title_dnsbl_log'),
(1643, 1, '_sys_adm_title_dnsbl_recheck'),
(1644, 1, '_sys_adm_title_dnsbluri_log'),
(1645, 1, '_sys_adm_title_dnsbluri_recheck'),
(1646, 1, '_sys_adm_title_stopforumspam_log'),
(1647, 1, '_sys_admin_apply'),
(1648, 1, '_sys_admin_filter'),
(1649, 1, '_sys_album'),
(1650, 1, '_sys_album_add'),
(1651, 1, '_sys_album_cancel'),
(1652, 1, '_sys_album_caption_capt'),
(1653, 1, '_sys_album_caption_desc'),
(1654, 1, '_sys_album_caption_loc'),
(1655, 1, '_sys_album_caption_new'),
(1656, 1, '_sys_album_create'),
(1657, 1, '_sys_album_create_new'),
(1658, 1, '_sys_album_delete'),
(1659, 1, '_sys_album_edit_info'),
(1660, 1, '_sys_album_edit_items'),
(1661, 1, '_sys_album_err_desc'),
(1662, 1, '_sys_album_move_to_another'),
(1663, 1, '_sys_album_organize'),
(1664, 1, '_sys_album_privacy_me_info'),
(1665, 1, '_sys_album_private'),
(1666, 1, '_sys_album_save_changes'),
(1667, 1, '_sys_album_x'),
(1668, 1, '_sys_album_x_photo_x'),
(1669, 1, '_sys_am_account_profile_page'),
(1670, 1, '_sys_am_mailbox_compose'),
(1671, 1, '_sys_am_profile_account_page'),
(1672, 1, '_sys_am_profile_friend_accept'),
(1673, 1, '_sys_am_profile_friend_add'),
(1674, 1, '_sys_am_profile_friend_cancel'),
(1675, 1, '_sys_am_profile_message'),
(1676, 1, '_sys_auth_join_with'),
(1677, 1, '_sys_auth_login_with'),
(1678, 1, '_sys_bcpt_member_account_control'),
(1679, 1, '_sys_bcpt_member_friend_requests'),
(1680, 1, '_sys_bcpt_member_new_messages'),
(1681, 1, '_sys_bcpt_my_subscriptions'),
(1682, 1, '_sys_bcpt_profile_cover'),
(1683, 1, '_sys_bcpt_subscribe'),
(1684, 1, '_sys_block_title_social_sharing'),
(1685, 1, '_sys_block_title_forum_feed'),
(1686, 1, '_sys_bm_design'),
(1687, 1, '_sys_bm_language'),
(1688, 1, '_sys_bm_popup_cpt_design'),
(1689, 1, '_sys_bm_popup_cpt_language'),
(1690, 1, '_sys_box_title_download'),
(1691, 1, '_sys_box_title_search_keyword'),
(1692, 1, '_sys_box_title_search_people'),
(1693, 1, '_sys_btn_thumbnail_change'),
(1694, 1, '_sys_btn_cover_change'),
(1695, 1, '_sys_btn_fans_add_to_admins'),
(1696, 1, '_sys_btn_fans_confirm'),
(1697, 1, '_sys_btn_fans_move_admins_to_fans'),
(1698, 1, '_sys_btn_fans_reject'),
(1699, 1, '_sys_btn_fans_remove'),
(1700, 1, '_sys_btn_sbs_send'),
(1701, 1, '_sys_btn_sbs_subscribe'),
(1702, 1, '_sys_btn_sbs_unsubscribe'),
(1703, 1, '_sys_bx_attr'),
(1704, 1, '_sys_calendar'),
(1705, 1, '_sys_city_country_format'),
(1706, 1, '_sys_cnts_bcpt_connections'),
(1707, 1, '_sys_cnts_bcpt_fave'),
(1708, 1, '_sys_cnts_bcpt_fave_remove'),
(1709, 1, '_sys_cnts_bcpt_friend_requests'),
(1710, 1, '_sys_cnts_btn_fave'),
(1711, 1, '_sys_cnts_btn_fr_accept'),
(1712, 1, '_sys_cnts_btn_fr_reject'),
(1713, 1, '_sys_cnts_msg_fr_empty'),
(1714, 1, '_sys_cnts_txt_blocked'),
(1715, 1, '_sys_cnts_txt_favorites'),
(1716, 1, '_sys_cnts_txt_frients'),
(1717, 1, '_sys_cnts_txt_mf_no'),
(1718, 1, '_sys_cnts_txt_mutual_friends'),
(1719, 1, '_sys_email_footer_info'),
(1720, 1, '_sys_err_categories'),
(1721, 1, '_sys_export_success'),
(1722, 1, '_sys_invitation_step_additional_emails'),
(1723, 1, '_sys_invitation_step_additional_emails_info'),
(1724, 1, '_sys_invitation_step_invitation_text'),
(1725, 1, '_sys_invitation_step_invitation_text_info'),
(1726, 1, '_sys_invitation_step_select_users'),
(1727, 1, '_sys_invitation_step_select_users_info'),
(1728, 1, '_sys_kilobyte'),
(1729, 1, '_sys_mailbox_back_inbox'),
(1730, 1, '_sys_mailbox_back_outbox'),
(1731, 1, '_sys_mailbox_back_trash'),
(1732, 1, '_sys_member_info_username'),
(1733, 1, '_sys_member_info_first_name'),
(1734, 1, '_sys_member_info_first_name_last_name'),
(1735, 1, '_sys_member_info_last_name_firs_name'),
(1736, 1, '_sys_member_info_full_name'),
(1737, 1, '_sys_member_info_headline'),
(1738, 1, '_sys_member_info_status_message'),
(1739, 1, '_sys_member_info_age_sex'),
(1740, 1, '_sys_member_info_location'),
(1741, 1, '_sys_member_thumb_avatar'),
(1742, 1, '_sys_member_thumb_icon_avatar'),
(1743, 1, '_sys_mobile_friends'),
(1744, 1, '_sys_mobile_info'),
(1745, 1, '_sys_mobile_mail'),
(1746, 1, '_sys_mobile_profile_contact'),
(1747, 1, '_sys_mobile_profile_friends'),
(1748, 1, '_sys_mobile_profile_info'),
(1749, 1, '_sys_mobile_search'),
(1750, 1, '_sys_mobile_search_by_keyword'),
(1751, 1, '_sys_mobile_search_by_location'),
(1752, 1, '_sys_mobile_status'),
(1753, 1, '_sys_module_profile'),
(1754, 1, '_sys_outdated_browser'),
(1755, 1, '_sys_outdated_browser_explain'),
(1756, 1, '_sys_pmt_shopping_cart_caption'),
(1757, 1, '_sys_pmt_shopping_cart_description'),
(1758, 1, '_sys_pmt_tmenu_cart'),
(1759, 1, '_sys_pmt_tmenu_payments'),
(1760, 1, '_sys_pcpt_my_subscriptions'),
(1761, 1, '_sys_private'),
(1762, 1, '_sys_profile'),
(1763, 1, '_sys_profile_private_text'),
(1764, 1, '_sys_profile_private_text_title'),
(1765, 1, '_sys_profiles'),
(1766, 1, '_sys_profiles_caption_browse_by_day'),
(1767, 1, '_sys_recaptcha_incorrect'),
(1768, 1, '_sys_recaptcha_text_image'),
(1769, 1, '_sys_recaptcha_text_audio'),
(1770, 1, '_sys_recaptcha_btn_refresh'),
(1771, 1, '_sys_recaptcha_btn_title_refresh'),
(1772, 1, '_sys_recaptcha_btn_audio'),
(1773, 1, '_sys_recaptcha_btn_title_audio'),
(1774, 1, '_sys_recaptcha_btn_image'),
(1775, 1, '_sys_recaptcha_btn_title_image'),
(1776, 1, '_sys_recaptcha_btn_help'),
(1777, 1, '_sys_recaptcha_btn_title_help'),
(1778, 1, '_sys_request_method_not_found_cnt'),
(1779, 1, '_sys_request_method_not_found_cpt'),
(1780, 1, '_sys_request_module_not_found_cnt'),
(1781, 1, '_sys_request_module_not_found_cpt'),
(1782, 1, '_sys_request_page_not_found_cnt'),
(1783, 1, '_sys_request_page_not_found_cpt'),
(1784, 1, '_sys_save_nothing'),
(1785, 1, '_sys_search_main_title'),
(1786, 1, '_sys_select_one'),
(1787, 1, '_sys_sitemap'),
(1788, 1, '_sys_sitemap_desc'),
(1789, 1, '_sys_sitemap_form_caption'),
(1790, 1, '_sys_sitemap_form_caption_sitemap_generated'),
(1791, 1, '_sys_sitemap_list'),
(1792, 1, '_sys_sitemap_pages'),
(1793, 1, '_sys_sitemap_profiles'),
(1794, 1, '_sys_sitemap_profiles_info'),
(1795, 1, '_sys_sitemap_system'),
(1796, 1, '_sys_sm_account'),
(1797, 1, '_sys_sm_account_menu'),
(1798, 1, '_sys_sm_join'),
(1799, 1, '_sys_sm_join_or_login'),
(1800, 1, '_sys_sm_login'),
(1801, 1, '_sys_sm_logout'),
(1802, 1, '_sys_sm_profile'),
(1803, 1, '_sys_sm_profile_settings'),
(1804, 1, '_sys_sm_search'),
(1805, 1, '_sys_spam_detected'),
(1806, 1, '_sys_status_default'),
(1807, 1, '_sys_status_update'),
(1808, 1, '_sys_sucess_result'),
(1809, 1, '_sys_tags_note'),
(1810, 1, '_sys_top_menu_more'),
(1811, 1, '_sys_txt_ac_manage_subscriptions'),
(1812, 1, '_sys_txt_btn_loading'),
(1813, 1, '_sys_txt_captcha_not_available'),
(1814, 1, '_sys_txt_cmt_loading'),
(1815, 1, '_sys_txt_cmt_mood_negative'),
(1816, 1, '_sys_txt_cmt_mood_neutral'),
(1817, 1, '_sys_txt_cmt_mood_positive'),
(1818, 1, '_sys_txt_form_toggle_html_editor'),
(1819, 1, '_sys_txt_select_files'),
(1820, 1, '_sys_txt_sbs_already_subscribed'),
(1821, 1, '_sys_txt_sbs_already_unsubscribed'),
(1822, 1, '_sys_txt_sbs_cannot_find_subscription'),
(1823, 1, '_sys_txt_sbs_cannot_save_visitor'),
(1824, 1, '_sys_txt_sbs_email'),
(1825, 1, '_sys_txt_sbs_empty_name_email'),
(1826, 1, '_sys_txt_sbs_error_occured'),
(1827, 1, '_sys_txt_sbs_name'),
(1828, 1, '_sys_txt_sbs_success_subscribe'),
(1829, 1, '_sys_txt_sbs_success_unsubscribe'),
(1830, 1, '_sys_txt_uploader_html5'),
(1831, 1, '_sys_txt_uploader_html5_not_supported'),
(1832, 1, '_sys_txt_upload_failed'),
(1833, 1, '_sys_txt_upload_size_error'),
(1834, 1, '_sys_txt_upload_abort'),
(1835, 1, '_sys_txt_upload_done'),
(1836, 1, '_sys_txt_wrong_file_extension'),
(1837, 1, '_sys_upload'),
(1838, 1, '_sys_media_disapproved'),
(1839, 1, '_sys_media_processing'),
(1840, 1, '_sys_media_not_found'),
(1841, 1, '_sys_wrn_disabled_scripts'),
(1842, 1, '_sys_x_byte'),
(1843, 1, '_sys_x_gigabyte'),
(1844, 1, '_sys_x_kilobyte'),
(1845, 1, '_sys_x_megabyte'),
(1846, 1, '_sys_x_terabyte'),
(1847, 1, '_tags_by_day'),
(1848, 1, '_tags_calendar'),
(1849, 1, '_tags_caption_keyword'),
(1850, 1, '_tags_caption_module'),
(1851, 1, '_tags_err_keyword'),
(1852, 1, '_tags_founded_tags'),
(1853, 1, '_tags_plural'),
(1854, 1, '_tags_recent'),
(1855, 1, '_tags_search_form'),
(1856, 1, '_tags_single'),
(1857, 1, '_td_caption'),
(1858, 1, '_td_content'),
(1859, 1, '_td_date'),
(1860, 1, '_td_edit'),
(1861, 1, '_td_err_empty_value'),
(1862, 1, '_td_err_incorrect_length'),
(1863, 1, '_td_post'),
(1864, 1, '_td_snippet'),
(1865, 1, '_td_tags'),
(1866, 1, '_title_min_lenght'),
(1867, 1, '_to'),
(1868, 1, '_tomorrow'),
(1869, 1, '_top'),
(1870, 1, '_top_extra'),
(1871, 1, '_uknown'),
(1872, 1, '_undefined'),
(1873, 1, '_votes'),
(1874, 1, '_n_votes'),
(1875, 1, '_week_fri'),
(1876, 1, '_week_mon'),
(1877, 1, '_week_sat'),
(1878, 1, '_week_sun'),
(1879, 1, '_week_thu'),
(1880, 1, '_week_tue'),
(1881, 1, '_week_wed'),
(1882, 1, '_week_fri_mini'),
(1883, 1, '_week_mon_mini'),
(1884, 1, '_week_sat_mini'),
(1885, 1, '_week_sun_mini'),
(1886, 1, '_week_thu_mini'),
(1887, 1, '_week_tue_mini'),
(1888, 1, '_week_wed_mini'),
(1889, 1, '_x_days_ago'),
(1890, 1, '_x_days_ago_short'),
(1891, 1, '_x_hour_ago'),
(1892, 1, '_x_hours_ago'),
(1893, 1, '_x_hours_ago_short'),
(1894, 1, '_x_minutes_ago'),
(1895, 1, '_x_minutes_ago_short'),
(1896, 1, '_y/o'),
(1897, 1, '_yesterday'),
(1898, 1, '__$10,000-$30,000/year'),
(1899, 1, '__$10,000/year and less'),
(1900, 1, '__$30,000-$50,000/year'),
(1901, 1, '__$50,000-$70,000/year'),
(1902, 1, '__$70,000/year and more'),
(1903, 1, '__Average'),
(1904, 1, '__Ample'),
(1905, 1, '__Athletic'),
(1906, 1, '__Cuddly'),
(1907, 1, '__Slim'),
(1908, 1, '__Very Cuddly'),
(1909, 1, '__Afghanistan'),
(1910, 1, '__Albania'),
(1911, 1, '__Algeria'),
(1912, 1, '__American Samoa'),
(1913, 1, '__Andorra'),
(1914, 1, '__Angola'),
(1915, 1, '__Anguilla'),
(1916, 1, '__Antarctica'),
(1917, 1, '__Antigua and Barbuda'),
(1918, 1, '__Argentina'),
(1919, 1, '__Armenia'),
(1920, 1, '__Aruba'),
(1921, 1, '__Australia'),
(1922, 1, '__Austria'),
(1923, 1, '__Azerbaijan'),
(1924, 1, '__Bahrain'),
(1925, 1, '__Bangladesh'),
(1926, 1, '__Barbados'),
(1927, 1, '__Belarus'),
(1928, 1, '__Belgium'),
(1929, 1, '__Belize'),
(1930, 1, '__Benin'),
(1931, 1, '__Bermuda'),
(1932, 1, '__Bhutan'),
(1933, 1, '__Bolivia'),
(1934, 1, '__Botswana'),
(1935, 1, '__Bouvet Island'),
(1936, 1, '__Brazil'),
(1937, 1, '__Brunei Darussalam'),
(1938, 1, '__Bulgaria'),
(1939, 1, '__Burkina Faso'),
(1940, 1, '__Burma'),
(1941, 1, '__Burundi'),
(1942, 1, '__Cambodia'),
(1943, 1, '__Cameroon'),
(1944, 1, '__Cape Verde'),
(1945, 1, '__Cayman Islands'),
(1946, 1, '__Chad'),
(1947, 1, '__Canada'),
(1948, 1, '__Chile'),
(1949, 1, '__China'),
(1950, 1, '__Christmas Island'),
(1951, 1, '__Cote d''Ivoire'),
(1952, 1, '__Colombia'),
(1953, 1, '__Comoros'),
(1954, 1, '__Cook Islands'),
(1955, 1, '__Costa Rica'),
(1956, 1, '__Croatia'),
(1957, 1, '__Cuba'),
(1958, 1, '__Cyprus'),
(1959, 1, '__Czech Republic'),
(1960, 1, '__Denmark'),
(1961, 1, '__Djibouti'),
(1962, 1, '__Dominica'),
(1963, 1, '__Dominican Republic'),
(1964, 1, '__East Timor'),
(1965, 1, '__Ecuador'),
(1966, 1, '__Egypt'),
(1967, 1, '__El Salvador'),
(1968, 1, '__Equatorial Guinea'),
(1969, 1, '__Eritrea'),
(1970, 1, '__Estonia'),
(1971, 1, '__Ethiopia'),
(1972, 1, '__Faroe Islands'),
(1973, 1, '__Fiji'),
(1974, 1, '__Finland'),
(1975, 1, '__Falkland Islands (Islas Malvinas)'),
(1976, 1, '__France'),
(1977, 1, '__Gabon'),
(1978, 1, '__Georgia'),
(1979, 1, '__Germany'),
(1980, 1, '__Ghana'),
(1981, 1, '__Gibraltar'),
(1982, 1, '__Greece'),
(1983, 1, '__Greenland'),
(1984, 1, '__Grenada'),
(1985, 1, '__Guadeloupe'),
(1986, 1, '__Guam'),
(1987, 1, '__Guatemala'),
(1988, 1, '__Guinea'),
(1989, 1, '__Guinea-Bissau'),
(1990, 1, '__Guyana'),
(1991, 1, '__Haiti'),
(1992, 1, '__Holy See (Vatican City)'),
(1993, 1, '__Hong Kong (SAR)'),
(1994, 1, '__Honduras'),
(1995, 1, '__Hungary'),
(1996, 1, '__Iceland'),
(1997, 1, '__India'),
(1998, 1, '__Indonesia'),
(1999, 1, '__Iran'),
(2000, 1, '__Iraq'),
(2001, 1, '__Ireland'),
(2002, 1, '__Israel'),
(2003, 1, '__Italy'),
(2004, 1, '__Jamaica'),
(2005, 1, '__Japan'),
(2006, 1, '__Jordan'),
(2007, 1, '__Kazakhstan'),
(2008, 1, '__Kenya'),
(2009, 1, '__Kiribati'),
(2010, 1, '__Kuwait'),
(2011, 1, '__Kyrgyzstan'),
(2012, 1, '__Latvia'),
(2013, 1, '__Lebanon'),
(2014, 1, '__Lesotho'),
(2015, 1, '__Liberia'),
(2016, 1, '__Liechtenstein'),
(2017, 1, '__Lithuania'),
(2018, 1, '__Luxembourg'),
(2019, 1, '__Madagascar'),
(2020, 1, '__Malawi'),
(2021, 1, '__Malaysia'),
(2022, 1, '__Maldives'),
(2023, 1, '__Mali'),
(2024, 1, '__Malta'),
(2025, 1, '__Marshall Islands'),
(2026, 1, '__Martinique'),
(2027, 1, '__Mauritania'),
(2028, 1, '__Mauritius'),
(2029, 1, '__Mayotte'),
(2030, 1, '__Mexico'),
(2031, 1, '__Moldova'),
(2032, 1, '__Monaco'),
(2033, 1, '__Mongolia'),
(2034, 1, '__Montserrat'),
(2035, 1, '__Morocco'),
(2036, 1, '__Mozambique'),
(2037, 1, '__Namibia'),
(2038, 1, '__Nauru'),
(2039, 1, '__Nepal'),
(2040, 1, '__Netherlands'),
(2041, 1, '__New Caledonia'),
(2042, 1, '__New Zealand'),
(2043, 1, '__Nicaragua'),
(2044, 1, '__Niger'),
(2045, 1, '__Nigeria'),
(2046, 1, '__Niue'),
(2047, 1, '__Norfolk Island'),
(2048, 1, '__Norway'),
(2049, 1, '__Oman'),
(2050, 1, '__Pakistan'),
(2051, 1, '__Palau'),
(2052, 1, '__Panama'),
(2053, 1, '__Papua New Guinea'),
(2054, 1, '__Paraguay'),
(2055, 1, '__Peru'),
(2056, 1, '__Philippines'),
(2057, 1, '__Poland'),
(2058, 1, '__Portugal'),
(2059, 1, '__Puerto Rico'),
(2060, 1, '__Qatar'),
(2061, 1, '__Reunion'),
(2062, 1, '__Romania'),
(2063, 1, '__Russia'),
(2064, 1, '__Rwanda'),
(2065, 1, '__Saint Lucia'),
(2066, 1, '__Samoa'),
(2067, 1, '__San Marino'),
(2068, 1, '__Saudi Arabia'),
(2069, 1, '__Senegal'),
(2070, 1, '__Seychelles'),
(2071, 1, '__Sierra Leone'),
(2072, 1, '__Singapore'),
(2073, 1, '__Slovakia'),
(2074, 1, '__Solomon Islands'),
(2075, 1, '__Somalia'),
(2076, 1, '__South Africa'),
(2077, 1, '__Spain'),
(2078, 1, '__Sri Lanka'),
(2079, 1, '__Sudan'),
(2080, 1, '__Suriname'),
(2081, 1, '__Swaziland'),
(2082, 1, '__Sweden'),
(2083, 1, '__Switzerland'),
(2084, 1, '__Syria'),
(2085, 1, '__Taiwan'),
(2086, 1, '__Tajikistan'),
(2087, 1, '__Tanzania'),
(2088, 1, '__Thailand'),
(2089, 1, '__Togo'),
(2090, 1, '__Tokelau'),
(2091, 1, '__Tonga'),
(2092, 1, '__Trinidad and Tobago'),
(2093, 1, '__Tunisia'),
(2094, 1, '__Turkey'),
(2095, 1, '__Turkmenistan'),
(2096, 1, '__Tuvalu'),
(2097, 1, '__Uganda'),
(2098, 1, '__Ukraine'),
(2099, 1, '__United Arab Emirates'),
(2100, 1, '__United Kingdom'),
(2101, 1, '__Uruguay'),
(2102, 1, '__Uzbekistan'),
(2103, 1, '__Vanuatu'),
(2104, 1, '__Venezuela'),
(2105, 1, '__Virgin Islands'),
(2106, 1, '__Western Sahara'),
(2107, 1, '__Yemen'),
(2108, 1, '__Zambia'),
(2109, 1, '__Zimbabwe'),
(2110, 1, '__Netherlands Antilles'),
(2111, 1, '__Bosnia and Herzegovina'),
(2112, 1, '__The Bahamas'),
(2113, 1, '__Cocos (Keeling) Islands'),
(2114, 1, '__Congo, Democratic Republic of the'),
(2115, 1, '__Central African Republic'),
(2116, 1, '__Congo, Republic of the'),
(2117, 1, '__Micronesia, Federated States of'),
(2118, 1, '__French Guiana'),
(2119, 1, '__The Gambia'),
(2120, 1, '__South Georgia and the South Sandwich Islands'),
(2121, 1, '__Heard Island and McDonald Islands'),
(2122, 1, '__British Indian Ocean Territory'),
(2123, 1, '__Saint Kitts and Nevis'),
(2124, 1, '__Korea, North'),
(2125, 1, '__Korea, South'),
(2126, 1, '__Laos'),
(2127, 1, '__Libya'),
(2128, 1, '__Macedonia, The Former Yugoslav Republic of'),
(2129, 1, '__Macao'),
(2130, 1, '__Northern Mariana Islands'),
(2131, 1, '__French Polynesia'),
(2132, 1, '__Saint Pierre and Miquelon'),
(2133, 1, '__Pitcairn Islands'),
(2134, 1, '__Palestinian Territory, Occupied'),
(2135, 1, '__Saint Helena'),
(2136, 1, '__Slovenia'),
(2137, 1, '__Svalbard'),
(2138, 1, '__Sao Tome and Principe'),
(2139, 1, '__Turks and Caicos Islands'),
(2140, 1, '__French Southern and Antarctic Lands'),
(2141, 1, '__United States Minor Outlying Islands'),
(2142, 1, '__United States'),
(2143, 1, '__Saint Vincent and the Grenadines'),
(2144, 1, '__British Virgin Islands'),
(2145, 1, '__Vietnam'),
(2146, 1, '__Aland_Islands'),
(2147, 1, '__Saint_Barthelemy'),
(2148, 1, '__Guernsey'),
(2149, 1, '__Isle_of_Man'),
(2150, 1, '__Jersey'),
(2151, 1, '__Montenegro'),
(2152, 1, '__Saint_Martin_French_part'),
(2153, 1, '__Serbia'),
(2154, 1, '__Wallis and Futuna'),
(2155, 1, '__All'),
(2156, 1, '__Active'),
(2157, 1, '__Approval'),
(2158, 1, '__Suspended'),
(2159, 1, '__Unconfirmed'),
(2160, 1, '__AA (2 years college)'),
(2161, 1, '__BA/BS (4 years college)'),
(2162, 1, '__High School graduate'),
(2163, 1, '__Some college'),
(2164, 1, '__College student'),
(2165, 1, '__Some grad school'),
(2166, 1, '__Grad school student'),
(2167, 1, '__MA/MS/MBA'),
(2168, 1, '__PhD/Post doctorate'),
(2169, 1, '__JD'),
(2170, 1, '__African'),
(2171, 1, '__African American'),
(2172, 1, '__Asian'),
(2173, 1, '__Caucasian'),
(2174, 1, '__East Indian'),
(2175, 1, '__Hispanic'),
(2176, 1, '__Indian'),
(2177, 1, '__Latino'),
(2178, 1, '__Mediterranean'),
(2179, 1, '__Middle Eastern'),
(2180, 1, '__Mixed'),
(2181, 1, '__English'),
(2182, 1, '__Afrikaans'),
(2183, 1, '__Arabic'),
(2184, 1, '__Bulgarian'),
(2185, 1, '__Burmese'),
(2186, 1, '__Cantonese'),
(2187, 1, '__Croatian'),
(2188, 1, '__Danish'),
(2189, 1, '__Dutch'),
(2190, 1, '__Esperanto'),
(2191, 1, '__Estonian'),
(2192, 1, '__Finnish'),
(2193, 1, '__French'),
(2194, 1, '__German'),
(2195, 1, '__Greek'),
(2196, 1, '__Gujrati'),
(2197, 1, '__Hebrew'),
(2198, 1, '__Hindi'),
(2199, 1, '__Hungarian'),
(2200, 1, '__Icelandic'),
(2201, 1, '__Indonesian'),
(2202, 1, '__Italian'),
(2203, 1, '__Japanese'),
(2204, 1, '__Korean'),
(2205, 1, '__Latvian'),
(2206, 1, '__Lithuanian'),
(2207, 1, '__Malay'),
(2208, 1, '__Mandarin'),
(2209, 1, '__Marathi'),
(2210, 1, '__Moldovian'),
(2211, 1, '__Nepalese'),
(2212, 1, '__Norwegian'),
(2213, 1, '__Persian'),
(2214, 1, '__Polish'),
(2215, 1, '__Portuguese'),
(2216, 1, '__Punjabi'),
(2217, 1, '__Romanian'),
(2218, 1, '__Russian'),
(2219, 1, '__Serbian'),
(2220, 1, '__Spanish'),
(2221, 1, '__Swedish'),
(2222, 1, '__Tagalog'),
(2223, 1, '__Taiwanese'),
(2224, 1, '__Tamil'),
(2225, 1, '__Telugu'),
(2226, 1, '__Thai'),
(2227, 1, '__Tongan'),
(2228, 1, '__Turkish'),
(2229, 1, '__Ukrainian'),
(2230, 1, '__Urdu'),
(2231, 1, '__Vietnamese'),
(2232, 1, '__Visayan'),
(2233, 1, '__Single'),
(2234, 1, '__Attached'),
(2235, 1, '__Divorced'),
(2236, 1, '__Married'),
(2237, 1, '__Separated'),
(2238, 1, '__Widow'),
(2239, 1, '__Adventist'),
(2240, 1, '__Agnostic'),
(2241, 1, '__Atheist'),
(2242, 1, '__Baptist'),
(2243, 1, '__Buddhist'),
(2244, 1, '__Caodaism'),
(2245, 1, '__Catholic'),
(2246, 1, '__Christian'),
(2247, 1, '__Hindu'),
(2248, 1, '__Iskcon'),
(2249, 1, '__Jainism'),
(2250, 1, '__Jewish'),
(2251, 1, '__Methodist'),
(2252, 1, '__Mormon'),
(2253, 1, '__Moslem'),
(2254, 1, '__Orthodox'),
(2255, 1, '__Pentecostal'),
(2256, 1, '__Protestant'),
(2257, 1, '__Quaker'),
(2258, 1, '__Scientology'),
(2259, 1, '__Shinto'),
(2260, 1, '__Sikhism'),
(2261, 1, '__Spiritual'),
(2262, 1, '__Taoism'),
(2263, 1, '__Wiccan'),
(2264, 1, '__Other'),
(2265, 1, '__No'),
(2266, 1, '__Rarely'),
(2267, 1, '__Often'),
(2268, 1, '__Very often');

-- --------------------------------------------------------

--
-- Table structure for table `sys_localization_languages`
--

CREATE TABLE `sys_localization_languages` (
  `ID` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(5) NOT NULL DEFAULT '',
  `Flag` varchar(2) NOT NULL DEFAULT '',
  `Title` varchar(255) NOT NULL DEFAULT '',
  `Direction` enum('LTR','RTL') NOT NULL DEFAULT 'LTR',
  `LanguageCountry` varchar(8) NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Name` (`Name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_localization_languages`
--

INSERT INTO `sys_localization_languages` VALUES
(1, 'en', 'gb', 'English', 'LTR', 'en_GB');

-- --------------------------------------------------------

--
-- Table structure for table `sys_localization_strings`
--

CREATE TABLE `sys_localization_strings` (
  `IDKey` int(10) unsigned NOT NULL DEFAULT '0',
  `IDLanguage` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `String` mediumtext NOT NULL,
  PRIMARY KEY (`IDKey`,`IDLanguage`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_localization_strings`
--

INSERT INTO `sys_localization_strings` VALUES
(1, 1, 'This site is powered by <a href="https://www.boonex.com/features" target="_blank">BoonEx Dolphin</a>. The rest is a mystery.'),
(2, 1, 'About Us'),
(3, 1, ' every {4} hours'),
(4, 1, 'Limit reached. Your current membership (<b>{2}</b>) allows you to {1} no more than {3} times'),
(5, 1, '<div style="width: 80%">Your account is inactive. <a href="mailto:{7}">Contact us</a> to request account activation to access this feature.</div>'),
(6, 1, '<div style="width: 80%">Your current membership (<b>{2}</b>) doesn''t allow you to <b>{1}</b>.</div>'),
(7, 1, '<div style="width: 80%">Your current membership (<b>{2}</b>) doesn''t allow you to <b>{1}</b> since <b>{5}</b>.</div>'),
(8, 1, '<div style="width: 80%">Your current membership (<b>{2}</b>) doesn''t allow you to <b>{1}</b> until <b>{6}</b>.</div>'),
(9, 1, 'Email Confirmation'),
(10, 1, 'Your e-mail confirmation'),
(11, 1, 'Your message has been sent.'),
(12, 1, '\n<p>"My advice to people today is as follows: if you take the game of life seriously, if you take your nervous system seriously, if you take your sense organs seriously, if you take the energy process seriously, you must turn on, tune in, and drop out."</p>\n<p class="bx-def-font-grayed"><i>Timothy Leary</i></p>'),
(13, 1, 'Advice'),
(14, 1, 'Advice'),
(15, 1, 'Your account is already active..'),
(16, 1, '<a href="pedit.php?ID={0}">Edit Profile</a>\n  <span class="sys-bullet"></span>\n  <a href="javascript:void(0);" onclick="javascript:loadHtmlInPopup(''explanation_popup'', ''explanation.php?explain=Active'');">Explanation</a>\n  <span class="sys-bullet"></span>\n  <a href="change_status.php">Suspend</a>\n  <span class="sys-bullet"></span>\n  <a href="javascript:void(0);" onclick="bx_export_user_data_popup()">Export personal data</a>'),
(17, 1, 'You are an active member. You can suspend your profile to hide it from others, if needed.'),
(18, 1, '<a href="javascript:void(0);" onclick="javascript:loadHtmlInPopup(''explanation_popup'', ''explanation.php?explain=Approval'');">Info</a>'),
(19, 1, 'Your profile activation is in progress. Usually it takes up to 24 hours. Thank you for your patience.'),
(20, 1, '<a href="javascript:void(0);" onclick="javascript:loadHtmlInPopup(''explanation_popup'', ''explanation.php?explain=Rejected'');">Info</a>'),
(21, 1, 'Your profile was rejected by site administrator due to inacceptable or missing information. If you have any questions, please, <a target=_blank href="contact.php">contact us</a>.'),
(22, 1, '<a href="javascript:void(0);" onclick="javascript:loadHtmlInPopup(''explanation_popup'', ''explanation.php?explain=Suspended'');">Info</a>'),
(23, 1, 'Your profile is suspended and is not visible to others. You can activate it <a target=_blank href="change_status.php">here</a>. If you have any questions, please <a target=_blank href="contact.php">contact us</a>.'),
(24, 1, '<a href="javascript:void(0);" onclick="javascript:loadHtmlInPopup(''explanation_popup'', ''explanation.php?explain=Unconfirmed'');">Info</a>'),
(25, 1, 'Follow the activation link in e-mail we''ve sent you. <br /><a target=_blank href="activation_email.php">Re-send me the confirmation e-mail</a>.'),
(26, 1, 'About'),
(27, 1, 'About Us'),
(28, 1, 'Access denied'),
(29, 1, 'Account'),
(30, 1, 'Account Home'),
(31, 1, 'Account Info'),
(32, 1, 'Action'),
(33, 1, 'Actions'),
(34, 1, 'Activate account'),
(35, 1, 'Active'),
(36, 1, 'Connections'),
(37, 1, 'Add Category'),
(38, 1, 'Add Post'),
(39, 1, 'Comment'),
(40, 1, 'Added'),
(41, 1, 'Added by'),
(42, 1, 'Additional information'),
(43, 1, 'Admin'),
(44, 1, 'Admin Panel'),
(45, 1, 'Advice'),
(46, 1, 'All'),
(47, 1, 'All Members'),
(48, 1, 'Allowed Since'),
(49, 1, 'Allowed Until'),
(50, 1, 'Allowed actions'),
(51, 1, 'Anonymous'),
(52, 1, '- Any -'),
(53, 1, 'Approval'),
(54, 1, 'Approve'),
(55, 1, 'April'),
(56, 1, 'Archive'),
(57, 1, 'Are you sure?'),
(58, 1, 'August'),
(59, 1, 'Auth type'),
(60, 1, 'Author'),
(61, 1, 'Away'),
(62, 1, 'Back'),
(63, 1, 'Cancel Friend Request(s)'),
(64, 1, 'Basic'),
(65, 1, 'Befriend'),
(66, 1, 'Birthdays'),
(67, 1, 'Block'),
(68, 1, 'Block list'),
(69, 1, 'Bookmark'),
(70, 1, 'BoonEx News'),
(71, 1, 'Bottom'),
(72, 1, 'Browse'),
(73, 1, 'Browse Profiles'),
(74, 1, 'Busy'),
(75, 1, 'By'),
(76, 1, 'By Age'),
(77, 1, 'By Country'),
(78, 1, 'Women'),
(79, 1, 'Men'),
(80, 1, 'By Sex'),
(81, 1, 'Change Account Status'),
(82, 1, 'Suspend/Activate your account'),
(83, 1, 'Write a new message'),
(84, 1, 'Write and send a message'),
(85, 1, 'Your contact information is here'),
(86, 1, 'Contact us'),
(87, 1, 'Feedback section - questions and comments.'),
(88, 1, 'Comments with replies cannot be deleted.'),
(89, 1, 'Cancel'),
(90, 1, 'Cancel Uploads'),
(91, 1, 'Security image check failed'),
(92, 1, 'Caption'),
(93, 1, 'Categories'),
(94, 1, 'Categories Settings'),
(95, 1, 'Category'),
(96, 1, 'chat'),
(97, 1, 'Choose'),
(98, 1, 'City'),
(99, 1, 'Click here'),
(100, 1, 'Click to sort'),
(101, 1, 'Close'),
(102, 1, 'PHP Block'),
(103, 1, 'Negative'),
(104, 1, 'Neutral'),
(105, 1, 'Positive'),
(106, 1, 'Comments'),
(107, 1, 'Compose'),
(108, 1, 'Compose'),
(109, 1, 'Confirm password'),
(110, 1, 'Enter the same password here'),
(111, 1, 'Confirmation code'),
(112, 1, 'Contact'),
(113, 1, 'Contact information not sent'),
(114, 1, 'Contact information sent'),
(115, 1, 'Contacted'),
(116, 1, 'Content'),
(117, 1, 'Continue'),
(118, 1, 'My Account'),
(119, 1, 'Count'),
(120, 1, 'Counter'),
(121, 1, 'Country'),
(122, 1, 'Couple'),
(123, 1, 'Couple profile was not found'),
(124, 1, 'Customize'),
(125, 1, 'Your account was successfully deleted'),
(126, 1, 'All of your content will be deleted. Are you sure you want to delete your account?'),
(127, 1, 'Account'),
(128, 1, 'Database Error'),
(129, 1, 'Date'),
(130, 1, 'UnFeature'),
(131, 1, 'December'),
(132, 1, 'Delete'),
(133, 1, 'Delete account'),
(134, 1, 'Delete image'),
(135, 1, 'Description'),
(136, 1, 'Disapprove'),
(137, 1, 'Download'),
(138, 1, 'Duplicate vote'),
(139, 1, 'E-mail'),
(140, 1, 'Username'),
(141, 1, 'This could happen because your web mail service displays web links improperly. If you see this message, please try to <u>exactly</u> copy the link from the confirmation e-mail and paste it into your browser''s address bar <b>or</b> just enter the confirmation code below:'),
(142, 1, '<b>E-mail has NOT been sent.</b><br />Unfortunately we could not send the confirmation e-mail. Please, try again later. We appologize for any inconvenience. <a href="contact.php">Please report this issue to us</a>.'),
(143, 1, '<b>E-mail has been successfully sent.</b><br />You should receive it within a minute.'),
(144, 1, 'Congratulations! Your e-mail is now confirmed.<br /><br />Your profile is created and is awaiting review. Thank you for your patience.'),
(145, 1, 'Enter confirmation code'),
(146, 1, 'Error while processing uploaded image'),
(147, 1, 'Explanation'),
(148, 1, 'Edit'),
(149, 1, 'Edit Profile'),
(150, 1, 'Edit'),
(151, 1, 'Edit profile info and settings'),
(152, 1, 'Email'),
(153, 1, 'Email confirmation'),
(154, 1, 'E-mail confirmed'),
(155, 1, 'Email send failed'),
(156, 1, 'Email was successfully sent'),
(157, 1, 'Embed'),
(158, 1, 'Empty'),
(159, 1, 'Enter Captcha'),
(160, 1, 'Enter email(s)'),
(161, 1, 'Enter new URL'),
(162, 1, 'Enter what you see'),
(163, 1, 'Please, enter a value here'),
(164, 1, 'Error'),
(165, 1, 'Error Occurred'),
(166, 1, 'Error occurred'),
(167, 1, 'Form contains errors, please review errors and try again.'),
(168, 1, 'Expiration date'),
(169, 1, 'Extended'),
(170, 1, 'Something went wrong! Please try reloading the page.'),
(171, 1, 'An uncaught exception was thrown'),
(172, 1, 'An uncaught exception was thrown in'),
(173, 1, 'Failed to send message to one or more recipients.'),
(174, 1, 'Failed to send message. This member has blocked you.'),
(175, 1, 'Your membership level doesn''t allow you to send messages'),
(176, 1, 'Failed to send message. Recipient is not an active member. <a href="{0}">[Click here]</a> to send another message.'),
(177, 1, 'FAQ'),
(178, 1, 'FAQ'),
(179, 1, 'FAQ'),
(180, 1, '\n<h2>How can I upload a primary photo</h2>\n<p>Go to Account then click on Avatar.\nYou will be able to select an Avatar as your primary photo or you can upload a photo from your computer.\nIf the Photos module is installed, from the View photo page you can set a photo as your Default Avatar.</p>\n\n<h2>How can I edit my profile?</h2>\n<p>Go to Account then click Edit Profile.\nYou will be able to edit your profile details such as Headline, Description, Gender etc.\n</p>\n\n<h2>How can I send a private message to a user?</h2>\n<p>There are 2 ways you can send a private message to a user\n1) Click on the Mail icon in member menu and select Compose.\nIn the Recipient field, type in the username of the user you want to send a message to.\nIf the username exists, it will populate as you''re typing in the Username.\nThis will help to ensure you type in the correct username.\n2) From the users profile you can click Send Letter.</p>\n\n<h2>Can I view messages I have sent?</h2>\n<p>Click on the Mail icon in member menu and click Outbox.\nThis will take you to your Outbox which contains Messages and Greetings you have sent.\nYou can have just messages display or just Greetings by placing a check mark beside what you want to see.\nRemoving a check mark beside Messages for example will display everything but Messages and vise versa.</p>\n\n<h2>I accidentally removed the wrong message, can I retrieve it?</h2>\n<p>Click on the Mail icon in member menu then click on Trash.\nThis will display all Messages and Greetings you deleted.\nChoose what you want to retrieve and click Restore\nThe message(s) selected will now be back in your Inbox.</p>\n\n<h2>Are my messages on here permanently unless I delete them?</h2>\n<p>To save space on our server and to ensure the site is not running what it doesn''t need to run, old messages maybe removed periodically.</p>\n\n<h2>How does Subscriptions work?</h2>\n<p>When you subscribe to another user, that user''s profile will be listed in your subscriptions page.\nThis also applies to subscribing to other users activities such as blogs etc.</p>\n\n<h2>A member keeps harassing me, what can I do?</h2>\n<p>If a member of the site is harassing you, Ignore or block that user.\nIf the problem progresses you should contact the site administrator.</p>\n\n<h2>Why was my account terminated?</h2>\n<p>We strictly enforce our Terms Of Service and make every effort possible to make sure all users are following them.\nYour account may have been terminated due to a breach in the Terms Of Service (aka TOS).\nIf you felt that your account was terminated for no probable reason, we ask that you contact the site administrator.</p>\n\n<h2>Why does my profile status say Approval?</h2>\n<p>The administrator may have chosen to have profiles approved first before joining the site.</p>\n\n<h2>Why can''t I log in to my account?</h2>\n<p>Chances are you may have misspelled your password or had your CAPS LOCK on while typing your password.\nTry typing your password with CAPS LOCK off.\nIf this fails, you can request a password that will be sent to the email address you provided when you registered.</p>\n\n'),
(181, 1, 'Forgot your ID and/or password? Please, write your e-mail address below and we will send you a new password.'),
(182, 1, 'You have already requested this member''s contact information for free. You can see it in <a href="profile.php?ID={0}">their profile</a>, or in <a href="communicator.php">your Connections</a>.'),
(183, 1, 'Sorry, contact information could not be sent to you. This member has blocked you.'),
(184, 1, 'Sorry, contact information could not be sent to you at this time. Make sure that you are logged in and  your profile is in active mode.'),
(185, 1, 'Get contact information for free!'),
(186, 1, 'Sorry, this member''s contact information cannot be received for free. You must purchase it.'),
(187, 1, 'You haven''t received greetings from this member.'),
(188, 1, 'You have just been sent an e-mail with {0}''s contact information.'),
(189, 1, 'Failed to apply changes'),
(190, 1, 'Fave'),
(191, 1, 'Unfave'),
(192, 1, 'Faves'),
(193, 1, 'Feature it'),
(194, 1, 'Featured'),
(195, 1, 'February'),
(196, 1, 'Woman'),
(197, 1, 'Admin Controls'),
(198, 1, 'Registration Date'),
(199, 1, 'General Info'),
(200, 1, 'Misc'),
(201, 1, 'Gender'),
(202, 1, 'Admin Controls'),
(203, 1, 'Admin Controls'),
(204, 1, 'Age'),
(205, 1, 'Captcha'),
(206, 1, 'City'),
(207, 1, 'City'),
(208, 1, 'City'),
(209, 1, 'City'),
(210, 1, 'Country'),
(211, 1, 'Country'),
(212, 1, 'Country'),
(213, 1, 'Country'),
(214, 1, 'Profile type'),
(215, 1, 'Profile type'),
(216, 1, 'Last profile edition date'),
(217, 1, 'Last Login Date'),
(218, 1, 'Last Navigation Date'),
(219, 1, 'Birthday'),
(220, 1, 'Birthday'),
(221, 1, 'Age'),
(222, 1, 'Birthday'),
(223, 1, 'Description'),
(224, 1, 'Description'),
(225, 1, 'Description'),
(226, 1, 'Description'),
(227, 1, 'Description'),
(228, 1, 'Education'),
(229, 1, 'Education'),
(230, 1, 'Receive site notifications'),
(231, 1, 'Receive site notifications'),
(232, 1, 'Email'),
(233, 1, 'Email'),
(234, 1, 'Email'),
(235, 1, 'Ethnicity'),
(236, 1, 'Ethnicity'),
(237, 1, 'Favorite Books'),
(238, 1, 'Favorite Books'),
(239, 1, 'Favorite Films'),
(240, 1, 'Favorite Films'),
(241, 1, 'Favorite Music'),
(242, 1, 'Favorite Music'),
(243, 1, 'Favorite Sites'),
(244, 1, 'Favorite Sites'),
(245, 1, 'Featured'),
(246, 1, 'General Info'),
(247, 1, 'General Info'),
(248, 1, 'Specific'),
(249, 1, 'Headline'),
(250, 1, 'Headline'),
(251, 1, 'Headline'),
(252, 1, 'Height'),
(253, 1, 'Height'),
(254, 1, 'Hobbies'),
(255, 1, 'Hobbies'),
(256, 1, 'Member ID'),
(257, 1, 'Member ID'),
(258, 1, 'Income'),
(259, 1, 'Income'),
(260, 1, 'Interests'),
(261, 1, 'Interests'),
(262, 1, 'Keyword'),
(263, 1, 'First Name'),
(264, 1, 'First  Name'),
(265, 1, 'First Name'),
(266, 1, 'Full Name'),
(267, 1, 'Full Name'),
(268, 1, 'Full Name'),
(269, 1, 'Last Name'),
(270, 1, 'Last Name'),
(271, 1, 'Last Name'),
(272, 1, 'Location'),
(273, 1, 'Looking For'),
(274, 1, 'Looking for'),
(275, 1, 'I am a'),
(276, 1, 'Looking For'),
(277, 1, 'Membership level'),
(278, 1, 'Additional Info'),
(279, 1, 'Additional Info'),
(280, 1, 'Options'),
(281, 1, 'Additional Info'),
(282, 1, 'Username'),
(283, 1, 'Username'),
(284, 1, 'Username'),
(285, 1, 'Username'),
(286, 1, 'Occupation'),
(287, 1, 'Occupation'),
(288, 1, 'Change Password'),
(289, 1, 'Password'),
(290, 1, 'Profile type'),
(291, 1, 'Profile Picture'),
(292, 1, 'Relationship Status'),
(293, 1, 'Relationship Status'),
(294, 1, 'Religion'),
(295, 1, 'Religion'),
(296, 1, 'Religion'),
(297, 1, 'Gender'),
(298, 1, 'Looking for'),
(299, 1, 'Gender'),
(300, 1, 'Status'),
(301, 1, 'Status'),
(302, 1, 'Tags'),
(303, 1, 'Tags'),
(304, 1, 'Tag'),
(305, 1, 'Tags'),
(306, 1, 'I have read and agreed with <a href="terms_of_use.php" target="_blank">Terms of Use</a> and <a href="privacy.php" target="_blank">Privacy Policy</a>.'),
(307, 1, 'weight'),
(308, 1, 'Weight'),
(309, 1, 'Profile privacy'),
(310, 1, 'Post code (Zip)'),
(311, 1, 'Post code (Zip)'),
(312, 1, 'Please specify your gender'),
(313, 1, 'Let us check that you are not a robot. Just enter the text you see on the picture.'),
(314, 1, 'Specify the city where you live '),
(315, 1, 'Select the country where you live '),
(316, 1, 'Select "Couple" if you are joining as a couple'),
(317, 1, 'Last profile edit'),
(318, 1, 'Last log in'),
(319, 1, 'Please specify your birth date: Year-Month-Day'),
(320, 1, 'Describe yourself in a few words. Your description should be at least {0} characters long.'),
(321, 1, 'Your education'),
(322, 1, 'Enter your Email. Your password will be sent to this email.'),
(323, 1, 'Your ethnicity'),
(324, 1, 'Your favorite books'),
(325, 1, 'Your favorite films'),
(326, 1, 'Your favorite music'),
(327, 1, 'Your favorite sites'),
(328, 1, 'Show this member in "Featured" block of index page'),
(329, 1, 'Enter your life headline'),
(330, 1, 'Your height'),
(331, 1, 'Your hobbies'),
(332, 1, 'ID'),
(333, 1, 'Your income'),
(334, 1, 'Your Interests'),
(335, 1, 'Enter your first name'),
(336, 1, 'Enter your full name'),
(337, 1, 'Enter your last name'),
(338, 1, 'Please specify whom you are looking for'),
(339, 1, 'Member membership level'),
(340, 1, 'Choose a Username which will be used for logging in to the site'),
(341, 1, 'Your occupation'),
(342, 1, 'To save old password, just leave this field empty. To change, enter new password and confirm it below.'),
(343, 1, 'Choose a password.'),
(344, 1, 'Your relationship status'),
(345, 1, 'Your religion'),
(346, 1, 'Your religion'),
(347, 1, 'System user status'),
(348, 1, 'Enter a few words separated by commas that describe your character'),
(349, 1, 'Your weight'),
(350, 1, 'Enter your Post code (Zip)'),
(351, 1, 'Enter your Post code (Zip)'),
(352, 1, 'You must specify your city'),
(353, 1, 'Please, enter {0} character(s) or less'),
(354, 1, 'Please, enter {0} character(s) or more'),
(355, 1, 'You must specify your country'),
(356, 1, 'You must specify your birth date'),
(357, 1, 'You cannot join the site if you are older than {0} years'),
(358, 1, 'You cannot join the site if you are younger than {0} years'),
(359, 1, 'You must enter your description'),
(360, 1, 'Your description should be at least 20 letters long'),
(361, 1, 'Please enter correct e-mail'),
(362, 1, 'E-mail address is required'),
(363, 1, 'Your email is too short'),
(364, 1, 'Account with this email already exists.'),
(365, 1, 'You must specify your headline'),
(366, 1, 'Please, enter {0} character(s) or less'),
(367, 1, 'Please, enter {0} character(s) or more'),
(368, 1, 'Enter your first name'),
(369, 1, 'Please, enter {0} character(s) or less'),
(370, 1, 'Please, enter {0} character(s) or more'),
(371, 1, 'Enter your full name'),
(372, 1, 'Please, enter {0} character(s) or less'),
(373, 1, 'Please, enter {0} character(s) or more'),
(374, 1, 'Enter your last name'),
(375, 1, 'Please, enter {0} character(s) or less'),
(376, 1, 'Please, enter {0} character(s) or more'),
(377, 1, 'Your Username must contain only latin symbols, numbers or underscore ( _ ) or minus ( - ) signs'),
(378, 1, 'You must enter Username'),
(379, 1, 'Your Username should be no longer than {0} characters long'),
(380, 1, 'Your Username must be at least {0} characters long'),
(381, 1, 'This Username is already in use by another member. Please select another Username.'),
(382, 1, 'Password is required'),
(383, 1, 'Your password should be no longer than {0} characters'),
(384, 1, 'Your password must be at least {0} characters long'),
(385, 1, 'Please, specify your gender'),
(386, 1, 'Please, specify your ZIP code'),
(387, 1, 'Please, enter {0} character(s) or less'),
(388, 1, 'Please, enter {0} character(s) or more'),
(389, 1, 'Active'),
(390, 1, 'Approval'),
(391, 1, 'Engaged'),
(392, 1, 'In a Relationship'),
(393, 1, 'In an Open Relationship'),
(394, 1, 'It''s Complicated'),
(395, 1, 'Married'),
(396, 1, 'Rejected'),
(397, 1, 'Single'),
(398, 1, 'Suspended'),
(399, 1, 'Unconfirmed'),
(400, 1, 'File info was sent'),
(401, 1, 'First'),
(402, 1, 'First Person'),
(403, 1, 'First page'),
(404, 1, 'First value must be bigger'),
(405, 1, 'Forgot Password?'),
(406, 1, 'Friend Requests'),
(407, 1, 'Friend email'),
(408, 1, 'Friend list'),
(409, 1, 'Friend was removed'),
(410, 1, 'Friend Request'),
(411, 1, 'Friends'),
(412, 1, 'Friends of {0}'),
(413, 1, 'From'),
(414, 1, 'Get E-mail'),
(415, 1, 'Go to admin panel'),
(416, 1, 'Greeting'),
(417, 1, 'Greetings'),
(418, 1, 'Guest'),
(419, 1, '\n<p>"If you can dream it, then you can achieve it. You will get all you want in life if you help enough other people get what they want."</p>\n<p class="bx-def-font-grayed"><i>Zig Ziglar</i></p>'),
(420, 1, 'Help'),
(421, 1, 'Help'),
(422, 1, 'HTML Block'),
(423, 1, 'Header'),
(424, 1, 'Hello, <b>{0}</b>!'),
(425, 1, 'Hide'),
(426, 1, '{0} replies'),
(427, 1, 'Home'),
(428, 1, 'I am'),
(429, 1, 'E-Mail or ID'),
(430, 1, 'Sorry, invalid password! Please try again.'),
(431, 1, 'Access denied'),
(432, 1, 'In'),
(433, 1, 'Inbox'),
(434, 1, 'Incorrect Security Image Entry'),
(435, 1, 'Incorrect Email'),
(436, 1, 'Info'),
(437, 1, 'Intersex'),
(438, 1, 'Invite a Friend'),
(439, 1, 'January'),
(440, 1, 'Join'),
(441, 1, 'Join'),
(442, 1, 'Joining process has been completed.'),
(443, 1, 'Join failed'),
(444, 1, 'Join Now'),
(445, 1, 'July'),
(446, 1, 'June'),
(447, 1, 'Keyword'),
(448, 1, 'Keyword Search'),
(449, 1, 'Your login information has expired, please re-login.'),
(450, 1, 'Sorry, you need to login before you can use this page.'),
(451, 1, 'If you are not registered at {2} you can join right now.<br />'),
(452, 1, 'Language'),
(453, 1, 'Last'),
(454, 1, 'Last login'),
(455, 1, 'Last page'),
(456, 1, 'latest'),
(457, 1, 'Latest activity'),
(458, 1, 'Location'),
(459, 1, 'Log in'),
(460, 1, 'Logout'),
(461, 1, 'Login'),
(462, 1, 'Woman'),
(463, 1, 'Intersex'),
(464, 1, 'Man'),
(465, 1, 'expires {0}'),
(466, 1, 'expires never'),
(467, 1, '<a href="{0}">Upgrade Options</a>'),
(468, 1, 'Friend requests'),
(469, 1, 'Members you have blocked'),
(470, 1, 'Members who blocked you'),
(471, 1, 'Members you have hotlisted'),
(472, 1, 'Members who hotlisted you'),
(473, 1, 'Members who invited you'),
(474, 1, 'Members you have greeted'),
(475, 1, 'Members who greeted you'),
(476, 1, 'Sorry, we could not recognize you. Please, make sure that you entered the e-mail address used when creating your account.'),
(477, 1, 'You have been recognized as a {0} member, but it was impossible to send you an e-mail with your account details right now. Please, try again later.'),
(478, 1, 'You have been recognized as a {1} member and your account details have just been sent to you. Once you receive the letter from us, <a href="{0}member.php">log-in here</a>.'),
(479, 1, 'Message has been successfully sent. <a href="{0}">Send</a> another message or <a href="{1}">view</a> {2}''s profile.'),
(480, 1, 'Mail'),
(481, 1, 'Mail box'),
(482, 1, 'Mailbox'),
(483, 1, 'Please enter the description'),
(484, 1, 'Please enter the recipient''s nickname'),
(485, 1, 'Please enter the title'),
(486, 1, 'Main'),
(487, 1, 'Man'),
(488, 1, 'Map'),
(489, 1, 'March'),
(490, 1, 'Mark as Unread'),
(491, 1, 'Mark as Read'),
(492, 1, 'Match'),
(493, 1, 'May'),
(494, 1, 'Member'),
(495, 1, 'Friends'),
(496, 1, 'Mutual Friends'),
(497, 1, 'Friend Requests'),
(498, 1, 'Member Profile'),
(499, 1, 'Member menu position'),
(500, 1, 'Login'),
(501, 1, 'Members'),
(502, 1, 'Pending Members'),
(503, 1, 'Membership'),
(504, 1, 'Current'),
(505, 1, 'Duration'),
(506, 1, 'in days (leave empty for lifetime)'),
(507, 1, 'Name'),
(508, 1, 'You need to select a membership level'),
(509, 1, 'Save'),
(510, 1, 'Cannot update membership level. Please report.'),
(511, 1, 'Membership level was updated successfully.'),
(512, 1, 'Starts<br />immediately'),
(513, 1, 'Message'),
(514, 1, 'Message text'),
(515, 1, 'Messages'),
(516, 1, 'More actions'),
(517, 1, 'Mutual Friends'),
(518, 1, 'My Account'),
(519, 1, 'My Email'),
(520, 1, 'My Friends'),
(521, 1, 'My Contacts'),
(522, 1, '<span>{0}</span> point'),
(523, 1, '<span>{0}</span> points'),
(524, 1, '{0} time(s)'),
(525, 1, 'There is no need to confirm your account e-mail because it''s already confirmed.'),
(526, 1, 'Name'),
(527, 1, 'Name is required'),
(528, 1, 'New Post'),
(529, 1, 'News'),
(530, 1, 'Next'),
(531, 1, 'Next'),
(532, 1, 'Next page'),
(533, 1, 'Username'),
(534, 1, 'No'),
(535, 1, 'No member specified'),
(536, 1, 'No such comment'),
(537, 1, 'None'),
(538, 1, 'Notify {0} by e-mail'),
(539, 1, 'November'),
(540, 1, 'Now Online'),
(541, 1, 'Our services'),
(542, 1, 'October'),
(543, 1, 'Offline'),
(544, 1, 'OK'),
(545, 1, 'Online'),
(546, 1, 'Online Friends'),
(547, 1, 'Open'),
(548, 1, 'Order by:'),
(549, 1, 'Outbox'),
(550, 1, 'Overview'),
(551, 1, '\nThis Privacy Policy governs the manner in which {0} collects, uses, maintains and discloses information collected from users (each, a "User") of the <a href="{1}">{1}</a> website ("Site"). This privacy policy applies to the Site and all products and services offered by {0}.<br><br>\n\n<b>Personal identification information</b><br><br>\n\nWe may collect personal identification information from Users in a variety of ways, including, but not limited to, when Users visit our site, register on the site, subscribe to the newsletter, and in connection with other activities, services, features or resources we make available on our Site. Users may be asked for, as appropriate, name, email address, mailing address. Users may, however, visit our Site anonymously. We will collect personal identification information from Users only if they voluntarily submit such information to us. Users can always refuse to supply personally identification information, except that it may prevent them from engaging in certain Site related activities.<br><br>\n\n<b>Non-personal identification information</b><br><br>\n\nWe may collect non-personal identification information about Users whenever they interact with our Site. Non-personal identification information may include the browser name, the type of computer and technical information about Users means of connection to our Site, such as the operating system and the Internet service providers utilized and other similar information.<br><br>\n\n<b>Web browser cookies</b><br><br>\n\nOur Site may use "cookies" to enhance User experience. User''s web browser places cookies on their hard drive for record-keeping purposes and sometimes to track information about them. User may choose to set their web browser to refuse cookies, or to alert you when cookies are being sent. If they do so, note that some parts of the Site may not function properly.<br><br>\n\n<b>How we use collected information</b><br><br>\n\n{0} may collect and use Users personal information for the following purposes:<br>\n<ul>\n<li><i>- To personalize user experience</i><br>\n    We may use information in the aggregate to understand how our Users as a group use the services and resources provided on our Site.</li>\n<li><i>- To send periodic emails</i><br>\nWe may use the email address to respond to their inquiries, questions, and/or other requests. If User decides to opt-in to our mailing list, they will receive emails that may include company news, updates, related product or service information, etc. If at any time the User would like to unsubscribe from receiving future emails, we include detailed unsubscribe instructions at the bottom of each email or User may contact us via our Site.</li>\n</ul>\n<b>How we protect your information</b><br><br>\n\nWe adopt appropriate data collection, storage and processing practices and security measures to protect against unauthorized access, alteration, disclosure or destruction of your personal information, username, password, transaction information and data stored on our Site.<br><br>\n\n<b>Sharing your personal information</b><br><br>\n\nWe do not sell, trade, or rent Users personal identification information to others. We may share generic aggregated demographic information not linked to any personal identification information regarding visitors and users with our business partners, trusted affiliates and advertisers for the purposes outlined above.<br><br>\n\n<b>Changes to this privacy policy</b><br><br>\n\n{0} has the discretion to update this privacy policy at any time. When we do, we will revise the updated date at the bottom of this page. We encourage Users to frequently check this page for any changes to stay informed about how we are helping to protect the personal information we collect. You acknowledge and agree that it is your responsibility to review this privacy policy periodically and become aware of modifications.<br><br>\n\n<b>Your acceptance of these terms</b><br><br>\n\nBy using this Site, you signify your acceptance of this policy and <a href="{1}terms_of_use.php">terms of service</a>. If you do not agree to this policy, please do not use our Site. Your continued use of the Site following the posting of changes to this policy will be deemed your acceptance of those changes.<br><br>\n\n<b>Contacting us</b><br><br>\n\nIf you have any questions about this Privacy Policy, the practices of this site, or your dealings with this site, please <a href="{1}contact.php">contact us</a>.\n\n<div class="bx-def-font-small bx-def-font-grayed bx-def-margin-sec-top">Privacy policy created by <a href="http://www.privacypolicies.com" target="_blank">Generate Privacy Policy</a></div>\n  '),
(552, 1, 'Privacy Policy'),
(553, 1, 'Privacy policy'),
(554, 1, 'You can not change your account status.'),
(555, 1, 'You can activate your account to make it visible again.'),
(556, 1, 'You can suspend your account, making it temporarily invisible. You can reactivate it later.'),
(557, 1, 'Congratulations! Your e-mail confirmation succeeded and your profile has been activated.<br />'),
(558, 1, 'Error!\r\nYour username or password was incorrect. Please try again.'),
(559, 1, 'Profile is not available.'),
(560, 1, 'Page'),
(561, 1, 'Page URI'),
(562, 1, 'Page title'),
(563, 1, 'Password'),
(564, 1, 'Password confirmation failed'),
(565, 1, 'Member password retrieval at {0}'),
(566, 1, 'People'),
(567, 1, 'Calendar'),
(568, 1, 'People Search'),
(569, 1, 'Period (hours)'),
(570, 1, 'Phone'),
(571, 1, 'Picture'),
(572, 1, 'Please Wait'),
(573, 1, 'Please enter 3-2048 characters'),
(574, 1, 'Please specify image file'),
(575, 1, 'Please, select at least one message'),
(576, 1, 'Please Select...'),
(577, 1, 'Popular'),
(578, 1, 'Post'),
(579, 1, 'Presence'),
(580, 1, 'Preview'),
(581, 1, 'Previous'),
(582, 1, 'Previous page'),
(583, 1, 'Privacy'),
(584, 1, 'Profile'),
(585, 1, 'Profile not available for view'),
(586, 1, 'Profile has not been found'),
(587, 1, 'Specified profile not found in the database. It must have been removed earlier.'),
(588, 1, 'Profile activation failed.'),
(589, 1, 'Profile information'),
(590, 1, 'Profile not found'),
(591, 1, 'Profile not specified'),
(592, 1, 'Profile status'),
(593, 1, 'Profile Photos'),
(594, 1, 'Profiles'),
(595, 1, 'Quick Links'),
(596, 1, 'Quick Search'),
(597, 1, 'You are recognized as a {0} member'),
(598, 1, 'Transaction verification failed.'),
(599, 1, 'We think that what you''ve done is bad.'),
(600, 1, 'Security breach suspected'),
(601, 1, '<b>The transaction could not proceed.</b> Make sure you have entered your credit card information correctly and try again.'),
(602, 1, 'Order failed'),
(603, 1, 'You do not have enough credits'),
(604, 1, 'The e-mail with contact information has been just sent to you.'),
(605, 1, 'Purchase success'),
(606, 1, 'Thank you! We appreciate your purchase. You should receive an email at {1}'),
(607, 1, 'You have successfully made a purchase, however the e-mail with contact information could not be sent to you right now. Your purchase has been recorded and you can see all the information in <a href="communicator.php">your Connections</a>.'),
(608, 1, 'RSS'),
(609, 1, 'RSS Feed'),
(610, 1, '{0} RSS'),
(611, 1, '{0}''s Recent {1}'),
(612, 1, 'random'),
(613, 1, 'Rate'),
(614, 1, 'Read'),
(615, 1, 'Read more'),
(616, 1, 'Recipient'),
(617, 1, 'Recognized'),
(618, 1, 'Record a video comment'),
(619, 1, 'Refresh'),
(620, 1, 'Registration'),
(621, 1, 'Remember Me'),
(622, 1, 'Remove'),
(623, 1, 'Unfriend'),
(624, 1, 'Reply'),
(625, 1, 'Reply'),
(626, 1, 'Record a video reply'),
(627, 1, 'Reply'),
(628, 1, 'Report'),
(629, 1, 'Report Spam'),
(630, 1, 'Spam report could not be sent'),
(631, 1, 'Spam report was sent'),
(632, 1, 'Repost'),
(633, 1, 'Reset'),
(634, 1, 'Restore'),
(635, 1, 'Results'),
(636, 1, 'Per page:'),
(637, 1, 'Retrieve my information'),
(638, 1, 'Search Result'),
(639, 1, 'send message'),
(640, 1, 'Recipient:'),
(641, 1, 'Your services description here'),
(642, 1, 'Subscribe now for {0} newsletter to receive news, updates, photos of top rated members, feedback and tips to your e-mail.'),
(643, 1, 'Save'),
(644, 1, 'Save Changes'),
(645, 1, 'The profile was successfully saved'),
(646, 1, 'Saved'),
(647, 1, 'Search'),
(648, 1, 'Search...'),
(649, 1, 'Search people'),
(650, 1, 'Search result'),
(651, 1, 'Search Home'),
(652, 1, 'Second Person'),
(653, 1, 'Section'),
(654, 1, 'Select'),
(655, 1, 'Select all'),
(656, 1, 'Select file'),
(657, 1, 'Select all'),
(658, 1, 'Selectively'),
(659, 1, 'Send'),
(660, 1, 'Send Letter'),
(661, 1, 'Send Message'),
(662, 1, 'Send copy to my personal email'),
(663, 1, 'Send copy to {0} personal email'),
(664, 1, 'Send a greeting'),
(665, 1, 'Contact'),
(666, 1, 'Sent'),
(667, 1, 'Sent you a'),
(668, 1, 'September'),
(669, 1, 'Settings'),
(670, 1, 'Share'),
(671, 1, 'Show'),
(672, 1, '{0} replies'),
(673, 1, 'Simple'),
(674, 1, 'Single'),
(675, 1, 'Site Stats'),
(676, 1, 'Sorry, your IP has been banned'),
(677, 1, 'Report Spam'),
(678, 1, 'Start date'),
(679, 1, 'Static'),
(680, 1, 'Status'),
(681, 1, 'Status Message'),
(682, 1, 'SubCategory is required'),
(683, 1, 'Subject'),
(684, 1, 'Submit'),
(685, 1, 'Post'),
(686, 1, 'Subscribe'),
(687, 1, 'Newsletter'),
(688, 1, 'Subscribers'),
(689, 1, 'Success'),
(690, 1, 'Suspend account'),
(691, 1, 'Suspended'),
(692, 1, 'Invite a friend to {0}'),
(693, 1, 'Invite a friend to view the profile'),
(694, 1, '\n<p><b>1 &nbsp;Acceptance The Use Of {0} Terms and Conditions</b></p>\n<p>Your  access  to  and  use  of  {0} is  subject exclusively to these Terms and Conditions. You will not use the Website for any purpose that is unlawful or prohibited by these Terms and Conditions. By using  the  Website  you  are  fully  accepting  the  terms,  conditions  and disclaimers contained in this notice. If you do not accept these Terms and Conditions you must immediately stop using the Website.</p>\n\n<p><b>2 &nbsp;Credit card details</b></p>\n<p>{0} will never ask for Credit Card details and request that you do not enter it on any of the forms on {0}.</p>\n\n<p><b>3 &nbsp;Advice</b></p>\n<p>The contents of {0} website do not constitute advice and should not be relied upon in making or refraining from making, any decision.</p>\n\n<p><b>4 &nbsp;Change of Use</b></p>\n<p>{0} reserves the right to:<br /> 4.1 &nbsp;change or remove (temporarily or permanently) the Website or any part of it without notice and you confirm that {0} shall not be liable to you for any such change or removal and.<br /> 4.2 &nbsp;change these Terms and Conditions at any time, and your continued use of the Website following any changes shall be deemed to be your acceptance of such change.</p>\n\n<p><b>5 &nbsp;Links to Third Party Websites</b></p>\n<p>{0} Website may include links to third party websites that are controlled and maintained by others. Any link to other websites is not an endorsement of such websites and you acknowledge and agree that we are not responsible for the content or availability of any such sites.</p>\n\n<p><b>6 &nbsp;Copyright </b></p>\n<p>6.1 &nbsp;All  copyright,  trade  marks  and  all  other  intellectual  property  rights  in  the Website and its content (including without limitation the Website design, text, graphics and all software and source codes connected with the Website) are owned by or   licensed to {0} or otherwise used by {0} as permitted by law.<br /> 6.2 &nbsp;In accessing the Website you agree that you will access the content solely for your personal, non-commercial use. None of the content may be downloaded, copied, reproduced, transmitted, stored, sold or distributed without the prior written consent of the copyright holder. This excludes the downloading, copying and/or printing of pages of the Website for personal, non-commercial home use only.</p>\n\n<p><b>7 &nbsp;Disclaimers and Limitation of Liability </b></p>\n<p>7.1 &nbsp;The Website is provided on an AS IS and AS AVAILABLE basis without any representation or endorsement made and without warranty of any kind whether express or implied, including but not limited to the implied warranties of satisfactory quality, fitness for a particular purpose, non-infringement, compatibility, security and accuracy.<br /> 7.2 &nbsp;To the extent permitted by law, {0} will not be liable for any indirect or consequential loss or damage whatever (including without limitation loss of business, opportunity, data, profits) arising out of or in connection with the use of the Website.<br /> 7.3 &nbsp;{0} makes no warranty that the functionality of the Website will be uninterrupted or error free, that defects will be corrected or that the Website or the server that makes it available are free of viruses or anything else which may be harmful or destructive.<br /> 7.4 &nbsp;Nothing in these Terms and Conditions shall be construed so as to exclude or limit the liability of {0} for death or personal injury as a result of the negligence of {0} or that of its employees or agents.</p>\n\n<p><b>8 &nbsp;Indemnity</b></p>\n<p>You agree to indemnify and hold {0} and its employees and agents harmless from and against all liabilities, legal fees, damages, losses, costs and other expenses in relation to any claims or actions brought against {0} arising out of any breach by you of these Terms and Conditions or other liabilities arising out of your use of this Website.</p>\n\n<p><b>9 &nbsp;Severance</b></p>\n<p>If any of these Terms and Conditions should be determined to be invalid, illegal or unenforceable for any reason by any court of competent jurisdiction then such Term or Condition shall be severed and the remaining Terms and Conditions shall survive and remain in full force and effect and continue to be binding and enforceable.</p>\n\n<p><b>10 &nbsp;Governing Law</b></p>\n<p>These Terms and Conditions shall be governed by and construed in accordance with the law and you hereby submit to the exclusive jurisdiction of the courts.</p>\n\nFor any further information please <a href="{1}contact.php">contact us</a>\n'),
(695, 1, 'Terms of use'),
(696, 1, 'Terms'),
(697, 1, 'Tag'),
(698, 1, 'Tags'),
(699, 1, 'Enter a few words delimited by commas or semicolon'),
(700, 1, 'Invite a friend'),
(701, 1, 'Template'),
(702, 1, 'Terms'),
(703, 1, 'Text'),
(704, 1, 'Text Block'),
(705, 1, 'There are no comments yet'),
(706, 1, 'Thumbs Down'),
(707, 1, 'Thumbs Up'),
(708, 1, 'Times allowed'),
(709, 1, 'Title'),
(710, 1, 'to'),
(711, 1, 'Top'),
(712, 1, 'Top Rated'),
(713, 1, 'Trash'),
(714, 1, 'Type'),
(715, 1, 'URL'),
(716, 1, 'Congratulations!<br /><br />Your account has been successfully confirmed and activated.'),
(717, 1, 'Congratulations! Your account has been successfully confirmed.<br /><br />Your profile has been successfully created, but it is awaiting review. Thank you for your patience.'),
(718, 1, 'Unconfirmed'),
(719, 1, 'Unblock'),
(720, 1, 'Unread'),
(721, 1, 'Unregister'),
(722, 1, 'User was added to block list'),
(723, 1, 'User was added to favourites'),
(724, 1, 'User was removed from favourites'),
(725, 1, 'User was added to friend list'),
(726, 1, 'User was invited to friend list'),
(727, 1, 'User was removed from block list'),
(728, 1, 'Allowed Actions'),
(729, 1, 'Sorry, a greeting has <b>not</b> been sent.'),
(730, 1, 'Profile authentication failed'),
(731, 1, 'Member not available'),
(732, 1, 'Email send failed. Please, try later.'),
(733, 1, 'Sorry, max number of greetings per day reached'),
(734, 1, 'Sorry, you have been blocked by this member'),
(735, 1, 'Greeting has been successfully sent.'),
(736, 1, 'Vacant'),
(737, 1, 'View'),
(738, 1, 'View All'),
(739, 1, 'View friends'),
(740, 1, 'Views'),
(741, 1, 'Visitor'),
(742, 1, 'Why join'),
(743, 1, 'with photos only'),
(744, 1, 'With status'),
(745, 1, 'World Map'),
(746, 1, '{0}% match'),
(747, 1, 'Your profile is not active for this operation.'),
(748, 1, 'Yes'),
(749, 1, 'You are'),
(750, 1, 'You cannot edit this profile'),
(751, 1, 'You have been blocked by this profile'),
(752, 1, 'You have to wait for {0} minute(s) before you can write another message! <a href="{1}">[Click here]</a> to send another message.'),
(753, 1, 'You must agree with terms of use'),
(754, 1, 'You need to select the mood'),
(755, 1, 'Your email'),
(756, 1, 'Your name'),
(757, 1, 'add'),
(758, 1, 'add other'),
(759, 1, 'Audit'),
(760, 1, 'The following files and directories have inappropriate permissions'),
(761, 1, 'Current level'),
(762, 1, 'Desired level'),
(763, 1, 'Directories'),
(764, 1, 'Elements'),
(765, 1, 'Executable'),
(766, 1, 'Files'),
(767, 1, 'Flash'),
(768, 1, 'Modules Directories'),
(769, 1, 'Modules Files'),
(770, 1, 'Non-Executable'),
(771, 1, 'Non-Writable'),
(772, 1, 'Does Not Exists'),
(773, 1, 'Show only files and directories with inappropriate permissions'),
(774, 1, 'Dolphin needs special access for certain files and directories. Please, change permissions as specified in the chart below. Helpful info about permissions is <a href="https://www.boonex.com/trac/dolphin/wiki/DetailedInstall#InstallScript-Step1-Permissions" target="_blank">available here</a>.'),
(775, 1, 'Permissions'),
(776, 1, 'Writable'),
(777, 1, 'Cache Engines'),
(778, 1, 'PHP Info'),
(779, 1, 'Admin Tools'),
(780, 1, 'Big Icon'),
(781, 1, 'Check'),
(782, 1, 'Some specific check (PHP-expression). For example, for checking Email, etc. Attention! Do not put here min/max/unique checks. They are defined above.'),
(783, 1, 'Icon'),
(784, 1, 'Small Icon'),
(785, 1, 'Admin Menu Builder'),
(786, 1, 'Admin Tools'),
(787, 1, 'Bottom'),
(788, 1, 'HShift'),
(789, 1, 'Insert as new'),
(790, 1, 'Left'),
(791, 1, 'Position on the page'),
(792, 1, 'Right'),
(793, 1, 'Top'),
(794, 1, 'VShift'),
(795, 1, 'clicks'),
(796, 1, 'Banner Clicks'),
(797, 1, 'impressions'),
(798, 1, 'Manage banners'),
(799, 1, 'Bottom Menu Builder'),
(800, 1, 'Bottom Menu Builder'),
(801, 1, 'Admin Password'),
(802, 1, 'Available Updates'),
(803, 1, 'BoonEx News Feed'),
(804, 1, 'Growth Charts'),
(805, 1, 'Content'),
(806, 1, 'Design templates from Unity Market'),
(807, 1, 'Email Templates'),
(808, 1, 'Initiall Steps'),
(809, 1, 'Flash Apps'),
(810, 1, 'Featured Modules'),
(811, 1, 'Injections'),
(812, 1, 'Installed Modules'),
(813, 1, 'Languages'),
(814, 1, 'Edit Language'),
(815, 1, 'Language files from Unity Market'),
(816, 1, 'Key'),
(817, 1, 'Current License'),
(818, 1, 'Quick Links'),
(819, 1, 'Logo'),
(820, 1, 'Manage Action'),
(821, 1, 'Actions of ''{0}'' membership level'),
(822, 1, 'Memberships'),
(823, 1, 'Pricing for ''{0}'' membership level'),
(824, 1, 'Overview'),
(825, 1, 'Members'),
(826, 1, 'Not Installed Modules'),
(827, 1, 'Operation Results'),
(828, 1, 'Privacy Settings'),
(829, 1, 'Predefined Values'),
(830, 1, 'Advanced Settings'),
(831, 1, 'Main Settings'),
(832, 1, 'Splash'),
(833, 1, 'Upload'),
(834, 1, 'Column'),
(835, 1, 'Create page'),
(836, 1, 'Go'),
(837, 1, 'Add Column'),
(838, 1, 'Add Full Column'),
(839, 1, 'Add Page'),
(840, 1, 'Save'),
(841, 1, 'Import'),
(842, 1, 'Save'),
(843, 1, 'Login'),
(844, 1, 'Add'),
(845, 1, 'Add'),
(846, 1, 'Delete'),
(847, 1, 'Disable'),
(848, 1, 'Enable'),
(849, 1, 'Save'),
(850, 1, 'Delete'),
(851, 1, 'Install'),
(852, 1, 'Recompile language(s)'),
(853, 1, 'Uninstall'),
(854, 1, 'Check For Updates'),
(855, 1, 'Activate'),
(856, 1, 'Ban'),
(857, 1, 'Enter a number of days'),
(858, 1, 'Browse'),
(859, 1, 'Calendar'),
(860, 1, 'Confirm Email'),
(861, 1, 'Deactivate'),
(862, 1, 'Delete'),
(863, 1, 'Delete Spammer'),
(864, 1, 'Extended'),
(865, 1, 'Geeky'),
(866, 1, 'Quick Links'),
(867, 1, 'Search'),
(868, 1, 'Simple'),
(869, 1, 'Tags'),
(870, 1, 'Unban'),
(871, 1, 'Delete'),
(872, 1, 'Save'),
(873, 1, 'Save'),
(874, 1, 'Upload'),
(875, 1, 'Delete'),
(876, 1, 'from'),
(877, 1, 'to'),
(878, 1, 'Display new'),
(879, 1, 'Backup content only'),
(880, 1, 'Backup database'),
(881, 1, 'Backup structure only'),
(882, 1, 'Backup structure and content'),
(883, 1, 'Backup table'),
(884, 1, 'Choose operation'),
(885, 1, 'Choose operation and table'),
(886, 1, 'Data successfully restored'),
(887, 1, 'Data successfully restored from server'),
(888, 1, 'Database backup tools'),
(889, 1, 'Database restore'),
(890, 1, 'Database restore from your PC'),
(891, 1, 'Delete dump from server'),
(892, 1, 'Dump file successfully deleted'),
(893, 1, 'Please select correct dump file (only *.sql)'),
(894, 1, 'Please select dump file'),
(895, 1, 'Restore data from dump'),
(896, 1, 'Save to server'),
(897, 1, 'Save to your PC'),
(898, 1, 'Show on the screen'),
(899, 1, 'Tables backup tools'),
(900, 1, 'Data successfully dumped into file'),
(901, 1, 'Database tools'),
(902, 1, 'Prevent SPAM'),
(903, 1, 'Backup Site Data'),
(904, 1, 'Build Pages and Menus'),
(905, 1, 'Check Hosting Server'),
(906, 1, 'Manage Languages'),
(907, 1, 'Manage Site Members'),
(908, 1, 'Add & Manage Modules'),
(909, 1, 'Manage Templates'),
(910, 1, 'Email All Members'),
(911, 1, 'Change Site Settings'),
(912, 1, 'HTML Editor may break some code'),
(913, 1, 'Code to insert before closing HEAD tag'),
(914, 1, 'Code to insert before closing BODY tag'),
(915, 1, 'Admin'),
(916, 1, 'Advanced'),
(917, 1, 'Advanced Search'),
(918, 1, 'Field'),
(919, 1, 'Fields builder'),
(920, 1, 'Translation of the item caption on the {0} page to default language. Used key: <b>{1}</b>. Do not type HTML code here!'),
(921, 1, 'Check error message'),
(922, 1, 'Error message returned if field Check is failed. Translated to default language (for other languages - use key: _FieldError_{0}_Check). Non-mandatory if Check is not defined.'),
(923, 1, 'Default value'),
(924, 1, 'Default value set into database(!) if not set by user. Non-mandatory. For boolean fields use 0 or 1. For dates use format: YYYY-MM-DD. Please do not change it if in doubt!'),
(925, 1, 'Are you sure want to delete this item? Attention! The field will be deleted forever. This operation irreversible!'),
(926, 1, 'Translation of the item description on the {0} page to default language. Used key: <b>{1}</b>.'),
(927, 1, 'edit profile'),
(928, 1, 'The field cannot be deleted.'),
(929, 1, 'Error. Field not found'),
(930, 1, 'I don''t know this control type.'),
(931, 1, 'I don''t know this type.'),
(932, 1, 'A field with such name already exists. Please select another.'),
(933, 1, 'The name must begin with a latin letter and contain only latin letters, numbers or underscores.'),
(934, 1, 'You entered an incorrect link'),
(935, 1, 'You entered an incorrect value'),
(936, 1, 'You must enter the caption.'),
(937, 1, 'You must enter the name.'),
(938, 1, 'You must enter values'),
(939, 1, 'General'),
(940, 1, 'join form'),
(941, 1, 'Join Page'),
(942, 1, 'loading ...'),
(943, 1, 'Mandatory'),
(944, 1, 'It will display red asterisk near the field only. For real checking you need to fill in min/max values or custom check field.'),
(945, 1, 'Mandatory error message'),
(946, 1, 'Error message returned if user didn''t specify value when field is mandatory. Translated to default language (for other languages - use key: _FieldError_{0}_Mandatory). This texts is non-mandatory field is non-mandatory.'),
(947, 1, 'Match percent'),
(948, 1, 'Enter percentage that this field will match'),
(949, 1, 'Match with field'),
(950, 1, 'Select a field which will be matched with the current.<br /> <b>Note:</b> We recommend using the same field.'),
(951, 1, 'Matching'),
(952, 1, 'Maximum exceeded error message'),
(953, 1, 'Error message returned when field maximum limit exceeded. Translated to default language (for other languages - use key: _FieldError_{0}_Max). Non-mandatory if maximum limit is not defined.'),
(954, 1, 'Maximum value'),
(955, 1, 'For "text" or "password" - maximum length, for "number" - maximum number, etc. Leave it empty for no restriction.'),
(956, 1, 'Member'),
(957, 1, 'Messages'),
(958, 1, 'Minimum exceed error message'),
(959, 1, 'Error message returned when field minimum limit exceeded. Translated to default language (for other languages - use key: _FieldError_{0}_Min). Non-mandatory if minimum limit is not defined.'),
(960, 1, 'Minimum value'),
(961, 1, 'For "text" or "password" - minimum length, for "number" - minimum number, etc. Leave it empty for no restriction.'),
(962, 1, 'Multiple selector control'),
(963, 1, 'The type of form input (HTML-element).'),
(964, 1, 'Mutual couple fields'),
(965, 1, 'Select fields which will be used as mutual for both persons in a couple. Use Ctrl key to select few fields.<br /><b>Note:</b> NickName, Password, Email, Country, City, Zip and EmailNotify are mandatory mutual.'),
(966, 1, 'System name used for database. It must begin with a latin letter and contain only latin letters, numbers or underscores.'),
(967, 1, 'Non-unique error message'),
(968, 1, 'Error message returned if user entered non-unique value. Translated to default language (for other languages - use key: _FieldError_{0}_Unique). Non-mandatory if Unique is not set.'),
(969, 1, 'Owner'),
(970, 1, 'Possible values'),
(971, 1, 'List of possible values for selectors. Use new line as divider. Also it can be link to predefined list. Please do not change it if in doubt!'),
(972, 1, 'Quick Search'),
(973, 1, 'Search in fields'),
(974, 1, 'Select fields in which the Keyword will be able to search. Use Ctrl key to select few fields.'),
(975, 1, 'search profiles'),
(976, 1, 'Selector control'),
(977, 1, 'The type of form input (HTML-element).'),
(978, 1, 'Simple Search'),
(979, 1, 'Fields builder'),
(980, 1, 'Unique'),
(981, 1, 'Define if field value for member must be unique. For example, NickName or Email.'),
(982, 1, 'Used lang. key'),
(983, 1, 'For selectors with "linked" values list you can use different language keys. We recommend to not change it if you are in doubt. The default is "LKey".'),
(984, 1, 'view profile'),
(985, 1, 'Visitor'),
(986, 1, 'Warning! Field not found.'),
(987, 1, 'Warning! Item not found.'),
(988, 1, 'Expiration date'),
(989, 1, 'IP Role'),
(990, 1, 'Stored Logged Members IPs'),
(991, 1, 'Manage'),
(992, 1, 'sample'),
(993, 1, 'IP Blacklist system'),
(994, 1, 'IP List Type is 0 : disabled'),
(995, 1, 'IP List Type is 1 : All IPs allowed except listed'),
(996, 1, 'IP List Type is 2 : All IPs blocked except listed'),
(997, 1, 'This is a trial copy of Dolphin software. <a href="https://www.boonex.com/start" target="_blank">Get a license from BoonEx.</a>'),
(998, 1, 'Commercial License'),
(999, 1, '<a href="https://www.boonex.com/start"><b>Buy a license</b></a> to remove BoonEx links and trial alerts.'),
(1000, 1, 'or <a href="{0}">continue trial</a>'),
(1001, 1, 'continue trial'),
(1002, 1, 'License:'),
(1003, 1, 'Trial copy! <b><a href="https://www.boonex.com/start">Get a license</a></b> and register it:'),
(1004, 1, 'or'),
(1005, 1, 'Register'),
(1006, 1, 'Register'),
(1007, 1, 'Register a new license'),
(1008, 1, 'Trial'),
(1009, 1, 'Are you sure you want to register a new license? The old license will be deleted!'),
(1010, 1, 'All Items'),
(1011, 1, 'Could not delete the item'),
(1012, 1, 'Default Name'),
(1013, 1, 'Item ID is not specified'),
(1014, 1, 'Item is non-deletable'),
(1015, 1, 'Item is non-editable'),
(1016, 1, 'Item not found'),
(1017, 1, 'Language Key'),
(1018, 1, 'New'),
(1019, 1, 'Quick Link'),
(1020, 1, 'Same'),
(1021, 1, 'Sorry could not insert object'),
(1022, 1, 'System Name'),
(1023, 1, 'Target Window'),
(1024, 1, 'This items are non-editable'),
(1025, 1, 'Visible for'),
(1026, 1, 'Active Items'),
(1027, 1, 'All Items'),
(1028, 1, 'Edit Item'),
(1029, 1, 'Icon'),
(1030, 1, 'Inactive Items'),
(1031, 1, 'Legend'),
(1032, 1, 'Second level items(subitems)'),
(1033, 1, 'All items'),
(1034, 1, 'System items'),
(1035, 1, 'Top level items'),
(1036, 1, 'Script'),
(1037, 1, 'Menu Builder'),
(1038, 1, 'Menu Builder'),
(1039, 1, 'Age'),
(1040, 1, 'All Messages'),
(1041, 1, 'Body'),
(1042, 1, 'Cupid mail status'),
(1043, 1, 'Email message'),
(1044, 1, 'Email <b><u>{0}</u></b> was not added to queue.<br>');
INSERT INTO `sys_localization_strings` VALUES
(1045, 1, 'Empty Queue'),
(1046, 1, 'Failed to queue emails (ID: {0}).'),
(1047, 1, 'Message was deleted'),
(1048, 1, 'Message was not deleted'),
(1049, 1, 'Queue empty'),
(1050, 1, 'Queue emptying failed'),
(1051, 1, 'Queue message'),
(1052, 1, 'Queue status'),
(1053, 1, 'Send to members'),
(1054, 1, '{0} members agreed to receive newslatters'),
(1055, 1, 'Send to subscribers'),
(1056, 1, 'Sex'),
(1057, 1, 'Text email body'),
(1058, 1, '{0} emails were successfully added to queue.'),
(1059, 1, 'emails'),
(1060, 1, '{0} mails in the queue'),
(1061, 1, 'There are no emails in queue'),
(1062, 1, 'Massmailer'),
(1063, 1, 'Admin Menu'),
(1064, 1, 'Admin Password'),
(1065, 1, 'Advanced Settings'),
(1066, 1, 'Antispam Tools'),
(1067, 1, 'Banners'),
(1068, 1, 'Basic Settings'),
(1069, 1, 'Bottom Menu'),
(1070, 1, 'Builders'),
(1071, 1, 'Cache'),
(1072, 1, 'Categories Settings'),
(1073, 1, 'Dashboard'),
(1074, 1, 'Database Backup'),
(1075, 1, 'Email Templates'),
(1076, 1, 'Flash Apps'),
(1077, 1, 'Host Tools'),
(1078, 1, 'IP Blacklist'),
(1079, 1, 'Languages Settings'),
(1080, 1, 'License'),
(1081, 1, 'Add & Manage'),
(1082, 1, 'Mass Mailer'),
(1083, 1, 'Member Menu'),
(1084, 1, 'Membership Levels'),
(1085, 1, 'Mobile Pages'),
(1086, 1, 'Modules'),
(1087, 1, 'Navigation Menu'),
(1088, 1, 'Pages Builder'),
(1089, 1, 'Predefined Values'),
(1090, 1, 'Privacy Settings'),
(1091, 1, 'Profile Fields'),
(1092, 1, 'Service Menu'),
(1093, 1, 'Settings'),
(1094, 1, 'Sitemap'),
(1095, 1, 'Templates'),
(1096, 1, 'Tools'),
(1097, 1, 'Members'),
(1098, 1, 'Watermark'),
(1099, 1, 'Active Items'),
(1100, 1, 'Inactive Items'),
(1101, 1, 'Mobile Pages Builder'),
(1102, 1, 'Homepage'),
(1103, 1, 'Profile'),
(1104, 1, 'Search'),
(1105, 1, 'Dashboard'),
(1106, 1, 'Email Templates'),
(1107, 1, 'Flash Apps'),
(1108, 1, 'Language Settings'),
(1109, 1, 'License'),
(1110, 1, 'Login'),
(1111, 1, 'Members'),
(1112, 1, 'Modules'),
(1113, 1, 'Manage Subscribers'),
(1114, 1, 'Membership Levels'),
(1115, 1, 'Privacy Settings'),
(1116, 1, 'Predefined Values'),
(1117, 1, 'Settings'),
(1118, 1, 'Advanced Settings'),
(1119, 1, 'Basic Settings'),
(1120, 1, 'Add column'),
(1121, 1, 'Block'),
(1122, 1, 'Caption Lang Key'),
(1123, 1, 'Do you really want to delete this column'),
(1124, 1, 'The column containing this block should be at least {0} px wide; narrower width may result in design corruption.'),
(1125, 1, 'Create new page'),
(1126, 1, 'Design Box Layout'),
(1127, 1, 'Empty'),
(1128, 1, 'No box'),
(1129, 1, 'Box (title, padding)'),
(1130, 1, 'Box (title, no padding)'),
(1131, 1, 'Box (no title, padding)'),
(1132, 1, 'Box (no title, no padding)'),
(1133, 1, 'HTML Block'),
(1134, 1, 'Number of RSS items (0 - all)'),
(1135, 1, 'Profile Fields'),
(1136, 1, 'PHP Block'),
(1137, 1, 'RSS Feed'),
(1138, 1, 'Are you sure want to reset this page?\nThe page contents will be reset to factory state!'),
(1139, 1, 'Special Block'),
(1140, 1, 'Text Block'),
(1141, 1, 'This block has no properties'),
(1142, 1, 'Url of RSS feed'),
(1143, 1, 'Are you sure want to delete this item?'),
(1144, 1, 'XML Block'),
(1145, 1, 'XML-path'),
(1146, 1, 'Page Builder'),
(1147, 1, 'Page Builder'),
(1148, 1, 'Use any chars you want ;)'),
(1149, 1, 'Unique page name. Will be used in its address: <b>{0}</b> Use only alphanumeric chars'),
(1150, 1, 'The value stored in the database'),
(1151, 1, 'Primary language key used for displaying'),
(1152, 1, 'Secondary language key used for displaying in some other places'),
(1153, 1, 'Miscellaneous language key used for displaying in some other places'),
(1154, 1, 'Extra parameter'),
(1155, 1, 'Miscellaneous extra parameter'),
(1156, 1, 'Miscellaneous extra parameter'),
(1157, 1, 'Please enter name of new list'),
(1158, 1, 'You should enter correct name'),
(1159, 1, 'Select a list'),
(1160, 1, 'Move Up'),
(1161, 1, 'Move Down'),
(1162, 1, 'Create New'),
(1163, 1, 'Add Record'),
(1164, 1, 'Service Menu Builder'),
(1165, 1, 'Service Menu Builder'),
(1166, 1, 'Add Modules'),
(1167, 1, 'Site Home'),
(1168, 1, 'Documentation'),
(1169, 1, 'Select Language'),
(1170, 1, 'Logout'),
(1171, 1, 'Cache'),
(1172, 1, 'Clear Cache'),
(1173, 1, 'Clear Cache:'),
(1174, 1, 'All'),
(1175, 1, 'Failed to clean cache'),
(1176, 1, 'Cache was successfully cleaned'),
(1177, 1, 'CSS'),
(1178, 1, 'DB'),
(1179, 1, 'JavaScript'),
(1180, 1, 'Member Menu'),
(1181, 1, 'Page Blocks'),
(1182, 1, 'Templates'),
(1183, 1, 'Users'),
(1184, 1, '\n<ol class="adm-ds-help bx-def-font-large">\n    <li>\n        Change the site logo to your own\n        <a href="{0}basic_settings.php">here</a>\n        <a target="_blank" href="https://www.boonex.com/trac/dolphin/wiki/TutorialHowToPersonalizeYourDolphinSite#Logo"><i class="sys-icon question-sign"></i></a>\n    </li>\n    <li>\n        <a target="_blank" href="http://www.google.com/recaptcha">Generate your own Captcha keys</a> and fill them in\n        <a href="{0}advanced_settings.php?c=Security">here</a>\n    </li>\n    <li>\n        Write your own copyright notice text\n        <a href="{0}lang_file.php">here</a>\n        <a target="_blank" href="https://www.boonex.com/trac/dolphin/wiki/TutorialHowToPersonalizeYourDolphinSite#Copyright"><i class="sys-icon question-sign"></i></a>\n    </li>\n    <li>\n        Change ''about'' and other information pages text\n        <a href="{0}lang_file.php">here</a>\n        <a target="_blank" href="https://www.boonex.com/trac/dolphin/wiki/TutorialHowToPersonalizeYourDolphinSite#PersonalizingText"><i class="sys-icon question-sign"></i></a>\n    </li>\n    <li>\n        Install modules of your choice\n        <a href="{0}modules.php">here</a>\n        <a target="_blank" href="https://www.boonex.com/trac/dolphin/wiki/DolphinAdminModules"><i class="sys-icon question-sign"></i></a>\n    </li>\n    <li>\n        If using Facebook Connect, Generate your own Facebook keys and fill them in\n        <a href="{1}modules/?r=facebook_connect/administration/">here</a>\n    </li>\n    <li>\n        Build your site homepage blocks\n        <a href="{0}pageBuilder.php?Page=index">here</a>\n        <a target="_blank" href="https://www.boonex.com/trac/dolphin/wiki/DolphinAdminPagesBlocks"><i class="sys-icon question-sign"></i></a>\n    </li>\n    <li>\n        Setup site permissions settings\n        <a href="{0}memb_levels.php">here</a>\n        <a target="_blank" href="https://www.boonex.com/trac/dolphin/wiki/DolphinAdminMembershipLevels"><i class="sys-icon question-sign"></i></a>\n    </li>\n    <li>\n        When ready to buy a full license, order it\n        <a target="_blank" href="https://www.boonex.com/start">here</a>\n    </li>\n    <li>\n        Register your license <a href="{0}license.php">here</a>\n    </li>\n</ol>'),
(1185, 1, 'Don''t show it anymore'),
(1186, 1, 'now!'),
(1187, 1, 'Update to'),
(1188, 1, 'Default'),
(1189, 1, 'Body'),
(1190, 1, 'Language'),
(1191, 1, 'Templates'),
(1192, 1, 'Nothing was changed'),
(1193, 1, 'Settings'),
(1194, 1, 'Subject'),
(1195, 1, 'Templates were successfully saved'),
(1196, 1, 'Get new modules'),
(1197, 1, '90% of configuration and installation issues result from incorrect hosting setup. BoonEx constantly works with a number of quality hosts and we recommend the best ones. Moreover, BoonEx customers generally receive better deals and accounts tailored specifically for Dolphin.'),
(1198, 1, 'Recommended Hosting'),
(1199, 1, 'Category'),
(1200, 1, 'Key name'),
(1201, 1, 'String text for {0} language'),
(1202, 1, 'Add key'),
(1203, 1, 'Language key already exists'),
(1204, 1, 'Could not add a language string to the database'),
(1205, 1, 'Could not compile a language file'),
(1206, 1, 'Could not add a new language to the database'),
(1207, 1, 'Could not delete a language file'),
(1208, 1, 'Cannot delete the default language'),
(1209, 1, 'Cannot upload the file'),
(1210, 1, '2 Letters Language Code'),
(1211, 1, 'Compile'),
(1212, 1, 'Copy from'),
(1213, 1, 'Language and Country code (ex: en_US)'),
(1214, 1, 'Default site language'),
(1215, 1, 'default'),
(1216, 1, 'Delete'),
(1217, 1, 'Direction'),
(1218, 1, 'Edit'),
(1219, 1, 'Please specify a code for the new language'),
(1220, 1, 'Please specify a title for the new language'),
(1221, 1, 'Export'),
(1222, 1, 'Browse'),
(1223, 1, 'Flag'),
(1224, 1, 'Keys'),
(1225, 1, 'Languages'),
(1226, 1, 'Add Language'),
(1227, 1, 'Import Language'),
(1228, 1, 'Settings'),
(1229, 1, 'Language file(s) was compiled successfully'),
(1230, 1, 'Language file was created'),
(1231, 1, 'Language file(s) has been successfully removed'),
(1232, 1, 'Language file was imported'),
(1233, 1, 'Language key was successfully saved'),
(1234, 1, 'Language file has been successfully updated'),
(1235, 1, 'Title'),
(1236, 1, 'List'),
(1237, 1, 'Password'),
(1238, 1, 'Username'),
(1239, 1, 'Make Default'),
(1240, 1, 'Manage'),
(1241, 1, 'Cannot save the action''s settings'),
(1242, 1, 'Action''s settings were saved successfully'),
(1243, 1, 'Actions'),
(1244, 1, 'Leave it blank if the action is available every time'),
(1245, 1, 'This action is available until'),
(1246, 1, 'This action is available since'),
(1247, 1, 'Number of allowed actions'),
(1248, 1, 'Leave it blank for unlimited actions'),
(1249, 1, 'Number of actions is reset every'),
(1250, 1, 'In hours. Leave it blank if you don''t want to reset counter'),
(1251, 1, 'The membership cannot be removed'),
(1252, 1, 'Custom Levels'),
(1253, 1, 'Description'),
(1254, 1, 'Edit'),
(1255, 1, 'Image Icon'),
(1256, 1, 'You need to select an image for thumbnail'),
(1257, 1, 'Leave empty if you want to use previously uploaded icon.'),
(1258, 1, 'There are members using the level so it cannot be deleted'),
(1259, 1, 'Levels'),
(1260, 1, 'Add Level'),
(1261, 1, 'Name'),
(1262, 1, 'You need to enter name(3, 100) for membership level'),
(1263, 1, 'Name must be unique'),
(1264, 1, 'Requested membership level is not found'),
(1265, 1, 'Order'),
(1266, 1, 'You need to enter order for membership level. It should be more then zero.'),
(1267, 1, 'Pricing'),
(1268, 1, 'Number of days (0 = life-time):'),
(1269, 1, 'Price:'),
(1270, 1, 'Similar pricing option already exists'),
(1271, 1, '{0} days - {1}{2}'),
(1272, 1, 'lifetime - {0}{1}'),
(1273, 1, 'Settings'),
(1274, 1, 'System Levels'),
(1275, 1, 'The module is already installed.'),
(1276, 1, 'The module is already uninstalled.'),
(1277, 1, 'Cannot connect to FTP server. Check credentials in Settings -> Advanced Settings -> General.'),
(1278, 1, 'Cannot recompile the following languages:'),
(1279, 1, 'Cannot remove package.'),
(1280, 1, 'Cannot unarchive the package'),
(1281, 1, 'Cannot upload the package'),
(1282, 1, 'Cannot download the package'),
(1283, 1, 'Cannot write the package'),
(1284, 1, 'Checking permissions:'),
(1285, 1, 'Changing permissions:'),
(1286, 1, 'Check module dependencies:'),
(1287, 1, 'Check module for existence:'),
(1288, 1, 'Check module hash:'),
(1289, 1, 'Check module version:'),
(1290, 1, 'Check the Dolphin version for compatibility:'),
(1291, 1, 'Clear database cache:'),
(1292, 1, 'All module data will be lost permanently. Are you sure you want to uninstall module(s) ?'),
(1293, 1, 'Destination FTP folder doesn''t look like valid Dolphin root folder. Check credentials in Settings -> Advanced Settings -> General.'),
(1294, 1, 'Executable'),
(1295, 1, 'Changing database:'),
(1296, 1, 'FTP access'),
(1297, 1, 'FTP transfer failed, please check write permission for this FTP user'),
(1298, 1, 'Failed to uninstall. The module has the following dependent modules. You need to uninstall them first.'),
(1299, 1, 'Host'),
(1300, 1, 'Login'),
(1301, 1, 'Module'),
(1302, 1, 'Module''s config file was not found'),
(1303, 1, 'Module not found'),
(1304, 1, 'Module was modified'),
(1305, 1, 'FTP access info was not specified. You may enter it via Settings -> General.'),
(1306, 1, 'Installation of: <b>{0}</b>'),
(1307, 1, 'Recompilation of language file(s) in <b>{0}</b>'),
(1308, 1, 'Uninstallation of: <b>{0}</b>'),
(1309, 1, 'Installation of update <b>{0}</b> from {1} up to {2}'),
(1310, 1, 'Package to upload'),
(1311, 1, 'A module with similar unique parameters is already installed.'),
(1312, 1, 'Path to Dolphin''s folder'),
(1313, 1, 'An error occurred. Contact with module''s vendor.'),
(1314, 1, 'Done'),
(1315, 1, 'Failed'),
(1316, 1, 'Cannot {0} module from "{1}" directory'),
(1317, 1, 'Done'),
(1318, 1, 'Recompiling alerts:'),
(1319, 1, 'Recompiling categories:'),
(1320, 1, 'Recompiling comments:'),
(1321, 1, 'Recompiling global parameters:'),
(1322, 1, 'Recompiling injections:'),
(1323, 1, 'Recompiling main menu:'),
(1324, 1, 'Recompiling member actions:'),
(1325, 1, 'Recompiling member menu:'),
(1326, 1, 'Recompiling page builder:'),
(1327, 1, 'Recompiling permalinks:'),
(1328, 1, 'Recompiling profile fields:'),
(1329, 1, 'Recompiling search:'),
(1330, 1, 'Recompiling site statistics:'),
(1331, 1, 'Recompiling tags:'),
(1332, 1, 'Recompiling votes:'),
(1333, 1, 'Conclusion from vendor:'),
(1334, 1, 'Introduction from vendor:'),
(1335, 1, 'The package(s) was successfully deleted'),
(1336, 1, 'The package was uploaded successfully'),
(1337, 1, '<span class="modules-item-title">{0}</span> version {1} by {2}'),
(1338, 1, '<span class="modules-item-title">{0}</span> ({1} - {2})'),
(1339, 1, 'The update was sucessfully downloaded'),
(1340, 1, 'Update files:'),
(1341, 1, 'Update languages:'),
(1342, 1, 'Updates were not found.'),
(1343, 1, 'New version {0} is available.'),
(1344, 1, '{0} version {1}'),
(1345, 1, 'Writable'),
(1346, 1, 'The following modules should be uninstalled first:'),
(1347, 1, 'The following modules should be installed first:'),
(1348, 1, 'You need to have at least one payment processing module installed and selected as default in Settings -> Advanced Settings -> General -> Payment module.'),
(1349, 1, 'There are errors in the following MySQL queries:'),
(1350, 1, 'Error: {0}'),
(1351, 1, 'Wrong package format'),
(1352, 1, 'You need to change permissions for the following files and folders:'),
(1353, 1, 'Unable to change permissions automatically.'),
(1354, 1, 'Unable to change permissions automatically due to cannot connect to FTP server. Check credentials in Settings -> Advanced Settings -> General.'),
(1355, 1, 'Unable to change permissions automatically due to destination FTP folder doesn''t look like valid Dolphin root folder. Check credentials in Settings -> Advanced Settings -> General.'),
(1356, 1, 'You need to manually change them for the following files and folders and try again:'),
(1357, 1, '{0} - {1}'),
(1358, 1, 'The module has incompatible version'),
(1359, 1, 'The module is not compatible with your version of Dolphin script'),
(1360, 1, 'ZIP functions aren''t available, please check server requirements'),
(1361, 1, 'active'),
(1362, 1, 'admins'),
(1363, 1, 'all'),
(1364, 1, 'approval'),
(1365, 1, 'banned'),
(1366, 1, 'couple'),
(1367, 1, 'featured'),
(1368, 1, 'female'),
(1369, 1, 'intersex'),
(1370, 1, 'male'),
(1371, 1, 'other'),
(1372, 1, 'Promotion'),
(1373, 1, 'rejected'),
(1374, 1, 'single'),
(1375, 1, 'suspended'),
(1376, 1, 'unconfirmed'),
(1377, 1, 'Confirmation email messages were successfully sent'),
(1378, 1, 'Email'),
(1379, 1, 'Filter'),
(1380, 1, 'Last Activity'),
(1381, 1, 'Membership'),
(1382, 1, 'Order by:'),
(1383, 1, 'Last Activity'),
(1384, 1, 'Last Join'),
(1385, 1, 'None'),
(1386, 1, 'User Name'),
(1387, 1, 'Registered'),
(1388, 1, 'Username'),
(1389, 1, 'Active Blocks'),
(1390, 1, 'Inactive Blocks'),
(1391, 1, 'loading ...'),
(1392, 1, 'Other Pages Width'),
(1393, 1, 'Pages:'),
(1394, 1, 'Page Width'),
(1395, 1, 'Samples'),
(1396, 1, 'Select page'),
(1397, 1, 'View page'),
(1398, 1, 'Defaults'),
(1399, 1, 'Nothing was changed'),
(1400, 1, 'Settings'),
(1401, 1, 'Default values were successfully saved'),
(1402, 1, 'Confirm Password'),
(1403, 1, 'Cannot save settings'),
(1404, 1, 'Couldn''t move uploaded file'),
(1405, 1, 'The uploaded file is not an image'),
(1406, 1, 'The uploaded file is not a JPEG, GIF or PNG file'),
(1407, 1, 'Resize failed'),
(1408, 1, '&lt;HEAD&gt; injection'),
(1409, 1, '&lt;BODY&gt; injection'),
(1410, 1, 'Upload'),
(1411, 1, 'Browse'),
(1412, 1, 'You''ve entered incorrect sizes'),
(1413, 1, 'New Password'),
(1414, 1, 'Old Password'),
(1415, 1, 'Enable resizing'),
(1416, 1, 'Resize'),
(1417, 1, 'Height'),
(1418, 1, 'Width'),
(1419, 1, 'Enable HTML Editor'),
(1420, 1, 'Hide for logged in users'),
(1421, 1, 'Visibility'),
(1422, 1, 'show on all pages'),
(1423, 1, 'disable'),
(1424, 1, 'show on homepage'),
(1425, 1, 'Note, that improper use of HTML may break the site layout.'),
(1426, 1, 'Settings were successfully saved'),
(1427, 1, 'Confirmation does not match password'),
(1428, 1, 'Wrong new password'),
(1429, 1, 'Wrong old password'),
(1430, 1, 'Alternative template with slightly different color scheme and background image. ALT is an example of how only a few basic changes to UNI template can create different "feel".'),
(1431, 1, 'Simple and responsive template, with emphasis on content and fluid user-experience. Retina-friendly, mobile-friendly touch-friendly.'),
(1432, 1, 'The default template for Dolphin, universally suitable for variety of social networking website niches. UNI is optimized for large screen resolutions and features minimalistic layout with vector-based icons (good for "retina" screens).'),
(1433, 1, 'Preview Not Available'),
(1434, 1, 'Templates'),
(1435, 1, 'all'),
(1436, 1, 'All Tags'),
(1437, 1, 'Who can<br />see you'),
(1438, 1, 'This user already in your friend list!'),
(1439, 1, 'associated image'),
(1440, 1, 'bad comment parent id'),
(1441, 1, 'Pending Approval'),
(1442, 1, 'Settings'),
(1443, 1, 'All Categories'),
(1444, 1, 'Activate'),
(1445, 1, 'Delete'),
(1446, 1, 'Disable'),
(1447, 1, 'Categories By Day: '),
(1448, 1, 'All Categories'),
(1449, 1, 'Calendar'),
(1450, 1, 'Common Categories'),
(1451, 1, 'Empty'),
(1452, 1, 'Search Results'),
(1453, 1, 'Keyword'),
(1454, 1, 'Search Form'),
(1455, 1, 'User Categories'),
(1456, 1, 'Please specify keyword from 1 to 100 characters'),
(1457, 1, 'Category named ''%s'' already exists'),
(1458, 1, 'Add Category'),
(1459, 1, 'Please specify name from 3 to 100 characters'),
(1460, 1, 'Name'),
(1461, 1, 'Type'),
(1462, 1, 'Modules'),
(1463, 1, 'None'),
(1464, 1, 'Order by: '),
(1465, 1, 'Popular'),
(1466, 1, 'Recent'),
(1467, 1, 'Categories'),
(1468, 1, 'Category'),
(1469, 1, 'User Categories'),
(1470, 1, '{0} to {1} characters'),
(1471, 1, 'comments'),
(1472, 1, 'Contact Us'),
(1473, 1, '&copy; {0} YourCompany'),
(1474, 1, 'created'),
(1475, 1, ' days'),
(1476, 1, 'delete'),
(1477, 1, 'download'),
(1478, 1, 'Edit available for <span><b>{0}</b></span> seconds'),
(1479, 1, 'Edit profile info'),
(1480, 1, 'Edit profile membership'),
(1481, 1, 'Edit profile privacy'),
(1482, 1, 'Save'),
(1483, 1, 'expand all'),
(1484, 1, 'failed to delete post'),
(1485, 1, 'featured members'),
(1486, 1, 'Woman'),
(1487, 1, 'Forgot password'),
(1488, 1, 'from'),
(1489, 1, 'from zip/postal code'),
(1490, 1, 'greeting'),
(1491, 1, 'Help'),
(1492, 1, 'Comment by <b>{0}</b> is hidden.'),
(1493, 1, 'in {0} days'),
(1494, 1, 'in {0}d'),
(1495, 1, 'in an hour'),
(1496, 1, 'in {0} hours'),
(1497, 1, 'in {0}h'),
(1498, 1, 'in {0} minutes'),
(1499, 1, 'in {0}m'),
(1500, 1, 'item'),
(1501, 1, 'items'),
(1502, 1, '<p style="text-align:center">By registering, you confirm that you accept our <a href="{0}terms_of_use.php">Terms of Use</a> and <a href="{0}privacy.php">Privacy Policy</a>.</p>'),
(1503, 1, 'just now'),
(1504, 1, 'kilometers'),
(1505, 1, 'letter'),
(1506, 1, 'living within'),
(1507, 1, 'loading ...'),
(1508, 1, '<div class="usualHeader">Not a member yet? <a href="{0}join.php">Join now!</a></div>Join our community now to meet new people; share photos, videos and music; create your own blog; post ads; chat online and more!'),
(1509, 1, 'Man'),
(1510, 1, 'If you have problems with the flash uploader, we recommend that you use a regular uploader.'),
(1511, 1, 'Sorry, you''ve been banned'),
(1512, 1, 'Membership'),
(1513, 1, 'Message Subject'),
(1514, 1, 'miles'),
(1515, 1, 'comments edit own'),
(1516, 1, 'comments post'),
(1517, 1, 'comments remove own'),
(1518, 1, 'comments vote'),
(1519, 1, 'get other members'' emails'),
(1520, 1, 'send friend requests'),
(1521, 1, 'send greetings'),
(1522, 1, 'send messages'),
(1523, 1, 'view profiles'),
(1524, 1, 'vote'),
(1525, 1, 'Member Menu Builder'),
(1526, 1, 'Member Menu Builder'),
(1527, 1, 'Next Month'),
(1528, 1, 'Next Mon &#8250;'),
(1529, 1, 'Previous Month'),
(1530, 1, '&#8249; Prev Mon'),
(1531, 1, 'more'),
(1532, 1, 'new'),
(1533, 1, 'newest first'),
(1534, 1, 'no limit'),
(1535, 1, 'Not a member?'),
(1536, 1, 'of'),
(1537, 1, 'oldest first'),
(1538, 1, 'online only'),
(1539, 1, 'or'),
(1540, 1, 'Your friend request is awaiting confirmation'),
(1541, 1, '<a href="{0}">Click here</a> to respond to the friend request.'),
(1542, 1, 'unlimited'),
(1543, 1, 'please fill in these fields first'),
(1544, 1, 'Popular Tags'),
(1545, 1, 'post successfully deleted'),
(1546, 1, 'Our website is powered by <a href="https://www.boonex.com/features">BoonEx Dolphin</a>. Anyone can create their own niche social network using BoonEx software.'),
(1547, 1, '{0} is {1} now'),
(1548, 1, 'Profile Comments'),
(1549, 1, 'Info'),
(1550, 1, 'Add members'),
(1551, 1, 'Privacy'),
(1552, 1, 'Create a New Privacy Group'),
(1553, 1, 'Default Privacy Group'),
(1554, 1, 'Default values'),
(1555, 1, 'Delete members'),
(1556, 1, 'My Privacy Groups'),
(1557, 1, 'Add'),
(1558, 1, 'Create'),
(1559, 1, 'Delete'),
(1560, 1, 'Save'),
(1561, 1, 'Search'),
(1562, 1, 'extended from'),
(1563, 1, 'None'),
(1564, 1, 'Extends'),
(1565, 1, 'Groups'),
(1566, 1, 'Keyword'),
(1567, 1, 'Title'),
(1568, 1, 'You need to enter text'),
(1569, 1, 'You need to select some values'),
(1570, 1, 'When you post content you can choose "default" privacy group and then change the "default" value anytime. Thus, you can start posting for your friends only, and later, for example, open everything for all members or even go public. Define "default" value here and choose "default" when posting content to have this global control.'),
(1571, 1, 'Default'),
(1572, 1, 'Me Only'),
(1573, 1, 'Public'),
(1574, 1, 'Members'),
(1575, 1, 'Friends'),
(1576, 1, 'Faves'),
(1577, 1, 'Contacts'),
(1578, 1, 'Add Members'),
(1579, 1, 'Delete Members'),
(1580, 1, 'Privacy Groups'),
(1581, 1, 'Privacy Groups'),
(1582, 1, 'Allow to view blocks'),
(1583, 1, 'public'),
(1584, 1, 'rate profile'),
(1585, 1, 'registration by invitation only'),
(1586, 1, 'Have an Android device?\r\nAccess our site on your handset!'),
(1587, 1, 'Android App'),
(1588, 1, 'Have an iPhone, iPod or iPad?\r\nAccess our site on your iOS device!'),
(1589, 1, 'iOS App'),
(1590, 1, 'Subscriptions'),
(1591, 1, 'Admin Mass Mails'),
(1592, 1, '{0}'),
(1593, 1, '{0} (New Profile Comments)'),
(1594, 1, '{0} (New Profile Updates)'),
(1595, 1, 'Profile'),
(1596, 1, 'System'),
(1597, 1, 'You will not receive any subscription emails because you have chosen to not receive any site notifications. You can change this setting <a href="{0}">here</a>.'),
(1598, 1, 'Are you sure you want to unsubscribe?'),
(1599, 1, 'Adv'),
(1600, 1, 'Quick'),
(1601, 1, 'Simple'),
(1602, 1, 'services'),
(1603, 1, 'Show'),
(1604, 1, 'Add New ...'),
(1605, 1, 'Your Akismet key is not specified - get <a target="_blank" href="http://wordpress.com/api-keys/">WordPress API key</a>'),
(1606, 1, 'Your Akismet key is invalid.'),
(1607, 1, 'Your Akismet key is valid.'),
(1608, 1, 'Available'),
(1609, 1, 'Activate'),
(1610, 1, 'Add'),
(1611, 1, 'Deactivate'),
(1612, 1, 'Delete'),
(1613, 1, 'Help'),
(1614, 1, 'DNSBL - <a href="http://en.wikipedia.org/wiki/DNSBL">Domain Name Service Block Lists</a>.\nThis functionality allows to block by IP address if it exists in one of available blocklists.\nOriginally it is designed to identify email spammers, but it is suitable for websites too.<br /><br />\nUse many services which provides lists of spammer IPs for blocking.\nYou can refer to the following sites for more such services: <br />\n<a href="http://en.wikipedia.org/wiki/Comparison_of_DNS_blacklists">http://en.wikipedia.org/wiki/Comparison_of_DNS_blacklists</a><br />\n<a href="http://www.dnsbl.info/">http://www.dnsbl.info/</a><br />\n<a href="http://stats.dnsbl.com/">http://stats.dnsbl.com/</a><br />\n<a href="http://www.moensted.dk/spam/">http://www.moensted.dk/spam/</a>'),
(1615, 1, 'Log'),
(1616, 1, 'Recheck'),
(1617, 1, 'A URI DNSBL is a DNSBL that lists the domain names and IP addresses which are found in the "clickable" links contained in the body of spams, but generally not found inside legitimate messages.\nThis antispam method scan submitted content for the urls and check them if any of them is a link to spam site. If such url detected in the text then content is not submitted.\n<br /><br />\nMore info about URI DNSBL: <br />\n<a href="http://www.surbl.org/">http://www.surbl.org/</a> <br />\n<a href="http://dnsbl.invaluement.com/ivmuri/">http://dnsbl.invaluement.com/ivmuri/</a>'),
(1618, 1, 'Cache Support'),
(1619, 1, 'Disabled'),
(1620, 1, 'Failed'),
(1621, 1, 'LISTED'),
(1622, 1, 'Not Listed'),
(1623, 1, 'Enabled'),
(1624, 1, 'Active'),
(1625, 1, 'Chain'),
(1626, 1, 'Comment'),
(1627, 1, 'Return value ("any" - any result)'),
(1628, 1, 'Recheck IP'),
(1629, 1, 'Recheck URL'),
(1630, 1, 'URL'),
(1631, 1, 'Domain zone'),
(1632, 1, 'Recheck Domain'),
(1633, 1, 'This is a required field'),
(1634, 1, 'Installed'),
(1635, 1, 'Akismet'),
(1636, 1, 'DNS Blocklists'),
(1637, 1, 'Stop Forum Spam'),
(1638, 1, 'URI DNS Blocklists'),
(1639, 1, 'To be able to submit spam reports to Stop Forum Spam server - <a target="_blank" href="http://www.stopforumspam.com/signup">get API key</a>'),
(1640, 1, 'Your Stop Forum Spam key is specified, so spam report will be sent when you delete member as spammer.'),
(1641, 1, 'Akismet Block Log'),
(1642, 1, 'DNSBL Block Log'),
(1643, 1, 'Recheck IP'),
(1644, 1, 'DNSBL URI Block Log'),
(1645, 1, 'Recheck URL'),
(1646, 1, 'Stop Forum Spam Block Log'),
(1647, 1, 'Apply'),
(1648, 1, 'Filter:'),
(1649, 1, 'Album'),
(1650, 1, 'Add items'),
(1651, 1, 'Cancel'),
(1652, 1, 'Album name'),
(1653, 1, 'Description'),
(1654, 1, 'Location'),
(1655, 1, '{0} ({1})'),
(1656, 1, 'Create album'),
(1657, 1, 'Create New Album...'),
(1658, 1, 'Delete album'),
(1659, 1, '<a href="{0}">Edit album</a> to change privacy.'),
(1660, 1, 'Edit items'),
(1661, 1, 'Description error'),
(1662, 1, 'Move to another album'),
(1663, 1, 'Organize'),
(1664, 1, 'This album privacy is set to "Me Only".'),
(1665, 1, 'Private Album'),
(1666, 1, 'Save changes'),
(1667, 1, 'Album: {0}'),
(1668, 1, 'Album: {0} <i class="sys-icon chevron-right"></i> {1}'),
(1669, 1, 'My Profile'),
(1670, 1, 'New Message'),
(1671, 1, 'My Account'),
(1672, 1, 'Accept Friend Request'),
(1673, 1, 'Add Friend'),
(1674, 1, 'Unfriend'),
(1675, 1, 'Message'),
(1676, 1, '{0}'),
(1677, 1, '{0}'),
(1678, 1, 'Account Control'),
(1679, 1, 'Friend Requests'),
(1680, 1, 'New Messages'),
(1681, 1, 'Subscriptions'),
(1682, 1, 'Cover'),
(1683, 1, 'Subscribe'),
(1684, 1, 'Recommend'),
(1685, 1, 'Forum Feed'),
(1686, 1, 'Design ({0})'),
(1687, 1, 'Language ({0})'),
(1688, 1, 'Select Design'),
(1689, 1, 'Select Language'),
(1690, 1, 'Download'),
(1691, 1, 'Keyword Search'),
(1692, 1, 'People Search'),
(1693, 1, 'Change Thumbnail'),
(1694, 1, 'Change Cover'),
(1695, 1, 'To Admins'),
(1696, 1, 'Confirm'),
(1697, 1, 'From Admins'),
(1698, 1, 'Reject'),
(1699, 1, 'Remove'),
(1700, 1, 'Send'),
(1701, 1, 'Subscribe'),
(1702, 1, 'Unsubscribe'),
(1703, 1, 'POWERED BY<br /><strong>DOLPHIN.PRO</strong>'),
(1704, 1, 'Calendar'),
(1705, 1, '{0}, {1}'),
(1706, 1, 'Connections'),
(1707, 1, 'Favourites'),
(1708, 1, 'Remove from Favourites'),
(1709, 1, 'Friend Requests'),
(1710, 1, 'Fave'),
(1711, 1, 'Accept'),
(1712, 1, 'Reject'),
(1713, 1, 'No friend requests. Get pro-active and <a href="browse.php">look for new friends</a>.'),
(1714, 1, 'Blocked'),
(1715, 1, 'Favorites'),
(1716, 1, 'Friends'),
(1717, 1, 'No'),
(1718, 1, '{0} Mutual Friends'),
(1719, 1, 'To unsubscribe - login to your account, edit your profile and uncheck ''Receive site notifications''.'),
(1720, 1, 'please specify at least one category'),
(1721, 1, 'Data export download link has been sent to your email: {0}'),
(1722, 1, 'Additional Emails'),
(1723, 1, 'Add limited number of emails to send invitation to'),
(1724, 1, 'Invitation Text'),
(1725, 1, 'Invitation text will appear in invitation message along with basic event info'),
(1726, 1, 'Select Users'),
(1727, 1, 'Users are from your contacts, friends and favorites'),
(1728, 1, 'Kb'),
(1729, 1, 'Back to inbox'),
(1730, 1, 'Back to outbox'),
(1731, 1, 'Back to trash'),
(1732, 1, 'Username'),
(1733, 1, 'First Name'),
(1734, 1, 'First Name + Last Name'),
(1735, 1, 'Last Name + First Name'),
(1736, 1, 'Full Name'),
(1737, 1, 'Headline'),
(1738, 1, 'Status Message'),
(1739, 1, 'Age + Sex'),
(1740, 1, 'Location'),
(1741, 1, 'Avatar'),
(1742, 1, 'Avatar Icon'),
(1743, 1, 'Friends'),
(1744, 1, 'My Info'),
(1745, 1, 'Messages'),
(1746, 1, 'Contact'),
(1747, 1, 'Friends'),
(1748, 1, 'Profile Info'),
(1749, 1, 'Search'),
(1750, 1, 'Search By Keyword'),
(1751, 1, 'Location Search'),
(1752, 1, 'Status'),
(1753, 1, 'Profile'),
(1754, 1, 'You are using an outdated browser'),
(1755, 1, 'For a better experience using this site, please upgrade to a modern web browser.'),
(1756, 1, 'Shopping Cart'),
(1757, 1, 'Shopping Cart'),
(1758, 1, 'Cart'),
(1759, 1, 'Payments'),
(1760, 1, 'Subscriptions'),
(1761, 1, 'Private'),
(1762, 1, 'profile'),
(1763, 1, 'Information availability is limited by member privacy.'),
(1764, 1, 'Limited Visibility'),
(1765, 1, 'profiles'),
(1766, 1, 'Browse profiles by date {0}'),
(1767, 1, 'Incorrect please try again'),
(1768, 1, 'Type the text:'),
(1769, 1, 'Enter what you hear:'),
(1770, 1, 'refresh'),
(1771, 1, 'Get another CAPTCHA'),
(1772, 1, 'audio'),
(1773, 1, 'Get an audio CAPTCHA'),
(1774, 1, 'image'),
(1775, 1, 'Get an image CAPTCHA'),
(1776, 1, 'help'),
(1777, 1, 'Help'),
(1778, 1, 'Method({0}) was not found in module({1})'),
(1779, 1, 'Method was not found'),
(1780, 1, 'Module({0}) was not found'),
(1781, 1, 'Module was not found'),
(1782, 1, 'Page({0}) was not found in module({1})'),
(1783, 1, 'Page was not found'),
(1784, 1, 'Nothing was changed'),
(1785, 1, 'Search Home'),
(1786, 1, 'Select One'),
(1787, 1, 'Sitemap'),
(1788, 1, '<p>Sitemaps are an easy way to inform search engines about pages on you site that are available for crawling.\nOnce you activated sitemap and it was generated, you need to inform the search engines that your site supports sitemaps.\n</p>\n<p>\nYou can do this by:\n</p>\n<ul>\n    <li>\n        <b>submiting it via the search engine''s submission interface:</b>\n        please refer to particular search engine''s documentation on how to do this.\n    </li>\n    <li>\n        <b>specifying it in robots.txt file:</b>\n        simply add the following line to <b>robots.txt</b> file:\n        <pre class="code">Sitemap: {0}</pre>\n    </li>\n</ul>'),
(1789, 1, 'Enable sitemap generation'),
(1790, 1, 'Sitemap file is generated'),
(1791, 1, 'The following content pages are included in sitemap:'),
(1792, 1, 'Pages Created With Page Builder'),
(1793, 1, 'Profiles'),
(1794, 1, 'Profile Info Pages'),
(1795, 1, 'System Pages'),
(1796, 1, 'Account'),
(1797, 1, 'Account Menu'),
(1798, 1, 'Join'),
(1799, 1, 'Join or Login'),
(1800, 1, 'Login'),
(1801, 1, 'Logout'),
(1802, 1, 'Profile'),
(1803, 1, 'Settings'),
(1804, 1, 'Search'),
(1805, 1, 'Sorry, it looks like you are trying to submit spam. If you believe that this is a mistake, please submit a false positive report here: %s'),
(1806, 1, 'status message...'),
(1807, 1, 'update status'),
(1808, 1, 'Data has been successfully submitted.'),
(1809, 1, 'Enter a few words delimited by commas'),
(1810, 1, 'More'),
(1811, 1, '<a href="member_subscriptions.php">Manage Subscriptions</a>'),
(1812, 1, 'Loading...'),
(1813, 1, 'Security image is not available'),
(1814, 1, 'Loading...'),
(1815, 1, 'negative'),
(1816, 1, 'neutral'),
(1817, 1, 'positive'),
(1818, 1, 'Toggle HTML Editor'),
(1819, 1, 'Select files'),
(1820, 1, 'You are already subscribed to this content.'),
(1821, 1, 'You are not subscribed to this content.'),
(1822, 1, 'Cannot find the subscription.'),
(1823, 1, 'Cannot save private data. Please report.'),
(1824, 1, 'Email'),
(1825, 1, 'Enter your name and correct email address.'),
(1826, 1, 'Unknown error occurred. Please report.'),
(1827, 1, 'Name'),
(1828, 1, 'You were successfully subscribed.'),
(1829, 1, 'Your subscription was successfully canceled.'),
(1830, 1, 'Multi-uploader'),
(1831, 1, 'Unfortunately your browser doesn''t support HTML5 nor Flash'),
(1832, 1, 'File upload failed'),
(1833, 1, 'File size can''t be more than {0}'),
(1834, 1, 'Interrupted'),
(1835, 1, 'Done'),
(1836, 1, 'Wrong file extension'),
(1837, 1, 'Upload'),
(1838, 1, 'File not approved yet'),
(1839, 1, 'File not processed yet'),
(1840, 1, 'File not found'),
(1841, 1, 'Your browser doesn''t support scripts!'),
(1842, 1, '{0} bytes'),
(1843, 1, '{0} Gb'),
(1844, 1, '{0} Kb'),
(1845, 1, '{0} Mb'),
(1846, 1, '{0} Tb'),
(1847, 1, 'Tags By Day: '),
(1848, 1, 'Calendar'),
(1849, 1, 'Keyword'),
(1850, 1, 'Module'),
(1851, 1, 'Specify keywords, 1 to 100 letters'),
(1852, 1, 'Search Results'),
(1853, 1, 'Tags'),
(1854, 1, 'Recently Added Tags'),
(1855, 1, 'Search Form'),
(1856, 1, 'Tag'),
(1857, 1, 'Caption'),
(1858, 1, 'Content'),
(1859, 1, 'Date'),
(1860, 1, 'Update'),
(1861, 1, 'You need to fill in the field'),
(1862, 1, 'Incorrect length'),
(1863, 1, 'Post'),
(1864, 1, 'Snippet'),
(1865, 1, 'Tags'),
(1866, 1, 'Title should be {0} characters minimum '),
(1867, 1, 'to'),
(1868, 1, 'Tomorrow'),
(1869, 1, 'Top'),
(1870, 1, 'Top extra'),
(1871, 1, 'unknown'),
(1872, 1, 'undefined'),
(1873, 1, 'votes'),
(1874, 1, '<i>{0}</i> votes'),
(1875, 1, 'Friday'),
(1876, 1, 'Monday'),
(1877, 1, 'Saturday'),
(1878, 1, 'Sunday'),
(1879, 1, 'Thursday'),
(1880, 1, 'Tuesday'),
(1881, 1, 'Wednesday'),
(1882, 1, 'Fr'),
(1883, 1, 'Mo'),
(1884, 1, 'Sa'),
(1885, 1, 'Su'),
(1886, 1, 'Th'),
(1887, 1, 'Tu'),
(1888, 1, 'We'),
(1889, 1, '{0} days ago'),
(1890, 1, '{0}d ago'),
(1891, 1, 'an hour ago'),
(1892, 1, '{0} hours ago'),
(1893, 1, '{0}h ago'),
(1894, 1, '{0} minutes ago'),
(1895, 1, '{0}m ago'),
(1896, 1, '{0} y/o'),
(1897, 1, 'Yesterday'),
(1898, 1, '$10,000-$30,000/year'),
(1899, 1, '$10,000/year and less'),
(1900, 1, '$30,000-$50,000/year'),
(1901, 1, '$50,000-$70,000/year'),
(1902, 1, '$70,000/year and more'),
(1903, 1, 'Average'),
(1904, 1, 'Ample'),
(1905, 1, 'Athletic'),
(1906, 1, 'Cuddly'),
(1907, 1, 'Slim'),
(1908, 1, 'Very Cuddly'),
(1909, 1, 'Afghanistan'),
(1910, 1, 'Albania'),
(1911, 1, 'Algeria'),
(1912, 1, 'American Samoa'),
(1913, 1, 'Andorra'),
(1914, 1, 'Angola'),
(1915, 1, 'Anguilla'),
(1916, 1, 'Antarctica'),
(1917, 1, 'Antigua and Barbuda'),
(1918, 1, 'Argentina'),
(1919, 1, 'Armenia'),
(1920, 1, 'Aruba'),
(1921, 1, 'Australia'),
(1922, 1, 'Austria'),
(1923, 1, 'Azerbaijan'),
(1924, 1, 'Bahrain'),
(1925, 1, 'Bangladesh'),
(1926, 1, 'Barbados'),
(1927, 1, 'Belarus'),
(1928, 1, 'Belgium'),
(1929, 1, 'Belize'),
(1930, 1, 'Benin'),
(1931, 1, 'Bermuda'),
(1932, 1, 'Bhutan'),
(1933, 1, 'Bolivia'),
(1934, 1, 'Botswana'),
(1935, 1, 'Bouvet Island'),
(1936, 1, 'Brazil'),
(1937, 1, 'Brunei'),
(1938, 1, 'Bulgaria'),
(1939, 1, 'Burkina Faso'),
(1940, 1, 'Burma'),
(1941, 1, 'Burundi'),
(1942, 1, 'Cambodia'),
(1943, 1, 'Cameroon'),
(1944, 1, 'Cape Verde'),
(1945, 1, 'Cayman Islands'),
(1946, 1, 'Chad'),
(1947, 1, 'Canada'),
(1948, 1, 'Chile'),
(1949, 1, 'China'),
(1950, 1, 'Christmas Island'),
(1951, 1, 'Cote d''Ivoire'),
(1952, 1, 'Colombia'),
(1953, 1, 'Comoros'),
(1954, 1, 'Cook Islands'),
(1955, 1, 'Costa Rica'),
(1956, 1, 'Croatia'),
(1957, 1, 'Cuba'),
(1958, 1, 'Cyprus'),
(1959, 1, 'Czech Republic'),
(1960, 1, 'Denmark'),
(1961, 1, 'Djibouti'),
(1962, 1, 'Dominica'),
(1963, 1, 'Dominican Republic'),
(1964, 1, 'East Timor'),
(1965, 1, 'Ecuador'),
(1966, 1, 'Egypt'),
(1967, 1, 'El Salvador'),
(1968, 1, 'Equatorial Guinea'),
(1969, 1, 'Eritrea'),
(1970, 1, 'Estonia'),
(1971, 1, 'Ethiopia'),
(1972, 1, 'Faroe Islands'),
(1973, 1, 'Fiji'),
(1974, 1, 'Finland'),
(1975, 1, 'Falkland Islands (Islas Malvinas)'),
(1976, 1, 'France'),
(1977, 1, 'Gabon'),
(1978, 1, 'Georgia'),
(1979, 1, 'Germany'),
(1980, 1, 'Ghana'),
(1981, 1, 'Gibraltar'),
(1982, 1, 'Greece'),
(1983, 1, 'Greenland'),
(1984, 1, 'Grenada'),
(1985, 1, 'Guadeloupe'),
(1986, 1, 'Guam'),
(1987, 1, 'Guatemala'),
(1988, 1, 'Guinea'),
(1989, 1, 'Guinea-Bissau'),
(1990, 1, 'Guyana'),
(1991, 1, 'Haiti'),
(1992, 1, 'Holy See (Vatican City)'),
(1993, 1, 'Hong Kong (SAR)'),
(1994, 1, 'Honduras'),
(1995, 1, 'Hungary'),
(1996, 1, 'Iceland'),
(1997, 1, 'India'),
(1998, 1, 'Indonesia'),
(1999, 1, 'Iran'),
(2000, 1, 'Iraq'),
(2001, 1, 'Ireland'),
(2002, 1, 'Israel'),
(2003, 1, 'Italy'),
(2004, 1, 'Jamaica'),
(2005, 1, 'Japan'),
(2006, 1, 'Jordan'),
(2007, 1, 'Kazakhstan'),
(2008, 1, 'Kenya'),
(2009, 1, 'Kiribati'),
(2010, 1, 'Kuwait'),
(2011, 1, 'Kyrgyzstan'),
(2012, 1, 'Latvia'),
(2013, 1, 'Lebanon'),
(2014, 1, 'Lesotho'),
(2015, 1, 'Liberia'),
(2016, 1, 'Liechtenstein'),
(2017, 1, 'Lithuania'),
(2018, 1, 'Luxembourg'),
(2019, 1, 'Madagascar'),
(2020, 1, 'Malawi'),
(2021, 1, 'Malaysia'),
(2022, 1, 'Maldives'),
(2023, 1, 'Mali'),
(2024, 1, 'Malta'),
(2025, 1, 'Marshall Islands'),
(2026, 1, 'Martinique'),
(2027, 1, 'Mauritania'),
(2028, 1, 'Mauritius'),
(2029, 1, 'Mayotte'),
(2030, 1, 'Mexico'),
(2031, 1, 'Moldova'),
(2032, 1, 'Monaco'),
(2033, 1, 'Mongolia'),
(2034, 1, 'Montserrat'),
(2035, 1, 'Morocco'),
(2036, 1, 'Mozambique'),
(2037, 1, 'Namibia'),
(2038, 1, 'Nauru'),
(2039, 1, 'Nepal'),
(2040, 1, 'Netherlands'),
(2041, 1, 'New Caledonia'),
(2042, 1, 'New Zealand'),
(2043, 1, 'Nicaragua'),
(2044, 1, 'Niger'),
(2045, 1, 'Nigeria'),
(2046, 1, 'Niue'),
(2047, 1, 'Norfolk Island'),
(2048, 1, 'Norway'),
(2049, 1, 'Oman'),
(2050, 1, 'Pakistan'),
(2051, 1, 'Palau'),
(2052, 1, 'Panama'),
(2053, 1, 'Papua New Guinea'),
(2054, 1, 'Paraguay'),
(2055, 1, 'Peru'),
(2056, 1, 'Philippines'),
(2057, 1, 'Poland'),
(2058, 1, 'Portugal'),
(2059, 1, 'Puerto Rico'),
(2060, 1, 'Qatar'),
(2061, 1, 'Reunion'),
(2062, 1, 'Romania'),
(2063, 1, 'Russia'),
(2064, 1, 'Rwanda'),
(2065, 1, 'Saint Lucia'),
(2066, 1, 'Samoa'),
(2067, 1, 'San Marino'),
(2068, 1, 'Saudi Arabia'),
(2069, 1, 'Senegal'),
(2070, 1, 'Seychelles'),
(2071, 1, 'Sierra Leone'),
(2072, 1, 'Singapore'),
(2073, 1, 'Slovakia'),
(2074, 1, 'Solomon Islands'),
(2075, 1, 'Somalia'),
(2076, 1, 'South Africa'),
(2077, 1, 'Spain'),
(2078, 1, 'Sri Lanka'),
(2079, 1, 'Sudan'),
(2080, 1, 'Suriname'),
(2081, 1, 'Swaziland'),
(2082, 1, 'Sweden'),
(2083, 1, 'Switzerland'),
(2084, 1, 'Syria'),
(2085, 1, 'Taiwan'),
(2086, 1, 'Tajikistan'),
(2087, 1, 'Tanzania'),
(2088, 1, 'Thailand'),
(2089, 1, 'Togo'),
(2090, 1, 'Tokelau'),
(2091, 1, 'Tonga'),
(2092, 1, 'Trinidad and Tobago'),
(2093, 1, 'Tunisia'),
(2094, 1, 'Turkey'),
(2095, 1, 'Turkmenistan'),
(2096, 1, 'Tuvalu'),
(2097, 1, 'Uganda'),
(2098, 1, 'Ukraine'),
(2099, 1, 'United Arab Emirates'),
(2100, 1, 'United Kingdom'),
(2101, 1, 'Uruguay'),
(2102, 1, 'Uzbekistan'),
(2103, 1, 'Vanuatu'),
(2104, 1, 'Venezuela'),
(2105, 1, 'Virgin Islands'),
(2106, 1, 'Western Sahara'),
(2107, 1, 'Yemen'),
(2108, 1, 'Zambia'),
(2109, 1, 'Zimbabwe'),
(2110, 1, 'Netherlands Antilles'),
(2111, 1, 'Bosnia and Herzegovina'),
(2112, 1, 'The Bahamas'),
(2113, 1, 'Cocos (Keeling) Islands'),
(2114, 1, 'Congo, Democratic Republic of the'),
(2115, 1, 'Central African Republic'),
(2116, 1, 'Congo, Republic of the'),
(2117, 1, 'Micronesia, Federated States of'),
(2118, 1, 'French Guiana'),
(2119, 1, 'The Gambia'),
(2120, 1, 'South Georgia and the South Sandwich Islands'),
(2121, 1, 'Heard Island and McDonald Islands'),
(2122, 1, 'British Indian Ocean Territory'),
(2123, 1, 'Saint Kitts and Nevis'),
(2124, 1, 'Korea, North'),
(2125, 1, 'Korea, South'),
(2126, 1, 'Laos'),
(2127, 1, 'Libya'),
(2128, 1, 'Macedonia, The Former Yugoslav Republic of'),
(2129, 1, 'Macao'),
(2130, 1, 'Northern Mariana Islands'),
(2131, 1, 'French Polynesia'),
(2132, 1, 'Saint Pierre and Miquelon'),
(2133, 1, 'Pitcairn Islands'),
(2134, 1, 'Palestinian Territory, Occupied'),
(2135, 1, 'Saint Helena'),
(2136, 1, 'Slovenia'),
(2137, 1, 'Svalbard'),
(2138, 1, 'Sao Tome and Principe'),
(2139, 1, 'Turks and Caicos Islands'),
(2140, 1, 'French Southern and Antarctic Lands'),
(2141, 1, 'United States Minor Outlying Islands'),
(2142, 1, 'United States'),
(2143, 1, 'Saint Vincent and the Grenadines'),
(2144, 1, 'British Virgin Islands'),
(2145, 1, 'Vietnam'),
(2146, 1, 'Aland Islands'),
(2147, 1, 'Saint Barthelemy'),
(2148, 1, 'Guernsey'),
(2149, 1, 'Isle of Man'),
(2150, 1, 'Jersey'),
(2151, 1, 'Montenegro'),
(2152, 1, 'Saint Martin (French part)'),
(2153, 1, 'Serbia'),
(2154, 1, 'Wallis and Futuna'),
(2155, 1, 'All'),
(2156, 1, 'Active'),
(2157, 1, 'Approval'),
(2158, 1, 'Suspended'),
(2159, 1, 'Unconfirmed'),
(2160, 1, 'AA (2 years college)'),
(2161, 1, 'BA/BS (4 years college)'),
(2162, 1, 'High School graduate'),
(2163, 1, 'Some college'),
(2164, 1, 'College student'),
(2165, 1, 'Some grad school'),
(2166, 1, 'Grad school student'),
(2167, 1, 'MA/MS/MBA'),
(2168, 1, 'PhD/Post doctorate'),
(2169, 1, 'JD'),
(2170, 1, 'African'),
(2171, 1, 'African American'),
(2172, 1, 'Asian'),
(2173, 1, 'Caucasian'),
(2174, 1, 'East Indian'),
(2175, 1, 'Hispanic'),
(2176, 1, 'Indian'),
(2177, 1, 'Latino'),
(2178, 1, 'Mediterranean'),
(2179, 1, 'Middle Eastern'),
(2180, 1, 'Mixed'),
(2181, 1, 'English'),
(2182, 1, 'Afrikaans'),
(2183, 1, 'Arabic'),
(2184, 1, 'Bulgarian'),
(2185, 1, 'Burmese'),
(2186, 1, 'Cantonese'),
(2187, 1, 'Croatian'),
(2188, 1, 'Danish'),
(2189, 1, 'Dutch'),
(2190, 1, 'Esperanto'),
(2191, 1, 'Estonian'),
(2192, 1, 'Finnish'),
(2193, 1, 'French'),
(2194, 1, 'German'),
(2195, 1, 'Greek'),
(2196, 1, 'Gujarati'),
(2197, 1, 'Hebrew'),
(2198, 1, 'Hindi'),
(2199, 1, 'Hungarian'),
(2200, 1, 'Icelandic'),
(2201, 1, 'Indonesian'),
(2202, 1, 'Italian'),
(2203, 1, 'Japanese'),
(2204, 1, 'Korean'),
(2205, 1, 'Latvian'),
(2206, 1, 'Lithuanian'),
(2207, 1, 'Malay'),
(2208, 1, 'Mandarin'),
(2209, 1, 'Marathi'),
(2210, 1, 'Moldavian'),
(2211, 1, 'Nepalese'),
(2212, 1, 'Norwegian'),
(2213, 1, 'Persian'),
(2214, 1, 'Polish'),
(2215, 1, 'Portuguese'),
(2216, 1, 'Punjabi'),
(2217, 1, 'Romanian'),
(2218, 1, 'Russian'),
(2219, 1, 'Serbian'),
(2220, 1, 'Spanish'),
(2221, 1, 'Swedish'),
(2222, 1, 'Tagalog'),
(2223, 1, 'Taiwanese'),
(2224, 1, 'Tamil'),
(2225, 1, 'Telugu'),
(2226, 1, 'Thai'),
(2227, 1, 'Tongan'),
(2228, 1, 'Turkish'),
(2229, 1, 'Ukrainian'),
(2230, 1, 'Urdu'),
(2231, 1, 'Vietnamese'),
(2232, 1, 'Visayan'),
(2233, 1, 'Single'),
(2234, 1, 'Attached'),
(2235, 1, 'Divorced'),
(2236, 1, 'Married'),
(2237, 1, 'Separated'),
(2238, 1, 'Widow/er'),
(2239, 1, 'Adventist'),
(2240, 1, 'Agnostic'),
(2241, 1, 'Atheist'),
(2242, 1, 'Baptist'),
(2243, 1, 'Buddhist'),
(2244, 1, 'Caodaism'),
(2245, 1, 'Catholic'),
(2246, 1, 'Christian'),
(2247, 1, 'Hindu'),
(2248, 1, 'Iskcon'),
(2249, 1, 'Jainism'),
(2250, 1, 'Jewish'),
(2251, 1, 'Methodist'),
(2252, 1, 'Mormon'),
(2253, 1, 'Muslim'),
(2254, 1, 'Orthodox'),
(2255, 1, 'Pentecostal'),
(2256, 1, 'Protestant'),
(2257, 1, 'Quaker'),
(2258, 1, 'Scientology'),
(2259, 1, 'Shinto'),
(2260, 1, 'Sikhism'),
(2261, 1, 'Spiritual'),
(2262, 1, 'Taoism'),
(2263, 1, 'Wiccan'),
(2264, 1, 'Other'),
(2265, 1, 'No'),
(2266, 1, 'Rarely'),
(2267, 1, 'Often'),
(2268, 1, 'Very often');

-- --------------------------------------------------------

--
-- Table structure for table `sys_localization_string_params`
--

CREATE TABLE `sys_localization_string_params` (
  `IDKey` int(10) unsigned NOT NULL DEFAULT '0',
  `IDParam` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `Description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`IDKey`,`IDParam`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_menu_admin`
--

CREATE TABLE `sys_menu_admin` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(32) NOT NULL DEFAULT '',
  `title` varchar(64) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `icon` varchar(128) NOT NULL DEFAULT '',
  `icon_large` varchar(128) NOT NULL DEFAULT '',
  `check` varchar(255) NOT NULL DEFAULT '',
  `order` tinyint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=36 ;

--
-- Dumping data for table `sys_menu_admin`
--

INSERT INTO `sys_menu_admin` VALUES
(1, 0, 'users', '_adm_mmi_users', '{siteAdminUrl}profiles.php', '', 'users col-green1', 'users', '', 2),
(2, 0, 'modules', '_adm_mmi_modules', '', '', 'puzzle-piece col-red1', 'puzzle-piece', '', 3),
(3, 2, 'manage_modules', '_adm_mmi_manage_modules', '{siteAdminUrl}modules.php', 'Manage and configure integration modules for 3d party scripts', 'plus col-red1', '', '', 1),
(4, 2, 'flash_apps', '_adm_mmi_flash_apps', '{siteAdminUrl}flash.php', 'Flash Apps administration panel is available here', 'bolt col-red1', '', '', 2),
(5, 0, 'tools', '_adm_mmi_tools', '', '', 'wrench col-green3', 'wrench', '', 4),
(6, 5, 'mass_mailer', '_adm_mmi_mass_mailer', '{siteAdminUrl}notifies.php', 'Using this function you are able to send a newsletter to your site members', 'envelope col-green3', '', '', 1),
(7, 5, 'banners', '_adm_mmi_banners', '{siteAdminUrl}banners.php', 'Provides you with the ability to manage banners on your web site', 'flag col-green3', '', '', 4),
(8, 5, 'ip_blacklist', '_adm_mmi_ip_blacklist', '{siteAdminUrl}ip_blacklist.php', 'IP Blacklist system', 'ban col-green3', '', '', 6),
(9, 5, 'database_backup', '_adm_mmi_database_backup', '{siteAdminUrl}db.php', 'Make a backup of your site database with this utility', 'download col-green3', '', '', 7),
(10, 5, 'host_tools', '_adm_mmi_host_tools', '{siteAdminUrl}host_tools.php', 'Admin Host Tools', 'hdd-o col-green3', '', '', 8),
(11, 5, 'antispam', '_adm_mmi_antispam', '{siteAdminUrl}antispam.php', 'Antispam Tools', 'gavel col-green3', '', '', 9),
(12, 5, 'sitemap', '_adm_mmi_sitemap', '{siteAdminUrl}sitemap.php', 'Sitemap', 'sitemap col-green3', '', '', 10),
(13, 5, 'cache', '_adm_mmi_cache', '{siteAdminUrl}cache.php', 'Cache', 'bolt col-green3', '', '', 11),
(14, 0, 'builders', '_adm_mmi_builders', '', '', 'magic col-red2', 'magic', '', 5),
(15, 14, 'navigation_menu', '_adm_mmi_navigation_menu', '{siteAdminUrl}nav_menu_compose.php', 'For top menu items management', 'list col-red2', '', '', 1),
(16, 14, 'service_menu', '_adm_mmi_service_menu', '{siteAdminUrl}service_menu_compose.php', 'For top service''s menu items management', 'list col-red2', '', '', 2),
(17, 14, 'bottom_menu', '_adm_mmi_bottom_menu', '{siteAdminUrl}bottom_menu_compose.php', 'For top bottom''s menu items management', 'list col-red2', '', '', 3),
(18, 14, 'member_menu', '_adm_mmi_member_menu', '{siteAdminUrl}member_menu_compose.php', 'For top member''s menu items management', 'list col-red2', '', '', 4),
(19, 14, 'admin_menu', '_adm_mmi_admin_menu', '{siteAdminUrl}menu_compose_admin.php', 'For top admin''s menu items management', 'list col-red2', '', '', 5),
(20, 14, 'profile_fields', '_adm_mmi_profile_fields', '{siteAdminUrl}fields.php', 'For member profile fields management', 'list-alt col-red2', '', '', 10),
(21, 14, 'pages_blocks', '_adm_mmi_pages_blocks', '{siteAdminUrl}pageBuilder.php', 'Compose blocks for the site pages here', 'th-large col-red2', '', '', 20),
(22, 14, 'mobile_pages', '_adm_mmi_mobile_pages', '{siteAdminUrl}mobileBuilder.php', 'Mobile pages builder', 'th col-red2', '', '', 21),
(23, 14, 'predefined_values', '_adm_mmi_predefined_values', '{siteAdminUrl}preValues.php', '', 'list-ol col-red2', '', '', 30),
(24, 0, 'settings', '_adm_mmi_settings', '', '', 'sliders col-blue2', 'sliders', '', 6),
(25, 24, 'admin_password', '_adm_mmi_admin_password', '{siteAdminUrl}settings.php?cat=ap', 'Change a password for access to administration panel here', 'user-secret col-blue2', '', '', 1),
(26, 24, 'basic_settings', '_adm_mmi_basic_settings', '{siteAdminUrl}basic_settings.php', 'For managing site system settings', 'cog col-blue2', '', '', 2),
(27, 24, 'advanced_settings', '_adm_mmi_advanced_settings', '{siteAdminUrl}advanced_settings.php', 'More enhanced settings for your site features', 'cogs col-blue2', '', '', 3),
(28, 24, 'languages_settings', '_adm_mmi_languages_settings', '{siteAdminUrl}lang_file.php', 'For languages management your website is using and making changes in your website content', 'language col-blue2', '', '', 4),
(29, 24, 'membership_levels', '_adm_mmi_membership_levels', '{siteAdminUrl}memb_levels.php', 'For setting up different membership levels, different actions for each membership level and action limits', 'star-o col-blue2', '', '', 5),
(30, 24, 'email_templates', '_adm_mmi_email_templates', '{siteAdminUrl}email_templates.php', 'For setting up email texts which are sent from your website to members automatically', 'clipboard col-blue2', '', '', 6),
(31, 24, 'templates', '_adm_mmi_templates', '{siteAdminUrl}templates.php', 'Templates management', 'eye col-blue2', '', '', 7),
(32, 24, 'privacy', '_adm_mmi_privacy', '{siteAdminUrl}privacy.php', 'Privacy settings', 'lock col-blue2', '', '', 8),
(33, 24, 'categories_settings', '_adm_mmi_categories_settings', '{siteAdminUrl}categories.php', 'Categories settings', 'folder col-blue2', '', '', 15),
(34, 24, 'watermark', '_adm_mmi_watermark', '{siteAdminUrl}settings.php?cat=16', 'Setting up watermark for media content', 'certificate col-blue2', '', '', 16),
(35, 0, 'dashboard', '_adm_mmi_dashboard', '{siteAdminUrl}index.php', '', 'tachometer col-blue3', 'tachometer', '', 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_menu_admin_top`
--

CREATE TABLE `sys_menu_admin_top` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL DEFAULT '',
  `caption` varchar(64) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `target` varchar(64) NOT NULL DEFAULT '',
  `icon` varchar(128) NOT NULL DEFAULT '',
  `order` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `sys_menu_admin_top`
--

INSERT INTO `sys_menu_admin_top` VALUES
(1, 'home', '_adm_tmi_home', '{site_url}index.php', '_blank', 'external-link-square', 1),
(2, 'extensions', '_adm_tmi_extensions', 'https://www.boonex.com/market', '', 'puzzle-piece', 2),
(3, 'info', '_adm_tmi_info', 'https://www.boonex.com/trac/dolphin/wiki', '', 'question-circle', 3),
(4, 'logout', '_adm_tmi_logout', '{site_url}logout.php', '', 'sign-out', 4);

-- --------------------------------------------------------

--
-- Table structure for table `sys_menu_bottom`
--

CREATE TABLE `sys_menu_bottom` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Caption` varchar(100) NOT NULL,
  `Name` varchar(200) NOT NULL,
  `Icon` varchar(100) NOT NULL,
  `Link` varchar(250) NOT NULL,
  `Script` varchar(250) NOT NULL,
  `Order` int(5) NOT NULL,
  `Target` varchar(200) NOT NULL,
  `Visible` set('non','memb') NOT NULL DEFAULT '',
  `Active` tinyint(1) NOT NULL DEFAULT '1',
  `Movable` tinyint(1) NOT NULL DEFAULT '1',
  `Clonable` tinyint(1) NOT NULL DEFAULT '1',
  `Editable` tinyint(1) NOT NULL DEFAULT '1',
  `Deletable` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `sys_menu_bottom`
--

INSERT INTO `sys_menu_bottom` VALUES
(1, '_About Us', 'About Us', '', 'about_us.php', '', 1, '', 'non,memb', 1, 3, 1, 1, 1),
(2, '_Privacy', 'Privacy', '', 'privacy.php', '', 2, '', 'non,memb', 1, 3, 1, 1, 1),
(3, '_Terms_of_use', 'Terms of use', '', 'terms_of_use.php', '', 3, '', 'non,memb', 1, 3, 1, 1, 1),
(4, '_FAQ', 'FAQ', '', 'faq.php', '', 4, '', 'non,memb', 1, 3, 1, 1, 1),
(5, '_Invite a friend', 'Invite a friend', '', 'tellfriend.php', 'return launchTellFriend();', 5, '', 'non,memb', 1, 3, 1, 1, 1),
(6, '_contact_us', 'Contact us', '', 'contact.php', '', 6, '', 'non,memb', 1, 3, 1, 1, 1),
(7, '_Bookmark', 'Bookmark', '', '', 'addBookmark(); return false;', 7, '', 'non,memb', 1, 3, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_menu_member`
--

CREATE TABLE `sys_menu_member` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Caption` varchar(100) NOT NULL,
  `Name` varchar(200) NOT NULL,
  `Icon` varchar(100) NOT NULL,
  `Link` varchar(250) NOT NULL,
  `Script` varchar(250) NOT NULL,
  `Eval` text NOT NULL,
  `PopupMenu` text NOT NULL,
  `Order` int(5) NOT NULL,
  `Active` enum('1','0') NOT NULL,
  `Movable` tinyint(4) NOT NULL DEFAULT '3',
  `Clonable` tinyint(1) NOT NULL DEFAULT '1',
  `Editable` tinyint(1) NOT NULL DEFAULT '1',
  `Deletable` tinyint(1) NOT NULL DEFAULT '1',
  `Target` varchar(200) NOT NULL,
  `Position` enum('top','bottom','top_extra') NOT NULL DEFAULT 'top',
  `Type` enum('link','system','linked_item') NOT NULL,
  `Parent` int(11) NOT NULL,
  `Bubble` text NOT NULL,
  `Description` varchar(50) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `Parent` (`Parent`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `sys_menu_member`
--

INSERT INTO `sys_menu_member` VALUES
(1, '{evalResult}', 'MemberBlock', '', '{ProfileLink}', '', 'return ''<b class="menu_item_username">'' . getNickName({ID}) . ''</b>'';', 'bx_import(''BxDolUserStatusView'');\r\n$oStatusView = new BxDolUserStatusView();\r\nreturn $oStatusView->getMemberMenuStatuses();', 1, '1', 3, 1, 0, 0, '', 'top', 'link', 0, '', '_Presence'),
(2, '_Mail', 'Mail', 'envelope', 'mail.php?mode=inbox', '', '', 'bx_import( ''BxTemplMailBox'' );\r\n// return list of messages ;\r\nreturn BxTemplMailBox::get_member_menu_messages_list({ID});', 1, '1', 3, 1, 0, 0, '', 'top_extra', 'link', 0, 'bx_import( ''BxTemplMailBox'' );\r\n// return list of new messages ;\r\n$aRetEval= BxTemplMailBox::get_member_menu_bubble_new_messages({ID}, {iOldCount});', '_Mail'),
(3, '_Friends', 'Friends', 'users', 'viewFriends.php?iUser={ID}', '', '', 'bx_import( ''BxDolFriendsPageView'' );\r\nreturn BxDolFriendsPageView::get_member_menu_friends_list({ID});', 3, '1', 3, 1, 0, 0, '', 'top_extra', 'link', 0, 'bx_import( ''BxDolFriendsPageView'' );\r\n$aRetEval = BxDolFriendsPageView::get_member_menu_bubble_friend_requests( {ID}, {iOldCount});', '_Friends'),
(4, '_sys_pmt_shopping_cart_caption', 'ShoppingCart', 'shopping-cart', 'cart.php', '', '', 'bx_import(''BxDolPayments'');\r\nreturn BxDolPayments::getInstance()->getCartItems();', 4, '1', 3, 1, 0, 0, '', 'top_extra', 'link', 0, 'bx_import(''BxDolPayments'');\r\n$oPayment = BxDolPayments::getInstance();\r\nif($oPayment->isActive()) $aRetEval = $oPayment->getCartItemCount({ID}, {iOldCount}); else $isSkipItem = true;', '_sys_pmt_shopping_cart_description'),
(5, '_Admin Panel', 'AdminPanel', 'wrench', '{evalResult}', '', 'return isAdmin() ? $GLOBALS[''site''][''url_admin''] : '''';', '', 5, '1', 3, 1, 1, 1, '', 'top_extra', 'link', 0, '', '_Go admin panel'),
(6, '_sys_add_content', 'AddContent', 'plus', 'javascript:void(0);', '', 'return array(''evalResultCssClassWrapper'' => ''extra_item_add_content'');', 'bx_import( ''BxDolUserStatusView'' );\r\n$oStatusView = new BxDolUserStatusView();\r\nreturn $oStatusView -> getStatusField({ID});', 6, '1', 3, 0, 0, 0, '', 'top_extra', 'link', 0, '$isSkipItem = $aReplaced[$sPosition][$iKey][''linked_items''] ? false : true;\r\n$aRetEval = false;', '_sys_add_content'),
(7, '_Settings', 'Settings', 'cog', 'pedit.php?ID={ID}', '', '', '', 0, '', 3, 1, 0, 0, '', 'top_extra', 'link', 0, '', '_Edit_profile_and_settings'),
(8, '_Status Message', 'StatusMessage', 'edit', 'javascript:void(0);', '', '', 'bx_import( ''BxDolUserStatusView'' );\r\n$oStatusView = new BxDolUserStatusView();\r\nreturn $oStatusView -> getStatusField({ID});', 0, '', 3, 1, 1, 1, '', 'top_extra', 'link', 0, '', '_Status Message');

-- --------------------------------------------------------

--
-- Table structure for table `sys_menu_mobile`
--

CREATE TABLE `sys_menu_mobile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(32) NOT NULL,
  `page` varchar(32) NOT NULL,
  `title` varchar(255) NOT NULL,
  `icon` varchar(255) NOT NULL,
  `action` int(11) NOT NULL,
  `action_data` varchar(255) NOT NULL,
  `eval_bubble` text NOT NULL,
  `eval_hidden` text NOT NULL,
  `order` int(11) NOT NULL,
  `active` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `sys_menu_mobile`
--

INSERT INTO `sys_menu_mobile` VALUES
(1, 'system', 'homepage', '_sys_mobile_status', 'home_status.png', 1, '', '', '', 1, 1),
(2, 'system', 'homepage', '_sys_mobile_mail', 'home_messages.png', 3, '', 'return getNewLettersNum({member_id});', '', 2, 1),
(3, 'system', 'homepage', '_sys_mobile_friends', 'home_friends.png', 4, '', 'return getFriendRequests({member_id});', '', 3, 1),
(4, 'system', 'homepage', '_sys_mobile_info', 'home_info.png', 5, '', '', '', 4, 1),
(5, 'system', 'homepage', '_sys_mobile_search', 'home_search.png', 6, '', '', '', 5, 1),
(6, 'system', 'profile', '_sys_mobile_profile_info', '', 5, '', '', '', 1, 1),
(7, 'system', 'profile', '_sys_mobile_profile_contact', '', 3, '', '', '', 2, 1),
(8, 'system', 'profile', '_sys_mobile_profile_friends', '', 4, '', 'return getFriendNumber(''{profile_id}'');', '', 3, 1),
(9, 'system', 'search', '_sys_mobile_search_by_keyword', '', 30, '', '', '', 1, 1),
(10, 'system', 'search', '_sys_mobile_search_by_location', '', 31, '', '', '', 2, 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_menu_mobile_pages`
--

CREATE TABLE `sys_menu_mobile_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page` varchar(32) NOT NULL,
  `title` varchar(255) NOT NULL,
  `order` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `page` (`page`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `sys_menu_mobile_pages`
--

INSERT INTO `sys_menu_mobile_pages` VALUES
(1, 'homepage', '_adm_mobile_page_homepage', 1),
(2, 'profile', '_adm_mobile_page_profile', 2),
(3, 'search', '_adm_mobile_page_search', 3);

-- --------------------------------------------------------

--
-- Table structure for table `sys_menu_service`
--

CREATE TABLE `sys_menu_service` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(200) NOT NULL,
  `Caption` varchar(100) NOT NULL,
  `Icon` varchar(100) NOT NULL,
  `Link` varchar(250) NOT NULL,
  `Script` varchar(250) NOT NULL,
  `Target` varchar(200) NOT NULL,
  `Order` int(5) NOT NULL,
  `Visible` set('non','memb') NOT NULL DEFAULT '',
  `Active` tinyint(1) NOT NULL DEFAULT '1',
  `Movable` tinyint(1) NOT NULL DEFAULT '1',
  `Clonable` tinyint(1) NOT NULL DEFAULT '1',
  `Editable` tinyint(1) NOT NULL DEFAULT '1',
  `Deletable` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `sys_menu_service`
--

INSERT INTO `sys_menu_service` VALUES
(1, 'Join', '_sys_sm_join', 'user', '', 'showPopupJoinForm(); return false;', '', 1, 'non', 1, 3, 1, 1, 1),
(2, 'Login', '_sys_sm_login', 'sign-in', '', 'showPopupLoginForm(); return false;', '', 2, 'non', 1, 3, 1, 1, 1),
(3, 'LoginOnly', '_sys_sm_login', 'sign-in', '', 'showPopupLoginOnlyForm(); return false;', '', 0, 'non', 0, 3, 1, 1, 1),
(4, 'Profile', '_sys_sm_profile', '', '{memberLink}|{memberNick}|change_status.php', '', '', 0, 'memb', 0, 3, 1, 1, 1),
(5, 'Account', '_sys_sm_account', 'tachometer', 'member.php', '', '', 1, 'memb', 1, 3, 1, 1, 1),
(6, 'ProfileSettings', '_sys_sm_profile_settings', 'cog', 'pedit.php?ID={memberID}', '', '', 2, 'memb', 1, 3, 1, 1, 1),
(7, 'Logout', '_sys_sm_logout', 'sign-out', 'logout.php?action=member_logout', '', '', 3, 'memb', 1, 3, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_menu_top`
--

CREATE TABLE `sys_menu_top` (
  `ID` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `Parent` smallint(6) unsigned NOT NULL DEFAULT '0',
  `Name` varchar(50) NOT NULL DEFAULT '',
  `Caption` varchar(50) NOT NULL DEFAULT '',
  `Link` varchar(255) NOT NULL DEFAULT '',
  `Order` smallint(6) unsigned NOT NULL DEFAULT '0',
  `Visible` set('non','memb') NOT NULL DEFAULT '',
  `Target` varchar(20) NOT NULL DEFAULT '',
  `Onclick` mediumtext NOT NULL,
  `Check` varchar(255) NOT NULL DEFAULT '',
  `Movable` tinyint(4) NOT NULL DEFAULT '3',
  `Clonable` tinyint(1) NOT NULL DEFAULT '1',
  `Editable` tinyint(1) NOT NULL DEFAULT '1',
  `Deletable` tinyint(1) NOT NULL DEFAULT '1',
  `Active` tinyint(1) NOT NULL DEFAULT '1',
  `Type` enum('system','top','custom') NOT NULL DEFAULT 'top',
  `Picture` varchar(128) NOT NULL,
  `Icon` varchar(128) NOT NULL,
  `BQuickLink` tinyint(1) NOT NULL DEFAULT '0',
  `Statistics` varchar(10) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=194 ;

--
-- Dumping data for table `sys_menu_top`
--

INSERT INTO `sys_menu_top` VALUES
(4, 0, 'My Profile', '{memberNick}', '{memberLink}|{memberUsername}|change_status.php', 3, 'memb', '', '', '', 1, 0, 0, 0, 1, 'system', 'user', '', 0, ''),
(5, 0, 'Home', '_Home', 'index.php', 0, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'top', 'home', '', 0, ''),
(6, 0, 'People', '_People', 'browse.php|search.php|calendar.php|tags.php?tags_mode=profile|search.php?show=match', 5, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'top', 'user', '', 0, ''),
(7, 6, 'All members', '_All Members', 'browse.php|browse', 0, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(8, 6, 'Search Members', '_Search', 'search.php', 9, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(9, 0, 'Profile View', '{profileNick}', '{profileUsername}|pedit.php?ID={profileID}', 0, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'system', '', '', 0, ''),
(11, 4, 'View My Profile', '_Profile', '{memberLink}|{memberUsername}|profile.php?ID={memberID}', 0, 'memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(12, 179, 'Mail Compose', '_Compose', 'mail.php?mode=compose', 0, 'memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(17, 179, 'Mail Inbox', '_Inbox', 'mail.php?mode=inbox', 1, 'memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 1, 'mma'),
(14, 179, 'Mail Outbox', '_Outbox', 'mail.php?mode=outbox', 2, 'memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(18, 179, 'Mail Trash', '_Trash', 'mail.php?mode=trash', 3, 'memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(20, 0, 'Edit My Profile', '_Customize', 'pedit.php?ID={memberID}', 0, 'memb', '', '', '', 3, 1, 1, 0, 0, 'custom', 'user', '', 1, ''),
(25, 6, 'Online Members', '_Online', 'search.php?online_only=1', 2, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(60, 9, 'View Profile', '_Profile', '{profileLink}|{profileUsername}|profile.php?ID={profileID}', 0, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(80, 4, 'My Friends', '_Friends', 'viewFriends.php?iUser={memberID}', 2, 'memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, 'mfa'),
(82, 9, 'Info', '_profile_info', 'profile_info.php?ID={profileID}', 1, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(83, 9, 'Member Friends', '_Friends', 'viewFriends.php?iUser={profileID}', 2, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(98, 0, 'Join', '_Account', 'join.php', 1, 'non', '', '', '', 3, 1, 1, 0, 1, 'system', 'user', '', 0, ''),
(99, 0, 'Login', '_Login', 'member.php', 0, 'non', '', '', '', 3, 1, 0, 0, 0, 'custom', 'user', '', 0, ''),
(100, 0, 'Main', '_Main', 'index.php|', 0, 'non,memb', '', '', '', 3, 1, 1, 0, 0, 'custom', '', '', 0, ''),
(101, 118, 'Account home', '_Account Home', 'member.php', 0, 'memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(129, 6, 'Top Rated', '_Top Rated', 'search.php?show=top_rated', 4, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(127, 6, 'Match', '_Match', 'search.php?show=match', 1, 'non,memb', '', '', 'return isLogged() && getParam(''enable_match'') == ''on'';', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(128, 6, 'Featured', '_Featured', 'search.php?show=featured', 3, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(107, 118, 'Privacy Groups', '_ps_tmenu_privacy_settings', 'member_privacy.php', 5, 'memb', '', '', 'bx_import(''BxDolPrivacy''); return BxDolPrivacy::isPrivacyPage();', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(109, 118, 'Unregister', '_Unregister', 'unregister.php', 8, 'memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(111, 4, 'Profile Info', '_Info', 'profile_info.php', 1, 'memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(118, 0, 'Dashboard', '_Dashboard', 'member.php', 2, 'memb', '', '', '', 1, 0, 1, 0, 1, 'system', 'tachometer', '', 0, ''),
(120, 0, 'About', '_About', 'about_us.php', 13, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'top', 'info-circle', '', 0, ''),
(122, 120, 'Terms of Use', '_TERMS_OF_USE_H', 'terms_of_use.php', 2, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(123, 120, 'Privacy Policy', '_PRIVACY_H', 'privacy.php', 3, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(126, 118, 'Activity', '_Activity', 'communicator.php', 3, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(130, 6, 'Popular', '_Popular', 'search.php?show=popular', 5, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(131, 6, 'Birthdays', '_Birthdays', 'search.php?show=birthdays', 6, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(132, 6, 'People Calendar', '_People_Calendar', 'calendar.php', 8, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(138, 0, 'Search', '_Search', 'search_home.php', 9, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'top', 'search', '', 0, ''),
(139, 138, 'Keyword Search', '_Keyword_Search', 'searchKeyword.php', 1, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(141, 138, 'People Search', '_People_Search', 'search.php', 3, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(159, 0, 'Help', '_help', 'help.php', 12, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'top', 'question-circle', '', 0, ''),
(160, 159, 'FAQ', '_FAQ', 'faq.php', 1, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(161, 159, 'Contact', '_Contact', 'contact.php', 2, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(162, 159, 'Advice', '_Advice', 'advice.php', 3, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(163, 159, 'Help', '_help', 'help.php', 0, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(175, 120, 'About', '_About', 'about_us.php', 0, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(176, 138, 'Search Home', '_Search_Home', 'search_home.php', 0, 'non,memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(179, 0, 'Mail', '_Mail', 'mail.php?mode=inbox', 4, 'memb', '', '', '', 3, 1, 1, 0, 1, 'system', 'envelope', '', 0, ''),
(191, 118, 'Subscriptions', '_sbs_tmenu_my_subscriptions', 'member_subscriptions.php', 7, 'memb', '', '', '', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(192, 118, 'Cart', '_sys_pmt_tmenu_cart', 'cart.php|modules/?r={sys_payment_module_uri}/cart/|modules/?r={sys_payment_module_uri}/history/', 9, 'memb', '', '', 'bx_import(''BxDolPayments''); return BxDolPayments::getInstance()->isActive();', 3, 1, 1, 0, 1, 'custom', '', '', 0, ''),
(193, 118, 'Payments', '_sys_pmt_tmenu_payments', 'orders.php|modules/?r={sys_payment_module_uri}/orders/|modules/?r={sys_payment_module_uri}/details/', 10, 'memb', '', '', 'bx_import(''BxDolPayments''); return BxDolPayments::getInstance()->isActive();', 3, 1, 1, 0, 1, 'custom', '', '', 0, '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_messages`
--

CREATE TABLE `sys_messages` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Sender` int(10) unsigned NOT NULL DEFAULT '0',
  `Recipient` int(10) unsigned NOT NULL DEFAULT '0',
  `Text` mediumtext NOT NULL,
  `Subject` varchar(255) NOT NULL DEFAULT '',
  `New` enum('0','1') NOT NULL DEFAULT '1',
  `Type` enum('letter','greeting') NOT NULL DEFAULT 'letter',
  `Trash` set('sender','recipient') NOT NULL,
  `TrashNotView` set('sender','recipient') NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `Pair` (`Sender`,`Recipient`),
  KEY `TrashNotView` (`TrashNotView`),
  KEY `Trash` (`Trash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_modules`
--

CREATE TABLE `sys_modules` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `vendor` varchar(64) NOT NULL DEFAULT '',
  `version` varchar(32) NOT NULL DEFAULT '',
  `update_url` varchar(128) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `uri` varchar(32) NOT NULL DEFAULT '',
  `class_prefix` varchar(32) NOT NULL DEFAULT '',
  `db_prefix` varchar(32) NOT NULL DEFAULT '',
  `dependencies` varchar(255) NOT NULL DEFAULT '',
  `date` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `path` (`path`),
  UNIQUE KEY `uri` (`uri`),
  UNIQUE KEY `class_prefix` (`class_prefix`),
  UNIQUE KEY `db_prefix` (`db_prefix`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_modules_file_tracks`
--

CREATE TABLE `sys_modules_file_tracks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `module_id` int(11) unsigned NOT NULL DEFAULT '0',
  `file` varchar(255) NOT NULL DEFAULT '',
  `hash` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_actions`
--

CREATE TABLE `sys_objects_actions` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Caption` varchar(100) NOT NULL,
  `Icon` varchar(100) NOT NULL,
  `Url` varchar(250) NOT NULL,
  `Script` varchar(250) NOT NULL,
  `Eval` text NOT NULL,
  `Order` int(5) NOT NULL,
  `Type` varchar(20) NOT NULL,
  `bDisplayInSubMenuHeader` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=26 ;

--
-- Dumping data for table `sys_objects_actions`
--

INSERT INTO `sys_objects_actions` VALUES
(1, '{evalResult}', 'edit', 'pedit.php?ID={ID}', '', 'if ({ID} == {member_id} || isAdmin({member_id}) || isModerator({member_id})) return _t(''{cpt_edit}'');', 1, 'Profile', 0),
(2, '{evalResult}', 'envelope', 'mail.php?mode=compose&recipient_id={ID}', '', 'if ({ID} == {member_id}) return;\r\nreturn _t(''{cpt_send_letter}'');', 2, 'Profile', 0),
(3, '{cpt_fave}', 'asterisk', '', '{evalResult}', 'return $GLOBALS[''oTopMenu'']->getScriptFaveAdd({ID}, {member_id});', 3, 'Profile', 0),
(4, '{cpt_remove_fave}', 'asterisk', '', '{evalResult}', 'return $GLOBALS[''oTopMenu'']->getScriptFaveCancel({ID}, {member_id});', 3, 'Profile', 0),
(5, '{cpt_befriend}', 'plus', '', '{evalResult}', 'return $GLOBALS[''oTopMenu'']->getScriptFriendAdd({ID}, {member_id});', 4, 'Profile', 0),
(6, '{cpt_remove_friend}', 'minus', '', '{evalResult}', 'return $GLOBALS[''oTopMenu'']->getScriptFriendCancel({ID}, {member_id}, false);', 4, 'Profile', 0),
(7, '{cpt_greet}', 'hand-o-right', '', '{evalResult}', 'if ({ID} == {member_id}) return;\r\n\r\nreturn "$.post(''greet.php'', { sendto: ''{ID}'' }, function(sData){ $(''#ajaxy_popup_result_div_{ID}'').html(sData) } );return false;";\r\n', 5, 'Profile', 0),
(8, '{cpt_get_mail}', 'envelope-o', '', '{evalResult}', 'if ({ID} == {member_id}) return;\r\n\r\n$bAnonymousMode  = ''{anonym_mode}'';\r\n\r\nif ( !$bAnonymousMode ) {\r\n    return "$.post(''freemail.php'', { ID: ''{ID}'' }, function(sData){ $(''#ajaxy_popup_result_div_{ID}'').html(sData) } );return false;";\r\n}\r\n', 6, 'Profile', 0),
(9, '{cpt_share}', 'share-square-o', '', 'return launchTellFriendProfile({ID});', '', 7, 'Profile', 0),
(10, '{cpt_report}', 'exclamation-circle', '', '{evalResult}', 'if ({ID} == {member_id}) return;\r\n\r\nreturn  "$.post(''list_pop.php?action=spam'', { ID: ''{ID}'' }, function(sData){ $(''#ajaxy_popup_result_div_{ID}'').html(sData) } );return false;";\r\n', 8, 'Profile', 0),
(11, '{cpt_block}', 'ban', '', '{evalResult}', 'if ( {ID} == {member_id} || isBlocked({member_id}, {ID}) ) return;\r\n\r\nreturn  "$.post(''list_pop.php?action=block'', { ID: ''{ID}'' }, function(sData){ $(''#ajaxy_popup_result_div_{ID}'').html(sData) } );return false;";\r\n', 9, 'Profile', 0),
(12, '{sbs_profile_title}', 'paperclip', '', '{sbs_profile_script}', '', 10, 'Profile', 0),
(13, '{cpt_unblock}', 'ban', '', '{evalResult}', 'if ({ID} == {member_id} || !isBlocked({member_id}, {ID}) ) return;\r\n\r\nreturn "$.post(''list_pop.php?action=unblock'', { ID: ''{ID}'' }, function(sData){ $(''#ajaxy_popup_result_div_{ID}'').html(sData) } );return false;";\r\n', 9, 'Profile', 0),
(14, '{cpt_activate}', 'check', '', 'getHtmlData(''ajaxy_popup_result_div_{ID}'', ''list_pop.php?action={act_activate}&ID={ID}'', false, ''post''); return false;', '', 11, 'Profile', 0),
(15, '{cpt_ban}', 'exclamation-circle', '', 'getHtmlData(''ajaxy_popup_result_div_{ID}'', ''list_pop.php?action={act_ban}&ID={ID}'', false, ''post''); return false;', '', 12, 'Profile', 0),
(16, '{cpt_delete}', 'times', '', 'getHtmlData(''ajaxy_popup_result_div_{ID}'', ''list_pop.php?action=delete&ID={ID}'', false, ''post'', true); return false;', '', 13, 'Profile', 0),
(17, '{cpt_delete_spam}', 'times', '', 'getHtmlData(''ajaxy_popup_result_div_{ID}'', ''list_pop.php?action=delete_spam&ID={ID}'', false, ''post'', true); return false;', '', 14, 'Profile', 0),
(18, '{cpt_feature}', 'asterisk', '', 'getHtmlData(''ajaxy_popup_result_div_{ID}'', ''list_pop.php?action={act_feature}&ID={ID}'', false, ''post''); return false;', '', 15, 'Profile', 0),
(19, '{evalResult}', 'plus', '{BaseUri}mail.php?mode=compose', '', 'return $GLOBALS[''logged''][''member''] || $GLOBALS[''logged''][''admin''] ? _t(''_sys_am_mailbox_compose'') : '''';', 1, 'Mailbox', 1),
(20, '{cpt_am_friend_add}', 'plus', '', '{evalResult}', 'return $GLOBALS[''oTopMenu'']->getScriptFriendAdd({ID}, {member_id}, false);', 1, 'ProfileTitle', 1),
(21, '{cpt_am_friend_accept}', 'plus', '', '{evalResult}', 'return $GLOBALS[''oTopMenu'']->getScriptFriendAccept({ID}, {member_id}, false);', 2, 'ProfileTitle', 1),
(22, '{cpt_am_friend_cancel}', 'minus', '', '{evalResult}', 'return $GLOBALS[''oTopMenu'']->getScriptFriendCancel({ID}, {member_id}, false);', 3, 'ProfileTitle', 1),
(23, '{cpt_am_profile_message}', 'envelope', '{evalResult}', '', 'return $GLOBALS[''oTopMenu'']->getUrlProfileMessage({ID});', 4, 'ProfileTitle', 1),
(24, '{cpt_am_profile_account_page}', 'tachometer', '{evalResult}', '', 'return $GLOBALS[''oTopMenu'']->getUrlAccountPage({ID});', 5, 'ProfileTitle', 1),
(25, '{cpt_am_account_profile_page}', 'user', '{evalResult}', '', 'return $GLOBALS[''oTopMenu'']->getUrlProfilePage({ID});', 1, 'AccountTitle', 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_auths`
--

CREATE TABLE `sys_objects_auths` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(64) NOT NULL,
  `Title` varchar(128) NOT NULL,
  `Link` varchar(255) NOT NULL,
  `OnClick` varchar(255) NOT NULL,
  `Icon` varchar(64) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_captcha`
--

CREATE TABLE `sys_objects_captcha` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(32) NOT NULL,
  `title` varchar(255) NOT NULL,
  `override_class_name` varchar(255) NOT NULL,
  `override_class_file` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_objects_captcha`
--

INSERT INTO `sys_objects_captcha` VALUES
(1, 'sys_recaptcha', 'reCAPTCHA', 'BxTemplCaptchaReCAPTCHA', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_categories`
--

CREATE TABLE `sys_objects_categories` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ObjectName` varchar(50) NOT NULL,
  `Query` text NOT NULL,
  `PermalinkParam` varchar(50) NOT NULL DEFAULT '',
  `EnabledPermalink` varchar(100) NOT NULL DEFAULT '',
  `DisabledPermalink` varchar(100) NOT NULL DEFAULT '',
  `LangKey` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_charts`
--

CREATE TABLE `sys_objects_charts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(32) NOT NULL,
  `title` varchar(255) NOT NULL,
  `table` varchar(255) NOT NULL,
  `field_date_ts` varchar(255) NOT NULL,
  `field_date_dt` varchar(255) NOT NULL,
  `column_date` int(11) NOT NULL DEFAULT '0',
  `column_count` int(11) NOT NULL DEFAULT '1',
  `type` varchar(255) NOT NULL,
  `options` text NOT NULL,
  `query` text NOT NULL,
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `order` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `sys_objects_charts`
--

INSERT INTO `sys_objects_charts` VALUES
(1, 'sys_profiles', '_Members', 'Profiles', '', 'DateReg', 0, 1, '', '', '', 1, 1),
(2, 'sys_subscribers', '_Subscribers', 'sys_sbs_users', 'date', '', 0, 1, '', '', '', 1, 2),
(3, 'sys_messages', '_Messages', 'sys_messages', '', 'Date', 0, 1, '', '', '', 1, 3),
(4, 'sys_greetings', '_Greetings', 'sys_greetings', '', 'When', 0, 1, '', '', '', 1, 4),
(5, 'sys_tags', '_Tags', 'sys_tags', '', 'Date', 0, 1, '', '', '', 1, 5),
(6, 'sys_categories', '_Categories', 'sys_categories', '', 'Date', 0, 1, '', '', '', 1, 6),
(7, 'sys_banners', '_adm_bann_clicks_chart', 'sys_banners_clicks', 'Date', '', 0, 1, '', '', '', 1, 7);

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_cmts`
--

CREATE TABLE `sys_objects_cmts` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ObjectName` varchar(50) NOT NULL,
  `TableCmts` varchar(50) NOT NULL,
  `TableTrack` varchar(50) NOT NULL,
  `AllowTags` smallint(1) NOT NULL,
  `Nl2br` smallint(1) NOT NULL,
  `SecToEdit` smallint(6) NOT NULL,
  `PerView` smallint(6) NOT NULL,
  `IsRatable` smallint(1) NOT NULL,
  `ViewingThreshold` smallint(6) NOT NULL,
  `AnimationEffect` varchar(50) NOT NULL,
  `AnimationSpeed` smallint(6) NOT NULL,
  `IsOn` smallint(1) NOT NULL,
  `IsMood` smallint(1) NOT NULL,
  `RootStylePrefix` varchar(16) NOT NULL DEFAULT 'cmt',
  `TriggerTable` varchar(32) NOT NULL,
  `TriggerFieldId` varchar(32) NOT NULL,
  `TriggerFieldComments` varchar(32) NOT NULL,
  `ClassName` varchar(32) NOT NULL,
  `ClassFile` varchar(256) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_objects_cmts`
--

INSERT INTO `sys_objects_cmts` VALUES
(1, 'profile', 'sys_cmts_profile', 'sys_cmts_track', 0, 1, 90, 5, 1, -3, 'none', 0, 1, 0, 'cmt', 'Profiles', 'ID', 'CommentsCount', 'BxDolCmtsProfile', 'inc/classes/BxDolCmtsProfile.php');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_editor`
--

CREATE TABLE `sys_objects_editor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(32) NOT NULL,
  `title` varchar(255) NOT NULL,
  `skin` varchar(255) NOT NULL,
  `override_class_name` varchar(255) NOT NULL,
  `override_class_file` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_objects_editor`
--

INSERT INTO `sys_objects_editor` VALUES
(1, 'sys_tinymce', 'TinyMCE', 'lightgray', 'BxTemplEditorTinyMCE', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_exports`
--

CREATE TABLE `sys_objects_exports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(32) NOT NULL,
  `title` varchar(255) NOT NULL,
  `class_name` varchar(255) NOT NULL,
  `class_file` varchar(255) NOT NULL,
  `order` tinyint(4) NOT NULL,
  `active` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `sys_objects_exports`
--

INSERT INTO `sys_objects_exports` VALUES
(1, 'profiles', '_Profiles', 'BxDolExportProfile', '', 1, 1),
(2, 'flash', '_adm_admtools_Flash', 'BxDolExportFlash', '', 2, 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_member_info`
--

CREATE TABLE `sys_objects_member_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(32) NOT NULL,
  `title` varchar(255) NOT NULL,
  `type` varchar(32) NOT NULL,
  `override_class_name` varchar(255) NOT NULL,
  `override_class_file` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `sys_objects_member_info`
--

INSERT INTO `sys_objects_member_info` VALUES
(1, 'sys_username', '_sys_member_info_username', 'name', '', ''),
(2, 'sys_full_name', '_sys_member_info_full_name', 'name', '', ''),
(3, 'sys_status_message', '_sys_member_info_status_message', 'info', '', ''),
(4, 'sys_age_sex', '_sys_member_info_age_sex', 'info', '', ''),
(5, 'sys_location', '_sys_member_info_location', 'info', '', ''),
(6, 'sys_avatar', '_sys_member_thumb_avatar', 'thumb', '', ''),
(7, 'sys_avatar_2x', '_sys_member_thumb_avatar_2x', 'thumb_2x', '', ''),
(8, 'sys_avatar_icon', '_sys_member_thumb_icon_avatar', 'thumb_icon', '', ''),
(9, 'sys_avatar_icon_2x', '_sys_member_thumb_icon_avatar_2x', 'thumb_icon_2x', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_payments`
--

CREATE TABLE `sys_objects_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(32) NOT NULL,
  `title` varchar(255) NOT NULL,
  `uri` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`),
  UNIQUE KEY `uri` (`uri`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_search`
--

CREATE TABLE `sys_objects_search` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ObjectName` varchar(50) NOT NULL DEFAULT '',
  `Title` varchar(50) NOT NULL DEFAULT '',
  `ClassName` varchar(50) NOT NULL DEFAULT '',
  `ClassPath` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `sys_objects_search`
--

INSERT INTO `sys_objects_search` VALUES
(3, 'profile', '_Profiles', 'BxTemplSearchProfile', 'templates/tmpl_{tmpl}/scripts/BxTemplSearchProfile.php');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_site_maps`
--

CREATE TABLE `sys_objects_site_maps` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(32) NOT NULL,
  `title` varchar(255) NOT NULL,
  `priority` varchar(5) NOT NULL DEFAULT '0.6',
  `changefreq` enum('always','hourly','daily','weekly','monthly','yearly','never','auto') NOT NULL DEFAULT 'auto',
  `class_name` varchar(255) NOT NULL,
  `class_file` varchar(255) NOT NULL,
  `order` tinyint(4) NOT NULL,
  `active` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `sys_objects_site_maps`
--

INSERT INTO `sys_objects_site_maps` VALUES
(1, 'system', '_sys_sitemap_system', '0.6', 'weekly', 'BxDolSiteMapsSystem', '', 1, 1),
(2, 'profiles', '_sys_sitemap_profiles', '0.8', 'daily', 'BxDolSiteMapsProfiles', '', 2, 1),
(3, 'profiles_info', '_sys_sitemap_profiles_info', '0.8', 'daily', 'BxDolSiteMapsProfilesInfo', '', 3, 1),
(4, 'pages', '_sys_sitemap_pages', '0.8', 'weekly', 'BxDolSiteMapsPages', '', 4, 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_social_sharing`
--

CREATE TABLE `sys_objects_social_sharing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(32) NOT NULL,
  `content` text NOT NULL,
  `order` int(11) NOT NULL,
  `active` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `sys_objects_social_sharing`
--

INSERT INTO `sys_objects_social_sharing` VALUES
(1, 'facebook', '<iframe src="//www.facebook.com/plugins/like.php?href={url_encoded}&amp;send=false&amp;layout=button_count&amp;width=450&amp;show_faces=false&amp;action=like&amp;colorscheme=light&amp;font&amp;height=21&amp;locale={locale}" scrolling="no" frameborder="0" style="border:none; overflow:hidden; width:100%; height:21px;" allowTransparency="true"></iframe>', 1, 1),
(2, 'twitter', '<iframe allowtransparency="true" frameborder="0" scrolling="no" src="//platform.twitter.com/widgets/tweet_button.html?url={url_encoded}&amp;text={title_encoded}&amp;size=medium&amp;count=horizontal&amp;lang={lang}" style="width:100%;height:21px;"></iframe>', 3, 1),
(3, 'pinterest', '<a href="http://pinterest.com/pin/create/button/?url={url_encoded}&media={img_url_encoded}&description={title_encoded}" class="pin-it-button" count-layout="horizontal"><img border="0" src="//assets.pinterest.com/images/PinExt.png" title="Pin It" /></a>\r\n\r\n<script type="text/javascript" src="//assets.pinterest.com/js/pinit.js"></script>', 4, 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_tag`
--

CREATE TABLE `sys_objects_tag` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ObjectName` varchar(50) NOT NULL,
  `Query` text NOT NULL,
  `PermalinkParam` varchar(50) NOT NULL DEFAULT '',
  `EnabledPermalink` varchar(100) NOT NULL DEFAULT '',
  `DisabledPermalink` varchar(100) NOT NULL DEFAULT '',
  `LangKey` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_objects_tag`
--

INSERT INTO `sys_objects_tag` VALUES
(1, 'profile', 'SELECT `Tags` FROM `Profiles` WHERE `ID` = {iID} AND `Status` = ''Active''', 'enable_modrewrite', 'search/tag/{tag}', 'search.php?Tags={tag}', '_Profiles');

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_views`
--

CREATE TABLE `sys_objects_views` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `table_track` varchar(32) NOT NULL,
  `period` int(11) NOT NULL DEFAULT '86400',
  `trigger_table` varchar(32) NOT NULL,
  `trigger_field_id` varchar(32) NOT NULL,
  `trigger_field_views` varchar(32) NOT NULL,
  `is_on` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_objects_views`
--

INSERT INTO `sys_objects_views` VALUES
(1, 'profiles', 'sys_profile_views_track', 86400, 'Profiles', 'ID', 'Views', 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_objects_vote`
--

CREATE TABLE `sys_objects_vote` (
  `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ObjectName` varchar(50) NOT NULL,
  `TableRating` varchar(50) NOT NULL,
  `TableTrack` varchar(50) NOT NULL,
  `RowPrefix` varchar(20) NOT NULL,
  `MaxVotes` smallint(2) NOT NULL,
  `PostName` varchar(50) NOT NULL,
  `IsDuplicate` varchar(80) NOT NULL,
  `IsOn` smallint(1) NOT NULL,
  `className` varchar(50) NOT NULL DEFAULT '',
  `classFile` varchar(100) NOT NULL DEFAULT '',
  `TriggerTable` varchar(32) NOT NULL,
  `TriggerFieldRate` varchar(32) NOT NULL,
  `TriggerFieldRateCount` varchar(32) NOT NULL,
  `TriggerFieldId` varchar(32) NOT NULL,
  `OverrideClassName` varchar(32) NOT NULL,
  `OverrideClassFile` varchar(256) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_objects_vote`
--

INSERT INTO `sys_objects_vote` VALUES
(1, 'profile', 'sys_profile_rating', 'sys_profile_voting_track', 'pr_', 5, 'vote_send_result', 'BX_PERIOD_PER_VOTE', 1, '', '', 'Profiles', 'Rate', 'RateCount', 'ID', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_options`
--

CREATE TABLE `sys_options` (
  `Name` varchar(64) NOT NULL DEFAULT '',
  `VALUE` mediumtext NOT NULL,
  `kateg` int(6) unsigned NOT NULL DEFAULT '0',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `Type` enum('digit','text','checkbox','select','select_multiple','file','list') NOT NULL DEFAULT 'digit',
  `check` text NOT NULL,
  `err_text` varchar(255) NOT NULL DEFAULT '',
  `order_in_kateg` float DEFAULT NULL,
  `AvailableValues` text NOT NULL,
  PRIMARY KEY (`Name`),
  KEY `kateg` (`kateg`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_options`
--

INSERT INTO `sys_options` VALUES
('enable_global_couple', '', 1, 'Enable couple profiles', 'checkbox', '', '', 10, ''),
('votes', 'on', 1, 'Enable profile rating', 'checkbox', '', '', 20, ''),
('zodiac', '', 1, 'Enable zodiac signs', 'checkbox', '', '', 30, ''),
('anon_mode', '', 1, 'Enable anonymous mode', 'checkbox', '', '', 40, ''),
('reg_by_inv_only', '', 1, 'Enable registration by invitation only', 'checkbox', '', '', 50, ''),
('enable_cmts_profile_delete', '', 1, 'Allow profile comments deletion by profile owner', 'checkbox', '', '', 60, ''),
('member_online_time', '1', 1, 'Online status timeframe (minutes)', 'digit', 'return (int)$arg0 > 0;', 'Must be > 0', 70, ''),
('search_start_age', '18', 1, 'Lowest age possible for site members', 'digit', 'return setSearchStartAge((int)$arg0);', '', 80, ''),
('search_end_age', '75', 1, 'Highest age possible for site members', 'digit', 'return setSearchEndAge((int)$arg0);', '', 90, ''),
('friends_per_page', '14', 1, 'Number of friends displayed per page in profile', 'digit', '', '', 100, ''),
('featured_num', '8', 1, 'Number of Featured Members per page', 'digit', '', '', 110, ''),
('top_members_max_num', '8', 1, 'Number of Top Members per page', 'digit', '', '', 120, ''),
('sys_member_info_name', 'sys_username', 1, 'Member display-name', 'select', '', '', 130, 'PHP:bx_import(''BxDolMemberInfoQuery''); return BxDolMemberInfoQuery::getMemberInfoKeysByType(''name'');'),
('sys_member_info_info', 'sys_status_message', 1, 'Member brief info', 'select', '', '', 140, 'PHP:bx_import(''BxDolMemberInfoQuery''); return BxDolMemberInfoQuery::getMemberInfoKeysByType(''info'');'),
('sys_member_info_thumb', 'sys_avatar', 1, 'Member thumb', 'select', '', '', 150, 'PHP:bx_import(''BxDolMemberInfoQuery''); return BxDolMemberInfoQuery::getMemberInfoKeysByType(''thumb'');'),
('sys_member_info_thumb_icon', 'sys_avatar_icon', 1, 'Member thumb icon', 'select', '', '', 160, 'PHP:bx_import(''BxDolMemberInfoQuery''); return BxDolMemberInfoQuery::getMemberInfoKeysByType(''thumb_icon'');'),
('sys_ftp_host', '', 3, 'FTP host', 'digit', '', '', 1, ''),
('sys_ftp_login', '', 3, 'FTP login', 'digit', '', '', 2, ''),
('sys_ftp_password', '', 3, 'FTP password', 'digit', '', '', 3, ''),
('sys_ftp_dir', '', 3, 'Path to Dolphin on FTP server', 'digit', '', '', 4, ''),
('MetaDescription', '[[site_desc]]', 3, 'Homepage meta-description', 'text', '', '', 10, ''),
('MetaKeyWords', '', 3, 'Homepage meta-keywords', 'text', '', '', 20, ''),
('enable_tiny_in_comments', '', 3, 'Enable WYSIWYG editor in comments', 'checkbox', '', '', 30, ''),
('sys_make_album_cover_last', 'on', 3, 'Enable last-added item as album cover', 'checkbox', '', '', 70, ''),
('sys_album_default_name', 'Hidden', 3, 'Default album name', 'digit', '', '', 80, ''),
('news_enable', 'on', 3, 'Enable BoonEx News in Admin', 'checkbox', '', '', 90, ''),
('feeds_enable', 'on', 3, 'Enable BoonEx Market Feeds in Admin', 'checkbox', '', '', 100, ''),
('enable_contact_form', 'on', 3, 'Enable contact form', 'checkbox', '', '', 110, ''),
('default_country', 'US', 3, 'Default country', 'digit', '', '', 120, ''),
('boonexAffID', '', 3, 'BoonEx affiliate ID', 'digit', '', '', 140, ''),
('enable_gd', 'on', 3, 'Enable GD library for image processing', 'checkbox', '', '', 150, ''),
('useLikeOperator', 'on', 3, 'Disable full-text search', 'checkbox', '', '', 160, ''),
('sys_default_payment', '', 3, 'Payment module (at least one payment processing module should be installed)', 'select', '', '', 170, 'PHP:bx_import(''BxDolPayments''); return BxDolPayments::getInstance()->getPayments();'),
('sys_embedly_key', '', 3, 'Embedly Key', 'digit', '', '', 180, ''),
('msgs_per_start', '20', 4, 'Number of emails to send from queue per run, it happens every 5m-1h', 'digit', '', '', 10, ''),
('expire_notify_once', 'on', 5, 'Notify members about membership expiration only once (every day otherwise)', 'checkbox', '', '', 10, ''),
('expire_notification_days', '1', 5, 'Number of days before membership expiration to notify members (-1 = after expiration)', 'digit', '', '', 20, ''),
('enable_promotion_membership', '', 5, 'Enable promotional membership', 'checkbox', '', '', 30, ''),
('promotion_membership_days', '7', 5, 'Number of days for promotional membership', 'digit', '', '', 40, ''),
('autoApproval_ifJoin', '', 6, 'Auto-activate profiles after joining', 'checkbox', '', '', 10, ''),
('autoApproval_ifProfile', 'on', 6, 'Preserve profile status after profile info editing', 'checkbox', '', '', 20, ''),
('autoApproval_ifNoConfEmail', '', 6, 'Auto-confirm profile without confirmation email', 'checkbox', '', '', 30, ''),
('newusernotify', 'on', 6, 'Enable notification about new members', 'checkbox', '', '', 40, ''),
('unregisterusernotify', 'on', 6, 'Enable notification about unregistered members', 'checkbox', '', '', 50, ''),
('ban_duration', '10', 6, 'Profile ban duration (in days)', 'digit', '', '', 60, ''),
('site_email', '[[admin_email]]', 7, 'Site Email', 'digit', '', '', 10, ''),
('site_title', '[[site_name]]', 7, 'Site Title', 'digit', '', '', 20, ''),
('site_email_notify', '[[noreply_email]]', 7, 'Email to send site''s mail from', 'digit', '', '', 30, ''),
('site_timezone', 'UTC', 7, 'Site Timezone', 'select', '', '', 40, 'PHP:return array_combine(timezone_identifiers_list(), timezone_identifiers_list());'),
('sys_ps_enable_create_group', '', 9, 'Enable ''Create New Privacy Group''', 'checkbox', '', '', 10, ''),
('sys_ps_enable_default_values', '', 9, 'Enable ''Default Values''', 'checkbox', '', '', 20, ''),
('sys_ps_enabled_group_1', '', 9, 'Enable ''Default'' group', 'checkbox', '', '', 30, ''),
('sys_ps_enabled_group_2', 'on', 9, 'Enable ''Me Only'' group', 'checkbox', '', '', 40, ''),
('sys_ps_enabled_group_3', 'on', 9, 'Enable ''Public'' group', 'checkbox', '', '', 50, ''),
('sys_ps_enabled_group_4', 'on', 9, 'Enable ''Members'' group', 'checkbox', '', '', 60, ''),
('sys_ps_enabled_group_5', 'on', 9, 'Enable ''Friends'' group', 'checkbox', '', '', 70, ''),
('sys_ps_enabled_group_6', '', 9, 'Enable ''Faves'' group', 'checkbox', '', '', 80, ''),
('sys_ps_enabled_group_7', '', 9, 'Enable ''Contacts'' group', 'checkbox', '', '', 90, ''),
('db_clean_msg', '365', 11, 'Delete messages older than (days)', 'digit', '', '', 10, ''),
('db_clean_profiles', '0', 11, 'Delete profiles of members that didn''t login for (days)', 'digit', '', '', 20, ''),
('db_clean_members_visits', '90', 11, 'Delete stored members IPs older than (days)', 'digit', '', '', 30, ''),
('db_clean_banners_info', '60', 11, 'Delete banner views and clicks data older than (days)', 'digit', '', '', 40, ''),
('db_clean_vkiss', '90', 11, 'Delete greeting older than (days)', 'digit', '', '', 50, ''),
('db_clean_mem_levels', '30', 11, 'Delete membership levels expired for (days)', 'digit', '', '', 60, ''),
('enable_match', '', 12, 'Enable matchmaking', 'checkbox', '', '', 10, ''),
('view_match_percent', '', 12, 'Enable match percentage display', 'checkbox', '', '', 20, ''),
('match_percent', '85', 12, 'Match percentage threshold for email notification (0-100)', 'digit', '', '', 30, ''),
('template', 'evo', 13, 'Default template', 'select', 'global $dir; return (strlen($arg0) > 0 && file_exists($dir["root"]."templates/tmpl_".$arg0) ) ? true : false;', 'Template can not be empty and must be valid', 10, 'PHP:$aValues = get_templates_array(); $aResult = array(); foreach($aValues as $sKey => $sValue) $aResult[] = array(''key'' => $sKey, ''value'' => $sValue); return $aResult;'),
('enable_template', 'on', 13, 'Allow users to choose templates', 'checkbox', '', '', 20, ''),
('nav_menu_elements_on_line_usr', '14', 13, 'Number of main menu tabs visible to members outside of "more" tab', 'digit', '', '', 30, ''),
('nav_menu_elements_on_line_gst', '14', 13, 'Number of main menu tabs visible to guests outside of "more" tab', 'digit', '', '', 40, ''),
('sys_template_page_width_min', '774', 13, 'Minimal allowed page width (pixels)', 'digit', '', '', 50, ''),
('sys_template_page_width_max', '1600', 13, 'Maximal allowed page width (pixels)', 'digit', '', '', 60, ''),
('ext_nav_menu_enabled', 'on', 13, 'Enable member menu', 'checkbox', '', '', 70, ''),
('ext_nav_menu_top_position', 'bottom', 13, 'Default position of member menu', 'select', '', '', 80, 'top,bottom,static'),
('sys_security_form_token_enable', 'on', 14, 'Enable CSRF token in forms', 'checkbox', '', '', 30, ''),
('sys_security_form_token_lifetime', '86400', 14, 'CSRF token lifetime (seconds, 0 - no tracking)', 'digit', '', '', 40, ''),
('sys_recaptcha_key_public', '', 14, 'reCAPTCHA public key', 'digit', '', '', 50, ''),
('sys_recaptcha_key_private', '', 14, 'reCAPTCHA private key', 'digit', '', '', 60, ''),
('sys_safe_iframe_regexp', '%^(https?:)?//(www.youtube(?:-nocookie)?.com/embed/|player.vimeo.com/video/)%', 14, 'Safe iframe URI regular expression (don''t edit if unsure)', 'text', '', '', 100, ''),
('enable_watermark', '', 16, 'Enable Watermark', 'checkbox', '', '', 10, ''),
('transparent1', '0', 16, 'Transparency for first image', 'digit', '', '', 20, ''),
('Water_Mark', '', 16, 'Water Mark', 'file', '', '', 30, ''),
('lang_default', 'en', 21, 'Default site language', 'text', '', '', 1, ''),
('lang_subst_from_en', 'on', 21, 'Substitute (during compilation) missing translations with english ones', 'checkbox', '', '', 2, ''),
('sys_calendar_starts_sunday', '', 21, 'Enable Sunday as the first weekday', 'checkbox', '', '', 30, ''),
('time_format_php', 'H:i', 21, 'Time format (for code)', 'digit', '', '', 40, ''),
('short_date_format_php', 'd.m.Y', 21, 'Short date format (for code)', 'digit', '', '', 50, ''),
('date_format_php', 'd.m.Y H:i', 21, 'Long date format (for code)', 'digit', '', '', 60, ''),
('time_format', '%H:%i', 21, 'Time format (for database)', 'digit', '', '', 70, ''),
('short_date_format', '%d.%m.%Y', 21, 'Short date format (for database)', 'digit', '', '', 80, ''),
('date_format', '%d.%m.%Y %H:%i', 21, 'Long date format (for database)', 'digit', '', '', 90, ''),
('enable_member_store_ip', 'on', 22, 'Enable member IP tracking', 'checkbox', '', '', 10, ''),
('ipBlacklistMode', '2', 22, 'IP blacklist mode (1 - total block, 2 - login block)', 'digit', '', '', 20, ''),
('ipListGlobalType', '0', 22, 'IP list type (0 - disabled, 1 - all allowed except listed, 2 - all blocked except listed)', 'digit', '', '', 30, ''),
('sys_dnsbl_enable', 'on', 23, 'Enable DNS Block Lists', 'checkbox', '', '', 10, ''),
('sys_dnsbl_behaviour', 'approval', 23, 'User join behaviour if listed in DNS Block Lists', 'select', '', '', 11, 'block,approval'),
('sys_uridnsbl_enable', 'on', 23, 'Enable URI DNS Block Lists', 'checkbox', '', '', 20, ''),
('sys_akismet_enable', '', 23, 'Enable Akismet', 'checkbox', '', '', 30, ''),
('sys_akismet_api_key', '', 23, 'Akismet API Key', 'digit', '', '', 40, ''),
('sys_stopforumspam_enable', 'on', 23, 'Enable "Stop Forum Spam"', 'checkbox', '', '', 45, ''),
('sys_stopforumspam_api_key', '', 23, '"Stop Forum Spam" API Key', 'digit', '', '', 46, ''),
('sys_antispam_block', '', 23, 'Total block all spam content', 'checkbox', '', '', 50, ''),
('sys_antispam_report', 'on', 23, 'Send report to admin if spam content discovered', 'checkbox', '', '', 60, ''),
('sys_antispam_smart_check', 'on', 23, 'Smart antispam check', 'checkbox', '', '', 70, ''),
('sys_antispam_add_nofollow', 'on', 23, 'Add "nofollow" attribute for external links', 'checkbox', '', '', 80, ''),
('enable_cache_system', 'on', 24, 'Enable cache for profiles information', 'checkbox', '', '', 10, ''),
('sys_db_cache_enable', 'on', 24, 'Enable DB cache', 'checkbox', '', '', 20, ''),
('sys_db_cache_engine', 'File', 24, 'DB cache engine (other than File option may require custom server setup)', 'select', '', '', 30, 'File,Memcache,APC,XCache'),
('sys_cache_memcache_host', '', 24, 'Memcached server host', 'digit', '', '', 40, ''),
('sys_cache_memcache_port', '11211', 24, 'Memcached server port', 'digit', '', '', 50, ''),
('sys_pb_cache_enable', 'on', 24, 'Enable page blocks cache', 'checkbox', '', '', 60, ''),
('sys_pb_cache_engine', 'File', 24, 'Page blocks cache engine (other than File option may require custom server setup)', 'select', '', '', 70, 'File,Memcache,APC,XCache'),
('sys_mm_cache_engine', 'File', 24, 'Member menu cache engine (other than File option may require custom server setup)', 'select', '', '', 80, 'File,Memcache,APC,XCache'),
('sys_template_cache_enable', 'on', 24, 'Enable cache for HTML files', 'checkbox', '', '', 90, ''),
('sys_template_cache_engine', 'FileHtml', 24, 'Template cache engine (other than FileHtml option may require custom server setup)', 'select', '', '', 100, 'FileHtml,Memcache,APC,XCache'),
('sys_template_cache_css_enable', 'on', 24, 'Enable cache for CSS files', 'checkbox', '', '', 110, ''),
('sys_template_cache_js_enable', 'on', 24, 'Enable cache for JS files', 'checkbox', '', '', 120, ''),
('sys_template_cache_compress_enable', 'on', 24, 'Enable compression for JS/CSS files(cache must be enabled)', 'checkbox', '', '', 130, ''),
('tags_non_parsable', 'hi, hey, hello, all, i, i''m, i''d, am, for, in, to, a, the, on, it''s, is, my, of, are, from, i''m, me, you, and, we, not, will, at, where, there', 25, 'Ignored words (lower case, comma-separated)', 'text', '', '', 10, ''),
('tags_min_rating', '2', 25, 'Minimum tag repeats to display for browsing', 'digit', '', '', 20, ''),
('tags_perpage_browse', '30', 25, 'Number of tags per page displayed for browsing', 'digit', '', '', 30, ''),
('tags_show_limit', '50', 25, 'Number of hot tags displayed for browsing', 'digit', '', '', 40, ''),
('enable_modrewrite', 'on', 26, 'Enable friendly profile permalinks', 'checkbox', '', '', 10, ''),
('permalinks_browse', 'on', 26, 'Enable friendly browse permalinks', 'checkbox', '', '', 20, ''),
('categ_perpage_browse', '30', 27, 'Number of categories to show on browse pages', 'digit', '', '', 10, ''),
('categ_show_limit', '50', 27, 'Number of categories to show limit', 'digit', '', '', 20, ''),
('categ_show_columns', '3', 27, 'Number of columns to show categories', 'digit', '', '', 30, ''),
('sys_tmp_version', '7.4.2', 0, 'Dolphin version ', 'digit', '', '', 10, ''),
('license_code', '', 0, 'Dolphin License Code', 'digit', '', '', 11, ''),
('license_expiration', '', 0, 'Dolphin License Expiration', 'digit', '', '', 12, ''),
('license_checksum', '', 0, 'Dolphin License Checksum', 'digit', '', '', 13, ''),
('enable_dolphin_footer', 'on', 0, 'Enable BoonEx Footers', 'checkbox', '', '', 14, ''),
('splash_editor', 'on', 0, '', 'checkbox', '', '', 30, ''),
('splash_code', '<div class="bx-splash bx-def-round-corners" style="background-image: url(templates/base/images/bx_splash_image.jpg);"><div class="bx-splash-txt"><div class="bx-splash-txt-cnt"><div class="bx-splash-txt-l1 bx-def-padding-sec-leftright"><h1 class="bx-cd-headline zoom"><span class="bx-cd-words-wrapper"><b class="bx-cd-word is-visible">Be The Gift You Bring!</b><b class="bx-cd-word">Be The Gift You Bring!</b><b class="bx-cd-word">Be The Gift You Bring!</b></span></h1></div><div class="bx-splash-actions bx-hide-when-logged-in"><button class="bx-btn bx-btn-primary bx-btn-sa-join">Join</button><button class="bx-btn bx-def-margin-left bx-btn-sa-login">Login</button></div></div></div></div>', 0, '', 'text', '', '', 31, ''),
('splash_visibility', 'index', 0, '', 'text', '', '', 32, ''),
('splash_logged', 'on', 0, '', 'checkbox', '', '', 33, ''),
('cmdDay', '10', 0, '', 'digit', '', '', 50, ''),
('tags_last_parse_time', '0', 0, 'Temporary value when tags cron-job was runed last time', 'digit', '', '', 51, ''),
('cupid_last_cron', '0', 0, 'Temporary value when cupid mails checked was runed last time', 'text', '', '', 52, ''),
('sys_show_admin_help', 'on', 0, 'Show help in admin dashboard', 'checkbox', '', '', 53, ''),
('sys_cron_time', '', 0, 'Last cron execution time', 'digit', '', '', 54, ''),
('sys_main_logo', '', 0, 'Main logo file name', 'text', '', '', 60, ''),
('sys_main_logo_w', '', 0, 'Main logo width', 'digit', '', '', 61, ''),
('sys_main_logo_h', '', 0, 'Main logo height', 'digit', '', '', 62, ''),
('main_div_width', '1140px', 0, 'Width of the main container of the site', 'digit', '', '', 65, ''),
('sys_template_cache_image_enable', '', 0, 'Enable cache for images (do not work for IE7)', 'checkbox', '', '', 70, ''),
('sys_template_cache_image_max_size', '5', 0, 'Max image size to be cached(in kb)', 'digit', '', '', 71, ''),
('sys_sitemap_enable', '', 0, 'Enable sitemap generation', 'checkbox', '', '', 80, ''),
('sys_captcha_default', 'sys_recaptcha', 0, 'Default CAPTCHA', 'digit', '', '', 90, ''),
('sys_editor_default', 'sys_tinymce', 0, 'Default HTML editor', 'digit', '', '', 91, '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_options_cats`
--

CREATE TABLE `sys_options_cats` (
  `ID` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `menu_order` float DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=100 ;

--
-- Dumping data for table `sys_options_cats`
--

INSERT INTO `sys_options_cats` VALUES
(1, 'Profiles', 1),
(3, 'General', 3),
(4, 'Massmailer', 4),
(5, 'Memberships', 5),
(6, 'Moderation', 6),
(7, 'Site', 7),
(9, 'Privacy Groups', 9),
(11, 'Pruning', 11),
(12, 'Matches', 12),
(13, 'Template', 13),
(14, 'Security', 14),
(16, 'Watermark', 16),
(21, 'Languages', 21),
(22, 'IP Block List', 22),
(23, 'Antispam', 23),
(24, 'Caching', 24),
(25, 'Tags Settings', 25),
(26, 'Permalinks', 26),
(27, 'Categories Settings', 27);

-- --------------------------------------------------------

--
-- Table structure for table `sys_page_compose`
--

CREATE TABLE `sys_page_compose` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `Page` varchar(255) NOT NULL DEFAULT '',
  `PageWidth` varchar(10) NOT NULL DEFAULT '1140px',
  `Desc` text NOT NULL,
  `Caption` varchar(255) NOT NULL DEFAULT '',
  `Column` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `Order` smallint(6) unsigned NOT NULL DEFAULT '0',
  `Func` varchar(255) NOT NULL DEFAULT '',
  `Content` text NOT NULL,
  `DesignBox` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `ColWidth` float unsigned NOT NULL DEFAULT '0',
  `Visible` set('non','memb') NOT NULL DEFAULT 'non,memb',
  `MinWidth` int(10) unsigned NOT NULL DEFAULT '0',
  `Cache` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=71 ;

--
-- Dumping data for table `sys_page_compose`
--

INSERT INTO `sys_page_compose` VALUES
(1, '', '1140px', 'RSS Feed', '_RSS Feed', 0, 0, 'Sample', 'RSS', 1, 0, 'non,memb', 0, 0),
(2, '', '1140px', 'Simple HTML Block', '_HTML Block', 0, 0, 'Sample', 'Echo', 11, 0, 'non,memb', 0, 0),
(3, '', '1140px', 'Simple Text Block', '_Text Block', 0, 0, 'Sample', 'Text', 11, 0, 'non,memb', 0, 0),
(4, 'index', '1140px', 'Shows statistic information about your site content', '_Site Stats', 2, 2, 'SiteStats', '', 1, 28.1, 'non,memb', 0, 3600),
(5, 'index', '1140px', 'Display form to subscribe to newsletters', '_Subscribe_block_caption', 2, 1, 'Subscribe', '', 1, 28.1, 'non,memb', 0, 0),
(6, 'index', '1140px', 'Quick search form', '_Quick Search', 0, 0, 'QuickSearch', '', 1, 28.1, 'non,memb', 0, 0),
(7, 'index', '1140px', 'List of featured profiles', '_featured members', 0, 0, 'Featured', '', 1, 71.9, 'non,memb', 0, 0),
(8, 'index', '1140px', 'Site Tags', '_Tags', 0, 0, 'Tags', '', 1, 71.9, 'non,memb', 0, 0),
(9, 'index', '1140px', 'Site Categories', '_Categories', 0, 0, 'Categories', '', 1, 71.9, 'non,memb', 0, 0),
(10, 'index', '1140px', 'List of profiles', '_Members', 2, 0, 'Members', '', 1, 28.1, 'non,memb', 0, 0),
(11, 'index', '1140px', 'Shows Login Form', '_Member_Login', 0, 0, 'LoginSection', '', 11, 28.1, 'non', 0, 86400),
(12, 'index', '1140px', '', '_BoonEx News', 1, 0, 'RSS', 'https://www.boonex.com/notes/featured_posts/?rss=1#4', 1, 71.9, 'non,memb', 0, 86400),
(13, 'index', '1140px', 'Download', '_sys_box_title_download', 0, 0, 'Download', '', 1, 28.1, 'non,memb', 0, 86400),
(14, 'member', '1140px', 'Quick Links', '_Quick Links', 1, 0, 'QuickLinks', '', 1, 71.9, 'memb', 0, 0),
(15, 'member', '1140px', 'Friend Requests', '_sys_bcpt_member_friend_requests', 2, 1, 'FriendRequests', '', 1, 28.1, 'memb', 0, 0),
(16, 'member', '1140px', 'New Messages', '_sys_bcpt_member_new_messages', 2, 2, 'NewMessages', '', 1, 28.1, 'memb', 0, 0),
(17, 'member', '1140px', 'Account Control', '_sys_bcpt_member_account_control', 2, 3, 'AccountControl', '', 1, 28.1, 'memb', 0, 0),
(18, 'member', '1140px', 'Member Friends', '_My Friends', 0, 0, 'Friends', '', 1, 28.1, 'memb', 0, 0),
(19, 'profile', '1140px', 'Profile cover', '_sys_bcpt_profile_cover', 1, 1, 'Cover', '', 0, 100, 'non,memb', 0, 0),
(20, 'profile', '1140px', 'Profile actions', '_Actions', 2, 2, 'ActionsMenu', '', 1, 28.1, 'non,memb', 0, 0),
(21, 'profile', '1140px', 'Friend request notification', '_FriendRequest', 2, 3, 'FriendRequest', '', 1, 28.1, 'memb', 0, 0),
(22, 'profile', '1140px', 'Profile description block', '_Description', 3, 2, 'Description', '', 1, 71.9, 'non,memb', 0, 0),
(23, 'profile', '1140px', 'Profile Fields Block', '_FieldCaption_Admin Controls_View', 2, 4, 'PFBlock', '21', 1, 28.1, 'non,memb', 0, 0),
(24, 'profile', '1140px', 'Profile Fields Block', '_FieldCaption_General Info_View', 2, 5, 'PFBlock', '17', 1, 28.1, 'non,memb', 0, 0),
(25, 'profile', '1140px', 'Profile rating form', '_rate profile', 2, 6, 'RateProfile', '', 1, 28.1, 'non,memb', 0, 0),
(26, 'profile', '1140px', 'Member friends list', '_Friends', 0, 0, 'Friends', '', 1, 71.9, 'non,memb', 0, 0),
(27, 'profile', '1140px', 'Mutual friends of viewing and viewed members', '_Mutual Friends', 0, 0, 'MutualFriends', '', 1, 71.9, 'non,memb', 0, 0),
(28, 'profile', '1140px', 'Comments on member profile', '_profile_comments', 0, 0, 'Cmts', '', 1, 71.9, 'non,memb', 0, 0),
(29, 'profile', '1140px', 'Profile Fields Block', '_FieldCaption_Misc_View', 0, 0, 'PFBlock', '20', 1, 71.9, 'non,memb', 0, 0),
(30, 'profile_info', '1140px', '', '_FieldCaption_General Info_View', 1, 0, 'GeneralInfo', '', 1, 100, 'non,memb', 0, 0),
(31, 'profile_info', '1140px', '', '_Additional information', 1, 2, 'AdditionalInfo', '', 1, 100, 'non,memb', 0, 0),
(32, 'profile_info', '1140px', 'Profile''s description', '_Description', 1, 1, 'Description', '', 1, 100, 'non,memb', 0, 0),
(33, 'friends', '1140px', '', '_Member Friends', 1, 1, 'Friends', '', 1, 71.9, 'non,memb', 0, 0),
(34, 'friends', '1140px', '', '_Member Friends Requests', 2, 1, 'FriendsRequests', '', 1, 28.1, 'memb', 0, 0),
(35, 'friends', '1140px', '', '_Member Friends Mutual', 2, 2, 'FriendsMutual', '', 1, 28.1, 'memb', 0, 0),
(36, 'browse_page', '1140px', '', '_Browse', 2, 0, 'SettingsBlock', '', 0, 28.1, 'non,memb', 0, 0),
(37, 'browse_page', '1140px', '', '_People', 1, 0, 'SearchedMembersBlock', '', 1, 71.9, 'non,memb', 0, 0),
(38, 'mail_page', '1140px', '', '_Mail box', 1, 0, 'MailBox', '', 1, 71.9, 'non,memb', 0, 0),
(39, 'mail_page', '1140px', '', '_My contacts', 2, 0, 'Contacts', '', 1, 28.1, 'non,memb', 0, 0),
(40, 'mail_page_view', '1140px', '', '_Mail box', 1, 0, 'ViewMessage', '', 1, 71.9, 'non,memb', 0, 0),
(41, 'mail_page_view', '1140px', '', '_Archive', 2, 0, 'Archives', '', 1, 28.1, 'non,memb', 0, 0),
(42, 'mail_page_compose', '1140px', '', '_COMPOSE_H', 1, 0, 'ComposeMessage', '', 1, 71.9, 'non,memb', 0, 0),
(43, 'mail_page_compose', '1140px', '', '_My contacts', 2, 0, 'Contacts', '', 1, 28.1, 'non,memb', 0, 0),
(44, 'search', '1140px', 'Search Results', '_Search result', 1, 0, 'Results', '', 1, 71.9, 'non,memb', 0, 0),
(45, 'search', '1140px', 'Search Form', '_Search profiles', 2, 0, 'SearchForm', '', 1, 28.1, 'non,memb', 0, 0),
(46, 'search_home', '1140px', 'Keyword Search', '_sys_box_title_search_keyword', 1, 0, 'Keyword', '', 1, 71.9, 'non,memb', 0, 86400),
(47, 'search_home', '1140px', 'People Search', '_sys_box_title_search_people', 2, 0, 'People', '', 1, 28.1, 'non,memb', 0, 0),
(48, 'join', '1140px', 'Join Form Block', '_Join_now', 1, 0, 'JoinForm', '', 1, 100, 'non', 413, 0),
(49, 'join', '1140px', 'Login Form Block', '_Login', 0, 0, 'LoginSection', 'no_join_text', 11, 100, 'non', 250, 86400),
(50, 'communicator_page', '1140px', '', '_sys_cnts_bcpt_connections', 1, 1, 'Connections', '', 1, 71.9, 'memb', 0, 0),
(51, 'communicator_page', '1140px', '', '_sys_cnts_bcpt_friend_requests', 2, 1, 'FriendRequests', '', 1, 28.1, 'memb', 0, 0),
(52, 'tags_home', '1140px', 'Recent Tags', '_tags_recent', 1, 0, 'Recent', '', 1, 28.1, 'non,memb', 0, 0),
(53, 'tags_home', '1140px', 'Popular Tags', '_popular_tags', 2, 0, 'Popular', '', 1, 71.9, 'non,memb', 0, 0),
(54, 'tags_calendar', '1140px', 'Calendar', '_tags_calendar', 1, 0, 'Calendar', '', 1, 100, 'non,memb', 0, 0),
(55, 'tags_calendar', '1140px', 'Date Tags', '_Tags', 1, 1, 'TagsDate', '', 1, 100, 'non,memb', 0, 0),
(56, 'tags_search', '1140px', 'Search Form', '_tags_search_form', 1, 0, 'Form', '', 1, 100, 'non,memb', 0, 86400),
(57, 'tags_search', '1140px', 'Founded Tags', '_tags_founded_tags', 1, 1, 'Founded', '', 1, 100, 'non,memb', 0, 0),
(58, 'tags_module', '1140px', 'Recent Tags', '_tags_recent', 1, 0, 'Recent', '', 1, 28.1, 'non,memb', 0, 0),
(59, 'tags_module', '1140px', 'All Tags', '_all_tags', 2, 0, 'All', '', 1, 71.9, 'non,memb', 0, 0),
(60, 'categ_calendar', '1140px', 'Calendar', '_categ_caption_calendar', 1, 0, 'Calendar', '', 1, 100, 'non,memb', 0, 0),
(61, 'categ_calendar', '1140px', 'Categories By Day', '_categ_caption_day', 1, 1, 'CategoriesDate', '', 1, 100, 'non,memb', 0, 0),
(62, 'categ_search', '1140px', 'Search Form', '_categ_caption_search_form', 1, 0, 'Form', '', 1, 100, 'non,memb', 0, 86400),
(63, 'categ_search', '1140px', 'Founded Categories', '_categ_caption_founded', 1, 1, 'Founded', '', 1, 100, 'non,memb', 0, 0),
(64, 'categ_module', '1140px', 'Common Categories', '_categ_caption_common', 1, 0, 'Common', '', 1, 28.1, 'non,memb', 0, 0),
(65, 'categ_module', '1140px', 'All Categories', '_categ_caption_all', 2, 0, 'All', '', 1, 71.9, 'non,memb', 0, 0),
(66, 'pedit', '1140px', 'Profile fields', '_edit_profile_info', 1, 1, 'Info', '', 1, 71.9, 'memb', 0, 0),
(67, 'pedit', '1140px', 'Profile privacy', '_edit_profile_privacy', 2, 1, 'Privacy', '', 1, 28.1, 'memb', 0, 0),
(68, 'pedit', '1140px', 'Profile membership', '_edit_profile_membership', 2, 2, 'Membership', '', 1, 28.1, 'memb', 0, 0),
(69, 'profile_private', '1140px', 'Actions that other members can do', '_Actions', 1, 0, 'ActionsMenu', '', 1, 28.1, 'non,memb', 0, 0),
(70, 'profile_private', '1140px', 'Some text to explain why this profile can not be viewed. Translation for this block is stored in ''_sys_profile_private_text'' language key.', '_sys_profile_private_text_title', 2, 0, 'PrivacyExplain', '', 1, 71.9, 'non,memb', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `sys_page_compose_pages`
--

CREATE TABLE `sys_page_compose_pages` (
  `Name` varchar(255) NOT NULL DEFAULT '',
  `Title` varchar(255) NOT NULL DEFAULT '',
  `Order` int(10) unsigned NOT NULL DEFAULT '0',
  `System` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`Name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_page_compose_pages`
--

INSERT INTO `sys_page_compose_pages` VALUES
('index', 'Homepage', 1, 1),
('member', 'Account', 6, 1),
('profile', 'Profile', 7, 1),
('pedit', 'Profile Edit', 8, 1),
('profile_info', 'Profile Info', 14, 1),
('profile_private', 'Profile Private', 15, 1),
('browse_page', 'All Members', 17, 1),
('mail_page', 'Mail Messages', 18, 1),
('mail_page_view', 'Mail View Message', 19, 1),
('mail_page_compose', 'Mail Compose Message', 20, 1),
('search', 'Search Profiles', 21, 1),
('join', 'Join Page', 22, 1),
('friends', 'Friends', 23, 1),
('communicator_page', 'Communicator', 24, 1),
('search_home', 'Search Home', 25, 1),
('tags_home', 'Tags Home', 26, 1),
('tags_calendar', 'Tags Search', 27, 1),
('tags_search', 'Tags Calendar', 28, 1),
('tags_module', 'Tags Module', 29, 1),
('categ_calendar', 'Categories Calendar', 30, 1),
('categ_search', 'Categories Search', 31, 1),
('categ_module', 'Categories Module', 32, 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_page_compose_privacy`
--

CREATE TABLE `sys_page_compose_privacy` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `block_id` int(11) unsigned NOT NULL DEFAULT '0',
  `allow_view_block_to` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `block` (`user_id`,`block_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_permalinks`
--

CREATE TABLE `sys_permalinks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `standard` varchar(128) NOT NULL DEFAULT '',
  `permalink` varchar(128) NOT NULL DEFAULT '',
  `check` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `check` (`standard`,`permalink`,`check`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_pre_values`
--

CREATE TABLE `sys_pre_values` (
  `Key` varchar(255) NOT NULL DEFAULT '' COMMENT 'Key which defines link to values list',
  `Value` varchar(255) NOT NULL DEFAULT '' COMMENT 'Simple value stored in the database',
  `Order` int(10) unsigned NOT NULL DEFAULT '0',
  `LKey` varchar(255) NOT NULL DEFAULT '' COMMENT 'Primary language key used for displaying this value',
  `LKey2` varchar(255) NOT NULL DEFAULT '' COMMENT 'Additional key used in some other places',
  `LKey3` varchar(255) NOT NULL DEFAULT '',
  `Extra` varchar(255) NOT NULL DEFAULT '' COMMENT 'Some extra values. For example image link for sex',
  `Extra2` varchar(255) NOT NULL DEFAULT '',
  `Extra3` varchar(255) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_pre_values`
--

INSERT INTO `sys_pre_values` VALUES
('Country', 'AF', 1, '__Afghanistan', '', '', '', '', ''),
('Country', 'AX', 2, '__Aland_Islands', '', '', '', '', ''),
('Country', 'AL', 3, '__Albania', '', '', '', '', ''),
('Country', 'DZ', 4, '__Algeria', '', '', '', '', ''),
('Country', 'AS', 5, '__American Samoa', '', '', '', '', ''),
('Country', 'AD', 6, '__Andorra', '', '', '', '', ''),
('Country', 'AO', 7, '__Angola', '', '', '', '', ''),
('Country', 'AI', 8, '__Anguilla', '', '', '', '', ''),
('Country', 'AQ', 9, '__Antarctica', '', '', '', '', ''),
('Country', 'AG', 10, '__Antigua and Barbuda', '', '', '', '', ''),
('Country', 'AR', 11, '__Argentina', '', '', '', '', ''),
('Country', 'AM', 12, '__Armenia', '', '', '', '', ''),
('Country', 'AW', 13, '__Aruba', '', '', '', '', ''),
('Country', 'AU', 14, '__Australia', '', '', '', '', ''),
('Country', 'AT', 15, '__Austria', '', '', '', '', ''),
('Country', 'AZ', 16, '__Azerbaijan', '', '', '', '', ''),
('Country', 'BH', 17, '__Bahrain', '', '', '', '', ''),
('Country', 'BD', 18, '__Bangladesh', '', '', '', '', ''),
('Country', 'BB', 19, '__Barbados', '', '', '', '', ''),
('Country', 'BY', 20, '__Belarus', '', '', '', '', ''),
('Country', 'BE', 21, '__Belgium', '', '', '', '', ''),
('Country', 'BZ', 22, '__Belize', '', '', '', '', ''),
('Country', 'BJ', 23, '__Benin', '', '', '', '', ''),
('Country', 'BM', 24, '__Bermuda', '', '', '', '', ''),
('Country', 'BT', 25, '__Bhutan', '', '', '', '', ''),
('Country', 'BO', 26, '__Bolivia', '', '', '', '', ''),
('Country', 'BA', 27, '__Bosnia and Herzegovina', '', '', '', '', ''),
('Country', 'BW', 28, '__Botswana', '', '', '', '', ''),
('Country', 'BV', 29, '__Bouvet Island', '', '', '', '', ''),
('Country', 'BR', 30, '__Brazil', '', '', '', '', ''),
('Country', 'IO', 31, '__British Indian Ocean Territory', '', '', '', '', ''),
('Country', 'VG', 32, '__British Virgin Islands', '', '', '', '', ''),
('Country', 'BN', 33, '__Brunei Darussalam', '', '', '', '', ''),
('Country', 'BG', 34, '__Bulgaria', '', '', '', '', ''),
('Country', 'BF', 35, '__Burkina Faso', '', '', '', '', ''),
('Country', 'MM', 36, '__Burma', '', '', '', '', ''),
('Country', 'BI', 37, '__Burundi', '', '', '', '', ''),
('Country', 'KH', 38, '__Cambodia', '', '', '', '', ''),
('Country', 'CM', 39, '__Cameroon', '', '', '', '', ''),
('Country', 'CA', 40, '__Canada', '', '', '', '', ''),
('Country', 'CV', 41, '__Cape Verde', '', '', '', '', ''),
('Country', 'KY', 42, '__Cayman Islands', '', '', '', '', ''),
('Country', 'CF', 43, '__Central African Republic', '', '', '', '', ''),
('Country', 'TD', 44, '__Chad', '', '', '', '', ''),
('Country', 'CL', 45, '__Chile', '', '', '', '', ''),
('Country', 'CN', 46, '__China', '', '', '', '', ''),
('Country', 'CX', 47, '__Christmas Island', '', '', '', '', ''),
('Country', 'CC', 48, '__Cocos (Keeling) Islands', '', '', '', '', ''),
('Country', 'CO', 49, '__Colombia', '', '', '', '', ''),
('Country', 'KM', 50, '__Comoros', '', '', '', '', ''),
('Country', 'CD', 51, '__Congo, Democratic Republic of the', '', '', '', '', ''),
('Country', 'CG', 52, '__Congo, Republic of the', '', '', '', '', ''),
('Country', 'CK', 53, '__Cook Islands', '', '', '', '', ''),
('Country', 'CR', 54, '__Costa Rica', '', '', '', '', ''),
('Country', 'CI', 55, '__Cote d''Ivoire', '', '', '', '', ''),
('Country', 'HR', 56, '__Croatia', '', '', '', '', ''),
('Country', 'CU', 57, '__Cuba', '', '', '', '', ''),
('Country', 'CY', 58, '__Cyprus', '', '', '', '', ''),
('Country', 'CZ', 59, '__Czech Republic', '', '', '', '', ''),
('Country', 'DK', 60, '__Denmark', '', '', '', '', ''),
('Country', 'DJ', 61, '__Djibouti', '', '', '', '', ''),
('Country', 'DM', 62, '__Dominica', '', '', '', '', ''),
('Country', 'DO', 63, '__Dominican Republic', '', '', '', '', ''),
('Country', 'TL', 64, '__East Timor', '', '', '', '', ''),
('Country', 'EC', 65, '__Ecuador', '', '', '', '', ''),
('Country', 'EG', 66, '__Egypt', '', '', '', '', ''),
('Country', 'SV', 67, '__El Salvador', '', '', '', '', ''),
('Country', 'GQ', 68, '__Equatorial Guinea', '', '', '', '', ''),
('Country', 'ER', 69, '__Eritrea', '', '', '', '', ''),
('Country', 'EE', 70, '__Estonia', '', '', '', '', ''),
('Country', 'ET', 71, '__Ethiopia', '', '', '', '', ''),
('Country', 'FK', 72, '__Falkland Islands (Islas Malvinas)', '', '', '', '', ''),
('Country', 'FO', 73, '__Faroe Islands', '', '', '', '', ''),
('Country', 'FJ', 74, '__Fiji', '', '', '', '', ''),
('Country', 'FI', 75, '__Finland', '', '', '', '', ''),
('Country', 'FR', 76, '__France', '', '', '', '', ''),
('Country', 'GF', 77, '__French Guiana', '', '', '', '', ''),
('Country', 'PF', 78, '__French Polynesia', '', '', '', '', ''),
('Country', 'TF', 79, '__French Southern and Antarctic Lands', '', '', '', '', ''),
('Country', 'GA', 80, '__Gabon', '', '', '', '', ''),
('Country', 'GE', 81, '__Georgia', '', '', '', '', ''),
('Country', 'DE', 82, '__Germany', '', '', '', '', ''),
('Country', 'GH', 83, '__Ghana', '', '', '', '', ''),
('Country', 'GI', 84, '__Gibraltar', '', '', '', '', ''),
('Country', 'GR', 85, '__Greece', '', '', '', '', ''),
('Country', 'GL', 86, '__Greenland', '', '', '', '', ''),
('Country', 'GD', 87, '__Grenada', '', '', '', '', ''),
('Country', 'GP', 88, '__Guadeloupe', '', '', '', '', ''),
('Country', 'GU', 89, '__Guam', '', '', '', '', ''),
('Country', 'GT', 90, '__Guatemala', '', '', '', '', ''),
('Country', 'GG', 91, '__Guernsey', '', '', '', '', ''),
('Country', 'GN', 92, '__Guinea', '', '', '', '', ''),
('Country', 'GW', 93, '__Guinea-Bissau', '', '', '', '', ''),
('Country', 'GY', 94, '__Guyana', '', '', '', '', ''),
('Country', 'HT', 95, '__Haiti', '', '', '', '', ''),
('Country', 'HM', 96, '__Heard Island and McDonald Islands', '', '', '', '', ''),
('Country', 'VA', 97, '__Holy See (Vatican City)', '', '', '', '', ''),
('Country', 'HN', 98, '__Honduras', '', '', '', '', ''),
('Country', 'HK', 99, '__Hong Kong (SAR)', '', '', '', '', ''),
('Country', 'HU', 100, '__Hungary', '', '', '', '', ''),
('Country', 'IS', 101, '__Iceland', '', '', '', '', ''),
('Country', 'IN', 102, '__India', '', '', '', '', ''),
('Country', 'ID', 103, '__Indonesia', '', '', '', '', ''),
('Country', 'IR', 104, '__Iran', '', '', '', '', ''),
('Country', 'IQ', 105, '__Iraq', '', '', '', '', ''),
('Country', 'IE', 106, '__Ireland', '', '', '', '', ''),
('Country', 'IM', 107, '__Isle_of_Man', '', '', '', '', ''),
('Country', 'IL', 108, '__Israel', '', '', '', '', ''),
('Country', 'IT', 109, '__Italy', '', '', '', '', ''),
('Country', 'JM', 110, '__Jamaica', '', '', '', '', ''),
('Country', 'JP', 111, '__Japan', '', '', '', '', ''),
('Country', 'JE', 112, '__Jersey', '', '', '', '', ''),
('Country', 'JO', 113, '__Jordan', '', '', '', '', ''),
('Country', 'KZ', 114, '__Kazakhstan', '', '', '', '', ''),
('Country', 'KE', 115, '__Kenya', '', '', '', '', ''),
('Country', 'KI', 116, '__Kiribati', '', '', '', '', ''),
('Country', 'KP', 117, '__Korea, North', '', '', '', '', ''),
('Country', 'KR', 118, '__Korea, South', '', '', '', '', ''),
('Country', 'KW', 119, '__Kuwait', '', '', '', '', ''),
('Country', 'KG', 120, '__Kyrgyzstan', '', '', '', '', ''),
('Country', 'LA', 121, '__Laos', '', '', '', '', ''),
('Country', 'LV', 122, '__Latvia', '', '', '', '', ''),
('Country', 'LB', 123, '__Lebanon', '', '', '', '', ''),
('Country', 'LS', 124, '__Lesotho', '', '', '', '', ''),
('Country', 'LR', 125, '__Liberia', '', '', '', '', ''),
('Country', 'LY', 126, '__Libya', '', '', '', '', ''),
('Country', 'LI', 127, '__Liechtenstein', '', '', '', '', ''),
('Country', 'LT', 128, '__Lithuania', '', '', '', '', ''),
('Country', 'LU', 129, '__Luxembourg', '', '', '', '', ''),
('Country', 'MO', 130, '__Macao', '', '', '', '', ''),
('Country', 'MK', 131, '__Macedonia, The Former Yugoslav Republic of', '', '', '', '', ''),
('Country', 'MG', 132, '__Madagascar', '', '', '', '', ''),
('Country', 'MW', 133, '__Malawi', '', '', '', '', ''),
('Country', 'MY', 134, '__Malaysia', '', '', '', '', ''),
('Country', 'MV', 135, '__Maldives', '', '', '', '', ''),
('Country', 'ML', 136, '__Mali', '', '', '', '', ''),
('Country', 'MT', 137, '__Malta', '', '', '', '', ''),
('Country', 'MH', 138, '__Marshall Islands', '', '', '', '', ''),
('Country', 'MQ', 139, '__Martinique', '', '', '', '', ''),
('Country', 'MR', 140, '__Mauritania', '', '', '', '', ''),
('Country', 'MU', 141, '__Mauritius', '', '', '', '', ''),
('Country', 'YT', 142, '__Mayotte', '', '', '', '', ''),
('Country', 'MX', 143, '__Mexico', '', '', '', '', ''),
('Country', 'FM', 144, '__Micronesia, Federated States of', '', '', '', '', ''),
('Country', 'MD', 145, '__Moldova', '', '', '', '', ''),
('Country', 'MC', 146, '__Monaco', '', '', '', '', ''),
('Country', 'MN', 147, '__Mongolia', '', '', '', '', ''),
('Country', 'ME', 148, '__Montenegro', '', '', '', '', ''),
('Country', 'MS', 149, '__Montserrat', '', '', '', '', ''),
('Country', 'MA', 150, '__Morocco', '', '', '', '', ''),
('Country', 'MZ', 151, '__Mozambique', '', '', '', '', ''),
('Country', 'NA', 152, '__Namibia', '', '', '', '', ''),
('Country', 'NR', 153, '__Nauru', '', '', '', '', ''),
('Country', 'NP', 154, '__Nepal', '', '', '', '', ''),
('Country', 'NL', 155, '__Netherlands', '', '', '', '', ''),
('Country', 'AN', 156, '__Netherlands Antilles', '', '', '', '', ''),
('Country', 'NC', 157, '__New Caledonia', '', '', '', '', ''),
('Country', 'NZ', 158, '__New Zealand', '', '', '', '', ''),
('Country', 'NI', 159, '__Nicaragua', '', '', '', '', ''),
('Country', 'NE', 160, '__Niger', '', '', '', '', ''),
('Country', 'NG', 161, '__Nigeria', '', '', '', '', ''),
('Country', 'NU', 162, '__Niue', '', '', '', '', ''),
('Country', 'NF', 163, '__Norfolk Island', '', '', '', '', ''),
('Country', 'MP', 164, '__Northern Mariana Islands', '', '', '', '', ''),
('Country', 'NO', 165, '__Norway', '', '', '', '', ''),
('Country', 'OM', 166, '__Oman', '', '', '', '', ''),
('Country', 'PK', 167, '__Pakistan', '', '', '', '', ''),
('Country', 'PW', 168, '__Palau', '', '', '', '', ''),
('Country', 'PS', 169, '__Palestinian Territory, Occupied', '', '', '', '', ''),
('Country', 'PA', 170, '__Panama', '', '', '', '', ''),
('Country', 'PG', 171, '__Papua New Guinea', '', '', '', '', ''),
('Country', 'PY', 172, '__Paraguay', '', '', '', '', ''),
('Country', 'PE', 173, '__Peru', '', '', '', '', ''),
('Country', 'PH', 174, '__Philippines', '', '', '', '', ''),
('Country', 'PN', 175, '__Pitcairn Islands', '', '', '', '', ''),
('Country', 'PL', 176, '__Poland', '', '', '', '', ''),
('Country', 'PT', 177, '__Portugal', '', '', '', '', ''),
('Country', 'PR', 178, '__Puerto Rico', '', '', '', '', ''),
('Country', 'QA', 179, '__Qatar', '', '', '', '', ''),
('Country', 'RE', 180, '__Reunion', '', '', '', '', ''),
('Country', 'RO', 181, '__Romania', '', '', '', '', ''),
('Country', 'RU', 182, '__Russia', '', '', '', '', ''),
('Country', 'RW', 183, '__Rwanda', '', '', '', '', ''),
('Country', 'SH', 184, '__Saint Helena', '', '', '', '', ''),
('Country', 'KN', 185, '__Saint Kitts and Nevis', '', '', '', '', ''),
('Country', 'LC', 186, '__Saint Lucia', '', '', '', '', ''),
('Country', 'PM', 187, '__Saint Pierre and Miquelon', '', '', '', '', ''),
('Country', 'VC', 188, '__Saint Vincent and the Grenadines', '', '', '', '', ''),
('Country', 'BL', 189, '__Saint_Barthelemy', '', '', '', '', ''),
('Country', 'MF', 190, '__Saint_Martin_French_part', '', '', '', '', ''),
('Country', 'WS', 191, '__Samoa', '', '', '', '', ''),
('Country', 'SM', 192, '__San Marino', '', '', '', '', ''),
('Country', 'ST', 193, '__Sao Tome and Principe', '', '', '', '', ''),
('Country', 'SA', 194, '__Saudi Arabia', '', '', '', '', ''),
('Country', 'SN', 195, '__Senegal', '', '', '', '', ''),
('Country', 'RS', 196, '__Serbia', '', '', '', '', ''),
('Country', 'SC', 197, '__Seychelles', '', '', '', '', ''),
('Country', 'SL', 198, '__Sierra Leone', '', '', '', '', ''),
('Country', 'SG', 199, '__Singapore', '', '', '', '', ''),
('Country', 'SK', 200, '__Slovakia', '', '', '', '', ''),
('Country', 'SI', 201, '__Slovenia', '', '', '', '', ''),
('Country', 'SB', 202, '__Solomon Islands', '', '', '', '', ''),
('Country', 'SO', 203, '__Somalia', '', '', '', '', ''),
('Country', 'ZA', 204, '__South Africa', '', '', '', '', ''),
('Country', 'GS', 205, '__South Georgia and the South Sandwich Islands', '', '', '', '', ''),
('Country', 'ES', 206, '__Spain', '', '', '', '', ''),
('Country', 'LK', 207, '__Sri Lanka', '', '', '', '', ''),
('Country', 'SD', 208, '__Sudan', '', '', '', '', ''),
('Country', 'SR', 209, '__Suriname', '', '', '', '', ''),
('Country', 'SJ', 210, '__Svalbard', '', '', '', '', ''),
('Country', 'SZ', 211, '__Swaziland', '', '', '', '', ''),
('Country', 'SE', 212, '__Sweden', '', '', '', '', ''),
('Country', 'CH', 213, '__Switzerland', '', '', '', '', ''),
('Country', 'SY', 214, '__Syria', '', '', '', '', ''),
('Country', 'TW', 215, '__Taiwan', '', '', '', '', ''),
('Country', 'TJ', 216, '__Tajikistan', '', '', '', '', ''),
('Country', 'TZ', 217, '__Tanzania', '', '', '', '', ''),
('Country', 'TH', 218, '__Thailand', '', '', '', '', ''),
('Country', 'BS', 219, '__The Bahamas', '', '', '', '', ''),
('Country', 'GM', 220, '__The Gambia', '', '', '', '', ''),
('Country', 'TG', 221, '__Togo', '', '', '', '', ''),
('Country', 'TK', 222, '__Tokelau', '', '', '', '', ''),
('Country', 'TO', 223, '__Tonga', '', '', '', '', ''),
('Country', 'TT', 224, '__Trinidad and Tobago', '', '', '', '', ''),
('Country', 'TN', 225, '__Tunisia', '', '', '', '', ''),
('Country', 'TR', 226, '__Turkey', '', '', '', '', ''),
('Country', 'TM', 227, '__Turkmenistan', '', '', '', '', ''),
('Country', 'TC', 228, '__Turks and Caicos Islands', '', '', '', '', ''),
('Country', 'TV', 229, '__Tuvalu', '', '', '', '', ''),
('Country', 'UG', 230, '__Uganda', '', '', '', '', ''),
('Country', 'UA', 231, '__Ukraine', '', '', '', '', ''),
('Country', 'AE', 232, '__United Arab Emirates', '', '', '', '', ''),
('Country', 'GB', 233, '__United Kingdom', '', '', '', '', ''),
('Country', 'US', 234, '__United States', '', '', '', '', ''),
('Country', 'UM', 235, '__United States Minor Outlying Islands', '', '', '', '', ''),
('Country', 'UY', 236, '__Uruguay', '', '', '', '', ''),
('Country', 'UZ', 237, '__Uzbekistan', '', '', '', '', ''),
('Country', 'VU', 238, '__Vanuatu', '', '', '', '', ''),
('Country', 'VE', 239, '__Venezuela', '', '', '', '', ''),
('Country', 'VN', 240, '__Vietnam', '', '', '', '', ''),
('Country', 'VI', 241, '__Virgin Islands', '', '', '', '', ''),
('Country', 'WF', 242, '__Wallis and Futuna', '', '', '', '', ''),
('Country', 'EH', 243, '__Western Sahara', '', '', '', '', ''),
('Country', 'YE', 244, '__Yemen', '', '', '', '', ''),
('Country', 'ZM', 245, '__Zambia', '', '', '', '', ''),
('Country', 'ZW', 246, '__Zimbabwe', '', '', '', '', ''),
('Sex', 'male', 1, '_Male', '_LookinMale', '', '', '', ''),
('Sex', 'female', 2, '_Female', '_LookinFemale', '', '', '', ''),
('Sex', 'intersex', 3, '_Intersex', '_LookinIntersex', '', '', '', ''),
('Height', '1', 1, '__4''7" (140cm) or below', '', '', '', '', ''),
('Height', '2', 2, '__4''8" - 4''11" (141-150cm)', '', '', '', '', ''),
('Height', '3', 3, '__5''0" - 5''3" (151-160cm)', '', '', '', '', ''),
('Height', '4', 4, '__5''4" - 5''7" (161-170cm)', '', '', '', '', ''),
('Height', '5', 5, '__5''8" - 5''11" (171-180cm)', '', '', '', '', ''),
('Height', '6', 6, '__6''0" - 6''3" (181-190cm)', '', '', '', '', ''),
('Height', '7', 7, '__6''4" (191cm) or above', '', '', '', '', ''),
('BodyType', '1', 1, '__Average', '', '', '', '', ''),
('BodyType', '2', 2, '__Ample', '', '', '', '', ''),
('BodyType', '3', 3, '__Athletic', '', '', '', '', ''),
('BodyType', '4', 4, '__Cuddly', '', '', '', '', ''),
('BodyType', '5', 5, '__Slim', '', '', '', '', ''),
('BodyType', '6', 6, '__Very Cuddly', '', '', '', '', ''),
('Religion', '1', 1, '__Adventist', '', '', '', '', ''),
('Religion', '2', 2, '__Agnostic', '', '', '', '', ''),
('Religion', '3', 3, '__Atheist', '', '', '', '', ''),
('Religion', '4', 4, '__Baptist', '', '', '', '', ''),
('Religion', '5', 5, '__Buddhist', '', '', '', '', ''),
('Religion', '6', 6, '__Caodaism', '', '', '', '', ''),
('Religion', '7', 7, '__Catholic', '', '', '', '', ''),
('Religion', '8', 8, '__Christian', '', '', '', '', ''),
('Religion', '9', 9, '__Hindu', '', '', '', '', ''),
('Religion', '10', 10, '__Iskcon', '', '', '', '', ''),
('Religion', '11', 11, '__Jainism', '', '', '', '', ''),
('Religion', '12', 12, '__Jewish', '', '', '', '', ''),
('Religion', '13', 13, '__Methodist', '', '', '', '', ''),
('Religion', '14', 14, '__Mormon', '', '', '', '', ''),
('Religion', '15', 15, '__Moslem', '', '', '', '', ''),
('Religion', '16', 16, '__Orthodox', '', '', '', '', ''),
('Religion', '17', 17, '__Pentecostal', '', '', '', '', ''),
('Religion', '18', 18, '__Protestant', '', '', '', '', ''),
('Religion', '19', 19, '__Quaker', '', '', '', '', ''),
('Religion', '20', 20, '__Scientology', '', '', '', '', ''),
('Religion', '21', 21, '__Shinto', '', '', '', '', ''),
('Religion', '22', 22, '__Sikhism', '', '', '', '', ''),
('Religion', '23', 23, '__Spiritual', '', '', '', '', ''),
('Religion', '24', 24, '__Taoism', '', '', '', '', ''),
('Religion', '25', 25, '__Wiccan', '', '', '', '', ''),
('Religion', '26', 26, '__Other', '', '', '', '', ''),
('Ethnicity', '1', 1, '__African', '', '', '', '', ''),
('Ethnicity', '2', 2, '__African American', '', '', '', '', ''),
('Ethnicity', '3', 3, '__Asian', '', '', '', '', ''),
('Ethnicity', '4', 4, '__Caucasian', '', '', '', '', ''),
('Ethnicity', '5', 5, '__East Indian', '', '', '', '', ''),
('Ethnicity', '6', 6, '__Hispanic', '', '', '', '', ''),
('Ethnicity', '7', 7, '__Indian', '', '', '', '', ''),
('Ethnicity', '8', 8, '__Latino', '', '', '', '', ''),
('Ethnicity', '9', 9, '__Mediterranean', '', '', '', '', ''),
('Ethnicity', '10', 10, '__Middle Eastern', '', '', '', '', ''),
('Ethnicity', '11', 11, '__Mixed', '', '', '', '', ''),
('MaritalStatus', '1', 1, '__Single', '', '', '', '', ''),
('MaritalStatus', '2', 2, '__Attached', '', '', '', '', ''),
('MaritalStatus', '3', 3, '__Divorced', '', '', '', '', ''),
('MaritalStatus', '4', 4, '__Married', '', '', '', '', ''),
('MaritalStatus', '5', 5, '__Separated', '', '', '', '', ''),
('MaritalStatus', '6', 6, '__Widow', '', '', '', '', ''),
('Language', '0', 0, '__English', '', '', '', '', ''),
('Language', '1', 1, '__Afrikaans', '', '', '', '', ''),
('Language', '2', 2, '__Arabic', '', '', '', '', ''),
('Language', '3', 3, '__Bulgarian', '', '', '', '', ''),
('Language', '4', 4, '__Burmese', '', '', '', '', ''),
('Language', '5', 5, '__Cantonese', '', '', '', '', ''),
('Language', '6', 6, '__Croatian', '', '', '', '', ''),
('Language', '7', 7, '__Danish', '', '', '', '', ''),
('Language', '8', 8, '__Dutch', '', '', '', '', ''),
('Language', '9', 9, '__Esperanto', '', '', '', '', ''),
('Language', '10', 10, '__Estonian', '', '', '', '', ''),
('Language', '11', 11, '__Finnish', '', '', '', '', ''),
('Language', '12', 12, '__French', '', '', '', '', ''),
('Language', '13', 13, '__German', '', '', '', '', ''),
('Language', '14', 14, '__Greek', '', '', '', '', ''),
('Language', '15', 15, '__Gujrati', '', '', '', '', ''),
('Language', '16', 16, '__Hebrew', '', '', '', '', ''),
('Language', '17', 17, '__Hindi', '', '', '', '', ''),
('Language', '18', 18, '__Hungarian', '', '', '', '', ''),
('Language', '19', 19, '__Icelandic', '', '', '', '', ''),
('Language', '20', 20, '__Indian', '', '', '', '', ''),
('Language', '21', 21, '__Indonesian', '', '', '', '', ''),
('Language', '22', 22, '__Italian', '', '', '', '', ''),
('Language', '23', 23, '__Japanese', '', '', '', '', ''),
('Language', '24', 24, '__Korean', '', '', '', '', ''),
('Language', '25', 25, '__Latvian', '', '', '', '', ''),
('Language', '26', 26, '__Lithuanian', '', '', '', '', ''),
('Language', '27', 27, '__Malay', '', '', '', '', ''),
('Language', '28', 28, '__Mandarin', '', '', '', '', ''),
('Language', '29', 29, '__Marathi', '', '', '', '', ''),
('Language', '30', 30, '__Moldovian', '', '', '', '', ''),
('Language', '31', 31, '__Nepalese', '', '', '', '', ''),
('Language', '32', 32, '__Norwegian', '', '', '', '', ''),
('Language', '33', 33, '__Persian', '', '', '', '', ''),
('Language', '34', 34, '__Polish', '', '', '', '', ''),
('Language', '35', 35, '__Portuguese', '', '', '', '', ''),
('Language', '36', 36, '__Punjabi', '', '', '', '', ''),
('Language', '37', 37, '__Romanian', '', '', '', '', ''),
('Language', '38', 38, '__Russian', '', '', '', '', ''),
('Language', '39', 39, '__Serbian', '', '', '', '', ''),
('Language', '40', 40, '__Spanish', '', '', '', '', ''),
('Language', '41', 41, '__Swedish', '', '', '', '', ''),
('Language', '42', 42, '__Tagalog', '', '', '', '', ''),
('Language', '43', 43, '__Taiwanese', '', '', '', '', ''),
('Language', '44', 44, '__Tamil', '', '', '', '', ''),
('Language', '45', 45, '__Telugu', '', '', '', '', ''),
('Language', '46', 46, '__Thai', '', '', '', '', ''),
('Language', '47', 47, '__Tongan', '', '', '', '', ''),
('Language', '48', 48, '__Turkish', '', '', '', '', ''),
('Language', '49', 49, '__Ukrainian', '', '', '', '', ''),
('Language', '50', 50, '__Urdu', '', '', '', '', ''),
('Language', '51', 51, '__Vietnamese', '', '', '', '', ''),
('Language', '52', 52, '__Visayan', '', '', '', '', ''),
('Education', '1', 1, '__High School graduate', '', '', '', '', ''),
('Education', '2', 2, '__Some college', '', '', '', '', ''),
('Education', '3', 3, '__College student', '', '', '', '', ''),
('Education', '4', 4, '__AA (2 years college)', '', '', '', '', ''),
('Education', '5', 5, '__BA/BS (4 years college)', '', '', '', '', ''),
('Education', '6', 6, '__Some grad school', '', '', '', '', ''),
('Education', '7', 7, '__Grad school student', '', '', '', '', ''),
('Education', '8', 8, '__MA/MS/MBA', '', '', '', '', ''),
('Education', '9', 9, '__PhD/Post doctorate', '', '', '', '', ''),
('Education', '10', 10, '__JD', '', '', '', '', ''),
('Income', '1', 1, '__$10,000/year and less', '', '', '', '', ''),
('Income', '2', 2, '__$10,000-$30,000/year', '', '', '', '', ''),
('Income', '3', 3, '__$30,000-$50,000/year', '', '', '', '', ''),
('Income', '4', 4, '__$50,000-$70,000/year', '', '', '', '', ''),
('Income', '5', 5, '__$70,000/year and more', '', '', '', '', ''),
('Smoker', '1', 1, '__No', '', '', '', '', ''),
('Smoker', '2', 2, '__Rarely', '', '', '', '', ''),
('Smoker', '3', 3, '__Often', '', '', '', '', ''),
('Smoker', '4', 4, '__Very often', '', '', '', '', ''),
('Drinker', '1', 1, '__No', '', '', '', '', ''),
('Drinker', '2', 2, '__Rarely', '', '', '', '', ''),
('Drinker', '3', 3, '__Often', '', '', '', '', ''),
('Drinker', '4', 4, '__Very often', '', '', '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `sys_privacy_actions`
--

CREATE TABLE `sys_privacy_actions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_uri` varchar(64) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `default_group` varchar(255) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `action` (`module_uri`,`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_privacy_actions`
--

INSERT INTO `sys_privacy_actions` VALUES
(1, 'profile', 'view_block', '_ps_view_block', '3');

-- --------------------------------------------------------

--
-- Table structure for table `sys_privacy_defaults`
--

CREATE TABLE `sys_privacy_defaults` (
  `owner_id` int(11) NOT NULL DEFAULT '0',
  `action_id` int(11) NOT NULL DEFAULT '0',
  `group_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`owner_id`,`action_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_privacy_groups`
--

CREATE TABLE `sys_privacy_groups` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `owner_id` int(11) NOT NULL DEFAULT '0',
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `home_url` varchar(255) NOT NULL DEFAULT '',
  `get_parent` text NOT NULL,
  `get_content` text NOT NULL,
  `members_count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `sys_privacy_groups`
--

INSERT INTO `sys_privacy_groups` VALUES
(1, 0, 0, '', '', '$aProfile = getProfileInfo($arg1); return (int)$aProfile[''PrivacyDefaultGroup''];', '', 0),
(2, 0, 0, '', '', '', 'return false;', 0),
(3, 0, 0, '', '', '', 'return true;', 0),
(4, 0, 0, '', '', '', 'return isMember() && isProfileActive($arg2);', 0),
(5, 0, 0, '', 'communicator.php?communicator_mode=friends_list', '', '$aIds = $arg0->fromMemory($arg0->_sGroupFriendsCache . $arg1, "getColumn", "SELECT `p`.`ID` AS `id` FROM `Profiles` AS `p` LEFT JOIN `sys_friend_list` AS `f1` ON (`f1`.`ID`=`p`.`ID` AND `f1`.`Profile`=''" . $arg1 . "'' AND `f1`.`Check`=1) LEFT JOIN `sys_friend_list` AS `f2` ON (`f2`.`Profile`=p.`ID` AND `f2`.`ID`=''" . $arg1 . "'' AND `f2`.`Check`=1) WHERE 1 AND (`f1`.`ID` IS NOT NULL OR `f2`.`ID` IS NOT NULL)"); return isProfileActive($arg2) && in_array($arg2, $aIds);', 0),
(6, 0, 0, '', 'communicator.php?&communicator_mode=hotlist_requests', '', '$aIds = $arg0->fromMemory($arg0->_sGroupFavesCache . $arg1, "getColumn", "SELECT `Profile` AS `id` FROM `sys_fave_list` WHERE `ID`=''" . $arg1 . "''"); return isProfileActive($arg2) && in_array($arg2, $aIds);', 0),
(7, 0, 0, '', 'mail.php?&mode=inbox&contacts_mode=Contacted', '', '$aIds = $arg0->fromMemory($arg0->_sGroupContactsCache . $arg1, "getColumn", "SELECT `tp`.`ID` AS `id` FROM `sys_messages` AS `tm` INNER JOIN `Profiles` AS `tp` ON (`tm`.`Sender`=`tp`.`ID` AND `tm`.`Recipient`=''" . $arg1 . "'') OR (`tm`.`Recipient`=`tp`.`ID` AND `tm`.`Sender`=''" . $arg1 . "'')"); return isProfileActive($arg2) && in_array($arg2, $aIds);', 0),
(8, 0, 0, '', '', '', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `sys_privacy_members`
--

CREATE TABLE `sys_privacy_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL DEFAULT '0',
  `member_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_member` (`group_id`,`member_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_profiles_match`
--

CREATE TABLE `sys_profiles_match` (
  `profile_id` int(10) NOT NULL,
  `sort` enum('none','activity','date_reg') NOT NULL DEFAULT 'none',
  `profiles_match` text,
  UNIQUE KEY `profile_id` (`profile_id`,`sort`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_profiles_match_mails`
--

CREATE TABLE `sys_profiles_match_mails` (
  `profile_id` int(10) NOT NULL,
  `profiles_match` text NOT NULL,
  PRIMARY KEY (`profile_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_profile_fields`
--

CREATE TABLE `sys_profile_fields` (
  `ID` smallint(10) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `Type` enum('text','html_area','area','pass','date','select_one','select_set','num','range','bool','system','block') NOT NULL DEFAULT 'text',
  `Control` enum('select','checkbox','radio') DEFAULT NULL COMMENT 'input element for selectors',
  `Extra` text NOT NULL,
  `Min` float DEFAULT NULL,
  `Max` float DEFAULT NULL,
  `Values` text NOT NULL,
  `UseLKey` enum('LKey','LKey2','LKey3') NOT NULL DEFAULT 'LKey',
  `Check` text NOT NULL,
  `Unique` tinyint(1) NOT NULL DEFAULT '0',
  `Default` text NOT NULL,
  `Mandatory` tinyint(1) NOT NULL DEFAULT '0',
  `Deletable` tinyint(1) NOT NULL DEFAULT '1',
  `JoinPage` int(10) unsigned NOT NULL DEFAULT '0',
  `JoinBlock` int(10) unsigned NOT NULL DEFAULT '0',
  `JoinOrder` float DEFAULT NULL,
  `EditOwnBlock` int(10) unsigned NOT NULL DEFAULT '0',
  `EditOwnOrder` float DEFAULT NULL,
  `EditAdmBlock` int(10) unsigned NOT NULL DEFAULT '0',
  `EditAdmOrder` float DEFAULT NULL,
  `EditModBlock` int(10) unsigned NOT NULL DEFAULT '0',
  `EditModOrder` float DEFAULT NULL,
  `ViewMembBlock` int(10) unsigned NOT NULL DEFAULT '0',
  `ViewMembOrder` float DEFAULT NULL,
  `ViewAdmBlock` int(10) unsigned NOT NULL DEFAULT '0',
  `ViewAdmOrder` float DEFAULT NULL,
  `ViewModBlock` int(10) unsigned NOT NULL DEFAULT '0',
  `ViewModOrder` float DEFAULT NULL,
  `ViewVisBlock` int(10) unsigned NOT NULL DEFAULT '0',
  `ViewVisOrder` float DEFAULT NULL,
  `SearchParams` text NOT NULL,
  `SearchSimpleBlock` int(10) unsigned NOT NULL DEFAULT '0',
  `SearchSimpleOrder` float DEFAULT NULL,
  `SearchQuickBlock` int(10) unsigned NOT NULL DEFAULT '0',
  `SearchQuickOrder` float DEFAULT NULL,
  `SearchAdvBlock` int(10) unsigned NOT NULL DEFAULT '0',
  `SearchAdvOrder` float DEFAULT NULL,
  `MatchField` int(10) unsigned NOT NULL DEFAULT '0',
  `MatchPercent` tinyint(7) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Name` (`Name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=71 ;

--
-- Dumping data for table `sys_profile_fields`
--

INSERT INTO `sys_profile_fields` VALUES
(1, 'ID', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 1, '', 0, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 17, 1, 17, 1, 0, NULL, '', 17, 2, 17, 2, 0, NULL, 0, 0),
(2, 'NickName', 'text', NULL, '', 4, 16, '', 'LKey', 'return ( preg_match( ''/^[a-zA-Z0-9_-]+$/'', $arg0 ) and !file_exists( $dir[''root''] . $arg0 ) );', 1, '', 1, 0, 0, 17, 2, 0, NULL, 0, NULL, 17, 1, 0, NULL, 17, 3, 17, 2, 0, NULL, '', 17, 1, 17, 1, 0, NULL, 0, 0),
(3, 'Password', 'pass', NULL, '', 5, 16, '', 'LKey', '', 0, '', 1, 0, 0, 17, 5, 17, 7, 17, 6, 17, 8, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(4, 'Email', 'text', NULL, '', 6, NULL, '', 'LKey', 'return (bool) preg_match(''/^([a-z0-9\\+\\_\\-\\.]+)@([a-z0-9\\+\\_\\-\\.]+)$/i'', $arg0);', 1, '', 1, 0, 0, 17, 6, 17, 4, 17, 4, 17, 2, 0, NULL, 21, 1, 21, 1, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(5, 'DateReg', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 21, 2, 21, 2, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(6, 'DateLastEdit', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 21, 4, 21, 4, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(7, 'Status', 'system', NULL, '', NULL, NULL, 'Unconfirmed\nApproval\nActive\nRejected\nSuspended', 'LKey', '', 0, '', 0, 0, 0, 0, NULL, 0, NULL, 21, 1, 21, 1, 0, NULL, 17, 6, 17, 3, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(8, 'DateLastLogin', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 21, 3, 21, 3, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(9, 'Featured', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 0, 0, 0, NULL, 0, NULL, 21, 2, 21, 2, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(10, 'Sex', 'select_one', 'select', '', NULL, NULL, '#!Sex', 'LKey', '', 0, '', 1, 0, 0, 20, 2, 17, 6, 17, 5, 17, 3, 17, 4, 17, 7, 17, 4, 17, 5, '', 20, 2, 20, 2, 17, 2, 11, 30),
(11, 'LookingFor', 'select_set', 'checkbox', '', NULL, NULL, '#!Sex', 'LKey2', '', 0, '', 0, 0, 0, 0, NULL, 20, 1, 20, 1, 17, 7, 17, 8, 17, 11, 17, 5, 17, 7, '', 20, 1, 20, 1, 0, NULL, 10, 30),
(12, 'DescriptionMe', 'area', NULL, '', 20, NULL, '', 'LKey', '', 0, '', 1, 0, 0, 20, 4, 20, 4, 20, 4, 20, 2, 0, NULL, 0, NULL, 22, 2, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(13, 'DateOfBirth', 'date', NULL, '', 18, 75, '', 'LKey', '', 0, '', 1, 0, 0, 20, 3, 20, 2, 20, 2, 17, 4, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 20, 3, 20, 3, 17, 3, 13, 0),
(15, 'Country', 'select_one', 'select', '', NULL, NULL, '#!Country', 'LKey', '', 0, '', 1, 0, 0, 0, NULL, 20, 5, 20, 5, 17, 5, 17, 6, 17, 9, 20, 2, 17, 4, '', 20, 4, 20, 4, 20, 1, 15, 25),
(16, 'City', 'text', NULL, '', 2, 64, '', 'LKey', '', 0, '', 1, 0, 0, 0, NULL, 20, 6, 20, 6, 17, 6, 17, 7, 17, 10, 20, 3, 17, 6, '', 0, NULL, 0, NULL, 20, 2, 0, 0),
(17, 'General Info', 'block', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 1, 0, 0, 1, 0, 1, 0, 2, 0, 2, 0, 1, 0, 1, 0, 1, 0, 1, '', 0, 1, 0, 1, 0, 1, 0, 0),
(18, 'Location', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 20, 5, 0, 0),
(19, 'Keyword', 'system', NULL, 'DescriptionMe\nHeadline', NULL, NULL, '', 'LKey', '', 0, '', 0, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 20, 3, 0, 0),
(20, 'Misc Info', 'block', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 1, 1, 0, 2, 0, 2, 0, 3, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, '', 0, 2, 0, 2, 0, 2, 0, 0),
(21, 'Admin Controls', 'block', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 1, 0, 0, NULL, 0, NULL, 0, 1, 0, 1, 0, NULL, 0, 3, 0, 4, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(23, 'Couple', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 1, 0, 0, 17, 1, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 17, 1, 0, 0),
(24, 'Captcha', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 1, 0, 0, 20, 6, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(41, 'EmailNotify', 'bool', 'checkbox', '', NULL, NULL, '', 'LKey', '', 0, '1', 0, 0, 0, 0, NULL, 17, 5, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(39, 'zip', 'text', NULL, '', 1, 32, '', 'LKey', '', 0, '', 1, 0, 0, 0, NULL, 20, 7, 20, 7, 20, 3, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(34, 'DateLastNav', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(37, 'aff_num', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '0', 0, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(38, 'Tags', 'text', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 0, 0, 0, NULL, 20, 9, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 20, 5, 20, 5, 20, 4, 0, 0),
(42, 'TermsOfUse', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 1, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(44, 'Age', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '0', 0, 1, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 17, 5, 17, 8, 20, 1, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(45, 'ProfilePhoto', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 0, 0, 20, 5, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(46, 'UserStatus', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(47, 'UserStatusMessage', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(48, 'UserStatusMessageWhen', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(49, 'Avatar', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(51, 'Height', 'text', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 1, 0, 0, NULL, 20, 8, 20, 8, 20, 4, 20, 1, 20, 1, 0, NULL, 20, 1, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(52, 'Weight', 'text', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 1, 0, 0, NULL, 20, 9, 20, 9, 20, 5, 20, 2, 20, 2, 0, NULL, 20, 2, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(53, 'Income', 'text', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 1, 0, 0, NULL, 20, 10, 20, 10, 20, 6, 20, 3, 20, 3, 0, NULL, 20, 3, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(54, 'Occupation', 'text', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 1, 0, 0, NULL, 20, 11, 20, 11, 20, 7, 20, 4, 20, 4, 0, NULL, 20, 4, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(55, 'Religion', 'text', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 1, 0, 0, NULL, 20, 12, 20, 12, 20, 8, 20, 5, 20, 5, 0, NULL, 20, 5, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(56, 'Education', 'text', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 1, 0, 0, NULL, 20, 13, 20, 13, 20, 9, 20, 6, 20, 6, 0, NULL, 20, 6, '', 0, NULL, 0, NULL, 0, NULL, 56, 0),
(57, 'RelationshipStatus', 'select_one', 'select', '', NULL, NULL, 'Single\nIn a Relationship\nEngaged\nMarried\nIt''s Complicated\nIn an Open Relationship', 'LKey', '', 0, '', 0, 1, 0, 0, NULL, 20, 14, 20, 14, 20, 10, 20, 7, 20, 7, 0, NULL, 20, 7, '', 0, NULL, 0, NULL, 0, NULL, 57, 10),
(58, 'Hobbies', 'area', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 1, 0, 0, NULL, 20, 15, 20, 15, 20, 11, 20, 8, 20, 8, 0, NULL, 20, 8, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(59, 'Interests', 'area', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 1, 0, 0, NULL, 20, 16, 20, 16, 20, 12, 20, 9, 20, 9, 0, NULL, 20, 9, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(60, 'Ethnicity', 'text', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 1, 0, 0, NULL, 20, 17, 20, 17, 20, 13, 20, 10, 20, 10, 0, NULL, 20, 10, '', 0, NULL, 0, NULL, 0, NULL, 60, 5),
(61, 'FavoriteSites', 'area', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 1, 0, 0, NULL, 20, 18, 20, 18, 20, 14, 20, 11, 20, 11, 0, NULL, 20, 11, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(62, 'FavoriteMusic', 'area', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 1, 0, 0, NULL, 20, 19, 20, 19, 20, 15, 20, 12, 20, 12, 0, NULL, 20, 12, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(63, 'FavoriteFilms', 'area', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 1, 0, 0, NULL, 20, 20, 20, 20, 20, 16, 20, 13, 20, 13, 0, NULL, 20, 13, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(64, 'FavoriteBooks', 'area', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 1, 0, 0, NULL, 20, 21, 20, 21, 20, 17, 20, 14, 20, 14, 0, NULL, 20, 14, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(66, 'FullName', 'text', NULL, '', 2, 200, '', 'LKey', '', 0, '', 1, 1, 0, 20, 1, 17, 2, 17, 2, 0, NULL, 17, 2, 17, 5, 0, NULL, 17, 2, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(67, 'allow_view_to', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(68, 'Agree', 'system', NULL, '', NULL, NULL, '', 'LKey', '', 0, '', 0, 0, 0, 20, 7, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(69, 'FirstName', 'text', NULL, '', 2, 200, '', 'LKey', '', 0, '', 1, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0),
(70, 'LastName', 'text', NULL, '', 2, 200, '', 'LKey', '', 0, '', 1, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, 0, NULL, '', 0, NULL, 0, NULL, 0, NULL, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `sys_profile_rating`
--

CREATE TABLE `sys_profile_rating` (
  `pr_id` int(10) unsigned NOT NULL DEFAULT '0',
  `pr_rating_count` int(11) NOT NULL DEFAULT '0',
  `pr_rating_sum` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `med_id` (`pr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_profile_views_track`
--

CREATE TABLE `sys_profile_views_track` (
  `id` int(10) unsigned NOT NULL,
  `viewer` int(10) unsigned NOT NULL,
  `ip` int(10) unsigned NOT NULL,
  `ts` int(10) unsigned NOT NULL,
  KEY `id` (`id`,`viewer`,`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_profile_voting_track`
--

CREATE TABLE `sys_profile_voting_track` (
  `pr_id` int(10) unsigned NOT NULL DEFAULT '0',
  `pr_ip` varchar(20) DEFAULT NULL,
  `pr_date` datetime DEFAULT NULL,
  KEY `pr_ip` (`pr_ip`,`pr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `sys_sbs_entries`
--

CREATE TABLE `sys_sbs_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) NOT NULL DEFAULT '0',
  `subscriber_type` tinyint(4) NOT NULL DEFAULT '0',
  `subscription_id` int(11) NOT NULL DEFAULT '0',
  `object_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `entry` (`subscriber_id`,`subscriber_type`,`subscription_id`,`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_sbs_messages`
--

CREATE TABLE `sys_sbs_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `subject` varchar(128) NOT NULL DEFAULT '',
  `body` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_sbs_queue`
--

CREATE TABLE `sys_sbs_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(64) NOT NULL DEFAULT '',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `body` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_sbs_types`
--

CREATE TABLE `sys_sbs_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `unit` varchar(32) NOT NULL DEFAULT '',
  `action` varchar(32) NOT NULL DEFAULT '',
  `template` varchar(64) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscription` (`unit`,`action`,`template`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `sys_sbs_types`
--

INSERT INTO `sys_sbs_types` VALUES
(1, 'system', '', '', 'return array(''template'' => array(''Subscription'' => _t(''_sbs_txt_sbs_mass_mailer''), ''ViewLink'' => BX_DOL_URL_ROOT));'),
(2, 'system', 'mass_mailer', 't_AdminEmail', 'return array(''template'' => array(''Subscription'' => _t(''_sbs_txt_sbs_mass_mailer''), ''ViewLink'' => BX_DOL_URL_ROOT));'),
(3, 'profile', '', '', '$aUser = getProfileInfo($arg3); return array(''template'' => array(''Subscription'' => _t(''_sbs_txt_sbs_profile'', $aUser[''NickName'']), ''ViewLink'' => getProfileLink($arg3)));'),
(4, 'profile', 'commentPost', 't_sbsProfileComments', '$aUser = getProfileInfo($arg3); return array(''template'' => array(''Subscription'' => _t(''_sbs_txt_sbs_profile_comments'', $aUser[''NickName'']), ''ViewLink'' => getProfileLink($arg3)));'),
(5, 'profile', 'edit', 't_sbsProfileEdit', '$aUser = getProfileInfo($arg3); return array(''template'' => array(''Subscription'' => _t(''_sbs_txt_sbs_profile_edit'', $aUser[''NickName'']), ''ViewLink'' => getProfileLink($arg3)));');

-- --------------------------------------------------------

--
-- Table structure for table `sys_sbs_users`
--

CREATE TABLE `sys_sbs_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '',
  `email` varchar(64) NOT NULL DEFAULT '',
  `date` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber` (`name`,`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_sessions`
--

CREATE TABLE `sys_sessions` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `data` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `date` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_sessions`
--

-- --------------------------------------------------------

--
-- Table structure for table `sys_shared_sites`
--

CREATE TABLE `sys_shared_sites` (
  `ID` tinyint(4) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) DEFAULT NULL,
  `URL` varchar(255) NOT NULL DEFAULT '',
  `Icon` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `sys_shared_sites`
--

INSERT INTO `sys_shared_sites` VALUES
(1, 'digg', 'http://digg.com/submit?phase=2&url=', 'digg.png'),
(2, 'delicious', 'http://del.icio.us/post?url=', 'delicious.png'),
(3, 'newsvine', 'http://www.newsvine.com/_tools/seed&save?u=', 'newsvine.png'),
(4, 'reddit', 'http://reddit.com/submit?url=', 'reddit.png'),
(5, 'facebook', 'http://www.facebook.com/sharer/sharer.php?u=', 'facebook.png'),
(6, 'twitter', 'https://twitter.com/share?url=', 'twitter.png');

-- --------------------------------------------------------

--
-- Table structure for table `sys_stat_member`
--

CREATE TABLE `sys_stat_member` (
  `Type` varchar(10) NOT NULL,
  `SQL` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_stat_member`
--

INSERT INTO `sys_stat_member` VALUES
('mma', 'SELECT COUNT(*) FROM `sys_messages` WHERE `Recipient`=''__member_id__'' AND NOT FIND_IN_SET(''Recipient'', `sys_messages`.`Trash`)'),
('mmn', 'SELECT COUNT(*) FROM `sys_messages` WHERE `Recipient`=''__member_id__'' AND `New`=''1'' AND NOT FIND_IN_SET(''Recipient'', `sys_messages`.`Trash`)'),
('mfl', 'SELECT COUNT(*) FROM `sys_fave_list` WHERE `ID` = ''__member_id__'' '),
('mfr', 'SELECT COUNT(*) FROM `sys_friend_list` as f LEFT JOIN `Profiles` as p ON p.`ID` = f.`ID` WHERE f.`Profile` = __member_id__ AND f.`Check` = ''0'' AND p.`Status`=''Active'''),
('mfa', 'SELECT COUNT(*) FROM `sys_friend_list` WHERE ( `ID`=''__member_id__'' OR `Profile`=''__member_id__'' ) AND `Check`=''1'''),
('mgc', 'SELECT COUNT(*) FROM `sys_greetings` WHERE `ID` = ''__member_id__'' AND New = ''1'''),
('mbc', 'SELECT COUNT(*) FROM `sys_block_list` WHERE `ID` = ''__member_id__'''),
('mgmc', 'SELECT COUNT(*) FROM `sys_greetings` WHERE `Profile` = ''__member_id__'' AND New = ''1''');

-- --------------------------------------------------------

--
-- Table structure for table `sys_stat_site`
--

CREATE TABLE `sys_stat_site` (
  `ID` tinyint(4) unsigned NOT NULL AUTO_INCREMENT,
  `Name` varchar(20) NOT NULL DEFAULT '',
  `Title` varchar(50) NOT NULL DEFAULT '',
  `UserLink` varchar(255) NOT NULL DEFAULT '',
  `UserQuery` varchar(255) NOT NULL DEFAULT '',
  `AdminLink` varchar(255) NOT NULL DEFAULT '',
  `AdminQuery` varchar(255) NOT NULL DEFAULT '',
  `IconName` varchar(50) NOT NULL DEFAULT '',
  `StatOrder` int(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `sys_stat_site`
--

INSERT INTO `sys_stat_site` VALUES
(1, 'all', 'Members', 'browse.php', 'SELECT COUNT(`ID`) FROM `Profiles` WHERE `Status`=''Active'' AND (`Couple`=''0'' OR `Couple`>`ID`)', '{admin_url}profiles.php?action=browse&by=status&value=approval', 'SELECT COUNT(`ID`) FROM `Profiles` WHERE `Status`=''Approval'' AND (`Couple`=''0'' OR `Couple`>`ID`)', 'user', 1);

-- --------------------------------------------------------

--
-- Table structure for table `sys_tags`
--

CREATE TABLE `sys_tags` (
  `Tag` varchar(32) NOT NULL DEFAULT '',
  `ObjID` int(10) unsigned NOT NULL DEFAULT '0',
  `Type` varchar(20) NOT NULL DEFAULT 'profile',
  `Date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`Tag`,`ObjID`,`Type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
