
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `dokeos211`
--

-- --------------------------------------------------------

--
-- Table structure for table `access_url`
--

CREATE TABLE `access_url` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `description` text,
  `active` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by` int(11) NOT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `access_url`
--

INSERT INTO `access_url` VALUES
(1, 'http://[[domhost]]/', ' ', 1, 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `access_url_rel_admin`
--

CREATE TABLE `access_url_rel_admin` (
  `access_url_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`access_url_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `access_url_rel_course`
--

CREATE TABLE `access_url_rel_course` (
  `access_url_id` int(10) unsigned NOT NULL,
  `course_code` char(40) NOT NULL,
  PRIMARY KEY (`access_url_id`,`course_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `access_url_rel_session`
--

CREATE TABLE `access_url_rel_session` (
  `access_url_id` int(10) unsigned NOT NULL,
  `session_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`access_url_id`,`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `access_url_rel_user`
--

CREATE TABLE `access_url_rel_user` (
  `access_url_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`access_url_id`,`user_id`),
  KEY `idx_access_url_rel_user_user` (`user_id`),
  KEY `idx_access_url_rel_user_access_url` (`access_url_id`),
  KEY `idx_access_url_rel_user_access_url_user` (`user_id`,`access_url_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `admin`
--

CREATE TABLE `admin` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `admin`
--

INSERT INTO `admin` VALUES
(1);

-- --------------------------------------------------------

--
-- Table structure for table `catalogue`
--

CREATE TABLE `catalogue` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `economic_model` char(1) NOT NULL DEFAULT '0',
  `visible` char(1) NOT NULL DEFAULT '0',
  `catalogue_display` text,
  `payment` char(50) DEFAULT NULL,
  `atos_account_number` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `paypal_account_ref` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `second_installment` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `second_installment_delay` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `third_installment` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `third_installment_delay` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `options_selection` text,
  `payment_message` text,
  `cc_payment_message` text,
  `installment_payment_message` text,
  `cheque_payment_message` text,
  `email` char(1) NOT NULL DEFAULT '0',
  `company_logo` varchar(255) DEFAULT NULL,
  `company_address` text,
  `bank_details` text,
  `cheque_message` text,
  `terms_conditions` text,
  `tva_description` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `certificate`
--

CREATE TABLE `certificate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `portal_name` varchar(200) DEFAULT NULL,
  `portal_logo` varchar(200) DEFAULT NULL,
  `company` varchar(200) DEFAULT NULL,
  `company_logo` varchar(200) DEFAULT NULL,
  `certificate_date` date NOT NULL DEFAULT '0000-00-00',
  `message` text,
  `company_seal` varchar(200) DEFAULT NULL,
  `scope` text,
  `display_as` varchar(20) NOT NULL DEFAULT 'html',
  `template` int(11) NOT NULL DEFAULT '1',
  `required_score` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `certificate_template`
--

CREATE TABLE `certificate_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) DEFAULT NULL,
  `description` text,
  `thumbnail` varchar(200) DEFAULT NULL,
  `content` longtext,
  `position` int(11) NOT NULL DEFAULT '0',
  `creation_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `class`
--

CREATE TABLE `class` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(40) DEFAULT '',
  `name` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `class_user`
--

CREATE TABLE `class_user` (
  `class_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`class_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `country`
--

CREATE TABLE `country` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `iso` varchar(4) DEFAULT NULL,
  `original_name` varchar(200) DEFAULT NULL,
  `langvar` varchar(200) DEFAULT NULL,
  `iso3` varchar(4) NOT NULL,
  `numcode` varchar(5) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=227 ;

--
-- Dumping data for table `country`
--

INSERT INTO `country` VALUES
(1, 'AF', 'AFGHANISTAN', 'Afghanistan', 'AFG', '004'),
(2, 'AL', 'ALBANIA', 'Albania', 'ALB', '008'),
(3, 'DZ', 'ALGERIA', 'Algeria', 'DZA', '012'),
(4, 'AS', 'AMERICAN SAMOA', 'AmericanSamoa', 'ASM', '016'),
(5, 'AD', 'ANDORRA', 'Andorra', 'AND', '020'),
(6, 'AO', 'ANGOLA', 'Angola', 'AGO', '024'),
(7, 'AI', 'ANGUILLA', 'Anguilla', 'AIA', '660'),
(8, 'AG', 'ANTIGUA AND BARBUDA', 'AntiguaAndBarbuda', 'ATG', '028'),
(9, 'AR', 'ARGENTINA', 'Argentina', 'ARG', '032'),
(10, 'AM', 'ARMENIA', 'Armenia', 'ARM', '051'),
(11, 'AW', 'ARUBA', 'Aruba', 'ABW', '533'),
(12, 'AU', 'AUSTRALIA', 'Australia', 'AUS', '036'),
(13, 'AT', 'AUSTRIA', 'Austria', 'AUT', '040'),
(14, 'AZ', 'AZERBAIJAN', 'Azerbaijan', 'AZE', '031'),
(15, 'BS', 'BAHAMAS', 'Bahamas', 'BHS', '044'),
(16, 'BH', 'BAHRAIN', 'Bahrain', 'BHR', '048'),
(17, 'BD', 'BANGLADESH', 'Bangladesh', 'BGD', '050'),
(18, 'BB', 'BARBADOS', 'Barbados', 'BRB', '052'),
(19, 'BY', 'BELARUS', 'Belarus', 'BLR', '112'),
(20, 'BE', 'BELGIUM', 'Belgium', 'BEL', '056'),
(21, 'BZ', 'BELIZE', 'Belize', 'BLZ', '084'),
(22, 'BJ', 'BENIN', 'Benin', 'BEN', '204'),
(23, 'BM', 'BERMUDA', 'Bermuda', 'BMU', '060'),
(24, 'BT', 'BHUTAN', 'Bhutan', 'BTN', '064'),
(25, 'BO', 'BOLIVIA', 'Bolivia', 'BOL', '068'),
(26, 'BA', 'BOSNIA AND HERZEGOVINA', 'BosniaAndHerzegovina', 'BIH', '070'),
(27, 'BW', 'BOTSWANA', 'Botswana', 'BWA', '072'),
(28, 'BR', 'BRAZIL', 'Brazil', 'BRA', '076'),
(29, 'BN', 'BRUNEI DARUSSALAM', 'BruneiDarussalam', 'BRN', '096'),
(30, 'BG', 'BULGARIA', 'Bulgaria', 'BGR', '100'),
(31, 'BF', 'BURKINA FASO', 'BurkinaFaso', 'BFA', '854'),
(32, 'BI', 'BURUNDI', 'Burundi', 'BDI', '108'),
(33, 'KH', 'CAMBODIA', 'Cambodia', 'KHM', '116'),
(34, 'CM', 'CAMEROON', 'Cameroon', 'CMR', '120'),
(35, 'CA', 'CANADA', 'Canada', 'CAN', '124'),
(36, 'CV', 'CAPE VERDE', 'CapeVerde', 'CPV', '132'),
(37, 'KY', 'CAYMAN ISLANDS', 'CaymanIslands', 'CYM', '136'),
(38, 'CF', 'CENTRAL AFRICAN REPUBLIC', 'CentralAfricanRepublic', 'CAF', '140'),
(39, 'TD', 'CHAD', 'Chad', 'TCD', '148'),
(40, 'CL', 'CHILE', 'Chile', 'CHL', '152'),
(41, 'CN', 'CHINA', 'China', 'CHN', '156'),
(42, 'CO', 'COLOMBIA', 'Colombia', 'COL', '170'),
(43, 'KM', 'COMOROS', 'Comoros', 'COM', '174'),
(44, 'CG', 'CONGO', 'Congo', 'COG', '178'),
(45, 'CD', 'CONGO, THE DEMOCRATIC REPUBLIC OF THE', 'CongoDemo', 'COD', '180'),
(46, 'CK', 'COOK ISLANDS', 'CookIslands', 'COK', '184'),
(47, 'CR', 'COSTA RICA', 'CostaRica', 'CRI', '188'),
(48, 'CI', 'COTE D''IVOIRE', 'CoteIvoire', 'CIV', '384'),
(49, 'HR', 'CROATIA', 'Croatia', 'HRV', '191'),
(50, 'CU', 'CUBA', 'Cuba', 'CUB', '192'),
(51, 'CY', 'CYPRUS', 'Cyprus', 'CYP', '196'),
(52, 'CZ', 'CZECH REPUBLIC', 'CzechRepublic', 'CZE', '203'),
(53, 'DK', 'DENMARK', 'Denmark', 'DNK', '208'),
(54, 'DJ', 'DJIBOUTI', 'Djibouti', 'DJI', '262'),
(55, 'DM', 'DOMINICA', 'Dominica', 'DMA', '212'),
(56, 'DO', 'DOMINICAN REPUBLIC', 'DominicanRepublic', 'DOM', '214'),
(57, 'EC', 'ECUADOR', 'Ecuador', 'ECU', '218'),
(58, 'EG', 'EGYPT', 'Egypt', 'EGY', '818'),
(59, 'SV', 'EL SALVADOR', 'ElSalvador', 'SLV', '222'),
(60, 'GQ', 'EQUATORIAL GUINEA', 'EquatorialGuinea', 'GNQ', '226'),
(61, 'ER', 'ERITREA', 'Eritrea', 'ERI', '232'),
(62, 'EE', 'ESTONIA', 'Estonia', 'EST', '233'),
(63, 'ET', 'ETHIOPIA', 'Ethiopia', 'ETH', '231'),
(64, 'FK', 'FALKLAND ISLANDS (MALVINAS)', 'FalklandIslands', 'FLK', '238'),
(65, 'FO', 'FAROE ISLANDS', 'FaroeIslands', 'FRO', '234'),
(66, 'FJ', 'FIJI', 'Fiji', 'FJI', '242'),
(67, 'FI', 'FINLAND', 'Finland', 'FIN', '246'),
(68, 'FR', 'FRANCE', 'France', 'FRA', '250'),
(69, 'GF', 'FRENCH GUIANA', 'FrenchGuiana', 'GUF', '254'),
(70, 'PF', 'FRENCH POLYNESIA', 'FrenchPolynesia', 'PYF', '258'),
(71, 'GA', 'GABON', 'Gabon', 'GAB', '266'),
(72, 'GM', 'GAMBIA', 'Gambia', 'GMB', '270'),
(73, 'GE', 'GEORGIA', 'Georgia', 'GEO', '268'),
(74, 'DE', 'GERMANY', 'Germany', 'DEU', '276'),
(75, 'GH', 'GHANA', 'Ghana', 'GHA', '288'),
(76, 'GI', 'GIBRALTAR', 'Gibraltar', 'GIB', '292'),
(77, 'GR', 'GREECE', 'Greece', 'GRC', '300'),
(78, 'GL', 'GREENLAND', 'Greenland', 'GRL', '304'),
(79, 'GD', 'GRENADA', 'Grenada', 'GRD', '308'),
(80, 'GP', 'GUADELOUPE', 'Guadeloupe', 'GLP', '312'),
(81, 'GU', 'GUAM', 'Guam', 'GUM', '316'),
(82, 'GT', 'GUATEMALA', 'Guatemala', 'GTM', '320'),
(83, 'GN', 'GUINEA', 'Guinea', 'GIN', '324'),
(84, 'GW', 'GUINEA-BISSAU', 'GuineaBissau', 'GNB', '624'),
(85, 'GY', 'GUYANA', 'Guyana', 'GUY', '328'),
(86, 'HT', 'HAITI', 'Haiti', 'HTI', '332'),
(87, 'VA', 'HOLY SEE (VATICAN CITY STATE)', 'HolySee', 'VAT', '336'),
(88, 'HN', 'HONDURAS', 'Honduras', 'HND', '340'),
(89, 'HK', 'HONG KONG', 'HongKong', 'HKG', '344'),
(90, 'HU', 'HUNGARY', 'Hungary', 'HUN', '348'),
(91, 'IS', 'ICELAND', 'Iceland', 'ISL', '352'),
(92, 'IN', 'INDIA', 'India', 'IND', '356'),
(93, 'ID', 'INDONESIA', 'Indonesia', 'IDN', '360'),
(94, 'IR', 'IRAN, ISLAMIC REPUBLIC OF', 'Iran', 'IRN', '364'),
(95, 'IQ', 'IRAQ', 'Iraq', 'IRQ', '368'),
(96, 'IE', 'IRELAND', 'Ireland', 'IRL', '372'),
(97, 'IL', 'ISRAEL', 'Israel', 'ISR', '376'),
(98, 'IT', 'ITALY', 'Italy', 'ITA', '380'),
(99, 'JM', 'JAMAICA', 'Jamaica', 'JAM', '388'),
(100, 'JP', 'JAPAN', 'Japan', 'JPN', '392'),
(101, 'JO', 'JORDAN', 'Jordan', 'JOR', '400'),
(102, 'KZ', 'KAZAKHSTAN', 'Kazakhstan', 'KAZ', '398'),
(103, 'KE', 'KENYA', 'Kenya', 'KEN', '404'),
(104, 'KI', 'KIRIBATI', 'Kiribati', 'KIR', '296'),
(105, 'KP', 'KOREA, DEMOCRATIC PEOPLE''S REPUBLIC OF', 'KoreaDemo', 'PRK', '408'),
(106, 'KR', 'KOREA, REPUBLIC OF', 'Korea', 'KOR', '410'),
(107, 'KW', 'KUWAIT', 'Kuwait', 'KWT', '414'),
(108, 'KG', 'KYRGYZSTAN', 'Kyrgyzstan', 'KGZ', '417'),
(109, 'LA', 'LAO PEOPLE''S DEMOCRATIC REPUBLIC', 'Lao', 'LAO', '418'),
(110, 'LV', 'LATVIA', 'Latvia', 'LVA', '428'),
(111, 'LB', 'LEBANON', 'Lebanon', 'LBN', '422'),
(112, 'LS', 'LESOTHO', 'Lesotho', 'LSO', '426'),
(113, 'LR', 'LIBERIA', 'Liberia', 'LBR', '430'),
(114, 'LY', 'LIBYAN ARAB JAMAHIRIYA', 'LibyanArabJamahiriya', 'LBY', '434'),
(115, 'LI', 'LIECHTENSTEIN', 'Liechtenstein', 'LIE', '438'),
(116, 'LT', 'LITHUANIA', 'Lithuania', 'LTU', '440'),
(117, 'LU', 'LUXEMBOURG', 'Luxembourg', 'LUX', '442'),
(118, 'MO', 'MACAO', 'Macao', 'MAC', '446'),
(119, 'MK', 'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF', 'Macedonia', 'MKD', '807'),
(120, 'MG', 'MADAGASCAR', 'Madagascar', 'MDG', '450'),
(121, 'MW', 'MALAWI', 'Malawi', 'MWI', '454'),
(122, 'MY', 'MALAYSIA', 'Malaysia', 'MYS', '458'),
(123, 'MV', 'MALDIVES', 'Maldives', 'MDV', '462'),
(124, 'ML', 'MALI', 'Mali', 'MLI', '466'),
(125, 'MT', 'MALTA', 'Malta', 'MLT', '470'),
(126, 'MH', 'MARSHALL ISLANDS', 'MarshallIslands', 'MHL', '584'),
(127, 'MQ', 'MARTINIQUE', 'Martinique', 'MTQ', '474'),
(128, 'MR', 'MAURITANIA', 'Mauritania', 'MRT', '478'),
(129, 'MU', 'MAURITIUS', 'Mauritius', 'MUS', '480'),
(130, 'MX', 'MEXICO', 'Mexico', 'MEX', '484'),
(131, 'FM', 'MICRONESIA, FEDERATED STATES OF', 'Micronesia', 'FSM', '583'),
(132, 'MD', 'MOLDOVA, REPUBLIC OF', 'Moldova', 'MDA', '498'),
(133, 'MC', 'MONACO', 'Monaco', 'MCO', '492'),
(134, 'MN', 'MONGOLIA', 'Mongolia', 'MNG', '496'),
(135, 'MS', 'MONTSERRAT', 'Montserrat', 'MSR', '500'),
(136, 'MA', 'MOROCCO', 'Morocco', 'MAR', '504'),
(137, 'MZ', 'MOZAMBIQUE', 'Mozambique', 'MOZ', '508'),
(138, 'MM', 'MYANMAR', 'Myanmar', 'MMR', '104'),
(139, 'NA', 'NAMIBIA', 'Namibia', 'NAM', '516'),
(140, 'NR', 'NAURU', 'Nauru', 'NRU', '520'),
(141, 'NP', 'NEPAL', 'Nepal', 'NPL', '524'),
(142, 'NL', 'NETHERLANDS', 'Netherlands', 'NLD', '528'),
(143, 'AN', 'NETHERLANDS ANTILLES', 'NetherlandsAntilles', 'ANT', '530'),
(144, 'NC', 'NEW CALEDONIA', 'NewCaledonia', 'NCL', '540'),
(145, 'NZ', 'NEW ZEALAND', 'NewZealand', 'NZL', '554'),
(146, 'NI', 'NICARAGUA', 'Nicaragua', 'NIC', '558'),
(147, 'NE', 'NIGER', 'Niger', 'NER', '562'),
(148, 'NG', 'NIGERIA', 'Nigeria', 'NGA', '566'),
(149, 'NU', 'NIUE', 'Niue', 'NIU', '570'),
(150, 'NF', 'NORFOLK ISLAND', 'NorfolkIsland', 'NFK', '574'),
(151, 'MP', 'NORTHERN MARIANA ISLANDS', 'NorthernMarianaIslands', 'MNP', '580'),
(152, 'NO', 'NORWAY', 'Norway', 'NOR', '578'),
(153, 'OM', 'OMAN', 'Oman', 'OMN', '512'),
(154, 'PK', 'PAKISTAN', 'Pakistan', 'PAK', '586'),
(155, 'PW', 'PALAU', 'Palau', 'PLW', '585'),
(156, 'PA', 'PANAMA', 'Panama', 'PAN', '591'),
(157, 'PG', 'PAPUA NEW GUINEA', 'PapuaNewGuinea', 'PNG', '598'),
(158, 'PY', 'PARAGUAY', 'Paraguay', 'PRY', '600'),
(159, 'PE', 'PERU', 'Peru', 'PER', '604'),
(160, 'PH', 'PHILIPPINES', 'Philippines', 'PHL', '608'),
(161, 'PN', 'PITCAIRN', 'Pitcairn', 'PCN', '612'),
(162, 'PL', 'POLAND', 'Poland', 'POL', '616'),
(163, 'PT', 'PORTUGAL', 'Portugal', 'PRT', '620'),
(164, 'PR', 'PUERTO RICO', 'PuertoRico', 'PRI', '630'),
(165, 'QA', 'QATAR', 'Qatar', 'QAT', '634'),
(166, 'RE', 'REUNION', 'Reunion', 'REU', '638'),
(167, 'RO', 'ROMANIA', 'Romania', 'ROM', '642'),
(168, 'RU', 'RUSSIAN FEDERATION', 'RussianFederation', 'RUS', '643'),
(169, 'RW', 'RWANDA', 'Rwanda', 'RWA', '646'),
(170, 'SH', 'SAINT HELENA', 'SaintHelena', 'SHN', '654'),
(171, 'KN', 'SAINT KITTS AND NEVIS', 'SaintKittsAndNevis', 'KNA', '659'),
(172, 'LC', 'SAINT LUCIA', 'SaintLucia', 'LCA', '662'),
(173, 'PM', 'SAINT PIERRE AND MIQUELON', 'SaintPierreAndMiquelon', 'SPM', '666'),
(174, 'VC', 'SAINT VINCENT AND THE GRENADINES', 'SaintVincentAndTheGrenadines', 'VCT', '670'),
(175, 'WS', 'SAMOA', 'Samoa', 'WSM', '882'),
(176, 'SM', 'SAN MARINO', 'SanMarino', 'SMR', '674'),
(177, 'ST', 'SAO TOME AND PRINCIPE', 'SaoTomeAndPrincipe', 'STP', '678'),
(178, 'SA', 'SAUDI ARABIA', 'SaudiArabia', 'SAU', '682'),
(179, 'SN', 'SENEGAL', 'Senegal', 'SEN', '686'),
(180, 'SC', 'SEYCHELLES', 'Seychelles', 'SYC', '690'),
(181, 'SL', 'SIERRA LEONE', 'SierraLeone', 'SLE', '694'),
(182, 'SG', 'SINGAPORE', 'Singapore', 'SGP', '702'),
(183, 'SK', 'SLOVAKIA', 'Slovakia', 'SVK', '703'),
(184, 'SI', 'SLOVENIA', 'Slovenia', 'SVN', '705'),
(185, 'SB', 'SOLOMON ISLANDS', 'SolomonIslands', 'SLB', '090'),
(186, 'SO', 'SOMALIA', 'Somalia', 'SOM', '706'),
(187, 'ZA', 'SOUTH AFRICA', 'SouthAfrica', 'ZAF', '710'),
(188, 'ES', 'SPAIN', 'Spain', 'ESP', '724'),
(189, 'LK', 'SRI LANKA', 'SriLanka', 'LKA', '144'),
(190, 'SD', 'SUDAN', 'Sudan', 'SDN', '736'),
(191, 'SR', 'SURINAME', 'Suriname', 'SUR', '740'),
(192, 'SJ', 'SVALBARD AND JAN MAYEN', 'SvalbardAndJanMayen', 'SJM', '744'),
(193, 'SZ', 'SWAZILAND', 'Swaziland', 'SWZ', '748'),
(194, 'SE', 'SWEDEN', 'Sweden', 'SWE', '752'),
(195, 'CH', 'SWITZERLAND', 'Switzerland', 'CHE', '756'),
(196, 'SY', 'SYRIAN ARAB REPUBLIC', 'SyrianArabRepublic', 'SYR', '760'),
(197, 'TW', 'TAIWAN, PROVINCE OF CHINA', 'Taiwan', 'TWN', '158'),
(198, 'TJ', 'TAJIKISTAN', 'Tajikistan', 'TJK', '762'),
(199, 'TZ', 'TANZANIA, UNITED REPUBLIC OF', 'Tanzania', 'TZA', '834'),
(200, 'TH', 'THAILAND', 'Thailand', 'THA', '764'),
(201, 'TG', 'TOGO', 'Togo', 'TGO', '768'),
(202, 'TK', 'TOKELAU', 'Tokelau', 'TKL', '772'),
(203, 'TO', 'TONGA', 'Tonga', 'TON', '776'),
(204, 'TT', 'TRINIDAD AND TOBAGO', 'TrinidadAndTobago', 'TTO', '780'),
(205, 'TN', 'TUNISIA', 'Tunisia', 'TUN', '788'),
(206, 'TR', 'TURKEY', 'Turkey', 'TUR', '792'),
(207, 'TM', 'TURKMENISTAN', 'Turkmenistan', 'TKM', '795'),
(208, 'TC', 'TURKS AND CAICOS ISLANDS', 'TurksAndCaicosIslands', 'TCA', '796'),
(209, 'TV', 'TUVALU', 'Tuvalu', 'TUV', '798'),
(210, 'UG', 'UGANDA', 'Uganda', 'UGA', '800'),
(211, 'UA', 'UKRAINE', 'Ukraine', 'UKR', '804'),
(212, 'AE', 'UNITED ARAB EMIRATES', 'UnitedArabEmirates', 'ARE', '784'),
(213, 'GB', 'UNITED KINGDOM', 'UnitedKingdom', 'GBR', '826'),
(214, 'US', 'UNITED STATES', 'UnitedStates', 'USA', '840'),
(215, 'UY', 'URUGUAY', 'Uruguay', 'URY', '858'),
(216, 'UZ', 'UZBEKISTAN', 'Uzbekistan', 'UZB', '860'),
(217, 'VU', 'VANUATU', 'Vanuatu', 'VUT', '548'),
(218, 'VE', 'VENEZUELA', 'Venezuela', 'VEN', '862'),
(219, 'VN', 'VIET NAM', 'VietNam', 'VNM', '704'),
(220, 'VG', 'VIRGIN ISLANDS, BRITISH', 'VirginIslandsBritish', 'VGB', '092'),
(221, 'VI', 'VIRGIN ISLANDS, U.S.', 'VirginIslandsUs', 'VIR', '850'),
(222, 'WF', 'WALLIS AND FUTUNA', 'WallisAndFutuna', 'WLF', '876'),
(223, 'EH', 'WESTERN SAHARA', 'WesternSahara', 'ESH', '732'),
(224, 'YE', 'YEMEN', 'Yemen', 'YEM', '887'),
(225, 'ZM', 'ZAMBIA', 'Zambia', 'ZMB', '894'),
(226, 'ZW', 'ZIMBABWE', 'Zimbabwe', 'ZWE', '716');

-- --------------------------------------------------------

--
-- Table structure for table `course`
--

CREATE TABLE `course` (
  `code` varchar(40) NOT NULL,
  `directory` varchar(40) DEFAULT NULL,
  `db_name` varchar(40) DEFAULT NULL,
  `course_language` varchar(20) DEFAULT NULL,
  `title` varchar(250) DEFAULT NULL,
  `description` text,
  `category_code` varchar(40) DEFAULT NULL,
  `visibility` tinyint(4) DEFAULT '0',
  `show_score` int(11) NOT NULL DEFAULT '1',
  `tutor_name` varchar(200) DEFAULT NULL,
  `visual_code` varchar(40) DEFAULT NULL,
  `department_name` varchar(30) DEFAULT NULL,
  `department_url` varchar(180) DEFAULT NULL,
  `disk_quota` int(10) unsigned DEFAULT NULL,
  `last_visit` datetime DEFAULT NULL,
  `last_edit` datetime DEFAULT NULL,
  `creation_date` datetime DEFAULT NULL,
  `expiration_date` datetime DEFAULT NULL,
  `target_course_code` varchar(40) DEFAULT NULL,
  `subscribe` tinyint(4) NOT NULL DEFAULT '1',
  `unsubscribe` tinyint(4) NOT NULL DEFAULT '1',
  `registration_code` varchar(255) NOT NULL DEFAULT '',
  `default_enrolment` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `course_category`
--

CREATE TABLE `course_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `code` varchar(40) NOT NULL DEFAULT '',
  `parent_id` varchar(40) DEFAULT NULL,
  `tree_pos` int(10) unsigned DEFAULT NULL,
  `children_count` smallint(6) DEFAULT NULL,
  `auth_course_child` enum('TRUE','FALSE') DEFAULT 'TRUE',
  `auth_cat_child` enum('TRUE','FALSE') DEFAULT 'TRUE',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `parent_id` (`parent_id`),
  KEY `tree_pos` (`tree_pos`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `course_category`
--

INSERT INTO `course_category` VALUES
(1, 'Language skills', 'LANG', NULL, 1, 0, 'TRUE', 'TRUE'),
(2, 'PC Skills', 'PC', NULL, 2, 0, 'TRUE', 'TRUE'),
(3, 'Projects', 'PROJ', NULL, 3, 0, 'TRUE', 'TRUE');

-- --------------------------------------------------------

--
-- Table structure for table `course_field`
--

CREATE TABLE `course_field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_type` int(11) NOT NULL DEFAULT '1',
  `field_variable` varchar(64) NOT NULL,
  `field_display_text` varchar(64) DEFAULT NULL,
  `field_default_value` text,
  `field_order` int(11) DEFAULT NULL,
  `field_visible` tinyint(4) DEFAULT '0',
  `field_changeable` tinyint(4) DEFAULT '0',
  `field_filter` tinyint(4) DEFAULT '0',
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `course_field_values`
--

CREATE TABLE `course_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_code` varchar(40) NOT NULL,
  `field_id` int(11) NOT NULL,
  `field_value` text,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `course_module`
--

CREATE TABLE `course_module` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `link` varchar(255) NOT NULL,
  `image` varchar(100) DEFAULT NULL,
  `row` int(10) unsigned NOT NULL DEFAULT '0',
  `column` int(10) unsigned NOT NULL DEFAULT '0',
  `position` varchar(20) NOT NULL DEFAULT 'basic',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=29 ;

--
-- Dumping data for table `course_module`
--

INSERT INTO `course_module` VALUES
(1, 'calendar_event', 'calendar/agenda.php', 'agenda.png', 1, 1, 'basic'),
(2, 'link', 'link/link.php', 'links.gif', 4, 1, 'basic'),
(3, 'document', 'document/document.php', 'documents.gif', 3, 1, 'basic'),
(4, 'student_publication', 'work/work.php', 'works.gif', 3, 2, 'basic'),
(5, 'announcement', 'announcements/announcements.php', 'valves.png', 2, 1, 'basic'),
(6, 'user', 'user/user.php', 'members.gif', 2, 3, 'basic'),
(7, 'forum', 'forum/index.php', 'forum.gif', 1, 2, 'basic'),
(8, 'quiz', 'exercice/exercice.php', 'quiz.gif', 2, 2, 'basic'),
(9, 'group', 'group/group.php', 'group.gif', 3, 3, 'basic'),
(10, 'course_description', 'course_description/', 'info.gif', 1, 3, 'basic'),
(11, 'chat', 'chat/chat.php', 'chat.gif', 0, 0, 'external'),
(12, 'dropbox', 'dropbox/index.php', 'dropbox.gif', 4, 2, 'basic'),
(13, 'tracking', 'tracking/courseLog.php', 'statistics.png', 1, 3, 'courseadmin'),
(14, 'homepage_link', 'link/link.php?action=addlink', 'npage.gif', 1, 1, 'courseadmin'),
(15, 'course_setting', 'course_info/infocours.php', 'reference.gif', 1, 1, 'courseadmin'),
(16, 'External', '', 'external.gif', 0, 0, 'external'),
(17, 'AddedLearnpath', '', 'scormbuilder.gif', 0, 0, 'external'),
(18, 'conference', 'conference/index.php?type=conference', 'conf.gif', 0, 0, 'external'),
(19, 'conference', 'conference/index.php?type=classroom', 'conf.gif', 0, 0, 'external'),
(20, 'learnpath', 'newscorm/lp_controller.php', 'scorm.gif', 5, 1, 'basic'),
(21, 'blog', 'blog/blog.php', 'blog.gif', 1, 2, 'basic'),
(22, 'blog_management', 'blog/blog_admin.php', 'blog_admin.gif', 1, 2, 'courseadmin'),
(23, 'course_maintenance', 'course_info/maintenance.php', 'backup.gif', 2, 3, 'courseadmin'),
(24, 'survey', 'survey/survey_list.php', 'survey.gif', 2, 1, 'basic'),
(25, 'wiki', 'wiki/index.php', 'wiki.gif', 2, 3, 'basic'),
(26, 'gradebook', 'gradebook/index.php', 'gradebook.gif', 2, 2, 'basic'),
(27, 'glossary', 'glossary/index.php', 'glossary.gif', 2, 1, 'basic'),
(28, 'notebook', 'notebook/index.php', 'notebook.gif', 2, 1, 'basic');

-- --------------------------------------------------------

--
-- Table structure for table `course_rel_class`
--

CREATE TABLE `course_rel_class` (
  `course_code` char(40) NOT NULL,
  `class_id` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`course_code`,`class_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `course_rel_user`
--

CREATE TABLE `course_rel_user` (
  `course_code` varchar(40) NOT NULL,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '5',
  `role` varchar(60) DEFAULT NULL,
  `group_id` int(11) NOT NULL DEFAULT '0',
  `tutor_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sort` int(11) DEFAULT NULL,
  `user_course_cat` int(11) DEFAULT '0',
  PRIMARY KEY (`course_code`,`user_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `email_template`
--

CREATE TABLE `email_template` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(250) NOT NULL,
  `description` text NOT NULL,
  `image` varchar(250) NOT NULL,
  `language` varchar(250) NOT NULL,
  `content` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=26 ;

--
-- Dumping data for table `email_template`
--

INSERT INTO `email_template` VALUES
(1, 'User Registration', 'Userregistration', 'emailtemplate.png', 'english', ''),
(2, 'Quiz Report', 'Quizreport', 'emailtemplate.png', 'english', ''),
(3, 'Utilisateurs inscrire', 'Userregistration', 'emailtemplate.png', 'french', ''),
(4, 'Quiz suivi', 'Quizreport', 'emailtemplate.png', 'french', ''),
(5, 'Nutzer registrieren', 'Userregistration', 'emailtemplate.png', 'german', ''),
(6, 'Test statistik', 'Quizreport', 'emailtemplate.png', 'german', ''),
(7, 'Quiz Success Report', 'Quizsuccess', 'emailtemplate.png', 'english', ''),
(8, 'Quiz Failure Report', 'Quizfailure', 'emailtemplate.png', 'english', ''),
(9, 'Rapport de reussite Quiz', 'Quizsuccess', 'emailtemplate.png', 'french', ''),
(10, 'Rapport non Quiz', 'Quizfailure', 'emailtemplate.png', 'french', ''),
(11, 'Quiz Erfolgsbericht', 'Quizsuccess', 'emailtemplate.png', 'german', ''),
(12, 'Quiz Fehler Bericht', 'Quizfailure', 'emailtemplate.png', 'german', ''),
(13, 'New Assignment', 'Newassignment', 'emailtemplate.png', 'english', 'Dear {Name} ,<br/><br/>\r\n\r\nCreated New Assignment :  {courseName} <br/>\r\n\r\n{assignmentName} <br/>\r\n\r\n{assignmentDescription} <br/><br/>\r\n\r\nDeadline : {assignmentDeadline} <br/>\r\n\r\nUpload your paper on : {siteName} <br/>\r\n\r\nYours, <br/><br/>\r\n\r\n{authorName} <br/>\r\n'),
(14, 'Submit Work', 'Submitwork', 'emailtemplate.png', 'english', 'Dear {authorName} ,<br/><br/>\r\n\r\n{studentName} has published a paper named <br/>\r\n\r\n{paperName} <br/>\r\n\r\nfor the {assignmentName} - {assignmentDescription}in the course {courseName} <br/> <br/>\r\n\r\nDeadline was : {assignmentDeadline}\r\n<br/>\r\nThe paper was submitted on : {assignmentSentDate} <br/>\r\n\r\nYou can mark, comment and correct this paper on  : {siteName} <br/>\r\n\r\nYours, <br/><br/>\r\n\r\n{administratorSurname} <br/>\r\n'),
(15, 'Correct Work', 'Correctwork', 'emailtemplate.png', 'english', 'Dear {studentName} ,<br/><br/>\r\n\r\nI have corrected your Paper <br/>\r\n\r\n{paperName}  <br/>\r\n\r\nfor the {assignmentName} - {assignmentDescription}in the course{courseName} <br/><br/>\r\n\r\nDeadline was : {assignmentDeadline} <br/>\r\n\r\nThe paper was submitted on : {assignmentSentDate} <br/>\r\n\r\nCheck your mark and /or corrections on : {siteName} <br/>\r\n\r\nYours, <br/><br/>\r\n\r\n{authorName} <br/>\r\n'),
(16, 'Inscription par ch', 'EmailsInCaseOfChequePayment', 'emailtemplate.png', 'french', 'Cher ('),
(17, 'User registration with cheque payment', 'EmailsInCaseOfChequePayment', 'emailtemplate.png', 'english', 'Dear {firstName} {lastName} ,<br/><br/>\n\nYou are registered to the {Programme} Programme on {siteName} {Institution}<br/>\n\nLOGIN : {username}\nPASSWORD : {password}<br/><br/>\n\nAs you paid by cheque, your account will be activated once we validate your payment. <br/>\n\n{siteName} offers you a true e-learning experience with the posibilty to progress step by step in your learning process under the supervision of a tutor that is dedicated to your support. For more details : {url}\n\nThank you for trusting {Institution}.\n\nYours,\n\n{siteName}\n{administratorSurname}'),
(18, 'Inscription ', 'UserRegistrationToSession', 'emailtemplate.png', 'french', 'Cher('),
(19, 'New Group', 'NewGroup', 'emailtemplate.png', 'english', 'Dear {adminName} ,<br/><br/>\r\n\r\nNew Group created automatically to give space to new user <br/><br/>\r\n\r\nGroup : {groupName} <br/><br/>\r\n\r\nSeats :  {maxStudent} <br/><br/>\r\n\r\nIn course : {courseName} <br/><br/>\r\n\r\nYours, <br/><br/>\r\n\r\n{authorName} <br/><br/>\r\n'),
(20, 'Nouveau devoir', 'Newassignment', 'emailtemplate.png', 'french', 'Cher('),
(21, 'Travail publi', 'Submitwork', 'emailtemplate.png', 'french', 'Cher('),
(22, 'Travail corrig', 'Correctwork', 'emailtemplate.png', 'french', 'Cher('),
(23, 'Nouveau groupe', 'NewGroup', 'emailtemplate.png', 'french', 'Cher('),
(24, 'Inscription carte ou 3 fois', 'EmailsRegistrationInCaseCreditCardOrInstallment', 'emailtemplate.png', 'french', 'Cher('),
(25, 'User Registration with credit card or 3 installment payment', 'EmailsRegistrationInCaseCreditCardOrInstallment', 'emailtemplate.png', 'english', 'Dear {firstName} {lastName},\r\n\r\nYou are registered to the {Programme} Programme on {siteName} {Institution} portal {InstitutionUrl}.\r\nLOGIN : {username}\r\nPASSWORD : {password}\r\n\r\n{siteName} offers you a true e-learning experience with the posibilty to progress step by step in your learning process under the supervision of a tutor that is dedicated to your support. For more details : {detailsUrl}.\r\n\r\nThank you for trusting {Institution}.\r\n\r\nYours,\r\n\r\n{siteName}\r\n\r\n{administratorSurname}');

-- --------------------------------------------------------

--
-- Table structure for table `gradebook_category`
--

CREATE TABLE `gradebook_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `description` text,
  `user_id` int(11) NOT NULL,
  `course_code` varchar(40) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `weight` smallint(6) NOT NULL,
  `visible` tinyint(4) NOT NULL,
  `certif_min_score` int(11) DEFAULT NULL,
  `session_id` int(11) DEFAULT NULL,
  `document_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `gradebook_certificate`
--

CREATE TABLE `gradebook_certificate` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cat_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `score_certificate` float unsigned NOT NULL DEFAULT '0',
  `date_certificate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `path_certificate` text,
  PRIMARY KEY (`id`),
  KEY `idx_gradebook_certificate_category_id` (`cat_id`),
  KEY `idx_gradebook_certificate_user_id` (`user_id`),
  KEY `idx_gradebook_certificate_category_id_user_id` (`cat_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `gradebook_evaluation`
--

CREATE TABLE `gradebook_evaluation` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `description` text,
  `user_id` int(11) NOT NULL,
  `course_code` varchar(40) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `date` int(11) DEFAULT '0',
  `weight` smallint(6) NOT NULL,
  `max` float unsigned NOT NULL,
  `visible` tinyint(4) NOT NULL,
  `type` varchar(40) NOT NULL DEFAULT 'evaluation',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `gradebook_link`
--

CREATE TABLE `gradebook_link` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL,
  `ref_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `course_code` varchar(40) NOT NULL,
  `category_id` int(11) NOT NULL,
  `date` int(11) DEFAULT NULL,
  `weight` smallint(6) NOT NULL,
  `visible` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `gradebook_linkeval_log`
--

CREATE TABLE `gradebook_linkeval_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_linkeval_log` int(11) NOT NULL,
  `name` text,
  `description` text,
  `date_log` int(11) DEFAULT NULL,
  `weight` smallint(6) DEFAULT NULL,
  `visible` tinyint(4) DEFAULT NULL,
  `type` varchar(20) NOT NULL,
  `user_id_log` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `gradebook_result`
--

CREATE TABLE `gradebook_result` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `evaluation_id` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  `score` float unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `gradebook_result_log`
--

CREATE TABLE `gradebook_result_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_result` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `evaluation_id` int(11) NOT NULL,
  `date_log` datetime DEFAULT '0000-00-00 00:00:00',
  `score` float unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `gradebook_score_display`
--

CREATE TABLE `gradebook_score_display` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `score` float unsigned NOT NULL,
  `display` varchar(40) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `group`
--

CREATE TABLE `group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `picture_uri` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL,
  `visibility` int(11) NOT NULL,
  `updated_on` varchar(255) NOT NULL,
  `created_on` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `group_rel_tag`
--

CREATE TABLE `group_rel_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `group_rel_user`
--

CREATE TABLE `group_rel_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `relation_type` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `language`
--

CREATE TABLE `language` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `original_name` varchar(255) DEFAULT NULL,
  `english_name` varchar(255) DEFAULT NULL,
  `isocode` varchar(10) DEFAULT NULL,
  `dokeos_folder` varchar(250) DEFAULT NULL,
  `available` tinyint(4) NOT NULL DEFAULT '1',
  `parent_id` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_language_dokeos_folder` (`dokeos_folder`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=54 ;

--
-- Dumping data for table `language`
--

INSERT INTO `language` VALUES
(1, 'Arabija (el)', 'arabic', 'ar', 'arabic', 0, NULL),
(2, 'Asturian', 'asturian', 'ast', 'asturian', 0, NULL),
(3, 'Balgarski', 'bulgarian', 'bg', 'bulgarian', 0, NULL),
(4, 'Bosanski', 'bosnian', 'bs', 'bosnian', 1, NULL),
(5, 'Catal&agrave;', 'catalan', 'ca', 'catalan', 0, NULL),
(6, 'Chinese (simplified)', 'simpl_chinese', 'zh', 'simpl_chinese', 0, NULL),
(7, 'Chinese (traditional)', 'trad_chinese', 'zh-TW', 'trad_chinese', 0, NULL),
(8, 'Czech', 'czech', 'cs', 'czech', 0, NULL),
(9, 'Dansk', 'danish', 'da', 'danish', 0, NULL),
(10, 'Dari', 'dari', 'prs', 'dari', 0, NULL),
(11, 'Deutsch', 'german', 'de', 'german', 1, NULL),
(12, 'Ellinika', 'greek', 'el', 'greek', 0, NULL),
(13, 'English', 'english', 'en', 'english', 1, NULL),
(14, 'Espa&ntilde;ol', 'spanish', 'es', 'spanish', 1, NULL),
(15, 'Esperanto', 'esperanto', 'eo', 'esperanto', 0, NULL),
(16, 'Euskara', 'euskera', 'eu', 'euskera', 0, NULL),
(17, 'Farsi', 'persian', 'fa', 'persian', 0, NULL),
(18, 'Fran&ccedil;ais', 'french', 'fr', 'french', 1, NULL),
(19, 'Friulian', 'friulian', 'fur', 'friulian', 0, NULL),
(20, 'Galego', 'galician', 'gl', 'galician', 0, NULL),
(21, 'Georgian', 'georgian', 'ka', 'georgian', 0, NULL),
(22, 'Hrvatski', 'croatian', 'hr', 'croatian', 0, NULL),
(23, 'Hebrew', 'hebrew', 'he', 'hebrew', 0, NULL),
(24, 'Indonesia (Bahasa I.)', 'indonesian', 'id', 'indonesian', 1, NULL),
(25, 'Italiano', 'italian', 'it', 'italian', 1, NULL),
(26, 'Korean', 'korean', 'ko', 'korean', 0, NULL),
(27, 'Latvian', 'latvian', 'lv', 'latvian', 0, NULL),
(28, 'Lithuanian', 'lithuanian', 'lt', 'lithuanian', 0, NULL),
(29, 'Macedonian', 'macedonian', 'mk', 'macedonian', 0, NULL),
(30, 'Magyar', 'hungarian', 'hu', 'hungarian', 1, NULL),
(31, 'Melayu (Bahasa M.)', 'malay', 'ms', 'malay', 0, NULL),
(32, 'Nederlands', 'dutch', 'nl', 'dutch', 1, NULL),
(33, 'Nihongo', 'japanese', 'ja', 'japanese', 0, NULL),
(34, 'Norsk', 'norwegian', 'no', 'norwegian', 0, NULL),
(35, 'Occitan', 'occitan', 'oc', 'occitan', 0, NULL),
(36, 'Pashto', 'pashto', 'ps', 'pashto', 0, NULL),
(37, 'Polski', 'polish', 'pl', 'polish', 0, NULL),
(38, 'Portugu&ecirc;s (Portugal)', 'portuguese', 'pt', 'portuguese', 1, NULL),
(39, 'Portugu&ecirc;s (Brazil)', 'brazilian', 'pt-BR', 'brazilian', 1, NULL),
(40, 'Romanian', 'romanian', 'ro', 'romanian', 0, NULL),
(41, 'Runasimi', 'quechua_cusco', 'qu', 'quechua_cusco', 0, NULL),
(42, 'Russkij', 'russian', 'ru', 'russian', 0, NULL),
(43, 'Slovak', 'slovak', 'sk', 'slovak', 0, NULL),
(44, 'Slovenscina', 'slovenian', 'sl', 'slovenian', 1, NULL),
(45, 'Srpski', 'serbian', 'sr', 'serbian', 0, NULL),
(46, 'Suomi', 'finnish', 'fi', 'finnish', 0, NULL),
(47, 'Svenska', 'swedish', 'sv', 'swedish', 0, NULL),
(48, 'Thai', 'thai', 'th', 'thai', 0, NULL),
(49, 'T&uuml;rk&ccedil;e', 'turkce', 'tr', 'turkce', 0, NULL),
(50, 'Ukrainian', 'ukrainian', 'uk', 'ukrainian', 0, NULL),
(51, 'Vi&ecirc;t (Ti&ecirc;ng V.)', 'vietnamese', 'vi', 'vietnamese', 0, NULL),
(52, 'Swahili (kiSw.)', 'swahili', 'sw', 'swahili', 0, NULL),
(53, 'Yoruba', 'yoruba', 'yo', 'yoruba', 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `legal`
--

CREATE TABLE `legal` (
  `legal_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL,
  `date` int(11) NOT NULL DEFAULT '0',
  `content` text,
  `type` int(11) NOT NULL,
  `changes` text NOT NULL,
  `version` int(11) DEFAULT NULL,
  PRIMARY KEY (`legal_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `message`
--

CREATE TABLE `message` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_sender_id` int(10) unsigned NOT NULL,
  `user_receiver_id` int(10) unsigned NOT NULL,
  `msg_status` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `send_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `group_id` int(10) unsigned NOT NULL DEFAULT '0',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `update_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_message_user_sender` (`user_sender_id`),
  KEY `idx_message_user_receiver` (`user_receiver_id`),
  KEY `idx_message_user_sender_user_receiver` (`user_sender_id`,`user_receiver_id`),
  KEY `idx_message_group` (`group_id`),
  KEY `idx_message_parent` (`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `message_attachment`
--

CREATE TABLE `message_attachment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `path` varchar(255) NOT NULL,
  `comment` text,
  `size` int(11) NOT NULL DEFAULT '0',
  `message_id` int(11) NOT NULL,
  `filename` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `openid_association`
--

CREATE TABLE `openid_association` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idp_endpoint_uri` text NOT NULL,
  `session_type` varchar(30) NOT NULL,
  `assoc_handle` text NOT NULL,
  `assoc_type` text NOT NULL,
  `expires_in` bigint(20) NOT NULL,
  `mac_key` text NOT NULL,
  `created` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `payer_user`
--

CREATE TABLE `payer_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `firstname` varchar(200) NOT NULL,
  `lastname` varchar(200) DEFAULT NULL,
  `email` varchar(200) DEFAULT NULL,
  `street_number` text,
  `street` text,
  `zipcode` varchar(20) DEFAULT NULL,
  `city` varchar(200) DEFAULT NULL,
  `country` varchar(200) DEFAULT NULL,
  `student_id` int(11) NOT NULL DEFAULT '0',
  `company` varchar(200) DEFAULT NULL,
  `vat_number` varchar(20) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `civility` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `payment_atos`
--

CREATE TABLE `payment_atos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `sess_id` int(11) NOT NULL DEFAULT '0',
  `pay_type` int(11) NOT NULL DEFAULT '0',
  `pay_data` text,
  `pay_time` int(11) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',
  `curr_quota` int(11) NOT NULL DEFAULT '0',
  `transaction_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `payment_log`
--

CREATE TABLE `payment_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `sess_id` int(11) NOT NULL DEFAULT '0',
  `pay_type` int(11) NOT NULL DEFAULT '0',
  `pay_data` text,
  `pay_time` int(11) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',
  `curr_quota` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `personal_agenda`
--

CREATE TABLE `personal_agenda` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(10) unsigned DEFAULT NULL,
  `title` text,
  `text` text,
  `date` datetime DEFAULT NULL,
  `enddate` datetime DEFAULT NULL,
  `course` varchar(255) DEFAULT NULL,
  `parent_event_id` int(11) DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `personal_agenda_repeat`
--

CREATE TABLE `personal_agenda_repeat` (
  `cal_id` int(11) NOT NULL DEFAULT '0',
  `cal_type` varchar(20) DEFAULT NULL,
  `cal_end` int(11) DEFAULT NULL,
  `cal_frequency` int(11) DEFAULT '1',
  `cal_days` char(7) DEFAULT NULL,
  PRIMARY KEY (`cal_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `personal_agenda_repeat_not`
--

CREATE TABLE `personal_agenda_repeat_not` (
  `cal_id` int(11) NOT NULL,
  `cal_date` int(11) NOT NULL,
  PRIMARY KEY (`cal_id`,`cal_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `php_session`
--

CREATE TABLE `php_session` (
  `session_id` varchar(32) NOT NULL DEFAULT '',
  `session_name` varchar(10) NOT NULL DEFAULT '',
  `session_time` int(11) NOT NULL DEFAULT '0',
  `session_start` int(11) NOT NULL DEFAULT '0',
  `session_value` mediumtext NOT NULL,
  PRIMARY KEY (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `quiz_answer_templates`
--

CREATE TABLE `quiz_answer_templates` (
  `id` mediumint(8) unsigned NOT NULL,
  `question_id` mediumint(8) unsigned NOT NULL,
  `answer` text NOT NULL,
  `correct` mediumint(8) unsigned DEFAULT NULL,
  `comment` text,
  `ponderation` float(6,2) NOT NULL DEFAULT '0.00',
  `position` mediumint(8) unsigned NOT NULL DEFAULT '1',
  `hotspot_coordinates` text,
  `hotspot_type` enum('square','circle','poly','delineation') DEFAULT NULL,
  `destination` text NOT NULL,
  PRIMARY KEY (`id`,`question_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `quiz_answer_templates`
--

INSERT INTO `quiz_answer_templates` VALUES
(3, 1, '239', 1, 'Correct. 239 is the only number not ending with ''40''', 10.00, 3, '', '', '0@@0@@0@@0'),
(2, 1, '140', 0, 'Wrong. Try again', 0.00, 2, '', '', '0@@0@@0@@0'),
(4, 2, 'A medical office building with eleven doctors'' officies', 1, 'Correct.', 3.33, 4, '', '', ''),
(3, 2, 'A convent occupied by five nuns', 1, 'Correct.', 3.33, 3, '', '', ''),
(4, 1, '340', 0, 'Wrong. Try again', 0.00, 4, '', '', '0@@0@@0@@0'),
(2, 2, 'A house in which a family or six and three boarders live', 1, 'Correct.', 3.33, 2, '', '', ''),
(3, 3, 'Idaho', 0, 'Wrong. Try again.', 0.00, 3, '', '', ''),
(2, 3, 'Montana', 0, 'Wrong. Try again.', 0.00, 2, '', '', ''),
(5, 5, '2', 1, '', 0.00, 5, '', '', ''),
(6, 5, '3', 2, '', 0.00, 6, '', '', ''),
(1, 6, '', 1, '', 0.00, 1, '', '', ''),
(1, 7, '', NULL, '', 10.00, 1, '0;0|0|0', 'square', ''),
(4, 5, '1', 2, '', 0.00, 4, '', '', ''),
(3, 5, 'Check skin temperature', 0, '', 0.00, 3, '', '', ''),
(2, 5, 'Tell casualty not to move', 0, 'Wrong! Try again.', 0.00, 2, '', '', ''),
(1, 4, '<div><font size="2">Group Quarters : Any living quarters occupied by ten  or more [unrelated] persons is called a group quarters. Examples of a  group quarters are worker''s dormitories, boading houses, halfway houses,  convents, etc. In addition, college [dormitories], fraternity houses,  or nurse''s dormitories are [always] considered  to be a group quarters,  regardless of the [number] of students who live there.</font></div>\r\n<p> </p>::10,10,10,10@', 0, 'a:2:{s:10:"comment[1]";s:8:"Correct.";s:10:"comment[2]";s:16:"Wrong! Try again";}', 0.00, 0, '', '', ''),
(1, 5, 'Call ambulance', 0, 'Correct.', 0.00, 1, '', '', ''),
(4, 3, 'Oregon', 0, 'Wrong. Try again.', 0.00, 4, '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `quiz_question_templates`
--

CREATE TABLE `quiz_question_templates` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `question` varchar(200) NOT NULL,
  `description` text,
  `ponderation` float(6,2) NOT NULL DEFAULT '0.00',
  `position` mediumint(8) unsigned NOT NULL DEFAULT '1',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '2',
  `picture` varchar(50) DEFAULT NULL,
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `image` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `position` (`position`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

--
-- Dumping data for table `quiz_question_templates`
--

INSERT INTO `quiz_question_templates` VALUES
(1, 'Which of the numbers below does not follow the pattern ...40, 140, 239, 340 ?10', '<table cellspacing="2" cellpadding="0" width="98%" height="100%" style="font-family: Comic Sans MS; font-size: 16px;">\r\n    <tbody>\r\n        <tr>\r\n            <td align="center" height="323px"><img height="310px" alt="" src="../img/instructor-projection.png" /></td>\r\n        </tr>\r\n    </tbody>\r\n</table>', 10.00, 1, 1, '', 1, 'multiple_choice.png'),
(2, 'According to the definition below, which of the following is NOT a group quarters ? ', '<table cellspacing="2" cellpadding="0" width="98%" height="100%" style="font-family: Comic Sans MS; font-size: 16px;">\r\n    <tbody>\r\n        <tr>\r\n            <td align="center" height="323px"><img height="310px" src="../img/instructor-projection.png" alt="" /></td>\r\n        </tr>\r\n    </tbody>\r\n</table>', 10.00, 2, 2, '', 1, 'multiple_answer.png'),
(3, 'What states does Columbia River run through ? Full sequence of correct answers must be right to get the score', '<table cellspacing="2" cellpadding="0" width="98%" height="100%" style="font-family: Comic Sans MS; font-size: 16px;">\r\n    <tbody>\r\n        <tr>\r\n            <td align="center" height="323px"><img height="310px" src="../img/instructor-projection.png" alt="" /></td>\r\n        </tr>\r\n    </tbody>\r\n</table>', 0.00, 3, 8, '', 1, 'reasoning.png'),
(4, 'In the previous question, you were given the definition of "Group Quarters". Fill in the missing words.', '<table cellspacing="2" cellpadding="0" width="98%" height="100%" style="font-family: Comic Sans MS; font-size: 16px;">\r\n    <tbody>\r\n        <tr>\r\n            <td align="center" height="323px"><img height="310px" src="../img/instructor-projection.png" alt="" /></td>\r\n        </tr>\r\n    </tbody>\r\n</table>', 40.00, 4, 3, '', 1, 'fill_in_the_blank.png'),
(5, 'On a car accident scene, in what sequence do you proceed to the following actions ?', '', 0.00, 5, 4, '', 1, 'drag_drop.png'),
(6, 'Explain the difference between a clinic and a hospital.', '<table cellspacing="2" cellpadding="0" width="98%" height="100%" style="font-family: Comic Sans MS; font-size: 16px;">\r\n    <tbody>\r\n        <tr>\r\n            <td align="center" height="323px"><img height="310px" src="../img/instructor-projection.png" alt="" /></td>\r\n        </tr>\r\n    </tbody>\r\n</table>', 10.00, 6, 5, '', 1, 'open-question.png'),
(7, 'Identify each device of this computer.', '', 0.00, 7, 6, 'quiz-12.jpg', 1, 'dokeos_hotspots.png'),
(10, 'On a car accident scene, in what sequence do you proceed to the following actions ?', '', 0.00, 9, 4, '', 1, 'drag_drop.png'),
(13, 'Which of the numbers below does not follow the pattern ...40, 140, 239, 340 ?10', '<table cellspacing="2" cellpadding="0" width="98%" height="100%" style="font-family: Comic Sans MS; font-size: 16px;">\r\n    <tbody>\r\n        <tr>\r\n            <td align="center" height="323px"><img height="310px" alt="" src="../img/instructor-projection.png" /></td>\r\n        </tr>\r\n    </tbody>\r\n</table>', 10.00, 1, 1, '', 1, 'multiple_choice.png'),
(12, 'Which of the numbers below does not follow the pattern ...40, 140, 239, 340 ?10', '<table cellspacing="2" cellpadding="0" width="98%" height="100%" style="font-family: Comic Sans MS; font-size: 16px;">\r\n    <tbody>\r\n        <tr>\r\n            <td align="center" height="323px"><img height="310px" alt="" src="../img/instructor-projection.png" /></td>\r\n        </tr>\r\n    </tbody>\r\n</table>', 10.00, 1, 1, '', 1, 'multiple_choice.png'),
(11, 'Which of the numbers below does not follow the pattern ...40, 140, 239, 340 ?10', '<table cellspacing="2" cellpadding="0" width="98%" height="100%" style="font-family: Comic Sans MS; font-size: 16px;">\r\n    <tbody>\r\n        <tr>\r\n            <td align="center" height="323px"><img height="310px" alt="" src="../img/instructor-projection.png" /></td>\r\n        </tr>\r\n    </tbody>\r\n</table>', 10.00, 1, 1, '', 1, 'multiple_choice.png');

-- --------------------------------------------------------

--
-- Table structure for table `reservation_category`
--

CREATE TABLE `reservation_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(128) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `reservation_category_rights`
--

CREATE TABLE `reservation_category_rights` (
  `category_id` int(11) NOT NULL DEFAULT '0',
  `class_id` int(11) NOT NULL DEFAULT '0',
  `m_items` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `reservation_item`
--

CREATE TABLE `reservation_item` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `course_code` varchar(40) NOT NULL DEFAULT '',
  `name` varchar(128) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `blackout` tinyint(4) NOT NULL DEFAULT '0',
  `creator` int(10) unsigned NOT NULL DEFAULT '0',
  `always_available` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `reservation_item_rights`
--

CREATE TABLE `reservation_item_rights` (
  `item_id` int(10) unsigned NOT NULL DEFAULT '0',
  `class_id` int(10) unsigned NOT NULL DEFAULT '0',
  `edit_right` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `delete_right` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `m_reservation` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `view_right` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_id`,`class_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `reservation_main`
--

CREATE TABLE `reservation_main` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `subid` int(10) unsigned NOT NULL DEFAULT '0',
  `item_id` int(10) unsigned NOT NULL DEFAULT '0',
  `auto_accept` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `max_users` int(10) unsigned NOT NULL DEFAULT '1',
  `start_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `subscribe_from` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `subscribe_until` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `subscribers` int(10) unsigned NOT NULL DEFAULT '0',
  `notes` text NOT NULL,
  `timepicker` tinyint(4) NOT NULL DEFAULT '0',
  `timepicker_min` int(11) NOT NULL DEFAULT '0',
  `timepicker_max` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `reservation_subscription`
--

CREATE TABLE `reservation_subscription` (
  `dummy` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `reservation_id` int(10) unsigned NOT NULL DEFAULT '0',
  `accepted` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `start_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`dummy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `search_engine_keywords`
--

CREATE TABLE `search_engine_keywords` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idobj` int(11) DEFAULT NULL,
  `course_code` varchar(45) DEFAULT NULL,
  `tool_id` varchar(100) DEFAULT NULL,
  `value` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `search_engine_ref`
--

CREATE TABLE `search_engine_ref` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_code` varchar(40) NOT NULL,
  `tool_id` varchar(100) NOT NULL,
  `ref_id_high_level` int(11) NOT NULL,
  `ref_id_second_level` int(11) DEFAULT NULL,
  `search_did` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `session`
--

CREATE TABLE `session` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `id_coach` int(10) unsigned NOT NULL DEFAULT '0',
  `name` char(50) NOT NULL DEFAULT '',
  `description` text,
  `nbr_courses` smallint(5) unsigned NOT NULL DEFAULT '0',
  `nbr_users` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `nbr_classes` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `date_start` date NOT NULL DEFAULT '0000-00-00',
  `date_end` date NOT NULL DEFAULT '0000-00-00',
  `nb_days_access_before_beginning` tinyint(3) unsigned DEFAULT '0',
  `nb_days_access_after_end` tinyint(3) unsigned DEFAULT '0',
  `session_admin_id` int(10) unsigned NOT NULL,
  `visibility` int(11) NOT NULL DEFAULT '1',
  `session_category_id` int(11) NOT NULL,
  `seats` int(11) NOT NULL DEFAULT '-1',
  `max_seats` int(11) NOT NULL DEFAULT '-1',
  `optional_subject` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `session_admin_id` (`session_admin_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `session_category`
--

CREATE TABLE `session_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `description` text,
  `topic` int(11) NOT NULL DEFAULT '0',
  `location` varchar(250) DEFAULT NULL,
  `modality` varchar(255) DEFAULT NULL,
  `keywords` text,
  `date_start` date DEFAULT NULL,
  `date_end` date DEFAULT NULL,
  `student_access` varchar(50) DEFAULT NULL,
  `language` varchar(50) NOT NULL DEFAULT 'English',
  `visible` char(1) NOT NULL DEFAULT '0',
  `cost` float NOT NULL DEFAULT '0',
  `currency` varchar(250) DEFAULT NULL,
  `tax` int(11) NOT NULL DEFAULT '0',
  `method_payment` varchar(100) NOT NULL,
  `code` varchar(100) DEFAULT NULL,
  `inscription_date_start` date DEFAULT NULL,
  `inscription_date_end` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `session_category_rel_user`
--

CREATE TABLE `session_category_rel_user` (
  `category_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `session_id` int(11) NOT NULL DEFAULT '0',
  `course_code` varchar(200) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `session_field`
--

CREATE TABLE `session_field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_type` int(11) NOT NULL DEFAULT '1',
  `field_variable` varchar(64) NOT NULL,
  `field_display_text` varchar(64) DEFAULT NULL,
  `field_default_value` text,
  `field_order` int(11) DEFAULT NULL,
  `field_visible` tinyint(4) DEFAULT '0',
  `field_changeable` tinyint(4) DEFAULT '0',
  `field_filter` tinyint(4) DEFAULT '0',
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `session_field_values`
--

CREATE TABLE `session_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `field_value` text,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `session_rel_category`
--

CREATE TABLE `session_rel_category` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) DEFAULT '0',
  `session_set` char(1) NOT NULL DEFAULT '1',
  `session_set_name` varchar(255) DEFAULT NULL,
  `session_id` int(11) NOT NULL DEFAULT '0',
  `session_range` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `session_rel_course`
--

CREATE TABLE `session_rel_course` (
  `id_session` smallint(5) unsigned NOT NULL DEFAULT '0',
  `course_code` char(40) NOT NULL DEFAULT '',
  `hours` int(11) NOT NULL DEFAULT '0',
  `schedule` date NOT NULL DEFAULT '0000-00-00',
  `time_from` varchar(50) NOT NULL DEFAULT '00:00',
  `time_to` varchar(50) NOT NULL DEFAULT '00:00',
  `repeats` varchar(50) NOT NULL DEFAULT '',
  `repeats_on` varchar(50) NOT NULL DEFAULT '',
  `ends_on` int(11) NOT NULL DEFAULT '0',
  `occurence` varchar(50) NOT NULL DEFAULT '0',
  `position` int(11) NOT NULL DEFAULT '0',
  `nbr_users` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_session`,`course_code`),
  KEY `course_code` (`course_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `session_rel_course_rel_user`
--

CREATE TABLE `session_rel_course_rel_user` (
  `id_session` smallint(5) unsigned NOT NULL DEFAULT '0',
  `course_code` char(40) NOT NULL DEFAULT '',
  `id_user` int(10) unsigned NOT NULL DEFAULT '0',
  `visibility` int(11) NOT NULL DEFAULT '1',
  `status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_session`,`course_code`,`id_user`),
  KEY `id_user` (`id_user`),
  KEY `course_code` (`course_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `session_rel_user`
--

CREATE TABLE `session_rel_user` (
  `id_session` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `id_user` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_session`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `settings_current`
--

CREATE TABLE `settings_current` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variable` varchar(255) DEFAULT NULL,
  `subkey` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `category` varchar(255) DEFAULT NULL,
  `subcategory` varchar(250) DEFAULT NULL,
  `selected_value` varchar(255) DEFAULT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `comment` varchar(255) DEFAULT NULL,
  `scope` varchar(50) DEFAULT NULL,
  `subkeytext` varchar(255) DEFAULT NULL,
  `access_url` int(10) unsigned NOT NULL DEFAULT '1',
  `access_url_changeable` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `access_url` (`access_url`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=239 ;

--
-- Dumping data for table `settings_current`
--

INSERT INTO `settings_current` VALUES
(1, 'Institution', NULL, 'textfield', 'Platform', NULL, 'Organisation', 'InstitutionTitle', 'InstitutionComment', NULL, NULL, 1, 1),
(2, 'InstitutionUrl', NULL, 'textfield', 'Platform', NULL, '[[softurl]]', 'InstitutionUrlTitle', 'InstitutionUrlComment', NULL, NULL, 1, 1),
(3, 'siteName', NULL, 'textfield', 'Platform', NULL, '[[site_name]]', 'SiteNameTitle', 'SiteNameComment', NULL, NULL, 1, 1),
(4, 'emailAdministrator', NULL, 'textfield', 'Platform', NULL, '[[admin_email]]', 'emailAdministratorTitle', 'emailAdministratorComment', NULL, NULL, 1, 1),
(5, 'administratorSurname', NULL, 'textfield', 'Platform', NULL, '[[admin_lname]]', 'administratorSurnameTitle', 'administratorSurnameComment', NULL, NULL, 1, 1),
(6, 'administratorName', NULL, 'textfield', 'Platform', NULL, '[[admin_fname]]', 'administratorNameTitle', 'administratorNameComment', NULL, NULL, 1, 1),
(7, 'show_administrator_data', NULL, 'radio', 'Platform', NULL, 'true', 'ShowAdministratorDataTitle', 'ShowAdministratorDataComment', NULL, NULL, 1, 1),
(8, 'show_tutor_data', NULL, 'radio', 'Platform', NULL, 'true', 'ShowTutorDataTitle', 'ShowTutorDataComment', NULL, NULL, 1, 1),
(9, 'show_teacher_data', NULL, 'radio', 'Platform', NULL, 'true', 'ShowTeacherDataTitle', 'ShowTeacherDataComment', NULL, NULL, 1, 1),
(10, 'homepage_view', NULL, 'radio', 'Advanced', NULL, 'activity', 'HomepageViewTitle', 'HomepageViewComment', '0', NULL, 1, 1),
(11, 'show_toolshortcuts', NULL, 'radio', 'Advanced', NULL, 'false', 'ShowToolShortcutsTitle', 'ShowToolShortcutsComment', NULL, NULL, 1, 1),
(12, 'allow_group_categories', NULL, 'radio', 'Advanced', NULL, 'false', 'AllowGroupCategories', 'AllowGroupCategoriesComment', NULL, NULL, 1, 1),
(13, 'server_type', NULL, 'radio', 'Advanced', NULL, 'production', 'ServerStatusTitle', 'ServerStatusComment', NULL, NULL, 1, 1),
(14, 'platformLanguage', NULL, 'link', 'Languages', NULL, 'english', 'PlatformLanguageTitle', 'PlatformLanguageComment', NULL, NULL, 1, 1),
(15, 'showonline', 'world', 'checkbox', 'Advanced', NULL, 'true', 'ShowOnlineTitle', 'ShowOnlineComment', NULL, 'ShowOnlineWorld', 1, 1),
(16, 'showonline', 'users', 'checkbox', 'Advanced', NULL, 'true', 'ShowOnlineTitle', 'ShowOnlineComment', NULL, 'ShowOnlineUsers', 1, 1),
(17, 'showonline', 'course', 'checkbox', 'Advanced', NULL, 'true', 'ShowOnlineTitle', 'ShowOnlineComment', NULL, 'ShowOnlineCourse', 1, 1),
(18, 'profile', 'name', 'checkbox', 'User', NULL, 'false', 'ProfileChangesTitle', 'ProfileChangesComment', NULL, 'name', 1, 1),
(19, 'profile', 'officialcode', 'checkbox', 'User', NULL, 'false', 'ProfileChangesTitle', 'ProfileChangesComment', NULL, 'officialcode', 1, 1),
(20, 'profile', 'email', 'checkbox', 'User', NULL, 'false', 'ProfileChangesTitle', 'ProfileChangesComment', NULL, 'Email', 1, 1),
(21, 'profile', 'picture', 'checkbox', 'User', NULL, 'true', 'ProfileChangesTitle', 'ProfileChangesComment', NULL, 'UserPicture', 1, 1),
(22, 'profile', 'login', 'checkbox', 'User', NULL, 'false', 'ProfileChangesTitle', 'ProfileChangesComment', NULL, 'Login', 1, 1),
(23, 'profile', 'password', 'checkbox', 'User', NULL, 'false', 'ProfileChangesTitle', 'ProfileChangesComment', NULL, 'UserPassword', 1, 1),
(24, 'profile', 'language', 'checkbox', 'User', NULL, 'true', 'ProfileChangesTitle', 'ProfileChangesComment', NULL, 'Language', 1, 1),
(25, 'default_document_quotum', NULL, 'textfield', 'Course', NULL, '500000000', 'DefaultDocumentQuotumTitle', 'DefaultDocumentQuotumComment', NULL, NULL, 1, 1),
(26, 'registration', 'officialcode', 'checkbox', 'User', NULL, 'false', 'RegistrationRequiredFormsTitle', 'RegistrationRequiredFormsComment', NULL, 'OfficialCode', 1, 1),
(27, 'registration', 'email', 'checkbox', 'User', NULL, 'true', 'RegistrationRequiredFormsTitle', 'RegistrationRequiredFormsComment', NULL, 'Email', 1, 1),
(28, 'registration', 'language', 'checkbox', 'User', NULL, 'true', 'RegistrationRequiredFormsTitle', 'RegistrationRequiredFormsComment', NULL, 'Language', 1, 1),
(29, 'default_group_quotum', NULL, 'textfield', 'Course', NULL, '5000000', 'DefaultGroupQuotumTitle', 'DefaultGroupQuotumComment', NULL, NULL, 1, 1),
(30, 'allow_registration', NULL, 'radio', 'Platform', NULL, 'true', 'AllowRegistrationTitle', 'AllowRegistrationComment', NULL, NULL, 1, 1),
(31, 'allow_registration_as_teacher', NULL, 'radio', 'Platform', NULL, 'true', 'AllowRegistrationAsTeacherTitle', 'AllowRegistrationAsTeacherComment', NULL, NULL, 1, 1),
(32, 'allow_lostpassword', NULL, 'radio', 'Platform', NULL, 'true', 'AllowLostPasswordTitle', 'AllowLostPasswordComment', NULL, NULL, 1, 1),
(33, 'allow_user_headings', NULL, 'radio', 'Advanced', NULL, 'false', 'AllowUserHeadings', 'AllowUserHeadingsComment', NULL, NULL, 1, 1),
(34, 'course_create_active_tools', 'course_description', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'CourseDescription', 1, 1),
(35, 'course_create_active_tools', 'agenda', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'Agenda', 1, 1),
(36, 'course_create_active_tools', 'documents', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'Documents', 1, 1),
(37, 'course_create_active_tools', 'learning_path', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'LearningPath', 1, 1),
(38, 'course_create_active_tools', 'links', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'Links', 1, 1),
(39, 'course_create_active_tools', 'announcements', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'Announcements', 1, 1),
(40, 'course_create_active_tools', 'forums', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'Forums', 1, 1),
(41, 'course_create_active_tools', 'dropbox', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'Dropbox', 1, 1),
(42, 'course_create_active_tools', 'quiz', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'Quiz', 1, 1),
(43, 'course_create_active_tools', 'users', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'Users', 1, 1),
(44, 'course_create_active_tools', 'groups', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'Groups', 1, 1),
(45, 'course_create_active_tools', 'chat', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'Chat', 1, 1),
(46, 'course_create_active_tools', 'online_conference', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'OnlineConference', 1, 1),
(47, 'course_create_active_tools', 'student_publications', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'StudentPublications', 1, 1),
(48, 'allow_personal_agenda', NULL, 'radio', 'User', NULL, 'true', 'AllowPersonalAgendaTitle', 'AllowPersonalAgendaComment', NULL, NULL, 1, 1),
(49, 'display_coursecode_in_courselist', NULL, 'radio', 'Advanced', NULL, 'true', 'DisplayCourseCodeInCourselistTitle', 'DisplayCourseCodeInCourselistComment', NULL, NULL, 1, 1),
(50, 'display_teacher_in_courselist', NULL, 'radio', 'Advanced', NULL, 'true', 'DisplayTeacherInCourselistTitle', 'DisplayTeacherInCourselistComment', NULL, NULL, 1, 1),
(51, 'use_document_title', NULL, 'radio', 'Tools', NULL, 'true', 'UseDocumentTitleTitle', 'UseDocumentTitleComment', NULL, NULL, 1, 1),
(52, 'permanently_remove_deleted_files', NULL, 'radio', 'Tools', NULL, 'false', 'PermanentlyRemoveFilesTitle', 'PermanentlyRemoveFilesComment', NULL, NULL, 1, 1),
(53, 'dropbox_allow_overwrite', NULL, 'radio', 'Advanced', NULL, 'true', 'DropboxAllowOverwriteTitle', 'DropboxAllowOverwriteComment', NULL, NULL, 1, 1),
(54, 'dropbox_max_filesize', NULL, 'textfield', 'Advanced', NULL, '100000000', 'DropboxMaxFilesizeTitle', 'DropboxMaxFilesizeComment', NULL, NULL, 1, 1),
(55, 'dropbox_allow_just_upload', NULL, 'radio', 'Advanced', NULL, 'true', 'DropboxAllowJustUploadTitle', 'DropboxAllowJustUploadComment', NULL, NULL, 1, 1),
(56, 'dropbox_allow_student_to_student', NULL, 'radio', 'Advanced', NULL, 'true', 'DropboxAllowStudentToStudentTitle', 'DropboxAllowStudentToStudentComment', NULL, NULL, 1, 1),
(57, 'dropbox_allow_group', NULL, 'radio', 'Advanced', NULL, 'true', 'DropboxAllowGroupTitle', 'DropboxAllowGroupComment', NULL, NULL, 1, 1),
(58, 'dropbox_allow_mailing', NULL, 'radio', 'Advanced', NULL, 'false', 'DropboxAllowMailingTitle', 'DropboxAllowMailingComment', NULL, NULL, 1, 1),
(59, 'administratorTelephone', NULL, 'textfield', 'Advanced', NULL, '(000) 001 02 03', 'administratorTelephoneTitle', 'administratorTelephoneComment', NULL, NULL, 1, 1),
(60, 'extended_profile', NULL, 'radio', 'Advanced', NULL, 'true', 'ExtendedProfileTitle', 'ExtendedProfileComment', NULL, NULL, 1, 1),
(61, 'student_view_enabled', NULL, 'radio', 'Advanced', NULL, 'true', 'StudentViewEnabledTitle', 'StudentViewEnabledComment', NULL, NULL, 1, 1),
(62, 'show_navigation_menu', NULL, 'radio', 'Advanced', NULL, 'false', 'ShowNavigationMenuTitle', 'ShowNavigationMenuComment', NULL, NULL, 1, 1),
(63, 'enable_tool_introduction', NULL, 'radio', 'course', NULL, 'false', 'EnableToolIntroductionTitle', 'EnableToolIntroductionComment', NULL, NULL, 1, 1),
(64, 'page_after_login', NULL, 'radio', 'Advanced', NULL, 'user_portal.php', 'PageAfterLoginTitle', 'PageAfterLoginComment', NULL, NULL, 1, 1),
(65, 'time_limit_whosonline', NULL, 'textfield', 'Advanced', NULL, '30', 'TimeLimitWhosonlineTitle', 'TimeLimitWhosonlineComment', NULL, NULL, 1, 1),
(66, 'breadcrumbs_course_homepage', NULL, 'radio', 'Advanced', NULL, 'session_name_and_course_title', 'BreadCrumbsCourseHomepageTitle', 'BreadCrumbsCourseHomepageComment', NULL, NULL, 1, 1),
(67, 'example_material_course_creation', NULL, 'radio', 'Advanced', NULL, 'true', 'ExampleMaterialCourseCreationTitle', 'ExampleMaterialCourseCreationComment', NULL, NULL, 1, 1),
(68, 'account_valid_duration', NULL, 'textfield', 'Advanced', NULL, '3660', 'AccountValidDurationTitle', 'AccountValidDurationComment', NULL, NULL, 1, 1),
(69, 'use_session_mode', NULL, 'radio', 'Platform', NULL, 'true', 'UseSessionModeTitle', 'UseSessionModeComment', NULL, NULL, 1, 1),
(70, 'allow_email_editor', NULL, 'radio', 'Tools', NULL, 'false', 'AllowEmailEditorTitle', 'AllowEmailEditorComment', NULL, NULL, 1, 1),
(71, 'registered', NULL, 'textfield', NULL, NULL, 'false', '', NULL, NULL, NULL, 1, 1),
(72, 'donotlistcampus', NULL, 'textfield', NULL, NULL, 'false', '', NULL, NULL, NULL, 1, 1),
(73, 'show_email_addresses', NULL, 'radio', 'Advanced', NULL, 'false', 'ShowEmailAddresses', 'ShowEmailAddressesComment', NULL, NULL, 1, 1),
(74, 'profile', 'phone', 'checkbox', 'User', NULL, 'false', 'ProfileChangesTitle', 'ProfileChangesComment', NULL, 'phone', 1, 1),
(75, 'service_visio', 'active', 'radio', NULL, NULL, 'false', 'VisioEnable', NULL, NULL, NULL, 1, 1),
(76, 'service_visio', 'visio_host', 'textfield', NULL, NULL, NULL, 'VisioHost', NULL, NULL, NULL, 1, 1),
(77, 'service_visio', 'visio_port', 'textfield', NULL, NULL, '1935', 'VisioPort', NULL, NULL, NULL, 1, 1),
(78, 'service_visio', 'visio_pass', 'textfield', NULL, NULL, NULL, 'VisioPassword', NULL, NULL, NULL, 1, 1),
(79, 'service_ppt2lp', 'active', 'radio', NULL, NULL, 'false', 'ppt2lp_actived', NULL, NULL, NULL, 1, 1),
(80, 'service_ppt2lp', 'host', 'textfield', NULL, NULL, NULL, 'Host', NULL, NULL, NULL, 1, 1),
(81, 'service_ppt2lp', 'port', 'textfield', NULL, NULL, '2002', 'Port', NULL, NULL, NULL, 1, 1),
(82, 'service_ppt2lp', 'user', 'textfield', NULL, NULL, NULL, 'UserOnHost', NULL, NULL, NULL, 1, 1),
(83, 'service_ppt2lp', 'ftp_password', 'textfield', NULL, NULL, NULL, 'FtpPassword', NULL, NULL, NULL, 1, 1),
(84, 'service_ppt2lp', 'path_to_lzx', 'textfield', NULL, NULL, NULL, '', NULL, NULL, NULL, 1, 1),
(85, 'service_ppt2lp', 'size', 'radio', NULL, NULL, '720x540', '', NULL, NULL, NULL, 1, 1),
(86, 'wcag_anysurfer_public_pages', NULL, 'radio', 'Editor', NULL, 'false', 'PublicPagesComplyToWAITitle', 'PublicPagesComplyToWAIComment', NULL, NULL, 1, 1),
(87, 'stylesheets', NULL, 'textfield', 'stylesheets', NULL, 'dokeos2_tablet', '', NULL, NULL, NULL, 1, 1),
(88, 'upload_extensions_list_type', NULL, 'radio', 'Security', NULL, 'blacklist', 'UploadExtensionsListType', 'UploadExtensionsListTypeComment', NULL, NULL, 1, 1),
(89, 'upload_extensions_blacklist', NULL, 'textfield', 'Security', NULL, NULL, 'UploadExtensionsBlacklist', 'UploadExtensionsBlacklistComment', NULL, NULL, 1, 1),
(90, 'upload_extensions_whitelist', NULL, 'textfield', 'Security', NULL, 'htm;html;jpg;jpeg;gif;png;swf;avi;mpg;mpeg;mov;flv;doc;docx;xls;xlsx;ppt;pptx;odt;odp;ods;pdf', 'UploadExtensionsWhitelist', 'UploadExtensionsWhitelistComment', NULL, NULL, 1, 1),
(91, 'upload_extensions_skip', NULL, 'radio', 'Security', NULL, 'true', 'UploadExtensionsSkip', 'UploadExtensionsSkipComment', NULL, NULL, 1, 1),
(92, 'upload_extensions_replace_by', NULL, 'textfield', 'Security', NULL, 'dangerous', 'UploadExtensionsReplaceBy', 'UploadExtensionsReplaceByComment', NULL, NULL, 1, 1),
(93, 'show_number_of_courses', NULL, 'radio', 'Advanced', NULL, 'false', 'ShowNumberOfCourses', 'ShowNumberOfCoursesComment', NULL, NULL, 1, 1),
(94, 'show_empty_course_categories', NULL, 'radio', 'Advanced', NULL, 'true', 'ShowEmptyCourseCategories', 'ShowEmptyCourseCategoriesComment', NULL, NULL, 1, 1),
(95, 'show_back_link_on_top_of_tree', NULL, 'radio', 'Advanced', NULL, 'false', 'ShowBackLinkOnTopOfCourseTree', 'ShowBackLinkOnTopOfCourseTreeComment', NULL, NULL, 1, 1),
(96, 'show_different_course_language', NULL, 'radio', 'Advanced', NULL, 'true', 'ShowDifferentCourseLanguage', 'ShowDifferentCourseLanguageComment', NULL, NULL, 1, 1),
(97, 'split_users_upload_directory', NULL, 'radio', 'Advanced', NULL, 'false', 'SplitUsersUploadDirectory', 'SplitUsersUploadDirectoryComment', NULL, NULL, 1, 1),
(98, 'hide_dltt_markup', NULL, 'radio', 'Advanced', NULL, 'true', 'HideDLTTMarkup', 'HideDLTTMarkupComment', NULL, NULL, 1, 1),
(99, 'display_categories_on_homepage', NULL, 'radio', 'Advanced', NULL, 'false', 'DisplayCategoriesOnHomepageTitle', 'DisplayCategoriesOnHomepageComment', NULL, NULL, 1, 1),
(100, 'permissions_for_new_directories', NULL, 'textfield', 'Security', NULL, '[[dir_mode]]', 'PermissionsForNewDirs', 'PermissionsForNewDirsComment', NULL, NULL, 1, 1),
(101, 'permissions_for_new_files', NULL, 'textfield', 'Security', NULL, '[[file_mode]]', 'PermissionsForNewFiles', 'PermissionsForNewFilesComment', NULL, NULL, 1, 1),
(102, 'show_tabs', 'campus_homepage', 'checkbox', 'Platform', NULL, 'true', 'ShowTabsTitle', 'ShowTabsComment', NULL, 'TabsCampusHomepage', 1, 1),
(103, 'show_tabs', 'my_courses', 'checkbox', 'Platform', NULL, 'true', 'ShowTabsTitle', 'ShowTabsComment', NULL, 'TabsMyCourses', 1, 1),
(104, 'show_tabs', 'reporting', 'checkbox', 'Platform', NULL, 'true', 'ShowTabsTitle', 'ShowTabsComment', NULL, 'TabsReporting', 1, 1),
(105, 'show_tabs', 'platform_administration', 'checkbox', 'Platform', NULL, 'true', 'ShowTabsTitle', 'ShowTabsComment', NULL, 'TabsPlatformAdministration', 1, 1),
(106, 'show_tabs', 'my_agenda', 'checkbox', 'Platform', NULL, 'true', 'ShowTabsTitle', 'ShowTabsComment', NULL, 'TabsMyAgenda', 1, 1),
(107, 'show_tabs', 'my_profile', 'checkbox', 'Platform', NULL, 'false', 'ShowTabsTitle', 'ShowTabsComment', NULL, 'TabsMyProfile', 1, 1),
(108, 'default_forum_view', NULL, 'radio', 'Course', NULL, 'flat', 'DefaultForumViewTitle', 'DefaultForumViewComment', NULL, NULL, 1, 1),
(109, 'platform_charset', NULL, 'textfield', 'Advanced', NULL, 'iso-8859-15', 'PlatformCharsetTitle', 'PlatformCharsetComment', 'platform', NULL, 1, 1),
(110, 'noreply_email_address', NULL, 'textfield', 'Advanced', NULL, NULL, 'NoReplyEmailAddress', 'NoReplyEmailAddressComment', NULL, NULL, 1, 1),
(111, 'survey_email_sender_noreply', NULL, 'radio', 'Course', NULL, 'coach', 'SurveyEmailSenderNoReply', 'SurveyEmailSenderNoReplyComment', NULL, NULL, 1, 1),
(112, 'openid_authentication', NULL, 'radio', 'Security', NULL, 'false', 'OpenIdAuthentication', 'OpenIdAuthenticationComment', NULL, NULL, 1, 1),
(113, 'profile', 'openid', 'checkbox', 'User', NULL, 'false', 'ProfileChangesTitle', 'ProfileChangesComment', NULL, 'OpenIDURL', 1, 1),
(114, 'gradebook_enable', NULL, 'radio', 'Advanced', NULL, 'true', 'GradebookActivation', 'GradebookActivationComment', NULL, NULL, 1, 1),
(115, 'show_tabs', 'my_gradebook', 'checkbox', 'Platform', NULL, 'true', 'ShowTabsTitle', 'ShowTabsComment', NULL, 'TabsMyGradebook', 1, 1),
(116, 'gradebook_score_display_coloring', 'my_display_coloring', 'checkbox', 'Advanced', NULL, 'false', 'GradebookScoreDisplayColoring', 'GradebookScoreDisplayColoringComment', NULL, 'TabsGradebookEnableColoring', 1, 1),
(117, 'gradebook_score_display_custom', 'my_display_custom', 'checkbox', 'Advanced', NULL, 'false', 'GradebookScoreDisplayCustom', 'GradebookScoreDisplayCustomComment', NULL, 'TabsGradebookEnableCustom', 1, 1),
(118, 'gradebook_score_display_colorsplit', NULL, 'textfield', 'Advanced', NULL, '50', 'GradebookScoreDisplayColorSplit', 'GradebookScoreDisplayColorSplitComment', NULL, NULL, 1, 1),
(119, 'gradebook_score_display_upperlimit', 'my_display_upperlimit', 'checkbox', 'Advanced', NULL, 'false', 'GradebookScoreDisplayUpperLimit', 'GradebookScoreDisplayUpperLimitComment', NULL, 'TabsGradebookEnableUpperLimit', 1, 1),
(120, 'user_selected_theme', NULL, 'radio', 'Advanced', NULL, 'false', 'UserThemeSelection', 'UserThemeSelectionComment', NULL, NULL, 1, 1),
(121, 'profile', 'theme', 'checkbox', 'User', NULL, 'false', 'ProfileChangesTitle', 'ProfileChangesComment', NULL, 'UserTheme', 1, 1),
(122, 'allow_course_theme', NULL, 'radio', 'Advanced', NULL, 'true', 'AllowCourseThemeTitle', 'AllowCourseThemeComment', NULL, NULL, 1, 1),
(123, 'display_mini_month_calendar', NULL, 'radio', 'Advanced', NULL, 'true', 'DisplayMiniMonthCalendarTitle', 'DisplayMiniMonthCalendarComment', NULL, NULL, 1, 1),
(124, 'display_upcoming_events', NULL, 'radio', 'Advanced', NULL, 'true', 'DisplayUpcomingEventsTitle', 'DisplayUpcomingEventsComment', NULL, NULL, 1, 1),
(125, 'number_of_upcoming_events', NULL, 'textfield', 'Advanced', NULL, '1', 'NumberOfUpcomingEventsTitle', 'NumberOfUpcomingEventsComment', NULL, NULL, 1, 1),
(126, 'show_closed_courses', NULL, 'radio', 'Advanced', NULL, 'false', 'ShowClosedCoursesTitle', 'ShowClosedCoursesComment', NULL, NULL, 1, 1),
(127, 'ldap_main_server_address', NULL, 'textfield', 'LDAP', NULL, 'localhost', 'LDAPMainServerAddressTitle', 'LDAPMainServerAddressComment', NULL, NULL, 1, 1),
(128, 'ldap_main_server_port', NULL, 'textfield', 'LDAP', NULL, '389', 'LDAPMainServerPortTitle', 'LDAPMainServerPortComment', NULL, NULL, 1, 1),
(129, 'ldap_domain', NULL, 'textfield', 'LDAP', NULL, 'dc=nodomain', 'LDAPDomainTitle', 'LDAPDomainComment', NULL, NULL, 1, 1),
(130, 'ldap_replicate_server_address', NULL, 'textfield', 'LDAP', NULL, 'localhost', 'LDAPReplicateServerAddressTitle', 'LDAPReplicateServerAddressComment', NULL, NULL, 1, 1),
(131, 'ldap_replicate_server_port', NULL, 'textfield', 'LDAP', NULL, '389', 'LDAPReplicateServerPortTitle', 'LDAPReplicateServerPortComment', NULL, NULL, 1, 1),
(132, 'ldap_search_term', NULL, 'textfield', 'LDAP', NULL, NULL, 'LDAPSearchTermTitle', 'LDAPSearchTermComment', NULL, NULL, 1, 1),
(133, 'ldap_version', NULL, 'radio', 'LDAP', NULL, '3', 'LDAPVersionTitle', 'LDAPVersionComment', NULL, NULL, 1, 1),
(134, 'ldap_filled_tutor_field', NULL, 'textfield', 'LDAP', NULL, 'employeenumber', 'LDAPFilledTutorFieldTitle', 'LDAPFilledTutorFieldComment', NULL, NULL, 1, 1),
(135, 'ldap_authentication_login', NULL, 'textfield', 'LDAP', NULL, NULL, 'LDAPAuthenticationLoginTitle', 'LDAPAuthenticationLoginComment', NULL, NULL, 1, 1),
(136, 'ldap_authentication_password', NULL, 'textfield', 'LDAP', NULL, NULL, 'LDAPAuthenticationPasswordTitle', 'LDAPAuthenticationPasswordComment', NULL, NULL, 1, 1),
(137, 'service_visio', 'visio_use_rtmpt', 'radio', NULL, NULL, 'false', 'VisioUseRtmptTitle', 'VisioUseRtmptComment', NULL, NULL, 1, 1),
(138, 'extendedprofile_registration', 'mycomptetences', 'checkbox', 'Advanced', NULL, 'false', 'ExtendedProfileRegistrationTitle', 'ExtendedProfileRegistrationComment', NULL, 'MyCompetences', 1, 1),
(139, 'extendedprofile_registration', 'mydiplomas', 'checkbox', 'Advanced', NULL, 'false', 'ExtendedProfileRegistrationTitle', 'ExtendedProfileRegistrationComment', NULL, 'MyDiplomas', 1, 1),
(140, 'extendedprofile_registration', 'myteach', 'checkbox', 'Advanced', NULL, 'false', 'ExtendedProfileRegistrationTitle', 'ExtendedProfileRegistrationComment', NULL, 'MyTeach', 1, 1),
(141, 'extendedprofile_registration', 'mypersonalopenarea', 'checkbox', 'Advanced', NULL, 'false', 'ExtendedProfileRegistrationTitle', 'ExtendedProfileRegistrationComment', NULL, 'MyPersonalOpenArea', 1, 1),
(142, 'extendedprofile_registrationrequired', 'mycomptetences', 'checkbox', 'Advanced', NULL, 'false', 'ExtendedProfileRegistrationRequiredTitle', 'ExtendedProfileRegistrationRequiredComment', NULL, 'MyCompetences', 1, 1),
(143, 'extendedprofile_registrationrequired', 'mydiplomas', 'checkbox', 'Advanced', NULL, 'false', 'ExtendedProfileRegistrationRequiredTitle', 'ExtendedProfileRegistrationRequiredComment', NULL, 'MyDiplomas', 1, 1),
(144, 'extendedprofile_registrationrequired', 'myteach', 'checkbox', 'Advanced', NULL, 'false', 'ExtendedProfileRegistrationRequiredTitle', 'ExtendedProfileRegistrationRequiredComment', NULL, 'MyTeach', 1, 1),
(145, 'extendedprofile_registrationrequired', 'mypersonalopenarea', 'checkbox', 'Advanced', NULL, 'false', 'ExtendedProfileRegistrationRequiredTitle', 'ExtendedProfileRegistrationRequiredComment', NULL, 'MyPersonalOpenArea', 1, 1),
(146, 'ldap_filled_tutor_field_value', NULL, 'textfield', 'LDAP', NULL, NULL, 'LDAPFilledTutorFieldValueTitle', 'LDAPFilledTutorFieldValueComment', NULL, NULL, 1, 1),
(147, 'registration', 'phone', 'textfield', 'User', NULL, 'false', 'RegistrationRequiredFormsTitle', 'RegistrationRequiredFormsComment', NULL, 'Phone', 1, 1),
(148, 'add_users_by_coach', NULL, 'radio', 'Security', NULL, 'false', 'AddUsersByCoachTitle', 'AddUsersByCoachComment', NULL, NULL, 1, 1),
(149, 'extend_rights_for_coach', NULL, 'radio', 'Security', NULL, 'false', 'ExtendRightsForCoachTitle', 'ExtendRightsForCoachComment', NULL, NULL, 1, 1),
(150, 'extend_rights_for_coach_on_survey', NULL, 'radio', 'Security', NULL, 'true', 'ExtendRightsForCoachOnSurveyTitle', 'ExtendRightsForCoachOnSurveyComment', NULL, NULL, 1, 1),
(151, 'course_create_active_tools', 'wiki', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'Wiki', 1, 1),
(152, 'show_session_coach', NULL, 'radio', 'Platform', NULL, 'false', 'ShowSessionCoachTitle', 'ShowSessionCoachComment', NULL, NULL, 1, 1),
(153, 'course_create_active_tools', 'Advanced', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'Gradebook', 1, 1),
(154, 'allow_users_to_create_courses', NULL, 'radio', 'Platform', NULL, 'true', 'AllowUsersToCreateCoursesTitle', 'AllowUsersToCreateCoursesComment', NULL, NULL, 1, 1),
(155, 'course_create_active_tools', 'survey', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'Survey', 1, 1),
(156, 'course_create_active_tools', 'glossary', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'Glossary', 1, 1),
(157, 'course_create_active_tools', 'notebook', 'checkbox', 'Tools', NULL, 'true', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'Notebook', 1, 1),
(158, 'advanced_filemanager', NULL, 'radio', 'Advanced', NULL, 'false', 'AdvancedFileManagerTitle', 'AdvancedFileManagerComment', NULL, NULL, 1, 1),
(159, 'allow_reservation', NULL, 'radio', 'Advanced', NULL, 'false', 'AllowReservationTitle', 'AllowReservationComment', NULL, NULL, 1, 1),
(160, 'profile', 'apikeys', 'checkbox', 'User', NULL, 'false', 'ProfileChangesTitle', 'ProfileChangesComment', NULL, 'ApiKeys', 1, 1),
(161, 'allow_message_tool', NULL, 'radio', 'Advanced', NULL, 'true', 'AllowMessageToolTitle', 'AllowMessageToolComment', NULL, NULL, 1, 1),
(162, 'allow_social_tool', NULL, 'radio', 'Tools', NULL, 'true', 'AllowSocialToolTitle', 'AllowSocialToolComment', NULL, NULL, 1, 1),
(163, 'allow_students_to_browse_courses', NULL, 'radio', 'Platform', NULL, 'true', 'AllowStudentsToBrowseCoursesTitle', 'AllowStudentsToBrowseCoursesComment', NULL, NULL, 1, 1),
(164, 'show_session_data', NULL, 'radio', 'Advanced', NULL, 'false', 'ShowSessionDataTitle', 'ShowSessionDataComment', NULL, NULL, 1, 1),
(165, 'allow_use_sub_language', NULL, 'radio', 'Advanced', NULL, 'false', 'AllowUseSubLanguageTitle', 'AllowUseSubLanguageComment', NULL, NULL, 1, 1),
(166, 'show_glossary_in_documents', NULL, 'radio', 'Advanced', NULL, 'isautomatic', 'ShowGlossaryInDocumentsTitle', 'ShowGlossaryInDocumentsComment', NULL, NULL, 1, 1),
(167, 'allow_terms_conditions', NULL, 'radio', 'Platform', NULL, 'false', 'AllowTermsAndConditionsTitle', 'AllowTermsAndConditionsComment', NULL, NULL, 1, 1),
(168, 'course_create_active_tools', 'enable_search', 'checkbox', 'Tools', NULL, 'false', 'CourseCreateActiveToolsTitle', 'CourseCreateActiveToolsComment', NULL, 'Search', 1, 1),
(169, 'search_enabled', NULL, 'radio', 'Tools', NULL, 'false', 'EnableSearchTitle', 'EnableSearchComment', NULL, NULL, 1, 1),
(170, 'search_prefilter_prefix', NULL, NULL, 'Search', NULL, NULL, 'SearchPrefilterPrefix', 'SearchPrefilterPrefixComment', NULL, NULL, 1, 1),
(171, 'search_show_unlinked_results', NULL, 'radio', 'Search', NULL, 'true', 'SearchShowUnlinkedResultsTitle', 'SearchShowUnlinkedResultsComment', NULL, NULL, 1, 1),
(172, 'show_courses_descriptions_in_catalog', NULL, 'radio', 'Course', NULL, 'true', 'ShowCoursesDescriptionsInCatalogTitle', 'ShowCoursesDescriptionsInCatalogComment', NULL, NULL, 1, 1),
(173, 'allow_coach_to_edit_course_session', NULL, 'radio', 'Course', NULL, 'false', 'AllowCoachsToEditInsideTrainingSessions', 'AllowCoachsToEditInsideTrainingSessionsComment', NULL, NULL, 1, 1),
(174, 'show_glossary_in_extra_tools', NULL, 'radio', 'Advanced', NULL, 'false', 'ShowGlossaryInExtraToolsTitle', 'ShowGlossaryInExtraToolsComment', NULL, NULL, 1, 1),
(175, 'dokeos_database_version', NULL, 'textfield', NULL, NULL, '2.1.12641', 'DokeosDatabaseVersion', NULL, NULL, NULL, 1, 1),
(176, 'send_email_to_admin_when_create_course', NULL, 'radio', 'Platform', NULL, 'false', 'SendEmailToAdminTitle', 'SendEmailToAdminComment', NULL, NULL, 1, 1),
(177, 'go_to_course_after_login', NULL, 'radio', 'Course', NULL, 'false', 'GoToCourseAfterLoginTitle', 'GoToCourseAfterLoginComment', NULL, NULL, 1, 1),
(178, 'math_mimetex', NULL, 'radio', 'Advanced', NULL, 'false', 'MathMimetexTitle', 'MathMimetexComment', NULL, NULL, 1, 1),
(179, 'math_asciimathML', NULL, 'radio', 'Editor', NULL, 'false', 'MathASCIImathMLTitle', 'MathASCIImathMLComment', NULL, NULL, 1, 1),
(180, 'youtube_for_students', NULL, 'radio', 'Advanced', NULL, 'true', 'YoutubeForStudentsTitle', 'YoutubeForStudentsComment', NULL, NULL, 1, 1),
(181, 'block_copy_paste_for_students', NULL, 'radio', 'Editor', NULL, 'false', 'BlockCopyPasteForStudentsTitle', 'BlockCopyPasteForStudentsComment', NULL, NULL, 1, 1),
(182, 'more_buttons_maximized_mode', NULL, 'radio', 'Editor', NULL, 'false', 'MoreButtonsForMaximizedModeTitle', 'MoreButtonsForMaximizedModeComment', NULL, NULL, 1, 1),
(183, 'students_download_folders', NULL, 'radio', 'Advanced', NULL, 'true', 'AllowStudentsDownloadFoldersTitle', 'AllowStudentsDownloadFoldersComment', NULL, NULL, 1, 1),
(184, 'installation_date', NULL, 'text', 'Advanced', NULL, '1319211472', 'InstallationDateTitle', 'InstallationDateComment', NULL, NULL, 1, 1),
(185, 'cas_activate', NULL, 'radio', 'CAS', NULL, 'false', 'CasMainActivateTitle', 'CasMainActivateComment', NULL, NULL, 1, 1),
(186, 'cas_server', NULL, 'textfield', 'CAS', NULL, NULL, 'CasMainServerTitle', 'CasMainServerComment', NULL, NULL, 1, 1),
(187, 'cas_server_uri', NULL, 'textfield', 'CAS', NULL, NULL, 'CasMainServerURITitle', 'CasMainServerURIComment', NULL, NULL, 1, 1),
(188, 'cas_port', NULL, 'textfield', 'CAS', NULL, NULL, 'CasMainPortTitle', 'CasMainPortComment', NULL, NULL, 1, 1),
(189, 'cas_protocol', NULL, 'radio', 'CAS', NULL, NULL, 'CasMainProtocolTitle', 'CasMainProtocolComment', NULL, NULL, 1, 1),
(190, 'cas_add_user_activate', NULL, 'radio', 'CAS', NULL, NULL, 'CasUserAddActivateTitle', 'CasUserAddActivateComment', NULL, NULL, 1, 1),
(191, 'cas_add_user_login_attr', NULL, 'textfield', 'CAS', NULL, NULL, 'CasUserAddLoginAttributeTitle', 'CasUserAddLoginAttributeComment', NULL, NULL, 1, 1),
(192, 'cas_add_user_email_attr', NULL, 'textfield', 'CAS', NULL, NULL, 'CasUserAddEmailAttributeTitle', 'CasUserAddEmailAttributeComment', NULL, NULL, 1, 1),
(193, 'cas_add_user_firstname_attr', NULL, 'textfield', 'CAS', NULL, NULL, 'CasUserAddFirstnameAttributeTitle', 'CasUserAddFirstnameAttributeComment', NULL, NULL, 1, 1),
(194, 'cas_add_user_lastname_attr', NULL, 'textfield', 'CAS', NULL, NULL, 'CasUserAddLastnameAttributeTitle', 'CasUserAddLastnameAttributeComment', NULL, NULL, 1, 1),
(195, 'calendar_types', 'platformevents', 'checkbox', 'Advanced', NULL, 'true', 'CalendarTypesTitle', 'CalendarTypesComment', '1', 'PlatformEvents', 1, 1),
(196, 'calendar_types', 'quizevents', 'checkbox', 'Advanced', NULL, 'true', 'CalendarTypesTitle', 'CalendarTypesComment', '1', 'QuizEvents', 1, 1),
(197, 'calendar_types', 'sessionevents', 'checkbox', 'Advanced', NULL, 'true', 'CalendarTypesTitle', 'CalendarTypesComment', '1', 'SessionEvents', 1, 1),
(198, 'mindmap_converter_activated', NULL, 'radio', 'Advanced', NULL, 'false', 'MindmapConverterTitle', 'MindmapConverterComment', NULL, NULL, 1, 1),
(199, 'agenda_default_view', NULL, 'radio', 'Tools', NULL, 'agendaWeek', 'AgendaDefaultViewTitle', 'AgendaDefaultViewComment', '1', NULL, 1, 1),
(200, 'agenda_action_icons', NULL, 'radio', 'Tools', NULL, 'false', 'AgendaActionIconsTitle', 'AgendaActionIconsComment', '1', NULL, 1, 1),
(201, 'calendar_detail_view', NULL, 'radio', 'Advanced', NULL, 'edit', 'CalendarDetailViewTitle', 'CalendarDetailViewComment', '1', NULL, 1, 1),
(202, 'calendar_navigation', NULL, 'radio', 'Advanced', NULL, 'actions', 'CalendarNavigationTitle', 'CalendarNavigationComment', '1', NULL, 1, 1),
(203, 'display_feedback_messages', NULL, 'radio', 'Advanced', NULL, 'false', 'DisplayFeedbackMessagesTitle', 'DisplayFeedbackMessagesComment', '1', NULL, 1, 1),
(204, 'allow_user_edit_agenda', NULL, 'radio', 'Advanced', NULL, 'false', 'AllowUserEditAgendaTitle', 'AllowUserEditAgendaTitle', '1', NULL, 1, 1),
(205, 'user_manage_group_agenda', NULL, 'radio', 'Advanced', NULL, 'true', 'CanUsersMangeGroupAgendaTitle', 'CanUsersMangeGroupAgendaComment', '1', NULL, 1, 1),
(206, 'captcha', NULL, 'radio', 'Advanced', NULL, 'false', 'CaptchaTitle', 'CaptchaComment', NULL, NULL, 1, 1),
(207, 'number_of_announcements', NULL, 'textfield', 'Advanced', NULL, '8', 'NumberOfAnnouncementsInListTitle', 'NumberOfAnnouncementsInListComment', '0', NULL, 1, 1),
(208, 'calendar_export_all', NULL, 'radio', 'Advanced', NULL, 'false', 'CalendarExportAllTitle', 'CalendarExportAllComment', '0', NULL, 1, 1),
(209, 'display_context_help', NULL, 'radio', 'Advanced', NULL, 'false', 'DisplayContextHelpTitle', 'DisplayContextHelpComment', '0', NULL, 1, 1),
(210, 'display_breadcrumbs', NULL, 'radio', 'Advanced', NULL, 'false', 'DisplayBreadcrumbsTitle', 'DisplayBreadcrumbsComment', '0', NULL, 1, 1),
(211, 'display_platform_header_in_course', NULL, 'radio', 'Advanced', NULL, 'hide', 'DisplayPlatformHeaderInCourseTitle', 'DisplayPlatformHeaderInCourseComment', '0', NULL, 1, 1),
(212, 'groupscenariofield', 'description', 'checkbox', 'Advanced', NULL, 'false', 'GroupScenarioFieldTitle', 'GroupScenarioFieldComment', '0', 'GroupScenarioFieldDescription', 1, 1),
(213, 'groupscenariofield', 'limit', 'checkbox', 'Advanced', NULL, 'true', 'GroupScenarioFieldTitle', 'GroupScenarioFieldComment', '0', 'GroupScenarioFieldLimit', 1, 1),
(214, 'groupscenariofield', 'registration', 'checkbox', 'Advanced', NULL, 'true', 'GroupScenarioFieldTitle', 'GroupScenarioFieldComment', '0', 'GroupScenarioFieldRegistration', 1, 1),
(215, 'groupscenariofield', 'unregistration', 'checkbox', 'Advanced', NULL, 'false', 'GroupScenarioFieldTitle', 'GroupScenarioFieldComment', '0', 'GroupScenarioFieldUnRegistration', 1, 1),
(216, 'groupscenariofield', 'publicprivategroup', 'checkbox', 'Advanced', NULL, 'true', 'GroupScenarioFieldTitle', 'GroupScenarioFieldComment', '0', 'GroupScenarioFieldPublicPrivateGroup', 1, 1),
(217, 'groupscenariofield', 'document', 'checkbox', 'Advanced', NULL, 'false', 'GroupScenarioFieldTitle', 'GroupScenarioFieldComment', '0', 'GroupScenarioFieldDocument', 1, 1),
(218, 'groupscenariofield', 'work', 'checkbox', 'Advanced', NULL, 'false', 'GroupScenarioFieldTitle', 'GroupScenarioFieldComment', '0', 'GroupScenarioFieldWork', 1, 1),
(219, 'groupscenariofield', 'calendar', 'checkbox', 'Advanced', NULL, 'false', 'GroupScenarioFieldTitle', 'GroupScenarioFieldComment', '0', 'GroupScenarioFieldCalendar', 1, 1),
(220, 'groupscenariofield', 'announcements', 'checkbox', 'Advanced', NULL, 'false', 'GroupScenarioFieldTitle', 'GroupScenarioFieldComment', '0', 'GroupScenarioFieldAnnouncements', 1, 1),
(221, 'groupscenariofield', 'forum', 'checkbox', 'Advanced', NULL, 'false', 'GroupScenarioFieldTitle', 'GroupScenarioFieldComment', '0', 'GroupScenarioFieldForum', 1, 1),
(222, 'groupscenariofield', 'wiki', 'checkbox', 'Advanced', NULL, 'false', 'GroupScenarioFieldTitle', 'GroupScenarioFieldComment', '0', 'GroupScenarioFieldWiki', 1, 1),
(223, 'message_max_upload_filesize', NULL, 'textfield', 'Advanced', NULL, '20971520', 'MessageMaxUploadFilesizeTitle', 'MessageMaxUploadFilesizeComment', NULL, NULL, 1, 1),
(224, 'show_tabs', 'social', 'checkbox', 'Platform', NULL, 'true', 'ShowTabsTitle', 'ShowTabsComment', NULL, 'TabsSocial', 1, 1),
(225, 'show_quizcategory', NULL, 'radio', 'Advanced', NULL, 'false', 'ShowQuizCategoryTitle', 'ShowQuizCategoryComment', '0', NULL, 1, 1),
(226, 'show_emailtemplates', NULL, 'radio', 'Advanced', NULL, 'true', 'ShowEmailTemplatesTitle', 'ShowEmailTemplatesComment', '0', NULL, 1, 1),
(227, 'show_catalogue', NULL, 'radio', 'Platform', NULL, 'true', 'ShowCatalogueTitle', 'ShowCatalogueComment', '0', NULL, 1, 1),
(228, 'automatic_group_filling', NULL, 'radio', 'Advanced', NULL, 'true', 'ShowAutomaticGroupTitle', 'ShowAutomaticGroupComment', '0', NULL, 1, 1),
(229, 'create_new_group', NULL, 'radio', 'Advanced', NULL, 'true', 'ShowNewGroupTitle', 'ShowNewGroupComment', '0', NULL, 1, 1),
(230, 'new_group_seats', NULL, 'textfield', 'Advanced', NULL, '20', 'ShowNewGroupSeatTitle', 'ShowNewGroupSeatComment', '0', NULL, 1, 1),
(231, 'show_force_password_change', NULL, 'radio', 'Security', NULL, '0', 'ShowForcePasswordChangeTitle', 'ShowForcePasswordChangeTitleComment', NULL, NULL, 1, 1),
(232, 'force_password_change', NULL, 'textfield', 'Security', NULL, '0', 'ForcePasswordChangeTitle', 'ForcePasswordChangeComment', NULL, NULL, 1, 1),
(233, 'force_password_change_account_creation', NULL, 'radio', 'Security', NULL, '0', 'ForcePasswordChangeAccountCreationTitle', 'ForcePasswordChangeAccountCreationComment', NULL, NULL, 1, 1),
(234, 'password_rule', 'numbers', 'checkbox', 'Security', NULL, 'true', 'PasswordRuleTitle', 'PasswordRuleComment', NULL, 'PasswordRuleNumbers', 1, 1),
(235, 'password_rule', 'camelcase', 'checkbox', 'Security', NULL, 'true', 'PasswordRuleTitle', 'PasswordRuleComment', NULL, 'PasswordRuleCamelCase', 1, 1),
(236, 'password_rule', 'symbols', 'checkbox', 'Security', NULL, 'false', 'PasswordRuleTitle', 'PasswordRuleComment', NULL, 'PasswordRuleSymbol', 1, 1),
(237, 'password_length', NULL, 'textfield', 'Security', NULL, '6', 'PasswordLengthTitle', 'PasswordLengthComment', NULL, NULL, 1, 1),
(238, 'login_fail_lock', NULL, 'textfield', 'Security', NULL, '0', 'LoginFailLockTitle', 'LoginFailLockComment', NULL, NULL, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `settings_options`
--

CREATE TABLE `settings_options` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variable` varchar(255) DEFAULT NULL,
  `value` varchar(255) DEFAULT NULL,
  `display_text` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=222 ;

--
-- Dumping data for table `settings_options`
--

INSERT INTO `settings_options` VALUES
(1, 'show_administrator_data', 'true', 'Yes'),
(2, 'show_administrator_data', 'false', 'No'),
(3, 'show_tutor_data', 'true', 'Yes'),
(4, 'show_tutor_data', 'false', 'No'),
(5, 'show_teacher_data', 'true', 'Yes'),
(6, 'show_teacher_data', 'false', 'No'),
(7, 'homepage_view', 'activity', 'HomepageViewActivity'),
(8, 'homepage_view', '2column', 'HomepageView2column'),
(9, 'homepage_view', '3column', 'HomepageView3column'),
(10, 'show_toolshortcuts', 'true', 'Yes'),
(11, 'show_toolshortcuts', 'false', 'No'),
(12, 'allow_group_categories', 'true', 'Yes'),
(13, 'allow_group_categories', 'false', 'No'),
(14, 'server_type', 'production', 'ProductionServer'),
(15, 'server_type', 'test', 'TestServer'),
(16, 'allow_name_change', 'true', 'Yes'),
(17, 'allow_name_change', 'false', 'No'),
(18, 'allow_officialcode_change', 'true', 'Yes'),
(19, 'allow_officialcode_change', 'false', 'No'),
(20, 'allow_registration', 'true', 'Yes'),
(21, 'allow_registration', 'false', 'No'),
(22, 'allow_registration', 'approval', 'AfterApproval'),
(23, 'allow_registration_as_teacher', 'true', 'Yes'),
(24, 'allow_registration_as_teacher', 'false', 'No'),
(25, 'allow_lostpassword', 'true', 'Yes'),
(26, 'allow_lostpassword', 'false', 'No'),
(27, 'allow_user_headings', 'true', 'Yes'),
(28, 'allow_user_headings', 'false', 'No'),
(29, 'allow_personal_agenda', 'true', 'Yes'),
(30, 'allow_personal_agenda', 'false', 'No'),
(31, 'display_coursecode_in_courselist', 'true', 'Yes'),
(32, 'display_coursecode_in_courselist', 'false', 'No'),
(33, 'display_teacher_in_courselist', 'true', 'Yes'),
(34, 'display_teacher_in_courselist', 'false', 'No'),
(35, 'use_document_title', 'true', 'Yes'),
(36, 'use_document_title', 'false', 'No'),
(37, 'permanently_remove_deleted_files', 'true', 'YesWillDeletePermanently'),
(38, 'permanently_remove_deleted_files', 'false', 'NoWillDeletePermanently'),
(39, 'dropbox_allow_overwrite', 'true', 'Yes'),
(40, 'dropbox_allow_overwrite', 'false', 'No'),
(41, 'dropbox_allow_just_upload', 'true', 'Yes'),
(42, 'dropbox_allow_just_upload', 'false', 'No'),
(43, 'dropbox_allow_student_to_student', 'true', 'Yes'),
(44, 'dropbox_allow_student_to_student', 'false', 'No'),
(45, 'dropbox_allow_group', 'true', 'Yes'),
(46, 'dropbox_allow_group', 'false', 'No'),
(47, 'dropbox_allow_mailing', 'true', 'Yes'),
(48, 'dropbox_allow_mailing', 'false', 'No'),
(49, 'extended_profile', 'true', 'Yes'),
(50, 'extended_profile', 'false', 'No'),
(51, 'student_view_enabled', 'true', 'Yes'),
(52, 'student_view_enabled', 'false', 'No'),
(53, 'show_navigation_menu', 'false', 'No'),
(54, 'show_navigation_menu', 'icons', 'IconsOnly'),
(55, 'show_navigation_menu', 'text', 'TextOnly'),
(56, 'show_navigation_menu', 'iconstext', 'IconsText'),
(57, 'enable_tool_introduction', 'true', 'Yes'),
(58, 'enable_tool_introduction', 'false', 'No'),
(59, 'page_after_login', 'index.php', 'CampusHomepage'),
(60, 'page_after_login', 'user_portal.php', 'MyCourses'),
(61, 'breadcrumbs_course_homepage', 'get_lang', 'CourseHomepage'),
(62, 'breadcrumbs_course_homepage', 'course_code', 'CourseCode'),
(63, 'breadcrumbs_course_homepage', 'course_title', 'CourseTitle'),
(64, 'example_material_course_creation', 'true', 'Yes'),
(65, 'example_material_course_creation', 'false', 'No'),
(66, 'use_session_mode', 'true', 'Yes'),
(67, 'use_session_mode', 'false', 'No'),
(68, 'allow_email_editor', 'true', 'Yes'),
(69, 'allow_email_editor', 'false', 'No'),
(70, 'show_email_addresses', 'true', 'Yes'),
(71, 'show_email_addresses', 'false', 'No'),
(72, 'wcag_anysurfer_public_pages', 'true', 'Yes'),
(73, 'wcag_anysurfer_public_pages', 'false', 'No'),
(74, 'upload_extensions_list_type', 'blacklist', 'Blacklist'),
(75, 'upload_extensions_list_type', 'whitelist', 'Whitelist'),
(76, 'upload_extensions_skip', 'true', 'Remove'),
(77, 'upload_extensions_skip', 'false', 'Rename'),
(78, 'show_number_of_courses', 'true', 'Yes'),
(79, 'show_number_of_courses', 'false', 'No'),
(80, 'show_empty_course_categories', 'true', 'Yes'),
(81, 'show_empty_course_categories', 'false', 'No'),
(82, 'show_back_link_on_top_of_tree', 'true', 'Yes'),
(83, 'show_back_link_on_top_of_tree', 'false', 'No'),
(84, 'show_different_course_language', 'true', 'Yes'),
(85, 'show_different_course_language', 'false', 'No'),
(86, 'split_users_upload_directory', 'true', 'Yes'),
(87, 'split_users_upload_directory', 'false', 'No'),
(88, 'hide_dltt_markup', 'false', 'No'),
(89, 'hide_dltt_markup', 'true', 'Yes'),
(90, 'display_categories_on_homepage', 'true', 'Yes'),
(91, 'display_categories_on_homepage', 'false', 'No'),
(92, 'default_forum_view', 'flat', 'Flat'),
(93, 'default_forum_view', 'threaded', 'Threaded'),
(94, 'default_forum_view', 'nested', 'Nested'),
(95, 'survey_email_sender_noreply', 'coach', 'CourseCoachEmailSender'),
(96, 'survey_email_sender_noreply', 'noreply', 'NoReplyEmailSender'),
(97, 'openid_authentication', 'true', 'Yes'),
(98, 'openid_authentication', 'false', 'No'),
(99, 'gradebook_enable', 'true', 'Yes'),
(100, 'gradebook_enable', 'false', 'No'),
(101, 'user_selected_theme', 'true', 'Yes'),
(102, 'user_selected_theme', 'false', 'No'),
(103, 'allow_course_theme', 'true', 'Yes'),
(104, 'allow_course_theme', 'false', 'No'),
(105, 'display_mini_month_calendar', 'true', 'Yes'),
(106, 'display_mini_month_calendar', 'false', 'No'),
(107, 'display_upcoming_events', 'true', 'Yes'),
(108, 'display_upcoming_events', 'false', 'No'),
(109, 'show_closed_courses', 'true', 'Yes'),
(110, 'show_closed_courses', 'false', 'No'),
(111, 'ldap_version', '2', 'LDAPVersion2'),
(112, 'ldap_version', '3', 'LDAPVersion3'),
(113, 'visio_use_rtmpt', 'true', 'Yes'),
(114, 'visio_use_rtmpt', 'false', 'No'),
(115, 'add_users_by_coach', 'true', 'Yes'),
(116, 'add_users_by_coach', 'false', 'No'),
(117, 'extend_rights_for_coach', 'true', 'Yes'),
(118, 'extend_rights_for_coach', 'false', 'No'),
(119, 'extend_rights_for_coach_on_survey', 'true', 'Yes'),
(120, 'extend_rights_for_coach_on_survey', 'false', 'No'),
(121, 'show_session_coach', 'true', 'Yes'),
(122, 'show_session_coach', 'false', 'No'),
(123, 'allow_users_to_create_courses', 'true', 'Yes'),
(124, 'allow_users_to_create_courses', 'false', 'No'),
(125, 'breadcrumbs_course_homepage', 'session_name_and_course_title', 'SessionNameAndCourseTitle'),
(126, 'advanced_filemanager', 'true', 'Yes'),
(127, 'advanced_filemanager', 'false', 'No'),
(128, 'allow_reservation', 'true', 'Yes'),
(129, 'allow_reservation', 'false', 'No'),
(130, 'allow_message_tool', 'true', 'Yes'),
(131, 'allow_message_tool', 'false', 'No'),
(132, 'allow_social_tool', 'true', 'Yes'),
(133, 'allow_social_tool', 'false', 'No'),
(134, 'allow_students_to_browse_courses', 'true', 'Yes'),
(135, 'allow_students_to_browse_courses', 'false', 'No'),
(136, 'show_email_of_teacher_or_tutor ', 'true', 'Yes'),
(137, 'show_email_of_teacher_or_tutor ', 'false', 'No'),
(138, 'show_session_data ', 'true', 'Yes'),
(139, 'show_session_data ', 'false', 'No'),
(140, 'allow_use_sub_language', 'true', 'Yes'),
(141, 'allow_use_sub_language', 'false', 'No'),
(142, 'show_glossary_in_documents', 'none', 'ShowGlossaryInDocumentsIsNone'),
(143, 'show_glossary_in_documents', 'ismanual', 'ShowGlossaryInDocumentsIsManual'),
(144, 'show_glossary_in_documents', 'isautomatic', 'ShowGlossaryInDocumentsIsAutomatic'),
(145, 'allow_terms_conditions', 'true', 'Yes'),
(146, 'allow_terms_conditions', 'false', 'No'),
(147, 'search_enabled', 'true', 'Yes'),
(148, 'search_enabled', 'false', 'No'),
(149, 'search_show_unlinked_results', 'true', 'SearchShowUnlinkedResults'),
(150, 'search_show_unlinked_results', 'false', 'SearchHideUnlinkedResults'),
(151, 'show_courses_descriptions_in_catalog', 'true', 'Yes'),
(152, 'show_courses_descriptions_in_catalog', 'false', 'No'),
(153, 'allow_coach_to_edit_course_session', 'true', 'Yes'),
(154, 'allow_coach_to_edit_course_session', 'false', 'No'),
(155, 'show_glossary_in_extra_tools', 'true', 'Yes'),
(156, 'show_glossary_in_extra_tools', 'false', 'No'),
(157, 'send_email_to_admin_when_create_course', 'true', 'Yes'),
(158, 'send_email_to_admin_when_create_course', 'false', 'No'),
(159, 'go_to_course_after_login', 'true', 'Yes'),
(160, 'go_to_course_after_login', 'false', 'No'),
(161, 'math_mimetex', 'true', 'Yes'),
(162, 'math_mimetex', 'false', 'No'),
(163, 'math_asciimathML', 'true', 'Yes'),
(164, 'math_asciimathML', 'false', 'No'),
(165, 'youtube_for_students', 'true', 'Yes'),
(166, 'youtube_for_students', 'false', 'No'),
(167, 'block_copy_paste_for_students', 'true', 'Yes'),
(168, 'block_copy_paste_for_students', 'false', 'No'),
(169, 'more_buttons_maximized_mode', 'true', 'Yes'),
(170, 'more_buttons_maximized_mode', 'false', 'No'),
(171, 'students_download_folders', 'true', 'Yes'),
(172, 'students_download_folders', 'false', 'No'),
(173, 'cas_activate', 'true', 'Yes'),
(174, 'cas_activate', 'false', 'No'),
(175, 'cas_protocol', 'CAS1', 'CAS1Text'),
(176, 'cas_protocol', 'CAS2', 'CAS2Text'),
(177, 'cas_protocol', 'SAML', 'SAMLText'),
(178, 'cas_add_user_activate', 'true', 'Yes'),
(179, 'cas_add_user_activate', 'false', 'No'),
(180, 'mindmap_converter_activated', 'true', 'Yes'),
(181, 'mindmap_converter_activated', 'false', 'No'),
(182, 'agenda_default_view', 'month', 'MonthView'),
(183, 'agenda_default_view', 'agendaWeek', 'WeekView'),
(184, 'agenda_default_view', 'agendaDay', 'DayView'),
(185, 'agenda_action_icons', 'true', 'Yes'),
(186, 'agenda_action_icons', 'false', 'No'),
(187, 'calendar_detail_view', 'detail', 'DetailView'),
(188, 'calendar_detail_view', 'edit', 'EditView'),
(189, 'calendar_navigation', 'actions', 'CalendarNavigationActions'),
(190, 'calendar_navigation', 'default', 'CalendarNavigationDefault'),
(191, 'display_feedback_messages', 'true', 'Yes'),
(192, 'display_feedback_messages', 'false', 'No'),
(193, 'allow_user_edit_agenda', 'true', 'Yes'),
(194, 'allow_user_edit_agenda', 'false', 'No'),
(195, 'user_manage_group_agenda', 'true', 'Yes'),
(196, 'user_manage_group_agenda', 'false', 'No'),
(197, 'captcha', 'true', 'Yes'),
(198, 'captcha', 'false', 'No'),
(199, 'calendar_export_all', 'true', 'Yes'),
(200, 'calendar_export_all', 'false', 'No'),
(201, 'display_context_help', 'true', 'Yes'),
(202, 'display_context_help', 'false', 'No'),
(203, 'display_breadcrumbs', 'true', 'Yes'),
(204, 'display_breadcrumbs', 'false', 'No'),
(205, 'display_platform_header_in_course', 'show', 'ShowPlatformHeaderInCourse'),
(206, 'display_platform_header_in_course', 'hide', 'HidePlatformHeaderInCourse'),
(207, 'display_platform_header_in_course', 'toggle', 'TogglePlatformHeaderInCourse'),
(208, 'show_quizcategory', 'true', 'Yes'),
(209, 'show_quizcategory', 'false', 'No'),
(210, 'show_emailtemplates', 'true', 'Yes'),
(211, 'show_emailtemplates', 'false', 'No'),
(212, 'show_catalogue', 'true', 'Yes'),
(213, 'show_catalogue', 'false', 'No'),
(214, 'automatic_group_filling', 'true', 'Yes'),
(215, 'automatic_group_filling', 'false', 'No'),
(216, 'create_new_group', 'true', 'Yes'),
(217, 'create_new_group', 'false', 'No'),
(218, 'force_password_change_account_creation', 'true', 'Yes'),
(219, 'force_password_change_account_creation', 'false', 'No'),
(220, 'show_force_password_change', 'true', 'Yes'),
(221, 'show_force_password_change', 'false', 'No');

-- --------------------------------------------------------

--
-- Table structure for table `shared_survey`
--

CREATE TABLE `shared_survey` (
  `survey_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) DEFAULT NULL,
  `title` text,
  `subtitle` text,
  `author` varchar(250) DEFAULT NULL,
  `lang` varchar(20) DEFAULT NULL,
  `template` varchar(20) DEFAULT NULL,
  `intro` text,
  `surveythanks` text,
  `creation_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `course_code` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`survey_id`),
  UNIQUE KEY `id` (`survey_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `shared_survey_question`
--

CREATE TABLE `shared_survey_question` (
  `question_id` int(11) NOT NULL AUTO_INCREMENT,
  `survey_id` int(11) NOT NULL DEFAULT '0',
  `survey_question` text NOT NULL,
  `survey_question_comment` text NOT NULL,
  `type` varchar(250) NOT NULL DEFAULT '',
  `display` varchar(10) NOT NULL DEFAULT '',
  `sort` int(11) NOT NULL DEFAULT '0',
  `code` varchar(40) NOT NULL DEFAULT '',
  `max_value` int(11) NOT NULL,
  PRIMARY KEY (`question_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `shared_survey_question_option`
--

CREATE TABLE `shared_survey_question_option` (
  `question_option_id` int(11) NOT NULL AUTO_INCREMENT,
  `question_id` int(11) NOT NULL DEFAULT '0',
  `survey_id` int(11) NOT NULL DEFAULT '0',
  `option_text` text NOT NULL,
  `sort` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`question_option_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `single_sign_on_association`
--

CREATE TABLE `single_sign_on_association` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` text NOT NULL,
  `date_end` datetime DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `login_status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `slides`
--

CREATE TABLE `slides` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `alternate_text` varchar(255) NOT NULL DEFAULT '',
  `link` varchar(255) NOT NULL DEFAULT '',
  `caption` text,
  `image` varchar(255) NOT NULL DEFAULT '',
  `language` varchar(255) NOT NULL DEFAULT 'English',
  `display_order` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `slides_management`
--

CREATE TABLE `slides_management` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `show_slide` int(11) NOT NULL DEFAULT '1',
  `slide_speed` int(11) NOT NULL DEFAULT '6',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `slides_management`
--

INSERT INTO `slides_management` VALUES
(1, 1, 6);

-- --------------------------------------------------------

--
-- Table structure for table `specific_field`
--

CREATE TABLE `specific_field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` char(1) NOT NULL,
  `name` varchar(200) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_specific_field__code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `specific_field_values`
--

CREATE TABLE `specific_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_code` varchar(40) NOT NULL,
  `tool_id` varchar(100) NOT NULL,
  `ref_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `system_template`
--

CREATE TABLE `system_template` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(250) NOT NULL,
  `comment` text NOT NULL,
  `image` varchar(250) NOT NULL,
  `content` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=47 ;

--
-- Dumping data for table `system_template`
--

INSERT INTO `system_template` VALUES
(14, 'TemplateTitleTwoColumns', 'TemplateTitleTwoColumnsDescription', 'twocolumns.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent table_actions table_actions_rows"><tr>\r\n				\r\n				    \r\n			    <td class="roundcell"><h2>Essi bla </h2>\r\n                                   <p>Essi bla accum zzrit aliquis er in erostio dolore doloreet aliquat. Duip eugiate consed magna faci blam.</p>\r\n                                   <p>Gue verilisl del ullut prat wisl eraestrud dolumsan vendreet nostinim volum iustrud te dolobore magniamet ullamet utetum dunt wiscipit, volenis acin henit lum zzrit aci tin vel utpatem vulput adit lum zzriure delisi bla feu feummodit vel utetue eum dolor sequi ting ero et non volessequi euis nulluta tummolor sequis enismodit ex eugiamet in ut utet ulla facipis nos ad </p>\r\n                                 \r\n			    </td>\r\n                                             \r\n			\r\n				\r\n				\r\n				<td class="imagecenter" valign="bottom">\r\n				\r\n						<img src="{IMG_DIR}templates/instructor-hands.jpg" />\r\n						\r\n				</td>\r\n				\r\n				\r\n				<td class="roundcell"><h2>Essi bla </h2>\r\n                                   <p>Essi bla accum zzrit aliquis er in erostio dolore doloreet aliquat. Duip eugiate consed magna faci blam.</p>\r\n                                   <p>Ut alit lor inim volobore dit, quipit venissi bla ad dolor adit augiat. Pit landit iriliquisi te cons et in ut eu feuguerci blandipit alis dit atueriure magna faccum velenim velit wis eu feugait et adipis nis nullaor perosto dolorem ipit iurerci eraesto</p>\r\n                                   <p>Duip eugiate consed magna faci blam.</p>                                        \r\n			\r\n				</td>\r\n			</tr>\r\n			</table><!-- end table for the cells of content -->\r\n			\r\n			</td>\r\n			</tr>			\r\n		  </table> <!-- end white table for the course -->\r\n</body>'),
(15, 'TemplateTitleArrowChannel', 'TemplateTitleArrowChannelDescription', 'arrowchannel.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr>\r\n			\r\n			<td>\r\n				<!--- tableau droit pour l''illustration et la bulle--->\r\n				<table class="perso-and-buble">\r\n				<tr><td id="buble-talk">\r\n				  <p>Deliquat ute faccummy nullums andionsed et wisci bla consequis eraestrud magna adipsus cidunt ullam, consed erci blandipit landre.</p>\r\n				  </td>\r\n				</tr>\r\n				<tr><td><img src="{IMG_DIR}templates/instructor-puzzle.jpg" alt="" /></td>\r\n				</tr>\r\n				</table> \r\n				<!--- fin tableau droit pour lillustration et la bulle --->\r\n				</td>\r\n				<td>\r\n			   <!-- tableau fleche-->\r\n			   <table class="arrow-ch table_actions table_actions_rows">				\r\n			   <tr valign="bottom"><td class="arrow-ch-int">\r\n			    <h2>Ad ming erit</h2>\r\n			   <p>Consequat nis elenibh eugiam zzrit utet.</p>\r\n			   </td></tr>\r\n			    <tr><td class="arrow-ch-int">\r\n				 <h2>Ad ming erit</h2>\r\n			   <p>Consequat nis elenibh eugiam zzrit utet.</p>\r\n			   </td></tr>\r\n			    <tr><td class="arrow-ch-int">\r\n				 <h2>Ad ming erit</h2>\r\n			   <p>Consequat nis elenibh eugiam zzrit utet.</p>\r\n			   </td></tr>\r\n			   </table>\r\n				<!-- fin tableau fleche-->		\r\n				\r\n				\r\n				 <!-- tableau fin -->\r\n			   <table class="ch-end">				\r\n			   <tr><td>\r\n			   <h2>Magna corper sum iriurercipit </h2>\r\n			  \r\n				<p>Oborem qui tat diat.<br />\r\n				Consequat nis elenibh eugiam zzrit utet.</p>\r\n				</td></tr>\r\n			  \r\n			  \r\n				</table>\r\n				<!-- fin tableau fin -->\r\n				</td>\r\n				\r\n				\r\n				\r\n		  </tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course -->\r\n</body>'),
(16, 'TemplateTitleBiblio', 'TemplateTitleBiblioDescription', 'biblio.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent">\r\n				<tr><td>\r\n			\r\n				\r\n					   <table class="liste-livre table_actions table_actions_rows">\r\n					   <tr><td class="book">\r\n				    <h3>si erilit ad magna ad </h3>\r\n					 <h4 class="details">ad lorem ipsum - ipsum</h4>\r\n					 <p>\r\n					 si erilit ad magna ad dolorercing ea consequis dolorpe raessequat. Si erilit ad magna ad dolorercing.</p><p>\r\n					 si erilit ad magna ad dolorercing ea consequis dolorpe raessequat. Si erilit ad magna ad dolorercing.</p></td></tr>\r\n					 <tr><td class="book">\r\n				    <h3>si erilit ad magna ad </h3>\r\n					 <h4 class="details">ad lorem ipsum - ipsum</h4>\r\n					 <p>\r\n					si erilit ad magna ad dolorercing ea consequis dolorpe raessequat. Si erilit ad magna ad dolorercing.</p></td></tr>\r\n					<tr><td class="book">\r\n				    <h3>si erilit ad magna ad </h3>\r\n					 <h4 class="details">ad lorem ipsum - ipsum</h4>\r\n					 <p>\r\n					 si erilit ad magna ad dolorercing ea consequis dolorpe raessequat. Si erilit ad magna ad dolorercing.</p>\r\n					 </td></tr>\r\n					 </table>\r\n					\r\n					 <td><img src="{IMG_DIR}templates/instructor-with-books.jpg" /></td>\r\n                     </tr>\r\n		           </table>\r\n				  \r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td></tr>				\r\n		  </table><!-- end white table for the course --></body>		           '),
(17, 'TemplateTitleCertificate', 'TemplateTitleCertificateDescription', 'certificate.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr>\r\n				<td>\r\n			\r\n				<!-- tableau gauche pour bulle + perso -->\r\n				<table class="perso-and-buble">\r\n				<tr>\r\n				  <td id="buble-talk"><p>volenis acin henit lum zzrit aci tin vel feummodit vel utetue eum dolor sequi ting ero !</p>\r\n			      </td>\r\n				  \r\n				</tr>\r\n				<tr>\r\n				<td><img src="{IMG_DIR}templates/instructor-certificate.jpg" alt="" /></td>\r\n				</tr>\r\n				\r\n				</table>\r\n				<!-- fin tableau gauche -->\r\n				</td>\r\n				\r\n				<td>\r\n				<!--- right table certificate --->\r\n				<table class="certif" >\r\n				<tr><td>\r\n				<table class="certif-in">\r\n				<tr>\r\n				<td>\r\n				<h2>Faccummy nim</h2>\r\n				<p>Ex et, qui estrud eu faccummy nostie dolorti nciliqu ipiscil utat</p><p>Qatuercil dolore dipit volorpe raeseni ssenis aliquatue.</p>\r\n				<p class="little">Dunt am eummy nullaorem incillaortie te</p>\r\n				<p class="little-bold-right">Dunt am te</p>\r\n				</td>\r\n				</tr>\r\n				</table></td></tr>\r\n				</table> \r\n				<!--- end certificate--->\r\n				</td>\r\n				\r\n			  </tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course -->\r\n</body>'),
(18, 'TemplateTitleCircularFourCells', 'TemplateTitleCircularFourCellsDescription', 'circularfourcells.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr>\r\n				<td>\r\n			\r\n				<!-- tableau gauche pour bulle + perso -->\r\n				<table class="perso-and-buble">\r\n				<tr>\r\n				  <td id="buble-talk"><p>si erilit ad magna ad dolorercing.Pit landit iriliquisi te cons et in ut eu feuguerci blandipit alis dit atueriure magna faccum velenim velit wis eu feugait et adipis</p>\r\n			      </td>\r\n				  \r\n				</tr>\r\n				<tr>\r\n				<td><img src="{IMG_DIR}templates/instructor-showleft.jpg" alt="" /></td>\r\n				</tr>\r\n				\r\n				</table>\r\n				<!-- fin tableau gauche -->\r\n				</td>\r\n				\r\n				<td>\r\n				<!--- tableau droit pour cercle --->\r\n				<table class="circular" >\r\n				<!--HAUT--><tr><td><table class="circ-a1"><tr><td><table id="circ-a2">\r\n				  <tr><td width="150">&nbsp;</td><td class="circular-item"><p>Do ero eum iustrud</p>\r\n				     </td><td>&nbsp;</td></tr><tr><td colspan="3" height="60px">&nbsp;</td></tr></table></td></tr></table>\r\n				</td></tr>\r\n				<!-- MILIEU--><tr><td><table class="circ-a1"><tr><td class="circular-item"><p>Ci ex et landipit </p>\r\n				          </td><td>&nbsp;</td><td class="circular-item"><p>Dolesequip essisit aut </p></td></tr>\r\n				</table>\r\n				</td></tr>\r\n				<!-- BAS--><tr><td><table class="circ-a1"><tr><td><table id="circ-a3">\r\n				  <tr><td colspan="3" height="50px">&nbsp;</td></tr>\r\n				  <tr><td width="160">&nbsp;</td><td class="circular-item"><p>Ut wis diamet in vulputpate </p>\r\n				      </td><td>&nbsp;</td></tr></table></td></tr></table>\r\n				</td></tr>\r\n				</table> \r\n				<!--- fin tableau droit pour cercle--->\r\n				</td>\r\n				\r\n			  </tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course -->\r\n</body>'),
(19, 'TemplateTitleCircularFiveCells', 'TemplateTitleCircularFiveCellsDescription', 'circularfivecells.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr>\r\n				<td>\r\n			\r\n				<!-- tableau gauche pour bulle + perso -->\r\n				<table class="perso-and-buble">\r\n				<tr>\r\n				  <td id="buble-talk"><p>si erilit ad magna ad dolorercing. Ut alit ecte dolor iuscil enit numsand ionsenim niate do ent lorperate volor accum nissed molenis nulput in ero.</p>\r\n			      </td>\r\n				  \r\n				</tr>\r\n				<tr>\r\n				<td><img src="{IMG_DIR}templates/instructor-showleft.jpg" alt="" /></td>\r\n				</tr>\r\n				\r\n				</table>\r\n				<!-- fin tableau gauche -->\r\n				</td>\r\n				\r\n				<td>\r\n				<!--- tableau droit pour cercle --->\r\n				<table class="circular" >\r\n				<!--HAUT--><tr><td><table class="circ-a1"><tr><td><table id="circ-a2">\r\n				  <tr><td width="150">&nbsp;</td><td class="circular-item"><p>Do ero eum iustrud</p>\r\n				\r\n				      </td><td>&nbsp;</td></tr><tr><td colspan="5" height="40px">&nbsp;</td></tr></table></td></tr></table>\r\n				</td></tr>\r\n				<!-- MILIEU--><tr><td><table class="circ-a1"><tr><td class="circular-item"><p>Ci ex et landipit </p>\r\n				          </td><td colspan="3">&nbsp;</td><td class="circular-item"><p>Dolesequip essisit aut </p></td></tr>\r\n				</table>\r\n				</td></tr>\r\n				<!-- BAS--><tr><td><table class="circ-a1"><tr><td><table id="circ-a3">\r\n				  <tr><td colspan="5" height="60px">&nbsp;</td></tr>\r\n				  <tr><td width="60">&nbsp;</td><td class="circular-item"><p>Ut wis diamet in diamet </p>\r\n				     </td><td width="50">&nbsp;</td><td class="circular-item"><p>Ut wis diamet</p>\r\n				      </td><td width="60">&nbsp;</td></tr></table></td></tr></table>\r\n				</td></tr>\r\n				</table> \r\n				<!--- fin tableau droit pour cercle--->\r\n				</td>\r\n				\r\n			  </tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(20, 'TemplateTitleDiagram', 'TemplateTitleDiagramDescription', 'diagram2.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent">\r\n				\r\n				<tr>\r\n				  \r\n				<td><img src="{IMG_DIR}templates/instructor-diagram.jpg" alt="" /></td>\r\n							\r\n				<td>\r\n				<table class="diag table_actions table_actions_columns">\r\n                             \r\n                             <tr class="diagcorpus">\r\n                               <td><h2>Essi bla </h2>\r\n							       <img src="{IMG_DIR}templates/diagram1.png" />\r\n                                   <p>Essi bla accum zzrit.</p></td>\r\n								<td><h2>Essi bla </h2>\r\n								<img src="{IMG_DIR}templates/diagram2.png" />\r\n                                   <p>Erostio dolore doloreet aliquat.</p></td>\r\n								<td><h2>Essi bla </h2>\r\n								<img src="{IMG_DIR}templates/diagram3.png" />\r\n                                   <p>Duip eugiate consed magna faci blam.</p></td>\r\n                             </tr>\r\n                             <tr class="diagarrow">\r\n                                <td><p>Essi bla </p>\r\n                                  </td>\r\n								<td><p>Essi bla </p>\r\n                                   </td>\r\n								<td><p>Essi bla </p>\r\n                                   </td>\r\n                             </tr>\r\n							 <tr class="diagcomment">\r\n                                <td colspan="3"><h2>Ea faciduis nullummy</h2><p>Essi bla Ut ad enissequat wismolum augait essenibh ea faciduis nullummy nulla alis nos nullam num dolum adigna faccum ilisl ex er sim vercipi scidunt la facinim deliqui scidunt alit praestie dignisit inibh eriustrud eraestinit nibh ectet essim duipissecte dit erit eummodo lendre vel er illa faccum irillaor </p>\r\n                               </td>\r\n                             </tr>\r\n                            \r\n               </table>                      \r\n\r\n				</td>\r\n				</tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(21, 'TemplateTitleFaq', 'TemplateTitleFaqDescription', 'faq.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr>\r\n			<td >\r\n				<!---  left table for perso --->\r\n				\r\n				<table class="perso-and-buble">\r\n				<tr>\r\n				  <td id="buble-talk"><p>si erilit ad magna ad dolorercing. Ut alit lor inim volobore dit, quipit venissi bla ad dolor adit.</p>\r\n			      </td>\r\n				  \r\n				</tr>\r\n				<tr>\r\n				<td><img src="{IMG_DIR}templates/instructor-faq.jpg" alt="" /></td>\r\n				</tr>\r\n				\r\n				</table>\r\n				\r\n				<!-- end left table perso -->		\r\n				</td>\r\n				<td>\r\n			\r\n				<!-- tableau 1 gauche -->\r\n				<table class="right-table">\r\n				<tr><td>\r\n				\r\n				  <!-- tableau gris container -->\r\n				     <table cellpadding="0" cellspacing="0" class="grey-frame">\r\n                       <tr>\r\n                         <td>\r\n						 <!-- tableau de contenu haut degrade -->\r\n						 <table class="item table_actions table_actions_rows">\r\n                             \r\n                             <tr>\r\n                               <td class="faq"><h2>Mod magna feuisis elit ut wisim ipis nulla ?</h2>\r\n                                   <p>Essi bla accum zzrit aliquis er in erostio dolore doloreet aliquat. Duip eugiate consed magna faci blam. Tatue moluptatis ad enibh.</p>\r\n                               </td>\r\n								 \r\n                             </tr>\r\n							 <tr>\r\n                               <td class="faq"><h2>Aute faccummy nim do od tio esse ? </h2>\r\n                                   <p>Cillaortie te dolortin utat adignis at, quip estrud dolorpe rostrud tet ut init at delit luptat, se exercin henim nonsequating ero dip essisl in et wisit wis erosto eu feugue consed moloreet vel eumsand.</p>\r\n                               </td>\r\n								 \r\n                             </tr>\r\n							 <tr>\r\n                               <td class="faq"><h2>Qui estrud eu faccummy nostie dolorti ?</h2>\r\n                                   <p>Re eui eu feuipisim autem vendipsum zzrit dunt alisisl ip eros at diate mincilla amcon henibh elisi.</p>\r\n                                   </td>\r\n								 \r\n                             </tr>\r\n							 <tr>\r\n                               <td class="faq"><h2>Isse magnismolore dolore con henim nummy ?</h2>\r\n                                   <p>It, consed ent ilis nullaore vel ullum volessenibh ex er se venit alis nulluptat. La feum aliquis ismoluptat ulput et atumsandrer ing ex euissi etummodo el ullan ulpute feum ilit nullaorem dolenit augait.</p>\r\n                                   </td>\r\n								 \r\n                             </tr>\r\n                           </table>\r\n                           <!-- fin tableau de contenu haut degrade -->                      \r\n						   </td>\r\n                       </tr>\r\n		          </table>\r\n				     <!-- fin du tableau gris containeur -->\r\n				</td>\r\n				</tr>\r\n				</table> \r\n				<!-- fin tableau 1 gauche -->\r\n				</td>				\r\n				\r\n				\r\n				\r\n			</tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(22, 'TemplateTitleFrame', 'TemplateTitleFrameDescription', 'frame.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr>\r\n				\r\n					   <td>\r\n					   <table class="left-table-for-text table_actions table_actions_rows">\r\n					   <tr><td>\r\n				    <h3>Si erilit ad magna ad </h3>\r\n					 <h4 class="details">ad lorem ipsum - ipsum</h4>\r\n					 <p>\r\n					 Si erilit ad magna ad dolorercing ea consequis dolorpe raessequat. Ut alit lor inim volobore dit, quipit venissi bla ad dolor adit augiat. Pit landit iriliquisi te cons et in ut eu feuguerci blandipit alis dit atueriure magna faccum velenim velit wis eu feugait et adipis nis nullaor perosto dolorem ipit iurerci eraesto.</p>\r\n				    <p>In el do od deliquatio odit esequisit ipsummo dolessequat lorer aliquis eumsandio consequamcon ut ing et, quisse dipit ver.</p>\r\n				    <p> incillam eum iusci tate del ut lut wiscilit aute faccummy nim do od tio esse dolore venim vent nis augiamcon hendre feuis at. </p>\r\n				    <p>It, consed ent ilis nullaore vel ullum volessenibh ex er se venit alis nulluptat. Uptatue raestrud duisi.\r\nLa feum aliquis ismoluptat ulput et atumsandrer ing ex euissi etummodo el ullan ulpute feum ilit nullaorem dolenit augait.</p>\r\n				    </td></tr>\r\n					   </table>\r\n					</td>\r\n						 \r\n                     <td>\r\n						<table class="persoandframe"><tr><td><img src="{IMG_DIR}templates/instructor-frame.jpg" /></td>\r\n						</tr><tr><td class="frame-for-text"><h2>Ea consenibh eugiam</h2>\r\n						<p>Ex et, qui estrud eu faccummy nostie dolorti nciliqu ipiscil utat, quatuercil dolore dipit volorpe raeseni ssenis aliquatue.</p>\r\n						<p>Em vel dolorer ciliqui smolor sequat. Put prat nit.</p></td></tr></table>\r\n					 </td>\r\n                       				\r\n			    </tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course -->\r\n</body>'),
(23, 'TemplateTitleGallery', 'TemplateTitleGalleryDescription', 'gallery.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent2 table_actions table_actions_rows">\r\n						<tr>\r\n						<td class="item-image-legende">\r\n						<img src="{IMG_DIR}templates/little-placeholder-image.jpg" />\r\n						<p>lorem ipsum and ipsum lorem ipsum and ipsum</p>\r\n						</td>\r\n						\r\n						<td class="item-image-legende">\r\n						<img src="{IMG_DIR}templates/little-placeholder-image.jpg" />\r\n						<p>lorem ipsum and ipsum lorem ipsum and ipsum</p>\r\n						</td>\r\n						\r\n						<td class="item-image-legende">\r\n						<img src="{IMG_DIR}templates/little-placeholder-image.jpg" />\r\n						<p>lorem ipsum and ipsum lorem ipsum and ipsum</p>\r\n						</td>\r\n						</tr>\r\n						<tr>						\r\n						<td class="item-image-legende">\r\n						<img src="{IMG_DIR}templates/little-placeholder-image.jpg" />\r\n						<p>lorem ipsum and ipsum lorem ipsum and ipsum</p>\r\n						</td>\r\n						\r\n						<td class="item-image-legende">\r\n						<img src="{IMG_DIR}templates/little-placeholder-image.jpg" />\r\n						<p>lorem ipsum and ipsum lorem ipsum and ipsum</p>\r\n						</td>\r\n						\r\n						<td class="item-image-legende">\r\n						<img src="{IMG_DIR}templates/little-placeholder-image.jpg" />\r\n						<p>lorem ipsum and ipsum lorem ipsum and ipsum</p>\r\n						</td>\r\n						</tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(24, 'TemplateTitleGears', 'TemplateTitleGearsDescription', 'gears.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr>\r\n				<td>\r\n			\r\n				<!-- tableau gauche pour bulle + perso -->\r\n				<table class="perso-and-buble">\r\n				<tr>\r\n				  <td id="buble-talk-ud"><p>si erilit ad magna ad dolorercing.Isse magnismolore dolore con henim nummy nulla.</p>\r\n			      </td>\r\n				  \r\n				</tr>\r\n				<tr>\r\n				<td><img src="{IMG_DIR}templates/instructor-impulsion.jpg" alt="" /></td>\r\n				</tr>\r\n				\r\n				</table>\r\n				<!-- fin tableau gauche -->\r\n				</td>\r\n				\r\n				<td>\r\n				<!--- tableau droit pour rouages --->\r\n				<table class="rouages" >\r\n				<tr>\r\n				<td id="bord-un"></td>\r\n				<td id="rouage-un">Er sum vulla am diamet</td>\r\n				<td id="bord-deux"></td>\r\n				<td id="rouage-deux">Quisci bla conullam zzrilit</td>\r\n				<td id="rouage-trois">Ci ex et landipit nosto</td>\r\n				<td id="bord-trois"></td>\r\n				</tr>\r\n				\r\n				</table> \r\n				<!--- fin tableau droit pour rouages--->\r\n				</td>\r\n				\r\n			  </tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(25, 'TemplateTitleGrowth', 'TemplateTitleGrowthDescription', 'growth.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr>\r\n				<td>\r\n			\r\n				<!-- tableau gauche pour bulle + perso -->\r\n				<table class="perso-and-buble">\r\n				<tr>\r\n				  <td id="buble-talk"><p>si erilit ad magna ad dolorercing.</p><p>Ipisseq uissit lor secte faccumsandit ipsum diamcom modolortie.  nulput in ero exercipit wismodi.</p>\r\n			      </td>\r\n				  \r\n				</tr>\r\n				<tr>\r\n				<td><img src="{IMG_DIR}templates/instructor-climbing.jpg" alt="" /></td>\r\n				</tr>\r\n				\r\n				</table>\r\n				<!-- fin tableau gauche -->\r\n				</td>\r\n				\r\n				<td>\r\n				<!--- tableau droit pour rouages --->\r\n				<table class="growth" >\r\n			\r\n				<tr><td class="text-growth-stage">\r\n				<table class="table_actions table_actions_rows">\r\n				<tr><td style="padding-left:240px"><p><span class="orange-bold">Ipit num ip</span></p></td></tr>\r\n				<tr>\r\n				  <td style="padding-left:190px">Esto ent feugiat</td>\r\n				</tr>\r\n				<tr><td style="padding-left:150px">Magna facillu ptating</td></tr>\r\n				<tr><td style="padding-left:125px">Vel eumsand rerat</td></tr>\r\n				<tr><td style="padding-left:100px">Faccummy nim do od tio</td></tr>\r\n				<tr><td style="padding-left:80px">Ex et, qui estrud eu faccummy</td></tr>\r\n				<tr><td style="padding-left:60px">Ipisseq uissit lor secte</td></tr>\r\n				</table>\r\n				</td>\r\n				</tr>\r\n				\r\n				\r\n				</table> \r\n				<!--- fin tableau droit pour rouages--->\r\n				</td>\r\n				\r\n			  </tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(26, 'TemplateTitleImage', 'TemplateTitleImageDescription', 'image.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent table_actions table_actions_rows"><tr>\r\n				<td>\r\n			\r\n				\r\n					   <!-- tableau image et sa legende -->\r\n					   <table class="image-and-legend"><tr><td><img src="{IMG_DIR}templates/placeholder-image.jpg" /></td></tr><tr><td class="legendingrey"><p>Aliquis er in erostio dolore dolore et aliquat. Duip eugiate consed magna</p>\r\n					     </td></tr>\r\n						</table>\r\n						<!-- fin tableau image et sa legende -->\r\n				</td>\r\n						 \r\n                <td >\r\n						<h2>Essi bla </h2>\r\n						<p>Essi bla accum zzrit aliquis er in erostio dolore doloreet aliquat. Duip eugiate consed magna faci blam.</span> <span class="item-desc">Essi bla accum zzrit aliquis er in erostio dolore doloreet aliquat. Duip eugiate consed magna faci blam.</p>\r\n					   <p> Duip eugiate consed magna faci blam. Essi bla accum zzrit ali.</p>\r\n					   <p>Consed magna faci blam.</p>\r\n					   <p>Essi bla accum zzrit aliquis er in erostio dolore doloreet aliquat. Duip eugiate consed magna faci blam. Essi bla accum zzrit aliquis er in erostio dolore doloreet aliquat. Duip eugiate consed magna faci blam.</p>\r\n                                      \r\n				</td>\r\n                </tr>\r\n			  </table>\r\n			  <!-- fin du tableau gris contenant le tableau texte et le tableau image -->\r\n\r\n				</td>\r\n				\r\n			  </tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(27, 'TemplateTitlePostIt', 'TemplateTitlePostItDescription', 'postit.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr>\r\n				<td>\r\n			\r\n				<!-- tableau  post-it -->\r\n				<table class="post-it-table">\r\n				<tr>\r\n				<td class="PI" >\r\n				  <!-- tableau enchesse pour le coin droit -->\r\n				  <table class="PI-corner">\r\n				    <tr><td>\r\n				  <h2>Vendre do dolorpe</h2>\r\n				  <p>Ulla conse feugait lor sustrud minit prat. Esto odolorpero con vendipsusto eum adit wisit, si erilit ad magna.			    </p>\r\n				\r\n				  <p>Isse magnismolore dolore con henim nummy nulla ad magna facin vel dolore dolese endre conse dolesse del euis nis dunt in henim quamcommy nim dolore veliquat, verit lum nonsequatuer ipis nostiscinibh ea cortio odo dip ea corperat in hendipisim ing eliqui.</p>\r\n				 \r\n		\r\n				  \r\n				  </td></tr></table>\r\n				  <!-- fin tableau enchesse -->\r\n				</td>\r\n				</tr>\r\n				</table>\r\n				<!-- fin tableau post-it-->\r\n			  </td>\r\n				\r\n				<td class="imagecenter">\r\n				<img src="{IMG_DIR}templates/instructor-writing.jpg" alt="" />\r\n				\r\n			  </td>\r\n				</tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(28, 'TemplateTitlePyramid', 'TemplateTitlePyramidDescription', 'pyramid.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr>\r\n				<td>\r\n			\r\n			     <table class="pyramide-background table_actions table_actions_rows">				\r\n			   \r\n				 <tr><td style="font-size:0.8em; padding-top:80px;">ad lorem ipsum</td></tr>\r\n				 <tr><td style="font-size:0.9em">ad lorem ipsum</td></tr>\r\n				 <tr><td style="font-size:1em">ad lorem ipsum</td></tr>\r\n				 <tr><td style="font-size:1.1em">ad lorem ipsum</td></tr>\r\n				 <tr><td style="font-size:1.2em">ad lorem ipsum</td></tr>\r\n				 <tr><td style="font-size:1.3em">ad lorem ipsum</td></tr>\r\n				 <tr><td style="font-size:1.4em">ad lorem ipsum</td></tr>\r\n				 <tr><td style="font-size:1.5em">ad lorem ipsum</td></tr>\r\n				\r\n			\r\n				</table>\r\n\r\n				\r\n				</td>\r\n				\r\n				<td>\r\n				<table class="perso-and-buble">\r\n				<tr><td id="buble-talk"><p>\r\n				Riure con et vulluptat, veniam, consequamet, commolor iliquat dunt iureraessi.\r\nUptat. Ectem doloreet alis nonsed magna feuisim et at. Rit vullaore vullan.</p></td>\r\n				</tr>\r\n				<tr><td><img src="{IMG_DIR}templates/instructor-coming.jpg" alt="" /></td>\r\n				</tr>\r\n				</table> \r\n				<!--- fin tableau droit pour lillustration et la bulle --->\r\n				</td>\r\n				\r\n				</tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(29, 'TemplateTitleResult', 'TemplateTitleResultDescription', 'result.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent">\r\n				<tr><td>\r\n				<!-- left table buble + perso -->\r\n				<table class="perso-and-buble" style="width:250px">\r\n				<tr>\r\n				  <td id="buble-talk"><p>si erilit ad magna ad dolorercing ea consequis dolorpe raessequat.</p>\r\n				    </td>\r\n				  \r\n				</tr>\r\n				<tr>\r\n				<td><img src="{IMG_DIR}templates/instructor-faq.jpg" /></td>\r\n				</tr>\r\n				</table>\r\n				<!-- end left table -->\r\n				</td>\r\n				<td>\r\n				<table class="result">\r\n                             \r\n                             \r\n                            \r\n                             <tr>\r\n                               <td class="add1"><h2>Od eliquis at erostrud</h2>\r\n                                 <p>Duisl iureetue mod te molobor perilisl do con erit at pratue</p>\r\n                               </td>\r\n								   <td class="add2"><h2>Sis nonsed etumsandre</h2><p>Eugait loreet praesse min vulpute tat</p>\r\n                                   </td>\r\n								   \r\n                             </tr>\r\n							 <tr>\r\n                               <td class="res" colspan="2"><img src="{IMG_DIR}templates/egal.png" />\r\n                                   </td>						   \r\n								   \r\n                             </tr>\r\n							 <tr>\r\n                               <td class="res" colspan="2"><h2>Od eliquis erostrud</h2>\r\n							   <p>Duisl iureetue mod te molobor perilisl do con erit at pratue.</p><p>Nonsequ ipsusci esequam zzrillan eu faccum veliquamcor sisi tet ad molesti sismodolore facidunt niscinibh ese min et alisl utpat.</p>\r\n                                   </td>						   \r\n								   \r\n                             </tr>\r\n               </table>\r\n                         \r\n\r\n				</td>\r\n				</tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(30, 'TemplateTitleTextFourX', 'TemplateTitleTextFourXDescription', 'textxfour.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent">\r\n				<tr>\r\n				<td valign="top">\r\n			\r\n				<!-- tableau gauche pour les 4 items -->\r\n				<table class="quatreitems table_actions table_actions_rows" cellspacing="10">\r\n				<tr>\r\n				  <td class="rond" style="background-color:#e6e5e4; background-image:url(design/degrade3.jpg)"><p>si erilit ad magna ad dolorercing ea consequis dolorpe raessequat. Si erilit ad magna ad dolorercing.</p>\r\n				    <p>si erilit ad magna ad </p>\r\n				    </td>\r\n					<td class="rond" style="background-color:#d3d2d1; background-image:url(design/degrade2.jpg)"><p>Deliquisim vero ex enibh ectem il in ullummodolor at.<br />\r\nRatem ipis at alit irit ipit wis nim in veliscipit</p>\r\n				    </td>				  \r\n				</tr>\r\n				<tr>\r\n					<td class="rond" style="background-color:#d3d2d1; background-image:url(design/degrade2.jpg)"><p>Ulla conse feugait lor sustrud minit prat. Esto odolorpero   con vendipsusto eum adit wisit, si erilit ad magna.</p>\r\n				    </td>\r\n					<td class="rond" style="background-color:#e8e1dc; background-image:url(design/degrade1.jpg)"><p>Essi bla accum zzrit aliquis er in erostio dolore   doloreet aliquat. Duip eugiate consed magna faci blam.</p>\r\n				    </td>	\r\n				</tr>\r\n				</table>\r\n				<!-- fin tableau gauche pour les 4 items -->\r\n				</td>\r\n				\r\n				<td class="imagecenter">\r\n				<h2>Ad lorem ipsum</h2>\r\n				<p>Riure con et vulluptat, veniam, consequamet, commolor iliquat dunt iureraessi.\r\nUptat. Ectem doloreet alis nonsed magna feuisim et at. Rit vullaore vullan ut nulla commy nos num ver sim ver</p>\r\n				 <img src="{IMG_DIR}templates/carrefour.jpg" alt="" />\r\n				</td>\r\n				\r\n				</tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(31, 'TemplateTitleTitle', 'TemplateTitleTitleDescription', 'title.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr><td>\r\n	    \r\n				\r\n				<!-- tableau gris container -->\r\n				<table class="greyframetitle">\r\n				<tr><td>\r\n					 <!-- tableau blanc container -->\r\n					 <table class="whiteframetitle">\r\n                       <tr>\r\n					   <td><table><tr><td><img src="{IMG_DIR}templates/instructor-coming.jpg" /></td></tr></table></td>\r\n                       <td><h1 class="orange">Ad Lorem Ipsum</h1><h2 class="orange">Essi bla accum zzrit aliquis</h2></td>\r\n                       </tr>\r\n					   </table>\r\n					   </td></tr>\r\n		              </table>\r\n				     <!-- fin du tableau blanc container -->\r\n				</td>\r\n				</tr>\r\n				</table><!-- fin du tableau gris container -->\r\n	  		</td>\r\n			</tr>\r\n                         \r\n\r\n				</td>\r\n				</tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(38, 'TemplateTitleSound', 'TemplateTitleSoundDescription', 'sound.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr>\r\n				<td>\r\n			\r\n				<!-- tableau gauche pour bulle + perso -->\r\n				<table class="perso-and-buble">\r\n				<tr>\r\n				  <td id="buble-talk-ud"><p>si erilit ad magna ad dolorercing ea consequis dolorpe raessequat. Si erilit ad magna ad dolorercing.</p>\r\n				    </td>\r\n				  \r\n				</tr>\r\n				<tr>\r\n				<td><img src="{IMG_DIR}templates/instructor-speaking.jpg" alt="" /></td>\r\n				</tr>\r\n				\r\n				</table>\r\n				<!-- fin tableau gauche -->\r\n				</td>\r\n				\r\n				<td>\r\n				\r\n				\r\n				     <!-- tableau gris container -->\r\n				     <table class="sound table_actions table_actions_rows" >\r\n                        <tr><td class="readsound"><img src="{IMG_DIR}templates/placeholder-son.jpg" /></td></tr>                           \r\n                       <tr><td class="commentsound"><h2>Isse magnismolore dolore con</h2>							   \r\n                                   <p>Essi bla accum zzrit aliquis er in erostio dolore doloreet aliquat. Duip eugiate consed magna faci blam.</p>\r\n                                   <p>Ulla conse feugait lor sustrud minit prat. Esto odolorpero con vendipsusto eum adit wisit, si erilit ad magna.</p>\r\n								   <p>Riure con et vulluptat, veniam, consequamet, commolor iliquat dunt iureraessi.\r\nUptat. Ectem doloreet alis nonsed magna feuisim et at. Rit vullaore vullan ut nulla commy nos num ver sim ver.</p></td></tr>\r\n					   \r\n                      </table>\r\n				     \r\n				</td>\r\n				\r\n			  </tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(39, 'TemplateTitleSimpleBase', 'TemplateTitleSimpleBaseDescription', 'simplebase.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr><td>\r\n				<!-- left table buble + perso -->\r\n				<table class="perso-and-buble">\r\n				<tr>\r\n				  <td id="buble-talk"><p>si erilit ad magna ad dolorercing ea consequis dolorpe raessequat. Si erilit ad magna ad dolorercing.</p>\r\n				    </td>\r\n				  \r\n				</tr>\r\n				<tr>\r\n				<td><img src="{IMG_DIR}templates/instructor-two.jpg" alt="" /></td>\r\n				</tr>\r\n				</table>\r\n				<!-- end left table -->\r\n				</td>\r\n				\r\n				<td>\r\n                                <h2 style="padding-left:27px">Essi bla </h2>\r\n				<table class="base table_actions table_actions_rows">\r\n                             \r\n                             <tr>\r\n							 <td>\r\n				\r\n							  <h3>Endrem zzrit dolorem in velit volor sustrud</h3>\r\n                                   <p>Essi bla accum zzrit aliquis er in erostio dolore doloreet aliquat. Duip eugiate consed magna faci blam.</p>\r\n								   <h4>Vel delessis nos nullandre</h4>\r\n								   <p>Re tat lutem nullaor ercing eugait loreet praesse min vulpute tat. Luptate tat aci enim quiscidui bla feuisis cipissecte cons non heniat lumsan vullut ut.</p>\r\n								   <h4>Velenis dipis dolor si</h4>\r\n								   <p>Aliquatem volore dolor sustio eugiat la cons nibh exercing ea facidui scipit iustie corem dolore erit ad magnibh et, consequis dit atum zzrilit landrerostin.</p>\r\n</tr>\r\n</td>\r\n<tr>\r\n<td>\r\n								   <h3>Etumsandre euguer adigna</h3>\r\n<p>Lore ming ex endre euis nullaor adit voloborero od eliquis erostrud dignit luptat. Ex ea facilismod tet acincip sustrud modiam, cons nonum init, sis nonsed etumsandre euguer adigna feuguer cidunt iuscilis num augait lore consequisi.</p></td>\r\n                             </tr>\r\n                             \r\n               </table>\r\n                         \r\n\r\n				</td>\r\n				</tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course -->\r\n</body>'),
(32, 'TemplateTitleVideo320', 'TemplateTitleVideo320Description', 'video320.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr>\r\n				<td>\r\n			\r\n				\r\n				\r\n				     <!-- tableau gris contenant le tableau video et le tableau texte -->\r\n				     \r\n					   <!-- tableau video et sa legende -->\r\n					   <table class="videoplace"><tr><td><img src="{IMG_DIR}templates/little-placeholder-video.jpg" /></td></tr><tr><td class="undervideo"><p>Aliquis er in erostio dolore dolore et aliquat. Duip eugiate consed magna</p>\r\n					     </td></tr>\r\n						</table>\r\n						<!-- fin tableau video et sa legende -->\r\n						 </td>\r\n						 \r\n                         <td>\r\n						 <!-- tableau pour le texte a droite -->\r\n						 <table class="commentvideo">\r\n                          \r\n                           <tr>\r\n                             <td><h2 class="orange">Ad lorem ipsum</h2>\r\n							     <table><tr><td><p>Aliquis er in erostio dolore dolore et aliquat. Duip eugiate consed magna.</p>\r\n							           <p>Si tatet alit nullaor sum aut prat num illa facip etum quat verilit la faci te tat. Oborem qui tat diat. Ut alit lor inim volobore dit, quipit venissi bla ad dolor adit augiat. Pit landit iriliquisi te cons et in ut eu feuguerci blandipit alis dit atueriure magna faccum velenim velit wis eu feugait et adipis nis nullaor perosto dolorem ipit iurerci eraesto.</p></td><td><img src="{IMG_DIR}templates/instructor-projection.jpg" /></td></tr></table>\r\n                           \r\n                             </td>\r\n                           </tr>\r\n                         </table>\r\n                           <!-- fin du tableau pour le texte a droite -->                         \r\n					\r\n\r\n				</td>\r\n				\r\n			  </tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(33, 'TemplateTitleVideo480', 'TemplateTitleVideo480Description', 'video480.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr>\r\n				<td>\r\n			\r\n				\r\n				\r\n				     <!-- tableau gris contenant le tableau video et le tableau texte -->\r\n				     \r\n					   <!-- tableau video et sa l?gende -->\r\n					   <table class="videoplace480"><tr><td><img src="{IMG_DIR}templates/placeholder-video2.jpg" /></td></tr><tr><td class="undervideo"><p>Aliquis er in erostio dolore dolore et aliquat. Duip eugiate consed magna.</p>\r\n					     </td></tr>\r\n						</table>\r\n						<!-- fin tableau video et sa legende -->\r\n						 </td>\r\n						 \r\n                         <td>\r\n						 <!-- tableau pour le texte a droite -->\r\n						 <table class="commentvideo">\r\n                          \r\n                           <tr>\r\n                             <td><h2 class="orange">Ad lorem ipsum</h2>\r\n							     <table><tr><td><p>Aliquis er in erostio dolore dolore et aliquat. Duip eugiate consed magna.</p>\r\n							           <p>Si tatet alit nullaor sum aut prat num illa facip etum quat verilit la faci te tat. Oborem qui tat diat. Ut alit lor inim volobore dit, quipit venissi bla ad dolor adit augiat. Pit landit iriliquisi te cons et in ut eu feuguerci.</p><p>Ommy nostionsed exeros esto eliqui bla facipsumsan volenit velestisl diat.</p></td><td><img src="{IMG_DIR}templates/instructor-projection.jpg" /></td></tr></table>\r\n                           \r\n                             </td>\r\n                           </tr>\r\n                         </table>\r\n                           <!-- fin du tableau pour le texte a droite -->                         \r\n					\r\n\r\n				</td>\r\n				\r\n			  </tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(34, 'TemplateTitleTrueFalse', 'TemplateTitleTrueFalseDescription', 'truefalse.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent">\r\n				<tr>\r\n			    <td class="imagecenter"><img src="{IMG_DIR}templates/instructor-truefalse.jpg" /></td>				\r\n				<td>\r\n				   <!-- tableau mis en page -->\r\n				   <table class="tabletruefalse table_actions table_actions_rows">\r\n				   <tr><th>Re tat lutem nullaor ercing</th><th>Cipissecte</th><th>Od eliquis</th>\r\n				   <tr>\r\n				   <td class="theQ"><p>Luptate tat aci enim quiscidui bla feuisis cipissecte cons non heniat lumsan</p></td><td class="TF"><img src="{IMG_DIR}templates/icone-V-QUIZ.png" /></td><td class="TF"></td>\r\n				   </tr>\r\n				   <tr>\r\n				   <td class="theQ"><p>Lore ming ex endre euis nullaor adit voloborero od eliquis erostrud dignit luptat</p></td><td class="TF"></td><td class="TF"><img src="{IMG_DIR}templates/icone-V-QUIZ.png" /></td>\r\n				   </tr>\r\n				   <tr>\r\n				   <td class="theQ"><p>Faccum veliquamcor sisi tet ad molesti sismodolore facidunt niscinibh ese min et alisl utpat</p></td><td class="TF"><img src="{IMG_DIR}templates/icone-V-QUIZ.png" /></td><td class="TF"><img src="{IMG_DIR}templates/icone-V-QUIZ.png" /></td>\r\n				   </tr>\r\n				   <tr>\r\n				   <td class="theQ"><p>Re tat lutem nullaor ercing eugait loreet praesse min vulpute ta</p></td><td class="TF"><img src="{IMG_DIR}templates/icone-V-QUIZ.png" /></td><td class="TF"></td>\r\n				   </tr>\r\n				   <tr>\r\n				   <td class="theQ"><p>Tem nis endions equat. Lestisl ut prat, sum zzrit, consequat</p></td><td class="TF"><img src="{IMG_DIR}templates/icone-V-QUIZ.png" /></td><td class="TF"><img src="{IMG_DIR}templates/icone-V-QUIZ.png" /></td\r\n				   </tr>			   \r\n				   </table>\r\n				   <!-- fin tableau mis en page -->				\r\n			  </td>\r\n			</tr>\r\n			</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n		  </td>\r\n		  </tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(35, 'TemplateTitleTable', 'TemplateTitleTableDescription', 'table2.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr><td>\r\n				 <!-- tableau mis en page -->\r\n				   <table class="the-tableau table_actions table_actions_rows">\r\n				   <tr class="premiere">\r\n				   <td>ad lorem ipsum</td><td>ad lorem ipsum</td><td>ad lorem ipsum</td><td>ad lorem ipsum</td>\r\n				   </tr>\r\n				   <tr class="ligne">\r\n				   <td>ad lorem ipsum</td><td>ad lorem ipsum</td><td>ad lorem ipsum</td><td>ad lorem ipsum</td>\r\n				   </tr>\r\n				   <tr class="ligne">\r\n				   <td>ad lorem ipsum</td><td>ad lorem ipsum</td><td>ad lorem ipsum</td><td>ad lorem ipsum</td>\r\n				   </tr>\r\n				   <tr class="ligne">\r\n				   <td>ad lorem ipsum</td><td>ad lorem ipsum</td><td>ad lorem ipsum</td><td>ad lorem ipsum</td>\r\n				   </tr>\r\n				   <tr class="ligne">\r\n				   <td>ad lorem ipsum</td><td>ad lorem ipsum</td><td>ad lorem ipsum</td><td>ad lorem ipsum</td>\r\n				   </tr>\r\n				   </table>\r\n				   <!-- fin tableau mis en page -->\r\n\r\n				</td>\r\n				</tr>\r\n				\r\n				<tr><td>\r\n				<table class="comments"> \r\n				<tr>\r\n				<td>\r\n			\r\n				<!-- tableau post-it -->\r\n				<table class="post-it-table">\r\n				<tr>\r\n				<td class="PI">\r\n				  <!-- tableau enchesse pour le bord corne droit -->\r\n				  <table class="PI-corner">\r\n				  <tr><td>\r\n				  <h2>LOREM IPSUM </h2>\r\n				  <p>Ulla conse feugait lor sustrud minit prat. Esto odolorpero con vendipsusto eum adit wisit, si erilit ad magna.			    </p>\r\n				  </td></tr></table>\r\n				  <!-- fin tableau enchenchesse pour le bord corne droit -->\r\n				</td>\r\n				</tr>\r\n				</table>\r\n				<!-- fin tableau post-it -->\r\n			   </td>\r\n				\r\n				<td >\r\n				<img src="{IMG_DIR}templates/instructor-board.jpg" alt="" /></td></tr>\r\n				</td>				\r\n		  	   </tr>	\r\n			   </table>\r\n			\r\n			   </td></tr></table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>');
INSERT INTO `system_template` VALUES
(40, 'TemplateTitleProcess', 'TemplateTitleProcessDescription', 'process.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent">\r\n				<tr><td>\r\n						<table style="background-color:#dcdcde; margin:0px 12px" class="table_actions table_actions_columns">\r\n				  		<tr height="150"  >\r\n						<td class="first-item-process">Lor sustrud minit prat</td>\r\n						<td class="cell-item-process">Esto odolorpero con vendipsusto</td>\r\n						<td class="cell-item-process">Vendipsusto eum adit wisit, si erilit ad magna</td>\r\n						<td class="cell-item-process">Si erilit ad magna.</td>\r\n						<td class="cell-item-process">Si erilit ad magna.</td>\r\n						<td width="40" style="background-image:url(design/process-end.jpg); background-repeat:no-repeat; background-position:center right">&nbsp;</td>\r\n				  		</tr>\r\n				       </table>\r\n				</td></tr>\r\n				<tr><td><table class="comments">\r\n                  <tr>\r\n                    <td><!-- tableau post-it -->\r\n                        <table class="post-it-table">\r\n                          <tr>\r\n                            <td class="PI"><!-- tableau enchesse pour le bord corne droit -->\r\n                                <table class="PI-corner">\r\n                                  <tr>\r\n                                    <td><h2>LOREM IPSUM </h2>\r\n                                        <p>Ulla conse feugait lor sustrud minit prat. Esto odolorpero con vendipsusto eum adit wisit, si erilit ad magna.</p>\r\n                                      <p>Riure con et vulluptat, veniam, consequamet, commolor iliquat dunt iureraessi.\r\n                                        Uptat. Ectem doloreet alis nonsed magna feuisim et at. Rit vullaore vullan ut nulla commy nos num ver sim ver.</p></td>\r\n                                  </tr>\r\n                                </table>\r\n                              <!-- fin tableau enchesse pour le bord corne droit -->                            </td>\r\n                          </tr>\r\n                        </table>\r\n                      <!-- fin tableau post-it -->                    \r\n					</td>\r\n                    <td class="imagecenter"><img src="{IMG_DIR}templates/instructor-analysis.jpg" /> </td>\r\n                  </tr>\r\n                </table></td>\r\n				</tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(41, 'TemplateTitlePhases', 'TemplateTitlePhasesDescription', 'phases.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent">\r\n				<tr><td>\r\n				<!-- left table buble + perso -->\r\n				<table class="perso-and-buble" style="width:250px">\r\n				<tr>\r\n				  <td id="buble-talk"><p>si erilit ad magna ad dolorercing ea consequis dolorpe raessequat. Si erilit ad magna ad dolorercing.</p>\r\n				    </td>\r\n				  \r\n				</tr>\r\n				<tr>\r\n				<td><img src="{IMG_DIR}templates/instructor-two.jpg" alt="" /></td>\r\n				</tr>\r\n				</table>\r\n				<!-- end left table -->\r\n				</td>\r\n				<td>\r\n				<table class="phases table_actions table_actions_columns">\r\n                             \r\n                             <tr>\r\n                               <td class="phase"><h2>CONS NOMUM</h2>\r\n                                   </td>\r\n								   <td class="phase"><h2>ESSI BLA</h2>\r\n                                   </td>\r\n								   <td class="phase"><h2>SUM IN HENIM</h2>\r\n                                   </td>\r\n                             </tr>\r\n                            \r\n                             <tr>\r\n                               <td class="phaseresult"><h2>Od eliquis erostrud</h2>\r\n							   <p>Duisl iureetue mod te molobor perilisl do con erit at pratue</p>\r\n                                   </td>\r\n								   <td class="phaseresult"><h2>Sis nonsed etumsandre</h2><p>Eugait loreet praesse min vulpute tat</p>\r\n                                   </td>\r\n								   <td class="phaseresult"><h2>Dionsed te commy</h2><p>Luptate tat aci enim quiscidui bla feuisis cipissecte cons non heniat lumsan</p>\r\n                                   </td>\r\n                             </tr>\r\n               </table>\r\n                         \r\n\r\n				</td>\r\n				</tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(42, 'TemplateTitleMethodology', 'TemplateTitleMethodologyDescription', 'methodology.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent">\r\n				\r\n				<tr>						\r\n				<td>\r\n				<table class="methodology table_actions table_actions_columns">\r\n                             \r\n                             <tr>\r\n                               <td class="methofirst">\r\n							       <ul>\r\n								   <li>Od eliquis erostrud</li> <li>Re tat lutem nullaor ercing eugait loreet</li> <li>Corem dolore erit ad magnibh et, vel ute tatum ad te ea ad modolor </li></td>\r\n								<td class="methoarrow">\r\n								<img src="{IMG_DIR}templates/little-placeholder-image150.jpg" />\r\n								<h2>Veliquamcor sisi</h2>\r\n								  <p>Erostio dolore doloreet aliquat.</p>\r\n								  <p>Re tat lutem nullaor ercing eugait loreet.</p></td>\r\n								<td class="methoarrow">\r\n								<img src="{IMG_DIR}templates/little-placeholder-image150.jpg" />\r\n								<h2>Sis etumsandre</h2>\r\n								  <p>Duip eugiate consed magna faci blam.</p>\r\n								  <p>Nonsequ ipsusci esequam zzrillan eu.</p></td>\r\n								  <td class="methoarrow">\r\n								  <img src="{IMG_DIR}templates/little-placeholder-image150.jpg" />\r\n								  <h2>Essi bla </h2>\r\n								  <p>Duip eugiate consed magna faci blam.</p>\r\n								  <p>Ut ad enissequat wismolum augait.</p></td>\r\n                             </tr>\r\n                             \r\n							 \r\n                            \r\n               </table>                      \r\n\r\n				</td>\r\n				</tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n				<tr><td><table class="cellscontent"><tr><td><img src="{IMG_DIR}templates/instructor-coming.jpg"/></td><td><h2>Ea faciduis nullummy</h2><p>Essi bla Ut ad enissequat wismolum augait essenibh ea faciduis nullummy nulla alis nos nullam num dolum adigna faccum ilisl ex er sim vercipi scidunt la facinim deliqui scidunt alit praestie dignisit inibh eriustrud eraestinit nibh ectet essim duipissecte dit erit eummodo lendre vel er illa faccum irillaor </p></td></tr></table></td></tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(43, 'TemplateTitleItemsList', 'TemplateTitleItemsListDescription', 'itemslist.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr><td>\r\n				<!-- left table buble + perso -->\r\n				<table class="perso-and-buble">\r\n				<tr>\r\n				  <td id="buble-talk"><p>si erilit ad magna ad dolorercing ea consequis dolorpe raessequat. Si erilit ad magna ad dolorercing.</p>\r\n				    </td>\r\n				  \r\n				</tr>\r\n				<tr>\r\n				<td><img src="{IMG_DIR}templates/instructor-two.jpg" alt="" /></td>\r\n				</tr>\r\n				</table>\r\n				<!-- end left table -->\r\n				</td>\r\n				\r\n				<td>\r\n				<table class="items table_actions table_actions_rows">\r\n                             \r\n                             <tr>\r\n                               <td class="arrow"><h2>Essi bla </h2>\r\n                                   <p>Essi bla accum zzrit aliquis er in erostio dolore doloreet aliquat. Duip eugiate consed magna faci blam.</p></td>\r\n                             </tr>\r\n                             <tr>\r\n                               <td class="arrow"><h2>Deliquissim vero </h2>\r\n                                   <p>Deliquisim vero ex enibh ectem il in ullummodolor at.<br />\r\n                                     Ratem ipis at alit irit ipit wis nim in veliscipit </p></td>\r\n                             </tr>\r\n                             <tr>\r\n                               <td class="arrow"><h2>Ulla conse </h2>\r\n                                   <p>Ulla conse feugait lor sustrud minit prat. Esto odolorpero con vendipsusto eum adit wisit, si erilit ad magna.</p></td>\r\n                             </tr>\r\n               </table>\r\n                         \r\n\r\n				</td>\r\n				</tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(44, 'TemplateTitleK', 'TemplateTitleKDescription', 'k.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr>\r\n			    <td class="illusleft"><img src="{IMG_DIR}templates/instructor-analysis.jpg" /></td>				\r\n				<td>\r\n				   <!-- tableau mis en page -->\r\n				   <table class="the-tableau table_actions table_actions_rows" id="the-tableau-K">\r\n				   <tr class="ligne-K">\r\n				   <td class="theK"><h3>ad lorem ipsum</h3></td><td class="expl">\r\n				   <h4>Ci ex et landipit nosto dolor sectet vel il dolore molore duisisit, quis exer</h4>\r\n				   <ul>\r\n				     <li>Velestrud mod dionsequate dolor.</li>\r\n				     <li>Iril ipisse magna faccum ex eugiatum dolesequip.</li></ul>\r\n				   \r\n				   </td>\r\n				   </tr>\r\n				   <tr class="ligne-K">\r\n				   <td class="theK"><h3>ad lorem ipsum</h3></td><td class="expl">\r\n				   <h4>Onsequi smodolore velit ullan eugiam enim do od modolorem vel ut aliquis</h4>\r\n				   <p>Deliquisim vero ex enibh ectem il in ullummodolor at.</p></td>\r\n				   </tr>\r\n				   <tr class="ligne-K">\r\n				   <td class="theK"><h3>ad lorem ipsum</h3></td><td class="expl">\r\n				   <h4>Magna corper sum iriurercipit lortisisi</h4>\r\n				  <ul>\r\n				  <li>Er sum vulla am diamet nisim irit, quisci bla</li>\r\n				  <li>Consequat nis elenibh eugiam zzrit utet do ero eum.</li>\r\n				  </ul>\r\n				  </td>\r\n				   </tr>\r\n				  \r\n				   \r\n				   </table>\r\n				   <!-- fin tableau mis en page -->\r\n				\r\n			  </td>\r\n			</tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(45, 'TemplateTitleMap', 'TemplateTitleMapDescription', 'map.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<!-- white table for the course -->\r\n		<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr>\r\n				<td>\r\n			\r\n				<!-- tableau gauche pour bulle + perso -->\r\n				<table class="perso-and-buble">\r\n				<tr>\r\n				  <td id="buble-talk"><p>si erilit ad magna ad dolorercing ea consequis dolorpe raessequat. Si erilit ad magna ad dolorercing.</p>\r\n				    </td>\r\n				  \r\n				</tr>\r\n				<tr>\r\n				<td><img src="{IMG_DIR}templates/instructor-path.jpg" alt="" /></td>\r\n				</tr>\r\n				\r\n				</table>\r\n				<!-- fin tableau gauche -->\r\n				</td>\r\n				\r\n				<td>\r\n				<!--- tableau droit pour la map --->\r\n				\r\n				     <table class="map table_actions table_actions_rows">\r\n                             <tr>\r\n                               <td class="part"><h2>Essi bla </h2>\r\n							   <h3>Eer in erostio dolore</h3>\r\n                                   <h4>Essi bla accum zzrit aliquis</h4><ul><li>Er in erostio dolore doloreet aliquat</li><li>Duip eugiate consed magna faci blam</li></ul>\r\n								   \r\n								<h3>Re eui eu feuipisim autem</h3>\r\n                                   <h4>zzrit dunt alisisl</h4><ul><li>Re eui eu feuipisim autem vendipsum </li><li>Nostie dolorti nciliqu ipiscil utat</li><li>Quisse dipit ver incillam eum iusci </li></ul>\r\n								</td>\r\n                             </tr>\r\n                             <tr>\r\n                               <td class="part"><h2>Esent irilisi blaor sisi</h2>\r\n                                 \r\n								   \r\n								<h3>Faccummy nim do od tio esse</h3>\r\n                                   <h4>Ut vero conullam</h4><ul><li>Ex et, qui estrud eu faccummy nostie dolorti nciliqu ipiscil</li><li>Em vel dolorer ciliqui smolor sequat</li></ul></td>\r\n                             </tr>\r\n				</table> \r\n				<!--- fin tableau droit pour la map"--->\r\n				</td>\r\n				\r\n			  </tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>'),
(46, 'TemplateTitleTextArrow', 'TemplateTitleTextArrowDescription', 'textarrowthree.gif', '<head>\r\n{CSS}\r\n</head>\r\n\r\n<body>\r\n<table class="white"> \r\n		<tr><td><h1> LOREM IPSUM</h1></td></tr>\r\n		<tr>\r\n				<td>\r\n				<!-- table for the cells of content -->\r\n			    <table class="cellscontent"><tr>\r\n				<td>\r\n			   <!-- tableau fleche1 -->\r\n			   <table class="grey-arrow">				\r\n			   <tr><td>\r\n			   <h2>Ad ming erit</h2>\r\n			   <p>Consequat nis elenibh eugiam zzrit utet do ero eum iustrud dit alisisisit ad ming erit nim iure doloreetue doloreet nim dipit vulput dolorem venibh etum.</p>\r\n			   </td></tr>\r\n			   <tr><td class="fleche-grise"></td></tr>\r\n			  \r\n				</table>\r\n				<!-- fin tableau fleche1 -->\r\n				 <!-- tableau fleche2 -->\r\n			   <table class="grey-arrow">				\r\n			   <tr><td>\r\n			   <h2>Aut vel ex essequam veriustrud</h2>\r\n			     <p>Iril ipisse magna faccum ex eugiatum dolesequip essisit aut vel ex essequam veriustrud tatie mincip elisisl incip eliquip sustrud mincip ea feugue feuis. </p>\r\n			</td></tr>\r\n			   <tr>\r\n			     <td class="fleche-grise"></td>\r\n			   </tr>\r\n			  \r\n				</table>\r\n				<!-- fin tableau fleche2 -->\r\n				\r\n				 <!-- tableau 3 -->\r\n			   <table class="dark-grey">				\r\n			   <tr><td>\r\n			   <h2>Magna corper sum iriurercipit lortisisi</h2>\r\n			  \r\n<p>Si tatet alit nullaor sum aut prat num illa facip etum quat verilit la faci te tat. Oborem qui tat diat.</p>\r\n			 \r\n			   </td></tr>\r\n			  \r\n			  \r\n				</table>\r\n				<!-- fin tableau 3 -->\r\n				</td>\r\n				\r\n				<td>\r\n				<!--- tableau droit pour lillustration et la bulle--->\r\n				<table class="perso-and-buble">\r\n				<tr><td id="buble-talk">\r\n				<p>Deliquat ute faccummy nullums andionsed et wisci bla consequis eraestrud magna adipsus cidunt ullam, consed erci blandipit landre.</p></td>\r\n				</tr>\r\n				<tr><td><img src="{IMG_DIR}templates/instructor-3fingers.jpg" alt="" /></td>\r\n				</tr>\r\n				</table> \r\n				<!--- fin tableau droit pour lillustration et la bulle --->\r\n				</td>\r\n				\r\n		  </tr>\r\n				</table>\r\n				<!-- end table for the cells of content -->\r\n				\r\n				</td>\r\n				</tr>\r\n								\r\n		  </table><!-- end white table for the course --></body>');

-- --------------------------------------------------------

--
-- Table structure for table `sys_announcement`
--

CREATE TABLE `sys_announcement` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date_start` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_end` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `visible_teacher` tinyint(4) NOT NULL DEFAULT '0',
  `visible_student` tinyint(4) NOT NULL DEFAULT '0',
  `visible_guest` tinyint(4) NOT NULL DEFAULT '0',
  `title` varchar(250) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `lang` varchar(70) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sys_calendar`
--

CREATE TABLE `sys_calendar` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `content` text,
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tag`
--

CREATE TABLE `tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tag` varchar(255) NOT NULL,
  `field_id` int(11) NOT NULL,
  `count` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `templates`
--

CREATE TABLE `templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `description` varchar(250) NOT NULL,
  `course_code` varchar(40) NOT NULL,
  `user_id` int(11) NOT NULL,
  `ref_doc` int(11) NOT NULL,
  `image` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `topic`
--

CREATE TABLE `topic` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `topic` varchar(255) DEFAULT NULL,
  `language` char(50) NOT NULL DEFAULT 'English',
  `visible` char(1) NOT NULL DEFAULT '0',
  `catalogue_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_c_browsers`
--

CREATE TABLE `track_c_browsers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `browser` varchar(255) NOT NULL DEFAULT '',
  `counter` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_c_countries`
--

CREATE TABLE `track_c_countries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(40) NOT NULL DEFAULT '',
  `country` varchar(50) NOT NULL DEFAULT '',
  `counter` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=265 ;

--
-- Dumping data for table `track_c_countries`
--

INSERT INTO `track_c_countries` VALUES
(1, 'ac', 'Ascension (ile)', 0),
(2, 'ad', 'Andorre', 0),
(3, 'ae', 'Emirats  Arabes Unis', 0),
(4, 'af', 'Afghanistan', 0),
(5, 'ag', 'Antigua et Barbuda', 0),
(6, 'ai', 'Anguilla', 0),
(7, 'al', 'Albanie', 0),
(8, 'am', 'Arm', 0),
(9, 'an', 'Antilles Neerlandaises', 0),
(10, 'ao', 'Angola', 0),
(11, 'aq', 'Antarctique', 0),
(12, 'ar', 'Argentine', 0),
(13, 'as', 'American Samoa', 0),
(14, 'au', 'Australie', 0),
(15, 'aw', 'Aruba', 0),
(16, 'az', 'Azerbaijan', 0),
(17, 'ba', 'Bosnie Herzegovine', 0),
(18, 'bb', 'Barbade', 0),
(19, 'bd', 'Bangladesh', 0),
(20, 'be', 'Belgique', 0),
(21, 'bf', 'Burkina Faso', 0),
(22, 'bg', 'Bulgarie', 0),
(23, 'bh', 'Bahrain', 0),
(24, 'bi', 'Burundi', 0),
(25, 'bj', 'Benin', 0),
(26, 'bm', 'Bermudes', 0),
(27, 'bn', 'Brunei Darussalam', 0),
(28, 'bo', 'Bolivie', 0),
(29, 'br', 'Br', 0),
(30, 'bs', 'Bahamas', 0),
(31, 'bt', 'Bhoutan', 0),
(32, 'bv', 'Bouvet (ile)', 0),
(33, 'bw', 'Botswana', 0),
(34, 'by', 'Bi', 0),
(35, 'bz', 'B', 0),
(36, 'ca', 'Canada', 0),
(37, 'cc', 'Cocos (Keeling) iles', 0),
(38, 'cd', 'Congo,(R', 0),
(39, 'cf', 'Centrafricaine (R', 0),
(40, 'cg', 'Congo', 0),
(41, 'ch', 'Suisse', 0),
(42, 'ci', 'Cote d''Ivoire', 0),
(43, 'ck', 'Cook (iles)', 0),
(44, 'cl', 'Chili', 0),
(45, 'cm', 'Cameroun', 0),
(46, 'cn', 'Chine', 0),
(47, 'co', 'Colombie', 0),
(48, 'cr', 'Costa Rica', 0),
(49, 'cu', 'Cuba', 0),
(50, 'cv', 'Cap Vert', 0),
(51, 'cx', 'Christmas (ile)', 0),
(52, 'cy', 'Chypre', 0),
(53, 'cz', 'Tch', 0),
(54, 'de', 'Allemagne', 0),
(55, 'dj', 'Djibouti', 0),
(56, 'dk', 'Danemark', 0),
(57, 'dm', 'Dominique', 0),
(58, 'do', 'Dominicaine (r', 0),
(59, 'dz', 'Alg', 0),
(60, 'ec', 'Equateur', 0),
(61, 'ee', 'Estonie', 0),
(62, 'eg', 'Egypte', 0),
(63, 'eh', 'Sahara Occidental', 0),
(64, 'er', 'Erythr', 0),
(65, 'es', 'Espagne', 0),
(66, 'et', 'Ethiopie', 0),
(67, 'fi', 'Finlande', 0),
(68, 'fj', 'Fiji', 0),
(69, 'fk', 'Falkland (Malouines) iles', 0),
(70, 'fm', 'Micron', 0),
(71, 'fo', 'Faroe (iles)', 0),
(72, 'fr', 'France', 0),
(73, 'ga', 'Gabon', 0),
(74, 'gd', 'Grenade', 0),
(75, 'ge', 'G', 0),
(76, 'gf', 'Guyane Fran', 0),
(77, 'gg', 'Guernsey', 0),
(78, 'gh', 'Ghana', 0),
(79, 'gi', 'Gibraltar', 0),
(80, 'gl', 'Groenland', 0),
(81, 'gm', 'Gambie', 0),
(82, 'gn', 'Guin', 0),
(83, 'gp', 'Guadeloupe', 0),
(84, 'gq', 'Guin', 0),
(85, 'gr', 'Gr', 0),
(86, 'gs', 'Georgie du sud et iles Sandwich du sud', 0),
(87, 'gt', 'Guatemala', 0),
(88, 'gu', 'Guam', 0),
(89, 'gw', 'Guin', 0),
(90, 'gy', 'Guyana', 0),
(91, 'hk', 'Hong Kong', 0),
(92, 'hm', 'Heard et McDonald (iles)', 0),
(93, 'hn', 'Honduras', 0),
(94, 'hr', 'Croatie', 0),
(95, 'ht', 'Haiti', 0),
(96, 'hu', 'Hongrie', 0),
(97, 'id', 'Indon', 0),
(98, 'ie', 'Irlande', 0),
(99, 'il', 'Isra', 0),
(100, 'im', 'Ile de Man', 0),
(101, 'in', 'Inde', 0),
(102, 'io', 'Territoire Britannique de l''Oc', 0),
(103, 'iq', 'Iraq', 0),
(104, 'ir', 'Iran', 0),
(105, 'is', 'Islande', 0),
(106, 'it', 'Italie', 0),
(107, 'je', 'Jersey', 0),
(108, 'jm', 'Jama', 0),
(109, 'jo', 'Jordanie', 0),
(110, 'jp', 'Japon', 0),
(111, 'ke', 'Kenya', 0),
(112, 'kg', 'Kirgizstan', 0),
(113, 'kh', 'Cambodge', 0),
(114, 'ki', 'Kiribati', 0),
(115, 'km', 'Comores', 0),
(116, 'kn', 'Saint Kitts et Nevis', 0),
(117, 'kp', 'Cor', 0),
(118, 'kr', 'Cor', 0),
(119, 'kw', 'Kowe', 0),
(120, 'ky', 'Ca', 0),
(121, 'kz', 'Kazakhstan', 0),
(122, 'la', 'Laos', 0),
(123, 'lb', 'Liban', 0),
(124, 'lc', 'Sainte Lucie', 0),
(125, 'li', 'Liechtenstein', 0),
(126, 'lk', 'Sri Lanka', 0),
(127, 'lr', 'Liberia', 0),
(128, 'ls', 'Lesotho', 0),
(129, 'lt', 'Lituanie', 0),
(130, 'lu', 'Luxembourg', 0),
(131, 'lv', 'Latvia', 0),
(132, 'ly', 'Libyan Arab Jamahiriya', 0),
(133, 'ma', 'Maroc', 0),
(134, 'mc', 'Monaco', 0),
(135, 'md', 'Moldavie', 0),
(136, 'mg', 'Madagascar', 0),
(137, 'mh', 'Marshall (iles)', 0),
(138, 'mk', 'Mac', 0),
(139, 'ml', 'Mali', 0),
(140, 'mm', 'Myanmar', 0),
(141, 'mn', 'Mongolie', 0),
(142, 'mo', 'Macao', 0),
(143, 'mp', 'Mariannes du nord (iles)', 0),
(144, 'mq', 'Martinique', 0),
(145, 'mr', 'Mauritanie', 0),
(146, 'ms', 'Montserrat', 0),
(147, 'mt', 'Malte', 0),
(148, 'mu', 'Maurice (ile)', 0),
(149, 'mv', 'Maldives', 0),
(150, 'mw', 'Malawi', 0),
(151, 'mx', 'Mexique', 0),
(152, 'my', 'Malaisie', 0),
(153, 'mz', 'Mozambique', 0),
(154, 'na', 'Namibie', 0),
(155, 'nc', 'Nouvelle Cal', 0),
(156, 'ne', 'Niger', 0),
(157, 'nf', 'Norfolk (ile)', 0),
(158, 'ng', 'Nig', 0),
(159, 'ni', 'Nicaragua', 0),
(160, 'nl', 'Pays Bas', 0),
(161, 'no', 'Norv', 0),
(162, 'np', 'N', 0),
(163, 'nr', 'Nauru', 0),
(164, 'nu', 'Niue', 0),
(165, 'nz', 'Nouvelle Z', 0),
(166, 'om', 'Oman', 0),
(167, 'pa', 'Panama', 0),
(168, 'pe', 'P', 0),
(169, 'pf', 'Polyn', 0),
(170, 'pg', 'Papouasie Nouvelle Guin', 0),
(171, 'ph', 'Philippines', 0),
(172, 'pk', 'Pakistan', 0),
(173, 'pl', 'Pologne', 0),
(174, 'pm', 'St. Pierre et Miquelon', 0),
(175, 'pn', 'Pitcairn (ile)', 0),
(176, 'pr', 'Porto Rico', 0),
(177, 'pt', 'Portugal', 0),
(178, 'pw', 'Palau', 0),
(179, 'py', 'Paraguay', 0),
(180, 'qa', 'Qatar', 0),
(181, 're', 'R', 0),
(182, 'ro', 'Roumanie', 0),
(183, 'ru', 'Russie', 0),
(184, 'rw', 'Rwanda', 0),
(185, 'sa', 'Arabie Saoudite', 0),
(186, 'sb', 'Salomon (iles)', 0),
(187, 'sc', 'Seychelles', 0),
(188, 'sd', 'Soudan', 0),
(189, 'se', 'Su', 0),
(190, 'sg', 'Singapour', 0),
(191, 'sh', 'St. H', 0),
(192, 'si', 'Slov', 0),
(193, 'sj', 'Svalbard et Jan Mayen (iles)', 0),
(194, 'sk', 'Slovaquie', 0),
(195, 'sl', 'Sierra Leone', 0),
(196, 'sm', 'Saint Marin', 0),
(197, 'sn', 'S', 0),
(198, 'so', 'Somalie', 0),
(199, 'sr', 'Suriname', 0),
(200, 'st', 'Sao Tome et Principe', 0),
(201, 'sv', 'Salvador', 0),
(202, 'sy', 'Syrie', 0),
(203, 'sz', 'Swaziland', 0),
(204, 'tc', 'Turks et Ca', 0),
(205, 'td', 'Tchad', 0),
(206, 'tf', 'Territoires Fran', 0),
(207, 'tg', 'Togo', 0),
(208, 'th', 'Thailande', 0),
(209, 'tj', 'Tajikistan', 0),
(210, 'tk', 'Tokelau', 0),
(211, 'tm', 'Turkm', 0),
(212, 'tn', 'Tunisie', 0),
(213, 'to', 'Tonga', 0),
(214, 'tp', 'Timor Oriental', 0),
(215, 'tr', 'Turquie', 0),
(216, 'tt', 'Trinidad et Tobago', 0),
(217, 'tv', 'Tuvalu', 0),
(218, 'tw', 'Taiwan', 0),
(219, 'tz', 'Tanzanie', 0),
(220, 'ua', 'Ukraine', 0),
(221, 'ug', 'Ouganda', 0),
(222, 'uk', 'Royaume Uni', 0),
(223, 'gb', 'Royaume Uni', 0),
(224, 'um', 'US Minor Outlying (iles)', 0),
(225, 'us', 'Etats Unis', 0),
(226, 'uy', 'Uruguay', 0),
(227, 'uz', 'Ouzb', 0),
(228, 'va', 'Vatican', 0),
(229, 'vc', 'Saint Vincent et les Grenadines', 0),
(230, 've', 'Venezuela', 0),
(231, 'vg', 'Vierges Britaniques (iles)', 0),
(232, 'vi', 'Vierges USA (iles)', 0),
(233, 'vn', 'Vi', 0),
(234, 'vu', 'Vanuatu', 0),
(235, 'wf', 'Wallis et Futuna (iles)', 0),
(236, 'ws', 'Western Samoa', 0),
(237, 'ye', 'Yemen', 0),
(238, 'yt', 'Mayotte', 0),
(239, 'yu', 'Yugoslavie', 0),
(240, 'za', 'Afrique du Sud', 0),
(241, 'zm', 'Zambie', 0),
(242, 'zr', 'Za', 0),
(243, 'zw', 'Zimbabwe', 0),
(244, 'com', '.COM', 0),
(245, 'net', '.NET', 0),
(246, 'org', '.ORG', 0),
(247, 'edu', 'Education', 0),
(248, 'int', '.INT', 0),
(249, 'arpa', '.ARPA', 0),
(250, 'at', 'Autriche', 0),
(251, 'gov', 'Gouvernement', 0),
(252, 'mil', 'Militaire', 0),
(253, 'su', 'Ex U.R.S.S.', 0),
(254, 'reverse', 'Reverse', 0),
(255, 'biz', 'Businesses', 0),
(256, 'info', '.INFO', 0),
(257, 'name', '.NAME', 0),
(258, 'pro', '.PRO', 0),
(259, 'coop', '.COOP', 0),
(260, 'aero', '.AERO', 0),
(261, 'museum', '.MUSEUM', 0),
(262, 'tv', '.TV', 0),
(263, 'ws', 'Web site', 0),
(264, '--', 'Unknown', 0);

-- --------------------------------------------------------

--
-- Table structure for table `track_c_os`
--

CREATE TABLE `track_c_os` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `os` varchar(255) NOT NULL DEFAULT '',
  `counter` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_c_providers`
--

CREATE TABLE `track_c_providers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `provider` varchar(255) NOT NULL DEFAULT '',
  `counter` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_c_referers`
--

CREATE TABLE `track_c_referers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `referer` varchar(255) NOT NULL DEFAULT '',
  `counter` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_e_access`
--

CREATE TABLE `track_e_access` (
  `access_id` int(11) NOT NULL AUTO_INCREMENT,
  `access_user_id` int(10) unsigned DEFAULT NULL,
  `access_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_cours_code` varchar(40) NOT NULL DEFAULT '',
  `access_tool` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`access_id`),
  KEY `access_user_id` (`access_user_id`),
  KEY `access_cours_code` (`access_cours_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_e_attempt`
--

CREATE TABLE `track_e_attempt` (
  `exe_id` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `question_id` int(11) NOT NULL DEFAULT '0',
  `answer` text NOT NULL,
  `teacher_comment` text NOT NULL,
  `marks` float(6,2) NOT NULL DEFAULT '0.00',
  `course_code` varchar(40) NOT NULL DEFAULT '',
  `position` int(11) DEFAULT '0',
  `tms` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  KEY `exe_id` (`exe_id`),
  KEY `user_id` (`user_id`),
  KEY `question_id` (`question_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `track_e_attempt_recording`
--

CREATE TABLE `track_e_attempt_recording` (
  `exe_id` int(10) unsigned NOT NULL,
  `question_id` int(10) unsigned NOT NULL,
  `marks` int(11) NOT NULL,
  `insert_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `author` int(10) unsigned NOT NULL,
  `teacher_comment` text NOT NULL,
  KEY `exe_id` (`exe_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `track_e_course_access`
--

CREATE TABLE `track_e_course_access` (
  `course_access_id` int(11) NOT NULL AUTO_INCREMENT,
  `course_code` varchar(40) NOT NULL,
  `user_id` int(11) NOT NULL,
  `login_course_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `logout_course_date` datetime DEFAULT NULL,
  `counter` int(11) NOT NULL,
  PRIMARY KEY (`course_access_id`),
  KEY `user_id` (`user_id`),
  KEY `login_course_date` (`login_course_date`),
  KEY `course_code` (`course_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_e_default`
--

CREATE TABLE `track_e_default` (
  `default_id` int(11) NOT NULL AUTO_INCREMENT,
  `default_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `default_cours_code` varchar(40) NOT NULL DEFAULT '',
  `default_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `default_event_type` varchar(20) NOT NULL DEFAULT '',
  `default_value_type` varchar(20) NOT NULL DEFAULT '',
  `default_value` tinytext NOT NULL,
  PRIMARY KEY (`default_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_e_downloads`
--

CREATE TABLE `track_e_downloads` (
  `down_id` int(11) NOT NULL AUTO_INCREMENT,
  `down_user_id` int(10) unsigned DEFAULT NULL,
  `down_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `down_cours_id` varchar(40) NOT NULL DEFAULT '',
  `down_doc_path` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`down_id`),
  KEY `down_user_id` (`down_user_id`),
  KEY `down_cours_id` (`down_cours_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_e_exercices`
--

CREATE TABLE `track_e_exercices` (
  `exe_id` int(11) NOT NULL AUTO_INCREMENT,
  `exe_user_id` int(10) unsigned DEFAULT NULL,
  `exe_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `exe_cours_id` varchar(40) NOT NULL DEFAULT '',
  `exe_exo_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `exe_result` float(6,2) NOT NULL DEFAULT '0.00',
  `exe_weighting` float(6,2) NOT NULL DEFAULT '0.00',
  `status` varchar(20) NOT NULL DEFAULT '',
  `data_tracking` text NOT NULL,
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `steps_counter` smallint(5) unsigned NOT NULL DEFAULT '0',
  `session_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `orig_lp_id` int(11) NOT NULL DEFAULT '0',
  `orig_lp_item_id` int(11) NOT NULL DEFAULT '0',
  `exe_duration` int(10) unsigned NOT NULL DEFAULT '0',
  `expired_time_control` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`exe_id`),
  KEY `exe_user_id` (`exe_user_id`),
  KEY `exe_cours_id` (`exe_cours_id`),
  KEY `session_id` (`session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_e_hotpotatoes`
--

CREATE TABLE `track_e_hotpotatoes` (
  `exe_name` varchar(255) NOT NULL,
  `exe_user_id` int(10) unsigned DEFAULT NULL,
  `exe_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `exe_cours_id` varchar(40) NOT NULL,
  `exe_result` smallint(6) NOT NULL DEFAULT '0',
  `exe_weighting` smallint(6) NOT NULL DEFAULT '0',
  KEY `exe_user_id` (`exe_user_id`),
  KEY `exe_cours_id` (`exe_cours_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `track_e_hotspot`
--

CREATE TABLE `track_e_hotspot` (
  `hotspot_id` int(11) NOT NULL AUTO_INCREMENT,
  `hotspot_user_id` int(11) NOT NULL,
  `hotspot_course_code` varchar(50) NOT NULL,
  `hotspot_exe_id` int(11) NOT NULL,
  `hotspot_question_id` int(11) NOT NULL,
  `hotspot_answer_id` int(11) NOT NULL,
  `hotspot_correct` tinyint(3) unsigned NOT NULL,
  `hotspot_coordinate` text NOT NULL,
  PRIMARY KEY (`hotspot_id`),
  KEY `hotspot_course_code` (`hotspot_course_code`),
  KEY `hotspot_user_id` (`hotspot_user_id`),
  KEY `hotspot_exe_id` (`hotspot_exe_id`),
  KEY `hotspot_question_id` (`hotspot_question_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_e_lastaccess`
--

CREATE TABLE `track_e_lastaccess` (
  `access_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `access_user_id` int(10) unsigned DEFAULT NULL,
  `access_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_cours_code` varchar(40) NOT NULL,
  `access_tool` varchar(30) DEFAULT NULL,
  `access_session_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`access_id`),
  KEY `access_user_id` (`access_user_id`),
  KEY `access_cours_code` (`access_cours_code`),
  KEY `access_session_id` (`access_session_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_e_links`
--

CREATE TABLE `track_e_links` (
  `links_id` int(11) NOT NULL AUTO_INCREMENT,
  `links_user_id` int(10) unsigned DEFAULT NULL,
  `links_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `links_cours_id` varchar(40) NOT NULL DEFAULT '',
  `links_link_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`links_id`),
  KEY `links_cours_id` (`links_cours_id`),
  KEY `links_user_id` (`links_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_e_login`
--

CREATE TABLE `track_e_login` (
  `login_id` int(11) NOT NULL AUTO_INCREMENT,
  `login_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `login_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `login_ip` varchar(39) NOT NULL DEFAULT '',
  `logout_date` datetime DEFAULT NULL,
  PRIMARY KEY (`login_id`),
  KEY `login_user_id` (`login_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_e_online`
--

CREATE TABLE `track_e_online` (
  `login_id` int(11) NOT NULL AUTO_INCREMENT,
  `login_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `login_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `login_ip` varchar(39) NOT NULL DEFAULT '',
  `course` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`login_id`),
  KEY `login_user_id` (`login_user_id`),
  KEY `course` (`course`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_e_open`
--

CREATE TABLE `track_e_open` (
  `open_id` int(11) NOT NULL AUTO_INCREMENT,
  `open_remote_host` tinytext NOT NULL,
  `open_agent` tinytext NOT NULL,
  `open_referer` tinytext NOT NULL,
  `open_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`open_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `track_e_uploads`
--

CREATE TABLE `track_e_uploads` (
  `upload_id` int(11) NOT NULL AUTO_INCREMENT,
  `upload_user_id` int(10) unsigned DEFAULT NULL,
  `upload_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `upload_cours_id` varchar(40) NOT NULL DEFAULT '',
  `upload_work_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`upload_id`),
  KEY `upload_user_id` (`upload_user_id`),
  KEY `upload_cours_id` (`upload_cours_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user`
--

CREATE TABLE `user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lastname` varchar(60) DEFAULT NULL,
  `firstname` varchar(60) DEFAULT NULL,
  `username` varchar(20) NOT NULL DEFAULT '',
  `password` varchar(50) NOT NULL DEFAULT '',
  `auth_source` varchar(50) DEFAULT 'platform',
  `email` varchar(100) DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '5',
  `official_code` varchar(40) DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `picture_uri` varchar(250) DEFAULT NULL,
  `creator_id` int(10) unsigned DEFAULT NULL,
  `competences` text,
  `diplomas` text,
  `openarea` text,
  `teach` text,
  `productions` varchar(250) DEFAULT NULL,
  `chatcall_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `chatcall_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `chatcall_text` varchar(50) NOT NULL DEFAULT '',
  `language` varchar(40) DEFAULT NULL,
  `registration_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expiration_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `openid` varchar(255) DEFAULT NULL,
  `theme` varchar(255) DEFAULT NULL,
  `hr_dept_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `login_counter` int(11) DEFAULT NULL,
  `login_failed_counter` int(11) DEFAULT NULL,
  `country_code` varchar(10) NOT NULL DEFAULT '',
  `civility` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `username` (`username`),
  KEY `status` (`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `user`
--

INSERT INTO `user` VALUES
(1, '[[admin_lname]]', '[[admin_fname]]', '[[admin_username]]', '[[admin_pass]]', 'platform', '[[admin_email]]', 1, 'ADMIN', '(000) 001 02 03', NULL, 1, NULL, NULL, NULL, NULL, NULL, 0, '0000-00-00 00:00:00', '', '[[language]]', '[[regtime]]', '0000-00-00 00:00:00', 1, NULL, NULL, 0, NULL, NULL, '', ''),
(2, 'Anonymous', 'Joe', '', '', 'platform', 'anonymous@[[domhost]]', 6, 'anonymous', NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 0, '0000-00-00 00:00:00', '', 'english', '[[regtime]]', '0000-00-00 00:00:00', 1, NULL, NULL, 0, NULL, NULL, '', '');

-- --------------------------------------------------------

--
-- Table structure for table `user_api_key`
--

CREATE TABLE `user_api_key` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `api_key` char(32) NOT NULL,
  `api_service` char(10) NOT NULL DEFAULT 'dokeos',
  PRIMARY KEY (`id`),
  KEY `idx_user_api_keys_user` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_chat`
--

CREATE TABLE `user_chat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `from_user` varchar(255) NOT NULL DEFAULT '',
  `to_user` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `sent` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `recd` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_course_category`
--

CREATE TABLE `user_course_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `title` text NOT NULL,
  `sort` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_field`
--

CREATE TABLE `user_field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_type` int(11) NOT NULL DEFAULT '1',
  `field_variable` varchar(64) NOT NULL,
  `field_display_text` varchar(64) DEFAULT NULL,
  `field_default_value` text,
  `field_order` int(11) DEFAULT NULL,
  `field_visible` tinyint(4) DEFAULT '0',
  `field_changeable` tinyint(4) DEFAULT '0',
  `field_filter` tinyint(4) DEFAULT '0',
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `field_registration` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

--
-- Dumping data for table `user_field`
--

INSERT INTO `user_field` VALUES
(1, 1, 'legal_accept', 'Legal', NULL, NULL, 0, 0, 0, '[[regtime]]', 0),
(2, 10, 'tags', 'tags', NULL, NULL, 0, 0, 0, '[[regtime]]', 0),
(3, 9, 'rssfeeds', 'RSS', NULL, NULL, 0, 0, 0, '[[regtime]]', 0),
(4, 1, 'organization', 'Organization', '', NULL, 0, 1, 1, '[[regtime]]', 1),
(5, 1, 'tva_id', 'TVA', '', NULL, 0, 1, 1, '[[regtime]]', 1),
(6, 1, 'phone', 'Phone', '', NULL, 1, 1, 1, '[[regtime]]', 1),
(7, 1, 'street', 'Street', '', NULL, 1, 1, 1, '[[regtime]]', 1),
(8, 1, 'addressline2', 'Address line', '', NULL, 1, 1, 1, '[[regtime]]', 1),
(9, 1, 'zipcode', 'Zip code', '', NULL, 1, 1, 1, '[[regtime]]', 1),
(10, 1, 'city', 'City', '', NULL, 1, 1, 1, '[[regtime]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `user_field_options`
--

CREATE TABLE `user_field_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_id` int(11) NOT NULL,
  `option_value` text,
  `option_display_text` varchar(64) DEFAULT NULL,
  `option_order` int(11) DEFAULT NULL,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_field_values`
--

CREATE TABLE `user_field_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `field_id` int(11) NOT NULL,
  `field_value` text,
  `tms` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_friend_relation_type`
--

CREATE TABLE `user_friend_relation_type` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` char(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `user_friend_relation_type`
--

INSERT INTO `user_friend_relation_type` VALUES
(1, 'SocialUnknow'),
(2, 'SocialParent'),
(3, 'SocialFriend'),
(4, 'SocialGoodFriend'),
(5, 'SocialEnemy'),
(6, 'SocialDeleted');

-- --------------------------------------------------------

--
-- Table structure for table `user_rel_tag`
--

CREATE TABLE `user_rel_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `tag_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_rel_user`
--

CREATE TABLE `user_rel_user` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `friend_user_id` int(10) unsigned NOT NULL,
  `relation_type` int(11) NOT NULL DEFAULT '0',
  `last_edit` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_rel_user_user` (`user_id`),
  KEY `idx_user_rel_user_friend_user` (`friend_user_id`),
  KEY `idx_user_rel_user_user_friend_user` (`user_id`,`friend_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
