
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `docebo31`
--

-- --------------------------------------------------------

--
-- Table structure for table `conference_booking`
--

CREATE TABLE `conference_booking` (
  `booking_id` int(11) NOT NULL AUTO_INCREMENT,
  `room_id` int(11) NOT NULL DEFAULT '0',
  `platform` varchar(255) NOT NULL DEFAULT '',
  `module` varchar(100) NOT NULL DEFAULT '',
  `user_idst` int(11) NOT NULL DEFAULT '0',
  `approved` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`booking_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `conference_booking`
--


-- --------------------------------------------------------

--
-- Table structure for table `conference_chatperm`
--

CREATE TABLE `conference_chatperm` (
  `room_id` int(11) NOT NULL DEFAULT '0',
  `module` varchar(50) NOT NULL DEFAULT '',
  `user_idst` int(11) NOT NULL DEFAULT '0',
  `perm` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`room_id`,`module`,`user_idst`,`perm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `conference_chatperm`
--


-- --------------------------------------------------------

--
-- Table structure for table `conference_chat_msg`
--

CREATE TABLE `conference_chat_msg` (
  `msg_id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `id_room` int(11) NOT NULL DEFAULT '0',
  `userid` varchar(255) NOT NULL DEFAULT '',
  `send_to` int(11) DEFAULT NULL,
  `sent_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `text` text NOT NULL,
  PRIMARY KEY (`msg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `conference_chat_msg`
--


-- --------------------------------------------------------

--
-- Table structure for table `conference_dimdim`
--

CREATE TABLE `conference_dimdim` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `idConference` bigint(20) NOT NULL DEFAULT '0',
  `confkey` varchar(255) DEFAULT NULL,
  `emailuser` varchar(255) DEFAULT NULL,
  `displayname` varchar(255) DEFAULT NULL,
  `timezone` varchar(255) DEFAULT NULL,
  `audiovideosettings` int(11) DEFAULT NULL,
  `maxmikes` int(11) DEFAULT NULL,
  `schedule_info` text NOT NULL,
  `extra_conf` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idConference` (`idConference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `conference_dimdim`
--


-- --------------------------------------------------------

--
-- Table structure for table `conference_menu`
--

CREATE TABLE `conference_menu` (
  `idMenu` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL DEFAULT '',
  `sequence` int(3) NOT NULL DEFAULT '0',
  `collapse` enum('true','false') NOT NULL DEFAULT 'false',
  PRIMARY KEY (`idMenu`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `conference_menu`
--

INSERT INTO `conference_menu` VALUES(1, '_MAIN_CONFERENCE_MANAGMENT', '', 1, 'true');

-- --------------------------------------------------------

--
-- Table structure for table `conference_menu_under`
--

CREATE TABLE `conference_menu_under` (
  `idUnder` int(11) NOT NULL AUTO_INCREMENT,
  `idMenu` int(11) NOT NULL DEFAULT '0',
  `module_name` varchar(255) NOT NULL DEFAULT '',
  `default_name` varchar(255) NOT NULL DEFAULT '',
  `default_op` varchar(255) NOT NULL DEFAULT '',
  `associated_token` varchar(255) NOT NULL DEFAULT '',
  `of_platform` varchar(255) DEFAULT NULL,
  `sequence` int(3) NOT NULL DEFAULT '0',
  `class_file` varchar(255) NOT NULL DEFAULT '',
  `class_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`idUnder`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `conference_menu_under`
--

INSERT INTO `conference_menu_under` VALUES(2, 1, 'room', '_ROOM', 'room', 'view', NULL, 2, 'class.room.php', 'Module_Room');

-- --------------------------------------------------------

--
-- Table structure for table `conference_room`
--

CREATE TABLE `conference_room` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `idCal` bigint(20) NOT NULL DEFAULT '0',
  `idCourse` bigint(20) NOT NULL DEFAULT '0',
  `idSt` bigint(20) NOT NULL DEFAULT '0',
  `name` varchar(255) DEFAULT NULL,
  `room_type` varchar(255) DEFAULT NULL,
  `starttime` bigint(20) DEFAULT NULL,
  `endtime` bigint(20) DEFAULT NULL,
  `meetinghours` int(11) DEFAULT NULL,
  `maxparticipants` int(11) DEFAULT NULL,
  `bookable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idCourse` (`idCourse`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `conference_room`
--


-- --------------------------------------------------------

--
-- Table structure for table `conference_rules_admin`
--

CREATE TABLE `conference_rules_admin` (
  `server_status` enum('yes','no') NOT NULL DEFAULT 'yes',
  `enable_recording_function` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_advice_insert` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_write` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_chat_recording` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_private_subroom` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_public_subroom` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_drawboard_watch` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_drawboard_write` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_audio` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_webcam` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_stream_watch` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_strem_write` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_remote_desktop` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  PRIMARY KEY (`server_status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `conference_rules_admin`
--


-- --------------------------------------------------------

--
-- Table structure for table `conference_rules_room`
--

CREATE TABLE `conference_rules_room` (
  `id_room` int(11) NOT NULL AUTO_INCREMENT,
  `enable_recording_function` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_advice_insert` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_write` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_chat_recording` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_private_subroom` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_public_subroom` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_drawboard_watch` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_drawboard_write` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_audio` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_webcam` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_stream_watch` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_strem_write` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `enable_remote_desktop` enum('admin','alluser','noone') NOT NULL DEFAULT 'noone',
  `room_name` varchar(255) NOT NULL DEFAULT '',
  `room_type` enum('course','private','public') NOT NULL DEFAULT 'course',
  `id_source` int(11) NOT NULL DEFAULT '0',
  `room_parent` int(11) NOT NULL DEFAULT '0',
  `advice_one` text,
  `advice_two` text,
  `advice_three` text,
  `room_logo` varchar(255) DEFAULT NULL,
  `room_sponsor` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id_room`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `conference_rules_room`
--


-- --------------------------------------------------------

--
-- Table structure for table `conference_rules_root`
--

CREATE TABLE `conference_rules_root` (
  `system_type` enum('p2p','server') NOT NULL DEFAULT 'p2p',
  `server_ip` varchar(255) DEFAULT NULL,
  `server_port` int(5) unsigned DEFAULT NULL,
  `server_path` varchar(255) DEFAULT NULL,
  `max_user_at_time` int(11) unsigned NOT NULL DEFAULT '0',
  `max_room_at_time` int(11) unsigned NOT NULL DEFAULT '0',
  `max_subroom_for_room` int(11) unsigned NOT NULL DEFAULT '0',
  `enable_drawboard` enum('yes','no') NOT NULL DEFAULT 'no',
  `enable_livestream` enum('yes','no') NOT NULL DEFAULT 'no',
  `enable_remote_desktop` enum('yes','no') NOT NULL DEFAULT 'no',
  `enable_webcam` enum('yes','no') NOT NULL DEFAULT 'no',
  `enable_audio` enum('yes','no') NOT NULL DEFAULT 'no',
  PRIMARY KEY (`system_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `conference_rules_root`
--


-- --------------------------------------------------------

--
-- Table structure for table `conference_rules_user`
--

CREATE TABLE `conference_rules_user` (
  `id_user` int(11) NOT NULL AUTO_INCREMENT,
  `last_hit` int(11) NOT NULL DEFAULT '0',
  `id_room` int(11) NOT NULL DEFAULT '0',
  `userid` varchar(255) NOT NULL DEFAULT '',
  `user_ip` varchar(15) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL DEFAULT '',
  `last_name` varchar(255) NOT NULL DEFAULT '',
  `level` int(11) NOT NULL DEFAULT '0',
  `auto_reload` tinyint(1) NOT NULL DEFAULT '0',
  `banned_until` datetime DEFAULT NULL,
  `chat_record` enum('yes','no') NOT NULL DEFAULT 'no',
  `advice_insert` enum('yes','no') NOT NULL DEFAULT 'no',
  `write_in_chat` enum('yes','no') NOT NULL DEFAULT 'no',
  `request_to_chat` enum('yes','no') NOT NULL DEFAULT 'no',
  `create_public_subroom` enum('yes','no') NOT NULL DEFAULT 'no',
  `enable_webcam` enum('yes','no') NOT NULL DEFAULT 'no',
  `enable_audio` enum('yes','no') NOT NULL DEFAULT 'no',
  `enable_drawboard_watch` enum('yes','no') NOT NULL DEFAULT 'no',
  `enable_drawboard_draw` enum('yes','no') NOT NULL DEFAULT 'no',
  `enable_livestream_watch` enum('yes','no') NOT NULL DEFAULT 'no',
  `enable_livestream_publish` enum('yes','no') NOT NULL DEFAULT 'no',
  `accept_private_message` enum('yes','no') NOT NULL DEFAULT 'no',
  `picture` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `conference_rules_user`
--


-- --------------------------------------------------------

--
-- Table structure for table `conference_teleskill`
--

CREATE TABLE `conference_teleskill` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `idConference` bigint(20) NOT NULL DEFAULT '0',
  `roomid` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idConference` (`idConference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `conference_teleskill`
--


-- --------------------------------------------------------

--
-- Table structure for table `conference_teleskill_log`
--

CREATE TABLE `conference_teleskill_log` (
  `roomid` int(11) NOT NULL DEFAULT '0',
  `idUser` int(11) NOT NULL DEFAULT '0',
  `role` int(11) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `duration` int(11) NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`roomid`,`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `conference_teleskill_log`
--


-- --------------------------------------------------------

--
-- Table structure for table `conference_teleskill_room`
--

CREATE TABLE `conference_teleskill_room` (
  `roomid` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `zone` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `bookable` tinyint(1) NOT NULL DEFAULT '0',
  `capacity` int(11) DEFAULT NULL,
  PRIMARY KEY (`roomid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `conference_teleskill_room`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_admin_course`
--

CREATE TABLE `core_admin_course` (
  `idst_user` int(11) NOT NULL DEFAULT '0',
  `type_of_entry` varchar(50) NOT NULL DEFAULT '',
  `id_entry` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idst_user`,`type_of_entry`,`id_entry`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_admin_course`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_admin_tree`
--

CREATE TABLE `core_admin_tree` (
  `idst` varchar(11) NOT NULL DEFAULT '',
  `idstAdmin` varchar(11) NOT NULL DEFAULT '',
  PRIMARY KEY (`idst`,`idstAdmin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_admin_tree`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_calendar`
--

CREATE TABLE `core_calendar` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `class` varchar(30) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `private` varchar(2) DEFAULT NULL,
  `category` varchar(255) DEFAULT NULL,
  `type` bigint(20) DEFAULT NULL,
  `visibility_rules` tinytext,
  `_owner` int(11) DEFAULT NULL,
  `_day` smallint(2) DEFAULT NULL,
  `_month` smallint(2) DEFAULT NULL,
  `_year` smallint(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_calendar`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_code`
--

CREATE TABLE `core_code` (
  `code` varchar(255) NOT NULL DEFAULT '',
  `idCodeGroup` int(11) NOT NULL DEFAULT '0',
  `used` tinyint(1) NOT NULL DEFAULT '0',
  `idUser` int(11) DEFAULT NULL,
  `unlimitedUse` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_code`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_code_association`
--

CREATE TABLE `core_code_association` (
  `code` varchar(255) NOT NULL DEFAULT '',
  `idUser` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`code`,`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_code_association`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_code_course`
--

CREATE TABLE `core_code_course` (
  `idCodeGroup` int(11) NOT NULL DEFAULT '0',
  `idCourse` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idCodeGroup`,`idCourse`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_code_course`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_code_groups`
--

CREATE TABLE `core_code_groups` (
  `idCodeGroup` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  PRIMARY KEY (`idCodeGroup`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_code_groups`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_code_org`
--

CREATE TABLE `core_code_org` (
  `idCodeGroup` int(11) NOT NULL DEFAULT '0',
  `idOrg` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idCodeGroup`,`idOrg`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_code_org`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_connection`
--

CREATE TABLE `core_connection` (
  `name` varchar(50) NOT NULL DEFAULT '',
  `description` varchar(255) DEFAULT NULL,
  `type` varchar(50) NOT NULL DEFAULT '',
  `params` text,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_connection`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_connector`
--

CREATE TABLE `core_connector` (
  `type` varchar(25) NOT NULL DEFAULT '',
  `file` varchar(255) NOT NULL DEFAULT '',
  `class` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_connector`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_country`
--

CREATE TABLE `core_country` (
  `id_country` int(11) NOT NULL AUTO_INCREMENT,
  `name_country` varchar(64) NOT NULL DEFAULT '',
  `iso_code_country` varchar(3) NOT NULL DEFAULT '',
  `id_zone` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_country`),
  KEY `IDX_COUNTRIES_NAME` (`name_country`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=245 ;

--
-- Dumping data for table `core_country`
--

INSERT INTO `core_country` VALUES(1, 'AFGHANISTAN', 'AF', 0);
INSERT INTO `core_country` VALUES(2, 'ALAND ISLANDS', 'AX', 0);
INSERT INTO `core_country` VALUES(3, 'ALBANIA', 'AL', 0);
INSERT INTO `core_country` VALUES(4, 'ALGERIA', 'DZ', 0);
INSERT INTO `core_country` VALUES(5, 'AMERICAN SAMOA', 'AS', 0);
INSERT INTO `core_country` VALUES(6, 'ANDORRA', 'AD', 0);
INSERT INTO `core_country` VALUES(7, 'ANGOLA', 'AO', 0);
INSERT INTO `core_country` VALUES(8, 'ANGUILLA', 'AI', 0);
INSERT INTO `core_country` VALUES(9, 'ANTARCTICA', 'AQ', 0);
INSERT INTO `core_country` VALUES(10, 'ANTIGUA AND BARBUDA', 'AG', 0);
INSERT INTO `core_country` VALUES(11, 'ARGENTINA', 'AR', 0);
INSERT INTO `core_country` VALUES(12, 'ARMENIA', 'AM', 0);
INSERT INTO `core_country` VALUES(13, 'ARUBA', 'AW', 0);
INSERT INTO `core_country` VALUES(14, 'AUSTRALIA', 'AU', 0);
INSERT INTO `core_country` VALUES(15, 'AUSTRIA', 'AT', 0);
INSERT INTO `core_country` VALUES(16, 'AZERBAIJAN', 'AZ', 0);
INSERT INTO `core_country` VALUES(17, 'BAHAMAS', 'BS', 0);
INSERT INTO `core_country` VALUES(18, 'BAHRAIN', 'BH', 0);
INSERT INTO `core_country` VALUES(19, 'BANGLADESH', 'BD', 0);
INSERT INTO `core_country` VALUES(20, 'BARBADOS', 'BB', 0);
INSERT INTO `core_country` VALUES(21, 'BELARUS', 'BY', 0);
INSERT INTO `core_country` VALUES(22, 'BELGIUM', 'BE', 0);
INSERT INTO `core_country` VALUES(23, 'BELIZE', 'BZ', 0);
INSERT INTO `core_country` VALUES(24, 'BENIN', 'BJ', 0);
INSERT INTO `core_country` VALUES(25, 'BERMUDA', 'BM', 0);
INSERT INTO `core_country` VALUES(26, 'BHUTAN', 'BT', 0);
INSERT INTO `core_country` VALUES(27, 'BOLIVIA', 'BO', 0);
INSERT INTO `core_country` VALUES(28, 'BOSNIA AND HERZEGOVINA', 'BA', 0);
INSERT INTO `core_country` VALUES(29, 'BOTSWANA', 'BW', 0);
INSERT INTO `core_country` VALUES(30, 'BOUVET ISLAND', 'BV', 0);
INSERT INTO `core_country` VALUES(31, 'BRAZIL', 'BR', 0);
INSERT INTO `core_country` VALUES(32, 'BRITISH INDIAN OCEAN TERRITORY', 'IO', 0);
INSERT INTO `core_country` VALUES(33, 'BRUNEI DARUSSALAM', 'BN', 0);
INSERT INTO `core_country` VALUES(34, 'BULGARIA', 'BG', 0);
INSERT INTO `core_country` VALUES(35, 'BURKINA FASO', 'BF', 0);
INSERT INTO `core_country` VALUES(36, 'BURUNDI', 'BI', 0);
INSERT INTO `core_country` VALUES(37, 'CAMBODIA', 'KH', 0);
INSERT INTO `core_country` VALUES(38, 'CAMEROON', 'CM', 0);
INSERT INTO `core_country` VALUES(39, 'CANADA', 'CA', 0);
INSERT INTO `core_country` VALUES(40, 'CAPE VERDE', 'CV', 0);
INSERT INTO `core_country` VALUES(41, 'CAYMAN ISLANDS', 'KY', 0);
INSERT INTO `core_country` VALUES(42, 'CENTRAL AFRICAN REPUBLIC', 'CF', 0);
INSERT INTO `core_country` VALUES(43, 'CHAD', 'TD', 0);
INSERT INTO `core_country` VALUES(44, 'CHILE', 'CL', 0);
INSERT INTO `core_country` VALUES(45, 'CHINA', 'CN', 0);
INSERT INTO `core_country` VALUES(46, 'CHRISTMAS ISLAND', 'CX', 0);
INSERT INTO `core_country` VALUES(47, 'COCOS (KEELING) ISLANDS', 'CC', 0);
INSERT INTO `core_country` VALUES(48, 'COLOMBIA', 'CO', 0);
INSERT INTO `core_country` VALUES(49, 'COMOROS', 'KM', 0);
INSERT INTO `core_country` VALUES(50, 'CONGO', 'CG', 0);
INSERT INTO `core_country` VALUES(51, 'CONGO, THE DEMOCRATIC REPUBLIC OF THE', 'CD', 0);
INSERT INTO `core_country` VALUES(52, 'COOK ISLANDS', 'CK', 0);
INSERT INTO `core_country` VALUES(53, 'COSTA RICA', 'CR', 0);
INSERT INTO `core_country` VALUES(54, 'IVORY COAST', 'CI', 0);
INSERT INTO `core_country` VALUES(55, 'CROATIA', 'HR', 0);
INSERT INTO `core_country` VALUES(56, 'CUBA', 'CU', 0);
INSERT INTO `core_country` VALUES(57, 'CYPRUS', 'CY', 0);
INSERT INTO `core_country` VALUES(58, 'CZECH REPUBLIC', 'CZ', 0);
INSERT INTO `core_country` VALUES(59, 'DENMARK', 'DK', 0);
INSERT INTO `core_country` VALUES(60, 'DJIBOUTI', 'DJ', 0);
INSERT INTO `core_country` VALUES(61, 'DOMINICA', 'DM', 0);
INSERT INTO `core_country` VALUES(62, 'DOMINICAN REPUBLIC', 'DO', 0);
INSERT INTO `core_country` VALUES(63, 'ECUADOR', 'EC', 0);
INSERT INTO `core_country` VALUES(64, 'EGYPT', 'EG', 0);
INSERT INTO `core_country` VALUES(65, 'EL SALVADOR', 'SV', 0);
INSERT INTO `core_country` VALUES(66, 'EQUATORIAL GUINEA', 'GQ', 0);
INSERT INTO `core_country` VALUES(67, 'ERITREA', 'ER', 0);
INSERT INTO `core_country` VALUES(68, 'ESTONIA', 'EE', 0);
INSERT INTO `core_country` VALUES(69, 'ETHIOPIA', 'ET', 0);
INSERT INTO `core_country` VALUES(70, 'FALKLAND ISLANDS (MALVINAS)', 'FK', 0);
INSERT INTO `core_country` VALUES(71, 'FAROE ISLANDS', 'FO', 0);
INSERT INTO `core_country` VALUES(72, 'FIJI', 'FJ', 0);
INSERT INTO `core_country` VALUES(73, 'FINLAND', 'FI', 0);
INSERT INTO `core_country` VALUES(74, 'FRANCE', 'FR', 0);
INSERT INTO `core_country` VALUES(75, 'FRENCH GUIANA', 'GF', 0);
INSERT INTO `core_country` VALUES(76, 'FRENCH POLYNESIA', 'PF', 0);
INSERT INTO `core_country` VALUES(77, 'FRENCH SOUTHERN TERRITORIES', 'TF', 0);
INSERT INTO `core_country` VALUES(78, 'GABON', 'GA', 0);
INSERT INTO `core_country` VALUES(79, 'GAMBIA', 'GM', 0);
INSERT INTO `core_country` VALUES(80, 'GEORGIA', 'GE', 0);
INSERT INTO `core_country` VALUES(81, 'GERMANY', 'DE', 0);
INSERT INTO `core_country` VALUES(82, 'GHANA', 'GH', 0);
INSERT INTO `core_country` VALUES(83, 'GIBRALTAR', 'GI', 0);
INSERT INTO `core_country` VALUES(84, 'GREECE', 'GR', 0);
INSERT INTO `core_country` VALUES(85, 'GREENLAND', 'GL', 0);
INSERT INTO `core_country` VALUES(86, 'GRENADA', 'GD', 0);
INSERT INTO `core_country` VALUES(87, 'GUADELOUPE', 'GP', 0);
INSERT INTO `core_country` VALUES(88, 'GUAM', 'GU', 0);
INSERT INTO `core_country` VALUES(89, 'GUATEMALA', 'GT', 0);
INSERT INTO `core_country` VALUES(90, 'GUERNSEY', 'GG', 0);
INSERT INTO `core_country` VALUES(91, 'GUINEA', 'GN', 0);
INSERT INTO `core_country` VALUES(92, 'GUINEA-BISSAU', 'GW', 0);
INSERT INTO `core_country` VALUES(93, 'GUYANA', 'GY', 0);
INSERT INTO `core_country` VALUES(94, 'HAITI', 'HT', 0);
INSERT INTO `core_country` VALUES(95, 'HEARD ISLAND AND MCDONALD ISLANDS', 'HM', 0);
INSERT INTO `core_country` VALUES(96, 'HONDURAS', 'HN', 0);
INSERT INTO `core_country` VALUES(97, 'HONG KONG', 'HK', 0);
INSERT INTO `core_country` VALUES(98, 'HUNGARY', 'HU', 0);
INSERT INTO `core_country` VALUES(99, 'ICELAND', 'IS', 0);
INSERT INTO `core_country` VALUES(100, 'INDIA', 'IN', 0);
INSERT INTO `core_country` VALUES(101, 'INDONESIA', 'ID', 0);
INSERT INTO `core_country` VALUES(102, 'IRAN', 'IR', 0);
INSERT INTO `core_country` VALUES(103, 'IRAQ', 'IQ', 0);
INSERT INTO `core_country` VALUES(104, 'IRELAND', 'IE', 0);
INSERT INTO `core_country` VALUES(105, 'ISLE OF MAN', 'IM', 0);
INSERT INTO `core_country` VALUES(106, 'ISRAEL', 'IL', 0);
INSERT INTO `core_country` VALUES(107, 'ITALY', 'IT', 0);
INSERT INTO `core_country` VALUES(108, 'JAMAICA', 'JM', 0);
INSERT INTO `core_country` VALUES(109, 'JAPAN', 'JP', 0);
INSERT INTO `core_country` VALUES(110, 'JERSEY', 'JE', 0);
INSERT INTO `core_country` VALUES(111, 'JORDAN', 'JO', 0);
INSERT INTO `core_country` VALUES(112, 'KAZAKHSTAN', 'KZ', 0);
INSERT INTO `core_country` VALUES(113, 'KENYA', 'KE', 0);
INSERT INTO `core_country` VALUES(114, 'KIRIBATI', 'KI', 0);
INSERT INTO `core_country` VALUES(115, 'KOREA, DEMOCRATIC PEOPLE''S REPUBLIC OF', 'KP', 0);
INSERT INTO `core_country` VALUES(116, 'KOREA, REPUBLIC OF', 'KR', 0);
INSERT INTO `core_country` VALUES(117, 'KUWAIT', 'KW', 0);
INSERT INTO `core_country` VALUES(118, 'KYRGYZSTAN', 'KG', 0);
INSERT INTO `core_country` VALUES(119, 'LAO PEOPLE''S DEMOCRATIC REPUBLIC', 'LA', 0);
INSERT INTO `core_country` VALUES(120, 'LATVIA', 'LV', 0);
INSERT INTO `core_country` VALUES(121, 'LEBANON', 'LB', 0);
INSERT INTO `core_country` VALUES(122, 'LESOTHO', 'LS', 0);
INSERT INTO `core_country` VALUES(123, 'LIBERIA', 'LR', 0);
INSERT INTO `core_country` VALUES(124, 'LIBYAN ARAB JAMAHIRIYA', 'LY', 0);
INSERT INTO `core_country` VALUES(125, 'LIECHTENSTEIN', 'LI', 0);
INSERT INTO `core_country` VALUES(126, 'LITHUANIA', 'LT', 0);
INSERT INTO `core_country` VALUES(127, 'LUXEMBOURG', 'LU', 0);
INSERT INTO `core_country` VALUES(128, 'MACAO', 'MO', 0);
INSERT INTO `core_country` VALUES(129, 'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF', 'MK', 0);
INSERT INTO `core_country` VALUES(130, 'MADAGASCAR', 'MG', 0);
INSERT INTO `core_country` VALUES(131, 'MALAWI', 'MW', 0);
INSERT INTO `core_country` VALUES(132, 'MALAYSIA', 'MY', 0);
INSERT INTO `core_country` VALUES(133, 'MALDIVES', 'MV', 0);
INSERT INTO `core_country` VALUES(134, 'MALI', 'ML', 0);
INSERT INTO `core_country` VALUES(135, 'MALTA', 'MT', 0);
INSERT INTO `core_country` VALUES(136, 'MARSHALL ISLANDS', 'MH', 0);
INSERT INTO `core_country` VALUES(137, 'MARTINIQUE', 'MQ', 0);
INSERT INTO `core_country` VALUES(138, 'MAURITANIA', 'MR', 0);
INSERT INTO `core_country` VALUES(139, 'MAURITIUS', 'MU', 0);
INSERT INTO `core_country` VALUES(140, 'MAYOTTE', 'YT', 0);
INSERT INTO `core_country` VALUES(141, 'MEXICO', 'MX', 0);
INSERT INTO `core_country` VALUES(142, 'MICRONESIA, FEDERATED STATES OF', 'FM', 0);
INSERT INTO `core_country` VALUES(143, 'MOLDOVA, REPUBLIC OF', 'MD', 0);
INSERT INTO `core_country` VALUES(144, 'MONACO', 'MC', 0);
INSERT INTO `core_country` VALUES(145, 'MONGOLIA', 'MN', 0);
INSERT INTO `core_country` VALUES(146, 'MONTENEGRO', 'ME', 0);
INSERT INTO `core_country` VALUES(147, 'MONTSERRAT', 'MS', 0);
INSERT INTO `core_country` VALUES(148, 'MOROCCO', 'MA', 0);
INSERT INTO `core_country` VALUES(149, 'MOZAMBIQUE', 'MZ', 0);
INSERT INTO `core_country` VALUES(150, 'MYANMAR', 'MM', 0);
INSERT INTO `core_country` VALUES(151, 'NAMIBIA', 'NA', 0);
INSERT INTO `core_country` VALUES(152, 'NAURU', 'NR', 0);
INSERT INTO `core_country` VALUES(153, 'NEPAL', 'NP', 0);
INSERT INTO `core_country` VALUES(154, 'NETHERLANDS', 'NL', 0);
INSERT INTO `core_country` VALUES(155, 'NETHERLANDS ANTILLES', 'AN', 0);
INSERT INTO `core_country` VALUES(156, 'NEW CALEDONIA', 'NC', 0);
INSERT INTO `core_country` VALUES(157, 'NEW ZEALAND', 'NZ', 0);
INSERT INTO `core_country` VALUES(158, 'NICARAGUA', 'NI', 0);
INSERT INTO `core_country` VALUES(159, 'NIGER', 'NE', 0);
INSERT INTO `core_country` VALUES(160, 'NIGERIA', 'NG', 0);
INSERT INTO `core_country` VALUES(161, 'NIUE', 'NU', 0);
INSERT INTO `core_country` VALUES(162, 'NORFOLK ISLAND', 'NF', 0);
INSERT INTO `core_country` VALUES(163, 'NORTHERN MARIANA ISLANDS', 'MP', 0);
INSERT INTO `core_country` VALUES(164, 'NORWAY', 'NO', 0);
INSERT INTO `core_country` VALUES(165, 'OMAN', 'OM', 0);
INSERT INTO `core_country` VALUES(166, 'PAKISTAN', 'PK', 0);
INSERT INTO `core_country` VALUES(167, 'PALAU', 'PW', 0);
INSERT INTO `core_country` VALUES(168, 'PALESTINIAN TERRITORY, OCCUPIED', 'PS', 0);
INSERT INTO `core_country` VALUES(169, 'PANAMA', 'PA', 0);
INSERT INTO `core_country` VALUES(170, 'PAPUA NEW GUINEA', 'PG', 0);
INSERT INTO `core_country` VALUES(171, 'PARAGUAY', 'PY', 0);
INSERT INTO `core_country` VALUES(172, 'PERU', 'PE', 0);
INSERT INTO `core_country` VALUES(173, 'PHILIPPINES', 'PH', 0);
INSERT INTO `core_country` VALUES(174, 'PITCAIRN', 'PN', 0);
INSERT INTO `core_country` VALUES(175, 'POLAND', 'PL', 0);
INSERT INTO `core_country` VALUES(176, 'PORTUGAL', 'PT', 0);
INSERT INTO `core_country` VALUES(177, 'PUERTO RICO', 'PR', 0);
INSERT INTO `core_country` VALUES(178, 'QATAR', 'QA', 0);
INSERT INTO `core_country` VALUES(179, 'Reunion', 'RE', 0);
INSERT INTO `core_country` VALUES(180, 'ROMANIA', 'RO', 0);
INSERT INTO `core_country` VALUES(181, 'RUSSIAN FEDERATION', 'RU', 0);
INSERT INTO `core_country` VALUES(182, 'RWANDA', 'RW', 0);
INSERT INTO `core_country` VALUES(183, 'SAINT HELENA', 'SH', 0);
INSERT INTO `core_country` VALUES(184, 'SAINT KITTS AND NEVIS', 'KN', 0);
INSERT INTO `core_country` VALUES(185, 'SAINT LUCIA', 'LC', 0);
INSERT INTO `core_country` VALUES(186, 'SAINT PIERRE AND MIQUELON', 'PM', 0);
INSERT INTO `core_country` VALUES(187, 'SAINT VINCENT AND THE GRENADINES', 'VC', 0);
INSERT INTO `core_country` VALUES(188, 'SAMOA', 'WS', 0);
INSERT INTO `core_country` VALUES(189, 'SAN MARINO', 'SM', 0);
INSERT INTO `core_country` VALUES(190, 'SAO TOME AND PRINCIPE', 'ST', 0);
INSERT INTO `core_country` VALUES(191, 'SAUDI ARABIA', 'SA', 0);
INSERT INTO `core_country` VALUES(192, 'SENEGAL', 'SN', 0);
INSERT INTO `core_country` VALUES(193, 'SERBIA', 'RS', 0);
INSERT INTO `core_country` VALUES(194, 'SEYCHELLES', 'SC', 0);
INSERT INTO `core_country` VALUES(195, 'SIERRA LEONE', 'SL', 0);
INSERT INTO `core_country` VALUES(196, 'SINGAPORE', 'SG', 0);
INSERT INTO `core_country` VALUES(197, 'SLOVAKIA', 'SK', 0);
INSERT INTO `core_country` VALUES(198, 'SLOVENIA', 'SI', 0);
INSERT INTO `core_country` VALUES(199, 'SOLOMON ISLANDS', 'SB', 0);
INSERT INTO `core_country` VALUES(200, 'SOMALIA', 'SO', 0);
INSERT INTO `core_country` VALUES(201, 'SOUTH AFRICA', 'ZA', 0);
INSERT INTO `core_country` VALUES(202, 'SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS', 'GS', 0);
INSERT INTO `core_country` VALUES(203, 'SPAIN', 'ES', 0);
INSERT INTO `core_country` VALUES(204, 'SRI LANKA', 'LK', 0);
INSERT INTO `core_country` VALUES(205, 'SUDAN', 'SD', 0);
INSERT INTO `core_country` VALUES(206, 'SURINAME', 'SR', 0);
INSERT INTO `core_country` VALUES(207, 'SVALBARD AND JAN MAYEN', 'SJ', 0);
INSERT INTO `core_country` VALUES(208, 'SWAZILAND', 'SZ', 0);
INSERT INTO `core_country` VALUES(209, 'SWEDEN', 'SE', 0);
INSERT INTO `core_country` VALUES(210, 'SWITZERLAND', 'CH', 0);
INSERT INTO `core_country` VALUES(211, 'SYRIAN ARAB REPUBLIC', 'SY', 0);
INSERT INTO `core_country` VALUES(212, 'TAIWAN, PROVINCE OF CHINA', 'TW', 0);
INSERT INTO `core_country` VALUES(213, 'TAJIKISTAN', 'TJ', 0);
INSERT INTO `core_country` VALUES(214, 'TANZANIA, UNITED REPUBLIC OF', 'TZ', 0);
INSERT INTO `core_country` VALUES(215, 'THAILAND', 'TH', 0);
INSERT INTO `core_country` VALUES(216, 'TIMOR-LESTE', 'TL', 0);
INSERT INTO `core_country` VALUES(217, 'TOGO', 'TG', 0);
INSERT INTO `core_country` VALUES(218, 'TOKELAU', 'TK', 0);
INSERT INTO `core_country` VALUES(219, 'TONGA', 'TO', 0);
INSERT INTO `core_country` VALUES(220, 'TRINIDAD AND TOBAGO', 'TT', 0);
INSERT INTO `core_country` VALUES(221, 'TUNISIA', 'TN', 0);
INSERT INTO `core_country` VALUES(222, 'TURKEY', 'TR', 0);
INSERT INTO `core_country` VALUES(223, 'TURKMENISTAN', 'TM', 0);
INSERT INTO `core_country` VALUES(224, 'TURKS AND CAICOS ISLANDS', 'TC', 0);
INSERT INTO `core_country` VALUES(225, 'TUVALU', 'TV', 0);
INSERT INTO `core_country` VALUES(226, 'UGANDA', 'UG', 0);
INSERT INTO `core_country` VALUES(227, 'UKRAINE', 'UA', 0);
INSERT INTO `core_country` VALUES(228, 'UNITED ARAB EMIRATES', 'AE', 0);
INSERT INTO `core_country` VALUES(229, 'UNITED KINGDOM', 'GB', 0);
INSERT INTO `core_country` VALUES(230, 'UNITED STATES', 'US', 0);
INSERT INTO `core_country` VALUES(231, 'UNITED STATES MINOR OUTLYING ISLANDS', 'UM', 0);
INSERT INTO `core_country` VALUES(232, 'URUGUAY', 'UY', 0);
INSERT INTO `core_country` VALUES(233, 'UZBEKISTAN', 'UZ', 0);
INSERT INTO `core_country` VALUES(234, 'VANUATU', 'VU', 0);
INSERT INTO `core_country` VALUES(235, 'VATICAN CITY STATE', 'VA', 0);
INSERT INTO `core_country` VALUES(236, 'VENEZUELA', 'VE', 0);
INSERT INTO `core_country` VALUES(237, 'VIET NAM', 'VN', 0);
INSERT INTO `core_country` VALUES(238, 'VIRGIN ISLANDS, BRITISH', 'VG', 0);
INSERT INTO `core_country` VALUES(239, 'VIRGIN ISLANDS, U.S.', 'VI', 0);
INSERT INTO `core_country` VALUES(240, 'WALLIS AND FUTUNA', 'WF', 0);
INSERT INTO `core_country` VALUES(241, 'WESTERN SAHARA', 'EH', 0);
INSERT INTO `core_country` VALUES(242, 'YEMEN', 'YE', 0);
INSERT INTO `core_country` VALUES(243, 'ZAMBIA', 'ZM', 0);
INSERT INTO `core_country` VALUES(244, 'ZIMBABWE', 'ZW', 0);

-- --------------------------------------------------------

--
-- Table structure for table `core_deleted_user`
--

CREATE TABLE `core_deleted_user` (
  `id_deletion` int(11) NOT NULL AUTO_INCREMENT,
  `idst` int(11) NOT NULL DEFAULT '0',
  `userid` varchar(255) NOT NULL DEFAULT '',
  `firstname` varchar(255) NOT NULL DEFAULT '',
  `lastname` varchar(255) NOT NULL DEFAULT '',
  `pass` varchar(50) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `photo` varchar(255) NOT NULL DEFAULT '',
  `avatar` varchar(255) NOT NULL DEFAULT '',
  `signature` text NOT NULL,
  `level` int(11) NOT NULL DEFAULT '0',
  `lastenter` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `valid` tinyint(1) NOT NULL DEFAULT '0',
  `pwd_expire_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `register_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `deletion_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `deleted_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_deletion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_deleted_user`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_event`
--

CREATE TABLE `core_event` (
  `idEvent` int(11) NOT NULL AUTO_INCREMENT,
  `idClass` int(11) NOT NULL DEFAULT '0',
  `module` varchar(50) NOT NULL DEFAULT '',
  `section` varchar(50) NOT NULL DEFAULT '',
  `priority` smallint(1) unsigned NOT NULL DEFAULT '1289',
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`idEvent`),
  KEY `idClass` (`idClass`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_event`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_event_class`
--

CREATE TABLE `core_event_class` (
  `idClass` int(11) NOT NULL AUTO_INCREMENT,
  `class` varchar(50) NOT NULL DEFAULT '',
  `platform` varchar(50) NOT NULL DEFAULT '',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`idClass`),
  UNIQUE KEY `class_2` (`class`),
  KEY `class` (`class`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=41 ;

--
-- Dumping data for table `core_event_class`
--

INSERT INTO `core_event_class` VALUES(1, 'UserNew', 'framework', '');
INSERT INTO `core_event_class` VALUES(2, 'UserMod', 'framework', '');
INSERT INTO `core_event_class` VALUES(3, 'UserDel', 'framework', '');
INSERT INTO `core_event_class` VALUES(4, 'UserNewModerated', 'framework', '');
INSERT INTO `core_event_class` VALUES(5, 'UserGroupModerated', 'framework', '');
INSERT INTO `core_event_class` VALUES(6, 'UserGroupInsert', 'framework', '');
INSERT INTO `core_event_class` VALUES(7, 'UserGroupRemove', 'framework', '');
INSERT INTO `core_event_class` VALUES(8, 'UserCourseInsertModerate', 'lms-a', '');
INSERT INTO `core_event_class` VALUES(9, 'UserCourseInserted', 'lms-a', '');
INSERT INTO `core_event_class` VALUES(10, 'UserCourseRemoved', 'lms-a', '');
INSERT INTO `core_event_class` VALUES(11, 'UserCourseLevelChanged', 'lms-a', '');
INSERT INTO `core_event_class` VALUES(12, 'UserCourseEnded', 'lms-a', '');
INSERT INTO `core_event_class` VALUES(13, 'CoursePorpModified', 'lms-a', '');
INSERT INTO `core_event_class` VALUES(14, 'AdviceNew', 'lms', '');
INSERT INTO `core_event_class` VALUES(15, 'MsgNewReceived', 'lms', '');
INSERT INTO `core_event_class` VALUES(16, 'ForumNewCategory', 'lms', '');
INSERT INTO `core_event_class` VALUES(17, 'ForumNewThread', 'lms', '');
INSERT INTO `core_event_class` VALUES(18, 'ForumNewResponse', 'lms', '');
INSERT INTO `core_event_class` VALUES(38, 'UserApproved', 'framework', '');
INSERT INTO `core_event_class` VALUES(39, 'UserCourseBuy', 'lms', '');
INSERT INTO `core_event_class` VALUES(40, 'SettingUpdate', 'framework', '');

-- --------------------------------------------------------

--
-- Table structure for table `core_event_consumer`
--

CREATE TABLE `core_event_consumer` (
  `idConsumer` int(11) NOT NULL AUTO_INCREMENT,
  `consumer_class` varchar(50) NOT NULL DEFAULT '',
  `consumer_file` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`idConsumer`),
  UNIQUE KEY `consumer_class` (`consumer_class`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Table of consumer with PHP classes and files' AUTO_INCREMENT=6 ;

--
-- Dumping data for table `core_event_consumer`
--

INSERT INTO `core_event_consumer` VALUES(1, 'DoceboUserNotifier', '/lib/lib.usernotifier.php');
INSERT INTO `core_event_consumer` VALUES(2, 'DoceboCourseNotifier', '/lib/lib.coursenotifier.php');
INSERT INTO `core_event_consumer` VALUES(3, 'DoceboOrgchartNotifier', '/lib/lib.orgchartnotifier.php');
INSERT INTO `core_event_consumer` VALUES(5, 'DoceboSettingNotifier', '/lib/lib.settingnotifier.php');

-- --------------------------------------------------------

--
-- Table structure for table `core_event_consumer_class`
--

CREATE TABLE `core_event_consumer_class` (
  `idConsumer` int(11) NOT NULL DEFAULT '0',
  `idClass` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idConsumer`,`idClass`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='n:m relation from consumers and event''s classes';

--
-- Dumping data for table `core_event_consumer_class`
--

INSERT INTO `core_event_consumer_class` VALUES(1, 1);
INSERT INTO `core_event_consumer_class` VALUES(1, 2);
INSERT INTO `core_event_consumer_class` VALUES(1, 3);
INSERT INTO `core_event_consumer_class` VALUES(1, 4);
INSERT INTO `core_event_consumer_class` VALUES(1, 5);
INSERT INTO `core_event_consumer_class` VALUES(1, 6);
INSERT INTO `core_event_consumer_class` VALUES(1, 7);
INSERT INTO `core_event_consumer_class` VALUES(1, 8);
INSERT INTO `core_event_consumer_class` VALUES(1, 9);
INSERT INTO `core_event_consumer_class` VALUES(1, 10);
INSERT INTO `core_event_consumer_class` VALUES(1, 11);
INSERT INTO `core_event_consumer_class` VALUES(1, 12);
INSERT INTO `core_event_consumer_class` VALUES(1, 13);
INSERT INTO `core_event_consumer_class` VALUES(1, 14);
INSERT INTO `core_event_consumer_class` VALUES(1, 15);
INSERT INTO `core_event_consumer_class` VALUES(1, 16);
INSERT INTO `core_event_consumer_class` VALUES(1, 17);
INSERT INTO `core_event_consumer_class` VALUES(1, 18);
INSERT INTO `core_event_consumer_class` VALUES(1, 38);
INSERT INTO `core_event_consumer_class` VALUES(1, 39);
INSERT INTO `core_event_consumer_class` VALUES(2, 3);
INSERT INTO `core_event_consumer_class` VALUES(3, 3);
INSERT INTO `core_event_consumer_class` VALUES(5, 40);

-- --------------------------------------------------------

--
-- Table structure for table `core_event_manager`
--

CREATE TABLE `core_event_manager` (
  `idEventMgr` int(11) NOT NULL AUTO_INCREMENT,
  `idClass` int(11) NOT NULL DEFAULT '0',
  `permission` enum('not_used','mandatory') NOT NULL DEFAULT 'not_used',
  `channel` set('email','sms') NOT NULL DEFAULT 'email',
  `recipients` varchar(255) NOT NULL DEFAULT '',
  `show_level` set('godadmin','admin','user') NOT NULL DEFAULT '',
  PRIMARY KEY (`idEventMgr`),
  UNIQUE KEY `idClass` (`idClass`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=40 ;

--
-- Dumping data for table `core_event_manager`
--

INSERT INTO `core_event_manager` VALUES(1, 1, 'mandatory', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user');
INSERT INTO `core_event_manager` VALUES(2, 2, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user');
INSERT INTO `core_event_manager` VALUES(3, 3, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user');
INSERT INTO `core_event_manager` VALUES(4, 4, 'not_used', 'email', '_EVENT_RECIPIENTS_MODERATORS_GOD', 'godadmin,admin');
INSERT INTO `core_event_manager` VALUES(5, 5, 'not_used', 'email', '_EVENT_RECIPIENTS_MODERATORS_GOD', 'godadmin,admin');
INSERT INTO `core_event_manager` VALUES(6, 6, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user');
INSERT INTO `core_event_manager` VALUES(7, 7, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user');
INSERT INTO `core_event_manager` VALUES(8, 8, 'not_used', 'email', '_EVENT_RECIPIENTS_MODERATORS_GOD', 'godadmin,admin');
INSERT INTO `core_event_manager` VALUES(9, 9, 'not_used', 'email', '_EVENT_RECIPIENTS_TEACHER', 'godadmin,admin,user');
INSERT INTO `core_event_manager` VALUES(10, 10, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user');
INSERT INTO `core_event_manager` VALUES(11, 11, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user');
INSERT INTO `core_event_manager` VALUES(12, 12, 'mandatory', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user');
INSERT INTO `core_event_manager` VALUES(13, 13, 'not_used', 'email', '_EVENT_RECIPIENTS_TEACHER_GOD', 'godadmin,admin,user');
INSERT INTO `core_event_manager` VALUES(14, 14, 'not_used', 'email', '_ALL', 'godadmin,admin,user');
INSERT INTO `core_event_manager` VALUES(15, 15, 'not_used', 'email', '_ALL', 'godadmin,admin,user');
INSERT INTO `core_event_manager` VALUES(16, 16, 'not_used', 'email', '_ALL', 'godadmin,admin,user');
INSERT INTO `core_event_manager` VALUES(17, 17, 'not_used', 'email', '_ALL', 'godadmin,admin,user');
INSERT INTO `core_event_manager` VALUES(18, 18, 'not_used', 'email', '_ALL', 'godadmin,admin,user');
INSERT INTO `core_event_manager` VALUES(38, 38, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user');
INSERT INTO `core_event_manager` VALUES(39, 39, 'not_used', 'email', '_EVENT_RECIPIENTS_USER', 'godadmin,admin,user');

-- --------------------------------------------------------

--
-- Table structure for table `core_event_property`
--

CREATE TABLE `core_event_property` (
  `idEvent` int(11) NOT NULL DEFAULT '0',
  `property_name` varchar(50) NOT NULL DEFAULT '',
  `property_value` text NOT NULL,
  `property_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`idEvent`,`property_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_event_property`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_event_user`
--

CREATE TABLE `core_event_user` (
  `idEventMgr` int(11) NOT NULL DEFAULT '0',
  `idst` int(11) NOT NULL DEFAULT '0',
  `channel` set('email','sms') NOT NULL DEFAULT '',
  PRIMARY KEY (`idEventMgr`,`idst`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_event_user`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_field`
--

CREATE TABLE `core_field` (
  `idField` int(11) NOT NULL AUTO_INCREMENT,
  `id_common` int(11) NOT NULL DEFAULT '0',
  `type_field` varchar(255) NOT NULL DEFAULT '',
  `lang_code` varchar(255) NOT NULL DEFAULT '',
  `translation` varchar(255) NOT NULL DEFAULT '',
  `sequence` int(5) NOT NULL DEFAULT '0',
  `show_on_platform` varchar(255) NOT NULL DEFAULT 'framework,',
  `use_multilang` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idField`),
  KEY `id_common` (`id_common`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_field`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_field_son`
--

CREATE TABLE `core_field_son` (
  `idSon` int(11) NOT NULL AUTO_INCREMENT,
  `idField` int(11) NOT NULL DEFAULT '0',
  `id_common_son` int(11) NOT NULL DEFAULT '0',
  `lang_code` varchar(50) NOT NULL DEFAULT '',
  `translation` varchar(255) NOT NULL DEFAULT '',
  `sequence` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idSon`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_field_son`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_field_type`
--

CREATE TABLE `core_field_type` (
  `type_field` varchar(255) NOT NULL DEFAULT '',
  `type_file` varchar(255) NOT NULL DEFAULT '',
  `type_class` varchar(255) NOT NULL DEFAULT '',
  `type_category` varchar(255) NOT NULL DEFAULT 'standard',
  PRIMARY KEY (`type_field`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_field_type`
--

INSERT INTO `core_field_type` VALUES('codicefiscale', 'class.cf.php', 'Field_Cf', 'standard');
INSERT INTO `core_field_type` VALUES('country', 'class.country.php', 'Field_Country', 'standard');
INSERT INTO `core_field_type` VALUES('date', 'class.date.php', 'Field_Date', 'standard');
INSERT INTO `core_field_type` VALUES('dropdown', 'class.dropdown.php', 'Field_Dropdown', 'standard');
INSERT INTO `core_field_type` VALUES('freetext', 'class.freetext.php', 'Field_Freetext', 'standard');
INSERT INTO `core_field_type` VALUES('textfield', 'class.textfield.php', 'Field_Textfield', 'standard');
INSERT INTO `core_field_type` VALUES('upload', 'class.upload.php', 'Field_Upload', 'standard');
INSERT INTO `core_field_type` VALUES('yesno', 'class.yesno.php', 'Field_Yesno', 'standard');

-- --------------------------------------------------------

--
-- Table structure for table `core_field_userentry`
--

CREATE TABLE `core_field_userentry` (
  `id_common` varchar(11) NOT NULL DEFAULT '',
  `id_common_son` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `user_entry` text NOT NULL,
  PRIMARY KEY (`id_common`,`id_common_son`,`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_field_userentry`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_fncrole`
--

CREATE TABLE `core_fncrole` (
  `id_fncrole` int(10) unsigned NOT NULL DEFAULT '0',
  `id_group` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_fncrole`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_fncrole`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_fncrole_competence`
--

CREATE TABLE `core_fncrole_competence` (
  `id_fncrole` int(10) unsigned NOT NULL DEFAULT '0',
  `id_competence` int(10) unsigned NOT NULL DEFAULT '0',
  `score` int(10) unsigned NOT NULL DEFAULT '0',
  `expiration` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_fncrole`,`id_competence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_fncrole_competence`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_fncrole_group`
--

CREATE TABLE `core_fncrole_group` (
  `id_group` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_fncrole_group`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_fncrole_group_lang`
--

CREATE TABLE `core_fncrole_group_lang` (
  `id_group` int(10) unsigned NOT NULL DEFAULT '0',
  `lang_code` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  PRIMARY KEY (`id_group`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_fncrole_group_lang`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_fncrole_lang`
--

CREATE TABLE `core_fncrole_lang` (
  `id_fncrole` int(10) unsigned NOT NULL DEFAULT '0',
  `lang_code` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  PRIMARY KEY (`id_fncrole`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_fncrole_lang`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_group`
--

CREATE TABLE `core_group` (
  `idst` int(11) NOT NULL DEFAULT '0',
  `groupid` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `hidden` enum('true','false') NOT NULL DEFAULT 'false',
  `type` enum('free','moderate','private','invisible','course','company') NOT NULL DEFAULT 'free',
  `show_on_platform` text NOT NULL,
  PRIMARY KEY (`idst`),
  UNIQUE KEY `groupid` (`groupid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_group`
--

INSERT INTO `core_group` VALUES(1, '/oc_0', 'Root of organization chart', 'true', 'free', '');
INSERT INTO `core_group` VALUES(2, '/ocd_0', 'Root of organization chart and descendants', 'true', 'free', '');
INSERT INTO `core_group` VALUES(3, '/framework/level/godadmin', 'Group of godadmins', 'true', 'free', '');
INSERT INTO `core_group` VALUES(4, '/framework/level/admin', 'Group of administrators', 'true', 'free', '');
INSERT INTO `core_group` VALUES(5, '/framework/level/publicadmin', 'Group of public admin', 'true', 'free', '');
INSERT INTO `core_group` VALUES(6, '/framework/level/user', 'Group of normal users', 'true', 'free', '');
INSERT INTO `core_group` VALUES(301, '/lms/custom/11/7', 'for custom lms menu', 'true', 'free', '');
INSERT INTO `core_group` VALUES(302, '/lms/custom/11/6', 'for custom lms menu', 'true', 'free', '');
INSERT INTO `core_group` VALUES(303, '/lms/custom/11/5', 'for custom lms menu', 'true', 'free', '');
INSERT INTO `core_group` VALUES(304, '/lms/custom/11/4', 'for custom lms menu', 'true', 'free', '');
INSERT INTO `core_group` VALUES(305, '/lms/custom/11/3', 'for custom lms menu', 'true', 'free', '');
INSERT INTO `core_group` VALUES(306, '/lms/custom/11/2', 'for custom lms menu', 'true', 'free', '');
INSERT INTO `core_group` VALUES(307, '/lms/custom/11/1', 'for custom lms menu', 'true', 'free', '');
INSERT INTO `core_group` VALUES(10893, '/lms/custom/21/7', 'for custom lms menu', 'true', 'free', '');
INSERT INTO `core_group` VALUES(10894, '/lms/custom/21/6', 'for custom lms menu', 'true', 'free', '');
INSERT INTO `core_group` VALUES(10895, '/lms/custom/21/5', 'for custom lms menu', 'true', 'free', '');
INSERT INTO `core_group` VALUES(10896, '/lms/custom/21/4', 'for custom lms menu', 'true', 'free', '');
INSERT INTO `core_group` VALUES(10897, '/lms/custom/21/3', 'for custom lms menu', 'true', 'free', '');
INSERT INTO `core_group` VALUES(10898, '/lms/custom/21/2', 'for custom lms menu', 'true', 'free', '');
INSERT INTO `core_group` VALUES(10899, '/lms/custom/21/1', 'for custom lms menu', 'true', 'free', '');

-- --------------------------------------------------------

--
-- Table structure for table `core_group_fields`
--

CREATE TABLE `core_group_fields` (
  `idst` int(11) NOT NULL DEFAULT '0',
  `id_field` int(11) NOT NULL DEFAULT '0',
  `mandatory` enum('true','false') NOT NULL DEFAULT 'false',
  `useraccess` enum('noaccess','readonly','readwrite') NOT NULL DEFAULT 'readonly',
  `user_inherit` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`idst`,`id_field`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_group_fields`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_group_members`
--

CREATE TABLE `core_group_members` (
  `idst` int(11) NOT NULL DEFAULT '0',
  `idstMember` int(11) NOT NULL DEFAULT '0',
  `filter` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`idst`,`idstMember`),
  KEY `idstMember` (`idstMember`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_group_members`
--

INSERT INTO `core_group_members` VALUES(1, 11836, '');
INSERT INTO `core_group_members` VALUES(3, 11836, '');

-- --------------------------------------------------------

--
-- Table structure for table `core_group_user_waiting`
--

CREATE TABLE `core_group_user_waiting` (
  `idst_group` int(11) NOT NULL DEFAULT '0',
  `idst_user` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idst_group`,`idst_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_group_user_waiting`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_hteditor`
--

CREATE TABLE `core_hteditor` (
  `hteditor` varchar(255) NOT NULL DEFAULT '',
  `hteditorname` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`hteditor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_hteditor`
--

INSERT INTO `core_hteditor` VALUES('textarea', '_TEXTAREA');
INSERT INTO `core_hteditor` VALUES('tinymce', '_TINYMCE');
INSERT INTO `core_hteditor` VALUES('yui', '_YUI');

-- --------------------------------------------------------

--
-- Table structure for table `core_lang_language`
--

CREATE TABLE `core_lang_language` (
  `lang_code` varchar(50) NOT NULL DEFAULT '',
  `lang_description` varchar(255) NOT NULL DEFAULT '',
  `lang_browsercode` varchar(50) NOT NULL DEFAULT '',
  `lang_direction` enum('ltr','rtl') NOT NULL DEFAULT 'ltr',
  PRIMARY KEY (`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_lang_language`
--

INSERT INTO `core_lang_language` VALUES('english', 'English', 'en; en-us', 'ltr');

-- --------------------------------------------------------

--
-- Table structure for table `core_lang_text`
--

CREATE TABLE `core_lang_text` (
  `id_text` int(11) NOT NULL AUTO_INCREMENT,
  `text_key` varchar(50) NOT NULL DEFAULT '',
  `text_module` varchar(50) NOT NULL DEFAULT '',
  `text_attributes` set('accessibility','sms','email') NOT NULL DEFAULT '',
  PRIMARY KEY (`id_text`),
  UNIQUE KEY `text_key` (`text_key`,`text_module`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2403 ;

--
-- Dumping data for table `core_lang_text`
--

INSERT INTO `core_lang_text` VALUES(1, '_ADMIN_ASSIGNTREEDESCR', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(2, '_ADMIN_MANAGMENT', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(3, '_ADMIN_MANAGMENT_CAPTION', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(4, '_ADMIN_MANAGMENT_SUMMARY', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(5, '_ADMIN_MENU', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(6, '_ADMIN_PREFERENCES_TITLE', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(7, '_ADMIN_RULES', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(8, '_ADMIN_SPECIAL_SETTING', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(9, '_DIRECT_COURSE_SUBSCRIBE', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(10, '_DIRECT_USER_INSERT', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(11, '_LANG_SETTING', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(12, '_LIMIT_COURSE_SUBSCRIBE', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(13, '_LIMIT_USER_INSERT', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(14, '_MANAGE_SUBSCRIPTION', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(15, '_MAX_COURSE_SUBSCRIBE', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(16, '_MAX_USER_INSERT', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(17, '_SELECT_LANG_TO_ASSIGN', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(18, '_SPECIAL_SETTING', 'adminrules', '');
INSERT INTO `core_lang_text` VALUES(19, '_PAPER_TEST', 'admin_date', '');
INSERT INTO `core_lang_text` VALUES(20, '_WEB_TEST', 'admin_date', '');
INSERT INTO `core_lang_text` VALUES(21, '_ACCEPT', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(22, '_APPROVED_USER_SBJ', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(23, '_ASSIGNED_EXTRAFIELD', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(24, '_DECLINE', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(25, '_DIRECOTRY_SELFREGISTERED', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(26, '_DIRECTORY_/framework/level/admin', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(27, '_DIRECTORY_/framework/level/godadmin', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(28, '_DIRECTORY_/framework/level/publicadmin', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(29, '_DIRECTORY_/framework/level/user', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(30, '_DIRECTORY_ASSIGNFIELDGROUP', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(31, '_DIRECTORY_FILTER_email', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(32, '_DIRECTORY_FILTER_firstname', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(33, '_DIRECTORY_FILTER_FLATMODE', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(34, '_DIRECTORY_FILTER_language', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(35, '_DIRECTORY_FILTER_lastname', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(36, '_DIRECTORY_FILTER_pass', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(37, '_DIRECTORY_FILTER_register_date', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(38, '_DIRECTORY_FILTER_templatename', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(39, '_DIRECTORY_FILTER_userid', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(40, '_DIRECTORY_FULLNAME', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(41, '_DIRECTORY_GROUPID', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(42, '_DIRECTORY_GROUPTYPE', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(43, '_DIRECTORY_GROUPTYPE_FREE', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(44, '_DIRECTORY_GROUPTYPE_INVISIBLE', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(45, '_DIRECTORY_GROUPTYPE_INVISIBLE_ALT', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(46, '_DIRECTORY_GROUPTYPE_MODERATE', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(47, '_DIRECTORY_GROUPTYPE_MODERATE_ALT', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(48, '_DIRECTORY_GROUPTYPE_PRIVATE', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(49, '_DIRECTORY_GROUPTYPE_PRIVATE_ALT', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(50, '_DIRECTORY_GROUPWAIT_ACCORDECLINE', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(51, '_DIRECTORY_GROUP_FIELD_WRITE', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(52, '_DIRECTORY_ITEMID', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(53, '_DIRECTORY_MEMBERTYPE', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(54, '_DIRECTORY_MEMBERTYPETREE', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(55, '_DIRECTORY_MEMBERTYPEUSER', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(56, '_DIRECTORY_ORGVIEWTITLE', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(57, '_FORCE_PASSWORD_CHANGE', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(58, '_GROUP_FIELD_NORMAL', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(59, '_GROUP_USER_IMPORT_CHARSET', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(60, '_GROUP_USER_IMPORT_FILE', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(61, '_GROUP_USER_IMPORT_HEADER', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(62, '_GROUP_USER_IMPORT_SEPARATOR', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(63, '_LASTNAME_FIRSTNAME', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(64, '_REFUSED_USER_TEXT_SMS', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(65, '_REFUSE_USER', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(66, '_REFUSE_USER_TITLE', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(67, '_SIMPLE_FILTER', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(68, '_WAITING_USER_SUMMARY', 'admin_directory', '');
INSERT INTO `core_lang_text` VALUES(69, '_BLANKLANG_CODE', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(70, '_CLEAN_LANG', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(71, '_CLEAR', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(72, '_DIRECTION_LTR', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(73, '_DIRECTION_RTL', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(74, '_DO_NOT_ADD_MISS', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(75, '_EXPORTG', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(76, '_EXPORT_DIFF', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(77, '_LANG_ACCESSIBILITY', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(78, '_LANG_ADDKEY', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(79, '_LANG_ALL', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(80, '_LANG_ALLMODULES', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(81, '_LANG_ATTRIBUTES', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(82, '_LANG_BROWSERCODE', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(83, '_LANG_CHARSET', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(84, '_LANG_CODE', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(85, '_LANG_COMPARE', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(86, '_LANG_DIRECTION', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(87, '_LANG_KEY', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(88, '_LANG_MODULE', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(89, '_LANG_NEWMODULE', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(90, '_LANG_TRANSLATION', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(91, '_LANG_TRAN_COMPARE', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(92, '_MODULES_UPDATED', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(93, '_NOIMPORT', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(94, '_NUM_TRAD', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(95, '_ONLY_EMPTY', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(96, '_ORIENTATION', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(97, '_OVERWRITE_EXISTENT', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(98, '_PERC_TRAD', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(99, '_TOTAL_LANGUAGE_UPDATED', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(100, '_TRANSALTIONTABLEFOR', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(101, '_TRANSLATELANG', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(102, '_TRANSLATELANGG', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(103, '_TRANSLATION_COTAINS', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(104, '_YESIMPORT', 'admin_lang', '');
INSERT INTO `core_lang_text` VALUES(105, '_CHOOSE_WHO_CAN_SEE', 'admin_news', '');
INSERT INTO `core_lang_text` VALUES(106, '_LONG_DESCR', 'admin_news', '');
INSERT INTO `core_lang_text` VALUES(107, '_NEWSINHOMEPAGE', 'admin_news', '');
INSERT INTO `core_lang_text` VALUES(108, '_NEWS_SUMMARY', 'admin_news', '');
INSERT INTO `core_lang_text` VALUES(109, '_TITLE_IMPORTANT', 'admin_news', '');
INSERT INTO `core_lang_text` VALUES(110, '_ANY', 'admin_newsletter', '');
INSERT INTO `core_lang_text` VALUES(111, '_NEWSLETTER_WILL_BE_SENT_TO', 'admin_newsletter', '');
INSERT INTO `core_lang_text` VALUES(112, '_SEC_OF_PAUSE', 'admin_newsletter', '');
INSERT INTO `core_lang_text` VALUES(113, '_SEND_SMS', 'admin_newsletter', '');
INSERT INTO `core_lang_text` VALUES(114, '_ADD_WEBPAGES', 'admin_webpages', '');
INSERT INTO `core_lang_text` VALUES(115, '_ALT_HOME', 'admin_webpages', '');
INSERT INTO `core_lang_text` VALUES(116, '_TITLE_HOME', 'admin_webpages', '');
INSERT INTO `core_lang_text` VALUES(117, '_TITLE_WEBPAGES', 'admin_webpages', '');
INSERT INTO `core_lang_text` VALUES(118, '_WEBPAGES_CAPTION', 'admin_webpages', '');
INSERT INTO `core_lang_text` VALUES(119, '_ADD_ADVICE', 'advice', '');
INSERT INTO `core_lang_text` VALUES(120, '_ADVICE', 'advice', '');
INSERT INTO `core_lang_text` VALUES(121, '_ALT_ARCHIVE', 'advice', '');
INSERT INTO `core_lang_text` VALUES(122, '_ARCHIVE_THIS_ADVICE', 'advice', '');
INSERT INTO `core_lang_text` VALUES(123, '_CHOOSE_READER', 'advice', '');
INSERT INTO `core_lang_text` VALUES(124, '_MANUAL_USER_SEL', 'advice', '');
INSERT INTO `core_lang_text` VALUES(125, '_YOUONLY', 'advice', '');
INSERT INTO `core_lang_text` VALUES(126, '_APR', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(127, '_APRIL', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(128, '_AUG', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(129, '_AUGUST', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(130, '_CAL_TITLE', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(131, '_DAY_FIRST', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(132, '_DEC', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(133, '_DECEMBER', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(134, '_DEF_DATE_FORMAT', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(135, '_FEB', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(136, '_FEBRUARY', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(137, '_FRI', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(138, '_FRIDAY', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(139, '_GENERIC', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(140, '_GO_TODAY', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(141, '_JAN', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(142, '_JANUARY', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(143, '_JUL', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(144, '_JULY', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(145, '_JUN', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(146, '_JUNE', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(147, '_MAR', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(148, '_MARCH', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(149, '_MAY', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(150, '_MEETING', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(151, '_MON', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(152, '_MONDAY', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(153, '_NEXT_MONTH', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(154, '_NEXT_YEAR', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(155, '_NOV', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(156, '_NOVEMBER', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(157, '_OCT', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(158, '_OCTOBER', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(159, '_PART_TODAY', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(160, '_PLS_WAIT', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(161, '_PREV_MONTH', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(162, '_PREV_YEAR', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(163, '_PRIVATE', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(164, '_PUBLIC', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(165, '_PUBLISHING', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(166, '_SAT', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(167, '_SATURDAY', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(168, '_SEP', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(169, '_SEPTEMBER', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(170, '_SUN', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(171, '_SUNDAY', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(172, '_THU', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(173, '_THURSDAY', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(174, '_TIME', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(175, '_TODAY', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(176, '_TT_DATE_FORMAT', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(177, '_TUE', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(178, '_TUESDAY', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(179, '_WED', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(180, '_WEDNESDAY', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(181, '_WEEKEND', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(182, '_WK', 'calendar', '');
INSERT INTO `core_lang_text` VALUES(183, '_ADD_TO_CART', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(184, '_CAREER', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(185, '_CATALOGUE_SELECTION', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(186, '_CATALOGUE_SUMMARY', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(187, '_CERT_RELESABLE', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(188, '_CLASSROOM_LOCATION', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(189, '_COURSEPATH_INTRO', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(190, '_COURSEPATH_LIST', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(191, '_COURSE_AS', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(192, '_COURSE_BEGIN', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(193, '_COURSE_END', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(194, '_COURSE_EXPIRING', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(195, '_COURSE_LIST_SUMMARY', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(196, '_COURSE_SUBSCRIPTION', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(197, '_COURSE_S_GODADMIN', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(198, '_COURSE_TYPE', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(199, '_COURSE_YOU_CAN_ACCESS', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(200, '_ENTRY_CAPTION', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(201, '_ENTRY_SUMMARY', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(202, '_FILTER_DATE_BEGIN', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(203, '_FILTER_FOR_COURSE_TYPE', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(204, '_FILTER_FOR_SALE', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(205, '_IMPORT_NEW_ENTRY', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(206, '_METHOD_MANUAL', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(207, '_MOD_ENTRY_CATALOGUE', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(208, '_NEW_CATALOGUE', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(209, '_NO_COURSE', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(210, '_NO_COURSE_FOUND', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(211, '_NO_EDITIONS', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(212, '_PREASSESSMENT_SUGGESTION', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(213, '_REMOVE_ENTRY', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(214, '_RESERVE_COURSE', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(215, '_SHOPPING_CART', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(216, '_SUBSCRIBE_COURSE_T', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(217, '_TAB_VIEW_CATEGORY', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(218, '_TAB_VIEW_MOSTPOPULAR', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(219, '_TAB_VIEW_RECENT', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(220, '_TOTAL_COURSE', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(221, '_WAITING_APPROVAL', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(222, '_WORD_TO_SEARCH', 'catalogue', '');
INSERT INTO `core_lang_text` VALUES(223, '_ALT_REM_META_CERT', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(224, '_ALT_TAKE_A_COPY', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(225, '_BACK_IMAGE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(226, '_BASE_LANGUAGE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(227, '_CERTIFICATE_CAPTION', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(228, '_CERTIFICATE_LIST', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(229, '_CERTIFICATE_REPORT', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(230, '_CERTIFICATE_SUMMARY', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(231, '_CERTIFICATE_VIEW_CAPTION', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(232, '_CERTIFICATE_WARNING', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(233, '_CHOOSE_CERTIFICATE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(234, '_CHOOSE_COURSE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(235, '_COURSE_BEGIN', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(236, '_COURSE_DESCRIPTION', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(237, '_COURSE_END', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(238, '_COURSE_SCORE_FINAL_MAX', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(239, '_COURSE_TODAY', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(240, '_COURSE_YEAR', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(241, '_DATE_COMPLETE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(242, '_DATE_ENROLL', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(243, '_DISPLAY_NAME', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(244, '_EX_CERT_POINT_REQUIRED', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(245, '_GENERATE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(246, '_GENERATE_ALL_SELECTED', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(247, '_LANDSCAPE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(248, '_META_CERTIFICATE_ASSIGN_CAPTION', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(249, '_META_CERTIFICATE_CAPTION', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(250, '_META_CERTIFICATE_CREATE_CAPTION', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(251, '_META_CERTIFICATE_DETAILS_CAPTION', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(252, '_META_CERTIFICATE_NEW_ASSIGN_CAPTION', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(253, '_META_CERTIFICATE_NEW_ASSIGN_SUMMARY', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(254, '_META_CERTIFICATE_PROGRESS', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(255, '_META_CERTIFICATE_SUMMARY', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(256, '_MY_CERTIFICATE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(257, '_NEW_ASSING_META_CERTIFICATE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(258, '_NEW_CERTIFICATE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(259, '_NOT_ENDED', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(260, '_NO_CERT_AVAILABLE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(261, '_NO_USER_FOR_CERTIFICATE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(262, '_NO_USER_FOUND', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(263, '_NUMBER_OF_CERTIFICATE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(264, '_ORIENTATION', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(265, '_PORTRAIT', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(266, '_RELASE_DATE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(267, '_RELEASED', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(268, '_STOP', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(269, '_STRUCTURE_CERTIFICATE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(270, '_STRUCTURE_META_CERTIFICATE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(271, '_TABLE_COURSE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(272, '_TAG_CODE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(273, '_TAG_DESCRIPTION', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(274, '_TAG_LIST_CAPTION', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(275, '_TAG_LIST_SUMMARY', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(276, '_TAKE_A_COPY', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(277, '_TEMPLATE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(278, '_TEST_SCORE_FINAL', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(279, '_TEST_SCORE_FINAL_MAX', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(280, '_TEST_SCORE_START', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(281, '_TEST_SCORE_START_MAX', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(282, '_TITLE_ASSIGN_META_CERTIFICATE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(283, '_TITLE_CERTIFICATE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(284, '_TITLE_CREATE_META_CERTIFICATE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(285, '_TITLE_META_CERTIFICATE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(286, '_TITLE_META_CERTIFICATE_ASSIGN', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(287, '_TITLE_META_CERTIFICATE_CREATE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(288, '_TITLE_META_CERTIFICATE_DELETING', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(289, '_TITLE_VIEW_CERT', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(290, '_TOTAL_TIME', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(291, '_TOTAL_TIME_HOUR', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(292, '_TOTAL_TIME_MINUTE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(293, '_TOTAL_TIME_SECOND', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(294, '_TO_RELEASE', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(295, '_USER_FOR_META_CERTIFICATE_ASSIGN', 'certificate', '');
INSERT INTO `core_lang_text` VALUES(296, '_CHAT_DESCRIPTION', 'chat', '');
INSERT INTO `core_lang_text` VALUES(297, '_OPENCHAT', 'chat', '');
INSERT INTO `core_lang_text` VALUES(298, '_OPENCHAT_WA', 'chat', '');
INSERT INTO `core_lang_text` VALUES(299, '_AVAILABLE_INSTRUMENT', 'classroom', '');
INSERT INTO `core_lang_text` VALUES(300, '_BUILDING_ROOM', 'classroom', '');
INSERT INTO `core_lang_text` VALUES(301, '_CAPACITY', 'classroom', '');
INSERT INTO `core_lang_text` VALUES(302, '_CITY', 'classroom', '');
INSERT INTO `core_lang_text` VALUES(303, '_DISPOSITION', 'classroom', '');
INSERT INTO `core_lang_text` VALUES(304, '_FAX', 'classroom', '');
INSERT INTO `core_lang_text` VALUES(305, '_INSTRUMENT', 'classroom', '');
INSERT INTO `core_lang_text` VALUES(306, '_PHONE', 'classroom', '');
INSERT INTO `core_lang_text` VALUES(307, '_PHOTO', 'classroom', '');
INSERT INTO `core_lang_text` VALUES(308, '_RESPONSABLE', 'classroom', '');
INSERT INTO `core_lang_text` VALUES(309, '_STATE', 'classroom', '');
INSERT INTO `core_lang_text` VALUES(310, '_STREET', 'classroom', '');
INSERT INTO `core_lang_text` VALUES(311, '_ZIP_CODE', 'classroom', '');
INSERT INTO `core_lang_text` VALUES(312, '_CODE_LIST', 'code', '');
INSERT INTO `core_lang_text` VALUES(313, '_CODE_USED_NUMBER', 'code', '');
INSERT INTO `core_lang_text` VALUES(314, '_UNLIMITED_USE', 'code', '');
INSERT INTO `core_lang_text` VALUES(315, '_USED', 'code', '');
INSERT INTO `core_lang_text` VALUES(316, '_ADD_COMPETENCE', 'competences', '');
INSERT INTO `core_lang_text` VALUES(317, '_ASSIGN_USER_TITLE', 'competences', '');
INSERT INTO `core_lang_text` VALUES(318, '_COMPETENCES_REQUIRED', 'competences', '');
INSERT INTO `core_lang_text` VALUES(319, '_COMPETENCES_TYPOLOGY_ATTITUDE', 'competences', '');
INSERT INTO `core_lang_text` VALUES(320, '_COMPETENCES_TYPOLOGY_KNOWLEDGE', 'competences', '');
INSERT INTO `core_lang_text` VALUES(321, '_COMPETENCES_TYPOLOGY_SKILL', 'competences', '');
INSERT INTO `core_lang_text` VALUES(322, '_COMPETENCES_USER_TAB_CAPTION', 'competences', '');
INSERT INTO `core_lang_text` VALUES(323, '_COMPETENCE_OBTAINED', 'competences', '');
INSERT INTO `core_lang_text` VALUES(324, '_DATE_OBTAINED', 'competences', '');
INSERT INTO `core_lang_text` VALUES(325, '_EXPIRATION_DAYS', 'competences', '');
INSERT INTO `core_lang_text` VALUES(326, '_TYPE_FLAG', 'competences', '');
INSERT INTO `core_lang_text` VALUES(327, '_AT_HOUR', 'conference', '');
INSERT INTO `core_lang_text` VALUES(328, '_CONFERENCE_NAME', 'conference', '');
INSERT INTO `core_lang_text` VALUES(329, '_CONFERENCE_SYSTEM', 'conference', '');
INSERT INTO `core_lang_text` VALUES(330, '_MAX_PARTICIPANTS', 'conference', '');
INSERT INTO `core_lang_text` VALUES(331, '_MEETING_HOURS', 'conference', '');
INSERT INTO `core_lang_text` VALUES(332, '_NO_MORE_ROOM', 'conference', '');
INSERT INTO `core_lang_text` VALUES(333, '_NO_ROOM_AVAILABLE', 'conference', '');
INSERT INTO `core_lang_text` VALUES(334, '_ROOMS_AVAILABLE', 'conference', '');
INSERT INTO `core_lang_text` VALUES(335, '_SUMMARY_ROOM_AVAILABLE', 'conference', '');
INSERT INTO `core_lang_text` VALUES(336, '_ACCESSIBILITY', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(337, '_ALLOW_URL_INCLUDE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(338, '_API', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(339, '_API_SSO', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(340, '_ASK_FOR_CODE_MODULE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(341, '_ASK_FOR_DROPDOWN_TREE_CODE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(342, '_ASK_FOR_MANUAL_TREE_CODE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(343, '_ASK_FOR_TREE_COURSE_CODE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(344, '_CODE_TELESKILL', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(345, '_COMMON_ADMIN_SESSION', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(346, '_CONFERENCE_CREATION_LIMIT_PER_USER', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(347, '_CONFIGURATION', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(348, '_CONF_GLOBAL', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(349, '_CONF_LMS', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(350, '_COURSE_QUOTA', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(351, '_CURRENCY_SYMBOL', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(352, '_DEBUG', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(353, '_DEFAULTTEMPLATE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(354, '_DIMDIM_MAX_MIKES', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(355, '_DIMDIM_MAX_PARTICIPANT', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(356, '_DIMDIM_MAX_ROOM', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(357, '_DIMDIM_PASSWORD', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(358, '_DIMDIM_PORT', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(359, '_DIMDIM_SERVER', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(360, '_DIMDIM_USER', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(361, '_DOMXML', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(362, '_DONT_SHOW', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(363, '_DO_DEBUG', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(364, '_ECOMMERCE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(365, '_FIRST_CATALOGUE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(366, '_FORUM_AS_TABLE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(367, '_FTPERR', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(368, '_FTPOK', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(369, '_GOOGLE_STAT_CODE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(370, '_GOOGLE_STAT_IN_LMS', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(371, '_HOUR_REQUEST_LIMIT', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(372, '_HTEDITOR', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(373, '_HTMLEDIT_IMAGE_ADMIN', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(374, '_HTMLEDIT_IMAGE_GODADMIN', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(375, '_HTMLEDIT_IMAGE_USER', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(376, '_KB_FILTER_BY_USER_ACCESS', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(377, '_KB_SHOW_UNCATEGORIZED', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(378, '_LANG_CHECK', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(379, '_LASTFIRST_MANDATORY', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(380, '_LDAP', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(381, '_LDAP_PORT', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(382, '_LDAP_SERVER', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(383, '_LDAP_USED', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(384, '_LDAP_USER_STRING', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(385, '_MAGIC_QUOTES_GPC', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(386, '_MAIL_SENDER', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(387, '_MAIN_OPTIONS', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(388, '_MANDATORY_CODE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(389, '_MAX_EXECUTION_TIME', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(390, '_MAX_LOG_ATTEMPT', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(391, '_MYSQL_COLLATION', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(392, '_MYSQL_ENCODING', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(393, '_MYSQL_MODE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(394, '_MYSQL_VERS', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(395, '_NL_SENDPAUSE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(396, '_NL_SENDPERCYCLE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(397, '_NOTSCORM', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(398, '_NO_ANSWER_IN_POLL', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(399, '_NO_ANSWER_IN_TEST', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(400, '_ON_CATALOGUE_EMPTY', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(401, '_ORG_NAME_TELESKILL', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(402, '_PAGE_TITLE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(403, '_PASS_ALFANUMERIC', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(404, '_PASS_CHANGE_FIRST_LOGIN', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(405, '_PASS_MAX_TIME_VALID', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(406, '_PASS_MIN_CHAR', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(407, '_PATH', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(408, '_PATHCHAT', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(409, '_PATHCOURSE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(410, '_PATHFIELD', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(411, '_PATHFORUM', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(412, '_PATHLESSON', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(413, '_PATHMESSAGE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(414, '_PATHPHOTO', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(415, '_PATHPRJ', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(416, '_PATHSCORM', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(417, '_PATHSPONSOR', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(418, '_PATHTEST', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(419, '_PAYPAL_CURRENCY', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(420, '_PAYPAL_MAIL', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(421, '_PAYPAL_SANDBOX', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(422, '_PHPINFO', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(423, '_PHPVERSION', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(424, '_POST_MAX_SIZE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(425, '_PRIVACY_POLICY', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(426, '_PROFILE_ONLY_PWD', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(427, '_REGISTER_DELETED_USER', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(428, '_REGISTER_GLOBAL', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(429, '_REGISTER_TYPE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(430, '_REGISTER_TYPE_ADMIN', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(431, '_REGISTER_TYPE_MODERATE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(432, '_REGISTER_TYPE_SELF', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(433, '_REGISTRATION_CODE_TYPE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(434, '_REQUEST_MANDATORY_FIELDS_COMPILATION', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(435, '_REST_AUTH_CODE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(436, '_REST_AUTH_LIFETIME', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(437, '_REST_AUTH_METHOD', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(438, '_REST_AUTH_TOKEN', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(439, '_REST_AUTH_UPDATE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(440, '_SAFEMODE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(441, '_SAVE_LA_AFTER_MAX', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(442, '_SAVE_LA_ALL', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(443, '_SAVE_LOG_ATTEMPT', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(444, '_SCO_DIRECT_PLAY', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(445, '_SECURITY', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(446, '_SENDER_EVENT', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(447, '_SEND_CC_FOR_SYSTEM_EMAILS', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(448, '_SERVERINFO', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(449, '_SERVER_ADDR', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(450, '_SERVER_ADMIN', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(451, '_SERVER_MYSQL', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(452, '_SERVER_NAME', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(453, '_SERVER_PORT', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(454, '_SERVER_SOFTWARE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(455, '_SESSION_IP_CONTROL', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(456, '_SHOW_AS_BLOCK', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(457, '_SHOW_AS_LINK', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(458, '_SMS', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(459, '_SMSMARKET_LOGO', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(460, '_SMS_BUY_RECHARGE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(461, '_SMS_CELL_NUM_FIELD', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(462, '_SMS_CREDIT', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(463, '_SMS_CREDIT_UPDATE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(464, '_SMS_GATEWAY_1', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(465, '_SMS_GATEWAY_2', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(466, '_SMS_GATEWAY_3', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(467, '_SMS_GATEWAY_4', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(468, '_SMS_GATEWAY_AUTO', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(469, '_SMS_GATEWAY_HOST', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(470, '_SMS_GATEWAY_ID', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(471, '_SMS_GATEWAY_PASS', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(472, '_SMS_GATEWAY_PORT', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(473, '_SMS_GATEWAY_USER', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(474, '_SMS_INTERNATIONAL_PREFIX', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(475, '_SMS_SENT_FROM', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(476, '_SOCIAL', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(477, '_SOCIAL_FB_ACTIVE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(478, '_SOCIAL_FB_API', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(479, '_SOCIAL_FB_SECRET', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(480, '_SOCIAL_GOOGLE_ACTIVE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(481, '_SOCIAL_LINKEDIN_ACCESS', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(482, '_SOCIAL_LINKEDIN_ACTIVE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(483, '_SOCIAL_LINKEDIN_SECRET', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(484, '_SOCIAL_TWITTER_ACTIVE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(485, '_SOCIAL_TWITTER_CONSUMER', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(486, '_SOCIAL_TWITTER_SECRET', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(487, '_SSO_SECRET', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(488, '_SSO_TOKEN', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(489, '_STOP_CONCURRENT_USER', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(490, '_TABLIST_MYCOURSES', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(491, '_TELESKILL_MAX_PARTICIPANT', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(492, '_TELESKILL_MAX_ROOM', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(493, '_TRACKING', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(494, '_TTLSESSION', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(495, '_UPLOADFTP', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(496, '_UPLOAD_MAX_FILESIZE', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(497, '_URL', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(498, '_URL_CHECKIN_TELESKILL', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(499, '_URL_VIDEOCONFERENCE_TELESKILL', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(500, '_USEFULL_ONLY_IF', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(501, '_USER_PWD_HISTORY_LENGTH', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(502, '_USER_QUOTA', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(503, '_USE_ADVANCED_FORM', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(504, '_USE_DIMDIM_API', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(505, '_USE_REST_API', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(506, '_USE_TAG', 'configuration', '');
INSERT INTO `core_lang_text` VALUES(507, '_ADDFILE', 'course', '');
INSERT INTO `core_lang_text` VALUES(508, '_ADDFILES', 'course', '');
INSERT INTO `core_lang_text` VALUES(509, '_ADD_SUBSCRIBE', 'course', '');
INSERT INTO `core_lang_text` VALUES(510, '_ADVERT_ADVICE', 'course', '');
INSERT INTO `core_lang_text` VALUES(511, '_ADVERT_FORUM', 'course', '');
INSERT INTO `core_lang_text` VALUES(512, '_ADVERT_LOBJ', 'course', '');
INSERT INTO `core_lang_text` VALUES(513, '_ALLOW_OVERBOOKING', 'course', '');
INSERT INTO `core_lang_text` VALUES(514, '_ALL_OPEN', 'course', '');
INSERT INTO `core_lang_text` VALUES(515, '_ASSIGN_FOR_ALL_STATUS', 'course', '');
INSERT INTO `core_lang_text` VALUES(516, '_ASSIGN_FOR_STATUS_COMPLETED', 'course', '');
INSERT INTO `core_lang_text` VALUES(517, '_ASSIGN_FOR_STATUS_INCOURSE', 'course', '');
INSERT INTO `core_lang_text` VALUES(518, '_ASSIGN_MENU', 'course', '');
INSERT INTO `core_lang_text` VALUES(519, '_AUTOREGISTRATION_CODE', 'course', '');
INSERT INTO `core_lang_text` VALUES(520, '_BACK_TO_ADMINISTRATION', 'course', '');
INSERT INTO `core_lang_text` VALUES(521, '_BUY_COURSE', 'course', '');
INSERT INTO `core_lang_text` VALUES(522, '_CAN_SUBSCRIBE', 'course', '');
INSERT INTO `core_lang_text` VALUES(523, '_CASCADE_MOD_ON_EDITION', 'course', '');
INSERT INTO `core_lang_text` VALUES(524, '_CATEGORY_PATH', 'course', '');
INSERT INTO `core_lang_text` VALUES(525, '_CATEGORY_SELECTED', 'course', '');
INSERT INTO `core_lang_text` VALUES(526, '_CERTIFICATE_ASSIGN_STATUS', 'course', '');
INSERT INTO `core_lang_text` VALUES(527, '_CERTIFICATE_EX_ASSIGN_STATUS', 'course', '');
INSERT INTO `core_lang_text` VALUES(528, '_CERTIFICATE_LANGUAGE', 'course', '');
INSERT INTO `core_lang_text` VALUES(529, '_CERTIFICATE_RELEASED', 'course', '');
INSERT INTO `core_lang_text` VALUES(530, '_CLASSROOMTOCOURSE_CAPTION', 'course', '');
INSERT INTO `core_lang_text` VALUES(531, '_CLASSROOM_EDITION', 'course', '');
INSERT INTO `core_lang_text` VALUES(532, '_CLASSROOM_OCCUPATED', 'course', '');
INSERT INTO `core_lang_text` VALUES(533, '_CLASSROOM_OCCUPATED_YES', 'course', '');
INSERT INTO `core_lang_text` VALUES(534, '_CONFIRM_EXIT', 'course', '');
INSERT INTO `core_lang_text` VALUES(535, '_COURSE_ADVANCE', 'course', '');
INSERT INTO `core_lang_text` VALUES(536, '_COURSE_AUTOREGISTRATION_CODE', 'course', '');
INSERT INTO `core_lang_text` VALUES(537, '_COURSE_CONTENT', 'course', '');
INSERT INTO `core_lang_text` VALUES(538, '_COURSE_DATE', 'course', '');
INSERT INTO `core_lang_text` VALUES(539, '_COURSE_DEMO', 'course', '');
INSERT INTO `core_lang_text` VALUES(540, '_COURSE_DISPLAY_MODE', 'course', '');
INSERT INTO `core_lang_text` VALUES(541, '_COURSE_EDITION', 'course', '');
INSERT INTO `core_lang_text` VALUES(542, '_COURSE_EM_LO', 'course', '');
INSERT INTO `core_lang_text` VALUES(543, '_COURSE_EM_TEACHER', 'course', '');
INSERT INTO `core_lang_text` VALUES(544, '_COURSE_END_MODE', 'course', '');
INSERT INTO `core_lang_text` VALUES(545, '_COURSE_INTRO', 'course', '');
INSERT INTO `core_lang_text` VALUES(546, '_COURSE_INTRO_WITH_MAX', 'course', '');
INSERT INTO `core_lang_text` VALUES(547, '_COURSE_LANG_METHOD', 'course', '');
INSERT INTO `core_lang_text` VALUES(548, '_COURSE_LIST_SUMMARY', 'course', '');
INSERT INTO `core_lang_text` VALUES(549, '_COURSE_LOGO', 'course', '');
INSERT INTO `core_lang_text` VALUES(550, '_COURSE_MENU_TO_ASSIGN', 'course', '');
INSERT INTO `core_lang_text` VALUES(551, '_COURSE_PRIZE', 'course', '');
INSERT INTO `core_lang_text` VALUES(552, '_COURSE_QUOTA', 'course', '');
INSERT INTO `core_lang_text` VALUES(553, '_COURSE_SELECTION', 'course', '');
INSERT INTO `core_lang_text` VALUES(554, '_COURSE_SELL', 'course', '');
INSERT INTO `core_lang_text` VALUES(555, '_COURSE_SPECIAL_OPTION', 'course', '');
INSERT INTO `core_lang_text` VALUES(556, '_COURSE_STATUS_CANNOT_ENTER', 'course', '');
INSERT INTO `core_lang_text` VALUES(557, '_COURSE_SUBSCRIPTION', 'course', '');
INSERT INTO `core_lang_text` VALUES(558, '_COURSE_SUBSRIBE', 'course', '');
INSERT INTO `core_lang_text` VALUES(559, '_COURSE_S_GODADMIN', 'course', '');
INSERT INTO `core_lang_text` VALUES(560, '_COURSE_S_MODERATE', 'course', '');
INSERT INTO `core_lang_text` VALUES(561, '_COURSE_S_SECURITY_CODE', 'course', '');
INSERT INTO `core_lang_text` VALUES(562, '_COURSE_TEACHERS', 'course', '');
INSERT INTO `core_lang_text` VALUES(563, '_COURSE_TIME_OPTION', 'course', '');
INSERT INTO `core_lang_text` VALUES(564, '_COURSE_TYPE', 'course', '');
INSERT INTO `core_lang_text` VALUES(565, '_COURSE_TYPE_BLENDED', 'course', '');
INSERT INTO `core_lang_text` VALUES(566, '_COURSE_TYPE_EDITION', 'course', '');
INSERT INTO `core_lang_text` VALUES(567, '_COURSE_TYPE_ELEARNING', 'course', '');
INSERT INTO `core_lang_text` VALUES(568, '_COURSE_USERISCR', 'course', '');
INSERT INTO `core_lang_text` VALUES(569, '_CREATION_DATE', 'course', '');
INSERT INTO `core_lang_text` VALUES(570, '_CST_AVAILABLE', 'course', '');
INSERT INTO `core_lang_text` VALUES(571, '_CST_CANCELLED', 'course', '');
INSERT INTO `core_lang_text` VALUES(572, '_CST_CONCLUDED', 'course', '');
INSERT INTO `core_lang_text` VALUES(573, '_CST_CONFIRMED', 'course', '');
INSERT INTO `core_lang_text` VALUES(574, '_CST_PREPARATION', 'course', '');
INSERT INTO `core_lang_text` VALUES(575, '_DAY_OF_VALIDITY', 'course', '');
INSERT INTO `core_lang_text` VALUES(576, '_DEMO', 'course', '');
INSERT INTO `core_lang_text` VALUES(577, '_DIRECT_PLAY', 'course', '');
INSERT INTO `core_lang_text` VALUES(578, '_DOCUMENT_UPLOAD', 'course', '');
INSERT INTO `core_lang_text` VALUES(579, '_DONT_SHOW', 'course', '');
INSERT INTO `core_lang_text` VALUES(580, '_DOWNLOAD_MATERIALS', 'course', '');
INSERT INTO `core_lang_text` VALUES(581, '_EDTION_TIME', 'course', '');
INSERT INTO `core_lang_text` VALUES(582, '_ENDOBJECT', 'course', '');
INSERT INTO `core_lang_text` VALUES(583, '_EXPIRING_IN', 'course', '');
INSERT INTO `core_lang_text` VALUES(584, '_FILEUNSPECIFIED', 'course', '');
INSERT INTO `core_lang_text` VALUES(585, '_FILTER_FLATVIEW', 'course', '');
INSERT INTO `core_lang_text` VALUES(586, '_FIRSTACOURSE', 'course', '');
INSERT INTO `core_lang_text` VALUES(587, '_GENERATE_CODE', 'course', '');
INSERT INTO `core_lang_text` VALUES(588, '_GOTO_COURSE_T', 'course', '');
INSERT INTO `core_lang_text` VALUES(589, '_HOUR_BEGIN', 'course', '');
INSERT INTO `core_lang_text` VALUES(590, '_HOUR_END', 'course', '');
INSERT INTO `core_lang_text` VALUES(591, '_IF_NEW_FILE', 'course', '');
INSERT INTO `core_lang_text` VALUES(592, '_IMPORT_FROM_COURSE', 'course', '');
INSERT INTO `core_lang_text` VALUES(593, '_IMPORT_SUBSCRIBE', 'course', '');
INSERT INTO `core_lang_text` VALUES(594, '_INFO', 'course', '');
INSERT INTO `core_lang_text` VALUES(595, '_INHERIT_QUOTA', 'course', '');
INSERT INTO `core_lang_text` VALUES(596, '_IN_COURSE', 'course', '');
INSERT INTO `core_lang_text` VALUES(597, '_IN_THE_CLASSROOM', 'course', '');
INSERT INTO `core_lang_text` VALUES(598, '_LESS_INFO', 'course', '');
INSERT INTO `core_lang_text` VALUES(599, '_MAIN_CATEGORY', 'course', '');
INSERT INTO `core_lang_text` VALUES(600, '_MANUALACTION', 'course', '');
INSERT INTO `core_lang_text` VALUES(601, '_MATERIALS', 'course', '');
INSERT INTO `core_lang_text` VALUES(602, '_MATERIALS_TABLE', 'course', '');
INSERT INTO `core_lang_text` VALUES(603, '_MAX_NUM_SUBSCRIBE', 'course', '');
INSERT INTO `core_lang_text` VALUES(604, '_MAX_SMS_BUDGET', 'course', '');
INSERT INTO `core_lang_text` VALUES(605, '_MEDIUM', 'course', '');
INSERT INTO `core_lang_text` VALUES(606, '_MEDIUMTIME', 'course', '');
INSERT INTO `core_lang_text` VALUES(607, '_MEDIUM_TIME', 'course', '');
INSERT INTO `core_lang_text` VALUES(608, '_MIN_NUM_SUBSCRIBE', 'course', '');
INSERT INTO `core_lang_text` VALUES(609, '_MIN_SCORE_NOT_SET', 'course', '');
INSERT INTO `core_lang_text` VALUES(610, '_MIN_SUBSCRIBE_FOR_COURSE', 'course', '');
INSERT INTO `core_lang_text` VALUES(611, '_MULTIPLE_SUBSCRIPTION', 'course', '');
INSERT INTO `core_lang_text` VALUES(612, '_MY_CERTIFICATE', 'course', '');
INSERT INTO `core_lang_text` VALUES(613, '_NEW_USER_SUBS_WAITING_TEXT', 'course', 'accessibility');
INSERT INTO `core_lang_text` VALUES(614, '_NOACTIVE', 'course', '');
INSERT INTO `core_lang_text` VALUES(615, '_NOENTER', 'course', '');
INSERT INTO `core_lang_text` VALUES(616, '_NO_COURSE_FOUND', 'course', '');
INSERT INTO `core_lang_text` VALUES(617, '_OTHER_OPTION', 'course', '');
INSERT INTO `core_lang_text` VALUES(618, '_OTHER_USER_MATERIAL', 'course', '');
INSERT INTO `core_lang_text` VALUES(619, '_PARTIAL_TIME', 'course', '');
INSERT INTO `core_lang_text` VALUES(620, '_PAUSE_BEGIN', 'course', '');
INSERT INTO `core_lang_text` VALUES(621, '_PAUSE_END', 'course', '');
INSERT INTO `core_lang_text` VALUES(622, '_PERMCLOSE', 'course', '');
INSERT INTO `core_lang_text` VALUES(623, '_PROGRESS_ALL', 'course', '');
INSERT INTO `core_lang_text` VALUES(624, '_PROGRESS_FAILED', 'course', '');
INSERT INTO `core_lang_text` VALUES(625, '_PROGRESS_TITLE', 'course', '');
INSERT INTO `core_lang_text` VALUES(626, '_QUOTA_EXCEDED', 'course', '');
INSERT INTO `core_lang_text` VALUES(627, '_RANDOM_COURSE_AUTOREGISTRATION_CODE', 'course', '');
INSERT INTO `core_lang_text` VALUES(628, '_RESERVE_COURSE', 'course', '');
INSERT INTO `core_lang_text` VALUES(629, '_SC_EVERYWHERE', 'course', '');
INSERT INTO `core_lang_text` VALUES(630, '_SC_ONLYINSC_USER', 'course', '');
INSERT INTO `core_lang_text` VALUES(631, '_SC_ONLY_IN', 'course', '');
INSERT INTO `core_lang_text` VALUES(632, '_SELF_UNSUBSCRIBE', 'course', '');
INSERT INTO `core_lang_text` VALUES(633, '_SHOW_ADVANCED_INFO', 'course', '');
INSERT INTO `core_lang_text` VALUES(634, '_SHOW_COUNT', 'course', '');
INSERT INTO `core_lang_text` VALUES(635, '_SHOW_DEMO', 'course', '');
INSERT INTO `core_lang_text` VALUES(636, '_SHOW_INSTMSG', 'course', '');
INSERT INTO `core_lang_text` VALUES(637, '_SHOW_PROGRESS', 'course', '');
INSERT INTO `core_lang_text` VALUES(638, '_SHOW_TIME', 'course', '');
INSERT INTO `core_lang_text` VALUES(639, '_SHOW_USER_OF_LEVEL', 'course', '');
INSERT INTO `core_lang_text` VALUES(640, '_SHOW_WHOISONLINE', 'course', '');
INSERT INTO `core_lang_text` VALUES(641, '_SPONSORED_BY', 'course', '');
INSERT INTO `core_lang_text` VALUES(642, '_SPONSOR_LINK', 'course', '');
INSERT INTO `core_lang_text` VALUES(643, '_SPONSOR_LOGO', 'course', '');
INSERT INTO `core_lang_text` VALUES(644, '_STATCANNOTENTER', 'course', '');
INSERT INTO `core_lang_text` VALUES(645, '_SUBSCRIBED_T', 'course', '');
INSERT INTO `core_lang_text` VALUES(646, '_SUBSCRIBE_METHOD', 'course', '');
INSERT INTO `core_lang_text` VALUES(647, '_SUBSCRIPTION', 'course', '');
INSERT INTO `core_lang_text` VALUES(648, '_SUBSCRIPTION_CLOSED', 'course', '');
INSERT INTO `core_lang_text` VALUES(649, '_SUBSCRIPTION_DATE_BEGIN', 'course', '');
INSERT INTO `core_lang_text` VALUES(650, '_SUBSCRIPTION_DATE_END', 'course', '');
INSERT INTO `core_lang_text` VALUES(651, '_SUBSCRIPTION_IN_PERIOD', 'course', '');
INSERT INTO `core_lang_text` VALUES(652, '_SUBSCRIPTION_OPEN', 'course', '');
INSERT INTO `core_lang_text` VALUES(653, '_THANKS_LOGIN_OR_REGISTER', 'course', '');
INSERT INTO `core_lang_text` VALUES(654, '_THEACER_LIST', 'course', '');
INSERT INTO `core_lang_text` VALUES(655, '_TITLE_CATEGORY_JUMP', 'course', '');
INSERT INTO `core_lang_text` VALUES(656, '_TITLE_CERTIFICATE_TO_COURSE', 'course', '');
INSERT INTO `core_lang_text` VALUES(657, '_T_USER_STATUS_BEGIN', 'course', '');
INSERT INTO `core_lang_text` VALUES(658, '_T_USER_STATUS_CONFIRMED', 'course', '');
INSERT INTO `core_lang_text` VALUES(659, '_T_USER_STATUS_END', 'course', '');
INSERT INTO `core_lang_text` VALUES(660, '_T_USER_STATUS_RESERVED', 'course', '');
INSERT INTO `core_lang_text` VALUES(661, '_T_USER_STATUS_SUBS', 'course', '');
INSERT INTO `core_lang_text` VALUES(662, '_UNLIMITED_QUOTA', 'course', '');
INSERT INTO `core_lang_text` VALUES(663, '_UNSUBSCRIBE_REQUESTS', 'course', '');
INSERT INTO `core_lang_text` VALUES(664, '_UNSUBSCRIBE_REQUEST_WAITING_FOR_MODERATION', 'course', '');
INSERT INTO `core_lang_text` VALUES(665, '_USED_DISK', 'course', '');
INSERT INTO `core_lang_text` VALUES(666, '_USERWAITING', 'course', '');
INSERT INTO `core_lang_text` VALUES(667, '_USER_CAN_SUBSCRIBE', 'course', '');
INSERT INTO `core_lang_text` VALUES(668, '_USER_CAN_UNSUBSCRIBE', 'course', '');
INSERT INTO `core_lang_text` VALUES(669, '_USER_EDITION_SUBSCRIBE', 'course', '');
INSERT INTO `core_lang_text` VALUES(670, '_USER_LVL', 'course', '');
INSERT INTO `core_lang_text` VALUES(671, '_USER_MATERIAL', 'course', '');
INSERT INTO `core_lang_text` VALUES(672, '_USETHIS', 'course', '');
INSERT INTO `core_lang_text` VALUES(673, '_USE_LOGO_IN_COURSELIST', 'course', '');
INSERT INTO `core_lang_text` VALUES(674, '_VOTE_BAD_ALT', 'course', 'accessibility');
INSERT INTO `core_lang_text` VALUES(675, '_VOTE_BAD_TITLE', 'course', '');
INSERT INTO `core_lang_text` VALUES(676, '_VOTE_GOOD_ALT', 'course', 'accessibility');
INSERT INTO `core_lang_text` VALUES(677, '_VOTE_GOOD_TITLE', 'course', '');
INSERT INTO `core_lang_text` VALUES(678, '_WAITING_PAYMENT', 'course', '');
INSERT INTO `core_lang_text` VALUES(679, '_WELCOME', 'course', '');
INSERT INTO `core_lang_text` VALUES(680, '_WHAT_SHOW', 'course', '');
INSERT INTO `core_lang_text` VALUES(681, '_WHERE_SHOW_COURSE', 'course', '');
INSERT INTO `core_lang_text` VALUES(682, '_WHOIS_ONLINE', 'course', '');
INSERT INTO `core_lang_text` VALUES(683, '_ALT_REM_SUB', 'coursepath', '');
INSERT INTO `core_lang_text` VALUES(684, '_AREE_YOU_SURE_TO_REMOVE_COURSE_FROM_PATH', 'coursepath', '');
INSERT INTO `core_lang_text` VALUES(685, '_COURSE_PATH_CAPTION', 'coursepath', '');
INSERT INTO `core_lang_text` VALUES(686, '_COURSE_PATH_COURSES_CAPTION', 'coursepath', '');
INSERT INTO `core_lang_text` VALUES(687, '_COURSE_PATH_SUBSCRIBE', 'coursepath', '');
INSERT INTO `core_lang_text` VALUES(688, '_COURSE_S_GODADMIN', 'coursepath', '');
INSERT INTO `core_lang_text` VALUES(689, '_COURSE_S_MODERATE', 'coursepath', '');
INSERT INTO `core_lang_text` VALUES(690, '_CURRENT_ACTIVITY', 'coursepath', '');
INSERT INTO `core_lang_text` VALUES(691, '_IMPORT_COURSE', 'coursepath', '');
INSERT INTO `core_lang_text` VALUES(692, '_SUBSCRIBED_CAPTION', 'coursepath', '');
INSERT INTO `core_lang_text` VALUES(693, '_ACTIVITY_INFO', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(694, '_ADD_ACTIVITY', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(695, '_ADD_ACTIVITY_TITLE', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(696, '_ADD_SCORM_RESULTS', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(697, '_ANSWER_CORRECT', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(698, '_COURSE_REPORT_CAPTION', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(699, '_COURSE_REPORT_SUMMARY', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(700, '_EXPORT_STATS', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(701, '_LEFT', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(702, '_MOVE_LEFT', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(703, '_MOVE_RIGHT', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(704, '_NOT_CHECKED', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(705, '_NOT_PASSED', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(706, '_OF_USER', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(707, '_PASSED', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(708, '_PERCENTAGE_CORRECT', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(709, '_QUESTION_ANSWERED', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(710, '_REDO_FINAL_VOTE', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(711, '_REDO_FINAL_VOTE_TITLE', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(712, '_REQUIRED_MUST_BE_LESS_THEN_MAX', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(713, '_RESET_TRACK', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(714, '_RIGHT', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(715, '_ROUND_FINAL_VOTE_TITLE', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(716, '_ROUND_TEST_VOTE', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(717, '_ROUND_VOTE', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(718, '_SHOW_ANSWER', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(719, '_SHOW_TO_USER', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(720, '_STANDARD_DEVIATION', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(721, '_STUDENTS', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(722, '_STUDENTS_VOTE', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(723, '_SUMMARY_VOTE', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(724, '_TABLE_QUEST', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(725, '_TABLE_QUEST_CORRECT_ASS', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(726, '_TABLE_QUEST_CORRECT_TXT', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(727, '_TABLE_QUEST_LIST', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(728, '_TEST_INFO', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(729, '_TITLE_ACT', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(730, '_TOT_QUESTION', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(731, '_TQ_LINK', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(732, '_USE_FOR_FINAL', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(733, '_WEIGHT', 'coursereport', '');
INSERT INTO `core_lang_text` VALUES(734, '_AUTOREGISTRATION', 'course_autoregistration', '');
INSERT INTO `core_lang_text` VALUES(735, '_BACK_TO_COURSE', 'course_autoregistration', '');
INSERT INTO `core_lang_text` VALUES(736, '_CODE_ALREDY_USED', 'course_autoregistration', '');
INSERT INTO `core_lang_text` VALUES(737, '_COURSE_AUTOREGISTRATION_CODE', 'course_autoregistration', '');
INSERT INTO `core_lang_text` VALUES(738, '_ACTIVITY_CHART_DESCRIPTION', 'course_charts', '');
INSERT INTO `core_lang_text` VALUES(739, '_CHAPTER_CHART_DESCRIPTION', 'course_charts', '');
INSERT INTO `core_lang_text` VALUES(740, '_COMPLETED_CHART_DESCRIPTION', 'course_charts', '');
INSERT INTO `core_lang_text` VALUES(741, '_NO_SCORM_IN_COURSE', 'course_charts', '');
INSERT INTO `core_lang_text` VALUES(742, '_PASSED_CHART_TITLE', 'course_charts', '');
INSERT INTO `core_lang_text` VALUES(743, '_SCORE_CHART_DESCRIPTION', 'course_charts', '');
INSERT INTO `core_lang_text` VALUES(744, '_TIME_CHART_DESCRIPTION', 'course_charts', '');
INSERT INTO `core_lang_text` VALUES(745, '_TIME_CHART_TITLE', 'course_charts', '');
INSERT INTO `core_lang_text` VALUES(746, '_SEL_COURSE', 'course_selector', '');
INSERT INTO `core_lang_text` VALUES(747, '_CUSTOMER_HELP', 'customer_help', '');
INSERT INTO `core_lang_text` VALUES(748, '_README_HELP', 'customer_help', '');
INSERT INTO `core_lang_text` VALUES(749, '_ACTIVE_COURSE', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(750, '_ACTIVE_SEVEN_COURSE', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(751, '_ADMIN_USER', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(752, '_CORE_VERSION', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(753, '_COURSES_PANEL', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(754, '_DASHBOARD', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(755, '_DEACTIVE_SEVEN_COURSE', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(756, '_FOLLOW_US', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(757, '_INACTIVE_USER', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(758, '_LAST_RELEASED', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(759, '_MONITOR_PRINT_CERTIFICATE_STATUS', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(760, '_NEW_RELEASE_AVAILABLE', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(761, '_ONLINE_USER', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(762, '_OPEN_IN_NEW_WINDOW', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(763, '_QUICK_LINKS', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(764, '_REG_LASTSEVENDAYS', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(765, '_REG_TODAY', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(766, '_REG_YESTERDAY', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(767, '_SUPERADMIN_USER', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(768, '_SUPPORT_SITE', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(769, '_SUSPENDED_USER', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(770, '_TITLE_URL_COMPANY', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(771, '_TITLE_URL_SUPPORTLMS', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(772, '_TOTAL_COURSE', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(773, '_TOTAL_SUBSCRIPTION', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(774, '_TOTAL_USER', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(775, '_UNKNOWN_RELEASE', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(776, '_URL_COMPANY', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(777, '_URL_SUPPORTLMS', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(778, '_USERS_PANEL', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(779, '_WAITING_SUBSCRIPTION', 'dashboard', '');
INSERT INTO `core_lang_text` VALUES(780, '_ALERT_SUBJECT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(781, '_ALERT_TEXT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(782, '_APPROVED_SUBSCRIBED_SUBJECT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(783, '_APPROVED_SUBSCRIBED_TEXT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(784, '_APPROVED_USER_TEXT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(785, '_DELETED_USER_SBJ', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(786, '_DELETED_USER_TEXT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(787, '_DENY_SUBSCRIBED_SUBJECT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(788, '_DENY_SUBSCRIBED_TEXT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(789, '_MODIFIED_USER_SBJ', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(790, '_MODIFIED_USER_TEXT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(791, '_MOD_USER_SUBSCRIPTION_SUBJECT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(792, '_MOD_USER_SUBSCRIPTION_TEXT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(793, '_NEW_FORUM', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(794, '_NEW_FORUM_BODY', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(795, '_NEW_MESSAGE_INSERT_IN_THREAD', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(796, '_NEW_THREAD_INSERT_IN_FORUM', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(797, '_NEW_USER_SUBSCRIBED_SUBJECT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(798, '_NEW_USER_SUBSCRIBED_TEXT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(799, '_NEW_USER_SUBS_WAITING_SUBJECT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(800, '_NEW_USER_SUBS_WAITING_TEXT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(801, '_PASSWORD_CHANGED', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(802, '_REFUSED_USER_SBJ', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(803, '_REFUSED_USER_TEXT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(804, '_REGISTERED_USER_SBJ', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(805, '_REGISTERED_USER_TEXT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(806, '_SUBJECT_NOTIFY_MESSAGE', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(807, '_SUBJECT_NOTIFY_THREAD', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(808, '_TO_APPROVE_GROUP_USER_SBJ', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(809, '_TO_APPROVE_GROUP_USER_TEXT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(810, '_TO_APPROVE_USER_SBJ', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(811, '_TO_APPROVE_USER_TEXT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(812, '_WAITING_USER_SBJ', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(813, '_WAITING_USER_TEXT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(814, '_YOU_RECIVE_MSG_SUBJECT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(815, '_YOU_RECIVE_MSG_TEXT', 'email', 'email');
INSERT INTO `core_lang_text` VALUES(816, '_BASE', 'enrollrules', '');
INSERT INTO `core_lang_text` VALUES(817, '_SHOW_LOGS', 'enrollrules', '');
INSERT INTO `core_lang_text` VALUES(818, '_EVENT_CHANNEL_SMS', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(819, '_EVENT_CLASS_AdviceNew', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(820, '_EVENT_CLASS_CoursePorpModified', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(821, '_EVENT_CLASS_ForumNewCategory', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(822, '_EVENT_CLASS_ForumNewResponse', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(823, '_EVENT_CLASS_ForumNewThread', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(824, '_EVENT_CLASS_MsgNewReceived', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(825, '_EVENT_CLASS_UserApproved', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(826, '_EVENT_CLASS_UserCourseBuy', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(827, '_EVENT_CLASS_UserCourseEnded', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(828, '_EVENT_CLASS_UserCourseInserted', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(829, '_EVENT_CLASS_UserCourseInsertModerate', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(830, '_EVENT_CLASS_UserCourseLevelChanged', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(831, '_EVENT_CLASS_UserCourseRemoved', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(832, '_EVENT_CLASS_UserDel', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(833, '_EVENT_CLASS_UserGroupInsert', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(834, '_EVENT_CLASS_UserGroupModerated', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(835, '_EVENT_CLASS_UserGroupRemove', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(836, '_EVENT_CLASS_UserMod', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(837, '_EVENT_CLASS_UserNew', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(838, '_EVENT_CLASS_UserNewModerated', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(839, '_EVENT_MANAGER', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(840, '_EVENT_PERM_NOTUSED', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(841, '_EVENT_PLATFORM', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(842, '_EVENT_PLATFORM_framework', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(843, '_EVENT_PLATFORM_lms', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(844, '_EVENT_PLATFORM_lms-a', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(845, '_EVENT_RECIPIENTS_MODERATORS_GOD', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(846, '_EVENT_RECIPIENTS_TEACHER', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(847, '_EVENT_RECIPIENTS_TEACHER_GOD', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(848, '_EVENT_RECIPIENTS_USER', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(849, '_EVENT_SETTINGS', 'event_manager', '');
INSERT INTO `core_lang_text` VALUES(850, '_ADDFAQ', 'faq', '');
INSERT INTO `core_lang_text` VALUES(851, '_BACKTOTOP', 'faq', '');
INSERT INTO `core_lang_text` VALUES(852, '_KEYWORD', 'faq', '');
INSERT INTO `core_lang_text` VALUES(853, '_SECT_FAQ', 'faq', '');
INSERT INTO `core_lang_text` VALUES(854, '_SESLECTTERM', 'faq', '');
INSERT INTO `core_lang_text` VALUES(855, '_SUMMARY_FAQ', 'faq', '');
INSERT INTO `core_lang_text` VALUES(856, '_SWITCH_TO_FAQ', 'faq', '');
INSERT INTO `core_lang_text` VALUES(857, '_SWITCH_TO_HELP', 'faq', '');
INSERT INTO `core_lang_text` VALUES(858, '_TERM', 'faq', '');
INSERT INTO `core_lang_text` VALUES(859, '_ADD_NEW_FIELD', 'field', '');
INSERT INTO `core_lang_text` VALUES(860, '_ALL_FIELD_TYPE', 'field', '');
INSERT INTO `core_lang_text` VALUES(861, '_CODICEFISCALE', 'field', '');
INSERT INTO `core_lang_text` VALUES(862, '_COUNTRY', 'field', '');
INSERT INTO `core_lang_text` VALUES(863, '_DROPDOWN', 'field', '');
INSERT INTO `core_lang_text` VALUES(864, '_DROPDOWN_ELEMENT', 'field', '');
INSERT INTO `core_lang_text` VALUES(865, '_DROPDOWN_NOVALUE', 'field', '');
INSERT INTO `core_lang_text` VALUES(866, '_DROPDOWN_SON_ADD', 'field', '');
INSERT INTO `core_lang_text` VALUES(867, '_DROPDOWN_SON_CAPTION', 'field', '');
INSERT INTO `core_lang_text` VALUES(868, '_DROPDOWN_SON_NEW', 'field', '');
INSERT INTO `core_lang_text` VALUES(869, '_FIELD_MANAGER', 'field', '');
INSERT INTO `core_lang_text` VALUES(870, '_FIELD_TYPE', 'field', '');
INSERT INTO `core_lang_text` VALUES(871, '_FILTER_NAME', 'field', '');
INSERT INTO `core_lang_text` VALUES(872, '_FREETEXT', 'field', '');
INSERT INTO `core_lang_text` VALUES(873, '_GMAIL', 'field', '');
INSERT INTO `core_lang_text` VALUES(874, '_ICQ', 'field', '');
INSERT INTO `core_lang_text` VALUES(875, '_MSN', 'field', '');
INSERT INTO `core_lang_text` VALUES(876, '_NEW_DATEFIELD', 'field', '');
INSERT INTO `core_lang_text` VALUES(877, '_NEW_DROPDOWN', 'field', '');
INSERT INTO `core_lang_text` VALUES(878, '_NEW_FREETEXT', 'field', '');
INSERT INTO `core_lang_text` VALUES(879, '_NEW_ICQ', 'field', '');
INSERT INTO `core_lang_text` VALUES(880, '_NEW_MSN', 'field', '');
INSERT INTO `core_lang_text` VALUES(881, '_NEW_SKYPE', 'field', '');
INSERT INTO `core_lang_text` VALUES(882, '_NEW_TEXTFIELD', 'field', '');
INSERT INTO `core_lang_text` VALUES(883, '_NEW_UPLOAD', 'field', '');
INSERT INTO `core_lang_text` VALUES(884, '_NEW_YAHOO', 'field', '');
INSERT INTO `core_lang_text` VALUES(885, '_NEW_YESNO', 'field', '');
INSERT INTO `core_lang_text` VALUES(886, '_NOT_DO', 'field', '');
INSERT INTO `core_lang_text` VALUES(887, '_NO_FILE_UPLOADED', 'field', '');
INSERT INTO `core_lang_text` VALUES(888, '_SHOW_ON_PLATFORM', 'field', '');
INSERT INTO `core_lang_text` VALUES(889, '_SKYPE', 'field', '');
INSERT INTO `core_lang_text` VALUES(890, '_TEXTFIELD', 'field', '');
INSERT INTO `core_lang_text` VALUES(891, '_USE_MULTI_LANG_WHEN_AVAILABLE', 'field', '');
INSERT INTO `core_lang_text` VALUES(892, '_YAHOO', 'field', '');
INSERT INTO `core_lang_text` VALUES(893, '_YESNO', 'field', '');
INSERT INTO `core_lang_text` VALUES(894, '_GAP_ANALYSIS', 'fncroles', '');
INSERT INTO `core_lang_text` VALUES(895, '_GAP_ONLY', 'fncroles', '');
INSERT INTO `core_lang_text` VALUES(896, '_NO_GAP_ONLY', 'fncroles', '');
INSERT INTO `core_lang_text` VALUES(897, '_ADDFORUM', 'forum', '');
INSERT INTO `core_lang_text` VALUES(898, '_ADDTHREAD', 'forum', '');
INSERT INTO `core_lang_text` VALUES(899, '_ALL_THREAD_READ', 'forum', '');
INSERT INTO `core_lang_text` VALUES(900, '_AREYOUSURE_MOVE_THREAD', 'forum', '');
INSERT INTO `core_lang_text` VALUES(901, '_CANNOTENTER', 'forum', '');
INSERT INTO `core_lang_text` VALUES(902, '_CAPTION_FORUM_MESSAGE', 'forum', '');
INSERT INTO `core_lang_text` VALUES(903, '_CAPTION_FORUM_MESSAGE_ADD', 'forum', '');
INSERT INTO `core_lang_text` VALUES(904, '_CHOOSE_FORUM_ACCESS', 'forum', '');
INSERT INTO `core_lang_text` VALUES(905, '_DELETE', 'forum', '');
INSERT INTO `core_lang_text` VALUES(906, '_ELEFORUM', 'forum', '');
INSERT INTO `core_lang_text` VALUES(907, '_EMOTICONS', 'forum', '');
INSERT INTO `core_lang_text` VALUES(908, '_FORUMCLOSED', 'forum', '');
INSERT INTO `core_lang_text` VALUES(909, '_FORUMOPEN', 'forum', '');
INSERT INTO `core_lang_text` VALUES(910, '_FORUM_ACCESS', 'forum', '');
INSERT INTO `core_lang_text` VALUES(911, '_FORUM_INFORMATION', 'forum', '');
INSERT INTO `core_lang_text` VALUES(912, '_FREE', 'forum', '');
INSERT INTO `core_lang_text` VALUES(913, '_FREET', 'forum', '');
INSERT INTO `core_lang_text` VALUES(914, '_FREETHREAD', 'forum', '');
INSERT INTO `core_lang_text` VALUES(915, '_FROM_FORUM', 'forum', '');
INSERT INTO `core_lang_text` VALUES(916, '_IMPORTANT_THREAD', 'forum', '');
INSERT INTO `core_lang_text` VALUES(917, '_LASTPOST', 'forum', '');
INSERT INTO `core_lang_text` VALUES(918, '_LOCKED', 'forum', '');
INSERT INTO `core_lang_text` VALUES(919, '_LOCKEDMESS', 'forum', '');
INSERT INTO `core_lang_text` VALUES(920, '_LOCKFORUM', 'forum', '');
INSERT INTO `core_lang_text` VALUES(921, '_LOCKFORUMALT', 'forum', '');
INSERT INTO `core_lang_text` VALUES(922, '_LOCKTHREAD', 'forum', '');
INSERT INTO `core_lang_text` VALUES(923, '_MODIFY_BY', 'forum', '');
INSERT INTO `core_lang_text` VALUES(924, '_MOD_MESSAGE', 'forum', '');
INSERT INTO `core_lang_text` VALUES(925, '_MOVE_TO_FORUM', 'forum', '');
INSERT INTO `core_lang_text` VALUES(926, '_NEW_MESSAGE', 'forum', '');
INSERT INTO `core_lang_text` VALUES(927, '_NEW_THREAD', 'forum', '');
INSERT INTO `core_lang_text` VALUES(928, '_NOACCESS', 'forum', '');
INSERT INTO `core_lang_text` VALUES(929, '_NOTIFY', 'forum', '');
INSERT INTO `core_lang_text` VALUES(930, '_NOTIFY_CHANGE_STATUS_CORRECT', 'forum', '');
INSERT INTO `core_lang_text` VALUES(931, '_NOTIFY_ME_FORUM', 'forum', '');
INSERT INTO `core_lang_text` VALUES(932, '_NOTIFY_ME_FORUM_TITLE', 'forum', '');
INSERT INTO `core_lang_text` VALUES(933, '_NOTIFY_ME_THREAD', 'forum', '');
INSERT INTO `core_lang_text` VALUES(934, '_NOTIFY_ME_THREAD_TITLE', 'forum', '');
INSERT INTO `core_lang_text` VALUES(935, '_NUMPOST', 'forum', '');
INSERT INTO `core_lang_text` VALUES(936, '_NUMREPLY', 'forum', '');
INSERT INTO `core_lang_text` VALUES(937, '_NUMTHREAD', 'forum', '');
INSERT INTO `core_lang_text` VALUES(938, '_NUMVIEW', 'forum', '');
INSERT INTO `core_lang_text` VALUES(939, '_QUOTE', 'forum', '');
INSERT INTO `core_lang_text` VALUES(940, '_RESTOREINSERT', 'forum', '');
INSERT INTO `core_lang_text` VALUES(941, '_SEARCH_LABEL', 'forum', '');
INSERT INTO `core_lang_text` VALUES(942, '_SEARCH_RESULT_FOR', 'forum', '');
INSERT INTO `core_lang_text` VALUES(943, '_SET_NOT_IMPORTANT_THREAD', 'forum', '');
INSERT INTO `core_lang_text` VALUES(944, '_THRAD_SUMMARY', 'forum', '');
INSERT INTO `core_lang_text` VALUES(945, '_THREAD', 'forum', '');
INSERT INTO `core_lang_text` VALUES(946, '_THREAD_CAPTION', 'forum', '');
INSERT INTO `core_lang_text` VALUES(947, '_TO_FORUM', 'forum', '');
INSERT INTO `core_lang_text` VALUES(948, '_UNERASE', 'forum', '');
INSERT INTO `core_lang_text` VALUES(949, '_UNLOCKFORUM', 'forum', '');
INSERT INTO `core_lang_text` VALUES(950, '_UNLOCKFORUMALT', 'forum', '');
INSERT INTO `core_lang_text` VALUES(951, '_UNNOTIFY', 'forum', '');
INSERT INTO `core_lang_text` VALUES(952, '_UNNOTIFY_ME_FORUM', 'forum', '');
INSERT INTO `core_lang_text` VALUES(953, '_UNNOTIFY_ME_FORUM_TITLE', 'forum', '');
INSERT INTO `core_lang_text` VALUES(954, '_UNNOTIFY_ME_THREAD', 'forum', '');
INSERT INTO `core_lang_text` VALUES(955, '_UNNOTIFY_ME_THREAD_TITLE', 'forum', '');
INSERT INTO `core_lang_text` VALUES(956, '_USERFORUMPARAM', 'forum', '');
INSERT INTO `core_lang_text` VALUES(957, '_USERPARAM', 'forum', '');
INSERT INTO `core_lang_text` VALUES(958, '_VIEW_PROFILE', 'forum', '');
INSERT INTO `core_lang_text` VALUES(959, '_WRITTED_BY', 'forum', '');
INSERT INTO `core_lang_text` VALUES(960, '_ADDTERM', 'glossary', '');
INSERT INTO `core_lang_text` VALUES(961, '_GLOSSARY', 'glossary', '');
INSERT INTO `core_lang_text` VALUES(962, '_GLOSSARY_SUMMARY', 'glossary', '');
INSERT INTO `core_lang_text` VALUES(963, '_TERM', 'glossary', '');
INSERT INTO `core_lang_text` VALUES(964, '_TERMDESCR', 'glossary', '');
INSERT INTO `core_lang_text` VALUES(965, '_TERMS', 'glossary', '');
INSERT INTO `core_lang_text` VALUES(966, '_GRADEBOOK_AREATITLE', 'gradebook', '');
INSERT INTO `core_lang_text` VALUES(967, '_GRADEBOOK_CAPTION', 'gradebook', 'accessibility');
INSERT INTO `core_lang_text` VALUES(968, '_GRADEBOOK_SUMMARY', 'gradebook', 'accessibility');
INSERT INTO `core_lang_text` VALUES(969, '_MAX_DIVISOR', 'gradebook', '');
INSERT INTO `core_lang_text` VALUES(970, '_NOT_CHECKED', 'gradebook', '');
INSERT INTO `core_lang_text` VALUES(971, '_NO_SCORE', 'gradebook', '');
INSERT INTO `core_lang_text` VALUES(972, '_TEST_N', 'gradebook', '');
INSERT INTO `core_lang_text` VALUES(973, '_ALT_SUBSCRIBE', 'groups', '');
INSERT INTO `core_lang_text` VALUES(974, '_GROUP_CAPTION', 'groups', '');
INSERT INTO `core_lang_text` VALUES(975, '_MANAGE_GROUP_SUBSCRIPTION', 'groups', '');
INSERT INTO `core_lang_text` VALUES(976, '_SUBSCRIBE_USER', 'groups', '');
INSERT INTO `core_lang_text` VALUES(977, '_REPOSELECTDESTINATION', 'homerepo', '');
INSERT INTO `core_lang_text` VALUES(978, '_TARGETMOVEFOLDER', 'homerepo', '');
INSERT INTO `core_lang_text` VALUES(979, '_AUTOREFRESH', 'htmlframechat', '');
INSERT INTO `core_lang_text` VALUES(980, '_EMOTICONS', 'htmlframechat', '');
INSERT INTO `core_lang_text` VALUES(981, '_MSGTXT', 'htmlframechat', '');
INSERT INTO `core_lang_text` VALUES(982, '_REFRESH', 'htmlframechat', '');
INSERT INTO `core_lang_text` VALUES(983, '_ROOMS_LIST', 'htmlframechat', '');
INSERT INTO `core_lang_text` VALUES(984, '_USERS_LIST', 'htmlframechat', '');
INSERT INTO `core_lang_text` VALUES(985, '_USER_HAS_QUIT', 'htmlframechat', '');
INSERT INTO `core_lang_text` VALUES(986, '_USER_LOGGED_IN', 'htmlframechat', '');
INSERT INTO `core_lang_text` VALUES(987, '_HTMLFRONT', 'htmlfront', '');
INSERT INTO `core_lang_text` VALUES(988, '_BACKTOTOP', 'htmlpage', '');
INSERT INTO `core_lang_text` VALUES(989, '_SECT_PAGE', 'htmlpage', '');
INSERT INTO `core_lang_text` VALUES(990, '_ACCESSTYPE', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(991, '_ADD_NEW_CONNECTION', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(992, '_ADD_NEW_CONNECTOR', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(993, '_ADD_NEW_TASK', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(994, '_BYEXAMPLE', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(995, '_CANCELED_COURSES', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(996, '_CANCELED_COURSEUSER', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(997, '_CANCELED_FOLDER', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(998, '_CANCELED_USERS', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(999, '_CLASS', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1000, '_CONFIRM_DELETION', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1001, '_CONNECTION', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1002, '_CONNECTIONS', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1003, '_CONNECTOR', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1004, '_CONNECTORS', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1005, '_CONNECTORS_TITLE', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1006, '_CONN_NAME_EXAMPLE', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1007, '_CONN_TITLE', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1008, '_DESTINATION', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1009, '_DOCEBO_IMPORT_NOTHINGTOPROCESS', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1010, '_DONTDELETE', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1011, '_DONTSEND', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1012, '_FIELD_DEF', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1013, '_FIELD_DEFINITION_TYPE', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1014, '_FIELD_DELIMITER', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1015, '_FIELD_ENCLOSURE', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1016, '_FIELD_SUBPATTERN', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1017, '_FILEPATTERN', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1018, '_FILEPATTERN_EXAMPLE', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1019, '_FILE_ANALYZED', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1020, '_FINISH', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1021, '_FIRST_ROW_HEADER', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1022, '_GROUP_FILTER', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1023, '_HOUR', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1024, '_IMPORT_TYPE', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1025, '_IMPORT_TYPE_INSERTONLY', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1026, '_IMPORT_TYPE_INSERTREMOVE', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1027, '_LAST_EXECUTION', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1028, '_MAP_NOT_REQUIRED', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1029, '_NO_NEW_CONNECTORS', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1030, '_PREG_MATCH_FOLDER', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1031, '_READ', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1032, '_READWRITE', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1033, '_SCHEDULE_TYPE_AT', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1034, '_SCHEDULE_TYPE_AT_DATA', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1035, '_SCHEDULE_TYPE_INTERVAL', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1036, '_SCHEDULE_TYPE_INTERVAL_DATA', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1037, '_SENDNOTIFY', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1038, '_SOURCE', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1039, '_STANDARD_MENU', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1040, '_TASKS', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1041, '_TASK_DEL', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1042, '_TASK_INSERTED', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1043, '_TASK_NAME_EXAMPLE', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1044, '_TASK_RUN', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1045, '_TASK_RUNNED', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1046, '_TREE_INSERT', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1047, '_TREE_INSERT_FOLDER', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1048, '_WRITE', 'iotask', '');
INSERT INTO `core_lang_text` VALUES(1049, '_FILEUNSPECIFIED', 'item', '');
INSERT INTO `core_lang_text` VALUES(1050, '_FILE_MOD', 'item', '');
INSERT INTO `core_lang_text` VALUES(1051, '_MIME', 'item', '');
INSERT INTO `core_lang_text` VALUES(1052, '_SECTIONNAME_ITEM', 'item', '');
INSERT INTO `core_lang_text` VALUES(1053, '_CATEGORIZED_AND_UNCATEGORIZED', 'kb', '');
INSERT INTO `core_lang_text` VALUES(1054, '_CATEGORIZED_ONLY', 'kb', '');
INSERT INTO `core_lang_text` VALUES(1055, '_CATEGORIZE_OBJECT_ITEMS', 'kb', '');
INSERT INTO `core_lang_text` VALUES(1056, '_CONTAINED_IN', 'kb', '');
INSERT INTO `core_lang_text` VALUES(1057, '_IS_MOBILE', 'kb', '');
INSERT INTO `core_lang_text` VALUES(1058, '_RESOURCE_ORIGINAL_NAME', 'kb', '');
INSERT INTO `core_lang_text` VALUES(1059, '_SET_AS_NORMAL', 'kb', '');
INSERT INTO `core_lang_text` VALUES(1060, '_SET_VISIBLE_TO_EVERYONE', 'kb', '');
INSERT INTO `core_lang_text` VALUES(1061, '_UNCATEGORIZED_ONLY', 'kb', '');
INSERT INTO `core_lang_text` VALUES(1062, '_VISIBLE_BY_EVERYONE', 'kb', '');
INSERT INTO `core_lang_text` VALUES(1063, '_YOU_WILL_LOSE_PREVIOUS_CATEGORIZATION', 'kb', '');
INSERT INTO `core_lang_text` VALUES(1064, '_ALL_DESCRIPTION', 'label', '');
INSERT INTO `core_lang_text` VALUES(1065, '_LEVEL_1', 'levels', '');
INSERT INTO `core_lang_text` VALUES(1066, '_LEVEL_2', 'levels', '');
INSERT INTO `core_lang_text` VALUES(1067, '_LEVEL_3', 'levels', '');
INSERT INTO `core_lang_text` VALUES(1068, '_LEVEL_4', 'levels', '');
INSERT INTO `core_lang_text` VALUES(1069, '_LEVEL_5', 'levels', '');
INSERT INTO `core_lang_text` VALUES(1070, '_LEVEL_6', 'levels', '');
INSERT INTO `core_lang_text` VALUES(1071, '_LEVEL_7', 'levels', '');
INSERT INTO `core_lang_text` VALUES(1072, '_ADD_FILE', 'light_repo', '');
INSERT INTO `core_lang_text` VALUES(1073, '_CAPTION_USER_FILE_LIST', 'light_repo', '');
INSERT INTO `core_lang_text` VALUES(1074, '_FILE_COUNT', 'light_repo', '');
INSERT INTO `core_lang_text` VALUES(1075, '_NEW_REPOSITORY', 'light_repo', '');
INSERT INTO `core_lang_text` VALUES(1076, '_NO_REPOSITORY_FOUND', 'light_repo', '');
INSERT INTO `core_lang_text` VALUES(1077, '_REPO_NEW_FILE', 'light_repo', '');
INSERT INTO `core_lang_text` VALUES(1078, '_TITLE_LIGHT_REPO', 'light_repo', '');
INSERT INTO `core_lang_text` VALUES(1079, '_VIEW_USER_FILE_LIST', 'light_repo', '');
INSERT INTO `core_lang_text` VALUES(1080, '_ADDLINK', 'link', '');
INSERT INTO `core_lang_text` VALUES(1081, '_ADDLINKT', 'link', '');
INSERT INTO `core_lang_text` VALUES(1082, '_BACKTOTOP', 'link', '');
INSERT INTO `core_lang_text` VALUES(1083, '_KEYWORD', 'link', '');
INSERT INTO `core_lang_text` VALUES(1084, '_LINKIUNNEWWINDOW', 'link', '');
INSERT INTO `core_lang_text` VALUES(1085, '_LINK_ADDRESS', 'link', '');
INSERT INTO `core_lang_text` VALUES(1086, '_SECT_LINK', 'link', '');
INSERT INTO `core_lang_text` VALUES(1087, '_SESLECTTERM', 'link', '');
INSERT INTO `core_lang_text` VALUES(1088, '_SUMMARY_LINK', 'link', '');
INSERT INTO `core_lang_text` VALUES(1089, '_SWITCH_TO_KEYWORD', 'link', '');
INSERT INTO `core_lang_text` VALUES(1090, '_SWITCH_TO_LIST', 'link', '');
INSERT INTO `core_lang_text` VALUES(1091, '_TERM', 'link', '');
INSERT INTO `core_lang_text` VALUES(1092, '_HOMEPAGE', 'login', '');
INSERT INTO `core_lang_text` VALUES(1093, '_INTRO_STD_TEXT', 'login', '');
INSERT INTO `core_lang_text` VALUES(1094, '_JUMP_TO_LOGIN', 'login', '');
INSERT INTO `core_lang_text` VALUES(1095, '_LDAPACTIVE', 'login', '');
INSERT INTO `core_lang_text` VALUES(1096, '_LOGIN', 'login', '');
INSERT INTO `core_lang_text` VALUES(1097, '_LOGIN_ACCESSIBILITY', 'login', '');
INSERT INTO `core_lang_text` VALUES(1098, '_LOGIN_LEGEND', 'login', '');
INSERT INTO `core_lang_text` VALUES(1099, '_LOGIN_WITH', 'login', '');
INSERT INTO `core_lang_text` VALUES(1100, '_LOG_LOSTPWD', 'login', '');
INSERT INTO `core_lang_text` VALUES(1101, '_LOST_INSTRUCTION_PWD', 'login', '');
INSERT INTO `core_lang_text` VALUES(1102, '_LOST_INSTRUCTION_USER', 'login', '');
INSERT INTO `core_lang_text` VALUES(1103, '_LOST_TITLE_USER', 'login', '');
INSERT INTO `core_lang_text` VALUES(1104, '_NOACCESS', 'login', '');
INSERT INTO `core_lang_text` VALUES(1105, '_PASSNOMATCH', 'login', '');
INSERT INTO `core_lang_text` VALUES(1106, '_REGISTER_FOR_COURSE', 'login', '');
INSERT INTO `core_lang_text` VALUES(1107, '_REGISTER_FOR_COURSE_NO_REG', 'login', '');
INSERT INTO `core_lang_text` VALUES(1108, '_REG_ELAPSEDREQUEST', 'login', '');
INSERT INTO `core_lang_text` VALUES(1109, '_REG_PRIVACY_POLICY', 'login', '');
INSERT INTO `core_lang_text` VALUES(1110, '_TWO_USERS_LOGGED_WITH_SAME_USERNAME', 'login', '');
INSERT INTO `core_lang_text` VALUES(1111, '_UNLOGGED', 'login', '');
INSERT INTO `core_lang_text` VALUES(1112, '_ADDCUSTOM', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1113, '_CHECKALL', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1114, '_DEFAULT_MY_NAME', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1115, '_FROM_CUSTOM', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1116, '_LEVELS', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1117, '_MODMODULE', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1118, '_MY_NAME', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1119, '_ORDER', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1120, '_SYMBOL', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1121, '_SYMBOL_TITLE', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1122, '_TB_CM_CAPTION', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1123, '_TB_CM_SUMMARY', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1124, '_TB_FREE_MANMODULE_CAPTION', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1125, '_TB_MANMENU_CAPTION', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1126, '_TB_MANMENU_SUMMARY', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1127, '_TB_MANMODULE_CAPTION', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1128, '_TB_MANMODULE_SUMMARY', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1129, '_TITLE_ADDCUSTOM', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1130, '_TITLE_GRABMODULE', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1131, '_TITLE_MANMENU', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1132, '_TITLE_MENUVOICE', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1133, '_TITLE_MODULE', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1134, '_UNCHECKALL', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1135, '_YOURE_IMPORTING', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1136, '_YOURE_WORKING_ON_MODULE', 'manmenu', '');
INSERT INTO `core_lang_text` VALUES(1137, '_ADMIN_CONFIGURATION', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1138, '_ADMIN_MANAGER', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1139, '_ADMIN_RULES', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1140, '_ASSOCIATE_USER', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1141, '_BLIND_MAIN_MENU', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1142, '_BLIND_MENU_MODULES', 'menu', 'accessibility');
INSERT INTO `core_lang_text` VALUES(1143, '_CERTIFICATE', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1144, '_COMMUNICATION_MAN', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1145, '_CONFIGURATION', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1146, '_DASHBOARD', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1147, '_EVENTMANAGER', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1148, '_EVENTS', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1149, '_FIELD_MANAGER', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1150, '_FIRST_LINE_framework', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1151, '_FIRST_LINE_lms', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1152, '_IOTASK', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1153, '_JUMP_TO_PLATFORM', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1154, '_LANG', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1155, '_LISTUSER', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1156, '_MANAGEMENT_COURSE', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1157, '_MANAGEMENT_RESERVATION', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1158, '_MAN_CERTIFICATE', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1159, '_META_CERTIFICATE', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1160, '_MIDDLE_AREA', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1161, '_MODULE_NAME', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1162, '_NEWS_INTERNAL', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1163, '_PLAYERTEMPLATE', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1164, '_PUBLIC_ADMIN_MANAGER', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1165, '_PUBLIC_ADMIN_RULES', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1166, '_QUESTCATEGORY', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1167, '_QUEST_CATEGORY', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1168, '_REPORT_CERTIFICATE', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1169, '_RESERVATION', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1170, '_SUBSCRIBE_USER_TO_COURSE', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1171, '_TRASV_MANAGMENT', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1172, '_USER_MANAGMENT', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1173, '_WEBPAGES', 'menu', '');
INSERT INTO `core_lang_text` VALUES(1174, '_ADVICE', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1175, '_COURSECHART', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1176, '_COURSEREPORT', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1177, '_COURSESTATS', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1178, '_EPORTFOLIO', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1179, '_GRADEBOOK', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1180, '_GROUPS', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1181, '_HTMLFRONT', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1182, '_INFCOURSE', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1183, '_LIGHT_REPO', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1184, '_ORGANIZATION', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1185, '_PROFILE', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1186, '_PROJECT', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1187, '_QUEST_BANK', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1188, '_RESERVATION', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1189, '_STAT', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1190, '_STATCOURSE', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1191, '_STATUSER', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1192, '_STORAGE', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1193, '_TELESKILL_ROOM', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1194, '_WIKI', 'menu_course', '');
INSERT INTO `core_lang_text` VALUES(1195, '_AUTHORING', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1196, '_BLIND_MENU_LAT', 'menu_over', 'accessibility');
INSERT INTO `core_lang_text` VALUES(1197, '_BLIND_YOUR_INFO', 'menu_over', 'accessibility');
INSERT INTO `core_lang_text` VALUES(1198, '_COMMUNITY', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1199, '_COURSE_AUTOREGISTRATION', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1200, '_GO_TO_FRAMEWORK', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1201, '_MENUCOURSE', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1202, '_MENUGEN', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1203, '_MYCOMPETENCES', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1204, '_MYCOURSES', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1205, '_MY_AREA', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1206, '_MY_CERTIFICATE', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1207, '_PUBLIC_ADMIN_AREA', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1208, '_PUBLIC_CERTIFICATE_ADMIN', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1209, '_PUBLIC_COURSE_ADMIN', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1210, '_PUBLIC_FORUM', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1211, '_PUBLIC_NEWSLETTER_ADMIN', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1212, '_PUBLIC_REPORT_ADMIN', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1213, '_PUBLIC_SUBSCRIBE_ADMIN', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1214, '_PUBLIC_USER_ADMIN', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1215, '_SUPPORT_FORUM', 'menu_over', '');
INSERT INTO `core_lang_text` VALUES(1216, '_ATTACH_TITLE', 'message', '');
INSERT INTO `core_lang_text` VALUES(1217, '_FILTER_MESSAGE_FOR', 'message', '');
INSERT INTO `core_lang_text` VALUES(1218, '_HIGH', 'message', '');
INSERT INTO `core_lang_text` VALUES(1219, '_INBOX', 'message', '');
INSERT INTO `core_lang_text` VALUES(1220, '_LOW', 'message', '');
INSERT INTO `core_lang_text` VALUES(1221, '_MIME', 'message', '');
INSERT INTO `core_lang_text` VALUES(1222, '_MUST_INS_SUBJECT', 'message', '');
INSERT INTO `core_lang_text` VALUES(1223, '_NORMAL', 'message', '');
INSERT INTO `core_lang_text` VALUES(1224, '_OUTBOX', 'message', '');
INSERT INTO `core_lang_text` VALUES(1225, '_PRIORITY', 'message', '');
INSERT INTO `core_lang_text` VALUES(1226, '_REFRESH', 'message', '');
INSERT INTO `core_lang_text` VALUES(1227, '_TITLE_READ', 'message', '');
INSERT INTO `core_lang_text` VALUES(1228, '_VERYHIGH', 'message', '');
INSERT INTO `core_lang_text` VALUES(1229, '_VERYLOW', 'message', '');
INSERT INTO `core_lang_text` VALUES(1230, '_BLOCKS', 'middlearea', '');
INSERT INTO `core_lang_text` VALUES(1231, '_CHOOSE_WHO_CAN_SEE', 'middlearea', '');
INSERT INTO `core_lang_text` VALUES(1232, '_COMPLETE_USER_PROFILE', 'middlearea', '');
INSERT INTO `core_lang_text` VALUES(1233, '_ENABLE_AREA', 'middlearea', '');
INSERT INTO `core_lang_text` VALUES(1234, '_MIDDLE_AREA', 'middlearea', '');
INSERT INTO `core_lang_text` VALUES(1235, '_SIMPLE_USER_PROFILE', 'middlearea', '');
INSERT INTO `core_lang_text` VALUES(1236, '_ADD_NOTES', 'notes', '');
INSERT INTO `core_lang_text` VALUES(1237, '_MORET', 'notes', '');
INSERT INTO `core_lang_text` VALUES(1238, '_NOTES', 'notes', '');
INSERT INTO `core_lang_text` VALUES(1239, '_ALT_BRANCH_INTER', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1240, '_ALT_EMPTY', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1241, '_ALT_VERT_INTER', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1242, '_ATTEMPT', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1243, '_ATTEMPTS', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1244, '_AUTOPLAY', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1245, '_CONFIRM_EXIT', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1246, '_HIDETREE', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1247, '_LOCKED', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1248, '_OBJECTIVE', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1249, '_ORGANIZATION', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1250, '_ORGISTERMINATOR', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1251, '_ORGLOCKEDTITLE', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1252, '_ORGMILESTONE', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1253, '_ORGMILESTONE_END', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1254, '_ORGMILESTONE_START', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1255, '_ORGPLAYTITLE', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1256, '_ORGROOTNAME', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1257, '_ORG_ACCESS', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1258, '_PUBLISH_FROM', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1259, '_PUBLISH_TO', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1260, '_REPOSELECTDESTINATION', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1261, '_RESOURCE', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1262, '_SHOW_INTERACTIONS', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1263, '_TIME', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1264, '_VIEWTREE', 'organization', '');
INSERT INTO `core_lang_text` VALUES(1265, '_ASSIGNED_EXTRAFIELD', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1266, '_GROUPUSER_groupid', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1267, '_IMPORT_IGNORE', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1268, '_IMPORT_MAP', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1269, '_INSERTED_WAIT_FOR_ADMIN', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1270, '_ORGCHART_FOLDER_FIELD_ALT', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1271, '_ORGCHART_USER_FIELD', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1272, '_ORG_CHART', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1273, '_ORG_CHART_FIELD_DESCEND', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1274, '_ORG_CHART_FIELD_INHERIT', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1275, '_ORG_CHART_FIELD_WRITE', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1276, '_ORG_CHART_FIELD_WRITE_ABBR', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1277, '_ORG_CHART_IMPORT_CHARSET', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1278, '_ORG_CHART_IMPORT_FILE', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1279, '_ORG_CHART_IMPORT_HEADER', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1280, '_ORG_CHART_IMPORT_SEPARATOR', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1281, '_ORG_CHART_IMPORT_USERS', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1282, '_ORG_CHART_INHERIT', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1283, '_ORG_CHART_LIST_FIELDS', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1284, '_ROOT_RENAME', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1285, '_SHOW_SUSPENDED', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1286, '_USERID_DUPLICATE', 'organization_chart', '');
INSERT INTO `core_lang_text` VALUES(1287, '_ASSOCIATEUSERTOGROUP', 'permission', '');
INSERT INTO `core_lang_text` VALUES(1288, '_DELUSER_ORG_CHART', 'permission', '');
INSERT INTO `core_lang_text` VALUES(1289, '_HOME', 'permission', '');
INSERT INTO `core_lang_text` VALUES(1290, '_LESSON', 'permission', '');
INSERT INTO `core_lang_text` VALUES(1291, '_PUBLIC', 'permission', '');
INSERT INTO `core_lang_text` VALUES(1292, '_SEND_ALL', 'permission', '');
INSERT INTO `core_lang_text` VALUES(1293, '_SEND_UPPER', 'permission', '');
INSERT INTO `core_lang_text` VALUES(1294, '_UPPLOAD', 'permission', '');
INSERT INTO `core_lang_text` VALUES(1295, '_LMS', 'platform', '');
INSERT INTO `core_lang_text` VALUES(1296, '_ANSWER_NUMBER', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1297, '_ANSWER_TEXT', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1298, '_CAPTION_ANSWER', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1299, '_INSERT_POLL', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1300, '_NO_QUESTION_IN_POLL', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1301, '_POLL_ADDQUEST', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1302, '_POLL_ADD_FORM', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1303, '_POLL_ADD_ONE_ANSWER', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1304, '_POLL_AFTER_QUEST', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1305, '_POLL_ALREDY_VOTED', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1306, '_POLL_ANSWER_SUMMARY', 'poll', 'accessibility');
INSERT INTO `core_lang_text` VALUES(1307, '_POLL_BEGIN', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1308, '_POLL_CAPTION', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1309, '_POLL_COMPLETED', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1310, '_POLL_END_BACKTOLESSON', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1311, '_POLL_END_PAGE', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1312, '_POLL_FIRST_QUEST', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1313, '_POLL_LABEL_AFTER_QUEST', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1314, '_POLL_LAST_QUEST', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1315, '_POLL_PREV_PAGE', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1316, '_POLL_QUEST_ORDER', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1317, '_POLL_QUEST_TITLE', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1318, '_POLL_REMPOLL', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1319, '_POLL_SECTION', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1320, '_POLL_SUB_ONE_ANSWER', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1321, '_POLL_SUMMARY', 'poll', 'accessibility');
INSERT INTO `core_lang_text` VALUES(1322, '_QUEST', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1323, '_QUEST_ACRN_BREAK_PAGE', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1324, '_QUEST_ACRN_CHOICE', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1325, '_QUEST_ACRN_CHOICE_MULTIPLE', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1326, '_QUEST_ACRN_COURSE_VALUTATION', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1327, '_QUEST_ACRN_DOC_VALUTATION', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1328, '_QUEST_ACRN_EXTENDED_TEXT', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1329, '_QUEST_ACRN_TITLE', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1330, '_QUEST_ANSWER', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1331, '_QUEST_BREAK_PAGE', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1332, '_QUEST_CHOICE', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1333, '_QUEST_CHOICE_MULTIPLE', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1334, '_QUEST_CHOICE_MULTIPLE_NOTE', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1335, '_QUEST_CHOICE_NOTE', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1336, '_QUEST_COURSE_VALUTATION', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1337, '_QUEST_DOC_VALUTATION', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1338, '_QUEST_EXTENDED_TEXT', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1339, '_QUEST_TITLE', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1340, '_QUEST_TITLE_NOTE', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1341, '_SUMMARY_ANSWER', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1342, '_TEST_SECTION', 'poll', '');
INSERT INTO `core_lang_text` VALUES(1343, '_ADD_ASSESSMENT', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1344, '_ADD_EFFECT', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1345, '_ADD_RULE', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1346, '_ALT_ADD_EFFECT', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1347, '_ASSIGN_ADMIN', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1348, '_ASSIGN_ADMIN_TITLE', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1349, '_ASSIGN_COURSE', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1350, '_ASSIGN_COURSE_TITLE', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1351, '_CAPTION_PREASSESSMENT', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1352, '_CAPTION_PREASSESSMENT_RULE', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1353, '_DO_NOTHING', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1354, '_RULES', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1355, '_RULE_ACTION', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1356, '_RULE_DEFAULT', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1357, '_RULE_OVERLAPPED', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1358, '_RULE_TEXT', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1359, '_SUMMARY_PREASSESSMENT_RULE', 'preassessment', '');
INSERT INTO `core_lang_text` VALUES(1360, '_TEMPLATE', 'preferences', '');
INSERT INTO `core_lang_text` VALUES(1361, '_ACCESS_COUNT', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1362, '_ACCESS_TIME', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1363, '_ACTIVITY_OF', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1364, '_AVATAR_PHOTO_INSTRUCTION', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1365, '_CHANGEPASSWORD', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1366, '_CHANGEPOLICY', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1367, '_COMMUNITY', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1368, '_COMPETENCE_NAME', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1369, '_COMPETENCE_SCORE_GOT', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1370, '_CONTACTS', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1371, '_COURSE_AS_MENTOR', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1372, '_COURSE_AS_TEACHER', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1373, '_COURSE_AS_TUTOR', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1374, '_DELETED_USER_LIST', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1375, '_DELETION_DATE', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1376, '_FIELD_VALUE', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1377, '_FIRSTNAME_DELETER', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1378, '_FIRST_ACCESS', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1379, '_FORUM_MESSAGE', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1380, '_GOTO_BLOG', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1381, '_GOTO_BLOG_TITLE', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1382, '_GO_TO_PROFILE', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1383, '_IDST_DELETED_USER', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1384, '_LASTNAME_DELETER', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1385, '_LAST_PROFILE_VIEW', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1386, '_MESSAGE_TEXT', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1387, '_NEWPWDVALID', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1388, '_NEW_VISIT', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1389, '_NOAVATAR', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1390, '_NO_AUDIO_FOUND', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1391, '_NO_IMAGE_FOUND', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1392, '_NO_OTHER_FOUND', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1393, '_NO_PROFILE_VIEW', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1394, '_NO_VIDEO_FOUND', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1395, '_OLDPASSWRONG', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1396, '_OLD_PWD', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1397, '_OTHER_POLICY', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1398, '_PFL_POLICY_NOONE', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1399, '_PFL_POLICY_TEACHER', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1400, '_POLICY_ASSIGNED', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1401, '_PRIVATE_MESSAGE_FROM', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1402, '_PROFILE', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1403, '_REGISTER_DATE', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1404, '_SCORE_FINAL', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1405, '_SCORE_INIT', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1406, '_SHARED_FILE', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1407, '_SHOWME_ONLINE', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1408, '_TEACHER_CURRICULUM', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1409, '_TEACHER_PROFILE', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1410, '_TEACHER_PUBLICATIONS', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1411, '_TITLE_CHANGE', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1412, '_UNLIMITED_QUOTA', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1413, '_UP_OFFLINE', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1414, '_USERCOMPETENCES_CAPTION', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1415, '_USERCOURSE_CAPTION', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1416, '_USERCOURSE_STATS_SUMMARY', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1417, '_USERCOURSE_STATS_TITLE', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1418, '_USERCOURSE_STATUS', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1419, '_USERFORUMPARAM', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1420, '_USERID_DELETER', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1421, '_USEROFFLINE', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1422, '_USERONLINE', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1423, '_USERPARAM', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1424, '_USERPROFILE_SUMMARY', 'profile', 'accessibility');
INSERT INTO `core_lang_text` VALUES(1425, '_USER_AUDIO', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1426, '_USER_OTHER', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1427, '_USER_QUOTA', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1428, '_USER_STATUS', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1429, '_USER_VIDEO', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1430, '_USER_VIDEOS', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1431, '_WELCOME', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1432, '_WRITE_ASK_A_FRIEND', 'profile', '');
INSERT INTO `core_lang_text` VALUES(1433, '_MODPROJECTADMIN', 'project', '');
INSERT INTO `core_lang_text` VALUES(1434, '_MYPRJ', 'project', '');
INSERT INTO `core_lang_text` VALUES(1435, '_NEW_PROJECT', 'project', '');
INSERT INTO `core_lang_text` VALUES(1436, '_NOTHINGTOSEE', 'project', '');
INSERT INTO `core_lang_text` VALUES(1437, '_PADMINS', 'project', '');
INSERT INTO `core_lang_text` VALUES(1438, '_PGROUP', 'project', '');
INSERT INTO `core_lang_text` VALUES(1439, '_POPTIONS', 'project', '');
INSERT INTO `core_lang_text` VALUES(1440, '_PRJFILES', 'project', '');
INSERT INTO `core_lang_text` VALUES(1441, '_PRJNOTITLE', 'project', '');
INSERT INTO `core_lang_text` VALUES(1442, '_PRJNOVALIDGROUP', 'project', '');
INSERT INTO `core_lang_text` VALUES(1443, '_PRJPROGTOT', 'project', '');
INSERT INTO `core_lang_text` VALUES(1444, '_PRJTASKS', 'project', '');
INSERT INTO `core_lang_text` VALUES(1445, '_PRJTODO', 'project', '');
INSERT INTO `core_lang_text` VALUES(1446, '_PROJECT_MANAGER', 'project', '');
INSERT INTO `core_lang_text` VALUES(1447, '_PROJECT_SUMMARY', 'project', '');
INSERT INTO `core_lang_text` VALUES(1448, '_PSFILES', 'project', '');
INSERT INTO `core_lang_text` VALUES(1449, '_PSMSG', 'project', '');
INSERT INTO `core_lang_text` VALUES(1450, '_PSNEWS', 'project', '');
INSERT INTO `core_lang_text` VALUES(1451, '_PSTASKS', 'project', '');
INSERT INTO `core_lang_text` VALUES(1452, '_PSTODO', 'project', '');
INSERT INTO `core_lang_text` VALUES(1453, '_PTITLE', 'project', '');
INSERT INTO `core_lang_text` VALUES(1454, '_TASKDESC', 'project', '');
INSERT INTO `core_lang_text` VALUES(1455, '_TASKNAME', 'project', '');
INSERT INTO `core_lang_text` VALUES(1456, '_TASKPROGRESS', 'project', '');
INSERT INTO `core_lang_text` VALUES(1457, '_YOUONLY', 'project', '');
INSERT INTO `core_lang_text` VALUES(1458, '_ACTION', 'public_admin_manager', '');
INSERT INTO `core_lang_text` VALUES(1459, '_ADMIN_SPECIAL_SETTING', 'public_admin_manager', '');
INSERT INTO `core_lang_text` VALUES(1460, '_CATEGORY_IN_USE', 'questcategory', '');
INSERT INTO `core_lang_text` VALUES(1461, '_TITLE_QCAT', 'questcategory', '');
INSERT INTO `core_lang_text` VALUES(1462, '_ACCEPT', 'register', '');
INSERT INTO `core_lang_text` VALUES(1463, '_CHANGELANG', 'register', '');
INSERT INTO `core_lang_text` VALUES(1464, '_CHOOSE_NEW_PASSWORD', 'register', '');
INSERT INTO `core_lang_text` VALUES(1465, '_ERR_DUPLICATE_MAIL', 'register', '');
INSERT INTO `core_lang_text` VALUES(1466, '_ERR_DUPLICATE_USER', 'register', '');
INSERT INTO `core_lang_text` VALUES(1467, '_ERR_INVALID_MAIL', 'register', '');
INSERT INTO `core_lang_text` VALUES(1468, '_ERR_INVALID_USER', 'register', '');
INSERT INTO `core_lang_text` VALUES(1469, '_ERR_PASSWORD_MUSTBE_ALPHA', 'register', '');
INSERT INTO `core_lang_text` VALUES(1470, '_ERR_PASSWORD_NO_MATCH', 'register', '');
INSERT INTO `core_lang_text` VALUES(1471, '_ERR_POLICY_NOT_CHECKED', 'register', '');
INSERT INTO `core_lang_text` VALUES(1472, '_ERR_PWD_OLD', 'register', '');
INSERT INTO `core_lang_text` VALUES(1473, '_FIRST_ACCESS', 'register', '');
INSERT INTO `core_lang_text` VALUES(1474, '_GOTO_LOGIN', 'register', '');
INSERT INTO `core_lang_text` VALUES(1475, '_GROUPS_FIELDS', 'register', '');
INSERT INTO `core_lang_text` VALUES(1476, '_IMGSECTION', 'register', '');
INSERT INTO `core_lang_text` VALUES(1477, '_INEXISTENT_USER', 'register', '');
INSERT INTO `core_lang_text` VALUES(1478, '_INVALID_CODE', 'register', '');
INSERT INTO `core_lang_text` VALUES(1479, '_INVALID_RANDOM_CODE', 'register', '');
INSERT INTO `core_lang_text` VALUES(1480, '_LOGIN', 'register', '');
INSERT INTO `core_lang_text` VALUES(1481, '_LOST_INSTRUCTION_PWD', 'register', '');
INSERT INTO `core_lang_text` VALUES(1482, '_LOST_INSTRUCTION_USER', 'register', '');
INSERT INTO `core_lang_text` VALUES(1483, '_LOST_PWD_MAILTEXT', 'register', '');
INSERT INTO `core_lang_text` VALUES(1484, '_LOST_PWD_TITLE', 'register', '');
INSERT INTO `core_lang_text` VALUES(1485, '_LOST_TITLE_PWD', 'register', '');
INSERT INTO `core_lang_text` VALUES(1486, '_LOST_TITLE_USER', 'register', '');
INSERT INTO `core_lang_text` VALUES(1487, '_LOST_USERID_MAILTEXT', 'register', '');
INSERT INTO `core_lang_text` VALUES(1488, '_LOST_USERID_TITLE', 'register', '');
INSERT INTO `core_lang_text` VALUES(1489, '_MAIL_OBJECT', 'register', '');
INSERT INTO `core_lang_text` VALUES(1490, '_MAIL_SEND_SUCCESSFUL', 'register', '');
INSERT INTO `core_lang_text` VALUES(1491, '_MAIL_SEND_SUCCESSFUL_PWD', 'register', '');
INSERT INTO `core_lang_text` VALUES(1492, '_NEWPWDVALID', 'register', '');
INSERT INTO `core_lang_text` VALUES(1493, '_NEW_PASSWORD', 'register', '');
INSERT INTO `core_lang_text` VALUES(1494, '_NOTE', 'register', '');
INSERT INTO `core_lang_text` VALUES(1495, '_OLD_PWD', 'register', '');
INSERT INTO `core_lang_text` VALUES(1496, '_PASSWORD_TOO_SHORT', 'register', '');
INSERT INTO `core_lang_text` VALUES(1497, '_REG_CONFIRM_FAILED', 'register', '');
INSERT INTO `core_lang_text` VALUES(1498, '_REG_ELAPSEDREQUEST', 'register', '');
INSERT INTO `core_lang_text` VALUES(1499, '_REG_HOUR_REQUEST_LIMIT', 'register', '');
INSERT INTO `core_lang_text` VALUES(1500, '_REG_MAIL_TEXT', 'register', '');
INSERT INTO `core_lang_text` VALUES(1501, '_REG_MANDATORY', 'register', '');
INSERT INTO `core_lang_text` VALUES(1502, '_REG_NOTE', 'register', '');
INSERT INTO `core_lang_text` VALUES(1503, '_REG_NOT_ACTIVE', 'register', '');
INSERT INTO `core_lang_text` VALUES(1504, '_REG_PASS_MIN_CHAR', 'register', '');
INSERT INTO `core_lang_text` VALUES(1505, '_REG_PASS_MUST_BE_ALPNUM', 'register', '');
INSERT INTO `core_lang_text` VALUES(1506, '_REG_PRESONAL_CODE', 'register', '');
INSERT INTO `core_lang_text` VALUES(1507, '_REG_PRIVACY_ACCEPT', 'register', '');
INSERT INTO `core_lang_text` VALUES(1508, '_REG_PRIVACY_POLICY', 'register', '');
INSERT INTO `core_lang_text` VALUES(1509, '_REG_PRIVACY_POLICY_TILTE', 'register', '');
INSERT INTO `core_lang_text` VALUES(1510, '_REG_REMEMBER_PRIVACY', 'register', '');
INSERT INTO `core_lang_text` VALUES(1511, '_REG_SUCCESS', 'register', '');
INSERT INTO `core_lang_text` VALUES(1512, '_REG_USERID_DEF', 'register', '');
INSERT INTO `core_lang_text` VALUES(1513, '_REG_WAIT_FOR_ADMIN_OK', 'register', '');
INSERT INTO `core_lang_text` VALUES(1514, '_REG_YOUR_ABI_TO_ACCESS', 'register', '');
INSERT INTO `core_lang_text` VALUES(1515, '_RETYPE_PASSWORD', 'register', '');
INSERT INTO `core_lang_text` VALUES(1516, '_SELECT_GROUP', 'register', '');
INSERT INTO `core_lang_text` VALUES(1517, '_SELECT_GROUP_SUMMARY', 'register', '');
INSERT INTO `core_lang_text` VALUES(1518, '_SOME_MANDATORY_EMPTY', 'register', '');
INSERT INTO `core_lang_text` VALUES(1519, '_WHYCHANGEPWD', 'register', '');
INSERT INTO `core_lang_text` VALUES(1520, 'aggregate_report', 'report', '');
INSERT INTO `core_lang_text` VALUES(1521, 'courses_report', 'report', '');
INSERT INTO `core_lang_text` VALUES(1522, 'ORG_CHART_SUBDIVISION', 'report', '');
INSERT INTO `core_lang_text` VALUES(1523, 'REPORT_SHOW_RESULTS', 'report', '');
INSERT INTO `core_lang_text` VALUES(1524, 'user_report', 'report', '');
INSERT INTO `core_lang_text` VALUES(1525, '_AGGREGATE_ON', 'report', '');
INSERT INTO `core_lang_text` VALUES(1526, '_BACK_TO_LIST', 'report', '');
INSERT INTO `core_lang_text` VALUES(1527, '_CHOOSE_TIME', 'report', '');
INSERT INTO `core_lang_text` VALUES(1528, '_CHOOSE_USER_FOR_REPORT', 'report', '');
INSERT INTO `core_lang_text` VALUES(1529, '_COMPETENCESFILTER_TITLE', 'report', '');
INSERT INTO `core_lang_text` VALUES(1530, '_COMPETENCESFILTER_TITLE_DESC', 'report', '');
INSERT INTO `core_lang_text` VALUES(1531, '_COMPETENCES_DROPDOWN_NULL_SELECT', 'report', '');
INSERT INTO `core_lang_text` VALUES(1532, '_COURSES_DROPDOWN_NULL_SELECT', 'report', '');
INSERT INTO `core_lang_text` VALUES(1533, '_COURSES_FILTER_END_DATE', 'report', '');
INSERT INTO `core_lang_text` VALUES(1534, '_COURSES_FILTER_INSCRIPTION_DATE', 'report', '');
INSERT INTO `core_lang_text` VALUES(1535, '_COURSES_FILTER_SCORE_COURSE', 'report', '');
INSERT INTO `core_lang_text` VALUES(1536, '_COURSES_FILTER_SCORE_INIT', 'report', '');
INSERT INTO `core_lang_text` VALUES(1537, '_COURSES_FILTER_SESSION_NUMBER', 'report', '');
INSERT INTO `core_lang_text` VALUES(1538, '_COURSES_SELECTION_TITLE', 'report', '');
INSERT INTO `core_lang_text` VALUES(1539, '_COURSE_COMPLETED', 'report', '');
INSERT INTO `core_lang_text` VALUES(1540, '_COURSE_FIELDS', 'report', '');
INSERT INTO `core_lang_text` VALUES(1541, '_COURSE_FIELDS_INFO', 'report', '');
INSERT INTO `core_lang_text` VALUES(1542, '_COURSE_STARTED', 'report', '');
INSERT INTO `core_lang_text` VALUES(1543, '_CREATION_DATE', 'report', '');
INSERT INTO `core_lang_text` VALUES(1544, '_CURRENT_SELECTION', 'report', '');
INSERT INTO `core_lang_text` VALUES(1545, '_CUSTOM_BELT', 'report', '');
INSERT INTO `core_lang_text` VALUES(1546, '_DATE_COURSE_COMPLETED', 'report', '');
INSERT INTO `core_lang_text` VALUES(1547, '_DATE_INSCR', 'report', '');
INSERT INTO `core_lang_text` VALUES(1548, '_DATE_UNTIL_COURSE_END', 'report', '');
INSERT INTO `core_lang_text` VALUES(1549, '_DAY_FROM_SUBSCRIPTION', 'report', '');
INSERT INTO `core_lang_text` VALUES(1550, '_DAY_UNTIL_COURSE_END', 'report', '');
INSERT INTO `core_lang_text` VALUES(1551, '_FILTER_ALL_CONDS', 'report', '');
INSERT INTO `core_lang_text` VALUES(1552, '_FILTER_ONE_COND', 'report', '');
INSERT INTO `core_lang_text` VALUES(1553, '_FILTER_RESET', 'report', '');
INSERT INTO `core_lang_text` VALUES(1554, '_INSCR', 'report', '');
INSERT INTO `core_lang_text` VALUES(1555, '_LAST_MONTH', 'report', '');
INSERT INTO `core_lang_text` VALUES(1556, '_LAST_SIX_MONTH', 'report', '');
INSERT INTO `core_lang_text` VALUES(1557, '_LAST_THREE_MONTH', 'report', '');
INSERT INTO `core_lang_text` VALUES(1558, '_LAST_WEEK', 'report', '');
INSERT INTO `core_lang_text` VALUES(1559, '_LAST_YEAR', 'report', '');
INSERT INTO `core_lang_text` VALUES(1560, '_LO_COL_FIRSTATT', 'report', '');
INSERT INTO `core_lang_text` VALUES(1561, '_LO_COL_LASTATT', 'report', '');
INSERT INTO `core_lang_text` VALUES(1562, '_LO_COL_MILESTONE', 'report', '');
INSERT INTO `core_lang_text` VALUES(1563, '_LO_COL_TYPE', 'report', '');
INSERT INTO `core_lang_text` VALUES(1564, '_MAIL_BODY', 'report', '');
INSERT INTO `core_lang_text` VALUES(1565, '_MUSTBEGIN', 'report', '');
INSERT INTO `core_lang_text` VALUES(1566, '_NOACTIVE', 'report', '');
INSERT INTO `core_lang_text` VALUES(1567, '_NULL_COURSE_SELECTION', 'report', '');
INSERT INTO `core_lang_text` VALUES(1568, '_NULL_REPORT_RESULT', 'report', '');
INSERT INTO `core_lang_text` VALUES(1569, '_NULL_SELECTION', 'report', '');
INSERT INTO `core_lang_text` VALUES(1570, '_NUM', 'report', '');
INSERT INTO `core_lang_text` VALUES(1571, '_PERC', 'report', '');
INSERT INTO `core_lang_text` VALUES(1572, '_RA_CAT_COURSECATS', 'report', '');
INSERT INTO `core_lang_text` VALUES(1573, '_RA_CAT_TIME', 'report', '');
INSERT INTO `core_lang_text` VALUES(1574, '_RCS_CAT_COURSE_VAL', 'report', '');
INSERT INTO `core_lang_text` VALUES(1575, '_RCS_CAT_DOC_VAL', 'report', '');
INSERT INTO `core_lang_text` VALUES(1576, '_RCS_CAT_USER', 'report', '');
INSERT INTO `core_lang_text` VALUES(1577, '_RC_CAPTION', 'report', '');
INSERT INTO `core_lang_text` VALUES(1578, '_REPORT_COLUMNS', 'report', '');
INSERT INTO `core_lang_text` VALUES(1579, '_REPORT_COURSE_CONDITIONS', 'report', '');
INSERT INTO `core_lang_text` VALUES(1580, '_REPORT_COURSE_SELECTION', 'report', '');
INSERT INTO `core_lang_text` VALUES(1581, '_REPORT_DAILY', 'report', '');
INSERT INTO `core_lang_text` VALUES(1582, '_REPORT_FOR_ALL', 'report', '');
INSERT INTO `core_lang_text` VALUES(1583, '_REPORT_MOD_COLUMNS', 'report', '');
INSERT INTO `core_lang_text` VALUES(1584, '_REPORT_MOD_ROWS', 'report', '');
INSERT INTO `core_lang_text` VALUES(1585, '_REPORT_MONTHLY', 'report', '');
INSERT INTO `core_lang_text` VALUES(1586, '_REPORT_SEL_COLUMNS', 'report', '');
INSERT INTO `core_lang_text` VALUES(1587, '_REPORT_SEL_ROWS', 'report', '');
INSERT INTO `core_lang_text` VALUES(1588, '_REPORT_USER_TITLE_TIMEBELT', 'report', '');
INSERT INTO `core_lang_text` VALUES(1589, '_REPORT_USER_TITLE_TIMEBELT_DESC', 'report', '');
INSERT INTO `core_lang_text` VALUES(1590, '_REPORT_WEEKLY', 'report', '');
INSERT INTO `core_lang_text` VALUES(1591, '_RG_SUMMAMRY_MANAGMENT', 'report', '');
INSERT INTO `core_lang_text` VALUES(1592, '_RU_CAPTION', 'report', '');
INSERT INTO `core_lang_text` VALUES(1593, '_RU_CAT_COMMUNICATIONS', 'report', '');
INSERT INTO `core_lang_text` VALUES(1594, '_RU_CAT_COMPETENCES', 'report', '');
INSERT INTO `core_lang_text` VALUES(1595, '_RU_CAT_COURSES', 'report', '');
INSERT INTO `core_lang_text` VALUES(1596, '_RU_CAT_DELAY', 'report', '');
INSERT INTO `core_lang_text` VALUES(1597, '_RU_CAT_GAMES', 'report', '');
INSERT INTO `core_lang_text` VALUES(1598, '_RU_CAT_LO', 'report', '');
INSERT INTO `core_lang_text` VALUES(1599, '_RU_LO_MILESTONES', 'report', '');
INSERT INTO `core_lang_text` VALUES(1600, '_RU_LO_TYPES', 'report', '');
INSERT INTO `core_lang_text` VALUES(1601, '_SAVE_AND_BACK_TO_LIST', 'report', '');
INSERT INTO `core_lang_text` VALUES(1602, '_SAVE_BACK', 'report', '');
INSERT INTO `core_lang_text` VALUES(1603, '_SAVE_SCHED_NAME', 'report', '');
INSERT INTO `core_lang_text` VALUES(1604, '_SAVE_SHOW', 'report', '');
INSERT INTO `core_lang_text` VALUES(1605, '_SCHED_TEXT_WEEK', 'report', '');
INSERT INTO `core_lang_text` VALUES(1606, '_SELECT_LO_OPTIONS', 'report', '');
INSERT INTO `core_lang_text` VALUES(1607, '_SELECT_REPORT_CATEGORY', 'report', '');
INSERT INTO `core_lang_text` VALUES(1608, '_SELECT_THE_DATA_COL_NEEDED', 'report', '');
INSERT INTO `core_lang_text` VALUES(1609, '_SEL_COURSES', 'report', '');
INSERT INTO `core_lang_text` VALUES(1610, '_SEND_MAIL', 'report', '');
INSERT INTO `core_lang_text` VALUES(1611, '_SHOWED_COLUMNS', 'report', '');
INSERT INTO `core_lang_text` VALUES(1612, '_SHOW_NOSAVE', 'report', '');
INSERT INTO `core_lang_text` VALUES(1613, '_STATS_FIELDS_INFO', 'report', '');
INSERT INTO `core_lang_text` VALUES(1614, '_TAB_REP_CREATOR', 'report', '');
INSERT INTO `core_lang_text` VALUES(1615, '_TAB_REP_PUBLIC', 'report', '');
INSERT INTO `core_lang_text` VALUES(1616, '_TH_COURSEPATH', 'report', '');
INSERT INTO `core_lang_text` VALUES(1617, '_TH_ESTIMATED_TIME', 'report', '');
INSERT INTO `core_lang_text` VALUES(1618, '_TH_USER_COURSE_SCORE', 'report', '');
INSERT INTO `core_lang_text` VALUES(1619, '_TH_USER_INSCRIPTION_DATE', 'report', '');
INSERT INTO `core_lang_text` VALUES(1620, '_TH_USER_NUMBER_SESSION', 'report', '');
INSERT INTO `core_lang_text` VALUES(1621, '_TH_USER_START_SCORE', 'report', '');
INSERT INTO `core_lang_text` VALUES(1622, '_TIME_BELT', 'report', '');
INSERT INTO `core_lang_text` VALUES(1623, '_TIME_BELT_2', 'report', '');
INSERT INTO `core_lang_text` VALUES(1624, '_TIME_PERIOD_FILTER', 'report', '');
INSERT INTO `core_lang_text` VALUES(1625, '_TOTAL_SESSION', 'report', '');
INSERT INTO `core_lang_text` VALUES(1626, '_USER_CUSTOM_FIELDS', 'report', '');
INSERT INTO `core_lang_text` VALUES(1627, '_ADD_USER', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1628, '_ALT_ADD_USER', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1629, '_AREYOUSURE_ADD_SUBSCRIPTION', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1630, '_AREYOUSURE_DEL_SUBSCRIPTION', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1631, '_AVAILABLE_PLACES', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1632, '_CANCEL_REGISTRATION', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1633, '_CATEGORY_CAPTION', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1634, '_CATEGORY_GESTION', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1635, '_CATEGORY_MAX_SUBSCRIPTION', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1636, '_CHOOSE_SUBSCRIBE', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1637, '_DEADLINE', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1638, '_DEL_EVENT_REGISTRATION', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1639, '_EVENT_CAPTION', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1640, '_FROM_TIME', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1641, '_LOCATION_GESTION', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1642, '_MAX_SUBSCRIPTION_FOR_CATEGORY', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1643, '_MAX_USER', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1644, '_NO_RESERVATION_FOUND', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1645, '_NO_USERS_FOUND', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1646, '_NUMBER_SUBSCRIBED', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1647, '_REGISTRATION', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1648, '_RESERVATION', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1649, '_RESERVATION_CAPTION', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1650, '_RESERVATION_EVENTS', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1651, '_RESERVATION_MY_EVENTS', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1652, '_RESERVATION_PAST_EVENTS', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1653, '_RESERVATION_SUBSCRIBED_USER', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1654, '_RESERVATION_SUMMARY', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1655, '_ROOM_FULL', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1656, '_SET_ROOM_VIEW_PERM', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1657, '_SUBSCRIBE_EVENT', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1658, '_SWITCH_REGISTRATION', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1659, '_TO_TIME', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1660, '_UNDEFINITED', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1661, '_UNLIMITED_SUBSCRIPTION', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1662, '_VIEW_EVENT_USER', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1663, '_VIEW_USER_SUBSCRIBED', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1664, '_WRONG_DATE', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1665, '_WRONG_TIME', 'reservation', '');
INSERT INTO `core_lang_text` VALUES(1666, '_BACK_TOLIST', 'scorm', '');
INSERT INTO `core_lang_text` VALUES(1667, '_CONTENTPACKAGE', 'scorm', '');
INSERT INTO `core_lang_text` VALUES(1668, '_FILEUNSPECIFIED', 'scorm', '');
INSERT INTO `core_lang_text` VALUES(1669, '_SCORMIMGSECTION', 'scorm', '');
INSERT INTO `core_lang_text` VALUES(1670, '_SCORMIMPORTRESOURCES', 'scorm', '');
INSERT INTO `core_lang_text` VALUES(1671, '_SCORMLOAD', 'scorm', '');
INSERT INTO `core_lang_text` VALUES(1672, '_SCORMSECTIONNAME', 'scorm', '');
INSERT INTO `core_lang_text` VALUES(1673, '_SCORM_ADD_FORM', 'scorm', '');
INSERT INTO `core_lang_text` VALUES(1674, '_MANUAL_SEL', 'simplesel', '');
INSERT INTO `core_lang_text` VALUES(1675, '_MSG_HASMANUAL_1', 'simplesel', '');
INSERT INTO `core_lang_text` VALUES(1676, '_MSG_HASMANUAL_2', 'simplesel', '');
INSERT INTO `core_lang_text` VALUES(1677, '_SIMPLESEL_SUMMARY', 'simplesel', '');
INSERT INTO `core_lang_text` VALUES(1678, '_SIMPLESEL_TITLE', 'simplesel', '');
INSERT INTO `core_lang_text` VALUES(1679, '_ALERT_TEXT_SMS', 'sms', 'sms');
INSERT INTO `core_lang_text` VALUES(1680, '_APPROVED_SUBSCRIBED_TEXT_SMS', 'sms', 'sms');
INSERT INTO `core_lang_text` VALUES(1681, '_APPROVED_USER_TEXT_SMS', 'sms', 'sms');
INSERT INTO `core_lang_text` VALUES(1682, '_DELETED_USER_TEXT_SMS', 'sms', 'sms');
INSERT INTO `core_lang_text` VALUES(1683, '_MODIFIED_USER_TEXT_SMS', 'sms', 'sms');
INSERT INTO `core_lang_text` VALUES(1684, '_NEW_FORUM_BODY_SMS', 'sms', 'sms');
INSERT INTO `core_lang_text` VALUES(1685, '_NEW_FORUM_SMS', 'sms', 'sms');
INSERT INTO `core_lang_text` VALUES(1686, '_NEW_MESSAGE_INSERT_IN_THREAD_SMS', 'sms', 'sms');
INSERT INTO `core_lang_text` VALUES(1687, '_NEW_THREAD_INSERT_IN_FORUM_SMS', 'sms', 'sms');
INSERT INTO `core_lang_text` VALUES(1688, '_PASSWORD_CHANGED_SMS', 'sms', 'sms');
INSERT INTO `core_lang_text` VALUES(1689, '_REGISTERED_USER_TEXT_SMS', 'sms', 'sms');
INSERT INTO `core_lang_text` VALUES(1690, '_TO_APPROVE_GROUP_USER_TEXT_SMS', 'sms', 'sms');
INSERT INTO `core_lang_text` VALUES(1691, '_TO_APPROVE_USER_TEXT_SMS', 'sms', 'sms');
INSERT INTO `core_lang_text` VALUES(1692, '_WAITING_USER_TEXT_SMS', 'sms', 'sms');
INSERT INTO `core_lang_text` VALUES(1693, '_YOU_RECIVE_MSG_TEXT_SMS', 'sms', 'sms');
INSERT INTO `core_lang_text` VALUES(1694, '_CONNECTED_ACCOUNTS', 'social', '');
INSERT INTO `core_lang_text` VALUES(1695, '_CONNECT_YOUR_ACCOUNT_WITH', 'social', '');
INSERT INTO `core_lang_text` VALUES(1696, 'ab-initio', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1697, 'attempted', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1698, 'completed', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1699, 'failed', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1700, 'incomplete', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1701, 'not attempted', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1702, 'not_attempted', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1703, 'passed', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1704, '_ACCESSES', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1705, '_ACTIVATE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1706, '_ACTIVE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1707, '_ACTIVE_TAB', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1708, '_ACTIVITY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1709, '_ADD', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1710, '_ADD_TAGS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1711, '_ADMINISTRATOR', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1712, '_ADMINISTRATORS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1713, '_ADVANCED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1714, '_ADVANCED_SEARCH', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1715, '_ALL', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1716, '_ALL_CATEGORIES', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1717, '_ALL_COURSES', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1718, '_ALL_PAGES', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1719, '_ALT_CHECK', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1720, '_ALT_LESS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1721, '_ALT_MORE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1722, '_ALT_ROOT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1723, '_ANSWER', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1724, '_APPROVE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1725, '_APPROVE_WAITING_USER', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1726, '_AREYOUSURE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1727, '_ASSESSMENT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1728, '_ASSIGN', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1729, '_ASSIGN_ADMIN', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1730, '_ASSIGN_USERS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1731, '_ATTACHMENT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1732, '_ATTENDANCE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1733, '_AUTHOR', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1734, '_AUTODETECT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1735, '_AVATAR', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1736, '_AVERANGE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1737, '_BACK', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1738, '_BASIC_SEARCH', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1739, '_BY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1740, '_CALENDAR', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1741, '_CANCEL', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1742, '_CATALOGUE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1743, '_CATEGORIZATION', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1744, '_CATEGORIZE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1745, '_CATEGORY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1746, '_CHAPTERS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1747, '_CHAT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1748, '_CLASSROOM', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1749, '_CLOSE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1750, '_CODE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1751, '_COLLAPSE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1752, '_COMMENTS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1753, '_COMMUNICATIONS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1754, '_COMMUNITY_BLOG', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1755, '_COMPANY_BLOG', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1756, '_COMPETENCE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1757, '_COMPETENCES', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1758, '_COMPLETED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1759, '_CONFIRM', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1760, '_CONNECT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1761, '_CONNECTION_ERROR', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1762, '_CONTAINS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1763, '_CONTENTS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1764, '_CONTENT_LIBRARY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1765, '_CONTEST', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1766, '_CONTINUE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1767, '_COURSE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1768, '_COURSEPATH', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1769, '_COURSES', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1770, '_COURSE_CODE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1771, '_COURSE_LIST', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1772, '_COURSE_NAME', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1773, '_COURSE_S_FREE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1774, '_CREATE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1775, '_CREDITS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1776, '_CURRENT_FILE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1777, '_DATE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1778, '_DATE_BEGIN', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1779, '_DATE_END', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1780, '_DATE_FIRST_ACCESS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1781, '_DATE_FORMAT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1782, '_DATE_LAST_ACCESS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1783, '_DAY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1784, '_DAYS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1785, '_DEACTIVATE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1786, '_DEFAULT_LANGUAGE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1787, '_DEL', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1788, '_DELETE_FILE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1789, '_DEL_SELECTED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1790, '_DEMODERATE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1791, '_DENY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1792, '_DESCRIPTION', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1793, '_DETAILS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1794, '_DIFFICULTY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1795, '_DIFFICULT_DIFFICULT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1796, '_DIFFICULT_EASY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1797, '_DIFFICULT_MEDIUM', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1798, '_DIFFICULT_VERYDIFFICULT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1799, '_DIFFICULT_VERYEASY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1800, '_DIMDIM', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1801, '_DISCONNECT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1802, '_DOWN', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1803, '_DOWNLOAD', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1804, '_EDITION', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1805, '_EDITIONS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1806, '_EDIT_SCORE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1807, '_EDIT_SETTINGS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1808, '_ELEARNING', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1809, '_EMAIL', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1810, '_EMPTY_SELECTION', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1811, '_END', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1812, '_ENDELEM', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1813, '_ENDS_WITH', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1814, '_ENROLLRULES', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1815, '_ENROL_COUNT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1816, '_ENTER', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1817, '_ENVIRONMENT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1818, '_EQUAL', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1819, '_ERRORS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1820, '_ERROR_MOVEONDESCENDANT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1821, '_ERROR_NONAME', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1822, '_ERROR_UPLOAD', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1823, '_EVENT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1824, '_EXPAND', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1825, '_EXPIRATION_DATE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1826, '_EXPORT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1827, '_EXPORT_CSV', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1828, '_EXPORT_HTML', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1829, '_EXPORT_XLS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1830, '_EXPORT_XML', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1831, '_FACEBOOK', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1832, '_FIELD_NAME', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1833, '_FILE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1834, '_FILENAME', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1835, '_FILTER', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1836, '_FILTER_ALL_CONDS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1837, '_FILTER_ONE_COND', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1838, '_FINAL_SCORE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1839, '_FIRSTNAME', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1840, '_FIX_SEQUENCE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1841, '_FORUM', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1842, '_FROM', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1843, '_FULLNAME', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1844, '_FUNCTIONAL_ROLE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1845, '_GAP', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1846, '_GOOGLE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1847, '_GROUPS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1848, '_HEIGHT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1849, '_HIDDEN', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1850, '_HISTORY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1851, '_HOURS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1852, '_IMAGE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1853, '_IMAGES', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1854, '_IMPORT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1855, '_IMPORTANT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1856, '_IMPORT_FROM_XML', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1857, '_INHERIT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1858, '_INSERT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1859, '_INSTRUCTION', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1860, '_INVALID_EXTENSION', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1861, '_JUMP', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1862, '_JUMP_TO', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1863, '_LABEL', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1864, '_LABELS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1865, '_LANGUAGE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1866, '_LASTNAME', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1867, '_LEARNING_OBJECTS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1868, '_LEVEL', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1869, '_LINK', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1870, '_LINKEDIN', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1871, '_LOADED_FILE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1872, '_LOADING', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1873, '_LOCATION', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1874, '_LOGOUT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1875, '_LOG_USERS_TO_FNCROLE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1876, '_LOG_USERS_TO_GROUP', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1877, '_MAKE_A_COPY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1878, '_MANAGE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1879, '_MANAGE_GROUPS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1880, '_MANDATORY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1881, '_MANUAL', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1882, '_MAN_MENU', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1883, '_MARK_AS_IMPORTANT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1884, '_MAX_SCORE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1885, '_MEET', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1886, '_MESSAGES', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1887, '_MIME_TYPE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1888, '_MINUTES', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1889, '_MIN_SCORE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1890, '_MOD', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1891, '_MODERATE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1892, '_MOD_SELECTED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1893, '_MOD_TITLE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1894, '_MONTH_01', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1895, '_MONTH_02', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1896, '_MONTH_03', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1897, '_MONTH_04', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1898, '_MONTH_05', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1899, '_MONTH_06', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1900, '_MONTH_07', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1901, '_MONTH_08', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1902, '_MONTH_09', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1903, '_MONTH_10', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1904, '_MONTH_11', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1905, '_MONTH_12', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1906, '_MORE_ACTIONS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1907, '_MORE_ATTACHMENT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1908, '_MORE_INFO', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1909, '_MOVE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1910, '_MOVE_DOWN', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1911, '_MOVE_UP', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1912, '_NAME', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1913, '_NEVER', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1914, '_NEW', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1915, '_NEWS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1916, '_NEWSLETTER', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1917, '_NEW_CATEGORY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1918, '_NEW_COURSE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1919, '_NEW_EVENT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1920, '_NEW_FILTER', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1921, '_NEW_FOLDER', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1922, '_NEW_USER', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1923, '_NEXT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1924, '_NO', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1925, '_NONE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1926, '_NOTES', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1927, '_NOTITLE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1928, '_NOT_ASSIGNED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1929, '_NOT_CONTAINS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1930, '_NOT_EQUAL', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1931, '_NOT_SATISFIED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1932, '_NOT_STARTED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1933, '_NOT_TRANSLATED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1934, '_NO_ANSWER', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1935, '_NO_BACK', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1936, '_NO_CATEGORY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1937, '_NO_CONTENT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1938, '_OF', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1939, '_OFF', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1940, '_ON', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1941, '_ONEMONTH', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1942, '_ONLY_ONCE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1943, '_OPEN', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1944, '_OPERATION_FAILURE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1945, '_OPERATION_SUCCESSFUL', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1946, '_ORDER_BY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1947, '_ORD_ASC', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1948, '_ORD_ASC_TITLE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1949, '_ORD_DESC', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1950, '_ORD_DESC_ALT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1951, '_ORD_DESC_TITLE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1952, '_ORGCHART', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1953, '_ORGCHART_ADDNODE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1954, '_PAGES', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1955, '_PASSWORD', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1956, '_PERCENTAGE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1957, '_PLANNED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1958, '_PLAY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1959, '_PLAY_CHANCE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1960, '_PREREQUISITES', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1961, '_PREV', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1962, '_PREVELEM', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1963, '_PREVIEW', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1964, '_PREV_STEP', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1965, '_PROGRESS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1966, '_PROPERTIES', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1967, '_PUBLIC_ADMIN_USER', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1968, '_PUBLISH', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1969, '_QUESTION', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1970, '_RE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1971, '_REACTIVATE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1972, '_READ', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1973, '_RECIPIENTS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1974, '_REGISTER', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1975, '_REGISTER_DATE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1976, '_REMOVE_FROM_NODE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1977, '_REPLY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1978, '_REPOPASTELO', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1979, '_REPORT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1980, '_REQUIRED_SCORE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1981, '_RESET', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1982, '_ROLLBACK', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1983, '_ROW', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1984, '_SAVE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1985, '_SCHEDULE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1986, '_SCORE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1987, '_SEARCH', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1988, '_SECONDS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1989, '_SELECT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1990, '_SELECTED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1991, '_SELECT_ALL', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1992, '_SEND', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1993, '_SENDER', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1994, '_SEND_TO', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1995, '_SET', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1996, '_SHORTDESC', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1997, '_SHOW', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1998, '_SHOW_RESULTS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(1999, '_SIGNATURE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2000, '_SORT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2001, '_STANDINGS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2002, '_START', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2003, '_STARTED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2004, '_STARTS_WITH', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2005, '_START_DATE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2006, '_START_PAGE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2007, '_START_TIME', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2008, '_STATISTICS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2009, '_STATUS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2010, '_SUBJECT', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2011, '_SUBSCRIBE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2012, '_SUBSCRIBED_BY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2013, '_SUSPEND', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2014, '_SUSPENDED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2015, '_TABS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2016, '_TAGS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2017, '_TELESKILL', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2018, '_TEXTOF', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2019, '_TIME_PERIODS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2020, '_TITLE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2021, '_TO', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2022, '_TOTAL', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2023, '_TOTAL_TIME', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2024, '_TRANSACTION', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2025, '_TWITTER', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2026, '_TYPE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2027, '_TYPOLOGY', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2028, '_UNASSIGN', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2029, '_UNDO', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2030, '_UNLIMITED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2031, '_UNPUBLISH', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2032, '_UNREAD', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2033, '_UNSELECT_ALL', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2034, '_UNTIL_COMPLETED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2035, '_UP', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2036, '_UPLOAD', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2037, '_URL', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2038, '_USER', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2039, '_USERNAME', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2040, '_USERS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2041, '_USER_STATUS_BEGIN', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2042, '_USER_STATUS_CANCELLED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2043, '_USER_STATUS_CONFIRMED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2044, '_USER_STATUS_END', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2045, '_USER_STATUS_RESERVED', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2046, '_USER_STATUS_SUBS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2047, '_USER_STATUS_SUSPEND', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2048, '_VERSION', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2049, '_VIDEOCONFERENCE', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2050, '_VIEW', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2051, '_VIEW_PERMISSION', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2052, '_WAITING', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2053, '_WAITING_USERS', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2054, '_WARNING', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2055, '_WIDTH', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2056, '_YEAR', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2057, '_YES', 'standard', '');
INSERT INTO `core_lang_text` VALUES(2058, '_AT_HOUR', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2059, '_FOR_day', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2060, '_FOR_month', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2061, '_FOR_TITLE_day', 'statistic', 'accessibility');
INSERT INTO `core_lang_text` VALUES(2062, '_FOR_TITLE_month', 'statistic', 'accessibility');
INSERT INTO `core_lang_text` VALUES(2063, '_FOR_TITLE_week', 'statistic', 'accessibility');
INSERT INTO `core_lang_text` VALUES(2064, '_FOR_TITLE_year', 'statistic', 'accessibility');
INSERT INTO `core_lang_text` VALUES(2065, '_FOR_week', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2066, '_FOR_year', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2067, '_HOW_MUCH_TIME', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2068, '_LAST_ACTION_AT', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2069, '_LAST_OP', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2070, '_NUMBER_OF_OP', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2071, '_ORD_FOR_HM', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2072, '_ORD_FOR_NOP', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2073, '_ORD_FOR_SST', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2074, '_PAGE_VIEW', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2075, '_SESSION_STARTED', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2076, '_TIME_IN', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2077, '_TYPE_OF_OPERATION', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2078, '_USERS_LIST_CAPTION', 'statistic', 'accessibility');
INSERT INTO `core_lang_text` VALUES(2079, '_USERS_LIST_DETAILS_CAPTION', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2080, '_USERS_LIST_DETAILS_SUMMARY', 'statistic', 'accessibility');
INSERT INTO `core_lang_text` VALUES(2081, '_USERS_LIST_SUMMARY', 'statistic', 'accessibility');
INSERT INTO `core_lang_text` VALUES(2082, '_USER_TOTAL_TIME', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2083, '_VIEW_SESSION_DETAILS', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2084, '_VIEW_SESSION_DETAILS_ALT', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2085, '_WEEK_DAY_0_SHORT', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2086, '_WEEK_DAY_1_SHORT', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2087, '_WEEK_DAY_2_SHORT', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2088, '_WEEK_DAY_3_SHORT', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2089, '_WEEK_DAY_4_SHORT', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2090, '_WEEK_DAY_5_SHORT', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2091, '_WEEK_DAY_6_SHORT', 'statistic', '');
INSERT INTO `core_lang_text` VALUES(2092, '_FILTEROBJECTFINISHED', 'stats', '');
INSERT INTO `core_lang_text` VALUES(2093, '_FILTERSTATUSSELECTONEOPTION', 'stats', '');
INSERT INTO `core_lang_text` VALUES(2094, '_ORGPLAYTITLE', 'stats', '');
INSERT INTO `core_lang_text` VALUES(2095, '_PROGRESS', 'stats', '');
INSERT INTO `core_lang_text` VALUES(2096, '_STATFORUSER', 'stats', '');
INSERT INTO `core_lang_text` VALUES(2097, '_STATISTIC', 'stats', '');
INSERT INTO `core_lang_text` VALUES(2098, '_STATNOTRACKFORUSER', 'stats', '');
INSERT INTO `core_lang_text` VALUES(2099, '_STATSFORITEM', 'stats', '');
INSERT INTO `core_lang_text` VALUES(2100, '_STATSITEM', 'stats', '');
INSERT INTO `core_lang_text` VALUES(2101, '_STATSUSERITEM', 'stats', '');
INSERT INTO `core_lang_text` VALUES(2102, '_STATS_FULLNAME', 'stats', '');
INSERT INTO `core_lang_text` VALUES(2103, '_STATS_USERS', 'stats', '');
INSERT INTO `core_lang_text` VALUES(2104, '_HOMEREPOROOTNAME', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2105, '_LOCKED', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2106, '_LONAME_faq', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2107, '_LONAME_glossary', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2108, '_LONAME_htmlpage', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2109, '_LONAME_item', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2110, '_LONAME_link', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2111, '_LONAME_poll', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2112, '_LONAME_scoitem', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2113, '_LONAME_scormorg', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2114, '_LONAME_test', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2115, '_ORGFOLDERNAME', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2116, '_ORGISTERMINATOR', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2117, '_ORGLOCKEDTITLE', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2118, '_ORGPLAYTITLE', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2119, '_ORGROOTNAME', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2120, '_PUBREPOROOTNAME', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2121, '_RENAMEFOLDER', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2122, '_REPOCOPYLO', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2123, '_REPOCREATELO', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2124, '_REPOSELECTDESTINATION', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2125, '_RULES', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2126, '_SELECTLO', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2127, '_TARGETMOVEFOLDER', 'storage', '');
INSERT INTO `core_lang_text` VALUES(2128, '_ABSENT', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2129, '_BEFORE_THIS_APPROVE', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2130, '_CAPTION_SELECT_LEVELS', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2131, '_CHOOSE_SUBSCRIBE', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2132, '_CORRECT', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2133, '_DATE_BEGIN_VALIDITY', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2134, '_DATE_EXPIRE_VALIDITY', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2135, '_DATE_FIRST_COMPLETE', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2136, '_DATE_LAST_COMPLETE', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2137, '_DENY_SUBSCRIBED_TEXT_SMS', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2138, '_EMPTYSPACE', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2139, '_IMPORT_FILE', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2140, '_IMPORT_FROM_COURSE', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2141, '_IMPORT_HEADER', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2142, '_IMPORT_INFO', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2143, '_INSERT_CORRECT', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2144, '_INSERT_NOT_NEEDED', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2145, '_INSER_STATUS', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2146, '_JUSTIFIED', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2147, '_LEVEL_TO_IMPORT', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2148, '_NOT_EXPIRED_WITHOUT_DATE', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2149, '_NOT_EXPIRED_WITH_DATE', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2150, '_NOT_JUSTIFIED', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2151, '_NOT_NEEDED', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2152, '_ONLY_EXPIRED', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2153, '_RESET_VALIDITY_DATES', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2154, '_SELECT_WHO_CONFIRM', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2155, '_SEND_ALERT', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2156, '_SHOW_ONLY', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2157, '_STATUS_TO_IMPORT', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2158, '_SUBSCRIBE_ACCEPT', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2159, '_SUBSCRIBE_REFUSE', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2160, '_SUMMARY_SELECT_LEVEL', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2161, '_SUMMARY_SELECT_WHO_CONFIRM', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2162, '_USER_IS_BUSY', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2163, '_USER_STATUS_OVERBOOKING', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2164, '_USER_SUBSCRIBED', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2165, '_VALID_AT_DATE', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2166, '_WAIT', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2167, '_YOUCANSUBSCRIBE', 'subscribe', '');
INSERT INTO `core_lang_text` VALUES(2168, '_ADDMESSAGE', 'sysforum', '');
INSERT INTO `core_lang_text` VALUES(2169, '_LOCKEDMESS', 'sysforum', '');
INSERT INTO `core_lang_text` VALUES(2170, '_LOCKMESS', 'sysforum', '');
INSERT INTO `core_lang_text` VALUES(2171, '_POPULAR', 'tags', '');
INSERT INTO `core_lang_text` VALUES(2172, '_TAGS_TIPS', 'tags', '');
INSERT INTO `core_lang_text` VALUES(2173, '_YOURS', 'tags', '');
INSERT INTO `core_lang_text` VALUES(2174, '_ALL_DIFFICULT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2175, '_ALL_QUEST_CATEGORY', 'test', '');
INSERT INTO `core_lang_text` VALUES(2176, '_ALL_QUEST_TYPE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2177, '_BONUS_SCORE_FOR_TEST', 'test', '');
INSERT INTO `core_lang_text` VALUES(2178, '_CURRENT_SELECTION_COUNT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2179, '_DESELECT_PAGE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2180, '_EMPTY_ANSWER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2181, '_FEEDBACK_MANAGEMENT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2182, '_FEEDBACK_TEXT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2183, '_GIFT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2184, '_HARD', 'test', '');
INSERT INTO `core_lang_text` VALUES(2185, '_MANDATORY_ANSWER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2186, '_MAX_ATTEMPT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2187, '_NEED_ANSWER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2188, '_NEW_SCORE_FOR_QUESTION', 'test', '');
INSERT INTO `core_lang_text` VALUES(2189, '_NEW_TEST', 'test', '');
INSERT INTO `core_lang_text` VALUES(2190, '_ORDER_TYPE_CATEGORY', 'test', '');
INSERT INTO `core_lang_text` VALUES(2191, '_ORDER_TYPE_RANDOM', 'test', '');
INSERT INTO `core_lang_text` VALUES(2192, '_QUEST', 'test', '');
INSERT INTO `core_lang_text` VALUES(2193, '_QUEST_ACRN_ASSOCIATE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2194, '_QUEST_ACRN_BREAK_PAGE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2195, '_QUEST_ACRN_CHOICE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2196, '_QUEST_ACRN_CHOICE_MULTIPLE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2197, '_QUEST_ACRN_EXTENDED_TEXT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2198, '_QUEST_ACRN_HOT_TEXT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2199, '_QUEST_ACRN_INLINE_CHOICE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2200, '_QUEST_ACRN_TEXT_ENTRY', 'test', '');
INSERT INTO `core_lang_text` VALUES(2201, '_QUEST_ACRN_TITLE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2202, '_QUEST_ACRN_UPLOAD', 'test', '');
INSERT INTO `core_lang_text` VALUES(2203, '_QUEST_ANSWER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2204, '_QUEST_ASSOCIATE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2205, '_QUEST_BREAK_PAGE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2206, '_QUEST_CHOICE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2207, '_QUEST_CHOICE_MULTIPLE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2208, '_QUEST_EXTENDED_TEXT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2209, '_QUEST_FREEANSWER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2210, '_QUEST_HOT_TEXT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2211, '_QUEST_HOT_TEXT_ISTRUCTION', 'test', '');
INSERT INTO `core_lang_text` VALUES(2212, '_QUEST_INLINE_CHOICE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2213, '_QUEST_INLINE_CHOICE_NOTE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2214, '_QUEST_NONE_ANSWER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2215, '_QUEST_REFER_TAG', 'test', '');
INSERT INTO `core_lang_text` VALUES(2216, '_QUEST_TEXT_ENTRY', 'test', '');
INSERT INTO `core_lang_text` VALUES(2217, '_QUEST_TE_ANSWERHERE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2218, '_QUEST_TITLE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2219, '_QUEST_TM2_DIFFERENCE_FROM_PREVIOUS', 'test', '');
INSERT INTO `core_lang_text` VALUES(2220, '_QUEST_TM2_SCORE_DIFFERENCE_FROM_PREVIOUS', 'test', '');
INSERT INTO `core_lang_text` VALUES(2221, '_QUEST_TM2_SETDIFFICULT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2222, '_QUEST_TM2_SETSCORE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2223, '_QUEST_TM2_SETTIME', 'test', '');
INSERT INTO `core_lang_text` VALUES(2224, '_QUEST_UPLOAD', 'test', '');
INSERT INTO `core_lang_text` VALUES(2225, '_SELECT_PAGE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2226, '_SUSPENSION_NUM_ATTEMPTS', 'test', '');
INSERT INTO `core_lang_text` VALUES(2227, '_SUSPENSION_NUM_HOURS', 'test', '');
INSERT INTO `core_lang_text` VALUES(2228, '_SUSPENSION_PREREQUISITES', 'test', '');
INSERT INTO `core_lang_text` VALUES(2229, '_TEST_ADDQUEST', 'test', '');
INSERT INTO `core_lang_text` VALUES(2230, '_TEST_ADD_FORM', 'test', '');
INSERT INTO `core_lang_text` VALUES(2231, '_TEST_ADD_ONE_ANSWER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2232, '_TEST_AFTER_QUEST', 'test', '');
INSERT INTO `core_lang_text` VALUES(2233, '_TEST_ANSWER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2234, '_TEST_ANSWER_CHECK', 'test', '');
INSERT INTO `core_lang_text` VALUES(2235, '_TEST_ANSWER_NOTCHECK', 'test', '');
INSERT INTO `core_lang_text` VALUES(2236, '_TEST_ASSOCIATE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2237, '_TEST_BACK_TO_SETTIME', 'test', '');
INSERT INTO `core_lang_text` VALUES(2238, '_TEST_BEGIN', 'test', '');
INSERT INTO `core_lang_text` VALUES(2239, '_TEST_CAN_TRAVEL', 'test', '');
INSERT INTO `core_lang_text` VALUES(2240, '_TEST_CAN_TRAVEL_NO', 'test', '');
INSERT INTO `core_lang_text` VALUES(2241, '_TEST_CAPTION', 'test', '');
INSERT INTO `core_lang_text` VALUES(2242, '_TEST_COMPILE_TIME', 'test', '');
INSERT INTO `core_lang_text` VALUES(2243, '_TEST_COMPLETED', 'test', '');
INSERT INTO `core_lang_text` VALUES(2244, '_TEST_CONTINUE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2245, '_TEST_CORRECT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2246, '_TEST_END_BACKTOLESSON', 'test', '');
INSERT INTO `core_lang_text` VALUES(2247, '_TEST_END_PAGE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2248, '_TEST_FAILED', 'test', '');
INSERT INTO `core_lang_text` VALUES(2249, '_TEST_FILE_NOT_ATTACH', 'test', '');
INSERT INTO `core_lang_text` VALUES(2250, '_TEST_FIRST_QUEST', 'test', '');
INSERT INTO `core_lang_text` VALUES(2251, '_TEST_IC_TITLE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2252, '_TEST_IFCORRECT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2253, '_TEST_IFINCORRECT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2254, '_TEST_INCORRECT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2255, '_TEST_INFO', 'test', '');
INSERT INTO `core_lang_text` VALUES(2256, '_TEST_INSERT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2257, '_TEST_ISCORRECT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2258, '_TEST_ISNOT_THECORRECT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2259, '_TEST_IS_THECORRECT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2260, '_TEST_LAST_QUEST', 'test', '');
INSERT INTO `core_lang_text` VALUES(2261, '_TEST_MANUAL_SCORE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2262, '_TEST_MAXSCORE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2263, '_TEST_MM1_ANSWER_ORDER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2264, '_TEST_MM1_ANSWER_RANDOM', 'test', '');
INSERT INTO `core_lang_text` VALUES(2265, '_TEST_MM1_ANSWER_SEQUENCE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2266, '_TEST_MM1_GROUPING', 'test', '');
INSERT INTO `core_lang_text` VALUES(2267, '_TEST_MM1_ONEFORPAGE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2268, '_TEST_MM1_QUESTION_RANDOM_NUMBER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2269, '_TEST_MM1_RANDOM', 'test', '');
INSERT INTO `core_lang_text` VALUES(2270, '_TEST_MM1_SEQUENCE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2271, '_TEST_MM2_CANTRAVEL', 'test', '');
INSERT INTO `core_lang_text` VALUES(2272, '_TEST_MM2_HIDE_INFO', 'test', '');
INSERT INTO `core_lang_text` VALUES(2273, '_TEST_MM2_MODANSWER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2274, '_TEST_MM2_SAVEKEEP', 'test', '');
INSERT INTO `core_lang_text` VALUES(2275, '_TEST_MM4_SHOWCAT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2276, '_TEST_MM4_SHOWDOANSWER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2277, '_TEST_MM4_SHOWSOL', 'test', '');
INSERT INTO `core_lang_text` VALUES(2278, '_TEST_MM4_SHOWTOT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2279, '_TEST_MM_FOUR', 'test', '');
INSERT INTO `core_lang_text` VALUES(2280, '_TEST_MM_ONE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2281, '_TEST_MM_TWO', 'test', '');
INSERT INTO `core_lang_text` VALUES(2282, '_TEST_MODALITY', 'test', '');
INSERT INTO `core_lang_text` VALUES(2283, '_TEST_MOD_DOANSWER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2284, '_TEST_MOD_DOANSWER_NO', 'test', '');
INSERT INTO `core_lang_text` VALUES(2285, '_TEST_MOVEQUEST', 'test', '');
INSERT INTO `core_lang_text` VALUES(2286, '_TEST_NEXT_PAGE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2287, '_TEST_NOT_AS_THECORRECT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2288, '_TEST_NOT_HT_THECORRECT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2289, '_TEST_NOT_MC_THECORRECT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2290, '_TEST_NOT_THECORRECT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2291, '_TEST_PAGES', 'test', '');
INSERT INTO `core_lang_text` VALUES(2292, '_TEST_PM1_PERC', 'test', '');
INSERT INTO `core_lang_text` VALUES(2293, '_TEST_PM1_POINT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2294, '_TEST_PMM_REQUIREDSCORE_POINT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2295, '_TEST_PM_DIFFICULT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2296, '_TEST_PM_EQUALTOALL', 'test', '');
INSERT INTO `core_lang_text` VALUES(2297, '_TEST_PM_MANUAL', 'test', '');
INSERT INTO `core_lang_text` VALUES(2298, '_TEST_PM_ONE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2299, '_TEST_PM_SETPOINT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2300, '_TEST_PM_SUBD_BY', 'test', '');
INSERT INTO `core_lang_text` VALUES(2301, '_TEST_PM_TWO', 'test', '');
INSERT INTO `core_lang_text` VALUES(2302, '_TEST_POINT_ASSIGNEMENT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2303, '_TEST_POINT_MANAGEMENT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2304, '_TEST_PREV_PAGE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2305, '_TEST_QUESTION_NUMBER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2306, '_TEST_QUEST_CATEGORY', 'test', '');
INSERT INTO `core_lang_text` VALUES(2307, '_TEST_QUEST_ELEM', 'test', '');
INSERT INTO `core_lang_text` VALUES(2308, '_TEST_QUEST_ELEMENTS_A', 'test', '');
INSERT INTO `core_lang_text` VALUES(2309, '_TEST_QUEST_ELEMENTS_B', 'test', '');
INSERT INTO `core_lang_text` VALUES(2310, '_TEST_QUEST_ELEM_NUM', 'test', '');
INSERT INTO `core_lang_text` VALUES(2311, '_TEST_QUEST_MAXTESTSCORE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2312, '_TEST_QUEST_NEWMAXTESTSCORE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2313, '_TEST_QUEST_ORDER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2314, '_TEST_QUEST_SEL_ASSOCIATION', 'test', '');
INSERT INTO `core_lang_text` VALUES(2315, '_TEST_QUEST_TIMEASS', 'test', '');
INSERT INTO `core_lang_text` VALUES(2316, '_TEST_QUEST_TIME_ASSIGNED', 'test', '');
INSERT INTO `core_lang_text` VALUES(2317, '_TEST_REQUIREDSCORE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2318, '_TEST_REQUIREDSCORE_RESULT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2319, '_TEST_RESTART', 'test', '');
INSERT INTO `core_lang_text` VALUES(2320, '_TEST_REVIEW_ANSWER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2321, '_TEST_SAVED', 'test', '');
INSERT INTO `core_lang_text` VALUES(2322, '_TEST_SAVEKEEP', 'test', '');
INSERT INTO `core_lang_text` VALUES(2323, '_TEST_SAVEKEEP_BACK', 'test', '');
INSERT INTO `core_lang_text` VALUES(2324, '_TEST_SAVEKEEP_FAILURE_BACK', 'test', '');
INSERT INTO `core_lang_text` VALUES(2325, '_TEST_SAVEKEEP_NO', 'test', '');
INSERT INTO `core_lang_text` VALUES(2326, '_TEST_SAVE_KEEP', 'test', '');
INSERT INTO `core_lang_text` VALUES(2327, '_TEST_SCORES', 'test', '');
INSERT INTO `core_lang_text` VALUES(2328, '_TEST_SECTION', 'test', '');
INSERT INTO `core_lang_text` VALUES(2329, '_TEST_SEL_LIBRARIES', 'test', '');
INSERT INTO `core_lang_text` VALUES(2330, '_TEST_SHOW_REVIEW', 'test', '');
INSERT INTO `core_lang_text` VALUES(2331, '_TEST_SHOW_SCORE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2332, '_TEST_SHOW_SCORE_NO', 'test', '');
INSERT INTO `core_lang_text` VALUES(2333, '_TEST_SHOW_SOLUTION', 'test', '');
INSERT INTO `core_lang_text` VALUES(2334, '_TEST_SHOW_SOLUTION_NO', 'test', '');
INSERT INTO `core_lang_text` VALUES(2335, '_TEST_SUB_ONE_ANSWER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2336, '_TEST_SUMMARY', 'test', '');
INSERT INTO `core_lang_text` VALUES(2337, '_TEST_TEXT_ANSWER', 'test', '');
INSERT INTO `core_lang_text` VALUES(2338, '_TEST_TE_TITLE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2339, '_TEST_TIME_ASSIGNED', 'test', '');
INSERT INTO `core_lang_text` VALUES(2340, '_TEST_TIME_ASSIGNED_NO', 'test', '');
INSERT INTO `core_lang_text` VALUES(2341, '_TEST_TIME_ASSIGNED_QUEST', 'test', '');
INSERT INTO `core_lang_text` VALUES(2342, '_TEST_TIME_MANAGEMENT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2343, '_TEST_TIME_NO', 'test', '');
INSERT INTO `core_lang_text` VALUES(2344, '_TEST_TIME_YES', 'test', '');
INSERT INTO `core_lang_text` VALUES(2345, '_TEST_TIME_YES_QUEST', 'test', '');
INSERT INTO `core_lang_text` VALUES(2346, '_TEST_TM1_LIMIT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2347, '_TEST_TM2_CAPTIONSETTIME', 'test', '');
INSERT INTO `core_lang_text` VALUES(2348, '_TEST_TM2_EQUALTOALL', 'test', '');
INSERT INTO `core_lang_text` VALUES(2349, '_TEST_TM2_MANUAL', 'test', '');
INSERT INTO `core_lang_text` VALUES(2350, '_TEST_TM2_NEWTIME', 'test', '');
INSERT INTO `core_lang_text` VALUES(2351, '_TEST_TM2_NEWTIMETOTAL', 'test', '');
INSERT INTO `core_lang_text` VALUES(2352, '_TEST_TM2_PENALITY_QUEST', 'test', '');
INSERT INTO `core_lang_text` VALUES(2353, '_TEST_TM2_PENALITY_TEST', 'test', '');
INSERT INTO `core_lang_text` VALUES(2354, '_TEST_TM2_SETSCORE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2355, '_TEST_TM2_SETTIME', 'test', '');
INSERT INTO `core_lang_text` VALUES(2356, '_TEST_TM2_SUBD_BY', 'test', '');
INSERT INTO `core_lang_text` VALUES(2357, '_TEST_TM_FOUR', 'test', '');
INSERT INTO `core_lang_text` VALUES(2358, '_TEST_TM_ONE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2359, '_TEST_TM_THREE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2360, '_TEST_TM_TWO', 'test', '');
INSERT INTO `core_lang_text` VALUES(2361, '_TEST_TOTAL_SCORE', 'test', '');
INSERT INTO `core_lang_text` VALUES(2362, '_TEST_YOUCANNOT_SAVEKEEP', 'test', '');
INSERT INTO `core_lang_text` VALUES(2363, '_TIME_ELAPSED', 'test', '');
INSERT INTO `core_lang_text` VALUES(2364, '_TIME_LEFT', 'test', '');
INSERT INTO `core_lang_text` VALUES(2365, '_USE_SUSPENSION', 'test', '');
INSERT INTO `core_lang_text` VALUES(2366, '_VERY_HARD', 'test', '');
INSERT INTO `core_lang_text` VALUES(2367, '_YES_IF_PASSED', 'test', '');
INSERT INTO `core_lang_text` VALUES(2368, '_MARK_AS_PAID', 'transaction', '');
INSERT INTO `core_lang_text` VALUES(2369, '_PRICE', 'transaction', '');
INSERT INTO `core_lang_text` VALUES(2370, '_SET_NOT_PAID', 'transaction', '');
INSERT INTO `core_lang_text` VALUES(2371, '_ALT_EMPTY', 'treeview', '');
INSERT INTO `core_lang_text` VALUES(2372, '_DONT_USE_TREE_REGISTRATION', 'user_managment', '');
INSERT INTO `core_lang_text` VALUES(2373, '_LOG_OPTION', 'user_managment', '');
INSERT INTO `core_lang_text` VALUES(2374, '_NO_VALUE', 'user_managment', '');
INSERT INTO `core_lang_text` VALUES(2375, '_REACH_NUMBERS_OF_ATTEMPT', 'user_managment', '');
INSERT INTO `core_lang_text` VALUES(2376, '_REGISTER_TYPE_ADMIN', 'user_managment', '');
INSERT INTO `core_lang_text` VALUES(2377, '_REGISTER_TYPE_MODERATE', 'user_managment', '');
INSERT INTO `core_lang_text` VALUES(2378, '_REGISTER_TYPE_SELF', 'user_managment', '');
INSERT INTO `core_lang_text` VALUES(2379, '_USE_WITH_MANUALEINSERT', 'user_managment', '');
INSERT INTO `core_lang_text` VALUES(2380, '_USE_WITH_SELECTION', 'user_managment', '');
INSERT INTO `core_lang_text` VALUES(2381, '_ADD_WIKI', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2382, '_ALT_GOTO_PAGE', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2383, '_ALT_VIEW_REVISION', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2384, '_COMPARE_SEL_VER', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2385, '_EXPORT_WIKI', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2386, '_GUIDE', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2387, '_HOME', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2388, '_LEVEL_UP', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2389, '_MAP', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2390, '_OTHER_LANGUAGE', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2391, '_PAGE', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2392, '_PROVIDE_SEARCH_QUERY', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2393, '_REVISIONS', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2394, '_SELECT_WIKI', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2395, '_TABLE_SELECT_WIKI_CAP', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2396, '_WIKI', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2397, '_WIKI_HOME', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2398, '_WIKI_INSTRUCTION', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2399, '_WIKI_LANGUAGE', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2400, '_WIKI_LEVEL_UP', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2401, '_WIKI_OTHER_LANGUAGES', 'wiki', '');
INSERT INTO `core_lang_text` VALUES(2402, '_WIKI_PREV', 'wiki', '');

-- --------------------------------------------------------

--
-- Table structure for table `core_lang_translation`
--

CREATE TABLE `core_lang_translation` (
  `id_text` int(11) NOT NULL DEFAULT '0',
  `lang_code` varchar(50) NOT NULL DEFAULT '',
  `translation_text` text,
  `save_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_text`,`lang_code`),
  KEY `lang_code` (`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_lang_translation`
--

INSERT INTO `core_lang_translation` VALUES(1, 'english', 'Select folders for administrator user visibility', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2, 'english', 'Administrators manager', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(3, 'english', 'Administrator user', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(4, 'english', 'List of all platform administrators', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(5, 'english', 'Menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(6, 'english', 'Special settings', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(7, 'english', 'Admin Profile', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(8, 'english', 'Special settings for:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(9, 'english', 'Activate directly the enrollments made by this admin', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(10, 'english', 'Activate directly the users created by this admin', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(11, 'english', 'Languages settings', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(12, 'english', 'Limit the maximum number of enrollments this admin can make', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(13, 'english', 'Limit the maximum number of users this admin can create', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(14, 'english', 'Manage subscriptions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(15, 'english', 'The maximum number of enrollments this admin can make', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(16, 'english', 'Max number of users this admin can create', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(17, 'english', 'Select the languages to assign', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(18, 'english', 'Special settings', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(19, 'english', 'Paper test', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(20, 'english', 'Web test', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(21, 'english', 'Accept', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(22, 'english', 'User accepted', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(23, 'english', 'Additional fields assigned', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(24, 'english', 'Declined', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(25, 'english', 'Self registration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(26, 'english', 'Administrator', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(27, 'english', 'Super admin', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(28, 'english', 'Public administrator', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(29, 'english', 'User', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(30, 'english', 'Assign field', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(31, 'english', 'Email', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(32, 'english', 'Firstname', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(33, 'english', 'Show also children node content', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(34, 'english', 'Language', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(35, 'english', 'Last Name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(36, 'english', 'Password', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(37, 'english', 'Registration date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(38, 'english', 'Template Name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(39, 'english', 'Username', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(40, 'english', 'Full name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(41, 'english', 'id', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(42, 'english', 'Group type', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(43, 'english', 'Open group', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(44, 'english', 'Invisible group', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(45, 'english', 'Invisible', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(46, 'english', 'Moderated group', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(47, 'english', 'Moderated', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(48, 'english', 'Private group', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(49, 'english', 'Admin', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(50, 'english', 'Users waiting for subscription confirmation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(51, 'english', 'User field', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(52, 'english', 'Member id', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(53, 'english', 'Member type', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(54, 'english', 'Node', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(55, 'english', 'User member', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(56, 'english', 'Organization chart', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(57, 'english', 'Require a change of password in the next sign in', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(58, 'english', 'Yes', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(59, 'english', 'File charset', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(60, 'english', 'CSV file', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(61, 'english', 'Consider first row as header', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(62, 'english', 'Fields separator', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(63, 'english', 'Last Name First Name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(64, 'english', 'User has not been approved', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(65, 'english', 'Refuse', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(66, 'english', 'Refuse user registration request', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(67, 'english', 'Search in field userID, First Name or Last Name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(68, 'english', 'Users list with confirmed registration request and waiting for approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(69, 'english', 'Language code not specified', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(70, 'english', 'Clean languages', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(71, 'english', 'Clean', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(72, 'english', 'From left to right (ltr)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(73, 'english', 'From right to left (rtl)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(74, 'english', 'Do not add missing labels', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(75, 'english', 'Export this language', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(76, 'english', 'Export only words not been traslated yet (these keys will be shown in english)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(77, 'english', 'Accessibility', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(78, 'english', 'Add key', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(79, 'english', 'All languages', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(80, 'english', 'All modules', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(81, 'english', 'Attributes', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(82, 'english', 'Web Browser language code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(83, 'english', 'Charset', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(84, 'english', 'Language code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(85, 'english', 'Comparison', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(86, 'english', 'Language direction', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(87, 'english', 'Key', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(88, 'english', 'Module', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(89, 'english', 'New module', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(90, 'english', 'Translation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(91, 'english', 'Comparison', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(92, 'english', 'Updated modules', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(93, 'english', 'No, don''t import', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(94, 'english', 'Phrases', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(95, 'english', 'Only untranslated phrases', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(96, 'english', 'Reading orientation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(97, 'english', 'Overwrite existing words', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(98, 'english', 'Translate %', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(99, 'english', 'Language definition updated', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(100, 'english', 'Translation table for %module%', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(101, 'english', 'Translate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(102, 'english', 'Translate language', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(103, 'english', 'Translation contains', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(104, 'english', 'Yes, import', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(105, 'english', 'Choose users who can see the news.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(106, 'english', 'Extended description', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(107, 'english', 'Number of news items displayed on home page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(108, 'english', 'List of all the news that you can find in the main page of the LMS', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(109, 'english', 'This news is marked as important', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(110, 'english', 'every language', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(111, 'english', 'Newsletter will reach [tot] users.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(112, 'english', 'Pause for 20 seconds', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(113, 'english', 'SMS', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(114, 'english', 'New web page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(115, 'english', 'Home', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(116, 'english', 'This is the default page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(117, 'english', 'Web pages', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(118, 'english', 'List of web pages', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(119, 'english', 'Add announcement', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(120, 'english', 'Announcements', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(121, 'english', 'Move to archive', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(122, 'english', 'Move into read announcements', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(123, 'english', 'Choose who can read this announcement', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(124, 'english', 'Select users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(125, 'english', 'Only me', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(126, 'english', 'Apr', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(127, 'english', 'April', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(128, 'english', 'Aug', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(129, 'english', 'August', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(130, 'english', 'Event calendar', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(131, 'english', 'Show before %s', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(132, 'english', 'Dec', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(133, 'english', 'December', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(134, 'english', '%d-%m-%Y', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(135, 'english', 'Feb', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(136, 'english', 'February', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(137, 'english', 'Fri', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(138, 'english', 'Friday', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(139, 'english', 'Generic', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(140, 'english', 'Today', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(141, 'english', 'Jan', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(142, 'english', 'January', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(143, 'english', 'Jul', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(144, 'english', 'July', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(145, 'english', 'Jun', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(146, 'english', 'June', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(147, 'english', 'Mar', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(148, 'english', 'March', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(149, 'english', 'May', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(150, 'english', 'Meeting', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(151, 'english', 'Mon', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(152, 'english', 'Monday', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(153, 'english', 'Next Month', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(154, 'english', 'Next Year', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(155, 'english', 'Nov', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(156, 'english', 'November', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(157, 'english', 'Oct', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(158, 'english', 'October', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(159, 'english', '(today)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(160, 'english', 'please wait...', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(161, 'english', 'Previous month', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(162, 'english', 'Previous year', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(163, 'english', 'Private', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(164, 'english', 'Public', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(165, 'english', 'Publishing', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(166, 'english', 'Sat', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(167, 'english', 'Saturday', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(168, 'english', 'Sep', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(169, 'english', 'September', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(170, 'english', 'Sun', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(171, 'english', 'Sunday', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(172, 'english', 'Thu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(173, 'english', 'Thursday', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(174, 'english', 'Hour:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(175, 'english', 'Today', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(176, 'english', '%a:%b:%e', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(177, 'english', 'Tue', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(178, 'english', 'Tuesday', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(179, 'english', 'Wed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(180, 'english', 'Wednesday', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(181, 'english', '0,6', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(182, 'english', 'week', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(183, 'english', 'Add to cart', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(184, 'english', 'Career', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(185, 'english', 'Select catalogs', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(186, 'english', 'List all the available catalogs', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(187, 'english', 'Certificates available for the download', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(188, 'english', 'Building', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(189, 'english', 'This curriculum has <b>[enrolled]</b> subscribed users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(190, 'english', 'Your curriculum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(191, 'english', 'Courses where you are [level]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(192, 'english', 'Courses you are subscribed to', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(193, 'english', 'Courses you have completed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(194, 'english', 'Courses expiring in one week', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(195, 'english', 'List of available courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(196, 'english', 'Course subscription', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(197, 'english', 'Only admin can subscribe', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(198, 'english', 'Course type', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(199, 'english', 'Enabled courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(200, 'english', 'Courses and curricula', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(201, 'english', 'Courses and curricula assigned to this catalog', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(202, 'english', 'Courses which start from', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(203, 'english', 'Show only courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(204, 'english', 'selling', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(205, 'english', 'Import new', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(206, 'english', 'Manual subscription', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(207, 'english', 'Show elements of the catalog', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(208, 'english', 'New catalog', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(209, 'english', 'No courses available', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(210, 'english', 'Course not found', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(211, 'english', 'There are no editions in this course.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(212, 'english', 'Suggested curriculum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(213, 'english', 'Remove from the catalog', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(214, 'english', 'Reserve', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(215, 'english', 'Shopping cart', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(216, 'english', 'Subscribe to this course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(217, 'english', 'By category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(218, 'english', 'Most popular', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(219, 'english', 'Most recent', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(220, 'english', 'Total number of courses you are subscribed to', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(221, 'english', 'Waiting for approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(222, 'english', 'Search by word', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(223, 'english', 'Erase meta-certificate already published', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(224, 'english', 'Publish a meta-certificate copy', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(225, 'english', 'Background image', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(226, 'english', 'Certificate language', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(227, 'english', 'Certificate template list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(228, 'english', 'Certificates list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(229, 'english', 'Released certificate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(230, 'english', 'Certificate template list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(231, 'english', 'Released certificates', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(232, 'english', 'IMPORTANT: Due to a limitation of the PDF class which will be fixed in a future version, we suggest using ONLY background images and not embedded images in HTML code inside tags like < p >, < div >, < center > etc., as this can cause errors.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(233, 'english', 'Choose the certificate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(234, 'english', 'Choose the course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(235, 'english', 'Course starting date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(236, 'english', 'Course description', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(237, 'english', 'Course end date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(238, 'english', 'Max final score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(239, 'english', 'Certificate date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(240, 'english', 'Certificate year', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(241, 'english', 'Date of the course completion', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(242, 'english', 'Course subscription date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(243, 'english', 'if not available, user name, write name and last name, username will be shown', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(244, 'english', 'Score required for the Excellence certificate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(245, 'english', 'Generate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(246, 'english', 'Generate all the selected certificates', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(247, 'english', 'Landscape', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(248, 'english', 'Association list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(249, 'english', 'Meta-certificate list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(250, 'english', 'Meta-certificates ready to be created', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(251, 'english', 'Status of meta-certificates linked to users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(252, 'english', 'Association table', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(253, 'english', 'Table to link users and courses to the meta-certificate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(254, 'english', 'Completed / Total', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(255, 'english', 'Meta-certificate list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(256, 'english', 'My certificates', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(257, 'english', 'New association', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(258, 'english', 'New certificate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(259, 'english', 'Not ended', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(260, 'english', 'No availables certificates', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(261, 'english', 'No one has accessed this certificate yet', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(262, 'english', 'No meta-certificates ready to be published', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(263, 'english', 'Certificates:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(264, 'english', 'Orientation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(265, 'english', 'Portrait', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(266, 'english', 'Released on', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(267, 'english', 'Released', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(268, 'english', 'Stop', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(269, 'english', 'Certificate template', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(270, 'english', 'Structure of meta-certificate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(271, 'english', 'Table of courses completed toward the meta-certificate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(272, 'english', 'Tag codes', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(273, 'english', 'Description tag', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(274, 'english', 'Tags available for certificate template building', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(275, 'english', 'Tags available for certificate template building', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(276, 'english', 'Download copy of certificate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(277, 'english', 'Template', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(278, 'english', 'Final Learning Object score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(279, 'english', 'Maximum final Learning Object score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(280, 'english', 'Initial Learning Object score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(281, 'english', 'Maximum initial Learning Object score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(282, 'english', 'Assign meta-certificate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(283, 'english', 'Certificate management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(284, 'english', 'Meta-certificates available to be pulbished', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(285, 'english', 'Meta-certificate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(286, 'english', 'Meta-certificate assignment', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(287, 'english', 'Meta-certificates emission', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(288, 'english', 'Deleting association', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(289, 'english', 'View copy', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(290, 'english', 'Total time spent in the course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(291, 'english', 'Total time spent in the course (just hours)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(292, 'english', 'Total time spent in the course (just minutes)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(293, 'english', 'Total time spent in the course (just seconds)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(294, 'english', 'To be released', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(295, 'english', 'Select users to be linked to the meta-certificate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(296, 'english', 'Chat with other users in this course, click on the link below to open the chatroom in a pop-up window', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(297, 'english', 'Open chatroom (new window)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(298, 'english', 'Open chatroom (accessibility version)(pop-up)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(299, 'english', 'Available Hardware', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(300, 'english', 'Room', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(301, 'english', 'Capacity', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(302, 'english', 'City', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(303, 'english', 'Layout', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(304, 'english', 'Fax', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(305, 'english', 'Classroom hardware', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(306, 'english', 'Phone number', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(307, 'english', 'Photo', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(308, 'english', 'Refer(s) to', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(309, 'english', 'State', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(310, 'english', 'Street', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(311, 'english', 'Zipcode', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(312, 'english', 'Code list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(313, 'english', 'Number of uses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(314, 'english', 'Unlimited use', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(315, 'english', 'Used', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(316, 'english', 'Add new competence', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(317, 'english', 'Assign competence requirements to users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(318, 'english', 'Required', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(319, 'english', 'Attitude', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(320, 'english', 'Knowledge', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(321, 'english', 'Skill', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(322, 'english', 'Competence''s related users list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(323, 'english', 'Obtained', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(324, 'english', 'Obtained on', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(325, 'english', 'Expire after (days)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(326, 'english', 'Flag', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(327, 'english', 'Hour:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(328, 'english', 'Room name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(329, 'english', 'System', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(330, 'english', 'Max users allowed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(331, 'english', 'Meeting duration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(332, 'english', 'You can''t create any more rooms', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(333, 'english', 'No available rooms', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(334, 'english', 'Videoconference available rooms', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(335, 'english', 'Available rooms list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(336, 'english', 'Activate accessibility features', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(337, 'english', 'Configuration of "allow_url_include"', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(338, 'english', 'Docebo <abbr title="Application Programming Interface">API</abbr>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(339, 'english', 'Docebo <abbr title="Application Programming Interface">API</abbr> and <abbr title="Single Sign On">SSO</abbr>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(340, 'english', 'Ask for a code created through the code module', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(341, 'english', 'Ask for a tree code chosen by the user from a list in a dropdown menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(342, 'english', 'Ask for a tree code that must be entered manually by the user', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(343, 'english', 'Ask for a combination of tree code and course code that must be entered manually by the user. Tree and course code must be composed of 10 characters each, in order to obtain a 20 characters code.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(344, 'english', 'Customer code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(345, 'english', 'Unify admin and public sessions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(346, 'english', 'Limit for the number of conferences that can be planned by a single user', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(347, 'english', 'Configurations', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(348, 'english', 'Common', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(349, 'english', 'E-Learning', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(350, 'english', 'Limit for the maximum total size of contents uploaded into the course (MB)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(351, 'english', 'Currency symbol (will be displayed at user side)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(352, 'english', 'Debug options', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(353, 'english', 'Default template', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(354, 'english', 'Max Audio users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(355, 'english', 'Max users per room', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(356, 'english', 'Max rooms', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(357, 'english', 'Password', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(358, 'english', 'DimDim Port', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(359, 'english', 'DimDim server address', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(360, 'english', 'DimDim username', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(361, 'english', 'DOM XML status', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(362, 'english', 'Don''t show', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(363, 'english', 'Enable debug information', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(364, 'english', 'E-Commerce', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(365, 'english', 'Show "course catalog" as user main page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(366, 'english', 'Show forum list in a table', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(367, 'english', 'Error in FTP', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(368, 'english', 'FTP OK', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(369, 'english', 'Code provided by Google', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(370, 'english', 'Enable Google Analytics', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(371, 'english', 'Limit, in hours, for the expiration of the subscription request', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(372, 'english', 'Visual HTML text editor', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(373, 'english', 'Allow administrator media management in the editor', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(374, 'english', 'Allow super-administrator media management in the editor', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(375, 'english', 'Allow user media management in the editor', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(376, 'english', 'Shows, in the results area of the content library searches, also objects not directly available to the user.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(377, 'english', 'Show, in the results of the content library searches, also objects that aren''t fully categorized.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(378, 'english', 'Activate language editing (used for debugging)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(379, 'english', 'First Name and Last Name are required in order to register', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(380, 'english', 'LDAP', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(381, 'english', 'LDAP port (usually 389)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(382, 'english', 'LDAP server', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(383, 'english', 'Activate LDAP authentication', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(384, 'english', 'Username for LDAP users, use $user for the username.<br />Ex. $user@domain2.domain1 (for: W2k3)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(385, 'english', 'Configuration of "magic_quotes_gpc"', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(386, 'english', 'Registrations and Lost passwords email sender', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(387, 'english', 'Main options', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(388, 'english', 'If one of the registration code options above are enabled, users are forced to enter the registration code (the code field must be filled in)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(389, 'english', 'Configuration of "max_execution_time"', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(390, 'english', 'Maximum number of consecutively failed login attempts (0 = no limit)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(391, 'english', 'Mysql Collation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(392, 'english', 'Mysql Encoding', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(393, 'english', 'Sql mode', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(394, 'english', 'MySQL version', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(395, 'english', 'Pause between blocks (seconds)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(396, 'english', 'Send newsletter messages in blocks of', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(397, 'english', 'With domxml OFF, the scorm module, language management and videconferencing will not work', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(398, 'english', 'Use "no answer" option in poll questions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(399, 'english', 'Use "no answer" option in test questions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(400, 'english', 'If not a single course catalog is assigned to a user, show all the courses and curricula', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(401, 'english', 'Organization name for the conference', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(402, 'english', 'Page title (will appear in the user''s browser)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(403, 'english', 'Password must be composed of letters and numbers', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(404, 'english', 'Force users to change their password at the first login', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(405, 'english', 'Password validity, max number of days the password will be valid (0 for unlimited)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(406, 'english', 'Password length, minimum number of characters', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(407, 'english', 'File uploads path', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(408, 'english', 'Save Path for the files uploaded in the chat shared files', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(409, 'english', 'Save Path for the files uploaded in the course info', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(410, 'english', 'Save path for additional fields', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(411, 'english', 'Save Path for the files uploaded as forum attachment', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(412, 'english', 'Save Path for the files uploaded in the upload files', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(413, 'english', 'Save Path for files uploaded as message attachments', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(414, 'english', 'Users photos and avatars', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(415, 'english', 'Save Path for files uploaded in project manager', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(416, 'english', 'Save Path for files uploaded as SCORM Learning Object', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(417, 'english', 'Sponsor banners', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(418, 'english', 'Question "file upload"', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(419, 'english', 'Paypal currency code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(420, 'english', 'Paypal Account', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(421, 'english', 'Use paypal sandbox instead of the real environment (this is a debug and testing option)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(422, 'english', 'Info about PHP', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(423, 'english', 'PHP version', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(424, 'english', 'Configuration of "post_max_size"', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(425, 'english', 'Privacy policy MUST be accepted', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(426, 'english', 'Limit user to change just his password (deactivate extended profile)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(427, 'english', 'Keep a record of all the deleted users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(428, 'english', 'Configuration of "register_global"', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(429, 'english', 'Registration type', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(430, 'english', 'Only by administrator', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(431, 'english', 'Moderated self registration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(432, 'english', 'Free self registration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(433, 'english', 'Registration code usage', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(434, 'english', 'At the login the user is prompted to fill in the mandatory fields related to his profile.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(435, 'english', 'Single code for platform', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(436, 'english', 'Generated token will expire after (minutes)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(437, 'english', 'Authentication method:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(438, 'english', 'Token generation at every connection', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(439, 'english', 'Refresh token lifetime at every API call', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(440, 'english', '"safe_mode" configuration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(441, 'english', 'Yes, only if the max number is reached', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(442, 'english', 'Yes, for all', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(443, 'english', 'Save info about failed login attempts', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(444, 'english', 'Allow the usage of direct link from external sources to scorm chaperts (sco and asset)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(445, 'english', 'Security related', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(446, 'english', 'Sender email address for alert messages', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(447, 'english', 'Add the following address as Cc for all the email sent by the platform', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(448, 'english', 'Server configuration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(449, 'english', 'Server address', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(450, 'english', 'Server admin mail', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(451, 'english', 'MySQL information', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(452, 'english', 'Server name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(453, 'english', 'Server port', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(454, 'english', 'Server software', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(455, 'english', 'Enable IP control within sessions (user can''t change IP after login)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(456, 'english', 'Show in block', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(457, 'english', 'Show as link list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(458, 'english', 'Sms', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(459, 'english', 'In association with smsmarket.it', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(460, 'english', 'Buy more SMSes', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(461, 'english', 'Cell phone number field', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(462, 'english', 'Credit left', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(463, 'english', 'Credit will be updated when you will send a further SMS.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(464, 'english', 'Gateway 1', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(465, 'english', 'Gateway 2', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(466, 'english', 'Gateway 3', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(467, 'english', 'Gateway 4', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(468, 'english', 'Automatic', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(469, 'english', 'Gateway host address', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(470, 'english', 'Select gateway', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(471, 'english', 'Gateway password', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(472, 'english', 'Port number', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(473, 'english', 'Gateway username', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(474, 'english', 'Default international prefix', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(475, 'english', 'SMS sender', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(476, 'english', 'Social Functions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(477, 'english', 'Use Facebook interfacing and Single Sign On', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(478, 'english', 'Facebook API code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(479, 'english', 'Facebook secret code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(480, 'english', 'Use Google interfacing and Single Sign On', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(481, 'english', 'Linkedin API access code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(482, 'english', 'Use Linkedin interfacing and Single Sign On', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(483, 'english', 'Linkedin secret code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(484, 'english', 'Use Twitter interfacing and Single Sign On', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(485, 'english', 'Twitter consumer code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(486, 'english', 'Twitter secret code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(487, 'english', '<abbr title="Single Sign On">SSO</abbr> secret for the token hash', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(488, 'english', 'Enable <abbr title="Single Sign On">SSO</abbr> with a third party software through a token', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(489, 'english', 'Disable simultaneous access with the same username', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(490, 'english', 'Courses sorting order in "My courses"', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(491, 'english', 'Max users per room', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(492, 'english', 'Max rooms', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(493, 'english', 'Allow user tracking (Recommended: yes)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(494, 'english', 'Session lifetime', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(495, 'english', 'FTP connection', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(496, 'english', 'Configuration of "upload_max_filesize"', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(497, 'english', 'Website URL with final /', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(498, 'english', 'URL for check-in', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(499, 'english', 'URL for videoconference', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(500, 'english', 'Consider this parameter only if you need to authenticate through LDAP', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(501, 'english', 'Ask the user to choose a password different from the last X used passwords', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(502, 'english', 'Disk quota (in MB) for each user''s My Files area', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(503, 'english', 'Use advanced registration form', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(504, 'english', 'Use DimDim Api instead of url interfacing', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(505, 'english', 'Enable the API functionality', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(506, 'english', 'Enable tags feature inside the forums.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(507, 'english', 'Add file', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(508, 'english', 'Add new file', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(509, 'english', 'Enroll users in this course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(510, 'english', 'There is [advice] new advice', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(511, 'english', 'There are [forum] new messages in the forum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(512, 'english', 'There are [lobj] new learning objects', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(513, 'english', 'Allow overbooking', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(514, 'english', 'All open', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(515, 'english', 'Assign for any user''s status', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(516, 'english', 'Assign for users that have  completed the course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(517, 'english', 'Assign for users that are attending the course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(518, 'english', 'Assign a new menu to the course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(519, 'english', 'Registration code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(520, 'english', 'Back to the admin area', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(521, 'english', 'Allowed to buy this course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(522, 'english', 'Subscribe', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(523, 'english', 'Copy changes also to editions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(524, 'english', 'You are in', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(525, 'english', 'Selected category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(526, 'english', 'Certificate assignment', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(527, 'english', 'Certificate assignment for Excellence', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(528, 'english', 'Certificate language', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(529, 'english', 'Number of released certificates', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(530, 'english', 'Classroom -> Course association', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(531, 'english', 'Classrooms/Editions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(532, 'english', 'Warning: some classrooms are already occupied by other courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(533, 'english', 'Class occupied', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(534, 'english', 'Your data will be saved.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(535, 'english', 'Advance payment %', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(536, 'english', 'Code for the automatic subscription to a course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(537, 'english', 'Available courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(538, 'english', 'Course duration: from <b>[date_begin]</b> to <b>[date_end]</b>.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(539, 'english', 'Demo material', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(540, 'english', 'Display mode options', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(541, 'english', 'Does the course contain editions?', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(542, 'english', 'Automatic after completing the end course LO', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(543, 'english', 'Manual teacher action', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(544, 'english', 'Completion mode', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(545, 'english', 'Course is: <b>[course_type]</b> with: <b>[enrolled]</b> users subscribed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(546, 'english', 'Course is: <b>[course_type]</b> with: <b>[enrolled]</b> out of a maximum of: <b>[max_subscribe]</b> subscribed users. Course is: <b>[course_status]</b>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(547, 'english', 'Course language', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(548, 'english', 'This is a list with all the courses to which the user subscribed and other relevant information', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(549, 'english', 'Course logo', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(550, 'english', 'Assign the menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(551, 'english', 'Price', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(552, 'english', 'Assign disk space limit to this course (MB)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(553, 'english', 'Select course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(554, 'english', 'Sell course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(555, 'english', 'Special options', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(556, 'english', 'Deny access to this course if the user status is', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(557, 'english', 'Course subscription', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(558, 'english', 'Enrollment policy', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(559, 'english', 'Only admin', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(560, 'english', 'On approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(561, 'english', 'Subscription through secret code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(562, 'english', 'Course instructors', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(563, 'english', 'Time options', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(564, 'english', 'Course type', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(565, 'english', 'Blended', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(566, 'english', 'E-Learning with editions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(567, 'english', 'E-Learning', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(568, 'english', 'Subscribed users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(569, 'english', 'Active since', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(570, 'english', 'Available', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(571, 'english', 'Cancelled', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(572, 'english', 'Concluded', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(573, 'english', 'Confirmed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(574, 'english', 'Under construction', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(575, 'english', 'Days of validity', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(576, 'english', 'Show demo', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(577, 'english', 'Directly play the first learning object in the player', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(578, 'english', 'Documents upload', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(579, 'english', 'Don''t show', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(580, 'english', 'Show material', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(581, 'english', 'start on <b>[date_begin]</b> and end on <b>[date_end]</b>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(582, 'english', 'Object marked as final', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(583, 'english', 'This course will expire in <b>[expiring_in]</b> days', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(584, 'english', 'No files have been specified', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(585, 'english', 'Flat view', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(586, 'english', 'Choose a course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(587, 'english', 'Generate new codes', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(588, 'english', 'Subscription OK', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(589, 'english', 'Starting hour', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(590, 'english', 'Ending hour', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(591, 'english', 'If you specify a new file, the previous one will be overwritten', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(592, 'english', 'Import subscriptions from a course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(593, 'english', 'Subscribe users imported from file', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(594, 'english', 'Course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(595, 'english', 'Inherit disk quota from standard settings', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(596, 'english', 'You are in', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(597, 'english', 'in classroom <b>[classrooms_name]</b> in building <b>[classrooms_location]</b>.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(598, 'english', 'Hide info', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(599, 'english', 'Main category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(600, 'english', 'Selected by instructor', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(601, 'english', 'Course material', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(602, 'english', 'Course file', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(603, 'english', 'Max number of subscriptions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(604, 'english', 'Max budget for SMS', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(605, 'english', 'Average', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(606, 'english', 'Average completion time', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(607, 'english', 'Average time for course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(608, 'english', 'Minimum number of subscription (0 = unlimited)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(609, 'english', 'Please enter a valid min score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(610, 'english', 'Minimum number of subscribed students allowed is <b>[min_subscribe]</b>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(611, 'english', 'Multiple subscriptions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(612, 'english', 'My certificates', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(613, 'english', 'User is waiting at [url]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(614, 'english', 'Waiting for activation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(615, 'english', 'Access denied', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(616, 'english', 'No course found', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(617, 'english', 'Other options', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(618, 'english', 'Material for other roles', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(619, 'english', 'Session time', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(620, 'english', 'Pause start', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(621, 'english', 'Pause end', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(622, 'english', 'Complete course method', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(623, 'english', 'Objects', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(624, 'english', 'Failed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(625, 'english', 'Objects: [total], passed: [complete], failed: [failed]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(626, 'english', 'You can''t upload any further files because the disk space for this course is full', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(627, 'english', 'Generate random code for self-registration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(628, 'english', 'Reserve course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(629, 'english', 'Everyone, and show on home page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(630, 'english', 'Only users subscribed to the course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(631, 'english', 'Only for logged in users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(632, 'english', 'Unsubscribe from the course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(633, 'english', 'Advanced course info', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(634, 'english', 'Show only number of connected users, but don''t use Instant Messenger', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(635, 'english', 'Demo', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(636, 'english', 'Show Instant Messenger', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(637, 'english', 'Show progress', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(638, 'english', 'Show time', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(639, 'english', 'Select levels of users shown on information course page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(640, 'english', 'Users online in this course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(641, 'english', 'Sponsored by', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(642, 'english', 'Link to the sponsor', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(643, 'english', 'Logo', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(644, 'english', 'Status not allowed to enter the course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(645, 'english', 'Already subscribed to the course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(646, 'english', 'Subscribe method', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(647, 'english', 'Subscription', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(648, 'english', 'Subscriptions are closed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(649, 'english', 'From', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(650, 'english', 'To', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(651, 'english', 'Subscription is available during the following period', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(652, 'english', 'Subscriptions are open', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(653, 'english', 'You have asked to buy the course: <b>[name]</b><br />\nIn order to proceed, you must log in to the platform if you are already registered.<br />\nOtherwise, you must register in our system, following this link: <br />\n<br />\n<a href="[link_register]">Register me</a>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(654, 'english', 'Teachers:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(655, 'english', 'Go to the content of', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(656, 'english', 'Association of certificates to course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(657, 'english', 'You are attending this course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(658, 'english', 'Confirmed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(659, 'english', 'You have completed this course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(660, 'english', 'Reserved', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(661, 'english', 'You didn''t start to attend this course yet', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(662, 'english', 'No disk space limit', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(663, 'english', 'Unsubscribe requests', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(664, 'english', 'Unsubscribe request waiting for approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(665, 'english', 'Disk space used for this couse', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(666, 'english', 'User waiting for approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(667, 'english', 'Can the user subscribe?', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(668, 'english', 'Auto - unsubscribe', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(669, 'english', 'There are now <b>[user_count]</b> users subscribed and <b>[waiting_count]</b> waiting.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(670, 'english', ', your level is <b>[level]</b>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(671, 'english', 'Material for users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(672, 'english', 'Select', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(673, 'english', 'Show course logo in course list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(674, 'english', 'Bad', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(675, 'english', 'Give to this course a negative evaluation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(676, 'english', 'Good', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(677, 'english', 'Give to this course a positive evaluation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(678, 'english', 'In progress', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(679, 'english', 'Welcome', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(680, 'english', 'Show on course interface', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(681, 'english', 'Show course to:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(682, 'english', 'Online users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(683, 'english', 'Del. subscr.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(684, 'english', 'Do you really want to remove the course from this curriculum?', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(685, 'english', 'Available curricula', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(686, 'english', 'Courses included in this curricula', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(687, 'english', 'Subscription method', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(688, 'english', 'Only admin', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(689, 'english', 'Moderate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(690, 'english', 'Current Activity', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(691, 'english', 'Import courses in curricula', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(692, 'english', 'User currently subscribed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(693, 'english', 'Information about the selected activities', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(694, 'english', 'New activity', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(695, 'english', 'Add new activity', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(696, 'english', 'Add Scorm Results', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(697, 'english', 'Right answer', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(698, 'english', 'Test for this course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(699, 'english', 'This is the list of all the tests for this course and the results for the students', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(700, 'english', 'Save stats', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(701, 'english', 'Left', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(702, 'english', 'Move left', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(703, 'english', 'Move right', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(704, 'english', 'Not checked', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(705, 'english', 'Not passed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(706, 'english', 'of the user', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(707, 'english', 'Passed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(708, 'english', 'Percentage of correct answers', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(709, 'english', 'Answered questions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(710, 'english', 'Re-calculate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(711, 'english', 'Re-calculate score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(712, 'english', 'The required score must be smaller than the max score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(713, 'english', 'Delete test track', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(714, 'english', 'Right', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(715, 'english', 'Round final score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(716, 'english', 'Round', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(717, 'english', 'Round', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(718, 'english', 'Show answer', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(719, 'english', 'Show to user', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(720, 'english', 'Standard deviation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(721, 'english', 'Students', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(722, 'english', 'Student''s scores', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(723, 'english', 'Evaluation summary', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(724, 'english', 'Stats for question "[title]"', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(725, 'english', 'Percentage of correct answers for link "[title]"', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(726, 'english', 'Percentage of correct answers after inserting text in phrase "[title]"', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(727, 'english', 'Insert list for question "[title]"', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(728, 'english', 'Information about the test', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(729, 'english', 'Activity title', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(730, 'english', 'Total questions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(731, 'english', 'Stats for test "[test]"', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(732, 'english', 'Use for final score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(733, 'english', 'Weight', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(734, 'english', 'Add new course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(735, 'english', '&gt;&gt; Back to "My course area"', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(736, 'english', 'You have already used this code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(737, 'english', 'Code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(738, 'english', 'This chart allows you to check the numbers of chapter seen by the users through the days.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(739, 'english', 'This chart gives you a view of all the chapters completed or passed per user.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(740, 'english', 'This chart gives you a view of all the chapters completed by the users in this course.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(741, 'english', 'There are no scorm packages in this course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(742, 'english', 'Object successfully completed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(743, 'english', 'This chart allows you to check the score acquired by the users in each scorm chapter.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(744, 'english', 'This chart allows you to check the time spent by the users inside each scorm chapter.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(745, 'english', 'Time', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(746, 'english', 'Courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(747, 'english', 'Help Desk', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(748, 'english', '<!-- here you can put some help text -->', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(749, 'english', 'Active courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(750, 'english', 'Courses that will be activated within 7 days', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(751, 'english', 'Administrator users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(752, 'english', 'Installed version', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(753, 'english', 'Info about courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(754, 'english', 'Welcome Page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(755, 'english', 'Courses that will be deactivated within 7 days', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(756, 'english', 'Follow Us', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(757, 'english', 'Inactive users (for at least one month)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(758, 'english', 'Last released version', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(759, 'english', 'Download or generate certificate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(760, 'english', 'A new version is available for the download', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(761, 'english', 'Online users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(762, 'english', '(New window)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(763, 'english', 'Quick <span>links</span>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(764, 'english', 'Users registered in the last 7 days', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(765, 'english', 'Users registered today', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(766, 'english', 'User registered yesterday', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(767, 'english', 'Super-admin users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(768, 'english', 'Docebo network', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(769, 'english', 'Suspended users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(770, 'english', 'Consulting site', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(771, 'english', 'LMS support site', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(772, 'english', 'Number of courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(773, 'english', 'Number of subscriptions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(774, 'english', 'Registered users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(775, 'english', 'Error, while retrieving the last available version', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(776, 'english', 'Docebo.com commercial services', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(777, 'english', 'Docebo.org open source community', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(778, 'english', 'Users info', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(779, 'english', 'Waiting subscription', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(780, 'english', 'New announcement', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(781, 'english', 'New announcement was published in the course "[course]"\n\nTitle: ''[title]''\n\n[text]\n\nYou can read it on Docebo at at URL <a href="[url]">[url]</a>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(782, 'english', 'Subscription request approved', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(783, 'english', 'Your course subscrition request to [course] has been approved by the administrator. You can enter the course clicking the URL located in <a href="[url]">[url]</a>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(784, 'english', 'The administrator has confirmed your subscription request to <a href="[url]">[url]</a>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(785, 'english', 'Your account has been deleted', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(786, 'english', 'Your account at <a href="[url]">[url]</a> with the username [userid] has been deleted', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(787, 'english', 'Subscription request refused', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(788, 'english', 'Your subscription requested for the course [course] has been refused by the administrator at <a href="[url]">[url]</a>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(789, 'english', 'The user account has been modified', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(790, 'english', 'Your account at the site <a href="[url]">[url]</a>  has been modified:\n\nUsername: [userid]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(791, 'english', 'Your subscription has been changed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(792, 'english', 'Your subscription at the course [course] at the address <a href="[url]">[url]</a> has been changed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(793, 'english', 'New forum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(794, 'english', 'New forum added to the course ''[course]'' at the address <a href="[url]">[url]</a>\n\n Title: [title]\n [text]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(795, 'english', 'There is a new message in a thread that you are following\n [url] > [course] > [forum_title] > [thread_title]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(796, 'english', 'There is a new thread in \n\n<a href="[url]">[url]</a> > [course] > [forum_title]\n\n Title: [thread_title]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(797, 'english', 'New user was subscribed to a course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(798, 'english', 'At url : <a href="[url]">[url]</a> a new user was subscribed to the course : [course]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(799, 'english', 'User is waiting for course subscription approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(800, 'english', 'New user subscribed to the ''[course]'' course and is waiting to be approved.\n\n<a href="[url]">[url]</a>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(801, 'english', 'and your password has been changed to: [password]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(802, 'english', 'User not approved', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(803, 'english', 'The administrator of [url] has not approved your subscription request', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(804, 'english', 'You are now registered in our system', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(805, 'english', 'You are now registered in our system at <a href="[url]">[url]</a>\nwith this account:\n\nUsername: [userid]\nPassword: [password]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(806, 'english', 'Alert: New message in a thread', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(807, 'english', 'Alert: new thread', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(808, 'english', 'New user group subscription waiting for approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(809, 'english', 'There is a new user subscription to a moderate group waiting for the approval at <a href="[url]">[url]</a>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(810, 'english', 'New user waiting for the approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(811, 'english', 'New user is registered at [url] and awaiting your approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(812, 'english', 'User is registered and waiting for your approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(813, 'english', 'There is a new user at <a href="[url]">[url]</a> waiting for the approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(814, 'english', 'You have received a new message', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(815, 'english', 'You have received a new message in the e-learning system at <a href="[url]">[url]</a> in the course [course] from the user [from]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(816, 'english', 'Base', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(817, 'english', 'Show logs', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(818, 'english', 'SMS', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(819, 'english', 'New Announcement', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(820, 'english', 'Course properties have been changed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(821, 'english', 'New category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(822, 'english', 'New reply', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(823, 'english', 'New thread', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(824, 'english', 'New message received', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(825, 'english', 'User approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(826, 'english', 'User bought a course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(827, 'english', 'Student completed a course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(828, 'english', 'User subscribed to a course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(829, 'english', 'User waiting to be subscribed to a course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(830, 'english', 'User level has been changed in a course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(831, 'english', 'User unsubscribed from a course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(832, 'english', 'User has been deleted', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(833, 'english', 'User subscribed to a group', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(834, 'english', 'User waiting to be subscribed in a group', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(835, 'english', 'User has been removed from a group', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(836, 'english', 'User has been modified', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(837, 'english', 'User has been created', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(838, 'english', 'User waiting to be approved in platform subscription', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(839, 'english', 'Event manager', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(840, 'english', 'Not used', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(841, 'english', 'Platform', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(842, 'english', 'DoceboCore', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(843, 'english', 'DoceboLMS', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(844, 'english', 'DoceboLMS-A', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(845, 'english', 'Moderators and Super Admins', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(846, 'english', 'Instructors', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(847, 'english', 'Instructors and Super Admins', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(848, 'english', 'User', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(849, 'english', 'Event settings', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(850, 'english', 'Add FAQ', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(851, 'english', 'Back to top', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(852, 'english', 'Keywords (separated by comma please)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(853, 'english', 'FAQ & Help', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(854, 'english', 'Select a word', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(855, 'english', 'FAQ list for this category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(856, 'english', 'FAQ view', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(857, 'english', 'Help view', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(858, 'english', 'Word', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(859, 'english', 'Add new custom field', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(860, 'english', 'All kind of fields', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(861, 'english', 'Fiscal code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(862, 'english', 'Country', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(863, 'english', 'Dropdown field', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(864, 'english', 'Element name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(865, 'english', '- No value -', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(866, 'english', 'New element', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(867, 'english', 'Value assigned', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(868, 'english', 'Insert new element', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(869, 'english', 'Field manager', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(870, 'english', 'Field category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(871, 'english', 'Keyword', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(872, 'english', 'Free text field', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(873, 'english', 'Gmail account', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(874, 'english', 'ICQ account', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(875, 'english', 'MSN account', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(876, 'english', 'New date field', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(877, 'english', 'New dropdown field', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(878, 'english', 'New free text field(big)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(879, 'english', 'New ICQ account filed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(880, 'english', 'New field MSN account', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(881, 'english', 'New field Skype account', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(882, 'english', 'New text field', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(883, 'english', 'New file field', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(884, 'english', 'New field yahoo account', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(885, 'english', 'New Yes/No field', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(886, 'english', 'Not done', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(887, 'english', 'No file loaded', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(888, 'english', 'Show on platforms', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(889, 'english', 'Skype account', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(890, 'english', 'Text field', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(891, 'english', 'Use multi-language field if available', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(892, 'english', 'Yahoo account', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(893, 'english', 'Field yes/no', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(894, 'english', 'Gap analysis', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(895, 'english', 'With a gap', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(896, 'english', 'Without a gap', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(897, 'english', 'Add new forum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(898, 'english', 'Start a new discussion', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(899, 'english', 'Mark all threads as read', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(900, 'english', 'Are you sure you want to move the thread?', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(901, 'english', 'You can''t access this discussion', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(902, 'english', 'Messages for this thread', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(903, 'english', 'Last messages in this thread', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(904, 'english', 'Choose who can see this forum (if nobody is selected, the forum will be seen by everyone)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(905, 'english', 'Moderate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(906, 'english', 'Forum list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(907, 'english', 'Emoticons', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(908, 'english', 'Forum closed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(909, 'english', 'Forum open', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(910, 'english', 'Show this forum to', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(911, 'english', 'This is a forum with all information regarding it', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(912, 'english', 'Unlock', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(913, 'english', 'Manage forum moderation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(914, 'english', 'Re-Open answers', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(915, 'english', 'from forum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(916, 'english', 'Mark thread as important', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(917, 'english', 'Last message.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(918, 'english', 'Locked', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(919, 'english', 'Message blocked by moderator', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(920, 'english', 'Lock forum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(921, 'english', 'Lock forum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(922, 'english', 'Lock answers', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(923, 'english', 'Message modified by', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(924, 'english', 'Mod. message', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(925, 'english', 'Move to forum:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(926, 'english', 'New message', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(927, 'english', 'New thread', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(928, 'english', 'You are not allowed to view this forum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(929, 'english', 'Notify', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(930, 'english', 'Notify request registered', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(931, 'english', 'Follow this forum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(932, 'english', 'Notify me about new threads in this forum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(933, 'english', 'Follow this thread', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(934, 'english', 'Follow this thread (notify me of new messages)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(935, 'english', 'Posts', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(936, 'english', 'Replies', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(937, 'english', 'Threads', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(938, 'english', 'Watchers', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(939, 'english', 'Quote', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(940, 'english', 'Re-Open thread', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(941, 'english', 'Find topic', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(942, 'english', 'Search result for', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(943, 'english', 'Remove important flag from thread', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(944, 'english', 'list with the thread present for the forum selected', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(945, 'english', 'Discussions available in forum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(946, 'english', 'List of threads', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(947, 'english', 'to forum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(948, 'english', 'Make accessible', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(949, 'english', 'Re-Open forum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(950, 'english', 'Open', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(951, 'english', 'Stop', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(952, 'english', 'Stop notifications for this forum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(953, 'english', 'Stop alerting me when threads are created in this forum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(954, 'english', 'Activate notifications', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(955, 'english', 'Stop notifications (stop annoying me)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(956, 'english', 'Picture, avatar and signature', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(957, 'english', 'User info', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(958, 'english', 'Show profile', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(959, 'english', 'Written by', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(960, 'english', 'Add word', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(961, 'english', 'Glossary', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(962, 'english', 'Terms list in the glossary', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(963, 'english', 'Word', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(964, 'english', 'Word description', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(965, 'english', 'Terms', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(966, 'english', 'Grade book', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(967, 'english', 'This is your score for the activities of this course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(968, 'english', 'This is a detailed list of the score collected in this course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(969, 'english', 'of', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(970, 'english', 'not graded yet', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(971, 'english', 'No score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(972, 'english', 'N.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(973, 'english', 'Sub.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(974, 'english', 'Groups for this course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(975, 'english', 'Manage the users subscribed to this group', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(976, 'english', 'Subscribe users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(977, 'english', 'Select the destination for the copy operation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(978, 'english', 'Choose destination folder', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(979, 'english', 'Auto-refresh', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(980, 'english', 'Emoticons', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(981, 'english', 'Message', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(982, 'english', 'Refresh', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(983, 'english', 'Rooms list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(984, 'english', 'Users list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(985, 'english', 'logged out.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(986, 'english', 'logged in.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(987, 'english', 'Introduction', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(988, 'english', 'Back to top', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(989, 'english', 'HTML page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(990, 'english', 'Access', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(991, 'english', 'New connection', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(992, 'english', 'New connector', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(993, 'english', 'New task', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(994, 'english', 'From example (through the analysis of the first file matching File pattern)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(995, 'english', 'If a course has been deleted', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(996, 'english', 'If a user has not been subscribed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(997, 'english', 'Removed folders', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(998, 'english', 'Canceled users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(999, 'english', 'Class', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1000, 'english', 'Confirm deletion', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1001, 'english', 'Connection', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1002, 'english', 'Connections', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1003, 'english', 'Connector', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1004, 'english', 'Connectors', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1005, 'english', 'Connectors', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1006, 'english', 'New connection', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1007, 'english', 'Connections', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1008, 'english', 'Destination', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1009, 'english', 'No input to process', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1010, 'english', 'Don''t delete', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1011, 'english', 'Don''t send', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1012, 'english', 'Fields definition', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1013, 'english', 'Fields definition mode', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1014, 'english', 'Field delimiter', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1015, 'english', 'Enclosure character', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1016, 'english', 'Sub-folder', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1017, 'english', 'File pattern', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1018, 'english', 'filename*', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1019, 'english', 'Analyzed file', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1020, 'english', 'Finish', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1021, 'english', 'First row header', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1022, 'english', 'Group filter', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1023, 'english', 'Hour', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1024, 'english', 'Import type', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1025, 'english', 'Insert only', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1026, 'english', 'Insert and remove', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1027, 'english', 'Last execution', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1028, 'english', 'Field''s map not required', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1029, 'english', 'There aren''t new connectors to insert', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1030, 'english', 'File pattern', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1031, 'english', 'Read', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1032, 'english', 'Read/Write', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1033, 'english', 'At', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1034, 'english', 'at %time%', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1035, 'english', 'Interval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1036, 'english', 'any %interval% %unit%', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1037, 'english', 'Send notify', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1038, 'english', 'Source', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1039, 'english', 'Menu to assign to new courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1040, 'english', 'Tasks', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1041, 'english', 'Del task', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1042, 'english', 'Insert/update', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1043, 'english', 'New task', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1044, 'english', 'Run', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1045, 'english', 'Executed task', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1046, 'english', 'Destination folder for users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1047, 'english', 'Select the folder containing the imported tree', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1048, 'english', 'Write', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1049, 'english', 'File not specified', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1050, 'english', 'File to upload<br />(this will overwrite the old one)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1051, 'english', 'File type', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1052, 'english', 'Upload files', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1053, 'english', 'Show all', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1054, 'english', 'Categorized only', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1055, 'english', 'Switch from scorm categorization to chapters categorization', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1056, 'english', 'Contained in', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1057, 'english', 'This resource is mobile compliant.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1058, 'english', 'Original name stored in the platform', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1059, 'english', 'Only related users can see this object', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1060, 'english', 'Everyone can access this object', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1061, 'english', 'Uncategorized only', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1062, 'english', 'Make this resource playable also by people that cannot access it.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1063, 'english', 'Switching between categorization mode will delete the current categorization.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1064, 'english', 'All the courses you are enrolled in.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1065, 'english', 'Guest', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1066, 'english', 'Ghost', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1067, 'english', 'Student', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1068, 'english', 'Tutor', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1069, 'english', 'Mentor', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1070, 'english', 'Instructor', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1071, 'english', 'Administrator', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1072, 'english', 'Add file to repository', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1073, 'english', 'Files uploaded', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1074, 'english', 'Uploaded files', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1075, 'english', 'New repository', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1076, 'english', 'No repositories available', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1077, 'english', 'new files', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1078, 'english', 'Repository', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1079, 'english', 'View student files', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1080, 'english', 'Add link', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1081, 'english', 'Allow to add a new link', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1082, 'english', 'Back to top', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1083, 'english', 'Keywords (separate by comma please)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1084, 'english', 'All the links will be opened in a new window', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1085, 'english', 'URL (Ex. http://www.website.com)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1086, 'english', 'Link', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1087, 'english', 'Select a word', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1088, 'english', 'Link list in category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1089, 'english', 'Keywords view', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1090, 'english', 'List view', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1091, 'english', 'Words', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1092, 'english', 'Home page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1093, 'english', 'Docebo is an Open Source e-Learning platform (LMS and LCMS) used in corporate and higher education markets.<br/>\n<br/>\nThe Platform supports 12 languages, it''s compliant with the SCORM 1.2 and 1.3 standards, and supports different didactic models, including: Blended, Self-Directed, Collaborative and even Social Learning through Chat, Wiki, Forums and other different functions.<br/>\n<br/>\n<br/>\nTo change these words please go to Admin/Language management, search for <b>login</b> and edit the key <b>_INTRO_STD_TEXT</b>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1094, 'english', 'Jump to login form', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1095, 'english', 'LDAP authentication is active, functionality unavailable please call your administrator', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1096, 'english', 'Login', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1097, 'english', 'Accessible Login', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1098, 'english', 'Login', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1099, 'english', 'Login with', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1100, 'english', 'Lost password', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1101, 'english', 'Fill this field with your user ID and you will receive an email (at your registration address) with the instruction for generate a new password.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1102, 'english', 'Fill this field with the email given in your registration process and you will receive an email that contains your username for this site.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1103, 'english', 'I lost my username', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1104, 'english', 'Access denied, please check your password', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1105, 'english', 'The two provided passwords are not equal or password field is empty.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1106, 'english', 'Please [login] or [signin] to buy or proceed with this course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1107, 'english', 'Please [login] to buy or proceed with this course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1108, 'english', 'This request is expired.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1109, 'english', 'Privacy policy', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1110, 'english', 'Another user has logged in with your username', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1111, 'english', 'You are logged out', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1112, 'english', 'Add new custom menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1113, 'english', 'Check all', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1114, 'english', 'Personalized name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1115, 'english', 'Create as a copy of', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1116, 'english', 'Levels', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1117, 'english', 'Assign modules to menu item', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1118, 'english', 'Customized name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1119, 'english', 'Sequence', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1120, 'english', 'Icons', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1121, 'english', 'Choose an icon for this menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1122, 'english', 'Custom Menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1123, 'english', 'List of custom menus created', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1124, 'english', 'Available modules for import', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1125, 'english', 'Main menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1126, 'english', 'Main items of the current custom menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1127, 'english', 'Modules assigned to this menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1128, 'english', 'Modules assigned to this menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1129, 'english', 'Add custom menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1130, 'english', 'Assign this module to this menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1131, 'english', 'Menu management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1132, 'english', 'Menu items', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1133, 'english', 'Module', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1134, 'english', 'Uncheck all', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1135, 'english', 'You are importing the module to this menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1136, 'english', 'You are working on this module', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1137, 'english', 'Main preferences', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1138, 'english', 'Administrators management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1139, 'english', 'Administrator profile', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1140, 'english', 'Associate Users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1141, 'english', 'Jump to the main menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1142, 'english', 'Jump to the modules list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1143, 'english', 'Certificates', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1144, 'english', 'Communications', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1145, 'english', 'Settings', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1146, 'english', 'Welcome Page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1147, 'english', 'Event manager', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1148, 'english', 'Events', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1149, 'english', 'Additional fields', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1150, 'english', 'Main', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1151, 'english', 'E-Learning', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1152, 'english', 'I/O Task', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1153, 'english', 'Jump to:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1154, 'english', 'Language management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1155, 'english', 'User management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1156, 'english', 'E-Learning', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1157, 'english', 'Reservation Management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1158, 'english', 'Certificates Management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1159, 'english', 'Aggregated certificates', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1160, 'english', 'User area in LMS', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1161, 'english', 'Module name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1162, 'english', 'Manage news in users area', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1163, 'english', 'Template player', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1164, 'english', 'Public Administrators management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1165, 'english', 'Public Administrator profile', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1166, 'english', 'Question category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1167, 'english', 'Quest Category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1168, 'english', 'Issued Certificates', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1169, 'english', 'Reservations', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1170, 'english', 'Subscribe to course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1171, 'english', 'Configuration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1172, 'english', 'Users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1173, 'english', 'Web pages', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1174, 'english', 'Announcements', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1175, 'english', 'Course charts', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1176, 'english', 'Grade book', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1177, 'english', 'User/objects grid', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1178, 'english', 'E-Portfolio', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1179, 'english', 'Report card', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1180, 'english', 'Group management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1181, 'english', 'Introduction', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1182, 'english', 'Course Info', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1183, 'english', 'Repository', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1184, 'english', 'Course Documents', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1185, 'english', 'My Profile', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1186, 'english', 'Project management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1187, 'english', 'Quest bank', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1188, 'english', 'Reservation module', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1189, 'english', 'Usage stats', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1190, 'english', 'Learning object stats', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1191, 'english', 'User stats', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1192, 'english', 'Learning object management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1193, 'english', 'Video conference', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1194, 'english', 'Wiki', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1195, 'english', 'Authoring', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1196, 'english', 'Jump to the main menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1197, 'english', 'Jump to your information related to this course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1198, 'english', 'Community', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1199, 'english', 'Activate course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1200, 'english', 'Admin area', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1201, 'english', 'Campus', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1202, 'english', 'General menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1203, 'english', 'Competences', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1204, 'english', 'My Courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1205, 'english', 'My area', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1206, 'english', 'Certificates', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1207, 'english', 'Manage', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1208, 'english', 'Certificates', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1209, 'english', 'Course management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1210, 'english', 'Community', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1211, 'english', 'Newsletter', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1212, 'english', 'Report', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1213, 'english', 'Course subscriptions management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1214, 'english', 'Users management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1215, 'english', 'Support', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1216, 'english', 'The message has attachments', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1217, 'english', 'Show only messages of the course:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1218, 'english', 'High', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1219, 'english', 'Received', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1220, 'english', 'Low', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1221, 'english', 'Mime type', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1222, 'english', 'You have inserted a blank subject', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1223, 'english', 'Normal', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1224, 'english', 'Sent', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1225, 'english', 'Priority', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1226, 'english', 'Refresh', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1227, 'english', 'Message read', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1228, 'english', 'Very high', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1229, 'english', 'Very low', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1230, 'english', 'Blocks', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1231, 'english', 'Select who can view this block', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1232, 'english', 'Complete user profile', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1233, 'english', 'Make block visible', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1234, 'english', 'Internal area', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1235, 'english', 'Simplified user profile', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1236, 'english', 'New notes', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1237, 'english', 'Show note', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1238, 'english', 'Notes', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1239, 'english', 'Vertical menu bar', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1240, 'english', 'Empty menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1241, 'english', 'Vertical menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1242, 'english', 'Attempt', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1243, 'english', 'Attempts', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1244, 'english', 'Autoplay', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1245, 'english', 'Your progress will be saved.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1246, 'english', 'Hide menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1247, 'english', 'Blocked', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1248, 'english', 'Objective', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1249, 'english', 'Lectures', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1250, 'english', 'End object marker', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1251, 'english', 'Prerequisites not satisfied', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1252, 'english', 'Bookmark', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1253, 'english', 'Final', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1254, 'english', 'Begin', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1255, 'english', 'Execute object', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1256, 'english', 'Lectures', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1257, 'english', 'Access', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1258, 'english', 'Publish from', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1259, 'english', 'Publish until', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1260, 'english', 'Select the destination folder for the copy operation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1261, 'english', 'Resource', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1262, 'english', 'Interactions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1263, 'english', 'Elapsed time', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1264, 'english', 'Show menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1265, 'english', 'Node Fields', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1266, 'english', 'Group name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1267, 'english', 'Do not import', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1268, 'english', 'Import schema', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1269, 'english', 'User inserted, wait for Admin approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1270, 'english', 'Assign node fields', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1271, 'english', 'Associate extra fields to user', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1272, 'english', 'Organization chart', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1273, 'english', 'Cascade', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1274, 'english', 'Inherited', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1275, 'english', 'Invisible to the user', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1276, 'english', 'Invisible', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1277, 'english', 'File charset', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1278, 'english', 'Choose file to import', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1279, 'english', 'Manage the first line as header', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1280, 'english', 'Choose separator (; or ,)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1281, 'english', 'Import users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1282, 'english', 'Descendants', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1283, 'english', 'List fields for the folder', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1284, 'english', 'Rename', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1285, 'english', 'Show also suspended users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1286, 'english', 'This username already exists, please choose a different one.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1287, 'english', 'Ass. user to group', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1288, 'english', 'Delete user', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1289, 'english', 'Personal learning objects', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1290, 'english', 'LO available in the course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1291, 'english', 'Shared learning object with other instructors', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1292, 'english', 'send to all', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1293, 'english', 'allow to send messages only to instructors', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1294, 'english', 'Allow file upload', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1295, 'english', 'LMS', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1296, 'english', 'Selected by', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1297, 'english', 'Answer text', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1298, 'english', 'Stat question', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1299, 'english', 'insert new question', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1300, 'english', 'no questions in this survey, please verify.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1301, 'english', 'Add question', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1302, 'english', 'New survey', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1303, 'english', 'Add answer', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1304, 'english', 'After the quest', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1305, 'english', 'You have already completed this survey', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1306, 'english', 'List of the available answers for this question', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1307, 'english', 'Begin the survey', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1308, 'english', 'Question list of the survey ( [tot_element] elements in [tot_page] pages )', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1309, 'english', 'Survey completed, thanks for your contribution.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1310, 'english', 'Back to the lesson', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1311, 'english', 'Submit survey', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1312, 'english', 'As the first', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1313, 'english', 'and put it after', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1314, 'english', 'As the last', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1315, 'english', 'Previous page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1316, 'english', 'Order', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1317, 'english', 'Question''s title', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1318, 'english', 'Remove question', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1319, 'english', 'Survey', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1320, 'english', 'Remove answer', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1321, 'english', 'List of all the questions created in this survey', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1322, 'english', 'Question', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1323, 'english', 'BP', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1324, 'english', 'CH', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1325, 'english', 'MC', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1326, 'english', 'CV', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1327, 'english', 'DV', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1328, 'english', 'ET', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1329, 'english', 'TI', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1330, 'english', 'Answer text', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1331, 'english', 'Break page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1332, 'english', 'Single choice', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1333, 'english', 'Multiple choice', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1334, 'english', 'user can choose more than one answer', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1335, 'english', 'Single choice - only one answer can be selected', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1336, 'english', 'Course evaluation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1337, 'english', 'Teacher evaluation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1338, 'english', 'Text answer', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1339, 'english', 'Title', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1340, 'english', 'Title - a free text', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1341, 'english', 'List of the answers to this question with the relative statistics', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1342, 'english', 'Survey', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1343, 'english', 'Create new assessment', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1344, 'english', 'Add effects', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1345, 'english', 'New rule', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1346, 'english', 'Effects', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1347, 'english', 'Assign teacher at the assessment', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1348, 'english', 'Assign teacher that can manage assessment', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1349, 'english', 'Assign rule to the assessment', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1350, 'english', 'Assign courses where the user will be subscribed after completing assessment', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1351, 'english', 'Assessment list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1352, 'english', 'Rules list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1353, 'english', 'Do nothing', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1354, 'english', 'Completing rules', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1355, 'english', 'Courses where the user will be subscribed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1356, 'english', 'If no rules has been applied', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1357, 'english', 'If two rules are in conflict, both of them will be applied', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1358, 'english', 'Rule description', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1359, 'english', 'Rules list to apply when assessment is completed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1360, 'english', 'Template', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1361, 'english', 'Number of log in', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1362, 'english', 'Time in course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1363, 'english', '[firstname]''s activity', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1364, 'english', 'Just png, gif and jpg image formats are allowed for the upload. If size exceeds [max_px] pixel it will be automatically resized.<br />\nPlease don''t upload offensive images.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1365, 'english', 'Change password', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1366, 'english', 'Fields visibility', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1367, 'english', 'Community', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1368, 'english', 'Skill name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1369, 'english', 'Acquired score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1370, 'english', 'Contacts', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1371, 'english', 'Course enrolled as mentor', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1372, 'english', 'Course enrolled as instructor', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1373, 'english', 'Course enrolled as tutor', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1374, 'english', 'Deleted users list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1375, 'english', 'Delete date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1376, 'english', 'Field content', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1377, 'english', 'Operator first name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1378, 'english', 'Welcome to the e-learning platform', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1379, 'english', 'Forum post', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1380, 'english', 'Goto [firstname]''s blog', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1381, 'english', 'Go to user blog', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1382, 'english', 'Go to [firstname]''s profile', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1383, 'english', 'Database ID', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1384, 'english', 'Operator last name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1385, 'english', 'Who have seen this profile', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1386, 'english', 'Message text', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1387, 'english', 'The new password is valid for', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1388, 'english', '(Visit in the last [days] days)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1389, 'english', 'No avatar', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1390, 'english', 'No audio found', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1391, 'english', 'No images found', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1392, 'english', 'No files found', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1393, 'english', 'This profile has not received visits yet', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1394, 'english', 'No videos found', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1395, 'english', 'The inserted password is not yours', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1396, 'english', 'Old password', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1397, 'english', 'Other options', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1398, 'english', 'no one', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1399, 'english', 'teachers', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1400, 'english', 'Rule assigned to the field', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1401, 'english', 'Accept private messages from', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1402, 'english', 'User Profile', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1403, 'english', 'Member since', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1404, 'english', 'Final test score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1405, 'english', 'Starting test score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1406, 'english', 'Shared files', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1407, 'english', 'Show my online status (teacher can view it anyway)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1408, 'english', 'Curriculum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1409, 'english', 'Teacher profile', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1410, 'english', 'Publications', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1411, 'english', 'Your password is expired', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1412, 'english', 'No limits configured', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1413, 'english', 'The user is offline', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1414, 'english', 'Skills', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1415, 'english', 'User''s courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1416, 'english', 'User''s courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1417, 'english', 'User statistics', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1418, 'english', 'User status', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1419, 'english', 'Picture, avatar and signature', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1420, 'english', 'Operator ID', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1421, 'english', 'Offline', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1422, 'english', 'Online', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1423, 'english', 'User parameters', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1424, 'english', 'Your details stored in the system', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1425, 'english', 'Audio', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1426, 'english', 'Other files', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1427, 'english', 'Used disk space', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1428, 'english', 'Now the user is', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1429, 'english', 'Video', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1430, 'english', 'Video', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1431, 'english', 'Welcome!', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1432, 'english', 'Write a message for your request', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1433, 'english', 'Manage admins', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1434, 'english', 'Projects you are attending', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1435, 'english', 'New project', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1436, 'english', 'This project has no active features at this time.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1437, 'english', 'Project admins', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1438, 'english', 'Project group', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1439, 'english', 'Project options', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1440, 'english', 'Files', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1441, 'english', 'You must specify a title', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1442, 'english', 'You selected an invalid group and/or you''re not a member of it.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1443, 'english', 'Total progress', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1444, 'english', 'Tasks', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1445, 'english', 'To do', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1446, 'english', 'Project manager', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1447, 'english', 'List of all the projects that you are following', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1448, 'english', 'Show files area', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1449, 'english', 'Enable internal messages', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1450, 'english', 'Show news area', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1451, 'english', 'Show tasks area', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1452, 'english', 'Show To Do area', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1453, 'english', 'Project title', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1454, 'english', 'Task description', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1455, 'english', 'Task name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1456, 'english', 'Task progress (%)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1457, 'english', 'Just yourself', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1458, 'english', 'Activity', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1459, 'english', 'Special settings for:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1460, 'english', 'Category in use, you can''t delete it', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1461, 'english', 'Quest categories', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1462, 'english', 'I agree', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1463, 'english', 'Change language', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1464, 'english', 'Choose a new password', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1465, 'english', 'This email is already used by another user.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1466, 'english', 'This user ID is not available, choose another one', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1467, 'english', 'You must enter a valid email address', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1468, 'english', 'Username is blank or invalid', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1469, 'english', 'Password must contain numbers and characters', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1470, 'english', 'The password does not match with the second one typed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1471, 'english', 'You must accept the privacy policy in order to register', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1472, 'english', 'The old password is wrong', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1473, 'english', 'This is the first time you log in to the system. Please change your temporary password', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1474, 'english', 'Back to login page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1475, 'english', 'This is the field associated with the group selected', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1476, 'english', 'Registration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1477, 'english', 'The userID you''ve inserted doesn''t exist. Please check and retry', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1478, 'english', 'Activation code not valid', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1479, 'english', 'The security code is invalid', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1480, 'english', 'Back to login', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1481, 'english', 'If you have lost your password insert your userID in the field below, you will receive a email with some instruction', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1482, 'english', 'If you have lost your username insert your registration mail address in the field below, you will receive a email', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1483, 'english', 'This is the process to generate a new password for the user associated to this email address. Click the link below to generate a new password.<br/>\n<br/>\n<a href="[link]">[link]</a>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1484, 'english', 'New password', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1485, 'english', 'I lost my password', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1486, 'english', 'I lost my username', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1487, 'english', 'Your username for the [url] website community is [userid]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1488, 'english', 'Recover username', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1489, 'english', 'Please confirm your registration request', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1490, 'english', 'Thank you! We have sent you an email with your username.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1491, 'english', 'Thank you! We have sent you an email with the link to reset your password.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1492, 'english', 'Your new password is valid for [valid_for_day] days.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1493, 'english', 'New password', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1494, 'english', 'Blank space before and after userID fields are not valid and will be erased', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1495, 'english', 'Your old password', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1496, 'english', 'Password too short', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1497, 'english', 'The confirmation of your account is failed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1498, 'english', 'The request is not valid because the validity period is elapsed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1499, 'english', 'This request will expire after <b>[hour] hours</b>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1500, 'english', 'We have received your subscription request with the following information:<br />\n<br />\nUserID : [userid]<br />\nPassword : [password]<br />\n<br />\nTo complete  the registration process, please click on the link below, (or copy it in your web browser address bar)<br />\n<br />\n<a href="[link]">[link]</a><br />\n<br />\nThis request will be valid for the next [hour] hours', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1501, 'english', 'You must fill the mandatory fields, marked with the symbol [mandatory]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1502, 'english', 'From this page you can register to the platform; follow the instructions below and fill in the fields properly.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1503, 'english', 'Registration is not active', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1504, 'english', 'The password must contain at least <b>[min_char] chars</b>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1505, 'english', 'The password must contain <b>characters</b> and <b>numbers</b>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1506, 'english', 'Activation code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1507, 'english', 'I accept the terms of the privacy policy', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1508, 'english', 'Any information collected by us, relating to an identifiable person, shall be used only in accordance with the procedures and for the purposes that are here acknowledged to the data subject and where the latter, as required by law, has expressely consented. <br><br>\n\n- User login and private area<br>\n- User newsletter<br>\n- User custom content purpose<br><br>\n\nIn handling this information, accuracy and precision shall be met to ensure the integrity and quality of the processed personal data, if you have any question please contact us.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1509, 'english', 'Privacy policy', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1510, 'english', 'You must accept the privacy policy', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1511, 'english', 'Thank you for the request of registration to our community.\nIn order to protect your privacy you will receive an email with the confirmation link.\nYou have to confirm your account before using it.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1512, 'english', 'your username', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1513, 'english', 'Your registration has been confirmed, you will receive an email as soon as the administrator approves it', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1514, 'english', 'Registration confirmed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1515, 'english', 'Retype the password', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1516, 'english', 'Select the group you want to subscribe', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1517, 'english', 'List of groups available for subscription', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1518, 'english', 'You haven''t filled in some mandatory fields', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1519, 'english', 'This procedure is required for security or legal reason by the website administrator and consists in changing password periodically.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1520, 'english', 'Data aggregation on users and course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1521, 'english', 'Courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1522, 'english', 'Subdivide data according to the organization chart', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1523, 'english', 'Show results', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1524, 'english', 'Users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1525, 'english', 'Aggregate data on', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1526, 'english', '<< Back to report list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1527, 'english', 'Choose time range to show', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1528, 'english', 'Choose users that you want to analyse', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1529, 'english', 'Competences filters settings', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1530, 'english', 'You can set filters about selected users competences.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1531, 'english', '(select a competence)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1532, 'english', '(select a condition)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1533, 'english', 'Course''s end date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1534, 'english', 'Inscription date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1535, 'english', 'Score in course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1536, 'english', 'Initial score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1537, 'english', 'Session count', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1538, 'english', 'Courses selection', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1539, 'english', 'Users that haven''t completed the course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1540, 'english', 'Display courses information', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1541, 'english', 'Display user''s information about courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1542, 'english', 'Users who haven''t started the course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1543, 'english', 'Creation date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1544, 'english', 'Current selection', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1545, 'english', 'User defined time range', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1546, 'english', 'Completion date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1547, 'english', 'Subscription date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1548, 'english', 'Course expiring on (specify date)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1549, 'english', 'After (specify number) days from their subscription', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1550, 'english', 'Course expiring in (specify number) days', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1551, 'english', 'All conditions must be satisfied', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1552, 'english', 'At least one condition must be satisfied', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1553, 'english', 'Reset filters', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1554, 'english', 'Subscribed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1555, 'english', 'Last 30 days', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1556, 'english', 'Last 6 months', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1557, 'english', 'Last 3 months', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1558, 'english', 'Last seven days', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1559, 'english', 'Last year', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1560, 'english', 'First attempt', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1561, 'english', 'Last attempt', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1562, 'english', 'Milestone', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1563, 'english', 'L.O. type', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1564, 'english', 'Mail body', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1565, 'english', 'To begin', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1566, 'english', 'Not activated', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1567, 'english', 'No courses have been selected', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1568, 'english', 'No results found.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1569, 'english', 'No values have been selected', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1570, 'english', 'Num.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1571, 'english', 'Perc.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1572, 'english', 'Course categories', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1573, 'english', 'Years', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1574, 'english', 'Relates courses with users votes (from poll).', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1575, 'english', 'Relates courses with the teachers votes (from poll)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1576, 'english', 'Relates courses to users.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1577, 'english', 'Users competences details', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1578, 'english', 'Columns filter''s setting', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1579, 'english', 'Conditions on selected courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1580, 'english', 'Select Courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1581, 'english', 'Everyday', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1582, 'english', 'Report for all the users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1583, 'english', 'Edit columns filters', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1584, 'english', 'Edit rows filters', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1585, 'english', 'Every month, on the day:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1586, 'english', 'Columns data', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1587, 'english', 'Rows filter''s settings', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1588, 'english', 'Time period', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1589, 'english', 'Define time period and options to consider for delay analysis', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1590, 'english', 'Every week, on the day:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1591, 'english', 'This table contains the statistic about the selected users in the courses in the platform', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1592, 'english', 'User courses details', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1593, 'english', 'Relates users to communications', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1594, 'english', 'Relates users to competences', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1595, 'english', 'Relates users to courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1596, 'english', 'Make delay analysis', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1597, 'english', 'Relates users to corporate contest', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1598, 'english', 'Relates users to Learning Objects', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1599, 'english', 'Select milestones', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1600, 'english', 'Learning Objects types', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1601, 'english', '<< SAVE and back to report list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1602, 'english', 'Save and back to list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1603, 'english', 'Description:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1604, 'english', 'Save and show', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1605, 'english', 'Every week,', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1606, 'english', 'Learning Objects options', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1607, 'english', 'Select report category:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1608, 'english', 'Check the columns you want to view in the report table', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1609, 'english', 'Courses manual selection', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1610, 'english', 'Send e-mail', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1611, 'english', 'Shown columns', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1612, 'english', 'Show but do not save', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1613, 'english', 'Show statistics about courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1614, 'english', 'Created by', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1615, 'english', 'Public', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1616, 'english', 'Path', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1617, 'english', 'Estimated time', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1618, 'english', 'Course score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1619, 'english', 'Subscribed date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1620, 'english', 'Number of sessions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1621, 'english', 'Start score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1622, 'english', 'Date range', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1623, 'english', 'Range', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1624, 'english', 'Filter for time periods', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1625, 'english', 'Time', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1626, 'english', 'Show users custom fields', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1627, 'english', 'Add users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1628, 'english', 'assign', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1629, 'english', 'Are you sure to Register this Event?', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1630, 'english', 'Are You Sure to Cancel this Registration?', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1631, 'english', 'Available', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1632, 'english', 'Cancel Registration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1633, 'english', 'Categories', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1634, 'english', 'Manage Category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1635, 'english', 'Max Event for Category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1636, 'english', 'Subscribe users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1637, 'english', 'Deadline', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1638, 'english', 'Register this event instead of', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1639, 'english', 'Event list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1640, 'english', 'From Time', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1641, 'english', 'Laboratory management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1642, 'english', 'Max number of subscriptions for this category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1643, 'english', 'Max user', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1644, 'english', 'No reservations found', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1645, 'english', 'No users enrolled', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1646, 'english', 'Num of  registered', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1647, 'english', 'Registration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1648, 'english', 'Reservation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1649, 'english', 'Category management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1650, 'english', 'Available Events', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1651, 'english', 'My Registration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1652, 'english', 'Past Events', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1653, 'english', 'Manage Events', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1654, 'english', 'List of current reservations', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1655, 'english', 'FULL', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1656, 'english', 'Who can reserve this event', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1657, 'english', 'Subscribe users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1658, 'english', 'Switch (choose this event instead of another)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1659, 'english', 'End Time', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1660, 'english', 'Undefined', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1661, 'english', 'Unlimited', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1662, 'english', 'User enrolled', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1663, 'english', 'View enrolled user', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1664, 'english', 'Wrong date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1665, 'english', 'Wrong time range', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1666, 'english', 'Back to list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1667, 'english', 'Select a content package with .zip or .pif extension', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1668, 'english', 'You have to specify the file to upload', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1669, 'english', 'SCORM 1.2 and 1.3 importer', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1670, 'english', 'Create complete objects list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1671, 'english', 'Upload SCORM package', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1672, 'english', 'SCORM', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1673, 'english', 'Load scorm package', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1674, 'english', 'Advanced selection', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1675, 'english', 'WARNING: Watch additional details', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1676, 'english', 'to edit them.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1677, 'english', 'Simplified selection', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1678, 'english', 'Simplified selection', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1679, 'english', 'E-learning: course ''[course]'', new announcement: [title]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1680, 'english', 'Your subscription request at course [course] has been approved by the administrator', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1681, 'english', 'Your subscription request has been approved', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1682, 'english', 'E-Learning: Your account with the username [userid] has been deleted', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1683, 'english', 'Your account at the site <a href="[url]">[url]</a>   has been modified:\n\nUsername: [userid]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1684, 'english', 'E-learning: course ''[course]'' new forum ''[title]''', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1685, 'english', 'New forum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1686, 'english', 'E-learning: in the course ''[course]'', there is a new message in ''[forum_title]'' > ''[thread_title]''', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1687, 'english', 'E-learning: course ''[course]'' there''s a new thread in ''[forum_title]'': [thread_title]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1688, 'english', 'and your password has been changed to: [password]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1689, 'english', 'You are now registered in our system with this account:\n\nUsername: [userid]\nPassword: [password]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1690, 'english', 'There is a new user subscription to a moderate group waiting for approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1691, 'english', 'New user is registered and awaiting your approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1692, 'english', 'There is a new user waiting for the approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1693, 'english', 'You have received a new message in the e-learning system in the course [course] from the user [from]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1694, 'english', 'Accounts connected:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1695, 'english', 'Link your Docebo account with:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1696, 'english', 'Started', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1697, 'english', 'Started', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1698, 'english', 'Completed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1699, 'english', 'Failed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1700, 'english', 'Not completed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1701, 'english', 'Not attempted', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1702, 'english', 'Not attempted', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1703, 'english', 'Passed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1704, 'english', 'Accesses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1705, 'english', 'Activate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1706, 'english', 'Active', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1707, 'english', '(Current area)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1708, 'english', 'Activity', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1709, 'english', 'Add', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1710, 'english', 'Add tags', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1711, 'english', 'Administrator', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1712, 'english', 'Administrators', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1713, 'english', 'Advanced', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1714, 'english', 'Advanced search', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1715, 'english', 'All', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1716, 'english', 'All categories', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1717, 'english', 'All courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1718, 'english', 'All pages', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1719, 'english', 'Check', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1720, 'english', '-', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1721, 'english', '', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1722, 'english', 'Root', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1723, 'english', 'Answer', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1724, 'english', 'Approve', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1725, 'english', 'Waiting for users approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1726, 'english', 'Are you sure?', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1727, 'english', 'Assessment', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1728, 'english', 'Assign', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1729, 'english', 'Assign administrators', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1730, 'english', 'Assign users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1731, 'english', 'Attachment', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1732, 'english', 'Attendance', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1733, 'english', 'Author', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1734, 'english', 'Auto-detect', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1735, 'english', 'Avatar', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1736, 'english', 'Average', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1737, 'english', '&lt;&lt; Back', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1738, 'english', 'Basic search', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1739, 'english', 'by', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1740, 'english', 'Calendar', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1741, 'english', 'Cancel', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1742, 'english', 'Course catalog', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1743, 'english', 'Categorization', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1744, 'english', 'Categorize', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1745, 'english', 'Category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1746, 'english', 'Chapters', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1747, 'english', 'Chat', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1748, 'english', 'Classroom', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1749, 'english', 'Close', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1750, 'english', 'Code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1751, 'english', 'Collapse', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1752, 'english', 'Comments', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1753, 'english', 'Communications', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1754, 'english', 'Community blog', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1755, 'english', 'Company blog', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1756, 'english', 'Competence', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1757, 'english', 'Competences', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1758, 'english', 'Completed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1759, 'english', 'Confirm', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1760, 'english', 'Connect', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1761, 'english', 'Connection error', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1762, 'english', 'Contains', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1763, 'english', 'Contents', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1764, 'english', 'Content library', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1765, 'english', 'Contest', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1766, 'english', 'Continue', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1767, 'english', 'Course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1768, 'english', 'Curricula', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1769, 'english', 'Courses', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1770, 'english', 'Course code', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1771, 'english', 'Courses list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1772, 'english', 'Course name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1773, 'english', 'Free', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1774, 'english', 'Create', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1775, 'english', 'Credits', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1776, 'english', 'Current file', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1777, 'english', 'Date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1778, 'english', 'Date begin', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1779, 'english', 'Date end', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1780, 'english', 'First access date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1781, 'english', 'Date format', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1782, 'english', 'Last access date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1783, 'english', 'Day', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1784, 'english', 'Day(s)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1785, 'english', 'Deactivate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1786, 'english', 'Default language', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1787, 'english', 'Delete', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1788, 'english', 'Delete file', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1789, 'english', 'Delete selected', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1790, 'english', 'Recover', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1791, 'english', 'Reject', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1792, 'english', 'Description', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1793, 'english', 'Details', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1794, 'english', 'Difficulty', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1795, 'english', 'Hard', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1796, 'english', 'Easy', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1797, 'english', 'Medium', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1798, 'english', 'Very hard', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1799, 'english', 'Very easy', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1800, 'english', 'DimDim', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1801, 'english', 'Disconnect', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1802, 'english', 'Down', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1803, 'english', 'Download', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1804, 'english', 'Edition', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1805, 'english', 'Editions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1806, 'english', 'Edit score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1807, 'english', 'Edit setting', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1808, 'english', 'E-Learning', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1809, 'english', 'Email', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1810, 'english', 'Empty selection', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1811, 'english', 'End', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1812, 'english', 'Last element', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1813, 'english', 'End with', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1814, 'english', 'Enrollment rules', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1815, 'english', 'Enrolled', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1816, 'english', 'Enter', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1817, 'english', 'Environment', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1818, 'english', 'Equal to', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1819, 'english', 'Errors', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1820, 'english', 'You can''t move folder in to their descendant', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1821, 'english', 'You are required to fill in the name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1822, 'english', 'Error while uploading the object, object not uploaded', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1823, 'english', 'Event', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1824, 'english', 'Expand', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1825, 'english', 'Expire on', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1826, 'english', 'Export', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1827, 'english', 'Export as CSV', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1828, 'english', 'Export as HTML', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1829, 'english', 'Export as XLS', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1830, 'english', 'Export as XML', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1831, 'english', 'Facebook', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1832, 'english', 'Field name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1833, 'english', 'File', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1834, 'english', 'File name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1835, 'english', 'Filter by', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1836, 'english', 'All the conditions must be satisfied', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1837, 'english', 'At least one condition must be satisfied', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1838, 'english', 'Final score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1839, 'english', 'First name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1840, 'english', 'Fix sequence error', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1841, 'english', 'Forum', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1842, 'english', 'from', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1843, 'english', 'Fullname', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1844, 'english', 'Company roles', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1845, 'english', 'Gap', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1846, 'english', 'Google', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1847, 'english', 'Groups', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1848, 'english', 'Height', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1849, 'english', 'Hidden', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1850, 'english', 'History', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1851, 'english', 'Hours', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1852, 'english', 'Image', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1853, 'english', 'Images', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1854, 'english', 'Import', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1855, 'english', 'Important', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1856, 'english', 'Import XML', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1857, 'english', 'Descendants', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1858, 'english', 'Insert', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1859, 'english', 'Instructions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1860, 'english', 'Invalid extension', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1861, 'english', 'Jump to', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1862, 'english', 'Jump to module content', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1863, 'english', 'Label', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1864, 'english', 'Labels', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1865, 'english', 'Language', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1866, 'english', 'Last name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1867, 'english', 'Learning Objects', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1868, 'english', 'Level', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1869, 'english', 'Link', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1870, 'english', 'Linkedin', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1871, 'english', 'Uploaded files', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1872, 'english', 'Loading', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1873, 'english', 'Locations', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1874, 'english', 'Logout', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1875, 'english', 'Assignment of users to a functional role', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1876, 'english', 'Assignment of users to a group', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1877, 'english', 'Make a copy', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1878, 'english', 'Manage', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1879, 'english', 'Groups management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1880, 'english', 'Mandatory', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1881, 'english', 'Manual', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1882, 'english', 'Manage menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1883, 'english', 'Mark as important', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1884, 'english', 'Max score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1885, 'english', 'Meet', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1886, 'english', 'Messages', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1887, 'english', 'Mime type', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1888, 'english', 'Minutes', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1889, 'english', 'Min score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1890, 'english', 'Edit', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1891, 'english', 'Moderate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1892, 'english', 'Edit selected', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1893, 'english', 'Edit title', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1894, 'english', 'January', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1895, 'english', 'February', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1896, 'english', 'March', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1897, 'english', 'April', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1898, 'english', 'May', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1899, 'english', 'June', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1900, 'english', 'July', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1901, 'english', 'August', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1902, 'english', 'September', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1903, 'english', 'October', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1904, 'english', 'November', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1905, 'english', 'December', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1906, 'english', 'More actions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1907, 'english', 'Add further attachments', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1908, 'english', 'More info', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1909, 'english', 'Move', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1910, 'english', 'Move down', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1911, 'english', 'Move up', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1912, 'english', 'Name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1913, 'english', 'Never', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1914, 'english', 'New', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1915, 'english', 'News', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1916, 'english', 'Newsletter', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1917, 'english', 'New category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1918, 'english', 'New course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1919, 'english', 'New event', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1920, 'english', 'New filter', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1921, 'english', 'New folder', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1922, 'english', 'New user', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1923, 'english', 'Next', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1924, 'english', 'No', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1925, 'english', 'None', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1926, 'english', 'Notes', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1927, 'english', 'No title', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1928, 'english', 'Not assigned', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1929, 'english', 'Does not contain', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1930, 'english', 'Is not equal to', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1931, 'english', 'Not satisfied', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1932, 'english', 'Not started', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1933, 'english', 'Untranslated languages, click here to expand', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1934, 'english', 'No answers', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1935, 'english', 'No, please get back', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1936, 'english', 'No categories', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1937, 'english', 'No content available', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1938, 'english', 'of', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1939, 'english', 'Off', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1940, 'english', 'On', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1941, 'english', 'One month', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1942, 'english', 'Only one time', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1943, 'english', 'Open', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1944, 'english', 'Error while processing the requested operation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1945, 'english', 'Operation successfully completed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1946, 'english', 'Order by', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1947, 'english', 'Order asc', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1948, 'english', 'Ascending order', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1949, 'english', 'Order desc', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1950, 'english', 'Desc', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1951, 'english', 'Descending order', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1952, 'english', 'Organization chart', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1953, 'english', 'Add node', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1954, 'english', 'Pages', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1955, 'english', 'Password', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1956, 'english', 'Percentage', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1957, 'english', 'Planned', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1958, 'english', 'Play', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1959, 'english', 'Number of views', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1960, 'english', 'Prerequisites', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1961, 'english', 'Previous', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1962, 'english', 'Previous element', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1963, 'english', 'Preview', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1964, 'english', 'Previous', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1965, 'english', 'Progress', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1966, 'english', 'Properties', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1967, 'english', 'Public Administrator', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1968, 'english', 'Publish', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1969, 'english', 'Question', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1970, 'english', 'Elements:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1971, 'english', 'Reactivate', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1972, 'english', 'Read', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1973, 'english', 'Recipients', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1974, 'english', 'Register', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1975, 'english', 'Join date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1976, 'english', 'Remove from node', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1977, 'english', 'Reply', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1978, 'english', 'Paste Learning Object', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1979, 'english', 'Report', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1980, 'english', 'Required score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1981, 'english', 'Reset', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1982, 'english', 'Rollback', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1983, 'english', 'Row', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1984, 'english', 'Save changes', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1985, 'english', 'Schedule', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1986, 'english', 'Score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1987, 'english', 'Search', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1988, 'english', 'seconds', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1989, 'english', 'Select', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1990, 'english', 'Selected elements', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1991, 'english', 'Select all', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1992, 'english', 'Send', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1993, 'english', 'Sender', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1994, 'english', 'Send to', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1995, 'english', 'Set', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1996, 'english', 'Short description', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1997, 'english', 'Show', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1998, 'english', 'Results', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(1999, 'english', 'Signature', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2000, 'english', 'Order by', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2001, 'english', 'Standings', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2002, 'english', 'Start', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2003, 'english', 'Started', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2004, 'english', 'Start with', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2005, 'english', 'Start date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2006, 'english', 'Start page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2007, 'english', 'Start', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2008, 'english', 'Statistics', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2009, 'english', 'Status', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2010, 'english', 'Subject', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2011, 'english', 'Subscribe', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2012, 'english', 'Subscribed by', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2013, 'english', 'Suspend', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2014, 'english', 'Suspended', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2015, 'english', 'Tabs', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2016, 'english', 'Tags', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2017, 'english', 'Teleskill', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2018, 'english', 'Text', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2019, 'english', 'Time periods', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2020, 'english', 'Title', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2021, 'english', 'to', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2022, 'english', 'Total', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2023, 'english', 'Total time', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2024, 'english', 'Transaction', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2025, 'english', 'Twitter', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2026, 'english', 'Type', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2027, 'english', 'Typology', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2028, 'english', 'Unassign', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2029, 'english', 'Undo', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2030, 'english', 'Infinite', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2031, 'english', 'Unpublish', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2032, 'english', 'Not read', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2033, 'english', 'Unselect all', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2034, 'english', 'Until not completed/passed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2035, 'english', 'Up', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2036, 'english', 'Upload file(s)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2037, 'english', 'URL', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2038, 'english', 'User', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2039, 'english', 'Username', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2040, 'english', 'Users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2041, 'english', 'In progress', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2042, 'english', 'Deleted', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2043, 'english', 'Subscriptions to confirm', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2044, 'english', 'Completed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2045, 'english', 'Reserved', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2046, 'english', 'Subscribed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2047, 'english', 'Suspended', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2048, 'english', 'Version', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2049, 'english', 'Video conference', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2050, 'english', 'View', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2051, 'english', 'Edit view rights', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2052, 'english', 'Waiting', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2053, 'english', 'Waiting users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2054, 'english', 'Warning', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2055, 'english', 'Width', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2056, 'english', 'Year', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2057, 'english', 'Yes', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2058, 'english', 'At hour', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2059, 'english', 'day', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2060, 'english', 'month', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2061, 'english', 'Show page views in the last 24 hours', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2062, 'english', 'Show page views in the last 30 days', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2063, 'english', 'Show page views in the last 7 days', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2064, 'english', 'Show page views in the last 12 months', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2065, 'english', 'week', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2066, 'english', 'year', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2067, 'english', 'Duration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2068, 'english', 'Session ends at', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2069, 'english', 'Last op.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2070, 'english', 'Number of op.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2071, 'english', 'Order by duration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2072, 'english', 'Order by number of operations', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2073, 'english', 'Order by session start', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2074, 'english', 'Page view', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2075, 'english', 'Session started at', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2076, 'english', 'Duration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2077, 'english', 'Operation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2078, 'english', 'User list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2079, 'english', 'User sessions list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2080, 'english', 'User session list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2081, 'english', 'User list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2082, 'english', 'User total time in this course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2083, 'english', 'Session details', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2084, 'english', 'Show', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2085, 'english', 'Sun', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2086, 'english', 'Mon', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2087, 'english', 'Tue', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2088, 'english', 'Wed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2089, 'english', 'Thu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2090, 'english', 'Fri', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2091, 'english', 'Sat', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2092, 'english', 'Show only users that have seen at least one Learning Object', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2093, 'english', 'All status', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2094, 'english', 'Stats by object', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2095, 'english', 'Objects', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2096, 'english', 'User stas', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2097, 'english', 'Statistics', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2098, 'english', 'No data for user/lesson', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2099, 'english', 'for lesson', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2100, 'english', 'Stats by object:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2101, 'english', 'Stats by Student/Object', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2102, 'english', 'Fullname', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2103, 'english', 'Users stats', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2104, 'english', 'My Objects', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2105, 'english', 'Locked', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2106, 'english', 'FAQ', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2107, 'english', 'Glossary', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2108, 'english', 'HTML page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2109, 'english', 'Upload file', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2110, 'english', 'Links', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2111, 'english', 'Survey', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2112, 'english', 'Scorm chapter', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2113, 'english', 'SCORM', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2114, 'english', 'Test', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2115, 'english', 'Folder name', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2116, 'english', 'End course marker', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2117, 'english', 'Requisites not satisfied', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2118, 'english', 'Play object', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2119, 'english', 'Course objects', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2120, 'english', 'Shared objects', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2121, 'english', 'Rename', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2122, 'english', 'Copy Learning Object', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2123, 'english', 'New Learning Object', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2124, 'english', 'Select destination for :', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2125, 'english', 'Watching rules', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2126, 'english', 'Select Learning Object', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2127, 'english', 'Select destination folder', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2128, 'english', 'Absence', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2129, 'english', 'The users subscription to this course will be confirmed only after the adminstator approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2130, 'english', 'Select the level for the user selected', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2131, 'english', 'Select the students to be subscribed to the course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2132, 'english', 'Correct subscription', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2133, 'english', 'Active from', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2134, 'english', 'Active until', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2135, 'english', 'Date of first completion', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2136, 'english', 'Date of last completion', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2137, 'english', 'Your subscription request at course [course] has been refused by the administrator', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2138, 'english', 'For this course you must select only [max_subscribe] users to subscribe', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2139, 'english', 'Select file(s) to import', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2140, 'english', 'Import users from course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2141, 'english', 'Use first row as header', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2142, 'english', 'For import use a file with a users list (one per row)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2143, 'english', 'Correct insertions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2144, 'english', 'Insertions not necessary', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2145, 'english', 'Insertion status', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2146, 'english', 'Yes, justified', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2147, 'english', 'Level of users to import', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2148, 'english', 'Without expiration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2149, 'english', 'Not expired', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2150, 'english', 'Yes, not justified', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2151, 'english', 'Not necessary, already subscribed to course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2152, 'english', 'Only expired', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2153, 'english', 'Remove validity dates', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2154, 'english', 'Select who wants to confirm', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2155, 'english', 'Send an alert to subscribed users', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2156, 'english', 'Show only', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2157, 'english', 'Status of users to import', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2158, 'english', 'Confirmation text (will be sent to the user)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2159, 'english', 'Not acceptance text (will be sent to the user)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2160, 'english', 'List of selected user, choose a level', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2161, 'english', 'List of users waiting for the approval', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2162, 'english', 'User is busy in the same period', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2163, 'english', 'Overbooking', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2164, 'english', 'Detailes of subscriptions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2165, 'english', 'Valid at date', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2166, 'english', 'Do nothing', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2167, 'english', 'You can subscribe only [user_subscribe_limit] before reach your subscrition limit', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2168, 'english', 'New message', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2169, 'english', 'This message has been locked', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2170, 'english', 'Lock message', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2171, 'english', 'Popular', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2172, 'english', 'Use commas to separate tags.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2173, 'english', 'Yours', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2174, 'english', 'All difficulties', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2175, 'english', 'Any category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2176, 'english', 'All types', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2177, 'english', 'Bonus assigned for this test (with round or manual modification)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2178, 'english', 'Selected answer', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2179, 'english', 'Deselect page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2180, 'english', 'Empty answer', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2181, 'english', 'Feedback management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2182, 'english', 'Textual feedback', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2183, 'english', 'GIFT', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2184, 'english', 'Hard', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2185, 'english', 'Ask the user to answer all questions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2186, 'english', 'Maximum number of attempts to answer the test (set 0 for no limits)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2187, 'english', 'You must answer all questions to proceed with the test.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2188, 'english', 'Assign new score for this question', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2189, 'english', 'As a new test', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2190, 'english', 'Random choice per category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2191, 'english', '(sub-group of question)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2192, 'english', 'Question', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2193, 'english', 'AS', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2194, 'english', 'BR', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2195, 'english', 'SC', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2196, 'english', 'MC', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2197, 'english', 'ET', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2198, 'english', 'HT', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2199, 'english', 'IC', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2200, 'english', 'TE', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2201, 'english', 'TL', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2202, 'english', 'UP', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2203, 'english', 'Answer...', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2204, 'english', 'Association', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2205, 'english', 'Break page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2206, 'english', 'Single Choice', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2207, 'english', 'Multiple Choice', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2208, 'english', 'Extended Text', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2209, 'english', 'Write here...', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2210, 'english', 'Hot Text (find the wrong word)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2211, 'english', 'write [answerN]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2212, 'english', 'Inline Choice', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2213, 'english', 'Students can anwser using a select menu that appears in the position of [anwser] tag', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2214, 'english', 'No errors', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2215, 'english', 'Reference tag', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2216, 'english', 'Text Entry', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2217, 'english', 'Answer Here', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2218, 'english', 'Title (no answer)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2219, 'english', 'Difference with previous time: [time_difference]', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2220, 'english', 'Difference between previous total score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2221, 'english', 'Set difficult', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2222, 'english', 'Set score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2223, 'english', 'Set time:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2224, 'english', 'Upload file', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2225, 'english', 'Select page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2226, 'english', 'Suspend the test after the following number of failed attempts', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2227, 'english', 'Suspend the test for the following number of hours', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2228, 'english', 'After the test suspension, require a new completion of all the test prerequisites', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2229, 'english', 'Add question', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2230, 'english', 'Description is shown to students before attempting the test', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2231, 'english', 'Add one more anwser', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2232, 'english', 'after row', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2233, 'english', 'Answers :', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2234, 'english', 'Selected', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2235, 'english', 'Not selected', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2236, 'english', 'Correct association', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2237, 'english', 'Back to score administration page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2238, 'english', 'Click to begin', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2239, 'english', 'You can jump to the next or previous page (if the test has multiple pages)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2240, 'english', 'You can <b>not</b> jump to the next or previous page (if the test has multiple pages)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2241, 'english', 'Complete list of questions available in the test. ( %tot_element% elements in %tot_page% pages)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2242, 'english', 'Time administration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2243, 'english', 'Test completed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2244, 'english', 'Resume the test', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2245, 'english', 'Correct', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2246, 'english', 'OK', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2247, 'english', 'Submit (test completed)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2248, 'english', 'Not passed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2249, 'english', 'You didn''t upload any file', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2250, 'english', 'as first', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2251, 'english', 'Select answer', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2252, 'english', 'If correct', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2253, 'english', 'If wrong', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2254, 'english', 'Wrong', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2255, 'english', 'Information about the test', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2256, 'english', 'New Test', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2257, 'english', 'Correct anwser', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2258, 'english', 'the right answer is:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2259, 'english', ', was the right choiche', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2260, 'english', 'as last', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2261, 'english', 'Some questions need instructor''s grading. Your score could increase of:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2262, 'english', 'Max Score: <b>[max_score]</b>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2263, 'english', 'Answers view', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2264, 'english', 'Random (if allowed by question type)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2265, 'english', 'Arrange in sequence', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2266, 'english', 'Show questions grouped in one or more pages (clustering by break pages)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2267, 'english', 'show one question per page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2268, 'english', 'Random choice of [random_quest] questions on  <b>[tot_quest]</b> available.', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2269, 'english', '(All questions) Random (clustering by break page)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2270, 'english', '(All questions) Arranged in sequence', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2271, 'english', 'Allow backtracking (button Previous Page active)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2272, 'english', 'Hide info for test in use', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2273, 'english', 'Allow answers edit', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2274, 'english', 'Allow attempts in more sessions (saving questions answered)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2275, 'english', 'Show score grouped by question category (if it''s calculable)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2276, 'english', 'Show all the answers inserted by user', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2277, 'english', 'Show correct answers', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2278, 'english', 'Show final score (if it''s calculable)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2279, 'english', '3 - Details shown at the end of attempt', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2280, 'english', '1 - set questions visualization', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2281, 'english', '2-  set attempts option', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2282, 'english', 'Test options', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2283, 'english', 'You can edit the answer', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2284, 'english', 'You <span class="text_bold">can''t</span>  edit the answer', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2285, 'english', 'row', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2286, 'english', 'Next page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2287, 'english', 'the correct answer is', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2288, 'english', 'is wrong', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2289, 'english', 'is wrong', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2290, 'english', 'Right answer', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2291, 'english', 'Page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2292, 'english', 'Express score as percentage', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2293, 'english', 'Express score as points', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2294, 'english', 'Min score required to pass the test', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2295, 'english', 'Different amount based on question difficulty', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2296, 'english', 'Same point for each question (total score/number of question)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2297, 'english', 'Choose score for every question', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2298, 'english', '1 - set final score calculation', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2299, 'english', 'Set score preferences', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2300, 'english', 'Distributed by', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2301, 'english', '2 - Set score for each question', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2302, 'english', 'Administration points', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2303, 'english', 'Points Management', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2304, 'english', 'Previous page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2305, 'english', 'The test has <b>[question_number]</b> questions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2306, 'english', 'Question category', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2307, 'english', 'element', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2308, 'english', 'Group A elements', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2309, 'english', 'Group B elements', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2310, 'english', 'N. elements', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2311, 'english', 'Maximum test score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2312, 'english', 'New max score', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2313, 'english', 'Order', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2314, 'english', 'Next (set right associations)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2315, 'english', 'Max answer time', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2316, 'english', 'Time assigned (seconds)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2317, 'english', 'Pass mark: <b>[score_req]</b>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2318, 'english', 'Pass Mark:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2319, 'english', 'Restart test', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2320, 'english', 'Show your answers', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2321, 'english', 'For this test there is an outstanding compilation: do you want to resume or to do it again?', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2322, 'english', 'You can save and resume test later', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2323, 'english', 'Back to course', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2324, 'english', 'Back to test', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2325, 'english', 'Test must be completed now. It <span class="text_bold">cannot</span> be resumed later', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2326, 'english', 'Save test, you can resume later', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2327, 'english', 'Points', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2328, 'english', 'Test', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2329, 'english', 'Choose answers from library', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2330, 'english', 'Show last results', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2331, 'english', 'Final score will be shown after the test completion', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2332, 'english', 'Final score will not be shown after the test completion', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2333, 'english', 'Solutions will be shown after the test completion', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2334, 'english', 'You <span class="text_bold">can''t</span> know the right answer to questions after completing the test', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2335, 'english', 'Remove last answer', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2336, 'english', 'Test question list', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2337, 'english', 'answer text', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2338, 'english', 'Choose the right word', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2339, 'english', 'Test time limit : <b>[time_assigned] minutes</b>', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2340, 'english', '<span class="text_bold">No</span> time limits', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2341, 'english', 'A time limit is defined for each question', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2342, 'english', 'Admin Attempting time', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2343, 'english', 'No time limit', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2344, 'english', 'Time limit, test based', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2345, 'english', 'Time limit question based; every question has a specific time limit', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2346, 'english', 'Test time limited', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2347, 'english', 'Set difficulty and score for each question', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2348, 'english', 'same time for each question (total time/number of question)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2349, 'english', 'Choose a time limit for answering each question', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2350, 'english', 'New total time', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2351, 'english', 'New total time :', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2352, 'english', 'penalty if question time limit has been exceeded', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2353, 'english', 'penalty if total time limit has been exceeded', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2354, 'english', 'Apply changes', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2355, 'english', 'Apply and Set time', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2356, 'english', 'Distributed by:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2357, 'english', 'Set time assigned to the questions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2358, 'english', '1 - set Test time', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2359, 'english', 'Set time for each question', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2360, 'english', '2 - Set total time for attempting', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2361, 'english', 'Total score:', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2362, 'english', 'This test does not support the action required', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2363, 'english', 'Time elapsed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2364, 'english', 'Time left', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2365, 'english', 'Use test suspension', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2366, 'english', 'Very hard', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2367, 'english', 'Yes, if the test has been passed', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2368, 'english', 'Mark as paid', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2369, 'english', 'Price', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2370, 'english', 'Set as not paid', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2371, 'english', 'Empty', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2372, 'english', 'Don''t use self registration in the organizational tree', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2373, 'english', 'Login/registration options', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2374, 'english', 'No selections have been made', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2375, 'english', 'You have failed to log in for [attempt] times, for security reasons wait [time] minutes before trying again', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2376, 'english', 'Only by administrator', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2377, 'english', 'Moderated self registration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2378, 'english', 'Free self registration', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2379, 'english', 'Subscription code inserted manually', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2380, 'english', 'Subscription code chosen from a dropdown menu', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2381, 'english', 'Add wiki', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2382, 'english', 'Go to this page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2383, 'english', 'View page revision', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2384, 'english', 'Compare selected versions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2385, 'english', 'Export selected pages', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2386, 'english', 'To create a new page and link write  [[page|title]] or only [[page]] if title and name are the same', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2387, 'english', 'Index', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2388, 'english', 'Level up', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2389, 'english', 'Map', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2390, 'english', 'Other language', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2391, 'english', 'Page', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2392, 'english', 'Please specify some text to search (at least 3 characters)', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2393, 'english', 'Revisions', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2394, 'english', 'Select a wiki', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2395, 'english', 'choose a wiki', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2396, 'english', 'Wiki', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2397, 'english', 'Index', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2398, 'english', 'WARNING: if you proceed with SAVE, this page will become the last version', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2399, 'english', 'default language', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2400, 'english', 'Level up', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2401, 'english', 'select other languages for pages', '[[regtime]]');
INSERT INTO `core_lang_translation` VALUES(2402, 'english', 'Prev.', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `core_menu`
--

CREATE TABLE `core_menu` (
  `idMenu` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL DEFAULT '',
  `sequence` int(3) NOT NULL DEFAULT '0',
  `collapse` enum('true','false') NOT NULL DEFAULT 'false',
  PRIMARY KEY (`idMenu`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `core_menu`
--

INSERT INTO `core_menu` VALUES(1, '', '', 1, 'true');
INSERT INTO `core_menu` VALUES(2, '_USER_MANAGMENT', '', 2, 'false');
INSERT INTO `core_menu` VALUES(3, '_TRASV_MANAGMENT', '', 3, 'false');
INSERT INTO `core_menu` VALUES(4, '_ADMINISTRATORS', '', 4, 'false');
INSERT INTO `core_menu` VALUES(5, '_LANGUAGE', '', 5, 'false');
INSERT INTO `core_menu` VALUES(6, '', '', 6, 'true');

-- --------------------------------------------------------

--
-- Table structure for table `core_menu_under`
--

CREATE TABLE `core_menu_under` (
  `idUnder` int(11) NOT NULL AUTO_INCREMENT,
  `idMenu` int(11) NOT NULL DEFAULT '0',
  `module_name` varchar(255) NOT NULL DEFAULT '',
  `default_name` varchar(255) NOT NULL DEFAULT '',
  `default_op` varchar(255) NOT NULL DEFAULT '',
  `associated_token` varchar(255) NOT NULL DEFAULT '',
  `of_platform` varchar(255) DEFAULT NULL,
  `sequence` int(3) NOT NULL DEFAULT '0',
  `class_file` varchar(255) NOT NULL DEFAULT '',
  `class_name` varchar(255) NOT NULL DEFAULT '',
  `mvc_path` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`idUnder`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=26 ;

--
-- Dumping data for table `core_menu_under`
--

INSERT INTO `core_menu_under` VALUES(1, 1, 'dashboard', '_DASHBOARD', '', 'view', NULL, 1, '', '', 'adm/dashboard/show');
INSERT INTO `core_menu_under` VALUES(3, 2, 'groupmanagement', '_MANAGE_GROUPS', '', 'view', NULL, 2, '', '', 'adm/groupmanagement/show');
INSERT INTO `core_menu_under` VALUES(4, 3, 'field_manager', '_FIELD_MANAGER', 'field_list', 'view', NULL, 3, 'class.field_manager.php', 'Module_Field_Manager', '');
INSERT INTO `core_menu_under` VALUES(5, 3, 'setting', '_CONFIGURATION', '', 'view', NULL, 1, 'class.configuration.php', 'Module_Configuration', 'adm/setting/show');
INSERT INTO `core_menu_under` VALUES(7, 3, 'event_manager', '_EVENTMANAGER', 'display', 'view_event_manager', NULL, 3, 'class.event_manager.php', 'Module_Event_Manager', '');
INSERT INTO `core_menu_under` VALUES(8, 3, 'iotask', '_IOTASK', 'iotask', 'view', NULL, 4, 'class.iotask.php', 'Module_IOTask', '');
INSERT INTO `core_menu_under` VALUES(10, 5, 'lang', '_LANG', '', 'view', NULL, 1, '', '', 'adm/lang/show');
INSERT INTO `core_menu_under` VALUES(13, 6, 'newsletter', '_NEWSLETTER', 'newsletter', 'view', NULL, 1, 'class.newsletter.php', 'Module_Newsletter', '');
INSERT INTO `core_menu_under` VALUES(16, 2, 'usermanagement', '_LISTUSER', '', 'view', NULL, 1, '', '', 'adm/usermanagement/show');
INSERT INTO `core_menu_under` VALUES(18, 4, 'adminrules', '_ADMIN_RULES', '', 'view', NULL, 1, '', '', 'adm/adminrules/show');
INSERT INTO `core_menu_under` VALUES(19, 4, 'publicadminrules', '_PUBLIC_ADMIN_RULES', '', 'view', NULL, 1, '', '', 'adm/publicadminrules/show');
INSERT INTO `core_menu_under` VALUES(20, 4, 'adminmanager', '_ADMIN_MANAGER', '', 'view', NULL, 1, '', '', 'adm/adminmanager/show');
INSERT INTO `core_menu_under` VALUES(21, 4, 'publicadminmanager', '_PUBLIC_ADMIN_MANAGER', '', 'view', NULL, 1, '', '', 'adm/publicadminmanager/show');
INSERT INTO `core_menu_under` VALUES(22, 2, 'functionalroles', '_FUNCTIONAL_ROLE', '', 'view', NULL, 4, '', '', 'adm/functionalroles/show');
INSERT INTO `core_menu_under` VALUES(23, 2, 'competences', '_COMPETENCES', '', 'view', NULL, 3, '', '', 'adm/competences/show');
INSERT INTO `core_menu_under` VALUES(24, 3, 'code', '_CODE', 'list', 'view', NULL, 5, 'class.code.php', 'Module_Code', '');
INSERT INTO `core_menu_under` VALUES(25, 3, 'privacypolicy', '_PRIVACYPOLICIES', '', 'view', NULL, 6, '', '', 'adm/privacypolicy/show');

-- --------------------------------------------------------

--
-- Table structure for table `core_message`
--

CREATE TABLE `core_message` (
  `idMessage` int(11) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `sender` int(11) NOT NULL DEFAULT '0',
  `posted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `title` varchar(255) NOT NULL DEFAULT '',
  `textof` text NOT NULL,
  `attach` varchar(255) NOT NULL DEFAULT '',
  `priority` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idMessage`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_message`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_message_user`
--

CREATE TABLE `core_message_user` (
  `idMessage` int(11) NOT NULL DEFAULT '0',
  `idUser` int(11) NOT NULL DEFAULT '0',
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `read` tinyint(1) NOT NULL DEFAULT '0',
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idMessage`,`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_message_user`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_newsletter`
--

CREATE TABLE `core_newsletter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_send` int(11) NOT NULL DEFAULT '0',
  `sub` varchar(255) NOT NULL DEFAULT '',
  `msg` text NOT NULL,
  `fromemail` varchar(255) NOT NULL DEFAULT '',
  `language` varchar(255) NOT NULL DEFAULT '',
  `tot` int(11) NOT NULL DEFAULT '0',
  `send_type` enum('email','sms') NOT NULL DEFAULT 'email',
  `stime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `file` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_newsletter`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_newsletter_sendto`
--

CREATE TABLE `core_newsletter_sendto` (
  `id_send` int(11) NOT NULL DEFAULT '0',
  `idst` int(11) NOT NULL DEFAULT '0',
  `stime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_send`,`idst`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_newsletter_sendto`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_org_chart`
--

CREATE TABLE `core_org_chart` (
  `id_dir` int(11) NOT NULL DEFAULT '0',
  `lang_code` varchar(50) NOT NULL DEFAULT '',
  `translation` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_dir`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_org_chart`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_org_chart_field`
--

CREATE TABLE `core_org_chart_field` (
  `idst` int(11) NOT NULL DEFAULT '0',
  `id_field` varchar(11) NOT NULL DEFAULT '0',
  `mandatory` enum('true','false') NOT NULL DEFAULT 'false',
  `useraccess` enum('readonly','readwrite','noaccess') NOT NULL DEFAULT 'readonly',
  PRIMARY KEY (`idst`,`id_field`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_org_chart_field`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_org_chart_fieldentry`
--

CREATE TABLE `core_org_chart_fieldentry` (
  `id_common` varchar(11) NOT NULL DEFAULT '',
  `id_common_son` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `user_entry` text NOT NULL,
  PRIMARY KEY (`id_common`,`id_common_son`,`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_org_chart_fieldentry`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_org_chart_tree`
--

CREATE TABLE `core_org_chart_tree` (
  `idOrg` int(11) NOT NULL AUTO_INCREMENT,
  `idParent` int(11) NOT NULL DEFAULT '0',
  `path` text NOT NULL,
  `lev` int(3) NOT NULL DEFAULT '0',
  `iLeft` int(5) NOT NULL DEFAULT '0',
  `iRight` int(5) NOT NULL DEFAULT '0',
  `code` varchar(255) NOT NULL DEFAULT '',
  `idst_oc` int(11) NOT NULL DEFAULT '0',
  `idst_ocd` int(11) NOT NULL DEFAULT '0',
  `associated_policy` int(11) unsigned DEFAULT NULL,
  `associated_template` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`idOrg`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_org_chart_tree`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_password_history`
--

CREATE TABLE `core_password_history` (
  `idst_user` int(11) NOT NULL DEFAULT '0',
  `pwd_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `passw` varchar(100) NOT NULL DEFAULT '',
  `changed_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idst_user`,`pwd_date`),
  KEY `pwd_date` (`pwd_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_password_history`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_platform`
--

CREATE TABLE `core_platform` (
  `platform` varchar(255) NOT NULL DEFAULT '',
  `class_file` varchar(255) NOT NULL DEFAULT '',
  `class_name` varchar(255) NOT NULL DEFAULT '',
  `class_file_menu` varchar(255) NOT NULL DEFAULT '',
  `class_name_menu` varchar(255) NOT NULL DEFAULT '',
  `class_name_menu_managment` varchar(255) NOT NULL DEFAULT '',
  `file_class_config` varchar(255) NOT NULL DEFAULT '',
  `class_name_config` varchar(255) NOT NULL DEFAULT '',
  `var_default_template` varchar(255) NOT NULL DEFAULT '',
  `class_default_admin` varchar(255) NOT NULL DEFAULT '',
  `sequence` int(3) NOT NULL DEFAULT '0',
  `is_active` enum('true','false') NOT NULL DEFAULT 'true',
  `mandatory` enum('true','false') NOT NULL DEFAULT 'true',
  `dependencies` text NOT NULL,
  `main` enum('true','false') NOT NULL DEFAULT 'true',
  `hidden_in_config` enum('true','false') NOT NULL DEFAULT 'false',
  PRIMARY KEY (`platform`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_platform`
--

INSERT INTO `core_platform` VALUES('framework', '', '', 'class.admin_menu_fw.php', 'Admin_Framework', 'Admin_Managment_Framework', 'class.conf_fw.php', 'Config_Framework', 'defaultTemplate', 'Module', 1, 'true', 'true', '', 'false', 'false');
INSERT INTO `core_platform` VALUES('lms', '', '', 'class.admin_menu_lms.php', 'Admin_Lms', 'Admin_Managment_Lms', 'class.conf_lms.php', 'Config_Lms', 'defaultTemplate', 'LmsAdminModule', 2, 'true', 'false', '', 'true', 'false');
INSERT INTO `core_platform` VALUES('scs', '', '', 'class.admin_menu_scs.php', 'Admin_Scs', '', 'class.conf_scs.php', 'Config_Scs', 'defaultTemplate', 'ScsAdminModule', 4, 'true', 'false', '', 'false', 'false');

-- --------------------------------------------------------

--
-- Table structure for table `core_privacypolicy`
--

CREATE TABLE `core_privacypolicy` (
  `id_policy` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_policy`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_privacypolicy`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_privacypolicy_lang`
--

CREATE TABLE `core_privacypolicy_lang` (
  `id_policy` int(11) unsigned NOT NULL DEFAULT '0',
  `lang_code` varchar(255) NOT NULL DEFAULT '',
  `translation` text NOT NULL,
  PRIMARY KEY (`id_policy`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_privacypolicy_lang`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_pwd_recover`
--

CREATE TABLE `core_pwd_recover` (
  `idst_user` int(11) NOT NULL DEFAULT '0',
  `random_code` varchar(255) NOT NULL DEFAULT '',
  `request_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`idst_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_pwd_recover`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_reg_list`
--

CREATE TABLE `core_reg_list` (
  `region_id` varchar(100) NOT NULL DEFAULT '',
  `lang_code` varchar(50) NOT NULL DEFAULT '',
  `region_desc` varchar(255) NOT NULL DEFAULT '',
  `default_region` tinyint(1) NOT NULL DEFAULT '0',
  `browsercode` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`region_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_reg_list`
--

INSERT INTO `core_reg_list` VALUES('england', 'english', 'england, usa, ...', 0, 'en-EN, en-US');
INSERT INTO `core_reg_list` VALUES('italy', 'italian', 'Italia', 1, 'it');

-- --------------------------------------------------------

--
-- Table structure for table `core_reg_setting`
--

CREATE TABLE `core_reg_setting` (
  `region_id` varchar(100) NOT NULL DEFAULT '',
  `val_name` varchar(100) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`region_id`,`val_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_reg_setting`
--

INSERT INTO `core_reg_setting` VALUES('england', 'custom_date_format', '');
INSERT INTO `core_reg_setting` VALUES('england', 'custom_time_format', '');
INSERT INTO `core_reg_setting` VALUES('england', 'date_format', 'd_m_Y');
INSERT INTO `core_reg_setting` VALUES('england', 'date_sep', '/');
INSERT INTO `core_reg_setting` VALUES('england', 'time_format', 'H_i');
INSERT INTO `core_reg_setting` VALUES('italy', 'custom_date_format', '');
INSERT INTO `core_reg_setting` VALUES('italy', 'custom_time_format', '');
INSERT INTO `core_reg_setting` VALUES('italy', 'date_format', 'd_m_Y');
INSERT INTO `core_reg_setting` VALUES('italy', 'date_sep', '-');
INSERT INTO `core_reg_setting` VALUES('italy', 'time_format', 'H_i');

-- --------------------------------------------------------

--
-- Table structure for table `core_rest_authentication`
--

CREATE TABLE `core_rest_authentication` (
  `id_user` int(11) NOT NULL DEFAULT '0',
  `user_level` int(11) NOT NULL DEFAULT '0',
  `token` varchar(255) NOT NULL DEFAULT '',
  `generation_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_enter_date` datetime DEFAULT NULL,
  `expiry_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_rest_authentication`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_revision`
--

CREATE TABLE `core_revision` (
  `type` enum('wiki','faq') NOT NULL DEFAULT 'faq',
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `version` int(11) NOT NULL DEFAULT '0',
  `sub_key` varchar(80) NOT NULL DEFAULT '0',
  `author` int(11) NOT NULL DEFAULT '0',
  `rev_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `content` longtext NOT NULL,
  PRIMARY KEY (`type`,`parent_id`,`version`,`sub_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_revision`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_role`
--

CREATE TABLE `core_role` (
  `idst` int(11) NOT NULL DEFAULT '0',
  `roleid` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`idst`),
  KEY `roleid` (`roleid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 PACK_KEYS=0;

--
-- Dumping data for table `core_role`
--

INSERT INTO `core_role` VALUES(7, '/framework/admin/adminmanager/mod', NULL);
INSERT INTO `core_role` VALUES(8, '/framework/admin/adminmanager/view', NULL);
INSERT INTO `core_role` VALUES(9, '/framework/admin/adminrules/view', NULL);
INSERT INTO `core_role` VALUES(10, '/framework/admin/dashboard/view', NULL);
INSERT INTO `core_role` VALUES(11, '/framework/admin/dashboard/view', NULL);
INSERT INTO `core_role` VALUES(12, '/framework/admin/directory/approve_waiting_user', NULL);
INSERT INTO `core_role` VALUES(13, '/framework/admin/event_manager/view_event_manager', NULL);
INSERT INTO `core_role` VALUES(14, '/framework/admin/field_manager/add', NULL);
INSERT INTO `core_role` VALUES(15, '/framework/admin/field_manager/del', NULL);
INSERT INTO `core_role` VALUES(16, '/framework/admin/field_manager/mod', NULL);
INSERT INTO `core_role` VALUES(17, '/framework/admin/field_manager/view', NULL);
INSERT INTO `core_role` VALUES(18, '/framework/admin/groupmanagement/add', NULL);
INSERT INTO `core_role` VALUES(19, '/framework/admin/groupmanagement/associate_user', NULL);
INSERT INTO `core_role` VALUES(20, '/framework/admin/groupmanagement/del', NULL);
INSERT INTO `core_role` VALUES(21, '/framework/admin/groupmanagement/mod', NULL);
INSERT INTO `core_role` VALUES(22, '/framework/admin/groupmanagement/view', NULL);
INSERT INTO `core_role` VALUES(23, '/framework/admin/iotask/view', NULL);
INSERT INTO `core_role` VALUES(24, '/framework/admin/kb/mod', NULL);
INSERT INTO `core_role` VALUES(25, '/framework/admin/kb/view', NULL);
INSERT INTO `core_role` VALUES(26, '/framework/admin/lang/mod', NULL);
INSERT INTO `core_role` VALUES(27, '/framework/admin/lang/view', NULL);
INSERT INTO `core_role` VALUES(28, '/framework/admin/newsletter/view', NULL);
INSERT INTO `core_role` VALUES(29, '/framework/admin/publicadminmanager/mod', NULL);
INSERT INTO `core_role` VALUES(30, '/framework/admin/publicadminmanager/view', NULL);
INSERT INTO `core_role` VALUES(31, '/framework/admin/usermanagement/add', NULL);
INSERT INTO `core_role` VALUES(32, '/framework/admin/usermanagement/approve_waiting_user', NULL);
INSERT INTO `core_role` VALUES(33, '/framework/admin/usermanagement/del', NULL);
INSERT INTO `core_role` VALUES(34, '/framework/admin/usermanagement/mod', NULL);
INSERT INTO `core_role` VALUES(35, '/framework/admin/usermanagement/view', NULL);
INSERT INTO `core_role` VALUES(36, '/lms/admin/amanmenu/mod', NULL);
INSERT INTO `core_role` VALUES(37, '/lms/admin/amanmenu/view', NULL);
INSERT INTO `core_role` VALUES(38, '/lms/admin/catalogue/mod', NULL);
INSERT INTO `core_role` VALUES(39, '/lms/admin/catalogue/view', NULL);
INSERT INTO `core_role` VALUES(40, '/lms/admin/certificate/mod', NULL);
INSERT INTO `core_role` VALUES(41, '/lms/admin/certificate/view', NULL);
INSERT INTO `core_role` VALUES(42, '/lms/admin/classroom/view', NULL);
INSERT INTO `core_role` VALUES(43, '/lms/admin/communication/mod', NULL);
INSERT INTO `core_role` VALUES(44, '/lms/admin/communication/view', NULL);
INSERT INTO `core_role` VALUES(45, '/lms/admin/course/add', NULL);
INSERT INTO `core_role` VALUES(46, '/lms/admin/course/del', NULL);
INSERT INTO `core_role` VALUES(47, '/lms/admin/course/mod', NULL);
INSERT INTO `core_role` VALUES(48, '/lms/admin/course/moderate', NULL);
INSERT INTO `core_role` VALUES(49, '/lms/admin/course/subscribe', NULL);
INSERT INTO `core_role` VALUES(50, '/lms/admin/course/view', NULL);
INSERT INTO `core_role` VALUES(51, '/lms/admin/coursepath/mod', NULL);
INSERT INTO `core_role` VALUES(52, '/lms/admin/coursepath/moderate', NULL);
INSERT INTO `core_role` VALUES(53, '/lms/admin/coursepath/subscribe', NULL);
INSERT INTO `core_role` VALUES(54, '/lms/admin/coursepath/view', NULL);
INSERT INTO `core_role` VALUES(55, '/lms/admin/enrollrules/view', NULL);
INSERT INTO `core_role` VALUES(56, '/lms/admin/games/mod', NULL);
INSERT INTO `core_role` VALUES(57, '/lms/admin/games/subscribe', NULL);
INSERT INTO `core_role` VALUES(58, '/lms/admin/games/view', NULL);
INSERT INTO `core_role` VALUES(59, '/lms/admin/internal_news/mod', NULL);
INSERT INTO `core_role` VALUES(60, '/lms/admin/internal_news/view', NULL);
INSERT INTO `core_role` VALUES(61, '/lms/admin/kb/view', NULL);
INSERT INTO `core_role` VALUES(62, '/lms/admin/label/view', NULL);
INSERT INTO `core_role` VALUES(63, '/lms/admin/middlearea/view', NULL);
INSERT INTO `core_role` VALUES(64, '/lms/admin/news/mod', NULL);
INSERT INTO `core_role` VALUES(65, '/lms/admin/news/view', NULL);
INSERT INTO `core_role` VALUES(66, '/lms/admin/preassessment/mod', NULL);
INSERT INTO `core_role` VALUES(67, '/lms/admin/preassessment/subscribe', NULL);
INSERT INTO `core_role` VALUES(68, '/lms/admin/preassessment/view', NULL);
INSERT INTO `core_role` VALUES(69, '/lms/admin/questcategory/mod', NULL);
INSERT INTO `core_role` VALUES(70, '/lms/admin/questcategory/view', NULL);
INSERT INTO `core_role` VALUES(71, '/lms/admin/report/mod', NULL);
INSERT INTO `core_role` VALUES(72, '/lms/admin/report/view', NULL);
INSERT INTO `core_role` VALUES(73, '/lms/admin/reservation/mod', NULL);
INSERT INTO `core_role` VALUES(74, '/lms/admin/reservation/view', NULL);
INSERT INTO `core_role` VALUES(75, '/lms/admin/timeperiods/mod', NULL);
INSERT INTO `core_role` VALUES(76, '/lms/admin/timeperiods/view', NULL);
INSERT INTO `core_role` VALUES(77, '/lms/admin/transaction/view', NULL);
INSERT INTO `core_role` VALUES(78, '/lms/admin/webpages/mod', NULL);
INSERT INTO `core_role` VALUES(79, '/lms/admin/webpages/view', NULL);
INSERT INTO `core_role` VALUES(80, '/lms/course/public/course/view', NULL);
INSERT INTO `core_role` VALUES(81, '/lms/course/public/course_autoregistration/view', NULL);
INSERT INTO `core_role` VALUES(82, '/lms/course/public/coursecatalogue/view', NULL);
INSERT INTO `core_role` VALUES(83, '/lms/course/public/message/send_all', NULL);
INSERT INTO `core_role` VALUES(84, '/lms/course/public/message/view', NULL);
INSERT INTO `core_role` VALUES(85, '/lms/course/public/mycertificate/view', NULL);
INSERT INTO `core_role` VALUES(86, '/lms/course/public/mycompetences/view', NULL);
INSERT INTO `core_role` VALUES(87, '/lms/course/public/mygroup/view', NULL);
INSERT INTO `core_role` VALUES(88, '/lms/course/public/profile/mod', NULL);
INSERT INTO `core_role` VALUES(89, '/lms/course/public/profile/view', NULL);
INSERT INTO `core_role` VALUES(90, '/lms/course/public/tprofile/view', NULL);
INSERT INTO `core_role` VALUES(91, '/lms/course/public/public_forum/view', NULL);
INSERT INTO `core_role` VALUES(92, '/lms/course/public/public_forum/add', NULL);
INSERT INTO `core_role` VALUES(93, '/lms/course/public/public_forum/del', NULL);
INSERT INTO `core_role` VALUES(94, '/lms/course/public/public_forum/mod', NULL);
INSERT INTO `core_role` VALUES(95, '/lms/course/public/public_forum/moderate', NULL);
INSERT INTO `core_role` VALUES(96, '/lms/course/public/public_forum/upload', NULL);
INSERT INTO `core_role` VALUES(97, '/lms/course/public/public_forum/write', NULL);
INSERT INTO `core_role` VALUES(98, '/lms/course/public/pcourse/add', NULL);
INSERT INTO `core_role` VALUES(99, '/lms/course/public/pcourse/del', NULL);
INSERT INTO `core_role` VALUES(100, '/lms/course/public/pcourse/mod', NULL);
INSERT INTO `core_role` VALUES(101, '/lms/course/public/pcourse/moderate', NULL);
INSERT INTO `core_role` VALUES(102, '/lms/course/public/pcourse/subscribe', NULL);
INSERT INTO `core_role` VALUES(103, '/lms/course/public/pcourse/view', NULL);
INSERT INTO `core_role` VALUES(104, '/lms/course/public/public_newsletter_admin/view', NULL);
INSERT INTO `core_role` VALUES(105, '/lms/course/public/public_report_admin/view', NULL);
INSERT INTO `core_role` VALUES(106, '/lms/course/public/public_subscribe_admin/approve_waiting_user', NULL);
INSERT INTO `core_role` VALUES(107, '/lms/course/public/public_subscribe_admin/createuser_org_chart', NULL);
INSERT INTO `core_role` VALUES(108, '/lms/course/public/public_subscribe_admin/deluser_org_chart', NULL);
INSERT INTO `core_role` VALUES(109, '/lms/course/public/public_subscribe_admin/edituser_org_chart', NULL);
INSERT INTO `core_role` VALUES(110, '/lms/course/public/public_subscribe_admin/view_org_chart', NULL);
INSERT INTO `core_role` VALUES(111, '/framework/admin/functionalroles/view', NULL);
INSERT INTO `core_role` VALUES(112, '/framework/admin/functionalroles/mod', NULL);
INSERT INTO `core_role` VALUES(113, '/framework/admin/functionalroles/associate_user', NULL);
INSERT INTO `core_role` VALUES(114, '/framework/admin/competences/view', NULL);
INSERT INTO `core_role` VALUES(115, '/framework/admin/competences/mod', NULL);
INSERT INTO `core_role` VALUES(116, '/framework/admin/competences/associate_user', NULL);
INSERT INTO `core_role` VALUES(117, '/framework/admin/publicadminrules/view', NULL);
INSERT INTO `core_role` VALUES(118, '/framework/admin/code/view', NULL);
INSERT INTO `core_role` VALUES(119, '/framework/admin/setting/view', NULL);
INSERT INTO `core_role` VALUES(120, '/lms/admin/meta_certificate/view', NULL);
INSERT INTO `core_role` VALUES(121, '/lms/admin/meta_certificate/mod', NULL);
INSERT INTO `core_role` VALUES(122, '/framework/admin/usermanagement/mod_org', NULL);
INSERT INTO `core_role` VALUES(123, '/lms/course/public/pusermanagement/view', NULL);
INSERT INTO `core_role` VALUES(124, '/lms/course/public/pusermanagement/add', NULL);
INSERT INTO `core_role` VALUES(125, '/lms/course/public/pusermanagement/mod', NULL);
INSERT INTO `core_role` VALUES(126, '/lms/course/public/pusermanagement/del', NULL);
INSERT INTO `core_role` VALUES(127, '/lms/course/public/pusermanagement/approve_waiting_user', NULL);
INSERT INTO `core_role` VALUES(175, '/lms/course/private/advice/mod', NULL);
INSERT INTO `core_role` VALUES(176, '/lms/course/private/advice/view', NULL);
INSERT INTO `core_role` VALUES(177, '/lms/course/private/calendar/mod', NULL);
INSERT INTO `core_role` VALUES(178, '/lms/course/private/calendar/personal', NULL);
INSERT INTO `core_role` VALUES(179, '/lms/course/private/calendar/view', NULL);
INSERT INTO `core_role` VALUES(180, '/lms/course/private/chat/view', NULL);
INSERT INTO `core_role` VALUES(181, '/lms/course/private/conference/mod', NULL);
INSERT INTO `core_role` VALUES(182, '/lms/course/private/conference/view', NULL);
INSERT INTO `core_role` VALUES(183, '/lms/course/private/course/mod', NULL);
INSERT INTO `core_role` VALUES(184, '/lms/course/private/course/view', NULL);
INSERT INTO `core_role` VALUES(185, '/lms/course/private/course/view_info', NULL);
INSERT INTO `core_role` VALUES(186, '/lms/course/private/coursereport/mod', NULL);
INSERT INTO `core_role` VALUES(187, '/lms/course/private/coursereport/view', NULL);
INSERT INTO `core_role` VALUES(188, '/lms/course/private/forum/add', NULL);
INSERT INTO `core_role` VALUES(189, '/lms/course/private/forum/del', NULL);
INSERT INTO `core_role` VALUES(190, '/lms/course/private/forum/mod', NULL);
INSERT INTO `core_role` VALUES(191, '/lms/course/private/forum/moderate', NULL);
INSERT INTO `core_role` VALUES(192, '/lms/course/private/forum/upload', NULL);
INSERT INTO `core_role` VALUES(193, '/lms/course/private/forum/view', NULL);
INSERT INTO `core_role` VALUES(194, '/lms/course/private/forum/write', NULL);
INSERT INTO `core_role` VALUES(195, '/lms/course/private/gradebook/view', NULL);
INSERT INTO `core_role` VALUES(196, '/lms/course/private/groups/mod', NULL);
INSERT INTO `core_role` VALUES(197, '/lms/course/private/groups/subscribe', NULL);
INSERT INTO `core_role` VALUES(198, '/lms/course/private/groups/view', NULL);
INSERT INTO `core_role` VALUES(199, '/lms/course/private/htmlfront/mod', NULL);
INSERT INTO `core_role` VALUES(200, '/lms/course/private/htmlfront/view', NULL);
INSERT INTO `core_role` VALUES(201, '/lms/course/private/light_repo/mod', NULL);
INSERT INTO `core_role` VALUES(202, '/lms/course/private/light_repo/view', NULL);
INSERT INTO `core_role` VALUES(203, '/lms/course/private/manmenu/mod', NULL);
INSERT INTO `core_role` VALUES(204, '/lms/course/private/manmenu/view', NULL);
INSERT INTO `core_role` VALUES(205, '/lms/course/private/newsletter/view', NULL);
INSERT INTO `core_role` VALUES(206, '/lms/course/private/notes/view', NULL);
INSERT INTO `core_role` VALUES(207, '/lms/course/private/organization/view', NULL);
INSERT INTO `core_role` VALUES(208, '/lms/course/private/project/add', NULL);
INSERT INTO `core_role` VALUES(209, '/lms/course/private/project/del', NULL);
INSERT INTO `core_role` VALUES(210, '/lms/course/private/project/mod', NULL);
INSERT INTO `core_role` VALUES(211, '/lms/course/private/project/view', NULL);
INSERT INTO `core_role` VALUES(212, '/lms/course/private/quest_bank/mod', NULL);
INSERT INTO `core_role` VALUES(213, '/lms/course/private/quest_bank/view', NULL);
INSERT INTO `core_role` VALUES(214, '/lms/course/private/reservation/mod', NULL);
INSERT INTO `core_role` VALUES(215, '/lms/course/private/reservation/view', NULL);
INSERT INTO `core_role` VALUES(216, '/lms/course/private/statistic/view', NULL);
INSERT INTO `core_role` VALUES(217, '/lms/course/private/stats/view_course', NULL);
INSERT INTO `core_role` VALUES(218, '/lms/course/private/stats/view_user', NULL);
INSERT INTO `core_role` VALUES(219, '/lms/course/private/storage/home', NULL);
INSERT INTO `core_role` VALUES(220, '/lms/course/private/storage/lesson', NULL);
INSERT INTO `core_role` VALUES(221, '/lms/course/private/storage/public', NULL);
INSERT INTO `core_role` VALUES(222, '/lms/course/private/storage/view', NULL);
INSERT INTO `core_role` VALUES(223, '/lms/course/private/wiki/admin', NULL);
INSERT INTO `core_role` VALUES(224, '/lms/course/private/wiki/edit', NULL);
INSERT INTO `core_role` VALUES(225, '/lms/course/private/wiki/view', NULL);
INSERT INTO `core_role` VALUES(226, '/lms/admin/location/view', NULL);
INSERT INTO `core_role` VALUES(227, '/lms/admin/location/mod', NULL);
INSERT INTO `core_role` VALUES(272, '/lms/course/private/coursecharts/view', '');
INSERT INTO `core_role` VALUES(11553, '/framework/admin/usermanagement/associate_user', NULL);
INSERT INTO `core_role` VALUES(11612, '/lms/course/public/pcertificate/view', NULL);
INSERT INTO `core_role` VALUES(11613, '/lms/course/public/pcertificate/mod', NULL);
INSERT INTO `core_role` VALUES(11757, '/lms/course/private/coursestats/view', '');
INSERT INTO `core_role` VALUES(11835, '/lms/course/private/presence/view', '');
INSERT INTO `core_role` VALUES(11836, '/framework/admin/privacypolicy/view', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `core_role_members`
--

CREATE TABLE `core_role_members` (
  `idst` int(11) NOT NULL DEFAULT '0',
  `idstMember` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idst`,`idstMember`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_role_members`
--

INSERT INTO `core_role_members` VALUES(7, 3);
INSERT INTO `core_role_members` VALUES(8, 3);
INSERT INTO `core_role_members` VALUES(9, 3);
INSERT INTO `core_role_members` VALUES(10, 3);
INSERT INTO `core_role_members` VALUES(11, 3);
INSERT INTO `core_role_members` VALUES(12, 3);
INSERT INTO `core_role_members` VALUES(13, 3);
INSERT INTO `core_role_members` VALUES(14, 3);
INSERT INTO `core_role_members` VALUES(15, 3);
INSERT INTO `core_role_members` VALUES(16, 3);
INSERT INTO `core_role_members` VALUES(17, 3);
INSERT INTO `core_role_members` VALUES(18, 3);
INSERT INTO `core_role_members` VALUES(19, 3);
INSERT INTO `core_role_members` VALUES(20, 3);
INSERT INTO `core_role_members` VALUES(21, 3);
INSERT INTO `core_role_members` VALUES(22, 3);
INSERT INTO `core_role_members` VALUES(23, 3);
INSERT INTO `core_role_members` VALUES(24, 3);
INSERT INTO `core_role_members` VALUES(25, 3);
INSERT INTO `core_role_members` VALUES(26, 3);
INSERT INTO `core_role_members` VALUES(27, 3);
INSERT INTO `core_role_members` VALUES(28, 3);
INSERT INTO `core_role_members` VALUES(29, 3);
INSERT INTO `core_role_members` VALUES(30, 3);
INSERT INTO `core_role_members` VALUES(31, 3);
INSERT INTO `core_role_members` VALUES(32, 3);
INSERT INTO `core_role_members` VALUES(33, 3);
INSERT INTO `core_role_members` VALUES(34, 3);
INSERT INTO `core_role_members` VALUES(35, 3);
INSERT INTO `core_role_members` VALUES(36, 3);
INSERT INTO `core_role_members` VALUES(37, 3);
INSERT INTO `core_role_members` VALUES(38, 3);
INSERT INTO `core_role_members` VALUES(39, 3);
INSERT INTO `core_role_members` VALUES(40, 3);
INSERT INTO `core_role_members` VALUES(41, 3);
INSERT INTO `core_role_members` VALUES(42, 3);
INSERT INTO `core_role_members` VALUES(43, 3);
INSERT INTO `core_role_members` VALUES(44, 3);
INSERT INTO `core_role_members` VALUES(45, 3);
INSERT INTO `core_role_members` VALUES(46, 3);
INSERT INTO `core_role_members` VALUES(47, 3);
INSERT INTO `core_role_members` VALUES(48, 3);
INSERT INTO `core_role_members` VALUES(49, 3);
INSERT INTO `core_role_members` VALUES(50, 3);
INSERT INTO `core_role_members` VALUES(51, 3);
INSERT INTO `core_role_members` VALUES(52, 3);
INSERT INTO `core_role_members` VALUES(53, 3);
INSERT INTO `core_role_members` VALUES(54, 3);
INSERT INTO `core_role_members` VALUES(55, 3);
INSERT INTO `core_role_members` VALUES(56, 3);
INSERT INTO `core_role_members` VALUES(57, 3);
INSERT INTO `core_role_members` VALUES(58, 3);
INSERT INTO `core_role_members` VALUES(59, 3);
INSERT INTO `core_role_members` VALUES(60, 3);
INSERT INTO `core_role_members` VALUES(61, 3);
INSERT INTO `core_role_members` VALUES(62, 3);
INSERT INTO `core_role_members` VALUES(63, 3);
INSERT INTO `core_role_members` VALUES(64, 3);
INSERT INTO `core_role_members` VALUES(65, 3);
INSERT INTO `core_role_members` VALUES(66, 3);
INSERT INTO `core_role_members` VALUES(67, 3);
INSERT INTO `core_role_members` VALUES(68, 3);
INSERT INTO `core_role_members` VALUES(69, 3);
INSERT INTO `core_role_members` VALUES(70, 3);
INSERT INTO `core_role_members` VALUES(71, 3);
INSERT INTO `core_role_members` VALUES(72, 3);
INSERT INTO `core_role_members` VALUES(73, 3);
INSERT INTO `core_role_members` VALUES(74, 3);
INSERT INTO `core_role_members` VALUES(75, 3);
INSERT INTO `core_role_members` VALUES(76, 3);
INSERT INTO `core_role_members` VALUES(77, 3);
INSERT INTO `core_role_members` VALUES(78, 3);
INSERT INTO `core_role_members` VALUES(79, 3);
INSERT INTO `core_role_members` VALUES(80, 1);
INSERT INTO `core_role_members` VALUES(81, 1);
INSERT INTO `core_role_members` VALUES(82, 1);
INSERT INTO `core_role_members` VALUES(83, 1);
INSERT INTO `core_role_members` VALUES(84, 1);
INSERT INTO `core_role_members` VALUES(85, 1);
INSERT INTO `core_role_members` VALUES(86, 1);
INSERT INTO `core_role_members` VALUES(87, 1);
INSERT INTO `core_role_members` VALUES(88, 1);
INSERT INTO `core_role_members` VALUES(89, 1);
INSERT INTO `core_role_members` VALUES(90, 1);
INSERT INTO `core_role_members` VALUES(91, 1);
INSERT INTO `core_role_members` VALUES(92, 3);
INSERT INTO `core_role_members` VALUES(93, 3);
INSERT INTO `core_role_members` VALUES(94, 3);
INSERT INTO `core_role_members` VALUES(95, 3);
INSERT INTO `core_role_members` VALUES(96, 1);
INSERT INTO `core_role_members` VALUES(96, 3);
INSERT INTO `core_role_members` VALUES(97, 1);
INSERT INTO `core_role_members` VALUES(97, 3);
INSERT INTO `core_role_members` VALUES(111, 3);
INSERT INTO `core_role_members` VALUES(112, 3);
INSERT INTO `core_role_members` VALUES(113, 3);
INSERT INTO `core_role_members` VALUES(114, 3);
INSERT INTO `core_role_members` VALUES(115, 3);
INSERT INTO `core_role_members` VALUES(116, 3);
INSERT INTO `core_role_members` VALUES(117, 3);
INSERT INTO `core_role_members` VALUES(118, 3);
INSERT INTO `core_role_members` VALUES(119, 3);
INSERT INTO `core_role_members` VALUES(120, 3);
INSERT INTO `core_role_members` VALUES(121, 3);
INSERT INTO `core_role_members` VALUES(122, 3);
INSERT INTO `core_role_members` VALUES(175, 301);
INSERT INTO `core_role_members` VALUES(175, 302);
INSERT INTO `core_role_members` VALUES(175, 303);
INSERT INTO `core_role_members` VALUES(175, 304);
INSERT INTO `core_role_members` VALUES(176, 301);
INSERT INTO `core_role_members` VALUES(176, 302);
INSERT INTO `core_role_members` VALUES(176, 303);
INSERT INTO `core_role_members` VALUES(176, 304);
INSERT INTO `core_role_members` VALUES(176, 305);
INSERT INTO `core_role_members` VALUES(176, 306);
INSERT INTO `core_role_members` VALUES(176, 307);
INSERT INTO `core_role_members` VALUES(177, 301);
INSERT INTO `core_role_members` VALUES(177, 302);
INSERT INTO `core_role_members` VALUES(177, 303);
INSERT INTO `core_role_members` VALUES(177, 304);
INSERT INTO `core_role_members` VALUES(178, 301);
INSERT INTO `core_role_members` VALUES(178, 302);
INSERT INTO `core_role_members` VALUES(178, 303);
INSERT INTO `core_role_members` VALUES(178, 304);
INSERT INTO `core_role_members` VALUES(178, 305);
INSERT INTO `core_role_members` VALUES(179, 301);
INSERT INTO `core_role_members` VALUES(179, 302);
INSERT INTO `core_role_members` VALUES(179, 303);
INSERT INTO `core_role_members` VALUES(179, 304);
INSERT INTO `core_role_members` VALUES(179, 305);
INSERT INTO `core_role_members` VALUES(179, 306);
INSERT INTO `core_role_members` VALUES(179, 307);
INSERT INTO `core_role_members` VALUES(180, 301);
INSERT INTO `core_role_members` VALUES(180, 302);
INSERT INTO `core_role_members` VALUES(180, 303);
INSERT INTO `core_role_members` VALUES(180, 304);
INSERT INTO `core_role_members` VALUES(180, 305);
INSERT INTO `core_role_members` VALUES(181, 301);
INSERT INTO `core_role_members` VALUES(181, 302);
INSERT INTO `core_role_members` VALUES(181, 303);
INSERT INTO `core_role_members` VALUES(181, 304);
INSERT INTO `core_role_members` VALUES(182, 301);
INSERT INTO `core_role_members` VALUES(182, 302);
INSERT INTO `core_role_members` VALUES(182, 303);
INSERT INTO `core_role_members` VALUES(182, 304);
INSERT INTO `core_role_members` VALUES(182, 305);
INSERT INTO `core_role_members` VALUES(182, 306);
INSERT INTO `core_role_members` VALUES(182, 307);
INSERT INTO `core_role_members` VALUES(183, 301);
INSERT INTO `core_role_members` VALUES(183, 302);
INSERT INTO `core_role_members` VALUES(183, 303);
INSERT INTO `core_role_members` VALUES(183, 304);
INSERT INTO `core_role_members` VALUES(185, 301);
INSERT INTO `core_role_members` VALUES(185, 302);
INSERT INTO `core_role_members` VALUES(185, 303);
INSERT INTO `core_role_members` VALUES(185, 304);
INSERT INTO `core_role_members` VALUES(185, 305);
INSERT INTO `core_role_members` VALUES(185, 306);
INSERT INTO `core_role_members` VALUES(185, 307);
INSERT INTO `core_role_members` VALUES(186, 301);
INSERT INTO `core_role_members` VALUES(186, 302);
INSERT INTO `core_role_members` VALUES(186, 303);
INSERT INTO `core_role_members` VALUES(186, 304);
INSERT INTO `core_role_members` VALUES(186, 10893);
INSERT INTO `core_role_members` VALUES(186, 10894);
INSERT INTO `core_role_members` VALUES(186, 10895);
INSERT INTO `core_role_members` VALUES(187, 301);
INSERT INTO `core_role_members` VALUES(187, 302);
INSERT INTO `core_role_members` VALUES(187, 303);
INSERT INTO `core_role_members` VALUES(187, 304);
INSERT INTO `core_role_members` VALUES(187, 10893);
INSERT INTO `core_role_members` VALUES(187, 10894);
INSERT INTO `core_role_members` VALUES(187, 10895);
INSERT INTO `core_role_members` VALUES(187, 10896);
INSERT INTO `core_role_members` VALUES(187, 10897);
INSERT INTO `core_role_members` VALUES(187, 10898);
INSERT INTO `core_role_members` VALUES(187, 10899);
INSERT INTO `core_role_members` VALUES(188, 301);
INSERT INTO `core_role_members` VALUES(188, 302);
INSERT INTO `core_role_members` VALUES(188, 303);
INSERT INTO `core_role_members` VALUES(188, 304);
INSERT INTO `core_role_members` VALUES(189, 301);
INSERT INTO `core_role_members` VALUES(189, 302);
INSERT INTO `core_role_members` VALUES(189, 303);
INSERT INTO `core_role_members` VALUES(189, 304);
INSERT INTO `core_role_members` VALUES(190, 301);
INSERT INTO `core_role_members` VALUES(190, 302);
INSERT INTO `core_role_members` VALUES(190, 303);
INSERT INTO `core_role_members` VALUES(190, 304);
INSERT INTO `core_role_members` VALUES(191, 301);
INSERT INTO `core_role_members` VALUES(191, 302);
INSERT INTO `core_role_members` VALUES(191, 303);
INSERT INTO `core_role_members` VALUES(191, 304);
INSERT INTO `core_role_members` VALUES(192, 301);
INSERT INTO `core_role_members` VALUES(192, 302);
INSERT INTO `core_role_members` VALUES(192, 303);
INSERT INTO `core_role_members` VALUES(192, 304);
INSERT INTO `core_role_members` VALUES(192, 305);
INSERT INTO `core_role_members` VALUES(193, 301);
INSERT INTO `core_role_members` VALUES(193, 302);
INSERT INTO `core_role_members` VALUES(193, 303);
INSERT INTO `core_role_members` VALUES(193, 304);
INSERT INTO `core_role_members` VALUES(193, 305);
INSERT INTO `core_role_members` VALUES(193, 306);
INSERT INTO `core_role_members` VALUES(193, 307);
INSERT INTO `core_role_members` VALUES(194, 301);
INSERT INTO `core_role_members` VALUES(194, 302);
INSERT INTO `core_role_members` VALUES(194, 303);
INSERT INTO `core_role_members` VALUES(194, 304);
INSERT INTO `core_role_members` VALUES(194, 305);
INSERT INTO `core_role_members` VALUES(195, 301);
INSERT INTO `core_role_members` VALUES(195, 302);
INSERT INTO `core_role_members` VALUES(195, 303);
INSERT INTO `core_role_members` VALUES(195, 304);
INSERT INTO `core_role_members` VALUES(195, 305);
INSERT INTO `core_role_members` VALUES(195, 10893);
INSERT INTO `core_role_members` VALUES(195, 10894);
INSERT INTO `core_role_members` VALUES(195, 10895);
INSERT INTO `core_role_members` VALUES(195, 10896);
INSERT INTO `core_role_members` VALUES(195, 10897);
INSERT INTO `core_role_members` VALUES(195, 10898);
INSERT INTO `core_role_members` VALUES(195, 10899);
INSERT INTO `core_role_members` VALUES(196, 301);
INSERT INTO `core_role_members` VALUES(196, 302);
INSERT INTO `core_role_members` VALUES(196, 303);
INSERT INTO `core_role_members` VALUES(196, 304);
INSERT INTO `core_role_members` VALUES(197, 301);
INSERT INTO `core_role_members` VALUES(197, 302);
INSERT INTO `core_role_members` VALUES(197, 303);
INSERT INTO `core_role_members` VALUES(197, 304);
INSERT INTO `core_role_members` VALUES(198, 301);
INSERT INTO `core_role_members` VALUES(198, 302);
INSERT INTO `core_role_members` VALUES(198, 303);
INSERT INTO `core_role_members` VALUES(198, 304);
INSERT INTO `core_role_members` VALUES(201, 301);
INSERT INTO `core_role_members` VALUES(201, 302);
INSERT INTO `core_role_members` VALUES(201, 303);
INSERT INTO `core_role_members` VALUES(201, 304);
INSERT INTO `core_role_members` VALUES(202, 301);
INSERT INTO `core_role_members` VALUES(202, 302);
INSERT INTO `core_role_members` VALUES(202, 303);
INSERT INTO `core_role_members` VALUES(202, 304);
INSERT INTO `core_role_members` VALUES(202, 305);
INSERT INTO `core_role_members` VALUES(205, 301);
INSERT INTO `core_role_members` VALUES(205, 302);
INSERT INTO `core_role_members` VALUES(205, 303);
INSERT INTO `core_role_members` VALUES(205, 304);
INSERT INTO `core_role_members` VALUES(206, 301);
INSERT INTO `core_role_members` VALUES(206, 302);
INSERT INTO `core_role_members` VALUES(206, 303);
INSERT INTO `core_role_members` VALUES(206, 304);
INSERT INTO `core_role_members` VALUES(206, 305);
INSERT INTO `core_role_members` VALUES(206, 306);
INSERT INTO `core_role_members` VALUES(206, 307);
INSERT INTO `core_role_members` VALUES(207, 301);
INSERT INTO `core_role_members` VALUES(207, 302);
INSERT INTO `core_role_members` VALUES(207, 303);
INSERT INTO `core_role_members` VALUES(207, 304);
INSERT INTO `core_role_members` VALUES(207, 305);
INSERT INTO `core_role_members` VALUES(207, 306);
INSERT INTO `core_role_members` VALUES(207, 307);
INSERT INTO `core_role_members` VALUES(207, 10893);
INSERT INTO `core_role_members` VALUES(207, 10894);
INSERT INTO `core_role_members` VALUES(207, 10895);
INSERT INTO `core_role_members` VALUES(207, 10896);
INSERT INTO `core_role_members` VALUES(207, 10897);
INSERT INTO `core_role_members` VALUES(207, 10898);
INSERT INTO `core_role_members` VALUES(208, 301);
INSERT INTO `core_role_members` VALUES(208, 302);
INSERT INTO `core_role_members` VALUES(208, 303);
INSERT INTO `core_role_members` VALUES(208, 304);
INSERT INTO `core_role_members` VALUES(209, 301);
INSERT INTO `core_role_members` VALUES(209, 302);
INSERT INTO `core_role_members` VALUES(209, 303);
INSERT INTO `core_role_members` VALUES(209, 304);
INSERT INTO `core_role_members` VALUES(210, 301);
INSERT INTO `core_role_members` VALUES(210, 302);
INSERT INTO `core_role_members` VALUES(210, 303);
INSERT INTO `core_role_members` VALUES(210, 304);
INSERT INTO `core_role_members` VALUES(211, 301);
INSERT INTO `core_role_members` VALUES(211, 302);
INSERT INTO `core_role_members` VALUES(211, 303);
INSERT INTO `core_role_members` VALUES(211, 304);
INSERT INTO `core_role_members` VALUES(211, 305);
INSERT INTO `core_role_members` VALUES(211, 306);
INSERT INTO `core_role_members` VALUES(211, 307);
INSERT INTO `core_role_members` VALUES(216, 301);
INSERT INTO `core_role_members` VALUES(216, 302);
INSERT INTO `core_role_members` VALUES(216, 303);
INSERT INTO `core_role_members` VALUES(216, 304);
INSERT INTO `core_role_members` VALUES(216, 10893);
INSERT INTO `core_role_members` VALUES(216, 10894);
INSERT INTO `core_role_members` VALUES(216, 10895);
INSERT INTO `core_role_members` VALUES(216, 10896);
INSERT INTO `core_role_members` VALUES(217, 301);
INSERT INTO `core_role_members` VALUES(217, 302);
INSERT INTO `core_role_members` VALUES(217, 303);
INSERT INTO `core_role_members` VALUES(217, 304);
INSERT INTO `core_role_members` VALUES(217, 10893);
INSERT INTO `core_role_members` VALUES(217, 10894);
INSERT INTO `core_role_members` VALUES(217, 10895);
INSERT INTO `core_role_members` VALUES(217, 10896);
INSERT INTO `core_role_members` VALUES(218, 301);
INSERT INTO `core_role_members` VALUES(218, 302);
INSERT INTO `core_role_members` VALUES(218, 303);
INSERT INTO `core_role_members` VALUES(218, 304);
INSERT INTO `core_role_members` VALUES(218, 10893);
INSERT INTO `core_role_members` VALUES(218, 10894);
INSERT INTO `core_role_members` VALUES(218, 10895);
INSERT INTO `core_role_members` VALUES(218, 10896);
INSERT INTO `core_role_members` VALUES(219, 301);
INSERT INTO `core_role_members` VALUES(219, 302);
INSERT INTO `core_role_members` VALUES(219, 10893);
INSERT INTO `core_role_members` VALUES(219, 10894);
INSERT INTO `core_role_members` VALUES(220, 301);
INSERT INTO `core_role_members` VALUES(220, 302);
INSERT INTO `core_role_members` VALUES(220, 303);
INSERT INTO `core_role_members` VALUES(220, 304);
INSERT INTO `core_role_members` VALUES(220, 10893);
INSERT INTO `core_role_members` VALUES(220, 10894);
INSERT INTO `core_role_members` VALUES(220, 10895);
INSERT INTO `core_role_members` VALUES(221, 301);
INSERT INTO `core_role_members` VALUES(221, 302);
INSERT INTO `core_role_members` VALUES(221, 10893);
INSERT INTO `core_role_members` VALUES(221, 10894);
INSERT INTO `core_role_members` VALUES(222, 301);
INSERT INTO `core_role_members` VALUES(222, 302);
INSERT INTO `core_role_members` VALUES(222, 303);
INSERT INTO `core_role_members` VALUES(222, 304);
INSERT INTO `core_role_members` VALUES(222, 10893);
INSERT INTO `core_role_members` VALUES(222, 10894);
INSERT INTO `core_role_members` VALUES(222, 10895);
INSERT INTO `core_role_members` VALUES(223, 301);
INSERT INTO `core_role_members` VALUES(223, 302);
INSERT INTO `core_role_members` VALUES(223, 303);
INSERT INTO `core_role_members` VALUES(223, 304);
INSERT INTO `core_role_members` VALUES(224, 301);
INSERT INTO `core_role_members` VALUES(224, 302);
INSERT INTO `core_role_members` VALUES(224, 303);
INSERT INTO `core_role_members` VALUES(224, 304);
INSERT INTO `core_role_members` VALUES(224, 305);
INSERT INTO `core_role_members` VALUES(225, 301);
INSERT INTO `core_role_members` VALUES(225, 302);
INSERT INTO `core_role_members` VALUES(225, 303);
INSERT INTO `core_role_members` VALUES(225, 304);
INSERT INTO `core_role_members` VALUES(225, 305);
INSERT INTO `core_role_members` VALUES(225, 306);
INSERT INTO `core_role_members` VALUES(225, 307);
INSERT INTO `core_role_members` VALUES(226, 3);
INSERT INTO `core_role_members` VALUES(227, 3);
INSERT INTO `core_role_members` VALUES(272, 301);
INSERT INTO `core_role_members` VALUES(272, 302);
INSERT INTO `core_role_members` VALUES(272, 303);
INSERT INTO `core_role_members` VALUES(272, 304);
INSERT INTO `core_role_members` VALUES(272, 307);
INSERT INTO `core_role_members` VALUES(272, 10893);
INSERT INTO `core_role_members` VALUES(272, 10894);
INSERT INTO `core_role_members` VALUES(272, 10895);
INSERT INTO `core_role_members` VALUES(272, 10896);
INSERT INTO `core_role_members` VALUES(11553, 3);
INSERT INTO `core_role_members` VALUES(11612, 3);
INSERT INTO `core_role_members` VALUES(11613, 3);
INSERT INTO `core_role_members` VALUES(11757, 301);
INSERT INTO `core_role_members` VALUES(11757, 302);
INSERT INTO `core_role_members` VALUES(11757, 303);
INSERT INTO `core_role_members` VALUES(11757, 304);
INSERT INTO `core_role_members` VALUES(11757, 10893);
INSERT INTO `core_role_members` VALUES(11757, 10894);
INSERT INTO `core_role_members` VALUES(11757, 10895);
INSERT INTO `core_role_members` VALUES(11757, 10896);
INSERT INTO `core_role_members` VALUES(11835, 301);
INSERT INTO `core_role_members` VALUES(11835, 302);
INSERT INTO `core_role_members` VALUES(11835, 303);
INSERT INTO `core_role_members` VALUES(11835, 304);
INSERT INTO `core_role_members` VALUES(11836, 3);

-- --------------------------------------------------------

--
-- Table structure for table `core_rules`
--

CREATE TABLE `core_rules` (
  `id_rule` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `lang_code` varchar(255) NOT NULL DEFAULT '',
  `rule_type` varchar(10) NOT NULL DEFAULT '',
  `creation_date` date NOT NULL DEFAULT '0000-00-00',
  `rule_active` tinyint(1) NOT NULL DEFAULT '0',
  `course_list` text NOT NULL,
  PRIMARY KEY (`id_rule`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_rules`
--

INSERT INTO `core_rules` VALUES(0, '', 'all', 'base', '0000-00-00', 1, '');

-- --------------------------------------------------------

--
-- Table structure for table `core_rules_entity`
--

CREATE TABLE `core_rules_entity` (
  `id_rule` int(11) NOT NULL DEFAULT '0',
  `id_entity` varchar(50) NOT NULL DEFAULT '',
  `course_list` text NOT NULL,
  PRIMARY KEY (`id_rule`,`id_entity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_rules_entity`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_rules_log`
--

CREATE TABLE `core_rules_log` (
  `id_log` int(11) NOT NULL AUTO_INCREMENT,
  `log_action` varchar(255) NOT NULL DEFAULT '',
  `log_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `applied` text NOT NULL,
  PRIMARY KEY (`id_log`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_rules_log`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_setting`
--

CREATE TABLE `core_setting` (
  `param_name` varchar(255) NOT NULL DEFAULT '',
  `param_value` text NOT NULL,
  `value_type` varchar(25) NOT NULL DEFAULT 'string',
  `max_size` int(3) NOT NULL DEFAULT '255',
  `pack` varchar(25) NOT NULL DEFAULT 'main',
  `regroup` int(5) NOT NULL DEFAULT '0',
  `sequence` int(5) NOT NULL DEFAULT '0',
  `param_load` tinyint(1) NOT NULL DEFAULT '1',
  `hide_in_modify` tinyint(1) NOT NULL DEFAULT '0',
  `extra_info` text NOT NULL,
  PRIMARY KEY (`param_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_setting`
--

INSERT INTO `core_setting` VALUES('accessibility', 'off', 'enum', 255, '0', 8, 5, 1, 0, '');
INSERT INTO `core_setting` VALUES('code_teleskill', '', 'string', 255, 'teleskill', 6, 3, 1, 0, '');
INSERT INTO `core_setting` VALUES('common_admin_session', 'on', 'enum', 3, 'security', 8, 24, 1, 0, '');
INSERT INTO `core_setting` VALUES('conference_creation_limit_per_user', '99999999999', 'string', 255, '0', 6, 0, 1, 0, '');
INSERT INTO `core_setting` VALUES('core_version', '4.0.5', 'string', 255, '0', 1, 0, 1, 1, '');
INSERT INTO `core_setting` VALUES('course_quota', '0', 'string', 255, '0', 4, 5, 1, 0, '');
INSERT INTO `core_setting` VALUES('currency_symbol', '&euro;', 'string', 10, '0', 5, 2, 1, 0, '');
INSERT INTO `core_setting` VALUES('customer_help_email', '', 'string', 255, '0', 3, 19, 1, 0, '');
INSERT INTO `core_setting` VALUES('customer_help_subj_pfx', '', 'string', 255, '0', 3, 20, 1, 0, '');
INSERT INTO `core_setting` VALUES('defaultTemplate', 'standard', 'template', 255, '0', 1, 4, 1, 0, '');
INSERT INTO `core_setting` VALUES('default_language', 'english', 'language', 255, '0', 1, 3, 1, 0, '');
INSERT INTO `core_setting` VALUES('dimdim_max_mikes', '2', 'string', 255, 'dimdim', 6, 7, 1, 0, '');
INSERT INTO `core_setting` VALUES('dimdim_max_participant', '300', 'string', 255, 'dimdim', 6, 6, 1, 0, '');
INSERT INTO `core_setting` VALUES('dimdim_max_room', '99999999999', 'string', 255, 'dimdim', 6, 5, 1, 0, '');
INSERT INTO `core_setting` VALUES('dimdim_password', '', 'password', 255, 'dimdim', 6, 2, 1, 0, '');
INSERT INTO `core_setting` VALUES('dimdim_port', '80', 'string', 255, 'dimdim', 6, 2, 1, 0, '');
INSERT INTO `core_setting` VALUES('dimdim_server', 'webmeeting.dimdim.com', 'string', 255, 'dimdim', 6, 1, 1, 0, '');
INSERT INTO `core_setting` VALUES('dimdim_user', '', 'string', 255, 'dimdim', 6, 2, 1, 0, '');
INSERT INTO `core_setting` VALUES('do_debug', 'off', 'enum', 3, 'debug', 8, 8, 1, 0, '');
INSERT INTO `core_setting` VALUES('file_upload_whitelist', 'zip,doc,xls,ppt,jpg,gif,png,txt,docx,pptx,xlsx,pdf', 'string', 65535, 'security', 8, 25, 1, 0, '');
INSERT INTO `core_setting` VALUES('first_catalogue', 'off', 'enum', 3, '0', 4, 2, 1, 0, '');
INSERT INTO `core_setting` VALUES('forum_as_table', 'on', 'enum', 3, '0', 4, 4, 1, 0, '');
INSERT INTO `core_setting` VALUES('google_stat_code', '', 'textarea', 65535, '0', 10, 2, 1, 0, '');
INSERT INTO `core_setting` VALUES('google_stat_in_lms', '0', 'check', 1, '0', 10, 1, 1, 0, '');
INSERT INTO `core_setting` VALUES('hour_request_limit', '48', 'int', 2, 'register', 3, 13, 0, 0, '');
INSERT INTO `core_setting` VALUES('hteditor', 'tinymce', 'hteditor', 255, '0', 1, 7, 1, 0, '');
INSERT INTO `core_setting` VALUES('htmledit_image_admin', '1', 'check', 255, '0', 8, 1, 1, 0, '');
INSERT INTO `core_setting` VALUES('htmledit_image_godadmin', '1', 'check', 255, '0', 8, 0, 1, 0, '');
INSERT INTO `core_setting` VALUES('htmledit_image_user', '1', 'check', 255, '0', 8, 2, 1, 0, '');
INSERT INTO `core_setting` VALUES('kb_filter_by_user_access', 'on', 'enum', 3, 'main', 4, 10, 1, 0, '');
INSERT INTO `core_setting` VALUES('kb_show_uncategorized', 'on', 'enum', 3, 'main', 4, 11, 1, 0, '');
INSERT INTO `core_setting` VALUES('lang_check', 'off', 'enum', 3, 'debug', 8, 7, 1, 0, '');
INSERT INTO `core_setting` VALUES('lastfirst_mandatory', 'off', 'enum', 3, 'register', 3, 14, 2, 0, '');
INSERT INTO `core_setting` VALUES('ldap_port', '389', 'string', 5, '0', 7, 3, 1, 0, '');
INSERT INTO `core_setting` VALUES('ldap_server', '192.168.0.1', 'string', 255, '0', 7, 2, 1, 0, '');
INSERT INTO `core_setting` VALUES('ldap_used', 'off', 'enum', 3, '0', 7, 1, 1, 0, '');
INSERT INTO `core_setting` VALUES('ldap_user_string', '$user@domain2.domain1', 'string', 255, '0', 7, 4, 1, 0, '');
INSERT INTO `core_setting` VALUES('mail_sender', 'sample@[[domhost]]', 'string', 255, 'register', 3, 12, 0, 0, '');
INSERT INTO `core_setting` VALUES('mandatory_code', 'off', 'enum', 3, 'register', 3, 18, 1, 0, '');
INSERT INTO `core_setting` VALUES('max_log_attempt', '0', 'int', 3, '0', 3, 4, 0, 0, '');
INSERT INTO `core_setting` VALUES('nl_sendpause', '20', 'int', 3, 'newsletter', 8, 10, 1, 0, '');
INSERT INTO `core_setting` VALUES('nl_sendpercycle', '200', 'int', 4, 'newsletter', 8, 9, 1, 0, '');
INSERT INTO `core_setting` VALUES('no_answer_in_poll', 'off', 'enum', 3, '0', 4, 7, 1, 0, '');
INSERT INTO `core_setting` VALUES('no_answer_in_test', 'off', 'enum', 3, '0', 4, 6, 1, 0, '');
INSERT INTO `core_setting` VALUES('on_catalogue_empty', 'on', 'enum', 3, '0', 4, 3, 1, 0, '');
INSERT INTO `core_setting` VALUES('on_usercourse_empty', 'off', 'enum', 3, '0', 4, 4, 1, 0, '');
INSERT INTO `core_setting` VALUES('org_name_teleskill', '', 'string', 255, 'teleskill', 6, 4, 1, 0, '');
INSERT INTO `core_setting` VALUES('page_title', 'Docebo E-learning', 'string', 255, '0', 1, 1, 1, 0, '');
INSERT INTO `core_setting` VALUES('pass_alfanumeric', 'off', 'enum', 3, 'password', 3, 6, 1, 0, '');
INSERT INTO `core_setting` VALUES('pass_change_first_login', 'off', 'enum', 3, 'password', 3, 8, 1, 0, '');
INSERT INTO `core_setting` VALUES('pass_max_time_valid', '0', 'int', 4, 'password', 3, 9, 1, 0, '');
INSERT INTO `core_setting` VALUES('pass_min_char', '5', 'int', 2, 'password', 3, 7, 0, 0, '');
INSERT INTO `core_setting` VALUES('pathchat', 'chat/', 'string', 255, 'path', 8, 21, 1, 0, '');
INSERT INTO `core_setting` VALUES('pathcourse', 'course/', 'string', 255, 'path', 8, 11, 1, 0, '');
INSERT INTO `core_setting` VALUES('pathfield', 'field/', 'string', 255, 'path', 8, 12, 1, 0, '');
INSERT INTO `core_setting` VALUES('pathforum', 'forum/', 'string', 255, 'path', 8, 14, 1, 0, '');
INSERT INTO `core_setting` VALUES('pathlesson', 'item/', 'string', 255, 'path', 8, 15, 1, 0, '');
INSERT INTO `core_setting` VALUES('pathmessage', 'message/', 'string', 255, 'path', 8, 16, 1, 0, '');
INSERT INTO `core_setting` VALUES('pathphoto', 'photo/', 'string', 255, 'path', 8, 13, 1, 0, '');
INSERT INTO `core_setting` VALUES('pathprj', 'project/', 'string', 255, 'path', 8, 20, 1, 1, '');
INSERT INTO `core_setting` VALUES('pathscorm', 'scorm/', 'string', 255, 'path', 8, 17, 1, 0, '');
INSERT INTO `core_setting` VALUES('pathsponsor', 'sponsor/', 'string', 255, 'path', 8, 18, 1, 0, '');
INSERT INTO `core_setting` VALUES('pathtest', 'test/', 'string', 255, 'path', 8, 19, 1, 0, '');
INSERT INTO `core_setting` VALUES('paypal_currency', 'EUR', 'string', 255, '0', 5, 1, 1, 0, '');
INSERT INTO `core_setting` VALUES('paypal_mail', '', 'string', 255, '0', 5, 0, 1, 0, '');
INSERT INTO `core_setting` VALUES('paypal_sandbox', 'on', 'enum', 3, '0', 5, 3, 1, 0, '');
INSERT INTO `core_setting` VALUES('privacy_policy', 'on', 'enum', 3, 'register', 3, 15, 0, 0, '');
INSERT INTO `core_setting` VALUES('profile_only_pwd', 'on', 'enum', 3, '0', 3, 1, 1, 0, '');
INSERT INTO `core_setting` VALUES('register_deleted_user', 'off', 'enum', 3, '0', 3, 3, 1, 0, '');
INSERT INTO `core_setting` VALUES('register_type', 'admin', 'register_type', 10, 'register', 3, 11, 0, 0, '');
INSERT INTO `core_setting` VALUES('registration_code_type', '0', 'registration_code_type', 3, 'register', 3, 17, 1, 0, '');
INSERT INTO `core_setting` VALUES('request_mandatory_fields_compilation', 'off', 'enum', 3, '0', 3, 2, 1, 0, '');
INSERT INTO `core_setting` VALUES('rest_auth_code', '', 'string', 255, 'api', 9, 4, 1, 0, '');
INSERT INTO `core_setting` VALUES('rest_auth_lifetime', '60', 'int', 3, 'api', 9, 5, 1, 0, '');
INSERT INTO `core_setting` VALUES('rest_auth_method', '1', 'rest_auth_sel_method', 3, 'api', 9, 3, 1, 0, '');
INSERT INTO `core_setting` VALUES('rest_auth_update', 'off', 'enum', 3, 'api', 9, 6, 1, 0, '');
INSERT INTO `core_setting` VALUES('save_log_attempt', 'no', 'save_log_attempt', 255, '0', 3, 5, 0, 0, '');
INSERT INTO `core_setting` VALUES('sco_direct_play', 'on', 'enum', 3, '0', 8, 3, 1, 0, '');
INSERT INTO `core_setting` VALUES('sender_event', 'sample@[[domhost]]', 'string', 255, '0', 1, 5, 1, 0, '');
INSERT INTO `core_setting` VALUES('send_cc_for_system_emails', '', 'string', 255, '0', 8, 4, 1, 0, '');
INSERT INTO `core_setting` VALUES('session_ip_control', 'off', 'enum', 3, 'security', 8, 22, 1, 0, '');
INSERT INTO `core_setting` VALUES('sms_cell_num_field', '1', 'field_select', 5, '0', 11, 6, 1, 0, '');
INSERT INTO `core_setting` VALUES('sms_credit', '0', 'string', 20, '0', 1, 0, 1, 1, '');
INSERT INTO `core_setting` VALUES('sms_gateway', 'smsmarket', 'string', 50, '0', 11, 0, 1, 1, '');
INSERT INTO `core_setting` VALUES('sms_gateway_host', '193.254.241.47', 'string', 15, '0', 11, 8, 1, 0, '');
INSERT INTO `core_setting` VALUES('sms_gateway_id', '3', 'sel_sms_gateway', 1, '0', 11, 7, 1, 0, '');
INSERT INTO `core_setting` VALUES('sms_gateway_pass', '', 'string', 255, '0', 11, 5, 1, 0, '');
INSERT INTO `core_setting` VALUES('sms_gateway_port', '26', 'int', 5, '0', 11, 9, 1, 0, '');
INSERT INTO `core_setting` VALUES('sms_gateway_user', '', 'string', 50, '0', 11, 4, 1, 0, '');
INSERT INTO `core_setting` VALUES('sms_international_prefix', '+39', 'string', 3, '0', 11, 1, 1, 0, '');
INSERT INTO `core_setting` VALUES('sms_sent_from', '0', 'string', 25, '0', 11, 2, 1, 0, '');
INSERT INTO `core_setting` VALUES('social_fb_active', 'off', 'enum', 3, 'main', 12, 0, 1, 0, '');
INSERT INTO `core_setting` VALUES('social_fb_api', '', 'string', 255, 'main', 12, 1, 1, 0, '');
INSERT INTO `core_setting` VALUES('social_fb_secret', '', 'string', 255, 'main', 12, 2, 1, 0, '');
INSERT INTO `core_setting` VALUES('social_google_active', 'off', 'enum', 3, 'main', 12, 9, 1, 0, '');
INSERT INTO `core_setting` VALUES('social_linkedin_access', '', 'string', 255, 'main', 12, 7, 1, 0, '');
INSERT INTO `core_setting` VALUES('social_linkedin_active', 'off', 'enum', 3, 'main', 12, 6, 1, 0, '');
INSERT INTO `core_setting` VALUES('social_linkedin_secret', '', 'string', 255, 'main', 12, 8, 1, 0, '');
INSERT INTO `core_setting` VALUES('social_twitter_active', 'off', 'enum', 3, 'main', 12, 3, 1, 0, '');
INSERT INTO `core_setting` VALUES('social_twitter_consumer', '', 'string', 255, 'main', 12, 4, 1, 0, '');
INSERT INTO `core_setting` VALUES('social_twitter_secret', '', 'string', 255, 'main', 12, 5, 1, 0, '');
INSERT INTO `core_setting` VALUES('sso_secret', '', 'text', 255, '0', 9, 1, 1, 0, '');
INSERT INTO `core_setting` VALUES('sso_token', 'off', 'enum', 3, '0', 9, 0, 1, 0, '');
INSERT INTO `core_setting` VALUES('stop_concurrent_user', 'off', 'enum', 3, 'security', 8, 23, 1, 0, '');
INSERT INTO `core_setting` VALUES('tablist_mycourses', 'name,status', 'tablist_mycourses', 255, '0', 4, 1, 1, 0, '');
INSERT INTO `core_setting` VALUES('teleskill_max_participant', '300', 'string', 255, 'teleskill', 6, 6, 1, 0, '');
INSERT INTO `core_setting` VALUES('teleskill_max_room', '99999999999', 'string', 255, 'teleskill', 6, 5, 1, 0, '');
INSERT INTO `core_setting` VALUES('template_domain', '', 'textarea', 65535, '0', 8, 8, 1, 0, '');
INSERT INTO `core_setting` VALUES('templ_use_field', '0', 'id_field', 11, '0', 1, 0, 1, 1, '');
INSERT INTO `core_setting` VALUES('title_organigram_chart', 'Docebo', 'string', 255, '0', 1, 0, 1, 1, '');
INSERT INTO `core_setting` VALUES('tracking', 'on', 'enum', 3, '0', 4, 8, 1, 0, '');
INSERT INTO `core_setting` VALUES('ttlSession', '4000', 'int', 5, '0', 1, 6, 1, 0, '');
INSERT INTO `core_setting` VALUES('url', '[[softurl]]/', 'string', 255, '0', 1, 2, 1, 0, '');
INSERT INTO `core_setting` VALUES('url_checkin_teleskill', 'http://asp.teleskill.it/tvclive/server-1-1.asp', 'string', 255, 'teleskill', 6, 1, 1, 0, '');
INSERT INTO `core_setting` VALUES('url_videoconference_teleskill', '', 'string', 255, 'teleskill', 6, 2, 1, 0, '');
INSERT INTO `core_setting` VALUES('user_pwd_history_length', '3', 'int', 3, 'password', 3, 10, 1, 0, '');
INSERT INTO `core_setting` VALUES('user_quota', '50', 'string', 255, '0', 8, 6, 1, 0, '');
INSERT INTO `core_setting` VALUES('use_advanced_form', 'off', 'enum', 3, 'register', 3, 16, 1, 0, '');
INSERT INTO `core_setting` VALUES('use_dimdim_api', 'off', 'enum', 3, 'dimdim', 6, 8, 1, 0, '');
INSERT INTO `core_setting` VALUES('use_rest_api', 'off', 'enum', 3, 'api', 9, 2, 1, 0, '');
INSERT INTO `core_setting` VALUES('use_tag', 'off', 'enum', 3, '0', 4, 5, 1, 0, '');
INSERT INTO `core_setting` VALUES('visuItem', '25', 'int', 3, '0', 2, 1, 1, 1, '');
INSERT INTO `core_setting` VALUES('visuNewsHomePage', '3', 'int', 5, '0', 1, 0, 1, 1, '');
INSERT INTO `core_setting` VALUES('welcome_use_feed', 'on', 'enum', 3, '0', 1, 0, 1, 1, '');

-- --------------------------------------------------------

--
-- Table structure for table `core_setting_group`
--

CREATE TABLE `core_setting_group` (
  `path_name` varchar(255) NOT NULL DEFAULT '',
  `idst` int(11) NOT NULL DEFAULT '0',
  `value` text NOT NULL,
  PRIMARY KEY (`path_name`,`idst`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_setting_group`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_setting_list`
--

CREATE TABLE `core_setting_list` (
  `path_name` varchar(255) NOT NULL DEFAULT '',
  `label` varchar(255) NOT NULL DEFAULT '',
  `default_value` text NOT NULL,
  `type` varchar(255) NOT NULL DEFAULT '',
  `visible` tinyint(1) NOT NULL DEFAULT '0',
  `load_at_startup` tinyint(1) NOT NULL DEFAULT '0',
  `sequence` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`path_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_setting_list`
--

INSERT INTO `core_setting_list` VALUES('admin_rules.course_presence_admin', '_COURSE_PRESENCE_ADMIN', 'off', 'enum', 1, 1, 7);
INSERT INTO `core_setting_list` VALUES('admin_rules.direct_course_subscribe', '_DIRECT_COURSE_SUBSCRIBE', 'off', 'enum', 1, 1, 6);
INSERT INTO `core_setting_list` VALUES('admin_rules.direct_user_insert', '_DIRECT_USER_INSERT', 'off', 'enum', 1, 1, 3);
INSERT INTO `core_setting_list` VALUES('admin_rules.limit_course_subscribe', '_LIMIT_COURSE_SUBSCRIBE', 'off', 'enum', 1, 1, 4);
INSERT INTO `core_setting_list` VALUES('admin_rules.limit_user_insert', '_LIMIT_USER_INSERT', 'off', 'enum', 1, 1, 1);
INSERT INTO `core_setting_list` VALUES('admin_rules.max_course_subscribe', '_MAX_COURSE_SUBSCRIBE', '0', 'integer', 1, 1, 5);
INSERT INTO `core_setting_list` VALUES('admin_rules.max_user_insert', '_MAX_USER_INSERT', '0', 'integer', 1, 1, 2);
INSERT INTO `core_setting_list` VALUES('admin_rules.user_lang_assigned', '', '', 'string', 0, 1, 0);
INSERT INTO `core_setting_list` VALUES('ui.directory.custom_columns', '_CUSTOM_COLUMS', '', 'hidden', 0, 1, 0);
INSERT INTO `core_setting_list` VALUES('ui.language', '_LANGUAGE', '', 'language', 1, 1, 0);
INSERT INTO `core_setting_list` VALUES('user_rules.field_policy', '', '', 'serialized', 0, 1, 0);
INSERT INTO `core_setting_list` VALUES('user_rules.user_quota', '', '-1', 'int', 0, 1, 0);
INSERT INTO `core_setting_list` VALUES('user_rules.user_quota_used', '', '0', 'int', 0, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `core_setting_user`
--

CREATE TABLE `core_setting_user` (
  `path_name` varchar(255) NOT NULL DEFAULT '',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `value` text NOT NULL,
  PRIMARY KEY (`path_name`,`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_setting_user`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_st`
--

CREATE TABLE `core_st` (
  `idst` int(11) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`idst`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COMMENT='Security Tokens' AUTO_INCREMENT=11837 ;

--
-- Dumping data for table `core_st`
--

INSERT INTO `core_st` VALUES(0);
INSERT INTO `core_st` VALUES(11831);
INSERT INTO `core_st` VALUES(11832);
INSERT INTO `core_st` VALUES(11833);
INSERT INTO `core_st` VALUES(11834);
INSERT INTO `core_st` VALUES(11835);
INSERT INTO `core_st` VALUES(11836);

-- --------------------------------------------------------

--
-- Table structure for table `core_tag`
--

CREATE TABLE `core_tag` (
  `id_tag` int(11) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(255) NOT NULL DEFAULT '',
  `id_parent` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_tag`),
  KEY `tag_name` (`tag_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_tag`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_tag_relation`
--

CREATE TABLE `core_tag_relation` (
  `id_tag` int(11) NOT NULL DEFAULT '0',
  `id_resource` int(11) NOT NULL DEFAULT '0',
  `resource_type` varchar(255) NOT NULL DEFAULT '',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `private` tinyint(1) NOT NULL DEFAULT '0',
  `id_course` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_tag`,`id_resource`,`resource_type`,`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_tag_relation`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_tag_resource`
--

CREATE TABLE `core_tag_resource` (
  `id_resource` int(11) NOT NULL DEFAULT '0',
  `resource_type` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `sample_text` text NOT NULL,
  `permalink` text NOT NULL,
  PRIMARY KEY (`id_resource`,`resource_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_tag_resource`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_task`
--

CREATE TABLE `core_task` (
  `name` varchar(50) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  `conn_source` varchar(50) NOT NULL DEFAULT '',
  `conn_destination` varchar(50) NOT NULL DEFAULT '',
  `schedule_type` enum('at','any') NOT NULL DEFAULT 'at',
  `schedule` varchar(50) NOT NULL DEFAULT '',
  `import_type` varchar(50) NOT NULL DEFAULT '',
  `map` text NOT NULL,
  `last_execution` datetime DEFAULT NULL,
  `sequence` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_task`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_transaction`
--

CREATE TABLE `core_transaction` (
  `id_trans` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `location` varchar(10) NOT NULL DEFAULT '',
  `date_creation` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_activated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `paid` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_trans`),
  KEY `id_user` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_transaction`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_transaction_info`
--

CREATE TABLE `core_transaction_info` (
  `id_trans` int(11) NOT NULL DEFAULT '0',
  `id_course` int(11) NOT NULL DEFAULT '0',
  `id_date` int(11) NOT NULL DEFAULT '0',
  `id_edition` int(11) NOT NULL DEFAULT '0',
  `code` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `price` varchar(255) NOT NULL DEFAULT '',
  `activated` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_trans`,`id_course`,`id_date`,`id_edition`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_transaction_info`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_user`
--

CREATE TABLE `core_user` (
  `idst` int(11) NOT NULL DEFAULT '0',
  `userid` varchar(255) NOT NULL DEFAULT '',
  `firstname` varchar(255) NOT NULL DEFAULT '',
  `lastname` varchar(255) NOT NULL DEFAULT '',
  `pass` varchar(50) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `avatar` varchar(255) NOT NULL DEFAULT '',
  `signature` text NOT NULL,
  `level` int(11) NOT NULL DEFAULT '0',
  `lastenter` datetime DEFAULT NULL,
  `valid` tinyint(1) NOT NULL DEFAULT '1',
  `pwd_expire_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `force_change` tinyint(1) NOT NULL DEFAULT '0',
  `register_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `facebook_id` varchar(255) DEFAULT NULL,
  `twitter_id` varchar(255) DEFAULT NULL,
  `linkedin_id` varchar(255) DEFAULT NULL,
  `google_id` varchar(255) DEFAULT NULL,
  `privacy_policy` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`idst`),
  UNIQUE KEY `userid` (`userid`),
  UNIQUE KEY `facebook_id` (`facebook_id`),
  UNIQUE KEY `twitter_id` (`twitter_id`),
  UNIQUE KEY `linkedin_id` (`linkedin_id`),
  UNIQUE KEY `google_id` (`google_id`),
  UNIQUE KEY `facebook_id_2` (`facebook_id`),
  UNIQUE KEY `google_id_2` (`google_id`),
  UNIQUE KEY `twitter_id_2` (`twitter_id`),
  UNIQUE KEY `linkedin_id_2` (`linkedin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_user`
--

INSERT INTO `core_user` VALUES(270, '/Anonymous', '', '', '', '', '', '', 0, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', 1, '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, 0);
INSERT INTO `core_user` VALUES(11836, '/[[admin_username]]', '[[admin_fname]]', '[[admin_lname]]', '[[admin_pass]]', '[[admin_email]]', '', '', 0, NULL, 1, '0000-00-00 00:00:00', 0, '0000-00-00 00:00:00', NULL, NULL, NULL, NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `core_user_file`
--

CREATE TABLE `core_user_file` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_idst` int(11) NOT NULL DEFAULT '0',
  `type` varchar(20) NOT NULL DEFAULT '',
  `fname` varchar(255) NOT NULL DEFAULT '',
  `real_fname` varchar(255) NOT NULL DEFAULT '',
  `media_url` varchar(255) NOT NULL DEFAULT '',
  `size` int(11) NOT NULL DEFAULT '0',
  `uldate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_user_file`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_user_log_attempt`
--

CREATE TABLE `core_user_log_attempt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` varchar(255) NOT NULL DEFAULT '',
  `attempt_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `attempt_number` int(5) NOT NULL DEFAULT '0',
  `user_ip` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_user_log_attempt`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_user_profileview`
--

CREATE TABLE `core_user_profileview` (
  `id_owner` int(11) NOT NULL DEFAULT '0',
  `id_viewer` int(11) NOT NULL DEFAULT '0',
  `date_view` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_owner`,`id_viewer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_user_profileview`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_user_temp`
--

CREATE TABLE `core_user_temp` (
  `idst` int(11) NOT NULL DEFAULT '0',
  `userid` varchar(255) NOT NULL DEFAULT '',
  `firstname` varchar(100) NOT NULL DEFAULT '',
  `lastname` varchar(100) NOT NULL DEFAULT '',
  `pass` varchar(50) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `language` varchar(50) NOT NULL DEFAULT '',
  `request_on` datetime DEFAULT '0000-00-00 00:00:00',
  `random_code` varchar(255) NOT NULL DEFAULT '',
  `create_by_admin` int(11) NOT NULL DEFAULT '0',
  `confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `facebook_id` varchar(255) DEFAULT NULL,
  `twitter_id` varchar(255) DEFAULT NULL,
  `linkedin_id` varchar(255) DEFAULT NULL,
  `google_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`idst`),
  UNIQUE KEY `userid` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_user_temp`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_wiki`
--

CREATE TABLE `core_wiki` (
  `wiki_id` int(11) NOT NULL AUTO_INCREMENT,
  `source_platform` varchar(255) NOT NULL DEFAULT '',
  `public` tinyint(1) NOT NULL DEFAULT '0',
  `language` varchar(50) NOT NULL DEFAULT '',
  `other_lang` text NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `creation_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `page_count` int(11) NOT NULL DEFAULT '0',
  `revision_count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`wiki_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_wiki`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_wiki_page`
--

CREATE TABLE `core_wiki_page` (
  `page_id` int(11) NOT NULL AUTO_INCREMENT,
  `page_code` varchar(60) NOT NULL DEFAULT '',
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `page_path` varchar(255) NOT NULL DEFAULT '',
  `lev` int(3) NOT NULL DEFAULT '0',
  `wiki_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 PACK_KEYS=1 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `core_wiki_page`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_wiki_page_info`
--

CREATE TABLE `core_wiki_page_info` (
  `page_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `version` int(11) NOT NULL DEFAULT '0',
  `last_update` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `wiki_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`page_id`,`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_wiki_page_info`
--


-- --------------------------------------------------------

--
-- Table structure for table `core_wiki_revision`
--

CREATE TABLE `core_wiki_revision` (
  `wiki_id` int(11) NOT NULL DEFAULT '0',
  `page_id` int(11) NOT NULL DEFAULT '0',
  `version` int(11) NOT NULL DEFAULT '0',
  `language` varchar(50) NOT NULL DEFAULT '0',
  `author` int(11) NOT NULL DEFAULT '0',
  `rev_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `content` longtext NOT NULL,
  PRIMARY KEY (`wiki_id`,`page_id`,`version`,`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `core_wiki_revision`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_advice`
--

CREATE TABLE `learning_advice` (
  `idAdvice` int(11) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `posted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `author` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `important` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idAdvice`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_advice`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_adviceuser`
--

CREATE TABLE `learning_adviceuser` (
  `idAdvice` int(11) NOT NULL DEFAULT '0',
  `idUser` int(11) NOT NULL DEFAULT '0',
  `archivied` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idAdvice`,`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_adviceuser`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_assessment_rule`
--

CREATE TABLE `learning_assessment_rule` (
  `rule_id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  `from_score` double NOT NULL DEFAULT '0',
  `to_score` double NOT NULL DEFAULT '0',
  `competences_list` text,
  `courses_list` text,
  `feedback_txt` text,
  PRIMARY KEY (`rule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_assessment_rule`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_assessment_user`
--

CREATE TABLE `learning_assessment_user` (
  `id_assessment` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `type_of` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_assessment`,`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_assessment_user`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_calendar`
--

CREATE TABLE `learning_calendar` (
  `id` bigint(20) NOT NULL DEFAULT '0',
  `idCourse` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_calendar`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_catalogue`
--

CREATE TABLE `learning_catalogue` (
  `idCatalogue` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  PRIMARY KEY (`idCatalogue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_catalogue`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_catalogue_entry`
--

CREATE TABLE `learning_catalogue_entry` (
  `idCatalogue` int(11) NOT NULL DEFAULT '0',
  `idEntry` int(11) NOT NULL DEFAULT '0',
  `type_of_entry` enum('course','coursepath') NOT NULL DEFAULT 'course',
  PRIMARY KEY (`idCatalogue`,`idEntry`,`type_of_entry`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_catalogue_entry`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_catalogue_member`
--

CREATE TABLE `learning_catalogue_member` (
  `idCatalogue` int(11) NOT NULL DEFAULT '0',
  `idst_member` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idCatalogue`,`idst_member`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_catalogue_member`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_category`
--

CREATE TABLE `learning_category` (
  `idCategory` int(11) NOT NULL AUTO_INCREMENT,
  `idParent` int(11) DEFAULT '0',
  `lev` int(11) NOT NULL DEFAULT '0',
  `path` text NOT NULL,
  `description` text NOT NULL,
  `iLeft` int(5) NOT NULL DEFAULT '0',
  `iRight` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idCategory`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_category`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_certificate`
--

CREATE TABLE `learning_certificate` (
  `id_certificate` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `base_language` varchar(255) NOT NULL DEFAULT '',
  `cert_structure` text NOT NULL,
  `orientation` enum('P','L') NOT NULL DEFAULT 'P',
  `bgimage` varchar(255) NOT NULL DEFAULT '',
  `meta` tinyint(1) NOT NULL DEFAULT '0',
  `user_release` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_certificate`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `learning_certificate`
--

INSERT INTO `learning_certificate` VALUES(2, '0000', 'Certificate sample', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.<br />', 'english', '<table style="margin-left: auto; margin-right: auto;" border="0">\n<tbody>\n<tr>\n<td>&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</td>\n<td style="text-align: center;" colspan="2"><span style="font-size: 65px;"><br /><br /><br /><br /><br /><br /><br />This certificate is awarded to<strong><strong><br />[display_name]<br /></strong><br /><br /><br /></strong>In recognition of your completion of the training course<strong><br />[course_name]<br /><br /><br /><br /><br /><br /></strong></span></td>\n<td>&nbsp;&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</td>\n</tr>\n<tr>\n<td>&nbsp;</td>\n<td>&nbsp;</td>\n<td style="text-align: right;"><span style="line-height: 19px; font-size: small;"><strong><br /></strong></span></td>\n<td><span style="font-size: x-large;"><strong>[theacher_list]</strong></span><br /><span style="font-size: x-large;">The Instructor/s</span></td>\n</tr>\n</tbody>\n</table>\n<br />', 'L', 'certificate_sample.jpg', 0, 1);

-- --------------------------------------------------------

--
-- Table structure for table `learning_certificate_assign`
--

CREATE TABLE `learning_certificate_assign` (
  `id_certificate` int(11) NOT NULL DEFAULT '0',
  `id_course` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `on_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cert_file` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_certificate`,`id_course`,`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_certificate_assign`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_certificate_course`
--

CREATE TABLE `learning_certificate_course` (
  `id_certificate` int(11) NOT NULL DEFAULT '0',
  `id_course` int(11) NOT NULL DEFAULT '0',
  `available_for_status` tinyint(1) NOT NULL DEFAULT '0',
  `point_required` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_certificate`,`id_course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_certificate_course`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_certificate_meta`
--

CREATE TABLE `learning_certificate_meta` (
  `idMetaCertificate` int(11) NOT NULL AUTO_INCREMENT,
  `idCertificate` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`idMetaCertificate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_certificate_meta`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_certificate_meta_assign`
--

CREATE TABLE `learning_certificate_meta_assign` (
  `idUser` int(11) NOT NULL DEFAULT '0',
  `idMetaCertificate` int(11) NOT NULL DEFAULT '0',
  `idCertificate` int(11) NOT NULL DEFAULT '0',
  `on_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `cert_file` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`idUser`,`idMetaCertificate`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_certificate_meta_assign`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_certificate_meta_course`
--

CREATE TABLE `learning_certificate_meta_course` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idMetaCertificate` int(11) NOT NULL DEFAULT '0',
  `idUser` int(11) NOT NULL DEFAULT '0',
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `idCourseEdition` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_certificate_meta_course`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_certificate_tags`
--

CREATE TABLE `learning_certificate_tags` (
  `file_name` varchar(255) NOT NULL DEFAULT '',
  `class_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`file_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_certificate_tags`
--

INSERT INTO `learning_certificate_tags` VALUES('certificate.course.php', 'CertificateSubs_Course');
INSERT INTO `learning_certificate_tags` VALUES('certificate.misc.php', 'CertificateSubs_Misc');
INSERT INTO `learning_certificate_tags` VALUES('certificate.user.php', 'CertificateSubs_User');
INSERT INTO `learning_certificate_tags` VALUES('certificate.userstat.php', 'CertificateSubs_UserStat');

-- --------------------------------------------------------

--
-- Table structure for table `learning_classroom`
--

CREATE TABLE `learning_classroom` (
  `idClassroom` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `location_id` int(11) NOT NULL DEFAULT '0',
  `room` varchar(255) NOT NULL DEFAULT '',
  `street` varchar(255) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `state` varchar(255) NOT NULL DEFAULT '',
  `zip_code` varchar(255) NOT NULL DEFAULT '',
  `phone` varchar(255) NOT NULL DEFAULT '',
  `fax` varchar(255) NOT NULL DEFAULT '',
  `capacity` varchar(255) NOT NULL DEFAULT '',
  `disposition` text NOT NULL,
  `instrument` text NOT NULL,
  `available_instrument` text NOT NULL,
  `note` text NOT NULL,
  `responsable` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`idClassroom`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_classroom`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_classroom_calendar`
--

CREATE TABLE `learning_classroom_calendar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `classroom_id` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `owner` int(11) NOT NULL DEFAULT '0',
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_classroom_calendar`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_class_location`
--

CREATE TABLE `learning_class_location` (
  `location_id` int(11) NOT NULL AUTO_INCREMENT,
  `location` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_class_location`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_comment_ajax`
--

CREATE TABLE `learning_comment_ajax` (
  `id_comment` int(11) NOT NULL AUTO_INCREMENT,
  `resource_type` varchar(50) NOT NULL DEFAULT '',
  `external_key` varchar(200) NOT NULL DEFAULT '',
  `id_author` int(11) NOT NULL DEFAULT '0',
  `posted_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `textof` text NOT NULL,
  `history_tree` varchar(255) NOT NULL DEFAULT '',
  `id_parent` int(11) NOT NULL DEFAULT '0',
  `moderated` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_comment`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_comment_ajax`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_commontrack`
--

CREATE TABLE `learning_commontrack` (
  `idReference` int(11) NOT NULL DEFAULT '0',
  `idUser` int(11) NOT NULL DEFAULT '0',
  `idTrack` int(11) NOT NULL DEFAULT '0',
  `objectType` varchar(20) NOT NULL DEFAULT '',
  `dateAttempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` varchar(20) NOT NULL DEFAULT '',
  `firstAttempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `first_complete` datetime DEFAULT NULL,
  `last_complete` datetime DEFAULT NULL,
  PRIMARY KEY (`idTrack`,`objectType`),
  KEY `idReference` (`idReference`),
  KEY `idUser` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_commontrack`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_communication`
--

CREATE TABLE `learning_communication` (
  `id_comm` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `publish_date` date NOT NULL DEFAULT '0000-00-00',
  `type_of` varchar(15) NOT NULL DEFAULT '',
  `id_resource` int(11) NOT NULL DEFAULT '0',
  `id_category` int(11) unsigned NOT NULL DEFAULT '0',
  `id_course` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_comm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_communication`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_communication_access`
--

CREATE TABLE `learning_communication_access` (
  `id_comm` int(11) NOT NULL DEFAULT '0',
  `idst` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_comm`,`idst`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_communication_access`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_communication_category`
--

CREATE TABLE `learning_communication_category` (
  `id_category` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_parent` int(11) unsigned NOT NULL DEFAULT '0',
  `level` int(11) unsigned NOT NULL DEFAULT '0',
  `iLeft` int(11) unsigned NOT NULL DEFAULT '0',
  `iRight` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_communication_category`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_communication_category_lang`
--

CREATE TABLE `learning_communication_category_lang` (
  `id_category` int(10) unsigned NOT NULL DEFAULT '0',
  `lang_code` varchar(255) NOT NULL DEFAULT '',
  `translation` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_category`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_communication_category_lang`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_communication_track`
--

CREATE TABLE `learning_communication_track` (
  `idReference` int(11) NOT NULL DEFAULT '0',
  `idUser` int(11) NOT NULL DEFAULT '0',
  `idTrack` int(11) NOT NULL DEFAULT '0',
  `objectType` varchar(20) NOT NULL DEFAULT '',
  `dateAttempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` varchar(20) NOT NULL DEFAULT '',
  `firstAttempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`idReference`,`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_communication_track`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_competence`
--

CREATE TABLE `learning_competence` (
  `id_competence` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_category` int(10) unsigned NOT NULL DEFAULT '0',
  `type` enum('score','flag') NOT NULL DEFAULT 'score',
  `score` float NOT NULL DEFAULT '0',
  `typology` enum('skill','attitude','knowledge') NOT NULL DEFAULT 'skill',
  `expiration` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_competence`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_competence`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_competence_category`
--

CREATE TABLE `learning_competence_category` (
  `id_category` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_parent` int(10) unsigned NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `iLeft` int(10) unsigned NOT NULL DEFAULT '0',
  `iRight` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_competence_category`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_competence_category_lang`
--

CREATE TABLE `learning_competence_category_lang` (
  `id_category` int(10) unsigned NOT NULL DEFAULT '0',
  `lang_code` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  PRIMARY KEY (`id_category`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_competence_category_lang`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_competence_course`
--

CREATE TABLE `learning_competence_course` (
  `id_competence` int(10) unsigned NOT NULL DEFAULT '0',
  `id_course` int(10) unsigned NOT NULL DEFAULT '0',
  `score` float NOT NULL DEFAULT '0',
  `retraining` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_competence`,`id_course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_competence_course`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_competence_lang`
--

CREATE TABLE `learning_competence_lang` (
  `id_competence` int(10) unsigned NOT NULL DEFAULT '0',
  `lang_code` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  PRIMARY KEY (`id_competence`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_competence_lang`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_competence_required`
--

CREATE TABLE `learning_competence_required` (
  `id_competence` int(10) unsigned NOT NULL DEFAULT '0',
  `idst` int(10) unsigned NOT NULL DEFAULT '0',
  `type_of` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_competence`,`idst`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_competence_required`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_competence_track`
--

CREATE TABLE `learning_competence_track` (
  `id_track` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_competence` int(10) unsigned NOT NULL DEFAULT '0',
  `id_user` int(10) unsigned NOT NULL DEFAULT '0',
  `operation` varchar(255) NOT NULL DEFAULT '',
  `id_course` int(11) NOT NULL DEFAULT '0',
  `assigned_by` int(11) NOT NULL DEFAULT '0',
  `date_assignment` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `score_assigned` float NOT NULL DEFAULT '0',
  `score_total` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_track`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_competence_track`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_competence_user`
--

CREATE TABLE `learning_competence_user` (
  `id_competence` int(10) unsigned NOT NULL DEFAULT '0',
  `id_user` int(10) unsigned NOT NULL DEFAULT '0',
  `score_got` float NOT NULL DEFAULT '0',
  `last_assign_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_competence`,`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_competence_user`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_course`
--

CREATE TABLE `learning_course` (
  `idCourse` int(11) NOT NULL AUTO_INCREMENT,
  `idCategory` int(11) NOT NULL DEFAULT '0',
  `code` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `lang_code` varchar(100) NOT NULL DEFAULT '',
  `status` int(1) NOT NULL DEFAULT '0',
  `level_show_user` int(11) NOT NULL DEFAULT '0',
  `subscribe_method` tinyint(1) NOT NULL DEFAULT '0',
  `linkSponsor` varchar(255) NOT NULL DEFAULT '',
  `imgSponsor` varchar(255) NOT NULL DEFAULT '',
  `img_course` varchar(255) NOT NULL DEFAULT '',
  `img_material` varchar(255) NOT NULL DEFAULT '',
  `img_othermaterial` varchar(255) NOT NULL DEFAULT '',
  `course_demo` varchar(255) NOT NULL DEFAULT '',
  `mediumTime` int(10) unsigned NOT NULL DEFAULT '0',
  `permCloseLO` tinyint(1) NOT NULL DEFAULT '0',
  `userStatusOp` int(11) NOT NULL DEFAULT '0',
  `difficult` enum('veryeasy','easy','medium','difficult','verydifficult') NOT NULL DEFAULT 'medium',
  `show_progress` tinyint(1) NOT NULL DEFAULT '1',
  `show_time` tinyint(1) NOT NULL DEFAULT '0',
  `show_who_online` tinyint(1) NOT NULL DEFAULT '0',
  `show_extra_info` tinyint(1) NOT NULL DEFAULT '0',
  `show_rules` tinyint(1) NOT NULL DEFAULT '0',
  `date_begin` date NOT NULL DEFAULT '0000-00-00',
  `date_end` date NOT NULL DEFAULT '0000-00-00',
  `hour_begin` varchar(5) NOT NULL DEFAULT '',
  `hour_end` varchar(5) NOT NULL DEFAULT '',
  `valid_time` int(10) NOT NULL DEFAULT '0',
  `max_num_subscribe` int(11) NOT NULL DEFAULT '0',
  `min_num_subscribe` int(11) NOT NULL DEFAULT '0',
  `max_sms_budget` double NOT NULL DEFAULT '0',
  `selling` tinyint(1) NOT NULL DEFAULT '0',
  `prize` varchar(255) NOT NULL DEFAULT '',
  `course_type` varchar(255) NOT NULL DEFAULT 'elearning',
  `policy_point` varchar(255) NOT NULL DEFAULT '',
  `point_to_all` int(10) NOT NULL DEFAULT '0',
  `course_edition` tinyint(1) NOT NULL DEFAULT '0',
  `classrooms` varchar(255) NOT NULL DEFAULT '',
  `certificates` varchar(255) NOT NULL DEFAULT '',
  `create_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `security_code` varchar(255) NOT NULL DEFAULT '',
  `imported_from_connection` varchar(255) DEFAULT NULL,
  `course_quota` varchar(255) NOT NULL DEFAULT '-1',
  `used_space` varchar(255) NOT NULL DEFAULT '0',
  `course_vote` double NOT NULL DEFAULT '0',
  `allow_overbooking` tinyint(1) NOT NULL DEFAULT '0',
  `can_subscribe` tinyint(1) NOT NULL DEFAULT '0',
  `sub_start_date` datetime DEFAULT NULL,
  `sub_end_date` datetime DEFAULT NULL,
  `advance` varchar(255) NOT NULL DEFAULT '',
  `autoregistration_code` varchar(255) NOT NULL DEFAULT '',
  `direct_play` tinyint(1) NOT NULL DEFAULT '0',
  `use_logo_in_courselist` tinyint(1) NOT NULL DEFAULT '0',
  `show_result` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `credits` int(11) NOT NULL DEFAULT '0',
  `auto_unsubscribe` tinyint(1) NOT NULL DEFAULT '0',
  `unsubscribe_date_limit` datetime DEFAULT NULL,
  PRIMARY KEY (`idCourse`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_course`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_coursepath`
--

CREATE TABLE `learning_coursepath` (
  `id_path` int(11) NOT NULL AUTO_INCREMENT,
  `path_code` varchar(255) NOT NULL DEFAULT '',
  `path_name` varchar(255) NOT NULL DEFAULT '',
  `path_descr` text NOT NULL,
  `subscribe_method` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_coursepath`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_coursepath_courses`
--

CREATE TABLE `learning_coursepath_courses` (
  `id_path` int(11) NOT NULL DEFAULT '0',
  `id_item` int(11) NOT NULL DEFAULT '0',
  `in_slot` int(11) NOT NULL DEFAULT '0',
  `prerequisites` text NOT NULL,
  `sequence` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_path`,`id_item`,`in_slot`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_coursepath_courses`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_coursepath_user`
--

CREATE TABLE `learning_coursepath_user` (
  `id_path` int(11) NOT NULL DEFAULT '0',
  `idUser` int(11) NOT NULL DEFAULT '0',
  `waiting` tinyint(1) NOT NULL DEFAULT '0',
  `course_completed` int(3) NOT NULL DEFAULT '0',
  `date_assign` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `subscribed_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_path`,`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_coursepath_user`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_coursereport`
--

CREATE TABLE `learning_coursereport` (
  `id_report` int(11) NOT NULL AUTO_INCREMENT,
  `id_course` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `max_score` float NOT NULL DEFAULT '0',
  `required_score` float NOT NULL DEFAULT '0',
  `weight` int(3) NOT NULL DEFAULT '0',
  `show_to_user` enum('true','false') NOT NULL DEFAULT 'true',
  `use_for_final` enum('true','false') NOT NULL DEFAULT 'true',
  `sequence` int(3) NOT NULL DEFAULT '0',
  `source_of` enum('test','activity','scorm','final_vote','scoitem') NOT NULL DEFAULT 'test',
  `id_source` varchar(255) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_report`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_coursereport`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_coursereport_score`
--

CREATE TABLE `learning_coursereport_score` (
  `id_report` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `date_attempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `score` double(5,2) NOT NULL DEFAULT '0.00',
  `score_status` enum('valid','not_checked','not_passed','passed') NOT NULL DEFAULT 'valid',
  `comment` text NOT NULL,
  PRIMARY KEY (`id_report`,`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_coursereport_score`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_courseuser`
--

CREATE TABLE `learning_courseuser` (
  `idUser` int(11) NOT NULL DEFAULT '0',
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `edition_id` int(11) NOT NULL DEFAULT '0',
  `level` int(11) NOT NULL DEFAULT '0',
  `date_inscr` datetime DEFAULT NULL,
  `date_first_access` datetime DEFAULT NULL,
  `date_complete` datetime DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `waiting` tinyint(1) NOT NULL DEFAULT '0',
  `subscribed_by` int(11) NOT NULL DEFAULT '0',
  `rule_log` int(11) DEFAULT NULL,
  `score_given` int(4) DEFAULT NULL,
  `imported_from_connection` varchar(255) DEFAULT NULL,
  `absent` tinyint(1) NOT NULL DEFAULT '0',
  `cancelled_by` int(11) NOT NULL DEFAULT '0',
  `new_forum_post` int(11) NOT NULL DEFAULT '0',
  `date_begin_validity` datetime DEFAULT NULL,
  `date_expire_validity` datetime DEFAULT NULL,
  `requesting_unsubscribe` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `requesting_unsubscribe_date` datetime DEFAULT NULL,
  PRIMARY KEY (`idUser`,`idCourse`,`edition_id`),
  KEY `idCourse` (`idCourse`),
  KEY `idUser` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_courseuser`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_course_date`
--

CREATE TABLE `learning_course_date` (
  `id_date` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_course` int(10) unsigned NOT NULL DEFAULT '0',
  `code` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `max_par` int(11) NOT NULL DEFAULT '0',
  `price` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `overbooking` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `test_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `status` int(10) unsigned NOT NULL DEFAULT '0',
  `medium_time` int(11) NOT NULL DEFAULT '0',
  `sub_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `sub_end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `unsubscribe_date_limit` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_date`),
  KEY `id_course` (`id_course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_course_date`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_course_date_day`
--

CREATE TABLE `learning_course_date_day` (
  `id_day` int(11) NOT NULL DEFAULT '0',
  `id_date` int(11) NOT NULL DEFAULT '0',
  `classroom` int(11) unsigned NOT NULL DEFAULT '0',
  `date_begin` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_end` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `pause_begin` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `pause_end` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_day`,`id_date`),
  KEY `id_date` (`id_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_course_date_day`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_course_date_presence`
--

CREATE TABLE `learning_course_date_presence` (
  `day` date NOT NULL DEFAULT '0000-00-00',
  `id_date` int(11) unsigned NOT NULL DEFAULT '0',
  `id_user` int(11) unsigned NOT NULL DEFAULT '0',
  `id_day` int(11) unsigned NOT NULL DEFAULT '0',
  `presence` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `score` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `note` text NOT NULL,
  PRIMARY KEY (`day`,`id_date`,`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_course_date_presence`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_course_date_user`
--

CREATE TABLE `learning_course_date_user` (
  `id_date` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `date_subscription` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_complete` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `presence` mediumtext CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `subscribed_by` int(10) unsigned NOT NULL DEFAULT '0',
  `overbooking` int(10) DEFAULT '0',
  `requesting_unsubscribe` tinyint(1) unsigned DEFAULT NULL,
  `requesting_unsubscribe_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id_date`,`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_course_date_user`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_course_editions`
--

CREATE TABLE `learning_course_editions` (
  `id_edition` int(11) NOT NULL AUTO_INCREMENT,
  `id_course` int(11) NOT NULL DEFAULT '0',
  `code` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `status` int(1) NOT NULL DEFAULT '0',
  `date_begin` date NOT NULL DEFAULT '0000-00-00',
  `date_end` date NOT NULL DEFAULT '0000-00-00',
  `max_num_subscribe` int(11) NOT NULL DEFAULT '0',
  `min_num_subscribe` int(11) NOT NULL DEFAULT '0',
  `price` varchar(255) NOT NULL DEFAULT '',
  `overbooking` tinyint(1) NOT NULL DEFAULT '0',
  `can_subscribe` tinyint(1) NOT NULL DEFAULT '0',
  `sub_date_begin` date NOT NULL DEFAULT '0000-00-00',
  `sub_date_end` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id_edition`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_course_editions`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_course_editions_user`
--

CREATE TABLE `learning_course_editions_user` (
  `id_edition` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `date_subscription` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_complete` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `subscribed_by` int(10) unsigned NOT NULL DEFAULT '0',
  `requesting_unsubscribe` tinyint(1) unsigned DEFAULT NULL,
  `requesting_unsubscribe_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id_edition`,`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_course_editions_user`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_course_file`
--

CREATE TABLE `learning_course_file` (
  `id_file` int(11) NOT NULL AUTO_INCREMENT,
  `id_course` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_file`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_course_file`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_faq`
--

CREATE TABLE `learning_faq` (
  `idFaq` int(11) NOT NULL AUTO_INCREMENT,
  `idCategory` int(11) NOT NULL DEFAULT '0',
  `question` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `keyword` text NOT NULL,
  `answer` text NOT NULL,
  `sequence` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idFaq`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_faq`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_faq_cat`
--

CREATE TABLE `learning_faq_cat` (
  `idCategory` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `author` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idCategory`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_faq_cat`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_forum`
--

CREATE TABLE `learning_forum` (
  `idForum` int(11) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `num_thread` int(11) NOT NULL DEFAULT '0',
  `num_post` int(11) NOT NULL DEFAULT '0',
  `last_post` int(11) NOT NULL DEFAULT '0',
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `sequence` int(5) NOT NULL DEFAULT '0',
  `emoticons` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`idForum`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_forum`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_forummessage`
--

CREATE TABLE `learning_forummessage` (
  `idMessage` int(11) NOT NULL AUTO_INCREMENT,
  `idThread` int(11) NOT NULL DEFAULT '0',
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `answer_tree` text NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `textof` text NOT NULL,
  `posted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `author` int(11) NOT NULL DEFAULT '0',
  `generator` tinyint(1) NOT NULL DEFAULT '0',
  `attach` varchar(255) NOT NULL DEFAULT '',
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `modified_by_on` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`idMessage`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_forummessage`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_forumthread`
--

CREATE TABLE `learning_forumthread` (
  `idThread` int(11) NOT NULL AUTO_INCREMENT,
  `id_edition` int(11) NOT NULL DEFAULT '0',
  `idForum` int(11) NOT NULL DEFAULT '0',
  `posted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `title` varchar(255) NOT NULL DEFAULT '',
  `author` int(11) NOT NULL DEFAULT '0',
  `num_post` int(11) NOT NULL DEFAULT '0',
  `num_view` int(5) NOT NULL DEFAULT '0',
  `last_post` int(11) NOT NULL DEFAULT '0',
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `erased` tinyint(1) NOT NULL DEFAULT '0',
  `emoticons` varchar(255) NOT NULL DEFAULT '',
  `rilevantForum` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idThread`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_forumthread`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_forum_access`
--

CREATE TABLE `learning_forum_access` (
  `idForum` int(11) NOT NULL DEFAULT '0',
  `idMember` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idForum`,`idMember`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_forum_access`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_forum_notifier`
--

CREATE TABLE `learning_forum_notifier` (
  `id_notify` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `notify_is_a` enum('forum','thread') NOT NULL DEFAULT 'forum',
  PRIMARY KEY (`id_notify`,`id_user`,`notify_is_a`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_forum_notifier`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_forum_timing`
--

CREATE TABLE `learning_forum_timing` (
  `idUser` int(11) NOT NULL DEFAULT '0',
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `last_access` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`idUser`,`idCourse`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_forum_timing`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_games`
--

CREATE TABLE `learning_games` (
  `id_game` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `start_date` date NOT NULL DEFAULT '0000-00-00',
  `end_date` date NOT NULL DEFAULT '0000-00-00',
  `type_of` varchar(15) NOT NULL DEFAULT '',
  `id_resource` int(11) NOT NULL DEFAULT '0',
  `play_chance` varchar(45) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_game`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_games`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_games_access`
--

CREATE TABLE `learning_games_access` (
  `id_game` int(11) NOT NULL DEFAULT '0',
  `idst` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_game`,`idst`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_games_access`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_games_track`
--

CREATE TABLE `learning_games_track` (
  `idReference` int(11) NOT NULL DEFAULT '0',
  `idUser` int(11) NOT NULL DEFAULT '0',
  `idTrack` int(11) NOT NULL DEFAULT '0',
  `objectType` varchar(20) NOT NULL DEFAULT '',
  `dateAttempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` varchar(20) NOT NULL DEFAULT '',
  `firstAttempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `current_score` int(11) DEFAULT NULL,
  `max_score` int(11) DEFAULT NULL,
  `num_attempts` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idTrack`,`objectType`),
  KEY `idReference` (`idReference`),
  KEY `idUser` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_games_track`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_glossary`
--

CREATE TABLE `learning_glossary` (
  `idGlossary` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `author` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idGlossary`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_glossary`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_glossaryterm`
--

CREATE TABLE `learning_glossaryterm` (
  `idTerm` int(11) NOT NULL AUTO_INCREMENT,
  `idGlossary` int(11) NOT NULL DEFAULT '0',
  `term` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  PRIMARY KEY (`idTerm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_glossaryterm`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_homerepo`
--

CREATE TABLE `learning_homerepo` (
  `idRepo` int(11) NOT NULL AUTO_INCREMENT,
  `idParent` int(11) NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `lev` int(10) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `objectType` varchar(20) NOT NULL DEFAULT '',
  `idResource` int(11) NOT NULL DEFAULT '0',
  `idCategory` int(11) NOT NULL DEFAULT '0',
  `idUser` int(11) NOT NULL DEFAULT '0',
  `idAuthor` int(11) NOT NULL DEFAULT '0',
  `version` varchar(8) NOT NULL DEFAULT '',
  `difficult` enum('_VERYEASY','_EASY','_MEDIUM','_DIFFICULT','_VERYDIFFICULT') NOT NULL DEFAULT '_VERYEASY',
  `description` text NOT NULL,
  `language` varchar(50) NOT NULL DEFAULT '',
  `resource` varchar(255) NOT NULL DEFAULT '',
  `objective` text NOT NULL,
  `dateInsert` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `idOwner` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idRepo`),
  KEY `idParent` (`idParent`),
  KEY `path` (`path`),
  KEY `idOwner` (`idOwner`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_homerepo`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_htmlfront`
--

CREATE TABLE `learning_htmlfront` (
  `id_course` int(11) NOT NULL DEFAULT '0',
  `textof` text NOT NULL,
  PRIMARY KEY (`id_course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_htmlfront`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_htmlpage`
--

CREATE TABLE `learning_htmlpage` (
  `idPage` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL DEFAULT '',
  `textof` text NOT NULL,
  `author` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idPage`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_htmlpage`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_instmsg`
--

CREATE TABLE `learning_instmsg` (
  `id_msg` bigint(20) NOT NULL AUTO_INCREMENT,
  `id_sender` int(11) NOT NULL DEFAULT '0',
  `id_receiver` int(11) NOT NULL DEFAULT '0',
  `msg` text,
  `status` smallint(2) NOT NULL DEFAULT '0',
  `data` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_msg`),
  KEY `id_sender` (`id_sender`,`id_receiver`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_instmsg`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_kb_rel`
--

CREATE TABLE `learning_kb_rel` (
  `res_id` int(11) NOT NULL DEFAULT '0',
  `parent_id` varchar(45) NOT NULL DEFAULT '',
  `rel_type` enum('tag','folder') NOT NULL DEFAULT 'tag',
  PRIMARY KEY (`res_id`,`parent_id`,`rel_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_kb_rel`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_kb_res`
--

CREATE TABLE `learning_kb_res` (
  `res_id` int(11) NOT NULL AUTO_INCREMENT,
  `r_name` varchar(255) NOT NULL DEFAULT '',
  `original_name` varchar(255) DEFAULT NULL,
  `r_desc` text,
  `r_item_id` int(11) NOT NULL DEFAULT '0',
  `r_type` varchar(45) NOT NULL DEFAULT '',
  `r_env` varchar(45) NOT NULL DEFAULT '',
  `r_env_parent_id` int(11) DEFAULT NULL,
  `r_param` varchar(255) DEFAULT NULL,
  `r_alt_desc` varchar(255) DEFAULT NULL,
  `r_lang` varchar(50) NOT NULL DEFAULT '',
  `force_visible` tinyint(1) NOT NULL DEFAULT '0',
  `is_mobile` tinyint(1) NOT NULL DEFAULT '0',
  `sub_categorize` tinyint(1) NOT NULL DEFAULT '-1',
  `is_categorized` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`res_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_kb_res`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_kb_tag`
--

CREATE TABLE `learning_kb_tag` (
  `tag_id` int(11) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_kb_tag`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_kb_tree`
--

CREATE TABLE `learning_kb_tree` (
  `node_id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `lev` int(11) NOT NULL DEFAULT '0',
  `iLeft` int(11) NOT NULL DEFAULT '0',
  `iRight` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_kb_tree`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_kb_tree_info`
--

CREATE TABLE `learning_kb_tree_info` (
  `id_dir` int(11) NOT NULL DEFAULT '0',
  `lang_code` varchar(50) NOT NULL DEFAULT '',
  `node_title` varchar(255) NOT NULL DEFAULT '',
  `node_desc` text
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_kb_tree_info`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_label`
--

CREATE TABLE `learning_label` (
  `id_common_label` int(11) NOT NULL DEFAULT '0',
  `lang_code` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `file_name` varchar(255) NOT NULL DEFAULT '',
  `sequence` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_common_label`,`lang_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_label`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_label_course`
--

CREATE TABLE `learning_label_course` (
  `id_common_label` int(11) NOT NULL DEFAULT '0',
  `id_course` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_common_label`,`id_course`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_label_course`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_light_repo`
--

CREATE TABLE `learning_light_repo` (
  `id_repository` int(11) NOT NULL AUTO_INCREMENT,
  `id_course` int(11) NOT NULL DEFAULT '0',
  `repo_title` varchar(255) NOT NULL DEFAULT '',
  `repo_descr` text NOT NULL,
  PRIMARY KEY (`id_repository`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_light_repo`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_light_repo_files`
--

CREATE TABLE `learning_light_repo_files` (
  `id_file` int(11) NOT NULL AUTO_INCREMENT,
  `id_repository` int(11) NOT NULL DEFAULT '0',
  `file_name` varchar(255) NOT NULL DEFAULT '',
  `file_descr` text NOT NULL,
  `id_author` int(11) NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id_file`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_light_repo_files`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_light_repo_user`
--

CREATE TABLE `learning_light_repo_user` (
  `id_repo` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `last_enter` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `repo_lock` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_repo`,`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_light_repo_user`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_link`
--

CREATE TABLE `learning_link` (
  `idLink` int(11) NOT NULL AUTO_INCREMENT,
  `idCategory` int(11) NOT NULL DEFAULT '0',
  `title` varchar(150) NOT NULL DEFAULT '',
  `link_address` varchar(255) NOT NULL DEFAULT '',
  `keyword` text NOT NULL,
  `description` text NOT NULL,
  `sequence` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idLink`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_link`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_link_cat`
--

CREATE TABLE `learning_link_cat` (
  `idCategory` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `author` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idCategory`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_link_cat`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_lo_param`
--

CREATE TABLE `learning_lo_param` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idParam` int(11) NOT NULL DEFAULT '0',
  `param_name` varchar(20) NOT NULL DEFAULT '',
  `param_value` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idParam_name` (`idParam`,`param_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_lo_param`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_lo_types`
--

CREATE TABLE `learning_lo_types` (
  `objectType` varchar(20) NOT NULL DEFAULT '',
  `className` varchar(20) NOT NULL DEFAULT '',
  `fileName` varchar(50) NOT NULL DEFAULT '',
  `classNameTrack` varchar(255) NOT NULL DEFAULT '',
  `fileNameTrack` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`objectType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_lo_types`
--

INSERT INTO `learning_lo_types` VALUES('faq', 'Learning_Faq', 'learning.faq.php', 'Track_Faq', 'track.faq.php');
INSERT INTO `learning_lo_types` VALUES('glossary', 'Learning_Glossary', 'learning.glossary.php', 'Track_Glossary', 'track.glossary.php');
INSERT INTO `learning_lo_types` VALUES('htmlpage', 'Learning_Htmlpage', 'learning.htmlpage.php', 'Track_Htmlpage', 'track.htmlpage.php');
INSERT INTO `learning_lo_types` VALUES('item', 'Learning_Item', 'learning.item.php', 'Track_Item', 'track.item.php');
INSERT INTO `learning_lo_types` VALUES('link', 'Learning_Link', 'learning.link.php', 'Track_Link', 'track.link.php');
INSERT INTO `learning_lo_types` VALUES('poll', 'Learning_Poll', 'learning.poll.php', 'Track_Poll', 'track.poll.php');
INSERT INTO `learning_lo_types` VALUES('scormorg', 'Learning_ScormOrg', 'learning.scorm.php', 'Track_Scormorg', 'track.scorm.php');
INSERT INTO `learning_lo_types` VALUES('test', 'Learning_Test', 'learning.test.php', 'Track_Test', 'track.test.php');

-- --------------------------------------------------------

--
-- Table structure for table `learning_materials_lesson`
--

CREATE TABLE `learning_materials_lesson` (
  `idLesson` int(11) NOT NULL AUTO_INCREMENT,
  `author` int(11) NOT NULL DEFAULT '0',
  `title` varchar(100) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `path` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`idLesson`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_materials_lesson`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_materials_track`
--

CREATE TABLE `learning_materials_track` (
  `idTrack` int(11) NOT NULL AUTO_INCREMENT,
  `idResource` int(11) NOT NULL DEFAULT '0',
  `idReference` int(11) NOT NULL DEFAULT '0',
  `idUser` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idTrack`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_materials_track`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_menu`
--

CREATE TABLE `learning_menu` (
  `idMenu` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL DEFAULT '',
  `sequence` int(3) NOT NULL DEFAULT '0',
  `collapse` enum('true','false') NOT NULL DEFAULT 'false',
  PRIMARY KEY (`idMenu`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

--
-- Dumping data for table `learning_menu`
--

INSERT INTO `learning_menu` VALUES(1, '_MANAGEMENT_COURSE', '', 1, 'false');
INSERT INTO `learning_menu` VALUES(2, '', '', 2, 'true');
INSERT INTO `learning_menu` VALUES(3, '_ASSESSMENT', '', 3, 'false');
INSERT INTO `learning_menu` VALUES(4, '', '', 4, 'true');
INSERT INTO `learning_menu` VALUES(5, '', '', 5, 'true');
INSERT INTO `learning_menu` VALUES(6, '_CONTENTS', '', 6, 'false');
INSERT INTO `learning_menu` VALUES(7, '_MAN_CERTIFICATE', '', 7, 'false');
INSERT INTO `learning_menu` VALUES(8, '_MANAGEMENT_RESERVATION', '', 8, 'false');
INSERT INTO `learning_menu` VALUES(9, '_CONFIGURATION', '', 9, 'false');
INSERT INTO `learning_menu` VALUES(10, '', '', 10, 'true');
INSERT INTO `learning_menu` VALUES(11, '', '', 11, 'true');
INSERT INTO `learning_menu` VALUES(12, '', '', 12, 'true');
INSERT INTO `learning_menu` VALUES(13, '', '', 13, 'true');
INSERT INTO `learning_menu` VALUES(14, '', '', 14, 'true');

-- --------------------------------------------------------

--
-- Table structure for table `learning_menucourse_main`
--

CREATE TABLE `learning_menucourse_main` (
  `idMain` int(11) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `sequence` int(3) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`idMain`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_menucourse_main`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_menucourse_under`
--

CREATE TABLE `learning_menucourse_under` (
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `idModule` int(11) NOT NULL DEFAULT '0',
  `idMain` int(11) NOT NULL DEFAULT '0',
  `sequence` int(3) NOT NULL DEFAULT '0',
  `my_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`idCourse`,`idModule`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_menucourse_under`
--

INSERT INTO `learning_menucourse_under` VALUES(0, 1, 0, 1, '');
INSERT INTO `learning_menucourse_under` VALUES(0, 2, 0, 2, '');
INSERT INTO `learning_menucourse_under` VALUES(0, 3, 0, 3, '');
INSERT INTO `learning_menucourse_under` VALUES(0, 4, 0, 4, '');
INSERT INTO `learning_menucourse_under` VALUES(0, 5, 0, 5, '');
INSERT INTO `learning_menucourse_under` VALUES(0, 6, 0, 6, '');
INSERT INTO `learning_menucourse_under` VALUES(0, 7, 0, 2, '');
INSERT INTO `learning_menucourse_under` VALUES(0, 8, 0, 8, '');
INSERT INTO `learning_menucourse_under` VALUES(0, 9, 0, 9, '');
INSERT INTO `learning_menucourse_under` VALUES(0, 32, 0, 4, '');
INSERT INTO `learning_menucourse_under` VALUES(0, 33, 5, 11, '');
INSERT INTO `learning_menucourse_under` VALUES(0, 34, 0, 3, '');
INSERT INTO `learning_menucourse_under` VALUES(0, 35, 1, 1, '');
INSERT INTO `learning_menucourse_under` VALUES(0, 36, 1, 2, '');
INSERT INTO `learning_menucourse_under` VALUES(0, 37, 1, 3, '');
INSERT INTO `learning_menucourse_under` VALUES(0, 38, 1, 4, '');
INSERT INTO `learning_menucourse_under` VALUES(0, 39, 1, 5, '');

-- --------------------------------------------------------

--
-- Table structure for table `learning_menucustom`
--

CREATE TABLE `learning_menucustom` (
  `idCustom` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  PRIMARY KEY (`idCustom`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=22 ;

--
-- Dumping data for table `learning_menucustom`
--

INSERT INTO `learning_menucustom` VALUES(11, 'Collaboration', 'Menu with standard collaboration features');
INSERT INTO `learning_menucustom` VALUES(21, 'Self - Training', 'Training based on multimedia content');

-- --------------------------------------------------------

--
-- Table structure for table `learning_menucustom_main`
--

CREATE TABLE `learning_menucustom_main` (
  `idMain` int(11) NOT NULL AUTO_INCREMENT,
  `idCustom` int(11) NOT NULL DEFAULT '0',
  `sequence` int(3) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`idMain`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=44 ;

--
-- Dumping data for table `learning_menucustom_main`
--

INSERT INTO `learning_menucustom_main` VALUES(25, 11, 1, 'Student Area', '');
INSERT INTO `learning_menucustom_main` VALUES(26, 11, 3, 'Teacher Area', '');
INSERT INTO `learning_menucustom_main` VALUES(27, 11, 4, 'Stat Area', '');
INSERT INTO `learning_menucustom_main` VALUES(41, 11, 2, 'Collaborative Area', '');
INSERT INTO `learning_menucustom_main` VALUES(42, 21, 1, 'Student Area', '');
INSERT INTO `learning_menucustom_main` VALUES(43, 21, 2, 'Teacher', '');

-- --------------------------------------------------------

--
-- Table structure for table `learning_menucustom_under`
--

CREATE TABLE `learning_menucustom_under` (
  `idCustom` int(11) NOT NULL DEFAULT '0',
  `idModule` int(11) NOT NULL DEFAULT '0',
  `idMain` int(11) NOT NULL DEFAULT '0',
  `sequence` int(3) NOT NULL DEFAULT '0',
  `my_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`idCustom`,`idModule`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_menucustom_under`
--

INSERT INTO `learning_menucustom_under` VALUES(0, 1, 0, 1, '');
INSERT INTO `learning_menucustom_under` VALUES(0, 2, 0, 2, '');
INSERT INTO `learning_menucustom_under` VALUES(0, 3, 0, 3, '');
INSERT INTO `learning_menucustom_under` VALUES(0, 4, 0, 4, '');
INSERT INTO `learning_menucustom_under` VALUES(0, 5, 0, 5, '');
INSERT INTO `learning_menucustom_under` VALUES(0, 6, 0, 6, '');
INSERT INTO `learning_menucustom_under` VALUES(0, 7, 0, 7, '');
INSERT INTO `learning_menucustom_under` VALUES(0, 8, 0, 8, '');
INSERT INTO `learning_menucustom_under` VALUES(0, 9, 0, 9, '');
INSERT INTO `learning_menucustom_under` VALUES(0, 32, 0, 10, '');
INSERT INTO `learning_menucustom_under` VALUES(0, 33, 0, 11, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 11, 25, 2, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 12, 26, 1, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 13, 25, 4, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 14, 25, 5, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 15, 25, 8, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 17, 41, 6, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 19, 41, 1, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 20, 41, 2, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 21, 41, 5, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 22, 41, 4, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 23, 41, 3, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 24, 26, 2, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 25, 25, 3, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 26, 26, 5, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 27, 26, 3, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 29, 27, 1, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 30, 27, 2, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 31, 27, 3, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 41, 27, 17, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 42, 27, 18, '');
INSERT INTO `learning_menucustom_under` VALUES(11, 43, 26, 16, '');
INSERT INTO `learning_menucustom_under` VALUES(21, 12, 43, 1, '');
INSERT INTO `learning_menucustom_under` VALUES(21, 14, 42, 2, '');
INSERT INTO `learning_menucustom_under` VALUES(21, 25, 42, 1, '');
INSERT INTO `learning_menucustom_under` VALUES(21, 26, 43, 2, '');
INSERT INTO `learning_menucustom_under` VALUES(21, 29, 43, 6, '');
INSERT INTO `learning_menucustom_under` VALUES(21, 30, 43, 7, '');
INSERT INTO `learning_menucustom_under` VALUES(21, 31, 43, 5, '');
INSERT INTO `learning_menucustom_under` VALUES(21, 41, 43, 3, '');
INSERT INTO `learning_menucustom_under` VALUES(21, 42, 43, 4, '');

-- --------------------------------------------------------

--
-- Table structure for table `learning_menu_under`
--

CREATE TABLE `learning_menu_under` (
  `idUnder` int(11) NOT NULL AUTO_INCREMENT,
  `idMenu` int(11) NOT NULL DEFAULT '0',
  `module_name` varchar(255) NOT NULL DEFAULT '',
  `default_name` varchar(255) NOT NULL DEFAULT '',
  `default_op` varchar(255) NOT NULL DEFAULT '',
  `associated_token` varchar(255) NOT NULL DEFAULT '',
  `of_platform` varchar(255) DEFAULT NULL,
  `sequence` int(3) NOT NULL DEFAULT '0',
  `class_file` varchar(255) NOT NULL DEFAULT '',
  `class_name` varchar(255) NOT NULL DEFAULT '',
  `mvc_path` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`idUnder`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=34 ;

--
-- Dumping data for table `learning_menu_under`
--

INSERT INTO `learning_menu_under` VALUES(1, 1, 'course', '_COURSE', '', 'view', NULL, 1, '', '', 'alms/course/show');
INSERT INTO `learning_menu_under` VALUES(2, 9, 'amanmenu', '_MAN_MENU', 'mancustom', 'view', NULL, 1, 'class.amanmenu.php', 'Module_AManmenu', '');
INSERT INTO `learning_menu_under` VALUES(3, 1, 'coursepath', '_COURSEPATH', 'pathlist', 'view', NULL, 2, 'class.coursepath.php', 'Module_Coursepath', '');
INSERT INTO `learning_menu_under` VALUES(4, 1, 'catalogue', '_CATALOGUE', 'catlist', 'view', NULL, 3, 'class.catalogue.php', 'Module_Catalogue', '');
INSERT INTO `learning_menu_under` VALUES(5, 6, 'webpages', '_WEBPAGES', 'webpages', 'view', NULL, 1, 'class.webpages.php', 'Module_Webpages', '');
INSERT INTO `learning_menu_under` VALUES(6, 6, 'news', '_NEWS', 'news', 'view', NULL, 2, 'class.news.php', 'Module_News', '');
INSERT INTO `learning_menu_under` VALUES(7, 9, 'questcategory', '_QUESTCATEGORY', '', 'view', NULL, 4, '', '', 'alms/questcategory/show');
INSERT INTO `learning_menu_under` VALUES(9, 11, 'report', '_REPORT', 'reportlist', 'view', NULL, 1, 'class.report.php', 'Module_Report', '');
INSERT INTO `learning_menu_under` VALUES(10, 3, 'preassessment', '_ASSESSMENT', 'assesmentlist', 'view', NULL, 1, 'class.preassessment.php', 'Module_PreAssessment', '');
INSERT INTO `learning_menu_under` VALUES(14, 7, 'certificate', '_CERTIFICATE', 'certificate', 'view', NULL, 1, 'class.certificate.php', 'Module_Certificate', '');
INSERT INTO `learning_menu_under` VALUES(17, 8, 'reservation', '_EVENTS', 'view_event', 'view', NULL, 1, 'class.reservation.php', 'Module_Reservation', '');
INSERT INTO `learning_menu_under` VALUES(18, 8, 'reservation', '_CATEGORY', 'view_category', 'view', NULL, 2, 'class.reservation.php', 'Module_Reservation', '');
INSERT INTO `learning_menu_under` VALUES(20, 8, 'reservation', '_RESERVATION', 'view_registration', 'view', NULL, 3, 'class.reservation.php', 'Module_Reservation', '');
INSERT INTO `learning_menu_under` VALUES(21, 9, 'middlearea', '_MIDDLE_AREA', 'view_area', 'view', NULL, 2, 'class.middlearea.php', 'Module_MiddleArea', '');
INSERT INTO `learning_menu_under` VALUES(22, 6, 'internal_news', '_NEWS_INTERNAL', 'news', 'view', NULL, 3, 'class.internal_news.php', 'Module_Internal_News', '');
INSERT INTO `learning_menu_under` VALUES(23, 7, 'meta_certificate', '_META_CERTIFICATE', 'meta_certificate', 'view', NULL, 3, 'class.meta_certificate.php', 'Module_Meta_Certificate', '');
INSERT INTO `learning_menu_under` VALUES(26, 14, 'transaction', '_TRANSACTION', '', 'view', NULL, 1, '', '', 'alms/transaction/show');
INSERT INTO `learning_menu_under` VALUES(27, 2, 'location', '_LOCATION', '', 'view', NULL, 1, '', '', 'alms/location/show');
INSERT INTO `learning_menu_under` VALUES(28, 4, 'games', '_CONTEST', '', 'view', NULL, 1, '', '', 'alms/games/show');
INSERT INTO `learning_menu_under` VALUES(29, 5, 'communication', '_COMMUNICATION_MAN', '', 'view', NULL, 1, '', '', 'alms/communication/show');
INSERT INTO `learning_menu_under` VALUES(30, 12, 'kb', '_CONTENT_LIBRARY', '', 'view', NULL, 1, '', '', 'alms/kb/show');
INSERT INTO `learning_menu_under` VALUES(31, 9, 'timeperiods', '_TIME_PERIODS', '', 'view', NULL, 5, '', '', 'alms/timeperiods/show');
INSERT INTO `learning_menu_under` VALUES(32, 13, 'enrollrules', '_ENROLLRULES', '', 'view', NULL, 1, '', '', 'alms/enrollrules/show');
INSERT INTO `learning_menu_under` VALUES(33, 9, 'label', '_LABEL', '', 'view', NULL, 5, '', '', 'alms/label/show');

-- --------------------------------------------------------

--
-- Table structure for table `learning_middlearea`
--

CREATE TABLE `learning_middlearea` (
  `obj_index` varchar(255) NOT NULL DEFAULT '',
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `idst_list` text NOT NULL,
  PRIMARY KEY (`obj_index`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_middlearea`
--

INSERT INTO `learning_middlearea` VALUES('credits', 1, 'a:0:{}');
INSERT INTO `learning_middlearea` VALUES('mo_32', 1, 'a:0:{}');
INSERT INTO `learning_middlearea` VALUES('mo_33', 1, 'a:0:{}');
INSERT INTO `learning_middlearea` VALUES('mo_34', 1, 'a:0:{}');
INSERT INTO `learning_middlearea` VALUES('mo_help', 1, 'a:0:{}');
INSERT INTO `learning_middlearea` VALUES('tb_assessment', 1, 'a:0:{}');
INSERT INTO `learning_middlearea` VALUES('tb_catalog', 1, 'a:0:{}');
INSERT INTO `learning_middlearea` VALUES('tb_classroom', 1, 'a:0:{}');
INSERT INTO `learning_middlearea` VALUES('tb_communication', 1, 'a:0:{}');
INSERT INTO `learning_middlearea` VALUES('tb_coursepath', 1, 'a:0:{}');
INSERT INTO `learning_middlearea` VALUES('tb_games', 1, 'a:0:{}');
INSERT INTO `learning_middlearea` VALUES('tb_label', 1, 'a:0:{}');
INSERT INTO `learning_middlearea` VALUES('tb_videoconference', 1, 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `learning_module`
--

CREATE TABLE `learning_module` (
  `idModule` int(11) NOT NULL AUTO_INCREMENT,
  `module_name` varchar(255) NOT NULL DEFAULT '',
  `default_op` varchar(255) NOT NULL DEFAULT '',
  `default_name` varchar(255) NOT NULL DEFAULT '',
  `token_associated` varchar(100) NOT NULL DEFAULT '',
  `file_name` varchar(255) NOT NULL DEFAULT '',
  `class_name` varchar(255) NOT NULL DEFAULT '',
  `module_info` varchar(50) NOT NULL DEFAULT '',
  `mvc_path` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`idModule`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=46 ;

--
-- Dumping data for table `learning_module`
--

INSERT INTO `learning_module` VALUES(1, 'course', '', '_MYCOURSES', 'view', '', '', 'all', 'elearning/show');
INSERT INTO `learning_module` VALUES(3, 'profile', 'profile', '_PROFILE', 'view', 'class.profile.php', 'Module_Profile', '_user', '');
INSERT INTO `learning_module` VALUES(7, 'mycertificate', 'mycertificate', '_MY_CERTIFICATE', 'view', 'class.mycertificate.php', 'Module_MyCertificate', 'all', '');
INSERT INTO `learning_module` VALUES(10, 'course', 'infocourse', '_INFCOURSE', 'view_info', 'class.course.php', 'Module_Course', '', '');
INSERT INTO `learning_module` VALUES(11, 'advice', 'advice', '_ADVICE', 'view', 'class.advice.php', 'Module_Advice', '', '');
INSERT INTO `learning_module` VALUES(12, 'storage', 'display', '_STORAGE', 'view', 'class.storage.php', 'Module_Storage', '', '');
INSERT INTO `learning_module` VALUES(13, 'calendar', 'calendar', '_CALENDAR', 'view', 'class.calendar.php', 'Module_Calendar', '', '');
INSERT INTO `learning_module` VALUES(14, 'gradebook', 'showgrade', '_GRADEBOOK', 'view', 'class.gradebook.php', 'Module_Gradebook', '', '');
INSERT INTO `learning_module` VALUES(15, 'notes', 'notes', '_NOTES', 'view', 'class.notes.php', 'Module_Notes', '', '');
INSERT INTO `learning_module` VALUES(16, 'reservation', 'reservation', '_RESERVATION', 'view', 'class.reservation.php', 'Module_Reservation', '', '');
INSERT INTO `learning_module` VALUES(17, 'light_repo', 'repolist', '_LIGHT_REPO', 'view', 'class.light_repo.php', 'Module_Light_Repo', '', '');
INSERT INTO `learning_module` VALUES(18, 'htmlfront', 'showhtml', '_HTMLFRONT', 'view', 'class.htmlfront.php', 'Module_Htmlfront', '', '');
INSERT INTO `learning_module` VALUES(19, 'forum', 'forum', '_FORUM', 'view', 'class.forum.php', 'Module_Forum', '', '');
INSERT INTO `learning_module` VALUES(20, 'wiki', 'main', '_WIKI', 'view', 'class.wiki.php', 'Module_Wiki', '', '');
INSERT INTO `learning_module` VALUES(21, 'chat', 'chat', '_CHAT', 'view', 'class.chat.php', 'Module_Chat', '', '');
INSERT INTO `learning_module` VALUES(22, 'conference', 'list', '_VIDEOCONFERENCE', 'view', 'class.conference.php', 'Module_Conference', '', '');
INSERT INTO `learning_module` VALUES(23, 'project', 'project', '_PROJECT', 'view', 'class.project.php', 'Module_Project', '', '');
INSERT INTO `learning_module` VALUES(24, 'groups', 'groups', '_GROUPS', 'view', 'class.groups.php', 'Module_Groups', '', '');
INSERT INTO `learning_module` VALUES(25, 'organization', 'organization', '_ORGANIZATION', 'view', 'class.organization.php', 'Module_Organization', '', '');
INSERT INTO `learning_module` VALUES(26, 'coursereport', 'coursereport', '_COURSEREPORT', 'view', 'class.coursereport.php', 'Module_CourseReport', '', '');
INSERT INTO `learning_module` VALUES(27, 'newsletter', 'view', '_NEWSLETTER', 'view', 'class.newsletter.php', 'Module_Newsletter', '', '');
INSERT INTO `learning_module` VALUES(28, 'manmenu', 'manmenu', '_MAN_MENU', 'view', 'class.manmenu.php', 'Module_CourseManmenu', '', '');
INSERT INTO `learning_module` VALUES(29, 'statistic', 'statistic', '_STAT', 'view', 'class.statistic.php', 'Module_Statistic', '', '');
INSERT INTO `learning_module` VALUES(30, 'stats', 'statuser', '_STATUSER', 'view_user', 'class.stats.php', 'Module_Stats', '', '');
INSERT INTO `learning_module` VALUES(31, 'stats', 'statcourse', '_STATCOURSE', 'view_course', 'class.stats.php', 'Module_Stats', '', '');
INSERT INTO `learning_module` VALUES(32, 'public_forum', 'forum', '_PUBLIC_FORUM', 'view', 'class.public_forum.php', 'Module_Public_Forum', 'all', '');
INSERT INTO `learning_module` VALUES(33, 'course_autoregistration', 'course_autoregistration', '_COURSE_AUTOREGISTRATION', 'view', 'class.course_autoregistration.php', 'Module_Course_Autoregistration', 'all', '');
INSERT INTO `learning_module` VALUES(34, 'mycompetences', 'mycompetences', '_MYCOMPETENCES', 'view', 'class.mycompetences.php', 'Module_MyCompetences', 'all', '');
INSERT INTO `learning_module` VALUES(35, 'pusermanagement', '', '_PUBLIC_USER_ADMIN', 'view', '', '', 'public_admin', 'lms/pusermanagement/show');
INSERT INTO `learning_module` VALUES(36, 'pcourse', '', '_PUBLIC_COURSE_ADMIN', 'view', '', '', 'public_admin', 'lms/pcourse/show');
INSERT INTO `learning_module` VALUES(38, 'public_report_admin', 'reportlist', '_PUBLIC_REPORT_ADMIN', 'view', 'class.public_report_admin.php', 'Module_Public_Report_Admin', 'public_admin', '');
INSERT INTO `learning_module` VALUES(39, 'public_newsletter_admin', 'newsletter', '_PUBLIC_NEWSLETTER_ADMIN', 'view', 'class.public_newsletter_admin.php', 'Module_Public_Newsletter_Admin', 'public_admin', '');
INSERT INTO `learning_module` VALUES(40, 'quest_bank', 'main', '_QUEST_BANK', 'view', 'class.quest_bank.php', 'Module_QuestBank', '', '');
INSERT INTO `learning_module` VALUES(41, 'coursecharts', 'show', '_COURSECHART', 'view', 'class.coursecharts.php', 'Module_Coursecharts', '', 'coursecharts/show');
INSERT INTO `learning_module` VALUES(42, 'coursestats', 'show', '_COURSESTATS', 'view', '', '', '', 'coursestats/show');
INSERT INTO `learning_module` VALUES(44, 'pcertificate', 'certificate', '_PUBLIC_CERTIFICATE_ADMIN', 'view', 'class.pcertificate.php', 'Module_Pcertificate', 'public_admin', '');
INSERT INTO `learning_module` VALUES(45, 'presence', '', '_PRESENCE', 'view', '', '', '', 'presence/presence');

-- --------------------------------------------------------

--
-- Table structure for table `learning_news`
--

CREATE TABLE `learning_news` (
  `idNews` int(11) NOT NULL AUTO_INCREMENT,
  `publish_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `title` varchar(100) NOT NULL DEFAULT '',
  `short_desc` text NOT NULL,
  `long_desc` text NOT NULL,
  `language` varchar(100) NOT NULL DEFAULT '',
  `important` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idNews`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_news`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_news_internal`
--

CREATE TABLE `learning_news_internal` (
  `idNews` int(11) NOT NULL AUTO_INCREMENT,
  `publish_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `title` varchar(100) NOT NULL DEFAULT '',
  `short_desc` text NOT NULL,
  `long_desc` text NOT NULL,
  `language` varchar(100) NOT NULL DEFAULT '',
  `important` tinyint(1) NOT NULL DEFAULT '0',
  `viewer` longtext NOT NULL,
  PRIMARY KEY (`idNews`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_news_internal`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_notes`
--

CREATE TABLE `learning_notes` (
  `idNotes` int(11) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `owner` int(11) NOT NULL DEFAULT '0',
  `data` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `title` varchar(150) NOT NULL DEFAULT '',
  `textof` text NOT NULL,
  PRIMARY KEY (`idNotes`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_notes`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_organization`
--

CREATE TABLE `learning_organization` (
  `idOrg` int(11) NOT NULL AUTO_INCREMENT,
  `idParent` int(11) NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `lev` int(10) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `objectType` varchar(20) NOT NULL DEFAULT '',
  `idResource` int(11) NOT NULL DEFAULT '0',
  `idCategory` int(11) NOT NULL DEFAULT '0',
  `idUser` int(11) NOT NULL DEFAULT '0',
  `idAuthor` int(11) NOT NULL DEFAULT '0',
  `version` varchar(8) NOT NULL DEFAULT '',
  `difficult` enum('_VERYEASY','_EASY','_MEDIUM','_DIFFICULT','_VERYDIFFICULT') NOT NULL DEFAULT '_VERYEASY',
  `description` text NOT NULL,
  `language` varchar(50) NOT NULL DEFAULT '',
  `resource` varchar(255) NOT NULL DEFAULT '',
  `objective` text NOT NULL,
  `dateInsert` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `prerequisites` varchar(255) NOT NULL DEFAULT '',
  `isTerminator` tinyint(4) NOT NULL DEFAULT '0',
  `idParam` int(11) NOT NULL DEFAULT '0',
  `visible` tinyint(4) NOT NULL DEFAULT '1',
  `milestone` enum('start','end','-') NOT NULL DEFAULT '-',
  `width` varchar(4) NOT NULL DEFAULT '',
  `height` varchar(4) NOT NULL DEFAULT '',
  `publish_from` datetime DEFAULT NULL,
  `publish_to` datetime DEFAULT NULL,
  `access` varchar(255) DEFAULT NULL,
  `publish_for` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idOrg`),
  KEY `idParent` (`idParent`),
  KEY `path` (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_organization`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_organization_access`
--

CREATE TABLE `learning_organization_access` (
  `idOrgAccess` int(11) NOT NULL DEFAULT '0',
  `kind` set('user','group') NOT NULL DEFAULT '',
  `value` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idOrgAccess`,`kind`,`value`),
  KEY `idObject` (`idOrgAccess`),
  KEY `kind` (`kind`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Access to items in area lesson (organization)';

--
-- Dumping data for table `learning_organization_access`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_poll`
--

CREATE TABLE `learning_poll` (
  `id_poll` int(11) NOT NULL AUTO_INCREMENT,
  `author` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  PRIMARY KEY (`id_poll`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_poll`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_pollquest`
--

CREATE TABLE `learning_pollquest` (
  `id_quest` int(11) NOT NULL AUTO_INCREMENT,
  `id_poll` int(11) NOT NULL DEFAULT '0',
  `id_category` int(11) NOT NULL DEFAULT '0',
  `type_quest` varchar(255) NOT NULL DEFAULT '',
  `title_quest` text NOT NULL,
  `sequence` int(5) NOT NULL DEFAULT '0',
  `page` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_quest`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_pollquest`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_pollquestanswer`
--

CREATE TABLE `learning_pollquestanswer` (
  `id_answer` int(11) NOT NULL AUTO_INCREMENT,
  `id_quest` int(11) NOT NULL DEFAULT '0',
  `sequence` int(11) NOT NULL DEFAULT '0',
  `answer` text NOT NULL,
  PRIMARY KEY (`id_answer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_pollquestanswer`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_pollquest_extra`
--

CREATE TABLE `learning_pollquest_extra` (
  `id_quest` int(11) NOT NULL DEFAULT '0',
  `id_answer` int(11) NOT NULL DEFAULT '0',
  `extra_info` text NOT NULL,
  PRIMARY KEY (`id_quest`,`id_answer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_pollquest_extra`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_polltrack`
--

CREATE TABLE `learning_polltrack` (
  `id_track` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `id_reference` int(11) NOT NULL DEFAULT '0',
  `id_poll` int(11) NOT NULL DEFAULT '0',
  `date_attempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` enum('valid','not_complete') NOT NULL DEFAULT 'not_complete',
  PRIMARY KEY (`id_track`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_polltrack`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_polltrack_answer`
--

CREATE TABLE `learning_polltrack_answer` (
  `id_track` int(11) NOT NULL DEFAULT '0',
  `id_quest` int(11) NOT NULL DEFAULT '0',
  `id_answer` int(11) NOT NULL DEFAULT '0',
  `more_info` longtext NOT NULL,
  PRIMARY KEY (`id_track`,`id_quest`,`id_answer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_polltrack_answer`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_prj`
--

CREATE TABLE `learning_prj` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ptitle` varchar(255) NOT NULL DEFAULT '',
  `pgroup` int(11) NOT NULL DEFAULT '0',
  `pprog` tinyint(3) NOT NULL DEFAULT '0',
  `psfiles` tinyint(1) NOT NULL DEFAULT '0',
  `pstasks` tinyint(1) NOT NULL DEFAULT '0',
  `psnews` tinyint(1) NOT NULL DEFAULT '0',
  `pstodo` tinyint(1) NOT NULL DEFAULT '0',
  `psmsg` tinyint(1) NOT NULL DEFAULT '0',
  `cid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_prj`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_prj_files`
--

CREATE TABLE `learning_prj_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `fname` varchar(255) NOT NULL DEFAULT '',
  `ftitle` varchar(255) NOT NULL DEFAULT '',
  `fver` varchar(255) NOT NULL DEFAULT '',
  `fdesc` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_prj_files`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_prj_news`
--

CREATE TABLE `learning_prj_news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `ntitle` varchar(255) NOT NULL DEFAULT '',
  `ndate` date NOT NULL DEFAULT '0000-00-00',
  `ntxt` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_prj_news`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_prj_tasks`
--

CREATE TABLE `learning_prj_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `tprog` tinyint(3) NOT NULL DEFAULT '0',
  `tname` varchar(255) NOT NULL DEFAULT '',
  `tdesc` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_prj_tasks`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_prj_todo`
--

CREATE TABLE `learning_prj_todo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `ttitle` varchar(255) NOT NULL DEFAULT '',
  `ttxt` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_prj_todo`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_prj_users`
--

CREATE TABLE `learning_prj_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  `flag` tinyint(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_prj_users`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_quest_category`
--

CREATE TABLE `learning_quest_category` (
  `idCategory` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `textof` text NOT NULL,
  `author` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idCategory`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_quest_category`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_quest_type`
--

CREATE TABLE `learning_quest_type` (
  `type_quest` varchar(255) NOT NULL DEFAULT '',
  `type_file` varchar(255) NOT NULL DEFAULT '',
  `type_class` varchar(255) NOT NULL DEFAULT '',
  `sequence` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`type_quest`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_quest_type`
--

INSERT INTO `learning_quest_type` VALUES('associate', 'class.associate.php', 'Associate_Question', 8);
INSERT INTO `learning_quest_type` VALUES('break_page', 'class.break_page.php', 'BreakPage_Question', 10);
INSERT INTO `learning_quest_type` VALUES('choice', 'class.choice.php', 'Choice_Question', 1);
INSERT INTO `learning_quest_type` VALUES('choice_multiple', 'class.choice_multiple.php', 'ChoiceMultiple_Question', 2);
INSERT INTO `learning_quest_type` VALUES('extended_text', 'class.extended_text.php', 'ExtendedText_Question', 3);
INSERT INTO `learning_quest_type` VALUES('hot_text', 'class.hot_text.php', 'HotText_Question', 6);
INSERT INTO `learning_quest_type` VALUES('inline_choice', 'class.inline_choice.php', 'InlineChoice_Question', 5);
INSERT INTO `learning_quest_type` VALUES('text_entry', 'class.text_entry.php', 'TextEntry_Question', 4);
INSERT INTO `learning_quest_type` VALUES('title', 'class.title.php', 'Title_Question', 9);
INSERT INTO `learning_quest_type` VALUES('upload', 'class.upload.php', 'Upload_Question', 7);

-- --------------------------------------------------------

--
-- Table structure for table `learning_quest_type_poll`
--

CREATE TABLE `learning_quest_type_poll` (
  `type_quest` varchar(255) NOT NULL DEFAULT '',
  `type_file` varchar(255) NOT NULL DEFAULT '',
  `type_class` varchar(255) NOT NULL DEFAULT '',
  `sequence` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`type_quest`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_quest_type_poll`
--

INSERT INTO `learning_quest_type_poll` VALUES('break_page', 'class.break_page.php', 'BreakPage_QuestionPoll', 7);
INSERT INTO `learning_quest_type_poll` VALUES('choice', 'class.choice.php', 'Choice_QuestionPoll', 1);
INSERT INTO `learning_quest_type_poll` VALUES('choice_multiple', 'class.choice_multiple.php', 'ChoiceMultiple_QuestionPoll', 2);
INSERT INTO `learning_quest_type_poll` VALUES('course_valutation', 'class.course_valutation.php', 'CourseValutation_QuestionPoll', 5);
INSERT INTO `learning_quest_type_poll` VALUES('doc_valutation', 'class.doc_valutation.php', 'DocValutation_QuestionPoll', 4);
INSERT INTO `learning_quest_type_poll` VALUES('extended_text', 'class.extended_text.php', 'ExtendedText_QuestionPoll', 3);
INSERT INTO `learning_quest_type_poll` VALUES('title', 'class.title.php', 'Title_QuestionPoll', 6);

-- --------------------------------------------------------

--
-- Table structure for table `learning_repo`
--

CREATE TABLE `learning_repo` (
  `idRepo` int(11) NOT NULL AUTO_INCREMENT,
  `idParent` int(11) NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `lev` int(10) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `objectType` varchar(20) NOT NULL DEFAULT '',
  `idResource` int(11) NOT NULL DEFAULT '0',
  `idCategory` int(11) NOT NULL DEFAULT '0',
  `idUser` int(11) NOT NULL DEFAULT '0',
  `idAuthor` varchar(11) NOT NULL DEFAULT '0',
  `version` varchar(8) NOT NULL DEFAULT '',
  `difficult` enum('_VERYEASY','_EASY','_MEDIUM','_DIFFICULT','_VERYDIFFICULT') NOT NULL DEFAULT '_VERYEASY',
  `description` text NOT NULL,
  `language` varchar(50) NOT NULL DEFAULT '',
  `resource` varchar(255) NOT NULL DEFAULT '',
  `objective` text NOT NULL,
  `dateInsert` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`idRepo`),
  KEY `idParent` (`idParent`),
  KEY `path` (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_repo`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_report`
--

CREATE TABLE `learning_report` (
  `id_report` int(11) NOT NULL AUTO_INCREMENT,
  `report_name` varchar(255) NOT NULL DEFAULT '',
  `class_name` varchar(255) NOT NULL DEFAULT '',
  `file_name` varchar(255) NOT NULL DEFAULT '',
  `use_user_selection` enum('true','false') NOT NULL DEFAULT 'true',
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_report`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `learning_report`
--

INSERT INTO `learning_report` VALUES(2, 'user_report', 'Report_User', 'class.report_user.php', 'true', 1);
INSERT INTO `learning_report` VALUES(4, 'courses_report', 'Report_Courses', 'class.report_courses.php', 'true', 1);
INSERT INTO `learning_report` VALUES(5, 'aggregate_report', 'Report_Aggregate', 'class.report_aggregate.php', 'true', 1);

-- --------------------------------------------------------

--
-- Table structure for table `learning_report_filter`
--

CREATE TABLE `learning_report_filter` (
  `id_filter` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_report` int(10) unsigned NOT NULL DEFAULT '0',
  `author` int(10) unsigned NOT NULL DEFAULT '0',
  `creation_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `filter_name` varchar(255) NOT NULL DEFAULT '',
  `filter_data` text NOT NULL,
  `is_public` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `views` int(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_filter`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=28 ;

--
-- Dumping data for table `learning_report_filter`
--

INSERT INTO `learning_report_filter` VALUES(13, 4, 270, '0000-00-00 00:00:00', 'Courses - Users', 'a:5:{s:9:"id_report";s:1:"4";s:11:"report_name";s:15:"Courses - Users";s:11:"rows_filter";a:2:{s:11:"all_courses";b:1;s:16:"selected_courses";a:0:{}}s:23:"columns_filter_category";s:5:"users";s:14:"columns_filter";a:6:{s:9:"time_belt";a:3:{s:10:"time_range";s:1:"0";s:10:"start_date";s:0:"";s:8:"end_date";s:0:"";}s:21:"org_chart_subdivision";i:0;s:11:"showed_cols";a:7:{i:0;s:12:"_CODE_COURSE";i:1;s:12:"_NAME_COURSE";i:2;s:6:"_INSCR";i:3;s:10:"_MUSTBEGIN";i:4;s:18:"_USER_STATUS_BEGIN";i:5;s:15:"_COMPLETECOURSE";i:6;s:14:"_TOTAL_SESSION";}s:12:"show_percent";b:1;s:9:"all_users";b:1;s:5:"users";a:0:{}}}', 1, 0);
INSERT INTO `learning_report_filter` VALUES(25, 2, 270, '0000-00-00 00:00:00', 'Users - Courses', 'a:5:{s:9:"id_report";s:1:"2";s:11:"report_name";s:15:"Users - Courses";s:11:"rows_filter";a:2:{s:5:"users";a:0:{}s:9:"all_users";b:1;}s:23:"columns_filter_category";s:7:"courses";s:14:"columns_filter";a:7:{s:21:"org_chart_subdivision";i:0;s:11:"all_courses";b:1;s:16:"selected_courses";a:0:{}s:11:"sub_filters";a:0:{}s:16:"filter_exclusive";s:1:"1";s:14:"showed_columns";a:12:{i:0;s:8:"_TH_CODE";i:1;s:25:"_TH_USER_INSCRIPTION_DATE";i:2;s:19:"_TH_USER_START_DATE";i:3;s:17:"_TH_USER_END_DATE";i:4;s:20:"_TH_LAST_ACCESS_DATE";i:5;s:15:"_TH_USER_STATUS";i:6;s:20:"_TH_USER_START_SCORE";i:7;s:20:"_TH_USER_FINAL_SCORE";i:8;s:21:"_TH_USER_COURSE_SCORE";i:9;s:23:"_TH_USER_NUMBER_SESSION";i:10;s:21:"_TH_USER_ELAPSED_TIME";i:11;s:18:"_TH_ESTIMATED_TIME";}s:13:"custom_fields";a:0:{}}}', 1, 0);
INSERT INTO `learning_report_filter` VALUES(26, 2, 270, '0000-00-00 00:00:00', 'Users - Learning Objects', 'a:5:{s:9:"id_report";s:1:"2";s:11:"report_name";s:24:"Users - Learning Objects";s:11:"rows_filter";a:2:{s:5:"users";a:0:{}s:9:"all_users";b:1;}s:23:"columns_filter_category";s:2:"LO";s:14:"columns_filter";a:6:{s:11:"all_courses";b:1;s:16:"selected_courses";a:0:{}s:8:"lo_types";a:8:{s:3:"faq";s:3:"faq";s:8:"glossary";s:8:"glossary";s:8:"htmlpage";s:8:"htmlpage";s:4:"item";s:4:"item";s:4:"link";s:4:"link";s:4:"poll";s:4:"poll";s:8:"scormorg";s:8:"scormorg";s:4:"test";s:4:"test";}s:13:"lo_milestones";a:0:{}s:14:"showed_columns";a:8:{i:0;s:9:"user_name";i:1;s:11:"course_name";i:2;s:13:"course_status";i:3;s:7:"lo_type";i:4;s:7:"lo_name";i:5;s:12:"firstAttempt";i:6;s:11:"lastAttempt";i:7;s:9:"lo_status";}s:13:"custom_fields";a:0:{}}}', 1, 0);
INSERT INTO `learning_report_filter` VALUES(27, 2, 270, '0000-00-00 00:00:00', 'Users - 30 Days Delay', 'a:5:{s:9:"id_report";s:1:"2";s:11:"report_name";s:21:"Users - 30 Days Delay";s:11:"rows_filter";a:2:{s:5:"users";a:0:{}s:9:"all_users";b:1;}s:23:"columns_filter_category";s:5:"delay";s:14:"columns_filter";a:9:{s:21:"report_type_completed";b:1;s:19:"report_type_started";b:1;s:21:"day_from_subscription";s:2:"30";s:20:"day_until_course_end";s:0:"";s:21:"date_until_course_end";s:0:"";s:21:"org_chart_subdivision";i:0;s:11:"all_courses";b:1;s:16:"selected_courses";a:0:{}s:14:"showed_columns";a:7:{i:0;s:9:"_LASTNAME";i:1;s:5:"_NAME";i:2;s:7:"_STATUS";i:3;s:6:"_EMAIL";i:4;s:11:"_DATE_INSCR";i:5;s:18:"_DATE_FIRST_ACCESS";i:6;s:22:"_DATE_COURSE_COMPLETED";}}}', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `learning_report_schedule`
--

CREATE TABLE `learning_report_schedule` (
  `id_report_schedule` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id_report_filter` int(11) unsigned NOT NULL DEFAULT '0',
  `id_creator` int(11) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `period` varchar(255) NOT NULL DEFAULT '',
  `time` time NOT NULL DEFAULT '00:00:00',
  `creation_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_report_schedule`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_report_schedule`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_report_schedule_recipient`
--

CREATE TABLE `learning_report_schedule_recipient` (
  `id_report_schedule` int(11) unsigned NOT NULL DEFAULT '0',
  `id_user` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_report_schedule`,`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_report_schedule_recipient`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_reservation_category`
--

CREATE TABLE `learning_reservation_category` (
  `idCategory` int(11) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `maxSubscription` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idCategory`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_reservation_category`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_reservation_events`
--

CREATE TABLE `learning_reservation_events` (
  `idEvent` int(11) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `idLaboratory` int(11) NOT NULL DEFAULT '0',
  `idCategory` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` longtext,
  `date` date NOT NULL DEFAULT '0000-00-00',
  `maxUser` int(11) NOT NULL DEFAULT '0',
  `deadLine` date NOT NULL DEFAULT '0000-00-00',
  `fromTime` time NOT NULL DEFAULT '00:00:00',
  `toTime` time NOT NULL DEFAULT '00:00:00',
  PRIMARY KEY (`idEvent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_reservation_events`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_reservation_perm`
--

CREATE TABLE `learning_reservation_perm` (
  `event_id` int(11) NOT NULL DEFAULT '0',
  `user_idst` int(11) NOT NULL DEFAULT '0',
  `perm` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`event_id`,`user_idst`,`perm`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_reservation_perm`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_reservation_subscribed`
--

CREATE TABLE `learning_reservation_subscribed` (
  `idstUser` int(11) NOT NULL DEFAULT '0',
  `idEvent` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idstUser`,`idEvent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_reservation_subscribed`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_scorm_items`
--

CREATE TABLE `learning_scorm_items` (
  `idscorm_item` int(11) NOT NULL AUTO_INCREMENT,
  `idscorm_organization` int(11) NOT NULL DEFAULT '0',
  `idscorm_parentitem` int(11) DEFAULT NULL,
  `adlcp_prerequisites` varchar(200) DEFAULT NULL,
  `adlcp_maxtimeallowed` varchar(24) DEFAULT NULL,
  `adlcp_timelimitaction` varchar(24) DEFAULT NULL,
  `adlcp_datafromlms` varchar(255) DEFAULT NULL,
  `adlcp_masteryscore` varchar(200) DEFAULT NULL,
  `item_identifier` varchar(255) DEFAULT NULL,
  `identifierref` varchar(255) DEFAULT NULL,
  `idscorm_resource` int(11) DEFAULT NULL,
  `isvisible` set('true','false') DEFAULT 'true',
  `parameters` varchar(100) DEFAULT NULL,
  `title` varchar(100) NOT NULL DEFAULT '',
  `nChild` int(11) NOT NULL DEFAULT '0',
  `nDescendant` int(11) NOT NULL DEFAULT '0',
  `adlcp_completionthreshold` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`idscorm_item`),
  UNIQUE KEY `idscorm_organization` (`idscorm_organization`,`item_identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_scorm_items`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_scorm_items_track`
--

CREATE TABLE `learning_scorm_items_track` (
  `idscorm_item_track` int(11) NOT NULL AUTO_INCREMENT,
  `idscorm_organization` int(11) NOT NULL DEFAULT '0',
  `idscorm_item` int(11) DEFAULT NULL,
  `idReference` int(11) NOT NULL DEFAULT '0',
  `idUser` int(11) NOT NULL DEFAULT '0',
  `idscorm_tracking` int(11) DEFAULT NULL,
  `status` varchar(16) NOT NULL DEFAULT 'not attempted',
  `nChild` int(11) NOT NULL DEFAULT '0',
  `nChildCompleted` int(11) NOT NULL DEFAULT '0',
  `nDescendant` int(11) NOT NULL DEFAULT '0',
  `nDescendantCompleted` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idscorm_item_track`),
  KEY `idscorm_organization` (`idscorm_organization`),
  KEY `idscorm_item` (`idscorm_item`),
  KEY `idUser` (`idUser`),
  KEY `idscorm_tracking` (`idscorm_tracking`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Join table 3 factor' AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_scorm_items_track`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_scorm_organizations`
--

CREATE TABLE `learning_scorm_organizations` (
  `idscorm_organization` int(11) NOT NULL AUTO_INCREMENT,
  `org_identifier` varchar(255) NOT NULL DEFAULT '',
  `idscorm_package` int(11) NOT NULL DEFAULT '0',
  `title` varchar(100) DEFAULT NULL,
  `nChild` int(11) NOT NULL DEFAULT '0',
  `nDescendant` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idscorm_organization`),
  UNIQUE KEY `idsco_package_unique` (`org_identifier`,`idscorm_package`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_scorm_organizations`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_scorm_package`
--

CREATE TABLE `learning_scorm_package` (
  `idscorm_package` int(11) NOT NULL AUTO_INCREMENT,
  `idpackage` varchar(255) NOT NULL DEFAULT '',
  `idProg` int(11) NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `defaultOrg` varchar(255) NOT NULL DEFAULT '',
  `idUser` int(11) NOT NULL DEFAULT '0',
  `scormVersion` varchar(10) NOT NULL DEFAULT '1.2',
  PRIMARY KEY (`idscorm_package`),
  KEY `idUser` (`idUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_scorm_package`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_scorm_resources`
--

CREATE TABLE `learning_scorm_resources` (
  `idscorm_resource` int(11) NOT NULL AUTO_INCREMENT,
  `idsco` varchar(255) NOT NULL DEFAULT '',
  `idscorm_package` int(11) NOT NULL DEFAULT '0',
  `scormtype` set('sco','asset') DEFAULT NULL,
  `href` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`idscorm_resource`),
  UNIQUE KEY `idsco_package_unique` (`idsco`,`idscorm_package`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_scorm_resources`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_scorm_tracking`
--

CREATE TABLE `learning_scorm_tracking` (
  `idscorm_tracking` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL DEFAULT '0',
  `idReference` int(11) NOT NULL DEFAULT '0',
  `idscorm_item` int(11) NOT NULL DEFAULT '0',
  `user_name` varchar(255) DEFAULT NULL,
  `lesson_location` varchar(255) DEFAULT NULL,
  `credit` varchar(24) DEFAULT NULL,
  `lesson_status` varchar(24) DEFAULT NULL,
  `entry` varchar(24) DEFAULT NULL,
  `score_raw` float DEFAULT NULL,
  `score_max` float DEFAULT NULL,
  `score_min` float DEFAULT NULL,
  `total_time` varchar(15) DEFAULT '0000:00:00.00',
  `lesson_mode` varchar(24) DEFAULT NULL,
  `exit` varchar(24) DEFAULT NULL,
  `session_time` varchar(15) DEFAULT NULL,
  `suspend_data` blob,
  `launch_data` blob,
  `comments` blob,
  `comments_from_lms` blob,
  `xmldata` longblob,
  `first_access` datetime DEFAULT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`idscorm_tracking`),
  UNIQUE KEY `Unique_tracking_usersco` (`idUser`,`idReference`,`idscorm_item`),
  KEY `idUser` (`idUser`),
  KEY `idscorm_resource` (`idReference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_scorm_tracking`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_scorm_tracking_history`
--

CREATE TABLE `learning_scorm_tracking_history` (
  `idscorm_tracking` int(11) NOT NULL DEFAULT '0',
  `date_action` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `score_raw` float DEFAULT NULL,
  `score_max` float DEFAULT NULL,
  `session_time` varchar(15) DEFAULT NULL,
  `lesson_status` varchar(24) NOT NULL DEFAULT '',
  PRIMARY KEY (`idscorm_tracking`,`date_action`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_scorm_tracking_history`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_statuschangelog`
--

CREATE TABLE `learning_statuschangelog` (
  `idUser` int(11) NOT NULL DEFAULT '0',
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `status_user` tinyint(1) NOT NULL DEFAULT '0',
  `when_do` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`idUser`,`idCourse`,`when_do`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_statuschangelog`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_sysforum`
--

CREATE TABLE `learning_sysforum` (
  `idMessage` int(11) NOT NULL AUTO_INCREMENT,
  `key1` varchar(255) NOT NULL DEFAULT '',
  `key2` int(11) NOT NULL DEFAULT '0',
  `key3` int(11) DEFAULT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `textof` text NOT NULL,
  `posted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `author` int(11) NOT NULL DEFAULT '0',
  `attach` varchar(255) NOT NULL DEFAULT '',
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idMessage`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_sysforum`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_teacher_profile`
--

CREATE TABLE `learning_teacher_profile` (
  `id_user` int(11) NOT NULL DEFAULT '0',
  `curriculum` text NOT NULL,
  `publications` text NOT NULL,
  PRIMARY KEY (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_teacher_profile`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_test`
--

CREATE TABLE `learning_test` (
  `idTest` int(11) NOT NULL AUTO_INCREMENT,
  `author` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `point_type` tinyint(1) NOT NULL DEFAULT '0',
  `point_required` double NOT NULL DEFAULT '0',
  `display_type` tinyint(1) NOT NULL DEFAULT '0',
  `order_type` tinyint(1) NOT NULL DEFAULT '0',
  `shuffle_answer` tinyint(1) NOT NULL DEFAULT '0',
  `question_random_number` int(4) NOT NULL DEFAULT '0',
  `save_keep` tinyint(1) NOT NULL DEFAULT '0',
  `mod_doanswer` tinyint(1) NOT NULL DEFAULT '1',
  `can_travel` tinyint(1) NOT NULL DEFAULT '1',
  `show_only_status` tinyint(1) NOT NULL DEFAULT '0',
  `show_score` tinyint(1) NOT NULL DEFAULT '1',
  `show_score_cat` tinyint(1) NOT NULL DEFAULT '0',
  `show_doanswer` tinyint(1) NOT NULL DEFAULT '0',
  `show_solution` tinyint(1) NOT NULL DEFAULT '0',
  `time_dependent` tinyint(1) NOT NULL DEFAULT '0',
  `time_assigned` int(6) NOT NULL DEFAULT '0',
  `penality_test` tinyint(1) NOT NULL DEFAULT '0',
  `penality_time_test` double NOT NULL DEFAULT '0',
  `penality_quest` tinyint(1) NOT NULL DEFAULT '0',
  `penality_time_quest` double NOT NULL DEFAULT '0',
  `max_attempt` int(11) NOT NULL DEFAULT '0',
  `hide_info` tinyint(1) NOT NULL DEFAULT '0',
  `order_info` text NOT NULL,
  `use_suspension` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `suspension_num_attempts` int(10) unsigned NOT NULL DEFAULT '0',
  `suspension_num_hours` int(10) unsigned NOT NULL DEFAULT '0',
  `suspension_prerequisites` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `chart_options` text NOT NULL,
  `mandatory_answer` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `score_max` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idTest`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_test`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_testquest`
--

CREATE TABLE `learning_testquest` (
  `idQuest` int(11) NOT NULL AUTO_INCREMENT,
  `idTest` int(11) NOT NULL DEFAULT '0',
  `idCategory` int(11) NOT NULL DEFAULT '0',
  `type_quest` varchar(255) NOT NULL DEFAULT '',
  `title_quest` text NOT NULL,
  `difficult` int(1) NOT NULL DEFAULT '3',
  `time_assigned` int(5) NOT NULL DEFAULT '0',
  `sequence` int(5) NOT NULL DEFAULT '0',
  `page` int(11) NOT NULL DEFAULT '0',
  `shuffle` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idQuest`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_testquest`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_testquestanswer`
--

CREATE TABLE `learning_testquestanswer` (
  `idAnswer` int(11) NOT NULL AUTO_INCREMENT,
  `idQuest` int(11) NOT NULL DEFAULT '0',
  `sequence` int(11) NOT NULL DEFAULT '0',
  `is_correct` int(11) NOT NULL DEFAULT '0',
  `answer` text NOT NULL,
  `comment` text NOT NULL,
  `score_correct` double NOT NULL DEFAULT '0',
  `score_incorrect` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`idAnswer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_testquestanswer`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_testquestanswer_associate`
--

CREATE TABLE `learning_testquestanswer_associate` (
  `idAnswer` int(11) NOT NULL AUTO_INCREMENT,
  `idQuest` int(11) NOT NULL DEFAULT '0',
  `answer` text NOT NULL,
  PRIMARY KEY (`idAnswer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_testquestanswer_associate`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_testquest_extra`
--

CREATE TABLE `learning_testquest_extra` (
  `idQuest` int(11) NOT NULL DEFAULT '0',
  `idAnswer` int(11) NOT NULL DEFAULT '0',
  `extra_info` text NOT NULL,
  PRIMARY KEY (`idQuest`,`idAnswer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_testquest_extra`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_testtrack`
--

CREATE TABLE `learning_testtrack` (
  `idTrack` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL DEFAULT '0',
  `idReference` int(11) NOT NULL DEFAULT '0',
  `idTest` int(11) NOT NULL DEFAULT '0',
  `date_attempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_attempt_mod` datetime DEFAULT NULL,
  `date_end_attempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_page_seen` int(11) NOT NULL DEFAULT '0',
  `last_page_saved` int(11) NOT NULL DEFAULT '0',
  `number_of_save` int(11) NOT NULL DEFAULT '0',
  `number_of_attempt` int(11) NOT NULL DEFAULT '0',
  `score` double DEFAULT NULL,
  `bonus_score` double NOT NULL DEFAULT '0',
  `score_status` enum('valid','not_checked','not_passed','passed','not_complete','doing') NOT NULL DEFAULT 'not_complete',
  `comment` text NOT NULL,
  `attempts_for_suspension` int(10) unsigned NOT NULL DEFAULT '0',
  `suspended_until` datetime DEFAULT NULL,
  PRIMARY KEY (`idTrack`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_testtrack`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_testtrack_answer`
--

CREATE TABLE `learning_testtrack_answer` (
  `idTrack` int(11) NOT NULL DEFAULT '0',
  `idQuest` int(11) NOT NULL DEFAULT '0',
  `idAnswer` int(11) NOT NULL DEFAULT '0',
  `score_assigned` double NOT NULL DEFAULT '0',
  `more_info` longtext NOT NULL,
  `manual_assigned` tinyint(1) NOT NULL DEFAULT '0',
  `user_answer` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`idTrack`,`idQuest`,`idAnswer`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_testtrack_answer`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_testtrack_page`
--

CREATE TABLE `learning_testtrack_page` (
  `idTrack` int(11) NOT NULL DEFAULT '0',
  `page` int(3) NOT NULL DEFAULT '0',
  `display_from` datetime DEFAULT NULL,
  `display_to` datetime DEFAULT NULL,
  `accumulated` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idTrack`,`page`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_testtrack_page`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_testtrack_quest`
--

CREATE TABLE `learning_testtrack_quest` (
  `idTrack` int(11) NOT NULL DEFAULT '0',
  `idQuest` int(11) NOT NULL DEFAULT '0',
  `page` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idTrack`,`idQuest`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_testtrack_quest`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_testtrack_times`
--

CREATE TABLE `learning_testtrack_times` (
  `idTrack` int(11) NOT NULL DEFAULT '0',
  `idReference` int(11) NOT NULL DEFAULT '0',
  `idTest` int(11) NOT NULL DEFAULT '0',
  `date_attempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `number_time` tinyint(4) NOT NULL DEFAULT '0',
  `score` double NOT NULL DEFAULT '0',
  `score_status` varchar(50) NOT NULL DEFAULT '',
  `date_begin` datetime NOT NULL,
  `date_end` datetime NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`idTrack`,`number_time`,`idTest`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_testtrack_times`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_time_period`
--

CREATE TABLE `learning_time_period` (
  `id_period` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `label` varchar(255) NOT NULL DEFAULT '',
  `start_date` date NOT NULL DEFAULT '0000-00-00',
  `end_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id_period`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_time_period`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_trackingeneral`
--

CREATE TABLE `learning_trackingeneral` (
  `idTrack` int(11) NOT NULL AUTO_INCREMENT,
  `idEnter` int(11) NOT NULL DEFAULT '0',
  `idUser` int(11) NOT NULL DEFAULT '0',
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `session_id` varchar(255) NOT NULL DEFAULT '',
  `function` varchar(250) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `timeof` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ip` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`idTrack`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_trackingeneral`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_tracksession`
--

CREATE TABLE `learning_tracksession` (
  `idEnter` int(11) NOT NULL AUTO_INCREMENT,
  `idCourse` int(11) NOT NULL DEFAULT '0',
  `idUser` int(11) NOT NULL DEFAULT '0',
  `session_id` varchar(255) NOT NULL DEFAULT '',
  `enterTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `numOp` int(5) NOT NULL DEFAULT '0',
  `lastFunction` varchar(50) NOT NULL DEFAULT '',
  `lastOp` varchar(5) NOT NULL DEFAULT '',
  `lastTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ip_address` varchar(40) NOT NULL DEFAULT '',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idEnter`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_tracksession`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_transaction`
--

CREATE TABLE `learning_transaction` (
  `id_transaction` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_confirm` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `price` int(11) NOT NULL DEFAULT '0',
  `payment_status` tinyint(1) NOT NULL DEFAULT '0',
  `course_status` tinyint(1) NOT NULL DEFAULT '0',
  `method` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_note` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `course_note` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id_transaction`),
  KEY `id_user` (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_transaction`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_transaction_info`
--

CREATE TABLE `learning_transaction_info` (
  `id_transaction` int(11) NOT NULL DEFAULT '0',
  `id_course` int(11) NOT NULL DEFAULT '0',
  `id_date` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_transaction`,`id_course`,`id_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_transaction_info`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_webpages`
--

CREATE TABLE `learning_webpages` (
  `idPages` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `language` varchar(255) NOT NULL DEFAULT '',
  `sequence` int(5) NOT NULL DEFAULT '0',
  `publish` tinyint(1) NOT NULL DEFAULT '0',
  `in_home` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`idPages`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `learning_webpages`
--


-- --------------------------------------------------------

--
-- Table structure for table `learning_wiki_course`
--

CREATE TABLE `learning_wiki_course` (
  `course_id` int(11) NOT NULL DEFAULT '0',
  `wiki_id` int(11) NOT NULL DEFAULT '0',
  `is_owner` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`course_id`,`wiki_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `learning_wiki_course`
--


--
-- Constraints for dumped tables
--

--
-- Constraints for table `core_lang_translation`
--
ALTER TABLE `core_lang_translation`
  ADD CONSTRAINT `core_lang_translation_ibfk_1` FOREIGN KEY (`lang_code`) REFERENCES `core_lang_language` (`lang_code`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `core_lang_translation_ibfk_2` FOREIGN KEY (`id_text`) REFERENCES `core_lang_text` (`id_text`) ON DELETE CASCADE ON UPDATE CASCADE;
