<?php defined("IN_DOCEBO") or die('Direct access is forbidden.');

/* ======================================================================== \
| 	DOCEBO - The E-Learning Suite											|
| 																			|
| 	Copyright (c) 2010 (Docebo)												|
| 	http://www.docebo.com													|
|   License 	http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt		|
\ ======================================================================== */

if (!defined('PEOPLEVIEW_TAB')) {
	define('DIRECTORY_TAB', 'DIRECTORY_TAB');
	define('PEOPLEVIEW_TAB', 'PEOPLEVIEW_TAB');
	define('GROUPVIEW_TAB', 'GROUPVIEW_TAB');
	define('ORGVIEW_TAB', 'ORGVIEW_TAB');
	define('DIRECTORY_ID', 'directory_id');
}

class UserSelector {

	public $show_user_selector = TRUE;
	public $show_group_selector = TRUE;
	public $show_orgchart_selector = TRUE;
	public $show_orgchart_simple_selector = FALSE;
	public $show_fncrole_selector = TRUE;

	public $requested_tab = FALSE;
	public $group_filter = array();
	public $user_filter = array();
	public $learning_filter = 'none';
	public $selection = array();
	public $_extra_form = array();
	public $nFields = FALSE;

	public $use_suspended = false;

	public function __construct() {}

	public function setPageTitle($title) {}

	public function isParseDataAvailable($arrayState) {
		return isset($arrayState[DIRECTORY_ID]);
	}

	/**
	 * Display the user/group/orgchart/fncrole selector
	 * @param string $url the url of the page, used for the form
	 * @param string $title the main title for the page (will be passed to a getTitleArea function
	 * @param string $text extra text to display
	 * @param bool $selector_mode if true the main div and page title will be drawed by the selector
	 * @param string $id the id for the form that will contain the selector
	 */
	public function loadSelector($url, $title = false, $text = '', $selector_mode = TRUE, $id=FALSE) {
		$res = '';
		$id = (empty($id) ? 'main_selector' : $id);
		$us_util = new UserSelectorUtil();

		if ($selector_mode && $title != false) {
			$res.=getTitleArea($title);
			$res.='<div class="std_block">';
		}
		$res.=Form::openForm($id . '_form', $url);

		if (is_array($this->_extra_form) && !empty($this->_extra_form)) {
			$res.=implode("\n", $this->_extra_form);
		}

		$res.=Util::widget('userselector', array(
			'id' => $id,
			'show_user_selector' => $this->show_user_selector,
			'show_group_selector' => $this->show_group_selector,
			'show_orgchart_selector' => $this->show_orgchart_selector,
			'show_fncrole_selector' => $this->show_fncrole_selector,
			'initial_selection' => $this->selection,
			'admin_filter' => true,
			'learning_filter' => $this->learning_filter,
			'use_suspended' => $this->use_suspended,
			'nFields' => $this->nFields !== FALSE ? $this->nFields : 3
		), true);

		$res.=Form::openButtonSpace();
		$res.=Form::getButton('okselector', 'okselector', Lang::t('_SAVE', 'standard'));
		$res.=Form::getButton('cancelselector', 'cancelselector', Lang::t('_UNDO', 'standard'));
		$res.=Form::closeButtonSpace();

		$res.=Form::closeForm();
		if ($selector_mode) {
			$res.='</div>';
		}

		cout($res, 'content');
	}

	/**
	 * Resolve the selection generated by the selector
	 * @param array $arrayData the array with the data for the selections, $_POST is the standard selections
	 * @param string $selector_id the id of the main array with the selections in it
	 * @return array the idsts selected
	 */
	public function getSelection($arrayData, $selector_id=false) {
		$selector_id = (empty($selector_id) ? 'main_selector' : $selector_id);
		$userselector_input = Get::pReq('userselector_input', DOTY_MIXED, false);
		if (is_array($userselector_input) && isset($userselector_input[$selector_id])) {
			if (!empty($userselector_input[$selector_id])) {
				$this->selection = explode(',', $userselector_input[$selector_id]);
			} else {
				$this->selection = array();
			}
		}
		return $this->selection;
	}

	public function resetSelection($array_selection = NULL, $array_selection_alt = NULL) {
		$this->selection = $array_selection;
	}

	/**
	 * Set filters for user data retriever
	 * @param string $filter_type one of the following:
	 * 								- "platform": retrieve only user of the platforms
	 * 												given in $filter_arg array
	 * 								- "group": retrieve only user members of the
	 * 												groups given in $filter_arg array
	 * 								- "exclude": exclude users with idst passed in
	 * 												$filter_arg array
	 * @param array $filter_arg an array of platforms or an array of groups or
	 * 								an array of idst (see $filter_type)
	 * @return NULL
	 * */
	public function setUserFilter($filter_type, $filter_arg) {
		switch ($filter_type) {
			case "platform" : $this->user_filter['platform'] = $filter_arg;
				break;
			case "user" : $this->user_filter['user'] = $filter_arg;
				break;
			case "group" : $this->user_filter['group'] = $filter_arg;
				break;
			case "exclude" : $this->user_filter['exclude'] = $filter_arg;
				break;
		}
		return;
	}

	function setGroupFilter($filter_type, $filter_arg) {

		switch($filter_type) {
			case "platform" : $this->group_filter['platform'] = $filter_arg;break;
			case "group" 	: $this->group_filter['group'] = $filter_arg;break;
			case "path" 	: $this->group_filter['path'] = $filter_arg;break;
		}
		return;
	}

	function addFormInfo($string) {
		$this->_extra_form[] = $string;
	}

	function resetFormInfo() {
		$this->_extra_form = array();
	}

	function setNFields($nFields) {
		$this->nFields=$nFields;
	}

}

class UserSelectorUtil {

	protected $db;

	public function __construct() {
		$this->db = DbConn::getInstance();
	}

	/**
	 * Returns an array with the data ready to be used as
	 * 'initial_selection' parameter in the userselector widget.
	 * @param array $array
	 * @return array multidimensional array with data organized by type
	 */
	public function getInitialSelFromIdst($array) {
		$res = array(
			'user' => array(),
			'group' => array(),
			'orgchart' => array(),
			'fncrole' => array()
		);

		if(empty($array)) return $res;

		$qtxt = "SELECT idst,'group' as item_type,groupid as itemid, hidden  FROM core_group
			WHERE idst IN (" . implode(',', $array) . ")
			UNION
			SELECT idst,'user' as item_type,userid as itemid, 'false' as hidden FROM core_user
			WHERE idst IN (" . implode(',', $array) . ")";
		$q = $this->db->query($qtxt);

		while ($row = $this->db->fetch_assoc($q)) {
			$item_id = $row['itemid'];
			$type = $row['item_type'];

			if ($type == 'user') {
				$res['user'][] = $row['idst'];
			} else if ($type == 'group') {
				$match = array();
				if (preg_match('/^\\/oc([d])*_(\d)/', $item_id, $match) && $row["hidden"] == 'true') {
					// org chart
					$res['orgchart'][] = $row['idst'];
				} else {
					// normal group
					if (strpos($item_id, '/fncroles/') === 0) {
						$res['fncrole'][] = $row['idst'];
					} else {
						$res['group'][] = $row['idst'];
					}
				}
			}
		}

		return $res;
	}

	/**
	 * Returns an array with all the idst of the given orgchart items
	 * (groupid names)
	 * @param string $oc_list comma separed string
	 * @return array
	 */
	public function getOrgChartIdst($oc_list) {
		$res = array();
		$oc_id_arr = array();
		$oc_arr = explode(',', $oc_list);

		foreach ($oc_arr as $oc) {
			if (substr($oc, -1) == 'd') {
				$oc_id_arr[] = '/ocd_' . substr($oc, 0, -1);
			} else {
				$oc_id_arr[] = '/oc_' . $oc;
			}
		}

		$acl_man = Docebo::user()->getACLManager();
		$res = $acl_man->getArrGroupST($oc_id_arr);

		return $res;
	}

	/**
	 *
	 * @param <type> $old_sel
	 * @param <type> $new_sel
	 * @return array
	 */
	public function getSelectionDiff($old_sel, $new_sel) {
		$res = array(
			'new' => array(),
			'eql' => array(),
			'rem' => array(),
		);
		return $res;
	}

}
