<?php

/**
 * Provides a way to identify a user across more than one page request or visit to a Web site and to store information about that user.
 * Wraps PHP's functions and global arrays to emulate Java's HttpSession interface.
 * @package		diy-framework
 * @subpackage	controller
 * @author		Martynas Jusevicius <pumba@xml.lt>
 * @link		http://www.xml.lt
 */

class Session
{
	private $id;
	private $attributes = array();

/**
 * Constructs Session (starts it and gives it an ID).
 */

	public function __construct()
	{
		session_start();
		$this->id = session_id();
		//$_SESSION["attributes"] = $this->attributes;
	}

/**
 * Returns session ID.
 * @return int Session ID
 */

	public function getID()
	{
		return $this->id;
	}

/**
 * Returns a session attribute, or null if it does not exist.
 * @param string $name Name of the attribute
 * @return mixed Attribute
 */

	public function getAttribute($name)
	{
		//if (isset($this->attributes[$name])) return $this->attributes[$name];
		//else return null;
		if (isset($_SESSION[$name])) return $_SESSION[$name];
		else return null;
	}

/**
 * Sets a session attribute.
 * @param string $name Name of the attribute
 * @param string $value Value of the attribute
 */

	public function setAttribute($name, $value)
	{
		//$this->attributes[$name] = $value;
		$_SESSION[$name] = $value;
	}

}

?>