<?php

/**
 * Provides access to HTTP response, such as status, headers etc.
 * Wraps PHP's functions and global arrays to emulate Java's HttpServletResponse interface. That means it can only be used to represent the "current" response.
 * @package		diy-framework
 * @subpackage	controller
 * @author		Martynas Jusevicius <pumba@xml.lt>
 * @link		http://www.xml.lt
 */

class Response
{
	private $headers = array();
	private static $instance = null;
	private $buffer = "";
	private $status = null;
	private $contentType = null;
	private $encoding = null;

	const SC_OK = 200;
	const SC_FORBIDDEN = 403;
	const SC_NOT_FOUND = 404;
	const SC_METHOD_NOT_ALLOWED = 405;
	const SC_INTERNAL_SERVER_ERROR = 500;

/**
 * Constructs a new Response.
 * Is private because of the Singleton pattern.
 */

	private function __construct() {}
	private function __clone() {}

/**
 * Sets a HTTP response header.
 * @param string $name Name of the header
 * @param string $value Value of the header
 */

	public function setHeader($name, $value)
	{
		$headers[$name] = $value;
		header($name.": ".$value); // QUIRK
	}

/**
 * Returns instance of self (Response object). Used to implement Singleton pattern.
 * @return Response
 */

	public static function getInstance()
	{
		if (self::$instance == null) self::$instance = new self();
		return self::$instance;
	}

/**
 * Returns response status.
 * @return int Status code
 */

	public function getStatus()
	{
		return $this->status;
	}

/**
 * Sets response status.
 * @param int $status Status code
 */

	public function setStatus($status)
	{
		$this->status = $status;
	}

/**
 * Returns content type.
 * @return string Content type
 */

	public function getContentType()
	{
		return $this->contentType;
	}

/**
 * Sets content type (e.g. "text/html").
 * @param string $contentType Content type
 */

	public function setContentType($contentType)
	{
		$this->contentType = $contentType;
		//$this->setHeader("Content-type", $outputType);
	}

/**
 * Returns character encoding.
 * @return string Character encoding
 */

	public function getCharacterEncoding()
	{
		return $this->encoding;
	}

/**
 * Sets character encoding (e.g. "UTF-8").
 * @param string $encoding Character encoding
 */

	public function setCharacterEncoding($encoding)
	{
		$this->encoding = $encoding;
	}

/**
 * Sends a temporary redirect response to the client using the specified redirect location URL.
 * @param string $url Redirect location URL
 */

	public function sendRedirect($url)
	{
		$this->setHeader("Location", $url);
		exit;
	}

/**
 * Writes a string into the response output buffer.
 * @param string $string String
 */

	public function write($string)
	{
		$this->buffer .= $string;
	}

/**
 * Returns the whole response output buffer.
 * @return string Buffer string
 */

	public function getBuffer()
	{
		return $this->buffer;
	}
}

?>