<?php

/**
 * Finds Resources by URIs and types. Basically wraps ResourcePeer.
 * It is an abstract class for sub-classing. An application Mapping should extend the framework Mapping.
 * @package		diy-framework
 * @subpackage	controller
 * @author		Martynas Jusevicius <pumba@xml.lt>
 * @link		http://www.xml.lt
 */

abstract class ResourceMapping implements Singleton
{

/**
 * Constructs a new ResourceMapping.
 * Is private because of the Singleton pattern.
 */

	private function __construct() {}
	private function __clone() {}

/**
 * Finds and returns Resource object by its URI, or null if it doesn't exist.
 * @param string $uri URI of the Resource
 * @return Resource Resource
 */

	public abstract static function findByURI($uri);

/**
 * Finds and returns Resource objects by their type, or null if it doesn't exist.
 * @param string $type Type of the Resource
 * @return array Array of Resources
 */

	public abstract static function findByType($type);

/**
 * Returns the hostname of this mapping.
 * @return string Hostname
 */

	public abstract static function getHost();
}

?>