<?php

/**
 * Static class for loading the framework classes. Should be called by the __autoload() function.
 * @package	diy-framework
 * @author	Martynas Jusevicius <pumba@xml.lt>
 * @link	http://www.xml.lt
 */

class DIYFrameworkLoader
{

/**
 * Loads a framework class by its name. First checks if the file exists and then includes it.
 * @param string $className The name of the class to load
 * @param string $dir Directory where the framework is located (with trailing slash). We need it because file_exists() looks in the current dir while require takes into account include_path.
 */

	public static function __autoload($className, $dir)
	{
		if (file_exists($dir."controller/".$className.".class.php")) require("controller/".$className.".class.php");
		if (file_exists($dir."controller/".$className.".int.php")) require("controller/".$className.".int.php");
		//if (file_exists($dir."controller/exceptions/".$className.".class.php")) require("controller/exceptions/".$className.".class.php");
		if (file_exists($dir."view/".$className.".class.php")) require("view/".$className.".class.php");
	}
}

?>