<?php

/**
 * Includes classes required by the frontend application and runs the application Controller.
 * Handles all HTTP requests for frontend. Base frontend URL should be rewritten to be handled by this file.
 * @package diy-framework
 * @author	Martynas Jusevicius <pumba@xml.lt>
 * @link	http://www.xml.lt
 */

require("common.php");

define("APP_DIR", MAIN_DIR."app/");
define("APP_CONTR_DIR", APP_DIR."controller/");
define("APP_VIEW_DIR", APP_DIR."view/");

// VIEWS

// specific Views are not autoloaded so fa:
//require(APP_VIEW_DIR."specific/SpecificView.class.php");

// Autoloading

function __autoload($classname)
{
	if (file_exists(MAIN_DIR."view/".$classname.".class.php")) require(MAIN_DIR."view/".$classname.".class.php");

	if (file_exists(APP_CONTR_DIR.$classname.".class.php")) require(APP_CONTR_DIR.$classname.".class.php");
	if (file_exists(APP_CONTR_DIR."forms/".$classname.".class.php")) require(APP_CONTR_DIR."forms/".$classname.".class.php");
	if (file_exists(APP_CONTR_DIR."exceptions/".$classname.".class.php")) require(APP_CONTR_DIR."exceptions/".$classname.".class.php");
	if (file_exists(APP_VIEW_DIR.$classname.".class.php")) require(APP_VIEW_DIR.$classname.".class.php");

	if (file_exists(MODEL_DIR.$classname.".php")) require(MODEL_DIR.$classname.".php");

	DIYFrameworkLoader::__autoload($classname, "lib/diy-framework/classes/diy-framework/");
}

// Runs controller

AppController::getInstance()->process(Request::getInstance(), Response::getInstance(), AppMapping::getInstance());

?>