<?php

/**
 * Specialized view subclass that handles XSLT processor initialization and executes general view procedures, such as passing parameters/arguments to the XSLT stylesheet.
 * It is an abstract class for sub-classing. An application Views should extend the XSLTView and call the parent::display().
 * @package		diy-framework
 * @subpackage	view
 * @author		Martynas Jusevicius <pumba@xml.lt>
 * @link		http://www.xml.lt
 */

abstract class XSLTView extends View
{
	protected $resource = null;
	protected $doc = null;
	protected $template = null;
	protected $proc = null;
	protected $resolver = null;

/**
 * Constructs View from Resource, initializes XSLT processor and creates URI resolver.
 * @param Resource $resource Resource
 */

	public function __construct(Resource $resource = null)
	{
		parent::__construct($resource);
		$this->doc = new DOMDocument();
		$this->template = new DOMDocument();
		$this->proc = new XSLTProcessor();
	}

/**
 * Sets common parameters and arguments for all XSLT views and displays this view.
 * @param Request $request Request
 * @param Response $response Response
 */

	public function display(Request $request, Response $response)
	{
		$this->proc->importStyleSheet($this->template);

		if ($this->resource != null)
		{
			$xml = Serializer::serialize($this->resource);
			$this->doc->loadXML($xml);
		}

		$xml = $this->proc->transformToXML($this->doc);
		$response->write($xml);
	}
}

?>