<?php

$xslArgs=null;

/**
 * Helper class, used by URIResolver to stream strings.
 * @package		diy-framework
 * @subpackage	view
 * @author		Martynas Jusevicius <pumba@xml.lt>
 * @link		http://www.xml.lt
 */

class StringStream
{
	var $position;
	var $xslArg;

	function stream_eof()
	{
		return $this->position>=strlen($this->xslArg);
	}

	function stream_open($path,$mode,$options,&$opened_path)
	{
		$this->position=0;
		$url=parse_url($path);
		$varname=$url['host'];
		global $xslArgs;
		if (isset($xslArgs['/'.$varname]))
		$this->xslArg=&$xslArgs['/'.$varname];
		elseif (isset($xslArgs[$varname]))
		$this->xslArg=&$xslArgs[$varname];
		else return false;
		return true;
	}

	function stream_read($count)
	{
		$ret=substr($this->xslArg,$this->position,$count);
		$this->position+=strlen($ret);
		return $ret;
	}

	function stream_tell()
	{
		return $this->position;
	}

	function url_stat()
	{
		return array();
	}
}

/**
 * Serves a (XML) string from memory as a stream.
 * It is used to imitate files and pass dynamically generated side XML documents to XSLT, where they can be accessed using XPath's document() function, e.g. document('arg://books')
 * @package diy-framework
 * @subpackage view
 * @author Martynas Jusevicius <pumba@xml.lt>
 */

class URIResolver
{
	private $scheme = null;
	private $args = array();

/**
 * Constructs CustomURIResolver from scheme prefix string (e.g. "arg" or "http").
 * @param string $scheme Scheme prefix string
 */

	function __construct($scheme)
	{
		$this->scheme = $scheme;
		if (!in_array($scheme, stream_get_wrappers())) stream_wrapper_register($scheme, "StringStream") or die("Failed to register '".$scheme."'");
	}

/**
 * Sets XML string as an argument (side document) which is later passed to XSLT stylesheet.
 * @param string $name Name of the argument
 * @param string $xml XML string
 */

	public function setArgument($name, $xml)
	{
		global $xslArgs;
		//$this->args[$name] = $xml;
		//$xslArgs = $this->args;
		$xslArgs[$name] = $xml;
	}

}