<?php

/**
 * An abstract HTTP Resource for subclassing. It should be specified as a base class in Propel schema.
 * If used without Propel, it should not extend BaseObject.
 * @package		diy-framework
 * @subpackage	controller
 * @author		Martynas Jusevicius <pumba@xml.lt>
 * @link		http://www.xml.lt
 */

abstract class Resource extends BaseObject
{

/**
 * Implements HTTP GET method of the Resource.
 * @param Request $request Request object
 * @param Response $response Response object
 */

	public function doGet(Request $request, Response $response)
	{
		$response->setStatus(Response::SC_METHOD_NOT_ALLOWED);
		return null;
	}

/**
 * Implements HTTP POST method of the Resource.
 * @param Request $request Request object
 * @param Response $response Response object
 */

	public function doPost(Request $request, Response $response)
	{
		$response->setStatus(Response::SC_METHOD_NOT_ALLOWED);
		return null;
	}

/**
 * Implements HTTP PUT method of the Resource.
 * @param Request $request Request object
 * @param Response $response Response object
 */

	public function doPut(Request $request, Response $response)
	{
		$response->setStatus(Response::SC_METHOD_NOT_ALLOWED);
		return null;
	}

/**
 * Implements HTTP DELETE method of the Resource.
 * @param Request $request Request object
 * @param Response $response Response object
 */

	public function doDelete(Request $request, Response $response)
	{
		$response->setStatus(Response::SC_METHOD_NOT_ALLOWED);
		return null;
	}

/**
 * Returns the (relative) URI of the Resource.
 * @return string Resource URI
 */

	public abstract function getURI();

/**
 * Sets the (relative) URI of the Resource.
 * @param string Resource URI
 */

	public abstract function setURI($uri);

}