<?php

/**
 * Provides HTTP request information such as headers, query parameters etc.
 * Wraps PHP's functions and global arrays to emulate Java's HttpServletRequest interface. That means it can only be used to represent the "current" request.
 * @package		diy-framework
 * @subpackage	controller
 * @author		Martynas Jusevicius <pumba@xml.lt>
 * @link		http://www.xml.lt
 */

class Request
{
	private $attributes = array();
	private $parameters = array();
	private $requestMethod;
	private $headers = array();
	private $session = null;
	private static $instance = null;

/**
 * Constructs a new Request.
 * Is private because of the Singleton pattern.
 */

	private function __construct()
	{
		foreach ($_GET as $name => $value)
			$this->setParameter($name, $value);
		foreach ($_POST as $name => $value)
			$this->setParameter($name, $value);
	}

	private function __clone() {}

/**
 * Returns a request attribute, or null if it does not exist. They are used to save and share data between components in a context of a single request.
 * @param string $name Name of the attribute
 * @return mixed Attribute
 */

	public function getAttribute($name)
	{
		if (isset($this->attributes[$name])) return $this->attributes[$name];
		else return null;
	}

/**
 * Sets a request attribute. They are used to save and share data between components in a context of a single request.
 * @param string $name Name of the attribute
 * @param string $value Value of the attribute
 */

	public function setAttribute($name, $value)
	{
		$this->attributes[$name] = $value;
	}

/**
 * Returns a HTTP request parameter (from both GET and POST) as a string, or null if it does not exist.
 * @param string $name Name of the parameter
 * @return string Value of the parameter
 */

	public function getParameter($name)
	{
		if (isset($this->parameters[$name])) return $this->parameters[$name];
		else return null;
	}

/**
 * Sets a request parameter, as if it was set by the client.
 * @param string $name Name of the parameter
 * @param string $value Value of the parameter
 */

	private function setParameter($name, $value)
	{
		$this->parameters[$name] = $value;
	}

/**
 * Returns a HTTP method (GET/POST/PUT/DELETE etc.) of this request.
 * @return string Request method
 */

	public function getMethod()
	{
		//return $requestMethod;
		return $_SERVER["REQUEST_METHOD"];
	}

/**
 * Returns a HTTP request header, or null if it does not exist.
 * Header names are the same as in PHP's $_SERVER[].
 * @param string $name Name of the header
 * @return string Value of the header
 */

	public function getHeader($name)
	{
		//return $headers[$name];
		if (isset($_SERVER[$name])) return $_SERVER[$name];
		else return null;
	}

/**
 * Returns the current Session object associated with this Request.
 * @return Session Session
 */

	public function getSession()
	{
		if ($this->session == null) $this->session = new Session();
		return $this->session;
	}

/**
 * Returns instance of self (Request object). Used to implement Singleton pattern.
 * @return Request
 */

	public static function getInstance()
	{
		if (self::$instance == null) self::$instance = new self();
		return self::$instance;
	}

/**
 * Returns a map (array with keys) of parameters of this Request.
 * @return array
 */

	public function getParameterMap()
	{
		return $this->parameters;
	}

/**
 * Returns Returns any extra path information associated with the URL the client sent when it made this request. The extra path information follows the servlet path but precedes the query string. This method returns null if there was no extra path information.
 * Same as the value of the CGI variable PATH_INFO.
 * @return string
 */

	public function getPathInfo()
	{
		return $this->getHeader("PATH_INFO");
	}

/**
 * Returns the part of this request's URL from the protocol name up to the query string in the first line of the HTTP request.
 * Same as the value of the CGI variable REQUEST_URI.
 * @return string
 */

	public function getRequestURI()
	{
		return $this->getHeader("REQUEST_URI");
	}

}

?>