<?php
namespace Directus\GraphQL\Type\Directus;

use Directus\Application\Application;
use Directus\GraphQL\Types;
use GraphQL\Type\Definition\ObjectType;
use GraphQL\Type\Definition\ResolveInfo;

class DirectusCollectionType extends ObjectType
{
    private $container;
    public function __construct()
    {
        $this->container = Application::getInstance()->getContainer();
        $config = [
            'name' => 'DirectusCollectionItem',
            'fields' =>  function () {
                return [
                    'collection' => Types::string(),
                    'fields' => Types::listOf(Types::directusField()),
                    'note' => Types::string(),
                    'managed' => Types::boolean(),
                    'hidden' => Types::boolean(),
                    'single' => Types::boolean(),
                    'translation' => Types::string(),
                    'icon' => Types::string()
                ];
            },
            'interfaces' => [
                Types::node()
            ],
            'resolveField' => function ($value, $args, $context, ResolveInfo $info) {
                $method = 'resolve' . ucfirst($info->fieldName);
                if (method_exists($this, $method)) {
                    return $this->{$method}($value, $args, $context, $info);
                } else {
                    return $value[$info->fieldName];
                }
            }
        ];
        parent::__construct($config);
    }
}
