
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `cumu253`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]attachments`
--

CREATE TABLE `[[dbprefix]]attachments` (
  `attachment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `file_id` bigint(20) NOT NULL,
  `video_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`attachment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `category_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(252) NOT NULL,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]categories`
--

INSERT INTO `[[dbprefix]]categories` VALUES
(1, 'General', 'general');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments`
--

CREATE TABLE `[[dbprefix]]comments` (
  `comment_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL DEFAULT '0',
  `video_id` bigint(20) NOT NULL,
  `parent_id` bigint(20) DEFAULT '0',
  `comments` longtext NOT NULL,
  `date_created` datetime NOT NULL,
  `status` varchar(255) NOT NULL,
  `released` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]files`
--

CREATE TABLE `[[dbprefix]]files` (
  `file_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `name` text NOT NULL,
  `filesize` bigint(20) NOT NULL,
  `extension` varchar(255) NOT NULL DEFAULT '',
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`file_id`),
  KEY `user_id` (`user_id`),
  KEY `filename` (`filename`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]flags`
--

CREATE TABLE `[[dbprefix]]flags` (
  `flag_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `object_id` bigint(20) NOT NULL,
  `type` varchar(255) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `date_created` date NOT NULL,
  `status` varchar(255) DEFAULT 'pending',
  PRIMARY KEY (`flag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messages`
--

CREATE TABLE `[[dbprefix]]messages` (
  `message_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `recipient` bigint(20) NOT NULL DEFAULT '0',
  `subject` text NOT NULL,
  `message` text NOT NULL,
  `status` varchar(255) NOT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`message_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pages`
--

CREATE TABLE `[[dbprefix]]pages` (
  `page_id` bigint(11) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `content` longtext NOT NULL,
  `slug` text NOT NULL,
  `layout` varchar(255) NOT NULL DEFAULT 'default',
  `date_created` datetime NOT NULL,
  `status` varchar(255) NOT NULL,
  PRIMARY KEY (`page_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]pages`
--

INSERT INTO `[[dbprefix]]pages` VALUES
(1, 'Sample Page', '<p>This is a sample page. You can create custom static pages like this in the Admin Panel.</p>', 'sample-page', 'default', '2011-09-05 06:28:49', 'published');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]playlists`
--

CREATE TABLE `[[dbprefix]]playlists` (
  `playlist_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `type` varchar(20) NOT NULL DEFAULT 'list',
  `public` tinyint(1) DEFAULT '1',
  `date_created` date NOT NULL,
  PRIMARY KEY (`playlist_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]playlists`
--

INSERT INTO `[[dbprefix]]playlists` VALUES
(1, NULL, 1, 'favorites', 0, '[[regdate]]'),
(2, NULL, 1, 'watch_later', 0, '[[regdate]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]playlist_entries`
--

CREATE TABLE `[[dbprefix]]playlist_entries` (
  `playlist_entry_id` int(11) NOT NULL AUTO_INCREMENT,
  `playlist_id` int(11) NOT NULL,
  `video_id` int(11) NOT NULL,
  `date_created` date NOT NULL,
  PRIMARY KEY (`playlist_entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]privacy`
--

CREATE TABLE `[[dbprefix]]privacy` (
  `privacy_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `video_comment` tinyint(1) NOT NULL DEFAULT '1',
  `new_message` tinyint(1) NOT NULL DEFAULT '1',
  `new_video` tinyint(1) NOT NULL DEFAULT '1',
  `video_ready` tinyint(1) NOT NULL DEFAULT '1',
  `comment_reply` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`privacy_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]privacy`
--

INSERT INTO `[[dbprefix]]privacy` VALUES
(1, 1, 1, 1, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ratings`
--

CREATE TABLE `[[dbprefix]]ratings` (
  `rating_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `video_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL,
  `rating` tinyint(4) NOT NULL,
  PRIMARY KEY (`rating_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `setting_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `value` longtext NOT NULL,
  PRIMARY KEY (`setting_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=46 ;

--
-- Dumping data for table `[[dbprefix]]settings`
--

INSERT INTO `[[dbprefix]]settings` VALUES
(1, 'active_theme', 'default'),
(2, 'active_mobile_theme', 'mobile-default'),
(3, 'default_language', 'en_US'),
(4, 'installed_languages', '{"en_US":{"active":true,"lang_name":"English","native_name":"English","author":"CumulusClips","sample":"The quick brown fox jumps over the lazy dog","version":"2.4","update":"http://mothership.cumulusclips.org/updates/languages/en_US/","notes":""}}'),
(5, 'installed_plugins', '[]'),
(6, 'enabled_plugins', '[]'),
(7, 'roles', '{"admin":{"name":"Administrator","permissions":["admin_panel","manage_settings"]},"mod":{"name":"Moderator","permissions":["admin_panel"]},"user":{"name":"User","permissions":[]}}'),
(8, 'debug_conversion', '0'),
(9, 'video_size_limit', '102000000'),
(10, 'file_size_limit', '102000000'),
(11, 'keep_original_video', '1'),
(12, 'enable_encoding', '1'),
(13, 'mobile_site', '1'),
(14, 'h264_encoding_options', '-vcodec libx264 -vf "scale=min(640\\,iw):trunc(ow/a/2)*2" -vb 800k -acodec aac -ab 96k -ar 44100 -f mp4'),
(15, 'webm_encoding_enabled', '0'),
(16, 'webm_encoding_options', '-vcodec libvpx -vf "scale=min(640\\,iw):trunc(ow/a/2)*2" -vb 800k -acodec libvorbis -ab 96k -ar 44100 -f webm'),
(17, 'theora_encoding_enabled', '0'),
(18, 'theora_encoding_options', '-vcodec libtheora -vf "scale=min(640\\,iw):trunc(ow/a/2)*2" -qscale 8 -vb 800k -acodec libvorbis -ab 96k -ar 44100 -f ogg'),
(19, 'mobile_encoding_enabled', '1'),
(20, 'mobile_encoding_options', '-vcodec libx264 -vf "scale=min(480\\,iw):trunc(ow/a/2)*2" -vb 600k -ac 2 -ab 96k -ar 44100 -f mp4'),
(21, 'thumb_encoding_options', '-vf "scale=min(640\\,iw):trunc(ow/a/2)*2" -t 1 -r 1 -f mjpeg'),
(22, 'auto_approve_users', '1'),
(23, 'auto_approve_videos', '1'),
(24, 'auto_approve_comments', '1'),
(25, 'alerts_videos', '1'),
(26, 'alerts_comments', '1'),
(27, 'alerts_users', '1'),
(28, 'alerts_flags', '1'),
(29, 'from_name', ''),
(30, 'from_address', ''),
(31, 'smtp', '{"enabled":false,"host":"","port":25,"username":"","password":""}'),
(32, 'user_registrations', '1'),
(33, 'user_uploads', '1'),
(34, 'alerts_imports', '1'),
(35, 'video_attachments', '1'),
(36, 'session_timeout', '60'),
(37, 'base_url', '[[softurl]]'),
(38, 'secret_key', '[[secret_key]]'),
(39, 'sitename', '[[site_name]]'),
(40, 'admin_email', '[[admin_email]]'),
(41, 'enable_uploads', '1'),
(42, 'ffmpeg', '[[softpath]]/cc-core/system/bin/ffmpeg-64-bit/ffmpeg'),
(43, 'qtfaststart', '[[softpath]]/cc-core/system/bin/ffmpeg-64-bit/qt-faststart'),
(44, 'php', '/usr/bin/php'),
(45, 'version', '2.5.3');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]subscriptions`
--

CREATE TABLE `[[dbprefix]]subscriptions` (
  `subscription_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `member` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`subscription_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]text`
--

CREATE TABLE `[[dbprefix]]text` (
  `text_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `language` varchar(20) DEFAULT 'english',
  `name` varchar(70) NOT NULL,
  `content` longtext NOT NULL,
  PRIMARY KEY (`text_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `user_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `username` varchar(80) NOT NULL,
  `email` varchar(80) NOT NULL,
  `password` varchar(32) NOT NULL,
  `status` varchar(255) NOT NULL,
  `role` varchar(255) NOT NULL DEFAULT 'user',
  `date_created` date NOT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `about_me` text,
  `website` text,
  `confirm_code` varchar(255) DEFAULT NULL,
  `views` bigint(20) DEFAULT '0',
  `last_login` date DEFAULT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `released` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`),
  KEY `username` (`username`),
  KEY `email` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, '[[admin_username]]', '[[admin_email]]', '[[admin_pass]]', 'active', 'admin', '[[regdate]]', NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]videos`
--

CREATE TABLE `[[dbprefix]]videos` (
  `video_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `category_id` bigint(20) NOT NULL,
  `title` text NOT NULL,
  `description` text NOT NULL,
  `tags` text NOT NULL,
  `date_created` datetime NOT NULL,
  `duration` varchar(255) DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `views` bigint(20) NOT NULL DEFAULT '0',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `original_extension` varchar(255) DEFAULT NULL,
  `job_id` bigint(20) DEFAULT NULL,
  `released` tinyint(1) NOT NULL DEFAULT '0',
  `disable_embed` tinyint(1) NOT NULL DEFAULT '0',
  `gated` tinyint(1) NOT NULL DEFAULT '0',
  `private` tinyint(1) NOT NULL DEFAULT '0',
  `private_url` varchar(255) DEFAULT NULL,
  `comments_closed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`video_id`),
  KEY `user_id` (`user_id`),
  FULLTEXT KEY `title_description_tags` (`title`,`description`,`tags`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
