<?php
if ( empty(get_included_files()) ) die("Direct access forbidden");
$is_db_section = ($conf_key != 'homedir' ? true : false);
?>
      <div class="panel panel-default"> <!-- restore tab <?= $section ?> section -->
        <div class="panel-heading">
          <div class="row">
            <div class="col-sm-3"> <!-- backup type col -->
              <h4 class="panel-title">
                <a
                  data-toggle="collapse"
                  data-parent="#restore_accordion"
                  href="#restore_<?= $conf_key ?>_collapse">
                    <span class="arw">&#9658;</span> <?= $section ?>
                </a>
              </h4>
            </div>
          </div>
        </div>
        <div id="restore_<?= $conf_key ?>_collapse" class="panel-collapse collapse">
          <div class="panel-body">
            <p><strong>Restore Options</strong></p>
            <div class="well">
<?php if (array_key_exists($conf_key, $conf['completed']) && $conf['completed'][$conf_key]): ?>
              <div class="form-group row">
<?php   if ($conf['show_geo']): ?>
                <label class="col-sm-2 col-form-label text-right pad-top-6" for="restore_date_<?= $conf_key ?>">From Cluster &amp; Date</label>
<?php   else: ?>
                <label class="col-sm-2 col-form-label text-right pad-top-6" for="restore_date_<?= $conf_key ?>">Restore From Date</label>
<?php   endif; ?>
                <div class="col-sm-3">
<?php   if ($is_db_section): ?>
                  <select id="restore_date_<?= $conf_key ?>" class="restore-date-select form-control restore_db_date" data-baktype="<?= $conf_key ?>">
<?php   else: ?>
                  <select id="restore_date_<?= $conf_key ?>" class="restore-date-select form-control" data-baktype="<?= $conf_key ?>">
<?php   endif; ?>
<?php   if ($is_db_section): // for databases, populate the date dropdown with data-dbnames in <options> ?>
<?php     foreach($conf['completed'][$conf_key] as $snap): ?>
                    <option class="fix-opt-locale-stamp" data-geo="<?= $snap['geo'] ?>" data-snap="<?= $snap['snap'] ?>" value="<?= $snap['geo'] ?>:<?= $snap['time'] ?>" data-dbsnaps="<?php echo_json_attrib($snap['dbs']); ?>">
                      <?= date_select_label($conf, $snap['geo'], $snap['time']) ?>
                    </option>
<?php     endforeach; ?>
<?php   else: // for homedirs, just add the date in <options> ?>
<?php     foreach($conf['completed'][$conf_key] as $snap): ?>
                    <option class="fix-opt-locale-stamp" data-geo="<?= $snap['geo'] ?>" data-snap="<?= $snap['snap'] ?>" data-stamp="<?= $snap['time'] ?>" value="<?= $snap['geo'] ?>:<?= $snap['snap'] ?>">
                      <?= date_select_label($conf, $snap['geo'], $snap['time']) ?>
                    </option>
<?php     endforeach; ?>
<?php   endif; ?>
                  </select>
                </div>
<?php     if ($conf['show_geo']): ?>
                <div class="col-sm-7 text-right">
                  Selected cluster is in <span id="geo-dest-<?= $conf_key ?>"></span>
                </div>
<?php     endif; ?>
              </div>
<?php   if ($is_db_section): // for databases, they also get a select for the database to restore ?>
              <div class="form-group row"> <!-- select database -->
                <label class="col-sm-2 col-form-label text-right pad-top-6" for="restore_dbname_<?= $conf_key ?>">Database</label>
                <div class="col-sm-3">
                  <select
                    class="form-control restore_dbname_select" data-no-db="#no_db_<?= $conf_key ?>"
                    id="restore_dbname_<?= $conf_key ?>"
                  >
                    <option value="">select</option>
                  </select>
                </div>
                <div class="col-sm-3 alert alert-danger no-db-alert" id="no_db_<?= $conf_key ?>">
                  <i class="glyphicon glyphicon-exclamation-sign"></i> <p>No database selected.</p>
                </div>
              </div>
<?php   else: // homedirs get a jquery widget instead ?>
              <?php browser_widget('homedir_filebrowser', $conf['home_path'], 'enable_home_restore', 'browse', true, []); ?>
<?php   endif; ?>
<?php   if ($is_db_section): // for databases, show a dump path field ?>
              <div class="form-group row"> <!-- enter dump path -->
                <label class="col-sm-2 col-form-label text-right pad-top-6" for="dump_path_<?= $conf_key ?>">Dump Path</label>
                <div class="col-sm-6">
                  <div class="input-group">
                    <span class="input-group-addon"><?= $conf['home_path'] ?>/</span>
                    <input
                      type="text" value="restored" class="form-control path-check"
                      id="dump_path_<?= $conf_key ?>" data-check-error="#path_error_<?= $conf_key ?>"
                    />
                  </div>
                </div>
                <div class="col-sm-4 alert alert-danger path-error" id="path_error_<?= $conf_key ?>">
                  <i class="glyphicon glyphicon-exclamation-sign"></i> <p>This folder cannot be accessed.</p>
                </div>
              </div>
<?php   endif; ?>
              <div class="form-group row"> <!-- select how to restore -->
                <div class="col-sm-2 text-right">
                    <label class="col-form-label pad-top-6">Restore Method</label>
                </div>
                <div class="col-sm-10">
<?php   if ($is_db_section): // for databases, they have 3 options on how to restore ?>
                  <div class="radio">
                    <label><input
                      type="radio" checked="checked" value="target" name="restore_method_<?= $conf_key ?>"
                    >Dump backup to path above</label>
                  </div>
                  <div class="radio">
                    <label>
                      <input type="radio" value="dump_import" name="restore_method_<?= $conf_key ?>">
                      Dump current database to path above and overwrite current database with the backup
                    </label>
                  </div>
                  <div class="radio">
                    <label>
                      <input
                      type="radio" value="import" name="restore_method_<?= $conf_key ?>">
                      Overwrite current database without dumping first <em>(not recommended)</em>
                    </label>
                  </div>
<?php   else: // for homedirs, they have 2 options on how to restore, and a path that hides when unchecked ?>
                  <div class="row">
                    <div class="col-sm-12">
                      <div class="radio">
                        <label>
                          <input type="radio" value="merge" checked="checked" name="restore_method_<?= $conf_key ?>">
                          Restore to the original path: this replaces the files that are different and keeps files not found in the backup
                        </label>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-sm-3">
                      <div class="radio">
                        <label><input
                          type="radio" value="target" name="restore_method_<?= $conf_key ?>"
                        >Restore to a different folder</label>
                      </div>
                    </div>
                    <div class="col-sm-6">
                      <div class="input-group" id="homedir_restore_path">
                        <span class="input-group-addon"><?= $conf['home_path'] ?>/</span>
                        <input type="text" value="restored" class="form-control path-check"
                        id="dump_path_<?= $conf_key ?>" data-check-error="#path_error_<?= $conf_key ?>" />
                      </div>
                    </div>
                    <div class="col-sm-3 alert alert-danger path-error" id="path_error_<?= $conf_key ?>">
                      <i class="glyphicon glyphicon-exclamation-sign"></i> <p>This folder cannot be accessed.</p>
                    </div>
                  </div>
<?php   endif; ?>
                </div> <!-- end col-sm-10 -->
              </div> <!-- end row -->
              <div class="row">
                <div class="col-sm-2 text-right">
                  <label>Email to notify on completion (optional)</label>
                </div>
                <div class="col-sm-6">
                  <input id="<?= $conf_key ?>-restore-email" class="form-control validate-email" type="email" data-err="#<?= $conf_key ?>-invalid-email" />
                </div>
                <div class="col-sm-4 alert alert-danger error-msg" id="<?= $conf_key ?>-invalid-email">
                  <i class="glyphicon glyphicon-exclamation-sign"></i> <p>Invalid email address</p>
                </div>
              </div>
              <div class="row">
                <div class="col-sm-2"></div>
                <div class="col-sm-10 restore_alert" id="restore_alert_<?= $conf_key ?>"> <!-- alert div -->
                  <div class="col-sm-12">
                    <p>Clicking Restore will queue the restoration immediately, and restoring a backup is irreversible.</p>
                    <p>If restoring a website which relies on a database such as a WordPress website, you may need to restore both website files and SQL data.</p>
                    <p class="restore_alert_msg hidden" id="restore_alert_msg_<?= $conf_key ?>">Are you sure you want to proceed with the restore?</p>
                  </div>
                  <div class="col-sm-12 row restore-alert-btns">
                    <div class="col-sm-2 btn-restore-col">
                      <button id="restore-btn-<?= $conf_key ?>" onclick="do_restore('<?= $conf_key ?>', this);" class="btn btn-primary btn-block btn-restore">Restore</button>
                    </div>
                    <div class="col-sm-2">
                      <span class="cancel-link"><a onclick="cancel_restore_form(this);" href="#">Cancel</a></span>
                    </div>
                    <div class="col-sm-6">
                      <?php error_box("{$conf_key}-restore-msg"); ?>
                    </div>
                  </div>
                </div>
              </div>
<?php else: ?>
            <p>No backups available to restore</p>
<?php endif; ?>
            </div> <!-- end well -->
          </div> <!-- end panel-body -->
        </div> <!-- end collapse -->
      </div> <!-- end panel -->
