<?php
if ( empty(get_included_files()) ) die("Direct access forbidden");
?>

    <p>Backup protection can be enabled on your cPanel child accounts using the interface below.
    Once enabled, backup storage space can be allocated on a per account basis.  Additionally,
    you can enable Email Notifications on a per account basis.  If you do not need an account
    to be covered under the automated backup system the Backup Limit can be set to zero.</p>
    <div class="row" id="do-child-limit-row">
      <strong>Limit Child Account Usage</strong><?php
      show_switch('do_child_limits', $conf['children']['do_limit']);
      help_popover(<<<EOF
If enabled, child accounts will see the limit you specify as their maximum backup usage.
If disabled, they will see the same limit as your account in their cPanel interface.
The main account's backup usage is the sum of it and its child accounts.
EOF
);
      error_box('child-limit-toggle-msg'); ?>
    </div>
    <div class="row child-limit-inputs child-limit-top-inputs">
      <strong>Set the Default Limit for New Child Accounts:</strong>
      <input
        id="child_limit_default"
        class="form-control input-sm frm-sm text-right"
        type="number"
        value="<?php echo(round($conf['children']['default_limit'] / 1024, 2)); ?>"
      /> GB
    </div>
    <div class="row child-limit-inputs child-limit-top-inputs">
      <strong>Child account notifications will be sent to the following email address:</strong>
      <input id="child-limit-email" class="form-control input-sm frm-md validate-email" data-err="#child-notify-invalid-email" placeholder="user@example.com" value="<?php echo($conf['bak_conf']['child']['email']) ?>" />
      <div class="alert alert-danger error-msg" id="child-notify-invalid-email">
        <i class="glyphicon glyphicon-exclamation-sign"></i> <p>Invalid email address</p>
      </div>
    </div>
    <div id="child-form-header" class="row">
      <div class="col-sm-3"><h4>Account</h4></div>
      <div class="col-sm-2"><h4 class="child-limit-inputs">Backup Limit</h4></div>
      <div class="col-sm-2"><h4 class="child-limit-inputs">Email Notifications <?php help_popover(<<<EOF
If an email notification is On, then you will be emailed if that account is not getting backed up.
Your parent account will always be notified if it's not being backed up.
EOF
); ?></h4></div>
      <div class="col-sm-1"></div>
      <div class="col-sm-4"><h4>Current Backup Usage</h4></div>
    </div>
    <div id="child-form-reseller" class="row">
      <div class="col-sm-3"><strong><?php echo($conf['username']); ?></strong> <em>(parent)</em></div>
      <div class="col-sm-2"><span class="child-limit-inputs">
        <?php echo(round($conf['quota_mb'] / 1024, 2)); ?> GB <?php help_popover(<<<EOF
<p>This is the total amount of backup space used by your parent account. You can allocate some of this space to your child accounts.</p>
<p>If you set a child account backup limit to 0, that account will not be backed up.</p>
EOF
); ?>
      </span></div>
      <div class="col-sm-2"><span class="child-limit-inputs"></span></div>
      <div class="col-sm-2 text-right"><span id="parent_usage">??</span>GB<span class="child-limit-inputs"> / <?php echo(round($conf['quota_mb'] / 1024, 2)); ?>GB</span></div>
      <div class="col-sm-3">
        <div class="progress">
          <div id="parent_progressbar" class="progress-bar" role="progressbar" style="width: 0%"></div>
        </div>
      </div>
    </div>
<?php foreach(array_keys($conf['children']['limits']) as $child): ?>
    <div class="row childacct-row">
      <div class="col-sm-3"><strong class="child-name"><?php echo($child); ?></strong></div>
      <div class="col-sm-2"><span class="child-limit-inputs">
        <input
          max="<?php echo($conf['quota_mb'] / 1024); ?>" min="0" step="0.1"
          class="childacct-limit form-control input-sm frm-sm text-right" type="number"
          value="<?php child_limit($conf, $child); ?>" /> GB
      </span></div>
      <div class="col-sm-2"><span class="child-limit-inputs"><?php show_switch("childnotify-${child}", $conf['children']['notify'][$child], 'On', 'Off'); ?></span></div>
      <div
        class="col-sm-2 childacct-usage text-right"
<?php if (array_key_exists($child, $conf['children']['usage'])): ?>
        data-usage="<?php echo($conf['children']['usage'][$child]); ?>"
<?php endif;?>
      >
        <span class="usage_span">??</span>GB
        <span class="limit_span">??GB</span>
      </div>
      <div class="col-sm-3">
        <div class="progress">
          <div class="childacct-progressbar progress-bar" role="progressbar" style="width: 0%"></div>
        </div>
      </div>
    </div>
<?php endforeach; ?>
    <div class="alert alert-danger" id="overprovision-warn">
      <i class="glyphicon glyphicon-exclamation-sign"></i>
      <p>
        You are over provisioning based on your <?php echo(round($conf['quota_mb'] / 1024, 2)); ?>GB limit.
        <?php if (!$conf['is_child']): ?>
        Please <a href="<?php echo($amp_url); ?>">purchase more space</a> if you'd like to apply these backup limits.
        <?php endif; ?>
      </p>
    </div>
    <div class="row save-row child-limit-inputs">
      <button id="child-limit-apply-button" onclick="apply_child_limits(true);" class="btn btn-primary">Apply Backup Limits</button>
      <?php error_box('child-limit-apply-msg'); ?>
    </div>
