<?php
ini_set('log_errors', 1);
error_reporting(E_ALL);
require "/usr/local/cpanel/php/cpanel.php";
require "/opt/backups/cpanel_plugin/funcs.php";
// Print the base cpanel UI buttons at the top
$cpanel = new CPANEL();
print $cpanel->header('Backup Manager');
// Collect data from cpanel_plugin
$cpreseller = (isset($_SERVER['CPRESELLERSESSION']) && isset($_SERVER['CPRESELLER'])) ? $_SERVER['CPRESELLER'] : '';
$response = $cpanel->uapi(
  'Backups',
  'backups',
  array(
    'action' => 'get_settings',
    'args' => ''
  )
);
if ($response['cpanelresult']['result']['status'] === 1) { // uapi reported no errors
    try {
        $plugin_response = json_decode(
            $response['cpanelresult']['result']['data'],
            true, // associative
            512, //depth
            JSON_THROW_ON_ERROR // flags
        );
    } catch (Exception $exc) {
        $plugin_response = array(
            "status" => 255,
            "error" => 'PHP json_decode raised exception: ' . $exc->getMessage()
        );
    }
} else { // uapi reported errors
    $plugin_response = array(
        "status" => 255,
        "error" => 'cPanel uapi call reported an error: ' . json_encode($response['cpanelresult']['result']['errors'])
    );
}
if ($plugin_response['status'] === 0) {
  // Success
  $conf = $plugin_response['data'];
  $svr_class = $plugin_response['data']['svr_class'];
  $show_backup_mgr = $conf['quota_mb'] > 0;
  $is_vded = ($svr_class == 'imh_vps' || $svr_class == 'imh_ded');
  $no_subscription_warning = $conf['quota_mb'] == 0 && !$conf['is_child'] && !$conf['down'] && !$is_vded;
  $plugin_error = null;
  // if v/ded, logged in as root, viewed account has 0 quota and is a main user, server has > 0
  $root_limit_warning = $is_vded && $conf['is_main_user'] && $cpreseller == 'root' && $conf['quota_mb'] == 0 && isset($conf['svr_quota']) && $conf['svr_quota'] > 0;
  // if child account, logged in as a reseller, viewed account has 0 quota, owner has backups
  $res_limit_warning = $conf['is_child'] && $cpreseller != $conf['username'] && $cpreseller != '' && $conf['res_disabled'];
  if ($svr_class == 'hub_shared') {
    error_log('backup_mgr.live.php: Undefined support center urls for hub');
    $amp_url = 'https://secure.webhostinghub.com/amp/marketplace/backups/';
    // FIXME
    $article_main_page = 'https://www.inmotionhosting.com/support/edu/backups-and-restorations';
    $article_alt_folder = 'https://www.inmotionhosting.com/support/edu/backups-and-restorations/how-to-restore-a-backup-to-an-alternate-folder-using-the-backup-manager-in-cpanel';
    $article_add_storage = 'https://www.inmotionhosting.com/support/edu/backups-and-restorations/how-to-add-storage-for-data-backups-using-the-amp-marketplace';
    $branding_own = "WebHosting Hub's";
  } else {
    $article_whm_storage_breakdown = 'https://www.inmotionhosting.com/support/website/backup-and-restore/backup-manager-whm-vps-dedicated/';
    $amp_url = 'https://secure1.inmotionhosting.com/amp/marketplace/backups/';
    $article_main_page = 'https://www.inmotionhosting.com/support/edu/backups-and-restorations';
    $article_alt_folder = 'https://www.inmotionhosting.com/support/edu/backups-and-restorations/how-to-restore-a-backup-to-an-alternate-folder-using-the-backup-manager-in-cpanel';
    $article_add_storage = 'https://www.inmotionhosting.com/support/edu/backups-and-restorations/how-to-add-storage-for-data-backups-using-the-amp-marketplace';
    $article_res_child_limits = 'https://www.inmotionhosting.com/support/product-guides/reseller-hosting/view-disk-usage/';
    if ($conf['is_child']) {
      $branding_own = 'an';
    } else {
      $branding_own = "InMotion Hosting's";
    }
    $article_imh_vps_snapshots = 'https://www.inmotionhosting.com/support/high-availability/snapshots';
  }
} else {
  $show_backup_mgr = false;
  $no_subscription_warning = false;
  $plugin_error = $plugin_response['error'];
  $root_limit_warning = false;
  $res_limit_warning = false;
}
?>

<link rel="stylesheet" type="text/css" href="./backup_mgr.css?v=3.8.5.4" />
<script src="./3rdparty/jquery.min.js" type="text/javascript"></script>
<script src="./3rdparty/bootstrap.min.js" type="text/javascript"></script>
<script type="text/javascript">
  // cPanel's jQuery will fight us; use no conflict mode
  var $j = jQuery.noConflict(false);
  window.filebrowse_img_root = './file_browse_imgs';
  window.remote_ip = '<?php echo ($_SERVER['REMOTE_ADDR']); ?>';
  // fix the icon at the top left
  var icon = $j($j('#icon-')[0]);
  var header = $j($j('.page-header')[0]);
  icon.removeClass('icon-').addClass('icon-backup_mgr');
  icon.attr("id", "icon-backup_mgr");
</script>

<?php if ($show_backup_mgr) : // hide everything but the 3 stock plugins
?>
  <div id="loading-div">
    <div><i class="fa fa-spin fa-spinner"></i></div>
  </div>

  <script src="./backup_mgr.js?v=3.8.5.4" type="text/javascript"></script>
  <script src="./file_browse.js?v=3.8.5.4" type="text/javascript"></script>

  <?php require '/opt/backups/cpanel_plugin/modals.php'; ?>

  <!-- article section -->
  <div class="alert alert-info">
    <p>The Backup Manager feature allows you to utilize <?php echo ($branding_own); ?>
      automated backup system to retain and secure your data.
      Backups are stored in a cloud infrastructure on different physical hardware from this server
      and accessible from the restore tab below.
    </p>
    <p>From this interface you can view your current backup storage capacity,
      specify which data is backed up and how often, as well as perform data restorations.
      <?php if (!$conf['is_child']) : ?>
        Additional backup storage blocks can be purchased from the AMP Marketplace.
      <?php endif; ?>
    </p>
    <?php if (!$conf['is_child']) : ?>
      <p>For additional information, please visit
        <a href="<?php echo ($article_main_page); ?>" target="_blank">our Support Center Articles.</a>
      </p>
      <?php if ($svr_class == 'imh_vps') : ?>
        <p>The High Availability Cloud VPS product also offers
          <a href="<?php echo ($article_imh_vps_snapshots); ?>" target="_blank">complete snapshots</a>
          as another method of backing up your data and configuration.
        </p>
      <?php endif; ?>
    <?php endif; ?>
  </div>

  <span id="restore_queue_timer" class="hidden" data-dur="15"></span>
  <span id="homedir-size" class="hidden" data-homedir-size="<?php echo $conf['home_size_mb']; ?>"></span>

  <!-- current usage section -->
  <div id="current-usage-top">
    <div class="row">
      <strong>Space Required for next Scheduled Backup:</strong>
      <span class="text-nowrap">
        <span id="total_gb" data-quota-mb="<?php echo ($conf['quota_mb']); ?>" <?php if (array_key_exists('svr_usage', $conf)) : ?> data-srv-unused="<?php echo ($conf['svr_quota'] - $conf['svr_usage']) ?>" <?php endif; ?>>?</span>GB
        (<span id="avail_gb">?</span><span id="avail_denominator">/<?php echo (round($conf['quota_mb'] / 1024, 2)) ?></span><span id="avail_lbl">GB remain</span>)
      </span>
      <?php $retention = $conf['retention'];
      help_popover(
        <<<EOF
    <p>Account space is only counted once. If you have more than one backup, it does not count against your quota multiple times.</p>
    <p>However, if you have extra space remaining, the automated backup system will retain more incremental copies of your data.</p>
    <p>Based on the last calculated size of your account, the backup system will retain the <strong>{$retention} most recent</strong> copies once they are created.</p>
EOF
      ); ?>
      <div id="over-quota-hover">
        <span id="over-quota-glyph" class="glyphicon glyphicon-exclamation-sign"></span>
      </div>
      <div class="progress">
        <div class="total-selected-bar progress-bar" role="progressbar" style="width: 0%"></div>
      </div>
      <?php if (!$conf['is_child'] && !array_key_exists('svr_usage', $conf)) : ?>
        <a class="btn btn-sm btn-primary" href="<?php echo ($amp_url); ?>" target="_blank">Purchase Backup Space</a>
      <?php endif; ?>
    </div>
    <?php if (array_key_exists('svr_usage', $conf) && ($conf['is_main_user'] || $cpreseller == 'root')) : ?>
      <div class="row">
        <strong>Total Server Space:</strong>
        <?php echo (round($conf['svr_usage'] / 1024, 2)); ?>/<?php echo (round($conf['svr_quota'] / 1024, 2)); ?>GB
        <?php help_popover(
          <<<EOF
    <p>This is the total for all users on the server.</p>
    <p>This number is cached and may take some time to reflect any changes you make.</p>
EOF
        ); ?>
        <div class="progress">
          <div id="svr-total-bar" data-svr-quota="<?php echo ($conf['svr_quota']); ?>" data-svr-usage="<?php echo ($conf['svr_usage']); ?>" class="progress-bar" role="progressbar" style="width: 0%"></div>
        </div>
        <?php if (!$conf['is_child'] && ($conf['is_main_user'] || $cpreseller == 'root')) : ?>
          <a class="btn btn-sm btn-primary" href="<?php echo ($amp_url); ?>" target="_blank">Purchase Backup Space</a>
        <?php endif; ?>
      </div>
    <?php endif; ?>
  </div>

  <div class="row" id="total-over-quota-warning">
    <!-- additional warning that displays if over quota -->
    <div class="alert alert-warning">
      <i class="glyphicon glyphicon-exclamation-sign"></i>
      <p>
        <strong>Warning:</strong>
        Your account is over your Backups Quota and no longer backing up.
      </p>
    </div>
  </div>
  <div class="row" id="total-incalculable-warning">
    <!-- additional warning that displays if total quota is '?' -->
    <div class="alert alert-warning">
      <i class="glyphicon glyphicon-exclamation-sign"></i>
      <p class="incalculable-warning-p">
        <strong>Warning:</strong>
        Unable to fetch folder sizes to calculate backup size from your custom home directory selection.
        The account may contain too many files to determine folder sizes interactively.
      </p>
    </div>
  </div>

  <?php if ($conf['down_error'] != '') : ?>
    <div id="nodes-down-error" class="row alert alert-danger">
      <i class="glyphicon glyphicon-exclamation-sign"></i>
      <p><?= $conf['down_error'] ?></p>
    </div>
  <?php endif; ?>

  <ul class="nav nav-tabs">
    <!-- make the navigation tabs -->
    <li class="nav-item active">
      <a id="nav-link-restore" class="nav-link" data-toggle="tab" href="#restore_tab">Perform a Restore</a>
    </li>
    <li class="nav-item">
      <a class="nav-link" data-toggle="tab" href="#settings_tab">Backup Settings &amp; Scheduling</a>
    </li>
    <?php if ($conf['has_children'] == 1) : ?>
      <!-- only shown for resellers with at least one child -->
      <li class="nav-item">
        <a class="nav-link" data-toggle="tab" href="#child_tab">Child Accounts</a>
      </li>
    <?php endif; ?>
  </ul>

  <div class="tab-content">
    <!-- bodies of the navigation tabs -->
    <div id="restore_tab" class="tab-pane active" data-home-path="<?php echo($conf['home_path']) ?>">
      <!-- restore tab body -->

      <div id="restore_queue_div">
        <p><strong>Restorations in the last 7 Days</strong></p>
        <div id="restore_queue"></div>
      </div>

      <div class="row accordion_legend">
        <!-- legend row that shows above the restore tab's accordion -->
        <div class="col-sm-3">
          <h4>Backup Type</h4>
        </div>
      </div>
      <div class="panel-group" id="restore_accordion" data-show-geo="<?= $conf['show_geo'] ?>" data-geo-loc="<?= $conf['geo_info']['location'] ?>" data-cluster-loc="<?= $conf['cluster_info']['location'] ?>">
        <?php
        // homedir is always enabled; intentionally do not check cpuser_enable
        $section = 'Home Directory';
        $conf_key = 'homedir';
        require '/opt/backups/cpanel_plugin/restore.php';
        if ($conf['cpuser_enable']['mysql'] == 1) {
          $section = 'MySQL';
          $conf_key = 'mysql';
          require '/opt/backups/cpanel_plugin/restore.php';
        }
        if ($conf['cpuser_enable']['pgsql'] == 1) {
          $section = 'PgSQL';
          $conf_key = 'pgsql';
          require '/opt/backups/cpanel_plugin/restore.php';
        }
        ?>
      </div>
    </div>
    <div id="settings_tab" class="tab-pane" data-subpaths="<?php echo (htmlspecialchars(json_encode($conf['sizes']['subpaths']))); ?>" data-home-items="<?php echo (htmlspecialchars(json_encode($conf['sizes']['homedir']))); ?>">
      <div class="row accordion_legend">
        <!-- legend row that shows above the settings tab's accordion -->
        <div class="col-sm-3">
          <h4>Backup Type</h4>
        </div>
        <div class="col-sm-3 text-center">
          <h4>Schedule</h4>
        </div>
        <div class="col-sm-3 text-center">
          <h4>Data Backed Up</h4>
        </div>
        <div class="col-sm-3 text-right">
          <h4>Current Backup Usage</h4>
        </div>
      </div>
      <div class="panel-group" id="settings_accordion">
        <?php
        // homedir is always enabled; intentionally do not check cpuser_enable
        $section = 'Home Directory';
        $conf_key = 'homedir';
        require '/opt/backups/cpanel_plugin/settings.php';
        if ($conf['cpuser_enable']['mysql'] == 1) {
          $section = 'MySQL';
          $conf_key = 'mysql';
          require '/opt/backups/cpanel_plugin/settings.php';
        }
        if ($conf['cpuser_enable']['pgsql'] == 1) {
          $section = 'PgSQL';
          $conf_key = 'pgsql';
          require '/opt/backups/cpanel_plugin/settings.php';
        }
        ?>
      </div>
    </div>
    <?php if ($conf['has_children'] == 1) : ?>
      <!-- only shown for resellers with at least one child -->
      <div id="child_tab" class="tab-pane">
        <?php require '/opt/backups/cpanel_plugin/childaccts.php'; ?>
      </div>
    <?php endif; ?>
  </div>
<?php endif; // end $show_backup_mgr section
?>

<?php if ($root_limit_warning) : ?>
  <div class="alert alert-warning">
    <p>This account's backups are disabled through WHM >> Plugins >> Backup Manager in the
      <a href="<?php echo ($article_whm_storage_breakdown) ?>">Storage Breakdown</a> tab
    </p>
    <br /><small>(This message is only visible when viewing this account as root)</small>
  </div>
<? endif; ?>
<?php if ($res_limit_warning) : ?>
  <div class="alert alert-warning">
    <p>This account's backups are disabled by its reseller (<?php echo($conf['owner']) ?>) through Backup Manager in the
      <a href="<?php echo ($article_res_child_limits) ?>">Child Accounts</a> tab
    </p>
    <br /><small>(This message is only visible when viewing this account as its reseller or root)</small>
  </div>
<? endif; ?>
<?php if ($no_subscription_warning) : ?>
  <div class="alert alert-info">
    <p>You do not have an active subscription to the Backup Manager. You can purchase one in <a href="<?php echo ($amp_url); ?>">AMP</a>.</p>
    <p>For additional information, please visit our Support Center Articles below:</p>
    <ul>
      <li><a href="<?php echo ($article_add_storage); ?>" target="_blank">How to Add Storage for Data Backups using the AMP Marketplace</a></li>
      <li><a href="<?php echo ($article_main_page); ?>" target="_blank">Backups and Restorations</a></li>
    </ul>
  </div>
<?php endif;
if (!is_null($plugin_error)) : ?>
  <div class="alert alert-danger">
    <i class="glyphicon glyphicon-exclamation-sign"></i>
    <p><?php echo($plugin_error); ?></p>
  </div>
<?php
endif;

require '/opt/backups/cpanel_plugin/footer.php';
?>
