INSERT INTO %PREFIX%mail_templates (`mt_id`, `mt_name`, `mt_text`) VALUES ('', 'email_contact_supplier_form', 'Hello $_MTP[to_name],\r\nThe following email from $_MTP[from_name] was sent through the $_MTP[site] contact supplier form.\r\n\r\nMessage as follows:\r\n-------------------\r\nTo: $_MTP[to_name]\r\nFrom: $_MTP[from_name]\r\nEmail: $_MTP[from_email]\r\n\r\nSubject: $_MTP[subject]\r\n\r\nMessage:\r\n$_MTP[message]\r\n\r\n-------------------\r\n');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'suppliers', 'B', 'SUPPLIERS_ENABLE', 'Suppliers Enable (Visible)', '1', 'Determines if the Suppliers module links / output is visible.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'suppliers', 'I', 'BASE_SUPPLIER_ID', 'Supplier ID Base-Initial Value Minus 1', '1000', 'Determines the supplier id initial value for the first supplier entered in the system. Supplier ID will be this value plus one.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'suppliers', 'I', 'IPP_SUPPLIERS', 'Listing Items Per Page for: Suppliers', '15', 'Determines the number of suppliers that are displayed on a page.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'suppliers', 'I', 'IPL_SUPPLIERS', 'Listing Items Per List for: Supplier Account', '5', 'Determines the number of most recent items (bills and emailarchive messages) that are displayed on a suppliers account page.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('automation', 'bills', 'B', 'BILL_ACOPY_DELAY_ENABLE', 'Bill Auto-Copy Delay Enable', '1', 'Determines if the auto-copy of recurring bills is delayed until new bill date is within days out setting.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('automation', 'bills', 'I', 'BILL_ACOPY_DAYS_OUT', 'Bill Auto-Copy Days Out to Copy', '15', 'Determines number of days from current date to auto-copy a recurring bill. Will auto-copy if the new bill date falls within this date range.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('automation', 'bills', 'B', 'BILL_AUTO_UPDATE_ENABLE', 'Bill Auto-Update of Status Enable', '1', 'Determines if the auto-update of bill status function is enabled when triggered by cron job or manually by command summary actions menu.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('automation', 'bills', 'B', 'BILL_AUTO_COPY_ENABLE', 'Bill Auto-Copy Recurring Enable', '1', 'Determines if the auto-copy of recurring bills function is enabled when triggered by cron job or manually by command summary actions menu.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'bills', 'I', 'BILL_DUE_DAYS_OFFSET', 'Bill Due Date Offset from Create in Days', '15', 'Determines the number of days to add to current date and set the due date to when creating a new bill.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'bills', 'B', 'BILL_TAX_01_ENABLE', 'Bill Tax 01 Enable', '1', 'Determines if bill tax 01 is enabled for display.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'bills', 'B', 'BILL_TAX_02_ENABLE', 'Bill Tax 02 Enable', '1', 'Determines if bill tax 02 is enabled for display.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'bills', 'B', 'BILL_SPLIT_TRANS_LIST_ENABLE', 'Bill Transaction Listing Split Enable', '0', 'Determines if the bill transaction listing is split to list charges on top, and then credits below (in seperate list).');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'bills', 'S', 'BILL_TAX_01_LABEL', 'Bill Tax 01 Text Label', '13% HST:', 'Determines the text label displayed on bills in place of "Tax 01".');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'bills', 'S', 'BILL_TAX_02_LABEL', 'Bill Tax 02 Text Label', '5% PST:', 'Determines the text label displayed on bills in place of "Tax 01".');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'bills', 'I', 'BILL_VIEW_SHOW_TRANS', 'Bill View Show Transactions Enable', '3', 'Determines if the bill transactions listing is displayed on lower portion of bill view. 0: No, 1: On-Screen Only, 2: Printed Only, 3: Onscreen and Printed ');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'bills', 'B', 'BILLS_ENABLE', 'Bills Enable (Visible)', '1', 'Determines if the Bills module links / output is visible.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'bills', 'R', 'BILL_TAX_01_DEF_VAL', 'Bill Tax 01 Rate Default Value', '13.00', 'Determines the default tax rate percentage value inserted for this tax. Example 1.00 equates to 1 percent.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'bills', 'R', 'BILL_TAX_02_DEF_VAL', 'Bill Tax 02 Rate Default Value', '5.00', 'Determines the default tax rate percentage value inserted for this tax. Example 1.00 equates to 1 percent.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'bills', 'I', 'BASE_BILL_ID', 'Bill ID Base-Initial Value Minus 1', '1000', 'Determines the bill id initial value for the first bill entered in the system. Bill ID will be this value plus one.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'summary', 'B', 'SUMMARY_BILLS_BY_PRODUCT', 'Summary: Display expenses that have been billed', '1', 'If "Yes", phpCOIN will display a table with the number of times each billed expense appears on a bill, as well as the total value.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'summary', 'S', 'SUMMARY_BILLS_BY_PRODUCT_IGNORE', 'Summary: Ignore these billed expenses', '', 'A pipe-separated list of item codes on bills that should be ignored when building the billed expenses summary.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'bills', 'B', 'BILL_TAX_BY_ITEM', 'Bill Tax By Item Enable', '1', 'Determines if the taxes are applied at the items level (each item), or just on the total of items.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'bills', 'I', 'IPP_BILLS', 'Listing Items Per Page for: Bills', '15', 'Determines the number of bills that are displayed  in listing form on a page.\r\n');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'bills', 'B', 'BILL_PRICES_INCLUDE_TAXES', 'Bill Taxes Are Included In Price', '0', 'If "No", phpCOIN will add applicable taxes to items on invoices. If "Yes", phpCOIN assumes that the prices include tax. In that event, taxes will be removed from the items and then recalculated, so the bill can show the amount of taxes included in the prices.');
CREATE TABLE IF NOT EXISTS %PREFIX%bills (`bill_id` int(11) NOT NULL default '0', `bill_status` varchar(20) NOT NULL default 'draft', `bill_s_id` int(11) NOT NULL default '0', `bill_invoice_number` varchar(20) NOT NULL default '', `bill_total_cost` double default '0', `bill_total_paid` double default '0', `bill_subtotal_cost` double default '0', `bill_tax_01_percent` double default '0', `bill_tax_01_amount` double default '0', `bill_tax_02_percent` double default '0', `bill_tax_02_amount` double default '0', `bill_tax_autocalc` tinyint(1) NOT NULL default '1', `bill_ts` int(11) NOT NULL, `bill_ts_due` int(11) NOT NULL, `bill_ts_paid` int(11) NOT NULL, `bill_cycle` tinyint(1) NOT NULL default '1', `bill_recurring` tinyint(1) NOT NULL default '0', `bill_recurr_proc` tinyint(4) NOT NULL default '0',  PRIMARY KEY (`bill_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Bills Module Table';
CREATE TABLE IF NOT EXISTS %PREFIX%bills_items (`bi_bill_id` int(11) NOT NULL default '0', `bi_item_no` smallint(4) NOT NULL default '0', `bi_item_name` varchar(30) NOT NULL default '', `bi_item_desc` varchar(75) NOT NULL default '', `bi_item_cost` double default '0', `bi_apply_tax_01` tinyint(1) NOT NULL default '1', `bi_apply_tax_02` tinyint(1) NOT NULL default '1', `bi_calc_tax_02_pb` tinyint(1) NOT NULL default '0', PRIMARY KEY (`bi_bill_id`,`bi_item_no`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Bills Module Items Table';
CREATE TABLE IF NOT EXISTS %PREFIX%bills_trans (`bt_id` bigint(11) NOT NULL auto_increment, `bt_ts` int(11) NOT NULL, `bt_bill_id` int(11) NOT NULL default '0', `bt_type` tinyint(2) NOT NULL default '0', `bt_origin` tinyint(2) NOT NULL default '0', `bt_desc` varchar(50) NOT NULL default '', `bt_amount` double default '0', PRIMARY KEY (`bt_id`)) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='Site Bills Module Transactions Table';
CREATE TABLE IF NOT EXISTS %PREFIX%suppliers (`s_id` int(11) NOT NULL default '0', `s_status` varchar(20) NOT NULL default 'pending', `s_company` varchar(50) NOT NULL default '', `s_name_first` varchar(20) NOT NULL default '', `s_name_last` varchar(20) NOT NULL default '', `s_addr_01` varchar(50) NOT NULL default '', `s_addr_02` varchar(50) NOT NULL default '', `s_city` varchar(50) NOT NULL default '', `s_state_prov` varchar(50) NOT NULL default '', `s_country` varchar(50) NOT NULL default '', `s_zip_code` varchar(12) NOT NULL default '', `s_phone` varchar(20) NOT NULL default '', `s_fax` varchar(20) NOT NULL default '', `s_tollfree` varchar(20) NOT NULL default '', `s_email` varchar(50) NOT NULL default '', `s_taxid` varchar(20) NOT NULL default '', `s_account` varchar(20) NOT NULL default '', `s_terms` varchar(20) NOT NULL, `s_notes` text NOT NULL, PRIMARY KEY (`s_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Suppliers Module Table';
CREATE TABLE IF NOT EXISTS %PREFIX%suppliers_contacts (`contacts_id` int(11) NOT NULL auto_increment, `contacts_s_id` int(11) NOT NULL default '0', `contacts_name_first` varchar(20) NOT NULL default '', `contacts_name_last` varchar(20) NOT NULL default '', `contacts_email` varchar(50) NOT NULL default '', UNIQUE KEY `contacts_id` (`contacts_id`), KEY `contacts_s_id` (`contacts_s_id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Site Suppliers Additional Emails Table';
ALTER table %PREFIX%clients MODIFY cl_join_ts int(11);
ALTER table %PREFIX%invoices MODIFY invc_ts int(11);
ALTER table %PREFIX%invoices MODIFY invc_ts_due int(11);
ALTER table %PREFIX%invoices MODIFY invc_ts_paid int(11);
ALTER table %PREFIX%invoices_trans MODIFY it_ts int(11);
ALTER table %PREFIX%orders MODIFY ord_ts int(11);
UPDATE %PREFIX%versions SET v_ts=%TIMESTAMP%, v_ver='v1.5.0 R1', v_type='Upgrade';