UPDATE `%PREFIX%pages` SET subject='Backup Failed', topic_id='3', pages_title='Backup Failed', pages_code='The MySQL database backup procedure has completed, but for some reason the file was not written to the server. Please check the location in Admin -> parameters -> subgroup=backup and ensure the the webserver user has write permission to that location' WHERE id='1';
DELETE FROM `%PREFIX%parameters` WHERE parm_name='IPP_MNEWS';
DELETE FROM `%PREFIX%parameters` WHERE parm_name='SITE_FOOTER_EMAIL_WEBMASTER';
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'S', 'SUMMARY_INVOICES_BY_PRODUCT_STATUS_IGNORE', 'Invoiced Products: Ignore these status', '1|4|5|6', 'A pipe-separated list of invoice statuses that should be ignored when building the invoiced products summary. This list MUST be the $_CCFG[''INV_STATUS''][] array element number, NOT the text of the status');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'B', 'SUMMARY_THIS_YEAR', 'Summary: Current Year Only', '1', 'YES: Display data on Summary page for this year only\r\nNO: Display data on Summary page for all dates in database');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'layout', 'summary', 'S', 'SUMMARY_EXPENSES_STATUS_IGNORE', 'Expenses: Ignore these status', '1|4|5', 'A pipe-separated list of bill statuses that should be ignored when building the billed expenses summary. This list MUST be the $_CCFG[''BILL_STATUS''][] array element number, NOT the text of the status');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'orders', 'B', 'ENABLE_AUTOPASS_ORDERS', 'Orders: AutoPassword Enable', '1', 'YES: phpCOIN will display a button that will generate a random password and fill the input boxes when clicked\r\nNO: The user must make up their own password');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'clients', 'B', 'ENABLE_AUTOPASS_CLIENTS', 'Clients: AutoPassword Enable', '1', 'YES: phpCOIN will display a button that will generate a random password and fill the input boxes when clicked\r\nNO: The user must make up their own password');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'domains', 'B', 'ENABLE_AUTOPASS_DOMAINS', 'Domains: AutoPassword Enable', '1', 'YES: phpCOIN will display a button that will generate a random password and fill the input boxes when clicked\r\nNO: The user must make up their own password');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'clients', 'B', 'AUTOPASSWORD_STRENGTH', 'Clients: Strongest Auto-Password', '1', 'YES: An auto-generated password will utilize the full alphanumeric character set and symbols, in the ASCII range 33 to 126\r\nNO: An auto-generated password will utilize only lowercase letters');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'clients', 'B', 'ALLOW_NULL_EMAIL', 'Allow Clients With No Email Address', '1', 'Web-Hosts will want clients to have an email address for auto-billing, but accountants can now use phpCOIN for tracking/invoicing clients with no email');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'ordering', 'orders', 'B', 'SKIP_CONFIRM_SCREEN', 'Skip Order Confirmation Page', '0', 'YES: Skip the confirmation screen and send the client straight to paylink\r\nNO: Display the order confirmation page so a client can change order info before processing');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'operation', 'invoices', 'B', 'Company_In_Select', 'Client List: Select by Company Name', '1', 'When adding or editing an invoice, the "client" drop-down will be:\r\nYES: CompanyName - LastName, FirstName\r\nNO: LastName, FirstName - UserName');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'email', 'B', 'client_can_resend', 'Email Archive: Client Can Resend Messages', '1', 'YES: On archived email listings, client will have an ''email'' icon to allow the client to re-send any previous message\r\nNO: On archived email listings, client will not have an ''email'' icon to allow the client to re-send any previous message');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'email', 'B', 'no_cc_on_resend', 'Email Archive: Resend To CC and BCC', '0', 'YES: When an archived email message is resent, any CC or BCC recipients on the original message WILL receive a copy of the message again\r\nNO: When an archived email message is resent, any CC or BCC recipients on the original message will NOT receive a copy of the message again');
INSERT INTO `%PREFIX%parameters` (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES('', 'enable', 'email', 'B', 'show_archive_to_clients', 'Email Archive: Show To Client', '1', 'YES: When a client views their "My Account" summary page, they will also see a section showing every email that was sent to them if "Email Archive: Enable" is enabled. Client can view/print any message, and re-send a message if "Email Archive: Client Can Resend Messages" is enabled\r\nNO: When a client views their "My Account" summary page, they will NOT see a section showing every email that was sent to them');
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='helpdesk', parm_desc='Auto-import: Enable', parm_notes='YES: The helpdesk cronjob will connect to a POP or IMAP box and attempt to create helpdesk tickets or ticket messages from any emails found\r\nNO: (obvious)' WHERE parm_name='HELPDESK_AUTO_IMPORT_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='helpdesk', parm_desc='Auto-import: Server', parm_notes='Name of the email server the helpdesk cronjob should connect to' WHERE parm_name='HELPDESK_AUTO_IMPORT_SERVER';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='helpdesk', parm_desc='Auto-import: Protocol', parm_notes='Protocol and port that the helpdesk cronjob should connect to\r\n"/imap:143" seems to work better than "/pop:110"\r\nYou may also need to try /IMAP/:143/notls or /:110/POP/notls or even other strings, depending on your mailserver' WHERE parm_name='HELPDESK_AUTO_IMPORT_TYPE';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='helpdesk', parm_desc='Auto-import: UserName', parm_notes='The email username that the helpdesk cronjob will check' WHERE parm_name='HELPDESK_AUTO_IMPORT_USERID';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='helpdesk', parm_desc='Auto-import: Password', parm_notes='Password for the email account that will be checked by the helpdesk cronjob' WHERE parm_name='HELPDESK_AUTO_IMPORT_PASSWORD';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='helpdesk', parm_desc='Auto-import: Delete Messages', parm_notes='Delete _these_ messages on the mail-server when the helpdesk cronjob runs' WHERE parm_name='HELPDESK_AUTO_IMPORT_DELETE_MESSAGES';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='helpdesk', parm_desc='Auto-import: Category', parm_notes='Default "category" for helpdesk tickets auto-created by the helpdesk cronjob' WHERE parm_name='HELPDESK_AUTO_IMPORT_DEFAULT_CATEGORY';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='helpdesk', parm_desc='Auto-import: Priority', parm_notes='Default "priority" for helpdesk tickets auto-created by the helpdesk cronjob' WHERE parm_name='HELPDESK_AUTO_IMPORT_DEFAULT_PRIORITY';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='helpdesk', parm_desc='Auto-import: Status', parm_notes='Default "status" for helpdesk tickets auto-created by the helpdesk cronjob' WHERE parm_name='HELPDESK_AUTO_IMPORT_DEFAULT_STATUS';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='helpdesk', parm_desc='Auto-import: Verbose', parm_notes='YES: phpCOIN will display the results of processing of each email message\r\nNO: phpCOIN will only display aggregate results' WHERE parm_name='HELPDESK_AUTO_VERBOSE';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='invoices', parm_desc='Invoice Auto-Copy: Delay', parm_notes='YES: Wait until new invoice date is within days-out setting before auto-copying new invoice. Auto-invoices will not sit as "pending" for a long time, and invoice numbers will be close to sequential\r\nNO: Auto-copy new invoice as soon as possible. An auto-invoice for next year will sit as "pending" for almost a year, and invoice numbers will not be sequential' WHERE parm_name='INVC_ACOPY_DELAY_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='invoices', parm_desc='Invoice Auto-Copy: Days Out to Copy', parm_notes='The number of days from current date to auto-copy a recurring invoice. Auto-copy will occur if the new invoice date falls within this date range' WHERE parm_name='INVC_ACOPY_DAYS_OUT';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='invoices', parm_desc='Invoice Auto-Copy: Auto-Update Status', parm_notes='YES: Auto-update of invoice status will occur when triggered by cron job or when run manually by command summary actions menu\r\nNO: Auto-update of invoice status will not occur' WHERE parm_name='INVC_AUTO_UPDATE_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='invoices', parm_desc='Invoice Auto-Copy: Enable', parm_notes='YES: Auto-copy of invoices will occur when triggered by cron job or when run manually by command summary actions menu\r\nNO: Auto-copy of invoices will not occur' WHERE parm_name='INVC_AUTO_COPY_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='invoices', parm_desc='Invoice Reminders: Autosend Overdue Reminders', parm_notes='YES: phpCOIN will auto-send the specified email message on the specified overdue day(s)\r\nNO: You must manually remind your customers that they are overdue.\r\nYou may setup as many event-dates and templates as you need.' WHERE parm_name='INVC_AUTO_REMINDERS_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='invoices', parm_desc='Invoice Reminders: Autosend Soon-Due Reminders', parm_notes='YES: phpCOIN will auto-send "reminders" email message number zero half way between the invoice issued and due dates\r\nNO: There will be NO reminders sent that an invoice will soon be due' WHERE parm_name='INVC_SOON_REMINDERS_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='invoices', parm_desc='Order Invoice: Auto-Create From Order', parm_notes='YES: Auto-create an invoice with the default terms, due dates, etc. every time a product is ordered\r\nNO: No invoice will be auto-created' WHERE parm_name='ORDER_AUTO_CREATE_INVOICE';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='invoices', parm_desc='Order Invoice: Auto-Recur From Order', parm_notes='YES: The invoice will be set to recur automatically by cronjob\r\nNO: The invoice will be set as NOT recurring (ie: one-time)' WHERE parm_name='AUTO_INV_RECUR';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='invoices', parm_desc='Order Invoice: Default Status', parm_notes='Default status of invoices auto-created by the order module.' WHERE parm_name='AUTO_INV_STATUS';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='invoices', parm_desc='Order Invoice: Default Delivery Method', parm_notes='Default delivery method for invoices auto-created by the order module.' WHERE parm_name='AUTO_INV_DELIVERY';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='invoices', parm_desc='Order Invoice: Default Billing Cycle', parm_notes='Default billing cycle for invoices auto-created by the order module.' WHERE parm_name='AUTO_INVC_BILL_CYCLE';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='invoices', parm_desc='Order Invoice: Flag as Delivered', parm_notes='Should the invoice "delivered" flag be set to delivered?' WHERE parm_name='AUTO_INV_DELIVERED';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='API', parm_desc='API Output Enable: Order COR Proc', parm_notes='If the API Output function is called when a COR order record is created by the order process' WHERE parm_name='APIO_ORDER_COR_PROC_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='API', parm_desc='API Output Enable: Order New Client', parm_notes='If the API Output function is called when a client record is created by the order process' WHERE parm_name='APIO_ORDER_NEW_CLIENT_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='API', parm_desc='API Output Enable: Order New Domain', parm_notes='If the API Output function is called when a domain record is created by the order process' WHERE parm_name='APIO_ORDER_NEW_DOMAIN_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='API', parm_desc='API Output Enable: Order Out Proc', parm_notes='If the API Output function is called when a client is shown the paylink during the order process' WHERE parm_name='APIO_ORDER_OUT_PROC_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='API', parm_desc='API Output Enable: Order Return Proc', parm_notes='If the API Output function is called when a client returns from clicking the paylink during the order process' WHERE parm_name='APIO_ORDER_RET_PROC_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='API', parm_desc='API Output Enable: Order Created', parm_notes='If the API Output function is called when an order record is created' WHERE parm_name='APIO_ORDER_NEW_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='API', parm_desc='API Output Enable: API System Activated', parm_notes='YES: The individual API Output functions enabled are allowed to trigger\r\nNO: Regardless of the individual API settings, no API functions will be triggered' WHERE parm_name='APIO_MASTER_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='admin', parm_desc='Automatically Check For Updates: Enable', parm_notes='YES: phpCOIN will check for new versions and bug-fixes each time you click the [Admin] or [Summary] button.  This enables phpCOIN to advise you when a new version or bug-fix is available, and provides a direct link to the actual download.  This feature uses an RSS feed, and does NOT send any information whatsoever to phpCOIN.com\r\nNO: Do not check for available updates and bug-fixes' WHERE parm_name='AUTOCHECK_UPDATES';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='admin', parm_desc='Menu Block: Max Menu Blocks', parm_notes='The maximum number to appear in the menu block position field drop-down list.' WHERE parm_name='_MAX_MENU_BLK_POS';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='admin', parm_desc='Menu Block: Max Block Items', parm_notes='The maximum number to appear in the menu item position field drop-down list.' WHERE parm_name='_MAX_MENU_ITM_NO';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='admin', parm_desc='Parameters: Show Notes in Listing', parm_notes='Enable the display of the parameter notes field in the main listing (what you are looking at right now)' WHERE parm_name='_PARM_EDITOR_SHOW_NOTES';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='admin', parm_desc='Admin Menu: Display as List', parm_notes='YES: Displays the Admin menu as "list" style\r\nNO: Displays the Admin menu as "button" table' WHERE parm_name='DisplayType';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='articles', parm_desc='List: Items Per Page', parm_notes='The number of articles that are displayed in listing form on a page.' WHERE parm_name='IPP_ARTICLES';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='articles', parm_desc='Articles Date/Time Display Format', parm_notes='The display format for Articles date display. See http://www.php.net/manual/en/function.strftime.php for formatting options.' WHERE parm_name='ARTICLES_DATE_DISPLAY_FORMAT';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='clients', parm_desc='List: Items Per Page', parm_notes='The number of clients that are displayed in listing form on a page' WHERE parm_name='IPP_CLIENTS';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='API', parm_desc='API Output Enable: Client Created', parm_notes='If the API Output function is called when a client record is created by admin' WHERE parm_name='APIO_CLIENT_NEW_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='API', parm_desc='API Output Enable: Client Deleted', parm_notes='If the API Output function is called when a client record is deleted by admin' WHERE parm_name='APIO_CLIENT_DEL_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='API', parm_desc='API Output Enable: Domain Created', parm_notes='If the API Output function is called when a domain record is created by admin' WHERE parm_name='APIO_DOMAIN_NEW_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='API', parm_desc='API Output Enable: Domain Deleted', parm_notes='If the API Output function is called when a domain record is deleted by admin' WHERE parm_name='APIO_DOMAIN_DEL_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='API', parm_desc='API Output Enable: Order Deleted', parm_notes='If the API Output function is called when an order record is deleted by admin' WHERE parm_name='APIO_ORDER_DEL_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='API', parm_desc='API Output Enable: Product Created', parm_notes='If the API Output function is called when a product record is created by admin' WHERE parm_name='APIO_PRODUCT_NEW_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='API', parm_desc='API Output Enable: Product Deleted', parm_notes='If the API Output function is called when a product record is deleted by admin' WHERE parm_name='APIO_PRODUCT_DEL_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='API', parm_desc='API Output Enable: Trans Created', parm_notes='If the API Output function is called when a transaction record (invoice, payment, etc.) is created' WHERE parm_name='APIO_TRANS_NEW_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='API', parm_desc='API Output Enable: Trans Deleted', parm_notes='If the API Output function is called when a transaction record (invoice, payment, etc.) is deleted by admin' WHERE parm_name='APIO_TRANS_DEL_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='backup', parm_desc='Save On Server: Save Directory', parm_notes='Directory on webserver to save mySQL dump file to when the "save to webserver" backup option is chosen.' WHERE parm_name='MYSQL_BACKUP_SAVE_DIR';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='backup', parm_desc='Backup By Email: Email From Name', parm_notes='The name of the person that the email is from when the "Email to me" backup option is chosen.' WHERE parm_name='MYSQL_BACKUP_EMAIL_FROM_NAME';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='backup', parm_desc='Backup By Email: Email From Address', parm_notes='The email address of the person that the email is from when the "Email to me" backup option is chosen.' WHERE parm_name='MYSQL_BACKUP_EMAIL_FROM_ADDRESS';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='backup', parm_desc='Backup By Email: Email To Name', parm_notes='The name of the person that the email is to when the "Email to me" backup option is chosen.' WHERE parm_name='MYSQL_BACKUP_EMAIL_TO_NAME';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='backup', parm_desc='Backup By Email: Email To Address', parm_notes='The email address of the person that the email is to when the "Email to me" backup option is chosen.' WHERE parm_name='MYSQL_BACKUP_EMAIL_TO_ADDRESS';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='backup', parm_desc='Backup By Email: Email Subject', parm_notes='Subject line of email sent when "Email to me" backup option is chosen.' WHERE parm_name='MYSQL_BACKUP_EMAIL_SUBJECT';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='backup', parm_desc='Backup By Email: Email Body', parm_notes='The message body when the "Email to me" backup option is chosen.' WHERE parm_name='MYSQL_BACKUP_EMAIL_BODY';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='backup', parm_desc='Backup By Email: Email Priority', parm_notes='Priority of message when "email to me" backup option is chosen. 1 is "Urgent", 3 is "Normal".' WHERE parm_name='MYSQL_BACKUP_EMAIL_PRIORITY';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='clients', parm_desc='Clients: Initial Value', parm_notes='Starting point for the first client entered in the system. Client ID will be this value plus one' WHERE parm_name='BASE_CLIENT_ID';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='clients', parm_desc='List: Items Per Summary', parm_notes='The number of most recent items per section (orders, invoices, tickets) that are displayed on a client account page' WHERE parm_name='IPL_CLIENTS_ACCOUNT';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='clients', parm_desc='Orders: Client Status on Create', parm_notes='The default client status used when a new client is created during the ordering process' WHERE parm_name='CLIENT_DEF_STATUS_NEW';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='clients', parm_desc='Client Profile Email: CC To Admin', parm_notes='YES: When a client clicks the icon to email their client profile, the site admin will receive a copy of the email\r\nNO: When a client clicks the icon to email their client profile, the site admin will not receive a copy of the email' WHERE parm_name='CLIENT_EMAIL_CC_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='clients', parm_desc='Login: AlphaNumeric UserName Only', parm_notes='YES: The username must contain only letters and numbers\r\nNO: Special characters such as pound and underscore are allowed in a username' WHERE parm_name='Username_AlphaNum';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='clients', parm_desc='Login: Max. Characters for User Name', parm_notes='The maximum number of characters permitted in username form fields.' WHERE parm_name='CLIENT_MAX_LEN_UNAME';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='clients', parm_desc='Login: Max. Characters for Password', parm_notes='The maximum number of characters permitted in password form fields' WHERE parm_name='CLIENT_MAX_LEN_PWORD';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='clients', parm_desc='Login: Min. Characters for Password', parm_notes='The minimum number of characters permitted in password form fields' WHERE parm_name='CLIENT_MIN_LEN_PWORD';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='clients', parm_desc='Default: Page View Upon Login', parm_notes='The page to show the client when they first log in' WHERE parm_name='CLIENT_VIEW_PAGE_UPON_LOGIN';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='clients', parm_desc='List: Optional Data Displayed', parm_notes='Select the two-out-of-three columns that you wish displayed when viewing a list of clients.' WHERE parm_name='CLIENT_LIST_DISPLAY';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='clients', parm_desc='Allow Clients With No Email Address', parm_notes='Web-Hosts will want clients to have an email address for auto-billing, but accountants can now use phpCOIN for tracking/invoicing clients with no email' WHERE parm_name='ALLOW_NULL_EMAIL';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='email', parm_desc='Mail Contacts: ID For Billing', parm_notes='The mail contact id to be used when phpCOIN requires an email address for Billing' WHERE parm_name='MC_ID_BILLING';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='email', parm_desc='Mail Contacts: ID For Orders', parm_notes='The mail contact id to be used when phpCOIN requires an email address for Orders' WHERE parm_name='MC_ID_ORDERS';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='email', parm_desc='Mail Contacts: ID For Support', parm_notes='The mail contact id to be used when phpCOIN requires an email address for Support' WHERE parm_name='MC_ID_SUPPORT';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='email', parm_desc='Mail Contacts: ID For Webmaster', parm_notes='The mail contact id to be used when phpCOIN requires an email address for Webmaster' WHERE parm_name='MC_ID_WEBMASTER';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='domains', parm_desc='List: Items Per Page', parm_notes='The number of domains that are displayed in listing form on a page' WHERE parm_name='IPP_DOMAINS';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='domains', parm_desc='Default: Server ID', parm_notes='The default server id that is inserted when a domain is created' WHERE parm_name='DOM_DEFAULT_SERVER';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='domains', parm_desc='Default: Path', parm_notes='The default file-system path to domain files inserted when a domain account is created. Use "username" to insert client user name, or "domain" to insert the domain name' WHERE parm_name='DOM_DEFAULT_PATH';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='domains', parm_desc='Domain Info Email: CC To Admin', parm_notes='YES: When a client clicks the icon to email their domain information, the site admin will receive a copy of the email\r\nNO: When a client clicks the icon to email their domain information, the site admin will not receive a copy of the email' WHERE parm_name='DOM_EMAIL_CC_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='domains', parm_desc='Domains: All Names Valid', parm_notes='NO: Domain names entered will be checked to ensure that the TLD is in the list of TLDs you support in the WHOIS module\r\nYES: The domain name validation logic will always return that the entered domain name is valid, even if that TLD is not active in WHOIS' WHERE parm_name='DOM_FORCE_CHECK_TRUE';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='domains', parm_desc='Default: IP Address', parm_notes='The default domain IP address that is inserted when a domain account is created.' WHERE parm_name='DOM_DEFAULT_IP';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='domains', parm_desc='CP/FTP: Default User Name', parm_notes='The default CP/FTP User Name inserted when a domain account is created by the order process. Choose "username" to insert client user name, or "domain" to insert the domain name' WHERE parm_name='DOM_DEFAULT_USERNAME';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='domains', parm_desc='Default: Control Panel URL', parm_notes='The URL (fully qualified) that will be used for the control panel link shown in domain listings. Variables that can be used her and will be replaced with actual values at run-time are:\r\n%DOM_ID% the domain_id\r\n%DOM_NAME% the domain name\r\n%CL_ID% client_id\r\n%FTP_NAME% default CP/FTP username\r\n%FTP_PWORD% default CP/FTP password' WHERE parm_name='DOM_DEFAULT_CP_URL';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='domains', parm_desc='List: Enable CP Link', parm_notes='YES: The control panel link will be shown in domain listings\r\nNO: The CP link will not be shown in listings' WHERE parm_name='DOM_CP_URL_LINK_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='domains', parm_desc='CP/FTP: Use phpCOIN Password For FTP', parm_notes='NO: A random password for FTP will be generated by phpCOIN.\r\nYES: The FTP password created by phpCOIN will match the username and password entered by the client for accessing phpCOIN. This means that you will know the u/p for account creation with cPanel, etc., but it is a security risk because this info is stored in the clear in the database' WHERE parm_name='MATCH_CP_LOGIN_TO_ACCOUNT';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='domains', parm_desc='CP/FTP: Show Passwords To Clients', parm_notes='YES: Clients can see their plaintext passwords for FTP and Control Panel access when viewing domain info\r\nNO: Only admins can see the passwords' WHERE parm_name='SHOW_PASSWORDS_TO_CLIENTS';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='domains', parm_desc='Domains: Enable', parm_notes='YES: Module is enabled and ready for use\r\nNO: Module is deactivated, all menu buttons/links are automatically hidden, and no output from this module will be visible' WHERE parm_name='DOMAINS_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='helpdesk', parm_desc='List: Items Per Page', parm_notes='The number of helpdesk tickets that are displayed  in listing form on a page' WHERE parm_name='IPP_HELPDESK';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='helpdesk', parm_desc='HelpDesk TT ID Base-Initial Value Minus 1', parm_notes='Determines the helpdesk ticket id initial value for the first helpdesk ticket entered in the system. Helpdesk Ticket ID will be this value plus one.' WHERE parm_name='BASE_HELPDESK_ID';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='helpdesk', parm_desc='HelpDesk: Enable', parm_notes='YES: Module is enabled and ready for use\r\nNO: Module is deactivated, all menu buttons/links are automatically hidden, and no output from this module will be visible' WHERE parm_name='HELPDESK_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='helpdesk', parm_desc='HelpDesk TT Alert Email: Address', parm_notes='The email (pager email) address the Alert Email is sent to. Does not effect normal support email received' WHERE parm_name='HELPDESK_ALERT_EMAIL_ADDRESS';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='helpdesk', parm_desc='Helpdesk TT Alert Email: Enable', parm_notes='YES: An Alert Email is also sent when a new ticket is created, in addition to normal email to support\r\nNO: Only the normal email to support is sent' WHERE parm_name='HELPDESK_ALERT_EMAIL_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='helpdesk', parm_desc='HelpDesk Admin: Reveal Admin Identity', parm_notes='YES: The specific admin responding to HelpDesk items will be identified in listings and emails\r\nNO: HelpDesk listings and emails will show as being from "support"' WHERE parm_name='HELPDESK_ADMIN_REVEAL_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='helpdesk', parm_desc='Helpdesk Message Email: CC To Client', parm_notes='YES: Client will receive a CC of the email when they submit a helpdesk message\r\nNO: Only support receives the message' WHERE parm_name='HELPDESK_MSG_CC_CLIENT_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='helpdesk', parm_desc='HelpDesk Reply: Limit Messages Sent', parm_notes='YES: Include only the X most recent messages for the HelpDesk Ticket in the reply notice email\r\nNO: Include all messages for the HelpDesk Ticket in the reply notice email' WHERE parm_name='HELPDESK_REPLY_EMAIL_SET_LIMIT';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='helpdesk', parm_desc='Helpdesk Reply: Email Messages Limit', parm_notes='The number of most recent messages to include in the reply notice email.' WHERE parm_name='HELPDESK_REPLY_EMAIL_LIMIT';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='helpdesk', parm_desc='List: Show Client Name', parm_notes='Enable the Client column in the helpdesk tickets listing when viewed by admins' WHERE parm_name='HELPDESK_SHOW_CLIENT_NAME';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='helpdesk', parm_desc='HelpDesk Admin: Admin Can Enter Tickets', parm_notes='YES: An administrator can enter a new support ticket on behalf of a client\r\nNO: Only a logged-in client can enter a new support ticket.' WHERE parm_name='HELPDESK_ADMIN_CAN_ADD';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='invoices', parm_desc='List: Items Per Page', parm_notes='Determines the number of invoices that are displayed  in listing form on a page.' WHERE parm_name='IPP_INVOICES';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='invoices', parm_desc='Invoice ID Initial Value', parm_notes='Starting point for the first invoice entered in the system. Invoice ID will be this value plus one' WHERE parm_name='BASE_INVOICE_ID';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='invoices', parm_desc='Invoice Auto-Email to Clients Enable', parm_notes='YES: Auto-email of due invoices is enabled when triggered by cron job or manually by command summary actions menu' WHERE parm_name='INVC_AUTO_EMAIL_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='invoices', parm_desc='Invoice Auto-Email CC Admin Enable', parm_notes='YES: Admin will receive a copy each time the auto-email code sends an invoice' WHERE parm_name='INVC_AUTO_EMAIL_CC_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='invoices', parm_desc='Invoice Delivery Method Default Value', parm_notes='The default invoice delivery method presented on invoice create' WHERE parm_name='INVC_DEL_MTHD_DEFAULT';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='invoices', parm_desc='Invoice Due x Days After Create', parm_notes='When an invoice is created, phpCOIN will add this many days to the create date in order to auto-calc the due date' WHERE parm_name='INVC_DUE_DAYS_OFFSET';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='invoices', parm_desc='Invoice Email CC Admin Enable', parm_notes='YES: Admin will receive a copy each time a request is made to email an invoice' WHERE parm_name='INVC_EMAIL_CC_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='invoices', parm_desc='Invoices: Tax 01 Enable', parm_notes='YES: Tax 1 will be calculated and displayed on invoices\r\nNO: Tax 1 will NOT be calculated and displayed on invoices' WHERE parm_name='INVC_TAX_01_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='invoices', parm_desc='Invoices: Tax 02 Enable', parm_notes='YES: Tax 2 will be calculated and displayed on invoices\r\nNO: Tax 2 will NOT be calculated and displayed on invoices' WHERE parm_name='INVC_TAX_02_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='invoices', parm_desc='Invoice Terms: Auto-Insert Default', parm_notes='YES: When terms are enabled, the terms field is auto-populated with the default terms on new invoices if admin left them empty on save\r\nNO: When terms are enabled, the terms field is left blank on new invoices if admin left them empty on save' WHERE parm_name='INVC_TERMS_INSERT_DEF';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='invoices', parm_desc='Invoice Terms: Enable', parm_notes='YES: The invoice terms field is displayed on invoice views' WHERE parm_name='INVC_TERMS_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='invoices', parm_desc='Invoices: Show Pending To Client', parm_notes='YES: The client will see invoices that are set to pending status. Useful as advance warning about upcoming invoices\r\nNO: The client will not see invoices that are set to pending status. No advance warning about upcoming invoices' WHERE parm_name='INVC_SHOW_CLIENT_PENDING';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='invoices', parm_desc='Invoice Transaction Listing: Enable Split Listing', parm_notes='YES: The invoice transaction listing is split to list charges on top, and then credits below in a separate list\r\nNO: invoice transactions appear in a single section one after the other, like a standard statement' WHERE parm_name='INVC_SPLIT_TRANS_LIST_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='invoices', parm_desc='Invoice Taxes: Tax By Item', parm_notes='YES: Taxes will be calculated on each item individually\r\nNO: Taxes will be calculated only on the invoice totals' WHERE parm_name='INVC_TAX_BY_ITEM';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='invoices', parm_desc='Invoice Tax 01: Label', parm_notes='The text label displayed on bills in place of "Tax 01"' WHERE parm_name='INVC_TAX_01_LABEL';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='invoices', parm_desc='Invoice Tax 01: Rate', parm_notes='The default tax rate percentage value used for this tax during auto-calc. For example: 1.00 is 1 percent' WHERE parm_name='INVC_TAX_01_DEF_VAL';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='invoices', parm_desc='Invoice Tax 02: Label', parm_notes='The text label displayed on bills in place of "Tax 02"' WHERE parm_name='INVC_TAX_02_LABEL';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='invoices', parm_desc='Invoice Tax 02: Rate', parm_notes='The default tax rate percentage value used for this tax during auto-calc. For example: 1.00 is 1 percent' WHERE parm_name='INVC_TAX_02_DEF_VAL';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='invoices', parm_desc='Invoice Transaction Listing: Show Transactions', parm_notes='If the transactions listing is displayed on lower portion of invoice:\r\n0: No transactions displayed\r\n1: Transactions displayed on-screen only\r\n2: Transactions displayed on printed output only\r\n3: Transactions appear on both screen and printed output' WHERE parm_name='INVC_VIEW_SHOW_TRANS';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='invoices', parm_desc= 'Invoice Taxes: Prices Include Taxes', parm_notes='NO: phpCOIN will add applicable taxes to items on invoices\r\nYES: phpCOIN assumes that the prices include tax. In this event, taxes will be removed from the items and then recalculated, so the invoice can show the amount of taxes included in the prices.' WHERE parm_name='PRICES_INCLUDE_TAXES';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='invoices', parm_desc='Invoice Email: Single Line Per Item', parm_notes='YES: Set each item on an emailed invoice to be single-line like a paper invoice. The formatting only works for text invoices and will not line up properly if outgoing html emails are enabled\r\nNO: Use multiple lines to describe each item. Layout is not messed up with outgoing html emails enabled, but it does not look like and invoice' WHERE parm_name='SINGLE_LINE_EMAIL_INVOICE_ITEMS';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='invoices', parm_desc='Invoices: Enable', parm_notes='YES: Module is enabled and ready for use\r\nNO: Module is deactivated, all menu buttons/links are automatically hidden, and no output from this module will be visible' WHERE parm_name='INVOICES_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='invoices', parm_desc='Invoices: Show Last Nag', parm_notes='YES: An additional info-box containing the name of the last nag email sent (if any) will be displayed as part of the invoice' WHERE parm_name='INVC_SHOW_LAST_NAG';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='package', parm_desc='Site Footer Block: Line 01 Text', parm_notes='The line 01 text that will be displayed in footer of the page output' WHERE parm_name='_PKG_FOOTER_LINE_01';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='package', parm_desc='Site Footer Block: Line 02 Text', parm_notes='The line 02 text that will be displayed in footer of the page output' WHERE parm_name='_PKG_FOOTER_LINE_02';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='email', parm_desc='Email: Enable', parm_notes='YES: phpCOIN will send all normal emails\r\nNO: The main email functions are disabled from sending email', parm_name='_PKG_EMAIL_OUT_ENABLE' WHERE parm_name='_PKG_EMAIL_OUT_DISABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='email', parm_desc='Email Contact Client: Use Custom Subject', parm_notes='YES: Use the subject that you entered on the form instead\r\nNO: Use the default subject line of "sitename- Client Contact Message" on emails sent using the [eMail Client] form' WHERE parm_name='MAIL_USE_CUSTOM_SUBJECT';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='email', parm_desc='Email: Use Safe Address Format', parm_notes='YES: Emails will be sent as only <name@address> which every mail-server will accept\r\nNO: Emails sent from phpCOIN use the "Name <name@address>" format. Some mail-servers have a problem with this' WHERE parm_name='_PKG_SAFE_EMAIL_ADDRESS';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='email', parm_desc='HTML Email: Enable HTML Outgoing', parm_notes='YES: phpCOIN will send html emails\r\nNO: phpCOIN will send plain-text only emails' WHERE parm_name='EMAIL_AS_HTML';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='admin', parm_desc='Quick-Edit Icons: Enable', parm_notes='YES: Display quick-access icons where appropriate for editing parameters and page text, rather than forcing admin to goto Admin and select menu items\r\nNO: Settings and content can only be edited by clicking through the relevant buttons and menus' WHERE parm_name='ENABLE_QUICK_EDIT';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='List: Items Per Page', parm_notes='The number of orders that are displayed in listing form on a page' WHERE parm_name='IPP_ORDERS';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='orders', parm_desc='Order ID Base-Initial Value Minus 1', parm_notes='Determines the order id initial value for the first order entered in the system. Order ID will be this value plus one.' WHERE parm_name='BASE_ORDER_ID';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='orders', parm_desc='Order Email: Mail to Admin on Order Out', parm_notes='YES: An email is sent to admin when client is showed the order paylink (order inserted into system)' WHERE parm_name='ENABLE_EMAIL_ORDER_OUT';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='orders', parm_desc='Order Email: Mail to Admin on Order Return', parm_notes='YES: An email is sent to admin when client is returned to phpCOIN from billing vendor' WHERE parm_name='ENABLE_EMAIL_ORDER_RET';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='Order Policy Button Show: AUP', parm_notes='Determines if order policy button for Acceptable Use Policy is shown on place order screens.' WHERE parm_name='ORDER_POLICY_BTTN_AUP';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='Order Policy Button Show: BC', parm_notes='Determines if order policy button for Banned Code is shown on place order screens.' WHERE parm_name='ORDER_POLICY_BTTN_BC';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='Order Policy Button Show: PP', parm_notes='Determines if order policy button for Privacy Policy is shown on place order screens.' WHERE parm_name='ORDER_POLICY_BTTN_PP';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='Order Policy Button Show: TOS', parm_notes='Determines if order policy button for Terms Of Service is shown on place order screens.' WHERE parm_name='ORDER_POLICY_BTTN_TOS';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='orders', parm_desc='Order Policy SiteInfo ID for: AUP', parm_notes='Determines the siteinfo page id for the Acceptable Use Policy button link.' WHERE parm_name='ORDER_POLICY_SI_ID_AUP';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='orders', parm_desc='Order Policy SiteInfo ID for: BC', parm_notes='Determines the siteinfo page id for the Banned Code Policy button link.' WHERE parm_name='ORDER_POLICY_SI_ID_BC';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='orders', parm_desc='Order Policy SiteInfo ID for: PP', parm_notes='Determines the siteinfo page id for the Privacy Policy button link.' WHERE parm_name='ORDER_POLICY_SI_ID_PP';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='orders', parm_desc='Order Policy SiteInfo ID for: TOS', parm_notes='Determines the siteinfo page id for the Terms Of Service button link.' WHERE parm_name='ORDER_POLICY_SI_ID_TOS';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='orders', parm_desc='Order Email: CC To Admin', parm_notes='YES: The site admin will receive a copy each time a request is made to email a order' WHERE parm_name='ORDER_EMAIL_CC_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='orders', parm_desc='Order Email: Ack Email To Client', parm_notes='YES: An acknowledgment email will be sent to client on new order' WHERE parm_name='ORDERS_ACK_EMAIL_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='orders', parm_desc='Order Email: Ack Email To Client On Return', parm_notes='An acknowledgment email will be sent to client on return from vendor, instead of upon paylink display' WHERE parm_name='ORDERS_ACK_EMAIL_ONRET';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='orders', parm_desc='Orders: Enable', parm_notes='YES: Module is enabled and ready for use\r\nNO: Module is deactivated, all menu buttons/links are automatically hidden, and no output from this module will be visible' WHERE parm_name='ORDERS_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='orders', parm_desc='Orders Req. Acceptable Use Policy (AUP): Enable', parm_notes='YES: The "Acceptable Use Policy" button is visible and client must check "I agree to AUP" box during order placement' WHERE parm_name='ORDERS_AUP_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='orders', parm_desc='Custom Order Request (COR): Enable', parm_notes='YES: a surfer can click the COR button to submit a price request for a custom order during the order process\r\nNO: The surfer can order only pre-defined products and services' WHERE parm_name='ORDERS_COR_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='orders', parm_desc='Orders Req. Terms Of Service (TOS): Enable', parm_notes='YES: The "Terms of Service" button is visible and client must check "I agree to TOS" box during order placement' WHERE parm_name='ORDERS_TOS_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='orders', parm_desc='Orders: Default Status on Create', parm_notes='The default order status used when an order is placed' WHERE parm_name='ORDERS_DEF_STATUS_NEW';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='Order Form: Enable Fields On COR', parm_notes='Determines which fields are enabled (visible) on the orders COR form.' WHERE parm_name='ORDERS_FIELD_ENABLE_COR';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='Order Form: Enable Fields On Form', parm_notes='Determines which fields are enabled (visible) on the orders order form. This also effects client editing forms.' WHERE parm_name='ORDERS_FIELD_ENABLE_ORD';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='Order Form: Require Fields On COR', parm_notes='Determines which fields are required (visible) on the orders COR form.' WHERE parm_name='ORDERS_FIELD_REQUIRE_COR';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='Order Form: Require Fields On Form', parm_notes='Determines which fields are required (visible) on the orders order form. This also effects client editing forms.' WHERE parm_name='ORDERS_FIELD_REQUIRE_ORD';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='Order Form: Show Product Description', parm_notes='Determines if the Product description will be displayed on Orders Listings instead of the default Vendor / Product Name columns.' WHERE parm_name='ORDERS_LIST_SHOW_PROD_DESC';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='Order Form: Products Display Sequence', parm_notes='What to display on the Products List shown to clients when ordering.' WHERE parm_name='ORDERS_PROD_DISPLAY_SEQUENCE';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='Order Form: Product List Primary Sort Field', parm_notes='Determines which field will be the ascending sort order for the order screen products list.' WHERE parm_name='ORDERS_PROD_LIST_SORT_ORDER';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='orders', parm_desc='Default Payment Method On Order Form', parm_notes='The billing method to use on a new order, or let client select payment method from a drop-down list of vendors. If you specify a vendor here, all modules that normally display the billing vendor will no longer do so.' WHERE parm_name='DEFAULT_PAYMENT_METHOD';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='orders', parm_desc='Orders: Add Order Setup Fee', parm_notes='Any amount here other than zero will be added to the price of the product ordered as a setup fee, and the words " (plus setup fee)" will be appended to the item description on the order' WHERE parm_name='ORDER_SETUP_FEE';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='Order Form: Product List Size', parm_notes='0: Products will be displayed as a radio list on the order form\r\nAny non-zero value: phpCOIN will use a select-list with that many rows visible' WHERE parm_name='ORDERS_PROD_LIST_SIZE';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='Orders: Group Products With Heading', parm_notes='YES: If items are displayed on order form by radio list, phpCOIN will "group" the products by the first word in the product display, with that word also used as a group title.  This means you can group products by name, description or price\r\nNO: Do not "group" products' WHERE parm_name='ORDERS_ITEMS_SUB-LIST';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='clients', parm_desc='Clients: Allow Editing Info On Re-order', parm_notes='YES will allow an existing client to edit their contact info when placing a new order. NO will display their contact info without allowing editing' WHERE parm_name='ORDER_EDIT_CLIENT';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='Order Form: Show User IP', parm_notes='YES: Display the users IP address and a warning about being tracked when placing a new order\r\nNO: Do not display the users IP address and warning about being tracked' WHERE parm_name='ORDER_SHOW_IP';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='package', parm_desc='Currency Prefix String (ex. $)', parm_notes='The currency notation prefix, placed in front of currency amounts where formatted to display' WHERE parm_name='_CURRENCY_PREFIX';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='package', parm_desc='Currency Suffix String (ex. USD)', parm_notes='The currency notation suffix, placed following currency amounts where formatted to display' WHERE parm_name='_CURRENCY_SUFFIX';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='package', parm_desc='Language: Database Setting', parm_notes='Which language files to load, and can  be overridden by config.php setting. The language file directory and files MUST exist prior to selection' WHERE parm_name='_DB_PKG_LANG';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='package', parm_desc='Package Locale: Datetime Display', parm_notes='Some examples:\r\nBulgaria - bg_BG\r\nEnglish  - en_EN (or English)\r\nFrench   - fr_FR\r\nGerman  - German\r\nSwedish  - sv_SE\r\nSpanish  - Spanish' WHERE parm_name='_DB_PKG_LOCALE';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='package', parm_desc='Theme: Database Setting', parm_notes='Which theme files to load, can be overridden by config.php setting. The theme file directory and files MUST exist prior to selection' WHERE parm_name='_DB_PKG_THEME';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='package', parm_desc='Number Format (see notes)', parm_notes='Example number 1234.56\r\nValue = 1	Output: 1234\r\nValue = 2	Output: 1234.56\r\nValue = 3	Output: 1,234.56\r\nValue = 4	Output: 1 234,56\r\nValue = 5	Output: 1.234,56' WHERE parm_name='_NUMBER_FORMAT_ID';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='package', parm_desc='Site Name: Short', parm_notes='For display of site name (short version). This variable is used extensively in emails and various pages' WHERE parm_name='_PKG_NAME_SHORT';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='package', parm_desc='Site Name: Long', parm_notes='Site long name for display, emails, etc. Basically longer version of the site short name' WHERE parm_name='_PKG_NAME_LONG';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='email', parm_desc='Email: Default Email', parm_notes='Last resort email address used when phpCOIN cannot locate a mail contacts entry' WHERE parm_name='_PKG_EMAIL_MAIL';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='package', parm_desc='Site Top Block Greeting Text', parm_notes='The Site Top Block (header) greeting text displayed if logo is not enabled.' WHERE parm_name='_PKG_TOP_GREETING';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='package', parm_desc='Date Display: Server Offset In Hours', parm_notes='Add or subtract this many hours from server time for the timestamps recorded / displayed' WHERE parm_name='_PKG_DATE_SERVER_OFFSET';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='package', parm_desc='Date Display: Format For Short Date', parm_notes='The display format for the short date, not locale setting dependent. See http://www.php.net/manual/en/function.date.php for formatting options' WHERE parm_name='_PKG_DATE_FORMAT_SHORT_DT';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='package', parm_desc='Date Display: Format For Short DateTime', parm_notes='The display format for the short datetime, not locale setting dependent. See http://www.php.net/manual/en/function.date.php for formatting options' WHERE parm_name='_PKG_DATE_FORMAT_SHORT_DTTM';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='package', parm_desc='Date Display: Format For Header Row', parm_notes='The display format for the header block date display. See http://www.php.net/manual/en/function.strftime.php for formatting options' WHERE parm_name='_PKG_DATE_FORMAT_HEADER';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='package', parm_desc='Date Display: Format for Printing', parm_notes='The display format for the footer printed items date display. See http://www.php.net/manual/en/function.strftime.php for formatting options' WHERE parm_name='_PKG_DATE_FORMAT_PRINT';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='admin', parm_desc='Banned IP Addresses: Enable', parm_notes='YES: Enables admin to create a list of banned IP addresses that can not view the site. Banned IPs are redirected to error message' WHERE parm_name='_PKG_ENABLE_IP_BAN';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='email', parm_desc='Email Archive: Enable', parm_notes='YES: Archive ALL emails sent by or through phpCOIN\r\nNO: Archive no emails sent by or through phpCOIN' WHERE parm_name='_PKG_ENABLE_EMAIL_ARCHIVE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='package', parm_desc='Exchange Rate For PayLinks', parm_notes='If you show your prices in one currency and collect payment in another, enter the exchange rate here. If you do not use different currencies, leave this as either 1 or 0' WHERE parm_name='PAYLINK_EXCHANGE_RATE';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='package', parm_desc='Use Login Menu Box', parm_notes='LEFT COLUMN: A login/logoff box will be displayed in the left column before any menus, and the logon/logoff button in the header will be disabled.\r\nRIGHT COLUMN: A login/logoff box will be displayed in the right column before any menus, and the logon/logoff button in the header will be disabled\r\nNONE: phpCOIN defaults to normal operation\r\nMake sure that Admin -> Parameters -> Themes -> Disable Menu Columns (Left / Right) is also set to "NO" if left or right column option is chosen' WHERE parm_name='USE_LOGIN_MENUBOX';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='pages', parm_desc='List: Items Per Page', parm_notes='The number of pages that are displayed in listing form on a page' WHERE parm_name='IPP_PAGES';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='summary', parm_desc='Domains Expiring: Days Before Expiry', parm_notes='When Domains Expiring Summary is enabled, list domain names that will expire within this many days from today' WHERE parm_name='CC_DOMAIN_EXP_IN_DAYS';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='summary', parm_desc='Domains Expiring: Enable', parm_notes='YES: Display domain names that will expire within X days from today' WHERE parm_name='CC_DOMAIN_EXP_LIST_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='summary', parm_desc='Domains Expiring: Include Expired', parm_notes='YES: Include expired domains in Domains Expiring Summary' WHERE parm_name='CC_DOMAIN_EXP_LIST_INCL_EXPRD';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='summary', parm_desc='Server Accounts Expiring: Days Before Expiry', parm_notes='When Server Accounts Expiring Summary is enabled, list domain names that will expire within this many days from today' WHERE parm_name='CC_SACC_EXP_IN_DAYS';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='summary', parm_desc='Server Accounts Expiring: Enable', parm_notes='YES: Display a summary of server accounts expiring within x days, or expired' WHERE parm_name='CC_SACC_EXP_LIST_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='summary', parm_desc='Server Accounts Expiring: Include Expired', parm_notes='YES: Include expired domains in Server Accounts Expiring Summary.' WHERE parm_name='CC_SACC_EXP_LIST_INCL_EXPRD';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='summary', parm_desc='Servers Summary: Enable', parm_notes='Display a list of all your servers, and the number of domains on each server' WHERE parm_name='CC_SERVER_LIST_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='summary', parm_desc='Active Product Orders: Enable', parm_notes='YES: Display a summary of all products that are on an active order.  If "Orders Listing Show Prod. Description" in the "orders" section is set to "Yes", then the description will show on the display, otherwise the product name will be shown.\r\nNO: Do not display' WHERE parm_name='PRODUCT_SUMMARY_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='summary', parm_desc='Invoices By Billing Cycle: Enable', parm_notes='YES: Invoices will be listed in columnar format, with the amounts broken out by status and billing cycle\r\nNO: Lump all billing cycles into one column.' WHERE parm_name='SUMMARY_INVOICES_BY_TYPE';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='summary', parm_desc='Invoiced Products: Enable', parm_notes='YES: Display a table with the number of times each product appears on an invoice, as well as the total value' WHERE parm_name='SUMMARY_INVOICES_BY_PRODUCT';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='summary', parm_desc='Invoiced Products: Ignore these items', parm_notes='A pipe-separated list of item names on invoices that should be ignored when building the "Invoiced Products Summary"' WHERE parm_name='SUMMARY_INVOICES_BY_PRODUCT_IGNORE';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='whois', parm_desc='WHOIS: Add Domain Setup Fee', parm_notes='Any amount here other than zero will be added to the price of the product ordered as a domain setup fee, and the words " (plus setup fee)" will be appended to the item description on the order IF the whois module "Order" link was clicked.' WHERE parm_name='DOMAIN_SETUP_FEE';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='whois', parm_desc='WHOIS: Registrar Affiliate Link', parm_notes='If you are an affiliate of a domain registrar and wish to use an affiliate link to register domains, enter the URL of the link here.' WHERE parm_name='WHOIS_AFFILIATE_LINK';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='whois', parm_desc='WHOIS: Show Extensions As DropDown', parm_notes='YES: Show allowable domain extensions as a drop-down list\r\nNO: Show the list as radio buttons' WHERE parm_name='WHOIS_EXT_LIST';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='whois', parm_desc='Show Domain Details In New Window', parm_notes='YES: Show details of registered domain in new "popup" window\r\nNO: Use current window' WHERE parm_name='WHOIS_DETAILS_NEW';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='whois', parm_desc='WHOIS: Show Short Instructions', parm_notes='YES: Show abbreviated domain selection instructions to surfers\r\nNO: Show the long instructions' WHERE parm_name='WHOIS_INSTRUCTIONS_SHORT';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='whois', parm_desc='WHOIS: Enable', parm_notes='YES: Module is enabled and ready for use\r\nNO: Module is deactivated, all menu buttons/links are automatically hidden, and no output from this module will be visible' WHERE parm_name='WHOIS_ENABLED';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='whois', parm_desc='WHOIS: Domain Registration Operation', parm_notes='0= Do NOT add an "Order" or "Register" link\r\n1= Add "Order" link and go to "orders" page, passing in domain name and setting "New Domain" to "Yes"\r\n2= Add "Register" link, going to your affiliate link to register the domain. This option will open a new browser window to the registrar, and the original browser window will remain on this page' WHERE parm_name='WHOIS_LINK';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 01: Enable', parm_notes='Determines whether the button appears in the top menu.' WHERE parm_name='_HDR_MENU_BTTN_01';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 02: Enable', parm_notes='Determines whether the button appears in the top menu.' WHERE parm_name='_HDR_MENU_BTTN_02';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 03: Enable', parm_notes='Determines whether the button appears in the top menu.' WHERE parm_name='_HDR_MENU_BTTN_03';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 04: Enable', parm_notes='Determines whether the button appears in the top menu.' WHERE parm_name='_HDR_MENU_BTTN_04';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 05: Enable', parm_notes='Determines whether the button appears in the top menu.' WHERE parm_name='_HDR_MENU_BTTN_05';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 06: Enable', parm_notes='Determines whether the button appears in the top menu.' WHERE parm_name='_HDR_MENU_BTTN_06';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 07: Enable', parm_notes='Determines whether the button appears in the top menu.' WHERE parm_name='_HDR_MENU_BTTN_07';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 08: Enable', parm_notes='Determines whether the button appears in the top menu.' WHERE parm_name='_HDR_MENU_BTTN_08';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 09: Enable', parm_notes='Determines whether the button appears in the top menu.' WHERE parm_name='_HDR_MENU_BTTN_09';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 01: Link', parm_notes='Determines link (URL) for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_LINK_01';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 02: Link', parm_notes='Determines link (URL) for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_LINK_02';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 03: Link', parm_notes='Determines link (URL) for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_LINK_03';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 04: Link', parm_notes='Determines link (URL) for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_LINK_04';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 05: Link', parm_notes='Determines link (URL) for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_LINK_05';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 06: Link', parm_notes='Determines link (URL) for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_LINK_06';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 07: Link', parm_notes='Determines link (URL) for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_LINK_07';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 08: Link', parm_notes='Determines link (URL) for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_LINK_08';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 09: Link', parm_notes='Determines link (URL) for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_LINK_09';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 01: Image', parm_notes='Determines image for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_IMG_01';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 02: Image', parm_notes='Determines image for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_IMG_02';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 03: Image', parm_notes='Determines image for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_IMG_03';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 04: Image', parm_notes='Determines image for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_IMG_04';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 05: Image', parm_notes='Determines image for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_IMG_05';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 06: Image', parm_notes='Determines image for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_IMG_06';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 07: Image', parm_notes='Determines image for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_IMG_07';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 08: Image', parm_notes='Determines image for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_IMG_08';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='Header Menu Button 09: Image', parm_notes='Determines image for the corresponding button in main menu.' WHERE parm_name='_HDR_MENU_BTTN_IMG_09';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 02: Enable', parm_notes='Determines whether the button appears in the user menu.' WHERE parm_name='_USR_MENU_BTTN_02';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 03: Enable', parm_notes='Determines whether the button appears in the user menu.' WHERE parm_name='_USR_MENU_BTTN_03';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 04: Enable', parm_notes='Determines whether the button appears in the user menu.' WHERE parm_name='_USR_MENU_BTTN_04';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 05: Enable', parm_notes='Determines whether the button appears in the user menu.' WHERE parm_name='_USR_MENU_BTTN_05';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 06: Enable', parm_notes='Determines whether the button appears in the user menu.' WHERE parm_name='_USR_MENU_BTTN_06';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 07: Enable', parm_notes='Determines whether the button appears in the user menu.' WHERE parm_name='_USR_MENU_BTTN_07';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 08: Enable', parm_notes='Determines whether the button appears in the user menu.' WHERE parm_name='_USR_MENU_BTTN_08';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 02: Link', parm_notes='Determines link (URL) for the corresponding button in user menu.' WHERE parm_name='_USR_MENU_BTTN_LINK_02';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 03: Link', parm_notes='Determines link (URL) for the corresponding button in user menu.' WHERE parm_name='_USR_MENU_BTTN_LINK_03';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 04: Link', parm_notes='Determines link (URL) for the corresponding button in user menu.' WHERE parm_name='_USR_MENU_BTTN_LINK_04';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 05: Link', parm_notes='Determines link (URL) for the corresponding button in user menu.' WHERE parm_name='_USR_MENU_BTTN_LINK_05';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 06: Link', parm_notes='Determines link (URL) for the corresponding button in user menu.' WHERE parm_name='_USR_MENU_BTTN_LINK_06';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 07: Link', parm_notes='Determines link (URL) for the corresponding button in user menu.' WHERE parm_name='_USR_MENU_BTTN_LINK_07';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 08: Link', parm_notes='Determines link (URL) for the corresponding button in user menu.' WHERE parm_name='_USR_MENU_BTTN_LINK_08';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 02: Image', parm_notes='Determines image for the corresponding button in user menu.' WHERE parm_name='_USR_MENU_BTTN_IMG_02';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 03: Image', parm_notes='Determines image for the corresponding button in user menu.' WHERE parm_name='_USR_MENU_BTTN_IMG_03';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 04: Image', parm_notes='Determines image for the corresponding button in user menu.' WHERE parm_name='_USR_MENU_BTTN_IMG_04';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 05: Image', parm_notes='Determines image for the corresponding button in user menu.' WHERE parm_name='_USR_MENU_BTTN_IMG_05';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 06: Image', parm_notes='Determines image for the corresponding button in user menu.' WHERE parm_name='_USR_MENU_BTTN_IMG_06';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 07: Image', parm_notes='Determines image for the corresponding button in user menu.' WHERE parm_name='_USR_MENU_BTTN_IMG_07';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='buttons', parm_desc='User Menu Button 08: Image', parm_notes='Determines image for the corresponding button in user menu.' WHERE parm_name='_USR_MENU_BTTN_IMG_08';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Menu Columns: Disable', parm_notes='YES: Do not display the page left / right menu columns' WHERE parm_name='_DISABLE_MENU_COLS';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Header: Disable Block', parm_notes='YES: Hide the page header row' WHERE parm_name='_DISABLE_HEADER_BLK';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Footer: Disable', parm_notes='YES: Hide the page footer row' WHERE parm_name='_DISABLE_FOOTER_BLK';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='admin', parm_desc='Admin Login Link Button Enable', parm_notes='YES: An "Admin" login button link is displayed on the client login screen\r\nNO: Button is not displayed. The only way for an admin to login is to manually type the URL to the admin login form' WHERE parm_name='_ENABLE_ADMIN_LOGIN_LINK';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Form Button Mouseover: Enable', parm_notes='YES: Enable the mouseover action on all form buttons throughout phpCOIN' WHERE parm_name='_ENABLE_BTN_MOUSEOVER';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Header: User Menu Same Block', parm_notes='YES: The logged in user / admin menu is visible directly below the main header menu, within the same block' WHERE parm_name='_ENABLE_MENU_USER_HDR';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Header: User Menu New Block', parm_notes='YES: The logged in user / admin menu is visible directly below the main header menu, as a separate block' WHERE parm_name='_ENABLE_MENU_USER_HROW';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Footer: User Menu Row', parm_notes='YES: The logged in user / admin menu is visible as an additional row above the footer' WHERE parm_name='_ENABLE_MENU_USER_FROW';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Header: Show Date', parm_notes='YES: Display the date in the page header block' WHERE parm_name='_PAGE_HEADER_DATE';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Header: Show Logo', parm_notes='YES: Display the site logo in the page header block\r\nNO: Display greeting text in the page header block' WHERE parm_name='_PAGE_HEADER_LOGO';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Header: Logo Filename', parm_notes='Filename for logo that is located in /images directory for each theme' WHERE parm_name='_PAGE_HEADER_LOGO_FILE';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Header: Make Clear', parm_notes='YES: The site header row is clear (underlying color)\r\nNO: The site header row is colored (styles)' WHERE parm_name='_PAGE_HEADER_CLEAR';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Footer: Make Clear', parm_notes='YES: The site footer row is clear (underlying color)\r\nNO: The site footer row is colored (styles)' WHERE parm_name='_PAGE_FOOTER_CLEAR';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Package Wrapper: Enable', parm_notes='YES: Enable "wrapper" code around phpCOIN for controlling top/left and right/bottom\r\nNO: Use the themes functions for controlling top/left and right/bottom' WHERE parm_name='_PKG_WRAPPER_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Table: Width Of Outmost Table', parm_notes='The width of the outermost table. Must include either percent or pixel signs, % or px' WHERE parm_name='_WIDTH_OUTER_TABLE';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Menu Columns: Percentage Width', parm_notes='The percentage width for each left / right menu column,  without the % sign' WHERE parm_name='_WIDTH_COL_BLOCK';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Menu Columns: Block Pixel Width', parm_notes='The pixel width setting for a menu block displayed within a left-right menu column, without the px sign' WHERE parm_name='_WIDTH_MENU_BLOCK';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Table: Percentage Width Of Non-Module Area', parm_notes='The percentage width of the content area that non-modules output will consume, including % sign' WHERE parm_name='_WIDTH_CONTENT_AREA';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Table: Percentage Width Of Module Area', parm_notes='The percentage width of the content area that modules output will consume, with % sign' WHERE parm_name='_WIDTH_MODULE_AREA';
UPDATE `%PREFIX%parameters` SET parm_group='theme', parm_group_sub='package', parm_desc='Table: Pixel Width For Printing', parm_notes='The pixel width of the outermost table when being printed, excluding px sign' WHERE parm_name='_WIDTH_PRINT_AREA';
UPDATE `%PREFIX%parameters` SET parm_group='user', parm_group_sub='package', parm_desc='Company Info 01: Name', parm_notes='Company name that you want to appear on invoices, and on the "Contact US" page if address display enabled, and on the website footer if the theme enables a site-owner footer' WHERE parm_name='CO_INFO_01_NAME';
UPDATE `%PREFIX%parameters` SET parm_group='user', parm_group_sub='package', parm_desc='Company Info 02: Address Line 01', parm_notes='Street address that you want to appear on invoices, and on the "Contact US" page if address display enabled, and on the website footer if the theme enables a site-owner footer' WHERE parm_name='CO_INFO_02_ADDR_01';
UPDATE `%PREFIX%parameters` SET parm_group='user', parm_group_sub='package', parm_desc='Company Info 03: Address Line 02', parm_notes='Secondary address line or suite number that you want to appear on invoices, and on the "Contact US" page if address display enabled, and on the website footer if the theme enables a site-owner footer' WHERE parm_name='CO_INFO_03_ADDR_02';
UPDATE `%PREFIX%parameters` SET parm_group='user', parm_group_sub='package', parm_desc='Company Info 04: City', parm_notes='City that you want to appear on invoices, and on the "Contact US" page if address display enabled, and on the website footer if the theme enables a site-owner footer' WHERE parm_name='CO_INFO_04_CITY';
UPDATE `%PREFIX%parameters` SET parm_group='user', parm_group_sub='package', parm_desc='Company Info 05: State/Prov', parm_notes='State or Province that you want to appear on invoices, and on the "Contact US" page if address display enabled, and on the website footer if the theme enables a site-owner footer' WHERE parm_name='CO_INFO_05_STATE_PROV';
UPDATE `%PREFIX%parameters` SET parm_group='user', parm_group_sub='package', parm_desc='Company Info 06: Postal Code', parm_notes='Zip or Postal code that you want to appear on invoices, and on the "Contact US" page if address display enabled, and on the website footer if the theme enables a site-owner footer' WHERE parm_name='CO_INFO_06_POSTAL_CODE';
UPDATE `%PREFIX%parameters` SET parm_group='user', parm_group_sub='package', parm_desc='Company Info 07: Country', parm_notes='Country that you want to appear on invoices, and on the "Contact US" page if address display enabled, and on the website footer if the theme enables a site-owner footer' WHERE parm_name='CO_INFO_07_COUNTRY';
UPDATE `%PREFIX%parameters` SET parm_group='user', parm_group_sub='package', parm_desc='Company Info 08: Phone No.', parm_notes='Phone number, if you have one, that you want to appear on invoices and on the "Contact US" page and on the website footer if the theme enables a site-owner footer' WHERE parm_name='CO_INFO_08_PHONE';
UPDATE `%PREFIX%parameters` SET parm_group='user', parm_group_sub='package', parm_desc='Company Info 09: FAX', parm_notes='Fax number, if you have one, that you want to appear on invoices, and on the "Contact US" page if address display enabled, and on the website footer if the theme enables a site-owner footer' WHERE parm_name='CO_INFO_09_FAX';
UPDATE `%PREFIX%parameters` SET parm_group='user', parm_group_sub='package', parm_desc='Company Info 10: Tax Number', parm_notes='If you charge taxes and require that your tax registration number appear on invoices, etc., enter it here' WHERE parm_name='CO_INFO_10_TAXNO';
UPDATE `%PREFIX%parameters` SET parm_group='user', parm_group_sub='package', parm_desc='Company Info 11: Toll Free Number', parm_notes='A toll-free number, if you have one, that you want to appear on invoices, and on the "Contact Us" page if address display enabled, and on the website footer if the theme enables a site-owner footer' WHERE parm_name='CO_INFO_11_TOLL_FREE';
UPDATE `%PREFIX%parameters` SET parm_group='user', parm_group_sub='package', parm_desc='Company Info 12: TagLine', parm_notes='Text of a "tagline" that will appear on invoices, and in the site footer if the theme used supports it' WHERE parm_name='CO_INFO_12_TAGLINE';
UPDATE `%PREFIX%parameters` SET parm_group='user', parm_group_sub='package', parm_desc='Display On Contact Form', parm_notes='YES: The Company Information in this section will be displayed on the "Contact Us" form,as well as used on invoices\r\nNO: The "Contact Us" form will be an email-only form.' WHERE parm_name='DISPLAY_ON_CONTACT_FORM';
UPDATE `%PREFIX%parameters` SET parm_group='user', parm_group_sub='package', parm_desc='Display On Output Footer', parm_notes='YES: The Company Information in this section will be displayed in the footer of every page output by phpCOIN if the theme used supports it.  The built-in themes all support this' WHERE parm_name='DISPLAY_ON_FOOTER';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='downloads', parm_desc='Downloads for logged-in users only', parm_notes='YES: A user must be logged-in in order to access the downloads page\r\nNO: Anyone can access the downloads page.' WHERE parm_name='LIMIT_DOWNLOADS_TO_LOGGED_IN';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='downloads', parm_desc='Show Available Downloads Only', parm_notes='YES: phpCOIN will display only those downloads marked "available"\r\nNO: phpCOIN will display all downloads in the database, but only available downloads will be clickable' WHERE parm_name='HIDE_NOAVAILS';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='downloads', parm_desc='Downloads Root URL', parm_notes='Root URL where downloads are located. The http:// prefix and the trailing slash can be eliminated ~ phpCOIN will auto-append them if necessary.' WHERE parm_name='DLOAD_URL';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='ipn', parm_desc='List: Items Per Page', parm_notes='Number of IPN Log items to display per page in listings' WHERE parm_name='IPN_NUM_DISPLAY';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='ipn', parm_desc='IPN: Send Transaction Ack Email', parm_notes='YES: Send a trans ack email when payment is received\r\nNO: Do not send a trans ack email' WHERE parm_name='IPN_SEND_TRANS_ACK';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='ipn', parm_desc='IPN: Process Incoming Data', parm_notes='If we accept data, do we want to process it also?' WHERE parm_name='IPN_PROCESS_INCOMING';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='ipn', parm_desc='Paypal: Primary Email Address', parm_notes='This is your PayPal Primary Email Address.  Incoming transactions will have this recipient address, to ensure that the transaction was meant for you.  You can have multiple email addresses here separated by spaces, for example:\r\njon@paypal.com john@paypal.com' WHERE parm_name='PAYPAL_RECEIVER_EMAIL';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='ipn', parm_desc='IPN: Select Invoice By Name', parm_notes='YES: If there is no invoice number or email address match, then use the first and last name of the payer to determine the invoice\r\nNO: Use only the supplied invoice number or email address to determine which invoice to pay' WHERE parm_name='IPN_SEARCH_NAME';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='ipn', parm_desc='IPN: Enable', parm_notes='YES: Module is enabled and ready for accept and apply payment notifications\r\nNO: Module is deactivated, all menu buttons/links are automatically hidden, no output from this module will be visible, and no payment notifications will be accepted and applied' WHERE parm_name='IPN_ACCEPT_INCOMING';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='ipn', parm_desc='IPN: Invoice Find Method', parm_notes='If no invoice number is sent with an incoming transaction, this is how ipn determines which invoice to apply the payment to:\r\n0: Highest invoice number, regardless of status\r\n1: Highest invoice number that does not have status PAID\r\n2: Highest invoice number that does not have status PAID, if none found, then return highest invoice num\r\n3: Lowest invoice number that does not have status PAID\r\n4: Lowest invoice number that does not have status PAID, IF none found, then return highest invoice number' WHERE parm_name='IPN_INVOICE_FIND_METHOD';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='ipn', parm_desc='IPN: Allow Transaction Resubmit', parm_notes='Allows you to simulate the transaction being run again.  Doing this will NOT reverse any payments posted, status changes, etc.' WHERE parm_name='IPN_ALLOW_RESUBMIT';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='ipn', parm_desc='IPN: Allow Transaction Delete', parm_notes='Allow IPN transactions to be deleted from the LOG' WHERE parm_name='IPN_ALLOW_DELETE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='ipn', parm_desc='IPN: Received Amount Must Match Invoice', parm_notes='YES: Amount received must match the invoice amount for the payment to be successful\r\nNO: Amount received can be for any amount ~ useful if you receive partial payments' WHERE parm_name='IPN_REQUIRE_AMOUNT_MATCH';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='ipn', parm_desc='PayPal: Enable Text Log', parm_notes='Create a text file to log IPN connection attempts to and from PayPal.' WHERE parm_name='PAYPAL_WRITEDEBUG';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='ipn', parm_desc='PayPal: Name of Text Log', parm_notes='Name of text file to log IPN connection attempts to and from PayPal (Use &#37;TIMESTAMP% to have current timestamp appended)' WHERE parm_name='PAYPAL_DEBUGFILE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='ipn', parm_desc='PayPal: SandBox Seller Email', parm_notes='Sandbox email address of seller, for testing IPN with PayPal' WHERE parm_name='PAYPAL_SBEMAIL';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='email', parm_desc='HTML Email: Enable HTML Incoming', parm_notes='YES: "Contact us" form will send you html email\r\nNO: "Contact Us" form allows plain-text only' WHERE parm_name='INCOMING_EMAIL_AS_HTML';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='todo', parm_desc='List: Items Per Page', parm_notes='The number of ToDo items that are displayed in listing form on a page' WHERE parm_name='IPP_TODO';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='email', parm_desc='Mail Contacts: Show Support On Contact Form', parm_notes='YES: "Support" will be a choice for users on the "Contact Us" form\r\nNO: "Support" will not be an option on the contact form. Useful if you want to enforce that support requests originate via helpdesk rather than a "contact Us" email to support' WHERE parm_name='ENABLE_SUPPORT_ON_CONTACT';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='invoices', parm_desc='Invoice Reminders: No Nag If Credit Balance', parm_notes='YES: A client will not be nagged about an unpaid invoice if their account has a cedit balance\r\nNO: A client will be nagged about an overdue invoice regardless of their account balance' WHERE parm_name='NO_NAG_ON_CREDIT';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='summary', parm_desc='Invoices By Billing Cycle: Show Unused Status', parm_notes='YES: The invoice columnar listing will show a row for each invoice status, whether any invoices have that status or not.\r\nNO: Only statuses that are used on an invoice will be shown' WHERE parm_name='SHOW_EMPTY_INVC_STATUS';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='summary', parm_desc='Invoices By Billing Cycle: $0.00 Totals', parm_notes='YES: Zero value billing cycle totals will display as $0.00\r\nNO: Zero value billing cycle totals will display as a blank space' WHERE parm_name='SHOW_INVC_ZERO_TOTAL';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='ipn', parm_desc='PayPal Emails: Verbose', parm_notes='YES: phpCOIN will display the results of processing of each email message\r\nNO: phpCOIN will only display aggregate results' WHERE parm_name='PAYPAL_AUTO_VERBOSE';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='ipn', parm_desc='PayPal Emails: Enable', parm_notes='YES: The paypal cronjob will connect to a POP or IMAP box and attempt to create invoice payments from any emails found\r\nNO: (obvious)' WHERE parm_name='PAYPAL_AUTO_IMPORT_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='ipn', parm_desc='PayPal Emails: Server', parm_notes='Name of the email server the helpdesk cronjob should connect to' WHERE parm_name='PAYPAL_AUTO_IMPORT_SERVER';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='ipn', parm_desc='PayPal Emails: Protocol', parm_notes='Protocol and port that the paypal cronjob should connect to\r\n"/imap:143" seems to work better than "/pop:110"\r\nYou may also need to try /IMAP/:143/notls or /:110/POP/notls or even other strings, depending on your mailserver' WHERE parm_name='PAYPAL_AUTO_IMPORT_TYPE';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='ipn', parm_desc='PayPal Emails: UserName', parm_notes='The email username that the paypal cronjob will check' WHERE parm_name='PAYPAL_AUTO_IMPORT_USERID';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='ipn', parm_desc='PayPal Emails: Password', parm_notes='Password for the email account that will be checked by the paypal cronjob' WHERE parm_name='PAYPAL_AUTO_IMPORT_PASSWORD';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='ipn', parm_desc='PayPal Emails: Delete Messages', parm_notes='Delete _these_ messages on the mail-server when the paypal cronjob runs' WHERE parm_name='PAYPAL_AUTO_IMPORT_DELETE_MESSAGES';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='ipn', parm_desc='PayPal Emails: Partial Subject String', parm_notes='Emails from PayPal will include this text in the subject line' WHERE parm_name='PAYPAL_AUTO_PARTIAL_SUBJECT';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='ipn', parm_desc='PayPal Emails: Invoice ID String', parm_notes='Emails from PayPal will include this text in the Invoice ID line' WHERE parm_name='PAYPAL_AUTO_INVOICE_ID';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='ipn', parm_desc='PayPal Emails: Transaction ID String', parm_notes='Emails from PayPal will include this text in the Transaction ID line' WHERE parm_name='PAYPAL_AUTO_TRANS_ID';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='ipn', parm_desc='PayPal Emails: Total Amount String', parm_notes='Emails from PayPal will include this text in the Total Amount line' WHERE parm_name='PAYPAL_AUTO_TOTAL_AMT';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='clients', parm_desc='Notes: Visible To Clients', parm_notes='YES: Client can view admin-entered client notes\r\nNO: Client cannot see admin-entered client notes' WHERE parm_name='CLIENT_NOTES_VISIBLE';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='invoices', parm_desc='Invoice AutoCopy: Insert New Terms', parm_notes='YES: phpCOIN will replace the existing terms on auto-copied invoices with whatever the current terms are in lang_config.php\r\nNO: phpCOIN will copy any existing terms on the invoice as-is' WHERE parm_name='INVC_ACOPY_NEW_TERMS';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='package', parm_desc='Display Digits: Tax Percent', parm_notes='How many digits after the decimal place should we display for the tax percentages?' WHERE parm_name='TAX_DISPLAY_DIGITS_PERCENT';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='package', parm_desc='Display Digits: Tax Amount', parm_notes='How many digits after the decimal place should we display for the tax amounts?' WHERE parm_name='TAX_DISPLAY_DIGITS_AMOUNT';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='package', parm_desc='Display Digits: Currency Amounts', parm_notes='How many digits after the decimal place should we display for currency (non-tax) amounts?' WHERE parm_name='CURRENCY_DISPLAY_DIGITS_AMOUNT';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='Display TOS in Iframe', parm_notes='Whether or not to show the TOS in an iframe on the orders page, underneath the "Accept TOS" checkbox' WHERE parm_name='ORDERS_TOS_IN_IFRAME';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='orders', parm_desc='Display AUP in Iframe', parm_notes='Whether or not to show the AUP in an iframe on the orders page, underneath the "Accept AUP" checkbox' WHERE parm_name='ORDERS_AUP_IN_IFRAME';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='summary', parm_desc='Active Product Orders: Sort Order', parm_notes='The sort order for active product orders:\r\n1: Alphabetical by product name or description\r\n2: Reverse alphabetical by product name or description\r\n3: Number of products sold, low to high\r\n4: Number of products sold, high to low\r\n5: Value of products sold, low to high\r\n6: Value of products sold, high to low' WHERE parm_name='SUMMARY_PRODUCTS_ORDER_BY';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='suppliers', parm_desc='Suppliers: Enable', parm_notes='YES: Module is enabled and ready for use\r\nNO: Module is deactivated, all menu buttons/links are automatically hidden, and no output from this module will be visible' WHERE parm_name='SUPPLIERS_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='suppliers', parm_desc='Supplier ID Base-Initial Value Minus 1', parm_notes='The id for the first supplier entered in the system. Supplier ID will be this value plus one' WHERE parm_name='BASE_SUPPLIER_ID';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='suppliers', parm_desc='List: Items Per Page', parm_notes='The number of suppliers that are displayed on a page in listing form' WHERE parm_name='IPP_SUPPLIERS';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='suppliers', parm_desc='List: Items Per Summary', parm_notes='The number of most recent items (bills and email archive messages) that are displayed on a supplier account page' WHERE parm_name='IPL_SUPPLIERS';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='bills', parm_desc='Bill Auto-Copy: Delay', parm_notes='Determines if the auto-copy of recurring bills is delayed until new bill date is within days out setting.' WHERE parm_name='BILL_ACOPY_DELAY_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='bills', parm_desc='Bill Auto-Copy: Days Out to Copy', parm_notes='Determines number of days from current date to auto-copy a recurring bill. Will auto-copy if the new bill date falls within this date range.' WHERE parm_name='BILL_ACOPY_DAYS_OUT';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='bills', parm_desc='Bill Auto Copy: Auto-Update Status', parm_notes='Determines if the auto-update of bill status function is enabled when triggered by cron job or manually by command summary actions menu.' WHERE parm_name='BILL_AUTO_UPDATE_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='cronjobs', parm_group_sub='bills', parm_desc='Bill Auto-Copy: Enable', parm_notes='Determines if the auto-copy of recurring bills function is enabled when triggered by cron job or manually by command summary actions menu.' WHERE parm_name='BILL_AUTO_COPY_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='bills', parm_desc='Bill Due Date: x Days After Create', parm_notes='When a bill is created, phpCOIN will add this many days to the create date in order to auto-calc the due date' WHERE parm_name='BILL_DUE_DAYS_OFFSET';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='bills', parm_desc='Bill Taxes: Tax 01 Enable', parm_notes='YES: Tax 1 will be calculated and displayed.\r\nNO: Tax 1 will NOT be calculated and displayed' WHERE parm_name='BILL_TAX_01_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='bills', parm_desc='Bill Taxes: Tax 02 Enable', parm_notes='YES: Tax 2 will be calculated and displayed.\r\nNO: Tax 2 will NOT be calculated and displayed' WHERE parm_name='BILL_TAX_02_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='bills', parm_desc='Bill Transaction Listing:  Enable Split Listing', parm_notes='YES: The bill transaction listing is split to list charges on top, and then credits below in a separate list\r\nNO: bill transactions appear in a single section one after the other, like a standard statement' WHERE parm_name='BILL_SPLIT_TRANS_LIST_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='bills', parm_desc='Bill Taxes: Tax 01 Label', parm_notes='The text label displayed on bills in place of "Tax 01"' WHERE parm_name='BILL_TAX_01_LABEL';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='bills', parm_desc='Bill Taxes: Tax 02 Label', parm_notes='The text label displayed on bills in place of "Tax 02"' WHERE parm_name='BILL_TAX_02_LABEL';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='bills', parm_desc='Bill Transaction Listing: Show Transactions', parm_notes='If the transactions listing is displayed on lower portion of bill:\r\n0: No transactions displayed\r\n1: Transactions displayed on-screen only\r\n2: Transactions displayed on printed output only\r\n3: Transactions appear on both screen and printed output' WHERE parm_name='BILL_VIEW_SHOW_TRANS';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='bills', parm_desc='Bills: Enable', parm_notes='YES: Module is enabled and ready for use\r\nNO: Module is deactivated, all menu buttons/links are automatically hidden, and no output from this module will be visible' WHERE parm_name='BILLS_ENABLE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='bills', parm_desc='Bill Taxes: Tax 01 Default Rate', parm_notes='The default tax rate percentage value used for this tax during auto-calc. For example: 1.00 is 1 percent' WHERE parm_name='BILL_TAX_01_DEF_VAL';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='bills', parm_desc='Bill Taxes: Tax 02 Default Rate', parm_notes='The default tax rate percentage value used for this tax during auto-calc. For example: 1.00 is 1 percent' WHERE parm_name='BILL_TAX_02_DEF_VAL';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='bills', parm_desc='Bills: Initial Value', parm_notes='Starting point for the first bill entered in the system. Bill ID will be this value plus one.' WHERE parm_name='BASE_BILL_ID';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='summary', parm_desc='Expenses: Enable', parm_notes='YES: Display a table with the number of times each expense appears on a bill, as well as the total value' WHERE parm_name='SUMMARY_BILLS_BY_PRODUCT';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='summary', parm_desc='Expenses: Ignore these items', parm_notes='A pipe-separated list of item codes on bills that should be ignored when building the billed expenses summary.' WHERE parm_name='SUMMARY_BILLS_BY_PRODUCT_IGNORE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='bills', parm_desc='Bill Taxes: Tax By Item', parm_notes='YES: Taxes will be calculated on each item individually\r\nNO: Taxes will be calculated only on the invoice totals' WHERE parm_name='BILL_TAX_BY_ITEM';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='bills', parm_desc='List: Items Per Page', parm_notes='The number of bills that are displayed in listing form on a page.' WHERE parm_name='IPP_BILLS';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='bills', parm_desc='Bill Taxes: Prices Include Taxes', parm_notes='NO: phpCOIN will add applicable taxes to items on bills\r\nYES: phpCOIN assumes that the prices include tax. In this event, taxes will be removed from the items and then recalculated, so the bill can show the amount of taxes included in the prices.' WHERE parm_name='BILL_PRICES_INCLUDE_TAXES';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='ipn', parm_desc='2Checkout: Enable Text Log', parm_notes='Create a text file to log IPN connection attempts to and from 2Checkout.' WHERE parm_name='2CHECKOUT_WRITEDEBUG';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='ipn', parm_desc='2Checkout: Name of Text Log', parm_notes='Name of text file to log IPN connection attempts to and from 2Checkout (Use &#37;TIMESTAMP%to have current timestamp appended)' WHERE parm_name='2CHECKOUT_DEBUGFILE';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='ipn', parm_desc='2Checkout: INS Secret Word', parm_notes='Incoming INS transactions will have this secret word as part of the MD5 hash, to help assure that the data is from 2Checkout' WHERE parm_name='2CHECKOUT_SECRET_WORD';
UPDATE `%PREFIX%parameters` SET parm_group='operation', parm_group_sub='ipn', parm_desc='2Checkout: Vendor ID', parm_notes='Incoming transactions will include your 2co vendor ID, to ensure that the transaction was meant for you' WHERE parm_name='2CHECKOUT_VENDOR_ID';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='summary', parm_desc='Invoiced Products: Ignore these status', parm_notes='A pipe-separated list of invoice statuses that should be ignored when building the invoiced products summary. This list MUST be the $_CCFG[''INV_STATUS''][] array element number, NOT the text of the status' WHERE parm_name='SUMMARY_INVOICES_BY_PRODUCT_STATUS_IGNORE';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='summary', parm_desc='Summary: Current Year Only', parm_notes='YES: Display data on Summary page for this year only\r\nNO: Display data on Summary page for all dates in database' WHERE parm_name='SUMMARY_THIS_YEAR';
UPDATE `%PREFIX%parameters` SET parm_group='layout', parm_group_sub='summary', parm_desc='Expenses: Ignore these status', parm_notes='A pipe-separated list of bill statuses that should be ignored when building the billed expenses summary. This list MUST be the $_CCFG[''BILL_STATUS''][] array element number, NOT the text of the status' WHERE parm_name='SUMMARY_EXPENSES_STATUS_IGNORE';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='orders', parm_desc='Orders: AutoPassword Enable', parm_notes='YES: phpCOIN will display a button that will generate a random password and fill the input boxes when clicked\r\nNO: The user must make up their own password' WHERE parm_name='ENABLE_AUTOPASS_ORDERS';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='clients', parm_desc='Clients: AutoPassword Enable', parm_notes='YES: phpCOIN will display a button that will generate a random password and fill the input boxes when clicked\r\nNO: The user must make up their own password' WHERE parm_name='ENABLE_AUTOPASS_CLIENTS';
UPDATE `%PREFIX%parameters` SET parm_group='enable', parm_group_sub='domains', parm_desc='Domains: AutoPassword Enable', parm_notes='YES: phpCOIN will display a button that will generate a random password and fill the input boxes when clicked\r\nNO: The user must make up their own password' WHERE parm_name='ENABLE_AUTOPASS_DOMAINS';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='clients', parm_desc='Clients: Strongest Auto-Password', parm_notes='YES: An auto-generated password will utilize the full alphanumeric character set and symbols, in the ASCII range 33 to 126\r\nNO: An auto-generated password will utilize only lowercase letters' WHERE parm_name='AUTOPASSWORD_STRENGTH';
UPDATE `%PREFIX%parameters` SET parm_group='ordering', parm_group_sub='orders', parm_desc='Skip Order Confirmation Page', parm_notes='YES: Skip the confirmation screen and send the client straight to paylink\r\nNO: Display the order confirmation page so a client can change order info before processing' WHERE parm_name='SKIP_CONFIRM_SCREEN';
UPDATE `%PREFIX%parameters` SET parm_group='add-ons' WHERE parm_group='common';
UPDATE %PREFIX%versions SET v_ts=%TIMESTAMP%, v_ver='v1.6.0', v_type='Upgrade';