INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'clients', 'I', 'CLIENT_MIN_LEN_PWORD', 'Client Min. Characters for Password', '8', 'Determines the minimum number of characters permitted in password form fields.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common','operation','B','ENABLE_SUPPORT_ON_CONTACT','Show support on Contact form','0','whether or not to enable the "support" address on the contact form');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('automation', 'invoices', 'B', 'NO_NAG_ON_CREDIT', 'Do Not Nag If Credit Balance', '1', 'Whether a client should be nagged for all unpaid invoices, or only if they exceed their prepaid credit balance');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'summary', 'B', 'SHOW_EMPTY_INVC_STATUS', 'Show Unused Invoices Statuses on Summary', '0', 'IF YES, the invoice columnar listing will show a row for each invoice status, whether any invoices have that status or not. If NO, then only statuses that are used on an invoice will be shown');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'summary', 'B', 'SHOW_INVC_ZERO_TOTAL', '$0.00 on Zero Totals or Blank', '1', 'If YES, zero value billing cycle totals will display as $0.00 If NO, zero value billing cycle totals will display as a blank space');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('automation', 'ipn', 'B', 'PAYPAL_AUTO_VERBOSE', 'PayPal Emails: Verbose Progress Display', '1', 'Whether to display the processing of each message, or only the agregate results');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('automation', 'ipn', 'B', 'PAYPAL_AUTO_IMPORT_ENABLE', 'PayPal Emails: Import Enable', '1', 'If "Yes", paypal.php will connect to a POP or IMAP box and attempt to create payments from any paypal messages found.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('automation', 'ipn', 'S', 'PAYPAL_AUTO_IMPORT_SERVER', 'PayPal Emails: Auto-import server', 'mail.%DOMAINNAME%', 'Name of the email server to connect to for auto-importing paypal payment messages.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('automation', 'ipn', 'S', 'PAYPAL_AUTO_IMPORT_TYPE', 'PayPal Emails: Auto-import protocol', ':143/imap/notls', 'Protocol and port to connect. "/:143/imap" seems to work better than "/pop:110". You may also need to try /IMAP/:143/notls or /:110/POP/notls depending on your mailserver');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('automation', 'ipn', 'S', 'PAYPAL_AUTO_IMPORT_USERID', 'PayPal Emails: Auto-import mailbox', 'sales@%DOMAINNAME%', 'The mailbox to connect to for helpdesk auto-import.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('automation', 'ipn', 'S', 'PAYPAL_AUTO_IMPORT_PASSWORD', 'PayPal Emails: Auto-import password', 'password', 'Password for the email box that will be checked automaticaly.');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('automation', 'ipn', 'I', 'PAYPAL_AUTO_IMPORT_DELETE_MESSAGES', 'PayPal Emails: Auto-import delete', '1', 'Delete _these_ messages on the mail-server');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('automation', 'ipn', 'S', 'PAYPAL_AUTO_PARTIAL_SUBJECT', 'PayPal Emails: Partial Subject String', 'Notification of Payment Received', 'Emails from PayPal will include this text in the subject line');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('automation', 'ipn', 'S', 'PAYPAL_AUTO_INVOICE_ID', 'PayPal Emails: Invoice ID String', 'Invoice ID', 'Emails from PayPal will include this text in the Invoice ID line');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('automation', 'ipn', 'S', 'PAYPAL_AUTO_TRANS_ID', 'PayPal Emails: Transaction ID String', 'Transaction ID', 'Emails from PayPal will include this text in the Transaction ID line');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('automation', 'ipn', 'S', 'PAYPAL_AUTO_TOTAL_AMT', 'PayPal Emails: Total Amount String', 'Total Amount', 'Emails from PayPal will include this text in the Total Amount line');
INSERT INTO %PREFIX%parameters (`parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('common', 'clients', 'B', 'CLIENT_NOTES_VISIBLE', 'Notes Visible To Clients', '0', 'Whether or not client notes should be viewable by the client');
DELETE FROM %PREFIX%parameters WHERE parm_name='_PKG_MODE_TEST';
UPDATE %PREFIX%parameters SET parm_type='I', parm_name='HELPDESK_AUTO_IMPORT_DELETE_MESSAGES', parm_desc='Helpdesk: Auto-import delete', parm_notes='Delete _these_ messages on the mail-server' WHERE parm_name='HELPDESK_AUTO_IMPORT_DELETE_IMPORTED_MESSAGES';
UPDATE %PREFIX%domains SET dom_type=(dom_type + 1), dom_status=(dom_status + 1);
UPDATE %PREFIX%versions SET v_ts=%TIMESTAMP%, v_ver='v1.4.0', v_type='Upgrade';