DROP TABLE IF EXISTS %PREFIX%tparameters;
CREATE TABLE %PREFIX%tparameters (parm_id smallint(6) NOT NULL auto_increment, parm_group varchar(10) NOT NULL default 'common', parm_group_sub varchar(10) NOT NULL default 'undefined', parm_type char(1) NOT NULL default 'S', parm_name varchar(50) NOT NULL default '', parm_desc varchar(50) NOT NULL default '', parm_value varchar(100) NOT NULL default '', parm_notes text NOT NULL, PRIMARY KEY (parm_id), UNIQUE KEY parm_name (parm_name)) TYPE=MyISAM COMMENT='Site Parameters Table';
INSERT INTO %PREFIX%tparameters (parm_id, parm_group, parm_group_sub, parm_type, parm_name, parm_desc, parm_value, parm_notes) SELECT DISTINCT parm_id, parm_group, parm_group_sub, parm_type, parm_name, parm_desc, parm_value, parm_notes FROM %PREFIX%parameters;
DROP TABLE IF EXISTS %PREFIX%parameters;
RENAME TABLE %PREFIX%tparameters TO %PREFIX%parameters;
INSERT INTO %PREFIX%parameters (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('', 'common', 'orders', 'I', 'ORDERS_FIELD_REQUIRE_COR', 'Orders Form Field Require Settings- COR', '49184', 'Determines which fields are required (visible) on the orders COR form.');
INSERT INTO %PREFIX%parameters (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('', 'common', 'orders', 'I', 'ORDERS_FIELD_REQUIRE_ORD', 'Orders Form Field Require Settings- Order', '24448', 'Determines which fields are required (visible) on the orders order form. This also effects client editing forms.');
INSERT INTO %PREFIX%parameters (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('', 'common', 'downloads', 'B', 'LIMIT_DOWNLOADS_TO_LOGGED_IN', 'Downloads for logged-in users only', '1', 'If "Yes", a user must be logged-in in order to access the downloads page. If "No", anyone can access the downloads page.');
INSERT INTO %PREFIX%parameters (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('', 'common', 'downloads', 'B', 'HIDE_NOAVAILS', 'Show Available Downloads Only', '1', 'Whether phpCOIN will display all downloads in the database, or only those marked "available"');
INSERT INTO %PREFIX%parameters (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('', 'common', 'orders', 'B', 'ORDER_SHOW_IP', 'Whether or not to show user IP address on order form to deter fraud', '1', 'YES will display the users IP address and a warning when placing a new order. NO will display nothing');
INSERT INTO %PREFIX%parameters (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('', 'automation', 'orders', 'B', 'AUTO_INV_RECUR', 'Invoice: Auto-Recur From Order', '1', '"Yes" will set the invoice as recurring. "No" will set the invoice as NOT recurring (ie: one-time)');
INSERT INTO %PREFIX%parameters (`parm_id`, `parm_group`, `parm_group_sub`, `parm_type`, `parm_name`, `parm_desc`, `parm_value`, `parm_notes`) VALUES ('', 'user', 'package', 'B', 'DISPLAY_ON_FOOTER', 'Display On Output Footer', '1', 'If "Yes", the Company Information in this section will be displayed in the footer of every page output by phpCOIN.');
DELETE FROM %PREFIX%parameters WHERE parm_name='ORDER_AUTO_PAY_INVOICE';
ALTER table %PREFIX%whois MODIFY whois_nomatch varchar(40) NOT NULL default '';
ALTER table %PREFIX%orders_sessions ADD column os_ord_cbpaid tinyint(1) NOT NULL default 0 after os_ord_optfld_05;
ALTER table %PREFIX%orders_sessions ADD column os_ord_cbflag tinyint(1) NOT NULL default 0 after os_ord_optfld_05;
ALTER table %PREFIX%vendors ADD column vendor_use_ipn tinyint(1) NOT NULL default 0 after vendor_url;
UPDATE %PREFIX%versions SET v_ts=%TIMESTAMP%, v_ver='v1.2.5', v_type='Upgrade';